// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateWorkteamOutput {
    /// <p>A <code>Workteam</code> object that describes the updated work team.</p>
    pub workteam: std::option::Option<crate::model::Workteam>,
}
impl UpdateWorkteamOutput {
    /// <p>A <code>Workteam</code> object that describes the updated work team.</p>
    pub fn workteam(&self) -> std::option::Option<&crate::model::Workteam> {
        self.workteam.as_ref()
    }
}
impl std::fmt::Debug for UpdateWorkteamOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateWorkteamOutput");
        formatter.field("workteam", &self.workteam);
        formatter.finish()
    }
}
/// See [`UpdateWorkteamOutput`](crate::output::UpdateWorkteamOutput)
pub mod update_workteam_output {
    /// A builder for [`UpdateWorkteamOutput`](crate::output::UpdateWorkteamOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workteam: std::option::Option<crate::model::Workteam>,
    }
    impl Builder {
        /// <p>A <code>Workteam</code> object that describes the updated work team.</p>
        pub fn workteam(mut self, input: crate::model::Workteam) -> Self {
            self.workteam = Some(input);
            self
        }
        /// <p>A <code>Workteam</code> object that describes the updated work team.</p>
        pub fn set_workteam(mut self, input: std::option::Option<crate::model::Workteam>) -> Self {
            self.workteam = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateWorkteamOutput`](crate::output::UpdateWorkteamOutput)
        pub fn build(self) -> crate::output::UpdateWorkteamOutput {
            crate::output::UpdateWorkteamOutput {
                workteam: self.workteam,
            }
        }
    }
}
impl UpdateWorkteamOutput {
    /// Creates a new builder-style object to manufacture [`UpdateWorkteamOutput`](crate::output::UpdateWorkteamOutput)
    pub fn builder() -> crate::output::update_workteam_output::Builder {
        crate::output::update_workteam_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateWorkforceOutput {
    /// <p>A single private workforce. You can create one private work force in each Amazon Web Services Region. By default, any workforce-related API operation used in a specific region will apply to the workforce created in that region. To learn how to create a private workforce, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html">Create a Private Workforce</a>.</p>
    pub workforce: std::option::Option<crate::model::Workforce>,
}
impl UpdateWorkforceOutput {
    /// <p>A single private workforce. You can create one private work force in each Amazon Web Services Region. By default, any workforce-related API operation used in a specific region will apply to the workforce created in that region. To learn how to create a private workforce, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html">Create a Private Workforce</a>.</p>
    pub fn workforce(&self) -> std::option::Option<&crate::model::Workforce> {
        self.workforce.as_ref()
    }
}
impl std::fmt::Debug for UpdateWorkforceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateWorkforceOutput");
        formatter.field("workforce", &self.workforce);
        formatter.finish()
    }
}
/// See [`UpdateWorkforceOutput`](crate::output::UpdateWorkforceOutput)
pub mod update_workforce_output {
    /// A builder for [`UpdateWorkforceOutput`](crate::output::UpdateWorkforceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workforce: std::option::Option<crate::model::Workforce>,
    }
    impl Builder {
        /// <p>A single private workforce. You can create one private work force in each Amazon Web Services Region. By default, any workforce-related API operation used in a specific region will apply to the workforce created in that region. To learn how to create a private workforce, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html">Create a Private Workforce</a>.</p>
        pub fn workforce(mut self, input: crate::model::Workforce) -> Self {
            self.workforce = Some(input);
            self
        }
        /// <p>A single private workforce. You can create one private work force in each Amazon Web Services Region. By default, any workforce-related API operation used in a specific region will apply to the workforce created in that region. To learn how to create a private workforce, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html">Create a Private Workforce</a>.</p>
        pub fn set_workforce(
            mut self,
            input: std::option::Option<crate::model::Workforce>,
        ) -> Self {
            self.workforce = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateWorkforceOutput`](crate::output::UpdateWorkforceOutput)
        pub fn build(self) -> crate::output::UpdateWorkforceOutput {
            crate::output::UpdateWorkforceOutput {
                workforce: self.workforce,
            }
        }
    }
}
impl UpdateWorkforceOutput {
    /// Creates a new builder-style object to manufacture [`UpdateWorkforceOutput`](crate::output::UpdateWorkforceOutput)
    pub fn builder() -> crate::output::update_workforce_output::Builder {
        crate::output::update_workforce_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateUserProfileOutput {
    /// <p>The user profile Amazon Resource Name (ARN).</p>
    pub user_profile_arn: std::option::Option<std::string::String>,
}
impl UpdateUserProfileOutput {
    /// <p>The user profile Amazon Resource Name (ARN).</p>
    pub fn user_profile_arn(&self) -> std::option::Option<&str> {
        self.user_profile_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateUserProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateUserProfileOutput");
        formatter.field("user_profile_arn", &self.user_profile_arn);
        formatter.finish()
    }
}
/// See [`UpdateUserProfileOutput`](crate::output::UpdateUserProfileOutput)
pub mod update_user_profile_output {
    /// A builder for [`UpdateUserProfileOutput`](crate::output::UpdateUserProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_profile_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user profile Amazon Resource Name (ARN).</p>
        pub fn user_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_profile_arn = Some(input.into());
            self
        }
        /// <p>The user profile Amazon Resource Name (ARN).</p>
        pub fn set_user_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_profile_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateUserProfileOutput`](crate::output::UpdateUserProfileOutput)
        pub fn build(self) -> crate::output::UpdateUserProfileOutput {
            crate::output::UpdateUserProfileOutput {
                user_profile_arn: self.user_profile_arn,
            }
        }
    }
}
impl UpdateUserProfileOutput {
    /// Creates a new builder-style object to manufacture [`UpdateUserProfileOutput`](crate::output::UpdateUserProfileOutput)
    pub fn builder() -> crate::output::update_user_profile_output::Builder {
        crate::output::update_user_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTrialComponentOutput {
    /// <p>The Amazon Resource Name (ARN) of the trial component.</p>
    pub trial_component_arn: std::option::Option<std::string::String>,
}
impl UpdateTrialComponentOutput {
    /// <p>The Amazon Resource Name (ARN) of the trial component.</p>
    pub fn trial_component_arn(&self) -> std::option::Option<&str> {
        self.trial_component_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateTrialComponentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTrialComponentOutput");
        formatter.field("trial_component_arn", &self.trial_component_arn);
        formatter.finish()
    }
}
/// See [`UpdateTrialComponentOutput`](crate::output::UpdateTrialComponentOutput)
pub mod update_trial_component_output {
    /// A builder for [`UpdateTrialComponentOutput`](crate::output::UpdateTrialComponentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trial_component_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the trial component.</p>
        pub fn trial_component_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trial_component_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the trial component.</p>
        pub fn set_trial_component_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.trial_component_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTrialComponentOutput`](crate::output::UpdateTrialComponentOutput)
        pub fn build(self) -> crate::output::UpdateTrialComponentOutput {
            crate::output::UpdateTrialComponentOutput {
                trial_component_arn: self.trial_component_arn,
            }
        }
    }
}
impl UpdateTrialComponentOutput {
    /// Creates a new builder-style object to manufacture [`UpdateTrialComponentOutput`](crate::output::UpdateTrialComponentOutput)
    pub fn builder() -> crate::output::update_trial_component_output::Builder {
        crate::output::update_trial_component_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTrialOutput {
    /// <p>The Amazon Resource Name (ARN) of the trial.</p>
    pub trial_arn: std::option::Option<std::string::String>,
}
impl UpdateTrialOutput {
    /// <p>The Amazon Resource Name (ARN) of the trial.</p>
    pub fn trial_arn(&self) -> std::option::Option<&str> {
        self.trial_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateTrialOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTrialOutput");
        formatter.field("trial_arn", &self.trial_arn);
        formatter.finish()
    }
}
/// See [`UpdateTrialOutput`](crate::output::UpdateTrialOutput)
pub mod update_trial_output {
    /// A builder for [`UpdateTrialOutput`](crate::output::UpdateTrialOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trial_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the trial.</p>
        pub fn trial_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trial_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the trial.</p>
        pub fn set_trial_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trial_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTrialOutput`](crate::output::UpdateTrialOutput)
        pub fn build(self) -> crate::output::UpdateTrialOutput {
            crate::output::UpdateTrialOutput {
                trial_arn: self.trial_arn,
            }
        }
    }
}
impl UpdateTrialOutput {
    /// Creates a new builder-style object to manufacture [`UpdateTrialOutput`](crate::output::UpdateTrialOutput)
    pub fn builder() -> crate::output::update_trial_output::Builder {
        crate::output::update_trial_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTrainingJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the training job.</p>
    pub training_job_arn: std::option::Option<std::string::String>,
}
impl UpdateTrainingJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the training job.</p>
    pub fn training_job_arn(&self) -> std::option::Option<&str> {
        self.training_job_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateTrainingJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTrainingJobOutput");
        formatter.field("training_job_arn", &self.training_job_arn);
        formatter.finish()
    }
}
/// See [`UpdateTrainingJobOutput`](crate::output::UpdateTrainingJobOutput)
pub mod update_training_job_output {
    /// A builder for [`UpdateTrainingJobOutput`](crate::output::UpdateTrainingJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) training_job_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the training job.</p>
        pub fn training_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.training_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the training job.</p>
        pub fn set_training_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.training_job_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTrainingJobOutput`](crate::output::UpdateTrainingJobOutput)
        pub fn build(self) -> crate::output::UpdateTrainingJobOutput {
            crate::output::UpdateTrainingJobOutput {
                training_job_arn: self.training_job_arn,
            }
        }
    }
}
impl UpdateTrainingJobOutput {
    /// Creates a new builder-style object to manufacture [`UpdateTrainingJobOutput`](crate::output::UpdateTrainingJobOutput)
    pub fn builder() -> crate::output::update_training_job_output::Builder {
        crate::output::update_training_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProjectOutput {
    /// <p>The Amazon Resource Name (ARN) of the project.</p>
    pub project_arn: std::option::Option<std::string::String>,
}
impl UpdateProjectOutput {
    /// <p>The Amazon Resource Name (ARN) of the project.</p>
    pub fn project_arn(&self) -> std::option::Option<&str> {
        self.project_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProjectOutput");
        formatter.field("project_arn", &self.project_arn);
        formatter.finish()
    }
}
/// See [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)
pub mod update_project_output {
    /// A builder for [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the project.</p>
        pub fn project_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)
        pub fn build(self) -> crate::output::UpdateProjectOutput {
            crate::output::UpdateProjectOutput {
                project_arn: self.project_arn,
            }
        }
    }
}
impl UpdateProjectOutput {
    /// Creates a new builder-style object to manufacture [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)
    pub fn builder() -> crate::output::update_project_output::Builder {
        crate::output::update_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePipelineExecutionOutput {
    /// <p>The Amazon Resource Name (ARN) of the updated pipeline execution.</p>
    pub pipeline_execution_arn: std::option::Option<std::string::String>,
}
impl UpdatePipelineExecutionOutput {
    /// <p>The Amazon Resource Name (ARN) of the updated pipeline execution.</p>
    pub fn pipeline_execution_arn(&self) -> std::option::Option<&str> {
        self.pipeline_execution_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdatePipelineExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePipelineExecutionOutput");
        formatter.field("pipeline_execution_arn", &self.pipeline_execution_arn);
        formatter.finish()
    }
}
/// See [`UpdatePipelineExecutionOutput`](crate::output::UpdatePipelineExecutionOutput)
pub mod update_pipeline_execution_output {
    /// A builder for [`UpdatePipelineExecutionOutput`](crate::output::UpdatePipelineExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_execution_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the updated pipeline execution.</p>
        pub fn pipeline_execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_execution_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the updated pipeline execution.</p>
        pub fn set_pipeline_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_execution_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePipelineExecutionOutput`](crate::output::UpdatePipelineExecutionOutput)
        pub fn build(self) -> crate::output::UpdatePipelineExecutionOutput {
            crate::output::UpdatePipelineExecutionOutput {
                pipeline_execution_arn: self.pipeline_execution_arn,
            }
        }
    }
}
impl UpdatePipelineExecutionOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePipelineExecutionOutput`](crate::output::UpdatePipelineExecutionOutput)
    pub fn builder() -> crate::output::update_pipeline_execution_output::Builder {
        crate::output::update_pipeline_execution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePipelineOutput {
    /// <p>The Amazon Resource Name (ARN) of the updated pipeline.</p>
    pub pipeline_arn: std::option::Option<std::string::String>,
}
impl UpdatePipelineOutput {
    /// <p>The Amazon Resource Name (ARN) of the updated pipeline.</p>
    pub fn pipeline_arn(&self) -> std::option::Option<&str> {
        self.pipeline_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdatePipelineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePipelineOutput");
        formatter.field("pipeline_arn", &self.pipeline_arn);
        formatter.finish()
    }
}
/// See [`UpdatePipelineOutput`](crate::output::UpdatePipelineOutput)
pub mod update_pipeline_output {
    /// A builder for [`UpdatePipelineOutput`](crate::output::UpdatePipelineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the updated pipeline.</p>
        pub fn pipeline_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the updated pipeline.</p>
        pub fn set_pipeline_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pipeline_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePipelineOutput`](crate::output::UpdatePipelineOutput)
        pub fn build(self) -> crate::output::UpdatePipelineOutput {
            crate::output::UpdatePipelineOutput {
                pipeline_arn: self.pipeline_arn,
            }
        }
    }
}
impl UpdatePipelineOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePipelineOutput`](crate::output::UpdatePipelineOutput)
    pub fn builder() -> crate::output::update_pipeline_output::Builder {
        crate::output::update_pipeline_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateNotebookInstanceLifecycleConfigOutput {}
impl std::fmt::Debug for UpdateNotebookInstanceLifecycleConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateNotebookInstanceLifecycleConfigOutput");
        formatter.finish()
    }
}
/// See [`UpdateNotebookInstanceLifecycleConfigOutput`](crate::output::UpdateNotebookInstanceLifecycleConfigOutput)
pub mod update_notebook_instance_lifecycle_config_output {
    /// A builder for [`UpdateNotebookInstanceLifecycleConfigOutput`](crate::output::UpdateNotebookInstanceLifecycleConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateNotebookInstanceLifecycleConfigOutput`](crate::output::UpdateNotebookInstanceLifecycleConfigOutput)
        pub fn build(self) -> crate::output::UpdateNotebookInstanceLifecycleConfigOutput {
            crate::output::UpdateNotebookInstanceLifecycleConfigOutput {}
        }
    }
}
impl UpdateNotebookInstanceLifecycleConfigOutput {
    /// Creates a new builder-style object to manufacture [`UpdateNotebookInstanceLifecycleConfigOutput`](crate::output::UpdateNotebookInstanceLifecycleConfigOutput)
    pub fn builder() -> crate::output::update_notebook_instance_lifecycle_config_output::Builder {
        crate::output::update_notebook_instance_lifecycle_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateNotebookInstanceOutput {}
impl std::fmt::Debug for UpdateNotebookInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateNotebookInstanceOutput");
        formatter.finish()
    }
}
/// See [`UpdateNotebookInstanceOutput`](crate::output::UpdateNotebookInstanceOutput)
pub mod update_notebook_instance_output {
    /// A builder for [`UpdateNotebookInstanceOutput`](crate::output::UpdateNotebookInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateNotebookInstanceOutput`](crate::output::UpdateNotebookInstanceOutput)
        pub fn build(self) -> crate::output::UpdateNotebookInstanceOutput {
            crate::output::UpdateNotebookInstanceOutput {}
        }
    }
}
impl UpdateNotebookInstanceOutput {
    /// Creates a new builder-style object to manufacture [`UpdateNotebookInstanceOutput`](crate::output::UpdateNotebookInstanceOutput)
    pub fn builder() -> crate::output::update_notebook_instance_output::Builder {
        crate::output::update_notebook_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMonitoringScheduleOutput {
    /// <p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>
    pub monitoring_schedule_arn: std::option::Option<std::string::String>,
}
impl UpdateMonitoringScheduleOutput {
    /// <p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>
    pub fn monitoring_schedule_arn(&self) -> std::option::Option<&str> {
        self.monitoring_schedule_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateMonitoringScheduleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMonitoringScheduleOutput");
        formatter.field("monitoring_schedule_arn", &self.monitoring_schedule_arn);
        formatter.finish()
    }
}
/// See [`UpdateMonitoringScheduleOutput`](crate::output::UpdateMonitoringScheduleOutput)
pub mod update_monitoring_schedule_output {
    /// A builder for [`UpdateMonitoringScheduleOutput`](crate::output::UpdateMonitoringScheduleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) monitoring_schedule_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>
        pub fn monitoring_schedule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.monitoring_schedule_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>
        pub fn set_monitoring_schedule_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.monitoring_schedule_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMonitoringScheduleOutput`](crate::output::UpdateMonitoringScheduleOutput)
        pub fn build(self) -> crate::output::UpdateMonitoringScheduleOutput {
            crate::output::UpdateMonitoringScheduleOutput {
                monitoring_schedule_arn: self.monitoring_schedule_arn,
            }
        }
    }
}
impl UpdateMonitoringScheduleOutput {
    /// Creates a new builder-style object to manufacture [`UpdateMonitoringScheduleOutput`](crate::output::UpdateMonitoringScheduleOutput)
    pub fn builder() -> crate::output::update_monitoring_schedule_output::Builder {
        crate::output::update_monitoring_schedule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateModelPackageOutput {
    /// <p>The Amazon Resource Name (ARN) of the model.</p>
    pub model_package_arn: std::option::Option<std::string::String>,
}
impl UpdateModelPackageOutput {
    /// <p>The Amazon Resource Name (ARN) of the model.</p>
    pub fn model_package_arn(&self) -> std::option::Option<&str> {
        self.model_package_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateModelPackageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateModelPackageOutput");
        formatter.field("model_package_arn", &self.model_package_arn);
        formatter.finish()
    }
}
/// See [`UpdateModelPackageOutput`](crate::output::UpdateModelPackageOutput)
pub mod update_model_package_output {
    /// A builder for [`UpdateModelPackageOutput`](crate::output::UpdateModelPackageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_package_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the model.</p>
        pub fn model_package_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_package_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model.</p>
        pub fn set_model_package_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_package_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateModelPackageOutput`](crate::output::UpdateModelPackageOutput)
        pub fn build(self) -> crate::output::UpdateModelPackageOutput {
            crate::output::UpdateModelPackageOutput {
                model_package_arn: self.model_package_arn,
            }
        }
    }
}
impl UpdateModelPackageOutput {
    /// Creates a new builder-style object to manufacture [`UpdateModelPackageOutput`](crate::output::UpdateModelPackageOutput)
    pub fn builder() -> crate::output::update_model_package_output::Builder {
        crate::output::update_model_package_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateImageOutput {
    /// <p>The Amazon Resource Name (ARN) of the image.</p>
    pub image_arn: std::option::Option<std::string::String>,
}
impl UpdateImageOutput {
    /// <p>The Amazon Resource Name (ARN) of the image.</p>
    pub fn image_arn(&self) -> std::option::Option<&str> {
        self.image_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateImageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateImageOutput");
        formatter.field("image_arn", &self.image_arn);
        formatter.finish()
    }
}
/// See [`UpdateImageOutput`](crate::output::UpdateImageOutput)
pub mod update_image_output {
    /// A builder for [`UpdateImageOutput`](crate::output::UpdateImageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the image.</p>
        pub fn image_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image.</p>
        pub fn set_image_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateImageOutput`](crate::output::UpdateImageOutput)
        pub fn build(self) -> crate::output::UpdateImageOutput {
            crate::output::UpdateImageOutput {
                image_arn: self.image_arn,
            }
        }
    }
}
impl UpdateImageOutput {
    /// Creates a new builder-style object to manufacture [`UpdateImageOutput`](crate::output::UpdateImageOutput)
    pub fn builder() -> crate::output::update_image_output::Builder {
        crate::output::update_image_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateExperimentOutput {
    /// <p>The Amazon Resource Name (ARN) of the experiment.</p>
    pub experiment_arn: std::option::Option<std::string::String>,
}
impl UpdateExperimentOutput {
    /// <p>The Amazon Resource Name (ARN) of the experiment.</p>
    pub fn experiment_arn(&self) -> std::option::Option<&str> {
        self.experiment_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateExperimentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateExperimentOutput");
        formatter.field("experiment_arn", &self.experiment_arn);
        formatter.finish()
    }
}
/// See [`UpdateExperimentOutput`](crate::output::UpdateExperimentOutput)
pub mod update_experiment_output {
    /// A builder for [`UpdateExperimentOutput`](crate::output::UpdateExperimentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) experiment_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the experiment.</p>
        pub fn experiment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.experiment_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the experiment.</p>
        pub fn set_experiment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.experiment_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateExperimentOutput`](crate::output::UpdateExperimentOutput)
        pub fn build(self) -> crate::output::UpdateExperimentOutput {
            crate::output::UpdateExperimentOutput {
                experiment_arn: self.experiment_arn,
            }
        }
    }
}
impl UpdateExperimentOutput {
    /// Creates a new builder-style object to manufacture [`UpdateExperimentOutput`](crate::output::UpdateExperimentOutput)
    pub fn builder() -> crate::output::update_experiment_output::Builder {
        crate::output::update_experiment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEndpointWeightsAndCapacitiesOutput {
    /// <p>The Amazon Resource Name (ARN) of the updated endpoint.</p>
    pub endpoint_arn: std::option::Option<std::string::String>,
}
impl UpdateEndpointWeightsAndCapacitiesOutput {
    /// <p>The Amazon Resource Name (ARN) of the updated endpoint.</p>
    pub fn endpoint_arn(&self) -> std::option::Option<&str> {
        self.endpoint_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateEndpointWeightsAndCapacitiesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEndpointWeightsAndCapacitiesOutput");
        formatter.field("endpoint_arn", &self.endpoint_arn);
        formatter.finish()
    }
}
/// See [`UpdateEndpointWeightsAndCapacitiesOutput`](crate::output::UpdateEndpointWeightsAndCapacitiesOutput)
pub mod update_endpoint_weights_and_capacities_output {
    /// A builder for [`UpdateEndpointWeightsAndCapacitiesOutput`](crate::output::UpdateEndpointWeightsAndCapacitiesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the updated endpoint.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the updated endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEndpointWeightsAndCapacitiesOutput`](crate::output::UpdateEndpointWeightsAndCapacitiesOutput)
        pub fn build(self) -> crate::output::UpdateEndpointWeightsAndCapacitiesOutput {
            crate::output::UpdateEndpointWeightsAndCapacitiesOutput {
                endpoint_arn: self.endpoint_arn,
            }
        }
    }
}
impl UpdateEndpointWeightsAndCapacitiesOutput {
    /// Creates a new builder-style object to manufacture [`UpdateEndpointWeightsAndCapacitiesOutput`](crate::output::UpdateEndpointWeightsAndCapacitiesOutput)
    pub fn builder() -> crate::output::update_endpoint_weights_and_capacities_output::Builder {
        crate::output::update_endpoint_weights_and_capacities_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEndpointOutput {
    /// <p>The Amazon Resource Name (ARN) of the endpoint.</p>
    pub endpoint_arn: std::option::Option<std::string::String>,
}
impl UpdateEndpointOutput {
    /// <p>The Amazon Resource Name (ARN) of the endpoint.</p>
    pub fn endpoint_arn(&self) -> std::option::Option<&str> {
        self.endpoint_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEndpointOutput");
        formatter.field("endpoint_arn", &self.endpoint_arn);
        formatter.finish()
    }
}
/// See [`UpdateEndpointOutput`](crate::output::UpdateEndpointOutput)
pub mod update_endpoint_output {
    /// A builder for [`UpdateEndpointOutput`](crate::output::UpdateEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the endpoint.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEndpointOutput`](crate::output::UpdateEndpointOutput)
        pub fn build(self) -> crate::output::UpdateEndpointOutput {
            crate::output::UpdateEndpointOutput {
                endpoint_arn: self.endpoint_arn,
            }
        }
    }
}
impl UpdateEndpointOutput {
    /// Creates a new builder-style object to manufacture [`UpdateEndpointOutput`](crate::output::UpdateEndpointOutput)
    pub fn builder() -> crate::output::update_endpoint_output::Builder {
        crate::output::update_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDomainOutput {
    /// <p>The Amazon Resource Name (ARN) of the domain.</p>
    pub domain_arn: std::option::Option<std::string::String>,
}
impl UpdateDomainOutput {
    /// <p>The Amazon Resource Name (ARN) of the domain.</p>
    pub fn domain_arn(&self) -> std::option::Option<&str> {
        self.domain_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDomainOutput");
        formatter.field("domain_arn", &self.domain_arn);
        formatter.finish()
    }
}
/// See [`UpdateDomainOutput`](crate::output::UpdateDomainOutput)
pub mod update_domain_output {
    /// A builder for [`UpdateDomainOutput`](crate::output::UpdateDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the domain.</p>
        pub fn domain_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the domain.</p>
        pub fn set_domain_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDomainOutput`](crate::output::UpdateDomainOutput)
        pub fn build(self) -> crate::output::UpdateDomainOutput {
            crate::output::UpdateDomainOutput {
                domain_arn: self.domain_arn,
            }
        }
    }
}
impl UpdateDomainOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDomainOutput`](crate::output::UpdateDomainOutput)
    pub fn builder() -> crate::output::update_domain_output::Builder {
        crate::output::update_domain_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDevicesOutput {}
impl std::fmt::Debug for UpdateDevicesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDevicesOutput");
        formatter.finish()
    }
}
/// See [`UpdateDevicesOutput`](crate::output::UpdateDevicesOutput)
pub mod update_devices_output {
    /// A builder for [`UpdateDevicesOutput`](crate::output::UpdateDevicesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateDevicesOutput`](crate::output::UpdateDevicesOutput)
        pub fn build(self) -> crate::output::UpdateDevicesOutput {
            crate::output::UpdateDevicesOutput {}
        }
    }
}
impl UpdateDevicesOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDevicesOutput`](crate::output::UpdateDevicesOutput)
    pub fn builder() -> crate::output::update_devices_output::Builder {
        crate::output::update_devices_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDeviceFleetOutput {}
impl std::fmt::Debug for UpdateDeviceFleetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDeviceFleetOutput");
        formatter.finish()
    }
}
/// See [`UpdateDeviceFleetOutput`](crate::output::UpdateDeviceFleetOutput)
pub mod update_device_fleet_output {
    /// A builder for [`UpdateDeviceFleetOutput`](crate::output::UpdateDeviceFleetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateDeviceFleetOutput`](crate::output::UpdateDeviceFleetOutput)
        pub fn build(self) -> crate::output::UpdateDeviceFleetOutput {
            crate::output::UpdateDeviceFleetOutput {}
        }
    }
}
impl UpdateDeviceFleetOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDeviceFleetOutput`](crate::output::UpdateDeviceFleetOutput)
    pub fn builder() -> crate::output::update_device_fleet_output::Builder {
        crate::output::update_device_fleet_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateContextOutput {
    /// <p>The Amazon Resource Name (ARN) of the context.</p>
    pub context_arn: std::option::Option<std::string::String>,
}
impl UpdateContextOutput {
    /// <p>The Amazon Resource Name (ARN) of the context.</p>
    pub fn context_arn(&self) -> std::option::Option<&str> {
        self.context_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateContextOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateContextOutput");
        formatter.field("context_arn", &self.context_arn);
        formatter.finish()
    }
}
/// See [`UpdateContextOutput`](crate::output::UpdateContextOutput)
pub mod update_context_output {
    /// A builder for [`UpdateContextOutput`](crate::output::UpdateContextOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) context_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the context.</p>
        pub fn context_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.context_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the context.</p>
        pub fn set_context_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.context_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateContextOutput`](crate::output::UpdateContextOutput)
        pub fn build(self) -> crate::output::UpdateContextOutput {
            crate::output::UpdateContextOutput {
                context_arn: self.context_arn,
            }
        }
    }
}
impl UpdateContextOutput {
    /// Creates a new builder-style object to manufacture [`UpdateContextOutput`](crate::output::UpdateContextOutput)
    pub fn builder() -> crate::output::update_context_output::Builder {
        crate::output::update_context_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCodeRepositoryOutput {
    /// <p>The ARN of the Git repository.</p>
    pub code_repository_arn: std::option::Option<std::string::String>,
}
impl UpdateCodeRepositoryOutput {
    /// <p>The ARN of the Git repository.</p>
    pub fn code_repository_arn(&self) -> std::option::Option<&str> {
        self.code_repository_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateCodeRepositoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCodeRepositoryOutput");
        formatter.field("code_repository_arn", &self.code_repository_arn);
        formatter.finish()
    }
}
/// See [`UpdateCodeRepositoryOutput`](crate::output::UpdateCodeRepositoryOutput)
pub mod update_code_repository_output {
    /// A builder for [`UpdateCodeRepositoryOutput`](crate::output::UpdateCodeRepositoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code_repository_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the Git repository.</p>
        pub fn code_repository_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_repository_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Git repository.</p>
        pub fn set_code_repository_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.code_repository_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCodeRepositoryOutput`](crate::output::UpdateCodeRepositoryOutput)
        pub fn build(self) -> crate::output::UpdateCodeRepositoryOutput {
            crate::output::UpdateCodeRepositoryOutput {
                code_repository_arn: self.code_repository_arn,
            }
        }
    }
}
impl UpdateCodeRepositoryOutput {
    /// Creates a new builder-style object to manufacture [`UpdateCodeRepositoryOutput`](crate::output::UpdateCodeRepositoryOutput)
    pub fn builder() -> crate::output::update_code_repository_output::Builder {
        crate::output::update_code_repository_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateArtifactOutput {
    /// <p>The Amazon Resource Name (ARN) of the artifact.</p>
    pub artifact_arn: std::option::Option<std::string::String>,
}
impl UpdateArtifactOutput {
    /// <p>The Amazon Resource Name (ARN) of the artifact.</p>
    pub fn artifact_arn(&self) -> std::option::Option<&str> {
        self.artifact_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateArtifactOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateArtifactOutput");
        formatter.field("artifact_arn", &self.artifact_arn);
        formatter.finish()
    }
}
/// See [`UpdateArtifactOutput`](crate::output::UpdateArtifactOutput)
pub mod update_artifact_output {
    /// A builder for [`UpdateArtifactOutput`](crate::output::UpdateArtifactOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) artifact_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the artifact.</p>
        pub fn artifact_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.artifact_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the artifact.</p>
        pub fn set_artifact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.artifact_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateArtifactOutput`](crate::output::UpdateArtifactOutput)
        pub fn build(self) -> crate::output::UpdateArtifactOutput {
            crate::output::UpdateArtifactOutput {
                artifact_arn: self.artifact_arn,
            }
        }
    }
}
impl UpdateArtifactOutput {
    /// Creates a new builder-style object to manufacture [`UpdateArtifactOutput`](crate::output::UpdateArtifactOutput)
    pub fn builder() -> crate::output::update_artifact_output::Builder {
        crate::output::update_artifact_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAppImageConfigOutput {
    /// <p>The Amazon Resource Name (ARN) for the AppImageConfig.</p>
    pub app_image_config_arn: std::option::Option<std::string::String>,
}
impl UpdateAppImageConfigOutput {
    /// <p>The Amazon Resource Name (ARN) for the AppImageConfig.</p>
    pub fn app_image_config_arn(&self) -> std::option::Option<&str> {
        self.app_image_config_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateAppImageConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAppImageConfigOutput");
        formatter.field("app_image_config_arn", &self.app_image_config_arn);
        formatter.finish()
    }
}
/// See [`UpdateAppImageConfigOutput`](crate::output::UpdateAppImageConfigOutput)
pub mod update_app_image_config_output {
    /// A builder for [`UpdateAppImageConfigOutput`](crate::output::UpdateAppImageConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_image_config_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the AppImageConfig.</p>
        pub fn app_image_config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_image_config_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the AppImageConfig.</p>
        pub fn set_app_image_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_image_config_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAppImageConfigOutput`](crate::output::UpdateAppImageConfigOutput)
        pub fn build(self) -> crate::output::UpdateAppImageConfigOutput {
            crate::output::UpdateAppImageConfigOutput {
                app_image_config_arn: self.app_image_config_arn,
            }
        }
    }
}
impl UpdateAppImageConfigOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAppImageConfigOutput`](crate::output::UpdateAppImageConfigOutput)
    pub fn builder() -> crate::output::update_app_image_config_output::Builder {
        crate::output::update_app_image_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateActionOutput {
    /// <p>The Amazon Resource Name (ARN) of the action.</p>
    pub action_arn: std::option::Option<std::string::String>,
}
impl UpdateActionOutput {
    /// <p>The Amazon Resource Name (ARN) of the action.</p>
    pub fn action_arn(&self) -> std::option::Option<&str> {
        self.action_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateActionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateActionOutput");
        formatter.field("action_arn", &self.action_arn);
        formatter.finish()
    }
}
/// See [`UpdateActionOutput`](crate::output::UpdateActionOutput)
pub mod update_action_output {
    /// A builder for [`UpdateActionOutput`](crate::output::UpdateActionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the action.</p>
        pub fn action_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the action.</p>
        pub fn set_action_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateActionOutput`](crate::output::UpdateActionOutput)
        pub fn build(self) -> crate::output::UpdateActionOutput {
            crate::output::UpdateActionOutput {
                action_arn: self.action_arn,
            }
        }
    }
}
impl UpdateActionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateActionOutput`](crate::output::UpdateActionOutput)
    pub fn builder() -> crate::output::update_action_output::Builder {
        crate::output::update_action_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopTransformJobOutput {}
impl std::fmt::Debug for StopTransformJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopTransformJobOutput");
        formatter.finish()
    }
}
/// See [`StopTransformJobOutput`](crate::output::StopTransformJobOutput)
pub mod stop_transform_job_output {
    /// A builder for [`StopTransformJobOutput`](crate::output::StopTransformJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopTransformJobOutput`](crate::output::StopTransformJobOutput)
        pub fn build(self) -> crate::output::StopTransformJobOutput {
            crate::output::StopTransformJobOutput {}
        }
    }
}
impl StopTransformJobOutput {
    /// Creates a new builder-style object to manufacture [`StopTransformJobOutput`](crate::output::StopTransformJobOutput)
    pub fn builder() -> crate::output::stop_transform_job_output::Builder {
        crate::output::stop_transform_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopTrainingJobOutput {}
impl std::fmt::Debug for StopTrainingJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopTrainingJobOutput");
        formatter.finish()
    }
}
/// See [`StopTrainingJobOutput`](crate::output::StopTrainingJobOutput)
pub mod stop_training_job_output {
    /// A builder for [`StopTrainingJobOutput`](crate::output::StopTrainingJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopTrainingJobOutput`](crate::output::StopTrainingJobOutput)
        pub fn build(self) -> crate::output::StopTrainingJobOutput {
            crate::output::StopTrainingJobOutput {}
        }
    }
}
impl StopTrainingJobOutput {
    /// Creates a new builder-style object to manufacture [`StopTrainingJobOutput`](crate::output::StopTrainingJobOutput)
    pub fn builder() -> crate::output::stop_training_job_output::Builder {
        crate::output::stop_training_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopProcessingJobOutput {}
impl std::fmt::Debug for StopProcessingJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopProcessingJobOutput");
        formatter.finish()
    }
}
/// See [`StopProcessingJobOutput`](crate::output::StopProcessingJobOutput)
pub mod stop_processing_job_output {
    /// A builder for [`StopProcessingJobOutput`](crate::output::StopProcessingJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopProcessingJobOutput`](crate::output::StopProcessingJobOutput)
        pub fn build(self) -> crate::output::StopProcessingJobOutput {
            crate::output::StopProcessingJobOutput {}
        }
    }
}
impl StopProcessingJobOutput {
    /// Creates a new builder-style object to manufacture [`StopProcessingJobOutput`](crate::output::StopProcessingJobOutput)
    pub fn builder() -> crate::output::stop_processing_job_output::Builder {
        crate::output::stop_processing_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopPipelineExecutionOutput {
    /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
    pub pipeline_execution_arn: std::option::Option<std::string::String>,
}
impl StopPipelineExecutionOutput {
    /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
    pub fn pipeline_execution_arn(&self) -> std::option::Option<&str> {
        self.pipeline_execution_arn.as_deref()
    }
}
impl std::fmt::Debug for StopPipelineExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopPipelineExecutionOutput");
        formatter.field("pipeline_execution_arn", &self.pipeline_execution_arn);
        formatter.finish()
    }
}
/// See [`StopPipelineExecutionOutput`](crate::output::StopPipelineExecutionOutput)
pub mod stop_pipeline_execution_output {
    /// A builder for [`StopPipelineExecutionOutput`](crate::output::StopPipelineExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_execution_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
        pub fn pipeline_execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_execution_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
        pub fn set_pipeline_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_execution_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StopPipelineExecutionOutput`](crate::output::StopPipelineExecutionOutput)
        pub fn build(self) -> crate::output::StopPipelineExecutionOutput {
            crate::output::StopPipelineExecutionOutput {
                pipeline_execution_arn: self.pipeline_execution_arn,
            }
        }
    }
}
impl StopPipelineExecutionOutput {
    /// Creates a new builder-style object to manufacture [`StopPipelineExecutionOutput`](crate::output::StopPipelineExecutionOutput)
    pub fn builder() -> crate::output::stop_pipeline_execution_output::Builder {
        crate::output::stop_pipeline_execution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopNotebookInstanceOutput {}
impl std::fmt::Debug for StopNotebookInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopNotebookInstanceOutput");
        formatter.finish()
    }
}
/// See [`StopNotebookInstanceOutput`](crate::output::StopNotebookInstanceOutput)
pub mod stop_notebook_instance_output {
    /// A builder for [`StopNotebookInstanceOutput`](crate::output::StopNotebookInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopNotebookInstanceOutput`](crate::output::StopNotebookInstanceOutput)
        pub fn build(self) -> crate::output::StopNotebookInstanceOutput {
            crate::output::StopNotebookInstanceOutput {}
        }
    }
}
impl StopNotebookInstanceOutput {
    /// Creates a new builder-style object to manufacture [`StopNotebookInstanceOutput`](crate::output::StopNotebookInstanceOutput)
    pub fn builder() -> crate::output::stop_notebook_instance_output::Builder {
        crate::output::stop_notebook_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopMonitoringScheduleOutput {}
impl std::fmt::Debug for StopMonitoringScheduleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopMonitoringScheduleOutput");
        formatter.finish()
    }
}
/// See [`StopMonitoringScheduleOutput`](crate::output::StopMonitoringScheduleOutput)
pub mod stop_monitoring_schedule_output {
    /// A builder for [`StopMonitoringScheduleOutput`](crate::output::StopMonitoringScheduleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopMonitoringScheduleOutput`](crate::output::StopMonitoringScheduleOutput)
        pub fn build(self) -> crate::output::StopMonitoringScheduleOutput {
            crate::output::StopMonitoringScheduleOutput {}
        }
    }
}
impl StopMonitoringScheduleOutput {
    /// Creates a new builder-style object to manufacture [`StopMonitoringScheduleOutput`](crate::output::StopMonitoringScheduleOutput)
    pub fn builder() -> crate::output::stop_monitoring_schedule_output::Builder {
        crate::output::stop_monitoring_schedule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopLabelingJobOutput {}
impl std::fmt::Debug for StopLabelingJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopLabelingJobOutput");
        formatter.finish()
    }
}
/// See [`StopLabelingJobOutput`](crate::output::StopLabelingJobOutput)
pub mod stop_labeling_job_output {
    /// A builder for [`StopLabelingJobOutput`](crate::output::StopLabelingJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopLabelingJobOutput`](crate::output::StopLabelingJobOutput)
        pub fn build(self) -> crate::output::StopLabelingJobOutput {
            crate::output::StopLabelingJobOutput {}
        }
    }
}
impl StopLabelingJobOutput {
    /// Creates a new builder-style object to manufacture [`StopLabelingJobOutput`](crate::output::StopLabelingJobOutput)
    pub fn builder() -> crate::output::stop_labeling_job_output::Builder {
        crate::output::stop_labeling_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopInferenceRecommendationsJobOutput {}
impl std::fmt::Debug for StopInferenceRecommendationsJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopInferenceRecommendationsJobOutput");
        formatter.finish()
    }
}
/// See [`StopInferenceRecommendationsJobOutput`](crate::output::StopInferenceRecommendationsJobOutput)
pub mod stop_inference_recommendations_job_output {
    /// A builder for [`StopInferenceRecommendationsJobOutput`](crate::output::StopInferenceRecommendationsJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopInferenceRecommendationsJobOutput`](crate::output::StopInferenceRecommendationsJobOutput)
        pub fn build(self) -> crate::output::StopInferenceRecommendationsJobOutput {
            crate::output::StopInferenceRecommendationsJobOutput {}
        }
    }
}
impl StopInferenceRecommendationsJobOutput {
    /// Creates a new builder-style object to manufacture [`StopInferenceRecommendationsJobOutput`](crate::output::StopInferenceRecommendationsJobOutput)
    pub fn builder() -> crate::output::stop_inference_recommendations_job_output::Builder {
        crate::output::stop_inference_recommendations_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopHyperParameterTuningJobOutput {}
impl std::fmt::Debug for StopHyperParameterTuningJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopHyperParameterTuningJobOutput");
        formatter.finish()
    }
}
/// See [`StopHyperParameterTuningJobOutput`](crate::output::StopHyperParameterTuningJobOutput)
pub mod stop_hyper_parameter_tuning_job_output {
    /// A builder for [`StopHyperParameterTuningJobOutput`](crate::output::StopHyperParameterTuningJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopHyperParameterTuningJobOutput`](crate::output::StopHyperParameterTuningJobOutput)
        pub fn build(self) -> crate::output::StopHyperParameterTuningJobOutput {
            crate::output::StopHyperParameterTuningJobOutput {}
        }
    }
}
impl StopHyperParameterTuningJobOutput {
    /// Creates a new builder-style object to manufacture [`StopHyperParameterTuningJobOutput`](crate::output::StopHyperParameterTuningJobOutput)
    pub fn builder() -> crate::output::stop_hyper_parameter_tuning_job_output::Builder {
        crate::output::stop_hyper_parameter_tuning_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopEdgePackagingJobOutput {}
impl std::fmt::Debug for StopEdgePackagingJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopEdgePackagingJobOutput");
        formatter.finish()
    }
}
/// See [`StopEdgePackagingJobOutput`](crate::output::StopEdgePackagingJobOutput)
pub mod stop_edge_packaging_job_output {
    /// A builder for [`StopEdgePackagingJobOutput`](crate::output::StopEdgePackagingJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopEdgePackagingJobOutput`](crate::output::StopEdgePackagingJobOutput)
        pub fn build(self) -> crate::output::StopEdgePackagingJobOutput {
            crate::output::StopEdgePackagingJobOutput {}
        }
    }
}
impl StopEdgePackagingJobOutput {
    /// Creates a new builder-style object to manufacture [`StopEdgePackagingJobOutput`](crate::output::StopEdgePackagingJobOutput)
    pub fn builder() -> crate::output::stop_edge_packaging_job_output::Builder {
        crate::output::stop_edge_packaging_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopCompilationJobOutput {}
impl std::fmt::Debug for StopCompilationJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopCompilationJobOutput");
        formatter.finish()
    }
}
/// See [`StopCompilationJobOutput`](crate::output::StopCompilationJobOutput)
pub mod stop_compilation_job_output {
    /// A builder for [`StopCompilationJobOutput`](crate::output::StopCompilationJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopCompilationJobOutput`](crate::output::StopCompilationJobOutput)
        pub fn build(self) -> crate::output::StopCompilationJobOutput {
            crate::output::StopCompilationJobOutput {}
        }
    }
}
impl StopCompilationJobOutput {
    /// Creates a new builder-style object to manufacture [`StopCompilationJobOutput`](crate::output::StopCompilationJobOutput)
    pub fn builder() -> crate::output::stop_compilation_job_output::Builder {
        crate::output::stop_compilation_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopAutoMlJobOutput {}
impl std::fmt::Debug for StopAutoMlJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopAutoMlJobOutput");
        formatter.finish()
    }
}
/// See [`StopAutoMlJobOutput`](crate::output::StopAutoMlJobOutput)
pub mod stop_auto_ml_job_output {
    /// A builder for [`StopAutoMlJobOutput`](crate::output::StopAutoMlJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopAutoMlJobOutput`](crate::output::StopAutoMlJobOutput)
        pub fn build(self) -> crate::output::StopAutoMlJobOutput {
            crate::output::StopAutoMlJobOutput {}
        }
    }
}
impl StopAutoMlJobOutput {
    /// Creates a new builder-style object to manufacture [`StopAutoMlJobOutput`](crate::output::StopAutoMlJobOutput)
    pub fn builder() -> crate::output::stop_auto_ml_job_output::Builder {
        crate::output::stop_auto_ml_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartPipelineExecutionOutput {
    /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
    pub pipeline_execution_arn: std::option::Option<std::string::String>,
}
impl StartPipelineExecutionOutput {
    /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
    pub fn pipeline_execution_arn(&self) -> std::option::Option<&str> {
        self.pipeline_execution_arn.as_deref()
    }
}
impl std::fmt::Debug for StartPipelineExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartPipelineExecutionOutput");
        formatter.field("pipeline_execution_arn", &self.pipeline_execution_arn);
        formatter.finish()
    }
}
/// See [`StartPipelineExecutionOutput`](crate::output::StartPipelineExecutionOutput)
pub mod start_pipeline_execution_output {
    /// A builder for [`StartPipelineExecutionOutput`](crate::output::StartPipelineExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_execution_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
        pub fn pipeline_execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_execution_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
        pub fn set_pipeline_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_execution_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StartPipelineExecutionOutput`](crate::output::StartPipelineExecutionOutput)
        pub fn build(self) -> crate::output::StartPipelineExecutionOutput {
            crate::output::StartPipelineExecutionOutput {
                pipeline_execution_arn: self.pipeline_execution_arn,
            }
        }
    }
}
impl StartPipelineExecutionOutput {
    /// Creates a new builder-style object to manufacture [`StartPipelineExecutionOutput`](crate::output::StartPipelineExecutionOutput)
    pub fn builder() -> crate::output::start_pipeline_execution_output::Builder {
        crate::output::start_pipeline_execution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartNotebookInstanceOutput {}
impl std::fmt::Debug for StartNotebookInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartNotebookInstanceOutput");
        formatter.finish()
    }
}
/// See [`StartNotebookInstanceOutput`](crate::output::StartNotebookInstanceOutput)
pub mod start_notebook_instance_output {
    /// A builder for [`StartNotebookInstanceOutput`](crate::output::StartNotebookInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StartNotebookInstanceOutput`](crate::output::StartNotebookInstanceOutput)
        pub fn build(self) -> crate::output::StartNotebookInstanceOutput {
            crate::output::StartNotebookInstanceOutput {}
        }
    }
}
impl StartNotebookInstanceOutput {
    /// Creates a new builder-style object to manufacture [`StartNotebookInstanceOutput`](crate::output::StartNotebookInstanceOutput)
    pub fn builder() -> crate::output::start_notebook_instance_output::Builder {
        crate::output::start_notebook_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartMonitoringScheduleOutput {}
impl std::fmt::Debug for StartMonitoringScheduleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartMonitoringScheduleOutput");
        formatter.finish()
    }
}
/// See [`StartMonitoringScheduleOutput`](crate::output::StartMonitoringScheduleOutput)
pub mod start_monitoring_schedule_output {
    /// A builder for [`StartMonitoringScheduleOutput`](crate::output::StartMonitoringScheduleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StartMonitoringScheduleOutput`](crate::output::StartMonitoringScheduleOutput)
        pub fn build(self) -> crate::output::StartMonitoringScheduleOutput {
            crate::output::StartMonitoringScheduleOutput {}
        }
    }
}
impl StartMonitoringScheduleOutput {
    /// Creates a new builder-style object to manufacture [`StartMonitoringScheduleOutput`](crate::output::StartMonitoringScheduleOutput)
    pub fn builder() -> crate::output::start_monitoring_schedule_output::Builder {
        crate::output::start_monitoring_schedule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendPipelineExecutionStepSuccessOutput {
    /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
    pub pipeline_execution_arn: std::option::Option<std::string::String>,
}
impl SendPipelineExecutionStepSuccessOutput {
    /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
    pub fn pipeline_execution_arn(&self) -> std::option::Option<&str> {
        self.pipeline_execution_arn.as_deref()
    }
}
impl std::fmt::Debug for SendPipelineExecutionStepSuccessOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendPipelineExecutionStepSuccessOutput");
        formatter.field("pipeline_execution_arn", &self.pipeline_execution_arn);
        formatter.finish()
    }
}
/// See [`SendPipelineExecutionStepSuccessOutput`](crate::output::SendPipelineExecutionStepSuccessOutput)
pub mod send_pipeline_execution_step_success_output {
    /// A builder for [`SendPipelineExecutionStepSuccessOutput`](crate::output::SendPipelineExecutionStepSuccessOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_execution_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
        pub fn pipeline_execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_execution_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
        pub fn set_pipeline_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_execution_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SendPipelineExecutionStepSuccessOutput`](crate::output::SendPipelineExecutionStepSuccessOutput)
        pub fn build(self) -> crate::output::SendPipelineExecutionStepSuccessOutput {
            crate::output::SendPipelineExecutionStepSuccessOutput {
                pipeline_execution_arn: self.pipeline_execution_arn,
            }
        }
    }
}
impl SendPipelineExecutionStepSuccessOutput {
    /// Creates a new builder-style object to manufacture [`SendPipelineExecutionStepSuccessOutput`](crate::output::SendPipelineExecutionStepSuccessOutput)
    pub fn builder() -> crate::output::send_pipeline_execution_step_success_output::Builder {
        crate::output::send_pipeline_execution_step_success_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendPipelineExecutionStepFailureOutput {
    /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
    pub pipeline_execution_arn: std::option::Option<std::string::String>,
}
impl SendPipelineExecutionStepFailureOutput {
    /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
    pub fn pipeline_execution_arn(&self) -> std::option::Option<&str> {
        self.pipeline_execution_arn.as_deref()
    }
}
impl std::fmt::Debug for SendPipelineExecutionStepFailureOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendPipelineExecutionStepFailureOutput");
        formatter.field("pipeline_execution_arn", &self.pipeline_execution_arn);
        formatter.finish()
    }
}
/// See [`SendPipelineExecutionStepFailureOutput`](crate::output::SendPipelineExecutionStepFailureOutput)
pub mod send_pipeline_execution_step_failure_output {
    /// A builder for [`SendPipelineExecutionStepFailureOutput`](crate::output::SendPipelineExecutionStepFailureOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_execution_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
        pub fn pipeline_execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_execution_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
        pub fn set_pipeline_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_execution_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SendPipelineExecutionStepFailureOutput`](crate::output::SendPipelineExecutionStepFailureOutput)
        pub fn build(self) -> crate::output::SendPipelineExecutionStepFailureOutput {
            crate::output::SendPipelineExecutionStepFailureOutput {
                pipeline_execution_arn: self.pipeline_execution_arn,
            }
        }
    }
}
impl SendPipelineExecutionStepFailureOutput {
    /// Creates a new builder-style object to manufacture [`SendPipelineExecutionStepFailureOutput`](crate::output::SendPipelineExecutionStepFailureOutput)
    pub fn builder() -> crate::output::send_pipeline_execution_step_failure_output::Builder {
        crate::output::send_pipeline_execution_step_failure_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchOutput {
    /// <p>A list of <code>SearchRecord</code> objects.</p>
    pub results: std::option::Option<std::vec::Vec<crate::model::SearchRecord>>,
    /// <p>If the result of the previous <code>Search</code> request was truncated, the response includes a NextToken. To retrieve the next set of results, use the token in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl SearchOutput {
    /// <p>A list of <code>SearchRecord</code> objects.</p>
    pub fn results(&self) -> std::option::Option<&[crate::model::SearchRecord]> {
        self.results.as_deref()
    }
    /// <p>If the result of the previous <code>Search</code> request was truncated, the response includes a NextToken. To retrieve the next set of results, use the token in the next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for SearchOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchOutput");
        formatter.field("results", &self.results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`SearchOutput`](crate::output::SearchOutput)
pub mod search_output {
    /// A builder for [`SearchOutput`](crate::output::SearchOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) results: std::option::Option<std::vec::Vec<crate::model::SearchRecord>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `results`.
        ///
        /// To override the contents of this collection use [`set_results`](Self::set_results).
        ///
        /// <p>A list of <code>SearchRecord</code> objects.</p>
        pub fn results(mut self, input: crate::model::SearchRecord) -> Self {
            let mut v = self.results.unwrap_or_default();
            v.push(input);
            self.results = Some(v);
            self
        }
        /// <p>A list of <code>SearchRecord</code> objects.</p>
        pub fn set_results(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SearchRecord>>,
        ) -> Self {
            self.results = input;
            self
        }
        /// <p>If the result of the previous <code>Search</code> request was truncated, the response includes a NextToken. To retrieve the next set of results, use the token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the result of the previous <code>Search</code> request was truncated, the response includes a NextToken. To retrieve the next set of results, use the token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchOutput`](crate::output::SearchOutput)
        pub fn build(self) -> crate::output::SearchOutput {
            crate::output::SearchOutput {
                results: self.results,
                next_token: self.next_token,
            }
        }
    }
}
impl SearchOutput {
    /// Creates a new builder-style object to manufacture [`SearchOutput`](crate::output::SearchOutput)
    pub fn builder() -> crate::output::search_output::Builder {
        crate::output::search_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RetryPipelineExecutionOutput {
    /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
    pub pipeline_execution_arn: std::option::Option<std::string::String>,
}
impl RetryPipelineExecutionOutput {
    /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
    pub fn pipeline_execution_arn(&self) -> std::option::Option<&str> {
        self.pipeline_execution_arn.as_deref()
    }
}
impl std::fmt::Debug for RetryPipelineExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RetryPipelineExecutionOutput");
        formatter.field("pipeline_execution_arn", &self.pipeline_execution_arn);
        formatter.finish()
    }
}
/// See [`RetryPipelineExecutionOutput`](crate::output::RetryPipelineExecutionOutput)
pub mod retry_pipeline_execution_output {
    /// A builder for [`RetryPipelineExecutionOutput`](crate::output::RetryPipelineExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_execution_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
        pub fn pipeline_execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_execution_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
        pub fn set_pipeline_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_execution_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RetryPipelineExecutionOutput`](crate::output::RetryPipelineExecutionOutput)
        pub fn build(self) -> crate::output::RetryPipelineExecutionOutput {
            crate::output::RetryPipelineExecutionOutput {
                pipeline_execution_arn: self.pipeline_execution_arn,
            }
        }
    }
}
impl RetryPipelineExecutionOutput {
    /// Creates a new builder-style object to manufacture [`RetryPipelineExecutionOutput`](crate::output::RetryPipelineExecutionOutput)
    pub fn builder() -> crate::output::retry_pipeline_execution_output::Builder {
        crate::output::retry_pipeline_execution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RenderUiTemplateOutput {
    /// <p>A Liquid template that renders the HTML for the worker UI.</p>
    pub rendered_content: std::option::Option<std::string::String>,
    /// <p>A list of one or more <code>RenderingError</code> objects if any were encountered while rendering the template. If there were no errors, the list is empty.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::RenderingError>>,
}
impl RenderUiTemplateOutput {
    /// <p>A Liquid template that renders the HTML for the worker UI.</p>
    pub fn rendered_content(&self) -> std::option::Option<&str> {
        self.rendered_content.as_deref()
    }
    /// <p>A list of one or more <code>RenderingError</code> objects if any were encountered while rendering the template. If there were no errors, the list is empty.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::RenderingError]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for RenderUiTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RenderUiTemplateOutput");
        formatter.field("rendered_content", &self.rendered_content);
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`RenderUiTemplateOutput`](crate::output::RenderUiTemplateOutput)
pub mod render_ui_template_output {
    /// A builder for [`RenderUiTemplateOutput`](crate::output::RenderUiTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rendered_content: std::option::Option<std::string::String>,
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::RenderingError>>,
    }
    impl Builder {
        /// <p>A Liquid template that renders the HTML for the worker UI.</p>
        pub fn rendered_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.rendered_content = Some(input.into());
            self
        }
        /// <p>A Liquid template that renders the HTML for the worker UI.</p>
        pub fn set_rendered_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rendered_content = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>A list of one or more <code>RenderingError</code> objects if any were encountered while rendering the template. If there were no errors, the list is empty.</p>
        pub fn errors(mut self, input: crate::model::RenderingError) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input);
            self.errors = Some(v);
            self
        }
        /// <p>A list of one or more <code>RenderingError</code> objects if any were encountered while rendering the template. If there were no errors, the list is empty.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RenderingError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`RenderUiTemplateOutput`](crate::output::RenderUiTemplateOutput)
        pub fn build(self) -> crate::output::RenderUiTemplateOutput {
            crate::output::RenderUiTemplateOutput {
                rendered_content: self.rendered_content,
                errors: self.errors,
            }
        }
    }
}
impl RenderUiTemplateOutput {
    /// Creates a new builder-style object to manufacture [`RenderUiTemplateOutput`](crate::output::RenderUiTemplateOutput)
    pub fn builder() -> crate::output::render_ui_template_output::Builder {
        crate::output::render_ui_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterDevicesOutput {}
impl std::fmt::Debug for RegisterDevicesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterDevicesOutput");
        formatter.finish()
    }
}
/// See [`RegisterDevicesOutput`](crate::output::RegisterDevicesOutput)
pub mod register_devices_output {
    /// A builder for [`RegisterDevicesOutput`](crate::output::RegisterDevicesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RegisterDevicesOutput`](crate::output::RegisterDevicesOutput)
        pub fn build(self) -> crate::output::RegisterDevicesOutput {
            crate::output::RegisterDevicesOutput {}
        }
    }
}
impl RegisterDevicesOutput {
    /// Creates a new builder-style object to manufacture [`RegisterDevicesOutput`](crate::output::RegisterDevicesOutput)
    pub fn builder() -> crate::output::register_devices_output::Builder {
        crate::output::register_devices_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryLineageOutput {
    /// <p>A list of vertices connected to the start entity(ies) in the lineage graph.</p>
    pub vertices: std::option::Option<std::vec::Vec<crate::model::Vertex>>,
    /// <p>A list of edges that connect vertices in the response.</p>
    pub edges: std::option::Option<std::vec::Vec<crate::model::Edge>>,
    /// <p>Limits the number of vertices in the response. Use the <code>NextToken</code> in a response to to retrieve the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl QueryLineageOutput {
    /// <p>A list of vertices connected to the start entity(ies) in the lineage graph.</p>
    pub fn vertices(&self) -> std::option::Option<&[crate::model::Vertex]> {
        self.vertices.as_deref()
    }
    /// <p>A list of edges that connect vertices in the response.</p>
    pub fn edges(&self) -> std::option::Option<&[crate::model::Edge]> {
        self.edges.as_deref()
    }
    /// <p>Limits the number of vertices in the response. Use the <code>NextToken</code> in a response to to retrieve the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for QueryLineageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryLineageOutput");
        formatter.field("vertices", &self.vertices);
        formatter.field("edges", &self.edges);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`QueryLineageOutput`](crate::output::QueryLineageOutput)
pub mod query_lineage_output {
    /// A builder for [`QueryLineageOutput`](crate::output::QueryLineageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vertices: std::option::Option<std::vec::Vec<crate::model::Vertex>>,
        pub(crate) edges: std::option::Option<std::vec::Vec<crate::model::Edge>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `vertices`.
        ///
        /// To override the contents of this collection use [`set_vertices`](Self::set_vertices).
        ///
        /// <p>A list of vertices connected to the start entity(ies) in the lineage graph.</p>
        pub fn vertices(mut self, input: crate::model::Vertex) -> Self {
            let mut v = self.vertices.unwrap_or_default();
            v.push(input);
            self.vertices = Some(v);
            self
        }
        /// <p>A list of vertices connected to the start entity(ies) in the lineage graph.</p>
        pub fn set_vertices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Vertex>>,
        ) -> Self {
            self.vertices = input;
            self
        }
        /// Appends an item to `edges`.
        ///
        /// To override the contents of this collection use [`set_edges`](Self::set_edges).
        ///
        /// <p>A list of edges that connect vertices in the response.</p>
        pub fn edges(mut self, input: crate::model::Edge) -> Self {
            let mut v = self.edges.unwrap_or_default();
            v.push(input);
            self.edges = Some(v);
            self
        }
        /// <p>A list of edges that connect vertices in the response.</p>
        pub fn set_edges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Edge>>,
        ) -> Self {
            self.edges = input;
            self
        }
        /// <p>Limits the number of vertices in the response. Use the <code>NextToken</code> in a response to to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Limits the number of vertices in the response. Use the <code>NextToken</code> in a response to to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryLineageOutput`](crate::output::QueryLineageOutput)
        pub fn build(self) -> crate::output::QueryLineageOutput {
            crate::output::QueryLineageOutput {
                vertices: self.vertices,
                edges: self.edges,
                next_token: self.next_token,
            }
        }
    }
}
impl QueryLineageOutput {
    /// Creates a new builder-style object to manufacture [`QueryLineageOutput`](crate::output::QueryLineageOutput)
    pub fn builder() -> crate::output::query_lineage_output::Builder {
        crate::output::query_lineage_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutModelPackageGroupPolicyOutput {
    /// <p>The Amazon Resource Name (ARN) of the model package group.</p>
    pub model_package_group_arn: std::option::Option<std::string::String>,
}
impl PutModelPackageGroupPolicyOutput {
    /// <p>The Amazon Resource Name (ARN) of the model package group.</p>
    pub fn model_package_group_arn(&self) -> std::option::Option<&str> {
        self.model_package_group_arn.as_deref()
    }
}
impl std::fmt::Debug for PutModelPackageGroupPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutModelPackageGroupPolicyOutput");
        formatter.field("model_package_group_arn", &self.model_package_group_arn);
        formatter.finish()
    }
}
/// See [`PutModelPackageGroupPolicyOutput`](crate::output::PutModelPackageGroupPolicyOutput)
pub mod put_model_package_group_policy_output {
    /// A builder for [`PutModelPackageGroupPolicyOutput`](crate::output::PutModelPackageGroupPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_package_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the model package group.</p>
        pub fn model_package_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_package_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model package group.</p>
        pub fn set_model_package_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_package_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`PutModelPackageGroupPolicyOutput`](crate::output::PutModelPackageGroupPolicyOutput)
        pub fn build(self) -> crate::output::PutModelPackageGroupPolicyOutput {
            crate::output::PutModelPackageGroupPolicyOutput {
                model_package_group_arn: self.model_package_group_arn,
            }
        }
    }
}
impl PutModelPackageGroupPolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutModelPackageGroupPolicyOutput`](crate::output::PutModelPackageGroupPolicyOutput)
    pub fn builder() -> crate::output::put_model_package_group_policy_output::Builder {
        crate::output::put_model_package_group_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWorkteamsOutput {
    /// <p>An array of <code>Workteam</code> objects, each describing a work team.</p>
    pub workteams: std::option::Option<std::vec::Vec<crate::model::Workteam>>,
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of work teams, use it in the subsequent request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListWorkteamsOutput {
    /// <p>An array of <code>Workteam</code> objects, each describing a work team.</p>
    pub fn workteams(&self) -> std::option::Option<&[crate::model::Workteam]> {
        self.workteams.as_deref()
    }
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of work teams, use it in the subsequent request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListWorkteamsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWorkteamsOutput");
        formatter.field("workteams", &self.workteams);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListWorkteamsOutput`](crate::output::ListWorkteamsOutput)
pub mod list_workteams_output {
    /// A builder for [`ListWorkteamsOutput`](crate::output::ListWorkteamsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workteams: std::option::Option<std::vec::Vec<crate::model::Workteam>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `workteams`.
        ///
        /// To override the contents of this collection use [`set_workteams`](Self::set_workteams).
        ///
        /// <p>An array of <code>Workteam</code> objects, each describing a work team.</p>
        pub fn workteams(mut self, input: crate::model::Workteam) -> Self {
            let mut v = self.workteams.unwrap_or_default();
            v.push(input);
            self.workteams = Some(v);
            self
        }
        /// <p>An array of <code>Workteam</code> objects, each describing a work team.</p>
        pub fn set_workteams(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Workteam>>,
        ) -> Self {
            self.workteams = input;
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of work teams, use it in the subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of work teams, use it in the subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWorkteamsOutput`](crate::output::ListWorkteamsOutput)
        pub fn build(self) -> crate::output::ListWorkteamsOutput {
            crate::output::ListWorkteamsOutput {
                workteams: self.workteams,
                next_token: self.next_token,
            }
        }
    }
}
impl ListWorkteamsOutput {
    /// Creates a new builder-style object to manufacture [`ListWorkteamsOutput`](crate::output::ListWorkteamsOutput)
    pub fn builder() -> crate::output::list_workteams_output::Builder {
        crate::output::list_workteams_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWorkforcesOutput {
    /// <p>A list containing information about your workforce.</p>
    pub workforces: std::option::Option<std::vec::Vec<crate::model::Workforce>>,
    /// <p>A token to resume pagination.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListWorkforcesOutput {
    /// <p>A list containing information about your workforce.</p>
    pub fn workforces(&self) -> std::option::Option<&[crate::model::Workforce]> {
        self.workforces.as_deref()
    }
    /// <p>A token to resume pagination.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListWorkforcesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWorkforcesOutput");
        formatter.field("workforces", &self.workforces);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListWorkforcesOutput`](crate::output::ListWorkforcesOutput)
pub mod list_workforces_output {
    /// A builder for [`ListWorkforcesOutput`](crate::output::ListWorkforcesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workforces: std::option::Option<std::vec::Vec<crate::model::Workforce>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `workforces`.
        ///
        /// To override the contents of this collection use [`set_workforces`](Self::set_workforces).
        ///
        /// <p>A list containing information about your workforce.</p>
        pub fn workforces(mut self, input: crate::model::Workforce) -> Self {
            let mut v = self.workforces.unwrap_or_default();
            v.push(input);
            self.workforces = Some(v);
            self
        }
        /// <p>A list containing information about your workforce.</p>
        pub fn set_workforces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Workforce>>,
        ) -> Self {
            self.workforces = input;
            self
        }
        /// <p>A token to resume pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to resume pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWorkforcesOutput`](crate::output::ListWorkforcesOutput)
        pub fn build(self) -> crate::output::ListWorkforcesOutput {
            crate::output::ListWorkforcesOutput {
                workforces: self.workforces,
                next_token: self.next_token,
            }
        }
    }
}
impl ListWorkforcesOutput {
    /// Creates a new builder-style object to manufacture [`ListWorkforcesOutput`](crate::output::ListWorkforcesOutput)
    pub fn builder() -> crate::output::list_workforces_output::Builder {
        crate::output::list_workforces_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListUserProfilesOutput {
    /// <p>The list of user profiles.</p>
    pub user_profiles: std::option::Option<std::vec::Vec<crate::model::UserProfileDetails>>,
    /// <p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListUserProfilesOutput {
    /// <p>The list of user profiles.</p>
    pub fn user_profiles(&self) -> std::option::Option<&[crate::model::UserProfileDetails]> {
        self.user_profiles.as_deref()
    }
    /// <p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListUserProfilesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListUserProfilesOutput");
        formatter.field("user_profiles", &self.user_profiles);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListUserProfilesOutput`](crate::output::ListUserProfilesOutput)
pub mod list_user_profiles_output {
    /// A builder for [`ListUserProfilesOutput`](crate::output::ListUserProfilesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_profiles:
            std::option::Option<std::vec::Vec<crate::model::UserProfileDetails>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `user_profiles`.
        ///
        /// To override the contents of this collection use [`set_user_profiles`](Self::set_user_profiles).
        ///
        /// <p>The list of user profiles.</p>
        pub fn user_profiles(mut self, input: crate::model::UserProfileDetails) -> Self {
            let mut v = self.user_profiles.unwrap_or_default();
            v.push(input);
            self.user_profiles = Some(v);
            self
        }
        /// <p>The list of user profiles.</p>
        pub fn set_user_profiles(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserProfileDetails>>,
        ) -> Self {
            self.user_profiles = input;
            self
        }
        /// <p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUserProfilesOutput`](crate::output::ListUserProfilesOutput)
        pub fn build(self) -> crate::output::ListUserProfilesOutput {
            crate::output::ListUserProfilesOutput {
                user_profiles: self.user_profiles,
                next_token: self.next_token,
            }
        }
    }
}
impl ListUserProfilesOutput {
    /// Creates a new builder-style object to manufacture [`ListUserProfilesOutput`](crate::output::ListUserProfilesOutput)
    pub fn builder() -> crate::output::list_user_profiles_output::Builder {
        crate::output::list_user_profiles_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTrialsOutput {
    /// <p>A list of the summaries of your trials.</p>
    pub trial_summaries: std::option::Option<std::vec::Vec<crate::model::TrialSummary>>,
    /// <p>A token for getting the next set of trials, if there are any.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTrialsOutput {
    /// <p>A list of the summaries of your trials.</p>
    pub fn trial_summaries(&self) -> std::option::Option<&[crate::model::TrialSummary]> {
        self.trial_summaries.as_deref()
    }
    /// <p>A token for getting the next set of trials, if there are any.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTrialsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTrialsOutput");
        formatter.field("trial_summaries", &self.trial_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTrialsOutput`](crate::output::ListTrialsOutput)
pub mod list_trials_output {
    /// A builder for [`ListTrialsOutput`](crate::output::ListTrialsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trial_summaries: std::option::Option<std::vec::Vec<crate::model::TrialSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `trial_summaries`.
        ///
        /// To override the contents of this collection use [`set_trial_summaries`](Self::set_trial_summaries).
        ///
        /// <p>A list of the summaries of your trials.</p>
        pub fn trial_summaries(mut self, input: crate::model::TrialSummary) -> Self {
            let mut v = self.trial_summaries.unwrap_or_default();
            v.push(input);
            self.trial_summaries = Some(v);
            self
        }
        /// <p>A list of the summaries of your trials.</p>
        pub fn set_trial_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TrialSummary>>,
        ) -> Self {
            self.trial_summaries = input;
            self
        }
        /// <p>A token for getting the next set of trials, if there are any.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token for getting the next set of trials, if there are any.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTrialsOutput`](crate::output::ListTrialsOutput)
        pub fn build(self) -> crate::output::ListTrialsOutput {
            crate::output::ListTrialsOutput {
                trial_summaries: self.trial_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTrialsOutput {
    /// Creates a new builder-style object to manufacture [`ListTrialsOutput`](crate::output::ListTrialsOutput)
    pub fn builder() -> crate::output::list_trials_output::Builder {
        crate::output::list_trials_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTrialComponentsOutput {
    /// <p>A list of the summaries of your trial components.</p>
    pub trial_component_summaries:
        std::option::Option<std::vec::Vec<crate::model::TrialComponentSummary>>,
    /// <p>A token for getting the next set of components, if there are any.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTrialComponentsOutput {
    /// <p>A list of the summaries of your trial components.</p>
    pub fn trial_component_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::TrialComponentSummary]> {
        self.trial_component_summaries.as_deref()
    }
    /// <p>A token for getting the next set of components, if there are any.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTrialComponentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTrialComponentsOutput");
        formatter.field("trial_component_summaries", &self.trial_component_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTrialComponentsOutput`](crate::output::ListTrialComponentsOutput)
pub mod list_trial_components_output {
    /// A builder for [`ListTrialComponentsOutput`](crate::output::ListTrialComponentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trial_component_summaries:
            std::option::Option<std::vec::Vec<crate::model::TrialComponentSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `trial_component_summaries`.
        ///
        /// To override the contents of this collection use [`set_trial_component_summaries`](Self::set_trial_component_summaries).
        ///
        /// <p>A list of the summaries of your trial components.</p>
        pub fn trial_component_summaries(
            mut self,
            input: crate::model::TrialComponentSummary,
        ) -> Self {
            let mut v = self.trial_component_summaries.unwrap_or_default();
            v.push(input);
            self.trial_component_summaries = Some(v);
            self
        }
        /// <p>A list of the summaries of your trial components.</p>
        pub fn set_trial_component_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TrialComponentSummary>>,
        ) -> Self {
            self.trial_component_summaries = input;
            self
        }
        /// <p>A token for getting the next set of components, if there are any.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token for getting the next set of components, if there are any.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTrialComponentsOutput`](crate::output::ListTrialComponentsOutput)
        pub fn build(self) -> crate::output::ListTrialComponentsOutput {
            crate::output::ListTrialComponentsOutput {
                trial_component_summaries: self.trial_component_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTrialComponentsOutput {
    /// Creates a new builder-style object to manufacture [`ListTrialComponentsOutput`](crate::output::ListTrialComponentsOutput)
    pub fn builder() -> crate::output::list_trial_components_output::Builder {
        crate::output::list_trial_components_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTransformJobsOutput {
    /// <p>An array of <code>TransformJobSummary</code> objects.</p>
    pub transform_job_summaries:
        std::option::Option<std::vec::Vec<crate::model::TransformJobSummary>>,
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of transform jobs, use it in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTransformJobsOutput {
    /// <p>An array of <code>TransformJobSummary</code> objects.</p>
    pub fn transform_job_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::TransformJobSummary]> {
        self.transform_job_summaries.as_deref()
    }
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of transform jobs, use it in the next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTransformJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTransformJobsOutput");
        formatter.field("transform_job_summaries", &self.transform_job_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTransformJobsOutput`](crate::output::ListTransformJobsOutput)
pub mod list_transform_jobs_output {
    /// A builder for [`ListTransformJobsOutput`](crate::output::ListTransformJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transform_job_summaries:
            std::option::Option<std::vec::Vec<crate::model::TransformJobSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `transform_job_summaries`.
        ///
        /// To override the contents of this collection use [`set_transform_job_summaries`](Self::set_transform_job_summaries).
        ///
        /// <p>An array of <code>TransformJobSummary</code> objects.</p>
        pub fn transform_job_summaries(mut self, input: crate::model::TransformJobSummary) -> Self {
            let mut v = self.transform_job_summaries.unwrap_or_default();
            v.push(input);
            self.transform_job_summaries = Some(v);
            self
        }
        /// <p>An array of <code>TransformJobSummary</code> objects.</p>
        pub fn set_transform_job_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TransformJobSummary>>,
        ) -> Self {
            self.transform_job_summaries = input;
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of transform jobs, use it in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of transform jobs, use it in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTransformJobsOutput`](crate::output::ListTransformJobsOutput)
        pub fn build(self) -> crate::output::ListTransformJobsOutput {
            crate::output::ListTransformJobsOutput {
                transform_job_summaries: self.transform_job_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTransformJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListTransformJobsOutput`](crate::output::ListTransformJobsOutput)
    pub fn builder() -> crate::output::list_transform_jobs_output::Builder {
        crate::output::list_transform_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTrainingJobsForHyperParameterTuningJobOutput {
    /// <p>A list of <code>TrainingJobSummary</code> objects that describe the training jobs that the <code>ListTrainingJobsForHyperParameterTuningJob</code> request returned.</p>
    pub training_job_summaries:
        std::option::Option<std::vec::Vec<crate::model::HyperParameterTrainingJobSummary>>,
    /// <p>If the result of this <code>ListTrainingJobsForHyperParameterTuningJob</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of training jobs, use the token in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTrainingJobsForHyperParameterTuningJobOutput {
    /// <p>A list of <code>TrainingJobSummary</code> objects that describe the training jobs that the <code>ListTrainingJobsForHyperParameterTuningJob</code> request returned.</p>
    pub fn training_job_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::HyperParameterTrainingJobSummary]> {
        self.training_job_summaries.as_deref()
    }
    /// <p>If the result of this <code>ListTrainingJobsForHyperParameterTuningJob</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of training jobs, use the token in the next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTrainingJobsForHyperParameterTuningJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTrainingJobsForHyperParameterTuningJobOutput");
        formatter.field("training_job_summaries", &self.training_job_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTrainingJobsForHyperParameterTuningJobOutput`](crate::output::ListTrainingJobsForHyperParameterTuningJobOutput)
pub mod list_training_jobs_for_hyper_parameter_tuning_job_output {
    /// A builder for [`ListTrainingJobsForHyperParameterTuningJobOutput`](crate::output::ListTrainingJobsForHyperParameterTuningJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) training_job_summaries:
            std::option::Option<std::vec::Vec<crate::model::HyperParameterTrainingJobSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `training_job_summaries`.
        ///
        /// To override the contents of this collection use [`set_training_job_summaries`](Self::set_training_job_summaries).
        ///
        /// <p>A list of <code>TrainingJobSummary</code> objects that describe the training jobs that the <code>ListTrainingJobsForHyperParameterTuningJob</code> request returned.</p>
        pub fn training_job_summaries(
            mut self,
            input: crate::model::HyperParameterTrainingJobSummary,
        ) -> Self {
            let mut v = self.training_job_summaries.unwrap_or_default();
            v.push(input);
            self.training_job_summaries = Some(v);
            self
        }
        /// <p>A list of <code>TrainingJobSummary</code> objects that describe the training jobs that the <code>ListTrainingJobsForHyperParameterTuningJob</code> request returned.</p>
        pub fn set_training_job_summaries(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::HyperParameterTrainingJobSummary>,
            >,
        ) -> Self {
            self.training_job_summaries = input;
            self
        }
        /// <p>If the result of this <code>ListTrainingJobsForHyperParameterTuningJob</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of training jobs, use the token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the result of this <code>ListTrainingJobsForHyperParameterTuningJob</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of training jobs, use the token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTrainingJobsForHyperParameterTuningJobOutput`](crate::output::ListTrainingJobsForHyperParameterTuningJobOutput)
        pub fn build(self) -> crate::output::ListTrainingJobsForHyperParameterTuningJobOutput {
            crate::output::ListTrainingJobsForHyperParameterTuningJobOutput {
                training_job_summaries: self.training_job_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTrainingJobsForHyperParameterTuningJobOutput {
    /// Creates a new builder-style object to manufacture [`ListTrainingJobsForHyperParameterTuningJobOutput`](crate::output::ListTrainingJobsForHyperParameterTuningJobOutput)
    pub fn builder(
    ) -> crate::output::list_training_jobs_for_hyper_parameter_tuning_job_output::Builder {
        crate::output::list_training_jobs_for_hyper_parameter_tuning_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTrainingJobsOutput {
    /// <p>An array of <code>TrainingJobSummary</code> objects, each listing a training job.</p>
    pub training_job_summaries:
        std::option::Option<std::vec::Vec<crate::model::TrainingJobSummary>>,
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of training jobs, use it in the subsequent request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTrainingJobsOutput {
    /// <p>An array of <code>TrainingJobSummary</code> objects, each listing a training job.</p>
    pub fn training_job_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::TrainingJobSummary]> {
        self.training_job_summaries.as_deref()
    }
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of training jobs, use it in the subsequent request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTrainingJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTrainingJobsOutput");
        formatter.field("training_job_summaries", &self.training_job_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTrainingJobsOutput`](crate::output::ListTrainingJobsOutput)
pub mod list_training_jobs_output {
    /// A builder for [`ListTrainingJobsOutput`](crate::output::ListTrainingJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) training_job_summaries:
            std::option::Option<std::vec::Vec<crate::model::TrainingJobSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `training_job_summaries`.
        ///
        /// To override the contents of this collection use [`set_training_job_summaries`](Self::set_training_job_summaries).
        ///
        /// <p>An array of <code>TrainingJobSummary</code> objects, each listing a training job.</p>
        pub fn training_job_summaries(mut self, input: crate::model::TrainingJobSummary) -> Self {
            let mut v = self.training_job_summaries.unwrap_or_default();
            v.push(input);
            self.training_job_summaries = Some(v);
            self
        }
        /// <p>An array of <code>TrainingJobSummary</code> objects, each listing a training job.</p>
        pub fn set_training_job_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TrainingJobSummary>>,
        ) -> Self {
            self.training_job_summaries = input;
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of training jobs, use it in the subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of training jobs, use it in the subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTrainingJobsOutput`](crate::output::ListTrainingJobsOutput)
        pub fn build(self) -> crate::output::ListTrainingJobsOutput {
            crate::output::ListTrainingJobsOutput {
                training_job_summaries: self.training_job_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTrainingJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListTrainingJobsOutput`](crate::output::ListTrainingJobsOutput)
    pub fn builder() -> crate::output::list_training_jobs_output::Builder {
        crate::output::list_training_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsOutput {
    /// <p>An array of <code>Tag</code> objects, each with a tag key and a value.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p> If response is truncated, Amazon SageMaker includes a token in the response. You can use this token in your subsequent request to fetch next set of tokens. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsOutput {
    /// <p>An array of <code>Tag</code> objects, each with a tag key and a value.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p> If response is truncated, Amazon SageMaker includes a token in the response. You can use this token in your subsequent request to fetch next set of tokens. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsOutput");
        formatter.field("tags", &self.tags);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTagsOutput`](crate::output::ListTagsOutput)
pub mod list_tags_output {
    /// A builder for [`ListTagsOutput`](crate::output::ListTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of <code>Tag</code> objects, each with a tag key and a value.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>An array of <code>Tag</code> objects, each with a tag key and a value.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p> If response is truncated, Amazon SageMaker includes a token in the response. You can use this token in your subsequent request to fetch next set of tokens. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> If response is truncated, Amazon SageMaker includes a token in the response. You can use this token in your subsequent request to fetch next set of tokens. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsOutput`](crate::output::ListTagsOutput)
        pub fn build(self) -> crate::output::ListTagsOutput {
            crate::output::ListTagsOutput {
                tags: self.tags,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTagsOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsOutput`](crate::output::ListTagsOutput)
    pub fn builder() -> crate::output::list_tags_output::Builder {
        crate::output::list_tags_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSubscribedWorkteamsOutput {
    /// <p>An array of <code>Workteam</code> objects, each describing a work team.</p>
    pub subscribed_workteams: std::option::Option<std::vec::Vec<crate::model::SubscribedWorkteam>>,
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of work teams, use it in the subsequent request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListSubscribedWorkteamsOutput {
    /// <p>An array of <code>Workteam</code> objects, each describing a work team.</p>
    pub fn subscribed_workteams(&self) -> std::option::Option<&[crate::model::SubscribedWorkteam]> {
        self.subscribed_workteams.as_deref()
    }
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of work teams, use it in the subsequent request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListSubscribedWorkteamsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSubscribedWorkteamsOutput");
        formatter.field("subscribed_workteams", &self.subscribed_workteams);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListSubscribedWorkteamsOutput`](crate::output::ListSubscribedWorkteamsOutput)
pub mod list_subscribed_workteams_output {
    /// A builder for [`ListSubscribedWorkteamsOutput`](crate::output::ListSubscribedWorkteamsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscribed_workteams:
            std::option::Option<std::vec::Vec<crate::model::SubscribedWorkteam>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `subscribed_workteams`.
        ///
        /// To override the contents of this collection use [`set_subscribed_workteams`](Self::set_subscribed_workteams).
        ///
        /// <p>An array of <code>Workteam</code> objects, each describing a work team.</p>
        pub fn subscribed_workteams(mut self, input: crate::model::SubscribedWorkteam) -> Self {
            let mut v = self.subscribed_workteams.unwrap_or_default();
            v.push(input);
            self.subscribed_workteams = Some(v);
            self
        }
        /// <p>An array of <code>Workteam</code> objects, each describing a work team.</p>
        pub fn set_subscribed_workteams(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SubscribedWorkteam>>,
        ) -> Self {
            self.subscribed_workteams = input;
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of work teams, use it in the subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of work teams, use it in the subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSubscribedWorkteamsOutput`](crate::output::ListSubscribedWorkteamsOutput)
        pub fn build(self) -> crate::output::ListSubscribedWorkteamsOutput {
            crate::output::ListSubscribedWorkteamsOutput {
                subscribed_workteams: self.subscribed_workteams,
                next_token: self.next_token,
            }
        }
    }
}
impl ListSubscribedWorkteamsOutput {
    /// Creates a new builder-style object to manufacture [`ListSubscribedWorkteamsOutput`](crate::output::ListSubscribedWorkteamsOutput)
    pub fn builder() -> crate::output::list_subscribed_workteams_output::Builder {
        crate::output::list_subscribed_workteams_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStudioLifecycleConfigsOutput {
    /// <p>A token for getting the next set of actions, if there are any.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of Lifecycle Configurations and their properties.</p>
    pub studio_lifecycle_configs:
        std::option::Option<std::vec::Vec<crate::model::StudioLifecycleConfigDetails>>,
}
impl ListStudioLifecycleConfigsOutput {
    /// <p>A token for getting the next set of actions, if there are any.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A list of Lifecycle Configurations and their properties.</p>
    pub fn studio_lifecycle_configs(
        &self,
    ) -> std::option::Option<&[crate::model::StudioLifecycleConfigDetails]> {
        self.studio_lifecycle_configs.as_deref()
    }
}
impl std::fmt::Debug for ListStudioLifecycleConfigsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStudioLifecycleConfigsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("studio_lifecycle_configs", &self.studio_lifecycle_configs);
        formatter.finish()
    }
}
/// See [`ListStudioLifecycleConfigsOutput`](crate::output::ListStudioLifecycleConfigsOutput)
pub mod list_studio_lifecycle_configs_output {
    /// A builder for [`ListStudioLifecycleConfigsOutput`](crate::output::ListStudioLifecycleConfigsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) studio_lifecycle_configs:
            std::option::Option<std::vec::Vec<crate::model::StudioLifecycleConfigDetails>>,
    }
    impl Builder {
        /// <p>A token for getting the next set of actions, if there are any.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token for getting the next set of actions, if there are any.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `studio_lifecycle_configs`.
        ///
        /// To override the contents of this collection use [`set_studio_lifecycle_configs`](Self::set_studio_lifecycle_configs).
        ///
        /// <p>A list of Lifecycle Configurations and their properties.</p>
        pub fn studio_lifecycle_configs(
            mut self,
            input: crate::model::StudioLifecycleConfigDetails,
        ) -> Self {
            let mut v = self.studio_lifecycle_configs.unwrap_or_default();
            v.push(input);
            self.studio_lifecycle_configs = Some(v);
            self
        }
        /// <p>A list of Lifecycle Configurations and their properties.</p>
        pub fn set_studio_lifecycle_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StudioLifecycleConfigDetails>>,
        ) -> Self {
            self.studio_lifecycle_configs = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStudioLifecycleConfigsOutput`](crate::output::ListStudioLifecycleConfigsOutput)
        pub fn build(self) -> crate::output::ListStudioLifecycleConfigsOutput {
            crate::output::ListStudioLifecycleConfigsOutput {
                next_token: self.next_token,
                studio_lifecycle_configs: self.studio_lifecycle_configs,
            }
        }
    }
}
impl ListStudioLifecycleConfigsOutput {
    /// Creates a new builder-style object to manufacture [`ListStudioLifecycleConfigsOutput`](crate::output::ListStudioLifecycleConfigsOutput)
    pub fn builder() -> crate::output::list_studio_lifecycle_configs_output::Builder {
        crate::output::list_studio_lifecycle_configs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProjectsOutput {
    /// <p>A list of summaries of projects.</p>
    pub project_summary_list: std::option::Option<std::vec::Vec<crate::model::ProjectSummary>>,
    /// <p>If the result of the previous <code>ListCompilationJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of model compilation jobs, use the token in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListProjectsOutput {
    /// <p>A list of summaries of projects.</p>
    pub fn project_summary_list(&self) -> std::option::Option<&[crate::model::ProjectSummary]> {
        self.project_summary_list.as_deref()
    }
    /// <p>If the result of the previous <code>ListCompilationJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of model compilation jobs, use the token in the next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListProjectsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProjectsOutput");
        formatter.field("project_summary_list", &self.project_summary_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListProjectsOutput`](crate::output::ListProjectsOutput)
pub mod list_projects_output {
    /// A builder for [`ListProjectsOutput`](crate::output::ListProjectsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_summary_list:
            std::option::Option<std::vec::Vec<crate::model::ProjectSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `project_summary_list`.
        ///
        /// To override the contents of this collection use [`set_project_summary_list`](Self::set_project_summary_list).
        ///
        /// <p>A list of summaries of projects.</p>
        pub fn project_summary_list(mut self, input: crate::model::ProjectSummary) -> Self {
            let mut v = self.project_summary_list.unwrap_or_default();
            v.push(input);
            self.project_summary_list = Some(v);
            self
        }
        /// <p>A list of summaries of projects.</p>
        pub fn set_project_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectSummary>>,
        ) -> Self {
            self.project_summary_list = input;
            self
        }
        /// <p>If the result of the previous <code>ListCompilationJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of model compilation jobs, use the token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the result of the previous <code>ListCompilationJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of model compilation jobs, use the token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProjectsOutput`](crate::output::ListProjectsOutput)
        pub fn build(self) -> crate::output::ListProjectsOutput {
            crate::output::ListProjectsOutput {
                project_summary_list: self.project_summary_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListProjectsOutput {
    /// Creates a new builder-style object to manufacture [`ListProjectsOutput`](crate::output::ListProjectsOutput)
    pub fn builder() -> crate::output::list_projects_output::Builder {
        crate::output::list_projects_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProcessingJobsOutput {
    /// <p>An array of <code>ProcessingJobSummary</code> objects, each listing a processing job.</p>
    pub processing_job_summaries:
        std::option::Option<std::vec::Vec<crate::model::ProcessingJobSummary>>,
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of processing jobs, use it in the subsequent request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListProcessingJobsOutput {
    /// <p>An array of <code>ProcessingJobSummary</code> objects, each listing a processing job.</p>
    pub fn processing_job_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::ProcessingJobSummary]> {
        self.processing_job_summaries.as_deref()
    }
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of processing jobs, use it in the subsequent request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListProcessingJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProcessingJobsOutput");
        formatter.field("processing_job_summaries", &self.processing_job_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListProcessingJobsOutput`](crate::output::ListProcessingJobsOutput)
pub mod list_processing_jobs_output {
    /// A builder for [`ListProcessingJobsOutput`](crate::output::ListProcessingJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) processing_job_summaries:
            std::option::Option<std::vec::Vec<crate::model::ProcessingJobSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `processing_job_summaries`.
        ///
        /// To override the contents of this collection use [`set_processing_job_summaries`](Self::set_processing_job_summaries).
        ///
        /// <p>An array of <code>ProcessingJobSummary</code> objects, each listing a processing job.</p>
        pub fn processing_job_summaries(
            mut self,
            input: crate::model::ProcessingJobSummary,
        ) -> Self {
            let mut v = self.processing_job_summaries.unwrap_or_default();
            v.push(input);
            self.processing_job_summaries = Some(v);
            self
        }
        /// <p>An array of <code>ProcessingJobSummary</code> objects, each listing a processing job.</p>
        pub fn set_processing_job_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProcessingJobSummary>>,
        ) -> Self {
            self.processing_job_summaries = input;
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of processing jobs, use it in the subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of processing jobs, use it in the subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProcessingJobsOutput`](crate::output::ListProcessingJobsOutput)
        pub fn build(self) -> crate::output::ListProcessingJobsOutput {
            crate::output::ListProcessingJobsOutput {
                processing_job_summaries: self.processing_job_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListProcessingJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListProcessingJobsOutput`](crate::output::ListProcessingJobsOutput)
    pub fn builder() -> crate::output::list_processing_jobs_output::Builder {
        crate::output::list_processing_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPipelinesOutput {
    /// <p>Contains a sorted list of <code>PipelineSummary</code> objects matching the specified filters. Each <code>PipelineSummary</code> consists of PipelineArn, PipelineName, ExperimentName, PipelineDescription, CreationTime, LastModifiedTime, LastRunTime, and RoleArn. This list can be empty. </p>
    pub pipeline_summaries: std::option::Option<std::vec::Vec<crate::model::PipelineSummary>>,
    /// <p>If the result of the previous <code>ListPipelines</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipelines, use the token in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPipelinesOutput {
    /// <p>Contains a sorted list of <code>PipelineSummary</code> objects matching the specified filters. Each <code>PipelineSummary</code> consists of PipelineArn, PipelineName, ExperimentName, PipelineDescription, CreationTime, LastModifiedTime, LastRunTime, and RoleArn. This list can be empty. </p>
    pub fn pipeline_summaries(&self) -> std::option::Option<&[crate::model::PipelineSummary]> {
        self.pipeline_summaries.as_deref()
    }
    /// <p>If the result of the previous <code>ListPipelines</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipelines, use the token in the next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPipelinesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPipelinesOutput");
        formatter.field("pipeline_summaries", &self.pipeline_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPipelinesOutput`](crate::output::ListPipelinesOutput)
pub mod list_pipelines_output {
    /// A builder for [`ListPipelinesOutput`](crate::output::ListPipelinesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_summaries:
            std::option::Option<std::vec::Vec<crate::model::PipelineSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `pipeline_summaries`.
        ///
        /// To override the contents of this collection use [`set_pipeline_summaries`](Self::set_pipeline_summaries).
        ///
        /// <p>Contains a sorted list of <code>PipelineSummary</code> objects matching the specified filters. Each <code>PipelineSummary</code> consists of PipelineArn, PipelineName, ExperimentName, PipelineDescription, CreationTime, LastModifiedTime, LastRunTime, and RoleArn. This list can be empty. </p>
        pub fn pipeline_summaries(mut self, input: crate::model::PipelineSummary) -> Self {
            let mut v = self.pipeline_summaries.unwrap_or_default();
            v.push(input);
            self.pipeline_summaries = Some(v);
            self
        }
        /// <p>Contains a sorted list of <code>PipelineSummary</code> objects matching the specified filters. Each <code>PipelineSummary</code> consists of PipelineArn, PipelineName, ExperimentName, PipelineDescription, CreationTime, LastModifiedTime, LastRunTime, and RoleArn. This list can be empty. </p>
        pub fn set_pipeline_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PipelineSummary>>,
        ) -> Self {
            self.pipeline_summaries = input;
            self
        }
        /// <p>If the result of the previous <code>ListPipelines</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipelines, use the token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the result of the previous <code>ListPipelines</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipelines, use the token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPipelinesOutput`](crate::output::ListPipelinesOutput)
        pub fn build(self) -> crate::output::ListPipelinesOutput {
            crate::output::ListPipelinesOutput {
                pipeline_summaries: self.pipeline_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPipelinesOutput {
    /// Creates a new builder-style object to manufacture [`ListPipelinesOutput`](crate::output::ListPipelinesOutput)
    pub fn builder() -> crate::output::list_pipelines_output::Builder {
        crate::output::list_pipelines_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPipelineParametersForExecutionOutput {
    /// <p>Contains a list of pipeline parameters. This list can be empty. </p>
    pub pipeline_parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    /// <p>If the result of the previous <code>ListPipelineParametersForExecution</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of parameters, use the token in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPipelineParametersForExecutionOutput {
    /// <p>Contains a list of pipeline parameters. This list can be empty. </p>
    pub fn pipeline_parameters(&self) -> std::option::Option<&[crate::model::Parameter]> {
        self.pipeline_parameters.as_deref()
    }
    /// <p>If the result of the previous <code>ListPipelineParametersForExecution</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of parameters, use the token in the next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPipelineParametersForExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPipelineParametersForExecutionOutput");
        formatter.field("pipeline_parameters", &self.pipeline_parameters);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPipelineParametersForExecutionOutput`](crate::output::ListPipelineParametersForExecutionOutput)
pub mod list_pipeline_parameters_for_execution_output {
    /// A builder for [`ListPipelineParametersForExecutionOutput`](crate::output::ListPipelineParametersForExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `pipeline_parameters`.
        ///
        /// To override the contents of this collection use [`set_pipeline_parameters`](Self::set_pipeline_parameters).
        ///
        /// <p>Contains a list of pipeline parameters. This list can be empty. </p>
        pub fn pipeline_parameters(mut self, input: crate::model::Parameter) -> Self {
            let mut v = self.pipeline_parameters.unwrap_or_default();
            v.push(input);
            self.pipeline_parameters = Some(v);
            self
        }
        /// <p>Contains a list of pipeline parameters. This list can be empty. </p>
        pub fn set_pipeline_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.pipeline_parameters = input;
            self
        }
        /// <p>If the result of the previous <code>ListPipelineParametersForExecution</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of parameters, use the token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the result of the previous <code>ListPipelineParametersForExecution</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of parameters, use the token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPipelineParametersForExecutionOutput`](crate::output::ListPipelineParametersForExecutionOutput)
        pub fn build(self) -> crate::output::ListPipelineParametersForExecutionOutput {
            crate::output::ListPipelineParametersForExecutionOutput {
                pipeline_parameters: self.pipeline_parameters,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPipelineParametersForExecutionOutput {
    /// Creates a new builder-style object to manufacture [`ListPipelineParametersForExecutionOutput`](crate::output::ListPipelineParametersForExecutionOutput)
    pub fn builder() -> crate::output::list_pipeline_parameters_for_execution_output::Builder {
        crate::output::list_pipeline_parameters_for_execution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPipelineExecutionStepsOutput {
    /// <p>A list of <code>PipeLineExecutionStep</code> objects. Each <code>PipeLineExecutionStep</code> consists of StepName, StartTime, EndTime, StepStatus, and Metadata. Metadata is an object with properties for each job that contains relevant information about the job created by the step.</p>
    pub pipeline_execution_steps:
        std::option::Option<std::vec::Vec<crate::model::PipelineExecutionStep>>,
    /// <p>If the result of the previous <code>ListPipelineExecutionSteps</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipeline execution steps, use the token in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPipelineExecutionStepsOutput {
    /// <p>A list of <code>PipeLineExecutionStep</code> objects. Each <code>PipeLineExecutionStep</code> consists of StepName, StartTime, EndTime, StepStatus, and Metadata. Metadata is an object with properties for each job that contains relevant information about the job created by the step.</p>
    pub fn pipeline_execution_steps(
        &self,
    ) -> std::option::Option<&[crate::model::PipelineExecutionStep]> {
        self.pipeline_execution_steps.as_deref()
    }
    /// <p>If the result of the previous <code>ListPipelineExecutionSteps</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipeline execution steps, use the token in the next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPipelineExecutionStepsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPipelineExecutionStepsOutput");
        formatter.field("pipeline_execution_steps", &self.pipeline_execution_steps);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPipelineExecutionStepsOutput`](crate::output::ListPipelineExecutionStepsOutput)
pub mod list_pipeline_execution_steps_output {
    /// A builder for [`ListPipelineExecutionStepsOutput`](crate::output::ListPipelineExecutionStepsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_execution_steps:
            std::option::Option<std::vec::Vec<crate::model::PipelineExecutionStep>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `pipeline_execution_steps`.
        ///
        /// To override the contents of this collection use [`set_pipeline_execution_steps`](Self::set_pipeline_execution_steps).
        ///
        /// <p>A list of <code>PipeLineExecutionStep</code> objects. Each <code>PipeLineExecutionStep</code> consists of StepName, StartTime, EndTime, StepStatus, and Metadata. Metadata is an object with properties for each job that contains relevant information about the job created by the step.</p>
        pub fn pipeline_execution_steps(
            mut self,
            input: crate::model::PipelineExecutionStep,
        ) -> Self {
            let mut v = self.pipeline_execution_steps.unwrap_or_default();
            v.push(input);
            self.pipeline_execution_steps = Some(v);
            self
        }
        /// <p>A list of <code>PipeLineExecutionStep</code> objects. Each <code>PipeLineExecutionStep</code> consists of StepName, StartTime, EndTime, StepStatus, and Metadata. Metadata is an object with properties for each job that contains relevant information about the job created by the step.</p>
        pub fn set_pipeline_execution_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PipelineExecutionStep>>,
        ) -> Self {
            self.pipeline_execution_steps = input;
            self
        }
        /// <p>If the result of the previous <code>ListPipelineExecutionSteps</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipeline execution steps, use the token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the result of the previous <code>ListPipelineExecutionSteps</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipeline execution steps, use the token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPipelineExecutionStepsOutput`](crate::output::ListPipelineExecutionStepsOutput)
        pub fn build(self) -> crate::output::ListPipelineExecutionStepsOutput {
            crate::output::ListPipelineExecutionStepsOutput {
                pipeline_execution_steps: self.pipeline_execution_steps,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPipelineExecutionStepsOutput {
    /// Creates a new builder-style object to manufacture [`ListPipelineExecutionStepsOutput`](crate::output::ListPipelineExecutionStepsOutput)
    pub fn builder() -> crate::output::list_pipeline_execution_steps_output::Builder {
        crate::output::list_pipeline_execution_steps_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPipelineExecutionsOutput {
    /// <p>Contains a sorted list of pipeline execution summary objects matching the specified filters. Each run summary includes the Amazon Resource Name (ARN) of the pipeline execution, the run date, and the status. This list can be empty. </p>
    pub pipeline_execution_summaries:
        std::option::Option<std::vec::Vec<crate::model::PipelineExecutionSummary>>,
    /// <p>If the result of the previous <code>ListPipelineExecutions</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipeline executions, use the token in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPipelineExecutionsOutput {
    /// <p>Contains a sorted list of pipeline execution summary objects matching the specified filters. Each run summary includes the Amazon Resource Name (ARN) of the pipeline execution, the run date, and the status. This list can be empty. </p>
    pub fn pipeline_execution_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::PipelineExecutionSummary]> {
        self.pipeline_execution_summaries.as_deref()
    }
    /// <p>If the result of the previous <code>ListPipelineExecutions</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipeline executions, use the token in the next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPipelineExecutionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPipelineExecutionsOutput");
        formatter.field(
            "pipeline_execution_summaries",
            &self.pipeline_execution_summaries,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPipelineExecutionsOutput`](crate::output::ListPipelineExecutionsOutput)
pub mod list_pipeline_executions_output {
    /// A builder for [`ListPipelineExecutionsOutput`](crate::output::ListPipelineExecutionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_execution_summaries:
            std::option::Option<std::vec::Vec<crate::model::PipelineExecutionSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `pipeline_execution_summaries`.
        ///
        /// To override the contents of this collection use [`set_pipeline_execution_summaries`](Self::set_pipeline_execution_summaries).
        ///
        /// <p>Contains a sorted list of pipeline execution summary objects matching the specified filters. Each run summary includes the Amazon Resource Name (ARN) of the pipeline execution, the run date, and the status. This list can be empty. </p>
        pub fn pipeline_execution_summaries(
            mut self,
            input: crate::model::PipelineExecutionSummary,
        ) -> Self {
            let mut v = self.pipeline_execution_summaries.unwrap_or_default();
            v.push(input);
            self.pipeline_execution_summaries = Some(v);
            self
        }
        /// <p>Contains a sorted list of pipeline execution summary objects matching the specified filters. Each run summary includes the Amazon Resource Name (ARN) of the pipeline execution, the run date, and the status. This list can be empty. </p>
        pub fn set_pipeline_execution_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PipelineExecutionSummary>>,
        ) -> Self {
            self.pipeline_execution_summaries = input;
            self
        }
        /// <p>If the result of the previous <code>ListPipelineExecutions</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipeline executions, use the token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the result of the previous <code>ListPipelineExecutions</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipeline executions, use the token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPipelineExecutionsOutput`](crate::output::ListPipelineExecutionsOutput)
        pub fn build(self) -> crate::output::ListPipelineExecutionsOutput {
            crate::output::ListPipelineExecutionsOutput {
                pipeline_execution_summaries: self.pipeline_execution_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPipelineExecutionsOutput {
    /// Creates a new builder-style object to manufacture [`ListPipelineExecutionsOutput`](crate::output::ListPipelineExecutionsOutput)
    pub fn builder() -> crate::output::list_pipeline_executions_output::Builder {
        crate::output::list_pipeline_executions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListNotebookInstancesOutput {
    /// <p>If the response to the previous <code>ListNotebookInstances</code> request was truncated, Amazon SageMaker returns this token. To retrieve the next set of notebook instances, use the token in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of <code>NotebookInstanceSummary</code> objects, one for each notebook instance.</p>
    pub notebook_instances:
        std::option::Option<std::vec::Vec<crate::model::NotebookInstanceSummary>>,
}
impl ListNotebookInstancesOutput {
    /// <p>If the response to the previous <code>ListNotebookInstances</code> request was truncated, Amazon SageMaker returns this token. To retrieve the next set of notebook instances, use the token in the next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An array of <code>NotebookInstanceSummary</code> objects, one for each notebook instance.</p>
    pub fn notebook_instances(
        &self,
    ) -> std::option::Option<&[crate::model::NotebookInstanceSummary]> {
        self.notebook_instances.as_deref()
    }
}
impl std::fmt::Debug for ListNotebookInstancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListNotebookInstancesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("notebook_instances", &self.notebook_instances);
        formatter.finish()
    }
}
/// See [`ListNotebookInstancesOutput`](crate::output::ListNotebookInstancesOutput)
pub mod list_notebook_instances_output {
    /// A builder for [`ListNotebookInstancesOutput`](crate::output::ListNotebookInstancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) notebook_instances:
            std::option::Option<std::vec::Vec<crate::model::NotebookInstanceSummary>>,
    }
    impl Builder {
        /// <p>If the response to the previous <code>ListNotebookInstances</code> request was truncated, Amazon SageMaker returns this token. To retrieve the next set of notebook instances, use the token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response to the previous <code>ListNotebookInstances</code> request was truncated, Amazon SageMaker returns this token. To retrieve the next set of notebook instances, use the token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `notebook_instances`.
        ///
        /// To override the contents of this collection use [`set_notebook_instances`](Self::set_notebook_instances).
        ///
        /// <p>An array of <code>NotebookInstanceSummary</code> objects, one for each notebook instance.</p>
        pub fn notebook_instances(mut self, input: crate::model::NotebookInstanceSummary) -> Self {
            let mut v = self.notebook_instances.unwrap_or_default();
            v.push(input);
            self.notebook_instances = Some(v);
            self
        }
        /// <p>An array of <code>NotebookInstanceSummary</code> objects, one for each notebook instance.</p>
        pub fn set_notebook_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NotebookInstanceSummary>>,
        ) -> Self {
            self.notebook_instances = input;
            self
        }
        /// Consumes the builder and constructs a [`ListNotebookInstancesOutput`](crate::output::ListNotebookInstancesOutput)
        pub fn build(self) -> crate::output::ListNotebookInstancesOutput {
            crate::output::ListNotebookInstancesOutput {
                next_token: self.next_token,
                notebook_instances: self.notebook_instances,
            }
        }
    }
}
impl ListNotebookInstancesOutput {
    /// Creates a new builder-style object to manufacture [`ListNotebookInstancesOutput`](crate::output::ListNotebookInstancesOutput)
    pub fn builder() -> crate::output::list_notebook_instances_output::Builder {
        crate::output::list_notebook_instances_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListNotebookInstanceLifecycleConfigsOutput {
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To get the next set of lifecycle configurations, use it in the next request. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of <code>NotebookInstanceLifecycleConfiguration</code> objects, each listing a lifecycle configuration.</p>
    pub notebook_instance_lifecycle_configs:
        std::option::Option<std::vec::Vec<crate::model::NotebookInstanceLifecycleConfigSummary>>,
}
impl ListNotebookInstanceLifecycleConfigsOutput {
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To get the next set of lifecycle configurations, use it in the next request. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>An array of <code>NotebookInstanceLifecycleConfiguration</code> objects, each listing a lifecycle configuration.</p>
    pub fn notebook_instance_lifecycle_configs(
        &self,
    ) -> std::option::Option<&[crate::model::NotebookInstanceLifecycleConfigSummary]> {
        self.notebook_instance_lifecycle_configs.as_deref()
    }
}
impl std::fmt::Debug for ListNotebookInstanceLifecycleConfigsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListNotebookInstanceLifecycleConfigsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field(
            "notebook_instance_lifecycle_configs",
            &self.notebook_instance_lifecycle_configs,
        );
        formatter.finish()
    }
}
/// See [`ListNotebookInstanceLifecycleConfigsOutput`](crate::output::ListNotebookInstanceLifecycleConfigsOutput)
pub mod list_notebook_instance_lifecycle_configs_output {
    /// A builder for [`ListNotebookInstanceLifecycleConfigsOutput`](crate::output::ListNotebookInstanceLifecycleConfigsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) notebook_instance_lifecycle_configs: std::option::Option<
            std::vec::Vec<crate::model::NotebookInstanceLifecycleConfigSummary>,
        >,
    }
    impl Builder {
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To get the next set of lifecycle configurations, use it in the next request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To get the next set of lifecycle configurations, use it in the next request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `notebook_instance_lifecycle_configs`.
        ///
        /// To override the contents of this collection use [`set_notebook_instance_lifecycle_configs`](Self::set_notebook_instance_lifecycle_configs).
        ///
        /// <p>An array of <code>NotebookInstanceLifecycleConfiguration</code> objects, each listing a lifecycle configuration.</p>
        pub fn notebook_instance_lifecycle_configs(
            mut self,
            input: crate::model::NotebookInstanceLifecycleConfigSummary,
        ) -> Self {
            let mut v = self.notebook_instance_lifecycle_configs.unwrap_or_default();
            v.push(input);
            self.notebook_instance_lifecycle_configs = Some(v);
            self
        }
        /// <p>An array of <code>NotebookInstanceLifecycleConfiguration</code> objects, each listing a lifecycle configuration.</p>
        pub fn set_notebook_instance_lifecycle_configs(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::NotebookInstanceLifecycleConfigSummary>,
            >,
        ) -> Self {
            self.notebook_instance_lifecycle_configs = input;
            self
        }
        /// Consumes the builder and constructs a [`ListNotebookInstanceLifecycleConfigsOutput`](crate::output::ListNotebookInstanceLifecycleConfigsOutput)
        pub fn build(self) -> crate::output::ListNotebookInstanceLifecycleConfigsOutput {
            crate::output::ListNotebookInstanceLifecycleConfigsOutput {
                next_token: self.next_token,
                notebook_instance_lifecycle_configs: self.notebook_instance_lifecycle_configs,
            }
        }
    }
}
impl ListNotebookInstanceLifecycleConfigsOutput {
    /// Creates a new builder-style object to manufacture [`ListNotebookInstanceLifecycleConfigsOutput`](crate::output::ListNotebookInstanceLifecycleConfigsOutput)
    pub fn builder() -> crate::output::list_notebook_instance_lifecycle_configs_output::Builder {
        crate::output::list_notebook_instance_lifecycle_configs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMonitoringSchedulesOutput {
    /// <p>A JSON array in which each element is a summary for a monitoring schedule.</p>
    pub monitoring_schedule_summaries:
        std::option::Option<std::vec::Vec<crate::model::MonitoringScheduleSummary>>,
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it in the subsequent request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListMonitoringSchedulesOutput {
    /// <p>A JSON array in which each element is a summary for a monitoring schedule.</p>
    pub fn monitoring_schedule_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::MonitoringScheduleSummary]> {
        self.monitoring_schedule_summaries.as_deref()
    }
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it in the subsequent request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListMonitoringSchedulesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMonitoringSchedulesOutput");
        formatter.field(
            "monitoring_schedule_summaries",
            &self.monitoring_schedule_summaries,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListMonitoringSchedulesOutput`](crate::output::ListMonitoringSchedulesOutput)
pub mod list_monitoring_schedules_output {
    /// A builder for [`ListMonitoringSchedulesOutput`](crate::output::ListMonitoringSchedulesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) monitoring_schedule_summaries:
            std::option::Option<std::vec::Vec<crate::model::MonitoringScheduleSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `monitoring_schedule_summaries`.
        ///
        /// To override the contents of this collection use [`set_monitoring_schedule_summaries`](Self::set_monitoring_schedule_summaries).
        ///
        /// <p>A JSON array in which each element is a summary for a monitoring schedule.</p>
        pub fn monitoring_schedule_summaries(
            mut self,
            input: crate::model::MonitoringScheduleSummary,
        ) -> Self {
            let mut v = self.monitoring_schedule_summaries.unwrap_or_default();
            v.push(input);
            self.monitoring_schedule_summaries = Some(v);
            self
        }
        /// <p>A JSON array in which each element is a summary for a monitoring schedule.</p>
        pub fn set_monitoring_schedule_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MonitoringScheduleSummary>>,
        ) -> Self {
            self.monitoring_schedule_summaries = input;
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it in the subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it in the subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMonitoringSchedulesOutput`](crate::output::ListMonitoringSchedulesOutput)
        pub fn build(self) -> crate::output::ListMonitoringSchedulesOutput {
            crate::output::ListMonitoringSchedulesOutput {
                monitoring_schedule_summaries: self.monitoring_schedule_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListMonitoringSchedulesOutput {
    /// Creates a new builder-style object to manufacture [`ListMonitoringSchedulesOutput`](crate::output::ListMonitoringSchedulesOutput)
    pub fn builder() -> crate::output::list_monitoring_schedules_output::Builder {
        crate::output::list_monitoring_schedules_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMonitoringExecutionsOutput {
    /// <p>A JSON array in which each element is a summary for a monitoring execution.</p>
    pub monitoring_execution_summaries:
        std::option::Option<std::vec::Vec<crate::model::MonitoringExecutionSummary>>,
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it in the subsequent reques</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListMonitoringExecutionsOutput {
    /// <p>A JSON array in which each element is a summary for a monitoring execution.</p>
    pub fn monitoring_execution_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::MonitoringExecutionSummary]> {
        self.monitoring_execution_summaries.as_deref()
    }
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it in the subsequent reques</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListMonitoringExecutionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMonitoringExecutionsOutput");
        formatter.field(
            "monitoring_execution_summaries",
            &self.monitoring_execution_summaries,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListMonitoringExecutionsOutput`](crate::output::ListMonitoringExecutionsOutput)
pub mod list_monitoring_executions_output {
    /// A builder for [`ListMonitoringExecutionsOutput`](crate::output::ListMonitoringExecutionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) monitoring_execution_summaries:
            std::option::Option<std::vec::Vec<crate::model::MonitoringExecutionSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `monitoring_execution_summaries`.
        ///
        /// To override the contents of this collection use [`set_monitoring_execution_summaries`](Self::set_monitoring_execution_summaries).
        ///
        /// <p>A JSON array in which each element is a summary for a monitoring execution.</p>
        pub fn monitoring_execution_summaries(
            mut self,
            input: crate::model::MonitoringExecutionSummary,
        ) -> Self {
            let mut v = self.monitoring_execution_summaries.unwrap_or_default();
            v.push(input);
            self.monitoring_execution_summaries = Some(v);
            self
        }
        /// <p>A JSON array in which each element is a summary for a monitoring execution.</p>
        pub fn set_monitoring_execution_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MonitoringExecutionSummary>>,
        ) -> Self {
            self.monitoring_execution_summaries = input;
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it in the subsequent reques</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it in the subsequent reques</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMonitoringExecutionsOutput`](crate::output::ListMonitoringExecutionsOutput)
        pub fn build(self) -> crate::output::ListMonitoringExecutionsOutput {
            crate::output::ListMonitoringExecutionsOutput {
                monitoring_execution_summaries: self.monitoring_execution_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListMonitoringExecutionsOutput {
    /// Creates a new builder-style object to manufacture [`ListMonitoringExecutionsOutput`](crate::output::ListMonitoringExecutionsOutput)
    pub fn builder() -> crate::output::list_monitoring_executions_output::Builder {
        crate::output::list_monitoring_executions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListModelsOutput {
    /// <p>An array of <code>ModelSummary</code> objects, each of which lists a model.</p>
    pub models: std::option::Option<std::vec::Vec<crate::model::ModelSummary>>,
    /// <p> If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of models, use it in the subsequent request. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListModelsOutput {
    /// <p>An array of <code>ModelSummary</code> objects, each of which lists a model.</p>
    pub fn models(&self) -> std::option::Option<&[crate::model::ModelSummary]> {
        self.models.as_deref()
    }
    /// <p> If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of models, use it in the subsequent request. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListModelsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListModelsOutput");
        formatter.field("models", &self.models);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListModelsOutput`](crate::output::ListModelsOutput)
pub mod list_models_output {
    /// A builder for [`ListModelsOutput`](crate::output::ListModelsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) models: std::option::Option<std::vec::Vec<crate::model::ModelSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `models`.
        ///
        /// To override the contents of this collection use [`set_models`](Self::set_models).
        ///
        /// <p>An array of <code>ModelSummary</code> objects, each of which lists a model.</p>
        pub fn models(mut self, input: crate::model::ModelSummary) -> Self {
            let mut v = self.models.unwrap_or_default();
            v.push(input);
            self.models = Some(v);
            self
        }
        /// <p>An array of <code>ModelSummary</code> objects, each of which lists a model.</p>
        pub fn set_models(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ModelSummary>>,
        ) -> Self {
            self.models = input;
            self
        }
        /// <p> If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of models, use it in the subsequent request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of models, use it in the subsequent request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListModelsOutput`](crate::output::ListModelsOutput)
        pub fn build(self) -> crate::output::ListModelsOutput {
            crate::output::ListModelsOutput {
                models: self.models,
                next_token: self.next_token,
            }
        }
    }
}
impl ListModelsOutput {
    /// Creates a new builder-style object to manufacture [`ListModelsOutput`](crate::output::ListModelsOutput)
    pub fn builder() -> crate::output::list_models_output::Builder {
        crate::output::list_models_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListModelQualityJobDefinitionsOutput {
    /// <p>A list of summaries of model quality monitoring job definitions.</p>
    pub job_definition_summaries:
        std::option::Option<std::vec::Vec<crate::model::MonitoringJobDefinitionSummary>>,
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of model quality monitoring job definitions, use it in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListModelQualityJobDefinitionsOutput {
    /// <p>A list of summaries of model quality monitoring job definitions.</p>
    pub fn job_definition_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::MonitoringJobDefinitionSummary]> {
        self.job_definition_summaries.as_deref()
    }
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of model quality monitoring job definitions, use it in the next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListModelQualityJobDefinitionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListModelQualityJobDefinitionsOutput");
        formatter.field("job_definition_summaries", &self.job_definition_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListModelQualityJobDefinitionsOutput`](crate::output::ListModelQualityJobDefinitionsOutput)
pub mod list_model_quality_job_definitions_output {
    /// A builder for [`ListModelQualityJobDefinitionsOutput`](crate::output::ListModelQualityJobDefinitionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_definition_summaries:
            std::option::Option<std::vec::Vec<crate::model::MonitoringJobDefinitionSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `job_definition_summaries`.
        ///
        /// To override the contents of this collection use [`set_job_definition_summaries`](Self::set_job_definition_summaries).
        ///
        /// <p>A list of summaries of model quality monitoring job definitions.</p>
        pub fn job_definition_summaries(
            mut self,
            input: crate::model::MonitoringJobDefinitionSummary,
        ) -> Self {
            let mut v = self.job_definition_summaries.unwrap_or_default();
            v.push(input);
            self.job_definition_summaries = Some(v);
            self
        }
        /// <p>A list of summaries of model quality monitoring job definitions.</p>
        pub fn set_job_definition_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MonitoringJobDefinitionSummary>>,
        ) -> Self {
            self.job_definition_summaries = input;
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of model quality monitoring job definitions, use it in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of model quality monitoring job definitions, use it in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListModelQualityJobDefinitionsOutput`](crate::output::ListModelQualityJobDefinitionsOutput)
        pub fn build(self) -> crate::output::ListModelQualityJobDefinitionsOutput {
            crate::output::ListModelQualityJobDefinitionsOutput {
                job_definition_summaries: self.job_definition_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListModelQualityJobDefinitionsOutput {
    /// Creates a new builder-style object to manufacture [`ListModelQualityJobDefinitionsOutput`](crate::output::ListModelQualityJobDefinitionsOutput)
    pub fn builder() -> crate::output::list_model_quality_job_definitions_output::Builder {
        crate::output::list_model_quality_job_definitions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListModelPackagesOutput {
    /// <p>An array of <code>ModelPackageSummary</code> objects, each of which lists a model package.</p>
    pub model_package_summary_list:
        std::option::Option<std::vec::Vec<crate::model::ModelPackageSummary>>,
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of model packages, use it in the subsequent request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListModelPackagesOutput {
    /// <p>An array of <code>ModelPackageSummary</code> objects, each of which lists a model package.</p>
    pub fn model_package_summary_list(
        &self,
    ) -> std::option::Option<&[crate::model::ModelPackageSummary]> {
        self.model_package_summary_list.as_deref()
    }
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of model packages, use it in the subsequent request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListModelPackagesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListModelPackagesOutput");
        formatter.field(
            "model_package_summary_list",
            &self.model_package_summary_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListModelPackagesOutput`](crate::output::ListModelPackagesOutput)
pub mod list_model_packages_output {
    /// A builder for [`ListModelPackagesOutput`](crate::output::ListModelPackagesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_package_summary_list:
            std::option::Option<std::vec::Vec<crate::model::ModelPackageSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `model_package_summary_list`.
        ///
        /// To override the contents of this collection use [`set_model_package_summary_list`](Self::set_model_package_summary_list).
        ///
        /// <p>An array of <code>ModelPackageSummary</code> objects, each of which lists a model package.</p>
        pub fn model_package_summary_list(
            mut self,
            input: crate::model::ModelPackageSummary,
        ) -> Self {
            let mut v = self.model_package_summary_list.unwrap_or_default();
            v.push(input);
            self.model_package_summary_list = Some(v);
            self
        }
        /// <p>An array of <code>ModelPackageSummary</code> objects, each of which lists a model package.</p>
        pub fn set_model_package_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ModelPackageSummary>>,
        ) -> Self {
            self.model_package_summary_list = input;
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of model packages, use it in the subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of model packages, use it in the subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListModelPackagesOutput`](crate::output::ListModelPackagesOutput)
        pub fn build(self) -> crate::output::ListModelPackagesOutput {
            crate::output::ListModelPackagesOutput {
                model_package_summary_list: self.model_package_summary_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListModelPackagesOutput {
    /// Creates a new builder-style object to manufacture [`ListModelPackagesOutput`](crate::output::ListModelPackagesOutput)
    pub fn builder() -> crate::output::list_model_packages_output::Builder {
        crate::output::list_model_packages_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListModelPackageGroupsOutput {
    /// <p>A list of summaries of the model groups in your Amazon Web Services account.</p>
    pub model_package_group_summary_list:
        std::option::Option<std::vec::Vec<crate::model::ModelPackageGroupSummary>>,
    /// <p>If the response is truncated, SageMaker returns this token. To retrieve the next set of model groups, use it in the subsequent request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListModelPackageGroupsOutput {
    /// <p>A list of summaries of the model groups in your Amazon Web Services account.</p>
    pub fn model_package_group_summary_list(
        &self,
    ) -> std::option::Option<&[crate::model::ModelPackageGroupSummary]> {
        self.model_package_group_summary_list.as_deref()
    }
    /// <p>If the response is truncated, SageMaker returns this token. To retrieve the next set of model groups, use it in the subsequent request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListModelPackageGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListModelPackageGroupsOutput");
        formatter.field(
            "model_package_group_summary_list",
            &self.model_package_group_summary_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListModelPackageGroupsOutput`](crate::output::ListModelPackageGroupsOutput)
pub mod list_model_package_groups_output {
    /// A builder for [`ListModelPackageGroupsOutput`](crate::output::ListModelPackageGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_package_group_summary_list:
            std::option::Option<std::vec::Vec<crate::model::ModelPackageGroupSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `model_package_group_summary_list`.
        ///
        /// To override the contents of this collection use [`set_model_package_group_summary_list`](Self::set_model_package_group_summary_list).
        ///
        /// <p>A list of summaries of the model groups in your Amazon Web Services account.</p>
        pub fn model_package_group_summary_list(
            mut self,
            input: crate::model::ModelPackageGroupSummary,
        ) -> Self {
            let mut v = self.model_package_group_summary_list.unwrap_or_default();
            v.push(input);
            self.model_package_group_summary_list = Some(v);
            self
        }
        /// <p>A list of summaries of the model groups in your Amazon Web Services account.</p>
        pub fn set_model_package_group_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ModelPackageGroupSummary>>,
        ) -> Self {
            self.model_package_group_summary_list = input;
            self
        }
        /// <p>If the response is truncated, SageMaker returns this token. To retrieve the next set of model groups, use it in the subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, SageMaker returns this token. To retrieve the next set of model groups, use it in the subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListModelPackageGroupsOutput`](crate::output::ListModelPackageGroupsOutput)
        pub fn build(self) -> crate::output::ListModelPackageGroupsOutput {
            crate::output::ListModelPackageGroupsOutput {
                model_package_group_summary_list: self.model_package_group_summary_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListModelPackageGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListModelPackageGroupsOutput`](crate::output::ListModelPackageGroupsOutput)
    pub fn builder() -> crate::output::list_model_package_groups_output::Builder {
        crate::output::list_model_package_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListModelMetadataOutput {
    /// <p>A structure that holds model metadata.</p>
    pub model_metadata_summaries:
        std::option::Option<std::vec::Vec<crate::model::ModelMetadataSummary>>,
    /// <p>A token for getting the next set of recommendations, if there are any.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListModelMetadataOutput {
    /// <p>A structure that holds model metadata.</p>
    pub fn model_metadata_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::ModelMetadataSummary]> {
        self.model_metadata_summaries.as_deref()
    }
    /// <p>A token for getting the next set of recommendations, if there are any.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListModelMetadataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListModelMetadataOutput");
        formatter.field("model_metadata_summaries", &self.model_metadata_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListModelMetadataOutput`](crate::output::ListModelMetadataOutput)
pub mod list_model_metadata_output {
    /// A builder for [`ListModelMetadataOutput`](crate::output::ListModelMetadataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_metadata_summaries:
            std::option::Option<std::vec::Vec<crate::model::ModelMetadataSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `model_metadata_summaries`.
        ///
        /// To override the contents of this collection use [`set_model_metadata_summaries`](Self::set_model_metadata_summaries).
        ///
        /// <p>A structure that holds model metadata.</p>
        pub fn model_metadata_summaries(
            mut self,
            input: crate::model::ModelMetadataSummary,
        ) -> Self {
            let mut v = self.model_metadata_summaries.unwrap_or_default();
            v.push(input);
            self.model_metadata_summaries = Some(v);
            self
        }
        /// <p>A structure that holds model metadata.</p>
        pub fn set_model_metadata_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ModelMetadataSummary>>,
        ) -> Self {
            self.model_metadata_summaries = input;
            self
        }
        /// <p>A token for getting the next set of recommendations, if there are any.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token for getting the next set of recommendations, if there are any.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListModelMetadataOutput`](crate::output::ListModelMetadataOutput)
        pub fn build(self) -> crate::output::ListModelMetadataOutput {
            crate::output::ListModelMetadataOutput {
                model_metadata_summaries: self.model_metadata_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListModelMetadataOutput {
    /// Creates a new builder-style object to manufacture [`ListModelMetadataOutput`](crate::output::ListModelMetadataOutput)
    pub fn builder() -> crate::output::list_model_metadata_output::Builder {
        crate::output::list_model_metadata_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListModelExplainabilityJobDefinitionsOutput {
    /// <p>A JSON array in which each element is a summary for a explainability bias jobs.</p>
    pub job_definition_summaries:
        std::option::Option<std::vec::Vec<crate::model::MonitoringJobDefinitionSummary>>,
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it in the subsequent request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListModelExplainabilityJobDefinitionsOutput {
    /// <p>A JSON array in which each element is a summary for a explainability bias jobs.</p>
    pub fn job_definition_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::MonitoringJobDefinitionSummary]> {
        self.job_definition_summaries.as_deref()
    }
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it in the subsequent request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListModelExplainabilityJobDefinitionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListModelExplainabilityJobDefinitionsOutput");
        formatter.field("job_definition_summaries", &self.job_definition_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListModelExplainabilityJobDefinitionsOutput`](crate::output::ListModelExplainabilityJobDefinitionsOutput)
pub mod list_model_explainability_job_definitions_output {
    /// A builder for [`ListModelExplainabilityJobDefinitionsOutput`](crate::output::ListModelExplainabilityJobDefinitionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_definition_summaries:
            std::option::Option<std::vec::Vec<crate::model::MonitoringJobDefinitionSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `job_definition_summaries`.
        ///
        /// To override the contents of this collection use [`set_job_definition_summaries`](Self::set_job_definition_summaries).
        ///
        /// <p>A JSON array in which each element is a summary for a explainability bias jobs.</p>
        pub fn job_definition_summaries(
            mut self,
            input: crate::model::MonitoringJobDefinitionSummary,
        ) -> Self {
            let mut v = self.job_definition_summaries.unwrap_or_default();
            v.push(input);
            self.job_definition_summaries = Some(v);
            self
        }
        /// <p>A JSON array in which each element is a summary for a explainability bias jobs.</p>
        pub fn set_job_definition_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MonitoringJobDefinitionSummary>>,
        ) -> Self {
            self.job_definition_summaries = input;
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it in the subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it in the subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListModelExplainabilityJobDefinitionsOutput`](crate::output::ListModelExplainabilityJobDefinitionsOutput)
        pub fn build(self) -> crate::output::ListModelExplainabilityJobDefinitionsOutput {
            crate::output::ListModelExplainabilityJobDefinitionsOutput {
                job_definition_summaries: self.job_definition_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListModelExplainabilityJobDefinitionsOutput {
    /// Creates a new builder-style object to manufacture [`ListModelExplainabilityJobDefinitionsOutput`](crate::output::ListModelExplainabilityJobDefinitionsOutput)
    pub fn builder() -> crate::output::list_model_explainability_job_definitions_output::Builder {
        crate::output::list_model_explainability_job_definitions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListModelBiasJobDefinitionsOutput {
    /// <p>A JSON array in which each element is a summary for a model bias jobs.</p>
    pub job_definition_summaries:
        std::option::Option<std::vec::Vec<crate::model::MonitoringJobDefinitionSummary>>,
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it in the subsequent request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListModelBiasJobDefinitionsOutput {
    /// <p>A JSON array in which each element is a summary for a model bias jobs.</p>
    pub fn job_definition_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::MonitoringJobDefinitionSummary]> {
        self.job_definition_summaries.as_deref()
    }
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it in the subsequent request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListModelBiasJobDefinitionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListModelBiasJobDefinitionsOutput");
        formatter.field("job_definition_summaries", &self.job_definition_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListModelBiasJobDefinitionsOutput`](crate::output::ListModelBiasJobDefinitionsOutput)
pub mod list_model_bias_job_definitions_output {
    /// A builder for [`ListModelBiasJobDefinitionsOutput`](crate::output::ListModelBiasJobDefinitionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_definition_summaries:
            std::option::Option<std::vec::Vec<crate::model::MonitoringJobDefinitionSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `job_definition_summaries`.
        ///
        /// To override the contents of this collection use [`set_job_definition_summaries`](Self::set_job_definition_summaries).
        ///
        /// <p>A JSON array in which each element is a summary for a model bias jobs.</p>
        pub fn job_definition_summaries(
            mut self,
            input: crate::model::MonitoringJobDefinitionSummary,
        ) -> Self {
            let mut v = self.job_definition_summaries.unwrap_or_default();
            v.push(input);
            self.job_definition_summaries = Some(v);
            self
        }
        /// <p>A JSON array in which each element is a summary for a model bias jobs.</p>
        pub fn set_job_definition_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MonitoringJobDefinitionSummary>>,
        ) -> Self {
            self.job_definition_summaries = input;
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it in the subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it in the subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListModelBiasJobDefinitionsOutput`](crate::output::ListModelBiasJobDefinitionsOutput)
        pub fn build(self) -> crate::output::ListModelBiasJobDefinitionsOutput {
            crate::output::ListModelBiasJobDefinitionsOutput {
                job_definition_summaries: self.job_definition_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListModelBiasJobDefinitionsOutput {
    /// Creates a new builder-style object to manufacture [`ListModelBiasJobDefinitionsOutput`](crate::output::ListModelBiasJobDefinitionsOutput)
    pub fn builder() -> crate::output::list_model_bias_job_definitions_output::Builder {
        crate::output::list_model_bias_job_definitions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLineageGroupsOutput {
    /// <p>A list of lineage groups and their properties.</p>
    pub lineage_group_summaries:
        std::option::Option<std::vec::Vec<crate::model::LineageGroupSummary>>,
    /// <p>If the response is truncated, SageMaker returns this token. To retrieve the next set of algorithms, use it in the subsequent request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListLineageGroupsOutput {
    /// <p>A list of lineage groups and their properties.</p>
    pub fn lineage_group_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::LineageGroupSummary]> {
        self.lineage_group_summaries.as_deref()
    }
    /// <p>If the response is truncated, SageMaker returns this token. To retrieve the next set of algorithms, use it in the subsequent request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListLineageGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLineageGroupsOutput");
        formatter.field("lineage_group_summaries", &self.lineage_group_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListLineageGroupsOutput`](crate::output::ListLineageGroupsOutput)
pub mod list_lineage_groups_output {
    /// A builder for [`ListLineageGroupsOutput`](crate::output::ListLineageGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lineage_group_summaries:
            std::option::Option<std::vec::Vec<crate::model::LineageGroupSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `lineage_group_summaries`.
        ///
        /// To override the contents of this collection use [`set_lineage_group_summaries`](Self::set_lineage_group_summaries).
        ///
        /// <p>A list of lineage groups and their properties.</p>
        pub fn lineage_group_summaries(mut self, input: crate::model::LineageGroupSummary) -> Self {
            let mut v = self.lineage_group_summaries.unwrap_or_default();
            v.push(input);
            self.lineage_group_summaries = Some(v);
            self
        }
        /// <p>A list of lineage groups and their properties.</p>
        pub fn set_lineage_group_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LineageGroupSummary>>,
        ) -> Self {
            self.lineage_group_summaries = input;
            self
        }
        /// <p>If the response is truncated, SageMaker returns this token. To retrieve the next set of algorithms, use it in the subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, SageMaker returns this token. To retrieve the next set of algorithms, use it in the subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLineageGroupsOutput`](crate::output::ListLineageGroupsOutput)
        pub fn build(self) -> crate::output::ListLineageGroupsOutput {
            crate::output::ListLineageGroupsOutput {
                lineage_group_summaries: self.lineage_group_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListLineageGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListLineageGroupsOutput`](crate::output::ListLineageGroupsOutput)
    pub fn builder() -> crate::output::list_lineage_groups_output::Builder {
        crate::output::list_lineage_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLabelingJobsForWorkteamOutput {
    /// <p>An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.</p>
    pub labeling_job_summary_list:
        std::option::Option<std::vec::Vec<crate::model::LabelingJobForWorkteamSummary>>,
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of labeling jobs, use it in the subsequent request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListLabelingJobsForWorkteamOutput {
    /// <p>An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.</p>
    pub fn labeling_job_summary_list(
        &self,
    ) -> std::option::Option<&[crate::model::LabelingJobForWorkteamSummary]> {
        self.labeling_job_summary_list.as_deref()
    }
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of labeling jobs, use it in the subsequent request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListLabelingJobsForWorkteamOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLabelingJobsForWorkteamOutput");
        formatter.field("labeling_job_summary_list", &self.labeling_job_summary_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListLabelingJobsForWorkteamOutput`](crate::output::ListLabelingJobsForWorkteamOutput)
pub mod list_labeling_jobs_for_workteam_output {
    /// A builder for [`ListLabelingJobsForWorkteamOutput`](crate::output::ListLabelingJobsForWorkteamOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) labeling_job_summary_list:
            std::option::Option<std::vec::Vec<crate::model::LabelingJobForWorkteamSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `labeling_job_summary_list`.
        ///
        /// To override the contents of this collection use [`set_labeling_job_summary_list`](Self::set_labeling_job_summary_list).
        ///
        /// <p>An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.</p>
        pub fn labeling_job_summary_list(
            mut self,
            input: crate::model::LabelingJobForWorkteamSummary,
        ) -> Self {
            let mut v = self.labeling_job_summary_list.unwrap_or_default();
            v.push(input);
            self.labeling_job_summary_list = Some(v);
            self
        }
        /// <p>An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.</p>
        pub fn set_labeling_job_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LabelingJobForWorkteamSummary>>,
        ) -> Self {
            self.labeling_job_summary_list = input;
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of labeling jobs, use it in the subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of labeling jobs, use it in the subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLabelingJobsForWorkteamOutput`](crate::output::ListLabelingJobsForWorkteamOutput)
        pub fn build(self) -> crate::output::ListLabelingJobsForWorkteamOutput {
            crate::output::ListLabelingJobsForWorkteamOutput {
                labeling_job_summary_list: self.labeling_job_summary_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListLabelingJobsForWorkteamOutput {
    /// Creates a new builder-style object to manufacture [`ListLabelingJobsForWorkteamOutput`](crate::output::ListLabelingJobsForWorkteamOutput)
    pub fn builder() -> crate::output::list_labeling_jobs_for_workteam_output::Builder {
        crate::output::list_labeling_jobs_for_workteam_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLabelingJobsOutput {
    /// <p>An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.</p>
    pub labeling_job_summary_list:
        std::option::Option<std::vec::Vec<crate::model::LabelingJobSummary>>,
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of labeling jobs, use it in the subsequent request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListLabelingJobsOutput {
    /// <p>An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.</p>
    pub fn labeling_job_summary_list(
        &self,
    ) -> std::option::Option<&[crate::model::LabelingJobSummary]> {
        self.labeling_job_summary_list.as_deref()
    }
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of labeling jobs, use it in the subsequent request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListLabelingJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLabelingJobsOutput");
        formatter.field("labeling_job_summary_list", &self.labeling_job_summary_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListLabelingJobsOutput`](crate::output::ListLabelingJobsOutput)
pub mod list_labeling_jobs_output {
    /// A builder for [`ListLabelingJobsOutput`](crate::output::ListLabelingJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) labeling_job_summary_list:
            std::option::Option<std::vec::Vec<crate::model::LabelingJobSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `labeling_job_summary_list`.
        ///
        /// To override the contents of this collection use [`set_labeling_job_summary_list`](Self::set_labeling_job_summary_list).
        ///
        /// <p>An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.</p>
        pub fn labeling_job_summary_list(
            mut self,
            input: crate::model::LabelingJobSummary,
        ) -> Self {
            let mut v = self.labeling_job_summary_list.unwrap_or_default();
            v.push(input);
            self.labeling_job_summary_list = Some(v);
            self
        }
        /// <p>An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.</p>
        pub fn set_labeling_job_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LabelingJobSummary>>,
        ) -> Self {
            self.labeling_job_summary_list = input;
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of labeling jobs, use it in the subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of labeling jobs, use it in the subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLabelingJobsOutput`](crate::output::ListLabelingJobsOutput)
        pub fn build(self) -> crate::output::ListLabelingJobsOutput {
            crate::output::ListLabelingJobsOutput {
                labeling_job_summary_list: self.labeling_job_summary_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListLabelingJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListLabelingJobsOutput`](crate::output::ListLabelingJobsOutput)
    pub fn builder() -> crate::output::list_labeling_jobs_output::Builder {
        crate::output::list_labeling_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInferenceRecommendationsJobsOutput {
    /// <p>The recommendations created from the Amazon SageMaker Inference Recommender job.</p>
    pub inference_recommendations_jobs:
        std::option::Option<std::vec::Vec<crate::model::InferenceRecommendationsJob>>,
    /// <p>A token for getting the next set of recommendations, if there are any.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListInferenceRecommendationsJobsOutput {
    /// <p>The recommendations created from the Amazon SageMaker Inference Recommender job.</p>
    pub fn inference_recommendations_jobs(
        &self,
    ) -> std::option::Option<&[crate::model::InferenceRecommendationsJob]> {
        self.inference_recommendations_jobs.as_deref()
    }
    /// <p>A token for getting the next set of recommendations, if there are any.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListInferenceRecommendationsJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInferenceRecommendationsJobsOutput");
        formatter.field(
            "inference_recommendations_jobs",
            &self.inference_recommendations_jobs,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListInferenceRecommendationsJobsOutput`](crate::output::ListInferenceRecommendationsJobsOutput)
pub mod list_inference_recommendations_jobs_output {
    /// A builder for [`ListInferenceRecommendationsJobsOutput`](crate::output::ListInferenceRecommendationsJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) inference_recommendations_jobs:
            std::option::Option<std::vec::Vec<crate::model::InferenceRecommendationsJob>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `inference_recommendations_jobs`.
        ///
        /// To override the contents of this collection use [`set_inference_recommendations_jobs`](Self::set_inference_recommendations_jobs).
        ///
        /// <p>The recommendations created from the Amazon SageMaker Inference Recommender job.</p>
        pub fn inference_recommendations_jobs(
            mut self,
            input: crate::model::InferenceRecommendationsJob,
        ) -> Self {
            let mut v = self.inference_recommendations_jobs.unwrap_or_default();
            v.push(input);
            self.inference_recommendations_jobs = Some(v);
            self
        }
        /// <p>The recommendations created from the Amazon SageMaker Inference Recommender job.</p>
        pub fn set_inference_recommendations_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InferenceRecommendationsJob>>,
        ) -> Self {
            self.inference_recommendations_jobs = input;
            self
        }
        /// <p>A token for getting the next set of recommendations, if there are any.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token for getting the next set of recommendations, if there are any.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInferenceRecommendationsJobsOutput`](crate::output::ListInferenceRecommendationsJobsOutput)
        pub fn build(self) -> crate::output::ListInferenceRecommendationsJobsOutput {
            crate::output::ListInferenceRecommendationsJobsOutput {
                inference_recommendations_jobs: self.inference_recommendations_jobs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListInferenceRecommendationsJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListInferenceRecommendationsJobsOutput`](crate::output::ListInferenceRecommendationsJobsOutput)
    pub fn builder() -> crate::output::list_inference_recommendations_jobs_output::Builder {
        crate::output::list_inference_recommendations_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListImageVersionsOutput {
    /// <p>A list of versions and their properties.</p>
    pub image_versions: std::option::Option<std::vec::Vec<crate::model::ImageVersion>>,
    /// <p>A token for getting the next set of versions, if there are any.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListImageVersionsOutput {
    /// <p>A list of versions and their properties.</p>
    pub fn image_versions(&self) -> std::option::Option<&[crate::model::ImageVersion]> {
        self.image_versions.as_deref()
    }
    /// <p>A token for getting the next set of versions, if there are any.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListImageVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListImageVersionsOutput");
        formatter.field("image_versions", &self.image_versions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListImageVersionsOutput`](crate::output::ListImageVersionsOutput)
pub mod list_image_versions_output {
    /// A builder for [`ListImageVersionsOutput`](crate::output::ListImageVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_versions: std::option::Option<std::vec::Vec<crate::model::ImageVersion>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `image_versions`.
        ///
        /// To override the contents of this collection use [`set_image_versions`](Self::set_image_versions).
        ///
        /// <p>A list of versions and their properties.</p>
        pub fn image_versions(mut self, input: crate::model::ImageVersion) -> Self {
            let mut v = self.image_versions.unwrap_or_default();
            v.push(input);
            self.image_versions = Some(v);
            self
        }
        /// <p>A list of versions and their properties.</p>
        pub fn set_image_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageVersion>>,
        ) -> Self {
            self.image_versions = input;
            self
        }
        /// <p>A token for getting the next set of versions, if there are any.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token for getting the next set of versions, if there are any.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListImageVersionsOutput`](crate::output::ListImageVersionsOutput)
        pub fn build(self) -> crate::output::ListImageVersionsOutput {
            crate::output::ListImageVersionsOutput {
                image_versions: self.image_versions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListImageVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListImageVersionsOutput`](crate::output::ListImageVersionsOutput)
    pub fn builder() -> crate::output::list_image_versions_output::Builder {
        crate::output::list_image_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListImagesOutput {
    /// <p>A list of images and their properties.</p>
    pub images: std::option::Option<std::vec::Vec<crate::model::Image>>,
    /// <p>A token for getting the next set of images, if there are any.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListImagesOutput {
    /// <p>A list of images and their properties.</p>
    pub fn images(&self) -> std::option::Option<&[crate::model::Image]> {
        self.images.as_deref()
    }
    /// <p>A token for getting the next set of images, if there are any.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListImagesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListImagesOutput");
        formatter.field("images", &self.images);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListImagesOutput`](crate::output::ListImagesOutput)
pub mod list_images_output {
    /// A builder for [`ListImagesOutput`](crate::output::ListImagesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) images: std::option::Option<std::vec::Vec<crate::model::Image>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `images`.
        ///
        /// To override the contents of this collection use [`set_images`](Self::set_images).
        ///
        /// <p>A list of images and their properties.</p>
        pub fn images(mut self, input: crate::model::Image) -> Self {
            let mut v = self.images.unwrap_or_default();
            v.push(input);
            self.images = Some(v);
            self
        }
        /// <p>A list of images and their properties.</p>
        pub fn set_images(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Image>>,
        ) -> Self {
            self.images = input;
            self
        }
        /// <p>A token for getting the next set of images, if there are any.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token for getting the next set of images, if there are any.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListImagesOutput`](crate::output::ListImagesOutput)
        pub fn build(self) -> crate::output::ListImagesOutput {
            crate::output::ListImagesOutput {
                images: self.images,
                next_token: self.next_token,
            }
        }
    }
}
impl ListImagesOutput {
    /// Creates a new builder-style object to manufacture [`ListImagesOutput`](crate::output::ListImagesOutput)
    pub fn builder() -> crate::output::list_images_output::Builder {
        crate::output::list_images_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListHyperParameterTuningJobsOutput {
    /// <p>A list of <code>HyperParameterTuningJobSummary</code> objects that describe the tuning jobs that the <code>ListHyperParameterTuningJobs</code> request returned.</p>
    pub hyper_parameter_tuning_job_summaries:
        std::option::Option<std::vec::Vec<crate::model::HyperParameterTuningJobSummary>>,
    /// <p>If the result of this <code>ListHyperParameterTuningJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of tuning jobs, use the token in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListHyperParameterTuningJobsOutput {
    /// <p>A list of <code>HyperParameterTuningJobSummary</code> objects that describe the tuning jobs that the <code>ListHyperParameterTuningJobs</code> request returned.</p>
    pub fn hyper_parameter_tuning_job_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::HyperParameterTuningJobSummary]> {
        self.hyper_parameter_tuning_job_summaries.as_deref()
    }
    /// <p>If the result of this <code>ListHyperParameterTuningJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of tuning jobs, use the token in the next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListHyperParameterTuningJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListHyperParameterTuningJobsOutput");
        formatter.field(
            "hyper_parameter_tuning_job_summaries",
            &self.hyper_parameter_tuning_job_summaries,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListHyperParameterTuningJobsOutput`](crate::output::ListHyperParameterTuningJobsOutput)
pub mod list_hyper_parameter_tuning_jobs_output {
    /// A builder for [`ListHyperParameterTuningJobsOutput`](crate::output::ListHyperParameterTuningJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hyper_parameter_tuning_job_summaries:
            std::option::Option<std::vec::Vec<crate::model::HyperParameterTuningJobSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `hyper_parameter_tuning_job_summaries`.
        ///
        /// To override the contents of this collection use [`set_hyper_parameter_tuning_job_summaries`](Self::set_hyper_parameter_tuning_job_summaries).
        ///
        /// <p>A list of <code>HyperParameterTuningJobSummary</code> objects that describe the tuning jobs that the <code>ListHyperParameterTuningJobs</code> request returned.</p>
        pub fn hyper_parameter_tuning_job_summaries(
            mut self,
            input: crate::model::HyperParameterTuningJobSummary,
        ) -> Self {
            let mut v = self
                .hyper_parameter_tuning_job_summaries
                .unwrap_or_default();
            v.push(input);
            self.hyper_parameter_tuning_job_summaries = Some(v);
            self
        }
        /// <p>A list of <code>HyperParameterTuningJobSummary</code> objects that describe the tuning jobs that the <code>ListHyperParameterTuningJobs</code> request returned.</p>
        pub fn set_hyper_parameter_tuning_job_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HyperParameterTuningJobSummary>>,
        ) -> Self {
            self.hyper_parameter_tuning_job_summaries = input;
            self
        }
        /// <p>If the result of this <code>ListHyperParameterTuningJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of tuning jobs, use the token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the result of this <code>ListHyperParameterTuningJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of tuning jobs, use the token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListHyperParameterTuningJobsOutput`](crate::output::ListHyperParameterTuningJobsOutput)
        pub fn build(self) -> crate::output::ListHyperParameterTuningJobsOutput {
            crate::output::ListHyperParameterTuningJobsOutput {
                hyper_parameter_tuning_job_summaries: self.hyper_parameter_tuning_job_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListHyperParameterTuningJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListHyperParameterTuningJobsOutput`](crate::output::ListHyperParameterTuningJobsOutput)
    pub fn builder() -> crate::output::list_hyper_parameter_tuning_jobs_output::Builder {
        crate::output::list_hyper_parameter_tuning_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListHumanTaskUisOutput {
    /// <p>An array of objects describing the human task user interfaces.</p>
    pub human_task_ui_summaries:
        std::option::Option<std::vec::Vec<crate::model::HumanTaskUiSummary>>,
    /// <p>A token to resume pagination.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListHumanTaskUisOutput {
    /// <p>An array of objects describing the human task user interfaces.</p>
    pub fn human_task_ui_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::HumanTaskUiSummary]> {
        self.human_task_ui_summaries.as_deref()
    }
    /// <p>A token to resume pagination.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListHumanTaskUisOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListHumanTaskUisOutput");
        formatter.field("human_task_ui_summaries", &self.human_task_ui_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListHumanTaskUisOutput`](crate::output::ListHumanTaskUisOutput)
pub mod list_human_task_uis_output {
    /// A builder for [`ListHumanTaskUisOutput`](crate::output::ListHumanTaskUisOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) human_task_ui_summaries:
            std::option::Option<std::vec::Vec<crate::model::HumanTaskUiSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `human_task_ui_summaries`.
        ///
        /// To override the contents of this collection use [`set_human_task_ui_summaries`](Self::set_human_task_ui_summaries).
        ///
        /// <p>An array of objects describing the human task user interfaces.</p>
        pub fn human_task_ui_summaries(mut self, input: crate::model::HumanTaskUiSummary) -> Self {
            let mut v = self.human_task_ui_summaries.unwrap_or_default();
            v.push(input);
            self.human_task_ui_summaries = Some(v);
            self
        }
        /// <p>An array of objects describing the human task user interfaces.</p>
        pub fn set_human_task_ui_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HumanTaskUiSummary>>,
        ) -> Self {
            self.human_task_ui_summaries = input;
            self
        }
        /// <p>A token to resume pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to resume pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListHumanTaskUisOutput`](crate::output::ListHumanTaskUisOutput)
        pub fn build(self) -> crate::output::ListHumanTaskUisOutput {
            crate::output::ListHumanTaskUisOutput {
                human_task_ui_summaries: self.human_task_ui_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListHumanTaskUisOutput {
    /// Creates a new builder-style object to manufacture [`ListHumanTaskUisOutput`](crate::output::ListHumanTaskUisOutput)
    pub fn builder() -> crate::output::list_human_task_uis_output::Builder {
        crate::output::list_human_task_uis_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFlowDefinitionsOutput {
    /// <p>An array of objects describing the flow definitions.</p>
    pub flow_definition_summaries:
        std::option::Option<std::vec::Vec<crate::model::FlowDefinitionSummary>>,
    /// <p>A token to resume pagination.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFlowDefinitionsOutput {
    /// <p>An array of objects describing the flow definitions.</p>
    pub fn flow_definition_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::FlowDefinitionSummary]> {
        self.flow_definition_summaries.as_deref()
    }
    /// <p>A token to resume pagination.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFlowDefinitionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFlowDefinitionsOutput");
        formatter.field("flow_definition_summaries", &self.flow_definition_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListFlowDefinitionsOutput`](crate::output::ListFlowDefinitionsOutput)
pub mod list_flow_definitions_output {
    /// A builder for [`ListFlowDefinitionsOutput`](crate::output::ListFlowDefinitionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_definition_summaries:
            std::option::Option<std::vec::Vec<crate::model::FlowDefinitionSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `flow_definition_summaries`.
        ///
        /// To override the contents of this collection use [`set_flow_definition_summaries`](Self::set_flow_definition_summaries).
        ///
        /// <p>An array of objects describing the flow definitions.</p>
        pub fn flow_definition_summaries(
            mut self,
            input: crate::model::FlowDefinitionSummary,
        ) -> Self {
            let mut v = self.flow_definition_summaries.unwrap_or_default();
            v.push(input);
            self.flow_definition_summaries = Some(v);
            self
        }
        /// <p>An array of objects describing the flow definitions.</p>
        pub fn set_flow_definition_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FlowDefinitionSummary>>,
        ) -> Self {
            self.flow_definition_summaries = input;
            self
        }
        /// <p>A token to resume pagination.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to resume pagination.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFlowDefinitionsOutput`](crate::output::ListFlowDefinitionsOutput)
        pub fn build(self) -> crate::output::ListFlowDefinitionsOutput {
            crate::output::ListFlowDefinitionsOutput {
                flow_definition_summaries: self.flow_definition_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListFlowDefinitionsOutput {
    /// Creates a new builder-style object to manufacture [`ListFlowDefinitionsOutput`](crate::output::ListFlowDefinitionsOutput)
    pub fn builder() -> crate::output::list_flow_definitions_output::Builder {
        crate::output::list_flow_definitions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFeatureGroupsOutput {
    /// <p>A summary of feature groups.</p>
    pub feature_group_summaries:
        std::option::Option<std::vec::Vec<crate::model::FeatureGroupSummary>>,
    /// <p>A token to resume pagination of <code>ListFeatureGroups</code> results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFeatureGroupsOutput {
    /// <p>A summary of feature groups.</p>
    pub fn feature_group_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::FeatureGroupSummary]> {
        self.feature_group_summaries.as_deref()
    }
    /// <p>A token to resume pagination of <code>ListFeatureGroups</code> results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFeatureGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFeatureGroupsOutput");
        formatter.field("feature_group_summaries", &self.feature_group_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListFeatureGroupsOutput`](crate::output::ListFeatureGroupsOutput)
pub mod list_feature_groups_output {
    /// A builder for [`ListFeatureGroupsOutput`](crate::output::ListFeatureGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) feature_group_summaries:
            std::option::Option<std::vec::Vec<crate::model::FeatureGroupSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `feature_group_summaries`.
        ///
        /// To override the contents of this collection use [`set_feature_group_summaries`](Self::set_feature_group_summaries).
        ///
        /// <p>A summary of feature groups.</p>
        pub fn feature_group_summaries(mut self, input: crate::model::FeatureGroupSummary) -> Self {
            let mut v = self.feature_group_summaries.unwrap_or_default();
            v.push(input);
            self.feature_group_summaries = Some(v);
            self
        }
        /// <p>A summary of feature groups.</p>
        pub fn set_feature_group_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FeatureGroupSummary>>,
        ) -> Self {
            self.feature_group_summaries = input;
            self
        }
        /// <p>A token to resume pagination of <code>ListFeatureGroups</code> results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to resume pagination of <code>ListFeatureGroups</code> results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFeatureGroupsOutput`](crate::output::ListFeatureGroupsOutput)
        pub fn build(self) -> crate::output::ListFeatureGroupsOutput {
            crate::output::ListFeatureGroupsOutput {
                feature_group_summaries: self.feature_group_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListFeatureGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListFeatureGroupsOutput`](crate::output::ListFeatureGroupsOutput)
    pub fn builder() -> crate::output::list_feature_groups_output::Builder {
        crate::output::list_feature_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListExperimentsOutput {
    /// <p>A list of the summaries of your experiments.</p>
    pub experiment_summaries: std::option::Option<std::vec::Vec<crate::model::ExperimentSummary>>,
    /// <p>A token for getting the next set of experiments, if there are any.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListExperimentsOutput {
    /// <p>A list of the summaries of your experiments.</p>
    pub fn experiment_summaries(&self) -> std::option::Option<&[crate::model::ExperimentSummary]> {
        self.experiment_summaries.as_deref()
    }
    /// <p>A token for getting the next set of experiments, if there are any.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListExperimentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListExperimentsOutput");
        formatter.field("experiment_summaries", &self.experiment_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListExperimentsOutput`](crate::output::ListExperimentsOutput)
pub mod list_experiments_output {
    /// A builder for [`ListExperimentsOutput`](crate::output::ListExperimentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) experiment_summaries:
            std::option::Option<std::vec::Vec<crate::model::ExperimentSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `experiment_summaries`.
        ///
        /// To override the contents of this collection use [`set_experiment_summaries`](Self::set_experiment_summaries).
        ///
        /// <p>A list of the summaries of your experiments.</p>
        pub fn experiment_summaries(mut self, input: crate::model::ExperimentSummary) -> Self {
            let mut v = self.experiment_summaries.unwrap_or_default();
            v.push(input);
            self.experiment_summaries = Some(v);
            self
        }
        /// <p>A list of the summaries of your experiments.</p>
        pub fn set_experiment_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExperimentSummary>>,
        ) -> Self {
            self.experiment_summaries = input;
            self
        }
        /// <p>A token for getting the next set of experiments, if there are any.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token for getting the next set of experiments, if there are any.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListExperimentsOutput`](crate::output::ListExperimentsOutput)
        pub fn build(self) -> crate::output::ListExperimentsOutput {
            crate::output::ListExperimentsOutput {
                experiment_summaries: self.experiment_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListExperimentsOutput {
    /// Creates a new builder-style object to manufacture [`ListExperimentsOutput`](crate::output::ListExperimentsOutput)
    pub fn builder() -> crate::output::list_experiments_output::Builder {
        crate::output::list_experiments_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEndpointsOutput {
    /// <p> An array or endpoint objects. </p>
    pub endpoints: std::option::Option<std::vec::Vec<crate::model::EndpointSummary>>,
    /// <p> If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of training jobs, use it in the subsequent request. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListEndpointsOutput {
    /// <p> An array or endpoint objects. </p>
    pub fn endpoints(&self) -> std::option::Option<&[crate::model::EndpointSummary]> {
        self.endpoints.as_deref()
    }
    /// <p> If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of training jobs, use it in the subsequent request. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListEndpointsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEndpointsOutput");
        formatter.field("endpoints", &self.endpoints);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListEndpointsOutput`](crate::output::ListEndpointsOutput)
pub mod list_endpoints_output {
    /// A builder for [`ListEndpointsOutput`](crate::output::ListEndpointsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoints: std::option::Option<std::vec::Vec<crate::model::EndpointSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `endpoints`.
        ///
        /// To override the contents of this collection use [`set_endpoints`](Self::set_endpoints).
        ///
        /// <p> An array or endpoint objects. </p>
        pub fn endpoints(mut self, input: crate::model::EndpointSummary) -> Self {
            let mut v = self.endpoints.unwrap_or_default();
            v.push(input);
            self.endpoints = Some(v);
            self
        }
        /// <p> An array or endpoint objects. </p>
        pub fn set_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EndpointSummary>>,
        ) -> Self {
            self.endpoints = input;
            self
        }
        /// <p> If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of training jobs, use it in the subsequent request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of training jobs, use it in the subsequent request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEndpointsOutput`](crate::output::ListEndpointsOutput)
        pub fn build(self) -> crate::output::ListEndpointsOutput {
            crate::output::ListEndpointsOutput {
                endpoints: self.endpoints,
                next_token: self.next_token,
            }
        }
    }
}
impl ListEndpointsOutput {
    /// Creates a new builder-style object to manufacture [`ListEndpointsOutput`](crate::output::ListEndpointsOutput)
    pub fn builder() -> crate::output::list_endpoints_output::Builder {
        crate::output::list_endpoints_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEndpointConfigsOutput {
    /// <p>An array of endpoint configurations.</p>
    pub endpoint_configs: std::option::Option<std::vec::Vec<crate::model::EndpointConfigSummary>>,
    /// <p> If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of endpoint configurations, use it in the subsequent request </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListEndpointConfigsOutput {
    /// <p>An array of endpoint configurations.</p>
    pub fn endpoint_configs(&self) -> std::option::Option<&[crate::model::EndpointConfigSummary]> {
        self.endpoint_configs.as_deref()
    }
    /// <p> If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of endpoint configurations, use it in the subsequent request </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListEndpointConfigsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEndpointConfigsOutput");
        formatter.field("endpoint_configs", &self.endpoint_configs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListEndpointConfigsOutput`](crate::output::ListEndpointConfigsOutput)
pub mod list_endpoint_configs_output {
    /// A builder for [`ListEndpointConfigsOutput`](crate::output::ListEndpointConfigsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_configs:
            std::option::Option<std::vec::Vec<crate::model::EndpointConfigSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `endpoint_configs`.
        ///
        /// To override the contents of this collection use [`set_endpoint_configs`](Self::set_endpoint_configs).
        ///
        /// <p>An array of endpoint configurations.</p>
        pub fn endpoint_configs(mut self, input: crate::model::EndpointConfigSummary) -> Self {
            let mut v = self.endpoint_configs.unwrap_or_default();
            v.push(input);
            self.endpoint_configs = Some(v);
            self
        }
        /// <p>An array of endpoint configurations.</p>
        pub fn set_endpoint_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EndpointConfigSummary>>,
        ) -> Self {
            self.endpoint_configs = input;
            self
        }
        /// <p> If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of endpoint configurations, use it in the subsequent request </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of endpoint configurations, use it in the subsequent request </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEndpointConfigsOutput`](crate::output::ListEndpointConfigsOutput)
        pub fn build(self) -> crate::output::ListEndpointConfigsOutput {
            crate::output::ListEndpointConfigsOutput {
                endpoint_configs: self.endpoint_configs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListEndpointConfigsOutput {
    /// Creates a new builder-style object to manufacture [`ListEndpointConfigsOutput`](crate::output::ListEndpointConfigsOutput)
    pub fn builder() -> crate::output::list_endpoint_configs_output::Builder {
        crate::output::list_endpoint_configs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEdgePackagingJobsOutput {
    /// <p>Summaries of edge packaging jobs.</p>
    pub edge_packaging_job_summaries:
        std::option::Option<std::vec::Vec<crate::model::EdgePackagingJobSummary>>,
    /// <p>Token to use when calling the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListEdgePackagingJobsOutput {
    /// <p>Summaries of edge packaging jobs.</p>
    pub fn edge_packaging_job_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::EdgePackagingJobSummary]> {
        self.edge_packaging_job_summaries.as_deref()
    }
    /// <p>Token to use when calling the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListEdgePackagingJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEdgePackagingJobsOutput");
        formatter.field(
            "edge_packaging_job_summaries",
            &self.edge_packaging_job_summaries,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListEdgePackagingJobsOutput`](crate::output::ListEdgePackagingJobsOutput)
pub mod list_edge_packaging_jobs_output {
    /// A builder for [`ListEdgePackagingJobsOutput`](crate::output::ListEdgePackagingJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) edge_packaging_job_summaries:
            std::option::Option<std::vec::Vec<crate::model::EdgePackagingJobSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `edge_packaging_job_summaries`.
        ///
        /// To override the contents of this collection use [`set_edge_packaging_job_summaries`](Self::set_edge_packaging_job_summaries).
        ///
        /// <p>Summaries of edge packaging jobs.</p>
        pub fn edge_packaging_job_summaries(
            mut self,
            input: crate::model::EdgePackagingJobSummary,
        ) -> Self {
            let mut v = self.edge_packaging_job_summaries.unwrap_or_default();
            v.push(input);
            self.edge_packaging_job_summaries = Some(v);
            self
        }
        /// <p>Summaries of edge packaging jobs.</p>
        pub fn set_edge_packaging_job_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EdgePackagingJobSummary>>,
        ) -> Self {
            self.edge_packaging_job_summaries = input;
            self
        }
        /// <p>Token to use when calling the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Token to use when calling the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEdgePackagingJobsOutput`](crate::output::ListEdgePackagingJobsOutput)
        pub fn build(self) -> crate::output::ListEdgePackagingJobsOutput {
            crate::output::ListEdgePackagingJobsOutput {
                edge_packaging_job_summaries: self.edge_packaging_job_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListEdgePackagingJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListEdgePackagingJobsOutput`](crate::output::ListEdgePackagingJobsOutput)
    pub fn builder() -> crate::output::list_edge_packaging_jobs_output::Builder {
        crate::output::list_edge_packaging_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDomainsOutput {
    /// <p>The list of domains.</p>
    pub domains: std::option::Option<std::vec::Vec<crate::model::DomainDetails>>,
    /// <p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDomainsOutput {
    /// <p>The list of domains.</p>
    pub fn domains(&self) -> std::option::Option<&[crate::model::DomainDetails]> {
        self.domains.as_deref()
    }
    /// <p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDomainsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDomainsOutput");
        formatter.field("domains", &self.domains);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDomainsOutput`](crate::output::ListDomainsOutput)
pub mod list_domains_output {
    /// A builder for [`ListDomainsOutput`](crate::output::ListDomainsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domains: std::option::Option<std::vec::Vec<crate::model::DomainDetails>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `domains`.
        ///
        /// To override the contents of this collection use [`set_domains`](Self::set_domains).
        ///
        /// <p>The list of domains.</p>
        pub fn domains(mut self, input: crate::model::DomainDetails) -> Self {
            let mut v = self.domains.unwrap_or_default();
            v.push(input);
            self.domains = Some(v);
            self
        }
        /// <p>The list of domains.</p>
        pub fn set_domains(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainDetails>>,
        ) -> Self {
            self.domains = input;
            self
        }
        /// <p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDomainsOutput`](crate::output::ListDomainsOutput)
        pub fn build(self) -> crate::output::ListDomainsOutput {
            crate::output::ListDomainsOutput {
                domains: self.domains,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDomainsOutput {
    /// Creates a new builder-style object to manufacture [`ListDomainsOutput`](crate::output::ListDomainsOutput)
    pub fn builder() -> crate::output::list_domains_output::Builder {
        crate::output::list_domains_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDevicesOutput {
    /// <p>Summary of devices.</p>
    pub device_summaries: std::option::Option<std::vec::Vec<crate::model::DeviceSummary>>,
    /// <p>The response from the last list when returning a list large enough to need tokening.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDevicesOutput {
    /// <p>Summary of devices.</p>
    pub fn device_summaries(&self) -> std::option::Option<&[crate::model::DeviceSummary]> {
        self.device_summaries.as_deref()
    }
    /// <p>The response from the last list when returning a list large enough to need tokening.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDevicesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDevicesOutput");
        formatter.field("device_summaries", &self.device_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDevicesOutput`](crate::output::ListDevicesOutput)
pub mod list_devices_output {
    /// A builder for [`ListDevicesOutput`](crate::output::ListDevicesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_summaries:
            std::option::Option<std::vec::Vec<crate::model::DeviceSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `device_summaries`.
        ///
        /// To override the contents of this collection use [`set_device_summaries`](Self::set_device_summaries).
        ///
        /// <p>Summary of devices.</p>
        pub fn device_summaries(mut self, input: crate::model::DeviceSummary) -> Self {
            let mut v = self.device_summaries.unwrap_or_default();
            v.push(input);
            self.device_summaries = Some(v);
            self
        }
        /// <p>Summary of devices.</p>
        pub fn set_device_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeviceSummary>>,
        ) -> Self {
            self.device_summaries = input;
            self
        }
        /// <p>The response from the last list when returning a list large enough to need tokening.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The response from the last list when returning a list large enough to need tokening.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDevicesOutput`](crate::output::ListDevicesOutput)
        pub fn build(self) -> crate::output::ListDevicesOutput {
            crate::output::ListDevicesOutput {
                device_summaries: self.device_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDevicesOutput {
    /// Creates a new builder-style object to manufacture [`ListDevicesOutput`](crate::output::ListDevicesOutput)
    pub fn builder() -> crate::output::list_devices_output::Builder {
        crate::output::list_devices_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDeviceFleetsOutput {
    /// <p>Summary of the device fleet.</p>
    pub device_fleet_summaries:
        std::option::Option<std::vec::Vec<crate::model::DeviceFleetSummary>>,
    /// <p>The response from the last list when returning a list large enough to need tokening.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDeviceFleetsOutput {
    /// <p>Summary of the device fleet.</p>
    pub fn device_fleet_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::DeviceFleetSummary]> {
        self.device_fleet_summaries.as_deref()
    }
    /// <p>The response from the last list when returning a list large enough to need tokening.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDeviceFleetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDeviceFleetsOutput");
        formatter.field("device_fleet_summaries", &self.device_fleet_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDeviceFleetsOutput`](crate::output::ListDeviceFleetsOutput)
pub mod list_device_fleets_output {
    /// A builder for [`ListDeviceFleetsOutput`](crate::output::ListDeviceFleetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_fleet_summaries:
            std::option::Option<std::vec::Vec<crate::model::DeviceFleetSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `device_fleet_summaries`.
        ///
        /// To override the contents of this collection use [`set_device_fleet_summaries`](Self::set_device_fleet_summaries).
        ///
        /// <p>Summary of the device fleet.</p>
        pub fn device_fleet_summaries(mut self, input: crate::model::DeviceFleetSummary) -> Self {
            let mut v = self.device_fleet_summaries.unwrap_or_default();
            v.push(input);
            self.device_fleet_summaries = Some(v);
            self
        }
        /// <p>Summary of the device fleet.</p>
        pub fn set_device_fleet_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeviceFleetSummary>>,
        ) -> Self {
            self.device_fleet_summaries = input;
            self
        }
        /// <p>The response from the last list when returning a list large enough to need tokening.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The response from the last list when returning a list large enough to need tokening.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDeviceFleetsOutput`](crate::output::ListDeviceFleetsOutput)
        pub fn build(self) -> crate::output::ListDeviceFleetsOutput {
            crate::output::ListDeviceFleetsOutput {
                device_fleet_summaries: self.device_fleet_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDeviceFleetsOutput {
    /// Creates a new builder-style object to manufacture [`ListDeviceFleetsOutput`](crate::output::ListDeviceFleetsOutput)
    pub fn builder() -> crate::output::list_device_fleets_output::Builder {
        crate::output::list_device_fleets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDataQualityJobDefinitionsOutput {
    /// <p>A list of data quality monitoring job definitions.</p>
    pub job_definition_summaries:
        std::option::Option<std::vec::Vec<crate::model::MonitoringJobDefinitionSummary>>,
    /// <p>If the result of the previous <code>ListDataQualityJobDefinitions</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of data quality monitoring job definitions, use the token in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDataQualityJobDefinitionsOutput {
    /// <p>A list of data quality monitoring job definitions.</p>
    pub fn job_definition_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::MonitoringJobDefinitionSummary]> {
        self.job_definition_summaries.as_deref()
    }
    /// <p>If the result of the previous <code>ListDataQualityJobDefinitions</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of data quality monitoring job definitions, use the token in the next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDataQualityJobDefinitionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDataQualityJobDefinitionsOutput");
        formatter.field("job_definition_summaries", &self.job_definition_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDataQualityJobDefinitionsOutput`](crate::output::ListDataQualityJobDefinitionsOutput)
pub mod list_data_quality_job_definitions_output {
    /// A builder for [`ListDataQualityJobDefinitionsOutput`](crate::output::ListDataQualityJobDefinitionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_definition_summaries:
            std::option::Option<std::vec::Vec<crate::model::MonitoringJobDefinitionSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `job_definition_summaries`.
        ///
        /// To override the contents of this collection use [`set_job_definition_summaries`](Self::set_job_definition_summaries).
        ///
        /// <p>A list of data quality monitoring job definitions.</p>
        pub fn job_definition_summaries(
            mut self,
            input: crate::model::MonitoringJobDefinitionSummary,
        ) -> Self {
            let mut v = self.job_definition_summaries.unwrap_or_default();
            v.push(input);
            self.job_definition_summaries = Some(v);
            self
        }
        /// <p>A list of data quality monitoring job definitions.</p>
        pub fn set_job_definition_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MonitoringJobDefinitionSummary>>,
        ) -> Self {
            self.job_definition_summaries = input;
            self
        }
        /// <p>If the result of the previous <code>ListDataQualityJobDefinitions</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of data quality monitoring job definitions, use the token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the result of the previous <code>ListDataQualityJobDefinitions</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of data quality monitoring job definitions, use the token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDataQualityJobDefinitionsOutput`](crate::output::ListDataQualityJobDefinitionsOutput)
        pub fn build(self) -> crate::output::ListDataQualityJobDefinitionsOutput {
            crate::output::ListDataQualityJobDefinitionsOutput {
                job_definition_summaries: self.job_definition_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDataQualityJobDefinitionsOutput {
    /// Creates a new builder-style object to manufacture [`ListDataQualityJobDefinitionsOutput`](crate::output::ListDataQualityJobDefinitionsOutput)
    pub fn builder() -> crate::output::list_data_quality_job_definitions_output::Builder {
        crate::output::list_data_quality_job_definitions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListContextsOutput {
    /// <p>A list of contexts and their properties.</p>
    pub context_summaries: std::option::Option<std::vec::Vec<crate::model::ContextSummary>>,
    /// <p>A token for getting the next set of contexts, if there are any.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListContextsOutput {
    /// <p>A list of contexts and their properties.</p>
    pub fn context_summaries(&self) -> std::option::Option<&[crate::model::ContextSummary]> {
        self.context_summaries.as_deref()
    }
    /// <p>A token for getting the next set of contexts, if there are any.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListContextsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListContextsOutput");
        formatter.field("context_summaries", &self.context_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListContextsOutput`](crate::output::ListContextsOutput)
pub mod list_contexts_output {
    /// A builder for [`ListContextsOutput`](crate::output::ListContextsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) context_summaries:
            std::option::Option<std::vec::Vec<crate::model::ContextSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `context_summaries`.
        ///
        /// To override the contents of this collection use [`set_context_summaries`](Self::set_context_summaries).
        ///
        /// <p>A list of contexts and their properties.</p>
        pub fn context_summaries(mut self, input: crate::model::ContextSummary) -> Self {
            let mut v = self.context_summaries.unwrap_or_default();
            v.push(input);
            self.context_summaries = Some(v);
            self
        }
        /// <p>A list of contexts and their properties.</p>
        pub fn set_context_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContextSummary>>,
        ) -> Self {
            self.context_summaries = input;
            self
        }
        /// <p>A token for getting the next set of contexts, if there are any.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token for getting the next set of contexts, if there are any.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListContextsOutput`](crate::output::ListContextsOutput)
        pub fn build(self) -> crate::output::ListContextsOutput {
            crate::output::ListContextsOutput {
                context_summaries: self.context_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListContextsOutput {
    /// Creates a new builder-style object to manufacture [`ListContextsOutput`](crate::output::ListContextsOutput)
    pub fn builder() -> crate::output::list_contexts_output::Builder {
        crate::output::list_contexts_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCompilationJobsOutput {
    /// <p>An array of <code>CompilationJobSummary</code> objects, each describing a model compilation job. </p>
    pub compilation_job_summaries:
        std::option::Option<std::vec::Vec<crate::model::CompilationJobSummary>>,
    /// <p>If the response is truncated, Amazon SageMaker returns this <code>NextToken</code>. To retrieve the next set of model compilation jobs, use this token in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListCompilationJobsOutput {
    /// <p>An array of <code>CompilationJobSummary</code> objects, each describing a model compilation job. </p>
    pub fn compilation_job_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::CompilationJobSummary]> {
        self.compilation_job_summaries.as_deref()
    }
    /// <p>If the response is truncated, Amazon SageMaker returns this <code>NextToken</code>. To retrieve the next set of model compilation jobs, use this token in the next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListCompilationJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCompilationJobsOutput");
        formatter.field("compilation_job_summaries", &self.compilation_job_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListCompilationJobsOutput`](crate::output::ListCompilationJobsOutput)
pub mod list_compilation_jobs_output {
    /// A builder for [`ListCompilationJobsOutput`](crate::output::ListCompilationJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compilation_job_summaries:
            std::option::Option<std::vec::Vec<crate::model::CompilationJobSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `compilation_job_summaries`.
        ///
        /// To override the contents of this collection use [`set_compilation_job_summaries`](Self::set_compilation_job_summaries).
        ///
        /// <p>An array of <code>CompilationJobSummary</code> objects, each describing a model compilation job. </p>
        pub fn compilation_job_summaries(
            mut self,
            input: crate::model::CompilationJobSummary,
        ) -> Self {
            let mut v = self.compilation_job_summaries.unwrap_or_default();
            v.push(input);
            self.compilation_job_summaries = Some(v);
            self
        }
        /// <p>An array of <code>CompilationJobSummary</code> objects, each describing a model compilation job. </p>
        pub fn set_compilation_job_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CompilationJobSummary>>,
        ) -> Self {
            self.compilation_job_summaries = input;
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this <code>NextToken</code>. To retrieve the next set of model compilation jobs, use this token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this <code>NextToken</code>. To retrieve the next set of model compilation jobs, use this token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCompilationJobsOutput`](crate::output::ListCompilationJobsOutput)
        pub fn build(self) -> crate::output::ListCompilationJobsOutput {
            crate::output::ListCompilationJobsOutput {
                compilation_job_summaries: self.compilation_job_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListCompilationJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListCompilationJobsOutput`](crate::output::ListCompilationJobsOutput)
    pub fn builder() -> crate::output::list_compilation_jobs_output::Builder {
        crate::output::list_compilation_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCodeRepositoriesOutput {
    /// <p>Gets a list of summaries of the Git repositories. Each summary specifies the following values for the repository: </p>
    /// <ul>
    /// <li> <p>Name</p> </li>
    /// <li> <p>Amazon Resource Name (ARN)</p> </li>
    /// <li> <p>Creation time</p> </li>
    /// <li> <p>Last modified time</p> </li>
    /// <li> <p>Configuration information, including the URL location of the repository and the ARN of the Amazon Web Services Secrets Manager secret that contains the credentials used to access the repository.</p> </li>
    /// </ul>
    pub code_repository_summary_list:
        std::option::Option<std::vec::Vec<crate::model::CodeRepositorySummary>>,
    /// <p>If the result of a <code>ListCodeRepositoriesOutput</code> request was truncated, the response includes a <code>NextToken</code>. To get the next set of Git repositories, use the token in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListCodeRepositoriesOutput {
    /// <p>Gets a list of summaries of the Git repositories. Each summary specifies the following values for the repository: </p>
    /// <ul>
    /// <li> <p>Name</p> </li>
    /// <li> <p>Amazon Resource Name (ARN)</p> </li>
    /// <li> <p>Creation time</p> </li>
    /// <li> <p>Last modified time</p> </li>
    /// <li> <p>Configuration information, including the URL location of the repository and the ARN of the Amazon Web Services Secrets Manager secret that contains the credentials used to access the repository.</p> </li>
    /// </ul>
    pub fn code_repository_summary_list(
        &self,
    ) -> std::option::Option<&[crate::model::CodeRepositorySummary]> {
        self.code_repository_summary_list.as_deref()
    }
    /// <p>If the result of a <code>ListCodeRepositoriesOutput</code> request was truncated, the response includes a <code>NextToken</code>. To get the next set of Git repositories, use the token in the next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListCodeRepositoriesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCodeRepositoriesOutput");
        formatter.field(
            "code_repository_summary_list",
            &self.code_repository_summary_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListCodeRepositoriesOutput`](crate::output::ListCodeRepositoriesOutput)
pub mod list_code_repositories_output {
    /// A builder for [`ListCodeRepositoriesOutput`](crate::output::ListCodeRepositoriesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code_repository_summary_list:
            std::option::Option<std::vec::Vec<crate::model::CodeRepositorySummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `code_repository_summary_list`.
        ///
        /// To override the contents of this collection use [`set_code_repository_summary_list`](Self::set_code_repository_summary_list).
        ///
        /// <p>Gets a list of summaries of the Git repositories. Each summary specifies the following values for the repository: </p>
        /// <ul>
        /// <li> <p>Name</p> </li>
        /// <li> <p>Amazon Resource Name (ARN)</p> </li>
        /// <li> <p>Creation time</p> </li>
        /// <li> <p>Last modified time</p> </li>
        /// <li> <p>Configuration information, including the URL location of the repository and the ARN of the Amazon Web Services Secrets Manager secret that contains the credentials used to access the repository.</p> </li>
        /// </ul>
        pub fn code_repository_summary_list(
            mut self,
            input: crate::model::CodeRepositorySummary,
        ) -> Self {
            let mut v = self.code_repository_summary_list.unwrap_or_default();
            v.push(input);
            self.code_repository_summary_list = Some(v);
            self
        }
        /// <p>Gets a list of summaries of the Git repositories. Each summary specifies the following values for the repository: </p>
        /// <ul>
        /// <li> <p>Name</p> </li>
        /// <li> <p>Amazon Resource Name (ARN)</p> </li>
        /// <li> <p>Creation time</p> </li>
        /// <li> <p>Last modified time</p> </li>
        /// <li> <p>Configuration information, including the URL location of the repository and the ARN of the Amazon Web Services Secrets Manager secret that contains the credentials used to access the repository.</p> </li>
        /// </ul>
        pub fn set_code_repository_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CodeRepositorySummary>>,
        ) -> Self {
            self.code_repository_summary_list = input;
            self
        }
        /// <p>If the result of a <code>ListCodeRepositoriesOutput</code> request was truncated, the response includes a <code>NextToken</code>. To get the next set of Git repositories, use the token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the result of a <code>ListCodeRepositoriesOutput</code> request was truncated, the response includes a <code>NextToken</code>. To get the next set of Git repositories, use the token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCodeRepositoriesOutput`](crate::output::ListCodeRepositoriesOutput)
        pub fn build(self) -> crate::output::ListCodeRepositoriesOutput {
            crate::output::ListCodeRepositoriesOutput {
                code_repository_summary_list: self.code_repository_summary_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListCodeRepositoriesOutput {
    /// Creates a new builder-style object to manufacture [`ListCodeRepositoriesOutput`](crate::output::ListCodeRepositoriesOutput)
    pub fn builder() -> crate::output::list_code_repositories_output::Builder {
        crate::output::list_code_repositories_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCandidatesForAutoMlJobOutput {
    /// <p>Summaries about the <code>AutoMLCandidates</code>.</p>
    pub candidates: std::option::Option<std::vec::Vec<crate::model::AutoMlCandidate>>,
    /// <p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListCandidatesForAutoMlJobOutput {
    /// <p>Summaries about the <code>AutoMLCandidates</code>.</p>
    pub fn candidates(&self) -> std::option::Option<&[crate::model::AutoMlCandidate]> {
        self.candidates.as_deref()
    }
    /// <p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListCandidatesForAutoMlJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCandidatesForAutoMlJobOutput");
        formatter.field("candidates", &self.candidates);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListCandidatesForAutoMlJobOutput`](crate::output::ListCandidatesForAutoMlJobOutput)
pub mod list_candidates_for_auto_ml_job_output {
    /// A builder for [`ListCandidatesForAutoMlJobOutput`](crate::output::ListCandidatesForAutoMlJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) candidates: std::option::Option<std::vec::Vec<crate::model::AutoMlCandidate>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `candidates`.
        ///
        /// To override the contents of this collection use [`set_candidates`](Self::set_candidates).
        ///
        /// <p>Summaries about the <code>AutoMLCandidates</code>.</p>
        pub fn candidates(mut self, input: crate::model::AutoMlCandidate) -> Self {
            let mut v = self.candidates.unwrap_or_default();
            v.push(input);
            self.candidates = Some(v);
            self
        }
        /// <p>Summaries about the <code>AutoMLCandidates</code>.</p>
        pub fn set_candidates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AutoMlCandidate>>,
        ) -> Self {
            self.candidates = input;
            self
        }
        /// <p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCandidatesForAutoMlJobOutput`](crate::output::ListCandidatesForAutoMlJobOutput)
        pub fn build(self) -> crate::output::ListCandidatesForAutoMlJobOutput {
            crate::output::ListCandidatesForAutoMlJobOutput {
                candidates: self.candidates,
                next_token: self.next_token,
            }
        }
    }
}
impl ListCandidatesForAutoMlJobOutput {
    /// Creates a new builder-style object to manufacture [`ListCandidatesForAutoMlJobOutput`](crate::output::ListCandidatesForAutoMlJobOutput)
    pub fn builder() -> crate::output::list_candidates_for_auto_ml_job_output::Builder {
        crate::output::list_candidates_for_auto_ml_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAutoMlJobsOutput {
    /// <p>Returns a summary list of jobs.</p>
    pub auto_ml_job_summaries: std::option::Option<std::vec::Vec<crate::model::AutoMlJobSummary>>,
    /// <p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAutoMlJobsOutput {
    /// <p>Returns a summary list of jobs.</p>
    pub fn auto_ml_job_summaries(&self) -> std::option::Option<&[crate::model::AutoMlJobSummary]> {
        self.auto_ml_job_summaries.as_deref()
    }
    /// <p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAutoMlJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAutoMlJobsOutput");
        formatter.field("auto_ml_job_summaries", &self.auto_ml_job_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAutoMlJobsOutput`](crate::output::ListAutoMlJobsOutput)
pub mod list_auto_ml_jobs_output {
    /// A builder for [`ListAutoMlJobsOutput`](crate::output::ListAutoMlJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_ml_job_summaries:
            std::option::Option<std::vec::Vec<crate::model::AutoMlJobSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `auto_ml_job_summaries`.
        ///
        /// To override the contents of this collection use [`set_auto_ml_job_summaries`](Self::set_auto_ml_job_summaries).
        ///
        /// <p>Returns a summary list of jobs.</p>
        pub fn auto_ml_job_summaries(mut self, input: crate::model::AutoMlJobSummary) -> Self {
            let mut v = self.auto_ml_job_summaries.unwrap_or_default();
            v.push(input);
            self.auto_ml_job_summaries = Some(v);
            self
        }
        /// <p>Returns a summary list of jobs.</p>
        pub fn set_auto_ml_job_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AutoMlJobSummary>>,
        ) -> Self {
            self.auto_ml_job_summaries = input;
            self
        }
        /// <p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAutoMlJobsOutput`](crate::output::ListAutoMlJobsOutput)
        pub fn build(self) -> crate::output::ListAutoMlJobsOutput {
            crate::output::ListAutoMlJobsOutput {
                auto_ml_job_summaries: self.auto_ml_job_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAutoMlJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListAutoMlJobsOutput`](crate::output::ListAutoMlJobsOutput)
    pub fn builder() -> crate::output::list_auto_ml_jobs_output::Builder {
        crate::output::list_auto_ml_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssociationsOutput {
    /// <p>A list of associations and their properties.</p>
    pub association_summaries: std::option::Option<std::vec::Vec<crate::model::AssociationSummary>>,
    /// <p>A token for getting the next set of associations, if there are any.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAssociationsOutput {
    /// <p>A list of associations and their properties.</p>
    pub fn association_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::AssociationSummary]> {
        self.association_summaries.as_deref()
    }
    /// <p>A token for getting the next set of associations, if there are any.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAssociationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssociationsOutput");
        formatter.field("association_summaries", &self.association_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAssociationsOutput`](crate::output::ListAssociationsOutput)
pub mod list_associations_output {
    /// A builder for [`ListAssociationsOutput`](crate::output::ListAssociationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) association_summaries:
            std::option::Option<std::vec::Vec<crate::model::AssociationSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `association_summaries`.
        ///
        /// To override the contents of this collection use [`set_association_summaries`](Self::set_association_summaries).
        ///
        /// <p>A list of associations and their properties.</p>
        pub fn association_summaries(mut self, input: crate::model::AssociationSummary) -> Self {
            let mut v = self.association_summaries.unwrap_or_default();
            v.push(input);
            self.association_summaries = Some(v);
            self
        }
        /// <p>A list of associations and their properties.</p>
        pub fn set_association_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssociationSummary>>,
        ) -> Self {
            self.association_summaries = input;
            self
        }
        /// <p>A token for getting the next set of associations, if there are any.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token for getting the next set of associations, if there are any.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssociationsOutput`](crate::output::ListAssociationsOutput)
        pub fn build(self) -> crate::output::ListAssociationsOutput {
            crate::output::ListAssociationsOutput {
                association_summaries: self.association_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAssociationsOutput {
    /// Creates a new builder-style object to manufacture [`ListAssociationsOutput`](crate::output::ListAssociationsOutput)
    pub fn builder() -> crate::output::list_associations_output::Builder {
        crate::output::list_associations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListArtifactsOutput {
    /// <p>A list of artifacts and their properties.</p>
    pub artifact_summaries: std::option::Option<std::vec::Vec<crate::model::ArtifactSummary>>,
    /// <p>A token for getting the next set of artifacts, if there are any.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListArtifactsOutput {
    /// <p>A list of artifacts and their properties.</p>
    pub fn artifact_summaries(&self) -> std::option::Option<&[crate::model::ArtifactSummary]> {
        self.artifact_summaries.as_deref()
    }
    /// <p>A token for getting the next set of artifacts, if there are any.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListArtifactsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListArtifactsOutput");
        formatter.field("artifact_summaries", &self.artifact_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListArtifactsOutput`](crate::output::ListArtifactsOutput)
pub mod list_artifacts_output {
    /// A builder for [`ListArtifactsOutput`](crate::output::ListArtifactsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) artifact_summaries:
            std::option::Option<std::vec::Vec<crate::model::ArtifactSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `artifact_summaries`.
        ///
        /// To override the contents of this collection use [`set_artifact_summaries`](Self::set_artifact_summaries).
        ///
        /// <p>A list of artifacts and their properties.</p>
        pub fn artifact_summaries(mut self, input: crate::model::ArtifactSummary) -> Self {
            let mut v = self.artifact_summaries.unwrap_or_default();
            v.push(input);
            self.artifact_summaries = Some(v);
            self
        }
        /// <p>A list of artifacts and their properties.</p>
        pub fn set_artifact_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ArtifactSummary>>,
        ) -> Self {
            self.artifact_summaries = input;
            self
        }
        /// <p>A token for getting the next set of artifacts, if there are any.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token for getting the next set of artifacts, if there are any.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListArtifactsOutput`](crate::output::ListArtifactsOutput)
        pub fn build(self) -> crate::output::ListArtifactsOutput {
            crate::output::ListArtifactsOutput {
                artifact_summaries: self.artifact_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListArtifactsOutput {
    /// Creates a new builder-style object to manufacture [`ListArtifactsOutput`](crate::output::ListArtifactsOutput)
    pub fn builder() -> crate::output::list_artifacts_output::Builder {
        crate::output::list_artifacts_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAppsOutput {
    /// <p>The list of apps.</p>
    pub apps: std::option::Option<std::vec::Vec<crate::model::AppDetails>>,
    /// <p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAppsOutput {
    /// <p>The list of apps.</p>
    pub fn apps(&self) -> std::option::Option<&[crate::model::AppDetails]> {
        self.apps.as_deref()
    }
    /// <p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAppsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAppsOutput");
        formatter.field("apps", &self.apps);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAppsOutput`](crate::output::ListAppsOutput)
pub mod list_apps_output {
    /// A builder for [`ListAppsOutput`](crate::output::ListAppsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) apps: std::option::Option<std::vec::Vec<crate::model::AppDetails>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `apps`.
        ///
        /// To override the contents of this collection use [`set_apps`](Self::set_apps).
        ///
        /// <p>The list of apps.</p>
        pub fn apps(mut self, input: crate::model::AppDetails) -> Self {
            let mut v = self.apps.unwrap_or_default();
            v.push(input);
            self.apps = Some(v);
            self
        }
        /// <p>The list of apps.</p>
        pub fn set_apps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AppDetails>>,
        ) -> Self {
            self.apps = input;
            self
        }
        /// <p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppsOutput`](crate::output::ListAppsOutput)
        pub fn build(self) -> crate::output::ListAppsOutput {
            crate::output::ListAppsOutput {
                apps: self.apps,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAppsOutput {
    /// Creates a new builder-style object to manufacture [`ListAppsOutput`](crate::output::ListAppsOutput)
    pub fn builder() -> crate::output::list_apps_output::Builder {
        crate::output::list_apps_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAppImageConfigsOutput {
    /// <p>A token for getting the next set of AppImageConfigs, if there are any.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of AppImageConfigs and their properties.</p>
    pub app_image_configs: std::option::Option<std::vec::Vec<crate::model::AppImageConfigDetails>>,
}
impl ListAppImageConfigsOutput {
    /// <p>A token for getting the next set of AppImageConfigs, if there are any.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A list of AppImageConfigs and their properties.</p>
    pub fn app_image_configs(&self) -> std::option::Option<&[crate::model::AppImageConfigDetails]> {
        self.app_image_configs.as_deref()
    }
}
impl std::fmt::Debug for ListAppImageConfigsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAppImageConfigsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("app_image_configs", &self.app_image_configs);
        formatter.finish()
    }
}
/// See [`ListAppImageConfigsOutput`](crate::output::ListAppImageConfigsOutput)
pub mod list_app_image_configs_output {
    /// A builder for [`ListAppImageConfigsOutput`](crate::output::ListAppImageConfigsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) app_image_configs:
            std::option::Option<std::vec::Vec<crate::model::AppImageConfigDetails>>,
    }
    impl Builder {
        /// <p>A token for getting the next set of AppImageConfigs, if there are any.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token for getting the next set of AppImageConfigs, if there are any.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `app_image_configs`.
        ///
        /// To override the contents of this collection use [`set_app_image_configs`](Self::set_app_image_configs).
        ///
        /// <p>A list of AppImageConfigs and their properties.</p>
        pub fn app_image_configs(mut self, input: crate::model::AppImageConfigDetails) -> Self {
            let mut v = self.app_image_configs.unwrap_or_default();
            v.push(input);
            self.app_image_configs = Some(v);
            self
        }
        /// <p>A list of AppImageConfigs and their properties.</p>
        pub fn set_app_image_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AppImageConfigDetails>>,
        ) -> Self {
            self.app_image_configs = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAppImageConfigsOutput`](crate::output::ListAppImageConfigsOutput)
        pub fn build(self) -> crate::output::ListAppImageConfigsOutput {
            crate::output::ListAppImageConfigsOutput {
                next_token: self.next_token,
                app_image_configs: self.app_image_configs,
            }
        }
    }
}
impl ListAppImageConfigsOutput {
    /// Creates a new builder-style object to manufacture [`ListAppImageConfigsOutput`](crate::output::ListAppImageConfigsOutput)
    pub fn builder() -> crate::output::list_app_image_configs_output::Builder {
        crate::output::list_app_image_configs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAlgorithmsOutput {
    /// <p>&gt;An array of <code>AlgorithmSummary</code> objects, each of which lists an algorithm.</p>
    pub algorithm_summary_list: std::option::Option<std::vec::Vec<crate::model::AlgorithmSummary>>,
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of algorithms, use it in the subsequent request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAlgorithmsOutput {
    /// <p>&gt;An array of <code>AlgorithmSummary</code> objects, each of which lists an algorithm.</p>
    pub fn algorithm_summary_list(&self) -> std::option::Option<&[crate::model::AlgorithmSummary]> {
        self.algorithm_summary_list.as_deref()
    }
    /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of algorithms, use it in the subsequent request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAlgorithmsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAlgorithmsOutput");
        formatter.field("algorithm_summary_list", &self.algorithm_summary_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAlgorithmsOutput`](crate::output::ListAlgorithmsOutput)
pub mod list_algorithms_output {
    /// A builder for [`ListAlgorithmsOutput`](crate::output::ListAlgorithmsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) algorithm_summary_list:
            std::option::Option<std::vec::Vec<crate::model::AlgorithmSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `algorithm_summary_list`.
        ///
        /// To override the contents of this collection use [`set_algorithm_summary_list`](Self::set_algorithm_summary_list).
        ///
        /// <p>&gt;An array of <code>AlgorithmSummary</code> objects, each of which lists an algorithm.</p>
        pub fn algorithm_summary_list(mut self, input: crate::model::AlgorithmSummary) -> Self {
            let mut v = self.algorithm_summary_list.unwrap_or_default();
            v.push(input);
            self.algorithm_summary_list = Some(v);
            self
        }
        /// <p>&gt;An array of <code>AlgorithmSummary</code> objects, each of which lists an algorithm.</p>
        pub fn set_algorithm_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AlgorithmSummary>>,
        ) -> Self {
            self.algorithm_summary_list = input;
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of algorithms, use it in the subsequent request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of algorithms, use it in the subsequent request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAlgorithmsOutput`](crate::output::ListAlgorithmsOutput)
        pub fn build(self) -> crate::output::ListAlgorithmsOutput {
            crate::output::ListAlgorithmsOutput {
                algorithm_summary_list: self.algorithm_summary_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAlgorithmsOutput {
    /// Creates a new builder-style object to manufacture [`ListAlgorithmsOutput`](crate::output::ListAlgorithmsOutput)
    pub fn builder() -> crate::output::list_algorithms_output::Builder {
        crate::output::list_algorithms_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListActionsOutput {
    /// <p>A list of actions and their properties.</p>
    pub action_summaries: std::option::Option<std::vec::Vec<crate::model::ActionSummary>>,
    /// <p>A token for getting the next set of actions, if there are any.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListActionsOutput {
    /// <p>A list of actions and their properties.</p>
    pub fn action_summaries(&self) -> std::option::Option<&[crate::model::ActionSummary]> {
        self.action_summaries.as_deref()
    }
    /// <p>A token for getting the next set of actions, if there are any.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListActionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListActionsOutput");
        formatter.field("action_summaries", &self.action_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListActionsOutput`](crate::output::ListActionsOutput)
pub mod list_actions_output {
    /// A builder for [`ListActionsOutput`](crate::output::ListActionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_summaries:
            std::option::Option<std::vec::Vec<crate::model::ActionSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `action_summaries`.
        ///
        /// To override the contents of this collection use [`set_action_summaries`](Self::set_action_summaries).
        ///
        /// <p>A list of actions and their properties.</p>
        pub fn action_summaries(mut self, input: crate::model::ActionSummary) -> Self {
            let mut v = self.action_summaries.unwrap_or_default();
            v.push(input);
            self.action_summaries = Some(v);
            self
        }
        /// <p>A list of actions and their properties.</p>
        pub fn set_action_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ActionSummary>>,
        ) -> Self {
            self.action_summaries = input;
            self
        }
        /// <p>A token for getting the next set of actions, if there are any.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token for getting the next set of actions, if there are any.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListActionsOutput`](crate::output::ListActionsOutput)
        pub fn build(self) -> crate::output::ListActionsOutput {
            crate::output::ListActionsOutput {
                action_summaries: self.action_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListActionsOutput {
    /// Creates a new builder-style object to manufacture [`ListActionsOutput`](crate::output::ListActionsOutput)
    pub fn builder() -> crate::output::list_actions_output::Builder {
        crate::output::list_actions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSearchSuggestionsOutput {
    /// <p>A list of property names for a <code>Resource</code> that match a <code>SuggestionQuery</code>.</p>
    pub property_name_suggestions:
        std::option::Option<std::vec::Vec<crate::model::PropertyNameSuggestion>>,
}
impl GetSearchSuggestionsOutput {
    /// <p>A list of property names for a <code>Resource</code> that match a <code>SuggestionQuery</code>.</p>
    pub fn property_name_suggestions(
        &self,
    ) -> std::option::Option<&[crate::model::PropertyNameSuggestion]> {
        self.property_name_suggestions.as_deref()
    }
}
impl std::fmt::Debug for GetSearchSuggestionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSearchSuggestionsOutput");
        formatter.field("property_name_suggestions", &self.property_name_suggestions);
        formatter.finish()
    }
}
/// See [`GetSearchSuggestionsOutput`](crate::output::GetSearchSuggestionsOutput)
pub mod get_search_suggestions_output {
    /// A builder for [`GetSearchSuggestionsOutput`](crate::output::GetSearchSuggestionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) property_name_suggestions:
            std::option::Option<std::vec::Vec<crate::model::PropertyNameSuggestion>>,
    }
    impl Builder {
        /// Appends an item to `property_name_suggestions`.
        ///
        /// To override the contents of this collection use [`set_property_name_suggestions`](Self::set_property_name_suggestions).
        ///
        /// <p>A list of property names for a <code>Resource</code> that match a <code>SuggestionQuery</code>.</p>
        pub fn property_name_suggestions(
            mut self,
            input: crate::model::PropertyNameSuggestion,
        ) -> Self {
            let mut v = self.property_name_suggestions.unwrap_or_default();
            v.push(input);
            self.property_name_suggestions = Some(v);
            self
        }
        /// <p>A list of property names for a <code>Resource</code> that match a <code>SuggestionQuery</code>.</p>
        pub fn set_property_name_suggestions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PropertyNameSuggestion>>,
        ) -> Self {
            self.property_name_suggestions = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSearchSuggestionsOutput`](crate::output::GetSearchSuggestionsOutput)
        pub fn build(self) -> crate::output::GetSearchSuggestionsOutput {
            crate::output::GetSearchSuggestionsOutput {
                property_name_suggestions: self.property_name_suggestions,
            }
        }
    }
}
impl GetSearchSuggestionsOutput {
    /// Creates a new builder-style object to manufacture [`GetSearchSuggestionsOutput`](crate::output::GetSearchSuggestionsOutput)
    pub fn builder() -> crate::output::get_search_suggestions_output::Builder {
        crate::output::get_search_suggestions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSagemakerServicecatalogPortfolioStatusOutput {
    /// <p>Whether Service Catalog is enabled or disabled in SageMaker.</p>
    pub status: std::option::Option<crate::model::SagemakerServicecatalogStatus>,
}
impl GetSagemakerServicecatalogPortfolioStatusOutput {
    /// <p>Whether Service Catalog is enabled or disabled in SageMaker.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::SagemakerServicecatalogStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for GetSagemakerServicecatalogPortfolioStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSagemakerServicecatalogPortfolioStatusOutput");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`GetSagemakerServicecatalogPortfolioStatusOutput`](crate::output::GetSagemakerServicecatalogPortfolioStatusOutput)
pub mod get_sagemaker_servicecatalog_portfolio_status_output {
    /// A builder for [`GetSagemakerServicecatalogPortfolioStatusOutput`](crate::output::GetSagemakerServicecatalogPortfolioStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::SagemakerServicecatalogStatus>,
    }
    impl Builder {
        /// <p>Whether Service Catalog is enabled or disabled in SageMaker.</p>
        pub fn status(mut self, input: crate::model::SagemakerServicecatalogStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Whether Service Catalog is enabled or disabled in SageMaker.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SagemakerServicecatalogStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSagemakerServicecatalogPortfolioStatusOutput`](crate::output::GetSagemakerServicecatalogPortfolioStatusOutput)
        pub fn build(self) -> crate::output::GetSagemakerServicecatalogPortfolioStatusOutput {
            crate::output::GetSagemakerServicecatalogPortfolioStatusOutput {
                status: self.status,
            }
        }
    }
}
impl GetSagemakerServicecatalogPortfolioStatusOutput {
    /// Creates a new builder-style object to manufacture [`GetSagemakerServicecatalogPortfolioStatusOutput`](crate::output::GetSagemakerServicecatalogPortfolioStatusOutput)
    pub fn builder() -> crate::output::get_sagemaker_servicecatalog_portfolio_status_output::Builder
    {
        crate::output::get_sagemaker_servicecatalog_portfolio_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetModelPackageGroupPolicyOutput {
    /// <p>The resource policy for the model group.</p>
    pub resource_policy: std::option::Option<std::string::String>,
}
impl GetModelPackageGroupPolicyOutput {
    /// <p>The resource policy for the model group.</p>
    pub fn resource_policy(&self) -> std::option::Option<&str> {
        self.resource_policy.as_deref()
    }
}
impl std::fmt::Debug for GetModelPackageGroupPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetModelPackageGroupPolicyOutput");
        formatter.field("resource_policy", &self.resource_policy);
        formatter.finish()
    }
}
/// See [`GetModelPackageGroupPolicyOutput`](crate::output::GetModelPackageGroupPolicyOutput)
pub mod get_model_package_group_policy_output {
    /// A builder for [`GetModelPackageGroupPolicyOutput`](crate::output::GetModelPackageGroupPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource policy for the model group.</p>
        pub fn resource_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_policy = Some(input.into());
            self
        }
        /// <p>The resource policy for the model group.</p>
        pub fn set_resource_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetModelPackageGroupPolicyOutput`](crate::output::GetModelPackageGroupPolicyOutput)
        pub fn build(self) -> crate::output::GetModelPackageGroupPolicyOutput {
            crate::output::GetModelPackageGroupPolicyOutput {
                resource_policy: self.resource_policy,
            }
        }
    }
}
impl GetModelPackageGroupPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetModelPackageGroupPolicyOutput`](crate::output::GetModelPackageGroupPolicyOutput)
    pub fn builder() -> crate::output::get_model_package_group_policy_output::Builder {
        crate::output::get_model_package_group_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLineageGroupPolicyOutput {
    /// <p>The Amazon Resource Name (ARN) of the lineage group.</p>
    pub lineage_group_arn: std::option::Option<std::string::String>,
    /// <p>The resource policy that gives access to the lineage group in another account.</p>
    pub resource_policy: std::option::Option<std::string::String>,
}
impl GetLineageGroupPolicyOutput {
    /// <p>The Amazon Resource Name (ARN) of the lineage group.</p>
    pub fn lineage_group_arn(&self) -> std::option::Option<&str> {
        self.lineage_group_arn.as_deref()
    }
    /// <p>The resource policy that gives access to the lineage group in another account.</p>
    pub fn resource_policy(&self) -> std::option::Option<&str> {
        self.resource_policy.as_deref()
    }
}
impl std::fmt::Debug for GetLineageGroupPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLineageGroupPolicyOutput");
        formatter.field("lineage_group_arn", &self.lineage_group_arn);
        formatter.field("resource_policy", &self.resource_policy);
        formatter.finish()
    }
}
/// See [`GetLineageGroupPolicyOutput`](crate::output::GetLineageGroupPolicyOutput)
pub mod get_lineage_group_policy_output {
    /// A builder for [`GetLineageGroupPolicyOutput`](crate::output::GetLineageGroupPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lineage_group_arn: std::option::Option<std::string::String>,
        pub(crate) resource_policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the lineage group.</p>
        pub fn lineage_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.lineage_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the lineage group.</p>
        pub fn set_lineage_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lineage_group_arn = input;
            self
        }
        /// <p>The resource policy that gives access to the lineage group in another account.</p>
        pub fn resource_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_policy = Some(input.into());
            self
        }
        /// <p>The resource policy that gives access to the lineage group in another account.</p>
        pub fn set_resource_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLineageGroupPolicyOutput`](crate::output::GetLineageGroupPolicyOutput)
        pub fn build(self) -> crate::output::GetLineageGroupPolicyOutput {
            crate::output::GetLineageGroupPolicyOutput {
                lineage_group_arn: self.lineage_group_arn,
                resource_policy: self.resource_policy,
            }
        }
    }
}
impl GetLineageGroupPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetLineageGroupPolicyOutput`](crate::output::GetLineageGroupPolicyOutput)
    pub fn builder() -> crate::output::get_lineage_group_policy_output::Builder {
        crate::output::get_lineage_group_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDeviceFleetReportOutput {
    /// <p>The Amazon Resource Name (ARN) of the device.</p>
    pub device_fleet_arn: std::option::Option<std::string::String>,
    /// <p>The name of the fleet.</p>
    pub device_fleet_name: std::option::Option<std::string::String>,
    /// <p>The output configuration for storing sample data collected by the fleet.</p>
    pub output_config: std::option::Option<crate::model::EdgeOutputConfig>,
    /// <p>Description of the fleet.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Timestamp of when the report was generated.</p>
    pub report_generated: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Status of devices.</p>
    pub device_stats: std::option::Option<crate::model::DeviceStats>,
    /// <p>The versions of Edge Manager agent deployed on the fleet.</p>
    pub agent_versions: std::option::Option<std::vec::Vec<crate::model::AgentVersion>>,
    /// <p>Status of model on device.</p>
    pub model_stats: std::option::Option<std::vec::Vec<crate::model::EdgeModelStat>>,
}
impl GetDeviceFleetReportOutput {
    /// <p>The Amazon Resource Name (ARN) of the device.</p>
    pub fn device_fleet_arn(&self) -> std::option::Option<&str> {
        self.device_fleet_arn.as_deref()
    }
    /// <p>The name of the fleet.</p>
    pub fn device_fleet_name(&self) -> std::option::Option<&str> {
        self.device_fleet_name.as_deref()
    }
    /// <p>The output configuration for storing sample data collected by the fleet.</p>
    pub fn output_config(&self) -> std::option::Option<&crate::model::EdgeOutputConfig> {
        self.output_config.as_ref()
    }
    /// <p>Description of the fleet.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Timestamp of when the report was generated.</p>
    pub fn report_generated(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.report_generated.as_ref()
    }
    /// <p>Status of devices.</p>
    pub fn device_stats(&self) -> std::option::Option<&crate::model::DeviceStats> {
        self.device_stats.as_ref()
    }
    /// <p>The versions of Edge Manager agent deployed on the fleet.</p>
    pub fn agent_versions(&self) -> std::option::Option<&[crate::model::AgentVersion]> {
        self.agent_versions.as_deref()
    }
    /// <p>Status of model on device.</p>
    pub fn model_stats(&self) -> std::option::Option<&[crate::model::EdgeModelStat]> {
        self.model_stats.as_deref()
    }
}
impl std::fmt::Debug for GetDeviceFleetReportOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDeviceFleetReportOutput");
        formatter.field("device_fleet_arn", &self.device_fleet_arn);
        formatter.field("device_fleet_name", &self.device_fleet_name);
        formatter.field("output_config", &self.output_config);
        formatter.field("description", &self.description);
        formatter.field("report_generated", &self.report_generated);
        formatter.field("device_stats", &self.device_stats);
        formatter.field("agent_versions", &self.agent_versions);
        formatter.field("model_stats", &self.model_stats);
        formatter.finish()
    }
}
/// See [`GetDeviceFleetReportOutput`](crate::output::GetDeviceFleetReportOutput)
pub mod get_device_fleet_report_output {
    /// A builder for [`GetDeviceFleetReportOutput`](crate::output::GetDeviceFleetReportOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_fleet_arn: std::option::Option<std::string::String>,
        pub(crate) device_fleet_name: std::option::Option<std::string::String>,
        pub(crate) output_config: std::option::Option<crate::model::EdgeOutputConfig>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) report_generated: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) device_stats: std::option::Option<crate::model::DeviceStats>,
        pub(crate) agent_versions: std::option::Option<std::vec::Vec<crate::model::AgentVersion>>,
        pub(crate) model_stats: std::option::Option<std::vec::Vec<crate::model::EdgeModelStat>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the device.</p>
        pub fn device_fleet_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_fleet_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the device.</p>
        pub fn set_device_fleet_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_fleet_arn = input;
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn device_fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_fleet_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_device_fleet_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_fleet_name = input;
            self
        }
        /// <p>The output configuration for storing sample data collected by the fleet.</p>
        pub fn output_config(mut self, input: crate::model::EdgeOutputConfig) -> Self {
            self.output_config = Some(input);
            self
        }
        /// <p>The output configuration for storing sample data collected by the fleet.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::EdgeOutputConfig>,
        ) -> Self {
            self.output_config = input;
            self
        }
        /// <p>Description of the fleet.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Description of the fleet.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Timestamp of when the report was generated.</p>
        pub fn report_generated(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.report_generated = Some(input);
            self
        }
        /// <p>Timestamp of when the report was generated.</p>
        pub fn set_report_generated(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.report_generated = input;
            self
        }
        /// <p>Status of devices.</p>
        pub fn device_stats(mut self, input: crate::model::DeviceStats) -> Self {
            self.device_stats = Some(input);
            self
        }
        /// <p>Status of devices.</p>
        pub fn set_device_stats(
            mut self,
            input: std::option::Option<crate::model::DeviceStats>,
        ) -> Self {
            self.device_stats = input;
            self
        }
        /// Appends an item to `agent_versions`.
        ///
        /// To override the contents of this collection use [`set_agent_versions`](Self::set_agent_versions).
        ///
        /// <p>The versions of Edge Manager agent deployed on the fleet.</p>
        pub fn agent_versions(mut self, input: crate::model::AgentVersion) -> Self {
            let mut v = self.agent_versions.unwrap_or_default();
            v.push(input);
            self.agent_versions = Some(v);
            self
        }
        /// <p>The versions of Edge Manager agent deployed on the fleet.</p>
        pub fn set_agent_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AgentVersion>>,
        ) -> Self {
            self.agent_versions = input;
            self
        }
        /// Appends an item to `model_stats`.
        ///
        /// To override the contents of this collection use [`set_model_stats`](Self::set_model_stats).
        ///
        /// <p>Status of model on device.</p>
        pub fn model_stats(mut self, input: crate::model::EdgeModelStat) -> Self {
            let mut v = self.model_stats.unwrap_or_default();
            v.push(input);
            self.model_stats = Some(v);
            self
        }
        /// <p>Status of model on device.</p>
        pub fn set_model_stats(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EdgeModelStat>>,
        ) -> Self {
            self.model_stats = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDeviceFleetReportOutput`](crate::output::GetDeviceFleetReportOutput)
        pub fn build(self) -> crate::output::GetDeviceFleetReportOutput {
            crate::output::GetDeviceFleetReportOutput {
                device_fleet_arn: self.device_fleet_arn,
                device_fleet_name: self.device_fleet_name,
                output_config: self.output_config,
                description: self.description,
                report_generated: self.report_generated,
                device_stats: self.device_stats,
                agent_versions: self.agent_versions,
                model_stats: self.model_stats,
            }
        }
    }
}
impl GetDeviceFleetReportOutput {
    /// Creates a new builder-style object to manufacture [`GetDeviceFleetReportOutput`](crate::output::GetDeviceFleetReportOutput)
    pub fn builder() -> crate::output::get_device_fleet_report_output::Builder {
        crate::output::get_device_fleet_report_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableSagemakerServicecatalogPortfolioOutput {}
impl std::fmt::Debug for EnableSagemakerServicecatalogPortfolioOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableSagemakerServicecatalogPortfolioOutput");
        formatter.finish()
    }
}
/// See [`EnableSagemakerServicecatalogPortfolioOutput`](crate::output::EnableSagemakerServicecatalogPortfolioOutput)
pub mod enable_sagemaker_servicecatalog_portfolio_output {
    /// A builder for [`EnableSagemakerServicecatalogPortfolioOutput`](crate::output::EnableSagemakerServicecatalogPortfolioOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`EnableSagemakerServicecatalogPortfolioOutput`](crate::output::EnableSagemakerServicecatalogPortfolioOutput)
        pub fn build(self) -> crate::output::EnableSagemakerServicecatalogPortfolioOutput {
            crate::output::EnableSagemakerServicecatalogPortfolioOutput {}
        }
    }
}
impl EnableSagemakerServicecatalogPortfolioOutput {
    /// Creates a new builder-style object to manufacture [`EnableSagemakerServicecatalogPortfolioOutput`](crate::output::EnableSagemakerServicecatalogPortfolioOutput)
    pub fn builder() -> crate::output::enable_sagemaker_servicecatalog_portfolio_output::Builder {
        crate::output::enable_sagemaker_servicecatalog_portfolio_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateTrialComponentOutput {
    /// <p>The ARN of the trial component.</p>
    pub trial_component_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the trial.</p>
    pub trial_arn: std::option::Option<std::string::String>,
}
impl DisassociateTrialComponentOutput {
    /// <p>The ARN of the trial component.</p>
    pub fn trial_component_arn(&self) -> std::option::Option<&str> {
        self.trial_component_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the trial.</p>
    pub fn trial_arn(&self) -> std::option::Option<&str> {
        self.trial_arn.as_deref()
    }
}
impl std::fmt::Debug for DisassociateTrialComponentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateTrialComponentOutput");
        formatter.field("trial_component_arn", &self.trial_component_arn);
        formatter.field("trial_arn", &self.trial_arn);
        formatter.finish()
    }
}
/// See [`DisassociateTrialComponentOutput`](crate::output::DisassociateTrialComponentOutput)
pub mod disassociate_trial_component_output {
    /// A builder for [`DisassociateTrialComponentOutput`](crate::output::DisassociateTrialComponentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trial_component_arn: std::option::Option<std::string::String>,
        pub(crate) trial_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the trial component.</p>
        pub fn trial_component_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trial_component_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the trial component.</p>
        pub fn set_trial_component_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.trial_component_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the trial.</p>
        pub fn trial_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trial_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the trial.</p>
        pub fn set_trial_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trial_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateTrialComponentOutput`](crate::output::DisassociateTrialComponentOutput)
        pub fn build(self) -> crate::output::DisassociateTrialComponentOutput {
            crate::output::DisassociateTrialComponentOutput {
                trial_component_arn: self.trial_component_arn,
                trial_arn: self.trial_arn,
            }
        }
    }
}
impl DisassociateTrialComponentOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateTrialComponentOutput`](crate::output::DisassociateTrialComponentOutput)
    pub fn builder() -> crate::output::disassociate_trial_component_output::Builder {
        crate::output::disassociate_trial_component_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableSagemakerServicecatalogPortfolioOutput {}
impl std::fmt::Debug for DisableSagemakerServicecatalogPortfolioOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableSagemakerServicecatalogPortfolioOutput");
        formatter.finish()
    }
}
/// See [`DisableSagemakerServicecatalogPortfolioOutput`](crate::output::DisableSagemakerServicecatalogPortfolioOutput)
pub mod disable_sagemaker_servicecatalog_portfolio_output {
    /// A builder for [`DisableSagemakerServicecatalogPortfolioOutput`](crate::output::DisableSagemakerServicecatalogPortfolioOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisableSagemakerServicecatalogPortfolioOutput`](crate::output::DisableSagemakerServicecatalogPortfolioOutput)
        pub fn build(self) -> crate::output::DisableSagemakerServicecatalogPortfolioOutput {
            crate::output::DisableSagemakerServicecatalogPortfolioOutput {}
        }
    }
}
impl DisableSagemakerServicecatalogPortfolioOutput {
    /// Creates a new builder-style object to manufacture [`DisableSagemakerServicecatalogPortfolioOutput`](crate::output::DisableSagemakerServicecatalogPortfolioOutput)
    pub fn builder() -> crate::output::disable_sagemaker_servicecatalog_portfolio_output::Builder {
        crate::output::disable_sagemaker_servicecatalog_portfolio_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorkteamOutput {
    /// <p>A <code>Workteam</code> instance that contains information about the work team. </p>
    pub workteam: std::option::Option<crate::model::Workteam>,
}
impl DescribeWorkteamOutput {
    /// <p>A <code>Workteam</code> instance that contains information about the work team. </p>
    pub fn workteam(&self) -> std::option::Option<&crate::model::Workteam> {
        self.workteam.as_ref()
    }
}
impl std::fmt::Debug for DescribeWorkteamOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorkteamOutput");
        formatter.field("workteam", &self.workteam);
        formatter.finish()
    }
}
/// See [`DescribeWorkteamOutput`](crate::output::DescribeWorkteamOutput)
pub mod describe_workteam_output {
    /// A builder for [`DescribeWorkteamOutput`](crate::output::DescribeWorkteamOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workteam: std::option::Option<crate::model::Workteam>,
    }
    impl Builder {
        /// <p>A <code>Workteam</code> instance that contains information about the work team. </p>
        pub fn workteam(mut self, input: crate::model::Workteam) -> Self {
            self.workteam = Some(input);
            self
        }
        /// <p>A <code>Workteam</code> instance that contains information about the work team. </p>
        pub fn set_workteam(mut self, input: std::option::Option<crate::model::Workteam>) -> Self {
            self.workteam = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorkteamOutput`](crate::output::DescribeWorkteamOutput)
        pub fn build(self) -> crate::output::DescribeWorkteamOutput {
            crate::output::DescribeWorkteamOutput {
                workteam: self.workteam,
            }
        }
    }
}
impl DescribeWorkteamOutput {
    /// Creates a new builder-style object to manufacture [`DescribeWorkteamOutput`](crate::output::DescribeWorkteamOutput)
    pub fn builder() -> crate::output::describe_workteam_output::Builder {
        crate::output::describe_workteam_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWorkforceOutput {
    /// <p>A single private workforce, which is automatically created when you create your first private work team. You can create one private work force in each Amazon Web Services Region. By default, any workforce-related API operation used in a specific region will apply to the workforce created in that region. To learn how to create a private workforce, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html">Create a Private Workforce</a>.</p>
    pub workforce: std::option::Option<crate::model::Workforce>,
}
impl DescribeWorkforceOutput {
    /// <p>A single private workforce, which is automatically created when you create your first private work team. You can create one private work force in each Amazon Web Services Region. By default, any workforce-related API operation used in a specific region will apply to the workforce created in that region. To learn how to create a private workforce, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html">Create a Private Workforce</a>.</p>
    pub fn workforce(&self) -> std::option::Option<&crate::model::Workforce> {
        self.workforce.as_ref()
    }
}
impl std::fmt::Debug for DescribeWorkforceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWorkforceOutput");
        formatter.field("workforce", &self.workforce);
        formatter.finish()
    }
}
/// See [`DescribeWorkforceOutput`](crate::output::DescribeWorkforceOutput)
pub mod describe_workforce_output {
    /// A builder for [`DescribeWorkforceOutput`](crate::output::DescribeWorkforceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workforce: std::option::Option<crate::model::Workforce>,
    }
    impl Builder {
        /// <p>A single private workforce, which is automatically created when you create your first private work team. You can create one private work force in each Amazon Web Services Region. By default, any workforce-related API operation used in a specific region will apply to the workforce created in that region. To learn how to create a private workforce, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html">Create a Private Workforce</a>.</p>
        pub fn workforce(mut self, input: crate::model::Workforce) -> Self {
            self.workforce = Some(input);
            self
        }
        /// <p>A single private workforce, which is automatically created when you create your first private work team. You can create one private work force in each Amazon Web Services Region. By default, any workforce-related API operation used in a specific region will apply to the workforce created in that region. To learn how to create a private workforce, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html">Create a Private Workforce</a>.</p>
        pub fn set_workforce(
            mut self,
            input: std::option::Option<crate::model::Workforce>,
        ) -> Self {
            self.workforce = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWorkforceOutput`](crate::output::DescribeWorkforceOutput)
        pub fn build(self) -> crate::output::DescribeWorkforceOutput {
            crate::output::DescribeWorkforceOutput {
                workforce: self.workforce,
            }
        }
    }
}
impl DescribeWorkforceOutput {
    /// Creates a new builder-style object to manufacture [`DescribeWorkforceOutput`](crate::output::DescribeWorkforceOutput)
    pub fn builder() -> crate::output::describe_workforce_output::Builder {
        crate::output::describe_workforce_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUserProfileOutput {
    /// <p>The ID of the domain that contains the profile.</p>
    pub domain_id: std::option::Option<std::string::String>,
    /// <p>The user profile Amazon Resource Name (ARN).</p>
    pub user_profile_arn: std::option::Option<std::string::String>,
    /// <p>The user profile name.</p>
    pub user_profile_name: std::option::Option<std::string::String>,
    /// <p>The ID of the user's profile in the Amazon Elastic File System (EFS) volume.</p>
    pub home_efs_file_system_uid: std::option::Option<std::string::String>,
    /// <p>The status.</p>
    pub status: std::option::Option<crate::model::UserProfileStatus>,
    /// <p>The last modified time.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The creation time.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The failure reason.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The SSO user identifier.</p>
    pub single_sign_on_user_identifier: std::option::Option<std::string::String>,
    /// <p>The SSO user value.</p>
    pub single_sign_on_user_value: std::option::Option<std::string::String>,
    /// <p>A collection of settings.</p>
    pub user_settings: std::option::Option<crate::model::UserSettings>,
}
impl DescribeUserProfileOutput {
    /// <p>The ID of the domain that contains the profile.</p>
    pub fn domain_id(&self) -> std::option::Option<&str> {
        self.domain_id.as_deref()
    }
    /// <p>The user profile Amazon Resource Name (ARN).</p>
    pub fn user_profile_arn(&self) -> std::option::Option<&str> {
        self.user_profile_arn.as_deref()
    }
    /// <p>The user profile name.</p>
    pub fn user_profile_name(&self) -> std::option::Option<&str> {
        self.user_profile_name.as_deref()
    }
    /// <p>The ID of the user's profile in the Amazon Elastic File System (EFS) volume.</p>
    pub fn home_efs_file_system_uid(&self) -> std::option::Option<&str> {
        self.home_efs_file_system_uid.as_deref()
    }
    /// <p>The status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::UserProfileStatus> {
        self.status.as_ref()
    }
    /// <p>The last modified time.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>The creation time.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The failure reason.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The SSO user identifier.</p>
    pub fn single_sign_on_user_identifier(&self) -> std::option::Option<&str> {
        self.single_sign_on_user_identifier.as_deref()
    }
    /// <p>The SSO user value.</p>
    pub fn single_sign_on_user_value(&self) -> std::option::Option<&str> {
        self.single_sign_on_user_value.as_deref()
    }
    /// <p>A collection of settings.</p>
    pub fn user_settings(&self) -> std::option::Option<&crate::model::UserSettings> {
        self.user_settings.as_ref()
    }
}
impl std::fmt::Debug for DescribeUserProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUserProfileOutput");
        formatter.field("domain_id", &self.domain_id);
        formatter.field("user_profile_arn", &self.user_profile_arn);
        formatter.field("user_profile_name", &self.user_profile_name);
        formatter.field("home_efs_file_system_uid", &self.home_efs_file_system_uid);
        formatter.field("status", &self.status);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field(
            "single_sign_on_user_identifier",
            &self.single_sign_on_user_identifier,
        );
        formatter.field("single_sign_on_user_value", &self.single_sign_on_user_value);
        formatter.field("user_settings", &self.user_settings);
        formatter.finish()
    }
}
/// See [`DescribeUserProfileOutput`](crate::output::DescribeUserProfileOutput)
pub mod describe_user_profile_output {
    /// A builder for [`DescribeUserProfileOutput`](crate::output::DescribeUserProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_id: std::option::Option<std::string::String>,
        pub(crate) user_profile_arn: std::option::Option<std::string::String>,
        pub(crate) user_profile_name: std::option::Option<std::string::String>,
        pub(crate) home_efs_file_system_uid: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::UserProfileStatus>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) single_sign_on_user_identifier: std::option::Option<std::string::String>,
        pub(crate) single_sign_on_user_value: std::option::Option<std::string::String>,
        pub(crate) user_settings: std::option::Option<crate::model::UserSettings>,
    }
    impl Builder {
        /// <p>The ID of the domain that contains the profile.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_id = Some(input.into());
            self
        }
        /// <p>The ID of the domain that contains the profile.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_id = input;
            self
        }
        /// <p>The user profile Amazon Resource Name (ARN).</p>
        pub fn user_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_profile_arn = Some(input.into());
            self
        }
        /// <p>The user profile Amazon Resource Name (ARN).</p>
        pub fn set_user_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_profile_arn = input;
            self
        }
        /// <p>The user profile name.</p>
        pub fn user_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_profile_name = Some(input.into());
            self
        }
        /// <p>The user profile name.</p>
        pub fn set_user_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_profile_name = input;
            self
        }
        /// <p>The ID of the user's profile in the Amazon Elastic File System (EFS) volume.</p>
        pub fn home_efs_file_system_uid(mut self, input: impl Into<std::string::String>) -> Self {
            self.home_efs_file_system_uid = Some(input.into());
            self
        }
        /// <p>The ID of the user's profile in the Amazon Elastic File System (EFS) volume.</p>
        pub fn set_home_efs_file_system_uid(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.home_efs_file_system_uid = input;
            self
        }
        /// <p>The status.</p>
        pub fn status(mut self, input: crate::model::UserProfileStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::UserProfileStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The last modified time.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The last modified time.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>The creation time.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The creation time.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The failure reason.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>The failure reason.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The SSO user identifier.</p>
        pub fn single_sign_on_user_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.single_sign_on_user_identifier = Some(input.into());
            self
        }
        /// <p>The SSO user identifier.</p>
        pub fn set_single_sign_on_user_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.single_sign_on_user_identifier = input;
            self
        }
        /// <p>The SSO user value.</p>
        pub fn single_sign_on_user_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.single_sign_on_user_value = Some(input.into());
            self
        }
        /// <p>The SSO user value.</p>
        pub fn set_single_sign_on_user_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.single_sign_on_user_value = input;
            self
        }
        /// <p>A collection of settings.</p>
        pub fn user_settings(mut self, input: crate::model::UserSettings) -> Self {
            self.user_settings = Some(input);
            self
        }
        /// <p>A collection of settings.</p>
        pub fn set_user_settings(
            mut self,
            input: std::option::Option<crate::model::UserSettings>,
        ) -> Self {
            self.user_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUserProfileOutput`](crate::output::DescribeUserProfileOutput)
        pub fn build(self) -> crate::output::DescribeUserProfileOutput {
            crate::output::DescribeUserProfileOutput {
                domain_id: self.domain_id,
                user_profile_arn: self.user_profile_arn,
                user_profile_name: self.user_profile_name,
                home_efs_file_system_uid: self.home_efs_file_system_uid,
                status: self.status,
                last_modified_time: self.last_modified_time,
                creation_time: self.creation_time,
                failure_reason: self.failure_reason,
                single_sign_on_user_identifier: self.single_sign_on_user_identifier,
                single_sign_on_user_value: self.single_sign_on_user_value,
                user_settings: self.user_settings,
            }
        }
    }
}
impl DescribeUserProfileOutput {
    /// Creates a new builder-style object to manufacture [`DescribeUserProfileOutput`](crate::output::DescribeUserProfileOutput)
    pub fn builder() -> crate::output::describe_user_profile_output::Builder {
        crate::output::describe_user_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTrialComponentOutput {
    /// <p>The name of the trial component.</p>
    pub trial_component_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the trial component.</p>
    pub trial_component_arn: std::option::Option<std::string::String>,
    /// <p>The name of the component as displayed. If <code>DisplayName</code> isn't specified, <code>TrialComponentName</code> is displayed.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the source and, optionally, the job type.</p>
    pub source: std::option::Option<crate::model::TrialComponentSource>,
    /// <p>The status of the component. States include:</p>
    /// <ul>
    /// <li> <p>InProgress</p> </li>
    /// <li> <p>Completed</p> </li>
    /// <li> <p>Failed</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::TrialComponentStatus>,
    /// <p>When the component started.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>When the component ended.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>When the component was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Who created the trial component.</p>
    pub created_by: std::option::Option<crate::model::UserContext>,
    /// <p>When the component was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Who last modified the component.</p>
    pub last_modified_by: std::option::Option<crate::model::UserContext>,
    /// <p>The hyperparameters of the component.</p>
    pub parameters: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::TrialComponentParameterValue>,
    >,
    /// <p>The input artifacts of the component.</p>
    pub input_artifacts: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::TrialComponentArtifact>,
    >,
    /// <p>The output artifacts of the component.</p>
    pub output_artifacts: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::TrialComponentArtifact>,
    >,
    /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
    pub metadata_properties: std::option::Option<crate::model::MetadataProperties>,
    /// <p>The metrics for the component.</p>
    pub metrics: std::option::Option<std::vec::Vec<crate::model::TrialComponentMetricSummary>>,
    /// <p>The Amazon Resource Name (ARN) of the lineage group.</p>
    pub lineage_group_arn: std::option::Option<std::string::String>,
}
impl DescribeTrialComponentOutput {
    /// <p>The name of the trial component.</p>
    pub fn trial_component_name(&self) -> std::option::Option<&str> {
        self.trial_component_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the trial component.</p>
    pub fn trial_component_arn(&self) -> std::option::Option<&str> {
        self.trial_component_arn.as_deref()
    }
    /// <p>The name of the component as displayed. If <code>DisplayName</code> isn't specified, <code>TrialComponentName</code> is displayed.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the source and, optionally, the job type.</p>
    pub fn source(&self) -> std::option::Option<&crate::model::TrialComponentSource> {
        self.source.as_ref()
    }
    /// <p>The status of the component. States include:</p>
    /// <ul>
    /// <li> <p>InProgress</p> </li>
    /// <li> <p>Completed</p> </li>
    /// <li> <p>Failed</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::TrialComponentStatus> {
        self.status.as_ref()
    }
    /// <p>When the component started.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>When the component ended.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>When the component was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>Who created the trial component.</p>
    pub fn created_by(&self) -> std::option::Option<&crate::model::UserContext> {
        self.created_by.as_ref()
    }
    /// <p>When the component was last modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>Who last modified the component.</p>
    pub fn last_modified_by(&self) -> std::option::Option<&crate::model::UserContext> {
        self.last_modified_by.as_ref()
    }
    /// <p>The hyperparameters of the component.</p>
    pub fn parameters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::TrialComponentParameterValue>,
    > {
        self.parameters.as_ref()
    }
    /// <p>The input artifacts of the component.</p>
    pub fn input_artifacts(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::TrialComponentArtifact>,
    > {
        self.input_artifacts.as_ref()
    }
    /// <p>The output artifacts of the component.</p>
    pub fn output_artifacts(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::TrialComponentArtifact>,
    > {
        self.output_artifacts.as_ref()
    }
    /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
    pub fn metadata_properties(&self) -> std::option::Option<&crate::model::MetadataProperties> {
        self.metadata_properties.as_ref()
    }
    /// <p>The metrics for the component.</p>
    pub fn metrics(&self) -> std::option::Option<&[crate::model::TrialComponentMetricSummary]> {
        self.metrics.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the lineage group.</p>
    pub fn lineage_group_arn(&self) -> std::option::Option<&str> {
        self.lineage_group_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeTrialComponentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTrialComponentOutput");
        formatter.field("trial_component_name", &self.trial_component_name);
        formatter.field("trial_component_arn", &self.trial_component_arn);
        formatter.field("display_name", &self.display_name);
        formatter.field("source", &self.source);
        formatter.field("status", &self.status);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("created_by", &self.created_by);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("parameters", &self.parameters);
        formatter.field("input_artifacts", &self.input_artifacts);
        formatter.field("output_artifacts", &self.output_artifacts);
        formatter.field("metadata_properties", &self.metadata_properties);
        formatter.field("metrics", &self.metrics);
        formatter.field("lineage_group_arn", &self.lineage_group_arn);
        formatter.finish()
    }
}
/// See [`DescribeTrialComponentOutput`](crate::output::DescribeTrialComponentOutput)
pub mod describe_trial_component_output {
    /// A builder for [`DescribeTrialComponentOutput`](crate::output::DescribeTrialComponentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trial_component_name: std::option::Option<std::string::String>,
        pub(crate) trial_component_arn: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<crate::model::TrialComponentSource>,
        pub(crate) status: std::option::Option<crate::model::TrialComponentStatus>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_by: std::option::Option<crate::model::UserContext>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_by: std::option::Option<crate::model::UserContext>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                crate::model::TrialComponentParameterValue,
            >,
        >,
        pub(crate) input_artifacts: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::TrialComponentArtifact>,
        >,
        pub(crate) output_artifacts: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::TrialComponentArtifact>,
        >,
        pub(crate) metadata_properties: std::option::Option<crate::model::MetadataProperties>,
        pub(crate) metrics:
            std::option::Option<std::vec::Vec<crate::model::TrialComponentMetricSummary>>,
        pub(crate) lineage_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the trial component.</p>
        pub fn trial_component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.trial_component_name = Some(input.into());
            self
        }
        /// <p>The name of the trial component.</p>
        pub fn set_trial_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.trial_component_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the trial component.</p>
        pub fn trial_component_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trial_component_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the trial component.</p>
        pub fn set_trial_component_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.trial_component_arn = input;
            self
        }
        /// <p>The name of the component as displayed. If <code>DisplayName</code> isn't specified, <code>TrialComponentName</code> is displayed.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The name of the component as displayed. If <code>DisplayName</code> isn't specified, <code>TrialComponentName</code> is displayed.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source and, optionally, the job type.</p>
        pub fn source(mut self, input: crate::model::TrialComponentSource) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source and, optionally, the job type.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::TrialComponentSource>,
        ) -> Self {
            self.source = input;
            self
        }
        /// <p>The status of the component. States include:</p>
        /// <ul>
        /// <li> <p>InProgress</p> </li>
        /// <li> <p>Completed</p> </li>
        /// <li> <p>Failed</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::TrialComponentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the component. States include:</p>
        /// <ul>
        /// <li> <p>InProgress</p> </li>
        /// <li> <p>Completed</p> </li>
        /// <li> <p>Failed</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TrialComponentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>When the component started.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>When the component started.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>When the component ended.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>When the component ended.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>When the component was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the component was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>Who created the trial component.</p>
        pub fn created_by(mut self, input: crate::model::UserContext) -> Self {
            self.created_by = Some(input);
            self
        }
        /// <p>Who created the trial component.</p>
        pub fn set_created_by(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.created_by = input;
            self
        }
        /// <p>When the component was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>When the component was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>Who last modified the component.</p>
        pub fn last_modified_by(mut self, input: crate::model::UserContext) -> Self {
            self.last_modified_by = Some(input);
            self
        }
        /// <p>Who last modified the component.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The hyperparameters of the component.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::TrialComponentParameterValue,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.parameters = Some(hash_map);
            self
        }
        /// <p>The hyperparameters of the component.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::TrialComponentParameterValue,
                >,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Adds a key-value pair to `input_artifacts`.
        ///
        /// To override the contents of this collection use [`set_input_artifacts`](Self::set_input_artifacts).
        ///
        /// <p>The input artifacts of the component.</p>
        pub fn input_artifacts(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::TrialComponentArtifact,
        ) -> Self {
            let mut hash_map = self.input_artifacts.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.input_artifacts = Some(hash_map);
            self
        }
        /// <p>The input artifacts of the component.</p>
        pub fn set_input_artifacts(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::TrialComponentArtifact,
                >,
            >,
        ) -> Self {
            self.input_artifacts = input;
            self
        }
        /// Adds a key-value pair to `output_artifacts`.
        ///
        /// To override the contents of this collection use [`set_output_artifacts`](Self::set_output_artifacts).
        ///
        /// <p>The output artifacts of the component.</p>
        pub fn output_artifacts(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::TrialComponentArtifact,
        ) -> Self {
            let mut hash_map = self.output_artifacts.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.output_artifacts = Some(hash_map);
            self
        }
        /// <p>The output artifacts of the component.</p>
        pub fn set_output_artifacts(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::TrialComponentArtifact,
                >,
            >,
        ) -> Self {
            self.output_artifacts = input;
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn metadata_properties(mut self, input: crate::model::MetadataProperties) -> Self {
            self.metadata_properties = Some(input);
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn set_metadata_properties(
            mut self,
            input: std::option::Option<crate::model::MetadataProperties>,
        ) -> Self {
            self.metadata_properties = input;
            self
        }
        /// Appends an item to `metrics`.
        ///
        /// To override the contents of this collection use [`set_metrics`](Self::set_metrics).
        ///
        /// <p>The metrics for the component.</p>
        pub fn metrics(mut self, input: crate::model::TrialComponentMetricSummary) -> Self {
            let mut v = self.metrics.unwrap_or_default();
            v.push(input);
            self.metrics = Some(v);
            self
        }
        /// <p>The metrics for the component.</p>
        pub fn set_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TrialComponentMetricSummary>>,
        ) -> Self {
            self.metrics = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the lineage group.</p>
        pub fn lineage_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.lineage_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the lineage group.</p>
        pub fn set_lineage_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lineage_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTrialComponentOutput`](crate::output::DescribeTrialComponentOutput)
        pub fn build(self) -> crate::output::DescribeTrialComponentOutput {
            crate::output::DescribeTrialComponentOutput {
                trial_component_name: self.trial_component_name,
                trial_component_arn: self.trial_component_arn,
                display_name: self.display_name,
                source: self.source,
                status: self.status,
                start_time: self.start_time,
                end_time: self.end_time,
                creation_time: self.creation_time,
                created_by: self.created_by,
                last_modified_time: self.last_modified_time,
                last_modified_by: self.last_modified_by,
                parameters: self.parameters,
                input_artifacts: self.input_artifacts,
                output_artifacts: self.output_artifacts,
                metadata_properties: self.metadata_properties,
                metrics: self.metrics,
                lineage_group_arn: self.lineage_group_arn,
            }
        }
    }
}
impl DescribeTrialComponentOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTrialComponentOutput`](crate::output::DescribeTrialComponentOutput)
    pub fn builder() -> crate::output::describe_trial_component_output::Builder {
        crate::output::describe_trial_component_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTrialOutput {
    /// <p>The name of the trial.</p>
    pub trial_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the trial.</p>
    pub trial_arn: std::option::Option<std::string::String>,
    /// <p>The name of the trial as displayed. If <code>DisplayName</code> isn't specified, <code>TrialName</code> is displayed.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The name of the experiment the trial is part of.</p>
    pub experiment_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the source and, optionally, the job type.</p>
    pub source: std::option::Option<crate::model::TrialSource>,
    /// <p>When the trial was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Who created the trial.</p>
    pub created_by: std::option::Option<crate::model::UserContext>,
    /// <p>When the trial was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Who last modified the trial.</p>
    pub last_modified_by: std::option::Option<crate::model::UserContext>,
    /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
    pub metadata_properties: std::option::Option<crate::model::MetadataProperties>,
}
impl DescribeTrialOutput {
    /// <p>The name of the trial.</p>
    pub fn trial_name(&self) -> std::option::Option<&str> {
        self.trial_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the trial.</p>
    pub fn trial_arn(&self) -> std::option::Option<&str> {
        self.trial_arn.as_deref()
    }
    /// <p>The name of the trial as displayed. If <code>DisplayName</code> isn't specified, <code>TrialName</code> is displayed.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The name of the experiment the trial is part of.</p>
    pub fn experiment_name(&self) -> std::option::Option<&str> {
        self.experiment_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the source and, optionally, the job type.</p>
    pub fn source(&self) -> std::option::Option<&crate::model::TrialSource> {
        self.source.as_ref()
    }
    /// <p>When the trial was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>Who created the trial.</p>
    pub fn created_by(&self) -> std::option::Option<&crate::model::UserContext> {
        self.created_by.as_ref()
    }
    /// <p>When the trial was last modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>Who last modified the trial.</p>
    pub fn last_modified_by(&self) -> std::option::Option<&crate::model::UserContext> {
        self.last_modified_by.as_ref()
    }
    /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
    pub fn metadata_properties(&self) -> std::option::Option<&crate::model::MetadataProperties> {
        self.metadata_properties.as_ref()
    }
}
impl std::fmt::Debug for DescribeTrialOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTrialOutput");
        formatter.field("trial_name", &self.trial_name);
        formatter.field("trial_arn", &self.trial_arn);
        formatter.field("display_name", &self.display_name);
        formatter.field("experiment_name", &self.experiment_name);
        formatter.field("source", &self.source);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("created_by", &self.created_by);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("metadata_properties", &self.metadata_properties);
        formatter.finish()
    }
}
/// See [`DescribeTrialOutput`](crate::output::DescribeTrialOutput)
pub mod describe_trial_output {
    /// A builder for [`DescribeTrialOutput`](crate::output::DescribeTrialOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trial_name: std::option::Option<std::string::String>,
        pub(crate) trial_arn: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) experiment_name: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<crate::model::TrialSource>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_by: std::option::Option<crate::model::UserContext>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_by: std::option::Option<crate::model::UserContext>,
        pub(crate) metadata_properties: std::option::Option<crate::model::MetadataProperties>,
    }
    impl Builder {
        /// <p>The name of the trial.</p>
        pub fn trial_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.trial_name = Some(input.into());
            self
        }
        /// <p>The name of the trial.</p>
        pub fn set_trial_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trial_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the trial.</p>
        pub fn trial_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trial_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the trial.</p>
        pub fn set_trial_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trial_arn = input;
            self
        }
        /// <p>The name of the trial as displayed. If <code>DisplayName</code> isn't specified, <code>TrialName</code> is displayed.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The name of the trial as displayed. If <code>DisplayName</code> isn't specified, <code>TrialName</code> is displayed.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The name of the experiment the trial is part of.</p>
        pub fn experiment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.experiment_name = Some(input.into());
            self
        }
        /// <p>The name of the experiment the trial is part of.</p>
        pub fn set_experiment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.experiment_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source and, optionally, the job type.</p>
        pub fn source(mut self, input: crate::model::TrialSource) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source and, optionally, the job type.</p>
        pub fn set_source(mut self, input: std::option::Option<crate::model::TrialSource>) -> Self {
            self.source = input;
            self
        }
        /// <p>When the trial was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the trial was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>Who created the trial.</p>
        pub fn created_by(mut self, input: crate::model::UserContext) -> Self {
            self.created_by = Some(input);
            self
        }
        /// <p>Who created the trial.</p>
        pub fn set_created_by(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.created_by = input;
            self
        }
        /// <p>When the trial was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>When the trial was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>Who last modified the trial.</p>
        pub fn last_modified_by(mut self, input: crate::model::UserContext) -> Self {
            self.last_modified_by = Some(input);
            self
        }
        /// <p>Who last modified the trial.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn metadata_properties(mut self, input: crate::model::MetadataProperties) -> Self {
            self.metadata_properties = Some(input);
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn set_metadata_properties(
            mut self,
            input: std::option::Option<crate::model::MetadataProperties>,
        ) -> Self {
            self.metadata_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTrialOutput`](crate::output::DescribeTrialOutput)
        pub fn build(self) -> crate::output::DescribeTrialOutput {
            crate::output::DescribeTrialOutput {
                trial_name: self.trial_name,
                trial_arn: self.trial_arn,
                display_name: self.display_name,
                experiment_name: self.experiment_name,
                source: self.source,
                creation_time: self.creation_time,
                created_by: self.created_by,
                last_modified_time: self.last_modified_time,
                last_modified_by: self.last_modified_by,
                metadata_properties: self.metadata_properties,
            }
        }
    }
}
impl DescribeTrialOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTrialOutput`](crate::output::DescribeTrialOutput)
    pub fn builder() -> crate::output::describe_trial_output::Builder {
        crate::output::describe_trial_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTransformJobOutput {
    /// <p>The name of the transform job.</p>
    pub transform_job_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the transform job.</p>
    pub transform_job_arn: std::option::Option<std::string::String>,
    /// <p>The status of the transform job. If the transform job failed, the reason is returned in the <code>FailureReason</code> field.</p>
    pub transform_job_status: std::option::Option<crate::model::TransformJobStatus>,
    /// <p>If the transform job failed, <code>FailureReason</code> describes why it failed. A transform job creates a log file, which includes error messages, and stores it as an Amazon S3 object. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/logging-cloudwatch.html">Log Amazon SageMaker Events with Amazon CloudWatch</a>.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The name of the model used in the transform job.</p>
    pub model_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of parallel requests on each instance node that can be launched in a transform job. The default value is 1.</p>
    pub max_concurrent_transforms: std::option::Option<i32>,
    /// <p>The timeout and maximum number of retries for processing a transform job invocation.</p>
    pub model_client_config: std::option::Option<crate::model::ModelClientConfig>,
    /// <p>The maximum payload size, in MB, used in the transform job.</p>
    pub max_payload_in_mb: std::option::Option<i32>,
    /// <p>Specifies the number of records to include in a mini-batch for an HTTP inference request. A <i>record</i> <i></i> is a single unit of input data that inference can be made on. For example, a single line in a CSV file is a record. </p>
    /// <p>To enable the batch strategy, you must set <code>SplitType</code> to <code>Line</code>, <code>RecordIO</code>, or <code>TFRecord</code>.</p>
    pub batch_strategy: std::option::Option<crate::model::BatchStrategy>,
    /// <p>The environment variables to set in the Docker container. We support up to 16 key and values entries in the map.</p>
    pub environment:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Describes the dataset to be transformed and the Amazon S3 location where it is stored.</p>
    pub transform_input: std::option::Option<crate::model::TransformInput>,
    /// <p>Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job.</p>
    pub transform_output: std::option::Option<crate::model::TransformOutput>,
    /// <p>Describes the resources, including ML instance types and ML instance count, to use for the transform job.</p>
    pub transform_resources: std::option::Option<crate::model::TransformResources>,
    /// <p>A timestamp that shows when the transform Job was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Indicates when the transform job starts on ML instances. You are billed for the time interval between this time and the value of <code>TransformEndTime</code>.</p>
    pub transform_start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Indicates when the transform job has been completed, or has stopped or failed. You are billed for the time interval between this time and the value of <code>TransformStartTime</code>.</p>
    pub transform_end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon SageMaker Ground Truth labeling job that created the transform or training job.</p>
    pub labeling_job_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the AutoML transform job.</p>
    pub auto_ml_job_arn: std::option::Option<std::string::String>,
    /// <p>The data structure used to specify the data to be used for inference in a batch transform job and to associate the data that is relevant to the prediction results in the output. The input filter provided allows you to exclude input data that is not needed for inference in a batch transform job. The output filter provided allows you to include input data relevant to interpreting the predictions in the output from the job. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html">Associate Prediction Results with their Corresponding Input Records</a>.</p>
    pub data_processing: std::option::Option<crate::model::DataProcessing>,
    /// <p>Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:</p>
    /// <ul>
    /// <li> <p> <code>CreateProcessingJob</code> </p> </li>
    /// <li> <p> <code>CreateTrainingJob</code> </p> </li>
    /// <li> <p> <code>CreateTransformJob</code> </p> </li>
    /// </ul>
    pub experiment_config: std::option::Option<crate::model::ExperimentConfig>,
}
impl DescribeTransformJobOutput {
    /// <p>The name of the transform job.</p>
    pub fn transform_job_name(&self) -> std::option::Option<&str> {
        self.transform_job_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the transform job.</p>
    pub fn transform_job_arn(&self) -> std::option::Option<&str> {
        self.transform_job_arn.as_deref()
    }
    /// <p>The status of the transform job. If the transform job failed, the reason is returned in the <code>FailureReason</code> field.</p>
    pub fn transform_job_status(&self) -> std::option::Option<&crate::model::TransformJobStatus> {
        self.transform_job_status.as_ref()
    }
    /// <p>If the transform job failed, <code>FailureReason</code> describes why it failed. A transform job creates a log file, which includes error messages, and stores it as an Amazon S3 object. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/logging-cloudwatch.html">Log Amazon SageMaker Events with Amazon CloudWatch</a>.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The name of the model used in the transform job.</p>
    pub fn model_name(&self) -> std::option::Option<&str> {
        self.model_name.as_deref()
    }
    /// <p>The maximum number of parallel requests on each instance node that can be launched in a transform job. The default value is 1.</p>
    pub fn max_concurrent_transforms(&self) -> std::option::Option<i32> {
        self.max_concurrent_transforms
    }
    /// <p>The timeout and maximum number of retries for processing a transform job invocation.</p>
    pub fn model_client_config(&self) -> std::option::Option<&crate::model::ModelClientConfig> {
        self.model_client_config.as_ref()
    }
    /// <p>The maximum payload size, in MB, used in the transform job.</p>
    pub fn max_payload_in_mb(&self) -> std::option::Option<i32> {
        self.max_payload_in_mb
    }
    /// <p>Specifies the number of records to include in a mini-batch for an HTTP inference request. A <i>record</i> <i></i> is a single unit of input data that inference can be made on. For example, a single line in a CSV file is a record. </p>
    /// <p>To enable the batch strategy, you must set <code>SplitType</code> to <code>Line</code>, <code>RecordIO</code>, or <code>TFRecord</code>.</p>
    pub fn batch_strategy(&self) -> std::option::Option<&crate::model::BatchStrategy> {
        self.batch_strategy.as_ref()
    }
    /// <p>The environment variables to set in the Docker container. We support up to 16 key and values entries in the map.</p>
    pub fn environment(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.environment.as_ref()
    }
    /// <p>Describes the dataset to be transformed and the Amazon S3 location where it is stored.</p>
    pub fn transform_input(&self) -> std::option::Option<&crate::model::TransformInput> {
        self.transform_input.as_ref()
    }
    /// <p>Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job.</p>
    pub fn transform_output(&self) -> std::option::Option<&crate::model::TransformOutput> {
        self.transform_output.as_ref()
    }
    /// <p>Describes the resources, including ML instance types and ML instance count, to use for the transform job.</p>
    pub fn transform_resources(&self) -> std::option::Option<&crate::model::TransformResources> {
        self.transform_resources.as_ref()
    }
    /// <p>A timestamp that shows when the transform Job was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>Indicates when the transform job starts on ML instances. You are billed for the time interval between this time and the value of <code>TransformEndTime</code>.</p>
    pub fn transform_start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.transform_start_time.as_ref()
    }
    /// <p>Indicates when the transform job has been completed, or has stopped or failed. You are billed for the time interval between this time and the value of <code>TransformStartTime</code>.</p>
    pub fn transform_end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.transform_end_time.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon SageMaker Ground Truth labeling job that created the transform or training job.</p>
    pub fn labeling_job_arn(&self) -> std::option::Option<&str> {
        self.labeling_job_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the AutoML transform job.</p>
    pub fn auto_ml_job_arn(&self) -> std::option::Option<&str> {
        self.auto_ml_job_arn.as_deref()
    }
    /// <p>The data structure used to specify the data to be used for inference in a batch transform job and to associate the data that is relevant to the prediction results in the output. The input filter provided allows you to exclude input data that is not needed for inference in a batch transform job. The output filter provided allows you to include input data relevant to interpreting the predictions in the output from the job. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html">Associate Prediction Results with their Corresponding Input Records</a>.</p>
    pub fn data_processing(&self) -> std::option::Option<&crate::model::DataProcessing> {
        self.data_processing.as_ref()
    }
    /// <p>Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:</p>
    /// <ul>
    /// <li> <p> <code>CreateProcessingJob</code> </p> </li>
    /// <li> <p> <code>CreateTrainingJob</code> </p> </li>
    /// <li> <p> <code>CreateTransformJob</code> </p> </li>
    /// </ul>
    pub fn experiment_config(&self) -> std::option::Option<&crate::model::ExperimentConfig> {
        self.experiment_config.as_ref()
    }
}
impl std::fmt::Debug for DescribeTransformJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTransformJobOutput");
        formatter.field("transform_job_name", &self.transform_job_name);
        formatter.field("transform_job_arn", &self.transform_job_arn);
        formatter.field("transform_job_status", &self.transform_job_status);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("model_name", &self.model_name);
        formatter.field("max_concurrent_transforms", &self.max_concurrent_transforms);
        formatter.field("model_client_config", &self.model_client_config);
        formatter.field("max_payload_in_mb", &self.max_payload_in_mb);
        formatter.field("batch_strategy", &self.batch_strategy);
        formatter.field("environment", &self.environment);
        formatter.field("transform_input", &self.transform_input);
        formatter.field("transform_output", &self.transform_output);
        formatter.field("transform_resources", &self.transform_resources);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("transform_start_time", &self.transform_start_time);
        formatter.field("transform_end_time", &self.transform_end_time);
        formatter.field("labeling_job_arn", &self.labeling_job_arn);
        formatter.field("auto_ml_job_arn", &self.auto_ml_job_arn);
        formatter.field("data_processing", &self.data_processing);
        formatter.field("experiment_config", &self.experiment_config);
        formatter.finish()
    }
}
/// See [`DescribeTransformJobOutput`](crate::output::DescribeTransformJobOutput)
pub mod describe_transform_job_output {
    /// A builder for [`DescribeTransformJobOutput`](crate::output::DescribeTransformJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transform_job_name: std::option::Option<std::string::String>,
        pub(crate) transform_job_arn: std::option::Option<std::string::String>,
        pub(crate) transform_job_status: std::option::Option<crate::model::TransformJobStatus>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) model_name: std::option::Option<std::string::String>,
        pub(crate) max_concurrent_transforms: std::option::Option<i32>,
        pub(crate) model_client_config: std::option::Option<crate::model::ModelClientConfig>,
        pub(crate) max_payload_in_mb: std::option::Option<i32>,
        pub(crate) batch_strategy: std::option::Option<crate::model::BatchStrategy>,
        pub(crate) environment: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) transform_input: std::option::Option<crate::model::TransformInput>,
        pub(crate) transform_output: std::option::Option<crate::model::TransformOutput>,
        pub(crate) transform_resources: std::option::Option<crate::model::TransformResources>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) transform_start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) transform_end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) labeling_job_arn: std::option::Option<std::string::String>,
        pub(crate) auto_ml_job_arn: std::option::Option<std::string::String>,
        pub(crate) data_processing: std::option::Option<crate::model::DataProcessing>,
        pub(crate) experiment_config: std::option::Option<crate::model::ExperimentConfig>,
    }
    impl Builder {
        /// <p>The name of the transform job.</p>
        pub fn transform_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.transform_job_name = Some(input.into());
            self
        }
        /// <p>The name of the transform job.</p>
        pub fn set_transform_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transform_job_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the transform job.</p>
        pub fn transform_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.transform_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the transform job.</p>
        pub fn set_transform_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transform_job_arn = input;
            self
        }
        /// <p>The status of the transform job. If the transform job failed, the reason is returned in the <code>FailureReason</code> field.</p>
        pub fn transform_job_status(mut self, input: crate::model::TransformJobStatus) -> Self {
            self.transform_job_status = Some(input);
            self
        }
        /// <p>The status of the transform job. If the transform job failed, the reason is returned in the <code>FailureReason</code> field.</p>
        pub fn set_transform_job_status(
            mut self,
            input: std::option::Option<crate::model::TransformJobStatus>,
        ) -> Self {
            self.transform_job_status = input;
            self
        }
        /// <p>If the transform job failed, <code>FailureReason</code> describes why it failed. A transform job creates a log file, which includes error messages, and stores it as an Amazon S3 object. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/logging-cloudwatch.html">Log Amazon SageMaker Events with Amazon CloudWatch</a>.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If the transform job failed, <code>FailureReason</code> describes why it failed. A transform job creates a log file, which includes error messages, and stores it as an Amazon S3 object. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/logging-cloudwatch.html">Log Amazon SageMaker Events with Amazon CloudWatch</a>.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The name of the model used in the transform job.</p>
        pub fn model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_name = Some(input.into());
            self
        }
        /// <p>The name of the model used in the transform job.</p>
        pub fn set_model_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_name = input;
            self
        }
        /// <p>The maximum number of parallel requests on each instance node that can be launched in a transform job. The default value is 1.</p>
        pub fn max_concurrent_transforms(mut self, input: i32) -> Self {
            self.max_concurrent_transforms = Some(input);
            self
        }
        /// <p>The maximum number of parallel requests on each instance node that can be launched in a transform job. The default value is 1.</p>
        pub fn set_max_concurrent_transforms(mut self, input: std::option::Option<i32>) -> Self {
            self.max_concurrent_transforms = input;
            self
        }
        /// <p>The timeout and maximum number of retries for processing a transform job invocation.</p>
        pub fn model_client_config(mut self, input: crate::model::ModelClientConfig) -> Self {
            self.model_client_config = Some(input);
            self
        }
        /// <p>The timeout and maximum number of retries for processing a transform job invocation.</p>
        pub fn set_model_client_config(
            mut self,
            input: std::option::Option<crate::model::ModelClientConfig>,
        ) -> Self {
            self.model_client_config = input;
            self
        }
        /// <p>The maximum payload size, in MB, used in the transform job.</p>
        pub fn max_payload_in_mb(mut self, input: i32) -> Self {
            self.max_payload_in_mb = Some(input);
            self
        }
        /// <p>The maximum payload size, in MB, used in the transform job.</p>
        pub fn set_max_payload_in_mb(mut self, input: std::option::Option<i32>) -> Self {
            self.max_payload_in_mb = input;
            self
        }
        /// <p>Specifies the number of records to include in a mini-batch for an HTTP inference request. A <i>record</i> <i></i> is a single unit of input data that inference can be made on. For example, a single line in a CSV file is a record. </p>
        /// <p>To enable the batch strategy, you must set <code>SplitType</code> to <code>Line</code>, <code>RecordIO</code>, or <code>TFRecord</code>.</p>
        pub fn batch_strategy(mut self, input: crate::model::BatchStrategy) -> Self {
            self.batch_strategy = Some(input);
            self
        }
        /// <p>Specifies the number of records to include in a mini-batch for an HTTP inference request. A <i>record</i> <i></i> is a single unit of input data that inference can be made on. For example, a single line in a CSV file is a record. </p>
        /// <p>To enable the batch strategy, you must set <code>SplitType</code> to <code>Line</code>, <code>RecordIO</code>, or <code>TFRecord</code>.</p>
        pub fn set_batch_strategy(
            mut self,
            input: std::option::Option<crate::model::BatchStrategy>,
        ) -> Self {
            self.batch_strategy = input;
            self
        }
        /// Adds a key-value pair to `environment`.
        ///
        /// To override the contents of this collection use [`set_environment`](Self::set_environment).
        ///
        /// <p>The environment variables to set in the Docker container. We support up to 16 key and values entries in the map.</p>
        pub fn environment(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.environment.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.environment = Some(hash_map);
            self
        }
        /// <p>The environment variables to set in the Docker container. We support up to 16 key and values entries in the map.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.environment = input;
            self
        }
        /// <p>Describes the dataset to be transformed and the Amazon S3 location where it is stored.</p>
        pub fn transform_input(mut self, input: crate::model::TransformInput) -> Self {
            self.transform_input = Some(input);
            self
        }
        /// <p>Describes the dataset to be transformed and the Amazon S3 location where it is stored.</p>
        pub fn set_transform_input(
            mut self,
            input: std::option::Option<crate::model::TransformInput>,
        ) -> Self {
            self.transform_input = input;
            self
        }
        /// <p>Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job.</p>
        pub fn transform_output(mut self, input: crate::model::TransformOutput) -> Self {
            self.transform_output = Some(input);
            self
        }
        /// <p>Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job.</p>
        pub fn set_transform_output(
            mut self,
            input: std::option::Option<crate::model::TransformOutput>,
        ) -> Self {
            self.transform_output = input;
            self
        }
        /// <p>Describes the resources, including ML instance types and ML instance count, to use for the transform job.</p>
        pub fn transform_resources(mut self, input: crate::model::TransformResources) -> Self {
            self.transform_resources = Some(input);
            self
        }
        /// <p>Describes the resources, including ML instance types and ML instance count, to use for the transform job.</p>
        pub fn set_transform_resources(
            mut self,
            input: std::option::Option<crate::model::TransformResources>,
        ) -> Self {
            self.transform_resources = input;
            self
        }
        /// <p>A timestamp that shows when the transform Job was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A timestamp that shows when the transform Job was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>Indicates when the transform job starts on ML instances. You are billed for the time interval between this time and the value of <code>TransformEndTime</code>.</p>
        pub fn transform_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.transform_start_time = Some(input);
            self
        }
        /// <p>Indicates when the transform job starts on ML instances. You are billed for the time interval between this time and the value of <code>TransformEndTime</code>.</p>
        pub fn set_transform_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.transform_start_time = input;
            self
        }
        /// <p>Indicates when the transform job has been completed, or has stopped or failed. You are billed for the time interval between this time and the value of <code>TransformStartTime</code>.</p>
        pub fn transform_end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.transform_end_time = Some(input);
            self
        }
        /// <p>Indicates when the transform job has been completed, or has stopped or failed. You are billed for the time interval between this time and the value of <code>TransformStartTime</code>.</p>
        pub fn set_transform_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.transform_end_time = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SageMaker Ground Truth labeling job that created the transform or training job.</p>
        pub fn labeling_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.labeling_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SageMaker Ground Truth labeling job that created the transform or training job.</p>
        pub fn set_labeling_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.labeling_job_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AutoML transform job.</p>
        pub fn auto_ml_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_ml_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AutoML transform job.</p>
        pub fn set_auto_ml_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_ml_job_arn = input;
            self
        }
        /// <p>The data structure used to specify the data to be used for inference in a batch transform job and to associate the data that is relevant to the prediction results in the output. The input filter provided allows you to exclude input data that is not needed for inference in a batch transform job. The output filter provided allows you to include input data relevant to interpreting the predictions in the output from the job. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html">Associate Prediction Results with their Corresponding Input Records</a>.</p>
        pub fn data_processing(mut self, input: crate::model::DataProcessing) -> Self {
            self.data_processing = Some(input);
            self
        }
        /// <p>The data structure used to specify the data to be used for inference in a batch transform job and to associate the data that is relevant to the prediction results in the output. The input filter provided allows you to exclude input data that is not needed for inference in a batch transform job. The output filter provided allows you to include input data relevant to interpreting the predictions in the output from the job. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html">Associate Prediction Results with their Corresponding Input Records</a>.</p>
        pub fn set_data_processing(
            mut self,
            input: std::option::Option<crate::model::DataProcessing>,
        ) -> Self {
            self.data_processing = input;
            self
        }
        /// <p>Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:</p>
        /// <ul>
        /// <li> <p> <code>CreateProcessingJob</code> </p> </li>
        /// <li> <p> <code>CreateTrainingJob</code> </p> </li>
        /// <li> <p> <code>CreateTransformJob</code> </p> </li>
        /// </ul>
        pub fn experiment_config(mut self, input: crate::model::ExperimentConfig) -> Self {
            self.experiment_config = Some(input);
            self
        }
        /// <p>Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:</p>
        /// <ul>
        /// <li> <p> <code>CreateProcessingJob</code> </p> </li>
        /// <li> <p> <code>CreateTrainingJob</code> </p> </li>
        /// <li> <p> <code>CreateTransformJob</code> </p> </li>
        /// </ul>
        pub fn set_experiment_config(
            mut self,
            input: std::option::Option<crate::model::ExperimentConfig>,
        ) -> Self {
            self.experiment_config = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTransformJobOutput`](crate::output::DescribeTransformJobOutput)
        pub fn build(self) -> crate::output::DescribeTransformJobOutput {
            crate::output::DescribeTransformJobOutput {
                transform_job_name: self.transform_job_name,
                transform_job_arn: self.transform_job_arn,
                transform_job_status: self.transform_job_status,
                failure_reason: self.failure_reason,
                model_name: self.model_name,
                max_concurrent_transforms: self.max_concurrent_transforms,
                model_client_config: self.model_client_config,
                max_payload_in_mb: self.max_payload_in_mb,
                batch_strategy: self.batch_strategy,
                environment: self.environment,
                transform_input: self.transform_input,
                transform_output: self.transform_output,
                transform_resources: self.transform_resources,
                creation_time: self.creation_time,
                transform_start_time: self.transform_start_time,
                transform_end_time: self.transform_end_time,
                labeling_job_arn: self.labeling_job_arn,
                auto_ml_job_arn: self.auto_ml_job_arn,
                data_processing: self.data_processing,
                experiment_config: self.experiment_config,
            }
        }
    }
}
impl DescribeTransformJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTransformJobOutput`](crate::output::DescribeTransformJobOutput)
    pub fn builder() -> crate::output::describe_transform_job_output::Builder {
        crate::output::describe_transform_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTrainingJobOutput {
    /// <p> Name of the model training job. </p>
    pub training_job_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the training job.</p>
    pub training_job_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the associated hyperparameter tuning job if the training job was launched by a hyperparameter tuning job.</p>
    pub tuning_job_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon SageMaker Ground Truth labeling job that created the transform or training job.</p>
    pub labeling_job_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of an AutoML job.</p>
    pub auto_ml_job_arn: std::option::Option<std::string::String>,
    /// <p>Information about the Amazon S3 location that is configured for storing model artifacts. </p>
    pub model_artifacts: std::option::Option<crate::model::ModelArtifacts>,
    /// <p>The status of the training job.</p>
    /// <p>Amazon SageMaker provides the following training job statuses:</p>
    /// <ul>
    /// <li> <p> <code>InProgress</code> - The training is in progress.</p> </li>
    /// <li> <p> <code>Completed</code> - The training job has completed.</p> </li>
    /// <li> <p> <code>Failed</code> - The training job has failed. To see the reason for the failure, see the <code>FailureReason</code> field in the response to a <code>DescribeTrainingJobResponse</code> call.</p> </li>
    /// <li> <p> <code>Stopping</code> - The training job is stopping.</p> </li>
    /// <li> <p> <code>Stopped</code> - The training job has stopped.</p> </li>
    /// </ul>
    /// <p>For more detailed information, see <code>SecondaryStatus</code>. </p>
    pub training_job_status: std::option::Option<crate::model::TrainingJobStatus>,
    /// <p> Provides detailed information about the state of the training job. For detailed information on the secondary status of the training job, see <code>StatusMessage</code> under <code>SecondaryStatusTransition</code>.</p>
    /// <p>Amazon SageMaker provides primary statuses and secondary statuses that apply to each of them:</p>
    /// <dl>
    /// <dt>
    /// InProgress
    /// </dt>
    /// <dd>
    /// <ul>
    /// <li> <p> <code>Starting</code> - Starting the training job.</p> </li>
    /// <li> <p> <code>Downloading</code> - An optional stage for algorithms that support <code>File</code> training input mode. It indicates that data is being downloaded to the ML storage volumes.</p> </li>
    /// <li> <p> <code>Training</code> - Training is in progress.</p> </li>
    /// <li> <p> <code>Interrupted</code> - The job stopped because the managed spot training instances were interrupted. </p> </li>
    /// <li> <p> <code>Uploading</code> - Training is complete and the model artifacts are being uploaded to the S3 location.</p> </li>
    /// </ul>
    /// </dd>
    /// <dt>
    /// Completed
    /// </dt>
    /// <dd>
    /// <ul>
    /// <li> <p> <code>Completed</code> - The training job has completed.</p> </li>
    /// </ul>
    /// </dd>
    /// <dt>
    /// Failed
    /// </dt>
    /// <dd>
    /// <ul>
    /// <li> <p> <code>Failed</code> - The training job has failed. The reason for the failure is returned in the <code>FailureReason</code> field of <code>DescribeTrainingJobResponse</code>.</p> </li>
    /// </ul>
    /// </dd>
    /// <dt>
    /// Stopped
    /// </dt>
    /// <dd>
    /// <ul>
    /// <li> <p> <code>MaxRuntimeExceeded</code> - The job stopped because it exceeded the maximum allowed runtime.</p> </li>
    /// <li> <p> <code>MaxWaitTimeExceeded</code> - The job stopped because it exceeded the maximum allowed wait time.</p> </li>
    /// <li> <p> <code>Stopped</code> - The training job has stopped.</p> </li>
    /// </ul>
    /// </dd>
    /// <dt>
    /// Stopping
    /// </dt>
    /// <dd>
    /// <ul>
    /// <li> <p> <code>Stopping</code> - Stopping the training job.</p> </li>
    /// </ul>
    /// </dd>
    /// </dl> <important>
    /// <p>Valid values for <code>SecondaryStatus</code> are subject to change. </p>
    /// </important>
    /// <p>We no longer support the following secondary statuses:</p>
    /// <ul>
    /// <li> <p> <code>LaunchingMLInstances</code> </p> </li>
    /// <li> <p> <code>PreparingTraining</code> </p> </li>
    /// <li> <p> <code>DownloadingTrainingImage</code> </p> </li>
    /// </ul>
    pub secondary_status: std::option::Option<crate::model::SecondaryStatus>,
    /// <p>If the training job failed, the reason it failed. </p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>Algorithm-specific parameters. </p>
    pub hyper_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Information about the algorithm used for training, and algorithm metadata. </p>
    pub algorithm_specification: std::option::Option<crate::model::AlgorithmSpecification>,
    /// <p>The Amazon Web Services Identity and Access Management (IAM) role configured for the training job. </p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>An array of <code>Channel</code> objects that describes each data input channel. </p>
    pub input_data_config: std::option::Option<std::vec::Vec<crate::model::Channel>>,
    /// <p>The S3 path where model artifacts that you configured when creating the job are stored. Amazon SageMaker creates subfolders for model artifacts. </p>
    pub output_data_config: std::option::Option<crate::model::OutputDataConfig>,
    /// <p>Resources, including ML compute instances and ML storage volumes, that are configured for model training. </p>
    pub resource_config: std::option::Option<crate::model::ResourceConfig>,
    /// <p>A <code>VpcConfig</code> object that specifies the VPC that this training job has access to. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an Amazon Virtual Private Cloud</a>.</p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
    /// <p>Specifies a limit to how long a model training job can run. It also specifies how long a managed Spot training job has to complete. When the job reaches the time limit, Amazon SageMaker ends the training job. Use this API to cap model training costs.</p>
    /// <p>To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost. </p>
    pub stopping_condition: std::option::Option<crate::model::StoppingCondition>,
    /// <p>A timestamp that indicates when the training job was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Indicates the time when the training job starts on training instances. You are billed for the time interval between this time and the value of <code>TrainingEndTime</code>. The start time in CloudWatch Logs might be later than this time. The difference is due to the time it takes to download the training data and to the size of the training container.</p>
    pub training_start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Indicates the time when the training job ends on training instances. You are billed for the time interval between the value of <code>TrainingStartTime</code> and this time. For successful jobs and stopped jobs, this is the time after model artifacts are uploaded. For failed jobs, this is the time when Amazon SageMaker detects a job failure.</p>
    pub training_end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp that indicates when the status of the training job was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A history of all of the secondary statuses that the training job has transitioned through.</p>
    pub secondary_status_transitions:
        std::option::Option<std::vec::Vec<crate::model::SecondaryStatusTransition>>,
    /// <p>A collection of <code>MetricData</code> objects that specify the names, values, and dates and times that the training algorithm emitted to Amazon CloudWatch.</p>
    pub final_metric_data_list: std::option::Option<std::vec::Vec<crate::model::MetricData>>,
    /// <p>If you want to allow inbound or outbound network calls, except for calls between peers within a training cluster for distributed training, choose <code>True</code>. If you enable network isolation for training jobs that are configured to use a VPC, Amazon SageMaker downloads and uploads customer data and model artifacts through the specified VPC, but the training container does not have network access.</p>
    pub enable_network_isolation: bool,
    /// <p>To encrypt all communications between ML compute instances in distributed training, choose <code>True</code>. Encryption provides greater security for distributed training, but training might take longer. How long it takes depends on the amount of communication between compute instances, especially if you use a deep learning algorithms in distributed training.</p>
    pub enable_inter_container_traffic_encryption: bool,
    /// <p>A Boolean indicating whether managed spot training is enabled (<code>True</code>) or not (<code>False</code>).</p>
    pub enable_managed_spot_training: bool,
    /// <p>Contains information about the output location for managed spot training checkpoint data. </p>
    pub checkpoint_config: std::option::Option<crate::model::CheckpointConfig>,
    /// <p>The training time in seconds.</p>
    pub training_time_in_seconds: std::option::Option<i32>,
    /// <p>The billable time in seconds. Billable time refers to the absolute wall-clock time.</p>
    /// <p>Multiply <code>BillableTimeInSeconds</code> by the number of instances (<code>InstanceCount</code>) in your training cluster to get the total compute time SageMaker will bill you if you run distributed training. The formula is as follows: <code>BillableTimeInSeconds * InstanceCount</code> .</p>
    /// <p>You can calculate the savings from using managed spot training using the formula <code>(1 - BillableTimeInSeconds / TrainingTimeInSeconds) * 100</code>. For example, if <code>BillableTimeInSeconds</code> is 100 and <code>TrainingTimeInSeconds</code> is 500, the savings is 80%.</p>
    pub billable_time_in_seconds: std::option::Option<i32>,
    /// <p>Configuration information for the Debugger hook parameters, metric and tensor collections, and storage paths. To learn more about how to configure the <code>DebugHookConfig</code> parameter, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html">Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job</a>.</p>
    pub debug_hook_config: std::option::Option<crate::model::DebugHookConfig>,
    /// <p>Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:</p>
    /// <ul>
    /// <li> <p> <code>CreateProcessingJob</code> </p> </li>
    /// <li> <p> <code>CreateTrainingJob</code> </p> </li>
    /// <li> <p> <code>CreateTransformJob</code> </p> </li>
    /// </ul>
    pub experiment_config: std::option::Option<crate::model::ExperimentConfig>,
    /// <p>Configuration information for Debugger rules for debugging output tensors.</p>
    pub debug_rule_configurations:
        std::option::Option<std::vec::Vec<crate::model::DebugRuleConfiguration>>,
    /// <p>Configuration of storage locations for the Debugger TensorBoard output data.</p>
    pub tensor_board_output_config: std::option::Option<crate::model::TensorBoardOutputConfig>,
    /// <p>Evaluation status of Debugger rules for debugging on a training job.</p>
    pub debug_rule_evaluation_statuses:
        std::option::Option<std::vec::Vec<crate::model::DebugRuleEvaluationStatus>>,
    /// <p>Configuration information for Debugger system monitoring, framework profiling, and storage paths.</p>
    pub profiler_config: std::option::Option<crate::model::ProfilerConfig>,
    /// <p>Configuration information for Debugger rules for profiling system and framework metrics.</p>
    pub profiler_rule_configurations:
        std::option::Option<std::vec::Vec<crate::model::ProfilerRuleConfiguration>>,
    /// <p>Evaluation status of Debugger rules for profiling on a training job.</p>
    pub profiler_rule_evaluation_statuses:
        std::option::Option<std::vec::Vec<crate::model::ProfilerRuleEvaluationStatus>>,
    /// <p>Profiling status of a training job.</p>
    pub profiling_status: std::option::Option<crate::model::ProfilingStatus>,
    /// <p>The number of times to retry the job when the job fails due to an <code>InternalServerError</code>.</p>
    pub retry_strategy: std::option::Option<crate::model::RetryStrategy>,
    /// <p>The environment variables to set in the Docker container.</p>
    pub environment:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl DescribeTrainingJobOutput {
    /// <p> Name of the model training job. </p>
    pub fn training_job_name(&self) -> std::option::Option<&str> {
        self.training_job_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the training job.</p>
    pub fn training_job_arn(&self) -> std::option::Option<&str> {
        self.training_job_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the associated hyperparameter tuning job if the training job was launched by a hyperparameter tuning job.</p>
    pub fn tuning_job_arn(&self) -> std::option::Option<&str> {
        self.tuning_job_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon SageMaker Ground Truth labeling job that created the transform or training job.</p>
    pub fn labeling_job_arn(&self) -> std::option::Option<&str> {
        self.labeling_job_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an AutoML job.</p>
    pub fn auto_ml_job_arn(&self) -> std::option::Option<&str> {
        self.auto_ml_job_arn.as_deref()
    }
    /// <p>Information about the Amazon S3 location that is configured for storing model artifacts. </p>
    pub fn model_artifacts(&self) -> std::option::Option<&crate::model::ModelArtifacts> {
        self.model_artifacts.as_ref()
    }
    /// <p>The status of the training job.</p>
    /// <p>Amazon SageMaker provides the following training job statuses:</p>
    /// <ul>
    /// <li> <p> <code>InProgress</code> - The training is in progress.</p> </li>
    /// <li> <p> <code>Completed</code> - The training job has completed.</p> </li>
    /// <li> <p> <code>Failed</code> - The training job has failed. To see the reason for the failure, see the <code>FailureReason</code> field in the response to a <code>DescribeTrainingJobResponse</code> call.</p> </li>
    /// <li> <p> <code>Stopping</code> - The training job is stopping.</p> </li>
    /// <li> <p> <code>Stopped</code> - The training job has stopped.</p> </li>
    /// </ul>
    /// <p>For more detailed information, see <code>SecondaryStatus</code>. </p>
    pub fn training_job_status(&self) -> std::option::Option<&crate::model::TrainingJobStatus> {
        self.training_job_status.as_ref()
    }
    /// <p> Provides detailed information about the state of the training job. For detailed information on the secondary status of the training job, see <code>StatusMessage</code> under <code>SecondaryStatusTransition</code>.</p>
    /// <p>Amazon SageMaker provides primary statuses and secondary statuses that apply to each of them:</p>
    /// <dl>
    /// <dt>
    /// InProgress
    /// </dt>
    /// <dd>
    /// <ul>
    /// <li> <p> <code>Starting</code> - Starting the training job.</p> </li>
    /// <li> <p> <code>Downloading</code> - An optional stage for algorithms that support <code>File</code> training input mode. It indicates that data is being downloaded to the ML storage volumes.</p> </li>
    /// <li> <p> <code>Training</code> - Training is in progress.</p> </li>
    /// <li> <p> <code>Interrupted</code> - The job stopped because the managed spot training instances were interrupted. </p> </li>
    /// <li> <p> <code>Uploading</code> - Training is complete and the model artifacts are being uploaded to the S3 location.</p> </li>
    /// </ul>
    /// </dd>
    /// <dt>
    /// Completed
    /// </dt>
    /// <dd>
    /// <ul>
    /// <li> <p> <code>Completed</code> - The training job has completed.</p> </li>
    /// </ul>
    /// </dd>
    /// <dt>
    /// Failed
    /// </dt>
    /// <dd>
    /// <ul>
    /// <li> <p> <code>Failed</code> - The training job has failed. The reason for the failure is returned in the <code>FailureReason</code> field of <code>DescribeTrainingJobResponse</code>.</p> </li>
    /// </ul>
    /// </dd>
    /// <dt>
    /// Stopped
    /// </dt>
    /// <dd>
    /// <ul>
    /// <li> <p> <code>MaxRuntimeExceeded</code> - The job stopped because it exceeded the maximum allowed runtime.</p> </li>
    /// <li> <p> <code>MaxWaitTimeExceeded</code> - The job stopped because it exceeded the maximum allowed wait time.</p> </li>
    /// <li> <p> <code>Stopped</code> - The training job has stopped.</p> </li>
    /// </ul>
    /// </dd>
    /// <dt>
    /// Stopping
    /// </dt>
    /// <dd>
    /// <ul>
    /// <li> <p> <code>Stopping</code> - Stopping the training job.</p> </li>
    /// </ul>
    /// </dd>
    /// </dl> <important>
    /// <p>Valid values for <code>SecondaryStatus</code> are subject to change. </p>
    /// </important>
    /// <p>We no longer support the following secondary statuses:</p>
    /// <ul>
    /// <li> <p> <code>LaunchingMLInstances</code> </p> </li>
    /// <li> <p> <code>PreparingTraining</code> </p> </li>
    /// <li> <p> <code>DownloadingTrainingImage</code> </p> </li>
    /// </ul>
    pub fn secondary_status(&self) -> std::option::Option<&crate::model::SecondaryStatus> {
        self.secondary_status.as_ref()
    }
    /// <p>If the training job failed, the reason it failed. </p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>Algorithm-specific parameters. </p>
    pub fn hyper_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.hyper_parameters.as_ref()
    }
    /// <p>Information about the algorithm used for training, and algorithm metadata. </p>
    pub fn algorithm_specification(
        &self,
    ) -> std::option::Option<&crate::model::AlgorithmSpecification> {
        self.algorithm_specification.as_ref()
    }
    /// <p>The Amazon Web Services Identity and Access Management (IAM) role configured for the training job. </p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>An array of <code>Channel</code> objects that describes each data input channel. </p>
    pub fn input_data_config(&self) -> std::option::Option<&[crate::model::Channel]> {
        self.input_data_config.as_deref()
    }
    /// <p>The S3 path where model artifacts that you configured when creating the job are stored. Amazon SageMaker creates subfolders for model artifacts. </p>
    pub fn output_data_config(&self) -> std::option::Option<&crate::model::OutputDataConfig> {
        self.output_data_config.as_ref()
    }
    /// <p>Resources, including ML compute instances and ML storage volumes, that are configured for model training. </p>
    pub fn resource_config(&self) -> std::option::Option<&crate::model::ResourceConfig> {
        self.resource_config.as_ref()
    }
    /// <p>A <code>VpcConfig</code> object that specifies the VPC that this training job has access to. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an Amazon Virtual Private Cloud</a>.</p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfig> {
        self.vpc_config.as_ref()
    }
    /// <p>Specifies a limit to how long a model training job can run. It also specifies how long a managed Spot training job has to complete. When the job reaches the time limit, Amazon SageMaker ends the training job. Use this API to cap model training costs.</p>
    /// <p>To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost. </p>
    pub fn stopping_condition(&self) -> std::option::Option<&crate::model::StoppingCondition> {
        self.stopping_condition.as_ref()
    }
    /// <p>A timestamp that indicates when the training job was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>Indicates the time when the training job starts on training instances. You are billed for the time interval between this time and the value of <code>TrainingEndTime</code>. The start time in CloudWatch Logs might be later than this time. The difference is due to the time it takes to download the training data and to the size of the training container.</p>
    pub fn training_start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.training_start_time.as_ref()
    }
    /// <p>Indicates the time when the training job ends on training instances. You are billed for the time interval between the value of <code>TrainingStartTime</code> and this time. For successful jobs and stopped jobs, this is the time after model artifacts are uploaded. For failed jobs, this is the time when Amazon SageMaker detects a job failure.</p>
    pub fn training_end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.training_end_time.as_ref()
    }
    /// <p>A timestamp that indicates when the status of the training job was last modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>A history of all of the secondary statuses that the training job has transitioned through.</p>
    pub fn secondary_status_transitions(
        &self,
    ) -> std::option::Option<&[crate::model::SecondaryStatusTransition]> {
        self.secondary_status_transitions.as_deref()
    }
    /// <p>A collection of <code>MetricData</code> objects that specify the names, values, and dates and times that the training algorithm emitted to Amazon CloudWatch.</p>
    pub fn final_metric_data_list(&self) -> std::option::Option<&[crate::model::MetricData]> {
        self.final_metric_data_list.as_deref()
    }
    /// <p>If you want to allow inbound or outbound network calls, except for calls between peers within a training cluster for distributed training, choose <code>True</code>. If you enable network isolation for training jobs that are configured to use a VPC, Amazon SageMaker downloads and uploads customer data and model artifacts through the specified VPC, but the training container does not have network access.</p>
    pub fn enable_network_isolation(&self) -> bool {
        self.enable_network_isolation
    }
    /// <p>To encrypt all communications between ML compute instances in distributed training, choose <code>True</code>. Encryption provides greater security for distributed training, but training might take longer. How long it takes depends on the amount of communication between compute instances, especially if you use a deep learning algorithms in distributed training.</p>
    pub fn enable_inter_container_traffic_encryption(&self) -> bool {
        self.enable_inter_container_traffic_encryption
    }
    /// <p>A Boolean indicating whether managed spot training is enabled (<code>True</code>) or not (<code>False</code>).</p>
    pub fn enable_managed_spot_training(&self) -> bool {
        self.enable_managed_spot_training
    }
    /// <p>Contains information about the output location for managed spot training checkpoint data. </p>
    pub fn checkpoint_config(&self) -> std::option::Option<&crate::model::CheckpointConfig> {
        self.checkpoint_config.as_ref()
    }
    /// <p>The training time in seconds.</p>
    pub fn training_time_in_seconds(&self) -> std::option::Option<i32> {
        self.training_time_in_seconds
    }
    /// <p>The billable time in seconds. Billable time refers to the absolute wall-clock time.</p>
    /// <p>Multiply <code>BillableTimeInSeconds</code> by the number of instances (<code>InstanceCount</code>) in your training cluster to get the total compute time SageMaker will bill you if you run distributed training. The formula is as follows: <code>BillableTimeInSeconds * InstanceCount</code> .</p>
    /// <p>You can calculate the savings from using managed spot training using the formula <code>(1 - BillableTimeInSeconds / TrainingTimeInSeconds) * 100</code>. For example, if <code>BillableTimeInSeconds</code> is 100 and <code>TrainingTimeInSeconds</code> is 500, the savings is 80%.</p>
    pub fn billable_time_in_seconds(&self) -> std::option::Option<i32> {
        self.billable_time_in_seconds
    }
    /// <p>Configuration information for the Debugger hook parameters, metric and tensor collections, and storage paths. To learn more about how to configure the <code>DebugHookConfig</code> parameter, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html">Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job</a>.</p>
    pub fn debug_hook_config(&self) -> std::option::Option<&crate::model::DebugHookConfig> {
        self.debug_hook_config.as_ref()
    }
    /// <p>Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:</p>
    /// <ul>
    /// <li> <p> <code>CreateProcessingJob</code> </p> </li>
    /// <li> <p> <code>CreateTrainingJob</code> </p> </li>
    /// <li> <p> <code>CreateTransformJob</code> </p> </li>
    /// </ul>
    pub fn experiment_config(&self) -> std::option::Option<&crate::model::ExperimentConfig> {
        self.experiment_config.as_ref()
    }
    /// <p>Configuration information for Debugger rules for debugging output tensors.</p>
    pub fn debug_rule_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::DebugRuleConfiguration]> {
        self.debug_rule_configurations.as_deref()
    }
    /// <p>Configuration of storage locations for the Debugger TensorBoard output data.</p>
    pub fn tensor_board_output_config(
        &self,
    ) -> std::option::Option<&crate::model::TensorBoardOutputConfig> {
        self.tensor_board_output_config.as_ref()
    }
    /// <p>Evaluation status of Debugger rules for debugging on a training job.</p>
    pub fn debug_rule_evaluation_statuses(
        &self,
    ) -> std::option::Option<&[crate::model::DebugRuleEvaluationStatus]> {
        self.debug_rule_evaluation_statuses.as_deref()
    }
    /// <p>Configuration information for Debugger system monitoring, framework profiling, and storage paths.</p>
    pub fn profiler_config(&self) -> std::option::Option<&crate::model::ProfilerConfig> {
        self.profiler_config.as_ref()
    }
    /// <p>Configuration information for Debugger rules for profiling system and framework metrics.</p>
    pub fn profiler_rule_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::ProfilerRuleConfiguration]> {
        self.profiler_rule_configurations.as_deref()
    }
    /// <p>Evaluation status of Debugger rules for profiling on a training job.</p>
    pub fn profiler_rule_evaluation_statuses(
        &self,
    ) -> std::option::Option<&[crate::model::ProfilerRuleEvaluationStatus]> {
        self.profiler_rule_evaluation_statuses.as_deref()
    }
    /// <p>Profiling status of a training job.</p>
    pub fn profiling_status(&self) -> std::option::Option<&crate::model::ProfilingStatus> {
        self.profiling_status.as_ref()
    }
    /// <p>The number of times to retry the job when the job fails due to an <code>InternalServerError</code>.</p>
    pub fn retry_strategy(&self) -> std::option::Option<&crate::model::RetryStrategy> {
        self.retry_strategy.as_ref()
    }
    /// <p>The environment variables to set in the Docker container.</p>
    pub fn environment(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.environment.as_ref()
    }
}
impl std::fmt::Debug for DescribeTrainingJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTrainingJobOutput");
        formatter.field("training_job_name", &self.training_job_name);
        formatter.field("training_job_arn", &self.training_job_arn);
        formatter.field("tuning_job_arn", &self.tuning_job_arn);
        formatter.field("labeling_job_arn", &self.labeling_job_arn);
        formatter.field("auto_ml_job_arn", &self.auto_ml_job_arn);
        formatter.field("model_artifacts", &self.model_artifacts);
        formatter.field("training_job_status", &self.training_job_status);
        formatter.field("secondary_status", &self.secondary_status);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("hyper_parameters", &self.hyper_parameters);
        formatter.field("algorithm_specification", &self.algorithm_specification);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("input_data_config", &self.input_data_config);
        formatter.field("output_data_config", &self.output_data_config);
        formatter.field("resource_config", &self.resource_config);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("stopping_condition", &self.stopping_condition);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("training_start_time", &self.training_start_time);
        formatter.field("training_end_time", &self.training_end_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field(
            "secondary_status_transitions",
            &self.secondary_status_transitions,
        );
        formatter.field("final_metric_data_list", &self.final_metric_data_list);
        formatter.field("enable_network_isolation", &self.enable_network_isolation);
        formatter.field(
            "enable_inter_container_traffic_encryption",
            &self.enable_inter_container_traffic_encryption,
        );
        formatter.field(
            "enable_managed_spot_training",
            &self.enable_managed_spot_training,
        );
        formatter.field("checkpoint_config", &self.checkpoint_config);
        formatter.field("training_time_in_seconds", &self.training_time_in_seconds);
        formatter.field("billable_time_in_seconds", &self.billable_time_in_seconds);
        formatter.field("debug_hook_config", &self.debug_hook_config);
        formatter.field("experiment_config", &self.experiment_config);
        formatter.field("debug_rule_configurations", &self.debug_rule_configurations);
        formatter.field(
            "tensor_board_output_config",
            &self.tensor_board_output_config,
        );
        formatter.field(
            "debug_rule_evaluation_statuses",
            &self.debug_rule_evaluation_statuses,
        );
        formatter.field("profiler_config", &self.profiler_config);
        formatter.field(
            "profiler_rule_configurations",
            &self.profiler_rule_configurations,
        );
        formatter.field(
            "profiler_rule_evaluation_statuses",
            &self.profiler_rule_evaluation_statuses,
        );
        formatter.field("profiling_status", &self.profiling_status);
        formatter.field("retry_strategy", &self.retry_strategy);
        formatter.field("environment", &self.environment);
        formatter.finish()
    }
}
/// See [`DescribeTrainingJobOutput`](crate::output::DescribeTrainingJobOutput)
pub mod describe_training_job_output {
    /// A builder for [`DescribeTrainingJobOutput`](crate::output::DescribeTrainingJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) training_job_name: std::option::Option<std::string::String>,
        pub(crate) training_job_arn: std::option::Option<std::string::String>,
        pub(crate) tuning_job_arn: std::option::Option<std::string::String>,
        pub(crate) labeling_job_arn: std::option::Option<std::string::String>,
        pub(crate) auto_ml_job_arn: std::option::Option<std::string::String>,
        pub(crate) model_artifacts: std::option::Option<crate::model::ModelArtifacts>,
        pub(crate) training_job_status: std::option::Option<crate::model::TrainingJobStatus>,
        pub(crate) secondary_status: std::option::Option<crate::model::SecondaryStatus>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) hyper_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) algorithm_specification:
            std::option::Option<crate::model::AlgorithmSpecification>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) input_data_config: std::option::Option<std::vec::Vec<crate::model::Channel>>,
        pub(crate) output_data_config: std::option::Option<crate::model::OutputDataConfig>,
        pub(crate) resource_config: std::option::Option<crate::model::ResourceConfig>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
        pub(crate) stopping_condition: std::option::Option<crate::model::StoppingCondition>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) training_start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) training_end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) secondary_status_transitions:
            std::option::Option<std::vec::Vec<crate::model::SecondaryStatusTransition>>,
        pub(crate) final_metric_data_list:
            std::option::Option<std::vec::Vec<crate::model::MetricData>>,
        pub(crate) enable_network_isolation: std::option::Option<bool>,
        pub(crate) enable_inter_container_traffic_encryption: std::option::Option<bool>,
        pub(crate) enable_managed_spot_training: std::option::Option<bool>,
        pub(crate) checkpoint_config: std::option::Option<crate::model::CheckpointConfig>,
        pub(crate) training_time_in_seconds: std::option::Option<i32>,
        pub(crate) billable_time_in_seconds: std::option::Option<i32>,
        pub(crate) debug_hook_config: std::option::Option<crate::model::DebugHookConfig>,
        pub(crate) experiment_config: std::option::Option<crate::model::ExperimentConfig>,
        pub(crate) debug_rule_configurations:
            std::option::Option<std::vec::Vec<crate::model::DebugRuleConfiguration>>,
        pub(crate) tensor_board_output_config:
            std::option::Option<crate::model::TensorBoardOutputConfig>,
        pub(crate) debug_rule_evaluation_statuses:
            std::option::Option<std::vec::Vec<crate::model::DebugRuleEvaluationStatus>>,
        pub(crate) profiler_config: std::option::Option<crate::model::ProfilerConfig>,
        pub(crate) profiler_rule_configurations:
            std::option::Option<std::vec::Vec<crate::model::ProfilerRuleConfiguration>>,
        pub(crate) profiler_rule_evaluation_statuses:
            std::option::Option<std::vec::Vec<crate::model::ProfilerRuleEvaluationStatus>>,
        pub(crate) profiling_status: std::option::Option<crate::model::ProfilingStatus>,
        pub(crate) retry_strategy: std::option::Option<crate::model::RetryStrategy>,
        pub(crate) environment: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p> Name of the model training job. </p>
        pub fn training_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.training_job_name = Some(input.into());
            self
        }
        /// <p> Name of the model training job. </p>
        pub fn set_training_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.training_job_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the training job.</p>
        pub fn training_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.training_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the training job.</p>
        pub fn set_training_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.training_job_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the associated hyperparameter tuning job if the training job was launched by a hyperparameter tuning job.</p>
        pub fn tuning_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tuning_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the associated hyperparameter tuning job if the training job was launched by a hyperparameter tuning job.</p>
        pub fn set_tuning_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tuning_job_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SageMaker Ground Truth labeling job that created the transform or training job.</p>
        pub fn labeling_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.labeling_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SageMaker Ground Truth labeling job that created the transform or training job.</p>
        pub fn set_labeling_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.labeling_job_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an AutoML job.</p>
        pub fn auto_ml_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_ml_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an AutoML job.</p>
        pub fn set_auto_ml_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_ml_job_arn = input;
            self
        }
        /// <p>Information about the Amazon S3 location that is configured for storing model artifacts. </p>
        pub fn model_artifacts(mut self, input: crate::model::ModelArtifacts) -> Self {
            self.model_artifacts = Some(input);
            self
        }
        /// <p>Information about the Amazon S3 location that is configured for storing model artifacts. </p>
        pub fn set_model_artifacts(
            mut self,
            input: std::option::Option<crate::model::ModelArtifacts>,
        ) -> Self {
            self.model_artifacts = input;
            self
        }
        /// <p>The status of the training job.</p>
        /// <p>Amazon SageMaker provides the following training job statuses:</p>
        /// <ul>
        /// <li> <p> <code>InProgress</code> - The training is in progress.</p> </li>
        /// <li> <p> <code>Completed</code> - The training job has completed.</p> </li>
        /// <li> <p> <code>Failed</code> - The training job has failed. To see the reason for the failure, see the <code>FailureReason</code> field in the response to a <code>DescribeTrainingJobResponse</code> call.</p> </li>
        /// <li> <p> <code>Stopping</code> - The training job is stopping.</p> </li>
        /// <li> <p> <code>Stopped</code> - The training job has stopped.</p> </li>
        /// </ul>
        /// <p>For more detailed information, see <code>SecondaryStatus</code>. </p>
        pub fn training_job_status(mut self, input: crate::model::TrainingJobStatus) -> Self {
            self.training_job_status = Some(input);
            self
        }
        /// <p>The status of the training job.</p>
        /// <p>Amazon SageMaker provides the following training job statuses:</p>
        /// <ul>
        /// <li> <p> <code>InProgress</code> - The training is in progress.</p> </li>
        /// <li> <p> <code>Completed</code> - The training job has completed.</p> </li>
        /// <li> <p> <code>Failed</code> - The training job has failed. To see the reason for the failure, see the <code>FailureReason</code> field in the response to a <code>DescribeTrainingJobResponse</code> call.</p> </li>
        /// <li> <p> <code>Stopping</code> - The training job is stopping.</p> </li>
        /// <li> <p> <code>Stopped</code> - The training job has stopped.</p> </li>
        /// </ul>
        /// <p>For more detailed information, see <code>SecondaryStatus</code>. </p>
        pub fn set_training_job_status(
            mut self,
            input: std::option::Option<crate::model::TrainingJobStatus>,
        ) -> Self {
            self.training_job_status = input;
            self
        }
        /// <p> Provides detailed information about the state of the training job. For detailed information on the secondary status of the training job, see <code>StatusMessage</code> under <code>SecondaryStatusTransition</code>.</p>
        /// <p>Amazon SageMaker provides primary statuses and secondary statuses that apply to each of them:</p>
        /// <dl>
        /// <dt>
        /// InProgress
        /// </dt>
        /// <dd>
        /// <ul>
        /// <li> <p> <code>Starting</code> - Starting the training job.</p> </li>
        /// <li> <p> <code>Downloading</code> - An optional stage for algorithms that support <code>File</code> training input mode. It indicates that data is being downloaded to the ML storage volumes.</p> </li>
        /// <li> <p> <code>Training</code> - Training is in progress.</p> </li>
        /// <li> <p> <code>Interrupted</code> - The job stopped because the managed spot training instances were interrupted. </p> </li>
        /// <li> <p> <code>Uploading</code> - Training is complete and the model artifacts are being uploaded to the S3 location.</p> </li>
        /// </ul>
        /// </dd>
        /// <dt>
        /// Completed
        /// </dt>
        /// <dd>
        /// <ul>
        /// <li> <p> <code>Completed</code> - The training job has completed.</p> </li>
        /// </ul>
        /// </dd>
        /// <dt>
        /// Failed
        /// </dt>
        /// <dd>
        /// <ul>
        /// <li> <p> <code>Failed</code> - The training job has failed. The reason for the failure is returned in the <code>FailureReason</code> field of <code>DescribeTrainingJobResponse</code>.</p> </li>
        /// </ul>
        /// </dd>
        /// <dt>
        /// Stopped
        /// </dt>
        /// <dd>
        /// <ul>
        /// <li> <p> <code>MaxRuntimeExceeded</code> - The job stopped because it exceeded the maximum allowed runtime.</p> </li>
        /// <li> <p> <code>MaxWaitTimeExceeded</code> - The job stopped because it exceeded the maximum allowed wait time.</p> </li>
        /// <li> <p> <code>Stopped</code> - The training job has stopped.</p> </li>
        /// </ul>
        /// </dd>
        /// <dt>
        /// Stopping
        /// </dt>
        /// <dd>
        /// <ul>
        /// <li> <p> <code>Stopping</code> - Stopping the training job.</p> </li>
        /// </ul>
        /// </dd>
        /// </dl> <important>
        /// <p>Valid values for <code>SecondaryStatus</code> are subject to change. </p>
        /// </important>
        /// <p>We no longer support the following secondary statuses:</p>
        /// <ul>
        /// <li> <p> <code>LaunchingMLInstances</code> </p> </li>
        /// <li> <p> <code>PreparingTraining</code> </p> </li>
        /// <li> <p> <code>DownloadingTrainingImage</code> </p> </li>
        /// </ul>
        pub fn secondary_status(mut self, input: crate::model::SecondaryStatus) -> Self {
            self.secondary_status = Some(input);
            self
        }
        /// <p> Provides detailed information about the state of the training job. For detailed information on the secondary status of the training job, see <code>StatusMessage</code> under <code>SecondaryStatusTransition</code>.</p>
        /// <p>Amazon SageMaker provides primary statuses and secondary statuses that apply to each of them:</p>
        /// <dl>
        /// <dt>
        /// InProgress
        /// </dt>
        /// <dd>
        /// <ul>
        /// <li> <p> <code>Starting</code> - Starting the training job.</p> </li>
        /// <li> <p> <code>Downloading</code> - An optional stage for algorithms that support <code>File</code> training input mode. It indicates that data is being downloaded to the ML storage volumes.</p> </li>
        /// <li> <p> <code>Training</code> - Training is in progress.</p> </li>
        /// <li> <p> <code>Interrupted</code> - The job stopped because the managed spot training instances were interrupted. </p> </li>
        /// <li> <p> <code>Uploading</code> - Training is complete and the model artifacts are being uploaded to the S3 location.</p> </li>
        /// </ul>
        /// </dd>
        /// <dt>
        /// Completed
        /// </dt>
        /// <dd>
        /// <ul>
        /// <li> <p> <code>Completed</code> - The training job has completed.</p> </li>
        /// </ul>
        /// </dd>
        /// <dt>
        /// Failed
        /// </dt>
        /// <dd>
        /// <ul>
        /// <li> <p> <code>Failed</code> - The training job has failed. The reason for the failure is returned in the <code>FailureReason</code> field of <code>DescribeTrainingJobResponse</code>.</p> </li>
        /// </ul>
        /// </dd>
        /// <dt>
        /// Stopped
        /// </dt>
        /// <dd>
        /// <ul>
        /// <li> <p> <code>MaxRuntimeExceeded</code> - The job stopped because it exceeded the maximum allowed runtime.</p> </li>
        /// <li> <p> <code>MaxWaitTimeExceeded</code> - The job stopped because it exceeded the maximum allowed wait time.</p> </li>
        /// <li> <p> <code>Stopped</code> - The training job has stopped.</p> </li>
        /// </ul>
        /// </dd>
        /// <dt>
        /// Stopping
        /// </dt>
        /// <dd>
        /// <ul>
        /// <li> <p> <code>Stopping</code> - Stopping the training job.</p> </li>
        /// </ul>
        /// </dd>
        /// </dl> <important>
        /// <p>Valid values for <code>SecondaryStatus</code> are subject to change. </p>
        /// </important>
        /// <p>We no longer support the following secondary statuses:</p>
        /// <ul>
        /// <li> <p> <code>LaunchingMLInstances</code> </p> </li>
        /// <li> <p> <code>PreparingTraining</code> </p> </li>
        /// <li> <p> <code>DownloadingTrainingImage</code> </p> </li>
        /// </ul>
        pub fn set_secondary_status(
            mut self,
            input: std::option::Option<crate::model::SecondaryStatus>,
        ) -> Self {
            self.secondary_status = input;
            self
        }
        /// <p>If the training job failed, the reason it failed. </p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If the training job failed, the reason it failed. </p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// Adds a key-value pair to `hyper_parameters`.
        ///
        /// To override the contents of this collection use [`set_hyper_parameters`](Self::set_hyper_parameters).
        ///
        /// <p>Algorithm-specific parameters. </p>
        pub fn hyper_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.hyper_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.hyper_parameters = Some(hash_map);
            self
        }
        /// <p>Algorithm-specific parameters. </p>
        pub fn set_hyper_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.hyper_parameters = input;
            self
        }
        /// <p>Information about the algorithm used for training, and algorithm metadata. </p>
        pub fn algorithm_specification(
            mut self,
            input: crate::model::AlgorithmSpecification,
        ) -> Self {
            self.algorithm_specification = Some(input);
            self
        }
        /// <p>Information about the algorithm used for training, and algorithm metadata. </p>
        pub fn set_algorithm_specification(
            mut self,
            input: std::option::Option<crate::model::AlgorithmSpecification>,
        ) -> Self {
            self.algorithm_specification = input;
            self
        }
        /// <p>The Amazon Web Services Identity and Access Management (IAM) role configured for the training job. </p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Identity and Access Management (IAM) role configured for the training job. </p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `input_data_config`.
        ///
        /// To override the contents of this collection use [`set_input_data_config`](Self::set_input_data_config).
        ///
        /// <p>An array of <code>Channel</code> objects that describes each data input channel. </p>
        pub fn input_data_config(mut self, input: crate::model::Channel) -> Self {
            let mut v = self.input_data_config.unwrap_or_default();
            v.push(input);
            self.input_data_config = Some(v);
            self
        }
        /// <p>An array of <code>Channel</code> objects that describes each data input channel. </p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Channel>>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p>The S3 path where model artifacts that you configured when creating the job are stored. Amazon SageMaker creates subfolders for model artifacts. </p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.output_data_config = Some(input);
            self
        }
        /// <p>The S3 path where model artifacts that you configured when creating the job are stored. Amazon SageMaker creates subfolders for model artifacts. </p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.output_data_config = input;
            self
        }
        /// <p>Resources, including ML compute instances and ML storage volumes, that are configured for model training. </p>
        pub fn resource_config(mut self, input: crate::model::ResourceConfig) -> Self {
            self.resource_config = Some(input);
            self
        }
        /// <p>Resources, including ML compute instances and ML storage volumes, that are configured for model training. </p>
        pub fn set_resource_config(
            mut self,
            input: std::option::Option<crate::model::ResourceConfig>,
        ) -> Self {
            self.resource_config = input;
            self
        }
        /// <p>A <code>VpcConfig</code> object that specifies the VPC that this training job has access to. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an Amazon Virtual Private Cloud</a>.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>A <code>VpcConfig</code> object that specifies the VPC that this training job has access to. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an Amazon Virtual Private Cloud</a>.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>Specifies a limit to how long a model training job can run. It also specifies how long a managed Spot training job has to complete. When the job reaches the time limit, Amazon SageMaker ends the training job. Use this API to cap model training costs.</p>
        /// <p>To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost. </p>
        pub fn stopping_condition(mut self, input: crate::model::StoppingCondition) -> Self {
            self.stopping_condition = Some(input);
            self
        }
        /// <p>Specifies a limit to how long a model training job can run. It also specifies how long a managed Spot training job has to complete. When the job reaches the time limit, Amazon SageMaker ends the training job. Use this API to cap model training costs.</p>
        /// <p>To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost. </p>
        pub fn set_stopping_condition(
            mut self,
            input: std::option::Option<crate::model::StoppingCondition>,
        ) -> Self {
            self.stopping_condition = input;
            self
        }
        /// <p>A timestamp that indicates when the training job was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the training job was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>Indicates the time when the training job starts on training instances. You are billed for the time interval between this time and the value of <code>TrainingEndTime</code>. The start time in CloudWatch Logs might be later than this time. The difference is due to the time it takes to download the training data and to the size of the training container.</p>
        pub fn training_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.training_start_time = Some(input);
            self
        }
        /// <p>Indicates the time when the training job starts on training instances. You are billed for the time interval between this time and the value of <code>TrainingEndTime</code>. The start time in CloudWatch Logs might be later than this time. The difference is due to the time it takes to download the training data and to the size of the training container.</p>
        pub fn set_training_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.training_start_time = input;
            self
        }
        /// <p>Indicates the time when the training job ends on training instances. You are billed for the time interval between the value of <code>TrainingStartTime</code> and this time. For successful jobs and stopped jobs, this is the time after model artifacts are uploaded. For failed jobs, this is the time when Amazon SageMaker detects a job failure.</p>
        pub fn training_end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.training_end_time = Some(input);
            self
        }
        /// <p>Indicates the time when the training job ends on training instances. You are billed for the time interval between the value of <code>TrainingStartTime</code> and this time. For successful jobs and stopped jobs, this is the time after model artifacts are uploaded. For failed jobs, this is the time when Amazon SageMaker detects a job failure.</p>
        pub fn set_training_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.training_end_time = input;
            self
        }
        /// <p>A timestamp that indicates when the status of the training job was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates when the status of the training job was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// Appends an item to `secondary_status_transitions`.
        ///
        /// To override the contents of this collection use [`set_secondary_status_transitions`](Self::set_secondary_status_transitions).
        ///
        /// <p>A history of all of the secondary statuses that the training job has transitioned through.</p>
        pub fn secondary_status_transitions(
            mut self,
            input: crate::model::SecondaryStatusTransition,
        ) -> Self {
            let mut v = self.secondary_status_transitions.unwrap_or_default();
            v.push(input);
            self.secondary_status_transitions = Some(v);
            self
        }
        /// <p>A history of all of the secondary statuses that the training job has transitioned through.</p>
        pub fn set_secondary_status_transitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SecondaryStatusTransition>>,
        ) -> Self {
            self.secondary_status_transitions = input;
            self
        }
        /// Appends an item to `final_metric_data_list`.
        ///
        /// To override the contents of this collection use [`set_final_metric_data_list`](Self::set_final_metric_data_list).
        ///
        /// <p>A collection of <code>MetricData</code> objects that specify the names, values, and dates and times that the training algorithm emitted to Amazon CloudWatch.</p>
        pub fn final_metric_data_list(mut self, input: crate::model::MetricData) -> Self {
            let mut v = self.final_metric_data_list.unwrap_or_default();
            v.push(input);
            self.final_metric_data_list = Some(v);
            self
        }
        /// <p>A collection of <code>MetricData</code> objects that specify the names, values, and dates and times that the training algorithm emitted to Amazon CloudWatch.</p>
        pub fn set_final_metric_data_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricData>>,
        ) -> Self {
            self.final_metric_data_list = input;
            self
        }
        /// <p>If you want to allow inbound or outbound network calls, except for calls between peers within a training cluster for distributed training, choose <code>True</code>. If you enable network isolation for training jobs that are configured to use a VPC, Amazon SageMaker downloads and uploads customer data and model artifacts through the specified VPC, but the training container does not have network access.</p>
        pub fn enable_network_isolation(mut self, input: bool) -> Self {
            self.enable_network_isolation = Some(input);
            self
        }
        /// <p>If you want to allow inbound or outbound network calls, except for calls between peers within a training cluster for distributed training, choose <code>True</code>. If you enable network isolation for training jobs that are configured to use a VPC, Amazon SageMaker downloads and uploads customer data and model artifacts through the specified VPC, but the training container does not have network access.</p>
        pub fn set_enable_network_isolation(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_network_isolation = input;
            self
        }
        /// <p>To encrypt all communications between ML compute instances in distributed training, choose <code>True</code>. Encryption provides greater security for distributed training, but training might take longer. How long it takes depends on the amount of communication between compute instances, especially if you use a deep learning algorithms in distributed training.</p>
        pub fn enable_inter_container_traffic_encryption(mut self, input: bool) -> Self {
            self.enable_inter_container_traffic_encryption = Some(input);
            self
        }
        /// <p>To encrypt all communications between ML compute instances in distributed training, choose <code>True</code>. Encryption provides greater security for distributed training, but training might take longer. How long it takes depends on the amount of communication between compute instances, especially if you use a deep learning algorithms in distributed training.</p>
        pub fn set_enable_inter_container_traffic_encryption(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_inter_container_traffic_encryption = input;
            self
        }
        /// <p>A Boolean indicating whether managed spot training is enabled (<code>True</code>) or not (<code>False</code>).</p>
        pub fn enable_managed_spot_training(mut self, input: bool) -> Self {
            self.enable_managed_spot_training = Some(input);
            self
        }
        /// <p>A Boolean indicating whether managed spot training is enabled (<code>True</code>) or not (<code>False</code>).</p>
        pub fn set_enable_managed_spot_training(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_managed_spot_training = input;
            self
        }
        /// <p>Contains information about the output location for managed spot training checkpoint data. </p>
        pub fn checkpoint_config(mut self, input: crate::model::CheckpointConfig) -> Self {
            self.checkpoint_config = Some(input);
            self
        }
        /// <p>Contains information about the output location for managed spot training checkpoint data. </p>
        pub fn set_checkpoint_config(
            mut self,
            input: std::option::Option<crate::model::CheckpointConfig>,
        ) -> Self {
            self.checkpoint_config = input;
            self
        }
        /// <p>The training time in seconds.</p>
        pub fn training_time_in_seconds(mut self, input: i32) -> Self {
            self.training_time_in_seconds = Some(input);
            self
        }
        /// <p>The training time in seconds.</p>
        pub fn set_training_time_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.training_time_in_seconds = input;
            self
        }
        /// <p>The billable time in seconds. Billable time refers to the absolute wall-clock time.</p>
        /// <p>Multiply <code>BillableTimeInSeconds</code> by the number of instances (<code>InstanceCount</code>) in your training cluster to get the total compute time SageMaker will bill you if you run distributed training. The formula is as follows: <code>BillableTimeInSeconds * InstanceCount</code> .</p>
        /// <p>You can calculate the savings from using managed spot training using the formula <code>(1 - BillableTimeInSeconds / TrainingTimeInSeconds) * 100</code>. For example, if <code>BillableTimeInSeconds</code> is 100 and <code>TrainingTimeInSeconds</code> is 500, the savings is 80%.</p>
        pub fn billable_time_in_seconds(mut self, input: i32) -> Self {
            self.billable_time_in_seconds = Some(input);
            self
        }
        /// <p>The billable time in seconds. Billable time refers to the absolute wall-clock time.</p>
        /// <p>Multiply <code>BillableTimeInSeconds</code> by the number of instances (<code>InstanceCount</code>) in your training cluster to get the total compute time SageMaker will bill you if you run distributed training. The formula is as follows: <code>BillableTimeInSeconds * InstanceCount</code> .</p>
        /// <p>You can calculate the savings from using managed spot training using the formula <code>(1 - BillableTimeInSeconds / TrainingTimeInSeconds) * 100</code>. For example, if <code>BillableTimeInSeconds</code> is 100 and <code>TrainingTimeInSeconds</code> is 500, the savings is 80%.</p>
        pub fn set_billable_time_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.billable_time_in_seconds = input;
            self
        }
        /// <p>Configuration information for the Debugger hook parameters, metric and tensor collections, and storage paths. To learn more about how to configure the <code>DebugHookConfig</code> parameter, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html">Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job</a>.</p>
        pub fn debug_hook_config(mut self, input: crate::model::DebugHookConfig) -> Self {
            self.debug_hook_config = Some(input);
            self
        }
        /// <p>Configuration information for the Debugger hook parameters, metric and tensor collections, and storage paths. To learn more about how to configure the <code>DebugHookConfig</code> parameter, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html">Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job</a>.</p>
        pub fn set_debug_hook_config(
            mut self,
            input: std::option::Option<crate::model::DebugHookConfig>,
        ) -> Self {
            self.debug_hook_config = input;
            self
        }
        /// <p>Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:</p>
        /// <ul>
        /// <li> <p> <code>CreateProcessingJob</code> </p> </li>
        /// <li> <p> <code>CreateTrainingJob</code> </p> </li>
        /// <li> <p> <code>CreateTransformJob</code> </p> </li>
        /// </ul>
        pub fn experiment_config(mut self, input: crate::model::ExperimentConfig) -> Self {
            self.experiment_config = Some(input);
            self
        }
        /// <p>Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:</p>
        /// <ul>
        /// <li> <p> <code>CreateProcessingJob</code> </p> </li>
        /// <li> <p> <code>CreateTrainingJob</code> </p> </li>
        /// <li> <p> <code>CreateTransformJob</code> </p> </li>
        /// </ul>
        pub fn set_experiment_config(
            mut self,
            input: std::option::Option<crate::model::ExperimentConfig>,
        ) -> Self {
            self.experiment_config = input;
            self
        }
        /// Appends an item to `debug_rule_configurations`.
        ///
        /// To override the contents of this collection use [`set_debug_rule_configurations`](Self::set_debug_rule_configurations).
        ///
        /// <p>Configuration information for Debugger rules for debugging output tensors.</p>
        pub fn debug_rule_configurations(
            mut self,
            input: crate::model::DebugRuleConfiguration,
        ) -> Self {
            let mut v = self.debug_rule_configurations.unwrap_or_default();
            v.push(input);
            self.debug_rule_configurations = Some(v);
            self
        }
        /// <p>Configuration information for Debugger rules for debugging output tensors.</p>
        pub fn set_debug_rule_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DebugRuleConfiguration>>,
        ) -> Self {
            self.debug_rule_configurations = input;
            self
        }
        /// <p>Configuration of storage locations for the Debugger TensorBoard output data.</p>
        pub fn tensor_board_output_config(
            mut self,
            input: crate::model::TensorBoardOutputConfig,
        ) -> Self {
            self.tensor_board_output_config = Some(input);
            self
        }
        /// <p>Configuration of storage locations for the Debugger TensorBoard output data.</p>
        pub fn set_tensor_board_output_config(
            mut self,
            input: std::option::Option<crate::model::TensorBoardOutputConfig>,
        ) -> Self {
            self.tensor_board_output_config = input;
            self
        }
        /// Appends an item to `debug_rule_evaluation_statuses`.
        ///
        /// To override the contents of this collection use [`set_debug_rule_evaluation_statuses`](Self::set_debug_rule_evaluation_statuses).
        ///
        /// <p>Evaluation status of Debugger rules for debugging on a training job.</p>
        pub fn debug_rule_evaluation_statuses(
            mut self,
            input: crate::model::DebugRuleEvaluationStatus,
        ) -> Self {
            let mut v = self.debug_rule_evaluation_statuses.unwrap_or_default();
            v.push(input);
            self.debug_rule_evaluation_statuses = Some(v);
            self
        }
        /// <p>Evaluation status of Debugger rules for debugging on a training job.</p>
        pub fn set_debug_rule_evaluation_statuses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DebugRuleEvaluationStatus>>,
        ) -> Self {
            self.debug_rule_evaluation_statuses = input;
            self
        }
        /// <p>Configuration information for Debugger system monitoring, framework profiling, and storage paths.</p>
        pub fn profiler_config(mut self, input: crate::model::ProfilerConfig) -> Self {
            self.profiler_config = Some(input);
            self
        }
        /// <p>Configuration information for Debugger system monitoring, framework profiling, and storage paths.</p>
        pub fn set_profiler_config(
            mut self,
            input: std::option::Option<crate::model::ProfilerConfig>,
        ) -> Self {
            self.profiler_config = input;
            self
        }
        /// Appends an item to `profiler_rule_configurations`.
        ///
        /// To override the contents of this collection use [`set_profiler_rule_configurations`](Self::set_profiler_rule_configurations).
        ///
        /// <p>Configuration information for Debugger rules for profiling system and framework metrics.</p>
        pub fn profiler_rule_configurations(
            mut self,
            input: crate::model::ProfilerRuleConfiguration,
        ) -> Self {
            let mut v = self.profiler_rule_configurations.unwrap_or_default();
            v.push(input);
            self.profiler_rule_configurations = Some(v);
            self
        }
        /// <p>Configuration information for Debugger rules for profiling system and framework metrics.</p>
        pub fn set_profiler_rule_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProfilerRuleConfiguration>>,
        ) -> Self {
            self.profiler_rule_configurations = input;
            self
        }
        /// Appends an item to `profiler_rule_evaluation_statuses`.
        ///
        /// To override the contents of this collection use [`set_profiler_rule_evaluation_statuses`](Self::set_profiler_rule_evaluation_statuses).
        ///
        /// <p>Evaluation status of Debugger rules for profiling on a training job.</p>
        pub fn profiler_rule_evaluation_statuses(
            mut self,
            input: crate::model::ProfilerRuleEvaluationStatus,
        ) -> Self {
            let mut v = self.profiler_rule_evaluation_statuses.unwrap_or_default();
            v.push(input);
            self.profiler_rule_evaluation_statuses = Some(v);
            self
        }
        /// <p>Evaluation status of Debugger rules for profiling on a training job.</p>
        pub fn set_profiler_rule_evaluation_statuses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProfilerRuleEvaluationStatus>>,
        ) -> Self {
            self.profiler_rule_evaluation_statuses = input;
            self
        }
        /// <p>Profiling status of a training job.</p>
        pub fn profiling_status(mut self, input: crate::model::ProfilingStatus) -> Self {
            self.profiling_status = Some(input);
            self
        }
        /// <p>Profiling status of a training job.</p>
        pub fn set_profiling_status(
            mut self,
            input: std::option::Option<crate::model::ProfilingStatus>,
        ) -> Self {
            self.profiling_status = input;
            self
        }
        /// <p>The number of times to retry the job when the job fails due to an <code>InternalServerError</code>.</p>
        pub fn retry_strategy(mut self, input: crate::model::RetryStrategy) -> Self {
            self.retry_strategy = Some(input);
            self
        }
        /// <p>The number of times to retry the job when the job fails due to an <code>InternalServerError</code>.</p>
        pub fn set_retry_strategy(
            mut self,
            input: std::option::Option<crate::model::RetryStrategy>,
        ) -> Self {
            self.retry_strategy = input;
            self
        }
        /// Adds a key-value pair to `environment`.
        ///
        /// To override the contents of this collection use [`set_environment`](Self::set_environment).
        ///
        /// <p>The environment variables to set in the Docker container.</p>
        pub fn environment(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.environment.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.environment = Some(hash_map);
            self
        }
        /// <p>The environment variables to set in the Docker container.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.environment = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTrainingJobOutput`](crate::output::DescribeTrainingJobOutput)
        pub fn build(self) -> crate::output::DescribeTrainingJobOutput {
            crate::output::DescribeTrainingJobOutput {
                training_job_name: self.training_job_name,
                training_job_arn: self.training_job_arn,
                tuning_job_arn: self.tuning_job_arn,
                labeling_job_arn: self.labeling_job_arn,
                auto_ml_job_arn: self.auto_ml_job_arn,
                model_artifacts: self.model_artifacts,
                training_job_status: self.training_job_status,
                secondary_status: self.secondary_status,
                failure_reason: self.failure_reason,
                hyper_parameters: self.hyper_parameters,
                algorithm_specification: self.algorithm_specification,
                role_arn: self.role_arn,
                input_data_config: self.input_data_config,
                output_data_config: self.output_data_config,
                resource_config: self.resource_config,
                vpc_config: self.vpc_config,
                stopping_condition: self.stopping_condition,
                creation_time: self.creation_time,
                training_start_time: self.training_start_time,
                training_end_time: self.training_end_time,
                last_modified_time: self.last_modified_time,
                secondary_status_transitions: self.secondary_status_transitions,
                final_metric_data_list: self.final_metric_data_list,
                enable_network_isolation: self.enable_network_isolation.unwrap_or_default(),
                enable_inter_container_traffic_encryption: self
                    .enable_inter_container_traffic_encryption
                    .unwrap_or_default(),
                enable_managed_spot_training: self.enable_managed_spot_training.unwrap_or_default(),
                checkpoint_config: self.checkpoint_config,
                training_time_in_seconds: self.training_time_in_seconds,
                billable_time_in_seconds: self.billable_time_in_seconds,
                debug_hook_config: self.debug_hook_config,
                experiment_config: self.experiment_config,
                debug_rule_configurations: self.debug_rule_configurations,
                tensor_board_output_config: self.tensor_board_output_config,
                debug_rule_evaluation_statuses: self.debug_rule_evaluation_statuses,
                profiler_config: self.profiler_config,
                profiler_rule_configurations: self.profiler_rule_configurations,
                profiler_rule_evaluation_statuses: self.profiler_rule_evaluation_statuses,
                profiling_status: self.profiling_status,
                retry_strategy: self.retry_strategy,
                environment: self.environment,
            }
        }
    }
}
impl DescribeTrainingJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTrainingJobOutput`](crate::output::DescribeTrainingJobOutput)
    pub fn builder() -> crate::output::describe_training_job_output::Builder {
        crate::output::describe_training_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSubscribedWorkteamOutput {
    /// <p>A <code>Workteam</code> instance that contains information about the work team.</p>
    pub subscribed_workteam: std::option::Option<crate::model::SubscribedWorkteam>,
}
impl DescribeSubscribedWorkteamOutput {
    /// <p>A <code>Workteam</code> instance that contains information about the work team.</p>
    pub fn subscribed_workteam(&self) -> std::option::Option<&crate::model::SubscribedWorkteam> {
        self.subscribed_workteam.as_ref()
    }
}
impl std::fmt::Debug for DescribeSubscribedWorkteamOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSubscribedWorkteamOutput");
        formatter.field("subscribed_workteam", &self.subscribed_workteam);
        formatter.finish()
    }
}
/// See [`DescribeSubscribedWorkteamOutput`](crate::output::DescribeSubscribedWorkteamOutput)
pub mod describe_subscribed_workteam_output {
    /// A builder for [`DescribeSubscribedWorkteamOutput`](crate::output::DescribeSubscribedWorkteamOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscribed_workteam: std::option::Option<crate::model::SubscribedWorkteam>,
    }
    impl Builder {
        /// <p>A <code>Workteam</code> instance that contains information about the work team.</p>
        pub fn subscribed_workteam(mut self, input: crate::model::SubscribedWorkteam) -> Self {
            self.subscribed_workteam = Some(input);
            self
        }
        /// <p>A <code>Workteam</code> instance that contains information about the work team.</p>
        pub fn set_subscribed_workteam(
            mut self,
            input: std::option::Option<crate::model::SubscribedWorkteam>,
        ) -> Self {
            self.subscribed_workteam = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSubscribedWorkteamOutput`](crate::output::DescribeSubscribedWorkteamOutput)
        pub fn build(self) -> crate::output::DescribeSubscribedWorkteamOutput {
            crate::output::DescribeSubscribedWorkteamOutput {
                subscribed_workteam: self.subscribed_workteam,
            }
        }
    }
}
impl DescribeSubscribedWorkteamOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSubscribedWorkteamOutput`](crate::output::DescribeSubscribedWorkteamOutput)
    pub fn builder() -> crate::output::describe_subscribed_workteam_output::Builder {
        crate::output::describe_subscribed_workteam_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeStudioLifecycleConfigOutput {
    /// <p>The ARN of the Lifecycle Configuration to describe.</p>
    pub studio_lifecycle_config_arn: std::option::Option<std::string::String>,
    /// <p>The name of the Studio Lifecycle Configuration that is described.</p>
    pub studio_lifecycle_config_name: std::option::Option<std::string::String>,
    /// <p>The creation time of the Studio Lifecycle Configuration.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>This value is equivalent to CreationTime because Studio Lifecycle Configurations are immutable.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The content of your Studio Lifecycle Configuration script.</p>
    pub studio_lifecycle_config_content: std::option::Option<std::string::String>,
    /// <p>The App type that the Lifecycle Configuration is attached to.</p>
    pub studio_lifecycle_config_app_type:
        std::option::Option<crate::model::StudioLifecycleConfigAppType>,
}
impl DescribeStudioLifecycleConfigOutput {
    /// <p>The ARN of the Lifecycle Configuration to describe.</p>
    pub fn studio_lifecycle_config_arn(&self) -> std::option::Option<&str> {
        self.studio_lifecycle_config_arn.as_deref()
    }
    /// <p>The name of the Studio Lifecycle Configuration that is described.</p>
    pub fn studio_lifecycle_config_name(&self) -> std::option::Option<&str> {
        self.studio_lifecycle_config_name.as_deref()
    }
    /// <p>The creation time of the Studio Lifecycle Configuration.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>This value is equivalent to CreationTime because Studio Lifecycle Configurations are immutable.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>The content of your Studio Lifecycle Configuration script.</p>
    pub fn studio_lifecycle_config_content(&self) -> std::option::Option<&str> {
        self.studio_lifecycle_config_content.as_deref()
    }
    /// <p>The App type that the Lifecycle Configuration is attached to.</p>
    pub fn studio_lifecycle_config_app_type(
        &self,
    ) -> std::option::Option<&crate::model::StudioLifecycleConfigAppType> {
        self.studio_lifecycle_config_app_type.as_ref()
    }
}
impl std::fmt::Debug for DescribeStudioLifecycleConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeStudioLifecycleConfigOutput");
        formatter.field(
            "studio_lifecycle_config_arn",
            &self.studio_lifecycle_config_arn,
        );
        formatter.field(
            "studio_lifecycle_config_name",
            &self.studio_lifecycle_config_name,
        );
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field(
            "studio_lifecycle_config_content",
            &self.studio_lifecycle_config_content,
        );
        formatter.field(
            "studio_lifecycle_config_app_type",
            &self.studio_lifecycle_config_app_type,
        );
        formatter.finish()
    }
}
/// See [`DescribeStudioLifecycleConfigOutput`](crate::output::DescribeStudioLifecycleConfigOutput)
pub mod describe_studio_lifecycle_config_output {
    /// A builder for [`DescribeStudioLifecycleConfigOutput`](crate::output::DescribeStudioLifecycleConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) studio_lifecycle_config_arn: std::option::Option<std::string::String>,
        pub(crate) studio_lifecycle_config_name: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) studio_lifecycle_config_content: std::option::Option<std::string::String>,
        pub(crate) studio_lifecycle_config_app_type:
            std::option::Option<crate::model::StudioLifecycleConfigAppType>,
    }
    impl Builder {
        /// <p>The ARN of the Lifecycle Configuration to describe.</p>
        pub fn studio_lifecycle_config_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.studio_lifecycle_config_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Lifecycle Configuration to describe.</p>
        pub fn set_studio_lifecycle_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.studio_lifecycle_config_arn = input;
            self
        }
        /// <p>The name of the Studio Lifecycle Configuration that is described.</p>
        pub fn studio_lifecycle_config_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.studio_lifecycle_config_name = Some(input.into());
            self
        }
        /// <p>The name of the Studio Lifecycle Configuration that is described.</p>
        pub fn set_studio_lifecycle_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.studio_lifecycle_config_name = input;
            self
        }
        /// <p>The creation time of the Studio Lifecycle Configuration.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The creation time of the Studio Lifecycle Configuration.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>This value is equivalent to CreationTime because Studio Lifecycle Configurations are immutable.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>This value is equivalent to CreationTime because Studio Lifecycle Configurations are immutable.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>The content of your Studio Lifecycle Configuration script.</p>
        pub fn studio_lifecycle_config_content(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.studio_lifecycle_config_content = Some(input.into());
            self
        }
        /// <p>The content of your Studio Lifecycle Configuration script.</p>
        pub fn set_studio_lifecycle_config_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.studio_lifecycle_config_content = input;
            self
        }
        /// <p>The App type that the Lifecycle Configuration is attached to.</p>
        pub fn studio_lifecycle_config_app_type(
            mut self,
            input: crate::model::StudioLifecycleConfigAppType,
        ) -> Self {
            self.studio_lifecycle_config_app_type = Some(input);
            self
        }
        /// <p>The App type that the Lifecycle Configuration is attached to.</p>
        pub fn set_studio_lifecycle_config_app_type(
            mut self,
            input: std::option::Option<crate::model::StudioLifecycleConfigAppType>,
        ) -> Self {
            self.studio_lifecycle_config_app_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStudioLifecycleConfigOutput`](crate::output::DescribeStudioLifecycleConfigOutput)
        pub fn build(self) -> crate::output::DescribeStudioLifecycleConfigOutput {
            crate::output::DescribeStudioLifecycleConfigOutput {
                studio_lifecycle_config_arn: self.studio_lifecycle_config_arn,
                studio_lifecycle_config_name: self.studio_lifecycle_config_name,
                creation_time: self.creation_time,
                last_modified_time: self.last_modified_time,
                studio_lifecycle_config_content: self.studio_lifecycle_config_content,
                studio_lifecycle_config_app_type: self.studio_lifecycle_config_app_type,
            }
        }
    }
}
impl DescribeStudioLifecycleConfigOutput {
    /// Creates a new builder-style object to manufacture [`DescribeStudioLifecycleConfigOutput`](crate::output::DescribeStudioLifecycleConfigOutput)
    pub fn builder() -> crate::output::describe_studio_lifecycle_config_output::Builder {
        crate::output::describe_studio_lifecycle_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProjectOutput {
    /// <p>The Amazon Resource Name (ARN) of the project.</p>
    pub project_arn: std::option::Option<std::string::String>,
    /// <p>The name of the project.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>The ID of the project.</p>
    pub project_id: std::option::Option<std::string::String>,
    /// <p>The description of the project.</p>
    pub project_description: std::option::Option<std::string::String>,
    /// <p>Information used to provision a service catalog product. For information, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services Service Catalog</a>.</p>
    pub service_catalog_provisioning_details:
        std::option::Option<crate::model::ServiceCatalogProvisioningDetails>,
    /// <p>Information about a provisioned service catalog product.</p>
    pub service_catalog_provisioned_product_details:
        std::option::Option<crate::model::ServiceCatalogProvisionedProductDetails>,
    /// <p>The status of the project.</p>
    pub project_status: std::option::Option<crate::model::ProjectStatus>,
    /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
    pub created_by: std::option::Option<crate::model::UserContext>,
    /// <p>The time when the project was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp when project was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
    pub last_modified_by: std::option::Option<crate::model::UserContext>,
}
impl DescribeProjectOutput {
    /// <p>The Amazon Resource Name (ARN) of the project.</p>
    pub fn project_arn(&self) -> std::option::Option<&str> {
        self.project_arn.as_deref()
    }
    /// <p>The name of the project.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>The ID of the project.</p>
    pub fn project_id(&self) -> std::option::Option<&str> {
        self.project_id.as_deref()
    }
    /// <p>The description of the project.</p>
    pub fn project_description(&self) -> std::option::Option<&str> {
        self.project_description.as_deref()
    }
    /// <p>Information used to provision a service catalog product. For information, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services Service Catalog</a>.</p>
    pub fn service_catalog_provisioning_details(
        &self,
    ) -> std::option::Option<&crate::model::ServiceCatalogProvisioningDetails> {
        self.service_catalog_provisioning_details.as_ref()
    }
    /// <p>Information about a provisioned service catalog product.</p>
    pub fn service_catalog_provisioned_product_details(
        &self,
    ) -> std::option::Option<&crate::model::ServiceCatalogProvisionedProductDetails> {
        self.service_catalog_provisioned_product_details.as_ref()
    }
    /// <p>The status of the project.</p>
    pub fn project_status(&self) -> std::option::Option<&crate::model::ProjectStatus> {
        self.project_status.as_ref()
    }
    /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
    pub fn created_by(&self) -> std::option::Option<&crate::model::UserContext> {
        self.created_by.as_ref()
    }
    /// <p>The time when the project was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The timestamp when project was last modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
    pub fn last_modified_by(&self) -> std::option::Option<&crate::model::UserContext> {
        self.last_modified_by.as_ref()
    }
}
impl std::fmt::Debug for DescribeProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProjectOutput");
        formatter.field("project_arn", &self.project_arn);
        formatter.field("project_name", &self.project_name);
        formatter.field("project_id", &self.project_id);
        formatter.field("project_description", &self.project_description);
        formatter.field(
            "service_catalog_provisioning_details",
            &self.service_catalog_provisioning_details,
        );
        formatter.field(
            "service_catalog_provisioned_product_details",
            &self.service_catalog_provisioned_product_details,
        );
        formatter.field("project_status", &self.project_status);
        formatter.field("created_by", &self.created_by);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.finish()
    }
}
/// See [`DescribeProjectOutput`](crate::output::DescribeProjectOutput)
pub mod describe_project_output {
    /// A builder for [`DescribeProjectOutput`](crate::output::DescribeProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_arn: std::option::Option<std::string::String>,
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) project_id: std::option::Option<std::string::String>,
        pub(crate) project_description: std::option::Option<std::string::String>,
        pub(crate) service_catalog_provisioning_details:
            std::option::Option<crate::model::ServiceCatalogProvisioningDetails>,
        pub(crate) service_catalog_provisioned_product_details:
            std::option::Option<crate::model::ServiceCatalogProvisionedProductDetails>,
        pub(crate) project_status: std::option::Option<crate::model::ProjectStatus>,
        pub(crate) created_by: std::option::Option<crate::model::UserContext>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_by: std::option::Option<crate::model::UserContext>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the project.</p>
        pub fn project_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_arn = input;
            self
        }
        /// <p>The name of the project.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>The ID of the project.</p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_id = Some(input.into());
            self
        }
        /// <p>The ID of the project.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_id = input;
            self
        }
        /// <p>The description of the project.</p>
        pub fn project_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_description = Some(input.into());
            self
        }
        /// <p>The description of the project.</p>
        pub fn set_project_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.project_description = input;
            self
        }
        /// <p>Information used to provision a service catalog product. For information, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services Service Catalog</a>.</p>
        pub fn service_catalog_provisioning_details(
            mut self,
            input: crate::model::ServiceCatalogProvisioningDetails,
        ) -> Self {
            self.service_catalog_provisioning_details = Some(input);
            self
        }
        /// <p>Information used to provision a service catalog product. For information, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services Service Catalog</a>.</p>
        pub fn set_service_catalog_provisioning_details(
            mut self,
            input: std::option::Option<crate::model::ServiceCatalogProvisioningDetails>,
        ) -> Self {
            self.service_catalog_provisioning_details = input;
            self
        }
        /// <p>Information about a provisioned service catalog product.</p>
        pub fn service_catalog_provisioned_product_details(
            mut self,
            input: crate::model::ServiceCatalogProvisionedProductDetails,
        ) -> Self {
            self.service_catalog_provisioned_product_details = Some(input);
            self
        }
        /// <p>Information about a provisioned service catalog product.</p>
        pub fn set_service_catalog_provisioned_product_details(
            mut self,
            input: std::option::Option<crate::model::ServiceCatalogProvisionedProductDetails>,
        ) -> Self {
            self.service_catalog_provisioned_product_details = input;
            self
        }
        /// <p>The status of the project.</p>
        pub fn project_status(mut self, input: crate::model::ProjectStatus) -> Self {
            self.project_status = Some(input);
            self
        }
        /// <p>The status of the project.</p>
        pub fn set_project_status(
            mut self,
            input: std::option::Option<crate::model::ProjectStatus>,
        ) -> Self {
            self.project_status = input;
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
        pub fn created_by(mut self, input: crate::model::UserContext) -> Self {
            self.created_by = Some(input);
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
        pub fn set_created_by(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The time when the project was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time when the project was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The timestamp when project was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The timestamp when project was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
        pub fn last_modified_by(mut self, input: crate::model::UserContext) -> Self {
            self.last_modified_by = Some(input);
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProjectOutput`](crate::output::DescribeProjectOutput)
        pub fn build(self) -> crate::output::DescribeProjectOutput {
            crate::output::DescribeProjectOutput {
                project_arn: self.project_arn,
                project_name: self.project_name,
                project_id: self.project_id,
                project_description: self.project_description,
                service_catalog_provisioning_details: self.service_catalog_provisioning_details,
                service_catalog_provisioned_product_details: self
                    .service_catalog_provisioned_product_details,
                project_status: self.project_status,
                created_by: self.created_by,
                creation_time: self.creation_time,
                last_modified_time: self.last_modified_time,
                last_modified_by: self.last_modified_by,
            }
        }
    }
}
impl DescribeProjectOutput {
    /// Creates a new builder-style object to manufacture [`DescribeProjectOutput`](crate::output::DescribeProjectOutput)
    pub fn builder() -> crate::output::describe_project_output::Builder {
        crate::output::describe_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProcessingJobOutput {
    /// <p>The inputs for a processing job.</p>
    pub processing_inputs: std::option::Option<std::vec::Vec<crate::model::ProcessingInput>>,
    /// <p>Output configuration for the processing job.</p>
    pub processing_output_config: std::option::Option<crate::model::ProcessingOutputConfig>,
    /// <p>The name of the processing job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
    pub processing_job_name: std::option::Option<std::string::String>,
    /// <p>Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In distributed training, you specify more than one instance.</p>
    pub processing_resources: std::option::Option<crate::model::ProcessingResources>,
    /// <p>The time limit for how long the processing job is allowed to run.</p>
    pub stopping_condition: std::option::Option<crate::model::ProcessingStoppingCondition>,
    /// <p>Configures the processing job to run a specified container image.</p>
    pub app_specification: std::option::Option<crate::model::AppSpecification>,
    /// <p>The environment variables set in the Docker container.</p>
    pub environment:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Networking options for a processing job.</p>
    pub network_config: std::option::Option<crate::model::NetworkConfig>,
    /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The configuration information used to create an experiment.</p>
    pub experiment_config: std::option::Option<crate::model::ExperimentConfig>,
    /// <p>The Amazon Resource Name (ARN) of the processing job.</p>
    pub processing_job_arn: std::option::Option<std::string::String>,
    /// <p>Provides the status of a processing job.</p>
    pub processing_job_status: std::option::Option<crate::model::ProcessingJobStatus>,
    /// <p>An optional string, up to one KB in size, that contains metadata from the processing container when the processing job exits.</p>
    pub exit_message: std::option::Option<std::string::String>,
    /// <p>A string, up to one KB in size, that contains the reason a processing job failed, if it failed.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The time at which the processing job completed.</p>
    pub processing_end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time at which the processing job started.</p>
    pub processing_start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time at which the processing job was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time at which the processing job was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The ARN of a monitoring schedule for an endpoint associated with this processing job.</p>
    pub monitoring_schedule_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of an AutoML job associated with this processing job.</p>
    pub auto_ml_job_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of a training job associated with this processing job.</p>
    pub training_job_arn: std::option::Option<std::string::String>,
}
impl DescribeProcessingJobOutput {
    /// <p>The inputs for a processing job.</p>
    pub fn processing_inputs(&self) -> std::option::Option<&[crate::model::ProcessingInput]> {
        self.processing_inputs.as_deref()
    }
    /// <p>Output configuration for the processing job.</p>
    pub fn processing_output_config(
        &self,
    ) -> std::option::Option<&crate::model::ProcessingOutputConfig> {
        self.processing_output_config.as_ref()
    }
    /// <p>The name of the processing job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
    pub fn processing_job_name(&self) -> std::option::Option<&str> {
        self.processing_job_name.as_deref()
    }
    /// <p>Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In distributed training, you specify more than one instance.</p>
    pub fn processing_resources(&self) -> std::option::Option<&crate::model::ProcessingResources> {
        self.processing_resources.as_ref()
    }
    /// <p>The time limit for how long the processing job is allowed to run.</p>
    pub fn stopping_condition(
        &self,
    ) -> std::option::Option<&crate::model::ProcessingStoppingCondition> {
        self.stopping_condition.as_ref()
    }
    /// <p>Configures the processing job to run a specified container image.</p>
    pub fn app_specification(&self) -> std::option::Option<&crate::model::AppSpecification> {
        self.app_specification.as_ref()
    }
    /// <p>The environment variables set in the Docker container.</p>
    pub fn environment(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.environment.as_ref()
    }
    /// <p>Networking options for a processing job.</p>
    pub fn network_config(&self) -> std::option::Option<&crate::model::NetworkConfig> {
        self.network_config.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The configuration information used to create an experiment.</p>
    pub fn experiment_config(&self) -> std::option::Option<&crate::model::ExperimentConfig> {
        self.experiment_config.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the processing job.</p>
    pub fn processing_job_arn(&self) -> std::option::Option<&str> {
        self.processing_job_arn.as_deref()
    }
    /// <p>Provides the status of a processing job.</p>
    pub fn processing_job_status(&self) -> std::option::Option<&crate::model::ProcessingJobStatus> {
        self.processing_job_status.as_ref()
    }
    /// <p>An optional string, up to one KB in size, that contains metadata from the processing container when the processing job exits.</p>
    pub fn exit_message(&self) -> std::option::Option<&str> {
        self.exit_message.as_deref()
    }
    /// <p>A string, up to one KB in size, that contains the reason a processing job failed, if it failed.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The time at which the processing job completed.</p>
    pub fn processing_end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.processing_end_time.as_ref()
    }
    /// <p>The time at which the processing job started.</p>
    pub fn processing_start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.processing_start_time.as_ref()
    }
    /// <p>The time at which the processing job was last modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>The time at which the processing job was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The ARN of a monitoring schedule for an endpoint associated with this processing job.</p>
    pub fn monitoring_schedule_arn(&self) -> std::option::Option<&str> {
        self.monitoring_schedule_arn.as_deref()
    }
    /// <p>The ARN of an AutoML job associated with this processing job.</p>
    pub fn auto_ml_job_arn(&self) -> std::option::Option<&str> {
        self.auto_ml_job_arn.as_deref()
    }
    /// <p>The ARN of a training job associated with this processing job.</p>
    pub fn training_job_arn(&self) -> std::option::Option<&str> {
        self.training_job_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeProcessingJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProcessingJobOutput");
        formatter.field("processing_inputs", &self.processing_inputs);
        formatter.field("processing_output_config", &self.processing_output_config);
        formatter.field("processing_job_name", &self.processing_job_name);
        formatter.field("processing_resources", &self.processing_resources);
        formatter.field("stopping_condition", &self.stopping_condition);
        formatter.field("app_specification", &self.app_specification);
        formatter.field("environment", &self.environment);
        formatter.field("network_config", &self.network_config);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("experiment_config", &self.experiment_config);
        formatter.field("processing_job_arn", &self.processing_job_arn);
        formatter.field("processing_job_status", &self.processing_job_status);
        formatter.field("exit_message", &self.exit_message);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("processing_end_time", &self.processing_end_time);
        formatter.field("processing_start_time", &self.processing_start_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("monitoring_schedule_arn", &self.monitoring_schedule_arn);
        formatter.field("auto_ml_job_arn", &self.auto_ml_job_arn);
        formatter.field("training_job_arn", &self.training_job_arn);
        formatter.finish()
    }
}
/// See [`DescribeProcessingJobOutput`](crate::output::DescribeProcessingJobOutput)
pub mod describe_processing_job_output {
    /// A builder for [`DescribeProcessingJobOutput`](crate::output::DescribeProcessingJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) processing_inputs:
            std::option::Option<std::vec::Vec<crate::model::ProcessingInput>>,
        pub(crate) processing_output_config:
            std::option::Option<crate::model::ProcessingOutputConfig>,
        pub(crate) processing_job_name: std::option::Option<std::string::String>,
        pub(crate) processing_resources: std::option::Option<crate::model::ProcessingResources>,
        pub(crate) stopping_condition:
            std::option::Option<crate::model::ProcessingStoppingCondition>,
        pub(crate) app_specification: std::option::Option<crate::model::AppSpecification>,
        pub(crate) environment: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) network_config: std::option::Option<crate::model::NetworkConfig>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) experiment_config: std::option::Option<crate::model::ExperimentConfig>,
        pub(crate) processing_job_arn: std::option::Option<std::string::String>,
        pub(crate) processing_job_status: std::option::Option<crate::model::ProcessingJobStatus>,
        pub(crate) exit_message: std::option::Option<std::string::String>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) processing_end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) processing_start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) monitoring_schedule_arn: std::option::Option<std::string::String>,
        pub(crate) auto_ml_job_arn: std::option::Option<std::string::String>,
        pub(crate) training_job_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `processing_inputs`.
        ///
        /// To override the contents of this collection use [`set_processing_inputs`](Self::set_processing_inputs).
        ///
        /// <p>The inputs for a processing job.</p>
        pub fn processing_inputs(mut self, input: crate::model::ProcessingInput) -> Self {
            let mut v = self.processing_inputs.unwrap_or_default();
            v.push(input);
            self.processing_inputs = Some(v);
            self
        }
        /// <p>The inputs for a processing job.</p>
        pub fn set_processing_inputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProcessingInput>>,
        ) -> Self {
            self.processing_inputs = input;
            self
        }
        /// <p>Output configuration for the processing job.</p>
        pub fn processing_output_config(
            mut self,
            input: crate::model::ProcessingOutputConfig,
        ) -> Self {
            self.processing_output_config = Some(input);
            self
        }
        /// <p>Output configuration for the processing job.</p>
        pub fn set_processing_output_config(
            mut self,
            input: std::option::Option<crate::model::ProcessingOutputConfig>,
        ) -> Self {
            self.processing_output_config = input;
            self
        }
        /// <p>The name of the processing job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
        pub fn processing_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.processing_job_name = Some(input.into());
            self
        }
        /// <p>The name of the processing job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
        pub fn set_processing_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.processing_job_name = input;
            self
        }
        /// <p>Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In distributed training, you specify more than one instance.</p>
        pub fn processing_resources(mut self, input: crate::model::ProcessingResources) -> Self {
            self.processing_resources = Some(input);
            self
        }
        /// <p>Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In distributed training, you specify more than one instance.</p>
        pub fn set_processing_resources(
            mut self,
            input: std::option::Option<crate::model::ProcessingResources>,
        ) -> Self {
            self.processing_resources = input;
            self
        }
        /// <p>The time limit for how long the processing job is allowed to run.</p>
        pub fn stopping_condition(
            mut self,
            input: crate::model::ProcessingStoppingCondition,
        ) -> Self {
            self.stopping_condition = Some(input);
            self
        }
        /// <p>The time limit for how long the processing job is allowed to run.</p>
        pub fn set_stopping_condition(
            mut self,
            input: std::option::Option<crate::model::ProcessingStoppingCondition>,
        ) -> Self {
            self.stopping_condition = input;
            self
        }
        /// <p>Configures the processing job to run a specified container image.</p>
        pub fn app_specification(mut self, input: crate::model::AppSpecification) -> Self {
            self.app_specification = Some(input);
            self
        }
        /// <p>Configures the processing job to run a specified container image.</p>
        pub fn set_app_specification(
            mut self,
            input: std::option::Option<crate::model::AppSpecification>,
        ) -> Self {
            self.app_specification = input;
            self
        }
        /// Adds a key-value pair to `environment`.
        ///
        /// To override the contents of this collection use [`set_environment`](Self::set_environment).
        ///
        /// <p>The environment variables set in the Docker container.</p>
        pub fn environment(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.environment.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.environment = Some(hash_map);
            self
        }
        /// <p>The environment variables set in the Docker container.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.environment = input;
            self
        }
        /// <p>Networking options for a processing job.</p>
        pub fn network_config(mut self, input: crate::model::NetworkConfig) -> Self {
            self.network_config = Some(input);
            self
        }
        /// <p>Networking options for a processing job.</p>
        pub fn set_network_config(
            mut self,
            input: std::option::Option<crate::model::NetworkConfig>,
        ) -> Self {
            self.network_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The configuration information used to create an experiment.</p>
        pub fn experiment_config(mut self, input: crate::model::ExperimentConfig) -> Self {
            self.experiment_config = Some(input);
            self
        }
        /// <p>The configuration information used to create an experiment.</p>
        pub fn set_experiment_config(
            mut self,
            input: std::option::Option<crate::model::ExperimentConfig>,
        ) -> Self {
            self.experiment_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the processing job.</p>
        pub fn processing_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.processing_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the processing job.</p>
        pub fn set_processing_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.processing_job_arn = input;
            self
        }
        /// <p>Provides the status of a processing job.</p>
        pub fn processing_job_status(mut self, input: crate::model::ProcessingJobStatus) -> Self {
            self.processing_job_status = Some(input);
            self
        }
        /// <p>Provides the status of a processing job.</p>
        pub fn set_processing_job_status(
            mut self,
            input: std::option::Option<crate::model::ProcessingJobStatus>,
        ) -> Self {
            self.processing_job_status = input;
            self
        }
        /// <p>An optional string, up to one KB in size, that contains metadata from the processing container when the processing job exits.</p>
        pub fn exit_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.exit_message = Some(input.into());
            self
        }
        /// <p>An optional string, up to one KB in size, that contains metadata from the processing container when the processing job exits.</p>
        pub fn set_exit_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.exit_message = input;
            self
        }
        /// <p>A string, up to one KB in size, that contains the reason a processing job failed, if it failed.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>A string, up to one KB in size, that contains the reason a processing job failed, if it failed.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The time at which the processing job completed.</p>
        pub fn processing_end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.processing_end_time = Some(input);
            self
        }
        /// <p>The time at which the processing job completed.</p>
        pub fn set_processing_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.processing_end_time = input;
            self
        }
        /// <p>The time at which the processing job started.</p>
        pub fn processing_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.processing_start_time = Some(input);
            self
        }
        /// <p>The time at which the processing job started.</p>
        pub fn set_processing_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.processing_start_time = input;
            self
        }
        /// <p>The time at which the processing job was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The time at which the processing job was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>The time at which the processing job was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time at which the processing job was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The ARN of a monitoring schedule for an endpoint associated with this processing job.</p>
        pub fn monitoring_schedule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.monitoring_schedule_arn = Some(input.into());
            self
        }
        /// <p>The ARN of a monitoring schedule for an endpoint associated with this processing job.</p>
        pub fn set_monitoring_schedule_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.monitoring_schedule_arn = input;
            self
        }
        /// <p>The ARN of an AutoML job associated with this processing job.</p>
        pub fn auto_ml_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_ml_job_arn = Some(input.into());
            self
        }
        /// <p>The ARN of an AutoML job associated with this processing job.</p>
        pub fn set_auto_ml_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_ml_job_arn = input;
            self
        }
        /// <p>The ARN of a training job associated with this processing job.</p>
        pub fn training_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.training_job_arn = Some(input.into());
            self
        }
        /// <p>The ARN of a training job associated with this processing job.</p>
        pub fn set_training_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.training_job_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProcessingJobOutput`](crate::output::DescribeProcessingJobOutput)
        pub fn build(self) -> crate::output::DescribeProcessingJobOutput {
            crate::output::DescribeProcessingJobOutput {
                processing_inputs: self.processing_inputs,
                processing_output_config: self.processing_output_config,
                processing_job_name: self.processing_job_name,
                processing_resources: self.processing_resources,
                stopping_condition: self.stopping_condition,
                app_specification: self.app_specification,
                environment: self.environment,
                network_config: self.network_config,
                role_arn: self.role_arn,
                experiment_config: self.experiment_config,
                processing_job_arn: self.processing_job_arn,
                processing_job_status: self.processing_job_status,
                exit_message: self.exit_message,
                failure_reason: self.failure_reason,
                processing_end_time: self.processing_end_time,
                processing_start_time: self.processing_start_time,
                last_modified_time: self.last_modified_time,
                creation_time: self.creation_time,
                monitoring_schedule_arn: self.monitoring_schedule_arn,
                auto_ml_job_arn: self.auto_ml_job_arn,
                training_job_arn: self.training_job_arn,
            }
        }
    }
}
impl DescribeProcessingJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeProcessingJobOutput`](crate::output::DescribeProcessingJobOutput)
    pub fn builder() -> crate::output::describe_processing_job_output::Builder {
        crate::output::describe_processing_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePipelineExecutionOutput {
    /// <p>The Amazon Resource Name (ARN) of the pipeline.</p>
    pub pipeline_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
    pub pipeline_execution_arn: std::option::Option<std::string::String>,
    /// <p>The display name of the pipeline execution.</p>
    pub pipeline_execution_display_name: std::option::Option<std::string::String>,
    /// <p>The status of the pipeline execution.</p>
    pub pipeline_execution_status: std::option::Option<crate::model::PipelineExecutionStatus>,
    /// <p>The description of the pipeline execution.</p>
    pub pipeline_execution_description: std::option::Option<std::string::String>,
    /// <p>Specifies the names of the experiment and trial created by a pipeline.</p>
    pub pipeline_experiment_config: std::option::Option<crate::model::PipelineExperimentConfig>,
    /// <p>If the execution failed, a message describing why.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The time when the pipeline execution was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the pipeline execution was modified last.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
    pub created_by: std::option::Option<crate::model::UserContext>,
    /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
    pub last_modified_by: std::option::Option<crate::model::UserContext>,
    /// <p>The parallelism configuration applied to the pipeline.</p>
    pub parallelism_configuration: std::option::Option<crate::model::ParallelismConfiguration>,
}
impl DescribePipelineExecutionOutput {
    /// <p>The Amazon Resource Name (ARN) of the pipeline.</p>
    pub fn pipeline_arn(&self) -> std::option::Option<&str> {
        self.pipeline_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
    pub fn pipeline_execution_arn(&self) -> std::option::Option<&str> {
        self.pipeline_execution_arn.as_deref()
    }
    /// <p>The display name of the pipeline execution.</p>
    pub fn pipeline_execution_display_name(&self) -> std::option::Option<&str> {
        self.pipeline_execution_display_name.as_deref()
    }
    /// <p>The status of the pipeline execution.</p>
    pub fn pipeline_execution_status(
        &self,
    ) -> std::option::Option<&crate::model::PipelineExecutionStatus> {
        self.pipeline_execution_status.as_ref()
    }
    /// <p>The description of the pipeline execution.</p>
    pub fn pipeline_execution_description(&self) -> std::option::Option<&str> {
        self.pipeline_execution_description.as_deref()
    }
    /// <p>Specifies the names of the experiment and trial created by a pipeline.</p>
    pub fn pipeline_experiment_config(
        &self,
    ) -> std::option::Option<&crate::model::PipelineExperimentConfig> {
        self.pipeline_experiment_config.as_ref()
    }
    /// <p>If the execution failed, a message describing why.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The time when the pipeline execution was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The time when the pipeline execution was modified last.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
    pub fn created_by(&self) -> std::option::Option<&crate::model::UserContext> {
        self.created_by.as_ref()
    }
    /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
    pub fn last_modified_by(&self) -> std::option::Option<&crate::model::UserContext> {
        self.last_modified_by.as_ref()
    }
    /// <p>The parallelism configuration applied to the pipeline.</p>
    pub fn parallelism_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ParallelismConfiguration> {
        self.parallelism_configuration.as_ref()
    }
}
impl std::fmt::Debug for DescribePipelineExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePipelineExecutionOutput");
        formatter.field("pipeline_arn", &self.pipeline_arn);
        formatter.field("pipeline_execution_arn", &self.pipeline_execution_arn);
        formatter.field(
            "pipeline_execution_display_name",
            &self.pipeline_execution_display_name,
        );
        formatter.field("pipeline_execution_status", &self.pipeline_execution_status);
        formatter.field(
            "pipeline_execution_description",
            &self.pipeline_execution_description,
        );
        formatter.field(
            "pipeline_experiment_config",
            &self.pipeline_experiment_config,
        );
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("created_by", &self.created_by);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("parallelism_configuration", &self.parallelism_configuration);
        formatter.finish()
    }
}
/// See [`DescribePipelineExecutionOutput`](crate::output::DescribePipelineExecutionOutput)
pub mod describe_pipeline_execution_output {
    /// A builder for [`DescribePipelineExecutionOutput`](crate::output::DescribePipelineExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_arn: std::option::Option<std::string::String>,
        pub(crate) pipeline_execution_arn: std::option::Option<std::string::String>,
        pub(crate) pipeline_execution_display_name: std::option::Option<std::string::String>,
        pub(crate) pipeline_execution_status:
            std::option::Option<crate::model::PipelineExecutionStatus>,
        pub(crate) pipeline_execution_description: std::option::Option<std::string::String>,
        pub(crate) pipeline_experiment_config:
            std::option::Option<crate::model::PipelineExperimentConfig>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_by: std::option::Option<crate::model::UserContext>,
        pub(crate) last_modified_by: std::option::Option<crate::model::UserContext>,
        pub(crate) parallelism_configuration:
            std::option::Option<crate::model::ParallelismConfiguration>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the pipeline.</p>
        pub fn pipeline_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the pipeline.</p>
        pub fn set_pipeline_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pipeline_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
        pub fn pipeline_execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_execution_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
        pub fn set_pipeline_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_execution_arn = input;
            self
        }
        /// <p>The display name of the pipeline execution.</p>
        pub fn pipeline_execution_display_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.pipeline_execution_display_name = Some(input.into());
            self
        }
        /// <p>The display name of the pipeline execution.</p>
        pub fn set_pipeline_execution_display_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_execution_display_name = input;
            self
        }
        /// <p>The status of the pipeline execution.</p>
        pub fn pipeline_execution_status(
            mut self,
            input: crate::model::PipelineExecutionStatus,
        ) -> Self {
            self.pipeline_execution_status = Some(input);
            self
        }
        /// <p>The status of the pipeline execution.</p>
        pub fn set_pipeline_execution_status(
            mut self,
            input: std::option::Option<crate::model::PipelineExecutionStatus>,
        ) -> Self {
            self.pipeline_execution_status = input;
            self
        }
        /// <p>The description of the pipeline execution.</p>
        pub fn pipeline_execution_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.pipeline_execution_description = Some(input.into());
            self
        }
        /// <p>The description of the pipeline execution.</p>
        pub fn set_pipeline_execution_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_execution_description = input;
            self
        }
        /// <p>Specifies the names of the experiment and trial created by a pipeline.</p>
        pub fn pipeline_experiment_config(
            mut self,
            input: crate::model::PipelineExperimentConfig,
        ) -> Self {
            self.pipeline_experiment_config = Some(input);
            self
        }
        /// <p>Specifies the names of the experiment and trial created by a pipeline.</p>
        pub fn set_pipeline_experiment_config(
            mut self,
            input: std::option::Option<crate::model::PipelineExperimentConfig>,
        ) -> Self {
            self.pipeline_experiment_config = input;
            self
        }
        /// <p>If the execution failed, a message describing why.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If the execution failed, a message describing why.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The time when the pipeline execution was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time when the pipeline execution was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time when the pipeline execution was modified last.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The time when the pipeline execution was modified last.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
        pub fn created_by(mut self, input: crate::model::UserContext) -> Self {
            self.created_by = Some(input);
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
        pub fn set_created_by(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.created_by = input;
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
        pub fn last_modified_by(mut self, input: crate::model::UserContext) -> Self {
            self.last_modified_by = Some(input);
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// <p>The parallelism configuration applied to the pipeline.</p>
        pub fn parallelism_configuration(
            mut self,
            input: crate::model::ParallelismConfiguration,
        ) -> Self {
            self.parallelism_configuration = Some(input);
            self
        }
        /// <p>The parallelism configuration applied to the pipeline.</p>
        pub fn set_parallelism_configuration(
            mut self,
            input: std::option::Option<crate::model::ParallelismConfiguration>,
        ) -> Self {
            self.parallelism_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePipelineExecutionOutput`](crate::output::DescribePipelineExecutionOutput)
        pub fn build(self) -> crate::output::DescribePipelineExecutionOutput {
            crate::output::DescribePipelineExecutionOutput {
                pipeline_arn: self.pipeline_arn,
                pipeline_execution_arn: self.pipeline_execution_arn,
                pipeline_execution_display_name: self.pipeline_execution_display_name,
                pipeline_execution_status: self.pipeline_execution_status,
                pipeline_execution_description: self.pipeline_execution_description,
                pipeline_experiment_config: self.pipeline_experiment_config,
                failure_reason: self.failure_reason,
                creation_time: self.creation_time,
                last_modified_time: self.last_modified_time,
                created_by: self.created_by,
                last_modified_by: self.last_modified_by,
                parallelism_configuration: self.parallelism_configuration,
            }
        }
    }
}
impl DescribePipelineExecutionOutput {
    /// Creates a new builder-style object to manufacture [`DescribePipelineExecutionOutput`](crate::output::DescribePipelineExecutionOutput)
    pub fn builder() -> crate::output::describe_pipeline_execution_output::Builder {
        crate::output::describe_pipeline_execution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePipelineDefinitionForExecutionOutput {
    /// <p>The JSON pipeline definition.</p>
    pub pipeline_definition: std::option::Option<std::string::String>,
    /// <p>The time when the pipeline was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribePipelineDefinitionForExecutionOutput {
    /// <p>The JSON pipeline definition.</p>
    pub fn pipeline_definition(&self) -> std::option::Option<&str> {
        self.pipeline_definition.as_deref()
    }
    /// <p>The time when the pipeline was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
}
impl std::fmt::Debug for DescribePipelineDefinitionForExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePipelineDefinitionForExecutionOutput");
        formatter.field("pipeline_definition", &self.pipeline_definition);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`DescribePipelineDefinitionForExecutionOutput`](crate::output::DescribePipelineDefinitionForExecutionOutput)
pub mod describe_pipeline_definition_for_execution_output {
    /// A builder for [`DescribePipelineDefinitionForExecutionOutput`](crate::output::DescribePipelineDefinitionForExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_definition: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The JSON pipeline definition.</p>
        pub fn pipeline_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_definition = Some(input.into());
            self
        }
        /// <p>The JSON pipeline definition.</p>
        pub fn set_pipeline_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_definition = input;
            self
        }
        /// <p>The time when the pipeline was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time when the pipeline was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePipelineDefinitionForExecutionOutput`](crate::output::DescribePipelineDefinitionForExecutionOutput)
        pub fn build(self) -> crate::output::DescribePipelineDefinitionForExecutionOutput {
            crate::output::DescribePipelineDefinitionForExecutionOutput {
                pipeline_definition: self.pipeline_definition,
                creation_time: self.creation_time,
            }
        }
    }
}
impl DescribePipelineDefinitionForExecutionOutput {
    /// Creates a new builder-style object to manufacture [`DescribePipelineDefinitionForExecutionOutput`](crate::output::DescribePipelineDefinitionForExecutionOutput)
    pub fn builder() -> crate::output::describe_pipeline_definition_for_execution_output::Builder {
        crate::output::describe_pipeline_definition_for_execution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePipelineOutput {
    /// <p>The Amazon Resource Name (ARN) of the pipeline.</p>
    pub pipeline_arn: std::option::Option<std::string::String>,
    /// <p>The name of the pipeline.</p>
    pub pipeline_name: std::option::Option<std::string::String>,
    /// <p>The display name of the pipeline.</p>
    pub pipeline_display_name: std::option::Option<std::string::String>,
    /// <p>The JSON pipeline definition.</p>
    pub pipeline_definition: std::option::Option<std::string::String>,
    /// <p>The description of the pipeline.</p>
    pub pipeline_description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) that the pipeline uses to execute.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The status of the pipeline execution.</p>
    pub pipeline_status: std::option::Option<crate::model::PipelineStatus>,
    /// <p>The time when the pipeline was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the pipeline was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the pipeline was last run.</p>
    pub last_run_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
    pub created_by: std::option::Option<crate::model::UserContext>,
    /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
    pub last_modified_by: std::option::Option<crate::model::UserContext>,
    /// <p>Lists the parallelism configuration applied to the pipeline.</p>
    pub parallelism_configuration: std::option::Option<crate::model::ParallelismConfiguration>,
}
impl DescribePipelineOutput {
    /// <p>The Amazon Resource Name (ARN) of the pipeline.</p>
    pub fn pipeline_arn(&self) -> std::option::Option<&str> {
        self.pipeline_arn.as_deref()
    }
    /// <p>The name of the pipeline.</p>
    pub fn pipeline_name(&self) -> std::option::Option<&str> {
        self.pipeline_name.as_deref()
    }
    /// <p>The display name of the pipeline.</p>
    pub fn pipeline_display_name(&self) -> std::option::Option<&str> {
        self.pipeline_display_name.as_deref()
    }
    /// <p>The JSON pipeline definition.</p>
    pub fn pipeline_definition(&self) -> std::option::Option<&str> {
        self.pipeline_definition.as_deref()
    }
    /// <p>The description of the pipeline.</p>
    pub fn pipeline_description(&self) -> std::option::Option<&str> {
        self.pipeline_description.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) that the pipeline uses to execute.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The status of the pipeline execution.</p>
    pub fn pipeline_status(&self) -> std::option::Option<&crate::model::PipelineStatus> {
        self.pipeline_status.as_ref()
    }
    /// <p>The time when the pipeline was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The time when the pipeline was last modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>The time when the pipeline was last run.</p>
    pub fn last_run_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_run_time.as_ref()
    }
    /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
    pub fn created_by(&self) -> std::option::Option<&crate::model::UserContext> {
        self.created_by.as_ref()
    }
    /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
    pub fn last_modified_by(&self) -> std::option::Option<&crate::model::UserContext> {
        self.last_modified_by.as_ref()
    }
    /// <p>Lists the parallelism configuration applied to the pipeline.</p>
    pub fn parallelism_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ParallelismConfiguration> {
        self.parallelism_configuration.as_ref()
    }
}
impl std::fmt::Debug for DescribePipelineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePipelineOutput");
        formatter.field("pipeline_arn", &self.pipeline_arn);
        formatter.field("pipeline_name", &self.pipeline_name);
        formatter.field("pipeline_display_name", &self.pipeline_display_name);
        formatter.field("pipeline_definition", &self.pipeline_definition);
        formatter.field("pipeline_description", &self.pipeline_description);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("pipeline_status", &self.pipeline_status);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("last_run_time", &self.last_run_time);
        formatter.field("created_by", &self.created_by);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("parallelism_configuration", &self.parallelism_configuration);
        formatter.finish()
    }
}
/// See [`DescribePipelineOutput`](crate::output::DescribePipelineOutput)
pub mod describe_pipeline_output {
    /// A builder for [`DescribePipelineOutput`](crate::output::DescribePipelineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_arn: std::option::Option<std::string::String>,
        pub(crate) pipeline_name: std::option::Option<std::string::String>,
        pub(crate) pipeline_display_name: std::option::Option<std::string::String>,
        pub(crate) pipeline_definition: std::option::Option<std::string::String>,
        pub(crate) pipeline_description: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) pipeline_status: std::option::Option<crate::model::PipelineStatus>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_run_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_by: std::option::Option<crate::model::UserContext>,
        pub(crate) last_modified_by: std::option::Option<crate::model::UserContext>,
        pub(crate) parallelism_configuration:
            std::option::Option<crate::model::ParallelismConfiguration>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the pipeline.</p>
        pub fn pipeline_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the pipeline.</p>
        pub fn set_pipeline_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pipeline_arn = input;
            self
        }
        /// <p>The name of the pipeline.</p>
        pub fn pipeline_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_name = Some(input.into());
            self
        }
        /// <p>The name of the pipeline.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_name = input;
            self
        }
        /// <p>The display name of the pipeline.</p>
        pub fn pipeline_display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_display_name = Some(input.into());
            self
        }
        /// <p>The display name of the pipeline.</p>
        pub fn set_pipeline_display_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_display_name = input;
            self
        }
        /// <p>The JSON pipeline definition.</p>
        pub fn pipeline_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_definition = Some(input.into());
            self
        }
        /// <p>The JSON pipeline definition.</p>
        pub fn set_pipeline_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_definition = input;
            self
        }
        /// <p>The description of the pipeline.</p>
        pub fn pipeline_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_description = Some(input.into());
            self
        }
        /// <p>The description of the pipeline.</p>
        pub fn set_pipeline_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that the pipeline uses to execute.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that the pipeline uses to execute.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The status of the pipeline execution.</p>
        pub fn pipeline_status(mut self, input: crate::model::PipelineStatus) -> Self {
            self.pipeline_status = Some(input);
            self
        }
        /// <p>The status of the pipeline execution.</p>
        pub fn set_pipeline_status(
            mut self,
            input: std::option::Option<crate::model::PipelineStatus>,
        ) -> Self {
            self.pipeline_status = input;
            self
        }
        /// <p>The time when the pipeline was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time when the pipeline was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time when the pipeline was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The time when the pipeline was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>The time when the pipeline was last run.</p>
        pub fn last_run_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_run_time = Some(input);
            self
        }
        /// <p>The time when the pipeline was last run.</p>
        pub fn set_last_run_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_run_time = input;
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
        pub fn created_by(mut self, input: crate::model::UserContext) -> Self {
            self.created_by = Some(input);
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
        pub fn set_created_by(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.created_by = input;
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
        pub fn last_modified_by(mut self, input: crate::model::UserContext) -> Self {
            self.last_modified_by = Some(input);
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// <p>Lists the parallelism configuration applied to the pipeline.</p>
        pub fn parallelism_configuration(
            mut self,
            input: crate::model::ParallelismConfiguration,
        ) -> Self {
            self.parallelism_configuration = Some(input);
            self
        }
        /// <p>Lists the parallelism configuration applied to the pipeline.</p>
        pub fn set_parallelism_configuration(
            mut self,
            input: std::option::Option<crate::model::ParallelismConfiguration>,
        ) -> Self {
            self.parallelism_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePipelineOutput`](crate::output::DescribePipelineOutput)
        pub fn build(self) -> crate::output::DescribePipelineOutput {
            crate::output::DescribePipelineOutput {
                pipeline_arn: self.pipeline_arn,
                pipeline_name: self.pipeline_name,
                pipeline_display_name: self.pipeline_display_name,
                pipeline_definition: self.pipeline_definition,
                pipeline_description: self.pipeline_description,
                role_arn: self.role_arn,
                pipeline_status: self.pipeline_status,
                creation_time: self.creation_time,
                last_modified_time: self.last_modified_time,
                last_run_time: self.last_run_time,
                created_by: self.created_by,
                last_modified_by: self.last_modified_by,
                parallelism_configuration: self.parallelism_configuration,
            }
        }
    }
}
impl DescribePipelineOutput {
    /// Creates a new builder-style object to manufacture [`DescribePipelineOutput`](crate::output::DescribePipelineOutput)
    pub fn builder() -> crate::output::describe_pipeline_output::Builder {
        crate::output::describe_pipeline_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeNotebookInstanceLifecycleConfigOutput {
    /// <p>The Amazon Resource Name (ARN) of the lifecycle configuration.</p>
    pub notebook_instance_lifecycle_config_arn: std::option::Option<std::string::String>,
    /// <p>The name of the lifecycle configuration.</p>
    pub notebook_instance_lifecycle_config_name: std::option::Option<std::string::String>,
    /// <p>The shell script that runs only once, when you create a notebook instance.</p>
    pub on_create: std::option::Option<std::vec::Vec<crate::model::NotebookInstanceLifecycleHook>>,
    /// <p>The shell script that runs every time you start a notebook instance, including when you create the notebook instance.</p>
    pub on_start: std::option::Option<std::vec::Vec<crate::model::NotebookInstanceLifecycleHook>>,
    /// <p>A timestamp that tells when the lifecycle configuration was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp that tells when the lifecycle configuration was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeNotebookInstanceLifecycleConfigOutput {
    /// <p>The Amazon Resource Name (ARN) of the lifecycle configuration.</p>
    pub fn notebook_instance_lifecycle_config_arn(&self) -> std::option::Option<&str> {
        self.notebook_instance_lifecycle_config_arn.as_deref()
    }
    /// <p>The name of the lifecycle configuration.</p>
    pub fn notebook_instance_lifecycle_config_name(&self) -> std::option::Option<&str> {
        self.notebook_instance_lifecycle_config_name.as_deref()
    }
    /// <p>The shell script that runs only once, when you create a notebook instance.</p>
    pub fn on_create(&self) -> std::option::Option<&[crate::model::NotebookInstanceLifecycleHook]> {
        self.on_create.as_deref()
    }
    /// <p>The shell script that runs every time you start a notebook instance, including when you create the notebook instance.</p>
    pub fn on_start(&self) -> std::option::Option<&[crate::model::NotebookInstanceLifecycleHook]> {
        self.on_start.as_deref()
    }
    /// <p>A timestamp that tells when the lifecycle configuration was last modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>A timestamp that tells when the lifecycle configuration was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeNotebookInstanceLifecycleConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeNotebookInstanceLifecycleConfigOutput");
        formatter.field(
            "notebook_instance_lifecycle_config_arn",
            &self.notebook_instance_lifecycle_config_arn,
        );
        formatter.field(
            "notebook_instance_lifecycle_config_name",
            &self.notebook_instance_lifecycle_config_name,
        );
        formatter.field("on_create", &self.on_create);
        formatter.field("on_start", &self.on_start);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`DescribeNotebookInstanceLifecycleConfigOutput`](crate::output::DescribeNotebookInstanceLifecycleConfigOutput)
pub mod describe_notebook_instance_lifecycle_config_output {
    /// A builder for [`DescribeNotebookInstanceLifecycleConfigOutput`](crate::output::DescribeNotebookInstanceLifecycleConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notebook_instance_lifecycle_config_arn: std::option::Option<std::string::String>,
        pub(crate) notebook_instance_lifecycle_config_name:
            std::option::Option<std::string::String>,
        pub(crate) on_create:
            std::option::Option<std::vec::Vec<crate::model::NotebookInstanceLifecycleHook>>,
        pub(crate) on_start:
            std::option::Option<std::vec::Vec<crate::model::NotebookInstanceLifecycleHook>>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the lifecycle configuration.</p>
        pub fn notebook_instance_lifecycle_config_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.notebook_instance_lifecycle_config_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the lifecycle configuration.</p>
        pub fn set_notebook_instance_lifecycle_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notebook_instance_lifecycle_config_arn = input;
            self
        }
        /// <p>The name of the lifecycle configuration.</p>
        pub fn notebook_instance_lifecycle_config_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.notebook_instance_lifecycle_config_name = Some(input.into());
            self
        }
        /// <p>The name of the lifecycle configuration.</p>
        pub fn set_notebook_instance_lifecycle_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notebook_instance_lifecycle_config_name = input;
            self
        }
        /// Appends an item to `on_create`.
        ///
        /// To override the contents of this collection use [`set_on_create`](Self::set_on_create).
        ///
        /// <p>The shell script that runs only once, when you create a notebook instance.</p>
        pub fn on_create(mut self, input: crate::model::NotebookInstanceLifecycleHook) -> Self {
            let mut v = self.on_create.unwrap_or_default();
            v.push(input);
            self.on_create = Some(v);
            self
        }
        /// <p>The shell script that runs only once, when you create a notebook instance.</p>
        pub fn set_on_create(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NotebookInstanceLifecycleHook>>,
        ) -> Self {
            self.on_create = input;
            self
        }
        /// Appends an item to `on_start`.
        ///
        /// To override the contents of this collection use [`set_on_start`](Self::set_on_start).
        ///
        /// <p>The shell script that runs every time you start a notebook instance, including when you create the notebook instance.</p>
        pub fn on_start(mut self, input: crate::model::NotebookInstanceLifecycleHook) -> Self {
            let mut v = self.on_start.unwrap_or_default();
            v.push(input);
            self.on_start = Some(v);
            self
        }
        /// <p>The shell script that runs every time you start a notebook instance, including when you create the notebook instance.</p>
        pub fn set_on_start(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NotebookInstanceLifecycleHook>>,
        ) -> Self {
            self.on_start = input;
            self
        }
        /// <p>A timestamp that tells when the lifecycle configuration was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>A timestamp that tells when the lifecycle configuration was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>A timestamp that tells when the lifecycle configuration was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A timestamp that tells when the lifecycle configuration was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeNotebookInstanceLifecycleConfigOutput`](crate::output::DescribeNotebookInstanceLifecycleConfigOutput)
        pub fn build(self) -> crate::output::DescribeNotebookInstanceLifecycleConfigOutput {
            crate::output::DescribeNotebookInstanceLifecycleConfigOutput {
                notebook_instance_lifecycle_config_arn: self.notebook_instance_lifecycle_config_arn,
                notebook_instance_lifecycle_config_name: self
                    .notebook_instance_lifecycle_config_name,
                on_create: self.on_create,
                on_start: self.on_start,
                last_modified_time: self.last_modified_time,
                creation_time: self.creation_time,
            }
        }
    }
}
impl DescribeNotebookInstanceLifecycleConfigOutput {
    /// Creates a new builder-style object to manufacture [`DescribeNotebookInstanceLifecycleConfigOutput`](crate::output::DescribeNotebookInstanceLifecycleConfigOutput)
    pub fn builder() -> crate::output::describe_notebook_instance_lifecycle_config_output::Builder {
        crate::output::describe_notebook_instance_lifecycle_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeNotebookInstanceOutput {
    /// <p>The Amazon Resource Name (ARN) of the notebook instance.</p>
    pub notebook_instance_arn: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon SageMaker notebook instance. </p>
    pub notebook_instance_name: std::option::Option<std::string::String>,
    /// <p>The status of the notebook instance.</p>
    pub notebook_instance_status: std::option::Option<crate::model::NotebookInstanceStatus>,
    /// <p>If status is <code>Failed</code>, the reason it failed.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The URL that you use to connect to the Jupyter notebook that is running in your notebook instance. </p>
    pub url: std::option::Option<std::string::String>,
    /// <p>The type of ML compute instance running on the notebook instance.</p>
    pub instance_type: std::option::Option<crate::model::InstanceType>,
    /// <p>The ID of the VPC subnet.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>The IDs of the VPC security groups.</p>
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role associated with the instance. </p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services KMS key ID Amazon SageMaker uses to encrypt data when storing it on the ML storage volume attached to the instance. </p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The network interface IDs that Amazon SageMaker created at the time of creating the instance. </p>
    pub network_interface_id: std::option::Option<std::string::String>,
    /// <p>A timestamp. Use this parameter to retrieve the time when the notebook instance was last modified. </p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp. Use this parameter to return the time when the notebook instance was created</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Returns the name of a notebook instance lifecycle configuration.</p>
    /// <p>For information about notebook instance lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a> </p>
    pub notebook_instance_lifecycle_config_name: std::option::Option<std::string::String>,
    /// <p>Describes whether Amazon SageMaker provides internet access to the notebook instance. If this value is set to <i>Disabled</i>, the notebook instance does not have internet access, and cannot connect to Amazon SageMaker training and endpoint services.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access">Notebook Instances Are Internet-Enabled by Default</a>.</p>
    pub direct_internet_access: std::option::Option<crate::model::DirectInternetAccess>,
    /// <p>The size, in GB, of the ML storage volume attached to the notebook instance.</p>
    pub volume_size_in_gb: std::option::Option<i32>,
    /// <p>A list of the Elastic Inference (EI) instance types associated with this notebook instance. Currently only one EI instance type can be associated with a notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.</p>
    pub accelerator_types:
        std::option::Option<std::vec::Vec<crate::model::NotebookInstanceAcceleratorType>>,
    /// <p>The Git repository associated with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>
    pub default_code_repository: std::option::Option<std::string::String>,
    /// <p>An array of up to three Git repositories associated with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>
    pub additional_code_repositories: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Whether root access is enabled or disabled for users of the notebook instance.</p> <note>
    /// <p>Lifecycle configurations need root access to be able to set up a notebook instance. Because of this, lifecycle configurations associated with a notebook instance always run with root access even if you disable root access for users.</p>
    /// </note>
    pub root_access: std::option::Option<crate::model::RootAccess>,
    /// <p>The platform identifier of the notebook instance runtime environment.</p>
    pub platform_identifier: std::option::Option<std::string::String>,
}
impl DescribeNotebookInstanceOutput {
    /// <p>The Amazon Resource Name (ARN) of the notebook instance.</p>
    pub fn notebook_instance_arn(&self) -> std::option::Option<&str> {
        self.notebook_instance_arn.as_deref()
    }
    /// <p>The name of the Amazon SageMaker notebook instance. </p>
    pub fn notebook_instance_name(&self) -> std::option::Option<&str> {
        self.notebook_instance_name.as_deref()
    }
    /// <p>The status of the notebook instance.</p>
    pub fn notebook_instance_status(
        &self,
    ) -> std::option::Option<&crate::model::NotebookInstanceStatus> {
        self.notebook_instance_status.as_ref()
    }
    /// <p>If status is <code>Failed</code>, the reason it failed.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The URL that you use to connect to the Jupyter notebook that is running in your notebook instance. </p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
    /// <p>The type of ML compute instance running on the notebook instance.</p>
    pub fn instance_type(&self) -> std::option::Option<&crate::model::InstanceType> {
        self.instance_type.as_ref()
    }
    /// <p>The ID of the VPC subnet.</p>
    pub fn subnet_id(&self) -> std::option::Option<&str> {
        self.subnet_id.as_deref()
    }
    /// <p>The IDs of the VPC security groups.</p>
    pub fn security_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.security_groups.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM role associated with the instance. </p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The Amazon Web Services KMS key ID Amazon SageMaker uses to encrypt data when storing it on the ML storage volume attached to the instance. </p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The network interface IDs that Amazon SageMaker created at the time of creating the instance. </p>
    pub fn network_interface_id(&self) -> std::option::Option<&str> {
        self.network_interface_id.as_deref()
    }
    /// <p>A timestamp. Use this parameter to retrieve the time when the notebook instance was last modified. </p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>A timestamp. Use this parameter to return the time when the notebook instance was created</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>Returns the name of a notebook instance lifecycle configuration.</p>
    /// <p>For information about notebook instance lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a> </p>
    pub fn notebook_instance_lifecycle_config_name(&self) -> std::option::Option<&str> {
        self.notebook_instance_lifecycle_config_name.as_deref()
    }
    /// <p>Describes whether Amazon SageMaker provides internet access to the notebook instance. If this value is set to <i>Disabled</i>, the notebook instance does not have internet access, and cannot connect to Amazon SageMaker training and endpoint services.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access">Notebook Instances Are Internet-Enabled by Default</a>.</p>
    pub fn direct_internet_access(
        &self,
    ) -> std::option::Option<&crate::model::DirectInternetAccess> {
        self.direct_internet_access.as_ref()
    }
    /// <p>The size, in GB, of the ML storage volume attached to the notebook instance.</p>
    pub fn volume_size_in_gb(&self) -> std::option::Option<i32> {
        self.volume_size_in_gb
    }
    /// <p>A list of the Elastic Inference (EI) instance types associated with this notebook instance. Currently only one EI instance type can be associated with a notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.</p>
    pub fn accelerator_types(
        &self,
    ) -> std::option::Option<&[crate::model::NotebookInstanceAcceleratorType]> {
        self.accelerator_types.as_deref()
    }
    /// <p>The Git repository associated with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>
    pub fn default_code_repository(&self) -> std::option::Option<&str> {
        self.default_code_repository.as_deref()
    }
    /// <p>An array of up to three Git repositories associated with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>
    pub fn additional_code_repositories(&self) -> std::option::Option<&[std::string::String]> {
        self.additional_code_repositories.as_deref()
    }
    /// <p>Whether root access is enabled or disabled for users of the notebook instance.</p> <note>
    /// <p>Lifecycle configurations need root access to be able to set up a notebook instance. Because of this, lifecycle configurations associated with a notebook instance always run with root access even if you disable root access for users.</p>
    /// </note>
    pub fn root_access(&self) -> std::option::Option<&crate::model::RootAccess> {
        self.root_access.as_ref()
    }
    /// <p>The platform identifier of the notebook instance runtime environment.</p>
    pub fn platform_identifier(&self) -> std::option::Option<&str> {
        self.platform_identifier.as_deref()
    }
}
impl std::fmt::Debug for DescribeNotebookInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeNotebookInstanceOutput");
        formatter.field("notebook_instance_arn", &self.notebook_instance_arn);
        formatter.field("notebook_instance_name", &self.notebook_instance_name);
        formatter.field("notebook_instance_status", &self.notebook_instance_status);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("url", &self.url);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("security_groups", &self.security_groups);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("network_interface_id", &self.network_interface_id);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("creation_time", &self.creation_time);
        formatter.field(
            "notebook_instance_lifecycle_config_name",
            &self.notebook_instance_lifecycle_config_name,
        );
        formatter.field("direct_internet_access", &self.direct_internet_access);
        formatter.field("volume_size_in_gb", &self.volume_size_in_gb);
        formatter.field("accelerator_types", &self.accelerator_types);
        formatter.field("default_code_repository", &self.default_code_repository);
        formatter.field(
            "additional_code_repositories",
            &self.additional_code_repositories,
        );
        formatter.field("root_access", &self.root_access);
        formatter.field("platform_identifier", &self.platform_identifier);
        formatter.finish()
    }
}
/// See [`DescribeNotebookInstanceOutput`](crate::output::DescribeNotebookInstanceOutput)
pub mod describe_notebook_instance_output {
    /// A builder for [`DescribeNotebookInstanceOutput`](crate::output::DescribeNotebookInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notebook_instance_arn: std::option::Option<std::string::String>,
        pub(crate) notebook_instance_name: std::option::Option<std::string::String>,
        pub(crate) notebook_instance_status:
            std::option::Option<crate::model::NotebookInstanceStatus>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<crate::model::InstanceType>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) network_interface_id: std::option::Option<std::string::String>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) notebook_instance_lifecycle_config_name:
            std::option::Option<std::string::String>,
        pub(crate) direct_internet_access: std::option::Option<crate::model::DirectInternetAccess>,
        pub(crate) volume_size_in_gb: std::option::Option<i32>,
        pub(crate) accelerator_types:
            std::option::Option<std::vec::Vec<crate::model::NotebookInstanceAcceleratorType>>,
        pub(crate) default_code_repository: std::option::Option<std::string::String>,
        pub(crate) additional_code_repositories:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) root_access: std::option::Option<crate::model::RootAccess>,
        pub(crate) platform_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the notebook instance.</p>
        pub fn notebook_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.notebook_instance_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the notebook instance.</p>
        pub fn set_notebook_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notebook_instance_arn = input;
            self
        }
        /// <p>The name of the Amazon SageMaker notebook instance. </p>
        pub fn notebook_instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.notebook_instance_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon SageMaker notebook instance. </p>
        pub fn set_notebook_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notebook_instance_name = input;
            self
        }
        /// <p>The status of the notebook instance.</p>
        pub fn notebook_instance_status(
            mut self,
            input: crate::model::NotebookInstanceStatus,
        ) -> Self {
            self.notebook_instance_status = Some(input);
            self
        }
        /// <p>The status of the notebook instance.</p>
        pub fn set_notebook_instance_status(
            mut self,
            input: std::option::Option<crate::model::NotebookInstanceStatus>,
        ) -> Self {
            self.notebook_instance_status = input;
            self
        }
        /// <p>If status is <code>Failed</code>, the reason it failed.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If status is <code>Failed</code>, the reason it failed.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The URL that you use to connect to the Jupyter notebook that is running in your notebook instance. </p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The URL that you use to connect to the Jupyter notebook that is running in your notebook instance. </p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// <p>The type of ML compute instance running on the notebook instance.</p>
        pub fn instance_type(mut self, input: crate::model::InstanceType) -> Self {
            self.instance_type = Some(input);
            self
        }
        /// <p>The type of ML compute instance running on the notebook instance.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<crate::model::InstanceType>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The ID of the VPC subnet.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC subnet.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>The IDs of the VPC security groups.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>The IDs of the VPC security groups.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role associated with the instance. </p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role associated with the instance. </p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The Amazon Web Services KMS key ID Amazon SageMaker uses to encrypt data when storing it on the ML storage volume attached to the instance. </p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services KMS key ID Amazon SageMaker uses to encrypt data when storing it on the ML storage volume attached to the instance. </p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The network interface IDs that Amazon SageMaker created at the time of creating the instance. </p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_interface_id = Some(input.into());
            self
        }
        /// <p>The network interface IDs that Amazon SageMaker created at the time of creating the instance. </p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_interface_id = input;
            self
        }
        /// <p>A timestamp. Use this parameter to retrieve the time when the notebook instance was last modified. </p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>A timestamp. Use this parameter to retrieve the time when the notebook instance was last modified. </p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>A timestamp. Use this parameter to return the time when the notebook instance was created</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A timestamp. Use this parameter to return the time when the notebook instance was created</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>Returns the name of a notebook instance lifecycle configuration.</p>
        /// <p>For information about notebook instance lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a> </p>
        pub fn notebook_instance_lifecycle_config_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.notebook_instance_lifecycle_config_name = Some(input.into());
            self
        }
        /// <p>Returns the name of a notebook instance lifecycle configuration.</p>
        /// <p>For information about notebook instance lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a> </p>
        pub fn set_notebook_instance_lifecycle_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notebook_instance_lifecycle_config_name = input;
            self
        }
        /// <p>Describes whether Amazon SageMaker provides internet access to the notebook instance. If this value is set to <i>Disabled</i>, the notebook instance does not have internet access, and cannot connect to Amazon SageMaker training and endpoint services.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access">Notebook Instances Are Internet-Enabled by Default</a>.</p>
        pub fn direct_internet_access(mut self, input: crate::model::DirectInternetAccess) -> Self {
            self.direct_internet_access = Some(input);
            self
        }
        /// <p>Describes whether Amazon SageMaker provides internet access to the notebook instance. If this value is set to <i>Disabled</i>, the notebook instance does not have internet access, and cannot connect to Amazon SageMaker training and endpoint services.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access">Notebook Instances Are Internet-Enabled by Default</a>.</p>
        pub fn set_direct_internet_access(
            mut self,
            input: std::option::Option<crate::model::DirectInternetAccess>,
        ) -> Self {
            self.direct_internet_access = input;
            self
        }
        /// <p>The size, in GB, of the ML storage volume attached to the notebook instance.</p>
        pub fn volume_size_in_gb(mut self, input: i32) -> Self {
            self.volume_size_in_gb = Some(input);
            self
        }
        /// <p>The size, in GB, of the ML storage volume attached to the notebook instance.</p>
        pub fn set_volume_size_in_gb(mut self, input: std::option::Option<i32>) -> Self {
            self.volume_size_in_gb = input;
            self
        }
        /// Appends an item to `accelerator_types`.
        ///
        /// To override the contents of this collection use [`set_accelerator_types`](Self::set_accelerator_types).
        ///
        /// <p>A list of the Elastic Inference (EI) instance types associated with this notebook instance. Currently only one EI instance type can be associated with a notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.</p>
        pub fn accelerator_types(
            mut self,
            input: crate::model::NotebookInstanceAcceleratorType,
        ) -> Self {
            let mut v = self.accelerator_types.unwrap_or_default();
            v.push(input);
            self.accelerator_types = Some(v);
            self
        }
        /// <p>A list of the Elastic Inference (EI) instance types associated with this notebook instance. Currently only one EI instance type can be associated with a notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.</p>
        pub fn set_accelerator_types(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::NotebookInstanceAcceleratorType>,
            >,
        ) -> Self {
            self.accelerator_types = input;
            self
        }
        /// <p>The Git repository associated with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>
        pub fn default_code_repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_code_repository = Some(input.into());
            self
        }
        /// <p>The Git repository associated with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>
        pub fn set_default_code_repository(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_code_repository = input;
            self
        }
        /// Appends an item to `additional_code_repositories`.
        ///
        /// To override the contents of this collection use [`set_additional_code_repositories`](Self::set_additional_code_repositories).
        ///
        /// <p>An array of up to three Git repositories associated with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>
        pub fn additional_code_repositories(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.additional_code_repositories.unwrap_or_default();
            v.push(input.into());
            self.additional_code_repositories = Some(v);
            self
        }
        /// <p>An array of up to three Git repositories associated with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>
        pub fn set_additional_code_repositories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.additional_code_repositories = input;
            self
        }
        /// <p>Whether root access is enabled or disabled for users of the notebook instance.</p> <note>
        /// <p>Lifecycle configurations need root access to be able to set up a notebook instance. Because of this, lifecycle configurations associated with a notebook instance always run with root access even if you disable root access for users.</p>
        /// </note>
        pub fn root_access(mut self, input: crate::model::RootAccess) -> Self {
            self.root_access = Some(input);
            self
        }
        /// <p>Whether root access is enabled or disabled for users of the notebook instance.</p> <note>
        /// <p>Lifecycle configurations need root access to be able to set up a notebook instance. Because of this, lifecycle configurations associated with a notebook instance always run with root access even if you disable root access for users.</p>
        /// </note>
        pub fn set_root_access(
            mut self,
            input: std::option::Option<crate::model::RootAccess>,
        ) -> Self {
            self.root_access = input;
            self
        }
        /// <p>The platform identifier of the notebook instance runtime environment.</p>
        pub fn platform_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_identifier = Some(input.into());
            self
        }
        /// <p>The platform identifier of the notebook instance runtime environment.</p>
        pub fn set_platform_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeNotebookInstanceOutput`](crate::output::DescribeNotebookInstanceOutput)
        pub fn build(self) -> crate::output::DescribeNotebookInstanceOutput {
            crate::output::DescribeNotebookInstanceOutput {
                notebook_instance_arn: self.notebook_instance_arn,
                notebook_instance_name: self.notebook_instance_name,
                notebook_instance_status: self.notebook_instance_status,
                failure_reason: self.failure_reason,
                url: self.url,
                instance_type: self.instance_type,
                subnet_id: self.subnet_id,
                security_groups: self.security_groups,
                role_arn: self.role_arn,
                kms_key_id: self.kms_key_id,
                network_interface_id: self.network_interface_id,
                last_modified_time: self.last_modified_time,
                creation_time: self.creation_time,
                notebook_instance_lifecycle_config_name: self
                    .notebook_instance_lifecycle_config_name,
                direct_internet_access: self.direct_internet_access,
                volume_size_in_gb: self.volume_size_in_gb,
                accelerator_types: self.accelerator_types,
                default_code_repository: self.default_code_repository,
                additional_code_repositories: self.additional_code_repositories,
                root_access: self.root_access,
                platform_identifier: self.platform_identifier,
            }
        }
    }
}
impl DescribeNotebookInstanceOutput {
    /// Creates a new builder-style object to manufacture [`DescribeNotebookInstanceOutput`](crate::output::DescribeNotebookInstanceOutput)
    pub fn builder() -> crate::output::describe_notebook_instance_output::Builder {
        crate::output::describe_notebook_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMonitoringScheduleOutput {
    /// <p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>
    pub monitoring_schedule_arn: std::option::Option<std::string::String>,
    /// <p>Name of the monitoring schedule.</p>
    pub monitoring_schedule_name: std::option::Option<std::string::String>,
    /// <p>The status of an monitoring job.</p>
    pub monitoring_schedule_status: std::option::Option<crate::model::ScheduleStatus>,
    /// <p>The type of the monitoring job that this schedule runs. This is one of the following values.</p>
    /// <ul>
    /// <li> <p> <code>DATA_QUALITY</code> - The schedule is for a data quality monitoring job.</p> </li>
    /// <li> <p> <code>MODEL_QUALITY</code> - The schedule is for a model quality monitoring job.</p> </li>
    /// <li> <p> <code>MODEL_BIAS</code> - The schedule is for a bias monitoring job.</p> </li>
    /// <li> <p> <code>MODEL_EXPLAINABILITY</code> - The schedule is for an explainability monitoring job.</p> </li>
    /// </ul>
    pub monitoring_type: std::option::Option<crate::model::MonitoringType>,
    /// <p>A string, up to one KB in size, that contains the reason a monitoring job failed, if it failed.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The time at which the monitoring job was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time at which the monitoring job was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The configuration object that specifies the monitoring schedule and defines the monitoring job.</p>
    pub monitoring_schedule_config: std::option::Option<crate::model::MonitoringScheduleConfig>,
    /// <p> The name of the endpoint for the monitoring job.</p>
    pub endpoint_name: std::option::Option<std::string::String>,
    /// <p>Describes metadata on the last execution to run, if there was one.</p>
    pub last_monitoring_execution_summary:
        std::option::Option<crate::model::MonitoringExecutionSummary>,
}
impl DescribeMonitoringScheduleOutput {
    /// <p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>
    pub fn monitoring_schedule_arn(&self) -> std::option::Option<&str> {
        self.monitoring_schedule_arn.as_deref()
    }
    /// <p>Name of the monitoring schedule.</p>
    pub fn monitoring_schedule_name(&self) -> std::option::Option<&str> {
        self.monitoring_schedule_name.as_deref()
    }
    /// <p>The status of an monitoring job.</p>
    pub fn monitoring_schedule_status(&self) -> std::option::Option<&crate::model::ScheduleStatus> {
        self.monitoring_schedule_status.as_ref()
    }
    /// <p>The type of the monitoring job that this schedule runs. This is one of the following values.</p>
    /// <ul>
    /// <li> <p> <code>DATA_QUALITY</code> - The schedule is for a data quality monitoring job.</p> </li>
    /// <li> <p> <code>MODEL_QUALITY</code> - The schedule is for a model quality monitoring job.</p> </li>
    /// <li> <p> <code>MODEL_BIAS</code> - The schedule is for a bias monitoring job.</p> </li>
    /// <li> <p> <code>MODEL_EXPLAINABILITY</code> - The schedule is for an explainability monitoring job.</p> </li>
    /// </ul>
    pub fn monitoring_type(&self) -> std::option::Option<&crate::model::MonitoringType> {
        self.monitoring_type.as_ref()
    }
    /// <p>A string, up to one KB in size, that contains the reason a monitoring job failed, if it failed.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The time at which the monitoring job was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The time at which the monitoring job was last modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>The configuration object that specifies the monitoring schedule and defines the monitoring job.</p>
    pub fn monitoring_schedule_config(
        &self,
    ) -> std::option::Option<&crate::model::MonitoringScheduleConfig> {
        self.monitoring_schedule_config.as_ref()
    }
    /// <p> The name of the endpoint for the monitoring job.</p>
    pub fn endpoint_name(&self) -> std::option::Option<&str> {
        self.endpoint_name.as_deref()
    }
    /// <p>Describes metadata on the last execution to run, if there was one.</p>
    pub fn last_monitoring_execution_summary(
        &self,
    ) -> std::option::Option<&crate::model::MonitoringExecutionSummary> {
        self.last_monitoring_execution_summary.as_ref()
    }
}
impl std::fmt::Debug for DescribeMonitoringScheduleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMonitoringScheduleOutput");
        formatter.field("monitoring_schedule_arn", &self.monitoring_schedule_arn);
        formatter.field("monitoring_schedule_name", &self.monitoring_schedule_name);
        formatter.field(
            "monitoring_schedule_status",
            &self.monitoring_schedule_status,
        );
        formatter.field("monitoring_type", &self.monitoring_type);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field(
            "monitoring_schedule_config",
            &self.monitoring_schedule_config,
        );
        formatter.field("endpoint_name", &self.endpoint_name);
        formatter.field(
            "last_monitoring_execution_summary",
            &self.last_monitoring_execution_summary,
        );
        formatter.finish()
    }
}
/// See [`DescribeMonitoringScheduleOutput`](crate::output::DescribeMonitoringScheduleOutput)
pub mod describe_monitoring_schedule_output {
    /// A builder for [`DescribeMonitoringScheduleOutput`](crate::output::DescribeMonitoringScheduleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) monitoring_schedule_arn: std::option::Option<std::string::String>,
        pub(crate) monitoring_schedule_name: std::option::Option<std::string::String>,
        pub(crate) monitoring_schedule_status: std::option::Option<crate::model::ScheduleStatus>,
        pub(crate) monitoring_type: std::option::Option<crate::model::MonitoringType>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) monitoring_schedule_config:
            std::option::Option<crate::model::MonitoringScheduleConfig>,
        pub(crate) endpoint_name: std::option::Option<std::string::String>,
        pub(crate) last_monitoring_execution_summary:
            std::option::Option<crate::model::MonitoringExecutionSummary>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>
        pub fn monitoring_schedule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.monitoring_schedule_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>
        pub fn set_monitoring_schedule_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.monitoring_schedule_arn = input;
            self
        }
        /// <p>Name of the monitoring schedule.</p>
        pub fn monitoring_schedule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.monitoring_schedule_name = Some(input.into());
            self
        }
        /// <p>Name of the monitoring schedule.</p>
        pub fn set_monitoring_schedule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.monitoring_schedule_name = input;
            self
        }
        /// <p>The status of an monitoring job.</p>
        pub fn monitoring_schedule_status(mut self, input: crate::model::ScheduleStatus) -> Self {
            self.monitoring_schedule_status = Some(input);
            self
        }
        /// <p>The status of an monitoring job.</p>
        pub fn set_monitoring_schedule_status(
            mut self,
            input: std::option::Option<crate::model::ScheduleStatus>,
        ) -> Self {
            self.monitoring_schedule_status = input;
            self
        }
        /// <p>The type of the monitoring job that this schedule runs. This is one of the following values.</p>
        /// <ul>
        /// <li> <p> <code>DATA_QUALITY</code> - The schedule is for a data quality monitoring job.</p> </li>
        /// <li> <p> <code>MODEL_QUALITY</code> - The schedule is for a model quality monitoring job.</p> </li>
        /// <li> <p> <code>MODEL_BIAS</code> - The schedule is for a bias monitoring job.</p> </li>
        /// <li> <p> <code>MODEL_EXPLAINABILITY</code> - The schedule is for an explainability monitoring job.</p> </li>
        /// </ul>
        pub fn monitoring_type(mut self, input: crate::model::MonitoringType) -> Self {
            self.monitoring_type = Some(input);
            self
        }
        /// <p>The type of the monitoring job that this schedule runs. This is one of the following values.</p>
        /// <ul>
        /// <li> <p> <code>DATA_QUALITY</code> - The schedule is for a data quality monitoring job.</p> </li>
        /// <li> <p> <code>MODEL_QUALITY</code> - The schedule is for a model quality monitoring job.</p> </li>
        /// <li> <p> <code>MODEL_BIAS</code> - The schedule is for a bias monitoring job.</p> </li>
        /// <li> <p> <code>MODEL_EXPLAINABILITY</code> - The schedule is for an explainability monitoring job.</p> </li>
        /// </ul>
        pub fn set_monitoring_type(
            mut self,
            input: std::option::Option<crate::model::MonitoringType>,
        ) -> Self {
            self.monitoring_type = input;
            self
        }
        /// <p>A string, up to one KB in size, that contains the reason a monitoring job failed, if it failed.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>A string, up to one KB in size, that contains the reason a monitoring job failed, if it failed.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The time at which the monitoring job was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time at which the monitoring job was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time at which the monitoring job was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The time at which the monitoring job was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>The configuration object that specifies the monitoring schedule and defines the monitoring job.</p>
        pub fn monitoring_schedule_config(
            mut self,
            input: crate::model::MonitoringScheduleConfig,
        ) -> Self {
            self.monitoring_schedule_config = Some(input);
            self
        }
        /// <p>The configuration object that specifies the monitoring schedule and defines the monitoring job.</p>
        pub fn set_monitoring_schedule_config(
            mut self,
            input: std::option::Option<crate::model::MonitoringScheduleConfig>,
        ) -> Self {
            self.monitoring_schedule_config = input;
            self
        }
        /// <p> The name of the endpoint for the monitoring job.</p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_name = Some(input.into());
            self
        }
        /// <p> The name of the endpoint for the monitoring job.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_name = input;
            self
        }
        /// <p>Describes metadata on the last execution to run, if there was one.</p>
        pub fn last_monitoring_execution_summary(
            mut self,
            input: crate::model::MonitoringExecutionSummary,
        ) -> Self {
            self.last_monitoring_execution_summary = Some(input);
            self
        }
        /// <p>Describes metadata on the last execution to run, if there was one.</p>
        pub fn set_last_monitoring_execution_summary(
            mut self,
            input: std::option::Option<crate::model::MonitoringExecutionSummary>,
        ) -> Self {
            self.last_monitoring_execution_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMonitoringScheduleOutput`](crate::output::DescribeMonitoringScheduleOutput)
        pub fn build(self) -> crate::output::DescribeMonitoringScheduleOutput {
            crate::output::DescribeMonitoringScheduleOutput {
                monitoring_schedule_arn: self.monitoring_schedule_arn,
                monitoring_schedule_name: self.monitoring_schedule_name,
                monitoring_schedule_status: self.monitoring_schedule_status,
                monitoring_type: self.monitoring_type,
                failure_reason: self.failure_reason,
                creation_time: self.creation_time,
                last_modified_time: self.last_modified_time,
                monitoring_schedule_config: self.monitoring_schedule_config,
                endpoint_name: self.endpoint_name,
                last_monitoring_execution_summary: self.last_monitoring_execution_summary,
            }
        }
    }
}
impl DescribeMonitoringScheduleOutput {
    /// Creates a new builder-style object to manufacture [`DescribeMonitoringScheduleOutput`](crate::output::DescribeMonitoringScheduleOutput)
    pub fn builder() -> crate::output::describe_monitoring_schedule_output::Builder {
        crate::output::describe_monitoring_schedule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeModelQualityJobDefinitionOutput {
    /// <p>The Amazon Resource Name (ARN) of the model quality job.</p>
    pub job_definition_arn: std::option::Option<std::string::String>,
    /// <p>The name of the quality job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
    pub job_definition_name: std::option::Option<std::string::String>,
    /// <p>The time at which the model quality job was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The baseline configuration for a model quality job.</p>
    pub model_quality_baseline_config:
        std::option::Option<crate::model::ModelQualityBaselineConfig>,
    /// <p>Configures the model quality job to run a specified Docker container image.</p>
    pub model_quality_app_specification:
        std::option::Option<crate::model::ModelQualityAppSpecification>,
    /// <p>Inputs for the model quality job.</p>
    pub model_quality_job_input: std::option::Option<crate::model::ModelQualityJobInput>,
    /// <p>The output configuration for monitoring jobs.</p>
    pub model_quality_job_output_config: std::option::Option<crate::model::MonitoringOutputConfig>,
    /// <p>Identifies the resources to deploy for a monitoring job.</p>
    pub job_resources: std::option::Option<crate::model::MonitoringResources>,
    /// <p>Networking options for a model quality job.</p>
    pub network_config: std::option::Option<crate::model::MonitoringNetworkConfig>,
    /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
    pub stopping_condition: std::option::Option<crate::model::MonitoringStoppingCondition>,
}
impl DescribeModelQualityJobDefinitionOutput {
    /// <p>The Amazon Resource Name (ARN) of the model quality job.</p>
    pub fn job_definition_arn(&self) -> std::option::Option<&str> {
        self.job_definition_arn.as_deref()
    }
    /// <p>The name of the quality job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
    pub fn job_definition_name(&self) -> std::option::Option<&str> {
        self.job_definition_name.as_deref()
    }
    /// <p>The time at which the model quality job was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The baseline configuration for a model quality job.</p>
    pub fn model_quality_baseline_config(
        &self,
    ) -> std::option::Option<&crate::model::ModelQualityBaselineConfig> {
        self.model_quality_baseline_config.as_ref()
    }
    /// <p>Configures the model quality job to run a specified Docker container image.</p>
    pub fn model_quality_app_specification(
        &self,
    ) -> std::option::Option<&crate::model::ModelQualityAppSpecification> {
        self.model_quality_app_specification.as_ref()
    }
    /// <p>Inputs for the model quality job.</p>
    pub fn model_quality_job_input(
        &self,
    ) -> std::option::Option<&crate::model::ModelQualityJobInput> {
        self.model_quality_job_input.as_ref()
    }
    /// <p>The output configuration for monitoring jobs.</p>
    pub fn model_quality_job_output_config(
        &self,
    ) -> std::option::Option<&crate::model::MonitoringOutputConfig> {
        self.model_quality_job_output_config.as_ref()
    }
    /// <p>Identifies the resources to deploy for a monitoring job.</p>
    pub fn job_resources(&self) -> std::option::Option<&crate::model::MonitoringResources> {
        self.job_resources.as_ref()
    }
    /// <p>Networking options for a model quality job.</p>
    pub fn network_config(&self) -> std::option::Option<&crate::model::MonitoringNetworkConfig> {
        self.network_config.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
    pub fn stopping_condition(
        &self,
    ) -> std::option::Option<&crate::model::MonitoringStoppingCondition> {
        self.stopping_condition.as_ref()
    }
}
impl std::fmt::Debug for DescribeModelQualityJobDefinitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeModelQualityJobDefinitionOutput");
        formatter.field("job_definition_arn", &self.job_definition_arn);
        formatter.field("job_definition_name", &self.job_definition_name);
        formatter.field("creation_time", &self.creation_time);
        formatter.field(
            "model_quality_baseline_config",
            &self.model_quality_baseline_config,
        );
        formatter.field(
            "model_quality_app_specification",
            &self.model_quality_app_specification,
        );
        formatter.field("model_quality_job_input", &self.model_quality_job_input);
        formatter.field(
            "model_quality_job_output_config",
            &self.model_quality_job_output_config,
        );
        formatter.field("job_resources", &self.job_resources);
        formatter.field("network_config", &self.network_config);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("stopping_condition", &self.stopping_condition);
        formatter.finish()
    }
}
/// See [`DescribeModelQualityJobDefinitionOutput`](crate::output::DescribeModelQualityJobDefinitionOutput)
pub mod describe_model_quality_job_definition_output {
    /// A builder for [`DescribeModelQualityJobDefinitionOutput`](crate::output::DescribeModelQualityJobDefinitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_definition_arn: std::option::Option<std::string::String>,
        pub(crate) job_definition_name: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) model_quality_baseline_config:
            std::option::Option<crate::model::ModelQualityBaselineConfig>,
        pub(crate) model_quality_app_specification:
            std::option::Option<crate::model::ModelQualityAppSpecification>,
        pub(crate) model_quality_job_input: std::option::Option<crate::model::ModelQualityJobInput>,
        pub(crate) model_quality_job_output_config:
            std::option::Option<crate::model::MonitoringOutputConfig>,
        pub(crate) job_resources: std::option::Option<crate::model::MonitoringResources>,
        pub(crate) network_config: std::option::Option<crate::model::MonitoringNetworkConfig>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) stopping_condition:
            std::option::Option<crate::model::MonitoringStoppingCondition>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the model quality job.</p>
        pub fn job_definition_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_definition_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model quality job.</p>
        pub fn set_job_definition_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_definition_arn = input;
            self
        }
        /// <p>The name of the quality job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
        pub fn job_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_definition_name = Some(input.into());
            self
        }
        /// <p>The name of the quality job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
        pub fn set_job_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_definition_name = input;
            self
        }
        /// <p>The time at which the model quality job was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time at which the model quality job was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The baseline configuration for a model quality job.</p>
        pub fn model_quality_baseline_config(
            mut self,
            input: crate::model::ModelQualityBaselineConfig,
        ) -> Self {
            self.model_quality_baseline_config = Some(input);
            self
        }
        /// <p>The baseline configuration for a model quality job.</p>
        pub fn set_model_quality_baseline_config(
            mut self,
            input: std::option::Option<crate::model::ModelQualityBaselineConfig>,
        ) -> Self {
            self.model_quality_baseline_config = input;
            self
        }
        /// <p>Configures the model quality job to run a specified Docker container image.</p>
        pub fn model_quality_app_specification(
            mut self,
            input: crate::model::ModelQualityAppSpecification,
        ) -> Self {
            self.model_quality_app_specification = Some(input);
            self
        }
        /// <p>Configures the model quality job to run a specified Docker container image.</p>
        pub fn set_model_quality_app_specification(
            mut self,
            input: std::option::Option<crate::model::ModelQualityAppSpecification>,
        ) -> Self {
            self.model_quality_app_specification = input;
            self
        }
        /// <p>Inputs for the model quality job.</p>
        pub fn model_quality_job_input(
            mut self,
            input: crate::model::ModelQualityJobInput,
        ) -> Self {
            self.model_quality_job_input = Some(input);
            self
        }
        /// <p>Inputs for the model quality job.</p>
        pub fn set_model_quality_job_input(
            mut self,
            input: std::option::Option<crate::model::ModelQualityJobInput>,
        ) -> Self {
            self.model_quality_job_input = input;
            self
        }
        /// <p>The output configuration for monitoring jobs.</p>
        pub fn model_quality_job_output_config(
            mut self,
            input: crate::model::MonitoringOutputConfig,
        ) -> Self {
            self.model_quality_job_output_config = Some(input);
            self
        }
        /// <p>The output configuration for monitoring jobs.</p>
        pub fn set_model_quality_job_output_config(
            mut self,
            input: std::option::Option<crate::model::MonitoringOutputConfig>,
        ) -> Self {
            self.model_quality_job_output_config = input;
            self
        }
        /// <p>Identifies the resources to deploy for a monitoring job.</p>
        pub fn job_resources(mut self, input: crate::model::MonitoringResources) -> Self {
            self.job_resources = Some(input);
            self
        }
        /// <p>Identifies the resources to deploy for a monitoring job.</p>
        pub fn set_job_resources(
            mut self,
            input: std::option::Option<crate::model::MonitoringResources>,
        ) -> Self {
            self.job_resources = input;
            self
        }
        /// <p>Networking options for a model quality job.</p>
        pub fn network_config(mut self, input: crate::model::MonitoringNetworkConfig) -> Self {
            self.network_config = Some(input);
            self
        }
        /// <p>Networking options for a model quality job.</p>
        pub fn set_network_config(
            mut self,
            input: std::option::Option<crate::model::MonitoringNetworkConfig>,
        ) -> Self {
            self.network_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
        pub fn stopping_condition(
            mut self,
            input: crate::model::MonitoringStoppingCondition,
        ) -> Self {
            self.stopping_condition = Some(input);
            self
        }
        /// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
        pub fn set_stopping_condition(
            mut self,
            input: std::option::Option<crate::model::MonitoringStoppingCondition>,
        ) -> Self {
            self.stopping_condition = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeModelQualityJobDefinitionOutput`](crate::output::DescribeModelQualityJobDefinitionOutput)
        pub fn build(self) -> crate::output::DescribeModelQualityJobDefinitionOutput {
            crate::output::DescribeModelQualityJobDefinitionOutput {
                job_definition_arn: self.job_definition_arn,
                job_definition_name: self.job_definition_name,
                creation_time: self.creation_time,
                model_quality_baseline_config: self.model_quality_baseline_config,
                model_quality_app_specification: self.model_quality_app_specification,
                model_quality_job_input: self.model_quality_job_input,
                model_quality_job_output_config: self.model_quality_job_output_config,
                job_resources: self.job_resources,
                network_config: self.network_config,
                role_arn: self.role_arn,
                stopping_condition: self.stopping_condition,
            }
        }
    }
}
impl DescribeModelQualityJobDefinitionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeModelQualityJobDefinitionOutput`](crate::output::DescribeModelQualityJobDefinitionOutput)
    pub fn builder() -> crate::output::describe_model_quality_job_definition_output::Builder {
        crate::output::describe_model_quality_job_definition_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeModelPackageGroupOutput {
    /// <p>The name of the model group.</p>
    pub model_package_group_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the model group.</p>
    pub model_package_group_arn: std::option::Option<std::string::String>,
    /// <p>A description of the model group.</p>
    pub model_package_group_description: std::option::Option<std::string::String>,
    /// <p>The time that the model group was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
    pub created_by: std::option::Option<crate::model::UserContext>,
    /// <p>The status of the model group.</p>
    pub model_package_group_status: std::option::Option<crate::model::ModelPackageGroupStatus>,
}
impl DescribeModelPackageGroupOutput {
    /// <p>The name of the model group.</p>
    pub fn model_package_group_name(&self) -> std::option::Option<&str> {
        self.model_package_group_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the model group.</p>
    pub fn model_package_group_arn(&self) -> std::option::Option<&str> {
        self.model_package_group_arn.as_deref()
    }
    /// <p>A description of the model group.</p>
    pub fn model_package_group_description(&self) -> std::option::Option<&str> {
        self.model_package_group_description.as_deref()
    }
    /// <p>The time that the model group was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
    pub fn created_by(&self) -> std::option::Option<&crate::model::UserContext> {
        self.created_by.as_ref()
    }
    /// <p>The status of the model group.</p>
    pub fn model_package_group_status(
        &self,
    ) -> std::option::Option<&crate::model::ModelPackageGroupStatus> {
        self.model_package_group_status.as_ref()
    }
}
impl std::fmt::Debug for DescribeModelPackageGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeModelPackageGroupOutput");
        formatter.field("model_package_group_name", &self.model_package_group_name);
        formatter.field("model_package_group_arn", &self.model_package_group_arn);
        formatter.field(
            "model_package_group_description",
            &self.model_package_group_description,
        );
        formatter.field("creation_time", &self.creation_time);
        formatter.field("created_by", &self.created_by);
        formatter.field(
            "model_package_group_status",
            &self.model_package_group_status,
        );
        formatter.finish()
    }
}
/// See [`DescribeModelPackageGroupOutput`](crate::output::DescribeModelPackageGroupOutput)
pub mod describe_model_package_group_output {
    /// A builder for [`DescribeModelPackageGroupOutput`](crate::output::DescribeModelPackageGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_package_group_name: std::option::Option<std::string::String>,
        pub(crate) model_package_group_arn: std::option::Option<std::string::String>,
        pub(crate) model_package_group_description: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_by: std::option::Option<crate::model::UserContext>,
        pub(crate) model_package_group_status:
            std::option::Option<crate::model::ModelPackageGroupStatus>,
    }
    impl Builder {
        /// <p>The name of the model group.</p>
        pub fn model_package_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_package_group_name = Some(input.into());
            self
        }
        /// <p>The name of the model group.</p>
        pub fn set_model_package_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_package_group_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model group.</p>
        pub fn model_package_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_package_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model group.</p>
        pub fn set_model_package_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_package_group_arn = input;
            self
        }
        /// <p>A description of the model group.</p>
        pub fn model_package_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.model_package_group_description = Some(input.into());
            self
        }
        /// <p>A description of the model group.</p>
        pub fn set_model_package_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_package_group_description = input;
            self
        }
        /// <p>The time that the model group was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the model group was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
        pub fn created_by(mut self, input: crate::model::UserContext) -> Self {
            self.created_by = Some(input);
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
        pub fn set_created_by(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The status of the model group.</p>
        pub fn model_package_group_status(
            mut self,
            input: crate::model::ModelPackageGroupStatus,
        ) -> Self {
            self.model_package_group_status = Some(input);
            self
        }
        /// <p>The status of the model group.</p>
        pub fn set_model_package_group_status(
            mut self,
            input: std::option::Option<crate::model::ModelPackageGroupStatus>,
        ) -> Self {
            self.model_package_group_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeModelPackageGroupOutput`](crate::output::DescribeModelPackageGroupOutput)
        pub fn build(self) -> crate::output::DescribeModelPackageGroupOutput {
            crate::output::DescribeModelPackageGroupOutput {
                model_package_group_name: self.model_package_group_name,
                model_package_group_arn: self.model_package_group_arn,
                model_package_group_description: self.model_package_group_description,
                creation_time: self.creation_time,
                created_by: self.created_by,
                model_package_group_status: self.model_package_group_status,
            }
        }
    }
}
impl DescribeModelPackageGroupOutput {
    /// Creates a new builder-style object to manufacture [`DescribeModelPackageGroupOutput`](crate::output::DescribeModelPackageGroupOutput)
    pub fn builder() -> crate::output::describe_model_package_group_output::Builder {
        crate::output::describe_model_package_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeModelPackageOutput {
    /// <p>The name of the model package being described.</p>
    pub model_package_name: std::option::Option<std::string::String>,
    /// <p>If the model is a versioned model, the name of the model group that the versioned model belongs to.</p>
    pub model_package_group_name: std::option::Option<std::string::String>,
    /// <p>The version of the model package.</p>
    pub model_package_version: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) of the model package.</p>
    pub model_package_arn: std::option::Option<std::string::String>,
    /// <p>A brief summary of the model package.</p>
    pub model_package_description: std::option::Option<std::string::String>,
    /// <p>A timestamp specifying when the model package was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Details about inference jobs that can be run with models based on this model package.</p>
    pub inference_specification: std::option::Option<crate::model::InferenceSpecification>,
    /// <p>Details about the algorithm that was used to create the model package.</p>
    pub source_algorithm_specification:
        std::option::Option<crate::model::SourceAlgorithmSpecification>,
    /// <p>Configurations for one or more transform jobs that SageMaker runs to test the model package.</p>
    pub validation_specification:
        std::option::Option<crate::model::ModelPackageValidationSpecification>,
    /// <p>The current status of the model package.</p>
    pub model_package_status: std::option::Option<crate::model::ModelPackageStatus>,
    /// <p>Details about the current status of the model package.</p>
    pub model_package_status_details: std::option::Option<crate::model::ModelPackageStatusDetails>,
    /// <p>Whether the model package is certified for listing on Amazon Web Services Marketplace.</p>
    pub certify_for_marketplace: bool,
    /// <p>The approval status of the model package.</p>
    pub model_approval_status: std::option::Option<crate::model::ModelApprovalStatus>,
    /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
    pub created_by: std::option::Option<crate::model::UserContext>,
    /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
    pub metadata_properties: std::option::Option<crate::model::MetadataProperties>,
    /// <p>Metrics for the model.</p>
    pub model_metrics: std::option::Option<crate::model::ModelMetrics>,
    /// <p>The last time the model package was modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
    pub last_modified_by: std::option::Option<crate::model::UserContext>,
    /// <p>A description provided for the model approval.</p>
    pub approval_description: std::option::Option<std::string::String>,
    /// <p>The metadata properties associated with the model package versions.</p>
    pub customer_metadata_properties:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Represents the drift check baselines that can be used when the model monitor is set using the model package. For more information, see the topic on <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-quality-clarify-baseline-lifecycle.html#pipelines-quality-clarify-baseline-drift-detection">Drift Detection against Previous Baselines in SageMaker Pipelines</a> in the <i>Amazon SageMaker Developer Guide</i>. </p>
    pub drift_check_baselines: std::option::Option<crate::model::DriftCheckBaselines>,
    /// <p>The machine learning domain of the model package you specified. Common machine learning domains include computer vision and natural language processing.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>The machine learning task you specified that your model package accomplishes. Common machine learning tasks include object detection and image classification.</p>
    pub task: std::option::Option<std::string::String>,
    /// <p>The Amazon Simple Storage Service (Amazon S3) path where the sample payload are stored. This path points to a single gzip compressed tar archive (.tar.gz suffix).</p>
    pub sample_payload_url: std::option::Option<std::string::String>,
    /// <p>An array of additional Inference Specification objects. Each additional Inference Specification specifies artifacts based on this model package that can be used on inference endpoints. Generally used with SageMaker Neo to store the compiled artifacts.</p>
    pub additional_inference_specifications: std::option::Option<
        std::vec::Vec<crate::model::AdditionalInferenceSpecificationDefinition>,
    >,
}
impl DescribeModelPackageOutput {
    /// <p>The name of the model package being described.</p>
    pub fn model_package_name(&self) -> std::option::Option<&str> {
        self.model_package_name.as_deref()
    }
    /// <p>If the model is a versioned model, the name of the model group that the versioned model belongs to.</p>
    pub fn model_package_group_name(&self) -> std::option::Option<&str> {
        self.model_package_group_name.as_deref()
    }
    /// <p>The version of the model package.</p>
    pub fn model_package_version(&self) -> std::option::Option<i32> {
        self.model_package_version
    }
    /// <p>The Amazon Resource Name (ARN) of the model package.</p>
    pub fn model_package_arn(&self) -> std::option::Option<&str> {
        self.model_package_arn.as_deref()
    }
    /// <p>A brief summary of the model package.</p>
    pub fn model_package_description(&self) -> std::option::Option<&str> {
        self.model_package_description.as_deref()
    }
    /// <p>A timestamp specifying when the model package was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>Details about inference jobs that can be run with models based on this model package.</p>
    pub fn inference_specification(
        &self,
    ) -> std::option::Option<&crate::model::InferenceSpecification> {
        self.inference_specification.as_ref()
    }
    /// <p>Details about the algorithm that was used to create the model package.</p>
    pub fn source_algorithm_specification(
        &self,
    ) -> std::option::Option<&crate::model::SourceAlgorithmSpecification> {
        self.source_algorithm_specification.as_ref()
    }
    /// <p>Configurations for one or more transform jobs that SageMaker runs to test the model package.</p>
    pub fn validation_specification(
        &self,
    ) -> std::option::Option<&crate::model::ModelPackageValidationSpecification> {
        self.validation_specification.as_ref()
    }
    /// <p>The current status of the model package.</p>
    pub fn model_package_status(&self) -> std::option::Option<&crate::model::ModelPackageStatus> {
        self.model_package_status.as_ref()
    }
    /// <p>Details about the current status of the model package.</p>
    pub fn model_package_status_details(
        &self,
    ) -> std::option::Option<&crate::model::ModelPackageStatusDetails> {
        self.model_package_status_details.as_ref()
    }
    /// <p>Whether the model package is certified for listing on Amazon Web Services Marketplace.</p>
    pub fn certify_for_marketplace(&self) -> bool {
        self.certify_for_marketplace
    }
    /// <p>The approval status of the model package.</p>
    pub fn model_approval_status(&self) -> std::option::Option<&crate::model::ModelApprovalStatus> {
        self.model_approval_status.as_ref()
    }
    /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
    pub fn created_by(&self) -> std::option::Option<&crate::model::UserContext> {
        self.created_by.as_ref()
    }
    /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
    pub fn metadata_properties(&self) -> std::option::Option<&crate::model::MetadataProperties> {
        self.metadata_properties.as_ref()
    }
    /// <p>Metrics for the model.</p>
    pub fn model_metrics(&self) -> std::option::Option<&crate::model::ModelMetrics> {
        self.model_metrics.as_ref()
    }
    /// <p>The last time the model package was modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
    pub fn last_modified_by(&self) -> std::option::Option<&crate::model::UserContext> {
        self.last_modified_by.as_ref()
    }
    /// <p>A description provided for the model approval.</p>
    pub fn approval_description(&self) -> std::option::Option<&str> {
        self.approval_description.as_deref()
    }
    /// <p>The metadata properties associated with the model package versions.</p>
    pub fn customer_metadata_properties(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.customer_metadata_properties.as_ref()
    }
    /// <p>Represents the drift check baselines that can be used when the model monitor is set using the model package. For more information, see the topic on <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-quality-clarify-baseline-lifecycle.html#pipelines-quality-clarify-baseline-drift-detection">Drift Detection against Previous Baselines in SageMaker Pipelines</a> in the <i>Amazon SageMaker Developer Guide</i>. </p>
    pub fn drift_check_baselines(&self) -> std::option::Option<&crate::model::DriftCheckBaselines> {
        self.drift_check_baselines.as_ref()
    }
    /// <p>The machine learning domain of the model package you specified. Common machine learning domains include computer vision and natural language processing.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>The machine learning task you specified that your model package accomplishes. Common machine learning tasks include object detection and image classification.</p>
    pub fn task(&self) -> std::option::Option<&str> {
        self.task.as_deref()
    }
    /// <p>The Amazon Simple Storage Service (Amazon S3) path where the sample payload are stored. This path points to a single gzip compressed tar archive (.tar.gz suffix).</p>
    pub fn sample_payload_url(&self) -> std::option::Option<&str> {
        self.sample_payload_url.as_deref()
    }
    /// <p>An array of additional Inference Specification objects. Each additional Inference Specification specifies artifacts based on this model package that can be used on inference endpoints. Generally used with SageMaker Neo to store the compiled artifacts.</p>
    pub fn additional_inference_specifications(
        &self,
    ) -> std::option::Option<&[crate::model::AdditionalInferenceSpecificationDefinition]> {
        self.additional_inference_specifications.as_deref()
    }
}
impl std::fmt::Debug for DescribeModelPackageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeModelPackageOutput");
        formatter.field("model_package_name", &self.model_package_name);
        formatter.field("model_package_group_name", &self.model_package_group_name);
        formatter.field("model_package_version", &self.model_package_version);
        formatter.field("model_package_arn", &self.model_package_arn);
        formatter.field("model_package_description", &self.model_package_description);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("inference_specification", &self.inference_specification);
        formatter.field(
            "source_algorithm_specification",
            &self.source_algorithm_specification,
        );
        formatter.field("validation_specification", &self.validation_specification);
        formatter.field("model_package_status", &self.model_package_status);
        formatter.field(
            "model_package_status_details",
            &self.model_package_status_details,
        );
        formatter.field("certify_for_marketplace", &self.certify_for_marketplace);
        formatter.field("model_approval_status", &self.model_approval_status);
        formatter.field("created_by", &self.created_by);
        formatter.field("metadata_properties", &self.metadata_properties);
        formatter.field("model_metrics", &self.model_metrics);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("approval_description", &self.approval_description);
        formatter.field(
            "customer_metadata_properties",
            &self.customer_metadata_properties,
        );
        formatter.field("drift_check_baselines", &self.drift_check_baselines);
        formatter.field("domain", &self.domain);
        formatter.field("task", &self.task);
        formatter.field("sample_payload_url", &self.sample_payload_url);
        formatter.field(
            "additional_inference_specifications",
            &self.additional_inference_specifications,
        );
        formatter.finish()
    }
}
/// See [`DescribeModelPackageOutput`](crate::output::DescribeModelPackageOutput)
pub mod describe_model_package_output {
    /// A builder for [`DescribeModelPackageOutput`](crate::output::DescribeModelPackageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_package_name: std::option::Option<std::string::String>,
        pub(crate) model_package_group_name: std::option::Option<std::string::String>,
        pub(crate) model_package_version: std::option::Option<i32>,
        pub(crate) model_package_arn: std::option::Option<std::string::String>,
        pub(crate) model_package_description: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) inference_specification:
            std::option::Option<crate::model::InferenceSpecification>,
        pub(crate) source_algorithm_specification:
            std::option::Option<crate::model::SourceAlgorithmSpecification>,
        pub(crate) validation_specification:
            std::option::Option<crate::model::ModelPackageValidationSpecification>,
        pub(crate) model_package_status: std::option::Option<crate::model::ModelPackageStatus>,
        pub(crate) model_package_status_details:
            std::option::Option<crate::model::ModelPackageStatusDetails>,
        pub(crate) certify_for_marketplace: std::option::Option<bool>,
        pub(crate) model_approval_status: std::option::Option<crate::model::ModelApprovalStatus>,
        pub(crate) created_by: std::option::Option<crate::model::UserContext>,
        pub(crate) metadata_properties: std::option::Option<crate::model::MetadataProperties>,
        pub(crate) model_metrics: std::option::Option<crate::model::ModelMetrics>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_by: std::option::Option<crate::model::UserContext>,
        pub(crate) approval_description: std::option::Option<std::string::String>,
        pub(crate) customer_metadata_properties: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) drift_check_baselines: std::option::Option<crate::model::DriftCheckBaselines>,
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) task: std::option::Option<std::string::String>,
        pub(crate) sample_payload_url: std::option::Option<std::string::String>,
        pub(crate) additional_inference_specifications: std::option::Option<
            std::vec::Vec<crate::model::AdditionalInferenceSpecificationDefinition>,
        >,
    }
    impl Builder {
        /// <p>The name of the model package being described.</p>
        pub fn model_package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_package_name = Some(input.into());
            self
        }
        /// <p>The name of the model package being described.</p>
        pub fn set_model_package_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_package_name = input;
            self
        }
        /// <p>If the model is a versioned model, the name of the model group that the versioned model belongs to.</p>
        pub fn model_package_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_package_group_name = Some(input.into());
            self
        }
        /// <p>If the model is a versioned model, the name of the model group that the versioned model belongs to.</p>
        pub fn set_model_package_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_package_group_name = input;
            self
        }
        /// <p>The version of the model package.</p>
        pub fn model_package_version(mut self, input: i32) -> Self {
            self.model_package_version = Some(input);
            self
        }
        /// <p>The version of the model package.</p>
        pub fn set_model_package_version(mut self, input: std::option::Option<i32>) -> Self {
            self.model_package_version = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model package.</p>
        pub fn model_package_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_package_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model package.</p>
        pub fn set_model_package_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_package_arn = input;
            self
        }
        /// <p>A brief summary of the model package.</p>
        pub fn model_package_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_package_description = Some(input.into());
            self
        }
        /// <p>A brief summary of the model package.</p>
        pub fn set_model_package_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_package_description = input;
            self
        }
        /// <p>A timestamp specifying when the model package was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A timestamp specifying when the model package was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>Details about inference jobs that can be run with models based on this model package.</p>
        pub fn inference_specification(
            mut self,
            input: crate::model::InferenceSpecification,
        ) -> Self {
            self.inference_specification = Some(input);
            self
        }
        /// <p>Details about inference jobs that can be run with models based on this model package.</p>
        pub fn set_inference_specification(
            mut self,
            input: std::option::Option<crate::model::InferenceSpecification>,
        ) -> Self {
            self.inference_specification = input;
            self
        }
        /// <p>Details about the algorithm that was used to create the model package.</p>
        pub fn source_algorithm_specification(
            mut self,
            input: crate::model::SourceAlgorithmSpecification,
        ) -> Self {
            self.source_algorithm_specification = Some(input);
            self
        }
        /// <p>Details about the algorithm that was used to create the model package.</p>
        pub fn set_source_algorithm_specification(
            mut self,
            input: std::option::Option<crate::model::SourceAlgorithmSpecification>,
        ) -> Self {
            self.source_algorithm_specification = input;
            self
        }
        /// <p>Configurations for one or more transform jobs that SageMaker runs to test the model package.</p>
        pub fn validation_specification(
            mut self,
            input: crate::model::ModelPackageValidationSpecification,
        ) -> Self {
            self.validation_specification = Some(input);
            self
        }
        /// <p>Configurations for one or more transform jobs that SageMaker runs to test the model package.</p>
        pub fn set_validation_specification(
            mut self,
            input: std::option::Option<crate::model::ModelPackageValidationSpecification>,
        ) -> Self {
            self.validation_specification = input;
            self
        }
        /// <p>The current status of the model package.</p>
        pub fn model_package_status(mut self, input: crate::model::ModelPackageStatus) -> Self {
            self.model_package_status = Some(input);
            self
        }
        /// <p>The current status of the model package.</p>
        pub fn set_model_package_status(
            mut self,
            input: std::option::Option<crate::model::ModelPackageStatus>,
        ) -> Self {
            self.model_package_status = input;
            self
        }
        /// <p>Details about the current status of the model package.</p>
        pub fn model_package_status_details(
            mut self,
            input: crate::model::ModelPackageStatusDetails,
        ) -> Self {
            self.model_package_status_details = Some(input);
            self
        }
        /// <p>Details about the current status of the model package.</p>
        pub fn set_model_package_status_details(
            mut self,
            input: std::option::Option<crate::model::ModelPackageStatusDetails>,
        ) -> Self {
            self.model_package_status_details = input;
            self
        }
        /// <p>Whether the model package is certified for listing on Amazon Web Services Marketplace.</p>
        pub fn certify_for_marketplace(mut self, input: bool) -> Self {
            self.certify_for_marketplace = Some(input);
            self
        }
        /// <p>Whether the model package is certified for listing on Amazon Web Services Marketplace.</p>
        pub fn set_certify_for_marketplace(mut self, input: std::option::Option<bool>) -> Self {
            self.certify_for_marketplace = input;
            self
        }
        /// <p>The approval status of the model package.</p>
        pub fn model_approval_status(mut self, input: crate::model::ModelApprovalStatus) -> Self {
            self.model_approval_status = Some(input);
            self
        }
        /// <p>The approval status of the model package.</p>
        pub fn set_model_approval_status(
            mut self,
            input: std::option::Option<crate::model::ModelApprovalStatus>,
        ) -> Self {
            self.model_approval_status = input;
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
        pub fn created_by(mut self, input: crate::model::UserContext) -> Self {
            self.created_by = Some(input);
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
        pub fn set_created_by(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.created_by = input;
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn metadata_properties(mut self, input: crate::model::MetadataProperties) -> Self {
            self.metadata_properties = Some(input);
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn set_metadata_properties(
            mut self,
            input: std::option::Option<crate::model::MetadataProperties>,
        ) -> Self {
            self.metadata_properties = input;
            self
        }
        /// <p>Metrics for the model.</p>
        pub fn model_metrics(mut self, input: crate::model::ModelMetrics) -> Self {
            self.model_metrics = Some(input);
            self
        }
        /// <p>Metrics for the model.</p>
        pub fn set_model_metrics(
            mut self,
            input: std::option::Option<crate::model::ModelMetrics>,
        ) -> Self {
            self.model_metrics = input;
            self
        }
        /// <p>The last time the model package was modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The last time the model package was modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
        pub fn last_modified_by(mut self, input: crate::model::UserContext) -> Self {
            self.last_modified_by = Some(input);
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// <p>A description provided for the model approval.</p>
        pub fn approval_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.approval_description = Some(input.into());
            self
        }
        /// <p>A description provided for the model approval.</p>
        pub fn set_approval_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_description = input;
            self
        }
        /// Adds a key-value pair to `customer_metadata_properties`.
        ///
        /// To override the contents of this collection use [`set_customer_metadata_properties`](Self::set_customer_metadata_properties).
        ///
        /// <p>The metadata properties associated with the model package versions.</p>
        pub fn customer_metadata_properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.customer_metadata_properties.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.customer_metadata_properties = Some(hash_map);
            self
        }
        /// <p>The metadata properties associated with the model package versions.</p>
        pub fn set_customer_metadata_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.customer_metadata_properties = input;
            self
        }
        /// <p>Represents the drift check baselines that can be used when the model monitor is set using the model package. For more information, see the topic on <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-quality-clarify-baseline-lifecycle.html#pipelines-quality-clarify-baseline-drift-detection">Drift Detection against Previous Baselines in SageMaker Pipelines</a> in the <i>Amazon SageMaker Developer Guide</i>. </p>
        pub fn drift_check_baselines(mut self, input: crate::model::DriftCheckBaselines) -> Self {
            self.drift_check_baselines = Some(input);
            self
        }
        /// <p>Represents the drift check baselines that can be used when the model monitor is set using the model package. For more information, see the topic on <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-quality-clarify-baseline-lifecycle.html#pipelines-quality-clarify-baseline-drift-detection">Drift Detection against Previous Baselines in SageMaker Pipelines</a> in the <i>Amazon SageMaker Developer Guide</i>. </p>
        pub fn set_drift_check_baselines(
            mut self,
            input: std::option::Option<crate::model::DriftCheckBaselines>,
        ) -> Self {
            self.drift_check_baselines = input;
            self
        }
        /// <p>The machine learning domain of the model package you specified. Common machine learning domains include computer vision and natural language processing.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The machine learning domain of the model package you specified. Common machine learning domains include computer vision and natural language processing.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The machine learning task you specified that your model package accomplishes. Common machine learning tasks include object detection and image classification.</p>
        pub fn task(mut self, input: impl Into<std::string::String>) -> Self {
            self.task = Some(input.into());
            self
        }
        /// <p>The machine learning task you specified that your model package accomplishes. Common machine learning tasks include object detection and image classification.</p>
        pub fn set_task(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task = input;
            self
        }
        /// <p>The Amazon Simple Storage Service (Amazon S3) path where the sample payload are stored. This path points to a single gzip compressed tar archive (.tar.gz suffix).</p>
        pub fn sample_payload_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.sample_payload_url = Some(input.into());
            self
        }
        /// <p>The Amazon Simple Storage Service (Amazon S3) path where the sample payload are stored. This path points to a single gzip compressed tar archive (.tar.gz suffix).</p>
        pub fn set_sample_payload_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sample_payload_url = input;
            self
        }
        /// Appends an item to `additional_inference_specifications`.
        ///
        /// To override the contents of this collection use [`set_additional_inference_specifications`](Self::set_additional_inference_specifications).
        ///
        /// <p>An array of additional Inference Specification objects. Each additional Inference Specification specifies artifacts based on this model package that can be used on inference endpoints. Generally used with SageMaker Neo to store the compiled artifacts.</p>
        pub fn additional_inference_specifications(
            mut self,
            input: crate::model::AdditionalInferenceSpecificationDefinition,
        ) -> Self {
            let mut v = self.additional_inference_specifications.unwrap_or_default();
            v.push(input);
            self.additional_inference_specifications = Some(v);
            self
        }
        /// <p>An array of additional Inference Specification objects. Each additional Inference Specification specifies artifacts based on this model package that can be used on inference endpoints. Generally used with SageMaker Neo to store the compiled artifacts.</p>
        pub fn set_additional_inference_specifications(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AdditionalInferenceSpecificationDefinition>,
            >,
        ) -> Self {
            self.additional_inference_specifications = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeModelPackageOutput`](crate::output::DescribeModelPackageOutput)
        pub fn build(self) -> crate::output::DescribeModelPackageOutput {
            crate::output::DescribeModelPackageOutput {
                model_package_name: self.model_package_name,
                model_package_group_name: self.model_package_group_name,
                model_package_version: self.model_package_version,
                model_package_arn: self.model_package_arn,
                model_package_description: self.model_package_description,
                creation_time: self.creation_time,
                inference_specification: self.inference_specification,
                source_algorithm_specification: self.source_algorithm_specification,
                validation_specification: self.validation_specification,
                model_package_status: self.model_package_status,
                model_package_status_details: self.model_package_status_details,
                certify_for_marketplace: self.certify_for_marketplace.unwrap_or_default(),
                model_approval_status: self.model_approval_status,
                created_by: self.created_by,
                metadata_properties: self.metadata_properties,
                model_metrics: self.model_metrics,
                last_modified_time: self.last_modified_time,
                last_modified_by: self.last_modified_by,
                approval_description: self.approval_description,
                customer_metadata_properties: self.customer_metadata_properties,
                drift_check_baselines: self.drift_check_baselines,
                domain: self.domain,
                task: self.task,
                sample_payload_url: self.sample_payload_url,
                additional_inference_specifications: self.additional_inference_specifications,
            }
        }
    }
}
impl DescribeModelPackageOutput {
    /// Creates a new builder-style object to manufacture [`DescribeModelPackageOutput`](crate::output::DescribeModelPackageOutput)
    pub fn builder() -> crate::output::describe_model_package_output::Builder {
        crate::output::describe_model_package_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeModelExplainabilityJobDefinitionOutput {
    /// <p>The Amazon Resource Name (ARN) of the model explainability job.</p>
    pub job_definition_arn: std::option::Option<std::string::String>,
    /// <p>The name of the explainability job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
    pub job_definition_name: std::option::Option<std::string::String>,
    /// <p>The time at which the model explainability job was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The baseline configuration for a model explainability job.</p>
    pub model_explainability_baseline_config:
        std::option::Option<crate::model::ModelExplainabilityBaselineConfig>,
    /// <p>Configures the model explainability job to run a specified Docker container image.</p>
    pub model_explainability_app_specification:
        std::option::Option<crate::model::ModelExplainabilityAppSpecification>,
    /// <p>Inputs for the model explainability job.</p>
    pub model_explainability_job_input:
        std::option::Option<crate::model::ModelExplainabilityJobInput>,
    /// <p>The output configuration for monitoring jobs.</p>
    pub model_explainability_job_output_config:
        std::option::Option<crate::model::MonitoringOutputConfig>,
    /// <p>Identifies the resources to deploy for a monitoring job.</p>
    pub job_resources: std::option::Option<crate::model::MonitoringResources>,
    /// <p>Networking options for a model explainability job.</p>
    pub network_config: std::option::Option<crate::model::MonitoringNetworkConfig>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that has read permission to the input data location and write permission to the output data location in Amazon S3.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
    pub stopping_condition: std::option::Option<crate::model::MonitoringStoppingCondition>,
}
impl DescribeModelExplainabilityJobDefinitionOutput {
    /// <p>The Amazon Resource Name (ARN) of the model explainability job.</p>
    pub fn job_definition_arn(&self) -> std::option::Option<&str> {
        self.job_definition_arn.as_deref()
    }
    /// <p>The name of the explainability job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
    pub fn job_definition_name(&self) -> std::option::Option<&str> {
        self.job_definition_name.as_deref()
    }
    /// <p>The time at which the model explainability job was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The baseline configuration for a model explainability job.</p>
    pub fn model_explainability_baseline_config(
        &self,
    ) -> std::option::Option<&crate::model::ModelExplainabilityBaselineConfig> {
        self.model_explainability_baseline_config.as_ref()
    }
    /// <p>Configures the model explainability job to run a specified Docker container image.</p>
    pub fn model_explainability_app_specification(
        &self,
    ) -> std::option::Option<&crate::model::ModelExplainabilityAppSpecification> {
        self.model_explainability_app_specification.as_ref()
    }
    /// <p>Inputs for the model explainability job.</p>
    pub fn model_explainability_job_input(
        &self,
    ) -> std::option::Option<&crate::model::ModelExplainabilityJobInput> {
        self.model_explainability_job_input.as_ref()
    }
    /// <p>The output configuration for monitoring jobs.</p>
    pub fn model_explainability_job_output_config(
        &self,
    ) -> std::option::Option<&crate::model::MonitoringOutputConfig> {
        self.model_explainability_job_output_config.as_ref()
    }
    /// <p>Identifies the resources to deploy for a monitoring job.</p>
    pub fn job_resources(&self) -> std::option::Option<&crate::model::MonitoringResources> {
        self.job_resources.as_ref()
    }
    /// <p>Networking options for a model explainability job.</p>
    pub fn network_config(&self) -> std::option::Option<&crate::model::MonitoringNetworkConfig> {
        self.network_config.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that has read permission to the input data location and write permission to the output data location in Amazon S3.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
    pub fn stopping_condition(
        &self,
    ) -> std::option::Option<&crate::model::MonitoringStoppingCondition> {
        self.stopping_condition.as_ref()
    }
}
impl std::fmt::Debug for DescribeModelExplainabilityJobDefinitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeModelExplainabilityJobDefinitionOutput");
        formatter.field("job_definition_arn", &self.job_definition_arn);
        formatter.field("job_definition_name", &self.job_definition_name);
        formatter.field("creation_time", &self.creation_time);
        formatter.field(
            "model_explainability_baseline_config",
            &self.model_explainability_baseline_config,
        );
        formatter.field(
            "model_explainability_app_specification",
            &self.model_explainability_app_specification,
        );
        formatter.field(
            "model_explainability_job_input",
            &self.model_explainability_job_input,
        );
        formatter.field(
            "model_explainability_job_output_config",
            &self.model_explainability_job_output_config,
        );
        formatter.field("job_resources", &self.job_resources);
        formatter.field("network_config", &self.network_config);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("stopping_condition", &self.stopping_condition);
        formatter.finish()
    }
}
/// See [`DescribeModelExplainabilityJobDefinitionOutput`](crate::output::DescribeModelExplainabilityJobDefinitionOutput)
pub mod describe_model_explainability_job_definition_output {
    /// A builder for [`DescribeModelExplainabilityJobDefinitionOutput`](crate::output::DescribeModelExplainabilityJobDefinitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_definition_arn: std::option::Option<std::string::String>,
        pub(crate) job_definition_name: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) model_explainability_baseline_config:
            std::option::Option<crate::model::ModelExplainabilityBaselineConfig>,
        pub(crate) model_explainability_app_specification:
            std::option::Option<crate::model::ModelExplainabilityAppSpecification>,
        pub(crate) model_explainability_job_input:
            std::option::Option<crate::model::ModelExplainabilityJobInput>,
        pub(crate) model_explainability_job_output_config:
            std::option::Option<crate::model::MonitoringOutputConfig>,
        pub(crate) job_resources: std::option::Option<crate::model::MonitoringResources>,
        pub(crate) network_config: std::option::Option<crate::model::MonitoringNetworkConfig>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) stopping_condition:
            std::option::Option<crate::model::MonitoringStoppingCondition>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the model explainability job.</p>
        pub fn job_definition_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_definition_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model explainability job.</p>
        pub fn set_job_definition_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_definition_arn = input;
            self
        }
        /// <p>The name of the explainability job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
        pub fn job_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_definition_name = Some(input.into());
            self
        }
        /// <p>The name of the explainability job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
        pub fn set_job_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_definition_name = input;
            self
        }
        /// <p>The time at which the model explainability job was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time at which the model explainability job was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The baseline configuration for a model explainability job.</p>
        pub fn model_explainability_baseline_config(
            mut self,
            input: crate::model::ModelExplainabilityBaselineConfig,
        ) -> Self {
            self.model_explainability_baseline_config = Some(input);
            self
        }
        /// <p>The baseline configuration for a model explainability job.</p>
        pub fn set_model_explainability_baseline_config(
            mut self,
            input: std::option::Option<crate::model::ModelExplainabilityBaselineConfig>,
        ) -> Self {
            self.model_explainability_baseline_config = input;
            self
        }
        /// <p>Configures the model explainability job to run a specified Docker container image.</p>
        pub fn model_explainability_app_specification(
            mut self,
            input: crate::model::ModelExplainabilityAppSpecification,
        ) -> Self {
            self.model_explainability_app_specification = Some(input);
            self
        }
        /// <p>Configures the model explainability job to run a specified Docker container image.</p>
        pub fn set_model_explainability_app_specification(
            mut self,
            input: std::option::Option<crate::model::ModelExplainabilityAppSpecification>,
        ) -> Self {
            self.model_explainability_app_specification = input;
            self
        }
        /// <p>Inputs for the model explainability job.</p>
        pub fn model_explainability_job_input(
            mut self,
            input: crate::model::ModelExplainabilityJobInput,
        ) -> Self {
            self.model_explainability_job_input = Some(input);
            self
        }
        /// <p>Inputs for the model explainability job.</p>
        pub fn set_model_explainability_job_input(
            mut self,
            input: std::option::Option<crate::model::ModelExplainabilityJobInput>,
        ) -> Self {
            self.model_explainability_job_input = input;
            self
        }
        /// <p>The output configuration for monitoring jobs.</p>
        pub fn model_explainability_job_output_config(
            mut self,
            input: crate::model::MonitoringOutputConfig,
        ) -> Self {
            self.model_explainability_job_output_config = Some(input);
            self
        }
        /// <p>The output configuration for monitoring jobs.</p>
        pub fn set_model_explainability_job_output_config(
            mut self,
            input: std::option::Option<crate::model::MonitoringOutputConfig>,
        ) -> Self {
            self.model_explainability_job_output_config = input;
            self
        }
        /// <p>Identifies the resources to deploy for a monitoring job.</p>
        pub fn job_resources(mut self, input: crate::model::MonitoringResources) -> Self {
            self.job_resources = Some(input);
            self
        }
        /// <p>Identifies the resources to deploy for a monitoring job.</p>
        pub fn set_job_resources(
            mut self,
            input: std::option::Option<crate::model::MonitoringResources>,
        ) -> Self {
            self.job_resources = input;
            self
        }
        /// <p>Networking options for a model explainability job.</p>
        pub fn network_config(mut self, input: crate::model::MonitoringNetworkConfig) -> Self {
            self.network_config = Some(input);
            self
        }
        /// <p>Networking options for a model explainability job.</p>
        pub fn set_network_config(
            mut self,
            input: std::option::Option<crate::model::MonitoringNetworkConfig>,
        ) -> Self {
            self.network_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that has read permission to the input data location and write permission to the output data location in Amazon S3.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that has read permission to the input data location and write permission to the output data location in Amazon S3.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
        pub fn stopping_condition(
            mut self,
            input: crate::model::MonitoringStoppingCondition,
        ) -> Self {
            self.stopping_condition = Some(input);
            self
        }
        /// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
        pub fn set_stopping_condition(
            mut self,
            input: std::option::Option<crate::model::MonitoringStoppingCondition>,
        ) -> Self {
            self.stopping_condition = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeModelExplainabilityJobDefinitionOutput`](crate::output::DescribeModelExplainabilityJobDefinitionOutput)
        pub fn build(self) -> crate::output::DescribeModelExplainabilityJobDefinitionOutput {
            crate::output::DescribeModelExplainabilityJobDefinitionOutput {
                job_definition_arn: self.job_definition_arn,
                job_definition_name: self.job_definition_name,
                creation_time: self.creation_time,
                model_explainability_baseline_config: self.model_explainability_baseline_config,
                model_explainability_app_specification: self.model_explainability_app_specification,
                model_explainability_job_input: self.model_explainability_job_input,
                model_explainability_job_output_config: self.model_explainability_job_output_config,
                job_resources: self.job_resources,
                network_config: self.network_config,
                role_arn: self.role_arn,
                stopping_condition: self.stopping_condition,
            }
        }
    }
}
impl DescribeModelExplainabilityJobDefinitionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeModelExplainabilityJobDefinitionOutput`](crate::output::DescribeModelExplainabilityJobDefinitionOutput)
    pub fn builder() -> crate::output::describe_model_explainability_job_definition_output::Builder
    {
        crate::output::describe_model_explainability_job_definition_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeModelBiasJobDefinitionOutput {
    /// <p>The Amazon Resource Name (ARN) of the model bias job.</p>
    pub job_definition_arn: std::option::Option<std::string::String>,
    /// <p>The name of the bias job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
    pub job_definition_name: std::option::Option<std::string::String>,
    /// <p>The time at which the model bias job was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The baseline configuration for a model bias job.</p>
    pub model_bias_baseline_config: std::option::Option<crate::model::ModelBiasBaselineConfig>,
    /// <p>Configures the model bias job to run a specified Docker container image.</p>
    pub model_bias_app_specification: std::option::Option<crate::model::ModelBiasAppSpecification>,
    /// <p>Inputs for the model bias job.</p>
    pub model_bias_job_input: std::option::Option<crate::model::ModelBiasJobInput>,
    /// <p>The output configuration for monitoring jobs.</p>
    pub model_bias_job_output_config: std::option::Option<crate::model::MonitoringOutputConfig>,
    /// <p>Identifies the resources to deploy for a monitoring job.</p>
    pub job_resources: std::option::Option<crate::model::MonitoringResources>,
    /// <p>Networking options for a model bias job.</p>
    pub network_config: std::option::Option<crate::model::MonitoringNetworkConfig>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that has read permission to the input data location and write permission to the output data location in Amazon S3.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
    pub stopping_condition: std::option::Option<crate::model::MonitoringStoppingCondition>,
}
impl DescribeModelBiasJobDefinitionOutput {
    /// <p>The Amazon Resource Name (ARN) of the model bias job.</p>
    pub fn job_definition_arn(&self) -> std::option::Option<&str> {
        self.job_definition_arn.as_deref()
    }
    /// <p>The name of the bias job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
    pub fn job_definition_name(&self) -> std::option::Option<&str> {
        self.job_definition_name.as_deref()
    }
    /// <p>The time at which the model bias job was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The baseline configuration for a model bias job.</p>
    pub fn model_bias_baseline_config(
        &self,
    ) -> std::option::Option<&crate::model::ModelBiasBaselineConfig> {
        self.model_bias_baseline_config.as_ref()
    }
    /// <p>Configures the model bias job to run a specified Docker container image.</p>
    pub fn model_bias_app_specification(
        &self,
    ) -> std::option::Option<&crate::model::ModelBiasAppSpecification> {
        self.model_bias_app_specification.as_ref()
    }
    /// <p>Inputs for the model bias job.</p>
    pub fn model_bias_job_input(&self) -> std::option::Option<&crate::model::ModelBiasJobInput> {
        self.model_bias_job_input.as_ref()
    }
    /// <p>The output configuration for monitoring jobs.</p>
    pub fn model_bias_job_output_config(
        &self,
    ) -> std::option::Option<&crate::model::MonitoringOutputConfig> {
        self.model_bias_job_output_config.as_ref()
    }
    /// <p>Identifies the resources to deploy for a monitoring job.</p>
    pub fn job_resources(&self) -> std::option::Option<&crate::model::MonitoringResources> {
        self.job_resources.as_ref()
    }
    /// <p>Networking options for a model bias job.</p>
    pub fn network_config(&self) -> std::option::Option<&crate::model::MonitoringNetworkConfig> {
        self.network_config.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that has read permission to the input data location and write permission to the output data location in Amazon S3.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
    pub fn stopping_condition(
        &self,
    ) -> std::option::Option<&crate::model::MonitoringStoppingCondition> {
        self.stopping_condition.as_ref()
    }
}
impl std::fmt::Debug for DescribeModelBiasJobDefinitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeModelBiasJobDefinitionOutput");
        formatter.field("job_definition_arn", &self.job_definition_arn);
        formatter.field("job_definition_name", &self.job_definition_name);
        formatter.field("creation_time", &self.creation_time);
        formatter.field(
            "model_bias_baseline_config",
            &self.model_bias_baseline_config,
        );
        formatter.field(
            "model_bias_app_specification",
            &self.model_bias_app_specification,
        );
        formatter.field("model_bias_job_input", &self.model_bias_job_input);
        formatter.field(
            "model_bias_job_output_config",
            &self.model_bias_job_output_config,
        );
        formatter.field("job_resources", &self.job_resources);
        formatter.field("network_config", &self.network_config);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("stopping_condition", &self.stopping_condition);
        formatter.finish()
    }
}
/// See [`DescribeModelBiasJobDefinitionOutput`](crate::output::DescribeModelBiasJobDefinitionOutput)
pub mod describe_model_bias_job_definition_output {
    /// A builder for [`DescribeModelBiasJobDefinitionOutput`](crate::output::DescribeModelBiasJobDefinitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_definition_arn: std::option::Option<std::string::String>,
        pub(crate) job_definition_name: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) model_bias_baseline_config:
            std::option::Option<crate::model::ModelBiasBaselineConfig>,
        pub(crate) model_bias_app_specification:
            std::option::Option<crate::model::ModelBiasAppSpecification>,
        pub(crate) model_bias_job_input: std::option::Option<crate::model::ModelBiasJobInput>,
        pub(crate) model_bias_job_output_config:
            std::option::Option<crate::model::MonitoringOutputConfig>,
        pub(crate) job_resources: std::option::Option<crate::model::MonitoringResources>,
        pub(crate) network_config: std::option::Option<crate::model::MonitoringNetworkConfig>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) stopping_condition:
            std::option::Option<crate::model::MonitoringStoppingCondition>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the model bias job.</p>
        pub fn job_definition_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_definition_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model bias job.</p>
        pub fn set_job_definition_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_definition_arn = input;
            self
        }
        /// <p>The name of the bias job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
        pub fn job_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_definition_name = Some(input.into());
            self
        }
        /// <p>The name of the bias job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
        pub fn set_job_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_definition_name = input;
            self
        }
        /// <p>The time at which the model bias job was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time at which the model bias job was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The baseline configuration for a model bias job.</p>
        pub fn model_bias_baseline_config(
            mut self,
            input: crate::model::ModelBiasBaselineConfig,
        ) -> Self {
            self.model_bias_baseline_config = Some(input);
            self
        }
        /// <p>The baseline configuration for a model bias job.</p>
        pub fn set_model_bias_baseline_config(
            mut self,
            input: std::option::Option<crate::model::ModelBiasBaselineConfig>,
        ) -> Self {
            self.model_bias_baseline_config = input;
            self
        }
        /// <p>Configures the model bias job to run a specified Docker container image.</p>
        pub fn model_bias_app_specification(
            mut self,
            input: crate::model::ModelBiasAppSpecification,
        ) -> Self {
            self.model_bias_app_specification = Some(input);
            self
        }
        /// <p>Configures the model bias job to run a specified Docker container image.</p>
        pub fn set_model_bias_app_specification(
            mut self,
            input: std::option::Option<crate::model::ModelBiasAppSpecification>,
        ) -> Self {
            self.model_bias_app_specification = input;
            self
        }
        /// <p>Inputs for the model bias job.</p>
        pub fn model_bias_job_input(mut self, input: crate::model::ModelBiasJobInput) -> Self {
            self.model_bias_job_input = Some(input);
            self
        }
        /// <p>Inputs for the model bias job.</p>
        pub fn set_model_bias_job_input(
            mut self,
            input: std::option::Option<crate::model::ModelBiasJobInput>,
        ) -> Self {
            self.model_bias_job_input = input;
            self
        }
        /// <p>The output configuration for monitoring jobs.</p>
        pub fn model_bias_job_output_config(
            mut self,
            input: crate::model::MonitoringOutputConfig,
        ) -> Self {
            self.model_bias_job_output_config = Some(input);
            self
        }
        /// <p>The output configuration for monitoring jobs.</p>
        pub fn set_model_bias_job_output_config(
            mut self,
            input: std::option::Option<crate::model::MonitoringOutputConfig>,
        ) -> Self {
            self.model_bias_job_output_config = input;
            self
        }
        /// <p>Identifies the resources to deploy for a monitoring job.</p>
        pub fn job_resources(mut self, input: crate::model::MonitoringResources) -> Self {
            self.job_resources = Some(input);
            self
        }
        /// <p>Identifies the resources to deploy for a monitoring job.</p>
        pub fn set_job_resources(
            mut self,
            input: std::option::Option<crate::model::MonitoringResources>,
        ) -> Self {
            self.job_resources = input;
            self
        }
        /// <p>Networking options for a model bias job.</p>
        pub fn network_config(mut self, input: crate::model::MonitoringNetworkConfig) -> Self {
            self.network_config = Some(input);
            self
        }
        /// <p>Networking options for a model bias job.</p>
        pub fn set_network_config(
            mut self,
            input: std::option::Option<crate::model::MonitoringNetworkConfig>,
        ) -> Self {
            self.network_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that has read permission to the input data location and write permission to the output data location in Amazon S3.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that has read permission to the input data location and write permission to the output data location in Amazon S3.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
        pub fn stopping_condition(
            mut self,
            input: crate::model::MonitoringStoppingCondition,
        ) -> Self {
            self.stopping_condition = Some(input);
            self
        }
        /// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
        pub fn set_stopping_condition(
            mut self,
            input: std::option::Option<crate::model::MonitoringStoppingCondition>,
        ) -> Self {
            self.stopping_condition = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeModelBiasJobDefinitionOutput`](crate::output::DescribeModelBiasJobDefinitionOutput)
        pub fn build(self) -> crate::output::DescribeModelBiasJobDefinitionOutput {
            crate::output::DescribeModelBiasJobDefinitionOutput {
                job_definition_arn: self.job_definition_arn,
                job_definition_name: self.job_definition_name,
                creation_time: self.creation_time,
                model_bias_baseline_config: self.model_bias_baseline_config,
                model_bias_app_specification: self.model_bias_app_specification,
                model_bias_job_input: self.model_bias_job_input,
                model_bias_job_output_config: self.model_bias_job_output_config,
                job_resources: self.job_resources,
                network_config: self.network_config,
                role_arn: self.role_arn,
                stopping_condition: self.stopping_condition,
            }
        }
    }
}
impl DescribeModelBiasJobDefinitionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeModelBiasJobDefinitionOutput`](crate::output::DescribeModelBiasJobDefinitionOutput)
    pub fn builder() -> crate::output::describe_model_bias_job_definition_output::Builder {
        crate::output::describe_model_bias_job_definition_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeModelOutput {
    /// <p>Name of the Amazon SageMaker model.</p>
    pub model_name: std::option::Option<std::string::String>,
    /// <p>The location of the primary inference code, associated artifacts, and custom environment map that the inference code uses when it is deployed in production. </p>
    pub primary_container: std::option::Option<crate::model::ContainerDefinition>,
    /// <p>The containers in the inference pipeline.</p>
    pub containers: std::option::Option<std::vec::Vec<crate::model::ContainerDefinition>>,
    /// <p>Specifies details of how containers in a multi-container endpoint are called.</p>
    pub inference_execution_config: std::option::Option<crate::model::InferenceExecutionConfig>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role that you specified for the model.</p>
    pub execution_role_arn: std::option::Option<std::string::String>,
    /// <p>A <code>VpcConfig</code> object that specifies the VPC that this model has access to. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html">Protect Endpoints by Using an Amazon Virtual Private Cloud</a> </p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
    /// <p>A timestamp that shows when the model was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Amazon Resource Name (ARN) of the model.</p>
    pub model_arn: std::option::Option<std::string::String>,
    /// <p>If <code>True</code>, no inbound or outbound network calls can be made to or from the model container.</p>
    pub enable_network_isolation: bool,
}
impl DescribeModelOutput {
    /// <p>Name of the Amazon SageMaker model.</p>
    pub fn model_name(&self) -> std::option::Option<&str> {
        self.model_name.as_deref()
    }
    /// <p>The location of the primary inference code, associated artifacts, and custom environment map that the inference code uses when it is deployed in production. </p>
    pub fn primary_container(&self) -> std::option::Option<&crate::model::ContainerDefinition> {
        self.primary_container.as_ref()
    }
    /// <p>The containers in the inference pipeline.</p>
    pub fn containers(&self) -> std::option::Option<&[crate::model::ContainerDefinition]> {
        self.containers.as_deref()
    }
    /// <p>Specifies details of how containers in a multi-container endpoint are called.</p>
    pub fn inference_execution_config(
        &self,
    ) -> std::option::Option<&crate::model::InferenceExecutionConfig> {
        self.inference_execution_config.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM role that you specified for the model.</p>
    pub fn execution_role_arn(&self) -> std::option::Option<&str> {
        self.execution_role_arn.as_deref()
    }
    /// <p>A <code>VpcConfig</code> object that specifies the VPC that this model has access to. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html">Protect Endpoints by Using an Amazon Virtual Private Cloud</a> </p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfig> {
        self.vpc_config.as_ref()
    }
    /// <p>A timestamp that shows when the model was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the model.</p>
    pub fn model_arn(&self) -> std::option::Option<&str> {
        self.model_arn.as_deref()
    }
    /// <p>If <code>True</code>, no inbound or outbound network calls can be made to or from the model container.</p>
    pub fn enable_network_isolation(&self) -> bool {
        self.enable_network_isolation
    }
}
impl std::fmt::Debug for DescribeModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeModelOutput");
        formatter.field("model_name", &self.model_name);
        formatter.field("primary_container", &self.primary_container);
        formatter.field("containers", &self.containers);
        formatter.field(
            "inference_execution_config",
            &self.inference_execution_config,
        );
        formatter.field("execution_role_arn", &self.execution_role_arn);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("model_arn", &self.model_arn);
        formatter.field("enable_network_isolation", &self.enable_network_isolation);
        formatter.finish()
    }
}
/// See [`DescribeModelOutput`](crate::output::DescribeModelOutput)
pub mod describe_model_output {
    /// A builder for [`DescribeModelOutput`](crate::output::DescribeModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_name: std::option::Option<std::string::String>,
        pub(crate) primary_container: std::option::Option<crate::model::ContainerDefinition>,
        pub(crate) containers:
            std::option::Option<std::vec::Vec<crate::model::ContainerDefinition>>,
        pub(crate) inference_execution_config:
            std::option::Option<crate::model::InferenceExecutionConfig>,
        pub(crate) execution_role_arn: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) model_arn: std::option::Option<std::string::String>,
        pub(crate) enable_network_isolation: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Name of the Amazon SageMaker model.</p>
        pub fn model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_name = Some(input.into());
            self
        }
        /// <p>Name of the Amazon SageMaker model.</p>
        pub fn set_model_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_name = input;
            self
        }
        /// <p>The location of the primary inference code, associated artifacts, and custom environment map that the inference code uses when it is deployed in production. </p>
        pub fn primary_container(mut self, input: crate::model::ContainerDefinition) -> Self {
            self.primary_container = Some(input);
            self
        }
        /// <p>The location of the primary inference code, associated artifacts, and custom environment map that the inference code uses when it is deployed in production. </p>
        pub fn set_primary_container(
            mut self,
            input: std::option::Option<crate::model::ContainerDefinition>,
        ) -> Self {
            self.primary_container = input;
            self
        }
        /// Appends an item to `containers`.
        ///
        /// To override the contents of this collection use [`set_containers`](Self::set_containers).
        ///
        /// <p>The containers in the inference pipeline.</p>
        pub fn containers(mut self, input: crate::model::ContainerDefinition) -> Self {
            let mut v = self.containers.unwrap_or_default();
            v.push(input);
            self.containers = Some(v);
            self
        }
        /// <p>The containers in the inference pipeline.</p>
        pub fn set_containers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContainerDefinition>>,
        ) -> Self {
            self.containers = input;
            self
        }
        /// <p>Specifies details of how containers in a multi-container endpoint are called.</p>
        pub fn inference_execution_config(
            mut self,
            input: crate::model::InferenceExecutionConfig,
        ) -> Self {
            self.inference_execution_config = Some(input);
            self
        }
        /// <p>Specifies details of how containers in a multi-container endpoint are called.</p>
        pub fn set_inference_execution_config(
            mut self,
            input: std::option::Option<crate::model::InferenceExecutionConfig>,
        ) -> Self {
            self.inference_execution_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that you specified for the model.</p>
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that you specified for the model.</p>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role_arn = input;
            self
        }
        /// <p>A <code>VpcConfig</code> object that specifies the VPC that this model has access to. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html">Protect Endpoints by Using an Amazon Virtual Private Cloud</a> </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>A <code>VpcConfig</code> object that specifies the VPC that this model has access to. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html">Protect Endpoints by Using an Amazon Virtual Private Cloud</a> </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>A timestamp that shows when the model was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A timestamp that shows when the model was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model.</p>
        pub fn model_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model.</p>
        pub fn set_model_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_arn = input;
            self
        }
        /// <p>If <code>True</code>, no inbound or outbound network calls can be made to or from the model container.</p>
        pub fn enable_network_isolation(mut self, input: bool) -> Self {
            self.enable_network_isolation = Some(input);
            self
        }
        /// <p>If <code>True</code>, no inbound or outbound network calls can be made to or from the model container.</p>
        pub fn set_enable_network_isolation(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_network_isolation = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeModelOutput`](crate::output::DescribeModelOutput)
        pub fn build(self) -> crate::output::DescribeModelOutput {
            crate::output::DescribeModelOutput {
                model_name: self.model_name,
                primary_container: self.primary_container,
                containers: self.containers,
                inference_execution_config: self.inference_execution_config,
                execution_role_arn: self.execution_role_arn,
                vpc_config: self.vpc_config,
                creation_time: self.creation_time,
                model_arn: self.model_arn,
                enable_network_isolation: self.enable_network_isolation.unwrap_or_default(),
            }
        }
    }
}
impl DescribeModelOutput {
    /// Creates a new builder-style object to manufacture [`DescribeModelOutput`](crate::output::DescribeModelOutput)
    pub fn builder() -> crate::output::describe_model_output::Builder {
        crate::output::describe_model_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLineageGroupOutput {
    /// <p>The name of the lineage group.</p>
    pub lineage_group_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the lineage group.</p>
    pub lineage_group_arn: std::option::Option<std::string::String>,
    /// <p>The display name of the lineage group.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The description of the lineage group.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The creation time of lineage group.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
    pub created_by: std::option::Option<crate::model::UserContext>,
    /// <p>The last modified time of the lineage group.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
    pub last_modified_by: std::option::Option<crate::model::UserContext>,
}
impl DescribeLineageGroupOutput {
    /// <p>The name of the lineage group.</p>
    pub fn lineage_group_name(&self) -> std::option::Option<&str> {
        self.lineage_group_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the lineage group.</p>
    pub fn lineage_group_arn(&self) -> std::option::Option<&str> {
        self.lineage_group_arn.as_deref()
    }
    /// <p>The display name of the lineage group.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The description of the lineage group.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The creation time of lineage group.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
    pub fn created_by(&self) -> std::option::Option<&crate::model::UserContext> {
        self.created_by.as_ref()
    }
    /// <p>The last modified time of the lineage group.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
    pub fn last_modified_by(&self) -> std::option::Option<&crate::model::UserContext> {
        self.last_modified_by.as_ref()
    }
}
impl std::fmt::Debug for DescribeLineageGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLineageGroupOutput");
        formatter.field("lineage_group_name", &self.lineage_group_name);
        formatter.field("lineage_group_arn", &self.lineage_group_arn);
        formatter.field("display_name", &self.display_name);
        formatter.field("description", &self.description);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("created_by", &self.created_by);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.finish()
    }
}
/// See [`DescribeLineageGroupOutput`](crate::output::DescribeLineageGroupOutput)
pub mod describe_lineage_group_output {
    /// A builder for [`DescribeLineageGroupOutput`](crate::output::DescribeLineageGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lineage_group_name: std::option::Option<std::string::String>,
        pub(crate) lineage_group_arn: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_by: std::option::Option<crate::model::UserContext>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_by: std::option::Option<crate::model::UserContext>,
    }
    impl Builder {
        /// <p>The name of the lineage group.</p>
        pub fn lineage_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.lineage_group_name = Some(input.into());
            self
        }
        /// <p>The name of the lineage group.</p>
        pub fn set_lineage_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lineage_group_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the lineage group.</p>
        pub fn lineage_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.lineage_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the lineage group.</p>
        pub fn set_lineage_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lineage_group_arn = input;
            self
        }
        /// <p>The display name of the lineage group.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The display name of the lineage group.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The description of the lineage group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the lineage group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The creation time of lineage group.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The creation time of lineage group.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
        pub fn created_by(mut self, input: crate::model::UserContext) -> Self {
            self.created_by = Some(input);
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
        pub fn set_created_by(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The last modified time of the lineage group.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The last modified time of the lineage group.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
        pub fn last_modified_by(mut self, input: crate::model::UserContext) -> Self {
            self.last_modified_by = Some(input);
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLineageGroupOutput`](crate::output::DescribeLineageGroupOutput)
        pub fn build(self) -> crate::output::DescribeLineageGroupOutput {
            crate::output::DescribeLineageGroupOutput {
                lineage_group_name: self.lineage_group_name,
                lineage_group_arn: self.lineage_group_arn,
                display_name: self.display_name,
                description: self.description,
                creation_time: self.creation_time,
                created_by: self.created_by,
                last_modified_time: self.last_modified_time,
                last_modified_by: self.last_modified_by,
            }
        }
    }
}
impl DescribeLineageGroupOutput {
    /// Creates a new builder-style object to manufacture [`DescribeLineageGroupOutput`](crate::output::DescribeLineageGroupOutput)
    pub fn builder() -> crate::output::describe_lineage_group_output::Builder {
        crate::output::describe_lineage_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLabelingJobOutput {
    /// <p>The processing status of the labeling job. </p>
    pub labeling_job_status: std::option::Option<crate::model::LabelingJobStatus>,
    /// <p>Provides a breakdown of the number of data objects labeled by humans, the number of objects labeled by machine, the number of objects than couldn't be labeled, and the total number of objects labeled. </p>
    pub label_counters: std::option::Option<crate::model::LabelCounters>,
    /// <p>If the job failed, the reason that it failed. </p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The date and time that the labeling job was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the labeling job was last updated.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A unique identifier for work done as part of a labeling job.</p>
    pub job_reference_code: std::option::Option<std::string::String>,
    /// <p>The name assigned to the labeling job when it was created.</p>
    pub labeling_job_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the labeling job.</p>
    pub labeling_job_arn: std::option::Option<std::string::String>,
    /// <p>The attribute used as the label in the output manifest file.</p>
    pub label_attribute_name: std::option::Option<std::string::String>,
    /// <p>Input configuration information for the labeling job, such as the Amazon S3 location of the data objects and the location of the manifest file that describes the data objects.</p>
    pub input_config: std::option::Option<crate::model::LabelingJobInputConfig>,
    /// <p>The location of the job's output data and the Amazon Web Services Key Management Service key ID for the key used to encrypt the output data, if any.</p>
    pub output_config: std::option::Option<crate::model::LabelingJobOutputConfig>,
    /// <p>The Amazon Resource Name (ARN) that Amazon SageMaker assumes to perform tasks on your behalf during data labeling.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The S3 location of the JSON file that defines the categories used to label data objects. Please note the following label-category limits:</p>
    /// <ul>
    /// <li> <p>Semantic segmentation labeling jobs using automated labeling: 20 labels</p> </li>
    /// <li> <p>Box bounding labeling jobs (all): 10 labels</p> </li>
    /// </ul>
    /// <p>The file is a JSON structure in the following format:</p>
    /// <p> <code>{</code> </p>
    /// <p> <code> "document-version": "2018-11-28"</code> </p>
    /// <p> <code> "labels": [</code> </p>
    /// <p> <code> {</code> </p>
    /// <p> <code> "label": "<i>label 1</i>"</code> </p>
    /// <p> <code> },</code> </p>
    /// <p> <code> {</code> </p>
    /// <p> <code> "label": "<i>label 2</i>"</code> </p>
    /// <p> <code> },</code> </p>
    /// <p> <code> ...</code> </p>
    /// <p> <code> {</code> </p>
    /// <p> <code> "label": "<i>label n</i>"</code> </p>
    /// <p> <code> }</code> </p>
    /// <p> <code> ]</code> </p>
    /// <p> <code>}</code> </p>
    pub label_category_config_s3_uri: std::option::Option<std::string::String>,
    /// <p>A set of conditions for stopping a labeling job. If any of the conditions are met, the job is automatically stopped.</p>
    pub stopping_conditions: std::option::Option<crate::model::LabelingJobStoppingConditions>,
    /// <p>Configuration information for automated data labeling.</p>
    pub labeling_job_algorithms_config:
        std::option::Option<crate::model::LabelingJobAlgorithmsConfig>,
    /// <p>Configuration information required for human workers to complete a labeling task.</p>
    pub human_task_config: std::option::Option<crate::model::HumanTaskConfig>,
    /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The location of the output produced by the labeling job.</p>
    pub labeling_job_output: std::option::Option<crate::model::LabelingJobOutput>,
}
impl DescribeLabelingJobOutput {
    /// <p>The processing status of the labeling job. </p>
    pub fn labeling_job_status(&self) -> std::option::Option<&crate::model::LabelingJobStatus> {
        self.labeling_job_status.as_ref()
    }
    /// <p>Provides a breakdown of the number of data objects labeled by humans, the number of objects labeled by machine, the number of objects than couldn't be labeled, and the total number of objects labeled. </p>
    pub fn label_counters(&self) -> std::option::Option<&crate::model::LabelCounters> {
        self.label_counters.as_ref()
    }
    /// <p>If the job failed, the reason that it failed. </p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The date and time that the labeling job was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The date and time that the labeling job was last updated.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>A unique identifier for work done as part of a labeling job.</p>
    pub fn job_reference_code(&self) -> std::option::Option<&str> {
        self.job_reference_code.as_deref()
    }
    /// <p>The name assigned to the labeling job when it was created.</p>
    pub fn labeling_job_name(&self) -> std::option::Option<&str> {
        self.labeling_job_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the labeling job.</p>
    pub fn labeling_job_arn(&self) -> std::option::Option<&str> {
        self.labeling_job_arn.as_deref()
    }
    /// <p>The attribute used as the label in the output manifest file.</p>
    pub fn label_attribute_name(&self) -> std::option::Option<&str> {
        self.label_attribute_name.as_deref()
    }
    /// <p>Input configuration information for the labeling job, such as the Amazon S3 location of the data objects and the location of the manifest file that describes the data objects.</p>
    pub fn input_config(&self) -> std::option::Option<&crate::model::LabelingJobInputConfig> {
        self.input_config.as_ref()
    }
    /// <p>The location of the job's output data and the Amazon Web Services Key Management Service key ID for the key used to encrypt the output data, if any.</p>
    pub fn output_config(&self) -> std::option::Option<&crate::model::LabelingJobOutputConfig> {
        self.output_config.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) that Amazon SageMaker assumes to perform tasks on your behalf during data labeling.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The S3 location of the JSON file that defines the categories used to label data objects. Please note the following label-category limits:</p>
    /// <ul>
    /// <li> <p>Semantic segmentation labeling jobs using automated labeling: 20 labels</p> </li>
    /// <li> <p>Box bounding labeling jobs (all): 10 labels</p> </li>
    /// </ul>
    /// <p>The file is a JSON structure in the following format:</p>
    /// <p> <code>{</code> </p>
    /// <p> <code> "document-version": "2018-11-28"</code> </p>
    /// <p> <code> "labels": [</code> </p>
    /// <p> <code> {</code> </p>
    /// <p> <code> "label": "<i>label 1</i>"</code> </p>
    /// <p> <code> },</code> </p>
    /// <p> <code> {</code> </p>
    /// <p> <code> "label": "<i>label 2</i>"</code> </p>
    /// <p> <code> },</code> </p>
    /// <p> <code> ...</code> </p>
    /// <p> <code> {</code> </p>
    /// <p> <code> "label": "<i>label n</i>"</code> </p>
    /// <p> <code> }</code> </p>
    /// <p> <code> ]</code> </p>
    /// <p> <code>}</code> </p>
    pub fn label_category_config_s3_uri(&self) -> std::option::Option<&str> {
        self.label_category_config_s3_uri.as_deref()
    }
    /// <p>A set of conditions for stopping a labeling job. If any of the conditions are met, the job is automatically stopped.</p>
    pub fn stopping_conditions(
        &self,
    ) -> std::option::Option<&crate::model::LabelingJobStoppingConditions> {
        self.stopping_conditions.as_ref()
    }
    /// <p>Configuration information for automated data labeling.</p>
    pub fn labeling_job_algorithms_config(
        &self,
    ) -> std::option::Option<&crate::model::LabelingJobAlgorithmsConfig> {
        self.labeling_job_algorithms_config.as_ref()
    }
    /// <p>Configuration information required for human workers to complete a labeling task.</p>
    pub fn human_task_config(&self) -> std::option::Option<&crate::model::HumanTaskConfig> {
        self.human_task_config.as_ref()
    }
    /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The location of the output produced by the labeling job.</p>
    pub fn labeling_job_output(&self) -> std::option::Option<&crate::model::LabelingJobOutput> {
        self.labeling_job_output.as_ref()
    }
}
impl std::fmt::Debug for DescribeLabelingJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLabelingJobOutput");
        formatter.field("labeling_job_status", &self.labeling_job_status);
        formatter.field("label_counters", &self.label_counters);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("job_reference_code", &self.job_reference_code);
        formatter.field("labeling_job_name", &self.labeling_job_name);
        formatter.field("labeling_job_arn", &self.labeling_job_arn);
        formatter.field("label_attribute_name", &self.label_attribute_name);
        formatter.field("input_config", &self.input_config);
        formatter.field("output_config", &self.output_config);
        formatter.field("role_arn", &self.role_arn);
        formatter.field(
            "label_category_config_s3_uri",
            &self.label_category_config_s3_uri,
        );
        formatter.field("stopping_conditions", &self.stopping_conditions);
        formatter.field(
            "labeling_job_algorithms_config",
            &self.labeling_job_algorithms_config,
        );
        formatter.field("human_task_config", &self.human_task_config);
        formatter.field("tags", &self.tags);
        formatter.field("labeling_job_output", &self.labeling_job_output);
        formatter.finish()
    }
}
/// See [`DescribeLabelingJobOutput`](crate::output::DescribeLabelingJobOutput)
pub mod describe_labeling_job_output {
    /// A builder for [`DescribeLabelingJobOutput`](crate::output::DescribeLabelingJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) labeling_job_status: std::option::Option<crate::model::LabelingJobStatus>,
        pub(crate) label_counters: std::option::Option<crate::model::LabelCounters>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) job_reference_code: std::option::Option<std::string::String>,
        pub(crate) labeling_job_name: std::option::Option<std::string::String>,
        pub(crate) labeling_job_arn: std::option::Option<std::string::String>,
        pub(crate) label_attribute_name: std::option::Option<std::string::String>,
        pub(crate) input_config: std::option::Option<crate::model::LabelingJobInputConfig>,
        pub(crate) output_config: std::option::Option<crate::model::LabelingJobOutputConfig>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) label_category_config_s3_uri: std::option::Option<std::string::String>,
        pub(crate) stopping_conditions:
            std::option::Option<crate::model::LabelingJobStoppingConditions>,
        pub(crate) labeling_job_algorithms_config:
            std::option::Option<crate::model::LabelingJobAlgorithmsConfig>,
        pub(crate) human_task_config: std::option::Option<crate::model::HumanTaskConfig>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) labeling_job_output: std::option::Option<crate::model::LabelingJobOutput>,
    }
    impl Builder {
        /// <p>The processing status of the labeling job. </p>
        pub fn labeling_job_status(mut self, input: crate::model::LabelingJobStatus) -> Self {
            self.labeling_job_status = Some(input);
            self
        }
        /// <p>The processing status of the labeling job. </p>
        pub fn set_labeling_job_status(
            mut self,
            input: std::option::Option<crate::model::LabelingJobStatus>,
        ) -> Self {
            self.labeling_job_status = input;
            self
        }
        /// <p>Provides a breakdown of the number of data objects labeled by humans, the number of objects labeled by machine, the number of objects than couldn't be labeled, and the total number of objects labeled. </p>
        pub fn label_counters(mut self, input: crate::model::LabelCounters) -> Self {
            self.label_counters = Some(input);
            self
        }
        /// <p>Provides a breakdown of the number of data objects labeled by humans, the number of objects labeled by machine, the number of objects than couldn't be labeled, and the total number of objects labeled. </p>
        pub fn set_label_counters(
            mut self,
            input: std::option::Option<crate::model::LabelCounters>,
        ) -> Self {
            self.label_counters = input;
            self
        }
        /// <p>If the job failed, the reason that it failed. </p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If the job failed, the reason that it failed. </p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The date and time that the labeling job was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The date and time that the labeling job was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The date and time that the labeling job was last updated.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The date and time that the labeling job was last updated.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>A unique identifier for work done as part of a labeling job.</p>
        pub fn job_reference_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_reference_code = Some(input.into());
            self
        }
        /// <p>A unique identifier for work done as part of a labeling job.</p>
        pub fn set_job_reference_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_reference_code = input;
            self
        }
        /// <p>The name assigned to the labeling job when it was created.</p>
        pub fn labeling_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.labeling_job_name = Some(input.into());
            self
        }
        /// <p>The name assigned to the labeling job when it was created.</p>
        pub fn set_labeling_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.labeling_job_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the labeling job.</p>
        pub fn labeling_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.labeling_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the labeling job.</p>
        pub fn set_labeling_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.labeling_job_arn = input;
            self
        }
        /// <p>The attribute used as the label in the output manifest file.</p>
        pub fn label_attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.label_attribute_name = Some(input.into());
            self
        }
        /// <p>The attribute used as the label in the output manifest file.</p>
        pub fn set_label_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.label_attribute_name = input;
            self
        }
        /// <p>Input configuration information for the labeling job, such as the Amazon S3 location of the data objects and the location of the manifest file that describes the data objects.</p>
        pub fn input_config(mut self, input: crate::model::LabelingJobInputConfig) -> Self {
            self.input_config = Some(input);
            self
        }
        /// <p>Input configuration information for the labeling job, such as the Amazon S3 location of the data objects and the location of the manifest file that describes the data objects.</p>
        pub fn set_input_config(
            mut self,
            input: std::option::Option<crate::model::LabelingJobInputConfig>,
        ) -> Self {
            self.input_config = input;
            self
        }
        /// <p>The location of the job's output data and the Amazon Web Services Key Management Service key ID for the key used to encrypt the output data, if any.</p>
        pub fn output_config(mut self, input: crate::model::LabelingJobOutputConfig) -> Self {
            self.output_config = Some(input);
            self
        }
        /// <p>The location of the job's output data and the Amazon Web Services Key Management Service key ID for the key used to encrypt the output data, if any.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::LabelingJobOutputConfig>,
        ) -> Self {
            self.output_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that Amazon SageMaker assumes to perform tasks on your behalf during data labeling.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that Amazon SageMaker assumes to perform tasks on your behalf during data labeling.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The S3 location of the JSON file that defines the categories used to label data objects. Please note the following label-category limits:</p>
        /// <ul>
        /// <li> <p>Semantic segmentation labeling jobs using automated labeling: 20 labels</p> </li>
        /// <li> <p>Box bounding labeling jobs (all): 10 labels</p> </li>
        /// </ul>
        /// <p>The file is a JSON structure in the following format:</p>
        /// <p> <code>{</code> </p>
        /// <p> <code> "document-version": "2018-11-28"</code> </p>
        /// <p> <code> "labels": [</code> </p>
        /// <p> <code> {</code> </p>
        /// <p> <code> "label": "<i>label 1</i>"</code> </p>
        /// <p> <code> },</code> </p>
        /// <p> <code> {</code> </p>
        /// <p> <code> "label": "<i>label 2</i>"</code> </p>
        /// <p> <code> },</code> </p>
        /// <p> <code> ...</code> </p>
        /// <p> <code> {</code> </p>
        /// <p> <code> "label": "<i>label n</i>"</code> </p>
        /// <p> <code> }</code> </p>
        /// <p> <code> ]</code> </p>
        /// <p> <code>}</code> </p>
        pub fn label_category_config_s3_uri(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.label_category_config_s3_uri = Some(input.into());
            self
        }
        /// <p>The S3 location of the JSON file that defines the categories used to label data objects. Please note the following label-category limits:</p>
        /// <ul>
        /// <li> <p>Semantic segmentation labeling jobs using automated labeling: 20 labels</p> </li>
        /// <li> <p>Box bounding labeling jobs (all): 10 labels</p> </li>
        /// </ul>
        /// <p>The file is a JSON structure in the following format:</p>
        /// <p> <code>{</code> </p>
        /// <p> <code> "document-version": "2018-11-28"</code> </p>
        /// <p> <code> "labels": [</code> </p>
        /// <p> <code> {</code> </p>
        /// <p> <code> "label": "<i>label 1</i>"</code> </p>
        /// <p> <code> },</code> </p>
        /// <p> <code> {</code> </p>
        /// <p> <code> "label": "<i>label 2</i>"</code> </p>
        /// <p> <code> },</code> </p>
        /// <p> <code> ...</code> </p>
        /// <p> <code> {</code> </p>
        /// <p> <code> "label": "<i>label n</i>"</code> </p>
        /// <p> <code> }</code> </p>
        /// <p> <code> ]</code> </p>
        /// <p> <code>}</code> </p>
        pub fn set_label_category_config_s3_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.label_category_config_s3_uri = input;
            self
        }
        /// <p>A set of conditions for stopping a labeling job. If any of the conditions are met, the job is automatically stopped.</p>
        pub fn stopping_conditions(
            mut self,
            input: crate::model::LabelingJobStoppingConditions,
        ) -> Self {
            self.stopping_conditions = Some(input);
            self
        }
        /// <p>A set of conditions for stopping a labeling job. If any of the conditions are met, the job is automatically stopped.</p>
        pub fn set_stopping_conditions(
            mut self,
            input: std::option::Option<crate::model::LabelingJobStoppingConditions>,
        ) -> Self {
            self.stopping_conditions = input;
            self
        }
        /// <p>Configuration information for automated data labeling.</p>
        pub fn labeling_job_algorithms_config(
            mut self,
            input: crate::model::LabelingJobAlgorithmsConfig,
        ) -> Self {
            self.labeling_job_algorithms_config = Some(input);
            self
        }
        /// <p>Configuration information for automated data labeling.</p>
        pub fn set_labeling_job_algorithms_config(
            mut self,
            input: std::option::Option<crate::model::LabelingJobAlgorithmsConfig>,
        ) -> Self {
            self.labeling_job_algorithms_config = input;
            self
        }
        /// <p>Configuration information required for human workers to complete a labeling task.</p>
        pub fn human_task_config(mut self, input: crate::model::HumanTaskConfig) -> Self {
            self.human_task_config = Some(input);
            self
        }
        /// <p>Configuration information required for human workers to complete a labeling task.</p>
        pub fn set_human_task_config(
            mut self,
            input: std::option::Option<crate::model::HumanTaskConfig>,
        ) -> Self {
            self.human_task_config = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The location of the output produced by the labeling job.</p>
        pub fn labeling_job_output(mut self, input: crate::model::LabelingJobOutput) -> Self {
            self.labeling_job_output = Some(input);
            self
        }
        /// <p>The location of the output produced by the labeling job.</p>
        pub fn set_labeling_job_output(
            mut self,
            input: std::option::Option<crate::model::LabelingJobOutput>,
        ) -> Self {
            self.labeling_job_output = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLabelingJobOutput`](crate::output::DescribeLabelingJobOutput)
        pub fn build(self) -> crate::output::DescribeLabelingJobOutput {
            crate::output::DescribeLabelingJobOutput {
                labeling_job_status: self.labeling_job_status,
                label_counters: self.label_counters,
                failure_reason: self.failure_reason,
                creation_time: self.creation_time,
                last_modified_time: self.last_modified_time,
                job_reference_code: self.job_reference_code,
                labeling_job_name: self.labeling_job_name,
                labeling_job_arn: self.labeling_job_arn,
                label_attribute_name: self.label_attribute_name,
                input_config: self.input_config,
                output_config: self.output_config,
                role_arn: self.role_arn,
                label_category_config_s3_uri: self.label_category_config_s3_uri,
                stopping_conditions: self.stopping_conditions,
                labeling_job_algorithms_config: self.labeling_job_algorithms_config,
                human_task_config: self.human_task_config,
                tags: self.tags,
                labeling_job_output: self.labeling_job_output,
            }
        }
    }
}
impl DescribeLabelingJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeLabelingJobOutput`](crate::output::DescribeLabelingJobOutput)
    pub fn builder() -> crate::output::describe_labeling_job_output::Builder {
        crate::output::describe_labeling_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInferenceRecommendationsJobOutput {
    /// <p>The name of the job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The job description that you provided when you initiated the job.</p>
    pub job_description: std::option::Option<std::string::String>,
    /// <p>The job type that you provided when you initiated the job.</p>
    pub job_type: std::option::Option<crate::model::RecommendationJobType>,
    /// <p>The Amazon Resource Name (ARN) of the job.</p>
    pub job_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role you provided when you initiated the job.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The status of the job.</p>
    pub status: std::option::Option<crate::model::RecommendationJobStatus>,
    /// <p>A timestamp that shows when the job was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp that shows when the job completed.</p>
    pub completion_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp that shows when the job was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>If the job fails, provides information why the job failed.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>Returns information about the versioned model package Amazon Resource Name (ARN), the traffic pattern, and endpoint configurations you provided when you initiated the job.</p>
    pub input_config: std::option::Option<crate::model::RecommendationJobInputConfig>,
    /// <p>The stopping conditions that you provided when you initiated the job.</p>
    pub stopping_conditions: std::option::Option<crate::model::RecommendationJobStoppingConditions>,
    /// <p>The recommendations made by Inference Recommender.</p>
    pub inference_recommendations:
        std::option::Option<std::vec::Vec<crate::model::InferenceRecommendation>>,
}
impl DescribeInferenceRecommendationsJobOutput {
    /// <p>The name of the job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>The job description that you provided when you initiated the job.</p>
    pub fn job_description(&self) -> std::option::Option<&str> {
        self.job_description.as_deref()
    }
    /// <p>The job type that you provided when you initiated the job.</p>
    pub fn job_type(&self) -> std::option::Option<&crate::model::RecommendationJobType> {
        self.job_type.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the job.</p>
    pub fn job_arn(&self) -> std::option::Option<&str> {
        self.job_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role you provided when you initiated the job.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The status of the job.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::RecommendationJobStatus> {
        self.status.as_ref()
    }
    /// <p>A timestamp that shows when the job was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>A timestamp that shows when the job completed.</p>
    pub fn completion_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.completion_time.as_ref()
    }
    /// <p>A timestamp that shows when the job was last modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>If the job fails, provides information why the job failed.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>Returns information about the versioned model package Amazon Resource Name (ARN), the traffic pattern, and endpoint configurations you provided when you initiated the job.</p>
    pub fn input_config(&self) -> std::option::Option<&crate::model::RecommendationJobInputConfig> {
        self.input_config.as_ref()
    }
    /// <p>The stopping conditions that you provided when you initiated the job.</p>
    pub fn stopping_conditions(
        &self,
    ) -> std::option::Option<&crate::model::RecommendationJobStoppingConditions> {
        self.stopping_conditions.as_ref()
    }
    /// <p>The recommendations made by Inference Recommender.</p>
    pub fn inference_recommendations(
        &self,
    ) -> std::option::Option<&[crate::model::InferenceRecommendation]> {
        self.inference_recommendations.as_deref()
    }
}
impl std::fmt::Debug for DescribeInferenceRecommendationsJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInferenceRecommendationsJobOutput");
        formatter.field("job_name", &self.job_name);
        formatter.field("job_description", &self.job_description);
        formatter.field("job_type", &self.job_type);
        formatter.field("job_arn", &self.job_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("status", &self.status);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("completion_time", &self.completion_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("input_config", &self.input_config);
        formatter.field("stopping_conditions", &self.stopping_conditions);
        formatter.field("inference_recommendations", &self.inference_recommendations);
        formatter.finish()
    }
}
/// See [`DescribeInferenceRecommendationsJobOutput`](crate::output::DescribeInferenceRecommendationsJobOutput)
pub mod describe_inference_recommendations_job_output {
    /// A builder for [`DescribeInferenceRecommendationsJobOutput`](crate::output::DescribeInferenceRecommendationsJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) job_description: std::option::Option<std::string::String>,
        pub(crate) job_type: std::option::Option<crate::model::RecommendationJobType>,
        pub(crate) job_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::RecommendationJobStatus>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) completion_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) input_config: std::option::Option<crate::model::RecommendationJobInputConfig>,
        pub(crate) stopping_conditions:
            std::option::Option<crate::model::RecommendationJobStoppingConditions>,
        pub(crate) inference_recommendations:
            std::option::Option<std::vec::Vec<crate::model::InferenceRecommendation>>,
    }
    impl Builder {
        /// <p>The name of the job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name of the job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The job description that you provided when you initiated the job.</p>
        pub fn job_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_description = Some(input.into());
            self
        }
        /// <p>The job description that you provided when you initiated the job.</p>
        pub fn set_job_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_description = input;
            self
        }
        /// <p>The job type that you provided when you initiated the job.</p>
        pub fn job_type(mut self, input: crate::model::RecommendationJobType) -> Self {
            self.job_type = Some(input);
            self
        }
        /// <p>The job type that you provided when you initiated the job.</p>
        pub fn set_job_type(
            mut self,
            input: std::option::Option<crate::model::RecommendationJobType>,
        ) -> Self {
            self.job_type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the job.</p>
        pub fn job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the job.</p>
        pub fn set_job_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role you provided when you initiated the job.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role you provided when you initiated the job.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The status of the job.</p>
        pub fn status(mut self, input: crate::model::RecommendationJobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the job.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RecommendationJobStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A timestamp that shows when the job was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A timestamp that shows when the job was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>A timestamp that shows when the job completed.</p>
        pub fn completion_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.completion_time = Some(input);
            self
        }
        /// <p>A timestamp that shows when the job completed.</p>
        pub fn set_completion_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.completion_time = input;
            self
        }
        /// <p>A timestamp that shows when the job was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>A timestamp that shows when the job was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>If the job fails, provides information why the job failed.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If the job fails, provides information why the job failed.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>Returns information about the versioned model package Amazon Resource Name (ARN), the traffic pattern, and endpoint configurations you provided when you initiated the job.</p>
        pub fn input_config(mut self, input: crate::model::RecommendationJobInputConfig) -> Self {
            self.input_config = Some(input);
            self
        }
        /// <p>Returns information about the versioned model package Amazon Resource Name (ARN), the traffic pattern, and endpoint configurations you provided when you initiated the job.</p>
        pub fn set_input_config(
            mut self,
            input: std::option::Option<crate::model::RecommendationJobInputConfig>,
        ) -> Self {
            self.input_config = input;
            self
        }
        /// <p>The stopping conditions that you provided when you initiated the job.</p>
        pub fn stopping_conditions(
            mut self,
            input: crate::model::RecommendationJobStoppingConditions,
        ) -> Self {
            self.stopping_conditions = Some(input);
            self
        }
        /// <p>The stopping conditions that you provided when you initiated the job.</p>
        pub fn set_stopping_conditions(
            mut self,
            input: std::option::Option<crate::model::RecommendationJobStoppingConditions>,
        ) -> Self {
            self.stopping_conditions = input;
            self
        }
        /// Appends an item to `inference_recommendations`.
        ///
        /// To override the contents of this collection use [`set_inference_recommendations`](Self::set_inference_recommendations).
        ///
        /// <p>The recommendations made by Inference Recommender.</p>
        pub fn inference_recommendations(
            mut self,
            input: crate::model::InferenceRecommendation,
        ) -> Self {
            let mut v = self.inference_recommendations.unwrap_or_default();
            v.push(input);
            self.inference_recommendations = Some(v);
            self
        }
        /// <p>The recommendations made by Inference Recommender.</p>
        pub fn set_inference_recommendations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InferenceRecommendation>>,
        ) -> Self {
            self.inference_recommendations = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInferenceRecommendationsJobOutput`](crate::output::DescribeInferenceRecommendationsJobOutput)
        pub fn build(self) -> crate::output::DescribeInferenceRecommendationsJobOutput {
            crate::output::DescribeInferenceRecommendationsJobOutput {
                job_name: self.job_name,
                job_description: self.job_description,
                job_type: self.job_type,
                job_arn: self.job_arn,
                role_arn: self.role_arn,
                status: self.status,
                creation_time: self.creation_time,
                completion_time: self.completion_time,
                last_modified_time: self.last_modified_time,
                failure_reason: self.failure_reason,
                input_config: self.input_config,
                stopping_conditions: self.stopping_conditions,
                inference_recommendations: self.inference_recommendations,
            }
        }
    }
}
impl DescribeInferenceRecommendationsJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeInferenceRecommendationsJobOutput`](crate::output::DescribeInferenceRecommendationsJobOutput)
    pub fn builder() -> crate::output::describe_inference_recommendations_job_output::Builder {
        crate::output::describe_inference_recommendations_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeImageVersionOutput {
    /// <p>The registry path of the container image on which this image version is based.</p>
    pub base_image: std::option::Option<std::string::String>,
    /// <p>The registry path of the container image that contains this image version.</p>
    pub container_image: std::option::Option<std::string::String>,
    /// <p>When the version was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>When a create or delete operation fails, the reason for the failure.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the image the version is based on.</p>
    pub image_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the version.</p>
    pub image_version_arn: std::option::Option<std::string::String>,
    /// <p>The status of the version.</p>
    pub image_version_status: std::option::Option<crate::model::ImageVersionStatus>,
    /// <p>When the version was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The version number.</p>
    pub version: std::option::Option<i32>,
}
impl DescribeImageVersionOutput {
    /// <p>The registry path of the container image on which this image version is based.</p>
    pub fn base_image(&self) -> std::option::Option<&str> {
        self.base_image.as_deref()
    }
    /// <p>The registry path of the container image that contains this image version.</p>
    pub fn container_image(&self) -> std::option::Option<&str> {
        self.container_image.as_deref()
    }
    /// <p>When the version was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>When a create or delete operation fails, the reason for the failure.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the image the version is based on.</p>
    pub fn image_arn(&self) -> std::option::Option<&str> {
        self.image_arn.as_deref()
    }
    /// <p>The ARN of the version.</p>
    pub fn image_version_arn(&self) -> std::option::Option<&str> {
        self.image_version_arn.as_deref()
    }
    /// <p>The status of the version.</p>
    pub fn image_version_status(&self) -> std::option::Option<&crate::model::ImageVersionStatus> {
        self.image_version_status.as_ref()
    }
    /// <p>When the version was last modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>The version number.</p>
    pub fn version(&self) -> std::option::Option<i32> {
        self.version
    }
}
impl std::fmt::Debug for DescribeImageVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeImageVersionOutput");
        formatter.field("base_image", &self.base_image);
        formatter.field("container_image", &self.container_image);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("image_arn", &self.image_arn);
        formatter.field("image_version_arn", &self.image_version_arn);
        formatter.field("image_version_status", &self.image_version_status);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`DescribeImageVersionOutput`](crate::output::DescribeImageVersionOutput)
pub mod describe_image_version_output {
    /// A builder for [`DescribeImageVersionOutput`](crate::output::DescribeImageVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) base_image: std::option::Option<std::string::String>,
        pub(crate) container_image: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) image_arn: std::option::Option<std::string::String>,
        pub(crate) image_version_arn: std::option::Option<std::string::String>,
        pub(crate) image_version_status: std::option::Option<crate::model::ImageVersionStatus>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) version: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The registry path of the container image on which this image version is based.</p>
        pub fn base_image(mut self, input: impl Into<std::string::String>) -> Self {
            self.base_image = Some(input.into());
            self
        }
        /// <p>The registry path of the container image on which this image version is based.</p>
        pub fn set_base_image(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.base_image = input;
            self
        }
        /// <p>The registry path of the container image that contains this image version.</p>
        pub fn container_image(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_image = Some(input.into());
            self
        }
        /// <p>The registry path of the container image that contains this image version.</p>
        pub fn set_container_image(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_image = input;
            self
        }
        /// <p>When the version was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the version was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>When a create or delete operation fails, the reason for the failure.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>When a create or delete operation fails, the reason for the failure.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image the version is based on.</p>
        pub fn image_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image the version is based on.</p>
        pub fn set_image_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_arn = input;
            self
        }
        /// <p>The ARN of the version.</p>
        pub fn image_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_version_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the version.</p>
        pub fn set_image_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_version_arn = input;
            self
        }
        /// <p>The status of the version.</p>
        pub fn image_version_status(mut self, input: crate::model::ImageVersionStatus) -> Self {
            self.image_version_status = Some(input);
            self
        }
        /// <p>The status of the version.</p>
        pub fn set_image_version_status(
            mut self,
            input: std::option::Option<crate::model::ImageVersionStatus>,
        ) -> Self {
            self.image_version_status = input;
            self
        }
        /// <p>When the version was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>When the version was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>The version number.</p>
        pub fn version(mut self, input: i32) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version number.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeImageVersionOutput`](crate::output::DescribeImageVersionOutput)
        pub fn build(self) -> crate::output::DescribeImageVersionOutput {
            crate::output::DescribeImageVersionOutput {
                base_image: self.base_image,
                container_image: self.container_image,
                creation_time: self.creation_time,
                failure_reason: self.failure_reason,
                image_arn: self.image_arn,
                image_version_arn: self.image_version_arn,
                image_version_status: self.image_version_status,
                last_modified_time: self.last_modified_time,
                version: self.version,
            }
        }
    }
}
impl DescribeImageVersionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeImageVersionOutput`](crate::output::DescribeImageVersionOutput)
    pub fn builder() -> crate::output::describe_image_version_output::Builder {
        crate::output::describe_image_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeImageOutput {
    /// <p>When the image was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The description of the image.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the image as displayed.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>When a create, update, or delete operation fails, the reason for the failure.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the image.</p>
    pub image_arn: std::option::Option<std::string::String>,
    /// <p>The name of the image.</p>
    pub image_name: std::option::Option<std::string::String>,
    /// <p>The status of the image.</p>
    pub image_status: std::option::Option<crate::model::ImageStatus>,
    /// <p>When the image was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role that enables Amazon SageMaker to perform tasks on your behalf.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl DescribeImageOutput {
    /// <p>When the image was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The description of the image.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The name of the image as displayed.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>When a create, update, or delete operation fails, the reason for the failure.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the image.</p>
    pub fn image_arn(&self) -> std::option::Option<&str> {
        self.image_arn.as_deref()
    }
    /// <p>The name of the image.</p>
    pub fn image_name(&self) -> std::option::Option<&str> {
        self.image_name.as_deref()
    }
    /// <p>The status of the image.</p>
    pub fn image_status(&self) -> std::option::Option<&crate::model::ImageStatus> {
        self.image_status.as_ref()
    }
    /// <p>When the image was last modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM role that enables Amazon SageMaker to perform tasks on your behalf.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeImageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeImageOutput");
        formatter.field("creation_time", &self.creation_time);
        formatter.field("description", &self.description);
        formatter.field("display_name", &self.display_name);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("image_arn", &self.image_arn);
        formatter.field("image_name", &self.image_name);
        formatter.field("image_status", &self.image_status);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`DescribeImageOutput`](crate::output::DescribeImageOutput)
pub mod describe_image_output {
    /// A builder for [`DescribeImageOutput`](crate::output::DescribeImageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) image_arn: std::option::Option<std::string::String>,
        pub(crate) image_name: std::option::Option<std::string::String>,
        pub(crate) image_status: std::option::Option<crate::model::ImageStatus>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>When the image was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the image was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The description of the image.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the image.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the image as displayed.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The name of the image as displayed.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>When a create, update, or delete operation fails, the reason for the failure.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>When a create, update, or delete operation fails, the reason for the failure.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image.</p>
        pub fn image_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image.</p>
        pub fn set_image_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_arn = input;
            self
        }
        /// <p>The name of the image.</p>
        pub fn image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_name = Some(input.into());
            self
        }
        /// <p>The name of the image.</p>
        pub fn set_image_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_name = input;
            self
        }
        /// <p>The status of the image.</p>
        pub fn image_status(mut self, input: crate::model::ImageStatus) -> Self {
            self.image_status = Some(input);
            self
        }
        /// <p>The status of the image.</p>
        pub fn set_image_status(
            mut self,
            input: std::option::Option<crate::model::ImageStatus>,
        ) -> Self {
            self.image_status = input;
            self
        }
        /// <p>When the image was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>When the image was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that enables Amazon SageMaker to perform tasks on your behalf.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that enables Amazon SageMaker to perform tasks on your behalf.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeImageOutput`](crate::output::DescribeImageOutput)
        pub fn build(self) -> crate::output::DescribeImageOutput {
            crate::output::DescribeImageOutput {
                creation_time: self.creation_time,
                description: self.description,
                display_name: self.display_name,
                failure_reason: self.failure_reason,
                image_arn: self.image_arn,
                image_name: self.image_name,
                image_status: self.image_status,
                last_modified_time: self.last_modified_time,
                role_arn: self.role_arn,
            }
        }
    }
}
impl DescribeImageOutput {
    /// Creates a new builder-style object to manufacture [`DescribeImageOutput`](crate::output::DescribeImageOutput)
    pub fn builder() -> crate::output::describe_image_output::Builder {
        crate::output::describe_image_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeHyperParameterTuningJobOutput {
    /// <p>The name of the tuning job.</p>
    pub hyper_parameter_tuning_job_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the tuning job.</p>
    pub hyper_parameter_tuning_job_arn: std::option::Option<std::string::String>,
    /// <p>The <code>HyperParameterTuningJobConfig</code> object that specifies the configuration of the tuning job.</p>
    pub hyper_parameter_tuning_job_config:
        std::option::Option<crate::model::HyperParameterTuningJobConfig>,
    /// <p>The <code>HyperParameterTrainingJobDefinition</code> object that specifies the definition of the training jobs that this tuning job launches.</p>
    pub training_job_definition:
        std::option::Option<crate::model::HyperParameterTrainingJobDefinition>,
    /// <p>A list of the <code>HyperParameterTrainingJobDefinition</code> objects launched for this tuning job.</p>
    pub training_job_definitions:
        std::option::Option<std::vec::Vec<crate::model::HyperParameterTrainingJobDefinition>>,
    /// <p>The status of the tuning job: InProgress, Completed, Failed, Stopping, or Stopped.</p>
    pub hyper_parameter_tuning_job_status:
        std::option::Option<crate::model::HyperParameterTuningJobStatus>,
    /// <p>The date and time that the tuning job started.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the tuning job ended.</p>
    pub hyper_parameter_tuning_end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the status of the tuning job was modified. </p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The <code>TrainingJobStatusCounters</code> object that specifies the number of training jobs, categorized by status, that this tuning job launched.</p>
    pub training_job_status_counters: std::option::Option<crate::model::TrainingJobStatusCounters>,
    /// <p>The <code>ObjectiveStatusCounters</code> object that specifies the number of training jobs, categorized by the status of their final objective metric, that this tuning job launched.</p>
    pub objective_status_counters: std::option::Option<crate::model::ObjectiveStatusCounters>,
    /// <p>A <code>TrainingJobSummary</code> object that describes the training job that completed with the best current <code>HyperParameterTuningJobObjective</code>.</p>
    pub best_training_job: std::option::Option<crate::model::HyperParameterTrainingJobSummary>,
    /// <p>If the hyperparameter tuning job is an warm start tuning job with a <code>WarmStartType</code> of <code>IDENTICAL_DATA_AND_ALGORITHM</code>, this is the <code>TrainingJobSummary</code> for the training job with the best objective metric value of all training jobs launched by this tuning job and all parent jobs specified for the warm start tuning job.</p>
    pub overall_best_training_job:
        std::option::Option<crate::model::HyperParameterTrainingJobSummary>,
    /// <p>The configuration for starting the hyperparameter parameter tuning job using one or more previous tuning jobs as a starting point. The results of previous tuning jobs are used to inform which combinations of hyperparameters to search over in the new tuning job.</p>
    pub warm_start_config:
        std::option::Option<crate::model::HyperParameterTuningJobWarmStartConfig>,
    /// <p>If the tuning job failed, the reason it failed.</p>
    pub failure_reason: std::option::Option<std::string::String>,
}
impl DescribeHyperParameterTuningJobOutput {
    /// <p>The name of the tuning job.</p>
    pub fn hyper_parameter_tuning_job_name(&self) -> std::option::Option<&str> {
        self.hyper_parameter_tuning_job_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the tuning job.</p>
    pub fn hyper_parameter_tuning_job_arn(&self) -> std::option::Option<&str> {
        self.hyper_parameter_tuning_job_arn.as_deref()
    }
    /// <p>The <code>HyperParameterTuningJobConfig</code> object that specifies the configuration of the tuning job.</p>
    pub fn hyper_parameter_tuning_job_config(
        &self,
    ) -> std::option::Option<&crate::model::HyperParameterTuningJobConfig> {
        self.hyper_parameter_tuning_job_config.as_ref()
    }
    /// <p>The <code>HyperParameterTrainingJobDefinition</code> object that specifies the definition of the training jobs that this tuning job launches.</p>
    pub fn training_job_definition(
        &self,
    ) -> std::option::Option<&crate::model::HyperParameterTrainingJobDefinition> {
        self.training_job_definition.as_ref()
    }
    /// <p>A list of the <code>HyperParameterTrainingJobDefinition</code> objects launched for this tuning job.</p>
    pub fn training_job_definitions(
        &self,
    ) -> std::option::Option<&[crate::model::HyperParameterTrainingJobDefinition]> {
        self.training_job_definitions.as_deref()
    }
    /// <p>The status of the tuning job: InProgress, Completed, Failed, Stopping, or Stopped.</p>
    pub fn hyper_parameter_tuning_job_status(
        &self,
    ) -> std::option::Option<&crate::model::HyperParameterTuningJobStatus> {
        self.hyper_parameter_tuning_job_status.as_ref()
    }
    /// <p>The date and time that the tuning job started.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The date and time that the tuning job ended.</p>
    pub fn hyper_parameter_tuning_end_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.hyper_parameter_tuning_end_time.as_ref()
    }
    /// <p>The date and time that the status of the tuning job was modified. </p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>The <code>TrainingJobStatusCounters</code> object that specifies the number of training jobs, categorized by status, that this tuning job launched.</p>
    pub fn training_job_status_counters(
        &self,
    ) -> std::option::Option<&crate::model::TrainingJobStatusCounters> {
        self.training_job_status_counters.as_ref()
    }
    /// <p>The <code>ObjectiveStatusCounters</code> object that specifies the number of training jobs, categorized by the status of their final objective metric, that this tuning job launched.</p>
    pub fn objective_status_counters(
        &self,
    ) -> std::option::Option<&crate::model::ObjectiveStatusCounters> {
        self.objective_status_counters.as_ref()
    }
    /// <p>A <code>TrainingJobSummary</code> object that describes the training job that completed with the best current <code>HyperParameterTuningJobObjective</code>.</p>
    pub fn best_training_job(
        &self,
    ) -> std::option::Option<&crate::model::HyperParameterTrainingJobSummary> {
        self.best_training_job.as_ref()
    }
    /// <p>If the hyperparameter tuning job is an warm start tuning job with a <code>WarmStartType</code> of <code>IDENTICAL_DATA_AND_ALGORITHM</code>, this is the <code>TrainingJobSummary</code> for the training job with the best objective metric value of all training jobs launched by this tuning job and all parent jobs specified for the warm start tuning job.</p>
    pub fn overall_best_training_job(
        &self,
    ) -> std::option::Option<&crate::model::HyperParameterTrainingJobSummary> {
        self.overall_best_training_job.as_ref()
    }
    /// <p>The configuration for starting the hyperparameter parameter tuning job using one or more previous tuning jobs as a starting point. The results of previous tuning jobs are used to inform which combinations of hyperparameters to search over in the new tuning job.</p>
    pub fn warm_start_config(
        &self,
    ) -> std::option::Option<&crate::model::HyperParameterTuningJobWarmStartConfig> {
        self.warm_start_config.as_ref()
    }
    /// <p>If the tuning job failed, the reason it failed.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
}
impl std::fmt::Debug for DescribeHyperParameterTuningJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeHyperParameterTuningJobOutput");
        formatter.field(
            "hyper_parameter_tuning_job_name",
            &self.hyper_parameter_tuning_job_name,
        );
        formatter.field(
            "hyper_parameter_tuning_job_arn",
            &self.hyper_parameter_tuning_job_arn,
        );
        formatter.field(
            "hyper_parameter_tuning_job_config",
            &self.hyper_parameter_tuning_job_config,
        );
        formatter.field("training_job_definition", &self.training_job_definition);
        formatter.field("training_job_definitions", &self.training_job_definitions);
        formatter.field(
            "hyper_parameter_tuning_job_status",
            &self.hyper_parameter_tuning_job_status,
        );
        formatter.field("creation_time", &self.creation_time);
        formatter.field(
            "hyper_parameter_tuning_end_time",
            &self.hyper_parameter_tuning_end_time,
        );
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field(
            "training_job_status_counters",
            &self.training_job_status_counters,
        );
        formatter.field("objective_status_counters", &self.objective_status_counters);
        formatter.field("best_training_job", &self.best_training_job);
        formatter.field("overall_best_training_job", &self.overall_best_training_job);
        formatter.field("warm_start_config", &self.warm_start_config);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.finish()
    }
}
/// See [`DescribeHyperParameterTuningJobOutput`](crate::output::DescribeHyperParameterTuningJobOutput)
pub mod describe_hyper_parameter_tuning_job_output {
    /// A builder for [`DescribeHyperParameterTuningJobOutput`](crate::output::DescribeHyperParameterTuningJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hyper_parameter_tuning_job_name: std::option::Option<std::string::String>,
        pub(crate) hyper_parameter_tuning_job_arn: std::option::Option<std::string::String>,
        pub(crate) hyper_parameter_tuning_job_config:
            std::option::Option<crate::model::HyperParameterTuningJobConfig>,
        pub(crate) training_job_definition:
            std::option::Option<crate::model::HyperParameterTrainingJobDefinition>,
        pub(crate) training_job_definitions:
            std::option::Option<std::vec::Vec<crate::model::HyperParameterTrainingJobDefinition>>,
        pub(crate) hyper_parameter_tuning_job_status:
            std::option::Option<crate::model::HyperParameterTuningJobStatus>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) hyper_parameter_tuning_end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) training_job_status_counters:
            std::option::Option<crate::model::TrainingJobStatusCounters>,
        pub(crate) objective_status_counters:
            std::option::Option<crate::model::ObjectiveStatusCounters>,
        pub(crate) best_training_job:
            std::option::Option<crate::model::HyperParameterTrainingJobSummary>,
        pub(crate) overall_best_training_job:
            std::option::Option<crate::model::HyperParameterTrainingJobSummary>,
        pub(crate) warm_start_config:
            std::option::Option<crate::model::HyperParameterTuningJobWarmStartConfig>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the tuning job.</p>
        pub fn hyper_parameter_tuning_job_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.hyper_parameter_tuning_job_name = Some(input.into());
            self
        }
        /// <p>The name of the tuning job.</p>
        pub fn set_hyper_parameter_tuning_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hyper_parameter_tuning_job_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the tuning job.</p>
        pub fn hyper_parameter_tuning_job_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.hyper_parameter_tuning_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the tuning job.</p>
        pub fn set_hyper_parameter_tuning_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hyper_parameter_tuning_job_arn = input;
            self
        }
        /// <p>The <code>HyperParameterTuningJobConfig</code> object that specifies the configuration of the tuning job.</p>
        pub fn hyper_parameter_tuning_job_config(
            mut self,
            input: crate::model::HyperParameterTuningJobConfig,
        ) -> Self {
            self.hyper_parameter_tuning_job_config = Some(input);
            self
        }
        /// <p>The <code>HyperParameterTuningJobConfig</code> object that specifies the configuration of the tuning job.</p>
        pub fn set_hyper_parameter_tuning_job_config(
            mut self,
            input: std::option::Option<crate::model::HyperParameterTuningJobConfig>,
        ) -> Self {
            self.hyper_parameter_tuning_job_config = input;
            self
        }
        /// <p>The <code>HyperParameterTrainingJobDefinition</code> object that specifies the definition of the training jobs that this tuning job launches.</p>
        pub fn training_job_definition(
            mut self,
            input: crate::model::HyperParameterTrainingJobDefinition,
        ) -> Self {
            self.training_job_definition = Some(input);
            self
        }
        /// <p>The <code>HyperParameterTrainingJobDefinition</code> object that specifies the definition of the training jobs that this tuning job launches.</p>
        pub fn set_training_job_definition(
            mut self,
            input: std::option::Option<crate::model::HyperParameterTrainingJobDefinition>,
        ) -> Self {
            self.training_job_definition = input;
            self
        }
        /// Appends an item to `training_job_definitions`.
        ///
        /// To override the contents of this collection use [`set_training_job_definitions`](Self::set_training_job_definitions).
        ///
        /// <p>A list of the <code>HyperParameterTrainingJobDefinition</code> objects launched for this tuning job.</p>
        pub fn training_job_definitions(
            mut self,
            input: crate::model::HyperParameterTrainingJobDefinition,
        ) -> Self {
            let mut v = self.training_job_definitions.unwrap_or_default();
            v.push(input);
            self.training_job_definitions = Some(v);
            self
        }
        /// <p>A list of the <code>HyperParameterTrainingJobDefinition</code> objects launched for this tuning job.</p>
        pub fn set_training_job_definitions(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::HyperParameterTrainingJobDefinition>,
            >,
        ) -> Self {
            self.training_job_definitions = input;
            self
        }
        /// <p>The status of the tuning job: InProgress, Completed, Failed, Stopping, or Stopped.</p>
        pub fn hyper_parameter_tuning_job_status(
            mut self,
            input: crate::model::HyperParameterTuningJobStatus,
        ) -> Self {
            self.hyper_parameter_tuning_job_status = Some(input);
            self
        }
        /// <p>The status of the tuning job: InProgress, Completed, Failed, Stopping, or Stopped.</p>
        pub fn set_hyper_parameter_tuning_job_status(
            mut self,
            input: std::option::Option<crate::model::HyperParameterTuningJobStatus>,
        ) -> Self {
            self.hyper_parameter_tuning_job_status = input;
            self
        }
        /// <p>The date and time that the tuning job started.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The date and time that the tuning job started.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The date and time that the tuning job ended.</p>
        pub fn hyper_parameter_tuning_end_time(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.hyper_parameter_tuning_end_time = Some(input);
            self
        }
        /// <p>The date and time that the tuning job ended.</p>
        pub fn set_hyper_parameter_tuning_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.hyper_parameter_tuning_end_time = input;
            self
        }
        /// <p>The date and time that the status of the tuning job was modified. </p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The date and time that the status of the tuning job was modified. </p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>The <code>TrainingJobStatusCounters</code> object that specifies the number of training jobs, categorized by status, that this tuning job launched.</p>
        pub fn training_job_status_counters(
            mut self,
            input: crate::model::TrainingJobStatusCounters,
        ) -> Self {
            self.training_job_status_counters = Some(input);
            self
        }
        /// <p>The <code>TrainingJobStatusCounters</code> object that specifies the number of training jobs, categorized by status, that this tuning job launched.</p>
        pub fn set_training_job_status_counters(
            mut self,
            input: std::option::Option<crate::model::TrainingJobStatusCounters>,
        ) -> Self {
            self.training_job_status_counters = input;
            self
        }
        /// <p>The <code>ObjectiveStatusCounters</code> object that specifies the number of training jobs, categorized by the status of their final objective metric, that this tuning job launched.</p>
        pub fn objective_status_counters(
            mut self,
            input: crate::model::ObjectiveStatusCounters,
        ) -> Self {
            self.objective_status_counters = Some(input);
            self
        }
        /// <p>The <code>ObjectiveStatusCounters</code> object that specifies the number of training jobs, categorized by the status of their final objective metric, that this tuning job launched.</p>
        pub fn set_objective_status_counters(
            mut self,
            input: std::option::Option<crate::model::ObjectiveStatusCounters>,
        ) -> Self {
            self.objective_status_counters = input;
            self
        }
        /// <p>A <code>TrainingJobSummary</code> object that describes the training job that completed with the best current <code>HyperParameterTuningJobObjective</code>.</p>
        pub fn best_training_job(
            mut self,
            input: crate::model::HyperParameterTrainingJobSummary,
        ) -> Self {
            self.best_training_job = Some(input);
            self
        }
        /// <p>A <code>TrainingJobSummary</code> object that describes the training job that completed with the best current <code>HyperParameterTuningJobObjective</code>.</p>
        pub fn set_best_training_job(
            mut self,
            input: std::option::Option<crate::model::HyperParameterTrainingJobSummary>,
        ) -> Self {
            self.best_training_job = input;
            self
        }
        /// <p>If the hyperparameter tuning job is an warm start tuning job with a <code>WarmStartType</code> of <code>IDENTICAL_DATA_AND_ALGORITHM</code>, this is the <code>TrainingJobSummary</code> for the training job with the best objective metric value of all training jobs launched by this tuning job and all parent jobs specified for the warm start tuning job.</p>
        pub fn overall_best_training_job(
            mut self,
            input: crate::model::HyperParameterTrainingJobSummary,
        ) -> Self {
            self.overall_best_training_job = Some(input);
            self
        }
        /// <p>If the hyperparameter tuning job is an warm start tuning job with a <code>WarmStartType</code> of <code>IDENTICAL_DATA_AND_ALGORITHM</code>, this is the <code>TrainingJobSummary</code> for the training job with the best objective metric value of all training jobs launched by this tuning job and all parent jobs specified for the warm start tuning job.</p>
        pub fn set_overall_best_training_job(
            mut self,
            input: std::option::Option<crate::model::HyperParameterTrainingJobSummary>,
        ) -> Self {
            self.overall_best_training_job = input;
            self
        }
        /// <p>The configuration for starting the hyperparameter parameter tuning job using one or more previous tuning jobs as a starting point. The results of previous tuning jobs are used to inform which combinations of hyperparameters to search over in the new tuning job.</p>
        pub fn warm_start_config(
            mut self,
            input: crate::model::HyperParameterTuningJobWarmStartConfig,
        ) -> Self {
            self.warm_start_config = Some(input);
            self
        }
        /// <p>The configuration for starting the hyperparameter parameter tuning job using one or more previous tuning jobs as a starting point. The results of previous tuning jobs are used to inform which combinations of hyperparameters to search over in the new tuning job.</p>
        pub fn set_warm_start_config(
            mut self,
            input: std::option::Option<crate::model::HyperParameterTuningJobWarmStartConfig>,
        ) -> Self {
            self.warm_start_config = input;
            self
        }
        /// <p>If the tuning job failed, the reason it failed.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If the tuning job failed, the reason it failed.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeHyperParameterTuningJobOutput`](crate::output::DescribeHyperParameterTuningJobOutput)
        pub fn build(self) -> crate::output::DescribeHyperParameterTuningJobOutput {
            crate::output::DescribeHyperParameterTuningJobOutput {
                hyper_parameter_tuning_job_name: self.hyper_parameter_tuning_job_name,
                hyper_parameter_tuning_job_arn: self.hyper_parameter_tuning_job_arn,
                hyper_parameter_tuning_job_config: self.hyper_parameter_tuning_job_config,
                training_job_definition: self.training_job_definition,
                training_job_definitions: self.training_job_definitions,
                hyper_parameter_tuning_job_status: self.hyper_parameter_tuning_job_status,
                creation_time: self.creation_time,
                hyper_parameter_tuning_end_time: self.hyper_parameter_tuning_end_time,
                last_modified_time: self.last_modified_time,
                training_job_status_counters: self.training_job_status_counters,
                objective_status_counters: self.objective_status_counters,
                best_training_job: self.best_training_job,
                overall_best_training_job: self.overall_best_training_job,
                warm_start_config: self.warm_start_config,
                failure_reason: self.failure_reason,
            }
        }
    }
}
impl DescribeHyperParameterTuningJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeHyperParameterTuningJobOutput`](crate::output::DescribeHyperParameterTuningJobOutput)
    pub fn builder() -> crate::output::describe_hyper_parameter_tuning_job_output::Builder {
        crate::output::describe_hyper_parameter_tuning_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeHumanTaskUiOutput {
    /// <p>The Amazon Resource Name (ARN) of the human task user interface (worker task template).</p>
    pub human_task_ui_arn: std::option::Option<std::string::String>,
    /// <p>The name of the human task user interface (worker task template).</p>
    pub human_task_ui_name: std::option::Option<std::string::String>,
    /// <p>The status of the human task user interface (worker task template). Valid values are listed below.</p>
    pub human_task_ui_status: std::option::Option<crate::model::HumanTaskUiStatus>,
    /// <p>The timestamp when the human task user interface was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Container for user interface template information.</p>
    pub ui_template: std::option::Option<crate::model::UiTemplateInfo>,
}
impl DescribeHumanTaskUiOutput {
    /// <p>The Amazon Resource Name (ARN) of the human task user interface (worker task template).</p>
    pub fn human_task_ui_arn(&self) -> std::option::Option<&str> {
        self.human_task_ui_arn.as_deref()
    }
    /// <p>The name of the human task user interface (worker task template).</p>
    pub fn human_task_ui_name(&self) -> std::option::Option<&str> {
        self.human_task_ui_name.as_deref()
    }
    /// <p>The status of the human task user interface (worker task template). Valid values are listed below.</p>
    pub fn human_task_ui_status(&self) -> std::option::Option<&crate::model::HumanTaskUiStatus> {
        self.human_task_ui_status.as_ref()
    }
    /// <p>The timestamp when the human task user interface was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>Container for user interface template information.</p>
    pub fn ui_template(&self) -> std::option::Option<&crate::model::UiTemplateInfo> {
        self.ui_template.as_ref()
    }
}
impl std::fmt::Debug for DescribeHumanTaskUiOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeHumanTaskUiOutput");
        formatter.field("human_task_ui_arn", &self.human_task_ui_arn);
        formatter.field("human_task_ui_name", &self.human_task_ui_name);
        formatter.field("human_task_ui_status", &self.human_task_ui_status);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("ui_template", &self.ui_template);
        formatter.finish()
    }
}
/// See [`DescribeHumanTaskUiOutput`](crate::output::DescribeHumanTaskUiOutput)
pub mod describe_human_task_ui_output {
    /// A builder for [`DescribeHumanTaskUiOutput`](crate::output::DescribeHumanTaskUiOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) human_task_ui_arn: std::option::Option<std::string::String>,
        pub(crate) human_task_ui_name: std::option::Option<std::string::String>,
        pub(crate) human_task_ui_status: std::option::Option<crate::model::HumanTaskUiStatus>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) ui_template: std::option::Option<crate::model::UiTemplateInfo>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the human task user interface (worker task template).</p>
        pub fn human_task_ui_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.human_task_ui_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the human task user interface (worker task template).</p>
        pub fn set_human_task_ui_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.human_task_ui_arn = input;
            self
        }
        /// <p>The name of the human task user interface (worker task template).</p>
        pub fn human_task_ui_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.human_task_ui_name = Some(input.into());
            self
        }
        /// <p>The name of the human task user interface (worker task template).</p>
        pub fn set_human_task_ui_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.human_task_ui_name = input;
            self
        }
        /// <p>The status of the human task user interface (worker task template). Valid values are listed below.</p>
        pub fn human_task_ui_status(mut self, input: crate::model::HumanTaskUiStatus) -> Self {
            self.human_task_ui_status = Some(input);
            self
        }
        /// <p>The status of the human task user interface (worker task template). Valid values are listed below.</p>
        pub fn set_human_task_ui_status(
            mut self,
            input: std::option::Option<crate::model::HumanTaskUiStatus>,
        ) -> Self {
            self.human_task_ui_status = input;
            self
        }
        /// <p>The timestamp when the human task user interface was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The timestamp when the human task user interface was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>Container for user interface template information.</p>
        pub fn ui_template(mut self, input: crate::model::UiTemplateInfo) -> Self {
            self.ui_template = Some(input);
            self
        }
        /// <p>Container for user interface template information.</p>
        pub fn set_ui_template(
            mut self,
            input: std::option::Option<crate::model::UiTemplateInfo>,
        ) -> Self {
            self.ui_template = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeHumanTaskUiOutput`](crate::output::DescribeHumanTaskUiOutput)
        pub fn build(self) -> crate::output::DescribeHumanTaskUiOutput {
            crate::output::DescribeHumanTaskUiOutput {
                human_task_ui_arn: self.human_task_ui_arn,
                human_task_ui_name: self.human_task_ui_name,
                human_task_ui_status: self.human_task_ui_status,
                creation_time: self.creation_time,
                ui_template: self.ui_template,
            }
        }
    }
}
impl DescribeHumanTaskUiOutput {
    /// Creates a new builder-style object to manufacture [`DescribeHumanTaskUiOutput`](crate::output::DescribeHumanTaskUiOutput)
    pub fn builder() -> crate::output::describe_human_task_ui_output::Builder {
        crate::output::describe_human_task_ui_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFlowDefinitionOutput {
    /// <p>The Amazon Resource Name (ARN) of the flow defintion.</p>
    pub flow_definition_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the flow definition.</p>
    pub flow_definition_name: std::option::Option<std::string::String>,
    /// <p>The status of the flow definition. Valid values are listed below.</p>
    pub flow_definition_status: std::option::Option<crate::model::FlowDefinitionStatus>,
    /// <p>The timestamp when the flow definition was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Container for configuring the source of human task requests. Used to specify if Amazon Rekognition or Amazon Textract is used as an integration source.</p>
    pub human_loop_request_source: std::option::Option<crate::model::HumanLoopRequestSource>,
    /// <p>An object containing information about what triggers a human review workflow.</p>
    pub human_loop_activation_config: std::option::Option<crate::model::HumanLoopActivationConfig>,
    /// <p>An object containing information about who works on the task, the workforce task price, and other task details.</p>
    pub human_loop_config: std::option::Option<crate::model::HumanLoopConfig>,
    /// <p>An object containing information about the output file.</p>
    pub output_config: std::option::Option<crate::model::FlowDefinitionOutputConfig>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) execution role for the flow definition.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The reason your flow definition failed.</p>
    pub failure_reason: std::option::Option<std::string::String>,
}
impl DescribeFlowDefinitionOutput {
    /// <p>The Amazon Resource Name (ARN) of the flow defintion.</p>
    pub fn flow_definition_arn(&self) -> std::option::Option<&str> {
        self.flow_definition_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the flow definition.</p>
    pub fn flow_definition_name(&self) -> std::option::Option<&str> {
        self.flow_definition_name.as_deref()
    }
    /// <p>The status of the flow definition. Valid values are listed below.</p>
    pub fn flow_definition_status(
        &self,
    ) -> std::option::Option<&crate::model::FlowDefinitionStatus> {
        self.flow_definition_status.as_ref()
    }
    /// <p>The timestamp when the flow definition was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>Container for configuring the source of human task requests. Used to specify if Amazon Rekognition or Amazon Textract is used as an integration source.</p>
    pub fn human_loop_request_source(
        &self,
    ) -> std::option::Option<&crate::model::HumanLoopRequestSource> {
        self.human_loop_request_source.as_ref()
    }
    /// <p>An object containing information about what triggers a human review workflow.</p>
    pub fn human_loop_activation_config(
        &self,
    ) -> std::option::Option<&crate::model::HumanLoopActivationConfig> {
        self.human_loop_activation_config.as_ref()
    }
    /// <p>An object containing information about who works on the task, the workforce task price, and other task details.</p>
    pub fn human_loop_config(&self) -> std::option::Option<&crate::model::HumanLoopConfig> {
        self.human_loop_config.as_ref()
    }
    /// <p>An object containing information about the output file.</p>
    pub fn output_config(&self) -> std::option::Option<&crate::model::FlowDefinitionOutputConfig> {
        self.output_config.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) execution role for the flow definition.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The reason your flow definition failed.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
}
impl std::fmt::Debug for DescribeFlowDefinitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFlowDefinitionOutput");
        formatter.field("flow_definition_arn", &self.flow_definition_arn);
        formatter.field("flow_definition_name", &self.flow_definition_name);
        formatter.field("flow_definition_status", &self.flow_definition_status);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("human_loop_request_source", &self.human_loop_request_source);
        formatter.field(
            "human_loop_activation_config",
            &self.human_loop_activation_config,
        );
        formatter.field("human_loop_config", &self.human_loop_config);
        formatter.field("output_config", &self.output_config);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.finish()
    }
}
/// See [`DescribeFlowDefinitionOutput`](crate::output::DescribeFlowDefinitionOutput)
pub mod describe_flow_definition_output {
    /// A builder for [`DescribeFlowDefinitionOutput`](crate::output::DescribeFlowDefinitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_definition_arn: std::option::Option<std::string::String>,
        pub(crate) flow_definition_name: std::option::Option<std::string::String>,
        pub(crate) flow_definition_status: std::option::Option<crate::model::FlowDefinitionStatus>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) human_loop_request_source:
            std::option::Option<crate::model::HumanLoopRequestSource>,
        pub(crate) human_loop_activation_config:
            std::option::Option<crate::model::HumanLoopActivationConfig>,
        pub(crate) human_loop_config: std::option::Option<crate::model::HumanLoopConfig>,
        pub(crate) output_config: std::option::Option<crate::model::FlowDefinitionOutputConfig>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the flow defintion.</p>
        pub fn flow_definition_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_definition_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the flow defintion.</p>
        pub fn set_flow_definition_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.flow_definition_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the flow definition.</p>
        pub fn flow_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_definition_name = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the flow definition.</p>
        pub fn set_flow_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.flow_definition_name = input;
            self
        }
        /// <p>The status of the flow definition. Valid values are listed below.</p>
        pub fn flow_definition_status(mut self, input: crate::model::FlowDefinitionStatus) -> Self {
            self.flow_definition_status = Some(input);
            self
        }
        /// <p>The status of the flow definition. Valid values are listed below.</p>
        pub fn set_flow_definition_status(
            mut self,
            input: std::option::Option<crate::model::FlowDefinitionStatus>,
        ) -> Self {
            self.flow_definition_status = input;
            self
        }
        /// <p>The timestamp when the flow definition was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The timestamp when the flow definition was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>Container for configuring the source of human task requests. Used to specify if Amazon Rekognition or Amazon Textract is used as an integration source.</p>
        pub fn human_loop_request_source(
            mut self,
            input: crate::model::HumanLoopRequestSource,
        ) -> Self {
            self.human_loop_request_source = Some(input);
            self
        }
        /// <p>Container for configuring the source of human task requests. Used to specify if Amazon Rekognition or Amazon Textract is used as an integration source.</p>
        pub fn set_human_loop_request_source(
            mut self,
            input: std::option::Option<crate::model::HumanLoopRequestSource>,
        ) -> Self {
            self.human_loop_request_source = input;
            self
        }
        /// <p>An object containing information about what triggers a human review workflow.</p>
        pub fn human_loop_activation_config(
            mut self,
            input: crate::model::HumanLoopActivationConfig,
        ) -> Self {
            self.human_loop_activation_config = Some(input);
            self
        }
        /// <p>An object containing information about what triggers a human review workflow.</p>
        pub fn set_human_loop_activation_config(
            mut self,
            input: std::option::Option<crate::model::HumanLoopActivationConfig>,
        ) -> Self {
            self.human_loop_activation_config = input;
            self
        }
        /// <p>An object containing information about who works on the task, the workforce task price, and other task details.</p>
        pub fn human_loop_config(mut self, input: crate::model::HumanLoopConfig) -> Self {
            self.human_loop_config = Some(input);
            self
        }
        /// <p>An object containing information about who works on the task, the workforce task price, and other task details.</p>
        pub fn set_human_loop_config(
            mut self,
            input: std::option::Option<crate::model::HumanLoopConfig>,
        ) -> Self {
            self.human_loop_config = input;
            self
        }
        /// <p>An object containing information about the output file.</p>
        pub fn output_config(mut self, input: crate::model::FlowDefinitionOutputConfig) -> Self {
            self.output_config = Some(input);
            self
        }
        /// <p>An object containing information about the output file.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::FlowDefinitionOutputConfig>,
        ) -> Self {
            self.output_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) execution role for the flow definition.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) execution role for the flow definition.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The reason your flow definition failed.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>The reason your flow definition failed.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFlowDefinitionOutput`](crate::output::DescribeFlowDefinitionOutput)
        pub fn build(self) -> crate::output::DescribeFlowDefinitionOutput {
            crate::output::DescribeFlowDefinitionOutput {
                flow_definition_arn: self.flow_definition_arn,
                flow_definition_name: self.flow_definition_name,
                flow_definition_status: self.flow_definition_status,
                creation_time: self.creation_time,
                human_loop_request_source: self.human_loop_request_source,
                human_loop_activation_config: self.human_loop_activation_config,
                human_loop_config: self.human_loop_config,
                output_config: self.output_config,
                role_arn: self.role_arn,
                failure_reason: self.failure_reason,
            }
        }
    }
}
impl DescribeFlowDefinitionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFlowDefinitionOutput`](crate::output::DescribeFlowDefinitionOutput)
    pub fn builder() -> crate::output::describe_flow_definition_output::Builder {
        crate::output::describe_flow_definition_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFeatureGroupOutput {
    /// <p>The Amazon Resource Name (ARN) of the <code>FeatureGroup</code>. </p>
    pub feature_group_arn: std::option::Option<std::string::String>,
    /// <p>he name of the <code>FeatureGroup</code>.</p>
    pub feature_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the <code>Feature</code> used for <code>RecordIdentifier</code>, whose value uniquely identifies a record stored in the feature store.</p>
    pub record_identifier_feature_name: std::option::Option<std::string::String>,
    /// <p>The name of the feature that stores the <code>EventTime</code> of a Record in a <code>FeatureGroup</code>.</p>
    /// <p> An <code>EventTime</code> is a point in time when a new event occurs that corresponds to the creation or update of a <code>Record</code> in a <code>FeatureGroup</code>. All <code>Records</code> in the <code>FeatureGroup</code> have a corresponding <code>EventTime</code>.</p>
    pub event_time_feature_name: std::option::Option<std::string::String>,
    /// <p>A list of the <code>Features</code> in the <code>FeatureGroup</code>. Each feature is defined by a <code>FeatureName</code> and <code>FeatureType</code>.</p>
    pub feature_definitions: std::option::Option<std::vec::Vec<crate::model::FeatureDefinition>>,
    /// <p>A timestamp indicating when SageMaker created the <code>FeatureGroup</code>.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The configuration for the <code>OnlineStore</code>.</p>
    pub online_store_config: std::option::Option<crate::model::OnlineStoreConfig>,
    /// <p>The configuration of the <code>OfflineStore</code>, inducing the S3 location of the <code>OfflineStore</code>, Amazon Web Services Glue or Amazon Web Services Hive data catalogue configurations, and the security configuration.</p>
    pub offline_store_config: std::option::Option<crate::model::OfflineStoreConfig>,
    /// <p>The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the <code>OfflineStore</code> if an <code>OfflineStoreConfig</code> is provided.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The status of the feature group.</p>
    pub feature_group_status: std::option::Option<crate::model::FeatureGroupStatus>,
    /// <p>The status of the <code>OfflineStore</code>. Notifies you if replicating data into the <code>OfflineStore</code> has failed. Returns either: <code>Active</code> or <code>Blocked</code> </p>
    pub offline_store_status: std::option::Option<crate::model::OfflineStoreStatus>,
    /// <p>The reason that the <code>FeatureGroup</code> failed to be replicated in the <code>OfflineStore</code>. This is failure can occur because:</p>
    /// <ul>
    /// <li> <p>The <code>FeatureGroup</code> could not be created in the <code>OfflineStore</code>.</p> </li>
    /// <li> <p>The <code>FeatureGroup</code> could not be deleted from the <code>OfflineStore</code>.</p> </li>
    /// </ul>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>A free form description of the feature group.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A token to resume pagination of the list of <code>Features</code> (<code>FeatureDefinitions</code>).</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeFeatureGroupOutput {
    /// <p>The Amazon Resource Name (ARN) of the <code>FeatureGroup</code>. </p>
    pub fn feature_group_arn(&self) -> std::option::Option<&str> {
        self.feature_group_arn.as_deref()
    }
    /// <p>he name of the <code>FeatureGroup</code>.</p>
    pub fn feature_group_name(&self) -> std::option::Option<&str> {
        self.feature_group_name.as_deref()
    }
    /// <p>The name of the <code>Feature</code> used for <code>RecordIdentifier</code>, whose value uniquely identifies a record stored in the feature store.</p>
    pub fn record_identifier_feature_name(&self) -> std::option::Option<&str> {
        self.record_identifier_feature_name.as_deref()
    }
    /// <p>The name of the feature that stores the <code>EventTime</code> of a Record in a <code>FeatureGroup</code>.</p>
    /// <p> An <code>EventTime</code> is a point in time when a new event occurs that corresponds to the creation or update of a <code>Record</code> in a <code>FeatureGroup</code>. All <code>Records</code> in the <code>FeatureGroup</code> have a corresponding <code>EventTime</code>.</p>
    pub fn event_time_feature_name(&self) -> std::option::Option<&str> {
        self.event_time_feature_name.as_deref()
    }
    /// <p>A list of the <code>Features</code> in the <code>FeatureGroup</code>. Each feature is defined by a <code>FeatureName</code> and <code>FeatureType</code>.</p>
    pub fn feature_definitions(&self) -> std::option::Option<&[crate::model::FeatureDefinition]> {
        self.feature_definitions.as_deref()
    }
    /// <p>A timestamp indicating when SageMaker created the <code>FeatureGroup</code>.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The configuration for the <code>OnlineStore</code>.</p>
    pub fn online_store_config(&self) -> std::option::Option<&crate::model::OnlineStoreConfig> {
        self.online_store_config.as_ref()
    }
    /// <p>The configuration of the <code>OfflineStore</code>, inducing the S3 location of the <code>OfflineStore</code>, Amazon Web Services Glue or Amazon Web Services Hive data catalogue configurations, and the security configuration.</p>
    pub fn offline_store_config(&self) -> std::option::Option<&crate::model::OfflineStoreConfig> {
        self.offline_store_config.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the <code>OfflineStore</code> if an <code>OfflineStoreConfig</code> is provided.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The status of the feature group.</p>
    pub fn feature_group_status(&self) -> std::option::Option<&crate::model::FeatureGroupStatus> {
        self.feature_group_status.as_ref()
    }
    /// <p>The status of the <code>OfflineStore</code>. Notifies you if replicating data into the <code>OfflineStore</code> has failed. Returns either: <code>Active</code> or <code>Blocked</code> </p>
    pub fn offline_store_status(&self) -> std::option::Option<&crate::model::OfflineStoreStatus> {
        self.offline_store_status.as_ref()
    }
    /// <p>The reason that the <code>FeatureGroup</code> failed to be replicated in the <code>OfflineStore</code>. This is failure can occur because:</p>
    /// <ul>
    /// <li> <p>The <code>FeatureGroup</code> could not be created in the <code>OfflineStore</code>.</p> </li>
    /// <li> <p>The <code>FeatureGroup</code> could not be deleted from the <code>OfflineStore</code>.</p> </li>
    /// </ul>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>A free form description of the feature group.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A token to resume pagination of the list of <code>Features</code> (<code>FeatureDefinitions</code>).</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeFeatureGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFeatureGroupOutput");
        formatter.field("feature_group_arn", &self.feature_group_arn);
        formatter.field("feature_group_name", &self.feature_group_name);
        formatter.field(
            "record_identifier_feature_name",
            &self.record_identifier_feature_name,
        );
        formatter.field("event_time_feature_name", &self.event_time_feature_name);
        formatter.field("feature_definitions", &self.feature_definitions);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("online_store_config", &self.online_store_config);
        formatter.field("offline_store_config", &self.offline_store_config);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("feature_group_status", &self.feature_group_status);
        formatter.field("offline_store_status", &self.offline_store_status);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("description", &self.description);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeFeatureGroupOutput`](crate::output::DescribeFeatureGroupOutput)
pub mod describe_feature_group_output {
    /// A builder for [`DescribeFeatureGroupOutput`](crate::output::DescribeFeatureGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) feature_group_arn: std::option::Option<std::string::String>,
        pub(crate) feature_group_name: std::option::Option<std::string::String>,
        pub(crate) record_identifier_feature_name: std::option::Option<std::string::String>,
        pub(crate) event_time_feature_name: std::option::Option<std::string::String>,
        pub(crate) feature_definitions:
            std::option::Option<std::vec::Vec<crate::model::FeatureDefinition>>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) online_store_config: std::option::Option<crate::model::OnlineStoreConfig>,
        pub(crate) offline_store_config: std::option::Option<crate::model::OfflineStoreConfig>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) feature_group_status: std::option::Option<crate::model::FeatureGroupStatus>,
        pub(crate) offline_store_status: std::option::Option<crate::model::OfflineStoreStatus>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the <code>FeatureGroup</code>. </p>
        pub fn feature_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.feature_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the <code>FeatureGroup</code>. </p>
        pub fn set_feature_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.feature_group_arn = input;
            self
        }
        /// <p>he name of the <code>FeatureGroup</code>.</p>
        pub fn feature_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.feature_group_name = Some(input.into());
            self
        }
        /// <p>he name of the <code>FeatureGroup</code>.</p>
        pub fn set_feature_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.feature_group_name = input;
            self
        }
        /// <p>The name of the <code>Feature</code> used for <code>RecordIdentifier</code>, whose value uniquely identifies a record stored in the feature store.</p>
        pub fn record_identifier_feature_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.record_identifier_feature_name = Some(input.into());
            self
        }
        /// <p>The name of the <code>Feature</code> used for <code>RecordIdentifier</code>, whose value uniquely identifies a record stored in the feature store.</p>
        pub fn set_record_identifier_feature_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.record_identifier_feature_name = input;
            self
        }
        /// <p>The name of the feature that stores the <code>EventTime</code> of a Record in a <code>FeatureGroup</code>.</p>
        /// <p> An <code>EventTime</code> is a point in time when a new event occurs that corresponds to the creation or update of a <code>Record</code> in a <code>FeatureGroup</code>. All <code>Records</code> in the <code>FeatureGroup</code> have a corresponding <code>EventTime</code>.</p>
        pub fn event_time_feature_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_time_feature_name = Some(input.into());
            self
        }
        /// <p>The name of the feature that stores the <code>EventTime</code> of a Record in a <code>FeatureGroup</code>.</p>
        /// <p> An <code>EventTime</code> is a point in time when a new event occurs that corresponds to the creation or update of a <code>Record</code> in a <code>FeatureGroup</code>. All <code>Records</code> in the <code>FeatureGroup</code> have a corresponding <code>EventTime</code>.</p>
        pub fn set_event_time_feature_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_time_feature_name = input;
            self
        }
        /// Appends an item to `feature_definitions`.
        ///
        /// To override the contents of this collection use [`set_feature_definitions`](Self::set_feature_definitions).
        ///
        /// <p>A list of the <code>Features</code> in the <code>FeatureGroup</code>. Each feature is defined by a <code>FeatureName</code> and <code>FeatureType</code>.</p>
        pub fn feature_definitions(mut self, input: crate::model::FeatureDefinition) -> Self {
            let mut v = self.feature_definitions.unwrap_or_default();
            v.push(input);
            self.feature_definitions = Some(v);
            self
        }
        /// <p>A list of the <code>Features</code> in the <code>FeatureGroup</code>. Each feature is defined by a <code>FeatureName</code> and <code>FeatureType</code>.</p>
        pub fn set_feature_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FeatureDefinition>>,
        ) -> Self {
            self.feature_definitions = input;
            self
        }
        /// <p>A timestamp indicating when SageMaker created the <code>FeatureGroup</code>.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A timestamp indicating when SageMaker created the <code>FeatureGroup</code>.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The configuration for the <code>OnlineStore</code>.</p>
        pub fn online_store_config(mut self, input: crate::model::OnlineStoreConfig) -> Self {
            self.online_store_config = Some(input);
            self
        }
        /// <p>The configuration for the <code>OnlineStore</code>.</p>
        pub fn set_online_store_config(
            mut self,
            input: std::option::Option<crate::model::OnlineStoreConfig>,
        ) -> Self {
            self.online_store_config = input;
            self
        }
        /// <p>The configuration of the <code>OfflineStore</code>, inducing the S3 location of the <code>OfflineStore</code>, Amazon Web Services Glue or Amazon Web Services Hive data catalogue configurations, and the security configuration.</p>
        pub fn offline_store_config(mut self, input: crate::model::OfflineStoreConfig) -> Self {
            self.offline_store_config = Some(input);
            self
        }
        /// <p>The configuration of the <code>OfflineStore</code>, inducing the S3 location of the <code>OfflineStore</code>, Amazon Web Services Glue or Amazon Web Services Hive data catalogue configurations, and the security configuration.</p>
        pub fn set_offline_store_config(
            mut self,
            input: std::option::Option<crate::model::OfflineStoreConfig>,
        ) -> Self {
            self.offline_store_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the <code>OfflineStore</code> if an <code>OfflineStoreConfig</code> is provided.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the <code>OfflineStore</code> if an <code>OfflineStoreConfig</code> is provided.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The status of the feature group.</p>
        pub fn feature_group_status(mut self, input: crate::model::FeatureGroupStatus) -> Self {
            self.feature_group_status = Some(input);
            self
        }
        /// <p>The status of the feature group.</p>
        pub fn set_feature_group_status(
            mut self,
            input: std::option::Option<crate::model::FeatureGroupStatus>,
        ) -> Self {
            self.feature_group_status = input;
            self
        }
        /// <p>The status of the <code>OfflineStore</code>. Notifies you if replicating data into the <code>OfflineStore</code> has failed. Returns either: <code>Active</code> or <code>Blocked</code> </p>
        pub fn offline_store_status(mut self, input: crate::model::OfflineStoreStatus) -> Self {
            self.offline_store_status = Some(input);
            self
        }
        /// <p>The status of the <code>OfflineStore</code>. Notifies you if replicating data into the <code>OfflineStore</code> has failed. Returns either: <code>Active</code> or <code>Blocked</code> </p>
        pub fn set_offline_store_status(
            mut self,
            input: std::option::Option<crate::model::OfflineStoreStatus>,
        ) -> Self {
            self.offline_store_status = input;
            self
        }
        /// <p>The reason that the <code>FeatureGroup</code> failed to be replicated in the <code>OfflineStore</code>. This is failure can occur because:</p>
        /// <ul>
        /// <li> <p>The <code>FeatureGroup</code> could not be created in the <code>OfflineStore</code>.</p> </li>
        /// <li> <p>The <code>FeatureGroup</code> could not be deleted from the <code>OfflineStore</code>.</p> </li>
        /// </ul>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>The reason that the <code>FeatureGroup</code> failed to be replicated in the <code>OfflineStore</code>. This is failure can occur because:</p>
        /// <ul>
        /// <li> <p>The <code>FeatureGroup</code> could not be created in the <code>OfflineStore</code>.</p> </li>
        /// <li> <p>The <code>FeatureGroup</code> could not be deleted from the <code>OfflineStore</code>.</p> </li>
        /// </ul>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>A free form description of the feature group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A free form description of the feature group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A token to resume pagination of the list of <code>Features</code> (<code>FeatureDefinitions</code>).</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to resume pagination of the list of <code>Features</code> (<code>FeatureDefinitions</code>).</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFeatureGroupOutput`](crate::output::DescribeFeatureGroupOutput)
        pub fn build(self) -> crate::output::DescribeFeatureGroupOutput {
            crate::output::DescribeFeatureGroupOutput {
                feature_group_arn: self.feature_group_arn,
                feature_group_name: self.feature_group_name,
                record_identifier_feature_name: self.record_identifier_feature_name,
                event_time_feature_name: self.event_time_feature_name,
                feature_definitions: self.feature_definitions,
                creation_time: self.creation_time,
                online_store_config: self.online_store_config,
                offline_store_config: self.offline_store_config,
                role_arn: self.role_arn,
                feature_group_status: self.feature_group_status,
                offline_store_status: self.offline_store_status,
                failure_reason: self.failure_reason,
                description: self.description,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeFeatureGroupOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFeatureGroupOutput`](crate::output::DescribeFeatureGroupOutput)
    pub fn builder() -> crate::output::describe_feature_group_output::Builder {
        crate::output::describe_feature_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeExperimentOutput {
    /// <p>The name of the experiment.</p>
    pub experiment_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the experiment.</p>
    pub experiment_arn: std::option::Option<std::string::String>,
    /// <p>The name of the experiment as displayed. If <code>DisplayName</code> isn't specified, <code>ExperimentName</code> is displayed.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the source and, optionally, the type.</p>
    pub source: std::option::Option<crate::model::ExperimentSource>,
    /// <p>The description of the experiment.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>When the experiment was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Who created the experiment.</p>
    pub created_by: std::option::Option<crate::model::UserContext>,
    /// <p>When the experiment was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Who last modified the experiment.</p>
    pub last_modified_by: std::option::Option<crate::model::UserContext>,
}
impl DescribeExperimentOutput {
    /// <p>The name of the experiment.</p>
    pub fn experiment_name(&self) -> std::option::Option<&str> {
        self.experiment_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the experiment.</p>
    pub fn experiment_arn(&self) -> std::option::Option<&str> {
        self.experiment_arn.as_deref()
    }
    /// <p>The name of the experiment as displayed. If <code>DisplayName</code> isn't specified, <code>ExperimentName</code> is displayed.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The ARN of the source and, optionally, the type.</p>
    pub fn source(&self) -> std::option::Option<&crate::model::ExperimentSource> {
        self.source.as_ref()
    }
    /// <p>The description of the experiment.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>When the experiment was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>Who created the experiment.</p>
    pub fn created_by(&self) -> std::option::Option<&crate::model::UserContext> {
        self.created_by.as_ref()
    }
    /// <p>When the experiment was last modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>Who last modified the experiment.</p>
    pub fn last_modified_by(&self) -> std::option::Option<&crate::model::UserContext> {
        self.last_modified_by.as_ref()
    }
}
impl std::fmt::Debug for DescribeExperimentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeExperimentOutput");
        formatter.field("experiment_name", &self.experiment_name);
        formatter.field("experiment_arn", &self.experiment_arn);
        formatter.field("display_name", &self.display_name);
        formatter.field("source", &self.source);
        formatter.field("description", &self.description);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("created_by", &self.created_by);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.finish()
    }
}
/// See [`DescribeExperimentOutput`](crate::output::DescribeExperimentOutput)
pub mod describe_experiment_output {
    /// A builder for [`DescribeExperimentOutput`](crate::output::DescribeExperimentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) experiment_name: std::option::Option<std::string::String>,
        pub(crate) experiment_arn: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<crate::model::ExperimentSource>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_by: std::option::Option<crate::model::UserContext>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_by: std::option::Option<crate::model::UserContext>,
    }
    impl Builder {
        /// <p>The name of the experiment.</p>
        pub fn experiment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.experiment_name = Some(input.into());
            self
        }
        /// <p>The name of the experiment.</p>
        pub fn set_experiment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.experiment_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the experiment.</p>
        pub fn experiment_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.experiment_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the experiment.</p>
        pub fn set_experiment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.experiment_arn = input;
            self
        }
        /// <p>The name of the experiment as displayed. If <code>DisplayName</code> isn't specified, <code>ExperimentName</code> is displayed.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The name of the experiment as displayed. If <code>DisplayName</code> isn't specified, <code>ExperimentName</code> is displayed.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The ARN of the source and, optionally, the type.</p>
        pub fn source(mut self, input: crate::model::ExperimentSource) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>The ARN of the source and, optionally, the type.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::ExperimentSource>,
        ) -> Self {
            self.source = input;
            self
        }
        /// <p>The description of the experiment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the experiment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>When the experiment was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the experiment was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>Who created the experiment.</p>
        pub fn created_by(mut self, input: crate::model::UserContext) -> Self {
            self.created_by = Some(input);
            self
        }
        /// <p>Who created the experiment.</p>
        pub fn set_created_by(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.created_by = input;
            self
        }
        /// <p>When the experiment was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>When the experiment was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>Who last modified the experiment.</p>
        pub fn last_modified_by(mut self, input: crate::model::UserContext) -> Self {
            self.last_modified_by = Some(input);
            self
        }
        /// <p>Who last modified the experiment.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeExperimentOutput`](crate::output::DescribeExperimentOutput)
        pub fn build(self) -> crate::output::DescribeExperimentOutput {
            crate::output::DescribeExperimentOutput {
                experiment_name: self.experiment_name,
                experiment_arn: self.experiment_arn,
                display_name: self.display_name,
                source: self.source,
                description: self.description,
                creation_time: self.creation_time,
                created_by: self.created_by,
                last_modified_time: self.last_modified_time,
                last_modified_by: self.last_modified_by,
            }
        }
    }
}
impl DescribeExperimentOutput {
    /// Creates a new builder-style object to manufacture [`DescribeExperimentOutput`](crate::output::DescribeExperimentOutput)
    pub fn builder() -> crate::output::describe_experiment_output::Builder {
        crate::output::describe_experiment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEndpointConfigOutput {
    /// <p>Name of the Amazon SageMaker endpoint configuration.</p>
    pub endpoint_config_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the endpoint configuration.</p>
    pub endpoint_config_arn: std::option::Option<std::string::String>,
    /// <p>An array of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint.</p>
    pub production_variants: std::option::Option<std::vec::Vec<crate::model::ProductionVariant>>,
    /// <p></p>
    pub data_capture_config: std::option::Option<crate::model::DataCaptureConfig>,
    /// <p>Amazon Web Services KMS key ID Amazon SageMaker uses to encrypt data when storing it on the ML storage volume attached to the instance.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>A timestamp that shows when the endpoint configuration was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Returns the description of an endpoint configuration created using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"> <code>CreateEndpointConfig</code> </a> API.</p>
    pub async_inference_config: std::option::Option<crate::model::AsyncInferenceConfig>,
}
impl DescribeEndpointConfigOutput {
    /// <p>Name of the Amazon SageMaker endpoint configuration.</p>
    pub fn endpoint_config_name(&self) -> std::option::Option<&str> {
        self.endpoint_config_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the endpoint configuration.</p>
    pub fn endpoint_config_arn(&self) -> std::option::Option<&str> {
        self.endpoint_config_arn.as_deref()
    }
    /// <p>An array of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint.</p>
    pub fn production_variants(&self) -> std::option::Option<&[crate::model::ProductionVariant]> {
        self.production_variants.as_deref()
    }
    /// <p></p>
    pub fn data_capture_config(&self) -> std::option::Option<&crate::model::DataCaptureConfig> {
        self.data_capture_config.as_ref()
    }
    /// <p>Amazon Web Services KMS key ID Amazon SageMaker uses to encrypt data when storing it on the ML storage volume attached to the instance.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>A timestamp that shows when the endpoint configuration was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>Returns the description of an endpoint configuration created using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"> <code>CreateEndpointConfig</code> </a> API.</p>
    pub fn async_inference_config(
        &self,
    ) -> std::option::Option<&crate::model::AsyncInferenceConfig> {
        self.async_inference_config.as_ref()
    }
}
impl std::fmt::Debug for DescribeEndpointConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEndpointConfigOutput");
        formatter.field("endpoint_config_name", &self.endpoint_config_name);
        formatter.field("endpoint_config_arn", &self.endpoint_config_arn);
        formatter.field("production_variants", &self.production_variants);
        formatter.field("data_capture_config", &self.data_capture_config);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("async_inference_config", &self.async_inference_config);
        formatter.finish()
    }
}
/// See [`DescribeEndpointConfigOutput`](crate::output::DescribeEndpointConfigOutput)
pub mod describe_endpoint_config_output {
    /// A builder for [`DescribeEndpointConfigOutput`](crate::output::DescribeEndpointConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_config_name: std::option::Option<std::string::String>,
        pub(crate) endpoint_config_arn: std::option::Option<std::string::String>,
        pub(crate) production_variants:
            std::option::Option<std::vec::Vec<crate::model::ProductionVariant>>,
        pub(crate) data_capture_config: std::option::Option<crate::model::DataCaptureConfig>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) async_inference_config: std::option::Option<crate::model::AsyncInferenceConfig>,
    }
    impl Builder {
        /// <p>Name of the Amazon SageMaker endpoint configuration.</p>
        pub fn endpoint_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_config_name = Some(input.into());
            self
        }
        /// <p>Name of the Amazon SageMaker endpoint configuration.</p>
        pub fn set_endpoint_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_config_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint configuration.</p>
        pub fn endpoint_config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_config_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint configuration.</p>
        pub fn set_endpoint_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_config_arn = input;
            self
        }
        /// Appends an item to `production_variants`.
        ///
        /// To override the contents of this collection use [`set_production_variants`](Self::set_production_variants).
        ///
        /// <p>An array of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint.</p>
        pub fn production_variants(mut self, input: crate::model::ProductionVariant) -> Self {
            let mut v = self.production_variants.unwrap_or_default();
            v.push(input);
            self.production_variants = Some(v);
            self
        }
        /// <p>An array of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint.</p>
        pub fn set_production_variants(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProductionVariant>>,
        ) -> Self {
            self.production_variants = input;
            self
        }
        /// <p></p>
        pub fn data_capture_config(mut self, input: crate::model::DataCaptureConfig) -> Self {
            self.data_capture_config = Some(input);
            self
        }
        /// <p></p>
        pub fn set_data_capture_config(
            mut self,
            input: std::option::Option<crate::model::DataCaptureConfig>,
        ) -> Self {
            self.data_capture_config = input;
            self
        }
        /// <p>Amazon Web Services KMS key ID Amazon SageMaker uses to encrypt data when storing it on the ML storage volume attached to the instance.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>Amazon Web Services KMS key ID Amazon SageMaker uses to encrypt data when storing it on the ML storage volume attached to the instance.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>A timestamp that shows when the endpoint configuration was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A timestamp that shows when the endpoint configuration was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>Returns the description of an endpoint configuration created using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"> <code>CreateEndpointConfig</code> </a> API.</p>
        pub fn async_inference_config(mut self, input: crate::model::AsyncInferenceConfig) -> Self {
            self.async_inference_config = Some(input);
            self
        }
        /// <p>Returns the description of an endpoint configuration created using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"> <code>CreateEndpointConfig</code> </a> API.</p>
        pub fn set_async_inference_config(
            mut self,
            input: std::option::Option<crate::model::AsyncInferenceConfig>,
        ) -> Self {
            self.async_inference_config = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEndpointConfigOutput`](crate::output::DescribeEndpointConfigOutput)
        pub fn build(self) -> crate::output::DescribeEndpointConfigOutput {
            crate::output::DescribeEndpointConfigOutput {
                endpoint_config_name: self.endpoint_config_name,
                endpoint_config_arn: self.endpoint_config_arn,
                production_variants: self.production_variants,
                data_capture_config: self.data_capture_config,
                kms_key_id: self.kms_key_id,
                creation_time: self.creation_time,
                async_inference_config: self.async_inference_config,
            }
        }
    }
}
impl DescribeEndpointConfigOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEndpointConfigOutput`](crate::output::DescribeEndpointConfigOutput)
    pub fn builder() -> crate::output::describe_endpoint_config_output::Builder {
        crate::output::describe_endpoint_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEndpointOutput {
    /// <p>Name of the endpoint.</p>
    pub endpoint_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the endpoint.</p>
    pub endpoint_arn: std::option::Option<std::string::String>,
    /// <p>The name of the endpoint configuration associated with this endpoint.</p>
    pub endpoint_config_name: std::option::Option<std::string::String>,
    /// <p> An array of <code>ProductionVariantSummary</code> objects, one for each model hosted behind this endpoint. </p>
    pub production_variants:
        std::option::Option<std::vec::Vec<crate::model::ProductionVariantSummary>>,
    /// <p></p>
    pub data_capture_config: std::option::Option<crate::model::DataCaptureConfigSummary>,
    /// <p>The status of the endpoint.</p>
    /// <ul>
    /// <li> <p> <code>OutOfService</code>: Endpoint is not available to take incoming requests.</p> </li>
    /// <li> <p> <code>Creating</code>: <code>CreateEndpoint</code> is executing.</p> </li>
    /// <li> <p> <code>Updating</code>: <code>UpdateEndpoint</code> or <code>UpdateEndpointWeightsAndCapacities</code> is executing.</p> </li>
    /// <li> <p> <code>SystemUpdating</code>: Endpoint is undergoing maintenance and cannot be updated or deleted or re-scaled until it has completed. This maintenance operation does not change any customer-specified values such as VPC config, KMS encryption, model, instance type, or instance count.</p> </li>
    /// <li> <p> <code>RollingBack</code>: Endpoint fails to scale up or down or change its variant weight and is in the process of rolling back to its previous configuration. Once the rollback completes, endpoint returns to an <code>InService</code> status. This transitional status only applies to an endpoint that has autoscaling enabled and is undergoing variant weight or capacity changes as part of an <code>UpdateEndpointWeightsAndCapacities</code> call or when the <code>UpdateEndpointWeightsAndCapacities</code> operation is called explicitly.</p> </li>
    /// <li> <p> <code>InService</code>: Endpoint is available to process incoming requests.</p> </li>
    /// <li> <p> <code>Deleting</code>: <code>DeleteEndpoint</code> is executing.</p> </li>
    /// <li> <p> <code>Failed</code>: Endpoint could not be created, updated, or re-scaled. Use <code>DescribeEndpointOutput$FailureReason</code> for information about the failure. <code>DeleteEndpoint</code> is the only operation that can be performed on a failed endpoint.</p> </li>
    /// </ul>
    pub endpoint_status: std::option::Option<crate::model::EndpointStatus>,
    /// <p>If the status of the endpoint is <code>Failed</code>, the reason why it failed. </p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>A timestamp that shows when the endpoint was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp that shows when the endpoint was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The most recent deployment configuration for the endpoint.</p>
    pub last_deployment_config: std::option::Option<crate::model::DeploymentConfig>,
    /// <p>Returns the description of an endpoint configuration created using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"> <code>CreateEndpointConfig</code> </a> API.</p>
    pub async_inference_config: std::option::Option<crate::model::AsyncInferenceConfig>,
    /// <p>Returns the summary of an in-progress deployment. This field is only returned when the endpoint is creating or updating with a new endpoint configuration.</p>
    pub pending_deployment_summary: std::option::Option<crate::model::PendingDeploymentSummary>,
}
impl DescribeEndpointOutput {
    /// <p>Name of the endpoint.</p>
    pub fn endpoint_name(&self) -> std::option::Option<&str> {
        self.endpoint_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the endpoint.</p>
    pub fn endpoint_arn(&self) -> std::option::Option<&str> {
        self.endpoint_arn.as_deref()
    }
    /// <p>The name of the endpoint configuration associated with this endpoint.</p>
    pub fn endpoint_config_name(&self) -> std::option::Option<&str> {
        self.endpoint_config_name.as_deref()
    }
    /// <p> An array of <code>ProductionVariantSummary</code> objects, one for each model hosted behind this endpoint. </p>
    pub fn production_variants(
        &self,
    ) -> std::option::Option<&[crate::model::ProductionVariantSummary]> {
        self.production_variants.as_deref()
    }
    /// <p></p>
    pub fn data_capture_config(
        &self,
    ) -> std::option::Option<&crate::model::DataCaptureConfigSummary> {
        self.data_capture_config.as_ref()
    }
    /// <p>The status of the endpoint.</p>
    /// <ul>
    /// <li> <p> <code>OutOfService</code>: Endpoint is not available to take incoming requests.</p> </li>
    /// <li> <p> <code>Creating</code>: <code>CreateEndpoint</code> is executing.</p> </li>
    /// <li> <p> <code>Updating</code>: <code>UpdateEndpoint</code> or <code>UpdateEndpointWeightsAndCapacities</code> is executing.</p> </li>
    /// <li> <p> <code>SystemUpdating</code>: Endpoint is undergoing maintenance and cannot be updated or deleted or re-scaled until it has completed. This maintenance operation does not change any customer-specified values such as VPC config, KMS encryption, model, instance type, or instance count.</p> </li>
    /// <li> <p> <code>RollingBack</code>: Endpoint fails to scale up or down or change its variant weight and is in the process of rolling back to its previous configuration. Once the rollback completes, endpoint returns to an <code>InService</code> status. This transitional status only applies to an endpoint that has autoscaling enabled and is undergoing variant weight or capacity changes as part of an <code>UpdateEndpointWeightsAndCapacities</code> call or when the <code>UpdateEndpointWeightsAndCapacities</code> operation is called explicitly.</p> </li>
    /// <li> <p> <code>InService</code>: Endpoint is available to process incoming requests.</p> </li>
    /// <li> <p> <code>Deleting</code>: <code>DeleteEndpoint</code> is executing.</p> </li>
    /// <li> <p> <code>Failed</code>: Endpoint could not be created, updated, or re-scaled. Use <code>DescribeEndpointOutput$FailureReason</code> for information about the failure. <code>DeleteEndpoint</code> is the only operation that can be performed on a failed endpoint.</p> </li>
    /// </ul>
    pub fn endpoint_status(&self) -> std::option::Option<&crate::model::EndpointStatus> {
        self.endpoint_status.as_ref()
    }
    /// <p>If the status of the endpoint is <code>Failed</code>, the reason why it failed. </p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>A timestamp that shows when the endpoint was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>A timestamp that shows when the endpoint was last modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>The most recent deployment configuration for the endpoint.</p>
    pub fn last_deployment_config(&self) -> std::option::Option<&crate::model::DeploymentConfig> {
        self.last_deployment_config.as_ref()
    }
    /// <p>Returns the description of an endpoint configuration created using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"> <code>CreateEndpointConfig</code> </a> API.</p>
    pub fn async_inference_config(
        &self,
    ) -> std::option::Option<&crate::model::AsyncInferenceConfig> {
        self.async_inference_config.as_ref()
    }
    /// <p>Returns the summary of an in-progress deployment. This field is only returned when the endpoint is creating or updating with a new endpoint configuration.</p>
    pub fn pending_deployment_summary(
        &self,
    ) -> std::option::Option<&crate::model::PendingDeploymentSummary> {
        self.pending_deployment_summary.as_ref()
    }
}
impl std::fmt::Debug for DescribeEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEndpointOutput");
        formatter.field("endpoint_name", &self.endpoint_name);
        formatter.field("endpoint_arn", &self.endpoint_arn);
        formatter.field("endpoint_config_name", &self.endpoint_config_name);
        formatter.field("production_variants", &self.production_variants);
        formatter.field("data_capture_config", &self.data_capture_config);
        formatter.field("endpoint_status", &self.endpoint_status);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("last_deployment_config", &self.last_deployment_config);
        formatter.field("async_inference_config", &self.async_inference_config);
        formatter.field(
            "pending_deployment_summary",
            &self.pending_deployment_summary,
        );
        formatter.finish()
    }
}
/// See [`DescribeEndpointOutput`](crate::output::DescribeEndpointOutput)
pub mod describe_endpoint_output {
    /// A builder for [`DescribeEndpointOutput`](crate::output::DescribeEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_name: std::option::Option<std::string::String>,
        pub(crate) endpoint_arn: std::option::Option<std::string::String>,
        pub(crate) endpoint_config_name: std::option::Option<std::string::String>,
        pub(crate) production_variants:
            std::option::Option<std::vec::Vec<crate::model::ProductionVariantSummary>>,
        pub(crate) data_capture_config: std::option::Option<crate::model::DataCaptureConfigSummary>,
        pub(crate) endpoint_status: std::option::Option<crate::model::EndpointStatus>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_deployment_config: std::option::Option<crate::model::DeploymentConfig>,
        pub(crate) async_inference_config: std::option::Option<crate::model::AsyncInferenceConfig>,
        pub(crate) pending_deployment_summary:
            std::option::Option<crate::model::PendingDeploymentSummary>,
    }
    impl Builder {
        /// <p>Name of the endpoint.</p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_name = Some(input.into());
            self
        }
        /// <p>Name of the endpoint.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_arn = input;
            self
        }
        /// <p>The name of the endpoint configuration associated with this endpoint.</p>
        pub fn endpoint_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_config_name = Some(input.into());
            self
        }
        /// <p>The name of the endpoint configuration associated with this endpoint.</p>
        pub fn set_endpoint_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_config_name = input;
            self
        }
        /// Appends an item to `production_variants`.
        ///
        /// To override the contents of this collection use [`set_production_variants`](Self::set_production_variants).
        ///
        /// <p> An array of <code>ProductionVariantSummary</code> objects, one for each model hosted behind this endpoint. </p>
        pub fn production_variants(
            mut self,
            input: crate::model::ProductionVariantSummary,
        ) -> Self {
            let mut v = self.production_variants.unwrap_or_default();
            v.push(input);
            self.production_variants = Some(v);
            self
        }
        /// <p> An array of <code>ProductionVariantSummary</code> objects, one for each model hosted behind this endpoint. </p>
        pub fn set_production_variants(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProductionVariantSummary>>,
        ) -> Self {
            self.production_variants = input;
            self
        }
        /// <p></p>
        pub fn data_capture_config(
            mut self,
            input: crate::model::DataCaptureConfigSummary,
        ) -> Self {
            self.data_capture_config = Some(input);
            self
        }
        /// <p></p>
        pub fn set_data_capture_config(
            mut self,
            input: std::option::Option<crate::model::DataCaptureConfigSummary>,
        ) -> Self {
            self.data_capture_config = input;
            self
        }
        /// <p>The status of the endpoint.</p>
        /// <ul>
        /// <li> <p> <code>OutOfService</code>: Endpoint is not available to take incoming requests.</p> </li>
        /// <li> <p> <code>Creating</code>: <code>CreateEndpoint</code> is executing.</p> </li>
        /// <li> <p> <code>Updating</code>: <code>UpdateEndpoint</code> or <code>UpdateEndpointWeightsAndCapacities</code> is executing.</p> </li>
        /// <li> <p> <code>SystemUpdating</code>: Endpoint is undergoing maintenance and cannot be updated or deleted or re-scaled until it has completed. This maintenance operation does not change any customer-specified values such as VPC config, KMS encryption, model, instance type, or instance count.</p> </li>
        /// <li> <p> <code>RollingBack</code>: Endpoint fails to scale up or down or change its variant weight and is in the process of rolling back to its previous configuration. Once the rollback completes, endpoint returns to an <code>InService</code> status. This transitional status only applies to an endpoint that has autoscaling enabled and is undergoing variant weight or capacity changes as part of an <code>UpdateEndpointWeightsAndCapacities</code> call or when the <code>UpdateEndpointWeightsAndCapacities</code> operation is called explicitly.</p> </li>
        /// <li> <p> <code>InService</code>: Endpoint is available to process incoming requests.</p> </li>
        /// <li> <p> <code>Deleting</code>: <code>DeleteEndpoint</code> is executing.</p> </li>
        /// <li> <p> <code>Failed</code>: Endpoint could not be created, updated, or re-scaled. Use <code>DescribeEndpointOutput$FailureReason</code> for information about the failure. <code>DeleteEndpoint</code> is the only operation that can be performed on a failed endpoint.</p> </li>
        /// </ul>
        pub fn endpoint_status(mut self, input: crate::model::EndpointStatus) -> Self {
            self.endpoint_status = Some(input);
            self
        }
        /// <p>The status of the endpoint.</p>
        /// <ul>
        /// <li> <p> <code>OutOfService</code>: Endpoint is not available to take incoming requests.</p> </li>
        /// <li> <p> <code>Creating</code>: <code>CreateEndpoint</code> is executing.</p> </li>
        /// <li> <p> <code>Updating</code>: <code>UpdateEndpoint</code> or <code>UpdateEndpointWeightsAndCapacities</code> is executing.</p> </li>
        /// <li> <p> <code>SystemUpdating</code>: Endpoint is undergoing maintenance and cannot be updated or deleted or re-scaled until it has completed. This maintenance operation does not change any customer-specified values such as VPC config, KMS encryption, model, instance type, or instance count.</p> </li>
        /// <li> <p> <code>RollingBack</code>: Endpoint fails to scale up or down or change its variant weight and is in the process of rolling back to its previous configuration. Once the rollback completes, endpoint returns to an <code>InService</code> status. This transitional status only applies to an endpoint that has autoscaling enabled and is undergoing variant weight or capacity changes as part of an <code>UpdateEndpointWeightsAndCapacities</code> call or when the <code>UpdateEndpointWeightsAndCapacities</code> operation is called explicitly.</p> </li>
        /// <li> <p> <code>InService</code>: Endpoint is available to process incoming requests.</p> </li>
        /// <li> <p> <code>Deleting</code>: <code>DeleteEndpoint</code> is executing.</p> </li>
        /// <li> <p> <code>Failed</code>: Endpoint could not be created, updated, or re-scaled. Use <code>DescribeEndpointOutput$FailureReason</code> for information about the failure. <code>DeleteEndpoint</code> is the only operation that can be performed on a failed endpoint.</p> </li>
        /// </ul>
        pub fn set_endpoint_status(
            mut self,
            input: std::option::Option<crate::model::EndpointStatus>,
        ) -> Self {
            self.endpoint_status = input;
            self
        }
        /// <p>If the status of the endpoint is <code>Failed</code>, the reason why it failed. </p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If the status of the endpoint is <code>Failed</code>, the reason why it failed. </p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>A timestamp that shows when the endpoint was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A timestamp that shows when the endpoint was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>A timestamp that shows when the endpoint was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>A timestamp that shows when the endpoint was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>The most recent deployment configuration for the endpoint.</p>
        pub fn last_deployment_config(mut self, input: crate::model::DeploymentConfig) -> Self {
            self.last_deployment_config = Some(input);
            self
        }
        /// <p>The most recent deployment configuration for the endpoint.</p>
        pub fn set_last_deployment_config(
            mut self,
            input: std::option::Option<crate::model::DeploymentConfig>,
        ) -> Self {
            self.last_deployment_config = input;
            self
        }
        /// <p>Returns the description of an endpoint configuration created using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"> <code>CreateEndpointConfig</code> </a> API.</p>
        pub fn async_inference_config(mut self, input: crate::model::AsyncInferenceConfig) -> Self {
            self.async_inference_config = Some(input);
            self
        }
        /// <p>Returns the description of an endpoint configuration created using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"> <code>CreateEndpointConfig</code> </a> API.</p>
        pub fn set_async_inference_config(
            mut self,
            input: std::option::Option<crate::model::AsyncInferenceConfig>,
        ) -> Self {
            self.async_inference_config = input;
            self
        }
        /// <p>Returns the summary of an in-progress deployment. This field is only returned when the endpoint is creating or updating with a new endpoint configuration.</p>
        pub fn pending_deployment_summary(
            mut self,
            input: crate::model::PendingDeploymentSummary,
        ) -> Self {
            self.pending_deployment_summary = Some(input);
            self
        }
        /// <p>Returns the summary of an in-progress deployment. This field is only returned when the endpoint is creating or updating with a new endpoint configuration.</p>
        pub fn set_pending_deployment_summary(
            mut self,
            input: std::option::Option<crate::model::PendingDeploymentSummary>,
        ) -> Self {
            self.pending_deployment_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEndpointOutput`](crate::output::DescribeEndpointOutput)
        pub fn build(self) -> crate::output::DescribeEndpointOutput {
            crate::output::DescribeEndpointOutput {
                endpoint_name: self.endpoint_name,
                endpoint_arn: self.endpoint_arn,
                endpoint_config_name: self.endpoint_config_name,
                production_variants: self.production_variants,
                data_capture_config: self.data_capture_config,
                endpoint_status: self.endpoint_status,
                failure_reason: self.failure_reason,
                creation_time: self.creation_time,
                last_modified_time: self.last_modified_time,
                last_deployment_config: self.last_deployment_config,
                async_inference_config: self.async_inference_config,
                pending_deployment_summary: self.pending_deployment_summary,
            }
        }
    }
}
impl DescribeEndpointOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEndpointOutput`](crate::output::DescribeEndpointOutput)
    pub fn builder() -> crate::output::describe_endpoint_output::Builder {
        crate::output::describe_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEdgePackagingJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the edge packaging job.</p>
    pub edge_packaging_job_arn: std::option::Option<std::string::String>,
    /// <p>The name of the edge packaging job.</p>
    pub edge_packaging_job_name: std::option::Option<std::string::String>,
    /// <p>The name of the SageMaker Neo compilation job that is used to locate model artifacts that are being packaged.</p>
    pub compilation_job_name: std::option::Option<std::string::String>,
    /// <p>The name of the model.</p>
    pub model_name: std::option::Option<std::string::String>,
    /// <p>The version of the model.</p>
    pub model_version: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to download and upload the model, and to contact Neo.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The output configuration for the edge packaging job.</p>
    pub output_config: std::option::Option<crate::model::EdgeOutputConfig>,
    /// <p>The Amazon Web Services KMS key to use when encrypting the EBS volume the job run on.</p>
    pub resource_key: std::option::Option<std::string::String>,
    /// <p>The current status of the packaging job.</p>
    pub edge_packaging_job_status: std::option::Option<crate::model::EdgePackagingJobStatus>,
    /// <p>Returns a message describing the job status and error messages.</p>
    pub edge_packaging_job_status_message: std::option::Option<std::string::String>,
    /// <p>The timestamp of when the packaging job was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp of when the job was last updated.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Amazon Simple Storage (S3) URI where model artifacts ares stored.</p>
    pub model_artifact: std::option::Option<std::string::String>,
    /// <p>The signature document of files in the model artifact.</p>
    pub model_signature: std::option::Option<std::string::String>,
    /// <p>The output of a SageMaker Edge Manager deployable resource.</p>
    pub preset_deployment_output: std::option::Option<crate::model::EdgePresetDeploymentOutput>,
}
impl DescribeEdgePackagingJobOutput {
    /// <p>The Amazon Resource Name (ARN) of the edge packaging job.</p>
    pub fn edge_packaging_job_arn(&self) -> std::option::Option<&str> {
        self.edge_packaging_job_arn.as_deref()
    }
    /// <p>The name of the edge packaging job.</p>
    pub fn edge_packaging_job_name(&self) -> std::option::Option<&str> {
        self.edge_packaging_job_name.as_deref()
    }
    /// <p>The name of the SageMaker Neo compilation job that is used to locate model artifacts that are being packaged.</p>
    pub fn compilation_job_name(&self) -> std::option::Option<&str> {
        self.compilation_job_name.as_deref()
    }
    /// <p>The name of the model.</p>
    pub fn model_name(&self) -> std::option::Option<&str> {
        self.model_name.as_deref()
    }
    /// <p>The version of the model.</p>
    pub fn model_version(&self) -> std::option::Option<&str> {
        self.model_version.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to download and upload the model, and to contact Neo.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The output configuration for the edge packaging job.</p>
    pub fn output_config(&self) -> std::option::Option<&crate::model::EdgeOutputConfig> {
        self.output_config.as_ref()
    }
    /// <p>The Amazon Web Services KMS key to use when encrypting the EBS volume the job run on.</p>
    pub fn resource_key(&self) -> std::option::Option<&str> {
        self.resource_key.as_deref()
    }
    /// <p>The current status of the packaging job.</p>
    pub fn edge_packaging_job_status(
        &self,
    ) -> std::option::Option<&crate::model::EdgePackagingJobStatus> {
        self.edge_packaging_job_status.as_ref()
    }
    /// <p>Returns a message describing the job status and error messages.</p>
    pub fn edge_packaging_job_status_message(&self) -> std::option::Option<&str> {
        self.edge_packaging_job_status_message.as_deref()
    }
    /// <p>The timestamp of when the packaging job was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The timestamp of when the job was last updated.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>The Amazon Simple Storage (S3) URI where model artifacts ares stored.</p>
    pub fn model_artifact(&self) -> std::option::Option<&str> {
        self.model_artifact.as_deref()
    }
    /// <p>The signature document of files in the model artifact.</p>
    pub fn model_signature(&self) -> std::option::Option<&str> {
        self.model_signature.as_deref()
    }
    /// <p>The output of a SageMaker Edge Manager deployable resource.</p>
    pub fn preset_deployment_output(
        &self,
    ) -> std::option::Option<&crate::model::EdgePresetDeploymentOutput> {
        self.preset_deployment_output.as_ref()
    }
}
impl std::fmt::Debug for DescribeEdgePackagingJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEdgePackagingJobOutput");
        formatter.field("edge_packaging_job_arn", &self.edge_packaging_job_arn);
        formatter.field("edge_packaging_job_name", &self.edge_packaging_job_name);
        formatter.field("compilation_job_name", &self.compilation_job_name);
        formatter.field("model_name", &self.model_name);
        formatter.field("model_version", &self.model_version);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("output_config", &self.output_config);
        formatter.field("resource_key", &self.resource_key);
        formatter.field("edge_packaging_job_status", &self.edge_packaging_job_status);
        formatter.field(
            "edge_packaging_job_status_message",
            &self.edge_packaging_job_status_message,
        );
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("model_artifact", &self.model_artifact);
        formatter.field("model_signature", &self.model_signature);
        formatter.field("preset_deployment_output", &self.preset_deployment_output);
        formatter.finish()
    }
}
/// See [`DescribeEdgePackagingJobOutput`](crate::output::DescribeEdgePackagingJobOutput)
pub mod describe_edge_packaging_job_output {
    /// A builder for [`DescribeEdgePackagingJobOutput`](crate::output::DescribeEdgePackagingJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) edge_packaging_job_arn: std::option::Option<std::string::String>,
        pub(crate) edge_packaging_job_name: std::option::Option<std::string::String>,
        pub(crate) compilation_job_name: std::option::Option<std::string::String>,
        pub(crate) model_name: std::option::Option<std::string::String>,
        pub(crate) model_version: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) output_config: std::option::Option<crate::model::EdgeOutputConfig>,
        pub(crate) resource_key: std::option::Option<std::string::String>,
        pub(crate) edge_packaging_job_status:
            std::option::Option<crate::model::EdgePackagingJobStatus>,
        pub(crate) edge_packaging_job_status_message: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) model_artifact: std::option::Option<std::string::String>,
        pub(crate) model_signature: std::option::Option<std::string::String>,
        pub(crate) preset_deployment_output:
            std::option::Option<crate::model::EdgePresetDeploymentOutput>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the edge packaging job.</p>
        pub fn edge_packaging_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.edge_packaging_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the edge packaging job.</p>
        pub fn set_edge_packaging_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.edge_packaging_job_arn = input;
            self
        }
        /// <p>The name of the edge packaging job.</p>
        pub fn edge_packaging_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.edge_packaging_job_name = Some(input.into());
            self
        }
        /// <p>The name of the edge packaging job.</p>
        pub fn set_edge_packaging_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.edge_packaging_job_name = input;
            self
        }
        /// <p>The name of the SageMaker Neo compilation job that is used to locate model artifacts that are being packaged.</p>
        pub fn compilation_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.compilation_job_name = Some(input.into());
            self
        }
        /// <p>The name of the SageMaker Neo compilation job that is used to locate model artifacts that are being packaged.</p>
        pub fn set_compilation_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.compilation_job_name = input;
            self
        }
        /// <p>The name of the model.</p>
        pub fn model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_name = Some(input.into());
            self
        }
        /// <p>The 