// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon SageMaker Service
///
/// Client for invoking operations on Amazon SageMaker Service. Each operation on Amazon SageMaker Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_sagemaker::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_sagemaker::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_sagemaker::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AddAssociation` operation.
    ///
    /// See [`AddAssociation`](crate::client::fluent_builders::AddAssociation) for more information about the
    /// operation and its arguments.
    pub fn add_association(&self) -> fluent_builders::AddAssociation<C, M, R> {
        fluent_builders::AddAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AddTags` operation.
    ///
    /// See [`AddTags`](crate::client::fluent_builders::AddTags) for more information about the
    /// operation and its arguments.
    pub fn add_tags(&self) -> fluent_builders::AddTags<C, M, R> {
        fluent_builders::AddTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateTrialComponent` operation.
    ///
    /// See [`AssociateTrialComponent`](crate::client::fluent_builders::AssociateTrialComponent) for more information about the
    /// operation and its arguments.
    pub fn associate_trial_component(&self) -> fluent_builders::AssociateTrialComponent<C, M, R> {
        fluent_builders::AssociateTrialComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchDescribeModelPackage` operation.
    ///
    /// See [`BatchDescribeModelPackage`](crate::client::fluent_builders::BatchDescribeModelPackage) for more information about the
    /// operation and its arguments.
    pub fn batch_describe_model_package(
        &self,
    ) -> fluent_builders::BatchDescribeModelPackage<C, M, R> {
        fluent_builders::BatchDescribeModelPackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAction` operation.
    ///
    /// See [`CreateAction`](crate::client::fluent_builders::CreateAction) for more information about the
    /// operation and its arguments.
    pub fn create_action(&self) -> fluent_builders::CreateAction<C, M, R> {
        fluent_builders::CreateAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAlgorithm` operation.
    ///
    /// See [`CreateAlgorithm`](crate::client::fluent_builders::CreateAlgorithm) for more information about the
    /// operation and its arguments.
    pub fn create_algorithm(&self) -> fluent_builders::CreateAlgorithm<C, M, R> {
        fluent_builders::CreateAlgorithm::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateApp` operation.
    ///
    /// See [`CreateApp`](crate::client::fluent_builders::CreateApp) for more information about the
    /// operation and its arguments.
    pub fn create_app(&self) -> fluent_builders::CreateApp<C, M, R> {
        fluent_builders::CreateApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAppImageConfig` operation.
    ///
    /// See [`CreateAppImageConfig`](crate::client::fluent_builders::CreateAppImageConfig) for more information about the
    /// operation and its arguments.
    pub fn create_app_image_config(&self) -> fluent_builders::CreateAppImageConfig<C, M, R> {
        fluent_builders::CreateAppImageConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateArtifact` operation.
    ///
    /// See [`CreateArtifact`](crate::client::fluent_builders::CreateArtifact) for more information about the
    /// operation and its arguments.
    pub fn create_artifact(&self) -> fluent_builders::CreateArtifact<C, M, R> {
        fluent_builders::CreateArtifact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAutoMLJob` operation.
    ///
    /// See [`CreateAutoMLJob`](crate::client::fluent_builders::CreateAutoMLJob) for more information about the
    /// operation and its arguments.
    pub fn create_auto_ml_job(&self) -> fluent_builders::CreateAutoMLJob<C, M, R> {
        fluent_builders::CreateAutoMLJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCodeRepository` operation.
    ///
    /// See [`CreateCodeRepository`](crate::client::fluent_builders::CreateCodeRepository) for more information about the
    /// operation and its arguments.
    pub fn create_code_repository(&self) -> fluent_builders::CreateCodeRepository<C, M, R> {
        fluent_builders::CreateCodeRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCompilationJob` operation.
    ///
    /// See [`CreateCompilationJob`](crate::client::fluent_builders::CreateCompilationJob) for more information about the
    /// operation and its arguments.
    pub fn create_compilation_job(&self) -> fluent_builders::CreateCompilationJob<C, M, R> {
        fluent_builders::CreateCompilationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateContext` operation.
    ///
    /// See [`CreateContext`](crate::client::fluent_builders::CreateContext) for more information about the
    /// operation and its arguments.
    pub fn create_context(&self) -> fluent_builders::CreateContext<C, M, R> {
        fluent_builders::CreateContext::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDataQualityJobDefinition` operation.
    ///
    /// See [`CreateDataQualityJobDefinition`](crate::client::fluent_builders::CreateDataQualityJobDefinition) for more information about the
    /// operation and its arguments.
    pub fn create_data_quality_job_definition(
        &self,
    ) -> fluent_builders::CreateDataQualityJobDefinition<C, M, R> {
        fluent_builders::CreateDataQualityJobDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDeviceFleet` operation.
    ///
    /// See [`CreateDeviceFleet`](crate::client::fluent_builders::CreateDeviceFleet) for more information about the
    /// operation and its arguments.
    pub fn create_device_fleet(&self) -> fluent_builders::CreateDeviceFleet<C, M, R> {
        fluent_builders::CreateDeviceFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDomain` operation.
    ///
    /// See [`CreateDomain`](crate::client::fluent_builders::CreateDomain) for more information about the
    /// operation and its arguments.
    pub fn create_domain(&self) -> fluent_builders::CreateDomain<C, M, R> {
        fluent_builders::CreateDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEdgePackagingJob` operation.
    ///
    /// See [`CreateEdgePackagingJob`](crate::client::fluent_builders::CreateEdgePackagingJob) for more information about the
    /// operation and its arguments.
    pub fn create_edge_packaging_job(&self) -> fluent_builders::CreateEdgePackagingJob<C, M, R> {
        fluent_builders::CreateEdgePackagingJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEndpoint` operation.
    ///
    /// See [`CreateEndpoint`](crate::client::fluent_builders::CreateEndpoint) for more information about the
    /// operation and its arguments.
    pub fn create_endpoint(&self) -> fluent_builders::CreateEndpoint<C, M, R> {
        fluent_builders::CreateEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEndpointConfig` operation.
    ///
    /// See [`CreateEndpointConfig`](crate::client::fluent_builders::CreateEndpointConfig) for more information about the
    /// operation and its arguments.
    pub fn create_endpoint_config(&self) -> fluent_builders::CreateEndpointConfig<C, M, R> {
        fluent_builders::CreateEndpointConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateExperiment` operation.
    ///
    /// See [`CreateExperiment`](crate::client::fluent_builders::CreateExperiment) for more information about the
    /// operation and its arguments.
    pub fn create_experiment(&self) -> fluent_builders::CreateExperiment<C, M, R> {
        fluent_builders::CreateExperiment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFeatureGroup` operation.
    ///
    /// See [`CreateFeatureGroup`](crate::client::fluent_builders::CreateFeatureGroup) for more information about the
    /// operation and its arguments.
    pub fn create_feature_group(&self) -> fluent_builders::CreateFeatureGroup<C, M, R> {
        fluent_builders::CreateFeatureGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFlowDefinition` operation.
    ///
    /// See [`CreateFlowDefinition`](crate::client::fluent_builders::CreateFlowDefinition) for more information about the
    /// operation and its arguments.
    pub fn create_flow_definition(&self) -> fluent_builders::CreateFlowDefinition<C, M, R> {
        fluent_builders::CreateFlowDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateHumanTaskUi` operation.
    ///
    /// See [`CreateHumanTaskUi`](crate::client::fluent_builders::CreateHumanTaskUi) for more information about the
    /// operation and its arguments.
    pub fn create_human_task_ui(&self) -> fluent_builders::CreateHumanTaskUi<C, M, R> {
        fluent_builders::CreateHumanTaskUi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateHyperParameterTuningJob` operation.
    ///
    /// See [`CreateHyperParameterTuningJob`](crate::client::fluent_builders::CreateHyperParameterTuningJob) for more information about the
    /// operation and its arguments.
    pub fn create_hyper_parameter_tuning_job(
        &self,
    ) -> fluent_builders::CreateHyperParameterTuningJob<C, M, R> {
        fluent_builders::CreateHyperParameterTuningJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateImage` operation.
    ///
    /// See [`CreateImage`](crate::client::fluent_builders::CreateImage) for more information about the
    /// operation and its arguments.
    pub fn create_image(&self) -> fluent_builders::CreateImage<C, M, R> {
        fluent_builders::CreateImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateImageVersion` operation.
    ///
    /// See [`CreateImageVersion`](crate::client::fluent_builders::CreateImageVersion) for more information about the
    /// operation and its arguments.
    pub fn create_image_version(&self) -> fluent_builders::CreateImageVersion<C, M, R> {
        fluent_builders::CreateImageVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateInferenceRecommendationsJob` operation.
    ///
    /// See [`CreateInferenceRecommendationsJob`](crate::client::fluent_builders::CreateInferenceRecommendationsJob) for more information about the
    /// operation and its arguments.
    pub fn create_inference_recommendations_job(
        &self,
    ) -> fluent_builders::CreateInferenceRecommendationsJob<C, M, R> {
        fluent_builders::CreateInferenceRecommendationsJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLabelingJob` operation.
    ///
    /// See [`CreateLabelingJob`](crate::client::fluent_builders::CreateLabelingJob) for more information about the
    /// operation and its arguments.
    pub fn create_labeling_job(&self) -> fluent_builders::CreateLabelingJob<C, M, R> {
        fluent_builders::CreateLabelingJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateModel` operation.
    ///
    /// See [`CreateModel`](crate::client::fluent_builders::CreateModel) for more information about the
    /// operation and its arguments.
    pub fn create_model(&self) -> fluent_builders::CreateModel<C, M, R> {
        fluent_builders::CreateModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateModelBiasJobDefinition` operation.
    ///
    /// See [`CreateModelBiasJobDefinition`](crate::client::fluent_builders::CreateModelBiasJobDefinition) for more information about the
    /// operation and its arguments.
    pub fn create_model_bias_job_definition(
        &self,
    ) -> fluent_builders::CreateModelBiasJobDefinition<C, M, R> {
        fluent_builders::CreateModelBiasJobDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateModelExplainabilityJobDefinition` operation.
    ///
    /// See [`CreateModelExplainabilityJobDefinition`](crate::client::fluent_builders::CreateModelExplainabilityJobDefinition) for more information about the
    /// operation and its arguments.
    pub fn create_model_explainability_job_definition(
        &self,
    ) -> fluent_builders::CreateModelExplainabilityJobDefinition<C, M, R> {
        fluent_builders::CreateModelExplainabilityJobDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateModelPackage` operation.
    ///
    /// See [`CreateModelPackage`](crate::client::fluent_builders::CreateModelPackage) for more information about the
    /// operation and its arguments.
    pub fn create_model_package(&self) -> fluent_builders::CreateModelPackage<C, M, R> {
        fluent_builders::CreateModelPackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateModelPackageGroup` operation.
    ///
    /// See [`CreateModelPackageGroup`](crate::client::fluent_builders::CreateModelPackageGroup) for more information about the
    /// operation and its arguments.
    pub fn create_model_package_group(&self) -> fluent_builders::CreateModelPackageGroup<C, M, R> {
        fluent_builders::CreateModelPackageGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateModelQualityJobDefinition` operation.
    ///
    /// See [`CreateModelQualityJobDefinition`](crate::client::fluent_builders::CreateModelQualityJobDefinition) for more information about the
    /// operation and its arguments.
    pub fn create_model_quality_job_definition(
        &self,
    ) -> fluent_builders::CreateModelQualityJobDefinition<C, M, R> {
        fluent_builders::CreateModelQualityJobDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateMonitoringSchedule` operation.
    ///
    /// See [`CreateMonitoringSchedule`](crate::client::fluent_builders::CreateMonitoringSchedule) for more information about the
    /// operation and its arguments.
    pub fn create_monitoring_schedule(&self) -> fluent_builders::CreateMonitoringSchedule<C, M, R> {
        fluent_builders::CreateMonitoringSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateNotebookInstance` operation.
    ///
    /// See [`CreateNotebookInstance`](crate::client::fluent_builders::CreateNotebookInstance) for more information about the
    /// operation and its arguments.
    pub fn create_notebook_instance(&self) -> fluent_builders::CreateNotebookInstance<C, M, R> {
        fluent_builders::CreateNotebookInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateNotebookInstanceLifecycleConfig` operation.
    ///
    /// See [`CreateNotebookInstanceLifecycleConfig`](crate::client::fluent_builders::CreateNotebookInstanceLifecycleConfig) for more information about the
    /// operation and its arguments.
    pub fn create_notebook_instance_lifecycle_config(
        &self,
    ) -> fluent_builders::CreateNotebookInstanceLifecycleConfig<C, M, R> {
        fluent_builders::CreateNotebookInstanceLifecycleConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePipeline` operation.
    ///
    /// See [`CreatePipeline`](crate::client::fluent_builders::CreatePipeline) for more information about the
    /// operation and its arguments.
    pub fn create_pipeline(&self) -> fluent_builders::CreatePipeline<C, M, R> {
        fluent_builders::CreatePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePresignedDomainUrl` operation.
    ///
    /// See [`CreatePresignedDomainUrl`](crate::client::fluent_builders::CreatePresignedDomainUrl) for more information about the
    /// operation and its arguments.
    pub fn create_presigned_domain_url(
        &self,
    ) -> fluent_builders::CreatePresignedDomainUrl<C, M, R> {
        fluent_builders::CreatePresignedDomainUrl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePresignedNotebookInstanceUrl` operation.
    ///
    /// See [`CreatePresignedNotebookInstanceUrl`](crate::client::fluent_builders::CreatePresignedNotebookInstanceUrl) for more information about the
    /// operation and its arguments.
    pub fn create_presigned_notebook_instance_url(
        &self,
    ) -> fluent_builders::CreatePresignedNotebookInstanceUrl<C, M, R> {
        fluent_builders::CreatePresignedNotebookInstanceUrl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateProcessingJob` operation.
    ///
    /// See [`CreateProcessingJob`](crate::client::fluent_builders::CreateProcessingJob) for more information about the
    /// operation and its arguments.
    pub fn create_processing_job(&self) -> fluent_builders::CreateProcessingJob<C, M, R> {
        fluent_builders::CreateProcessingJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateProject` operation.
    ///
    /// See [`CreateProject`](crate::client::fluent_builders::CreateProject) for more information about the
    /// operation and its arguments.
    pub fn create_project(&self) -> fluent_builders::CreateProject<C, M, R> {
        fluent_builders::CreateProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateStudioLifecycleConfig` operation.
    ///
    /// See [`CreateStudioLifecycleConfig`](crate::client::fluent_builders::CreateStudioLifecycleConfig) for more information about the
    /// operation and its arguments.
    pub fn create_studio_lifecycle_config(
        &self,
    ) -> fluent_builders::CreateStudioLifecycleConfig<C, M, R> {
        fluent_builders::CreateStudioLifecycleConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTrainingJob` operation.
    ///
    /// See [`CreateTrainingJob`](crate::client::fluent_builders::CreateTrainingJob) for more information about the
    /// operation and its arguments.
    pub fn create_training_job(&self) -> fluent_builders::CreateTrainingJob<C, M, R> {
        fluent_builders::CreateTrainingJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTransformJob` operation.
    ///
    /// See [`CreateTransformJob`](crate::client::fluent_builders::CreateTransformJob) for more information about the
    /// operation and its arguments.
    pub fn create_transform_job(&self) -> fluent_builders::CreateTransformJob<C, M, R> {
        fluent_builders::CreateTransformJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTrial` operation.
    ///
    /// See [`CreateTrial`](crate::client::fluent_builders::CreateTrial) for more information about the
    /// operation and its arguments.
    pub fn create_trial(&self) -> fluent_builders::CreateTrial<C, M, R> {
        fluent_builders::CreateTrial::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTrialComponent` operation.
    ///
    /// See [`CreateTrialComponent`](crate::client::fluent_builders::CreateTrialComponent) for more information about the
    /// operation and its arguments.
    pub fn create_trial_component(&self) -> fluent_builders::CreateTrialComponent<C, M, R> {
        fluent_builders::CreateTrialComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateUserProfile` operation.
    ///
    /// See [`CreateUserProfile`](crate::client::fluent_builders::CreateUserProfile) for more information about the
    /// operation and its arguments.
    pub fn create_user_profile(&self) -> fluent_builders::CreateUserProfile<C, M, R> {
        fluent_builders::CreateUserProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateWorkforce` operation.
    ///
    /// See [`CreateWorkforce`](crate::client::fluent_builders::CreateWorkforce) for more information about the
    /// operation and its arguments.
    pub fn create_workforce(&self) -> fluent_builders::CreateWorkforce<C, M, R> {
        fluent_builders::CreateWorkforce::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateWorkteam` operation.
    ///
    /// See [`CreateWorkteam`](crate::client::fluent_builders::CreateWorkteam) for more information about the
    /// operation and its arguments.
    pub fn create_workteam(&self) -> fluent_builders::CreateWorkteam<C, M, R> {
        fluent_builders::CreateWorkteam::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAction` operation.
    ///
    /// See [`DeleteAction`](crate::client::fluent_builders::DeleteAction) for more information about the
    /// operation and its arguments.
    pub fn delete_action(&self) -> fluent_builders::DeleteAction<C, M, R> {
        fluent_builders::DeleteAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAlgorithm` operation.
    ///
    /// See [`DeleteAlgorithm`](crate::client::fluent_builders::DeleteAlgorithm) for more information about the
    /// operation and its arguments.
    pub fn delete_algorithm(&self) -> fluent_builders::DeleteAlgorithm<C, M, R> {
        fluent_builders::DeleteAlgorithm::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteApp` operation.
    ///
    /// See [`DeleteApp`](crate::client::fluent_builders::DeleteApp) for more information about the
    /// operation and its arguments.
    pub fn delete_app(&self) -> fluent_builders::DeleteApp<C, M, R> {
        fluent_builders::DeleteApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAppImageConfig` operation.
    ///
    /// See [`DeleteAppImageConfig`](crate::client::fluent_builders::DeleteAppImageConfig) for more information about the
    /// operation and its arguments.
    pub fn delete_app_image_config(&self) -> fluent_builders::DeleteAppImageConfig<C, M, R> {
        fluent_builders::DeleteAppImageConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteArtifact` operation.
    ///
    /// See [`DeleteArtifact`](crate::client::fluent_builders::DeleteArtifact) for more information about the
    /// operation and its arguments.
    pub fn delete_artifact(&self) -> fluent_builders::DeleteArtifact<C, M, R> {
        fluent_builders::DeleteArtifact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAssociation` operation.
    ///
    /// See [`DeleteAssociation`](crate::client::fluent_builders::DeleteAssociation) for more information about the
    /// operation and its arguments.
    pub fn delete_association(&self) -> fluent_builders::DeleteAssociation<C, M, R> {
        fluent_builders::DeleteAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCodeRepository` operation.
    ///
    /// See [`DeleteCodeRepository`](crate::client::fluent_builders::DeleteCodeRepository) for more information about the
    /// operation and its arguments.
    pub fn delete_code_repository(&self) -> fluent_builders::DeleteCodeRepository<C, M, R> {
        fluent_builders::DeleteCodeRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteContext` operation.
    ///
    /// See [`DeleteContext`](crate::client::fluent_builders::DeleteContext) for more information about the
    /// operation and its arguments.
    pub fn delete_context(&self) -> fluent_builders::DeleteContext<C, M, R> {
        fluent_builders::DeleteContext::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDataQualityJobDefinition` operation.
    ///
    /// See [`DeleteDataQualityJobDefinition`](crate::client::fluent_builders::DeleteDataQualityJobDefinition) for more information about the
    /// operation and its arguments.
    pub fn delete_data_quality_job_definition(
        &self,
    ) -> fluent_builders::DeleteDataQualityJobDefinition<C, M, R> {
        fluent_builders::DeleteDataQualityJobDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDeviceFleet` operation.
    ///
    /// See [`DeleteDeviceFleet`](crate::client::fluent_builders::DeleteDeviceFleet) for more information about the
    /// operation and its arguments.
    pub fn delete_device_fleet(&self) -> fluent_builders::DeleteDeviceFleet<C, M, R> {
        fluent_builders::DeleteDeviceFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDomain` operation.
    ///
    /// See [`DeleteDomain`](crate::client::fluent_builders::DeleteDomain) for more information about the
    /// operation and its arguments.
    pub fn delete_domain(&self) -> fluent_builders::DeleteDomain<C, M, R> {
        fluent_builders::DeleteDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEndpoint` operation.
    ///
    /// See [`DeleteEndpoint`](crate::client::fluent_builders::DeleteEndpoint) for more information about the
    /// operation and its arguments.
    pub fn delete_endpoint(&self) -> fluent_builders::DeleteEndpoint<C, M, R> {
        fluent_builders::DeleteEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEndpointConfig` operation.
    ///
    /// See [`DeleteEndpointConfig`](crate::client::fluent_builders::DeleteEndpointConfig) for more information about the
    /// operation and its arguments.
    pub fn delete_endpoint_config(&self) -> fluent_builders::DeleteEndpointConfig<C, M, R> {
        fluent_builders::DeleteEndpointConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteExperiment` operation.
    ///
    /// See [`DeleteExperiment`](crate::client::fluent_builders::DeleteExperiment) for more information about the
    /// operation and its arguments.
    pub fn delete_experiment(&self) -> fluent_builders::DeleteExperiment<C, M, R> {
        fluent_builders::DeleteExperiment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFeatureGroup` operation.
    ///
    /// See [`DeleteFeatureGroup`](crate::client::fluent_builders::DeleteFeatureGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_feature_group(&self) -> fluent_builders::DeleteFeatureGroup<C, M, R> {
        fluent_builders::DeleteFeatureGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFlowDefinition` operation.
    ///
    /// See [`DeleteFlowDefinition`](crate::client::fluent_builders::DeleteFlowDefinition) for more information about the
    /// operation and its arguments.
    pub fn delete_flow_definition(&self) -> fluent_builders::DeleteFlowDefinition<C, M, R> {
        fluent_builders::DeleteFlowDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteHumanTaskUi` operation.
    ///
    /// See [`DeleteHumanTaskUi`](crate::client::fluent_builders::DeleteHumanTaskUi) for more information about the
    /// operation and its arguments.
    pub fn delete_human_task_ui(&self) -> fluent_builders::DeleteHumanTaskUi<C, M, R> {
        fluent_builders::DeleteHumanTaskUi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteImage` operation.
    ///
    /// See [`DeleteImage`](crate::client::fluent_builders::DeleteImage) for more information about the
    /// operation and its arguments.
    pub fn delete_image(&self) -> fluent_builders::DeleteImage<C, M, R> {
        fluent_builders::DeleteImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteImageVersion` operation.
    ///
    /// See [`DeleteImageVersion`](crate::client::fluent_builders::DeleteImageVersion) for more information about the
    /// operation and its arguments.
    pub fn delete_image_version(&self) -> fluent_builders::DeleteImageVersion<C, M, R> {
        fluent_builders::DeleteImageVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteModel` operation.
    ///
    /// See [`DeleteModel`](crate::client::fluent_builders::DeleteModel) for more information about the
    /// operation and its arguments.
    pub fn delete_model(&self) -> fluent_builders::DeleteModel<C, M, R> {
        fluent_builders::DeleteModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteModelBiasJobDefinition` operation.
    ///
    /// See [`DeleteModelBiasJobDefinition`](crate::client::fluent_builders::DeleteModelBiasJobDefinition) for more information about the
    /// operation and its arguments.
    pub fn delete_model_bias_job_definition(
        &self,
    ) -> fluent_builders::DeleteModelBiasJobDefinition<C, M, R> {
        fluent_builders::DeleteModelBiasJobDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteModelExplainabilityJobDefinition` operation.
    ///
    /// See [`DeleteModelExplainabilityJobDefinition`](crate::client::fluent_builders::DeleteModelExplainabilityJobDefinition) for more information about the
    /// operation and its arguments.
    pub fn delete_model_explainability_job_definition(
        &self,
    ) -> fluent_builders::DeleteModelExplainabilityJobDefinition<C, M, R> {
        fluent_builders::DeleteModelExplainabilityJobDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteModelPackage` operation.
    ///
    /// See [`DeleteModelPackage`](crate::client::fluent_builders::DeleteModelPackage) for more information about the
    /// operation and its arguments.
    pub fn delete_model_package(&self) -> fluent_builders::DeleteModelPackage<C, M, R> {
        fluent_builders::DeleteModelPackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteModelPackageGroup` operation.
    ///
    /// See [`DeleteModelPackageGroup`](crate::client::fluent_builders::DeleteModelPackageGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_model_package_group(&self) -> fluent_builders::DeleteModelPackageGroup<C, M, R> {
        fluent_builders::DeleteModelPackageGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteModelPackageGroupPolicy` operation.
    ///
    /// See [`DeleteModelPackageGroupPolicy`](crate::client::fluent_builders::DeleteModelPackageGroupPolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_model_package_group_policy(
        &self,
    ) -> fluent_builders::DeleteModelPackageGroupPolicy<C, M, R> {
        fluent_builders::DeleteModelPackageGroupPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteModelQualityJobDefinition` operation.
    ///
    /// See [`DeleteModelQualityJobDefinition`](crate::client::fluent_builders::DeleteModelQualityJobDefinition) for more information about the
    /// operation and its arguments.
    pub fn delete_model_quality_job_definition(
        &self,
    ) -> fluent_builders::DeleteModelQualityJobDefinition<C, M, R> {
        fluent_builders::DeleteModelQualityJobDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteMonitoringSchedule` operation.
    ///
    /// See [`DeleteMonitoringSchedule`](crate::client::fluent_builders::DeleteMonitoringSchedule) for more information about the
    /// operation and its arguments.
    pub fn delete_monitoring_schedule(&self) -> fluent_builders::DeleteMonitoringSchedule<C, M, R> {
        fluent_builders::DeleteMonitoringSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteNotebookInstance` operation.
    ///
    /// See [`DeleteNotebookInstance`](crate::client::fluent_builders::DeleteNotebookInstance) for more information about the
    /// operation and its arguments.
    pub fn delete_notebook_instance(&self) -> fluent_builders::DeleteNotebookInstance<C, M, R> {
        fluent_builders::DeleteNotebookInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteNotebookInstanceLifecycleConfig` operation.
    ///
    /// See [`DeleteNotebookInstanceLifecycleConfig`](crate::client::fluent_builders::DeleteNotebookInstanceLifecycleConfig) for more information about the
    /// operation and its arguments.
    pub fn delete_notebook_instance_lifecycle_config(
        &self,
    ) -> fluent_builders::DeleteNotebookInstanceLifecycleConfig<C, M, R> {
        fluent_builders::DeleteNotebookInstanceLifecycleConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePipeline` operation.
    ///
    /// See [`DeletePipeline`](crate::client::fluent_builders::DeletePipeline) for more information about the
    /// operation and its arguments.
    pub fn delete_pipeline(&self) -> fluent_builders::DeletePipeline<C, M, R> {
        fluent_builders::DeletePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteProject` operation.
    ///
    /// See [`DeleteProject`](crate::client::fluent_builders::DeleteProject) for more information about the
    /// operation and its arguments.
    pub fn delete_project(&self) -> fluent_builders::DeleteProject<C, M, R> {
        fluent_builders::DeleteProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteStudioLifecycleConfig` operation.
    ///
    /// See [`DeleteStudioLifecycleConfig`](crate::client::fluent_builders::DeleteStudioLifecycleConfig) for more information about the
    /// operation and its arguments.
    pub fn delete_studio_lifecycle_config(
        &self,
    ) -> fluent_builders::DeleteStudioLifecycleConfig<C, M, R> {
        fluent_builders::DeleteStudioLifecycleConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTags` operation.
    ///
    /// See [`DeleteTags`](crate::client::fluent_builders::DeleteTags) for more information about the
    /// operation and its arguments.
    pub fn delete_tags(&self) -> fluent_builders::DeleteTags<C, M, R> {
        fluent_builders::DeleteTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTrial` operation.
    ///
    /// See [`DeleteTrial`](crate::client::fluent_builders::DeleteTrial) for more information about the
    /// operation and its arguments.
    pub fn delete_trial(&self) -> fluent_builders::DeleteTrial<C, M, R> {
        fluent_builders::DeleteTrial::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTrialComponent` operation.
    ///
    /// See [`DeleteTrialComponent`](crate::client::fluent_builders::DeleteTrialComponent) for more information about the
    /// operation and its arguments.
    pub fn delete_trial_component(&self) -> fluent_builders::DeleteTrialComponent<C, M, R> {
        fluent_builders::DeleteTrialComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteUserProfile` operation.
    ///
    /// See [`DeleteUserProfile`](crate::client::fluent_builders::DeleteUserProfile) for more information about the
    /// operation and its arguments.
    pub fn delete_user_profile(&self) -> fluent_builders::DeleteUserProfile<C, M, R> {
        fluent_builders::DeleteUserProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteWorkforce` operation.
    ///
    /// See [`DeleteWorkforce`](crate::client::fluent_builders::DeleteWorkforce) for more information about the
    /// operation and its arguments.
    pub fn delete_workforce(&self) -> fluent_builders::DeleteWorkforce<C, M, R> {
        fluent_builders::DeleteWorkforce::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteWorkteam` operation.
    ///
    /// See [`DeleteWorkteam`](crate::client::fluent_builders::DeleteWorkteam) for more information about the
    /// operation and its arguments.
    pub fn delete_workteam(&self) -> fluent_builders::DeleteWorkteam<C, M, R> {
        fluent_builders::DeleteWorkteam::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeregisterDevices` operation.
    ///
    /// See [`DeregisterDevices`](crate::client::fluent_builders::DeregisterDevices) for more information about the
    /// operation and its arguments.
    pub fn deregister_devices(&self) -> fluent_builders::DeregisterDevices<C, M, R> {
        fluent_builders::DeregisterDevices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAction` operation.
    ///
    /// See [`DescribeAction`](crate::client::fluent_builders::DescribeAction) for more information about the
    /// operation and its arguments.
    pub fn describe_action(&self) -> fluent_builders::DescribeAction<C, M, R> {
        fluent_builders::DescribeAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAlgorithm` operation.
    ///
    /// See [`DescribeAlgorithm`](crate::client::fluent_builders::DescribeAlgorithm) for more information about the
    /// operation and its arguments.
    pub fn describe_algorithm(&self) -> fluent_builders::DescribeAlgorithm<C, M, R> {
        fluent_builders::DescribeAlgorithm::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeApp` operation.
    ///
    /// See [`DescribeApp`](crate::client::fluent_builders::DescribeApp) for more information about the
    /// operation and its arguments.
    pub fn describe_app(&self) -> fluent_builders::DescribeApp<C, M, R> {
        fluent_builders::DescribeApp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAppImageConfig` operation.
    ///
    /// See [`DescribeAppImageConfig`](crate::client::fluent_builders::DescribeAppImageConfig) for more information about the
    /// operation and its arguments.
    pub fn describe_app_image_config(&self) -> fluent_builders::DescribeAppImageConfig<C, M, R> {
        fluent_builders::DescribeAppImageConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeArtifact` operation.
    ///
    /// See [`DescribeArtifact`](crate::client::fluent_builders::DescribeArtifact) for more information about the
    /// operation and its arguments.
    pub fn describe_artifact(&self) -> fluent_builders::DescribeArtifact<C, M, R> {
        fluent_builders::DescribeArtifact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAutoMLJob` operation.
    ///
    /// See [`DescribeAutoMLJob`](crate::client::fluent_builders::DescribeAutoMLJob) for more information about the
    /// operation and its arguments.
    pub fn describe_auto_ml_job(&self) -> fluent_builders::DescribeAutoMLJob<C, M, R> {
        fluent_builders::DescribeAutoMLJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCodeRepository` operation.
    ///
    /// See [`DescribeCodeRepository`](crate::client::fluent_builders::DescribeCodeRepository) for more information about the
    /// operation and its arguments.
    pub fn describe_code_repository(&self) -> fluent_builders::DescribeCodeRepository<C, M, R> {
        fluent_builders::DescribeCodeRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCompilationJob` operation.
    ///
    /// See [`DescribeCompilationJob`](crate::client::fluent_builders::DescribeCompilationJob) for more information about the
    /// operation and its arguments.
    pub fn describe_compilation_job(&self) -> fluent_builders::DescribeCompilationJob<C, M, R> {
        fluent_builders::DescribeCompilationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeContext` operation.
    ///
    /// See [`DescribeContext`](crate::client::fluent_builders::DescribeContext) for more information about the
    /// operation and its arguments.
    pub fn describe_context(&self) -> fluent_builders::DescribeContext<C, M, R> {
        fluent_builders::DescribeContext::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDataQualityJobDefinition` operation.
    ///
    /// See [`DescribeDataQualityJobDefinition`](crate::client::fluent_builders::DescribeDataQualityJobDefinition) for more information about the
    /// operation and its arguments.
    pub fn describe_data_quality_job_definition(
        &self,
    ) -> fluent_builders::DescribeDataQualityJobDefinition<C, M, R> {
        fluent_builders::DescribeDataQualityJobDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDevice` operation.
    ///
    /// See [`DescribeDevice`](crate::client::fluent_builders::DescribeDevice) for more information about the
    /// operation and its arguments.
    pub fn describe_device(&self) -> fluent_builders::DescribeDevice<C, M, R> {
        fluent_builders::DescribeDevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDeviceFleet` operation.
    ///
    /// See [`DescribeDeviceFleet`](crate::client::fluent_builders::DescribeDeviceFleet) for more information about the
    /// operation and its arguments.
    pub fn describe_device_fleet(&self) -> fluent_builders::DescribeDeviceFleet<C, M, R> {
        fluent_builders::DescribeDeviceFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDomain` operation.
    ///
    /// See [`DescribeDomain`](crate::client::fluent_builders::DescribeDomain) for more information about the
    /// operation and its arguments.
    pub fn describe_domain(&self) -> fluent_builders::DescribeDomain<C, M, R> {
        fluent_builders::DescribeDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEdgePackagingJob` operation.
    ///
    /// See [`DescribeEdgePackagingJob`](crate::client::fluent_builders::DescribeEdgePackagingJob) for more information about the
    /// operation and its arguments.
    pub fn describe_edge_packaging_job(
        &self,
    ) -> fluent_builders::DescribeEdgePackagingJob<C, M, R> {
        fluent_builders::DescribeEdgePackagingJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEndpoint` operation.
    ///
    /// See [`DescribeEndpoint`](crate::client::fluent_builders::DescribeEndpoint) for more information about the
    /// operation and its arguments.
    pub fn describe_endpoint(&self) -> fluent_builders::DescribeEndpoint<C, M, R> {
        fluent_builders::DescribeEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEndpointConfig` operation.
    ///
    /// See [`DescribeEndpointConfig`](crate::client::fluent_builders::DescribeEndpointConfig) for more information about the
    /// operation and its arguments.
    pub fn describe_endpoint_config(&self) -> fluent_builders::DescribeEndpointConfig<C, M, R> {
        fluent_builders::DescribeEndpointConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeExperiment` operation.
    ///
    /// See [`DescribeExperiment`](crate::client::fluent_builders::DescribeExperiment) for more information about the
    /// operation and its arguments.
    pub fn describe_experiment(&self) -> fluent_builders::DescribeExperiment<C, M, R> {
        fluent_builders::DescribeExperiment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFeatureGroup` operation.
    ///
    /// See [`DescribeFeatureGroup`](crate::client::fluent_builders::DescribeFeatureGroup) for more information about the
    /// operation and its arguments.
    pub fn describe_feature_group(&self) -> fluent_builders::DescribeFeatureGroup<C, M, R> {
        fluent_builders::DescribeFeatureGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFlowDefinition` operation.
    ///
    /// See [`DescribeFlowDefinition`](crate::client::fluent_builders::DescribeFlowDefinition) for more information about the
    /// operation and its arguments.
    pub fn describe_flow_definition(&self) -> fluent_builders::DescribeFlowDefinition<C, M, R> {
        fluent_builders::DescribeFlowDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeHumanTaskUi` operation.
    ///
    /// See [`DescribeHumanTaskUi`](crate::client::fluent_builders::DescribeHumanTaskUi) for more information about the
    /// operation and its arguments.
    pub fn describe_human_task_ui(&self) -> fluent_builders::DescribeHumanTaskUi<C, M, R> {
        fluent_builders::DescribeHumanTaskUi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeHyperParameterTuningJob` operation.
    ///
    /// See [`DescribeHyperParameterTuningJob`](crate::client::fluent_builders::DescribeHyperParameterTuningJob) for more information about the
    /// operation and its arguments.
    pub fn describe_hyper_parameter_tuning_job(
        &self,
    ) -> fluent_builders::DescribeHyperParameterTuningJob<C, M, R> {
        fluent_builders::DescribeHyperParameterTuningJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeImage` operation.
    ///
    /// See [`DescribeImage`](crate::client::fluent_builders::DescribeImage) for more information about the
    /// operation and its arguments.
    pub fn describe_image(&self) -> fluent_builders::DescribeImage<C, M, R> {
        fluent_builders::DescribeImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeImageVersion` operation.
    ///
    /// See [`DescribeImageVersion`](crate::client::fluent_builders::DescribeImageVersion) for more information about the
    /// operation and its arguments.
    pub fn describe_image_version(&self) -> fluent_builders::DescribeImageVersion<C, M, R> {
        fluent_builders::DescribeImageVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInferenceRecommendationsJob` operation.
    ///
    /// See [`DescribeInferenceRecommendationsJob`](crate::client::fluent_builders::DescribeInferenceRecommendationsJob) for more information about the
    /// operation and its arguments.
    pub fn describe_inference_recommendations_job(
        &self,
    ) -> fluent_builders::DescribeInferenceRecommendationsJob<C, M, R> {
        fluent_builders::DescribeInferenceRecommendationsJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLabelingJob` operation.
    ///
    /// See [`DescribeLabelingJob`](crate::client::fluent_builders::DescribeLabelingJob) for more information about the
    /// operation and its arguments.
    pub fn describe_labeling_job(&self) -> fluent_builders::DescribeLabelingJob<C, M, R> {
        fluent_builders::DescribeLabelingJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLineageGroup` operation.
    ///
    /// See [`DescribeLineageGroup`](crate::client::fluent_builders::DescribeLineageGroup) for more information about the
    /// operation and its arguments.
    pub fn describe_lineage_group(&self) -> fluent_builders::DescribeLineageGroup<C, M, R> {
        fluent_builders::DescribeLineageGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeModel` operation.
    ///
    /// See [`DescribeModel`](crate::client::fluent_builders::DescribeModel) for more information about the
    /// operation and its arguments.
    pub fn describe_model(&self) -> fluent_builders::DescribeModel<C, M, R> {
        fluent_builders::DescribeModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeModelBiasJobDefinition` operation.
    ///
    /// See [`DescribeModelBiasJobDefinition`](crate::client::fluent_builders::DescribeModelBiasJobDefinition) for more information about the
    /// operation and its arguments.
    pub fn describe_model_bias_job_definition(
        &self,
    ) -> fluent_builders::DescribeModelBiasJobDefinition<C, M, R> {
        fluent_builders::DescribeModelBiasJobDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeModelExplainabilityJobDefinition` operation.
    ///
    /// See [`DescribeModelExplainabilityJobDefinition`](crate::client::fluent_builders::DescribeModelExplainabilityJobDefinition) for more information about the
    /// operation and its arguments.
    pub fn describe_model_explainability_job_definition(
        &self,
    ) -> fluent_builders::DescribeModelExplainabilityJobDefinition<C, M, R> {
        fluent_builders::DescribeModelExplainabilityJobDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeModelPackage` operation.
    ///
    /// See [`DescribeModelPackage`](crate::client::fluent_builders::DescribeModelPackage) for more information about the
    /// operation and its arguments.
    pub fn describe_model_package(&self) -> fluent_builders::DescribeModelPackage<C, M, R> {
        fluent_builders::DescribeModelPackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeModelPackageGroup` operation.
    ///
    /// See [`DescribeModelPackageGroup`](crate::client::fluent_builders::DescribeModelPackageGroup) for more information about the
    /// operation and its arguments.
    pub fn describe_model_package_group(
        &self,
    ) -> fluent_builders::DescribeModelPackageGroup<C, M, R> {
        fluent_builders::DescribeModelPackageGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeModelQualityJobDefinition` operation.
    ///
    /// See [`DescribeModelQualityJobDefinition`](crate::client::fluent_builders::DescribeModelQualityJobDefinition) for more information about the
    /// operation and its arguments.
    pub fn describe_model_quality_job_definition(
        &self,
    ) -> fluent_builders::DescribeModelQualityJobDefinition<C, M, R> {
        fluent_builders::DescribeModelQualityJobDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeMonitoringSchedule` operation.
    ///
    /// See [`DescribeMonitoringSchedule`](crate::client::fluent_builders::DescribeMonitoringSchedule) for more information about the
    /// operation and its arguments.
    pub fn describe_monitoring_schedule(
        &self,
    ) -> fluent_builders::DescribeMonitoringSchedule<C, M, R> {
        fluent_builders::DescribeMonitoringSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeNotebookInstance` operation.
    ///
    /// See [`DescribeNotebookInstance`](crate::client::fluent_builders::DescribeNotebookInstance) for more information about the
    /// operation and its arguments.
    pub fn describe_notebook_instance(&self) -> fluent_builders::DescribeNotebookInstance<C, M, R> {
        fluent_builders::DescribeNotebookInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeNotebookInstanceLifecycleConfig` operation.
    ///
    /// See [`DescribeNotebookInstanceLifecycleConfig`](crate::client::fluent_builders::DescribeNotebookInstanceLifecycleConfig) for more information about the
    /// operation and its arguments.
    pub fn describe_notebook_instance_lifecycle_config(
        &self,
    ) -> fluent_builders::DescribeNotebookInstanceLifecycleConfig<C, M, R> {
        fluent_builders::DescribeNotebookInstanceLifecycleConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePipeline` operation.
    ///
    /// See [`DescribePipeline`](crate::client::fluent_builders::DescribePipeline) for more information about the
    /// operation and its arguments.
    pub fn describe_pipeline(&self) -> fluent_builders::DescribePipeline<C, M, R> {
        fluent_builders::DescribePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePipelineDefinitionForExecution` operation.
    ///
    /// See [`DescribePipelineDefinitionForExecution`](crate::client::fluent_builders::DescribePipelineDefinitionForExecution) for more information about the
    /// operation and its arguments.
    pub fn describe_pipeline_definition_for_execution(
        &self,
    ) -> fluent_builders::DescribePipelineDefinitionForExecution<C, M, R> {
        fluent_builders::DescribePipelineDefinitionForExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePipelineExecution` operation.
    ///
    /// See [`DescribePipelineExecution`](crate::client::fluent_builders::DescribePipelineExecution) for more information about the
    /// operation and its arguments.
    pub fn describe_pipeline_execution(
        &self,
    ) -> fluent_builders::DescribePipelineExecution<C, M, R> {
        fluent_builders::DescribePipelineExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeProcessingJob` operation.
    ///
    /// See [`DescribeProcessingJob`](crate::client::fluent_builders::DescribeProcessingJob) for more information about the
    /// operation and its arguments.
    pub fn describe_processing_job(&self) -> fluent_builders::DescribeProcessingJob<C, M, R> {
        fluent_builders::DescribeProcessingJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeProject` operation.
    ///
    /// See [`DescribeProject`](crate::client::fluent_builders::DescribeProject) for more information about the
    /// operation and its arguments.
    pub fn describe_project(&self) -> fluent_builders::DescribeProject<C, M, R> {
        fluent_builders::DescribeProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeStudioLifecycleConfig` operation.
    ///
    /// See [`DescribeStudioLifecycleConfig`](crate::client::fluent_builders::DescribeStudioLifecycleConfig) for more information about the
    /// operation and its arguments.
    pub fn describe_studio_lifecycle_config(
        &self,
    ) -> fluent_builders::DescribeStudioLifecycleConfig<C, M, R> {
        fluent_builders::DescribeStudioLifecycleConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSubscribedWorkteam` operation.
    ///
    /// See [`DescribeSubscribedWorkteam`](crate::client::fluent_builders::DescribeSubscribedWorkteam) for more information about the
    /// operation and its arguments.
    pub fn describe_subscribed_workteam(
        &self,
    ) -> fluent_builders::DescribeSubscribedWorkteam<C, M, R> {
        fluent_builders::DescribeSubscribedWorkteam::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTrainingJob` operation.
    ///
    /// See [`DescribeTrainingJob`](crate::client::fluent_builders::DescribeTrainingJob) for more information about the
    /// operation and its arguments.
    pub fn describe_training_job(&self) -> fluent_builders::DescribeTrainingJob<C, M, R> {
        fluent_builders::DescribeTrainingJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTransformJob` operation.
    ///
    /// See [`DescribeTransformJob`](crate::client::fluent_builders::DescribeTransformJob) for more information about the
    /// operation and its arguments.
    pub fn describe_transform_job(&self) -> fluent_builders::DescribeTransformJob<C, M, R> {
        fluent_builders::DescribeTransformJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTrial` operation.
    ///
    /// See [`DescribeTrial`](crate::client::fluent_builders::DescribeTrial) for more information about the
    /// operation and its arguments.
    pub fn describe_trial(&self) -> fluent_builders::DescribeTrial<C, M, R> {
        fluent_builders::DescribeTrial::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTrialComponent` operation.
    ///
    /// See [`DescribeTrialComponent`](crate::client::fluent_builders::DescribeTrialComponent) for more information about the
    /// operation and its arguments.
    pub fn describe_trial_component(&self) -> fluent_builders::DescribeTrialComponent<C, M, R> {
        fluent_builders::DescribeTrialComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeUserProfile` operation.
    ///
    /// See [`DescribeUserProfile`](crate::client::fluent_builders::DescribeUserProfile) for more information about the
    /// operation and its arguments.
    pub fn describe_user_profile(&self) -> fluent_builders::DescribeUserProfile<C, M, R> {
        fluent_builders::DescribeUserProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeWorkforce` operation.
    ///
    /// See [`DescribeWorkforce`](crate::client::fluent_builders::DescribeWorkforce) for more information about the
    /// operation and its arguments.
    pub fn describe_workforce(&self) -> fluent_builders::DescribeWorkforce<C, M, R> {
        fluent_builders::DescribeWorkforce::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeWorkteam` operation.
    ///
    /// See [`DescribeWorkteam`](crate::client::fluent_builders::DescribeWorkteam) for more information about the
    /// operation and its arguments.
    pub fn describe_workteam(&self) -> fluent_builders::DescribeWorkteam<C, M, R> {
        fluent_builders::DescribeWorkteam::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableSagemakerServicecatalogPortfolio` operation.
    ///
    /// See [`DisableSagemakerServicecatalogPortfolio`](crate::client::fluent_builders::DisableSagemakerServicecatalogPortfolio) for more information about the
    /// operation and its arguments.
    pub fn disable_sagemaker_servicecatalog_portfolio(
        &self,
    ) -> fluent_builders::DisableSagemakerServicecatalogPortfolio<C, M, R> {
        fluent_builders::DisableSagemakerServicecatalogPortfolio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateTrialComponent` operation.
    ///
    /// See [`DisassociateTrialComponent`](crate::client::fluent_builders::DisassociateTrialComponent) for more information about the
    /// operation and its arguments.
    pub fn disassociate_trial_component(
        &self,
    ) -> fluent_builders::DisassociateTrialComponent<C, M, R> {
        fluent_builders::DisassociateTrialComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableSagemakerServicecatalogPortfolio` operation.
    ///
    /// See [`EnableSagemakerServicecatalogPortfolio`](crate::client::fluent_builders::EnableSagemakerServicecatalogPortfolio) for more information about the
    /// operation and its arguments.
    pub fn enable_sagemaker_servicecatalog_portfolio(
        &self,
    ) -> fluent_builders::EnableSagemakerServicecatalogPortfolio<C, M, R> {
        fluent_builders::EnableSagemakerServicecatalogPortfolio::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDeviceFleetReport` operation.
    ///
    /// See [`GetDeviceFleetReport`](crate::client::fluent_builders::GetDeviceFleetReport) for more information about the
    /// operation and its arguments.
    pub fn get_device_fleet_report(&self) -> fluent_builders::GetDeviceFleetReport<C, M, R> {
        fluent_builders::GetDeviceFleetReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLineageGroupPolicy` operation.
    ///
    /// See [`GetLineageGroupPolicy`](crate::client::fluent_builders::GetLineageGroupPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_lineage_group_policy(&self) -> fluent_builders::GetLineageGroupPolicy<C, M, R> {
        fluent_builders::GetLineageGroupPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetModelPackageGroupPolicy` operation.
    ///
    /// See [`GetModelPackageGroupPolicy`](crate::client::fluent_builders::GetModelPackageGroupPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_model_package_group_policy(
        &self,
    ) -> fluent_builders::GetModelPackageGroupPolicy<C, M, R> {
        fluent_builders::GetModelPackageGroupPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSagemakerServicecatalogPortfolioStatus` operation.
    ///
    /// See [`GetSagemakerServicecatalogPortfolioStatus`](crate::client::fluent_builders::GetSagemakerServicecatalogPortfolioStatus) for more information about the
    /// operation and its arguments.
    pub fn get_sagemaker_servicecatalog_portfolio_status(
        &self,
    ) -> fluent_builders::GetSagemakerServicecatalogPortfolioStatus<C, M, R> {
        fluent_builders::GetSagemakerServicecatalogPortfolioStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSearchSuggestions` operation.
    ///
    /// See [`GetSearchSuggestions`](crate::client::fluent_builders::GetSearchSuggestions) for more information about the
    /// operation and its arguments.
    pub fn get_search_suggestions(&self) -> fluent_builders::GetSearchSuggestions<C, M, R> {
        fluent_builders::GetSearchSuggestions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListActions` operation.
    ///
    /// See [`ListActions`](crate::client::fluent_builders::ListActions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListActions::into_paginator).
    pub fn list_actions(&self) -> fluent_builders::ListActions<C, M, R> {
        fluent_builders::ListActions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAlgorithms` operation.
    ///
    /// See [`ListAlgorithms`](crate::client::fluent_builders::ListAlgorithms) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListAlgorithms::into_paginator).
    pub fn list_algorithms(&self) -> fluent_builders::ListAlgorithms<C, M, R> {
        fluent_builders::ListAlgorithms::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAppImageConfigs` operation.
    ///
    /// See [`ListAppImageConfigs`](crate::client::fluent_builders::ListAppImageConfigs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListAppImageConfigs::into_paginator).
    pub fn list_app_image_configs(&self) -> fluent_builders::ListAppImageConfigs<C, M, R> {
        fluent_builders::ListAppImageConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListApps` operation.
    ///
    /// See [`ListApps`](crate::client::fluent_builders::ListApps) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListApps::into_paginator).
    pub fn list_apps(&self) -> fluent_builders::ListApps<C, M, R> {
        fluent_builders::ListApps::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListArtifacts` operation.
    ///
    /// See [`ListArtifacts`](crate::client::fluent_builders::ListArtifacts) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListArtifacts::into_paginator).
    pub fn list_artifacts(&self) -> fluent_builders::ListArtifacts<C, M, R> {
        fluent_builders::ListArtifacts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAssociations` operation.
    ///
    /// See [`ListAssociations`](crate::client::fluent_builders::ListAssociations) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListAssociations::into_paginator).
    pub fn list_associations(&self) -> fluent_builders::ListAssociations<C, M, R> {
        fluent_builders::ListAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAutoMLJobs` operation.
    ///
    /// See [`ListAutoMLJobs`](crate::client::fluent_builders::ListAutoMLJobs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListAutoMLJobs::into_paginator).
    pub fn list_auto_ml_jobs(&self) -> fluent_builders::ListAutoMLJobs<C, M, R> {
        fluent_builders::ListAutoMLJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCandidatesForAutoMLJob` operation.
    ///
    /// See [`ListCandidatesForAutoMLJob`](crate::client::fluent_builders::ListCandidatesForAutoMLJob) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListCandidatesForAutoMLJob::into_paginator).
    pub fn list_candidates_for_auto_ml_job(
        &self,
    ) -> fluent_builders::ListCandidatesForAutoMLJob<C, M, R> {
        fluent_builders::ListCandidatesForAutoMLJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCodeRepositories` operation.
    ///
    /// See [`ListCodeRepositories`](crate::client::fluent_builders::ListCodeRepositories) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListCodeRepositories::into_paginator).
    pub fn list_code_repositories(&self) -> fluent_builders::ListCodeRepositories<C, M, R> {
        fluent_builders::ListCodeRepositories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCompilationJobs` operation.
    ///
    /// See [`ListCompilationJobs`](crate::client::fluent_builders::ListCompilationJobs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListCompilationJobs::into_paginator).
    pub fn list_compilation_jobs(&self) -> fluent_builders::ListCompilationJobs<C, M, R> {
        fluent_builders::ListCompilationJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListContexts` operation.
    ///
    /// See [`ListContexts`](crate::client::fluent_builders::ListContexts) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListContexts::into_paginator).
    pub fn list_contexts(&self) -> fluent_builders::ListContexts<C, M, R> {
        fluent_builders::ListContexts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDataQualityJobDefinitions` operation.
    ///
    /// See [`ListDataQualityJobDefinitions`](crate::client::fluent_builders::ListDataQualityJobDefinitions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListDataQualityJobDefinitions::into_paginator).
    pub fn list_data_quality_job_definitions(
        &self,
    ) -> fluent_builders::ListDataQualityJobDefinitions<C, M, R> {
        fluent_builders::ListDataQualityJobDefinitions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDeviceFleets` operation.
    ///
    /// See [`ListDeviceFleets`](crate::client::fluent_builders::ListDeviceFleets) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListDeviceFleets::into_paginator).
    pub fn list_device_fleets(&self) -> fluent_builders::ListDeviceFleets<C, M, R> {
        fluent_builders::ListDeviceFleets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDevices` operation.
    ///
    /// See [`ListDevices`](crate::client::fluent_builders::ListDevices) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListDevices::into_paginator).
    pub fn list_devices(&self) -> fluent_builders::ListDevices<C, M, R> {
        fluent_builders::ListDevices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDomains` operation.
    ///
    /// See [`ListDomains`](crate::client::fluent_builders::ListDomains) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListDomains::into_paginator).
    pub fn list_domains(&self) -> fluent_builders::ListDomains<C, M, R> {
        fluent_builders::ListDomains::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEdgePackagingJobs` operation.
    ///
    /// See [`ListEdgePackagingJobs`](crate::client::fluent_builders::ListEdgePackagingJobs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListEdgePackagingJobs::into_paginator).
    pub fn list_edge_packaging_jobs(&self) -> fluent_builders::ListEdgePackagingJobs<C, M, R> {
        fluent_builders::ListEdgePackagingJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEndpointConfigs` operation.
    ///
    /// See [`ListEndpointConfigs`](crate::client::fluent_builders::ListEndpointConfigs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListEndpointConfigs::into_paginator).
    pub fn list_endpoint_configs(&self) -> fluent_builders::ListEndpointConfigs<C, M, R> {
        fluent_builders::ListEndpointConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEndpoints` operation.
    ///
    /// See [`ListEndpoints`](crate::client::fluent_builders::ListEndpoints) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListEndpoints::into_paginator).
    pub fn list_endpoints(&self) -> fluent_builders::ListEndpoints<C, M, R> {
        fluent_builders::ListEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListExperiments` operation.
    ///
    /// See [`ListExperiments`](crate::client::fluent_builders::ListExperiments) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListExperiments::into_paginator).
    pub fn list_experiments(&self) -> fluent_builders::ListExperiments<C, M, R> {
        fluent_builders::ListExperiments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFeatureGroups` operation.
    ///
    /// See [`ListFeatureGroups`](crate::client::fluent_builders::ListFeatureGroups) for more information about the
    /// operation and its arguments.
    pub fn list_feature_groups(&self) -> fluent_builders::ListFeatureGroups<C, M, R> {
        fluent_builders::ListFeatureGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFlowDefinitions` operation.
    ///
    /// See [`ListFlowDefinitions`](crate::client::fluent_builders::ListFlowDefinitions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListFlowDefinitions::into_paginator).
    pub fn list_flow_definitions(&self) -> fluent_builders::ListFlowDefinitions<C, M, R> {
        fluent_builders::ListFlowDefinitions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListHumanTaskUis` operation.
    ///
    /// See [`ListHumanTaskUis`](crate::client::fluent_builders::ListHumanTaskUis) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListHumanTaskUis::into_paginator).
    pub fn list_human_task_uis(&self) -> fluent_builders::ListHumanTaskUis<C, M, R> {
        fluent_builders::ListHumanTaskUis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListHyperParameterTuningJobs` operation.
    ///
    /// See [`ListHyperParameterTuningJobs`](crate::client::fluent_builders::ListHyperParameterTuningJobs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListHyperParameterTuningJobs::into_paginator).
    pub fn list_hyper_parameter_tuning_jobs(
        &self,
    ) -> fluent_builders::ListHyperParameterTuningJobs<C, M, R> {
        fluent_builders::ListHyperParameterTuningJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListImages` operation.
    ///
    /// See [`ListImages`](crate::client::fluent_builders::ListImages) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListImages::into_paginator).
    pub fn list_images(&self) -> fluent_builders::ListImages<C, M, R> {
        fluent_builders::ListImages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListImageVersions` operation.
    ///
    /// See [`ListImageVersions`](crate::client::fluent_builders::ListImageVersions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListImageVersions::into_paginator).
    pub fn list_image_versions(&self) -> fluent_builders::ListImageVersions<C, M, R> {
        fluent_builders::ListImageVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListInferenceRecommendationsJobs` operation.
    ///
    /// See [`ListInferenceRecommendationsJobs`](crate::client::fluent_builders::ListInferenceRecommendationsJobs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListInferenceRecommendationsJobs::into_paginator).
    pub fn list_inference_recommendations_jobs(
        &self,
    ) -> fluent_builders::ListInferenceRecommendationsJobs<C, M, R> {
        fluent_builders::ListInferenceRecommendationsJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLabelingJobs` operation.
    ///
    /// See [`ListLabelingJobs`](crate::client::fluent_builders::ListLabelingJobs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListLabelingJobs::into_paginator).
    pub fn list_labeling_jobs(&self) -> fluent_builders::ListLabelingJobs<C, M, R> {
        fluent_builders::ListLabelingJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLabelingJobsForWorkteam` operation.
    ///
    /// See [`ListLabelingJobsForWorkteam`](crate::client::fluent_builders::ListLabelingJobsForWorkteam) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListLabelingJobsForWorkteam::into_paginator).
    pub fn list_labeling_jobs_for_workteam(
        &self,
    ) -> fluent_builders::ListLabelingJobsForWorkteam<C, M, R> {
        fluent_builders::ListLabelingJobsForWorkteam::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLineageGroups` operation.
    ///
    /// See [`ListLineageGroups`](crate::client::fluent_builders::ListLineageGroups) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListLineageGroups::into_paginator).
    pub fn list_lineage_groups(&self) -> fluent_builders::ListLineageGroups<C, M, R> {
        fluent_builders::ListLineageGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListModelBiasJobDefinitions` operation.
    ///
    /// See [`ListModelBiasJobDefinitions`](crate::client::fluent_builders::ListModelBiasJobDefinitions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListModelBiasJobDefinitions::into_paginator).
    pub fn list_model_bias_job_definitions(
        &self,
    ) -> fluent_builders::ListModelBiasJobDefinitions<C, M, R> {
        fluent_builders::ListModelBiasJobDefinitions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListModelExplainabilityJobDefinitions` operation.
    ///
    /// See [`ListModelExplainabilityJobDefinitions`](crate::client::fluent_builders::ListModelExplainabilityJobDefinitions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListModelExplainabilityJobDefinitions::into_paginator).
    pub fn list_model_explainability_job_definitions(
        &self,
    ) -> fluent_builders::ListModelExplainabilityJobDefinitions<C, M, R> {
        fluent_builders::ListModelExplainabilityJobDefinitions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListModelMetadata` operation.
    ///
    /// See [`ListModelMetadata`](crate::client::fluent_builders::ListModelMetadata) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListModelMetadata::into_paginator).
    pub fn list_model_metadata(&self) -> fluent_builders::ListModelMetadata<C, M, R> {
        fluent_builders::ListModelMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListModelPackageGroups` operation.
    ///
    /// See [`ListModelPackageGroups`](crate::client::fluent_builders::ListModelPackageGroups) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListModelPackageGroups::into_paginator).
    pub fn list_model_package_groups(&self) -> fluent_builders::ListModelPackageGroups<C, M, R> {
        fluent_builders::ListModelPackageGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListModelPackages` operation.
    ///
    /// See [`ListModelPackages`](crate::client::fluent_builders::ListModelPackages) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListModelPackages::into_paginator).
    pub fn list_model_packages(&self) -> fluent_builders::ListModelPackages<C, M, R> {
        fluent_builders::ListModelPackages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListModelQualityJobDefinitions` operation.
    ///
    /// See [`ListModelQualityJobDefinitions`](crate::client::fluent_builders::ListModelQualityJobDefinitions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListModelQualityJobDefinitions::into_paginator).
    pub fn list_model_quality_job_definitions(
        &self,
    ) -> fluent_builders::ListModelQualityJobDefinitions<C, M, R> {
        fluent_builders::ListModelQualityJobDefinitions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListModels` operation.
    ///
    /// See [`ListModels`](crate::client::fluent_builders::ListModels) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListModels::into_paginator).
    pub fn list_models(&self) -> fluent_builders::ListModels<C, M, R> {
        fluent_builders::ListModels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListMonitoringExecutions` operation.
    ///
    /// See [`ListMonitoringExecutions`](crate::client::fluent_builders::ListMonitoringExecutions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListMonitoringExecutions::into_paginator).
    pub fn list_monitoring_executions(&self) -> fluent_builders::ListMonitoringExecutions<C, M, R> {
        fluent_builders::ListMonitoringExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListMonitoringSchedules` operation.
    ///
    /// See [`ListMonitoringSchedules`](crate::client::fluent_builders::ListMonitoringSchedules) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListMonitoringSchedules::into_paginator).
    pub fn list_monitoring_schedules(&self) -> fluent_builders::ListMonitoringSchedules<C, M, R> {
        fluent_builders::ListMonitoringSchedules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListNotebookInstanceLifecycleConfigs` operation.
    ///
    /// See [`ListNotebookInstanceLifecycleConfigs`](crate::client::fluent_builders::ListNotebookInstanceLifecycleConfigs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListNotebookInstanceLifecycleConfigs::into_paginator).
    pub fn list_notebook_instance_lifecycle_configs(
        &self,
    ) -> fluent_builders::ListNotebookInstanceLifecycleConfigs<C, M, R> {
        fluent_builders::ListNotebookInstanceLifecycleConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListNotebookInstances` operation.
    ///
    /// See [`ListNotebookInstances`](crate::client::fluent_builders::ListNotebookInstances) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListNotebookInstances::into_paginator).
    pub fn list_notebook_instances(&self) -> fluent_builders::ListNotebookInstances<C, M, R> {
        fluent_builders::ListNotebookInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPipelineExecutions` operation.
    ///
    /// See [`ListPipelineExecutions`](crate::client::fluent_builders::ListPipelineExecutions) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListPipelineExecutions::into_paginator).
    pub fn list_pipeline_executions(&self) -> fluent_builders::ListPipelineExecutions<C, M, R> {
        fluent_builders::ListPipelineExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPipelineExecutionSteps` operation.
    ///
    /// See [`ListPipelineExecutionSteps`](crate::client::fluent_builders::ListPipelineExecutionSteps) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListPipelineExecutionSteps::into_paginator).
    pub fn list_pipeline_execution_steps(
        &self,
    ) -> fluent_builders::ListPipelineExecutionSteps<C, M, R> {
        fluent_builders::ListPipelineExecutionSteps::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPipelineParametersForExecution` operation.
    ///
    /// See [`ListPipelineParametersForExecution`](crate::client::fluent_builders::ListPipelineParametersForExecution) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListPipelineParametersForExecution::into_paginator).
    pub fn list_pipeline_parameters_for_execution(
        &self,
    ) -> fluent_builders::ListPipelineParametersForExecution<C, M, R> {
        fluent_builders::ListPipelineParametersForExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPipelines` operation.
    ///
    /// See [`ListPipelines`](crate::client::fluent_builders::ListPipelines) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListPipelines::into_paginator).
    pub fn list_pipelines(&self) -> fluent_builders::ListPipelines<C, M, R> {
        fluent_builders::ListPipelines::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProcessingJobs` operation.
    ///
    /// See [`ListProcessingJobs`](crate::client::fluent_builders::ListProcessingJobs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListProcessingJobs::into_paginator).
    pub fn list_processing_jobs(&self) -> fluent_builders::ListProcessingJobs<C, M, R> {
        fluent_builders::ListProcessingJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProjects` operation.
    ///
    /// See [`ListProjects`](crate::client::fluent_builders::ListProjects) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListProjects::into_paginator).
    pub fn list_projects(&self) -> fluent_builders::ListProjects<C, M, R> {
        fluent_builders::ListProjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListStudioLifecycleConfigs` operation.
    ///
    /// See [`ListStudioLifecycleConfigs`](crate::client::fluent_builders::ListStudioLifecycleConfigs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListStudioLifecycleConfigs::into_paginator).
    pub fn list_studio_lifecycle_configs(
        &self,
    ) -> fluent_builders::ListStudioLifecycleConfigs<C, M, R> {
        fluent_builders::ListStudioLifecycleConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSubscribedWorkteams` operation.
    ///
    /// See [`ListSubscribedWorkteams`](crate::client::fluent_builders::ListSubscribedWorkteams) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListSubscribedWorkteams::into_paginator).
    pub fn list_subscribed_workteams(&self) -> fluent_builders::ListSubscribedWorkteams<C, M, R> {
        fluent_builders::ListSubscribedWorkteams::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTags` operation.
    ///
    /// See [`ListTags`](crate::client::fluent_builders::ListTags) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListTags::into_paginator).
    pub fn list_tags(&self) -> fluent_builders::ListTags<C, M, R> {
        fluent_builders::ListTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTrainingJobs` operation.
    ///
    /// See [`ListTrainingJobs`](crate::client::fluent_builders::ListTrainingJobs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListTrainingJobs::into_paginator).
    pub fn list_training_jobs(&self) -> fluent_builders::ListTrainingJobs<C, M, R> {
        fluent_builders::ListTrainingJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTrainingJobsForHyperParameterTuningJob` operation.
    ///
    /// See [`ListTrainingJobsForHyperParameterTuningJob`](crate::client::fluent_builders::ListTrainingJobsForHyperParameterTuningJob) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListTrainingJobsForHyperParameterTuningJob::into_paginator).
    pub fn list_training_jobs_for_hyper_parameter_tuning_job(
        &self,
    ) -> fluent_builders::ListTrainingJobsForHyperParameterTuningJob<C, M, R> {
        fluent_builders::ListTrainingJobsForHyperParameterTuningJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTransformJobs` operation.
    ///
    /// See [`ListTransformJobs`](crate::client::fluent_builders::ListTransformJobs) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListTransformJobs::into_paginator).
    pub fn list_transform_jobs(&self) -> fluent_builders::ListTransformJobs<C, M, R> {
        fluent_builders::ListTransformJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTrialComponents` operation.
    ///
    /// See [`ListTrialComponents`](crate::client::fluent_builders::ListTrialComponents) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListTrialComponents::into_paginator).
    pub fn list_trial_components(&self) -> fluent_builders::ListTrialComponents<C, M, R> {
        fluent_builders::ListTrialComponents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTrials` operation.
    ///
    /// See [`ListTrials`](crate::client::fluent_builders::ListTrials) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListTrials::into_paginator).
    pub fn list_trials(&self) -> fluent_builders::ListTrials<C, M, R> {
        fluent_builders::ListTrials::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListUserProfiles` operation.
    ///
    /// See [`ListUserProfiles`](crate::client::fluent_builders::ListUserProfiles) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListUserProfiles::into_paginator).
    pub fn list_user_profiles(&self) -> fluent_builders::ListUserProfiles<C, M, R> {
        fluent_builders::ListUserProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListWorkforces` operation.
    ///
    /// See [`ListWorkforces`](crate::client::fluent_builders::ListWorkforces) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListWorkforces::into_paginator).
    pub fn list_workforces(&self) -> fluent_builders::ListWorkforces<C, M, R> {
        fluent_builders::ListWorkforces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListWorkteams` operation.
    ///
    /// See [`ListWorkteams`](crate::client::fluent_builders::ListWorkteams) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::ListWorkteams::into_paginator).
    pub fn list_workteams(&self) -> fluent_builders::ListWorkteams<C, M, R> {
        fluent_builders::ListWorkteams::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutModelPackageGroupPolicy` operation.
    ///
    /// See [`PutModelPackageGroupPolicy`](crate::client::fluent_builders::PutModelPackageGroupPolicy) for more information about the
    /// operation and its arguments.
    pub fn put_model_package_group_policy(
        &self,
    ) -> fluent_builders::PutModelPackageGroupPolicy<C, M, R> {
        fluent_builders::PutModelPackageGroupPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `QueryLineage` operation.
    ///
    /// See [`QueryLineage`](crate::client::fluent_builders::QueryLineage) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::QueryLineage::into_paginator).
    pub fn query_lineage(&self) -> fluent_builders::QueryLineage<C, M, R> {
        fluent_builders::QueryLineage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterDevices` operation.
    ///
    /// See [`RegisterDevices`](crate::client::fluent_builders::RegisterDevices) for more information about the
    /// operation and its arguments.
    pub fn register_devices(&self) -> fluent_builders::RegisterDevices<C, M, R> {
        fluent_builders::RegisterDevices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RenderUiTemplate` operation.
    ///
    /// See [`RenderUiTemplate`](crate::client::fluent_builders::RenderUiTemplate) for more information about the
    /// operation and its arguments.
    pub fn render_ui_template(&self) -> fluent_builders::RenderUiTemplate<C, M, R> {
        fluent_builders::RenderUiTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RetryPipelineExecution` operation.
    ///
    /// See [`RetryPipelineExecution`](crate::client::fluent_builders::RetryPipelineExecution) for more information about the
    /// operation and its arguments.
    pub fn retry_pipeline_execution(&self) -> fluent_builders::RetryPipelineExecution<C, M, R> {
        fluent_builders::RetryPipelineExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `Search` operation.
    ///
    /// See [`Search`](crate::client::fluent_builders::Search) for more information about the
    /// operation and its arguments.
    /// This operation supports pagination. See [`into_paginator()`](crate::client::fluent_builders::Search::into_paginator).
    pub fn search(&self) -> fluent_builders::Search<C, M, R> {
        fluent_builders::Search::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendPipelineExecutionStepFailure` operation.
    ///
    /// See [`SendPipelineExecutionStepFailure`](crate::client::fluent_builders::SendPipelineExecutionStepFailure) for more information about the
    /// operation and its arguments.
    pub fn send_pipeline_execution_step_failure(
        &self,
    ) -> fluent_builders::SendPipelineExecutionStepFailure<C, M, R> {
        fluent_builders::SendPipelineExecutionStepFailure::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendPipelineExecutionStepSuccess` operation.
    ///
    /// See [`SendPipelineExecutionStepSuccess`](crate::client::fluent_builders::SendPipelineExecutionStepSuccess) for more information about the
    /// operation and its arguments.
    pub fn send_pipeline_execution_step_success(
        &self,
    ) -> fluent_builders::SendPipelineExecutionStepSuccess<C, M, R> {
        fluent_builders::SendPipelineExecutionStepSuccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartMonitoringSchedule` operation.
    ///
    /// See [`StartMonitoringSchedule`](crate::client::fluent_builders::StartMonitoringSchedule) for more information about the
    /// operation and its arguments.
    pub fn start_monitoring_schedule(&self) -> fluent_builders::StartMonitoringSchedule<C, M, R> {
        fluent_builders::StartMonitoringSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartNotebookInstance` operation.
    ///
    /// See [`StartNotebookInstance`](crate::client::fluent_builders::StartNotebookInstance) for more information about the
    /// operation and its arguments.
    pub fn start_notebook_instance(&self) -> fluent_builders::StartNotebookInstance<C, M, R> {
        fluent_builders::StartNotebookInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartPipelineExecution` operation.
    ///
    /// See [`StartPipelineExecution`](crate::client::fluent_builders::StartPipelineExecution) for more information about the
    /// operation and its arguments.
    pub fn start_pipeline_execution(&self) -> fluent_builders::StartPipelineExecution<C, M, R> {
        fluent_builders::StartPipelineExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopAutoMLJob` operation.
    ///
    /// See [`StopAutoMLJob`](crate::client::fluent_builders::StopAutoMLJob) for more information about the
    /// operation and its arguments.
    pub fn stop_auto_ml_job(&self) -> fluent_builders::StopAutoMLJob<C, M, R> {
        fluent_builders::StopAutoMLJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopCompilationJob` operation.
    ///
    /// See [`StopCompilationJob`](crate::client::fluent_builders::StopCompilationJob) for more information about the
    /// operation and its arguments.
    pub fn stop_compilation_job(&self) -> fluent_builders::StopCompilationJob<C, M, R> {
        fluent_builders::StopCompilationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopEdgePackagingJob` operation.
    ///
    /// See [`StopEdgePackagingJob`](crate::client::fluent_builders::StopEdgePackagingJob) for more information about the
    /// operation and its arguments.
    pub fn stop_edge_packaging_job(&self) -> fluent_builders::StopEdgePackagingJob<C, M, R> {
        fluent_builders::StopEdgePackagingJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopHyperParameterTuningJob` operation.
    ///
    /// See [`StopHyperParameterTuningJob`](crate::client::fluent_builders::StopHyperParameterTuningJob) for more information about the
    /// operation and its arguments.
    pub fn stop_hyper_parameter_tuning_job(
        &self,
    ) -> fluent_builders::StopHyperParameterTuningJob<C, M, R> {
        fluent_builders::StopHyperParameterTuningJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopInferenceRecommendationsJob` operation.
    ///
    /// See [`StopInferenceRecommendationsJob`](crate::client::fluent_builders::StopInferenceRecommendationsJob) for more information about the
    /// operation and its arguments.
    pub fn stop_inference_recommendations_job(
        &self,
    ) -> fluent_builders::StopInferenceRecommendationsJob<C, M, R> {
        fluent_builders::StopInferenceRecommendationsJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopLabelingJob` operation.
    ///
    /// See [`StopLabelingJob`](crate::client::fluent_builders::StopLabelingJob) for more information about the
    /// operation and its arguments.
    pub fn stop_labeling_job(&self) -> fluent_builders::StopLabelingJob<C, M, R> {
        fluent_builders::StopLabelingJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopMonitoringSchedule` operation.
    ///
    /// See [`StopMonitoringSchedule`](crate::client::fluent_builders::StopMonitoringSchedule) for more information about the
    /// operation and its arguments.
    pub fn stop_monitoring_schedule(&self) -> fluent_builders::StopMonitoringSchedule<C, M, R> {
        fluent_builders::StopMonitoringSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopNotebookInstance` operation.
    ///
    /// See [`StopNotebookInstance`](crate::client::fluent_builders::StopNotebookInstance) for more information about the
    /// operation and its arguments.
    pub fn stop_notebook_instance(&self) -> fluent_builders::StopNotebookInstance<C, M, R> {
        fluent_builders::StopNotebookInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopPipelineExecution` operation.
    ///
    /// See [`StopPipelineExecution`](crate::client::fluent_builders::StopPipelineExecution) for more information about the
    /// operation and its arguments.
    pub fn stop_pipeline_execution(&self) -> fluent_builders::StopPipelineExecution<C, M, R> {
        fluent_builders::StopPipelineExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopProcessingJob` operation.
    ///
    /// See [`StopProcessingJob`](crate::client::fluent_builders::StopProcessingJob) for more information about the
    /// operation and its arguments.
    pub fn stop_processing_job(&self) -> fluent_builders::StopProcessingJob<C, M, R> {
        fluent_builders::StopProcessingJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopTrainingJob` operation.
    ///
    /// See [`StopTrainingJob`](crate::client::fluent_builders::StopTrainingJob) for more information about the
    /// operation and its arguments.
    pub fn stop_training_job(&self) -> fluent_builders::StopTrainingJob<C, M, R> {
        fluent_builders::StopTrainingJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopTransformJob` operation.
    ///
    /// See [`StopTransformJob`](crate::client::fluent_builders::StopTransformJob) for more information about the
    /// operation and its arguments.
    pub fn stop_transform_job(&self) -> fluent_builders::StopTransformJob<C, M, R> {
        fluent_builders::StopTransformJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAction` operation.
    ///
    /// See [`UpdateAction`](crate::client::fluent_builders::UpdateAction) for more information about the
    /// operation and its arguments.
    pub fn update_action(&self) -> fluent_builders::UpdateAction<C, M, R> {
        fluent_builders::UpdateAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAppImageConfig` operation.
    ///
    /// See [`UpdateAppImageConfig`](crate::client::fluent_builders::UpdateAppImageConfig) for more information about the
    /// operation and its arguments.
    pub fn update_app_image_config(&self) -> fluent_builders::UpdateAppImageConfig<C, M, R> {
        fluent_builders::UpdateAppImageConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateArtifact` operation.
    ///
    /// See [`UpdateArtifact`](crate::client::fluent_builders::UpdateArtifact) for more information about the
    /// operation and its arguments.
    pub fn update_artifact(&self) -> fluent_builders::UpdateArtifact<C, M, R> {
        fluent_builders::UpdateArtifact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateCodeRepository` operation.
    ///
    /// See [`UpdateCodeRepository`](crate::client::fluent_builders::UpdateCodeRepository) for more information about the
    /// operation and its arguments.
    pub fn update_code_repository(&self) -> fluent_builders::UpdateCodeRepository<C, M, R> {
        fluent_builders::UpdateCodeRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateContext` operation.
    ///
    /// See [`UpdateContext`](crate::client::fluent_builders::UpdateContext) for more information about the
    /// operation and its arguments.
    pub fn update_context(&self) -> fluent_builders::UpdateContext<C, M, R> {
        fluent_builders::UpdateContext::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDeviceFleet` operation.
    ///
    /// See [`UpdateDeviceFleet`](crate::client::fluent_builders::UpdateDeviceFleet) for more information about the
    /// operation and its arguments.
    pub fn update_device_fleet(&self) -> fluent_builders::UpdateDeviceFleet<C, M, R> {
        fluent_builders::UpdateDeviceFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDevices` operation.
    ///
    /// See [`UpdateDevices`](crate::client::fluent_builders::UpdateDevices) for more information about the
    /// operation and its arguments.
    pub fn update_devices(&self) -> fluent_builders::UpdateDevices<C, M, R> {
        fluent_builders::UpdateDevices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDomain` operation.
    ///
    /// See [`UpdateDomain`](crate::client::fluent_builders::UpdateDomain) for more information about the
    /// operation and its arguments.
    pub fn update_domain(&self) -> fluent_builders::UpdateDomain<C, M, R> {
        fluent_builders::UpdateDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateEndpoint` operation.
    ///
    /// See [`UpdateEndpoint`](crate::client::fluent_builders::UpdateEndpoint) for more information about the
    /// operation and its arguments.
    pub fn update_endpoint(&self) -> fluent_builders::UpdateEndpoint<C, M, R> {
        fluent_builders::UpdateEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateEndpointWeightsAndCapacities` operation.
    ///
    /// See [`UpdateEndpointWeightsAndCapacities`](crate::client::fluent_builders::UpdateEndpointWeightsAndCapacities) for more information about the
    /// operation and its arguments.
    pub fn update_endpoint_weights_and_capacities(
        &self,
    ) -> fluent_builders::UpdateEndpointWeightsAndCapacities<C, M, R> {
        fluent_builders::UpdateEndpointWeightsAndCapacities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateExperiment` operation.
    ///
    /// See [`UpdateExperiment`](crate::client::fluent_builders::UpdateExperiment) for more information about the
    /// operation and its arguments.
    pub fn update_experiment(&self) -> fluent_builders::UpdateExperiment<C, M, R> {
        fluent_builders::UpdateExperiment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateImage` operation.
    ///
    /// See [`UpdateImage`](crate::client::fluent_builders::UpdateImage) for more information about the
    /// operation and its arguments.
    pub fn update_image(&self) -> fluent_builders::UpdateImage<C, M, R> {
        fluent_builders::UpdateImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateModelPackage` operation.
    ///
    /// See [`UpdateModelPackage`](crate::client::fluent_builders::UpdateModelPackage) for more information about the
    /// operation and its arguments.
    pub fn update_model_package(&self) -> fluent_builders::UpdateModelPackage<C, M, R> {
        fluent_builders::UpdateModelPackage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateMonitoringSchedule` operation.
    ///
    /// See [`UpdateMonitoringSchedule`](crate::client::fluent_builders::UpdateMonitoringSchedule) for more information about the
    /// operation and its arguments.
    pub fn update_monitoring_schedule(&self) -> fluent_builders::UpdateMonitoringSchedule<C, M, R> {
        fluent_builders::UpdateMonitoringSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateNotebookInstance` operation.
    ///
    /// See [`UpdateNotebookInstance`](crate::client::fluent_builders::UpdateNotebookInstance) for more information about the
    /// operation and its arguments.
    pub fn update_notebook_instance(&self) -> fluent_builders::UpdateNotebookInstance<C, M, R> {
        fluent_builders::UpdateNotebookInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateNotebookInstanceLifecycleConfig` operation.
    ///
    /// See [`UpdateNotebookInstanceLifecycleConfig`](crate::client::fluent_builders::UpdateNotebookInstanceLifecycleConfig) for more information about the
    /// operation and its arguments.
    pub fn update_notebook_instance_lifecycle_config(
        &self,
    ) -> fluent_builders::UpdateNotebookInstanceLifecycleConfig<C, M, R> {
        fluent_builders::UpdateNotebookInstanceLifecycleConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePipeline` operation.
    ///
    /// See [`UpdatePipeline`](crate::client::fluent_builders::UpdatePipeline) for more information about the
    /// operation and its arguments.
    pub fn update_pipeline(&self) -> fluent_builders::UpdatePipeline<C, M, R> {
        fluent_builders::UpdatePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePipelineExecution` operation.
    ///
    /// See [`UpdatePipelineExecution`](crate::client::fluent_builders::UpdatePipelineExecution) for more information about the
    /// operation and its arguments.
    pub fn update_pipeline_execution(&self) -> fluent_builders::UpdatePipelineExecution<C, M, R> {
        fluent_builders::UpdatePipelineExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateProject` operation.
    ///
    /// See [`UpdateProject`](crate::client::fluent_builders::UpdateProject) for more information about the
    /// operation and its arguments.
    pub fn update_project(&self) -> fluent_builders::UpdateProject<C, M, R> {
        fluent_builders::UpdateProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTrainingJob` operation.
    ///
    /// See [`UpdateTrainingJob`](crate::client::fluent_builders::UpdateTrainingJob) for more information about the
    /// operation and its arguments.
    pub fn update_training_job(&self) -> fluent_builders::UpdateTrainingJob<C, M, R> {
        fluent_builders::UpdateTrainingJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTrial` operation.
    ///
    /// See [`UpdateTrial`](crate::client::fluent_builders::UpdateTrial) for more information about the
    /// operation and its arguments.
    pub fn update_trial(&self) -> fluent_builders::UpdateTrial<C, M, R> {
        fluent_builders::UpdateTrial::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTrialComponent` operation.
    ///
    /// See [`UpdateTrialComponent`](crate::client::fluent_builders::UpdateTrialComponent) for more information about the
    /// operation and its arguments.
    pub fn update_trial_component(&self) -> fluent_builders::UpdateTrialComponent<C, M, R> {
        fluent_builders::UpdateTrialComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateUserProfile` operation.
    ///
    /// See [`UpdateUserProfile`](crate::client::fluent_builders::UpdateUserProfile) for more information about the
    /// operation and its arguments.
    pub fn update_user_profile(&self) -> fluent_builders::UpdateUserProfile<C, M, R> {
        fluent_builders::UpdateUserProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateWorkforce` operation.
    ///
    /// See [`UpdateWorkforce`](crate::client::fluent_builders::UpdateWorkforce) for more information about the
    /// operation and its arguments.
    pub fn update_workforce(&self) -> fluent_builders::UpdateWorkforce<C, M, R> {
        fluent_builders::UpdateWorkforce::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateWorkteam` operation.
    ///
    /// See [`UpdateWorkteam`](crate::client::fluent_builders::UpdateWorkteam) for more information about the
    /// operation and its arguments.
    pub fn update_workteam(&self) -> fluent_builders::UpdateWorkteam<C, M, R> {
        fluent_builders::UpdateWorkteam::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddAssociation`.
    ///
    /// <p>Creates an <i>association</i> between the source and the destination. A source can be associated with multiple destinations, and a destination can be associated with multiple sources. An association is a lineage tracking entity. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage Tracking</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddAssociation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_association_input::Builder,
    }
    impl<C, M, R> AddAssociation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::AddAssociationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddAssociationInputOperationOutputAlias,
                crate::output::AddAssociationOutput,
                crate::error::AddAssociationError,
                crate::input::AddAssociationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the source.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_arn(input.into());
            self
        }
        /// <p>The ARN of the source.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the destination.</p>
        pub fn destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the destination.</p>
        pub fn set_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_arn(input);
            self
        }
        /// <p>The type of association. The following are suggested uses for each type. Amazon SageMaker places no restrictions on their use.</p>
        /// <ul>
        /// <li> <p>ContributedTo - The source contributed to the destination or had a part in enabling the destination. For example, the training data contributed to the training job.</p> </li>
        /// <li> <p>AssociatedWith - The source is connected to the destination. For example, an approval workflow is associated with a model deployment.</p> </li>
        /// <li> <p>DerivedFrom - The destination is a modification of the source. For example, a digest output of a channel input for a processing job is derived from the original inputs.</p> </li>
        /// <li> <p>Produced - The source generated the destination. For example, a training job produced a model artifact.</p> </li>
        /// </ul>
        pub fn association_type(mut self, input: crate::model::AssociationEdgeType) -> Self {
            self.inner = self.inner.association_type(input);
            self
        }
        /// <p>The type of association. The following are suggested uses for each type. Amazon SageMaker places no restrictions on their use.</p>
        /// <ul>
        /// <li> <p>ContributedTo - The source contributed to the destination or had a part in enabling the destination. For example, the training data contributed to the training job.</p> </li>
        /// <li> <p>AssociatedWith - The source is connected to the destination. For example, an approval workflow is associated with a model deployment.</p> </li>
        /// <li> <p>DerivedFrom - The destination is a modification of the source. For example, a digest output of a channel input for a processing job is derived from the original inputs.</p> </li>
        /// <li> <p>Produced - The source generated the destination. For example, a training job produced a model artifact.</p> </li>
        /// </ul>
        pub fn set_association_type(
            mut self,
            input: std::option::Option<crate::model::AssociationEdgeType>,
        ) -> Self {
            self.inner = self.inner.set_association_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddTags`.
    ///
    /// <p>Adds or overwrites one or more tags for the specified Amazon SageMaker resource. You can add tags to notebook instances, training jobs, hyperparameter tuning jobs, batch transform jobs, models, labeling jobs, work teams, endpoint configurations, and endpoints.</p>
    /// <p>Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information about tags, see For more information, see <a href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">Amazon Web Services Tagging Strategies</a>.</p> <note>
    /// <p>Tags that you add to a hyperparameter tuning job by calling this API are also added to any training jobs that the hyperparameter tuning job launches after you call this API, but not to training jobs that the hyperparameter tuning job launched before you called this API. To make sure that the tags associated with a hyperparameter tuning job are also added to all training jobs that the hyperparameter tuning job launches, add the tags when you first create the tuning job by specifying them in the <code>Tags</code> parameter of <code>CreateHyperParameterTuningJob</code> </p>
    /// </note> <note>
    /// <p>Tags that you add to a SageMaker Studio Domain or User Profile by calling this API are also added to any Apps that the Domain or User Profile launches after you call this API, but not to Apps that the Domain or User Profile launched before you called this API. To make sure that the tags associated with a Domain or User Profile are also added to all Apps that the Domain or User Profile launches, add the tags when you first create the Domain or User Profile by specifying them in the <code>Tags</code> parameter of <code>CreateDomain</code> or <code>CreateUserProfile</code>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_tags_input::Builder,
    }
    impl<C, M, R> AddTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddTagsInputOperationOutputAlias,
                crate::output::AddTagsOutput,
                crate::error::AddTagsError,
                crate::input::AddTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateTrialComponent`.
    ///
    /// <p>Associates a trial component with a trial. A trial component can be associated with multiple trials. To disassociate a trial component from a trial, call the <code>DisassociateTrialComponent</code> API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateTrialComponent<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_trial_component_input::Builder,
    }
    impl<C, M, R> AssociateTrialComponent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateTrialComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateTrialComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateTrialComponentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateTrialComponentInputOperationOutputAlias,
                crate::output::AssociateTrialComponentOutput,
                crate::error::AssociateTrialComponentError,
                crate::input::AssociateTrialComponentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the component to associated with the trial.</p>
        pub fn trial_component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trial_component_name(input.into());
            self
        }
        /// <p>The name of the component to associated with the trial.</p>
        pub fn set_trial_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_trial_component_name(input);
            self
        }
        /// <p>The name of the trial to associate with.</p>
        pub fn trial_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trial_name(input.into());
            self
        }
        /// <p>The name of the trial to associate with.</p>
        pub fn set_trial_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_trial_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDescribeModelPackage`.
    ///
    /// <p>This action batch describes a list of versioned model packages</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchDescribeModelPackage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_describe_model_package_input::Builder,
    }
    impl<C, M, R> BatchDescribeModelPackage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDescribeModelPackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDescribeModelPackageOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDescribeModelPackageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDescribeModelPackageInputOperationOutputAlias,
                crate::output::BatchDescribeModelPackageOutput,
                crate::error::BatchDescribeModelPackageError,
                crate::input::BatchDescribeModelPackageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ModelPackageArnList`.
        ///
        /// To override the contents of this collection use [`set_model_package_arn_list`](Self::set_model_package_arn_list).
        ///
        /// <p>The list of Amazon Resource Name (ARN) of the model package groups.</p>
        pub fn model_package_arn_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_package_arn_list(input.into());
            self
        }
        /// <p>The list of Amazon Resource Name (ARN) of the model package groups.</p>
        pub fn set_model_package_arn_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_model_package_arn_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAction`.
    ///
    /// <p>Creates an <i>action</i>. An action is a lineage tracking entity that represents an action or activity. For example, a model deployment or an HPO job. Generally, an action involves at least one input or output artifact. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage Tracking</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_action_input::Builder,
    }
    impl<C, M, R> CreateAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateActionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateActionInputOperationOutputAlias,
                crate::output::CreateActionOutput,
                crate::error::CreateActionError,
                crate::input::CreateActionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the action. Must be unique to your account in an Amazon Web Services Region.</p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_name(input.into());
            self
        }
        /// <p>The name of the action. Must be unique to your account in an Amazon Web Services Region.</p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action_name(input);
            self
        }
        /// <p>The source type, ID, and URI.</p>
        pub fn source(mut self, input: crate::model::ActionSource) -> Self {
            self.inner = self.inner.source(input);
            self
        }
        /// <p>The source type, ID, and URI.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::ActionSource>,
        ) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// <p>The action type.</p>
        pub fn action_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_type(input.into());
            self
        }
        /// <p>The action type.</p>
        pub fn set_action_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action_type(input);
            self
        }
        /// <p>The description of the action.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the action.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The status of the action.</p>
        pub fn status(mut self, input: crate::model::ActionStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The status of the action.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ActionStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// Adds a key-value pair to `Properties`.
        ///
        /// To override the contents of this collection use [`set_properties`](Self::set_properties).
        ///
        /// <p>A list of properties to add to the action.</p>
        pub fn properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.properties(k.into(), v.into());
            self
        }
        /// <p>A list of properties to add to the action.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_properties(input);
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn metadata_properties(mut self, input: crate::model::MetadataProperties) -> Self {
            self.inner = self.inner.metadata_properties(input);
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn set_metadata_properties(
            mut self,
            input: std::option::Option<crate::model::MetadataProperties>,
        ) -> Self {
            self.inner = self.inner.set_metadata_properties(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to apply to the action.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to apply to the action.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAlgorithm`.
    ///
    /// <p>Create a machine learning algorithm that you can use in Amazon SageMaker and list in the Amazon Web Services Marketplace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAlgorithm<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_algorithm_input::Builder,
    }
    impl<C, M, R> CreateAlgorithm<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAlgorithm`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAlgorithmOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAlgorithmError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAlgorithmInputOperationOutputAlias,
                crate::output::CreateAlgorithmOutput,
                crate::error::CreateAlgorithmError,
                crate::input::CreateAlgorithmInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the algorithm.</p>
        pub fn algorithm_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.algorithm_name(input.into());
            self
        }
        /// <p>The name of the algorithm.</p>
        pub fn set_algorithm_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_algorithm_name(input);
            self
        }
        /// <p>A description of the algorithm.</p>
        pub fn algorithm_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.algorithm_description(input.into());
            self
        }
        /// <p>A description of the algorithm.</p>
        pub fn set_algorithm_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_algorithm_description(input);
            self
        }
        /// <p>Specifies details about training jobs run by this algorithm, including the following:</p>
        /// <ul>
        /// <li> <p>The Amazon ECR path of the container and the version digest of the algorithm.</p> </li>
        /// <li> <p>The hyperparameters that the algorithm supports.</p> </li>
        /// <li> <p>The instance types that the algorithm supports for training.</p> </li>
        /// <li> <p>Whether the algorithm supports distributed training.</p> </li>
        /// <li> <p>The metrics that the algorithm emits to Amazon CloudWatch.</p> </li>
        /// <li> <p>Which metrics that the algorithm emits can be used as the objective metric for hyperparameter tuning jobs.</p> </li>
        /// <li> <p>The input channels that the algorithm supports for training data. For example, an algorithm might support <code>train</code>, <code>validation</code>, and <code>test</code> channels.</p> </li>
        /// </ul>
        pub fn training_specification(
            mut self,
            input: crate::model::TrainingSpecification,
        ) -> Self {
            self.inner = self.inner.training_specification(input);
            self
        }
        /// <p>Specifies details about training jobs run by this algorithm, including the following:</p>
        /// <ul>
        /// <li> <p>The Amazon ECR path of the container and the version digest of the algorithm.</p> </li>
        /// <li> <p>The hyperparameters that the algorithm supports.</p> </li>
        /// <li> <p>The instance types that the algorithm supports for training.</p> </li>
        /// <li> <p>Whether the algorithm supports distributed training.</p> </li>
        /// <li> <p>The metrics that the algorithm emits to Amazon CloudWatch.</p> </li>
        /// <li> <p>Which metrics that the algorithm emits can be used as the objective metric for hyperparameter tuning jobs.</p> </li>
        /// <li> <p>The input channels that the algorithm supports for training data. For example, an algorithm might support <code>train</code>, <code>validation</code>, and <code>test</code> channels.</p> </li>
        /// </ul>
        pub fn set_training_specification(
            mut self,
            input: std::option::Option<crate::model::TrainingSpecification>,
        ) -> Self {
            self.inner = self.inner.set_training_specification(input);
            self
        }
        /// <p>Specifies details about inference jobs that the algorithm runs, including the following:</p>
        /// <ul>
        /// <li> <p>The Amazon ECR paths of containers that contain the inference code and model artifacts.</p> </li>
        /// <li> <p>The instance types that the algorithm supports for transform jobs and real-time endpoints used for inference.</p> </li>
        /// <li> <p>The input and output content formats that the algorithm supports for inference.</p> </li>
        /// </ul>
        pub fn inference_specification(
            mut self,
            input: crate::model::InferenceSpecification,
        ) -> Self {
            self.inner = self.inner.inference_specification(input);
            self
        }
        /// <p>Specifies details about inference jobs that the algorithm runs, including the following:</p>
        /// <ul>
        /// <li> <p>The Amazon ECR paths of containers that contain the inference code and model artifacts.</p> </li>
        /// <li> <p>The instance types that the algorithm supports for transform jobs and real-time endpoints used for inference.</p> </li>
        /// <li> <p>The input and output content formats that the algorithm supports for inference.</p> </li>
        /// </ul>
        pub fn set_inference_specification(
            mut self,
            input: std::option::Option<crate::model::InferenceSpecification>,
        ) -> Self {
            self.inner = self.inner.set_inference_specification(input);
            self
        }
        /// <p>Specifies configurations for one or more training jobs and that Amazon SageMaker runs to test the algorithm's training code and, optionally, one or more batch transform jobs that Amazon SageMaker runs to test the algorithm's inference code.</p>
        pub fn validation_specification(
            mut self,
            input: crate::model::AlgorithmValidationSpecification,
        ) -> Self {
            self.inner = self.inner.validation_specification(input);
            self
        }
        /// <p>Specifies configurations for one or more training jobs and that Amazon SageMaker runs to test the algorithm's training code and, optionally, one or more batch transform jobs that Amazon SageMaker runs to test the algorithm's inference code.</p>
        pub fn set_validation_specification(
            mut self,
            input: std::option::Option<crate::model::AlgorithmValidationSpecification>,
        ) -> Self {
            self.inner = self.inner.set_validation_specification(input);
            self
        }
        /// <p>Whether to certify the algorithm so that it can be listed in Amazon Web Services Marketplace.</p>
        pub fn certify_for_marketplace(mut self, input: bool) -> Self {
            self.inner = self.inner.certify_for_marketplace(input);
            self
        }
        /// <p>Whether to certify the algorithm so that it can be listed in Amazon Web Services Marketplace.</p>
        pub fn set_certify_for_marketplace(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_certify_for_marketplace(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateApp`.
    ///
    /// <p>Creates a running app for the specified UserProfile. Supported apps are <code>JupyterServer</code> and <code>KernelGateway</code>. This operation is automatically invoked by Amazon SageMaker Studio upon access to the associated Domain, and when new kernel configurations are selected by the user. A user may have multiple Apps active simultaneously.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateApp<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_app_input::Builder,
    }
    impl<C, M, R> CreateApp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAppOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAppError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAppInputOperationOutputAlias,
                crate::output::CreateAppOutput,
                crate::error::CreateAppError,
                crate::input::CreateAppInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain ID.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(input.into());
            self
        }
        /// <p>The domain ID.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The user profile name.</p>
        pub fn user_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_profile_name(input.into());
            self
        }
        /// <p>The user profile name.</p>
        pub fn set_user_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_user_profile_name(input);
            self
        }
        /// <p>The type of app. Supported apps are <code>JupyterServer</code> and <code>KernelGateway</code>. <code>TensorBoard</code> is not supported.</p>
        pub fn app_type(mut self, input: crate::model::AppType) -> Self {
            self.inner = self.inner.app_type(input);
            self
        }
        /// <p>The type of app. Supported apps are <code>JupyterServer</code> and <code>KernelGateway</code>. <code>TensorBoard</code> is not supported.</p>
        pub fn set_app_type(mut self, input: std::option::Option<crate::model::AppType>) -> Self {
            self.inner = self.inner.set_app_type(input);
            self
        }
        /// <p>The name of the app.</p>
        pub fn app_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_name(input.into());
            self
        }
        /// <p>The name of the app.</p>
        pub fn set_app_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Each tag consists of a key and an optional value. Tag keys must be unique per resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Each tag consists of a key and an optional value. Tag keys must be unique per resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.</p>
        pub fn resource_spec(mut self, input: crate::model::ResourceSpec) -> Self {
            self.inner = self.inner.resource_spec(input);
            self
        }
        /// <p>The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.</p>
        pub fn set_resource_spec(
            mut self,
            input: std::option::Option<crate::model::ResourceSpec>,
        ) -> Self {
            self.inner = self.inner.set_resource_spec(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAppImageConfig`.
    ///
    /// <p>Creates a configuration for running a SageMaker image as a KernelGateway app. The configuration specifies the Amazon Elastic File System (EFS) storage volume on the image, and a list of the kernels in the image.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAppImageConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_app_image_config_input::Builder,
    }
    impl<C, M, R> CreateAppImageConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAppImageConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAppImageConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAppImageConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAppImageConfigInputOperationOutputAlias,
                crate::output::CreateAppImageConfigOutput,
                crate::error::CreateAppImageConfigError,
                crate::input::CreateAppImageConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the AppImageConfig. Must be unique to your account.</p>
        pub fn app_image_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_image_config_name(input.into());
            self
        }
        /// <p>The name of the AppImageConfig. Must be unique to your account.</p>
        pub fn set_app_image_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_image_config_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to apply to the AppImageConfig.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to apply to the AppImageConfig.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The KernelGatewayImageConfig.</p>
        pub fn kernel_gateway_image_config(
            mut self,
            input: crate::model::KernelGatewayImageConfig,
        ) -> Self {
            self.inner = self.inner.kernel_gateway_image_config(input);
            self
        }
        /// <p>The KernelGatewayImageConfig.</p>
        pub fn set_kernel_gateway_image_config(
            mut self,
            input: std::option::Option<crate::model::KernelGatewayImageConfig>,
        ) -> Self {
            self.inner = self.inner.set_kernel_gateway_image_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateArtifact`.
    ///
    /// <p>Creates an <i>artifact</i>. An artifact is a lineage tracking entity that represents a URI addressable object or data. Some examples are the S3 URI of a dataset and the ECR registry path of an image. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage Tracking</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateArtifact<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_artifact_input::Builder,
    }
    impl<C, M, R> CreateArtifact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateArtifact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateArtifactOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateArtifactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateArtifactInputOperationOutputAlias,
                crate::output::CreateArtifactOutput,
                crate::error::CreateArtifactError,
                crate::input::CreateArtifactInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the artifact. Must be unique to your account in an Amazon Web Services Region.</p>
        pub fn artifact_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.artifact_name(input.into());
            self
        }
        /// <p>The name of the artifact. Must be unique to your account in an Amazon Web Services Region.</p>
        pub fn set_artifact_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_artifact_name(input);
            self
        }
        /// <p>The ID, ID type, and URI of the source.</p>
        pub fn source(mut self, input: crate::model::ArtifactSource) -> Self {
            self.inner = self.inner.source(input);
            self
        }
        /// <p>The ID, ID type, and URI of the source.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::ArtifactSource>,
        ) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// <p>The artifact type.</p>
        pub fn artifact_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.artifact_type(input.into());
            self
        }
        /// <p>The artifact type.</p>
        pub fn set_artifact_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_artifact_type(input);
            self
        }
        /// Adds a key-value pair to `Properties`.
        ///
        /// To override the contents of this collection use [`set_properties`](Self::set_properties).
        ///
        /// <p>A list of properties to add to the artifact.</p>
        pub fn properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.properties(k.into(), v.into());
            self
        }
        /// <p>A list of properties to add to the artifact.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_properties(input);
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn metadata_properties(mut self, input: crate::model::MetadataProperties) -> Self {
            self.inner = self.inner.metadata_properties(input);
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn set_metadata_properties(
            mut self,
            input: std::option::Option<crate::model::MetadataProperties>,
        ) -> Self {
            self.inner = self.inner.set_metadata_properties(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to apply to the artifact.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to apply to the artifact.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAutoMLJob`.
    ///
    /// <p>Creates an Autopilot job.</p>
    /// <p>Find the best-performing model after you run an Autopilot job by calling .</p>
    /// <p>For information about how to use Autopilot, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html">Automate Model Development with Amazon SageMaker Autopilot</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAutoMLJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_auto_ml_job_input::Builder,
    }
    impl<C, M, R> CreateAutoMLJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAutoMLJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAutoMlJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAutoMLJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAutoMlJobInputOperationOutputAlias,
                crate::output::CreateAutoMlJobOutput,
                crate::error::CreateAutoMLJobError,
                crate::input::CreateAutoMlJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies an Autopilot job. The name must be unique to your account and is case-insensitive.</p>
        pub fn auto_ml_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.auto_ml_job_name(input.into());
            self
        }
        /// <p>Identifies an Autopilot job. The name must be unique to your account and is case-insensitive.</p>
        pub fn set_auto_ml_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_auto_ml_job_name(input);
            self
        }
        /// Appends an item to `InputDataConfig`.
        ///
        /// To override the contents of this collection use [`set_input_data_config`](Self::set_input_data_config).
        ///
        /// <p>An array of channel objects that describes the input data and its location. Each channel is a named input source. Similar to <code>InputDataConfig</code> supported by . Format(s) supported: CSV. Minimum of 500 rows.</p>
        pub fn input_data_config(mut self, input: crate::model::AutoMlChannel) -> Self {
            self.inner = self.inner.input_data_config(input);
            self
        }
        /// <p>An array of channel objects that describes the input data and its location. Each channel is a named input source. Similar to <code>InputDataConfig</code> supported by . Format(s) supported: CSV. Minimum of 500 rows.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AutoMlChannel>>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>Provides information about encryption and the Amazon S3 output path needed to store artifacts from an AutoML job. Format(s) supported: CSV.</p>
        pub fn output_data_config(mut self, input: crate::model::AutoMlOutputDataConfig) -> Self {
            self.inner = self.inner.output_data_config(input);
            self
        }
        /// <p>Provides information about encryption and the Amazon S3 output path needed to store artifacts from an AutoML job. Format(s) supported: CSV.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::AutoMlOutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_data_config(input);
            self
        }
        /// <p>Defines the type of supervised learning available for the candidates. Options include: <code>BinaryClassification</code>, <code>MulticlassClassification</code>, and <code>Regression</code>. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-problem-types.html"> Amazon SageMaker Autopilot problem types and algorithm support</a>.</p>
        pub fn problem_type(mut self, input: crate::model::ProblemType) -> Self {
            self.inner = self.inner.problem_type(input);
            self
        }
        /// <p>Defines the type of supervised learning available for the candidates. Options include: <code>BinaryClassification</code>, <code>MulticlassClassification</code>, and <code>Regression</code>. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-problem-types.html"> Amazon SageMaker Autopilot problem types and algorithm support</a>.</p>
        pub fn set_problem_type(
            mut self,
            input: std::option::Option<crate::model::ProblemType>,
        ) -> Self {
            self.inner = self.inner.set_problem_type(input);
            self
        }
        /// <p>Defines the objective metric used to measure the predictive quality of an AutoML job. You provide an <code>AutoMLJobObjective$MetricName</code> and Autopilot infers whether to minimize or maximize it.</p>
        pub fn auto_ml_job_objective(mut self, input: crate::model::AutoMlJobObjective) -> Self {
            self.inner = self.inner.auto_ml_job_objective(input);
            self
        }
        /// <p>Defines the objective metric used to measure the predictive quality of an AutoML job. You provide an <code>AutoMLJobObjective$MetricName</code> and Autopilot infers whether to minimize or maximize it.</p>
        pub fn set_auto_ml_job_objective(
            mut self,
            input: std::option::Option<crate::model::AutoMlJobObjective>,
        ) -> Self {
            self.inner = self.inner.set_auto_ml_job_objective(input);
            self
        }
        /// <p>Contains <code>CompletionCriteria</code> and <code>SecurityConfig</code> settings for the AutoML job.</p>
        pub fn auto_ml_job_config(mut self, input: crate::model::AutoMlJobConfig) -> Self {
            self.inner = self.inner.auto_ml_job_config(input);
            self
        }
        /// <p>Contains <code>CompletionCriteria</code> and <code>SecurityConfig</code> settings for the AutoML job.</p>
        pub fn set_auto_ml_job_config(
            mut self,
            input: std::option::Option<crate::model::AutoMlJobConfig>,
        ) -> Self {
            self.inner = self.inner.set_auto_ml_job_config(input);
            self
        }
        /// <p>The ARN of the role that is used to access the data.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The ARN of the role that is used to access the data.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>Generates possible candidates without training the models. A candidate is a combination of data preprocessors, algorithms, and algorithm parameter settings.</p>
        pub fn generate_candidate_definitions_only(mut self, input: bool) -> Self {
            self.inner = self.inner.generate_candidate_definitions_only(input);
            self
        }
        /// <p>Generates possible candidates without training the models. A candidate is a combination of data preprocessors, algorithms, and algorithm parameter settings.</p>
        pub fn set_generate_candidate_definitions_only(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_generate_candidate_definitions_only(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Each tag consists of a key and an optional value. Tag keys must be unique per resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Each tag consists of a key and an optional value. Tag keys must be unique per resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Specifies how to generate the endpoint name for an automatic one-click Autopilot model deployment.</p>
        pub fn model_deploy_config(mut self, input: crate::model::ModelDeployConfig) -> Self {
            self.inner = self.inner.model_deploy_config(input);
            self
        }
        /// <p>Specifies how to generate the endpoint name for an automatic one-click Autopilot model deployment.</p>
        pub fn set_model_deploy_config(
            mut self,
            input: std::option::Option<crate::model::ModelDeployConfig>,
        ) -> Self {
            self.inner = self.inner.set_model_deploy_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCodeRepository`.
    ///
    /// <p>Creates a Git repository as a resource in your Amazon SageMaker account. You can associate the repository with notebook instances so that you can use Git source control for the notebooks you create. The Git repository is a resource in your Amazon SageMaker account, so it can be associated with more than one notebook instance, and it persists independently from the lifecycle of any notebook instances it is associated with.</p>
    /// <p>The repository can be hosted either in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCodeRepository<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_code_repository_input::Builder,
    }
    impl<C, M, R> CreateCodeRepository<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCodeRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCodeRepositoryOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCodeRepositoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCodeRepositoryInputOperationOutputAlias,
                crate::output::CreateCodeRepositoryOutput,
                crate::error::CreateCodeRepositoryError,
                crate::input::CreateCodeRepositoryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Git repository. The name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).</p>
        pub fn code_repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.code_repository_name(input.into());
            self
        }
        /// <p>The name of the Git repository. The name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).</p>
        pub fn set_code_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_code_repository_name(input);
            self
        }
        /// <p>Specifies details about the repository, including the URL where the repository is located, the default branch, and credentials to use to access the repository.</p>
        pub fn git_config(mut self, input: crate::model::GitConfig) -> Self {
            self.inner = self.inner.git_config(input);
            self
        }
        /// <p>Specifies details about the repository, including the URL where the repository is located, the default branch, and credentials to use to access the repository.</p>
        pub fn set_git_config(
            mut self,
            input: std::option::Option<crate::model::GitConfig>,
        ) -> Self {
            self.inner = self.inner.set_git_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCompilationJob`.
    ///
    /// <p>Starts a model compilation job. After the model has been compiled, Amazon SageMaker saves the resulting model artifacts to an Amazon Simple Storage Service (Amazon S3) bucket that you specify. </p>
    /// <p>If you choose to host your model using Amazon SageMaker hosting services, you can use the resulting model artifacts as part of the model. You can also use the artifacts with Amazon Web Services IoT Greengrass. In that case, deploy them as an ML resource.</p>
    /// <p>In the request body, you provide the following:</p>
    /// <ul>
    /// <li> <p>A name for the compilation job</p> </li>
    /// <li> <p> Information about the input model artifacts </p> </li>
    /// <li> <p>The output location for the compiled model and the device (target) that the model runs on </p> </li>
    /// <li> <p>The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker assumes to perform the model compilation job. </p> </li>
    /// </ul>
    /// <p>You can also provide a <code>Tag</code> to track the model compilation job's resource use and costs. The response body contains the <code>CompilationJobArn</code> for the compiled job.</p>
    /// <p>To stop a model compilation job, use <code>StopCompilationJob</code>. To get information about a particular model compilation job, use <code>DescribeCompilationJob</code>. To get information about multiple model compilation jobs, use <code>ListCompilationJobs</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCompilationJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_compilation_job_input::Builder,
    }
    impl<C, M, R> CreateCompilationJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCompilationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCompilationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCompilationJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCompilationJobInputOperationOutputAlias,
                crate::output::CreateCompilationJobOutput,
                crate::error::CreateCompilationJobError,
                crate::input::CreateCompilationJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name for the model compilation job. The name must be unique within the Amazon Web Services Region and within your Amazon Web Services account. </p>
        pub fn compilation_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.compilation_job_name(input.into());
            self
        }
        /// <p>A name for the model compilation job. The name must be unique within the Amazon Web Services Region and within your Amazon Web Services account. </p>
        pub fn set_compilation_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_compilation_job_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf. </p>
        /// <p>During model compilation, Amazon SageMaker needs your permission to:</p>
        /// <ul>
        /// <li> <p>Read input data from an S3 bucket</p> </li>
        /// <li> <p>Write model artifacts to an S3 bucket</p> </li>
        /// <li> <p>Write logs to Amazon CloudWatch Logs</p> </li>
        /// <li> <p>Publish metrics to Amazon CloudWatch</p> </li>
        /// </ul>
        /// <p>You grant permissions for all of these tasks to an IAM role. To pass this role to Amazon SageMaker, the caller of this API must have the <code>iam:PassRole</code> permission. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles.</a> </p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf. </p>
        /// <p>During model compilation, Amazon SageMaker needs your permission to:</p>
        /// <ul>
        /// <li> <p>Read input data from an S3 bucket</p> </li>
        /// <li> <p>Write model artifacts to an S3 bucket</p> </li>
        /// <li> <p>Write logs to Amazon CloudWatch Logs</p> </li>
        /// <li> <p>Publish metrics to Amazon CloudWatch</p> </li>
        /// </ul>
        /// <p>You grant permissions for all of these tasks to an IAM role. To pass this role to Amazon SageMaker, the caller of this API must have the <code>iam:PassRole</code> permission. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles.</a> </p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a versioned model package. Provide either a <code>ModelPackageVersionArn</code> or an <code>InputConfig</code> object in the request syntax. The presence of both objects in the <code>CreateCompilationJob</code> request will return an exception.</p>
        pub fn model_package_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_package_version_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a versioned model package. Provide either a <code>ModelPackageVersionArn</code> or an <code>InputConfig</code> object in the request syntax. The presence of both objects in the <code>CreateCompilationJob</code> request will return an exception.</p>
        pub fn set_model_package_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_package_version_arn(input);
            self
        }
        /// <p>Provides information about the location of input model artifacts, the name and shape of the expected data inputs, and the framework in which the model was trained.</p>
        pub fn input_config(mut self, input: crate::model::InputConfig) -> Self {
            self.inner = self.inner.input_config(input);
            self
        }
        /// <p>Provides information about the location of input model artifacts, the name and shape of the expected data inputs, and the framework in which the model was trained.</p>
        pub fn set_input_config(
            mut self,
            input: std::option::Option<crate::model::InputConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_config(input);
            self
        }
        /// <p>Provides information about the output location for the compiled model and the target device the model runs on.</p>
        pub fn output_config(mut self, input: crate::model::OutputConfig) -> Self {
            self.inner = self.inner.output_config(input);
            self
        }
        /// <p>Provides information about the output location for the compiled model and the target device the model runs on.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::OutputConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_config(input);
            self
        }
        /// <p>A <code>VpcConfig</code> object that specifies the VPC that you want your compilation job to connect to. Control access to your models by configuring the VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html">Protect Compilation Jobs by Using an Amazon Virtual Private Cloud</a>.</p>
        pub fn vpc_config(mut self, input: crate::model::NeoVpcConfig) -> Self {
            self.inner = self.inner.vpc_config(input);
            self
        }
        /// <p>A <code>VpcConfig</code> object that specifies the VPC that you want your compilation job to connect to. Control access to your models by configuring the VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html">Protect Compilation Jobs by Using an Amazon Virtual Private Cloud</a>.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::NeoVpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// <p>Specifies a limit to how long a model compilation job can run. When the job reaches the time limit, Amazon SageMaker ends the compilation job. Use this API to cap model training costs.</p>
        pub fn stopping_condition(mut self, input: crate::model::StoppingCondition) -> Self {
            self.inner = self.inner.stopping_condition(input);
            self
        }
        /// <p>Specifies a limit to how long a model compilation job can run. When the job reaches the time limit, Amazon SageMaker ends the compilation job. Use this API to cap model training costs.</p>
        pub fn set_stopping_condition(
            mut self,
            input: std::option::Option<crate::model::StoppingCondition>,
        ) -> Self {
            self.inner = self.inner.set_stopping_condition(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateContext`.
    ///
    /// <p>Creates a <i>context</i>. A context is a lineage tracking entity that represents a logical grouping of other tracking or experiment entities. Some examples are an endpoint and a model package. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage Tracking</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateContext<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_context_input::Builder,
    }
    impl<C, M, R> CreateContext<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateContext`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateContextOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateContextError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateContextInputOperationOutputAlias,
                crate::output::CreateContextOutput,
                crate::error::CreateContextError,
                crate::input::CreateContextInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the context. Must be unique to your account in an Amazon Web Services Region.</p>
        pub fn context_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.context_name(input.into());
            self
        }
        /// <p>The name of the context. Must be unique to your account in an Amazon Web Services Region.</p>
        pub fn set_context_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_context_name(input);
            self
        }
        /// <p>The source type, ID, and URI.</p>
        pub fn source(mut self, input: crate::model::ContextSource) -> Self {
            self.inner = self.inner.source(input);
            self
        }
        /// <p>The source type, ID, and URI.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::ContextSource>,
        ) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// <p>The context type.</p>
        pub fn context_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.context_type(input.into());
            self
        }
        /// <p>The context type.</p>
        pub fn set_context_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_context_type(input);
            self
        }
        /// <p>The description of the context.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the context.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `Properties`.
        ///
        /// To override the contents of this collection use [`set_properties`](Self::set_properties).
        ///
        /// <p>A list of properties to add to the context.</p>
        pub fn properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.properties(k.into(), v.into());
            self
        }
        /// <p>A list of properties to add to the context.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_properties(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to apply to the context.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to apply to the context.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDataQualityJobDefinition`.
    ///
    /// <p>Creates a definition for a job that monitors data quality and drift. For information about model monitor, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker Model Monitor</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDataQualityJobDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_data_quality_job_definition_input::Builder,
    }
    impl<C, M, R> CreateDataQualityJobDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDataQualityJobDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDataQualityJobDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDataQualityJobDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDataQualityJobDefinitionInputOperationOutputAlias,
                crate::output::CreateDataQualityJobDefinitionOutput,
                crate::error::CreateDataQualityJobDefinitionError,
                crate::input::CreateDataQualityJobDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the monitoring job definition.</p>
        pub fn job_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_definition_name(input.into());
            self
        }
        /// <p>The name for the monitoring job definition.</p>
        pub fn set_job_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_job_definition_name(input);
            self
        }
        /// <p>Configures the constraints and baselines for the monitoring job.</p>
        pub fn data_quality_baseline_config(
            mut self,
            input: crate::model::DataQualityBaselineConfig,
        ) -> Self {
            self.inner = self.inner.data_quality_baseline_config(input);
            self
        }
        /// <p>Configures the constraints and baselines for the monitoring job.</p>
        pub fn set_data_quality_baseline_config(
            mut self,
            input: std::option::Option<crate::model::DataQualityBaselineConfig>,
        ) -> Self {
            self.inner = self.inner.set_data_quality_baseline_config(input);
            self
        }
        /// <p>Specifies the container that runs the monitoring job.</p>
        pub fn data_quality_app_specification(
            mut self,
            input: crate::model::DataQualityAppSpecification,
        ) -> Self {
            self.inner = self.inner.data_quality_app_specification(input);
            self
        }
        /// <p>Specifies the container that runs the monitoring job.</p>
        pub fn set_data_quality_app_specification(
            mut self,
            input: std::option::Option<crate::model::DataQualityAppSpecification>,
        ) -> Self {
            self.inner = self.inner.set_data_quality_app_specification(input);
            self
        }
        /// <p>A list of inputs for the monitoring job. Currently endpoints are supported as monitoring inputs.</p>
        pub fn data_quality_job_input(mut self, input: crate::model::DataQualityJobInput) -> Self {
            self.inner = self.inner.data_quality_job_input(input);
            self
        }
        /// <p>A list of inputs for the monitoring job. Currently endpoints are supported as monitoring inputs.</p>
        pub fn set_data_quality_job_input(
            mut self,
            input: std::option::Option<crate::model::DataQualityJobInput>,
        ) -> Self {
            self.inner = self.inner.set_data_quality_job_input(input);
            self
        }
        /// <p>The output configuration for monitoring jobs.</p>
        pub fn data_quality_job_output_config(
            mut self,
            input: crate::model::MonitoringOutputConfig,
        ) -> Self {
            self.inner = self.inner.data_quality_job_output_config(input);
            self
        }
        /// <p>The output configuration for monitoring jobs.</p>
        pub fn set_data_quality_job_output_config(
            mut self,
            input: std::option::Option<crate::model::MonitoringOutputConfig>,
        ) -> Self {
            self.inner = self.inner.set_data_quality_job_output_config(input);
            self
        }
        /// <p>Identifies the resources to deploy for a monitoring job.</p>
        pub fn job_resources(mut self, input: crate::model::MonitoringResources) -> Self {
            self.inner = self.inner.job_resources(input);
            self
        }
        /// <p>Identifies the resources to deploy for a monitoring job.</p>
        pub fn set_job_resources(
            mut self,
            input: std::option::Option<crate::model::MonitoringResources>,
        ) -> Self {
            self.inner = self.inner.set_job_resources(input);
            self
        }
        /// <p>Specifies networking configuration for the monitoring job.</p>
        pub fn network_config(mut self, input: crate::model::MonitoringNetworkConfig) -> Self {
            self.inner = self.inner.network_config(input);
            self
        }
        /// <p>Specifies networking configuration for the monitoring job.</p>
        pub fn set_network_config(
            mut self,
            input: std::option::Option<crate::model::MonitoringNetworkConfig>,
        ) -> Self {
            self.inner = self.inner.set_network_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
        pub fn stopping_condition(
            mut self,
            input: crate::model::MonitoringStoppingCondition,
        ) -> Self {
            self.inner = self.inner.stopping_condition(input);
            self
        }
        /// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
        pub fn set_stopping_condition(
            mut self,
            input: std::option::Option<crate::model::MonitoringStoppingCondition>,
        ) -> Self {
            self.inner = self.inner.set_stopping_condition(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDeviceFleet`.
    ///
    /// <p>Creates a device fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDeviceFleet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_device_fleet_input::Builder,
    }
    impl<C, M, R> CreateDeviceFleet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDeviceFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDeviceFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDeviceFleetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDeviceFleetInputOperationOutputAlias,
                crate::output::CreateDeviceFleetOutput,
                crate::error::CreateDeviceFleetError,
                crate::input::CreateDeviceFleetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet that the device belongs to.</p>
        pub fn device_fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_fleet_name(input.into());
            self
        }
        /// <p>The name of the fleet that the device belongs to.</p>
        pub fn set_device_fleet_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_device_fleet_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that has access to Amazon Web Services Internet of Things (IoT).</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that has access to Amazon Web Services Internet of Things (IoT).</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>A description of the fleet.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the fleet.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The output configuration for storing sample data collected by the fleet.</p>
        pub fn output_config(mut self, input: crate::model::EdgeOutputConfig) -> Self {
            self.inner = self.inner.output_config(input);
            self
        }
        /// <p>The output configuration for storing sample data collected by the fleet.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::EdgeOutputConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Creates tags for the specified fleet.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Creates tags for the specified fleet.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Whether to create an Amazon Web Services IoT Role Alias during device fleet creation. The name of the role alias generated will match this pattern: "SageMakerEdge-{DeviceFleetName}".</p>
        /// <p>For example, if your device fleet is called "demo-fleet", the name of the role alias will be "SageMakerEdge-demo-fleet".</p>
        pub fn enable_iot_role_alias(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_iot_role_alias(input);
            self
        }
        /// <p>Whether to create an Amazon Web Services IoT Role Alias during device fleet creation. The name of the role alias generated will match this pattern: "SageMakerEdge-{DeviceFleetName}".</p>
        /// <p>For example, if your device fleet is called "demo-fleet", the name of the role alias will be "SageMakerEdge-demo-fleet".</p>
        pub fn set_enable_iot_role_alias(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_iot_role_alias(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDomain`.
    ///
    /// <p>Creates a <code>Domain</code> used by Amazon SageMaker Studio. A domain consists of an associated Amazon Elastic File System (EFS) volume, a list of authorized users, and a variety of security, application, policy, and Amazon Virtual Private Cloud (VPC) configurations. An Amazon Web Services account is limited to one domain per region. Users within a domain can share notebook files and other artifacts with each other.</p>
    /// <p> <b>EFS storage</b> </p>
    /// <p>When a domain is created, an EFS volume is created for use by all of the users within the domain. Each user receives a private home directory within the EFS volume for notebooks, Git repositories, and data files.</p>
    /// <p>SageMaker uses the Amazon Web Services Key Management Service (Amazon Web Services KMS) to encrypt the EFS volume attached to the domain with an Amazon Web Services managed key by default. For more control, you can specify a customer managed key. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/encryption-at-rest.html">Protect Data at Rest Using Encryption</a>.</p>
    /// <p> <b>VPC configuration</b> </p>
    /// <p>All SageMaker Studio traffic between the domain and the EFS volume is through the specified VPC and subnets. For other Studio traffic, you can specify the <code>AppNetworkAccessType</code> parameter. <code>AppNetworkAccessType</code> corresponds to the network access type that you choose when you onboard to Studio. The following options are available:</p>
    /// <ul>
    /// <li> <p> <code>PublicInternetOnly</code> - Non-EFS traffic goes through a VPC managed by Amazon SageMaker, which allows internet access. This is the default value.</p> </li>
    /// <li> <p> <code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets. Internet access is disabled by default. To allow internet access, you must specify a NAT gateway.</p> <p>When internet access is disabled, you won't be able to run a Studio notebook or to train or host models unless your VPC has an interface endpoint to the SageMaker API and runtime or a NAT gateway and your security groups allow outbound connections.</p> </li>
    /// </ul> <important>
    /// <p>NFS traffic over TCP on port 2049 needs to be allowed in both inbound and outbound rules in order to launch a SageMaker Studio app successfully.</p>
    /// </important>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-notebooks-and-internet-access.html">Connect SageMaker Studio Notebooks to Resources in a VPC</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_domain_input::Builder,
    }
    impl<C, M, R> CreateDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDomainInputOperationOutputAlias,
                crate::output::CreateDomainOutput,
                crate::error::CreateDomainError,
                crate::input::CreateDomainInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name for the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>A name for the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The mode of authentication that members use to access the domain.</p>
        pub fn auth_mode(mut self, input: crate::model::AuthMode) -> Self {
            self.inner = self.inner.auth_mode(input);
            self
        }
        /// <p>The mode of authentication that members use to access the domain.</p>
        pub fn set_auth_mode(mut self, input: std::option::Option<crate::model::AuthMode>) -> Self {
            self.inner = self.inner.set_auth_mode(input);
            self
        }
        /// <p>The default settings to use to create a user profile when <code>UserSettings</code> isn't specified in the call to the <code>CreateUserProfile</code> API.</p>
        /// <p> <code>SecurityGroups</code> is aggregated when specified in both calls. For all other settings in <code>UserSettings</code>, the values specified in <code>CreateUserProfile</code> take precedence over those specified in <code>CreateDomain</code>.</p>
        pub fn default_user_settings(mut self, input: crate::model::UserSettings) -> Self {
            self.inner = self.inner.default_user_settings(input);
            self
        }
        /// <p>The default settings to use to create a user profile when <code>UserSettings</code> isn't specified in the call to the <code>CreateUserProfile</code> API.</p>
        /// <p> <code>SecurityGroups</code> is aggregated when specified in both calls. For all other settings in <code>UserSettings</code>, the values specified in <code>CreateUserProfile</code> take precedence over those specified in <code>CreateDomain</code>.</p>
        pub fn set_default_user_settings(
            mut self,
            input: std::option::Option<crate::model::UserSettings>,
        ) -> Self {
            self.inner = self.inner.set_default_user_settings(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The VPC subnets that Studio uses for communication.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>The VPC subnets that Studio uses for communication.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// <p>The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to associated with the Domain. Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the <code>Search</code> API.</p>
        /// <p>Tags that you specify for the Domain are also added to all Apps that the Domain launches.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags to associated with the Domain. Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the <code>Search</code> API.</p>
        /// <p>Tags that you specify for the Domain are also added to all Apps that the Domain launches.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Specifies the VPC used for non-EFS traffic. The default value is <code>PublicInternetOnly</code>.</p>
        /// <ul>
        /// <li> <p> <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which allows direct internet access</p> </li>
        /// <li> <p> <code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets</p> </li>
        /// </ul>
        pub fn app_network_access_type(
            mut self,
            input: crate::model::AppNetworkAccessType,
        ) -> Self {
            self.inner = self.inner.app_network_access_type(input);
            self
        }
        /// <p>Specifies the VPC used for non-EFS traffic. The default value is <code>PublicInternetOnly</code>.</p>
        /// <ul>
        /// <li> <p> <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which allows direct internet access</p> </li>
        /// <li> <p> <code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets</p> </li>
        /// </ul>
        pub fn set_app_network_access_type(
            mut self,
            input: std::option::Option<crate::model::AppNetworkAccessType>,
        ) -> Self {
            self.inner = self.inner.set_app_network_access_type(input);
            self
        }
        /// <p>Use <code>KmsKeyId</code>.</p>
        pub fn home_efs_file_system_kms_key_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.home_efs_file_system_kms_key_id(input.into());
            self
        }
        /// <p>Use <code>KmsKeyId</code>.</p>
        pub fn set_home_efs_file_system_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_home_efs_file_system_kms_key_id(input);
            self
        }
        /// <p>SageMaker uses Amazon Web Services KMS to encrypt the EFS volume attached to the domain with an Amazon Web Services managed key by default. For more control, specify a customer managed key.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>SageMaker uses Amazon Web Services KMS to encrypt the EFS volume attached to the domain with an Amazon Web Services managed key by default. For more control, specify a customer managed key.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>The entity that creates and manages the required security groups for inter-app communication in <code>VPCOnly</code> mode. Required when <code>CreateDomain.AppNetworkAccessType</code> is <code>VPCOnly</code> and <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided.</p>
        pub fn app_security_group_management(
            mut self,
            input: crate::model::AppSecurityGroupManagement,
        ) -> Self {
            self.inner = self.inner.app_security_group_management(input);
            self
        }
        /// <p>The entity that creates and manages the required security groups for inter-app communication in <code>VPCOnly</code> mode. Required when <code>CreateDomain.AppNetworkAccessType</code> is <code>VPCOnly</code> and <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided.</p>
        pub fn set_app_security_group_management(
            mut self,
            input: std::option::Option<crate::model::AppSecurityGroupManagement>,
        ) -> Self {
            self.inner = self.inner.set_app_security_group_management(input);
            self
        }
        /// <p>A collection of <code>Domain</code> settings.</p>
        pub fn domain_settings(mut self, input: crate::model::DomainSettings) -> Self {
            self.inner = self.inner.domain_settings(input);
            self
        }
        /// <p>A collection of <code>Domain</code> settings.</p>
        pub fn set_domain_settings(
            mut self,
            input: std::option::Option<crate::model::DomainSettings>,
        ) -> Self {
            self.inner = self.inner.set_domain_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEdgePackagingJob`.
    ///
    /// <p>Starts a SageMaker Edge Manager model packaging job. Edge Manager will use the model artifacts from the Amazon Simple Storage Service bucket that you specify. After the model has been packaged, Amazon SageMaker saves the resulting artifacts to an S3 bucket that you specify.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEdgePackagingJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_edge_packaging_job_input::Builder,
    }
    impl<C, M, R> CreateEdgePackagingJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEdgePackagingJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEdgePackagingJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEdgePackagingJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEdgePackagingJobInputOperationOutputAlias,
                crate::output::CreateEdgePackagingJobOutput,
                crate::error::CreateEdgePackagingJobError,
                crate::input::CreateEdgePackagingJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the edge packaging job.</p>
        pub fn edge_packaging_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.edge_packaging_job_name(input.into());
            self
        }
        /// <p>The name of the edge packaging job.</p>
        pub fn set_edge_packaging_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_edge_packaging_job_name(input);
            self
        }
        /// <p>The name of the SageMaker Neo compilation job that will be used to locate model artifacts for packaging.</p>
        pub fn compilation_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.compilation_job_name(input.into());
            self
        }
        /// <p>The name of the SageMaker Neo compilation job that will be used to locate model artifacts for packaging.</p>
        pub fn set_compilation_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_compilation_job_name(input);
            self
        }
        /// <p>The name of the model.</p>
        pub fn model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_name(input.into());
            self
        }
        /// <p>The name of the model.</p>
        pub fn set_model_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_name(input);
            self
        }
        /// <p>The version of the model.</p>
        pub fn model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_version(input.into());
            self
        }
        /// <p>The version of the model.</p>
        pub fn set_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_version(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to download and upload the model, and to contact SageMaker Neo.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to download and upload the model, and to contact SageMaker Neo.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>Provides information about the output location for the packaged model.</p>
        pub fn output_config(mut self, input: crate::model::EdgeOutputConfig) -> Self {
            self.inner = self.inner.output_config(input);
            self
        }
        /// <p>Provides information about the output location for the packaged model.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::EdgeOutputConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_config(input);
            self
        }
        /// <p>The Amazon Web Services KMS key to use when encrypting the EBS volume the edge packaging job runs on.</p>
        pub fn resource_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_key(input.into());
            self
        }
        /// <p>The Amazon Web Services KMS key to use when encrypting the EBS volume the edge packaging job runs on.</p>
        pub fn set_resource_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_key(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Creates tags for the packaging job.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Creates tags for the packaging job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEndpoint`.
    ///
    /// <p>Creates an endpoint using the endpoint configuration specified in the request. Amazon SageMaker uses the endpoint to provision resources and deploy models. You create the endpoint configuration with the <code>CreateEndpointConfig</code> API. </p>
    /// <p> Use this API to deploy models using Amazon SageMaker hosting services. </p>
    /// <p>For an example that calls this method when deploying a model to Amazon SageMaker hosting services, see the <a href="https://github.com/aws/amazon-sagemaker-examples/blob/master/sagemaker-fundamentals/create-endpoint/create_endpoint.ipynb">Create Endpoint example notebook.</a> </p> <note>
    /// <p> You must not delete an <code>EndpointConfig</code> that is in use by an endpoint that is live or while the <code>UpdateEndpoint</code> or <code>CreateEndpoint</code> operations are being performed on the endpoint. To update an endpoint, you must create a new <code>EndpointConfig</code>.</p>
    /// </note>
    /// <p>The endpoint name must be unique within an Amazon Web Services Region in your Amazon Web Services account. </p>
    /// <p>When it receives the request, Amazon SageMaker creates the endpoint, launches the resources (ML compute instances), and deploys the model(s) on them. </p> <note>
    /// <p>When you call <code>CreateEndpoint</code>, a load call is made to DynamoDB to verify that your endpoint configuration exists. When you read data from a DynamoDB table supporting <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html"> <code>Eventually Consistent Reads</code> </a>, the response might not reflect the results of a recently completed write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB, this causes a validation error. If you repeat your read request after a short time, the response should return the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers call <code>DescribeEndpointConfig</code> before calling <code>CreateEndpoint</code> to minimize the potential impact of a DynamoDB eventually consistent read.</p>
    /// </note>
    /// <p>When Amazon SageMaker receives the request, it sets the endpoint status to <code>Creating</code>. After it creates the endpoint, it sets the status to <code>InService</code>. Amazon SageMaker can then process incoming requests for inferences. To check the status of an endpoint, use the <code>DescribeEndpoint</code> API.</p>
    /// <p>If any of the models hosted at this endpoint get model data from an Amazon S3 location, Amazon SageMaker uses Amazon Web Services Security Token Service to download model artifacts from the S3 path you provided. Amazon Web Services STS is activated in your IAM user account by default. If you previously deactivated Amazon Web Services STS for a region, you need to reactivate Amazon Web Services STS for that region. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and Deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>.</p> <note>
    /// <p> To add the IAM role policies for using this API operation, go to the <a href="https://console.aws.amazon.com/iam/">IAM console</a>, and choose Roles in the left navigation pane. Search the IAM role that you want to grant access to use the <code>CreateEndpoint</code> and <code>CreateEndpointConfig</code> API operations, add the following policies to the role. </p>
    /// <ul>
    /// <li> <p>Option 1: For a full SageMaker access, search and attach the <code>AmazonSageMakerFullAccess</code> policy.</p> </li>
    /// <li> <p>Option 2: For granting a limited access to an IAM role, paste the following Action elements manually into the JSON file of the IAM role: </p> <p> <code>"Action": ["sagemaker:CreateEndpoint", "sagemaker:CreateEndpointConfig"]</code> </p> <p> <code>"Resource": [</code> </p> <p> <code>"arn:aws:sagemaker:region:account-id:endpoint/endpointName"</code> </p> <p> <code>"arn:aws:sagemaker:region:account-id:endpoint-config/endpointConfigName"</code> </p> <p> <code>]</code> </p> <p>For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/api-permissions-reference.html">SageMaker API Permissions: Actions, Permissions, and Resources Reference</a>.</p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_endpoint_input::Builder,
    }
    impl<C, M, R> CreateEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEndpointInputOperationOutputAlias,
                crate::output::CreateEndpointOutput,
                crate::error::CreateEndpointError,
                crate::input::CreateEndpointInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the endpoint.The name must be unique within an Amazon Web Services Region in your Amazon Web Services account. The name is case-insensitive in <code>CreateEndpoint</code>, but the case is preserved and must be matched in .</p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_name(input.into());
            self
        }
        /// <p>The name of the endpoint.The name must be unique within an Amazon Web Services Region in your Amazon Web Services account. The name is case-insensitive in <code>CreateEndpoint</code>, but the case is preserved and must be matched in .</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_name(input);
            self
        }
        /// <p>The name of an endpoint configuration. For more information, see <code>CreateEndpointConfig</code>. </p>
        pub fn endpoint_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_config_name(input.into());
            self
        }
        /// <p>The name of an endpoint configuration. For more information, see <code>CreateEndpointConfig</code>. </p>
        pub fn set_endpoint_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_config_name(input);
            self
        }
        /// <p>The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.</p>
        pub fn deployment_config(mut self, input: crate::model::DeploymentConfig) -> Self {
            self.inner = self.inner.deployment_config(input);
            self
        }
        /// <p>The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.</p>
        pub fn set_deployment_config(
            mut self,
            input: std::option::Option<crate::model::DeploymentConfig>,
        ) -> Self {
            self.inner = self.inner.set_deployment_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEndpointConfig`.
    ///
    /// <p>Creates an endpoint configuration that Amazon SageMaker hosting services uses to deploy models. In the configuration, you identify one or more models, created using the <code>CreateModel</code> API, to deploy and the resources that you want Amazon SageMaker to provision. Then you call the <code>CreateEndpoint</code> API.</p> <note>
    /// <p> Use this API if you want to use Amazon SageMaker hosting services to deploy models into production. </p>
    /// </note>
    /// <p>In the request, you define a <code>ProductionVariant</code>, for each model that you want to deploy. Each <code>ProductionVariant</code> parameter also describes the resources that you want Amazon SageMaker to provision. This includes the number and type of ML compute instances to deploy. </p>
    /// <p>If you are hosting multiple models, you also assign a <code>VariantWeight</code> to specify how much traffic you want to allocate to each model. For example, suppose that you want to host two models, A and B, and you assign traffic weight 2 for model A and 1 for model B. Amazon SageMaker distributes two-thirds of the traffic to Model A, and one-third to model B. </p> <note>
    /// <p>When you call <code>CreateEndpoint</code>, a load call is made to DynamoDB to verify that your endpoint configuration exists. When you read data from a DynamoDB table supporting <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html"> <code>Eventually Consistent Reads</code> </a>, the response might not reflect the results of a recently completed write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB, this causes a validation error. If you repeat your read request after a short time, the response should return the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers call <code>DescribeEndpointConfig</code> before calling <code>CreateEndpoint</code> to minimize the potential impact of a DynamoDB eventually consistent read.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEndpointConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_endpoint_config_input::Builder,
    }
    impl<C, M, R> CreateEndpointConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEndpointConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEndpointConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEndpointConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEndpointConfigInputOperationOutputAlias,
                crate::output::CreateEndpointConfigOutput,
                crate::error::CreateEndpointConfigError,
                crate::input::CreateEndpointConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the endpoint configuration. You specify this name in a <code>CreateEndpoint</code> request. </p>
        pub fn endpoint_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_config_name(input.into());
            self
        }
        /// <p>The name of the endpoint configuration. You specify this name in a <code>CreateEndpoint</code> request. </p>
        pub fn set_endpoint_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_config_name(input);
            self
        }
        /// Appends an item to `ProductionVariants`.
        ///
        /// To override the contents of this collection use [`set_production_variants`](Self::set_production_variants).
        ///
        /// <p>An list of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint.</p>
        pub fn production_variants(mut self, input: crate::model::ProductionVariant) -> Self {
            self.inner = self.inner.production_variants(input);
            self
        }
        /// <p>An list of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint.</p>
        pub fn set_production_variants(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProductionVariant>>,
        ) -> Self {
            self.inner = self.inner.set_production_variants(input);
            self
        }
        /// <p></p>
        pub fn data_capture_config(mut self, input: crate::model::DataCaptureConfig) -> Self {
            self.inner = self.inner.data_capture_config(input);
            self
        }
        /// <p></p>
        pub fn set_data_capture_config(
            mut self,
            input: std::option::Option<crate::model::DataCaptureConfig>,
        ) -> Self {
            self.inner = self.inner.set_data_capture_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.</p>
        /// <p>The KmsKeyId can be any of the following formats: </p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>The KMS key policy must grant permission to the IAM role that you specify in your <code>CreateEndpoint</code>, <code>UpdateEndpoint</code> requests. For more information, refer to the Amazon Web Services Key Management Service section<a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html"> Using Key Policies in Amazon Web Services KMS </a> </p> <note>
        /// <p>Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a <code>KmsKeyId</code> when using an instance type with local storage. If any of the models that you specify in the <code>ProductionVariants</code> parameter use nitro-based instances with local storage, do not specify a value for the <code>KmsKeyId</code> parameter. If you specify a value for <code>KmsKeyId</code> when using any nitro-based instances with local storage, the call to <code>CreateEndpointConfig</code> fails.</p>
        /// <p>For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a>.</p>
        /// <p>For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store Volumes</a>.</p>
        /// </note>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.</p>
        /// <p>The KmsKeyId can be any of the following formats: </p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li>
        /// <li> <p>Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code> </p> </li>
        /// </ul>
        /// <p>The KMS key policy must grant permission to the IAM role that you specify in your <code>CreateEndpoint</code>, <code>UpdateEndpoint</code> requests. For more information, refer to the Amazon Web Services Key Management Service section<a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html"> Using Key Policies in Amazon Web Services KMS </a> </p> <note>
        /// <p>Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a <code>KmsKeyId</code> when using an instance type with local storage. If any of the models that you specify in the <code>ProductionVariants</code> parameter use nitro-based instances with local storage, do not specify a value for the <code>KmsKeyId</code> parameter. If you specify a value for <code>KmsKeyId</code> when using any nitro-based instances with local storage, the call to <code>CreateEndpointConfig</code> fails.</p>
        /// <p>For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a>.</p>
        /// <p>For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store Volumes</a>.</p>
        /// </note>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>Specifies configuration for how an endpoint performs asynchronous inference. This is a required field in order for your Endpoint to be invoked using <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html"> <code>InvokeEndpointAsync</code> </a>.</p>
        pub fn async_inference_config(mut self, input: crate::model::AsyncInferenceConfig) -> Self {
            self.inner = self.inner.async_inference_config(input);
            self
        }
        /// <p>Specifies configuration for how an endpoint performs asynchronous inference. This is a required field in order for your Endpoint to be invoked using <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html"> <code>InvokeEndpointAsync</code> </a>.</p>
        pub fn set_async_inference_config(
            mut self,
            input: std::option::Option<crate::model::AsyncInferenceConfig>,
        ) -> Self {
            self.inner = self.inner.set_async_inference_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateExperiment`.
    ///
    /// <p>Creates an SageMaker <i>experiment</i>. An experiment is a collection of <i>trials</i> that are observed, compared and evaluated as a group. A trial is a set of steps, called <i>trial components</i>, that produce a machine learning model.</p>
    /// <p>The goal of an experiment is to determine the components that produce the best model. Multiple trials are performed, each one isolating and measuring the impact of a change to one or more inputs, while keeping the remaining inputs constant.</p>
    /// <p>When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must use the logging APIs provided by the SDK.</p>
    /// <p>You can add tags to experiments, trials, trial components and then use the <code>Search</code> API to search for the tags.</p>
    /// <p>To add a description to an experiment, specify the optional <code>Description</code> parameter. To add a description later, or to change the description, call the <code>UpdateExperiment</code> API.</p>
    /// <p>To get a list of all your experiments, call the <code>ListExperiments</code> API. To view an experiment's properties, call the <code>DescribeExperiment</code> API. To get a list of all the trials associated with an experiment, call the <code>ListTrials</code> API. To create a trial call the <code>CreateTrial</code> API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateExperiment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_experiment_input::Builder,
    }
    impl<C, M, R> CreateExperiment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateExperiment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateExperimentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateExperimentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateExperimentInputOperationOutputAlias,
                crate::output::CreateExperimentOutput,
                crate::error::CreateExperimentError,
                crate::input::CreateExperimentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the experiment. The name must be unique in your Amazon Web Services account and is not case-sensitive.</p>
        pub fn experiment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.experiment_name(input.into());
            self
        }
        /// <p>The name of the experiment. The name must be unique in your Amazon Web Services account and is not case-sensitive.</p>
        pub fn set_experiment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_experiment_name(input);
            self
        }
        /// <p>The name of the experiment as displayed. The name doesn't need to be unique. If you don't specify <code>DisplayName</code>, the value in <code>ExperimentName</code> is displayed.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The name of the experiment as displayed. The name doesn't need to be unique. If you don't specify <code>DisplayName</code>, the value in <code>ExperimentName</code> is displayed.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The description of the experiment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the experiment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to associate with the experiment. You can use <code>Search</code> API to search on the tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to associate with the experiment. You can use <code>Search</code> API to search on the tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFeatureGroup`.
    ///
    /// <p>Create a new <code>FeatureGroup</code>. A <code>FeatureGroup</code> is a group of <code>Features</code> defined in the <code>FeatureStore</code> to describe a <code>Record</code>. </p>
    /// <p>The <code>FeatureGroup</code> defines the schema and features contained in the FeatureGroup. A <code>FeatureGroup</code> definition is composed of a list of <code>Features</code>, a <code>RecordIdentifierFeatureName</code>, an <code>EventTimeFeatureName</code> and configurations for its <code>OnlineStore</code> and <code>OfflineStore</code>. Check <a href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">Amazon Web Services service quotas</a> to see the <code>FeatureGroup</code>s quota for your Amazon Web Services account.</p> <important>
    /// <p>You must include at least one of <code>OnlineStoreConfig</code> and <code>OfflineStoreConfig</code> to create a <code>FeatureGroup</code>.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFeatureGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_feature_group_input::Builder,
    }
    impl<C, M, R> CreateFeatureGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFeatureGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFeatureGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFeatureGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFeatureGroupInputOperationOutputAlias,
                crate::output::CreateFeatureGroupOutput,
                crate::error::CreateFeatureGroupError,
                crate::input::CreateFeatureGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the <code>FeatureGroup</code>. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account. The name:</p>
        /// <ul>
        /// <li> <p>Must start and end with an alphanumeric character.</p> </li>
        /// <li> <p>Can only contain alphanumeric character and hyphens. Spaces are not allowed. </p> </li>
        /// </ul>
        pub fn feature_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.feature_group_name(input.into());
            self
        }
        /// <p>The name of the <code>FeatureGroup</code>. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account. The name:</p>
        /// <ul>
        /// <li> <p>Must start and end with an alphanumeric character.</p> </li>
        /// <li> <p>Can only contain alphanumeric character and hyphens. Spaces are not allowed. </p> </li>
        /// </ul>
        pub fn set_feature_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_feature_group_name(input);
            self
        }
        /// <p>The name of the <code>Feature</code> whose value uniquely identifies a <code>Record</code> defined in the <code>FeatureStore</code>. Only the latest record per identifier value will be stored in the <code>OnlineStore</code>. <code>RecordIdentifierFeatureName</code> must be one of feature definitions' names.</p>
        /// <p>You use the <code>RecordIdentifierFeatureName</code> to access data in a <code>FeatureStore</code>.</p>
        /// <p>This name:</p>
        /// <ul>
        /// <li> <p>Must start and end with an alphanumeric character.</p> </li>
        /// <li> <p>Can only contains alphanumeric characters, hyphens, underscores. Spaces are not allowed. </p> </li>
        /// </ul>
        pub fn record_identifier_feature_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.record_identifier_feature_name(input.into());
            self
        }
        /// <p>The name of the <code>Feature</code> whose value uniquely identifies a <code>Record</code> defined in the <code>FeatureStore</code>. Only the latest record per identifier value will be stored in the <code>OnlineStore</code>. <code>RecordIdentifierFeatureName</code> must be one of feature definitions' names.</p>
        /// <p>You use the <code>RecordIdentifierFeatureName</code> to access data in a <code>FeatureStore</code>.</p>
        /// <p>This name:</p>
        /// <ul>
        /// <li> <p>Must start and end with an alphanumeric character.</p> </li>
        /// <li> <p>Can only contains alphanumeric characters, hyphens, underscores. Spaces are not allowed. </p> </li>
        /// </ul>
        pub fn set_record_identifier_feature_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_record_identifier_feature_name(input);
            self
        }
        /// <p>The name of the feature that stores the <code>EventTime</code> of a <code>Record</code> in a <code>FeatureGroup</code>.</p>
        /// <p>An <code>EventTime</code> is a point in time when a new event occurs that corresponds to the creation or update of a <code>Record</code> in a <code>FeatureGroup</code>. All <code>Records</code> in the <code>FeatureGroup</code> must have a corresponding <code>EventTime</code>.</p>
        /// <p>An <code>EventTime</code> can be a <code>String</code> or <code>Fractional</code>. </p>
        /// <ul>
        /// <li> <p> <code>Fractional</code>: <code>EventTime</code> feature values must be a Unix timestamp in seconds.</p> </li>
        /// <li> <p> <code>String</code>: <code>EventTime</code> feature values must be an ISO-8601 string in the format. The following formats are supported <code>yyyy-MM-dd'T'HH:mm:ssZ</code> and <code>yyyy-MM-dd'T'HH:mm:ss.SSSZ</code> where <code>yyyy</code>, <code>MM</code>, and <code>dd</code> represent the year, month, and day respectively and <code>HH</code>, <code>mm</code>, <code>ss</code>, and if applicable, <code>SSS</code> represent the hour, month, second and milliseconds respsectively. <code>'T'</code> and <code>Z</code> are constants.</p> </li>
        /// </ul>
        pub fn event_time_feature_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_time_feature_name(input.into());
            self
        }
        /// <p>The name of the feature that stores the <code>EventTime</code> of a <code>Record</code> in a <code>FeatureGroup</code>.</p>
        /// <p>An <code>EventTime</code> is a point in time when a new event occurs that corresponds to the creation or update of a <code>Record</code> in a <code>FeatureGroup</code>. All <code>Records</code> in the <code>FeatureGroup</code> must have a corresponding <code>EventTime</code>.</p>
        /// <p>An <code>EventTime</code> can be a <code>String</code> or <code>Fractional</code>. </p>
        /// <ul>
        /// <li> <p> <code>Fractional</code>: <code>EventTime</code> feature values must be a Unix timestamp in seconds.</p> </li>
        /// <li> <p> <code>String</code>: <code>EventTime</code> feature values must be an ISO-8601 string in the format. The following formats are supported <code>yyyy-MM-dd'T'HH:mm:ssZ</code> and <code>yyyy-MM-dd'T'HH:mm:ss.SSSZ</code> where <code>yyyy</code>, <code>MM</code>, and <code>dd</code> represent the year, month, and day respectively and <code>HH</code>, <code>mm</code>, <code>ss</code>, and if applicable, <code>SSS</code> represent the hour, month, second and milliseconds respsectively. <code>'T'</code> and <code>Z</code> are constants.</p> </li>
        /// </ul>
        pub fn set_event_time_feature_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_time_feature_name(input);
            self
        }
        /// Appends an item to `FeatureDefinitions`.
        ///
        /// To override the contents of this collection use [`set_feature_definitions`](Self::set_feature_definitions).
        ///
        /// <p>A list of <code>Feature</code> names and types. <code>Name</code> and <code>Type</code> is compulsory per <code>Feature</code>. </p>
        /// <p>Valid feature <code>FeatureType</code>s are <code>Integral</code>, <code>Fractional</code> and <code>String</code>.</p>
        /// <p> <code>FeatureName</code>s cannot be any of the following: <code>is_deleted</code>, <code>write_time</code>, <code>api_invocation_time</code> </p>
        /// <p>You can create up to 2,500 <code>FeatureDefinition</code>s per <code>FeatureGroup</code>.</p>
        pub fn feature_definitions(mut self, input: crate::model::FeatureDefinition) -> Self {
            self.inner = self.inner.feature_definitions(input);
            self
        }
        /// <p>A list of <code>Feature</code> names and types. <code>Name</code> and <code>Type</code> is compulsory per <code>Feature</code>. </p>
        /// <p>Valid feature <code>FeatureType</code>s are <code>Integral</code>, <code>Fractional</code> and <code>String</code>.</p>
        /// <p> <code>FeatureName</code>s cannot be any of the following: <code>is_deleted</code>, <code>write_time</code>, <code>api_invocation_time</code> </p>
        /// <p>You can create up to 2,500 <code>FeatureDefinition</code>s per <code>FeatureGroup</code>.</p>
        pub fn set_feature_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FeatureDefinition>>,
        ) -> Self {
            self.inner = self.inner.set_feature_definitions(input);
            self
        }
        /// <p>You can turn the <code>OnlineStore</code> on or off by specifying <code>True</code> for the <code>EnableOnlineStore</code> flag in <code>OnlineStoreConfig</code>; the default value is <code>False</code>.</p>
        /// <p>You can also include an Amazon Web Services KMS key ID (<code>KMSKeyId</code>) for at-rest encryption of the <code>OnlineStore</code>.</p>
        pub fn online_store_config(mut self, input: crate::model::OnlineStoreConfig) -> Self {
            self.inner = self.inner.online_store_config(input);
            self
        }
        /// <p>You can turn the <code>OnlineStore</code> on or off by specifying <code>True</code> for the <code>EnableOnlineStore</code> flag in <code>OnlineStoreConfig</code>; the default value is <code>False</code>.</p>
        /// <p>You can also include an Amazon Web Services KMS key ID (<code>KMSKeyId</code>) for at-rest encryption of the <code>OnlineStore</code>.</p>
        pub fn set_online_store_config(
            mut self,
            input: std::option::Option<crate::model::OnlineStoreConfig>,
        ) -> Self {
            self.inner = self.inner.set_online_store_config(input);
            self
        }
        /// <p>Use this to configure an <code>OfflineFeatureStore</code>. This parameter allows you to specify:</p>
        /// <ul>
        /// <li> <p>The Amazon Simple Storage Service (Amazon S3) location of an <code>OfflineStore</code>.</p> </li>
        /// <li> <p>A configuration for an Amazon Web Services Glue or Amazon Web Services Hive data catalog. </p> </li>
        /// <li> <p>An KMS encryption key to encrypt the Amazon S3 location used for <code>OfflineStore</code>. If KMS encryption key is not specified, by default we encrypt all data at rest using Amazon Web Services KMS key. By defining your <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-key.html">bucket-level key</a> for SSE, you can reduce Amazon Web Services KMS requests costs by up to 99 percent.</p> </li>
        /// </ul>
        /// <p>To learn more about this parameter, see <code>OfflineStoreConfig</code>.</p>
        pub fn offline_store_config(mut self, input: crate::model::OfflineStoreConfig) -> Self {
            self.inner = self.inner.offline_store_config(input);
            self
        }
        /// <p>Use this to configure an <code>OfflineFeatureStore</code>. This parameter allows you to specify:</p>
        /// <ul>
        /// <li> <p>The Amazon Simple Storage Service (Amazon S3) location of an <code>OfflineStore</code>.</p> </li>
        /// <li> <p>A configuration for an Amazon Web Services Glue or Amazon Web Services Hive data catalog. </p> </li>
        /// <li> <p>An KMS encryption key to encrypt the Amazon S3 location used for <code>OfflineStore</code>. If KMS encryption key is not specified, by default we encrypt all data at rest using Amazon Web Services KMS key. By defining your <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-key.html">bucket-level key</a> for SSE, you can reduce Amazon Web Services KMS requests costs by up to 99 percent.</p> </li>
        /// </ul>
        /// <p>To learn more about this parameter, see <code>OfflineStoreConfig</code>.</p>
        pub fn set_offline_store_config(
            mut self,
            input: std::option::Option<crate::model::OfflineStoreConfig>,
        ) -> Self {
            self.inner = self.inner.set_offline_store_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the <code>OfflineStore</code> if an <code>OfflineStoreConfig</code> is provided.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the <code>OfflineStore</code> if an <code>OfflineStoreConfig</code> is provided.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>A free-form description of a <code>FeatureGroup</code>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A free-form description of a <code>FeatureGroup</code>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags used to identify <code>Features</code> in each <code>FeatureGroup</code>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags used to identify <code>Features</code> in each <code>FeatureGroup</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFlowDefinition`.
    ///
    /// <p>Creates a flow definition.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFlowDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_flow_definition_input::Builder,
    }
    impl<C, M, R> CreateFlowDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFlowDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFlowDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFlowDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFlowDefinitionInputOperationOutputAlias,
                crate::output::CreateFlowDefinitionOutput,
                crate::error::CreateFlowDefinitionError,
                crate::input::CreateFlowDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of your flow definition.</p>
        pub fn flow_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_definition_name(input.into());
            self
        }
        /// <p>The name of your flow definition.</p>
        pub fn set_flow_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_flow_definition_name(input);
            self
        }
        /// <p>Container for configuring the source of human task requests. Use to specify if Amazon Rekognition or Amazon Textract is used as an integration source.</p>
        pub fn human_loop_request_source(
            mut self,
            input: crate::model::HumanLoopRequestSource,
        ) -> Self {
            self.inner = self.inner.human_loop_request_source(input);
            self
        }
        /// <p>Container for configuring the source of human task requests. Use to specify if Amazon Rekognition or Amazon Textract is used as an integration source.</p>
        pub fn set_human_loop_request_source(
            mut self,
            input: std::option::Option<crate::model::HumanLoopRequestSource>,
        ) -> Self {
            self.inner = self.inner.set_human_loop_request_source(input);
            self
        }
        /// <p>An object containing information about the events that trigger a human workflow.</p>
        pub fn human_loop_activation_config(
            mut self,
            input: crate::model::HumanLoopActivationConfig,
        ) -> Self {
            self.inner = self.inner.human_loop_activation_config(input);
            self
        }
        /// <p>An object containing information about the events that trigger a human workflow.</p>
        pub fn set_human_loop_activation_config(
            mut self,
            input: std::option::Option<crate::model::HumanLoopActivationConfig>,
        ) -> Self {
            self.inner = self.inner.set_human_loop_activation_config(input);
            self
        }
        /// <p>An object containing information about the tasks the human reviewers will perform.</p>
        pub fn human_loop_config(mut self, input: crate::model::HumanLoopConfig) -> Self {
            self.inner = self.inner.human_loop_config(input);
            self
        }
        /// <p>An object containing information about the tasks the human reviewers will perform.</p>
        pub fn set_human_loop_config(
            mut self,
            input: std::option::Option<crate::model::HumanLoopConfig>,
        ) -> Self {
            self.inner = self.inner.set_human_loop_config(input);
            self
        }
        /// <p>An object containing information about where the human review results will be uploaded.</p>
        pub fn output_config(mut self, input: crate::model::FlowDefinitionOutputConfig) -> Self {
            self.inner = self.inner.output_config(input);
            self
        }
        /// <p>An object containing information about where the human review results will be uploaded.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::FlowDefinitionOutputConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role needed to call other services on your behalf. For example, <code>arn:aws:iam::1234567890:role/service-role/AmazonSageMaker-ExecutionRole-20180111T151298</code>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role needed to call other services on your behalf. For example, <code>arn:aws:iam::1234567890:role/service-role/AmazonSageMaker-ExecutionRole-20180111T151298</code>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs that contain metadata to help you categorize and organize a flow definition. Each tag consists of a key and a value, both of which you define.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key-value pairs that contain metadata to help you categorize and organize a flow definition. Each tag consists of a key and a value, both of which you define.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateHumanTaskUi`.
    ///
    /// <p>Defines the settings you will use for the human review workflow user interface. Reviewers will see a three-panel interface with an instruction area, the item to review, and an input area.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateHumanTaskUi<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_human_task_ui_input::Builder,
    }
    impl<C, M, R> CreateHumanTaskUi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateHumanTaskUi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHumanTaskUiOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHumanTaskUiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateHumanTaskUiInputOperationOutputAlias,
                crate::output::CreateHumanTaskUiOutput,
                crate::error::CreateHumanTaskUiError,
                crate::input::CreateHumanTaskUiInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user interface you are creating.</p>
        pub fn human_task_ui_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.human_task_ui_name(input.into());
            self
        }
        /// <p>The name of the user interface you are creating.</p>
        pub fn set_human_task_ui_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_human_task_ui_name(input);
            self
        }
        /// <p>The Liquid template for the worker user interface.</p>
        pub fn ui_template(mut self, input: crate::model::UiTemplate) -> Self {
            self.inner = self.inner.ui_template(input);
            self
        }
        /// <p>The Liquid template for the worker user interface.</p>
        pub fn set_ui_template(
            mut self,
            input: std::option::Option<crate::model::UiTemplate>,
        ) -> Self {
            self.inner = self.inner.set_ui_template(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs that contain metadata to help you categorize and organize a human review workflow user interface. Each tag consists of a key and a value, both of which you define.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key-value pairs that contain metadata to help you categorize and organize a human review workflow user interface. Each tag consists of a key and a value, both of which you define.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateHyperParameterTuningJob`.
    ///
    /// <p>Starts a hyperparameter tuning job. A hyperparameter tuning job finds the best version of a model by running many training jobs on your dataset using the algorithm you choose and values for hyperparameters within ranges that you specify. It then chooses the hyperparameter values that result in a model that performs the best, as measured by an objective metric that you choose.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateHyperParameterTuningJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_hyper_parameter_tuning_job_input::Builder,
    }
    impl<C, M, R> CreateHyperParameterTuningJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateHyperParameterTuningJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHyperParameterTuningJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHyperParameterTuningJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateHyperParameterTuningJobInputOperationOutputAlias,
                crate::output::CreateHyperParameterTuningJobOutput,
                crate::error::CreateHyperParameterTuningJobError,
                crate::input::CreateHyperParameterTuningJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the tuning job. This name is the prefix for the names of all training jobs that this tuning job launches. The name must be unique within the same Amazon Web Services account and Amazon Web Services Region. The name must have 1 to 32 characters. Valid characters are a-z, A-Z, 0-9, and : + = @ _ % - (hyphen). The name is not case sensitive.</p>
        pub fn hyper_parameter_tuning_job_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.hyper_parameter_tuning_job_name(input.into());
            self
        }
        /// <p>The name of the tuning job. This name is the prefix for the names of all training jobs that this tuning job launches. The name must be unique within the same Amazon Web Services account and Amazon Web Services Region. The name must have 1 to 32 characters. Valid characters are a-z, A-Z, 0-9, and : + = @ _ % - (hyphen). The name is not case sensitive.</p>
        pub fn set_hyper_parameter_tuning_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hyper_parameter_tuning_job_name(input);
            self
        }
        /// <p>The <code>HyperParameterTuningJobConfig</code> object that describes the tuning job, including the search strategy, the objective metric used to evaluate training jobs, ranges of parameters to search, and resource limits for the tuning job. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How Hyperparameter Tuning Works</a>.</p>
        pub fn hyper_parameter_tuning_job_config(
            mut self,
            input: crate::model::HyperParameterTuningJobConfig,
        ) -> Self {
            self.inner = self.inner.hyper_parameter_tuning_job_config(input);
            self
        }
        /// <p>The <code>HyperParameterTuningJobConfig</code> object that describes the tuning job, including the search strategy, the objective metric used to evaluate training jobs, ranges of parameters to search, and resource limits for the tuning job. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How Hyperparameter Tuning Works</a>.</p>
        pub fn set_hyper_parameter_tuning_job_config(
            mut self,
            input: std::option::Option<crate::model::HyperParameterTuningJobConfig>,
        ) -> Self {
            self.inner = self.inner.set_hyper_parameter_tuning_job_config(input);
            self
        }
        /// <p>The <code>HyperParameterTrainingJobDefinition</code> object that describes the training jobs that this tuning job launches, including static hyperparameters, input data configuration, output data configuration, resource configuration, and stopping condition.</p>
        pub fn training_job_definition(
            mut self,
            input: crate::model::HyperParameterTrainingJobDefinition,
        ) -> Self {
            self.inner = self.inner.training_job_definition(input);
            self
        }
        /// <p>The <code>HyperParameterTrainingJobDefinition</code> object that describes the training jobs that this tuning job launches, including static hyperparameters, input data configuration, output data configuration, resource configuration, and stopping condition.</p>
        pub fn set_training_job_definition(
            mut self,
            input: std::option::Option<crate::model::HyperParameterTrainingJobDefinition>,
        ) -> Self {
            self.inner = self.inner.set_training_job_definition(input);
            self
        }
        /// Appends an item to `TrainingJobDefinitions`.
        ///
        /// To override the contents of this collection use [`set_training_job_definitions`](Self::set_training_job_definitions).
        ///
        /// <p>A list of the <code>HyperParameterTrainingJobDefinition</code> objects launched for this tuning job.</p>
        pub fn training_job_definitions(
            mut self,
            input: crate::model::HyperParameterTrainingJobDefinition,
        ) -> Self {
            self.inner = self.inner.training_job_definitions(input);
            self
        }
        /// <p>A list of the <code>HyperParameterTrainingJobDefinition</code> objects launched for this tuning job.</p>
        pub fn set_training_job_definitions(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::HyperParameterTrainingJobDefinition>,
            >,
        ) -> Self {
            self.inner = self.inner.set_training_job_definitions(input);
            self
        }
        /// <p>Specifies the configuration for starting the hyperparameter tuning job using one or more previous tuning jobs as a starting point. The results of previous tuning jobs are used to inform which combinations of hyperparameters to search over in the new tuning job.</p>
        /// <p>All training jobs launched by the new hyperparameter tuning job are evaluated by using the objective metric. If you specify <code>IDENTICAL_DATA_AND_ALGORITHM</code> as the <code>WarmStartType</code> value for the warm start configuration, the training job that performs the best in the new tuning job is compared to the best training jobs from the parent tuning jobs. From these, the training job that performs the best as measured by the objective metric is returned as the overall best training job.</p> <note>
        /// <p>All training jobs launched by parent hyperparameter tuning jobs and the new hyperparameter tuning jobs count against the limit of training jobs for the tuning job.</p>
        /// </note>
        pub fn warm_start_config(
            mut self,
            input: crate::model::HyperParameterTuningJobWarmStartConfig,
        ) -> Self {
            self.inner = self.inner.warm_start_config(input);
            self
        }
        /// <p>Specifies the configuration for starting the hyperparameter tuning job using one or more previous tuning jobs as a starting point. The results of previous tuning jobs are used to inform which combinations of hyperparameters to search over in the new tuning job.</p>
        /// <p>All training jobs launched by the new hyperparameter tuning job are evaluated by using the objective metric. If you specify <code>IDENTICAL_DATA_AND_ALGORITHM</code> as the <code>WarmStartType</code> value for the warm start configuration, the training job that performs the best in the new tuning job is compared to the best training jobs from the parent tuning jobs. From these, the training job that performs the best as measured by the objective metric is returned as the overall best training job.</p> <note>
        /// <p>All training jobs launched by parent hyperparameter tuning jobs and the new hyperparameter tuning jobs count against the limit of training jobs for the tuning job.</p>
        /// </note>
        pub fn set_warm_start_config(
            mut self,
            input: std::option::Option<crate::model::HyperParameterTuningJobWarmStartConfig>,
        ) -> Self {
            self.inner = self.inner.set_warm_start_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>
        /// <p>Tags that you specify for the tuning job are also added to all training jobs that the tuning job launches.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>
        /// <p>Tags that you specify for the tuning job are also added to all training jobs that the tuning job launches.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateImage`.
    ///
    /// <p>Creates a custom SageMaker image. A SageMaker image is a set of image versions. Each image version represents a container image stored in Amazon Container Registry (ECR). For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html">Bring your own SageMaker image</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateImage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_image_input::Builder,
    }
    impl<C, M, R> CreateImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateImageOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateImageInputOperationOutputAlias,
                crate::output::CreateImageOutput,
                crate::error::CreateImageError,
                crate::input::CreateImageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The description of the image.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the image.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The display name of the image. If not provided, <code>ImageName</code> is displayed.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The display name of the image. If not provided, <code>ImageName</code> is displayed.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The name of the image. Must be unique to your account.</p>
        pub fn image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_name(input.into());
            self
        }
        /// <p>The name of the image. Must be unique to your account.</p>
        pub fn set_image_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to apply to the image.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to apply to the image.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateImageVersion`.
    ///
    /// <p>Creates a version of the SageMaker image specified by <code>ImageName</code>. The version represents the Amazon Container Registry (ECR) container image specified by <code>BaseImage</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateImageVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_image_version_input::Builder,
    }
    impl<C, M, R> CreateImageVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateImageVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateImageVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateImageVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateImageVersionInputOperationOutputAlias,
                crate::output::CreateImageVersionOutput,
                crate::error::CreateImageVersionError,
                crate::input::CreateImageVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The registry path of the container image to use as the starting point for this version. The path is an Amazon Container Registry (ECR) URI in the following format:</p>
        /// <p> <code>
        /// <acct-id>
        /// .dkr.ecr.
        /// <region>
        /// .amazonaws.com/
        /// <repo-name[:tag] or [@digest]></repo-name[:tag]>
        /// </region>
        /// </acct-id></code> </p>
        pub fn base_image(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.base_image(input.into());
            self
        }
        /// <p>The registry path of the container image to use as the starting point for this version. The path is an Amazon Container Registry (ECR) URI in the following format:</p>
        /// <p> <code>
        /// <acct-id>
        /// .dkr.ecr.
        /// <region>
        /// .amazonaws.com/
        /// <repo-name[:tag] or [@digest]></repo-name[:tag]>
        /// </region>
        /// </acct-id></code> </p>
        pub fn set_base_image(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_base_image(input);
            self
        }
        /// <p>A unique ID. If not specified, the Amazon Web Services CLI and Amazon Web Services SDKs, such as the SDK for Python (Boto3), add a unique value to the call.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique ID. If not specified, the Amazon Web Services CLI and Amazon Web Services SDKs, such as the SDK for Python (Boto3), add a unique value to the call.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The <code>ImageName</code> of the <code>Image</code> to create a version of.</p>
        pub fn image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_name(input.into());
            self
        }
        /// <p>The <code>ImageName</code> of the <code>Image</code> to create a version of.</p>
        pub fn set_image_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateInferenceRecommendationsJob`.
    ///
    /// <p>Starts a recommendation job. You can create either an instance recommendation or load test job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateInferenceRecommendationsJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_inference_recommendations_job_input::Builder,
    }
    impl<C, M, R> CreateInferenceRecommendationsJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateInferenceRecommendationsJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateInferenceRecommendationsJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateInferenceRecommendationsJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateInferenceRecommendationsJobInputOperationOutputAlias,
                crate::output::CreateInferenceRecommendationsJobOutput,
                crate::error::CreateInferenceRecommendationsJobError,
                crate::input::CreateInferenceRecommendationsJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name for the recommendation job. The name must be unique within the Amazon Web Services Region and within your Amazon Web Services account.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(input.into());
            self
        }
        /// <p>A name for the recommendation job. The name must be unique within the Amazon Web Services Region and within your Amazon Web Services account.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>Defines the type of recommendation job. Specify <code>Default</code> to initiate an instance recommendation and <code>Advanced</code> to initiate a load test. If left unspecified, Amazon SageMaker Inference Recommender will run an instance recommendation (<code>DEFAULT</code>) job.</p>
        pub fn job_type(mut self, input: crate::model::RecommendationJobType) -> Self {
            self.inner = self.inner.job_type(input);
            self
        }
        /// <p>Defines the type of recommendation job. Specify <code>Default</code> to initiate an instance recommendation and <code>Advanced</code> to initiate a load test. If left unspecified, Amazon SageMaker Inference Recommender will run an instance recommendation (<code>DEFAULT</code>) job.</p>
        pub fn set_job_type(
            mut self,
            input: std::option::Option<crate::model::RecommendationJobType>,
        ) -> Self {
            self.inner = self.inner.set_job_type(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>Provides information about the versioned model package Amazon Resource Name (ARN), the traffic pattern, and endpoint configurations.</p>
        pub fn input_config(mut self, input: crate::model::RecommendationJobInputConfig) -> Self {
            self.inner = self.inner.input_config(input);
            self
        }
        /// <p>Provides information about the versioned model package Amazon Resource Name (ARN), the traffic pattern, and endpoint configurations.</p>
        pub fn set_input_config(
            mut self,
            input: std::option::Option<crate::model::RecommendationJobInputConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_config(input);
            self
        }
        /// <p>Description of the recommendation job.</p>
        pub fn job_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_description(input.into());
            self
        }
        /// <p>Description of the recommendation job.</p>
        pub fn set_job_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_job_description(input);
            self
        }
        /// <p>A set of conditions for stopping a recommendation job. If any of the conditions are met, the job is automatically stopped.</p>
        pub fn stopping_conditions(
            mut self,
            input: crate::model::RecommendationJobStoppingConditions,
        ) -> Self {
            self.inner = self.inner.stopping_conditions(input);
            self
        }
        /// <p>A set of conditions for stopping a recommendation job. If any of the conditions are met, the job is automatically stopped.</p>
        pub fn set_stopping_conditions(
            mut self,
            input: std::option::Option<crate::model::RecommendationJobStoppingConditions>,
        ) -> Self {
            self.inner = self.inner.set_stopping_conditions(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to Amazon Web Services resources to help you categorize and organize them. Each tag consists of a key and a value, both of which you define. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> in the Amazon Web Services General Reference.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The metadata that you apply to Amazon Web Services resources to help you categorize and organize them. Each tag consists of a key and a value, both of which you define. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> in the Amazon Web Services General Reference.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLabelingJob`.
    ///
    /// <p>Creates a job that uses workers to label the data objects in your input dataset. You can use the labeled data to train machine learning models. </p>
    /// <p>You can select your workforce from one of three providers:</p>
    /// <ul>
    /// <li> <p>A private workforce that you create. It can include employees, contractors, and outside experts. Use a private workforce when want the data to stay within your organization or when a specific set of skills is required.</p> </li>
    /// <li> <p>One or more vendors that you select from the Amazon Web Services Marketplace. Vendors provide expertise in specific areas. </p> </li>
    /// <li> <p>The Amazon Mechanical Turk workforce. This is the largest workforce, but it should only be used for public data or data that has been stripped of any personally identifiable information.</p> </li>
    /// </ul>
    /// <p>You can also use <i>automated data labeling</i> to reduce the number of data objects that need to be labeled by a human. Automated data labeling uses <i>active learning</i> to determine if a data object can be labeled by machine or if it needs to be sent to a human worker. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-automated-labeling.html">Using Automated Data Labeling</a>.</p>
    /// <p>The data objects to be labeled are contained in an Amazon S3 bucket. You create a <i>manifest file</i> that describes the location of each object. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data.html">Using Input and Output Data</a>.</p>
    /// <p>The output can be used as the manifest file for another labeling job or as training data for your machine learning models.</p>
    /// <p>You can use this operation to create a static labeling job or a streaming labeling job. A static labeling job stops if all data objects in the input manifest file identified in <code>ManifestS3Uri</code> have been labeled. A streaming labeling job runs perpetually until it is manually stopped, or remains idle for 10 days. You can send new data objects to an active (<code>InProgress</code>) streaming labeling job in real time. To learn how to create a static labeling job, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-create-labeling-job-api.html">Create a Labeling Job (API) </a> in the Amazon SageMaker Developer Guide. To learn how to create a streaming labeling job, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-create-job.html">Create a Streaming Labeling Job</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLabelingJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_labeling_job_input::Builder,
    }
    impl<C, M, R> CreateLabelingJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLabelingJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLabelingJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLabelingJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLabelingJobInputOperationOutputAlias,
                crate::output::CreateLabelingJobOutput,
                crate::error::CreateLabelingJobError,
                crate::input::CreateLabelingJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the labeling job. This name is used to identify the job in a list of labeling jobs. Labeling job names must be unique within an Amazon Web Services account and region. <code>LabelingJobName</code> is not case sensitive. For example, Example-job and example-job are considered the same labeling job name by Ground Truth.</p>
        pub fn labeling_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.labeling_job_name(input.into());
            self
        }
        /// <p>The name of the labeling job. This name is used to identify the job in a list of labeling jobs. Labeling job names must be unique within an Amazon Web Services account and region. <code>LabelingJobName</code> is not case sensitive. For example, Example-job and example-job are considered the same labeling job name by Ground Truth.</p>
        pub fn set_labeling_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_labeling_job_name(input);
            self
        }
        /// <p>The attribute name to use for the label in the output manifest file. This is the key for the key/value pair formed with the label that a worker assigns to the object. The <code>LabelAttributeName</code> must meet the following requirements.</p>
        /// <ul>
        /// <li> <p>The name can't end with "-metadata". </p> </li>
        /// <li> <p>If you are using one of the following <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types</a>, the attribute name <i>must</i> end with "-ref". If the task type you are using is not listed below, the attribute name <i>must not</i> end with "-ref".</p>
        /// <ul>
        /// <li> <p>Image semantic segmentation (<code>SemanticSegmentation)</code>, and adjustment (<code>AdjustmentSemanticSegmentation</code>) and verification (<code>VerificationSemanticSegmentation</code>) labeling jobs for this task type.</p> </li>
        /// <li> <p>Video frame object detection (<code>VideoObjectDetection</code>), and adjustment and verification (<code>AdjustmentVideoObjectDetection</code>) labeling jobs for this task type.</p> </li>
        /// <li> <p>Video frame object tracking (<code>VideoObjectTracking</code>), and adjustment and verification (<code>AdjustmentVideoObjectTracking</code>) labeling jobs for this task type.</p> </li>
        /// <li> <p>3D point cloud semantic segmentation (<code>3DPointCloudSemanticSegmentation</code>), and adjustment and verification (<code>Adjustment3DPointCloudSemanticSegmentation</code>) labeling jobs for this task type. </p> </li>
        /// <li> <p>3D point cloud object tracking (<code>3DPointCloudObjectTracking</code>), and adjustment and verification (<code>Adjustment3DPointCloudObjectTracking</code>) labeling jobs for this task type. </p> </li>
        /// </ul> </li>
        /// </ul>
        /// <p></p> <important>
        /// <p>If you are creating an adjustment or verification labeling job, you must use a <i>different</i> <code>LabelAttributeName</code> than the one used in the original labeling job. The original labeling job is the Ground Truth labeling job that produced the labels that you want verified or adjusted. To learn more about adjustment and verification labeling jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html">Verify and Adjust Labels</a>.</p>
        /// </important>
        pub fn label_attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.label_attribute_name(input.into());
            self
        }
        /// <p>The attribute name to use for the label in the output manifest file. This is the key for the key/value pair formed with the label that a worker assigns to the object. The <code>LabelAttributeName</code> must meet the following requirements.</p>
        /// <ul>
        /// <li> <p>The name can't end with "-metadata". </p> </li>
        /// <li> <p>If you are using one of the following <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types</a>, the attribute name <i>must</i> end with "-ref". If the task type you are using is not listed below, the attribute name <i>must not</i> end with "-ref".</p>
        /// <ul>
        /// <li> <p>Image semantic segmentation (<code>SemanticSegmentation)</code>, and adjustment (<code>AdjustmentSemanticSegmentation</code>) and verification (<code>VerificationSemanticSegmentation</code>) labeling jobs for this task type.</p> </li>
        /// <li> <p>Video frame object detection (<code>VideoObjectDetection</code>), and adjustment and verification (<code>AdjustmentVideoObjectDetection</code>) labeling jobs for this task type.</p> </li>
        /// <li> <p>Video frame object tracking (<code>VideoObjectTracking</code>), and adjustment and verification (<code>AdjustmentVideoObjectTracking</code>) labeling jobs for this task type.</p> </li>
        /// <li> <p>3D point cloud semantic segmentation (<code>3DPointCloudSemanticSegmentation</code>), and adjustment and verification (<code>Adjustment3DPointCloudSemanticSegmentation</code>) labeling jobs for this task type. </p> </li>
        /// <li> <p>3D point cloud object tracking (<code>3DPointCloudObjectTracking</code>), and adjustment and verification (<code>Adjustment3DPointCloudObjectTracking</code>) labeling jobs for this task type. </p> </li>
        /// </ul> </li>
        /// </ul>
        /// <p></p> <important>
        /// <p>If you are creating an adjustment or verification labeling job, you must use a <i>different</i> <code>LabelAttributeName</code> than the one used in the original labeling job. The original labeling job is the Ground Truth labeling job that produced the labels that you want verified or adjusted. To learn more about adjustment and verification labeling jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html">Verify and Adjust Labels</a>.</p>
        /// </important>
        pub fn set_label_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_label_attribute_name(input);
            self
        }
        /// <p>Input data for the labeling job, such as the Amazon S3 location of the data objects and the location of the manifest file that describes the data objects.</p>
        /// <p>You must specify at least one of the following: <code>S3DataSource</code> or <code>SnsDataSource</code>. </p>
        /// <ul>
        /// <li> <p>Use <code>SnsDataSource</code> to specify an SNS input topic for a streaming labeling job. If you do not specify and SNS input topic ARN, Ground Truth will create a one-time labeling job that stops after all data objects in the input manifest file have been labeled.</p> </li>
        /// <li> <p>Use <code>S3DataSource</code> to specify an input manifest file for both streaming and one-time labeling jobs. Adding an <code>S3DataSource</code> is optional if you use <code>SnsDataSource</code> to create a streaming labeling job.</p> </li>
        /// </ul>
        /// <p>If you use the Amazon Mechanical Turk workforce, your input data should not include confidential information, personal information or protected health information. Use <code>ContentClassifiers</code> to specify that your data is free of personally identifiable information and adult content.</p>
        pub fn input_config(mut self, input: crate::model::LabelingJobInputConfig) -> Self {
            self.inner = self.inner.input_config(input);
            self
        }
        /// <p>Input data for the labeling job, such as the Amazon S3 location of the data objects and the location of the manifest file that describes the data objects.</p>
        /// <p>You must specify at least one of the following: <code>S3DataSource</code> or <code>SnsDataSource</code>. </p>
        /// <ul>
        /// <li> <p>Use <code>SnsDataSource</code> to specify an SNS input topic for a streaming labeling job. If you do not specify and SNS input topic ARN, Ground Truth will create a one-time labeling job that stops after all data objects in the input manifest file have been labeled.</p> </li>
        /// <li> <p>Use <code>S3DataSource</code> to specify an input manifest file for both streaming and one-time labeling jobs. Adding an <code>S3DataSource</code> is optional if you use <code>SnsDataSource</code> to create a streaming labeling job.</p> </li>
        /// </ul>
        /// <p>If you use the Amazon Mechanical Turk workforce, your input data should not include confidential information, personal information or protected health information. Use <code>ContentClassifiers</code> to specify that your data is free of personally identifiable information and adult content.</p>
        pub fn set_input_config(
            mut self,
            input: std::option::Option<crate::model::LabelingJobInputConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_config(input);
            self
        }
        /// <p>The location of the output data and the Amazon Web Services Key Management Service key ID for the key used to encrypt the output data, if any.</p>
        pub fn output_config(mut self, input: crate::model::LabelingJobOutputConfig) -> Self {
            self.inner = self.inner.output_config(input);
            self
        }
        /// <p>The location of the output data and the Amazon Web Services Key Management Service key ID for the key used to encrypt the output data, if any.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::LabelingJobOutputConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_config(input);
            self
        }
        /// <p>The Amazon Resource Number (ARN) that Amazon SageMaker assumes to perform tasks on your behalf during data labeling. You must grant this role the necessary permissions so that Amazon SageMaker can successfully complete data labeling.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) that Amazon SageMaker assumes to perform tasks on your behalf during data labeling. You must grant this role the necessary permissions so that Amazon SageMaker can successfully complete data labeling.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The S3 URI of the file, referred to as a <i>label category configuration file</i>, that defines the categories used to label the data objects.</p>
        /// <p>For 3D point cloud and video frame task types, you can add label category attributes and frame attributes to your label category configuration file. To learn how, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud-label-category-config.html">Create a Labeling Category Configuration File for 3D Point Cloud Labeling Jobs</a>. </p>
        /// <p>For named entity recognition jobs, in addition to <code>"labels"</code>, you must provide worker instructions in the label category configuration file using the <code>"instructions"</code> parameter: <code>"instructions": {"shortInstruction":"</code></p>
        /// <h1><code>Add header</code></h1>
        /// <p><code>Add Instructions</code></p><code>", "fullInstruction":"<p>Add additional instructions.</p>"}</code>. For details and an example, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-named-entity-recg.html#sms-creating-ner-api">Create a Named Entity Recognition Labeling Job (API) </a>.
        /// <p></p>
        /// <p>For all other <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates.html">custom tasks</a>, your label category configuration file must be a JSON file in the following format. Identify the labels you want to use by replacing <code>label_1</code>, <code>label_2</code>,<code>...</code>,<code>label_n</code> with your label categories.</p>
        /// <p> <code>{ </code> </p>
        /// <p> <code>"document-version": "2018-11-28",</code> </p>
        /// <p> <code>"labels": [{"label": "label_1"},{"label": "label_2"},...{"label": "label_n"}]</code> </p>
        /// <p> <code>}</code> </p>
        /// <p>Note the following about the label category configuration file:</p>
        /// <ul>
        /// <li> <p>For image classification and text classification (single and multi-label) you must specify at least two label categories. For all other task types, the minimum number of label categories required is one. </p> </li>
        /// <li> <p>Each label category must be unique, you cannot specify duplicate label categories.</p> </li>
        /// <li> <p>If you create a 3D point cloud or video frame adjustment or verification labeling job, you must include <code>auditLabelAttributeName</code> in the label category configuration. Use this parameter to enter the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateLabelingJob.html#sagemaker-CreateLabelingJob-request-LabelAttributeName"> <code>LabelAttributeName</code> </a> of the labeling job you want to adjust or verify annotations of.</p> </li>
        /// </ul>
        pub fn label_category_config_s3_uri(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.label_category_config_s3_uri(input.into());
            self
        }
        /// <p>The S3 URI of the file, referred to as a <i>label category configuration file</i>, that defines the categories used to label the data objects.</p>
        /// <p>For 3D point cloud and video frame task types, you can add label category attributes and frame attributes to your label category configuration file. To learn how, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud-label-category-config.html">Create a Labeling Category Configuration File for 3D Point Cloud Labeling Jobs</a>. </p>
        /// <p>For named entity recognition jobs, in addition to <code>"labels"</code>, you must provide worker instructions in the label category configuration file using the <code>"instructions"</code> parameter: <code>"instructions": {"shortInstruction":"</code></p>
        /// <h1><code>Add header</code></h1>
        /// <p><code>Add Instructions</code></p><code>", "fullInstruction":"<p>Add additional instructions.</p>"}</code>. For details and an example, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-named-entity-recg.html#sms-creating-ner-api">Create a Named Entity Recognition Labeling Job (API) </a>.
        /// <p></p>
        /// <p>For all other <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates.html">custom tasks</a>, your label category configuration file must be a JSON file in the following format. Identify the labels you want to use by replacing <code>label_1</code>, <code>label_2</code>,<code>...</code>,<code>label_n</code> with your label categories.</p>
        /// <p> <code>{ </code> </p>
        /// <p> <code>"document-version": "2018-11-28",</code> </p>
        /// <p> <code>"labels": [{"label": "label_1"},{"label": "label_2"},...{"label": "label_n"}]</code> </p>
        /// <p> <code>}</code> </p>
        /// <p>Note the following about the label category configuration file:</p>
        /// <ul>
        /// <li> <p>For image classification and text classification (single and multi-label) you must specify at least two label categories. For all other task types, the minimum number of label categories required is one. </p> </li>
        /// <li> <p>Each label category must be unique, you cannot specify duplicate label categories.</p> </li>
        /// <li> <p>If you create a 3D point cloud or video frame adjustment or verification labeling job, you must include <code>auditLabelAttributeName</code> in the label category configuration. Use this parameter to enter the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateLabelingJob.html#sagemaker-CreateLabelingJob-request-LabelAttributeName"> <code>LabelAttributeName</code> </a> of the labeling job you want to adjust or verify annotations of.</p> </li>
        /// </ul>
        pub fn set_label_category_config_s3_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_label_category_config_s3_uri(input);
            self
        }
        /// <p>A set of conditions for stopping the labeling job. If any of the conditions are met, the job is automatically stopped. You can use these conditions to control the cost of data labeling.</p>
        pub fn stopping_conditions(
            mut self,
            input: crate::model::LabelingJobStoppingConditions,
        ) -> Self {
            self.inner = self.inner.stopping_conditions(input);
            self
        }
        /// <p>A set of conditions for stopping the labeling job. If any of the conditions are met, the job is automatically stopped. You can use these conditions to control the cost of data labeling.</p>
        pub fn set_stopping_conditions(
            mut self,
            input: std::option::Option<crate::model::LabelingJobStoppingConditions>,
        ) -> Self {
            self.inner = self.inner.set_stopping_conditions(input);
            self
        }
        /// <p>Configures the information required to perform automated data labeling.</p>
        pub fn labeling_job_algorithms_config(
            mut self,
            input: crate::model::LabelingJobAlgorithmsConfig,
        ) -> Self {
            self.inner = self.inner.labeling_job_algorithms_config(input);
            self
        }
        /// <p>Configures the information required to perform automated data labeling.</p>
        pub fn set_labeling_job_algorithms_config(
            mut self,
            input: std::option::Option<crate::model::LabelingJobAlgorithmsConfig>,
        ) -> Self {
            self.inner = self.inner.set_labeling_job_algorithms_config(input);
            self
        }
        /// <p>Configures the labeling task and how it is presented to workers; including, but not limited to price, keywords, and batch size (task count).</p>
        pub fn human_task_config(mut self, input: crate::model::HumanTaskConfig) -> Self {
            self.inner = self.inner.human_task_config(input);
            self
        }
        /// <p>Configures the labeling task and how it is presented to workers; including, but not limited to price, keywords, and batch size (task count).</p>
        pub fn set_human_task_config(
            mut self,
            input: std::option::Option<crate::model::HumanTaskConfig>,
        ) -> Self {
            self.inner = self.inner.set_human_task_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key/value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key/value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateModel`.
    ///
    /// <p>Creates a model in Amazon SageMaker. In the request, you name the model and describe a primary container. For the primary container, you specify the Docker image that contains inference code, artifacts (from prior training), and a custom environment map that the inference code uses when you deploy the model for predictions.</p>
    /// <p>Use this API to create a model if you want to use Amazon SageMaker hosting services or run a batch transform job.</p>
    /// <p>To host your model, you create an endpoint configuration with the <code>CreateEndpointConfig</code> API, and then create an endpoint with the <code>CreateEndpoint</code> API. Amazon SageMaker then deploys all of the containers that you defined for the model in the hosting environment. </p>
    /// <p>For an example that calls this method when deploying a model to Amazon SageMaker hosting services, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ex1-deploy-model.html#ex1-deploy-model-boto">Deploy the Model to Amazon SageMaker Hosting Services (Amazon Web Services SDK for Python (Boto 3)).</a> </p>
    /// <p>To run a batch transform using your model, you start a job with the <code>CreateTransformJob</code> API. Amazon SageMaker uses your model and your dataset to get inferences which are then saved to a specified S3 location.</p>
    /// <p>In the <code>CreateModel</code> request, you must define a container with the <code>PrimaryContainer</code> parameter.</p>
    /// <p>In the request, you also provide an IAM role that Amazon SageMaker can assume to access model artifacts and docker image for deployment on ML compute hosting instances or for batch transform jobs. In addition, you also use the IAM role to manage permissions the inference code needs. For example, if the inference code access any other Amazon Web Services resources, you grant necessary permissions via this role.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateModel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_model_input::Builder,
    }
    impl<C, M, R> CreateModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateModelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateModelInputOperationOutputAlias,
                crate::output::CreateModelOutput,
                crate::error::CreateModelError,
                crate::input::CreateModelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the new model.</p>
        pub fn model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_name(input.into());
            self
        }
        /// <p>The name of the new model.</p>
        pub fn set_model_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_name(input);
            self
        }
        /// <p>The location of the primary docker image containing inference code, associated artifacts, and custom environment map that the inference code uses when the model is deployed for predictions. </p>
        pub fn primary_container(mut self, input: crate::model::ContainerDefinition) -> Self {
            self.inner = self.inner.primary_container(input);
            self
        }
        /// <p>The location of the primary docker image containing inference code, associated artifacts, and custom environment map that the inference code uses when the model is deployed for predictions. </p>
        pub fn set_primary_container(
            mut self,
            input: std::option::Option<crate::model::ContainerDefinition>,
        ) -> Self {
            self.inner = self.inner.set_primary_container(input);
            self
        }
        /// Appends an item to `Containers`.
        ///
        /// To override the contents of this collection use [`set_containers`](Self::set_containers).
        ///
        /// <p>Specifies the containers in the inference pipeline.</p>
        pub fn containers(mut self, input: crate::model::ContainerDefinition) -> Self {
            self.inner = self.inner.containers(input);
            self
        }
        /// <p>Specifies the containers in the inference pipeline.</p>
        pub fn set_containers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContainerDefinition>>,
        ) -> Self {
            self.inner = self.inner.set_containers(input);
            self
        }
        /// <p>Specifies details of how containers in a multi-container endpoint are called.</p>
        pub fn inference_execution_config(
            mut self,
            input: crate::model::InferenceExecutionConfig,
        ) -> Self {
            self.inner = self.inner.inference_execution_config(input);
            self
        }
        /// <p>Specifies details of how containers in a multi-container endpoint are called.</p>
        pub fn set_inference_execution_config(
            mut self,
            input: std::option::Option<crate::model::InferenceExecutionConfig>,
        ) -> Self {
            self.inner = self.inner.set_inference_execution_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker can assume to access model artifacts and docker image for deployment on ML compute instances or for batch transform jobs. Deploying on ML compute instances is part of model hosting. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles</a>. </p> <note>
        /// <p>To be able to pass this role to Amazon SageMaker, the caller of this API must have the <code>iam:PassRole</code> permission.</p>
        /// </note>
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.execution_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker can assume to access model artifacts and docker image for deployment on ML compute instances or for batch transform jobs. Deploying on ML compute instances is part of model hosting. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles</a>. </p> <note>
        /// <p>To be able to pass this role to Amazon SageMaker, the caller of this API must have the <code>iam:PassRole</code> permission.</p>
        /// </note>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_execution_role_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A <code>VpcConfig</code> object that specifies the VPC that you want your model to connect to. Control access to and from your model container by configuring the VPC. <code>VpcConfig</code> is used in hosting services and in batch transform. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html">Protect Endpoints by Using an Amazon Virtual Private Cloud</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-vpc.html">Protect Data in Batch Transform Jobs by Using an Amazon Virtual Private Cloud</a>.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(input);
            self
        }
        /// <p>A <code>VpcConfig</code> object that specifies the VPC that you want your model to connect to. Control access to and from your model container by configuring the VPC. <code>VpcConfig</code> is used in hosting services and in batch transform. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html">Protect Endpoints by Using an Amazon Virtual Private Cloud</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-vpc.html">Protect Data in Batch Transform Jobs by Using an Amazon Virtual Private Cloud</a>.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// <p>Isolates the model container. No inbound or outbound network calls can be made to or from the model container.</p>
        pub fn enable_network_isolation(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_network_isolation(input);
            self
        }
        /// <p>Isolates the model container. No inbound or outbound network calls can be made to or from the model container.</p>
        pub fn set_enable_network_isolation(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_network_isolation(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateModelBiasJobDefinition`.
    ///
    /// <p>Creates the definition for a model bias job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateModelBiasJobDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_model_bias_job_definition_input::Builder,
    }
    impl<C, M, R> CreateModelBiasJobDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateModelBiasJobDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateModelBiasJobDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateModelBiasJobDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateModelBiasJobDefinitionInputOperationOutputAlias,
                crate::output::CreateModelBiasJobDefinitionOutput,
                crate::error::CreateModelBiasJobDefinitionError,
                crate::input::CreateModelBiasJobDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bias job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
        pub fn job_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_definition_name(input.into());
            self
        }
        /// <p>The name of the bias job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
        pub fn set_job_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_job_definition_name(input);
            self
        }
        /// <p>The baseline configuration for a model bias job.</p>
        pub fn model_bias_baseline_config(
            mut self,
            input: crate::model::ModelBiasBaselineConfig,
        ) -> Self {
            self.inner = self.inner.model_bias_baseline_config(input);
            self
        }
        /// <p>The baseline configuration for a model bias job.</p>
        pub fn set_model_bias_baseline_config(
            mut self,
            input: std::option::Option<crate::model::ModelBiasBaselineConfig>,
        ) -> Self {
            self.inner = self.inner.set_model_bias_baseline_config(input);
            self
        }
        /// <p>Configures the model bias job to run a specified Docker container image.</p>
        pub fn model_bias_app_specification(
            mut self,
            input: crate::model::ModelBiasAppSpecification,
        ) -> Self {
            self.inner = self.inner.model_bias_app_specification(input);
            self
        }
        /// <p>Configures the model bias job to run a specified Docker container image.</p>
        pub fn set_model_bias_app_specification(
            mut self,
            input: std::option::Option<crate::model::ModelBiasAppSpecification>,
        ) -> Self {
            self.inner = self.inner.set_model_bias_app_specification(input);
            self
        }
        /// <p>Inputs for the model bias job.</p>
        pub fn model_bias_job_input(mut self, input: crate::model::ModelBiasJobInput) -> Self {
            self.inner = self.inner.model_bias_job_input(input);
            self
        }
        /// <p>Inputs for the model bias job.</p>
        pub fn set_model_bias_job_input(
            mut self,
            input: std::option::Option<crate::model::ModelBiasJobInput>,
        ) -> Self {
            self.inner = self.inner.set_model_bias_job_input(input);
            self
        }
        /// <p>The output configuration for monitoring jobs.</p>
        pub fn model_bias_job_output_config(
            mut self,
            input: crate::model::MonitoringOutputConfig,
        ) -> Self {
            self.inner = self.inner.model_bias_job_output_config(input);
            self
        }
        /// <p>The output configuration for monitoring jobs.</p>
        pub fn set_model_bias_job_output_config(
            mut self,
            input: std::option::Option<crate::model::MonitoringOutputConfig>,
        ) -> Self {
            self.inner = self.inner.set_model_bias_job_output_config(input);
            self
        }
        /// <p>Identifies the resources to deploy for a monitoring job.</p>
        pub fn job_resources(mut self, input: crate::model::MonitoringResources) -> Self {
            self.inner = self.inner.job_resources(input);
            self
        }
        /// <p>Identifies the resources to deploy for a monitoring job.</p>
        pub fn set_job_resources(
            mut self,
            input: std::option::Option<crate::model::MonitoringResources>,
        ) -> Self {
            self.inner = self.inner.set_job_resources(input);
            self
        }
        /// <p>Networking options for a model bias job.</p>
        pub fn network_config(mut self, input: crate::model::MonitoringNetworkConfig) -> Self {
            self.inner = self.inner.network_config(input);
            self
        }
        /// <p>Networking options for a model bias job.</p>
        pub fn set_network_config(
            mut self,
            input: std::option::Option<crate::model::MonitoringNetworkConfig>,
        ) -> Self {
            self.inner = self.inner.set_network_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
        pub fn stopping_condition(
            mut self,
            input: crate::model::MonitoringStoppingCondition,
        ) -> Self {
            self.inner = self.inner.stopping_condition(input);
            self
        }
        /// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
        pub fn set_stopping_condition(
            mut self,
            input: std::option::Option<crate::model::MonitoringStoppingCondition>,
        ) -> Self {
            self.inner = self.inner.set_stopping_condition(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateModelExplainabilityJobDefinition`.
    ///
    /// <p>Creates the definition for a model explainability job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateModelExplainabilityJobDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_model_explainability_job_definition_input::Builder,
    }
    impl<C, M, R> CreateModelExplainabilityJobDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateModelExplainabilityJobDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateModelExplainabilityJobDefinitionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateModelExplainabilityJobDefinitionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateModelExplainabilityJobDefinitionInputOperationOutputAlias,
                crate::output::CreateModelExplainabilityJobDefinitionOutput,
                crate::error::CreateModelExplainabilityJobDefinitionError,
                crate::input::CreateModelExplainabilityJobDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the model explainability job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
        pub fn job_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_definition_name(input.into());
            self
        }
        /// <p> The name of the model explainability job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
        pub fn set_job_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_job_definition_name(input);
            self
        }
        /// <p>The baseline configuration for a model explainability job.</p>
        pub fn model_explainability_baseline_config(
            mut self,
            input: crate::model::ModelExplainabilityBaselineConfig,
        ) -> Self {
            self.inner = self.inner.model_explainability_baseline_config(input);
            self
        }
        /// <p>The baseline configuration for a model explainability job.</p>
        pub fn set_model_explainability_baseline_config(
            mut self,
            input: std::option::Option<crate::model::ModelExplainabilityBaselineConfig>,
        ) -> Self {
            self.inner = self.inner.set_model_explainability_baseline_config(input);
            self
        }
        /// <p>Configures the model explainability job to run a specified Docker container image.</p>
        pub fn model_explainability_app_specification(
            mut self,
            input: crate::model::ModelExplainabilityAppSpecification,
        ) -> Self {
            self.inner = self.inner.model_explainability_app_specification(input);
            self
        }
        /// <p>Configures the model explainability job to run a specified Docker container image.</p>
        pub fn set_model_explainability_app_specification(
            mut self,
            input: std::option::Option<crate::model::ModelExplainabilityAppSpecification>,
        ) -> Self {
            self.inner = self.inner.set_model_explainability_app_specification(input);
            self
        }
        /// <p>Inputs for the model explainability job.</p>
        pub fn model_explainability_job_input(
            mut self,
            input: crate::model::ModelExplainabilityJobInput,
        ) -> Self {
            self.inner = self.inner.model_explainability_job_input(input);
            self
        }
        /// <p>Inputs for the model explainability job.</p>
        pub fn set_model_explainability_job_input(
            mut self,
            input: std::option::Option<crate::model::ModelExplainabilityJobInput>,
        ) -> Self {
            self.inner = self.inner.set_model_explainability_job_input(input);
            self
        }
        /// <p>The output configuration for monitoring jobs.</p>
        pub fn model_explainability_job_output_config(
            mut self,
            input: crate::model::MonitoringOutputConfig,
        ) -> Self {
            self.inner = self.inner.model_explainability_job_output_config(input);
            self
        }
        /// <p>The output configuration for monitoring jobs.</p>
        pub fn set_model_explainability_job_output_config(
            mut self,
            input: std::option::Option<crate::model::MonitoringOutputConfig>,
        ) -> Self {
            self.inner = self.inner.set_model_explainability_job_output_config(input);
            self
        }
        /// <p>Identifies the resources to deploy for a monitoring job.</p>
        pub fn job_resources(mut self, input: crate::model::MonitoringResources) -> Self {
            self.inner = self.inner.job_resources(input);
            self
        }
        /// <p>Identifies the resources to deploy for a monitoring job.</p>
        pub fn set_job_resources(
            mut self,
            input: std::option::Option<crate::model::MonitoringResources>,
        ) -> Self {
            self.inner = self.inner.set_job_resources(input);
            self
        }
        /// <p>Networking options for a model explainability job.</p>
        pub fn network_config(mut self, input: crate::model::MonitoringNetworkConfig) -> Self {
            self.inner = self.inner.network_config(input);
            self
        }
        /// <p>Networking options for a model explainability job.</p>
        pub fn set_network_config(
            mut self,
            input: std::option::Option<crate::model::MonitoringNetworkConfig>,
        ) -> Self {
            self.inner = self.inner.set_network_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
        pub fn stopping_condition(
            mut self,
            input: crate::model::MonitoringStoppingCondition,
        ) -> Self {
            self.inner = self.inner.stopping_condition(input);
            self
        }
        /// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
        pub fn set_stopping_condition(
            mut self,
            input: std::option::Option<crate::model::MonitoringStoppingCondition>,
        ) -> Self {
            self.inner = self.inner.set_stopping_condition(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateModelPackage`.
    ///
    /// <p>Creates a model package that you can use to create Amazon SageMaker models or list on Amazon Web Services Marketplace, or a versioned model that is part of a model group. Buyers can subscribe to model packages listed on Amazon Web Services Marketplace to create models in Amazon SageMaker.</p>
    /// <p>To create a model package by specifying a Docker container that contains your inference code and the Amazon S3 location of your model artifacts, provide values for <code>InferenceSpecification</code>. To create a model from an algorithm resource that you created or subscribed to in Amazon Web Services Marketplace, provide a value for <code>SourceAlgorithmSpecification</code>.</p> <note>
    /// <p>There are two types of model packages:</p>
    /// <ul>
    /// <li> <p>Versioned - a model that is part of a model group in the model registry.</p> </li>
    /// <li> <p>Unversioned - a model package that is not part of a model group.</p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateModelPackage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_model_package_input::Builder,
    }
    impl<C, M, R> CreateModelPackage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateModelPackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateModelPackageOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateModelPackageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateModelPackageInputOperationOutputAlias,
                crate::output::CreateModelPackageOutput,
                crate::error::CreateModelPackageError,
                crate::input::CreateModelPackageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the model package. The name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).</p>
        /// <p>This parameter is required for unversioned models. It is not applicable to versioned models.</p>
        pub fn model_package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_package_name(input.into());
            self
        }
        /// <p>The name of the model package. The name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).</p>
        /// <p>This parameter is required for unversioned models. It is not applicable to versioned models.</p>
        pub fn set_model_package_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_package_name(input);
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the model package group that this model version belongs to.</p>
        /// <p>This parameter is required for versioned models, and does not apply to unversioned models.</p>
        pub fn model_package_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_package_group_name(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the model package group that this model version belongs to.</p>
        /// <p>This parameter is required for versioned models, and does not apply to unversioned models.</p>
        pub fn set_model_package_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_package_group_name(input);
            self
        }
        /// <p>A description of the model package.</p>
        pub fn model_package_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_package_description(input.into());
            self
        }
        /// <p>A description of the model package.</p>
        pub fn set_model_package_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_package_description(input);
            self
        }
        /// <p>Specifies details about inference jobs that can be run with models based on this model package, including the following:</p>
        /// <ul>
        /// <li> <p>The Amazon ECR paths of containers that contain the inference code and model artifacts.</p> </li>
        /// <li> <p>The instance types that the model package supports for transform jobs and real-time endpoints used for inference.</p> </li>
        /// <li> <p>The input and output content formats that the model package supports for inference.</p> </li>
        /// </ul>
        pub fn inference_specification(
            mut self,
            input: crate::model::InferenceSpecification,
        ) -> Self {
            self.inner = self.inner.inference_specification(input);
            self
        }
        /// <p>Specifies details about inference jobs that can be run with models based on this model package, including the following:</p>
        /// <ul>
        /// <li> <p>The Amazon ECR paths of containers that contain the inference code and model artifacts.</p> </li>
        /// <li> <p>The instance types that the model package supports for transform jobs and real-time endpoints used for inference.</p> </li>
        /// <li> <p>The input and output content formats that the model package supports for inference.</p> </li>
        /// </ul>
        pub fn set_inference_specification(
            mut self,
            input: std::option::Option<crate::model::InferenceSpecification>,
        ) -> Self {
            self.inner = self.inner.set_inference_specification(input);
            self
        }
        /// <p>Specifies configurations for one or more transform jobs that Amazon SageMaker runs to test the model package.</p>
        pub fn validation_specification(
            mut self,
            input: crate::model::ModelPackageValidationSpecification,
        ) -> Self {
            self.inner = self.inner.validation_specification(input);
            self
        }
        /// <p>Specifies configurations for one or more transform jobs that Amazon SageMaker runs to test the model package.</p>
        pub fn set_validation_specification(
            mut self,
            input: std::option::Option<crate::model::ModelPackageValidationSpecification>,
        ) -> Self {
            self.inner = self.inner.set_validation_specification(input);
            self
        }
        /// <p>Details about the algorithm that was used to create the model package.</p>
        pub fn source_algorithm_specification(
            mut self,
            input: crate::model::SourceAlgorithmSpecification,
        ) -> Self {
            self.inner = self.inner.source_algorithm_specification(input);
            self
        }
        /// <p>Details about the algorithm that was used to create the model package.</p>
        pub fn set_source_algorithm_specification(
            mut self,
            input: std::option::Option<crate::model::SourceAlgorithmSpecification>,
        ) -> Self {
            self.inner = self.inner.set_source_algorithm_specification(input);
            self
        }
        /// <p>Whether to certify the model package for listing on Amazon Web Services Marketplace.</p>
        /// <p>This parameter is optional for unversioned models, and does not apply to versioned models.</p>
        pub fn certify_for_marketplace(mut self, input: bool) -> Self {
            self.inner = self.inner.certify_for_marketplace(input);
            self
        }
        /// <p>Whether to certify the model package for listing on Amazon Web Services Marketplace.</p>
        /// <p>This parameter is optional for unversioned models, and does not apply to versioned models.</p>
        pub fn set_certify_for_marketplace(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_certify_for_marketplace(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key value pairs associated with the model. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of key value pairs associated with the model. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Whether the model is approved for deployment.</p>
        /// <p>This parameter is optional for versioned models, and does not apply to unversioned models.</p>
        /// <p>For versioned models, the value of this parameter must be set to <code>Approved</code> to deploy the model.</p>
        pub fn model_approval_status(mut self, input: crate::model::ModelApprovalStatus) -> Self {
            self.inner = self.inner.model_approval_status(input);
            self
        }
        /// <p>Whether the model is approved for deployment.</p>
        /// <p>This parameter is optional for versioned models, and does not apply to unversioned models.</p>
        /// <p>For versioned models, the value of this parameter must be set to <code>Approved</code> to deploy the model.</p>
        pub fn set_model_approval_status(
            mut self,
            input: std::option::Option<crate::model::ModelApprovalStatus>,
        ) -> Self {
            self.inner = self.inner.set_model_approval_status(input);
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn metadata_properties(mut self, input: crate::model::MetadataProperties) -> Self {
            self.inner = self.inner.metadata_properties(input);
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn set_metadata_properties(
            mut self,
            input: std::option::Option<crate::model::MetadataProperties>,
        ) -> Self {
            self.inner = self.inner.set_metadata_properties(input);
            self
        }
        /// <p>A structure that contains model metrics reports.</p>
        pub fn model_metrics(mut self, input: crate::model::ModelMetrics) -> Self {
            self.inner = self.inner.model_metrics(input);
            self
        }
        /// <p>A structure that contains model metrics reports.</p>
        pub fn set_model_metrics(
            mut self,
            input: std::option::Option<crate::model::ModelMetrics>,
        ) -> Self {
            self.inner = self.inner.set_model_metrics(input);
            self
        }
        /// <p>A unique token that guarantees that the call to this API is idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique token that guarantees that the call to this API is idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `CustomerMetadataProperties`.
        ///
        /// To override the contents of this collection use [`set_customer_metadata_properties`](Self::set_customer_metadata_properties).
        ///
        /// <p>The metadata properties associated with the model package versions.</p>
        pub fn customer_metadata_properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.customer_metadata_properties(k.into(), v.into());
            self
        }
        /// <p>The metadata properties associated with the model package versions.</p>
        pub fn set_customer_metadata_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_customer_metadata_properties(input);
            self
        }
        /// <p>Represents the drift check baselines that can be used when the model monitor is set using the model package. For more information, see the topic on <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-quality-clarify-baseline-lifecycle.html#pipelines-quality-clarify-baseline-drift-detection">Drift Detection against Previous Baselines in SageMaker Pipelines</a> in the <i>Amazon SageMaker Developer Guide</i>. </p>
        pub fn drift_check_baselines(mut self, input: crate::model::DriftCheckBaselines) -> Self {
            self.inner = self.inner.drift_check_baselines(input);
            self
        }
        /// <p>Represents the drift check baselines that can be used when the model monitor is set using the model package. For more information, see the topic on <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-quality-clarify-baseline-lifecycle.html#pipelines-quality-clarify-baseline-drift-detection">Drift Detection against Previous Baselines in SageMaker Pipelines</a> in the <i>Amazon SageMaker Developer Guide</i>. </p>
        pub fn set_drift_check_baselines(
            mut self,
            input: std::option::Option<crate::model::DriftCheckBaselines>,
        ) -> Self {
            self.inner = self.inner.set_drift_check_baselines(input);
            self
        }
        /// <p>The machine learning domain of your model package and its components. Common machine learning domains include computer vision and natural language processing.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The machine learning domain of your model package and its components. Common machine learning domains include computer vision and natural language processing.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>The machine learning task your model package accomplishes. Common machine learning tasks include object detection and image classification.</p>
        pub fn task(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task(input.into());
            self
        }
        /// <p>The machine learning task your model package accomplishes. Common machine learning tasks include object detection and image classification.</p>
        pub fn set_task(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task(input);
            self
        }
        /// <p>The Amazon Simple Storage Service (Amazon S3) path where the sample payload are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix).</p>
        pub fn sample_payload_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sample_payload_url(input.into());
            self
        }
        /// <p>The Amazon Simple Storage Service (Amazon S3) path where the sample payload are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix).</p>
        pub fn set_sample_payload_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sample_payload_url(input);
            self
        }
        /// Appends an item to `AdditionalInferenceSpecifications`.
        ///
        /// To override the contents of this collection use [`set_additional_inference_specifications`](Self::set_additional_inference_specifications).
        ///
        /// <p>An array of additional Inference Specification objects. Each additional Inference Specification specifies artifacts based on this model package that can be used on inference endpoints. Generally used with SageMaker Neo to store the compiled artifacts. </p>
        pub fn additional_inference_specifications(
            mut self,
            input: crate::model::AdditionalInferenceSpecificationDefinition,
        ) -> Self {
            self.inner = self.inner.additional_inference_specifications(input);
            self
        }
        /// <p>An array of additional Inference Specification objects. Each additional Inference Specification specifies artifacts based on this model package that can be used on inference endpoints. Generally used with SageMaker Neo to store the compiled artifacts. </p>
        pub fn set_additional_inference_specifications(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AdditionalInferenceSpecificationDefinition>,
            >,
        ) -> Self {
            self.inner = self.inner.set_additional_inference_specifications(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateModelPackageGroup`.
    ///
    /// <p>Creates a model group. A model group contains a group of model versions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateModelPackageGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_model_package_group_input::Builder,
    }
    impl<C, M, R> CreateModelPackageGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateModelPackageGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateModelPackageGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateModelPackageGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateModelPackageGroupInputOperationOutputAlias,
                crate::output::CreateModelPackageGroupOutput,
                crate::error::CreateModelPackageGroupError,
                crate::input::CreateModelPackageGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the model group.</p>
        pub fn model_package_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_package_group_name(input.into());
            self
        }
        /// <p>The name of the model group.</p>
        pub fn set_model_package_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_package_group_name(input);
            self
        }
        /// <p>A description for the model group.</p>
        pub fn model_package_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.model_package_group_description(input.into());
            self
        }
        /// <p>A description for the model group.</p>
        pub fn set_model_package_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_package_group_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key value pairs associated with the model group. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of key value pairs associated with the model group. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateModelQualityJobDefinition`.
    ///
    /// <p>Creates a definition for a job that monitors model quality and drift. For information about model monitor, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker Model Monitor</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateModelQualityJobDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_model_quality_job_definition_input::Builder,
    }
    impl<C, M, R> CreateModelQualityJobDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateModelQualityJobDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateModelQualityJobDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateModelQualityJobDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateModelQualityJobDefinitionInputOperationOutputAlias,
                crate::output::CreateModelQualityJobDefinitionOutput,
                crate::error::CreateModelQualityJobDefinitionError,
                crate::input::CreateModelQualityJobDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the monitoring job definition.</p>
        pub fn job_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_definition_name(input.into());
            self
        }
        /// <p>The name of the monitoring job definition.</p>
        pub fn set_job_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_job_definition_name(input);
            self
        }
        /// <p>Specifies the constraints and baselines for the monitoring job.</p>
        pub fn model_quality_baseline_config(
            mut self,
            input: crate::model::ModelQualityBaselineConfig,
        ) -> Self {
            self.inner = self.inner.model_quality_baseline_config(input);
            self
        }
        /// <p>Specifies the constraints and baselines for the monitoring job.</p>
        pub fn set_model_quality_baseline_config(
            mut self,
            input: std::option::Option<crate::model::ModelQualityBaselineConfig>,
        ) -> Self {
            self.inner = self.inner.set_model_quality_baseline_config(input);
            self
        }
        /// <p>The container that runs the monitoring job.</p>
        pub fn model_quality_app_specification(
            mut self,
            input: crate::model::ModelQualityAppSpecification,
        ) -> Self {
            self.inner = self.inner.model_quality_app_specification(input);
            self
        }
        /// <p>The container that runs the monitoring job.</p>
        pub fn set_model_quality_app_specification(
            mut self,
            input: std::option::Option<crate::model::ModelQualityAppSpecification>,
        ) -> Self {
            self.inner = self.inner.set_model_quality_app_specification(input);
            self
        }
        /// <p>A list of the inputs that are monitored. Currently endpoints are supported.</p>
        pub fn model_quality_job_input(
            mut self,
            input: crate::model::ModelQualityJobInput,
        ) -> Self {
            self.inner = self.inner.model_quality_job_input(input);
            self
        }
        /// <p>A list of the inputs that are monitored. Currently endpoints are supported.</p>
        pub fn set_model_quality_job_input(
            mut self,
            input: std::option::Option<crate::model::ModelQualityJobInput>,
        ) -> Self {
            self.inner = self.inner.set_model_quality_job_input(input);
            self
        }
        /// <p>The output configuration for monitoring jobs.</p>
        pub fn model_quality_job_output_config(
            mut self,
            input: crate::model::MonitoringOutputConfig,
        ) -> Self {
            self.inner = self.inner.model_quality_job_output_config(input);
            self
        }
        /// <p>The output configuration for monitoring jobs.</p>
        pub fn set_model_quality_job_output_config(
            mut self,
            input: std::option::Option<crate::model::MonitoringOutputConfig>,
        ) -> Self {
            self.inner = self.inner.set_model_quality_job_output_config(input);
            self
        }
        /// <p>Identifies the resources to deploy for a monitoring job.</p>
        pub fn job_resources(mut self, input: crate::model::MonitoringResources) -> Self {
            self.inner = self.inner.job_resources(input);
            self
        }
        /// <p>Identifies the resources to deploy for a monitoring job.</p>
        pub fn set_job_resources(
            mut self,
            input: std::option::Option<crate::model::MonitoringResources>,
        ) -> Self {
            self.inner = self.inner.set_job_resources(input);
            self
        }
        /// <p>Specifies the network configuration for the monitoring job.</p>
        pub fn network_config(mut self, input: crate::model::MonitoringNetworkConfig) -> Self {
            self.inner = self.inner.network_config(input);
            self
        }
        /// <p>Specifies the network configuration for the monitoring job.</p>
        pub fn set_network_config(
            mut self,
            input: std::option::Option<crate::model::MonitoringNetworkConfig>,
        ) -> Self {
            self.inner = self.inner.set_network_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
        pub fn stopping_condition(
            mut self,
            input: crate::model::MonitoringStoppingCondition,
        ) -> Self {
            self.inner = self.inner.stopping_condition(input);
            self
        }
        /// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
        pub fn set_stopping_condition(
            mut self,
            input: std::option::Option<crate::model::MonitoringStoppingCondition>,
        ) -> Self {
            self.inner = self.inner.set_stopping_condition(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMonitoringSchedule`.
    ///
    /// <p>Creates a schedule that regularly starts Amazon SageMaker Processing Jobs to monitor the data captured for an Amazon SageMaker Endoint.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateMonitoringSchedule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_monitoring_schedule_input::Builder,
    }
    impl<C, M, R> CreateMonitoringSchedule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMonitoringSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMonitoringScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMonitoringScheduleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMonitoringScheduleInputOperationOutputAlias,
                crate::output::CreateMonitoringScheduleOutput,
                crate::error::CreateMonitoringScheduleError,
                crate::input::CreateMonitoringScheduleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the monitoring schedule. The name must be unique within an Amazon Web Services Region within an Amazon Web Services account.</p>
        pub fn monitoring_schedule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.monitoring_schedule_name(input.into());
            self
        }
        /// <p>The name of the monitoring schedule. The name must be unique within an Amazon Web Services Region within an Amazon Web Services account.</p>
        pub fn set_monitoring_schedule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_monitoring_schedule_name(input);
            self
        }
        /// <p>The configuration object that specifies the monitoring schedule and defines the monitoring job.</p>
        pub fn monitoring_schedule_config(
            mut self,
            input: crate::model::MonitoringScheduleConfig,
        ) -> Self {
            self.inner = self.inner.monitoring_schedule_config(input);
            self
        }
        /// <p>The configuration object that specifies the monitoring schedule and defines the monitoring job.</p>
        pub fn set_monitoring_schedule_config(
            mut self,
            input: std::option::Option<crate::model::MonitoringScheduleConfig>,
        ) -> Self {
            self.inner = self.inner.set_monitoring_schedule_config(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>(Optional) An array of key-value pairs. For more information, see <a href=" https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>(Optional) An array of key-value pairs. For more information, see <a href=" https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateNotebookInstance`.
    ///
    /// <p>Creates an Amazon SageMaker notebook instance. A notebook instance is a machine learning (ML) compute instance running on a Jupyter notebook. </p>
    /// <p>In a <code>CreateNotebookInstance</code> request, specify the type of ML compute instance that you want to run. Amazon SageMaker launches the instance, installs common libraries that you can use to explore datasets for model training, and attaches an ML storage volume to the notebook instance. </p>
    /// <p>Amazon SageMaker also provides a set of example notebooks. Each notebook demonstrates how to use Amazon SageMaker with a specific algorithm or with a machine learning framework. </p>
    /// <p>After receiving the request, Amazon SageMaker does the following:</p>
    /// <ol>
    /// <li> <p>Creates a network interface in the Amazon SageMaker VPC.</p> </li>
    /// <li> <p>(Option) If you specified <code>SubnetId</code>, Amazon SageMaker creates a network interface in your own VPC, which is inferred from the subnet ID that you provide in the input. When creating this network interface, Amazon SageMaker attaches the security group that you specified in the request to the network interface that it creates in your VPC.</p> </li>
    /// <li> <p>Launches an EC2 instance of the type specified in the request in the Amazon SageMaker VPC. If you specified <code>SubnetId</code> of your VPC, Amazon SageMaker specifies both network interfaces when launching this instance. This enables inbound traffic from your own VPC to the notebook instance, assuming that the security groups allow it.</p> </li>
    /// </ol>
    /// <p>After creating the notebook instance, Amazon SageMaker returns its Amazon Resource Name (ARN). You can't change the name of a notebook instance after you create it.</p>
    /// <p>After Amazon SageMaker creates the notebook instance, you can connect to the Jupyter server and work in Jupyter notebooks. For example, you can write code to explore a dataset that you can use for model training, train a model, host models by creating Amazon SageMaker endpoints, and validate hosted models. </p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html">How It Works</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateNotebookInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_notebook_instance_input::Builder,
    }
    impl<C, M, R> CreateNotebookInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateNotebookInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateNotebookInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateNotebookInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateNotebookInstanceInputOperationOutputAlias,
                crate::output::CreateNotebookInstanceOutput,
                crate::error::CreateNotebookInstanceError,
                crate::input::CreateNotebookInstanceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the new notebook instance.</p>
        pub fn notebook_instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notebook_instance_name(input.into());
            self
        }
        /// <p>The name of the new notebook instance.</p>
        pub fn set_notebook_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notebook_instance_name(input);
            self
        }
        /// <p>The type of ML compute instance to launch for the notebook instance.</p>
        pub fn instance_type(mut self, input: crate::model::InstanceType) -> Self {
            self.inner = self.inner.instance_type(input);
            self
        }
        /// <p>The type of ML compute instance to launch for the notebook instance.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<crate::model::InstanceType>,
        ) -> Self {
            self.inner = self.inner.set_instance_type(input);
            self
        }
        /// <p>The ID of the subnet in a VPC to which you would like to have a connectivity from your ML compute instance. </p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_id(input.into());
            self
        }
        /// <p>The ID of the subnet in a VPC to which you would like to have a connectivity from your ML compute instance. </p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subnet_id(input);
            self
        }
        /// Appends an item to `SecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The VPC security group IDs, in the form sg-xxxxxxxx. The security groups must be for the same VPC as specified in the subnet. </p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(input.into());
            self
        }
        /// <p>The VPC security group IDs, in the form sg-xxxxxxxx. The security groups must be for the same VPC as specified in the subnet. </p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
        /// <p> When you send any requests to Amazon Web Services resources from the notebook instance, Amazon SageMaker assumes this role to perform tasks on your behalf. You must grant this role necessary permissions so Amazon SageMaker can perform these tasks. The policy must allow the Amazon SageMaker service principal (sagemaker.amazonaws.com) permissions to assume this role. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles</a>. </p> <note>
        /// <p>To be able to pass this role to Amazon SageMaker, the caller of this API must have the <code>iam:PassRole</code> permission.</p>
        /// </note>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p> When you send any requests to Amazon Web Services resources from the notebook instance, Amazon SageMaker assumes this role to perform tasks on your behalf. You must grant this role necessary permissions so Amazon SageMaker can perform these tasks. The policy must allow the Amazon SageMaker service principal (sagemaker.amazonaws.com) permissions to assume this role. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles</a>. </p> <note>
        /// <p>To be able to pass this role to Amazon SageMaker, the caller of this API must have the <code>iam:PassRole</code> permission.</p>
        /// </note>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to your notebook instance. The KMS key you provide must be enabled. For information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html">Enabling and Disabling Keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to your notebook instance. The KMS key you provide must be enabled. For information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html">Enabling and Disabling Keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The name of a lifecycle configuration to associate with the notebook instance. For information about lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a>.</p>
        pub fn lifecycle_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lifecycle_config_name(input.into());
            self
        }
        /// <p>The name of a lifecycle configuration to associate with the notebook instance. For information about lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a>.</p>
        pub fn set_lifecycle_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_lifecycle_config_name(input);
            self
        }
        /// <p>Sets whether Amazon SageMaker provides internet access to the notebook instance. If you set this to <code>Disabled</code> this notebook instance is able to access resources only in your VPC, and is not be able to connect to Amazon SageMaker training and endpoint services unless you configure a NAT Gateway in your VPC.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access">Notebook Instances Are Internet-Enabled by Default</a>. You can set the value of this parameter to <code>Disabled</code> only if you set a value for the <code>SubnetId</code> parameter.</p>
        pub fn direct_internet_access(mut self, input: crate::model::DirectInternetAccess) -> Self {
            self.inner = self.inner.direct_internet_access(input);
            self
        }
        /// <p>Sets whether Amazon SageMaker provides internet access to the notebook instance. If you set this to <code>Disabled</code> this notebook instance is able to access resources only in your VPC, and is not be able to connect to Amazon SageMaker training and endpoint services unless you configure a NAT Gateway in your VPC.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access">Notebook Instances Are Internet-Enabled by Default</a>. You can set the value of this parameter to <code>Disabled</code> only if you set a value for the <code>SubnetId</code> parameter.</p>
        pub fn set_direct_internet_access(
            mut self,
            input: std::option::Option<crate::model::DirectInternetAccess>,
        ) -> Self {
            self.inner = self.inner.set_direct_internet_access(input);
            self
        }
        /// <p>The size, in GB, of the ML storage volume to attach to the notebook instance. The default value is 5 GB.</p>
        pub fn volume_size_in_gb(mut self, input: i32) -> Self {
            self.inner = self.inner.volume_size_in_gb(input);
            self
        }
        /// <p>The size, in GB, of the ML storage volume to attach to the notebook instance. The default value is 5 GB.</p>
        pub fn set_volume_size_in_gb(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_volume_size_in_gb(input);
            self
        }
        /// Appends an item to `AcceleratorTypes`.
        ///
        /// To override the contents of this collection use [`set_accelerator_types`](Self::set_accelerator_types).
        ///
        /// <p>A list of Elastic Inference (EI) instance types to associate with this notebook instance. Currently, only one instance type can be associated with a notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.</p>
        pub fn accelerator_types(
            mut self,
            input: crate::model::NotebookInstanceAcceleratorType,
        ) -> Self {
            self.inner = self.inner.accelerator_types(input);
            self
        }
        /// <p>A list of Elastic Inference (EI) instance types to associate with this notebook instance. Currently, only one instance type can be associated with a notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.</p>
        pub fn set_accelerator_types(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::NotebookInstanceAcceleratorType>,
            >,
        ) -> Self {
            self.inner = self.inner.set_accelerator_types(input);
            self
        }
        /// <p>A Git repository to associate with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>
        pub fn default_code_repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_code_repository(input.into());
            self
        }
        /// <p>A Git repository to associate with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>
        pub fn set_default_code_repository(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_code_repository(input);
            self
        }
        /// Appends an item to `AdditionalCodeRepositories`.
        ///
        /// To override the contents of this collection use [`set_additional_code_repositories`](Self::set_additional_code_repositories).
        ///
        /// <p>An array of up to three Git repositories to associate with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>
        pub fn additional_code_repositories(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.additional_code_repositories(input.into());
            self
        }
        /// <p>An array of up to three Git repositories to associate with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>
        pub fn set_additional_code_repositories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_additional_code_repositories(input);
            self
        }
        /// <p>Whether root access is enabled or disabled for users of the notebook instance. The default value is <code>Enabled</code>.</p> <note>
        /// <p>Lifecycle configurations need root access to be able to set up a notebook instance. Because of this, lifecycle configurations associated with a notebook instance always run with root access even if you disable root access for users.</p>
        /// </note>
        pub fn root_access(mut self, input: crate::model::RootAccess) -> Self {
            self.inner = self.inner.root_access(input);
            self
        }
        /// <p>Whether root access is enabled or disabled for users of the notebook instance. The default value is <code>Enabled</code>.</p> <note>
        /// <p>Lifecycle configurations need root access to be able to set up a notebook instance. Because of this, lifecycle configurations associated with a notebook instance always run with root access even if you disable root access for users.</p>
        /// </note>
        pub fn set_root_access(
            mut self,
            input: std::option::Option<crate::model::RootAccess>,
        ) -> Self {
            self.inner = self.inner.set_root_access(input);
            self
        }
        /// <p>The platform identifier of the notebook instance runtime environment.</p>
        pub fn platform_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.platform_identifier(input.into());
            self
        }
        /// <p>The platform identifier of the notebook instance runtime environment.</p>
        pub fn set_platform_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_platform_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateNotebookInstanceLifecycleConfig`.
    ///
    /// <p>Creates a lifecycle configuration that you can associate with a notebook instance. A <i>lifecycle configuration</i> is a collection of shell scripts that run when you create or start a notebook instance.</p>
    /// <p>Each lifecycle configuration script has a limit of 16384 characters.</p>
    /// <p>The value of the <code>$PATH</code> environment variable that is available to both scripts is <code>/sbin:bin:/usr/sbin:/usr/bin</code>.</p>
    /// <p>View CloudWatch Logs for notebook instance lifecycle configurations in log group <code>/aws/sagemaker/NotebookInstances</code> in log stream <code>[notebook-instance-name]/[LifecycleConfigHook]</code>.</p>
    /// <p>Lifecycle configuration scripts cannot run for longer than 5 minutes. If a script runs for longer than 5 minutes, it fails and the notebook instance is not created or started.</p>
    /// <p>For information about notebook instance lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateNotebookInstanceLifecycleConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_notebook_instance_lifecycle_config_input::Builder,
    }
    impl<C, M, R> CreateNotebookInstanceLifecycleConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateNotebookInstanceLifecycleConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateNotebookInstanceLifecycleConfigOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateNotebookInstanceLifecycleConfigError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateNotebookInstanceLifecycleConfigInputOperationOutputAlias,
                crate::output::CreateNotebookInstanceLifecycleConfigOutput,
                crate::error::CreateNotebookInstanceLifecycleConfigError,
                crate::input::CreateNotebookInstanceLifecycleConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the lifecycle configuration.</p>
        pub fn notebook_instance_lifecycle_config_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .notebook_instance_lifecycle_config_name(input.into());
            self
        }
        /// <p>The name of the lifecycle configuration.</p>
        pub fn set_notebook_instance_lifecycle_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_notebook_instance_lifecycle_config_name(input);
            self
        }
        /// Appends an item to `OnCreate`.
        ///
        /// To override the contents of this collection use [`set_on_create`](Self::set_on_create).
        ///
        /// <p>A shell script that runs only once, when you create a notebook instance. The shell script must be a base64-encoded string.</p>
        pub fn on_create(mut self, input: crate::model::NotebookInstanceLifecycleHook) -> Self {
            self.inner = self.inner.on_create(input);
            self
        }
        /// <p>A shell script that runs only once, when you create a notebook instance. The shell script must be a base64-encoded string.</p>
        pub fn set_on_create(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NotebookInstanceLifecycleHook>>,
        ) -> Self {
            self.inner = self.inner.set_on_create(input);
            self
        }
        /// Appends an item to `OnStart`.
        ///
        /// To override the contents of this collection use [`set_on_start`](Self::set_on_start).
        ///
        /// <p>A shell script that runs every time you start a notebook instance, including when you create the notebook instance. The shell script must be a base64-encoded string.</p>
        pub fn on_start(mut self, input: crate::model::NotebookInstanceLifecycleHook) -> Self {
            self.inner = self.inner.on_start(input);
            self
        }
        /// <p>A shell script that runs every time you start a notebook instance, including when you create the notebook instance. The shell script must be a base64-encoded string.</p>
        pub fn set_on_start(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NotebookInstanceLifecycleHook>>,
        ) -> Self {
            self.inner = self.inner.set_on_start(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePipeline`.
    ///
    /// <p>Creates a pipeline using a JSON pipeline definition.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePipeline<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_pipeline_input::Builder,
    }
    impl<C, M, R> CreatePipeline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePipelineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePipelineInputOperationOutputAlias,
                crate::output::CreatePipelineOutput,
                crate::error::CreatePipelineError,
                crate::input::CreatePipelineInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the pipeline.</p>
        pub fn pipeline_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_name(input.into());
            self
        }
        /// <p>The name of the pipeline.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_name(input);
            self
        }
        /// <p>The display name of the pipeline.</p>
        pub fn pipeline_display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_display_name(input.into());
            self
        }
        /// <p>The display name of the pipeline.</p>
        pub fn set_pipeline_display_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_display_name(input);
            self
        }
        /// <p>The JSON pipeline definition of the pipeline.</p>
        pub fn pipeline_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_definition(input.into());
            self
        }
        /// <p>The JSON pipeline definition of the pipeline.</p>
        pub fn set_pipeline_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_definition(input);
            self
        }
        /// <p>The location of the pipeline definition stored in Amazon S3. If specified, SageMaker will retrieve the pipeline definition from this location.</p>
        pub fn pipeline_definition_s3_location(
            mut self,
            input: crate::model::PipelineDefinitionS3Location,
        ) -> Self {
            self.inner = self.inner.pipeline_definition_s3_location(input);
            self
        }
        /// <p>The location of the pipeline definition stored in Amazon S3. If specified, SageMaker will retrieve the pipeline definition from this location.</p>
        pub fn set_pipeline_definition_s3_location(
            mut self,
            input: std::option::Option<crate::model::PipelineDefinitionS3Location>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_definition_s3_location(input);
            self
        }
        /// <p>A description of the pipeline.</p>
        pub fn pipeline_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_description(input.into());
            self
        }
        /// <p>A description of the pipeline.</p>
        pub fn set_pipeline_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_description(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role used by the pipeline to access and create resources.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role used by the pipeline to access and create resources.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to apply to the created pipeline.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to apply to the created pipeline.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>This is the configuration that controls the parallelism of the pipeline. If specified, it applies to all runs of this pipeline by default.</p>
        pub fn parallelism_configuration(
            mut self,
            input: crate::model::ParallelismConfiguration,
        ) -> Self {
            self.inner = self.inner.parallelism_configuration(input);
            self
        }
        /// <p>This is the configuration that controls the parallelism of the pipeline. If specified, it applies to all runs of this pipeline by default.</p>
        pub fn set_parallelism_configuration(
            mut self,
            input: std::option::Option<crate::model::ParallelismConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_parallelism_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePresignedDomainUrl`.
    ///
    /// <p>Creates a URL for a specified UserProfile in a Domain. When accessed in a web browser, the user will be automatically signed in to Amazon SageMaker Studio, and granted access to all of the Apps and files associated with the Domain's Amazon Elastic File System (EFS) volume. This operation can only be called when the authentication mode equals IAM. </p>
    /// <p>The IAM role or user used to call this API defines the permissions to access the app. Once the presigned URL is created, no additional permission is required to access this URL. IAM authorization policies for this API are also enforced for every HTTP request and WebSocket frame that attempts to connect to the app.</p>
    /// <p>You can restrict access to this API and to the URL that it returns to a list of IP addresses, Amazon VPCs or Amazon VPC Endpoints that you specify. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-interface-endpoint.html">Connect to SageMaker Studio Through an Interface VPC Endpoint</a> .</p> <note>
    /// <p>The URL that you get from a call to <code>CreatePresignedDomainUrl</code> has a default timeout of 5 minutes. You can configure this value using <code>ExpiresInSeconds</code>. If you try to use the URL after the timeout limit expires, you are directed to the Amazon Web Services console sign-in page.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePresignedDomainUrl<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_presigned_domain_url_input::Builder,
    }
    impl<C, M, R> CreatePresignedDomainUrl<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePresignedDomainUrl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePresignedDomainUrlOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePresignedDomainUrlError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePresignedDomainUrlInputOperationOutputAlias,
                crate::output::CreatePresignedDomainUrlOutput,
                crate::error::CreatePresignedDomainUrlError,
                crate::input::CreatePresignedDomainUrlInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain ID.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(input.into());
            self
        }
        /// <p>The domain ID.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The name of the UserProfile to sign-in as.</p>
        pub fn user_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_profile_name(input.into());
            self
        }
        /// <p>The name of the UserProfile to sign-in as.</p>
        pub fn set_user_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_user_profile_name(input);
            self
        }
        /// <p>The session expiration duration in seconds. This value defaults to 43200.</p>
        pub fn session_expiration_duration_in_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.session_expiration_duration_in_seconds(input);
            self
        }
        /// <p>The session expiration duration in seconds. This value defaults to 43200.</p>
        pub fn set_session_expiration_duration_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_session_expiration_duration_in_seconds(input);
            self
        }
        /// <p>The number of seconds until the pre-signed URL expires. This value defaults to 300.</p>
        pub fn expires_in_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.expires_in_seconds(input);
            self
        }
        /// <p>The number of seconds until the pre-signed URL expires. This value defaults to 300.</p>
        pub fn set_expires_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_expires_in_seconds(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePresignedNotebookInstanceUrl`.
    ///
    /// <p>Returns a URL that you can use to connect to the Jupyter server from a notebook instance. In the Amazon SageMaker console, when you choose <code>Open</code> next to a notebook instance, Amazon SageMaker opens a new tab showing the Jupyter server home page from the notebook instance. The console uses this API to get the URL and show the page.</p>
    /// <p> The IAM role or user used to call this API defines the permissions to access the notebook instance. Once the presigned URL is created, no additional permission is required to access this URL. IAM authorization policies for this API are also enforced for every HTTP request and WebSocket frame that attempts to connect to the notebook instance.</p>
    /// <p>You can restrict access to this API and to the URL that it returns to a list of IP addresses that you specify. Use the <code>NotIpAddress</code> condition operator and the <code>aws:SourceIP</code> condition context key to specify the list of IP addresses that you want to have access to the notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/security_iam_id-based-policy-examples.html#nbi-ip-filter">Limit Access to a Notebook Instance by IP Address</a>.</p> <note>
    /// <p>The URL that you get from a call to <code>CreatePresignedNotebookInstanceUrl</code> is valid only for 5 minutes. If you try to use the URL after the 5-minute limit expires, you are directed to the Amazon Web Services console sign-in page.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePresignedNotebookInstanceUrl<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_presigned_notebook_instance_url_input::Builder,
    }
    impl<C, M, R> CreatePresignedNotebookInstanceUrl<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePresignedNotebookInstanceUrl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePresignedNotebookInstanceUrlOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreatePresignedNotebookInstanceUrlError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePresignedNotebookInstanceUrlInputOperationOutputAlias,
                crate::output::CreatePresignedNotebookInstanceUrlOutput,
                crate::error::CreatePresignedNotebookInstanceUrlError,
                crate::input::CreatePresignedNotebookInstanceUrlInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the notebook instance.</p>
        pub fn notebook_instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notebook_instance_name(input.into());
            self
        }
        /// <p>The name of the notebook instance.</p>
        pub fn set_notebook_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notebook_instance_name(input);
            self
        }
        /// <p>The duration of the session, in seconds. The default is 12 hours.</p>
        pub fn session_expiration_duration_in_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.session_expiration_duration_in_seconds(input);
            self
        }
        /// <p>The duration of the session, in seconds. The default is 12 hours.</p>
        pub fn set_session_expiration_duration_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_session_expiration_duration_in_seconds(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProcessingJob`.
    ///
    /// <p>Creates a processing job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateProcessingJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_processing_job_input::Builder,
    }
    impl<C, M, R> CreateProcessingJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProcessingJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProcessingJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProcessingJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProcessingJobInputOperationOutputAlias,
                crate::output::CreateProcessingJobOutput,
                crate::error::CreateProcessingJobError,
                crate::input::CreateProcessingJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ProcessingInputs`.
        ///
        /// To override the contents of this collection use [`set_processing_inputs`](Self::set_processing_inputs).
        ///
        /// <p>An array of inputs configuring the data to download into the processing container.</p>
        pub fn processing_inputs(mut self, input: crate::model::ProcessingInput) -> Self {
            self.inner = self.inner.processing_inputs(input);
            self
        }
        /// <p>An array of inputs configuring the data to download into the processing container.</p>
        pub fn set_processing_inputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProcessingInput>>,
        ) -> Self {
            self.inner = self.inner.set_processing_inputs(input);
            self
        }
        /// <p>Output configuration for the processing job.</p>
        pub fn processing_output_config(
            mut self,
            input: crate::model::ProcessingOutputConfig,
        ) -> Self {
            self.inner = self.inner.processing_output_config(input);
            self
        }
        /// <p>Output configuration for the processing job.</p>
        pub fn set_processing_output_config(
            mut self,
            input: std::option::Option<crate::model::ProcessingOutputConfig>,
        ) -> Self {
            self.inner = self.inner.set_processing_output_config(input);
            self
        }
        /// <p> The name of the processing job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
        pub fn processing_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.processing_job_name(input.into());
            self
        }
        /// <p> The name of the processing job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
        pub fn set_processing_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_processing_job_name(input);
            self
        }
        /// <p>Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In distributed training, you specify more than one instance.</p>
        pub fn processing_resources(mut self, input: crate::model::ProcessingResources) -> Self {
            self.inner = self.inner.processing_resources(input);
            self
        }
        /// <p>Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In distributed training, you specify more than one instance.</p>
        pub fn set_processing_resources(
            mut self,
            input: std::option::Option<crate::model::ProcessingResources>,
        ) -> Self {
            self.inner = self.inner.set_processing_resources(input);
            self
        }
        /// <p>The time limit for how long the processing job is allowed to run.</p>
        pub fn stopping_condition(
            mut self,
            input: crate::model::ProcessingStoppingCondition,
        ) -> Self {
            self.inner = self.inner.stopping_condition(input);
            self
        }
        /// <p>The time limit for how long the processing job is allowed to run.</p>
        pub fn set_stopping_condition(
            mut self,
            input: std::option::Option<crate::model::ProcessingStoppingCondition>,
        ) -> Self {
            self.inner = self.inner.set_stopping_condition(input);
            self
        }
        /// <p>Configures the processing job to run a specified Docker container image.</p>
        pub fn app_specification(mut self, input: crate::model::AppSpecification) -> Self {
            self.inner = self.inner.app_specification(input);
            self
        }
        /// <p>Configures the processing job to run a specified Docker container image.</p>
        pub fn set_app_specification(
            mut self,
            input: std::option::Option<crate::model::AppSpecification>,
        ) -> Self {
            self.inner = self.inner.set_app_specification(input);
            self
        }
        /// Adds a key-value pair to `Environment`.
        ///
        /// To override the contents of this collection use [`set_environment`](Self::set_environment).
        ///
        /// <p>The environment variables to set in the Docker container. Up to 100 key and values entries in the map are supported.</p>
        pub fn environment(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.environment(k.into(), v.into());
            self
        }
        /// <p>The environment variables to set in the Docker container. Up to 100 key and values entries in the map are supported.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_environment(input);
            self
        }
        /// <p>Networking options for a processing job, such as whether to allow inbound and outbound network calls to and from processing containers, and the VPC subnets and security groups to use for VPC-enabled processing jobs.</p>
        pub fn network_config(mut self, input: crate::model::NetworkConfig) -> Self {
            self.inner = self.inner.network_config(input);
            self
        }
        /// <p>Networking options for a processing job, such as whether to allow inbound and outbound network calls to and from processing containers, and the VPC subnets and security groups to use for VPC-enabled processing jobs.</p>
        pub fn set_network_config(
            mut self,
            input: std::option::Option<crate::model::NetworkConfig>,
        ) -> Self {
            self.inner = self.inner.set_network_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:</p>
        /// <ul>
        /// <li> <p> <code>CreateProcessingJob</code> </p> </li>
        /// <li> <p> <code>CreateTrainingJob</code> </p> </li>
        /// <li> <p> <code>CreateTransformJob</code> </p> </li>
        /// </ul>
        pub fn experiment_config(mut self, input: crate::model::ExperimentConfig) -> Self {
            self.inner = self.inner.experiment_config(input);
            self
        }
        /// <p>Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:</p>
        /// <ul>
        /// <li> <p> <code>CreateProcessingJob</code> </p> </li>
        /// <li> <p> <code>CreateTrainingJob</code> </p> </li>
        /// <li> <p> <code>CreateTransformJob</code> </p> </li>
        /// </ul>
        pub fn set_experiment_config(
            mut self,
            input: std::option::Option<crate::model::ExperimentConfig>,
        ) -> Self {
            self.inner = self.inner.set_experiment_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProject`.
    ///
    /// <p>Creates a machine learning (ML) project that can contain one or more templates that set up an ML pipeline from training to deploying an approved model.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateProject<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_project_input::Builder,
    }
    impl<C, M, R> CreateProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProjectInputOperationOutputAlias,
                crate::output::CreateProjectOutput,
                crate::error::CreateProjectError,
                crate::input::CreateProjectInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>The name of the project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>A description for the project.</p>
        pub fn project_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_description(input.into());
            self
        }
        /// <p>A description for the project.</p>
        pub fn set_project_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_project_description(input);
            self
        }
        /// <p>The product ID and provisioning artifact ID to provision a service catalog. The provisioning artifact ID will default to the latest provisioning artifact ID of the product, if you don't provide the provisioning artifact ID. For more information, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services Service Catalog</a>.</p>
        pub fn service_catalog_provisioning_details(
            mut self,
            input: crate::model::ServiceCatalogProvisioningDetails,
        ) -> Self {
            self.inner = self.inner.service_catalog_provisioning_details(input);
            self
        }
        /// <p>The product ID and provisioning artifact ID to provision a service catalog. The provisioning artifact ID will default to the latest provisioning artifact ID of the product, if you don't provide the provisioning artifact ID. For more information, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services Service Catalog</a>.</p>
        pub fn set_service_catalog_provisioning_details(
            mut self,
            input: std::option::Option<crate::model::ServiceCatalogProvisioningDetails>,
        ) -> Self {
            self.inner = self.inner.set_service_catalog_provisioning_details(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs that you want to use to organize and track your Amazon Web Services resource costs. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key-value pairs that you want to use to organize and track your Amazon Web Services resource costs. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStudioLifecycleConfig`.
    ///
    /// <p>Creates a new Studio Lifecycle Configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateStudioLifecycleConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_studio_lifecycle_config_input::Builder,
    }
    impl<C, M, R> CreateStudioLifecycleConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateStudioLifecycleConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStudioLifecycleConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStudioLifecycleConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateStudioLifecycleConfigInputOperationOutputAlias,
                crate::output::CreateStudioLifecycleConfigOutput,
                crate::error::CreateStudioLifecycleConfigError,
                crate::input::CreateStudioLifecycleConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Studio Lifecycle Configuration to create.</p>
        pub fn studio_lifecycle_config_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.studio_lifecycle_config_name(input.into());
            self
        }
        /// <p>The name of the Studio Lifecycle Configuration to create.</p>
        pub fn set_studio_lifecycle_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_studio_lifecycle_config_name(input);
            self
        }
        /// <p>The content of your Studio Lifecycle Configuration script. This content must be base64 encoded.</p>
        pub fn studio_lifecycle_config_content(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.studio_lifecycle_config_content(input.into());
            self
        }
        /// <p>The content of your Studio Lifecycle Configuration script. This content must be base64 encoded.</p>
        pub fn set_studio_lifecycle_config_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_studio_lifecycle_config_content(input);
            self
        }
        /// <p>The App type that the Lifecycle Configuration is attached to.</p>
        pub fn studio_lifecycle_config_app_type(
            mut self,
            input: crate::model::StudioLifecycleConfigAppType,
        ) -> Self {
            self.inner = self.inner.studio_lifecycle_config_app_type(input);
            self
        }
        /// <p>The App type that the Lifecycle Configuration is attached to.</p>
        pub fn set_studio_lifecycle_config_app_type(
            mut self,
            input: std::option::Option<crate::model::StudioLifecycleConfigAppType>,
        ) -> Self {
            self.inner = self.inner.set_studio_lifecycle_config_app_type(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the Lifecycle Configuration. Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the Search API. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags to be associated with the Lifecycle Configuration. Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the Search API. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTrainingJob`.
    ///
    /// <p>Starts a model training job. After training completes, Amazon SageMaker saves the resulting model artifacts to an Amazon S3 location that you specify. </p>
    /// <p>If you choose to host your model using Amazon SageMaker hosting services, you can use the resulting model artifacts as part of the model. You can also use the artifacts in a machine learning service other than Amazon SageMaker, provided that you know how to use them for inference. </p>
    /// <p>In the request body, you provide the following: </p>
    /// <ul>
    /// <li> <p> <code>AlgorithmSpecification</code> - Identifies the training algorithm to use. </p> </li>
    /// <li> <p> <code>HyperParameters</code> - Specify these algorithm-specific parameters to enable the estimation of model parameters during training. Hyperparameters can be tuned to optimize this learning process. For a list of hyperparameters for each training algorithm provided by Amazon SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. </p> </li>
    /// <li> <p> <code>InputDataConfig</code> - Describes the training dataset and the Amazon S3, EFS, or FSx location where it is stored.</p> </li>
    /// <li> <p> <code>OutputDataConfig</code> - Identifies the Amazon S3 bucket where you want Amazon SageMaker to save the results of model training. </p> </li>
    /// <li> <p> <code>ResourceConfig</code> - Identifies the resources, ML compute instances, and ML storage volumes to deploy for model training. In distributed training, you specify more than one instance. </p> </li>
    /// <li> <p> <code>EnableManagedSpotTraining</code> - Optimize the cost of training machine learning models by up to 80% by using Amazon EC2 Spot instances. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html">Managed Spot Training</a>. </p> </li>
    /// <li> <p> <code>RoleArn</code> - The Amazon Resource Name (ARN) that Amazon SageMaker assumes to perform tasks on your behalf during model training. You must grant this role the necessary permissions so that Amazon SageMaker can successfully complete model training. </p> </li>
    /// <li> <p> <code>StoppingCondition</code> - To help cap training costs, use <code>MaxRuntimeInSeconds</code> to set a time limit for training. Use <code>MaxWaitTimeInSeconds</code> to specify how long a managed spot training job has to complete. </p> </li>
    /// <li> <p> <code>Environment</code> - The environment variables to set in the Docker container.</p> </li>
    /// <li> <p> <code>RetryStrategy</code> - The number of times to retry the job when the job fails due to an <code>InternalServerError</code>.</p> </li>
    /// </ul>
    /// <p> For more information about Amazon SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html">How It Works</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTrainingJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_training_job_input::Builder,
    }
    impl<C, M, R> CreateTrainingJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTrainingJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTrainingJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTrainingJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTrainingJobInputOperationOutputAlias,
                crate::output::CreateTrainingJobOutput,
                crate::error::CreateTrainingJobError,
                crate::input::CreateTrainingJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the training job. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account. </p>
        pub fn training_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.training_job_name(input.into());
            self
        }
        /// <p>The name of the training job. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account. </p>
        pub fn set_training_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_training_job_name(input);
            self
        }
        /// Adds a key-value pair to `HyperParameters`.
        ///
        /// To override the contents of this collection use [`set_hyper_parameters`](Self::set_hyper_parameters).
        ///
        /// <p>Algorithm-specific parameters that influence the quality of the model. You set hyperparameters before you start the learning process. For a list of hyperparameters for each training algorithm provided by Amazon SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. </p>
        /// <p>You can specify a maximum of 100 hyperparameters. Each hyperparameter is a key-value pair. Each key and value is limited to 256 characters, as specified by the <code>Length Constraint</code>. </p>
        pub fn hyper_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.hyper_parameters(k.into(), v.into());
            self
        }
        /// <p>Algorithm-specific parameters that influence the quality of the model. You set hyperparameters before you start the learning process. For a list of hyperparameters for each training algorithm provided by Amazon SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. </p>
        /// <p>You can specify a maximum of 100 hyperparameters. Each hyperparameter is a key-value pair. Each key and value is limited to 256 characters, as specified by the <code>Length Constraint</code>. </p>
        pub fn set_hyper_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_hyper_parameters(input);
            self
        }
        /// <p>The registry path of the Docker image that contains the training algorithm and algorithm-specific metadata, including the input mode. For more information about algorithms provided by Amazon SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. For information about providing your own algorithms, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon SageMaker</a>. </p>
        pub fn algorithm_specification(
            mut self,
            input: crate::model::AlgorithmSpecification,
        ) -> Self {
            self.inner = self.inner.algorithm_specification(input);
            self
        }
        /// <p>The registry path of the Docker image that contains the training algorithm and algorithm-specific metadata, including the input mode. For more information about algorithms provided by Amazon SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. For information about providing your own algorithms, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon SageMaker</a>. </p>
        pub fn set_algorithm_specification(
            mut self,
            input: std::option::Option<crate::model::AlgorithmSpecification>,
        ) -> Self {
            self.inner = self.inner.set_algorithm_specification(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf. </p>
        /// <p>During model training, Amazon SageMaker needs your permission to read input data from an S3 bucket, download a Docker image that contains training code, write model artifacts to an S3 bucket, write logs to Amazon CloudWatch Logs, and publish metrics to Amazon CloudWatch. You grant permissions for all of these tasks to an IAM role. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles</a>. </p> <note>
        /// <p>To be able to pass this role to Amazon SageMaker, the caller of this API must have the <code>iam:PassRole</code> permission.</p>
        /// </note>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf. </p>
        /// <p>During model training, Amazon SageMaker needs your permission to read input data from an S3 bucket, download a Docker image that contains training code, write model artifacts to an S3 bucket, write logs to Amazon CloudWatch Logs, and publish metrics to Amazon CloudWatch. You grant permissions for all of these tasks to an IAM role. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles</a>. </p> <note>
        /// <p>To be able to pass this role to Amazon SageMaker, the caller of this API must have the <code>iam:PassRole</code> permission.</p>
        /// </note>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Appends an item to `InputDataConfig`.
        ///
        /// To override the contents of this collection use [`set_input_data_config`](Self::set_input_data_config).
        ///
        /// <p>An array of <code>Channel</code> objects. Each channel is a named input source. <code>InputDataConfig</code> describes the input data and its location. </p>
        /// <p>Algorithms can accept input data from one or more channels. For example, an algorithm might have two channels of input data, <code>training_data</code> and <code>validation_data</code>. The configuration for each channel provides the S3, EFS, or FSx location where the input data is stored. It also provides information about the stored data: the MIME type, compression method, and whether the data is wrapped in RecordIO format. </p>
        /// <p>Depending on the input mode that the algorithm supports, Amazon SageMaker either copies input data files from an S3 bucket to a local directory in the Docker container, or makes it available as input streams. For example, if you specify an EFS location, input data files will be made available as input streams. They do not need to be downloaded.</p>
        pub fn input_data_config(mut self, input: crate::model::Channel) -> Self {
            self.inner = self.inner.input_data_config(input);
            self
        }
        /// <p>An array of <code>Channel</code> objects. Each channel is a named input source. <code>InputDataConfig</code> describes the input data and its location. </p>
        /// <p>Algorithms can accept input data from one or more channels. For example, an algorithm might have two channels of input data, <code>training_data</code> and <code>validation_data</code>. The configuration for each channel provides the S3, EFS, or FSx location where the input data is stored. It also provides information about the stored data: the MIME type, compression method, and whether the data is wrapped in RecordIO format. </p>
        /// <p>Depending on the input mode that the algorithm supports, Amazon SageMaker either copies input data files from an S3 bucket to a local directory in the Docker container, or makes it available as input streams. For example, if you specify an EFS location, input data files will be made available as input streams. They do not need to be downloaded.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Channel>>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>Specifies the path to the S3 location where you want to store model artifacts. Amazon SageMaker creates subfolders for the artifacts. </p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.inner = self.inner.output_data_config(input);
            self
        }
        /// <p>Specifies the path to the S3 location where you want to store model artifacts. Amazon SageMaker creates subfolders for the artifacts. </p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_data_config(input);
            self
        }
        /// <p>The resources, including the ML compute instances and ML storage volumes, to use for model training. </p>
        /// <p>ML storage volumes store model artifacts and incremental states. Training algorithms might also use ML storage volumes for scratch space. If you want Amazon SageMaker to use the ML storage volume to store the training data, choose <code>File</code> as the <code>TrainingInputMode</code> in the algorithm specification. For distributed training algorithms, specify an instance count greater than 1.</p>
        pub fn resource_config(mut self, input: crate::model::ResourceConfig) -> Self {
            self.inner = self.inner.resource_config(input);
            self
        }
        /// <p>The resources, including the ML compute instances and ML storage volumes, to use for model training. </p>
        /// <p>ML storage volumes store model artifacts and incremental states. Training algorithms might also use ML storage volumes for scratch space. If you want Amazon SageMaker to use the ML storage volume to store the training data, choose <code>File</code> as the <code>TrainingInputMode</code> in the algorithm specification. For distributed training algorithms, specify an instance count greater than 1.</p>
        pub fn set_resource_config(
            mut self,
            input: std::option::Option<crate::model::ResourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_resource_config(input);
            self
        }
        /// <p>A <code>VpcConfig</code> object that specifies the VPC that you want your training job to connect to. Control access to and from your training container by configuring the VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an Amazon Virtual Private Cloud</a>.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(input);
            self
        }
        /// <p>A <code>VpcConfig</code> object that specifies the VPC that you want your training job to connect to. Control access to and from your training container by configuring the VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an Amazon Virtual Private Cloud</a>.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// <p>Specifies a limit to how long a model training job can run. It also specifies how long a managed Spot training job has to complete. When the job reaches the time limit, Amazon SageMaker ends the training job. Use this API to cap model training costs.</p>
        /// <p>To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost. </p>
        pub fn stopping_condition(mut self, input: crate::model::StoppingCondition) -> Self {
            self.inner = self.inner.stopping_condition(input);
            self
        }
        /// <p>Specifies a limit to how long a model training job can run. It also specifies how long a managed Spot training job has to complete. When the job reaches the time limit, Amazon SageMaker ends the training job. Use this API to cap model training costs.</p>
        /// <p>To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost. </p>
        pub fn set_stopping_condition(
            mut self,
            input: std::option::Option<crate::model::StoppingCondition>,
        ) -> Self {
            self.inner = self.inner.set_stopping_condition(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Isolates the training container. No inbound or outbound network calls can be made, except for calls between peers within a training cluster for distributed training. If you enable network isolation for training jobs that are configured to use a VPC, Amazon SageMaker downloads and uploads customer data and model artifacts through the specified VPC, but the training container does not have network access.</p>
        pub fn enable_network_isolation(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_network_isolation(input);
            self
        }
        /// <p>Isolates the training container. No inbound or outbound network calls can be made, except for calls between peers within a training cluster for distributed training. If you enable network isolation for training jobs that are configured to use a VPC, Amazon SageMaker downloads and uploads customer data and model artifacts through the specified VPC, but the training container does not have network access.</p>
        pub fn set_enable_network_isolation(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_network_isolation(input);
            self
        }
        /// <p>To encrypt all communications between ML compute instances in distributed training, choose <code>True</code>. Encryption provides greater security for distributed training, but training might take longer. How long it takes depends on the amount of communication between compute instances, especially if you use a deep learning algorithm in distributed training. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-encrypt.html">Protect Communications Between ML Compute Instances in a Distributed Training Job</a>.</p>
        pub fn enable_inter_container_traffic_encryption(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_inter_container_traffic_encryption(input);
            self
        }
        /// <p>To encrypt all communications between ML compute instances in distributed training, choose <code>True</code>. Encryption provides greater security for distributed training, but training might take longer. How long it takes depends on the amount of communication between compute instances, especially if you use a deep learning algorithm in distributed training. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-encrypt.html">Protect Communications Between ML Compute Instances in a Distributed Training Job</a>.</p>
        pub fn set_enable_inter_container_traffic_encryption(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self
                .inner
                .set_enable_inter_container_traffic_encryption(input);
            self
        }
        /// <p>To train models using managed spot training, choose <code>True</code>. Managed spot training provides a fully managed and scalable infrastructure for training machine learning models. this option is useful when training jobs can be interrupted and when there is flexibility when the training job is run. </p>
        /// <p>The complete and intermediate results of jobs are stored in an Amazon S3 bucket, and can be used as a starting point to train models incrementally. Amazon SageMaker provides metrics and logs in CloudWatch. They can be used to see when managed spot training jobs are running, interrupted, resumed, or completed. </p>
        pub fn enable_managed_spot_training(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_managed_spot_training(input);
            self
        }
        /// <p>To train models using managed spot training, choose <code>True</code>. Managed spot training provides a fully managed and scalable infrastructure for training machine learning models. this option is useful when training jobs can be interrupted and when there is flexibility when the training job is run. </p>
        /// <p>The complete and intermediate results of jobs are stored in an Amazon S3 bucket, and can be used as a starting point to train models incrementally. Amazon SageMaker provides metrics and logs in CloudWatch. They can be used to see when managed spot training jobs are running, interrupted, resumed, or completed. </p>
        pub fn set_enable_managed_spot_training(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_managed_spot_training(input);
            self
        }
        /// <p>Contains information about the output location for managed spot training checkpoint data.</p>
        pub fn checkpoint_config(mut self, input: crate::model::CheckpointConfig) -> Self {
            self.inner = self.inner.checkpoint_config(input);
            self
        }
        /// <p>Contains information about the output location for managed spot training checkpoint data.</p>
        pub fn set_checkpoint_config(
            mut self,
            input: std::option::Option<crate::model::CheckpointConfig>,
        ) -> Self {
            self.inner = self.inner.set_checkpoint_config(input);
            self
        }
        /// <p>Configuration information for the Debugger hook parameters, metric and tensor collections, and storage paths. To learn more about how to configure the <code>DebugHookConfig</code> parameter, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html">Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job</a>.</p>
        pub fn debug_hook_config(mut self, input: crate::model::DebugHookConfig) -> Self {
            self.inner = self.inner.debug_hook_config(input);
            self
        }
        /// <p>Configuration information for the Debugger hook parameters, metric and tensor collections, and storage paths. To learn more about how to configure the <code>DebugHookConfig</code> parameter, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html">Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job</a>.</p>
        pub fn set_debug_hook_config(
            mut self,
            input: std::option::Option<crate::model::DebugHookConfig>,
        ) -> Self {
            self.inner = self.inner.set_debug_hook_config(input);
            self
        }
        /// Appends an item to `DebugRuleConfigurations`.
        ///
        /// To override the contents of this collection use [`set_debug_rule_configurations`](Self::set_debug_rule_configurations).
        ///
        /// <p>Configuration information for Debugger rules for debugging output tensors.</p>
        pub fn debug_rule_configurations(
            mut self,
            input: crate::model::DebugRuleConfiguration,
        ) -> Self {
            self.inner = self.inner.debug_rule_configurations(input);
            self
        }
        /// <p>Configuration information for Debugger rules for debugging output tensors.</p>
        pub fn set_debug_rule_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DebugRuleConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_debug_rule_configurations(input);
            self
        }
        /// <p>Configuration of storage locations for the Debugger TensorBoard output data.</p>
        pub fn tensor_board_output_config(
            mut self,
            input: crate::model::TensorBoardOutputConfig,
        ) -> Self {
            self.inner = self.inner.tensor_board_output_config(input);
            self
        }
        /// <p>Configuration of storage locations for the Debugger TensorBoard output data.</p>
        pub fn set_tensor_board_output_config(
            mut self,
            input: std::option::Option<crate::model::TensorBoardOutputConfig>,
        ) -> Self {
            self.inner = self.inner.set_tensor_board_output_config(input);
            self
        }
        /// <p>Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:</p>
        /// <ul>
        /// <li> <p> <code>CreateProcessingJob</code> </p> </li>
        /// <li> <p> <code>CreateTrainingJob</code> </p> </li>
        /// <li> <p> <code>CreateTransformJob</code> </p> </li>
        /// </ul>
        pub fn experiment_config(mut self, input: crate::model::ExperimentConfig) -> Self {
            self.inner = self.inner.experiment_config(input);
            self
        }
        /// <p>Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:</p>
        /// <ul>
        /// <li> <p> <code>CreateProcessingJob</code> </p> </li>
        /// <li> <p> <code>CreateTrainingJob</code> </p> </li>
        /// <li> <p> <code>CreateTransformJob</code> </p> </li>
        /// </ul>
        pub fn set_experiment_config(
            mut self,
            input: std::option::Option<crate::model::ExperimentConfig>,
        ) -> Self {
            self.inner = self.inner.set_experiment_config(input);
            self
        }
        /// <p>Configuration information for Debugger system monitoring, framework profiling, and storage paths.</p>
        pub fn profiler_config(mut self, input: crate::model::ProfilerConfig) -> Self {
            self.inner = self.inner.profiler_config(input);
            self
        }
        /// <p>Configuration information for Debugger system monitoring, framework profiling, and storage paths.</p>
        pub fn set_profiler_config(
            mut self,
            input: std::option::Option<crate::model::ProfilerConfig>,
        ) -> Self {
            self.inner = self.inner.set_profiler_config(input);
            self
        }
        /// Appends an item to `ProfilerRuleConfigurations`.
        ///
        /// To override the contents of this collection use [`set_profiler_rule_configurations`](Self::set_profiler_rule_configurations).
        ///
        /// <p>Configuration information for Debugger rules for profiling system and framework metrics.</p>
        pub fn profiler_rule_configurations(
            mut self,
            input: crate::model::ProfilerRuleConfiguration,
        ) -> Self {
            self.inner = self.inner.profiler_rule_configurations(input);
            self
        }
        /// <p>Configuration information for Debugger rules for profiling system and framework metrics.</p>
        pub fn set_profiler_rule_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProfilerRuleConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_profiler_rule_configurations(input);
            self
        }
        /// Adds a key-value pair to `Environment`.
        ///
        /// To override the contents of this collection use [`set_environment`](Self::set_environment).
        ///
        /// <p>The environment variables to set in the Docker container.</p>
        pub fn environment(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.environment(k.into(), v.into());
            self
        }
        /// <p>The environment variables to set in the Docker container.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_environment(input);
            self
        }
        /// <p>The number of times to retry the job when the job fails due to an <code>InternalServerError</code>.</p>
        pub fn retry_strategy(mut self, input: crate::model::RetryStrategy) -> Self {
            self.inner = self.inner.retry_strategy(input);
            self
        }
        /// <p>The number of times to retry the job when the job fails due to an <code>InternalServerError</code>.</p>
        pub fn set_retry_strategy(
            mut self,
            input: std::option::Option<crate::model::RetryStrategy>,
        ) -> Self {
            self.inner = self.inner.set_retry_strategy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTransformJob`.
    ///
    /// <p>Starts a transform job. A transform job uses a trained model to get inferences on a dataset and saves these results to an Amazon S3 location that you specify.</p>
    /// <p>To perform batch transformations, you create a transform job and use the data that you have readily available.</p>
    /// <p>In the request body, you provide the following:</p>
    /// <ul>
    /// <li> <p> <code>TransformJobName</code> - Identifies the transform job. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account.</p> </li>
    /// <li> <p> <code>ModelName</code> - Identifies the model to use. <code>ModelName</code> must be the name of an existing Amazon SageMaker model in the same Amazon Web Services Region and Amazon Web Services account. For information on creating a model, see <code>CreateModel</code>.</p> </li>
    /// <li> <p> <code>TransformInput</code> - Describes the dataset to be transformed and the Amazon S3 location where it is stored.</p> </li>
    /// <li> <p> <code>TransformOutput</code> - Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job.</p> </li>
    /// <li> <p> <code>TransformResources</code> - Identifies the ML compute instances for the transform job.</p> </li>
    /// </ul>
    /// <p>For more information about how batch transformation works, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html">Batch Transform</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTransformJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_transform_job_input::Builder,
    }
    impl<C, M, R> CreateTransformJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTransformJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTransformJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTransformJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTransformJobInputOperationOutputAlias,
                crate::output::CreateTransformJobOutput,
                crate::error::CreateTransformJobError,
                crate::input::CreateTransformJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the transform job. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account. </p>
        pub fn transform_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transform_job_name(input.into());
            self
        }
        /// <p>The name of the transform job. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account. </p>
        pub fn set_transform_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transform_job_name(input);
            self
        }
        /// <p>The name of the model that you want to use for the transform job. <code>ModelName</code> must be the name of an existing Amazon SageMaker model within an Amazon Web Services Region in an Amazon Web Services account.</p>
        pub fn model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_name(input.into());
            self
        }
        /// <p>The name of the model that you want to use for the transform job. <code>ModelName</code> must be the name of an existing Amazon SageMaker model within an Amazon Web Services Region in an Amazon Web Services account.</p>
        pub fn set_model_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_name(input);
            self
        }
        /// <p>The maximum number of parallel requests that can be sent to each instance in a transform job. If <code>MaxConcurrentTransforms</code> is set to <code>0</code> or left unset, Amazon SageMaker checks the optional execution-parameters to determine the settings for your chosen algorithm. If the execution-parameters endpoint is not enabled, the default value is <code>1</code>. For more information on execution-parameters, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-batch-code.html#your-algorithms-batch-code-how-containe-serves-requests">How Containers Serve Requests</a>. For built-in algorithms, you don't need to set a value for <code>MaxConcurrentTransforms</code>.</p>
        pub fn max_concurrent_transforms(mut self, input: i32) -> Self {
            self.inner = self.inner.max_concurrent_transforms(input);
            self
        }
        /// <p>The maximum number of parallel requests that can be sent to each instance in a transform job. If <code>MaxConcurrentTransforms</code> is set to <code>0</code> or left unset, Amazon SageMaker checks the optional execution-parameters to determine the settings for your chosen algorithm. If the execution-parameters endpoint is not enabled, the default value is <code>1</code>. For more information on execution-parameters, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-batch-code.html#your-algorithms-batch-code-how-containe-serves-requests">How Containers Serve Requests</a>. For built-in algorithms, you don't need to set a value for <code>MaxConcurrentTransforms</code>.</p>
        pub fn set_max_concurrent_transforms(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_concurrent_transforms(input);
            self
        }
        /// <p>Configures the timeout and maximum number of retries for processing a transform job invocation.</p>
        pub fn model_client_config(mut self, input: crate::model::ModelClientConfig) -> Self {
            self.inner = self.inner.model_client_config(input);
            self
        }
        /// <p>Configures the timeout and maximum number of retries for processing a transform job invocation.</p>
        pub fn set_model_client_config(
            mut self,
            input: std::option::Option<crate::model::ModelClientConfig>,
        ) -> Self {
            self.inner = self.inner.set_model_client_config(input);
            self
        }
        /// <p>The maximum allowed size of the payload, in MB. A <i>payload</i> is the data portion of a record (without metadata). The value in <code>MaxPayloadInMB</code> must be greater than, or equal to, the size of a single record. To estimate the size of a record in MB, divide the size of your dataset by the number of records. To ensure that the records fit within the maximum payload size, we recommend using a slightly larger value. The default value is <code>6</code> MB. </p>
        /// <p>For cases where the payload might be arbitrarily large and is transmitted using HTTP chunked encoding, set the value to <code>0</code>. This feature works only in supported algorithms. Currently, Amazon SageMaker built-in algorithms do not support HTTP chunked encoding.</p>
        pub fn max_payload_in_mb(mut self, input: i32) -> Self {
            self.inner = self.inner.max_payload_in_mb(input);
            self
        }
        /// <p>The maximum allowed size of the payload, in MB. A <i>payload</i> is the data portion of a record (without metadata). The value in <code>MaxPayloadInMB</code> must be greater than, or equal to, the size of a single record. To estimate the size of a record in MB, divide the size of your dataset by the number of records. To ensure that the records fit within the maximum payload size, we recommend using a slightly larger value. The default value is <code>6</code> MB. </p>
        /// <p>For cases where the payload might be arbitrarily large and is transmitted using HTTP chunked encoding, set the value to <code>0</code>. This feature works only in supported algorithms. Currently, Amazon SageMaker built-in algorithms do not support HTTP chunked encoding.</p>
        pub fn set_max_payload_in_mb(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_payload_in_mb(input);
            self
        }
        /// <p>Specifies the number of records to include in a mini-batch for an HTTP inference request. A <i>record</i> <i></i> is a single unit of input data that inference can be made on. For example, a single line in a CSV file is a record. </p>
        /// <p>To enable the batch strategy, you must set the <code>SplitType</code> property to <code>Line</code>, <code>RecordIO</code>, or <code>TFRecord</code>.</p>
        /// <p>To use only one record when making an HTTP invocation request to a container, set <code>BatchStrategy</code> to <code>SingleRecord</code> and <code>SplitType</code> to <code>Line</code>.</p>
        /// <p>To fit as many records in a mini-batch as can fit within the <code>MaxPayloadInMB</code> limit, set <code>BatchStrategy</code> to <code>MultiRecord</code> and <code>SplitType</code> to <code>Line</code>.</p>
        pub fn batch_strategy(mut self, input: crate::model::BatchStrategy) -> Self {
            self.inner = self.inner.batch_strategy(input);
            self
        }
        /// <p>Specifies the number of records to include in a mini-batch for an HTTP inference request. A <i>record</i> <i></i> is a single unit of input data that inference can be made on. For example, a single line in a CSV file is a record. </p>
        /// <p>To enable the batch strategy, you must set the <code>SplitType</code> property to <code>Line</code>, <code>RecordIO</code>, or <code>TFRecord</code>.</p>
        /// <p>To use only one record when making an HTTP invocation request to a container, set <code>BatchStrategy</code> to <code>SingleRecord</code> and <code>SplitType</code> to <code>Line</code>.</p>
        /// <p>To fit as many records in a mini-batch as can fit within the <code>MaxPayloadInMB</code> limit, set <code>BatchStrategy</code> to <code>MultiRecord</code> and <code>SplitType</code> to <code>Line</code>.</p>
        pub fn set_batch_strategy(
            mut self,
            input: std::option::Option<crate::model::BatchStrategy>,
        ) -> Self {
            self.inner = self.inner.set_batch_strategy(input);
            self
        }
        /// Adds a key-value pair to `Environment`.
        ///
        /// To override the contents of this collection use [`set_environment`](Self::set_environment).
        ///
        /// <p>The environment variables to set in the Docker container. We support up to 16 key and values entries in the map.</p>
        pub fn environment(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.environment(k.into(), v.into());
            self
        }
        /// <p>The environment variables to set in the Docker container. We support up to 16 key and values entries in the map.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_environment(input);
            self
        }
        /// <p>Describes the input source and the way the transform job consumes it.</p>
        pub fn transform_input(mut self, input: crate::model::TransformInput) -> Self {
            self.inner = self.inner.transform_input(input);
            self
        }
        /// <p>Describes the input source and the way the transform job consumes it.</p>
        pub fn set_transform_input(
            mut self,
            input: std::option::Option<crate::model::TransformInput>,
        ) -> Self {
            self.inner = self.inner.set_transform_input(input);
            self
        }
        /// <p>Describes the results of the transform job.</p>
        pub fn transform_output(mut self, input: crate::model::TransformOutput) -> Self {
            self.inner = self.inner.transform_output(input);
            self
        }
        /// <p>Describes the results of the transform job.</p>
        pub fn set_transform_output(
            mut self,
            input: std::option::Option<crate::model::TransformOutput>,
        ) -> Self {
            self.inner = self.inner.set_transform_output(input);
            self
        }
        /// <p>Describes the resources, including ML instance types and ML instance count, to use for the transform job.</p>
        pub fn transform_resources(mut self, input: crate::model::TransformResources) -> Self {
            self.inner = self.inner.transform_resources(input);
            self
        }
        /// <p>Describes the resources, including ML instance types and ML instance count, to use for the transform job.</p>
        pub fn set_transform_resources(
            mut self,
            input: std::option::Option<crate::model::TransformResources>,
        ) -> Self {
            self.inner = self.inner.set_transform_resources(input);
            self
        }
        /// <p>The data structure used to specify the data to be used for inference in a batch transform job and to associate the data that is relevant to the prediction results in the output. The input filter provided allows you to exclude input data that is not needed for inference in a batch transform job. The output filter provided allows you to include input data relevant to interpreting the predictions in the output from the job. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html">Associate Prediction Results with their Corresponding Input Records</a>.</p>
        pub fn data_processing(mut self, input: crate::model::DataProcessing) -> Self {
            self.inner = self.inner.data_processing(input);
            self
        }
        /// <p>The data structure used to specify the data to be used for inference in a batch transform job and to associate the data that is relevant to the prediction results in the output. The input filter provided allows you to exclude input data that is not needed for inference in a batch transform job. The output filter provided allows you to include input data relevant to interpreting the predictions in the output from the job. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html">Associate Prediction Results with their Corresponding Input Records</a>.</p>
        pub fn set_data_processing(
            mut self,
            input: std::option::Option<crate::model::DataProcessing>,
        ) -> Self {
            self.inner = self.inner.set_data_processing(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:</p>
        /// <ul>
        /// <li> <p> <code>CreateProcessingJob</code> </p> </li>
        /// <li> <p> <code>CreateTrainingJob</code> </p> </li>
        /// <li> <p> <code>CreateTransformJob</code> </p> </li>
        /// </ul>
        pub fn experiment_config(mut self, input: crate::model::ExperimentConfig) -> Self {
            self.inner = self.inner.experiment_config(input);
            self
        }
        /// <p>Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:</p>
        /// <ul>
        /// <li> <p> <code>CreateProcessingJob</code> </p> </li>
        /// <li> <p> <code>CreateTrainingJob</code> </p> </li>
        /// <li> <p> <code>CreateTransformJob</code> </p> </li>
        /// </ul>
        pub fn set_experiment_config(
            mut self,
            input: std::option::Option<crate::model::ExperimentConfig>,
        ) -> Self {
            self.inner = self.inner.set_experiment_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTrial`.
    ///
    /// <p>Creates an SageMaker <i>trial</i>. A trial is a set of steps called <i>trial components</i> that produce a machine learning model. A trial is part of a single SageMaker <i>experiment</i>.</p>
    /// <p>When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must use the logging APIs provided by the SDK.</p>
    /// <p>You can add tags to a trial and then use the <code>Search</code> API to search for the tags.</p>
    /// <p>To get a list of all your trials, call the <code>ListTrials</code> API. To view a trial's properties, call the <code>DescribeTrial</code> API. To create a trial component, call the <code>CreateTrialComponent</code> API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTrial<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_trial_input::Builder,
    }
    impl<C, M, R> CreateTrial<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTrial`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTrialOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTrialError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTrialInputOperationOutputAlias,
                crate::output::CreateTrialOutput,
                crate::error::CreateTrialError,
                crate::input::CreateTrialInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the trial. The name must be unique in your Amazon Web Services account and is not case-sensitive.</p>
        pub fn trial_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trial_name(input.into());
            self
        }
        /// <p>The name of the trial. The name must be unique in your Amazon Web Services account and is not case-sensitive.</p>
        pub fn set_trial_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_trial_name(input);
            self
        }
        /// <p>The name of the trial as displayed. The name doesn't need to be unique. If <code>DisplayName</code> isn't specified, <code>TrialName</code> is displayed.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The name of the trial as displayed. The name doesn't need to be unique. If <code>DisplayName</code> isn't specified, <code>TrialName</code> is displayed.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The name of the experiment to associate the trial with.</p>
        pub fn experiment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.experiment_name(input.into());
            self
        }
        /// <p>The name of the experiment to associate the trial with.</p>
        pub fn set_experiment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_experiment_name(input);
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn metadata_properties(mut self, input: crate::model::MetadataProperties) -> Self {
            self.inner = self.inner.metadata_properties(input);
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn set_metadata_properties(
            mut self,
            input: std::option::Option<crate::model::MetadataProperties>,
        ) -> Self {
            self.inner = self.inner.set_metadata_properties(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to associate with the trial. You can use <code>Search</code> API to search on the tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to associate with the trial. You can use <code>Search</code> API to search on the tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTrialComponent`.
    ///
    /// <p>Creates a <i>trial component</i>, which is a stage of a machine learning <i>trial</i>. A trial is composed of one or more trial components. A trial component can be used in multiple trials.</p>
    /// <p>Trial components include pre-processing jobs, training jobs, and batch transform jobs.</p>
    /// <p>When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must use the logging APIs provided by the SDK.</p>
    /// <p>You can add tags to a trial component and then use the <code>Search</code> API to search for the tags.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTrialComponent<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_trial_component_input::Builder,
    }
    impl<C, M, R> CreateTrialComponent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTrialComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTrialComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTrialComponentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTrialComponentInputOperationOutputAlias,
                crate::output::CreateTrialComponentOutput,
                crate::error::CreateTrialComponentError,
                crate::input::CreateTrialComponentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the component. The name must be unique in your Amazon Web Services account and is not case-sensitive.</p>
        pub fn trial_component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trial_component_name(input.into());
            self
        }
        /// <p>The name of the component. The name must be unique in your Amazon Web Services account and is not case-sensitive.</p>
        pub fn set_trial_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_trial_component_name(input);
            self
        }
        /// <p>The name of the component as displayed. The name doesn't need to be unique. If <code>DisplayName</code> isn't specified, <code>TrialComponentName</code> is displayed.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The name of the component as displayed. The name doesn't need to be unique. If <code>DisplayName</code> isn't specified, <code>TrialComponentName</code> is displayed.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The status of the component. States include:</p>
        /// <ul>
        /// <li> <p>InProgress</p> </li>
        /// <li> <p>Completed</p> </li>
        /// <li> <p>Failed</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::TrialComponentStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The status of the component. States include:</p>
        /// <ul>
        /// <li> <p>InProgress</p> </li>
        /// <li> <p>Completed</p> </li>
        /// <li> <p>Failed</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TrialComponentStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>When the component started.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>When the component started.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>When the component ended.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>When the component ended.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// Adds a key-value pair to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The hyperparameters for the component.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::TrialComponentParameterValue,
        ) -> Self {
            self.inner = self.inner.parameters(k.into(), v);
            self
        }
        /// <p>The hyperparameters for the component.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::TrialComponentParameterValue,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// Adds a key-value pair to `InputArtifacts`.
        ///
        /// To override the contents of this collection use [`set_input_artifacts`](Self::set_input_artifacts).
        ///
        /// <p>The input artifacts for the component. Examples of input artifacts are datasets, algorithms, hyperparameters, source code, and instance types.</p>
        pub fn input_artifacts(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::TrialComponentArtifact,
        ) -> Self {
            self.inner = self.inner.input_artifacts(k.into(), v);
            self
        }
        /// <p>The input artifacts for the component. Examples of input artifacts are datasets, algorithms, hyperparameters, source code, and instance types.</p>
        pub fn set_input_artifacts(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::TrialComponentArtifact,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_input_artifacts(input);
            self
        }
        /// Adds a key-value pair to `OutputArtifacts`.
        ///
        /// To override the contents of this collection use [`set_output_artifacts`](Self::set_output_artifacts).
        ///
        /// <p>The output artifacts for the component. Examples of output artifacts are metrics, snapshots, logs, and images.</p>
        pub fn output_artifacts(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::TrialComponentArtifact,
        ) -> Self {
            self.inner = self.inner.output_artifacts(k.into(), v);
            self
        }
        /// <p>The output artifacts for the component. Examples of output artifacts are metrics, snapshots, logs, and images.</p>
        pub fn set_output_artifacts(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::TrialComponentArtifact,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_output_artifacts(input);
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn metadata_properties(mut self, input: crate::model::MetadataProperties) -> Self {
            self.inner = self.inner.metadata_properties(input);
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn set_metadata_properties(
            mut self,
            input: std::option::Option<crate::model::MetadataProperties>,
        ) -> Self {
            self.inner = self.inner.set_metadata_properties(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to associate with the component. You can use <code>Search</code> API to search on the tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to associate with the component. You can use <code>Search</code> API to search on the tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUserProfile`.
    ///
    /// <p>Creates a user profile. A user profile represents a single user within a domain, and is the main way to reference a "person" for the purposes of sharing, reporting, and other user-oriented features. This entity is created when a user onboards to Amazon SageMaker Studio. If an administrator invites a person by email or imports them from SSO, a user profile is automatically created. A user profile is the primary holder of settings for an individual user and has a reference to the user's private Amazon Elastic File System (EFS) home directory. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateUserProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_user_profile_input::Builder,
    }
    impl<C, M, R> CreateUserProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUserProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUserProfileInputOperationOutputAlias,
                crate::output::CreateUserProfileOutput,
                crate::error::CreateUserProfileError,
                crate::input::CreateUserProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the associated Domain.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(input.into());
            self
        }
        /// <p>The ID of the associated Domain.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>A name for the UserProfile. This value is not case sensitive.</p>
        pub fn user_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_profile_name(input.into());
            self
        }
        /// <p>A name for the UserProfile. This value is not case sensitive.</p>
        pub fn set_user_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_user_profile_name(input);
            self
        }
        /// <p>A specifier for the type of value specified in SingleSignOnUserValue. Currently, the only supported value is "UserName". If the Domain's AuthMode is SSO, this field is required. If the Domain's AuthMode is not SSO, this field cannot be specified. </p>
        pub fn single_sign_on_user_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.single_sign_on_user_identifier(input.into());
            self
        }
        /// <p>A specifier for the type of value specified in SingleSignOnUserValue. Currently, the only supported value is "UserName". If the Domain's AuthMode is SSO, this field is required. If the Domain's AuthMode is not SSO, this field cannot be specified. </p>
        pub fn set_single_sign_on_user_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_single_sign_on_user_identifier(input);
            self
        }
        /// <p>The username of the associated Amazon Web Services Single Sign-On User for this UserProfile. If the Domain's AuthMode is SSO, this field is required, and must match a valid username of a user in your directory. If the Domain's AuthMode is not SSO, this field cannot be specified. </p>
        pub fn single_sign_on_user_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.single_sign_on_user_value(input.into());
            self
        }
        /// <p>The username of the associated Amazon Web Services Single Sign-On User for this UserProfile. If the Domain's AuthMode is SSO, this field is required, and must match a valid username of a user in your directory. If the Domain's AuthMode is not SSO, this field cannot be specified. </p>
        pub fn set_single_sign_on_user_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_single_sign_on_user_value(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Each tag consists of a key and an optional value. Tag keys must be unique per resource.</p>
        /// <p>Tags that you specify for the User Profile are also added to all Apps that the User Profile launches.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Each tag consists of a key and an optional value. Tag keys must be unique per resource.</p>
        /// <p>Tags that you specify for the User Profile are also added to all Apps that the User Profile launches.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A collection of settings.</p>
        pub fn user_settings(mut self, input: crate::model::UserSettings) -> Self {
            self.inner = self.inner.user_settings(input);
            self
        }
        /// <p>A collection of settings.</p>
        pub fn set_user_settings(
            mut self,
            input: std::option::Option<crate::model::UserSettings>,
        ) -> Self {
            self.inner = self.inner.set_user_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWorkforce`.
    ///
    /// <p>Use this operation to create a workforce. This operation will return an error if a workforce already exists in the Amazon Web Services Region that you specify. You can only create one workforce in each Amazon Web Services Region per Amazon Web Services account.</p>
    /// <p>If you want to create a new workforce in an Amazon Web Services Region where a workforce already exists, use the API operation to delete the existing workforce and then use <code>CreateWorkforce</code> to create a new workforce.</p>
    /// <p>To create a private workforce using Amazon Cognito, you must specify a Cognito user pool in <code>CognitoConfig</code>. You can also create an Amazon Cognito workforce using the Amazon SageMaker console. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html"> Create a Private Workforce (Amazon Cognito)</a>.</p>
    /// <p>To create a private workforce using your own OIDC Identity Provider (IdP), specify your IdP configuration in <code>OidcConfig</code>. Your OIDC IdP must support <i>groups</i> because groups are used by Ground Truth and Amazon A2I to create work teams. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private-oidc.html"> Create a Private Workforce (OIDC IdP)</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWorkforce<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_workforce_input::Builder,
    }
    impl<C, M, R> CreateWorkforce<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWorkforce`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWorkforceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWorkforceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWorkforceInputOperationOutputAlias,
                crate::output::CreateWorkforceOutput,
                crate::error::CreateWorkforceError,
                crate::input::CreateWorkforceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use this parameter to configure an Amazon Cognito private workforce. A single Cognito workforce is created using and corresponds to a single <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"> Amazon Cognito user pool</a>.</p>
        /// <p>Do not use <code>OidcConfig</code> if you specify values for <code>CognitoConfig</code>.</p>
        pub fn cognito_config(mut self, input: crate::model::CognitoConfig) -> Self {
            self.inner = self.inner.cognito_config(input);
            self
        }
        /// <p>Use this parameter to configure an Amazon Cognito private workforce. A single Cognito workforce is created using and corresponds to a single <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"> Amazon Cognito user pool</a>.</p>
        /// <p>Do not use <code>OidcConfig</code> if you specify values for <code>CognitoConfig</code>.</p>
        pub fn set_cognito_config(
            mut self,
            input: std::option::Option<crate::model::CognitoConfig>,
        ) -> Self {
            self.inner = self.inner.set_cognito_config(input);
            self
        }
        /// <p>Use this parameter to configure a private workforce using your own OIDC Identity Provider.</p>
        /// <p>Do not use <code>CognitoConfig</code> if you specify values for <code>OidcConfig</code>.</p>
        pub fn oidc_config(mut self, input: crate::model::OidcConfig) -> Self {
            self.inner = self.inner.oidc_config(input);
            self
        }
        /// <p>Use this parameter to configure a private workforce using your own OIDC Identity Provider.</p>
        /// <p>Do not use <code>CognitoConfig</code> if you specify values for <code>OidcConfig</code>.</p>
        pub fn set_oidc_config(
            mut self,
            input: std::option::Option<crate::model::OidcConfig>,
        ) -> Self {
            self.inner = self.inner.set_oidc_config(input);
            self
        }
        /// <p>A list of IP address ranges (<a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>). Used to create an allow list of IP addresses for a private workforce. Workers will only be able to login to their worker portal from an IP address within this range. By default, a workforce isn't restricted to specific IP addresses.</p>
        pub fn source_ip_config(mut self, input: crate::model::SourceIpConfig) -> Self {
            self.inner = self.inner.source_ip_config(input);
            self
        }
        /// <p>A list of IP address ranges (<a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>). Used to create an allow list of IP addresses for a private workforce. Workers will only be able to login to their worker portal from an IP address within this range. By default, a workforce isn't restricted to specific IP addresses.</p>
        pub fn set_source_ip_config(
            mut self,
            input: std::option::Option<crate::model::SourceIpConfig>,
        ) -> Self {
            self.inner = self.inner.set_source_ip_config(input);
            self
        }
        /// <p>The name of the private workforce.</p>
        pub fn workforce_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workforce_name(input.into());
            self
        }
        /// <p>The name of the private workforce.</p>
        pub fn set_workforce_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_workforce_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs that contain metadata to help you categorize and organize our workforce. Each tag consists of a key and a value, both of which you define.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key-value pairs that contain metadata to help you categorize and organize our workforce. Each tag consists of a key and a value, both of which you define.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWorkteam`.
    ///
    /// <p>Creates a new work team for labeling your data. A work team is defined by one or more Amazon Cognito user pools. You must first create the user pools before you can create a work team.</p>
    /// <p>You cannot create more than 25 work teams in an account and region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWorkteam<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_workteam_input::Builder,
    }
    impl<C, M, R> CreateWorkteam<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWorkteam`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWorkteamOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWorkteamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWorkteamInputOperationOutputAlias,
                crate::output::CreateWorkteamOutput,
                crate::error::CreateWorkteamError,
                crate::input::CreateWorkteamInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the work team. Use this name to identify the work team.</p>
        pub fn workteam_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workteam_name(input.into());
            self
        }
        /// <p>The name of the work team. Use this name to identify the work team.</p>
        pub fn set_workteam_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_workteam_name(input);
            self
        }
        /// <p>The name of the workforce.</p>
        pub fn workforce_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workforce_name(input.into());
            self
        }
        /// <p>The name of the workforce.</p>
        pub fn set_workforce_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_workforce_name(input);
            self
        }
        /// Appends an item to `MemberDefinitions`.
        ///
        /// To override the contents of this collection use [`set_member_definitions`](Self::set_member_definitions).
        ///
        /// <p>A list of <code>MemberDefinition</code> objects that contains objects that identify the workers that make up the work team. </p>
        /// <p>Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use <code>CognitoMemberDefinition</code>. For workforces created using your own OIDC identity provider (IdP) use <code>OidcMemberDefinition</code>. Do not provide input for both of these parameters in a single request.</p>
        /// <p>For workforces created using Amazon Cognito, private work teams correspond to Amazon Cognito <i>user groups</i> within the user pool used to create a workforce. All of the <code>CognitoMemberDefinition</code> objects that make up the member definition must have the same <code>ClientId</code> and <code>UserPool</code> values. To add a Amazon Cognito user group to an existing worker pool, see <code>Adding groups to a User Pool</code>. For more information about user pools, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">Amazon Cognito User Pools</a>.</p>
        /// <p>For workforces created using your own OIDC IdP, specify the user groups that you want to include in your private work team in <code>OidcMemberDefinition</code> by listing those groups in <code>Groups</code>.</p>
        pub fn member_definitions(mut self, input: crate::model::MemberDefinition) -> Self {
            self.inner = self.inner.member_definitions(input);
            self
        }
        /// <p>A list of <code>MemberDefinition</code> objects that contains objects that identify the workers that make up the work team. </p>
        /// <p>Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use <code>CognitoMemberDefinition</code>. For workforces created using your own OIDC identity provider (IdP) use <code>OidcMemberDefinition</code>. Do not provide input for both of these parameters in a single request.</p>
        /// <p>For workforces created using Amazon Cognito, private work teams correspond to Amazon Cognito <i>user groups</i> within the user pool used to create a workforce. All of the <code>CognitoMemberDefinition</code> objects that make up the member definition must have the same <code>ClientId</code> and <code>UserPool</code> values. To add a Amazon Cognito user group to an existing worker pool, see <code>Adding groups to a User Pool</code>. For more information about user pools, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">Amazon Cognito User Pools</a>.</p>
        /// <p>For workforces created using your own OIDC IdP, specify the user groups that you want to include in your private work team in <code>OidcMemberDefinition</code> by listing those groups in <code>Groups</code>.</p>
        pub fn set_member_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MemberDefinition>>,
        ) -> Self {
            self.inner = self.inner.set_member_definitions(input);
            self
        }
        /// <p>A description of the work team.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the work team.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Configures notification of workers regarding available or expiring work items.</p>
        pub fn notification_configuration(
            mut self,
            input: crate::model::NotificationConfiguration,
        ) -> Self {
            self.inner = self.inner.notification_configuration(input);
            self
        }
        /// <p>Configures notification of workers regarding available or expiring work items.</p>
        pub fn set_notification_configuration(
            mut self,
            input: std::option::Option<crate::model::NotificationConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_notification_configuration(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Resource Tag</a> and <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> in the <i> Amazon Web Services Billing and Cost Management User Guide</i>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An array of key-value pairs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Resource Tag</a> and <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> in the <i> Amazon Web Services Billing and Cost Management User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAction`.
    ///
    /// <p>Deletes an action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_action_input::Builder,
    }
    impl<C, M, R> DeleteAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteActionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteActionInputOperationOutputAlias,
                crate::output::DeleteActionOutput,
                crate::error::DeleteActionError,
                crate::input::DeleteActionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the action to delete.</p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_name(input.into());
            self
        }
        /// <p>The name of the action to delete.</p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAlgorithm`.
    ///
    /// <p>Removes the specified algorithm from your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAlgorithm<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_algorithm_input::Builder,
    }
    impl<C, M, R> DeleteAlgorithm<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAlgorithm`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAlgorithmOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAlgorithmError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAlgorithmInputOperationOutputAlias,
                crate::output::DeleteAlgorithmOutput,
                crate::error::DeleteAlgorithmError,
                crate::input::DeleteAlgorithmInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the algorithm to delete.</p>
        pub fn algorithm_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.algorithm_name(input.into());
            self
        }
        /// <p>The name of the algorithm to delete.</p>
        pub fn set_algorithm_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_algorithm_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApp`.
    ///
    /// <p>Used to stop and delete an app.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApp<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_app_input::Builder,
    }
    impl<C, M, R> DeleteApp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAppError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAppInputOperationOutputAlias,
                crate::output::DeleteAppOutput,
                crate::error::DeleteAppError,
                crate::input::DeleteAppInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain ID.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(input.into());
            self
        }
        /// <p>The domain ID.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The user profile name.</p>
        pub fn user_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_profile_name(input.into());
            self
        }
        /// <p>The user profile name.</p>
        pub fn set_user_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_user_profile_name(input);
            self
        }
        /// <p>The type of app.</p>
        pub fn app_type(mut self, input: crate::model::AppType) -> Self {
            self.inner = self.inner.app_type(input);
            self
        }
        /// <p>The type of app.</p>
        pub fn set_app_type(mut self, input: std::option::Option<crate::model::AppType>) -> Self {
            self.inner = self.inner.set_app_type(input);
            self
        }
        /// <p>The name of the app.</p>
        pub fn app_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_name(input.into());
            self
        }
        /// <p>The name of the app.</p>
        pub fn set_app_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAppImageConfig`.
    ///
    /// <p>Deletes an AppImageConfig.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAppImageConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_app_image_config_input::Builder,
    }
    impl<C, M, R> DeleteAppImageConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAppImageConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppImageConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAppImageConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAppImageConfigInputOperationOutputAlias,
                crate::output::DeleteAppImageConfigOutput,
                crate::error::DeleteAppImageConfigError,
                crate::input::DeleteAppImageConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the AppImageConfig to delete.</p>
        pub fn app_image_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_image_config_name(input.into());
            self
        }
        /// <p>The name of the AppImageConfig to delete.</p>
        pub fn set_app_image_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_image_config_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteArtifact`.
    ///
    /// <p>Deletes an artifact. Either <code>ArtifactArn</code> or <code>Source</code> must be specified.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteArtifact<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_artifact_input::Builder,
    }
    impl<C, M, R> DeleteArtifact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteArtifact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteArtifactOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteArtifactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteArtifactInputOperationOutputAlias,
                crate::output::DeleteArtifactOutput,
                crate::error::DeleteArtifactError,
                crate::input::DeleteArtifactInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the artifact to delete.</p>
        pub fn artifact_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.artifact_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the artifact to delete.</p>
        pub fn set_artifact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_artifact_arn(input);
            self
        }
        /// <p>The URI of the source.</p>
        pub fn source(mut self, input: crate::model::ArtifactSource) -> Self {
            self.inner = self.inner.source(input);
            self
        }
        /// <p>The URI of the source.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::ArtifactSource>,
        ) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAssociation`.
    ///
    /// <p>Deletes an association.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAssociation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_association_input::Builder,
    }
    impl<C, M, R> DeleteAssociation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAssociationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAssociationInputOperationOutputAlias,
                crate::output::DeleteAssociationOutput,
                crate::error::DeleteAssociationError,
                crate::input::DeleteAssociationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the source.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_arn(input.into());
            self
        }
        /// <p>The ARN of the source.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the destination.</p>
        pub fn destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the destination.</p>
        pub fn set_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCodeRepository`.
    ///
    /// <p>Deletes the specified Git repository from your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCodeRepository<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_code_repository_input::Builder,
    }
    impl<C, M, R> DeleteCodeRepository<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCodeRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCodeRepositoryOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCodeRepositoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCodeRepositoryInputOperationOutputAlias,
                crate::output::DeleteCodeRepositoryOutput,
                crate::error::DeleteCodeRepositoryError,
                crate::input::DeleteCodeRepositoryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Git repository to delete.</p>
        pub fn code_repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.code_repository_name(input.into());
            self
        }
        /// <p>The name of the Git repository to delete.</p>
        pub fn set_code_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_code_repository_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteContext`.
    ///
    /// <p>Deletes an context.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteContext<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_context_input::Builder,
    }
    impl<C, M, R> DeleteContext<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteContext`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteContextOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteContextError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteContextInputOperationOutputAlias,
                crate::output::DeleteContextOutput,
                crate::error::DeleteContextError,
                crate::input::DeleteContextInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the context to delete.</p>
        pub fn context_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.context_name(input.into());
            self
        }
        /// <p>The name of the context to delete.</p>
        pub fn set_context_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_context_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataQualityJobDefinition`.
    ///
    /// <p>Deletes a data quality monitoring job definition.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDataQualityJobDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_data_quality_job_definition_input::Builder,
    }
    impl<C, M, R> DeleteDataQualityJobDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDataQualityJobDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDataQualityJobDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDataQualityJobDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDataQualityJobDefinitionInputOperationOutputAlias,
                crate::output::DeleteDataQualityJobDefinitionOutput,
                crate::error::DeleteDataQualityJobDefinitionError,
                crate::input::DeleteDataQualityJobDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the data quality monitoring job definition to delete.</p>
        pub fn job_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_definition_name(input.into());
            self
        }
        /// <p>The name of the data quality monitoring job definition to delete.</p>
        pub fn set_job_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_job_definition_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDeviceFleet`.
    ///
    /// <p>Deletes a fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDeviceFleet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_device_fleet_input::Builder,
    }
    impl<C, M, R> DeleteDeviceFleet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDeviceFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDeviceFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDeviceFleetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDeviceFleetInputOperationOutputAlias,
                crate::output::DeleteDeviceFleetOutput,
                crate::error::DeleteDeviceFleetError,
                crate::input::DeleteDeviceFleetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet to delete.</p>
        pub fn device_fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_fleet_name(input.into());
            self
        }
        /// <p>The name of the fleet to delete.</p>
        pub fn set_device_fleet_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_device_fleet_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDomain`.
    ///
    /// <p>Used to delete a domain. If you onboarded with IAM mode, you will need to delete your domain to onboard again using SSO. Use with caution. All of the members of the domain will lose access to their EFS volume, including data, notebooks, and other artifacts. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_domain_input::Builder,
    }
    impl<C, M, R> DeleteDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDomainInputOperationOutputAlias,
                crate::output::DeleteDomainOutput,
                crate::error::DeleteDomainError,
                crate::input::DeleteDomainInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain ID.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(input.into());
            self
        }
        /// <p>The domain ID.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The retention policy for this domain, which specifies whether resources will be retained after the Domain is deleted. By default, all resources are retained (not automatically deleted). </p>
        pub fn retention_policy(mut self, input: crate::model::RetentionPolicy) -> Self {
            self.inner = self.inner.retention_policy(input);
            self
        }
        /// <p>The retention policy for this domain, which specifies whether resources will be retained after the Domain is deleted. By default, all resources are retained (not automatically deleted). </p>
        pub fn set_retention_policy(
            mut self,
            input: std::option::Option<crate::model::RetentionPolicy>,
        ) -> Self {
            self.inner = self.inner.set_retention_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEndpoint`.
    ///
    /// <p>Deletes an endpoint. Amazon SageMaker frees up all of the resources that were deployed when the endpoint was created. </p>
    /// <p>Amazon SageMaker retires any custom KMS key grants associated with the endpoint, meaning you don't need to use the <a href="http://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html">RevokeGrant</a> API call.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_endpoint_input::Builder,
    }
    impl<C, M, R> DeleteEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEndpointInputOperationOutputAlias,
                crate::output::DeleteEndpointOutput,
                crate::error::DeleteEndpointError,
                crate::input::DeleteEndpointInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the endpoint that you want to delete.</p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_name(input.into());
            self
        }
        /// <p>The name of the endpoint that you want to delete.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEndpointConfig`.
    ///
    /// <p>Deletes an endpoint configuration. The <code>DeleteEndpointConfig</code> API deletes only the specified configuration. It does not delete endpoints created using the configuration. </p>
    /// <p>You must not delete an <code>EndpointConfig</code> in use by an endpoint that is live or while the <code>UpdateEndpoint</code> or <code>CreateEndpoint</code> operations are being performed on the endpoint. If you delete the <code>EndpointConfig</code> of an endpoint that is active or being created or updated you may lose visibility into the instance type the endpoint is using. The endpoint must be deleted in order to stop incurring charges.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEndpointConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_endpoint_config_input::Builder,
    }
    impl<C, M, R> DeleteEndpointConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEndpointConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEndpointConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEndpointConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEndpointConfigInputOperationOutputAlias,
                crate::output::DeleteEndpointConfigOutput,
                crate::error::DeleteEndpointConfigError,
                crate::input::DeleteEndpointConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the endpoint configuration that you want to delete.</p>
        pub fn endpoint_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_config_name(input.into());
            self
        }
        /// <p>The name of the endpoint configuration that you want to delete.</p>
        pub fn set_endpoint_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_config_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteExperiment`.
    ///
    /// <p>Deletes an SageMaker experiment. All trials associated with the experiment must be deleted first. Use the <code>ListTrials</code> API to get a list of the trials associated with the experiment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteExperiment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_experiment_input::Builder,
    }
    impl<C, M, R> DeleteExperiment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteExperiment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteExperimentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteExperimentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteExperimentInputOperationOutputAlias,
                crate::output::DeleteExperimentOutput,
                crate::error::DeleteExperimentError,
                crate::input::DeleteExperimentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the experiment to delete.</p>
        pub fn experiment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.experiment_name(input.into());
            self
        }
        /// <p>The name of the experiment to delete.</p>
        pub fn set_experiment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_experiment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFeatureGroup`.
    ///
    /// <p>Delete the <code>FeatureGroup</code> and any data that was written to the <code>OnlineStore</code> of the <code>FeatureGroup</code>. Data cannot be accessed from the <code>OnlineStore</code> immediately after <code>DeleteFeatureGroup</code> is called. </p>
    /// <p>Data written into the <code>OfflineStore</code> will not be deleted. The Amazon Web Services Glue database and tables that are automatically created for your <code>OfflineStore</code> are not deleted. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFeatureGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_feature_group_input::Builder,
    }
    impl<C, M, R> DeleteFeatureGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFeatureGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFeatureGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFeatureGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFeatureGroupInputOperationOutputAlias,
                crate::output::DeleteFeatureGroupOutput,
                crate::error::DeleteFeatureGroupError,
                crate::input::DeleteFeatureGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the <code>FeatureGroup</code> you want to delete. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account. </p>
        pub fn feature_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.feature_group_name(input.into());
            self
        }
        /// <p>The name of the <code>FeatureGroup</code> you want to delete. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account. </p>
        pub fn set_feature_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_feature_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFlowDefinition`.
    ///
    /// <p>Deletes the specified flow definition.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFlowDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_flow_definition_input::Builder,
    }
    impl<C, M, R> DeleteFlowDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFlowDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFlowDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFlowDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFlowDefinitionInputOperationOutputAlias,
                crate::output::DeleteFlowDefinitionOutput,
                crate::error::DeleteFlowDefinitionError,
                crate::input::DeleteFlowDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the flow definition you are deleting.</p>
        pub fn flow_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_definition_name(input.into());
            self
        }
        /// <p>The name of the flow definition you are deleting.</p>
        pub fn set_flow_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_flow_definition_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteHumanTaskUi`.
    ///
    /// <p>Use this operation to delete a human task user interface (worker task template).</p>
    /// <p> To see a list of human task user interfaces (work task templates) in your account, use . When you delete a worker task template, it no longer appears when you call <code>ListHumanTaskUis</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteHumanTaskUi<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_human_task_ui_input::Builder,
    }
    impl<C, M, R> DeleteHumanTaskUi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteHumanTaskUi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteHumanTaskUiOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteHumanTaskUiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteHumanTaskUiInputOperationOutputAlias,
                crate::output::DeleteHumanTaskUiOutput,
                crate::error::DeleteHumanTaskUiError,
                crate::input::DeleteHumanTaskUiInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the human task user interface (work task template) you want to delete.</p>
        pub fn human_task_ui_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.human_task_ui_name(input.into());
            self
        }
        /// <p>The name of the human task user interface (work task template) you want to delete.</p>
        pub fn set_human_task_ui_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_human_task_ui_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteImage`.
    ///
    /// <p>Deletes a SageMaker image and all versions of the image. The container images aren't deleted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteImage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_image_input::Builder,
    }
    impl<C, M, R> DeleteImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteImageOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteImageInputOperationOutputAlias,
                crate::output::DeleteImageOutput,
                crate::error::DeleteImageError,
                crate::input::DeleteImageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the image to delete.</p>
        pub fn image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_name(input.into());
            self
        }
        /// <p>The name of the image to delete.</p>
        pub fn set_image_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteImageVersion`.
    ///
    /// <p>Deletes a version of a SageMaker image. The container image the version represents isn't deleted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteImageVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_image_version_input::Builder,
    }
    impl<C, M, R> DeleteImageVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteImageVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteImageVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteImageVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteImageVersionInputOperationOutputAlias,
                crate::output::DeleteImageVersionOutput,
                crate::error::DeleteImageVersionError,
                crate::input::DeleteImageVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the image.</p>
        pub fn image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_name(input.into());
            self
        }
        /// <p>The name of the image.</p>
        pub fn set_image_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_name(input);
            self
        }
        /// <p>The version to delete.</p>
        pub fn version(mut self, input: i32) -> Self {
            self.inner = self.inner.version(input);
            self
        }
        /// <p>The version to delete.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteModel`.
    ///
    /// <p>Deletes a model. The <code>DeleteModel</code> API deletes only the model entry that was created in Amazon SageMaker when you called the <code>CreateModel</code> API. It does not delete model artifacts, inference code, or the IAM role that you specified when creating the model. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteModel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_model_input::Builder,
    }
    impl<C, M, R> DeleteModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteModelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteModelInputOperationOutputAlias,
                crate::output::DeleteModelOutput,
                crate::error::DeleteModelError,
                crate::input::DeleteModelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the model to delete.</p>
        pub fn model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_name(input.into());
            self
        }
        /// <p>The name of the model to delete.</p>
        pub fn set_model_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteModelBiasJobDefinition`.
    ///
    /// <p>Deletes an Amazon SageMaker model bias job definition.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteModelBiasJobDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_model_bias_job_definition_input::Builder,
    }
    impl<C, M, R> DeleteModelBiasJobDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteModelBiasJobDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteModelBiasJobDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteModelBiasJobDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteModelBiasJobDefinitionInputOperationOutputAlias,
                crate::output::DeleteModelBiasJobDefinitionOutput,
                crate::error::DeleteModelBiasJobDefinitionError,
                crate::input::DeleteModelBiasJobDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the model bias job definition to delete.</p>
        pub fn job_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_definition_name(input.into());
            self
        }
        /// <p>The name of the model bias job definition to delete.</p>
        pub fn set_job_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_job_definition_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteModelExplainabilityJobDefinition`.
    ///
    /// <p>Deletes an Amazon SageMaker model explainability job definition.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteModelExplainabilityJobDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_model_explainability_job_definition_input::Builder,
    }
    impl<C, M, R> DeleteModelExplainabilityJobDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteModelExplainabilityJobDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteModelExplainabilityJobDefinitionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteModelExplainabilityJobDefinitionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteModelExplainabilityJobDefinitionInputOperationOutputAlias,
                crate::output::DeleteModelExplainabilityJobDefinitionOutput,
                crate::error::DeleteModelExplainabilityJobDefinitionError,
                crate::input::DeleteModelExplainabilityJobDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the model explainability job definition to delete.</p>
        pub fn job_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_definition_name(input.into());
            self
        }
        /// <p>The name of the model explainability job definition to delete.</p>
        pub fn set_job_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_job_definition_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteModelPackage`.
    ///
    /// <p>Deletes a model package.</p>
    /// <p>A model package is used to create Amazon SageMaker models or list on Amazon Web Services Marketplace. Buyers can subscribe to model packages listed on Amazon Web Services Marketplace to create models in Amazon SageMaker.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteModelPackage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_model_package_input::Builder,
    }
    impl<C, M, R> DeleteModelPackage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteModelPackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteModelPackageOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteModelPackageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteModelPackageInputOperationOutputAlias,
                crate::output::DeleteModelPackageOutput,
                crate::error::DeleteModelPackageError,
                crate::input::DeleteModelPackageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or Amazon Resource Name (ARN) of the model package to delete.</p>
        /// <p>When you specify a name, the name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).</p>
        pub fn model_package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_package_name(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the model package to delete.</p>
        /// <p>When you specify a name, the name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).</p>
        pub fn set_model_package_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_package_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteModelPackageGroup`.
    ///
    /// <p>Deletes the specified model group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteModelPackageGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_model_package_group_input::Builder,
    }
    impl<C, M, R> DeleteModelPackageGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteModelPackageGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteModelPackageGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteModelPackageGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteModelPackageGroupInputOperationOutputAlias,
                crate::output::DeleteModelPackageGroupOutput,
                crate::error::DeleteModelPackageGroupError,
                crate::input::DeleteModelPackageGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the model group to delete.</p>
        pub fn model_package_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_package_group_name(input.into());
            self
        }
        /// <p>The name of the model group to delete.</p>
        pub fn set_model_package_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_package_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteModelPackageGroupPolicy`.
    ///
    /// <p>Deletes a model group resource policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteModelPackageGroupPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_model_package_group_policy_input::Builder,
    }
    impl<C, M, R> DeleteModelPackageGroupPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteModelPackageGroupPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteModelPackageGroupPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteModelPackageGroupPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteModelPackageGroupPolicyInputOperationOutputAlias,
                crate::output::DeleteModelPackageGroupPolicyOutput,
                crate::error::DeleteModelPackageGroupPolicyError,
                crate::input::DeleteModelPackageGroupPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the model group for which to delete the policy.</p>
        pub fn model_package_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_package_group_name(input.into());
            self
        }
        /// <p>The name of the model group for which to delete the policy.</p>
        pub fn set_model_package_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_package_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteModelQualityJobDefinition`.
    ///
    /// <p>Deletes the secified model quality monitoring job definition.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteModelQualityJobDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_model_quality_job_definition_input::Builder,
    }
    impl<C, M, R> DeleteModelQualityJobDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteModelQualityJobDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteModelQualityJobDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteModelQualityJobDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteModelQualityJobDefinitionInputOperationOutputAlias,
                crate::output::DeleteModelQualityJobDefinitionOutput,
                crate::error::DeleteModelQualityJobDefinitionError,
                crate::input::DeleteModelQualityJobDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the model quality monitoring job definition to delete.</p>
        pub fn job_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_definition_name(input.into());
            self
        }
        /// <p>The name of the model quality monitoring job definition to delete.</p>
        pub fn set_job_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_job_definition_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMonitoringSchedule`.
    ///
    /// <p>Deletes a monitoring schedule. Also stops the schedule had not already been stopped. This does not delete the job execution history of the monitoring schedule. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteMonitoringSchedule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_monitoring_schedule_input::Builder,
    }
    impl<C, M, R> DeleteMonitoringSchedule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMonitoringSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMonitoringScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMonitoringScheduleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMonitoringScheduleInputOperationOutputAlias,
                crate::output::DeleteMonitoringScheduleOutput,
                crate::error::DeleteMonitoringScheduleError,
                crate::input::DeleteMonitoringScheduleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the monitoring schedule to delete.</p>
        pub fn monitoring_schedule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.monitoring_schedule_name(input.into());
            self
        }
        /// <p>The name of the monitoring schedule to delete.</p>
        pub fn set_monitoring_schedule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_monitoring_schedule_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteNotebookInstance`.
    ///
    /// <p> Deletes an Amazon SageMaker notebook instance. Before you can delete a notebook instance, you must call the <code>StopNotebookInstance</code> API. </p> <important>
    /// <p>When you delete a notebook instance, you lose all of your data. Amazon SageMaker removes the ML compute instance, and deletes the ML storage volume and the network interface associated with the notebook instance. </p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteNotebookInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_notebook_instance_input::Builder,
    }
    impl<C, M, R> DeleteNotebookInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteNotebookInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteNotebookInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteNotebookInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteNotebookInstanceInputOperationOutputAlias,
                crate::output::DeleteNotebookInstanceOutput,
                crate::error::DeleteNotebookInstanceError,
                crate::input::DeleteNotebookInstanceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon SageMaker notebook instance to delete.</p>
        pub fn notebook_instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notebook_instance_name(input.into());
            self
        }
        /// <p>The name of the Amazon SageMaker notebook instance to delete.</p>
        pub fn set_notebook_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notebook_instance_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteNotebookInstanceLifecycleConfig`.
    ///
    /// <p>Deletes a notebook instance lifecycle configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteNotebookInstanceLifecycleConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_notebook_instance_lifecycle_config_input::Builder,
    }
    impl<C, M, R> DeleteNotebookInstanceLifecycleConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteNotebookInstanceLifecycleConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteNotebookInstanceLifecycleConfigOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteNotebookInstanceLifecycleConfigError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteNotebookInstanceLifecycleConfigInputOperationOutputAlias,
                crate::output::DeleteNotebookInstanceLifecycleConfigOutput,
                crate::error::DeleteNotebookInstanceLifecycleConfigError,
                crate::input::DeleteNotebookInstanceLifecycleConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the lifecycle configuration to delete.</p>
        pub fn notebook_instance_lifecycle_config_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .notebook_instance_lifecycle_config_name(input.into());
            self
        }
        /// <p>The name of the lifecycle configuration to delete.</p>
        pub fn set_notebook_instance_lifecycle_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_notebook_instance_lifecycle_config_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePipeline`.
    ///
    /// <p>Deletes a pipeline if there are no running instances of the pipeline. To delete a pipeline, you must stop all running instances of the pipeline using the <code>StopPipelineExecution</code> API. When you delete a pipeline, all instances of the pipeline are deleted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePipeline<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_pipeline_input::Builder,
    }
    impl<C, M, R> DeletePipeline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePipelineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePipelineInputOperationOutputAlias,
                crate::output::DeletePipelineOutput,
                crate::error::DeletePipelineError,
                crate::input::DeletePipelineInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the pipeline to delete.</p>
        pub fn pipeline_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_name(input.into());
            self
        }
        /// <p>The name of the pipeline to delete.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_name(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProject`.
    ///
    /// <p>Delete the specified project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteProject<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_project_input::Builder,
    }
    impl<C, M, R> DeleteProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProjectInputOperationOutputAlias,
                crate::output::DeleteProjectOutput,
                crate::error::DeleteProjectError,
                crate::input::DeleteProjectInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project to delete.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>The name of the project to delete.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStudioLifecycleConfig`.
    ///
    /// <p>Deletes the Studio Lifecycle Configuration. In order to delete the Lifecycle Configuration, there must be no running apps using the Lifecycle Configuration. You must also remove the Lifecycle Configuration from UserSettings in all Domains and UserProfiles.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteStudioLifecycleConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_studio_lifecycle_config_input::Builder,
    }
    impl<C, M, R> DeleteStudioLifecycleConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteStudioLifecycleConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStudioLifecycleConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStudioLifecycleConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteStudioLifecycleConfigInputOperationOutputAlias,
                crate::output::DeleteStudioLifecycleConfigOutput,
                crate::error::DeleteStudioLifecycleConfigError,
                crate::input::DeleteStudioLifecycleConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Studio Lifecycle Configuration to delete.</p>
        pub fn studio_lifecycle_config_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.studio_lifecycle_config_name(input.into());
            self
        }
        /// <p>The name of the Studio Lifecycle Configuration to delete.</p>
        pub fn set_studio_lifecycle_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_studio_lifecycle_config_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTags`.
    ///
    /// <p>Deletes the specified tags from an Amazon SageMaker resource.</p>
    /// <p>To list a resource's tags, use the <code>ListTags</code> API. </p> <note>
    /// <p>When you call this API to delete tags from a hyperparameter tuning job, the deleted tags are not removed from training jobs that the hyperparameter tuning job launched before you called this API.</p>
    /// </note> <note>
    /// <p>When you call this API to delete tags from a SageMaker Studio Domain or User Profile, the deleted tags are not removed from Apps that the SageMaker Studio Domain or User Profile launched before you called this API.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_tags_input::Builder,
    }
    impl<C, M, R> DeleteTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTagsInputOperationOutputAlias,
                crate::output::DeleteTagsOutput,
                crate::error::DeleteTagsError,
                crate::input::DeleteTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to delete.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to delete.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>An array or one or more tag keys to delete.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>An array or one or more tag keys to delete.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTrial`.
    ///
    /// <p>Deletes the specified trial. All trial components that make up the trial must be deleted first. Use the <code>DescribeTrialComponent</code> API to get the list of trial components.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTrial<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_trial_input::Builder,
    }
    impl<C, M, R> DeleteTrial<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTrial`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTrialOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTrialError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTrialInputOperationOutputAlias,
                crate::output::DeleteTrialOutput,
                crate::error::DeleteTrialError,
                crate::input::DeleteTrialInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the trial to delete.</p>
        pub fn trial_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trial_name(input.into());
            self
        }
        /// <p>The name of the trial to delete.</p>
        pub fn set_trial_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_trial_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTrialComponent`.
    ///
    /// <p>Deletes the specified trial component. A trial component must be disassociated from all trials before the trial component can be deleted. To disassociate a trial component from a trial, call the <code>DisassociateTrialComponent</code> API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTrialComponent<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_trial_component_input::Builder,
    }
    impl<C, M, R> DeleteTrialComponent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTrialComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTrialComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTrialComponentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTrialComponentInputOperationOutputAlias,
                crate::output::DeleteTrialComponentOutput,
                crate::error::DeleteTrialComponentError,
                crate::input::DeleteTrialComponentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the component to delete.</p>
        pub fn trial_component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trial_component_name(input.into());
            self
        }
        /// <p>The name of the component to delete.</p>
        pub fn set_trial_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_trial_component_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUserProfile`.
    ///
    /// <p>Deletes a user profile. When a user profile is deleted, the user loses access to their EFS volume, including data, notebooks, and other artifacts.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteUserProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_profile_input::Builder,
    }
    impl<C, M, R> DeleteUserProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUserProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserProfileInputOperationOutputAlias,
                crate::output::DeleteUserProfileOutput,
                crate::error::DeleteUserProfileError,
                crate::input::DeleteUserProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain ID.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(input.into());
            self
        }
        /// <p>The domain ID.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The user profile name.</p>
        pub fn user_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_profile_name(input.into());
            self
        }
        /// <p>The user profile name.</p>
        pub fn set_user_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_user_profile_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWorkforce`.
    ///
    /// <p>Use this operation to delete a workforce.</p>
    /// <p>If you want to create a new workforce in an Amazon Web Services Region where a workforce already exists, use this operation to delete the existing workforce and then use to create a new workforce.</p> <important>
    /// <p>If a private workforce contains one or more work teams, you must use the operation to delete all work teams before you delete the workforce. If you try to delete a workforce that contains one or more work teams, you will recieve a <code>ResourceInUse</code> error.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteWorkforce<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_workforce_input::Builder,
    }
    impl<C, M, R> DeleteWorkforce<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWorkforce`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWorkforceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWorkforceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWorkforceInputOperationOutputAlias,
                crate::output::DeleteWorkforceOutput,
                crate::error::DeleteWorkforceError,
                crate::input::DeleteWorkforceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the workforce.</p>
        pub fn workforce_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workforce_name(input.into());
            self
        }
        /// <p>The name of the workforce.</p>
        pub fn set_workforce_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_workforce_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWorkteam`.
    ///
    /// <p>Deletes an existing work team. This operation can't be undone.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteWorkteam<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_workteam_input::Builder,
    }
    impl<C, M, R> DeleteWorkteam<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWorkteam`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWorkteamOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWorkteamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWorkteamInputOperationOutputAlias,
                crate::output::DeleteWorkteamOutput,
                crate::error::DeleteWorkteamError,
                crate::input::DeleteWorkteamInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the work team to delete.</p>
        pub fn workteam_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workteam_name(input.into());
            self
        }
        /// <p>The name of the work team to delete.</p>
        pub fn set_workteam_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_workteam_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterDevices`.
    ///
    /// <p>Deregisters the specified devices. After you deregister a device, you will need to re-register the devices.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeregisterDevices<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deregister_devices_input::Builder,
    }
    impl<C, M, R> DeregisterDevices<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeregisterDevices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterDevicesOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterDevicesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeregisterDevicesInputOperationOutputAlias,
                crate::output::DeregisterDevicesOutput,
                crate::error::DeregisterDevicesError,
                crate::input::DeregisterDevicesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet the devices belong to.</p>
        pub fn device_fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_fleet_name(input.into());
            self
        }
        /// <p>The name of the fleet the devices belong to.</p>
        pub fn set_device_fleet_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_device_fleet_name(input);
            self
        }
        /// Appends an item to `DeviceNames`.
        ///
        /// To override the contents of this collection use [`set_device_names`](Self::set_device_names).
        ///
        /// <p>The unique IDs of the devices.</p>
        pub fn device_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_names(input.into());
            self
        }
        /// <p>The unique IDs of the devices.</p>
        pub fn set_device_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_device_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAction`.
    ///
    /// <p>Describes an action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_action_input::Builder,
    }
    impl<C, M, R> DescribeAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeActionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeActionInputOperationOutputAlias,
                crate::output::DescribeActionOutput,
                crate::error::DescribeActionError,
                crate::input::DescribeActionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the action to describe.</p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_name(input.into());
            self
        }
        /// <p>The name of the action to describe.</p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAlgorithm`.
    ///
    /// <p>Returns a description of the specified algorithm that is in your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAlgorithm<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_algorithm_input::Builder,
    }
    impl<C, M, R> DescribeAlgorithm<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAlgorithm`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAlgorithmOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAlgorithmError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAlgorithmInputOperationOutputAlias,
                crate::output::DescribeAlgorithmOutput,
                crate::error::DescribeAlgorithmError,
                crate::input::DescribeAlgorithmInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the algorithm to describe.</p>
        pub fn algorithm_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.algorithm_name(input.into());
            self
        }
        /// <p>The name of the algorithm to describe.</p>
        pub fn set_algorithm_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_algorithm_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeApp`.
    ///
    /// <p>Describes the app.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeApp<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_app_input::Builder,
    }
    impl<C, M, R> DescribeApp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeApp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAppOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAppError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAppInputOperationOutputAlias,
                crate::output::DescribeAppOutput,
                crate::error::DescribeAppError,
                crate::input::DescribeAppInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain ID.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(input.into());
            self
        }
        /// <p>The domain ID.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The user profile name.</p>
        pub fn user_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_profile_name(input.into());
            self
        }
        /// <p>The user profile name.</p>
        pub fn set_user_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_user_profile_name(input);
            self
        }
        /// <p>The type of app.</p>
        pub fn app_type(mut self, input: crate::model::AppType) -> Self {
            self.inner = self.inner.app_type(input);
            self
        }
        /// <p>The type of app.</p>
        pub fn set_app_type(mut self, input: std::option::Option<crate::model::AppType>) -> Self {
            self.inner = self.inner.set_app_type(input);
            self
        }
        /// <p>The name of the app.</p>
        pub fn app_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_name(input.into());
            self
        }
        /// <p>The name of the app.</p>
        pub fn set_app_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAppImageConfig`.
    ///
    /// <p>Describes an AppImageConfig.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAppImageConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_app_image_config_input::Builder,
    }
    impl<C, M, R> DescribeAppImageConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAppImageConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAppImageConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAppImageConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAppImageConfigInputOperationOutputAlias,
                crate::output::DescribeAppImageConfigOutput,
                crate::error::DescribeAppImageConfigError,
                crate::input::DescribeAppImageConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the AppImageConfig to describe.</p>
        pub fn app_image_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_image_config_name(input.into());
            self
        }
        /// <p>The name of the AppImageConfig to describe.</p>
        pub fn set_app_image_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_image_config_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeArtifact`.
    ///
    /// <p>Describes an artifact.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeArtifact<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_artifact_input::Builder,
    }
    impl<C, M, R> DescribeArtifact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeArtifact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeArtifactOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeArtifactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeArtifactInputOperationOutputAlias,
                crate::output::DescribeArtifactOutput,
                crate::error::DescribeArtifactError,
                crate::input::DescribeArtifactInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the artifact to describe.</p>
        pub fn artifact_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.artifact_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the artifact to describe.</p>
        pub fn set_artifact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_artifact_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAutoMLJob`.
    ///
    /// <p>Returns information about an Amazon SageMaker AutoML job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAutoMLJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_auto_ml_job_input::Builder,
    }
    impl<C, M, R> DescribeAutoMLJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAutoMLJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAutoMlJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAutoMLJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAutoMlJobInputOperationOutputAlias,
                crate::output::DescribeAutoMlJobOutput,
                crate::error::DescribeAutoMLJobError,
                crate::input::DescribeAutoMlJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Requests information about an AutoML job using its unique name.</p>
        pub fn auto_ml_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.auto_ml_job_name(input.into());
            self
        }
        /// <p>Requests information about an AutoML job using its unique name.</p>
        pub fn set_auto_ml_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_auto_ml_job_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCodeRepository`.
    ///
    /// <p>Gets details about the specified Git repository.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCodeRepository<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_code_repository_input::Builder,
    }
    impl<C, M, R> DescribeCodeRepository<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCodeRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCodeRepositoryOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCodeRepositoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCodeRepositoryInputOperationOutputAlias,
                crate::output::DescribeCodeRepositoryOutput,
                crate::error::DescribeCodeRepositoryError,
                crate::input::DescribeCodeRepositoryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Git repository to describe.</p>
        pub fn code_repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.code_repository_name(input.into());
            self
        }
        /// <p>The name of the Git repository to describe.</p>
        pub fn set_code_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_code_repository_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCompilationJob`.
    ///
    /// <p>Returns information about a model compilation job.</p>
    /// <p>To create a model compilation job, use <code>CreateCompilationJob</code>. To get information about multiple model compilation jobs, use <code>ListCompilationJobs</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCompilationJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_compilation_job_input::Builder,
    }
    impl<C, M, R> DescribeCompilationJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCompilationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCompilationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCompilationJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCompilationJobInputOperationOutputAlias,
                crate::output::DescribeCompilationJobOutput,
                crate::error::DescribeCompilationJobError,
                crate::input::DescribeCompilationJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the model compilation job that you want information about.</p>
        pub fn compilation_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.compilation_job_name(input.into());
            self
        }
        /// <p>The name of the model compilation job that you want information about.</p>
        pub fn set_compilation_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_compilation_job_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeContext`.
    ///
    /// <p>Describes a context.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeContext<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_context_input::Builder,
    }
    impl<C, M, R> DescribeContext<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeContext`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeContextOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeContextError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeContextInputOperationOutputAlias,
                crate::output::DescribeContextOutput,
                crate::error::DescribeContextError,
                crate::input::DescribeContextInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the context to describe.</p>
        pub fn context_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.context_name(input.into());
            self
        }
        /// <p>The name of the context to describe.</p>
        pub fn set_context_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_context_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataQualityJobDefinition`.
    ///
    /// <p>Gets the details of a data quality monitoring job definition.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDataQualityJobDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_data_quality_job_definition_input::Builder,
    }
    impl<C, M, R> DescribeDataQualityJobDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDataQualityJobDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDataQualityJobDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDataQualityJobDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDataQualityJobDefinitionInputOperationOutputAlias,
                crate::output::DescribeDataQualityJobDefinitionOutput,
                crate::error::DescribeDataQualityJobDefinitionError,
                crate::input::DescribeDataQualityJobDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the data quality monitoring job definition to describe.</p>
        pub fn job_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_definition_name(input.into());
            self
        }
        /// <p>The name of the data quality monitoring job definition to describe.</p>
        pub fn set_job_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_job_definition_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDevice`.
    ///
    /// <p>Describes the device.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDevice<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_device_input::Builder,
    }
    impl<C, M, R> DescribeDevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDeviceInputOperationOutputAlias,
                crate::output::DescribeDeviceOutput,
                crate::error::DescribeDeviceError,
                crate::input::DescribeDeviceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Next token of device description.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Next token of device description.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The unique ID of the device.</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_name(input.into());
            self
        }
        /// <p>The unique ID of the device.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_name(input);
            self
        }
        /// <p>The name of the fleet the devices belong to.</p>
        pub fn device_fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_fleet_name(input.into());
            self
        }
        /// <p>The name of the fleet the devices belong to.</p>
        pub fn set_device_fleet_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_device_fleet_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDeviceFleet`.
    ///
    /// <p>A description of the fleet the device belongs to.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDeviceFleet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_device_fleet_input::Builder,
    }
    impl<C, M, R> DescribeDeviceFleet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDeviceFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDeviceFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDeviceFleetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDeviceFleetInputOperationOutputAlias,
                crate::output::DescribeDeviceFleetOutput,
                crate::error::DescribeDeviceFleetError,
                crate::input::DescribeDeviceFleetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet.</p>
        pub fn device_fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_fleet_name(input.into());
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_device_fleet_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_device_fleet_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDomain`.
    ///
    /// <p>The description of the domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_domain_input::Builder,
    }
    impl<C, M, R> DescribeDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDomainInputOperationOutputAlias,
                crate::output::DescribeDomainOutput,
                crate::error::DescribeDomainError,
                crate::input::DescribeDomainInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain ID.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(input.into());
            self
        }
        /// <p>The domain ID.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEdgePackagingJob`.
    ///
    /// <p>A description of edge packaging jobs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEdgePackagingJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_edge_packaging_job_input::Builder,
    }
    impl<C, M, R> DescribeEdgePackagingJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEdgePackagingJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEdgePackagingJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEdgePackagingJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEdgePackagingJobInputOperationOutputAlias,
                crate::output::DescribeEdgePackagingJobOutput,
                crate::error::DescribeEdgePackagingJobError,
                crate::input::DescribeEdgePackagingJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the edge packaging job.</p>
        pub fn edge_packaging_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.edge_packaging_job_name(input.into());
            self
        }
        /// <p>The name of the edge packaging job.</p>
        pub fn set_edge_packaging_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_edge_packaging_job_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEndpoint`.
    ///
    /// <p>Returns the description of an endpoint.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_endpoint_input::Builder,
    }
    impl<C, M, R> DescribeEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEndpointInputOperationOutputAlias,
                crate::output::DescribeEndpointOutput,
                crate::error::DescribeEndpointError,
                crate::input::DescribeEndpointInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the endpoint.</p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_name(input.into());
            self
        }
        /// <p>The name of the endpoint.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEndpointConfig`.
    ///
    /// <p>Returns the description of an endpoint configuration created using the <code>CreateEndpointConfig</code> API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEndpointConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_endpoint_config_input::Builder,
    }
    impl<C, M, R> DescribeEndpointConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEndpointConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEndpointConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEndpointConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEndpointConfigInputOperationOutputAlias,
                crate::output::DescribeEndpointConfigOutput,
                crate::error::DescribeEndpointConfigError,
                crate::input::DescribeEndpointConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the endpoint configuration.</p>
        pub fn endpoint_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_config_name(input.into());
            self
        }
        /// <p>The name of the endpoint configuration.</p>
        pub fn set_endpoint_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_config_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeExperiment`.
    ///
    /// <p>Provides a list of an experiment's properties.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeExperiment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_experiment_input::Builder,
    }
    impl<C, M, R> DescribeExperiment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeExperiment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeExperimentOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeExperimentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeExperimentInputOperationOutputAlias,
                crate::output::DescribeExperimentOutput,
                crate::error::DescribeExperimentError,
                crate::input::DescribeExperimentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the experiment to describe.</p>
        pub fn experiment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.experiment_name(input.into());
            self
        }
        /// <p>The name of the experiment to describe.</p>
        pub fn set_experiment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_experiment_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFeatureGroup`.
    ///
    /// <p>Use this operation to describe a <code>FeatureGroup</code>. The response includes information on the creation time, <code>FeatureGroup</code> name, the unique identifier for each <code>FeatureGroup</code>, and more.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFeatureGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_feature_group_input::Builder,
    }
    impl<C, M, R> DescribeFeatureGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFeatureGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFeatureGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFeatureGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFeatureGroupInputOperationOutputAlias,
                crate::output::DescribeFeatureGroupOutput,
                crate::error::DescribeFeatureGroupError,
                crate::input::DescribeFeatureGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the <code>FeatureGroup</code> you want described. </p>
        pub fn feature_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.feature_group_name(input.into());
            self
        }
        /// <p>The name of the <code>FeatureGroup</code> you want described. </p>
        pub fn set_feature_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_feature_group_name(input);
            self
        }
        /// <p>A token to resume pagination of the list of <code>Features</code> (<code>FeatureDefinitions</code>). 2,500 <code>Features</code> are returned by default.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to resume pagination of the list of <code>Features</code> (<code>FeatureDefinitions</code>). 2,500 <code>Features</code> are returned by default.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFlowDefinition`.
    ///
    /// <p>Returns information about the specified flow definition.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFlowDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_flow_definition_input::Builder,
    }
    impl<C, M, R> DescribeFlowDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFlowDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFlowDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFlowDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFlowDefinitionInputOperationOutputAlias,
                crate::output::DescribeFlowDefinitionOutput,
                crate::error::DescribeFlowDefinitionError,
                crate::input::DescribeFlowDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the flow definition.</p>
        pub fn flow_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_definition_name(input.into());
            self
        }
        /// <p>The name of the flow definition.</p>
        pub fn set_flow_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_flow_definition_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeHumanTaskUi`.
    ///
    /// <p>Returns information about the requested human task user interface (worker task template).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeHumanTaskUi<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_human_task_ui_input::Builder,
    }
    impl<C, M, R> DescribeHumanTaskUi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeHumanTaskUi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeHumanTaskUiOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeHumanTaskUiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeHumanTaskUiInputOperationOutputAlias,
                crate::output::DescribeHumanTaskUiOutput,
                crate::error::DescribeHumanTaskUiError,
                crate::input::DescribeHumanTaskUiInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the human task user interface (worker task template) you want information about.</p>
        pub fn human_task_ui_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.human_task_ui_name(input.into());
            self
        }
        /// <p>The name of the human task user interface (worker task template) you want information about.</p>
        pub fn set_human_task_ui_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_human_task_ui_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeHyperParameterTuningJob`.
    ///
    /// <p>Gets a description of a hyperparameter tuning job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeHyperParameterTuningJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_hyper_parameter_tuning_job_input::Builder,
    }
    impl<C, M, R> DescribeHyperParameterTuningJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeHyperParameterTuningJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeHyperParameterTuningJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeHyperParameterTuningJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeHyperParameterTuningJobInputOperationOutputAlias,
                crate::output::DescribeHyperParameterTuningJobOutput,
                crate::error::DescribeHyperParameterTuningJobError,
                crate::input::DescribeHyperParameterTuningJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the tuning job.</p>
        pub fn hyper_parameter_tuning_job_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.hyper_parameter_tuning_job_name(input.into());
            self
        }
        /// <p>The name of the tuning job.</p>
        pub fn set_hyper_parameter_tuning_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hyper_parameter_tuning_job_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeImage`.
    ///
    /// <p>Describes a SageMaker image.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeImage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_image_input::Builder,
    }
    impl<C, M, R> DescribeImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeImageOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeImageInputOperationOutputAlias,
                crate::output::DescribeImageOutput,
                crate::error::DescribeImageError,
                crate::input::DescribeImageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the image to describe.</p>
        pub fn image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_name(input.into());
            self
        }
        /// <p>The name of the image to describe.</p>
        pub fn set_image_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeImageVersion`.
    ///
    /// <p>Describes a version of a SageMaker image.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeImageVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_image_version_input::Builder,
    }
    impl<C, M, R> DescribeImageVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeImageVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeImageVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeImageVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeImageVersionInputOperationOutputAlias,
                crate::output::DescribeImageVersionOutput,
                crate::error::DescribeImageVersionError,
                crate::input::DescribeImageVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the image.</p>
        pub fn image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_name(input.into());
            self
        }
        /// <p>The name of the image.</p>
        pub fn set_image_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_name(input);
            self
        }
        /// <p>The version of the image. If not specified, the latest version is described.</p>
        pub fn version(mut self, input: i32) -> Self {
            self.inner = self.inner.version(input);
            self
        }
        /// <p>The version of the image. If not specified, the latest version is described.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInferenceRecommendationsJob`.
    ///
    /// <p>Provides the results of the Inference Recommender job. One or more recommendation jobs are returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeInferenceRecommendationsJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_inference_recommendations_job_input::Builder,
    }
    impl<C, M, R> DescribeInferenceRecommendationsJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeInferenceRecommendationsJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInferenceRecommendationsJobOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeInferenceRecommendationsJobError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeInferenceRecommendationsJobInputOperationOutputAlias,
                crate::output::DescribeInferenceRecommendationsJobOutput,
                crate::error::DescribeInferenceRecommendationsJobError,
                crate::input::DescribeInferenceRecommendationsJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(input.into());
            self
        }
        /// <p>The name of the job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLabelingJob`.
    ///
    /// <p>Gets information about a labeling job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLabelingJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_labeling_job_input::Builder,
    }
    impl<C, M, R> DescribeLabelingJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLabelingJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLabelingJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLabelingJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLabelingJobInputOperationOutputAlias,
                crate::output::DescribeLabelingJobOutput,
                crate::error::DescribeLabelingJobError,
                crate::input::DescribeLabelingJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the labeling job to return information for.</p>
        pub fn labeling_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.labeling_job_name(input.into());
            self
        }
        /// <p>The name of the labeling job to return information for.</p>
        pub fn set_labeling_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_labeling_job_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLineageGroup`.
    ///
    /// <p>Provides a list of properties for the requested lineage group. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/xaccount-lineage-tracking.html"> Cross-Account Lineage Tracking </a> in the <i>Amazon SageMaker Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLineageGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_lineage_group_input::Builder,
    }
    impl<C, M, R> DescribeLineageGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLineageGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLineageGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLineageGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLineageGroupInputOperationOutputAlias,
                crate::output::DescribeLineageGroupOutput,
                crate::error::DescribeLineageGroupError,
                crate::input::DescribeLineageGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the lineage group.</p>
        pub fn lineage_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lineage_group_name(input.into());
            self
        }
        /// <p>The name of the lineage group.</p>
        pub fn set_lineage_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_lineage_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeModel`.
    ///
    /// <p>Describes a model that you created using the <code>CreateModel</code> API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeModel<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_model_input::Builder,
    }
    impl<C, M, R> DescribeModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeModelOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeModelInputOperationOutputAlias,
                crate::output::DescribeModelOutput,
                crate::error::DescribeModelError,
                crate::input::DescribeModelInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the model.</p>
        pub fn model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_name(input.into());
            self
        }
        /// <p>The name of the model.</p>
        pub fn set_model_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_model_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeModelBiasJobDefinition`.
    ///
    /// <p>Returns a description of a model bias job definition.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeModelBiasJobDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_model_bias_job_definition_input::Builder,
    }
    impl<C, M, R> DescribeModelBiasJobDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeModelBiasJobDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeModelBiasJobDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeModelBiasJobDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeModelBiasJobDefinitionInputOperationOutputAlias,
                crate::output::DescribeModelBiasJobDefinitionOutput,
                crate::error::DescribeModelBiasJobDefinitionError,
                crate::input::DescribeModelBiasJobDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the model bias job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
        pub fn job_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_definition_name(input.into());
            self
        }
        /// <p>The name of the model bias job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
        pub fn set_job_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_job_definition_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeModelExplainabilityJobDefinition`.
    ///
    /// <p>Returns a description of a model explainability job definition.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeModelExplainabilityJobDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_model_explainability_job_definition_input::Builder,
    }
    impl<C, M, R> DescribeModelExplainabilityJobDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeModelExplainabilityJobDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeModelExplainabilityJobDefinitionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeModelExplainabilityJobDefinitionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeModelExplainabilityJobDefinitionInputOperationOutputAlias,
                crate::output::DescribeModelExplainabilityJobDefinitionOutput,
                crate::error::DescribeModelExplainabilityJobDefinitionError,
                crate::input::DescribeModelExplainabilityJobDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the model explainability job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
        pub fn job_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_definition_name(input.into());
            self
        }
        /// <p>The name of the model explainability job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
        pub fn set_job_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_job_definition_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeModelPackage`.
    ///
    /// <p>Returns a description of the specified model package, which is used to create SageMaker models or list them on Amazon Web Services Marketplace.</p>
    /// <p>To create models in SageMaker, buyers can subscribe to model packages listed on Amazon Web Services Marketplace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeModelPackage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_model_package_input::Builder,
    }
    impl<C, M, R> DescribeModelPackage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeModelPackage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeModelPackageOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeModelPackageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeModelPackageInputOperationOutputAlias,
                crate::output::DescribeModelPackageOutput,
                crate::error::DescribeModelPackageError,
                crate::input::DescribeModelPackageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or Amazon Resource Name (ARN) of the model package to describe.</p>
        /// <p>When you specify a name, the name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).</p>
        pub fn model_package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_package_name(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the model package to describe.</p>
        /// <p>When you specify a name, the name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).</p>
        pub fn set_model_package_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_package_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeModelPackageGroup`.
    ///
    /// <p>Gets a description for the specified model group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeModelPackageGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_model_package_group_input::Builder,
    }
    impl<C, M, R> DescribeModelPackageGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeModelPackageGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeModelPackageGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeModelPackageGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeModelPackageGroupInputOperationOutputAlias,
                crate::output::DescribeModelPackageGroupOutput,
                crate::error::DescribeModelPackageGroupError,
                crate::input::DescribeModelPackageGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the model group to describe.</p>
        pub fn model_package_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_package_group_name(input.into());
            self
        }
        /// <p>The name of the model group to describe.</p>
        pub fn set_model_package_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_package_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeModelQualityJobDefinition`.
    ///
    /// <p>Returns a description of a model quality job definition.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeModelQualityJobDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_model_quality_job_definition_input::Builder,
    }
    impl<C, M, R> DescribeModelQualityJobDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeModelQualityJobDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeModelQualityJobDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeModelQualityJobDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeModelQualityJobDefinitionInputOperationOutputAlias,
                crate::output::DescribeModelQualityJobDefinitionOutput,
                crate::error::DescribeModelQualityJobDefinitionError,
                crate::input::DescribeModelQualityJobDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the model quality job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
        pub fn job_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_definition_name(input.into());
            self
        }
        /// <p>The name of the model quality job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
        pub fn set_job_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_job_definition_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMonitoringSchedule`.
    ///
    /// <p>Describes the schedule for a monitoring job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeMonitoringSchedule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_monitoring_schedule_input::Builder,
    }
    impl<C, M, R> DescribeMonitoringSchedule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeMonitoringSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMonitoringScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMonitoringScheduleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeMonitoringScheduleInputOperationOutputAlias,
                crate::output::DescribeMonitoringScheduleOutput,
                crate::error::DescribeMonitoringScheduleError,
                crate::input::DescribeMonitoringScheduleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of a previously created monitoring schedule.</p>
        pub fn monitoring_schedule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.monitoring_schedule_name(input.into());
            self
        }
        /// <p>Name of a previously created monitoring schedule.</p>
        pub fn set_monitoring_schedule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_monitoring_schedule_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeNotebookInstance`.
    ///
    /// <p>Returns information about a notebook instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeNotebookInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_notebook_instance_input::Builder,
    }
    impl<C, M, R> DescribeNotebookInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeNotebookInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeNotebookInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeNotebookInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeNotebookInstanceInputOperationOutputAlias,
                crate::output::DescribeNotebookInstanceOutput,
                crate::error::DescribeNotebookInstanceError,
                crate::input::DescribeNotebookInstanceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the notebook instance that you want information about.</p>
        pub fn notebook_instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.notebook_instance_name(input.into());
            self
        }
        /// <p>The name of the notebook instance that you want information about.</p>
        pub fn set_notebook_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_notebook_instance_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeNotebookInstanceLifecycleConfig`.
    ///
    /// <p>Returns a description of a notebook instance lifecycle configuration.</p>
    /// <p>For information about notebook instance lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeNotebookInstanceLifecycleConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_notebook_instance_lifecycle_config_input::Builder,
    }
    impl<C, M, R> DescribeNotebookInstanceLifecycleConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeNotebookInstanceLifecycleConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeNotebookInstanceLifecycleConfigOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeNotebookInstanceLifecycleConfigError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeNotebookInstanceLifecycleConfigInputOperationOutputAlias,
                crate::output::DescribeNotebookInstanceLifecycleConfigOutput,
                crate::error::DescribeNotebookInstanceLifecycleConfigError,
                crate::input::DescribeNotebookInstanceLifecycleConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the lifecycle configuration to describe.</p>
        pub fn notebook_instance_lifecycle_config_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .notebook_instance_lifecycle_config_name(input.into());
            self
        }
        /// <p>The name of the lifecycle configuration to describe.</p>
        pub fn set_notebook_instance_lifecycle_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_notebook_instance_lifecycle_config_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePipeline`.
    ///
    /// <p>Describes the details of a pipeline.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePipeline<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_pipeline_input::Builder,
    }
    impl<C, M, R> DescribePipeline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePipelineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePipelineInputOperationOutputAlias,
                crate::output::DescribePipelineOutput,
                crate::error::DescribePipelineError,
                crate::input::DescribePipelineInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the pipeline to describe.</p>
        pub fn pipeline_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_name(input.into());
            self
        }
        /// <p>The name of the pipeline to describe.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePipelineDefinitionForExecution`.
    ///
    /// <p>Describes the details of an execution's pipeline definition.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePipelineDefinitionForExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_pipeline_definition_for_execution_input::Builder,
    }
    impl<C, M, R> DescribePipelineDefinitionForExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePipelineDefinitionForExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePipelineDefinitionForExecutionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribePipelineDefinitionForExecutionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePipelineDefinitionForExecutionInputOperationOutputAlias,
                crate::output::DescribePipelineDefinitionForExecutionOutput,
                crate::error::DescribePipelineDefinitionForExecutionError,
                crate::input::DescribePipelineDefinitionForExecutionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
        pub fn pipeline_execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_execution_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
        pub fn set_pipeline_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_execution_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePipelineExecution`.
    ///
    /// <p>Describes the details of a pipeline execution.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePipelineExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_pipeline_execution_input::Builder,
    }
    impl<C, M, R> DescribePipelineExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePipelineExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePipelineExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePipelineExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePipelineExecutionInputOperationOutputAlias,
                crate::output::DescribePipelineExecutionOutput,
                crate::error::DescribePipelineExecutionError,
                crate::input::DescribePipelineExecutionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
        pub fn pipeline_execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pipeline_execution_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
        pub fn set_pipeline_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_execution_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProcessingJob`.
    ///
    /// <p>Returns a description of a processing job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeProcessingJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_processing_job_input::Builder,
    }
    impl<C, M, R> DescribeProcessingJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeProcessingJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProcessingJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProcessingJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeProcessingJobInputOperationOutputAlias,
                crate::output::DescribeProcessingJobOutput,
                crate::error::DescribeProcessingJobError,
                crate::input::DescribeProcessingJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the processing job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
        pub fn processing_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.processing_job_name(input.into());
            self
        }
        /// <p>The name of the processing job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>
        pub fn set_processing_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_processing_job_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProject`.
    ///
    /// <p>Describes the details of a project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeProject<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_project_input::Builder,
    }
    impl<C, M, R> DescribeProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeProjectInputOperationOutputAlias,
                crate::output::DescribeProjectOutput,
                crate::error::DescribeProjectError,
                crate::input::DescribeProjectInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project to describe.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>The name of the project to describe.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStudioLifecycleConfig`.
    ///
    /// <p>Describes the Studio Lifecycle Configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeStudioLifecycleConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_studio_lifecycle_config_input::Builder,
    }
    impl<C, M, R> DescribeStudioLifecycleConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeStudioLifecycleConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStudioLifecycleConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStudioLifecycleConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeStudioLifecycleConfigInputOperationOutputAlias,
                crate::output::DescribeStudioLifecycleConfigOutput,
                crate::error::DescribeStudioLifecycleConfigError,
                crate::input::DescribeStudioLifecycleConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Studio Lifecycle Configuration to describe.</p>
        pub fn studio_lifecycle_config_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.studio_lifecycle_config_name(input.into());
            self
        }
        /// <p>The name of the Studio Lifecycle Configuration to describe.</p>
        pub fn set_studio_lifecycle_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_studio_lifecycle_config_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSubscribedWorkteam`.
    ///
    /// <p>Gets information about a work team provided by a vendor. It returns details about the subscription with a vendor in the Amazon Web Services Marketplace.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSubscribedWorkteam<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_subscribed_workteam_input::Builder,
    }
    impl<C, M, R> DescribeSubscribedWorkteam<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSubscribedWorkteam`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSubscribedWorkteamOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSubscribedWorkteamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSubscribedWorkteamInputOperationOutputAlias,
                crate::output::DescribeSubscribedWorkteamOutput,
                crate::error::DescribeSubscribedWorkteamError,
                crate::input::DescribeSubscribedWorkteamInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the subscribed work team to describe.</p>
        pub fn workteam_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workteam_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the subscribed work team to describe.</p>
        pub fn set_workteam_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workteam_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTrainingJob`.
    ///
    /// <p>Returns information about a training job. </p>
    /// <p>Some of the attributes below only appear if the training job successfully starts. If the training job fails, <code>TrainingJobStatus</code> is <code>Failed</code> and, depending on the <code>FailureReason</code>, attributes like <code>TrainingStartTime</code>, <code>TrainingTimeInSeconds</code>, <code>TrainingEndTime</code>, and <code>BillableTimeInSeconds</code> may not be present in the response.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTrainingJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_training_job_input::Builder,
    }
    impl<C, M, R> DescribeTrainingJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTrainingJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTrainingJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTrainingJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTrainingJobInputOperationOutputAlias,
                crate::output::DescribeTrainingJobOutput,
                crate::error::DescribeTrainingJobError,
                crate::input::DescribeTrainingJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the training job.</p>
        pub fn training_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.training_job_name(input.into());
            self
        }
        /// <p>The name of the training job.</p>
        pub fn set_training_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_training_job_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTransformJob`.
    ///
    /// <p>Returns information about a transform job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTransformJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_transform_job_input::Builder,
    }
    impl<C, M, R> DescribeTransformJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTransformJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTransformJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTransformJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTransformJobInputOperationOutputAlias,
                crate::output::DescribeTransformJobOutput,
                crate::error::DescribeTransformJobError,
                crate::input::DescribeTransformJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the transform job that you want to view details of.</p>
        pub fn transform_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transform_job_name(input.into());
            self
        }
        /// <p>The name of the transform job that you want to view details of.</p>
        pub fn set_transform_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transform_job_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTrial`.
    ///
    /// <p>Provides a list of a trial's properties.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTrial<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_trial_input::Builder,
    }
    impl<C, M, R> DescribeTrial<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTrial`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTrialOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTrialError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTrialInputOperationOutputAlias,
                crate::output::DescribeTrialOutput,
                crate::error::DescribeTrialError,
                crate::input::DescribeTrialInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the trial to describe.</p>
        pub fn trial_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trial_name(input.into());
            self
        }
        /// <p>The name of the trial to describe.</p>
        pub fn set_trial_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_trial_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTrialComponent`.
    ///
    /// <p>Provides a list of a trials component's properties.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTrialComponent<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_trial_component_input::Builder,
    }
    impl<C, M, R> DescribeTrialComponent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTrialComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTrialComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTrialComponentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTrialComponentInputOperationOutputAlias,
                crate::output::DescribeTrialComponentOutput,
                crate::error::DescribeTrialComponentError,
                crate::input::DescribeTrialComponentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the trial component to describe.</p>
        pub fn trial_component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trial_component_name(input.into());
            self
        }
        /// <p>The name of the trial component to describe.</p>
        pub fn set_trial_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_trial_component_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUserProfile`.
    ///
    /// <p>Describes a user profile. For more information, see <code>CreateUserProfile</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeUserProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_user_profile_input::Builder,
    }
    impl<C, M, R> DescribeUserProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeUserProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUserProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUserProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeUserProfileInputOperationOutputAlias,
                crate::output::DescribeUserProfileOutput,
                crate::error::DescribeUserProfileError,
                crate::input::DescribeUserProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain ID.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id(input.into());
            self
        }
        /// <p>The domain ID.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_id(input);
            self
        }
        /// <p>The user profile name. This value is not case sensitive.</p>
        pub fn user_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_profile_name(input.into());
            self
        }
        /// <p>The user profile name. This value is not case sensitive.</p>
        pub fn set_user_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_user_profile_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorkforce`.
    ///
    /// <p>Lists private workforce information, including workforce name, Amazon Resource Name (ARN), and, if applicable, allowed IP address ranges (<a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>). Allowable IP address ranges are the IP addresses that workers can use to access tasks. </p> <important>
    /// <p>This operation applies only to private workforces.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWorkforce<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_workforce_input::Builder,
    }
    impl<C, M, R> DescribeWorkforce<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeWorkforce`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorkforceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorkforceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeWorkforceInputOperationOutputAlias,
                crate::output::DescribeWorkforceOutput,
                crate::error::DescribeWorkforceError,
                crate::input::DescribeWorkforceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the private workforce whose access you want to restrict. <code>WorkforceName</code> is automatically set to <code>default</code> when a workforce is created and cannot be modified. </p>
        pub fn workforce_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workforce_name(input.into());
            self
        }
        /// <p>The name of the private workforce whose access you want to restrict. <code>WorkforceName</code> is automatically set to <code>default</code> when a workforce is created and cannot be modified. </p>
        pub fn set_workforce_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_workforce_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeWorkteam`.
    ///
    /// <p>Gets information about a specific work team. You can see information such as the create date, the last updated date, membership information, and the work team's Amazon Resource Name (ARN).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeWorkteam<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_workteam_input::Builder,
    }
    impl<C, M, R> DescribeWorkteam<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeWorkteam`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeWorkteamOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeWorkteamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeWorkteamInputOperationOutputAlias,
                crate::output::DescribeWorkteamOutput,
                crate::error::DescribeWorkteamError,
                crate::input::DescribeWorkteamInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the work team to return a description of.</p>
        pub fn workteam_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workteam_name(input.into());
            self
        }
        /// <p>The name of the work team to return a description of.</p>
        pub fn set_workteam_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_workteam_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableSagemakerServicecatalogPortfolio`.
    ///
    /// <p>Disables using Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableSagemakerServicecatalogPortfolio<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_sagemaker_servicecatalog_portfolio_input::Builder,
    }
    impl<C, M, R> DisableSagemakerServicecatalogPortfolio<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableSagemakerServicecatalogPortfolio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableSagemakerServicecatalogPortfolioOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisableSagemakerServicecatalogPortfolioError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableSagemakerServicecatalogPortfolioInputOperationOutputAlias,
                crate::output::DisableSagemakerServicecatalogPortfolioOutput,
                crate::error::DisableSagemakerServicecatalogPortfolioError,
                crate::input::DisableSagemakerServicecatalogPortfolioInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DisassociateTrialComponent`.
    ///
    /// <p>Disassociates a trial component from a trial. This doesn't effect other trials the component is associated with. Before you can delete a component, you must disassociate the component from all trials it is associated with. To associate a trial component with a trial, call the <code>AssociateTrialComponent</code> API.</p>
    /// <p>To get a list of the trials a component is associated with, use the <code>Search</code> API. Specify <code>ExperimentTrialComponent</code> for the <code>Resource</code> parameter. The list appears in the response under <code>Results.TrialComponent.Parents</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateTrialComponent<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_trial_component_input::Builder,
    }
    impl<C, M, R> DisassociateTrialComponent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateTrialComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateTrialComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateTrialComponentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateTrialComponentInputOperationOutputAlias,
                crate::output::DisassociateTrialComponentOutput,
                crate::error::DisassociateTrialComponentError,
                crate::input::DisassociateTrialComponentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the component to disassociate from the trial.</p>
        pub fn trial_component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trial_component_name(input.into());
            self
        }
        /// <p>The name of the component to disassociate from the trial.</p>
        pub fn set_trial_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_trial_component_name(input);
            self
        }
        /// <p>The name of the trial to disassociate from.</p>
        pub fn trial_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.trial_name(input.into());
            self
        }
        /// <p>The name of the trial to disassociate from.</p>
        pub fn set_trial_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_trial_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableSagemakerServicecatalogPortfolio`.
    ///
    /// <p>Enables using Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableSagemakerServicecatalogPortfolio<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_sagemaker_servicecatalog_portfolio_input::Builder,
    }
    impl<C, M, R> EnableSagemakerServicecatalogPortfolio<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableSagemakerServicecatalogPortfolio`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableSagemakerServicecatalogPortfolioOutput,
            aws_smithy_http::result::SdkError<
                crate::error::EnableSagemakerServicecatalogPortfolioError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableSagemakerServicecatalogPortfolioInputOperationOutputAlias,
                crate::output::EnableSagemakerServicecatalogPortfolioOutput,
                crate::error::EnableSagemakerServicecatalogPortfolioError,
                crate::input::EnableSagemakerServicecatalogPortfolioInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetDeviceFleetReport`.
    ///
    /// <p>Describes a fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDeviceFleetReport<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_device_fleet_report_input::Builder,
    }
    impl<C, M, R> GetDeviceFleetReport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDeviceFleetReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDeviceFleetReportOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDeviceFleetReportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDeviceFleetReportInputOperationOutputAlias,
                crate::output::GetDeviceFleetReportOutput,
                crate::error::GetDeviceFleetReportError,
                crate::input::GetDeviceFleetReportInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet.</p>
        pub fn device_fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_fleet_name(input.into());
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_device_fleet_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_device_fleet_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLineageGroupPolicy`.
    ///
    /// <p>The resource policy for the lineage group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLineageGroupPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_lineage_group_policy_input::Builder,
    }
    impl<C, M, R> GetLineageGroupPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLineageGroupPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLineageGroupPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLineageGroupPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLineageGroupPolicyInputOperationOutputAlias,
                crate::output::GetLineageGroupPolicyOutput,
                crate::error::GetLineageGroupPolicyError,
                crate::input::GetLineageGroupPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or Amazon Resource Name (ARN) of the lineage group.</p>
        pub fn lineage_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lineage_group_name(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the lineage group.</p>
        pub fn set_lineage_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_lineage_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetModelPackageGroupPolicy`.
    ///
    /// <p>Gets a resource policy that manages access for a model group. For information about resource policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html">Identity-based policies and resource-based policies</a> in the <i>Amazon Web Services Identity and Access Management User Guide.</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetModelPackageGroupPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_model_package_group_policy_input::Builder,
    }
    impl<C, M, R> GetModelPackageGroupPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetModelPackageGroupPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetModelPackageGroupPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetModelPackageGroupPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetModelPackageGroupPolicyInputOperationOutputAlias,
                crate::output::GetModelPackageGroupPolicyOutput,
                crate::error::GetModelPackageGroupPolicyError,
                crate::input::GetModelPackageGroupPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the model group for which to get the resource policy.</p>
        pub fn model_package_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_package_group_name(input.into());
            self
        }
        /// <p>The name of the model group for which to get the resource policy.</p>
        pub fn set_model_package_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_package_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSagemakerServicecatalogPortfolioStatus`.
    ///
    /// <p>Gets the status of Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSagemakerServicecatalogPortfolioStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_sagemaker_servicecatalog_portfolio_status_input::Builder,
    }
    impl<C, M, R> GetSagemakerServicecatalogPortfolioStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSagemakerServicecatalogPortfolioStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSagemakerServicecatalogPortfolioStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetSagemakerServicecatalogPortfolioStatusError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSagemakerServicecatalogPortfolioStatusInputOperationOutputAlias,
                crate::output::GetSagemakerServicecatalogPortfolioStatusOutput,
                crate::error::GetSagemakerServicecatalogPortfolioStatusError,
                crate::input::GetSagemakerServicecatalogPortfolioStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetSearchSuggestions`.
    ///
    /// <p>An auto-complete API for the search functionality in the Amazon SageMaker console. It returns suggestions of possible matches for the property name to use in <code>Search</code> queries. Provides suggestions for <code>HyperParameters</code>, <code>Tags</code>, and <code>Metrics</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSearchSuggestions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_search_suggestions_input::Builder,
    }
    impl<C, M, R> GetSearchSuggestions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSearchSuggestions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSearchSuggestionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSearchSuggestionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSearchSuggestionsInputOperationOutputAlias,
                crate::output::GetSearchSuggestionsOutput,
                crate::error::GetSearchSuggestionsError,
                crate::input::GetSearchSuggestionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon SageMaker resource to search for.</p>
        pub fn resource(mut self, input: crate::model::ResourceType) -> Self {
            self.inner = self.inner.resource(input);
            self
        }
        /// <p>The name of the Amazon SageMaker resource to search for.</p>
        pub fn set_resource(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
        /// <p>Limits the property names that are included in the response.</p>
        pub fn suggestion_query(mut self, input: crate::model::SuggestionQuery) -> Self {
            self.inner = self.inner.suggestion_query(input);
            self
        }
        /// <p>Limits the property names that are included in the response.</p>
        pub fn set_suggestion_query(
            mut self,
            input: std::option::Option<crate::model::SuggestionQuery>,
        ) -> Self {
            self.inner = self.inner.set_suggestion_query(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListActions`.
    ///
    /// <p>Lists the actions in your account and their properties.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListActions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_actions_input::Builder,
    }
    impl<C, M, R> ListActions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListActions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListActionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListActionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListActionsInputOperationOutputAlias,
                crate::output::ListActionsOutput,
                crate::error::ListActionsError,
                crate::input::ListActionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListActionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListActionsPaginator<C, M, R> {
            crate::paginator::ListActionsPaginator::new(self.handle, self.inner)
        }
        /// <p>A filter that returns only actions with the specified source URI.</p>
        pub fn source_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_uri(input.into());
            self
        }
        /// <p>A filter that returns only actions with the specified source URI.</p>
        pub fn set_source_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_uri(input);
            self
        }
        /// <p>A filter that returns only actions of the specified type.</p>
        pub fn action_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_type(input.into());
            self
        }
        /// <p>A filter that returns only actions of the specified type.</p>
        pub fn set_action_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action_type(input);
            self
        }
        /// <p>A filter that returns only actions created on or after the specified time.</p>
        pub fn created_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.created_after(input);
            self
        }
        /// <p>A filter that returns only actions created on or after the specified time.</p>
        pub fn set_created_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_created_after(input);
            self
        }
        /// <p>A filter that returns only actions created on or before the specified time.</p>
        pub fn created_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.created_before(input);
            self
        }
        /// <p>A filter that returns only actions created on or before the specified time.</p>
        pub fn set_created_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_created_before(input);
            self
        }
        /// <p>The property used to sort results. The default value is <code>CreationTime</code>.</p>
        pub fn sort_by(mut self, input: crate::model::SortActionsBy) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>The property used to sort results. The default value is <code>CreationTime</code>.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::SortActionsBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The sort order. The default value is <code>Descending</code>.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>The sort order. The default value is <code>Descending</code>.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>If the previous call to <code>ListActions</code> didn't return the full set of actions, the call returns a token for getting the next set of actions.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous call to <code>ListActions</code> didn't return the full set of actions, the call returns a token for getting the next set of actions.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of actions to return in the response. The default value is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of actions to return in the response. The default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAlgorithms`.
    ///
    /// <p>Lists the machine learning algorithms that have been created.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAlgorithms<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_algorithms_input::Builder,
    }
    impl<C, M, R> ListAlgorithms<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAlgorithms`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAlgorithmsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAlgorithmsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAlgorithmsInputOperationOutputAlias,
                crate::output::ListAlgorithmsOutput,
                crate::error::ListAlgorithmsError,
                crate::input::ListAlgorithmsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAlgorithmsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAlgorithmsPaginator<C, M, R> {
            crate::paginator::ListAlgorithmsPaginator::new(self.handle, self.inner)
        }
        /// <p>A filter that returns only algorithms created after the specified time (timestamp).</p>
        pub fn creation_time_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.creation_time_after(input);
            self
        }
        /// <p>A filter that returns only algorithms created after the specified time (timestamp).</p>
        pub fn set_creation_time_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_creation_time_after(input);
            self
        }
        /// <p>A filter that returns only algorithms created before the specified time (timestamp).</p>
        pub fn creation_time_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.creation_time_before(input);
            self
        }
        /// <p>A filter that returns only algorithms created before the specified time (timestamp).</p>
        pub fn set_creation_time_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_creation_time_before(input);
            self
        }
        /// <p>The maximum number of algorithms to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of algorithms to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A string in the algorithm name. This filter returns only algorithms whose name contains the specified string.</p>
        pub fn name_contains(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_contains(input.into());
            self
        }
        /// <p>A string in the algorithm name. This filter returns only algorithms whose name contains the specified string.</p>
        pub fn set_name_contains(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_name_contains(input);
            self
        }
        /// <p>If the response to a previous <code>ListAlgorithms</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of algorithms, use the token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the response to a previous <code>ListAlgorithms</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of algorithms, use the token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The parameter by which to sort the results. The default is <code>CreationTime</code>.</p>
        pub fn sort_by(mut self, input: crate::model::AlgorithmSortBy) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>The parameter by which to sort the results. The default is <code>CreationTime</code>.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::AlgorithmSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The sort order for the results. The default is <code>Ascending</code>.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>The sort order for the results. The default is <code>Ascending</code>.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAppImageConfigs`.
    ///
    /// <p>Lists the AppImageConfigs in your account and their properties. The list can be filtered by creation time or modified time, and whether the AppImageConfig name contains a specified string.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAppImageConfigs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_app_image_configs_input::Builder,
    }
    impl<C, M, R> ListAppImageConfigs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAppImageConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppImageConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppImageConfigsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAppImageConfigsInputOperationOutputAlias,
                crate::output::ListAppImageConfigsOutput,
                crate::error::ListAppImageConfigsError,
                crate::input::ListAppImageConfigsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAppImageConfigsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAppImageConfigsPaginator<C, M, R> {
            crate::paginator::ListAppImageConfigsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of AppImageConfigs to return in the response. The default value is 10. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of AppImageConfigs to return in the response. The default value is 10. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the previous call to <code>ListImages</code> didn't return the full set of AppImageConfigs, the call returns a token for getting the next set of AppImageConfigs.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous call to <code>ListImages</code> didn't return the full set of AppImageConfigs, the call returns a token for getting the next set of AppImageConfigs.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A filter that returns only AppImageConfigs whose name contains the specified string.</p>
        pub fn name_contains(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_contains(input.into());
            self
        }
        /// <p>A filter that returns only AppImageConfigs whose name contains the specified string.</p>
        pub fn set_name_contains(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_name_contains(input);
            self
        }
        /// <p>A filter that returns only AppImageConfigs created on or before the specified time.</p>
        pub fn creation_time_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.creation_time_before(input);
            self
        }
        /// <p>A filter that returns only AppImageConfigs created on or before the specified time.</p>
        pub fn set_creation_time_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_creation_time_before(input);
            self
        }
        /// <p>A filter that returns only AppImageConfigs created on or after the specified time.</p>
        pub fn creation_time_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.creation_time_after(input);
            self
        }
        /// <p>A filter that returns only AppImageConfigs created on or after the specified time.</p>
        pub fn set_creation_time_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_creation_time_after(input);
            self
        }
        /// <p>A filter that returns only AppImageConfigs modified on or before the specified time.</p>
        pub fn modified_time_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.modified_time_before(input);
            self
        }
        /// <p>A filter that returns only AppImageConfigs modified on or before the specified time.</p>
        pub fn set_modified_time_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_modified_time_before(input);
            self
        }
        /// <p>A filter that returns only AppImageConfigs modified on or after the specified time.</p>
        pub fn modified_time_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.modified_time_after(input);
            self
        }
        /// <p>A filter that returns only AppImageConfigs modified on or after the specified time.</p>
        pub fn set_modified_time_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_modified_time_after(input);
            self
        }
        /// <p>The property used to sort results. The default value is <code>CreationTime</code>.</p>
        pub fn sort_by(mut self, input: crate::model::AppImageConfigSortKey) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>The property used to sort results. The default value is <code>CreationTime</code>.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::AppImageConfigSortKey>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The sort order. The default value is <code>Descending</code>.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>The sort order. The default value is <code>Descending</code>.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApps`.
    ///
    /// <p>Lists apps.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListApps<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_apps_input::Builder,
    }
    impl<C, M, R> ListApps<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListApps`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAppsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAppsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAppsInputOperationOutputAlias,
                crate::output::ListAppsOutput,
                crate::error::ListAppsError,
                crate::input::ListAppsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAppsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAppsPaginator<C, M, R> {
            crate::paginator::ListAppsPaginator::new(self.handle, self.inner)
        }
        /// <p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Returns a list up to a specified limit.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Returns a list up to a specified limit.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The sort order for the results. The default is Ascending.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>The sort order for the results. The default is Ascending.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>The parameter by which to sort the results. The default is CreationTime.</p>
        pub fn sort_by(mut self, input: crate::model::AppSortKey) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>The parameter by which to sort the results. The default is CreationTime.</p>
        pub fn set_sort_by(mut self, input: std::option::Option<crate::model::AppSortKey>) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>A parameter to search for the domain ID.</p>
        pub fn domain_id_equals(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_id_equals(input.into());
            self
        }
        /// <p>A parameter to search for the domain ID.</p>
        pub fn set_domain_id_equals(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_domain_id_equals(input);
            self
        }
        /// <p>A parameter to search by user profile name.</p>
        pub fn user_profile_name_equals(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_profile_name_equals(input.into());
            self
        }
        /// <p>A parameter to search by user profile name.</p>
        pub fn set_user_profile_name_equals(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_user_profile_name_equals(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListArtifacts`.
    ///
    /// <p>Lists the artifacts in your account and their properties.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListArtifacts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_artifacts_input::Builder,
    }
    impl<C, M, R> ListArtifacts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListArtifacts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListArtifactsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListArtifactsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListArtifactsInputOperationOutputAlias,
                crate::output::ListArtifactsOutput,
                crate::error::ListArtifactsError,
                crate::input::ListArtifactsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListArtifactsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListArtifactsPaginator<C, M, R> {
            crate::paginator::ListArtifactsPaginator::new(self.handle, self.inner)
        }
        /// <p>A filter that returns only artifacts with the specified source URI.</p>
        pub fn source_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_uri(input.into());
            self
        }
        /// <p>A filter that returns only artifacts with the specified source URI.</p>
        pub fn set_source_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_uri(input);
            self
        }
        /// <p>A filter that returns only artifacts of the specified type.</p>
        pub fn artifact_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.artifact_type(input.into());
            self
        }
        /// <p>A filter that returns only artifacts of the specified type.</p>
        pub fn set_artifact_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_artifact_type(input);
            self
        }
        /// <p>A filter that returns only artifacts created on or after the specified time.</p>
        pub fn created_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.created_after(input);
            self
        }
        /// <p>A filter that returns only artifacts created on or after the specified time.</p>
        pub fn set_created_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_created_after(input);
            self
        }
        /// <p>A filter that returns only artifacts created on or before the specified time.</p>
        pub fn created_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.created_before(input);
            self
        }
        /// <p>A filter that returns only artifacts created on or before the specified time.</p>
        pub fn set_created_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_created_before(input);
            self
        }
        /// <p>The property used to sort results. The default value is <code>CreationTime</code>.</p>
        pub fn sort_by(mut self, input: crate::model::SortArtifactsBy) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>The property used to sort results. The default value is <code>CreationTime</code>.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::SortArtifactsBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The sort order. The default value is <code>Descending</code>.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>The sort order. The default value is <code>Descending</code>.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>If the previous call to <code>ListArtifacts</code> didn't return the full set of artifacts, the call returns a token for getting the next set of artifacts.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous call to <code>ListArtifacts</code> didn't return the full set of artifacts, the call returns a token for getting the next set of artifacts.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of artifacts to return in the response. The default value is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of artifacts to return in the response. The default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssociations`.
    ///
    /// <p>Lists the associations in your account and their properties.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAssociations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_associations_input::Builder,
    }
    impl<C, M, R> ListAssociations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssociationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAssociationsInputOperationOutputAlias,
                crate::output::ListAssociationsOutput,
                crate::error::ListAssociationsError,
                crate::input::ListAssociationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAssociationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAssociationsPaginator<C, M, R> {
            crate::paginator::ListAssociationsPaginator::new(self.handle, self.inner)
        }
        /// <p>A filter that returns only associations with the specified source ARN.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_arn(input.into());
            self
        }
        /// <p>A filter that returns only associations with the specified source ARN.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_arn(input);
            self
        }
        /// <p>A filter that returns only associations with the specified destination Amazon Resource Name (ARN).</p>
        pub fn destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_arn(input.into());
            self
        }
        /// <p>A filter that returns only associations with the specified destination Amazon Resource Name (ARN).</p>
        pub fn set_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_arn(input);
            self
        }
        /// <p>A filter that returns only associations with the specified source type.</p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_type(input.into());
            self
        }
        /// <p>A filter that returns only associations with the specified source type.</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// <p>A filter that returns only associations with the specified destination type.</p>
        pub fn destination_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_type(input.into());
            self
        }
        /// <p>A filter that returns only associations with the specified destination type.</p>
        pub fn set_destination_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_type(input);
            self
        }
        /// <p>A filter that returns only associations of the specified type.</p>
        pub fn association_type(mut self, input: crate::model::AssociationEdgeType) -> Self {
            self.inner = self.inner.association_type(input);
            self
        }
        /// <p>A filter that returns only associations of the specified type.</p>
        pub fn set_association_type(
            mut self,
            input: std::option::Option<crate::model::AssociationEdgeType>,
        ) -> Self {
            self.inner = self.inner.set_association_type(input);
            self
        }
        /// <p>A filter that returns only associations created on or after the specified time.</p>
        pub fn created_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.created_after(input);
            self
        }
        /// <p>A filter that returns only associations created on or after the specified time.</p>
        pub fn set_created_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_created_after(input);
            self
        }
        /// <p>A filter that returns only associations created on or before the specified time.</p>
        pub fn created_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.created_before(input);
            self
        }
        /// <p>A filter that returns only associations created on or before the specified time.</p>
        pub fn set_created_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_created_before(input);
            self
        }
        /// <p>The property used to sort results. The default value is <code>CreationTime</code>.</p>
        pub fn sort_by(mut self, input: crate::model::SortAssociationsBy) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>The property used to sort results. The default value is <code>CreationTime</code>.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::SortAssociationsBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The sort order. The default value is <code>Descending</code>.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>The sort order. The default value is <code>Descending</code>.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>If the previous call to <code>ListAssociations</code> didn't return the full set of associations, the call returns a token for getting the next set of associations.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous call to <code>ListAssociations</code> didn't return the full set of associations, the call returns a token for getting the next set of associations.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of associations to return in the response. The default value is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of associations to return in the response. The default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAutoMLJobs`.
    ///
    /// <p>Request a list of jobs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAutoMLJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_auto_ml_jobs_input::Builder,
    }
    impl<C, M, R> ListAutoMLJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAutoMLJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAutoMlJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAutoMLJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAutoMlJobsInputOperationOutputAlias,
                crate::output::ListAutoMlJobsOutput,
                crate::error::ListAutoMLJobsError,
                crate::input::ListAutoMlJobsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAutoMlJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAutoMlJobsPaginator<C, M, R> {
            crate::paginator::ListAutoMlJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>Request a list of jobs, using a filter for time.</p>
        pub fn creation_time_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.creation_time_after(input);
            self
        }
        /// <p>Request a list of jobs, using a filter for time.</p>
        pub fn set_creation_time_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_creation_time_after(input);
            self
        }
        /// <p>Request a list of jobs, using a filter for time.</p>
        pub fn creation_time_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.creation_time_before(input);
            self
        }
        /// <p>Request a list of jobs, using a filter for time.</p>
        pub fn set_creation_time_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_creation_time_before(input);
            self
        }
        /// <p>Request a list of jobs, using a filter for time.</p>
        pub fn last_modified_time_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.last_modified_time_after(input);
            self
        }
        /// <p>Request a list of jobs, using a filter for time.</p>
        pub fn set_last_modified_time_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_last_modified_time_after(input);
            self
        }
        /// <p>Request a list of jobs, using a filter for time.</p>
        pub fn last_modified_time_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.last_modified_time_before(input);
            self
        }
        /// <p>Request a list of jobs, using a filter for time.</p>
        pub fn set_last_modified_time_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_last_modified_time_before(input);
            self
        }
        /// <p>Request a list of jobs, using a search filter for name.</p>
        pub fn name_contains(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_contains(input.into());
            self
        }
        /// <p>Request a list of jobs, using a search filter for name.</p>
        pub fn set_name_contains(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_name_contains(input);
            self
        }
        /// <p>Request a list of jobs, using a filter for status.</p>
        pub fn status_equals(mut self, input: crate::model::AutoMlJobStatus) -> Self {
            self.inner = self.inner.status_equals(input);
            self
        }
        /// <p>Request a list of jobs, using a filter for status.</p>
        pub fn set_status_equals(
            mut self,
            input: std::option::Option<crate::model::AutoMlJobStatus>,
        ) -> Self {
            self.inner = self.inner.set_status_equals(input);
            self
        }
        /// <p>The sort order for the results. The default is <code>Descending</code>.</p>
        pub fn sort_order(mut self, input: crate::model::AutoMlSortOrder) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>The sort order for the results. The default is <code>Descending</code>.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::AutoMlSortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>The parameter by which to sort the results. The default is <code>Name</code>.</p>
        pub fn sort_by(mut self, input: crate::model::AutoMlSortBy) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>The parameter by which to sort the results. The default is <code>Name</code>.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::AutoMlSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>Request a list of jobs up to a specified limit.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Request a list of jobs up to a specified limit.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCandidatesForAutoMLJob`.
    ///
    /// <p>List the candidates created for the job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCandidatesForAutoMLJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_candidates_for_auto_ml_job_input::Builder,
    }
    impl<C, M, R> ListCandidatesForAutoMLJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCandidatesForAutoMLJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCandidatesForAutoMlJobOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCandidatesForAutoMLJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCandidatesForAutoMlJobInputOperationOutputAlias,
                crate::output::ListCandidatesForAutoMlJobOutput,
                crate::error::ListCandidatesForAutoMLJobError,
                crate::input::ListCandidatesForAutoMlJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCandidatesForAutoMlJobPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListCandidatesForAutoMlJobPaginator<C, M, R> {
            crate::paginator::ListCandidatesForAutoMlJobPaginator::new(self.handle, self.inner)
        }
        /// <p>List the candidates created for the job by providing the job's name.</p>
        pub fn auto_ml_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.auto_ml_job_name(input.into());
            self
        }
        /// <p>List the candidates created for the job by providing the job's name.</p>
        pub fn set_auto_ml_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_auto_ml_job_name(input);
            self
        }
        /// <p>List the candidates for the job and filter by status.</p>
        pub fn status_equals(mut self, input: crate::model::CandidateStatus) -> Self {
            self.inner = self.inner.status_equals(input);
            self
        }
        /// <p>List the candidates for the job and filter by status.</p>
        pub fn set_status_equals(
            mut self,
            input: std::option::Option<crate::model::CandidateStatus>,
        ) -> Self {
            self.inner = self.inner.set_status_equals(input);
            self
        }
        /// <p>List the candidates for the job and filter by candidate name.</p>
        pub fn candidate_name_equals(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.candidate_name_equals(input.into());
            self
        }
        /// <p>List the candidates for the job and filter by candidate name.</p>
        pub fn set_candidate_name_equals(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_candidate_name_equals(input);
            self
        }
        /// <p>The sort order for the results. The default is <code>Ascending</code>.</p>
        pub fn sort_order(mut self, input: crate::model::AutoMlSortOrder) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>The sort order for the results. The default is <code>Ascending</code>.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::AutoMlSortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>The parameter by which to sort the results. The default is <code>Descending</code>.</p>
        pub fn sort_by(mut self, input: crate::model::CandidateSortBy) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>The parameter by which to sort the results. The default is <code>Descending</code>.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::CandidateSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>List the job's candidates up to a specified limit.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>List the job's candidates up to a specified limit.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCodeRepositories`.
    ///
    /// <p>Gets a list of the Git repositories in your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCodeRepositories<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_code_repositories_input::Builder,
    }
    impl<C, M, R> ListCodeRepositories<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCodeRepositories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCodeRepositoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCodeRepositoriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCodeRepositoriesInputOperationOutputAlias,
                crate::output::ListCodeRepositoriesOutput,
                crate::error::ListCodeRepositoriesError,
                crate::input::ListCodeRepositoriesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCodeRepositoriesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCodeRepositoriesPaginator<C, M, R> {
            crate::paginator::ListCodeRepositoriesPaginator::new(self.handle, self.inner)
        }
        /// <p>A filter that returns only Git repositories that were created after the specified time.</p>
        pub fn creation_time_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.creation_time_after(input);
            self
        }
        /// <p>A filter that returns only Git repositories that were created after the specified time.</p>
        pub fn set_creation_time_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_creation_time_after(input);
            self
        }
        /// <p>A filter that returns only Git repositories that were created before the specified time.</p>
        pub fn creation_time_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.creation_time_before(input);
            self
        }
        /// <p>A filter that returns only Git repositories that were created before the specified time.</p>
        pub fn set_creation_time_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_creation_time_before(input);
            self
        }
        /// <p>A filter that returns only Git repositories that were last modified after the specified time.</p>
        pub fn last_modified_time_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.last_modified_time_after(input);
            self
        }
        /// <p>A filter that returns only Git repositories that were last modified after the specified time.</p>
        pub fn set_last_modified_time_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_last_modified_time_after(input);
            self
        }
        /// <p>A filter that returns only Git repositories that were last modified before the specified time.</p>
        pub fn last_modified_time_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.last_modified_time_before(input);
            self
        }
        /// <p>A filter that returns only Git repositories that were last modified before the specified time.</p>
        pub fn set_last_modified_time_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_last_modified_time_before(input);
            self
        }
        /// <p>The maximum number of Git repositories to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of Git repositories to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A string in the Git repositories name. This filter returns only repositories whose name contains the specified string.</p>
        pub fn name_contains(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_contains(input.into());
            self
        }
        /// <p>A string in the Git repositories name. This filter returns only repositories whose name contains the specified string.</p>
        pub fn set_name_contains(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_name_contains(input);
            self
        }
        /// <p>If the result of a <code>ListCodeRepositoriesOutput</code> request was truncated, the response includes a <code>NextToken</code>. To get the next set of Git repositories, use the token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the result of a <code>ListCodeRepositoriesOutput</code> request was truncated, the response includes a <code>NextToken</code>. To get the next set of Git repositories, use the token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The field to sort results by. The default is <code>Name</code>.</p>
        pub fn sort_by(mut self, input: crate::model::CodeRepositorySortBy) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>The field to sort results by. The default is <code>Name</code>.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::CodeRepositorySortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The sort order for results. The default is <code>Ascending</code>.</p>
        pub fn sort_order(mut self, input: crate::model::CodeRepositorySortOrder) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>The sort order for results. The default is <code>Ascending</code>.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::CodeRepositorySortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCompilationJobs`.
    ///
    /// <p>Lists model compilation jobs that satisfy various filters.</p>
    /// <p>To create a model compilation job, use <code>CreateCompilationJob</code>. To get information about a particular model compilation job you have created, use <code>DescribeCompilationJob</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCompilationJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_compilation_jobs_input::Builder,
    }
    impl<C, M, R> ListCompilationJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCompilationJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCompilationJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCompilationJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCompilationJobsInputOperationOutputAlias,
                crate::output::ListCompilationJobsOutput,
                crate::error::ListCompilationJobsError,
                crate::input::ListCompilationJobsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCompilationJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCompilationJobsPaginator<C, M, R> {
            crate::paginator::ListCompilationJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>If the result of the previous <code>ListCompilationJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of model compilation jobs, use the token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the result of the previous <code>ListCompilationJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of model compilation jobs, use the token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of model compilation jobs to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of model compilation jobs to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A filter that returns the model compilation jobs that were created after a specified time. </p>
        pub fn creation_time_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.creation_time_after(input);
            self
        }
        /// <p>A filter that returns the model compilation jobs that were created after a specified time. </p>
        pub fn set_creation_time_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_creation_time_after(input);
            self
        }
        /// <p>A filter that returns the model compilation jobs that were created before a specified time.</p>
        pub fn creation_time_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.creation_time_before(input);
            self
        }
        /// <p>A filter that returns the model compilation jobs that were created before a specified time.</p>
        pub fn set_creation_time_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_creation_time_before(input);
            self
        }
        /// <p>A filter that returns the model compilation jobs that were modified after a specified time.</p>
        pub fn last_modified_time_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.last_modified_time_after(input);
            self
        }
        /// <p>A filter that returns the model compilation jobs that were modified after a specified time.</p>
        pub fn set_last_modified_time_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_last_modified_time_after(input);
            self
        }
        /// <p>A filter that returns the model compilation jobs that were modified before a specified time.</p>
        pub fn last_modified_time_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.last_modified_time_before(input);
            self
        }
        /// <p>A filter that returns the model compilation jobs that were modified before a specified time.</p>
        pub fn set_last_modified_time_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_last_modified_time_before(input);
            self
        }
        /// <p>A filter that returns the model compilation jobs whose name contains a specified string.</p>
        pub fn name_contains(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_contains(input.into());
            self
        }
        /// <p>A filter that returns the model compilation jobs whose name contains a specified string.</p>
        pub fn set_name_contains(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_name_contains(input);
            self
        }
        /// <p>A filter that retrieves model compilation jobs with a specific <code>DescribeCompilationJobResponse$CompilationJobStatus</code> status.</p>
        pub fn status_equals(mut self, input: crate::model::CompilationJobStatus) -> Self {
            self.inner = self.inner.status_equals(input);
            self
        }
        /// <p>A filter that retrieves model compilation jobs with a specific <code>DescribeCompilationJobResponse$CompilationJobStatus</code> status.</p>
        pub fn set_status_equals(
            mut self,
            input: std::option::Option<crate::model::CompilationJobStatus>,
        ) -> Self {
            self.inner = self.inner.set_status_equals(input);
            self
        }
        /// <p>The field by which to sort results. The default is <code>CreationTime</code>.</p>
        pub fn sort_by(mut self, input: crate::model::ListCompilationJobsSortBy) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>The field by which to sort results. The default is <code>CreationTime</code>.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::ListCompilationJobsSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The sort order for results. The default is <code>Ascending</code>.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>The sort order for results. The default is <code>Ascending</code>.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListContexts`.
    ///
    /// <p>Lists the contexts in your account and their properties.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListContexts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_contexts_input::Builder,
    }
    impl<C, M, R> ListContexts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListContexts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListContextsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListContextsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListContextsInputOperationOutputAlias,
                crate::output::ListContextsOutput,
                crate::error::ListContextsError,
                crate::input::ListContextsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListContextsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListContextsPaginator<C, M, R> {
            crate::paginator::ListContextsPaginator::new(self.handle, self.inner)
        }
        /// <p>A filter that returns only contexts with the specified source URI.</p>
        pub fn source_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_uri(input.into());
            self
        }
        /// <p>A filter that returns only contexts with the specified source URI.</p>
        pub fn set_source_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_uri(input);
            self
        }
        /// <p>A filter that returns only contexts of the specified type.</p>
        pub fn context_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.context_type(input.into());
            self
        }
        /// <p>A filter that returns only contexts of the specified type.</p>
        pub fn set_context_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_context_type(input);
            self
        }
        /// <p>A filter that returns only contexts created on or after the specified time.</p>
        pub fn created_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.created_after(input);
            self
        }
        /// <p>A filter that returns only contexts created on or after the specified time.</p>
        pub fn set_created_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_created_after(input);
            self
        }
        /// <p>A filter that returns only contexts created on or before the specified time.</p>
        pub fn created_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.created_before(input);
            self
        }
        /// <p>A filter that returns only contexts created on or before the specified time.</p>
        pub fn set_created_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_created_before(input);
            self
        }
        /// <p>The property used to sort results. The default value is <code>CreationTime</code>.</p>
        pub fn sort_by(mut self, input: crate::model::SortContextsBy) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>The property used to sort results. The default value is <code>CreationTime</code>.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::SortContextsBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The sort order. The default value is <code>Descending</code>.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>The sort order. The default value is <code>Descending</code>.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>If the previous call to <code>ListContexts</code> didn't return the full set of contexts, the call returns a token for getting the next set of contexts.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous call to <code>ListContexts</code> didn't return the full set of contexts, the call returns a token for getting the next set of contexts.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of contexts to return in the response. The default value is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of contexts to return in the response. The default value is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDataQualityJobDefinitions`.
    ///
    /// <p>Lists the data quality job definitions in your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDataQualityJobDefinitions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_data_quality_job_definitions_input::Builder,
    }
    impl<C, M, R> ListDataQualityJobDefinitions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDataQualityJobDefinitions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDataQualityJobDefinitionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDataQualityJobDefinitionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDataQualityJobDefinitionsInputOperationOutputAlias,
                crate::output::ListDataQualityJobDefinitionsOutput,
                crate::error::ListDataQualityJobDefinitionsError,
                crate::input::ListDataQualityJobDefinitionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDataQualityJobDefinitionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListDataQualityJobDefinitionsPaginator<C, M, R> {
            crate::paginator::ListDataQualityJobDefinitionsPaginator::new(self.handle, self.inner)
        }
        /// <p>A filter that lists the data quality job definitions associated with the specified endpoint.</p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_name(input.into());
            self
        }
        /// <p>A filter that lists the data quality job definitions associated with the specified endpoint.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_name(input);
            self
        }
        /// <p>The field to sort results by. The default is <code>CreationTime</code>.</p>
        pub fn sort_by(mut self, input: crate::model::MonitoringJobDefinitionSortKey) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>The field to sort results by. The default is <code>CreationTime</code>.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::MonitoringJobDefinitionSortKey>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The sort order for results. The default is <code>Descending</code>.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>The sort order for results. The default is <code>Descending</code>.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>If the result of the previous <code>ListDataQualityJobDefinitions</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of transform jobs, use the token in the next request.&gt;</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the result of the previous <code>ListDataQualityJobDefinitions</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of transform jobs, use the token in the next request.&gt;</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of data quality monitoring job definitions to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of data quality monitoring job definitions to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A string in the data quality monitoring job definition name. This filter returns only data quality monitoring job definitions whose name contains the specified string.</p>
        pub fn name_contains(mut self, input: impl Into<std::string::