// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Provides details about a labeling work team.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Workteam {
    /// <p>The name of the work team.</p>
    pub workteam_name: std::option::Option<std::string::String>,
    /// <p>A list of <code>MemberDefinition</code> objects that contains objects that identify
    /// the workers that make up the work team. </p>
    /// <p>Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP).
    /// For private workforces created using Amazon Cognito use
    /// <code>CognitoMemberDefinition</code>. For workforces created using your own OIDC identity
    /// provider (IdP) use <code>OidcMemberDefinition</code>.</p>
    pub member_definitions: std::option::Option<std::vec::Vec<crate::model::MemberDefinition>>,
    /// <p>The Amazon Resource Name (ARN) that identifies the work team.</p>
    pub workteam_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the workforce.</p>
    pub workforce_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Marketplace identifier for a vendor's work team.</p>
    pub product_listing_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A description of the work team.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The URI of the labeling job's user interface. Workers open this URI to start labeling
    /// your data objects.</p>
    pub sub_domain: std::option::Option<std::string::String>,
    /// <p>The date and time that the work team was created (timestamp).</p>
    pub create_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the work team was last updated (timestamp).</p>
    pub last_updated_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Configures SNS notifications of available or expiring work items for work
    /// teams.</p>
    pub notification_configuration: std::option::Option<crate::model::NotificationConfiguration>,
}
impl Workteam {
    /// <p>The name of the work team.</p>
    pub fn workteam_name(&self) -> std::option::Option<&str> {
        self.workteam_name.as_deref()
    }
    /// <p>A list of <code>MemberDefinition</code> objects that contains objects that identify
    /// the workers that make up the work team. </p>
    /// <p>Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP).
    /// For private workforces created using Amazon Cognito use
    /// <code>CognitoMemberDefinition</code>. For workforces created using your own OIDC identity
    /// provider (IdP) use <code>OidcMemberDefinition</code>.</p>
    pub fn member_definitions(&self) -> std::option::Option<&[crate::model::MemberDefinition]> {
        self.member_definitions.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) that identifies the work team.</p>
    pub fn workteam_arn(&self) -> std::option::Option<&str> {
        self.workteam_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the workforce.</p>
    pub fn workforce_arn(&self) -> std::option::Option<&str> {
        self.workforce_arn.as_deref()
    }
    /// <p>The Amazon Marketplace identifier for a vendor's work team.</p>
    pub fn product_listing_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.product_listing_ids.as_deref()
    }
    /// <p>A description of the work team.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The URI of the labeling job's user interface. Workers open this URI to start labeling
    /// your data objects.</p>
    pub fn sub_domain(&self) -> std::option::Option<&str> {
        self.sub_domain.as_deref()
    }
    /// <p>The date and time that the work team was created (timestamp).</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_date.as_ref()
    }
    /// <p>The date and time that the work team was last updated (timestamp).</p>
    pub fn last_updated_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date.as_ref()
    }
    /// <p>Configures SNS notifications of available or expiring work items for work
    /// teams.</p>
    pub fn notification_configuration(
        &self,
    ) -> std::option::Option<&crate::model::NotificationConfiguration> {
        self.notification_configuration.as_ref()
    }
}
impl std::fmt::Debug for Workteam {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Workteam");
        formatter.field("workteam_name", &self.workteam_name);
        formatter.field("member_definitions", &self.member_definitions);
        formatter.field("workteam_arn", &self.workteam_arn);
        formatter.field("workforce_arn", &self.workforce_arn);
        formatter.field("product_listing_ids", &self.product_listing_ids);
        formatter.field("description", &self.description);
        formatter.field("sub_domain", &self.sub_domain);
        formatter.field("create_date", &self.create_date);
        formatter.field("last_updated_date", &self.last_updated_date);
        formatter.field(
            "notification_configuration",
            &self.notification_configuration,
        );
        formatter.finish()
    }
}
/// See [`Workteam`](crate::model::Workteam)
pub mod workteam {
    /// A builder for [`Workteam`](crate::model::Workteam)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workteam_name: std::option::Option<std::string::String>,
        pub(crate) member_definitions:
            std::option::Option<std::vec::Vec<crate::model::MemberDefinition>>,
        pub(crate) workteam_arn: std::option::Option<std::string::String>,
        pub(crate) workforce_arn: std::option::Option<std::string::String>,
        pub(crate) product_listing_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) sub_domain: std::option::Option<std::string::String>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) notification_configuration:
            std::option::Option<crate::model::NotificationConfiguration>,
    }
    impl Builder {
        /// <p>The name of the work team.</p>
        pub fn workteam_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.workteam_name = Some(input.into());
            self
        }
        /// <p>The name of the work team.</p>
        pub fn set_workteam_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workteam_name = input;
            self
        }
        /// Appends an item to `member_definitions`.
        ///
        /// To override the contents of this collection use [`set_member_definitions`](Self::set_member_definitions).
        ///
        /// <p>A list of <code>MemberDefinition</code> objects that contains objects that identify
        /// the workers that make up the work team. </p>
        /// <p>Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP).
        /// For private workforces created using Amazon Cognito use
        /// <code>CognitoMemberDefinition</code>. For workforces created using your own OIDC identity
        /// provider (IdP) use <code>OidcMemberDefinition</code>.</p>
        pub fn member_definitions(
            mut self,
            input: impl Into<crate::model::MemberDefinition>,
        ) -> Self {
            let mut v = self.member_definitions.unwrap_or_default();
            v.push(input.into());
            self.member_definitions = Some(v);
            self
        }
        /// <p>A list of <code>MemberDefinition</code> objects that contains objects that identify
        /// the workers that make up the work team. </p>
        /// <p>Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP).
        /// For private workforces created using Amazon Cognito use
        /// <code>CognitoMemberDefinition</code>. For workforces created using your own OIDC identity
        /// provider (IdP) use <code>OidcMemberDefinition</code>.</p>
        pub fn set_member_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MemberDefinition>>,
        ) -> Self {
            self.member_definitions = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the work team.</p>
        pub fn workteam_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.workteam_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the work team.</p>
        pub fn set_workteam_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workteam_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the workforce.</p>
        pub fn workforce_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.workforce_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the workforce.</p>
        pub fn set_workforce_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workforce_arn = input;
            self
        }
        /// Appends an item to `product_listing_ids`.
        ///
        /// To override the contents of this collection use [`set_product_listing_ids`](Self::set_product_listing_ids).
        ///
        /// <p>The Amazon Marketplace identifier for a vendor's work team.</p>
        pub fn product_listing_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.product_listing_ids.unwrap_or_default();
            v.push(input.into());
            self.product_listing_ids = Some(v);
            self
        }
        /// <p>The Amazon Marketplace identifier for a vendor's work team.</p>
        pub fn set_product_listing_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.product_listing_ids = input;
            self
        }
        /// <p>A description of the work team.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the work team.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The URI of the labeling job's user interface. Workers open this URI to start labeling
        /// your data objects.</p>
        pub fn sub_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.sub_domain = Some(input.into());
            self
        }
        /// <p>The URI of the labeling job's user interface. Workers open this URI to start labeling
        /// your data objects.</p>
        pub fn set_sub_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sub_domain = input;
            self
        }
        /// <p>The date and time that the work team was created (timestamp).</p>
        pub fn create_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time that the work team was created (timestamp).</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// <p>The date and time that the work team was last updated (timestamp).</p>
        pub fn last_updated_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date = Some(input);
            self
        }
        /// <p>The date and time that the work team was last updated (timestamp).</p>
        pub fn set_last_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date = input;
            self
        }
        /// <p>Configures SNS notifications of available or expiring work items for work
        /// teams.</p>
        pub fn notification_configuration(
            mut self,
            input: crate::model::NotificationConfiguration,
        ) -> Self {
            self.notification_configuration = Some(input);
            self
        }
        /// <p>Configures SNS notifications of available or expiring work items for work
        /// teams.</p>
        pub fn set_notification_configuration(
            mut self,
            input: std::option::Option<crate::model::NotificationConfiguration>,
        ) -> Self {
            self.notification_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`Workteam`](crate::model::Workteam)
        pub fn build(self) -> crate::model::Workteam {
            crate::model::Workteam {
                workteam_name: self.workteam_name,
                member_definitions: self.member_definitions,
                workteam_arn: self.workteam_arn,
                workforce_arn: self.workforce_arn,
                product_listing_ids: self.product_listing_ids,
                description: self.description,
                sub_domain: self.sub_domain,
                create_date: self.create_date,
                last_updated_date: self.last_updated_date,
                notification_configuration: self.notification_configuration,
            }
        }
    }
}
impl Workteam {
    /// Creates a new builder-style object to manufacture [`Workteam`](crate::model::Workteam)
    pub fn builder() -> crate::model::workteam::Builder {
        crate::model::workteam::Builder::default()
    }
}

/// <p>Configures Amazon SNS notifications of available or expiring work items for work
/// teams.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotificationConfiguration {
    /// <p>The ARN for the Amazon SNS topic to which notifications should be published.</p>
    pub notification_topic_arn: std::option::Option<std::string::String>,
}
impl NotificationConfiguration {
    /// <p>The ARN for the Amazon SNS topic to which notifications should be published.</p>
    pub fn notification_topic_arn(&self) -> std::option::Option<&str> {
        self.notification_topic_arn.as_deref()
    }
}
impl std::fmt::Debug for NotificationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotificationConfiguration");
        formatter.field("notification_topic_arn", &self.notification_topic_arn);
        formatter.finish()
    }
}
/// See [`NotificationConfiguration`](crate::model::NotificationConfiguration)
pub mod notification_configuration {
    /// A builder for [`NotificationConfiguration`](crate::model::NotificationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notification_topic_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN for the Amazon SNS topic to which notifications should be published.</p>
        pub fn notification_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_topic_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the Amazon SNS topic to which notifications should be published.</p>
        pub fn set_notification_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_topic_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`NotificationConfiguration`](crate::model::NotificationConfiguration)
        pub fn build(self) -> crate::model::NotificationConfiguration {
            crate::model::NotificationConfiguration {
                notification_topic_arn: self.notification_topic_arn,
            }
        }
    }
}
impl NotificationConfiguration {
    /// Creates a new builder-style object to manufacture [`NotificationConfiguration`](crate::model::NotificationConfiguration)
    pub fn builder() -> crate::model::notification_configuration::Builder {
        crate::model::notification_configuration::Builder::default()
    }
}

/// <p>Defines an Amazon Cognito or your own OIDC IdP user group that is part of a work team.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MemberDefinition {
    /// <p>The Amazon Cognito user group that is part of the work team.</p>
    pub cognito_member_definition: std::option::Option<crate::model::CognitoMemberDefinition>,
    /// <p>A list user groups that exist in your OIDC Identity Provider (IdP).
    /// One to ten groups can be used to create a single private work team.
    /// When you add a user group to the list of <code>Groups</code>, you can add that user group to one or more
    /// private work teams. If you add a user group to a private work team, all workers in that user group
    /// are added to the work team.</p>
    pub oidc_member_definition: std::option::Option<crate::model::OidcMemberDefinition>,
}
impl MemberDefinition {
    /// <p>The Amazon Cognito user group that is part of the work team.</p>
    pub fn cognito_member_definition(
        &self,
    ) -> std::option::Option<&crate::model::CognitoMemberDefinition> {
        self.cognito_member_definition.as_ref()
    }
    /// <p>A list user groups that exist in your OIDC Identity Provider (IdP).
    /// One to ten groups can be used to create a single private work team.
    /// When you add a user group to the list of <code>Groups</code>, you can add that user group to one or more
    /// private work teams. If you add a user group to a private work team, all workers in that user group
    /// are added to the work team.</p>
    pub fn oidc_member_definition(
        &self,
    ) -> std::option::Option<&crate::model::OidcMemberDefinition> {
        self.oidc_member_definition.as_ref()
    }
}
impl std::fmt::Debug for MemberDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MemberDefinition");
        formatter.field("cognito_member_definition", &self.cognito_member_definition);
        formatter.field("oidc_member_definition", &self.oidc_member_definition);
        formatter.finish()
    }
}
/// See [`MemberDefinition`](crate::model::MemberDefinition)
pub mod member_definition {
    /// A builder for [`MemberDefinition`](crate::model::MemberDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cognito_member_definition:
            std::option::Option<crate::model::CognitoMemberDefinition>,
        pub(crate) oidc_member_definition: std::option::Option<crate::model::OidcMemberDefinition>,
    }
    impl Builder {
        /// <p>The Amazon Cognito user group that is part of the work team.</p>
        pub fn cognito_member_definition(
            mut self,
            input: crate::model::CognitoMemberDefinition,
        ) -> Self {
            self.cognito_member_definition = Some(input);
            self
        }
        /// <p>The Amazon Cognito user group that is part of the work team.</p>
        pub fn set_cognito_member_definition(
            mut self,
            input: std::option::Option<crate::model::CognitoMemberDefinition>,
        ) -> Self {
            self.cognito_member_definition = input;
            self
        }
        /// <p>A list user groups that exist in your OIDC Identity Provider (IdP).
        /// One to ten groups can be used to create a single private work team.
        /// When you add a user group to the list of <code>Groups</code>, you can add that user group to one or more
        /// private work teams. If you add a user group to a private work team, all workers in that user group
        /// are added to the work team.</p>
        pub fn oidc_member_definition(mut self, input: crate::model::OidcMemberDefinition) -> Self {
            self.oidc_member_definition = Some(input);
            self
        }
        /// <p>A list user groups that exist in your OIDC Identity Provider (IdP).
        /// One to ten groups can be used to create a single private work team.
        /// When you add a user group to the list of <code>Groups</code>, you can add that user group to one or more
        /// private work teams. If you add a user group to a private work team, all workers in that user group
        /// are added to the work team.</p>
        pub fn set_oidc_member_definition(
            mut self,
            input: std::option::Option<crate::model::OidcMemberDefinition>,
        ) -> Self {
            self.oidc_member_definition = input;
            self
        }
        /// Consumes the builder and constructs a [`MemberDefinition`](crate::model::MemberDefinition)
        pub fn build(self) -> crate::model::MemberDefinition {
            crate::model::MemberDefinition {
                cognito_member_definition: self.cognito_member_definition,
                oidc_member_definition: self.oidc_member_definition,
            }
        }
    }
}
impl MemberDefinition {
    /// Creates a new builder-style object to manufacture [`MemberDefinition`](crate::model::MemberDefinition)
    pub fn builder() -> crate::model::member_definition::Builder {
        crate::model::member_definition::Builder::default()
    }
}

/// <p>A list of user groups that exist in your OIDC Identity Provider (IdP).
/// One to ten groups can be used to create a single private work team.
/// When you add a user group to the list of <code>Groups</code>, you can add that user group to one or more
/// private work teams. If you add a user group to a private work team, all workers in that user group
/// are added to the work team.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OidcMemberDefinition {
    /// <p>A list of comma seperated strings that identifies
    /// user groups in your OIDC IdP. Each user group is
    /// made up of a group of private workers.</p>
    pub groups: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl OidcMemberDefinition {
    /// <p>A list of comma seperated strings that identifies
    /// user groups in your OIDC IdP. Each user group is
    /// made up of a group of private workers.</p>
    pub fn groups(&self) -> std::option::Option<&[std::string::String]> {
        self.groups.as_deref()
    }
}
impl std::fmt::Debug for OidcMemberDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OidcMemberDefinition");
        formatter.field("groups", &self.groups);
        formatter.finish()
    }
}
/// See [`OidcMemberDefinition`](crate::model::OidcMemberDefinition)
pub mod oidc_member_definition {
    /// A builder for [`OidcMemberDefinition`](crate::model::OidcMemberDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) groups: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>A list of comma seperated strings that identifies
        /// user groups in your OIDC IdP. Each user group is
        /// made up of a group of private workers.</p>
        pub fn groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input.into());
            self.groups = Some(v);
            self
        }
        /// <p>A list of comma seperated strings that identifies
        /// user groups in your OIDC IdP. Each user group is
        /// made up of a group of private workers.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// Consumes the builder and constructs a [`OidcMemberDefinition`](crate::model::OidcMemberDefinition)
        pub fn build(self) -> crate::model::OidcMemberDefinition {
            crate::model::OidcMemberDefinition {
                groups: self.groups,
            }
        }
    }
}
impl OidcMemberDefinition {
    /// Creates a new builder-style object to manufacture [`OidcMemberDefinition`](crate::model::OidcMemberDefinition)
    pub fn builder() -> crate::model::oidc_member_definition::Builder {
        crate::model::oidc_member_definition::Builder::default()
    }
}

/// <p>Identifies a Amazon Cognito user group. A user group can be used in on or more work
/// teams.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CognitoMemberDefinition {
    /// <p>An identifier for a user pool. The user pool must be in the same region as the service
    /// that you are calling.</p>
    pub user_pool: std::option::Option<std::string::String>,
    /// <p>An identifier for a user group.</p>
    pub user_group: std::option::Option<std::string::String>,
    /// <p>An identifier for an application client. You must create the app client ID using
    /// Amazon Cognito.</p>
    pub client_id: std::option::Option<std::string::String>,
}
impl CognitoMemberDefinition {
    /// <p>An identifier for a user pool. The user pool must be in the same region as the service
    /// that you are calling.</p>
    pub fn user_pool(&self) -> std::option::Option<&str> {
        self.user_pool.as_deref()
    }
    /// <p>An identifier for a user group.</p>
    pub fn user_group(&self) -> std::option::Option<&str> {
        self.user_group.as_deref()
    }
    /// <p>An identifier for an application client. You must create the app client ID using
    /// Amazon Cognito.</p>
    pub fn client_id(&self) -> std::option::Option<&str> {
        self.client_id.as_deref()
    }
}
impl std::fmt::Debug for CognitoMemberDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CognitoMemberDefinition");
        formatter.field("user_pool", &self.user_pool);
        formatter.field("user_group", &self.user_group);
        formatter.field("client_id", &self.client_id);
        formatter.finish()
    }
}
/// See [`CognitoMemberDefinition`](crate::model::CognitoMemberDefinition)
pub mod cognito_member_definition {
    /// A builder for [`CognitoMemberDefinition`](crate::model::CognitoMemberDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool: std::option::Option<std::string::String>,
        pub(crate) user_group: std::option::Option<std::string::String>,
        pub(crate) client_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An identifier for a user pool. The user pool must be in the same region as the service
        /// that you are calling.</p>
        pub fn user_pool(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool = Some(input.into());
            self
        }
        /// <p>An identifier for a user pool. The user pool must be in the same region as the service
        /// that you are calling.</p>
        pub fn set_user_pool(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool = input;
            self
        }
        /// <p>An identifier for a user group.</p>
        pub fn user_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_group = Some(input.into());
            self
        }
        /// <p>An identifier for a user group.</p>
        pub fn set_user_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_group = input;
            self
        }
        /// <p>An identifier for an application client. You must create the app client ID using
        /// Amazon Cognito.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>An identifier for an application client. You must create the app client ID using
        /// Amazon Cognito.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CognitoMemberDefinition`](crate::model::CognitoMemberDefinition)
        pub fn build(self) -> crate::model::CognitoMemberDefinition {
            crate::model::CognitoMemberDefinition {
                user_pool: self.user_pool,
                user_group: self.user_group,
                client_id: self.client_id,
            }
        }
    }
}
impl CognitoMemberDefinition {
    /// Creates a new builder-style object to manufacture [`CognitoMemberDefinition`](crate::model::CognitoMemberDefinition)
    pub fn builder() -> crate::model::cognito_member_definition::Builder {
        crate::model::cognito_member_definition::Builder::default()
    }
}

/// <p>A single private workforce, which is automatically created when you create your first
/// private work team. You can create one private work force in each Amazon Web Services Region. By default,
/// any workforce-related API operation used in a specific region will apply to the
/// workforce created in that region. To learn how to create a private workforce, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html">Create a Private Workforce</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Workforce {
    /// <p>The name of the private workforce.</p>
    pub workforce_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the private workforce.</p>
    pub workforce_arn: std::option::Option<std::string::String>,
    /// <p>The most recent date that  was used to
    /// successfully add one or more IP address ranges (<a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>) to a private workforce's
    /// allow list.</p>
    pub last_updated_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A list of one to ten IP address ranges (<a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>) to be added to the
    /// workforce allow list. By default, a workforce isn't restricted to specific IP addresses.</p>
    pub source_ip_config: std::option::Option<crate::model::SourceIpConfig>,
    /// <p>The subdomain for your OIDC Identity Provider.</p>
    pub sub_domain: std::option::Option<std::string::String>,
    /// <p>The configuration of an Amazon Cognito workforce.
    /// A single Cognito workforce is created using and corresponds to a single
    /// <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">
    /// Amazon Cognito user pool</a>.</p>
    pub cognito_config: std::option::Option<crate::model::CognitoConfig>,
    /// <p>The configuration of an OIDC Identity Provider (IdP) private workforce.</p>
    pub oidc_config: std::option::Option<crate::model::OidcConfigForResponse>,
    /// <p>The date that the workforce is created.</p>
    pub create_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl Workforce {
    /// <p>The name of the private workforce.</p>
    pub fn workforce_name(&self) -> std::option::Option<&str> {
        self.workforce_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the private workforce.</p>
    pub fn workforce_arn(&self) -> std::option::Option<&str> {
        self.workforce_arn.as_deref()
    }
    /// <p>The most recent date that  was used to
    /// successfully add one or more IP address ranges (<a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>) to a private workforce's
    /// allow list.</p>
    pub fn last_updated_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date.as_ref()
    }
    /// <p>A list of one to ten IP address ranges (<a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>) to be added to the
    /// workforce allow list. By default, a workforce isn't restricted to specific IP addresses.</p>
    pub fn source_ip_config(&self) -> std::option::Option<&crate::model::SourceIpConfig> {
        self.source_ip_config.as_ref()
    }
    /// <p>The subdomain for your OIDC Identity Provider.</p>
    pub fn sub_domain(&self) -> std::option::Option<&str> {
        self.sub_domain.as_deref()
    }
    /// <p>The configuration of an Amazon Cognito workforce.
    /// A single Cognito workforce is created using and corresponds to a single
    /// <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">
    /// Amazon Cognito user pool</a>.</p>
    pub fn cognito_config(&self) -> std::option::Option<&crate::model::CognitoConfig> {
        self.cognito_config.as_ref()
    }
    /// <p>The configuration of an OIDC Identity Provider (IdP) private workforce.</p>
    pub fn oidc_config(&self) -> std::option::Option<&crate::model::OidcConfigForResponse> {
        self.oidc_config.as_ref()
    }
    /// <p>The date that the workforce is created.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_date.as_ref()
    }
}
impl std::fmt::Debug for Workforce {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Workforce");
        formatter.field("workforce_name", &self.workforce_name);
        formatter.field("workforce_arn", &self.workforce_arn);
        formatter.field("last_updated_date", &self.last_updated_date);
        formatter.field("source_ip_config", &self.source_ip_config);
        formatter.field("sub_domain", &self.sub_domain);
        formatter.field("cognito_config", &self.cognito_config);
        formatter.field("oidc_config", &self.oidc_config);
        formatter.field("create_date", &self.create_date);
        formatter.finish()
    }
}
/// See [`Workforce`](crate::model::Workforce)
pub mod workforce {
    /// A builder for [`Workforce`](crate::model::Workforce)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workforce_name: std::option::Option<std::string::String>,
        pub(crate) workforce_arn: std::option::Option<std::string::String>,
        pub(crate) last_updated_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) source_ip_config: std::option::Option<crate::model::SourceIpConfig>,
        pub(crate) sub_domain: std::option::Option<std::string::String>,
        pub(crate) cognito_config: std::option::Option<crate::model::CognitoConfig>,
        pub(crate) oidc_config: std::option::Option<crate::model::OidcConfigForResponse>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the private workforce.</p>
        pub fn workforce_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.workforce_name = Some(input.into());
            self
        }
        /// <p>The name of the private workforce.</p>
        pub fn set_workforce_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workforce_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the private workforce.</p>
        pub fn workforce_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.workforce_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the private workforce.</p>
        pub fn set_workforce_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workforce_arn = input;
            self
        }
        /// <p>The most recent date that  was used to
        /// successfully add one or more IP address ranges (<a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>) to a private workforce's
        /// allow list.</p>
        pub fn last_updated_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date = Some(input);
            self
        }
        /// <p>The most recent date that  was used to
        /// successfully add one or more IP address ranges (<a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>) to a private workforce's
        /// allow list.</p>
        pub fn set_last_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date = input;
            self
        }
        /// <p>A list of one to ten IP address ranges (<a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>) to be added to the
        /// workforce allow list. By default, a workforce isn't restricted to specific IP addresses.</p>
        pub fn source_ip_config(mut self, input: crate::model::SourceIpConfig) -> Self {
            self.source_ip_config = Some(input);
            self
        }
        /// <p>A list of one to ten IP address ranges (<a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>) to be added to the
        /// workforce allow list. By default, a workforce isn't restricted to specific IP addresses.</p>
        pub fn set_source_ip_config(
            mut self,
            input: std::option::Option<crate::model::SourceIpConfig>,
        ) -> Self {
            self.source_ip_config = input;
            self
        }
        /// <p>The subdomain for your OIDC Identity Provider.</p>
        pub fn sub_domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.sub_domain = Some(input.into());
            self
        }
        /// <p>The subdomain for your OIDC Identity Provider.</p>
        pub fn set_sub_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sub_domain = input;
            self
        }
        /// <p>The configuration of an Amazon Cognito workforce.
        /// A single Cognito workforce is created using and corresponds to a single
        /// <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">
        /// Amazon Cognito user pool</a>.</p>
        pub fn cognito_config(mut self, input: crate::model::CognitoConfig) -> Self {
            self.cognito_config = Some(input);
            self
        }
        /// <p>The configuration of an Amazon Cognito workforce.
        /// A single Cognito workforce is created using and corresponds to a single
        /// <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">
        /// Amazon Cognito user pool</a>.</p>
        pub fn set_cognito_config(
            mut self,
            input: std::option::Option<crate::model::CognitoConfig>,
        ) -> Self {
            self.cognito_config = input;
            self
        }
        /// <p>The configuration of an OIDC Identity Provider (IdP) private workforce.</p>
        pub fn oidc_config(mut self, input: crate::model::OidcConfigForResponse) -> Self {
            self.oidc_config = Some(input);
            self
        }
        /// <p>The configuration of an OIDC Identity Provider (IdP) private workforce.</p>
        pub fn set_oidc_config(
            mut self,
            input: std::option::Option<crate::model::OidcConfigForResponse>,
        ) -> Self {
            self.oidc_config = input;
            self
        }
        /// <p>The date that the workforce is created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date that the workforce is created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// Consumes the builder and constructs a [`Workforce`](crate::model::Workforce)
        pub fn build(self) -> crate::model::Workforce {
            crate::model::Workforce {
                workforce_name: self.workforce_name,
                workforce_arn: self.workforce_arn,
                last_updated_date: self.last_updated_date,
                source_ip_config: self.source_ip_config,
                sub_domain: self.sub_domain,
                cognito_config: self.cognito_config,
                oidc_config: self.oidc_config,
                create_date: self.create_date,
            }
        }
    }
}
impl Workforce {
    /// Creates a new builder-style object to manufacture [`Workforce`](crate::model::Workforce)
    pub fn builder() -> crate::model::workforce::Builder {
        crate::model::workforce::Builder::default()
    }
}

/// <p>Your OIDC IdP workforce configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OidcConfigForResponse {
    /// <p>The OIDC IdP client ID used to configure your private workforce.</p>
    pub client_id: std::option::Option<std::string::String>,
    /// <p>The OIDC IdP issuer used to configure your private workforce.</p>
    pub issuer: std::option::Option<std::string::String>,
    /// <p>The OIDC IdP authorization endpoint used to configure your private workforce.</p>
    pub authorization_endpoint: std::option::Option<std::string::String>,
    /// <p>The OIDC IdP token endpoint used to configure your private workforce.</p>
    pub token_endpoint: std::option::Option<std::string::String>,
    /// <p>The OIDC IdP user information endpoint used to configure your private workforce.</p>
    pub user_info_endpoint: std::option::Option<std::string::String>,
    /// <p>The OIDC IdP logout endpoint used to configure your private workforce.</p>
    pub logout_endpoint: std::option::Option<std::string::String>,
    /// <p>The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.</p>
    pub jwks_uri: std::option::Option<std::string::String>,
}
impl OidcConfigForResponse {
    /// <p>The OIDC IdP client ID used to configure your private workforce.</p>
    pub fn client_id(&self) -> std::option::Option<&str> {
        self.client_id.as_deref()
    }
    /// <p>The OIDC IdP issuer used to configure your private workforce.</p>
    pub fn issuer(&self) -> std::option::Option<&str> {
        self.issuer.as_deref()
    }
    /// <p>The OIDC IdP authorization endpoint used to configure your private workforce.</p>
    pub fn authorization_endpoint(&self) -> std::option::Option<&str> {
        self.authorization_endpoint.as_deref()
    }
    /// <p>The OIDC IdP token endpoint used to configure your private workforce.</p>
    pub fn token_endpoint(&self) -> std::option::Option<&str> {
        self.token_endpoint.as_deref()
    }
    /// <p>The OIDC IdP user information endpoint used to configure your private workforce.</p>
    pub fn user_info_endpoint(&self) -> std::option::Option<&str> {
        self.user_info_endpoint.as_deref()
    }
    /// <p>The OIDC IdP logout endpoint used to configure your private workforce.</p>
    pub fn logout_endpoint(&self) -> std::option::Option<&str> {
        self.logout_endpoint.as_deref()
    }
    /// <p>The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.</p>
    pub fn jwks_uri(&self) -> std::option::Option<&str> {
        self.jwks_uri.as_deref()
    }
}
impl std::fmt::Debug for OidcConfigForResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OidcConfigForResponse");
        formatter.field("client_id", &self.client_id);
        formatter.field("issuer", &self.issuer);
        formatter.field("authorization_endpoint", &self.authorization_endpoint);
        formatter.field("token_endpoint", &self.token_endpoint);
        formatter.field("user_info_endpoint", &self.user_info_endpoint);
        formatter.field("logout_endpoint", &self.logout_endpoint);
        formatter.field("jwks_uri", &self.jwks_uri);
        formatter.finish()
    }
}
/// See [`OidcConfigForResponse`](crate::model::OidcConfigForResponse)
pub mod oidc_config_for_response {
    /// A builder for [`OidcConfigForResponse`](crate::model::OidcConfigForResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) issuer: std::option::Option<std::string::String>,
        pub(crate) authorization_endpoint: std::option::Option<std::string::String>,
        pub(crate) token_endpoint: std::option::Option<std::string::String>,
        pub(crate) user_info_endpoint: std::option::Option<std::string::String>,
        pub(crate) logout_endpoint: std::option::Option<std::string::String>,
        pub(crate) jwks_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The OIDC IdP client ID used to configure your private workforce.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The OIDC IdP client ID used to configure your private workforce.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>The OIDC IdP issuer used to configure your private workforce.</p>
        pub fn issuer(mut self, input: impl Into<std::string::String>) -> Self {
            self.issuer = Some(input.into());
            self
        }
        /// <p>The OIDC IdP issuer used to configure your private workforce.</p>
        pub fn set_issuer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.issuer = input;
            self
        }
        /// <p>The OIDC IdP authorization endpoint used to configure your private workforce.</p>
        pub fn authorization_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorization_endpoint = Some(input.into());
            self
        }
        /// <p>The OIDC IdP authorization endpoint used to configure your private workforce.</p>
        pub fn set_authorization_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorization_endpoint = input;
            self
        }
        /// <p>The OIDC IdP token endpoint used to configure your private workforce.</p>
        pub fn token_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.token_endpoint = Some(input.into());
            self
        }
        /// <p>The OIDC IdP token endpoint used to configure your private workforce.</p>
        pub fn set_token_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.token_endpoint = input;
            self
        }
        /// <p>The OIDC IdP user information endpoint used to configure your private workforce.</p>
        pub fn user_info_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_info_endpoint = Some(input.into());
            self
        }
        /// <p>The OIDC IdP user information endpoint used to configure your private workforce.</p>
        pub fn set_user_info_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_info_endpoint = input;
            self
        }
        /// <p>The OIDC IdP logout endpoint used to configure your private workforce.</p>
        pub fn logout_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.logout_endpoint = Some(input.into());
            self
        }
        /// <p>The OIDC IdP logout endpoint used to configure your private workforce.</p>
        pub fn set_logout_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.logout_endpoint = input;
            self
        }
        /// <p>The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.</p>
        pub fn jwks_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.jwks_uri = Some(input.into());
            self
        }
        /// <p>The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.</p>
        pub fn set_jwks_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.jwks_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`OidcConfigForResponse`](crate::model::OidcConfigForResponse)
        pub fn build(self) -> crate::model::OidcConfigForResponse {
            crate::model::OidcConfigForResponse {
                client_id: self.client_id,
                issuer: self.issuer,
                authorization_endpoint: self.authorization_endpoint,
                token_endpoint: self.token_endpoint,
                user_info_endpoint: self.user_info_endpoint,
                logout_endpoint: self.logout_endpoint,
                jwks_uri: self.jwks_uri,
            }
        }
    }
}
impl OidcConfigForResponse {
    /// Creates a new builder-style object to manufacture [`OidcConfigForResponse`](crate::model::OidcConfigForResponse)
    pub fn builder() -> crate::model::oidc_config_for_response::Builder {
        crate::model::oidc_config_for_response::Builder::default()
    }
}

/// <p>Use this parameter to configure your Amazon Cognito workforce.
/// A single Cognito workforce is created using and corresponds to a single
/// <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">
/// Amazon Cognito user pool</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CognitoConfig {
    /// <p>A <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">
    /// user pool</a> is a user directory in Amazon Cognito.
    /// With a user pool, your users can sign in to your web or mobile app through Amazon Cognito.
    /// Your users can also sign in through social identity providers like
    /// Google, Facebook, Amazon, or Apple, and through SAML identity providers.</p>
    pub user_pool: std::option::Option<std::string::String>,
    /// <p>The client ID for your Amazon Cognito user pool.</p>
    pub client_id: std::option::Option<std::string::String>,
}
impl CognitoConfig {
    /// <p>A <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">
    /// user pool</a> is a user directory in Amazon Cognito.
    /// With a user pool, your users can sign in to your web or mobile app through Amazon Cognito.
    /// Your users can also sign in through social identity providers like
    /// Google, Facebook, Amazon, or Apple, and through SAML identity providers.</p>
    pub fn user_pool(&self) -> std::option::Option<&str> {
        self.user_pool.as_deref()
    }
    /// <p>The client ID for your Amazon Cognito user pool.</p>
    pub fn client_id(&self) -> std::option::Option<&str> {
        self.client_id.as_deref()
    }
}
impl std::fmt::Debug for CognitoConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CognitoConfig");
        formatter.field("user_pool", &self.user_pool);
        formatter.field("client_id", &self.client_id);
        formatter.finish()
    }
}
/// See [`CognitoConfig`](crate::model::CognitoConfig)
pub mod cognito_config {
    /// A builder for [`CognitoConfig`](crate::model::CognitoConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool: std::option::Option<std::string::String>,
        pub(crate) client_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">
        /// user pool</a> is a user directory in Amazon Cognito.
        /// With a user pool, your users can sign in to your web or mobile app through Amazon Cognito.
        /// Your users can also sign in through social identity providers like
        /// Google, Facebook, Amazon, or Apple, and through SAML identity providers.</p>
        pub fn user_pool(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool = Some(input.into());
            self
        }
        /// <p>A <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">
        /// user pool</a> is a user directory in Amazon Cognito.
        /// With a user pool, your users can sign in to your web or mobile app through Amazon Cognito.
        /// Your users can also sign in through social identity providers like
        /// Google, Facebook, Amazon, or Apple, and through SAML identity providers.</p>
        pub fn set_user_pool(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool = input;
            self
        }
        /// <p>The client ID for your Amazon Cognito user pool.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The client ID for your Amazon Cognito user pool.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CognitoConfig`](crate::model::CognitoConfig)
        pub fn build(self) -> crate::model::CognitoConfig {
            crate::model::CognitoConfig {
                user_pool: self.user_pool,
                client_id: self.client_id,
            }
        }
    }
}
impl CognitoConfig {
    /// Creates a new builder-style object to manufacture [`CognitoConfig`](crate::model::CognitoConfig)
    pub fn builder() -> crate::model::cognito_config::Builder {
        crate::model::cognito_config::Builder::default()
    }
}

/// <p>A list of IP address ranges (<a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>). Used to create an allow
/// list of IP addresses for a private workforce. Workers will only be able to login to their worker portal from an
/// IP address within this range. By default, a workforce isn't restricted to specific IP addresses.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceIpConfig {
    /// <p>A list of one to ten <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Classless Inter-Domain Routing</a> (CIDR) values.</p>
    /// <p>Maximum: Ten CIDR values</p>
    /// <note>
    /// <p>The following Length Constraints apply to individual CIDR values in
    /// the CIDR value list.</p>
    /// </note>
    pub cidrs: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl SourceIpConfig {
    /// <p>A list of one to ten <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Classless Inter-Domain Routing</a> (CIDR) values.</p>
    /// <p>Maximum: Ten CIDR values</p>
    /// <note>
    /// <p>The following Length Constraints apply to individual CIDR values in
    /// the CIDR value list.</p>
    /// </note>
    pub fn cidrs(&self) -> std::option::Option<&[std::string::String]> {
        self.cidrs.as_deref()
    }
}
impl std::fmt::Debug for SourceIpConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceIpConfig");
        formatter.field("cidrs", &self.cidrs);
        formatter.finish()
    }
}
/// See [`SourceIpConfig`](crate::model::SourceIpConfig)
pub mod source_ip_config {
    /// A builder for [`SourceIpConfig`](crate::model::SourceIpConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cidrs: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `cidrs`.
        ///
        /// To override the contents of this collection use [`set_cidrs`](Self::set_cidrs).
        ///
        /// <p>A list of one to ten <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Classless Inter-Domain Routing</a> (CIDR) values.</p>
        /// <p>Maximum: Ten CIDR values</p>
        /// <note>
        /// <p>The following Length Constraints apply to individual CIDR values in
        /// the CIDR value list.</p>
        /// </note>
        pub fn cidrs(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cidrs.unwrap_or_default();
            v.push(input.into());
            self.cidrs = Some(v);
            self
        }
        /// <p>A list of one to ten <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Classless Inter-Domain Routing</a> (CIDR) values.</p>
        /// <p>Maximum: Ten CIDR values</p>
        /// <note>
        /// <p>The following Length Constraints apply to individual CIDR values in
        /// the CIDR value list.</p>
        /// </note>
        pub fn set_cidrs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cidrs = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceIpConfig`](crate::model::SourceIpConfig)
        pub fn build(self) -> crate::model::SourceIpConfig {
            crate::model::SourceIpConfig { cidrs: self.cidrs }
        }
    }
}
impl SourceIpConfig {
    /// Creates a new builder-style object to manufacture [`SourceIpConfig`](crate::model::SourceIpConfig)
    pub fn builder() -> crate::model::source_ip_config::Builder {
        crate::model::source_ip_config::Builder::default()
    }
}

/// <p>Use this parameter to configure your OIDC Identity Provider (IdP).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OidcConfig {
    /// <p>The OIDC IdP client ID used to configure your private workforce.</p>
    pub client_id: std::option::Option<std::string::String>,
    /// <p>The OIDC IdP client secret used to configure your private workforce.</p>
    pub client_secret: std::option::Option<std::string::String>,
    /// <p>The OIDC IdP issuer used to configure your private workforce.</p>
    pub issuer: std::option::Option<std::string::String>,
    /// <p>The OIDC IdP authorization endpoint used to configure your private workforce.</p>
    pub authorization_endpoint: std::option::Option<std::string::String>,
    /// <p>The OIDC IdP token endpoint used to configure your private workforce.</p>
    pub token_endpoint: std::option::Option<std::string::String>,
    /// <p>The OIDC IdP user information endpoint used to configure your private workforce.</p>
    pub user_info_endpoint: std::option::Option<std::string::String>,
    /// <p>The OIDC IdP logout endpoint used to configure your private workforce.</p>
    pub logout_endpoint: std::option::Option<std::string::String>,
    /// <p>The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.</p>
    pub jwks_uri: std::option::Option<std::string::String>,
}
impl OidcConfig {
    /// <p>The OIDC IdP client ID used to configure your private workforce.</p>
    pub fn client_id(&self) -> std::option::Option<&str> {
        self.client_id.as_deref()
    }
    /// <p>The OIDC IdP client secret used to configure your private workforce.</p>
    pub fn client_secret(&self) -> std::option::Option<&str> {
        self.client_secret.as_deref()
    }
    /// <p>The OIDC IdP issuer used to configure your private workforce.</p>
    pub fn issuer(&self) -> std::option::Option<&str> {
        self.issuer.as_deref()
    }
    /// <p>The OIDC IdP authorization endpoint used to configure your private workforce.</p>
    pub fn authorization_endpoint(&self) -> std::option::Option<&str> {
        self.authorization_endpoint.as_deref()
    }
    /// <p>The OIDC IdP token endpoint used to configure your private workforce.</p>
    pub fn token_endpoint(&self) -> std::option::Option<&str> {
        self.token_endpoint.as_deref()
    }
    /// <p>The OIDC IdP user information endpoint used to configure your private workforce.</p>
    pub fn user_info_endpoint(&self) -> std::option::Option<&str> {
        self.user_info_endpoint.as_deref()
    }
    /// <p>The OIDC IdP logout endpoint used to configure your private workforce.</p>
    pub fn logout_endpoint(&self) -> std::option::Option<&str> {
        self.logout_endpoint.as_deref()
    }
    /// <p>The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.</p>
    pub fn jwks_uri(&self) -> std::option::Option<&str> {
        self.jwks_uri.as_deref()
    }
}
impl std::fmt::Debug for OidcConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OidcConfig");
        formatter.field("client_id", &self.client_id);
        formatter.field("client_secret", &"*** Sensitive Data Redacted ***");
        formatter.field("issuer", &self.issuer);
        formatter.field("authorization_endpoint", &self.authorization_endpoint);
        formatter.field("token_endpoint", &self.token_endpoint);
        formatter.field("user_info_endpoint", &self.user_info_endpoint);
        formatter.field("logout_endpoint", &self.logout_endpoint);
        formatter.field("jwks_uri", &self.jwks_uri);
        formatter.finish()
    }
}
/// See [`OidcConfig`](crate::model::OidcConfig)
pub mod oidc_config {
    /// A builder for [`OidcConfig`](crate::model::OidcConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) client_secret: std::option::Option<std::string::String>,
        pub(crate) issuer: std::option::Option<std::string::String>,
        pub(crate) authorization_endpoint: std::option::Option<std::string::String>,
        pub(crate) token_endpoint: std::option::Option<std::string::String>,
        pub(crate) user_info_endpoint: std::option::Option<std::string::String>,
        pub(crate) logout_endpoint: std::option::Option<std::string::String>,
        pub(crate) jwks_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The OIDC IdP client ID used to configure your private workforce.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The OIDC IdP client ID used to configure your private workforce.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>The OIDC IdP client secret used to configure your private workforce.</p>
        pub fn client_secret(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_secret = Some(input.into());
            self
        }
        /// <p>The OIDC IdP client secret used to configure your private workforce.</p>
        pub fn set_client_secret(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_secret = input;
            self
        }
        /// <p>The OIDC IdP issuer used to configure your private workforce.</p>
        pub fn issuer(mut self, input: impl Into<std::string::String>) -> Self {
            self.issuer = Some(input.into());
            self
        }
        /// <p>The OIDC IdP issuer used to configure your private workforce.</p>
        pub fn set_issuer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.issuer = input;
            self
        }
        /// <p>The OIDC IdP authorization endpoint used to configure your private workforce.</p>
        pub fn authorization_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorization_endpoint = Some(input.into());
            self
        }
        /// <p>The OIDC IdP authorization endpoint used to configure your private workforce.</p>
        pub fn set_authorization_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorization_endpoint = input;
            self
        }
        /// <p>The OIDC IdP token endpoint used to configure your private workforce.</p>
        pub fn token_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.token_endpoint = Some(input.into());
            self
        }
        /// <p>The OIDC IdP token endpoint used to configure your private workforce.</p>
        pub fn set_token_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.token_endpoint = input;
            self
        }
        /// <p>The OIDC IdP user information endpoint used to configure your private workforce.</p>
        pub fn user_info_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_info_endpoint = Some(input.into());
            self
        }
        /// <p>The OIDC IdP user information endpoint used to configure your private workforce.</p>
        pub fn set_user_info_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_info_endpoint = input;
            self
        }
        /// <p>The OIDC IdP logout endpoint used to configure your private workforce.</p>
        pub fn logout_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.logout_endpoint = Some(input.into());
            self
        }
        /// <p>The OIDC IdP logout endpoint used to configure your private workforce.</p>
        pub fn set_logout_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.logout_endpoint = input;
            self
        }
        /// <p>The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.</p>
        pub fn jwks_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.jwks_uri = Some(input.into());
            self
        }
        /// <p>The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.</p>
        pub fn set_jwks_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.jwks_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`OidcConfig`](crate::model::OidcConfig)
        pub fn build(self) -> crate::model::OidcConfig {
            crate::model::OidcConfig {
                client_id: self.client_id,
                client_secret: self.client_secret,
                issuer: self.issuer,
                authorization_endpoint: self.authorization_endpoint,
                token_endpoint: self.token_endpoint,
                user_info_endpoint: self.user_info_endpoint,
                logout_endpoint: self.logout_endpoint,
                jwks_uri: self.jwks_uri,
            }
        }
    }
}
impl OidcConfig {
    /// Creates a new builder-style object to manufacture [`OidcConfig`](crate::model::OidcConfig)
    pub fn builder() -> crate::model::oidc_config::Builder {
        crate::model::oidc_config::Builder::default()
    }
}

/// <p>A collection of settings that apply to users of Amazon SageMaker Studio. These settings are
/// specified when the <code>CreateUserProfile</code> API is called, and as <code>DefaultUserSettings</code>
/// when the <code>CreateDomain</code> API is called.</p>
/// <p>
/// <code>SecurityGroups</code> is aggregated when specified in both calls. For all other
/// settings in <code>UserSettings</code>, the values specified in <code>CreateUserProfile</code>
/// take precedence over those specified in <code>CreateDomain</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserSettings {
    /// <p>The execution role for the user.</p>
    pub execution_role: std::option::Option<std::string::String>,
    /// <p>The security groups for the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.</p>
    /// <p>Optional when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to
    /// <code>PublicInternetOnly</code>.</p>
    /// <p>Required when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to
    /// <code>VpcOnly</code>.</p>
    /// <p>Amazon SageMaker adds a security group to allow NFS traffic from SageMaker Studio. Therefore, the
    /// number of security groups that you can specify is one less than the maximum number shown.</p>
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies options for sharing SageMaker Studio notebooks.</p>
    pub sharing_settings: std::option::Option<crate::model::SharingSettings>,
    /// <p>The Jupyter server's app settings.</p>
    pub jupyter_server_app_settings: std::option::Option<crate::model::JupyterServerAppSettings>,
    /// <p>The kernel gateway app settings.</p>
    pub kernel_gateway_app_settings: std::option::Option<crate::model::KernelGatewayAppSettings>,
    /// <p>The TensorBoard app settings.</p>
    pub tensor_board_app_settings: std::option::Option<crate::model::TensorBoardAppSettings>,
    /// <p>A collection of settings that configure user interaction with the <code>RStudioServerPro</code> app.</p>
    pub r_studio_server_pro_app_settings:
        std::option::Option<crate::model::RStudioServerProAppSettings>,
    /// <p>A collection of settings that configure the <code>RSessionGateway</code> app.</p>
    pub r_session_app_settings: std::option::Option<crate::model::RSessionAppSettings>,
}
impl UserSettings {
    /// <p>The execution role for the user.</p>
    pub fn execution_role(&self) -> std::option::Option<&str> {
        self.execution_role.as_deref()
    }
    /// <p>The security groups for the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.</p>
    /// <p>Optional when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to
    /// <code>PublicInternetOnly</code>.</p>
    /// <p>Required when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to
    /// <code>VpcOnly</code>.</p>
    /// <p>Amazon SageMaker adds a security group to allow NFS traffic from SageMaker Studio. Therefore, the
    /// number of security groups that you can specify is one less than the maximum number shown.</p>
    pub fn security_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.security_groups.as_deref()
    }
    /// <p>Specifies options for sharing SageMaker Studio notebooks.</p>
    pub fn sharing_settings(&self) -> std::option::Option<&crate::model::SharingSettings> {
        self.sharing_settings.as_ref()
    }
    /// <p>The Jupyter server's app settings.</p>
    pub fn jupyter_server_app_settings(
        &self,
    ) -> std::option::Option<&crate::model::JupyterServerAppSettings> {
        self.jupyter_server_app_settings.as_ref()
    }
    /// <p>The kernel gateway app settings.</p>
    pub fn kernel_gateway_app_settings(
        &self,
    ) -> std::option::Option<&crate::model::KernelGatewayAppSettings> {
        self.kernel_gateway_app_settings.as_ref()
    }
    /// <p>The TensorBoard app settings.</p>
    pub fn tensor_board_app_settings(
        &self,
    ) -> std::option::Option<&crate::model::TensorBoardAppSettings> {
        self.tensor_board_app_settings.as_ref()
    }
    /// <p>A collection of settings that configure user interaction with the <code>RStudioServerPro</code> app.</p>
    pub fn r_studio_server_pro_app_settings(
        &self,
    ) -> std::option::Option<&crate::model::RStudioServerProAppSettings> {
        self.r_studio_server_pro_app_settings.as_ref()
    }
    /// <p>A collection of settings that configure the <code>RSessionGateway</code> app.</p>
    pub fn r_session_app_settings(
        &self,
    ) -> std::option::Option<&crate::model::RSessionAppSettings> {
        self.r_session_app_settings.as_ref()
    }
}
impl std::fmt::Debug for UserSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserSettings");
        formatter.field("execution_role", &self.execution_role);
        formatter.field("security_groups", &self.security_groups);
        formatter.field("sharing_settings", &self.sharing_settings);
        formatter.field(
            "jupyter_server_app_settings",
            &self.jupyter_server_app_settings,
        );
        formatter.field(
            "kernel_gateway_app_settings",
            &self.kernel_gateway_app_settings,
        );
        formatter.field("tensor_board_app_settings", &self.tensor_board_app_settings);
        formatter.field(
            "r_studio_server_pro_app_settings",
            &self.r_studio_server_pro_app_settings,
        );
        formatter.field("r_session_app_settings", &self.r_session_app_settings);
        formatter.finish()
    }
}
/// See [`UserSettings`](crate::model::UserSettings)
pub mod user_settings {
    /// A builder for [`UserSettings`](crate::model::UserSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) execution_role: std::option::Option<std::string::String>,
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) sharing_settings: std::option::Option<crate::model::SharingSettings>,
        pub(crate) jupyter_server_app_settings:
            std::option::Option<crate::model::JupyterServerAppSettings>,
        pub(crate) kernel_gateway_app_settings:
            std::option::Option<crate::model::KernelGatewayAppSettings>,
        pub(crate) tensor_board_app_settings:
            std::option::Option<crate::model::TensorBoardAppSettings>,
        pub(crate) r_studio_server_pro_app_settings:
            std::option::Option<crate::model::RStudioServerProAppSettings>,
        pub(crate) r_session_app_settings: std::option::Option<crate::model::RSessionAppSettings>,
    }
    impl Builder {
        /// <p>The execution role for the user.</p>
        pub fn execution_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role = Some(input.into());
            self
        }
        /// <p>The execution role for the user.</p>
        pub fn set_execution_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>The security groups for the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.</p>
        /// <p>Optional when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to
        /// <code>PublicInternetOnly</code>.</p>
        /// <p>Required when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to
        /// <code>VpcOnly</code>.</p>
        /// <p>Amazon SageMaker adds a security group to allow NFS traffic from SageMaker Studio. Therefore, the
        /// number of security groups that you can specify is one less than the maximum number shown.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>The security groups for the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.</p>
        /// <p>Optional when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to
        /// <code>PublicInternetOnly</code>.</p>
        /// <p>Required when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to
        /// <code>VpcOnly</code>.</p>
        /// <p>Amazon SageMaker adds a security group to allow NFS traffic from SageMaker Studio. Therefore, the
        /// number of security groups that you can specify is one less than the maximum number shown.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// <p>Specifies options for sharing SageMaker Studio notebooks.</p>
        pub fn sharing_settings(mut self, input: crate::model::SharingSettings) -> Self {
            self.sharing_settings = Some(input);
            self
        }
        /// <p>Specifies options for sharing SageMaker Studio notebooks.</p>
        pub fn set_sharing_settings(
            mut self,
            input: std::option::Option<crate::model::SharingSettings>,
        ) -> Self {
            self.sharing_settings = input;
            self
        }
        /// <p>The Jupyter server's app settings.</p>
        pub fn jupyter_server_app_settings(
            mut self,
            input: crate::model::JupyterServerAppSettings,
        ) -> Self {
            self.jupyter_server_app_settings = Some(input);
            self
        }
        /// <p>The Jupyter server's app settings.</p>
        pub fn set_jupyter_server_app_settings(
            mut self,
            input: std::option::Option<crate::model::JupyterServerAppSettings>,
        ) -> Self {
            self.jupyter_server_app_settings = input;
            self
        }
        /// <p>The kernel gateway app settings.</p>
        pub fn kernel_gateway_app_settings(
            mut self,
            input: crate::model::KernelGatewayAppSettings,
        ) -> Self {
            self.kernel_gateway_app_settings = Some(input);
            self
        }
        /// <p>The kernel gateway app settings.</p>
        pub fn set_kernel_gateway_app_settings(
            mut self,
            input: std::option::Option<crate::model::KernelGatewayAppSettings>,
        ) -> Self {
            self.kernel_gateway_app_settings = input;
            self
        }
        /// <p>The TensorBoard app settings.</p>
        pub fn tensor_board_app_settings(
            mut self,
            input: crate::model::TensorBoardAppSettings,
        ) -> Self {
            self.tensor_board_app_settings = Some(input);
            self
        }
        /// <p>The TensorBoard app settings.</p>
        pub fn set_tensor_board_app_settings(
            mut self,
            input: std::option::Option<crate::model::TensorBoardAppSettings>,
        ) -> Self {
            self.tensor_board_app_settings = input;
            self
        }
        /// <p>A collection of settings that configure user interaction with the <code>RStudioServerPro</code> app.</p>
        pub fn r_studio_server_pro_app_settings(
            mut self,
            input: crate::model::RStudioServerProAppSettings,
        ) -> Self {
            self.r_studio_server_pro_app_settings = Some(input);
            self
        }
        /// <p>A collection of settings that configure user interaction with the <code>RStudioServerPro</code> app.</p>
        pub fn set_r_studio_server_pro_app_settings(
            mut self,
            input: std::option::Option<crate::model::RStudioServerProAppSettings>,
        ) -> Self {
            self.r_studio_server_pro_app_settings = input;
            self
        }
        /// <p>A collection of settings that configure the <code>RSessionGateway</code> app.</p>
        pub fn r_session_app_settings(mut self, input: crate::model::RSessionAppSettings) -> Self {
            self.r_session_app_settings = Some(input);
            self
        }
        /// <p>A collection of settings that configure the <code>RSessionGateway</code> app.</p>
        pub fn set_r_session_app_settings(
            mut self,
            input: std::option::Option<crate::model::RSessionAppSettings>,
        ) -> Self {
            self.r_session_app_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`UserSettings`](crate::model::UserSettings)
        pub fn build(self) -> crate::model::UserSettings {
            crate::model::UserSettings {
                execution_role: self.execution_role,
                security_groups: self.security_groups,
                sharing_settings: self.sharing_settings,
                jupyter_server_app_settings: self.jupyter_server_app_settings,
                kernel_gateway_app_settings: self.kernel_gateway_app_settings,
                tensor_board_app_settings: self.tensor_board_app_settings,
                r_studio_server_pro_app_settings: self.r_studio_server_pro_app_settings,
                r_session_app_settings: self.r_session_app_settings,
            }
        }
    }
}
impl UserSettings {
    /// Creates a new builder-style object to manufacture [`UserSettings`](crate::model::UserSettings)
    pub fn builder() -> crate::model::user_settings::Builder {
        crate::model::user_settings::Builder::default()
    }
}

/// <p>A collection of settings that apply to an <code>RSessionGateway</code> app.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RSessionAppSettings {}
impl std::fmt::Debug for RSessionAppSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RSessionAppSettings");
        formatter.finish()
    }
}
/// See [`RSessionAppSettings`](crate::model::RSessionAppSettings)
pub mod r_session_app_settings {
    /// A builder for [`RSessionAppSettings`](crate::model::RSessionAppSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RSessionAppSettings`](crate::model::RSessionAppSettings)
        pub fn build(self) -> crate::model::RSessionAppSettings {
            crate::model::RSessionAppSettings {}
        }
    }
}
impl RSessionAppSettings {
    /// Creates a new builder-style object to manufacture [`RSessionAppSettings`](crate::model::RSessionAppSettings)
    pub fn builder() -> crate::model::r_session_app_settings::Builder {
        crate::model::r_session_app_settings::Builder::default()
    }
}

/// <p>A collection of settings that configure user interaction with the <code>RStudioServerPro</code> app. <code>RStudioServerProAppSettings</code> cannot be updated. The <code>RStudioServerPro</code> app must be deleted and a new one created to make any changes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RStudioServerProAppSettings {
    /// <p>Indicates whether the current user has access to the <code>RStudioServerPro</code> app.</p>
    pub access_status: std::option::Option<crate::model::RStudioServerProAccessStatus>,
    /// <p>The level of permissions that the user has within the <code>RStudioServerPro</code> app. This value defaults to `User`. The `Admin` value allows the user access to the RStudio Administrative Dashboard.</p>
    pub user_group: std::option::Option<crate::model::RStudioServerProUserGroup>,
}
impl RStudioServerProAppSettings {
    /// <p>Indicates whether the current user has access to the <code>RStudioServerPro</code> app.</p>
    pub fn access_status(
        &self,
    ) -> std::option::Option<&crate::model::RStudioServerProAccessStatus> {
        self.access_status.as_ref()
    }
    /// <p>The level of permissions that the user has within the <code>RStudioServerPro</code> app. This value defaults to `User`. The `Admin` value allows the user access to the RStudio Administrative Dashboard.</p>
    pub fn user_group(&self) -> std::option::Option<&crate::model::RStudioServerProUserGroup> {
        self.user_group.as_ref()
    }
}
impl std::fmt::Debug for RStudioServerProAppSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RStudioServerProAppSettings");
        formatter.field("access_status", &self.access_status);
        formatter.field("user_group", &self.user_group);
        formatter.finish()
    }
}
/// See [`RStudioServerProAppSettings`](crate::model::RStudioServerProAppSettings)
pub mod r_studio_server_pro_app_settings {
    /// A builder for [`RStudioServerProAppSettings`](crate::model::RStudioServerProAppSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_status: std::option::Option<crate::model::RStudioServerProAccessStatus>,
        pub(crate) user_group: std::option::Option<crate::model::RStudioServerProUserGroup>,
    }
    impl Builder {
        /// <p>Indicates whether the current user has access to the <code>RStudioServerPro</code> app.</p>
        pub fn access_status(mut self, input: crate::model::RStudioServerProAccessStatus) -> Self {
            self.access_status = Some(input);
            self
        }
        /// <p>Indicates whether the current user has access to the <code>RStudioServerPro</code> app.</p>
        pub fn set_access_status(
            mut self,
            input: std::option::Option<crate::model::RStudioServerProAccessStatus>,
        ) -> Self {
            self.access_status = input;
            self
        }
        /// <p>The level of permissions that the user has within the <code>RStudioServerPro</code> app. This value defaults to `User`. The `Admin` value allows the user access to the RStudio Administrative Dashboard.</p>
        pub fn user_group(mut self, input: crate::model::RStudioServerProUserGroup) -> Self {
            self.user_group = Some(input);
            self
        }
        /// <p>The level of permissions that the user has within the <code>RStudioServerPro</code> app. This value defaults to `User`. The `Admin` value allows the user access to the RStudio Administrative Dashboard.</p>
        pub fn set_user_group(
            mut self,
            input: std::option::Option<crate::model::RStudioServerProUserGroup>,
        ) -> Self {
            self.user_group = input;
            self
        }
        /// Consumes the builder and constructs a [`RStudioServerProAppSettings`](crate::model::RStudioServerProAppSettings)
        pub fn build(self) -> crate::model::RStudioServerProAppSettings {
            crate::model::RStudioServerProAppSettings {
                access_status: self.access_status,
                user_group: self.user_group,
            }
        }
    }
}
impl RStudioServerProAppSettings {
    /// Creates a new builder-style object to manufacture [`RStudioServerProAppSettings`](crate::model::RStudioServerProAppSettings)
    pub fn builder() -> crate::model::r_studio_server_pro_app_settings::Builder {
        crate::model::r_studio_server_pro_app_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RStudioServerProUserGroup {
    #[allow(missing_docs)] // documentation missing in model
    Admin,
    #[allow(missing_docs)] // documentation missing in model
    User,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RStudioServerProUserGroup {
    fn from(s: &str) -> Self {
        match s {
            "R_STUDIO_ADMIN" => RStudioServerProUserGroup::Admin,
            "R_STUDIO_USER" => RStudioServerProUserGroup::User,
            other => RStudioServerProUserGroup::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RStudioServerProUserGroup {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RStudioServerProUserGroup::from(s))
    }
}
impl RStudioServerProUserGroup {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RStudioServerProUserGroup::Admin => "R_STUDIO_ADMIN",
            RStudioServerProUserGroup::User => "R_STUDIO_USER",
            RStudioServerProUserGroup::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["R_STUDIO_ADMIN", "R_STUDIO_USER"]
    }
}
impl AsRef<str> for RStudioServerProUserGroup {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RStudioServerProAccessStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RStudioServerProAccessStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => RStudioServerProAccessStatus::Disabled,
            "ENABLED" => RStudioServerProAccessStatus::Enabled,
            other => RStudioServerProAccessStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RStudioServerProAccessStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RStudioServerProAccessStatus::from(s))
    }
}
impl RStudioServerProAccessStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RStudioServerProAccessStatus::Disabled => "DISABLED",
            RStudioServerProAccessStatus::Enabled => "ENABLED",
            RStudioServerProAccessStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for RStudioServerProAccessStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The TensorBoard app settings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TensorBoardAppSettings {
    /// <p>The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.</p>
    pub default_resource_spec: std::option::Option<crate::model::ResourceSpec>,
}
impl TensorBoardAppSettings {
    /// <p>The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.</p>
    pub fn default_resource_spec(&self) -> std::option::Option<&crate::model::ResourceSpec> {
        self.default_resource_spec.as_ref()
    }
}
impl std::fmt::Debug for TensorBoardAppSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TensorBoardAppSettings");
        formatter.field("default_resource_spec", &self.default_resource_spec);
        formatter.finish()
    }
}
/// See [`TensorBoardAppSettings`](crate::model::TensorBoardAppSettings)
pub mod tensor_board_app_settings {
    /// A builder for [`TensorBoardAppSettings`](crate::model::TensorBoardAppSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_resource_spec: std::option::Option<crate::model::ResourceSpec>,
    }
    impl Builder {
        /// <p>The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.</p>
        pub fn default_resource_spec(mut self, input: crate::model::ResourceSpec) -> Self {
            self.default_resource_spec = Some(input);
            self
        }
        /// <p>The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.</p>
        pub fn set_default_resource_spec(
            mut self,
            input: std::option::Option<crate::model::ResourceSpec>,
        ) -> Self {
            self.default_resource_spec = input;
            self
        }
        /// Consumes the builder and constructs a [`TensorBoardAppSettings`](crate::model::TensorBoardAppSettings)
        pub fn build(self) -> crate::model::TensorBoardAppSettings {
            crate::model::TensorBoardAppSettings {
                default_resource_spec: self.default_resource_spec,
            }
        }
    }
}
impl TensorBoardAppSettings {
    /// Creates a new builder-style object to manufacture [`TensorBoardAppSettings`](crate::model::TensorBoardAppSettings)
    pub fn builder() -> crate::model::tensor_board_app_settings::Builder {
        crate::model::tensor_board_app_settings::Builder::default()
    }
}

/// <p>Specifies the ARN's of a SageMaker image and SageMaker image version, and the instance type that
/// the version runs on.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceSpec {
    /// <p>The ARN of the SageMaker image that the image version belongs to.</p>
    pub sage_maker_image_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the image version created on the instance.</p>
    pub sage_maker_image_version_arn: std::option::Option<std::string::String>,
    /// <p>The instance type that the image version runs on.</p>
    pub instance_type: std::option::Option<crate::model::AppInstanceType>,
    /// <p> The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.</p>
    pub lifecycle_config_arn: std::option::Option<std::string::String>,
}
impl ResourceSpec {
    /// <p>The ARN of the SageMaker image that the image version belongs to.</p>
    pub fn sage_maker_image_arn(&self) -> std::option::Option<&str> {
        self.sage_maker_image_arn.as_deref()
    }
    /// <p>The ARN of the image version created on the instance.</p>
    pub fn sage_maker_image_version_arn(&self) -> std::option::Option<&str> {
        self.sage_maker_image_version_arn.as_deref()
    }
    /// <p>The instance type that the image version runs on.</p>
    pub fn instance_type(&self) -> std::option::Option<&crate::model::AppInstanceType> {
        self.instance_type.as_ref()
    }
    /// <p> The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.</p>
    pub fn lifecycle_config_arn(&self) -> std::option::Option<&str> {
        self.lifecycle_config_arn.as_deref()
    }
}
impl std::fmt::Debug for ResourceSpec {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceSpec");
        formatter.field("sage_maker_image_arn", &self.sage_maker_image_arn);
        formatter.field(
            "sage_maker_image_version_arn",
            &self.sage_maker_image_version_arn,
        );
        formatter.field("instance_type", &self.instance_type);
        formatter.field("lifecycle_config_arn", &self.lifecycle_config_arn);
        formatter.finish()
    }
}
/// See [`ResourceSpec`](crate::model::ResourceSpec)
pub mod resource_spec {
    /// A builder for [`ResourceSpec`](crate::model::ResourceSpec)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sage_maker_image_arn: std::option::Option<std::string::String>,
        pub(crate) sage_maker_image_version_arn: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<crate::model::AppInstanceType>,
        pub(crate) lifecycle_config_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the SageMaker image that the image version belongs to.</p>
        pub fn sage_maker_image_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sage_maker_image_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SageMaker image that the image version belongs to.</p>
        pub fn set_sage_maker_image_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sage_maker_image_arn = input;
            self
        }
        /// <p>The ARN of the image version created on the instance.</p>
        pub fn sage_maker_image_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.sage_maker_image_version_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the image version created on the instance.</p>
        pub fn set_sage_maker_image_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sage_maker_image_version_arn = input;
            self
        }
        /// <p>The instance type that the image version runs on.</p>
        pub fn instance_type(mut self, input: crate::model::AppInstanceType) -> Self {
            self.instance_type = Some(input);
            self
        }
        /// <p>The instance type that the image version runs on.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<crate::model::AppInstanceType>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.</p>
        pub fn lifecycle_config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.lifecycle_config_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.</p>
        pub fn set_lifecycle_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lifecycle_config_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceSpec`](crate::model::ResourceSpec)
        pub fn build(self) -> crate::model::ResourceSpec {
            crate::model::ResourceSpec {
                sage_maker_image_arn: self.sage_maker_image_arn,
                sage_maker_image_version_arn: self.sage_maker_image_version_arn,
                instance_type: self.instance_type,
                lifecycle_config_arn: self.lifecycle_config_arn,
            }
        }
    }
}
impl ResourceSpec {
    /// Creates a new builder-style object to manufacture [`ResourceSpec`](crate::model::ResourceSpec)
    pub fn builder() -> crate::model::resource_spec::Builder {
        crate::model::resource_spec::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AppInstanceType {
    #[allow(missing_docs)] // documentation missing in model
    MlC512Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC518Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC524Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC52Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC54Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC59Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC5Large,
    #[allow(missing_docs)] // documentation missing in model
    MlC5Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4Dn12Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4Dn16Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4Dn2Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4Dn4Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4Dn8Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4DnXlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM512Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM516Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM524Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM52Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM54Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM58Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM5Large,
    #[allow(missing_docs)] // documentation missing in model
    MlM5Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM5D12Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM5D16Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM5D24Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM5D2Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM5D4Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM5D8Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM5DLarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM5DXlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlP316Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlP32Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlP38Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlP3Dn24Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR512Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR516Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR524Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR52Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR54Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR58Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR5Large,
    #[allow(missing_docs)] // documentation missing in model
    MlR5Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlT32Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlT3Large,
    #[allow(missing_docs)] // documentation missing in model
    MlT3Medium,
    #[allow(missing_docs)] // documentation missing in model
    MlT3Micro,
    #[allow(missing_docs)] // documentation missing in model
    MlT3Small,
    #[allow(missing_docs)] // documentation missing in model
    MlT3Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    System,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AppInstanceType {
    fn from(s: &str) -> Self {
        match s {
            "ml.c5.12xlarge" => AppInstanceType::MlC512Xlarge,
            "ml.c5.18xlarge" => AppInstanceType::MlC518Xlarge,
            "ml.c5.24xlarge" => AppInstanceType::MlC524Xlarge,
            "ml.c5.2xlarge" => AppInstanceType::MlC52Xlarge,
            "ml.c5.4xlarge" => AppInstanceType::MlC54Xlarge,
            "ml.c5.9xlarge" => AppInstanceType::MlC59Xlarge,
            "ml.c5.large" => AppInstanceType::MlC5Large,
            "ml.c5.xlarge" => AppInstanceType::MlC5Xlarge,
            "ml.g4dn.12xlarge" => AppInstanceType::MlG4Dn12Xlarge,
            "ml.g4dn.16xlarge" => AppInstanceType::MlG4Dn16Xlarge,
            "ml.g4dn.2xlarge" => AppInstanceType::MlG4Dn2Xlarge,
            "ml.g4dn.4xlarge" => AppInstanceType::MlG4Dn4Xlarge,
            "ml.g4dn.8xlarge" => AppInstanceType::MlG4Dn8Xlarge,
            "ml.g4dn.xlarge" => AppInstanceType::MlG4DnXlarge,
            "ml.m5.12xlarge" => AppInstanceType::MlM512Xlarge,
            "ml.m5.16xlarge" => AppInstanceType::MlM516Xlarge,
            "ml.m5.24xlarge" => AppInstanceType::MlM524Xlarge,
            "ml.m5.2xlarge" => AppInstanceType::MlM52Xlarge,
            "ml.m5.4xlarge" => AppInstanceType::MlM54Xlarge,
            "ml.m5.8xlarge" => AppInstanceType::MlM58Xlarge,
            "ml.m5.large" => AppInstanceType::MlM5Large,
            "ml.m5.xlarge" => AppInstanceType::MlM5Xlarge,
            "ml.m5d.12xlarge" => AppInstanceType::MlM5D12Xlarge,
            "ml.m5d.16xlarge" => AppInstanceType::MlM5D16Xlarge,
            "ml.m5d.24xlarge" => AppInstanceType::MlM5D24Xlarge,
            "ml.m5d.2xlarge" => AppInstanceType::MlM5D2Xlarge,
            "ml.m5d.4xlarge" => AppInstanceType::MlM5D4Xlarge,
            "ml.m5d.8xlarge" => AppInstanceType::MlM5D8Xlarge,
            "ml.m5d.large" => AppInstanceType::MlM5DLarge,
            "ml.m5d.xlarge" => AppInstanceType::MlM5DXlarge,
            "ml.p3.16xlarge" => AppInstanceType::MlP316Xlarge,
            "ml.p3.2xlarge" => AppInstanceType::MlP32Xlarge,
            "ml.p3.8xlarge" => AppInstanceType::MlP38Xlarge,
            "ml.p3dn.24xlarge" => AppInstanceType::MlP3Dn24Xlarge,
            "ml.r5.12xlarge" => AppInstanceType::MlR512Xlarge,
            "ml.r5.16xlarge" => AppInstanceType::MlR516Xlarge,
            "ml.r5.24xlarge" => AppInstanceType::MlR524Xlarge,
            "ml.r5.2xlarge" => AppInstanceType::MlR52Xlarge,
            "ml.r5.4xlarge" => AppInstanceType::MlR54Xlarge,
            "ml.r5.8xlarge" => AppInstanceType::MlR58Xlarge,
            "ml.r5.large" => AppInstanceType::MlR5Large,
            "ml.r5.xlarge" => AppInstanceType::MlR5Xlarge,
            "ml.t3.2xlarge" => AppInstanceType::MlT32Xlarge,
            "ml.t3.large" => AppInstanceType::MlT3Large,
            "ml.t3.medium" => AppInstanceType::MlT3Medium,
            "ml.t3.micro" => AppInstanceType::MlT3Micro,
            "ml.t3.small" => AppInstanceType::MlT3Small,
            "ml.t3.xlarge" => AppInstanceType::MlT3Xlarge,
            "system" => AppInstanceType::System,
            other => AppInstanceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AppInstanceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AppInstanceType::from(s))
    }
}
impl AppInstanceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AppInstanceType::MlC512Xlarge => "ml.c5.12xlarge",
            AppInstanceType::MlC518Xlarge => "ml.c5.18xlarge",
            AppInstanceType::MlC524Xlarge => "ml.c5.24xlarge",
            AppInstanceType::MlC52Xlarge => "ml.c5.2xlarge",
            AppInstanceType::MlC54Xlarge => "ml.c5.4xlarge",
            AppInstanceType::MlC59Xlarge => "ml.c5.9xlarge",
            AppInstanceType::MlC5Large => "ml.c5.large",
            AppInstanceType::MlC5Xlarge => "ml.c5.xlarge",
            AppInstanceType::MlG4Dn12Xlarge => "ml.g4dn.12xlarge",
            AppInstanceType::MlG4Dn16Xlarge => "ml.g4dn.16xlarge",
            AppInstanceType::MlG4Dn2Xlarge => "ml.g4dn.2xlarge",
            AppInstanceType::MlG4Dn4Xlarge => "ml.g4dn.4xlarge",
            AppInstanceType::MlG4Dn8Xlarge => "ml.g4dn.8xlarge",
            AppInstanceType::MlG4DnXlarge => "ml.g4dn.xlarge",
            AppInstanceType::MlM512Xlarge => "ml.m5.12xlarge",
            AppInstanceType::MlM516Xlarge => "ml.m5.16xlarge",
            AppInstanceType::MlM524Xlarge => "ml.m5.24xlarge",
            AppInstanceType::MlM52Xlarge => "ml.m5.2xlarge",
            AppInstanceType::MlM54Xlarge => "ml.m5.4xlarge",
            AppInstanceType::MlM58Xlarge => "ml.m5.8xlarge",
            AppInstanceType::MlM5Large => "ml.m5.large",
            AppInstanceType::MlM5Xlarge => "ml.m5.xlarge",
            AppInstanceType::MlM5D12Xlarge => "ml.m5d.12xlarge",
            AppInstanceType::MlM5D16Xlarge => "ml.m5d.16xlarge",
            AppInstanceType::MlM5D24Xlarge => "ml.m5d.24xlarge",
            AppInstanceType::MlM5D2Xlarge => "ml.m5d.2xlarge",
            AppInstanceType::MlM5D4Xlarge => "ml.m5d.4xlarge",
            AppInstanceType::MlM5D8Xlarge => "ml.m5d.8xlarge",
            AppInstanceType::MlM5DLarge => "ml.m5d.large",
            AppInstanceType::MlM5DXlarge => "ml.m5d.xlarge",
            AppInstanceType::MlP316Xlarge => "ml.p3.16xlarge",
            AppInstanceType::MlP32Xlarge => "ml.p3.2xlarge",
            AppInstanceType::MlP38Xlarge => "ml.p3.8xlarge",
            AppInstanceType::MlP3Dn24Xlarge => "ml.p3dn.24xlarge",
            AppInstanceType::MlR512Xlarge => "ml.r5.12xlarge",
            AppInstanceType::MlR516Xlarge => "ml.r5.16xlarge",
            AppInstanceType::MlR524Xlarge => "ml.r5.24xlarge",
            AppInstanceType::MlR52Xlarge => "ml.r5.2xlarge",
            AppInstanceType::MlR54Xlarge => "ml.r5.4xlarge",
            AppInstanceType::MlR58Xlarge => "ml.r5.8xlarge",
            AppInstanceType::MlR5Large => "ml.r5.large",
            AppInstanceType::MlR5Xlarge => "ml.r5.xlarge",
            AppInstanceType::MlT32Xlarge => "ml.t3.2xlarge",
            AppInstanceType::MlT3Large => "ml.t3.large",
            AppInstanceType::MlT3Medium => "ml.t3.medium",
            AppInstanceType::MlT3Micro => "ml.t3.micro",
            AppInstanceType::MlT3Small => "ml.t3.small",
            AppInstanceType::MlT3Xlarge => "ml.t3.xlarge",
            AppInstanceType::System => "system",
            AppInstanceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ml.c5.12xlarge",
            "ml.c5.18xlarge",
            "ml.c5.24xlarge",
            "ml.c5.2xlarge",
            "ml.c5.4xlarge",
            "ml.c5.9xlarge",
            "ml.c5.large",
            "ml.c5.xlarge",
            "ml.g4dn.12xlarge",
            "ml.g4dn.16xlarge",
            "ml.g4dn.2xlarge",
            "ml.g4dn.4xlarge",
            "ml.g4dn.8xlarge",
            "ml.g4dn.xlarge",
            "ml.m5.12xlarge",
            "ml.m5.16xlarge",
            "ml.m5.24xlarge",
            "ml.m5.2xlarge",
            "ml.m5.4xlarge",
            "ml.m5.8xlarge",
            "ml.m5.large",
            "ml.m5.xlarge",
            "ml.m5d.12xlarge",
            "ml.m5d.16xlarge",
            "ml.m5d.24xlarge",
            "ml.m5d.2xlarge",
            "ml.m5d.4xlarge",
            "ml.m5d.8xlarge",
            "ml.m5d.large",
            "ml.m5d.xlarge",
            "ml.p3.16xlarge",
            "ml.p3.2xlarge",
            "ml.p3.8xlarge",
            "ml.p3dn.24xlarge",
            "ml.r5.12xlarge",
            "ml.r5.16xlarge",
            "ml.r5.24xlarge",
            "ml.r5.2xlarge",
            "ml.r5.4xlarge",
            "ml.r5.8xlarge",
            "ml.r5.large",
            "ml.r5.xlarge",
            "ml.t3.2xlarge",
            "ml.t3.large",
            "ml.t3.medium",
            "ml.t3.micro",
            "ml.t3.small",
            "ml.t3.xlarge",
            "system",
        ]
    }
}
impl AsRef<str> for AppInstanceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The KernelGateway app settings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KernelGatewayAppSettings {
    /// <p>The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.</p>
    pub default_resource_spec: std::option::Option<crate::model::ResourceSpec>,
    /// <p>A list of custom SageMaker images that are configured to run as a KernelGateway app.</p>
    pub custom_images: std::option::Option<std::vec::Vec<crate::model::CustomImage>>,
    /// <p> The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the the user profile or domain.</p>
    pub lifecycle_config_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl KernelGatewayAppSettings {
    /// <p>The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.</p>
    pub fn default_resource_spec(&self) -> std::option::Option<&crate::model::ResourceSpec> {
        self.default_resource_spec.as_ref()
    }
    /// <p>A list of custom SageMaker images that are configured to run as a KernelGateway app.</p>
    pub fn custom_images(&self) -> std::option::Option<&[crate::model::CustomImage]> {
        self.custom_images.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the the user profile or domain.</p>
    pub fn lifecycle_config_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.lifecycle_config_arns.as_deref()
    }
}
impl std::fmt::Debug for KernelGatewayAppSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KernelGatewayAppSettings");
        formatter.field("default_resource_spec", &self.default_resource_spec);
        formatter.field("custom_images", &self.custom_images);
        formatter.field("lifecycle_config_arns", &self.lifecycle_config_arns);
        formatter.finish()
    }
}
/// See [`KernelGatewayAppSettings`](crate::model::KernelGatewayAppSettings)
pub mod kernel_gateway_app_settings {
    /// A builder for [`KernelGatewayAppSettings`](crate::model::KernelGatewayAppSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_resource_spec: std::option::Option<crate::model::ResourceSpec>,
        pub(crate) custom_images: std::option::Option<std::vec::Vec<crate::model::CustomImage>>,
        pub(crate) lifecycle_config_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.</p>
        pub fn default_resource_spec(mut self, input: crate::model::ResourceSpec) -> Self {
            self.default_resource_spec = Some(input);
            self
        }
        /// <p>The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.</p>
        pub fn set_default_resource_spec(
            mut self,
            input: std::option::Option<crate::model::ResourceSpec>,
        ) -> Self {
            self.default_resource_spec = input;
            self
        }
        /// Appends an item to `custom_images`.
        ///
        /// To override the contents of this collection use [`set_custom_images`](Self::set_custom_images).
        ///
        /// <p>A list of custom SageMaker images that are configured to run as a KernelGateway app.</p>
        pub fn custom_images(mut self, input: impl Into<crate::model::CustomImage>) -> Self {
            let mut v = self.custom_images.unwrap_or_default();
            v.push(input.into());
            self.custom_images = Some(v);
            self
        }
        /// <p>A list of custom SageMaker images that are configured to run as a KernelGateway app.</p>
        pub fn set_custom_images(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CustomImage>>,
        ) -> Self {
            self.custom_images = input;
            self
        }
        /// Appends an item to `lifecycle_config_arns`.
        ///
        /// To override the contents of this collection use [`set_lifecycle_config_arns`](Self::set_lifecycle_config_arns).
        ///
        /// <p> The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the the user profile or domain.</p>
        pub fn lifecycle_config_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.lifecycle_config_arns.unwrap_or_default();
            v.push(input.into());
            self.lifecycle_config_arns = Some(v);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the the user profile or domain.</p>
        pub fn set_lifecycle_config_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.lifecycle_config_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`KernelGatewayAppSettings`](crate::model::KernelGatewayAppSettings)
        pub fn build(self) -> crate::model::KernelGatewayAppSettings {
            crate::model::KernelGatewayAppSettings {
                default_resource_spec: self.default_resource_spec,
                custom_images: self.custom_images,
                lifecycle_config_arns: self.lifecycle_config_arns,
            }
        }
    }
}
impl KernelGatewayAppSettings {
    /// Creates a new builder-style object to manufacture [`KernelGatewayAppSettings`](crate::model::KernelGatewayAppSettings)
    pub fn builder() -> crate::model::kernel_gateway_app_settings::Builder {
        crate::model::kernel_gateway_app_settings::Builder::default()
    }
}

/// <p>A custom SageMaker image. For more information, see
/// <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html">Bring your own SageMaker image</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomImage {
    /// <p>The name of the CustomImage. Must be unique to your account.</p>
    pub image_name: std::option::Option<std::string::String>,
    /// <p>The version number of the CustomImage.</p>
    pub image_version_number: std::option::Option<i32>,
    /// <p>The name of the AppImageConfig.</p>
    pub app_image_config_name: std::option::Option<std::string::String>,
}
impl CustomImage {
    /// <p>The name of the CustomImage. Must be unique to your account.</p>
    pub fn image_name(&self) -> std::option::Option<&str> {
        self.image_name.as_deref()
    }
    /// <p>The version number of the CustomImage.</p>
    pub fn image_version_number(&self) -> std::option::Option<i32> {
        self.image_version_number
    }
    /// <p>The name of the AppImageConfig.</p>
    pub fn app_image_config_name(&self) -> std::option::Option<&str> {
        self.app_image_config_name.as_deref()
    }
}
impl std::fmt::Debug for CustomImage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomImage");
        formatter.field("image_name", &self.image_name);
        formatter.field("image_version_number", &self.image_version_number);
        formatter.field("app_image_config_name", &self.app_image_config_name);
        formatter.finish()
    }
}
/// See [`CustomImage`](crate::model::CustomImage)
pub mod custom_image {
    /// A builder for [`CustomImage`](crate::model::CustomImage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_name: std::option::Option<std::string::String>,
        pub(crate) image_version_number: std::option::Option<i32>,
        pub(crate) app_image_config_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the CustomImage. Must be unique to your account.</p>
        pub fn image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_name = Some(input.into());
            self
        }
        /// <p>The name of the CustomImage. Must be unique to your account.</p>
        pub fn set_image_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_name = input;
            self
        }
        /// <p>The version number of the CustomImage.</p>
        pub fn image_version_number(mut self, input: i32) -> Self {
            self.image_version_number = Some(input);
            self
        }
        /// <p>The version number of the CustomImage.</p>
        pub fn set_image_version_number(mut self, input: std::option::Option<i32>) -> Self {
            self.image_version_number = input;
            self
        }
        /// <p>The name of the AppImageConfig.</p>
        pub fn app_image_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_image_config_name = Some(input.into());
            self
        }
        /// <p>The name of the AppImageConfig.</p>
        pub fn set_app_image_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_image_config_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomImage`](crate::model::CustomImage)
        pub fn build(self) -> crate::model::CustomImage {
            crate::model::CustomImage {
                image_name: self.image_name,
                image_version_number: self.image_version_number,
                app_image_config_name: self.app_image_config_name,
            }
        }
    }
}
impl CustomImage {
    /// Creates a new builder-style object to manufacture [`CustomImage`](crate::model::CustomImage)
    pub fn builder() -> crate::model::custom_image::Builder {
        crate::model::custom_image::Builder::default()
    }
}

/// <p>The JupyterServer app settings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JupyterServerAppSettings {
    /// <p>The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app.</p>
    pub default_resource_spec: std::option::Option<crate::model::ResourceSpec>,
    /// <p> The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the JupyterServerApp.</p>
    pub lifecycle_config_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl JupyterServerAppSettings {
    /// <p>The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app.</p>
    pub fn default_resource_spec(&self) -> std::option::Option<&crate::model::ResourceSpec> {
        self.default_resource_spec.as_ref()
    }
    /// <p> The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the JupyterServerApp.</p>
    pub fn lifecycle_config_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.lifecycle_config_arns.as_deref()
    }
}
impl std::fmt::Debug for JupyterServerAppSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JupyterServerAppSettings");
        formatter.field("default_resource_spec", &self.default_resource_spec);
        formatter.field("lifecycle_config_arns", &self.lifecycle_config_arns);
        formatter.finish()
    }
}
/// See [`JupyterServerAppSettings`](crate::model::JupyterServerAppSettings)
pub mod jupyter_server_app_settings {
    /// A builder for [`JupyterServerAppSettings`](crate::model::JupyterServerAppSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_resource_spec: std::option::Option<crate::model::ResourceSpec>,
        pub(crate) lifecycle_config_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app.</p>
        pub fn default_resource_spec(mut self, input: crate::model::ResourceSpec) -> Self {
            self.default_resource_spec = Some(input);
            self
        }
        /// <p>The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app.</p>
        pub fn set_default_resource_spec(
            mut self,
            input: std::option::Option<crate::model::ResourceSpec>,
        ) -> Self {
            self.default_resource_spec = input;
            self
        }
        /// Appends an item to `lifecycle_config_arns`.
        ///
        /// To override the contents of this collection use [`set_lifecycle_config_arns`](Self::set_lifecycle_config_arns).
        ///
        /// <p> The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the JupyterServerApp.</p>
        pub fn lifecycle_config_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.lifecycle_config_arns.unwrap_or_default();
            v.push(input.into());
            self.lifecycle_config_arns = Some(v);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the JupyterServerApp.</p>
        pub fn set_lifecycle_config_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.lifecycle_config_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`JupyterServerAppSettings`](crate::model::JupyterServerAppSettings)
        pub fn build(self) -> crate::model::JupyterServerAppSettings {
            crate::model::JupyterServerAppSettings {
                default_resource_spec: self.default_resource_spec,
                lifecycle_config_arns: self.lifecycle_config_arns,
            }
        }
    }
}
impl JupyterServerAppSettings {
    /// Creates a new builder-style object to manufacture [`JupyterServerAppSettings`](crate::model::JupyterServerAppSettings)
    pub fn builder() -> crate::model::jupyter_server_app_settings::Builder {
        crate::model::jupyter_server_app_settings::Builder::default()
    }
}

/// <p>Specifies options for sharing SageMaker Studio notebooks. These settings are
/// specified as part of <code>DefaultUserSettings</code> when the <code>CreateDomain</code>
/// API is called, and as part of <code>UserSettings</code> when the <code>CreateUserProfile</code>
/// API is called. When <code>SharingSettings</code> is not specified, notebook sharing
/// isn't allowed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SharingSettings {
    /// <p>Whether to include the notebook cell output when sharing the notebook. The default
    /// is <code>Disabled</code>.</p>
    pub notebook_output_option: std::option::Option<crate::model::NotebookOutputOption>,
    /// <p>When <code>NotebookOutputOption</code> is <code>Allowed</code>, the Amazon S3 bucket used
    /// to store the shared notebook snapshots.</p>
    pub s3_output_path: std::option::Option<std::string::String>,
    /// <p>When <code>NotebookOutputOption</code> is <code>Allowed</code>, the Amazon Web Services Key Management Service (KMS)
    /// encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.</p>
    pub s3_kms_key_id: std::option::Option<std::string::String>,
}
impl SharingSettings {
    /// <p>Whether to include the notebook cell output when sharing the notebook. The default
    /// is <code>Disabled</code>.</p>
    pub fn notebook_output_option(
        &self,
    ) -> std::option::Option<&crate::model::NotebookOutputOption> {
        self.notebook_output_option.as_ref()
    }
    /// <p>When <code>NotebookOutputOption</code> is <code>Allowed</code>, the Amazon S3 bucket used
    /// to store the shared notebook snapshots.</p>
    pub fn s3_output_path(&self) -> std::option::Option<&str> {
        self.s3_output_path.as_deref()
    }
    /// <p>When <code>NotebookOutputOption</code> is <code>Allowed</code>, the Amazon Web Services Key Management Service (KMS)
    /// encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.</p>
    pub fn s3_kms_key_id(&self) -> std::option::Option<&str> {
        self.s3_kms_key_id.as_deref()
    }
}
impl std::fmt::Debug for SharingSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SharingSettings");
        formatter.field("notebook_output_option", &self.notebook_output_option);
        formatter.field("s3_output_path", &self.s3_output_path);
        formatter.field("s3_kms_key_id", &self.s3_kms_key_id);
        formatter.finish()
    }
}
/// See [`SharingSettings`](crate::model::SharingSettings)
pub mod sharing_settings {
    /// A builder for [`SharingSettings`](crate::model::SharingSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notebook_output_option: std::option::Option<crate::model::NotebookOutputOption>,
        pub(crate) s3_output_path: std::option::Option<std::string::String>,
        pub(crate) s3_kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Whether to include the notebook cell output when sharing the notebook. The default
        /// is <code>Disabled</code>.</p>
        pub fn notebook_output_option(mut self, input: crate::model::NotebookOutputOption) -> Self {
            self.notebook_output_option = Some(input);
            self
        }
        /// <p>Whether to include the notebook cell output when sharing the notebook. The default
        /// is <code>Disabled</code>.</p>
        pub fn set_notebook_output_option(
            mut self,
            input: std::option::Option<crate::model::NotebookOutputOption>,
        ) -> Self {
            self.notebook_output_option = input;
            self
        }
        /// <p>When <code>NotebookOutputOption</code> is <code>Allowed</code>, the Amazon S3 bucket used
        /// to store the shared notebook snapshots.</p>
        pub fn s3_output_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_output_path = Some(input.into());
            self
        }
        /// <p>When <code>NotebookOutputOption</code> is <code>Allowed</code>, the Amazon S3 bucket used
        /// to store the shared notebook snapshots.</p>
        pub fn set_s3_output_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_output_path = input;
            self
        }
        /// <p>When <code>NotebookOutputOption</code> is <code>Allowed</code>, the Amazon Web Services Key Management Service (KMS)
        /// encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.</p>
        pub fn s3_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_kms_key_id = Some(input.into());
            self
        }
        /// <p>When <code>NotebookOutputOption</code> is <code>Allowed</code>, the Amazon Web Services Key Management Service (KMS)
        /// encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.</p>
        pub fn set_s3_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SharingSettings`](crate::model::SharingSettings)
        pub fn build(self) -> crate::model::SharingSettings {
            crate::model::SharingSettings {
                notebook_output_option: self.notebook_output_option,
                s3_output_path: self.s3_output_path,
                s3_kms_key_id: self.s3_kms_key_id,
            }
        }
    }
}
impl SharingSettings {
    /// Creates a new builder-style object to manufacture [`SharingSettings`](crate::model::SharingSettings)
    pub fn builder() -> crate::model::sharing_settings::Builder {
        crate::model::sharing_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NotebookOutputOption {
    #[allow(missing_docs)] // documentation missing in model
    Allowed,
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NotebookOutputOption {
    fn from(s: &str) -> Self {
        match s {
            "Allowed" => NotebookOutputOption::Allowed,
            "Disabled" => NotebookOutputOption::Disabled,
            other => NotebookOutputOption::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NotebookOutputOption {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NotebookOutputOption::from(s))
    }
}
impl NotebookOutputOption {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NotebookOutputOption::Allowed => "Allowed",
            NotebookOutputOption::Disabled => "Disabled",
            NotebookOutputOption::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Allowed", "Disabled"]
    }
}
impl AsRef<str> for NotebookOutputOption {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents an input or output artifact of a trial component. You specify
/// <code>TrialComponentArtifact</code> as part of the <code>InputArtifacts</code> and
/// <code>OutputArtifacts</code> parameters in the <a>CreateTrialComponent</a>
/// request.</p>
/// <p>Examples of input artifacts are datasets, algorithms, hyperparameters, source code, and
/// instance types. Examples of output artifacts are metrics, snapshots, logs, and images.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrialComponentArtifact {
    /// <p>The media type of the artifact, which indicates the type of data in the artifact file. The
    /// media type consists of a <i>type</i> and a <i>subtype</i>
    /// concatenated with a slash (/) character, for example, text/csv, image/jpeg, and s3/uri. The
    /// type specifies the category of the media. The subtype specifies the kind of data.</p>
    pub media_type: std::option::Option<std::string::String>,
    /// <p>The location of the artifact.</p>
    pub value: std::option::Option<std::string::String>,
}
impl TrialComponentArtifact {
    /// <p>The media type of the artifact, which indicates the type of data in the artifact file. The
    /// media type consists of a <i>type</i> and a <i>subtype</i>
    /// concatenated with a slash (/) character, for example, text/csv, image/jpeg, and s3/uri. The
    /// type specifies the category of the media. The subtype specifies the kind of data.</p>
    pub fn media_type(&self) -> std::option::Option<&str> {
        self.media_type.as_deref()
    }
    /// <p>The location of the artifact.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for TrialComponentArtifact {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrialComponentArtifact");
        formatter.field("media_type", &self.media_type);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`TrialComponentArtifact`](crate::model::TrialComponentArtifact)
pub mod trial_component_artifact {
    /// A builder for [`TrialComponentArtifact`](crate::model::TrialComponentArtifact)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) media_type: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The media type of the artifact, which indicates the type of data in the artifact file. The
        /// media type consists of a <i>type</i> and a <i>subtype</i>
        /// concatenated with a slash (/) character, for example, text/csv, image/jpeg, and s3/uri. The
        /// type specifies the category of the media. The subtype specifies the kind of data.</p>
        pub fn media_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.media_type = Some(input.into());
            self
        }
        /// <p>The media type of the artifact, which indicates the type of data in the artifact file. The
        /// media type consists of a <i>type</i> and a <i>subtype</i>
        /// concatenated with a slash (/) character, for example, text/csv, image/jpeg, and s3/uri. The
        /// type specifies the category of the media. The subtype specifies the kind of data.</p>
        pub fn set_media_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.media_type = input;
            self
        }
        /// <p>The location of the artifact.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The location of the artifact.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`TrialComponentArtifact`](crate::model::TrialComponentArtifact)
        pub fn build(self) -> crate::model::TrialComponentArtifact {
            crate::model::TrialComponentArtifact {
                media_type: self.media_type,
                value: self.value,
            }
        }
    }
}
impl TrialComponentArtifact {
    /// Creates a new builder-style object to manufacture [`TrialComponentArtifact`](crate::model::TrialComponentArtifact)
    pub fn builder() -> crate::model::trial_component_artifact::Builder {
        crate::model::trial_component_artifact::Builder::default()
    }
}

/// <p>The value of a hyperparameter. Only one of <code>NumberValue</code> or
/// <code>StringValue</code> can be specified.</p>
/// <p>This object is specified in the <a>CreateTrialComponent</a> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum TrialComponentParameterValue {
    /// <p>The numeric value of a numeric hyperparameter. If you specify a value for this parameter,
    /// you can't specify the <code>StringValue</code> parameter.</p>
    NumberValue(f64),
    /// <p>The string value of a categorical hyperparameter. If you specify a value for this
    /// parameter, you can't specify the <code>NumberValue</code> parameter.</p>
    StringValue(std::string::String),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl TrialComponentParameterValue {
    /// Tries to convert the enum instance into [`NumberValue`](crate::model::TrialComponentParameterValue::NumberValue), extracting the inner [`f64`](f64).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_number_value(&self) -> std::result::Result<&f64, &Self> {
        if let TrialComponentParameterValue::NumberValue(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`NumberValue`](crate::model::TrialComponentParameterValue::NumberValue).
    pub fn is_number_value(&self) -> bool {
        self.as_number_value().is_ok()
    }
    /// Tries to convert the enum instance into [`StringValue`](crate::model::TrialComponentParameterValue::StringValue), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_string_value(&self) -> std::result::Result<&std::string::String, &Self> {
        if let TrialComponentParameterValue::StringValue(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`StringValue`](crate::model::TrialComponentParameterValue::StringValue).
    pub fn is_string_value(&self) -> bool {
        self.as_string_value().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>The status of the trial component.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrialComponentStatus {
    /// <p>The status of the trial component.</p>
    pub primary_status: std::option::Option<crate::model::TrialComponentPrimaryStatus>,
    /// <p>If the component failed, a message describing why.</p>
    pub message: std::option::Option<std::string::String>,
}
impl TrialComponentStatus {
    /// <p>The status of the trial component.</p>
    pub fn primary_status(
        &self,
    ) -> std::option::Option<&crate::model::TrialComponentPrimaryStatus> {
        self.primary_status.as_ref()
    }
    /// <p>If the component failed, a message describing why.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for TrialComponentStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrialComponentStatus");
        formatter.field("primary_status", &self.primary_status);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`TrialComponentStatus`](crate::model::TrialComponentStatus)
pub mod trial_component_status {
    /// A builder for [`TrialComponentStatus`](crate::model::TrialComponentStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) primary_status: std::option::Option<crate::model::TrialComponentPrimaryStatus>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The status of the trial component.</p>
        pub fn primary_status(mut self, input: crate::model::TrialComponentPrimaryStatus) -> Self {
            self.primary_status = Some(input);
            self
        }
        /// <p>The status of the trial component.</p>
        pub fn set_primary_status(
            mut self,
            input: std::option::Option<crate::model::TrialComponentPrimaryStatus>,
        ) -> Self {
            self.primary_status = input;
            self
        }
        /// <p>If the component failed, a message describing why.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>If the component failed, a message describing why.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TrialComponentStatus`](crate::model::TrialComponentStatus)
        pub fn build(self) -> crate::model::TrialComponentStatus {
            crate::model::TrialComponentStatus {
                primary_status: self.primary_status,
                message: self.message,
            }
        }
    }
}
impl TrialComponentStatus {
    /// Creates a new builder-style object to manufacture [`TrialComponentStatus`](crate::model::TrialComponentStatus)
    pub fn builder() -> crate::model::trial_component_status::Builder {
        crate::model::trial_component_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TrialComponentPrimaryStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TrialComponentPrimaryStatus {
    fn from(s: &str) -> Self {
        match s {
            "Completed" => TrialComponentPrimaryStatus::Completed,
            "Failed" => TrialComponentPrimaryStatus::Failed,
            "InProgress" => TrialComponentPrimaryStatus::InProgress,
            "Stopped" => TrialComponentPrimaryStatus::Stopped,
            "Stopping" => TrialComponentPrimaryStatus::Stopping,
            other => TrialComponentPrimaryStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TrialComponentPrimaryStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TrialComponentPrimaryStatus::from(s))
    }
}
impl TrialComponentPrimaryStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TrialComponentPrimaryStatus::Completed => "Completed",
            TrialComponentPrimaryStatus::Failed => "Failed",
            TrialComponentPrimaryStatus::InProgress => "InProgress",
            TrialComponentPrimaryStatus::Stopped => "Stopped",
            TrialComponentPrimaryStatus::Stopping => "Stopping",
            TrialComponentPrimaryStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Completed", "Failed", "InProgress", "Stopped", "Stopping"]
    }
}
impl AsRef<str> for TrialComponentPrimaryStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Configuration information for profiling rules.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProfilerRuleConfiguration {
    /// <p>The name of the rule configuration. It must be unique relative to other rule configuration names.</p>
    pub rule_configuration_name: std::option::Option<std::string::String>,
    /// <p>Path to local storage location for output of rules. Defaults to <code>/opt/ml/processing/output/rule/</code>. </p>
    pub local_path: std::option::Option<std::string::String>,
    /// <p>Path to Amazon S3 storage location for rules.</p>
    pub s3_output_path: std::option::Option<std::string::String>,
    /// <p>The Amazon Elastic Container (ECR) Image for the managed rule evaluation.</p>
    pub rule_evaluator_image: std::option::Option<std::string::String>,
    /// <p>The instance type to deploy a Debugger custom rule for profiling a training job.</p>
    pub instance_type: std::option::Option<crate::model::ProcessingInstanceType>,
    /// <p>The size, in GB, of the ML storage volume attached to the processing instance.</p>
    pub volume_size_in_gb: i32,
    /// <p>Runtime configuration for rule container.</p>
    pub rule_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ProfilerRuleConfiguration {
    /// <p>The name of the rule configuration. It must be unique relative to other rule configuration names.</p>
    pub fn rule_configuration_name(&self) -> std::option::Option<&str> {
        self.rule_configuration_name.as_deref()
    }
    /// <p>Path to local storage location for output of rules. Defaults to <code>/opt/ml/processing/output/rule/</code>. </p>
    pub fn local_path(&self) -> std::option::Option<&str> {
        self.local_path.as_deref()
    }
    /// <p>Path to Amazon S3 storage location for rules.</p>
    pub fn s3_output_path(&self) -> std::option::Option<&str> {
        self.s3_output_path.as_deref()
    }
    /// <p>The Amazon Elastic Container (ECR) Image for the managed rule evaluation.</p>
    pub fn rule_evaluator_image(&self) -> std::option::Option<&str> {
        self.rule_evaluator_image.as_deref()
    }
    /// <p>The instance type to deploy a Debugger custom rule for profiling a training job.</p>
    pub fn instance_type(&self) -> std::option::Option<&crate::model::ProcessingInstanceType> {
        self.instance_type.as_ref()
    }
    /// <p>The size, in GB, of the ML storage volume attached to the processing instance.</p>
    pub fn volume_size_in_gb(&self) -> i32 {
        self.volume_size_in_gb
    }
    /// <p>Runtime configuration for rule container.</p>
    pub fn rule_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.rule_parameters.as_ref()
    }
}
impl std::fmt::Debug for ProfilerRuleConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProfilerRuleConfiguration");
        formatter.field("rule_configuration_name", &self.rule_configuration_name);
        formatter.field("local_path", &self.local_path);
        formatter.field("s3_output_path", &self.s3_output_path);
        formatter.field("rule_evaluator_image", &self.rule_evaluator_image);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("volume_size_in_gb", &self.volume_size_in_gb);
        formatter.field("rule_parameters", &self.rule_parameters);
        formatter.finish()
    }
}
/// See [`ProfilerRuleConfiguration`](crate::model::ProfilerRuleConfiguration)
pub mod profiler_rule_configuration {
    /// A builder for [`ProfilerRuleConfiguration`](crate::model::ProfilerRuleConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rule_configuration_name: std::option::Option<std::string::String>,
        pub(crate) local_path: std::option::Option<std::string::String>,
        pub(crate) s3_output_path: std::option::Option<std::string::String>,
        pub(crate) rule_evaluator_image: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<crate::model::ProcessingInstanceType>,
        pub(crate) volume_size_in_gb: std::option::Option<i32>,
        pub(crate) rule_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the rule configuration. It must be unique relative to other rule configuration names.</p>
        pub fn rule_configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_configuration_name = Some(input.into());
            self
        }
        /// <p>The name of the rule configuration. It must be unique relative to other rule configuration names.</p>
        pub fn set_rule_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_configuration_name = input;
            self
        }
        /// <p>Path to local storage location for output of rules. Defaults to <code>/opt/ml/processing/output/rule/</code>. </p>
        pub fn local_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.local_path = Some(input.into());
            self
        }
        /// <p>Path to local storage location for output of rules. Defaults to <code>/opt/ml/processing/output/rule/</code>. </p>
        pub fn set_local_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.local_path = input;
            self
        }
        /// <p>Path to Amazon S3 storage location for rules.</p>
        pub fn s3_output_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_output_path = Some(input.into());
            self
        }
        /// <p>Path to Amazon S3 storage location for rules.</p>
        pub fn set_s3_output_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_output_path = input;
            self
        }
        /// <p>The Amazon Elastic Container (ECR) Image for the managed rule evaluation.</p>
        pub fn rule_evaluator_image(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_evaluator_image = Some(input.into());
            self
        }
        /// <p>The Amazon Elastic Container (ECR) Image for the managed rule evaluation.</p>
        pub fn set_rule_evaluator_image(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_evaluator_image = input;
            self
        }
        /// <p>The instance type to deploy a Debugger custom rule for profiling a training job.</p>
        pub fn instance_type(mut self, input: crate::model::ProcessingInstanceType) -> Self {
            self.instance_type = Some(input);
            self
        }
        /// <p>The instance type to deploy a Debugger custom rule for profiling a training job.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<crate::model::ProcessingInstanceType>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The size, in GB, of the ML storage volume attached to the processing instance.</p>
        pub fn volume_size_in_gb(mut self, input: i32) -> Self {
            self.volume_size_in_gb = Some(input);
            self
        }
        /// <p>The size, in GB, of the ML storage volume attached to the processing instance.</p>
        pub fn set_volume_size_in_gb(mut self, input: std::option::Option<i32>) -> Self {
            self.volume_size_in_gb = input;
            self
        }
        /// Adds a key-value pair to `rule_parameters`.
        ///
        /// To override the contents of this collection use [`set_rule_parameters`](Self::set_rule_parameters).
        ///
        /// <p>Runtime configuration for rule container.</p>
        pub fn rule_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.rule_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.rule_parameters = Some(hash_map);
            self
        }
        /// <p>Runtime configuration for rule container.</p>
        pub fn set_rule_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.rule_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`ProfilerRuleConfiguration`](crate::model::ProfilerRuleConfiguration)
        pub fn build(self) -> crate::model::ProfilerRuleConfiguration {
            crate::model::ProfilerRuleConfiguration {
                rule_configuration_name: self.rule_configuration_name,
                local_path: self.local_path,
                s3_output_path: self.s3_output_path,
                rule_evaluator_image: self.rule_evaluator_image,
                instance_type: self.instance_type,
                volume_size_in_gb: self.volume_size_in_gb.unwrap_or_default(),
                rule_parameters: self.rule_parameters,
            }
        }
    }
}
impl ProfilerRuleConfiguration {
    /// Creates a new builder-style object to manufacture [`ProfilerRuleConfiguration`](crate::model::ProfilerRuleConfiguration)
    pub fn builder() -> crate::model::profiler_rule_configuration::Builder {
        crate::model::profiler_rule_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProcessingInstanceType {
    #[allow(missing_docs)] // documentation missing in model
    MlC42Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC44Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC48Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC4Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC518Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC52Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC54Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC59Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC5Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4Dn12Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4Dn16Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4Dn2Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4Dn4Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4Dn8Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4DnXlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM410Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM416Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM42Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM44Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM4Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM512Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM524Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM52Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM54Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM5Large,
    #[allow(missing_docs)] // documentation missing in model
    MlM5Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlP216Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlP28Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlP2Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlP316Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlP32Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlP38Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR512Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR516Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR524Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR52Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR54Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR58Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR5Large,
    #[allow(missing_docs)] // documentation missing in model
    MlR5Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlT32Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlT3Large,
    #[allow(missing_docs)] // documentation missing in model
    MlT3Medium,
    #[allow(missing_docs)] // documentation missing in model
    MlT3Xlarge,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProcessingInstanceType {
    fn from(s: &str) -> Self {
        match s {
            "ml.c4.2xlarge" => ProcessingInstanceType::MlC42Xlarge,
            "ml.c4.4xlarge" => ProcessingInstanceType::MlC44Xlarge,
            "ml.c4.8xlarge" => ProcessingInstanceType::MlC48Xlarge,
            "ml.c4.xlarge" => ProcessingInstanceType::MlC4Xlarge,
            "ml.c5.18xlarge" => ProcessingInstanceType::MlC518Xlarge,
            "ml.c5.2xlarge" => ProcessingInstanceType::MlC52Xlarge,
            "ml.c5.4xlarge" => ProcessingInstanceType::MlC54Xlarge,
            "ml.c5.9xlarge" => ProcessingInstanceType::MlC59Xlarge,
            "ml.c5.xlarge" => ProcessingInstanceType::MlC5Xlarge,
            "ml.g4dn.12xlarge" => ProcessingInstanceType::MlG4Dn12Xlarge,
            "ml.g4dn.16xlarge" => ProcessingInstanceType::MlG4Dn16Xlarge,
            "ml.g4dn.2xlarge" => ProcessingInstanceType::MlG4Dn2Xlarge,
            "ml.g4dn.4xlarge" => ProcessingInstanceType::MlG4Dn4Xlarge,
            "ml.g4dn.8xlarge" => ProcessingInstanceType::MlG4Dn8Xlarge,
            "ml.g4dn.xlarge" => ProcessingInstanceType::MlG4DnXlarge,
            "ml.m4.10xlarge" => ProcessingInstanceType::MlM410Xlarge,
            "ml.m4.16xlarge" => ProcessingInstanceType::MlM416Xlarge,
            "ml.m4.2xlarge" => ProcessingInstanceType::MlM42Xlarge,
            "ml.m4.4xlarge" => ProcessingInstanceType::MlM44Xlarge,
            "ml.m4.xlarge" => ProcessingInstanceType::MlM4Xlarge,
            "ml.m5.12xlarge" => ProcessingInstanceType::MlM512Xlarge,
            "ml.m5.24xlarge" => ProcessingInstanceType::MlM524Xlarge,
            "ml.m5.2xlarge" => ProcessingInstanceType::MlM52Xlarge,
            "ml.m5.4xlarge" => ProcessingInstanceType::MlM54Xlarge,
            "ml.m5.large" => ProcessingInstanceType::MlM5Large,
            "ml.m5.xlarge" => ProcessingInstanceType::MlM5Xlarge,
            "ml.p2.16xlarge" => ProcessingInstanceType::MlP216Xlarge,
            "ml.p2.8xlarge" => ProcessingInstanceType::MlP28Xlarge,
            "ml.p2.xlarge" => ProcessingInstanceType::MlP2Xlarge,
            "ml.p3.16xlarge" => ProcessingInstanceType::MlP316Xlarge,
            "ml.p3.2xlarge" => ProcessingInstanceType::MlP32Xlarge,
            "ml.p3.8xlarge" => ProcessingInstanceType::MlP38Xlarge,
            "ml.r5.12xlarge" => ProcessingInstanceType::MlR512Xlarge,
            "ml.r5.16xlarge" => ProcessingInstanceType::MlR516Xlarge,
            "ml.r5.24xlarge" => ProcessingInstanceType::MlR524Xlarge,
            "ml.r5.2xlarge" => ProcessingInstanceType::MlR52Xlarge,
            "ml.r5.4xlarge" => ProcessingInstanceType::MlR54Xlarge,
            "ml.r5.8xlarge" => ProcessingInstanceType::MlR58Xlarge,
            "ml.r5.large" => ProcessingInstanceType::MlR5Large,
            "ml.r5.xlarge" => ProcessingInstanceType::MlR5Xlarge,
            "ml.t3.2xlarge" => ProcessingInstanceType::MlT32Xlarge,
            "ml.t3.large" => ProcessingInstanceType::MlT3Large,
            "ml.t3.medium" => ProcessingInstanceType::MlT3Medium,
            "ml.t3.xlarge" => ProcessingInstanceType::MlT3Xlarge,
            other => ProcessingInstanceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProcessingInstanceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProcessingInstanceType::from(s))
    }
}
impl ProcessingInstanceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProcessingInstanceType::MlC42Xlarge => "ml.c4.2xlarge",
            ProcessingInstanceType::MlC44Xlarge => "ml.c4.4xlarge",
            ProcessingInstanceType::MlC48Xlarge => "ml.c4.8xlarge",
            ProcessingInstanceType::MlC4Xlarge => "ml.c4.xlarge",
            ProcessingInstanceType::MlC518Xlarge => "ml.c5.18xlarge",
            ProcessingInstanceType::MlC52Xlarge => "ml.c5.2xlarge",
            ProcessingInstanceType::MlC54Xlarge => "ml.c5.4xlarge",
            ProcessingInstanceType::MlC59Xlarge => "ml.c5.9xlarge",
            ProcessingInstanceType::MlC5Xlarge => "ml.c5.xlarge",
            ProcessingInstanceType::MlG4Dn12Xlarge => "ml.g4dn.12xlarge",
            ProcessingInstanceType::MlG4Dn16Xlarge => "ml.g4dn.16xlarge",
            ProcessingInstanceType::MlG4Dn2Xlarge => "ml.g4dn.2xlarge",
            ProcessingInstanceType::MlG4Dn4Xlarge => "ml.g4dn.4xlarge",
            ProcessingInstanceType::MlG4Dn8Xlarge => "ml.g4dn.8xlarge",
            ProcessingInstanceType::MlG4DnXlarge => "ml.g4dn.xlarge",
            ProcessingInstanceType::MlM410Xlarge => "ml.m4.10xlarge",
            ProcessingInstanceType::MlM416Xlarge => "ml.m4.16xlarge",
            ProcessingInstanceType::MlM42Xlarge => "ml.m4.2xlarge",
            ProcessingInstanceType::MlM44Xlarge => "ml.m4.4xlarge",
            ProcessingInstanceType::MlM4Xlarge => "ml.m4.xlarge",
            ProcessingInstanceType::MlM512Xlarge => "ml.m5.12xlarge",
            ProcessingInstanceType::MlM524Xlarge => "ml.m5.24xlarge",
            ProcessingInstanceType::MlM52Xlarge => "ml.m5.2xlarge",
            ProcessingInstanceType::MlM54Xlarge => "ml.m5.4xlarge",
            ProcessingInstanceType::MlM5Large => "ml.m5.large",
            ProcessingInstanceType::MlM5Xlarge => "ml.m5.xlarge",
            ProcessingInstanceType::MlP216Xlarge => "ml.p2.16xlarge",
            ProcessingInstanceType::MlP28Xlarge => "ml.p2.8xlarge",
            ProcessingInstanceType::MlP2Xlarge => "ml.p2.xlarge",
            ProcessingInstanceType::MlP316Xlarge => "ml.p3.16xlarge",
            ProcessingInstanceType::MlP32Xlarge => "ml.p3.2xlarge",
            ProcessingInstanceType::MlP38Xlarge => "ml.p3.8xlarge",
            ProcessingInstanceType::MlR512Xlarge => "ml.r5.12xlarge",
            ProcessingInstanceType::MlR516Xlarge => "ml.r5.16xlarge",
            ProcessingInstanceType::MlR524Xlarge => "ml.r5.24xlarge",
            ProcessingInstanceType::MlR52Xlarge => "ml.r5.2xlarge",
            ProcessingInstanceType::MlR54Xlarge => "ml.r5.4xlarge",
            ProcessingInstanceType::MlR58Xlarge => "ml.r5.8xlarge",
            ProcessingInstanceType::MlR5Large => "ml.r5.large",
            ProcessingInstanceType::MlR5Xlarge => "ml.r5.xlarge",
            ProcessingInstanceType::MlT32Xlarge => "ml.t3.2xlarge",
            ProcessingInstanceType::MlT3Large => "ml.t3.large",
            ProcessingInstanceType::MlT3Medium => "ml.t3.medium",
            ProcessingInstanceType::MlT3Xlarge => "ml.t3.xlarge",
            ProcessingInstanceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ml.c4.2xlarge",
            "ml.c4.4xlarge",
            "ml.c4.8xlarge",
            "ml.c4.xlarge",
            "ml.c5.18xlarge",
            "ml.c5.2xlarge",
            "ml.c5.4xlarge",
            "ml.c5.9xlarge",
            "ml.c5.xlarge",
            "ml.g4dn.12xlarge",
            "ml.g4dn.16xlarge",
            "ml.g4dn.2xlarge",
            "ml.g4dn.4xlarge",
            "ml.g4dn.8xlarge",
            "ml.g4dn.xlarge",
            "ml.m4.10xlarge",
            "ml.m4.16xlarge",
            "ml.m4.2xlarge",
            "ml.m4.4xlarge",
            "ml.m4.xlarge",
            "ml.m5.12xlarge",
            "ml.m5.24xlarge",
            "ml.m5.2xlarge",
            "ml.m5.4xlarge",
            "ml.m5.large",
            "ml.m5.xlarge",
            "ml.p2.16xlarge",
            "ml.p2.8xlarge",
            "ml.p2.xlarge",
            "ml.p3.16xlarge",
            "ml.p3.2xlarge",
            "ml.p3.8xlarge",
            "ml.r5.12xlarge",
            "ml.r5.16xlarge",
            "ml.r5.24xlarge",
            "ml.r5.2xlarge",
            "ml.r5.4xlarge",
            "ml.r5.8xlarge",
            "ml.r5.large",
            "ml.r5.xlarge",
            "ml.t3.2xlarge",
            "ml.t3.large",
            "ml.t3.medium",
            "ml.t3.xlarge",
        ]
    }
}
impl AsRef<str> for ProcessingInstanceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Configuration information for updating the Debugger profile parameters, system and framework metrics configurations, and
/// storage paths.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProfilerConfigForUpdate {
    /// <p>Path to Amazon S3 storage location for system and framework metrics.</p>
    pub s3_output_path: std::option::Option<std::string::String>,
    /// <p>A time interval for capturing system metrics in milliseconds. Available values are
    /// 100, 200, 500, 1000 (1 second), 5000 (5 seconds), and 60000 (1 minute) milliseconds. The default value is 500 milliseconds.</p>
    pub profiling_interval_in_milliseconds: std::option::Option<i64>,
    /// <p>Configuration information for capturing framework metrics. Available key strings for different profiling options are
    /// <code>DetailedProfilingConfig</code>, <code>PythonProfilingConfig</code>, and <code>DataLoaderProfilingConfig</code>.
    /// The following codes are configuration structures for the <code>ProfilingParameters</code> parameter. To learn more about
    /// how to configure the <code>ProfilingParameters</code> parameter,
    /// see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html">Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job</a>.
    /// </p>
    pub profiling_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>To disable Debugger monitoring and profiling, set to <code>True</code>.</p>
    pub disable_profiler: bool,
}
impl ProfilerConfigForUpdate {
    /// <p>Path to Amazon S3 storage location for system and framework metrics.</p>
    pub fn s3_output_path(&self) -> std::option::Option<&str> {
        self.s3_output_path.as_deref()
    }
    /// <p>A time interval for capturing system metrics in milliseconds. Available values are
    /// 100, 200, 500, 1000 (1 second), 5000 (5 seconds), and 60000 (1 minute) milliseconds. The default value is 500 milliseconds.</p>
    pub fn profiling_interval_in_milliseconds(&self) -> std::option::Option<i64> {
        self.profiling_interval_in_milliseconds
    }
    /// <p>Configuration information for capturing framework metrics. Available key strings for different profiling options are
    /// <code>DetailedProfilingConfig</code>, <code>PythonProfilingConfig</code>, and <code>DataLoaderProfilingConfig</code>.
    /// The following codes are configuration structures for the <code>ProfilingParameters</code> parameter. To learn more about
    /// how to configure the <code>ProfilingParameters</code> parameter,
    /// see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html">Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job</a>.
    /// </p>
    pub fn profiling_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.profiling_parameters.as_ref()
    }
    /// <p>To disable Debugger monitoring and profiling, set to <code>True</code>.</p>
    pub fn disable_profiler(&self) -> bool {
        self.disable_profiler
    }
}
impl std::fmt::Debug for ProfilerConfigForUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProfilerConfigForUpdate");
        formatter.field("s3_output_path", &self.s3_output_path);
        formatter.field(
            "profiling_interval_in_milliseconds",
            &self.profiling_interval_in_milliseconds,
        );
        formatter.field("profiling_parameters", &self.profiling_parameters);
        formatter.field("disable_profiler", &self.disable_profiler);
        formatter.finish()
    }
}
/// See [`ProfilerConfigForUpdate`](crate::model::ProfilerConfigForUpdate)
pub mod profiler_config_for_update {
    /// A builder for [`ProfilerConfigForUpdate`](crate::model::ProfilerConfigForUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_output_path: std::option::Option<std::string::String>,
        pub(crate) profiling_interval_in_milliseconds: std::option::Option<i64>,
        pub(crate) profiling_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) disable_profiler: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Path to Amazon S3 storage location for system and framework metrics.</p>
        pub fn s3_output_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_output_path = Some(input.into());
            self
        }
        /// <p>Path to Amazon S3 storage location for system and framework metrics.</p>
        pub fn set_s3_output_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_output_path = input;
            self
        }
        /// <p>A time interval for capturing system metrics in milliseconds. Available values are
        /// 100, 200, 500, 1000 (1 second), 5000 (5 seconds), and 60000 (1 minute) milliseconds. The default value is 500 milliseconds.</p>
        pub fn profiling_interval_in_milliseconds(mut self, input: i64) -> Self {
            self.profiling_interval_in_milliseconds = Some(input);
            self
        }
        /// <p>A time interval for capturing system metrics in milliseconds. Available values are
        /// 100, 200, 500, 1000 (1 second), 5000 (5 seconds), and 60000 (1 minute) milliseconds. The default value is 500 milliseconds.</p>
        pub fn set_profiling_interval_in_milliseconds(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.profiling_interval_in_milliseconds = input;
            self
        }
        /// Adds a key-value pair to `profiling_parameters`.
        ///
        /// To override the contents of this collection use [`set_profiling_parameters`](Self::set_profiling_parameters).
        ///
        /// <p>Configuration information for capturing framework metrics. Available key strings for different profiling options are
        /// <code>DetailedProfilingConfig</code>, <code>PythonProfilingConfig</code>, and <code>DataLoaderProfilingConfig</code>.
        /// The following codes are configuration structures for the <code>ProfilingParameters</code> parameter. To learn more about
        /// how to configure the <code>ProfilingParameters</code> parameter,
        /// see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html">Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job</a>.
        /// </p>
        pub fn profiling_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.profiling_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.profiling_parameters = Some(hash_map);
            self
        }
        /// <p>Configuration information for capturing framework metrics. Available key strings for different profiling options are
        /// <code>DetailedProfilingConfig</code>, <code>PythonProfilingConfig</code>, and <code>DataLoaderProfilingConfig</code>.
        /// The following codes are configuration structures for the <code>ProfilingParameters</code> parameter. To learn more about
        /// how to configure the <code>ProfilingParameters</code> parameter,
        /// see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html">Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job</a>.
        /// </p>
        pub fn set_profiling_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.profiling_parameters = input;
            self
        }
        /// <p>To disable Debugger monitoring and profiling, set to <code>True</code>.</p>
        pub fn disable_profiler(mut self, input: bool) -> Self {
            self.disable_profiler = Some(input);
            self
        }
        /// <p>To disable Debugger monitoring and profiling, set to <code>True</code>.</p>
        pub fn set_disable_profiler(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_profiler = input;
            self
        }
        /// Consumes the builder and constructs a [`ProfilerConfigForUpdate`](crate::model::ProfilerConfigForUpdate)
        pub fn build(self) -> crate::model::ProfilerConfigForUpdate {
            crate::model::ProfilerConfigForUpdate {
                s3_output_path: self.s3_output_path,
                profiling_interval_in_milliseconds: self.profiling_interval_in_milliseconds,
                profiling_parameters: self.profiling_parameters,
                disable_profiler: self.disable_profiler.unwrap_or_default(),
            }
        }
    }
}
impl ProfilerConfigForUpdate {
    /// Creates a new builder-style object to manufacture [`ProfilerConfigForUpdate`](crate::model::ProfilerConfigForUpdate)
    pub fn builder() -> crate::model::profiler_config_for_update::Builder {
        crate::model::profiler_config_for_update::Builder::default()
    }
}

/// <p>A tag object that consists of a key and an optional value, used to manage metadata
/// for SageMaker Amazon Web Services resources.</p>
/// <p>You can add tags to notebook instances, training jobs, hyperparameter tuning jobs,
/// batch transform jobs, models, labeling jobs, work teams, endpoint configurations, and
/// endpoints. For more information on adding tags to SageMaker resources, see <a>AddTags</a>.</p>
/// <p>For more information on adding metadata to your Amazon Web Services resources with tagging, see
/// <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
/// resources</a>. For advice on best practices for managing Amazon Web Services resources with
/// tagging, see <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging
/// Best Practices: Implement an Effective Amazon Web Services Resource Tagging Strategy</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The tag key. Tag keys must be unique per resource.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The tag value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The tag key. Tag keys must be unique per resource.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The tag value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The tag key. Tag keys must be unique per resource.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The tag key. Tag keys must be unique per resource.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The tag value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The tag value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Details that you specify to provision a service catalog product.
/// For information about service catalog, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services Service Catalog</a>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceCatalogProvisioningUpdateDetails {
    /// <p>The ID of the provisioning artifact.</p>
    pub provisioning_artifact_id: std::option::Option<std::string::String>,
    /// <p>A list of key value pairs that you specify when you provision a product.</p>
    pub provisioning_parameters:
        std::option::Option<std::vec::Vec<crate::model::ProvisioningParameter>>,
}
impl ServiceCatalogProvisioningUpdateDetails {
    /// <p>The ID of the provisioning artifact.</p>
    pub fn provisioning_artifact_id(&self) -> std::option::Option<&str> {
        self.provisioning_artifact_id.as_deref()
    }
    /// <p>A list of key value pairs that you specify when you provision a product.</p>
    pub fn provisioning_parameters(
        &self,
    ) -> std::option::Option<&[crate::model::ProvisioningParameter]> {
        self.provisioning_parameters.as_deref()
    }
}
impl std::fmt::Debug for ServiceCatalogProvisioningUpdateDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceCatalogProvisioningUpdateDetails");
        formatter.field("provisioning_artifact_id", &self.provisioning_artifact_id);
        formatter.field("provisioning_parameters", &self.provisioning_parameters);
        formatter.finish()
    }
}
/// See [`ServiceCatalogProvisioningUpdateDetails`](crate::model::ServiceCatalogProvisioningUpdateDetails)
pub mod service_catalog_provisioning_update_details {
    /// A builder for [`ServiceCatalogProvisioningUpdateDetails`](crate::model::ServiceCatalogProvisioningUpdateDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) provisioning_artifact_id: std::option::Option<std::string::String>,
        pub(crate) provisioning_parameters:
            std::option::Option<std::vec::Vec<crate::model::ProvisioningParameter>>,
    }
    impl Builder {
        /// <p>The ID of the provisioning artifact.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioning_artifact_id = Some(input.into());
            self
        }
        /// <p>The ID of the provisioning artifact.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioning_artifact_id = input;
            self
        }
        /// Appends an item to `provisioning_parameters`.
        ///
        /// To override the contents of this collection use [`set_provisioning_parameters`](Self::set_provisioning_parameters).
        ///
        /// <p>A list of key value pairs that you specify when you provision a product.</p>
        pub fn provisioning_parameters(
            mut self,
            input: impl Into<crate::model::ProvisioningParameter>,
        ) -> Self {
            let mut v = self.provisioning_parameters.unwrap_or_default();
            v.push(input.into());
            self.provisioning_parameters = Some(v);
            self
        }
        /// <p>A list of key value pairs that you specify when you provision a product.</p>
        pub fn set_provisioning_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProvisioningParameter>>,
        ) -> Self {
            self.provisioning_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceCatalogProvisioningUpdateDetails`](crate::model::ServiceCatalogProvisioningUpdateDetails)
        pub fn build(self) -> crate::model::ServiceCatalogProvisioningUpdateDetails {
            crate::model::ServiceCatalogProvisioningUpdateDetails {
                provisioning_artifact_id: self.provisioning_artifact_id,
                provisioning_parameters: self.provisioning_parameters,
            }
        }
    }
}
impl ServiceCatalogProvisioningUpdateDetails {
    /// Creates a new builder-style object to manufacture [`ServiceCatalogProvisioningUpdateDetails`](crate::model::ServiceCatalogProvisioningUpdateDetails)
    pub fn builder() -> crate::model::service_catalog_provisioning_update_details::Builder {
        crate::model::service_catalog_provisioning_update_details::Builder::default()
    }
}

/// <p>A key value pair used when you provision a project as a service catalog product. For
/// information, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services Service
/// Catalog</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisioningParameter {
    /// <p>The key that identifies a provisioning parameter.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of the provisioning parameter.</p>
    pub value: std::option::Option<std::string::String>,
}
impl ProvisioningParameter {
    /// <p>The key that identifies a provisioning parameter.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value of the provisioning parameter.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for ProvisioningParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisioningParameter");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`ProvisioningParameter`](crate::model::ProvisioningParameter)
pub mod provisioning_parameter {
    /// A builder for [`ProvisioningParameter`](crate::model::ProvisioningParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key that identifies a provisioning parameter.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key that identifies a provisioning parameter.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of the provisioning parameter.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the provisioning parameter.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisioningParameter`](crate::model::ProvisioningParameter)
        pub fn build(self) -> crate::model::ProvisioningParameter {
            crate::model::ProvisioningParameter {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl ProvisioningParameter {
    /// Creates a new builder-style object to manufacture [`ProvisioningParameter`](crate::model::ProvisioningParameter)
    pub fn builder() -> crate::model::provisioning_parameter::Builder {
        crate::model::provisioning_parameter::Builder::default()
    }
}

/// <p>Contains the notebook instance lifecycle configuration script.</p>
/// <p>Each lifecycle configuration script has a limit of 16384 characters.</p>
/// <p>The value of the <code>$PATH</code> environment variable that is available to both
/// scripts is <code>/sbin:bin:/usr/sbin:/usr/bin</code>.</p>
/// <p>View CloudWatch Logs for notebook instance lifecycle configurations in log group
/// <code>/aws/sagemaker/NotebookInstances</code> in log stream
/// <code>[notebook-instance-name]/[LifecycleConfigHook]</code>.</p>
/// <p>Lifecycle configuration scripts cannot run for longer than 5 minutes. If a script runs
/// for longer than 5 minutes, it fails and the notebook instance is not created or
/// started.</p>
/// <p>For information about notebook instance lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step
/// 2.1: (Optional) Customize a Notebook Instance</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotebookInstanceLifecycleHook {
    /// <p>A base64-encoded string that contains a shell script for a notebook instance lifecycle
    /// configuration.</p>
    pub content: std::option::Option<std::string::String>,
}
impl NotebookInstanceLifecycleHook {
    /// <p>A base64-encoded string that contains a shell script for a notebook instance lifecycle
    /// configuration.</p>
    pub fn content(&self) -> std::option::Option<&str> {
        self.content.as_deref()
    }
}
impl std::fmt::Debug for NotebookInstanceLifecycleHook {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotebookInstanceLifecycleHook");
        formatter.field("content", &self.content);
        formatter.finish()
    }
}
/// See [`NotebookInstanceLifecycleHook`](crate::model::NotebookInstanceLifecycleHook)
pub mod notebook_instance_lifecycle_hook {
    /// A builder for [`NotebookInstanceLifecycleHook`](crate::model::NotebookInstanceLifecycleHook)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A base64-encoded string that contains a shell script for a notebook instance lifecycle
        /// configuration.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>A base64-encoded string that contains a shell script for a notebook instance lifecycle
        /// configuration.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// Consumes the builder and constructs a [`NotebookInstanceLifecycleHook`](crate::model::NotebookInstanceLifecycleHook)
        pub fn build(self) -> crate::model::NotebookInstanceLifecycleHook {
            crate::model::NotebookInstanceLifecycleHook {
                content: self.content,
            }
        }
    }
}
impl NotebookInstanceLifecycleHook {
    /// Creates a new builder-style object to manufacture [`NotebookInstanceLifecycleHook`](crate::model::NotebookInstanceLifecycleHook)
    pub fn builder() -> crate::model::notebook_instance_lifecycle_hook::Builder {
        crate::model::notebook_instance_lifecycle_hook::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RootAccess {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RootAccess {
    fn from(s: &str) -> Self {
        match s {
            "Disabled" => RootAccess::Disabled,
            "Enabled" => RootAccess::Enabled,
            other => RootAccess::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RootAccess {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RootAccess::from(s))
    }
}
impl RootAccess {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RootAccess::Disabled => "Disabled",
            RootAccess::Enabled => "Enabled",
            RootAccess::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Disabled", "Enabled"]
    }
}
impl AsRef<str> for RootAccess {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NotebookInstanceAcceleratorType {
    #[allow(missing_docs)] // documentation missing in model
    MlEia1Large,
    #[allow(missing_docs)] // documentation missing in model
    MlEia1Medium,
    #[allow(missing_docs)] // documentation missing in model
    MlEia1Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlEia2Large,
    #[allow(missing_docs)] // documentation missing in model
    MlEia2Medium,
    #[allow(missing_docs)] // documentation missing in model
    MlEia2Xlarge,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NotebookInstanceAcceleratorType {
    fn from(s: &str) -> Self {
        match s {
            "ml.eia1.large" => NotebookInstanceAcceleratorType::MlEia1Large,
            "ml.eia1.medium" => NotebookInstanceAcceleratorType::MlEia1Medium,
            "ml.eia1.xlarge" => NotebookInstanceAcceleratorType::MlEia1Xlarge,
            "ml.eia2.large" => NotebookInstanceAcceleratorType::MlEia2Large,
            "ml.eia2.medium" => NotebookInstanceAcceleratorType::MlEia2Medium,
            "ml.eia2.xlarge" => NotebookInstanceAcceleratorType::MlEia2Xlarge,
            other => NotebookInstanceAcceleratorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NotebookInstanceAcceleratorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NotebookInstanceAcceleratorType::from(s))
    }
}
impl NotebookInstanceAcceleratorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NotebookInstanceAcceleratorType::MlEia1Large => "ml.eia1.large",
            NotebookInstanceAcceleratorType::MlEia1Medium => "ml.eia1.medium",
            NotebookInstanceAcceleratorType::MlEia1Xlarge => "ml.eia1.xlarge",
            NotebookInstanceAcceleratorType::MlEia2Large => "ml.eia2.large",
            NotebookInstanceAcceleratorType::MlEia2Medium => "ml.eia2.medium",
            NotebookInstanceAcceleratorType::MlEia2Xlarge => "ml.eia2.xlarge",
            NotebookInstanceAcceleratorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ml.eia1.large",
            "ml.eia1.medium",
            "ml.eia1.xlarge",
            "ml.eia2.large",
            "ml.eia2.medium",
            "ml.eia2.xlarge",
        ]
    }
}
impl AsRef<str> for NotebookInstanceAcceleratorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceType {
    #[allow(missing_docs)] // documentation missing in model
    MlC42Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC44Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC48Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC4Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC518Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC52Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC54Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC59Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC5Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC5D18Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC5D2Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC5D4Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC5D9Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC5DXlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4Dn12Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4Dn16Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4Dn2Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4Dn4Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4Dn8Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4DnXlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM410Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM416Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM42Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM44Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM4Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM512Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM524Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM52Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM54Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM5Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM5D12Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM5D16Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM5D24Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM5D2Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM5D4Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM5D8Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM5DLarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM5DXlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlP216Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlP28Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlP2Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlP316Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlP32Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlP38Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlP3Dn24Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR512Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR516Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR524Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR52Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR54Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR58Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR5Large,
    #[allow(missing_docs)] // documentation missing in model
    MlR5Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlT22Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlT2Large,
    #[allow(missing_docs)] // documentation missing in model
    MlT2Medium,
    #[allow(missing_docs)] // documentation missing in model
    MlT2Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlT32Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlT3Large,
    #[allow(missing_docs)] // documentation missing in model
    MlT3Medium,
    #[allow(missing_docs)] // documentation missing in model
    MlT3Xlarge,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceType {
    fn from(s: &str) -> Self {
        match s {
            "ml.c4.2xlarge" => InstanceType::MlC42Xlarge,
            "ml.c4.4xlarge" => InstanceType::MlC44Xlarge,
            "ml.c4.8xlarge" => InstanceType::MlC48Xlarge,
            "ml.c4.xlarge" => InstanceType::MlC4Xlarge,
            "ml.c5.18xlarge" => InstanceType::MlC518Xlarge,
            "ml.c5.2xlarge" => InstanceType::MlC52Xlarge,
            "ml.c5.4xlarge" => InstanceType::MlC54Xlarge,
            "ml.c5.9xlarge" => InstanceType::MlC59Xlarge,
            "ml.c5.xlarge" => InstanceType::MlC5Xlarge,
            "ml.c5d.18xlarge" => InstanceType::MlC5D18Xlarge,
            "ml.c5d.2xlarge" => InstanceType::MlC5D2Xlarge,
            "ml.c5d.4xlarge" => InstanceType::MlC5D4Xlarge,
            "ml.c5d.9xlarge" => InstanceType::MlC5D9Xlarge,
            "ml.c5d.xlarge" => InstanceType::MlC5DXlarge,
            "ml.g4dn.12xlarge" => InstanceType::MlG4Dn12Xlarge,
            "ml.g4dn.16xlarge" => InstanceType::MlG4Dn16Xlarge,
            "ml.g4dn.2xlarge" => InstanceType::MlG4Dn2Xlarge,
            "ml.g4dn.4xlarge" => InstanceType::MlG4Dn4Xlarge,
            "ml.g4dn.8xlarge" => InstanceType::MlG4Dn8Xlarge,
            "ml.g4dn.xlarge" => InstanceType::MlG4DnXlarge,
            "ml.m4.10xlarge" => InstanceType::MlM410Xlarge,
            "ml.m4.16xlarge" => InstanceType::MlM416Xlarge,
            "ml.m4.2xlarge" => InstanceType::MlM42Xlarge,
            "ml.m4.4xlarge" => InstanceType::MlM44Xlarge,
            "ml.m4.xlarge" => InstanceType::MlM4Xlarge,
            "ml.m5.12xlarge" => InstanceType::MlM512Xlarge,
            "ml.m5.24xlarge" => InstanceType::MlM524Xlarge,
            "ml.m5.2xlarge" => InstanceType::MlM52Xlarge,
            "ml.m5.4xlarge" => InstanceType::MlM54Xlarge,
            "ml.m5.xlarge" => InstanceType::MlM5Xlarge,
            "ml.m5d.12xlarge" => InstanceType::MlM5D12Xlarge,
            "ml.m5d.16xlarge" => InstanceType::MlM5D16Xlarge,
            "ml.m5d.24xlarge" => InstanceType::MlM5D24Xlarge,
            "ml.m5d.2xlarge" => InstanceType::MlM5D2Xlarge,
            "ml.m5d.4xlarge" => InstanceType::MlM5D4Xlarge,
            "ml.m5d.8xlarge" => InstanceType::MlM5D8Xlarge,
            "ml.m5d.large" => InstanceType::MlM5DLarge,
            "ml.m5d.xlarge" => InstanceType::MlM5DXlarge,
            "ml.p2.16xlarge" => InstanceType::MlP216Xlarge,
            "ml.p2.8xlarge" => InstanceType::MlP28Xlarge,
            "ml.p2.xlarge" => InstanceType::MlP2Xlarge,
            "ml.p3.16xlarge" => InstanceType::MlP316Xlarge,
            "ml.p3.2xlarge" => InstanceType::MlP32Xlarge,
            "ml.p3.8xlarge" => InstanceType::MlP38Xlarge,
            "ml.p3dn.24xlarge" => InstanceType::MlP3Dn24Xlarge,
            "ml.r5.12xlarge" => InstanceType::MlR512Xlarge,
            "ml.r5.16xlarge" => InstanceType::MlR516Xlarge,
            "ml.r5.24xlarge" => InstanceType::MlR524Xlarge,
            "ml.r5.2xlarge" => InstanceType::MlR52Xlarge,
            "ml.r5.4xlarge" => InstanceType::MlR54Xlarge,
            "ml.r5.8xlarge" => InstanceType::MlR58Xlarge,
            "ml.r5.large" => InstanceType::MlR5Large,
            "ml.r5.xlarge" => InstanceType::MlR5Xlarge,
            "ml.t2.2xlarge" => InstanceType::MlT22Xlarge,
            "ml.t2.large" => InstanceType::MlT2Large,
            "ml.t2.medium" => InstanceType::MlT2Medium,
            "ml.t2.xlarge" => InstanceType::MlT2Xlarge,
            "ml.t3.2xlarge" => InstanceType::MlT32Xlarge,
            "ml.t3.large" => InstanceType::MlT3Large,
            "ml.t3.medium" => InstanceType::MlT3Medium,
            "ml.t3.xlarge" => InstanceType::MlT3Xlarge,
            other => InstanceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceType::from(s))
    }
}
impl InstanceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceType::MlC42Xlarge => "ml.c4.2xlarge",
            InstanceType::MlC44Xlarge => "ml.c4.4xlarge",
            InstanceType::MlC48Xlarge => "ml.c4.8xlarge",
            InstanceType::MlC4Xlarge => "ml.c4.xlarge",
            InstanceType::MlC518Xlarge => "ml.c5.18xlarge",
            InstanceType::MlC52Xlarge => "ml.c5.2xlarge",
            InstanceType::MlC54Xlarge => "ml.c5.4xlarge",
            InstanceType::MlC59Xlarge => "ml.c5.9xlarge",
            InstanceType::MlC5Xlarge => "ml.c5.xlarge",
            InstanceType::MlC5D18Xlarge => "ml.c5d.18xlarge",
            InstanceType::MlC5D2Xlarge => "ml.c5d.2xlarge",
            InstanceType::MlC5D4Xlarge => "ml.c5d.4xlarge",
            InstanceType::MlC5D9Xlarge => "ml.c5d.9xlarge",
            InstanceType::MlC5DXlarge => "ml.c5d.xlarge",
            InstanceType::MlG4Dn12Xlarge => "ml.g4dn.12xlarge",
            InstanceType::MlG4Dn16Xlarge => "ml.g4dn.16xlarge",
            InstanceType::MlG4Dn2Xlarge => "ml.g4dn.2xlarge",
            InstanceType::MlG4Dn4Xlarge => "ml.g4dn.4xlarge",
            InstanceType::MlG4Dn8Xlarge => "ml.g4dn.8xlarge",
            InstanceType::MlG4DnXlarge => "ml.g4dn.xlarge",
            InstanceType::MlM410Xlarge => "ml.m4.10xlarge",
            InstanceType::MlM416Xlarge => "ml.m4.16xlarge",
            InstanceType::MlM42Xlarge => "ml.m4.2xlarge",
            InstanceType::MlM44Xlarge => "ml.m4.4xlarge",
            InstanceType::MlM4Xlarge => "ml.m4.xlarge",
            InstanceType::MlM512Xlarge => "ml.m5.12xlarge",
            InstanceType::MlM524Xlarge => "ml.m5.24xlarge",
            InstanceType::MlM52Xlarge => "ml.m5.2xlarge",
            InstanceType::MlM54Xlarge => "ml.m5.4xlarge",
            InstanceType::MlM5Xlarge => "ml.m5.xlarge",
            InstanceType::MlM5D12Xlarge => "ml.m5d.12xlarge",
            InstanceType::MlM5D16Xlarge => "ml.m5d.16xlarge",
            InstanceType::MlM5D24Xlarge => "ml.m5d.24xlarge",
            InstanceType::MlM5D2Xlarge => "ml.m5d.2xlarge",
            InstanceType::MlM5D4Xlarge => "ml.m5d.4xlarge",
            InstanceType::MlM5D8Xlarge => "ml.m5d.8xlarge",
            InstanceType::MlM5DLarge => "ml.m5d.large",
            InstanceType::MlM5DXlarge => "ml.m5d.xlarge",
            InstanceType::MlP216Xlarge => "ml.p2.16xlarge",
            InstanceType::MlP28Xlarge => "ml.p2.8xlarge",
            InstanceType::MlP2Xlarge => "ml.p2.xlarge",
            InstanceType::MlP316Xlarge => "ml.p3.16xlarge",
            InstanceType::MlP32Xlarge => "ml.p3.2xlarge",
            InstanceType::MlP38Xlarge => "ml.p3.8xlarge",
            InstanceType::MlP3Dn24Xlarge => "ml.p3dn.24xlarge",
            InstanceType::MlR512Xlarge => "ml.r5.12xlarge",
            InstanceType::MlR516Xlarge => "ml.r5.16xlarge",
            InstanceType::MlR524Xlarge => "ml.r5.24xlarge",
            InstanceType::MlR52Xlarge => "ml.r5.2xlarge",
            InstanceType::MlR54Xlarge => "ml.r5.4xlarge",
            InstanceType::MlR58Xlarge => "ml.r5.8xlarge",
            InstanceType::MlR5Large => "ml.r5.large",
            InstanceType::MlR5Xlarge => "ml.r5.xlarge",
            InstanceType::MlT22Xlarge => "ml.t2.2xlarge",
            InstanceType::MlT2Large => "ml.t2.large",
            InstanceType::MlT2Medium => "ml.t2.medium",
            InstanceType::MlT2Xlarge => "ml.t2.xlarge",
            InstanceType::MlT32Xlarge => "ml.t3.2xlarge",
            InstanceType::MlT3Large => "ml.t3.large",
            InstanceType::MlT3Medium => "ml.t3.medium",
            InstanceType::MlT3Xlarge => "ml.t3.xlarge",
            InstanceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ml.c4.2xlarge",
            "ml.c4.4xlarge",
            "ml.c4.8xlarge",
            "ml.c4.xlarge",
            "ml.c5.18xlarge",
            "ml.c5.2xlarge",
            "ml.c5.4xlarge",
            "ml.c5.9xlarge",
            "ml.c5.xlarge",
            "ml.c5d.18xlarge",
            "ml.c5d.2xlarge",
            "ml.c5d.4xlarge",
            "ml.c5d.9xlarge",
            "ml.c5d.xlarge",
            "ml.g4dn.12xlarge",
            "ml.g4dn.16xlarge",
            "ml.g4dn.2xlarge",
            "ml.g4dn.4xlarge",
            "ml.g4dn.8xlarge",
            "ml.g4dn.xlarge",
            "ml.m4.10xlarge",
            "ml.m4.16xlarge",
            "ml.m4.2xlarge",
            "ml.m4.4xlarge",
            "ml.m4.xlarge",
            "ml.m5.12xlarge",
            "ml.m5.24xlarge",
            "ml.m5.2xlarge",
            "ml.m5.4xlarge",
            "ml.m5.xlarge",
            "ml.m5d.12xlarge",
            "ml.m5d.16xlarge",
            "ml.m5d.24xlarge",
            "ml.m5d.2xlarge",
            "ml.m5d.4xlarge",
            "ml.m5d.8xlarge",
            "ml.m5d.large",
            "ml.m5d.xlarge",
            "ml.p2.16xlarge",
            "ml.p2.8xlarge",
            "ml.p2.xlarge",
            "ml.p3.16xlarge",
            "ml.p3.2xlarge",
            "ml.p3.8xlarge",
            "ml.p3dn.24xlarge",
            "ml.r5.12xlarge",
            "ml.r5.16xlarge",
            "ml.r5.24xlarge",
            "ml.r5.2xlarge",
            "ml.r5.4xlarge",
            "ml.r5.8xlarge",
            "ml.r5.large",
            "ml.r5.xlarge",
            "ml.t2.2xlarge",
            "ml.t2.large",
            "ml.t2.medium",
            "ml.t2.xlarge",
            "ml.t3.2xlarge",
            "ml.t3.large",
            "ml.t3.medium",
            "ml.t3.xlarge",
        ]
    }
}
impl AsRef<str> for InstanceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Configures the monitoring schedule and defines the monitoring job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MonitoringScheduleConfig {
    /// <p>Configures the monitoring schedule.</p>
    pub schedule_config: std::option::Option<crate::model::ScheduleConfig>,
    /// <p>Defines the monitoring job.</p>
    pub monitoring_job_definition: std::option::Option<crate::model::MonitoringJobDefinition>,
    /// <p>The name of the monitoring job definition to schedule.</p>
    pub monitoring_job_definition_name: std::option::Option<std::string::String>,
    /// <p>The type of the monitoring job definition to schedule.</p>
    pub monitoring_type: std::option::Option<crate::model::MonitoringType>,
}
impl MonitoringScheduleConfig {
    /// <p>Configures the monitoring schedule.</p>
    pub fn schedule_config(&self) -> std::option::Option<&crate::model::ScheduleConfig> {
        self.schedule_config.as_ref()
    }
    /// <p>Defines the monitoring job.</p>
    pub fn monitoring_job_definition(
        &self,
    ) -> std::option::Option<&crate::model::MonitoringJobDefinition> {
        self.monitoring_job_definition.as_ref()
    }
    /// <p>The name of the monitoring job definition to schedule.</p>
    pub fn monitoring_job_definition_name(&self) -> std::option::Option<&str> {
        self.monitoring_job_definition_name.as_deref()
    }
    /// <p>The type of the monitoring job definition to schedule.</p>
    pub fn monitoring_type(&self) -> std::option::Option<&crate::model::MonitoringType> {
        self.monitoring_type.as_ref()
    }
}
impl std::fmt::Debug for MonitoringScheduleConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MonitoringScheduleConfig");
        formatter.field("schedule_config", &self.schedule_config);
        formatter.field("monitoring_job_definition", &self.monitoring_job_definition);
        formatter.field(
            "monitoring_job_definition_name",
            &self.monitoring_job_definition_name,
        );
        formatter.field("monitoring_type", &self.monitoring_type);
        formatter.finish()
    }
}
/// See [`MonitoringScheduleConfig`](crate::model::MonitoringScheduleConfig)
pub mod monitoring_schedule_config {
    /// A builder for [`MonitoringScheduleConfig`](crate::model::MonitoringScheduleConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schedule_config: std::option::Option<crate::model::ScheduleConfig>,
        pub(crate) monitoring_job_definition:
            std::option::Option<crate::model::MonitoringJobDefinition>,
        pub(crate) monitoring_job_definition_name: std::option::Option<std::string::String>,
        pub(crate) monitoring_type: std::option::Option<crate::model::MonitoringType>,
    }
    impl Builder {
        /// <p>Configures the monitoring schedule.</p>
        pub fn schedule_config(mut self, input: crate::model::ScheduleConfig) -> Self {
            self.schedule_config = Some(input);
            self
        }
        /// <p>Configures the monitoring schedule.</p>
        pub fn set_schedule_config(
            mut self,
            input: std::option::Option<crate::model::ScheduleConfig>,
        ) -> Self {
            self.schedule_config = input;
            self
        }
        /// <p>Defines the monitoring job.</p>
        pub fn monitoring_job_definition(
            mut self,
            input: crate::model::MonitoringJobDefinition,
        ) -> Self {
            self.monitoring_job_definition = Some(input);
            self
        }
        /// <p>Defines the monitoring job.</p>
        pub fn set_monitoring_job_definition(
            mut self,
            input: std::option::Option<crate::model::MonitoringJobDefinition>,
        ) -> Self {
            self.monitoring_job_definition = input;
            self
        }
        /// <p>The name of the monitoring job definition to schedule.</p>
        pub fn monitoring_job_definition_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.monitoring_job_definition_name = Some(input.into());
            self
        }
        /// <p>The name of the monitoring job definition to schedule.</p>
        pub fn set_monitoring_job_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.monitoring_job_definition_name = input;
            self
        }
        /// <p>The type of the monitoring job definition to schedule.</p>
        pub fn monitoring_type(mut self, input: crate::model::MonitoringType) -> Self {
            self.monitoring_type = Some(input);
            self
        }
        /// <p>The type of the monitoring job definition to schedule.</p>
        pub fn set_monitoring_type(
            mut self,
            input: std::option::Option<crate::model::MonitoringType>,
        ) -> Self {
            self.monitoring_type = input;
            self
        }
        /// Consumes the builder and constructs a [`MonitoringScheduleConfig`](crate::model::MonitoringScheduleConfig)
        pub fn build(self) -> crate::model::MonitoringScheduleConfig {
            crate::model::MonitoringScheduleConfig {
                schedule_config: self.schedule_config,
                monitoring_job_definition: self.monitoring_job_definition,
                monitoring_job_definition_name: self.monitoring_job_definition_name,
                monitoring_type: self.monitoring_type,
            }
        }
    }
}
impl MonitoringScheduleConfig {
    /// Creates a new builder-style object to manufacture [`MonitoringScheduleConfig`](crate::model::MonitoringScheduleConfig)
    pub fn builder() -> crate::model::monitoring_schedule_config::Builder {
        crate::model::monitoring_schedule_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MonitoringType {
    #[allow(missing_docs)] // documentation missing in model
    DataQuality,
    #[allow(missing_docs)] // documentation missing in model
    ModelBias,
    #[allow(missing_docs)] // documentation missing in model
    ModelExplainability,
    #[allow(missing_docs)] // documentation missing in model
    ModelQuality,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MonitoringType {
    fn from(s: &str) -> Self {
        match s {
            "DataQuality" => MonitoringType::DataQuality,
            "ModelBias" => MonitoringType::ModelBias,
            "ModelExplainability" => MonitoringType::ModelExplainability,
            "ModelQuality" => MonitoringType::ModelQuality,
            other => MonitoringType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MonitoringType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MonitoringType::from(s))
    }
}
impl MonitoringType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MonitoringType::DataQuality => "DataQuality",
            MonitoringType::ModelBias => "ModelBias",
            MonitoringType::ModelExplainability => "ModelExplainability",
            MonitoringType::ModelQuality => "ModelQuality",
            MonitoringType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DataQuality",
            "ModelBias",
            "ModelExplainability",
            "ModelQuality",
        ]
    }
}
impl AsRef<str> for MonitoringType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Defines the monitoring job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MonitoringJobDefinition {
    /// <p>Baseline configuration used to validate that the data conforms to the specified
    /// constraints and statistics</p>
    pub baseline_config: std::option::Option<crate::model::MonitoringBaselineConfig>,
    /// <p>The array of inputs for the monitoring job. Currently we support monitoring an Amazon SageMaker
    /// Endpoint.</p>
    pub monitoring_inputs: std::option::Option<std::vec::Vec<crate::model::MonitoringInput>>,
    /// <p>The array of outputs from the monitoring job to be uploaded to Amazon Simple Storage
    /// Service (Amazon S3).</p>
    pub monitoring_output_config: std::option::Option<crate::model::MonitoringOutputConfig>,
    /// <p>Identifies the resources, ML compute instances, and ML storage volumes to deploy for a
    /// monitoring job. In distributed processing, you specify more than one instance.</p>
    pub monitoring_resources: std::option::Option<crate::model::MonitoringResources>,
    /// <p>Configures the monitoring job to run a specified Docker container image.</p>
    pub monitoring_app_specification: std::option::Option<crate::model::MonitoringAppSpecification>,
    /// <p>Specifies a time limit for how long the monitoring job is allowed to run.</p>
    pub stopping_condition: std::option::Option<crate::model::MonitoringStoppingCondition>,
    /// <p>Sets the environment variables in the Docker container.</p>
    pub environment:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Specifies networking options for an monitoring job.</p>
    pub network_config: std::option::Option<crate::model::NetworkConfig>,
    /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on
    /// your behalf.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl MonitoringJobDefinition {
    /// <p>Baseline configuration used to validate that the data conforms to the specified
    /// constraints and statistics</p>
    pub fn baseline_config(&self) -> std::option::Option<&crate::model::MonitoringBaselineConfig> {
        self.baseline_config.as_ref()
    }
    /// <p>The array of inputs for the monitoring job. Currently we support monitoring an Amazon SageMaker
    /// Endpoint.</p>
    pub fn monitoring_inputs(&self) -> std::option::Option<&[crate::model::MonitoringInput]> {
        self.monitoring_inputs.as_deref()
    }
    /// <p>The array of outputs from the monitoring job to be uploaded to Amazon Simple Storage
    /// Service (Amazon S3).</p>
    pub fn monitoring_output_config(
        &self,
    ) -> std::option::Option<&crate::model::MonitoringOutputConfig> {
        self.monitoring_output_config.as_ref()
    }
    /// <p>Identifies the resources, ML compute instances, and ML storage volumes to deploy for a
    /// monitoring job. In distributed processing, you specify more than one instance.</p>
    pub fn monitoring_resources(&self) -> std::option::Option<&crate::model::MonitoringResources> {
        self.monitoring_resources.as_ref()
    }
    /// <p>Configures the monitoring job to run a specified Docker container image.</p>
    pub fn monitoring_app_specification(
        &self,
    ) -> std::option::Option<&crate::model::MonitoringAppSpecification> {
        self.monitoring_app_specification.as_ref()
    }
    /// <p>Specifies a time limit for how long the monitoring job is allowed to run.</p>
    pub fn stopping_condition(
        &self,
    ) -> std::option::Option<&crate::model::MonitoringStoppingCondition> {
        self.stopping_condition.as_ref()
    }
    /// <p>Sets the environment variables in the Docker container.</p>
    pub fn environment(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.environment.as_ref()
    }
    /// <p>Specifies networking options for an monitoring job.</p>
    pub fn network_config(&self) -> std::option::Option<&crate::model::NetworkConfig> {
        self.network_config.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on
    /// your behalf.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for MonitoringJobDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MonitoringJobDefinition");
        formatter.field("baseline_config", &self.baseline_config);
        formatter.field("monitoring_inputs", &self.monitoring_inputs);
        formatter.field("monitoring_output_config", &self.monitoring_output_config);
        formatter.field("monitoring_resources", &self.monitoring_resources);
        formatter.field(
            "monitoring_app_specification",
            &self.monitoring_app_specification,
        );
        formatter.field("stopping_condition", &self.stopping_condition);
        formatter.field("environment", &self.environment);
        formatter.field("network_config", &self.network_config);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`MonitoringJobDefinition`](crate::model::MonitoringJobDefinition)
pub mod monitoring_job_definition {
    /// A builder for [`MonitoringJobDefinition`](crate::model::MonitoringJobDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) baseline_config: std::option::Option<crate::model::MonitoringBaselineConfig>,
        pub(crate) monitoring_inputs:
            std::option::Option<std::vec::Vec<crate::model::MonitoringInput>>,
        pub(crate) monitoring_output_config:
            std::option::Option<crate::model::MonitoringOutputConfig>,
        pub(crate) monitoring_resources: std::option::Option<crate::model::MonitoringResources>,
        pub(crate) monitoring_app_specification:
            std::option::Option<crate::model::MonitoringAppSpecification>,
        pub(crate) stopping_condition:
            std::option::Option<crate::model::MonitoringStoppingCondition>,
        pub(crate) environment: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) network_config: std::option::Option<crate::model::NetworkConfig>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Baseline configuration used to validate that the data conforms to the specified
        /// constraints and statistics</p>
        pub fn baseline_config(mut self, input: crate::model::MonitoringBaselineConfig) -> Self {
            self.baseline_config = Some(input);
            self
        }
        /// <p>Baseline configuration used to validate that the data conforms to the specified
        /// constraints and statistics</p>
        pub fn set_baseline_config(
            mut self,
            input: std::option::Option<crate::model::MonitoringBaselineConfig>,
        ) -> Self {
            self.baseline_config = input;
            self
        }
        /// Appends an item to `monitoring_inputs`.
        ///
        /// To override the contents of this collection use [`set_monitoring_inputs`](Self::set_monitoring_inputs).
        ///
        /// <p>The array of inputs for the monitoring job. Currently we support monitoring an Amazon SageMaker
        /// Endpoint.</p>
        pub fn monitoring_inputs(
            mut self,
            input: impl Into<crate::model::MonitoringInput>,
        ) -> Self {
            let mut v = self.monitoring_inputs.unwrap_or_default();
            v.push(input.into());
            self.monitoring_inputs = Some(v);
            self
        }
        /// <p>The array of inputs for the monitoring job. Currently we support monitoring an Amazon SageMaker
        /// Endpoint.</p>
        pub fn set_monitoring_inputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MonitoringInput>>,
        ) -> Self {
            self.monitoring_inputs = input;
            self
        }
        /// <p>The array of outputs from the monitoring job to be uploaded to Amazon Simple Storage
        /// Service (Amazon S3).</p>
        pub fn monitoring_output_config(
            mut self,
            input: crate::model::MonitoringOutputConfig,
        ) -> Self {
            self.monitoring_output_config = Some(input);
            self
        }
        /// <p>The array of outputs from the monitoring job to be uploaded to Amazon Simple Storage
        /// Service (Amazon S3).</p>
        pub fn set_monitoring_output_config(
            mut self,
            input: std::option::Option<crate::model::MonitoringOutputConfig>,
        ) -> Self {
            self.monitoring_output_config = input;
            self
        }
        /// <p>Identifies the resources, ML compute instances, and ML storage volumes to deploy for a
        /// monitoring job. In distributed processing, you specify more than one instance.</p>
        pub fn monitoring_resources(mut self, input: crate::model::MonitoringResources) -> Self {
            self.monitoring_resources = Some(input);
            self
        }
        /// <p>Identifies the resources, ML compute instances, and ML storage volumes to deploy for a
        /// monitoring job. In distributed processing, you specify more than one instance.</p>
        pub fn set_monitoring_resources(
            mut self,
            input: std::option::Option<crate::model::MonitoringResources>,
        ) -> Self {
            self.monitoring_resources = input;
            self
        }
        /// <p>Configures the monitoring job to run a specified Docker container image.</p>
        pub fn monitoring_app_specification(
            mut self,
            input: crate::model::MonitoringAppSpecification,
        ) -> Self {
            self.monitoring_app_specification = Some(input);
            self
        }
        /// <p>Configures the monitoring job to run a specified Docker container image.</p>
        pub fn set_monitoring_app_specification(
            mut self,
            input: std::option::Option<crate::model::MonitoringAppSpecification>,
        ) -> Self {
            self.monitoring_app_specification = input;
            self
        }
        /// <p>Specifies a time limit for how long the monitoring job is allowed to run.</p>
        pub fn stopping_condition(
            mut self,
            input: crate::model::MonitoringStoppingCondition,
        ) -> Self {
            self.stopping_condition = Some(input);
            self
        }
        /// <p>Specifies a time limit for how long the monitoring job is allowed to run.</p>
        pub fn set_stopping_condition(
            mut self,
            input: std::option::Option<crate::model::MonitoringStoppingCondition>,
        ) -> Self {
            self.stopping_condition = input;
            self
        }
        /// Adds a key-value pair to `environment`.
        ///
        /// To override the contents of this collection use [`set_environment`](Self::set_environment).
        ///
        /// <p>Sets the environment variables in the Docker container.</p>
        pub fn environment(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.environment.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.environment = Some(hash_map);
            self
        }
        /// <p>Sets the environment variables in the Docker container.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.environment = input;
            self
        }
        /// <p>Specifies networking options for an monitoring job.</p>
        pub fn network_config(mut self, input: crate::model::NetworkConfig) -> Self {
            self.network_config = Some(input);
            self
        }
        /// <p>Specifies networking options for an monitoring job.</p>
        pub fn set_network_config(
            mut self,
            input: std::option::Option<crate::model::NetworkConfig>,
        ) -> Self {
            self.network_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on
        /// your behalf.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on
        /// your behalf.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`MonitoringJobDefinition`](crate::model::MonitoringJobDefinition)
        pub fn build(self) -> crate::model::MonitoringJobDefinition {
            crate::model::MonitoringJobDefinition {
                baseline_config: self.baseline_config,
                monitoring_inputs: self.monitoring_inputs,
                monitoring_output_config: self.monitoring_output_config,
                monitoring_resources: self.monitoring_resources,
                monitoring_app_specification: self.monitoring_app_specification,
                stopping_condition: self.stopping_condition,
                environment: self.environment,
                network_config: self.network_config,
                role_arn: self.role_arn,
            }
        }
    }
}
impl MonitoringJobDefinition {
    /// Creates a new builder-style object to manufacture [`MonitoringJobDefinition`](crate::model::MonitoringJobDefinition)
    pub fn builder() -> crate::model::monitoring_job_definition::Builder {
        crate::model::monitoring_job_definition::Builder::default()
    }
}

/// <p>Networking options for a job, such as network traffic encryption between containers,
/// whether to allow inbound and outbound network calls to and from containers, and the VPC
/// subnets and security groups to use for VPC-enabled jobs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkConfig {
    /// <p>Whether to encrypt all communications between distributed processing jobs. Choose
    /// <code>True</code> to encrypt communications. Encryption provides greater security for distributed
    /// processing jobs, but the processing might take longer.</p>
    pub enable_inter_container_traffic_encryption: bool,
    /// <p>Whether to allow inbound and outbound network calls to and from the containers used for
    /// the processing job.</p>
    pub enable_network_isolation: bool,
    /// <p>Specifies a VPC that your training jobs and hosted models have access to. Control
    /// access to and from your training and model containers by configuring the VPC. For more
    /// information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html">Protect Endpoints by Using an Amazon Virtual Private Cloud</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs
    /// by Using an Amazon Virtual Private Cloud</a>. </p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
}
impl NetworkConfig {
    /// <p>Whether to encrypt all communications between distributed processing jobs. Choose
    /// <code>True</code> to encrypt communications. Encryption provides greater security for distributed
    /// processing jobs, but the processing might take longer.</p>
    pub fn enable_inter_container_traffic_encryption(&self) -> bool {
        self.enable_inter_container_traffic_encryption
    }
    /// <p>Whether to allow inbound and outbound network calls to and from the containers used for
    /// the processing job.</p>
    pub fn enable_network_isolation(&self) -> bool {
        self.enable_network_isolation
    }
    /// <p>Specifies a VPC that your training jobs and hosted models have access to. Control
    /// access to and from your training and model containers by configuring the VPC. For more
    /// information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html">Protect Endpoints by Using an Amazon Virtual Private Cloud</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs
    /// by Using an Amazon Virtual Private Cloud</a>. </p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfig> {
        self.vpc_config.as_ref()
    }
}
impl std::fmt::Debug for NetworkConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkConfig");
        formatter.field(
            "enable_inter_container_traffic_encryption",
            &self.enable_inter_container_traffic_encryption,
        );
        formatter.field("enable_network_isolation", &self.enable_network_isolation);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.finish()
    }
}
/// See [`NetworkConfig`](crate::model::NetworkConfig)
pub mod network_config {
    /// A builder for [`NetworkConfig`](crate::model::NetworkConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enable_inter_container_traffic_encryption: std::option::Option<bool>,
        pub(crate) enable_network_isolation: std::option::Option<bool>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
    }
    impl Builder {
        /// <p>Whether to encrypt all communications between distributed processing jobs. Choose
        /// <code>True</code> to encrypt communications. Encryption provides greater security for distributed
        /// processing jobs, but the processing might take longer.</p>
        pub fn enable_inter_container_traffic_encryption(mut self, input: bool) -> Self {
            self.enable_inter_container_traffic_encryption = Some(input);
            self
        }
        /// <p>Whether to encrypt all communications between distributed processing jobs. Choose
        /// <code>True</code> to encrypt communications. Encryption provides greater security for distributed
        /// processing jobs, but the processing might take longer.</p>
        pub fn set_enable_inter_container_traffic_encryption(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_inter_container_traffic_encryption = input;
            self
        }
        /// <p>Whether to allow inbound and outbound network calls to and from the containers used for
        /// the processing job.</p>
        pub fn enable_network_isolation(mut self, input: bool) -> Self {
            self.enable_network_isolation = Some(input);
            self
        }
        /// <p>Whether to allow inbound and outbound network calls to and from the containers used for
        /// the processing job.</p>
        pub fn set_enable_network_isolation(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_network_isolation = input;
            self
        }
        /// <p>Specifies a VPC that your training jobs and hosted models have access to. Control
        /// access to and from your training and model containers by configuring the VPC. For more
        /// information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html">Protect Endpoints by Using an Amazon Virtual Private Cloud</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs
        /// by Using an Amazon Virtual Private Cloud</a>. </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>Specifies a VPC that your training jobs and hosted models have access to. Control
        /// access to and from your training and model containers by configuring the VPC. For more
        /// information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html">Protect Endpoints by Using an Amazon Virtual Private Cloud</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs
        /// by Using an Amazon Virtual Private Cloud</a>. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkConfig`](crate::model::NetworkConfig)
        pub fn build(self) -> crate::model::NetworkConfig {
            crate::model::NetworkConfig {
                enable_inter_container_traffic_encryption: self
                    .enable_inter_container_traffic_encryption
                    .unwrap_or_default(),
                enable_network_isolation: self.enable_network_isolation.unwrap_or_default(),
                vpc_config: self.vpc_config,
            }
        }
    }
}
impl NetworkConfig {
    /// Creates a new builder-style object to manufacture [`NetworkConfig`](crate::model::NetworkConfig)
    pub fn builder() -> crate::model::network_config::Builder {
        crate::model::network_config::Builder::default()
    }
}

/// <p>Specifies a VPC that your training jobs and hosted models have access to. Control
/// access to and from your training and model containers by configuring the VPC. For more
/// information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html">Protect Endpoints by Using an Amazon Virtual Private Cloud</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs
/// by Using an Amazon Virtual Private Cloud</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcConfig {
    /// <p>The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for
    /// the VPC that is specified in the <code>Subnets</code> field.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ID of the subnets in the VPC to which you want to connect your training job or
    /// model. For information about the availability of specific instance types, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html">Supported
    /// Instance Types and Availability Zones</a>.</p>
    pub subnets: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl VpcConfig {
    /// <p>The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for
    /// the VPC that is specified in the <code>Subnets</code> field.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
    /// <p>The ID of the subnets in the VPC to which you want to connect your training job or
    /// model. For information about the availability of specific instance types, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html">Supported
    /// Instance Types and Availability Zones</a>.</p>
    pub fn subnets(&self) -> std::option::Option<&[std::string::String]> {
        self.subnets.as_deref()
    }
}
impl std::fmt::Debug for VpcConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcConfig");
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("subnets", &self.subnets);
        formatter.finish()
    }
}
/// See [`VpcConfig`](crate::model::VpcConfig)
pub mod vpc_config {
    /// A builder for [`VpcConfig`](crate::model::VpcConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnets: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for
        /// the VPC that is specified in the <code>Subnets</code> field.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for
        /// the VPC that is specified in the <code>Subnets</code> field.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Appends an item to `subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>The ID of the subnets in the VPC to which you want to connect your training job or
        /// model. For information about the availability of specific instance types, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html">Supported
        /// Instance Types and Availability Zones</a>.</p>
        pub fn subnets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnets.unwrap_or_default();
            v.push(input.into());
            self.subnets = Some(v);
            self
        }
        /// <p>The ID of the subnets in the VPC to which you want to connect your training job or
        /// model. For information about the availability of specific instance types, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html">Supported
        /// Instance Types and Availability Zones</a>.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnets = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcConfig`](crate::model::VpcConfig)
        pub fn build(self) -> crate::model::VpcConfig {
            crate::model::VpcConfig {
                security_group_ids: self.security_group_ids,
                subnets: self.subnets,
            }
        }
    }
}
impl VpcConfig {
    /// Creates a new builder-style object to manufacture [`VpcConfig`](crate::model::VpcConfig)
    pub fn builder() -> crate::model::vpc_config::Builder {
        crate::model::vpc_config::Builder::default()
    }
}

/// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MonitoringStoppingCondition {
    /// <p>The maximum runtime allowed in seconds.</p>
    /// <note>
    /// <p>The <code>MaxRuntimeInSeconds</code> cannot exceed the frequency of the job. For data quality and
    /// model explainability, this can be up to 3600 seconds for an hourly schedule. For model
    /// bias and model quality hourly schedules, this can be up to 1800 seconds.</p>
    /// </note>
    pub max_runtime_in_seconds: i32,
}
impl MonitoringStoppingCondition {
    /// <p>The maximum runtime allowed in seconds.</p>
    /// <note>
    /// <p>The <code>MaxRuntimeInSeconds</code> cannot exceed the frequency of the job. For data quality and
    /// model explainability, this can be up to 3600 seconds for an hourly schedule. For model
    /// bias and model quality hourly schedules, this can be up to 1800 seconds.</p>
    /// </note>
    pub fn max_runtime_in_seconds(&self) -> i32 {
        self.max_runtime_in_seconds
    }
}
impl std::fmt::Debug for MonitoringStoppingCondition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MonitoringStoppingCondition");
        formatter.field("max_runtime_in_seconds", &self.max_runtime_in_seconds);
        formatter.finish()
    }
}
/// See [`MonitoringStoppingCondition`](crate::model::MonitoringStoppingCondition)
pub mod monitoring_stopping_condition {
    /// A builder for [`MonitoringStoppingCondition`](crate::model::MonitoringStoppingCondition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_runtime_in_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The maximum runtime allowed in seconds.</p>
        /// <note>
        /// <p>The <code>MaxRuntimeInSeconds</code> cannot exceed the frequency of the job. For data quality and
        /// model explainability, this can be up to 3600 seconds for an hourly schedule. For model
        /// bias and model quality hourly schedules, this can be up to 1800 seconds.</p>
        /// </note>
        pub fn max_runtime_in_seconds(mut self, input: i32) -> Self {
            self.max_runtime_in_seconds = Some(input);
            self
        }
        /// <p>The maximum runtime allowed in seconds.</p>
        /// <note>
        /// <p>The <code>MaxRuntimeInSeconds</code> cannot exceed the frequency of the job. For data quality and
        /// model explainability, this can be up to 3600 seconds for an hourly schedule. For model
        /// bias and model quality hourly schedules, this can be up to 1800 seconds.</p>
        /// </note>
        pub fn set_max_runtime_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.max_runtime_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`MonitoringStoppingCondition`](crate::model::MonitoringStoppingCondition)
        pub fn build(self) -> crate::model::MonitoringStoppingCondition {
            crate::model::MonitoringStoppingCondition {
                max_runtime_in_seconds: self.max_runtime_in_seconds.unwrap_or_default(),
            }
        }
    }
}
impl MonitoringStoppingCondition {
    /// Creates a new builder-style object to manufacture [`MonitoringStoppingCondition`](crate::model::MonitoringStoppingCondition)
    pub fn builder() -> crate::model::monitoring_stopping_condition::Builder {
        crate::model::monitoring_stopping_condition::Builder::default()
    }
}

/// <p>Container image configuration object for the monitoring job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MonitoringAppSpecification {
    /// <p>The container image to be run by the monitoring job.</p>
    pub image_uri: std::option::Option<std::string::String>,
    /// <p>Specifies the entrypoint for a container used to run the monitoring job.</p>
    pub container_entrypoint: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of arguments for the container used to run the monitoring job.</p>
    pub container_arguments: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An Amazon S3 URI to a script that is called per row prior to running analysis. It can
    /// base64 decode the payload and convert it into a flatted json so that the built-in container
    /// can use the converted data. Applicable only for the built-in (first party)
    /// containers.</p>
    pub record_preprocessor_source_uri: std::option::Option<std::string::String>,
    /// <p>An Amazon S3 URI to a script that is called after analysis has been performed.
    /// Applicable only for the built-in (first party) containers.</p>
    pub post_analytics_processor_source_uri: std::option::Option<std::string::String>,
}
impl MonitoringAppSpecification {
    /// <p>The container image to be run by the monitoring job.</p>
    pub fn image_uri(&self) -> std::option::Option<&str> {
        self.image_uri.as_deref()
    }
    /// <p>Specifies the entrypoint for a container used to run the monitoring job.</p>
    pub fn container_entrypoint(&self) -> std::option::Option<&[std::string::String]> {
        self.container_entrypoint.as_deref()
    }
    /// <p>An array of arguments for the container used to run the monitoring job.</p>
    pub fn container_arguments(&self) -> std::option::Option<&[std::string::String]> {
        self.container_arguments.as_deref()
    }
    /// <p>An Amazon S3 URI to a script that is called per row prior to running analysis. It can
    /// base64 decode the payload and convert it into a flatted json so that the built-in container
    /// can use the converted data. Applicable only for the built-in (first party)
    /// containers.</p>
    pub fn record_preprocessor_source_uri(&self) -> std::option::Option<&str> {
        self.record_preprocessor_source_uri.as_deref()
    }
    /// <p>An Amazon S3 URI to a script that is called after analysis has been performed.
    /// Applicable only for the built-in (first party) containers.</p>
    pub fn post_analytics_processor_source_uri(&self) -> std::option::Option<&str> {
        self.post_analytics_processor_source_uri.as_deref()
    }
}
impl std::fmt::Debug for MonitoringAppSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MonitoringAppSpecification");
        formatter.field("image_uri", &self.image_uri);
        formatter.field("container_entrypoint", &self.container_entrypoint);
        formatter.field("container_arguments", &self.container_arguments);
        formatter.field(
            "record_preprocessor_source_uri",
            &self.record_preprocessor_source_uri,
        );
        formatter.field(
            "post_analytics_processor_source_uri",
            &self.post_analytics_processor_source_uri,
        );
        formatter.finish()
    }
}
/// See [`MonitoringAppSpecification`](crate::model::MonitoringAppSpecification)
pub mod monitoring_app_specification {
    /// A builder for [`MonitoringAppSpecification`](crate::model::MonitoringAppSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_uri: std::option::Option<std::string::String>,
        pub(crate) container_entrypoint: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) container_arguments: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) record_preprocessor_source_uri: std::option::Option<std::string::String>,
        pub(crate) post_analytics_processor_source_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The container image to be run by the monitoring job.</p>
        pub fn image_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_uri = Some(input.into());
            self
        }
        /// <p>The container image to be run by the monitoring job.</p>
        pub fn set_image_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_uri = input;
            self
        }
        /// Appends an item to `container_entrypoint`.
        ///
        /// To override the contents of this collection use [`set_container_entrypoint`](Self::set_container_entrypoint).
        ///
        /// <p>Specifies the entrypoint for a container used to run the monitoring job.</p>
        pub fn container_entrypoint(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.container_entrypoint.unwrap_or_default();
            v.push(input.into());
            self.container_entrypoint = Some(v);
            self
        }
        /// <p>Specifies the entrypoint for a container used to run the monitoring job.</p>
        pub fn set_container_entrypoint(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.container_entrypoint = input;
            self
        }
        /// Appends an item to `container_arguments`.
        ///
        /// To override the contents of this collection use [`set_container_arguments`](Self::set_container_arguments).
        ///
        /// <p>An array of arguments for the container used to run the monitoring job.</p>
        pub fn container_arguments(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.container_arguments.unwrap_or_default();
            v.push(input.into());
            self.container_arguments = Some(v);
            self
        }
        /// <p>An array of arguments for the container used to run the monitoring job.</p>
        pub fn set_container_arguments(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.container_arguments = input;
            self
        }
        /// <p>An Amazon S3 URI to a script that is called per row prior to running analysis. It can
        /// base64 decode the payload and convert it into a flatted json so that the built-in container
        /// can use the converted data. Applicable only for the built-in (first party)
        /// containers.</p>
        pub fn record_preprocessor_source_uri(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.record_preprocessor_source_uri = Some(input.into());
            self
        }
        /// <p>An Amazon S3 URI to a script that is called per row prior to running analysis. It can
        /// base64 decode the payload and convert it into a flatted json so that the built-in container
        /// can use the converted data. Applicable only for the built-in (first party)
        /// containers.</p>
        pub fn set_record_preprocessor_source_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.record_preprocessor_source_uri = input;
            self
        }
        /// <p>An Amazon S3 URI to a script that is called after analysis has been performed.
        /// Applicable only for the built-in (first party) containers.</p>
        pub fn post_analytics_processor_source_uri(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.post_analytics_processor_source_uri = Some(input.into());
            self
        }
        /// <p>An Amazon S3 URI to a script that is called after analysis has been performed.
        /// Applicable only for the built-in (first party) containers.</p>
        pub fn set_post_analytics_processor_source_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.post_analytics_processor_source_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`MonitoringAppSpecification`](crate::model::MonitoringAppSpecification)
        pub fn build(self) -> crate::model::MonitoringAppSpecification {
            crate::model::MonitoringAppSpecification {
                image_uri: self.image_uri,
                container_entrypoint: self.container_entrypoint,
                container_arguments: self.container_arguments,
                record_preprocessor_source_uri: self.record_preprocessor_source_uri,
                post_analytics_processor_source_uri: self.post_analytics_processor_source_uri,
            }
        }
    }
}
impl MonitoringAppSpecification {
    /// Creates a new builder-style object to manufacture [`MonitoringAppSpecification`](crate::model::MonitoringAppSpecification)
    pub fn builder() -> crate::model::monitoring_app_specification::Builder {
        crate::model::monitoring_app_specification::Builder::default()
    }
}

/// <p>Identifies the resources to deploy for a monitoring job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MonitoringResources {
    /// <p>The configuration for the cluster resources used to run the processing job.</p>
    pub cluster_config: std::option::Option<crate::model::MonitoringClusterConfig>,
}
impl MonitoringResources {
    /// <p>The configuration for the cluster resources used to run the processing job.</p>
    pub fn cluster_config(&self) -> std::option::Option<&crate::model::MonitoringClusterConfig> {
        self.cluster_config.as_ref()
    }
}
impl std::fmt::Debug for MonitoringResources {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MonitoringResources");
        formatter.field("cluster_config", &self.cluster_config);
        formatter.finish()
    }
}
/// See [`MonitoringResources`](crate::model::MonitoringResources)
pub mod monitoring_resources {
    /// A builder for [`MonitoringResources`](crate::model::MonitoringResources)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_config: std::option::Option<crate::model::MonitoringClusterConfig>,
    }
    impl Builder {
        /// <p>The configuration for the cluster resources used to run the processing job.</p>
        pub fn cluster_config(mut self, input: crate::model::MonitoringClusterConfig) -> Self {
            self.cluster_config = Some(input);
            self
        }
        /// <p>The configuration for the cluster resources used to run the processing job.</p>
        pub fn set_cluster_config(
            mut self,
            input: std::option::Option<crate::model::MonitoringClusterConfig>,
        ) -> Self {
            self.cluster_config = input;
            self
        }
        /// Consumes the builder and constructs a [`MonitoringResources`](crate::model::MonitoringResources)
        pub fn build(self) -> crate::model::MonitoringResources {
            crate::model::MonitoringResources {
                cluster_config: self.cluster_config,
            }
        }
    }
}
impl MonitoringResources {
    /// Creates a new builder-style object to manufacture [`MonitoringResources`](crate::model::MonitoringResources)
    pub fn builder() -> crate::model::monitoring_resources::Builder {
        crate::model::monitoring_resources::Builder::default()
    }
}

/// <p>Configuration for the cluster used to run model monitoring jobs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MonitoringClusterConfig {
    /// <p>The number of ML compute instances to use in the model monitoring job. For distributed
    /// processing jobs, specify a value greater than 1. The default value is 1.</p>
    pub instance_count: std::option::Option<i32>,
    /// <p>The ML compute instance type for the processing job.</p>
    pub instance_type: std::option::Option<crate::model::ProcessingInstanceType>,
    /// <p>The size of the ML storage volume, in gigabytes, that you want to provision. You must
    /// specify sufficient ML storage for your scenario.</p>
    pub volume_size_in_gb: std::option::Option<i32>,
    /// <p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data
    /// on the storage volume attached to the ML compute instance(s) that run the model monitoring
    /// job.</p>
    pub volume_kms_key_id: std::option::Option<std::string::String>,
}
impl MonitoringClusterConfig {
    /// <p>The number of ML compute instances to use in the model monitoring job. For distributed
    /// processing jobs, specify a value greater than 1. The default value is 1.</p>
    pub fn instance_count(&self) -> std::option::Option<i32> {
        self.instance_count
    }
    /// <p>The ML compute instance type for the processing job.</p>
    pub fn instance_type(&self) -> std::option::Option<&crate::model::ProcessingInstanceType> {
        self.instance_type.as_ref()
    }
    /// <p>The size of the ML storage volume, in gigabytes, that you want to provision. You must
    /// specify sufficient ML storage for your scenario.</p>
    pub fn volume_size_in_gb(&self) -> std::option::Option<i32> {
        self.volume_size_in_gb
    }
    /// <p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data
    /// on the storage volume attached to the ML compute instance(s) that run the model monitoring
    /// job.</p>
    pub fn volume_kms_key_id(&self) -> std::option::Option<&str> {
        self.volume_kms_key_id.as_deref()
    }
}
impl std::fmt::Debug for MonitoringClusterConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MonitoringClusterConfig");
        formatter.field("instance_count", &self.instance_count);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("volume_size_in_gb", &self.volume_size_in_gb);
        formatter.field("volume_kms_key_id", &self.volume_kms_key_id);
        formatter.finish()
    }
}
/// See [`MonitoringClusterConfig`](crate::model::MonitoringClusterConfig)
pub mod monitoring_cluster_config {
    /// A builder for [`MonitoringClusterConfig`](crate::model::MonitoringClusterConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_count: std::option::Option<i32>,
        pub(crate) instance_type: std::option::Option<crate::model::ProcessingInstanceType>,
        pub(crate) volume_size_in_gb: std::option::Option<i32>,
        pub(crate) volume_kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of ML compute instances to use in the model monitoring job. For distributed
        /// processing jobs, specify a value greater than 1. The default value is 1.</p>
        pub fn instance_count(mut self, input: i32) -> Self {
            self.instance_count = Some(input);
            self
        }
        /// <p>The number of ML compute instances to use in the model monitoring job. For distributed
        /// processing jobs, specify a value greater than 1. The default value is 1.</p>
        pub fn set_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.instance_count = input;
            self
        }
        /// <p>The ML compute instance type for the processing job.</p>
        pub fn instance_type(mut self, input: crate::model::ProcessingInstanceType) -> Self {
            self.instance_type = Some(input);
            self
        }
        /// <p>The ML compute instance type for the processing job.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<crate::model::ProcessingInstanceType>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The size of the ML storage volume, in gigabytes, that you want to provision. You must
        /// specify sufficient ML storage for your scenario.</p>
        pub fn volume_size_in_gb(mut self, input: i32) -> Self {
            self.volume_size_in_gb = Some(input);
            self
        }
        /// <p>The size of the ML storage volume, in gigabytes, that you want to provision. You must
        /// specify sufficient ML storage for your scenario.</p>
        pub fn set_volume_size_in_gb(mut self, input: std::option::Option<i32>) -> Self {
            self.volume_size_in_gb = input;
            self
        }
        /// <p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data
        /// on the storage volume attached to the ML compute instance(s) that run the model monitoring
        /// job.</p>
        pub fn volume_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data
        /// on the storage volume attached to the ML compute instance(s) that run the model monitoring
        /// job.</p>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.volume_kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`MonitoringClusterConfig`](crate::model::MonitoringClusterConfig)
        pub fn build(self) -> crate::model::MonitoringClusterConfig {
            crate::model::MonitoringClusterConfig {
                instance_count: self.instance_count,
                instance_type: self.instance_type,
                volume_size_in_gb: self.volume_size_in_gb,
                volume_kms_key_id: self.volume_kms_key_id,
            }
        }
    }
}
impl MonitoringClusterConfig {
    /// Creates a new builder-style object to manufacture [`MonitoringClusterConfig`](crate::model::MonitoringClusterConfig)
    pub fn builder() -> crate::model::monitoring_cluster_config::Builder {
        crate::model::monitoring_cluster_config::Builder::default()
    }
}

/// <p>The output configuration for monitoring jobs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MonitoringOutputConfig {
    /// <p>Monitoring outputs for monitoring jobs. This is where the output of the periodic
    /// monitoring jobs is uploaded.</p>
    pub monitoring_outputs: std::option::Option<std::vec::Vec<crate::model::MonitoringOutput>>,
    /// <p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt the model
    /// artifacts at rest using Amazon S3 server-side encryption.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
}
impl MonitoringOutputConfig {
    /// <p>Monitoring outputs for monitoring jobs. This is where the output of the periodic
    /// monitoring jobs is uploaded.</p>
    pub fn monitoring_outputs(&self) -> std::option::Option<&[crate::model::MonitoringOutput]> {
        self.monitoring_outputs.as_deref()
    }
    /// <p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt the model
    /// artifacts at rest using Amazon S3 server-side encryption.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
}
impl std::fmt::Debug for MonitoringOutputConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MonitoringOutputConfig");
        formatter.field("monitoring_outputs", &self.monitoring_outputs);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.finish()
    }
}
/// See [`MonitoringOutputConfig`](crate::model::MonitoringOutputConfig)
pub mod monitoring_output_config {
    /// A builder for [`MonitoringOutputConfig`](crate::model::MonitoringOutputConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) monitoring_outputs:
            std::option::Option<std::vec::Vec<crate::model::MonitoringOutput>>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `monitoring_outputs`.
        ///
        /// To override the contents of this collection use [`set_monitoring_outputs`](Self::set_monitoring_outputs).
        ///
        /// <p>Monitoring outputs for monitoring jobs. This is where the output of the periodic
        /// monitoring jobs is uploaded.</p>
        pub fn monitoring_outputs(
            mut self,
            input: impl Into<crate::model::MonitoringOutput>,
        ) -> Self {
            let mut v = self.monitoring_outputs.unwrap_or_default();
            v.push(input.into());
            self.monitoring_outputs = Some(v);
            self
        }
        /// <p>Monitoring outputs for monitoring jobs. This is where the output of the periodic
        /// monitoring jobs is uploaded.</p>
        pub fn set_monitoring_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MonitoringOutput>>,
        ) -> Self {
            self.monitoring_outputs = input;
            self
        }
        /// <p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt the model
        /// artifacts at rest using Amazon S3 server-side encryption.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt the model
        /// artifacts at rest using Amazon S3 server-side encryption.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`MonitoringOutputConfig`](crate::model::MonitoringOutputConfig)
        pub fn build(self) -> crate::model::MonitoringOutputConfig {
            crate::model::MonitoringOutputConfig {
                monitoring_outputs: self.monitoring_outputs,
                kms_key_id: self.kms_key_id,
            }
        }
    }
}
impl MonitoringOutputConfig {
    /// Creates a new builder-style object to manufacture [`MonitoringOutputConfig`](crate::model::MonitoringOutputConfig)
    pub fn builder() -> crate::model::monitoring_output_config::Builder {
        crate::model::monitoring_output_config::Builder::default()
    }
}

/// <p>The output object for a monitoring job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MonitoringOutput {
    /// <p>The Amazon S3 storage location where the results of a monitoring job are saved.</p>
    pub s3_output: std::option::Option<crate::model::MonitoringS3Output>,
}
impl MonitoringOutput {
    /// <p>The Amazon S3 storage location where the results of a monitoring job are saved.</p>
    pub fn s3_output(&self) -> std::option::Option<&crate::model::MonitoringS3Output> {
        self.s3_output.as_ref()
    }
}
impl std::fmt::Debug for MonitoringOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MonitoringOutput");
        formatter.field("s3_output", &self.s3_output);
        formatter.finish()
    }
}
/// See [`MonitoringOutput`](crate::model::MonitoringOutput)
pub mod monitoring_output {
    /// A builder for [`MonitoringOutput`](crate::model::MonitoringOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_output: std::option::Option<crate::model::MonitoringS3Output>,
    }
    impl Builder {
        /// <p>The Amazon S3 storage location where the results of a monitoring job are saved.</p>
        pub fn s3_output(mut self, input: crate::model::MonitoringS3Output) -> Self {
            self.s3_output = Some(input);
            self
        }
        /// <p>The Amazon S3 storage location where the results of a monitoring job are saved.</p>
        pub fn set_s3_output(
            mut self,
            input: std::option::Option<crate::model::MonitoringS3Output>,
        ) -> Self {
            self.s3_output = input;
            self
        }
        /// Consumes the builder and constructs a [`MonitoringOutput`](crate::model::MonitoringOutput)
        pub fn build(self) -> crate::model::MonitoringOutput {
            crate::model::MonitoringOutput {
                s3_output: self.s3_output,
            }
        }
    }
}
impl MonitoringOutput {
    /// Creates a new builder-style object to manufacture [`MonitoringOutput`](crate::model::MonitoringOutput)
    pub fn builder() -> crate::model::monitoring_output::Builder {
        crate::model::monitoring_output::Builder::default()
    }
}

/// <p>Information about where and how you want to store the results of a monitoring
/// job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MonitoringS3Output {
    /// <p>A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a
    /// monitoring job.</p>
    pub s3_uri: std::option::Option<std::string::String>,
    /// <p>The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a
    /// monitoring job. LocalPath is an absolute path for the output data.</p>
    pub local_path: std::option::Option<std::string::String>,
    /// <p>Whether to upload the results of the monitoring job continuously or after the job
    /// completes.</p>
    pub s3_upload_mode: std::option::Option<crate::model::ProcessingS3UploadMode>,
}
impl MonitoringS3Output {
    /// <p>A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a
    /// monitoring job.</p>
    pub fn s3_uri(&self) -> std::option::Option<&str> {
        self.s3_uri.as_deref()
    }
    /// <p>The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a
    /// monitoring job. LocalPath is an absolute path for the output data.</p>
    pub fn local_path(&self) -> std::option::Option<&str> {
        self.local_path.as_deref()
    }
    /// <p>Whether to upload the results of the monitoring job continuously or after the job
    /// completes.</p>
    pub fn s3_upload_mode(&self) -> std::option::Option<&crate::model::ProcessingS3UploadMode> {
        self.s3_upload_mode.as_ref()
    }
}
impl std::fmt::Debug for MonitoringS3Output {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MonitoringS3Output");
        formatter.field("s3_uri", &self.s3_uri);
        formatter.field("local_path", &self.local_path);
        formatter.field("s3_upload_mode", &self.s3_upload_mode);
        formatter.finish()
    }
}
/// See [`MonitoringS3Output`](crate::model::MonitoringS3Output)
pub mod monitoring_s3_output {
    /// A builder for [`MonitoringS3Output`](crate::model::MonitoringS3Output)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_uri: std::option::Option<std::string::String>,
        pub(crate) local_path: std::option::Option<std::string::String>,
        pub(crate) s3_upload_mode: std::option::Option<crate::model::ProcessingS3UploadMode>,
    }
    impl Builder {
        /// <p>A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a
        /// monitoring job.</p>
        pub fn s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_uri = Some(input.into());
            self
        }
        /// <p>A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a
        /// monitoring job.</p>
        pub fn set_s3_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_uri = input;
            self
        }
        /// <p>The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a
        /// monitoring job. LocalPath is an absolute path for the output data.</p>
        pub fn local_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.local_path = Some(input.into());
            self
        }
        /// <p>The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a
        /// monitoring job. LocalPath is an absolute path for the output data.</p>
        pub fn set_local_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.local_path = input;
            self
        }
        /// <p>Whether to upload the results of the monitoring job continuously or after the job
        /// completes.</p>
        pub fn s3_upload_mode(mut self, input: crate::model::ProcessingS3UploadMode) -> Self {
            self.s3_upload_mode = Some(input);
            self
        }
        /// <p>Whether to upload the results of the monitoring job continuously or after the job
        /// completes.</p>
        pub fn set_s3_upload_mode(
            mut self,
            input: std::option::Option<crate::model::ProcessingS3UploadMode>,
        ) -> Self {
            self.s3_upload_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`MonitoringS3Output`](crate::model::MonitoringS3Output)
        pub fn build(self) -> crate::model::MonitoringS3Output {
            crate::model::MonitoringS3Output {
                s3_uri: self.s3_uri,
                local_path: self.local_path,
                s3_upload_mode: self.s3_upload_mode,
            }
        }
    }
}
impl MonitoringS3Output {
    /// Creates a new builder-style object to manufacture [`MonitoringS3Output`](crate::model::MonitoringS3Output)
    pub fn builder() -> crate::model::monitoring_s3_output::Builder {
        crate::model::monitoring_s3_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProcessingS3UploadMode {
    #[allow(missing_docs)] // documentation missing in model
    Continuous,
    #[allow(missing_docs)] // documentation missing in model
    EndOfJob,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProcessingS3UploadMode {
    fn from(s: &str) -> Self {
        match s {
            "Continuous" => ProcessingS3UploadMode::Continuous,
            "EndOfJob" => ProcessingS3UploadMode::EndOfJob,
            other => ProcessingS3UploadMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProcessingS3UploadMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProcessingS3UploadMode::from(s))
    }
}
impl ProcessingS3UploadMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProcessingS3UploadMode::Continuous => "Continuous",
            ProcessingS3UploadMode::EndOfJob => "EndOfJob",
            ProcessingS3UploadMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Continuous", "EndOfJob"]
    }
}
impl AsRef<str> for ProcessingS3UploadMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The inputs for a monitoring job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MonitoringInput {
    /// <p>The endpoint for a monitoring job.</p>
    pub endpoint_input: std::option::Option<crate::model::EndpointInput>,
}
impl MonitoringInput {
    /// <p>The endpoint for a monitoring job.</p>
    pub fn endpoint_input(&self) -> std::option::Option<&crate::model::EndpointInput> {
        self.endpoint_input.as_ref()
    }
}
impl std::fmt::Debug for MonitoringInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MonitoringInput");
        formatter.field("endpoint_input", &self.endpoint_input);
        formatter.finish()
    }
}
/// See [`MonitoringInput`](crate::model::MonitoringInput)
pub mod monitoring_input {
    /// A builder for [`MonitoringInput`](crate::model::MonitoringInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_input: std::option::Option<crate::model::EndpointInput>,
    }
    impl Builder {
        /// <p>The endpoint for a monitoring job.</p>
        pub fn endpoint_input(mut self, input: crate::model::EndpointInput) -> Self {
            self.endpoint_input = Some(input);
            self
        }
        /// <p>The endpoint for a monitoring job.</p>
        pub fn set_endpoint_input(
            mut self,
            input: std::option::Option<crate::model::EndpointInput>,
        ) -> Self {
            self.endpoint_input = input;
            self
        }
        /// Consumes the builder and constructs a [`MonitoringInput`](crate::model::MonitoringInput)
        pub fn build(self) -> crate::model::MonitoringInput {
            crate::model::MonitoringInput {
                endpoint_input: self.endpoint_input,
            }
        }
    }
}
impl MonitoringInput {
    /// Creates a new builder-style object to manufacture [`MonitoringInput`](crate::model::MonitoringInput)
    pub fn builder() -> crate::model::monitoring_input::Builder {
        crate::model::monitoring_input::Builder::default()
    }
}

/// <p>Input object for the endpoint</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointInput {
    /// <p>An endpoint in customer's account which has enabled <code>DataCaptureConfig</code>
    /// enabled.</p>
    pub endpoint_name: std::option::Option<std::string::String>,
    /// <p>Path to the filesystem where the endpoint data is available to the container.</p>
    pub local_path: std::option::Option<std::string::String>,
    /// <p>Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for
    /// transferring data for the monitoring job. <code>Pipe</code> mode is recommended for large
    /// datasets. <code>File</code> mode is useful for small files that fit in memory. Defaults to
    /// <code>File</code>.</p>
    pub s3_input_mode: std::option::Option<crate::model::ProcessingS3InputMode>,
    /// <p>Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key.
    /// Defaults to <code>FullyReplicated</code>
    /// </p>
    pub s3_data_distribution_type:
        std::option::Option<crate::model::ProcessingS3DataDistributionType>,
    /// <p>The attributes of the input data that are the input features.</p>
    pub features_attribute: std::option::Option<std::string::String>,
    /// <p>The attribute of the input data that represents the ground truth label.</p>
    pub inference_attribute: std::option::Option<std::string::String>,
    /// <p>In a classification problem, the attribute that represents the class probability.</p>
    pub probability_attribute: std::option::Option<std::string::String>,
    /// <p>The threshold for the class probability to be evaluated as a positive result.</p>
    pub probability_threshold_attribute: std::option::Option<f64>,
    /// <p>If specified, monitoring jobs substract this time from the start time. For information
    /// about using offsets for scheduling monitoring jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model
    /// Quality Monitoring Jobs</a>.</p>
    pub start_time_offset: std::option::Option<std::string::String>,
    /// <p>If specified, monitoring jobs substract this time from the end time. For information
    /// about using offsets for scheduling monitoring jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model
    /// Quality Monitoring Jobs</a>.</p>
    pub end_time_offset: std::option::Option<std::string::String>,
}
impl EndpointInput {
    /// <p>An endpoint in customer's account which has enabled <code>DataCaptureConfig</code>
    /// enabled.</p>
    pub fn endpoint_name(&self) -> std::option::Option<&str> {
        self.endpoint_name.as_deref()
    }
    /// <p>Path to the filesystem where the endpoint data is available to the container.</p>
    pub fn local_path(&self) -> std::option::Option<&str> {
        self.local_path.as_deref()
    }
    /// <p>Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for
    /// transferring data for the monitoring job. <code>Pipe</code> mode is recommended for large
    /// datasets. <code>File</code> mode is useful for small files that fit in memory. Defaults to
    /// <code>File</code>.</p>
    pub fn s3_input_mode(&self) -> std::option::Option<&crate::model::ProcessingS3InputMode> {
        self.s3_input_mode.as_ref()
    }
    /// <p>Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key.
    /// Defaults to <code>FullyReplicated</code>
    /// </p>
    pub fn s3_data_distribution_type(
        &self,
    ) -> std::option::Option<&crate::model::ProcessingS3DataDistributionType> {
        self.s3_data_distribution_type.as_ref()
    }
    /// <p>The attributes of the input data that are the input features.</p>
    pub fn features_attribute(&self) -> std::option::Option<&str> {
        self.features_attribute.as_deref()
    }
    /// <p>The attribute of the input data that represents the ground truth label.</p>
    pub fn inference_attribute(&self) -> std::option::Option<&str> {
        self.inference_attribute.as_deref()
    }
    /// <p>In a classification problem, the attribute that represents the class probability.</p>
    pub fn probability_attribute(&self) -> std::option::Option<&str> {
        self.probability_attribute.as_deref()
    }
    /// <p>The threshold for the class probability to be evaluated as a positive result.</p>
    pub fn probability_threshold_attribute(&self) -> std::option::Option<f64> {
        self.probability_threshold_attribute
    }
    /// <p>If specified, monitoring jobs substract this time from the start time. For information
    /// about using offsets for scheduling monitoring jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model
    /// Quality Monitoring Jobs</a>.</p>
    pub fn start_time_offset(&self) -> std::option::Option<&str> {
        self.start_time_offset.as_deref()
    }
    /// <p>If specified, monitoring jobs substract this time from the end time. For information
    /// about using offsets for scheduling monitoring jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model
    /// Quality Monitoring Jobs</a>.</p>
    pub fn end_time_offset(&self) -> std::option::Option<&str> {
        self.end_time_offset.as_deref()
    }
}
impl std::fmt::Debug for EndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointInput");
        formatter.field("endpoint_name", &self.endpoint_name);
        formatter.field("local_path", &self.local_path);
        formatter.field("s3_input_mode", &self.s3_input_mode);
        formatter.field("s3_data_distribution_type", &self.s3_data_distribution_type);
        formatter.field("features_attribute", &self.features_attribute);
        formatter.field("inference_attribute", &self.inference_attribute);
        formatter.field("probability_attribute", &self.probability_attribute);
        formatter.field(
            "probability_threshold_attribute",
            &self.probability_threshold_attribute,
        );
        formatter.field("start_time_offset", &self.start_time_offset);
        formatter.field("end_time_offset", &self.end_time_offset);
        formatter.finish()
    }
}
/// See [`EndpointInput`](crate::model::EndpointInput)
pub mod endpoint_input {
    /// A builder for [`EndpointInput`](crate::model::EndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_name: std::option::Option<std::string::String>,
        pub(crate) local_path: std::option::Option<std::string::String>,
        pub(crate) s3_input_mode: std::option::Option<crate::model::ProcessingS3InputMode>,
        pub(crate) s3_data_distribution_type:
            std::option::Option<crate::model::ProcessingS3DataDistributionType>,
        pub(crate) features_attribute: std::option::Option<std::string::String>,
        pub(crate) inference_attribute: std::option::Option<std::string::String>,
        pub(crate) probability_attribute: std::option::Option<std::string::String>,
        pub(crate) probability_threshold_attribute: std::option::Option<f64>,
        pub(crate) start_time_offset: std::option::Option<std::string::String>,
        pub(crate) end_time_offset: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An endpoint in customer's account which has enabled <code>DataCaptureConfig</code>
        /// enabled.</p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_name = Some(input.into());
            self
        }
        /// <p>An endpoint in customer's account which has enabled <code>DataCaptureConfig</code>
        /// enabled.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_name = input;
            self
        }
        /// <p>Path to the filesystem where the endpoint data is available to the container.</p>
        pub fn local_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.local_path = Some(input.into());
            self
        }
        /// <p>Path to the filesystem where the endpoint data is available to the container.</p>
        pub fn set_local_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.local_path = input;
            self
        }
        /// <p>Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for
        /// transferring data for the monitoring job. <code>Pipe</code> mode is recommended for large
        /// datasets. <code>File</code> mode is useful for small files that fit in memory. Defaults to
        /// <code>File</code>.</p>
        pub fn s3_input_mode(mut self, input: crate::model::ProcessingS3InputMode) -> Self {
            self.s3_input_mode = Some(input);
            self
        }
        /// <p>Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for
        /// transferring data for the monitoring job. <code>Pipe</code> mode is recommended for large
        /// datasets. <code>File</code> mode is useful for small files that fit in memory. Defaults to
        /// <code>File</code>.</p>
        pub fn set_s3_input_mode(
            mut self,
            input: std::option::Option<crate::model::ProcessingS3InputMode>,
        ) -> Self {
            self.s3_input_mode = input;
            self
        }
        /// <p>Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key.
        /// Defaults to <code>FullyReplicated</code>
        /// </p>
        pub fn s3_data_distribution_type(
            mut self,
            input: crate::model::ProcessingS3DataDistributionType,
        ) -> Self {
            self.s3_data_distribution_type = Some(input);
            self
        }
        /// <p>Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key.
        /// Defaults to <code>FullyReplicated</code>
        /// </p>
        pub fn set_s3_data_distribution_type(
            mut self,
            input: std::option::Option<crate::model::ProcessingS3DataDistributionType>,
        ) -> Self {
            self.s3_data_distribution_type = input;
            self
        }
        /// <p>The attributes of the input data that are the input features.</p>
        pub fn features_attribute(mut self, input: impl Into<std::string::String>) -> Self {
            self.features_attribute = Some(input.into());
            self
        }
        /// <p>The attributes of the input data that are the input features.</p>
        pub fn set_features_attribute(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.features_attribute = input;
            self
        }
        /// <p>The attribute of the input data that represents the ground truth label.</p>
        pub fn inference_attribute(mut self, input: impl Into<std::string::String>) -> Self {
            self.inference_attribute = Some(input.into());
            self
        }
        /// <p>The attribute of the input data that represents the ground truth label.</p>
        pub fn set_inference_attribute(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inference_attribute = input;
            self
        }
        /// <p>In a classification problem, the attribute that represents the class probability.</p>
        pub fn probability_attribute(mut self, input: impl Into<std::string::String>) -> Self {
            self.probability_attribute = Some(input.into());
            self
        }
        /// <p>In a classification problem, the attribute that represents the class probability.</p>
        pub fn set_probability_attribute(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.probability_attribute = input;
            self
        }
        /// <p>The threshold for the class probability to be evaluated as a positive result.</p>
        pub fn probability_threshold_attribute(mut self, input: f64) -> Self {
            self.probability_threshold_attribute = Some(input);
            self
        }
        /// <p>The threshold for the class probability to be evaluated as a positive result.</p>
        pub fn set_probability_threshold_attribute(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.probability_threshold_attribute = input;
            self
        }
        /// <p>If specified, monitoring jobs substract this time from the start time. For information
        /// about using offsets for scheduling monitoring jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model
        /// Quality Monitoring Jobs</a>.</p>
        pub fn start_time_offset(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_time_offset = Some(input.into());
            self
        }
        /// <p>If specified, monitoring jobs substract this time from the start time. For information
        /// about using offsets for scheduling monitoring jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model
        /// Quality Monitoring Jobs</a>.</p>
        pub fn set_start_time_offset(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.start_time_offset = input;
            self
        }
        /// <p>If specified, monitoring jobs substract this time from the end time. For information
        /// about using offsets for scheduling monitoring jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model
        /// Quality Monitoring Jobs</a>.</p>
        pub fn end_time_offset(mut self, input: impl Into<std::string::String>) -> Self {
            self.end_time_offset = Some(input.into());
            self
        }
        /// <p>If specified, monitoring jobs substract this time from the end time. For information
        /// about using offsets for scheduling monitoring jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model
        /// Quality Monitoring Jobs</a>.</p>
        pub fn set_end_time_offset(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.end_time_offset = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointInput`](crate::model::EndpointInput)
        pub fn build(self) -> crate::model::EndpointInput {
            crate::model::EndpointInput {
                endpoint_name: self.endpoint_name,
                local_path: self.local_path,
                s3_input_mode: self.s3_input_mode,
                s3_data_distribution_type: self.s3_data_distribution_type,
                features_attribute: self.features_attribute,
                inference_attribute: self.inference_attribute,
                probability_attribute: self.probability_attribute,
                probability_threshold_attribute: self.probability_threshold_attribute,
                start_time_offset: self.start_time_offset,
                end_time_offset: self.end_time_offset,
            }
        }
    }
}
impl EndpointInput {
    /// Creates a new builder-style object to manufacture [`EndpointInput`](crate::model::EndpointInput)
    pub fn builder() -> crate::model::endpoint_input::Builder {
        crate::model::endpoint_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProcessingS3DataDistributionType {
    #[allow(missing_docs)] // documentation missing in model
    Fullyreplicated,
    #[allow(missing_docs)] // documentation missing in model
    Shardedbys3Key,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProcessingS3DataDistributionType {
    fn from(s: &str) -> Self {
        match s {
            "FullyReplicated" => ProcessingS3DataDistributionType::Fullyreplicated,
            "ShardedByS3Key" => ProcessingS3DataDistributionType::Shardedbys3Key,
            other => ProcessingS3DataDistributionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProcessingS3DataDistributionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProcessingS3DataDistributionType::from(s))
    }
}
impl ProcessingS3DataDistributionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProcessingS3DataDistributionType::Fullyreplicated => "FullyReplicated",
            ProcessingS3DataDistributionType::Shardedbys3Key => "ShardedByS3Key",
            ProcessingS3DataDistributionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FullyReplicated", "ShardedByS3Key"]
    }
}
impl AsRef<str> for ProcessingS3DataDistributionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProcessingS3InputMode {
    #[allow(missing_docs)] // documentation missing in model
    File,
    #[allow(missing_docs)] // documentation missing in model
    Pipe,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProcessingS3InputMode {
    fn from(s: &str) -> Self {
        match s {
            "File" => ProcessingS3InputMode::File,
            "Pipe" => ProcessingS3InputMode::Pipe,
            other => ProcessingS3InputMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProcessingS3InputMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProcessingS3InputMode::from(s))
    }
}
impl ProcessingS3InputMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProcessingS3InputMode::File => "File",
            ProcessingS3InputMode::Pipe => "Pipe",
            ProcessingS3InputMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["File", "Pipe"]
    }
}
impl AsRef<str> for ProcessingS3InputMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Configuration for monitoring constraints and monitoring statistics. These baseline
/// resources are compared against the results of the current job from the series of jobs
/// scheduled to collect data periodically.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MonitoringBaselineConfig {
    /// <p>The name of the job that performs baselining for the monitoring job.</p>
    pub baselining_job_name: std::option::Option<std::string::String>,
    /// <p>The baseline constraint file in Amazon S3 that the current monitoring job should
    /// validated against.</p>
    pub constraints_resource: std::option::Option<crate::model::MonitoringConstraintsResource>,
    /// <p>The baseline statistics file in Amazon S3 that the current monitoring job should be
    /// validated against.</p>
    pub statistics_resource: std::option::Option<crate::model::MonitoringStatisticsResource>,
}
impl MonitoringBaselineConfig {
    /// <p>The name of the job that performs baselining for the monitoring job.</p>
    pub fn baselining_job_name(&self) -> std::option::Option<&str> {
        self.baselining_job_name.as_deref()
    }
    /// <p>The baseline constraint file in Amazon S3 that the current monitoring job should
    /// validated against.</p>
    pub fn constraints_resource(
        &self,
    ) -> std::option::Option<&crate::model::MonitoringConstraintsResource> {
        self.constraints_resource.as_ref()
    }
    /// <p>The baseline statistics file in Amazon S3 that the current monitoring job should be
    /// validated against.</p>
    pub fn statistics_resource(
        &self,
    ) -> std::option::Option<&crate::model::MonitoringStatisticsResource> {
        self.statistics_resource.as_ref()
    }
}
impl std::fmt::Debug for MonitoringBaselineConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MonitoringBaselineConfig");
        formatter.field("baselining_job_name", &self.baselining_job_name);
        formatter.field("constraints_resource", &self.constraints_resource);
        formatter.field("statistics_resource", &self.statistics_resource);
        formatter.finish()
    }
}
/// See [`MonitoringBaselineConfig`](crate::model::MonitoringBaselineConfig)
pub mod monitoring_baseline_config {
    /// A builder for [`MonitoringBaselineConfig`](crate::model::MonitoringBaselineConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) baselining_job_name: std::option::Option<std::string::String>,
        pub(crate) constraints_resource:
            std::option::Option<crate::model::MonitoringConstraintsResource>,
        pub(crate) statistics_resource:
            std::option::Option<crate::model::MonitoringStatisticsResource>,
    }
    impl Builder {
        /// <p>The name of the job that performs baselining for the monitoring job.</p>
        pub fn baselining_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.baselining_job_name = Some(input.into());
            self
        }
        /// <p>The name of the job that performs baselining for the monitoring job.</p>
        pub fn set_baselining_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.baselining_job_name = input;
            self
        }
        /// <p>The baseline constraint file in Amazon S3 that the current monitoring job should
        /// validated against.</p>
        pub fn constraints_resource(
            mut self,
            input: crate::model::MonitoringConstraintsResource,
        ) -> Self {
            self.constraints_resource = Some(input);
            self
        }
        /// <p>The baseline constraint file in Amazon S3 that the current monitoring job should
        /// validated against.</p>
        pub fn set_constraints_resource(
            mut self,
            input: std::option::Option<crate::model::MonitoringConstraintsResource>,
        ) -> Self {
            self.constraints_resource = input;
            self
        }
        /// <p>The baseline statistics file in Amazon S3 that the current monitoring job should be
        /// validated against.</p>
        pub fn statistics_resource(
            mut self,
            input: crate::model::MonitoringStatisticsResource,
        ) -> Self {
            self.statistics_resource = Some(input);
            self
        }
        /// <p>The baseline statistics file in Amazon S3 that the current monitoring job should be
        /// validated against.</p>
        pub fn set_statistics_resource(
            mut self,
            input: std::option::Option<crate::model::MonitoringStatisticsResource>,
        ) -> Self {
            self.statistics_resource = input;
            self
        }
        /// Consumes the builder and constructs a [`MonitoringBaselineConfig`](crate::model::MonitoringBaselineConfig)
        pub fn build(self) -> crate::model::MonitoringBaselineConfig {
            crate::model::MonitoringBaselineConfig {
                baselining_job_name: self.baselining_job_name,
                constraints_resource: self.constraints_resource,
                statistics_resource: self.statistics_resource,
            }
        }
    }
}
impl MonitoringBaselineConfig {
    /// Creates a new builder-style object to manufacture [`MonitoringBaselineConfig`](crate::model::MonitoringBaselineConfig)
    pub fn builder() -> crate::model::monitoring_baseline_config::Builder {
        crate::model::monitoring_baseline_config::Builder::default()
    }
}

/// <p>The statistics resource for a monitoring job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MonitoringStatisticsResource {
    /// <p>The Amazon S3 URI for the statistics resource.</p>
    pub s3_uri: std::option::Option<std::string::String>,
}
impl MonitoringStatisticsResource {
    /// <p>The Amazon S3 URI for the statistics resource.</p>
    pub fn s3_uri(&self) -> std::option::Option<&str> {
        self.s3_uri.as_deref()
    }
}
impl std::fmt::Debug for MonitoringStatisticsResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MonitoringStatisticsResource");
        formatter.field("s3_uri", &self.s3_uri);
        formatter.finish()
    }
}
/// See [`MonitoringStatisticsResource`](crate::model::MonitoringStatisticsResource)
pub mod monitoring_statistics_resource {
    /// A builder for [`MonitoringStatisticsResource`](crate::model::MonitoringStatisticsResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon S3 URI for the statistics resource.</p>
        pub fn s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_uri = Some(input.into());
            self
        }
        /// <p>The Amazon S3 URI for the statistics resource.</p>
        pub fn set_s3_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`MonitoringStatisticsResource`](crate::model::MonitoringStatisticsResource)
        pub fn build(self) -> crate::model::MonitoringStatisticsResource {
            crate::model::MonitoringStatisticsResource {
                s3_uri: self.s3_uri,
            }
        }
    }
}
impl MonitoringStatisticsResource {
    /// Creates a new builder-style object to manufacture [`MonitoringStatisticsResource`](crate::model::MonitoringStatisticsResource)
    pub fn builder() -> crate::model::monitoring_statistics_resource::Builder {
        crate::model::monitoring_statistics_resource::Builder::default()
    }
}

/// <p>The constraints resource for a monitoring job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MonitoringConstraintsResource {
    /// <p>The Amazon S3 URI for the constraints resource.</p>
    pub s3_uri: std::option::Option<std::string::String>,
}
impl MonitoringConstraintsResource {
    /// <p>The Amazon S3 URI for the constraints resource.</p>
    pub fn s3_uri(&self) -> std::option::Option<&str> {
        self.s3_uri.as_deref()
    }
}
impl std::fmt::Debug for MonitoringConstraintsResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MonitoringConstraintsResource");
        formatter.field("s3_uri", &self.s3_uri);
        formatter.finish()
    }
}
/// See [`MonitoringConstraintsResource`](crate::model::MonitoringConstraintsResource)
pub mod monitoring_constraints_resource {
    /// A builder for [`MonitoringConstraintsResource`](crate::model::MonitoringConstraintsResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon S3 URI for the constraints resource.</p>
        pub fn s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_uri = Some(input.into());
            self
        }
        /// <p>The Amazon S3 URI for the constraints resource.</p>
        pub fn set_s3_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`MonitoringConstraintsResource`](crate::model::MonitoringConstraintsResource)
        pub fn build(self) -> crate::model::MonitoringConstraintsResource {
            crate::model::MonitoringConstraintsResource {
                s3_uri: self.s3_uri,
            }
        }
    }
}
impl MonitoringConstraintsResource {
    /// Creates a new builder-style object to manufacture [`MonitoringConstraintsResource`](crate::model::MonitoringConstraintsResource)
    pub fn builder() -> crate::model::monitoring_constraints_resource::Builder {
        crate::model::monitoring_constraints_resource::Builder::default()
    }
}

/// <p>Configuration details about the monitoring schedule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduleConfig {
    /// <p>A cron expression that describes details about the monitoring schedule.</p>
    ///
    /// <p>Currently the only supported cron expressions are:</p>
    /// <ul>
    /// <li>
    /// <p>If you want to set the job to start every hour, please use the following:</p>
    /// <p>
    /// <code>Hourly: cron(0 * ? * * *)</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>If you want to start the job daily:</p>
    /// <p>
    /// <code>cron(0 [00-23] ? * * *)</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For example, the following are valid cron expressions:</p>
    /// <ul>
    /// <li>
    /// <p>Daily at noon UTC: <code>cron(0 12 ? * * *)</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Daily at midnight UTC: <code>cron(0 0 ? * * *)</code>
    /// </p>
    /// </li>
    /// </ul>
    ///
    /// <p>To support running every 6, 12 hours, the following are also supported:</p>
    /// <p>
    /// <code>cron(0 [00-23]/[01-24] ? * * *)</code>
    /// </p>
    /// <p>For example, the following are valid cron expressions:</p>
    /// <ul>
    /// <li>
    /// <p>Every 12 hours, starting at 5pm UTC: <code>cron(0 17/12 ? * * *)</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Every two hours starting at midnight: <code>cron(0 0/2 ? * * *)</code>
    /// </p>
    /// </li>
    /// </ul>
    ///
    /// <note>
    /// <ul>
    /// <li>
    /// <p>Even though the cron expression is set to start at 5PM UTC, note that there
    /// could be a delay of 0-20 minutes from the actual requested time to run the
    /// execution. </p>
    /// </li>
    /// <li>
    /// <p>We recommend that if you would like a daily schedule, you do not provide this
    /// parameter. Amazon SageMaker will pick a time for running every day.</p>
    /// </li>
    /// </ul>
    /// </note>
    pub schedule_expression: std::option::Option<std::string::String>,
}
impl ScheduleConfig {
    /// <p>A cron expression that describes details about the monitoring schedule.</p>
    ///
    /// <p>Currently the only supported cron expressions are:</p>
    /// <ul>
    /// <li>
    /// <p>If you want to set the job to start every hour, please use the following:</p>
    /// <p>
    /// <code>Hourly: cron(0 * ? * * *)</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>If you want to start the job daily:</p>
    /// <p>
    /// <code>cron(0 [00-23] ? * * *)</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For example, the following are valid cron expressions:</p>
    /// <ul>
    /// <li>
    /// <p>Daily at noon UTC: <code>cron(0 12 ? * * *)</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Daily at midnight UTC: <code>cron(0 0 ? * * *)</code>
    /// </p>
    /// </li>
    /// </ul>
    ///
    /// <p>To support running every 6, 12 hours, the following are also supported:</p>
    /// <p>
    /// <code>cron(0 [00-23]/[01-24] ? * * *)</code>
    /// </p>
    /// <p>For example, the following are valid cron expressions:</p>
    /// <ul>
    /// <li>
    /// <p>Every 12 hours, starting at 5pm UTC: <code>cron(0 17/12 ? * * *)</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Every two hours starting at midnight: <code>cron(0 0/2 ? * * *)</code>
    /// </p>
    /// </li>
    /// </ul>
    ///
    /// <note>
    /// <ul>
    /// <li>
    /// <p>Even though the cron expression is set to start at 5PM UTC, note that there
    /// could be a delay of 0-20 minutes from the actual requested time to run the
    /// execution. </p>
    /// </li>
    /// <li>
    /// <p>We recommend that if you would like a daily schedule, you do not provide this
    /// parameter. Amazon SageMaker will pick a time for running every day.</p>
    /// </li>
    /// </ul>
    /// </note>
    pub fn schedule_expression(&self) -> std::option::Option<&str> {
        self.schedule_expression.as_deref()
    }
}
impl std::fmt::Debug for ScheduleConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduleConfig");
        formatter.field("schedule_expression", &self.schedule_expression);
        formatter.finish()
    }
}
/// See [`ScheduleConfig`](crate::model::ScheduleConfig)
pub mod schedule_config {
    /// A builder for [`ScheduleConfig`](crate::model::ScheduleConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schedule_expression: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A cron expression that describes details about the monitoring schedule.</p>
        ///
        /// <p>Currently the only supported cron expressions are:</p>
        /// <ul>
        /// <li>
        /// <p>If you want to set the job to start every hour, please use the following:</p>
        /// <p>
        /// <code>Hourly: cron(0 * ? * * *)</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>If you want to start the job daily:</p>
        /// <p>
        /// <code>cron(0 [00-23] ? * * *)</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For example, the following are valid cron expressions:</p>
        /// <ul>
        /// <li>
        /// <p>Daily at noon UTC: <code>cron(0 12 ? * * *)</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Daily at midnight UTC: <code>cron(0 0 ? * * *)</code>
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <p>To support running every 6, 12 hours, the following are also supported:</p>
        /// <p>
        /// <code>cron(0 [00-23]/[01-24] ? * * *)</code>
        /// </p>
        /// <p>For example, the following are valid cron expressions:</p>
        /// <ul>
        /// <li>
        /// <p>Every 12 hours, starting at 5pm UTC: <code>cron(0 17/12 ? * * *)</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Every two hours starting at midnight: <code>cron(0 0/2 ? * * *)</code>
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <note>
        /// <ul>
        /// <li>
        /// <p>Even though the cron expression is set to start at 5PM UTC, note that there
        /// could be a delay of 0-20 minutes from the actual requested time to run the
        /// execution. </p>
        /// </li>
        /// <li>
        /// <p>We recommend that if you would like a daily schedule, you do not provide this
        /// parameter. Amazon SageMaker will pick a time for running every day.</p>
        /// </li>
        /// </ul>
        /// </note>
        pub fn schedule_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_expression = Some(input.into());
            self
        }
        /// <p>A cron expression that describes details about the monitoring schedule.</p>
        ///
        /// <p>Currently the only supported cron expressions are:</p>
        /// <ul>
        /// <li>
        /// <p>If you want to set the job to start every hour, please use the following:</p>
        /// <p>
        /// <code>Hourly: cron(0 * ? * * *)</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>If you want to start the job daily:</p>
        /// <p>
        /// <code>cron(0 [00-23] ? * * *)</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For example, the following are valid cron expressions:</p>
        /// <ul>
        /// <li>
        /// <p>Daily at noon UTC: <code>cron(0 12 ? * * *)</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Daily at midnight UTC: <code>cron(0 0 ? * * *)</code>
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <p>To support running every 6, 12 hours, the following are also supported:</p>
        /// <p>
        /// <code>cron(0 [00-23]/[01-24] ? * * *)</code>
        /// </p>
        /// <p>For example, the following are valid cron expressions:</p>
        /// <ul>
        /// <li>
        /// <p>Every 12 hours, starting at 5pm UTC: <code>cron(0 17/12 ? * * *)</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Every two hours starting at midnight: <code>cron(0 0/2 ? * * *)</code>
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <note>
        /// <ul>
        /// <li>
        /// <p>Even though the cron expression is set to start at 5PM UTC, note that there
        /// could be a delay of 0-20 minutes from the actual requested time to run the
        /// execution. </p>
        /// </li>
        /// <li>
        /// <p>We recommend that if you would like a daily schedule, you do not provide this
        /// parameter. Amazon SageMaker will pick a time for running every day.</p>
        /// </li>
        /// </ul>
        /// </note>
        pub fn set_schedule_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_expression = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduleConfig`](crate::model::ScheduleConfig)
        pub fn build(self) -> crate::model::ScheduleConfig {
            crate::model::ScheduleConfig {
                schedule_expression: self.schedule_expression,
            }
        }
    }
}
impl ScheduleConfig {
    /// Creates a new builder-style object to manufacture [`ScheduleConfig`](crate::model::ScheduleConfig)
    pub fn builder() -> crate::model::schedule_config::Builder {
        crate::model::schedule_config::Builder::default()
    }
}

/// <p>A structure of additional Inference Specification. Additional Inference Specification
/// specifies details about inference jobs that can be run with models based on
/// this model package</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdditionalInferenceSpecificationDefinition {
    /// <p>A unique name to identify the additional inference specification. The name must
    /// be unique within the list of your additional inference specifications for a
    /// particular model package.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the additional Inference specification</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon ECR registry path of the Docker image that contains the inference code.</p>
    pub containers:
        std::option::Option<std::vec::Vec<crate::model::ModelPackageContainerDefinition>>,
    /// <p>A list of the instance types on which a transformation job can be run
    /// or on which an endpoint can be deployed.</p>
    pub supported_transform_instance_types:
        std::option::Option<std::vec::Vec<crate::model::TransformInstanceType>>,
    /// <p>A list of the instance types that are used to generate inferences in real-time.</p>
    pub supported_realtime_inference_instance_types:
        std::option::Option<std::vec::Vec<crate::model::ProductionVariantInstanceType>>,
    /// <p>The supported MIME types for the input data.</p>
    pub supported_content_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The supported MIME types for the output data.</p>
    pub supported_response_mime_types: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AdditionalInferenceSpecificationDefinition {
    /// <p>A unique name to identify the additional inference specification. The name must
    /// be unique within the list of your additional inference specifications for a
    /// particular model package.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the additional Inference specification</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon ECR registry path of the Docker image that contains the inference code.</p>
    pub fn containers(
        &self,
    ) -> std::option::Option<&[crate::model::ModelPackageContainerDefinition]> {
        self.containers.as_deref()
    }
    /// <p>A list of the instance types on which a transformation job can be run
    /// or on which an endpoint can be deployed.</p>
    pub fn supported_transform_instance_types(
        &self,
    ) -> std::option::Option<&[crate::model::TransformInstanceType]> {
        self.supported_transform_instance_types.as_deref()
    }
    /// <p>A list of the instance types that are used to generate inferences in real-time.</p>
    pub fn supported_realtime_inference_instance_types(
        &self,
    ) -> std::option::Option<&[crate::model::ProductionVariantInstanceType]> {
        self.supported_realtime_inference_instance_types.as_deref()
    }
    /// <p>The supported MIME types for the input data.</p>
    pub fn supported_content_types(&self) -> std::option::Option<&[std::string::String]> {
        self.supported_content_types.as_deref()
    }
    /// <p>The supported MIME types for the output data.</p>
    pub fn supported_response_mime_types(&self) -> std::option::Option<&[std::string::String]> {
        self.supported_response_mime_types.as_deref()
    }
}
impl std::fmt::Debug for AdditionalInferenceSpecificationDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdditionalInferenceSpecificationDefinition");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("containers", &self.containers);
        formatter.field(
            "supported_transform_instance_types",
            &self.supported_transform_instance_types,
        );
        formatter.field(
            "supported_realtime_inference_instance_types",
            &self.supported_realtime_inference_instance_types,
        );
        formatter.field("supported_content_types", &self.supported_content_types);
        formatter.field(
            "supported_response_mime_types",
            &self.supported_response_mime_types,
        );
        formatter.finish()
    }
}
/// See [`AdditionalInferenceSpecificationDefinition`](crate::model::AdditionalInferenceSpecificationDefinition)
pub mod additional_inference_specification_definition {
    /// A builder for [`AdditionalInferenceSpecificationDefinition`](crate::model::AdditionalInferenceSpecificationDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) containers:
            std::option::Option<std::vec::Vec<crate::model::ModelPackageContainerDefinition>>,
        pub(crate) supported_transform_instance_types:
            std::option::Option<std::vec::Vec<crate::model::TransformInstanceType>>,
        pub(crate) supported_realtime_inference_instance_types:
            std::option::Option<std::vec::Vec<crate::model::ProductionVariantInstanceType>>,
        pub(crate) supported_content_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) supported_response_mime_types:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>A unique name to identify the additional inference specification. The name must
        /// be unique within the list of your additional inference specifications for a
        /// particular model package.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A unique name to identify the additional inference specification. The name must
        /// be unique within the list of your additional inference specifications for a
        /// particular model package.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the additional Inference specification</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the additional Inference specification</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `containers`.
        ///
        /// To override the contents of this collection use [`set_containers`](Self::set_containers).
        ///
        /// <p>The Amazon ECR registry path of the Docker image that contains the inference code.</p>
        pub fn containers(
            mut self,
            input: impl Into<crate::model::ModelPackageContainerDefinition>,
        ) -> Self {
            let mut v = self.containers.unwrap_or_default();
            v.push(input.into());
            self.containers = Some(v);
            self
        }
        /// <p>The Amazon ECR registry path of the Docker image that contains the inference code.</p>
        pub fn set_containers(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ModelPackageContainerDefinition>,
            >,
        ) -> Self {
            self.containers = input;
            self
        }
        /// Appends an item to `supported_transform_instance_types`.
        ///
        /// To override the contents of this collection use [`set_supported_transform_instance_types`](Self::set_supported_transform_instance_types).
        ///
        /// <p>A list of the instance types on which a transformation job can be run
        /// or on which an endpoint can be deployed.</p>
        pub fn supported_transform_instance_types(
            mut self,
            input: impl Into<crate::model::TransformInstanceType>,
        ) -> Self {
            let mut v = self.supported_transform_instance_types.unwrap_or_default();
            v.push(input.into());
            self.supported_transform_instance_types = Some(v);
            self
        }
        /// <p>A list of the instance types on which a transformation job can be run
        /// or on which an endpoint can be deployed.</p>
        pub fn set_supported_transform_instance_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TransformInstanceType>>,
        ) -> Self {
            self.supported_transform_instance_types = input;
            self
        }
        /// Appends an item to `supported_realtime_inference_instance_types`.
        ///
        /// To override the contents of this collection use [`set_supported_realtime_inference_instance_types`](Self::set_supported_realtime_inference_instance_types).
        ///
        /// <p>A list of the instance types that are used to generate inferences in real-time.</p>
        pub fn supported_realtime_inference_instance_types(
            mut self,
            input: impl Into<crate::model::ProductionVariantInstanceType>,
        ) -> Self {
            let mut v = self
                .supported_realtime_inference_instance_types
                .unwrap_or_default();
            v.push(input.into());
            self.supported_realtime_inference_instance_types = Some(v);
            self
        }
        /// <p>A list of the instance types that are used to generate inferences in real-time.</p>
        pub fn set_supported_realtime_inference_instance_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProductionVariantInstanceType>>,
        ) -> Self {
            self.supported_realtime_inference_instance_types = input;
            self
        }
        /// Appends an item to `supported_content_types`.
        ///
        /// To override the contents of this collection use [`set_supported_content_types`](Self::set_supported_content_types).
        ///
        /// <p>The supported MIME types for the input data.</p>
        pub fn supported_content_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.supported_content_types.unwrap_or_default();
            v.push(input.into());
            self.supported_content_types = Some(v);
            self
        }
        /// <p>The supported MIME types for the input data.</p>
        pub fn set_supported_content_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_content_types = input;
            self
        }
        /// Appends an item to `supported_response_mime_types`.
        ///
        /// To override the contents of this collection use [`set_supported_response_mime_types`](Self::set_supported_response_mime_types).
        ///
        /// <p>The supported MIME types for the output data.</p>
        pub fn supported_response_mime_types(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.supported_response_mime_types.unwrap_or_default();
            v.push(input.into());
            self.supported_response_mime_types = Some(v);
            self
        }
        /// <p>The supported MIME types for the output data.</p>
        pub fn set_supported_response_mime_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_response_mime_types = input;
            self
        }
        /// Consumes the builder and constructs a [`AdditionalInferenceSpecificationDefinition`](crate::model::AdditionalInferenceSpecificationDefinition)
        pub fn build(self) -> crate::model::AdditionalInferenceSpecificationDefinition {
            crate::model::AdditionalInferenceSpecificationDefinition {
                name: self.name,
                description: self.description,
                containers: self.containers,
                supported_transform_instance_types: self.supported_transform_instance_types,
                supported_realtime_inference_instance_types: self
                    .supported_realtime_inference_instance_types,
                supported_content_types: self.supported_content_types,
                supported_response_mime_types: self.supported_response_mime_types,
            }
        }
    }
}
impl AdditionalInferenceSpecificationDefinition {
    /// Creates a new builder-style object to manufacture [`AdditionalInferenceSpecificationDefinition`](crate::model::AdditionalInferenceSpecificationDefinition)
    pub fn builder() -> crate::model::additional_inference_specification_definition::Builder {
        crate::model::additional_inference_specification_definition::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProductionVariantInstanceType {
    #[allow(missing_docs)] // documentation missing in model
    MlC42Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC44Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC48Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC4Large,
    #[allow(missing_docs)] // documentation missing in model
    MlC4Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC518Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC52Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC54Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC59Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC5Large,
    #[allow(missing_docs)] // documentation missing in model
    MlC5Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC5D18Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC5D2Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC5D4Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC5D9Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC5DLarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC5DXlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4Dn12Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4Dn16Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4Dn2Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4Dn4Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4Dn8Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4DnXlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlInf124Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlInf12Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlInf16Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlInf1Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM410Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM416Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM42Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM44Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM4Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM512Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM524Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM52Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM54Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM5Large,
    #[allow(missing_docs)] // documentation missing in model
    MlM5Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM5D12Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM5D24Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM5D2Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM5D4Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM5DLarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM5DXlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlP216Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlP28Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlP2Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlP316Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlP32Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlP38Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR512Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR524Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR52Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR54Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR5Large,
    #[allow(missing_docs)] // documentation missing in model
    MlR5Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR5D12Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR5D24Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR5D2Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR5D4Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR5DLarge,
    #[allow(missing_docs)] // documentation missing in model
    MlR5DXlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlT22Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlT2Large,
    #[allow(missing_docs)] // documentation missing in model
    MlT2Medium,
    #[allow(missing_docs)] // documentation missing in model
    MlT2Xlarge,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProductionVariantInstanceType {
    fn from(s: &str) -> Self {
        match s {
            "ml.c4.2xlarge" => ProductionVariantInstanceType::MlC42Xlarge,
            "ml.c4.4xlarge" => ProductionVariantInstanceType::MlC44Xlarge,
            "ml.c4.8xlarge" => ProductionVariantInstanceType::MlC48Xlarge,
            "ml.c4.large" => ProductionVariantInstanceType::MlC4Large,
            "ml.c4.xlarge" => ProductionVariantInstanceType::MlC4Xlarge,
            "ml.c5.18xlarge" => ProductionVariantInstanceType::MlC518Xlarge,
            "ml.c5.2xlarge" => ProductionVariantInstanceType::MlC52Xlarge,
            "ml.c5.4xlarge" => ProductionVariantInstanceType::MlC54Xlarge,
            "ml.c5.9xlarge" => ProductionVariantInstanceType::MlC59Xlarge,
            "ml.c5.large" => ProductionVariantInstanceType::MlC5Large,
            "ml.c5.xlarge" => ProductionVariantInstanceType::MlC5Xlarge,
            "ml.c5d.18xlarge" => ProductionVariantInstanceType::MlC5D18Xlarge,
            "ml.c5d.2xlarge" => ProductionVariantInstanceType::MlC5D2Xlarge,
            "ml.c5d.4xlarge" => ProductionVariantInstanceType::MlC5D4Xlarge,
            "ml.c5d.9xlarge" => ProductionVariantInstanceType::MlC5D9Xlarge,
            "ml.c5d.large" => ProductionVariantInstanceType::MlC5DLarge,
            "ml.c5d.xlarge" => ProductionVariantInstanceType::MlC5DXlarge,
            "ml.g4dn.12xlarge" => ProductionVariantInstanceType::MlG4Dn12Xlarge,
            "ml.g4dn.16xlarge" => ProductionVariantInstanceType::MlG4Dn16Xlarge,
            "ml.g4dn.2xlarge" => ProductionVariantInstanceType::MlG4Dn2Xlarge,
            "ml.g4dn.4xlarge" => ProductionVariantInstanceType::MlG4Dn4Xlarge,
            "ml.g4dn.8xlarge" => ProductionVariantInstanceType::MlG4Dn8Xlarge,
            "ml.g4dn.xlarge" => ProductionVariantInstanceType::MlG4DnXlarge,
            "ml.inf1.24xlarge" => ProductionVariantInstanceType::MlInf124Xlarge,
            "ml.inf1.2xlarge" => ProductionVariantInstanceType::MlInf12Xlarge,
            "ml.inf1.6xlarge" => ProductionVariantInstanceType::MlInf16Xlarge,
            "ml.inf1.xlarge" => ProductionVariantInstanceType::MlInf1Xlarge,
            "ml.m4.10xlarge" => ProductionVariantInstanceType::MlM410Xlarge,
            "ml.m4.16xlarge" => ProductionVariantInstanceType::MlM416Xlarge,
            "ml.m4.2xlarge" => ProductionVariantInstanceType::MlM42Xlarge,
            "ml.m4.4xlarge" => ProductionVariantInstanceType::MlM44Xlarge,
            "ml.m4.xlarge" => ProductionVariantInstanceType::MlM4Xlarge,
            "ml.m5.12xlarge" => ProductionVariantInstanceType::MlM512Xlarge,
            "ml.m5.24xlarge" => ProductionVariantInstanceType::MlM524Xlarge,
            "ml.m5.2xlarge" => ProductionVariantInstanceType::MlM52Xlarge,
            "ml.m5.4xlarge" => ProductionVariantInstanceType::MlM54Xlarge,
            "ml.m5.large" => ProductionVariantInstanceType::MlM5Large,
            "ml.m5.xlarge" => ProductionVariantInstanceType::MlM5Xlarge,
            "ml.m5d.12xlarge" => ProductionVariantInstanceType::MlM5D12Xlarge,
            "ml.m5d.24xlarge" => ProductionVariantInstanceType::MlM5D24Xlarge,
            "ml.m5d.2xlarge" => ProductionVariantInstanceType::MlM5D2Xlarge,
            "ml.m5d.4xlarge" => ProductionVariantInstanceType::MlM5D4Xlarge,
            "ml.m5d.large" => ProductionVariantInstanceType::MlM5DLarge,
            "ml.m5d.xlarge" => ProductionVariantInstanceType::MlM5DXlarge,
            "ml.p2.16xlarge" => ProductionVariantInstanceType::MlP216Xlarge,
            "ml.p2.8xlarge" => ProductionVariantInstanceType::MlP28Xlarge,
            "ml.p2.xlarge" => ProductionVariantInstanceType::MlP2Xlarge,
            "ml.p3.16xlarge" => ProductionVariantInstanceType::MlP316Xlarge,
            "ml.p3.2xlarge" => ProductionVariantInstanceType::MlP32Xlarge,
            "ml.p3.8xlarge" => ProductionVariantInstanceType::MlP38Xlarge,
            "ml.r5.12xlarge" => ProductionVariantInstanceType::MlR512Xlarge,
            "ml.r5.24xlarge" => ProductionVariantInstanceType::MlR524Xlarge,
            "ml.r5.2xlarge" => ProductionVariantInstanceType::MlR52Xlarge,
            "ml.r5.4xlarge" => ProductionVariantInstanceType::MlR54Xlarge,
            "ml.r5.large" => ProductionVariantInstanceType::MlR5Large,
            "ml.r5.xlarge" => ProductionVariantInstanceType::MlR5Xlarge,
            "ml.r5d.12xlarge" => ProductionVariantInstanceType::MlR5D12Xlarge,
            "ml.r5d.24xlarge" => ProductionVariantInstanceType::MlR5D24Xlarge,
            "ml.r5d.2xlarge" => ProductionVariantInstanceType::MlR5D2Xlarge,
            "ml.r5d.4xlarge" => ProductionVariantInstanceType::MlR5D4Xlarge,
            "ml.r5d.large" => ProductionVariantInstanceType::MlR5DLarge,
            "ml.r5d.xlarge" => ProductionVariantInstanceType::MlR5DXlarge,
            "ml.t2.2xlarge" => ProductionVariantInstanceType::MlT22Xlarge,
            "ml.t2.large" => ProductionVariantInstanceType::MlT2Large,
            "ml.t2.medium" => ProductionVariantInstanceType::MlT2Medium,
            "ml.t2.xlarge" => ProductionVariantInstanceType::MlT2Xlarge,
            other => ProductionVariantInstanceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProductionVariantInstanceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProductionVariantInstanceType::from(s))
    }
}
impl ProductionVariantInstanceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProductionVariantInstanceType::MlC42Xlarge => "ml.c4.2xlarge",
            ProductionVariantInstanceType::MlC44Xlarge => "ml.c4.4xlarge",
            ProductionVariantInstanceType::MlC48Xlarge => "ml.c4.8xlarge",
            ProductionVariantInstanceType::MlC4Large => "ml.c4.large",
            ProductionVariantInstanceType::MlC4Xlarge => "ml.c4.xlarge",
            ProductionVariantInstanceType::MlC518Xlarge => "ml.c5.18xlarge",
            ProductionVariantInstanceType::MlC52Xlarge => "ml.c5.2xlarge",
            ProductionVariantInstanceType::MlC54Xlarge => "ml.c5.4xlarge",
            ProductionVariantInstanceType::MlC59Xlarge => "ml.c5.9xlarge",
            ProductionVariantInstanceType::MlC5Large => "ml.c5.large",
            ProductionVariantInstanceType::MlC5Xlarge => "ml.c5.xlarge",
            ProductionVariantInstanceType::MlC5D18Xlarge => "ml.c5d.18xlarge",
            ProductionVariantInstanceType::MlC5D2Xlarge => "ml.c5d.2xlarge",
            ProductionVariantInstanceType::MlC5D4Xlarge => "ml.c5d.4xlarge",
            ProductionVariantInstanceType::MlC5D9Xlarge => "ml.c5d.9xlarge",
            ProductionVariantInstanceType::MlC5DLarge => "ml.c5d.large",
            ProductionVariantInstanceType::MlC5DXlarge => "ml.c5d.xlarge",
            ProductionVariantInstanceType::MlG4Dn12Xlarge => "ml.g4dn.12xlarge",
            ProductionVariantInstanceType::MlG4Dn16Xlarge => "ml.g4dn.16xlarge",
            ProductionVariantInstanceType::MlG4Dn2Xlarge => "ml.g4dn.2xlarge",
            ProductionVariantInstanceType::MlG4Dn4Xlarge => "ml.g4dn.4xlarge",
            ProductionVariantInstanceType::MlG4Dn8Xlarge => "ml.g4dn.8xlarge",
            ProductionVariantInstanceType::MlG4DnXlarge => "ml.g4dn.xlarge",
            ProductionVariantInstanceType::MlInf124Xlarge => "ml.inf1.24xlarge",
            ProductionVariantInstanceType::MlInf12Xlarge => "ml.inf1.2xlarge",
            ProductionVariantInstanceType::MlInf16Xlarge => "ml.inf1.6xlarge",
            ProductionVariantInstanceType::MlInf1Xlarge => "ml.inf1.xlarge",
            ProductionVariantInstanceType::MlM410Xlarge => "ml.m4.10xlarge",
            ProductionVariantInstanceType::MlM416Xlarge => "ml.m4.16xlarge",
            ProductionVariantInstanceType::MlM42Xlarge => "ml.m4.2xlarge",
            ProductionVariantInstanceType::MlM44Xlarge => "ml.m4.4xlarge",
            ProductionVariantInstanceType::MlM4Xlarge => "ml.m4.xlarge",
            ProductionVariantInstanceType::MlM512Xlarge => "ml.m5.12xlarge",
            ProductionVariantInstanceType::MlM524Xlarge => "ml.m5.24xlarge",
            ProductionVariantInstanceType::MlM52Xlarge => "ml.m5.2xlarge",
            ProductionVariantInstanceType::MlM54Xlarge => "ml.m5.4xlarge",
            ProductionVariantInstanceType::MlM5Large => "ml.m5.large",
            ProductionVariantInstanceType::MlM5Xlarge => "ml.m5.xlarge",
            ProductionVariantInstanceType::MlM5D12Xlarge => "ml.m5d.12xlarge",
            ProductionVariantInstanceType::MlM5D24Xlarge => "ml.m5d.24xlarge",
            ProductionVariantInstanceType::MlM5D2Xlarge => "ml.m5d.2xlarge",
            ProductionVariantInstanceType::MlM5D4Xlarge => "ml.m5d.4xlarge",
            ProductionVariantInstanceType::MlM5DLarge => "ml.m5d.large",
            ProductionVariantInstanceType::MlM5DXlarge => "ml.m5d.xlarge",
            ProductionVariantInstanceType::MlP216Xlarge => "ml.p2.16xlarge",
            ProductionVariantInstanceType::MlP28Xlarge => "ml.p2.8xlarge",
            ProductionVariantInstanceType::MlP2Xlarge => "ml.p2.xlarge",
            ProductionVariantInstanceType::MlP316Xlarge => "ml.p3.16xlarge",
            ProductionVariantInstanceType::MlP32Xlarge => "ml.p3.2xlarge",
            ProductionVariantInstanceType::MlP38Xlarge => "ml.p3.8xlarge",
            ProductionVariantInstanceType::MlR512Xlarge => "ml.r5.12xlarge",
            ProductionVariantInstanceType::MlR524Xlarge => "ml.r5.24xlarge",
            ProductionVariantInstanceType::MlR52Xlarge => "ml.r5.2xlarge",
            ProductionVariantInstanceType::MlR54Xlarge => "ml.r5.4xlarge",
            ProductionVariantInstanceType::MlR5Large => "ml.r5.large",
            ProductionVariantInstanceType::MlR5Xlarge => "ml.r5.xlarge",
            ProductionVariantInstanceType::MlR5D12Xlarge => "ml.r5d.12xlarge",
            ProductionVariantInstanceType::MlR5D24Xlarge => "ml.r5d.24xlarge",
            ProductionVariantInstanceType::MlR5D2Xlarge => "ml.r5d.2xlarge",
            ProductionVariantInstanceType::MlR5D4Xlarge => "ml.r5d.4xlarge",
            ProductionVariantInstanceType::MlR5DLarge => "ml.r5d.large",
            ProductionVariantInstanceType::MlR5DXlarge => "ml.r5d.xlarge",
            ProductionVariantInstanceType::MlT22Xlarge => "ml.t2.2xlarge",
            ProductionVariantInstanceType::MlT2Large => "ml.t2.large",
            ProductionVariantInstanceType::MlT2Medium => "ml.t2.medium",
            ProductionVariantInstanceType::MlT2Xlarge => "ml.t2.xlarge",
            ProductionVariantInstanceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ml.c4.2xlarge",
            "ml.c4.4xlarge",
            "ml.c4.8xlarge",
            "ml.c4.large",
            "ml.c4.xlarge",
            "ml.c5.18xlarge",
            "ml.c5.2xlarge",
            "ml.c5.4xlarge",
            "ml.c5.9xlarge",
            "ml.c5.large",
            "ml.c5.xlarge",
            "ml.c5d.18xlarge",
            "ml.c5d.2xlarge",
            "ml.c5d.4xlarge",
            "ml.c5d.9xlarge",
            "ml.c5d.large",
            "ml.c5d.xlarge",
            "ml.g4dn.12xlarge",
            "ml.g4dn.16xlarge",
            "ml.g4dn.2xlarge",
            "ml.g4dn.4xlarge",
            "ml.g4dn.8xlarge",
            "ml.g4dn.xlarge",
            "ml.inf1.24xlarge",
            "ml.inf1.2xlarge",
            "ml.inf1.6xlarge",
            "ml.inf1.xlarge",
            "ml.m4.10xlarge",
            "ml.m4.16xlarge",
            "ml.m4.2xlarge",
            "ml.m4.4xlarge",
            "ml.m4.xlarge",
            "ml.m5.12xlarge",
            "ml.m5.24xlarge",
            "ml.m5.2xlarge",
            "ml.m5.4xlarge",
            "ml.m5.large",
            "ml.m5.xlarge",
            "ml.m5d.12xlarge",
            "ml.m5d.24xlarge",
            "ml.m5d.2xlarge",
            "ml.m5d.4xlarge",
            "ml.m5d.large",
            "ml.m5d.xlarge",
            "ml.p2.16xlarge",
            "ml.p2.8xlarge",
            "ml.p2.xlarge",
            "ml.p3.16xlarge",
            "ml.p3.2xlarge",
            "ml.p3.8xlarge",
            "ml.r5.12xlarge",
            "ml.r5.24xlarge",
            "ml.r5.2xlarge",
            "ml.r5.4xlarge",
            "ml.r5.large",
            "ml.r5.xlarge",
            "ml.r5d.12xlarge",
            "ml.r5d.24xlarge",
            "ml.r5d.2xlarge",
            "ml.r5d.4xlarge",
            "ml.r5d.large",
            "ml.r5d.xlarge",
            "ml.t2.2xlarge",
            "ml.t2.large",
            "ml.t2.medium",
            "ml.t2.xlarge",
        ]
    }
}
impl AsRef<str> for ProductionVariantInstanceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TransformInstanceType {
    #[allow(missing_docs)] // documentation missing in model
    MlC42Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC44Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC48Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC4Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC518Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC52Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC54Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC59Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlC5Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4Dn12Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4Dn16Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4Dn2Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4Dn4Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4Dn8Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlG4DnXlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM410Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM416Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM42Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM44Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM4Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM512Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM524Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM52Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM54Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlM5Large,
    #[allow(missing_docs)] // documentation missing in model
    MlM5Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlP216Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlP28Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlP2Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlP316Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlP32Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    MlP38Xlarge,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TransformInstanceType {
    fn from(s: &str) -> Self {
        match s {
            "ml.c4.2xlarge" => TransformInstanceType::MlC42Xlarge,
            "ml.c4.4xlarge" => TransformInstanceType::MlC44Xlarge,
            "ml.c4.8xlarge" => TransformInstanceType::MlC48Xlarge,
            "ml.c4.xlarge" => TransformInstanceType::MlC4Xlarge,
            "ml.c5.18xlarge" => TransformInstanceType::MlC518Xlarge,
            "ml.c5.2xlarge" => TransformInstanceType::MlC52Xlarge,
            "ml.c5.4xlarge" => TransformInstanceType::MlC54Xlarge,
            "ml.c5.9xlarge" => TransformInstanceType::MlC59Xlarge,
            "ml.c5.xlarge" => TransformInstanceType::MlC5Xlarge,
            "ml.g4dn.12xlarge" => TransformInstanceType::MlG4Dn12Xlarge,
            "ml.g4dn.16xlarge" => TransformInstanceType::MlG4Dn16Xlarge,
            "ml.g4dn.2xlarge" => TransformInstanceType::MlG4Dn2Xlarge,
            "ml.g4dn.4xlarge" => TransformInstanceType::MlG4Dn4Xlarge,
            "ml.g4dn.8xlarge" => TransformInstanceType::MlG4Dn8Xlarge,
            "ml.g4dn.xlarge" => TransformInstanceType::MlG4DnXlarge,
            "ml.m4.10xlarge" => TransformInstanceType::MlM410Xlarge,
            "ml.m4.16xlarge" => TransformInstanceType::MlM416Xlarge,
            "ml.m4.2xlarge" => TransformInstanceType::MlM42Xlarge,
            "ml.m4.4xlarge" => TransformInstanceType::MlM44Xlarge,
            "ml.m4.xlarge" => TransformInstanceType::MlM4Xlarge,
            "ml.m5.12xlarge" => TransformInstanceType::MlM512Xlarge,
            "ml.m5.24xlarge" => TransformInstanceType::MlM524Xlarge,
            "ml.m5.2xlarge" => TransformInstanceType::MlM52Xlarge,
            "ml.m5.4xlarge" => TransformInstanceType::MlM54Xlarge,
            "ml.m5.large" => TransformInstanceType::MlM5Large,
            "ml.m5.xlarge" => TransformInstanceType::MlM5Xlarge,
            "ml.p2.16xlarge" => TransformInstanceType::MlP216Xlarge,
            "ml.p2.8xlarge" => TransformInstanceType::MlP28Xlarge,
            "ml.p2.xlarge" => TransformInstanceType::MlP2Xlarge,
            "ml.p3.16xlarge" => TransformInstanceType::MlP316Xlarge,
            "ml.p3.2xlarge" => TransformInstanceType::MlP32Xlarge,
            "ml.p3.8xlarge" => TransformInstanceType::MlP38Xlarge,
            other => TransformInstanceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TransformInstanceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TransformInstanceType::from(s))
    }
}
impl TransformInstanceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TransformInstanceType::MlC42Xlarge => "ml.c4.2xlarge",
            TransformInstanceType::MlC44Xlarge => "ml.c4.4xlarge",
            TransformInstanceType::MlC48Xlarge => "ml.c4.8xlarge",
            TransformInstanceType::MlC4Xlarge => "ml.c4.xlarge",
            TransformInstanceType::MlC518Xlarge => "ml.c5.18xlarge",
            TransformInstanceType::MlC52Xlarge => "ml.c5.2xlarge",
            TransformInstanceType::MlC54Xlarge => "ml.c5.4xlarge",
            TransformInstanceType::MlC59Xlarge => "ml.c5.9xlarge",
            TransformInstanceType::MlC5Xlarge => "ml.c5.xlarge",
            TransformInstanceType::MlG4Dn12Xlarge => "ml.g4dn.12xlarge",
            TransformInstanceType::MlG4Dn16Xlarge => "ml.g4dn.16xlarge",
            TransformInstanceType::MlG4Dn2Xlarge => "ml.g4dn.2xlarge",
            TransformInstanceType::MlG4Dn4Xlarge => "ml.g4dn.4xlarge",
            TransformInstanceType::MlG4Dn8Xlarge => "ml.g4dn.8xlarge",
            TransformInstanceType::MlG4DnXlarge => "ml.g4dn.xlarge",
            TransformInstanceType::MlM410Xlarge => "ml.m4.10xlarge",
            TransformInstanceType::MlM416Xlarge => "ml.m4.16xlarge",
            TransformInstanceType::MlM42Xlarge => "ml.m4.2xlarge",
            TransformInstanceType::MlM44Xlarge => "ml.m4.4xlarge",
            TransformInstanceType::MlM4Xlarge => "ml.m4.xlarge",
            TransformInstanceType::MlM512Xlarge => "ml.m5.12xlarge",
            TransformInstanceType::MlM524Xlarge => "ml.m5.24xlarge",
            TransformInstanceType::MlM52Xlarge => "ml.m5.2xlarge",
            TransformInstanceType::MlM54Xlarge => "ml.m5.4xlarge",
            TransformInstanceType::MlM5Large => "ml.m5.large",
            TransformInstanceType::MlM5Xlarge => "ml.m5.xlarge",
            TransformInstanceType::MlP216Xlarge => "ml.p2.16xlarge",
            TransformInstanceType::MlP28Xlarge => "ml.p2.8xlarge",
            TransformInstanceType::MlP2Xlarge => "ml.p2.xlarge",
            TransformInstanceType::MlP316Xlarge => "ml.p3.16xlarge",
            TransformInstanceType::MlP32Xlarge => "ml.p3.2xlarge",
            TransformInstanceType::MlP38Xlarge => "ml.p3.8xlarge",
            TransformInstanceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ml.c4.2xlarge",
            "ml.c4.4xlarge",
            "ml.c4.8xlarge",
            "ml.c4.xlarge",
            "ml.c5.18xlarge",
            "ml.c5.2xlarge",
            "ml.c5.4xlarge",
            "ml.c5.9xlarge",
            "ml.c5.xlarge",
            "ml.g4dn.12xlarge",
            "ml.g4dn.16xlarge",
            "ml.g4dn.2xlarge",
            "ml.g4dn.4xlarge",
            "ml.g4dn.8xlarge",
            "ml.g4dn.xlarge",
            "ml.m4.10xlarge",
            "ml.m4.16xlarge",
            "ml.m4.2xlarge",
            "ml.m4.4xlarge",
            "ml.m4.xlarge",
            "ml.m5.12xlarge",
            "ml.m5.24xlarge",
            "ml.m5.2xlarge",
            "ml.m5.4xlarge",
            "ml.m5.large",
            "ml.m5.xlarge",
            "ml.p2.16xlarge",
            "ml.p2.8xlarge",
            "ml.p2.xlarge",
            "ml.p3.16xlarge",
            "ml.p3.2xlarge",
            "ml.p3.8xlarge",
        ]
    }
}
impl AsRef<str> for TransformInstanceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the Docker container for the model package.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModelPackageContainerDefinition {
    /// <p>The DNS host name for the Docker container.</p>
    pub container_hostname: std::option::Option<std::string::String>,
    /// <p>The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored.</p>
    /// <p>If you are using your own custom algorithm instead of an algorithm provided by Amazon SageMaker,
    /// the inference code must meet Amazon SageMaker requirements. Amazon SageMaker supports both
    /// <code>registry/repository[:tag]</code> and <code>registry/repository[@digest]</code>
    /// image path formats. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon
    /// SageMaker</a>.</p>
    pub image: std::option::Option<std::string::String>,
    /// <p>An MD5 hash of the training algorithm that identifies the Docker image used for
    /// training.</p>
    pub image_digest: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 path where the model artifacts, which result from model training, are stored.
    /// This path must point to a single <code>gzip</code> compressed tar archive
    /// (<code>.tar.gz</code> suffix).</p>
    /// <note>
    /// <p>The model artifacts must be in an S3 bucket that is in the same region as the
    /// model package.</p>
    /// </note>
    pub model_data_url: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Marketplace product ID of the model package.</p>
    pub product_id: std::option::Option<std::string::String>,
    /// <p>The environment variables to set in the Docker container. Each key and value in the
    /// <code>Environment</code> string to string map can have length of up to 1024. We
    /// support up to 16 entries in the map.</p>
    pub environment:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A structure with Model Input details.</p>
    pub model_input: std::option::Option<crate::model::ModelInput>,
    /// <p>The machine learning framework of the model package container image.</p>
    pub framework: std::option::Option<std::string::String>,
    /// <p>The framework version of the Model Package Container Image.</p>
    pub framework_version: std::option::Option<std::string::String>,
    /// <p>The name of a pre-trained machine learning benchmarked by
    /// Amazon SageMaker Inference Recommender model that matches your model.
    /// You can find a list of benchmarked models by calling <code>ListModelMetadata</code>.</p>
    pub nearest_model_name: std::option::Option<std::string::String>,
}
impl ModelPackageContainerDefinition {
    /// <p>The DNS host name for the Docker container.</p>
    pub fn container_hostname(&self) -> std::option::Option<&str> {
        self.container_hostname.as_deref()
    }
    /// <p>The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored.</p>
    /// <p>If you are using your own custom algorithm instead of an algorithm provided by Amazon SageMaker,
    /// the inference code must meet Amazon SageMaker requirements. Amazon SageMaker supports both
    /// <code>registry/repository[:tag]</code> and <code>registry/repository[@digest]</code>
    /// image path formats. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon
    /// SageMaker</a>.</p>
    pub fn image(&self) -> std::option::Option<&str> {
        self.image.as_deref()
    }
    /// <p>An MD5 hash of the training algorithm that identifies the Docker image used for
    /// training.</p>
    pub fn image_digest(&self) -> std::option::Option<&str> {
        self.image_digest.as_deref()
    }
    /// <p>The Amazon S3 path where the model artifacts, which result from model training, are stored.
    /// This path must point to a single <code>gzip</code> compressed tar archive
    /// (<code>.tar.gz</code> suffix).</p>
    /// <note>
    /// <p>The model artifacts must be in an S3 bucket that is in the same region as the
    /// model package.</p>
    /// </note>
    pub fn model_data_url(&self) -> std::option::Option<&str> {
        self.model_data_url.as_deref()
    }
    /// <p>The Amazon Web Services Marketplace product ID of the model package.</p>
    pub fn product_id(&self) -> std::option::Option<&str> {
        self.product_id.as_deref()
    }
    /// <p>The environment variables to set in the Docker container. Each key and value in the
    /// <code>Environment</code> string to string map can have length of up to 1024. We
    /// support up to 16 entries in the map.</p>
    pub fn environment(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.environment.as_ref()
    }
    /// <p>A structure with Model Input details.</p>
    pub fn model_input(&self) -> std::option::Option<&crate::model::ModelInput> {
        self.model_input.as_ref()
    }
    /// <p>The machine learning framework of the model package container image.</p>
    pub fn framework(&self) -> std::option::Option<&str> {
        self.framework.as_deref()
    }
    /// <p>The framework version of the Model Package Container Image.</p>
    pub fn framework_version(&self) -> std::option::Option<&str> {
        self.framework_version.as_deref()
    }
    /// <p>The name of a pre-trained machine learning benchmarked by
    /// Amazon SageMaker Inference Recommender model that matches your model.
    /// You can find a list of benchmarked models by calling <code>ListModelMetadata</code>.</p>
    pub fn nearest_model_name(&self) -> std::option::Option<&str> {
        self.nearest_model_name.as_deref()
    }
}
impl std::fmt::Debug for ModelPackageContainerDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModelPackageContainerDefinition");
        formatter.field("container_hostname", &self.container_hostname);
        formatter.field("image", &self.image);
        formatter.field("image_digest", &self.image_digest);
        formatter.field("model_data_url", &self.model_data_url);
        formatter.field("product_id", &self.product_id);
        formatter.field("environment", &self.environment);
        formatter.field("model_input", &self.model_input);
        formatter.field("framework", &self.framework);
        formatter.field("framework_version", &self.framework_version);
        formatter.field("nearest_model_name", &self.nearest_model_name);
        formatter.finish()
    }
}
/// See [`ModelPackageContainerDefinition`](crate::model::ModelPackageContainerDefinition)
pub mod model_package_container_definition {
    /// A builder for [`ModelPackageContainerDefinition`](crate::model::ModelPackageContainerDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_hostname: std::option::Option<std::string::String>,
        pub(crate) image: std::option::Option<std::string::String>,
        pub(crate) image_digest: std::option::Option<std::string::String>,
        pub(crate) model_data_url: std::option::Option<std::string::String>,
        pub(crate) product_id: std::option::Option<std::string::String>,
        pub(crate) environment: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) model_input: std::option::Option<crate::model::ModelInput>,
        pub(crate) framework: std::option::Option<std::string::String>,
        pub(crate) framework_version: std::option::Option<std::string::String>,
        pub(crate) nearest_model_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The DNS host name for the Docker container.</p>
        pub fn container_hostname(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_hostname = Some(input.into());
            self
        }
        /// <p>The DNS host name for the Docker container.</p>
        pub fn set_container_hostname(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_hostname = input;
            self
        }
        /// <p>The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored.</p>
        /// <p>If you are using your own custom algorithm instead of an algorithm provided by Amazon SageMaker,
        /// the inference code must meet Amazon SageMaker requirements. Amazon SageMaker supports both
        /// <code>registry/repository[:tag]</code> and <code>registry/repository[@digest]</code>
        /// image path formats. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon
        /// SageMaker</a>.</p>
        pub fn image(mut self, input: impl Into<std::string::String>) -> Self {
            self.image = Some(input.into());
            self
        }
        /// <p>The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored.</p>
        /// <p>If you are using your own custom algorithm instead of an algorithm provided by Amazon SageMaker,
        /// the inference code must meet Amazon SageMaker requirements. Amazon SageMaker supports both
        /// <code>registry/repository[:tag]</code> and <code>registry/repository[@digest]</code>
        /// image path formats. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon
        /// SageMaker</a>.</p>
        pub fn set_image(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image = input;
            self
        }
        /// <p>An MD5 hash of the training algorithm that identifies the Docker image used for
        /// training.</p>
        pub fn image_digest(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_digest = Some(input.into());
            self
        }
        /// <p>An MD5 hash of the training algorithm that identifies the Docker image used for
        /// training.</p>
        pub fn set_image_digest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_digest = input;
            self
        }
        /// <p>The Amazon S3 path where the model artifacts, which result from model training, are stored.
        /// This path must point to a single <code>gzip</code> compressed tar archive
        /// (<code>.tar.gz</code> suffix).</p>
        /// <note>
        /// <p>The model artifacts must be in an S3 bucket that is in the same region as the
        /// model package.</p>
        /// </note>
        pub fn model_data_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_data_url = Some(input.into());
            self
        }
        /// <p>The Amazon S3 path where the model artifacts, which result from model training, are stored.
        /// This path must point to a single <code>gzip</code> compressed tar archive
        /// (<code>.tar.gz</code> suffix).</p>
        /// <note>
        /// <p>The model artifacts must be in an S3 bucket that is in the same region as the
        /// model package.</p>
        /// </note>
        pub fn set_model_data_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_data_url = input;
            self
        }
        /// <p>The Amazon Web Services Marketplace product ID of the model package.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Marketplace product ID of the model package.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// Adds a key-value pair to `environment`.
        ///
        /// To override the contents of this collection use [`set_environment`](Self::set_environment).
        ///
        /// <p>The environment variables to set in the Docker container. Each key and value in the
        /// <code>Environment</code> string to string map can have length of up to 1024. We
        /// support up to 16 entries in the map.</p>
        pub fn environment(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.environment.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.environment = Some(hash_map);
            self
        }
        /// <p>The environment variables to set in the Docker container. Each key and value in the
        /// <code>Environment</code> string to string map can have length of up to 1024. We
        /// support up to 16 entries in the map.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.environment = input;
            self
        }
        /// <p>A structure with Model Input details.</p>
        pub fn model_input(mut self, input: crate::model::ModelInput) -> Self {
            self.model_input = Some(input);
            self
        }
        /// <p>A structure with Model Input details.</p>
        pub fn set_model_input(
            mut self,
            input: std::option::Option<crate::model::ModelInput>,
        ) -> Self {
            self.model_input = input;
            self
        }
        /// <p>The machine learning framework of the model package container image.</p>
        pub fn framework(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework = Some(input.into());
            self
        }
        /// <p>The machine learning framework of the model package container image.</p>
        pub fn set_framework(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.framework = input;
            self
        }
        /// <p>The framework version of the Model Package Container Image.</p>
        pub fn framework_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework_version = Some(input.into());
            self
        }
        /// <p>The framework version of the Model Package Container Image.</p>
        pub fn set_framework_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.framework_version = input;
            self
        }
        /// <p>The name of a pre-trained machine learning benchmarked by
        /// Amazon SageMaker Inference Recommender model that matches your model.
        /// You can find a list of benchmarked models by calling <code>ListModelMetadata</code>.</p>
        pub fn nearest_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.nearest_model_name = Some(input.into());
            self
        }
        /// <p>The name of a pre-trained machine learning benchmarked by
        /// Amazon SageMaker Inference Recommender model that matches your model.
        /// You can find a list of benchmarked models by calling <code>ListModelMetadata</code>.</p>
        pub fn set_nearest_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.nearest_model_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ModelPackageContainerDefinition`](crate::model::ModelPackageContainerDefinition)
        pub fn build(self) -> crate::model::ModelPackageContainerDefinition {
            crate::model::ModelPackageContainerDefinition {
                container_hostname: self.container_hostname,
                image: self.image,
                image_digest: self.image_digest,
                model_data_url: self.model_data_url,
                product_id: self.product_id,
                environment: self.environment,
                model_input: self.model_input,
                framework: self.framework,
                framework_version: self.framework_version,
                nearest_model_name: self.nearest_model_name,
            }
        }
    }
}
impl ModelPackageContainerDefinition {
    /// Creates a new builder-style object to manufacture [`ModelPackageContainerDefinition`](crate::model::ModelPackageContainerDefinition)
    pub fn builder() -> crate::model::model_package_container_definition::Builder {
        crate::model::model_package_container_definition::Builder::default()
    }
}

/// <p>Input object for the model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModelInput {
    /// <p>The input configuration object for the model.</p>
    pub data_input_config: std::option::Option<std::string::String>,
}
impl ModelInput {
    /// <p>The input configuration object for the model.</p>
    pub fn data_input_config(&self) -> std::option::Option<&str> {
        self.data_input_config.as_deref()
    }
}
impl std::fmt::Debug for ModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModelInput");
        formatter.field("data_input_config", &self.data_input_config);
        formatter.finish()
    }
}
/// See [`ModelInput`](crate::model::ModelInput)
pub mod model_input {
    /// A builder for [`ModelInput`](crate::model::ModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_input_config: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The input configuration object for the model.</p>
        pub fn data_input_config(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_input_config = Some(input.into());
            self
        }
        /// <p>The input configuration object for the model.</p>
        pub fn set_data_input_config(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_input_config = input;
            self
        }
        /// Consumes the builder and constructs a [`ModelInput`](crate::model::ModelInput)
        pub fn build(self) -> crate::model::ModelInput {
            crate::model::ModelInput {
                data_input_config: self.data_input_config,
            }
        }
    }
}
impl ModelInput {
    /// Creates a new builder-style object to manufacture [`ModelInput`](crate::model::ModelInput)
    pub fn builder() -> crate::model::model_input::Builder {
        crate::model::model_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ModelApprovalStatus {
    #[allow(missing_docs)] // documentation missing in model
    Approved,
    #[allow(missing_docs)] // documentation missing in model
    PendingManualApproval,
    #[allow(missing_docs)] // documentation missing in model
    Rejected,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ModelApprovalStatus {
    fn from(s: &str) -> Self {
        match s {
            "Approved" => ModelApprovalStatus::Approved,
            "PendingManualApproval" => ModelApprovalStatus::PendingManualApproval,
            "Rejected" => ModelApprovalStatus::Rejected,
            other => ModelApprovalStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ModelApprovalStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ModelApprovalStatus::from(s))
    }
}
impl ModelApprovalStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ModelApprovalStatus::Approved => "Approved",
            ModelApprovalStatus::PendingManualApproval => "PendingManualApproval",
            ModelApprovalStatus::Rejected => "Rejected",
            ModelApprovalStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Approved", "PendingManualApproval", "Rejected"]
    }
}
impl AsRef<str> for ModelApprovalStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies weight and capacity values for a production variant.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DesiredWeightAndCapacity {
    /// <p>The name of the
    /// variant
    /// to update.</p>
    pub variant_name: std::option::Option<std::string::String>,
    /// <p>The variant's weight.</p>
    pub desired_weight: std::option::Option<f32>,
    /// <p>The variant's capacity.</p>
    pub desired_instance_count: std::option::Option<i32>,
}
impl DesiredWeightAndCapacity {
    /// <p>The name of the
    /// variant
    /// to update.</p>
    pub fn variant_name(&self) -> std::option::Option<&str> {
        self.variant_name.as_deref()
    }
    /// <p>The variant's weight.</p>
    pub fn desired_weight(&self) -> std::option::Option<f32> {
        self.desired_weight
    }
    /// <p>The variant's capacity.</p>
    pub fn desired_instance_count(&self) -> std::option::Option<i32> {
        self.desired_instance_count
    }
}
impl std::fmt::Debug for DesiredWeightAndCapacity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DesiredWeightAndCapacity");
        formatter.field("variant_name", &self.variant_name);
        formatter.field("desired_weight", &self.desired_weight);
        formatter.field("desired_instance_count", &self.desired_instance_count);
        formatter.finish()
    }
}
/// See [`DesiredWeightAndCapacity`](crate::model::DesiredWeightAndCapacity)
pub mod desired_weight_and_capacity {
    /// A builder for [`DesiredWeightAndCapacity`](crate::model::DesiredWeightAndCapacity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) variant_name: std::option::Option<std::string::String>,
        pub(crate) desired_weight: std::option::Option<f32>,
        pub(crate) desired_instance_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the
        /// variant
        /// to update.</p>
        pub fn variant_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.variant_name = Some(input.into());
            self
        }
        /// <p>The name of the
        /// variant
        /// to update.</p>
        pub fn set_variant_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.variant_name = input;
            self
        }
        /// <p>The variant's weight.</p>
        pub fn desired_weight(mut self, input: f32) -> Self {
            self.desired_weight = Some(input);
            self
        }
        /// <p>The variant's weight.</p>
        pub fn set_desired_weight(mut self, input: std::option::Option<f32>) -> Self {
            self.desired_weight = input;
            self
        }
        /// <p>The variant's capacity.</p>
        pub fn desired_instance_count(mut self, input: i32) -> Self {
            self.desired_instance_count = Some(input);
            self
        }
        /// <p>The variant's capacity.</p>
        pub fn set_desired_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.desired_instance_count = input;
            self
        }
        /// Consumes the builder and constructs a [`DesiredWeightAndCapacity`](crate::model::DesiredWeightAndCapacity)
        pub fn build(self) -> crate::model::DesiredWeightAndCapacity {
            crate::model::DesiredWeightAndCapacity {
                variant_name: self.variant_name,
                desired_weight: self.desired_weight,
                desired_instance_count: self.desired_instance_count,
            }
        }
    }
}
impl DesiredWeightAndCapacity {
    /// Creates a new builder-style object to manufacture [`DesiredWeightAndCapacity`](crate::model::DesiredWeightAndCapacity)
    pub fn builder() -> crate::model::desired_weight_and_capacity::Builder {
        crate::model::desired_weight_and_capacity::Builder::default()
    }
}

/// <p>The deployment configuration for an endpoint, which contains the desired deployment
/// strategy and rollback configurations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeploymentConfig {
    /// <p>Update policy for a blue/green deployment. If this update policy is specified, SageMaker
    /// creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips
    /// traffic to the new fleet according to the specified traffic routing configuration. Only
    /// one update policy should be used in the deployment configuration. If no update policy is
    /// specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting
    /// by default.</p>
    pub blue_green_update_policy: std::option::Option<crate::model::BlueGreenUpdatePolicy>,
    /// <p>Automatic rollback configuration for handling endpoint deployment failures and recovery.</p>
    pub auto_rollback_configuration: std::option::Option<crate::model::AutoRollbackConfig>,
}
impl DeploymentConfig {
    /// <p>Update policy for a blue/green deployment. If this update policy is specified, SageMaker
    /// creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips
    /// traffic to the new fleet according to the specified traffic routing configuration. Only
    /// one update policy should be used in the deployment configuration. If no update policy is
    /// specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting
    /// by default.</p>
    pub fn blue_green_update_policy(
        &self,
    ) -> std::option::Option<&crate::model::BlueGreenUpdatePolicy> {
        self.blue_green_update_policy.as_ref()
    }
    /// <p>Automatic rollback configuration for handling endpoint deployment failures and recovery.</p>
    pub fn auto_rollback_configuration(
        &self,
    ) -> std::option::Option<&crate::model::AutoRollbackConfig> {
        self.auto_rollback_configuration.as_ref()
    }
}
impl std::fmt::Debug for DeploymentConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeploymentConfig");
        formatter.field("blue_green_update_policy", &self.blue_green_update_policy);
        formatter.field(
            "auto_rollback_configuration",
            &self.auto_rollback_configuration,
        );
        formatter.finish()
    }
}
/// See [`DeploymentConfig`](crate::model::DeploymentConfig)
pub mod deployment_config {
    /// A builder for [`DeploymentConfig`](crate::model::DeploymentConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) blue_green_update_policy:
            std::option::Option<crate::model::BlueGreenUpdatePolicy>,
        pub(crate) auto_rollback_configuration:
            std::option::Option<crate::model::AutoRollbackConfig>,
    }
    impl Builder {
        /// <p>Update policy for a blue/green deployment. If this update policy is specified, SageMaker
        /// creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips
        /// traffic to the new fleet according to the specified traffic routing configuration. Only
        /// one update policy should be used in the deployment configuration. If no update policy is
        /// specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting
        /// by default.</p>
        pub fn blue_green_update_policy(
            mut self,
            input: crate::model::BlueGreenUpdatePolicy,
        ) -> Self {
            self.blue_green_update_policy = Some(input);
            self
        }
        /// <p>Update policy for a blue/green deployment. If this update policy is specified, SageMaker
        /// creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips
        /// traffic to the new fleet according to the specified traffic routing configuration. Only
        /// one update policy should be used in the deployment configuration. If no update policy is
        /// specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting
        /// by default.</p>
        pub fn set_blue_green_update_policy(
            mut self,
            input: std::option::Option<crate::model::BlueGreenUpdatePolicy>,
        ) -> Self {
            self.blue_green_update_policy = input;
            self
        }
        /// <p>Automatic rollback configuration for handling endpoint deployment failures and recovery.</p>
        pub fn auto_rollback_configuration(
            mut self,
            input: crate::model::AutoRollbackConfig,
        ) -> Self {
            self.auto_rollback_configuration = Some(input);
            self
        }
        /// <p>Automatic rollback configuration for handling endpoint deployment failures and recovery.</p>
        pub fn set_auto_rollback_configuration(
            mut self,
            input: std::option::Option<crate::model::AutoRollbackConfig>,
        ) -> Self {
            self.auto_rollback_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`DeploymentConfig`](crate::model::DeploymentConfig)
        pub fn build(self) -> crate::model::DeploymentConfig {
            crate::model::DeploymentConfig {
                blue_green_update_policy: self.blue_green_update_policy,
                auto_rollback_configuration: self.auto_rollback_configuration,
            }
        }
    }
}
impl DeploymentConfig {
    /// Creates a new builder-style object to manufacture [`DeploymentConfig`](crate::model::DeploymentConfig)
    pub fn builder() -> crate::model::deployment_config::Builder {
        crate::model::deployment_config::Builder::default()
    }
}

/// <p>Automatic rollback configuration for handling endpoint deployment failures and recovery.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoRollbackConfig {
    /// <p>List of CloudWatch alarms in your account that are configured to monitor metrics on an endpoint.
    /// If any alarms are tripped during a deployment, SageMaker rolls back the deployment.</p>
    pub alarms: std::option::Option<std::vec::Vec<crate::model::Alarm>>,
}
impl AutoRollbackConfig {
    /// <p>List of CloudWatch alarms in your account that are configured to monitor metrics on an endpoint.
    /// If any alarms are tripped during a deployment, SageMaker rolls back the deployment.</p>
    pub fn alarms(&self) -> std::option::Option<&[crate::model::Alarm]> {
        self.alarms.as_deref()
    }
}
impl std::fmt::Debug for AutoRollbackConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoRollbackConfig");
        formatter.field("alarms", &self.alarms);
        formatter.finish()
    }
}
/// See [`AutoRollbackConfig`](crate::model::AutoRollbackConfig)
pub mod auto_rollback_config {
    /// A builder for [`AutoRollbackConfig`](crate::model::AutoRollbackConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alarms: std::option::Option<std::vec::Vec<crate::model::Alarm>>,
    }
    impl Builder {
        /// Appends an item to `alarms`.
        ///
        /// To override the contents of this collection use [`set_alarms`](Self::set_alarms).
        ///
        /// <p>List of CloudWatch alarms in your account that are configured to monitor metrics on an endpoint.
        /// If any alarms are tripped during a deployment, SageMaker rolls back the deployment.</p>
        pub fn alarms(mut self, input: impl Into<crate::model::Alarm>) -> Self {
            let mut v = self.alarms.unwrap_or_default();
            v.push(input.into());
            self.alarms = Some(v);
            self
        }
        /// <p>List of CloudWatch alarms in your account that are configured to monitor metrics on an endpoint.
        /// If any alarms are tripped during a deployment, SageMaker rolls back the deployment.</p>
        pub fn set_alarms(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Alarm>>,
        ) -> Self {
            self.alarms = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoRollbackConfig`](crate::model::AutoRollbackConfig)
        pub fn build(self) -> crate::model::AutoRollbackConfig {
            crate::model::AutoRollbackConfig {
                alarms: self.alarms,
            }
        }
    }
}
impl AutoRollbackConfig {
    /// Creates a new builder-style object to manufacture [`AutoRollbackConfig`](crate::model::AutoRollbackConfig)
    pub fn builder() -> crate::model::auto_rollback_config::Builder {
        crate::model::auto_rollback_config::Builder::default()
    }
}

/// <p>An Amazon CloudWatch alarm configured to monitor metrics on an endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Alarm {
    /// <p>The name of a CloudWatch alarm in your account.</p>
    pub alarm_name: std::option::Option<std::string::String>,
}
impl Alarm {
    /// <p>The name of a CloudWatch alarm in your account.</p>
    pub fn alarm_name(&self) -> std::option::Option<&str> {
        self.alarm_name.as_deref()
    }
}
impl std::fmt::Debug for Alarm {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Alarm");
        formatter.field("alarm_name", &self.alarm_name);
        formatter.finish()
    }
}
/// See [`Alarm`](crate::model::Alarm)
pub mod alarm {
    /// A builder for [`Alarm`](crate::model::Alarm)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alarm_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a CloudWatch alarm in your account.</p>
        pub fn alarm_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_name = Some(input.into());
            self
        }
        /// <p>The name of a CloudWatch alarm in your account.</p>
        pub fn set_alarm_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alarm_name = input;
            self
        }
        /// Consumes the builder and constructs a [`Alarm`](crate::model::Alarm)
        pub fn build(self) -> crate::model::Alarm {
            crate::model::Alarm {
                alarm_name: self.alarm_name,
            }
        }
    }
}
impl Alarm {
    /// Creates a new builder-style object to manufacture [`Alarm`](crate::model::Alarm)
    pub fn builder() -> crate::model::alarm::Builder {
        crate::model::alarm::Builder::default()
    }
}

/// <p>Update policy for a blue/green deployment. If this update policy is specified, SageMaker
/// creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips
/// traffic to the new fleet according to the specified traffic routing configuration. Only
/// one update policy should be used in the deployment configuration. If no update policy is
/// specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting
/// by default.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BlueGreenUpdatePolicy {
    /// <p>Defines the traffic routing strategy to shift traffic from the old fleet to the new fleet
    /// during an endpoint deployment.</p>
    pub traffic_routing_configuration: std::option::Option<crate::model::TrafficRoutingConfig>,
    /// <p>Additional waiting time in seconds after the completion of an endpoint deployment
    /// before terminating the old endpoint fleet. Default is 0.</p>
    pub termination_wait_in_seconds: std::option::Option<i32>,
    /// <p>Maximum execution timeout for the deployment. Note that the timeout value should be larger
    /// than the total waiting time specified in <code>TerminationWaitInSeconds</code> and <code>WaitIntervalInSeconds</code>.</p>
    pub maximum_execution_timeout_in_seconds: std::option::Option<i32>,
}
impl BlueGreenUpdatePolicy {
    /// <p>Defines the traffic routing strategy to shift traffic from the old fleet to the new fleet
    /// during an endpoint deployment.</p>
    pub fn traffic_routing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::TrafficRoutingConfig> {
        self.traffic_routing_configuration.as_ref()
    }
    /// <p>Additional waiting time in seconds after the completion of an endpoint deployment
    /// before terminating the old endpoint fleet. Default is 0.</p>
    pub fn termination_wait_in_seconds(&self) -> std::option::Option<i32> {
        self.termination_wait_in_seconds
    }
    /// <p>Maximum execution timeout for the deployment. Note that the timeout value should be larger
    /// than the total waiting time specified in <code>TerminationWaitInSeconds</code> and <code>WaitIntervalInSeconds</code>.</p>
    pub fn maximum_execution_timeout_in_seconds(&self) -> std::option::Option<i32> {
        self.maximum_execution_timeout_in_seconds
    }
}
impl std::fmt::Debug for BlueGreenUpdatePolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BlueGreenUpdatePolicy");
        formatter.field(
            "traffic_routing_configuration",
            &self.traffic_routing_configuration,
        );
        formatter.field(
            "termination_wait_in_seconds",
            &self.termination_wait_in_seconds,
        );
        formatter.field(
            "maximum_execution_timeout_in_seconds",
            &self.maximum_execution_timeout_in_seconds,
        );
        formatter.finish()
    }
}
/// See [`BlueGreenUpdatePolicy`](crate::model::BlueGreenUpdatePolicy)
pub mod blue_green_update_policy {
    /// A builder for [`BlueGreenUpdatePolicy`](crate::model::BlueGreenUpdatePolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) traffic_routing_configuration:
            std::option::Option<crate::model::TrafficRoutingConfig>,
        pub(crate) termination_wait_in_seconds: std::option::Option<i32>,
        pub(crate) maximum_execution_timeout_in_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Defines the traffic routing strategy to shift traffic from the old fleet to the new fleet
        /// during an endpoint deployment.</p>
        pub fn traffic_routing_configuration(
            mut self,
            input: crate::model::TrafficRoutingConfig,
        ) -> Self {
            self.traffic_routing_configuration = Some(input);
            self
        }
        /// <p>Defines the traffic routing strategy to shift traffic from the old fleet to the new fleet
        /// during an endpoint deployment.</p>
        pub fn set_traffic_routing_configuration(
            mut self,
            input: std::option::Option<crate::model::TrafficRoutingConfig>,
        ) -> Self {
            self.traffic_routing_configuration = input;
            self
        }
        /// <p>Additional waiting time in seconds after the completion of an endpoint deployment
        /// before terminating the old endpoint fleet. Default is 0.</p>
        pub fn termination_wait_in_seconds(mut self, input: i32) -> Self {
            self.termination_wait_in_seconds = Some(input);
            self
        }
        /// <p>Additional waiting time in seconds after the completion of an endpoint deployment
        /// before terminating the old endpoint fleet. Default is 0.</p>
        pub fn set_termination_wait_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.termination_wait_in_seconds = input;
            self
        }
        /// <p>Maximum execution timeout for the deployment. Note that the timeout value should be larger
        /// than the total waiting time specified in <code>TerminationWaitInSeconds</code> and <code>WaitIntervalInSeconds</code>.</p>
        pub fn maximum_execution_timeout_in_seconds(mut self, input: i32) -> Self {
            self.maximum_execution_timeout_in_seconds = Some(input);
            self
        }
        /// <p>Maximum execution timeout for the deployment. Note that the timeout value should be larger
        /// than the total waiting time specified in <code>TerminationWaitInSeconds</code> and <code>WaitIntervalInSeconds</code>.</p>
        pub fn set_maximum_execution_timeout_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.maximum_execution_timeout_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`BlueGreenUpdatePolicy`](crate::model::BlueGreenUpdatePolicy)
        pub fn build(self) -> crate::model::BlueGreenUpdatePolicy {
            crate::model::BlueGreenUpdatePolicy {
                traffic_routing_configuration: self.traffic_routing_configuration,
                termination_wait_in_seconds: self.termination_wait_in_seconds,
                maximum_execution_timeout_in_seconds: self.maximum_execution_timeout_in_seconds,
            }
        }
    }
}
impl BlueGreenUpdatePolicy {
    /// Creates a new builder-style object to manufacture [`BlueGreenUpdatePolicy`](crate::model::BlueGreenUpdatePolicy)
    pub fn builder() -> crate::model::blue_green_update_policy::Builder {
        crate::model::blue_green_update_policy::Builder::default()
    }
}

/// <p>Defines the traffic routing strategy during an endpoint deployment to shift traffic from the
/// old fleet to the new fleet.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrafficRoutingConfig {
    /// <p>Traffic routing strategy type.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALL_AT_ONCE</code>: Endpoint traffic shifts to the new fleet
    /// in a single step.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CANARY</code>: Endpoint traffic shifts to the new fleet
    /// in two steps. The first step is the canary, which is a small portion of the traffic. The
    /// second step is the remainder of the traffic.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LINEAR</code>: Endpoint traffic shifts to the new fleet in
    /// n steps of a configurable size.
    /// </p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::TrafficRoutingConfigType>,
    /// <p>The waiting time (in seconds) between incremental steps to turn on traffic on the
    /// new endpoint fleet.</p>
    pub wait_interval_in_seconds: std::option::Option<i32>,
    /// <p>Batch size for the first step to turn on traffic on the new endpoint fleet. <code>Value</code> must be less than
    /// or equal to 50% of the variant's total instance count.</p>
    pub canary_size: std::option::Option<crate::model::CapacitySize>,
    /// <p>Batch size for each step to turn on traffic on the new endpoint fleet. <code>Value</code> must be
    /// 10-50% of the variant's total instance count.</p>
    pub linear_step_size: std::option::Option<crate::model::CapacitySize>,
}
impl TrafficRoutingConfig {
    /// <p>Traffic routing strategy type.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALL_AT_ONCE</code>: Endpoint traffic shifts to the new fleet
    /// in a single step.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CANARY</code>: Endpoint traffic shifts to the new fleet
    /// in two steps. The first step is the canary, which is a small portion of the traffic. The
    /// second step is the remainder of the traffic.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LINEAR</code>: Endpoint traffic shifts to the new fleet in
    /// n steps of a configurable size.
    /// </p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::TrafficRoutingConfigType> {
        self.r#type.as_ref()
    }
    /// <p>The waiting time (in seconds) between incremental steps to turn on traffic on the
    /// new endpoint fleet.</p>
    pub fn wait_interval_in_seconds(&self) -> std::option::Option<i32> {
        self.wait_interval_in_seconds
    }
    /// <p>Batch size for the first step to turn on traffic on the new endpoint fleet. <code>Value</code> must be less than
    /// or equal to 50% of the variant's total instance count.</p>
    pub fn canary_size(&self) -> std::option::Option<&crate::model::CapacitySize> {
        self.canary_size.as_ref()
    }
    /// <p>Batch size for each step to turn on traffic on the new endpoint fleet. <code>Value</code> must be
    /// 10-50% of the variant's total instance count.</p>
    pub fn linear_step_size(&self) -> std::option::Option<&crate::model::CapacitySize> {
        self.linear_step_size.as_ref()
    }
}
impl std::fmt::Debug for TrafficRoutingConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrafficRoutingConfig");
        formatter.field("r#type", &self.r#type);
        formatter.field("wait_interval_in_seconds", &self.wait_interval_in_seconds);
        formatter.field("canary_size", &self.canary_size);
        formatter.field("linear_step_size", &self.linear_step_size);
        formatter.finish()
    }
}
/// See [`TrafficRoutingConfig`](crate::model::TrafficRoutingConfig)
pub mod traffic_routing_config {
    /// A builder for [`TrafficRoutingConfig`](crate::model::TrafficRoutingConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::TrafficRoutingConfigType>,
        pub(crate) wait_interval_in_seconds: std::option::Option<i32>,
        pub(crate) canary_size: std::option::Option<crate::model::CapacitySize>,
        pub(crate) linear_step_size: std::option::Option<crate::model::CapacitySize>,
    }
    impl Builder {
        /// <p>Traffic routing strategy type.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALL_AT_ONCE</code>: Endpoint traffic shifts to the new fleet
        /// in a single step.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANARY</code>: Endpoint traffic shifts to the new fleet
        /// in two steps. The first step is the canary, which is a small portion of the traffic. The
        /// second step is the remainder of the traffic.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LINEAR</code>: Endpoint traffic shifts to the new fleet in
        /// n steps of a configurable size.
        /// </p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::TrafficRoutingConfigType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Traffic routing strategy type.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALL_AT_ONCE</code>: Endpoint traffic shifts to the new fleet
        /// in a single step.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CANARY</code>: Endpoint traffic shifts to the new fleet
        /// in two steps. The first step is the canary, which is a small portion of the traffic. The
        /// second step is the remainder of the traffic.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LINEAR</code>: Endpoint traffic shifts to the new fleet in
        /// n steps of a configurable size.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::TrafficRoutingConfigType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The waiting time (in seconds) between incremental steps to turn on traffic on the
        /// new endpoint fleet.</p>
        pub fn wait_interval_in_seconds(mut self, input: i32) -> Self {
            self.wait_interval_in_seconds = Some(input);
            self
        }
        /// <p>The waiting time (in seconds) between incremental steps to turn on traffic on the
        /// new endpoint fleet.</p>
        pub fn set_wait_interval_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.wait_interval_in_seconds = input;
            self
        }
        /// <p>Batch size for the first step to turn on traffic on the new endpoint fleet. <code>Value</code> must be less than
        /// or equal to 50% of the variant's total instance count.</p>
        pub fn canary_size(mut self, input: crate::model::CapacitySize) -> Self {
            self.canary_size = Some(input);
            self
        }
        /// <p>Batch size for the first step to turn on traffic on the new endpoint fleet. <code>Value</code> must be less than
        /// or equal to 50% of the variant's total instance count.</p>
        pub fn set_canary_size(
            mut self,
            input: std::option::Option<crate::model::CapacitySize>,
        ) -> Self {
            self.canary_size = input;
            self
        }
        /// <p>Batch size for each step to turn on traffic on the new endpoint fleet. <code>Value</code> must be
        /// 10-50% of the variant's total instance count.</p>
        pub fn linear_step_size(mut self, input: crate::model::CapacitySize) -> Self {
            self.linear_step_size = Some(input);
            self
        }
        /// <p>Batch size for each step to turn on traffic on the new endpoint fleet. <code>Value</code> must be
        /// 10-50% of the variant's total instance count.</p>
        pub fn set_linear_step_size(
            mut self,
            input: std::option::Option<crate::model::CapacitySize>,
        ) -> Self {
            self.linear_step_size = input;
            self
        }
        /// Consumes the builder and constructs a [`TrafficRoutingConfig`](crate::model::TrafficRoutingConfig)
        pub fn build(self) -> crate::model::TrafficRoutingConfig {
            crate::model::TrafficRoutingConfig {
                r#type: self.r#type,
                wait_interval_in_seconds: self.wait_interval_in_seconds,
                canary_size: self.canary_size,
                linear_step_size: self.linear_step_size,
            }
        }
    }
}
impl TrafficRoutingConfig {
    /// Creates a new builder-style object to manufacture [`TrafficRoutingConfig`](crate::model::TrafficRoutingConfig)
    pub fn builder() -> crate::model::traffic_routing_config::Builder {
        crate::model::traffic_routing_config::Builder::default()
    }
}

/// <p>Specifies the endpoint capacity to activate for production.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CapacitySize {
    /// <p>Specifies the endpoint capacity type.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>INSTANCE_COUNT</code>: The endpoint activates based on
    /// the number of instances.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CAPACITY_PERCENT</code>: The endpoint activates based on
    /// the specified percentage of capacity.</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::CapacitySizeType>,
    /// <p>Defines the capacity size, either as a number of instances or a capacity percentage.</p>
    pub value: std::option::Option<i32>,
}
impl CapacitySize {
    /// <p>Specifies the endpoint capacity type.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>INSTANCE_COUNT</code>: The endpoint activates based on
    /// the number of instances.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CAPACITY_PERCENT</code>: The endpoint activates based on
    /// the specified percentage of capacity.</p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::CapacitySizeType> {
        self.r#type.as_ref()
    }
    /// <p>Defines the capacity size, either as a number of instances or a capacity percentage.</p>
    pub fn value(&self) -> std::option::Option<i32> {
        self.value
    }
}
impl std::fmt::Debug for CapacitySize {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CapacitySize");
        formatter.field("r#type", &self.r#type);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`CapacitySize`](crate::model::CapacitySize)
pub mod capacity_size {
    /// A builder for [`CapacitySize`](crate::model::CapacitySize)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::CapacitySizeType>,
        pub(crate) value: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specifies the endpoint capacity type.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INSTANCE_COUNT</code>: The endpoint activates based on
        /// the number of instances.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CAPACITY_PERCENT</code>: The endpoint activates based on
        /// the specified percentage of capacity.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::CapacitySizeType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Specifies the endpoint capacity type.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>INSTANCE_COUNT</code>: The endpoint activates based on
        /// the number of instances.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CAPACITY_PERCENT</code>: The endpoint activates based on
        /// the specified percentage of capacity.</p>
        /// </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::CapacitySizeType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Defines the capacity size, either as a number of instances or a capacity percentage.</p>
        pub fn value(mut self, input: i32) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>Defines the capacity size, either as a number of instances or a capacity percentage.</p>
        pub fn set_value(mut self, input: std::option::Option<i32>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`CapacitySize`](crate::model::CapacitySize)
        pub fn build(self) -> crate::model::CapacitySize {
            crate::model::CapacitySize {
                r#type: self.r#type,
                value: self.value,
            }
        }
    }
}
impl CapacitySize {
    /// Creates a new builder-style object to manufacture [`CapacitySize`](crate::model::CapacitySize)
    pub fn builder() -> crate::model::capacity_size::Builder {
        crate::model::capacity_size::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CapacitySizeType {
    #[allow(missing_docs)] // documentation missing in model
    CapacityPercent,
    #[allow(missing_docs)] // documentation missing in model
    InstanceCount,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CapacitySizeType {
    fn from(s: &str) -> Self {
        match s {
            "CAPACITY_PERCENT" => CapacitySizeType::CapacityPercent,
            "INSTANCE_COUNT" => CapacitySizeType::InstanceCount,
            other => CapacitySizeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CapacitySizeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CapacitySizeType::from(s))
    }
}
impl CapacitySizeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CapacitySizeType::CapacityPercent => "CAPACITY_PERCENT",
            CapacitySizeType::InstanceCount => "INSTANCE_COUNT",
            CapacitySizeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CAPACITY_PERCENT", "INSTANCE_COUNT"]
    }
}
impl AsRef<str> for CapacitySizeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TrafficRoutingConfigType {
    #[allow(missing_docs)] // documentation missing in model
    AllAtOnce,
    #[allow(missing_docs)] // documentation missing in model
    Canary,
    #[allow(missing_docs)] // documentation missing in model
    Linear,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TrafficRoutingConfigType {
    fn from(s: &str) -> Self {
        match s {
            "ALL_AT_ONCE" => TrafficRoutingConfigType::AllAtOnce,
            "CANARY" => TrafficRoutingConfigType::Canary,
            "LINEAR" => TrafficRoutingConfigType::Linear,
            other => TrafficRoutingConfigType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TrafficRoutingConfigType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TrafficRoutingConfigType::from(s))
    }
}
impl TrafficRoutingConfigType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TrafficRoutingConfigType::AllAtOnce => "ALL_AT_ONCE",
            TrafficRoutingConfigType::Canary => "CANARY",
            TrafficRoutingConfigType::Linear => "LINEAR",
            TrafficRoutingConfigType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL_AT_ONCE", "CANARY", "LINEAR"]
    }
}
impl AsRef<str> for TrafficRoutingConfigType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies a production variant property type for an Endpoint.</p>
/// <p>If you are updating an endpoint with the <a>UpdateEndpointInput$RetainAllVariantProperties</a> option set to
/// <code>true</code>, the <code>VariantProperty</code> objects listed in <a>UpdateEndpointInput$ExcludeRetainedVariantProperties</a> override the
/// existing variant properties of the endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VariantProperty {
    /// <p>The type of variant property. The supported values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DesiredInstanceCount</code>: Overrides the existing variant instance
    /// counts using the <a>ProductionVariant$InitialInstanceCount</a> values
    /// in the <a>CreateEndpointConfigInput$ProductionVariants</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DesiredWeight</code>: Overrides the existing variant weights using the
    /// <a>ProductionVariant$InitialVariantWeight</a> values in the <a>CreateEndpointConfigInput$ProductionVariants</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DataCaptureConfig</code>: (Not currently supported.)</p>
    /// </li>
    /// </ul>
    pub variant_property_type: std::option::Option<crate::model::VariantPropertyType>,
}
impl VariantProperty {
    /// <p>The type of variant property. The supported values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DesiredInstanceCount</code>: Overrides the existing variant instance
    /// counts using the <a>ProductionVariant$InitialInstanceCount</a> values
    /// in the <a>CreateEndpointConfigInput$ProductionVariants</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DesiredWeight</code>: Overrides the existing variant weights using the
    /// <a>ProductionVariant$InitialVariantWeight</a> values in the <a>CreateEndpointConfigInput$ProductionVariants</a>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DataCaptureConfig</code>: (Not currently supported.)</p>
    /// </li>
    /// </ul>
    pub fn variant_property_type(&self) -> std::option::Option<&crate::model::VariantPropertyType> {
        self.variant_property_type.as_ref()
    }
}
impl std::fmt::Debug for VariantProperty {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VariantProperty");
        formatter.field("variant_property_type", &self.variant_property_type);
        formatter.finish()
    }
}
/// See [`VariantProperty`](crate::model::VariantProperty)
pub mod variant_property {
    /// A builder for [`VariantProperty`](crate::model::VariantProperty)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) variant_property_type: std::option::Option<crate::model::VariantPropertyType>,
    }
    impl Builder {
        /// <p>The type of variant property. The supported values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DesiredInstanceCount</code>: Overrides the existing variant instance
        /// counts using the <a>ProductionVariant$InitialInstanceCount</a> values
        /// in the <a>CreateEndpointConfigInput$ProductionVariants</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DesiredWeight</code>: Overrides the existing variant weights using the
        /// <a>ProductionVariant$InitialVariantWeight</a> values in the <a>CreateEndpointConfigInput$ProductionVariants</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DataCaptureConfig</code>: (Not currently supported.)</p>
        /// </li>
        /// </ul>
        pub fn variant_property_type(mut self, input: crate::model::VariantPropertyType) -> Self {
            self.variant_property_type = Some(input);
            self
        }
        /// <p>The type of variant property. The supported values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DesiredInstanceCount</code>: Overrides the existing variant instance
        /// counts using the <a>ProductionVariant$InitialInstanceCount</a> values
        /// in the <a>CreateEndpointConfigInput$ProductionVariants</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DesiredWeight</code>: Overrides the existing variant weights using the
        /// <a>ProductionVariant$InitialVariantWeight</a> values in the <a>CreateEndpointConfigInput$ProductionVariants</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DataCaptureConfig</code>: (Not currently supported.)</p>
        /// </li>
        /// </ul>
        pub fn set_variant_property_type(
            mut self,
            input: std::option::Option<crate::model::VariantPropertyType>,
        ) -> Self {
            self.variant_property_type = input;
            self
        }
        /// Consumes the builder and constructs a [`VariantProperty`](crate::model::VariantProperty)
        pub fn build(self) -> crate::model::VariantProperty {
            crate::model::VariantProperty {
                variant_property_type: self.variant_property_type,
            }
        }
    }
}
impl VariantProperty {
    /// Creates a new builder-style object to manufacture [`VariantProperty`](crate::model::VariantProperty)
    pub fn builder() -> crate::model::variant_property::Builder {
        crate::model::variant_property::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VariantPropertyType {
    #[allow(missing_docs)] // documentation missing in model
    DataCaptureConfig,
    #[allow(missing_docs)] // documentation missing in model
    DesiredInstanceCount,
    #[allow(missing_docs)] // documentation missing in model
    DesiredWeight,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VariantPropertyType {
    fn from(s: &str) -> Self {
        match s {
            "DataCaptureConfig" => VariantPropertyType::DataCaptureConfig,
            "DesiredInstanceCount" => VariantPropertyType::DesiredInstanceCount,
            "DesiredWeight" => VariantPropertyType::DesiredWeight,
            other => VariantPropertyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VariantPropertyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VariantPropertyType::from(s))
    }
}
impl VariantPropertyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VariantPropertyType::DataCaptureConfig => "DataCaptureConfig",
            VariantPropertyType::DesiredInstanceCount => "DesiredInstanceCount",
            VariantPropertyType::DesiredWeight => "DesiredWeight",
            VariantPropertyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DataCaptureConfig", "DesiredInstanceCount", "DesiredWeight"]
    }
}
impl AsRef<str> for VariantPropertyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A collection of <code>Domain</code> configuration settings to update.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainSettingsForUpdate {
    /// <p>A collection of <code>RStudioServerPro</code> Domain-level app settings to update.</p>
    pub r_studio_server_pro_domain_settings_for_update:
        std::option::Option<crate::model::RStudioServerProDomainSettingsForUpdate>,
}
impl DomainSettingsForUpdate {
    /// <p>A collection of <code>RStudioServerPro</code> Domain-level app settings to update.</p>
    pub fn r_studio_server_pro_domain_settings_for_update(
        &self,
    ) -> std::option::Option<&crate::model::RStudioServerProDomainSettingsForUpdate> {
        self.r_studio_server_pro_domain_settings_for_update.as_ref()
    }
}
impl std::fmt::Debug for DomainSettingsForUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainSettingsForUpdate");
        formatter.field(
            "r_studio_server_pro_domain_settings_for_update",
            &self.r_studio_server_pro_domain_settings_for_update,
        );
        formatter.finish()
    }
}
/// See [`DomainSettingsForUpdate`](crate::model::DomainSettingsForUpdate)
pub mod domain_settings_for_update {
    /// A builder for [`DomainSettingsForUpdate`](crate::model::DomainSettingsForUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r_studio_server_pro_domain_settings_for_update:
            std::option::Option<crate::model::RStudioServerProDomainSettingsForUpdate>,
    }
    impl Builder {
        /// <p>A collection of <code>RStudioServerPro</code> Domain-level app settings to update.</p>
        pub fn r_studio_server_pro_domain_settings_for_update(
            mut self,
            input: crate::model::RStudioServerProDomainSettingsForUpdate,
        ) -> Self {
            self.r_studio_server_pro_domain_settings_for_update = Some(input);
            self
        }
        /// <p>A collection of <code>RStudioServerPro</code> Domain-level app settings to update.</p>
        pub fn set_r_studio_server_pro_domain_settings_for_update(
            mut self,
            input: std::option::Option<crate::model::RStudioServerProDomainSettingsForUpdate>,
        ) -> Self {
            self.r_studio_server_pro_domain_settings_for_update = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainSettingsForUpdate`](crate::model::DomainSettingsForUpdate)
        pub fn build(self) -> crate::model::DomainSettingsForUpdate {
            crate::model::DomainSettingsForUpdate {
                r_studio_server_pro_domain_settings_for_update: self
                    .r_studio_server_pro_domain_settings_for_update,
            }
        }
    }
}
impl DomainSettingsForUpdate {
    /// Creates a new builder-style object to manufacture [`DomainSettingsForUpdate`](crate::model::DomainSettingsForUpdate)
    pub fn builder() -> crate::model::domain_settings_for_update::Builder {
        crate::model::domain_settings_for_update::Builder::default()
    }
}

/// <p>A collection of settings that update the current configuration for the <code>RStudioServerPro</code> Domain-level app.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RStudioServerProDomainSettingsForUpdate {
    /// <p>The execution role for the <code>RStudioServerPro</code> Domain-level app.</p>
    pub domain_execution_role_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the ARN's of a SageMaker image and SageMaker image version, and the instance type that
    /// the version runs on.</p>
    pub default_resource_spec: std::option::Option<crate::model::ResourceSpec>,
}
impl RStudioServerProDomainSettingsForUpdate {
    /// <p>The execution role for the <code>RStudioServerPro</code> Domain-level app.</p>
    pub fn domain_execution_role_arn(&self) -> std::option::Option<&str> {
        self.domain_execution_role_arn.as_deref()
    }
    /// <p>Specifies the ARN's of a SageMaker image and SageMaker image version, and the instance type that
    /// the version runs on.</p>
    pub fn default_resource_spec(&self) -> std::option::Option<&crate::model::ResourceSpec> {
        self.default_resource_spec.as_ref()
    }
}
impl std::fmt::Debug for RStudioServerProDomainSettingsForUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RStudioServerProDomainSettingsForUpdate");
        formatter.field("domain_execution_role_arn", &self.domain_execution_role_arn);
        formatter.field("default_resource_spec", &self.default_resource_spec);
        formatter.finish()
    }
}
/// See [`RStudioServerProDomainSettingsForUpdate`](crate::model::RStudioServerProDomainSettingsForUpdate)
pub mod r_studio_server_pro_domain_settings_for_update {
    /// A builder for [`RStudioServerProDomainSettingsForUpdate`](crate::model::RStudioServerProDomainSettingsForUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_execution_role_arn: std::option::Option<std::string::String>,
        pub(crate) default_resource_spec: std::option::Option<crate::model::ResourceSpec>,
    }
    impl Builder {
        /// <p>The execution role for the <code>RStudioServerPro</code> Domain-level app.</p>
        pub fn domain_execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_execution_role_arn = Some(input.into());
            self
        }
        /// <p>The execution role for the <code>RStudioServerPro</code> Domain-level app.</p>
        pub fn set_domain_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.domain_execution_role_arn = input;
            self
        }
        /// <p>Specifies the ARN's of a SageMaker image and SageMaker image version, and the instance type that
        /// the version runs on.</p>
        pub fn default_resource_spec(mut self, input: crate::model::ResourceSpec) -> Self {
            self.default_resource_spec = Some(input);
            self
        }
        /// <p>Specifies the ARN's of a SageMaker image and SageMaker image version, and the instance type that
        /// the version runs on.</p>
        pub fn set_default_resource_spec(
            mut self,
            input: std::option::Option<crate::model::ResourceSpec>,
        ) -> Self {
            self.default_resource_spec = input;
            self
        }
        /// Consumes the builder and constructs a [`RStudioServerProDomainSettingsForUpdate`](crate::model::RStudioServerProDomainSettingsForUpdate)
        pub fn build(self) -> crate::model::RStudioServerProDomainSettingsForUpdate {
            crate::model::RStudioServerProDomainSettingsForUpdate {
                domain_execution_role_arn: self.domain_execution_role_arn,
                default_resource_spec: self.default_resource_spec,
            }
        }
    }
}
impl RStudioServerProDomainSettingsForUpdate {
    /// Creates a new builder-style object to manufacture [`RStudioServerProDomainSettingsForUpdate`](crate::model::RStudioServerProDomainSettingsForUpdate)
    pub fn builder() -> crate::model::r_studio_server_pro_domain_settings_for_update::Builder {
        crate::model::r_studio_server_pro_domain_settings_for_update::Builder::default()
    }
}

/// <p>Information of a particular device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Device {
    /// <p>The name of the device.</p>
    pub device_name: std::option::Option<std::string::String>,
    /// <p>Description of the device.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Amazon Web Services Internet of Things (IoT) object name.</p>
    pub iot_thing_name: std::option::Option<std::string::String>,
}
impl Device {
    /// <p>The name of the device.</p>
    pub fn device_name(&self) -> std::option::Option<&str> {
        self.device_name.as_deref()
    }
    /// <p>Description of the device.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Amazon Web Services Internet of Things (IoT) object name.</p>
    pub fn iot_thing_name(&self) -> std::option::Option<&str> {
        self.iot_thing_name.as_deref()
    }
}
impl std::fmt::Debug for Device {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Device");
        formatter.field("device_name", &self.device_name);
        formatter.field("description", &self.description);
        formatter.field("iot_thing_name", &self.iot_thing_name);
        formatter.finish()
    }
}
/// See [`Device`](crate::model::Device)
pub mod device {
    /// A builder for [`Device`](crate::model::Device)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) iot_thing_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the device.</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>The name of the device.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>Description of the device.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Description of the device.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Amazon Web Services Internet of Things (IoT) object name.</p>
        pub fn iot_thing_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.iot_thing_name = Some(input.into());
            self
        }
        /// <p>Amazon Web Services Internet of Things (IoT) object name.</p>
        pub fn set_iot_thing_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iot_thing_name = input;
            self
        }
        /// Consumes the builder and constructs a [`Device`](crate::model::Device)
        pub fn build(self) -> crate::model::Device {
            crate::model::Device {
                device_name: self.device_name,
                description: self.description,
                iot_thing_name: self.iot_thing_name,
            }
        }
    }
}
impl Device {
    /// Creates a new builder-style object to manufacture [`Device`](crate::model::Device)
    pub fn builder() -> crate::model::device::Builder {
        crate::model::device::Builder::default()
    }
}

/// <p>The output configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EdgeOutputConfig {
    /// <p>The Amazon Simple Storage (S3) bucker URI.</p>
    pub s3_output_location: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data on the storage volume after compilation job.
    /// If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The deployment type SageMaker Edge Manager will create.
    /// Currently only supports Amazon Web Services IoT Greengrass Version 2 components.</p>
    pub preset_deployment_type: std::option::Option<crate::model::EdgePresetDeploymentType>,
    /// <p>The configuration used to create deployment artifacts.
    /// Specify configuration options with a JSON string. The available configuration options for each type are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ComponentName</code> (optional) - Name of the GreenGrass V2 component. If not specified,
    /// the default name generated consists of "SagemakerEdgeManager" and the name of your SageMaker Edge Manager
    /// packaging job.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ComponentDescription</code> (optional) - Description of the component.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ComponentVersion</code> (optional) - The version of the component.</p>
    /// <note>
    /// <p>Amazon Web Services IoT Greengrass uses semantic versions for components. Semantic versions follow a<i>
    /// major.minor.patch</i> number system. For example, version 1.0.0 represents the first
    /// major release for a component. For more information, see the <a href="https://semver.org/">semantic version specification</a>.</p>
    /// </note>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PlatformOS</code> (optional) - The name of the operating system for the platform.
    /// Supported platforms include Windows and Linux.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PlatformArchitecture</code> (optional) - The processor architecture for the platform. </p>
    /// <p>Supported architectures Windows include: Windows32_x86, Windows64_x64.</p>
    /// <p>Supported architectures for Linux include: Linux x86_64, Linux ARMV8.</p>
    /// </li>
    /// </ul>
    pub preset_deployment_config: std::option::Option<std::string::String>,
}
impl EdgeOutputConfig {
    /// <p>The Amazon Simple Storage (S3) bucker URI.</p>
    pub fn s3_output_location(&self) -> std::option::Option<&str> {
        self.s3_output_location.as_deref()
    }
    /// <p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data on the storage volume after compilation job.
    /// If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The deployment type SageMaker Edge Manager will create.
    /// Currently only supports Amazon Web Services IoT Greengrass Version 2 components.</p>
    pub fn preset_deployment_type(
        &self,
    ) -> std::option::Option<&crate::model::EdgePresetDeploymentType> {
        self.preset_deployment_type.as_ref()
    }
    /// <p>The configuration used to create deployment artifacts.
    /// Specify configuration options with a JSON string. The available configuration options for each type are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ComponentName</code> (optional) - Name of the GreenGrass V2 component. If not specified,
    /// the default name generated consists of "SagemakerEdgeManager" and the name of your SageMaker Edge Manager
    /// packaging job.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ComponentDescription</code> (optional) - Description of the component.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ComponentVersion</code> (optional) - The version of the component.</p>
    /// <note>
    /// <p>Amazon Web Services IoT Greengrass uses semantic versions for components. Semantic versions follow a<i>
    /// major.minor.patch</i> number system. For example, version 1.0.0 represents the first
    /// major release for a component. For more information, see the <a href="https://semver.org/">semantic version specification</a>.</p>
    /// </note>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PlatformOS</code> (optional) - The name of the operating system for the platform.
    /// Supported platforms include Windows and Linux.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PlatformArchitecture</code> (optional) - The processor architecture for the platform. </p>
    /// <p>Supported architectures Windows include: Windows32_x86, Windows64_x64.</p>
    /// <p>Supported architectures for Linux include: Linux x86_64, Linux ARMV8.</p>
    /// </li>
    /// </ul>
    pub fn preset_deployment_config(&self) -> std::option::Option<&str> {
        self.preset_deployment_config.as_deref()
    }
}
impl std::fmt::Debug for EdgeOutputConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EdgeOutputConfig");
        formatter.field("s3_output_location", &self.s3_output_location);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("preset_deployment_type", &self.preset_deployment_type);
        formatter.field("preset_deployment_config", &self.preset_deployment_config);
        formatter.finish()
    }
}
/// See [`EdgeOutputConfig`](crate::model::EdgeOutputConfig)
pub mod edge_output_config {
    /// A builder for [`EdgeOutputConfig`](crate::model::EdgeOutputConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_output_location: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) preset_deployment_type:
            std::option::Option<crate::model::EdgePresetDeploymentType>,
        pub(crate) preset_deployment_config: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Simple Storage (S3) bucker URI.</p>
        pub fn s3_output_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_output_location = Some(input.into());
            self
        }
        /// <p>The Amazon Simple Storage (S3) bucker URI.</p>
        pub fn set_s3_output_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_output_location = input;
            self
        }
        /// <p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data on the storage volume after compilation job.
        /// If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data on the storage volume after compilation job.
        /// If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The deployment type SageMaker Edge Manager will create.
        /// Currently only supports Amazon Web Services IoT Greengrass Version 2 components.</p>
        pub fn preset_deployment_type(
            mut self,
            input: crate::model::EdgePresetDeploymentType,
        ) -> Self {
            self.preset_deployment_type = Some(input);
            self
        }
        /// <p>The deployment type SageMaker Edge Manager will create.
        /// Currently only supports Amazon Web Services IoT Greengrass Version 2 components.</p>
        pub fn set_preset_deployment_type(
            mut self,
            input: std::option::Option<crate::model::EdgePresetDeploymentType>,
        ) -> Self {
            self.preset_deployment_type = input;
            self
        }
        /// <p>The configuration used to create deployment artifacts.
        /// Specify configuration options with a JSON string. The available configuration options for each type are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ComponentName</code> (optional) - Name of the GreenGrass V2 component. If not specified,
        /// the default name generated consists of "SagemakerEdgeManager" and the name of your SageMaker Edge Manager
        /// packaging job.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ComponentDescription</code> (optional) - Description of the component.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ComponentVersion</code> (optional) - The version of the component.</p>
        /// <note>
        /// <p>Amazon Web Services IoT Greengrass uses semantic versions for components. Semantic versions follow a<i>
        /// major.minor.patch</i> number system. For example, version 1.0.0 represents the first
        /// major release for a component. For more information, see the <a href="https://semver.org/">semantic version specification</a>.</p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PlatformOS</code> (optional) - The name of the operating system for the platform.
        /// Supported platforms include Windows and Linux.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PlatformArchitecture</code> (optional) - The processor architecture for the platform. </p>
        /// <p>Supported architectures Windows include: Windows32_x86, Windows64_x64.</p>
        /// <p>Supported architectures for Linux include: Linux x86_64, Linux ARMV8.</p>
        /// </li>
        /// </ul>
        pub fn preset_deployment_config(mut self, input: impl Into<std::string::String>) -> Self {
            self.preset_deployment_config = Some(input.into());
            self
        }
        /// <p>The configuration used to create deployment artifacts.
        /// Specify configuration options with a JSON string. The available configuration options for each type are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ComponentName</code> (optional) - Name of the GreenGrass V2 component. If not specified,
        /// the default name generated consists of "SagemakerEdgeManager" and the name of your SageMaker Edge Manager
        /// packaging job.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ComponentDescription</code> (optional) - Description of the component.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ComponentVersion</code> (optional) - The version of the component.</p>
        /// <note>
        /// <p>Amazon Web Services IoT Greengrass uses semantic versions for components. Semantic versions follow a<i>
        /// major.minor.patch</i> number system. For example, version 1.0.0 represents the first
        /// major release for a component. For more information, see the <a href="https://semver.org/">semantic version specification</a>.</p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PlatformOS</code> (optional) - The name of the operating system for the platform.
        /// Supported platforms include Windows and Linux.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PlatformArchitecture</code> (optional) - The processor architecture for the platform. </p>
        /// <p>Supported architectures Windows include: Windows32_x86, Windows64_x64.</p>
        /// <p>Supported architectures for Linux include: Linux x86_64, Linux ARMV8.</p>
        /// </li>
        /// </ul>
        pub fn set_preset_deployment_config(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preset_deployment_config = input;
            self
        }
        /// Consumes the builder and constructs a [`EdgeOutputConfig`](crate::model::EdgeOutputConfig)
        pub fn build(self) -> crate::model::EdgeOutputConfig {
            crate::model::EdgeOutputConfig {
                s3_output_location: self.s3_output_location,
                kms_key_id: self.kms_key_id,
                preset_deployment_type: self.preset_deployment_type,
                preset_deployment_config: self.preset_deployment_config,
            }
        }
    }
}
impl EdgeOutputConfig {
    /// Creates a new builder-style object to manufacture [`EdgeOutputConfig`](crate::model::EdgeOutputConfig)
    pub fn builder() -> crate::model::edge_output_config::Builder {
        crate::model::edge_output_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EdgePresetDeploymentType {
    #[allow(missing_docs)] // documentation missing in model
    GreengrassV2Component,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EdgePresetDeploymentType {
    fn from(s: &str) -> Self {
        match s {
            "GreengrassV2Component" => EdgePresetDeploymentType::GreengrassV2Component,
            other => EdgePresetDeploymentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EdgePresetDeploymentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EdgePresetDeploymentType::from(s))
    }
}
impl EdgePresetDeploymentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EdgePresetDeploymentType::GreengrassV2Component => "GreengrassV2Component",
            EdgePresetDeploymentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GreengrassV2Component"]
    }
}
impl AsRef<str> for EdgePresetDeploymentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies configuration details for a Git repository when the repository is
/// updated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GitConfigForUpdate {
    /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret that contains the
    /// credentials used to access the git repository. The secret must have a staging label of
    /// <code>AWSCURRENT</code> and must be in the following format:</p>
    /// <p>
    /// <code>{"username": <i>UserName</i>, "password":
    /// <i>Password</i>}</code>
    /// </p>
    pub secret_arn: std::option::Option<std::string::String>,
}
impl GitConfigForUpdate {
    /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret that contains the
    /// credentials used to access the git repository. The secret must have a staging label of
    /// <code>AWSCURRENT</code> and must be in the following format:</p>
    /// <p>
    /// <code>{"username": <i>UserName</i>, "password":
    /// <i>Password</i>}</code>
    /// </p>
    pub fn secret_arn(&self) -> std::option::Option<&str> {
        self.secret_arn.as_deref()
    }
}
impl std::fmt::Debug for GitConfigForUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GitConfigForUpdate");
        formatter.field("secret_arn", &self.secret_arn);
        formatter.finish()
    }
}
/// See [`GitConfigForUpdate`](crate::model::GitConfigForUpdate)
pub mod git_config_for_update {
    /// A builder for [`GitConfigForUpdate`](crate::model::GitConfigForUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) secret_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret that contains the
        /// credentials used to access the git repository. The secret must have a staging label of
        /// <code>AWSCURRENT</code> and must be in the following format:</p>
        /// <p>
        /// <code>{"username": <i>UserName</i>, "password":
        /// <i>Password</i>}</code>
        /// </p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret that contains the
        /// credentials used to access the git repository. The secret must have a staging label of
        /// <code>AWSCURRENT</code> and must be in the following format:</p>
        /// <p>
        /// <code>{"username": <i>UserName</i>, "password":
        /// <i>Password</i>}</code>
        /// </p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GitConfigForUpdate`](crate::model::GitConfigForUpdate)
        pub fn build(self) -> crate::model::GitConfigForUpdate {
            crate::model::GitConfigForUpdate {
                secret_arn: self.secret_arn,
            }
        }
    }
}
impl GitConfigForUpdate {
    /// Creates a new builder-style object to manufacture [`GitConfigForUpdate`](crate::model::GitConfigForUpdate)
    pub fn builder() -> crate::model::git_config_for_update::Builder {
        crate::model::git_config_for_update::Builder::default()
    }
}

/// <p>The configuration for the file system and kernels in a SageMaker image running as a
/// KernelGateway app.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KernelGatewayImageConfig {
    /// <p>The specification of the Jupyter kernels in the image.</p>
    pub kernel_specs: std::option::Option<std::vec::Vec<crate::model::KernelSpec>>,
    /// <p>The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.</p>
    pub file_system_config: std::option::Option<crate::model::FileSystemConfig>,
}
impl KernelGatewayImageConfig {
    /// <p>The specification of the Jupyter kernels in the image.</p>
    pub fn kernel_specs(&self) -> std::option::Option<&[crate::model::KernelSpec]> {
        self.kernel_specs.as_deref()
    }
    /// <p>The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.</p>
    pub fn file_system_config(&self) -> std::option::Option<&crate::model::FileSystemConfig> {
        self.file_system_config.as_ref()
    }
}
impl std::fmt::Debug for KernelGatewayImageConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KernelGatewayImageConfig");
        formatter.field("kernel_specs", &self.kernel_specs);
        formatter.field("file_system_config", &self.file_system_config);
        formatter.finish()
    }
}
/// See [`KernelGatewayImageConfig`](crate::model::KernelGatewayImageConfig)
pub mod kernel_gateway_image_config {
    /// A builder for [`KernelGatewayImageConfig`](crate::model::KernelGatewayImageConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) kernel_specs: std::option::Option<std::vec::Vec<crate::model::KernelSpec>>,
        pub(crate) file_system_config: std::option::Option<crate::model::FileSystemConfig>,
    }
    impl Builder {
        /// Appends an item to `kernel_specs`.
        ///
        /// To override the contents of this collection use [`set_kernel_specs`](Self::set_kernel_specs).
        ///
        /// <p>The specification of the Jupyter kernels in the image.</p>
        pub fn kernel_specs(mut self, input: impl Into<crate::model::KernelSpec>) -> Self {
            let mut v = self.kernel_specs.unwrap_or_default();
            v.push(input.into());
            self.kernel_specs = Some(v);
            self
        }
        /// <p>The specification of the Jupyter kernels in the image.</p>
        pub fn set_kernel_specs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KernelSpec>>,
        ) -> Self {
            self.kernel_specs = input;
            self
        }
        /// <p>The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.</p>
        pub fn file_system_config(mut self, input: crate::model::FileSystemConfig) -> Self {
            self.file_system_config = Some(input);
            self
        }
        /// <p>The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.</p>
        pub fn set_file_system_config(
            mut self,
            input: std::option::Option<crate::model::FileSystemConfig>,
        ) -> Self {
            self.file_system_config = input;
            self
        }
        /// Consumes the builder and constructs a [`KernelGatewayImageConfig`](crate::model::KernelGatewayImageConfig)
        pub fn build(self) -> crate::model::KernelGatewayImageConfig {
            crate::model::KernelGatewayImageConfig {
                kernel_specs: self.kernel_specs,
                file_system_config: self.file_system_config,
            }
        }
    }
}
impl KernelGatewayImageConfig {
    /// Creates a new builder-style object to manufacture [`KernelGatewayImageConfig`](crate::model::KernelGatewayImageConfig)
    pub fn builder() -> crate::model::kernel_gateway_image_config::Builder {
        crate::model::kernel_gateway_image_config::Builder::default()
    }
}

/// <p>The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FileSystemConfig {
    /// <p>The path within the image to mount the user's EFS home directory. The directory
    /// should be empty. If not specified, defaults to <i>/home/sagemaker-user</i>.</p>
    pub mount_path: std::option::Option<std::string::String>,
    /// <p>The default POSIX user ID (UID). If not specified, defaults to <code>1000</code>.</p>
    pub default_uid: std::option::Option<i32>,
    /// <p>The default POSIX group ID (GID). If not specified, defaults to <code>100</code>.</p>
    pub default_gid: std::option::Option<i32>,
}
impl FileSystemConfig {
    /// <p>The path within the image to mount the user's EFS home directory. The directory
    /// should be empty. If not specified, defaults to <i>/home/sagemaker-user</i>.</p>
    pub fn mount_path(&self) -> std::option::Option<&str> {
        self.mount_path.as_deref()
    }
    /// <p>The default POSIX user ID (UID). If not specified, defaults to <code>1000</code>.</p>
    pub fn default_uid(&self) -> std::option::Option<i32> {
        self.default_uid
    }
    /// <p>The default POSIX group ID (GID). If not specified, defaults to <code>100</code>.</p>
    pub fn default_gid(&self) -> std::option::Option<i32> {
        self.default_gid
    }
}
impl std::fmt::Debug for FileSystemConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FileSystemConfig");
        formatter.field("mount_path", &self.mount_path);
        formatter.field("default_uid", &self.default_uid);
        formatter.field("default_gid", &self.default_gid);
        formatter.finish()
    }
}
/// See [`FileSystemConfig`](crate::model::FileSystemConfig)
pub mod file_system_config {
    /// A builder for [`FileSystemConfig`](crate::model::FileSystemConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mount_path: std::option::Option<std::string::String>,
        pub(crate) default_uid: std::option::Option<i32>,
        pub(crate) default_gid: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The path within the image to mount the user's EFS home directory. The directory
        /// should be empty. If not specified, defaults to <i>/home/sagemaker-user</i>.</p>
        pub fn mount_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.mount_path = Some(input.into());
            self
        }
        /// <p>The path within the image to mount the user's EFS home directory. The directory
        /// should be empty. If not specified, defaults to <i>/home/sagemaker-user</i>.</p>
        pub fn set_mount_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mount_path = input;
            self
        }
        /// <p>The default POSIX user ID (UID). If not specified, defaults to <code>1000</code>.</p>
        pub fn default_uid(mut self, input: i32) -> Self {
            self.default_uid = Some(input);
            self
        }
        /// <p>The default POSIX user ID (UID). If not specified, defaults to <code>1000</code>.</p>
        pub fn set_default_uid(mut self, input: std::option::Option<i32>) -> Self {
            self.default_uid = input;
            self
        }
        /// <p>The default POSIX group ID (GID). If not specified, defaults to <code>100</code>.</p>
        pub fn default_gid(mut self, input: i32) -> Self {
            self.default_gid = Some(input);
            self
        }
        /// <p>The default POSIX group ID (GID). If not specified, defaults to <code>100</code>.</p>
        pub fn set_default_gid(mut self, input: std::option::Option<i32>) -> Self {
            self.default_gid = input;
            self
        }
        /// Consumes the builder and constructs a [`FileSystemConfig`](crate::model::FileSystemConfig)
        pub fn build(self) -> crate::model::FileSystemConfig {
            crate::model::FileSystemConfig {
                mount_path: self.mount_path,
                default_uid: self.default_uid,
                default_gid: self.default_gid,
            }
        }
    }
}
impl FileSystemConfig {
    /// Creates a new builder-style object to manufacture [`FileSystemConfig`](crate::model::FileSystemConfig)
    pub fn builder() -> crate::model::file_system_config::Builder {
        crate::model::file_system_config::Builder::default()
    }
}

/// <p>The specification of a Jupyter kernel.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KernelSpec {
    /// <p>The name of the Jupyter kernel in the image. This value is case sensitive.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The display name of the kernel.</p>
    pub display_name: std::option::Option<std::string::String>,
}
impl KernelSpec {
    /// <p>The name of the Jupyter kernel in the image. This value is case sensitive.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The display name of the kernel.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
}
impl std::fmt::Debug for KernelSpec {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KernelSpec");
        formatter.field("name", &self.name);
        formatter.field("display_name", &self.display_name);
        formatter.finish()
    }
}
/// See [`KernelSpec`](crate::model::KernelSpec)
pub mod kernel_spec {
    /// A builder for [`KernelSpec`](crate::model::KernelSpec)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Jupyter kernel in the image. This value is case sensitive.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Jupyter kernel in the image. This value is case sensitive.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The display name of the kernel.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The display name of the kernel.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// Consumes the builder and constructs a [`KernelSpec`](crate::model::KernelSpec)
        pub fn build(self) -> crate::model::KernelSpec {
            crate::model::KernelSpec {
                name: self.name,
                display_name: self.display_name,
            }
        }
    }
}
impl KernelSpec {
    /// Creates a new builder-style object to manufacture [`KernelSpec`](crate::model::KernelSpec)
    pub fn builder() -> crate::model::kernel_spec::Builder {
        crate::model::kernel_spec::Builder::default()
    }
}

/// _Note: `ActionStatus::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ActionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ActionStatus {
    fn from(s: &str) -> Self {
        match s {
            "Completed" => ActionStatus::Completed,
            "Failed" => ActionStatus::Failed,
            "InProgress" => ActionStatus::InProgress,
            "Stopped" => ActionStatus::Stopped,
            "Stopping" => ActionStatus::Stopping,
            "Unknown" => ActionStatus::UnknownValue,
            other => ActionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ActionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ActionStatus::from(s))
    }
}
impl ActionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ActionStatus::Completed => "Completed",
            ActionStatus::Failed => "Failed",
            ActionStatus::InProgress => "InProgress",
            ActionStatus::Stopped => "Stopped",
            ActionStatus::Stopping => "Stopping",
            ActionStatus::UnknownValue => "Unknown",
            ActionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Completed",
            "Failed",
            "InProgress",
            "Stopped",
            "Stopping",
            "Unknown",
        ]
    }
}
impl AsRef<str> for ActionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Assigns a value to a named Pipeline parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Parameter {
    /// <p>The name of the parameter to assign a value to. This parameter name must match a named parameter in the pipeline definition.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The literal value for the parameter.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Parameter {
    /// <p>The name of the parameter to assign a value to. This parameter name must match a named parameter in the pipeline definition.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The literal value for the parameter.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Parameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Parameter");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Parameter`](crate::model::Parameter)
pub mod parameter {
    /// A builder for [`Parameter`](crate::model::Parameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the parameter to assign a value to. This parameter name must match a named parameter in the pipeline definition.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the parameter to assign a value to. This parameter name must match a named parameter in the pipeline definition.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The literal value for the parameter.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The literal value for the parameter.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Parameter`](crate::model::Parameter)
        pub fn build(self) -> crate::model::Parameter {
            crate::model::Parameter {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl Parameter {
    /// Creates a new builder-style object to manufacture [`Parameter`](crate::model::Parameter)
    pub fn builder() -> crate::model::parameter::Builder {
        crate::model::parameter::Builder::default()
    }
}

/// <p>An output parameter of a pipeline step.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutputParameter {
    /// <p>The name of the output parameter.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value of the output parameter.</p>
    pub value: std::option::Option<std::string::String>,
}
impl OutputParameter {
    /// <p>The name of the output parameter.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value of the output parameter.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for OutputParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutputParameter");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`OutputParameter`](crate::model::OutputParameter)
pub mod output_parameter {
    /// A builder for [`OutputParameter`](crate::model::OutputParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the output parameter.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the output parameter.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of the output parameter.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the output parameter.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`OutputParameter`](crate::model::OutputParameter)
        pub fn build(self) -> crate::model::OutputParameter {
            crate::model::OutputParameter {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl OutputParameter {
    /// Creates a new builder-style object to manufacture [`OutputParameter`](crate::model::OutputParameter)
    pub fn builder() -> crate::model::output_parameter::Builder {
        crate::model::output_parameter::Builder::default()
    }
}

/// <p>A single resource returned as part of the <a>Search</a> API response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchRecord {
    /// <p>The properties of a training job.</p>
    pub training_job: std::option::Option<crate::model::TrainingJob>,
    /// <p>The properties of an experiment.</p>
    pub experiment: std::option::Option<crate::model::Experiment>,
    /// <p>The properties of a trial.</p>
    pub trial: std::option::Option<crate::model::Trial>,
    /// <p>The properties of a trial component.</p>
    pub trial_component: std::option::Option<crate::model::TrialComponent>,
    /// <p>A hosted endpoint for real-time inference.</p>
    pub endpoint: std::option::Option<crate::model::Endpoint>,
    /// <p>A versioned model that can be deployed for SageMaker inference.</p>
    pub model_package: std::option::Option<crate::model::ModelPackage>,
    /// <p>A group of versioned models in the model registry.</p>
    pub model_package_group: std::option::Option<crate::model::ModelPackageGroup>,
    /// <p>A SageMaker Model Building Pipeline instance.</p>
    pub pipeline: std::option::Option<crate::model::Pipeline>,
    /// <p>An execution of a pipeline.</p>
    pub pipeline_execution: std::option::Option<crate::model::PipelineExecution>,
    /// <p>Amazon SageMaker Feature Store stores features in a collection called Feature Group.
    /// A Feature Group can be visualized as a table which has rows,
    /// with a unique identifier for each row where each column in the table is a feature.
    /// In principle, a Feature Group is composed of features and values per features.</p>
    pub feature_group: std::option::Option<crate::model::FeatureGroup>,
    /// <p>The properties of a project.</p>
    pub project: std::option::Option<crate::model::Project>,
}
impl SearchRecord {
    /// <p>The properties of a training job.</p>
    pub fn training_job(&self) -> std::option::Option<&crate::model::TrainingJob> {
        self.training_job.as_ref()
    }
    /// <p>The properties of an experiment.</p>
    pub fn experiment(&self) -> std::option::Option<&crate::model::Experiment> {
        self.experiment.as_ref()
    }
    /// <p>The properties of a trial.</p>
    pub fn trial(&self) -> std::option::Option<&crate::model::Trial> {
        self.trial.as_ref()
    }
    /// <p>The properties of a trial component.</p>
    pub fn trial_component(&self) -> std::option::Option<&crate::model::TrialComponent> {
        self.trial_component.as_ref()
    }
    /// <p>A hosted endpoint for real-time inference.</p>
    pub fn endpoint(&self) -> std::option::Option<&crate::model::Endpoint> {
        self.endpoint.as_ref()
    }
    /// <p>A versioned model that can be deployed for SageMaker inference.</p>
    pub fn model_package(&self) -> std::option::Option<&crate::model::ModelPackage> {
        self.model_package.as_ref()
    }
    /// <p>A group of versioned models in the model registry.</p>
    pub fn model_package_group(&self) -> std::option::Option<&crate::model::ModelPackageGroup> {
        self.model_package_group.as_ref()
    }
    /// <p>A SageMaker Model Building Pipeline instance.</p>
    pub fn pipeline(&self) -> std::option::Option<&crate::model::Pipeline> {
        self.pipeline.as_ref()
    }
    /// <p>An execution of a pipeline.</p>
    pub fn pipeline_execution(&self) -> std::option::Option<&crate::model::PipelineExecution> {
        self.pipeline_execution.as_ref()
    }
    /// <p>Amazon SageMaker Feature Store stores features in a collection called Feature Group.
    /// A Feature Group can be visualized as a table which has rows,
    /// with a unique identifier for each row where each column in the table is a feature.
    /// In principle, a Feature Group is composed of features and values per features.</p>
    pub fn feature_group(&self) -> std::option::Option<&crate::model::FeatureGroup> {
        self.feature_group.as_ref()
    }
    /// <p>The properties of a project.</p>
    pub fn project(&self) -> std::option::Option<&crate::model::Project> {
        self.project.as_ref()
    }
}
impl std::fmt::Debug for SearchRecord {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchRecord");
        formatter.field("training_job", &self.training_job);
        formatter.field("experiment", &self.experiment);
        formatter.field("trial", &self.trial);
        formatter.field("trial_component", &self.trial_component);
        formatter.field("endpoint", &self.endpoint);
        formatter.field("model_package", &self.model_package);
        formatter.field("model_package_group", &self.model_package_group);
        formatter.field("pipeline", &self.pipeline);
        formatter.field("pipeline_execution", &self.pipeline_execution);
        formatter.field("feature_group", &self.feature_group);
        formatter.field("project", &self.project);
        formatter.finish()
    }
}
/// See [`SearchRecord`](crate::model::SearchRecord)
pub mod search_record {
    /// A builder for [`SearchRecord`](crate::model::SearchRecord)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) training_job: std::option::Option<crate::model::TrainingJob>,
        pub(crate) experiment: std::option::Option<crate::model::Experiment>,
        pub(crate) trial: std::option::Option<crate::model::Trial>,
        pub(crate) trial_component: std::option::Option<crate::model::TrialComponent>,
        pub(crate) endpoint: std::option::Option<crate::model::Endpoint>,
        pub(crate) model_package: std::option::Option<crate::model::ModelPackage>,
        pub(crate) model_package_group: std::option::Option<crate::model::ModelPackageGroup>,
        pub(crate) pipeline: std::option::Option<crate::model::Pipeline>,
        pub(crate) pipeline_execution: std::option::Option<crate::model::PipelineExecution>,
        pub(crate) feature_group: std::option::Option<crate::model::FeatureGroup>,
        pub(crate) project: std::option::Option<crate::model::Project>,
    }
    impl Builder {
        /// <p>The properties of a training job.</p>
        pub fn training_job(mut self, input: crate::model::TrainingJob) -> Self {
            self.training_job = Some(input);
            self
        }
        /// <p>The properties of a training job.</p>
        pub fn set_training_job(
            mut self,
            input: std::option::Option<crate::model::TrainingJob>,
        ) -> Self {
            self.training_job = input;
            self
        }
        /// <p>The properties of an experiment.</p>
        pub fn experiment(mut self, input: crate::model::Experiment) -> Self {
            self.experiment = Some(input);
            self
        }
        /// <p>The properties of an experiment.</p>
        pub fn set_experiment(
            mut self,
            input: std::option::Option<crate::model::Experiment>,
        ) -> Self {
            self.experiment = input;
            self
        }
        /// <p>The properties of a trial.</p>
        pub fn trial(mut self, input: crate::model::Trial) -> Self {
            self.trial = Some(input);
            self
        }
        /// <p>The properties of a trial.</p>
        pub fn set_trial(mut self, input: std::option::Option<crate::model::Trial>) -> Self {
            self.trial = input;
            self
        }
        /// <p>The properties of a trial component.</p>
        pub fn trial_component(mut self, input: crate::model::TrialComponent) -> Self {
            self.trial_component = Some(input);
            self
        }
        /// <p>The properties of a trial component.</p>
        pub fn set_trial_component(
            mut self,
            input: std::option::Option<crate::model::TrialComponent>,
        ) -> Self {
            self.trial_component = input;
            self
        }
        /// <p>A hosted endpoint for real-time inference.</p>
        pub fn endpoint(mut self, input: crate::model::Endpoint) -> Self {
            self.endpoint = Some(input);
            self
        }
        /// <p>A hosted endpoint for real-time inference.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<crate::model::Endpoint>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>A versioned model that can be deployed for SageMaker inference.</p>
        pub fn model_package(mut self, input: crate::model::ModelPackage) -> Self {
            self.model_package = Some(input);
            self
        }
        /// <p>A versioned model that can be deployed for SageMaker inference.</p>
        pub fn set_model_package(
            mut self,
            input: std::option::Option<crate::model::ModelPackage>,
        ) -> Self {
            self.model_package = input;
            self
        }
        /// <p>A group of versioned models in the model registry.</p>
        pub fn model_package_group(mut self, input: crate::model::ModelPackageGroup) -> Self {
            self.model_package_group = Some(input);
            self
        }
        /// <p>A group of versioned models in the model registry.</p>
        pub fn set_model_package_group(
            mut self,
            input: std::option::Option<crate::model::ModelPackageGroup>,
        ) -> Self {
            self.model_package_group = input;
            self
        }
        /// <p>A SageMaker Model Building Pipeline instance.</p>
        pub fn pipeline(mut self, input: crate::model::Pipeline) -> Self {
            self.pipeline = Some(input);
            self
        }
        /// <p>A SageMaker Model Building Pipeline instance.</p>
        pub fn set_pipeline(mut self, input: std::option::Option<crate::model::Pipeline>) -> Self {
            self.pipeline = input;
            self
        }
        /// <p>An execution of a pipeline.</p>
        pub fn pipeline_execution(mut self, input: crate::model::PipelineExecution) -> Self {
            self.pipeline_execution = Some(input);
            self
        }
        /// <p>An execution of a pipeline.</p>
        pub fn set_pipeline_execution(
            mut self,
            input: std::option::Option<crate::model::PipelineExecution>,
        ) -> Self {
            self.pipeline_execution = input;
            self
        }
        /// <p>Amazon SageMaker Feature Store stores features in a collection called Feature Group.
        /// A Feature Group can be visualized as a table which has rows,
        /// with a unique identifier for each row where each column in the table is a feature.
        /// In principle, a Feature Group is composed of features and values per features.</p>
        pub fn feature_group(mut self, input: crate::model::FeatureGroup) -> Self {
            self.feature_group = Some(input);
            self
        }
        /// <p>Amazon SageMaker Feature Store stores features in a collection called Feature Group.
        /// A Feature Group can be visualized as a table which has rows,
        /// with a unique identifier for each row where each column in the table is a feature.
        /// In principle, a Feature Group is composed of features and values per features.</p>
        pub fn set_feature_group(
            mut self,
            input: std::option::Option<crate::model::FeatureGroup>,
        ) -> Self {
            self.feature_group = input;
            self
        }
        /// <p>The properties of a project.</p>
        pub fn project(mut self, input: crate::model::Project) -> Self {
            self.project = Some(input);
            self
        }
        /// <p>The properties of a project.</p>
        pub fn set_project(mut self, input: std::option::Option<crate::model::Project>) -> Self {
            self.project = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchRecord`](crate::model::SearchRecord)
        pub fn build(self) -> crate::model::SearchRecord {
            crate::model::SearchRecord {
                training_job: self.training_job,
                experiment: self.experiment,
                trial: self.trial,
                trial_component: self.trial_component,
                endpoint: self.endpoint,
                model_package: self.model_package,
                model_package_group: self.model_package_group,
                pipeline: self.pipeline,
                pipeline_execution: self.pipeline_execution,
                feature_group: self.feature_group,
                project: self.project,
            }
        }
    }
}
impl SearchRecord {
    /// Creates a new builder-style object to manufacture [`SearchRecord`](crate::model::SearchRecord)
    pub fn builder() -> crate::model::search_record::Builder {
        crate::model::search_record::Builder::default()
    }
}

/// <p>The properties of a project as returned by the Search API.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Project {
    /// <p>The Amazon Resource Name (ARN) of the project.</p>
    pub project_arn: std::option::Option<std::string::String>,
    /// <p>The name of the project.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>The ID of the project.</p>
    pub project_id: std::option::Option<std::string::String>,
    /// <p>The description of the project.</p>
    pub project_description: std::option::Option<std::string::String>,
    /// <p>Details that you specify to provision a service catalog product. For information about
    /// service catalog, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services Service
    /// Catalog</a>.</p>
    pub service_catalog_provisioning_details:
        std::option::Option<crate::model::ServiceCatalogProvisioningDetails>,
    /// <p>Details of a provisioned service catalog product. For information about service catalog,
    /// see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services Service
    /// Catalog</a>.</p>
    pub service_catalog_provisioned_product_details:
        std::option::Option<crate::model::ServiceCatalogProvisionedProductDetails>,
    /// <p>The status of the project.</p>
    pub project_status: std::option::Option<crate::model::ProjectStatus>,
    /// <p>Who created the project.</p>
    pub created_by: std::option::Option<crate::model::UserContext>,
    /// <p>A timestamp specifying when the project was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
    /// different ways, for example, by purpose, owner, or environment. For more information,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
    /// Resources</a>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>A timestamp container for when the project was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Information about the user who created or modified an experiment, trial, trial
    /// component, lineage group, or project.</p>
    pub last_modified_by: std::option::Option<crate::model::UserContext>,
}
impl Project {
    /// <p>The Amazon Resource Name (ARN) of the project.</p>
    pub fn project_arn(&self) -> std::option::Option<&str> {
        self.project_arn.as_deref()
    }
    /// <p>The name of the project.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>The ID of the project.</p>
    pub fn project_id(&self) -> std::option::Option<&str> {
        self.project_id.as_deref()
    }
    /// <p>The description of the project.</p>
    pub fn project_description(&self) -> std::option::Option<&str> {
        self.project_description.as_deref()
    }
    /// <p>Details that you specify to provision a service catalog product. For information about
    /// service catalog, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services Service
    /// Catalog</a>.</p>
    pub fn service_catalog_provisioning_details(
        &self,
    ) -> std::option::Option<&crate::model::ServiceCatalogProvisioningDetails> {
        self.service_catalog_provisioning_details.as_ref()
    }
    /// <p>Details of a provisioned service catalog product. For information about service catalog,
    /// see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services Service
    /// Catalog</a>.</p>
    pub fn service_catalog_provisioned_product_details(
        &self,
    ) -> std::option::Option<&crate::model::ServiceCatalogProvisionedProductDetails> {
        self.service_catalog_provisioned_product_details.as_ref()
    }
    /// <p>The status of the project.</p>
    pub fn project_status(&self) -> std::option::Option<&crate::model::ProjectStatus> {
        self.project_status.as_ref()
    }
    /// <p>Who created the project.</p>
    pub fn created_by(&self) -> std::option::Option<&crate::model::UserContext> {
        self.created_by.as_ref()
    }
    /// <p>A timestamp specifying when the project was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
    /// different ways, for example, by purpose, owner, or environment. For more information,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
    /// Resources</a>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>A timestamp container for when the project was last modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>Information about the user who created or modified an experiment, trial, trial
    /// component, lineage group, or project.</p>
    pub fn last_modified_by(&self) -> std::option::Option<&crate::model::UserContext> {
        self.last_modified_by.as_ref()
    }
}
impl std::fmt::Debug for Project {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Project");
        formatter.field("project_arn", &self.project_arn);
        formatter.field("project_name", &self.project_name);
        formatter.field("project_id", &self.project_id);
        formatter.field("project_description", &self.project_description);
        formatter.field(
            "service_catalog_provisioning_details",
            &self.service_catalog_provisioning_details,
        );
        formatter.field(
            "service_catalog_provisioned_product_details",
            &self.service_catalog_provisioned_product_details,
        );
        formatter.field("project_status", &self.project_status);
        formatter.field("created_by", &self.created_by);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("tags", &self.tags);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.finish()
    }
}
/// See [`Project`](crate::model::Project)
pub mod project {
    /// A builder for [`Project`](crate::model::Project)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_arn: std::option::Option<std::string::String>,
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) project_id: std::option::Option<std::string::String>,
        pub(crate) project_description: std::option::Option<std::string::String>,
        pub(crate) service_catalog_provisioning_details:
            std::option::Option<crate::model::ServiceCatalogProvisioningDetails>,
        pub(crate) service_catalog_provisioned_product_details:
            std::option::Option<crate::model::ServiceCatalogProvisionedProductDetails>,
        pub(crate) project_status: std::option::Option<crate::model::ProjectStatus>,
        pub(crate) created_by: std::option::Option<crate::model::UserContext>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_by: std::option::Option<crate::model::UserContext>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the project.</p>
        pub fn project_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_arn = input;
            self
        }
        /// <p>The name of the project.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>The ID of the project.</p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_id = Some(input.into());
            self
        }
        /// <p>The ID of the project.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_id = input;
            self
        }
        /// <p>The description of the project.</p>
        pub fn project_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_description = Some(input.into());
            self
        }
        /// <p>The description of the project.</p>
        pub fn set_project_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.project_description = input;
            self
        }
        /// <p>Details that you specify to provision a service catalog product. For information about
        /// service catalog, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services Service
        /// Catalog</a>.</p>
        pub fn service_catalog_provisioning_details(
            mut self,
            input: crate::model::ServiceCatalogProvisioningDetails,
        ) -> Self {
            self.service_catalog_provisioning_details = Some(input);
            self
        }
        /// <p>Details that you specify to provision a service catalog product. For information about
        /// service catalog, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services Service
        /// Catalog</a>.</p>
        pub fn set_service_catalog_provisioning_details(
            mut self,
            input: std::option::Option<crate::model::ServiceCatalogProvisioningDetails>,
        ) -> Self {
            self.service_catalog_provisioning_details = input;
            self
        }
        /// <p>Details of a provisioned service catalog product. For information about service catalog,
        /// see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services Service
        /// Catalog</a>.</p>
        pub fn service_catalog_provisioned_product_details(
            mut self,
            input: crate::model::ServiceCatalogProvisionedProductDetails,
        ) -> Self {
            self.service_catalog_provisioned_product_details = Some(input);
            self
        }
        /// <p>Details of a provisioned service catalog product. For information about service catalog,
        /// see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services Service
        /// Catalog</a>.</p>
        pub fn set_service_catalog_provisioned_product_details(
            mut self,
            input: std::option::Option<crate::model::ServiceCatalogProvisionedProductDetails>,
        ) -> Self {
            self.service_catalog_provisioned_product_details = input;
            self
        }
        /// <p>The status of the project.</p>
        pub fn project_status(mut self, input: crate::model::ProjectStatus) -> Self {
            self.project_status = Some(input);
            self
        }
        /// <p>The status of the project.</p>
        pub fn set_project_status(
            mut self,
            input: std::option::Option<crate::model::ProjectStatus>,
        ) -> Self {
            self.project_status = input;
            self
        }
        /// <p>Who created the project.</p>
        pub fn created_by(mut self, input: crate::model::UserContext) -> Self {
            self.created_by = Some(input);
            self
        }
        /// <p>Who created the project.</p>
        pub fn set_created_by(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.created_by = input;
            self
        }
        /// <p>A timestamp specifying when the project was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A timestamp specifying when the project was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
        /// different ways, for example, by purpose, owner, or environment. For more information,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// Resources</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
        /// different ways, for example, by purpose, owner, or environment. For more information,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// Resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A timestamp container for when the project was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>A timestamp container for when the project was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial
        /// component, lineage group, or project.</p>
        pub fn last_modified_by(mut self, input: crate::model::UserContext) -> Self {
            self.last_modified_by = Some(input);
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial
        /// component, lineage group, or project.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// Consumes the builder and constructs a [`Project`](crate::model::Project)
        pub fn build(self) -> crate::model::Project {
            crate::model::Project {
                project_arn: self.project_arn,
                project_name: self.project_name,
                project_id: self.project_id,
                project_description: self.project_description,
                service_catalog_provisioning_details: self.service_catalog_provisioning_details,
                service_catalog_provisioned_product_details: self
                    .service_catalog_provisioned_product_details,
                project_status: self.project_status,
                created_by: self.created_by,
                creation_time: self.creation_time,
                tags: self.tags,
                last_modified_time: self.last_modified_time,
                last_modified_by: self.last_modified_by,
            }
        }
    }
}
impl Project {
    /// Creates a new builder-style object to manufacture [`Project`](crate::model::Project)
    pub fn builder() -> crate::model::project::Builder {
        crate::model::project::Builder::default()
    }
}

/// <p>Information about the user who created or modified an experiment, trial, trial
/// component, lineage group, or project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserContext {
    /// <p>The Amazon Resource Name (ARN) of the user's profile.</p>
    pub user_profile_arn: std::option::Option<std::string::String>,
    /// <p>The name of the user's profile.</p>
    pub user_profile_name: std::option::Option<std::string::String>,
    /// <p>The domain associated with the user.</p>
    pub domain_id: std::option::Option<std::string::String>,
}
impl UserContext {
    /// <p>The Amazon Resource Name (ARN) of the user's profile.</p>
    pub fn user_profile_arn(&self) -> std::option::Option<&str> {
        self.user_profile_arn.as_deref()
    }
    /// <p>The name of the user's profile.</p>
    pub fn user_profile_name(&self) -> std::option::Option<&str> {
        self.user_profile_name.as_deref()
    }
    /// <p>The domain associated with the user.</p>
    pub fn domain_id(&self) -> std::option::Option<&str> {
        self.domain_id.as_deref()
    }
}
impl std::fmt::Debug for UserContext {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserContext");
        formatter.field("user_profile_arn", &self.user_profile_arn);
        formatter.field("user_profile_name", &self.user_profile_name);
        formatter.field("domain_id", &self.domain_id);
        formatter.finish()
    }
}
/// See [`UserContext`](crate::model::UserContext)
pub mod user_context {
    /// A builder for [`UserContext`](crate::model::UserContext)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_profile_arn: std::option::Option<std::string::String>,
        pub(crate) user_profile_name: std::option::Option<std::string::String>,
        pub(crate) domain_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the user's profile.</p>
        pub fn user_profile_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_profile_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user's profile.</p>
        pub fn set_user_profile_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_profile_arn = input;
            self
        }
        /// <p>The name of the user's profile.</p>
        pub fn user_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_profile_name = Some(input.into());
            self
        }
        /// <p>The name of the user's profile.</p>
        pub fn set_user_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_profile_name = input;
            self
        }
        /// <p>The domain associated with the user.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_id = Some(input.into());
            self
        }
        /// <p>The domain associated with the user.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UserContext`](crate::model::UserContext)
        pub fn build(self) -> crate::model::UserContext {
            crate::model::UserContext {
                user_profile_arn: self.user_profile_arn,
                user_profile_name: self.user_profile_name,
                domain_id: self.domain_id,
            }
        }
    }
}
impl UserContext {
    /// Creates a new builder-style object to manufacture [`UserContext`](crate::model::UserContext)
    pub fn builder() -> crate::model::user_context::Builder {
        crate::model::user_context::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProjectStatus {
    #[allow(missing_docs)] // documentation missing in model
    CreateCompleted,
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    CreateInProgress,
    #[allow(missing_docs)] // documentation missing in model
    DeleteCompleted,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    UpdateCompleted,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailed,
    #[allow(missing_docs)] // documentation missing in model
    UpdateInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProjectStatus {
    fn from(s: &str) -> Self {
        match s {
            "CreateCompleted" => ProjectStatus::CreateCompleted,
            "CreateFailed" => ProjectStatus::CreateFailed,
            "CreateInProgress" => ProjectStatus::CreateInProgress,
            "DeleteCompleted" => ProjectStatus::DeleteCompleted,
            "DeleteFailed" => ProjectStatus::DeleteFailed,
            "DeleteInProgress" => ProjectStatus::DeleteInProgress,
            "Pending" => ProjectStatus::Pending,
            "UpdateCompleted" => ProjectStatus::UpdateCompleted,
            "UpdateFailed" => ProjectStatus::UpdateFailed,
            "UpdateInProgress" => ProjectStatus::UpdateInProgress,
            other => ProjectStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProjectStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProjectStatus::from(s))
    }
}
impl ProjectStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProjectStatus::CreateCompleted => "CreateCompleted",
            ProjectStatus::CreateFailed => "CreateFailed",
            ProjectStatus::CreateInProgress => "CreateInProgress",
            ProjectStatus::DeleteCompleted => "DeleteCompleted",
            ProjectStatus::DeleteFailed => "DeleteFailed",
            ProjectStatus::DeleteInProgress => "DeleteInProgress",
            ProjectStatus::Pending => "Pending",
            ProjectStatus::UpdateCompleted => "UpdateCompleted",
            ProjectStatus::UpdateFailed => "UpdateFailed",
            ProjectStatus::UpdateInProgress => "UpdateInProgress",
            ProjectStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CreateCompleted",
            "CreateFailed",
            "CreateInProgress",
            "DeleteCompleted",
            "DeleteFailed",
            "DeleteInProgress",
            "Pending",
            "UpdateCompleted",
            "UpdateFailed",
            "UpdateInProgress",
        ]
    }
}
impl AsRef<str> for ProjectStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details of a provisioned service catalog product. For information about service catalog,
/// see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services Service
/// Catalog</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceCatalogProvisionedProductDetails {
    /// <p>The ID of the provisioned product.</p>
    pub provisioned_product_id: std::option::Option<std::string::String>,
    /// <p>The current status of the product.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AVAILABLE</code> - Stable state, ready to perform any operation. The most recent operation succeeded and completed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UNDER_CHANGE</code> - Transitive state. Operations performed might not have valid results. Wait for an AVAILABLE status before performing operations.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TAINTED</code> - Stable state, ready to perform any operation. The stack has completed the requested operation but is not exactly what was requested. For example, a request to update to a new version failed and the stack rolled back to the current version.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ERROR</code> - An unexpected error occurred. The provisioned product exists but the stack is not running. For example, CloudFormation received a parameter value that was not valid and could not launch the stack.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PLAN_IN_PROGRESS</code> - Transitive state. The plan operations were performed to provision a new product, but resources have not yet been created. After reviewing the list of resources to be created, execute the plan. Wait for an AVAILABLE status before performing operations.</p>
    /// </li>
    /// </ul>
    pub provisioned_product_status_message: std::option::Option<std::string::String>,
}
impl ServiceCatalogProvisionedProductDetails {
    /// <p>The ID of the provisioned product.</p>
    pub fn provisioned_product_id(&self) -> std::option::Option<&str> {
        self.provisioned_product_id.as_deref()
    }
    /// <p>The current status of the product.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AVAILABLE</code> - Stable state, ready to perform any operation. The most recent operation succeeded and completed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UNDER_CHANGE</code> - Transitive state. Operations performed might not have valid results. Wait for an AVAILABLE status before performing operations.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TAINTED</code> - Stable state, ready to perform any operation. The stack has completed the requested operation but is not exactly what was requested. For example, a request to update to a new version failed and the stack rolled back to the current version.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ERROR</code> - An unexpected error occurred. The provisioned product exists but the stack is not running. For example, CloudFormation received a parameter value that was not valid and could not launch the stack.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PLAN_IN_PROGRESS</code> - Transitive state. The plan operations were performed to provision a new product, but resources have not yet been created. After reviewing the list of resources to be created, execute the plan. Wait for an AVAILABLE status before performing operations.</p>
    /// </li>
    /// </ul>
    pub fn provisioned_product_status_message(&self) -> std::option::Option<&str> {
        self.provisioned_product_status_message.as_deref()
    }
}
impl std::fmt::Debug for ServiceCatalogProvisionedProductDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceCatalogProvisionedProductDetails");
        formatter.field("provisioned_product_id", &self.provisioned_product_id);
        formatter.field(
            "provisioned_product_status_message",
            &self.provisioned_product_status_message,
        );
        formatter.finish()
    }
}
/// See [`ServiceCatalogProvisionedProductDetails`](crate::model::ServiceCatalogProvisionedProductDetails)
pub mod service_catalog_provisioned_product_details {
    /// A builder for [`ServiceCatalogProvisionedProductDetails`](crate::model::ServiceCatalogProvisionedProductDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) provisioned_product_id: std::option::Option<std::string::String>,
        pub(crate) provisioned_product_status_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the provisioned product.</p>
        pub fn provisioned_product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioned_product_id = Some(input.into());
            self
        }
        /// <p>The ID of the provisioned product.</p>
        pub fn set_provisioned_product_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioned_product_id = input;
            self
        }
        /// <p>The current status of the product.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AVAILABLE</code> - Stable state, ready to perform any operation. The most recent operation succeeded and completed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UNDER_CHANGE</code> - Transitive state. Operations performed might not have valid results. Wait for an AVAILABLE status before performing operations.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TAINTED</code> - Stable state, ready to perform any operation. The stack has completed the requested operation but is not exactly what was requested. For example, a request to update to a new version failed and the stack rolled back to the current version.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ERROR</code> - An unexpected error occurred. The provisioned product exists but the stack is not running. For example, CloudFormation received a parameter value that was not valid and could not launch the stack.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PLAN_IN_PROGRESS</code> - Transitive state. The plan operations were performed to provision a new product, but resources have not yet been created. After reviewing the list of resources to be created, execute the plan. Wait for an AVAILABLE status before performing operations.</p>
        /// </li>
        /// </ul>
        pub fn provisioned_product_status_message(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.provisioned_product_status_message = Some(input.into());
            self
        }
        /// <p>The current status of the product.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AVAILABLE</code> - Stable state, ready to perform any operation. The most recent operation succeeded and completed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UNDER_CHANGE</code> - Transitive state. Operations performed might not have valid results. Wait for an AVAILABLE status before performing operations.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TAINTED</code> - Stable state, ready to perform any operation. The stack has completed the requested operation but is not exactly what was requested. For example, a request to update to a new version failed and the stack rolled back to the current version.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ERROR</code> - An unexpected error occurred. The provisioned product exists but the stack is not running. For example, CloudFormation received a parameter value that was not valid and could not launch the stack.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PLAN_IN_PROGRESS</code> - Transitive state. The plan operations were performed to provision a new product, but resources have not yet been created. After reviewing the list of resources to be created, execute the plan. Wait for an AVAILABLE status before performing operations.</p>
        /// </li>
        /// </ul>
        pub fn set_provisioned_product_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioned_product_status_message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceCatalogProvisionedProductDetails`](crate::model::ServiceCatalogProvisionedProductDetails)
        pub fn build(self) -> crate::model::ServiceCatalogProvisionedProductDetails {
            crate::model::ServiceCatalogProvisionedProductDetails {
                provisioned_product_id: self.provisioned_product_id,
                provisioned_product_status_message: self.provisioned_product_status_message,
            }
        }
    }
}
impl ServiceCatalogProvisionedProductDetails {
    /// Creates a new builder-style object to manufacture [`ServiceCatalogProvisionedProductDetails`](crate::model::ServiceCatalogProvisionedProductDetails)
    pub fn builder() -> crate::model::service_catalog_provisioned_product_details::Builder {
        crate::model::service_catalog_provisioned_product_details::Builder::default()
    }
}

/// <p>Details that you specify to provision a service catalog product. For information about
/// service catalog, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services Service
/// Catalog</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceCatalogProvisioningDetails {
    /// <p>The ID of the product to provision.</p>
    pub product_id: std::option::Option<std::string::String>,
    /// <p>The ID of the provisioning artifact.</p>
    pub provisioning_artifact_id: std::option::Option<std::string::String>,
    /// <p>The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. </p>
    pub path_id: std::option::Option<std::string::String>,
    /// <p>A list of key value pairs that you specify when you provision a product.</p>
    pub provisioning_parameters:
        std::option::Option<std::vec::Vec<crate::model::ProvisioningParameter>>,
}
impl ServiceCatalogProvisioningDetails {
    /// <p>The ID of the product to provision.</p>
    pub fn product_id(&self) -> std::option::Option<&str> {
        self.product_id.as_deref()
    }
    /// <p>The ID of the provisioning artifact.</p>
    pub fn provisioning_artifact_id(&self) -> std::option::Option<&str> {
        self.provisioning_artifact_id.as_deref()
    }
    /// <p>The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. </p>
    pub fn path_id(&self) -> std::option::Option<&str> {
        self.path_id.as_deref()
    }
    /// <p>A list of key value pairs that you specify when you provision a product.</p>
    pub fn provisioning_parameters(
        &self,
    ) -> std::option::Option<&[crate::model::ProvisioningParameter]> {
        self.provisioning_parameters.as_deref()
    }
}
impl std::fmt::Debug for ServiceCatalogProvisioningDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceCatalogProvisioningDetails");
        formatter.field("product_id", &self.product_id);
        formatter.field("provisioning_artifact_id", &self.provisioning_artifact_id);
        formatter.field("path_id", &self.path_id);
        formatter.field("provisioning_parameters", &self.provisioning_parameters);
        formatter.finish()
    }
}
/// See [`ServiceCatalogProvisioningDetails`](crate::model::ServiceCatalogProvisioningDetails)
pub mod service_catalog_provisioning_details {
    /// A builder for [`ServiceCatalogProvisioningDetails`](crate::model::ServiceCatalogProvisioningDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) product_id: std::option::Option<std::string::String>,
        pub(crate) provisioning_artifact_id: std::option::Option<std::string::String>,
        pub(crate) path_id: std::option::Option<std::string::String>,
        pub(crate) provisioning_parameters:
            std::option::Option<std::vec::Vec<crate::model::ProvisioningParameter>>,
    }
    impl Builder {
        /// <p>The ID of the product to provision.</p>
        pub fn product_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_id = Some(input.into());
            self
        }
        /// <p>The ID of the product to provision.</p>
        pub fn set_product_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_id = input;
            self
        }
        /// <p>The ID of the provisioning artifact.</p>
        pub fn provisioning_artifact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.provisioning_artifact_id = Some(input.into());
            self
        }
        /// <p>The ID of the provisioning artifact.</p>
        pub fn set_provisioning_artifact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provisioning_artifact_id = input;
            self
        }
        /// <p>The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. </p>
        pub fn path_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.path_id = Some(input.into());
            self
        }
        /// <p>The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. </p>
        pub fn set_path_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path_id = input;
            self
        }
        /// Appends an item to `provisioning_parameters`.
        ///
        /// To override the contents of this collection use [`set_provisioning_parameters`](Self::set_provisioning_parameters).
        ///
        /// <p>A list of key value pairs that you specify when you provision a product.</p>
        pub fn provisioning_parameters(
            mut self,
            input: impl Into<crate::model::ProvisioningParameter>,
        ) -> Self {
            let mut v = self.provisioning_parameters.unwrap_or_default();
            v.push(input.into());
            self.provisioning_parameters = Some(v);
            self
        }
        /// <p>A list of key value pairs that you specify when you provision a product.</p>
        pub fn set_provisioning_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProvisioningParameter>>,
        ) -> Self {
            self.provisioning_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceCatalogProvisioningDetails`](crate::model::ServiceCatalogProvisioningDetails)
        pub fn build(self) -> crate::model::ServiceCatalogProvisioningDetails {
            crate::model::ServiceCatalogProvisioningDetails {
                product_id: self.product_id,
                provisioning_artifact_id: self.provisioning_artifact_id,
                path_id: self.path_id,
                provisioning_parameters: self.provisioning_parameters,
            }
        }
    }
}
impl ServiceCatalogProvisioningDetails {
    /// Creates a new builder-style object to manufacture [`ServiceCatalogProvisioningDetails`](crate::model::ServiceCatalogProvisioningDetails)
    pub fn builder() -> crate::model::service_catalog_provisioning_details::Builder {
        crate::model::service_catalog_provisioning_details::Builder::default()
    }
}

/// <p>Amazon SageMaker Feature Store stores features in a collection called Feature Group.
/// A Feature Group can be visualized as a table which has rows,
/// with a unique identifier for each row where each column in the table is a feature.
/// In principle, a Feature Group is composed of features and values per features.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FeatureGroup {
    /// <p>The Amazon Resource Name (ARN) of a <code>FeatureGroup</code>.</p>
    pub feature_group_arn: std::option::Option<std::string::String>,
    /// <p>The name of the <code>FeatureGroup</code>.</p>
    pub feature_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the <code>Feature</code> whose value uniquely identifies a
    /// <code>Record</code> defined in the <code>FeatureGroup</code>
    /// <code>FeatureDefinitions</code>.</p>
    pub record_identifier_feature_name: std::option::Option<std::string::String>,
    /// <p>The name of the feature that stores the <code>EventTime</code> of a Record in a
    /// <code>FeatureGroup</code>.</p>
    /// <p>A <code>EventTime</code> is point in time when a new event
    /// occurs that corresponds to the creation or update of a <code>Record</code> in
    /// <code>FeatureGroup</code>. All <code>Records</code> in the <code>FeatureGroup</code>
    /// must have a corresponding <code>EventTime</code>.</p>
    pub event_time_feature_name: std::option::Option<std::string::String>,
    /// <p>A list of <code>Feature</code>s. Each <code>Feature</code> must include a
    /// <code>FeatureName</code> and a <code>FeatureType</code>. </p>
    /// <p>Valid <code>FeatureType</code>s are <code>Integral</code>, <code>Fractional</code> and
    /// <code>String</code>. </p>
    /// <p>
    /// <code>FeatureName</code>s cannot be any of the following: <code>is_deleted</code>,
    /// <code>write_time</code>, <code>api_invocation_time</code>.</p>
    /// <p>You can create up to 2,500 <code>FeatureDefinition</code>s per
    /// <code>FeatureGroup</code>.</p>
    pub feature_definitions: std::option::Option<std::vec::Vec<crate::model::FeatureDefinition>>,
    /// <p>The time a <code>FeatureGroup</code> was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Use this to specify the Amazon Web Services Key Management Service (KMS) Key ID, or
    /// <code>KMSKeyId</code>, for at rest data encryption. You can turn
    /// <code>OnlineStore</code> on or off by specifying the <code>EnableOnlineStore</code> flag
    /// at General Assembly; the default value is <code>False</code>.</p>
    pub online_store_config: std::option::Option<crate::model::OnlineStoreConfig>,
    /// <p>The configuration of an <code>OfflineStore</code>.</p>
    /// <p>Provide an <code>OfflineStoreConfig</code> in a request to
    /// <code>CreateFeatureGroup</code> to create an <code>OfflineStore</code>.</p>
    /// <p>To encrypt an <code>OfflineStore</code> using at rest data encryption, specify Amazon Web Services Key
    /// Management Service (KMS) key ID, or <code>KMSKeyId</code>, in
    /// <code>S3StorageConfig</code>.</p>
    pub offline_store_config: std::option::Option<crate::model::OfflineStoreConfig>,
    /// <p>The Amazon Resource Name (ARN) of the IAM execution role used to create the feature
    /// group.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>A <code>FeatureGroup</code> status.</p>
    pub feature_group_status: std::option::Option<crate::model::FeatureGroupStatus>,
    /// <p>The status of <code>OfflineStore</code>.</p>
    pub offline_store_status: std::option::Option<crate::model::OfflineStoreStatus>,
    /// <p>The reason that the <code>FeatureGroup</code> failed to
    /// be replicated in the <code>OfflineStore</code>. This is
    /// failure may be due to a failure to create a <code>FeatureGroup</code> in
    /// or delete a <code>FeatureGroup</code> from the <code>OfflineStore</code>.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>A free form description of a <code>FeatureGroup</code>.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Tags used to define a <code>FeatureGroup</code>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl FeatureGroup {
    /// <p>The Amazon Resource Name (ARN) of a <code>FeatureGroup</code>.</p>
    pub fn feature_group_arn(&self) -> std::option::Option<&str> {
        self.feature_group_arn.as_deref()
    }
    /// <p>The name of the <code>FeatureGroup</code>.</p>
    pub fn feature_group_name(&self) -> std::option::Option<&str> {
        self.feature_group_name.as_deref()
    }
    /// <p>The name of the <code>Feature</code> whose value uniquely identifies a
    /// <code>Record</code> defined in the <code>FeatureGroup</code>
    /// <code>FeatureDefinitions</code>.</p>
    pub fn record_identifier_feature_name(&self) -> std::option::Option<&str> {
        self.record_identifier_feature_name.as_deref()
    }
    /// <p>The name of the feature that stores the <code>EventTime</code> of a Record in a
    /// <code>FeatureGroup</code>.</p>
    /// <p>A <code>EventTime</code> is point in time when a new event
    /// occurs that corresponds to the creation or update of a <code>Record</code> in
    /// <code>FeatureGroup</code>. All <code>Records</code> in the <code>FeatureGroup</code>
    /// must have a corresponding <code>EventTime</code>.</p>
    pub fn event_time_feature_name(&self) -> std::option::Option<&str> {
        self.event_time_feature_name.as_deref()
    }
    /// <p>A list of <code>Feature</code>s. Each <code>Feature</code> must include a
    /// <code>FeatureName</code> and a <code>FeatureType</code>. </p>
    /// <p>Valid <code>FeatureType</code>s are <code>Integral</code>, <code>Fractional</code> and
    /// <code>String</code>. </p>
    /// <p>
    /// <code>FeatureName</code>s cannot be any of the following: <code>is_deleted</code>,
    /// <code>write_time</code>, <code>api_invocation_time</code>.</p>
    /// <p>You can create up to 2,500 <code>FeatureDefinition</code>s per
    /// <code>FeatureGroup</code>.</p>
    pub fn feature_definitions(&self) -> std::option::Option<&[crate::model::FeatureDefinition]> {
        self.feature_definitions.as_deref()
    }
    /// <p>The time a <code>FeatureGroup</code> was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>Use this to specify the Amazon Web Services Key Management Service (KMS) Key ID, or
    /// <code>KMSKeyId</code>, for at rest data encryption. You can turn
    /// <code>OnlineStore</code> on or off by specifying the <code>EnableOnlineStore</code> flag
    /// at General Assembly; the default value is <code>False</code>.</p>
    pub fn online_store_config(&self) -> std::option::Option<&crate::model::OnlineStoreConfig> {
        self.online_store_config.as_ref()
    }
    /// <p>The configuration of an <code>OfflineStore</code>.</p>
    /// <p>Provide an <code>OfflineStoreConfig</code> in a request to
    /// <code>CreateFeatureGroup</code> to create an <code>OfflineStore</code>.</p>
    /// <p>To encrypt an <code>OfflineStore</code> using at rest data encryption, specify Amazon Web Services Key
    /// Management Service (KMS) key ID, or <code>KMSKeyId</code>, in
    /// <code>S3StorageConfig</code>.</p>
    pub fn offline_store_config(&self) -> std::option::Option<&crate::model::OfflineStoreConfig> {
        self.offline_store_config.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM execution role used to create the feature
    /// group.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>A <code>FeatureGroup</code> status.</p>
    pub fn feature_group_status(&self) -> std::option::Option<&crate::model::FeatureGroupStatus> {
        self.feature_group_status.as_ref()
    }
    /// <p>The status of <code>OfflineStore</code>.</p>
    pub fn offline_store_status(&self) -> std::option::Option<&crate::model::OfflineStoreStatus> {
        self.offline_store_status.as_ref()
    }
    /// <p>The reason that the <code>FeatureGroup</code> failed to
    /// be replicated in the <code>OfflineStore</code>. This is
    /// failure may be due to a failure to create a <code>FeatureGroup</code> in
    /// or delete a <code>FeatureGroup</code> from the <code>OfflineStore</code>.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>A free form description of a <code>FeatureGroup</code>.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Tags used to define a <code>FeatureGroup</code>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for FeatureGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FeatureGroup");
        formatter.field("feature_group_arn", &self.feature_group_arn);
        formatter.field("feature_group_name", &self.feature_group_name);
        formatter.field(
            "record_identifier_feature_name",
            &self.record_identifier_feature_name,
        );
        formatter.field("event_time_feature_name", &self.event_time_feature_name);
        formatter.field("feature_definitions", &self.feature_definitions);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("online_store_config", &self.online_store_config);
        formatter.field("offline_store_config", &self.offline_store_config);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("feature_group_status", &self.feature_group_status);
        formatter.field("offline_store_status", &self.offline_store_status);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`FeatureGroup`](crate::model::FeatureGroup)
pub mod feature_group {
    /// A builder for [`FeatureGroup`](crate::model::FeatureGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) feature_group_arn: std::option::Option<std::string::String>,
        pub(crate) feature_group_name: std::option::Option<std::string::String>,
        pub(crate) record_identifier_feature_name: std::option::Option<std::string::String>,
        pub(crate) event_time_feature_name: std::option::Option<std::string::String>,
        pub(crate) feature_definitions:
            std::option::Option<std::vec::Vec<crate::model::FeatureDefinition>>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) online_store_config: std::option::Option<crate::model::OnlineStoreConfig>,
        pub(crate) offline_store_config: std::option::Option<crate::model::OfflineStoreConfig>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) feature_group_status: std::option::Option<crate::model::FeatureGroupStatus>,
        pub(crate) offline_store_status: std::option::Option<crate::model::OfflineStoreStatus>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of a <code>FeatureGroup</code>.</p>
        pub fn feature_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.feature_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a <code>FeatureGroup</code>.</p>
        pub fn set_feature_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.feature_group_arn = input;
            self
        }
        /// <p>The name of the <code>FeatureGroup</code>.</p>
        pub fn feature_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.feature_group_name = Some(input.into());
            self
        }
        /// <p>The name of the <code>FeatureGroup</code>.</p>
        pub fn set_feature_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.feature_group_name = input;
            self
        }
        /// <p>The name of the <code>Feature</code> whose value uniquely identifies a
        /// <code>Record</code> defined in the <code>FeatureGroup</code>
        /// <code>FeatureDefinitions</code>.</p>
        pub fn record_identifier_feature_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.record_identifier_feature_name = Some(input.into());
            self
        }
        /// <p>The name of the <code>Feature</code> whose value uniquely identifies a
        /// <code>Record</code> defined in the <code>FeatureGroup</code>
        /// <code>FeatureDefinitions</code>.</p>
        pub fn set_record_identifier_feature_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.record_identifier_feature_name = input;
            self
        }
        /// <p>The name of the feature that stores the <code>EventTime</code> of a Record in a
        /// <code>FeatureGroup</code>.</p>
        /// <p>A <code>EventTime</code> is point in time when a new event
        /// occurs that corresponds to the creation or update of a <code>Record</code> in
        /// <code>FeatureGroup</code>. All <code>Records</code> in the <code>FeatureGroup</code>
        /// must have a corresponding <code>EventTime</code>.</p>
        pub fn event_time_feature_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_time_feature_name = Some(input.into());
            self
        }
        /// <p>The name of the feature that stores the <code>EventTime</code> of a Record in a
        /// <code>FeatureGroup</code>.</p>
        /// <p>A <code>EventTime</code> is point in time when a new event
        /// occurs that corresponds to the creation or update of a <code>Record</code> in
        /// <code>FeatureGroup</code>. All <code>Records</code> in the <code>FeatureGroup</code>
        /// must have a corresponding <code>EventTime</code>.</p>
        pub fn set_event_time_feature_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_time_feature_name = input;
            self
        }
        /// Appends an item to `feature_definitions`.
        ///
        /// To override the contents of this collection use [`set_feature_definitions`](Self::set_feature_definitions).
        ///
        /// <p>A list of <code>Feature</code>s. Each <code>Feature</code> must include a
        /// <code>FeatureName</code> and a <code>FeatureType</code>. </p>
        /// <p>Valid <code>FeatureType</code>s are <code>Integral</code>, <code>Fractional</code> and
        /// <code>String</code>. </p>
        /// <p>
        /// <code>FeatureName</code>s cannot be any of the following: <code>is_deleted</code>,
        /// <code>write_time</code>, <code>api_invocation_time</code>.</p>
        /// <p>You can create up to 2,500 <code>FeatureDefinition</code>s per
        /// <code>FeatureGroup</code>.</p>
        pub fn feature_definitions(
            mut self,
            input: impl Into<crate::model::FeatureDefinition>,
        ) -> Self {
            let mut v = self.feature_definitions.unwrap_or_default();
            v.push(input.into());
            self.feature_definitions = Some(v);
            self
        }
        /// <p>A list of <code>Feature</code>s. Each <code>Feature</code> must include a
        /// <code>FeatureName</code> and a <code>FeatureType</code>. </p>
        /// <p>Valid <code>FeatureType</code>s are <code>Integral</code>, <code>Fractional</code> and
        /// <code>String</code>. </p>
        /// <p>
        /// <code>FeatureName</code>s cannot be any of the following: <code>is_deleted</code>,
        /// <code>write_time</code>, <code>api_invocation_time</code>.</p>
        /// <p>You can create up to 2,500 <code>FeatureDefinition</code>s per
        /// <code>FeatureGroup</code>.</p>
        pub fn set_feature_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FeatureDefinition>>,
        ) -> Self {
            self.feature_definitions = input;
            self
        }
        /// <p>The time a <code>FeatureGroup</code> was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time a <code>FeatureGroup</code> was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>Use this to specify the Amazon Web Services Key Management Service (KMS) Key ID, or
        /// <code>KMSKeyId</code>, for at rest data encryption. You can turn
        /// <code>OnlineStore</code> on or off by specifying the <code>EnableOnlineStore</code> flag
        /// at General Assembly; the default value is <code>False</code>.</p>
        pub fn online_store_config(mut self, input: crate::model::OnlineStoreConfig) -> Self {
            self.online_store_config = Some(input);
            self
        }
        /// <p>Use this to specify the Amazon Web Services Key Management Service (KMS) Key ID, or
        /// <code>KMSKeyId</code>, for at rest data encryption. You can turn
        /// <code>OnlineStore</code> on or off by specifying the <code>EnableOnlineStore</code> flag
        /// at General Assembly; the default value is <code>False</code>.</p>
        pub fn set_online_store_config(
            mut self,
            input: std::option::Option<crate::model::OnlineStoreConfig>,
        ) -> Self {
            self.online_store_config = input;
            self
        }
        /// <p>The configuration of an <code>OfflineStore</code>.</p>
        /// <p>Provide an <code>OfflineStoreConfig</code> in a request to
        /// <code>CreateFeatureGroup</code> to create an <code>OfflineStore</code>.</p>
        /// <p>To encrypt an <code>OfflineStore</code> using at rest data encryption, specify Amazon Web Services Key
        /// Management Service (KMS) key ID, or <code>KMSKeyId</code>, in
        /// <code>S3StorageConfig</code>.</p>
        pub fn offline_store_config(mut self, input: crate::model::OfflineStoreConfig) -> Self {
            self.offline_store_config = Some(input);
            self
        }
        /// <p>The configuration of an <code>OfflineStore</code>.</p>
        /// <p>Provide an <code>OfflineStoreConfig</code> in a request to
        /// <code>CreateFeatureGroup</code> to create an <code>OfflineStore</code>.</p>
        /// <p>To encrypt an <code>OfflineStore</code> using at rest data encryption, specify Amazon Web Services Key
        /// Management Service (KMS) key ID, or <code>KMSKeyId</code>, in
        /// <code>S3StorageConfig</code>.</p>
        pub fn set_offline_store_config(
            mut self,
            input: std::option::Option<crate::model::OfflineStoreConfig>,
        ) -> Self {
            self.offline_store_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM execution role used to create the feature
        /// group.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM execution role used to create the feature
        /// group.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>A <code>FeatureGroup</code> status.</p>
        pub fn feature_group_status(mut self, input: crate::model::FeatureGroupStatus) -> Self {
            self.feature_group_status = Some(input);
            self
        }
        /// <p>A <code>FeatureGroup</code> status.</p>
        pub fn set_feature_group_status(
            mut self,
            input: std::option::Option<crate::model::FeatureGroupStatus>,
        ) -> Self {
            self.feature_group_status = input;
            self
        }
        /// <p>The status of <code>OfflineStore</code>.</p>
        pub fn offline_store_status(mut self, input: crate::model::OfflineStoreStatus) -> Self {
            self.offline_store_status = Some(input);
            self
        }
        /// <p>The status of <code>OfflineStore</code>.</p>
        pub fn set_offline_store_status(
            mut self,
            input: std::option::Option<crate::model::OfflineStoreStatus>,
        ) -> Self {
            self.offline_store_status = input;
            self
        }
        /// <p>The reason that the <code>FeatureGroup</code> failed to
        /// be replicated in the <code>OfflineStore</code>. This is
        /// failure may be due to a failure to create a <code>FeatureGroup</code> in
        /// or delete a <code>FeatureGroup</code> from the <code>OfflineStore</code>.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>The reason that the <code>FeatureGroup</code> failed to
        /// be replicated in the <code>OfflineStore</code>. This is
        /// failure may be due to a failure to create a <code>FeatureGroup</code> in
        /// or delete a <code>FeatureGroup</code> from the <code>OfflineStore</code>.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>A free form description of a <code>FeatureGroup</code>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A free form description of a <code>FeatureGroup</code>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags used to define a <code>FeatureGroup</code>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Tags used to define a <code>FeatureGroup</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`FeatureGroup`](crate::model::FeatureGroup)
        pub fn build(self) -> crate::model::FeatureGroup {
            crate::model::FeatureGroup {
                feature_group_arn: self.feature_group_arn,
                feature_group_name: self.feature_group_name,
                record_identifier_feature_name: self.record_identifier_feature_name,
                event_time_feature_name: self.event_time_feature_name,
                feature_definitions: self.feature_definitions,
                creation_time: self.creation_time,
                online_store_config: self.online_store_config,
                offline_store_config: self.offline_store_config,
                role_arn: self.role_arn,
                feature_group_status: self.feature_group_status,
                offline_store_status: self.offline_store_status,
                failure_reason: self.failure_reason,
                description: self.description,
                tags: self.tags,
            }
        }
    }
}
impl FeatureGroup {
    /// Creates a new builder-style object to manufacture [`FeatureGroup`](crate::model::FeatureGroup)
    pub fn builder() -> crate::model::feature_group::Builder {
        crate::model::feature_group::Builder::default()
    }
}

/// <p>The status of <code>OfflineStore</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OfflineStoreStatus {
    /// <p>An <code>OfflineStore</code> status.</p>
    pub status: std::option::Option<crate::model::OfflineStoreStatusValue>,
    /// <p>The justification for why the OfflineStoreStatus is Blocked (if applicable).</p>
    pub blocked_reason: std::option::Option<std::string::String>,
}
impl OfflineStoreStatus {
    /// <p>An <code>OfflineStore</code> status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::OfflineStoreStatusValue> {
        self.status.as_ref()
    }
    /// <p>The justification for why the OfflineStoreStatus is Blocked (if applicable).</p>
    pub fn blocked_reason(&self) -> std::option::Option<&str> {
        self.blocked_reason.as_deref()
    }
}
impl std::fmt::Debug for OfflineStoreStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OfflineStoreStatus");
        formatter.field("status", &self.status);
        formatter.field("blocked_reason", &self.blocked_reason);
        formatter.finish()
    }
}
/// See [`OfflineStoreStatus`](crate::model::OfflineStoreStatus)
pub mod offline_store_status {
    /// A builder for [`OfflineStoreStatus`](crate::model::OfflineStoreStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::OfflineStoreStatusValue>,
        pub(crate) blocked_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An <code>OfflineStore</code> status.</p>
        pub fn status(mut self, input: crate::model::OfflineStoreStatusValue) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>An <code>OfflineStore</code> status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OfflineStoreStatusValue>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The justification for why the OfflineStoreStatus is Blocked (if applicable).</p>
        pub fn blocked_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.blocked_reason = Some(input.into());
            self
        }
        /// <p>The justification for why the OfflineStoreStatus is Blocked (if applicable).</p>
        pub fn set_blocked_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.blocked_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`OfflineStoreStatus`](crate::model::OfflineStoreStatus)
        pub fn build(self) -> crate::model::OfflineStoreStatus {
            crate::model::OfflineStoreStatus {
                status: self.status,
                blocked_reason: self.blocked_reason,
            }
        }
    }
}
impl OfflineStoreStatus {
    /// Creates a new builder-style object to manufacture [`OfflineStoreStatus`](crate::model::OfflineStoreStatus)
    pub fn builder() -> crate::model::offline_store_status::Builder {
        crate::model::offline_store_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OfflineStoreStatusValue {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Blocked,
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OfflineStoreStatusValue {
    fn from(s: &str) -> Self {
        match s {
            "Active" => OfflineStoreStatusValue::Active,
            "Blocked" => OfflineStoreStatusValue::Blocked,
            "Disabled" => OfflineStoreStatusValue::Disabled,
            other => OfflineStoreStatusValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OfflineStoreStatusValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OfflineStoreStatusValue::from(s))
    }
}
impl OfflineStoreStatusValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OfflineStoreStatusValue::Active => "Active",
            OfflineStoreStatusValue::Blocked => "Blocked",
            OfflineStoreStatusValue::Disabled => "Disabled",
            OfflineStoreStatusValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Active", "Blocked", "Disabled"]
    }
}
impl AsRef<str> for OfflineStoreStatusValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FeatureGroupStatus {
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    Created,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FeatureGroupStatus {
    fn from(s: &str) -> Self {
        match s {
            "CreateFailed" => FeatureGroupStatus::CreateFailed,
            "Created" => FeatureGroupStatus::Created,
            "Creating" => FeatureGroupStatus::Creating,
            "DeleteFailed" => FeatureGroupStatus::DeleteFailed,
            "Deleting" => FeatureGroupStatus::Deleting,
            other => FeatureGroupStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FeatureGroupStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FeatureGroupStatus::from(s))
    }
}
impl FeatureGroupStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FeatureGroupStatus::CreateFailed => "CreateFailed",
            FeatureGroupStatus::Created => "Created",
            FeatureGroupStatus::Creating => "Creating",
            FeatureGroupStatus::DeleteFailed => "DeleteFailed",
            FeatureGroupStatus::Deleting => "Deleting",
            FeatureGroupStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CreateFailed",
            "Created",
            "Creating",
            "DeleteFailed",
            "Deleting",
        ]
    }
}
impl AsRef<str> for FeatureGroupStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The configuration of an <code>OfflineStore</code>.</p>
/// <p>Provide an <code>OfflineStoreConfig</code> in a request to
/// <code>CreateFeatureGroup</code> to create an <code>OfflineStore</code>.</p>
/// <p>To encrypt an <code>OfflineStore</code> using at rest data encryption, specify Amazon Web Services Key
/// Management Service (KMS) key ID, or <code>KMSKeyId</code>, in
/// <code>S3StorageConfig</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OfflineStoreConfig {
    /// <p>The Amazon Simple Storage (Amazon S3) location of <code>OfflineStore</code>.</p>
    pub s3_storage_config: std::option::Option<crate::model::S3StorageConfig>,
    /// <p>Set to <code>True</code> to disable the automatic creation of an Amazon Web Services Glue table when
    /// configuring an <code>OfflineStore</code>.</p>
    pub disable_glue_table_creation: bool,
    /// <p>The meta data of the Glue table that is autogenerated when an <code>OfflineStore</code>
    /// is created. </p>
    pub data_catalog_config: std::option::Option<crate::model::DataCatalogConfig>,
}
impl OfflineStoreConfig {
    /// <p>The Amazon Simple Storage (Amazon S3) location of <code>OfflineStore</code>.</p>
    pub fn s3_storage_config(&self) -> std::option::Option<&crate::model::S3StorageConfig> {
        self.s3_storage_config.as_ref()
    }
    /// <p>Set to <code>True</code> to disable the automatic creation of an Amazon Web Services Glue table when
    /// configuring an <code>OfflineStore</code>.</p>
    pub fn disable_glue_table_creation(&self) -> bool {
        self.disable_glue_table_creation
    }
    /// <p>The meta data of the Glue table that is autogenerated when an <code>OfflineStore</code>
    /// is created. </p>
    pub fn data_catalog_config(&self) -> std::option::Option<&crate::model::DataCatalogConfig> {
        self.data_catalog_config.as_ref()
    }
}
impl std::fmt::Debug for OfflineStoreConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OfflineStoreConfig");
        formatter.field("s3_storage_config", &self.s3_storage_config);
        formatter.field(
            "disable_glue_table_creation",
            &self.disable_glue_table_creation,
        );
        formatter.field("data_catalog_config", &self.data_catalog_config);
        formatter.finish()
    }
}
/// See [`OfflineStoreConfig`](crate::model::OfflineStoreConfig)
pub mod offline_store_config {
    /// A builder for [`OfflineStoreConfig`](crate::model::OfflineStoreConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_storage_config: std::option::Option<crate::model::S3StorageConfig>,
        pub(crate) disable_glue_table_creation: std::option::Option<bool>,
        pub(crate) data_catalog_config: std::option::Option<crate::model::DataCatalogConfig>,
    }
    impl Builder {
        /// <p>The Amazon Simple Storage (Amazon S3) location of <code>OfflineStore</code>.</p>
        pub fn s3_storage_config(mut self, input: crate::model::S3StorageConfig) -> Self {
            self.s3_storage_config = Some(input);
            self
        }
        /// <p>The Amazon Simple Storage (Amazon S3) location of <code>OfflineStore</code>.</p>
        pub fn set_s3_storage_config(
            mut self,
            input: std::option::Option<crate::model::S3StorageConfig>,
        ) -> Self {
            self.s3_storage_config = input;
            self
        }
        /// <p>Set to <code>True</code> to disable the automatic creation of an Amazon Web Services Glue table when
        /// configuring an <code>OfflineStore</code>.</p>
        pub fn disable_glue_table_creation(mut self, input: bool) -> Self {
            self.disable_glue_table_creation = Some(input);
            self
        }
        /// <p>Set to <code>True</code> to disable the automatic creation of an Amazon Web Services Glue table when
        /// configuring an <code>OfflineStore</code>.</p>
        pub fn set_disable_glue_table_creation(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_glue_table_creation = input;
            self
        }
        /// <p>The meta data of the Glue table that is autogenerated when an <code>OfflineStore</code>
        /// is created. </p>
        pub fn data_catalog_config(mut self, input: crate::model::DataCatalogConfig) -> Self {
            self.data_catalog_config = Some(input);
            self
        }
        /// <p>The meta data of the Glue table that is autogenerated when an <code>OfflineStore</code>
        /// is created. </p>
        pub fn set_data_catalog_config(
            mut self,
            input: std::option::Option<crate::model::DataCatalogConfig>,
        ) -> Self {
            self.data_catalog_config = input;
            self
        }
        /// Consumes the builder and constructs a [`OfflineStoreConfig`](crate::model::OfflineStoreConfig)
        pub fn build(self) -> crate::model::OfflineStoreConfig {
            crate::model::OfflineStoreConfig {
                s3_storage_config: self.s3_storage_config,
                disable_glue_table_creation: self.disable_glue_table_creation.unwrap_or_default(),
                data_catalog_config: self.data_catalog_config,
            }
        }
    }
}
impl OfflineStoreConfig {
    /// Creates a new builder-style object to manufacture [`OfflineStoreConfig`](crate::model::OfflineStoreConfig)
    pub fn builder() -> crate::model::offline_store_config::Builder {
        crate::model::offline_store_config::Builder::default()
    }
}

/// <p>The meta data of the Glue table which serves as data catalog for the
/// <code>OfflineStore</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataCatalogConfig {
    /// <p>The name of the Glue table.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The name of the Glue table catalog.</p>
    pub catalog: std::option::Option<std::string::String>,
    /// <p>The name of the Glue table database.</p>
    pub database: std::option::Option<std::string::String>,
}
impl DataCatalogConfig {
    /// <p>The name of the Glue table.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The name of the Glue table catalog.</p>
    pub fn catalog(&self) -> std::option::Option<&str> {
        self.catalog.as_deref()
    }
    /// <p>The name of the Glue table database.</p>
    pub fn database(&self) -> std::option::Option<&str> {
        self.database.as_deref()
    }
}
impl std::fmt::Debug for DataCatalogConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataCatalogConfig");
        formatter.field("table_name", &self.table_name);
        formatter.field("catalog", &self.catalog);
        formatter.field("database", &self.database);
        formatter.finish()
    }
}
/// See [`DataCatalogConfig`](crate::model::DataCatalogConfig)
pub mod data_catalog_config {
    /// A builder for [`DataCatalogConfig`](crate::model::DataCatalogConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) catalog: std::option::Option<std::string::String>,
        pub(crate) database: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Glue table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the Glue table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The name of the Glue table catalog.</p>
        pub fn catalog(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog = Some(input.into());
            self
        }
        /// <p>The name of the Glue table catalog.</p>
        pub fn set_catalog(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog = input;
            self
        }
        /// <p>The name of the Glue table database.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.database = Some(input.into());
            self
        }
        /// <p>The name of the Glue table database.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database = input;
            self
        }
        /// Consumes the builder and constructs a [`DataCatalogConfig`](crate::model::DataCatalogConfig)
        pub fn build(self) -> crate::model::DataCatalogConfig {
            crate::model::DataCatalogConfig {
                table_name: self.table_name,
                catalog: self.catalog,
                database: self.database,
            }
        }
    }
}
impl DataCatalogConfig {
    /// Creates a new builder-style object to manufacture [`DataCatalogConfig`](crate::model::DataCatalogConfig)
    pub fn builder() -> crate::model::data_catalog_config::Builder {
        crate::model::data_catalog_config::Builder::default()
    }
}

/// <p>The Amazon Simple Storage (Amazon S3) location and and security configuration for <code>OfflineStore</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3StorageConfig {
    /// <p>The S3 URI, or location in Amazon S3, of <code>OfflineStore</code>.</p>
    /// <p>S3 URIs have a format similar to the following: <code>s3://example-bucket/prefix/</code>.</p>
    pub s3_uri: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Key Management Service (KMS) key ID of the key used to encrypt any objects
    /// written into the <code>OfflineStore</code> S3 location.</p>
    /// <p>The IAM <code>roleARN</code> that is passed as a parameter to
    /// <code>CreateFeatureGroup</code> must have below permissions to the
    /// <code>KmsKeyId</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>"kms:GenerateDataKey"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The S3 path where offline records are written.</p>
    pub resolved_output_s3_uri: std::option::Option<std::string::String>,
}
impl S3StorageConfig {
    /// <p>The S3 URI, or location in Amazon S3, of <code>OfflineStore</code>.</p>
    /// <p>S3 URIs have a format similar to the following: <code>s3://example-bucket/prefix/</code>.</p>
    pub fn s3_uri(&self) -> std::option::Option<&str> {
        self.s3_uri.as_deref()
    }
    /// <p>The Amazon Web Services Key Management Service (KMS) key ID of the key used to encrypt any objects
    /// written into the <code>OfflineStore</code> S3 location.</p>
    /// <p>The IAM <code>roleARN</code> that is passed as a parameter to
    /// <code>CreateFeatureGroup</code> must have below permissions to the
    /// <code>KmsKeyId</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>"kms:GenerateDataKey"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The S3 path where offline records are written.</p>
    pub fn resolved_output_s3_uri(&self) -> std::option::Option<&str> {
        self.resolved_output_s3_uri.as_deref()
    }
}
impl std::fmt::Debug for S3StorageConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3StorageConfig");
        formatter.field("s3_uri", &self.s3_uri);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("resolved_output_s3_uri", &self.resolved_output_s3_uri);
        formatter.finish()
    }
}
/// See [`S3StorageConfig`](crate::model::S3StorageConfig)
pub mod s3_storage_config {
    /// A builder for [`S3StorageConfig`](crate::model::S3StorageConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_uri: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) resolved_output_s3_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The S3 URI, or location in Amazon S3, of <code>OfflineStore</code>.</p>
        /// <p>S3 URIs have a format similar to the following: <code>s3://example-bucket/prefix/</code>.</p>
        pub fn s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_uri = Some(input.into());
            self
        }
        /// <p>The S3 URI, or location in Amazon S3, of <code>OfflineStore</code>.</p>
        /// <p>S3 URIs have a format similar to the following: <code>s3://example-bucket/prefix/</code>.</p>
        pub fn set_s3_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_uri = input;
            self
        }
        /// <p>The Amazon Web Services Key Management Service (KMS) key ID of the key used to encrypt any objects
        /// written into the <code>OfflineStore</code> S3 location.</p>
        /// <p>The IAM <code>roleARN</code> that is passed as a parameter to
        /// <code>CreateFeatureGroup</code> must have below permissions to the
        /// <code>KmsKeyId</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"kms:GenerateDataKey"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Key Management Service (KMS) key ID of the key used to encrypt any objects
        /// written into the <code>OfflineStore</code> S3 location.</p>
        /// <p>The IAM <code>roleARN</code> that is passed as a parameter to
        /// <code>CreateFeatureGroup</code> must have below permissions to the
        /// <code>KmsKeyId</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"kms:GenerateDataKey"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The S3 path where offline records are written.</p>
        pub fn resolved_output_s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolved_output_s3_uri = Some(input.into());
            self
        }
        /// <p>The S3 path where offline records are written.</p>
        pub fn set_resolved_output_s3_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolved_output_s3_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`S3StorageConfig`](crate::model::S3StorageConfig)
        pub fn build(self) -> crate::model::S3StorageConfig {
            crate::model::S3StorageConfig {
                s3_uri: self.s3_uri,
                kms_key_id: self.kms_key_id,
                resolved_output_s3_uri: self.resolved_output_s3_uri,
            }
        }
    }
}
impl S3StorageConfig {
    /// Creates a new builder-style object to manufacture [`S3StorageConfig`](crate::model::S3StorageConfig)
    pub fn builder() -> crate::model::s3_storage_config::Builder {
        crate::model::s3_storage_config::Builder::default()
    }
}

/// <p>Use this to specify the Amazon Web Services Key Management Service (KMS) Key ID, or
/// <code>KMSKeyId</code>, for at rest data encryption. You can turn
/// <code>OnlineStore</code> on or off by specifying the <code>EnableOnlineStore</code> flag
/// at General Assembly; the default value is <code>False</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OnlineStoreConfig {
    /// <p>Use to specify KMS Key ID (<code>KMSKeyId</code>) for at-rest encryption of your
    /// <code>OnlineStore</code>.</p>
    pub security_config: std::option::Option<crate::model::OnlineStoreSecurityConfig>,
    /// <p>Turn <code>OnlineStore</code> off by specifying <code>False</code>
    /// for the <code>EnableOnlineStore</code> flag. Turn <code>OnlineStore</code>
    /// on by specifying <code>True</code>
    /// for the <code>EnableOnlineStore</code> flag. </p>
    /// <p>The default value is <code>False</code>.</p>
    pub enable_online_store: bool,
}
impl OnlineStoreConfig {
    /// <p>Use to specify KMS Key ID (<code>KMSKeyId</code>) for at-rest encryption of your
    /// <code>OnlineStore</code>.</p>
    pub fn security_config(&self) -> std::option::Option<&crate::model::OnlineStoreSecurityConfig> {
        self.security_config.as_ref()
    }
    /// <p>Turn <code>OnlineStore</code> off by specifying <code>False</code>
    /// for the <code>EnableOnlineStore</code> flag. Turn <code>OnlineStore</code>
    /// on by specifying <code>True</code>
    /// for the <code>EnableOnlineStore</code> flag. </p>
    /// <p>The default value is <code>False</code>.</p>
    pub fn enable_online_store(&self) -> bool {
        self.enable_online_store
    }
}
impl std::fmt::Debug for OnlineStoreConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OnlineStoreConfig");
        formatter.field("security_config", &self.security_config);
        formatter.field("enable_online_store", &self.enable_online_store);
        formatter.finish()
    }
}
/// See [`OnlineStoreConfig`](crate::model::OnlineStoreConfig)
pub mod online_store_config {
    /// A builder for [`OnlineStoreConfig`](crate::model::OnlineStoreConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_config: std::option::Option<crate::model::OnlineStoreSecurityConfig>,
        pub(crate) enable_online_store: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Use to specify KMS Key ID (<code>KMSKeyId</code>) for at-rest encryption of your
        /// <code>OnlineStore</code>.</p>
        pub fn security_config(mut self, input: crate::model::OnlineStoreSecurityConfig) -> Self {
            self.security_config = Some(input);
            self
        }
        /// <p>Use to specify KMS Key ID (<code>KMSKeyId</code>) for at-rest encryption of your
        /// <code>OnlineStore</code>.</p>
        pub fn set_security_config(
            mut self,
            input: std::option::Option<crate::model::OnlineStoreSecurityConfig>,
        ) -> Self {
            self.security_config = input;
            self
        }
        /// <p>Turn <code>OnlineStore</code> off by specifying <code>False</code>
        /// for the <code>EnableOnlineStore</code> flag. Turn <code>OnlineStore</code>
        /// on by specifying <code>True</code>
        /// for the <code>EnableOnlineStore</code> flag. </p>
        /// <p>The default value is <code>False</code>.</p>
        pub fn enable_online_store(mut self, input: bool) -> Self {
            self.enable_online_store = Some(input);
            self
        }
        /// <p>Turn <code>OnlineStore</code> off by specifying <code>False</code>
        /// for the <code>EnableOnlineStore</code> flag. Turn <code>OnlineStore</code>
        /// on by specifying <code>True</code>
        /// for the <code>EnableOnlineStore</code> flag. </p>
        /// <p>The default value is <code>False</code>.</p>
        pub fn set_enable_online_store(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_online_store = input;
            self
        }
        /// Consumes the builder and constructs a [`OnlineStoreConfig`](crate::model::OnlineStoreConfig)
        pub fn build(self) -> crate::model::OnlineStoreConfig {
            crate::model::OnlineStoreConfig {
                security_config: self.security_config,
                enable_online_store: self.enable_online_store.unwrap_or_default(),
            }
        }
    }
}
impl OnlineStoreConfig {
    /// Creates a new builder-style object to manufacture [`OnlineStoreConfig`](crate::model::OnlineStoreConfig)
    pub fn builder() -> crate::model::online_store_config::Builder {
        crate::model::online_store_config::Builder::default()
    }
}

/// <p>The security configuration for <code>OnlineStore</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OnlineStoreSecurityConfig {
    /// <p>The ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) key that SageMaker Feature Store uses
    /// to encrypt the Amazon S3 objects at rest using Amazon S3 server-side encryption.</p>
    /// <p>The caller (either IAM user or IAM role) of <code>CreateFeatureGroup</code> must have
    /// below permissions to the <code>OnlineStore</code>
    /// <code>KmsKeyId</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>"kms:Encrypt"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"kms:Decrypt"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"kms:DescribeKey"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"kms:CreateGrant"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"kms:RetireGrant"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"kms:ReEncryptFrom"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"kms:ReEncryptTo"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"kms:GenerateDataKey"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"kms:ListAliases"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"kms:ListGrants"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"kms:RevokeGrant"</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>The caller (either IAM user or IAM role) to all DataPlane operations
    /// (<code>PutRecord</code>, <code>GetRecord</code>, <code>DeleteRecord</code>) must have
    /// the following permissions to the <code>KmsKeyId</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>"kms:Decrypt"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub kms_key_id: std::option::Option<std::string::String>,
}
impl OnlineStoreSecurityConfig {
    /// <p>The ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) key that SageMaker Feature Store uses
    /// to encrypt the Amazon S3 objects at rest using Amazon S3 server-side encryption.</p>
    /// <p>The caller (either IAM user or IAM role) of <code>CreateFeatureGroup</code> must have
    /// below permissions to the <code>OnlineStore</code>
    /// <code>KmsKeyId</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>"kms:Encrypt"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"kms:Decrypt"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"kms:DescribeKey"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"kms:CreateGrant"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"kms:RetireGrant"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"kms:ReEncryptFrom"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"kms:ReEncryptTo"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"kms:GenerateDataKey"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"kms:ListAliases"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"kms:ListGrants"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"kms:RevokeGrant"</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>The caller (either IAM user or IAM role) to all DataPlane operations
    /// (<code>PutRecord</code>, <code>GetRecord</code>, <code>DeleteRecord</code>) must have
    /// the following permissions to the <code>KmsKeyId</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>"kms:Decrypt"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
}
impl std::fmt::Debug for OnlineStoreSecurityConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OnlineStoreSecurityConfig");
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.finish()
    }
}
/// See [`OnlineStoreSecurityConfig`](crate::model::OnlineStoreSecurityConfig)
pub mod online_store_security_config {
    /// A builder for [`OnlineStoreSecurityConfig`](crate::model::OnlineStoreSecurityConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) key that SageMaker Feature Store uses
        /// to encrypt the Amazon S3 objects at rest using Amazon S3 server-side encryption.</p>
        /// <p>The caller (either IAM user or IAM role) of <code>CreateFeatureGroup</code> must have
        /// below permissions to the <code>OnlineStore</code>
        /// <code>KmsKeyId</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"kms:Encrypt"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"kms:Decrypt"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"kms:DescribeKey"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"kms:CreateGrant"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"kms:RetireGrant"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"kms:ReEncryptFrom"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"kms:ReEncryptTo"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"kms:GenerateDataKey"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"kms:ListAliases"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"kms:ListGrants"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"kms:RevokeGrant"</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The caller (either IAM user or IAM role) to all DataPlane operations
        /// (<code>PutRecord</code>, <code>GetRecord</code>, <code>DeleteRecord</code>) must have
        /// the following permissions to the <code>KmsKeyId</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"kms:Decrypt"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) key that SageMaker Feature Store uses
        /// to encrypt the Amazon S3 objects at rest using Amazon S3 server-side encryption.</p>
        /// <p>The caller (either IAM user or IAM role) of <code>CreateFeatureGroup</code> must have
        /// below permissions to the <code>OnlineStore</code>
        /// <code>KmsKeyId</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"kms:Encrypt"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"kms:Decrypt"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"kms:DescribeKey"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"kms:CreateGrant"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"kms:RetireGrant"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"kms:ReEncryptFrom"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"kms:ReEncryptTo"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"kms:GenerateDataKey"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"kms:ListAliases"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"kms:ListGrants"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"kms:RevokeGrant"</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The caller (either IAM user or IAM role) to all DataPlane operations
        /// (<code>PutRecord</code>, <code>GetRecord</code>, <code>DeleteRecord</code>) must have
        /// the following permissions to the <code>KmsKeyId</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"kms:Decrypt"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`OnlineStoreSecurityConfig`](crate::model::OnlineStoreSecurityConfig)
        pub fn build(self) -> crate::model::OnlineStoreSecurityConfig {
            crate::model::OnlineStoreSecurityConfig {
                kms_key_id: self.kms_key_id,
            }
        }
    }
}
impl OnlineStoreSecurityConfig {
    /// Creates a new builder-style object to manufacture [`OnlineStoreSecurityConfig`](crate::model::OnlineStoreSecurityConfig)
    pub fn builder() -> crate::model::online_store_security_config::Builder {
        crate::model::online_store_security_config::Builder::default()
    }
}

/// <p>A list of features. You must include <code>FeatureName</code> and
/// <code>FeatureType</code>. Valid feature <code>FeatureType</code>s are
/// <code>Integral</code>, <code>Fractional</code> and <code>String</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FeatureDefinition {
    /// <p>The name of a feature. The type must be a string. <code>FeatureName</code> cannot be any
    /// of the following: <code>is_deleted</code>, <code>write_time</code>,
    /// <code>api_invocation_time</code>.</p>
    pub feature_name: std::option::Option<std::string::String>,
    /// <p>The value type of a feature. Valid values are Integral, Fractional, or String.</p>
    pub feature_type: std::option::Option<crate::model::FeatureType>,
}
impl FeatureDefinition {
    /// <p>The name of a feature. The type must be a string. <code>FeatureName</code> cannot be any
    /// of the following: <code>is_deleted</code>, <code>write_time</code>,
    /// <code>api_invocation_time</code>.</p>
    pub fn feature_name(&self) -> std::option::Option<&str> {
        self.feature_name.as_deref()
    }
    /// <p>The value type of a feature. Valid values are Integral, Fractional, or String.</p>
    pub fn feature_type(&self) -> std::option::Option<&crate::model::FeatureType> {
        self.feature_type.as_ref()
    }
}
impl std::fmt::Debug for FeatureDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FeatureDefinition");
        formatter.field("feature_name", &self.feature_name);
        formatter.field("feature_type", &self.feature_type);
        formatter.finish()
    }
}
/// See [`FeatureDefinition`](crate::model::FeatureDefinition)
pub mod feature_definition {
    /// A builder for [`FeatureDefinition`](crate::model::FeatureDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) feature_name: std::option::Option<std::string::String>,
        pub(crate) feature_type: std::option::Option<crate::model::FeatureType>,
    }
    impl Builder {
        /// <p>The name of a feature. The type must be a string. <code>FeatureName</code> cannot be any
        /// of the following: <code>is_deleted</code>, <code>write_time</code>,
        /// <code>api_invocation_time</code>.</p>
        pub fn feature_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.feature_name = Some(input.into());
            self
        }
        /// <p>The name of a feature. The type must be a string. <code>FeatureName</code> cannot be any
        /// of the following: <code>is_deleted</code>, <code>write_time</code>,
        /// <code>api_invocation_time</code>.</p>
        pub fn set_feature_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.feature_name = input;
            self
        }
        /// <p>The value type of a feature. Valid values are Integral, Fractional, or String.</p>
        pub fn feature_type(mut self, input: crate::model::FeatureType) -> Self {
            self.feature_type = Some(input);
            self
        }
        /// <p>The value type of a feature. Valid values are Integral, Fractional, or String.</p>
        pub fn set_feature_type(
            mut self,
            input: std::option::Option<crate::model::FeatureType>,
        ) -> Self {
            self.feature_type = input;
            self
        }
        /// Consumes the builder and constructs a [`FeatureDefinition`](crate::model::FeatureDefinition)
        pub fn build(self) -> crate::model::FeatureDefinition {
            crate::model::FeatureDefinition {
                feature_name: self.feature_name,
                feature_type: self.feature_type,
            }
        }
    }
}
impl FeatureDefinition {
    /// Creates a new builder-style object to manufacture [`FeatureDefinition`](crate::model::FeatureDefinition)
    pub fn builder() -> crate::model::feature_definition::Builder {
        crate::model::feature_definition::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FeatureType {
    #[allow(missing_docs)] // documentation missing in model
    Fractional,
    #[allow(missing_docs)] // documentation missing in model
    Integral,
    #[allow(missing_docs)] // documentation missing in model
    String,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FeatureType {
    fn from(s: &str) -> Self {
        match s {
            "Fractional" => FeatureType::Fractional,
            "Integral" => FeatureType::Integral,
            "String" => FeatureType::String,
            other => FeatureType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FeatureType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FeatureType::from(s))
    }
}
impl FeatureType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FeatureType::Fractional => "Fractional",
            FeatureType::Integral => "Integral",
            FeatureType::String => "String",
            FeatureType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Fractional", "Integral", "String"]
    }
}
impl AsRef<str> for FeatureType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An execution of a pipeline.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PipelineExecution {
    /// <p>The Amazon Resource Name (ARN) of the pipeline that was executed.</p>
    pub pipeline_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
    pub pipeline_execution_arn: std::option::Option<std::string::String>,
    /// <p>The display name of the pipeline execution.</p>
    pub pipeline_execution_display_name: std::option::Option<std::string::String>,
    /// <p>The status of the pipeline status.</p>
    pub pipeline_execution_status: std::option::Option<crate::model::PipelineExecutionStatus>,
    /// <p>The description of the pipeline execution.</p>
    pub pipeline_execution_description: std::option::Option<std::string::String>,
    /// <p>Specifies the names of the experiment and trial created by a pipeline.</p>
    pub pipeline_experiment_config: std::option::Option<crate::model::PipelineExperimentConfig>,
    /// <p>If the execution failed, a message describing why.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The creation time of the pipeline execution.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time that the pipeline execution was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Information about the user who created or modified an experiment, trial, trial
    /// component, lineage group, or project.</p>
    pub created_by: std::option::Option<crate::model::UserContext>,
    /// <p>Information about the user who created or modified an experiment, trial, trial
    /// component, lineage group, or project.</p>
    pub last_modified_by: std::option::Option<crate::model::UserContext>,
    /// <p>Contains a list of pipeline parameters. This list can be empty. </p>
    pub pipeline_parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
}
impl PipelineExecution {
    /// <p>The Amazon Resource Name (ARN) of the pipeline that was executed.</p>
    pub fn pipeline_arn(&self) -> std::option::Option<&str> {
        self.pipeline_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
    pub fn pipeline_execution_arn(&self) -> std::option::Option<&str> {
        self.pipeline_execution_arn.as_deref()
    }
    /// <p>The display name of the pipeline execution.</p>
    pub fn pipeline_execution_display_name(&self) -> std::option::Option<&str> {
        self.pipeline_execution_display_name.as_deref()
    }
    /// <p>The status of the pipeline status.</p>
    pub fn pipeline_execution_status(
        &self,
    ) -> std::option::Option<&crate::model::PipelineExecutionStatus> {
        self.pipeline_execution_status.as_ref()
    }
    /// <p>The description of the pipeline execution.</p>
    pub fn pipeline_execution_description(&self) -> std::option::Option<&str> {
        self.pipeline_execution_description.as_deref()
    }
    /// <p>Specifies the names of the experiment and trial created by a pipeline.</p>
    pub fn pipeline_experiment_config(
        &self,
    ) -> std::option::Option<&crate::model::PipelineExperimentConfig> {
        self.pipeline_experiment_config.as_ref()
    }
    /// <p>If the execution failed, a message describing why.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The creation time of the pipeline execution.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The time that the pipeline execution was last modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>Information about the user who created or modified an experiment, trial, trial
    /// component, lineage group, or project.</p>
    pub fn created_by(&self) -> std::option::Option<&crate::model::UserContext> {
        self.created_by.as_ref()
    }
    /// <p>Information about the user who created or modified an experiment, trial, trial
    /// component, lineage group, or project.</p>
    pub fn last_modified_by(&self) -> std::option::Option<&crate::model::UserContext> {
        self.last_modified_by.as_ref()
    }
    /// <p>Contains a list of pipeline parameters. This list can be empty. </p>
    pub fn pipeline_parameters(&self) -> std::option::Option<&[crate::model::Parameter]> {
        self.pipeline_parameters.as_deref()
    }
}
impl std::fmt::Debug for PipelineExecution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PipelineExecution");
        formatter.field("pipeline_arn", &self.pipeline_arn);
        formatter.field("pipeline_execution_arn", &self.pipeline_execution_arn);
        formatter.field(
            "pipeline_execution_display_name",
            &self.pipeline_execution_display_name,
        );
        formatter.field("pipeline_execution_status", &self.pipeline_execution_status);
        formatter.field(
            "pipeline_execution_description",
            &self.pipeline_execution_description,
        );
        formatter.field(
            "pipeline_experiment_config",
            &self.pipeline_experiment_config,
        );
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("created_by", &self.created_by);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("pipeline_parameters", &self.pipeline_parameters);
        formatter.finish()
    }
}
/// See [`PipelineExecution`](crate::model::PipelineExecution)
pub mod pipeline_execution {
    /// A builder for [`PipelineExecution`](crate::model::PipelineExecution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_arn: std::option::Option<std::string::String>,
        pub(crate) pipeline_execution_arn: std::option::Option<std::string::String>,
        pub(crate) pipeline_execution_display_name: std::option::Option<std::string::String>,
        pub(crate) pipeline_execution_status:
            std::option::Option<crate::model::PipelineExecutionStatus>,
        pub(crate) pipeline_execution_description: std::option::Option<std::string::String>,
        pub(crate) pipeline_experiment_config:
            std::option::Option<crate::model::PipelineExperimentConfig>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_by: std::option::Option<crate::model::UserContext>,
        pub(crate) last_modified_by: std::option::Option<crate::model::UserContext>,
        pub(crate) pipeline_parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the pipeline that was executed.</p>
        pub fn pipeline_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the pipeline that was executed.</p>
        pub fn set_pipeline_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pipeline_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
        pub fn pipeline_execution_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_execution_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the pipeline execution.</p>
        pub fn set_pipeline_execution_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_execution_arn = input;
            self
        }
        /// <p>The display name of the pipeline execution.</p>
        pub fn pipeline_execution_display_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.pipeline_execution_display_name = Some(input.into());
            self
        }
        /// <p>The display name of the pipeline execution.</p>
        pub fn set_pipeline_execution_display_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_execution_display_name = input;
            self
        }
        /// <p>The status of the pipeline status.</p>
        pub fn pipeline_execution_status(
            mut self,
            input: crate::model::PipelineExecutionStatus,
        ) -> Self {
            self.pipeline_execution_status = Some(input);
            self
        }
        /// <p>The status of the pipeline status.</p>
        pub fn set_pipeline_execution_status(
            mut self,
            input: std::option::Option<crate::model::PipelineExecutionStatus>,
        ) -> Self {
            self.pipeline_execution_status = input;
            self
        }
        /// <p>The description of the pipeline execution.</p>
        pub fn pipeline_execution_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.pipeline_execution_description = Some(input.into());
            self
        }
        /// <p>The description of the pipeline execution.</p>
        pub fn set_pipeline_execution_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_execution_description = input;
            self
        }
        /// <p>Specifies the names of the experiment and trial created by a pipeline.</p>
        pub fn pipeline_experiment_config(
            mut self,
            input: crate::model::PipelineExperimentConfig,
        ) -> Self {
            self.pipeline_experiment_config = Some(input);
            self
        }
        /// <p>Specifies the names of the experiment and trial created by a pipeline.</p>
        pub fn set_pipeline_experiment_config(
            mut self,
            input: std::option::Option<crate::model::PipelineExperimentConfig>,
        ) -> Self {
            self.pipeline_experiment_config = input;
            self
        }
        /// <p>If the execution failed, a message describing why.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If the execution failed, a message describing why.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The creation time of the pipeline execution.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The creation time of the pipeline execution.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time that the pipeline execution was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The time that the pipeline execution was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial
        /// component, lineage group, or project.</p>
        pub fn created_by(mut self, input: crate::model::UserContext) -> Self {
            self.created_by = Some(input);
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial
        /// component, lineage group, or project.</p>
        pub fn set_created_by(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.created_by = input;
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial
        /// component, lineage group, or project.</p>
        pub fn last_modified_by(mut self, input: crate::model::UserContext) -> Self {
            self.last_modified_by = Some(input);
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial
        /// component, lineage group, or project.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// Appends an item to `pipeline_parameters`.
        ///
        /// To override the contents of this collection use [`set_pipeline_parameters`](Self::set_pipeline_parameters).
        ///
        /// <p>Contains a list of pipeline parameters. This list can be empty. </p>
        pub fn pipeline_parameters(mut self, input: impl Into<crate::model::Parameter>) -> Self {
            let mut v = self.pipeline_parameters.unwrap_or_default();
            v.push(input.into());
            self.pipeline_parameters = Some(v);
            self
        }
        /// <p>Contains a list of pipeline parameters. This list can be empty. </p>
        pub fn set_pipeline_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.pipeline_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`PipelineExecution`](crate::model::PipelineExecution)
        pub fn build(self) -> crate::model::PipelineExecution {
            crate::model::PipelineExecution {
                pipeline_arn: self.pipeline_arn,
                pipeline_execution_arn: self.pipeline_execution_arn,
                pipeline_execution_display_name: self.pipeline_execution_display_name,
                pipeline_execution_status: self.pipeline_execution_status,
                pipeline_execution_description: self.pipeline_execution_description,
                pipeline_experiment_config: self.pipeline_experiment_config,
                failure_reason: self.failure_reason,
                creation_time: self.creation_time,
                last_modified_time: self.last_modified_time,
                created_by: self.created_by,
                last_modified_by: self.last_modified_by,
                pipeline_parameters: self.pipeline_parameters,
            }
        }
    }
}
impl PipelineExecution {
    /// Creates a new builder-style object to manufacture [`PipelineExecution`](crate::model::PipelineExecution)
    pub fn builder() -> crate::model::pipeline_execution::Builder {
        crate::model::pipeline_execution::Builder::default()
    }
}

/// <p>Specifies the names of the experiment and trial created by a pipeline.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PipelineExperimentConfig {
    /// <p>The name of the experiment.</p>
    pub experiment_name: std::option::Option<std::string::String>,
    /// <p>The name of the trial.</p>
    pub trial_name: std::option::Option<std::string::String>,
}
impl PipelineExperimentConfig {
    /// <p>The name of the experiment.</p>
    pub fn experiment_name(&self) -> std::option::Option<&str> {
        self.experiment_name.as_deref()
    }
    /// <p>The name of the trial.</p>
    pub fn trial_name(&self) -> std::option::Option<&str> {
        self.trial_name.as_deref()
    }
}
impl std::fmt::Debug for PipelineExperimentConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PipelineExperimentConfig");
        formatter.field("experiment_name", &self.experiment_name);
        formatter.field("trial_name", &self.trial_name);
        formatter.finish()
    }
}
/// See [`PipelineExperimentConfig`](crate::model::PipelineExperimentConfig)
pub mod pipeline_experiment_config {
    /// A builder for [`PipelineExperimentConfig`](crate::model::PipelineExperimentConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) experiment_name: std::option::Option<std::string::String>,
        pub(crate) trial_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the experiment.</p>
        pub fn experiment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.experiment_name = Some(input.into());
            self
        }
        /// <p>The name of the experiment.</p>
        pub fn set_experiment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.experiment_name = input;
            self
        }
        /// <p>The name of the trial.</p>
        pub fn trial_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.trial_name = Some(input.into());
            self
        }
        /// <p>The name of the trial.</p>
        pub fn set_trial_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trial_name = input;
            self
        }
        /// Consumes the builder and constructs a [`PipelineExperimentConfig`](crate::model::PipelineExperimentConfig)
        pub fn build(self) -> crate::model::PipelineExperimentConfig {
            crate::model::PipelineExperimentConfig {
                experiment_name: self.experiment_name,
                trial_name: self.trial_name,
            }
        }
    }
}
impl PipelineExperimentConfig {
    /// Creates a new builder-style object to manufacture [`PipelineExperimentConfig`](crate::model::PipelineExperimentConfig)
    pub fn builder() -> crate::model::pipeline_experiment_config::Builder {
        crate::model::pipeline_experiment_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PipelineExecutionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Executing,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PipelineExecutionStatus {
    fn from(s: &str) -> Self {
        match s {
            "Executing" => PipelineExecutionStatus::Executing,
            "Failed" => PipelineExecutionStatus::Failed,
            "Stopped" => PipelineExecutionStatus::Stopped,
            "Stopping" => PipelineExecutionStatus::Stopping,
            "Succeeded" => PipelineExecutionStatus::Succeeded,
            other => PipelineExecutionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PipelineExecutionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PipelineExecutionStatus::from(s))
    }
}
impl PipelineExecutionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PipelineExecutionStatus::Executing => "Executing",
            PipelineExecutionStatus::Failed => "Failed",
            PipelineExecutionStatus::Stopped => "Stopped",
            PipelineExecutionStatus::Stopping => "Stopping",
            PipelineExecutionStatus::Succeeded => "Succeeded",
            PipelineExecutionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Executing", "Failed", "Stopped", "Stopping", "Succeeded"]
    }
}
impl AsRef<str> for PipelineExecutionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A SageMaker Model Building Pipeline instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Pipeline {
    /// <p>The Amazon Resource Name (ARN) of the pipeline.</p>
    pub pipeline_arn: std::option::Option<std::string::String>,
    /// <p>The name of the pipeline.</p>
    pub pipeline_name: std::option::Option<std::string::String>,
    /// <p>The display name of the pipeline.</p>
    pub pipeline_display_name: std::option::Option<std::string::String>,
    /// <p>The description of the pipeline.</p>
    pub pipeline_description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the role that created the pipeline.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The status of the pipeline.</p>
    pub pipeline_status: std::option::Option<crate::model::PipelineStatus>,
    /// <p>The creation time of the pipeline.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time that the pipeline was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the pipeline was last run.</p>
    pub last_run_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Information about the user who created or modified an experiment, trial, trial
    /// component, lineage group, or project.</p>
    pub created_by: std::option::Option<crate::model::UserContext>,
    /// <p>Information about the user who created or modified an experiment, trial, trial
    /// component, lineage group, or project.</p>
    pub last_modified_by: std::option::Option<crate::model::UserContext>,
    /// <p>A list of tags that apply to the pipeline.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl Pipeline {
    /// <p>The Amazon Resource Name (ARN) of the pipeline.</p>
    pub fn pipeline_arn(&self) -> std::option::Option<&str> {
        self.pipeline_arn.as_deref()
    }
    /// <p>The name of the pipeline.</p>
    pub fn pipeline_name(&self) -> std::option::Option<&str> {
        self.pipeline_name.as_deref()
    }
    /// <p>The display name of the pipeline.</p>
    pub fn pipeline_display_name(&self) -> std::option::Option<&str> {
        self.pipeline_display_name.as_deref()
    }
    /// <p>The description of the pipeline.</p>
    pub fn pipeline_description(&self) -> std::option::Option<&str> {
        self.pipeline_description.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the role that created the pipeline.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The status of the pipeline.</p>
    pub fn pipeline_status(&self) -> std::option::Option<&crate::model::PipelineStatus> {
        self.pipeline_status.as_ref()
    }
    /// <p>The creation time of the pipeline.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The time that the pipeline was last modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>The time when the pipeline was last run.</p>
    pub fn last_run_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_run_time.as_ref()
    }
    /// <p>Information about the user who created or modified an experiment, trial, trial
    /// component, lineage group, or project.</p>
    pub fn created_by(&self) -> std::option::Option<&crate::model::UserContext> {
        self.created_by.as_ref()
    }
    /// <p>Information about the user who created or modified an experiment, trial, trial
    /// component, lineage group, or project.</p>
    pub fn last_modified_by(&self) -> std::option::Option<&crate::model::UserContext> {
        self.last_modified_by.as_ref()
    }
    /// <p>A list of tags that apply to the pipeline.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for Pipeline {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Pipeline");
        formatter.field("pipeline_arn", &self.pipeline_arn);
        formatter.field("pipeline_name", &self.pipeline_name);
        formatter.field("pipeline_display_name", &self.pipeline_display_name);
        formatter.field("pipeline_description", &self.pipeline_description);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("pipeline_status", &self.pipeline_status);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("last_run_time", &self.last_run_time);
        formatter.field("created_by", &self.created_by);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Pipeline`](crate::model::Pipeline)
pub mod pipeline {
    /// A builder for [`Pipeline`](crate::model::Pipeline)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_arn: std::option::Option<std::string::String>,
        pub(crate) pipeline_name: std::option::Option<std::string::String>,
        pub(crate) pipeline_display_name: std::option::Option<std::string::String>,
        pub(crate) pipeline_description: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) pipeline_status: std::option::Option<crate::model::PipelineStatus>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_run_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_by: std::option::Option<crate::model::UserContext>,
        pub(crate) last_modified_by: std::option::Option<crate::model::UserContext>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the pipeline.</p>
        pub fn pipeline_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the pipeline.</p>
        pub fn set_pipeline_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pipeline_arn = input;
            self
        }
        /// <p>The name of the pipeline.</p>
        pub fn pipeline_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_name = Some(input.into());
            self
        }
        /// <p>The name of the pipeline.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_name = input;
            self
        }
        /// <p>The display name of the pipeline.</p>
        pub fn pipeline_display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_display_name = Some(input.into());
            self
        }
        /// <p>The display name of the pipeline.</p>
        pub fn set_pipeline_display_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_display_name = input;
            self
        }
        /// <p>The description of the pipeline.</p>
        pub fn pipeline_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_description = Some(input.into());
            self
        }
        /// <p>The description of the pipeline.</p>
        pub fn set_pipeline_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role that created the pipeline.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role that created the pipeline.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The status of the pipeline.</p>
        pub fn pipeline_status(mut self, input: crate::model::PipelineStatus) -> Self {
            self.pipeline_status = Some(input);
            self
        }
        /// <p>The status of the pipeline.</p>
        pub fn set_pipeline_status(
            mut self,
            input: std::option::Option<crate::model::PipelineStatus>,
        ) -> Self {
            self.pipeline_status = input;
            self
        }
        /// <p>The creation time of the pipeline.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The creation time of the pipeline.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time that the pipeline was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The time that the pipeline was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>The time when the pipeline was last run.</p>
        pub fn last_run_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_run_time = Some(input);
            self
        }
        /// <p>The time when the pipeline was last run.</p>
        pub fn set_last_run_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_run_time = input;
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial
        /// component, lineage group, or project.</p>
        pub fn created_by(mut self, input: crate::model::UserContext) -> Self {
            self.created_by = Some(input);
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial
        /// component, lineage group, or project.</p>
        pub fn set_created_by(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.created_by = input;
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial
        /// component, lineage group, or project.</p>
        pub fn last_modified_by(mut self, input: crate::model::UserContext) -> Self {
            self.last_modified_by = Some(input);
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial
        /// component, lineage group, or project.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that apply to the pipeline.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags that apply to the pipeline.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Pipeline`](crate::model::Pipeline)
        pub fn build(self) -> crate::model::Pipeline {
            crate::model::Pipeline {
                pipeline_arn: self.pipeline_arn,
                pipeline_name: self.pipeline_name,
                pipeline_display_name: self.pipeline_display_name,
                pipeline_description: self.pipeline_description,
                role_arn: self.role_arn,
                pipeline_status: self.pipeline_status,
                creation_time: self.creation_time,
                last_modified_time: self.last_modified_time,
                last_run_time: self.last_run_time,
                created_by: self.created_by,
                last_modified_by: self.last_modified_by,
                tags: self.tags,
            }
        }
    }
}
impl Pipeline {
    /// Creates a new builder-style object to manufacture [`Pipeline`](crate::model::Pipeline)
    pub fn builder() -> crate::model::pipeline::Builder {
        crate::model::pipeline::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PipelineStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PipelineStatus {
    fn from(s: &str) -> Self {
        match s {
            "Active" => PipelineStatus::Active,
            other => PipelineStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PipelineStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PipelineStatus::from(s))
    }
}
impl PipelineStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PipelineStatus::Active => "Active",
            PipelineStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Active"]
    }
}
impl AsRef<str> for PipelineStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A group of versioned models in the model registry.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModelPackageGroup {
    /// <p>The name of the model group.</p>
    pub model_package_group_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the model group.</p>
    pub model_package_group_arn: std::option::Option<std::string::String>,
    /// <p>The description for the model group.</p>
    pub model_package_group_description: std::option::Option<std::string::String>,
    /// <p>The time that the model group was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Information about the user who created or modified an experiment, trial, trial
    /// component, lineage group, or project.</p>
    pub created_by: std::option::Option<crate::model::UserContext>,
    /// <p>The status of the model group. This can be one of the following values.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PENDING</code> - The model group is pending being created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code> - The model group is in the process of being
    /// created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMPLETED</code> - The model group was successfully created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - The model group failed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETING</code> - The model group is in the process of being deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_FAILED</code> - SageMaker failed to delete the model group.</p>
    /// </li>
    /// </ul>
    pub model_package_group_status: std::option::Option<crate::model::ModelPackageGroupStatus>,
    /// <p>A list of the tags associated with the model group. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
    /// resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ModelPackageGroup {
    /// <p>The name of the model group.</p>
    pub fn model_package_group_name(&self) -> std::option::Option<&str> {
        self.model_package_group_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the model group.</p>
    pub fn model_package_group_arn(&self) -> std::option::Option<&str> {
        self.model_package_group_arn.as_deref()
    }
    /// <p>The description for the model group.</p>
    pub fn model_package_group_description(&self) -> std::option::Option<&str> {
        self.model_package_group_description.as_deref()
    }
    /// <p>The time that the model group was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>Information about the user who created or modified an experiment, trial, trial
    /// component, lineage group, or project.</p>
    pub fn created_by(&self) -> std::option::Option<&crate::model::UserContext> {
        self.created_by.as_ref()
    }
    /// <p>The status of the model group. This can be one of the following values.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PENDING</code> - The model group is pending being created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code> - The model group is in the process of being
    /// created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMPLETED</code> - The model group was successfully created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - The model group failed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETING</code> - The model group is in the process of being deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETE_FAILED</code> - SageMaker failed to delete the model group.</p>
    /// </li>
    /// </ul>
    pub fn model_package_group_status(
        &self,
    ) -> std::option::Option<&crate::model::ModelPackageGroupStatus> {
        self.model_package_group_status.as_ref()
    }
    /// <p>A list of the tags associated with the model group. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
    /// resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ModelPackageGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModelPackageGroup");
        formatter.field("model_package_group_name", &self.model_package_group_name);
        formatter.field("model_package_group_arn", &self.model_package_group_arn);
        formatter.field(
            "model_package_group_description",
            &self.model_package_group_description,
        );
        formatter.field("creation_time", &self.creation_time);
        formatter.field("created_by", &self.created_by);
        formatter.field(
            "model_package_group_status",
            &self.model_package_group_status,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ModelPackageGroup`](crate::model::ModelPackageGroup)
pub mod model_package_group {
    /// A builder for [`ModelPackageGroup`](crate::model::ModelPackageGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_package_group_name: std::option::Option<std::string::String>,
        pub(crate) model_package_group_arn: std::option::Option<std::string::String>,
        pub(crate) model_package_group_description: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_by: std::option::Option<crate::model::UserContext>,
        pub(crate) model_package_group_status:
            std::option::Option<crate::model::ModelPackageGroupStatus>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the model group.</p>
        pub fn model_package_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_package_group_name = Some(input.into());
            self
        }
        /// <p>The name of the model group.</p>
        pub fn set_model_package_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_package_group_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model group.</p>
        pub fn model_package_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_package_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model group.</p>
        pub fn set_model_package_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_package_group_arn = input;
            self
        }
        /// <p>The description for the model group.</p>
        pub fn model_package_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.model_package_group_description = Some(input.into());
            self
        }
        /// <p>The description for the model group.</p>
        pub fn set_model_package_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_package_group_description = input;
            self
        }
        /// <p>The time that the model group was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the model group was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial
        /// component, lineage group, or project.</p>
        pub fn created_by(mut self, input: crate::model::UserContext) -> Self {
            self.created_by = Some(input);
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial
        /// component, lineage group, or project.</p>
        pub fn set_created_by(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The status of the model group. This can be one of the following values.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - The model group is pending being created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code> - The model group is in the process of being
        /// created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMPLETED</code> - The model group was successfully created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - The model group failed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code> - The model group is in the process of being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_FAILED</code> - SageMaker failed to delete the model group.</p>
        /// </li>
        /// </ul>
        pub fn model_package_group_status(
            mut self,
            input: crate::model::ModelPackageGroupStatus,
        ) -> Self {
            self.model_package_group_status = Some(input);
            self
        }
        /// <p>The status of the model group. This can be one of the following values.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - The model group is pending being created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code> - The model group is in the process of being
        /// created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMPLETED</code> - The model group was successfully created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - The model group failed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code> - The model group is in the process of being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETE_FAILED</code> - SageMaker failed to delete the model group.</p>
        /// </li>
        /// </ul>
        pub fn set_model_package_group_status(
            mut self,
            input: std::option::Option<crate::model::ModelPackageGroupStatus>,
        ) -> Self {
            self.model_package_group_status = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tags associated with the model group. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of the tags associated with the model group. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ModelPackageGroup`](crate::model::ModelPackageGroup)
        pub fn build(self) -> crate::model::ModelPackageGroup {
            crate::model::ModelPackageGroup {
                model_package_group_name: self.model_package_group_name,
                model_package_group_arn: self.model_package_group_arn,
                model_package_group_description: self.model_package_group_description,
                creation_time: self.creation_time,
                created_by: self.created_by,
                model_package_group_status: self.model_package_group_status,
                tags: self.tags,
            }
        }
    }
}
impl ModelPackageGroup {
    /// Creates a new builder-style object to manufacture [`ModelPackageGroup`](crate::model::ModelPackageGroup)
    pub fn builder() -> crate::model::model_package_group::Builder {
        crate::model::model_package_group::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ModelPackageGroupStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ModelPackageGroupStatus {
    fn from(s: &str) -> Self {
        match s {
            "Completed" => ModelPackageGroupStatus::Completed,
            "DeleteFailed" => ModelPackageGroupStatus::DeleteFailed,
            "Deleting" => ModelPackageGroupStatus::Deleting,
            "Failed" => ModelPackageGroupStatus::Failed,
            "InProgress" => ModelPackageGroupStatus::InProgress,
            "Pending" => ModelPackageGroupStatus::Pending,
            other => ModelPackageGroupStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ModelPackageGroupStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ModelPackageGroupStatus::from(s))
    }
}
impl ModelPackageGroupStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ModelPackageGroupStatus::Completed => "Completed",
            ModelPackageGroupStatus::DeleteFailed => "DeleteFailed",
            ModelPackageGroupStatus::Deleting => "Deleting",
            ModelPackageGroupStatus::Failed => "Failed",
            ModelPackageGroupStatus::InProgress => "InProgress",
            ModelPackageGroupStatus::Pending => "Pending",
            ModelPackageGroupStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Completed",
            "DeleteFailed",
            "Deleting",
            "Failed",
            "InProgress",
            "Pending",
        ]
    }
}
impl AsRef<str> for ModelPackageGroupStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A versioned model that can be deployed for SageMaker inference.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModelPackage {
    /// <p>The name of the model.</p>
    pub model_package_name: std::option::Option<std::string::String>,
    /// <p>The model group to which the model belongs.</p>
    pub model_package_group_name: std::option::Option<std::string::String>,
    /// <p>The version number of a versioned model.</p>
    pub model_package_version: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) of the model package.</p>
    pub model_package_arn: std::option::Option<std::string::String>,
    /// <p>The description of the model package.</p>
    pub model_package_description: std::option::Option<std::string::String>,
    /// <p>The time that the model package was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Defines how to perform inference generation after a training job is run.</p>
    pub inference_specification: std::option::Option<crate::model::InferenceSpecification>,
    /// <p>A list of algorithms that were used to create a model package.</p>
    pub source_algorithm_specification:
        std::option::Option<crate::model::SourceAlgorithmSpecification>,
    /// <p>Specifies batch transform jobs that Amazon SageMaker runs to validate your model package.</p>
    pub validation_specification:
        std::option::Option<crate::model::ModelPackageValidationSpecification>,
    /// <p>The status of the model package. This can be one of the following values.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PENDING</code> - The model package is pending being created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code> - The model package is in the process of being
    /// created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMPLETED</code> - The model package was successfully created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - The model package failed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETING</code> - The model package is in the process of being deleted.</p>
    /// </li>
    /// </ul>
    pub model_package_status: std::option::Option<crate::model::ModelPackageStatus>,
    /// <p>Specifies the validation and image scan statuses of the model package.</p>
    pub model_package_status_details: std::option::Option<crate::model::ModelPackageStatusDetails>,
    /// <p>Whether the model package is to be certified to be listed on Amazon Web Services Marketplace. For
    /// information about listing model packages on Amazon Web Services Marketplace, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html">List Your
    /// Algorithm or Model Package on Amazon Web Services Marketplace</a>.</p>
    pub certify_for_marketplace: bool,
    /// <p>The approval status of the model. This can be one of the following values.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>APPROVED</code> - The model is approved</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REJECTED</code> - The model is rejected.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PENDING_MANUAL_APPROVAL</code> - The model is waiting for manual
    /// approval.</p>
    /// </li>
    /// </ul>
    pub model_approval_status: std::option::Option<crate::model::ModelApprovalStatus>,
    /// <p>Information about the user who created or modified an experiment, trial, trial
    /// component, lineage group, or project.</p>
    pub created_by: std::option::Option<crate::model::UserContext>,
    /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
    pub metadata_properties: std::option::Option<crate::model::MetadataProperties>,
    /// <p>Metrics for the model.</p>
    pub model_metrics: std::option::Option<crate::model::ModelMetrics>,
    /// <p>The last time the model package was modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Information about the user who created or modified an experiment, trial, trial
    /// component, lineage group, or project.</p>
    pub last_modified_by: std::option::Option<crate::model::UserContext>,
    /// <p>A description provided when the model approval is set.</p>
    pub approval_description: std::option::Option<std::string::String>,
    /// <p>The machine learning domain of your model package and its components. Common
    /// machine learning domains include computer vision and natural language processing.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>The machine learning task your model package accomplishes. Common machine
    /// learning tasks include object detection and image classification.</p>
    pub task: std::option::Option<std::string::String>,
    /// <p>The Amazon Simple Storage Service path where the sample payload are stored. This path must point to
    /// a single gzip compressed tar archive (.tar.gz suffix).</p>
    pub sample_payload_url: std::option::Option<std::string::String>,
    /// <p>An array of additional Inference Specification objects.</p>
    pub additional_inference_specifications: std::option::Option<
        std::vec::Vec<crate::model::AdditionalInferenceSpecificationDefinition>,
    >,
    /// <p>A list of the tags associated with the model package. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
    /// resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The metadata properties for the model package. </p>
    pub customer_metadata_properties:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Represents the drift check baselines that can be used when the model monitor is set using the model package.</p>
    pub drift_check_baselines: std::option::Option<crate::model::DriftCheckBaselines>,
}
impl ModelPackage {
    /// <p>The name of the model.</p>
    pub fn model_package_name(&self) -> std::option::Option<&str> {
        self.model_package_name.as_deref()
    }
    /// <p>The model group to which the model belongs.</p>
    pub fn model_package_group_name(&self) -> std::option::Option<&str> {
        self.model_package_group_name.as_deref()
    }
    /// <p>The version number of a versioned model.</p>
    pub fn model_package_version(&self) -> std::option::Option<i32> {
        self.model_package_version
    }
    /// <p>The Amazon Resource Name (ARN) of the model package.</p>
    pub fn model_package_arn(&self) -> std::option::Option<&str> {
        self.model_package_arn.as_deref()
    }
    /// <p>The description of the model package.</p>
    pub fn model_package_description(&self) -> std::option::Option<&str> {
        self.model_package_description.as_deref()
    }
    /// <p>The time that the model package was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>Defines how to perform inference generation after a training job is run.</p>
    pub fn inference_specification(
        &self,
    ) -> std::option::Option<&crate::model::InferenceSpecification> {
        self.inference_specification.as_ref()
    }
    /// <p>A list of algorithms that were used to create a model package.</p>
    pub fn source_algorithm_specification(
        &self,
    ) -> std::option::Option<&crate::model::SourceAlgorithmSpecification> {
        self.source_algorithm_specification.as_ref()
    }
    /// <p>Specifies batch transform jobs that Amazon SageMaker runs to validate your model package.</p>
    pub fn validation_specification(
        &self,
    ) -> std::option::Option<&crate::model::ModelPackageValidationSpecification> {
        self.validation_specification.as_ref()
    }
    /// <p>The status of the model package. This can be one of the following values.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PENDING</code> - The model package is pending being created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code> - The model package is in the process of being
    /// created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMPLETED</code> - The model package was successfully created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - The model package failed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETING</code> - The model package is in the process of being deleted.</p>
    /// </li>
    /// </ul>
    pub fn model_package_status(&self) -> std::option::Option<&crate::model::ModelPackageStatus> {
        self.model_package_status.as_ref()
    }
    /// <p>Specifies the validation and image scan statuses of the model package.</p>
    pub fn model_package_status_details(
        &self,
    ) -> std::option::Option<&crate::model::ModelPackageStatusDetails> {
        self.model_package_status_details.as_ref()
    }
    /// <p>Whether the model package is to be certified to be listed on Amazon Web Services Marketplace. For
    /// information about listing model packages on Amazon Web Services Marketplace, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html">List Your
    /// Algorithm or Model Package on Amazon Web Services Marketplace</a>.</p>
    pub fn certify_for_marketplace(&self) -> bool {
        self.certify_for_marketplace
    }
    /// <p>The approval status of the model. This can be one of the following values.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>APPROVED</code> - The model is approved</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REJECTED</code> - The model is rejected.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PENDING_MANUAL_APPROVAL</code> - The model is waiting for manual
    /// approval.</p>
    /// </li>
    /// </ul>
    pub fn model_approval_status(&self) -> std::option::Option<&crate::model::ModelApprovalStatus> {
        self.model_approval_status.as_ref()
    }
    /// <p>Information about the user who created or modified an experiment, trial, trial
    /// component, lineage group, or project.</p>
    pub fn created_by(&self) -> std::option::Option<&crate::model::UserContext> {
        self.created_by.as_ref()
    }
    /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
    pub fn metadata_properties(&self) -> std::option::Option<&crate::model::MetadataProperties> {
        self.metadata_properties.as_ref()
    }
    /// <p>Metrics for the model.</p>
    pub fn model_metrics(&self) -> std::option::Option<&crate::model::ModelMetrics> {
        self.model_metrics.as_ref()
    }
    /// <p>The last time the model package was modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>Information about the user who created or modified an experiment, trial, trial
    /// component, lineage group, or project.</p>
    pub fn last_modified_by(&self) -> std::option::Option<&crate::model::UserContext> {
        self.last_modified_by.as_ref()
    }
    /// <p>A description provided when the model approval is set.</p>
    pub fn approval_description(&self) -> std::option::Option<&str> {
        self.approval_description.as_deref()
    }
    /// <p>The machine learning domain of your model package and its components. Common
    /// machine learning domains include computer vision and natural language processing.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>The machine learning task your model package accomplishes. Common machine
    /// learning tasks include object detection and image classification.</p>
    pub fn task(&self) -> std::option::Option<&str> {
        self.task.as_deref()
    }
    /// <p>The Amazon Simple Storage Service path where the sample payload are stored. This path must point to
    /// a single gzip compressed tar archive (.tar.gz suffix).</p>
    pub fn sample_payload_url(&self) -> std::option::Option<&str> {
        self.sample_payload_url.as_deref()
    }
    /// <p>An array of additional Inference Specification objects.</p>
    pub fn additional_inference_specifications(
        &self,
    ) -> std::option::Option<&[crate::model::AdditionalInferenceSpecificationDefinition]> {
        self.additional_inference_specifications.as_deref()
    }
    /// <p>A list of the tags associated with the model package. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
    /// resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The metadata properties for the model package. </p>
    pub fn customer_metadata_properties(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.customer_metadata_properties.as_ref()
    }
    /// <p>Represents the drift check baselines that can be used when the model monitor is set using the model package.</p>
    pub fn drift_check_baselines(&self) -> std::option::Option<&crate::model::DriftCheckBaselines> {
        self.drift_check_baselines.as_ref()
    }
}
impl std::fmt::Debug for ModelPackage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModelPackage");
        formatter.field("model_package_name", &self.model_package_name);
        formatter.field("model_package_group_name", &self.model_package_group_name);
        formatter.field("model_package_version", &self.model_package_version);
        formatter.field("model_package_arn", &self.model_package_arn);
        formatter.field("model_package_description", &self.model_package_description);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("inference_specification", &self.inference_specification);
        formatter.field(
            "source_algorithm_specification",
            &self.source_algorithm_specification,
        );
        formatter.field("validation_specification", &self.validation_specification);
        formatter.field("model_package_status", &self.model_package_status);
        formatter.field(
            "model_package_status_details",
            &self.model_package_status_details,
        );
        formatter.field("certify_for_marketplace", &self.certify_for_marketplace);
        formatter.field("model_approval_status", &self.model_approval_status);
        formatter.field("created_by", &self.created_by);
        formatter.field("metadata_properties", &self.metadata_properties);
        formatter.field("model_metrics", &self.model_metrics);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("approval_description", &self.approval_description);
        formatter.field("domain", &self.domain);
        formatter.field("task", &self.task);
        formatter.field("sample_payload_url", &self.sample_payload_url);
        formatter.field(
            "additional_inference_specifications",
            &self.additional_inference_specifications,
        );
        formatter.field("tags", &self.tags);
        formatter.field(
            "customer_metadata_properties",
            &self.customer_metadata_properties,
        );
        formatter.field("drift_check_baselines", &self.drift_check_baselines);
        formatter.finish()
    }
}
/// See [`ModelPackage`](crate::model::ModelPackage)
pub mod model_package {
    /// A builder for [`ModelPackage`](crate::model::ModelPackage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_package_name: std::option::Option<std::string::String>,
        pub(crate) model_package_group_name: std::option::Option<std::string::String>,
        pub(crate) model_package_version: std::option::Option<i32>,
        pub(crate) model_package_arn: std::option::Option<std::string::String>,
        pub(crate) model_package_description: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) inference_specification:
            std::option::Option<crate::model::InferenceSpecification>,
        pub(crate) source_algorithm_specification:
            std::option::Option<crate::model::SourceAlgorithmSpecification>,
        pub(crate) validation_specification:
            std::option::Option<crate::model::ModelPackageValidationSpecification>,
        pub(crate) model_package_status: std::option::Option<crate::model::ModelPackageStatus>,
        pub(crate) model_package_status_details:
            std::option::Option<crate::model::ModelPackageStatusDetails>,
        pub(crate) certify_for_marketplace: std::option::Option<bool>,
        pub(crate) model_approval_status: std::option::Option<crate::model::ModelApprovalStatus>,
        pub(crate) created_by: std::option::Option<crate::model::UserContext>,
        pub(crate) metadata_properties: std::option::Option<crate::model::MetadataProperties>,
        pub(crate) model_metrics: std::option::Option<crate::model::ModelMetrics>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_by: std::option::Option<crate::model::UserContext>,
        pub(crate) approval_description: std::option::Option<std::string::String>,
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) task: std::option::Option<std::string::String>,
        pub(crate) sample_payload_url: std::option::Option<std::string::String>,
        pub(crate) additional_inference_specifications: std::option::Option<
            std::vec::Vec<crate::model::AdditionalInferenceSpecificationDefinition>,
        >,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) customer_metadata_properties: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) drift_check_baselines: std::option::Option<crate::model::DriftCheckBaselines>,
    }
    impl Builder {
        /// <p>The name of the model.</p>
        pub fn model_package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_package_name = Some(input.into());
            self
        }
        /// <p>The name of the model.</p>
        pub fn set_model_package_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_package_name = input;
            self
        }
        /// <p>The model group to which the model belongs.</p>
        pub fn model_package_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_package_group_name = Some(input.into());
            self
        }
        /// <p>The model group to which the model belongs.</p>
        pub fn set_model_package_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_package_group_name = input;
            self
        }
        /// <p>The version number of a versioned model.</p>
        pub fn model_package_version(mut self, input: i32) -> Self {
            self.model_package_version = Some(input);
            self
        }
        /// <p>The version number of a versioned model.</p>
        pub fn set_model_package_version(mut self, input: std::option::Option<i32>) -> Self {
            self.model_package_version = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model package.</p>
        pub fn model_package_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_package_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model package.</p>
        pub fn set_model_package_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_package_arn = input;
            self
        }
        /// <p>The description of the model package.</p>
        pub fn model_package_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_package_description = Some(input.into());
            self
        }
        /// <p>The description of the model package.</p>
        pub fn set_model_package_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_package_description = input;
            self
        }
        /// <p>The time that the model package was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the model package was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>Defines how to perform inference generation after a training job is run.</p>
        pub fn inference_specification(
            mut self,
            input: crate::model::InferenceSpecification,
        ) -> Self {
            self.inference_specification = Some(input);
            self
        }
        /// <p>Defines how to perform inference generation after a training job is run.</p>
        pub fn set_inference_specification(
            mut self,
            input: std::option::Option<crate::model::InferenceSpecification>,
        ) -> Self {
            self.inference_specification = input;
            self
        }
        /// <p>A list of algorithms that were used to create a model package.</p>
        pub fn source_algorithm_specification(
            mut self,
            input: crate::model::SourceAlgorithmSpecification,
        ) -> Self {
            self.source_algorithm_specification = Some(input);
            self
        }
        /// <p>A list of algorithms that were used to create a model package.</p>
        pub fn set_source_algorithm_specification(
            mut self,
            input: std::option::Option<crate::model::SourceAlgorithmSpecification>,
        ) -> Self {
            self.source_algorithm_specification = input;
            self
        }
        /// <p>Specifies batch transform jobs that Amazon SageMaker runs to validate your model package.</p>
        pub fn validation_specification(
            mut self,
            input: crate::model::ModelPackageValidationSpecification,
        ) -> Self {
            self.validation_specification = Some(input);
            self
        }
        /// <p>Specifies batch transform jobs that Amazon SageMaker runs to validate your model package.</p>
        pub fn set_validation_specification(
            mut self,
            input: std::option::Option<crate::model::ModelPackageValidationSpecification>,
        ) -> Self {
            self.validation_specification = input;
            self
        }
        /// <p>The status of the model package. This can be one of the following values.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - The model package is pending being created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code> - The model package is in the process of being
        /// created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMPLETED</code> - The model package was successfully created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - The model package failed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code> - The model package is in the process of being deleted.</p>
        /// </li>
        /// </ul>
        pub fn model_package_status(mut self, input: crate::model::ModelPackageStatus) -> Self {
            self.model_package_status = Some(input);
            self
        }
        /// <p>The status of the model package. This can be one of the following values.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - The model package is pending being created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code> - The model package is in the process of being
        /// created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMPLETED</code> - The model package was successfully created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - The model package failed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code> - The model package is in the process of being deleted.</p>
        /// </li>
        /// </ul>
        pub fn set_model_package_status(
            mut self,
            input: std::option::Option<crate::model::ModelPackageStatus>,
        ) -> Self {
            self.model_package_status = input;
            self
        }
        /// <p>Specifies the validation and image scan statuses of the model package.</p>
        pub fn model_package_status_details(
            mut self,
            input: crate::model::ModelPackageStatusDetails,
        ) -> Self {
            self.model_package_status_details = Some(input);
            self
        }
        /// <p>Specifies the validation and image scan statuses of the model package.</p>
        pub fn set_model_package_status_details(
            mut self,
            input: std::option::Option<crate::model::ModelPackageStatusDetails>,
        ) -> Self {
            self.model_package_status_details = input;
            self
        }
        /// <p>Whether the model package is to be certified to be listed on Amazon Web Services Marketplace. For
        /// information about listing model packages on Amazon Web Services Marketplace, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html">List Your
        /// Algorithm or Model Package on Amazon Web Services Marketplace</a>.</p>
        pub fn certify_for_marketplace(mut self, input: bool) -> Self {
            self.certify_for_marketplace = Some(input);
            self
        }
        /// <p>Whether the model package is to be certified to be listed on Amazon Web Services Marketplace. For
        /// information about listing model packages on Amazon Web Services Marketplace, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html">List Your
        /// Algorithm or Model Package on Amazon Web Services Marketplace</a>.</p>
        pub fn set_certify_for_marketplace(mut self, input: std::option::Option<bool>) -> Self {
            self.certify_for_marketplace = input;
            self
        }
        /// <p>The approval status of the model. This can be one of the following values.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>APPROVED</code> - The model is approved</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REJECTED</code> - The model is rejected.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PENDING_MANUAL_APPROVAL</code> - The model is waiting for manual
        /// approval.</p>
        /// </li>
        /// </ul>
        pub fn model_approval_status(mut self, input: crate::model::ModelApprovalStatus) -> Self {
            self.model_approval_status = Some(input);
            self
        }
        /// <p>The approval status of the model. This can be one of the following values.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>APPROVED</code> - The model is approved</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REJECTED</code> - The model is rejected.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PENDING_MANUAL_APPROVAL</code> - The model is waiting for manual
        /// approval.</p>
        /// </li>
        /// </ul>
        pub fn set_model_approval_status(
            mut self,
            input: std::option::Option<crate::model::ModelApprovalStatus>,
        ) -> Self {
            self.model_approval_status = input;
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial
        /// component, lineage group, or project.</p>
        pub fn created_by(mut self, input: crate::model::UserContext) -> Self {
            self.created_by = Some(input);
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial
        /// component, lineage group, or project.</p>
        pub fn set_created_by(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.created_by = input;
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn metadata_properties(mut self, input: crate::model::MetadataProperties) -> Self {
            self.metadata_properties = Some(input);
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn set_metadata_properties(
            mut self,
            input: std::option::Option<crate::model::MetadataProperties>,
        ) -> Self {
            self.metadata_properties = input;
            self
        }
        /// <p>Metrics for the model.</p>
        pub fn model_metrics(mut self, input: crate::model::ModelMetrics) -> Self {
            self.model_metrics = Some(input);
            self
        }
        /// <p>Metrics for the model.</p>
        pub fn set_model_metrics(
            mut self,
            input: std::option::Option<crate::model::ModelMetrics>,
        ) -> Self {
            self.model_metrics = input;
            self
        }
        /// <p>The last time the model package was modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The last time the model package was modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial
        /// component, lineage group, or project.</p>
        pub fn last_modified_by(mut self, input: crate::model::UserContext) -> Self {
            self.last_modified_by = Some(input);
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial
        /// component, lineage group, or project.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// <p>A description provided when the model approval is set.</p>
        pub fn approval_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.approval_description = Some(input.into());
            self
        }
        /// <p>A description provided when the model approval is set.</p>
        pub fn set_approval_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_description = input;
            self
        }
        /// <p>The machine learning domain of your model package and its components. Common
        /// machine learning domains include computer vision and natural language processing.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The machine learning domain of your model package and its components. Common
        /// machine learning domains include computer vision and natural language processing.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The machine learning task your model package accomplishes. Common machine
        /// learning tasks include object detection and image classification.</p>
        pub fn task(mut self, input: impl Into<std::string::String>) -> Self {
            self.task = Some(input.into());
            self
        }
        /// <p>The machine learning task your model package accomplishes. Common machine
        /// learning tasks include object detection and image classification.</p>
        pub fn set_task(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task = input;
            self
        }
        /// <p>The Amazon Simple Storage Service path where the sample payload are stored. This path must point to
        /// a single gzip compressed tar archive (.tar.gz suffix).</p>
        pub fn sample_payload_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.sample_payload_url = Some(input.into());
            self
        }
        /// <p>The Amazon Simple Storage Service path where the sample payload are stored. This path must point to
        /// a single gzip compressed tar archive (.tar.gz suffix).</p>
        pub fn set_sample_payload_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sample_payload_url = input;
            self
        }
        /// Appends an item to `additional_inference_specifications`.
        ///
        /// To override the contents of this collection use [`set_additional_inference_specifications`](Self::set_additional_inference_specifications).
        ///
        /// <p>An array of additional Inference Specification objects.</p>
        pub fn additional_inference_specifications(
            mut self,
            input: impl Into<crate::model::AdditionalInferenceSpecificationDefinition>,
        ) -> Self {
            let mut v = self.additional_inference_specifications.unwrap_or_default();
            v.push(input.into());
            self.additional_inference_specifications = Some(v);
            self
        }
        /// <p>An array of additional Inference Specification objects.</p>
        pub fn set_additional_inference_specifications(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AdditionalInferenceSpecificationDefinition>,
            >,
        ) -> Self {
            self.additional_inference_specifications = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tags associated with the model package. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of the tags associated with the model package. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Adds a key-value pair to `customer_metadata_properties`.
        ///
        /// To override the contents of this collection use [`set_customer_metadata_properties`](Self::set_customer_metadata_properties).
        ///
        /// <p>The metadata properties for the model package. </p>
        pub fn customer_metadata_properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.customer_metadata_properties.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.customer_metadata_properties = Some(hash_map);
            self
        }
        /// <p>The metadata properties for the model package. </p>
        pub fn set_customer_metadata_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.customer_metadata_properties = input;
            self
        }
        /// <p>Represents the drift check baselines that can be used when the model monitor is set using the model package.</p>
        pub fn drift_check_baselines(mut self, input: crate::model::DriftCheckBaselines) -> Self {
            self.drift_check_baselines = Some(input);
            self
        }
        /// <p>Represents the drift check baselines that can be used when the model monitor is set using the model package.</p>
        pub fn set_drift_check_baselines(
            mut self,
            input: std::option::Option<crate::model::DriftCheckBaselines>,
        ) -> Self {
            self.drift_check_baselines = input;
            self
        }
        /// Consumes the builder and constructs a [`ModelPackage`](crate::model::ModelPackage)
        pub fn build(self) -> crate::model::ModelPackage {
            crate::model::ModelPackage {
                model_package_name: self.model_package_name,
                model_package_group_name: self.model_package_group_name,
                model_package_version: self.model_package_version,
                model_package_arn: self.model_package_arn,
                model_package_description: self.model_package_description,
                creation_time: self.creation_time,
                inference_specification: self.inference_specification,
                source_algorithm_specification: self.source_algorithm_specification,
                validation_specification: self.validation_specification,
                model_package_status: self.model_package_status,
                model_package_status_details: self.model_package_status_details,
                certify_for_marketplace: self.certify_for_marketplace.unwrap_or_default(),
                model_approval_status: self.model_approval_status,
                created_by: self.created_by,
                metadata_properties: self.metadata_properties,
                model_metrics: self.model_metrics,
                last_modified_time: self.last_modified_time,
                last_modified_by: self.last_modified_by,
                approval_description: self.approval_description,
                domain: self.domain,
                task: self.task,
                sample_payload_url: self.sample_payload_url,
                additional_inference_specifications: self.additional_inference_specifications,
                tags: self.tags,
                customer_metadata_properties: self.customer_metadata_properties,
                drift_check_baselines: self.drift_check_baselines,
            }
        }
    }
}
impl ModelPackage {
    /// Creates a new builder-style object to manufacture [`ModelPackage`](crate::model::ModelPackage)
    pub fn builder() -> crate::model::model_package::Builder {
        crate::model::model_package::Builder::default()
    }
}

/// <p>Represents the drift check baselines that can be used when the model monitor is set using the model
/// package. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DriftCheckBaselines {
    /// <p>Represents the drift check bias baselines that can be used when the model monitor is set using the model
    /// package. </p>
    pub bias: std::option::Option<crate::model::DriftCheckBias>,
    /// <p>Represents the drift check explainability baselines that can be used when the model monitor is set using
    /// the model package. </p>
    pub explainability: std::option::Option<crate::model::DriftCheckExplainability>,
    /// <p>Represents the drift check model quality baselines that can be used when the model monitor is set using
    /// the model package.</p>
    pub model_quality: std::option::Option<crate::model::DriftCheckModelQuality>,
    /// <p>Represents the drift check model data quality baselines that can be used when the model monitor is set
    /// using the model package.</p>
    pub model_data_quality: std::option::Option<crate::model::DriftCheckModelDataQuality>,
}
impl DriftCheckBaselines {
    /// <p>Represents the drift check bias baselines that can be used when the model monitor is set using the model
    /// package. </p>
    pub fn bias(&self) -> std::option::Option<&crate::model::DriftCheckBias> {
        self.bias.as_ref()
    }
    /// <p>Represents the drift check explainability baselines that can be used when the model monitor is set using
    /// the model package. </p>
    pub fn explainability(&self) -> std::option::Option<&crate::model::DriftCheckExplainability> {
        self.explainability.as_ref()
    }
    /// <p>Represents the drift check model quality baselines that can be used when the model monitor is set using
    /// the model package.</p>
    pub fn model_quality(&self) -> std::option::Option<&crate::model::DriftCheckModelQuality> {
        self.model_quality.as_ref()
    }
    /// <p>Represents the drift check model data quality baselines that can be used when the model monitor is set
    /// using the model package.</p>
    pub fn model_data_quality(
        &self,
    ) -> std::option::Option<&crate::model::DriftCheckModelDataQuality> {
        self.model_data_quality.as_ref()
    }
}
impl std::fmt::Debug for DriftCheckBaselines {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DriftCheckBaselines");
        formatter.field("bias", &self.bias);
        formatter.field("explainability", &self.explainability);
        formatter.field("model_quality", &self.model_quality);
        formatter.field("model_data_quality", &self.model_data_quality);
        formatter.finish()
    }
}
/// See [`DriftCheckBaselines`](crate::model::DriftCheckBaselines)
pub mod drift_check_baselines {
    /// A builder for [`DriftCheckBaselines`](crate::model::DriftCheckBaselines)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bias: std::option::Option<crate::model::DriftCheckBias>,
        pub(crate) explainability: std::option::Option<crate::model::DriftCheckExplainability>,
        pub(crate) model_quality: std::option::Option<crate::model::DriftCheckModelQuality>,
        pub(crate) model_data_quality:
            std::option::Option<crate::model::DriftCheckModelDataQuality>,
    }
    impl Builder {
        /// <p>Represents the drift check bias baselines that can be used when the model monitor is set using the model
        /// package. </p>
        pub fn bias(mut self, input: crate::model::DriftCheckBias) -> Self {
            self.bias = Some(input);
            self
        }
        /// <p>Represents the drift check bias baselines that can be used when the model monitor is set using the model
        /// package. </p>
        pub fn set_bias(
            mut self,
            input: std::option::Option<crate::model::DriftCheckBias>,
        ) -> Self {
            self.bias = input;
            self
        }
        /// <p>Represents the drift check explainability baselines that can be used when the model monitor is set using
        /// the model package. </p>
        pub fn explainability(mut self, input: crate::model::DriftCheckExplainability) -> Self {
            self.explainability = Some(input);
            self
        }
        /// <p>Represents the drift check explainability baselines that can be used when the model monitor is set using
        /// the model package. </p>
        pub fn set_explainability(
            mut self,
            input: std::option::Option<crate::model::DriftCheckExplainability>,
        ) -> Self {
            self.explainability = input;
            self
        }
        /// <p>Represents the drift check model quality baselines that can be used when the model monitor is set using
        /// the model package.</p>
        pub fn model_quality(mut self, input: crate::model::DriftCheckModelQuality) -> Self {
            self.model_quality = Some(input);
            self
        }
        /// <p>Represents the drift check model quality baselines that can be used when the model monitor is set using
        /// the model package.</p>
        pub fn set_model_quality(
            mut self,
            input: std::option::Option<crate::model::DriftCheckModelQuality>,
        ) -> Self {
            self.model_quality = input;
            self
        }
        /// <p>Represents the drift check model data quality baselines that can be used when the model monitor is set
        /// using the model package.</p>
        pub fn model_data_quality(
            mut self,
            input: crate::model::DriftCheckModelDataQuality,
        ) -> Self {
            self.model_data_quality = Some(input);
            self
        }
        /// <p>Represents the drift check model data quality baselines that can be used when the model monitor is set
        /// using the model package.</p>
        pub fn set_model_data_quality(
            mut self,
            input: std::option::Option<crate::model::DriftCheckModelDataQuality>,
        ) -> Self {
            self.model_data_quality = input;
            self
        }
        /// Consumes the builder and constructs a [`DriftCheckBaselines`](crate::model::DriftCheckBaselines)
        pub fn build(self) -> crate::model::DriftCheckBaselines {
            crate::model::DriftCheckBaselines {
                bias: self.bias,
                explainability: self.explainability,
                model_quality: self.model_quality,
                model_data_quality: self.model_data_quality,
            }
        }
    }
}
impl DriftCheckBaselines {
    /// Creates a new builder-style object to manufacture [`DriftCheckBaselines`](crate::model::DriftCheckBaselines)
    pub fn builder() -> crate::model::drift_check_baselines::Builder {
        crate::model::drift_check_baselines::Builder::default()
    }
}

/// <p>Represents the drift check data quality baselines that can be used when the model monitor is set using
/// the model package. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DriftCheckModelDataQuality {
    /// <p></p>
    pub statistics: std::option::Option<crate::model::MetricsSource>,
    /// <p></p>
    pub constraints: std::option::Option<crate::model::MetricsSource>,
}
impl DriftCheckModelDataQuality {
    /// <p></p>
    pub fn statistics(&self) -> std::option::Option<&crate::model::MetricsSource> {
        self.statistics.as_ref()
    }
    /// <p></p>
    pub fn constraints(&self) -> std::option::Option<&crate::model::MetricsSource> {
        self.constraints.as_ref()
    }
}
impl std::fmt::Debug for DriftCheckModelDataQuality {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DriftCheckModelDataQuality");
        formatter.field("statistics", &self.statistics);
        formatter.field("constraints", &self.constraints);
        formatter.finish()
    }
}
/// See [`DriftCheckModelDataQuality`](crate::model::DriftCheckModelDataQuality)
pub mod drift_check_model_data_quality {
    /// A builder for [`DriftCheckModelDataQuality`](crate::model::DriftCheckModelDataQuality)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) statistics: std::option::Option<crate::model::MetricsSource>,
        pub(crate) constraints: std::option::Option<crate::model::MetricsSource>,
    }
    impl Builder {
        /// <p></p>
        pub fn statistics(mut self, input: crate::model::MetricsSource) -> Self {
            self.statistics = Some(input);
            self
        }
        /// <p></p>
        pub fn set_statistics(
            mut self,
            input: std::option::Option<crate::model::MetricsSource>,
        ) -> Self {
            self.statistics = input;
            self
        }
        /// <p></p>
        pub fn constraints(mut self, input: crate::model::MetricsSource) -> Self {
            self.constraints = Some(input);
            self
        }
        /// <p></p>
        pub fn set_constraints(
            mut self,
            input: std::option::Option<crate::model::MetricsSource>,
        ) -> Self {
            self.constraints = input;
            self
        }
        /// Consumes the builder and constructs a [`DriftCheckModelDataQuality`](crate::model::DriftCheckModelDataQuality)
        pub fn build(self) -> crate::model::DriftCheckModelDataQuality {
            crate::model::DriftCheckModelDataQuality {
                statistics: self.statistics,
                constraints: self.constraints,
            }
        }
    }
}
impl DriftCheckModelDataQuality {
    /// Creates a new builder-style object to manufacture [`DriftCheckModelDataQuality`](crate::model::DriftCheckModelDataQuality)
    pub fn builder() -> crate::model::drift_check_model_data_quality::Builder {
        crate::model::drift_check_model_data_quality::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricsSource {
    /// <p></p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p></p>
    pub content_digest: std::option::Option<std::string::String>,
    /// <p></p>
    pub s3_uri: std::option::Option<std::string::String>,
}
impl MetricsSource {
    /// <p></p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p></p>
    pub fn content_digest(&self) -> std::option::Option<&str> {
        self.content_digest.as_deref()
    }
    /// <p></p>
    pub fn s3_uri(&self) -> std::option::Option<&str> {
        self.s3_uri.as_deref()
    }
}
impl std::fmt::Debug for MetricsSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricsSource");
        formatter.field("content_type", &self.content_type);
        formatter.field("content_digest", &self.content_digest);
        formatter.field("s3_uri", &self.s3_uri);
        formatter.finish()
    }
}
/// See [`MetricsSource`](crate::model::MetricsSource)
pub mod metrics_source {
    /// A builder for [`MetricsSource`](crate::model::MetricsSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) content_digest: std::option::Option<std::string::String>,
        pub(crate) s3_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p></p>
        pub fn content_digest(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_digest = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_content_digest(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_digest = input;
            self
        }
        /// <p></p>
        pub fn s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_uri = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_s3_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricsSource`](crate::model::MetricsSource)
        pub fn build(self) -> crate::model::MetricsSource {
            crate::model::MetricsSource {
                content_type: self.content_type,
                content_digest: self.content_digest,
                s3_uri: self.s3_uri,
            }
        }
    }
}
impl MetricsSource {
    /// Creates a new builder-style object to manufacture [`MetricsSource`](crate::model::MetricsSource)
    pub fn builder() -> crate::model::metrics_source::Builder {
        crate::model::metrics_source::Builder::default()
    }
}

/// <p>Represents the drift check model quality baselines that can be used when the model monitor is set using
/// the model package. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DriftCheckModelQuality {
    /// <p></p>
    pub statistics: std::option::Option<crate::model::MetricsSource>,
    /// <p></p>
    pub constraints: std::option::Option<crate::model::MetricsSource>,
}
impl DriftCheckModelQuality {
    /// <p></p>
    pub fn statistics(&self) -> std::option::Option<&crate::model::MetricsSource> {
        self.statistics.as_ref()
    }
    /// <p></p>
    pub fn constraints(&self) -> std::option::Option<&crate::model::MetricsSource> {
        self.constraints.as_ref()
    }
}
impl std::fmt::Debug for DriftCheckModelQuality {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DriftCheckModelQuality");
        formatter.field("statistics", &self.statistics);
        formatter.field("constraints", &self.constraints);
        formatter.finish()
    }
}
/// See [`DriftCheckModelQuality`](crate::model::DriftCheckModelQuality)
pub mod drift_check_model_quality {
    /// A builder for [`DriftCheckModelQuality`](crate::model::DriftCheckModelQuality)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) statistics: std::option::Option<crate::model::MetricsSource>,
        pub(crate) constraints: std::option::Option<crate::model::MetricsSource>,
    }
    impl Builder {
        /// <p></p>
        pub fn statistics(mut self, input: crate::model::MetricsSource) -> Self {
            self.statistics = Some(input);
            self
        }
        /// <p></p>
        pub fn set_statistics(
            mut self,
            input: std::option::Option<crate::model::MetricsSource>,
        ) -> Self {
            self.statistics = input;
            self
        }
        /// <p></p>
        pub fn constraints(mut self, input: crate::model::MetricsSource) -> Self {
            self.constraints = Some(input);
            self
        }
        /// <p></p>
        pub fn set_constraints(
            mut self,
            input: std::option::Option<crate::model::MetricsSource>,
        ) -> Self {
            self.constraints = input;
            self
        }
        /// Consumes the builder and constructs a [`DriftCheckModelQuality`](crate::model::DriftCheckModelQuality)
        pub fn build(self) -> crate::model::DriftCheckModelQuality {
            crate::model::DriftCheckModelQuality {
                statistics: self.statistics,
                constraints: self.constraints,
            }
        }
    }
}
impl DriftCheckModelQuality {
    /// Creates a new builder-style object to manufacture [`DriftCheckModelQuality`](crate::model::DriftCheckModelQuality)
    pub fn builder() -> crate::model::drift_check_model_quality::Builder {
        crate::model::drift_check_model_quality::Builder::default()
    }
}

/// <p>Represents the drift check explainability baselines that can be used when the model monitor is set
/// using the model package. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DriftCheckExplainability {
    /// <p></p>
    pub constraints: std::option::Option<crate::model::MetricsSource>,
    /// <p>The explainability config file for the model.</p>
    pub config_file: std::option::Option<crate::model::FileSource>,
}
impl DriftCheckExplainability {
    /// <p></p>
    pub fn constraints(&self) -> std::option::Option<&crate::model::MetricsSource> {
        self.constraints.as_ref()
    }
    /// <p>The explainability config file for the model.</p>
    pub fn config_file(&self) -> std::option::Option<&crate::model::FileSource> {
        self.config_file.as_ref()
    }
}
impl std::fmt::Debug for DriftCheckExplainability {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DriftCheckExplainability");
        formatter.field("constraints", &self.constraints);
        formatter.field("config_file", &self.config_file);
        formatter.finish()
    }
}
/// See [`DriftCheckExplainability`](crate::model::DriftCheckExplainability)
pub mod drift_check_explainability {
    /// A builder for [`DriftCheckExplainability`](crate::model::DriftCheckExplainability)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) constraints: std::option::Option<crate::model::MetricsSource>,
        pub(crate) config_file: std::option::Option<crate::model::FileSource>,
    }
    impl Builder {
        /// <p></p>
        pub fn constraints(mut self, input: crate::model::MetricsSource) -> Self {
            self.constraints = Some(input);
            self
        }
        /// <p></p>
        pub fn set_constraints(
            mut self,
            input: std::option::Option<crate::model::MetricsSource>,
        ) -> Self {
            self.constraints = input;
            self
        }
        /// <p>The explainability config file for the model.</p>
        pub fn config_file(mut self, input: crate::model::FileSource) -> Self {
            self.config_file = Some(input);
            self
        }
        /// <p>The explainability config file for the model.</p>
        pub fn set_config_file(
            mut self,
            input: std::option::Option<crate::model::FileSource>,
        ) -> Self {
            self.config_file = input;
            self
        }
        /// Consumes the builder and constructs a [`DriftCheckExplainability`](crate::model::DriftCheckExplainability)
        pub fn build(self) -> crate::model::DriftCheckExplainability {
            crate::model::DriftCheckExplainability {
                constraints: self.constraints,
                config_file: self.config_file,
            }
        }
    }
}
impl DriftCheckExplainability {
    /// Creates a new builder-style object to manufacture [`DriftCheckExplainability`](crate::model::DriftCheckExplainability)
    pub fn builder() -> crate::model::drift_check_explainability::Builder {
        crate::model::drift_check_explainability::Builder::default()
    }
}

/// <p>Contains details regarding the file source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FileSource {
    /// <p>The type of content stored in the file source.</p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p>The digest of the file source.</p>
    pub content_digest: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 URI for the file source.</p>
    pub s3_uri: std::option::Option<std::string::String>,
}
impl FileSource {
    /// <p>The type of content stored in the file source.</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p>The digest of the file source.</p>
    pub fn content_digest(&self) -> std::option::Option<&str> {
        self.content_digest.as_deref()
    }
    /// <p>The Amazon S3 URI for the file source.</p>
    pub fn s3_uri(&self) -> std::option::Option<&str> {
        self.s3_uri.as_deref()
    }
}
impl std::fmt::Debug for FileSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FileSource");
        formatter.field("content_type", &self.content_type);
        formatter.field("content_digest", &self.content_digest);
        formatter.field("s3_uri", &self.s3_uri);
        formatter.finish()
    }
}
/// See [`FileSource`](crate::model::FileSource)
pub mod file_source {
    /// A builder for [`FileSource`](crate::model::FileSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) content_digest: std::option::Option<std::string::String>,
        pub(crate) s3_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of content stored in the file source.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The type of content stored in the file source.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>The digest of the file source.</p>
        pub fn content_digest(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_digest = Some(input.into());
            self
        }
        /// <p>The digest of the file source.</p>
        pub fn set_content_digest(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_digest = input;
            self
        }
        /// <p>The Amazon S3 URI for the file source.</p>
        pub fn s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_uri = Some(input.into());
            self
        }
        /// <p>The Amazon S3 URI for the file source.</p>
        pub fn set_s3_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`FileSource`](crate::model::FileSource)
        pub fn build(self) -> crate::model::FileSource {
            crate::model::FileSource {
                content_type: self.content_type,
                content_digest: self.content_digest,
                s3_uri: self.s3_uri,
            }
        }
    }
}
impl FileSource {
    /// Creates a new builder-style object to manufacture [`FileSource`](crate::model::FileSource)
    pub fn builder() -> crate::model::file_source::Builder {
        crate::model::file_source::Builder::default()
    }
}

/// <p>Represents the drift check bias baselines that can be used when the model monitor is set using the
/// model package.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DriftCheckBias {
    /// <p>The bias config file for a model.</p>
    pub config_file: std::option::Option<crate::model::FileSource>,
    /// <p></p>
    pub pre_training_constraints: std::option::Option<crate::model::MetricsSource>,
    /// <p></p>
    pub post_training_constraints: std::option::Option<crate::model::MetricsSource>,
}
impl DriftCheckBias {
    /// <p>The bias config file for a model.</p>
    pub fn config_file(&self) -> std::option::Option<&crate::model::FileSource> {
        self.config_file.as_ref()
    }
    /// <p></p>
    pub fn pre_training_constraints(&self) -> std::option::Option<&crate::model::MetricsSource> {
        self.pre_training_constraints.as_ref()
    }
    /// <p></p>
    pub fn post_training_constraints(&self) -> std::option::Option<&crate::model::MetricsSource> {
        self.post_training_constraints.as_ref()
    }
}
impl std::fmt::Debug for DriftCheckBias {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DriftCheckBias");
        formatter.field("config_file", &self.config_file);
        formatter.field("pre_training_constraints", &self.pre_training_constraints);
        formatter.field("post_training_constraints", &self.post_training_constraints);
        formatter.finish()
    }
}
/// See [`DriftCheckBias`](crate::model::DriftCheckBias)
pub mod drift_check_bias {
    /// A builder for [`DriftCheckBias`](crate::model::DriftCheckBias)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_file: std::option::Option<crate::model::FileSource>,
        pub(crate) pre_training_constraints: std::option::Option<crate::model::MetricsSource>,
        pub(crate) post_training_constraints: std::option::Option<crate::model::MetricsSource>,
    }
    impl Builder {
        /// <p>The bias config file for a model.</p>
        pub fn config_file(mut self, input: crate::model::FileSource) -> Self {
            self.config_file = Some(input);
            self
        }
        /// <p>The bias config file for a model.</p>
        pub fn set_config_file(
            mut self,
            input: std::option::Option<crate::model::FileSource>,
        ) -> Self {
            self.config_file = input;
            self
        }
        /// <p></p>
        pub fn pre_training_constraints(mut self, input: crate::model::MetricsSource) -> Self {
            self.pre_training_constraints = Some(input);
            self
        }
        /// <p></p>
        pub fn set_pre_training_constraints(
            mut self,
            input: std::option::Option<crate::model::MetricsSource>,
        ) -> Self {
            self.pre_training_constraints = input;
            self
        }
        /// <p></p>
        pub fn post_training_constraints(mut self, input: crate::model::MetricsSource) -> Self {
            self.post_training_constraints = Some(input);
            self
        }
        /// <p></p>
        pub fn set_post_training_constraints(
            mut self,
            input: std::option::Option<crate::model::MetricsSource>,
        ) -> Self {
            self.post_training_constraints = input;
            self
        }
        /// Consumes the builder and constructs a [`DriftCheckBias`](crate::model::DriftCheckBias)
        pub fn build(self) -> crate::model::DriftCheckBias {
            crate::model::DriftCheckBias {
                config_file: self.config_file,
                pre_training_constraints: self.pre_training_constraints,
                post_training_constraints: self.post_training_constraints,
            }
        }
    }
}
impl DriftCheckBias {
    /// Creates a new builder-style object to manufacture [`DriftCheckBias`](crate::model::DriftCheckBias)
    pub fn builder() -> crate::model::drift_check_bias::Builder {
        crate::model::drift_check_bias::Builder::default()
    }
}

/// <p>Contains metrics captured from a model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModelMetrics {
    /// <p>Metrics that measure the quality of a model.</p>
    pub model_quality: std::option::Option<crate::model::ModelQuality>,
    /// <p>Metrics that measure the quality of the input data for a model.</p>
    pub model_data_quality: std::option::Option<crate::model::ModelDataQuality>,
    /// <p>Metrics that measure bais in a model.</p>
    pub bias: std::option::Option<crate::model::Bias>,
    /// <p>Metrics that help explain a model.</p>
    pub explainability: std::option::Option<crate::model::Explainability>,
}
impl ModelMetrics {
    /// <p>Metrics that measure the quality of a model.</p>
    pub fn model_quality(&self) -> std::option::Option<&crate::model::ModelQuality> {
        self.model_quality.as_ref()
    }
    /// <p>Metrics that measure the quality of the input data for a model.</p>
    pub fn model_data_quality(&self) -> std::option::Option<&crate::model::ModelDataQuality> {
        self.model_data_quality.as_ref()
    }
    /// <p>Metrics that measure bais in a model.</p>
    pub fn bias(&self) -> std::option::Option<&crate::model::Bias> {
        self.bias.as_ref()
    }
    /// <p>Metrics that help explain a model.</p>
    pub fn explainability(&self) -> std::option::Option<&crate::model::Explainability> {
        self.explainability.as_ref()
    }
}
impl std::fmt::Debug for ModelMetrics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModelMetrics");
        formatter.field("model_quality", &self.model_quality);
        formatter.field("model_data_quality", &self.model_data_quality);
        formatter.field("bias", &self.bias);
        formatter.field("explainability", &self.explainability);
        formatter.finish()
    }
}
/// See [`ModelMetrics`](crate::model::ModelMetrics)
pub mod model_metrics {
    /// A builder for [`ModelMetrics`](crate::model::ModelMetrics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_quality: std::option::Option<crate::model::ModelQuality>,
        pub(crate) model_data_quality: std::option::Option<crate::model::ModelDataQuality>,
        pub(crate) bias: std::option::Option<crate::model::Bias>,
        pub(crate) explainability: std::option::Option<crate::model::Explainability>,
    }
    impl Builder {
        /// <p>Metrics that measure the quality of a model.</p>
        pub fn model_quality(mut self, input: crate::model::ModelQuality) -> Self {
            self.model_quality = Some(input);
            self
        }
        /// <p>Metrics that measure the quality of a model.</p>
        pub fn set_model_quality(
            mut self,
            input: std::option::Option<crate::model::ModelQuality>,
        ) -> Self {
            self.model_quality = input;
            self
        }
        /// <p>Metrics that measure the quality of the input data for a model.</p>
        pub fn model_data_quality(mut self, input: crate::model::ModelDataQuality) -> Self {
            self.model_data_quality = Some(input);
            self
        }
        /// <p>Metrics that measure the quality of the input data for a model.</p>
        pub fn set_model_data_quality(
            mut self,
            input: std::option::Option<crate::model::ModelDataQuality>,
        ) -> Self {
            self.model_data_quality = input;
            self
        }
        /// <p>Metrics that measure bais in a model.</p>
        pub fn bias(mut self, input: crate::model::Bias) -> Self {
            self.bias = Some(input);
            self
        }
        /// <p>Metrics that measure bais in a model.</p>
        pub fn set_bias(mut self, input: std::option::Option<crate::model::Bias>) -> Self {
            self.bias = input;
            self
        }
        /// <p>Metrics that help explain a model.</p>
        pub fn explainability(mut self, input: crate::model::Explainability) -> Self {
            self.explainability = Some(input);
            self
        }
        /// <p>Metrics that help explain a model.</p>
        pub fn set_explainability(
            mut self,
            input: std::option::Option<crate::model::Explainability>,
        ) -> Self {
            self.explainability = input;
            self
        }
        /// Consumes the builder and constructs a [`ModelMetrics`](crate::model::ModelMetrics)
        pub fn build(self) -> crate::model::ModelMetrics {
            crate::model::ModelMetrics {
                model_quality: self.model_quality,
                model_data_quality: self.model_data_quality,
                bias: self.bias,
                explainability: self.explainability,
            }
        }
    }
}
impl ModelMetrics {
    /// Creates a new builder-style object to manufacture [`ModelMetrics`](crate::model::ModelMetrics)
    pub fn builder() -> crate::model::model_metrics::Builder {
        crate::model::model_metrics::Builder::default()
    }
}

/// <p>Contains explainability metrics for a model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Explainability {
    /// <p>The explainability report for a model.</p>
    pub report: std::option::Option<crate::model::MetricsSource>,
}
impl Explainability {
    /// <p>The explainability report for a model.</p>
    pub fn report(&self) -> std::option::Option<&crate::model::MetricsSource> {
        self.report.as_ref()
    }
}
impl std::fmt::Debug for Explainability {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Explainability");
        formatter.field("report", &self.report);
        formatter.finish()
    }
}
/// See [`Explainability`](crate::model::Explainability)
pub mod explainability {
    /// A builder for [`Explainability`](crate::model::Explainability)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report: std::option::Option<crate::model::MetricsSource>,
    }
    impl Builder {
        /// <p>The explainability report for a model.</p>
        pub fn report(mut self, input: crate::model::MetricsSource) -> Self {
            self.report = Some(input);
            self
        }
        /// <p>The explainability report for a model.</p>
        pub fn set_report(
            mut self,
            input: std::option::Option<crate::model::MetricsSource>,
        ) -> Self {
            self.report = input;
            self
        }
        /// Consumes the builder and constructs a [`Explainability`](crate::model::Explainability)
        pub fn build(self) -> crate::model::Explainability {
            crate::model::Explainability {
                report: self.report,
            }
        }
    }
}
impl Explainability {
    /// Creates a new builder-style object to manufacture [`Explainability`](crate::model::Explainability)
    pub fn builder() -> crate::model::explainability::Builder {
        crate::model::explainability::Builder::default()
    }
}

/// <p>Contains bias metrics for a model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Bias {
    /// <p>The bias report for a model</p>
    pub report: std::option::Option<crate::model::MetricsSource>,
    /// <p></p>
    pub pre_training_report: std::option::Option<crate::model::MetricsSource>,
    /// <p></p>
    pub post_training_report: std::option::Option<crate::model::MetricsSource>,
}
impl Bias {
    /// <p>The bias report for a model</p>
    pub fn report(&self) -> std::option::Option<&crate::model::MetricsSource> {
        self.report.as_ref()
    }
    /// <p></p>
    pub fn pre_training_report(&self) -> std::option::Option<&crate::model::MetricsSource> {
        self.pre_training_report.as_ref()
    }
    /// <p></p>
    pub fn post_training_report(&self) -> std::option::Option<&crate::model::MetricsSource> {
        self.post_training_report.as_ref()
    }
}
impl std::fmt::Debug for Bias {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Bias");
        formatter.field("report", &self.report);
        formatter.field("pre_training_report", &self.pre_training_report);
        formatter.field("post_training_report", &self.post_training_report);
        formatter.finish()
    }
}
/// See [`Bias`](crate::model::Bias)
pub mod bias {
    /// A builder for [`Bias`](crate::model::Bias)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report: std::option::Option<crate::model::MetricsSource>,
        pub(crate) pre_training_report: std::option::Option<crate::model::MetricsSource>,
        pub(crate) post_training_report: std::option::Option<crate::model::MetricsSource>,
    }
    impl Builder {
        /// <p>The bias report for a model</p>
        pub fn report(mut self, input: crate::model::MetricsSource) -> Self {
            self.report = Some(input);
            self
        }
        /// <p>The bias report for a model</p>
        pub fn set_report(
            mut self,
            input: std::option::Option<crate::model::MetricsSource>,
        ) -> Self {
            self.report = input;
            self
        }
        /// <p></p>
        pub fn pre_training_report(mut self, input: crate::model::MetricsSource) -> Self {
            self.pre_training_report = Some(input);
            self
        }
        /// <p></p>
        pub fn set_pre_training_report(
            mut self,
            input: std::option::Option<crate::model::MetricsSource>,
        ) -> Self {
            self.pre_training_report = input;
            self
        }
        /// <p></p>
        pub fn post_training_report(mut self, input: crate::model::MetricsSource) -> Self {
            self.post_training_report = Some(input);
            self
        }
        /// <p></p>
        pub fn set_post_training_report(
            mut self,
            input: std::option::Option<crate::model::MetricsSource>,
        ) -> Self {
            self.post_training_report = input;
            self
        }
        /// Consumes the builder and constructs a [`Bias`](crate::model::Bias)
        pub fn build(self) -> crate::model::Bias {
            crate::model::Bias {
                report: self.report,
                pre_training_report: self.pre_training_report,
                post_training_report: self.post_training_report,
            }
        }
    }
}
impl Bias {
    /// Creates a new builder-style object to manufacture [`Bias`](crate::model::Bias)
    pub fn builder() -> crate::model::bias::Builder {
        crate::model::bias::Builder::default()
    }
}

/// <p>Data quality constraints and statistics for a model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModelDataQuality {
    /// <p>Data quality statistics for a model.</p>
    pub statistics: std::option::Option<crate::model::MetricsSource>,
    /// <p>Data quality constraints for a model.</p>
    pub constraints: std::option::Option<crate::model::MetricsSource>,
}
impl ModelDataQuality {
    /// <p>Data quality statistics for a model.</p>
    pub fn statistics(&self) -> std::option::Option<&crate::model::MetricsSource> {
        self.statistics.as_ref()
    }
    /// <p>Data quality constraints for a model.</p>
    pub fn constraints(&self) -> std::option::Option<&crate::model::MetricsSource> {
        self.constraints.as_ref()
    }
}
impl std::fmt::Debug for ModelDataQuality {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModelDataQuality");
        formatter.field("statistics", &self.statistics);
        formatter.field("constraints", &self.constraints);
        formatter.finish()
    }
}
/// See [`ModelDataQuality`](crate::model::ModelDataQuality)
pub mod model_data_quality {
    /// A builder for [`ModelDataQuality`](crate::model::ModelDataQuality)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) statistics: std::option::Option<crate::model::MetricsSource>,
        pub(crate) constraints: std::option::Option<crate::model::MetricsSource>,
    }
    impl Builder {
        /// <p>Data quality statistics for a model.</p>
        pub fn statistics(mut self, input: crate::model::MetricsSource) -> Self {
            self.statistics = Some(input);
            self
        }
        /// <p>Data quality statistics for a model.</p>
        pub fn set_statistics(
            mut self,
            input: std::option::Option<crate::model::MetricsSource>,
        ) -> Self {
            self.statistics = input;
            self
        }
        /// <p>Data quality constraints for a model.</p>
        pub fn constraints(mut self, input: crate::model::MetricsSource) -> Self {
            self.constraints = Some(input);
            self
        }
        /// <p>Data quality constraints for a model.</p>
        pub fn set_constraints(
            mut self,
            input: std::option::Option<crate::model::MetricsSource>,
        ) -> Self {
            self.constraints = input;
            self
        }
        /// Consumes the builder and constructs a [`ModelDataQuality`](crate::model::ModelDataQuality)
        pub fn build(self) -> crate::model::ModelDataQuality {
            crate::model::ModelDataQuality {
                statistics: self.statistics,
                constraints: self.constraints,
            }
        }
    }
}
impl ModelDataQuality {
    /// Creates a new builder-style object to manufacture [`ModelDataQuality`](crate::model::ModelDataQuality)
    pub fn builder() -> crate::model::model_data_quality::Builder {
        crate::model::model_data_quality::Builder::default()
    }
}

/// <p>Model quality statistics and constraints.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModelQuality {
    /// <p>Model quality statistics.</p>
    pub statistics: std::option::Option<crate::model::MetricsSource>,
    /// <p>Model quality constraints.</p>
    pub constraints: std::option::Option<crate::model::MetricsSource>,
}
impl ModelQuality {
    /// <p>Model quality statistics.</p>
    pub fn statistics(&self) -> std::option::Option<&crate::model::MetricsSource> {
        self.statistics.as_ref()
    }
    /// <p>Model quality constraints.</p>
    pub fn constraints(&self) -> std::option::Option<&crate::model::MetricsSource> {
        self.constraints.as_ref()
    }
}
impl std::fmt::Debug for ModelQuality {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModelQuality");
        formatter.field("statistics", &self.statistics);
        formatter.field("constraints", &self.constraints);
        formatter.finish()
    }
}
/// See [`ModelQuality`](crate::model::ModelQuality)
pub mod model_quality {
    /// A builder for [`ModelQuality`](crate::model::ModelQuality)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) statistics: std::option::Option<crate::model::MetricsSource>,
        pub(crate) constraints: std::option::Option<crate::model::MetricsSource>,
    }
    impl Builder {
        /// <p>Model quality statistics.</p>
        pub fn statistics(mut self, input: crate::model::MetricsSource) -> Self {
            self.statistics = Some(input);
            self
        }
        /// <p>Model quality statistics.</p>
        pub fn set_statistics(
            mut self,
            input: std::option::Option<crate::model::MetricsSource>,
        ) -> Self {
            self.statistics = input;
            self
        }
        /// <p>Model quality constraints.</p>
        pub fn constraints(mut self, input: crate::model::MetricsSource) -> Self {
            self.constraints = Some(input);
            self
        }
        /// <p>Model quality constraints.</p>
        pub fn set_constraints(
            mut self,
            input: std::option::Option<crate::model::MetricsSource>,
        ) -> Self {
            self.constraints = input;
            self
        }
        /// Consumes the builder and constructs a [`ModelQuality`](crate::model::ModelQuality)
        pub fn build(self) -> crate::model::ModelQuality {
            crate::model::ModelQuality {
                statistics: self.statistics,
                constraints: self.constraints,
            }
        }
    }
}
impl ModelQuality {
    /// Creates a new builder-style object to manufacture [`ModelQuality`](crate::model::ModelQuality)
    pub fn builder() -> crate::model::model_quality::Builder {
        crate::model::model_quality::Builder::default()
    }
}

/// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetadataProperties {
    /// <p>The commit ID.</p>
    pub commit_id: std::option::Option<std::string::String>,
    /// <p>The repository.</p>
    pub repository: std::option::Option<std::string::String>,
    /// <p>The entity this entity was generated by.</p>
    pub generated_by: std::option::Option<std::string::String>,
    /// <p>The project ID.</p>
    pub project_id: std::option::Option<std::string::String>,
}
impl MetadataProperties {
    /// <p>The commit ID.</p>
    pub fn commit_id(&self) -> std::option::Option<&str> {
        self.commit_id.as_deref()
    }
    /// <p>The repository.</p>
    pub fn repository(&self) -> std::option::Option<&str> {
        self.repository.as_deref()
    }
    /// <p>The entity this entity was generated by.</p>
    pub fn generated_by(&self) -> std::option::Option<&str> {
        self.generated_by.as_deref()
    }
    /// <p>The project ID.</p>
    pub fn project_id(&self) -> std::option::Option<&str> {
        self.project_id.as_deref()
    }
}
impl std::fmt::Debug for MetadataProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetadataProperties");
        formatter.field("commit_id", &self.commit_id);
        formatter.field("repository", &self.repository);
        formatter.field("generated_by", &self.generated_by);
        formatter.field("project_id", &self.project_id);
        formatter.finish()
    }
}
/// See [`MetadataProperties`](crate::model::MetadataProperties)
pub mod metadata_properties {
    /// A builder for [`MetadataProperties`](crate::model::MetadataProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) commit_id: std::option::Option<std::string::String>,
        pub(crate) repository: std::option::Option<std::string::String>,
        pub(crate) generated_by: std::option::Option<std::string::String>,
        pub(crate) project_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The commit ID.</p>
        pub fn commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_id = Some(input.into());
            self
        }
        /// <p>The commit ID.</p>
        pub fn set_commit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.commit_id = input;
            self
        }
        /// <p>The repository.</p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository = Some(input.into());
            self
        }
        /// <p>The repository.</p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.repository = input;
            self
        }
        /// <p>The entity this entity was generated by.</p>
        pub fn generated_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.generated_by = Some(input.into());
            self
        }
        /// <p>The entity this entity was generated by.</p>
        pub fn set_generated_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.generated_by = input;
            self
        }
        /// <p>The project ID.</p>
        pub fn project_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_id = Some(input.into());
            self
        }
        /// <p>The project ID.</p>
        pub fn set_project_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_id = input;
            self
        }
        /// Consumes the builder and constructs a [`MetadataProperties`](crate::model::MetadataProperties)
        pub fn build(self) -> crate::model::MetadataProperties {
            crate::model::MetadataProperties {
                commit_id: self.commit_id,
                repository: self.repository,
                generated_by: self.generated_by,
                project_id: self.project_id,
            }
        }
    }
}
impl MetadataProperties {
    /// Creates a new builder-style object to manufacture [`MetadataProperties`](crate::model::MetadataProperties)
    pub fn builder() -> crate::model::metadata_properties::Builder {
        crate::model::metadata_properties::Builder::default()
    }
}

/// <p>Specifies the validation and image scan statuses of the model package.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModelPackageStatusDetails {
    /// <p>The validation status of the model package.</p>
    pub validation_statuses:
        std::option::Option<std::vec::Vec<crate::model::ModelPackageStatusItem>>,
    /// <p>The status of the scan of the Docker image container for the model package.</p>
    pub image_scan_statuses:
        std::option::Option<std::vec::Vec<crate::model::ModelPackageStatusItem>>,
}
impl ModelPackageStatusDetails {
    /// <p>The validation status of the model package.</p>
    pub fn validation_statuses(
        &self,
    ) -> std::option::Option<&[crate::model::ModelPackageStatusItem]> {
        self.validation_statuses.as_deref()
    }
    /// <p>The status of the scan of the Docker image container for the model package.</p>
    pub fn image_scan_statuses(
        &self,
    ) -> std::option::Option<&[crate::model::ModelPackageStatusItem]> {
        self.image_scan_statuses.as_deref()
    }
}
impl std::fmt::Debug for ModelPackageStatusDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModelPackageStatusDetails");
        formatter.field("validation_statuses", &self.validation_statuses);
        formatter.field("image_scan_statuses", &self.image_scan_statuses);
        formatter.finish()
    }
}
/// See [`ModelPackageStatusDetails`](crate::model::ModelPackageStatusDetails)
pub mod model_package_status_details {
    /// A builder for [`ModelPackageStatusDetails`](crate::model::ModelPackageStatusDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) validation_statuses:
            std::option::Option<std::vec::Vec<crate::model::ModelPackageStatusItem>>,
        pub(crate) image_scan_statuses:
            std::option::Option<std::vec::Vec<crate::model::ModelPackageStatusItem>>,
    }
    impl Builder {
        /// Appends an item to `validation_statuses`.
        ///
        /// To override the contents of this collection use [`set_validation_statuses`](Self::set_validation_statuses).
        ///
        /// <p>The validation status of the model package.</p>
        pub fn validation_statuses(
            mut self,
            input: impl Into<crate::model::ModelPackageStatusItem>,
        ) -> Self {
            let mut v = self.validation_statuses.unwrap_or_default();
            v.push(input.into());
            self.validation_statuses = Some(v);
            self
        }
        /// <p>The validation status of the model package.</p>
        pub fn set_validation_statuses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ModelPackageStatusItem>>,
        ) -> Self {
            self.validation_statuses = input;
            self
        }
        /// Appends an item to `image_scan_statuses`.
        ///
        /// To override the contents of this collection use [`set_image_scan_statuses`](Self::set_image_scan_statuses).
        ///
        /// <p>The status of the scan of the Docker image container for the model package.</p>
        pub fn image_scan_statuses(
            mut self,
            input: impl Into<crate::model::ModelPackageStatusItem>,
        ) -> Self {
            let mut v = self.image_scan_statuses.unwrap_or_default();
            v.push(input.into());
            self.image_scan_statuses = Some(v);
            self
        }
        /// <p>The status of the scan of the Docker image container for the model package.</p>
        pub fn set_image_scan_statuses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ModelPackageStatusItem>>,
        ) -> Self {
            self.image_scan_statuses = input;
            self
        }
        /// Consumes the builder and constructs a [`ModelPackageStatusDetails`](crate::model::ModelPackageStatusDetails)
        pub fn build(self) -> crate::model::ModelPackageStatusDetails {
            crate::model::ModelPackageStatusDetails {
                validation_statuses: self.validation_statuses,
                image_scan_statuses: self.image_scan_statuses,
            }
        }
    }
}
impl ModelPackageStatusDetails {
    /// Creates a new builder-style object to manufacture [`ModelPackageStatusDetails`](crate::model::ModelPackageStatusDetails)
    pub fn builder() -> crate::model::model_package_status_details::Builder {
        crate::model::model_package_status_details::Builder::default()
    }
}

/// <p>Represents the overall status of a model package.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModelPackageStatusItem {
    /// <p>The name of the model package for which the overall status is being reported.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The current status.</p>
    pub status: std::option::Option<crate::model::DetailedModelPackageStatus>,
    /// <p>if the overall status is <code>Failed</code>, the reason for the failure.</p>
    pub failure_reason: std::option::Option<std::string::String>,
}
impl ModelPackageStatusItem {
    /// <p>The name of the model package for which the overall status is being reported.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The current status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DetailedModelPackageStatus> {
        self.status.as_ref()
    }
    /// <p>if the overall status is <code>Failed</code>, the reason for the failure.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
}
impl std::fmt::Debug for ModelPackageStatusItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModelPackageStatusItem");
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.finish()
    }
}
/// See [`ModelPackageStatusItem`](crate::model::ModelPackageStatusItem)
pub mod model_package_status_item {
    /// A builder for [`ModelPackageStatusItem`](crate::model::ModelPackageStatusItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DetailedModelPackageStatus>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the model package for which the overall status is being reported.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the model package for which the overall status is being reported.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The current status.</p>
        pub fn status(mut self, input: crate::model::DetailedModelPackageStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DetailedModelPackageStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>if the overall status is <code>Failed</code>, the reason for the failure.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>if the overall status is <code>Failed</code>, the reason for the failure.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`ModelPackageStatusItem`](crate::model::ModelPackageStatusItem)
        pub fn build(self) -> crate::model::ModelPackageStatusItem {
            crate::model::ModelPackageStatusItem {
                name: self.name,
                status: self.status,
                failure_reason: self.failure_reason,
            }
        }
    }
}
impl ModelPackageStatusItem {
    /// Creates a new builder-style object to manufacture [`ModelPackageStatusItem`](crate::model::ModelPackageStatusItem)
    pub fn builder() -> crate::model::model_package_status_item::Builder {
        crate::model::model_package_status_item::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DetailedModelPackageStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    NotStarted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DetailedModelPackageStatus {
    fn from(s: &str) -> Self {
        match s {
            "Completed" => DetailedModelPackageStatus::Completed,
            "Failed" => DetailedModelPackageStatus::Failed,
            "InProgress" => DetailedModelPackageStatus::InProgress,
            "NotStarted" => DetailedModelPackageStatus::NotStarted,
            other => DetailedModelPackageStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DetailedModelPackageStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DetailedModelPackageStatus::from(s))
    }
}
impl DetailedModelPackageStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DetailedModelPackageStatus::Completed => "Completed",
            DetailedModelPackageStatus::Failed => "Failed",
            DetailedModelPackageStatus::InProgress => "InProgress",
            DetailedModelPackageStatus::NotStarted => "NotStarted",
            DetailedModelPackageStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Completed", "Failed", "InProgress", "NotStarted"]
    }
}
impl AsRef<str> for DetailedModelPackageStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ModelPackageStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ModelPackageStatus {
    fn from(s: &str) -> Self {
        match s {
            "Completed" => ModelPackageStatus::Completed,
            "Deleting" => ModelPackageStatus::Deleting,
            "Failed" => ModelPackageStatus::Failed,
            "InProgress" => ModelPackageStatus::InProgress,
            "Pending" => ModelPackageStatus::Pending,
            other => ModelPackageStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ModelPackageStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ModelPackageStatus::from(s))
    }
}
impl ModelPackageStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ModelPackageStatus::Completed => "Completed",
            ModelPackageStatus::Deleting => "Deleting",
            ModelPackageStatus::Failed => "Failed",
            ModelPackageStatus::InProgress => "InProgress",
            ModelPackageStatus::Pending => "Pending",
            ModelPackageStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Completed", "Deleting", "Failed", "InProgress", "Pending"]
    }
}
impl AsRef<str> for ModelPackageStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies batch transform jobs that Amazon SageMaker runs to validate your model package.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModelPackageValidationSpecification {
    /// <p>The IAM roles to be used for the validation of the model package.</p>
    pub validation_role: std::option::Option<std::string::String>,
    /// <p>An array of <code>ModelPackageValidationProfile</code> objects, each of which
    /// specifies a batch transform job that Amazon SageMaker runs to validate your model package.</p>
    pub validation_profiles:
        std::option::Option<std::vec::Vec<crate::model::ModelPackageValidationProfile>>,
}
impl ModelPackageValidationSpecification {
    /// <p>The IAM roles to be used for the validation of the model package.</p>
    pub fn validation_role(&self) -> std::option::Option<&str> {
        self.validation_role.as_deref()
    }
    /// <p>An array of <code>ModelPackageValidationProfile</code> objects, each of which
    /// specifies a batch transform job that Amazon SageMaker runs to validate your model package.</p>
    pub fn validation_profiles(
        &self,
    ) -> std::option::Option<&[crate::model::ModelPackageValidationProfile]> {
        self.validation_profiles.as_deref()
    }
}
impl std::fmt::Debug for ModelPackageValidationSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModelPackageValidationSpecification");
        formatter.field("validation_role", &self.validation_role);
        formatter.field("validation_profiles", &self.validation_profiles);
        formatter.finish()
    }
}
/// See [`ModelPackageValidationSpecification`](crate::model::ModelPackageValidationSpecification)
pub mod model_package_validation_specification {
    /// A builder for [`ModelPackageValidationSpecification`](crate::model::ModelPackageValidationSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) validation_role: std::option::Option<std::string::String>,
        pub(crate) validation_profiles:
            std::option::Option<std::vec::Vec<crate::model::ModelPackageValidationProfile>>,
    }
    impl Builder {
        /// <p>The IAM roles to be used for the validation of the model package.</p>
        pub fn validation_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.validation_role = Some(input.into());
            self
        }
        /// <p>The IAM roles to be used for the validation of the model package.</p>
        pub fn set_validation_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.validation_role = input;
            self
        }
        /// Appends an item to `validation_profiles`.
        ///
        /// To override the contents of this collection use [`set_validation_profiles`](Self::set_validation_profiles).
        ///
        /// <p>An array of <code>ModelPackageValidationProfile</code> objects, each of which
        /// specifies a batch transform job that Amazon SageMaker runs to validate your model package.</p>
        pub fn validation_profiles(
            mut self,
            input: impl Into<crate::model::ModelPackageValidationProfile>,
        ) -> Self {
            let mut v = self.validation_profiles.unwrap_or_default();
            v.push(input.into());
            self.validation_profiles = Some(v);
            self
        }
        /// <p>An array of <code>ModelPackageValidationProfile</code> objects, each of which
        /// specifies a batch transform job that Amazon SageMaker runs to validate your model package.</p>
        pub fn set_validation_profiles(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ModelPackageValidationProfile>>,
        ) -> Self {
            self.validation_profiles = input;
            self
        }
        /// Consumes the builder and constructs a [`ModelPackageValidationSpecification`](crate::model::ModelPackageValidationSpecification)
        pub fn build(self) -> crate::model::ModelPackageValidationSpecification {
            crate::model::ModelPackageValidationSpecification {
                validation_role: self.validation_role,
                validation_profiles: self.validation_profiles,
            }
        }
    }
}
impl ModelPackageValidationSpecification {
    /// Creates a new builder-style object to manufacture [`ModelPackageValidationSpecification`](crate::model::ModelPackageValidationSpecification)
    pub fn builder() -> crate::model::model_package_validation_specification::Builder {
        crate::model::model_package_validation_specification::Builder::default()
    }
}

/// <p>Contains data, such as the inputs and targeted instance types that are used in the
/// process of validating the model package.</p>
/// <p>The data provided in the validation profile is made available to your buyers on Amazon Web Services
/// Marketplace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModelPackageValidationProfile {
    /// <p>The name of the profile for the model package.</p>
    pub profile_name: std::option::Option<std::string::String>,
    /// <p>The <code>TransformJobDefinition</code> object that describes the transform job used
    /// for the validation of the model package.</p>
    pub transform_job_definition: std::option::Option<crate::model::TransformJobDefinition>,
}
impl ModelPackageValidationProfile {
    /// <p>The name of the profile for the model package.</p>
    pub fn profile_name(&self) -> std::option::Option<&str> {
        self.profile_name.as_deref()
    }
    /// <p>The <code>TransformJobDefinition</code> object that describes the transform job used
    /// for the validation of the model package.</p>
    pub fn transform_job_definition(
        &self,
    ) -> std::option::Option<&crate::model::TransformJobDefinition> {
        self.transform_job_definition.as_ref()
    }
}
impl std::fmt::Debug for ModelPackageValidationProfile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModelPackageValidationProfile");
        formatter.field("profile_name", &self.profile_name);
        formatter.field("transform_job_definition", &self.transform_job_definition);
        formatter.finish()
    }
}
/// See [`ModelPackageValidationProfile`](crate::model::ModelPackageValidationProfile)
pub mod model_package_validation_profile {
    /// A builder for [`ModelPackageValidationProfile`](crate::model::ModelPackageValidationProfile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profile_name: std::option::Option<std::string::String>,
        pub(crate) transform_job_definition:
            std::option::Option<crate::model::TransformJobDefinition>,
    }
    impl Builder {
        /// <p>The name of the profile for the model package.</p>
        pub fn profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_name = Some(input.into());
            self
        }
        /// <p>The name of the profile for the model package.</p>
        pub fn set_profile_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_name = input;
            self
        }
        /// <p>The <code>TransformJobDefinition</code> object that describes the transform job used
        /// for the validation of the model package.</p>
        pub fn transform_job_definition(
            mut self,
            input: crate::model::TransformJobDefinition,
        ) -> Self {
            self.transform_job_definition = Some(input);
            self
        }
        /// <p>The <code>TransformJobDefinition</code> object that describes the transform job used
        /// for the validation of the model package.</p>
        pub fn set_transform_job_definition(
            mut self,
            input: std::option::Option<crate::model::TransformJobDefinition>,
        ) -> Self {
            self.transform_job_definition = input;
            self
        }
        /// Consumes the builder and constructs a [`ModelPackageValidationProfile`](crate::model::ModelPackageValidationProfile)
        pub fn build(self) -> crate::model::ModelPackageValidationProfile {
            crate::model::ModelPackageValidationProfile {
                profile_name: self.profile_name,
                transform_job_definition: self.transform_job_definition,
            }
        }
    }
}
impl ModelPackageValidationProfile {
    /// Creates a new builder-style object to manufacture [`ModelPackageValidationProfile`](crate::model::ModelPackageValidationProfile)
    pub fn builder() -> crate::model::model_package_validation_profile::Builder {
        crate::model::model_package_validation_profile::Builder::default()
    }
}

/// <p>Defines the input needed to run a transform job using the inference specification
/// specified in the algorithm.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransformJobDefinition {
    /// <p>The maximum number of parallel requests that can be sent to each instance in a
    /// transform job. The default value is 1.</p>
    pub max_concurrent_transforms: std::option::Option<i32>,
    /// <p>The maximum payload size allowed, in MB. A payload is the data portion of a record
    /// (without metadata).</p>
    pub max_payload_in_mb: std::option::Option<i32>,
    /// <p>A string that determines the number of records included in a single mini-batch.</p>
    /// <p>
    /// <code>SingleRecord</code> means only one record is used per mini-batch.
    /// <code>MultiRecord</code> means a mini-batch is set to contain as many records that
    /// can fit within the <code>MaxPayloadInMB</code> limit.</p>
    pub batch_strategy: std::option::Option<crate::model::BatchStrategy>,
    /// <p>The environment variables to set in the Docker container. We support up to 16 key and
    /// values entries in the map.</p>
    pub environment:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A description of the input source and the way the transform job consumes it.</p>
    pub transform_input: std::option::Option<crate::model::TransformInput>,
    /// <p>Identifies the Amazon S3 location where you want Amazon SageMaker to save the results
    /// from the transform job.</p>
    pub transform_output: std::option::Option<crate::model::TransformOutput>,
    /// <p>Identifies the ML compute instances for the transform job.</p>
    pub transform_resources: std::option::Option<crate::model::TransformResources>,
}
impl TransformJobDefinition {
    /// <p>The maximum number of parallel requests that can be sent to each instance in a
    /// transform job. The default value is 1.</p>
    pub fn max_concurrent_transforms(&self) -> std::option::Option<i32> {
        self.max_concurrent_transforms
    }
    /// <p>The maximum payload size allowed, in MB. A payload is the data portion of a record
    /// (without metadata).</p>
    pub fn max_payload_in_mb(&self) -> std::option::Option<i32> {
        self.max_payload_in_mb
    }
    /// <p>A string that determines the number of records included in a single mini-batch.</p>
    /// <p>
    /// <code>SingleRecord</code> means only one record is used per mini-batch.
    /// <code>MultiRecord</code> means a mini-batch is set to contain as many records that
    /// can fit within the <code>MaxPayloadInMB</code> limit.</p>
    pub fn batch_strategy(&self) -> std::option::Option<&crate::model::BatchStrategy> {
        self.batch_strategy.as_ref()
    }
    /// <p>The environment variables to set in the Docker container. We support up to 16 key and
    /// values entries in the map.</p>
    pub fn environment(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.environment.as_ref()
    }
    /// <p>A description of the input source and the way the transform job consumes it.</p>
    pub fn transform_input(&self) -> std::option::Option<&crate::model::TransformInput> {
        self.transform_input.as_ref()
    }
    /// <p>Identifies the Amazon S3 location where you want Amazon SageMaker to save the results
    /// from the transform job.</p>
    pub fn transform_output(&self) -> std::option::Option<&crate::model::TransformOutput> {
        self.transform_output.as_ref()
    }
    /// <p>Identifies the ML compute instances for the transform job.</p>
    pub fn transform_resources(&self) -> std::option::Option<&crate::model::TransformResources> {
        self.transform_resources.as_ref()
    }
}
impl std::fmt::Debug for TransformJobDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransformJobDefinition");
        formatter.field("max_concurrent_transforms", &self.max_concurrent_transforms);
        formatter.field("max_payload_in_mb", &self.max_payload_in_mb);
        formatter.field("batch_strategy", &self.batch_strategy);
        formatter.field("environment", &self.environment);
        formatter.field("transform_input", &self.transform_input);
        formatter.field("transform_output", &self.transform_output);
        formatter.field("transform_resources", &self.transform_resources);
        formatter.finish()
    }
}
/// See [`TransformJobDefinition`](crate::model::TransformJobDefinition)
pub mod transform_job_definition {
    /// A builder for [`TransformJobDefinition`](crate::model::TransformJobDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_concurrent_transforms: std::option::Option<i32>,
        pub(crate) max_payload_in_mb: std::option::Option<i32>,
        pub(crate) batch_strategy: std::option::Option<crate::model::BatchStrategy>,
        pub(crate) environment: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) transform_input: std::option::Option<crate::model::TransformInput>,
        pub(crate) transform_output: std::option::Option<crate::model::TransformOutput>,
        pub(crate) transform_resources: std::option::Option<crate::model::TransformResources>,
    }
    impl Builder {
        /// <p>The maximum number of parallel requests that can be sent to each instance in a
        /// transform job. The default value is 1.</p>
        pub fn max_concurrent_transforms(mut self, input: i32) -> Self {
            self.max_concurrent_transforms = Some(input);
            self
        }
        /// <p>The maximum number of parallel requests that can be sent to each instance in a
        /// transform job. The default value is 1.</p>
        pub fn set_max_concurrent_transforms(mut self, input: std::option::Option<i32>) -> Self {
            self.max_concurrent_transforms = input;
            self
        }
        /// <p>The maximum payload size allowed, in MB. A payload is the data portion of a record
        /// (without metadata).</p>
        pub fn max_payload_in_mb(mut self, input: i32) -> Self {
            self.max_payload_in_mb = Some(input);
            self
        }
        /// <p>The maximum payload size allowed, in MB. A payload is the data portion of a record
        /// (without metadata).</p>
        pub fn set_max_payload_in_mb(mut self, input: std::option::Option<i32>) -> Self {
            self.max_payload_in_mb = input;
            self
        }
        /// <p>A string that determines the number of records included in a single mini-batch.</p>
        /// <p>
        /// <code>SingleRecord</code> means only one record is used per mini-batch.
        /// <code>MultiRecord</code> means a mini-batch is set to contain as many records that
        /// can fit within the <code>MaxPayloadInMB</code> limit.</p>
        pub fn batch_strategy(mut self, input: crate::model::BatchStrategy) -> Self {
            self.batch_strategy = Some(input);
            self
        }
        /// <p>A string that determines the number of records included in a single mini-batch.</p>
        /// <p>
        /// <code>SingleRecord</code> means only one record is used per mini-batch.
        /// <code>MultiRecord</code> means a mini-batch is set to contain as many records that
        /// can fit within the <code>MaxPayloadInMB</code> limit.</p>
        pub fn set_batch_strategy(
            mut self,
            input: std::option::Option<crate::model::BatchStrategy>,
        ) -> Self {
            self.batch_strategy = input;
            self
        }
        /// Adds a key-value pair to `environment`.
        ///
        /// To override the contents of this collection use [`set_environment`](Self::set_environment).
        ///
        /// <p>The environment variables to set in the Docker container. We support up to 16 key and
        /// values entries in the map.</p>
        pub fn environment(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.environment.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.environment = Some(hash_map);
            self
        }
        /// <p>The environment variables to set in the Docker container. We support up to 16 key and
        /// values entries in the map.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.environment = input;
            self
        }
        /// <p>A description of the input source and the way the transform job consumes it.</p>
        pub fn transform_input(mut self, input: crate::model::TransformInput) -> Self {
            self.transform_input = Some(input);
            self
        }
        /// <p>A description of the input source and the way the transform job consumes it.</p>
        pub fn set_transform_input(
            mut self,
            input: std::option::Option<crate::model::TransformInput>,
        ) -> Self {
            self.transform_input = input;
            self
        }
        /// <p>Identifies the Amazon S3 location where you want Amazon SageMaker to save the results
        /// from the transform job.</p>
        pub fn transform_output(mut self, input: crate::model::TransformOutput) -> Self {
            self.transform_output = Some(input);
            self
        }
        /// <p>Identifies the Amazon S3 location where you want Amazon SageMaker to save the results
        /// from the transform job.</p>
        pub fn set_transform_output(
            mut self,
            input: std::option::Option<crate::model::TransformOutput>,
        ) -> Self {
            self.transform_output = input;
            self
        }
        /// <p>Identifies the ML compute instances for the transform job.</p>
        pub fn transform_resources(mut self, input: crate::model::TransformResources) -> Self {
            self.transform_resources = Some(input);
            self
        }
        /// <p>Identifies the ML compute instances for the transform job.</p>
        pub fn set_transform_resources(
            mut self,
            input: std::option::Option<crate::model::TransformResources>,
        ) -> Self {
            self.transform_resources = input;
            self
        }
        /// Consumes the builder and constructs a [`TransformJobDefinition`](crate::model::TransformJobDefinition)
        pub fn build(self) -> crate::model::TransformJobDefinition {
            crate::model::TransformJobDefinition {
                max_concurrent_transforms: self.max_concurrent_transforms,
                max_payload_in_mb: self.max_payload_in_mb,
                batch_strategy: self.batch_strategy,
                environment: self.environment,
                transform_input: self.transform_input,
                transform_output: self.transform_output,
                transform_resources: self.transform_resources,
            }
        }
    }
}
impl TransformJobDefinition {
    /// Creates a new builder-style object to manufacture [`TransformJobDefinition`](crate::model::TransformJobDefinition)
    pub fn builder() -> crate::model::transform_job_definition::Builder {
        crate::model::transform_job_definition::Builder::default()
    }
}

/// <p>Describes the resources, including ML instance types and ML instance count, to use for
/// transform job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransformResources {
    /// <p>The ML compute instance type for the transform job. If you are using built-in
    /// algorithms to
    /// transform
    /// moderately sized datasets, we recommend using ml.m4.xlarge or
    /// <code>ml.m5.large</code>instance types.</p>
    pub instance_type: std::option::Option<crate::model::TransformInstanceType>,
    /// <p>The number of
    /// ML
    /// compute instances to use in the transform job. For distributed
    /// transform jobs, specify a value greater than 1. The default value is
    /// <code>1</code>.</p>
    pub instance_count: std::option::Option<i32>,
    /// <p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt model data on the storage volume
    /// attached to the ML compute instance(s) that run the batch transform job.</p>
    /// <note>
    /// <p>Certain Nitro-based instances include local storage, dependent on the instance
    /// type. Local storage volumes are encrypted using a hardware module on the instance.
    /// You can't request a <code>VolumeKmsKeyId</code> when using an instance type with
    /// local storage.</p>
    /// <p>For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a>.</p>
    /// <p>For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD
    /// Instance Store Volumes</a>.</p>
    /// </note>
    /// <p>
    /// The <code>VolumeKmsKeyId</code> can be any of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Key ARN:
    /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Alias name: <code>alias/ExampleAlias</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Alias name ARN:
    /// <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code>
    /// </p>
    /// </li>
    /// </ul>
    pub volume_kms_key_id: std::option::Option<std::string::String>,
}
impl TransformResources {
    /// <p>The ML compute instance type for the transform job. If you are using built-in
    /// algorithms to
    /// transform
    /// moderately sized datasets, we recommend using ml.m4.xlarge or
    /// <code>ml.m5.large</code>instance types.</p>
    pub fn instance_type(&self) -> std::option::Option<&crate::model::TransformInstanceType> {
        self.instance_type.as_ref()
    }
    /// <p>The number of
    /// ML
    /// compute instances to use in the transform job. For distributed
    /// transform jobs, specify a value greater than 1. The default value is
    /// <code>1</code>.</p>
    pub fn instance_count(&self) -> std::option::Option<i32> {
        self.instance_count
    }
    /// <p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt model data on the storage volume
    /// attached to the ML compute instance(s) that run the batch transform job.</p>
    /// <note>
    /// <p>Certain Nitro-based instances include local storage, dependent on the instance
    /// type. Local storage volumes are encrypted using a hardware module on the instance.
    /// You can't request a <code>VolumeKmsKeyId</code> when using an instance type with
    /// local storage.</p>
    /// <p>For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a>.</p>
    /// <p>For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD
    /// Instance Store Volumes</a>.</p>
    /// </note>
    /// <p>
    /// The <code>VolumeKmsKeyId</code> can be any of the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Key ARN:
    /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Alias name: <code>alias/ExampleAlias</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Alias name ARN:
    /// <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn volume_kms_key_id(&self) -> std::option::Option<&str> {
        self.volume_kms_key_id.as_deref()
    }
}
impl std::fmt::Debug for TransformResources {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransformResources");
        formatter.field("instance_type", &self.instance_type);
        formatter.field("instance_count", &self.instance_count);
        formatter.field("volume_kms_key_id", &self.volume_kms_key_id);
        formatter.finish()
    }
}
/// See [`TransformResources`](crate::model::TransformResources)
pub mod transform_resources {
    /// A builder for [`TransformResources`](crate::model::TransformResources)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_type: std::option::Option<crate::model::TransformInstanceType>,
        pub(crate) instance_count: std::option::Option<i32>,
        pub(crate) volume_kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ML compute instance type for the transform job. If you are using built-in
        /// algorithms to
        /// transform
        /// moderately sized datasets, we recommend using ml.m4.xlarge or
        /// <code>ml.m5.large</code>instance types.</p>
        pub fn instance_type(mut self, input: crate::model::TransformInstanceType) -> Self {
            self.instance_type = Some(input);
            self
        }
        /// <p>The ML compute instance type for the transform job. If you are using built-in
        /// algorithms to
        /// transform
        /// moderately sized datasets, we recommend using ml.m4.xlarge or
        /// <code>ml.m5.large</code>instance types.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<crate::model::TransformInstanceType>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The number of
        /// ML
        /// compute instances to use in the transform job. For distributed
        /// transform jobs, specify a value greater than 1. The default value is
        /// <code>1</code>.</p>
        pub fn instance_count(mut self, input: i32) -> Self {
            self.instance_count = Some(input);
            self
        }
        /// <p>The number of
        /// ML
        /// compute instances to use in the transform job. For distributed
        /// transform jobs, specify a value greater than 1. The default value is
        /// <code>1</code>.</p>
        pub fn set_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.instance_count = input;
            self
        }
        /// <p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt model data on the storage volume
        /// attached to the ML compute instance(s) that run the batch transform job.</p>
        /// <note>
        /// <p>Certain Nitro-based instances include local storage, dependent on the instance
        /// type. Local storage volumes are encrypted using a hardware module on the instance.
        /// You can't request a <code>VolumeKmsKeyId</code> when using an instance type with
        /// local storage.</p>
        /// <p>For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a>.</p>
        /// <p>For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD
        /// Instance Store Volumes</a>.</p>
        /// </note>
        /// <p>
        /// The <code>VolumeKmsKeyId</code> can be any of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Key ARN:
        /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias name: <code>alias/ExampleAlias</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias name ARN:
        /// <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn volume_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt model data on the storage volume
        /// attached to the ML compute instance(s) that run the batch transform job.</p>
        /// <note>
        /// <p>Certain Nitro-based instances include local storage, dependent on the instance
        /// type. Local storage volumes are encrypted using a hardware module on the instance.
        /// You can't request a <code>VolumeKmsKeyId</code> when using an instance type with
        /// local storage.</p>
        /// <p>For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a>.</p>
        /// <p>For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD
        /// Instance Store Volumes</a>.</p>
        /// </note>
        /// <p>
        /// The <code>VolumeKmsKeyId</code> can be any of the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Key ARN:
        /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias name: <code>alias/ExampleAlias</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias name ARN:
        /// <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_volume_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.volume_kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`TransformResources`](crate::model::TransformResources)
        pub fn build(self) -> crate::model::TransformResources {
            crate::model::TransformResources {
                instance_type: self.instance_type,
                instance_count: self.instance_count,
                volume_kms_key_id: self.volume_kms_key_id,
            }
        }
    }
}
impl TransformResources {
    /// Creates a new builder-style object to manufacture [`TransformResources`](crate::model::TransformResources)
    pub fn builder() -> crate::model::transform_resources::Builder {
        crate::model::transform_resources::Builder::default()
    }
}

/// <p>Describes the results of a transform job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransformOutput {
    /// <p>The Amazon S3 path where you want Amazon SageMaker to store the results of the transform job. For
    /// example, <code>s3://bucket-name/key-name-prefix</code>.</p>
    /// <p>For every S3 object used as input for the transform job, batch transform stores the
    /// transformed data with an .<code>out</code> suffix in a corresponding subfolder in the
    /// location in the output prefix. For example, for the input data stored at
    /// <code>s3://bucket-name/input-name-prefix/dataset01/data.csv</code>, batch transform
    /// stores the transformed data at
    /// <code>s3://bucket-name/output-name-prefix/input-name-prefix/data.csv.out</code>.
    /// Batch transform doesn't upload partially processed objects. For an input S3 object that
    /// contains multiple records, it creates an .<code>out</code> file only if the transform
    /// job succeeds on the entire file. When the input contains multiple S3 objects, the batch
    /// transform job processes the listed S3 objects and uploads only the output for
    /// successfully processed objects. If any object fails in the transform job batch transform
    /// marks the job as failed to prompt investigation.</p>
    pub s3_output_path: std::option::Option<std::string::String>,
    /// <p>The MIME type used to specify the output data. Amazon SageMaker uses the MIME type with each http
    /// call to transfer data from the transform job.</p>
    pub accept: std::option::Option<std::string::String>,
    /// <p>Defines how to assemble the results of the transform job as a single S3 object. Choose
    /// a format that is most convenient to you. To concatenate the results in binary format,
    /// specify <code>None</code>. To add a newline character at the end of every transformed
    /// record, specify
    /// <code>Line</code>.</p>
    pub assemble_with: std::option::Option<crate::model::AssemblyType>,
    /// <p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using
    /// Amazon S3 server-side encryption. The <code>KmsKeyId</code> can be any of the following
    /// formats: </p>
    /// <ul>
    /// <li>
    /// <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Key ARN:
    /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Alias name: <code>alias/ExampleAlias</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Alias name ARN:
    /// <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code>
    /// </p>
    /// </li>
    /// </ul>
    ///
    ///
    /// <p>If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your
    /// role's account. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">KMS-Managed Encryption Keys</a> in the
    /// <i>Amazon Simple Storage Service
    /// Developer Guide.</i>
    /// </p>
    /// <p>The KMS key policy must grant permission to the IAM role that you specify in your
    /// <a>CreateModel</a> request. For more information, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Using
    /// Key Policies in Amazon Web Services KMS</a> in the <i>Amazon Web Services Key Management Service Developer
    /// Guide</i>.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
}
impl TransformOutput {
    /// <p>The Amazon S3 path where you want Amazon SageMaker to store the results of the transform job. For
    /// example, <code>s3://bucket-name/key-name-prefix</code>.</p>
    /// <p>For every S3 object used as input for the transform job, batch transform stores the
    /// transformed data with an .<code>out</code> suffix in a corresponding subfolder in the
    /// location in the output prefix. For example, for the input data stored at
    /// <code>s3://bucket-name/input-name-prefix/dataset01/data.csv</code>, batch transform
    /// stores the transformed data at
    /// <code>s3://bucket-name/output-name-prefix/input-name-prefix/data.csv.out</code>.
    /// Batch transform doesn't upload partially processed objects. For an input S3 object that
    /// contains multiple records, it creates an .<code>out</code> file only if the transform
    /// job succeeds on the entire file. When the input contains multiple S3 objects, the batch
    /// transform job processes the listed S3 objects and uploads only the output for
    /// successfully processed objects. If any object fails in the transform job batch transform
    /// marks the job as failed to prompt investigation.</p>
    pub fn s3_output_path(&self) -> std::option::Option<&str> {
        self.s3_output_path.as_deref()
    }
    /// <p>The MIME type used to specify the output data. Amazon SageMaker uses the MIME type with each http
    /// call to transfer data from the transform job.</p>
    pub fn accept(&self) -> std::option::Option<&str> {
        self.accept.as_deref()
    }
    /// <p>Defines how to assemble the results of the transform job as a single S3 object. Choose
    /// a format that is most convenient to you. To concatenate the results in binary format,
    /// specify <code>None</code>. To add a newline character at the end of every transformed
    /// record, specify
    /// <code>Line</code>.</p>
    pub fn assemble_with(&self) -> std::option::Option<&crate::model::AssemblyType> {
        self.assemble_with.as_ref()
    }
    /// <p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using
    /// Amazon S3 server-side encryption. The <code>KmsKeyId</code> can be any of the following
    /// formats: </p>
    /// <ul>
    /// <li>
    /// <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Key ARN:
    /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Alias name: <code>alias/ExampleAlias</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Alias name ARN:
    /// <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code>
    /// </p>
    /// </li>
    /// </ul>
    ///
    ///
    /// <p>If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your
    /// role's account. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">KMS-Managed Encryption Keys</a> in the
    /// <i>Amazon Simple Storage Service
    /// Developer Guide.</i>
    /// </p>
    /// <p>The KMS key policy must grant permission to the IAM role that you specify in your
    /// <a>CreateModel</a> request. For more information, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Using
    /// Key Policies in Amazon Web Services KMS</a> in the <i>Amazon Web Services Key Management Service Developer
    /// Guide</i>.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
}
impl std::fmt::Debug for TransformOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransformOutput");
        formatter.field("s3_output_path", &self.s3_output_path);
        formatter.field("accept", &self.accept);
        formatter.field("assemble_with", &self.assemble_with);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.finish()
    }
}
/// See [`TransformOutput`](crate::model::TransformOutput)
pub mod transform_output {
    /// A builder for [`TransformOutput`](crate::model::TransformOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_output_path: std::option::Option<std::string::String>,
        pub(crate) accept: std::option::Option<std::string::String>,
        pub(crate) assemble_with: std::option::Option<crate::model::AssemblyType>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon S3 path where you want Amazon SageMaker to store the results of the transform job. For
        /// example, <code>s3://bucket-name/key-name-prefix</code>.</p>
        /// <p>For every S3 object used as input for the transform job, batch transform stores the
        /// transformed data with an .<code>out</code> suffix in a corresponding subfolder in the
        /// location in the output prefix. For example, for the input data stored at
        /// <code>s3://bucket-name/input-name-prefix/dataset01/data.csv</code>, batch transform
        /// stores the transformed data at
        /// <code>s3://bucket-name/output-name-prefix/input-name-prefix/data.csv.out</code>.
        /// Batch transform doesn't upload partially processed objects. For an input S3 object that
        /// contains multiple records, it creates an .<code>out</code> file only if the transform
        /// job succeeds on the entire file. When the input contains multiple S3 objects, the batch
        /// transform job processes the listed S3 objects and uploads only the output for
        /// successfully processed objects. If any object fails in the transform job batch transform
        /// marks the job as failed to prompt investigation.</p>
        pub fn s3_output_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_output_path = Some(input.into());
            self
        }
        /// <p>The Amazon S3 path where you want Amazon SageMaker to store the results of the transform job. For
        /// example, <code>s3://bucket-name/key-name-prefix</code>.</p>
        /// <p>For every S3 object used as input for the transform job, batch transform stores the
        /// transformed data with an .<code>out</code> suffix in a corresponding subfolder in the
        /// location in the output prefix. For example, for the input data stored at
        /// <code>s3://bucket-name/input-name-prefix/dataset01/data.csv</code>, batch transform
        /// stores the transformed data at
        /// <code>s3://bucket-name/output-name-prefix/input-name-prefix/data.csv.out</code>.
        /// Batch transform doesn't upload partially processed objects. For an input S3 object that
        /// contains multiple records, it creates an .<code>out</code> file only if the transform
        /// job succeeds on the entire file. When the input contains multiple S3 objects, the batch
        /// transform job processes the listed S3 objects and uploads only the output for
        /// successfully processed objects. If any object fails in the transform job batch transform
        /// marks the job as failed to prompt investigation.</p>
        pub fn set_s3_output_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_output_path = input;
            self
        }
        /// <p>The MIME type used to specify the output data. Amazon SageMaker uses the MIME type with each http
        /// call to transfer data from the transform job.</p>
        pub fn accept(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept = Some(input.into());
            self
        }
        /// <p>The MIME type used to specify the output data. Amazon SageMaker uses the MIME type with each http
        /// call to transfer data from the transform job.</p>
        pub fn set_accept(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.accept = input;
            self
        }
        /// <p>Defines how to assemble the results of the transform job as a single S3 object. Choose
        /// a format that is most convenient to you. To concatenate the results in binary format,
        /// specify <code>None</code>. To add a newline character at the end of every transformed
        /// record, specify
        /// <code>Line</code>.</p>
        pub fn assemble_with(mut self, input: crate::model::AssemblyType) -> Self {
            self.assemble_with = Some(input);
            self
        }
        /// <p>Defines how to assemble the results of the transform job as a single S3 object. Choose
        /// a format that is most convenient to you. To concatenate the results in binary format,
        /// specify <code>None</code>. To add a newline character at the end of every transformed
        /// record, specify
        /// <code>Line</code>.</p>
        pub fn set_assemble_with(
            mut self,
            input: std::option::Option<crate::model::AssemblyType>,
        ) -> Self {
            self.assemble_with = input;
            self
        }
        /// <p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using
        /// Amazon S3 server-side encryption. The <code>KmsKeyId</code> can be any of the following
        /// formats: </p>
        /// <ul>
        /// <li>
        /// <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Key ARN:
        /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias name: <code>alias/ExampleAlias</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias name ARN:
        /// <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code>
        /// </p>
        /// </li>
        /// </ul>
        ///
        ///
        /// <p>If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your
        /// role's account. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">KMS-Managed Encryption Keys</a> in the
        /// <i>Amazon Simple Storage Service
        /// Developer Guide.</i>
        /// </p>
        /// <p>The KMS key policy must grant permission to the IAM role that you specify in your
        /// <a>CreateModel</a> request. For more information, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Using
        /// Key Policies in Amazon Web Services KMS</a> in the <i>Amazon Web Services Key Management Service Developer
        /// Guide</i>.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using
        /// Amazon S3 server-side encryption. The <code>KmsKeyId</code> can be any of the following
        /// formats: </p>
        /// <ul>
        /// <li>
        /// <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Key ARN:
        /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias name: <code>alias/ExampleAlias</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias name ARN:
        /// <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code>
        /// </p>
        /// </li>
        /// </ul>
        ///
        ///
        /// <p>If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your
        /// role's account. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">KMS-Managed Encryption Keys</a> in the
        /// <i>Amazon Simple Storage Service
        /// Developer Guide.</i>
        /// </p>
        /// <p>The KMS key policy must grant permission to the IAM role that you specify in your
        /// <a>CreateModel</a> request. For more information, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Using
        /// Key Policies in Amazon Web Services KMS</a> in the <i>Amazon Web Services Key Management Service Developer
        /// Guide</i>.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`TransformOutput`](crate::model::TransformOutput)
        pub fn build(self) -> crate::model::TransformOutput {
            crate::model::TransformOutput {
                s3_output_path: self.s3_output_path,
                accept: self.accept,
                assemble_with: self.assemble_with,
                kms_key_id: self.kms_key_id,
            }
        }
    }
}
impl TransformOutput {
    /// Creates a new builder-style object to manufacture [`TransformOutput`](crate::model::TransformOutput)
    pub fn builder() -> crate::model::transform_output::Builder {
        crate::model::transform_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AssemblyType {
    #[allow(missing_docs)] // documentation missing in model
    Line,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AssemblyType {
    fn from(s: &str) -> Self {
        match s {
            "Line" => AssemblyType::Line,
            "None" => AssemblyType::None,
            other => AssemblyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AssemblyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AssemblyType::from(s))
    }
}
impl AssemblyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AssemblyType::Line => "Line",
            AssemblyType::None => "None",
            AssemblyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Line", "None"]
    }
}
impl AsRef<str> for AssemblyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the input source of a transform job and the way the transform job consumes
/// it.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransformInput {
    /// <p>Describes the location of
    /// the
    /// channel data, which is, the S3 location of the input data that the
    /// model can consume.</p>
    pub data_source: std::option::Option<crate::model::TransformDataSource>,
    /// <p>The multipurpose internet mail extension
    /// (MIME)
    /// type of the data. Amazon SageMaker uses the MIME type with each http call to
    /// transfer data to the transform job.</p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p>If your transform data
    /// is
    /// compressed, specify the compression type. Amazon SageMaker automatically
    /// decompresses the data for the transform job accordingly. The default value is
    /// <code>None</code>.</p>
    pub compression_type: std::option::Option<crate::model::CompressionType>,
    /// <p>The method to use to split the transform job's data files into smaller batches.
    /// Splitting is necessary when the total size of each object is too large to fit in a
    /// single request. You can also use data splitting to improve performance by processing
    /// multiple concurrent mini-batches. The default value for <code>SplitType</code> is
    /// <code>None</code>, which indicates that input data files are not split, and request
    /// payloads contain the entire contents of an input object. Set the value of this parameter
    /// to <code>Line</code> to split records on a newline character boundary.
    /// <code>SplitType</code> also supports a number of record-oriented binary data
    /// formats. Currently, the supported record formats are:</p>
    /// <ul>
    /// <li>
    /// <p>RecordIO</p>
    /// </li>
    /// <li>
    /// <p>TFRecord</p>
    /// </li>
    /// </ul>
    /// <p>When splitting is enabled, the size of a mini-batch depends on the values of the
    /// <code>BatchStrategy</code> and <code>MaxPayloadInMB</code> parameters. When the
    /// value of <code>BatchStrategy</code> is <code>MultiRecord</code>, Amazon SageMaker sends the maximum
    /// number of records in each request, up to the <code>MaxPayloadInMB</code> limit. If the
    /// value of <code>BatchStrategy</code> is <code>SingleRecord</code>, Amazon SageMaker sends individual
    /// records in each request.</p>
    /// <note>
    /// <p>Some data formats represent a record as a binary payload wrapped with extra
    /// padding bytes. When splitting is applied to a binary data format, padding is removed
    /// if the value of <code>BatchStrategy</code> is set to <code>SingleRecord</code>.
    /// Padding is not removed if the value of <code>BatchStrategy</code> is set to
    /// <code>MultiRecord</code>.</p>
    /// <p>For more information about <code>RecordIO</code>, see <a href="https://mxnet.apache.org/api/faq/recordio">Create a Dataset Using
    /// RecordIO</a> in the MXNet documentation. For more information about
    /// <code>TFRecord</code>, see <a href="https://www.tensorflow.org/guide/data#consuming_tfrecord_data">Consuming TFRecord data</a> in the TensorFlow documentation.</p>
    /// </note>
    pub split_type: std::option::Option<crate::model::SplitType>,
}
impl TransformInput {
    /// <p>Describes the location of
    /// the
    /// channel data, which is, the S3 location of the input data that the
    /// model can consume.</p>
    pub fn data_source(&self) -> std::option::Option<&crate::model::TransformDataSource> {
        self.data_source.as_ref()
    }
    /// <p>The multipurpose internet mail extension
    /// (MIME)
    /// type of the data. Amazon SageMaker uses the MIME type with each http call to
    /// transfer data to the transform job.</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p>If your transform data
    /// is
    /// compressed, specify the compression type. Amazon SageMaker automatically
    /// decompresses the data for the transform job accordingly. The default value is
    /// <code>None</code>.</p>
    pub fn compression_type(&self) -> std::option::Option<&crate::model::CompressionType> {
        self.compression_type.as_ref()
    }
    /// <p>The method to use to split the transform job's data files into smaller batches.
    /// Splitting is necessary when the total size of each object is too large to fit in a
    /// single request. You can also use data splitting to improve performance by processing
    /// multiple concurrent mini-batches. The default value for <code>SplitType</code> is
    /// <code>None</code>, which indicates that input data files are not split, and request
    /// payloads contain the entire contents of an input object. Set the value of this parameter
    /// to <code>Line</code> to split records on a newline character boundary.
    /// <code>SplitType</code> also supports a number of record-oriented binary data
    /// formats. Currently, the supported record formats are:</p>
    /// <ul>
    /// <li>
    /// <p>RecordIO</p>
    /// </li>
    /// <li>
    /// <p>TFRecord</p>
    /// </li>
    /// </ul>
    /// <p>When splitting is enabled, the size of a mini-batch depends on the values of the
    /// <code>BatchStrategy</code> and <code>MaxPayloadInMB</code> parameters. When the
    /// value of <code>BatchStrategy</code> is <code>MultiRecord</code>, Amazon SageMaker sends the maximum
    /// number of records in each request, up to the <code>MaxPayloadInMB</code> limit. If the
    /// value of <code>BatchStrategy</code> is <code>SingleRecord</code>, Amazon SageMaker sends individual
    /// records in each request.</p>
    /// <note>
    /// <p>Some data formats represent a record as a binary payload wrapped with extra
    /// padding bytes. When splitting is applied to a binary data format, padding is removed
    /// if the value of <code>BatchStrategy</code> is set to <code>SingleRecord</code>.
    /// Padding is not removed if the value of <code>BatchStrategy</code> is set to
    /// <code>MultiRecord</code>.</p>
    /// <p>For more information about <code>RecordIO</code>, see <a href="https://mxnet.apache.org/api/faq/recordio">Create a Dataset Using
    /// RecordIO</a> in the MXNet documentation. For more information about
    /// <code>TFRecord</code>, see <a href="https://www.tensorflow.org/guide/data#consuming_tfrecord_data">Consuming TFRecord data</a> in the TensorFlow documentation.</p>
    /// </note>
    pub fn split_type(&self) -> std::option::Option<&crate::model::SplitType> {
        self.split_type.as_ref()
    }
}
impl std::fmt::Debug for TransformInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransformInput");
        formatter.field("data_source", &self.data_source);
        formatter.field("content_type", &self.content_type);
        formatter.field("compression_type", &self.compression_type);
        formatter.field("split_type", &self.split_type);
        formatter.finish()
    }
}
/// See [`TransformInput`](crate::model::TransformInput)
pub mod transform_input {
    /// A builder for [`TransformInput`](crate::model::TransformInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source: std::option::Option<crate::model::TransformDataSource>,
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) compression_type: std::option::Option<crate::model::CompressionType>,
        pub(crate) split_type: std::option::Option<crate::model::SplitType>,
    }
    impl Builder {
        /// <p>Describes the location of
        /// the
        /// channel data, which is, the S3 location of the input data that the
        /// model can consume.</p>
        pub fn data_source(mut self, input: crate::model::TransformDataSource) -> Self {
            self.data_source = Some(input);
            self
        }
        /// <p>Describes the location of
        /// the
        /// channel data, which is, the S3 location of the input data that the
        /// model can consume.</p>
        pub fn set_data_source(
            mut self,
            input: std::option::Option<crate::model::TransformDataSource>,
        ) -> Self {
            self.data_source = input;
            self
        }
        /// <p>The multipurpose internet mail extension
        /// (MIME)
        /// type of the data. Amazon SageMaker uses the MIME type with each http call to
        /// transfer data to the transform job.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The multipurpose internet mail extension
        /// (MIME)
        /// type of the data. Amazon SageMaker uses the MIME type with each http call to
        /// transfer data to the transform job.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>If your transform data
        /// is
        /// compressed, specify the compression type. Amazon SageMaker automatically
        /// decompresses the data for the transform job accordingly. The default value is
        /// <code>None</code>.</p>
        pub fn compression_type(mut self, input: crate::model::CompressionType) -> Self {
            self.compression_type = Some(input);
            self
        }
        /// <p>If your transform data
        /// is
        /// compressed, specify the compression type. Amazon SageMaker automatically
        /// decompresses the data for the transform job accordingly. The default value is
        /// <code>None</code>.</p>
        pub fn set_compression_type(
            mut self,
            input: std::option::Option<crate::model::CompressionType>,
        ) -> Self {
            self.compression_type = input;
            self
        }
        /// <p>The method to use to split the transform job's data files into smaller batches.
        /// Splitting is necessary when the total size of each object is too large to fit in a
        /// single request. You can also use data splitting to improve performance by processing
        /// multiple concurrent mini-batches. The default value for <code>SplitType</code> is
        /// <code>None</code>, which indicates that input data files are not split, and request
        /// payloads contain the entire contents of an input object. Set the value of this parameter
        /// to <code>Line</code> to split records on a newline character boundary.
        /// <code>SplitType</code> also supports a number of record-oriented binary data
        /// formats. Currently, the supported record formats are:</p>
        /// <ul>
        /// <li>
        /// <p>RecordIO</p>
        /// </li>
        /// <li>
        /// <p>TFRecord</p>
        /// </li>
        /// </ul>
        /// <p>When splitting is enabled, the size of a mini-batch depends on the values of the
        /// <code>BatchStrategy</code> and <code>MaxPayloadInMB</code> parameters. When the
        /// value of <code>BatchStrategy</code> is <code>MultiRecord</code>, Amazon SageMaker sends the maximum
        /// number of records in each request, up to the <code>MaxPayloadInMB</code> limit. If the
        /// value of <code>BatchStrategy</code> is <code>SingleRecord</code>, Amazon SageMaker sends individual
        /// records in each request.</p>
        /// <note>
        /// <p>Some data formats represent a record as a binary payload wrapped with extra
        /// padding bytes. When splitting is applied to a binary data format, padding is removed
        /// if the value of <code>BatchStrategy</code> is set to <code>SingleRecord</code>.
        /// Padding is not removed if the value of <code>BatchStrategy</code> is set to
        /// <code>MultiRecord</code>.</p>
        /// <p>For more information about <code>RecordIO</code>, see <a href="https://mxnet.apache.org/api/faq/recordio">Create a Dataset Using
        /// RecordIO</a> in the MXNet documentation. For more information about
        /// <code>TFRecord</code>, see <a href="https://www.tensorflow.org/guide/data#consuming_tfrecord_data">Consuming TFRecord data</a> in the TensorFlow documentation.</p>
        /// </note>
        pub fn split_type(mut self, input: crate::model::SplitType) -> Self {
            self.split_type = Some(input);
            self
        }
        /// <p>The method to use to split the transform job's data files into smaller batches.
        /// Splitting is necessary when the total size of each object is too large to fit in a
        /// single request. You can also use data splitting to improve performance by processing
        /// multiple concurrent mini-batches. The default value for <code>SplitType</code> is
        /// <code>None</code>, which indicates that input data files are not split, and request
        /// payloads contain the entire contents of an input object. Set the value of this parameter
        /// to <code>Line</code> to split records on a newline character boundary.
        /// <code>SplitType</code> also supports a number of record-oriented binary data
        /// formats. Currently, the supported record formats are:</p>
        /// <ul>
        /// <li>
        /// <p>RecordIO</p>
        /// </li>
        /// <li>
        /// <p>TFRecord</p>
        /// </li>
        /// </ul>
        /// <p>When splitting is enabled, the size of a mini-batch depends on the values of the
        /// <code>BatchStrategy</code> and <code>MaxPayloadInMB</code> parameters. When the
        /// value of <code>BatchStrategy</code> is <code>MultiRecord</code>, Amazon SageMaker sends the maximum
        /// number of records in each request, up to the <code>MaxPayloadInMB</code> limit. If the
        /// value of <code>BatchStrategy</code> is <code>SingleRecord</code>, Amazon SageMaker sends individual
        /// records in each request.</p>
        /// <note>
        /// <p>Some data formats represent a record as a binary payload wrapped with extra
        /// padding bytes. When splitting is applied to a binary data format, padding is removed
        /// if the value of <code>BatchStrategy</code> is set to <code>SingleRecord</code>.
        /// Padding is not removed if the value of <code>BatchStrategy</code> is set to
        /// <code>MultiRecord</code>.</p>
        /// <p>For more information about <code>RecordIO</code>, see <a href="https://mxnet.apache.org/api/faq/recordio">Create a Dataset Using
        /// RecordIO</a> in the MXNet documentation. For more information about
        /// <code>TFRecord</code>, see <a href="https://www.tensorflow.org/guide/data#consuming_tfrecord_data">Consuming TFRecord data</a> in the TensorFlow documentation.</p>
        /// </note>
        pub fn set_split_type(
            mut self,
            input: std::option::Option<crate::model::SplitType>,
        ) -> Self {
            self.split_type = input;
            self
        }
        /// Consumes the builder and constructs a [`TransformInput`](crate::model::TransformInput)
        pub fn build(self) -> crate::model::TransformInput {
            crate::model::TransformInput {
                data_source: self.data_source,
                content_type: self.content_type,
                compression_type: self.compression_type,
                split_type: self.split_type,
            }
        }
    }
}
impl TransformInput {
    /// Creates a new builder-style object to manufacture [`TransformInput`](crate::model::TransformInput)
    pub fn builder() -> crate::model::transform_input::Builder {
        crate::model::transform_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SplitType {
    #[allow(missing_docs)] // documentation missing in model
    Line,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Recordio,
    #[allow(missing_docs)] // documentation missing in model
    Tfrecord,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SplitType {
    fn from(s: &str) -> Self {
        match s {
            "Line" => SplitType::Line,
            "None" => SplitType::None,
            "RecordIO" => SplitType::Recordio,
            "TFRecord" => SplitType::Tfrecord,
            other => SplitType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SplitType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SplitType::from(s))
    }
}
impl SplitType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SplitType::Line => "Line",
            SplitType::None => "None",
            SplitType::Recordio => "RecordIO",
            SplitType::Tfrecord => "TFRecord",
            SplitType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Line", "None", "RecordIO", "TFRecord"]
    }
}
impl AsRef<str> for SplitType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CompressionType {
    #[allow(missing_docs)] // documentation missing in model
    Gzip,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CompressionType {
    fn from(s: &str) -> Self {
        match s {
            "Gzip" => CompressionType::Gzip,
            "None" => CompressionType::None,
            other => CompressionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CompressionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CompressionType::from(s))
    }
}
impl CompressionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CompressionType::Gzip => "Gzip",
            CompressionType::None => "None",
            CompressionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Gzip", "None"]
    }
}
impl AsRef<str> for CompressionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the location of the channel data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransformDataSource {
    /// <p>The S3 location of the data source that is associated with a channel.</p>
    pub s3_data_source: std::option::Option<crate::model::TransformS3DataSource>,
}
impl TransformDataSource {
    /// <p>The S3 location of the data source that is associated with a channel.</p>
    pub fn s3_data_source(&self) -> std::option::Option<&crate::model::TransformS3DataSource> {
        self.s3_data_source.as_ref()
    }
}
impl std::fmt::Debug for TransformDataSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransformDataSource");
        formatter.field("s3_data_source", &self.s3_data_source);
        formatter.finish()
    }
}
/// See [`TransformDataSource`](crate::model::TransformDataSource)
pub mod transform_data_source {
    /// A builder for [`TransformDataSource`](crate::model::TransformDataSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_data_source: std::option::Option<crate::model::TransformS3DataSource>,
    }
    impl Builder {
        /// <p>The S3 location of the data source that is associated with a channel.</p>
        pub fn s3_data_source(mut self, input: crate::model::TransformS3DataSource) -> Self {
            self.s3_data_source = Some(input);
            self
        }
        /// <p>The S3 location of the data source that is associated with a channel.</p>
        pub fn set_s3_data_source(
            mut self,
            input: std::option::Option<crate::model::TransformS3DataSource>,
        ) -> Self {
            self.s3_data_source = input;
            self
        }
        /// Consumes the builder and constructs a [`TransformDataSource`](crate::model::TransformDataSource)
        pub fn build(self) -> crate::model::TransformDataSource {
            crate::model::TransformDataSource {
                s3_data_source: self.s3_data_source,
            }
        }
    }
}
impl TransformDataSource {
    /// Creates a new builder-style object to manufacture [`TransformDataSource`](crate::model::TransformDataSource)
    pub fn builder() -> crate::model::transform_data_source::Builder {
        crate::model::transform_data_source::Builder::default()
    }
}

/// <p>Describes the S3 data source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TransformS3DataSource {
    /// <p>If you choose <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix.
    /// Amazon SageMaker uses all objects with the specified key name prefix for batch transform. </p>
    /// <p>If you choose <code>ManifestFile</code>, <code>S3Uri</code> identifies an object that
    /// is a manifest file containing a list of object keys that you want Amazon SageMaker to use for batch
    /// transform. </p>
    /// <p>The following values are compatible: <code>ManifestFile</code>,
    /// <code>S3Prefix</code>
    /// </p>
    /// <p>The following value is not compatible: <code>AugmentedManifestFile</code>
    /// </p>
    pub s3_data_type: std::option::Option<crate::model::S3DataType>,
    /// <p>Depending on the value specified for the <code>S3DataType</code>, identifies either a
    /// key name prefix or a manifest. For example:</p>
    /// <ul>
    /// <li>
    /// <p> A key name prefix might look like this:
    /// <code>s3://bucketname/exampleprefix</code>. </p>
    /// </li>
    /// <li>
    /// <p> A manifest might look like this:
    /// <code>s3://bucketname/example.manifest</code>
    /// </p>
    /// <p> The manifest is an S3 object which is a JSON file with the following format: </p>
    /// <p>
    /// <code>[ {"prefix": "s3://customer_bucket/some/prefix/"},</code>
    /// </p>
    /// <p>
    /// <code>"relative/path/to/custdata-1",</code>
    /// </p>
    /// <p>
    /// <code>"relative/path/custdata-2",</code>
    /// </p>
    /// <p>
    /// <code>...</code>
    /// </p>
    /// <p>
    /// <code>"relative/path/custdata-N"</code>
    /// </p>
    /// <p>
    /// <code>]</code>
    /// </p>
    /// <p> The preceding JSON matches the following <code>S3Uris</code>: </p>
    /// <p>
    /// <code>s3://customer_bucket/some/prefix/relative/path/to/custdata-1</code>
    /// </p>
    /// <p>
    /// <code>s3://customer_bucket/some/prefix/relative/path/custdata-2</code>
    /// </p>
    /// <p>
    /// <code>...</code>
    /// </p>
    /// <p>
    /// <code>s3://customer_bucket/some/prefix/relative/path/custdata-N</code>
    /// </p>
    /// <p> The complete set of <code>S3Uris</code> in this manifest constitutes the
    /// input data for the channel for this datasource. The object that each
    /// <code>S3Uris</code> points to must be readable by the IAM role that Amazon SageMaker
    /// uses to perform tasks on your behalf.</p>
    /// </li>
    /// </ul>
    pub s3_uri: std::option::Option<std::string::String>,
}
impl TransformS3DataSource {
    /// <p>If you choose <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix.
    /// Amazon SageMaker uses all objects with the specified key name prefix for batch transform. </p>
    /// <p>If you choose <code>ManifestFile</code>, <code>S3Uri</code> identifies an object that
    /// is a manifest file containing a list of object keys that you want Amazon SageMaker to use for batch
    /// transform. </p>
    /// <p>The following values are compatible: <code>ManifestFile</code>,
    /// <code>S3Prefix</code>
    /// </p>
    /// <p>The following value is not compatible: <code>AugmentedManifestFile</code>
    /// </p>
    pub fn s3_data_type(&self) -> std::option::Option<&crate::model::S3DataType> {
        self.s3_data_type.as_ref()
    }
    /// <p>Depending on the value specified for the <code>S3DataType</code>, identifies either a
    /// key name prefix or a manifest. For example:</p>
    /// <ul>
    /// <li>
    /// <p> A key name prefix might look like this:
    /// <code>s3://bucketname/exampleprefix</code>. </p>
    /// </li>
    /// <li>
    /// <p> A manifest might look like this:
    /// <code>s3://bucketname/example.manifest</code>
    /// </p>
    /// <p> The manifest is an S3 object which is a JSON file with the following format: </p>
    /// <p>
    /// <code>[ {"prefix": "s3://customer_bucket/some/prefix/"},</code>
    /// </p>
    /// <p>
    /// <code>"relative/path/to/custdata-1",</code>
    /// </p>
    /// <p>
    /// <code>"relative/path/custdata-2",</code>
    /// </p>
    /// <p>
    /// <code>...</code>
    /// </p>
    /// <p>
    /// <code>"relative/path/custdata-N"</code>
    /// </p>
    /// <p>
    /// <code>]</code>
    /// </p>
    /// <p> The preceding JSON matches the following <code>S3Uris</code>: </p>
    /// <p>
    /// <code>s3://customer_bucket/some/prefix/relative/path/to/custdata-1</code>
    /// </p>
    /// <p>
    /// <code>s3://customer_bucket/some/prefix/relative/path/custdata-2</code>
    /// </p>
    /// <p>
    /// <code>...</code>
    /// </p>
    /// <p>
    /// <code>s3://customer_bucket/some/prefix/relative/path/custdata-N</code>
    /// </p>
    /// <p> The complete set of <code>S3Uris</code> in this manifest constitutes the
    /// input data for the channel for this datasource. The object that each
    /// <code>S3Uris</code> points to must be readable by the IAM role that Amazon SageMaker
    /// uses to perform tasks on your behalf.</p>
    /// </li>
    /// </ul>
    pub fn s3_uri(&self) -> std::option::Option<&str> {
        self.s3_uri.as_deref()
    }
}
impl std::fmt::Debug for TransformS3DataSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TransformS3DataSource");
        formatter.field("s3_data_type", &self.s3_data_type);
        formatter.field("s3_uri", &self.s3_uri);
        formatter.finish()
    }
}
/// See [`TransformS3DataSource`](crate::model::TransformS3DataSource)
pub mod transform_s3_data_source {
    /// A builder for [`TransformS3DataSource`](crate::model::TransformS3DataSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_data_type: std::option::Option<crate::model::S3DataType>,
        pub(crate) s3_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>If you choose <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix.
        /// Amazon SageMaker uses all objects with the specified key name prefix for batch transform. </p>
        /// <p>If you choose <code>ManifestFile</code>, <code>S3Uri</code> identifies an object that
        /// is a manifest file containing a list of object keys that you want Amazon SageMaker to use for batch
        /// transform. </p>
        /// <p>The following values are compatible: <code>ManifestFile</code>,
        /// <code>S3Prefix</code>
        /// </p>
        /// <p>The following value is not compatible: <code>AugmentedManifestFile</code>
        /// </p>
        pub fn s3_data_type(mut self, input: crate::model::S3DataType) -> Self {
            self.s3_data_type = Some(input);
            self
        }
        /// <p>If you choose <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix.
        /// Amazon SageMaker uses all objects with the specified key name prefix for batch transform. </p>
        /// <p>If you choose <code>ManifestFile</code>, <code>S3Uri</code> identifies an object that
        /// is a manifest file containing a list of object keys that you want Amazon SageMaker to use for batch
        /// transform. </p>
        /// <p>The following values are compatible: <code>ManifestFile</code>,
        /// <code>S3Prefix</code>
        /// </p>
        /// <p>The following value is not compatible: <code>AugmentedManifestFile</code>
        /// </p>
        pub fn set_s3_data_type(
            mut self,
            input: std::option::Option<crate::model::S3DataType>,
        ) -> Self {
            self.s3_data_type = input;
            self
        }
        /// <p>Depending on the value specified for the <code>S3DataType</code>, identifies either a
        /// key name prefix or a manifest. For example:</p>
        /// <ul>
        /// <li>
        /// <p> A key name prefix might look like this:
        /// <code>s3://bucketname/exampleprefix</code>. </p>
        /// </li>
        /// <li>
        /// <p> A manifest might look like this:
        /// <code>s3://bucketname/example.manifest</code>
        /// </p>
        /// <p> The manifest is an S3 object which is a JSON file with the following format: </p>
        /// <p>
        /// <code>[ {"prefix": "s3://customer_bucket/some/prefix/"},</code>
        /// </p>
        /// <p>
        /// <code>"relative/path/to/custdata-1",</code>
        /// </p>
        /// <p>
        /// <code>"relative/path/custdata-2",</code>
        /// </p>
        /// <p>
        /// <code>...</code>
        /// </p>
        /// <p>
        /// <code>"relative/path/custdata-N"</code>
        /// </p>
        /// <p>
        /// <code>]</code>
        /// </p>
        /// <p> The preceding JSON matches the following <code>S3Uris</code>: </p>
        /// <p>
        /// <code>s3://customer_bucket/some/prefix/relative/path/to/custdata-1</code>
        /// </p>
        /// <p>
        /// <code>s3://customer_bucket/some/prefix/relative/path/custdata-2</code>
        /// </p>
        /// <p>
        /// <code>...</code>
        /// </p>
        /// <p>
        /// <code>s3://customer_bucket/some/prefix/relative/path/custdata-N</code>
        /// </p>
        /// <p> The complete set of <code>S3Uris</code> in this manifest constitutes the
        /// input data for the channel for this datasource. The object that each
        /// <code>S3Uris</code> points to must be readable by the IAM role that Amazon SageMaker
        /// uses to perform tasks on your behalf.</p>
        /// </li>
        /// </ul>
        pub fn s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_uri = Some(input.into());
            self
        }
        /// <p>Depending on the value specified for the <code>S3DataType</code>, identifies either a
        /// key name prefix or a manifest. For example:</p>
        /// <ul>
        /// <li>
        /// <p> A key name prefix might look like this:
        /// <code>s3://bucketname/exampleprefix</code>. </p>
        /// </li>
        /// <li>
        /// <p> A manifest might look like this:
        /// <code>s3://bucketname/example.manifest</code>
        /// </p>
        /// <p> The manifest is an S3 object which is a JSON file with the following format: </p>
        /// <p>
        /// <code>[ {"prefix": "s3://customer_bucket/some/prefix/"},</code>
        /// </p>
        /// <p>
        /// <code>"relative/path/to/custdata-1",</code>
        /// </p>
        /// <p>
        /// <code>"relative/path/custdata-2",</code>
        /// </p>
        /// <p>
        /// <code>...</code>
        /// </p>
        /// <p>
        /// <code>"relative/path/custdata-N"</code>
        /// </p>
        /// <p>
        /// <code>]</code>
        /// </p>
        /// <p> The preceding JSON matches the following <code>S3Uris</code>: </p>
        /// <p>
        /// <code>s3://customer_bucket/some/prefix/relative/path/to/custdata-1</code>
        /// </p>
        /// <p>
        /// <code>s3://customer_bucket/some/prefix/relative/path/custdata-2</code>
        /// </p>
        /// <p>
        /// <code>...</code>
        /// </p>
        /// <p>
        /// <code>s3://customer_bucket/some/prefix/relative/path/custdata-N</code>
        /// </p>
        /// <p> The complete set of <code>S3Uris</code> in this manifest constitutes the
        /// input data for the channel for this datasource. The object that each
        /// <code>S3Uris</code> points to must be readable by the IAM role that Amazon SageMaker
        /// uses to perform tasks on your behalf.</p>
        /// </li>
        /// </ul>
        pub fn set_s3_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`TransformS3DataSource`](crate::model::TransformS3DataSource)
        pub fn build(self) -> crate::model::TransformS3DataSource {
            crate::model::TransformS3DataSource {
                s3_data_type: self.s3_data_type,
                s3_uri: self.s3_uri,
            }
        }
    }
}
impl TransformS3DataSource {
    /// Creates a new builder-style object to manufacture [`TransformS3DataSource`](crate::model::TransformS3DataSource)
    pub fn builder() -> crate::model::transform_s3_data_source::Builder {
        crate::model::transform_s3_data_source::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum S3DataType {
    #[allow(missing_docs)] // documentation missing in model
    AugmentedManifestFile,
    #[allow(missing_docs)] // documentation missing in model
    ManifestFile,
    #[allow(missing_docs)] // documentation missing in model
    S3Prefix,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for S3DataType {
    fn from(s: &str) -> Self {
        match s {
            "AugmentedManifestFile" => S3DataType::AugmentedManifestFile,
            "ManifestFile" => S3DataType::ManifestFile,
            "S3Prefix" => S3DataType::S3Prefix,
            other => S3DataType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for S3DataType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(S3DataType::from(s))
    }
}
impl S3DataType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            S3DataType::AugmentedManifestFile => "AugmentedManifestFile",
            S3DataType::ManifestFile => "ManifestFile",
            S3DataType::S3Prefix => "S3Prefix",
            S3DataType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AugmentedManifestFile", "ManifestFile", "S3Prefix"]
    }
}
impl AsRef<str> for S3DataType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BatchStrategy {
    #[allow(missing_docs)] // documentation missing in model
    MultiRecord,
    #[allow(missing_docs)] // documentation missing in model
    SingleRecord,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BatchStrategy {
    fn from(s: &str) -> Self {
        match s {
            "MultiRecord" => BatchStrategy::MultiRecord,
            "SingleRecord" => BatchStrategy::SingleRecord,
            other => BatchStrategy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BatchStrategy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BatchStrategy::from(s))
    }
}
impl BatchStrategy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BatchStrategy::MultiRecord => "MultiRecord",
            BatchStrategy::SingleRecord => "SingleRecord",
            BatchStrategy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MultiRecord", "SingleRecord"]
    }
}
impl AsRef<str> for BatchStrategy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A list of algorithms that were used to create a model package.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceAlgorithmSpecification {
    /// <p>A list of the algorithms that were used to create a model package.</p>
    pub source_algorithms: std::option::Option<std::vec::Vec<crate::model::SourceAlgorithm>>,
}
impl SourceAlgorithmSpecification {
    /// <p>A list of the algorithms that were used to create a model package.</p>
    pub fn source_algorithms(&self) -> std::option::Option<&[crate::model::SourceAlgorithm]> {
        self.source_algorithms.as_deref()
    }
}
impl std::fmt::Debug for SourceAlgorithmSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceAlgorithmSpecification");
        formatter.field("source_algorithms", &self.source_algorithms);
        formatter.finish()
    }
}
/// See [`SourceAlgorithmSpecification`](crate::model::SourceAlgorithmSpecification)
pub mod source_algorithm_specification {
    /// A builder for [`SourceAlgorithmSpecification`](crate::model::SourceAlgorithmSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_algorithms:
            std::option::Option<std::vec::Vec<crate::model::SourceAlgorithm>>,
    }
    impl Builder {
        /// Appends an item to `source_algorithms`.
        ///
        /// To override the contents of this collection use [`set_source_algorithms`](Self::set_source_algorithms).
        ///
        /// <p>A list of the algorithms that were used to create a model package.</p>
        pub fn source_algorithms(
            mut self,
            input: impl Into<crate::model::SourceAlgorithm>,
        ) -> Self {
            let mut v = self.source_algorithms.unwrap_or_default();
            v.push(input.into());
            self.source_algorithms = Some(v);
            self
        }
        /// <p>A list of the algorithms that were used to create a model package.</p>
        pub fn set_source_algorithms(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SourceAlgorithm>>,
        ) -> Self {
            self.source_algorithms = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceAlgorithmSpecification`](crate::model::SourceAlgorithmSpecification)
        pub fn build(self) -> crate::model::SourceAlgorithmSpecification {
            crate::model::SourceAlgorithmSpecification {
                source_algorithms: self.source_algorithms,
            }
        }
    }
}
impl SourceAlgorithmSpecification {
    /// Creates a new builder-style object to manufacture [`SourceAlgorithmSpecification`](crate::model::SourceAlgorithmSpecification)
    pub fn builder() -> crate::model::source_algorithm_specification::Builder {
        crate::model::source_algorithm_specification::Builder::default()
    }
}

/// <p>Specifies an algorithm that was used to create the model package. The algorithm must
/// be either an algorithm resource in your Amazon SageMaker account or an algorithm in Amazon Web Services Marketplace that you
/// are subscribed to.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceAlgorithm {
    /// <p>The Amazon S3 path where the model artifacts, which result from model training, are stored.
    /// This path must point to a single <code>gzip</code> compressed tar archive
    /// (<code>.tar.gz</code> suffix).</p>
    /// <note>
    /// <p>The model artifacts must be in an S3 bucket that is in the same region as the
    /// algorithm.</p>
    /// </note>
    pub model_data_url: std::option::Option<std::string::String>,
    /// <p>The name of an algorithm that was used to create the model package. The algorithm must
    /// be either an algorithm resource in your Amazon SageMaker account or an algorithm in Amazon Web Services Marketplace that you
    /// are subscribed to.</p>
    pub algorithm_name: std::option::Option<std::string::String>,
}
impl SourceAlgorithm {
    /// <p>The Amazon S3 path where the model artifacts, which result from model training, are stored.
    /// This path must point to a single <code>gzip</code> compressed tar archive
    /// (<code>.tar.gz</code> suffix).</p>
    /// <note>
    /// <p>The model artifacts must be in an S3 bucket that is in the same region as the
    /// algorithm.</p>
    /// </note>
    pub fn model_data_url(&self) -> std::option::Option<&str> {
        self.model_data_url.as_deref()
    }
    /// <p>The name of an algorithm that was used to create the model package. The algorithm must
    /// be either an algorithm resource in your Amazon SageMaker account or an algorithm in Amazon Web Services Marketplace that you
    /// are subscribed to.</p>
    pub fn algorithm_name(&self) -> std::option::Option<&str> {
        self.algorithm_name.as_deref()
    }
}
impl std::fmt::Debug for SourceAlgorithm {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceAlgorithm");
        formatter.field("model_data_url", &self.model_data_url);
        formatter.field("algorithm_name", &self.algorithm_name);
        formatter.finish()
    }
}
/// See [`SourceAlgorithm`](crate::model::SourceAlgorithm)
pub mod source_algorithm {
    /// A builder for [`SourceAlgorithm`](crate::model::SourceAlgorithm)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_data_url: std::option::Option<std::string::String>,
        pub(crate) algorithm_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon S3 path where the model artifacts, which result from model training, are stored.
        /// This path must point to a single <code>gzip</code> compressed tar archive
        /// (<code>.tar.gz</code> suffix).</p>
        /// <note>
        /// <p>The model artifacts must be in an S3 bucket that is in the same region as the
        /// algorithm.</p>
        /// </note>
        pub fn model_data_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_data_url = Some(input.into());
            self
        }
        /// <p>The Amazon S3 path where the model artifacts, which result from model training, are stored.
        /// This path must point to a single <code>gzip</code> compressed tar archive
        /// (<code>.tar.gz</code> suffix).</p>
        /// <note>
        /// <p>The model artifacts must be in an S3 bucket that is in the same region as the
        /// algorithm.</p>
        /// </note>
        pub fn set_model_data_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_data_url = input;
            self
        }
        /// <p>The name of an algorithm that was used to create the model package. The algorithm must
        /// be either an algorithm resource in your Amazon SageMaker account or an algorithm in Amazon Web Services Marketplace that you
        /// are subscribed to.</p>
        pub fn algorithm_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.algorithm_name = Some(input.into());
            self
        }
        /// <p>The name of an algorithm that was used to create the model package. The algorithm must
        /// be either an algorithm resource in your Amazon SageMaker account or an algorithm in Amazon Web Services Marketplace that you
        /// are subscribed to.</p>
        pub fn set_algorithm_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.algorithm_name = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceAlgorithm`](crate::model::SourceAlgorithm)
        pub fn build(self) -> crate::model::SourceAlgorithm {
            crate::model::SourceAlgorithm {
                model_data_url: self.model_data_url,
                algorithm_name: self.algorithm_name,
            }
        }
    }
}
impl SourceAlgorithm {
    /// Creates a new builder-style object to manufacture [`SourceAlgorithm`](crate::model::SourceAlgorithm)
    pub fn builder() -> crate::model::source_algorithm::Builder {
        crate::model::source_algorithm::Builder::default()
    }
}

/// <p>Defines how to perform inference generation after a training job is run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InferenceSpecification {
    /// <p>The Amazon ECR registry path of the Docker image that contains the inference code.</p>
    pub containers:
        std::option::Option<std::vec::Vec<crate::model::ModelPackageContainerDefinition>>,
    /// <p>A list of the instance types on which a transformation job can be run or on which an
    /// endpoint can be deployed.</p>
    /// <p>This parameter is required for unversioned models, and optional for versioned
    /// models.</p>
    pub supported_transform_instance_types:
        std::option::Option<std::vec::Vec<crate::model::TransformInstanceType>>,
    /// <p>A list of the instance types that are used to generate inferences in real-time.</p>
    /// <p>This parameter is required for unversioned models, and optional for versioned
    /// models.</p>
    pub supported_realtime_inference_instance_types:
        std::option::Option<std::vec::Vec<crate::model::ProductionVariantInstanceType>>,
    /// <p>The supported MIME types for the input data.</p>
    pub supported_content_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The supported MIME types for the output data.</p>
    pub supported_response_mime_types: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl InferenceSpecification {
    /// <p>The Amazon ECR registry path of the Docker image that contains the inference code.</p>
    pub fn containers(
        &self,
    ) -> std::option::Option<&[crate::model::ModelPackageContainerDefinition]> {
        self.containers.as_deref()
    }
    /// <p>A list of the instance types on which a transformation job can be run or on which an
    /// endpoint can be deployed.</p>
    /// <p>This parameter is required for unversioned models, and optional for versioned
    /// models.</p>
    pub fn supported_transform_instance_types(
        &self,
    ) -> std::option::Option<&[crate::model::TransformInstanceType]> {
        self.supported_transform_instance_types.as_deref()
    }
    /// <p>A list of the instance types that are used to generate inferences in real-time.</p>
    /// <p>This parameter is required for unversioned models, and optional for versioned
    /// models.</p>
    pub fn supported_realtime_inference_instance_types(
        &self,
    ) -> std::option::Option<&[crate::model::ProductionVariantInstanceType]> {
        self.supported_realtime_inference_instance_types.as_deref()
    }
    /// <p>The supported MIME types for the input data.</p>
    pub fn supported_content_types(&self) -> std::option::Option<&[std::string::String]> {
        self.supported_content_types.as_deref()
    }
    /// <p>The supported MIME types for the output data.</p>
    pub fn supported_response_mime_types(&self) -> std::option::Option<&[std::string::String]> {
        self.supported_response_mime_types.as_deref()
    }
}
impl std::fmt::Debug for InferenceSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InferenceSpecification");
        formatter.field("containers", &self.containers);
        formatter.field(
            "supported_transform_instance_types",
            &self.supported_transform_instance_types,
        );
        formatter.field(
            "supported_realtime_inference_instance_types",
            &self.supported_realtime_inference_instance_types,
        );
        formatter.field("supported_content_types", &self.supported_content_types);
        formatter.field(
            "supported_response_mime_types",
            &self.supported_response_mime_types,
        );
        formatter.finish()
    }
}
/// See [`InferenceSpecification`](crate::model::InferenceSpecification)
pub mod inference_specification {
    /// A builder for [`InferenceSpecification`](crate::model::InferenceSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) containers:
            std::option::Option<std::vec::Vec<crate::model::ModelPackageContainerDefinition>>,
        pub(crate) supported_transform_instance_types:
            std::option::Option<std::vec::Vec<crate::model::TransformInstanceType>>,
        pub(crate) supported_realtime_inference_instance_types:
            std::option::Option<std::vec::Vec<crate::model::ProductionVariantInstanceType>>,
        pub(crate) supported_content_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) supported_response_mime_types:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `containers`.
        ///
        /// To override the contents of this collection use [`set_containers`](Self::set_containers).
        ///
        /// <p>The Amazon ECR registry path of the Docker image that contains the inference code.</p>
        pub fn containers(
            mut self,
            input: impl Into<crate::model::ModelPackageContainerDefinition>,
        ) -> Self {
            let mut v = self.containers.unwrap_or_default();
            v.push(input.into());
            self.containers = Some(v);
            self
        }
        /// <p>The Amazon ECR registry path of the Docker image that contains the inference code.</p>
        pub fn set_containers(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ModelPackageContainerDefinition>,
            >,
        ) -> Self {
            self.containers = input;
            self
        }
        /// Appends an item to `supported_transform_instance_types`.
        ///
        /// To override the contents of this collection use [`set_supported_transform_instance_types`](Self::set_supported_transform_instance_types).
        ///
        /// <p>A list of the instance types on which a transformation job can be run or on which an
        /// endpoint can be deployed.</p>
        /// <p>This parameter is required for unversioned models, and optional for versioned
        /// models.</p>
        pub fn supported_transform_instance_types(
            mut self,
            input: impl Into<crate::model::TransformInstanceType>,
        ) -> Self {
            let mut v = self.supported_transform_instance_types.unwrap_or_default();
            v.push(input.into());
            self.supported_transform_instance_types = Some(v);
            self
        }
        /// <p>A list of the instance types on which a transformation job can be run or on which an
        /// endpoint can be deployed.</p>
        /// <p>This parameter is required for unversioned models, and optional for versioned
        /// models.</p>
        pub fn set_supported_transform_instance_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TransformInstanceType>>,
        ) -> Self {
            self.supported_transform_instance_types = input;
            self
        }
        /// Appends an item to `supported_realtime_inference_instance_types`.
        ///
        /// To override the contents of this collection use [`set_supported_realtime_inference_instance_types`](Self::set_supported_realtime_inference_instance_types).
        ///
        /// <p>A list of the instance types that are used to generate inferences in real-time.</p>
        /// <p>This parameter is required for unversioned models, and optional for versioned
        /// models.</p>
        pub fn supported_realtime_inference_instance_types(
            mut self,
            input: impl Into<crate::model::ProductionVariantInstanceType>,
        ) -> Self {
            let mut v = self
                .supported_realtime_inference_instance_types
                .unwrap_or_default();
            v.push(input.into());
            self.supported_realtime_inference_instance_types = Some(v);
            self
        }
        /// <p>A list of the instance types that are used to generate inferences in real-time.</p>
        /// <p>This parameter is required for unversioned models, and optional for versioned
        /// models.</p>
        pub fn set_supported_realtime_inference_instance_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProductionVariantInstanceType>>,
        ) -> Self {
            self.supported_realtime_inference_instance_types = input;
            self
        }
        /// Appends an item to `supported_content_types`.
        ///
        /// To override the contents of this collection use [`set_supported_content_types`](Self::set_supported_content_types).
        ///
        /// <p>The supported MIME types for the input data.</p>
        pub fn supported_content_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.supported_content_types.unwrap_or_default();
            v.push(input.into());
            self.supported_content_types = Some(v);
            self
        }
        /// <p>The supported MIME types for the input data.</p>
        pub fn set_supported_content_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_content_types = input;
            self
        }
        /// Appends an item to `supported_response_mime_types`.
        ///
        /// To override the contents of this collection use [`set_supported_response_mime_types`](Self::set_supported_response_mime_types).
        ///
        /// <p>The supported MIME types for the output data.</p>
        pub fn supported_response_mime_types(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.supported_response_mime_types.unwrap_or_default();
            v.push(input.into());
            self.supported_response_mime_types = Some(v);
            self
        }
        /// <p>The supported MIME types for the output data.</p>
        pub fn set_supported_response_mime_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_response_mime_types = input;
            self
        }
        /// Consumes the builder and constructs a [`InferenceSpecification`](crate::model::InferenceSpecification)
        pub fn build(self) -> crate::model::InferenceSpecification {
            crate::model::InferenceSpecification {
                containers: self.containers,
                supported_transform_instance_types: self.supported_transform_instance_types,
                supported_realtime_inference_instance_types: self
                    .supported_realtime_inference_instance_types,
                supported_content_types: self.supported_content_types,
                supported_response_mime_types: self.supported_response_mime_types,
            }
        }
    }
}
impl InferenceSpecification {
    /// Creates a new builder-style object to manufacture [`InferenceSpecification`](crate::model::InferenceSpecification)
    pub fn builder() -> crate::model::inference_specification::Builder {
        crate::model::inference_specification::Builder::default()
    }
}

/// <p>A hosted endpoint for real-time inference.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Endpoint {
    /// <p>The name of the endpoint.</p>
    pub endpoint_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the endpoint.</p>
    pub endpoint_arn: std::option::Option<std::string::String>,
    /// <p>The endpoint configuration associated with the endpoint.</p>
    pub endpoint_config_name: std::option::Option<std::string::String>,
    /// <p>A list of the production variants hosted on the endpoint. Each production variant is a
    /// model.</p>
    pub production_variants:
        std::option::Option<std::vec::Vec<crate::model::ProductionVariantSummary>>,
    /// <p></p>
    pub data_capture_config: std::option::Option<crate::model::DataCaptureConfigSummary>,
    /// <p>The status of the endpoint.</p>
    pub endpoint_status: std::option::Option<crate::model::EndpointStatus>,
    /// <p>If the endpoint failed, the reason it failed.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The time that the endpoint was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last time the endpoint was modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A list of monitoring schedules for the endpoint. For information about model
    /// monitoring, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker Model Monitor</a>.</p>
    pub monitoring_schedules: std::option::Option<std::vec::Vec<crate::model::MonitoringSchedule>>,
    /// <p>A list of the tags associated with the endpoint. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
    /// resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl Endpoint {
    /// <p>The name of the endpoint.</p>
    pub fn endpoint_name(&self) -> std::option::Option<&str> {
        self.endpoint_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the endpoint.</p>
    pub fn endpoint_arn(&self) -> std::option::Option<&str> {
        self.endpoint_arn.as_deref()
    }
    /// <p>The endpoint configuration associated with the endpoint.</p>
    pub fn endpoint_config_name(&self) -> std::option::Option<&str> {
        self.endpoint_config_name.as_deref()
    }
    /// <p>A list of the production variants hosted on the endpoint. Each production variant is a
    /// model.</p>
    pub fn production_variants(
        &self,
    ) -> std::option::Option<&[crate::model::ProductionVariantSummary]> {
        self.production_variants.as_deref()
    }
    /// <p></p>
    pub fn data_capture_config(
        &self,
    ) -> std::option::Option<&crate::model::DataCaptureConfigSummary> {
        self.data_capture_config.as_ref()
    }
    /// <p>The status of the endpoint.</p>
    pub fn endpoint_status(&self) -> std::option::Option<&crate::model::EndpointStatus> {
        self.endpoint_status.as_ref()
    }
    /// <p>If the endpoint failed, the reason it failed.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The time that the endpoint was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The last time the endpoint was modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>A list of monitoring schedules for the endpoint. For information about model
    /// monitoring, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker Model Monitor</a>.</p>
    pub fn monitoring_schedules(&self) -> std::option::Option<&[crate::model::MonitoringSchedule]> {
        self.monitoring_schedules.as_deref()
    }
    /// <p>A list of the tags associated with the endpoint. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
    /// resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for Endpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Endpoint");
        formatter.field("endpoint_name", &self.endpoint_name);
        formatter.field("endpoint_arn", &self.endpoint_arn);
        formatter.field("endpoint_config_name", &self.endpoint_config_name);
        formatter.field("production_variants", &self.production_variants);
        formatter.field("data_capture_config", &self.data_capture_config);
        formatter.field("endpoint_status", &self.endpoint_status);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("monitoring_schedules", &self.monitoring_schedules);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Endpoint`](crate::model::Endpoint)
pub mod endpoint {
    /// A builder for [`Endpoint`](crate::model::Endpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_name: std::option::Option<std::string::String>,
        pub(crate) endpoint_arn: std::option::Option<std::string::String>,
        pub(crate) endpoint_config_name: std::option::Option<std::string::String>,
        pub(crate) production_variants:
            std::option::Option<std::vec::Vec<crate::model::ProductionVariantSummary>>,
        pub(crate) data_capture_config: std::option::Option<crate::model::DataCaptureConfigSummary>,
        pub(crate) endpoint_status: std::option::Option<crate::model::EndpointStatus>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) monitoring_schedules:
            std::option::Option<std::vec::Vec<crate::model::MonitoringSchedule>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the endpoint.</p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_name = Some(input.into());
            self
        }
        /// <p>The name of the endpoint.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_arn = input;
            self
        }
        /// <p>The endpoint configuration associated with the endpoint.</p>
        pub fn endpoint_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_config_name = Some(input.into());
            self
        }
        /// <p>The endpoint configuration associated with the endpoint.</p>
        pub fn set_endpoint_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_config_name = input;
            self
        }
        /// Appends an item to `production_variants`.
        ///
        /// To override the contents of this collection use [`set_production_variants`](Self::set_production_variants).
        ///
        /// <p>A list of the production variants hosted on the endpoint. Each production variant is a
        /// model.</p>
        pub fn production_variants(
            mut self,
            input: impl Into<crate::model::ProductionVariantSummary>,
        ) -> Self {
            let mut v = self.production_variants.unwrap_or_default();
            v.push(input.into());
            self.production_variants = Some(v);
            self
        }
        /// <p>A list of the production variants hosted on the endpoint. Each production variant is a
        /// model.</p>
        pub fn set_production_variants(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProductionVariantSummary>>,
        ) -> Self {
            self.production_variants = input;
            self
        }
        /// <p></p>
        pub fn data_capture_config(
            mut self,
            input: crate::model::DataCaptureConfigSummary,
        ) -> Self {
            self.data_capture_config = Some(input);
            self
        }
        /// <p></p>
        pub fn set_data_capture_config(
            mut self,
            input: std::option::Option<crate::model::DataCaptureConfigSummary>,
        ) -> Self {
            self.data_capture_config = input;
            self
        }
        /// <p>The status of the endpoint.</p>
        pub fn endpoint_status(mut self, input: crate::model::EndpointStatus) -> Self {
            self.endpoint_status = Some(input);
            self
        }
        /// <p>The status of the endpoint.</p>
        pub fn set_endpoint_status(
            mut self,
            input: std::option::Option<crate::model::EndpointStatus>,
        ) -> Self {
            self.endpoint_status = input;
            self
        }
        /// <p>If the endpoint failed, the reason it failed.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If the endpoint failed, the reason it failed.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The time that the endpoint was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the endpoint was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The last time the endpoint was modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The last time the endpoint was modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// Appends an item to `monitoring_schedules`.
        ///
        /// To override the contents of this collection use [`set_monitoring_schedules`](Self::set_monitoring_schedules).
        ///
        /// <p>A list of monitoring schedules for the endpoint. For information about model
        /// monitoring, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker Model Monitor</a>.</p>
        pub fn monitoring_schedules(
            mut self,
            input: impl Into<crate::model::MonitoringSchedule>,
        ) -> Self {
            let mut v = self.monitoring_schedules.unwrap_or_default();
            v.push(input.into());
            self.monitoring_schedules = Some(v);
            self
        }
        /// <p>A list of monitoring schedules for the endpoint. For information about model
        /// monitoring, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker Model Monitor</a>.</p>
        pub fn set_monitoring_schedules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MonitoringSchedule>>,
        ) -> Self {
            self.monitoring_schedules = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tags associated with the endpoint. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of the tags associated with the endpoint. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Endpoint`](crate::model::Endpoint)
        pub fn build(self) -> crate::model::Endpoint {
            crate::model::Endpoint {
                endpoint_name: self.endpoint_name,
                endpoint_arn: self.endpoint_arn,
                endpoint_config_name: self.endpoint_config_name,
                production_variants: self.production_variants,
                data_capture_config: self.data_capture_config,
                endpoint_status: self.endpoint_status,
                failure_reason: self.failure_reason,
                creation_time: self.creation_time,
                last_modified_time: self.last_modified_time,
                monitoring_schedules: self.monitoring_schedules,
                tags: self.tags,
            }
        }
    }
}
impl Endpoint {
    /// Creates a new builder-style object to manufacture [`Endpoint`](crate::model::Endpoint)
    pub fn builder() -> crate::model::endpoint::Builder {
        crate::model::endpoint::Builder::default()
    }
}

/// <p>A schedule for a model monitoring job. For information about model monitor, see
/// <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker Model
/// Monitor</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MonitoringSchedule {
    /// <p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>
    pub monitoring_schedule_arn: std::option::Option<std::string::String>,
    /// <p>The name of the monitoring schedule.</p>
    pub monitoring_schedule_name: std::option::Option<std::string::String>,
    /// <p>The status of the monitoring schedule. This can be one of the following values.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PENDING</code> - The schedule is pending being created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - The schedule failed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SCHEDULED</code> - The schedule was successfully created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STOPPED</code> - The schedule was stopped.</p>
    /// </li>
    /// </ul>
    pub monitoring_schedule_status: std::option::Option<crate::model::ScheduleStatus>,
    /// <p>The type of the monitoring job definition to schedule.</p>
    pub monitoring_type: std::option::Option<crate::model::MonitoringType>,
    /// <p>If the monitoring schedule failed, the reason it failed.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The time that the monitoring schedule was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last time the monitoring schedule was changed.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Configures the monitoring schedule and defines the monitoring job.</p>
    pub monitoring_schedule_config: std::option::Option<crate::model::MonitoringScheduleConfig>,
    /// <p>The endpoint that hosts the model being monitored.</p>
    pub endpoint_name: std::option::Option<std::string::String>,
    /// <p>Summary of information about the last monitoring job to run.</p>
    pub last_monitoring_execution_summary:
        std::option::Option<crate::model::MonitoringExecutionSummary>,
    /// <p>A list of the tags associated with the monitoring schedlue. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
    /// resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl MonitoringSchedule {
    /// <p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>
    pub fn monitoring_schedule_arn(&self) -> std::option::Option<&str> {
        self.monitoring_schedule_arn.as_deref()
    }
    /// <p>The name of the monitoring schedule.</p>
    pub fn monitoring_schedule_name(&self) -> std::option::Option<&str> {
        self.monitoring_schedule_name.as_deref()
    }
    /// <p>The status of the monitoring schedule. This can be one of the following values.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PENDING</code> - The schedule is pending being created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - The schedule failed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SCHEDULED</code> - The schedule was successfully created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STOPPED</code> - The schedule was stopped.</p>
    /// </li>
    /// </ul>
    pub fn monitoring_schedule_status(&self) -> std::option::Option<&crate::model::ScheduleStatus> {
        self.monitoring_schedule_status.as_ref()
    }
    /// <p>The type of the monitoring job definition to schedule.</p>
    pub fn monitoring_type(&self) -> std::option::Option<&crate::model::MonitoringType> {
        self.monitoring_type.as_ref()
    }
    /// <p>If the monitoring schedule failed, the reason it failed.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The time that the monitoring schedule was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The last time the monitoring schedule was changed.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>Configures the monitoring schedule and defines the monitoring job.</p>
    pub fn monitoring_schedule_config(
        &self,
    ) -> std::option::Option<&crate::model::MonitoringScheduleConfig> {
        self.monitoring_schedule_config.as_ref()
    }
    /// <p>The endpoint that hosts the model being monitored.</p>
    pub fn endpoint_name(&self) -> std::option::Option<&str> {
        self.endpoint_name.as_deref()
    }
    /// <p>Summary of information about the last monitoring job to run.</p>
    pub fn last_monitoring_execution_summary(
        &self,
    ) -> std::option::Option<&crate::model::MonitoringExecutionSummary> {
        self.last_monitoring_execution_summary.as_ref()
    }
    /// <p>A list of the tags associated with the monitoring schedlue. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
    /// resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for MonitoringSchedule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MonitoringSchedule");
        formatter.field("monitoring_schedule_arn", &self.monitoring_schedule_arn);
        formatter.field("monitoring_schedule_name", &self.monitoring_schedule_name);
        formatter.field(
            "monitoring_schedule_status",
            &self.monitoring_schedule_status,
        );
        formatter.field("monitoring_type", &self.monitoring_type);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field(
            "monitoring_schedule_config",
            &self.monitoring_schedule_config,
        );
        formatter.field("endpoint_name", &self.endpoint_name);
        formatter.field(
            "last_monitoring_execution_summary",
            &self.last_monitoring_execution_summary,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`MonitoringSchedule`](crate::model::MonitoringSchedule)
pub mod monitoring_schedule {
    /// A builder for [`MonitoringSchedule`](crate::model::MonitoringSchedule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) monitoring_schedule_arn: std::option::Option<std::string::String>,
        pub(crate) monitoring_schedule_name: std::option::Option<std::string::String>,
        pub(crate) monitoring_schedule_status: std::option::Option<crate::model::ScheduleStatus>,
        pub(crate) monitoring_type: std::option::Option<crate::model::MonitoringType>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) monitoring_schedule_config:
            std::option::Option<crate::model::MonitoringScheduleConfig>,
        pub(crate) endpoint_name: std::option::Option<std::string::String>,
        pub(crate) last_monitoring_execution_summary:
            std::option::Option<crate::model::MonitoringExecutionSummary>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>
        pub fn monitoring_schedule_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.monitoring_schedule_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>
        pub fn set_monitoring_schedule_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.monitoring_schedule_arn = input;
            self
        }
        /// <p>The name of the monitoring schedule.</p>
        pub fn monitoring_schedule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.monitoring_schedule_name = Some(input.into());
            self
        }
        /// <p>The name of the monitoring schedule.</p>
        pub fn set_monitoring_schedule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.monitoring_schedule_name = input;
            self
        }
        /// <p>The status of the monitoring schedule. This can be one of the following values.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - The schedule is pending being created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - The schedule failed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SCHEDULED</code> - The schedule was successfully created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STOPPED</code> - The schedule was stopped.</p>
        /// </li>
        /// </ul>
        pub fn monitoring_schedule_status(mut self, input: crate::model::ScheduleStatus) -> Self {
            self.monitoring_schedule_status = Some(input);
            self
        }
        /// <p>The status of the monitoring schedule. This can be one of the following values.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - The schedule is pending being created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - The schedule failed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SCHEDULED</code> - The schedule was successfully created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STOPPED</code> - The schedule was stopped.</p>
        /// </li>
        /// </ul>
        pub fn set_monitoring_schedule_status(
            mut self,
            input: std::option::Option<crate::model::ScheduleStatus>,
        ) -> Self {
            self.monitoring_schedule_status = input;
            self
        }
        /// <p>The type of the monitoring job definition to schedule.</p>
        pub fn monitoring_type(mut self, input: crate::model::MonitoringType) -> Self {
            self.monitoring_type = Some(input);
            self
        }
        /// <p>The type of the monitoring job definition to schedule.</p>
        pub fn set_monitoring_type(
            mut self,
            input: std::option::Option<crate::model::MonitoringType>,
        ) -> Self {
            self.monitoring_type = input;
            self
        }
        /// <p>If the monitoring schedule failed, the reason it failed.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If the monitoring schedule failed, the reason it failed.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The time that the monitoring schedule was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the monitoring schedule was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The last time the monitoring schedule was changed.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The last time the monitoring schedule was changed.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>Configures the monitoring schedule and defines the monitoring job.</p>
        pub fn monitoring_schedule_config(
            mut self,
            input: crate::model::MonitoringScheduleConfig,
        ) -> Self {
            self.monitoring_schedule_config = Some(input);
            self
        }
        /// <p>Configures the monitoring schedule and defines the monitoring job.</p>
        pub fn set_monitoring_schedule_config(
            mut self,
            input: std::option::Option<crate::model::MonitoringScheduleConfig>,
        ) -> Self {
            self.monitoring_schedule_config = input;
            self
        }
        /// <p>The endpoint that hosts the model being monitored.</p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_name = Some(input.into());
            self
        }
        /// <p>The endpoint that hosts the model being monitored.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_name = input;
            self
        }
        /// <p>Summary of information about the last monitoring job to run.</p>
        pub fn last_monitoring_execution_summary(
            mut self,
            input: crate::model::MonitoringExecutionSummary,
        ) -> Self {
            self.last_monitoring_execution_summary = Some(input);
            self
        }
        /// <p>Summary of information about the last monitoring job to run.</p>
        pub fn set_last_monitoring_execution_summary(
            mut self,
            input: std::option::Option<crate::model::MonitoringExecutionSummary>,
        ) -> Self {
            self.last_monitoring_execution_summary = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tags associated with the monitoring schedlue. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of the tags associated with the monitoring schedlue. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`MonitoringSchedule`](crate::model::MonitoringSchedule)
        pub fn build(self) -> crate::model::MonitoringSchedule {
            crate::model::MonitoringSchedule {
                monitoring_schedule_arn: self.monitoring_schedule_arn,
                monitoring_schedule_name: self.monitoring_schedule_name,
                monitoring_schedule_status: self.monitoring_schedule_status,
                monitoring_type: self.monitoring_type,
                failure_reason: self.failure_reason,
                creation_time: self.creation_time,
                last_modified_time: self.last_modified_time,
                monitoring_schedule_config: self.monitoring_schedule_config,
                endpoint_name: self.endpoint_name,
                last_monitoring_execution_summary: self.last_monitoring_execution_summary,
                tags: self.tags,
            }
        }
    }
}
impl MonitoringSchedule {
    /// Creates a new builder-style object to manufacture [`MonitoringSchedule`](crate::model::MonitoringSchedule)
    pub fn builder() -> crate::model::monitoring_schedule::Builder {
        crate::model::monitoring_schedule::Builder::default()
    }
}

/// <p>Summary of information about the last monitoring job to run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MonitoringExecutionSummary {
    /// <p>The name of the monitoring schedule.</p>
    pub monitoring_schedule_name: std::option::Option<std::string::String>,
    /// <p>The time the monitoring job was scheduled.</p>
    pub scheduled_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time at which the monitoring job was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp that indicates the last time the monitoring job was modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the monitoring job.</p>
    pub monitoring_execution_status: std::option::Option<crate::model::ExecutionStatus>,
    /// <p>The Amazon Resource Name (ARN) of the monitoring job.</p>
    pub processing_job_arn: std::option::Option<std::string::String>,
    /// <p>The name of the endpoint used to run the monitoring job.</p>
    pub endpoint_name: std::option::Option<std::string::String>,
    /// <p>Contains the reason a monitoring job failed, if it failed.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The name of the monitoring job.</p>
    pub monitoring_job_definition_name: std::option::Option<std::string::String>,
    /// <p>The type of the monitoring job.</p>
    pub monitoring_type: std::option::Option<crate::model::MonitoringType>,
}
impl MonitoringExecutionSummary {
    /// <p>The name of the monitoring schedule.</p>
    pub fn monitoring_schedule_name(&self) -> std::option::Option<&str> {
        self.monitoring_schedule_name.as_deref()
    }
    /// <p>The time the monitoring job was scheduled.</p>
    pub fn scheduled_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.scheduled_time.as_ref()
    }
    /// <p>The time at which the monitoring job was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>A timestamp that indicates the last time the monitoring job was modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>The status of the monitoring job.</p>
    pub fn monitoring_execution_status(
        &self,
    ) -> std::option::Option<&crate::model::ExecutionStatus> {
        self.monitoring_execution_status.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the monitoring job.</p>
    pub fn processing_job_arn(&self) -> std::option::Option<&str> {
        self.processing_job_arn.as_deref()
    }
    /// <p>The name of the endpoint used to run the monitoring job.</p>
    pub fn endpoint_name(&self) -> std::option::Option<&str> {
        self.endpoint_name.as_deref()
    }
    /// <p>Contains the reason a monitoring job failed, if it failed.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The name of the monitoring job.</p>
    pub fn monitoring_job_definition_name(&self) -> std::option::Option<&str> {
        self.monitoring_job_definition_name.as_deref()
    }
    /// <p>The type of the monitoring job.</p>
    pub fn monitoring_type(&self) -> std::option::Option<&crate::model::MonitoringType> {
        self.monitoring_type.as_ref()
    }
}
impl std::fmt::Debug for MonitoringExecutionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MonitoringExecutionSummary");
        formatter.field("monitoring_schedule_name", &self.monitoring_schedule_name);
        formatter.field("scheduled_time", &self.scheduled_time);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field(
            "monitoring_execution_status",
            &self.monitoring_execution_status,
        );
        formatter.field("processing_job_arn", &self.processing_job_arn);
        formatter.field("endpoint_name", &self.endpoint_name);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field(
            "monitoring_job_definition_name",
            &self.monitoring_job_definition_name,
        );
        formatter.field("monitoring_type", &self.monitoring_type);
        formatter.finish()
    }
}
/// See [`MonitoringExecutionSummary`](crate::model::MonitoringExecutionSummary)
pub mod monitoring_execution_summary {
    /// A builder for [`MonitoringExecutionSummary`](crate::model::MonitoringExecutionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) monitoring_schedule_name: std::option::Option<std::string::String>,
        pub(crate) scheduled_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) monitoring_execution_status: std::option::Option<crate::model::ExecutionStatus>,
        pub(crate) processing_job_arn: std::option::Option<std::string::String>,
        pub(crate) endpoint_name: std::option::Option<std::string::String>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) monitoring_job_definition_name: std::option::Option<std::string::String>,
        pub(crate) monitoring_type: std::option::Option<crate::model::MonitoringType>,
    }
    impl Builder {
        /// <p>The name of the monitoring schedule.</p>
        pub fn monitoring_schedule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.monitoring_schedule_name = Some(input.into());
            self
        }
        /// <p>The name of the monitoring schedule.</p>
        pub fn set_monitoring_schedule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.monitoring_schedule_name = input;
            self
        }
        /// <p>The time the monitoring job was scheduled.</p>
        pub fn scheduled_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.scheduled_time = Some(input);
            self
        }
        /// <p>The time the monitoring job was scheduled.</p>
        pub fn set_scheduled_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.scheduled_time = input;
            self
        }
        /// <p>The time at which the monitoring job was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time at which the monitoring job was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>A timestamp that indicates the last time the monitoring job was modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>A timestamp that indicates the last time the monitoring job was modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>The status of the monitoring job.</p>
        pub fn monitoring_execution_status(mut self, input: crate::model::ExecutionStatus) -> Self {
            self.monitoring_execution_status = Some(input);
            self
        }
        /// <p>The status of the monitoring job.</p>
        pub fn set_monitoring_execution_status(
            mut self,
            input: std::option::Option<crate::model::ExecutionStatus>,
        ) -> Self {
            self.monitoring_execution_status = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the monitoring job.</p>
        pub fn processing_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.processing_job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the monitoring job.</p>
        pub fn set_processing_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.processing_job_arn = input;
            self
        }
        /// <p>The name of the endpoint used to run the monitoring job.</p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_name = Some(input.into());
            self
        }
        /// <p>The name of the endpoint used to run the monitoring job.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_name = input;
            self
        }
        /// <p>Contains the reason a monitoring job failed, if it failed.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>Contains the reason a monitoring job failed, if it failed.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The name of the monitoring job.</p>
        pub fn monitoring_job_definition_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.monitoring_job_definition_name = Some(input.into());
            self
        }
        /// <p>The name of the monitoring job.</p>
        pub fn set_monitoring_job_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.monitoring_job_definition_name = input;
            self
        }
        /// <p>The type of the monitoring job.</p>
        pub fn monitoring_type(mut self, input: crate::model::MonitoringType) -> Self {
            self.monitoring_type = Some(input);
            self
        }
        /// <p>The type of the monitoring job.</p>
        pub fn set_monitoring_type(
            mut self,
            input: std::option::Option<crate::model::MonitoringType>,
        ) -> Self {
            self.monitoring_type = input;
            self
        }
        /// Consumes the builder and constructs a [`MonitoringExecutionSummary`](crate::model::MonitoringExecutionSummary)
        pub fn build(self) -> crate::model::MonitoringExecutionSummary {
            crate::model::MonitoringExecutionSummary {
                monitoring_schedule_name: self.monitoring_schedule_name,
                scheduled_time: self.scheduled_time,
                creation_time: self.creation_time,
                last_modified_time: self.last_modified_time,
                monitoring_execution_status: self.monitoring_execution_status,
                processing_job_arn: self.processing_job_arn,
                endpoint_name: self.endpoint_name,
                failure_reason: self.failure_reason,
                monitoring_job_definition_name: self.monitoring_job_definition_name,
                monitoring_type: self.monitoring_type,
            }
        }
    }
}
impl MonitoringExecutionSummary {
    /// Creates a new builder-style object to manufacture [`MonitoringExecutionSummary`](crate::model::MonitoringExecutionSummary)
    pub fn builder() -> crate::model::monitoring_execution_summary::Builder {
        crate::model::monitoring_execution_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExecutionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    CompletedWithViolations,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExecutionStatus {
    fn from(s: &str) -> Self {
        match s {
            "Completed" => ExecutionStatus::Completed,
            "CompletedWithViolations" => ExecutionStatus::CompletedWithViolations,
            "Failed" => ExecutionStatus::Failed,
            "InProgress" => ExecutionStatus::InProgress,
            "Pending" => ExecutionStatus::Pending,
            "Stopped" => ExecutionStatus::Stopped,
            "Stopping" => ExecutionStatus::Stopping,
            other => ExecutionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExecutionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExecutionStatus::from(s))
    }
}
impl ExecutionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExecutionStatus::Completed => "Completed",
            ExecutionStatus::CompletedWithViolations => "CompletedWithViolations",
            ExecutionStatus::Failed => "Failed",
            ExecutionStatus::InProgress => "InProgress",
            ExecutionStatus::Pending => "Pending",
            ExecutionStatus::Stopped => "Stopped",
            ExecutionStatus::Stopping => "Stopping",
            ExecutionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Completed",
            "CompletedWithViolations",
            "Failed",
            "InProgress",
            "Pending",
            "Stopped",
            "Stopping",
        ]
    }
}
impl AsRef<str> for ExecutionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScheduleStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Scheduled,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScheduleStatus {
    fn from(s: &str) -> Self {
        match s {
            "Failed" => ScheduleStatus::Failed,
            "Pending" => ScheduleStatus::Pending,
            "Scheduled" => ScheduleStatus::Scheduled,
            "Stopped" => ScheduleStatus::Stopped,
            other => ScheduleStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScheduleStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScheduleStatus::from(s))
    }
}
impl ScheduleStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScheduleStatus::Failed => "Failed",
            ScheduleStatus::Pending => "Pending",
            ScheduleStatus::Scheduled => "Scheduled",
            ScheduleStatus::Stopped => "Stopped",
            ScheduleStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Failed", "Pending", "Scheduled", "Stopped"]
    }
}
impl AsRef<str> for ScheduleStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EndpointStatus {
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InService,
    #[allow(missing_docs)] // documentation missing in model
    OutOfService,
    #[allow(missing_docs)] // documentation missing in model
    RollingBack,
    #[allow(missing_docs)] // documentation missing in model
    SystemUpdating,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EndpointStatus {
    fn from(s: &str) -> Self {
        match s {
            "Creating" => EndpointStatus::Creating,
            "Deleting" => EndpointStatus::Deleting,
            "Failed" => EndpointStatus::Failed,
            "InService" => EndpointStatus::InService,
            "OutOfService" => EndpointStatus::OutOfService,
            "RollingBack" => EndpointStatus::RollingBack,
            "SystemUpdating" => EndpointStatus::SystemUpdating,
            "Updating" => EndpointStatus::Updating,
            other => EndpointStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EndpointStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EndpointStatus::from(s))
    }
}
impl EndpointStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EndpointStatus::Creating => "Creating",
            EndpointStatus::Deleting => "Deleting",
            EndpointStatus::Failed => "Failed",
            EndpointStatus::InService => "InService",
            EndpointStatus::OutOfService => "OutOfService",
            EndpointStatus::RollingBack => "RollingBack",
            EndpointStatus::SystemUpdating => "SystemUpdating",
            EndpointStatus::Updating => "Updating",
            EndpointStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Creating",
            "Deleting",
            "Failed",
            "InService",
            "OutOfService",
            "RollingBack",
            "SystemUpdating",
            "Updating",
        ]
    }
}
impl AsRef<str> for EndpointStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataCaptureConfigSummary {
    /// <p></p>
    pub enable_capture: bool,
    /// <p></p>
    pub capture_status: std::option::Option<crate::model::CaptureStatus>,
    /// <p></p>
    pub current_sampling_percentage: std::option::Option<i32>,
    /// <p></p>
    pub destination_s3_uri: std::option::Option<std::string::String>,
    /// <p></p>
    pub kms_key_id: std::option::Option<std::string::String>,
}
impl DataCaptureConfigSummary {
    /// <p></p>
    pub fn enable_capture(&self) -> bool {
        self.enable_capture
    }
    /// <p></p>
    pub fn capture_status(&self) -> std::option::Option<&crate::model::CaptureStatus> {
        self.capture_status.as_ref()
    }
    /// <p></p>
    pub fn current_sampling_percentage(&self) -> std::option::Option<i32> {
        self.current_sampling_percentage
    }
    /// <p></p>
    pub fn destination_s3_uri(&self) -> std::option::Option<&str> {
        self.destination_s3_uri.as_deref()
    }
    /// <p></p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
}
impl std::fmt::Debug for DataCaptureConfigSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataCaptureConfigSummary");
        formatter.field("enable_capture", &self.enable_capture);
        formatter.field("capture_status", &self.capture_status);
        formatter.field(
            "current_sampling_percentage",
            &self.current_sampling_percentage,
        );
        formatter.field("destination_s3_uri", &self.destination_s3_uri);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.finish()
    }
}
/// See [`DataCaptureConfigSummary`](crate::model::DataCaptureConfigSummary)
pub mod data_capture_config_summary {
    /// A builder for [`DataCaptureConfigSummary`](crate::model::DataCaptureConfigSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enable_capture: std::option::Option<bool>,
        pub(crate) capture_status: std::option::Option<crate::model::CaptureStatus>,
        pub(crate) current_sampling_percentage: std::option::Option<i32>,
        pub(crate) destination_s3_uri: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn enable_capture(mut self, input: bool) -> Self {
            self.enable_capture = Some(input);
            self
        }
        /// <p></p>
        pub fn set_enable_capture(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_capture = input;
            self
        }
        /// <p></p>
        pub fn capture_status(mut self, input: crate::model::CaptureStatus) -> Self {
            self.capture_status = Some(input);
            self
        }
        /// <p></p>
        pub fn set_capture_status(
            mut self,
            input: std::option::Option<crate::model::CaptureStatus>,
        ) -> Self {
            self.capture_status = input;
            self
        }
        /// <p></p>
        pub fn current_sampling_percentage(mut self, input: i32) -> Self {
            self.current_sampling_percentage = Some(input);
            self
        }
        /// <p></p>
        pub fn set_current_sampling_percentage(mut self, input: std::option::Option<i32>) -> Self {
            self.current_sampling_percentage = input;
            self
        }
        /// <p></p>
        pub fn destination_s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_s3_uri = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_destination_s3_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_s3_uri = input;
            self
        }
        /// <p></p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DataCaptureConfigSummary`](crate::model::DataCaptureConfigSummary)
        pub fn build(self) -> crate::model::DataCaptureConfigSummary {
            crate::model::DataCaptureConfigSummary {
                enable_capture: self.enable_capture.unwrap_or_default(),
                capture_status: self.capture_status,
                current_sampling_percentage: self.current_sampling_percentage,
                destination_s3_uri: self.destination_s3_uri,
                kms_key_id: self.kms_key_id,
            }
        }
    }
}
impl DataCaptureConfigSummary {
    /// Creates a new builder-style object to manufacture [`DataCaptureConfigSummary`](crate::model::DataCaptureConfigSummary)
    pub fn builder() -> crate::model::data_capture_config_summary::Builder {
        crate::model::data_capture_config_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CaptureStatus {
    #[allow(missing_docs)] // documentation missing in model
    Started,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CaptureStatus {
    fn from(s: &str) -> Self {
        match s {
            "Started" => CaptureStatus::Started,
            "Stopped" => CaptureStatus::Stopped,
            other => CaptureStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CaptureStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CaptureStatus::from(s))
    }
}
impl CaptureStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CaptureStatus::Started => "Started",
            CaptureStatus::Stopped => "Stopped",
            CaptureStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Started", "Stopped"]
    }
}
impl AsRef<str> for CaptureStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes weight and capacities for a production variant associated with an
/// endpoint. If you sent a request to the <code>UpdateEndpointWeightsAndCapacities</code>
/// API and the endpoint status is <code>Updating</code>, you get different desired and
/// current values. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProductionVariantSummary {
    /// <p>The name of the variant.</p>
    pub variant_name: std::option::Option<std::string::String>,
    /// <p>An array of <code>DeployedImage</code> objects that specify the Amazon EC2 Container Registry paths of the
    /// inference images deployed on instances of this <code>ProductionVariant</code>.</p>
    pub deployed_images: std::option::Option<std::vec::Vec<crate::model::DeployedImage>>,
    /// <p>The weight associated with the variant.</p>
    pub current_weight: std::option::Option<f32>,
    /// <p>The requested weight, as specified in the
    /// <code>UpdateEndpointWeightsAndCapacities</code> request. </p>
    pub desired_weight: std::option::Option<f32>,
    /// <p>The number of instances associated with the variant.</p>
    pub current_instance_count: std::option::Option<i32>,
    /// <p>The number of instances requested in the
    /// <code>UpdateEndpointWeightsAndCapacities</code> request. </p>
    pub desired_instance_count: std::option::Option<i32>,
    /// <p>The endpoint variant status which describes the current deployment stage status or operational status.</p>
    pub variant_status: std::option::Option<std::vec::Vec<crate::model::ProductionVariantStatus>>,
    /// <p>The serverless configuration for the endpoint.</p>
    /// <note>
    /// <p>Serverless Inference is in preview release for Amazon SageMaker and is subject to change. We do not recommend using this feature in production environments.</p>
    /// </note>
    pub current_serverless_config:
        std::option::Option<crate::model::ProductionVariantServerlessConfig>,
    /// <p>The serverless configuration requested for the endpoint update.</p>
    /// <note>
    /// <p>Serverless Inference is in preview release for Amazon SageMaker and is subject to change. We do not recommend using this feature in production environments.</p>
    /// </note>
    pub desired_serverless_config:
        std::option::Option<crate::model::ProductionVariantServerlessConfig>,
}
impl ProductionVariantSummary {
    /// <p>The name of the variant.</p>
    pub fn variant_name(&self) -> std::option::Option<&str> {
        self.variant_name.as_deref()
    }
    /// <p>An array of <code>DeployedImage</code> objects that specify the Amazon EC2 Container Registry paths of the
    /// inference images deployed on instances of this <code>ProductionVariant</code>.</p>
    pub fn deployed_images(&self) -> std::option::Option<&[crate::model::DeployedImage]> {
        self.deployed_images.as_deref()
    }
    /// <p>The weight associated with the variant.</p>
    pub fn current_weight(&self) -> std::option::Option<f32> {
        self.current_weight
    }
    /// <p>The requested weight, as specified in the
    /// <code>UpdateEndpointWeightsAndCapacities</code> request. </p>
    pub fn desired_weight(&self) -> std::option::Option<f32> {
        self.desired_weight
    }
    /// <p>The number of instances associated with the variant.</p>
    pub fn current_instance_count(&self) -> std::option::Option<i32> {
        self.current_instance_count
    }
    /// <p>The number of instances requested in the
    /// <code>UpdateEndpointWeightsAndCapacities</code> request. </p>
    pub fn desired_instance_count(&self) -> std::option::Option<i32> {
        self.desired_instance_count
    }
    /// <p>The endpoint variant status which describes the current deployment stage status or operational status.</p>
    pub fn variant_status(&self) -> std::option::Option<&[crate::model::ProductionVariantStatus]> {
        self.variant_status.as_deref()
    }
    /// <p>The serverless configuration for the endpoint.</p>
    /// <note>
    /// <p>Serverless Inference is in preview release for Amazon SageMaker and is subject to change. We do not recommend using this feature in production environments.</p>
    /// </note>
    pub fn current_serverless_config(
        &self,
    ) -> std::option::Option<&crate::model::ProductionVariantServerlessConfig> {
        self.current_serverless_config.as_ref()
    }
    /// <p>The serverless configuration requested for the endpoint update.</p>
    /// <note>
    /// <p>Serverless Inference is in preview release for Amazon SageMaker and is subject to change. We do not recommend using this feature in production environments.</p>
    /// </note>
    pub fn desired_serverless_config(
        &self,
    ) -> std::option::Option<&crate::model::ProductionVariantServerlessConfig> {
        self.desired_serverless_config.as_ref()
    }
}
impl std::fmt::Debug for ProductionVariantSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProductionVariantSummary");
        formatter.field("variant_name", &self.variant_name);
        formatter.field("deployed_images", &self.deployed_images);
        formatter.field("current_weight", &self.current_weight);
        formatter.field("desired_weight", &self.desired_weight);
        formatter.field("current_instance_count", &self.current_instance_count);
        formatter.field("desired_instance_count", &self.desired_instance_count);
        formatter.field("variant_status", &self.variant_status);
        formatter.field("current_serverless_config", &self.current_serverless_config);
        formatter.field("desired_serverless_config", &self.desired_serverless_config);
        formatter.finish()
    }
}
/// See [`ProductionVariantSummary`](crate::model::ProductionVariantSummary)
pub mod production_variant_summary {
    /// A builder for [`ProductionVariantSummary`](crate::model::ProductionVariantSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) variant_name: std::option::Option<std::string::String>,
        pub(crate) deployed_images: std::option::Option<std::vec::Vec<crate::model::DeployedImage>>,
        pub(crate) current_weight: std::option::Option<f32>,
        pub(crate) desired_weight: std::option::Option<f32>,
        pub(crate) current_instance_count: std::option::Option<i32>,
        pub(crate) desired_instance_count: std::option::Option<i32>,
        pub(crate) variant_status:
            std::option::Option<std::vec::Vec<crate::model::ProductionVariantStatus>>,
        pub(crate) current_serverless_config:
            std::option::Option<crate::model::ProductionVariantServerlessConfig>,
        pub(crate) desired_serverless_config:
            std::option::Option<crate::model::ProductionVariantServerlessConfig>,
    }
    impl Builder {
        /// <p>The name of the variant.</p>
        pub fn variant_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.variant_name = Some(input.into());
            self
        }
        /// <p>The name of the variant.</p>
        pub fn set_variant_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.variant_name = input;
            self
        }
        /// Appends an item to `deployed_images`.
        ///
        /// To override the contents of this collection use [`set_deployed_images`](Self::set_deployed_images).
        ///
        /// <p>An array of <code>DeployedImage</code> objects that specify the Amazon EC2 Container Registry paths of the
        /// inference images deployed on instances of this <code>ProductionVariant</code>.</p>
        pub fn deployed_images(mut self, input: impl Into<crate::model::DeployedImage>) -> Self {
            let mut v = self.deployed_images.unwrap_or_default();
            v.push(input.into());
            self.deployed_images = Some(v);
            self
        }
        /// <p>An array of <code>DeployedImage</code> objects that specify the Amazon EC2 Container Registry paths of the
        /// inference images deployed on instances of this <code>ProductionVariant</code>.</p>
        pub fn set_deployed_images(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeployedImage>>,
        ) -> Self {
            self.deployed_images = input;
            self
        }
        /// <p>The weight associated with the variant.</p>
        pub fn current_weight(mut self, input: f32) -> Self {
            self.current_weight = Some(input);
            self
        }
        /// <p>The weight associated with the variant.</p>
        pub fn set_current_weight(mut self, input: std::option::Option<f32>) -> Self {
            self.current_weight = input;
            self
        }
        /// <p>The requested weight, as specified in the
        /// <code>UpdateEndpointWeightsAndCapacities</code> request. </p>
        pub fn desired_weight(mut self, input: f32) -> Self {
            self.desired_weight = Some(input);
            self
        }
        /// <p>The requested weight, as specified in the
        /// <code>UpdateEndpointWeightsAndCapacities</code> request. </p>
        pub fn set_desired_weight(mut self, input: std::option::Option<f32>) -> Self {
            self.desired_weight = input;
            self
        }
        /// <p>The number of instances associated with the variant.</p>
        pub fn current_instance_count(mut self, input: i32) -> Self {
            self.current_instance_count = Some(input);
            self
        }
        /// <p>The number of instances associated with the variant.</p>
        pub fn set_current_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.current_instance_count = input;
            self
        }
        /// <p>The number of instances requested in the
        /// <code>UpdateEndpointWeightsAndCapacities</code> request. </p>
        pub fn desired_instance_count(mut self, input: i32) -> Self {
            self.desired_instance_count = Some(input);
            self
        }
        /// <p>The number of instances requested in the
        /// <code>UpdateEndpointWeightsAndCapacities</code> request. </p>
        pub fn set_desired_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.desired_instance_count = input;
            self
        }
        /// Appends an item to `variant_status`.
        ///
        /// To override the contents of this collection use [`set_variant_status`](Self::set_variant_status).
        ///
        /// <p>The endpoint variant status which describes the current deployment stage status or operational status.</p>
        pub fn variant_status(
            mut self,
            input: impl Into<crate::model::ProductionVariantStatus>,
        ) -> Self {
            let mut v = self.variant_status.unwrap_or_default();
            v.push(input.into());
            self.variant_status = Some(v);
            self
        }
        /// <p>The endpoint variant status which describes the current deployment stage status or operational status.</p>
        pub fn set_variant_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProductionVariantStatus>>,
        ) -> Self {
            self.variant_status = input;
            self
        }
        /// <p>The serverless configuration for the endpoint.</p>
        /// <note>
        /// <p>Serverless Inference is in preview release for Amazon SageMaker and is subject to change. We do not recommend using this feature in production environments.</p>
        /// </note>
        pub fn current_serverless_config(
            mut self,
            input: crate::model::ProductionVariantServerlessConfig,
        ) -> Self {
            self.current_serverless_config = Some(input);
            self
        }
        /// <p>The serverless configuration for the endpoint.</p>
        /// <note>
        /// <p>Serverless Inference is in preview release for Amazon SageMaker and is subject to change. We do not recommend using this feature in production environments.</p>
        /// </note>
        pub fn set_current_serverless_config(
            mut self,
            input: std::option::Option<crate::model::ProductionVariantServerlessConfig>,
        ) -> Self {
            self.current_serverless_config = input;
            self
        }
        /// <p>The serverless configuration requested for the endpoint update.</p>
        /// <note>
        /// <p>Serverless Inference is in preview release for Amazon SageMaker and is subject to change. We do not recommend using this feature in production environments.</p>
        /// </note>
        pub fn desired_serverless_config(
            mut self,
            input: crate::model::ProductionVariantServerlessConfig,
        ) -> Self {
            self.desired_serverless_config = Some(input);
            self
        }
        /// <p>The serverless configuration requested for the endpoint update.</p>
        /// <note>
        /// <p>Serverless Inference is in preview release for Amazon SageMaker and is subject to change. We do not recommend using this feature in production environments.</p>
        /// </note>
        pub fn set_desired_serverless_config(
            mut self,
            input: std::option::Option<crate::model::ProductionVariantServerlessConfig>,
        ) -> Self {
            self.desired_serverless_config = input;
            self
        }
        /// Consumes the builder and constructs a [`ProductionVariantSummary`](crate::model::ProductionVariantSummary)
        pub fn build(self) -> crate::model::ProductionVariantSummary {
            crate::model::ProductionVariantSummary {
                variant_name: self.variant_name,
                deployed_images: self.deployed_images,
                current_weight: self.current_weight,
                desired_weight: self.desired_weight,
                current_instance_count: self.current_instance_count,
                desired_instance_count: self.desired_instance_count,
                variant_status: self.variant_status,
                current_serverless_config: self.current_serverless_config,
                desired_serverless_config: self.desired_serverless_config,
            }
        }
    }
}
impl ProductionVariantSummary {
    /// Creates a new builder-style object to manufacture [`ProductionVariantSummary`](crate::model::ProductionVariantSummary)
    pub fn builder() -> crate::model::production_variant_summary::Builder {
        crate::model::production_variant_summary::Builder::default()
    }
}

/// <important>
/// <p>Serverless Inference is in preview release for Amazon SageMaker and is subject to change. We do not recommend using this feature in production environments.</p>
/// </important>
/// <p>Specifies the serverless configuration for an endpoint variant.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProductionVariantServerlessConfig {
    /// <p>The memory size of your serverless endpoint. Valid values are in 1 GB increments: 1024 MB, 2048 MB, 3072 MB, 4096 MB, 5120 MB, or 6144 MB.</p>
    pub memory_size_in_mb: std::option::Option<i32>,
    /// <p>The maximum number of concurrent invocations your serverless endpoint can process.</p>
    pub max_concurrency: std::option::Option<i32>,
}
impl ProductionVariantServerlessConfig {
    /// <p>The memory size of your serverless endpoint. Valid values are in 1 GB increments: 1024 MB, 2048 MB, 3072 MB, 4096 MB, 5120 MB, or 6144 MB.</p>
    pub fn memory_size_in_mb(&self) -> std::option::Option<i32> {
        self.memory_size_in_mb
    }
    /// <p>The maximum number of concurrent invocations your serverless endpoint can process.</p>
    pub fn max_concurrency(&self) -> std::option::Option<i32> {
        self.max_concurrency
    }
}
impl std::fmt::Debug for ProductionVariantServerlessConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProductionVariantServerlessConfig");
        formatter.field("memory_size_in_mb", &self.memory_size_in_mb);
        formatter.field("max_concurrency", &self.max_concurrency);
        formatter.finish()
    }
}
/// See [`ProductionVariantServerlessConfig`](crate::model::ProductionVariantServerlessConfig)
pub mod production_variant_serverless_config {
    /// A builder for [`ProductionVariantServerlessConfig`](crate::model::ProductionVariantServerlessConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) memory_size_in_mb: std::option::Option<i32>,
        pub(crate) max_concurrency: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The memory size of your serverless endpoint. Valid values are in 1 GB increments: 1024 MB, 2048 MB, 3072 MB, 4096 MB, 5120 MB, or 6144 MB.</p>
        pub fn memory_size_in_mb(mut self, input: i32) -> Self {
            self.memory_size_in_mb = Some(input);
            self
        }
        /// <p>The memory size of your serverless endpoint. Valid values are in 1 GB increments: 1024 MB, 2048 MB, 3072 MB, 4096 MB, 5120 MB, or 6144 MB.</p>
        pub fn set_memory_size_in_mb(mut self, input: std::option::Option<i32>) -> Self {
            self.memory_size_in_mb = input;
            self
        }
        /// <p>The maximum number of concurrent invocations your serverless endpoint can process.</p>
        pub fn max_concurrency(mut self, input: i32) -> Self {
            self.max_concurrency = Some(input);
            self
        }
        /// <p>The maximum number of concurrent invocations your serverless endpoint can process.</p>
        pub fn set_max_concurrency(mut self, input: std::option::Option<i32>) -> Self {
            self.max_concurrency = input;
            self
        }
        /// Consumes the builder and constructs a [`ProductionVariantServerlessConfig`](crate::model::ProductionVariantServerlessConfig)
        pub fn build(self) -> crate::model::ProductionVariantServerlessConfig {
            crate::model::ProductionVariantServerlessConfig {
                memory_size_in_mb: self.memory_size_in_mb,
                max_concurrency: self.max_concurrency,
            }
        }
    }
}
impl ProductionVariantServerlessConfig {
    /// Creates a new builder-style object to manufacture [`ProductionVariantServerlessConfig`](crate::model::ProductionVariantServerlessConfig)
    pub fn builder() -> crate::model::production_variant_serverless_config::Builder {
        crate::model::production_variant_serverless_config::Builder::default()
    }
}

/// <p>Describes the status of the production variant.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProductionVariantStatus {
    /// <p>The endpoint variant status which describes the current deployment stage status or operational status.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Creating</code>: Creating inference resources for the production variant.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Deleting</code>: Terminating inference resources for the production variant.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Updating</code>: Updating capacity for the production variant.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ActivatingTraffic</code>: Turning on traffic for the production variant.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Baking</code>: Waiting period to monitor the CloudWatch alarms in the
    /// automatic rollback configuration.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::VariantStatus>,
    /// <p>A message that describes the status of the production variant.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The start time of the current status change.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ProductionVariantStatus {
    /// <p>The endpoint variant status which describes the current deployment stage status or operational status.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Creating</code>: Creating inference resources for the production variant.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Deleting</code>: Terminating inference resources for the production variant.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Updating</code>: Updating capacity for the production variant.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ActivatingTraffic</code>: Turning on traffic for the production variant.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Baking</code>: Waiting period to monitor the CloudWatch alarms in the
    /// automatic rollback configuration.</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::VariantStatus> {
        self.status.as_ref()
    }
    /// <p>A message that describes the status of the production variant.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>The start time of the current status change.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
}
impl std::fmt::Debug for ProductionVariantStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProductionVariantStatus");
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("start_time", &self.start_time);
        formatter.finish()
    }
}
/// See [`ProductionVariantStatus`](crate::model::ProductionVariantStatus)
pub mod production_variant_status {
    /// A builder for [`ProductionVariantStatus`](crate::model::ProductionVariantStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::VariantStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The endpoint variant status which describes the current deployment stage status or operational status.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Creating</code>: Creating inference resources for the production variant.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Deleting</code>: Terminating inference resources for the production variant.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Updating</code>: Updating capacity for the production variant.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ActivatingTraffic</code>: Turning on traffic for the production variant.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Baking</code>: Waiting period to monitor the CloudWatch alarms in the
        /// automatic rollback configuration.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::VariantStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The endpoint variant status which describes the current deployment stage status or operational status.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Creating</code>: Creating inference resources for the production variant.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Deleting</code>: Terminating inference resources for the production variant.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Updating</code>: Updating capacity for the production variant.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ActivatingTraffic</code>: Turning on traffic for the production variant.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Baking</code>: Waiting period to monitor the CloudWatch alarms in the
        /// automatic rollback configuration.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::VariantStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A message that describes the status of the production variant.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A message that describes the status of the production variant.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The start time of the current status change.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start time of the current status change.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ProductionVariantStatus`](crate::model::ProductionVariantStatus)
        pub fn build(self) -> crate::model::ProductionVariantStatus {
            crate::model::ProductionVariantStatus {
                status: self.status,
                status_message: self.status_message,
                start_time: self.start_time,
            }
        }
    }
}
impl ProductionVariantStatus {
    /// Creates a new builder-style object to manufacture [`ProductionVariantStatus`](crate::model::ProductionVariantStatus)
    pub fn builder() -> crate::model::production_variant_status::Builder {
        crate::model::production_variant_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VariantStatus {
    #[allow(missing_docs)] // documentation missing in model
    ActivatingTraffic,
    #[allow(missing_docs)] // documentation missing in model
    Baking,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VariantStatus {
    fn from(s: &str) -> Self {
        match s {
            "ActivatingTraffic" => VariantStatus::ActivatingTraffic,
            "Baking" => VariantStatus::Baking,
            "Creating" => VariantStatus::Creating,
            "Deleting" => VariantStatus::Deleting,
            "Updating" => VariantStatus::Updating,
            other => VariantStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VariantStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VariantStatus::from(s))
    }
}
impl VariantStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VariantStatus::ActivatingTraffic => "ActivatingTraffic",
            VariantStatus::Baking => "Baking",
            VariantStatus::Creating => "Creating",
            VariantStatus::Deleting => "Deleting",
            VariantStatus::Updating => "Updating",
            VariantStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ActivatingTraffic",
            "Baking",
            "Creating",
            "Deleting",
            "Updating",
        ]
    }
}
impl AsRef<str> for VariantStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Gets the Amazon EC2 Container Registry path of the docker image of the model that is hosted in this <a>ProductionVariant</a>.</p>
/// <p>If you used the <code>registry/repository[:tag]</code> form to specify the image path
/// of the primary container when you created the model hosted in this
/// <code>ProductionVariant</code>, the path resolves to a path of the form
/// <code>registry/repository[@digest]</code>. A digest is a hash value that identifies
/// a specific version of an image. For information about Amazon ECR paths, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/docker-pull-ecr-image.html">Pulling an Image</a> in the <i>Amazon ECR User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeployedImage {
    /// <p>The image path you specified when you created the model.</p>
    pub specified_image: std::option::Option<std::string::String>,
    /// <p>The specific digest path of the image hosted in this
    /// <code>ProductionVariant</code>.</p>
    pub resolved_image: std::option::Option<std::string::String>,
    /// <p>The date and time when the image path for the model resolved to the
    /// <code>ResolvedImage</code>
    /// </p>
    pub resolution_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DeployedImage {
    /// <p>The image path you specified when you created the model.</p>
    pub fn specified_image(&self) -> std::option::Option<&str> {
        self.specified_image.as_deref()
    }
    /// <p>The specific digest path of the image hosted in this
    /// <code>ProductionVariant</code>.</p>
    pub fn resolved_image(&self) -> std::option::Option<&str> {
        self.resolved_image.as_deref()
    }
    /// <p>The date and time when the image path for the model resolved to the
    /// <code>ResolvedImage</code>
    /// </p>
    pub fn resolution_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.resolution_time.as_ref()
    }
}
impl std::fmt::Debug for DeployedImage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeployedImage");
        formatter.field("specified_image", &self.specified_image);
        formatter.field("resolved_image", &self.resolved_image);
        formatter.field("resolution_time", &self.resolution_time);
        formatter.finish()
    }
}
/// See [`DeployedImage`](crate::model::DeployedImage)
pub mod deployed_image {
    /// A builder for [`DeployedImage`](crate::model::DeployedImage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) specified_image: std::option::Option<std::string::String>,
        pub(crate) resolved_image: std::option::Option<std::string::String>,
        pub(crate) resolution_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The image path you specified when you created the model.</p>
        pub fn specified_image(mut self, input: impl Into<std::string::String>) -> Self {
            self.specified_image = Some(input.into());
            self
        }
        /// <p>The image path you specified when you created the model.</p>
        pub fn set_specified_image(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.specified_image = input;
            self
        }
        /// <p>The specific digest path of the image hosted in this
        /// <code>ProductionVariant</code>.</p>
        pub fn resolved_image(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolved_image = Some(input.into());
            self
        }
        /// <p>The specific digest path of the image hosted in this
        /// <code>ProductionVariant</code>.</p>
        pub fn set_resolved_image(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolved_image = input;
            self
        }
        /// <p>The date and time when the image path for the model resolved to the
        /// <code>ResolvedImage</code>
        /// </p>
        pub fn resolution_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.resolution_time = Some(input);
            self
        }
        /// <p>The date and time when the image path for the model resolved to the
        /// <code>ResolvedImage</code>
        /// </p>
        pub fn set_resolution_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.resolution_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DeployedImage`](crate::model::DeployedImage)
        pub fn build(self) -> crate::model::DeployedImage {
            crate::model::DeployedImage {
                specified_image: self.specified_image,
                resolved_image: self.resolved_image,
                resolution_time: self.resolution_time,
            }
        }
    }
}
impl DeployedImage {
    /// Creates a new builder-style object to manufacture [`DeployedImage`](crate::model::DeployedImage)
    pub fn builder() -> crate::model::deployed_image::Builder {
        crate::model::deployed_image::Builder::default()
    }
}

/// <p>The properties of a trial component as returned by the <a>Search</a>
/// API.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrialComponent {
    /// <p>The name of the trial component.</p>
    pub trial_component_name: std::option::Option<std::string::String>,
    /// <p>The name of the component as displayed. If <code>DisplayName</code> isn't specified,
    /// <code>TrialComponentName</code> is displayed.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the trial component.</p>
    pub trial_component_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) and job type of the source of the component.</p>
    pub source: std::option::Option<crate::model::TrialComponentSource>,
    /// <p>The status of the trial component.</p>
    pub status: std::option::Option<crate::model::TrialComponentStatus>,
    /// <p>When the component started.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>When the component ended.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>When the component was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Who created the trial component.</p>
    pub created_by: std::option::Option<crate::model::UserContext>,
    /// <p>When the component was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Information about the user who created or modified an experiment, trial, trial
    /// component, lineage group, or project.</p>
    pub last_modified_by: std::option::Option<crate::model::UserContext>,
    /// <p>The hyperparameters of the component.</p>
    pub parameters: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::TrialComponentParameterValue>,
    >,
    /// <p>The input artifacts of the component.</p>
    pub input_artifacts: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::TrialComponentArtifact>,
    >,
    /// <p>The output artifacts of the component.</p>
    pub output_artifacts: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::TrialComponentArtifact>,
    >,
    /// <p>The metrics for the component.</p>
    pub metrics: std::option::Option<std::vec::Vec<crate::model::TrialComponentMetricSummary>>,
    /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
    pub metadata_properties: std::option::Option<crate::model::MetadataProperties>,
    /// <p>Details of the source of the component.</p>
    pub source_detail: std::option::Option<crate::model::TrialComponentSourceDetail>,
    /// <p>The Amazon Resource Name (ARN) of the lineage group resource.</p>
    pub lineage_group_arn: std::option::Option<std::string::String>,
    /// <p>The list of tags that are associated with the component. You can use <a>Search</a> API to search on the tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>An array of the parents of the component. A parent is a trial the component is associated
    /// with and the experiment the trial is part of. A component might not have any parents.</p>
    pub parents: std::option::Option<std::vec::Vec<crate::model::Parent>>,
}
impl TrialComponent {
    /// <p>The name of the trial component.</p>
    pub fn trial_component_name(&self) -> std::option::Option<&str> {
        self.trial_component_name.as_deref()
    }
    /// <p>The name of the component as displayed. If <code>DisplayName</code> isn't specified,
    /// <code>TrialComponentName</code> is displayed.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the trial component.</p>
    pub fn trial_component_arn(&self) -> std::option::Option<&str> {
        self.trial_component_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) and job type of the source of the component.</p>
    pub fn source(&self) -> std::option::Option<&crate::model::TrialComponentSource> {
        self.source.as_ref()
    }
    /// <p>The status of the trial component.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::TrialComponentStatus> {
        self.status.as_ref()
    }
    /// <p>When the component started.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>When the component ended.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>When the component was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>Who created the trial component.</p>
    pub fn created_by(&self) -> std::option::Option<&crate::model::UserContext> {
        self.created_by.as_ref()
    }
    /// <p>When the component was last modified.</p>
    pub fn last_modified_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_time.as_ref()
    }
    /// <p>Information about the user who created or modified an experiment, trial, trial
    /// component, lineage group, or project.</p>
    pub fn last_modified_by(&self) -> std::option::Option<&crate::model::UserContext> {
        self.last_modified_by.as_ref()
    }
    /// <p>The hyperparameters of the component.</p>
    pub fn parameters(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::TrialComponentParameterValue>,
    > {
        self.parameters.as_ref()
    }
    /// <p>The input artifacts of the component.</p>
    pub fn input_artifacts(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::TrialComponentArtifact>,
    > {
        self.input_artifacts.as_ref()
    }
    /// <p>The output artifacts of the component.</p>
    pub fn output_artifacts(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::TrialComponentArtifact>,
    > {
        self.output_artifacts.as_ref()
    }
    /// <p>The metrics for the component.</p>
    pub fn metrics(&self) -> std::option::Option<&[crate::model::TrialComponentMetricSummary]> {
        self.metrics.as_deref()
    }
    /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
    pub fn metadata_properties(&self) -> std::option::Option<&crate::model::MetadataProperties> {
        self.metadata_properties.as_ref()
    }
    /// <p>Details of the source of the component.</p>
    pub fn source_detail(&self) -> std::option::Option<&crate::model::TrialComponentSourceDetail> {
        self.source_detail.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the lineage group resource.</p>
    pub fn lineage_group_arn(&self) -> std::option::Option<&str> {
        self.lineage_group_arn.as_deref()
    }
    /// <p>The list of tags that are associated with the component. You can use <a>Search</a> API to search on the tags.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>An array of the parents of the component. A parent is a trial the component is associated
    /// with and the experiment the trial is part of. A component might not have any parents.</p>
    pub fn parents(&self) -> std::option::Option<&[crate::model::Parent]> {
        self.parents.as_deref()
    }
}
impl std::fmt::Debug for TrialComponent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrialComponent");
        formatter.field("trial_component_name", &self.trial_component_name);
        formatter.field("display_name", &self.display_name);
        formatter.field("trial_component_arn", &self.trial_component_arn);
        formatter.field("source", &self.source);
        formatter.field("status", &self.status);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("created_by", &self.created_by);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("last_modified_by", &self.last_modified_by);
        formatter.field("parameters", &self.parameters);
        formatter.field("input_artifacts", &self.input_artifacts);
        formatter.field("output_artifacts", &self.output_artifacts);
        formatter.field("metrics", &self.metrics);
        formatter.field("metadata_properties", &self.metadata_properties);
        formatter.field("source_detail", &self.source_detail);
        formatter.field("lineage_group_arn", &self.lineage_group_arn);
        formatter.field("tags", &self.tags);
        formatter.field("parents", &self.parents);
        formatter.finish()
    }
}
/// See [`TrialComponent`](crate::model::TrialComponent)
pub mod trial_component {
    /// A builder for [`TrialComponent`](crate::model::TrialComponent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trial_component_name: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) trial_component_arn: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<crate::model::TrialComponentSource>,
        pub(crate) status: std::option::Option<crate::model::TrialComponentStatus>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_by: std::option::Option<crate::model::UserContext>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_by: std::option::Option<crate::model::UserContext>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                crate::model::TrialComponentParameterValue,
            >,
        >,
        pub(crate) input_artifacts: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::TrialComponentArtifact>,
        >,
        pub(crate) output_artifacts: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::TrialComponentArtifact>,
        >,
        pub(crate) metrics:
            std::option::Option<std::vec::Vec<crate::model::TrialComponentMetricSummary>>,
        pub(crate) metadata_properties: std::option::Option<crate::model::MetadataProperties>,
        pub(crate) source_detail: std::option::Option<crate::model::TrialComponentSourceDetail>,
        pub(crate) lineage_group_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) parents: std::option::Option<std::vec::Vec<crate::model::Parent>>,
    }
    impl Builder {
        /// <p>The name of the trial component.</p>
        pub fn trial_component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.trial_component_name = Some(input.into());
            self
        }
        /// <p>The name of the trial component.</p>
        pub fn set_trial_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.trial_component_name = input;
            self
        }
        /// <p>The name of the component as displayed. If <code>DisplayName</code> isn't specified,
        /// <code>TrialComponentName</code> is displayed.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The name of the component as displayed. If <code>DisplayName</code> isn't specified,
        /// <code>TrialComponentName</code> is displayed.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the trial component.</p>
        pub fn trial_component_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.trial_component_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the trial component.</p>
        pub fn set_trial_component_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.trial_component_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) and job type of the source of the component.</p>
        pub fn source(mut self, input: crate::model::TrialComponentSource) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) and job type of the source of the component.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::TrialComponentSource>,
        ) -> Self {
            self.source = input;
            self
        }
        /// <p>The status of the trial component.</p>
        pub fn status(mut self, input: crate::model::TrialComponentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the trial component.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TrialComponentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>When the component started.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>When the component started.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>When the component ended.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>When the component ended.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>When the component was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>When the component was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>Who created the trial component.</p>
        pub fn created_by(mut self, input: crate::model::UserContext) -> Self {
            self.created_by = Some(input);
            self
        }
        /// <p>Who created the trial component.</p>
        pub fn set_created_by(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.created_by = input;
            self
        }
        /// <p>When the component was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>When the component was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial
        /// component, lineage group, or project.</p>
        pub fn last_modified_by(mut self, input: crate::model::UserContext) -> Self {
            self.last_modified_by = Some(input);
            self
        }
        /// <p>Information about the user who created or modified an experiment, trial, trial
        /// component, lineage group, or project.</p>
        pub fn set_last_modified_by(
            mut self,
            input: std::option::Option<crate::model::UserContext>,
        ) -> Self {
            self.last_modified_by = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The hyperparameters of the component.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::TrialComponentParameterValue>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>The hyperparameters of the component.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::TrialComponentParameterValue,
                >,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Adds a key-value pair to `input_artifacts`.
        ///
        /// To override the contents of this collection use [`set_input_artifacts`](Self::set_input_artifacts).
        ///
        /// <p>The input artifacts of the component.</p>
        pub fn input_artifacts(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::TrialComponentArtifact>,
        ) -> Self {
            let mut hash_map = self.input_artifacts.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.input_artifacts = Some(hash_map);
            self
        }
        /// <p>The input artifacts of the component.</p>
        pub fn set_input_artifacts(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::TrialComponentArtifact,
                >,
            >,
        ) -> Self {
            self.input_artifacts = input;
            self
        }
        /// Adds a key-value pair to `output_artifacts`.
        ///
        /// To override the contents of this collection use [`set_output_artifacts`](Self::set_output_artifacts).
        ///
        /// <p>The output artifacts of the component.</p>
        pub fn output_artifacts(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::TrialComponentArtifact>,
        ) -> Self {
            let mut hash_map = self.output_artifacts.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.output_artifacts = Some(hash_map);
            self
        }
        /// <p>The output artifacts of the component.</p>
        pub fn set_output_artifacts(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::TrialComponentArtifact,
                >,
            >,
        ) -> Self {
            self.output_artifacts = input;
            self
        }
        /// Appends an item to `metrics`.
        ///
        /// To override the contents of this collection use [`set_metrics`](Self::set_metrics).
        ///
        /// <p>The metrics for the component.</p>
        pub fn metrics(
            mut self,
            input: impl Into<crate::model::TrialComponentMetricSummary>,
        ) -> Self {
            let mut v = self.metrics.unwrap_or_default();
            v.push(input.into());
            self.metrics = Some(v);
            self
        }
        /// <p>The metrics for the component.</p>
        pub fn set_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TrialComponentMetricSummary>>,
        ) -> Self {
            self.metrics = input;
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn metadata_properties(mut self, input: crate::model::MetadataProperties) -> Self {
            self.metadata_properties = Some(input);
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn set_metadata_properties(
            mut self,
            input: std::option::Option<crate::model::MetadataProperties>,
        ) -> Self {
            self.metadata_properties = input;
            self
        }
        /// <p>Details of the source of the component.</p>
        pub fn source_detail(mut self, input: crate::model::TrialComponentSourceDetail) -> Self {
            self.source_detail = Some(input);
            self
        }
        /// <p>Details of the source of the component.</p>
        pub fn set_source_detail(
            mut self,
            input: std::option::Option<crate::model::TrialComponentSourceDetail>,
        ) -> Self {
            self.source_detail = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the lineage group resource.</p>
        pub fn lineage_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.lineage_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the lineage group resource.</p>
        pub fn set_lineage_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lineage_group_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags that are associated with the component. You can use <a>Search</a> API to search on the tags.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags that are associated with the component. You can use <a>Search</a> API to search on the tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `parents`.
        ///
        /// To override the contents of this collection use [`set_parents`](Self::set_parents).
        ///
        /// <p>An array of the parents of the component. A parent is a trial the component is associated
        /// with and the experiment the trial is part of. A component might not have any parents.</p>
        pub fn parents(mut self, input: impl Into<crate::model::Parent>) -> Self {
            let mut v = self.parents.unwrap_or_default();
            v.push(input.into());
            self.parents = Some(v);
            self
        }
        /// <p>An array of the parents of the component. A parent is a trial the component is associated
        /// with and the experiment the trial is part of. A component might not have any parents.</p>
        pub fn set_parents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parent>>,
        ) -> Self {
            self.parents = input;
            self
        }
        /// Consumes the builder and constructs a [`TrialComponent`](crate::model::TrialComponent)
        pub fn build(self) -> crate::model::TrialComponent {
            crate::model::TrialComponent {
                trial_component_name: self.trial_component_name,
                display_name: self.display_name,
                trial_component_arn: self.trial_component_arn,
                source: self.source,
                status: self.status,
                start_time: self.start_time,
                end_time: self.end_time,
                creation_time: self.creation_time,
                created_by: self.created_by,
                last_modified_time: self.last_modified_time,
                last_modified_by: self.last_modified_by,
                parameters: self.parameters,
                input_artifacts: self.input_artifacts,
                output_artifacts: self.output_artifacts,
                metrics: self.metrics,
                metadata_properties: self.metadata_properties,
                source_detail: self.source_detail,
                lineage_group_arn: self.lineage_group_arn,
                tags: self.tags,
                parents: self.parents,
            }
        }
    }
}
impl TrialComponent {
    /// Creates a new builder-style object to manufacture [`TrialComponent`](crate::model::TrialComponent)
    pub fn builder() -> crate::model::trial_component::Builder {
        crate::model::trial_component::Builder::default()
    }
}

/// <p>The trial that a trial component is associated with and the experiment the trial is part
/// of. A component might not be associated with a trial. A component can be associated with
/// multiple trials.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Parent {
    /// <p>The name of the trial.</p>
    pub trial_name: std::option::Option<std::string::String>,
    /// <p>The name of the experiment.</p>
    pub experiment_name: std::option::Option<std::string::String>,
}
impl Parent {
    /// <p>The name of the trial.</p>
    pub fn trial_name(&self) -> std::option::Option<&str> {
        self.trial_name.as_deref()
    }
    /// <p>The name of the experiment.</p>
    pub fn experiment_name(&self) -> std::option::Option<&str> {
        self.experiment_name.as_deref()
    }
}
impl std::fmt::Debug for Parent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Parent");
        formatter.field("trial_name", &self.trial_name);
        formatter.field("experiment_name", &self.experiment_name);
        formatter.finish()
    }
}
/// See [`Parent`](crate::model::Parent)
pub mod parent {
    /// A builder for [`Parent`](crate::model::Parent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trial_name: std::option::Option<std::string::String>,
        pub(crate) experiment_name: std::option::Option<std::string::String>,
    }
    impl Bu