// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddAssociationInput`](crate::input::AddAssociationInput)
pub mod add_association_input {
    /// A builder for [`AddAssociationInput`](crate::input::AddAssociationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_arn: std::option::Option<std::string::String>,
        pub(crate) destination_arn: std::option::Option<std::string::String>,
        pub(crate) association_type: std::option::Option<crate::model::AssociationEdgeType>,
    }
    impl Builder {
        /// <p>The ARN of the source.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the source.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the destination.</p>
        pub fn destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the destination.</p>
        pub fn set_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_arn = input;
            self
        }
        /// <p>The type of association. The following are suggested uses for each type. Amazon SageMaker
        /// places no restrictions on their use.</p>
        /// <ul>
        /// <li>
        /// <p>ContributedTo - The source contributed to the destination or had a part in
        /// enabling the destination. For example, the training data contributed to the training
        /// job.</p>
        /// </li>
        /// <li>
        /// <p>AssociatedWith - The source is connected to the destination. For example, an
        /// approval workflow is associated with a model deployment.</p>
        /// </li>
        /// <li>
        /// <p>DerivedFrom - The destination is a modification of the source. For example, a digest
        /// output of a channel input for a processing job is derived from the original inputs.</p>
        /// </li>
        /// <li>
        /// <p>Produced - The source generated the destination. For example, a training job
        /// produced a model artifact.</p>
        /// </li>
        /// </ul>
        pub fn association_type(mut self, input: crate::model::AssociationEdgeType) -> Self {
            self.association_type = Some(input);
            self
        }
        /// <p>The type of association. The following are suggested uses for each type. Amazon SageMaker
        /// places no restrictions on their use.</p>
        /// <ul>
        /// <li>
        /// <p>ContributedTo - The source contributed to the destination or had a part in
        /// enabling the destination. For example, the training data contributed to the training
        /// job.</p>
        /// </li>
        /// <li>
        /// <p>AssociatedWith - The source is connected to the destination. For example, an
        /// approval workflow is associated with a model deployment.</p>
        /// </li>
        /// <li>
        /// <p>DerivedFrom - The destination is a modification of the source. For example, a digest
        /// output of a channel input for a processing job is derived from the original inputs.</p>
        /// </li>
        /// <li>
        /// <p>Produced - The source generated the destination. For example, a training job
        /// produced a model artifact.</p>
        /// </li>
        /// </ul>
        pub fn set_association_type(
            mut self,
            input: std::option::Option<crate::model::AssociationEdgeType>,
        ) -> Self {
            self.association_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AddAssociationInput`](crate::input::AddAssociationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddAssociationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddAssociationInput {
                source_arn: self.source_arn,
                destination_arn: self.destination_arn,
                association_type: self.association_type,
            })
        }
    }
}
#[doc(hidden)]
pub type AddAssociationInputOperationOutputAlias = crate::operation::AddAssociation;
#[doc(hidden)]
pub type AddAssociationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddAssociationInput {
    /// Consumes the builder and constructs an Operation<[`AddAssociation`](crate::operation::AddAssociation)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddAssociation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddAssociationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddAssociationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddAssociationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.AddAssociation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_association(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddAssociation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddAssociation",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddAssociationInput`](crate::input::AddAssociationInput)
    pub fn builder() -> crate::input::add_association_input::Builder {
        crate::input::add_association_input::Builder::default()
    }
}

/// See [`AddTagsInput`](crate::input::AddTagsInput)
pub mod add_tags_input {
    /// A builder for [`AddTagsInput`](crate::input::AddTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
        /// different ways, for example, by purpose, owner, or environment. For more information,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// Resources</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
        /// different ways, for example, by purpose, owner, or environment. For more information,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// Resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AddTagsInput`](crate::input::AddTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::AddTagsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::AddTagsInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type AddTagsInputOperationOutputAlias = crate::operation::AddTags;
#[doc(hidden)]
pub type AddTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddTagsInput {
    /// Consumes the builder and constructs an Operation<[`AddTags`](crate::operation::AddTags)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.AddTags",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_add_tags(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::AddTags::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "AddTags",
                    "sagemaker",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddTagsInput`](crate::input::AddTagsInput)
    pub fn builder() -> crate::input::add_tags_input::Builder {
        crate::input::add_tags_input::Builder::default()
    }
}

/// See [`AssociateTrialComponentInput`](crate::input::AssociateTrialComponentInput)
pub mod associate_trial_component_input {
    /// A builder for [`AssociateTrialComponentInput`](crate::input::AssociateTrialComponentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trial_component_name: std::option::Option<std::string::String>,
        pub(crate) trial_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the component to associated with the trial.</p>
        pub fn trial_component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.trial_component_name = Some(input.into());
            self
        }
        /// <p>The name of the component to associated with the trial.</p>
        pub fn set_trial_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.trial_component_name = input;
            self
        }
        /// <p>The name of the trial to associate with.</p>
        pub fn trial_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.trial_name = Some(input.into());
            self
        }
        /// <p>The name of the trial to associate with.</p>
        pub fn set_trial_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trial_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateTrialComponentInput`](crate::input::AssociateTrialComponentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateTrialComponentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateTrialComponentInput {
                trial_component_name: self.trial_component_name,
                trial_name: self.trial_name,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateTrialComponentInputOperationOutputAlias =
    crate::operation::AssociateTrialComponent;
#[doc(hidden)]
pub type AssociateTrialComponentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateTrialComponentInput {
    /// Consumes the builder and constructs an Operation<[`AssociateTrialComponent`](crate::operation::AssociateTrialComponent)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateTrialComponent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateTrialComponentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateTrialComponentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateTrialComponentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.AssociateTrialComponent",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_trial_component(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateTrialComponent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateTrialComponent",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateTrialComponentInput`](crate::input::AssociateTrialComponentInput)
    pub fn builder() -> crate::input::associate_trial_component_input::Builder {
        crate::input::associate_trial_component_input::Builder::default()
    }
}

/// See [`BatchDescribeModelPackageInput`](crate::input::BatchDescribeModelPackageInput)
pub mod batch_describe_model_package_input {
    /// A builder for [`BatchDescribeModelPackageInput`](crate::input::BatchDescribeModelPackageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_package_arn_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `model_package_arn_list`.
        ///
        /// To override the contents of this collection use [`set_model_package_arn_list`](Self::set_model_package_arn_list).
        ///
        /// <p>The list of Amazon Resource Name (ARN) of the model package groups.</p>
        pub fn model_package_arn_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.model_package_arn_list.unwrap_or_default();
            v.push(input.into());
            self.model_package_arn_list = Some(v);
            self
        }
        /// <p>The list of Amazon Resource Name (ARN) of the model package groups.</p>
        pub fn set_model_package_arn_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.model_package_arn_list = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDescribeModelPackageInput`](crate::input::BatchDescribeModelPackageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDescribeModelPackageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchDescribeModelPackageInput {
                model_package_arn_list: self.model_package_arn_list,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchDescribeModelPackageInputOperationOutputAlias =
    crate::operation::BatchDescribeModelPackage;
#[doc(hidden)]
pub type BatchDescribeModelPackageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchDescribeModelPackageInput {
    /// Consumes the builder and constructs an Operation<[`BatchDescribeModelPackage`](crate::operation::BatchDescribeModelPackage)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDescribeModelPackage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchDescribeModelPackageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchDescribeModelPackageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchDescribeModelPackageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.BatchDescribeModelPackage",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_describe_model_package(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDescribeModelPackage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDescribeModelPackage",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchDescribeModelPackageInput`](crate::input::BatchDescribeModelPackageInput)
    pub fn builder() -> crate::input::batch_describe_model_package_input::Builder {
        crate::input::batch_describe_model_package_input::Builder::default()
    }
}

/// See [`CreateActionInput`](crate::input::CreateActionInput)
pub mod create_action_input {
    /// A builder for [`CreateActionInput`](crate::input::CreateActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_name: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<crate::model::ActionSource>,
        pub(crate) action_type: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ActionStatus>,
        pub(crate) properties: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) metadata_properties: std::option::Option<crate::model::MetadataProperties>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the action. Must be unique to your account in an Amazon Web Services Region.</p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_name = Some(input.into());
            self
        }
        /// <p>The name of the action. Must be unique to your account in an Amazon Web Services Region.</p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_name = input;
            self
        }
        /// <p>The source type, ID, and URI.</p>
        pub fn source(mut self, input: crate::model::ActionSource) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>The source type, ID, and URI.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::ActionSource>,
        ) -> Self {
            self.source = input;
            self
        }
        /// <p>The action type.</p>
        pub fn action_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_type = Some(input.into());
            self
        }
        /// <p>The action type.</p>
        pub fn set_action_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_type = input;
            self
        }
        /// <p>The description of the action.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the action.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The status of the action.</p>
        pub fn status(mut self, input: crate::model::ActionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the action.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ActionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Adds a key-value pair to `properties`.
        ///
        /// To override the contents of this collection use [`set_properties`](Self::set_properties).
        ///
        /// <p>A list of properties to add to the action.</p>
        pub fn properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.properties.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.properties = Some(hash_map);
            self
        }
        /// <p>A list of properties to add to the action.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.properties = input;
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn metadata_properties(mut self, input: crate::model::MetadataProperties) -> Self {
            self.metadata_properties = Some(input);
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn set_metadata_properties(
            mut self,
            input: std::option::Option<crate::model::MetadataProperties>,
        ) -> Self {
            self.metadata_properties = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to apply to the action.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to apply to the action.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateActionInput`](crate::input::CreateActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateActionInput {
                action_name: self.action_name,
                source: self.source,
                action_type: self.action_type,
                description: self.description,
                status: self.status,
                properties: self.properties,
                metadata_properties: self.metadata_properties,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateActionInputOperationOutputAlias = crate::operation::CreateAction;
#[doc(hidden)]
pub type CreateActionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateActionInput {
    /// Consumes the builder and constructs an Operation<[`CreateAction`](crate::operation::CreateAction)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAction,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateActionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateActionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateActionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateAction",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_action(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAction",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateActionInput`](crate::input::CreateActionInput)
    pub fn builder() -> crate::input::create_action_input::Builder {
        crate::input::create_action_input::Builder::default()
    }
}

/// See [`CreateAlgorithmInput`](crate::input::CreateAlgorithmInput)
pub mod create_algorithm_input {
    /// A builder for [`CreateAlgorithmInput`](crate::input::CreateAlgorithmInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) algorithm_name: std::option::Option<std::string::String>,
        pub(crate) algorithm_description: std::option::Option<std::string::String>,
        pub(crate) training_specification: std::option::Option<crate::model::TrainingSpecification>,
        pub(crate) inference_specification:
            std::option::Option<crate::model::InferenceSpecification>,
        pub(crate) validation_specification:
            std::option::Option<crate::model::AlgorithmValidationSpecification>,
        pub(crate) certify_for_marketplace: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the algorithm.</p>
        pub fn algorithm_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.algorithm_name = Some(input.into());
            self
        }
        /// <p>The name of the algorithm.</p>
        pub fn set_algorithm_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.algorithm_name = input;
            self
        }
        /// <p>A description of the algorithm.</p>
        pub fn algorithm_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.algorithm_description = Some(input.into());
            self
        }
        /// <p>A description of the algorithm.</p>
        pub fn set_algorithm_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.algorithm_description = input;
            self
        }
        /// <p>Specifies details about training jobs run by this algorithm, including the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>The Amazon ECR path of the container and the version digest of the
        /// algorithm.</p>
        /// </li>
        /// <li>
        /// <p>The hyperparameters that the algorithm supports.</p>
        /// </li>
        /// <li>
        /// <p>The instance types that the algorithm supports for training.</p>
        /// </li>
        /// <li>
        /// <p>Whether the algorithm supports distributed training.</p>
        /// </li>
        /// <li>
        /// <p>The metrics that the algorithm emits to Amazon CloudWatch.</p>
        /// </li>
        /// <li>
        /// <p>Which metrics that the algorithm emits can be used as the objective metric for
        /// hyperparameter tuning jobs.</p>
        /// </li>
        /// <li>
        /// <p>The input channels that the algorithm supports for training data. For example,
        /// an algorithm might support <code>train</code>, <code>validation</code>, and
        /// <code>test</code> channels.</p>
        /// </li>
        /// </ul>
        pub fn training_specification(
            mut self,
            input: crate::model::TrainingSpecification,
        ) -> Self {
            self.training_specification = Some(input);
            self
        }
        /// <p>Specifies details about training jobs run by this algorithm, including the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>The Amazon ECR path of the container and the version digest of the
        /// algorithm.</p>
        /// </li>
        /// <li>
        /// <p>The hyperparameters that the algorithm supports.</p>
        /// </li>
        /// <li>
        /// <p>The instance types that the algorithm supports for training.</p>
        /// </li>
        /// <li>
        /// <p>Whether the algorithm supports distributed training.</p>
        /// </li>
        /// <li>
        /// <p>The metrics that the algorithm emits to Amazon CloudWatch.</p>
        /// </li>
        /// <li>
        /// <p>Which metrics that the algorithm emits can be used as the objective metric for
        /// hyperparameter tuning jobs.</p>
        /// </li>
        /// <li>
        /// <p>The input channels that the algorithm supports for training data. For example,
        /// an algorithm might support <code>train</code>, <code>validation</code>, and
        /// <code>test</code> channels.</p>
        /// </li>
        /// </ul>
        pub fn set_training_specification(
            mut self,
            input: std::option::Option<crate::model::TrainingSpecification>,
        ) -> Self {
            self.training_specification = input;
            self
        }
        /// <p>Specifies details about inference jobs that the algorithm runs, including the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>The Amazon ECR paths of containers that contain the inference code and model
        /// artifacts.</p>
        /// </li>
        /// <li>
        /// <p>The instance types that the algorithm supports for transform jobs and
        /// real-time endpoints used for inference.</p>
        /// </li>
        /// <li>
        /// <p>The input and output content formats that the algorithm supports for
        /// inference.</p>
        /// </li>
        /// </ul>
        pub fn inference_specification(
            mut self,
            input: crate::model::InferenceSpecification,
        ) -> Self {
            self.inference_specification = Some(input);
            self
        }
        /// <p>Specifies details about inference jobs that the algorithm runs, including the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>The Amazon ECR paths of containers that contain the inference code and model
        /// artifacts.</p>
        /// </li>
        /// <li>
        /// <p>The instance types that the algorithm supports for transform jobs and
        /// real-time endpoints used for inference.</p>
        /// </li>
        /// <li>
        /// <p>The input and output content formats that the algorithm supports for
        /// inference.</p>
        /// </li>
        /// </ul>
        pub fn set_inference_specification(
            mut self,
            input: std::option::Option<crate::model::InferenceSpecification>,
        ) -> Self {
            self.inference_specification = input;
            self
        }
        /// <p>Specifies configurations for one or more training jobs and that Amazon SageMaker runs to test the
        /// algorithm's training code and, optionally, one or more batch transform jobs that Amazon SageMaker
        /// runs to test the algorithm's inference code.</p>
        pub fn validation_specification(
            mut self,
            input: crate::model::AlgorithmValidationSpecification,
        ) -> Self {
            self.validation_specification = Some(input);
            self
        }
        /// <p>Specifies configurations for one or more training jobs and that Amazon SageMaker runs to test the
        /// algorithm's training code and, optionally, one or more batch transform jobs that Amazon SageMaker
        /// runs to test the algorithm's inference code.</p>
        pub fn set_validation_specification(
            mut self,
            input: std::option::Option<crate::model::AlgorithmValidationSpecification>,
        ) -> Self {
            self.validation_specification = input;
            self
        }
        /// <p>Whether to certify the algorithm so that it can be listed in Amazon Web Services Marketplace.</p>
        pub fn certify_for_marketplace(mut self, input: bool) -> Self {
            self.certify_for_marketplace = Some(input);
            self
        }
        /// <p>Whether to certify the algorithm so that it can be listed in Amazon Web Services Marketplace.</p>
        pub fn set_certify_for_marketplace(mut self, input: std::option::Option<bool>) -> Self {
            self.certify_for_marketplace = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
        /// different ways, for example, by purpose, owner, or environment. For more information,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// Resources</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
        /// different ways, for example, by purpose, owner, or environment. For more information,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// Resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAlgorithmInput`](crate::input::CreateAlgorithmInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAlgorithmInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAlgorithmInput {
                algorithm_name: self.algorithm_name,
                algorithm_description: self.algorithm_description,
                training_specification: self.training_specification,
                inference_specification: self.inference_specification,
                validation_specification: self.validation_specification,
                certify_for_marketplace: self.certify_for_marketplace.unwrap_or_default(),
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAlgorithmInputOperationOutputAlias = crate::operation::CreateAlgorithm;
#[doc(hidden)]
pub type CreateAlgorithmInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateAlgorithmInput {
    /// Consumes the builder and constructs an Operation<[`CreateAlgorithm`](crate::operation::CreateAlgorithm)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAlgorithm,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAlgorithmInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAlgorithmInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAlgorithmInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateAlgorithm",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_algorithm(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAlgorithm::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAlgorithm",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAlgorithmInput`](crate::input::CreateAlgorithmInput)
    pub fn builder() -> crate::input::create_algorithm_input::Builder {
        crate::input::create_algorithm_input::Builder::default()
    }
}

/// See [`CreateAppInput`](crate::input::CreateAppInput)
pub mod create_app_input {
    /// A builder for [`CreateAppInput`](crate::input::CreateAppInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_id: std::option::Option<std::string::String>,
        pub(crate) user_profile_name: std::option::Option<std::string::String>,
        pub(crate) app_type: std::option::Option<crate::model::AppType>,
        pub(crate) app_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) resource_spec: std::option::Option<crate::model::ResourceSpec>,
    }
    impl Builder {
        /// <p>The domain ID.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_id = Some(input.into());
            self
        }
        /// <p>The domain ID.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_id = input;
            self
        }
        /// <p>The user profile name.</p>
        pub fn user_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_profile_name = Some(input.into());
            self
        }
        /// <p>The user profile name.</p>
        pub fn set_user_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_profile_name = input;
            self
        }
        /// <p>The type of app. Supported apps are <code>JupyterServer</code> and
        /// <code>KernelGateway</code>. <code>TensorBoard</code> is not supported.</p>
        pub fn app_type(mut self, input: crate::model::AppType) -> Self {
            self.app_type = Some(input);
            self
        }
        /// <p>The type of app. Supported apps are <code>JupyterServer</code> and
        /// <code>KernelGateway</code>. <code>TensorBoard</code> is not supported.</p>
        pub fn set_app_type(mut self, input: std::option::Option<crate::model::AppType>) -> Self {
            self.app_type = input;
            self
        }
        /// <p>The name of the app.</p>
        pub fn app_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_name = Some(input.into());
            self
        }
        /// <p>The name of the app.</p>
        pub fn set_app_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Each tag consists of a key and an optional value.
        /// Tag keys must be unique per resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Each tag consists of a key and an optional value.
        /// Tag keys must be unique per resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.</p>
        pub fn resource_spec(mut self, input: crate::model::ResourceSpec) -> Self {
            self.resource_spec = Some(input);
            self
        }
        /// <p>The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.</p>
        pub fn set_resource_spec(
            mut self,
            input: std::option::Option<crate::model::ResourceSpec>,
        ) -> Self {
            self.resource_spec = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAppInput`](crate::input::CreateAppInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::CreateAppInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::CreateAppInput {
                domain_id: self.domain_id,
                user_profile_name: self.user_profile_name,
                app_type: self.app_type,
                app_name: self.app_name,
                tags: self.tags,
                resource_spec: self.resource_spec,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAppInputOperationOutputAlias = crate::operation::CreateApp;
#[doc(hidden)]
pub type CreateAppInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateAppInput {
    /// Consumes the builder and constructs an Operation<[`CreateApp`](crate::operation::CreateApp)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateApp,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAppInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAppInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAppInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateApp",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_app(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::CreateApp::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "CreateApp",
                    "sagemaker",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAppInput`](crate::input::CreateAppInput)
    pub fn builder() -> crate::input::create_app_input::Builder {
        crate::input::create_app_input::Builder::default()
    }
}

/// See [`CreateAppImageConfigInput`](crate::input::CreateAppImageConfigInput)
pub mod create_app_image_config_input {
    /// A builder for [`CreateAppImageConfigInput`](crate::input::CreateAppImageConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_image_config_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) kernel_gateway_image_config:
            std::option::Option<crate::model::KernelGatewayImageConfig>,
    }
    impl Builder {
        /// <p>The name of the AppImageConfig. Must be unique to your account.</p>
        pub fn app_image_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_image_config_name = Some(input.into());
            self
        }
        /// <p>The name of the AppImageConfig. Must be unique to your account.</p>
        pub fn set_app_image_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_image_config_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to apply to the AppImageConfig.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to apply to the AppImageConfig.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The KernelGatewayImageConfig.</p>
        pub fn kernel_gateway_image_config(
            mut self,
            input: crate::model::KernelGatewayImageConfig,
        ) -> Self {
            self.kernel_gateway_image_config = Some(input);
            self
        }
        /// <p>The KernelGatewayImageConfig.</p>
        pub fn set_kernel_gateway_image_config(
            mut self,
            input: std::option::Option<crate::model::KernelGatewayImageConfig>,
        ) -> Self {
            self.kernel_gateway_image_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAppImageConfigInput`](crate::input::CreateAppImageConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAppImageConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAppImageConfigInput {
                app_image_config_name: self.app_image_config_name,
                tags: self.tags,
                kernel_gateway_image_config: self.kernel_gateway_image_config,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAppImageConfigInputOperationOutputAlias = crate::operation::CreateAppImageConfig;
#[doc(hidden)]
pub type CreateAppImageConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateAppImageConfigInput {
    /// Consumes the builder and constructs an Operation<[`CreateAppImageConfig`](crate::operation::CreateAppImageConfig)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAppImageConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAppImageConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAppImageConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAppImageConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateAppImageConfig",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_app_image_config(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAppImageConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAppImageConfig",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAppImageConfigInput`](crate::input::CreateAppImageConfigInput)
    pub fn builder() -> crate::input::create_app_image_config_input::Builder {
        crate::input::create_app_image_config_input::Builder::default()
    }
}

/// See [`CreateArtifactInput`](crate::input::CreateArtifactInput)
pub mod create_artifact_input {
    /// A builder for [`CreateArtifactInput`](crate::input::CreateArtifactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) artifact_name: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<crate::model::ArtifactSource>,
        pub(crate) artifact_type: std::option::Option<std::string::String>,
        pub(crate) properties: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) metadata_properties: std::option::Option<crate::model::MetadataProperties>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the artifact. Must be unique to your account in an Amazon Web Services Region.</p>
        pub fn artifact_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.artifact_name = Some(input.into());
            self
        }
        /// <p>The name of the artifact. Must be unique to your account in an Amazon Web Services Region.</p>
        pub fn set_artifact_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.artifact_name = input;
            self
        }
        /// <p>The ID, ID type, and URI of the source.</p>
        pub fn source(mut self, input: crate::model::ArtifactSource) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>The ID, ID type, and URI of the source.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::ArtifactSource>,
        ) -> Self {
            self.source = input;
            self
        }
        /// <p>The artifact type.</p>
        pub fn artifact_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.artifact_type = Some(input.into());
            self
        }
        /// <p>The artifact type.</p>
        pub fn set_artifact_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.artifact_type = input;
            self
        }
        /// Adds a key-value pair to `properties`.
        ///
        /// To override the contents of this collection use [`set_properties`](Self::set_properties).
        ///
        /// <p>A list of properties to add to the artifact.</p>
        pub fn properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.properties.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.properties = Some(hash_map);
            self
        }
        /// <p>A list of properties to add to the artifact.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.properties = input;
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn metadata_properties(mut self, input: crate::model::MetadataProperties) -> Self {
            self.metadata_properties = Some(input);
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn set_metadata_properties(
            mut self,
            input: std::option::Option<crate::model::MetadataProperties>,
        ) -> Self {
            self.metadata_properties = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to apply to the artifact.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to apply to the artifact.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateArtifactInput`](crate::input::CreateArtifactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateArtifactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateArtifactInput {
                artifact_name: self.artifact_name,
                source: self.source,
                artifact_type: self.artifact_type,
                properties: self.properties,
                metadata_properties: self.metadata_properties,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateArtifactInputOperationOutputAlias = crate::operation::CreateArtifact;
#[doc(hidden)]
pub type CreateArtifactInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateArtifactInput {
    /// Consumes the builder and constructs an Operation<[`CreateArtifact`](crate::operation::CreateArtifact)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateArtifact,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateArtifactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateArtifactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateArtifactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateArtifact",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_artifact(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateArtifact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateArtifact",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateArtifactInput`](crate::input::CreateArtifactInput)
    pub fn builder() -> crate::input::create_artifact_input::Builder {
        crate::input::create_artifact_input::Builder::default()
    }
}

/// See [`CreateAutoMlJobInput`](crate::input::CreateAutoMlJobInput)
pub mod create_auto_ml_job_input {
    /// A builder for [`CreateAutoMlJobInput`](crate::input::CreateAutoMlJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_ml_job_name: std::option::Option<std::string::String>,
        pub(crate) input_data_config:
            std::option::Option<std::vec::Vec<crate::model::AutoMlChannel>>,
        pub(crate) output_data_config: std::option::Option<crate::model::AutoMlOutputDataConfig>,
        pub(crate) problem_type: std::option::Option<crate::model::ProblemType>,
        pub(crate) auto_ml_job_objective: std::option::Option<crate::model::AutoMlJobObjective>,
        pub(crate) auto_ml_job_config: std::option::Option<crate::model::AutoMlJobConfig>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) generate_candidate_definitions_only: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) model_deploy_config: std::option::Option<crate::model::ModelDeployConfig>,
    }
    impl Builder {
        /// <p>Identifies an Autopilot job. The name must be unique to your account and is
        /// case-insensitive.</p>
        pub fn auto_ml_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_ml_job_name = Some(input.into());
            self
        }
        /// <p>Identifies an Autopilot job. The name must be unique to your account and is
        /// case-insensitive.</p>
        pub fn set_auto_ml_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_ml_job_name = input;
            self
        }
        /// Appends an item to `input_data_config`.
        ///
        /// To override the contents of this collection use [`set_input_data_config`](Self::set_input_data_config).
        ///
        /// <p>An array of channel objects that describes the input data and its location. Each channel
        /// is a named input source. Similar to <code>InputDataConfig</code> supported by . Format(s) supported: CSV. Minimum
        /// of 500 rows.</p>
        pub fn input_data_config(mut self, input: impl Into<crate::model::AutoMlChannel>) -> Self {
            let mut v = self.input_data_config.unwrap_or_default();
            v.push(input.into());
            self.input_data_config = Some(v);
            self
        }
        /// <p>An array of channel objects that describes the input data and its location. Each channel
        /// is a named input source. Similar to <code>InputDataConfig</code> supported by . Format(s) supported: CSV. Minimum
        /// of 500 rows.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AutoMlChannel>>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p>Provides information about encryption and the Amazon S3 output path needed to store artifacts
        /// from an AutoML job. Format(s) supported: CSV.</p>
        pub fn output_data_config(mut self, input: crate::model::AutoMlOutputDataConfig) -> Self {
            self.output_data_config = Some(input);
            self
        }
        /// <p>Provides information about encryption and the Amazon S3 output path needed to store artifacts
        /// from an AutoML job. Format(s) supported: CSV.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::AutoMlOutputDataConfig>,
        ) -> Self {
            self.output_data_config = input;
            self
        }
        /// <p>Defines the type of supervised learning available for the candidates. Options include:
        /// <code>BinaryClassification</code>, <code>MulticlassClassification</code>, and
        /// <code>Regression</code>. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-problem-types.html">
        /// Amazon SageMaker Autopilot problem types and algorithm support</a>.</p>
        pub fn problem_type(mut self, input: crate::model::ProblemType) -> Self {
            self.problem_type = Some(input);
            self
        }
        /// <p>Defines the type of supervised learning available for the candidates. Options include:
        /// <code>BinaryClassification</code>, <code>MulticlassClassification</code>, and
        /// <code>Regression</code>. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-problem-types.html">
        /// Amazon SageMaker Autopilot problem types and algorithm support</a>.</p>
        pub fn set_problem_type(
            mut self,
            input: std::option::Option<crate::model::ProblemType>,
        ) -> Self {
            self.problem_type = input;
            self
        }
        /// <p>Defines the objective metric used to measure the predictive quality of an AutoML job. You
        /// provide an <a>AutoMLJobObjective$MetricName</a> and Autopilot infers whether to
        /// minimize or maximize it.</p>
        pub fn auto_ml_job_objective(mut self, input: crate::model::AutoMlJobObjective) -> Self {
            self.auto_ml_job_objective = Some(input);
            self
        }
        /// <p>Defines the objective metric used to measure the predictive quality of an AutoML job. You
        /// provide an <a>AutoMLJobObjective$MetricName</a> and Autopilot infers whether to
        /// minimize or maximize it.</p>
        pub fn set_auto_ml_job_objective(
            mut self,
            input: std::option::Option<crate::model::AutoMlJobObjective>,
        ) -> Self {
            self.auto_ml_job_objective = input;
            self
        }
        /// <p>Contains <code>CompletionCriteria</code> and <code>SecurityConfig</code> settings for
        /// the AutoML job.</p>
        pub fn auto_ml_job_config(mut self, input: crate::model::AutoMlJobConfig) -> Self {
            self.auto_ml_job_config = Some(input);
            self
        }
        /// <p>Contains <code>CompletionCriteria</code> and <code>SecurityConfig</code> settings for
        /// the AutoML job.</p>
        pub fn set_auto_ml_job_config(
            mut self,
            input: std::option::Option<crate::model::AutoMlJobConfig>,
        ) -> Self {
            self.auto_ml_job_config = input;
            self
        }
        /// <p>The ARN of the role that is used to access the data.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the role that is used to access the data.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Generates possible candidates without training the models. A candidate is a combination
        /// of data preprocessors, algorithms, and algorithm parameter settings.</p>
        pub fn generate_candidate_definitions_only(mut self, input: bool) -> Self {
            self.generate_candidate_definitions_only = Some(input);
            self
        }
        /// <p>Generates possible candidates without training the models. A candidate is a combination
        /// of data preprocessors, algorithms, and algorithm parameter settings.</p>
        pub fn set_generate_candidate_definitions_only(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.generate_candidate_definitions_only = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Each tag consists of a key and an optional value. Tag keys must be unique per
        /// resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Each tag consists of a key and an optional value. Tag keys must be unique per
        /// resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Specifies how to generate the endpoint name for an automatic one-click Autopilot model
        /// deployment.</p>
        pub fn model_deploy_config(mut self, input: crate::model::ModelDeployConfig) -> Self {
            self.model_deploy_config = Some(input);
            self
        }
        /// <p>Specifies how to generate the endpoint name for an automatic one-click Autopilot model
        /// deployment.</p>
        pub fn set_model_deploy_config(
            mut self,
            input: std::option::Option<crate::model::ModelDeployConfig>,
        ) -> Self {
            self.model_deploy_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAutoMlJobInput`](crate::input::CreateAutoMlJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAutoMlJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAutoMlJobInput {
                auto_ml_job_name: self.auto_ml_job_name,
                input_data_config: self.input_data_config,
                output_data_config: self.output_data_config,
                problem_type: self.problem_type,
                auto_ml_job_objective: self.auto_ml_job_objective,
                auto_ml_job_config: self.auto_ml_job_config,
                role_arn: self.role_arn,
                generate_candidate_definitions_only: self
                    .generate_candidate_definitions_only
                    .unwrap_or_default(),
                tags: self.tags,
                model_deploy_config: self.model_deploy_config,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAutoMlJobInputOperationOutputAlias = crate::operation::CreateAutoMLJob;
#[doc(hidden)]
pub type CreateAutoMlJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateAutoMlJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateAutoMLJob`](crate::operation::CreateAutoMLJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAutoMLJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAutoMlJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAutoMlJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAutoMlJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateAutoMLJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_auto_ml_job(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAutoMLJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAutoMLJob",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAutoMlJobInput`](crate::input::CreateAutoMlJobInput)
    pub fn builder() -> crate::input::create_auto_ml_job_input::Builder {
        crate::input::create_auto_ml_job_input::Builder::default()
    }
}

/// See [`CreateCodeRepositoryInput`](crate::input::CreateCodeRepositoryInput)
pub mod create_code_repository_input {
    /// A builder for [`CreateCodeRepositoryInput`](crate::input::CreateCodeRepositoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code_repository_name: std::option::Option<std::string::String>,
        pub(crate) git_config: std::option::Option<crate::model::GitConfig>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the Git repository. The name must have 1 to 63 characters. Valid
        /// characters are a-z, A-Z, 0-9, and - (hyphen).</p>
        pub fn code_repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_repository_name = Some(input.into());
            self
        }
        /// <p>The name of the Git repository. The name must have 1 to 63 characters. Valid
        /// characters are a-z, A-Z, 0-9, and - (hyphen).</p>
        pub fn set_code_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.code_repository_name = input;
            self
        }
        /// <p>Specifies details about the repository, including the URL where the repository is
        /// located, the default branch, and credentials to use to access the repository.</p>
        pub fn git_config(mut self, input: crate::model::GitConfig) -> Self {
            self.git_config = Some(input);
            self
        }
        /// <p>Specifies details about the repository, including the URL where the repository is
        /// located, the default branch, and credentials to use to access the repository.</p>
        pub fn set_git_config(
            mut self,
            input: std::option::Option<crate::model::GitConfig>,
        ) -> Self {
            self.git_config = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
        /// different ways, for example, by purpose, owner, or environment. For more information,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// Resources</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
        /// different ways, for example, by purpose, owner, or environment. For more information,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// Resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCodeRepositoryInput`](crate::input::CreateCodeRepositoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCodeRepositoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCodeRepositoryInput {
                code_repository_name: self.code_repository_name,
                git_config: self.git_config,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCodeRepositoryInputOperationOutputAlias = crate::operation::CreateCodeRepository;
#[doc(hidden)]
pub type CreateCodeRepositoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateCodeRepositoryInput {
    /// Consumes the builder and constructs an Operation<[`CreateCodeRepository`](crate::operation::CreateCodeRepository)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCodeRepository,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateCodeRepositoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateCodeRepositoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateCodeRepositoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateCodeRepository",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_code_repository(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCodeRepository::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCodeRepository",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateCodeRepositoryInput`](crate::input::CreateCodeRepositoryInput)
    pub fn builder() -> crate::input::create_code_repository_input::Builder {
        crate::input::create_code_repository_input::Builder::default()
    }
}

/// See [`CreateCompilationJobInput`](crate::input::CreateCompilationJobInput)
pub mod create_compilation_job_input {
    /// A builder for [`CreateCompilationJobInput`](crate::input::CreateCompilationJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compilation_job_name: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) input_config: std::option::Option<crate::model::InputConfig>,
        pub(crate) output_config: std::option::Option<crate::model::OutputConfig>,
        pub(crate) vpc_config: std::option::Option<crate::model::NeoVpcConfig>,
        pub(crate) stopping_condition: std::option::Option<crate::model::StoppingCondition>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A name for the model compilation job. The name must be unique within the Amazon Web Services Region
        /// and within your Amazon Web Services account. </p>
        pub fn compilation_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.compilation_job_name = Some(input.into());
            self
        }
        /// <p>A name for the model compilation job. The name must be unique within the Amazon Web Services Region
        /// and within your Amazon Web Services account. </p>
        pub fn set_compilation_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.compilation_job_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on
        /// your behalf. </p>
        /// <p>During model compilation, Amazon SageMaker needs your permission to:</p>
        /// <ul>
        /// <li>
        /// <p>Read input data from an S3 bucket</p>
        /// </li>
        /// <li>
        /// <p>Write model artifacts to an S3 bucket</p>
        /// </li>
        /// <li>
        /// <p>Write logs to Amazon CloudWatch Logs</p>
        /// </li>
        /// <li>
        /// <p>Publish metrics to Amazon CloudWatch</p>
        /// </li>
        /// </ul>
        /// <p>You grant permissions for all of these tasks to an IAM role. To pass this role to
        /// Amazon SageMaker, the caller of this API must have the <code>iam:PassRole</code> permission. For
        /// more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker
        /// Roles.</a>
        /// </p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on
        /// your behalf. </p>
        /// <p>During model compilation, Amazon SageMaker needs your permission to:</p>
        /// <ul>
        /// <li>
        /// <p>Read input data from an S3 bucket</p>
        /// </li>
        /// <li>
        /// <p>Write model artifacts to an S3 bucket</p>
        /// </li>
        /// <li>
        /// <p>Write logs to Amazon CloudWatch Logs</p>
        /// </li>
        /// <li>
        /// <p>Publish metrics to Amazon CloudWatch</p>
        /// </li>
        /// </ul>
        /// <p>You grant permissions for all of these tasks to an IAM role. To pass this role to
        /// Amazon SageMaker, the caller of this API must have the <code>iam:PassRole</code> permission. For
        /// more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker
        /// Roles.</a>
        /// </p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Provides information about the location of input model artifacts, the name and shape
        /// of the expected data inputs, and the framework in which the model was trained.</p>
        pub fn input_config(mut self, input: crate::model::InputConfig) -> Self {
            self.input_config = Some(input);
            self
        }
        /// <p>Provides information about the location of input model artifacts, the name and shape
        /// of the expected data inputs, and the framework in which the model was trained.</p>
        pub fn set_input_config(
            mut self,
            input: std::option::Option<crate::model::InputConfig>,
        ) -> Self {
            self.input_config = input;
            self
        }
        /// <p>Provides information about the output location for the compiled model and the target
        /// device the model runs on.</p>
        pub fn output_config(mut self, input: crate::model::OutputConfig) -> Self {
            self.output_config = Some(input);
            self
        }
        /// <p>Provides information about the output location for the compiled model and the target
        /// device the model runs on.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::OutputConfig>,
        ) -> Self {
            self.output_config = input;
            self
        }
        /// <p>A <a>VpcConfig</a> object that specifies the VPC that you want your
        /// compilation job to connect to. Control access to your models by
        /// configuring the VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html">Protect Compilation Jobs by Using an Amazon
        /// Virtual Private Cloud</a>.</p>
        pub fn vpc_config(mut self, input: crate::model::NeoVpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>A <a>VpcConfig</a> object that specifies the VPC that you want your
        /// compilation job to connect to. Control access to your models by
        /// configuring the VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html">Protect Compilation Jobs by Using an Amazon
        /// Virtual Private Cloud</a>.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::NeoVpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>Specifies a limit to how long a model compilation job can run. When the job reaches
        /// the time limit, Amazon SageMaker ends the compilation job. Use this API to cap model training
        /// costs.</p>
        pub fn stopping_condition(mut self, input: crate::model::StoppingCondition) -> Self {
            self.stopping_condition = Some(input);
            self
        }
        /// <p>Specifies a limit to how long a model compilation job can run. When the job reaches
        /// the time limit, Amazon SageMaker ends the compilation job. Use this API to cap model training
        /// costs.</p>
        pub fn set_stopping_condition(
            mut self,
            input: std::option::Option<crate::model::StoppingCondition>,
        ) -> Self {
            self.stopping_condition = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
        /// different ways, for example, by purpose, owner, or environment. For more information,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// Resources</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
        /// different ways, for example, by purpose, owner, or environment. For more information,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// Resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCompilationJobInput`](crate::input::CreateCompilationJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCompilationJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCompilationJobInput {
                compilation_job_name: self.compilation_job_name,
                role_arn: self.role_arn,
                input_config: self.input_config,
                output_config: self.output_config,
                vpc_config: self.vpc_config,
                stopping_condition: self.stopping_condition,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCompilationJobInputOperationOutputAlias = crate::operation::CreateCompilationJob;
#[doc(hidden)]
pub type CreateCompilationJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateCompilationJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateCompilationJob`](crate::operation::CreateCompilationJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCompilationJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateCompilationJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateCompilationJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateCompilationJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateCompilationJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_compilation_job(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCompilationJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCompilationJob",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateCompilationJobInput`](crate::input::CreateCompilationJobInput)
    pub fn builder() -> crate::input::create_compilation_job_input::Builder {
        crate::input::create_compilation_job_input::Builder::default()
    }
}

/// See [`CreateContextInput`](crate::input::CreateContextInput)
pub mod create_context_input {
    /// A builder for [`CreateContextInput`](crate::input::CreateContextInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) context_name: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<crate::model::ContextSource>,
        pub(crate) context_type: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) properties: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the context. Must be unique to your account in an Amazon Web Services Region.</p>
        pub fn context_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.context_name = Some(input.into());
            self
        }
        /// <p>The name of the context. Must be unique to your account in an Amazon Web Services Region.</p>
        pub fn set_context_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.context_name = input;
            self
        }
        /// <p>The source type, ID, and URI.</p>
        pub fn source(mut self, input: crate::model::ContextSource) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>The source type, ID, and URI.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::ContextSource>,
        ) -> Self {
            self.source = input;
            self
        }
        /// <p>The context type.</p>
        pub fn context_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.context_type = Some(input.into());
            self
        }
        /// <p>The context type.</p>
        pub fn set_context_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.context_type = input;
            self
        }
        /// <p>The description of the context.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the context.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `properties`.
        ///
        /// To override the contents of this collection use [`set_properties`](Self::set_properties).
        ///
        /// <p>A list of properties to add to the context.</p>
        pub fn properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.properties.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.properties = Some(hash_map);
            self
        }
        /// <p>A list of properties to add to the context.</p>
        pub fn set_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.properties = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to apply to the context.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to apply to the context.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateContextInput`](crate::input::CreateContextInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateContextInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateContextInput {
                context_name: self.context_name,
                source: self.source,
                context_type: self.context_type,
                description: self.description,
                properties: self.properties,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateContextInputOperationOutputAlias = crate::operation::CreateContext;
#[doc(hidden)]
pub type CreateContextInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateContextInput {
    /// Consumes the builder and constructs an Operation<[`CreateContext`](crate::operation::CreateContext)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateContext,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateContextInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateContextInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateContextInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateContext",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_context(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateContext::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateContext",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateContextInput`](crate::input::CreateContextInput)
    pub fn builder() -> crate::input::create_context_input::Builder {
        crate::input::create_context_input::Builder::default()
    }
}

/// See [`CreateDataQualityJobDefinitionInput`](crate::input::CreateDataQualityJobDefinitionInput)
pub mod create_data_quality_job_definition_input {
    /// A builder for [`CreateDataQualityJobDefinitionInput`](crate::input::CreateDataQualityJobDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_definition_name: std::option::Option<std::string::String>,
        pub(crate) data_quality_baseline_config:
            std::option::Option<crate::model::DataQualityBaselineConfig>,
        pub(crate) data_quality_app_specification:
            std::option::Option<crate::model::DataQualityAppSpecification>,
        pub(crate) data_quality_job_input: std::option::Option<crate::model::DataQualityJobInput>,
        pub(crate) data_quality_job_output_config:
            std::option::Option<crate::model::MonitoringOutputConfig>,
        pub(crate) job_resources: std::option::Option<crate::model::MonitoringResources>,
        pub(crate) network_config: std::option::Option<crate::model::MonitoringNetworkConfig>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) stopping_condition:
            std::option::Option<crate::model::MonitoringStoppingCondition>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name for the monitoring job definition.</p>
        pub fn job_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_definition_name = Some(input.into());
            self
        }
        /// <p>The name for the monitoring job definition.</p>
        pub fn set_job_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_definition_name = input;
            self
        }
        /// <p>Configures the constraints and baselines for the monitoring job.</p>
        pub fn data_quality_baseline_config(
            mut self,
            input: crate::model::DataQualityBaselineConfig,
        ) -> Self {
            self.data_quality_baseline_config = Some(input);
            self
        }
        /// <p>Configures the constraints and baselines for the monitoring job.</p>
        pub fn set_data_quality_baseline_config(
            mut self,
            input: std::option::Option<crate::model::DataQualityBaselineConfig>,
        ) -> Self {
            self.data_quality_baseline_config = input;
            self
        }
        /// <p>Specifies the container that runs the monitoring job.</p>
        pub fn data_quality_app_specification(
            mut self,
            input: crate::model::DataQualityAppSpecification,
        ) -> Self {
            self.data_quality_app_specification = Some(input);
            self
        }
        /// <p>Specifies the container that runs the monitoring job.</p>
        pub fn set_data_quality_app_specification(
            mut self,
            input: std::option::Option<crate::model::DataQualityAppSpecification>,
        ) -> Self {
            self.data_quality_app_specification = input;
            self
        }
        /// <p>A list of inputs for the monitoring job. Currently endpoints are supported as monitoring
        /// inputs.</p>
        pub fn data_quality_job_input(mut self, input: crate::model::DataQualityJobInput) -> Self {
            self.data_quality_job_input = Some(input);
            self
        }
        /// <p>A list of inputs for the monitoring job. Currently endpoints are supported as monitoring
        /// inputs.</p>
        pub fn set_data_quality_job_input(
            mut self,
            input: std::option::Option<crate::model::DataQualityJobInput>,
        ) -> Self {
            self.data_quality_job_input = input;
            self
        }
        /// <p>The output configuration for monitoring jobs.</p>
        pub fn data_quality_job_output_config(
            mut self,
            input: crate::model::MonitoringOutputConfig,
        ) -> Self {
            self.data_quality_job_output_config = Some(input);
            self
        }
        /// <p>The output configuration for monitoring jobs.</p>
        pub fn set_data_quality_job_output_config(
            mut self,
            input: std::option::Option<crate::model::MonitoringOutputConfig>,
        ) -> Self {
            self.data_quality_job_output_config = input;
            self
        }
        /// <p>Identifies the resources to deploy for a monitoring job.</p>
        pub fn job_resources(mut self, input: crate::model::MonitoringResources) -> Self {
            self.job_resources = Some(input);
            self
        }
        /// <p>Identifies the resources to deploy for a monitoring job.</p>
        pub fn set_job_resources(
            mut self,
            input: std::option::Option<crate::model::MonitoringResources>,
        ) -> Self {
            self.job_resources = input;
            self
        }
        /// <p>Specifies networking configuration for the monitoring job.</p>
        pub fn network_config(mut self, input: crate::model::MonitoringNetworkConfig) -> Self {
            self.network_config = Some(input);
            self
        }
        /// <p>Specifies networking configuration for the monitoring job.</p>
        pub fn set_network_config(
            mut self,
            input: std::option::Option<crate::model::MonitoringNetworkConfig>,
        ) -> Self {
            self.network_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to
        /// perform tasks on your behalf.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to
        /// perform tasks on your behalf.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
        pub fn stopping_condition(
            mut self,
            input: crate::model::MonitoringStoppingCondition,
        ) -> Self {
            self.stopping_condition = Some(input);
            self
        }
        /// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
        pub fn set_stopping_condition(
            mut self,
            input: std::option::Option<crate::model::MonitoringStoppingCondition>,
        ) -> Self {
            self.stopping_condition = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management
        /// User Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management
        /// User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDataQualityJobDefinitionInput`](crate::input::CreateDataQualityJobDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDataQualityJobDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDataQualityJobDefinitionInput {
                job_definition_name: self.job_definition_name,
                data_quality_baseline_config: self.data_quality_baseline_config,
                data_quality_app_specification: self.data_quality_app_specification,
                data_quality_job_input: self.data_quality_job_input,
                data_quality_job_output_config: self.data_quality_job_output_config,
                job_resources: self.job_resources,
                network_config: self.network_config,
                role_arn: self.role_arn,
                stopping_condition: self.stopping_condition,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDataQualityJobDefinitionInputOperationOutputAlias =
    crate::operation::CreateDataQualityJobDefinition;
#[doc(hidden)]
pub type CreateDataQualityJobDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDataQualityJobDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`CreateDataQualityJobDefinition`](crate::operation::CreateDataQualityJobDefinition)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDataQualityJobDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDataQualityJobDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDataQualityJobDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDataQualityJobDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateDataQualityJobDefinition",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_data_quality_job_definition(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDataQualityJobDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDataQualityJobDefinition",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDataQualityJobDefinitionInput`](crate::input::CreateDataQualityJobDefinitionInput)
    pub fn builder() -> crate::input::create_data_quality_job_definition_input::Builder {
        crate::input::create_data_quality_job_definition_input::Builder::default()
    }
}

/// See [`CreateDeviceFleetInput`](crate::input::CreateDeviceFleetInput)
pub mod create_device_fleet_input {
    /// A builder for [`CreateDeviceFleetInput`](crate::input::CreateDeviceFleetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_fleet_name: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) output_config: std::option::Option<crate::model::EdgeOutputConfig>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) enable_iot_role_alias: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the fleet that the device belongs to.</p>
        pub fn device_fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_fleet_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet that the device belongs to.</p>
        pub fn set_device_fleet_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_fleet_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that has access to Amazon Web Services Internet of Things (IoT).</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that has access to Amazon Web Services Internet of Things (IoT).</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>A description of the fleet.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the fleet.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The output configuration for storing sample data collected by the fleet.</p>
        pub fn output_config(mut self, input: crate::model::EdgeOutputConfig) -> Self {
            self.output_config = Some(input);
            self
        }
        /// <p>The output configuration for storing sample data collected by the fleet.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::EdgeOutputConfig>,
        ) -> Self {
            self.output_config = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Creates tags for the specified fleet.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Creates tags for the specified fleet.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Whether to create an Amazon Web Services IoT Role Alias during device fleet creation.
        /// The name of the role alias generated will match this pattern:
        /// "SageMakerEdge-{DeviceFleetName}".</p>
        /// <p>For example, if your device fleet is called "demo-fleet", the name of
        /// the role alias will be "SageMakerEdge-demo-fleet".</p>
        pub fn enable_iot_role_alias(mut self, input: bool) -> Self {
            self.enable_iot_role_alias = Some(input);
            self
        }
        /// <p>Whether to create an Amazon Web Services IoT Role Alias during device fleet creation.
        /// The name of the role alias generated will match this pattern:
        /// "SageMakerEdge-{DeviceFleetName}".</p>
        /// <p>For example, if your device fleet is called "demo-fleet", the name of
        /// the role alias will be "SageMakerEdge-demo-fleet".</p>
        pub fn set_enable_iot_role_alias(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_iot_role_alias = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDeviceFleetInput`](crate::input::CreateDeviceFleetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDeviceFleetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDeviceFleetInput {
                device_fleet_name: self.device_fleet_name,
                role_arn: self.role_arn,
                description: self.description,
                output_config: self.output_config,
                tags: self.tags,
                enable_iot_role_alias: self.enable_iot_role_alias,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDeviceFleetInputOperationOutputAlias = crate::operation::CreateDeviceFleet;
#[doc(hidden)]
pub type CreateDeviceFleetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDeviceFleetInput {
    /// Consumes the builder and constructs an Operation<[`CreateDeviceFleet`](crate::operation::CreateDeviceFleet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDeviceFleet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDeviceFleetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDeviceFleetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDeviceFleetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateDeviceFleet",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_device_fleet(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDeviceFleet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDeviceFleet",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDeviceFleetInput`](crate::input::CreateDeviceFleetInput)
    pub fn builder() -> crate::input::create_device_fleet_input::Builder {
        crate::input::create_device_fleet_input::Builder::default()
    }
}

/// See [`CreateDomainInput`](crate::input::CreateDomainInput)
pub mod create_domain_input {
    /// A builder for [`CreateDomainInput`](crate::input::CreateDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) auth_mode: std::option::Option<crate::model::AuthMode>,
        pub(crate) default_user_settings: std::option::Option<crate::model::UserSettings>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) app_network_access_type: std::option::Option<crate::model::AppNetworkAccessType>,
        pub(crate) home_efs_file_system_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) app_security_group_management:
            std::option::Option<crate::model::AppSecurityGroupManagement>,
        pub(crate) domain_settings: std::option::Option<crate::model::DomainSettings>,
    }
    impl Builder {
        /// <p>A name for the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>A name for the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The mode of authentication that members use to access the domain.</p>
        pub fn auth_mode(mut self, input: crate::model::AuthMode) -> Self {
            self.auth_mode = Some(input);
            self
        }
        /// <p>The mode of authentication that members use to access the domain.</p>
        pub fn set_auth_mode(mut self, input: std::option::Option<crate::model::AuthMode>) -> Self {
            self.auth_mode = input;
            self
        }
        /// <p>The default settings to use to create a user profile when <code>UserSettings</code> isn't specified
        /// in the call to the <code>CreateUserProfile</code> API.</p>
        /// <p>
        /// <code>SecurityGroups</code> is aggregated when specified in both calls. For all other
        /// settings in <code>UserSettings</code>, the values specified in <code>CreateUserProfile</code>
        /// take precedence over those specified in <code>CreateDomain</code>.</p>
        pub fn default_user_settings(mut self, input: crate::model::UserSettings) -> Self {
            self.default_user_settings = Some(input);
            self
        }
        /// <p>The default settings to use to create a user profile when <code>UserSettings</code> isn't specified
        /// in the call to the <code>CreateUserProfile</code> API.</p>
        /// <p>
        /// <code>SecurityGroups</code> is aggregated when specified in both calls. For all other
        /// settings in <code>UserSettings</code>, the values specified in <code>CreateUserProfile</code>
        /// take precedence over those specified in <code>CreateDomain</code>.</p>
        pub fn set_default_user_settings(
            mut self,
            input: std::option::Option<crate::model::UserSettings>,
        ) -> Self {
            self.default_user_settings = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The VPC subnets that Studio uses for communication.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The VPC subnets that Studio uses for communication.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// <p>The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to associated with the Domain. Each tag consists of a key and an optional value.
        /// Tag keys must be unique per resource. Tags are searchable using the
        /// <code>Search</code> API.</p>
        /// <p>Tags that you specify for the Domain are also added to all Apps that the
        /// Domain launches.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Tags to associated with the Domain. Each tag consists of a key and an optional value.
        /// Tag keys must be unique per resource. Tags are searchable using the
        /// <code>Search</code> API.</p>
        /// <p>Tags that you specify for the Domain are also added to all Apps that the
        /// Domain launches.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Specifies the VPC used for non-EFS traffic. The default value is
        /// <code>PublicInternetOnly</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by
        /// Amazon SageMaker, which allows direct internet access</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets</p>
        /// </li>
        /// </ul>
        pub fn app_network_access_type(
            mut self,
            input: crate::model::AppNetworkAccessType,
        ) -> Self {
            self.app_network_access_type = Some(input);
            self
        }
        /// <p>Specifies the VPC used for non-EFS traffic. The default value is
        /// <code>PublicInternetOnly</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by
        /// Amazon SageMaker, which allows direct internet access</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets</p>
        /// </li>
        /// </ul>
        pub fn set_app_network_access_type(
            mut self,
            input: std::option::Option<crate::model::AppNetworkAccessType>,
        ) -> Self {
            self.app_network_access_type = input;
            self
        }
        /// <p>This member is deprecated and replaced with <code>KmsKeyId</code>.</p>
        pub fn home_efs_file_system_kms_key_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.home_efs_file_system_kms_key_id = Some(input.into());
            self
        }
        /// <p>This member is deprecated and replaced with <code>KmsKeyId</code>.</p>
        pub fn set_home_efs_file_system_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.home_efs_file_system_kms_key_id = input;
            self
        }
        /// <p>SageMaker uses Amazon Web Services KMS to encrypt the EFS volume attached to the domain with an Amazon Web Services managed
        /// key by default. For more control, specify a customer managed key.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>SageMaker uses Amazon Web Services KMS to encrypt the EFS volume attached to the domain with an Amazon Web Services managed
        /// key by default. For more control, specify a customer managed key.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The entity that creates and manages the required security groups for inter-app
        /// communication in <code>VPCOnly</code> mode. Required when
        /// <code>CreateDomain.AppNetworkAccessType</code> is <code>VPCOnly</code> and
        /// <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is
        /// provided.</p>
        pub fn app_security_group_management(
            mut self,
            input: crate::model::AppSecurityGroupManagement,
        ) -> Self {
            self.app_security_group_management = Some(input);
            self
        }
        /// <p>The entity that creates and manages the required security groups for inter-app
        /// communication in <code>VPCOnly</code> mode. Required when
        /// <code>CreateDomain.AppNetworkAccessType</code> is <code>VPCOnly</code> and
        /// <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is
        /// provided.</p>
        pub fn set_app_security_group_management(
            mut self,
            input: std::option::Option<crate::model::AppSecurityGroupManagement>,
        ) -> Self {
            self.app_security_group_management = input;
            self
        }
        /// <p>A collection of <code>Domain</code> settings.</p>
        pub fn domain_settings(mut self, input: crate::model::DomainSettings) -> Self {
            self.domain_settings = Some(input);
            self
        }
        /// <p>A collection of <code>Domain</code> settings.</p>
        pub fn set_domain_settings(
            mut self,
            input: std::option::Option<crate::model::DomainSettings>,
        ) -> Self {
            self.domain_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDomainInput`](crate::input::CreateDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDomainInput {
                domain_name: self.domain_name,
                auth_mode: self.auth_mode,
                default_user_settings: self.default_user_settings,
                subnet_ids: self.subnet_ids,
                vpc_id: self.vpc_id,
                tags: self.tags,
                app_network_access_type: self.app_network_access_type,
                home_efs_file_system_kms_key_id: self.home_efs_file_system_kms_key_id,
                kms_key_id: self.kms_key_id,
                app_security_group_management: self.app_security_group_management,
                domain_settings: self.domain_settings,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDomainInputOperationOutputAlias = crate::operation::CreateDomain;
#[doc(hidden)]
pub type CreateDomainInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDomainInput {
    /// Consumes the builder and constructs an Operation<[`CreateDomain`](crate::operation::CreateDomain)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDomain,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDomainInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDomainInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDomainInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateDomain",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_domain(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDomain",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDomainInput`](crate::input::CreateDomainInput)
    pub fn builder() -> crate::input::create_domain_input::Builder {
        crate::input::create_domain_input::Builder::default()
    }
}

/// See [`CreateEdgePackagingJobInput`](crate::input::CreateEdgePackagingJobInput)
pub mod create_edge_packaging_job_input {
    /// A builder for [`CreateEdgePackagingJobInput`](crate::input::CreateEdgePackagingJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) edge_packaging_job_name: std::option::Option<std::string::String>,
        pub(crate) compilation_job_name: std::option::Option<std::string::String>,
        pub(crate) model_name: std::option::Option<std::string::String>,
        pub(crate) model_version: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) output_config: std::option::Option<crate::model::EdgeOutputConfig>,
        pub(crate) resource_key: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the edge packaging job.</p>
        pub fn edge_packaging_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.edge_packaging_job_name = Some(input.into());
            self
        }
        /// <p>The name of the edge packaging job.</p>
        pub fn set_edge_packaging_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.edge_packaging_job_name = input;
            self
        }
        /// <p>The name of the SageMaker Neo compilation job that will be used to locate model artifacts for packaging.</p>
        pub fn compilation_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.compilation_job_name = Some(input.into());
            self
        }
        /// <p>The name of the SageMaker Neo compilation job that will be used to locate model artifacts for packaging.</p>
        pub fn set_compilation_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.compilation_job_name = input;
            self
        }
        /// <p>The name of the model.</p>
        pub fn model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_name = Some(input.into());
            self
        }
        /// <p>The name of the model.</p>
        pub fn set_model_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_name = input;
            self
        }
        /// <p>The version of the model.</p>
        pub fn model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_version = Some(input.into());
            self
        }
        /// <p>The version of the model.</p>
        pub fn set_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_version = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to download and upload the model, and to contact SageMaker Neo.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to download and upload the model, and to contact SageMaker Neo.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Provides information about the output location for the packaged model.</p>
        pub fn output_config(mut self, input: crate::model::EdgeOutputConfig) -> Self {
            self.output_config = Some(input);
            self
        }
        /// <p>Provides information about the output location for the packaged model.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::EdgeOutputConfig>,
        ) -> Self {
            self.output_config = input;
            self
        }
        /// <p>The Amazon Web Services KMS key to use when encrypting the EBS volume the edge packaging job runs on.</p>
        pub fn resource_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_key = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services KMS key to use when encrypting the EBS volume the edge packaging job runs on.</p>
        pub fn set_resource_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_key = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Creates tags for the packaging job.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Creates tags for the packaging job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEdgePackagingJobInput`](crate::input::CreateEdgePackagingJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEdgePackagingJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEdgePackagingJobInput {
                edge_packaging_job_name: self.edge_packaging_job_name,
                compilation_job_name: self.compilation_job_name,
                model_name: self.model_name,
                model_version: self.model_version,
                role_arn: self.role_arn,
                output_config: self.output_config,
                resource_key: self.resource_key,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEdgePackagingJobInputOperationOutputAlias = crate::operation::CreateEdgePackagingJob;
#[doc(hidden)]
pub type CreateEdgePackagingJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateEdgePackagingJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateEdgePackagingJob`](crate::operation::CreateEdgePackagingJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEdgePackagingJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateEdgePackagingJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateEdgePackagingJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateEdgePackagingJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateEdgePackagingJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_edge_packaging_job(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEdgePackagingJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEdgePackagingJob",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateEdgePackagingJobInput`](crate::input::CreateEdgePackagingJobInput)
    pub fn builder() -> crate::input::create_edge_packaging_job_input::Builder {
        crate::input::create_edge_packaging_job_input::Builder::default()
    }
}

/// See [`CreateEndpointInput`](crate::input::CreateEndpointInput)
pub mod create_endpoint_input {
    /// A builder for [`CreateEndpointInput`](crate::input::CreateEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_name: std::option::Option<std::string::String>,
        pub(crate) endpoint_config_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the endpoint.The name must be unique within an Amazon Web Services Region in your Amazon Web Services
        /// account. The name is case-insensitive in <code>CreateEndpoint</code>, but the case is
        /// preserved and must be matched in .</p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_name = Some(input.into());
            self
        }
        /// <p>The name of the endpoint.The name must be unique within an Amazon Web Services Region in your Amazon Web Services
        /// account. The name is case-insensitive in <code>CreateEndpoint</code>, but the case is
        /// preserved and must be matched in .</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_name = input;
            self
        }
        /// <p>The name of an endpoint configuration. For more information, see <a>CreateEndpointConfig</a>. </p>
        pub fn endpoint_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_config_name = Some(input.into());
            self
        }
        /// <p>The name of an endpoint configuration. For more information, see <a>CreateEndpointConfig</a>. </p>
        pub fn set_endpoint_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_config_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
        /// different ways, for example, by purpose, owner, or environment. For more information,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// Resources</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
        /// different ways, for example, by purpose, owner, or environment. For more information,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// Resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEndpointInput`](crate::input::CreateEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEndpointInput {
                endpoint_name: self.endpoint_name,
                endpoint_config_name: self.endpoint_config_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEndpointInputOperationOutputAlias = crate::operation::CreateEndpoint;
#[doc(hidden)]
pub type CreateEndpointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateEndpointInput {
    /// Consumes the builder and constructs an Operation<[`CreateEndpoint`](crate::operation::CreateEndpoint)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEndpoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateEndpoint",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_endpoint(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEndpoint",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateEndpointInput`](crate::input::CreateEndpointInput)
    pub fn builder() -> crate::input::create_endpoint_input::Builder {
        crate::input::create_endpoint_input::Builder::default()
    }
}

/// See [`CreateEndpointConfigInput`](crate::input::CreateEndpointConfigInput)
pub mod create_endpoint_config_input {
    /// A builder for [`CreateEndpointConfigInput`](crate::input::CreateEndpointConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_config_name: std::option::Option<std::string::String>,
        pub(crate) production_variants:
            std::option::Option<std::vec::Vec<crate::model::ProductionVariant>>,
        pub(crate) data_capture_config: std::option::Option<crate::model::DataCaptureConfig>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) async_inference_config: std::option::Option<crate::model::AsyncInferenceConfig>,
    }
    impl Builder {
        /// <p>The name of the endpoint configuration. You specify this name in a <a>CreateEndpoint</a> request. </p>
        pub fn endpoint_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_config_name = Some(input.into());
            self
        }
        /// <p>The name of the endpoint configuration. You specify this name in a <a>CreateEndpoint</a> request. </p>
        pub fn set_endpoint_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_config_name = input;
            self
        }
        /// Appends an item to `production_variants`.
        ///
        /// To override the contents of this collection use [`set_production_variants`](Self::set_production_variants).
        ///
        /// <p>An list of <code>ProductionVariant</code> objects, one for each model that you want
        /// to host at this endpoint.</p>
        pub fn production_variants(
            mut self,
            input: impl Into<crate::model::ProductionVariant>,
        ) -> Self {
            let mut v = self.production_variants.unwrap_or_default();
            v.push(input.into());
            self.production_variants = Some(v);
            self
        }
        /// <p>An list of <code>ProductionVariant</code> objects, one for each model that you want
        /// to host at this endpoint.</p>
        pub fn set_production_variants(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProductionVariant>>,
        ) -> Self {
            self.production_variants = input;
            self
        }
        /// <p></p>
        pub fn data_capture_config(mut self, input: crate::model::DataCaptureConfig) -> Self {
            self.data_capture_config = Some(input);
            self
        }
        /// <p></p>
        pub fn set_data_capture_config(
            mut self,
            input: std::option::Option<crate::model::DataCaptureConfig>,
        ) -> Self {
            self.data_capture_config = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
        /// different ways, for example, by purpose, owner, or environment. For more information,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// Resources</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
        /// different ways, for example, by purpose, owner, or environment. For more information,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// Resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that Amazon SageMaker uses to encrypt data on
        /// the storage volume attached to the ML compute instance that hosts the endpoint.</p>
        /// <p>The KmsKeyId can be any of the following formats: </p>
        /// <ul>
        /// <li>
        /// <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Key ARN:
        /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias name: <code>alias/ExampleAlias</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias name ARN:
        /// <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The KMS key policy must grant permission to the IAM role that you specify in your
        /// <code>CreateEndpoint</code>, <code>UpdateEndpoint</code> requests. For more
        /// information, refer to the Amazon Web Services Key Management Service section<a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html"> Using Key
        /// Policies in Amazon Web Services KMS </a>
        /// </p>
        /// <note>
        /// <p>Certain Nitro-based instances include local storage, dependent on the instance
        /// type. Local storage volumes are encrypted using a hardware module on the instance.
        /// You can't request a <code>KmsKeyId</code> when using an instance type with local
        /// storage. If any of the models that you specify in the
        /// <code>ProductionVariants</code> parameter use nitro-based instances with local
        /// storage, do not specify a value for the <code>KmsKeyId</code> parameter. If you
        /// specify a value for <code>KmsKeyId</code> when using any nitro-based instances with
        /// local storage, the call to <code>CreateEndpointConfig</code> fails.</p>
        /// <p>For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a>.</p>
        /// <p>For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD
        /// Instance Store Volumes</a>.</p>
        /// </note>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that Amazon SageMaker uses to encrypt data on
        /// the storage volume attached to the ML compute instance that hosts the endpoint.</p>
        /// <p>The KmsKeyId can be any of the following formats: </p>
        /// <ul>
        /// <li>
        /// <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Key ARN:
        /// <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias name: <code>alias/ExampleAlias</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Alias name ARN:
        /// <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The KMS key policy must grant permission to the IAM role that you specify in your
        /// <code>CreateEndpoint</code>, <code>UpdateEndpoint</code> requests. For more
        /// information, refer to the Amazon Web Services Key Management Service section<a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html"> Using Key
        /// Policies in Amazon Web Services KMS </a>
        /// </p>
        /// <note>
        /// <p>Certain Nitro-based instances include local storage, dependent on the instance
        /// type. Local storage volumes are encrypted using a hardware module on the instance.
        /// You can't request a <code>KmsKeyId</code> when using an instance type with local
        /// storage. If any of the models that you specify in the
        /// <code>ProductionVariants</code> parameter use nitro-based instances with local
        /// storage, do not specify a value for the <code>KmsKeyId</code> parameter. If you
        /// specify a value for <code>KmsKeyId</code> when using any nitro-based instances with
        /// local storage, the call to <code>CreateEndpointConfig</code> fails.</p>
        /// <p>For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a>.</p>
        /// <p>For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD
        /// Instance Store Volumes</a>.</p>
        /// </note>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>Specifies configuration for how an endpoint performs asynchronous inference.
        /// This is a required field in order for your Endpoint to be invoked using
        /// <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html">
        /// <code>InvokeEndpointAsync</code>
        /// </a>.</p>
        pub fn async_inference_config(mut self, input: crate::model::AsyncInferenceConfig) -> Self {
            self.async_inference_config = Some(input);
            self
        }
        /// <p>Specifies configuration for how an endpoint performs asynchronous inference.
        /// This is a required field in order for your Endpoint to be invoked using
        /// <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html">
        /// <code>InvokeEndpointAsync</code>
        /// </a>.</p>
        pub fn set_async_inference_config(
            mut self,
            input: std::option::Option<crate::model::AsyncInferenceConfig>,
        ) -> Self {
            self.async_inference_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEndpointConfigInput`](crate::input::CreateEndpointConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEndpointConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEndpointConfigInput {
                endpoint_config_name: self.endpoint_config_name,
                production_variants: self.production_variants,
                data_capture_config: self.data_capture_config,
                tags: self.tags,
                kms_key_id: self.kms_key_id,
                async_inference_config: self.async_inference_config,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEndpointConfigInputOperationOutputAlias = crate::operation::CreateEndpointConfig;
#[doc(hidden)]
pub type CreateEndpointConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateEndpointConfigInput {
    /// Consumes the builder and constructs an Operation<[`CreateEndpointConfig`](crate::operation::CreateEndpointConfig)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEndpointConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateEndpointConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateEndpointConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateEndpointConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateEndpointConfig",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_endpoint_config(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEndpointConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEndpointConfig",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateEndpointConfigInput`](crate::input::CreateEndpointConfigInput)
    pub fn builder() -> crate::input::create_endpoint_config_input::Builder {
        crate::input::create_endpoint_config_input::Builder::default()
    }
}

/// See [`CreateExperimentInput`](crate::input::CreateExperimentInput)
pub mod create_experiment_input {
    /// A builder for [`CreateExperimentInput`](crate::input::CreateExperimentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) experiment_name: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the experiment. The name must be unique in your Amazon Web Services account and is not
        /// case-sensitive.</p>
        pub fn experiment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.experiment_name = Some(input.into());
            self
        }
        /// <p>The name of the experiment. The name must be unique in your Amazon Web Services account and is not
        /// case-sensitive.</p>
        pub fn set_experiment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.experiment_name = input;
            self
        }
        /// <p>The name of the experiment as displayed. The name doesn't need to be unique. If you don't
        /// specify <code>DisplayName</code>, the value in <code>ExperimentName</code> is
        /// displayed.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The name of the experiment as displayed. The name doesn't need to be unique. If you don't
        /// specify <code>DisplayName</code>, the value in <code>ExperimentName</code> is
        /// displayed.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The description of the experiment.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the experiment.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to associate with the experiment. You can use <a>Search</a> API
        /// to search on the tags.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to associate with the experiment. You can use <a>Search</a> API
        /// to search on the tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateExperimentInput`](crate::input::CreateExperimentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateExperimentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateExperimentInput {
                experiment_name: self.experiment_name,
                display_name: self.display_name,
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateExperimentInputOperationOutputAlias = crate::operation::CreateExperiment;
#[doc(hidden)]
pub type CreateExperimentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateExperimentInput {
    /// Consumes the builder and constructs an Operation<[`CreateExperiment`](crate::operation::CreateExperiment)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateExperiment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateExperimentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateExperimentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateExperimentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateExperiment",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_experiment(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateExperiment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateExperiment",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateExperimentInput`](crate::input::CreateExperimentInput)
    pub fn builder() -> crate::input::create_experiment_input::Builder {
        crate::input::create_experiment_input::Builder::default()
    }
}

/// See [`CreateFeatureGroupInput`](crate::input::CreateFeatureGroupInput)
pub mod create_feature_group_input {
    /// A builder for [`CreateFeatureGroupInput`](crate::input::CreateFeatureGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) feature_group_name: std::option::Option<std::string::String>,
        pub(crate) record_identifier_feature_name: std::option::Option<std::string::String>,
        pub(crate) event_time_feature_name: std::option::Option<std::string::String>,
        pub(crate) feature_definitions:
            std::option::Option<std::vec::Vec<crate::model::FeatureDefinition>>,
        pub(crate) online_store_config: std::option::Option<crate::model::OnlineStoreConfig>,
        pub(crate) offline_store_config: std::option::Option<crate::model::OfflineStoreConfig>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the <code>FeatureGroup</code>. The name must be unique within an Amazon Web Services Region
        /// in an Amazon Web Services account. The name:</p>
        /// <ul>
        /// <li>
        /// <p>Must start and end with an alphanumeric character.</p>
        /// </li>
        /// <li>
        /// <p>Can only contain alphanumeric character and hyphens. Spaces are not allowed.
        /// </p>
        /// </li>
        /// </ul>
        pub fn feature_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.feature_group_name = Some(input.into());
            self
        }
        /// <p>The name of the <code>FeatureGroup</code>. The name must be unique within an Amazon Web Services Region
        /// in an Amazon Web Services account. The name:</p>
        /// <ul>
        /// <li>
        /// <p>Must start and end with an alphanumeric character.</p>
        /// </li>
        /// <li>
        /// <p>Can only contain alphanumeric character and hyphens. Spaces are not allowed.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_feature_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.feature_group_name = input;
            self
        }
        /// <p>The name of the <code>Feature</code> whose value uniquely identifies a
        /// <code>Record</code> defined in the <code>FeatureStore</code>. Only the latest record per
        /// identifier value will be stored in the <code>OnlineStore</code>.
        /// <code>RecordIdentifierFeatureName</code> must be one of feature definitions'
        /// names.</p>
        /// <p>You use the <code>RecordIdentifierFeatureName</code> to access data in a
        /// <code>FeatureStore</code>.</p>
        /// <p>This name:</p>
        /// <ul>
        /// <li>
        /// <p>Must start and end with an alphanumeric character.</p>
        /// </li>
        /// <li>
        /// <p>Can only contains alphanumeric characters, hyphens, underscores. Spaces are not
        /// allowed. </p>
        /// </li>
        /// </ul>
        pub fn record_identifier_feature_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.record_identifier_feature_name = Some(input.into());
            self
        }
        /// <p>The name of the <code>Feature</code> whose value uniquely identifies a
        /// <code>Record</code> defined in the <code>FeatureStore</code>. Only the latest record per
        /// identifier value will be stored in the <code>OnlineStore</code>.
        /// <code>RecordIdentifierFeatureName</code> must be one of feature definitions'
        /// names.</p>
        /// <p>You use the <code>RecordIdentifierFeatureName</code> to access data in a
        /// <code>FeatureStore</code>.</p>
        /// <p>This name:</p>
        /// <ul>
        /// <li>
        /// <p>Must start and end with an alphanumeric character.</p>
        /// </li>
        /// <li>
        /// <p>Can only contains alphanumeric characters, hyphens, underscores. Spaces are not
        /// allowed. </p>
        /// </li>
        /// </ul>
        pub fn set_record_identifier_feature_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.record_identifier_feature_name = input;
            self
        }
        /// <p>The name of the feature that stores the <code>EventTime</code> of a <code>Record</code>
        /// in a <code>FeatureGroup</code>.</p>
        /// <p>An <code>EventTime</code> is a point in time when a new event occurs that corresponds to
        /// the creation or update of a <code>Record</code> in a <code>FeatureGroup</code>. All
        /// <code>Records</code> in the <code>FeatureGroup</code> must have a corresponding
        /// <code>EventTime</code>.</p>
        /// <p>An <code>EventTime</code> can be a <code>String</code> or <code>Fractional</code>. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Fractional</code>: <code>EventTime</code> feature values must be a Unix
        /// timestamp in seconds.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>String</code>: <code>EventTime</code> feature values must be an ISO-8601
        /// string in the format. The following formats are supported
        /// <code>yyyy-MM-dd'T'HH:mm:ssZ</code> and <code>yyyy-MM-dd'T'HH:mm:ss.SSSZ</code>
        /// where <code>yyyy</code>, <code>MM</code>, and <code>dd</code> represent the year,
        /// month, and day respectively and <code>HH</code>, <code>mm</code>, <code>ss</code>,
        /// and if applicable, <code>SSS</code> represent the hour, month, second and
        /// milliseconds respsectively. <code>'T'</code> and <code>Z</code> are constants.</p>
        /// </li>
        /// </ul>
        pub fn event_time_feature_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_time_feature_name = Some(input.into());
            self
        }
        /// <p>The name of the feature that stores the <code>EventTime</code> of a <code>Record</code>
        /// in a <code>FeatureGroup</code>.</p>
        /// <p>An <code>EventTime</code> is a point in time when a new event occurs that corresponds to
        /// the creation or update of a <code>Record</code> in a <code>FeatureGroup</code>. All
        /// <code>Records</code> in the <code>FeatureGroup</code> must have a corresponding
        /// <code>EventTime</code>.</p>
        /// <p>An <code>EventTime</code> can be a <code>String</code> or <code>Fractional</code>. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Fractional</code>: <code>EventTime</code> feature values must be a Unix
        /// timestamp in seconds.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>String</code>: <code>EventTime</code> feature values must be an ISO-8601
        /// string in the format. The following formats are supported
        /// <code>yyyy-MM-dd'T'HH:mm:ssZ</code> and <code>yyyy-MM-dd'T'HH:mm:ss.SSSZ</code>
        /// where <code>yyyy</code>, <code>MM</code>, and <code>dd</code> represent the year,
        /// month, and day respectively and <code>HH</code>, <code>mm</code>, <code>ss</code>,
        /// and if applicable, <code>SSS</code> represent the hour, month, second and
        /// milliseconds respsectively. <code>'T'</code> and <code>Z</code> are constants.</p>
        /// </li>
        /// </ul>
        pub fn set_event_time_feature_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_time_feature_name = input;
            self
        }
        /// Appends an item to `feature_definitions`.
        ///
        /// To override the contents of this collection use [`set_feature_definitions`](Self::set_feature_definitions).
        ///
        /// <p>A list of <code>Feature</code> names and types. <code>Name</code> and <code>Type</code>
        /// is compulsory per <code>Feature</code>. </p>
        /// <p>Valid feature <code>FeatureType</code>s are <code>Integral</code>,
        /// <code>Fractional</code> and <code>String</code>.</p>
        /// <p>
        /// <code>FeatureName</code>s cannot be any of the following: <code>is_deleted</code>,
        /// <code>write_time</code>, <code>api_invocation_time</code>
        /// </p>
        /// <p>You can create up to 2,500 <code>FeatureDefinition</code>s per
        /// <code>FeatureGroup</code>.</p>
        pub fn feature_definitions(
            mut self,
            input: impl Into<crate::model::FeatureDefinition>,
        ) -> Self {
            let mut v = self.feature_definitions.unwrap_or_default();
            v.push(input.into());
            self.feature_definitions = Some(v);
            self
        }
        /// <p>A list of <code>Feature</code> names and types. <code>Name</code> and <code>Type</code>
        /// is compulsory per <code>Feature</code>. </p>
        /// <p>Valid feature <code>FeatureType</code>s are <code>Integral</code>,
        /// <code>Fractional</code> and <code>String</code>.</p>
        /// <p>
        /// <code>FeatureName</code>s cannot be any of the following: <code>is_deleted</code>,
        /// <code>write_time</code>, <code>api_invocation_time</code>
        /// </p>
        /// <p>You can create up to 2,500 <code>FeatureDefinition</code>s per
        /// <code>FeatureGroup</code>.</p>
        pub fn set_feature_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FeatureDefinition>>,
        ) -> Self {
            self.feature_definitions = input;
            self
        }
        /// <p>You can turn the <code>OnlineStore</code> on or off by specifying <code>True</code> for
        /// the <code>EnableOnlineStore</code> flag in <code>OnlineStoreConfig</code>; the default
        /// value is <code>False</code>.</p>
        /// <p>You can also include an Amazon Web Services KMS key ID (<code>KMSKeyId</code>) for at-rest encryption of
        /// the <code>OnlineStore</code>.</p>
        pub fn online_store_config(mut self, input: crate::model::OnlineStoreConfig) -> Self {
            self.online_store_config = Some(input);
            self
        }
        /// <p>You can turn the <code>OnlineStore</code> on or off by specifying <code>True</code> for
        /// the <code>EnableOnlineStore</code> flag in <code>OnlineStoreConfig</code>; the default
        /// value is <code>False</code>.</p>
        /// <p>You can also include an Amazon Web Services KMS key ID (<code>KMSKeyId</code>) for at-rest encryption of
        /// the <code>OnlineStore</code>.</p>
        pub fn set_online_store_config(
            mut self,
            input: std::option::Option<crate::model::OnlineStoreConfig>,
        ) -> Self {
            self.online_store_config = input;
            self
        }
        /// <p>Use this to configure an <code>OfflineFeatureStore</code>. This parameter allows you to
        /// specify:</p>
        /// <ul>
        /// <li>
        /// <p>The Amazon Simple Storage Service (Amazon S3) location of an
        /// <code>OfflineStore</code>.</p>
        /// </li>
        /// <li>
        /// <p>A configuration for an Amazon Web Services Glue or Amazon Web Services Hive data catalog. </p>
        /// </li>
        /// <li>
        /// <p>An KMS encryption key to encrypt the Amazon S3 location used for
        /// <code>OfflineStore</code>. If KMS encryption key is not specified, by default we encrypt all data at rest using
        /// Amazon Web Services KMS key. By defining your <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-key.html">bucket-level key</a> for SSE,
        /// you can reduce Amazon Web Services KMS requests costs by up to 99 percent.</p>
        /// </li>
        /// </ul>
        /// <p>To learn more about this parameter, see <a>OfflineStoreConfig</a>.</p>
        pub fn offline_store_config(mut self, input: crate::model::OfflineStoreConfig) -> Self {
            self.offline_store_config = Some(input);
            self
        }
        /// <p>Use this to configure an <code>OfflineFeatureStore</code>. This parameter allows you to
        /// specify:</p>
        /// <ul>
        /// <li>
        /// <p>The Amazon Simple Storage Service (Amazon S3) location of an
        /// <code>OfflineStore</code>.</p>
        /// </li>
        /// <li>
        /// <p>A configuration for an Amazon Web Services Glue or Amazon Web Services Hive data catalog. </p>
        /// </li>
        /// <li>
        /// <p>An KMS encryption key to encrypt the Amazon S3 location used for
        /// <code>OfflineStore</code>. If KMS encryption key is not specified, by default we encrypt all data at rest using
        /// Amazon Web Services KMS key. By defining your <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-key.html">bucket-level key</a> for SSE,
        /// you can reduce Amazon Web Services KMS requests costs by up to 99 percent.</p>
        /// </li>
        /// </ul>
        /// <p>To learn more about this parameter, see <a>OfflineStoreConfig</a>.</p>
        pub fn set_offline_store_config(
            mut self,
            input: std::option::Option<crate::model::OfflineStoreConfig>,
        ) -> Self {
            self.offline_store_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the
        /// <code>OfflineStore</code> if an <code>OfflineStoreConfig</code> is provided.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the
        /// <code>OfflineStore</code> if an <code>OfflineStoreConfig</code> is provided.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>A free-form description of a <code>FeatureGroup</code>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A free-form description of a <code>FeatureGroup</code>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags used to identify <code>Features</code> in each <code>FeatureGroup</code>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Tags used to identify <code>Features</code> in each <code>FeatureGroup</code>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFeatureGroupInput`](crate::input::CreateFeatureGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFeatureGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFeatureGroupInput {
                feature_group_name: self.feature_group_name,
                record_identifier_feature_name: self.record_identifier_feature_name,
                event_time_feature_name: self.event_time_feature_name,
                feature_definitions: self.feature_definitions,
                online_store_config: self.online_store_config,
                offline_store_config: self.offline_store_config,
                role_arn: self.role_arn,
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFeatureGroupInputOperationOutputAlias = crate::operation::CreateFeatureGroup;
#[doc(hidden)]
pub type CreateFeatureGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateFeatureGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateFeatureGroup`](crate::operation::CreateFeatureGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFeatureGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateFeatureGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateFeatureGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateFeatureGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateFeatureGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_feature_group(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFeatureGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFeatureGroup",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateFeatureGroupInput`](crate::input::CreateFeatureGroupInput)
    pub fn builder() -> crate::input::create_feature_group_input::Builder {
        crate::input::create_feature_group_input::Builder::default()
    }
}

/// See [`CreateFlowDefinitionInput`](crate::input::CreateFlowDefinitionInput)
pub mod create_flow_definition_input {
    /// A builder for [`CreateFlowDefinitionInput`](crate::input::CreateFlowDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_definition_name: std::option::Option<std::string::String>,
        pub(crate) human_loop_request_source:
            std::option::Option<crate::model::HumanLoopRequestSource>,
        pub(crate) human_loop_activation_config:
            std::option::Option<crate::model::HumanLoopActivationConfig>,
        pub(crate) human_loop_config: std::option::Option<crate::model::HumanLoopConfig>,
        pub(crate) output_config: std::option::Option<crate::model::FlowDefinitionOutputConfig>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of your flow definition.</p>
        pub fn flow_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_definition_name = Some(input.into());
            self
        }
        /// <p>The name of your flow definition.</p>
        pub fn set_flow_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.flow_definition_name = input;
            self
        }
        /// <p>Container for configuring the source of human task requests. Use to specify if
        /// Amazon Rekognition or Amazon Textract is used as an integration source.</p>
        pub fn human_loop_request_source(
            mut self,
            input: crate::model::HumanLoopRequestSource,
        ) -> Self {
            self.human_loop_request_source = Some(input);
            self
        }
        /// <p>Container for configuring the source of human task requests. Use to specify if
        /// Amazon Rekognition or Amazon Textract is used as an integration source.</p>
        pub fn set_human_loop_request_source(
            mut self,
            input: std::option::Option<crate::model::HumanLoopRequestSource>,
        ) -> Self {
            self.human_loop_request_source = input;
            self
        }
        /// <p>An object containing information about the events that trigger a human workflow.</p>
        pub fn human_loop_activation_config(
            mut self,
            input: crate::model::HumanLoopActivationConfig,
        ) -> Self {
            self.human_loop_activation_config = Some(input);
            self
        }
        /// <p>An object containing information about the events that trigger a human workflow.</p>
        pub fn set_human_loop_activation_config(
            mut self,
            input: std::option::Option<crate::model::HumanLoopActivationConfig>,
        ) -> Self {
            self.human_loop_activation_config = input;
            self
        }
        /// <p>An object containing information about the tasks the human reviewers will perform.</p>
        pub fn human_loop_config(mut self, input: crate::model::HumanLoopConfig) -> Self {
            self.human_loop_config = Some(input);
            self
        }
        /// <p>An object containing information about the tasks the human reviewers will perform.</p>
        pub fn set_human_loop_config(
            mut self,
            input: std::option::Option<crate::model::HumanLoopConfig>,
        ) -> Self {
            self.human_loop_config = input;
            self
        }
        /// <p>An object containing information about where the human review results will be uploaded.</p>
        pub fn output_config(mut self, input: crate::model::FlowDefinitionOutputConfig) -> Self {
            self.output_config = Some(input);
            self
        }
        /// <p>An object containing information about where the human review results will be uploaded.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::FlowDefinitionOutputConfig>,
        ) -> Self {
            self.output_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role needed to call other services on your behalf. For example, <code>arn:aws:iam::1234567890:role/service-role/AmazonSageMaker-ExecutionRole-20180111T151298</code>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role needed to call other services on your behalf. For example, <code>arn:aws:iam::1234567890:role/service-role/AmazonSageMaker-ExecutionRole-20180111T151298</code>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs that contain metadata to help you categorize and organize a flow definition. Each tag consists of a key and a value, both of which you define.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>An array of key-value pairs that contain metadata to help you categorize and organize a flow definition. Each tag consists of a key and a value, both of which you define.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFlowDefinitionInput`](crate::input::CreateFlowDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFlowDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFlowDefinitionInput {
                flow_definition_name: self.flow_definition_name,
                human_loop_request_source: self.human_loop_request_source,
                human_loop_activation_config: self.human_loop_activation_config,
                human_loop_config: self.human_loop_config,
                output_config: self.output_config,
                role_arn: self.role_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFlowDefinitionInputOperationOutputAlias = crate::operation::CreateFlowDefinition;
#[doc(hidden)]
pub type CreateFlowDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateFlowDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`CreateFlowDefinition`](crate::operation::CreateFlowDefinition)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFlowDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateFlowDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateFlowDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateFlowDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateFlowDefinition",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_flow_definition(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFlowDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFlowDefinition",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateFlowDefinitionInput`](crate::input::CreateFlowDefinitionInput)
    pub fn builder() -> crate::input::create_flow_definition_input::Builder {
        crate::input::create_flow_definition_input::Builder::default()
    }
}

/// See [`CreateHumanTaskUiInput`](crate::input::CreateHumanTaskUiInput)
pub mod create_human_task_ui_input {
    /// A builder for [`CreateHumanTaskUiInput`](crate::input::CreateHumanTaskUiInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) human_task_ui_name: std::option::Option<std::string::String>,
        pub(crate) ui_template: std::option::Option<crate::model::UiTemplate>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the user interface you are creating.</p>
        pub fn human_task_ui_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.human_task_ui_name = Some(input.into());
            self
        }
        /// <p>The name of the user interface you are creating.</p>
        pub fn set_human_task_ui_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.human_task_ui_name = input;
            self
        }
        /// <p>The Liquid template for the worker user interface.</p>
        pub fn ui_template(mut self, input: crate::model::UiTemplate) -> Self {
            self.ui_template = Some(input);
            self
        }
        /// <p>The Liquid template for the worker user interface.</p>
        pub fn set_ui_template(
            mut self,
            input: std::option::Option<crate::model::UiTemplate>,
        ) -> Self {
            self.ui_template = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs that contain metadata to help you categorize and organize a human review workflow user interface. Each tag consists of a key and a value, both of which you define.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>An array of key-value pairs that contain metadata to help you categorize and organize a human review workflow user interface. Each tag consists of a key and a value, both of which you define.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateHumanTaskUiInput`](crate::input::CreateHumanTaskUiInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateHumanTaskUiInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateHumanTaskUiInput {
                human_task_ui_name: self.human_task_ui_name,
                ui_template: self.ui_template,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateHumanTaskUiInputOperationOutputAlias = crate::operation::CreateHumanTaskUi;
#[doc(hidden)]
pub type CreateHumanTaskUiInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateHumanTaskUiInput {
    /// Consumes the builder and constructs an Operation<[`CreateHumanTaskUi`](crate::operation::CreateHumanTaskUi)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateHumanTaskUi,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateHumanTaskUiInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateHumanTaskUiInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateHumanTaskUiInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateHumanTaskUi",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_human_task_ui(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateHumanTaskUi::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateHumanTaskUi",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateHumanTaskUiInput`](crate::input::CreateHumanTaskUiInput)
    pub fn builder() -> crate::input::create_human_task_ui_input::Builder {
        crate::input::create_human_task_ui_input::Builder::default()
    }
}

/// See [`CreateHyperParameterTuningJobInput`](crate::input::CreateHyperParameterTuningJobInput)
pub mod create_hyper_parameter_tuning_job_input {
    /// A builder for [`CreateHyperParameterTuningJobInput`](crate::input::CreateHyperParameterTuningJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hyper_parameter_tuning_job_name: std::option::Option<std::string::String>,
        pub(crate) hyper_parameter_tuning_job_config:
            std::option::Option<crate::model::HyperParameterTuningJobConfig>,
        pub(crate) training_job_definition:
            std::option::Option<crate::model::HyperParameterTrainingJobDefinition>,
        pub(crate) training_job_definitions:
            std::option::Option<std::vec::Vec<crate::model::HyperParameterTrainingJobDefinition>>,
        pub(crate) warm_start_config:
            std::option::Option<crate::model::HyperParameterTuningJobWarmStartConfig>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the tuning job. This name is the prefix for the names of all training jobs
        /// that this tuning job launches. The name must be unique within the same Amazon Web Services account and
        /// Amazon Web Services Region. The name must have 1 to 32 characters. Valid characters are a-z, A-Z, 0-9,
        /// and : + = @ _ % - (hyphen). The name is not case sensitive.</p>
        pub fn hyper_parameter_tuning_job_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.hyper_parameter_tuning_job_name = Some(input.into());
            self
        }
        /// <p>The name of the tuning job. This name is the prefix for the names of all training jobs
        /// that this tuning job launches. The name must be unique within the same Amazon Web Services account and
        /// Amazon Web Services Region. The name must have 1 to 32 characters. Valid characters are a-z, A-Z, 0-9,
        /// and : + = @ _ % - (hyphen). The name is not case sensitive.</p>
        pub fn set_hyper_parameter_tuning_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hyper_parameter_tuning_job_name = input;
            self
        }
        /// <p>The <a>HyperParameterTuningJobConfig</a> object that describes the tuning
        /// job, including the search strategy, the objective metric used to evaluate training jobs,
        /// ranges of parameters to search, and resource limits for the tuning job. For more
        /// information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How
        /// Hyperparameter Tuning Works</a>.</p>
        pub fn hyper_parameter_tuning_job_config(
            mut self,
            input: crate::model::HyperParameterTuningJobConfig,
        ) -> Self {
            self.hyper_parameter_tuning_job_config = Some(input);
            self
        }
        /// <p>The <a>HyperParameterTuningJobConfig</a> object that describes the tuning
        /// job, including the search strategy, the objective metric used to evaluate training jobs,
        /// ranges of parameters to search, and resource limits for the tuning job. For more
        /// information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How
        /// Hyperparameter Tuning Works</a>.</p>
        pub fn set_hyper_parameter_tuning_job_config(
            mut self,
            input: std::option::Option<crate::model::HyperParameterTuningJobConfig>,
        ) -> Self {
            self.hyper_parameter_tuning_job_config = input;
            self
        }
        /// <p>The <a>HyperParameterTrainingJobDefinition</a> object that describes the
        /// training jobs that this tuning job launches,
        /// including
        /// static hyperparameters, input data configuration, output data configuration, resource
        /// configuration, and stopping condition.</p>
        pub fn training_job_definition(
            mut self,
            input: crate::model::HyperParameterTrainingJobDefinition,
        ) -> Self {
            self.training_job_definition = Some(input);
            self
        }
        /// <p>The <a>HyperParameterTrainingJobDefinition</a> object that describes the
        /// training jobs that this tuning job launches,
        /// including
        /// static hyperparameters, input data configuration, output data configuration, resource
        /// configuration, and stopping condition.</p>
        pub fn set_training_job_definition(
            mut self,
            input: std::option::Option<crate::model::HyperParameterTrainingJobDefinition>,
        ) -> Self {
            self.training_job_definition = input;
            self
        }
        /// Appends an item to `training_job_definitions`.
        ///
        /// To override the contents of this collection use [`set_training_job_definitions`](Self::set_training_job_definitions).
        ///
        /// <p>A list of the <a>HyperParameterTrainingJobDefinition</a> objects launched
        /// for this tuning job.</p>
        pub fn training_job_definitions(
            mut self,
            input: impl Into<crate::model::HyperParameterTrainingJobDefinition>,
        ) -> Self {
            let mut v = self.training_job_definitions.unwrap_or_default();
            v.push(input.into());
            self.training_job_definitions = Some(v);
            self
        }
        /// <p>A list of the <a>HyperParameterTrainingJobDefinition</a> objects launched
        /// for this tuning job.</p>
        pub fn set_training_job_definitions(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::HyperParameterTrainingJobDefinition>,
            >,
        ) -> Self {
            self.training_job_definitions = input;
            self
        }
        /// <p>Specifies the configuration for starting the hyperparameter tuning job using one or
        /// more previous tuning jobs as a starting point. The results of previous tuning jobs are
        /// used to inform which combinations of hyperparameters to search over in the new tuning
        /// job.</p>
        /// <p>All training jobs launched by the new hyperparameter tuning job are evaluated by using
        /// the objective metric. If you specify <code>IDENTICAL_DATA_AND_ALGORITHM</code> as the
        /// <code>WarmStartType</code> value for the warm start configuration, the training job
        /// that performs the best in the new tuning job is compared to the best training jobs from
        /// the parent tuning jobs. From these, the training job that performs the best as measured
        /// by the objective metric is returned as the overall best training job.</p>
        /// <note>
        /// <p>All training jobs launched by parent hyperparameter tuning jobs and the new
        /// hyperparameter tuning jobs count against the limit of training jobs for the tuning
        /// job.</p>
        /// </note>
        pub fn warm_start_config(
            mut self,
            input: crate::model::HyperParameterTuningJobWarmStartConfig,
        ) -> Self {
            self.warm_start_config = Some(input);
            self
        }
        /// <p>Specifies the configuration for starting the hyperparameter tuning job using one or
        /// more previous tuning jobs as a starting point. The results of previous tuning jobs are
        /// used to inform which combinations of hyperparameters to search over in the new tuning
        /// job.</p>
        /// <p>All training jobs launched by the new hyperparameter tuning job are evaluated by using
        /// the objective metric. If you specify <code>IDENTICAL_DATA_AND_ALGORITHM</code> as the
        /// <code>WarmStartType</code> value for the warm start configuration, the training job
        /// that performs the best in the new tuning job is compared to the best training jobs from
        /// the parent tuning jobs. From these, the training job that performs the best as measured
        /// by the objective metric is returned as the overall best training job.</p>
        /// <note>
        /// <p>All training jobs launched by parent hyperparameter tuning jobs and the new
        /// hyperparameter tuning jobs count against the limit of training jobs for the tuning
        /// job.</p>
        /// </note>
        pub fn set_warm_start_config(
            mut self,
            input: std::option::Option<crate::model::HyperParameterTuningJobWarmStartConfig>,
        ) -> Self {
            self.warm_start_config = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
        /// different ways, for example, by purpose, owner, or environment. For more information,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// Resources</a>.</p>
        /// <p>Tags that you specify for the tuning job are also added to all training jobs that the
        /// tuning job launches.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
        /// different ways, for example, by purpose, owner, or environment. For more information,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// Resources</a>.</p>
        /// <p>Tags that you specify for the tuning job are also added to all training jobs that the
        /// tuning job launches.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateHyperParameterTuningJobInput`](crate::input::CreateHyperParameterTuningJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateHyperParameterTuningJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateHyperParameterTuningJobInput {
                hyper_parameter_tuning_job_name: self.hyper_parameter_tuning_job_name,
                hyper_parameter_tuning_job_config: self.hyper_parameter_tuning_job_config,
                training_job_definition: self.training_job_definition,
                training_job_definitions: self.training_job_definitions,
                warm_start_config: self.warm_start_config,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateHyperParameterTuningJobInputOperationOutputAlias =
    crate::operation::CreateHyperParameterTuningJob;
#[doc(hidden)]
pub type CreateHyperParameterTuningJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateHyperParameterTuningJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateHyperParameterTuningJob`](crate::operation::CreateHyperParameterTuningJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateHyperParameterTuningJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateHyperParameterTuningJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateHyperParameterTuningJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateHyperParameterTuningJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateHyperParameterTuningJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_hyper_parameter_tuning_job(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateHyperParameterTuningJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateHyperParameterTuningJob",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateHyperParameterTuningJobInput`](crate::input::CreateHyperParameterTuningJobInput)
    pub fn builder() -> crate::input::create_hyper_parameter_tuning_job_input::Builder {
        crate::input::create_hyper_parameter_tuning_job_input::Builder::default()
    }
}

/// See [`CreateImageInput`](crate::input::CreateImageInput)
pub mod create_image_input {
    /// A builder for [`CreateImageInput`](crate::input::CreateImageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) image_name: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The description of the image.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the image.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The display name of the image. If not provided, <code>ImageName</code> is displayed.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The display name of the image. If not provided, <code>ImageName</code> is displayed.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The name of the image. Must be unique to your account.</p>
        pub fn image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_name = Some(input.into());
            self
        }
        /// <p>The name of the image. Must be unique to your account.</p>
        pub fn set_image_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to apply to the image.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to apply to the image.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateImageInput`](crate::input::CreateImageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateImageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateImageInput {
                description: self.description,
                display_name: self.display_name,
                image_name: self.image_name,
                role_arn: self.role_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateImageInputOperationOutputAlias = crate::operation::CreateImage;
#[doc(hidden)]
pub type CreateImageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateImageInput {
    /// Consumes the builder and constructs an Operation<[`CreateImage`](crate::operation::CreateImage)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateImage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateImageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateImageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateImageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateImage",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_image(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateImage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateImage",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateImageInput`](crate::input::CreateImageInput)
    pub fn builder() -> crate::input::create_image_input::Builder {
        crate::input::create_image_input::Builder::default()
    }
}

/// See [`CreateImageVersionInput`](crate::input::CreateImageVersionInput)
pub mod create_image_version_input {
    /// A builder for [`CreateImageVersionInput`](crate::input::CreateImageVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) base_image: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) image_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The registry path of the container image to use as the starting point for this
        /// version. The path is an Amazon Container Registry (ECR) URI in the following format:</p>
        /// <p>
        /// <code><acct-id>.dkr.ecr.<region>.amazonaws.com/<repo-name[:tag] or [@digest]></code>
        /// </p>
        pub fn base_image(mut self, input: impl Into<std::string::String>) -> Self {
            self.base_image = Some(input.into());
            self
        }
        /// <p>The registry path of the container image to use as the starting point for this
        /// version. The path is an Amazon Container Registry (ECR) URI in the following format:</p>
        /// <p>
        /// <code><acct-id>.dkr.ecr.<region>.amazonaws.com/<repo-name[:tag] or [@digest]></code>
        /// </p>
        pub fn set_base_image(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.base_image = input;
            self
        }
        /// <p>A unique ID. If not specified, the Amazon Web Services CLI and Amazon Web Services SDKs, such as the SDK for Python
        /// (Boto3), add a unique value to the call.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique ID. If not specified, the Amazon Web Services CLI and Amazon Web Services SDKs, such as the SDK for Python
        /// (Boto3), add a unique value to the call.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The <code>ImageName</code> of the <code>Image</code> to create a version of.</p>
        pub fn image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_name = Some(input.into());
            self
        }
        /// <p>The <code>ImageName</code> of the <code>Image</code> to create a version of.</p>
        pub fn set_image_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateImageVersionInput`](crate::input::CreateImageVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateImageVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateImageVersionInput {
                base_image: self.base_image,
                client_token: self.client_token,
                image_name: self.image_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateImageVersionInputOperationOutputAlias = crate::operation::CreateImageVersion;
#[doc(hidden)]
pub type CreateImageVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateImageVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateImageVersion`](crate::operation::CreateImageVersion)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateImageVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateImageVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateImageVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateImageVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateImageVersion",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_image_version(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateImageVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateImageVersion",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateImageVersionInput`](crate::input::CreateImageVersionInput)
    pub fn builder() -> crate::input::create_image_version_input::Builder {
        crate::input::create_image_version_input::Builder::default()
    }
}

/// See [`CreateLabelingJobInput`](crate::input::CreateLabelingJobInput)
pub mod create_labeling_job_input {
    /// A builder for [`CreateLabelingJobInput`](crate::input::CreateLabelingJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) labeling_job_name: std::option::Option<std::string::String>,
        pub(crate) label_attribute_name: std::option::Option<std::string::String>,
        pub(crate) input_config: std::option::Option<crate::model::LabelingJobInputConfig>,
        pub(crate) output_config: std::option::Option<crate::model::LabelingJobOutputConfig>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) label_category_config_s3_uri: std::option::Option<std::string::String>,
        pub(crate) stopping_conditions:
            std::option::Option<crate::model::LabelingJobStoppingConditions>,
        pub(crate) labeling_job_algorithms_config:
            std::option::Option<crate::model::LabelingJobAlgorithmsConfig>,
        pub(crate) human_task_config: std::option::Option<crate::model::HumanTaskConfig>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the labeling job. This name is used to identify the job in a list of
        /// labeling jobs. Labeling job names must be unique within an Amazon Web Services account and region.
        /// <code>LabelingJobName</code> is not case sensitive. For example, Example-job and
        /// example-job are considered the same labeling job name by Ground Truth.</p>
        pub fn labeling_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.labeling_job_name = Some(input.into());
            self
        }
        /// <p>The name of the labeling job. This name is used to identify the job in a list of
        /// labeling jobs. Labeling job names must be unique within an Amazon Web Services account and region.
        /// <code>LabelingJobName</code> is not case sensitive. For example, Example-job and
        /// example-job are considered the same labeling job name by Ground Truth.</p>
        pub fn set_labeling_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.labeling_job_name = input;
            self
        }
        /// <p>The attribute name to use for the label in the output manifest file. This is the key
        /// for the key/value pair formed with the label that a worker assigns to the object. The
        /// <code>LabelAttributeName</code> must meet the following requirements.</p>
        /// <ul>
        /// <li>
        /// <p>The name can't end with "-metadata". </p>
        /// </li>
        /// <li>
        /// <p>If you are using one of the following <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types</a>,
        /// the attribute name <i>must</i> end with "-ref". If the task type
        /// you are using is not listed below, the attribute name <i>must
        /// not</i> end with "-ref".</p>
        /// <ul>
        /// <li>
        /// <p>Image semantic segmentation (<code>SemanticSegmentation)</code>, and
        /// adjustment (<code>AdjustmentSemanticSegmentation</code>) and
        /// verification (<code>VerificationSemanticSegmentation</code>) labeling
        /// jobs for this task type.</p>
        /// </li>
        /// <li>
        /// <p>Video frame object detection (<code>VideoObjectDetection</code>), and
        /// adjustment and verification
        /// (<code>AdjustmentVideoObjectDetection</code>) labeling jobs for this
        /// task type.</p>
        /// </li>
        /// <li>
        /// <p>Video frame object tracking (<code>VideoObjectTracking</code>), and
        /// adjustment and verification (<code>AdjustmentVideoObjectTracking</code>)
        /// labeling jobs for this task type.</p>
        /// </li>
        /// <li>
        /// <p>3D point cloud semantic segmentation
        /// (<code>3DPointCloudSemanticSegmentation</code>), and adjustment and
        /// verification (<code>Adjustment3DPointCloudSemanticSegmentation</code>)
        /// labeling jobs for this task type. </p>
        /// </li>
        /// <li>
        /// <p>3D point cloud object tracking
        /// (<code>3DPointCloudObjectTracking</code>), and adjustment and
        /// verification (<code>Adjustment3DPointCloudObjectTracking</code>)
        /// labeling jobs for this task type. </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// <p></p>
        /// <important>
        /// <p>If you are creating an adjustment or verification labeling job, you must use a
        /// <i>different</i>
        /// <code>LabelAttributeName</code> than the one used in the original labeling job. The
        /// original labeling job is the Ground Truth labeling job that produced the labels that you
        /// want verified or adjusted. To learn more about adjustment and verification labeling
        /// jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html">Verify and Adjust
        /// Labels</a>.</p>
        /// </important>
        pub fn label_attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.label_attribute_name = Some(input.into());
            self
        }
        /// <p>The attribute name to use for the label in the output manifest file. This is the key
        /// for the key/value pair formed with the label that a worker assigns to the object. The
        /// <code>LabelAttributeName</code> must meet the following requirements.</p>
        /// <ul>
        /// <li>
        /// <p>The name can't end with "-metadata". </p>
        /// </li>
        /// <li>
        /// <p>If you are using one of the following <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types</a>,
        /// the attribute name <i>must</i> end with "-ref". If the task type
        /// you are using is not listed below, the attribute name <i>must
        /// not</i> end with "-ref".</p>
        /// <ul>
        /// <li>
        /// <p>Image semantic segmentation (<code>SemanticSegmentation)</code>, and
        /// adjustment (<code>AdjustmentSemanticSegmentation</code>) and
        /// verification (<code>VerificationSemanticSegmentation</code>) labeling
        /// jobs for this task type.</p>
        /// </li>
        /// <li>
        /// <p>Video frame object detection (<code>VideoObjectDetection</code>), and
        /// adjustment and verification
        /// (<code>AdjustmentVideoObjectDetection</code>) labeling jobs for this
        /// task type.</p>
        /// </li>
        /// <li>
        /// <p>Video frame object tracking (<code>VideoObjectTracking</code>), and
        /// adjustment and verification (<code>AdjustmentVideoObjectTracking</code>)
        /// labeling jobs for this task type.</p>
        /// </li>
        /// <li>
        /// <p>3D point cloud semantic segmentation
        /// (<code>3DPointCloudSemanticSegmentation</code>), and adjustment and
        /// verification (<code>Adjustment3DPointCloudSemanticSegmentation</code>)
        /// labeling jobs for this task type. </p>
        /// </li>
        /// <li>
        /// <p>3D point cloud object tracking
        /// (<code>3DPointCloudObjectTracking</code>), and adjustment and
        /// verification (<code>Adjustment3DPointCloudObjectTracking</code>)
        /// labeling jobs for this task type. </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// <p></p>
        /// <important>
        /// <p>If you are creating an adjustment or verification labeling job, you must use a
        /// <i>different</i>
        /// <code>LabelAttributeName</code> than the one used in the original labeling job. The
        /// original labeling job is the Ground Truth labeling job that produced the labels that you
        /// want verified or adjusted. To learn more about adjustment and verification labeling
        /// jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html">Verify and Adjust
        /// Labels</a>.</p>
        /// </important>
        pub fn set_label_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.label_attribute_name = input;
            self
        }
        /// <p>Input data for the labeling job, such as the Amazon S3 location of the data objects and the
        /// location of the manifest file that describes the data objects.</p>
        /// <p>You must specify at least one of the following: <code>S3DataSource</code> or
        /// <code>SnsDataSource</code>. </p>
        /// <ul>
        /// <li>
        /// <p>Use <code>SnsDataSource</code> to specify an SNS input topic for a streaming
        /// labeling job. If you do not specify and SNS input topic ARN, Ground Truth will
        /// create a one-time labeling job that stops after all data objects in the input
        /// manifest file have been labeled.</p>
        /// </li>
        /// <li>
        /// <p>Use <code>S3DataSource</code> to specify an input manifest file for both
        /// streaming and one-time labeling jobs. Adding an <code>S3DataSource</code> is
        /// optional if you use <code>SnsDataSource</code> to create a streaming labeling
        /// job.</p>
        /// </li>
        /// </ul>
        /// <p>If you use the Amazon Mechanical Turk workforce, your input data should not include
        /// confidential information, personal information or protected health information. Use
        /// <code>ContentClassifiers</code> to specify that your data is free of personally
        /// identifiable information and adult content.</p>
        pub fn input_config(mut self, input: crate::model::LabelingJobInputConfig) -> Self {
            self.input_config = Some(input);
            self
        }
        /// <p>Input data for the labeling job, such as the Amazon S3 location of the data objects and the
        /// location of the manifest file that describes the data objects.</p>
        /// <p>You must specify at least one of the following: <code>S3DataSource</code> or
        /// <code>SnsDataSource</code>. </p>
        /// <ul>
        /// <li>
        /// <p>Use <code>SnsDataSource</code> to specify an SNS input topic for a streaming
        /// labeling job. If you do not specify and SNS input topic ARN, Ground Truth will
        /// create a one-time labeling job that stops after all data objects in the input
        /// manifest file have been labeled.</p>
        /// </li>
        /// <li>
        /// <p>Use <code>S3DataSource</code> to specify an input manifest file for both
        /// streaming and one-time labeling jobs. Adding an <code>S3DataSource</code> is
        /// optional if you use <code>SnsDataSource</code> to create a streaming labeling
        /// job.</p>
        /// </li>
        /// </ul>
        /// <p>If you use the Amazon Mechanical Turk workforce, your input data should not include
        /// confidential information, personal information or protected health information. Use
        /// <code>ContentClassifiers</code> to specify that your data is free of personally
        /// identifiable information and adult content.</p>
        pub fn set_input_config(
            mut self,
            input: std::option::Option<crate::model::LabelingJobInputConfig>,
        ) -> Self {
            self.input_config = input;
            self
        }
        /// <p>The location of the output data and the Amazon Web Services Key Management Service key ID for the key used to encrypt
        /// the output data, if any.</p>
        pub fn output_config(mut self, input: crate::model::LabelingJobOutputConfig) -> Self {
            self.output_config = Some(input);
            self
        }
        /// <p>The location of the output data and the Amazon Web Services Key Management Service key ID for the key used to encrypt
        /// the output data, if any.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::LabelingJobOutputConfig>,
        ) -> Self {
            self.output_config = input;
            self
        }
        /// <p>The Amazon Resource Number (ARN) that Amazon SageMaker assumes to perform tasks on your behalf
        /// during data labeling. You must grant this role the necessary permissions so that Amazon SageMaker
        /// can successfully complete data labeling.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Number (ARN) that Amazon SageMaker assumes to perform tasks on your behalf
        /// during data labeling. You must grant this role the necessary permissions so that Amazon SageMaker
        /// can successfully complete data labeling.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The S3 URI of the file, referred to as a <i>label category configuration
        /// file</i>, that defines the categories used to label the data objects.</p>
        /// <p>For 3D point cloud and video frame task types, you can add label category attributes
        /// and frame attributes to your label category configuration file. To learn how, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud-label-category-config.html">Create a
        /// Labeling Category Configuration File for 3D Point Cloud Labeling Jobs</a>. </p>
        /// <p>For named entity recognition jobs, in addition to <code>"labels"</code>, you must
        /// provide worker instructions in the label category configuration file using the
        /// <code>"instructions"</code> parameter: <code>"instructions":
        /// {"shortInstruction":"<h1>Add header</h1><p>Add Instructions</p>",
        /// "fullInstruction":"<p>Add additional instructions.</p>"}</code>. For details
        /// and an example, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-named-entity-recg.html#sms-creating-ner-api">Create a
        /// Named Entity Recognition Labeling Job (API) </a>.</p>
        /// <p>For all other <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates.html">custom
        /// tasks</a>, your label category configuration file must be a JSON file in the
        /// following format. Identify the labels you want to use by replacing <code>label_1</code>,
        /// <code>label_2</code>,<code>...</code>,<code>label_n</code> with your label
        /// categories.</p>
        /// <p>
        /// <code>{ </code>
        /// </p>
        /// <p>
        /// <code>"document-version": "2018-11-28",</code>
        /// </p>
        /// <p>
        /// <code>"labels": [{"label": "label_1"},{"label": "label_2"},...{"label":
        /// "label_n"}]</code>
        /// </p>
        /// <p>
        /// <code>}</code>
        /// </p>
        /// <p>Note the following about the label category configuration file:</p>
        /// <ul>
        /// <li>
        /// <p>For image classification and text classification (single and multi-label) you
        /// must specify at least two label categories. For all other task types, the
        /// minimum number of label categories required is one. </p>
        /// </li>
        /// <li>
        /// <p>Each label category must be unique, you cannot specify duplicate label
        /// categories.</p>
        /// </li>
        /// <li>
        /// <p>If you create a 3D point cloud or video frame adjustment or verification
        /// labeling job, you must include <code>auditLabelAttributeName</code> in the label
        /// category configuration. Use this parameter to enter the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateLabelingJob.html#sagemaker-CreateLabelingJob-request-LabelAttributeName">
        /// <code>LabelAttributeName</code>
        /// </a> of the labeling job you want to
        /// adjust or verify annotations of.</p>
        /// </li>
        /// </ul>
        pub fn label_category_config_s3_uri(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.label_category_config_s3_uri = Some(input.into());
            self
        }
        /// <p>The S3 URI of the file, referred to as a <i>label category configuration
        /// file</i>, that defines the categories used to label the data objects.</p>
        /// <p>For 3D point cloud and video frame task types, you can add label category attributes
        /// and frame attributes to your label category configuration file. To learn how, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud-label-category-config.html">Create a
        /// Labeling Category Configuration File for 3D Point Cloud Labeling Jobs</a>. </p>
        /// <p>For named entity recognition jobs, in addition to <code>"labels"</code>, you must
        /// provide worker instructions in the label category configuration file using the
        /// <code>"instructions"</code> parameter: <code>"instructions":
        /// {"shortInstruction":"<h1>Add header</h1><p>Add Instructions</p>",
        /// "fullInstruction":"<p>Add additional instructions.</p>"}</code>. For details
        /// and an example, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-named-entity-recg.html#sms-creating-ner-api">Create a
        /// Named Entity Recognition Labeling Job (API) </a>.</p>
        /// <p>For all other <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates.html">custom
        /// tasks</a>, your label category configuration file must be a JSON file in the
        /// following format. Identify the labels you want to use by replacing <code>label_1</code>,
        /// <code>label_2</code>,<code>...</code>,<code>label_n</code> with your label
        /// categories.</p>
        /// <p>
        /// <code>{ </code>
        /// </p>
        /// <p>
        /// <code>"document-version": "2018-11-28",</code>
        /// </p>
        /// <p>
        /// <code>"labels": [{"label": "label_1"},{"label": "label_2"},...{"label":
        /// "label_n"}]</code>
        /// </p>
        /// <p>
        /// <code>}</code>
        /// </p>
        /// <p>Note the following about the label category configuration file:</p>
        /// <ul>
        /// <li>
        /// <p>For image classification and text classification (single and multi-label) you
        /// must specify at least two label categories. For all other task types, the
        /// minimum number of label categories required is one. </p>
        /// </li>
        /// <li>
        /// <p>Each label category must be unique, you cannot specify duplicate label
        /// categories.</p>
        /// </li>
        /// <li>
        /// <p>If you create a 3D point cloud or video frame adjustment or verification
        /// labeling job, you must include <code>auditLabelAttributeName</code> in the label
        /// category configuration. Use this parameter to enter the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateLabelingJob.html#sagemaker-CreateLabelingJob-request-LabelAttributeName">
        /// <code>LabelAttributeName</code>
        /// </a> of the labeling job you want to
        /// adjust or verify annotations of.</p>
        /// </li>
        /// </ul>
        pub fn set_label_category_config_s3_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.label_category_config_s3_uri = input;
            self
        }
        /// <p>A set of conditions for stopping the labeling job. If any of the conditions are met,
        /// the job is automatically stopped. You can use these conditions to control the cost of
        /// data labeling.</p>
        pub fn stopping_conditions(
            mut self,
            input: crate::model::LabelingJobStoppingConditions,
        ) -> Self {
            self.stopping_conditions = Some(input);
            self
        }
        /// <p>A set of conditions for stopping the labeling job. If any of the conditions are met,
        /// the job is automatically stopped. You can use these conditions to control the cost of
        /// data labeling.</p>
        pub fn set_stopping_conditions(
            mut self,
            input: std::option::Option<crate::model::LabelingJobStoppingConditions>,
        ) -> Self {
            self.stopping_conditions = input;
            self
        }
        /// <p>Configures the information required to perform automated data labeling.</p>
        pub fn labeling_job_algorithms_config(
            mut self,
            input: crate::model::LabelingJobAlgorithmsConfig,
        ) -> Self {
            self.labeling_job_algorithms_config = Some(input);
            self
        }
        /// <p>Configures the information required to perform automated data labeling.</p>
        pub fn set_labeling_job_algorithms_config(
            mut self,
            input: std::option::Option<crate::model::LabelingJobAlgorithmsConfig>,
        ) -> Self {
            self.labeling_job_algorithms_config = input;
            self
        }
        /// <p>Configures the labeling task and how it is presented to workers; including, but not limited to price, keywords, and batch size (task count).</p>
        pub fn human_task_config(mut self, input: crate::model::HumanTaskConfig) -> Self {
            self.human_task_config = Some(input);
            self
        }
        /// <p>Configures the labeling task and how it is presented to workers; including, but not limited to price, keywords, and batch size (task count).</p>
        pub fn set_human_task_config(
            mut self,
            input: std::option::Option<crate::model::HumanTaskConfig>,
        ) -> Self {
            self.human_task_config = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key/value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management
        /// User Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>An array of key/value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management
        /// User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLabelingJobInput`](crate::input::CreateLabelingJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLabelingJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLabelingJobInput {
                labeling_job_name: self.labeling_job_name,
                label_attribute_name: self.label_attribute_name,
                input_config: self.input_config,
                output_config: self.output_config,
                role_arn: self.role_arn,
                label_category_config_s3_uri: self.label_category_config_s3_uri,
                stopping_conditions: self.stopping_conditions,
                labeling_job_algorithms_config: self.labeling_job_algorithms_config,
                human_task_config: self.human_task_config,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLabelingJobInputOperationOutputAlias = crate::operation::CreateLabelingJob;
#[doc(hidden)]
pub type CreateLabelingJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateLabelingJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateLabelingJob`](crate::operation::CreateLabelingJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLabelingJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateLabelingJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateLabelingJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateLabelingJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateLabelingJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_labeling_job(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLabelingJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLabelingJob",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateLabelingJobInput`](crate::input::CreateLabelingJobInput)
    pub fn builder() -> crate::input::create_labeling_job_input::Builder {
        crate::input::create_labeling_job_input::Builder::default()
    }
}

/// See [`CreateModelInput`](crate::input::CreateModelInput)
pub mod create_model_input {
    /// A builder for [`CreateModelInput`](crate::input::CreateModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_name: std::option::Option<std::string::String>,
        pub(crate) primary_container: std::option::Option<crate::model::ContainerDefinition>,
        pub(crate) containers:
            std::option::Option<std::vec::Vec<crate::model::ContainerDefinition>>,
        pub(crate) inference_execution_config:
            std::option::Option<crate::model::InferenceExecutionConfig>,
        pub(crate) execution_role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
        pub(crate) enable_network_isolation: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the new model.</p>
        pub fn model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_name = Some(input.into());
            self
        }
        /// <p>The name of the new model.</p>
        pub fn set_model_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_name = input;
            self
        }
        /// <p>The location of the primary docker image containing inference code, associated
        /// artifacts, and custom environment map that the inference code uses when the model is
        /// deployed for predictions. </p>
        pub fn primary_container(mut self, input: crate::model::ContainerDefinition) -> Self {
            self.primary_container = Some(input);
            self
        }
        /// <p>The location of the primary docker image containing inference code, associated
        /// artifacts, and custom environment map that the inference code uses when the model is
        /// deployed for predictions. </p>
        pub fn set_primary_container(
            mut self,
            input: std::option::Option<crate::model::ContainerDefinition>,
        ) -> Self {
            self.primary_container = input;
            self
        }
        /// Appends an item to `containers`.
        ///
        /// To override the contents of this collection use [`set_containers`](Self::set_containers).
        ///
        /// <p>Specifies the containers in the inference pipeline.</p>
        pub fn containers(mut self, input: impl Into<crate::model::ContainerDefinition>) -> Self {
            let mut v = self.containers.unwrap_or_default();
            v.push(input.into());
            self.containers = Some(v);
            self
        }
        /// <p>Specifies the containers in the inference pipeline.</p>
        pub fn set_containers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContainerDefinition>>,
        ) -> Self {
            self.containers = input;
            self
        }
        /// <p>Specifies details of how containers in a multi-container endpoint are called.</p>
        pub fn inference_execution_config(
            mut self,
            input: crate::model::InferenceExecutionConfig,
        ) -> Self {
            self.inference_execution_config = Some(input);
            self
        }
        /// <p>Specifies details of how containers in a multi-container endpoint are called.</p>
        pub fn set_inference_execution_config(
            mut self,
            input: std::option::Option<crate::model::InferenceExecutionConfig>,
        ) -> Self {
            self.inference_execution_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker can assume to access model
        /// artifacts and docker image for deployment on ML compute instances or for batch transform
        /// jobs. Deploying on ML compute instances is part of model hosting. For more information,
        /// see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker
        /// Roles</a>. </p>
        /// <note>
        /// <p>To be able to pass this role to Amazon SageMaker, the caller of this API must have the
        /// <code>iam:PassRole</code> permission.</p>
        /// </note>
        pub fn execution_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker can assume to access model
        /// artifacts and docker image for deployment on ML compute instances or for batch transform
        /// jobs. Deploying on ML compute instances is part of model hosting. For more information,
        /// see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker
        /// Roles</a>. </p>
        /// <note>
        /// <p>To be able to pass this role to Amazon SageMaker, the caller of this API must have the
        /// <code>iam:PassRole</code> permission.</p>
        /// </note>
        pub fn set_execution_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.execution_role_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
        /// different ways, for example, by purpose, owner, or environment. For more information,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// Resources</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
        /// different ways, for example, by purpose, owner, or environment. For more information,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// Resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A <a>VpcConfig</a> object that specifies the VPC that you want your model
        /// to connect to. Control access to and from your model container by configuring the VPC.
        /// <code>VpcConfig</code> is used in hosting services and in batch transform. For more
        /// information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html">Protect Endpoints by Using an Amazon Virtual Private Cloud</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-vpc.html">Protect Data in Batch
        /// Transform Jobs by Using an Amazon Virtual Private Cloud</a>.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>A <a>VpcConfig</a> object that specifies the VPC that you want your model
        /// to connect to. Control access to and from your model container by configuring the VPC.
        /// <code>VpcConfig</code> is used in hosting services and in batch transform. For more
        /// information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html">Protect Endpoints by Using an Amazon Virtual Private Cloud</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-vpc.html">Protect Data in Batch
        /// Transform Jobs by Using an Amazon Virtual Private Cloud</a>.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>Isolates the model container. No inbound or outbound network calls can be made to or
        /// from the model container.</p>
        pub fn enable_network_isolation(mut self, input: bool) -> Self {
            self.enable_network_isolation = Some(input);
            self
        }
        /// <p>Isolates the model container. No inbound or outbound network calls can be made to or
        /// from the model container.</p>
        pub fn set_enable_network_isolation(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_network_isolation = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateModelInput`](crate::input::CreateModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateModelInput {
                model_name: self.model_name,
                primary_container: self.primary_container,
                containers: self.containers,
                inference_execution_config: self.inference_execution_config,
                execution_role_arn: self.execution_role_arn,
                tags: self.tags,
                vpc_config: self.vpc_config,
                enable_network_isolation: self.enable_network_isolation.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type CreateModelInputOperationOutputAlias = crate::operation::CreateModel;
#[doc(hidden)]
pub type CreateModelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateModelInput {
    /// Consumes the builder and constructs an Operation<[`CreateModel`](crate::operation::CreateModel)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateModel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateModelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateModelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateModelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateModel",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_model(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateModel",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateModelInput`](crate::input::CreateModelInput)
    pub fn builder() -> crate::input::create_model_input::Builder {
        crate::input::create_model_input::Builder::default()
    }
}

/// See [`CreateModelBiasJobDefinitionInput`](crate::input::CreateModelBiasJobDefinitionInput)
pub mod create_model_bias_job_definition_input {
    /// A builder for [`CreateModelBiasJobDefinitionInput`](crate::input::CreateModelBiasJobDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_definition_name: std::option::Option<std::string::String>,
        pub(crate) model_bias_baseline_config:
            std::option::Option<crate::model::ModelBiasBaselineConfig>,
        pub(crate) model_bias_app_specification:
            std::option::Option<crate::model::ModelBiasAppSpecification>,
        pub(crate) model_bias_job_input: std::option::Option<crate::model::ModelBiasJobInput>,
        pub(crate) model_bias_job_output_config:
            std::option::Option<crate::model::MonitoringOutputConfig>,
        pub(crate) job_resources: std::option::Option<crate::model::MonitoringResources>,
        pub(crate) network_config: std::option::Option<crate::model::MonitoringNetworkConfig>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) stopping_condition:
            std::option::Option<crate::model::MonitoringStoppingCondition>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the bias job definition. The name must be unique within an Amazon Web Services Region in the
        /// Amazon Web Services account.</p>
        pub fn job_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_definition_name = Some(input.into());
            self
        }
        /// <p>The name of the bias job definition. The name must be unique within an Amazon Web Services Region in the
        /// Amazon Web Services account.</p>
        pub fn set_job_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_definition_name = input;
            self
        }
        /// <p>The baseline configuration for a model bias job.</p>
        pub fn model_bias_baseline_config(
            mut self,
            input: crate::model::ModelBiasBaselineConfig,
        ) -> Self {
            self.model_bias_baseline_config = Some(input);
            self
        }
        /// <p>The baseline configuration for a model bias job.</p>
        pub fn set_model_bias_baseline_config(
            mut self,
            input: std::option::Option<crate::model::ModelBiasBaselineConfig>,
        ) -> Self {
            self.model_bias_baseline_config = input;
            self
        }
        /// <p>Configures the model bias job to run a specified Docker container image.</p>
        pub fn model_bias_app_specification(
            mut self,
            input: crate::model::ModelBiasAppSpecification,
        ) -> Self {
            self.model_bias_app_specification = Some(input);
            self
        }
        /// <p>Configures the model bias job to run a specified Docker container image.</p>
        pub fn set_model_bias_app_specification(
            mut self,
            input: std::option::Option<crate::model::ModelBiasAppSpecification>,
        ) -> Self {
            self.model_bias_app_specification = input;
            self
        }
        /// <p>Inputs for the model bias job.</p>
        pub fn model_bias_job_input(mut self, input: crate::model::ModelBiasJobInput) -> Self {
            self.model_bias_job_input = Some(input);
            self
        }
        /// <p>Inputs for the model bias job.</p>
        pub fn set_model_bias_job_input(
            mut self,
            input: std::option::Option<crate::model::ModelBiasJobInput>,
        ) -> Self {
            self.model_bias_job_input = input;
            self
        }
        /// <p>The output configuration for monitoring jobs.</p>
        pub fn model_bias_job_output_config(
            mut self,
            input: crate::model::MonitoringOutputConfig,
        ) -> Self {
            self.model_bias_job_output_config = Some(input);
            self
        }
        /// <p>The output configuration for monitoring jobs.</p>
        pub fn set_model_bias_job_output_config(
            mut self,
            input: std::option::Option<crate::model::MonitoringOutputConfig>,
        ) -> Self {
            self.model_bias_job_output_config = input;
            self
        }
        /// <p>Identifies the resources to deploy for a monitoring job.</p>
        pub fn job_resources(mut self, input: crate::model::MonitoringResources) -> Self {
            self.job_resources = Some(input);
            self
        }
        /// <p>Identifies the resources to deploy for a monitoring job.</p>
        pub fn set_job_resources(
            mut self,
            input: std::option::Option<crate::model::MonitoringResources>,
        ) -> Self {
            self.job_resources = input;
            self
        }
        /// <p>Networking options for a model bias job.</p>
        pub fn network_config(mut self, input: crate::model::MonitoringNetworkConfig) -> Self {
            self.network_config = Some(input);
            self
        }
        /// <p>Networking options for a model bias job.</p>
        pub fn set_network_config(
            mut self,
            input: std::option::Option<crate::model::MonitoringNetworkConfig>,
        ) -> Self {
            self.network_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to
        /// perform tasks on your behalf.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to
        /// perform tasks on your behalf.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
        pub fn stopping_condition(
            mut self,
            input: crate::model::MonitoringStoppingCondition,
        ) -> Self {
            self.stopping_condition = Some(input);
            self
        }
        /// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
        pub fn set_stopping_condition(
            mut self,
            input: std::option::Option<crate::model::MonitoringStoppingCondition>,
        ) -> Self {
            self.stopping_condition = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management
        /// User Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management
        /// User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateModelBiasJobDefinitionInput`](crate::input::CreateModelBiasJobDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateModelBiasJobDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateModelBiasJobDefinitionInput {
                job_definition_name: self.job_definition_name,
                model_bias_baseline_config: self.model_bias_baseline_config,
                model_bias_app_specification: self.model_bias_app_specification,
                model_bias_job_input: self.model_bias_job_input,
                model_bias_job_output_config: self.model_bias_job_output_config,
                job_resources: self.job_resources,
                network_config: self.network_config,
                role_arn: self.role_arn,
                stopping_condition: self.stopping_condition,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateModelBiasJobDefinitionInputOperationOutputAlias =
    crate::operation::CreateModelBiasJobDefinition;
#[doc(hidden)]
pub type CreateModelBiasJobDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateModelBiasJobDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`CreateModelBiasJobDefinition`](crate::operation::CreateModelBiasJobDefinition)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateModelBiasJobDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateModelBiasJobDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateModelBiasJobDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateModelBiasJobDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateModelBiasJobDefinition",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_model_bias_job_definition(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateModelBiasJobDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateModelBiasJobDefinition",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateModelBiasJobDefinitionInput`](crate::input::CreateModelBiasJobDefinitionInput)
    pub fn builder() -> crate::input::create_model_bias_job_definition_input::Builder {
        crate::input::create_model_bias_job_definition_input::Builder::default()
    }
}

/// See [`CreateModelExplainabilityJobDefinitionInput`](crate::input::CreateModelExplainabilityJobDefinitionInput)
pub mod create_model_explainability_job_definition_input {
    /// A builder for [`CreateModelExplainabilityJobDefinitionInput`](crate::input::CreateModelExplainabilityJobDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_definition_name: std::option::Option<std::string::String>,
        pub(crate) model_explainability_baseline_config:
            std::option::Option<crate::model::ModelExplainabilityBaselineConfig>,
        pub(crate) model_explainability_app_specification:
            std::option::Option<crate::model::ModelExplainabilityAppSpecification>,
        pub(crate) model_explainability_job_input:
            std::option::Option<crate::model::ModelExplainabilityJobInput>,
        pub(crate) model_explainability_job_output_config:
            std::option::Option<crate::model::MonitoringOutputConfig>,
        pub(crate) job_resources: std::option::Option<crate::model::MonitoringResources>,
        pub(crate) network_config: std::option::Option<crate::model::MonitoringNetworkConfig>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) stopping_condition:
            std::option::Option<crate::model::MonitoringStoppingCondition>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p> The name of the model explainability job definition. The name must be unique within an
        /// Amazon Web Services Region in the Amazon Web Services account.</p>
        pub fn job_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_definition_name = Some(input.into());
            self
        }
        /// <p> The name of the model explainability job definition. The name must be unique within an
        /// Amazon Web Services Region in the Amazon Web Services account.</p>
        pub fn set_job_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_definition_name = input;
            self
        }
        /// <p>The baseline configuration for a model explainability job.</p>
        pub fn model_explainability_baseline_config(
            mut self,
            input: crate::model::ModelExplainabilityBaselineConfig,
        ) -> Self {
            self.model_explainability_baseline_config = Some(input);
            self
        }
        /// <p>The baseline configuration for a model explainability job.</p>
        pub fn set_model_explainability_baseline_config(
            mut self,
            input: std::option::Option<crate::model::ModelExplainabilityBaselineConfig>,
        ) -> Self {
            self.model_explainability_baseline_config = input;
            self
        }
        /// <p>Configures the model explainability job to run a specified Docker container
        /// image.</p>
        pub fn model_explainability_app_specification(
            mut self,
            input: crate::model::ModelExplainabilityAppSpecification,
        ) -> Self {
            self.model_explainability_app_specification = Some(input);
            self
        }
        /// <p>Configures the model explainability job to run a specified Docker container
        /// image.</p>
        pub fn set_model_explainability_app_specification(
            mut self,
            input: std::option::Option<crate::model::ModelExplainabilityAppSpecification>,
        ) -> Self {
            self.model_explainability_app_specification = input;
            self
        }
        /// <p>Inputs for the model explainability job.</p>
        pub fn model_explainability_job_input(
            mut self,
            input: crate::model::ModelExplainabilityJobInput,
        ) -> Self {
            self.model_explainability_job_input = Some(input);
            self
        }
        /// <p>Inputs for the model explainability job.</p>
        pub fn set_model_explainability_job_input(
            mut self,
            input: std::option::Option<crate::model::ModelExplainabilityJobInput>,
        ) -> Self {
            self.model_explainability_job_input = input;
            self
        }
        /// <p>The output configuration for monitoring jobs.</p>
        pub fn model_explainability_job_output_config(
            mut self,
            input: crate::model::MonitoringOutputConfig,
        ) -> Self {
            self.model_explainability_job_output_config = Some(input);
            self
        }
        /// <p>The output configuration for monitoring jobs.</p>
        pub fn set_model_explainability_job_output_config(
            mut self,
            input: std::option::Option<crate::model::MonitoringOutputConfig>,
        ) -> Self {
            self.model_explainability_job_output_config = input;
            self
        }
        /// <p>Identifies the resources to deploy for a monitoring job.</p>
        pub fn job_resources(mut self, input: crate::model::MonitoringResources) -> Self {
            self.job_resources = Some(input);
            self
        }
        /// <p>Identifies the resources to deploy for a monitoring job.</p>
        pub fn set_job_resources(
            mut self,
            input: std::option::Option<crate::model::MonitoringResources>,
        ) -> Self {
            self.job_resources = input;
            self
        }
        /// <p>Networking options for a model explainability job.</p>
        pub fn network_config(mut self, input: crate::model::MonitoringNetworkConfig) -> Self {
            self.network_config = Some(input);
            self
        }
        /// <p>Networking options for a model explainability job.</p>
        pub fn set_network_config(
            mut self,
            input: std::option::Option<crate::model::MonitoringNetworkConfig>,
        ) -> Self {
            self.network_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to
        /// perform tasks on your behalf.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to
        /// perform tasks on your behalf.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
        pub fn stopping_condition(
            mut self,
            input: crate::model::MonitoringStoppingCondition,
        ) -> Self {
            self.stopping_condition = Some(input);
            self
        }
        /// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
        pub fn set_stopping_condition(
            mut self,
            input: std::option::Option<crate::model::MonitoringStoppingCondition>,
        ) -> Self {
            self.stopping_condition = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management
        /// User Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management
        /// User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateModelExplainabilityJobDefinitionInput`](crate::input::CreateModelExplainabilityJobDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateModelExplainabilityJobDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateModelExplainabilityJobDefinitionInput {
                job_definition_name: self.job_definition_name,
                model_explainability_baseline_config: self.model_explainability_baseline_config,
                model_explainability_app_specification: self.model_explainability_app_specification,
                model_explainability_job_input: self.model_explainability_job_input,
                model_explainability_job_output_config: self.model_explainability_job_output_config,
                job_resources: self.job_resources,
                network_config: self.network_config,
                role_arn: self.role_arn,
                stopping_condition: self.stopping_condition,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateModelExplainabilityJobDefinitionInputOperationOutputAlias =
    crate::operation::CreateModelExplainabilityJobDefinition;
#[doc(hidden)]
pub type CreateModelExplainabilityJobDefinitionInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl CreateModelExplainabilityJobDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`CreateModelExplainabilityJobDefinition`](crate::operation::CreateModelExplainabilityJobDefinition)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateModelExplainabilityJobDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateModelExplainabilityJobDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateModelExplainabilityJobDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateModelExplainabilityJobDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateModelExplainabilityJobDefinition",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_model_explainability_job_definition(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateModelExplainabilityJobDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateModelExplainabilityJobDefinition",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateModelExplainabilityJobDefinitionInput`](crate::input::CreateModelExplainabilityJobDefinitionInput)
    pub fn builder() -> crate::input::create_model_explainability_job_definition_input::Builder {
        crate::input::create_model_explainability_job_definition_input::Builder::default()
    }
}

/// See [`CreateModelPackageInput`](crate::input::CreateModelPackageInput)
pub mod create_model_package_input {
    /// A builder for [`CreateModelPackageInput`](crate::input::CreateModelPackageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_package_name: std::option::Option<std::string::String>,
        pub(crate) model_package_group_name: std::option::Option<std::string::String>,
        pub(crate) model_package_description: std::option::Option<std::string::String>,
        pub(crate) inference_specification:
            std::option::Option<crate::model::InferenceSpecification>,
        pub(crate) validation_specification:
            std::option::Option<crate::model::ModelPackageValidationSpecification>,
        pub(crate) source_algorithm_specification:
            std::option::Option<crate::model::SourceAlgorithmSpecification>,
        pub(crate) certify_for_marketplace: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) model_approval_status: std::option::Option<crate::model::ModelApprovalStatus>,
        pub(crate) metadata_properties: std::option::Option<crate::model::MetadataProperties>,
        pub(crate) model_metrics: std::option::Option<crate::model::ModelMetrics>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) customer_metadata_properties: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the model package. The name must have 1 to 63 characters. Valid characters
        /// are a-z, A-Z, 0-9, and - (hyphen).</p>
        /// <p>This parameter is required for unversioned models. It is not applicable to versioned
        /// models.</p>
        pub fn model_package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_package_name = Some(input.into());
            self
        }
        /// <p>The name of the model package. The name must have 1 to 63 characters. Valid characters
        /// are a-z, A-Z, 0-9, and - (hyphen).</p>
        /// <p>This parameter is required for unversioned models. It is not applicable to versioned
        /// models.</p>
        pub fn set_model_package_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_package_name = input;
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the model package group that this model version belongs to.</p>
        /// <p>This parameter is required for versioned models, and does not apply to unversioned
        /// models.</p>
        pub fn model_package_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_package_group_name = Some(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the model package group that this model version belongs to.</p>
        /// <p>This parameter is required for versioned models, and does not apply to unversioned
        /// models.</p>
        pub fn set_model_package_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_package_group_name = input;
            self
        }
        /// <p>A description of the model package.</p>
        pub fn model_package_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_package_description = Some(input.into());
            self
        }
        /// <p>A description of the model package.</p>
        pub fn set_model_package_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_package_description = input;
            self
        }
        /// <p>Specifies details about inference jobs that can be run with models based on this model
        /// package, including the following:</p>
        /// <ul>
        /// <li>
        /// <p>The Amazon ECR paths of containers that contain the inference code and model
        /// artifacts.</p>
        /// </li>
        /// <li>
        /// <p>The instance types that the model package supports for transform jobs and
        /// real-time endpoints used for inference.</p>
        /// </li>
        /// <li>
        /// <p>The input and output content formats that the model package supports for
        /// inference.</p>
        /// </li>
        /// </ul>
        pub fn inference_specification(
            mut self,
            input: crate::model::InferenceSpecification,
        ) -> Self {
            self.inference_specification = Some(input);
            self
        }
        /// <p>Specifies details about inference jobs that can be run with models based on this model
        /// package, including the following:</p>
        /// <ul>
        /// <li>
        /// <p>The Amazon ECR paths of containers that contain the inference code and model
        /// artifacts.</p>
        /// </li>
        /// <li>
        /// <p>The instance types that the model package supports for transform jobs and
        /// real-time endpoints used for inference.</p>
        /// </li>
        /// <li>
        /// <p>The input and output content formats that the model package supports for
        /// inference.</p>
        /// </li>
        /// </ul>
        pub fn set_inference_specification(
            mut self,
            input: std::option::Option<crate::model::InferenceSpecification>,
        ) -> Self {
            self.inference_specification = input;
            self
        }
        /// <p>Specifies configurations for one or more transform jobs that Amazon SageMaker runs to test the
        /// model package.</p>
        pub fn validation_specification(
            mut self,
            input: crate::model::ModelPackageValidationSpecification,
        ) -> Self {
            self.validation_specification = Some(input);
            self
        }
        /// <p>Specifies configurations for one or more transform jobs that Amazon SageMaker runs to test the
        /// model package.</p>
        pub fn set_validation_specification(
            mut self,
            input: std::option::Option<crate::model::ModelPackageValidationSpecification>,
        ) -> Self {
            self.validation_specification = input;
            self
        }
        /// <p>Details about the algorithm that was used to create the model package.</p>
        pub fn source_algorithm_specification(
            mut self,
            input: crate::model::SourceAlgorithmSpecification,
        ) -> Self {
            self.source_algorithm_specification = Some(input);
            self
        }
        /// <p>Details about the algorithm that was used to create the model package.</p>
        pub fn set_source_algorithm_specification(
            mut self,
            input: std::option::Option<crate::model::SourceAlgorithmSpecification>,
        ) -> Self {
            self.source_algorithm_specification = input;
            self
        }
        /// <p>Whether to certify the model package for listing on Amazon Web Services Marketplace.</p>
        /// <p>This parameter is optional for unversioned models, and does not apply to versioned
        /// models.</p>
        pub fn certify_for_marketplace(mut self, input: bool) -> Self {
            self.certify_for_marketplace = Some(input);
            self
        }
        /// <p>Whether to certify the model package for listing on Amazon Web Services Marketplace.</p>
        /// <p>This parameter is optional for unversioned models, and does not apply to versioned
        /// models.</p>
        pub fn set_certify_for_marketplace(mut self, input: std::option::Option<bool>) -> Self {
            self.certify_for_marketplace = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key value pairs associated with the model. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of key value pairs associated with the model. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Whether the model is approved for deployment.</p>
        /// <p>This parameter is optional for versioned models, and does not apply to unversioned
        /// models.</p>
        /// <p>For versioned models, the value of this parameter must be set to <code>Approved</code>
        /// to deploy the model.</p>
        pub fn model_approval_status(mut self, input: crate::model::ModelApprovalStatus) -> Self {
            self.model_approval_status = Some(input);
            self
        }
        /// <p>Whether the model is approved for deployment.</p>
        /// <p>This parameter is optional for versioned models, and does not apply to unversioned
        /// models.</p>
        /// <p>For versioned models, the value of this parameter must be set to <code>Approved</code>
        /// to deploy the model.</p>
        pub fn set_model_approval_status(
            mut self,
            input: std::option::Option<crate::model::ModelApprovalStatus>,
        ) -> Self {
            self.model_approval_status = input;
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn metadata_properties(mut self, input: crate::model::MetadataProperties) -> Self {
            self.metadata_properties = Some(input);
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn set_metadata_properties(
            mut self,
            input: std::option::Option<crate::model::MetadataProperties>,
        ) -> Self {
            self.metadata_properties = input;
            self
        }
        /// <p>A structure that contains model metrics reports.</p>
        pub fn model_metrics(mut self, input: crate::model::ModelMetrics) -> Self {
            self.model_metrics = Some(input);
            self
        }
        /// <p>A structure that contains model metrics reports.</p>
        pub fn set_model_metrics(
            mut self,
            input: std::option::Option<crate::model::ModelMetrics>,
        ) -> Self {
            self.model_metrics = input;
            self
        }
        /// <p>A unique token that guarantees that the call to this API is idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique token that guarantees that the call to this API is idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Adds a key-value pair to `customer_metadata_properties`.
        ///
        /// To override the contents of this collection use [`set_customer_metadata_properties`](Self::set_customer_metadata_properties).
        ///
        /// <p>The metadata properties associated with the model package versions.</p>
        pub fn customer_metadata_properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.customer_metadata_properties.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.customer_metadata_properties = Some(hash_map);
            self
        }
        /// <p>The metadata properties associated with the model package versions.</p>
        pub fn set_customer_metadata_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.customer_metadata_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateModelPackageInput`](crate::input::CreateModelPackageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateModelPackageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateModelPackageInput {
                model_package_name: self.model_package_name,
                model_package_group_name: self.model_package_group_name,
                model_package_description: self.model_package_description,
                inference_specification: self.inference_specification,
                validation_specification: self.validation_specification,
                source_algorithm_specification: self.source_algorithm_specification,
                certify_for_marketplace: self.certify_for_marketplace.unwrap_or_default(),
                tags: self.tags,
                model_approval_status: self.model_approval_status,
                metadata_properties: self.metadata_properties,
                model_metrics: self.model_metrics,
                client_token: self.client_token,
                customer_metadata_properties: self.customer_metadata_properties,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateModelPackageInputOperationOutputAlias = crate::operation::CreateModelPackage;
#[doc(hidden)]
pub type CreateModelPackageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateModelPackageInput {
    /// Consumes the builder and constructs an Operation<[`CreateModelPackage`](crate::operation::CreateModelPackage)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateModelPackage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateModelPackageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateModelPackageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateModelPackageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateModelPackage",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_model_package(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateModelPackage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateModelPackage",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateModelPackageInput`](crate::input::CreateModelPackageInput)
    pub fn builder() -> crate::input::create_model_package_input::Builder {
        crate::input::create_model_package_input::Builder::default()
    }
}

/// See [`CreateModelPackageGroupInput`](crate::input::CreateModelPackageGroupInput)
pub mod create_model_package_group_input {
    /// A builder for [`CreateModelPackageGroupInput`](crate::input::CreateModelPackageGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_package_group_name: std::option::Option<std::string::String>,
        pub(crate) model_package_group_description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the model group.</p>
        pub fn model_package_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_package_group_name = Some(input.into());
            self
        }
        /// <p>The name of the model group.</p>
        pub fn set_model_package_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_package_group_name = input;
            self
        }
        /// <p>A description for the model group.</p>
        pub fn model_package_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.model_package_group_description = Some(input.into());
            self
        }
        /// <p>A description for the model group.</p>
        pub fn set_model_package_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_package_group_description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of key value pairs associated with the model group. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of key value pairs associated with the model group. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateModelPackageGroupInput`](crate::input::CreateModelPackageGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateModelPackageGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateModelPackageGroupInput {
                model_package_group_name: self.model_package_group_name,
                model_package_group_description: self.model_package_group_description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateModelPackageGroupInputOperationOutputAlias =
    crate::operation::CreateModelPackageGroup;
#[doc(hidden)]
pub type CreateModelPackageGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateModelPackageGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateModelPackageGroup`](crate::operation::CreateModelPackageGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateModelPackageGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateModelPackageGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateModelPackageGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateModelPackageGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateModelPackageGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_model_package_group(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateModelPackageGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateModelPackageGroup",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateModelPackageGroupInput`](crate::input::CreateModelPackageGroupInput)
    pub fn builder() -> crate::input::create_model_package_group_input::Builder {
        crate::input::create_model_package_group_input::Builder::default()
    }
}

/// See [`CreateModelQualityJobDefinitionInput`](crate::input::CreateModelQualityJobDefinitionInput)
pub mod create_model_quality_job_definition_input {
    /// A builder for [`CreateModelQualityJobDefinitionInput`](crate::input::CreateModelQualityJobDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_definition_name: std::option::Option<std::string::String>,
        pub(crate) model_quality_baseline_config:
            std::option::Option<crate::model::ModelQualityBaselineConfig>,
        pub(crate) model_quality_app_specification:
            std::option::Option<crate::model::ModelQualityAppSpecification>,
        pub(crate) model_quality_job_input: std::option::Option<crate::model::ModelQualityJobInput>,
        pub(crate) model_quality_job_output_config:
            std::option::Option<crate::model::MonitoringOutputConfig>,
        pub(crate) job_resources: std::option::Option<crate::model::MonitoringResources>,
        pub(crate) network_config: std::option::Option<crate::model::MonitoringNetworkConfig>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) stopping_condition:
            std::option::Option<crate::model::MonitoringStoppingCondition>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the monitoring job definition.</p>
        pub fn job_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_definition_name = Some(input.into());
            self
        }
        /// <p>The name of the monitoring job definition.</p>
        pub fn set_job_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_definition_name = input;
            self
        }
        /// <p>Specifies the constraints and baselines for the monitoring job.</p>
        pub fn model_quality_baseline_config(
            mut self,
            input: crate::model::ModelQualityBaselineConfig,
        ) -> Self {
            self.model_quality_baseline_config = Some(input);
            self
        }
        /// <p>Specifies the constraints and baselines for the monitoring job.</p>
        pub fn set_model_quality_baseline_config(
            mut self,
            input: std::option::Option<crate::model::ModelQualityBaselineConfig>,
        ) -> Self {
            self.model_quality_baseline_config = input;
            self
        }
        /// <p>The container that runs the monitoring job.</p>
        pub fn model_quality_app_specification(
            mut self,
            input: crate::model::ModelQualityAppSpecification,
        ) -> Self {
            self.model_quality_app_specification = Some(input);
            self
        }
        /// <p>The container that runs the monitoring job.</p>
        pub fn set_model_quality_app_specification(
            mut self,
            input: std::option::Option<crate::model::ModelQualityAppSpecification>,
        ) -> Self {
            self.model_quality_app_specification = input;
            self
        }
        /// <p>A list of the inputs that are monitored. Currently endpoints are supported.</p>
        pub fn model_quality_job_input(
            mut self,
            input: crate::model::ModelQualityJobInput,
        ) -> Self {
            self.model_quality_job_input = Some(input);
            self
        }
        /// <p>A list of the inputs that are monitored. Currently endpoints are supported.</p>
        pub fn set_model_quality_job_input(
            mut self,
            input: std::option::Option<crate::model::ModelQualityJobInput>,
        ) -> Self {
            self.model_quality_job_input = input;
            self
        }
        /// <p>The output configuration for monitoring jobs.</p>
        pub fn model_quality_job_output_config(
            mut self,
            input: crate::model::MonitoringOutputConfig,
        ) -> Self {
            self.model_quality_job_output_config = Some(input);
            self
        }
        /// <p>The output configuration for monitoring jobs.</p>
        pub fn set_model_quality_job_output_config(
            mut self,
            input: std::option::Option<crate::model::MonitoringOutputConfig>,
        ) -> Self {
            self.model_quality_job_output_config = input;
            self
        }
        /// <p>Identifies the resources to deploy for a monitoring job.</p>
        pub fn job_resources(mut self, input: crate::model::MonitoringResources) -> Self {
            self.job_resources = Some(input);
            self
        }
        /// <p>Identifies the resources to deploy for a monitoring job.</p>
        pub fn set_job_resources(
            mut self,
            input: std::option::Option<crate::model::MonitoringResources>,
        ) -> Self {
            self.job_resources = input;
            self
        }
        /// <p>Specifies the network configuration for the monitoring job.</p>
        pub fn network_config(mut self, input: crate::model::MonitoringNetworkConfig) -> Self {
            self.network_config = Some(input);
            self
        }
        /// <p>Specifies the network configuration for the monitoring job.</p>
        pub fn set_network_config(
            mut self,
            input: std::option::Option<crate::model::MonitoringNetworkConfig>,
        ) -> Self {
            self.network_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to
        /// perform tasks on your behalf.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to
        /// perform tasks on your behalf.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
        pub fn stopping_condition(
            mut self,
            input: crate::model::MonitoringStoppingCondition,
        ) -> Self {
            self.stopping_condition = Some(input);
            self
        }
        /// <p>A time limit for how long the monitoring job is allowed to run before stopping.</p>
        pub fn set_stopping_condition(
            mut self,
            input: std::option::Option<crate::model::MonitoringStoppingCondition>,
        ) -> Self {
            self.stopping_condition = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management
        /// User Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management
        /// User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateModelQualityJobDefinitionInput`](crate::input::CreateModelQualityJobDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateModelQualityJobDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateModelQualityJobDefinitionInput {
                job_definition_name: self.job_definition_name,
                model_quality_baseline_config: self.model_quality_baseline_config,
                model_quality_app_specification: self.model_quality_app_specification,
                model_quality_job_input: self.model_quality_job_input,
                model_quality_job_output_config: self.model_quality_job_output_config,
                job_resources: self.job_resources,
                network_config: self.network_config,
                role_arn: self.role_arn,
                stopping_condition: self.stopping_condition,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateModelQualityJobDefinitionInputOperationOutputAlias =
    crate::operation::CreateModelQualityJobDefinition;
#[doc(hidden)]
pub type CreateModelQualityJobDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateModelQualityJobDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`CreateModelQualityJobDefinition`](crate::operation::CreateModelQualityJobDefinition)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateModelQualityJobDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateModelQualityJobDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateModelQualityJobDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateModelQualityJobDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateModelQualityJobDefinition",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_model_quality_job_definition(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateModelQualityJobDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateModelQualityJobDefinition",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateModelQualityJobDefinitionInput`](crate::input::CreateModelQualityJobDefinitionInput)
    pub fn builder() -> crate::input::create_model_quality_job_definition_input::Builder {
        crate::input::create_model_quality_job_definition_input::Builder::default()
    }
}

/// See [`CreateMonitoringScheduleInput`](crate::input::CreateMonitoringScheduleInput)
pub mod create_monitoring_schedule_input {
    /// A builder for [`CreateMonitoringScheduleInput`](crate::input::CreateMonitoringScheduleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) monitoring_schedule_name: std::option::Option<std::string::String>,
        pub(crate) monitoring_schedule_config:
            std::option::Option<crate::model::MonitoringScheduleConfig>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the monitoring schedule. The name must be unique within an Amazon Web Services Region within
        /// an Amazon Web Services account.</p>
        pub fn monitoring_schedule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.monitoring_schedule_name = Some(input.into());
            self
        }
        /// <p>The name of the monitoring schedule. The name must be unique within an Amazon Web Services Region within
        /// an Amazon Web Services account.</p>
        pub fn set_monitoring_schedule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.monitoring_schedule_name = input;
            self
        }
        /// <p>The configuration object that specifies the monitoring schedule and defines the
        /// monitoring job.</p>
        pub fn monitoring_schedule_config(
            mut self,
            input: crate::model::MonitoringScheduleConfig,
        ) -> Self {
            self.monitoring_schedule_config = Some(input);
            self
        }
        /// <p>The configuration object that specifies the monitoring schedule and defines the
        /// monitoring job.</p>
        pub fn set_monitoring_schedule_config(
            mut self,
            input: std::option::Option<crate::model::MonitoringScheduleConfig>,
        ) -> Self {
            self.monitoring_schedule_config = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>(Optional) An array of key-value pairs. For more information, see <a href=" https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management
        /// User Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>(Optional) An array of key-value pairs. For more information, see <a href=" https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management
        /// User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMonitoringScheduleInput`](crate::input::CreateMonitoringScheduleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMonitoringScheduleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMonitoringScheduleInput {
                monitoring_schedule_name: self.monitoring_schedule_name,
                monitoring_schedule_config: self.monitoring_schedule_config,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMonitoringScheduleInputOperationOutputAlias =
    crate::operation::CreateMonitoringSchedule;
#[doc(hidden)]
pub type CreateMonitoringScheduleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateMonitoringScheduleInput {
    /// Consumes the builder and constructs an Operation<[`CreateMonitoringSchedule`](crate::operation::CreateMonitoringSchedule)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMonitoringSchedule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateMonitoringScheduleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateMonitoringScheduleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateMonitoringScheduleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateMonitoringSchedule",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_monitoring_schedule(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMonitoringSchedule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMonitoringSchedule",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateMonitoringScheduleInput`](crate::input::CreateMonitoringScheduleInput)
    pub fn builder() -> crate::input::create_monitoring_schedule_input::Builder {
        crate::input::create_monitoring_schedule_input::Builder::default()
    }
}

/// See [`CreateNotebookInstanceInput`](crate::input::CreateNotebookInstanceInput)
pub mod create_notebook_instance_input {
    /// A builder for [`CreateNotebookInstanceInput`](crate::input::CreateNotebookInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notebook_instance_name: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<crate::model::InstanceType>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) lifecycle_config_name: std::option::Option<std::string::String>,
        pub(crate) direct_internet_access: std::option::Option<crate::model::DirectInternetAccess>,
        pub(crate) volume_size_in_gb: std::option::Option<i32>,
        pub(crate) accelerator_types:
            std::option::Option<std::vec::Vec<crate::model::NotebookInstanceAcceleratorType>>,
        pub(crate) default_code_repository: std::option::Option<std::string::String>,
        pub(crate) additional_code_repositories:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) root_access: std::option::Option<crate::model::RootAccess>,
        pub(crate) platform_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the new notebook instance.</p>
        pub fn notebook_instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.notebook_instance_name = Some(input.into());
            self
        }
        /// <p>The name of the new notebook instance.</p>
        pub fn set_notebook_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notebook_instance_name = input;
            self
        }
        /// <p>The type of ML compute instance to launch for the notebook instance.</p>
        pub fn instance_type(mut self, input: crate::model::InstanceType) -> Self {
            self.instance_type = Some(input);
            self
        }
        /// <p>The type of ML compute instance to launch for the notebook instance.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<crate::model::InstanceType>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The ID of the subnet in a VPC to which you would like to have a connectivity from
        /// your ML compute instance. </p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The ID of the subnet in a VPC to which you would like to have a connectivity from
        /// your ML compute instance. </p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The VPC security group IDs, in the form sg-xxxxxxxx. The security groups must be
        /// for the same VPC as specified in the subnet. </p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>The VPC security group IDs, in the form sg-xxxxxxxx. The security groups must be
        /// for the same VPC as specified in the subnet. </p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// <p> When you send any requests to Amazon Web Services resources from the notebook instance, Amazon SageMaker
        /// assumes this role to perform tasks on your behalf. You must grant this role necessary
        /// permissions so Amazon SageMaker can perform these tasks. The policy must allow the Amazon SageMaker service
        /// principal (sagemaker.amazonaws.com) permissions to assume this role. For more
        /// information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles</a>. </p>
        /// <note>
        /// <p>To be able to pass this role to Amazon SageMaker, the caller of this API must have the
        /// <code>iam:PassRole</code> permission.</p>
        /// </note>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p> When you send any requests to Amazon Web Services resources from the notebook instance, Amazon SageMaker
        /// assumes this role to perform tasks on your behalf. You must grant this role necessary
        /// permissions so Amazon SageMaker can perform these tasks. The policy must allow the Amazon SageMaker service
        /// principal (sagemaker.amazonaws.com) permissions to assume this role. For more
        /// information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles</a>. </p>
        /// <note>
        /// <p>To be able to pass this role to Amazon SageMaker, the caller of this API must have the
        /// <code>iam:PassRole</code> permission.</p>
        /// </note>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that Amazon SageMaker uses to encrypt data on
        /// the storage volume attached to your notebook instance. The KMS key you provide must be
        /// enabled. For information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html">Enabling and Disabling
        /// Keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that Amazon SageMaker uses to encrypt data on
        /// the storage volume attached to your notebook instance. The KMS key you provide must be
        /// enabled. For information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html">Enabling and Disabling
        /// Keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
        /// different ways, for example, by purpose, owner, or environment. For more information,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// Resources</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
        /// different ways, for example, by purpose, owner, or environment. For more information,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// Resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The name of a lifecycle configuration to associate with the notebook instance. For
        /// information about lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
        /// Customize a Notebook Instance</a>.</p>
        pub fn lifecycle_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.lifecycle_config_name = Some(input.into());
            self
        }
        /// <p>The name of a lifecycle configuration to associate with the notebook instance. For
        /// information about lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
        /// Customize a Notebook Instance</a>.</p>
        pub fn set_lifecycle_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lifecycle_config_name = input;
            self
        }
        /// <p>Sets whether Amazon SageMaker provides internet access to the notebook instance. If you set this
        /// to <code>Disabled</code> this notebook instance is able to access resources only in your
        /// VPC, and is not be able to connect to Amazon SageMaker training and endpoint services unless you
        /// configure a NAT Gateway in your VPC.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access">Notebook Instances Are Internet-Enabled by Default</a>. You can set the value
        /// of this parameter to <code>Disabled</code> only if you set a value for the
        /// <code>SubnetId</code> parameter.</p>
        pub fn direct_internet_access(mut self, input: crate::model::DirectInternetAccess) -> Self {
            self.direct_internet_access = Some(input);
            self
        }
        /// <p>Sets whether Amazon SageMaker provides internet access to the notebook instance. If you set this
        /// to <code>Disabled</code> this notebook instance is able to access resources only in your
        /// VPC, and is not be able to connect to Amazon SageMaker training and endpoint services unless you
        /// configure a NAT Gateway in your VPC.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access">Notebook Instances Are Internet-Enabled by Default</a>. You can set the value
        /// of this parameter to <code>Disabled</code> only if you set a value for the
        /// <code>SubnetId</code> parameter.</p>
        pub fn set_direct_internet_access(
            mut self,
            input: std::option::Option<crate::model::DirectInternetAccess>,
        ) -> Self {
            self.direct_internet_access = input;
            self
        }
        /// <p>The size, in GB, of the ML storage volume to attach to the notebook instance. The
        /// default value is 5 GB.</p>
        pub fn volume_size_in_gb(mut self, input: i32) -> Self {
            self.volume_size_in_gb = Some(input);
            self
        }
        /// <p>The size, in GB, of the ML storage volume to attach to the notebook instance. The
        /// default value is 5 GB.</p>
        pub fn set_volume_size_in_gb(mut self, input: std::option::Option<i32>) -> Self {
            self.volume_size_in_gb = input;
            self
        }
        /// Appends an item to `accelerator_types`.
        ///
        /// To override the contents of this collection use [`set_accelerator_types`](Self::set_accelerator_types).
        ///
        /// <p>A list of Elastic Inference (EI) instance types to associate with this notebook
        /// instance. Currently, only one instance type can be associated with a notebook instance.
        /// For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.</p>
        pub fn accelerator_types(
            mut self,
            input: impl Into<crate::model::NotebookInstanceAcceleratorType>,
        ) -> Self {
            let mut v = self.accelerator_types.unwrap_or_default();
            v.push(input.into());
            self.accelerator_types = Some(v);
            self
        }
        /// <p>A list of Elastic Inference (EI) instance types to associate with this notebook
        /// instance. Currently, only one instance type can be associated with a notebook instance.
        /// For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.</p>
        pub fn set_accelerator_types(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::NotebookInstanceAcceleratorType>,
            >,
        ) -> Self {
            self.accelerator_types = input;
            self
        }
        /// <p>A Git repository to associate with the notebook instance as its default code
        /// repository. This can be either the name of a Git repository stored as a resource in your
        /// account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any
        /// other Git repository. When you open a notebook instance, it opens in the directory that
        /// contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker
        /// Notebook Instances</a>.</p>
        pub fn default_code_repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_code_repository = Some(input.into());
            self
        }
        /// <p>A Git repository to associate with the notebook instance as its default code
        /// repository. This can be either the name of a Git repository stored as a resource in your
        /// account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any
        /// other Git repository. When you open a notebook instance, it opens in the directory that
        /// contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker
        /// Notebook Instances</a>.</p>
        pub fn set_default_code_repository(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_code_repository = input;
            self
        }
        /// Appends an item to `additional_code_repositories`.
        ///
        /// To override the contents of this collection use [`set_additional_code_repositories`](Self::set_additional_code_repositories).
        ///
        /// <p>An array of up to three Git repositories to associate with the notebook instance.
        /// These can be either the names of Git repositories stored as resources in your account,
        /// or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any
        /// other Git repository. These repositories are cloned at the same level as the default
        /// repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git
        /// Repositories with Amazon SageMaker Notebook Instances</a>.</p>
        pub fn additional_code_repositories(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.additional_code_repositories.unwrap_or_default();
            v.push(input.into());
            self.additional_code_repositories = Some(v);
            self
        }
        /// <p>An array of up to three Git repositories to associate with the notebook instance.
        /// These can be either the names of Git repositories stored as resources in your account,
        /// or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any
        /// other Git repository. These repositories are cloned at the same level as the default
        /// repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git
        /// Repositories with Amazon SageMaker Notebook Instances</a>.</p>
        pub fn set_additional_code_repositories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.additional_code_repositories = input;
            self
        }
        /// <p>Whether root access is enabled or disabled for users of the notebook instance. The
        /// default value is <code>Enabled</code>.</p>
        /// <note>
        /// <p>Lifecycle configurations need root access to be able to set up a notebook
        /// instance. Because of this, lifecycle configurations associated with a notebook
        /// instance always run with root access even if you disable root access for
        /// users.</p>
        /// </note>
        pub fn root_access(mut self, input: crate::model::RootAccess) -> Self {
            self.root_access = Some(input);
            self
        }
        /// <p>Whether root access is enabled or disabled for users of the notebook instance. The
        /// default value is <code>Enabled</code>.</p>
        /// <note>
        /// <p>Lifecycle configurations need root access to be able to set up a notebook
        /// instance. Because of this, lifecycle configurations associated with a notebook
        /// instance always run with root access even if you disable root access for
        /// users.</p>
        /// </note>
        pub fn set_root_access(
            mut self,
            input: std::option::Option<crate::model::RootAccess>,
        ) -> Self {
            self.root_access = input;
            self
        }
        /// <p>The platform identifier of the notebook instance runtime environment.</p>
        pub fn platform_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_identifier = Some(input.into());
            self
        }
        /// <p>The platform identifier of the notebook instance runtime environment.</p>
        pub fn set_platform_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateNotebookInstanceInput`](crate::input::CreateNotebookInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateNotebookInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateNotebookInstanceInput {
                notebook_instance_name: self.notebook_instance_name,
                instance_type: self.instance_type,
                subnet_id: self.subnet_id,
                security_group_ids: self.security_group_ids,
                role_arn: self.role_arn,
                kms_key_id: self.kms_key_id,
                tags: self.tags,
                lifecycle_config_name: self.lifecycle_config_name,
                direct_internet_access: self.direct_internet_access,
                volume_size_in_gb: self.volume_size_in_gb,
                accelerator_types: self.accelerator_types,
                default_code_repository: self.default_code_repository,
                additional_code_repositories: self.additional_code_repositories,
                root_access: self.root_access,
                platform_identifier: self.platform_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateNotebookInstanceInputOperationOutputAlias = crate::operation::CreateNotebookInstance;
#[doc(hidden)]
pub type CreateNotebookInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateNotebookInstanceInput {
    /// Consumes the builder and constructs an Operation<[`CreateNotebookInstance`](crate::operation::CreateNotebookInstance)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateNotebookInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateNotebookInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateNotebookInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateNotebookInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateNotebookInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_notebook_instance(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateNotebookInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateNotebookInstance",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateNotebookInstanceInput`](crate::input::CreateNotebookInstanceInput)
    pub fn builder() -> crate::input::create_notebook_instance_input::Builder {
        crate::input::create_notebook_instance_input::Builder::default()
    }
}

/// See [`CreateNotebookInstanceLifecycleConfigInput`](crate::input::CreateNotebookInstanceLifecycleConfigInput)
pub mod create_notebook_instance_lifecycle_config_input {
    /// A builder for [`CreateNotebookInstanceLifecycleConfigInput`](crate::input::CreateNotebookInstanceLifecycleConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notebook_instance_lifecycle_config_name:
            std::option::Option<std::string::String>,
        pub(crate) on_create:
            std::option::Option<std::vec::Vec<crate::model::NotebookInstanceLifecycleHook>>,
        pub(crate) on_start:
            std::option::Option<std::vec::Vec<crate::model::NotebookInstanceLifecycleHook>>,
    }
    impl Builder {
        /// <p>The name of the lifecycle configuration.</p>
        pub fn notebook_instance_lifecycle_config_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.notebook_instance_lifecycle_config_name = Some(input.into());
            self
        }
        /// <p>The name of the lifecycle configuration.</p>
        pub fn set_notebook_instance_lifecycle_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notebook_instance_lifecycle_config_name = input;
            self
        }
        /// Appends an item to `on_create`.
        ///
        /// To override the contents of this collection use [`set_on_create`](Self::set_on_create).
        ///
        /// <p>A shell script that runs only once, when you create a notebook instance. The shell
        /// script must be a base64-encoded string.</p>
        pub fn on_create(
            mut self,
            input: impl Into<crate::model::NotebookInstanceLifecycleHook>,
        ) -> Self {
            let mut v = self.on_create.unwrap_or_default();
            v.push(input.into());
            self.on_create = Some(v);
            self
        }
        /// <p>A shell script that runs only once, when you create a notebook instance. The shell
        /// script must be a base64-encoded string.</p>
        pub fn set_on_create(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NotebookInstanceLifecycleHook>>,
        ) -> Self {
            self.on_create = input;
            self
        }
        /// Appends an item to `on_start`.
        ///
        /// To override the contents of this collection use [`set_on_start`](Self::set_on_start).
        ///
        /// <p>A shell script that runs every time you start a notebook instance, including when you
        /// create the notebook instance. The shell script must be a base64-encoded string.</p>
        pub fn on_start(
            mut self,
            input: impl Into<crate::model::NotebookInstanceLifecycleHook>,
        ) -> Self {
            let mut v = self.on_start.unwrap_or_default();
            v.push(input.into());
            self.on_start = Some(v);
            self
        }
        /// <p>A shell script that runs every time you start a notebook instance, including when you
        /// create the notebook instance. The shell script must be a base64-encoded string.</p>
        pub fn set_on_start(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NotebookInstanceLifecycleHook>>,
        ) -> Self {
            self.on_start = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateNotebookInstanceLifecycleConfigInput`](crate::input::CreateNotebookInstanceLifecycleConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateNotebookInstanceLifecycleConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateNotebookInstanceLifecycleConfigInput {
                notebook_instance_lifecycle_config_name: self
                    .notebook_instance_lifecycle_config_name,
                on_create: self.on_create,
                on_start: self.on_start,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateNotebookInstanceLifecycleConfigInputOperationOutputAlias =
    crate::operation::CreateNotebookInstanceLifecycleConfig;
#[doc(hidden)]
pub type CreateNotebookInstanceLifecycleConfigInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl CreateNotebookInstanceLifecycleConfigInput {
    /// Consumes the builder and constructs an Operation<[`CreateNotebookInstanceLifecycleConfig`](crate::operation::CreateNotebookInstanceLifecycleConfig)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateNotebookInstanceLifecycleConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateNotebookInstanceLifecycleConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateNotebookInstanceLifecycleConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateNotebookInstanceLifecycleConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateNotebookInstanceLifecycleConfig",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_notebook_instance_lifecycle_config(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateNotebookInstanceLifecycleConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateNotebookInstanceLifecycleConfig",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateNotebookInstanceLifecycleConfigInput`](crate::input::CreateNotebookInstanceLifecycleConfigInput)
    pub fn builder() -> crate::input::create_notebook_instance_lifecycle_config_input::Builder {
        crate::input::create_notebook_instance_lifecycle_config_input::Builder::default()
    }
}

/// See [`CreatePipelineInput`](crate::input::CreatePipelineInput)
pub mod create_pipeline_input {
    /// A builder for [`CreatePipelineInput`](crate::input::CreatePipelineInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_name: std::option::Option<std::string::String>,
        pub(crate) pipeline_display_name: std::option::Option<std::string::String>,
        pub(crate) pipeline_definition: std::option::Option<std::string::String>,
        pub(crate) pipeline_description: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the pipeline.</p>
        pub fn pipeline_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_name = Some(input.into());
            self
        }
        /// <p>The name of the pipeline.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_name = input;
            self
        }
        /// <p>The display name of the pipeline.</p>
        pub fn pipeline_display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_display_name = Some(input.into());
            self
        }
        /// <p>The display name of the pipeline.</p>
        pub fn set_pipeline_display_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_display_name = input;
            self
        }
        /// <p>The JSON pipeline definition of the pipeline.</p>
        pub fn pipeline_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_definition = Some(input.into());
            self
        }
        /// <p>The JSON pipeline definition of the pipeline.</p>
        pub fn set_pipeline_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_definition = input;
            self
        }
        /// <p>A description of the pipeline.</p>
        pub fn pipeline_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_description = Some(input.into());
            self
        }
        /// <p>A description of the pipeline.</p>
        pub fn set_pipeline_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_description = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// operation. An idempotent operation completes no more than one time.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// operation. An idempotent operation completes no more than one time.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role used by the pipeline to access and create resources.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role used by the pipeline to access and create resources.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to apply to the created pipeline.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to apply to the created pipeline.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePipelineInput`](crate::input::CreatePipelineInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePipelineInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePipelineInput {
                pipeline_name: self.pipeline_name,
                pipeline_display_name: self.pipeline_display_name,
                pipeline_definition: self.pipeline_definition,
                pipeline_description: self.pipeline_description,
                client_request_token: self.client_request_token,
                role_arn: self.role_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePipelineInputOperationOutputAlias = crate::operation::CreatePipeline;
#[doc(hidden)]
pub type CreatePipelineInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreatePipelineInput {
    /// Consumes the builder and constructs an Operation<[`CreatePipeline`](crate::operation::CreatePipeline)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePipeline,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreatePipelineInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreatePipelineInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreatePipelineInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreatePipeline",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_pipeline(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePipeline::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePipeline",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreatePipelineInput`](crate::input::CreatePipelineInput)
    pub fn builder() -> crate::input::create_pipeline_input::Builder {
        crate::input::create_pipeline_input::Builder::default()
    }
}

/// See [`CreatePresignedDomainUrlInput`](crate::input::CreatePresignedDomainUrlInput)
pub mod create_presigned_domain_url_input {
    /// A builder for [`CreatePresignedDomainUrlInput`](crate::input::CreatePresignedDomainUrlInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_id: std::option::Option<std::string::String>,
        pub(crate) user_profile_name: std::option::Option<std::string::String>,
        pub(crate) session_expiration_duration_in_seconds: std::option::Option<i32>,
        pub(crate) expires_in_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The domain ID.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_id = Some(input.into());
            self
        }
        /// <p>The domain ID.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_id = input;
            self
        }
        /// <p>The name of the UserProfile to sign-in as.</p>
        pub fn user_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_profile_name = Some(input.into());
            self
        }
        /// <p>The name of the UserProfile to sign-in as.</p>
        pub fn set_user_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_profile_name = input;
            self
        }
        /// <p>The session expiration duration in seconds. This value defaults to 43200.</p>
        pub fn session_expiration_duration_in_seconds(mut self, input: i32) -> Self {
            self.session_expiration_duration_in_seconds = Some(input);
            self
        }
        /// <p>The session expiration duration in seconds. This value defaults to 43200.</p>
        pub fn set_session_expiration_duration_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.session_expiration_duration_in_seconds = input;
            self
        }
        /// <p>The number of seconds until the pre-signed URL expires. This value defaults to
        /// 300.</p>
        pub fn expires_in_seconds(mut self, input: i32) -> Self {
            self.expires_in_seconds = Some(input);
            self
        }
        /// <p>The number of seconds until the pre-signed URL expires. This value defaults to
        /// 300.</p>
        pub fn set_expires_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.expires_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePresignedDomainUrlInput`](crate::input::CreatePresignedDomainUrlInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePresignedDomainUrlInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePresignedDomainUrlInput {
                domain_id: self.domain_id,
                user_profile_name: self.user_profile_name,
                session_expiration_duration_in_seconds: self.session_expiration_duration_in_seconds,
                expires_in_seconds: self.expires_in_seconds,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePresignedDomainUrlInputOperationOutputAlias =
    crate::operation::CreatePresignedDomainUrl;
#[doc(hidden)]
pub type CreatePresignedDomainUrlInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreatePresignedDomainUrlInput {
    /// Consumes the builder and constructs an Operation<[`CreatePresignedDomainUrl`](crate::operation::CreatePresignedDomainUrl)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePresignedDomainUrl,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreatePresignedDomainUrlInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreatePresignedDomainUrlInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreatePresignedDomainUrlInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreatePresignedDomainUrl",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_presigned_domain_url(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePresignedDomainUrl::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePresignedDomainUrl",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreatePresignedDomainUrlInput`](crate::input::CreatePresignedDomainUrlInput)
    pub fn builder() -> crate::input::create_presigned_domain_url_input::Builder {
        crate::input::create_presigned_domain_url_input::Builder::default()
    }
}

/// See [`CreatePresignedNotebookInstanceUrlInput`](crate::input::CreatePresignedNotebookInstanceUrlInput)
pub mod create_presigned_notebook_instance_url_input {
    /// A builder for [`CreatePresignedNotebookInstanceUrlInput`](crate::input::CreatePresignedNotebookInstanceUrlInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notebook_instance_name: std::option::Option<std::string::String>,
        pub(crate) session_expiration_duration_in_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the notebook instance.</p>
        pub fn notebook_instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.notebook_instance_name = Some(input.into());
            self
        }
        /// <p>The name of the notebook instance.</p>
        pub fn set_notebook_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notebook_instance_name = input;
            self
        }
        /// <p>The duration of the session, in seconds. The default is 12 hours.</p>
        pub fn session_expiration_duration_in_seconds(mut self, input: i32) -> Self {
            self.session_expiration_duration_in_seconds = Some(input);
            self
        }
        /// <p>The duration of the session, in seconds. The default is 12 hours.</p>
        pub fn set_session_expiration_duration_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.session_expiration_duration_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePresignedNotebookInstanceUrlInput`](crate::input::CreatePresignedNotebookInstanceUrlInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePresignedNotebookInstanceUrlInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePresignedNotebookInstanceUrlInput {
                notebook_instance_name: self.notebook_instance_name,
                session_expiration_duration_in_seconds: self.session_expiration_duration_in_seconds,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePresignedNotebookInstanceUrlInputOperationOutputAlias =
    crate::operation::CreatePresignedNotebookInstanceUrl;
#[doc(hidden)]
pub type CreatePresignedNotebookInstanceUrlInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreatePresignedNotebookInstanceUrlInput {
    /// Consumes the builder and constructs an Operation<[`CreatePresignedNotebookInstanceUrl`](crate::operation::CreatePresignedNotebookInstanceUrl)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePresignedNotebookInstanceUrl,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreatePresignedNotebookInstanceUrlInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreatePresignedNotebookInstanceUrlInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreatePresignedNotebookInstanceUrlInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreatePresignedNotebookInstanceUrl",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_presigned_notebook_instance_url(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePresignedNotebookInstanceUrl::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePresignedNotebookInstanceUrl",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreatePresignedNotebookInstanceUrlInput`](crate::input::CreatePresignedNotebookInstanceUrlInput)
    pub fn builder() -> crate::input::create_presigned_notebook_instance_url_input::Builder {
        crate::input::create_presigned_notebook_instance_url_input::Builder::default()
    }
}

/// See [`CreateProcessingJobInput`](crate::input::CreateProcessingJobInput)
pub mod create_processing_job_input {
    /// A builder for [`CreateProcessingJobInput`](crate::input::CreateProcessingJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) processing_inputs:
            std::option::Option<std::vec::Vec<crate::model::ProcessingInput>>,
        pub(crate) processing_output_config:
            std::option::Option<crate::model::ProcessingOutputConfig>,
        pub(crate) processing_job_name: std::option::Option<std::string::String>,
        pub(crate) processing_resources: std::option::Option<crate::model::ProcessingResources>,
        pub(crate) stopping_condition:
            std::option::Option<crate::model::ProcessingStoppingCondition>,
        pub(crate) app_specification: std::option::Option<crate::model::AppSpecification>,
        pub(crate) environment: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) network_config: std::option::Option<crate::model::NetworkConfig>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) experiment_config: std::option::Option<crate::model::ExperimentConfig>,
    }
    impl Builder {
        /// Appends an item to `processing_inputs`.
        ///
        /// To override the contents of this collection use [`set_processing_inputs`](Self::set_processing_inputs).
        ///
        /// <p>An array of inputs configuring the data to download into the
        /// processing container.</p>
        pub fn processing_inputs(
            mut self,
            input: impl Into<crate::model::ProcessingInput>,
        ) -> Self {
            let mut v = self.processing_inputs.unwrap_or_default();
            v.push(input.into());
            self.processing_inputs = Some(v);
            self
        }
        /// <p>An array of inputs configuring the data to download into the
        /// processing container.</p>
        pub fn set_processing_inputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProcessingInput>>,
        ) -> Self {
            self.processing_inputs = input;
            self
        }
        /// <p>Output configuration for the processing job.</p>
        pub fn processing_output_config(
            mut self,
            input: crate::model::ProcessingOutputConfig,
        ) -> Self {
            self.processing_output_config = Some(input);
            self
        }
        /// <p>Output configuration for the processing job.</p>
        pub fn set_processing_output_config(
            mut self,
            input: std::option::Option<crate::model::ProcessingOutputConfig>,
        ) -> Self {
            self.processing_output_config = input;
            self
        }
        /// <p> The name of the processing job. The name must be unique within an Amazon Web Services Region in the
        /// Amazon Web Services account.</p>
        pub fn processing_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.processing_job_name = Some(input.into());
            self
        }
        /// <p> The name of the processing job. The name must be unique within an Amazon Web Services Region in the
        /// Amazon Web Services account.</p>
        pub fn set_processing_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.processing_job_name = input;
            self
        }
        /// <p>Identifies the resources, ML compute instances, and ML storage volumes to deploy for a
        /// processing job. In distributed training, you specify more than one instance.</p>
        pub fn processing_resources(mut self, input: crate::model::ProcessingResources) -> Self {
            self.processing_resources = Some(input);
            self
        }
        /// <p>Identifies the resources, ML compute instances, and ML storage volumes to deploy for a
        /// processing job. In distributed training, you specify more than one instance.</p>
        pub fn set_processing_resources(
            mut self,
            input: std::option::Option<crate::model::ProcessingResources>,
        ) -> Self {
            self.processing_resources = input;
            self
        }
        /// <p>The time limit for how long the processing job is allowed to run.</p>
        pub fn stopping_condition(
            mut self,
            input: crate::model::ProcessingStoppingCondition,
        ) -> Self {
            self.stopping_condition = Some(input);
            self
        }
        /// <p>The time limit for how long the processing job is allowed to run.</p>
        pub fn set_stopping_condition(
            mut self,
            input: std::option::Option<crate::model::ProcessingStoppingCondition>,
        ) -> Self {
            self.stopping_condition = input;
            self
        }
        /// <p>Configures the processing job to run a specified Docker container image.</p>
        pub fn app_specification(mut self, input: crate::model::AppSpecification) -> Self {
            self.app_specification = Some(input);
            self
        }
        /// <p>Configures the processing job to run a specified Docker container image.</p>
        pub fn set_app_specification(
            mut self,
            input: std::option::Option<crate::model::AppSpecification>,
        ) -> Self {
            self.app_specification = input;
            self
        }
        /// Adds a key-value pair to `environment`.
        ///
        /// To override the contents of this collection use [`set_environment`](Self::set_environment).
        ///
        /// <p>The environment variables to set in the Docker container. Up to
        /// 100 key and values entries in the map are supported.</p>
        pub fn environment(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.environment.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.environment = Some(hash_map);
            self
        }
        /// <p>The environment variables to set in the Docker container. Up to
        /// 100 key and values entries in the map are supported.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.environment = input;
            self
        }
        /// <p>Networking options for a processing job, such as whether to allow inbound and
        /// outbound network calls to and from processing containers, and the VPC subnets and
        /// security groups to use for VPC-enabled processing jobs.</p>
        pub fn network_config(mut self, input: crate::model::NetworkConfig) -> Self {
            self.network_config = Some(input);
            self
        }
        /// <p>Networking options for a processing job, such as whether to allow inbound and
        /// outbound network calls to and from processing containers, and the VPC subnets and
        /// security groups to use for VPC-enabled processing jobs.</p>
        pub fn set_network_config(
            mut self,
            input: std::option::Option<crate::model::NetworkConfig>,
        ) -> Self {
            self.network_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on
        /// your behalf.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on
        /// your behalf.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management
        /// User Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management
        /// User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Associates a SageMaker job as a trial component with an experiment and trial. Specified when
        /// you call the following APIs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a>CreateProcessingJob</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>CreateTrainingJob</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>CreateTransformJob</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn experiment_config(mut self, input: crate::model::ExperimentConfig) -> Self {
            self.experiment_config = Some(input);
            self
        }
        /// <p>Associates a SageMaker job as a trial component with an experiment and trial. Specified when
        /// you call the following APIs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a>CreateProcessingJob</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>CreateTrainingJob</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>CreateTransformJob</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_experiment_config(
            mut self,
            input: std::option::Option<crate::model::ExperimentConfig>,
        ) -> Self {
            self.experiment_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProcessingJobInput`](crate::input::CreateProcessingJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateProcessingJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateProcessingJobInput {
                processing_inputs: self.processing_inputs,
                processing_output_config: self.processing_output_config,
                processing_job_name: self.processing_job_name,
                processing_resources: self.processing_resources,
                stopping_condition: self.stopping_condition,
                app_specification: self.app_specification,
                environment: self.environment,
                network_config: self.network_config,
                role_arn: self.role_arn,
                tags: self.tags,
                experiment_config: self.experiment_config,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateProcessingJobInputOperationOutputAlias = crate::operation::CreateProcessingJob;
#[doc(hidden)]
pub type CreateProcessingJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateProcessingJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateProcessingJob`](crate::operation::CreateProcessingJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateProcessingJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateProcessingJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateProcessingJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateProcessingJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateProcessingJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_processing_job(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateProcessingJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateProcessingJob",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateProcessingJobInput`](crate::input::CreateProcessingJobInput)
    pub fn builder() -> crate::input::create_processing_job_input::Builder {
        crate::input::create_processing_job_input::Builder::default()
    }
}

/// See [`CreateProjectInput`](crate::input::CreateProjectInput)
pub mod create_project_input {
    /// A builder for [`CreateProjectInput`](crate::input::CreateProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) project_description: std::option::Option<std::string::String>,
        pub(crate) service_catalog_provisioning_details:
            std::option::Option<crate::model::ServiceCatalogProvisioningDetails>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the project.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>A description for the project.</p>
        pub fn project_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_description = Some(input.into());
            self
        }
        /// <p>A description for the project.</p>
        pub fn set_project_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.project_description = input;
            self
        }
        /// <p>The product ID and provisioning artifact ID to provision a service catalog. The provisioning
        /// artifact ID will default to the latest provisioning artifact ID of the product, if you don't
        /// provide the provisioning artifact ID. For more information, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services Service
        /// Catalog</a>.</p>
        pub fn service_catalog_provisioning_details(
            mut self,
            input: crate::model::ServiceCatalogProvisioningDetails,
        ) -> Self {
            self.service_catalog_provisioning_details = Some(input);
            self
        }
        /// <p>The product ID and provisioning artifact ID to provision a service catalog. The provisioning
        /// artifact ID will default to the latest provisioning artifact ID of the product, if you don't
        /// provide the provisioning artifact ID. For more information, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services Service
        /// Catalog</a>.</p>
        pub fn set_service_catalog_provisioning_details(
            mut self,
            input: std::option::Option<crate::model::ServiceCatalogProvisioningDetails>,
        ) -> Self {
            self.service_catalog_provisioning_details = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs that you want to use to organize and track your Amazon Web Services
        /// resource costs. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>An array of key-value pairs that you want to use to organize and track your Amazon Web Services
        /// resource costs. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProjectInput`](crate::input::CreateProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateProjectInput {
                project_name: self.project_name,
                project_description: self.project_description,
                service_catalog_provisioning_details: self.service_catalog_provisioning_details,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateProjectInputOperationOutputAlias = crate::operation::CreateProject;
#[doc(hidden)]
pub type CreateProjectInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateProjectInput {
    /// Consumes the builder and constructs an Operation<[`CreateProject`](crate::operation::CreateProject)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateProject,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateProjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateProjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateProjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateProject",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_project(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateProject",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateProjectInput`](crate::input::CreateProjectInput)
    pub fn builder() -> crate::input::create_project_input::Builder {
        crate::input::create_project_input::Builder::default()
    }
}

/// See [`CreateStudioLifecycleConfigInput`](crate::input::CreateStudioLifecycleConfigInput)
pub mod create_studio_lifecycle_config_input {
    /// A builder for [`CreateStudioLifecycleConfigInput`](crate::input::CreateStudioLifecycleConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) studio_lifecycle_config_name: std::option::Option<std::string::String>,
        pub(crate) studio_lifecycle_config_content: std::option::Option<std::string::String>,
        pub(crate) studio_lifecycle_config_app_type:
            std::option::Option<crate::model::StudioLifecycleConfigAppType>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the Studio Lifecycle Configuration to create.</p>
        pub fn studio_lifecycle_config_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.studio_lifecycle_config_name = Some(input.into());
            self
        }
        /// <p>The name of the Studio Lifecycle Configuration to create.</p>
        pub fn set_studio_lifecycle_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.studio_lifecycle_config_name = input;
            self
        }
        /// <p>The content of your Studio Lifecycle Configuration script. This content must be base64 encoded.</p>
        pub fn studio_lifecycle_config_content(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.studio_lifecycle_config_content = Some(input.into());
            self
        }
        /// <p>The content of your Studio Lifecycle Configuration script. This content must be base64 encoded.</p>
        pub fn set_studio_lifecycle_config_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.studio_lifecycle_config_content = input;
            self
        }
        /// <p>The App type that the Lifecycle Configuration is attached to.</p>
        pub fn studio_lifecycle_config_app_type(
            mut self,
            input: crate::model::StudioLifecycleConfigAppType,
        ) -> Self {
            self.studio_lifecycle_config_app_type = Some(input);
            self
        }
        /// <p>The App type that the Lifecycle Configuration is attached to.</p>
        pub fn set_studio_lifecycle_config_app_type(
            mut self,
            input: std::option::Option<crate::model::StudioLifecycleConfigAppType>,
        ) -> Self {
            self.studio_lifecycle_config_app_type = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to be associated with the Lifecycle Configuration. Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the Search API. </p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Tags to be associated with the Lifecycle Configuration. Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the Search API. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStudioLifecycleConfigInput`](crate::input::CreateStudioLifecycleConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateStudioLifecycleConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateStudioLifecycleConfigInput {
                studio_lifecycle_config_name: self.studio_lifecycle_config_name,
                studio_lifecycle_config_content: self.studio_lifecycle_config_content,
                studio_lifecycle_config_app_type: self.studio_lifecycle_config_app_type,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateStudioLifecycleConfigInputOperationOutputAlias =
    crate::operation::CreateStudioLifecycleConfig;
#[doc(hidden)]
pub type CreateStudioLifecycleConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateStudioLifecycleConfigInput {
    /// Consumes the builder and constructs an Operation<[`CreateStudioLifecycleConfig`](crate::operation::CreateStudioLifecycleConfig)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateStudioLifecycleConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateStudioLifecycleConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateStudioLifecycleConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateStudioLifecycleConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateStudioLifecycleConfig",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_studio_lifecycle_config(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateStudioLifecycleConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateStudioLifecycleConfig",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateStudioLifecycleConfigInput`](crate::input::CreateStudioLifecycleConfigInput)
    pub fn builder() -> crate::input::create_studio_lifecycle_config_input::Builder {
        crate::input::create_studio_lifecycle_config_input::Builder::default()
    }
}

/// See [`CreateTrainingJobInput`](crate::input::CreateTrainingJobInput)
pub mod create_training_job_input {
    /// A builder for [`CreateTrainingJobInput`](crate::input::CreateTrainingJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) training_job_name: std::option::Option<std::string::String>,
        pub(crate) hyper_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) algorithm_specification:
            std::option::Option<crate::model::AlgorithmSpecification>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) input_data_config: std::option::Option<std::vec::Vec<crate::model::Channel>>,
        pub(crate) output_data_config: std::option::Option<crate::model::OutputDataConfig>,
        pub(crate) resource_config: std::option::Option<crate::model::ResourceConfig>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
        pub(crate) stopping_condition: std::option::Option<crate::model::StoppingCondition>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) enable_network_isolation: std::option::Option<bool>,
        pub(crate) enable_inter_container_traffic_encryption: std::option::Option<bool>,
        pub(crate) enable_managed_spot_training: std::option::Option<bool>,
        pub(crate) checkpoint_config: std::option::Option<crate::model::CheckpointConfig>,
        pub(crate) debug_hook_config: std::option::Option<crate::model::DebugHookConfig>,
        pub(crate) debug_rule_configurations:
            std::option::Option<std::vec::Vec<crate::model::DebugRuleConfiguration>>,
        pub(crate) tensor_board_output_config:
            std::option::Option<crate::model::TensorBoardOutputConfig>,
        pub(crate) experiment_config: std::option::Option<crate::model::ExperimentConfig>,
        pub(crate) profiler_config: std::option::Option<crate::model::ProfilerConfig>,
        pub(crate) profiler_rule_configurations:
            std::option::Option<std::vec::Vec<crate::model::ProfilerRuleConfiguration>>,
        pub(crate) environment: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) retry_strategy: std::option::Option<crate::model::RetryStrategy>,
    }
    impl Builder {
        /// <p>The name of the training job. The name must be unique within an Amazon Web Services Region in an
        /// Amazon Web Services account. </p>
        pub fn training_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.training_job_name = Some(input.into());
            self
        }
        /// <p>The name of the training job. The name must be unique within an Amazon Web Services Region in an
        /// Amazon Web Services account. </p>
        pub fn set_training_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.training_job_name = input;
            self
        }
        /// Adds a key-value pair to `hyper_parameters`.
        ///
        /// To override the contents of this collection use [`set_hyper_parameters`](Self::set_hyper_parameters).
        ///
        /// <p>Algorithm-specific parameters that influence the quality of the model. You set
        /// hyperparameters before you start the learning process. For a list of hyperparameters for
        /// each training algorithm provided by Amazon SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. </p>
        /// <p>You can specify a maximum of 100 hyperparameters. Each hyperparameter is a
        /// key-value pair. Each key and value is limited to 256 characters, as specified by the
        /// <code>Length Constraint</code>. </p>
        pub fn hyper_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.hyper_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.hyper_parameters = Some(hash_map);
            self
        }
        /// <p>Algorithm-specific parameters that influence the quality of the model. You set
        /// hyperparameters before you start the learning process. For a list of hyperparameters for
        /// each training algorithm provided by Amazon SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. </p>
        /// <p>You can specify a maximum of 100 hyperparameters. Each hyperparameter is a
        /// key-value pair. Each key and value is limited to 256 characters, as specified by the
        /// <code>Length Constraint</code>. </p>
        pub fn set_hyper_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.hyper_parameters = input;
            self
        }
        /// <p>The registry path of the Docker image that contains the training algorithm and
        /// algorithm-specific metadata, including the input mode. For more information about
        /// algorithms provided by Amazon SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. For information about
        /// providing your own algorithms, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon
        /// SageMaker</a>. </p>
        pub fn algorithm_specification(
            mut self,
            input: crate::model::AlgorithmSpecification,
        ) -> Self {
            self.algorithm_specification = Some(input);
            self
        }
        /// <p>The registry path of the Docker image that contains the training algorithm and
        /// algorithm-specific metadata, including the input mode. For more information about
        /// algorithms provided by Amazon SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. For information about
        /// providing your own algorithms, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon
        /// SageMaker</a>. </p>
        pub fn set_algorithm_specification(
            mut self,
            input: std::option::Option<crate::model::AlgorithmSpecification>,
        ) -> Self {
            self.algorithm_specification = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform
        /// tasks on your behalf. </p>
        /// <p>During model training, Amazon SageMaker needs your permission to read input data from an S3
        /// bucket, download a Docker image that contains training code, write model artifacts to an
        /// S3 bucket, write logs to Amazon CloudWatch Logs, and publish metrics to Amazon CloudWatch. You grant
        /// permissions for all of these tasks to an IAM role. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker
        /// Roles</a>. </p>
        /// <note>
        /// <p>To be able to pass this role to Amazon SageMaker, the caller of this API must have the
        /// <code>iam:PassRole</code> permission.</p>
        /// </note>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform
        /// tasks on your behalf. </p>
        /// <p>During model training, Amazon SageMaker needs your permission to read input data from an S3
        /// bucket, download a Docker image that contains training code, write model artifacts to an
        /// S3 bucket, write logs to Amazon CloudWatch Logs, and publish metrics to Amazon CloudWatch. You grant
        /// permissions for all of these tasks to an IAM role. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker
        /// Roles</a>. </p>
        /// <note>
        /// <p>To be able to pass this role to Amazon SageMaker, the caller of this API must have the
        /// <code>iam:PassRole</code> permission.</p>
        /// </note>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `input_data_config`.
        ///
        /// To override the contents of this collection use [`set_input_data_config`](Self::set_input_data_config).
        ///
        /// <p>An array of <code>Channel</code> objects. Each channel is a named input source.
        /// <code>InputDataConfig</code>
        /// describes the input data and its location. </p>
        /// <p>Algorithms can accept input data from one or more channels. For example, an
        /// algorithm might have two channels of input data, <code>training_data</code> and
        /// <code>validation_data</code>. The configuration for each channel provides the S3,
        /// EFS, or FSx location where the input data is stored. It also provides information about
        /// the stored data: the MIME type, compression method, and whether the data is wrapped in
        /// RecordIO format. </p>
        /// <p>Depending on the input mode that the algorithm supports, Amazon SageMaker either copies input
        /// data files from an S3 bucket to a local directory in the Docker container, or makes it
        /// available as input streams. For example, if you specify an EFS location, input data
        /// files will be made available as input streams. They do not need to be
        /// downloaded.</p>
        pub fn input_data_config(mut self, input: impl Into<crate::model::Channel>) -> Self {
            let mut v = self.input_data_config.unwrap_or_default();
            v.push(input.into());
            self.input_data_config = Some(v);
            self
        }
        /// <p>An array of <code>Channel</code> objects. Each channel is a named input source.
        /// <code>InputDataConfig</code>
        /// describes the input data and its location. </p>
        /// <p>Algorithms can accept input data from one or more channels. For example, an
        /// algorithm might have two channels of input data, <code>training_data</code> and
        /// <code>validation_data</code>. The configuration for each channel provides the S3,
        /// EFS, or FSx location where the input data is stored. It also provides information about
        /// the stored data: the MIME type, compression method, and whether the data is wrapped in
        /// RecordIO format. </p>
        /// <p>Depending on the input mode that the algorithm supports, Amazon SageMaker either copies input
        /// data files from an S3 bucket to a local directory in the Docker container, or makes it
        /// available as input streams. For example, if you specify an EFS location, input data
        /// files will be made available as input streams. They do not need to be
        /// downloaded.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Channel>>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p>Specifies the path to the S3 location where you want to store model artifacts. Amazon SageMaker
        /// creates subfolders for the artifacts. </p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.output_data_config = Some(input);
            self
        }
        /// <p>Specifies the path to the S3 location where you want to store model artifacts. Amazon SageMaker
        /// creates subfolders for the artifacts. </p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.output_data_config = input;
            self
        }
        /// <p>The resources, including the ML compute instances and ML storage volumes, to use
        /// for model training. </p>
        /// <p>ML storage volumes store model artifacts and incremental states. Training
        /// algorithms might also use ML storage volumes for scratch space. If you want Amazon SageMaker to use
        /// the ML storage volume to store the training data, choose <code>File</code> as the
        /// <code>TrainingInputMode</code> in the algorithm specification. For distributed
        /// training algorithms, specify an instance count greater than 1.</p>
        pub fn resource_config(mut self, input: crate::model::ResourceConfig) -> Self {
            self.resource_config = Some(input);
            self
        }
        /// <p>The resources, including the ML compute instances and ML storage volumes, to use
        /// for model training. </p>
        /// <p>ML storage volumes store model artifacts and incremental states. Training
        /// algorithms might also use ML storage volumes for scratch space. If you want Amazon SageMaker to use
        /// the ML storage volume to store the training data, choose <code>File</code> as the
        /// <code>TrainingInputMode</code> in the algorithm specification. For distributed
        /// training algorithms, specify an instance count greater than 1.</p>
        pub fn set_resource_config(
            mut self,
            input: std::option::Option<crate::model::ResourceConfig>,
        ) -> Self {
            self.resource_config = input;
            self
        }
        /// <p>A <a>VpcConfig</a> object that specifies the VPC that you want your
        /// training job to connect to. Control access to and from your training container by
        /// configuring the VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an Amazon
        /// Virtual Private Cloud</a>.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>A <a>VpcConfig</a> object that specifies the VPC that you want your
        /// training job to connect to. Control access to and from your training container by
        /// configuring the VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an Amazon
        /// Virtual Private Cloud</a>.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>Specifies a limit to how long a model training job can run. It also specifies how long
        /// a managed Spot training job has to complete. When the job reaches the time limit, Amazon SageMaker
        /// ends the training job. Use this API to cap model training costs.</p>
        /// <p>To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays
        /// job termination for 120 seconds. Algorithms can use this 120-second window to save the
        /// model artifacts, so the results of training are not lost. </p>
        pub fn stopping_condition(mut self, input: crate::model::StoppingCondition) -> Self {
            self.stopping_condition = Some(input);
            self
        }
        /// <p>Specifies a limit to how long a model training job can run. It also specifies how long
        /// a managed Spot training job has to complete. When the job reaches the time limit, Amazon SageMaker
        /// ends the training job. Use this API to cap model training costs.</p>
        /// <p>To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays
        /// job termination for 120 seconds. Algorithms can use this 120-second window to save the
        /// model artifacts, so the results of training are not lost. </p>
        pub fn set_stopping_condition(
            mut self,
            input: std::option::Option<crate::model::StoppingCondition>,
        ) -> Self {
            self.stopping_condition = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
        /// different ways, for example, by purpose, owner, or environment. For more information,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// Resources</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
        /// different ways, for example, by purpose, owner, or environment. For more information,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
        /// Resources</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Isolates the training container. No inbound or outbound network calls can be made,
        /// except for calls between peers within a training cluster for distributed training. If
        /// you enable network isolation for training jobs that are configured to use a VPC, Amazon SageMaker
        /// downloads and uploads customer data and model artifacts through the specified VPC, but
        /// the training container does not have network access.</p>
        pub fn enable_network_isolation(mut self, input: bool) -> Self {
            self.enable_network_isolation = Some(input);
            self
        }
        /// <p>Isolates the training container. No inbound or outbound network calls can be made,
        /// except for calls between peers within a training cluster for distributed training. If
        /// you enable network isolation for training jobs that are configured to use a VPC, Amazon SageMaker
        /// downloads and uploads customer data and model artifacts through the specified VPC, but
        /// the training container does not have network access.</p>
        pub fn set_enable_network_isolation(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_network_isolation = input;
            self
        }
        /// <p>To encrypt all communications between ML compute instances in distributed training,
        /// choose <code>True</code>. Encryption provides greater security for distributed training,
        /// but training might take longer. How long it takes depends on the amount of communication
        /// between compute instances, especially if you use a deep learning algorithm in
        /// distributed training. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-encrypt.html">Protect Communications Between ML
        /// Compute Instances in a Distributed Training Job</a>.</p>
        pub fn enable_inter_container_traffic_encryption(mut self, input: bool) -> Self {
            self.enable_inter_container_traffic_encryption = Some(input);
            self
        }
        /// <p>To encrypt all communications between ML compute instances in distributed training,
        /// choose <code>True</code>. Encryption provides greater security for distributed training,
        /// but training might take longer. How long it takes depends on the amount of communication
        /// between compute instances, especially if you use a deep learning algorithm in
        /// distributed training. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-encrypt.html">Protect Communications Between ML
        /// Compute Instances in a Distributed Training Job</a>.</p>
        pub fn set_enable_inter_container_traffic_encryption(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_inter_container_traffic_encryption = input;
            self
        }
        /// <p>To train models using managed spot training, choose <code>True</code>. Managed spot
        /// training provides a fully managed and scalable infrastructure for training machine
        /// learning models. this option is useful when training jobs can be interrupted and when
        /// there is flexibility when the training job is run. </p>
        /// <p>The complete and intermediate results of jobs are stored in an Amazon S3 bucket, and can be
        /// used as a starting point to train models incrementally. Amazon SageMaker provides metrics and
        /// logs in CloudWatch. They can be used to see when managed spot training jobs are running,
        /// interrupted, resumed, or completed. </p>
        pub fn enable_managed_spot_training(mut self, input: bool) -> Self {
            self.enable_managed_spot_training = Some(input);
            self
        }
        /// <p>To train models using managed spot training, choose <code>True</code>. Managed spot
        /// training provides a fully managed and scalable infrastructure for training machine
        /// learning models. this option is useful when training jobs can be interrupted and when
        /// there is flexibility when the training job is run. </p>
        /// <p>The complete and intermediate results of jobs are stored in an Amazon S3 bucket, and can be
        /// used as a starting point to train models incrementally. Amazon SageMaker provides metrics and
        /// logs in CloudWatch. They can be used to see when managed spot training jobs are running,
        /// interrupted, resumed, or completed. </p>
        pub fn set_enable_managed_spot_training(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_managed_spot_training = input;
            self
        }
        /// <p>Contains information about the output location for managed spot training checkpoint
        /// data.</p>
        pub fn checkpoint_config(mut self, input: crate::model::CheckpointConfig) -> Self {
            self.checkpoint_config = Some(input);
            self
        }
        /// <p>Contains information about the output location for managed spot training checkpoint
        /// data.</p>
        pub fn set_checkpoint_config(
            mut self,
            input: std::option::Option<crate::model::CheckpointConfig>,
        ) -> Self {
            self.checkpoint_config = input;
            self
        }
        /// <p>Configuration information for the Debugger hook parameters, metric and tensor collections, and
        /// storage paths. To learn more about
        /// how to configure the <code>DebugHookConfig</code> parameter,
        /// see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html">Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job</a>.</p>
        pub fn debug_hook_config(mut self, input: crate::model::DebugHookConfig) -> Self {
            self.debug_hook_config = Some(input);
            self
        }
        /// <p>Configuration information for the Debugger hook parameters, metric and tensor collections, and
        /// storage paths. To learn more about
        /// how to configure the <code>DebugHookConfig</code> parameter,
        /// see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html">Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job</a>.</p>
        pub fn set_debug_hook_config(
            mut self,
            input: std::option::Option<crate::model::DebugHookConfig>,
        ) -> Self {
            self.debug_hook_config = input;
            self
        }
        /// Appends an item to `debug_rule_configurations`.
        ///
        /// To override the contents of this collection use [`set_debug_rule_configurations`](Self::set_debug_rule_configurations).
        ///
        /// <p>Configuration information for Debugger rules for debugging output tensors.</p>
        pub fn debug_rule_configurations(
            mut self,
            input: impl Into<crate::model::DebugRuleConfiguration>,
        ) -> Self {
            let mut v = self.debug_rule_configurations.unwrap_or_default();
            v.push(input.into());
            self.debug_rule_configurations = Some(v);
            self
        }
        /// <p>Configuration information for Debugger rules for debugging output tensors.</p>
        pub fn set_debug_rule_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DebugRuleConfiguration>>,
        ) -> Self {
            self.debug_rule_configurations = input;
            self
        }
        /// <p>Configuration of storage locations for the Debugger TensorBoard output data.</p>
        pub fn tensor_board_output_config(
            mut self,
            input: crate::model::TensorBoardOutputConfig,
        ) -> Self {
            self.tensor_board_output_config = Some(input);
            self
        }
        /// <p>Configuration of storage locations for the Debugger TensorBoard output data.</p>
        pub fn set_tensor_board_output_config(
            mut self,
            input: std::option::Option<crate::model::TensorBoardOutputConfig>,
        ) -> Self {
            self.tensor_board_output_config = input;
            self
        }
        /// <p>Associates a SageMaker job as a trial component with an experiment and trial. Specified when
        /// you call the following APIs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a>CreateProcessingJob</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>CreateTrainingJob</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>CreateTransformJob</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn experiment_config(mut self, input: crate::model::ExperimentConfig) -> Self {
            self.experiment_config = Some(input);
            self
        }
        /// <p>Associates a SageMaker job as a trial component with an experiment and trial. Specified when
        /// you call the following APIs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a>CreateProcessingJob</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>CreateTrainingJob</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>CreateTransformJob</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_experiment_config(
            mut self,
            input: std::option::Option<crate::model::ExperimentConfig>,
        ) -> Self {
            self.experiment_config = input;
            self
        }
        /// <p>Configuration information for Debugger system monitoring, framework profiling, and
        /// storage paths.</p>
        pub fn profiler_config(mut self, input: crate::model::ProfilerConfig) -> Self {
            self.profiler_config = Some(input);
            self
        }
        /// <p>Configuration information for Debugger system monitoring, framework profiling, and
        /// storage paths.</p>
        pub fn set_profiler_config(
            mut self,
            input: std::option::Option<crate::model::ProfilerConfig>,
        ) -> Self {
            self.profiler_config = input;
            self
        }
        /// Appends an item to `profiler_rule_configurations`.
        ///
        /// To override the contents of this collection use [`set_profiler_rule_configurations`](Self::set_profiler_rule_configurations).
        ///
        /// <p>Configuration information for Debugger rules for profiling system and framework
        /// metrics.</p>
        pub fn profiler_rule_configurations(
            mut self,
            input: impl Into<crate::model::ProfilerRuleConfiguration>,
        ) -> Self {
            let mut v = self.profiler_rule_configurations.unwrap_or_default();
            v.push(input.into());
            self.profiler_rule_configurations = Some(v);
            self
        }
        /// <p>Configuration information for Debugger rules for profiling system and framework
        /// metrics.</p>
        pub fn set_profiler_rule_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProfilerRuleConfiguration>>,
        ) -> Self {
            self.profiler_rule_configurations = input;
            self
        }
        /// Adds a key-value pair to `environment`.
        ///
        /// To override the contents of this collection use [`set_environment`](Self::set_environment).
        ///
        /// <p>The environment variables to set in the Docker container.</p>
        pub fn environment(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.environment.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.environment = Some(hash_map);
            self
        }
        /// <p>The environment variables to set in the Docker container.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.environment = input;
            self
        }
        /// <p>The number of times to retry the job when the job fails due to an
        /// <code>InternalServerError</code>.</p>
        pub fn retry_strategy(mut self, input: crate::model::RetryStrategy) -> Self {
            self.retry_strategy = Some(input);
            self
        }
        /// <p>The number of times to retry the job when the job fails due to an
        /// <code>InternalServerError</code>.</p>
        pub fn set_retry_strategy(
            mut self,
            input: std::option::Option<crate::model::RetryStrategy>,
        ) -> Self {
            self.retry_strategy = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTrainingJobInput`](crate::input::CreateTrainingJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTrainingJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTrainingJobInput {
                training_job_name: self.training_job_name,
                hyper_parameters: self.hyper_parameters,
                algorithm_specification: self.algorithm_specification,
                role_arn: self.role_arn,
                input_data_config: self.input_data_config,
                output_data_config: self.output_data_config,
                resource_config: self.resource_config,
                vpc_config: self.vpc_config,
                stopping_condition: self.stopping_condition,
                tags: self.tags,
                enable_network_isolation: self.enable_network_isolation.unwrap_or_default(),
                enable_inter_container_traffic_encryption: self
                    .enable_inter_container_traffic_encryption
                    .unwrap_or_default(),
                enable_managed_spot_training: self.enable_managed_spot_training.unwrap_or_default(),
                checkpoint_config: self.checkpoint_config,
                debug_hook_config: self.debug_hook_config,
                debug_rule_configurations: self.debug_rule_configurations,
                tensor_board_output_config: self.tensor_board_output_config,
                experiment_config: self.experiment_config,
                profiler_config: self.profiler_config,
                profiler_rule_configurations: self.profiler_rule_configurations,
                environment: self.environment,
                retry_strategy: self.retry_strategy,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTrainingJobInputOperationOutputAlias = crate::operation::CreateTrainingJob;
#[doc(hidden)]
pub type CreateTrainingJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateTrainingJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateTrainingJob`](crate::operation::CreateTrainingJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTrainingJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTrainingJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTrainingJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTrainingJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateTrainingJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_training_job(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTrainingJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTrainingJob",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTrainingJobInput`](crate::input::CreateTrainingJobInput)
    pub fn builder() -> crate::input::create_training_job_input::Builder {
        crate::input::create_training_job_input::Builder::default()
    }
}

/// See [`CreateTransformJobInput`](crate::input::CreateTransformJobInput)
pub mod create_transform_job_input {
    /// A builder for [`CreateTransformJobInput`](crate::input::CreateTransformJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) transform_job_name: std::option::Option<std::string::String>,
        pub(crate) model_name: std::option::Option<std::string::String>,
        pub(crate) max_concurrent_transforms: std::option::Option<i32>,
        pub(crate) model_client_config: std::option::Option<crate::model::ModelClientConfig>,
        pub(crate) max_payload_in_mb: std::option::Option<i32>,
        pub(crate) batch_strategy: std::option::Option<crate::model::BatchStrategy>,
        pub(crate) environment: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) transform_input: std::option::Option<crate::model::TransformInput>,
        pub(crate) transform_output: std::option::Option<crate::model::TransformOutput>,
        pub(crate) transform_resources: std::option::Option<crate::model::TransformResources>,
        pub(crate) data_processing: std::option::Option<crate::model::DataProcessing>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) experiment_config: std::option::Option<crate::model::ExperimentConfig>,
    }
    impl Builder {
        /// <p>The name of the transform job. The name must be unique within an Amazon Web Services Region in an
        /// Amazon Web Services account. </p>
        pub fn transform_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.transform_job_name = Some(input.into());
            self
        }
        /// <p>The name of the transform job. The name must be unique within an Amazon Web Services Region in an
        /// Amazon Web Services account. </p>
        pub fn set_transform_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transform_job_name = input;
            self
        }
        /// <p>The name of the model that you want to use for the transform job.
        /// <code>ModelName</code> must be the name of an existing Amazon SageMaker model within an Amazon Web Services
        /// Region in an Amazon Web Services account.</p>
        pub fn model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_name = Some(input.into());
            self
        }
        /// <p>The name of the model that you want to use for the transform job.
        /// <code>ModelName</code> must be the name of an existing Amazon SageMaker model within an Amazon Web Services
        /// Region in an Amazon Web Services account.</p>
        pub fn set_model_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_name = input;
            self
        }
        /// <p>The maximum number of parallel requests that can be sent to each instance in a
        /// transform job. If <code>MaxConcurrentTransforms</code> is set to <code>0</code> or left
        /// unset, Amazon SageMaker checks the optional execution-parameters to determine the settings for your
        /// chosen algorithm. If the execution-parameters endpoint is not enabled, the default value
        /// is <code>1</code>. For more information on execution-parameters, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-batch-code.html#your-algorithms-batch-code-how-containe-serves-requests">How Containers Serve Requests</a>. For built-in algorithms, you don't need to
        /// set a value for <code>MaxConcurrentTransforms</code>.</p>
        pub fn max_concurrent_transforms(mut self, input: i32) -> Self {
            self.max_concurrent_transforms = Some(input);
            self
        }
        /// <p>The maximum number of parallel requests that can be sent to each instance in a
        /// transform job. If <code>MaxConcurrentTransforms</code> is set to <code>0</code> or left
        /// unset, Amazon SageMaker checks the optional execution-parameters to determine the settings for your
        /// chosen algorithm. If the execution-parameters endpoint is not enabled, the default value
        /// is <code>1</code>. For more information on execution-parameters, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-batch-code.html#your-algorithms-batch-code-how-containe-serves-requests">How Containers Serve Requests</a>. For built-in algorithms, you don't need to
        /// set a value for <code>MaxConcurrentTransforms</code>.</p>
        pub fn set_max_concurrent_transforms(mut self, input: std::option::Option<i32>) -> Self {
            self.max_concurrent_transforms = input;
            self
        }
        /// <p>Configures the timeout and maximum number of retries for processing a transform job
        /// invocation.</p>
        pub fn model_client_config(mut self, input: crate::model::ModelClientConfig) -> Self {
            self.model_client_config = Some(input);
            self
        }
        /// <p>Configures the timeout and maximum number of retries for processing a transform job
        /// invocation.</p>
        pub fn set_model_client_config(
            mut self,
            input: std::option::Option<crate::model::ModelClientConfig>,
        ) -> Self {
            self.model_client_config = input;
            self
        }
        /// <p>The maximum allowed size of the payload, in MB. A <i>payload</i> is the
        /// data portion of a record (without metadata). The value in <code>MaxPayloadInMB</code>
        /// must be greater than, or equal to, the size of a single record. To estimate the size of
        /// a record in MB, divide the size of your dataset by the number of records. To ensure that
        /// the records fit within the maximum payload size, we recommend using a slightly larger
        /// value. The default value is <code>6</code> MB.
        /// </p>
        /// <p>For cases where the payload might be arbitrarily large and is transmitted using HTTP
        /// chunked encoding, set the value to <code>0</code>.
        /// This
        /// feature works only in supported algorithms. Currently, Amazon SageMaker built-in
        /// algorithms do not support HTTP chunked encoding.</p>
        pub fn max_payload_in_mb(mut self, input: i32) -> Self {
            self.max_payload_in_mb = Some(input);
            self
        }
        /// <p>The maximum allowed size of the payload, in MB. A <i>payload</i> is the
        /// data portion of a record (without metadata). The value in <code>MaxPayloadInMB</code>
        /// must be greater than, or equal to, the size of a single record. To estimate the size of
        /// a record in MB, divide the size of your dataset by the number of records. To ensure that
        /// the records fit within the maximum payload size, we recommend using a slightly larger
        /// value. The default value is <code>6</code> MB.
        /// </p>
        /// <p>For cases where the payload might be arbitrarily large and is transmitted using HTTP
        /// chunked encoding, set the value to <code>0</code>.
        /// This
        /// feature works only in supported algorithms. Currently, Amazon SageMaker built-in
        /// algorithms do not support HTTP chunked encoding.</p>
        pub fn set_max_payload_in_mb(mut self, input: std::option::Option<i32>) -> Self {
            self.max_payload_in_mb = input;
            self
        }
        /// <p>Specifies the number of records to include in a mini-batch for an HTTP inference
        /// request. A <i>record</i>
        /// <i></i> is a single unit of input data that
        /// inference can be made on. For example, a single line in a CSV file is a record. </p>
        /// <p>To enable the batch strategy, you must set the <code>SplitType</code> property to
        /// <code>Line</code>, <code>RecordIO</code>, or <code>TFRecord</code>.</p>
        /// <p>To use only one record when making an HTTP invocation request to a container, set
        /// <code>BatchStrategy</code> to <code>SingleRecord</code> and <code>SplitType</code>
        /// to <code>Line</code>.</p>
        /// <p>To fit as many records in a mini-batch as can fit within the
        /// <code>MaxPayloadInMB</code> limit, set <code>BatchStrategy</code> to
        /// <code>MultiRecord</code> and <code>SplitType</code> to <code>Line</code>.</p>
        pub fn batch_strategy(mut self, input: crate::model::BatchStrategy) -> Self {
            self.batch_strategy = Some(input);
            self
        }
        /// <p>Specifies the number of records to include in a mini-batch for an HTTP inference
        /// request. A <i>record</i>
        /// <i></i> is a single unit of input data that
        /// inference can be made on. For example, a single line in a CSV file is a record. </p>
        /// <p>To enable the batch strategy, you must set the <code>SplitType</code> property to
        /// <code>Line</code>, <code>RecordIO</code>, or <code>TFRecord</code>.</p>
        /// <p>To use only one record when making an HTTP invocation request to a container, set
        /// <code>BatchStrategy</code> to <code>SingleRecord</code> and <code>SplitType</code>
        /// to <code>Line</code>.</p>
        /// <p>To fit as many records in a mini-batch as can fit within the
        /// <code>MaxPayloadInMB</code> limit, set <code>BatchStrategy</code> to
        /// <code>MultiRecord</code> and <code>SplitType</code> to <code>Line</code>.</p>
        pub fn set_batch_strategy(
            mut self,
            input: std::option::Option<crate::model::BatchStrategy>,
        ) -> Self {
            self.batch_strategy = input;
            self
        }
        /// Adds a key-value pair to `environment`.
        ///
        /// To override the contents of this collection use [`set_environment`](Self::set_environment).
        ///
        /// <p>The environment variables to set in the Docker container. We support up to 16 key and
        /// values entries in the map.</p>
        pub fn environment(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.environment.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.environment = Some(hash_map);
            self
        }
        /// <p>The environment variables to set in the Docker container. We support up to 16 key and
        /// values entries in the map.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.environment = input;
            self
        }
        /// <p>Describes the input source and
        /// the
        /// way the transform job consumes it.</p>
        pub fn transform_input(mut self, input: crate::model::TransformInput) -> Self {
            self.transform_input = Some(input);
            self
        }
        /// <p>Describes the input source and
        /// the
        /// way the transform job consumes it.</p>
        pub fn set_transform_input(
            mut self,
            input: std::option::Option<crate::model::TransformInput>,
        ) -> Self {
            self.transform_input = input;
            self
        }
        /// <p>Describes the results of the transform job.</p>
        pub fn transform_output(mut self, input: crate::model::TransformOutput) -> Self {
            self.transform_output = Some(input);
            self
        }
        /// <p>Describes the results of the transform job.</p>
        pub fn set_transform_output(
            mut self,
            input: std::option::Option<crate::model::TransformOutput>,
        ) -> Self {
            self.transform_output = input;
            self
        }
        /// <p>Describes the resources, including
        /// ML
        /// instance types and ML instance count, to use for the transform
        /// job.</p>
        pub fn transform_resources(mut self, input: crate::model::TransformResources) -> Self {
            self.transform_resources = Some(input);
            self
        }
        /// <p>Describes the resources, including
        /// ML
        /// instance types and ML instance count, to use for the transform
        /// job.</p>
        pub fn set_transform_resources(
            mut self,
            input: std::option::Option<crate::model::TransformResources>,
        ) -> Self {
            self.transform_resources = input;
            self
        }
        /// <p>The data structure used to specify the data to be used for inference in a batch
        /// transform job and to associate the data that is relevant to the prediction results in
        /// the output. The input filter provided allows you to exclude input data that is not
        /// needed for inference in a batch transform job. The output filter provided allows you to
        /// include input data relevant to interpreting the predictions in the output from the job.
        /// For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html">Associate Prediction
        /// Results with their Corresponding Input Records</a>.</p>
        pub fn data_processing(mut self, input: crate::model::DataProcessing) -> Self {
            self.data_processing = Some(input);
            self
        }
        /// <p>The data structure used to specify the data to be used for inference in a batch
        /// transform job and to associate the data that is relevant to the prediction results in
        /// the output. The input filter provided allows you to exclude input data that is not
        /// needed for inference in a batch transform job. The output filter provided allows you to
        /// include input data relevant to interpreting the predictions in the output from the job.
        /// For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html">Associate Prediction
        /// Results with their Corresponding Input Records</a>.</p>
        pub fn set_data_processing(
            mut self,
            input: std::option::Option<crate::model::DataProcessing>,
        ) -> Self {
            self.data_processing = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>(Optional)
        /// An
        /// array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using
        /// Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User
        /// Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>(Optional)
        /// An
        /// array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using
        /// Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User
        /// Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Associates a SageMaker job as a trial component with an experiment and trial. Specified when
        /// you call the following APIs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a>CreateProcessingJob</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>CreateTrainingJob</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>CreateTransformJob</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn experiment_config(mut self, input: crate::model::ExperimentConfig) -> Self {
            self.experiment_config = Some(input);
            self
        }
        /// <p>Associates a SageMaker job as a trial component with an experiment and trial. Specified when
        /// you call the following APIs:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a>CreateProcessingJob</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>CreateTrainingJob</a>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <a>CreateTransformJob</a>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_experiment_config(
            mut self,
            input: std::option::Option<crate::model::ExperimentConfig>,
        ) -> Self {
            self.experiment_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTransformJobInput`](crate::input::CreateTransformJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTransformJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTransformJobInput {
                transform_job_name: self.transform_job_name,
                model_name: self.model_name,
                max_concurrent_transforms: self.max_concurrent_transforms,
                model_client_config: self.model_client_config,
                max_payload_in_mb: self.max_payload_in_mb,
                batch_strategy: self.batch_strategy,
                environment: self.environment,
                transform_input: self.transform_input,
                transform_output: self.transform_output,
                transform_resources: self.transform_resources,
                data_processing: self.data_processing,
                tags: self.tags,
                experiment_config: self.experiment_config,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTransformJobInputOperationOutputAlias = crate::operation::CreateTransformJob;
#[doc(hidden)]
pub type CreateTransformJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateTransformJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateTransformJob`](crate::operation::CreateTransformJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTransformJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTransformJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTransformJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTransformJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateTransformJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_transform_job(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTransformJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTransformJob",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTransformJobInput`](crate::input::CreateTransformJobInput)
    pub fn builder() -> crate::input::create_transform_job_input::Builder {
        crate::input::create_transform_job_input::Builder::default()
    }
}

/// See [`CreateTrialInput`](crate::input::CreateTrialInput)
pub mod create_trial_input {
    /// A builder for [`CreateTrialInput`](crate::input::CreateTrialInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trial_name: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) experiment_name: std::option::Option<std::string::String>,
        pub(crate) metadata_properties: std::option::Option<crate::model::MetadataProperties>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the trial. The name must be unique in your Amazon Web Services account and is not
        /// case-sensitive.</p>
        pub fn trial_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.trial_name = Some(input.into());
            self
        }
        /// <p>The name of the trial. The name must be unique in your Amazon Web Services account and is not
        /// case-sensitive.</p>
        pub fn set_trial_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trial_name = input;
            self
        }
        /// <p>The name of the trial as displayed. The name doesn't need to be unique. If
        /// <code>DisplayName</code> isn't specified, <code>TrialName</code> is displayed.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The name of the trial as displayed. The name doesn't need to be unique. If
        /// <code>DisplayName</code> isn't specified, <code>TrialName</code> is displayed.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The name of the experiment to associate the trial with.</p>
        pub fn experiment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.experiment_name = Some(input.into());
            self
        }
        /// <p>The name of the experiment to associate the trial with.</p>
        pub fn set_experiment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.experiment_name = input;
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn metadata_properties(mut self, input: crate::model::MetadataProperties) -> Self {
            self.metadata_properties = Some(input);
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn set_metadata_properties(
            mut self,
            input: std::option::Option<crate::model::MetadataProperties>,
        ) -> Self {
            self.metadata_properties = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to associate with the trial. You can use <a>Search</a> API to
        /// search on the tags.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to associate with the trial. You can use <a>Search</a> API to
        /// search on the tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTrialInput`](crate::input::CreateTrialInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTrialInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTrialInput {
                trial_name: self.trial_name,
                display_name: self.display_name,
                experiment_name: self.experiment_name,
                metadata_properties: self.metadata_properties,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTrialInputOperationOutputAlias = crate::operation::CreateTrial;
#[doc(hidden)]
pub type CreateTrialInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateTrialInput {
    /// Consumes the builder and constructs an Operation<[`CreateTrial`](crate::operation::CreateTrial)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTrial,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTrialInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTrialInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTrialInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateTrial",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_trial(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTrial::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTrial",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTrialInput`](crate::input::CreateTrialInput)
    pub fn builder() -> crate::input::create_trial_input::Builder {
        crate::input::create_trial_input::Builder::default()
    }
}

/// See [`CreateTrialComponentInput`](crate::input::CreateTrialComponentInput)
pub mod create_trial_component_input {
    /// A builder for [`CreateTrialComponentInput`](crate::input::CreateTrialComponentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trial_component_name: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::TrialComponentStatus>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                crate::model::TrialComponentParameterValue,
            >,
        >,
        pub(crate) input_artifacts: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::TrialComponentArtifact>,
        >,
        pub(crate) output_artifacts: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::TrialComponentArtifact>,
        >,
        pub(crate) metadata_properties: std::option::Option<crate::model::MetadataProperties>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the component. The name must be unique in your Amazon Web Services account and is not
        /// case-sensitive.</p>
        pub fn trial_component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.trial_component_name = Some(input.into());
            self
        }
        /// <p>The name of the component. The name must be unique in your Amazon Web Services account and is not
        /// case-sensitive.</p>
        pub fn set_trial_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.trial_component_name = input;
            self
        }
        /// <p>The name of the component as displayed. The name doesn't need to be unique. If
        /// <code>DisplayName</code> isn't specified, <code>TrialComponentName</code> is
        /// displayed.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The name of the component as displayed. The name doesn't need to be unique. If
        /// <code>DisplayName</code> isn't specified, <code>TrialComponentName</code> is
        /// displayed.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The status of the component. States include:</p>
        /// <ul>
        /// <li>
        /// <p>InProgress</p>
        /// </li>
        /// <li>
        /// <p>Completed</p>
        /// </li>
        /// <li>
        /// <p>Failed</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::TrialComponentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the component. States include:</p>
        /// <ul>
        /// <li>
        /// <p>InProgress</p>
        /// </li>
        /// <li>
        /// <p>Completed</p>
        /// </li>
        /// <li>
        /// <p>Failed</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TrialComponentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>When the component started.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>When the component started.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>When the component ended.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>When the component ended.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The hyperparameters for the component.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::TrialComponentParameterValue>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>The hyperparameters for the component.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::TrialComponentParameterValue,
                >,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Adds a key-value pair to `input_artifacts`.
        ///
        /// To override the contents of this collection use [`set_input_artifacts`](Self::set_input_artifacts).
        ///
        /// <p>The input artifacts for the component. Examples of input artifacts are datasets,
        /// algorithms, hyperparameters, source code, and instance types.</p>
        pub fn input_artifacts(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::TrialComponentArtifact>,
        ) -> Self {
            let mut hash_map = self.input_artifacts.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.input_artifacts = Some(hash_map);
            self
        }
        /// <p>The input artifacts for the component. Examples of input artifacts are datasets,
        /// algorithms, hyperparameters, source code, and instance types.</p>
        pub fn set_input_artifacts(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::TrialComponentArtifact,
                >,
            >,
        ) -> Self {
            self.input_artifacts = input;
            self
        }
        /// Adds a key-value pair to `output_artifacts`.
        ///
        /// To override the contents of this collection use [`set_output_artifacts`](Self::set_output_artifacts).
        ///
        /// <p>The output artifacts for the component. Examples of output artifacts are metrics,
        /// snapshots, logs, and images.</p>
        pub fn output_artifacts(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::TrialComponentArtifact>,
        ) -> Self {
            let mut hash_map = self.output_artifacts.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.output_artifacts = Some(hash_map);
            self
        }
        /// <p>The output artifacts for the component. Examples of output artifacts are metrics,
        /// snapshots, logs, and images.</p>
        pub fn set_output_artifacts(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::TrialComponentArtifact,
                >,
            >,
        ) -> Self {
            self.output_artifacts = input;
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn metadata_properties(mut self, input: crate::model::MetadataProperties) -> Self {
            self.metadata_properties = Some(input);
            self
        }
        /// <p>Metadata properties of the tracking entity, trial, or trial component.</p>
        pub fn set_metadata_properties(
            mut self,
            input: std::option::Option<crate::model::MetadataProperties>,
        ) -> Self {
            self.metadata_properties = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to associate with the component. You can use <a>Search</a> API
        /// to search on the tags.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to associate with the component. You can use <a>Search</a> API
        /// to search on the tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTrialComponentInput`](crate::input::CreateTrialComponentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTrialComponentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTrialComponentInput {
                trial_component_name: self.trial_component_name,
                display_name: self.display_name,
                status: self.status,
                start_time: self.start_time,
                end_time: self.end_time,
                parameters: self.parameters,
                input_artifacts: self.input_artifacts,
                output_artifacts: self.output_artifacts,
                metadata_properties: self.metadata_properties,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTrialComponentInputOperationOutputAlias = crate::operation::CreateTrialComponent;
#[doc(hidden)]
pub type CreateTrialComponentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateTrialComponentInput {
    /// Consumes the builder and constructs an Operation<[`CreateTrialComponent`](crate::operation::CreateTrialComponent)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTrialComponent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateTrialComponentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateTrialComponentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateTrialComponentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateTrialComponent",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_trial_component(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTrialComponent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTrialComponent",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateTrialComponentInput`](crate::input::CreateTrialComponentInput)
    pub fn builder() -> crate::input::create_trial_component_input::Builder {
        crate::input::create_trial_component_input::Builder::default()
    }
}

/// See [`CreateUserProfileInput`](crate::input::CreateUserProfileInput)
pub mod create_user_profile_input {
    /// A builder for [`CreateUserProfileInput`](crate::input::CreateUserProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_id: std::option::Option<std::string::String>,
        pub(crate) user_profile_name: std::option::Option<std::string::String>,
        pub(crate) single_sign_on_user_identifier: std::option::Option<std::string::String>,
        pub(crate) single_sign_on_user_value: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) user_settings: std::option::Option<crate::model::UserSettings>,
    }
    impl Builder {
        /// <p>The ID of the associated Domain.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_id = Some(input.into());
            self
        }
        /// <p>The ID of the associated Domain.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_id = input;
            self
        }
        /// <p>A name for the UserProfile. This value is not case sensitive.</p>
        pub fn user_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_profile_name = Some(input.into());
            self
        }
        /// <p>A name for the UserProfile. This value is not case sensitive.</p>
        pub fn set_user_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_profile_name = input;
            self
        }
        /// <p>A specifier for the type of value specified in SingleSignOnUserValue.  Currently, the only supported value is "UserName".
        /// If the Domain's AuthMode is SSO, this field is required.  If the Domain's AuthMode is not SSO, this field cannot be specified.
        /// </p>
        pub fn single_sign_on_user_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.single_sign_on_user_identifier = Some(input.into());
            self
        }
        /// <p>A specifier for the type of value specified in SingleSignOnUserValue.  Currently, the only supported value is "UserName".
        /// If the Domain's AuthMode is SSO, this field is required.  If the Domain's AuthMode is not SSO, this field cannot be specified.
        /// </p>
        pub fn set_single_sign_on_user_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.single_sign_on_user_identifier = input;
            self
        }
        /// <p>The username of the associated Amazon Web Services Single Sign-On User for this UserProfile.  If the Domain's AuthMode is SSO, this field is
        /// required, and must match a valid username of a user in your directory.  If the Domain's AuthMode is not SSO, this field cannot be specified.
        /// </p>
        pub fn single_sign_on_user_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.single_sign_on_user_value = Some(input.into());
            self
        }
        /// <p>The username of the associated Amazon Web Services Single Sign-On User for this UserProfile.  If the Domain's AuthMode is SSO, this field is
        /// required, and must match a valid username of a user in your directory.  If the Domain's AuthMode is not SSO, this field cannot be specified.
        /// </p>
        pub fn set_single_sign_on_user_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.single_sign_on_user_value = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Each tag consists of a key and an optional value.
        /// Tag keys must be unique per resource.</p>
        /// <p>Tags that you specify for the User Profile are also added to all Apps that the
        /// User Profile launches.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Each tag consists of a key and an optional value.
        /// Tag keys must be unique per resource.</p>
        /// <p>Tags that you specify for the User Profile are also added to all Apps that the
        /// User Profile launches.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A collection of settings.</p>
        pub fn user_settings(mut self, input: crate::model::UserSettings) -> Self {
            self.user_settings = Some(input);
            self
        }
        /// <p>A collection of settings.</p>
        pub fn set_user_settings(
            mut self,
            input: std::option::Option<crate::model::UserSettings>,
        ) -> Self {
            self.user_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserProfileInput`](crate::input::CreateUserProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUserProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUserProfileInput {
                domain_id: self.domain_id,
                user_profile_name: self.user_profile_name,
                single_sign_on_user_identifier: self.single_sign_on_user_identifier,
                single_sign_on_user_value: self.single_sign_on_user_value,
                tags: self.tags,
                user_settings: self.user_settings,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUserProfileInputOperationOutputAlias = crate::operation::CreateUserProfile;
#[doc(hidden)]
pub type CreateUserProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateUserProfileInput {
    /// Consumes the builder and constructs an Operation<[`CreateUserProfile`](crate::operation::CreateUserProfile)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUserProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateUserProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateUserProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateUserProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateUserProfile",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_user_profile(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUserProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUserProfile",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateUserProfileInput`](crate::input::CreateUserProfileInput)
    pub fn builder() -> crate::input::create_user_profile_input::Builder {
        crate::input::create_user_profile_input::Builder::default()
    }
}

/// See [`CreateWorkforceInput`](crate::input::CreateWorkforceInput)
pub mod create_workforce_input {
    /// A builder for [`CreateWorkforceInput`](crate::input::CreateWorkforceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cognito_config: std::option::Option<crate::model::CognitoConfig>,
        pub(crate) oidc_config: std::option::Option<crate::model::OidcConfig>,
        pub(crate) source_ip_config: std::option::Option<crate::model::SourceIpConfig>,
        pub(crate) workforce_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Use this parameter to configure an Amazon Cognito private workforce.
        /// A single Cognito workforce is created using and corresponds to a single
        /// <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">
        /// Amazon Cognito user pool</a>.</p>
        ///
        /// <p>Do not use <code>OidcConfig</code> if you specify values for
        /// <code>CognitoConfig</code>.</p>
        pub fn cognito_config(mut self, input: crate::model::CognitoConfig) -> Self {
            self.cognito_config = Some(input);
            self
        }
        /// <p>Use this parameter to configure an Amazon Cognito private workforce.
        /// A single Cognito workforce is created using and corresponds to a single
        /// <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">
        /// Amazon Cognito user pool</a>.</p>
        ///
        /// <p>Do not use <code>OidcConfig</code> if you specify values for
        /// <code>CognitoConfig</code>.</p>
        pub fn set_cognito_config(
            mut self,
            input: std::option::Option<crate::model::CognitoConfig>,
        ) -> Self {
            self.cognito_config = input;
            self
        }
        /// <p>Use this parameter to configure a private workforce using your own OIDC Identity Provider.</p>
        /// <p>Do not use <code>CognitoConfig</code> if you specify values for
        /// <code>OidcConfig</code>.</p>
        pub fn oidc_config(mut self, input: crate::model::OidcConfig) -> Self {
            self.oidc_config = Some(input);
            self
        }
        /// <p>Use this parameter to configure a private workforce using your own OIDC Identity Provider.</p>
        /// <p>Do not use <code>CognitoConfig</code> if you specify values for
        /// <code>OidcConfig</code>.</p>
        pub fn set_oidc_config(
            mut self,
            input: std::option::Option<crate::model::OidcConfig>,
        ) -> Self {
            self.oidc_config = input;
            self
        }
        /// <p>A list of IP address ranges (<a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>). Used to create an allow
        /// list of IP addresses for a private workforce. Workers will only be able to login to their worker portal from an
        /// IP address within this range. By default, a workforce isn't restricted to specific IP addresses.</p>
        pub fn source_ip_config(mut self, input: crate::model::SourceIpConfig) -> Self {
            self.source_ip_config = Some(input);
            self
        }
        /// <p>A list of IP address ranges (<a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>). Used to create an allow
        /// list of IP addresses for a private workforce. Workers will only be able to login to their worker portal from an
        /// IP address within this range. By default, a workforce isn't restricted to specific IP addresses.</p>
        pub fn set_source_ip_config(
            mut self,
            input: std::option::Option<crate::model::SourceIpConfig>,
        ) -> Self {
            self.source_ip_config = input;
            self
        }
        /// <p>The name of the private workforce.</p>
        pub fn workforce_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.workforce_name = Some(input.into());
            self
        }
        /// <p>The name of the private workforce.</p>
        pub fn set_workforce_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workforce_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs that contain metadata to help you categorize and
        /// organize our workforce. Each tag consists of a key and a value,
        /// both of which you define.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>An array of key-value pairs that contain metadata to help you categorize and
        /// organize our workforce. Each tag consists of a key and a value,
        /// both of which you define.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWorkforceInput`](crate::input::CreateWorkforceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateWorkforceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateWorkforceInput {
                cognito_config: self.cognito_config,
                oidc_config: self.oidc_config,
                source_ip_config: self.source_ip_config,
                workforce_name: self.workforce_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateWorkforceInputOperationOutputAlias = crate::operation::CreateWorkforce;
#[doc(hidden)]
pub type CreateWorkforceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateWorkforceInput {
    /// Consumes the builder and constructs an Operation<[`CreateWorkforce`](crate::operation::CreateWorkforce)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateWorkforce,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateWorkforceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateWorkforceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateWorkforceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateWorkforce",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_workforce(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateWorkforce::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateWorkforce",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateWorkforceInput`](crate::input::CreateWorkforceInput)
    pub fn builder() -> crate::input::create_workforce_input::Builder {
        crate::input::create_workforce_input::Builder::default()
    }
}

/// See [`CreateWorkteamInput`](crate::input::CreateWorkteamInput)
pub mod create_workteam_input {
    /// A builder for [`CreateWorkteamInput`](crate::input::CreateWorkteamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workteam_name: std::option::Option<std::string::String>,
        pub(crate) workforce_name: std::option::Option<std::string::String>,
        pub(crate) member_definitions:
            std::option::Option<std::vec::Vec<crate::model::MemberDefinition>>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) notification_configuration:
            std::option::Option<crate::model::NotificationConfiguration>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the work team. Use this name to identify the work team.</p>
        pub fn workteam_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.workteam_name = Some(input.into());
            self
        }
        /// <p>The name of the work team. Use this name to identify the work team.</p>
        pub fn set_workteam_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workteam_name = input;
            self
        }
        /// <p>The name of the workforce.</p>
        pub fn workforce_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.workforce_name = Some(input.into());
            self
        }
        /// <p>The name of the workforce.</p>
        pub fn set_workforce_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workforce_name = input;
            self
        }
        /// Appends an item to `member_definitions`.
        ///
        /// To override the contents of this collection use [`set_member_definitions`](Self::set_member_definitions).
        ///
        /// <p>A list of <code>MemberDefinition</code> objects that contains objects that identify
        /// the workers that make up the work team. </p>
        /// <p>Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For
        /// private workforces created using Amazon Cognito use <code>CognitoMemberDefinition</code>. For
        /// workforces created using your own OIDC identity provider (IdP) use
        /// <code>OidcMemberDefinition</code>. Do not provide input for both of these parameters
        /// in a single request.</p>
        /// <p>For workforces created using Amazon Cognito, private work teams correspond to Amazon Cognito
        /// <i>user groups</i> within the user pool used to create a workforce. All of the
        /// <code>CognitoMemberDefinition</code> objects that make up the member definition must
        /// have the same <code>ClientId</code> and <code>UserPool</code> values. To add a Amazon
        /// Cognito user group to an existing worker pool, see <a href="">Adding groups to a User
        /// Pool</a>. For more information about user pools, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">Amazon Cognito User
        /// Pools</a>.</p>
        /// <p>For workforces created using your own OIDC IdP, specify the user groups that you want to
        /// include in your private work team in <code>OidcMemberDefinition</code> by listing those groups
        /// in <code>Groups</code>.</p>
        pub fn member_definitions(
            mut self,
            input: impl Into<crate::model::MemberDefinition>,
        ) -> Self {
            let mut v = self.member_definitions.unwrap_or_default();
            v.push(input.into());
            self.member_definitions = Some(v);
            self
        }
        /// <p>A list of <code>MemberDefinition</code> objects that contains objects that identify
        /// the workers that make up the work team. </p>
        /// <p>Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For
        /// private workforces created using Amazon Cognito use <code>CognitoMemberDefinition</code>. For
        /// workforces created using your own OIDC identity provider (IdP) use
        /// <code>OidcMemberDefinition</code>. Do not provide input for both of these parameters
        /// in a single request.</p>
        /// <p>For workforces created using Amazon Cognito, private work teams correspond to Amazon Cognito
        /// <i>user groups</i> within the user pool used to create a workforce. All of the
        /// <code>CognitoMemberDefinition</code> objects that make up the member definition must
        /// have the same <code>ClientId</code> and <code>UserPool</code> values. To add a Amazon
        /// Cognito user group to an existing worker pool, see <a href="">Adding groups to a User
        /// Pool</a>. For more information about user pools, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">Amazon Cognito User
        /// Pools</a>.</p>
        /// <p>For workforces created using your own OIDC IdP, specify the user groups that you want to
        /// include in your private work team in <code>OidcMemberDefinition</code> by listing those groups
        /// in <code>Groups</code>.</p>
        pub fn set_member_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MemberDefinition>>,
        ) -> Self {
            self.member_definitions = input;
            self
        }
        /// <p>A description of the work team.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the work team.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Configures notification of workers regarding available or expiring work items.</p>
        pub fn notification_configuration(
            mut self,
            input: crate::model::NotificationConfiguration,
        ) -> Self {
            self.notification_configuration = Some(input);
            self
        }
        /// <p>Configures notification of workers regarding available or expiring work items.</p>
        pub fn set_notification_configuration(
            mut self,
            input: std::option::Option<crate::model::NotificationConfiguration>,
        ) -> Self {
            self.notification_configuration = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of key-value pairs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Resource
        /// Tag</a> and <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using
        /// Cost Allocation Tags</a> in the <i> Amazon Web Services Billing and Cost Management User
        /// Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>An array of key-value pairs.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Resource
        /// Tag</a> and <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using
        /// Cost Allocation Tags</a> in the <i> Amazon Web Services Billing and Cost Management User
        /// Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWorkteamInput`](crate::input::CreateWorkteamInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateWorkteamInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateWorkteamInput {
                workteam_name: self.workteam_name,
                workforce_name: self.workforce_name,
                member_definitions: self.member_definitions,
                description: self.description,
                notification_configuration: self.notification_configuration,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateWorkteamInputOperationOutputAlias = crate::operation::CreateWorkteam;
#[doc(hidden)]
pub type CreateWorkteamInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateWorkteamInput {
    /// Consumes the builder and constructs an Operation<[`CreateWorkteam`](crate::operation::CreateWorkteam)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateWorkteam,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateWorkteamInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateWorkteamInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateWorkteamInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.CreateWorkteam",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_workteam(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateWorkteam::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateWorkteam",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateWorkteamInput`](crate::input::CreateWorkteamInput)
    pub fn builder() -> crate::input::create_workteam_input::Builder {
        crate::input::create_workteam_input::Builder::default()
    }
}

/// See [`DeleteActionInput`](crate::input::DeleteActionInput)
pub mod delete_action_input {
    /// A builder for [`DeleteActionInput`](crate::input::DeleteActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the action to delete.</p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_name = Some(input.into());
            self
        }
        /// <p>The name of the action to delete.</p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteActionInput`](crate::input::DeleteActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteActionInput {
                action_name: self.action_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteActionInputOperationOutputAlias = crate::operation::DeleteAction;
#[doc(hidden)]
pub type DeleteActionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteActionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAction`](crate::operation::DeleteAction)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAction,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteActionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteActionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteActionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteAction",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_action(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAction",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteActionInput`](crate::input::DeleteActionInput)
    pub fn builder() -> crate::input::delete_action_input::Builder {
        crate::input::delete_action_input::Builder::default()
    }
}

/// See [`DeleteAlgorithmInput`](crate::input::DeleteAlgorithmInput)
pub mod delete_algorithm_input {
    /// A builder for [`DeleteAlgorithmInput`](crate::input::DeleteAlgorithmInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) algorithm_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the algorithm to delete.</p>
        pub fn algorithm_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.algorithm_name = Some(input.into());
            self
        }
        /// <p>The name of the algorithm to delete.</p>
        pub fn set_algorithm_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.algorithm_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAlgorithmInput`](crate::input::DeleteAlgorithmInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAlgorithmInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAlgorithmInput {
                algorithm_name: self.algorithm_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAlgorithmInputOperationOutputAlias = crate::operation::DeleteAlgorithm;
#[doc(hidden)]
pub type DeleteAlgorithmInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAlgorithmInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAlgorithm`](crate::operation::DeleteAlgorithm)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAlgorithm,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAlgorithmInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAlgorithmInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAlgorithmInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteAlgorithm",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_algorithm(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAlgorithm::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAlgorithm",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAlgorithmInput`](crate::input::DeleteAlgorithmInput)
    pub fn builder() -> crate::input::delete_algorithm_input::Builder {
        crate::input::delete_algorithm_input::Builder::default()
    }
}

/// See [`DeleteAppInput`](crate::input::DeleteAppInput)
pub mod delete_app_input {
    /// A builder for [`DeleteAppInput`](crate::input::DeleteAppInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_id: std::option::Option<std::string::String>,
        pub(crate) user_profile_name: std::option::Option<std::string::String>,
        pub(crate) app_type: std::option::Option<crate::model::AppType>,
        pub(crate) app_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The domain ID.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_id = Some(input.into());
            self
        }
        /// <p>The domain ID.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_id = input;
            self
        }
        /// <p>The user profile name.</p>
        pub fn user_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_profile_name = Some(input.into());
            self
        }
        /// <p>The user profile name.</p>
        pub fn set_user_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_profile_name = input;
            self
        }
        /// <p>The type of app.</p>
        pub fn app_type(mut self, input: crate::model::AppType) -> Self {
            self.app_type = Some(input);
            self
        }
        /// <p>The type of app.</p>
        pub fn set_app_type(mut self, input: std::option::Option<crate::model::AppType>) -> Self {
            self.app_type = input;
            self
        }
        /// <p>The name of the app.</p>
        pub fn app_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_name = Some(input.into());
            self
        }
        /// <p>The name of the app.</p>
        pub fn set_app_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAppInput`](crate::input::DeleteAppInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::DeleteAppInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::DeleteAppInput {
                domain_id: self.domain_id,
                user_profile_name: self.user_profile_name,
                app_type: self.app_type,
                app_name: self.app_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAppInputOperationOutputAlias = crate::operation::DeleteApp;
#[doc(hidden)]
pub type DeleteAppInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAppInput {
    /// Consumes the builder and constructs an Operation<[`DeleteApp`](crate::operation::DeleteApp)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteApp,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAppInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAppInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAppInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteApp",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_app(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::DeleteApp::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "DeleteApp",
                    "sagemaker",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAppInput`](crate::input::DeleteAppInput)
    pub fn builder() -> crate::input::delete_app_input::Builder {
        crate::input::delete_app_input::Builder::default()
    }
}

/// See [`DeleteAppImageConfigInput`](crate::input::DeleteAppImageConfigInput)
pub mod delete_app_image_config_input {
    /// A builder for [`DeleteAppImageConfigInput`](crate::input::DeleteAppImageConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_image_config_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the AppImageConfig to delete.</p>
        pub fn app_image_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_image_config_name = Some(input.into());
            self
        }
        /// <p>The name of the AppImageConfig to delete.</p>
        pub fn set_app_image_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_image_config_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAppImageConfigInput`](crate::input::DeleteAppImageConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAppImageConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAppImageConfigInput {
                app_image_config_name: self.app_image_config_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAppImageConfigInputOperationOutputAlias = crate::operation::DeleteAppImageConfig;
#[doc(hidden)]
pub type DeleteAppImageConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAppImageConfigInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAppImageConfig`](crate::operation::DeleteAppImageConfig)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAppImageConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAppImageConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAppImageConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAppImageConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteAppImageConfig",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_app_image_config(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAppImageConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAppImageConfig",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAppImageConfigInput`](crate::input::DeleteAppImageConfigInput)
    pub fn builder() -> crate::input::delete_app_image_config_input::Builder {
        crate::input::delete_app_image_config_input::Builder::default()
    }
}

/// See [`DeleteArtifactInput`](crate::input::DeleteArtifactInput)
pub mod delete_artifact_input {
    /// A builder for [`DeleteArtifactInput`](crate::input::DeleteArtifactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) artifact_arn: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<crate::model::ArtifactSource>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the artifact to delete.</p>
        pub fn artifact_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.artifact_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the artifact to delete.</p>
        pub fn set_artifact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.artifact_arn = input;
            self
        }
        /// <p>The URI of the source.</p>
        pub fn source(mut self, input: crate::model::ArtifactSource) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>The URI of the source.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::ArtifactSource>,
        ) -> Self {
            self.source = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteArtifactInput`](crate::input::DeleteArtifactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteArtifactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteArtifactInput {
                artifact_arn: self.artifact_arn,
                source: self.source,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteArtifactInputOperationOutputAlias = crate::operation::DeleteArtifact;
#[doc(hidden)]
pub type DeleteArtifactInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteArtifactInput {
    /// Consumes the builder and constructs an Operation<[`DeleteArtifact`](crate::operation::DeleteArtifact)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteArtifact,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteArtifactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteArtifactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteArtifactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteArtifact",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_artifact(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteArtifact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteArtifact",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteArtifactInput`](crate::input::DeleteArtifactInput)
    pub fn builder() -> crate::input::delete_artifact_input::Builder {
        crate::input::delete_artifact_input::Builder::default()
    }
}

/// See [`DeleteAssociationInput`](crate::input::DeleteAssociationInput)
pub mod delete_association_input {
    /// A builder for [`DeleteAssociationInput`](crate::input::DeleteAssociationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_arn: std::option::Option<std::string::String>,
        pub(crate) destination_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the source.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the source.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the destination.</p>
        pub fn destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the destination.</p>
        pub fn set_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAssociationInput`](crate::input::DeleteAssociationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAssociationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAssociationInput {
                source_arn: self.source_arn,
                destination_arn: self.destination_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAssociationInputOperationOutputAlias = crate::operation::DeleteAssociation;
#[doc(hidden)]
pub type DeleteAssociationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAssociationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAssociation`](crate::operation::DeleteAssociation)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAssociation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAssociationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAssociationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAssociationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteAssociation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_association(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAssociation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAssociation",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAssociationInput`](crate::input::DeleteAssociationInput)
    pub fn builder() -> crate::input::delete_association_input::Builder {
        crate::input::delete_association_input::Builder::default()
    }
}

/// See [`DeleteCodeRepositoryInput`](crate::input::DeleteCodeRepositoryInput)
pub mod delete_code_repository_input {
    /// A builder for [`DeleteCodeRepositoryInput`](crate::input::DeleteCodeRepositoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code_repository_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Git repository to delete.</p>
        pub fn code_repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_repository_name = Some(input.into());
            self
        }
        /// <p>The name of the Git repository to delete.</p>
        pub fn set_code_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.code_repository_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCodeRepositoryInput`](crate::input::DeleteCodeRepositoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCodeRepositoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCodeRepositoryInput {
                code_repository_name: self.code_repository_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCodeRepositoryInputOperationOutputAlias = crate::operation::DeleteCodeRepository;
#[doc(hidden)]
pub type DeleteCodeRepositoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteCodeRepositoryInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCodeRepository`](crate::operation::DeleteCodeRepository)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCodeRepository,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteCodeRepositoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteCodeRepositoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteCodeRepositoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteCodeRepository",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_code_repository(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCodeRepository::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCodeRepository",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteCodeRepositoryInput`](crate::input::DeleteCodeRepositoryInput)
    pub fn builder() -> crate::input::delete_code_repository_input::Builder {
        crate::input::delete_code_repository_input::Builder::default()
    }
}

/// See [`DeleteContextInput`](crate::input::DeleteContextInput)
pub mod delete_context_input {
    /// A builder for [`DeleteContextInput`](crate::input::DeleteContextInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) context_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the context to delete.</p>
        pub fn context_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.context_name = Some(input.into());
            self
        }
        /// <p>The name of the context to delete.</p>
        pub fn set_context_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.context_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteContextInput`](crate::input::DeleteContextInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteContextInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteContextInput {
                context_name: self.context_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteContextInputOperationOutputAlias = crate::operation::DeleteContext;
#[doc(hidden)]
pub type DeleteContextInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteContextInput {
    /// Consumes the builder and constructs an Operation<[`DeleteContext`](crate::operation::DeleteContext)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteContext,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteContextInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteContextInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteContextInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteContext",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_context(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteContext::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteContext",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteContextInput`](crate::input::DeleteContextInput)
    pub fn builder() -> crate::input::delete_context_input::Builder {
        crate::input::delete_context_input::Builder::default()
    }
}

/// See [`DeleteDataQualityJobDefinitionInput`](crate::input::DeleteDataQualityJobDefinitionInput)
pub mod delete_data_quality_job_definition_input {
    /// A builder for [`DeleteDataQualityJobDefinitionInput`](crate::input::DeleteDataQualityJobDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_definition_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the data quality monitoring job definition to delete.</p>
        pub fn job_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_definition_name = Some(input.into());
            self
        }
        /// <p>The name of the data quality monitoring job definition to delete.</p>
        pub fn set_job_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_definition_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDataQualityJobDefinitionInput`](crate::input::DeleteDataQualityJobDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDataQualityJobDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDataQualityJobDefinitionInput {
                job_definition_name: self.job_definition_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDataQualityJobDefinitionInputOperationOutputAlias =
    crate::operation::DeleteDataQualityJobDefinition;
#[doc(hidden)]
pub type DeleteDataQualityJobDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDataQualityJobDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDataQualityJobDefinition`](crate::operation::DeleteDataQualityJobDefinition)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDataQualityJobDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDataQualityJobDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDataQualityJobDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDataQualityJobDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteDataQualityJobDefinition",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_data_quality_job_definition(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDataQualityJobDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDataQualityJobDefinition",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDataQualityJobDefinitionInput`](crate::input::DeleteDataQualityJobDefinitionInput)
    pub fn builder() -> crate::input::delete_data_quality_job_definition_input::Builder {
        crate::input::delete_data_quality_job_definition_input::Builder::default()
    }
}

/// See [`DeleteDeviceFleetInput`](crate::input::DeleteDeviceFleetInput)
pub mod delete_device_fleet_input {
    /// A builder for [`DeleteDeviceFleetInput`](crate::input::DeleteDeviceFleetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_fleet_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the fleet to delete.</p>
        pub fn device_fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_fleet_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet to delete.</p>
        pub fn set_device_fleet_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_fleet_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDeviceFleetInput`](crate::input::DeleteDeviceFleetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDeviceFleetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDeviceFleetInput {
                device_fleet_name: self.device_fleet_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDeviceFleetInputOperationOutputAlias = crate::operation::DeleteDeviceFleet;
#[doc(hidden)]
pub type DeleteDeviceFleetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDeviceFleetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDeviceFleet`](crate::operation::DeleteDeviceFleet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDeviceFleet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDeviceFleetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDeviceFleetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDeviceFleetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteDeviceFleet",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_device_fleet(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDeviceFleet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDeviceFleet",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDeviceFleetInput`](crate::input::DeleteDeviceFleetInput)
    pub fn builder() -> crate::input::delete_device_fleet_input::Builder {
        crate::input::delete_device_fleet_input::Builder::default()
    }
}

/// See [`DeleteDomainInput`](crate::input::DeleteDomainInput)
pub mod delete_domain_input {
    /// A builder for [`DeleteDomainInput`](crate::input::DeleteDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_id: std::option::Option<std::string::String>,
        pub(crate) retention_policy: std::option::Option<crate::model::RetentionPolicy>,
    }
    impl Builder {
        /// <p>The domain ID.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_id = Some(input.into());
            self
        }
        /// <p>The domain ID.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_id = input;
            self
        }
        /// <p>The retention policy for this domain, which specifies whether resources will be retained after the Domain is deleted.
        /// By default, all resources are retained (not automatically deleted).
        /// </p>
        pub fn retention_policy(mut self, input: crate::model::RetentionPolicy) -> Self {
            self.retention_policy = Some(input);
            self
        }
        /// <p>The retention policy for this domain, which specifies whether resources will be retained after the Domain is deleted.
        /// By default, all resources are retained (not automatically deleted).
        /// </p>
        pub fn set_retention_policy(
            mut self,
            input: std::option::Option<crate::model::RetentionPolicy>,
        ) -> Self {
            self.retention_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDomainInput`](crate::input::DeleteDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDomainInput {
                domain_id: self.domain_id,
                retention_policy: self.retention_policy,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDomainInputOperationOutputAlias = crate::operation::DeleteDomain;
#[doc(hidden)]
pub type DeleteDomainInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDomainInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDomain`](crate::operation::DeleteDomain)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDomain,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDomainInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDomainInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDomainInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteDomain",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_domain(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDomain",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDomainInput`](crate::input::DeleteDomainInput)
    pub fn builder() -> crate::input::delete_domain_input::Builder {
        crate::input::delete_domain_input::Builder::default()
    }
}

/// See [`DeleteEndpointInput`](crate::input::DeleteEndpointInput)
pub mod delete_endpoint_input {
    /// A builder for [`DeleteEndpointInput`](crate::input::DeleteEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the endpoint that you want to delete.</p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_name = Some(input.into());
            self
        }
        /// <p>The name of the endpoint that you want to delete.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEndpointInput`](crate::input::DeleteEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEndpointInput {
                endpoint_name: self.endpoint_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEndpointInputOperationOutputAlias = crate::operation::DeleteEndpoint;
#[doc(hidden)]
pub type DeleteEndpointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteEndpointInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEndpoint`](crate::operation::DeleteEndpoint)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEndpoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteEndpoint",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_endpoint(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEndpoint",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteEndpointInput`](crate::input::DeleteEndpointInput)
    pub fn builder() -> crate::input::delete_endpoint_input::Builder {
        crate::input::delete_endpoint_input::Builder::default()
    }
}

/// See [`DeleteEndpointConfigInput`](crate::input::DeleteEndpointConfigInput)
pub mod delete_endpoint_config_input {
    /// A builder for [`DeleteEndpointConfigInput`](crate::input::DeleteEndpointConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_config_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the endpoint configuration that you want to delete.</p>
        pub fn endpoint_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_config_name = Some(input.into());
            self
        }
        /// <p>The name of the endpoint configuration that you want to delete.</p>
        pub fn set_endpoint_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_config_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEndpointConfigInput`](crate::input::DeleteEndpointConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEndpointConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEndpointConfigInput {
                endpoint_config_name: self.endpoint_config_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEndpointConfigInputOperationOutputAlias = crate::operation::DeleteEndpointConfig;
#[doc(hidden)]
pub type DeleteEndpointConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteEndpointConfigInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEndpointConfig`](crate::operation::DeleteEndpointConfig)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEndpointConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteEndpointConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteEndpointConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteEndpointConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteEndpointConfig",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_endpoint_config(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEndpointConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEndpointConfig",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteEndpointConfigInput`](crate::input::DeleteEndpointConfigInput)
    pub fn builder() -> crate::input::delete_endpoint_config_input::Builder {
        crate::input::delete_endpoint_config_input::Builder::default()
    }
}

/// See [`DeleteExperimentInput`](crate::input::DeleteExperimentInput)
pub mod delete_experiment_input {
    /// A builder for [`DeleteExperimentInput`](crate::input::DeleteExperimentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) experiment_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the experiment to delete.</p>
        pub fn experiment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.experiment_name = Some(input.into());
            self
        }
        /// <p>The name of the experiment to delete.</p>
        pub fn set_experiment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.experiment_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteExperimentInput`](crate::input::DeleteExperimentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteExperimentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteExperimentInput {
                experiment_name: self.experiment_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteExperimentInputOperationOutputAlias = crate::operation::DeleteExperiment;
#[doc(hidden)]
pub type DeleteExperimentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteExperimentInput {
    /// Consumes the builder and constructs an Operation<[`DeleteExperiment`](crate::operation::DeleteExperiment)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteExperiment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteExperimentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteExperimentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteExperimentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteExperiment",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_experiment(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteExperiment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteExperiment",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteExperimentInput`](crate::input::DeleteExperimentInput)
    pub fn builder() -> crate::input::delete_experiment_input::Builder {
        crate::input::delete_experiment_input::Builder::default()
    }
}

/// See [`DeleteFeatureGroupInput`](crate::input::DeleteFeatureGroupInput)
pub mod delete_feature_group_input {
    /// A builder for [`DeleteFeatureGroupInput`](crate::input::DeleteFeatureGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) feature_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the <code>FeatureGroup</code> you want to delete. The name must be unique
        /// within an Amazon Web Services Region in an Amazon Web Services account. </p>
        pub fn feature_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.feature_group_name = Some(input.into());
            self
        }
        /// <p>The name of the <code>FeatureGroup</code> you want to delete. The name must be unique
        /// within an Amazon Web Services Region in an Amazon Web Services account. </p>
        pub fn set_feature_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.feature_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFeatureGroupInput`](crate::input::DeleteFeatureGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFeatureGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFeatureGroupInput {
                feature_group_name: self.feature_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFeatureGroupInputOperationOutputAlias = crate::operation::DeleteFeatureGroup;
#[doc(hidden)]
pub type DeleteFeatureGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteFeatureGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFeatureGroup`](crate::operation::DeleteFeatureGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFeatureGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteFeatureGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteFeatureGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteFeatureGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteFeatureGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_feature_group(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFeatureGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFeatureGroup",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteFeatureGroupInput`](crate::input::DeleteFeatureGroupInput)
    pub fn builder() -> crate::input::delete_feature_group_input::Builder {
        crate::input::delete_feature_group_input::Builder::default()
    }
}

/// See [`DeleteFlowDefinitionInput`](crate::input::DeleteFlowDefinitionInput)
pub mod delete_flow_definition_input {
    /// A builder for [`DeleteFlowDefinitionInput`](crate::input::DeleteFlowDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_definition_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the flow definition you are deleting.</p>
        pub fn flow_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_definition_name = Some(input.into());
            self
        }
        /// <p>The name of the flow definition you are deleting.</p>
        pub fn set_flow_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.flow_definition_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFlowDefinitionInput`](crate::input::DeleteFlowDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFlowDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFlowDefinitionInput {
                flow_definition_name: self.flow_definition_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFlowDefinitionInputOperationOutputAlias = crate::operation::DeleteFlowDefinition;
#[doc(hidden)]
pub type DeleteFlowDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteFlowDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFlowDefinition`](crate::operation::DeleteFlowDefinition)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFlowDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteFlowDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteFlowDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteFlowDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteFlowDefinition",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_flow_definition(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFlowDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFlowDefinition",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteFlowDefinitionInput`](crate::input::DeleteFlowDefinitionInput)
    pub fn builder() -> crate::input::delete_flow_definition_input::Builder {
        crate::input::delete_flow_definition_input::Builder::default()
    }
}

/// See [`DeleteHumanTaskUiInput`](crate::input::DeleteHumanTaskUiInput)
pub mod delete_human_task_ui_input {
    /// A builder for [`DeleteHumanTaskUiInput`](crate::input::DeleteHumanTaskUiInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) human_task_ui_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the human task user interface (work task template) you want to delete.</p>
        pub fn human_task_ui_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.human_task_ui_name = Some(input.into());
            self
        }
        /// <p>The name of the human task user interface (work task template) you want to delete.</p>
        pub fn set_human_task_ui_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.human_task_ui_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteHumanTaskUiInput`](crate::input::DeleteHumanTaskUiInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteHumanTaskUiInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteHumanTaskUiInput {
                human_task_ui_name: self.human_task_ui_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteHumanTaskUiInputOperationOutputAlias = crate::operation::DeleteHumanTaskUi;
#[doc(hidden)]
pub type DeleteHumanTaskUiInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteHumanTaskUiInput {
    /// Consumes the builder and constructs an Operation<[`DeleteHumanTaskUi`](crate::operation::DeleteHumanTaskUi)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteHumanTaskUi,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteHumanTaskUiInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteHumanTaskUiInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteHumanTaskUiInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteHumanTaskUi",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_human_task_ui(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteHumanTaskUi::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteHumanTaskUi",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteHumanTaskUiInput`](crate::input::DeleteHumanTaskUiInput)
    pub fn builder() -> crate::input::delete_human_task_ui_input::Builder {
        crate::input::delete_human_task_ui_input::Builder::default()
    }
}

/// See [`DeleteImageInput`](crate::input::DeleteImageInput)
pub mod delete_image_input {
    /// A builder for [`DeleteImageInput`](crate::input::DeleteImageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the image to delete.</p>
        pub fn image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_name = Some(input.into());
            self
        }
        /// <p>The name of the image to delete.</p>
        pub fn set_image_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteImageInput`](crate::input::DeleteImageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteImageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteImageInput {
                image_name: self.image_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteImageInputOperationOutputAlias = crate::operation::DeleteImage;
#[doc(hidden)]
pub type DeleteImageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteImageInput {
    /// Consumes the builder and constructs an Operation<[`DeleteImage`](crate::operation::DeleteImage)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteImage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteImageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteImageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteImageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteImage",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_image(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteImage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteImage",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteImageInput`](crate::input::DeleteImageInput)
    pub fn builder() -> crate::input::delete_image_input::Builder {
        crate::input::delete_image_input::Builder::default()
    }
}

/// See [`DeleteImageVersionInput`](crate::input::DeleteImageVersionInput)
pub mod delete_image_version_input {
    /// A builder for [`DeleteImageVersionInput`](crate::input::DeleteImageVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the image.</p>
        pub fn image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_name = Some(input.into());
            self
        }
        /// <p>The name of the image.</p>
        pub fn set_image_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_name = input;
            self
        }
        /// <p>The version to delete.</p>
        pub fn version(mut self, input: i32) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version to delete.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteImageVersionInput`](crate::input::DeleteImageVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteImageVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteImageVersionInput {
                image_name: self.image_name,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteImageVersionInputOperationOutputAlias = crate::operation::DeleteImageVersion;
#[doc(hidden)]
pub type DeleteImageVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteImageVersionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteImageVersion`](crate::operation::DeleteImageVersion)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteImageVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteImageVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteImageVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteImageVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteImageVersion",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_image_version(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteImageVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteImageVersion",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteImageVersionInput`](crate::input::DeleteImageVersionInput)
    pub fn builder() -> crate::input::delete_image_version_input::Builder {
        crate::input::delete_image_version_input::Builder::default()
    }
}

/// See [`DeleteModelInput`](crate::input::DeleteModelInput)
pub mod delete_model_input {
    /// A builder for [`DeleteModelInput`](crate::input::DeleteModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the model to delete.</p>
        pub fn model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_name = Some(input.into());
            self
        }
        /// <p>The name of the model to delete.</p>
        pub fn set_model_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteModelInput`](crate::input::DeleteModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteModelInput {
                model_name: self.model_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteModelInputOperationOutputAlias = crate::operation::DeleteModel;
#[doc(hidden)]
pub type DeleteModelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteModelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteModel`](crate::operation::DeleteModel)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteModel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteModelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteModelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteModelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteModel",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_model(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteModel",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteModelInput`](crate::input::DeleteModelInput)
    pub fn builder() -> crate::input::delete_model_input::Builder {
        crate::input::delete_model_input::Builder::default()
    }
}

/// See [`DeleteModelBiasJobDefinitionInput`](crate::input::DeleteModelBiasJobDefinitionInput)
pub mod delete_model_bias_job_definition_input {
    /// A builder for [`DeleteModelBiasJobDefinitionInput`](crate::input::DeleteModelBiasJobDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_definition_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the model bias job definition to delete.</p>
        pub fn job_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_definition_name = Some(input.into());
            self
        }
        /// <p>The name of the model bias job definition to delete.</p>
        pub fn set_job_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_definition_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteModelBiasJobDefinitionInput`](crate::input::DeleteModelBiasJobDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteModelBiasJobDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteModelBiasJobDefinitionInput {
                job_definition_name: self.job_definition_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteModelBiasJobDefinitionInputOperationOutputAlias =
    crate::operation::DeleteModelBiasJobDefinition;
#[doc(hidden)]
pub type DeleteModelBiasJobDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteModelBiasJobDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteModelBiasJobDefinition`](crate::operation::DeleteModelBiasJobDefinition)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteModelBiasJobDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteModelBiasJobDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteModelBiasJobDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteModelBiasJobDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteModelBiasJobDefinition",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_model_bias_job_definition(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteModelBiasJobDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteModelBiasJobDefinition",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteModelBiasJobDefinitionInput`](crate::input::DeleteModelBiasJobDefinitionInput)
    pub fn builder() -> crate::input::delete_model_bias_job_definition_input::Builder {
        crate::input::delete_model_bias_job_definition_input::Builder::default()
    }
}

/// See [`DeleteModelExplainabilityJobDefinitionInput`](crate::input::DeleteModelExplainabilityJobDefinitionInput)
pub mod delete_model_explainability_job_definition_input {
    /// A builder for [`DeleteModelExplainabilityJobDefinitionInput`](crate::input::DeleteModelExplainabilityJobDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_definition_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the model explainability job definition to delete.</p>
        pub fn job_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_definition_name = Some(input.into());
            self
        }
        /// <p>The name of the model explainability job definition to delete.</p>
        pub fn set_job_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_definition_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteModelExplainabilityJobDefinitionInput`](crate::input::DeleteModelExplainabilityJobDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteModelExplainabilityJobDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteModelExplainabilityJobDefinitionInput {
                job_definition_name: self.job_definition_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteModelExplainabilityJobDefinitionInputOperationOutputAlias =
    crate::operation::DeleteModelExplainabilityJobDefinition;
#[doc(hidden)]
pub type DeleteModelExplainabilityJobDefinitionInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DeleteModelExplainabilityJobDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteModelExplainabilityJobDefinition`](crate::operation::DeleteModelExplainabilityJobDefinition)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteModelExplainabilityJobDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteModelExplainabilityJobDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteModelExplainabilityJobDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteModelExplainabilityJobDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteModelExplainabilityJobDefinition",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_model_explainability_job_definition(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteModelExplainabilityJobDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteModelExplainabilityJobDefinition",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteModelExplainabilityJobDefinitionInput`](crate::input::DeleteModelExplainabilityJobDefinitionInput)
    pub fn builder() -> crate::input::delete_model_explainability_job_definition_input::Builder {
        crate::input::delete_model_explainability_job_definition_input::Builder::default()
    }
}

/// See [`DeleteModelPackageInput`](crate::input::DeleteModelPackageInput)
pub mod delete_model_package_input {
    /// A builder for [`DeleteModelPackageInput`](crate::input::DeleteModelPackageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_package_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or Amazon Resource Name (ARN) of the model package to delete.</p>
        /// <p>When you specify a name, the name must have 1 to 63 characters. Valid
        /// characters are a-z, A-Z, 0-9, and - (hyphen).</p>
        pub fn model_package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_package_name = Some(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the model package to delete.</p>
        /// <p>When you specify a name, the name must have 1 to 63 characters. Valid
        /// characters are a-z, A-Z, 0-9, and - (hyphen).</p>
        pub fn set_model_package_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_package_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteModelPackageInput`](crate::input::DeleteModelPackageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteModelPackageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteModelPackageInput {
                model_package_name: self.model_package_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteModelPackageInputOperationOutputAlias = crate::operation::DeleteModelPackage;
#[doc(hidden)]
pub type DeleteModelPackageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteModelPackageInput {
    /// Consumes the builder and constructs an Operation<[`DeleteModelPackage`](crate::operation::DeleteModelPackage)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteModelPackage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteModelPackageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteModelPackageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteModelPackageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteModelPackage",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_model_package(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteModelPackage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteModelPackage",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteModelPackageInput`](crate::input::DeleteModelPackageInput)
    pub fn builder() -> crate::input::delete_model_package_input::Builder {
        crate::input::delete_model_package_input::Builder::default()
    }
}

/// See [`DeleteModelPackageGroupInput`](crate::input::DeleteModelPackageGroupInput)
pub mod delete_model_package_group_input {
    /// A builder for [`DeleteModelPackageGroupInput`](crate::input::DeleteModelPackageGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_package_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the model group to delete.</p>
        pub fn model_package_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_package_group_name = Some(input.into());
            self
        }
        /// <p>The name of the model group to delete.</p>
        pub fn set_model_package_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_package_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteModelPackageGroupInput`](crate::input::DeleteModelPackageGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteModelPackageGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteModelPackageGroupInput {
                model_package_group_name: self.model_package_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteModelPackageGroupInputOperationOutputAlias =
    crate::operation::DeleteModelPackageGroup;
#[doc(hidden)]
pub type DeleteModelPackageGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteModelPackageGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteModelPackageGroup`](crate::operation::DeleteModelPackageGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteModelPackageGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteModelPackageGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteModelPackageGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteModelPackageGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteModelPackageGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_model_package_group(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteModelPackageGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteModelPackageGroup",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteModelPackageGroupInput`](crate::input::DeleteModelPackageGroupInput)
    pub fn builder() -> crate::input::delete_model_package_group_input::Builder {
        crate::input::delete_model_package_group_input::Builder::default()
    }
}

/// See [`DeleteModelPackageGroupPolicyInput`](crate::input::DeleteModelPackageGroupPolicyInput)
pub mod delete_model_package_group_policy_input {
    /// A builder for [`DeleteModelPackageGroupPolicyInput`](crate::input::DeleteModelPackageGroupPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_package_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the model group for which to delete the policy.</p>
        pub fn model_package_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_package_group_name = Some(input.into());
            self
        }
        /// <p>The name of the model group for which to delete the policy.</p>
        pub fn set_model_package_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_package_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteModelPackageGroupPolicyInput`](crate::input::DeleteModelPackageGroupPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteModelPackageGroupPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteModelPackageGroupPolicyInput {
                model_package_group_name: self.model_package_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteModelPackageGroupPolicyInputOperationOutputAlias =
    crate::operation::DeleteModelPackageGroupPolicy;
#[doc(hidden)]
pub type DeleteModelPackageGroupPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteModelPackageGroupPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteModelPackageGroupPolicy`](crate::operation::DeleteModelPackageGroupPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteModelPackageGroupPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteModelPackageGroupPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteModelPackageGroupPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteModelPackageGroupPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteModelPackageGroupPolicy",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_model_package_group_policy(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteModelPackageGroupPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteModelPackageGroupPolicy",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteModelPackageGroupPolicyInput`](crate::input::DeleteModelPackageGroupPolicyInput)
    pub fn builder() -> crate::input::delete_model_package_group_policy_input::Builder {
        crate::input::delete_model_package_group_policy_input::Builder::default()
    }
}

/// See [`DeleteModelQualityJobDefinitionInput`](crate::input::DeleteModelQualityJobDefinitionInput)
pub mod delete_model_quality_job_definition_input {
    /// A builder for [`DeleteModelQualityJobDefinitionInput`](crate::input::DeleteModelQualityJobDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_definition_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the model quality monitoring job definition to delete.</p>
        pub fn job_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_definition_name = Some(input.into());
            self
        }
        /// <p>The name of the model quality monitoring job definition to delete.</p>
        pub fn set_job_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_definition_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteModelQualityJobDefinitionInput`](crate::input::DeleteModelQualityJobDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteModelQualityJobDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteModelQualityJobDefinitionInput {
                job_definition_name: self.job_definition_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteModelQualityJobDefinitionInputOperationOutputAlias =
    crate::operation::DeleteModelQualityJobDefinition;
#[doc(hidden)]
pub type DeleteModelQualityJobDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteModelQualityJobDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteModelQualityJobDefinition`](crate::operation::DeleteModelQualityJobDefinition)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteModelQualityJobDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteModelQualityJobDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteModelQualityJobDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteModelQualityJobDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteModelQualityJobDefinition",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_model_quality_job_definition(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteModelQualityJobDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteModelQualityJobDefinition",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteModelQualityJobDefinitionInput`](crate::input::DeleteModelQualityJobDefinitionInput)
    pub fn builder() -> crate::input::delete_model_quality_job_definition_input::Builder {
        crate::input::delete_model_quality_job_definition_input::Builder::default()
    }
}

/// See [`DeleteMonitoringScheduleInput`](crate::input::DeleteMonitoringScheduleInput)
pub mod delete_monitoring_schedule_input {
    /// A builder for [`DeleteMonitoringScheduleInput`](crate::input::DeleteMonitoringScheduleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) monitoring_schedule_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the monitoring schedule to delete.</p>
        pub fn monitoring_schedule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.monitoring_schedule_name = Some(input.into());
            self
        }
        /// <p>The name of the monitoring schedule to delete.</p>
        pub fn set_monitoring_schedule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.monitoring_schedule_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMonitoringScheduleInput`](crate::input::DeleteMonitoringScheduleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteMonitoringScheduleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteMonitoringScheduleInput {
                monitoring_schedule_name: self.monitoring_schedule_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteMonitoringScheduleInputOperationOutputAlias =
    crate::operation::DeleteMonitoringSchedule;
#[doc(hidden)]
pub type DeleteMonitoringScheduleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteMonitoringScheduleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteMonitoringSchedule`](crate::operation::DeleteMonitoringSchedule)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteMonitoringSchedule,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteMonitoringScheduleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteMonitoringScheduleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteMonitoringScheduleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteMonitoringSchedule",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_monitoring_schedule(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteMonitoringSchedule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteMonitoringSchedule",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteMonitoringScheduleInput`](crate::input::DeleteMonitoringScheduleInput)
    pub fn builder() -> crate::input::delete_monitoring_schedule_input::Builder {
        crate::input::delete_monitoring_schedule_input::Builder::default()
    }
}

/// See [`DeleteNotebookInstanceInput`](crate::input::DeleteNotebookInstanceInput)
pub mod delete_notebook_instance_input {
    /// A builder for [`DeleteNotebookInstanceInput`](crate::input::DeleteNotebookInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notebook_instance_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon SageMaker notebook instance to delete.</p>
        pub fn notebook_instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.notebook_instance_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon SageMaker notebook instance to delete.</p>
        pub fn set_notebook_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notebook_instance_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteNotebookInstanceInput`](crate::input::DeleteNotebookInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteNotebookInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteNotebookInstanceInput {
                notebook_instance_name: self.notebook_instance_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteNotebookInstanceInputOperationOutputAlias = crate::operation::DeleteNotebookInstance;
#[doc(hidden)]
pub type DeleteNotebookInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteNotebookInstanceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteNotebookInstance`](crate::operation::DeleteNotebookInstance)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteNotebookInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteNotebookInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteNotebookInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteNotebookInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteNotebookInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_notebook_instance(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteNotebookInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteNotebookInstance",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteNotebookInstanceInput`](crate::input::DeleteNotebookInstanceInput)
    pub fn builder() -> crate::input::delete_notebook_instance_input::Builder {
        crate::input::delete_notebook_instance_input::Builder::default()
    }
}

/// See [`DeleteNotebookInstanceLifecycleConfigInput`](crate::input::DeleteNotebookInstanceLifecycleConfigInput)
pub mod delete_notebook_instance_lifecycle_config_input {
    /// A builder for [`DeleteNotebookInstanceLifecycleConfigInput`](crate::input::DeleteNotebookInstanceLifecycleConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notebook_instance_lifecycle_config_name:
            std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the lifecycle configuration to delete.</p>
        pub fn notebook_instance_lifecycle_config_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.notebook_instance_lifecycle_config_name = Some(input.into());
            self
        }
        /// <p>The name of the lifecycle configuration to delete.</p>
        pub fn set_notebook_instance_lifecycle_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notebook_instance_lifecycle_config_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteNotebookInstanceLifecycleConfigInput`](crate::input::DeleteNotebookInstanceLifecycleConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteNotebookInstanceLifecycleConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteNotebookInstanceLifecycleConfigInput {
                notebook_instance_lifecycle_config_name: self
                    .notebook_instance_lifecycle_config_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteNotebookInstanceLifecycleConfigInputOperationOutputAlias =
    crate::operation::DeleteNotebookInstanceLifecycleConfig;
#[doc(hidden)]
pub type DeleteNotebookInstanceLifecycleConfigInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DeleteNotebookInstanceLifecycleConfigInput {
    /// Consumes the builder and constructs an Operation<[`DeleteNotebookInstanceLifecycleConfig`](crate::operation::DeleteNotebookInstanceLifecycleConfig)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteNotebookInstanceLifecycleConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteNotebookInstanceLifecycleConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteNotebookInstanceLifecycleConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteNotebookInstanceLifecycleConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteNotebookInstanceLifecycleConfig",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_notebook_instance_lifecycle_config(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteNotebookInstanceLifecycleConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteNotebookInstanceLifecycleConfig",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteNotebookInstanceLifecycleConfigInput`](crate::input::DeleteNotebookInstanceLifecycleConfigInput)
    pub fn builder() -> crate::input::delete_notebook_instance_lifecycle_config_input::Builder {
        crate::input::delete_notebook_instance_lifecycle_config_input::Builder::default()
    }
}

/// See [`DeletePipelineInput`](crate::input::DeletePipelineInput)
pub mod delete_pipeline_input {
    /// A builder for [`DeletePipelineInput`](crate::input::DeletePipelineInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_name: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the pipeline to delete.</p>
        pub fn pipeline_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_name = Some(input.into());
            self
        }
        /// <p>The name of the pipeline to delete.</p>
        pub fn set_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pipeline_name = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// operation. An idempotent operation completes no more than one time.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// operation. An idempotent operation completes no more than one time.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePipelineInput`](crate::input::DeletePipelineInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePipelineInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePipelineInput {
                pipeline_name: self.pipeline_name,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePipelineInputOperationOutputAlias = crate::operation::DeletePipeline;
#[doc(hidden)]
pub type DeletePipelineInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeletePipelineInput {
    /// Consumes the builder and constructs an Operation<[`DeletePipeline`](crate::operation::DeletePipeline)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePipeline,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeletePipelineInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeletePipelineInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeletePipelineInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeletePipeline",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_pipeline(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePipeline::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePipeline",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeletePipelineInput`](crate::input::DeletePipelineInput)
    pub fn builder() -> crate::input::delete_pipeline_input::Builder {
        crate::input::delete_pipeline_input::Builder::default()
    }
}

/// See [`DeleteProjectInput`](crate::input::DeleteProjectInput)
pub mod delete_project_input {
    /// A builder for [`DeleteProjectInput`](crate::input::DeleteProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the project to delete.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project to delete.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteProjectInput`](crate::input::DeleteProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteProjectInput {
                project_name: self.project_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteProjectInputOperationOutputAlias = crate::operation::DeleteProject;
#[doc(hidden)]
pub type DeleteProjectInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteProjectInput {
    /// Consumes the builder and constructs an Operation<[`DeleteProject`](crate::operation::DeleteProject)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteProject,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteProjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteProjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteProjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteProject",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_project(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteProject",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteProjectInput`](crate::input::DeleteProjectInput)
    pub fn builder() -> crate::input::delete_project_input::Builder {
        crate::input::delete_project_input::Builder::default()
    }
}

/// See [`DeleteStudioLifecycleConfigInput`](crate::input::DeleteStudioLifecycleConfigInput)
pub mod delete_studio_lifecycle_config_input {
    /// A builder for [`DeleteStudioLifecycleConfigInput`](crate::input::DeleteStudioLifecycleConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) studio_lifecycle_config_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Studio Lifecycle Configuration to delete.</p>
        pub fn studio_lifecycle_config_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.studio_lifecycle_config_name = Some(input.into());
            self
        }
        /// <p>The name of the Studio Lifecycle Configuration to delete.</p>
        pub fn set_studio_lifecycle_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.studio_lifecycle_config_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteStudioLifecycleConfigInput`](crate::input::DeleteStudioLifecycleConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteStudioLifecycleConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteStudioLifecycleConfigInput {
                studio_lifecycle_config_name: self.studio_lifecycle_config_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteStudioLifecycleConfigInputOperationOutputAlias =
    crate::operation::DeleteStudioLifecycleConfig;
#[doc(hidden)]
pub type DeleteStudioLifecycleConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteStudioLifecycleConfigInput {
    /// Consumes the builder and constructs an Operation<[`DeleteStudioLifecycleConfig`](crate::operation::DeleteStudioLifecycleConfig)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteStudioLifecycleConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteStudioLifecycleConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteStudioLifecycleConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteStudioLifecycleConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteStudioLifecycleConfig",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_studio_lifecycle_config(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteStudioLifecycleConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteStudioLifecycleConfig",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteStudioLifecycleConfigInput`](crate::input::DeleteStudioLifecycleConfigInput)
    pub fn builder() -> crate::input::delete_studio_lifecycle_config_input::Builder {
        crate::input::delete_studio_lifecycle_config_input::Builder::default()
    }
}

/// See [`DeleteTagsInput`](crate::input::DeleteTagsInput)
pub mod delete_tags_input {
    /// A builder for [`DeleteTagsInput`](crate::input::DeleteTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to
        /// delete.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to
        /// delete.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>An array or one or more tag keys to delete.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>An array or one or more tag keys to delete.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTagsInput`](crate::input::DeleteTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTagsInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTagsInputOperationOutputAlias = crate::operation::DeleteTags;
#[doc(hidden)]
pub type DeleteTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteTagsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTags`](crate::operation::DeleteTags)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteTags",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_tags(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTags",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTagsInput`](crate::input::DeleteTagsInput)
    pub fn builder() -> crate::input::delete_tags_input::Builder {
        crate::input::delete_tags_input::Builder::default()
    }
}

/// See [`DeleteTrialInput`](crate::input::DeleteTrialInput)
pub mod delete_trial_input {
    /// A builder for [`DeleteTrialInput`](crate::input::DeleteTrialInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trial_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the trial to delete.</p>
        pub fn trial_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.trial_name = Some(input.into());
            self
        }
        /// <p>The name of the trial to delete.</p>
        pub fn set_trial_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trial_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTrialInput`](crate::input::DeleteTrialInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTrialInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTrialInput {
                trial_name: self.trial_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTrialInputOperationOutputAlias = crate::operation::DeleteTrial;
#[doc(hidden)]
pub type DeleteTrialInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteTrialInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTrial`](crate::operation::DeleteTrial)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTrial,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTrialInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTrialInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTrialInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteTrial",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_trial(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTrial::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTrial",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTrialInput`](crate::input::DeleteTrialInput)
    pub fn builder() -> crate::input::delete_trial_input::Builder {
        crate::input::delete_trial_input::Builder::default()
    }
}

/// See [`DeleteTrialComponentInput`](crate::input::DeleteTrialComponentInput)
pub mod delete_trial_component_input {
    /// A builder for [`DeleteTrialComponentInput`](crate::input::DeleteTrialComponentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trial_component_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the component to delete.</p>
        pub fn trial_component_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.trial_component_name = Some(input.into());
            self
        }
        /// <p>The name of the component to delete.</p>
        pub fn set_trial_component_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.trial_component_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTrialComponentInput`](crate::input::DeleteTrialComponentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTrialComponentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTrialComponentInput {
                trial_component_name: self.trial_component_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTrialComponentInputOperationOutputAlias = crate::operation::DeleteTrialComponent;
#[doc(hidden)]
pub type DeleteTrialComponentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteTrialComponentInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTrialComponent`](crate::operation::DeleteTrialComponent)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTrialComponent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTrialComponentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTrialComponentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTrialComponentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteTrialComponent",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_trial_component(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTrialComponent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTrialComponent",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTrialComponentInput`](crate::input::DeleteTrialComponentInput)
    pub fn builder() -> crate::input::delete_trial_component_input::Builder {
        crate::input::delete_trial_component_input::Builder::default()
    }
}

/// See [`DeleteUserProfileInput`](crate::input::DeleteUserProfileInput)
pub mod delete_user_profile_input {
    /// A builder for [`DeleteUserProfileInput`](crate::input::DeleteUserProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_id: std::option::Option<std::string::String>,
        pub(crate) user_profile_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The domain ID.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_id = Some(input.into());
            self
        }
        /// <p>The domain ID.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_id = input;
            self
        }
        /// <p>The user profile name.</p>
        pub fn user_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_profile_name = Some(input.into());
            self
        }
        /// <p>The user profile name.</p>
        pub fn set_user_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_profile_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserProfileInput`](crate::input::DeleteUserProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUserProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUserProfileInput {
                domain_id: self.domain_id,
                user_profile_name: self.user_profile_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUserProfileInputOperationOutputAlias = crate::operation::DeleteUserProfile;
#[doc(hidden)]
pub type DeleteUserProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteUserProfileInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUserProfile`](crate::operation::DeleteUserProfile)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUserProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteUserProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteUserProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteUserProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteUserProfile",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_user_profile(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUserProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUserProfile",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteUserProfileInput`](crate::input::DeleteUserProfileInput)
    pub fn builder() -> crate::input::delete_user_profile_input::Builder {
        crate::input::delete_user_profile_input::Builder::default()
    }
}

/// See [`DeleteWorkforceInput`](crate::input::DeleteWorkforceInput)
pub mod delete_workforce_input {
    /// A builder for [`DeleteWorkforceInput`](crate::input::DeleteWorkforceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workforce_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the workforce.</p>
        pub fn workforce_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.workforce_name = Some(input.into());
            self
        }
        /// <p>The name of the workforce.</p>
        pub fn set_workforce_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workforce_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteWorkforceInput`](crate::input::DeleteWorkforceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteWorkforceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteWorkforceInput {
                workforce_name: self.workforce_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteWorkforceInputOperationOutputAlias = crate::operation::DeleteWorkforce;
#[doc(hidden)]
pub type DeleteWorkforceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteWorkforceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteWorkforce`](crate::operation::DeleteWorkforce)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteWorkforce,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteWorkforceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteWorkforceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteWorkforceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteWorkforce",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_workforce(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteWorkforce::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteWorkforce",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteWorkforceInput`](crate::input::DeleteWorkforceInput)
    pub fn builder() -> crate::input::delete_workforce_input::Builder {
        crate::input::delete_workforce_input::Builder::default()
    }
}

/// See [`DeleteWorkteamInput`](crate::input::DeleteWorkteamInput)
pub mod delete_workteam_input {
    /// A builder for [`DeleteWorkteamInput`](crate::input::DeleteWorkteamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workteam_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the work team to delete.</p>
        pub fn workteam_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.workteam_name = Some(input.into());
            self
        }
        /// <p>The name of the work team to delete.</p>
        pub fn set_workteam_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.workteam_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteWorkteamInput`](crate::input::DeleteWorkteamInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteWorkteamInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteWorkteamInput {
                workteam_name: self.workteam_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteWorkteamInputOperationOutputAlias = crate::operation::DeleteWorkteam;
#[doc(hidden)]
pub type DeleteWorkteamInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteWorkteamInput {
    /// Consumes the builder and constructs an Operation<[`DeleteWorkteam`](crate::operation::DeleteWorkteam)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteWorkteam,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteWorkteamInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteWorkteamInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteWorkteamInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeleteWorkteam",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_workteam(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteWorkteam::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteWorkteam",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteWorkteamInput`](crate::input::DeleteWorkteamInput)
    pub fn builder() -> crate::input::delete_workteam_input::Builder {
        crate::input::delete_workteam_input::Builder::default()
    }
}

/// See [`DeregisterDevicesInput`](crate::input::DeregisterDevicesInput)
pub mod deregister_devices_input {
    /// A builder for [`DeregisterDevicesInput`](crate::input::DeregisterDevicesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_fleet_name: std::option::Option<std::string::String>,
        pub(crate) device_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the fleet the devices belong to.</p>
        pub fn device_fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_fleet_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet the devices belong to.</p>
        pub fn set_device_fleet_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_fleet_name = input;
            self
        }
        /// Appends an item to `device_names`.
        ///
        /// To override the contents of this collection use [`set_device_names`](Self::set_device_names).
        ///
        /// <p>The unique IDs of the devices.</p>
        pub fn device_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.device_names.unwrap_or_default();
            v.push(input.into());
            self.device_names = Some(v);
            self
        }
        /// <p>The unique IDs of the devices.</p>
        pub fn set_device_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.device_names = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterDevicesInput`](crate::input::DeregisterDevicesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterDevicesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterDevicesInput {
                device_fleet_name: self.device_fleet_name,
                device_names: self.device_names,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterDevicesInputOperationOutputAlias = crate::operation::DeregisterDevices;
#[doc(hidden)]
pub type DeregisterDevicesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeregisterDevicesInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterDevices`](crate::operation::DeregisterDevices)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterDevices,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeregisterDevicesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeregisterDevicesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeregisterDevicesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DeregisterDevices",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deregister_devices(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterDevices::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterDevices",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeregisterDevicesInput`](crate::input::DeregisterDevicesInput)
    pub fn builder() -> crate::input::deregister_devices_input::Builder {
        crate::input::deregister_devices_input::Builder::default()
    }
}

/// See [`DescribeActionInput`](crate::input::DescribeActionInput)
pub mod describe_action_input {
    /// A builder for [`DescribeActionInput`](crate::input::DescribeActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the action to describe.</p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_name = Some(input.into());
            self
        }
        /// <p>The name of the action to describe.</p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeActionInput`](crate::input::DescribeActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeActionInput {
                action_name: self.action_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeActionInputOperationOutputAlias = crate::operation::DescribeAction;
#[doc(hidden)]
pub type DescribeActionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeActionInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAction`](crate::operation::DescribeAction)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAction,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeActionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeActionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeActionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DescribeAction",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_action(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAction",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeActionInput`](crate::input::DescribeActionInput)
    pub fn builder() -> crate::input::describe_action_input::Builder {
        crate::input::describe_action_input::Builder::default()
    }
}

/// See [`DescribeAlgorithmInput`](crate::input::DescribeAlgorithmInput)
pub mod describe_algorithm_input {
    /// A builder for [`DescribeAlgorithmInput`](crate::input::DescribeAlgorithmInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) algorithm_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the algorithm to describe.</p>
        pub fn algorithm_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.algorithm_name = Some(input.into());
            self
        }
        /// <p>The name of the algorithm to describe.</p>
        pub fn set_algorithm_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.algorithm_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAlgorithmInput`](crate::input::DescribeAlgorithmInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAlgorithmInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAlgorithmInput {
                algorithm_name: self.algorithm_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAlgorithmInputOperationOutputAlias = crate::operation::DescribeAlgorithm;
#[doc(hidden)]
pub type DescribeAlgorithmInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAlgorithmInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAlgorithm`](crate::operation::DescribeAlgorithm)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAlgorithm,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAlgorithmInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAlgorithmInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAlgorithmInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DescribeAlgorithm",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_algorithm(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAlgorithm::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAlgorithm",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAlgorithmInput`](crate::input::DescribeAlgorithmInput)
    pub fn builder() -> crate::input::describe_algorithm_input::Builder {
        crate::input::describe_algorithm_input::Builder::default()
    }
}

/// See [`DescribeAppInput`](crate::input::DescribeAppInput)
pub mod describe_app_input {
    /// A builder for [`DescribeAppInput`](crate::input::DescribeAppInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_id: std::option::Option<std::string::String>,
        pub(crate) user_profile_name: std::option::Option<std::string::String>,
        pub(crate) app_type: std::option::Option<crate::model::AppType>,
        pub(crate) app_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The domain ID.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_id = Some(input.into());
            self
        }
        /// <p>The domain ID.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_id = input;
            self
        }
        /// <p>The user profile name.</p>
        pub fn user_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_profile_name = Some(input.into());
            self
        }
        /// <p>The user profile name.</p>
        pub fn set_user_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_profile_name = input;
            self
        }
        /// <p>The type of app.</p>
        pub fn app_type(mut self, input: crate::model::AppType) -> Self {
            self.app_type = Some(input);
            self
        }
        /// <p>The type of app.</p>
        pub fn set_app_type(mut self, input: std::option::Option<crate::model::AppType>) -> Self {
            self.app_type = input;
            self
        }
        /// <p>The name of the app.</p>
        pub fn app_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_name = Some(input.into());
            self
        }
        /// <p>The name of the app.</p>
        pub fn set_app_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAppInput`](crate::input::DescribeAppInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAppInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAppInput {
                domain_id: self.domain_id,
                user_profile_name: self.user_profile_name,
                app_type: self.app_type,
                app_name: self.app_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAppInputOperationOutputAlias = crate::operation::DescribeApp;
#[doc(hidden)]
pub type DescribeAppInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAppInput {
    /// Consumes the builder and constructs an Operation<[`DescribeApp`](crate::operation::DescribeApp)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeApp,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAppInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAppInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAppInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DescribeApp",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_app(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeApp::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeApp",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAppInput`](crate::input::DescribeAppInput)
    pub fn builder() -> crate::input::describe_app_input::Builder {
        crate::input::describe_app_input::Builder::default()
    }
}

/// See [`DescribeAppImageConfigInput`](crate::input::DescribeAppImageConfigInput)
pub mod describe_app_image_config_input {
    /// A builder for [`DescribeAppImageConfigInput`](crate::input::DescribeAppImageConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) app_image_config_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the AppImageConfig to describe.</p>
        pub fn app_image_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_image_config_name = Some(input.into());
            self
        }
        /// <p>The name of the AppImageConfig to describe.</p>
        pub fn set_app_image_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_image_config_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAppImageConfigInput`](crate::input::DescribeAppImageConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAppImageConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAppImageConfigInput {
                app_image_config_name: self.app_image_config_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAppImageConfigInputOperationOutputAlias = crate::operation::DescribeAppImageConfig;
#[doc(hidden)]
pub type DescribeAppImageConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAppImageConfigInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAppImageConfig`](crate::operation::DescribeAppImageConfig)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAppImageConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAppImageConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAppImageConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAppImageConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DescribeAppImageConfig",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_app_image_config(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAppImageConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAppImageConfig",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAppImageConfigInput`](crate::input::DescribeAppImageConfigInput)
    pub fn builder() -> crate::input::describe_app_image_config_input::Builder {
        crate::input::describe_app_image_config_input::Builder::default()
    }
}

/// See [`DescribeArtifactInput`](crate::input::DescribeArtifactInput)
pub mod describe_artifact_input {
    /// A builder for [`DescribeArtifactInput`](crate::input::DescribeArtifactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) artifact_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the artifact to describe.</p>
        pub fn artifact_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.artifact_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the artifact to describe.</p>
        pub fn set_artifact_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.artifact_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeArtifactInput`](crate::input::DescribeArtifactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeArtifactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeArtifactInput {
                artifact_arn: self.artifact_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeArtifactInputOperationOutputAlias = crate::operation::DescribeArtifact;
#[doc(hidden)]
pub type DescribeArtifactInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeArtifactInput {
    /// Consumes the builder and constructs an Operation<[`DescribeArtifact`](crate::operation::DescribeArtifact)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeArtifact,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeArtifactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeArtifactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeArtifactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DescribeArtifact",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_artifact(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeArtifact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeArtifact",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeArtifactInput`](crate::input::DescribeArtifactInput)
    pub fn builder() -> crate::input::describe_artifact_input::Builder {
        crate::input::describe_artifact_input::Builder::default()
    }
}

/// See [`DescribeAutoMlJobInput`](crate::input::DescribeAutoMlJobInput)
pub mod describe_auto_ml_job_input {
    /// A builder for [`DescribeAutoMlJobInput`](crate::input::DescribeAutoMlJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_ml_job_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Requests information about an AutoML job using its unique name.</p>
        pub fn auto_ml_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_ml_job_name = Some(input.into());
            self
        }
        /// <p>Requests information about an AutoML job using its unique name.</p>
        pub fn set_auto_ml_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_ml_job_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAutoMlJobInput`](crate::input::DescribeAutoMlJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAutoMlJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAutoMlJobInput {
                auto_ml_job_name: self.auto_ml_job_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAutoMlJobInputOperationOutputAlias = crate::operation::DescribeAutoMLJob;
#[doc(hidden)]
pub type DescribeAutoMlJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAutoMlJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAutoMLJob`](crate::operation::DescribeAutoMLJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAutoMLJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAutoMlJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAutoMlJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAutoMlJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DescribeAutoMLJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_auto_ml_job(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAutoMLJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAutoMLJob",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAutoMlJobInput`](crate::input::DescribeAutoMlJobInput)
    pub fn builder() -> crate::input::describe_auto_ml_job_input::Builder {
        crate::input::describe_auto_ml_job_input::Builder::default()
    }
}

/// See [`DescribeCodeRepositoryInput`](crate::input::DescribeCodeRepositoryInput)
pub mod describe_code_repository_input {
    /// A builder for [`DescribeCodeRepositoryInput`](crate::input::DescribeCodeRepositoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code_repository_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Git repository to describe.</p>
        pub fn code_repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_repository_name = Some(input.into());
            self
        }
        /// <p>The name of the Git repository to describe.</p>
        pub fn set_code_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.code_repository_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCodeRepositoryInput`](crate::input::DescribeCodeRepositoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCodeRepositoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCodeRepositoryInput {
                code_repository_name: self.code_repository_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCodeRepositoryInputOperationOutputAlias = crate::operation::DescribeCodeRepository;
#[doc(hidden)]
pub type DescribeCodeRepositoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeCodeRepositoryInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCodeRepository`](crate::operation::DescribeCodeRepository)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCodeRepository,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCodeRepositoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCodeRepositoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCodeRepositoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DescribeCodeRepository",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_code_repository(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCodeRepository::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCodeRepository",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCodeRepositoryInput`](crate::input::DescribeCodeRepositoryInput)
    pub fn builder() -> crate::input::describe_code_repository_input::Builder {
        crate::input::describe_code_repository_input::Builder::default()
    }
}

/// See [`DescribeCompilationJobInput`](crate::input::DescribeCompilationJobInput)
pub mod describe_compilation_job_input {
    /// A builder for [`DescribeCompilationJobInput`](crate::input::DescribeCompilationJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compilation_job_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the model compilation job that you want information about.</p>
        pub fn compilation_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.compilation_job_name = Some(input.into());
            self
        }
        /// <p>The name of the model compilation job that you want information about.</p>
        pub fn set_compilation_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.compilation_job_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCompilationJobInput`](crate::input::DescribeCompilationJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCompilationJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCompilationJobInput {
                compilation_job_name: self.compilation_job_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCompilationJobInputOperationOutputAlias = crate::operation::DescribeCompilationJob;
#[doc(hidden)]
pub type DescribeCompilationJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeCompilationJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCompilationJob`](crate::operation::DescribeCompilationJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCompilationJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCompilationJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCompilationJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCompilationJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DescribeCompilationJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_compilation_job(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCompilationJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCompilationJob",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCompilationJobInput`](crate::input::DescribeCompilationJobInput)
    pub fn builder() -> crate::input::describe_compilation_job_input::Builder {
        crate::input::describe_compilation_job_input::Builder::default()
    }
}

/// See [`DescribeContextInput`](crate::input::DescribeContextInput)
pub mod describe_context_input {
    /// A builder for [`DescribeContextInput`](crate::input::DescribeContextInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) context_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the context to describe.</p>
        pub fn context_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.context_name = Some(input.into());
            self
        }
        /// <p>The name of the context to describe.</p>
        pub fn set_context_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.context_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeContextInput`](crate::input::DescribeContextInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeContextInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeContextInput {
                context_name: self.context_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeContextInputOperationOutputAlias = crate::operation::DescribeContext;
#[doc(hidden)]
pub type DescribeContextInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeContextInput {
    /// Consumes the builder and constructs an Operation<[`DescribeContext`](crate::operation::DescribeContext)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeContext,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeContextInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeContextInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeContextInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DescribeContext",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_context(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeContext::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeContext",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeContextInput`](crate::input::DescribeContextInput)
    pub fn builder() -> crate::input::describe_context_input::Builder {
        crate::input::describe_context_input::Builder::default()
    }
}

/// See [`DescribeDataQualityJobDefinitionInput`](crate::input::DescribeDataQualityJobDefinitionInput)
pub mod describe_data_quality_job_definition_input {
    /// A builder for [`DescribeDataQualityJobDefinitionInput`](crate::input::DescribeDataQualityJobDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_definition_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the data quality monitoring job definition to describe.</p>
        pub fn job_definition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_definition_name = Some(input.into());
            self
        }
        /// <p>The name of the data quality monitoring job definition to describe.</p>
        pub fn set_job_definition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_definition_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDataQualityJobDefinitionInput`](crate::input::DescribeDataQualityJobDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDataQualityJobDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDataQualityJobDefinitionInput {
                job_definition_name: self.job_definition_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDataQualityJobDefinitionInputOperationOutputAlias =
    crate::operation::DescribeDataQualityJobDefinition;
#[doc(hidden)]
pub type DescribeDataQualityJobDefinitionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDataQualityJobDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDataQualityJobDefinition`](crate::operation::DescribeDataQualityJobDefinition)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDataQualityJobDefinition,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDataQualityJobDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDataQualityJobDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDataQualityJobDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DescribeDataQualityJobDefinition",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_data_quality_job_definition(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDataQualityJobDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDataQualityJobDefinition",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDataQualityJobDefinitionInput`](crate::input::DescribeDataQualityJobDefinitionInput)
    pub fn builder() -> crate::input::describe_data_quality_job_definition_input::Builder {
        crate::input::describe_data_quality_job_definition_input::Builder::default()
    }
}

/// See [`DescribeDeviceInput`](crate::input::DescribeDeviceInput)
pub mod describe_device_input {
    /// A builder for [`DescribeDeviceInput`](crate::input::DescribeDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) device_fleet_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Next token of device description.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Next token of device description.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The unique ID of the device.</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>The unique ID of the device.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>The name of the fleet the devices belong to.</p>
        pub fn device_fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_fleet_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet the devices belong to.</p>
        pub fn set_device_fleet_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_fleet_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDeviceInput`](crate::input::DescribeDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDeviceInput {
                next_token: self.next_token,
                device_name: self.device_name,
                device_fleet_name: self.device_fleet_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDeviceInputOperationOutputAlias = crate::operation::DescribeDevice;
#[doc(hidden)]
pub type DescribeDeviceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDeviceInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDevice`](crate::operation::DescribeDevice)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDevice,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DescribeDevice",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_device(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDevice",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDeviceInput`](crate::input::DescribeDeviceInput)
    pub fn builder() -> crate::input::describe_device_input::Builder {
        crate::input::describe_device_input::Builder::default()
    }
}

/// See [`DescribeDeviceFleetInput`](crate::input::DescribeDeviceFleetInput)
pub mod describe_device_fleet_input {
    /// A builder for [`DescribeDeviceFleetInput`](crate::input::DescribeDeviceFleetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_fleet_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the fleet.</p>
        pub fn device_fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_fleet_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_device_fleet_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.device_fleet_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDeviceFleetInput`](crate::input::DescribeDeviceFleetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDeviceFleetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDeviceFleetInput {
                device_fleet_name: self.device_fleet_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDeviceFleetInputOperationOutputAlias = crate::operation::DescribeDeviceFleet;
#[doc(hidden)]
pub type DescribeDeviceFleetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDeviceFleetInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDeviceFleet`](crate::operation::DescribeDeviceFleet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDeviceFleet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDeviceFleetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDeviceFleetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDeviceFleetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DescribeDeviceFleet",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_device_fleet(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDeviceFleet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDeviceFleet",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDeviceFleetInput`](crate::input::DescribeDeviceFleetInput)
    pub fn builder() -> crate::input::describe_device_fleet_input::Builder {
        crate::input::describe_device_fleet_input::Builder::default()
    }
}

/// See [`DescribeDomainInput`](crate::input::DescribeDomainInput)
pub mod describe_domain_input {
    /// A builder for [`DescribeDomainInput`](crate::input::DescribeDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The domain ID.</p>
        pub fn domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_id = Some(input.into());
            self
        }
        /// <p>The domain ID.</p>
        pub fn set_domain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDomainInput`](crate::input::DescribeDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDomainInput {
                domain_id: self.domain_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDomainInputOperationOutputAlias = crate::operation::DescribeDomain;
#[doc(hidden)]
pub type DescribeDomainInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDomainInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDomain`](crate::operation::DescribeDomain)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDomain,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDomainInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDomainInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDomainInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DescribeDomain",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_domain(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDomain",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDomainInput`](crate::input::DescribeDomainInput)
    pub fn builder() -> crate::input::describe_domain_input::Builder {
        crate::input::describe_domain_input::Builder::default()
    }
}

/// See [`DescribeEdgePackagingJobInput`](crate::input::DescribeEdgePackagingJobInput)
pub mod describe_edge_packaging_job_input {
    /// A builder for [`DescribeEdgePackagingJobInput`](crate::input::DescribeEdgePackagingJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) edge_packaging_job_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the edge packaging job.</p>
        pub fn edge_packaging_job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.edge_packaging_job_name = Some(input.into());
            self
        }
        /// <p>The name of the edge packaging job.</p>
        pub fn set_edge_packaging_job_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.edge_packaging_job_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEdgePackagingJobInput`](crate::input::DescribeEdgePackagingJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEdgePackagingJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEdgePackagingJobInput {
                edge_packaging_job_name: self.edge_packaging_job_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEdgePackagingJobInputOperationOutputAlias =
    crate::operation::DescribeEdgePackagingJob;
#[doc(hidden)]
pub type DescribeEdgePackagingJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEdgePackagingJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEdgePackagingJob`](crate::operation::DescribeEdgePackagingJob)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEdgePackagingJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEdgePackagingJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEdgePackagingJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEdgePackagingJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DescribeEdgePackagingJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_edge_packaging_job(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEdgePackagingJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEdgePackagingJob",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEdgePackagingJobInput`](crate::input::DescribeEdgePackagingJobInput)
    pub fn builder() -> crate::input::describe_edge_packaging_job_input::Builder {
        crate::input::describe_edge_packaging_job_input::Builder::default()
    }
}

/// See [`DescribeEndpointInput`](crate::input::DescribeEndpointInput)
pub mod describe_endpoint_input {
    /// A builder for [`DescribeEndpointInput`](crate::input::DescribeEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the endpoint.</p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_name = Some(input.into());
            self
        }
        /// <p>The name of the endpoint.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEndpointInput`](crate::input::DescribeEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEndpointInput {
                endpoint_name: self.endpoint_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEndpointInputOperationOutputAlias = crate::operation::DescribeEndpoint;
#[doc(hidden)]
pub type DescribeEndpointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEndpointInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEndpoint`](crate::operation::DescribeEndpoint)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEndpoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DescribeEndpoint",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_endpoint(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEndpoint",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEndpointInput`](crate::input::DescribeEndpointInput)
    pub fn builder() -> crate::input::describe_endpoint_input::Builder {
        crate::input::describe_endpoint_input::Builder::default()
    }
}

/// See [`DescribeEndpointConfigInput`](crate::input::DescribeEndpointConfigInput)
pub mod describe_endpoint_config_input {
    /// A builder for [`DescribeEndpointConfigInput`](crate::input::DescribeEndpointConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_config_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the endpoint configuration.</p>
        pub fn endpoint_config_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_config_name = Some(input.into());
            self
        }
        /// <p>The name of the endpoint configuration.</p>
        pub fn set_endpoint_config_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_config_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEndpointConfigInput`](crate::input::DescribeEndpointConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEndpointConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEndpointConfigInput {
                endpoint_config_name: self.endpoint_config_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEndpointConfigInputOperationOutputAlias = crate::operation::DescribeEndpointConfig;
#[doc(hidden)]
pub type DescribeEndpointConfigInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEndpointConfigInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEndpointConfig`](crate::operation::DescribeEndpointConfig)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEndpointConfig,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEndpointConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEndpointConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEndpointConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "SageMaker.DescribeEndpointConfig",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_endpoint_config(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEndpointConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEndpointConfig",
            "sagemaker",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::ne