// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AddAssociation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_association`](crate::client::Client::add_association).
///
/// See [`crate::client::fluent_builders::AddAssociation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddAssociation {
    _private: (),
}
impl AddAssociation {
    /// Creates a new builder-style object to manufacture [`AddAssociationInput`](crate::input::AddAssociationInput)
    pub fn builder() -> crate::input::add_association_input::Builder {
        crate::input::add_association_input::Builder::default()
    }
    /// Creates a new `AddAssociation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddAssociation {
    type Output =
        std::result::Result<crate::output::AddAssociationOutput, crate::error::AddAssociationError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_association_error(response)
        } else {
            crate::operation_deser::parse_add_association_response(response)
        }
    }
}

/// Operation shape for `AddTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_tags`](crate::client::Client::add_tags).
///
/// See [`crate::client::fluent_builders::AddTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddTags {
    _private: (),
}
impl AddTags {
    /// Creates a new builder-style object to manufacture [`AddTagsInput`](crate::input::AddTagsInput)
    pub fn builder() -> crate::input::add_tags_input::Builder {
        crate::input::add_tags_input::Builder::default()
    }
    /// Creates a new `AddTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddTags {
    type Output = std::result::Result<crate::output::AddTagsOutput, crate::error::AddTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_tags_error(response)
        } else {
            crate::operation_deser::parse_add_tags_response(response)
        }
    }
}

/// Operation shape for `AssociateTrialComponent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_trial_component`](crate::client::Client::associate_trial_component).
///
/// See [`crate::client::fluent_builders::AssociateTrialComponent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateTrialComponent {
    _private: (),
}
impl AssociateTrialComponent {
    /// Creates a new builder-style object to manufacture [`AssociateTrialComponentInput`](crate::input::AssociateTrialComponentInput)
    pub fn builder() -> crate::input::associate_trial_component_input::Builder {
        crate::input::associate_trial_component_input::Builder::default()
    }
    /// Creates a new `AssociateTrialComponent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateTrialComponent {
    type Output = std::result::Result<
        crate::output::AssociateTrialComponentOutput,
        crate::error::AssociateTrialComponentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_trial_component_error(response)
        } else {
            crate::operation_deser::parse_associate_trial_component_response(response)
        }
    }
}

/// Operation shape for `CreateAction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_action`](crate::client::Client::create_action).
///
/// See [`crate::client::fluent_builders::CreateAction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAction {
    _private: (),
}
impl CreateAction {
    /// Creates a new builder-style object to manufacture [`CreateActionInput`](crate::input::CreateActionInput)
    pub fn builder() -> crate::input::create_action_input::Builder {
        crate::input::create_action_input::Builder::default()
    }
    /// Creates a new `CreateAction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAction {
    type Output =
        std::result::Result<crate::output::CreateActionOutput, crate::error::CreateActionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_action_error(response)
        } else {
            crate::operation_deser::parse_create_action_response(response)
        }
    }
}

/// Operation shape for `CreateAlgorithm`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_algorithm`](crate::client::Client::create_algorithm).
///
/// See [`crate::client::fluent_builders::CreateAlgorithm`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAlgorithm {
    _private: (),
}
impl CreateAlgorithm {
    /// Creates a new builder-style object to manufacture [`CreateAlgorithmInput`](crate::input::CreateAlgorithmInput)
    pub fn builder() -> crate::input::create_algorithm_input::Builder {
        crate::input::create_algorithm_input::Builder::default()
    }
    /// Creates a new `CreateAlgorithm` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAlgorithm {
    type Output = std::result::Result<
        crate::output::CreateAlgorithmOutput,
        crate::error::CreateAlgorithmError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_algorithm_error(response)
        } else {
            crate::operation_deser::parse_create_algorithm_response(response)
        }
    }
}

/// Operation shape for `CreateApp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_app`](crate::client::Client::create_app).
///
/// See [`crate::client::fluent_builders::CreateApp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateApp {
    _private: (),
}
impl CreateApp {
    /// Creates a new builder-style object to manufacture [`CreateAppInput`](crate::input::CreateAppInput)
    pub fn builder() -> crate::input::create_app_input::Builder {
        crate::input::create_app_input::Builder::default()
    }
    /// Creates a new `CreateApp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateApp {
    type Output = std::result::Result<crate::output::CreateAppOutput, crate::error::CreateAppError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_app_error(response)
        } else {
            crate::operation_deser::parse_create_app_response(response)
        }
    }
}

/// Operation shape for `CreateAppImageConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_app_image_config`](crate::client::Client::create_app_image_config).
///
/// See [`crate::client::fluent_builders::CreateAppImageConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAppImageConfig {
    _private: (),
}
impl CreateAppImageConfig {
    /// Creates a new builder-style object to manufacture [`CreateAppImageConfigInput`](crate::input::CreateAppImageConfigInput)
    pub fn builder() -> crate::input::create_app_image_config_input::Builder {
        crate::input::create_app_image_config_input::Builder::default()
    }
    /// Creates a new `CreateAppImageConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAppImageConfig {
    type Output = std::result::Result<
        crate::output::CreateAppImageConfigOutput,
        crate::error::CreateAppImageConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_app_image_config_error(response)
        } else {
            crate::operation_deser::parse_create_app_image_config_response(response)
        }
    }
}

/// Operation shape for `CreateArtifact`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_artifact`](crate::client::Client::create_artifact).
///
/// See [`crate::client::fluent_builders::CreateArtifact`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateArtifact {
    _private: (),
}
impl CreateArtifact {
    /// Creates a new builder-style object to manufacture [`CreateArtifactInput`](crate::input::CreateArtifactInput)
    pub fn builder() -> crate::input::create_artifact_input::Builder {
        crate::input::create_artifact_input::Builder::default()
    }
    /// Creates a new `CreateArtifact` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateArtifact {
    type Output =
        std::result::Result<crate::output::CreateArtifactOutput, crate::error::CreateArtifactError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_artifact_error(response)
        } else {
            crate::operation_deser::parse_create_artifact_response(response)
        }
    }
}

/// Operation shape for `CreateAutoMLJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_auto_ml_job`](crate::client::Client::create_auto_ml_job).
///
/// See [`crate::client::fluent_builders::CreateAutoMLJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAutoMLJob {
    _private: (),
}
impl CreateAutoMLJob {
    /// Creates a new builder-style object to manufacture [`CreateAutoMlJobInput`](crate::input::CreateAutoMlJobInput)
    pub fn builder() -> crate::input::create_auto_ml_job_input::Builder {
        crate::input::create_auto_ml_job_input::Builder::default()
    }
    /// Creates a new `CreateAutoMLJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAutoMLJob {
    type Output = std::result::Result<
        crate::output::CreateAutoMlJobOutput,
        crate::error::CreateAutoMLJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_auto_ml_job_error(response)
        } else {
            crate::operation_deser::parse_create_auto_ml_job_response(response)
        }
    }
}

/// Operation shape for `CreateCodeRepository`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_code_repository`](crate::client::Client::create_code_repository).
///
/// See [`crate::client::fluent_builders::CreateCodeRepository`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCodeRepository {
    _private: (),
}
impl CreateCodeRepository {
    /// Creates a new builder-style object to manufacture [`CreateCodeRepositoryInput`](crate::input::CreateCodeRepositoryInput)
    pub fn builder() -> crate::input::create_code_repository_input::Builder {
        crate::input::create_code_repository_input::Builder::default()
    }
    /// Creates a new `CreateCodeRepository` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCodeRepository {
    type Output = std::result::Result<
        crate::output::CreateCodeRepositoryOutput,
        crate::error::CreateCodeRepositoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_code_repository_error(response)
        } else {
            crate::operation_deser::parse_create_code_repository_response(response)
        }
    }
}

/// Operation shape for `CreateCompilationJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_compilation_job`](crate::client::Client::create_compilation_job).
///
/// See [`crate::client::fluent_builders::CreateCompilationJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCompilationJob {
    _private: (),
}
impl CreateCompilationJob {
    /// Creates a new builder-style object to manufacture [`CreateCompilationJobInput`](crate::input::CreateCompilationJobInput)
    pub fn builder() -> crate::input::create_compilation_job_input::Builder {
        crate::input::create_compilation_job_input::Builder::default()
    }
    /// Creates a new `CreateCompilationJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCompilationJob {
    type Output = std::result::Result<
        crate::output::CreateCompilationJobOutput,
        crate::error::CreateCompilationJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_compilation_job_error(response)
        } else {
            crate::operation_deser::parse_create_compilation_job_response(response)
        }
    }
}

/// Operation shape for `CreateContext`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_context`](crate::client::Client::create_context).
///
/// See [`crate::client::fluent_builders::CreateContext`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateContext {
    _private: (),
}
impl CreateContext {
    /// Creates a new builder-style object to manufacture [`CreateContextInput`](crate::input::CreateContextInput)
    pub fn builder() -> crate::input::create_context_input::Builder {
        crate::input::create_context_input::Builder::default()
    }
    /// Creates a new `CreateContext` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateContext {
    type Output =
        std::result::Result<crate::output::CreateContextOutput, crate::error::CreateContextError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_context_error(response)
        } else {
            crate::operation_deser::parse_create_context_response(response)
        }
    }
}

/// Operation shape for `CreateDataQualityJobDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_data_quality_job_definition`](crate::client::Client::create_data_quality_job_definition).
///
/// See [`crate::client::fluent_builders::CreateDataQualityJobDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDataQualityJobDefinition {
    _private: (),
}
impl CreateDataQualityJobDefinition {
    /// Creates a new builder-style object to manufacture [`CreateDataQualityJobDefinitionInput`](crate::input::CreateDataQualityJobDefinitionInput)
    pub fn builder() -> crate::input::create_data_quality_job_definition_input::Builder {
        crate::input::create_data_quality_job_definition_input::Builder::default()
    }
    /// Creates a new `CreateDataQualityJobDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDataQualityJobDefinition {
    type Output = std::result::Result<
        crate::output::CreateDataQualityJobDefinitionOutput,
        crate::error::CreateDataQualityJobDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_data_quality_job_definition_error(response)
        } else {
            crate::operation_deser::parse_create_data_quality_job_definition_response(response)
        }
    }
}

/// Operation shape for `CreateDeviceFleet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_device_fleet`](crate::client::Client::create_device_fleet).
///
/// See [`crate::client::fluent_builders::CreateDeviceFleet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDeviceFleet {
    _private: (),
}
impl CreateDeviceFleet {
    /// Creates a new builder-style object to manufacture [`CreateDeviceFleetInput`](crate::input::CreateDeviceFleetInput)
    pub fn builder() -> crate::input::create_device_fleet_input::Builder {
        crate::input::create_device_fleet_input::Builder::default()
    }
    /// Creates a new `CreateDeviceFleet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDeviceFleet {
    type Output = std::result::Result<
        crate::output::CreateDeviceFleetOutput,
        crate::error::CreateDeviceFleetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_device_fleet_error(response)
        } else {
            crate::operation_deser::parse_create_device_fleet_response(response)
        }
    }
}

/// Operation shape for `CreateDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_domain`](crate::client::Client::create_domain).
///
/// See [`crate::client::fluent_builders::CreateDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDomain {
    _private: (),
}
impl CreateDomain {
    /// Creates a new builder-style object to manufacture [`CreateDomainInput`](crate::input::CreateDomainInput)
    pub fn builder() -> crate::input::create_domain_input::Builder {
        crate::input::create_domain_input::Builder::default()
    }
    /// Creates a new `CreateDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDomain {
    type Output =
        std::result::Result<crate::output::CreateDomainOutput, crate::error::CreateDomainError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_domain_error(response)
        } else {
            crate::operation_deser::parse_create_domain_response(response)
        }
    }
}

/// Operation shape for `CreateEdgePackagingJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_edge_packaging_job`](crate::client::Client::create_edge_packaging_job).
///
/// See [`crate::client::fluent_builders::CreateEdgePackagingJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateEdgePackagingJob {
    _private: (),
}
impl CreateEdgePackagingJob {
    /// Creates a new builder-style object to manufacture [`CreateEdgePackagingJobInput`](crate::input::CreateEdgePackagingJobInput)
    pub fn builder() -> crate::input::create_edge_packaging_job_input::Builder {
        crate::input::create_edge_packaging_job_input::Builder::default()
    }
    /// Creates a new `CreateEdgePackagingJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateEdgePackagingJob {
    type Output = std::result::Result<
        crate::output::CreateEdgePackagingJobOutput,
        crate::error::CreateEdgePackagingJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_edge_packaging_job_error(response)
        } else {
            crate::operation_deser::parse_create_edge_packaging_job_response(response)
        }
    }
}

/// Operation shape for `CreateEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_endpoint`](crate::client::Client::create_endpoint).
///
/// See [`crate::client::fluent_builders::CreateEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateEndpoint {
    _private: (),
}
impl CreateEndpoint {
    /// Creates a new builder-style object to manufacture [`CreateEndpointInput`](crate::input::CreateEndpointInput)
    pub fn builder() -> crate::input::create_endpoint_input::Builder {
        crate::input::create_endpoint_input::Builder::default()
    }
    /// Creates a new `CreateEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateEndpoint {
    type Output =
        std::result::Result<crate::output::CreateEndpointOutput, crate::error::CreateEndpointError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_endpoint_error(response)
        } else {
            crate::operation_deser::parse_create_endpoint_response(response)
        }
    }
}

/// Operation shape for `CreateEndpointConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_endpoint_config`](crate::client::Client::create_endpoint_config).
///
/// See [`crate::client::fluent_builders::CreateEndpointConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateEndpointConfig {
    _private: (),
}
impl CreateEndpointConfig {
    /// Creates a new builder-style object to manufacture [`CreateEndpointConfigInput`](crate::input::CreateEndpointConfigInput)
    pub fn builder() -> crate::input::create_endpoint_config_input::Builder {
        crate::input::create_endpoint_config_input::Builder::default()
    }
    /// Creates a new `CreateEndpointConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateEndpointConfig {
    type Output = std::result::Result<
        crate::output::CreateEndpointConfigOutput,
        crate::error::CreateEndpointConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_endpoint_config_error(response)
        } else {
            crate::operation_deser::parse_create_endpoint_config_response(response)
        }
    }
}

/// Operation shape for `CreateExperiment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_experiment`](crate::client::Client::create_experiment).
///
/// See [`crate::client::fluent_builders::CreateExperiment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateExperiment {
    _private: (),
}
impl CreateExperiment {
    /// Creates a new builder-style object to manufacture [`CreateExperimentInput`](crate::input::CreateExperimentInput)
    pub fn builder() -> crate::input::create_experiment_input::Builder {
        crate::input::create_experiment_input::Builder::default()
    }
    /// Creates a new `CreateExperiment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateExperiment {
    type Output = std::result::Result<
        crate::output::CreateExperimentOutput,
        crate::error::CreateExperimentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_experiment_error(response)
        } else {
            crate::operation_deser::parse_create_experiment_response(response)
        }
    }
}

/// Operation shape for `CreateFeatureGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_feature_group`](crate::client::Client::create_feature_group).
///
/// See [`crate::client::fluent_builders::CreateFeatureGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFeatureGroup {
    _private: (),
}
impl CreateFeatureGroup {
    /// Creates a new builder-style object to manufacture [`CreateFeatureGroupInput`](crate::input::CreateFeatureGroupInput)
    pub fn builder() -> crate::input::create_feature_group_input::Builder {
        crate::input::create_feature_group_input::Builder::default()
    }
    /// Creates a new `CreateFeatureGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFeatureGroup {
    type Output = std::result::Result<
        crate::output::CreateFeatureGroupOutput,
        crate::error::CreateFeatureGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_feature_group_error(response)
        } else {
            crate::operation_deser::parse_create_feature_group_response(response)
        }
    }
}

/// Operation shape for `CreateFlowDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_flow_definition`](crate::client::Client::create_flow_definition).
///
/// See [`crate::client::fluent_builders::CreateFlowDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFlowDefinition {
    _private: (),
}
impl CreateFlowDefinition {
    /// Creates a new builder-style object to manufacture [`CreateFlowDefinitionInput`](crate::input::CreateFlowDefinitionInput)
    pub fn builder() -> crate::input::create_flow_definition_input::Builder {
        crate::input::create_flow_definition_input::Builder::default()
    }
    /// Creates a new `CreateFlowDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFlowDefinition {
    type Output = std::result::Result<
        crate::output::CreateFlowDefinitionOutput,
        crate::error::CreateFlowDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_flow_definition_error(response)
        } else {
            crate::operation_deser::parse_create_flow_definition_response(response)
        }
    }
}

/// Operation shape for `CreateHumanTaskUi`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_human_task_ui`](crate::client::Client::create_human_task_ui).
///
/// See [`crate::client::fluent_builders::CreateHumanTaskUi`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateHumanTaskUi {
    _private: (),
}
impl CreateHumanTaskUi {
    /// Creates a new builder-style object to manufacture [`CreateHumanTaskUiInput`](crate::input::CreateHumanTaskUiInput)
    pub fn builder() -> crate::input::create_human_task_ui_input::Builder {
        crate::input::create_human_task_ui_input::Builder::default()
    }
    /// Creates a new `CreateHumanTaskUi` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateHumanTaskUi {
    type Output = std::result::Result<
        crate::output::CreateHumanTaskUiOutput,
        crate::error::CreateHumanTaskUiError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_human_task_ui_error(response)
        } else {
            crate::operation_deser::parse_create_human_task_ui_response(response)
        }
    }
}

/// Operation shape for `CreateHyperParameterTuningJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_hyper_parameter_tuning_job`](crate::client::Client::create_hyper_parameter_tuning_job).
///
/// See [`crate::client::fluent_builders::CreateHyperParameterTuningJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateHyperParameterTuningJob {
    _private: (),
}
impl CreateHyperParameterTuningJob {
    /// Creates a new builder-style object to manufacture [`CreateHyperParameterTuningJobInput`](crate::input::CreateHyperParameterTuningJobInput)
    pub fn builder() -> crate::input::create_hyper_parameter_tuning_job_input::Builder {
        crate::input::create_hyper_parameter_tuning_job_input::Builder::default()
    }
    /// Creates a new `CreateHyperParameterTuningJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateHyperParameterTuningJob {
    type Output = std::result::Result<
        crate::output::CreateHyperParameterTuningJobOutput,
        crate::error::CreateHyperParameterTuningJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_hyper_parameter_tuning_job_error(response)
        } else {
            crate::operation_deser::parse_create_hyper_parameter_tuning_job_response(response)
        }
    }
}

/// Operation shape for `CreateImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_image`](crate::client::Client::create_image).
///
/// See [`crate::client::fluent_builders::CreateImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateImage {
    _private: (),
}
impl CreateImage {
    /// Creates a new builder-style object to manufacture [`CreateImageInput`](crate::input::CreateImageInput)
    pub fn builder() -> crate::input::create_image_input::Builder {
        crate::input::create_image_input::Builder::default()
    }
    /// Creates a new `CreateImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateImage {
    type Output =
        std::result::Result<crate::output::CreateImageOutput, crate::error::CreateImageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_image_error(response)
        } else {
            crate::operation_deser::parse_create_image_response(response)
        }
    }
}

/// Operation shape for `CreateImageVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_image_version`](crate::client::Client::create_image_version).
///
/// See [`crate::client::fluent_builders::CreateImageVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateImageVersion {
    _private: (),
}
impl CreateImageVersion {
    /// Creates a new builder-style object to manufacture [`CreateImageVersionInput`](crate::input::CreateImageVersionInput)
    pub fn builder() -> crate::input::create_image_version_input::Builder {
        crate::input::create_image_version_input::Builder::default()
    }
    /// Creates a new `CreateImageVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateImageVersion {
    type Output = std::result::Result<
        crate::output::CreateImageVersionOutput,
        crate::error::CreateImageVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_image_version_error(response)
        } else {
            crate::operation_deser::parse_create_image_version_response(response)
        }
    }
}

/// Operation shape for `CreateLabelingJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_labeling_job`](crate::client::Client::create_labeling_job).
///
/// See [`crate::client::fluent_builders::CreateLabelingJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLabelingJob {
    _private: (),
}
impl CreateLabelingJob {
    /// Creates a new builder-style object to manufacture [`CreateLabelingJobInput`](crate::input::CreateLabelingJobInput)
    pub fn builder() -> crate::input::create_labeling_job_input::Builder {
        crate::input::create_labeling_job_input::Builder::default()
    }
    /// Creates a new `CreateLabelingJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLabelingJob {
    type Output = std::result::Result<
        crate::output::CreateLabelingJobOutput,
        crate::error::CreateLabelingJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_labeling_job_error(response)
        } else {
            crate::operation_deser::parse_create_labeling_job_response(response)
        }
    }
}

/// Operation shape for `CreateModel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_model`](crate::client::Client::create_model).
///
/// See [`crate::client::fluent_builders::CreateModel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateModel {
    _private: (),
}
impl CreateModel {
    /// Creates a new builder-style object to manufacture [`CreateModelInput`](crate::input::CreateModelInput)
    pub fn builder() -> crate::input::create_model_input::Builder {
        crate::input::create_model_input::Builder::default()
    }
    /// Creates a new `CreateModel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateModel {
    type Output =
        std::result::Result<crate::output::CreateModelOutput, crate::error::CreateModelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_model_error(response)
        } else {
            crate::operation_deser::parse_create_model_response(response)
        }
    }
}

/// Operation shape for `CreateModelBiasJobDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_model_bias_job_definition`](crate::client::Client::create_model_bias_job_definition).
///
/// See [`crate::client::fluent_builders::CreateModelBiasJobDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateModelBiasJobDefinition {
    _private: (),
}
impl CreateModelBiasJobDefinition {
    /// Creates a new builder-style object to manufacture [`CreateModelBiasJobDefinitionInput`](crate::input::CreateModelBiasJobDefinitionInput)
    pub fn builder() -> crate::input::create_model_bias_job_definition_input::Builder {
        crate::input::create_model_bias_job_definition_input::Builder::default()
    }
    /// Creates a new `CreateModelBiasJobDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateModelBiasJobDefinition {
    type Output = std::result::Result<
        crate::output::CreateModelBiasJobDefinitionOutput,
        crate::error::CreateModelBiasJobDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_model_bias_job_definition_error(response)
        } else {
            crate::operation_deser::parse_create_model_bias_job_definition_response(response)
        }
    }
}

/// Operation shape for `CreateModelExplainabilityJobDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_model_explainability_job_definition`](crate::client::Client::create_model_explainability_job_definition).
///
/// See [`crate::client::fluent_builders::CreateModelExplainabilityJobDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateModelExplainabilityJobDefinition {
    _private: (),
}
impl CreateModelExplainabilityJobDefinition {
    /// Creates a new builder-style object to manufacture [`CreateModelExplainabilityJobDefinitionInput`](crate::input::CreateModelExplainabilityJobDefinitionInput)
    pub fn builder() -> crate::input::create_model_explainability_job_definition_input::Builder {
        crate::input::create_model_explainability_job_definition_input::Builder::default()
    }
    /// Creates a new `CreateModelExplainabilityJobDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateModelExplainabilityJobDefinition {
    type Output = std::result::Result<
        crate::output::CreateModelExplainabilityJobDefinitionOutput,
        crate::error::CreateModelExplainabilityJobDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_model_explainability_job_definition_error(response)
        } else {
            crate::operation_deser::parse_create_model_explainability_job_definition_response(
                response,
            )
        }
    }
}

/// Operation shape for `CreateModelPackage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_model_package`](crate::client::Client::create_model_package).
///
/// See [`crate::client::fluent_builders::CreateModelPackage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateModelPackage {
    _private: (),
}
impl CreateModelPackage {
    /// Creates a new builder-style object to manufacture [`CreateModelPackageInput`](crate::input::CreateModelPackageInput)
    pub fn builder() -> crate::input::create_model_package_input::Builder {
        crate::input::create_model_package_input::Builder::default()
    }
    /// Creates a new `CreateModelPackage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateModelPackage {
    type Output = std::result::Result<
        crate::output::CreateModelPackageOutput,
        crate::error::CreateModelPackageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_model_package_error(response)
        } else {
            crate::operation_deser::parse_create_model_package_response(response)
        }
    }
}

/// Operation shape for `CreateModelPackageGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_model_package_group`](crate::client::Client::create_model_package_group).
///
/// See [`crate::client::fluent_builders::CreateModelPackageGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateModelPackageGroup {
    _private: (),
}
impl CreateModelPackageGroup {
    /// Creates a new builder-style object to manufacture [`CreateModelPackageGroupInput`](crate::input::CreateModelPackageGroupInput)
    pub fn builder() -> crate::input::create_model_package_group_input::Builder {
        crate::input::create_model_package_group_input::Builder::default()
    }
    /// Creates a new `CreateModelPackageGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateModelPackageGroup {
    type Output = std::result::Result<
        crate::output::CreateModelPackageGroupOutput,
        crate::error::CreateModelPackageGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_model_package_group_error(response)
        } else {
            crate::operation_deser::parse_create_model_package_group_response(response)
        }
    }
}

/// Operation shape for `CreateModelQualityJobDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_model_quality_job_definition`](crate::client::Client::create_model_quality_job_definition).
///
/// See [`crate::client::fluent_builders::CreateModelQualityJobDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateModelQualityJobDefinition {
    _private: (),
}
impl CreateModelQualityJobDefinition {
    /// Creates a new builder-style object to manufacture [`CreateModelQualityJobDefinitionInput`](crate::input::CreateModelQualityJobDefinitionInput)
    pub fn builder() -> crate::input::create_model_quality_job_definition_input::Builder {
        crate::input::create_model_quality_job_definition_input::Builder::default()
    }
    /// Creates a new `CreateModelQualityJobDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateModelQualityJobDefinition {
    type Output = std::result::Result<
        crate::output::CreateModelQualityJobDefinitionOutput,
        crate::error::CreateModelQualityJobDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_model_quality_job_definition_error(response)
        } else {
            crate::operation_deser::parse_create_model_quality_job_definition_response(response)
        }
    }
}

/// Operation shape for `CreateMonitoringSchedule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_monitoring_schedule`](crate::client::Client::create_monitoring_schedule).
///
/// See [`crate::client::fluent_builders::CreateMonitoringSchedule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMonitoringSchedule {
    _private: (),
}
impl CreateMonitoringSchedule {
    /// Creates a new builder-style object to manufacture [`CreateMonitoringScheduleInput`](crate::input::CreateMonitoringScheduleInput)
    pub fn builder() -> crate::input::create_monitoring_schedule_input::Builder {
        crate::input::create_monitoring_schedule_input::Builder::default()
    }
    /// Creates a new `CreateMonitoringSchedule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMonitoringSchedule {
    type Output = std::result::Result<
        crate::output::CreateMonitoringScheduleOutput,
        crate::error::CreateMonitoringScheduleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_monitoring_schedule_error(response)
        } else {
            crate::operation_deser::parse_create_monitoring_schedule_response(response)
        }
    }
}

/// Operation shape for `CreateNotebookInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_notebook_instance`](crate::client::Client::create_notebook_instance).
///
/// See [`crate::client::fluent_builders::CreateNotebookInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateNotebookInstance {
    _private: (),
}
impl CreateNotebookInstance {
    /// Creates a new builder-style object to manufacture [`CreateNotebookInstanceInput`](crate::input::CreateNotebookInstanceInput)
    pub fn builder() -> crate::input::create_notebook_instance_input::Builder {
        crate::input::create_notebook_instance_input::Builder::default()
    }
    /// Creates a new `CreateNotebookInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateNotebookInstance {
    type Output = std::result::Result<
        crate::output::CreateNotebookInstanceOutput,
        crate::error::CreateNotebookInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_notebook_instance_error(response)
        } else {
            crate::operation_deser::parse_create_notebook_instance_response(response)
        }
    }
}

/// Operation shape for `CreateNotebookInstanceLifecycleConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_notebook_instance_lifecycle_config`](crate::client::Client::create_notebook_instance_lifecycle_config).
///
/// See [`crate::client::fluent_builders::CreateNotebookInstanceLifecycleConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateNotebookInstanceLifecycleConfig {
    _private: (),
}
impl CreateNotebookInstanceLifecycleConfig {
    /// Creates a new builder-style object to manufacture [`CreateNotebookInstanceLifecycleConfigInput`](crate::input::CreateNotebookInstanceLifecycleConfigInput)
    pub fn builder() -> crate::input::create_notebook_instance_lifecycle_config_input::Builder {
        crate::input::create_notebook_instance_lifecycle_config_input::Builder::default()
    }
    /// Creates a new `CreateNotebookInstanceLifecycleConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateNotebookInstanceLifecycleConfig {
    type Output = std::result::Result<
        crate::output::CreateNotebookInstanceLifecycleConfigOutput,
        crate::error::CreateNotebookInstanceLifecycleConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_notebook_instance_lifecycle_config_error(response)
        } else {
            crate::operation_deser::parse_create_notebook_instance_lifecycle_config_response(
                response,
            )
        }
    }
}

/// Operation shape for `CreatePipeline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_pipeline`](crate::client::Client::create_pipeline).
///
/// See [`crate::client::fluent_builders::CreatePipeline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePipeline {
    _private: (),
}
impl CreatePipeline {
    /// Creates a new builder-style object to manufacture [`CreatePipelineInput`](crate::input::CreatePipelineInput)
    pub fn builder() -> crate::input::create_pipeline_input::Builder {
        crate::input::create_pipeline_input::Builder::default()
    }
    /// Creates a new `CreatePipeline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePipeline {
    type Output =
        std::result::Result<crate::output::CreatePipelineOutput, crate::error::CreatePipelineError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_pipeline_error(response)
        } else {
            crate::operation_deser::parse_create_pipeline_response(response)
        }
    }
}

/// Operation shape for `CreatePresignedDomainUrl`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_presigned_domain_url`](crate::client::Client::create_presigned_domain_url).
///
/// See [`crate::client::fluent_builders::CreatePresignedDomainUrl`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePresignedDomainUrl {
    _private: (),
}
impl CreatePresignedDomainUrl {
    /// Creates a new builder-style object to manufacture [`CreatePresignedDomainUrlInput`](crate::input::CreatePresignedDomainUrlInput)
    pub fn builder() -> crate::input::create_presigned_domain_url_input::Builder {
        crate::input::create_presigned_domain_url_input::Builder::default()
    }
    /// Creates a new `CreatePresignedDomainUrl` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePresignedDomainUrl {
    type Output = std::result::Result<
        crate::output::CreatePresignedDomainUrlOutput,
        crate::error::CreatePresignedDomainUrlError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_presigned_domain_url_error(response)
        } else {
            crate::operation_deser::parse_create_presigned_domain_url_response(response)
        }
    }
}

/// Operation shape for `CreatePresignedNotebookInstanceUrl`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_presigned_notebook_instance_url`](crate::client::Client::create_presigned_notebook_instance_url).
///
/// See [`crate::client::fluent_builders::CreatePresignedNotebookInstanceUrl`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePresignedNotebookInstanceUrl {
    _private: (),
}
impl CreatePresignedNotebookInstanceUrl {
    /// Creates a new builder-style object to manufacture [`CreatePresignedNotebookInstanceUrlInput`](crate::input::CreatePresignedNotebookInstanceUrlInput)
    pub fn builder() -> crate::input::create_presigned_notebook_instance_url_input::Builder {
        crate::input::create_presigned_notebook_instance_url_input::Builder::default()
    }
    /// Creates a new `CreatePresignedNotebookInstanceUrl` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePresignedNotebookInstanceUrl {
    type Output = std::result::Result<
        crate::output::CreatePresignedNotebookInstanceUrlOutput,
        crate::error::CreatePresignedNotebookInstanceUrlError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_presigned_notebook_instance_url_error(response)
        } else {
            crate::operation_deser::parse_create_presigned_notebook_instance_url_response(response)
        }
    }
}

/// Operation shape for `CreateProcessingJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_processing_job`](crate::client::Client::create_processing_job).
///
/// See [`crate::client::fluent_builders::CreateProcessingJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateProcessingJob {
    _private: (),
}
impl CreateProcessingJob {
    /// Creates a new builder-style object to manufacture [`CreateProcessingJobInput`](crate::input::CreateProcessingJobInput)
    pub fn builder() -> crate::input::create_processing_job_input::Builder {
        crate::input::create_processing_job_input::Builder::default()
    }
    /// Creates a new `CreateProcessingJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateProcessingJob {
    type Output = std::result::Result<
        crate::output::CreateProcessingJobOutput,
        crate::error::CreateProcessingJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_processing_job_error(response)
        } else {
            crate::operation_deser::parse_create_processing_job_response(response)
        }
    }
}

/// Operation shape for `CreateProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_project`](crate::client::Client::create_project).
///
/// See [`crate::client::fluent_builders::CreateProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateProject {
    _private: (),
}
impl CreateProject {
    /// Creates a new builder-style object to manufacture [`CreateProjectInput`](crate::input::CreateProjectInput)
    pub fn builder() -> crate::input::create_project_input::Builder {
        crate::input::create_project_input::Builder::default()
    }
    /// Creates a new `CreateProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateProject {
    type Output =
        std::result::Result<crate::output::CreateProjectOutput, crate::error::CreateProjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_project_error(response)
        } else {
            crate::operation_deser::parse_create_project_response(response)
        }
    }
}

/// Operation shape for `CreateStudioLifecycleConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_studio_lifecycle_config`](crate::client::Client::create_studio_lifecycle_config).
///
/// See [`crate::client::fluent_builders::CreateStudioLifecycleConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateStudioLifecycleConfig {
    _private: (),
}
impl CreateStudioLifecycleConfig {
    /// Creates a new builder-style object to manufacture [`CreateStudioLifecycleConfigInput`](crate::input::CreateStudioLifecycleConfigInput)
    pub fn builder() -> crate::input::create_studio_lifecycle_config_input::Builder {
        crate::input::create_studio_lifecycle_config_input::Builder::default()
    }
    /// Creates a new `CreateStudioLifecycleConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateStudioLifecycleConfig {
    type Output = std::result::Result<
        crate::output::CreateStudioLifecycleConfigOutput,
        crate::error::CreateStudioLifecycleConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_studio_lifecycle_config_error(response)
        } else {
            crate::operation_deser::parse_create_studio_lifecycle_config_response(response)
        }
    }
}

/// Operation shape for `CreateTrainingJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_training_job`](crate::client::Client::create_training_job).
///
/// See [`crate::client::fluent_builders::CreateTrainingJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTrainingJob {
    _private: (),
}
impl CreateTrainingJob {
    /// Creates a new builder-style object to manufacture [`CreateTrainingJobInput`](crate::input::CreateTrainingJobInput)
    pub fn builder() -> crate::input::create_training_job_input::Builder {
        crate::input::create_training_job_input::Builder::default()
    }
    /// Creates a new `CreateTrainingJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTrainingJob {
    type Output = std::result::Result<
        crate::output::CreateTrainingJobOutput,
        crate::error::CreateTrainingJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_training_job_error(response)
        } else {
            crate::operation_deser::parse_create_training_job_response(response)
        }
    }
}

/// Operation shape for `CreateTransformJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_transform_job`](crate::client::Client::create_transform_job).
///
/// See [`crate::client::fluent_builders::CreateTransformJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTransformJob {
    _private: (),
}
impl CreateTransformJob {
    /// Creates a new builder-style object to manufacture [`CreateTransformJobInput`](crate::input::CreateTransformJobInput)
    pub fn builder() -> crate::input::create_transform_job_input::Builder {
        crate::input::create_transform_job_input::Builder::default()
    }
    /// Creates a new `CreateTransformJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTransformJob {
    type Output = std::result::Result<
        crate::output::CreateTransformJobOutput,
        crate::error::CreateTransformJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_transform_job_error(response)
        } else {
            crate::operation_deser::parse_create_transform_job_response(response)
        }
    }
}

/// Operation shape for `CreateTrial`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_trial`](crate::client::Client::create_trial).
///
/// See [`crate::client::fluent_builders::CreateTrial`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTrial {
    _private: (),
}
impl CreateTrial {
    /// Creates a new builder-style object to manufacture [`CreateTrialInput`](crate::input::CreateTrialInput)
    pub fn builder() -> crate::input::create_trial_input::Builder {
        crate::input::create_trial_input::Builder::default()
    }
    /// Creates a new `CreateTrial` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTrial {
    type Output =
        std::result::Result<crate::output::CreateTrialOutput, crate::error::CreateTrialError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_trial_error(response)
        } else {
            crate::operation_deser::parse_create_trial_response(response)
        }
    }
}

/// Operation shape for `CreateTrialComponent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_trial_component`](crate::client::Client::create_trial_component).
///
/// See [`crate::client::fluent_builders::CreateTrialComponent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTrialComponent {
    _private: (),
}
impl CreateTrialComponent {
    /// Creates a new builder-style object to manufacture [`CreateTrialComponentInput`](crate::input::CreateTrialComponentInput)
    pub fn builder() -> crate::input::create_trial_component_input::Builder {
        crate::input::create_trial_component_input::Builder::default()
    }
    /// Creates a new `CreateTrialComponent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTrialComponent {
    type Output = std::result::Result<
        crate::output::CreateTrialComponentOutput,
        crate::error::CreateTrialComponentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_trial_component_error(response)
        } else {
            crate::operation_deser::parse_create_trial_component_response(response)
        }
    }
}

/// Operation shape for `CreateUserProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_user_profile`](crate::client::Client::create_user_profile).
///
/// See [`crate::client::fluent_builders::CreateUserProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUserProfile {
    _private: (),
}
impl CreateUserProfile {
    /// Creates a new builder-style object to manufacture [`CreateUserProfileInput`](crate::input::CreateUserProfileInput)
    pub fn builder() -> crate::input::create_user_profile_input::Builder {
        crate::input::create_user_profile_input::Builder::default()
    }
    /// Creates a new `CreateUserProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUserProfile {
    type Output = std::result::Result<
        crate::output::CreateUserProfileOutput,
        crate::error::CreateUserProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_user_profile_error(response)
        } else {
            crate::operation_deser::parse_create_user_profile_response(response)
        }
    }
}

/// Operation shape for `CreateWorkforce`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_workforce`](crate::client::Client::create_workforce).
///
/// See [`crate::client::fluent_builders::CreateWorkforce`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateWorkforce {
    _private: (),
}
impl CreateWorkforce {
    /// Creates a new builder-style object to manufacture [`CreateWorkforceInput`](crate::input::CreateWorkforceInput)
    pub fn builder() -> crate::input::create_workforce_input::Builder {
        crate::input::create_workforce_input::Builder::default()
    }
    /// Creates a new `CreateWorkforce` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateWorkforce {
    type Output = std::result::Result<
        crate::output::CreateWorkforceOutput,
        crate::error::CreateWorkforceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_workforce_error(response)
        } else {
            crate::operation_deser::parse_create_workforce_response(response)
        }
    }
}

/// Operation shape for `CreateWorkteam`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_workteam`](crate::client::Client::create_workteam).
///
/// See [`crate::client::fluent_builders::CreateWorkteam`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateWorkteam {
    _private: (),
}
impl CreateWorkteam {
    /// Creates a new builder-style object to manufacture [`CreateWorkteamInput`](crate::input::CreateWorkteamInput)
    pub fn builder() -> crate::input::create_workteam_input::Builder {
        crate::input::create_workteam_input::Builder::default()
    }
    /// Creates a new `CreateWorkteam` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateWorkteam {
    type Output =
        std::result::Result<crate::output::CreateWorkteamOutput, crate::error::CreateWorkteamError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_workteam_error(response)
        } else {
            crate::operation_deser::parse_create_workteam_response(response)
        }
    }
}

/// Operation shape for `DeleteAction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_action`](crate::client::Client::delete_action).
///
/// See [`crate::client::fluent_builders::DeleteAction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAction {
    _private: (),
}
impl DeleteAction {
    /// Creates a new builder-style object to manufacture [`DeleteActionInput`](crate::input::DeleteActionInput)
    pub fn builder() -> crate::input::delete_action_input::Builder {
        crate::input::delete_action_input::Builder::default()
    }
    /// Creates a new `DeleteAction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAction {
    type Output =
        std::result::Result<crate::output::DeleteActionOutput, crate::error::DeleteActionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_action_error(response)
        } else {
            crate::operation_deser::parse_delete_action_response(response)
        }
    }
}

/// Operation shape for `DeleteAlgorithm`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_algorithm`](crate::client::Client::delete_algorithm).
///
/// See [`crate::client::fluent_builders::DeleteAlgorithm`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAlgorithm {
    _private: (),
}
impl DeleteAlgorithm {
    /// Creates a new builder-style object to manufacture [`DeleteAlgorithmInput`](crate::input::DeleteAlgorithmInput)
    pub fn builder() -> crate::input::delete_algorithm_input::Builder {
        crate::input::delete_algorithm_input::Builder::default()
    }
    /// Creates a new `DeleteAlgorithm` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAlgorithm {
    type Output = std::result::Result<
        crate::output::DeleteAlgorithmOutput,
        crate::error::DeleteAlgorithmError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_algorithm_error(response)
        } else {
            crate::operation_deser::parse_delete_algorithm_response(response)
        }
    }
}

/// Operation shape for `DeleteApp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_app`](crate::client::Client::delete_app).
///
/// See [`crate::client::fluent_builders::DeleteApp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteApp {
    _private: (),
}
impl DeleteApp {
    /// Creates a new builder-style object to manufacture [`DeleteAppInput`](crate::input::DeleteAppInput)
    pub fn builder() -> crate::input::delete_app_input::Builder {
        crate::input::delete_app_input::Builder::default()
    }
    /// Creates a new `DeleteApp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteApp {
    type Output = std::result::Result<crate::output::DeleteAppOutput, crate::error::DeleteAppError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_app_error(response)
        } else {
            crate::operation_deser::parse_delete_app_response(response)
        }
    }
}

/// Operation shape for `DeleteAppImageConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_app_image_config`](crate::client::Client::delete_app_image_config).
///
/// See [`crate::client::fluent_builders::DeleteAppImageConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAppImageConfig {
    _private: (),
}
impl DeleteAppImageConfig {
    /// Creates a new builder-style object to manufacture [`DeleteAppImageConfigInput`](crate::input::DeleteAppImageConfigInput)
    pub fn builder() -> crate::input::delete_app_image_config_input::Builder {
        crate::input::delete_app_image_config_input::Builder::default()
    }
    /// Creates a new `DeleteAppImageConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAppImageConfig {
    type Output = std::result::Result<
        crate::output::DeleteAppImageConfigOutput,
        crate::error::DeleteAppImageConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_app_image_config_error(response)
        } else {
            crate::operation_deser::parse_delete_app_image_config_response(response)
        }
    }
}

/// Operation shape for `DeleteArtifact`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_artifact`](crate::client::Client::delete_artifact).
///
/// See [`crate::client::fluent_builders::DeleteArtifact`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteArtifact {
    _private: (),
}
impl DeleteArtifact {
    /// Creates a new builder-style object to manufacture [`DeleteArtifactInput`](crate::input::DeleteArtifactInput)
    pub fn builder() -> crate::input::delete_artifact_input::Builder {
        crate::input::delete_artifact_input::Builder::default()
    }
    /// Creates a new `DeleteArtifact` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteArtifact {
    type Output =
        std::result::Result<crate::output::DeleteArtifactOutput, crate::error::DeleteArtifactError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_artifact_error(response)
        } else {
            crate::operation_deser::parse_delete_artifact_response(response)
        }
    }
}

/// Operation shape for `DeleteAssociation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_association`](crate::client::Client::delete_association).
///
/// See [`crate::client::fluent_builders::DeleteAssociation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAssociation {
    _private: (),
}
impl DeleteAssociation {
    /// Creates a new builder-style object to manufacture [`DeleteAssociationInput`](crate::input::DeleteAssociationInput)
    pub fn builder() -> crate::input::delete_association_input::Builder {
        crate::input::delete_association_input::Builder::default()
    }
    /// Creates a new `DeleteAssociation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAssociation {
    type Output = std::result::Result<
        crate::output::DeleteAssociationOutput,
        crate::error::DeleteAssociationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_association_error(response)
        } else {
            crate::operation_deser::parse_delete_association_response(response)
        }
    }
}

/// Operation shape for `DeleteCodeRepository`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_code_repository`](crate::client::Client::delete_code_repository).
///
/// See [`crate::client::fluent_builders::DeleteCodeRepository`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCodeRepository {
    _private: (),
}
impl DeleteCodeRepository {
    /// Creates a new builder-style object to manufacture [`DeleteCodeRepositoryInput`](crate::input::DeleteCodeRepositoryInput)
    pub fn builder() -> crate::input::delete_code_repository_input::Builder {
        crate::input::delete_code_repository_input::Builder::default()
    }
    /// Creates a new `DeleteCodeRepository` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCodeRepository {
    type Output = std::result::Result<
        crate::output::DeleteCodeRepositoryOutput,
        crate::error::DeleteCodeRepositoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_code_repository_error(response)
        } else {
            crate::operation_deser::parse_delete_code_repository_response(response)
        }
    }
}

/// Operation shape for `DeleteContext`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_context`](crate::client::Client::delete_context).
///
/// See [`crate::client::fluent_builders::DeleteContext`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteContext {
    _private: (),
}
impl DeleteContext {
    /// Creates a new builder-style object to manufacture [`DeleteContextInput`](crate::input::DeleteContextInput)
    pub fn builder() -> crate::input::delete_context_input::Builder {
        crate::input::delete_context_input::Builder::default()
    }
    /// Creates a new `DeleteContext` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteContext {
    type Output =
        std::result::Result<crate::output::DeleteContextOutput, crate::error::DeleteContextError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_context_error(response)
        } else {
            crate::operation_deser::parse_delete_context_response(response)
        }
    }
}

/// Operation shape for `DeleteDataQualityJobDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_data_quality_job_definition`](crate::client::Client::delete_data_quality_job_definition).
///
/// See [`crate::client::fluent_builders::DeleteDataQualityJobDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDataQualityJobDefinition {
    _private: (),
}
impl DeleteDataQualityJobDefinition {
    /// Creates a new builder-style object to manufacture [`DeleteDataQualityJobDefinitionInput`](crate::input::DeleteDataQualityJobDefinitionInput)
    pub fn builder() -> crate::input::delete_data_quality_job_definition_input::Builder {
        crate::input::delete_data_quality_job_definition_input::Builder::default()
    }
    /// Creates a new `DeleteDataQualityJobDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDataQualityJobDefinition {
    type Output = std::result::Result<
        crate::output::DeleteDataQualityJobDefinitionOutput,
        crate::error::DeleteDataQualityJobDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_data_quality_job_definition_error(response)
        } else {
            crate::operation_deser::parse_delete_data_quality_job_definition_response(response)
        }
    }
}

/// Operation shape for `DeleteDeviceFleet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_device_fleet`](crate::client::Client::delete_device_fleet).
///
/// See [`crate::client::fluent_builders::DeleteDeviceFleet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDeviceFleet {
    _private: (),
}
impl DeleteDeviceFleet {
    /// Creates a new builder-style object to manufacture [`DeleteDeviceFleetInput`](crate::input::DeleteDeviceFleetInput)
    pub fn builder() -> crate::input::delete_device_fleet_input::Builder {
        crate::input::delete_device_fleet_input::Builder::default()
    }
    /// Creates a new `DeleteDeviceFleet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDeviceFleet {
    type Output = std::result::Result<
        crate::output::DeleteDeviceFleetOutput,
        crate::error::DeleteDeviceFleetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_device_fleet_error(response)
        } else {
            crate::operation_deser::parse_delete_device_fleet_response(response)
        }
    }
}

/// Operation shape for `DeleteDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_domain`](crate::client::Client::delete_domain).
///
/// See [`crate::client::fluent_builders::DeleteDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDomain {
    _private: (),
}
impl DeleteDomain {
    /// Creates a new builder-style object to manufacture [`DeleteDomainInput`](crate::input::DeleteDomainInput)
    pub fn builder() -> crate::input::delete_domain_input::Builder {
        crate::input::delete_domain_input::Builder::default()
    }
    /// Creates a new `DeleteDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDomain {
    type Output =
        std::result::Result<crate::output::DeleteDomainOutput, crate::error::DeleteDomainError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_domain_error(response)
        } else {
            crate::operation_deser::parse_delete_domain_response(response)
        }
    }
}

/// Operation shape for `DeleteEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_endpoint`](crate::client::Client::delete_endpoint).
///
/// See [`crate::client::fluent_builders::DeleteEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEndpoint {
    _private: (),
}
impl DeleteEndpoint {
    /// Creates a new builder-style object to manufacture [`DeleteEndpointInput`](crate::input::DeleteEndpointInput)
    pub fn builder() -> crate::input::delete_endpoint_input::Builder {
        crate::input::delete_endpoint_input::Builder::default()
    }
    /// Creates a new `DeleteEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEndpoint {
    type Output =
        std::result::Result<crate::output::DeleteEndpointOutput, crate::error::DeleteEndpointError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_endpoint_error(response)
        } else {
            crate::operation_deser::parse_delete_endpoint_response(response)
        }
    }
}

/// Operation shape for `DeleteEndpointConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_endpoint_config`](crate::client::Client::delete_endpoint_config).
///
/// See [`crate::client::fluent_builders::DeleteEndpointConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEndpointConfig {
    _private: (),
}
impl DeleteEndpointConfig {
    /// Creates a new builder-style object to manufacture [`DeleteEndpointConfigInput`](crate::input::DeleteEndpointConfigInput)
    pub fn builder() -> crate::input::delete_endpoint_config_input::Builder {
        crate::input::delete_endpoint_config_input::Builder::default()
    }
    /// Creates a new `DeleteEndpointConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEndpointConfig {
    type Output = std::result::Result<
        crate::output::DeleteEndpointConfigOutput,
        crate::error::DeleteEndpointConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_endpoint_config_error(response)
        } else {
            crate::operation_deser::parse_delete_endpoint_config_response(response)
        }
    }
}

/// Operation shape for `DeleteExperiment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_experiment`](crate::client::Client::delete_experiment).
///
/// See [`crate::client::fluent_builders::DeleteExperiment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteExperiment {
    _private: (),
}
impl DeleteExperiment {
    /// Creates a new builder-style object to manufacture [`DeleteExperimentInput`](crate::input::DeleteExperimentInput)
    pub fn builder() -> crate::input::delete_experiment_input::Builder {
        crate::input::delete_experiment_input::Builder::default()
    }
    /// Creates a new `DeleteExperiment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteExperiment {
    type Output = std::result::Result<
        crate::output::DeleteExperimentOutput,
        crate::error::DeleteExperimentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_experiment_error(response)
        } else {
            crate::operation_deser::parse_delete_experiment_response(response)
        }
    }
}

/// Operation shape for `DeleteFeatureGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_feature_group`](crate::client::Client::delete_feature_group).
///
/// See [`crate::client::fluent_builders::DeleteFeatureGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFeatureGroup {
    _private: (),
}
impl DeleteFeatureGroup {
    /// Creates a new builder-style object to manufacture [`DeleteFeatureGroupInput`](crate::input::DeleteFeatureGroupInput)
    pub fn builder() -> crate::input::delete_feature_group_input::Builder {
        crate::input::delete_feature_group_input::Builder::default()
    }
    /// Creates a new `DeleteFeatureGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFeatureGroup {
    type Output = std::result::Result<
        crate::output::DeleteFeatureGroupOutput,
        crate::error::DeleteFeatureGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_feature_group_error(response)
        } else {
            crate::operation_deser::parse_delete_feature_group_response(response)
        }
    }
}

/// Operation shape for `DeleteFlowDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_flow_definition`](crate::client::Client::delete_flow_definition).
///
/// See [`crate::client::fluent_builders::DeleteFlowDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFlowDefinition {
    _private: (),
}
impl DeleteFlowDefinition {
    /// Creates a new builder-style object to manufacture [`DeleteFlowDefinitionInput`](crate::input::DeleteFlowDefinitionInput)
    pub fn builder() -> crate::input::delete_flow_definition_input::Builder {
        crate::input::delete_flow_definition_input::Builder::default()
    }
    /// Creates a new `DeleteFlowDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFlowDefinition {
    type Output = std::result::Result<
        crate::output::DeleteFlowDefinitionOutput,
        crate::error::DeleteFlowDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_flow_definition_error(response)
        } else {
            crate::operation_deser::parse_delete_flow_definition_response(response)
        }
    }
}

/// Operation shape for `DeleteHumanTaskUi`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_human_task_ui`](crate::client::Client::delete_human_task_ui).
///
/// See [`crate::client::fluent_builders::DeleteHumanTaskUi`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteHumanTaskUi {
    _private: (),
}
impl DeleteHumanTaskUi {
    /// Creates a new builder-style object to manufacture [`DeleteHumanTaskUiInput`](crate::input::DeleteHumanTaskUiInput)
    pub fn builder() -> crate::input::delete_human_task_ui_input::Builder {
        crate::input::delete_human_task_ui_input::Builder::default()
    }
    /// Creates a new `DeleteHumanTaskUi` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteHumanTaskUi {
    type Output = std::result::Result<
        crate::output::DeleteHumanTaskUiOutput,
        crate::error::DeleteHumanTaskUiError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_human_task_ui_error(response)
        } else {
            crate::operation_deser::parse_delete_human_task_ui_response(response)
        }
    }
}

/// Operation shape for `DeleteImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_image`](crate::client::Client::delete_image).
///
/// See [`crate::client::fluent_builders::DeleteImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteImage {
    _private: (),
}
impl DeleteImage {
    /// Creates a new builder-style object to manufacture [`DeleteImageInput`](crate::input::DeleteImageInput)
    pub fn builder() -> crate::input::delete_image_input::Builder {
        crate::input::delete_image_input::Builder::default()
    }
    /// Creates a new `DeleteImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteImage {
    type Output =
        std::result::Result<crate::output::DeleteImageOutput, crate::error::DeleteImageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_image_error(response)
        } else {
            crate::operation_deser::parse_delete_image_response(response)
        }
    }
}

/// Operation shape for `DeleteImageVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_image_version`](crate::client::Client::delete_image_version).
///
/// See [`crate::client::fluent_builders::DeleteImageVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteImageVersion {
    _private: (),
}
impl DeleteImageVersion {
    /// Creates a new builder-style object to manufacture [`DeleteImageVersionInput`](crate::input::DeleteImageVersionInput)
    pub fn builder() -> crate::input::delete_image_version_input::Builder {
        crate::input::delete_image_version_input::Builder::default()
    }
    /// Creates a new `DeleteImageVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteImageVersion {
    type Output = std::result::Result<
        crate::output::DeleteImageVersionOutput,
        crate::error::DeleteImageVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_image_version_error(response)
        } else {
            crate::operation_deser::parse_delete_image_version_response(response)
        }
    }
}

/// Operation shape for `DeleteModel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_model`](crate::client::Client::delete_model).
///
/// See [`crate::client::fluent_builders::DeleteModel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteModel {
    _private: (),
}
impl DeleteModel {
    /// Creates a new builder-style object to manufacture [`DeleteModelInput`](crate::input::DeleteModelInput)
    pub fn builder() -> crate::input::delete_model_input::Builder {
        crate::input::delete_model_input::Builder::default()
    }
    /// Creates a new `DeleteModel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteModel {
    type Output =
        std::result::Result<crate::output::DeleteModelOutput, crate::error::DeleteModelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_model_error(response)
        } else {
            crate::operation_deser::parse_delete_model_response(response)
        }
    }
}

/// Operation shape for `DeleteModelBiasJobDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_model_bias_job_definition`](crate::client::Client::delete_model_bias_job_definition).
///
/// See [`crate::client::fluent_builders::DeleteModelBiasJobDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteModelBiasJobDefinition {
    _private: (),
}
impl DeleteModelBiasJobDefinition {
    /// Creates a new builder-style object to manufacture [`DeleteModelBiasJobDefinitionInput`](crate::input::DeleteModelBiasJobDefinitionInput)
    pub fn builder() -> crate::input::delete_model_bias_job_definition_input::Builder {
        crate::input::delete_model_bias_job_definition_input::Builder::default()
    }
    /// Creates a new `DeleteModelBiasJobDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteModelBiasJobDefinition {
    type Output = std::result::Result<
        crate::output::DeleteModelBiasJobDefinitionOutput,
        crate::error::DeleteModelBiasJobDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_model_bias_job_definition_error(response)
        } else {
            crate::operation_deser::parse_delete_model_bias_job_definition_response(response)
        }
    }
}

/// Operation shape for `DeleteModelExplainabilityJobDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_model_explainability_job_definition`](crate::client::Client::delete_model_explainability_job_definition).
///
/// See [`crate::client::fluent_builders::DeleteModelExplainabilityJobDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteModelExplainabilityJobDefinition {
    _private: (),
}
impl DeleteModelExplainabilityJobDefinition {
    /// Creates a new builder-style object to manufacture [`DeleteModelExplainabilityJobDefinitionInput`](crate::input::DeleteModelExplainabilityJobDefinitionInput)
    pub fn builder() -> crate::input::delete_model_explainability_job_definition_input::Builder {
        crate::input::delete_model_explainability_job_definition_input::Builder::default()
    }
    /// Creates a new `DeleteModelExplainabilityJobDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteModelExplainabilityJobDefinition {
    type Output = std::result::Result<
        crate::output::DeleteModelExplainabilityJobDefinitionOutput,
        crate::error::DeleteModelExplainabilityJobDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_model_explainability_job_definition_error(response)
        } else {
            crate::operation_deser::parse_delete_model_explainability_job_definition_response(
                response,
            )
        }
    }
}

/// Operation shape for `DeleteModelPackage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_model_package`](crate::client::Client::delete_model_package).
///
/// See [`crate::client::fluent_builders::DeleteModelPackage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteModelPackage {
    _private: (),
}
impl DeleteModelPackage {
    /// Creates a new builder-style object to manufacture [`DeleteModelPackageInput`](crate::input::DeleteModelPackageInput)
    pub fn builder() -> crate::input::delete_model_package_input::Builder {
        crate::input::delete_model_package_input::Builder::default()
    }
    /// Creates a new `DeleteModelPackage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteModelPackage {
    type Output = std::result::Result<
        crate::output::DeleteModelPackageOutput,
        crate::error::DeleteModelPackageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_model_package_error(response)
        } else {
            crate::operation_deser::parse_delete_model_package_response(response)
        }
    }
}

/// Operation shape for `DeleteModelPackageGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_model_package_group`](crate::client::Client::delete_model_package_group).
///
/// See [`crate::client::fluent_builders::DeleteModelPackageGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteModelPackageGroup {
    _private: (),
}
impl DeleteModelPackageGroup {
    /// Creates a new builder-style object to manufacture [`DeleteModelPackageGroupInput`](crate::input::DeleteModelPackageGroupInput)
    pub fn builder() -> crate::input::delete_model_package_group_input::Builder {
        crate::input::delete_model_package_group_input::Builder::default()
    }
    /// Creates a new `DeleteModelPackageGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteModelPackageGroup {
    type Output = std::result::Result<
        crate::output::DeleteModelPackageGroupOutput,
        crate::error::DeleteModelPackageGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_model_package_group_error(response)
        } else {
            crate::operation_deser::parse_delete_model_package_group_response(response)
        }
    }
}

/// Operation shape for `DeleteModelPackageGroupPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_model_package_group_policy`](crate::client::Client::delete_model_package_group_policy).
///
/// See [`crate::client::fluent_builders::DeleteModelPackageGroupPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteModelPackageGroupPolicy {
    _private: (),
}
impl DeleteModelPackageGroupPolicy {
    /// Creates a new builder-style object to manufacture [`DeleteModelPackageGroupPolicyInput`](crate::input::DeleteModelPackageGroupPolicyInput)
    pub fn builder() -> crate::input::delete_model_package_group_policy_input::Builder {
        crate::input::delete_model_package_group_policy_input::Builder::default()
    }
    /// Creates a new `DeleteModelPackageGroupPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteModelPackageGroupPolicy {
    type Output = std::result::Result<
        crate::output::DeleteModelPackageGroupPolicyOutput,
        crate::error::DeleteModelPackageGroupPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_model_package_group_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_model_package_group_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteModelQualityJobDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_model_quality_job_definition`](crate::client::Client::delete_model_quality_job_definition).
///
/// See [`crate::client::fluent_builders::DeleteModelQualityJobDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteModelQualityJobDefinition {
    _private: (),
}
impl DeleteModelQualityJobDefinition {
    /// Creates a new builder-style object to manufacture [`DeleteModelQualityJobDefinitionInput`](crate::input::DeleteModelQualityJobDefinitionInput)
    pub fn builder() -> crate::input::delete_model_quality_job_definition_input::Builder {
        crate::input::delete_model_quality_job_definition_input::Builder::default()
    }
    /// Creates a new `DeleteModelQualityJobDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteModelQualityJobDefinition {
    type Output = std::result::Result<
        crate::output::DeleteModelQualityJobDefinitionOutput,
        crate::error::DeleteModelQualityJobDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_model_quality_job_definition_error(response)
        } else {
            crate::operation_deser::parse_delete_model_quality_job_definition_response(response)
        }
    }
}

/// Operation shape for `DeleteMonitoringSchedule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_monitoring_schedule`](crate::client::Client::delete_monitoring_schedule).
///
/// See [`crate::client::fluent_builders::DeleteMonitoringSchedule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMonitoringSchedule {
    _private: (),
}
impl DeleteMonitoringSchedule {
    /// Creates a new builder-style object to manufacture [`DeleteMonitoringScheduleInput`](crate::input::DeleteMonitoringScheduleInput)
    pub fn builder() -> crate::input::delete_monitoring_schedule_input::Builder {
        crate::input::delete_monitoring_schedule_input::Builder::default()
    }
    /// Creates a new `DeleteMonitoringSchedule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMonitoringSchedule {
    type Output = std::result::Result<
        crate::output::DeleteMonitoringScheduleOutput,
        crate::error::DeleteMonitoringScheduleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_monitoring_schedule_error(response)
        } else {
            crate::operation_deser::parse_delete_monitoring_schedule_response(response)
        }
    }
}

/// Operation shape for `DeleteNotebookInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_notebook_instance`](crate::client::Client::delete_notebook_instance).
///
/// See [`crate::client::fluent_builders::DeleteNotebookInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteNotebookInstance {
    _private: (),
}
impl DeleteNotebookInstance {
    /// Creates a new builder-style object to manufacture [`DeleteNotebookInstanceInput`](crate::input::DeleteNotebookInstanceInput)
    pub fn builder() -> crate::input::delete_notebook_instance_input::Builder {
        crate::input::delete_notebook_instance_input::Builder::default()
    }
    /// Creates a new `DeleteNotebookInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteNotebookInstance {
    type Output = std::result::Result<
        crate::output::DeleteNotebookInstanceOutput,
        crate::error::DeleteNotebookInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_notebook_instance_error(response)
        } else {
            crate::operation_deser::parse_delete_notebook_instance_response(response)
        }
    }
}

/// Operation shape for `DeleteNotebookInstanceLifecycleConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_notebook_instance_lifecycle_config`](crate::client::Client::delete_notebook_instance_lifecycle_config).
///
/// See [`crate::client::fluent_builders::DeleteNotebookInstanceLifecycleConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteNotebookInstanceLifecycleConfig {
    _private: (),
}
impl DeleteNotebookInstanceLifecycleConfig {
    /// Creates a new builder-style object to manufacture [`DeleteNotebookInstanceLifecycleConfigInput`](crate::input::DeleteNotebookInstanceLifecycleConfigInput)
    pub fn builder() -> crate::input::delete_notebook_instance_lifecycle_config_input::Builder {
        crate::input::delete_notebook_instance_lifecycle_config_input::Builder::default()
    }
    /// Creates a new `DeleteNotebookInstanceLifecycleConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteNotebookInstanceLifecycleConfig {
    type Output = std::result::Result<
        crate::output::DeleteNotebookInstanceLifecycleConfigOutput,
        crate::error::DeleteNotebookInstanceLifecycleConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_notebook_instance_lifecycle_config_error(response)
        } else {
            crate::operation_deser::parse_delete_notebook_instance_lifecycle_config_response(
                response,
            )
        }
    }
}

/// Operation shape for `DeletePipeline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_pipeline`](crate::client::Client::delete_pipeline).
///
/// See [`crate::client::fluent_builders::DeletePipeline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePipeline {
    _private: (),
}
impl DeletePipeline {
    /// Creates a new builder-style object to manufacture [`DeletePipelineInput`](crate::input::DeletePipelineInput)
    pub fn builder() -> crate::input::delete_pipeline_input::Builder {
        crate::input::delete_pipeline_input::Builder::default()
    }
    /// Creates a new `DeletePipeline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePipeline {
    type Output =
        std::result::Result<crate::output::DeletePipelineOutput, crate::error::DeletePipelineError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_pipeline_error(response)
        } else {
            crate::operation_deser::parse_delete_pipeline_response(response)
        }
    }
}

/// Operation shape for `DeleteProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_project`](crate::client::Client::delete_project).
///
/// See [`crate::client::fluent_builders::DeleteProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteProject {
    _private: (),
}
impl DeleteProject {
    /// Creates a new builder-style object to manufacture [`DeleteProjectInput`](crate::input::DeleteProjectInput)
    pub fn builder() -> crate::input::delete_project_input::Builder {
        crate::input::delete_project_input::Builder::default()
    }
    /// Creates a new `DeleteProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteProject {
    type Output =
        std::result::Result<crate::output::DeleteProjectOutput, crate::error::DeleteProjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_project_error(response)
        } else {
            crate::operation_deser::parse_delete_project_response(response)
        }
    }
}

/// Operation shape for `DeleteStudioLifecycleConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_studio_lifecycle_config`](crate::client::Client::delete_studio_lifecycle_config).
///
/// See [`crate::client::fluent_builders::DeleteStudioLifecycleConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteStudioLifecycleConfig {
    _private: (),
}
impl DeleteStudioLifecycleConfig {
    /// Creates a new builder-style object to manufacture [`DeleteStudioLifecycleConfigInput`](crate::input::DeleteStudioLifecycleConfigInput)
    pub fn builder() -> crate::input::delete_studio_lifecycle_config_input::Builder {
        crate::input::delete_studio_lifecycle_config_input::Builder::default()
    }
    /// Creates a new `DeleteStudioLifecycleConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteStudioLifecycleConfig {
    type Output = std::result::Result<
        crate::output::DeleteStudioLifecycleConfigOutput,
        crate::error::DeleteStudioLifecycleConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_studio_lifecycle_config_error(response)
        } else {
            crate::operation_deser::parse_delete_studio_lifecycle_config_response(response)
        }
    }
}

/// Operation shape for `DeleteTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_tags`](crate::client::Client::delete_tags).
///
/// See [`crate::client::fluent_builders::DeleteTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTags {
    _private: (),
}
impl DeleteTags {
    /// Creates a new builder-style object to manufacture [`DeleteTagsInput`](crate::input::DeleteTagsInput)
    pub fn builder() -> crate::input::delete_tags_input::Builder {
        crate::input::delete_tags_input::Builder::default()
    }
    /// Creates a new `DeleteTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTags {
    type Output =
        std::result::Result<crate::output::DeleteTagsOutput, crate::error::DeleteTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_tags_error(response)
        } else {
            crate::operation_deser::parse_delete_tags_response(response)
        }
    }
}

/// Operation shape for `DeleteTrial`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_trial`](crate::client::Client::delete_trial).
///
/// See [`crate::client::fluent_builders::DeleteTrial`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTrial {
    _private: (),
}
impl DeleteTrial {
    /// Creates a new builder-style object to manufacture [`DeleteTrialInput`](crate::input::DeleteTrialInput)
    pub fn builder() -> crate::input::delete_trial_input::Builder {
        crate::input::delete_trial_input::Builder::default()
    }
    /// Creates a new `DeleteTrial` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTrial {
    type Output =
        std::result::Result<crate::output::DeleteTrialOutput, crate::error::DeleteTrialError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_trial_error(response)
        } else {
            crate::operation_deser::parse_delete_trial_response(response)
        }
    }
}

/// Operation shape for `DeleteTrialComponent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_trial_component`](crate::client::Client::delete_trial_component).
///
/// See [`crate::client::fluent_builders::DeleteTrialComponent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTrialComponent {
    _private: (),
}
impl DeleteTrialComponent {
    /// Creates a new builder-style object to manufacture [`DeleteTrialComponentInput`](crate::input::DeleteTrialComponentInput)
    pub fn builder() -> crate::input::delete_trial_component_input::Builder {
        crate::input::delete_trial_component_input::Builder::default()
    }
    /// Creates a new `DeleteTrialComponent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTrialComponent {
    type Output = std::result::Result<
        crate::output::DeleteTrialComponentOutput,
        crate::error::DeleteTrialComponentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_trial_component_error(response)
        } else {
            crate::operation_deser::parse_delete_trial_component_response(response)
        }
    }
}

/// Operation shape for `DeleteUserProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_user_profile`](crate::client::Client::delete_user_profile).
///
/// See [`crate::client::fluent_builders::DeleteUserProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUserProfile {
    _private: (),
}
impl DeleteUserProfile {
    /// Creates a new builder-style object to manufacture [`DeleteUserProfileInput`](crate::input::DeleteUserProfileInput)
    pub fn builder() -> crate::input::delete_user_profile_input::Builder {
        crate::input::delete_user_profile_input::Builder::default()
    }
    /// Creates a new `DeleteUserProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUserProfile {
    type Output = std::result::Result<
        crate::output::DeleteUserProfileOutput,
        crate::error::DeleteUserProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_user_profile_error(response)
        } else {
            crate::operation_deser::parse_delete_user_profile_response(response)
        }
    }
}

/// Operation shape for `DeleteWorkforce`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_workforce`](crate::client::Client::delete_workforce).
///
/// See [`crate::client::fluent_builders::DeleteWorkforce`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteWorkforce {
    _private: (),
}
impl DeleteWorkforce {
    /// Creates a new builder-style object to manufacture [`DeleteWorkforceInput`](crate::input::DeleteWorkforceInput)
    pub fn builder() -> crate::input::delete_workforce_input::Builder {
        crate::input::delete_workforce_input::Builder::default()
    }
    /// Creates a new `DeleteWorkforce` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteWorkforce {
    type Output = std::result::Result<
        crate::output::DeleteWorkforceOutput,
        crate::error::DeleteWorkforceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_workforce_error(response)
        } else {
            crate::operation_deser::parse_delete_workforce_response(response)
        }
    }
}

/// Operation shape for `DeleteWorkteam`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_workteam`](crate::client::Client::delete_workteam).
///
/// See [`crate::client::fluent_builders::DeleteWorkteam`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteWorkteam {
    _private: (),
}
impl DeleteWorkteam {
    /// Creates a new builder-style object to manufacture [`DeleteWorkteamInput`](crate::input::DeleteWorkteamInput)
    pub fn builder() -> crate::input::delete_workteam_input::Builder {
        crate::input::delete_workteam_input::Builder::default()
    }
    /// Creates a new `DeleteWorkteam` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteWorkteam {
    type Output =
        std::result::Result<crate::output::DeleteWorkteamOutput, crate::error::DeleteWorkteamError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_workteam_error(response)
        } else {
            crate::operation_deser::parse_delete_workteam_response(response)
        }
    }
}

/// Operation shape for `DeregisterDevices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_devices`](crate::client::Client::deregister_devices).
///
/// See [`crate::client::fluent_builders::DeregisterDevices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterDevices {
    _private: (),
}
impl DeregisterDevices {
    /// Creates a new builder-style object to manufacture [`DeregisterDevicesInput`](crate::input::DeregisterDevicesInput)
    pub fn builder() -> crate::input::deregister_devices_input::Builder {
        crate::input::deregister_devices_input::Builder::default()
    }
    /// Creates a new `DeregisterDevices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterDevices {
    type Output = std::result::Result<
        crate::output::DeregisterDevicesOutput,
        crate::error::DeregisterDevicesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_devices_error(response)
        } else {
            crate::operation_deser::parse_deregister_devices_response(response)
        }
    }
}

/// Operation shape for `DescribeAction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_action`](crate::client::Client::describe_action).
///
/// See [`crate::client::fluent_builders::DescribeAction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAction {
    _private: (),
}
impl DescribeAction {
    /// Creates a new builder-style object to manufacture [`DescribeActionInput`](crate::input::DescribeActionInput)
    pub fn builder() -> crate::input::describe_action_input::Builder {
        crate::input::describe_action_input::Builder::default()
    }
    /// Creates a new `DescribeAction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAction {
    type Output =
        std::result::Result<crate::output::DescribeActionOutput, crate::error::DescribeActionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_action_error(response)
        } else {
            crate::operation_deser::parse_describe_action_response(response)
        }
    }
}

/// Operation shape for `DescribeAlgorithm`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_algorithm`](crate::client::Client::describe_algorithm).
///
/// See [`crate::client::fluent_builders::DescribeAlgorithm`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAlgorithm {
    _private: (),
}
impl DescribeAlgorithm {
    /// Creates a new builder-style object to manufacture [`DescribeAlgorithmInput`](crate::input::DescribeAlgorithmInput)
    pub fn builder() -> crate::input::describe_algorithm_input::Builder {
        crate::input::describe_algorithm_input::Builder::default()
    }
    /// Creates a new `DescribeAlgorithm` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAlgorithm {
    type Output = std::result::Result<
        crate::output::DescribeAlgorithmOutput,
        crate::error::DescribeAlgorithmError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_algorithm_error(response)
        } else {
            crate::operation_deser::parse_describe_algorithm_response(response)
        }
    }
}

/// Operation shape for `DescribeApp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_app`](crate::client::Client::describe_app).
///
/// See [`crate::client::fluent_builders::DescribeApp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeApp {
    _private: (),
}
impl DescribeApp {
    /// Creates a new builder-style object to manufacture [`DescribeAppInput`](crate::input::DescribeAppInput)
    pub fn builder() -> crate::input::describe_app_input::Builder {
        crate::input::describe_app_input::Builder::default()
    }
    /// Creates a new `DescribeApp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeApp {
    type Output =
        std::result::Result<crate::output::DescribeAppOutput, crate::error::DescribeAppError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_app_error(response)
        } else {
            crate::operation_deser::parse_describe_app_response(response)
        }
    }
}

/// Operation shape for `DescribeAppImageConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_app_image_config`](crate::client::Client::describe_app_image_config).
///
/// See [`crate::client::fluent_builders::DescribeAppImageConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAppImageConfig {
    _private: (),
}
impl DescribeAppImageConfig {
    /// Creates a new builder-style object to manufacture [`DescribeAppImageConfigInput`](crate::input::DescribeAppImageConfigInput)
    pub fn builder() -> crate::input::describe_app_image_config_input::Builder {
        crate::input::describe_app_image_config_input::Builder::default()
    }
    /// Creates a new `DescribeAppImageConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAppImageConfig {
    type Output = std::result::Result<
        crate::output::DescribeAppImageConfigOutput,
        crate::error::DescribeAppImageConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_app_image_config_error(response)
        } else {
            crate::operation_deser::parse_describe_app_image_config_response(response)
        }
    }
}

/// Operation shape for `DescribeArtifact`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_artifact`](crate::client::Client::describe_artifact).
///
/// See [`crate::client::fluent_builders::DescribeArtifact`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeArtifact {
    _private: (),
}
impl DescribeArtifact {
    /// Creates a new builder-style object to manufacture [`DescribeArtifactInput`](crate::input::DescribeArtifactInput)
    pub fn builder() -> crate::input::describe_artifact_input::Builder {
        crate::input::describe_artifact_input::Builder::default()
    }
    /// Creates a new `DescribeArtifact` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeArtifact {
    type Output = std::result::Result<
        crate::output::DescribeArtifactOutput,
        crate::error::DescribeArtifactError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_artifact_error(response)
        } else {
            crate::operation_deser::parse_describe_artifact_response(response)
        }
    }
}

/// Operation shape for `DescribeAutoMLJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_auto_ml_job`](crate::client::Client::describe_auto_ml_job).
///
/// See [`crate::client::fluent_builders::DescribeAutoMLJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAutoMLJob {
    _private: (),
}
impl DescribeAutoMLJob {
    /// Creates a new builder-style object to manufacture [`DescribeAutoMlJobInput`](crate::input::DescribeAutoMlJobInput)
    pub fn builder() -> crate::input::describe_auto_ml_job_input::Builder {
        crate::input::describe_auto_ml_job_input::Builder::default()
    }
    /// Creates a new `DescribeAutoMLJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAutoMLJob {
    type Output = std::result::Result<
        crate::output::DescribeAutoMlJobOutput,
        crate::error::DescribeAutoMLJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_auto_ml_job_error(response)
        } else {
            crate::operation_deser::parse_describe_auto_ml_job_response(response)
        }
    }
}

/// Operation shape for `DescribeCodeRepository`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_code_repository`](crate::client::Client::describe_code_repository).
///
/// See [`crate::client::fluent_builders::DescribeCodeRepository`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCodeRepository {
    _private: (),
}
impl DescribeCodeRepository {
    /// Creates a new builder-style object to manufacture [`DescribeCodeRepositoryInput`](crate::input::DescribeCodeRepositoryInput)
    pub fn builder() -> crate::input::describe_code_repository_input::Builder {
        crate::input::describe_code_repository_input::Builder::default()
    }
    /// Creates a new `DescribeCodeRepository` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCodeRepository {
    type Output = std::result::Result<
        crate::output::DescribeCodeRepositoryOutput,
        crate::error::DescribeCodeRepositoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_code_repository_error(response)
        } else {
            crate::operation_deser::parse_describe_code_repository_response(response)
        }
    }
}

/// Operation shape for `DescribeCompilationJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_compilation_job`](crate::client::Client::describe_compilation_job).
///
/// See [`crate::client::fluent_builders::DescribeCompilationJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCompilationJob {
    _private: (),
}
impl DescribeCompilationJob {
    /// Creates a new builder-style object to manufacture [`DescribeCompilationJobInput`](crate::input::DescribeCompilationJobInput)
    pub fn builder() -> crate::input::describe_compilation_job_input::Builder {
        crate::input::describe_compilation_job_input::Builder::default()
    }
    /// Creates a new `DescribeCompilationJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCompilationJob {
    type Output = std::result::Result<
        crate::output::DescribeCompilationJobOutput,
        crate::error::DescribeCompilationJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_compilation_job_error(response)
        } else {
            crate::operation_deser::parse_describe_compilation_job_response(response)
        }
    }
}

/// Operation shape for `DescribeContext`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_context`](crate::client::Client::describe_context).
///
/// See [`crate::client::fluent_builders::DescribeContext`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeContext {
    _private: (),
}
impl DescribeContext {
    /// Creates a new builder-style object to manufacture [`DescribeContextInput`](crate::input::DescribeContextInput)
    pub fn builder() -> crate::input::describe_context_input::Builder {
        crate::input::describe_context_input::Builder::default()
    }
    /// Creates a new `DescribeContext` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeContext {
    type Output = std::result::Result<
        crate::output::DescribeContextOutput,
        crate::error::DescribeContextError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_context_error(response)
        } else {
            crate::operation_deser::parse_describe_context_response(response)
        }
    }
}

/// Operation shape for `DescribeDataQualityJobDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_data_quality_job_definition`](crate::client::Client::describe_data_quality_job_definition).
///
/// See [`crate::client::fluent_builders::DescribeDataQualityJobDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDataQualityJobDefinition {
    _private: (),
}
impl DescribeDataQualityJobDefinition {
    /// Creates a new builder-style object to manufacture [`DescribeDataQualityJobDefinitionInput`](crate::input::DescribeDataQualityJobDefinitionInput)
    pub fn builder() -> crate::input::describe_data_quality_job_definition_input::Builder {
        crate::input::describe_data_quality_job_definition_input::Builder::default()
    }
    /// Creates a new `DescribeDataQualityJobDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDataQualityJobDefinition {
    type Output = std::result::Result<
        crate::output::DescribeDataQualityJobDefinitionOutput,
        crate::error::DescribeDataQualityJobDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_data_quality_job_definition_error(response)
        } else {
            crate::operation_deser::parse_describe_data_quality_job_definition_response(response)
        }
    }
}

/// Operation shape for `DescribeDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_device`](crate::client::Client::describe_device).
///
/// See [`crate::client::fluent_builders::DescribeDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDevice {
    _private: (),
}
impl DescribeDevice {
    /// Creates a new builder-style object to manufacture [`DescribeDeviceInput`](crate::input::DescribeDeviceInput)
    pub fn builder() -> crate::input::describe_device_input::Builder {
        crate::input::describe_device_input::Builder::default()
    }
    /// Creates a new `DescribeDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDevice {
    type Output =
        std::result::Result<crate::output::DescribeDeviceOutput, crate::error::DescribeDeviceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_device_error(response)
        } else {
            crate::operation_deser::parse_describe_device_response(response)
        }
    }
}

/// Operation shape for `DescribeDeviceFleet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_device_fleet`](crate::client::Client::describe_device_fleet).
///
/// See [`crate::client::fluent_builders::DescribeDeviceFleet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDeviceFleet {
    _private: (),
}
impl DescribeDeviceFleet {
    /// Creates a new builder-style object to manufacture [`DescribeDeviceFleetInput`](crate::input::DescribeDeviceFleetInput)
    pub fn builder() -> crate::input::describe_device_fleet_input::Builder {
        crate::input::describe_device_fleet_input::Builder::default()
    }
    /// Creates a new `DescribeDeviceFleet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDeviceFleet {
    type Output = std::result::Result<
        crate::output::DescribeDeviceFleetOutput,
        crate::error::DescribeDeviceFleetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_device_fleet_error(response)
        } else {
            crate::operation_deser::parse_describe_device_fleet_response(response)
        }
    }
}

/// Operation shape for `DescribeDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_domain`](crate::client::Client::describe_domain).
///
/// See [`crate::client::fluent_builders::DescribeDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDomain {
    _private: (),
}
impl DescribeDomain {
    /// Creates a new builder-style object to manufacture [`DescribeDomainInput`](crate::input::DescribeDomainInput)
    pub fn builder() -> crate::input::describe_domain_input::Builder {
        crate::input::describe_domain_input::Builder::default()
    }
    /// Creates a new `DescribeDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDomain {
    type Output =
        std::result::Result<crate::output::DescribeDomainOutput, crate::error::DescribeDomainError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_domain_error(response)
        } else {
            crate::operation_deser::parse_describe_domain_response(response)
        }
    }
}

/// Operation shape for `DescribeEdgePackagingJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_edge_packaging_job`](crate::client::Client::describe_edge_packaging_job).
///
/// See [`crate::client::fluent_builders::DescribeEdgePackagingJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEdgePackagingJob {
    _private: (),
}
impl DescribeEdgePackagingJob {
    /// Creates a new builder-style object to manufacture [`DescribeEdgePackagingJobInput`](crate::input::DescribeEdgePackagingJobInput)
    pub fn builder() -> crate::input::describe_edge_packaging_job_input::Builder {
        crate::input::describe_edge_packaging_job_input::Builder::default()
    }
    /// Creates a new `DescribeEdgePackagingJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEdgePackagingJob {
    type Output = std::result::Result<
        crate::output::DescribeEdgePackagingJobOutput,
        crate::error::DescribeEdgePackagingJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_edge_packaging_job_error(response)
        } else {
            crate::operation_deser::parse_describe_edge_packaging_job_response(response)
        }
    }
}

/// Operation shape for `DescribeEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_endpoint`](crate::client::Client::describe_endpoint).
///
/// See [`crate::client::fluent_builders::DescribeEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEndpoint {
    _private: (),
}
impl DescribeEndpoint {
    /// Creates a new builder-style object to manufacture [`DescribeEndpointInput`](crate::input::DescribeEndpointInput)
    pub fn builder() -> crate::input::describe_endpoint_input::Builder {
        crate::input::describe_endpoint_input::Builder::default()
    }
    /// Creates a new `DescribeEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEndpoint {
    type Output = std::result::Result<
        crate::output::DescribeEndpointOutput,
        crate::error::DescribeEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_endpoint_error(response)
        } else {
            crate::operation_deser::parse_describe_endpoint_response(response)
        }
    }
}

/// Operation shape for `DescribeEndpointConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_endpoint_config`](crate::client::Client::describe_endpoint_config).
///
/// See [`crate::client::fluent_builders::DescribeEndpointConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEndpointConfig {
    _private: (),
}
impl DescribeEndpointConfig {
    /// Creates a new builder-style object to manufacture [`DescribeEndpointConfigInput`](crate::input::DescribeEndpointConfigInput)
    pub fn builder() -> crate::input::describe_endpoint_config_input::Builder {
        crate::input::describe_endpoint_config_input::Builder::default()
    }
    /// Creates a new `DescribeEndpointConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEndpointConfig {
    type Output = std::result::Result<
        crate::output::DescribeEndpointConfigOutput,
        crate::error::DescribeEndpointConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_endpoint_config_error(response)
        } else {
            crate::operation_deser::parse_describe_endpoint_config_response(response)
        }
    }
}

/// Operation shape for `DescribeExperiment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_experiment`](crate::client::Client::describe_experiment).
///
/// See [`crate::client::fluent_builders::DescribeExperiment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeExperiment {
    _private: (),
}
impl DescribeExperiment {
    /// Creates a new builder-style object to manufacture [`DescribeExperimentInput`](crate::input::DescribeExperimentInput)
    pub fn builder() -> crate::input::describe_experiment_input::Builder {
        crate::input::describe_experiment_input::Builder::default()
    }
    /// Creates a new `DescribeExperiment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeExperiment {
    type Output = std::result::Result<
        crate::output::DescribeExperimentOutput,
        crate::error::DescribeExperimentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_experiment_error(response)
        } else {
            crate::operation_deser::parse_describe_experiment_response(response)
        }
    }
}

/// Operation shape for `DescribeFeatureGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_feature_group`](crate::client::Client::describe_feature_group).
///
/// See [`crate::client::fluent_builders::DescribeFeatureGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFeatureGroup {
    _private: (),
}
impl DescribeFeatureGroup {
    /// Creates a new builder-style object to manufacture [`DescribeFeatureGroupInput`](crate::input::DescribeFeatureGroupInput)
    pub fn builder() -> crate::input::describe_feature_group_input::Builder {
        crate::input::describe_feature_group_input::Builder::default()
    }
    /// Creates a new `DescribeFeatureGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFeatureGroup {
    type Output = std::result::Result<
        crate::output::DescribeFeatureGroupOutput,
        crate::error::DescribeFeatureGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_feature_group_error(response)
        } else {
            crate::operation_deser::parse_describe_feature_group_response(response)
        }
    }
}

/// Operation shape for `DescribeFlowDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_flow_definition`](crate::client::Client::describe_flow_definition).
///
/// See [`crate::client::fluent_builders::DescribeFlowDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFlowDefinition {
    _private: (),
}
impl DescribeFlowDefinition {
    /// Creates a new builder-style object to manufacture [`DescribeFlowDefinitionInput`](crate::input::DescribeFlowDefinitionInput)
    pub fn builder() -> crate::input::describe_flow_definition_input::Builder {
        crate::input::describe_flow_definition_input::Builder::default()
    }
    /// Creates a new `DescribeFlowDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFlowDefinition {
    type Output = std::result::Result<
        crate::output::DescribeFlowDefinitionOutput,
        crate::error::DescribeFlowDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_flow_definition_error(response)
        } else {
            crate::operation_deser::parse_describe_flow_definition_response(response)
        }
    }
}

/// Operation shape for `DescribeHumanTaskUi`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_human_task_ui`](crate::client::Client::describe_human_task_ui).
///
/// See [`crate::client::fluent_builders::DescribeHumanTaskUi`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeHumanTaskUi {
    _private: (),
}
impl DescribeHumanTaskUi {
    /// Creates a new builder-style object to manufacture [`DescribeHumanTaskUiInput`](crate::input::DescribeHumanTaskUiInput)
    pub fn builder() -> crate::input::describe_human_task_ui_input::Builder {
        crate::input::describe_human_task_ui_input::Builder::default()
    }
    /// Creates a new `DescribeHumanTaskUi` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeHumanTaskUi {
    type Output = std::result::Result<
        crate::output::DescribeHumanTaskUiOutput,
        crate::error::DescribeHumanTaskUiError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_human_task_ui_error(response)
        } else {
            crate::operation_deser::parse_describe_human_task_ui_response(response)
        }
    }
}

/// Operation shape for `DescribeHyperParameterTuningJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_hyper_parameter_tuning_job`](crate::client::Client::describe_hyper_parameter_tuning_job).
///
/// See [`crate::client::fluent_builders::DescribeHyperParameterTuningJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeHyperParameterTuningJob {
    _private: (),
}
impl DescribeHyperParameterTuningJob {
    /// Creates a new builder-style object to manufacture [`DescribeHyperParameterTuningJobInput`](crate::input::DescribeHyperParameterTuningJobInput)
    pub fn builder() -> crate::input::describe_hyper_parameter_tuning_job_input::Builder {
        crate::input::describe_hyper_parameter_tuning_job_input::Builder::default()
    }
    /// Creates a new `DescribeHyperParameterTuningJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeHyperParameterTuningJob {
    type Output = std::result::Result<
        crate::output::DescribeHyperParameterTuningJobOutput,
        crate::error::DescribeHyperParameterTuningJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_hyper_parameter_tuning_job_error(response)
        } else {
            crate::operation_deser::parse_describe_hyper_parameter_tuning_job_response(response)
        }
    }
}

/// Operation shape for `DescribeImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_image`](crate::client::Client::describe_image).
///
/// See [`crate::client::fluent_builders::DescribeImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeImage {
    _private: (),
}
impl DescribeImage {
    /// Creates a new builder-style object to manufacture [`DescribeImageInput`](crate::input::DescribeImageInput)
    pub fn builder() -> crate::input::describe_image_input::Builder {
        crate::input::describe_image_input::Builder::default()
    }
    /// Creates a new `DescribeImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeImage {
    type Output =
        std::result::Result<crate::output::DescribeImageOutput, crate::error::DescribeImageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_image_error(response)
        } else {
            crate::operation_deser::parse_describe_image_response(response)
        }
    }
}

/// Operation shape for `DescribeImageVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_image_version`](crate::client::Client::describe_image_version).
///
/// See [`crate::client::fluent_builders::DescribeImageVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeImageVersion {
    _private: (),
}
impl DescribeImageVersion {
    /// Creates a new builder-style object to manufacture [`DescribeImageVersionInput`](crate::input::DescribeImageVersionInput)
    pub fn builder() -> crate::input::describe_image_version_input::Builder {
        crate::input::describe_image_version_input::Builder::default()
    }
    /// Creates a new `DescribeImageVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeImageVersion {
    type Output = std::result::Result<
        crate::output::DescribeImageVersionOutput,
        crate::error::DescribeImageVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_image_version_error(response)
        } else {
            crate::operation_deser::parse_describe_image_version_response(response)
        }
    }
}

/// Operation shape for `DescribeLabelingJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_labeling_job`](crate::client::Client::describe_labeling_job).
///
/// See [`crate::client::fluent_builders::DescribeLabelingJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLabelingJob {
    _private: (),
}
impl DescribeLabelingJob {
    /// Creates a new builder-style object to manufacture [`DescribeLabelingJobInput`](crate::input::DescribeLabelingJobInput)
    pub fn builder() -> crate::input::describe_labeling_job_input::Builder {
        crate::input::describe_labeling_job_input::Builder::default()
    }
    /// Creates a new `DescribeLabelingJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLabelingJob {
    type Output = std::result::Result<
        crate::output::DescribeLabelingJobOutput,
        crate::error::DescribeLabelingJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_labeling_job_error(response)
        } else {
            crate::operation_deser::parse_describe_labeling_job_response(response)
        }
    }
}

/// Operation shape for `DescribeModel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_model`](crate::client::Client::describe_model).
///
/// See [`crate::client::fluent_builders::DescribeModel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeModel {
    _private: (),
}
impl DescribeModel {
    /// Creates a new builder-style object to manufacture [`DescribeModelInput`](crate::input::DescribeModelInput)
    pub fn builder() -> crate::input::describe_model_input::Builder {
        crate::input::describe_model_input::Builder::default()
    }
    /// Creates a new `DescribeModel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeModel {
    type Output =
        std::result::Result<crate::output::DescribeModelOutput, crate::error::DescribeModelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_model_error(response)
        } else {
            crate::operation_deser::parse_describe_model_response(response)
        }
    }
}

/// Operation shape for `DescribeModelBiasJobDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_model_bias_job_definition`](crate::client::Client::describe_model_bias_job_definition).
///
/// See [`crate::client::fluent_builders::DescribeModelBiasJobDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeModelBiasJobDefinition {
    _private: (),
}
impl DescribeModelBiasJobDefinition {
    /// Creates a new builder-style object to manufacture [`DescribeModelBiasJobDefinitionInput`](crate::input::DescribeModelBiasJobDefinitionInput)
    pub fn builder() -> crate::input::describe_model_bias_job_definition_input::Builder {
        crate::input::describe_model_bias_job_definition_input::Builder::default()
    }
    /// Creates a new `DescribeModelBiasJobDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeModelBiasJobDefinition {
    type Output = std::result::Result<
        crate::output::DescribeModelBiasJobDefinitionOutput,
        crate::error::DescribeModelBiasJobDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_model_bias_job_definition_error(response)
        } else {
            crate::operation_deser::parse_describe_model_bias_job_definition_response(response)
        }
    }
}

/// Operation shape for `DescribeModelExplainabilityJobDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_model_explainability_job_definition`](crate::client::Client::describe_model_explainability_job_definition).
///
/// See [`crate::client::fluent_builders::DescribeModelExplainabilityJobDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeModelExplainabilityJobDefinition {
    _private: (),
}
impl DescribeModelExplainabilityJobDefinition {
    /// Creates a new builder-style object to manufacture [`DescribeModelExplainabilityJobDefinitionInput`](crate::input::DescribeModelExplainabilityJobDefinitionInput)
    pub fn builder() -> crate::input::describe_model_explainability_job_definition_input::Builder {
        crate::input::describe_model_explainability_job_definition_input::Builder::default()
    }
    /// Creates a new `DescribeModelExplainabilityJobDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeModelExplainabilityJobDefinition {
    type Output = std::result::Result<
        crate::output::DescribeModelExplainabilityJobDefinitionOutput,
        crate::error::DescribeModelExplainabilityJobDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_model_explainability_job_definition_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_model_explainability_job_definition_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeModelPackage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_model_package`](crate::client::Client::describe_model_package).
///
/// See [`crate::client::fluent_builders::DescribeModelPackage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeModelPackage {
    _private: (),
}
impl DescribeModelPackage {
    /// Creates a new builder-style object to manufacture [`DescribeModelPackageInput`](crate::input::DescribeModelPackageInput)
    pub fn builder() -> crate::input::describe_model_package_input::Builder {
        crate::input::describe_model_package_input::Builder::default()
    }
    /// Creates a new `DescribeModelPackage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeModelPackage {
    type Output = std::result::Result<
        crate::output::DescribeModelPackageOutput,
        crate::error::DescribeModelPackageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_model_package_error(response)
        } else {
            crate::operation_deser::parse_describe_model_package_response(response)
        }
    }
}

/// Operation shape for `DescribeModelPackageGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_model_package_group`](crate::client::Client::describe_model_package_group).
///
/// See [`crate::client::fluent_builders::DescribeModelPackageGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeModelPackageGroup {
    _private: (),
}
impl DescribeModelPackageGroup {
    /// Creates a new builder-style object to manufacture [`DescribeModelPackageGroupInput`](crate::input::DescribeModelPackageGroupInput)
    pub fn builder() -> crate::input::describe_model_package_group_input::Builder {
        crate::input::describe_model_package_group_input::Builder::default()
    }
    /// Creates a new `DescribeModelPackageGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeModelPackageGroup {
    type Output = std::result::Result<
        crate::output::DescribeModelPackageGroupOutput,
        crate::error::DescribeModelPackageGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_model_package_group_error(response)
        } else {
            crate::operation_deser::parse_describe_model_package_group_response(response)
        }
    }
}

/// Operation shape for `DescribeModelQualityJobDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_model_quality_job_definition`](crate::client::Client::describe_model_quality_job_definition).
///
/// See [`crate::client::fluent_builders::DescribeModelQualityJobDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeModelQualityJobDefinition {
    _private: (),
}
impl DescribeModelQualityJobDefinition {
    /// Creates a new builder-style object to manufacture [`DescribeModelQualityJobDefinitionInput`](crate::input::DescribeModelQualityJobDefinitionInput)
    pub fn builder() -> crate::input::describe_model_quality_job_definition_input::Builder {
        crate::input::describe_model_quality_job_definition_input::Builder::default()
    }
    /// Creates a new `DescribeModelQualityJobDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeModelQualityJobDefinition {
    type Output = std::result::Result<
        crate::output::DescribeModelQualityJobDefinitionOutput,
        crate::error::DescribeModelQualityJobDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_model_quality_job_definition_error(response)
        } else {
            crate::operation_deser::parse_describe_model_quality_job_definition_response(response)
        }
    }
}

/// Operation shape for `DescribeMonitoringSchedule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_monitoring_schedule`](crate::client::Client::describe_monitoring_schedule).
///
/// See [`crate::client::fluent_builders::DescribeMonitoringSchedule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeMonitoringSchedule {
    _private: (),
}
impl DescribeMonitoringSchedule {
    /// Creates a new builder-style object to manufacture [`DescribeMonitoringScheduleInput`](crate::input::DescribeMonitoringScheduleInput)
    pub fn builder() -> crate::input::describe_monitoring_schedule_input::Builder {
        crate::input::describe_monitoring_schedule_input::Builder::default()
    }
    /// Creates a new `DescribeMonitoringSchedule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeMonitoringSchedule {
    type Output = std::result::Result<
        crate::output::DescribeMonitoringScheduleOutput,
        crate::error::DescribeMonitoringScheduleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_monitoring_schedule_error(response)
        } else {
            crate::operation_deser::parse_describe_monitoring_schedule_response(response)
        }
    }
}

/// Operation shape for `DescribeNotebookInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_notebook_instance`](crate::client::Client::describe_notebook_instance).
///
/// See [`crate::client::fluent_builders::DescribeNotebookInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeNotebookInstance {
    _private: (),
}
impl DescribeNotebookInstance {
    /// Creates a new builder-style object to manufacture [`DescribeNotebookInstanceInput`](crate::input::DescribeNotebookInstanceInput)
    pub fn builder() -> crate::input::describe_notebook_instance_input::Builder {
        crate::input::describe_notebook_instance_input::Builder::default()
    }
    /// Creates a new `DescribeNotebookInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeNotebookInstance {
    type Output = std::result::Result<
        crate::output::DescribeNotebookInstanceOutput,
        crate::error::DescribeNotebookInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_notebook_instance_error(response)
        } else {
            crate::operation_deser::parse_describe_notebook_instance_response(response)
        }
    }
}

/// Operation shape for `DescribeNotebookInstanceLifecycleConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_notebook_instance_lifecycle_config`](crate::client::Client::describe_notebook_instance_lifecycle_config).
///
/// See [`crate::client::fluent_builders::DescribeNotebookInstanceLifecycleConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeNotebookInstanceLifecycleConfig {
    _private: (),
}
impl DescribeNotebookInstanceLifecycleConfig {
    /// Creates a new builder-style object to manufacture [`DescribeNotebookInstanceLifecycleConfigInput`](crate::input::DescribeNotebookInstanceLifecycleConfigInput)
    pub fn builder() -> crate::input::describe_notebook_instance_lifecycle_config_input::Builder {
        crate::input::describe_notebook_instance_lifecycle_config_input::Builder::default()
    }
    /// Creates a new `DescribeNotebookInstanceLifecycleConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeNotebookInstanceLifecycleConfig {
    type Output = std::result::Result<
        crate::output::DescribeNotebookInstanceLifecycleConfigOutput,
        crate::error::DescribeNotebookInstanceLifecycleConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_notebook_instance_lifecycle_config_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_notebook_instance_lifecycle_config_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribePipeline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_pipeline`](crate::client::Client::describe_pipeline).
///
/// See [`crate::client::fluent_builders::DescribePipeline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePipeline {
    _private: (),
}
impl DescribePipeline {
    /// Creates a new builder-style object to manufacture [`DescribePipelineInput`](crate::input::DescribePipelineInput)
    pub fn builder() -> crate::input::describe_pipeline_input::Builder {
        crate::input::describe_pipeline_input::Builder::default()
    }
    /// Creates a new `DescribePipeline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePipeline {
    type Output = std::result::Result<
        crate::output::DescribePipelineOutput,
        crate::error::DescribePipelineError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_pipeline_error(response)
        } else {
            crate::operation_deser::parse_describe_pipeline_response(response)
        }
    }
}

/// Operation shape for `DescribePipelineDefinitionForExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_pipeline_definition_for_execution`](crate::client::Client::describe_pipeline_definition_for_execution).
///
/// See [`crate::client::fluent_builders::DescribePipelineDefinitionForExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePipelineDefinitionForExecution {
    _private: (),
}
impl DescribePipelineDefinitionForExecution {
    /// Creates a new builder-style object to manufacture [`DescribePipelineDefinitionForExecutionInput`](crate::input::DescribePipelineDefinitionForExecutionInput)
    pub fn builder() -> crate::input::describe_pipeline_definition_for_execution_input::Builder {
        crate::input::describe_pipeline_definition_for_execution_input::Builder::default()
    }
    /// Creates a new `DescribePipelineDefinitionForExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePipelineDefinitionForExecution {
    type Output = std::result::Result<
        crate::output::DescribePipelineDefinitionForExecutionOutput,
        crate::error::DescribePipelineDefinitionForExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_pipeline_definition_for_execution_error(response)
        } else {
            crate::operation_deser::parse_describe_pipeline_definition_for_execution_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribePipelineExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_pipeline_execution`](crate::client::Client::describe_pipeline_execution).
///
/// See [`crate::client::fluent_builders::DescribePipelineExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePipelineExecution {
    _private: (),
}
impl DescribePipelineExecution {
    /// Creates a new builder-style object to manufacture [`DescribePipelineExecutionInput`](crate::input::DescribePipelineExecutionInput)
    pub fn builder() -> crate::input::describe_pipeline_execution_input::Builder {
        crate::input::describe_pipeline_execution_input::Builder::default()
    }
    /// Creates a new `DescribePipelineExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePipelineExecution {
    type Output = std::result::Result<
        crate::output::DescribePipelineExecutionOutput,
        crate::error::DescribePipelineExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_pipeline_execution_error(response)
        } else {
            crate::operation_deser::parse_describe_pipeline_execution_response(response)
        }
    }
}

/// Operation shape for `DescribeProcessingJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_processing_job`](crate::client::Client::describe_processing_job).
///
/// See [`crate::client::fluent_builders::DescribeProcessingJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeProcessingJob {
    _private: (),
}
impl DescribeProcessingJob {
    /// Creates a new builder-style object to manufacture [`DescribeProcessingJobInput`](crate::input::DescribeProcessingJobInput)
    pub fn builder() -> crate::input::describe_processing_job_input::Builder {
        crate::input::describe_processing_job_input::Builder::default()
    }
    /// Creates a new `DescribeProcessingJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeProcessingJob {
    type Output = std::result::Result<
        crate::output::DescribeProcessingJobOutput,
        crate::error::DescribeProcessingJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_processing_job_error(response)
        } else {
            crate::operation_deser::parse_describe_processing_job_response(response)
        }
    }
}

/// Operation shape for `DescribeProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_project`](crate::client::Client::describe_project).
///
/// See [`crate::client::fluent_builders::DescribeProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeProject {
    _private: (),
}
impl DescribeProject {
    /// Creates a new builder-style object to manufacture [`DescribeProjectInput`](crate::input::DescribeProjectInput)
    pub fn builder() -> crate::input::describe_project_input::Builder {
        crate::input::describe_project_input::Builder::default()
    }
    /// Creates a new `DescribeProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeProject {
    type Output = std::result::Result<
        crate::output::DescribeProjectOutput,
        crate::error::DescribeProjectError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_project_error(response)
        } else {
            crate::operation_deser::parse_describe_project_response(response)
        }
    }
}

/// Operation shape for `DescribeStudioLifecycleConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_studio_lifecycle_config`](crate::client::Client::describe_studio_lifecycle_config).
///
/// See [`crate::client::fluent_builders::DescribeStudioLifecycleConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStudioLifecycleConfig {
    _private: (),
}
impl DescribeStudioLifecycleConfig {
    /// Creates a new builder-style object to manufacture [`DescribeStudioLifecycleConfigInput`](crate::input::DescribeStudioLifecycleConfigInput)
    pub fn builder() -> crate::input::describe_studio_lifecycle_config_input::Builder {
        crate::input::describe_studio_lifecycle_config_input::Builder::default()
    }
    /// Creates a new `DescribeStudioLifecycleConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStudioLifecycleConfig {
    type Output = std::result::Result<
        crate::output::DescribeStudioLifecycleConfigOutput,
        crate::error::DescribeStudioLifecycleConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_studio_lifecycle_config_error(response)
        } else {
            crate::operation_deser::parse_describe_studio_lifecycle_config_response(response)
        }
    }
}

/// Operation shape for `DescribeSubscribedWorkteam`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_subscribed_workteam`](crate::client::Client::describe_subscribed_workteam).
///
/// See [`crate::client::fluent_builders::DescribeSubscribedWorkteam`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSubscribedWorkteam {
    _private: (),
}
impl DescribeSubscribedWorkteam {
    /// Creates a new builder-style object to manufacture [`DescribeSubscribedWorkteamInput`](crate::input::DescribeSubscribedWorkteamInput)
    pub fn builder() -> crate::input::describe_subscribed_workteam_input::Builder {
        crate::input::describe_subscribed_workteam_input::Builder::default()
    }
    /// Creates a new `DescribeSubscribedWorkteam` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSubscribedWorkteam {
    type Output = std::result::Result<
        crate::output::DescribeSubscribedWorkteamOutput,
        crate::error::DescribeSubscribedWorkteamError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_subscribed_workteam_error(response)
        } else {
            crate::operation_deser::parse_describe_subscribed_workteam_response(response)
        }
    }
}

/// Operation shape for `DescribeTrainingJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_training_job`](crate::client::Client::describe_training_job).
///
/// See [`crate::client::fluent_builders::DescribeTrainingJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTrainingJob {
    _private: (),
}
impl DescribeTrainingJob {
    /// Creates a new builder-style object to manufacture [`DescribeTrainingJobInput`](crate::input::DescribeTrainingJobInput)
    pub fn builder() -> crate::input::describe_training_job_input::Builder {
        crate::input::describe_training_job_input::Builder::default()
    }
    /// Creates a new `DescribeTrainingJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTrainingJob {
    type Output = std::result::Result<
        crate::output::DescribeTrainingJobOutput,
        crate::error::DescribeTrainingJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_training_job_error(response)
        } else {
            crate::operation_deser::parse_describe_training_job_response(response)
        }
    }
}

/// Operation shape for `DescribeTransformJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_transform_job`](crate::client::Client::describe_transform_job).
///
/// See [`crate::client::fluent_builders::DescribeTransformJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTransformJob {
    _private: (),
}
impl DescribeTransformJob {
    /// Creates a new builder-style object to manufacture [`DescribeTransformJobInput`](crate::input::DescribeTransformJobInput)
    pub fn builder() -> crate::input::describe_transform_job_input::Builder {
        crate::input::describe_transform_job_input::Builder::default()
    }
    /// Creates a new `DescribeTransformJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTransformJob {
    type Output = std::result::Result<
        crate::output::DescribeTransformJobOutput,
        crate::error::DescribeTransformJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_transform_job_error(response)
        } else {
            crate::operation_deser::parse_describe_transform_job_response(response)
        }
    }
}

/// Operation shape for `DescribeTrial`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_trial`](crate::client::Client::describe_trial).
///
/// See [`crate::client::fluent_builders::DescribeTrial`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTrial {
    _private: (),
}
impl DescribeTrial {
    /// Creates a new builder-style object to manufacture [`DescribeTrialInput`](crate::input::DescribeTrialInput)
    pub fn builder() -> crate::input::describe_trial_input::Builder {
        crate::input::describe_trial_input::Builder::default()
    }
    /// Creates a new `DescribeTrial` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTrial {
    type Output =
        std::result::Result<crate::output::DescribeTrialOutput, crate::error::DescribeTrialError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_trial_error(response)
        } else {
            crate::operation_deser::parse_describe_trial_response(response)
        }
    }
}

/// Operation shape for `DescribeTrialComponent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_trial_component`](crate::client::Client::describe_trial_component).
///
/// See [`crate::client::fluent_builders::DescribeTrialComponent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTrialComponent {
    _private: (),
}
impl DescribeTrialComponent {
    /// Creates a new builder-style object to manufacture [`DescribeTrialComponentInput`](crate::input::DescribeTrialComponentInput)
    pub fn builder() -> crate::input::describe_trial_component_input::Builder {
        crate::input::describe_trial_component_input::Builder::default()
    }
    /// Creates a new `DescribeTrialComponent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTrialComponent {
    type Output = std::result::Result<
        crate::output::DescribeTrialComponentOutput,
        crate::error::DescribeTrialComponentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_trial_component_error(response)
        } else {
            crate::operation_deser::parse_describe_trial_component_response(response)
        }
    }
}

/// Operation shape for `DescribeUserProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_user_profile`](crate::client::Client::describe_user_profile).
///
/// See [`crate::client::fluent_builders::DescribeUserProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeUserProfile {
    _private: (),
}
impl DescribeUserProfile {
    /// Creates a new builder-style object to manufacture [`DescribeUserProfileInput`](crate::input::DescribeUserProfileInput)
    pub fn builder() -> crate::input::describe_user_profile_input::Builder {
        crate::input::describe_user_profile_input::Builder::default()
    }
    /// Creates a new `DescribeUserProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeUserProfile {
    type Output = std::result::Result<
        crate::output::DescribeUserProfileOutput,
        crate::error::DescribeUserProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_user_profile_error(response)
        } else {
            crate::operation_deser::parse_describe_user_profile_response(response)
        }
    }
}

/// Operation shape for `DescribeWorkforce`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_workforce`](crate::client::Client::describe_workforce).
///
/// See [`crate::client::fluent_builders::DescribeWorkforce`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeWorkforce {
    _private: (),
}
impl DescribeWorkforce {
    /// Creates a new builder-style object to manufacture [`DescribeWorkforceInput`](crate::input::DescribeWorkforceInput)
    pub fn builder() -> crate::input::describe_workforce_input::Builder {
        crate::input::describe_workforce_input::Builder::default()
    }
    /// Creates a new `DescribeWorkforce` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeWorkforce {
    type Output = std::result::Result<
        crate::output::DescribeWorkforceOutput,
        crate::error::DescribeWorkforceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_workforce_error(response)
        } else {
            crate::operation_deser::parse_describe_workforce_response(response)
        }
    }
}

/// Operation shape for `DescribeWorkteam`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_workteam`](crate::client::Client::describe_workteam).
///
/// See [`crate::client::fluent_builders::DescribeWorkteam`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeWorkteam {
    _private: (),
}
impl DescribeWorkteam {
    /// Creates a new builder-style object to manufacture [`DescribeWorkteamInput`](crate::input::DescribeWorkteamInput)
    pub fn builder() -> crate::input::describe_workteam_input::Builder {
        crate::input::describe_workteam_input::Builder::default()
    }
    /// Creates a new `DescribeWorkteam` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeWorkteam {
    type Output = std::result::Result<
        crate::output::DescribeWorkteamOutput,
        crate::error::DescribeWorkteamError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_workteam_error(response)
        } else {
            crate::operation_deser::parse_describe_workteam_response(response)
        }
    }
}

/// Operation shape for `DisableSagemakerServicecatalogPortfolio`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_sagemaker_servicecatalog_portfolio`](crate::client::Client::disable_sagemaker_servicecatalog_portfolio).
///
/// See [`crate::client::fluent_builders::DisableSagemakerServicecatalogPortfolio`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableSagemakerServicecatalogPortfolio {
    _private: (),
}
impl DisableSagemakerServicecatalogPortfolio {
    /// Creates a new builder-style object to manufacture [`DisableSagemakerServicecatalogPortfolioInput`](crate::input::DisableSagemakerServicecatalogPortfolioInput)
    pub fn builder() -> crate::input::disable_sagemaker_servicecatalog_portfolio_input::Builder {
        crate::input::disable_sagemaker_servicecatalog_portfolio_input::Builder::default()
    }
    /// Creates a new `DisableSagemakerServicecatalogPortfolio` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableSagemakerServicecatalogPortfolio {
    type Output = std::result::Result<
        crate::output::DisableSagemakerServicecatalogPortfolioOutput,
        crate::error::DisableSagemakerServicecatalogPortfolioError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_sagemaker_servicecatalog_portfolio_error(response)
        } else {
            crate::operation_deser::parse_disable_sagemaker_servicecatalog_portfolio_response(
                response,
            )
        }
    }
}

/// Operation shape for `DisassociateTrialComponent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_trial_component`](crate::client::Client::disassociate_trial_component).
///
/// See [`crate::client::fluent_builders::DisassociateTrialComponent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateTrialComponent {
    _private: (),
}
impl DisassociateTrialComponent {
    /// Creates a new builder-style object to manufacture [`DisassociateTrialComponentInput`](crate::input::DisassociateTrialComponentInput)
    pub fn builder() -> crate::input::disassociate_trial_component_input::Builder {
        crate::input::disassociate_trial_component_input::Builder::default()
    }
    /// Creates a new `DisassociateTrialComponent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateTrialComponent {
    type Output = std::result::Result<
        crate::output::DisassociateTrialComponentOutput,
        crate::error::DisassociateTrialComponentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_trial_component_error(response)
        } else {
            crate::operation_deser::parse_disassociate_trial_component_response(response)
        }
    }
}

/// Operation shape for `EnableSagemakerServicecatalogPortfolio`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_sagemaker_servicecatalog_portfolio`](crate::client::Client::enable_sagemaker_servicecatalog_portfolio).
///
/// See [`crate::client::fluent_builders::EnableSagemakerServicecatalogPortfolio`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableSagemakerServicecatalogPortfolio {
    _private: (),
}
impl EnableSagemakerServicecatalogPortfolio {
    /// Creates a new builder-style object to manufacture [`EnableSagemakerServicecatalogPortfolioInput`](crate::input::EnableSagemakerServicecatalogPortfolioInput)
    pub fn builder() -> crate::input::enable_sagemaker_servicecatalog_portfolio_input::Builder {
        crate::input::enable_sagemaker_servicecatalog_portfolio_input::Builder::default()
    }
    /// Creates a new `EnableSagemakerServicecatalogPortfolio` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableSagemakerServicecatalogPortfolio {
    type Output = std::result::Result<
        crate::output::EnableSagemakerServicecatalogPortfolioOutput,
        crate::error::EnableSagemakerServicecatalogPortfolioError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_sagemaker_servicecatalog_portfolio_error(response)
        } else {
            crate::operation_deser::parse_enable_sagemaker_servicecatalog_portfolio_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetDeviceFleetReport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_device_fleet_report`](crate::client::Client::get_device_fleet_report).
///
/// See [`crate::client::fluent_builders::GetDeviceFleetReport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDeviceFleetReport {
    _private: (),
}
impl GetDeviceFleetReport {
    /// Creates a new builder-style object to manufacture [`GetDeviceFleetReportInput`](crate::input::GetDeviceFleetReportInput)
    pub fn builder() -> crate::input::get_device_fleet_report_input::Builder {
        crate::input::get_device_fleet_report_input::Builder::default()
    }
    /// Creates a new `GetDeviceFleetReport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDeviceFleetReport {
    type Output = std::result::Result<
        crate::output::GetDeviceFleetReportOutput,
        crate::error::GetDeviceFleetReportError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_device_fleet_report_error(response)
        } else {
            crate::operation_deser::parse_get_device_fleet_report_response(response)
        }
    }
}

/// Operation shape for `GetModelPackageGroupPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_model_package_group_policy`](crate::client::Client::get_model_package_group_policy).
///
/// See [`crate::client::fluent_builders::GetModelPackageGroupPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetModelPackageGroupPolicy {
    _private: (),
}
impl GetModelPackageGroupPolicy {
    /// Creates a new builder-style object to manufacture [`GetModelPackageGroupPolicyInput`](crate::input::GetModelPackageGroupPolicyInput)
    pub fn builder() -> crate::input::get_model_package_group_policy_input::Builder {
        crate::input::get_model_package_group_policy_input::Builder::default()
    }
    /// Creates a new `GetModelPackageGroupPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetModelPackageGroupPolicy {
    type Output = std::result::Result<
        crate::output::GetModelPackageGroupPolicyOutput,
        crate::error::GetModelPackageGroupPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_model_package_group_policy_error(response)
        } else {
            crate::operation_deser::parse_get_model_package_group_policy_response(response)
        }
    }
}

/// Operation shape for `GetSagemakerServicecatalogPortfolioStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_sagemaker_servicecatalog_portfolio_status`](crate::client::Client::get_sagemaker_servicecatalog_portfolio_status).
///
/// See [`crate::client::fluent_builders::GetSagemakerServicecatalogPortfolioStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSagemakerServicecatalogPortfolioStatus {
    _private: (),
}
impl GetSagemakerServicecatalogPortfolioStatus {
    /// Creates a new builder-style object to manufacture [`GetSagemakerServicecatalogPortfolioStatusInput`](crate::input::GetSagemakerServicecatalogPortfolioStatusInput)
    pub fn builder() -> crate::input::get_sagemaker_servicecatalog_portfolio_status_input::Builder {
        crate::input::get_sagemaker_servicecatalog_portfolio_status_input::Builder::default()
    }
    /// Creates a new `GetSagemakerServicecatalogPortfolioStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSagemakerServicecatalogPortfolioStatus {
    type Output = std::result::Result<
        crate::output::GetSagemakerServicecatalogPortfolioStatusOutput,
        crate::error::GetSagemakerServicecatalogPortfolioStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_sagemaker_servicecatalog_portfolio_status_error(
                response,
            )
        } else {
            crate::operation_deser::parse_get_sagemaker_servicecatalog_portfolio_status_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetSearchSuggestions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_search_suggestions`](crate::client::Client::get_search_suggestions).
///
/// See [`crate::client::fluent_builders::GetSearchSuggestions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSearchSuggestions {
    _private: (),
}
impl GetSearchSuggestions {
    /// Creates a new builder-style object to manufacture [`GetSearchSuggestionsInput`](crate::input::GetSearchSuggestionsInput)
    pub fn builder() -> crate::input::get_search_suggestions_input::Builder {
        crate::input::get_search_suggestions_input::Builder::default()
    }
    /// Creates a new `GetSearchSuggestions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSearchSuggestions {
    type Output = std::result::Result<
        crate::output::GetSearchSuggestionsOutput,
        crate::error::GetSearchSuggestionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_search_suggestions_error(response)
        } else {
            crate::operation_deser::parse_get_search_suggestions_response(response)
        }
    }
}

/// Operation shape for `ListActions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_actions`](crate::client::Client::list_actions).
///
/// See [`crate::client::fluent_builders::ListActions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListActions {
    _private: (),
}
impl ListActions {
    /// Creates a new builder-style object to manufacture [`ListActionsInput`](crate::input::ListActionsInput)
    pub fn builder() -> crate::input::list_actions_input::Builder {
        crate::input::list_actions_input::Builder::default()
    }
    /// Creates a new `ListActions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListActions {
    type Output =
        std::result::Result<crate::output::ListActionsOutput, crate::error::ListActionsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_actions_error(response)
        } else {
            crate::operation_deser::parse_list_actions_response(response)
        }
    }
}

/// Operation shape for `ListAlgorithms`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_algorithms`](crate::client::Client::list_algorithms).
///
/// See [`crate::client::fluent_builders::ListAlgorithms`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAlgorithms {
    _private: (),
}
impl ListAlgorithms {
    /// Creates a new builder-style object to manufacture [`ListAlgorithmsInput`](crate::input::ListAlgorithmsInput)
    pub fn builder() -> crate::input::list_algorithms_input::Builder {
        crate::input::list_algorithms_input::Builder::default()
    }
    /// Creates a new `ListAlgorithms` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAlgorithms {
    type Output =
        std::result::Result<crate::output::ListAlgorithmsOutput, crate::error::ListAlgorithmsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_algorithms_error(response)
        } else {
            crate::operation_deser::parse_list_algorithms_response(response)
        }
    }
}

/// Operation shape for `ListAppImageConfigs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_app_image_configs`](crate::client::Client::list_app_image_configs).
///
/// See [`crate::client::fluent_builders::ListAppImageConfigs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAppImageConfigs {
    _private: (),
}
impl ListAppImageConfigs {
    /// Creates a new builder-style object to manufacture [`ListAppImageConfigsInput`](crate::input::ListAppImageConfigsInput)
    pub fn builder() -> crate::input::list_app_image_configs_input::Builder {
        crate::input::list_app_image_configs_input::Builder::default()
    }
    /// Creates a new `ListAppImageConfigs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAppImageConfigs {
    type Output = std::result::Result<
        crate::output::ListAppImageConfigsOutput,
        crate::error::ListAppImageConfigsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_app_image_configs_error(response)
        } else {
            crate::operation_deser::parse_list_app_image_configs_response(response)
        }
    }
}

/// Operation shape for `ListApps`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_apps`](crate::client::Client::list_apps).
///
/// See [`crate::client::fluent_builders::ListApps`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListApps {
    _private: (),
}
impl ListApps {
    /// Creates a new builder-style object to manufacture [`ListAppsInput`](crate::input::ListAppsInput)
    pub fn builder() -> crate::input::list_apps_input::Builder {
        crate::input::list_apps_input::Builder::default()
    }
    /// Creates a new `ListApps` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListApps {
    type Output = std::result::Result<crate::output::ListAppsOutput, crate::error::ListAppsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_apps_error(response)
        } else {
            crate::operation_deser::parse_list_apps_response(response)
        }
    }
}

/// Operation shape for `ListArtifacts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_artifacts`](crate::client::Client::list_artifacts).
///
/// See [`crate::client::fluent_builders::ListArtifacts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListArtifacts {
    _private: (),
}
impl ListArtifacts {
    /// Creates a new builder-style object to manufacture [`ListArtifactsInput`](crate::input::ListArtifactsInput)
    pub fn builder() -> crate::input::list_artifacts_input::Builder {
        crate::input::list_artifacts_input::Builder::default()
    }
    /// Creates a new `ListArtifacts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListArtifacts {
    type Output =
        std::result::Result<crate::output::ListArtifactsOutput, crate::error::ListArtifactsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_artifacts_error(response)
        } else {
            crate::operation_deser::parse_list_artifacts_response(response)
        }
    }
}

/// Operation shape for `ListAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_associations`](crate::client::Client::list_associations).
///
/// See [`crate::client::fluent_builders::ListAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAssociations {
    _private: (),
}
impl ListAssociations {
    /// Creates a new builder-style object to manufacture [`ListAssociationsInput`](crate::input::ListAssociationsInput)
    pub fn builder() -> crate::input::list_associations_input::Builder {
        crate::input::list_associations_input::Builder::default()
    }
    /// Creates a new `ListAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAssociations {
    type Output = std::result::Result<
        crate::output::ListAssociationsOutput,
        crate::error::ListAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_associations_error(response)
        } else {
            crate::operation_deser::parse_list_associations_response(response)
        }
    }
}

/// Operation shape for `ListAutoMLJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_auto_ml_jobs`](crate::client::Client::list_auto_ml_jobs).
///
/// See [`crate::client::fluent_builders::ListAutoMLJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAutoMLJobs {
    _private: (),
}
impl ListAutoMLJobs {
    /// Creates a new builder-style object to manufacture [`ListAutoMlJobsInput`](crate::input::ListAutoMlJobsInput)
    pub fn builder() -> crate::input::list_auto_ml_jobs_input::Builder {
        crate::input::list_auto_ml_jobs_input::Builder::default()
    }
    /// Creates a new `ListAutoMLJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAutoMLJobs {
    type Output =
        std::result::Result<crate::output::ListAutoMlJobsOutput, crate::error::ListAutoMLJobsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_auto_ml_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_auto_ml_jobs_response(response)
        }
    }
}

/// Operation shape for `ListCandidatesForAutoMLJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_candidates_for_auto_ml_job`](crate::client::Client::list_candidates_for_auto_ml_job).
///
/// See [`crate::client::fluent_builders::ListCandidatesForAutoMLJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCandidatesForAutoMLJob {
    _private: (),
}
impl ListCandidatesForAutoMLJob {
    /// Creates a new builder-style object to manufacture [`ListCandidatesForAutoMlJobInput`](crate::input::ListCandidatesForAutoMlJobInput)
    pub fn builder() -> crate::input::list_candidates_for_auto_ml_job_input::Builder {
        crate::input::list_candidates_for_auto_ml_job_input::Builder::default()
    }
    /// Creates a new `ListCandidatesForAutoMLJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCandidatesForAutoMLJob {
    type Output = std::result::Result<
        crate::output::ListCandidatesForAutoMlJobOutput,
        crate::error::ListCandidatesForAutoMLJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_candidates_for_auto_ml_job_error(response)
        } else {
            crate::operation_deser::parse_list_candidates_for_auto_ml_job_response(response)
        }
    }
}

/// Operation shape for `ListCodeRepositories`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_code_repositories`](crate::client::Client::list_code_repositories).
///
/// See [`crate::client::fluent_builders::ListCodeRepositories`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCodeRepositories {
    _private: (),
}
impl ListCodeRepositories {
    /// Creates a new builder-style object to manufacture [`ListCodeRepositoriesInput`](crate::input::ListCodeRepositoriesInput)
    pub fn builder() -> crate::input::list_code_repositories_input::Builder {
        crate::input::list_code_repositories_input::Builder::default()
    }
    /// Creates a new `ListCodeRepositories` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCodeRepositories {
    type Output = std::result::Result<
        crate::output::ListCodeRepositoriesOutput,
        crate::error::ListCodeRepositoriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_code_repositories_error(response)
        } else {
            crate::operation_deser::parse_list_code_repositories_response(response)
        }
    }
}

/// Operation shape for `ListCompilationJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_compilation_jobs`](crate::client::Client::list_compilation_jobs).
///
/// See [`crate::client::fluent_builders::ListCompilationJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCompilationJobs {
    _private: (),
}
impl ListCompilationJobs {
    /// Creates a new builder-style object to manufacture [`ListCompilationJobsInput`](crate::input::ListCompilationJobsInput)
    pub fn builder() -> crate::input::list_compilation_jobs_input::Builder {
        crate::input::list_compilation_jobs_input::Builder::default()
    }
    /// Creates a new `ListCompilationJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCompilationJobs {
    type Output = std::result::Result<
        crate::output::ListCompilationJobsOutput,
        crate::error::ListCompilationJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_compilation_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_compilation_jobs_response(response)
        }
    }
}

/// Operation shape for `ListContexts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_contexts`](crate::client::Client::list_contexts).
///
/// See [`crate::client::fluent_builders::ListContexts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListContexts {
    _private: (),
}
impl ListContexts {
    /// Creates a new builder-style object to manufacture [`ListContextsInput`](crate::input::ListContextsInput)
    pub fn builder() -> crate::input::list_contexts_input::Builder {
        crate::input::list_contexts_input::Builder::default()
    }
    /// Creates a new `ListContexts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListContexts {
    type Output =
        std::result::Result<crate::output::ListContextsOutput, crate::error::ListContextsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_contexts_error(response)
        } else {
            crate::operation_deser::parse_list_contexts_response(response)
        }
    }
}

/// Operation shape for `ListDataQualityJobDefinitions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_data_quality_job_definitions`](crate::client::Client::list_data_quality_job_definitions).
///
/// See [`crate::client::fluent_builders::ListDataQualityJobDefinitions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDataQualityJobDefinitions {
    _private: (),
}
impl ListDataQualityJobDefinitions {
    /// Creates a new builder-style object to manufacture [`ListDataQualityJobDefinitionsInput`](crate::input::ListDataQualityJobDefinitionsInput)
    pub fn builder() -> crate::input::list_data_quality_job_definitions_input::Builder {
        crate::input::list_data_quality_job_definitions_input::Builder::default()
    }
    /// Creates a new `ListDataQualityJobDefinitions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDataQualityJobDefinitions {
    type Output = std::result::Result<
        crate::output::ListDataQualityJobDefinitionsOutput,
        crate::error::ListDataQualityJobDefinitionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_data_quality_job_definitions_error(response)
        } else {
            crate::operation_deser::parse_list_data_quality_job_definitions_response(response)
        }
    }
}

/// Operation shape for `ListDeviceFleets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_device_fleets`](crate::client::Client::list_device_fleets).
///
/// See [`crate::client::fluent_builders::ListDeviceFleets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDeviceFleets {
    _private: (),
}
impl ListDeviceFleets {
    /// Creates a new builder-style object to manufacture [`ListDeviceFleetsInput`](crate::input::ListDeviceFleetsInput)
    pub fn builder() -> crate::input::list_device_fleets_input::Builder {
        crate::input::list_device_fleets_input::Builder::default()
    }
    /// Creates a new `ListDeviceFleets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDeviceFleets {
    type Output = std::result::Result<
        crate::output::ListDeviceFleetsOutput,
        crate::error::ListDeviceFleetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_device_fleets_error(response)
        } else {
            crate::operation_deser::parse_list_device_fleets_response(response)
        }
    }
}

/// Operation shape for `ListDevices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_devices`](crate::client::Client::list_devices).
///
/// See [`crate::client::fluent_builders::ListDevices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDevices {
    _private: (),
}
impl ListDevices {
    /// Creates a new builder-style object to manufacture [`ListDevicesInput`](crate::input::ListDevicesInput)
    pub fn builder() -> crate::input::list_devices_input::Builder {
        crate::input::list_devices_input::Builder::default()
    }
    /// Creates a new `ListDevices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDevices {
    type Output =
        std::result::Result<crate::output::ListDevicesOutput, crate::error::ListDevicesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_devices_error(response)
        } else {
            crate::operation_deser::parse_list_devices_response(response)
        }
    }
}

/// Operation shape for `ListDomains`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_domains`](crate::client::Client::list_domains).
///
/// See [`crate::client::fluent_builders::ListDomains`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDomains {
    _private: (),
}
impl ListDomains {
    /// Creates a new builder-style object to manufacture [`ListDomainsInput`](crate::input::ListDomainsInput)
    pub fn builder() -> crate::input::list_domains_input::Builder {
        crate::input::list_domains_input::Builder::default()
    }
    /// Creates a new `ListDomains` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDomains {
    type Output =
        std::result::Result<crate::output::ListDomainsOutput, crate::error::ListDomainsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_domains_error(response)
        } else {
            crate::operation_deser::parse_list_domains_response(response)
        }
    }
}

/// Operation shape for `ListEdgePackagingJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_edge_packaging_jobs`](crate::client::Client::list_edge_packaging_jobs).
///
/// See [`crate::client::fluent_builders::ListEdgePackagingJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEdgePackagingJobs {
    _private: (),
}
impl ListEdgePackagingJobs {
    /// Creates a new builder-style object to manufacture [`ListEdgePackagingJobsInput`](crate::input::ListEdgePackagingJobsInput)
    pub fn builder() -> crate::input::list_edge_packaging_jobs_input::Builder {
        crate::input::list_edge_packaging_jobs_input::Builder::default()
    }
    /// Creates a new `ListEdgePackagingJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEdgePackagingJobs {
    type Output = std::result::Result<
        crate::output::ListEdgePackagingJobsOutput,
        crate::error::ListEdgePackagingJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_edge_packaging_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_edge_packaging_jobs_response(response)
        }
    }
}

/// Operation shape for `ListEndpointConfigs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_endpoint_configs`](crate::client::Client::list_endpoint_configs).
///
/// See [`crate::client::fluent_builders::ListEndpointConfigs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEndpointConfigs {
    _private: (),
}
impl ListEndpointConfigs {
    /// Creates a new builder-style object to manufacture [`ListEndpointConfigsInput`](crate::input::ListEndpointConfigsInput)
    pub fn builder() -> crate::input::list_endpoint_configs_input::Builder {
        crate::input::list_endpoint_configs_input::Builder::default()
    }
    /// Creates a new `ListEndpointConfigs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEndpointConfigs {
    type Output = std::result::Result<
        crate::output::ListEndpointConfigsOutput,
        crate::error::ListEndpointConfigsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_endpoint_configs_error(response)
        } else {
            crate::operation_deser::parse_list_endpoint_configs_response(response)
        }
    }
}

/// Operation shape for `ListEndpoints`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_endpoints`](crate::client::Client::list_endpoints).
///
/// See [`crate::client::fluent_builders::ListEndpoints`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEndpoints {
    _private: (),
}
impl ListEndpoints {
    /// Creates a new builder-style object to manufacture [`ListEndpointsInput`](crate::input::ListEndpointsInput)
    pub fn builder() -> crate::input::list_endpoints_input::Builder {
        crate::input::list_endpoints_input::Builder::default()
    }
    /// Creates a new `ListEndpoints` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEndpoints {
    type Output =
        std::result::Result<crate::output::ListEndpointsOutput, crate::error::ListEndpointsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_endpoints_error(response)
        } else {
            crate::operation_deser::parse_list_endpoints_response(response)
        }
    }
}

/// Operation shape for `ListExperiments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_experiments`](crate::client::Client::list_experiments).
///
/// See [`crate::client::fluent_builders::ListExperiments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListExperiments {
    _private: (),
}
impl ListExperiments {
    /// Creates a new builder-style object to manufacture [`ListExperimentsInput`](crate::input::ListExperimentsInput)
    pub fn builder() -> crate::input::list_experiments_input::Builder {
        crate::input::list_experiments_input::Builder::default()
    }
    /// Creates a new `ListExperiments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListExperiments {
    type Output = std::result::Result<
        crate::output::ListExperimentsOutput,
        crate::error::ListExperimentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_experiments_error(response)
        } else {
            crate::operation_deser::parse_list_experiments_response(response)
        }
    }
}

/// Operation shape for `ListFeatureGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_feature_groups`](crate::client::Client::list_feature_groups).
///
/// See [`crate::client::fluent_builders::ListFeatureGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFeatureGroups {
    _private: (),
}
impl ListFeatureGroups {
    /// Creates a new builder-style object to manufacture [`ListFeatureGroupsInput`](crate::input::ListFeatureGroupsInput)
    pub fn builder() -> crate::input::list_feature_groups_input::Builder {
        crate::input::list_feature_groups_input::Builder::default()
    }
    /// Creates a new `ListFeatureGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFeatureGroups {
    type Output = std::result::Result<
        crate::output::ListFeatureGroupsOutput,
        crate::error::ListFeatureGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_feature_groups_error(response)
        } else {
            crate::operation_deser::parse_list_feature_groups_response(response)
        }
    }
}

/// Operation shape for `ListFlowDefinitions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_flow_definitions`](crate::client::Client::list_flow_definitions).
///
/// See [`crate::client::fluent_builders::ListFlowDefinitions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFlowDefinitions {
    _private: (),
}
impl ListFlowDefinitions {
    /// Creates a new builder-style object to manufacture [`ListFlowDefinitionsInput`](crate::input::ListFlowDefinitionsInput)
    pub fn builder() -> crate::input::list_flow_definitions_input::Builder {
        crate::input::list_flow_definitions_input::Builder::default()
    }
    /// Creates a new `ListFlowDefinitions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFlowDefinitions {
    type Output = std::result::Result<
        crate::output::ListFlowDefinitionsOutput,
        crate::error::ListFlowDefinitionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_flow_definitions_error(response)
        } else {
            crate::operation_deser::parse_list_flow_definitions_response(response)
        }
    }
}

/// Operation shape for `ListHumanTaskUis`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_human_task_uis`](crate::client::Client::list_human_task_uis).
///
/// See [`crate::client::fluent_builders::ListHumanTaskUis`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListHumanTaskUis {
    _private: (),
}
impl ListHumanTaskUis {
    /// Creates a new builder-style object to manufacture [`ListHumanTaskUisInput`](crate::input::ListHumanTaskUisInput)
    pub fn builder() -> crate::input::list_human_task_uis_input::Builder {
        crate::input::list_human_task_uis_input::Builder::default()
    }
    /// Creates a new `ListHumanTaskUis` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListHumanTaskUis {
    type Output = std::result::Result<
        crate::output::ListHumanTaskUisOutput,
        crate::error::ListHumanTaskUisError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_human_task_uis_error(response)
        } else {
            crate::operation_deser::parse_list_human_task_uis_response(response)
        }
    }
}

/// Operation shape for `ListHyperParameterTuningJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_hyper_parameter_tuning_jobs`](crate::client::Client::list_hyper_parameter_tuning_jobs).
///
/// See [`crate::client::fluent_builders::ListHyperParameterTuningJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListHyperParameterTuningJobs {
    _private: (),
}
impl ListHyperParameterTuningJobs {
    /// Creates a new builder-style object to manufacture [`ListHyperParameterTuningJobsInput`](crate::input::ListHyperParameterTuningJobsInput)
    pub fn builder() -> crate::input::list_hyper_parameter_tuning_jobs_input::Builder {
        crate::input::list_hyper_parameter_tuning_jobs_input::Builder::default()
    }
    /// Creates a new `ListHyperParameterTuningJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListHyperParameterTuningJobs {
    type Output = std::result::Result<
        crate::output::ListHyperParameterTuningJobsOutput,
        crate::error::ListHyperParameterTuningJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_hyper_parameter_tuning_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_hyper_parameter_tuning_jobs_response(response)
        }
    }
}

/// Operation shape for `ListImages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_images`](crate::client::Client::list_images).
///
/// See [`crate::client::fluent_builders::ListImages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListImages {
    _private: (),
}
impl ListImages {
    /// Creates a new builder-style object to manufacture [`ListImagesInput`](crate::input::ListImagesInput)
    pub fn builder() -> crate::input::list_images_input::Builder {
        crate::input::list_images_input::Builder::default()
    }
    /// Creates a new `ListImages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListImages {
    type Output =
        std::result::Result<crate::output::ListImagesOutput, crate::error::ListImagesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_images_error(response)
        } else {
            crate::operation_deser::parse_list_images_response(response)
        }
    }
}

/// Operation shape for `ListImageVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_image_versions`](crate::client::Client::list_image_versions).
///
/// See [`crate::client::fluent_builders::ListImageVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListImageVersions {
    _private: (),
}
impl ListImageVersions {
    /// Creates a new builder-style object to manufacture [`ListImageVersionsInput`](crate::input::ListImageVersionsInput)
    pub fn builder() -> crate::input::list_image_versions_input::Builder {
        crate::input::list_image_versions_input::Builder::default()
    }
    /// Creates a new `ListImageVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListImageVersions {
    type Output = std::result::Result<
        crate::output::ListImageVersionsOutput,
        crate::error::ListImageVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_image_versions_error(response)
        } else {
            crate::operation_deser::parse_list_image_versions_response(response)
        }
    }
}

/// Operation shape for `ListLabelingJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_labeling_jobs`](crate::client::Client::list_labeling_jobs).
///
/// See [`crate::client::fluent_builders::ListLabelingJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListLabelingJobs {
    _private: (),
}
impl ListLabelingJobs {
    /// Creates a new builder-style object to manufacture [`ListLabelingJobsInput`](crate::input::ListLabelingJobsInput)
    pub fn builder() -> crate::input::list_labeling_jobs_input::Builder {
        crate::input::list_labeling_jobs_input::Builder::default()
    }
    /// Creates a new `ListLabelingJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListLabelingJobs {
    type Output = std::result::Result<
        crate::output::ListLabelingJobsOutput,
        crate::error::ListLabelingJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_labeling_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_labeling_jobs_response(response)
        }
    }
}

/// Operation shape for `ListLabelingJobsForWorkteam`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_labeling_jobs_for_workteam`](crate::client::Client::list_labeling_jobs_for_workteam).
///
/// See [`crate::client::fluent_builders::ListLabelingJobsForWorkteam`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListLabelingJobsForWorkteam {
    _private: (),
}
impl ListLabelingJobsForWorkteam {
    /// Creates a new builder-style object to manufacture [`ListLabelingJobsForWorkteamInput`](crate::input::ListLabelingJobsForWorkteamInput)
    pub fn builder() -> crate::input::list_labeling_jobs_for_workteam_input::Builder {
        crate::input::list_labeling_jobs_for_workteam_input::Builder::default()
    }
    /// Creates a new `ListLabelingJobsForWorkteam` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListLabelingJobsForWorkteam {
    type Output = std::result::Result<
        crate::output::ListLabelingJobsForWorkteamOutput,
        crate::error::ListLabelingJobsForWorkteamError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_labeling_jobs_for_workteam_error(response)
        } else {
            crate::operation_deser::parse_list_labeling_jobs_for_workteam_response(response)
        }
    }
}

/// Operation shape for `ListModelBiasJobDefinitions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_model_bias_job_definitions`](crate::client::Client::list_model_bias_job_definitions).
///
/// See [`crate::client::fluent_builders::ListModelBiasJobDefinitions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListModelBiasJobDefinitions {
    _private: (),
}
impl ListModelBiasJobDefinitions {
    /// Creates a new builder-style object to manufacture [`ListModelBiasJobDefinitionsInput`](crate::input::ListModelBiasJobDefinitionsInput)
    pub fn builder() -> crate::input::list_model_bias_job_definitions_input::Builder {
        crate::input::list_model_bias_job_definitions_input::Builder::default()
    }
    /// Creates a new `ListModelBiasJobDefinitions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListModelBiasJobDefinitions {
    type Output = std::result::Result<
        crate::output::ListModelBiasJobDefinitionsOutput,
        crate::error::ListModelBiasJobDefinitionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_model_bias_job_definitions_error(response)
        } else {
            crate::operation_deser::parse_list_model_bias_job_definitions_response(response)
        }
    }
}

/// Operation shape for `ListModelExplainabilityJobDefinitions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_model_explainability_job_definitions`](crate::client::Client::list_model_explainability_job_definitions).
///
/// See [`crate::client::fluent_builders::ListModelExplainabilityJobDefinitions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListModelExplainabilityJobDefinitions {
    _private: (),
}
impl ListModelExplainabilityJobDefinitions {
    /// Creates a new builder-style object to manufacture [`ListModelExplainabilityJobDefinitionsInput`](crate::input::ListModelExplainabilityJobDefinitionsInput)
    pub fn builder() -> crate::input::list_model_explainability_job_definitions_input::Builder {
        crate::input::list_model_explainability_job_definitions_input::Builder::default()
    }
    /// Creates a new `ListModelExplainabilityJobDefinitions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListModelExplainabilityJobDefinitions {
    type Output = std::result::Result<
        crate::output::ListModelExplainabilityJobDefinitionsOutput,
        crate::error::ListModelExplainabilityJobDefinitionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_model_explainability_job_definitions_error(response)
        } else {
            crate::operation_deser::parse_list_model_explainability_job_definitions_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListModelPackageGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_model_package_groups`](crate::client::Client::list_model_package_groups).
///
/// See [`crate::client::fluent_builders::ListModelPackageGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListModelPackageGroups {
    _private: (),
}
impl ListModelPackageGroups {
    /// Creates a new builder-style object to manufacture [`ListModelPackageGroupsInput`](crate::input::ListModelPackageGroupsInput)
    pub fn builder() -> crate::input::list_model_package_groups_input::Builder {
        crate::input::list_model_package_groups_input::Builder::default()
    }
    /// Creates a new `ListModelPackageGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListModelPackageGroups {
    type Output = std::result::Result<
        crate::output::ListModelPackageGroupsOutput,
        crate::error::ListModelPackageGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_model_package_groups_error(response)
        } else {
            crate::operation_deser::parse_list_model_package_groups_response(response)
        }
    }
}

/// Operation shape for `ListModelPackages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_model_packages`](crate::client::Client::list_model_packages).
///
/// See [`crate::client::fluent_builders::ListModelPackages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListModelPackages {
    _private: (),
}
impl ListModelPackages {
    /// Creates a new builder-style object to manufacture [`ListModelPackagesInput`](crate::input::ListModelPackagesInput)
    pub fn builder() -> crate::input::list_model_packages_input::Builder {
        crate::input::list_model_packages_input::Builder::default()
    }
    /// Creates a new `ListModelPackages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListModelPackages {
    type Output = std::result::Result<
        crate::output::ListModelPackagesOutput,
        crate::error::ListModelPackagesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_model_packages_error(response)
        } else {
            crate::operation_deser::parse_list_model_packages_response(response)
        }
    }
}

/// Operation shape for `ListModelQualityJobDefinitions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_model_quality_job_definitions`](crate::client::Client::list_model_quality_job_definitions).
///
/// See [`crate::client::fluent_builders::ListModelQualityJobDefinitions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListModelQualityJobDefinitions {
    _private: (),
}
impl ListModelQualityJobDefinitions {
    /// Creates a new builder-style object to manufacture [`ListModelQualityJobDefinitionsInput`](crate::input::ListModelQualityJobDefinitionsInput)
    pub fn builder() -> crate::input::list_model_quality_job_definitions_input::Builder {
        crate::input::list_model_quality_job_definitions_input::Builder::default()
    }
    /// Creates a new `ListModelQualityJobDefinitions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListModelQualityJobDefinitions {
    type Output = std::result::Result<
        crate::output::ListModelQualityJobDefinitionsOutput,
        crate::error::ListModelQualityJobDefinitionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_model_quality_job_definitions_error(response)
        } else {
            crate::operation_deser::parse_list_model_quality_job_definitions_response(response)
        }
    }
}

/// Operation shape for `ListModels`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_models`](crate::client::Client::list_models).
///
/// See [`crate::client::fluent_builders::ListModels`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListModels {
    _private: (),
}
impl ListModels {
    /// Creates a new builder-style object to manufacture [`ListModelsInput`](crate::input::ListModelsInput)
    pub fn builder() -> crate::input::list_models_input::Builder {
        crate::input::list_models_input::Builder::default()
    }
    /// Creates a new `ListModels` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListModels {
    type Output =
        std::result::Result<crate::output::ListModelsOutput, crate::error::ListModelsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_models_error(response)
        } else {
            crate::operation_deser::parse_list_models_response(response)
        }
    }
}

/// Operation shape for `ListMonitoringExecutions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_monitoring_executions`](crate::client::Client::list_monitoring_executions).
///
/// See [`crate::client::fluent_builders::ListMonitoringExecutions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMonitoringExecutions {
    _private: (),
}
impl ListMonitoringExecutions {
    /// Creates a new builder-style object to manufacture [`ListMonitoringExecutionsInput`](crate::input::ListMonitoringExecutionsInput)
    pub fn builder() -> crate::input::list_monitoring_executions_input::Builder {
        crate::input::list_monitoring_executions_input::Builder::default()
    }
    /// Creates a new `ListMonitoringExecutions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMonitoringExecutions {
    type Output = std::result::Result<
        crate::output::ListMonitoringExecutionsOutput,
        crate::error::ListMonitoringExecutionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_monitoring_executions_error(response)
        } else {
            crate::operation_deser::parse_list_monitoring_executions_response(response)
        }
    }
}

/// Operation shape for `ListMonitoringSchedules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_monitoring_schedules`](crate::client::Client::list_monitoring_schedules).
///
/// See [`crate::client::fluent_builders::ListMonitoringSchedules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMonitoringSchedules {
    _private: (),
}
impl ListMonitoringSchedules {
    /// Creates a new builder-style object to manufacture [`ListMonitoringSchedulesInput`](crate::input::ListMonitoringSchedulesInput)
    pub fn builder() -> crate::input::list_monitoring_schedules_input::Builder {
        crate::input::list_monitoring_schedules_input::Builder::default()
    }
    /// Creates a new `ListMonitoringSchedules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMonitoringSchedules {
    type Output = std::result::Result<
        crate::output::ListMonitoringSchedulesOutput,
        crate::error::ListMonitoringSchedulesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_monitoring_schedules_error(response)
        } else {
            crate::operation_deser::parse_list_monitoring_schedules_response(response)
        }
    }
}

/// Operation shape for `ListNotebookInstanceLifecycleConfigs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_notebook_instance_lifecycle_configs`](crate::client::Client::list_notebook_instance_lifecycle_configs).
///
/// See [`crate::client::fluent_builders::ListNotebookInstanceLifecycleConfigs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListNotebookInstanceLifecycleConfigs {
    _private: (),
}
impl ListNotebookInstanceLifecycleConfigs {
    /// Creates a new builder-style object to manufacture [`ListNotebookInstanceLifecycleConfigsInput`](crate::input::ListNotebookInstanceLifecycleConfigsInput)
    pub fn builder() -> crate::input::list_notebook_instance_lifecycle_configs_input::Builder {
        crate::input::list_notebook_instance_lifecycle_configs_input::Builder::default()
    }
    /// Creates a new `ListNotebookInstanceLifecycleConfigs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListNotebookInstanceLifecycleConfigs {
    type Output = std::result::Result<
        crate::output::ListNotebookInstanceLifecycleConfigsOutput,
        crate::error::ListNotebookInstanceLifecycleConfigsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_notebook_instance_lifecycle_configs_error(response)
        } else {
            crate::operation_deser::parse_list_notebook_instance_lifecycle_configs_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListNotebookInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_notebook_instances`](crate::client::Client::list_notebook_instances).
///
/// See [`crate::client::fluent_builders::ListNotebookInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListNotebookInstances {
    _private: (),
}
impl ListNotebookInstances {
    /// Creates a new builder-style object to manufacture [`ListNotebookInstancesInput`](crate::input::ListNotebookInstancesInput)
    pub fn builder() -> crate::input::list_notebook_instances_input::Builder {
        crate::input::list_notebook_instances_input::Builder::default()
    }
    /// Creates a new `ListNotebookInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListNotebookInstances {
    type Output = std::result::Result<
        crate::output::ListNotebookInstancesOutput,
        crate::error::ListNotebookInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_notebook_instances_error(response)
        } else {
            crate::operation_deser::parse_list_notebook_instances_response(response)
        }
    }
}

/// Operation shape for `ListPipelineExecutions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_pipeline_executions`](crate::client::Client::list_pipeline_executions).
///
/// See [`crate::client::fluent_builders::ListPipelineExecutions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPipelineExecutions {
    _private: (),
}
impl ListPipelineExecutions {
    /// Creates a new builder-style object to manufacture [`ListPipelineExecutionsInput`](crate::input::ListPipelineExecutionsInput)
    pub fn builder() -> crate::input::list_pipeline_executions_input::Builder {
        crate::input::list_pipeline_executions_input::Builder::default()
    }
    /// Creates a new `ListPipelineExecutions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPipelineExecutions {
    type Output = std::result::Result<
        crate::output::ListPipelineExecutionsOutput,
        crate::error::ListPipelineExecutionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_pipeline_executions_error(response)
        } else {
            crate::operation_deser::parse_list_pipeline_executions_response(response)
        }
    }
}

/// Operation shape for `ListPipelineExecutionSteps`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_pipeline_execution_steps`](crate::client::Client::list_pipeline_execution_steps).
///
/// See [`crate::client::fluent_builders::ListPipelineExecutionSteps`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPipelineExecutionSteps {
    _private: (),
}
impl ListPipelineExecutionSteps {
    /// Creates a new builder-style object to manufacture [`ListPipelineExecutionStepsInput`](crate::input::ListPipelineExecutionStepsInput)
    pub fn builder() -> crate::input::list_pipeline_execution_steps_input::Builder {
        crate::input::list_pipeline_execution_steps_input::Builder::default()
    }
    /// Creates a new `ListPipelineExecutionSteps` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPipelineExecutionSteps {
    type Output = std::result::Result<
        crate::output::ListPipelineExecutionStepsOutput,
        crate::error::ListPipelineExecutionStepsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_pipeline_execution_steps_error(response)
        } else {
            crate::operation_deser::parse_list_pipeline_execution_steps_response(response)
        }
    }
}

/// Operation shape for `ListPipelineParametersForExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_pipeline_parameters_for_execution`](crate::client::Client::list_pipeline_parameters_for_execution).
///
/// See [`crate::client::fluent_builders::ListPipelineParametersForExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPipelineParametersForExecution {
    _private: (),
}
impl ListPipelineParametersForExecution {
    /// Creates a new builder-style object to manufacture [`ListPipelineParametersForExecutionInput`](crate::input::ListPipelineParametersForExecutionInput)
    pub fn builder() -> crate::input::list_pipeline_parameters_for_execution_input::Builder {
        crate::input::list_pipeline_parameters_for_execution_input::Builder::default()
    }
    /// Creates a new `ListPipelineParametersForExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPipelineParametersForExecution {
    type Output = std::result::Result<
        crate::output::ListPipelineParametersForExecutionOutput,
        crate::error::ListPipelineParametersForExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_pipeline_parameters_for_execution_error(response)
        } else {
            crate::operation_deser::parse_list_pipeline_parameters_for_execution_response(response)
        }
    }
}

/// Operation shape for `ListPipelines`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_pipelines`](crate::client::Client::list_pipelines).
///
/// See [`crate::client::fluent_builders::ListPipelines`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPipelines {
    _private: (),
}
impl ListPipelines {
    /// Creates a new builder-style object to manufacture [`ListPipelinesInput`](crate::input::ListPipelinesInput)
    pub fn builder() -> crate::input::list_pipelines_input::Builder {
        crate::input::list_pipelines_input::Builder::default()
    }
    /// Creates a new `ListPipelines` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPipelines {
    type Output =
        std::result::Result<crate::output::ListPipelinesOutput, crate::error::ListPipelinesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_pipelines_error(response)
        } else {
            crate::operation_deser::parse_list_pipelines_response(response)
        }
    }
}

/// Operation shape for `ListProcessingJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_processing_jobs`](crate::client::Client::list_processing_jobs).
///
/// See [`crate::client::fluent_builders::ListProcessingJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListProcessingJobs {
    _private: (),
}
impl ListProcessingJobs {
    /// Creates a new builder-style object to manufacture [`ListProcessingJobsInput`](crate::input::ListProcessingJobsInput)
    pub fn builder() -> crate::input::list_processing_jobs_input::Builder {
        crate::input::list_processing_jobs_input::Builder::default()
    }
    /// Creates a new `ListProcessingJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListProcessingJobs {
    type Output = std::result::Result<
        crate::output::ListProcessingJobsOutput,
        crate::error::ListProcessingJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_processing_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_processing_jobs_response(response)
        }
    }
}

/// Operation shape for `ListProjects`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_projects`](crate::client::Client::list_projects).
///
/// See [`crate::client::fluent_builders::ListProjects`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListProjects {
    _private: (),
}
impl ListProjects {
    /// Creates a new builder-style object to manufacture [`ListProjectsInput`](crate::input::ListProjectsInput)
    pub fn builder() -> crate::input::list_projects_input::Builder {
        crate::input::list_projects_input::Builder::default()
    }
    /// Creates a new `ListProjects` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListProjects {
    type Output =
        std::result::Result<crate::output::ListProjectsOutput, crate::error::ListProjectsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_projects_error(response)
        } else {
            crate::operation_deser::parse_list_projects_response(response)
        }
    }
}

/// Operation shape for `ListStudioLifecycleConfigs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_studio_lifecycle_configs`](crate::client::Client::list_studio_lifecycle_configs).
///
/// See [`crate::client::fluent_builders::ListStudioLifecycleConfigs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListStudioLifecycleConfigs {
    _private: (),
}
impl ListStudioLifecycleConfigs {
    /// Creates a new builder-style object to manufacture [`ListStudioLifecycleConfigsInput`](crate::input::ListStudioLifecycleConfigsInput)
    pub fn builder() -> crate::input::list_studio_lifecycle_configs_input::Builder {
        crate::input::list_studio_lifecycle_configs_input::Builder::default()
    }
    /// Creates a new `ListStudioLifecycleConfigs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListStudioLifecycleConfigs {
    type Output = std::result::Result<
        crate::output::ListStudioLifecycleConfigsOutput,
        crate::error::ListStudioLifecycleConfigsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_studio_lifecycle_configs_error(response)
        } else {
            crate::operation_deser::parse_list_studio_lifecycle_configs_response(response)
        }
    }
}

/// Operation shape for `ListSubscribedWorkteams`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_subscribed_workteams`](crate::client::Client::list_subscribed_workteams).
///
/// See [`crate::client::fluent_builders::ListSubscribedWorkteams`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSubscribedWorkteams {
    _private: (),
}
impl ListSubscribedWorkteams {
    /// Creates a new builder-style object to manufacture [`ListSubscribedWorkteamsInput`](crate::input::ListSubscribedWorkteamsInput)
    pub fn builder() -> crate::input::list_subscribed_workteams_input::Builder {
        crate::input::list_subscribed_workteams_input::Builder::default()
    }
    /// Creates a new `ListSubscribedWorkteams` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSubscribedWorkteams {
    type Output = std::result::Result<
        crate::output::ListSubscribedWorkteamsOutput,
        crate::error::ListSubscribedWorkteamsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_subscribed_workteams_error(response)
        } else {
            crate::operation_deser::parse_list_subscribed_workteams_response(response)
        }
    }
}

/// Operation shape for `ListTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags`](crate::client::Client::list_tags).
///
/// See [`crate::client::fluent_builders::ListTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTags {
    _private: (),
}
impl ListTags {
    /// Creates a new builder-style object to manufacture [`ListTagsInput`](crate::input::ListTagsInput)
    pub fn builder() -> crate::input::list_tags_input::Builder {
        crate::input::list_tags_input::Builder::default()
    }
    /// Creates a new `ListTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTags {
    type Output = std::result::Result<crate::output::ListTagsOutput, crate::error::ListTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_error(response)
        } else {
            crate::operation_deser::parse_list_tags_response(response)
        }
    }
}

/// Operation shape for `ListTrainingJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_training_jobs`](crate::client::Client::list_training_jobs).
///
/// See [`crate::client::fluent_builders::ListTrainingJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTrainingJobs {
    _private: (),
}
impl ListTrainingJobs {
    /// Creates a new builder-style object to manufacture [`ListTrainingJobsInput`](crate::input::ListTrainingJobsInput)
    pub fn builder() -> crate::input::list_training_jobs_input::Builder {
        crate::input::list_training_jobs_input::Builder::default()
    }
    /// Creates a new `ListTrainingJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTrainingJobs {
    type Output = std::result::Result<
        crate::output::ListTrainingJobsOutput,
        crate::error::ListTrainingJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_training_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_training_jobs_response(response)
        }
    }
}

/// Operation shape for `ListTrainingJobsForHyperParameterTuningJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_training_jobs_for_hyper_parameter_tuning_job`](crate::client::Client::list_training_jobs_for_hyper_parameter_tuning_job).
///
/// See [`crate::client::fluent_builders::ListTrainingJobsForHyperParameterTuningJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTrainingJobsForHyperParameterTuningJob {
    _private: (),
}
impl ListTrainingJobsForHyperParameterTuningJob {
    /// Creates a new builder-style object to manufacture [`ListTrainingJobsForHyperParameterTuningJobInput`](crate::input::ListTrainingJobsForHyperParameterTuningJobInput)
    pub fn builder(
    ) -> crate::input::list_training_jobs_for_hyper_parameter_tuning_job_input::Builder {
        crate::input::list_training_jobs_for_hyper_parameter_tuning_job_input::Builder::default()
    }
    /// Creates a new `ListTrainingJobsForHyperParameterTuningJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTrainingJobsForHyperParameterTuningJob {
    type Output = std::result::Result<
        crate::output::ListTrainingJobsForHyperParameterTuningJobOutput,
        crate::error::ListTrainingJobsForHyperParameterTuningJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_training_jobs_for_hyper_parameter_tuning_job_error(
                response,
            )
        } else {
            crate::operation_deser::parse_list_training_jobs_for_hyper_parameter_tuning_job_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListTransformJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_transform_jobs`](crate::client::Client::list_transform_jobs).
///
/// See [`crate::client::fluent_builders::ListTransformJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTransformJobs {
    _private: (),
}
impl ListTransformJobs {
    /// Creates a new builder-style object to manufacture [`ListTransformJobsInput`](crate::input::ListTransformJobsInput)
    pub fn builder() -> crate::input::list_transform_jobs_input::Builder {
        crate::input::list_transform_jobs_input::Builder::default()
    }
    /// Creates a new `ListTransformJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTransformJobs {
    type Output = std::result::Result<
        crate::output::ListTransformJobsOutput,
        crate::error::ListTransformJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_transform_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_transform_jobs_response(response)
        }
    }
}

/// Operation shape for `ListTrialComponents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_trial_components`](crate::client::Client::list_trial_components).
///
/// See [`crate::client::fluent_builders::ListTrialComponents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTrialComponents {
    _private: (),
}
impl ListTrialComponents {
    /// Creates a new builder-style object to manufacture [`ListTrialComponentsInput`](crate::input::ListTrialComponentsInput)
    pub fn builder() -> crate::input::list_trial_components_input::Builder {
        crate::input::list_trial_components_input::Builder::default()
    }
    /// Creates a new `ListTrialComponents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTrialComponents {
    type Output = std::result::Result<
        crate::output::ListTrialComponentsOutput,
        crate::error::ListTrialComponentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_trial_components_error(response)
        } else {
            crate::operation_deser::parse_list_trial_components_response(response)
        }
    }
}

/// Operation shape for `ListTrials`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_trials`](crate::client::Client::list_trials).
///
/// See [`crate::client::fluent_builders::ListTrials`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTrials {
    _private: (),
}
impl ListTrials {
    /// Creates a new builder-style object to manufacture [`ListTrialsInput`](crate::input::ListTrialsInput)
    pub fn builder() -> crate::input::list_trials_input::Builder {
        crate::input::list_trials_input::Builder::default()
    }
    /// Creates a new `ListTrials` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTrials {
    type Output =
        std::result::Result<crate::output::ListTrialsOutput, crate::error::ListTrialsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_trials_error(response)
        } else {
            crate::operation_deser::parse_list_trials_response(response)
        }
    }
}

/// Operation shape for `ListUserProfiles`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_user_profiles`](crate::client::Client::list_user_profiles).
///
/// See [`crate::client::fluent_builders::ListUserProfiles`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListUserProfiles {
    _private: (),
}
impl ListUserProfiles {
    /// Creates a new builder-style object to manufacture [`ListUserProfilesInput`](crate::input::ListUserProfilesInput)
    pub fn builder() -> crate::input::list_user_profiles_input::Builder {
        crate::input::list_user_profiles_input::Builder::default()
    }
    /// Creates a new `ListUserProfiles` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListUserProfiles {
    type Output = std::result::Result<
        crate::output::ListUserProfilesOutput,
        crate::error::ListUserProfilesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_user_profiles_error(response)
        } else {
            crate::operation_deser::parse_list_user_profiles_response(response)
        }
    }
}

/// Operation shape for `ListWorkforces`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_workforces`](crate::client::Client::list_workforces).
///
/// See [`crate::client::fluent_builders::ListWorkforces`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListWorkforces {
    _private: (),
}
impl ListWorkforces {
    /// Creates a new builder-style object to manufacture [`ListWorkforcesInput`](crate::input::ListWorkforcesInput)
    pub fn builder() -> crate::input::list_workforces_input::Builder {
        crate::input::list_workforces_input::Builder::default()
    }
    /// Creates a new `ListWorkforces` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListWorkforces {
    type Output =
        std::result::Result<crate::output::ListWorkforcesOutput, crate::error::ListWorkforcesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_workforces_error(response)
        } else {
            crate::operation_deser::parse_list_workforces_response(response)
        }
    }
}

/// Operation shape for `ListWorkteams`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_workteams`](crate::client::Client::list_workteams).
///
/// See [`crate::client::fluent_builders::ListWorkteams`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListWorkteams {
    _private: (),
}
impl ListWorkteams {
    /// Creates a new builder-style object to manufacture [`ListWorkteamsInput`](crate::input::ListWorkteamsInput)
    pub fn builder() -> crate::input::list_workteams_input::Builder {
        crate::input::list_workteams_input::Builder::default()
    }
    /// Creates a new `ListWorkteams` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListWorkteams {
    type Output =
        std::result::Result<crate::output::ListWorkteamsOutput, crate::error::ListWorkteamsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_workteams_error(response)
        } else {
            crate::operation_deser::parse_list_workteams_response(response)
        }
    }
}

/// Operation shape for `PutModelPackageGroupPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_model_package_group_policy`](crate::client::Client::put_model_package_group_policy).
///
/// See [`crate::client::fluent_builders::PutModelPackageGroupPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutModelPackageGroupPolicy {
    _private: (),
}
impl PutModelPackageGroupPolicy {
    /// Creates a new builder-style object to manufacture [`PutModelPackageGroupPolicyInput`](crate::input::PutModelPackageGroupPolicyInput)
    pub fn builder() -> crate::input::put_model_package_group_policy_input::Builder {
        crate::input::put_model_package_group_policy_input::Builder::default()
    }
    /// Creates a new `PutModelPackageGroupPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutModelPackageGroupPolicy {
    type Output = std::result::Result<
        crate::output::PutModelPackageGroupPolicyOutput,
        crate::error::PutModelPackageGroupPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_model_package_group_policy_error(response)
        } else {
            crate::operation_deser::parse_put_model_package_group_policy_response(response)
        }
    }
}

/// Operation shape for `RegisterDevices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_devices`](crate::client::Client::register_devices).
///
/// See [`crate::client::fluent_builders::RegisterDevices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterDevices {
    _private: (),
}
impl RegisterDevices {
    /// Creates a new builder-style object to manufacture [`RegisterDevicesInput`](crate::input::RegisterDevicesInput)
    pub fn builder() -> crate::input::register_devices_input::Builder {
        crate::input::register_devices_input::Builder::default()
    }
    /// Creates a new `RegisterDevices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterDevices {
    type Output = std::result::Result<
        crate::output::RegisterDevicesOutput,
        crate::error::RegisterDevicesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_devices_error(response)
        } else {
            crate::operation_deser::parse_register_devices_response(response)
        }
    }
}

/// Operation shape for `RenderUiTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`render_ui_template`](crate::client::Client::render_ui_template).
///
/// See [`crate::client::fluent_builders::RenderUiTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RenderUiTemplate {
    _private: (),
}
impl RenderUiTemplate {
    /// Creates a new builder-style object to manufacture [`RenderUiTemplateInput`](crate::input::RenderUiTemplateInput)
    pub fn builder() -> crate::input::render_ui_template_input::Builder {
        crate::input::render_ui_template_input::Builder::default()
    }
    /// Creates a new `RenderUiTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RenderUiTemplate {
    type Output = std::result::Result<
        crate::output::RenderUiTemplateOutput,
        crate::error::RenderUiTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_render_ui_template_error(response)
        } else {
            crate::operation_deser::parse_render_ui_template_response(response)
        }
    }
}

/// Operation shape for `RetryPipelineExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`retry_pipeline_execution`](crate::client::Client::retry_pipeline_execution).
///
/// See [`crate::client::fluent_builders::RetryPipelineExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RetryPipelineExecution {
    _private: (),
}
impl RetryPipelineExecution {
    /// Creates a new builder-style object to manufacture [`RetryPipelineExecutionInput`](crate::input::RetryPipelineExecutionInput)
    pub fn builder() -> crate::input::retry_pipeline_execution_input::Builder {
        crate::input::retry_pipeline_execution_input::Builder::default()
    }
    /// Creates a new `RetryPipelineExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RetryPipelineExecution {
    type Output = std::result::Result<
        crate::output::RetryPipelineExecutionOutput,
        crate::error::RetryPipelineExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_retry_pipeline_execution_error(response)
        } else {
            crate::operation_deser::parse_retry_pipeline_execution_response(response)
        }
    }
}

/// Operation shape for `Search`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search`](crate::client::Client::search).
///
/// See [`crate::client::fluent_builders::Search`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct Search {
    _private: (),
}
impl Search {
    /// Creates a new builder-style object to manufacture [`SearchInput`](crate::input::SearchInput)
    pub fn builder() -> crate::input::search_input::Builder {
        crate::input::search_input::Builder::default()
    }
    /// Creates a new `Search` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for Search {
    type Output = std::result::Result<crate::output::SearchOutput, crate::error::SearchError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_error(response)
        } else {
            crate::operation_deser::parse_search_response(response)
        }
    }
}

/// Operation shape for `SendPipelineExecutionStepFailure`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_pipeline_execution_step_failure`](crate::client::Client::send_pipeline_execution_step_failure).
///
/// See [`crate::client::fluent_builders::SendPipelineExecutionStepFailure`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendPipelineExecutionStepFailure {
    _private: (),
}
impl SendPipelineExecutionStepFailure {
    /// Creates a new builder-style object to manufacture [`SendPipelineExecutionStepFailureInput`](crate::input::SendPipelineExecutionStepFailureInput)
    pub fn builder() -> crate::input::send_pipeline_execution_step_failure_input::Builder {
        crate::input::send_pipeline_execution_step_failure_input::Builder::default()
    }
    /// Creates a new `SendPipelineExecutionStepFailure` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendPipelineExecutionStepFailure {
    type Output = std::result::Result<
        crate::output::SendPipelineExecutionStepFailureOutput,
        crate::error::SendPipelineExecutionStepFailureError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_pipeline_execution_step_failure_error(response)
        } else {
            crate::operation_deser::parse_send_pipeline_execution_step_failure_response(response)
        }
    }
}

/// Operation shape for `SendPipelineExecutionStepSuccess`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_pipeline_execution_step_success`](crate::client::Client::send_pipeline_execution_step_success).
///
/// See [`crate::client::fluent_builders::SendPipelineExecutionStepSuccess`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendPipelineExecutionStepSuccess {
    _private: (),
}
impl SendPipelineExecutionStepSuccess {
    /// Creates a new builder-style object to manufacture [`SendPipelineExecutionStepSuccessInput`](crate::input::SendPipelineExecutionStepSuccessInput)
    pub fn builder() -> crate::input::send_pipeline_execution_step_success_input::Builder {
        crate::input::send_pipeline_execution_step_success_input::Builder::default()
    }
    /// Creates a new `SendPipelineExecutionStepSuccess` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendPipelineExecutionStepSuccess {
    type Output = std::result::Result<
        crate::output::SendPipelineExecutionStepSuccessOutput,
        crate::error::SendPipelineExecutionStepSuccessError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_pipeline_execution_step_success_error(response)
        } else {
            crate::operation_deser::parse_send_pipeline_execution_step_success_response(response)
        }
    }
}

/// Operation shape for `StartMonitoringSchedule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_monitoring_schedule`](crate::client::Client::start_monitoring_schedule).
///
/// See [`crate::client::fluent_builders::StartMonitoringSchedule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartMonitoringSchedule {
    _private: (),
}
impl StartMonitoringSchedule {
    /// Creates a new builder-style object to manufacture [`StartMonitoringScheduleInput`](crate::input::StartMonitoringScheduleInput)
    pub fn builder() -> crate::input::start_monitoring_schedule_input::Builder {
        crate::input::start_monitoring_schedule_input::Builder::default()
    }
    /// Creates a new `StartMonitoringSchedule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartMonitoringSchedule {
    type Output = std::result::Result<
        crate::output::StartMonitoringScheduleOutput,
        crate::error::StartMonitoringScheduleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_monitoring_schedule_error(response)
        } else {
            crate::operation_deser::parse_start_monitoring_schedule_response(response)
        }
    }
}

/// Operation shape for `StartNotebookInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_notebook_instance`](crate::client::Client::start_notebook_instance).
///
/// See [`crate::client::fluent_builders::StartNotebookInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartNotebookInstance {
    _private: (),
}
impl StartNotebookInstance {
    /// Creates a new builder-style object to manufacture [`StartNotebookInstanceInput`](crate::input::StartNotebookInstanceInput)
    pub fn builder() -> crate::input::start_notebook_instance_input::Builder {
        crate::input::start_notebook_instance_input::Builder::default()
    }
    /// Creates a new `StartNotebookInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartNotebookInstance {
    type Output = std::result::Result<
        crate::output::StartNotebookInstanceOutput,
        crate::error::StartNotebookInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_notebook_instance_error(response)
        } else {
            crate::operation_deser::parse_start_notebook_instance_response(response)
        }
    }
}

/// Operation shape for `StartPipelineExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_pipeline_execution`](crate::client::Client::start_pipeline_execution).
///
/// See [`crate::client::fluent_builders::StartPipelineExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartPipelineExecution {
    _private: (),
}
impl StartPipelineExecution {
    /// Creates a new builder-style object to manufacture [`StartPipelineExecutionInput`](crate::input::StartPipelineExecutionInput)
    pub fn builder() -> crate::input::start_pipeline_execution_input::Builder {
        crate::input::start_pipeline_execution_input::Builder::default()
    }
    /// Creates a new `StartPipelineExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartPipelineExecution {
    type Output = std::result::Result<
        crate::output::StartPipelineExecutionOutput,
        crate::error::StartPipelineExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_pipeline_execution_error(response)
        } else {
            crate::operation_deser::parse_start_pipeline_execution_response(response)
        }
    }
}

/// Operation shape for `StopAutoMLJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_auto_ml_job`](crate::client::Client::stop_auto_ml_job).
///
/// See [`crate::client::fluent_builders::StopAutoMLJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopAutoMLJob {
    _private: (),
}
impl StopAutoMLJob {
    /// Creates a new builder-style object to manufacture [`StopAutoMlJobInput`](crate::input::StopAutoMlJobInput)
    pub fn builder() -> crate::input::stop_auto_ml_job_input::Builder {
        crate::input::stop_auto_ml_job_input::Builder::default()
    }
    /// Creates a new `StopAutoMLJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopAutoMLJob {
    type Output =
        std::result::Result<crate::output::StopAutoMlJobOutput, crate::error::StopAutoMLJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_auto_ml_job_error(response)
        } else {
            crate::operation_deser::parse_stop_auto_ml_job_response(response)
        }
    }
}

/// Operation shape for `StopCompilationJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_compilation_job`](crate::client::Client::stop_compilation_job).
///
/// See [`crate::client::fluent_builders::StopCompilationJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopCompilationJob {
    _private: (),
}
impl StopCompilationJob {
    /// Creates a new builder-style object to manufacture [`StopCompilationJobInput`](crate::input::StopCompilationJobInput)
    pub fn builder() -> crate::input::stop_compilation_job_input::Builder {
        crate::input::stop_compilation_job_input::Builder::default()
    }
    /// Creates a new `StopCompilationJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopCompilationJob {
    type Output = std::result::Result<
        crate::output::StopCompilationJobOutput,
        crate::error::StopCompilationJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_compilation_job_error(response)
        } else {
            crate::operation_deser::parse_stop_compilation_job_response(response)
        }
    }
}

/// Operation shape for `StopEdgePackagingJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_edge_packaging_job`](crate::client::Client::stop_edge_packaging_job).
///
/// See [`crate::client::fluent_builders::StopEdgePackagingJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopEdgePackagingJob {
    _private: (),
}
impl StopEdgePackagingJob {
    /// Creates a new builder-style object to manufacture [`StopEdgePackagingJobInput`](crate::input::StopEdgePackagingJobInput)
    pub fn builder() -> crate::input::stop_edge_packaging_job_input::Builder {
        crate::input::stop_edge_packaging_job_input::Builder::default()
    }
    /// Creates a new `StopEdgePackagingJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopEdgePackagingJob {
    type Output = std::result::Result<
        crate::output::StopEdgePackagingJobOutput,
        crate::error::StopEdgePackagingJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_edge_packaging_job_error(response)
        } else {
            crate::operation_deser::parse_stop_edge_packaging_job_response(response)
        }
    }
}

/// Operation shape for `StopHyperParameterTuningJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_hyper_parameter_tuning_job`](crate::client::Client::stop_hyper_parameter_tuning_job).
///
/// See [`crate::client::fluent_builders::StopHyperParameterTuningJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopHyperParameterTuningJob {
    _private: (),
}
impl StopHyperParameterTuningJob {
    /// Creates a new builder-style object to manufacture [`StopHyperParameterTuningJobInput`](crate::input::StopHyperParameterTuningJobInput)
    pub fn builder() -> crate::input::stop_hyper_parameter_tuning_job_input::Builder {
        crate::input::stop_hyper_parameter_tuning_job_input::Builder::default()
    }
    /// Creates a new `StopHyperParameterTuningJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopHyperParameterTuningJob {
    type Output = std::result::Result<
        crate::output::StopHyperParameterTuningJobOutput,
        crate::error::StopHyperParameterTuningJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_hyper_parameter_tuning_job_error(response)
        } else {
            crate::operation_deser::parse_stop_hyper_parameter_tuning_job_response(response)
        }
    }
}

/// Operation shape for `StopLabelingJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_labeling_job`](crate::client::Client::stop_labeling_job).
///
/// See [`crate::client::fluent_builders::StopLabelingJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopLabelingJob {
    _private: (),
}
impl StopLabelingJob {
    /// Creates a new builder-style object to manufacture [`StopLabelingJobInput`](crate::input::StopLabelingJobInput)
    pub fn builder() -> crate::input::stop_labeling_job_input::Builder {
        crate::input::stop_labeling_job_input::Builder::default()
    }
    /// Creates a new `StopLabelingJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopLabelingJob {
    type Output = std::result::Result<
        crate::output::StopLabelingJobOutput,
        crate::error::StopLabelingJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_labeling_job_error(response)
        } else {
            crate::operation_deser::parse_stop_labeling_job_response(response)
        }
    }
}

/// Operation shape for `StopMonitoringSchedule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_monitoring_schedule`](crate::client::Client::stop_monitoring_schedule).
///
/// See [`crate::client::fluent_builders::StopMonitoringSchedule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopMonitoringSchedule {
    _private: (),
}
impl StopMonitoringSchedule {
    /// Creates a new builder-style object to manufacture [`StopMonitoringScheduleInput`](crate::input::StopMonitoringScheduleInput)
    pub fn builder() -> crate::input::stop_monitoring_schedule_input::Builder {
        crate::input::stop_monitoring_schedule_input::Builder::default()
    }
    /// Creates a new `StopMonitoringSchedule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopMonitoringSchedule {
    type Output = std::result::Result<
        crate::output::StopMonitoringScheduleOutput,
        crate::error::StopMonitoringScheduleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_monitoring_schedule_error(response)
        } else {
            crate::operation_deser::parse_stop_monitoring_schedule_response(response)
        }
    }
}

/// Operation shape for `StopNotebookInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_notebook_instance`](crate::client::Client::stop_notebook_instance).
///
/// See [`crate::client::fluent_builders::StopNotebookInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopNotebookInstance {
    _private: (),
}
impl StopNotebookInstance {
    /// Creates a new builder-style object to manufacture [`StopNotebookInstanceInput`](crate::input::StopNotebookInstanceInput)
    pub fn builder() -> crate::input::stop_notebook_instance_input::Builder {
        crate::input::stop_notebook_instance_input::Builder::default()
    }
    /// Creates a new `StopNotebookInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopNotebookInstance {
    type Output = std::result::Result<
        crate::output::StopNotebookInstanceOutput,
        crate::error::StopNotebookInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_notebook_instance_error(response)
        } else {
            crate::operation_deser::parse_stop_notebook_instance_response(response)
        }
    }
}

/// Operation shape for `StopPipelineExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_pipeline_execution`](crate::client::Client::stop_pipeline_execution).
///
/// See [`crate::client::fluent_builders::StopPipelineExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopPipelineExecution {
    _private: (),
}
impl StopPipelineExecution {
    /// Creates a new builder-style object to manufacture [`StopPipelineExecutionInput`](crate::input::StopPipelineExecutionInput)
    pub fn builder() -> crate::input::stop_pipeline_execution_input::Builder {
        crate::input::stop_pipeline_execution_input::Builder::default()
    }
    /// Creates a new `StopPipelineExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopPipelineExecution {
    type Output = std::result::Result<
        crate::output::StopPipelineExecutionOutput,
        crate::error::StopPipelineExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_pipeline_execution_error(response)
        } else {
            crate::operation_deser::parse_stop_pipeline_execution_response(response)
        }
    }
}

/// Operation shape for `StopProcessingJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_processing_job`](crate::client::Client::stop_processing_job).
///
/// See [`crate::client::fluent_builders::StopProcessingJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopProcessingJob {
    _private: (),
}
impl StopProcessingJob {
    /// Creates a new builder-style object to manufacture [`StopProcessingJobInput`](crate::input::StopProcessingJobInput)
    pub fn builder() -> crate::input::stop_processing_job_input::Builder {
        crate::input::stop_processing_job_input::Builder::default()
    }
    /// Creates a new `StopProcessingJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopProcessingJob {
    type Output = std::result::Result<
        crate::output::StopProcessingJobOutput,
        crate::error::StopProcessingJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_processing_job_error(response)
        } else {
            crate::operation_deser::parse_stop_processing_job_response(response)
        }
    }
}

/// Operation shape for `StopTrainingJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_training_job`](crate::client::Client::stop_training_job).
///
/// See [`crate::client::fluent_builders::StopTrainingJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopTrainingJob {
    _private: (),
}
impl StopTrainingJob {
    /// Creates a new builder-style object to manufacture [`StopTrainingJobInput`](crate::input::StopTrainingJobInput)
    pub fn builder() -> crate::input::stop_training_job_input::Builder {
        crate::input::stop_training_job_input::Builder::default()
    }
    /// Creates a new `StopTrainingJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopTrainingJob {
    type Output = std::result::Result<
        crate::output::StopTrainingJobOutput,
        crate::error::StopTrainingJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_training_job_error(response)
        } else {
            crate::operation_deser::parse_stop_training_job_response(response)
        }
    }
}

/// Operation shape for `StopTransformJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_transform_job`](crate::client::Client::stop_transform_job).
///
/// See [`crate::client::fluent_builders::StopTransformJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopTransformJob {
    _private: (),
}
impl StopTransformJob {
    /// Creates a new builder-style object to manufacture [`StopTransformJobInput`](crate::input::StopTransformJobInput)
    pub fn builder() -> crate::input::stop_transform_job_input::Builder {
        crate::input::stop_transform_job_input::Builder::default()
    }
    /// Creates a new `StopTransformJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopTransformJob {
    type Output = std::result::Result<
        crate::output::StopTransformJobOutput,
        crate::error::StopTransformJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_transform_job_error(response)
        } else {
            crate::operation_deser::parse_stop_transform_job_response(response)
        }
    }
}

/// Operation shape for `UpdateAction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_action`](crate::client::Client::update_action).
///
/// See [`crate::client::fluent_builders::UpdateAction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAction {
    _private: (),
}
impl UpdateAction {
    /// Creates a new builder-style object to manufacture [`UpdateActionInput`](crate::input::UpdateActionInput)
    pub fn builder() -> crate::input::update_action_input::Builder {
        crate::input::update_action_input::Builder::default()
    }
    /// Creates a new `UpdateAction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAction {
    type Output =
        std::result::Result<crate::output::UpdateActionOutput, crate::error::UpdateActionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_action_error(response)
        } else {
            crate::operation_deser::parse_update_action_response(response)
        }
    }
}

/// Operation shape for `UpdateAppImageConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_app_image_config`](crate::client::Client::update_app_image_config).
///
/// See [`crate::client::fluent_builders::UpdateAppImageConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAppImageConfig {
    _private: (),
}
impl UpdateAppImageConfig {
    /// Creates a new builder-style object to manufacture [`UpdateAppImageConfigInput`](crate::input::UpdateAppImageConfigInput)
    pub fn builder() -> crate::input::update_app_image_config_input::Builder {
        crate::input::update_app_image_config_input::Builder::default()
    }
    /// Creates a new `UpdateAppImageConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAppImageConfig {
    type Output = std::result::Result<
        crate::output::UpdateAppImageConfigOutput,
        crate::error::UpdateAppImageConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_app_image_config_error(response)
        } else {
            crate::operation_deser::parse_update_app_image_config_response(response)
        }
    }
}

/// Operation shape for `UpdateArtifact`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_artifact`](crate::client::Client::update_artifact).
///
/// See [`crate::client::fluent_builders::UpdateArtifact`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateArtifact {
    _private: (),
}
impl UpdateArtifact {
    /// Creates a new builder-style object to manufacture [`UpdateArtifactInput`](crate::input::UpdateArtifactInput)
    pub fn builder() -> crate::input::update_artifact_input::Builder {
        crate::input::update_artifact_input::Builder::default()
    }
    /// Creates a new `UpdateArtifact` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateArtifact {
    type Output =
        std::result::Result<crate::output::UpdateArtifactOutput, crate::error::UpdateArtifactError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_artifact_error(response)
        } else {
            crate::operation_deser::parse_update_artifact_response(response)
        }
    }
}

/// Operation shape for `UpdateCodeRepository`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_code_repository`](crate::client::Client::update_code_repository).
///
/// See [`crate::client::fluent_builders::UpdateCodeRepository`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateCodeRepository {
    _private: (),
}
impl UpdateCodeRepository {
    /// Creates a new builder-style object to manufacture [`UpdateCodeRepositoryInput`](crate::input::UpdateCodeRepositoryInput)
    pub fn builder() -> crate::input::update_code_repository_input::Builder {
        crate::input::update_code_repository_input::Builder::default()
    }
    /// Creates a new `UpdateCodeRepository` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateCodeRepository {
    type Output = std::result::Result<
        crate::output::UpdateCodeRepositoryOutput,
        crate::error::UpdateCodeRepositoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_code_repository_error(response)
        } else {
            crate::operation_deser::parse_update_code_repository_response(response)
        }
    }
}

/// Operation shape for `UpdateContext`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_context`](crate::client::Client::update_context).
///
/// See [`crate::client::fluent_builders::UpdateContext`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateContext {
    _private: (),
}
impl UpdateContext {
    /// Creates a new builder-style object to manufacture [`UpdateContextInput`](crate::input::UpdateContextInput)
    pub fn builder() -> crate::input::update_context_input::Builder {
        crate::input::update_context_input::Builder::default()
    }
    /// Creates a new `UpdateContext` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateContext {
    type Output =
        std::result::Result<crate::output::UpdateContextOutput, crate::error::UpdateContextError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_context_error(response)
        } else {
            crate::operation_deser::parse_update_context_response(response)
        }
    }
}

/// Operation shape for `UpdateDeviceFleet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_device_fleet`](crate::client::Client::update_device_fleet).
///
/// See [`crate::client::fluent_builders::UpdateDeviceFleet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDeviceFleet {
    _private: (),
}
impl UpdateDeviceFleet {
    /// Creates a new builder-style object to manufacture [`UpdateDeviceFleetInput`](crate::input::UpdateDeviceFleetInput)
    pub fn builder() -> crate::input::update_device_fleet_input::Builder {
        crate::input::update_device_fleet_input::Builder::default()
    }
    /// Creates a new `UpdateDeviceFleet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDeviceFleet {
    type Output = std::result::Result<
        crate::output::UpdateDeviceFleetOutput,
        crate::error::UpdateDeviceFleetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_device_fleet_error(response)
        } else {
            crate::operation_deser::parse_update_device_fleet_response(response)
        }
    }
}

/// Operation shape for `UpdateDevices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_devices`](crate::client::Client::update_devices).
///
/// See [`crate::client::fluent_builders::UpdateDevices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDevices {
    _private: (),
}
impl UpdateDevices {
    /// Creates a new builder-style object to manufacture [`UpdateDevicesInput`](crate::input::UpdateDevicesInput)
    pub fn builder() -> crate::input::update_devices_input::Builder {
        crate::input::update_devices_input::Builder::default()
    }
    /// Creates a new `UpdateDevices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDevices {
    type Output =
        std::result::Result<crate::output::UpdateDevicesOutput, crate::error::UpdateDevicesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_devices_error(response)
        } else {
            crate::operation_deser::parse_update_devices_response(response)
        }
    }
}

/// Operation shape for `UpdateDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_domain`](crate::client::Client::update_domain).
///
/// See [`crate::client::fluent_builders::UpdateDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDomain {
    _private: (),
}
impl UpdateDomain {
    /// Creates a new builder-style object to manufacture [`UpdateDomainInput`](crate::input::UpdateDomainInput)
    pub fn builder() -> crate::input::update_domain_input::Builder {
        crate::input::update_domain_input::Builder::default()
    }
    /// Creates a new `UpdateDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDomain {
    type Output =
        std::result::Result<crate::output::UpdateDomainOutput, crate::error::UpdateDomainError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_domain_error(response)
        } else {
            crate::operation_deser::parse_update_domain_response(response)
        }
    }
}

/// Operation shape for `UpdateEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_endpoint`](crate::client::Client::update_endpoint).
///
/// See [`crate::client::fluent_builders::UpdateEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateEndpoint {
    _private: (),
}
impl UpdateEndpoint {
    /// Creates a new builder-style object to manufacture [`UpdateEndpointInput`](crate::input::UpdateEndpointInput)
    pub fn builder() -> crate::input::update_endpoint_input::Builder {
        crate::input::update_endpoint_input::Builder::default()
    }
    /// Creates a new `UpdateEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateEndpoint {
    type Output =
        std::result::Result<crate::output::UpdateEndpointOutput, crate::error::UpdateEndpointError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_endpoint_error(response)
        } else {
            crate::operation_deser::parse_update_endpoint_response(response)
        }
    }
}

/// Operation shape for `UpdateEndpointWeightsAndCapacities`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_endpoint_weights_and_capacities`](crate::client::Client::update_endpoint_weights_and_capacities).
///
/// See [`crate::client::fluent_builders::UpdateEndpointWeightsAndCapacities`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateEndpointWeightsAndCapacities {
    _private: (),
}
impl UpdateEndpointWeightsAndCapacities {
    /// Creates a new builder-style object to manufacture [`UpdateEndpointWeightsAndCapacitiesInput`](crate::input::UpdateEndpointWeightsAndCapacitiesInput)
    pub fn builder() -> crate::input::update_endpoint_weights_and_capacities_input::Builder {
        crate::input::update_endpoint_weights_and_capacities_input::Builder::default()
    }
    /// Creates a new `UpdateEndpointWeightsAndCapacities` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateEndpointWeightsAndCapacities {
    type Output = std::result::Result<
        crate::output::UpdateEndpointWeightsAndCapacitiesOutput,
        crate::error::UpdateEndpointWeightsAndCapacitiesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_endpoint_weights_and_capacities_error(response)
        } else {
            crate::operation_deser::parse_update_endpoint_weights_and_capacities_response(response)
        }
    }
}

/// Operation shape for `UpdateExperiment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_experiment`](crate::client::Client::update_experiment).
///
/// See [`crate::client::fluent_builders::UpdateExperiment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateExperiment {
    _private: (),
}
impl UpdateExperiment {
    /// Creates a new builder-style object to manufacture [`UpdateExperimentInput`](crate::input::UpdateExperimentInput)
    pub fn builder() -> crate::input::update_experiment_input::Builder {
        crate::input::update_experiment_input::Builder::default()
    }
    /// Creates a new `UpdateExperiment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateExperiment {
    type Output = std::result::Result<
        crate::output::UpdateExperimentOutput,
        crate::error::UpdateExperimentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_experiment_error(response)
        } else {
            crate::operation_deser::parse_update_experiment_response(response)
        }
    }
}

/// Operation shape for `UpdateImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_image`](crate::client::Client::update_image).
///
/// See [`crate::client::fluent_builders::UpdateImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateImage {
    _private: (),
}
impl UpdateImage {
    /// Creates a new builder-style object to manufacture [`UpdateImageInput`](crate::input::UpdateImageInput)
    pub fn builder() -> crate::input::update_image_input::Builder {
        crate::input::update_image_input::Builder::default()
    }
    /// Creates a new `UpdateImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateImage {
    type Output =
        std::result::Result<crate::output::UpdateImageOutput, crate::error::UpdateImageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_image_error(response)
        } else {
            crate::operation_deser::parse_update_image_response(response)
        }
    }
}

/// Operation shape for `UpdateModelPackage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_model_package`](crate::client::Client::update_model_package).
///
/// See [`crate::client::fluent_builders::UpdateModelPackage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateModelPackage {
    _private: (),
}
impl UpdateModelPackage {
    /// Creates a new builder-style object to manufacture [`UpdateModelPackageInput`](crate::input::UpdateModelPackageInput)
    pub fn builder() -> crate::input::update_model_package_input::Builder {
        crate::input::update_model_package_input::Builder::default()
    }
    /// Creates a new `UpdateModelPackage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateModelPackage {
    type Output = std::result::Result<
        crate::output::UpdateModelPackageOutput,
        crate::error::UpdateModelPackageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_model_package_error(response)
        } else {
            crate::operation_deser::parse_update_model_package_response(response)
        }
    }
}

/// Operation shape for `UpdateMonitoringSchedule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_monitoring_schedule`](crate::client::Client::update_monitoring_schedule).
///
/// See [`crate::client::fluent_builders::UpdateMonitoringSchedule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateMonitoringSchedule {
    _private: (),
}
impl UpdateMonitoringSchedule {
    /// Creates a new builder-style object to manufacture [`UpdateMonitoringScheduleInput`](crate::input::UpdateMonitoringScheduleInput)
    pub fn builder() -> crate::input::update_monitoring_schedule_input::Builder {
        crate::input::update_monitoring_schedule_input::Builder::default()
    }
    /// Creates a new `UpdateMonitoringSchedule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateMonitoringSchedule {
    type Output = std::result::Result<
        crate::output::UpdateMonitoringScheduleOutput,
        crate::error::UpdateMonitoringScheduleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_monitoring_schedule_error(response)
        } else {
            crate::operation_deser::parse_update_monitoring_schedule_response(response)
        }
    }
}

/// Operation shape for `UpdateNotebookInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_notebook_instance`](crate::client::Client::update_notebook_instance).
///
/// See [`crate::client::fluent_builders::UpdateNotebookInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateNotebookInstance {
    _private: (),
}
impl UpdateNotebookInstance {
    /// Creates a new builder-style object to manufacture [`UpdateNotebookInstanceInput`](crate::input::UpdateNotebookInstanceInput)
    pub fn builder() -> crate::input::update_notebook_instance_input::Builder {
        crate::input::update_notebook_instance_input::Builder::default()
    }
    /// Creates a new `UpdateNotebookInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateNotebookInstance {
    type Output = std::result::Result<
        crate::output::UpdateNotebookInstanceOutput,
        crate::error::UpdateNotebookInstanceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_notebook_instance_error(response)
        } else {
            crate::operation_deser::parse_update_notebook_instance_response(response)
        }
    }
}

/// Operation shape for `UpdateNotebookInstanceLifecycleConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_notebook_instance_lifecycle_config`](crate::client::Client::update_notebook_instance_lifecycle_config).
///
/// See [`crate::client::fluent_builders::UpdateNotebookInstanceLifecycleConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateNotebookInstanceLifecycleConfig {
    _private: (),
}
impl UpdateNotebookInstanceLifecycleConfig {
    /// Creates a new builder-style object to manufacture [`UpdateNotebookInstanceLifecycleConfigInput`](crate::input::UpdateNotebookInstanceLifecycleConfigInput)
    pub fn builder() -> crate::input::update_notebook_instance_lifecycle_config_input::Builder {
        crate::input::update_notebook_instance_lifecycle_config_input::Builder::default()
    }
    /// Creates a new `UpdateNotebookInstanceLifecycleConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateNotebookInstanceLifecycleConfig {
    type Output = std::result::Result<
        crate::output::UpdateNotebookInstanceLifecycleConfigOutput,
        crate::error::UpdateNotebookInstanceLifecycleConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_notebook_instance_lifecycle_config_error(response)
        } else {
            crate::operation_deser::parse_update_notebook_instance_lifecycle_config_response(
                response,
            )
        }
    }
}

/// Operation shape for `UpdatePipeline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_pipeline`](crate::client::Client::update_pipeline).
///
/// See [`crate::client::fluent_builders::UpdatePipeline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePipeline {
    _private: (),
}
impl UpdatePipeline {
    /// Creates a new builder-style object to manufacture [`UpdatePipelineInput`](crate::input::UpdatePipelineInput)
    pub fn builder() -> crate::input::update_pipeline_input::Builder {
        crate::input::update_pipeline_input::Builder::default()
    }
    /// Creates a new `UpdatePipeline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePipeline {
    type Output =
        std::result::Result<crate::output::UpdatePipelineOutput, crate::error::UpdatePipelineError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_pipeline_error(response)
        } else {
            crate::operation_deser::parse_update_pipeline_response(response)
        }
    }
}

/// Operation shape for `UpdatePipelineExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_pipeline_execution`](crate::client::Client::update_pipeline_execution).
///
/// See [`crate::client::fluent_builders::UpdatePipelineExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePipelineExecution {
    _private: (),
}
impl UpdatePipelineExecution {
    /// Creates a new builder-style object to manufacture [`UpdatePipelineExecutionInput`](crate::input::UpdatePipelineExecutionInput)
    pub fn builder() -> crate::input::update_pipeline_execution_input::Builder {
        crate::input::update_pipeline_execution_input::Builder::default()
    }
    /// Creates a new `UpdatePipelineExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePipelineExecution {
    type Output = std::result::Result<
        crate::output::UpdatePipelineExecutionOutput,
        crate::error::UpdatePipelineExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_pipeline_execution_error(response)
        } else {
            crate::operation_deser::parse_update_pipeline_execution_response(response)
        }
    }
}

/// Operation shape for `UpdateTrainingJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_training_job`](crate::client::Client::update_training_job).
///
/// See [`crate::client::fluent_builders::UpdateTrainingJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTrainingJob {
    _private: (),
}
impl UpdateTrainingJob {
    /// Creates a new builder-style object to manufacture [`UpdateTrainingJobInput`](crate::input::UpdateTrainingJobInput)
    pub fn builder() -> crate::input::update_training_job_input::Builder {
        crate::input::update_training_job_input::Builder::default()
    }
    /// Creates a new `UpdateTrainingJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTrainingJob {
    type Output = std::result::Result<
        crate::output::UpdateTrainingJobOutput,
        crate::error::UpdateTrainingJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_training_job_error(response)
        } else {
            crate::operation_deser::parse_update_training_job_response(response)
        }
    }
}

/// Operation shape for `UpdateTrial`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_trial`](crate::client::Client::update_trial).
///
/// See [`crate::client::fluent_builders::UpdateTrial`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTrial {
    _private: (),
}
impl UpdateTrial {
    /// Creates a new builder-style object to manufacture [`UpdateTrialInput`](crate::input::UpdateTrialInput)
    pub fn builder() -> crate::input::update_trial_input::Builder {
        crate::input::update_trial_input::Builder::default()
    }
    /// Creates a new `UpdateTrial` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTrial {
    type Output =
        std::result::Result<crate::output::UpdateTrialOutput, crate::error::UpdateTrialError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_trial_error(response)
        } else {
            crate::operation_deser::parse_update_trial_response(response)
        }
    }
}

/// Operation shape for `UpdateTrialComponent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_trial_component`](crate::client::Client::update_trial_component).
///
/// See [`crate::client::fluent_builders::UpdateTrialComponent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTrialComponent {
    _private: (),
}
impl UpdateTrialComponent {
    /// Creates a new builder-style object to manufacture [`UpdateTrialComponentInput`](crate::input::UpdateTrialComponentInput)
    pub fn builder() -> crate::input::update_trial_component_input::Builder {
        crate::input::update_trial_component_input::Builder::default()
    }
    /// Creates a new `UpdateTrialComponent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTrialComponent {
    type Output = std::result::Result<
        crate::output::UpdateTrialComponentOutput,
        crate::error::UpdateTrialComponentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_trial_component_error(response)
        } else {
            crate::operation_deser::parse_update_trial_component_response(response)
        }
    }
}

/// Operation shape for `UpdateUserProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_user_profile`](crate::client::Client::update_user_profile).
///
/// See [`crate::client::fluent_builders::UpdateUserProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateUserProfile {
    _private: (),
}
impl UpdateUserProfile {
    /// Creates a new builder-style object to manufacture [`UpdateUserProfileInput`](crate::input::UpdateUserProfileInput)
    pub fn builder() -> crate::input::update_user_profile_input::Builder {
        crate::input::update_user_profile_input::Builder::default()
    }
    /// Creates a new `UpdateUserProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateUserProfile {
    type Output = std::result::Result<
        crate::output::UpdateUserProfileOutput,
        crate::error::UpdateUserProfileError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_user_profile_error(response)
        } else {
            crate::operation_deser::parse_update_user_profile_response(response)
        }
    }
}

/// Operation shape for `UpdateWorkforce`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_workforce`](crate::client::Client::update_workforce).
///
/// See [`crate::client::fluent_builders::UpdateWorkforce`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateWorkforce {
    _private: (),
}
impl UpdateWorkforce {
    /// Creates a new builder-style object to manufacture [`UpdateWorkforceInput`](crate::input::UpdateWorkforceInput)
    pub fn builder() -> crate::input::update_workforce_input::Builder {
        crate::input::update_workforce_input::Builder::default()
    }
    /// Creates a new `UpdateWorkforce` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateWorkforce {
    type Output = std::result::Result<
        crate::output::UpdateWorkforceOutput,
        crate::error::UpdateWorkforceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_workforce_error(response)
        } else {
            crate::operation_deser::parse_update_workforce_response(response)
        }
    }
}

/// Operation shape for `UpdateWorkteam`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_workteam`](crate::client::Client::update_workteam).
///
/// See [`crate::client::fluent_builders::UpdateWorkteam`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateWorkteam {
    _private: (),
}
impl UpdateWorkteam {
    /// Creates a new builder-style object to manufacture [`UpdateWorkteamInput`](crate::input::UpdateWorkteamInput)
    pub fn builder() -> crate::input::update_workteam_input::Builder {
        crate::input::update_workteam_input::Builder::default()
    }
    /// Creates a new `UpdateWorkteam` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateWorkteam {
    type Output =
        std::result::Result<crate::output::UpdateWorkteamOutput, crate::error::UpdateWorkteamError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_workteam_error(response)
        } else {
            crate::operation_deser::parse_update_workteam_response(response)
        }
    }
}
