// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEndpointsOutput {
    /// <p>Returns an array of endpoints associated with AWS Outposts.</p>
    pub endpoints: std::option::Option<std::vec::Vec<crate::model::Endpoint>>,
    /// <p>The next endpoint returned in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListEndpointsOutput {
    /// <p>Returns an array of endpoints associated with AWS Outposts.</p>
    pub fn endpoints(&self) -> std::option::Option<&[crate::model::Endpoint]> {
        self.endpoints.as_deref()
    }
    /// <p>The next endpoint returned in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListEndpointsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEndpointsOutput");
        formatter.field("endpoints", &self.endpoints);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListEndpointsOutput`](crate::output::ListEndpointsOutput)
pub mod list_endpoints_output {
    /// A builder for [`ListEndpointsOutput`](crate::output::ListEndpointsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoints: std::option::Option<std::vec::Vec<crate::model::Endpoint>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `endpoints`.
        ///
        /// To override the contents of this collection use [`set_endpoints`](Self::set_endpoints).
        ///
        /// <p>Returns an array of endpoints associated with AWS Outposts.</p>
        pub fn endpoints(mut self, input: impl Into<crate::model::Endpoint>) -> Self {
            let mut v = self.endpoints.unwrap_or_default();
            v.push(input.into());
            self.endpoints = Some(v);
            self
        }
        /// <p>Returns an array of endpoints associated with AWS Outposts.</p>
        pub fn set_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Endpoint>>,
        ) -> Self {
            self.endpoints = input;
            self
        }
        /// <p>The next endpoint returned in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next endpoint returned in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEndpointsOutput`](crate::output::ListEndpointsOutput)
        pub fn build(self) -> crate::output::ListEndpointsOutput {
            crate::output::ListEndpointsOutput {
                endpoints: self.endpoints,
                next_token: self.next_token,
            }
        }
    }
}
impl ListEndpointsOutput {
    /// Creates a new builder-style object to manufacture [`ListEndpointsOutput`](crate::output::ListEndpointsOutput)
    pub fn builder() -> crate::output::list_endpoints_output::Builder {
        crate::output::list_endpoints_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEndpointOutput {}
impl std::fmt::Debug for DeleteEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEndpointOutput");
        formatter.finish()
    }
}
/// See [`DeleteEndpointOutput`](crate::output::DeleteEndpointOutput)
pub mod delete_endpoint_output {
    /// A builder for [`DeleteEndpointOutput`](crate::output::DeleteEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteEndpointOutput`](crate::output::DeleteEndpointOutput)
        pub fn build(self) -> crate::output::DeleteEndpointOutput {
            crate::output::DeleteEndpointOutput {}
        }
    }
}
impl DeleteEndpointOutput {
    /// Creates a new builder-style object to manufacture [`DeleteEndpointOutput`](crate::output::DeleteEndpointOutput)
    pub fn builder() -> crate::output::delete_endpoint_output::Builder {
        crate::output::delete_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEndpointOutput {
    /// <p>The Amazon Resource Name (ARN) of the endpoint.</p>
    pub endpoint_arn: std::option::Option<std::string::String>,
}
impl CreateEndpointOutput {
    /// <p>The Amazon Resource Name (ARN) of the endpoint.</p>
    pub fn endpoint_arn(&self) -> std::option::Option<&str> {
        self.endpoint_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEndpointOutput");
        formatter.field("endpoint_arn", &self.endpoint_arn);
        formatter.finish()
    }
}
/// See [`CreateEndpointOutput`](crate::output::CreateEndpointOutput)
pub mod create_endpoint_output {
    /// A builder for [`CreateEndpointOutput`](crate::output::CreateEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the endpoint.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEndpointOutput`](crate::output::CreateEndpointOutput)
        pub fn build(self) -> crate::output::CreateEndpointOutput {
            crate::output::CreateEndpointOutput {
                endpoint_arn: self.endpoint_arn,
            }
        }
    }
}
impl CreateEndpointOutput {
    /// Creates a new builder-style object to manufacture [`CreateEndpointOutput`](crate::output::CreateEndpointOutput)
    pub fn builder() -> crate::output::create_endpoint_output::Builder {
        crate::output::create_endpoint_output::Builder::default()
    }
}
