// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateAccessPoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_access_point`](crate::client::Client::create_access_point).
///
/// See [`crate::client::fluent_builders::CreateAccessPoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAccessPoint {
    _private: (),
}
impl CreateAccessPoint {
    /// Creates a new builder-style object to manufacture [`CreateAccessPointInput`](crate::input::CreateAccessPointInput)
    pub fn builder() -> crate::input::create_access_point_input::Builder {
        crate::input::create_access_point_input::Builder::default()
    }
    /// Creates a new `CreateAccessPoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAccessPoint {
    type Output = std::result::Result<
        crate::output::CreateAccessPointOutput,
        crate::error::CreateAccessPointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_access_point_error(response)
        } else {
            crate::operation_deser::parse_create_access_point_response(response)
        }
    }
}

/// Operation shape for `CreateAccessPointForObjectLambda`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_access_point_for_object_lambda`](crate::client::Client::create_access_point_for_object_lambda).
///
/// See [`crate::client::fluent_builders::CreateAccessPointForObjectLambda`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAccessPointForObjectLambda {
    _private: (),
}
impl CreateAccessPointForObjectLambda {
    /// Creates a new builder-style object to manufacture [`CreateAccessPointForObjectLambdaInput`](crate::input::CreateAccessPointForObjectLambdaInput)
    pub fn builder() -> crate::input::create_access_point_for_object_lambda_input::Builder {
        crate::input::create_access_point_for_object_lambda_input::Builder::default()
    }
    /// Creates a new `CreateAccessPointForObjectLambda` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAccessPointForObjectLambda {
    type Output = std::result::Result<
        crate::output::CreateAccessPointForObjectLambdaOutput,
        crate::error::CreateAccessPointForObjectLambdaError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_access_point_for_object_lambda_error(response)
        } else {
            crate::operation_deser::parse_create_access_point_for_object_lambda_response(response)
        }
    }
}

/// Operation shape for `CreateBucket`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_bucket`](crate::client::Client::create_bucket).
///
/// See [`crate::client::fluent_builders::CreateBucket`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBucket {
    _private: (),
}
impl CreateBucket {
    /// Creates a new builder-style object to manufacture [`CreateBucketInput`](crate::input::CreateBucketInput)
    pub fn builder() -> crate::input::create_bucket_input::Builder {
        crate::input::create_bucket_input::Builder::default()
    }
    /// Creates a new `CreateBucket` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBucket {
    type Output =
        std::result::Result<crate::output::CreateBucketOutput, crate::error::CreateBucketError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_bucket_error(response)
        } else {
            crate::operation_deser::parse_create_bucket_response(response)
        }
    }
}

/// Operation shape for `CreateJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_job`](crate::client::Client::create_job).
///
/// See [`crate::client::fluent_builders::CreateJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateJob {
    _private: (),
}
impl CreateJob {
    /// Creates a new builder-style object to manufacture [`CreateJobInput`](crate::input::CreateJobInput)
    pub fn builder() -> crate::input::create_job_input::Builder {
        crate::input::create_job_input::Builder::default()
    }
    /// Creates a new `CreateJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateJob {
    type Output = std::result::Result<crate::output::CreateJobOutput, crate::error::CreateJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_job_error(response)
        } else {
            crate::operation_deser::parse_create_job_response(response)
        }
    }
}

/// Operation shape for `CreateMultiRegionAccessPoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_multi_region_access_point`](crate::client::Client::create_multi_region_access_point).
///
/// See [`crate::client::fluent_builders::CreateMultiRegionAccessPoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMultiRegionAccessPoint {
    _private: (),
}
impl CreateMultiRegionAccessPoint {
    /// Creates a new builder-style object to manufacture [`CreateMultiRegionAccessPointInput`](crate::input::CreateMultiRegionAccessPointInput)
    pub fn builder() -> crate::input::create_multi_region_access_point_input::Builder {
        crate::input::create_multi_region_access_point_input::Builder::default()
    }
    /// Creates a new `CreateMultiRegionAccessPoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMultiRegionAccessPoint {
    type Output = std::result::Result<
        crate::output::CreateMultiRegionAccessPointOutput,
        crate::error::CreateMultiRegionAccessPointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_multi_region_access_point_error(response)
        } else {
            crate::operation_deser::parse_create_multi_region_access_point_response(response)
        }
    }
}

/// Operation shape for `DeleteAccessPoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_access_point`](crate::client::Client::delete_access_point).
///
/// See [`crate::client::fluent_builders::DeleteAccessPoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAccessPoint {
    _private: (),
}
impl DeleteAccessPoint {
    /// Creates a new builder-style object to manufacture [`DeleteAccessPointInput`](crate::input::DeleteAccessPointInput)
    pub fn builder() -> crate::input::delete_access_point_input::Builder {
        crate::input::delete_access_point_input::Builder::default()
    }
    /// Creates a new `DeleteAccessPoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAccessPoint {
    type Output = std::result::Result<
        crate::output::DeleteAccessPointOutput,
        crate::error::DeleteAccessPointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_access_point_error(response)
        } else {
            crate::operation_deser::parse_delete_access_point_response(response)
        }
    }
}

/// Operation shape for `DeleteAccessPointForObjectLambda`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_access_point_for_object_lambda`](crate::client::Client::delete_access_point_for_object_lambda).
///
/// See [`crate::client::fluent_builders::DeleteAccessPointForObjectLambda`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAccessPointForObjectLambda {
    _private: (),
}
impl DeleteAccessPointForObjectLambda {
    /// Creates a new builder-style object to manufacture [`DeleteAccessPointForObjectLambdaInput`](crate::input::DeleteAccessPointForObjectLambdaInput)
    pub fn builder() -> crate::input::delete_access_point_for_object_lambda_input::Builder {
        crate::input::delete_access_point_for_object_lambda_input::Builder::default()
    }
    /// Creates a new `DeleteAccessPointForObjectLambda` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAccessPointForObjectLambda {
    type Output = std::result::Result<
        crate::output::DeleteAccessPointForObjectLambdaOutput,
        crate::error::DeleteAccessPointForObjectLambdaError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_access_point_for_object_lambda_error(response)
        } else {
            crate::operation_deser::parse_delete_access_point_for_object_lambda_response(response)
        }
    }
}

/// Operation shape for `DeleteAccessPointPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_access_point_policy`](crate::client::Client::delete_access_point_policy).
///
/// See [`crate::client::fluent_builders::DeleteAccessPointPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAccessPointPolicy {
    _private: (),
}
impl DeleteAccessPointPolicy {
    /// Creates a new builder-style object to manufacture [`DeleteAccessPointPolicyInput`](crate::input::DeleteAccessPointPolicyInput)
    pub fn builder() -> crate::input::delete_access_point_policy_input::Builder {
        crate::input::delete_access_point_policy_input::Builder::default()
    }
    /// Creates a new `DeleteAccessPointPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAccessPointPolicy {
    type Output = std::result::Result<
        crate::output::DeleteAccessPointPolicyOutput,
        crate::error::DeleteAccessPointPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_access_point_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_access_point_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteAccessPointPolicyForObjectLambda`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_access_point_policy_for_object_lambda`](crate::client::Client::delete_access_point_policy_for_object_lambda).
///
/// See [`crate::client::fluent_builders::DeleteAccessPointPolicyForObjectLambda`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAccessPointPolicyForObjectLambda {
    _private: (),
}
impl DeleteAccessPointPolicyForObjectLambda {
    /// Creates a new builder-style object to manufacture [`DeleteAccessPointPolicyForObjectLambdaInput`](crate::input::DeleteAccessPointPolicyForObjectLambdaInput)
    pub fn builder() -> crate::input::delete_access_point_policy_for_object_lambda_input::Builder {
        crate::input::delete_access_point_policy_for_object_lambda_input::Builder::default()
    }
    /// Creates a new `DeleteAccessPointPolicyForObjectLambda` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAccessPointPolicyForObjectLambda {
    type Output = std::result::Result<
        crate::output::DeleteAccessPointPolicyForObjectLambdaOutput,
        crate::error::DeleteAccessPointPolicyForObjectLambdaError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_access_point_policy_for_object_lambda_error(
                response,
            )
        } else {
            crate::operation_deser::parse_delete_access_point_policy_for_object_lambda_response(
                response,
            )
        }
    }
}

/// Operation shape for `DeleteBucket`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_bucket`](crate::client::Client::delete_bucket).
///
/// See [`crate::client::fluent_builders::DeleteBucket`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBucket {
    _private: (),
}
impl DeleteBucket {
    /// Creates a new builder-style object to manufacture [`DeleteBucketInput`](crate::input::DeleteBucketInput)
    pub fn builder() -> crate::input::delete_bucket_input::Builder {
        crate::input::delete_bucket_input::Builder::default()
    }
    /// Creates a new `DeleteBucket` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBucket {
    type Output =
        std::result::Result<crate::output::DeleteBucketOutput, crate::error::DeleteBucketError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_bucket_error(response)
        } else {
            crate::operation_deser::parse_delete_bucket_response(response)
        }
    }
}

/// Operation shape for `DeleteBucketLifecycleConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_bucket_lifecycle_configuration`](crate::client::Client::delete_bucket_lifecycle_configuration).
///
/// See [`crate::client::fluent_builders::DeleteBucketLifecycleConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBucketLifecycleConfiguration {
    _private: (),
}
impl DeleteBucketLifecycleConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteBucketLifecycleConfigurationInput`](crate::input::DeleteBucketLifecycleConfigurationInput)
    pub fn builder() -> crate::input::delete_bucket_lifecycle_configuration_input::Builder {
        crate::input::delete_bucket_lifecycle_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteBucketLifecycleConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBucketLifecycleConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteBucketLifecycleConfigurationOutput,
        crate::error::DeleteBucketLifecycleConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_bucket_lifecycle_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_bucket_lifecycle_configuration_response(response)
        }
    }
}

/// Operation shape for `DeleteBucketPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_bucket_policy`](crate::client::Client::delete_bucket_policy).
///
/// See [`crate::client::fluent_builders::DeleteBucketPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBucketPolicy {
    _private: (),
}
impl DeleteBucketPolicy {
    /// Creates a new builder-style object to manufacture [`DeleteBucketPolicyInput`](crate::input::DeleteBucketPolicyInput)
    pub fn builder() -> crate::input::delete_bucket_policy_input::Builder {
        crate::input::delete_bucket_policy_input::Builder::default()
    }
    /// Creates a new `DeleteBucketPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBucketPolicy {
    type Output = std::result::Result<
        crate::output::DeleteBucketPolicyOutput,
        crate::error::DeleteBucketPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_bucket_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_bucket_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteBucketTagging`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_bucket_tagging`](crate::client::Client::delete_bucket_tagging).
///
/// See [`crate::client::fluent_builders::DeleteBucketTagging`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBucketTagging {
    _private: (),
}
impl DeleteBucketTagging {
    /// Creates a new builder-style object to manufacture [`DeleteBucketTaggingInput`](crate::input::DeleteBucketTaggingInput)
    pub fn builder() -> crate::input::delete_bucket_tagging_input::Builder {
        crate::input::delete_bucket_tagging_input::Builder::default()
    }
    /// Creates a new `DeleteBucketTagging` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBucketTagging {
    type Output = std::result::Result<
        crate::output::DeleteBucketTaggingOutput,
        crate::error::DeleteBucketTaggingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_bucket_tagging_error(response)
        } else {
            crate::operation_deser::parse_delete_bucket_tagging_response(response)
        }
    }
}

/// Operation shape for `DeleteJobTagging`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_job_tagging`](crate::client::Client::delete_job_tagging).
///
/// See [`crate::client::fluent_builders::DeleteJobTagging`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteJobTagging {
    _private: (),
}
impl DeleteJobTagging {
    /// Creates a new builder-style object to manufacture [`DeleteJobTaggingInput`](crate::input::DeleteJobTaggingInput)
    pub fn builder() -> crate::input::delete_job_tagging_input::Builder {
        crate::input::delete_job_tagging_input::Builder::default()
    }
    /// Creates a new `DeleteJobTagging` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteJobTagging {
    type Output = std::result::Result<
        crate::output::DeleteJobTaggingOutput,
        crate::error::DeleteJobTaggingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_job_tagging_error(response)
        } else {
            crate::operation_deser::parse_delete_job_tagging_response(response)
        }
    }
}

/// Operation shape for `DeleteMultiRegionAccessPoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_multi_region_access_point`](crate::client::Client::delete_multi_region_access_point).
///
/// See [`crate::client::fluent_builders::DeleteMultiRegionAccessPoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMultiRegionAccessPoint {
    _private: (),
}
impl DeleteMultiRegionAccessPoint {
    /// Creates a new builder-style object to manufacture [`DeleteMultiRegionAccessPointInput`](crate::input::DeleteMultiRegionAccessPointInput)
    pub fn builder() -> crate::input::delete_multi_region_access_point_input::Builder {
        crate::input::delete_multi_region_access_point_input::Builder::default()
    }
    /// Creates a new `DeleteMultiRegionAccessPoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMultiRegionAccessPoint {
    type Output = std::result::Result<
        crate::output::DeleteMultiRegionAccessPointOutput,
        crate::error::DeleteMultiRegionAccessPointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_multi_region_access_point_error(response)
        } else {
            crate::operation_deser::parse_delete_multi_region_access_point_response(response)
        }
    }
}

/// Operation shape for `DeletePublicAccessBlock`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_public_access_block`](crate::client::Client::delete_public_access_block).
///
/// See [`crate::client::fluent_builders::DeletePublicAccessBlock`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePublicAccessBlock {
    _private: (),
}
impl DeletePublicAccessBlock {
    /// Creates a new builder-style object to manufacture [`DeletePublicAccessBlockInput`](crate::input::DeletePublicAccessBlockInput)
    pub fn builder() -> crate::input::delete_public_access_block_input::Builder {
        crate::input::delete_public_access_block_input::Builder::default()
    }
    /// Creates a new `DeletePublicAccessBlock` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePublicAccessBlock {
    type Output = std::result::Result<
        crate::output::DeletePublicAccessBlockOutput,
        crate::error::DeletePublicAccessBlockError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_public_access_block_error(response)
        } else {
            crate::operation_deser::parse_delete_public_access_block_response(response)
        }
    }
}

/// Operation shape for `DeleteStorageLensConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_storage_lens_configuration`](crate::client::Client::delete_storage_lens_configuration).
///
/// See [`crate::client::fluent_builders::DeleteStorageLensConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteStorageLensConfiguration {
    _private: (),
}
impl DeleteStorageLensConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteStorageLensConfigurationInput`](crate::input::DeleteStorageLensConfigurationInput)
    pub fn builder() -> crate::input::delete_storage_lens_configuration_input::Builder {
        crate::input::delete_storage_lens_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteStorageLensConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteStorageLensConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteStorageLensConfigurationOutput,
        crate::error::DeleteStorageLensConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_storage_lens_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_storage_lens_configuration_response(response)
        }
    }
}

/// Operation shape for `DeleteStorageLensConfigurationTagging`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_storage_lens_configuration_tagging`](crate::client::Client::delete_storage_lens_configuration_tagging).
///
/// See [`crate::client::fluent_builders::DeleteStorageLensConfigurationTagging`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteStorageLensConfigurationTagging {
    _private: (),
}
impl DeleteStorageLensConfigurationTagging {
    /// Creates a new builder-style object to manufacture [`DeleteStorageLensConfigurationTaggingInput`](crate::input::DeleteStorageLensConfigurationTaggingInput)
    pub fn builder() -> crate::input::delete_storage_lens_configuration_tagging_input::Builder {
        crate::input::delete_storage_lens_configuration_tagging_input::Builder::default()
    }
    /// Creates a new `DeleteStorageLensConfigurationTagging` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteStorageLensConfigurationTagging {
    type Output = std::result::Result<
        crate::output::DeleteStorageLensConfigurationTaggingOutput,
        crate::error::DeleteStorageLensConfigurationTaggingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_storage_lens_configuration_tagging_error(response)
        } else {
            crate::operation_deser::parse_delete_storage_lens_configuration_tagging_response(
                response,
            )
        }
    }
}

/// Operation shape for `DescribeJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_job`](crate::client::Client::describe_job).
///
/// See [`crate::client::fluent_builders::DescribeJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeJob {
    _private: (),
}
impl DescribeJob {
    /// Creates a new builder-style object to manufacture [`DescribeJobInput`](crate::input::DescribeJobInput)
    pub fn builder() -> crate::input::describe_job_input::Builder {
        crate::input::describe_job_input::Builder::default()
    }
    /// Creates a new `DescribeJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeJob {
    type Output =
        std::result::Result<crate::output::DescribeJobOutput, crate::error::DescribeJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_job_error(response)
        } else {
            crate::operation_deser::parse_describe_job_response(response)
        }
    }
}

/// Operation shape for `DescribeMultiRegionAccessPointOperation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_multi_region_access_point_operation`](crate::client::Client::describe_multi_region_access_point_operation).
///
/// See [`crate::client::fluent_builders::DescribeMultiRegionAccessPointOperation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeMultiRegionAccessPointOperation {
    _private: (),
}
impl DescribeMultiRegionAccessPointOperation {
    /// Creates a new builder-style object to manufacture [`DescribeMultiRegionAccessPointOperationInput`](crate::input::DescribeMultiRegionAccessPointOperationInput)
    pub fn builder() -> crate::input::describe_multi_region_access_point_operation_input::Builder {
        crate::input::describe_multi_region_access_point_operation_input::Builder::default()
    }
    /// Creates a new `DescribeMultiRegionAccessPointOperation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeMultiRegionAccessPointOperation {
    type Output = std::result::Result<
        crate::output::DescribeMultiRegionAccessPointOperationOutput,
        crate::error::DescribeMultiRegionAccessPointOperationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_multi_region_access_point_operation_error(
                response,
            )
        } else {
            crate::operation_deser::parse_describe_multi_region_access_point_operation_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetAccessPoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_access_point`](crate::client::Client::get_access_point).
///
/// See [`crate::client::fluent_builders::GetAccessPoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAccessPoint {
    _private: (),
}
impl GetAccessPoint {
    /// Creates a new builder-style object to manufacture [`GetAccessPointInput`](crate::input::GetAccessPointInput)
    pub fn builder() -> crate::input::get_access_point_input::Builder {
        crate::input::get_access_point_input::Builder::default()
    }
    /// Creates a new `GetAccessPoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAccessPoint {
    type Output =
        std::result::Result<crate::output::GetAccessPointOutput, crate::error::GetAccessPointError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_access_point_error(response)
        } else {
            crate::operation_deser::parse_get_access_point_response(response)
        }
    }
}

/// Operation shape for `GetAccessPointConfigurationForObjectLambda`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_access_point_configuration_for_object_lambda`](crate::client::Client::get_access_point_configuration_for_object_lambda).
///
/// See [`crate::client::fluent_builders::GetAccessPointConfigurationForObjectLambda`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAccessPointConfigurationForObjectLambda {
    _private: (),
}
impl GetAccessPointConfigurationForObjectLambda {
    /// Creates a new builder-style object to manufacture [`GetAccessPointConfigurationForObjectLambdaInput`](crate::input::GetAccessPointConfigurationForObjectLambdaInput)
    pub fn builder() -> crate::input::get_access_point_configuration_for_object_lambda_input::Builder
    {
        crate::input::get_access_point_configuration_for_object_lambda_input::Builder::default()
    }
    /// Creates a new `GetAccessPointConfigurationForObjectLambda` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAccessPointConfigurationForObjectLambda {
    type Output = std::result::Result<
        crate::output::GetAccessPointConfigurationForObjectLambdaOutput,
        crate::error::GetAccessPointConfigurationForObjectLambdaError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_access_point_configuration_for_object_lambda_error(
                response,
            )
        } else {
            crate::operation_deser::parse_get_access_point_configuration_for_object_lambda_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetAccessPointForObjectLambda`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_access_point_for_object_lambda`](crate::client::Client::get_access_point_for_object_lambda).
///
/// See [`crate::client::fluent_builders::GetAccessPointForObjectLambda`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAccessPointForObjectLambda {
    _private: (),
}
impl GetAccessPointForObjectLambda {
    /// Creates a new builder-style object to manufacture [`GetAccessPointForObjectLambdaInput`](crate::input::GetAccessPointForObjectLambdaInput)
    pub fn builder() -> crate::input::get_access_point_for_object_lambda_input::Builder {
        crate::input::get_access_point_for_object_lambda_input::Builder::default()
    }
    /// Creates a new `GetAccessPointForObjectLambda` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAccessPointForObjectLambda {
    type Output = std::result::Result<
        crate::output::GetAccessPointForObjectLambdaOutput,
        crate::error::GetAccessPointForObjectLambdaError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_access_point_for_object_lambda_error(response)
        } else {
            crate::operation_deser::parse_get_access_point_for_object_lambda_response(response)
        }
    }
}

/// Operation shape for `GetAccessPointPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_access_point_policy`](crate::client::Client::get_access_point_policy).
///
/// See [`crate::client::fluent_builders::GetAccessPointPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAccessPointPolicy {
    _private: (),
}
impl GetAccessPointPolicy {
    /// Creates a new builder-style object to manufacture [`GetAccessPointPolicyInput`](crate::input::GetAccessPointPolicyInput)
    pub fn builder() -> crate::input::get_access_point_policy_input::Builder {
        crate::input::get_access_point_policy_input::Builder::default()
    }
    /// Creates a new `GetAccessPointPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAccessPointPolicy {
    type Output = std::result::Result<
        crate::output::GetAccessPointPolicyOutput,
        crate::error::GetAccessPointPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_access_point_policy_error(response)
        } else {
            crate::operation_deser::parse_get_access_point_policy_response(response)
        }
    }
}

/// Operation shape for `GetAccessPointPolicyForObjectLambda`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_access_point_policy_for_object_lambda`](crate::client::Client::get_access_point_policy_for_object_lambda).
///
/// See [`crate::client::fluent_builders::GetAccessPointPolicyForObjectLambda`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAccessPointPolicyForObjectLambda {
    _private: (),
}
impl GetAccessPointPolicyForObjectLambda {
    /// Creates a new builder-style object to manufacture [`GetAccessPointPolicyForObjectLambdaInput`](crate::input::GetAccessPointPolicyForObjectLambdaInput)
    pub fn builder() -> crate::input::get_access_point_policy_for_object_lambda_input::Builder {
        crate::input::get_access_point_policy_for_object_lambda_input::Builder::default()
    }
    /// Creates a new `GetAccessPointPolicyForObjectLambda` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAccessPointPolicyForObjectLambda {
    type Output = std::result::Result<
        crate::output::GetAccessPointPolicyForObjectLambdaOutput,
        crate::error::GetAccessPointPolicyForObjectLambdaError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_access_point_policy_for_object_lambda_error(response)
        } else {
            crate::operation_deser::parse_get_access_point_policy_for_object_lambda_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetAccessPointPolicyStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_access_point_policy_status`](crate::client::Client::get_access_point_policy_status).
///
/// See [`crate::client::fluent_builders::GetAccessPointPolicyStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAccessPointPolicyStatus {
    _private: (),
}
impl GetAccessPointPolicyStatus {
    /// Creates a new builder-style object to manufacture [`GetAccessPointPolicyStatusInput`](crate::input::GetAccessPointPolicyStatusInput)
    pub fn builder() -> crate::input::get_access_point_policy_status_input::Builder {
        crate::input::get_access_point_policy_status_input::Builder::default()
    }
    /// Creates a new `GetAccessPointPolicyStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAccessPointPolicyStatus {
    type Output = std::result::Result<
        crate::output::GetAccessPointPolicyStatusOutput,
        crate::error::GetAccessPointPolicyStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_access_point_policy_status_error(response)
        } else {
            crate::operation_deser::parse_get_access_point_policy_status_response(response)
        }
    }
}

/// Operation shape for `GetAccessPointPolicyStatusForObjectLambda`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_access_point_policy_status_for_object_lambda`](crate::client::Client::get_access_point_policy_status_for_object_lambda).
///
/// See [`crate::client::fluent_builders::GetAccessPointPolicyStatusForObjectLambda`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAccessPointPolicyStatusForObjectLambda {
    _private: (),
}
impl GetAccessPointPolicyStatusForObjectLambda {
    /// Creates a new builder-style object to manufacture [`GetAccessPointPolicyStatusForObjectLambdaInput`](crate::input::GetAccessPointPolicyStatusForObjectLambdaInput)
    pub fn builder() -> crate::input::get_access_point_policy_status_for_object_lambda_input::Builder
    {
        crate::input::get_access_point_policy_status_for_object_lambda_input::Builder::default()
    }
    /// Creates a new `GetAccessPointPolicyStatusForObjectLambda` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAccessPointPolicyStatusForObjectLambda {
    type Output = std::result::Result<
        crate::output::GetAccessPointPolicyStatusForObjectLambdaOutput,
        crate::error::GetAccessPointPolicyStatusForObjectLambdaError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_access_point_policy_status_for_object_lambda_error(
                response,
            )
        } else {
            crate::operation_deser::parse_get_access_point_policy_status_for_object_lambda_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetBucket`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bucket`](crate::client::Client::get_bucket).
///
/// See [`crate::client::fluent_builders::GetBucket`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBucket {
    _private: (),
}
impl GetBucket {
    /// Creates a new builder-style object to manufacture [`GetBucketInput`](crate::input::GetBucketInput)
    pub fn builder() -> crate::input::get_bucket_input::Builder {
        crate::input::get_bucket_input::Builder::default()
    }
    /// Creates a new `GetBucket` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBucket {
    type Output = std::result::Result<crate::output::GetBucketOutput, crate::error::GetBucketError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bucket_error(response)
        } else {
            crate::operation_deser::parse_get_bucket_response(response)
        }
    }
}

/// Operation shape for `GetBucketLifecycleConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bucket_lifecycle_configuration`](crate::client::Client::get_bucket_lifecycle_configuration).
///
/// See [`crate::client::fluent_builders::GetBucketLifecycleConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBucketLifecycleConfiguration {
    _private: (),
}
impl GetBucketLifecycleConfiguration {
    /// Creates a new builder-style object to manufacture [`GetBucketLifecycleConfigurationInput`](crate::input::GetBucketLifecycleConfigurationInput)
    pub fn builder() -> crate::input::get_bucket_lifecycle_configuration_input::Builder {
        crate::input::get_bucket_lifecycle_configuration_input::Builder::default()
    }
    /// Creates a new `GetBucketLifecycleConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBucketLifecycleConfiguration {
    type Output = std::result::Result<
        crate::output::GetBucketLifecycleConfigurationOutput,
        crate::error::GetBucketLifecycleConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bucket_lifecycle_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_bucket_lifecycle_configuration_response(response)
        }
    }
}

/// Operation shape for `GetBucketPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bucket_policy`](crate::client::Client::get_bucket_policy).
///
/// See [`crate::client::fluent_builders::GetBucketPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBucketPolicy {
    _private: (),
}
impl GetBucketPolicy {
    /// Creates a new builder-style object to manufacture [`GetBucketPolicyInput`](crate::input::GetBucketPolicyInput)
    pub fn builder() -> crate::input::get_bucket_policy_input::Builder {
        crate::input::get_bucket_policy_input::Builder::default()
    }
    /// Creates a new `GetBucketPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBucketPolicy {
    type Output = std::result::Result<
        crate::output::GetBucketPolicyOutput,
        crate::error::GetBucketPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bucket_policy_error(response)
        } else {
            crate::operation_deser::parse_get_bucket_policy_response(response)
        }
    }
}

/// Operation shape for `GetBucketTagging`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bucket_tagging`](crate::client::Client::get_bucket_tagging).
///
/// See [`crate::client::fluent_builders::GetBucketTagging`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBucketTagging {
    _private: (),
}
impl GetBucketTagging {
    /// Creates a new builder-style object to manufacture [`GetBucketTaggingInput`](crate::input::GetBucketTaggingInput)
    pub fn builder() -> crate::input::get_bucket_tagging_input::Builder {
        crate::input::get_bucket_tagging_input::Builder::default()
    }
    /// Creates a new `GetBucketTagging` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBucketTagging {
    type Output = std::result::Result<
        crate::output::GetBucketTaggingOutput,
        crate::error::GetBucketTaggingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bucket_tagging_error(response)
        } else {
            crate::operation_deser::parse_get_bucket_tagging_response(response)
        }
    }
}

/// Operation shape for `GetJobTagging`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_job_tagging`](crate::client::Client::get_job_tagging).
///
/// See [`crate::client::fluent_builders::GetJobTagging`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetJobTagging {
    _private: (),
}
impl GetJobTagging {
    /// Creates a new builder-style object to manufacture [`GetJobTaggingInput`](crate::input::GetJobTaggingInput)
    pub fn builder() -> crate::input::get_job_tagging_input::Builder {
        crate::input::get_job_tagging_input::Builder::default()
    }
    /// Creates a new `GetJobTagging` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetJobTagging {
    type Output =
        std::result::Result<crate::output::GetJobTaggingOutput, crate::error::GetJobTaggingError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_job_tagging_error(response)
        } else {
            crate::operation_deser::parse_get_job_tagging_response(response)
        }
    }
}

/// Operation shape for `GetMultiRegionAccessPoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_multi_region_access_point`](crate::client::Client::get_multi_region_access_point).
///
/// See [`crate::client::fluent_builders::GetMultiRegionAccessPoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMultiRegionAccessPoint {
    _private: (),
}
impl GetMultiRegionAccessPoint {
    /// Creates a new builder-style object to manufacture [`GetMultiRegionAccessPointInput`](crate::input::GetMultiRegionAccessPointInput)
    pub fn builder() -> crate::input::get_multi_region_access_point_input::Builder {
        crate::input::get_multi_region_access_point_input::Builder::default()
    }
    /// Creates a new `GetMultiRegionAccessPoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMultiRegionAccessPoint {
    type Output = std::result::Result<
        crate::output::GetMultiRegionAccessPointOutput,
        crate::error::GetMultiRegionAccessPointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_multi_region_access_point_error(response)
        } else {
            crate::operation_deser::parse_get_multi_region_access_point_response(response)
        }
    }
}

/// Operation shape for `GetMultiRegionAccessPointPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_multi_region_access_point_policy`](crate::client::Client::get_multi_region_access_point_policy).
///
/// See [`crate::client::fluent_builders::GetMultiRegionAccessPointPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMultiRegionAccessPointPolicy {
    _private: (),
}
impl GetMultiRegionAccessPointPolicy {
    /// Creates a new builder-style object to manufacture [`GetMultiRegionAccessPointPolicyInput`](crate::input::GetMultiRegionAccessPointPolicyInput)
    pub fn builder() -> crate::input::get_multi_region_access_point_policy_input::Builder {
        crate::input::get_multi_region_access_point_policy_input::Builder::default()
    }
    /// Creates a new `GetMultiRegionAccessPointPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMultiRegionAccessPointPolicy {
    type Output = std::result::Result<
        crate::output::GetMultiRegionAccessPointPolicyOutput,
        crate::error::GetMultiRegionAccessPointPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_multi_region_access_point_policy_error(response)
        } else {
            crate::operation_deser::parse_get_multi_region_access_point_policy_response(response)
        }
    }
}

/// Operation shape for `GetMultiRegionAccessPointPolicyStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_multi_region_access_point_policy_status`](crate::client::Client::get_multi_region_access_point_policy_status).
///
/// See [`crate::client::fluent_builders::GetMultiRegionAccessPointPolicyStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMultiRegionAccessPointPolicyStatus {
    _private: (),
}
impl GetMultiRegionAccessPointPolicyStatus {
    /// Creates a new builder-style object to manufacture [`GetMultiRegionAccessPointPolicyStatusInput`](crate::input::GetMultiRegionAccessPointPolicyStatusInput)
    pub fn builder() -> crate::input::get_multi_region_access_point_policy_status_input::Builder {
        crate::input::get_multi_region_access_point_policy_status_input::Builder::default()
    }
    /// Creates a new `GetMultiRegionAccessPointPolicyStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMultiRegionAccessPointPolicyStatus {
    type Output = std::result::Result<
        crate::output::GetMultiRegionAccessPointPolicyStatusOutput,
        crate::error::GetMultiRegionAccessPointPolicyStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_multi_region_access_point_policy_status_error(
                response,
            )
        } else {
            crate::operation_deser::parse_get_multi_region_access_point_policy_status_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetPublicAccessBlock`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_public_access_block`](crate::client::Client::get_public_access_block).
///
/// See [`crate::client::fluent_builders::GetPublicAccessBlock`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPublicAccessBlock {
    _private: (),
}
impl GetPublicAccessBlock {
    /// Creates a new builder-style object to manufacture [`GetPublicAccessBlockInput`](crate::input::GetPublicAccessBlockInput)
    pub fn builder() -> crate::input::get_public_access_block_input::Builder {
        crate::input::get_public_access_block_input::Builder::default()
    }
    /// Creates a new `GetPublicAccessBlock` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPublicAccessBlock {
    type Output = std::result::Result<
        crate::output::GetPublicAccessBlockOutput,
        crate::error::GetPublicAccessBlockError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_public_access_block_error(response)
        } else {
            crate::operation_deser::parse_get_public_access_block_response(response)
        }
    }
}

/// Operation shape for `GetStorageLensConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_storage_lens_configuration`](crate::client::Client::get_storage_lens_configuration).
///
/// See [`crate::client::fluent_builders::GetStorageLensConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetStorageLensConfiguration {
    _private: (),
}
impl GetStorageLensConfiguration {
    /// Creates a new builder-style object to manufacture [`GetStorageLensConfigurationInput`](crate::input::GetStorageLensConfigurationInput)
    pub fn builder() -> crate::input::get_storage_lens_configuration_input::Builder {
        crate::input::get_storage_lens_configuration_input::Builder::default()
    }
    /// Creates a new `GetStorageLensConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetStorageLensConfiguration {
    type Output = std::result::Result<
        crate::output::GetStorageLensConfigurationOutput,
        crate::error::GetStorageLensConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_storage_lens_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_storage_lens_configuration_response(response)
        }
    }
}

/// Operation shape for `GetStorageLensConfigurationTagging`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_storage_lens_configuration_tagging`](crate::client::Client::get_storage_lens_configuration_tagging).
///
/// See [`crate::client::fluent_builders::GetStorageLensConfigurationTagging`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetStorageLensConfigurationTagging {
    _private: (),
}
impl GetStorageLensConfigurationTagging {
    /// Creates a new builder-style object to manufacture [`GetStorageLensConfigurationTaggingInput`](crate::input::GetStorageLensConfigurationTaggingInput)
    pub fn builder() -> crate::input::get_storage_lens_configuration_tagging_input::Builder {
        crate::input::get_storage_lens_configuration_tagging_input::Builder::default()
    }
    /// Creates a new `GetStorageLensConfigurationTagging` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetStorageLensConfigurationTagging {
    type Output = std::result::Result<
        crate::output::GetStorageLensConfigurationTaggingOutput,
        crate::error::GetStorageLensConfigurationTaggingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_storage_lens_configuration_tagging_error(response)
        } else {
            crate::operation_deser::parse_get_storage_lens_configuration_tagging_response(response)
        }
    }
}

/// Operation shape for `ListAccessPoints`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_access_points`](crate::client::Client::list_access_points).
///
/// See [`crate::client::fluent_builders::ListAccessPoints`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAccessPoints {
    _private: (),
}
impl ListAccessPoints {
    /// Creates a new builder-style object to manufacture [`ListAccessPointsInput`](crate::input::ListAccessPointsInput)
    pub fn builder() -> crate::input::list_access_points_input::Builder {
        crate::input::list_access_points_input::Builder::default()
    }
    /// Creates a new `ListAccessPoints` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAccessPoints {
    type Output = std::result::Result<
        crate::output::ListAccessPointsOutput,
        crate::error::ListAccessPointsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_access_points_error(response)
        } else {
            crate::operation_deser::parse_list_access_points_response(response)
        }
    }
}

/// Operation shape for `ListAccessPointsForObjectLambda`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_access_points_for_object_lambda`](crate::client::Client::list_access_points_for_object_lambda).
///
/// See [`crate::client::fluent_builders::ListAccessPointsForObjectLambda`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAccessPointsForObjectLambda {
    _private: (),
}
impl ListAccessPointsForObjectLambda {
    /// Creates a new builder-style object to manufacture [`ListAccessPointsForObjectLambdaInput`](crate::input::ListAccessPointsForObjectLambdaInput)
    pub fn builder() -> crate::input::list_access_points_for_object_lambda_input::Builder {
        crate::input::list_access_points_for_object_lambda_input::Builder::default()
    }
    /// Creates a new `ListAccessPointsForObjectLambda` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAccessPointsForObjectLambda {
    type Output = std::result::Result<
        crate::output::ListAccessPointsForObjectLambdaOutput,
        crate::error::ListAccessPointsForObjectLambdaError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_access_points_for_object_lambda_error(response)
        } else {
            crate::operation_deser::parse_list_access_points_for_object_lambda_response(response)
        }
    }
}

/// Operation shape for `ListJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_jobs`](crate::client::Client::list_jobs).
///
/// See [`crate::client::fluent_builders::ListJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListJobs {
    _private: (),
}
impl ListJobs {
    /// Creates a new builder-style object to manufacture [`ListJobsInput`](crate::input::ListJobsInput)
    pub fn builder() -> crate::input::list_jobs_input::Builder {
        crate::input::list_jobs_input::Builder::default()
    }
    /// Creates a new `ListJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListJobs {
    type Output = std::result::Result<crate::output::ListJobsOutput, crate::error::ListJobsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_jobs_response(response)
        }
    }
}

/// Operation shape for `ListMultiRegionAccessPoints`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_multi_region_access_points`](crate::client::Client::list_multi_region_access_points).
///
/// See [`crate::client::fluent_builders::ListMultiRegionAccessPoints`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMultiRegionAccessPoints {
    _private: (),
}
impl ListMultiRegionAccessPoints {
    /// Creates a new builder-style object to manufacture [`ListMultiRegionAccessPointsInput`](crate::input::ListMultiRegionAccessPointsInput)
    pub fn builder() -> crate::input::list_multi_region_access_points_input::Builder {
        crate::input::list_multi_region_access_points_input::Builder::default()
    }
    /// Creates a new `ListMultiRegionAccessPoints` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMultiRegionAccessPoints {
    type Output = std::result::Result<
        crate::output::ListMultiRegionAccessPointsOutput,
        crate::error::ListMultiRegionAccessPointsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_multi_region_access_points_error(response)
        } else {
            crate::operation_deser::parse_list_multi_region_access_points_response(response)
        }
    }
}

/// Operation shape for `ListRegionalBuckets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_regional_buckets`](crate::client::Client::list_regional_buckets).
///
/// See [`crate::client::fluent_builders::ListRegionalBuckets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRegionalBuckets {
    _private: (),
}
impl ListRegionalBuckets {
    /// Creates a new builder-style object to manufacture [`ListRegionalBucketsInput`](crate::input::ListRegionalBucketsInput)
    pub fn builder() -> crate::input::list_regional_buckets_input::Builder {
        crate::input::list_regional_buckets_input::Builder::default()
    }
    /// Creates a new `ListRegionalBuckets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRegionalBuckets {
    type Output = std::result::Result<
        crate::output::ListRegionalBucketsOutput,
        crate::error::ListRegionalBucketsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_regional_buckets_error(response)
        } else {
            crate::operation_deser::parse_list_regional_buckets_response(response)
        }
    }
}

/// Operation shape for `ListStorageLensConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_storage_lens_configurations`](crate::client::Client::list_storage_lens_configurations).
///
/// See [`crate::client::fluent_builders::ListStorageLensConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListStorageLensConfigurations {
    _private: (),
}
impl ListStorageLensConfigurations {
    /// Creates a new builder-style object to manufacture [`ListStorageLensConfigurationsInput`](crate::input::ListStorageLensConfigurationsInput)
    pub fn builder() -> crate::input::list_storage_lens_configurations_input::Builder {
        crate::input::list_storage_lens_configurations_input::Builder::default()
    }
    /// Creates a new `ListStorageLensConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListStorageLensConfigurations {
    type Output = std::result::Result<
        crate::output::ListStorageLensConfigurationsOutput,
        crate::error::ListStorageLensConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_storage_lens_configurations_error(response)
        } else {
            crate::operation_deser::parse_list_storage_lens_configurations_response(response)
        }
    }
}

/// Operation shape for `PutAccessPointConfigurationForObjectLambda`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_access_point_configuration_for_object_lambda`](crate::client::Client::put_access_point_configuration_for_object_lambda).
///
/// See [`crate::client::fluent_builders::PutAccessPointConfigurationForObjectLambda`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutAccessPointConfigurationForObjectLambda {
    _private: (),
}
impl PutAccessPointConfigurationForObjectLambda {
    /// Creates a new builder-style object to manufacture [`PutAccessPointConfigurationForObjectLambdaInput`](crate::input::PutAccessPointConfigurationForObjectLambdaInput)
    pub fn builder() -> crate::input::put_access_point_configuration_for_object_lambda_input::Builder
    {
        crate::input::put_access_point_configuration_for_object_lambda_input::Builder::default()
    }
    /// Creates a new `PutAccessPointConfigurationForObjectLambda` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutAccessPointConfigurationForObjectLambda {
    type Output = std::result::Result<
        crate::output::PutAccessPointConfigurationForObjectLambdaOutput,
        crate::error::PutAccessPointConfigurationForObjectLambdaError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_access_point_configuration_for_object_lambda_error(
                response,
            )
        } else {
            crate::operation_deser::parse_put_access_point_configuration_for_object_lambda_response(
                response,
            )
        }
    }
}

/// Operation shape for `PutAccessPointPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_access_point_policy`](crate::client::Client::put_access_point_policy).
///
/// See [`crate::client::fluent_builders::PutAccessPointPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutAccessPointPolicy {
    _private: (),
}
impl PutAccessPointPolicy {
    /// Creates a new builder-style object to manufacture [`PutAccessPointPolicyInput`](crate::input::PutAccessPointPolicyInput)
    pub fn builder() -> crate::input::put_access_point_policy_input::Builder {
        crate::input::put_access_point_policy_input::Builder::default()
    }
    /// Creates a new `PutAccessPointPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutAccessPointPolicy {
    type Output = std::result::Result<
        crate::output::PutAccessPointPolicyOutput,
        crate::error::PutAccessPointPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_access_point_policy_error(response)
        } else {
            crate::operation_deser::parse_put_access_point_policy_response(response)
        }
    }
}

/// Operation shape for `PutAccessPointPolicyForObjectLambda`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_access_point_policy_for_object_lambda`](crate::client::Client::put_access_point_policy_for_object_lambda).
///
/// See [`crate::client::fluent_builders::PutAccessPointPolicyForObjectLambda`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutAccessPointPolicyForObjectLambda {
    _private: (),
}
impl PutAccessPointPolicyForObjectLambda {
    /// Creates a new builder-style object to manufacture [`PutAccessPointPolicyForObjectLambdaInput`](crate::input::PutAccessPointPolicyForObjectLambdaInput)
    pub fn builder() -> crate::input::put_access_point_policy_for_object_lambda_input::Builder {
        crate::input::put_access_point_policy_for_object_lambda_input::Builder::default()
    }
    /// Creates a new `PutAccessPointPolicyForObjectLambda` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutAccessPointPolicyForObjectLambda {
    type Output = std::result::Result<
        crate::output::PutAccessPointPolicyForObjectLambdaOutput,
        crate::error::PutAccessPointPolicyForObjectLambdaError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_access_point_policy_for_object_lambda_error(response)
        } else {
            crate::operation_deser::parse_put_access_point_policy_for_object_lambda_response(
                response,
            )
        }
    }
}

/// Operation shape for `PutBucketLifecycleConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_bucket_lifecycle_configuration`](crate::client::Client::put_bucket_lifecycle_configuration).
///
/// See [`crate::client::fluent_builders::PutBucketLifecycleConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutBucketLifecycleConfiguration {
    _private: (),
}
impl PutBucketLifecycleConfiguration {
    /// Creates a new builder-style object to manufacture [`PutBucketLifecycleConfigurationInput`](crate::input::PutBucketLifecycleConfigurationInput)
    pub fn builder() -> crate::input::put_bucket_lifecycle_configuration_input::Builder {
        crate::input::put_bucket_lifecycle_configuration_input::Builder::default()
    }
    /// Creates a new `PutBucketLifecycleConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutBucketLifecycleConfiguration {
    type Output = std::result::Result<
        crate::output::PutBucketLifecycleConfigurationOutput,
        crate::error::PutBucketLifecycleConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_bucket_lifecycle_configuration_error(response)
        } else {
            crate::operation_deser::parse_put_bucket_lifecycle_configuration_response(response)
        }
    }
}

/// Operation shape for `PutBucketPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_bucket_policy`](crate::client::Client::put_bucket_policy).
///
/// See [`crate::client::fluent_builders::PutBucketPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutBucketPolicy {
    _private: (),
}
impl PutBucketPolicy {
    /// Creates a new builder-style object to manufacture [`PutBucketPolicyInput`](crate::input::PutBucketPolicyInput)
    pub fn builder() -> crate::input::put_bucket_policy_input::Builder {
        crate::input::put_bucket_policy_input::Builder::default()
    }
    /// Creates a new `PutBucketPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutBucketPolicy {
    type Output = std::result::Result<
        crate::output::PutBucketPolicyOutput,
        crate::error::PutBucketPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_bucket_policy_error(response)
        } else {
            crate::operation_deser::parse_put_bucket_policy_response(response)
        }
    }
}

/// Operation shape for `PutBucketTagging`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_bucket_tagging`](crate::client::Client::put_bucket_tagging).
///
/// See [`crate::client::fluent_builders::PutBucketTagging`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutBucketTagging {
    _private: (),
}
impl PutBucketTagging {
    /// Creates a new builder-style object to manufacture [`PutBucketTaggingInput`](crate::input::PutBucketTaggingInput)
    pub fn builder() -> crate::input::put_bucket_tagging_input::Builder {
        crate::input::put_bucket_tagging_input::Builder::default()
    }
    /// Creates a new `PutBucketTagging` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutBucketTagging {
    type Output = std::result::Result<
        crate::output::PutBucketTaggingOutput,
        crate::error::PutBucketTaggingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_bucket_tagging_error(response)
        } else {
            crate::operation_deser::parse_put_bucket_tagging_response(response)
        }
    }
}

/// Operation shape for `PutJobTagging`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_job_tagging`](crate::client::Client::put_job_tagging).
///
/// See [`crate::client::fluent_builders::PutJobTagging`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutJobTagging {
    _private: (),
}
impl PutJobTagging {
    /// Creates a new builder-style object to manufacture [`PutJobTaggingInput`](crate::input::PutJobTaggingInput)
    pub fn builder() -> crate::input::put_job_tagging_input::Builder {
        crate::input::put_job_tagging_input::Builder::default()
    }
    /// Creates a new `PutJobTagging` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutJobTagging {
    type Output =
        std::result::Result<crate::output::PutJobTaggingOutput, crate::error::PutJobTaggingError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_job_tagging_error(response)
        } else {
            crate::operation_deser::parse_put_job_tagging_response(response)
        }
    }
}

/// Operation shape for `PutMultiRegionAccessPointPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_multi_region_access_point_policy`](crate::client::Client::put_multi_region_access_point_policy).
///
/// See [`crate::client::fluent_builders::PutMultiRegionAccessPointPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutMultiRegionAccessPointPolicy {
    _private: (),
}
impl PutMultiRegionAccessPointPolicy {
    /// Creates a new builder-style object to manufacture [`PutMultiRegionAccessPointPolicyInput`](crate::input::PutMultiRegionAccessPointPolicyInput)
    pub fn builder() -> crate::input::put_multi_region_access_point_policy_input::Builder {
        crate::input::put_multi_region_access_point_policy_input::Builder::default()
    }
    /// Creates a new `PutMultiRegionAccessPointPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutMultiRegionAccessPointPolicy {
    type Output = std::result::Result<
        crate::output::PutMultiRegionAccessPointPolicyOutput,
        crate::error::PutMultiRegionAccessPointPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_multi_region_access_point_policy_error(response)
        } else {
            crate::operation_deser::parse_put_multi_region_access_point_policy_response(response)
        }
    }
}

/// Operation shape for `PutPublicAccessBlock`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_public_access_block`](crate::client::Client::put_public_access_block).
///
/// See [`crate::client::fluent_builders::PutPublicAccessBlock`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutPublicAccessBlock {
    _private: (),
}
impl PutPublicAccessBlock {
    /// Creates a new builder-style object to manufacture [`PutPublicAccessBlockInput`](crate::input::PutPublicAccessBlockInput)
    pub fn builder() -> crate::input::put_public_access_block_input::Builder {
        crate::input::put_public_access_block_input::Builder::default()
    }
    /// Creates a new `PutPublicAccessBlock` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutPublicAccessBlock {
    type Output = std::result::Result<
        crate::output::PutPublicAccessBlockOutput,
        crate::error::PutPublicAccessBlockError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_public_access_block_error(response)
        } else {
            crate::operation_deser::parse_put_public_access_block_response(response)
        }
    }
}

/// Operation shape for `PutStorageLensConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_storage_lens_configuration`](crate::client::Client::put_storage_lens_configuration).
///
/// See [`crate::client::fluent_builders::PutStorageLensConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutStorageLensConfiguration {
    _private: (),
}
impl PutStorageLensConfiguration {
    /// Creates a new builder-style object to manufacture [`PutStorageLensConfigurationInput`](crate::input::PutStorageLensConfigurationInput)
    pub fn builder() -> crate::input::put_storage_lens_configuration_input::Builder {
        crate::input::put_storage_lens_configuration_input::Builder::default()
    }
    /// Creates a new `PutStorageLensConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutStorageLensConfiguration {
    type Output = std::result::Result<
        crate::output::PutStorageLensConfigurationOutput,
        crate::error::PutStorageLensConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_storage_lens_configuration_error(response)
        } else {
            crate::operation_deser::parse_put_storage_lens_configuration_response(response)
        }
    }
}

/// Operation shape for `PutStorageLensConfigurationTagging`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_storage_lens_configuration_tagging`](crate::client::Client::put_storage_lens_configuration_tagging).
///
/// See [`crate::client::fluent_builders::PutStorageLensConfigurationTagging`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutStorageLensConfigurationTagging {
    _private: (),
}
impl PutStorageLensConfigurationTagging {
    /// Creates a new builder-style object to manufacture [`PutStorageLensConfigurationTaggingInput`](crate::input::PutStorageLensConfigurationTaggingInput)
    pub fn builder() -> crate::input::put_storage_lens_configuration_tagging_input::Builder {
        crate::input::put_storage_lens_configuration_tagging_input::Builder::default()
    }
    /// Creates a new `PutStorageLensConfigurationTagging` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutStorageLensConfigurationTagging {
    type Output = std::result::Result<
        crate::output::PutStorageLensConfigurationTaggingOutput,
        crate::error::PutStorageLensConfigurationTaggingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_storage_lens_configuration_tagging_error(response)
        } else {
            crate::operation_deser::parse_put_storage_lens_configuration_tagging_response(response)
        }
    }
}

/// Operation shape for `UpdateJobPriority`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_job_priority`](crate::client::Client::update_job_priority).
///
/// See [`crate::client::fluent_builders::UpdateJobPriority`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateJobPriority {
    _private: (),
}
impl UpdateJobPriority {
    /// Creates a new builder-style object to manufacture [`UpdateJobPriorityInput`](crate::input::UpdateJobPriorityInput)
    pub fn builder() -> crate::input::update_job_priority_input::Builder {
        crate::input::update_job_priority_input::Builder::default()
    }
    /// Creates a new `UpdateJobPriority` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateJobPriority {
    type Output = std::result::Result<
        crate::output::UpdateJobPriorityOutput,
        crate::error::UpdateJobPriorityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_job_priority_error(response)
        } else {
            crate::operation_deser::parse_update_job_priority_response(response)
        }
    }
}

/// Operation shape for `UpdateJobStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_job_status`](crate::client::Client::update_job_status).
///
/// See [`crate::client::fluent_builders::UpdateJobStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateJobStatus {
    _private: (),
}
impl UpdateJobStatus {
    /// Creates a new builder-style object to manufacture [`UpdateJobStatusInput`](crate::input::UpdateJobStatusInput)
    pub fn builder() -> crate::input::update_job_status_input::Builder {
        crate::input::update_job_status_input::Builder::default()
    }
    /// Creates a new `UpdateJobStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateJobStatus {
    type Output = std::result::Result<
        crate::output::UpdateJobStatusOutput,
        crate::error::UpdateJobStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_job_status_error(response)
        } else {
            crate::operation_deser::parse_update_job_status_response(response)
        }
    }
}
