// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS S3 Control
///
/// Client for invoking operations on AWS S3 Control. Each operation on AWS S3 Control is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_s3control::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_s3control::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_s3control::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateAccessPoint`](crate::client::fluent_builders::CreateAccessPoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::CreateAccessPoint::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::CreateAccessPoint::set_account_id): <p>The Amazon Web Services account ID for the owner of the bucket for which you want to create an access point.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateAccessPoint::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateAccessPoint::set_name): <p>The name you want to assign to this access point.</p>
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::CreateAccessPoint::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::CreateAccessPoint::set_bucket): <p>The name of the bucket that you want to associate this access point with.</p>  <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>  <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:   <region>    :    <account-id>     :outpost/     <outpost-id>      /bucket/      <my-bucket-name></my-bucket-name>     </outpost-id>    </account-id>   </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    ///   - [`vpc_configuration(VpcConfiguration)`](crate::client::fluent_builders::CreateAccessPoint::vpc_configuration) / [`set_vpc_configuration(Option<VpcConfiguration>)`](crate::client::fluent_builders::CreateAccessPoint::set_vpc_configuration): <p>If you include this field, Amazon S3 restricts access to this access point to requests from the specified virtual private cloud (VPC).</p> <note>   <p>This is required for creating an access point for Amazon S3 on Outposts buckets.</p>  </note>
    ///   - [`public_access_block_configuration(PublicAccessBlockConfiguration)`](crate::client::fluent_builders::CreateAccessPoint::public_access_block_configuration) / [`set_public_access_block_configuration(Option<PublicAccessBlockConfiguration>)`](crate::client::fluent_builders::CreateAccessPoint::set_public_access_block_configuration): <p> The <code>PublicAccessBlock</code> configuration that you want to apply to the access point. </p>
    /// - On success, responds with [`CreateAccessPointOutput`](crate::output::CreateAccessPointOutput) with field(s):
    ///   - [`access_point_arn(Option<String>)`](crate::output::CreateAccessPointOutput::access_point_arn): <p>The ARN of the access point.</p> <note>   <p>This is only supported by Amazon S3 on Outposts.</p>  </note>
    ///   - [`alias(Option<String>)`](crate::output::CreateAccessPointOutput::alias): <p>The name or alias of the access point.</p>
    /// - On failure, responds with [`SdkError<CreateAccessPointError>`](crate::error::CreateAccessPointError)
    pub fn create_access_point(&self) -> fluent_builders::CreateAccessPoint {
        fluent_builders::CreateAccessPoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAccessPointForObjectLambda`](crate::client::fluent_builders::CreateAccessPointForObjectLambda) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::CreateAccessPointForObjectLambda::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::CreateAccessPointForObjectLambda::set_account_id): <p>The Amazon Web Services account ID for owner of the specified Object Lambda Access Point.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateAccessPointForObjectLambda::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateAccessPointForObjectLambda::set_name): <p>The name you want to assign to this Object Lambda Access Point.</p>
    ///   - [`configuration(ObjectLambdaConfiguration)`](crate::client::fluent_builders::CreateAccessPointForObjectLambda::configuration) / [`set_configuration(Option<ObjectLambdaConfiguration>)`](crate::client::fluent_builders::CreateAccessPointForObjectLambda::set_configuration): <p>Object Lambda Access Point configuration as a JSON document.</p>
    /// - On success, responds with [`CreateAccessPointForObjectLambdaOutput`](crate::output::CreateAccessPointForObjectLambdaOutput) with field(s):
    ///   - [`object_lambda_access_point_arn(Option<String>)`](crate::output::CreateAccessPointForObjectLambdaOutput::object_lambda_access_point_arn): <p>Specifies the ARN for the Object Lambda Access Point.</p>
    /// - On failure, responds with [`SdkError<CreateAccessPointForObjectLambdaError>`](crate::error::CreateAccessPointForObjectLambdaError)
    pub fn create_access_point_for_object_lambda(
        &self,
    ) -> fluent_builders::CreateAccessPointForObjectLambda {
        fluent_builders::CreateAccessPointForObjectLambda::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateBucket`](crate::client::fluent_builders::CreateBucket) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`acl(BucketCannedAcl)`](crate::client::fluent_builders::CreateBucket::acl) / [`set_acl(Option<BucketCannedAcl>)`](crate::client::fluent_builders::CreateBucket::set_acl): <p>The canned ACL to apply to the bucket.</p> <note>   <p>This is not supported by Amazon S3 on Outposts buckets.</p>  </note>
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::CreateBucket::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::CreateBucket::set_bucket): <p>The name of the bucket.</p>
    ///   - [`create_bucket_configuration(CreateBucketConfiguration)`](crate::client::fluent_builders::CreateBucket::create_bucket_configuration) / [`set_create_bucket_configuration(Option<CreateBucketConfiguration>)`](crate::client::fluent_builders::CreateBucket::set_create_bucket_configuration): <p>The configuration information for the bucket.</p> <note>   <p>This is not supported by Amazon S3 on Outposts buckets.</p>  </note>
    ///   - [`grant_full_control(impl Into<String>)`](crate::client::fluent_builders::CreateBucket::grant_full_control) / [`set_grant_full_control(Option<String>)`](crate::client::fluent_builders::CreateBucket::set_grant_full_control): <p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p> <note>   <p>This is not supported by Amazon S3 on Outposts buckets.</p>  </note>
    ///   - [`grant_read(impl Into<String>)`](crate::client::fluent_builders::CreateBucket::grant_read) / [`set_grant_read(Option<String>)`](crate::client::fluent_builders::CreateBucket::set_grant_read): <p>Allows grantee to list the objects in the bucket.</p> <note>   <p>This is not supported by Amazon S3 on Outposts buckets.</p>  </note>
    ///   - [`grant_read_acp(impl Into<String>)`](crate::client::fluent_builders::CreateBucket::grant_read_acp) / [`set_grant_read_acp(Option<String>)`](crate::client::fluent_builders::CreateBucket::set_grant_read_acp): <p>Allows grantee to read the bucket ACL.</p> <note>   <p>This is not supported by Amazon S3 on Outposts buckets.</p>  </note>
    ///   - [`grant_write(impl Into<String>)`](crate::client::fluent_builders::CreateBucket::grant_write) / [`set_grant_write(Option<String>)`](crate::client::fluent_builders::CreateBucket::set_grant_write): <p>Allows grantee to create, overwrite, and delete any object in the bucket.</p> <note>   <p>This is not supported by Amazon S3 on Outposts buckets.</p>  </note>
    ///   - [`grant_write_acp(impl Into<String>)`](crate::client::fluent_builders::CreateBucket::grant_write_acp) / [`set_grant_write_acp(Option<String>)`](crate::client::fluent_builders::CreateBucket::set_grant_write_acp): <p>Allows grantee to write the ACL for the applicable bucket.</p> <note>   <p>This is not supported by Amazon S3 on Outposts buckets.</p>  </note>
    ///   - [`object_lock_enabled_for_bucket(bool)`](crate::client::fluent_builders::CreateBucket::object_lock_enabled_for_bucket) / [`set_object_lock_enabled_for_bucket(bool)`](crate::client::fluent_builders::CreateBucket::set_object_lock_enabled_for_bucket): <p>Specifies whether you want S3 Object Lock to be enabled for the new bucket.</p> <note>   <p>This is not supported by Amazon S3 on Outposts buckets.</p>  </note>
    ///   - [`outpost_id(impl Into<String>)`](crate::client::fluent_builders::CreateBucket::outpost_id) / [`set_outpost_id(Option<String>)`](crate::client::fluent_builders::CreateBucket::set_outpost_id): <p>The ID of the Outposts where the bucket is being created.</p> <note>   <p>This is required by Amazon S3 on Outposts buckets.</p>  </note>
    /// - On success, responds with [`CreateBucketOutput`](crate::output::CreateBucketOutput) with field(s):
    ///   - [`location(Option<String>)`](crate::output::CreateBucketOutput::location): <p>The location of the bucket.</p>
    ///   - [`bucket_arn(Option<String>)`](crate::output::CreateBucketOutput::bucket_arn): <p>The Amazon Resource Name (ARN) of the bucket.</p>  <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>  <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:   <region>    :    <account-id>     :outpost/     <outpost-id>      /bucket/      <my-bucket-name></my-bucket-name>     </outpost-id>    </account-id>   </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    /// - On failure, responds with [`SdkError<CreateBucketError>`](crate::error::CreateBucketError)
    pub fn create_bucket(&self) -> fluent_builders::CreateBucket {
        fluent_builders::CreateBucket::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateJob`](crate::client::fluent_builders::CreateJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::CreateJob::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::CreateJob::set_account_id): <p>The Amazon Web Services account ID that creates the job.</p>
    ///   - [`confirmation_required(bool)`](crate::client::fluent_builders::CreateJob::confirmation_required) / [`set_confirmation_required(Option<bool>)`](crate::client::fluent_builders::CreateJob::set_confirmation_required): <p>Indicates whether confirmation is required before Amazon S3 runs the job. Confirmation is only required for jobs created through the Amazon S3 console.</p>
    ///   - [`operation(JobOperation)`](crate::client::fluent_builders::CreateJob::operation) / [`set_operation(Option<JobOperation>)`](crate::client::fluent_builders::CreateJob::set_operation): <p>The action that you want this job to perform on every object listed in the manifest. For more information about the available actions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-actions.html">Operations</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`report(JobReport)`](crate::client::fluent_builders::CreateJob::report) / [`set_report(Option<JobReport>)`](crate::client::fluent_builders::CreateJob::set_report): <p>Configuration parameters for the optional job-completion report.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateJob::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateJob::set_client_request_token): <p>An idempotency token to ensure that you don't accidentally submit the same request twice. You can use any string up to the maximum length.</p>
    ///   - [`manifest(JobManifest)`](crate::client::fluent_builders::CreateJob::manifest) / [`set_manifest(Option<JobManifest>)`](crate::client::fluent_builders::CreateJob::set_manifest): <p>Configuration parameters for the manifest.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateJob::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateJob::set_description): <p>A description for this job. You can use any string within the permitted length. Descriptions don't need to be unique and can be used for multiple jobs.</p>
    ///   - [`priority(i32)`](crate::client::fluent_builders::CreateJob::priority) / [`set_priority(Option<i32>)`](crate::client::fluent_builders::CreateJob::set_priority): <p>The numerical priority for this job. Higher numbers indicate higher priority.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateJob::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::CreateJob::set_role_arn): <p>The Amazon Resource Name (ARN) for the Identity and Access Management (IAM) role that Batch Operations will use to run this job's action on every object in the manifest.</p>
    ///   - [`tags(Vec<S3Tag>)`](crate::client::fluent_builders::CreateJob::tags) / [`set_tags(Option<Vec<S3Tag>>)`](crate::client::fluent_builders::CreateJob::set_tags): <p>A set of tags to associate with the S3 Batch Operations job. This is an optional parameter. </p>
    ///   - [`manifest_generator(JobManifestGenerator)`](crate::client::fluent_builders::CreateJob::manifest_generator) / [`set_manifest_generator(Option<JobManifestGenerator>)`](crate::client::fluent_builders::CreateJob::set_manifest_generator): <p>The attribute container for the ManifestGenerator details. Jobs must be created with either a manifest file or a ManifestGenerator, but not both.</p>
    /// - On success, responds with [`CreateJobOutput`](crate::output::CreateJobOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::CreateJobOutput::job_id): <p>The ID for this job. Amazon S3 generates this ID automatically and returns it after a successful <code>Create Job</code> request.</p>
    /// - On failure, responds with [`SdkError<CreateJobError>`](crate::error::CreateJobError)
    pub fn create_job(&self) -> fluent_builders::CreateJob {
        fluent_builders::CreateJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateMultiRegionAccessPoint`](crate::client::fluent_builders::CreateMultiRegionAccessPoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::CreateMultiRegionAccessPoint::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::CreateMultiRegionAccessPoint::set_account_id): <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point. The owner of the Multi-Region Access Point also must own the underlying buckets.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateMultiRegionAccessPoint::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateMultiRegionAccessPoint::set_client_token): <p>An idempotency token used to identify the request and guarantee that requests are unique.</p>
    ///   - [`details(CreateMultiRegionAccessPointInput)`](crate::client::fluent_builders::CreateMultiRegionAccessPoint::details) / [`set_details(Option<CreateMultiRegionAccessPointInput>)`](crate::client::fluent_builders::CreateMultiRegionAccessPoint::set_details): <p>A container element containing details about the Multi-Region Access Point.</p>
    /// - On success, responds with [`CreateMultiRegionAccessPointOutput`](crate::output::CreateMultiRegionAccessPointOutput) with field(s):
    ///   - [`request_token_arn(Option<String>)`](crate::output::CreateMultiRegionAccessPointOutput::request_token_arn): <p>The request token associated with the request. You can use this token with <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> to determine the status of asynchronous requests.</p>
    /// - On failure, responds with [`SdkError<CreateMultiRegionAccessPointError>`](crate::error::CreateMultiRegionAccessPointError)
    pub fn create_multi_region_access_point(
        &self,
    ) -> fluent_builders::CreateMultiRegionAccessPoint {
        fluent_builders::CreateMultiRegionAccessPoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAccessPoint`](crate::client::fluent_builders::DeleteAccessPoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAccessPoint::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DeleteAccessPoint::set_account_id): <p>The account ID for the account that owns the specified access point.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteAccessPoint::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteAccessPoint::set_name): <p>The name of the access point you want to delete.</p>  <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>  <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:   <region>    :    <account-id>     :outpost/     <outpost-id>      /accesspoint/      <my-accesspoint-name></my-accesspoint-name>     </outpost-id>    </account-id>   </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
    /// - On success, responds with [`DeleteAccessPointOutput`](crate::output::DeleteAccessPointOutput)

    /// - On failure, responds with [`SdkError<DeleteAccessPointError>`](crate::error::DeleteAccessPointError)
    pub fn delete_access_point(&self) -> fluent_builders::DeleteAccessPoint {
        fluent_builders::DeleteAccessPoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAccessPointForObjectLambda`](crate::client::fluent_builders::DeleteAccessPointForObjectLambda) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAccessPointForObjectLambda::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DeleteAccessPointForObjectLambda::set_account_id): <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteAccessPointForObjectLambda::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteAccessPointForObjectLambda::set_name): <p>The name of the access point you want to delete.</p>
    /// - On success, responds with [`DeleteAccessPointForObjectLambdaOutput`](crate::output::DeleteAccessPointForObjectLambdaOutput)

    /// - On failure, responds with [`SdkError<DeleteAccessPointForObjectLambdaError>`](crate::error::DeleteAccessPointForObjectLambdaError)
    pub fn delete_access_point_for_object_lambda(
        &self,
    ) -> fluent_builders::DeleteAccessPointForObjectLambda {
        fluent_builders::DeleteAccessPointForObjectLambda::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAccessPointPolicy`](crate::client::fluent_builders::DeleteAccessPointPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAccessPointPolicy::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DeleteAccessPointPolicy::set_account_id): <p>The account ID for the account that owns the specified access point.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteAccessPointPolicy::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteAccessPointPolicy::set_name): <p>The name of the access point whose policy you want to delete.</p>  <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>  <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:   <region>    :    <account-id>     :outpost/     <outpost-id>      /accesspoint/      <my-accesspoint-name></my-accesspoint-name>     </outpost-id>    </account-id>   </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
    /// - On success, responds with [`DeleteAccessPointPolicyOutput`](crate::output::DeleteAccessPointPolicyOutput)

    /// - On failure, responds with [`SdkError<DeleteAccessPointPolicyError>`](crate::error::DeleteAccessPointPolicyError)
    pub fn delete_access_point_policy(&self) -> fluent_builders::DeleteAccessPointPolicy {
        fluent_builders::DeleteAccessPointPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAccessPointPolicyForObjectLambda`](crate::client::fluent_builders::DeleteAccessPointPolicyForObjectLambda) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAccessPointPolicyForObjectLambda::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DeleteAccessPointPolicyForObjectLambda::set_account_id): <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteAccessPointPolicyForObjectLambda::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteAccessPointPolicyForObjectLambda::set_name): <p>The name of the Object Lambda Access Point you want to delete the policy for.</p>
    /// - On success, responds with [`DeleteAccessPointPolicyForObjectLambdaOutput`](crate::output::DeleteAccessPointPolicyForObjectLambdaOutput)

    /// - On failure, responds with [`SdkError<DeleteAccessPointPolicyForObjectLambdaError>`](crate::error::DeleteAccessPointPolicyForObjectLambdaError)
    pub fn delete_access_point_policy_for_object_lambda(
        &self,
    ) -> fluent_builders::DeleteAccessPointPolicyForObjectLambda {
        fluent_builders::DeleteAccessPointPolicyForObjectLambda::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBucket`](crate::client::fluent_builders::DeleteBucket) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteBucket::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DeleteBucket::set_account_id): <p>The account ID that owns the Outposts bucket.</p>
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::DeleteBucket::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::DeleteBucket::set_bucket): <p>Specifies the bucket being deleted.</p>  <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>  <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:   <region>    :    <account-id>     :outpost/     <outpost-id>      /bucket/      <my-bucket-name></my-bucket-name>     </outpost-id>    </account-id>   </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    /// - On success, responds with [`DeleteBucketOutput`](crate::output::DeleteBucketOutput)

    /// - On failure, responds with [`SdkError<DeleteBucketError>`](crate::error::DeleteBucketError)
    pub fn delete_bucket(&self) -> fluent_builders::DeleteBucket {
        fluent_builders::DeleteBucket::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBucketLifecycleConfiguration`](crate::client::fluent_builders::DeleteBucketLifecycleConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketLifecycleConfiguration::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DeleteBucketLifecycleConfiguration::set_account_id): <p>The account ID of the lifecycle configuration to delete.</p>
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketLifecycleConfiguration::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::DeleteBucketLifecycleConfiguration::set_bucket): <p>Specifies the bucket.</p>  <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>  <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:   <region>    :    <account-id>     :outpost/     <outpost-id>      /bucket/      <my-bucket-name></my-bucket-name>     </outpost-id>    </account-id>   </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    /// - On success, responds with [`DeleteBucketLifecycleConfigurationOutput`](crate::output::DeleteBucketLifecycleConfigurationOutput)

    /// - On failure, responds with [`SdkError<DeleteBucketLifecycleConfigurationError>`](crate::error::DeleteBucketLifecycleConfigurationError)
    pub fn delete_bucket_lifecycle_configuration(
        &self,
    ) -> fluent_builders::DeleteBucketLifecycleConfiguration {
        fluent_builders::DeleteBucketLifecycleConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBucketPolicy`](crate::client::fluent_builders::DeleteBucketPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketPolicy::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DeleteBucketPolicy::set_account_id): <p>The account ID of the Outposts bucket.</p>
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketPolicy::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::DeleteBucketPolicy::set_bucket): <p>Specifies the bucket.</p>  <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>  <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:   <region>    :    <account-id>     :outpost/     <outpost-id>      /bucket/      <my-bucket-name></my-bucket-name>     </outpost-id>    </account-id>   </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    /// - On success, responds with [`DeleteBucketPolicyOutput`](crate::output::DeleteBucketPolicyOutput)

    /// - On failure, responds with [`SdkError<DeleteBucketPolicyError>`](crate::error::DeleteBucketPolicyError)
    pub fn delete_bucket_policy(&self) -> fluent_builders::DeleteBucketPolicy {
        fluent_builders::DeleteBucketPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBucketTagging`](crate::client::fluent_builders::DeleteBucketTagging) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketTagging::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DeleteBucketTagging::set_account_id): <p>The Amazon Web Services account ID of the Outposts bucket tag set to be removed.</p>
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketTagging::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::DeleteBucketTagging::set_bucket): <p>The bucket ARN that has the tag set to be removed.</p>  <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>  <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:   <region>    :    <account-id>     :outpost/     <outpost-id>      /bucket/      <my-bucket-name></my-bucket-name>     </outpost-id>    </account-id>   </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    /// - On success, responds with [`DeleteBucketTaggingOutput`](crate::output::DeleteBucketTaggingOutput)

    /// - On failure, responds with [`SdkError<DeleteBucketTaggingError>`](crate::error::DeleteBucketTaggingError)
    pub fn delete_bucket_tagging(&self) -> fluent_builders::DeleteBucketTagging {
        fluent_builders::DeleteBucketTagging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteJobTagging`](crate::client::fluent_builders::DeleteJobTagging) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteJobTagging::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DeleteJobTagging::set_account_id): <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DeleteJobTagging::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DeleteJobTagging::set_job_id): <p>The ID for the S3 Batch Operations job whose tags you want to delete.</p>
    /// - On success, responds with [`DeleteJobTaggingOutput`](crate::output::DeleteJobTaggingOutput)

    /// - On failure, responds with [`SdkError<DeleteJobTaggingError>`](crate::error::DeleteJobTaggingError)
    pub fn delete_job_tagging(&self) -> fluent_builders::DeleteJobTagging {
        fluent_builders::DeleteJobTagging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteMultiRegionAccessPoint`](crate::client::fluent_builders::DeleteMultiRegionAccessPoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteMultiRegionAccessPoint::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DeleteMultiRegionAccessPoint::set_account_id): <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeleteMultiRegionAccessPoint::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeleteMultiRegionAccessPoint::set_client_token): <p>An idempotency token used to identify the request and guarantee that requests are unique.</p>
    ///   - [`details(DeleteMultiRegionAccessPointInput)`](crate::client::fluent_builders::DeleteMultiRegionAccessPoint::details) / [`set_details(Option<DeleteMultiRegionAccessPointInput>)`](crate::client::fluent_builders::DeleteMultiRegionAccessPoint::set_details): <p>A container element containing details about the Multi-Region Access Point.</p>
    /// - On success, responds with [`DeleteMultiRegionAccessPointOutput`](crate::output::DeleteMultiRegionAccessPointOutput) with field(s):
    ///   - [`request_token_arn(Option<String>)`](crate::output::DeleteMultiRegionAccessPointOutput::request_token_arn): <p>The request token associated with the request. You can use this token with <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> to determine the status of asynchronous requests.</p>
    /// - On failure, responds with [`SdkError<DeleteMultiRegionAccessPointError>`](crate::error::DeleteMultiRegionAccessPointError)
    pub fn delete_multi_region_access_point(
        &self,
    ) -> fluent_builders::DeleteMultiRegionAccessPoint {
        fluent_builders::DeleteMultiRegionAccessPoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePublicAccessBlock`](crate::client::fluent_builders::DeletePublicAccessBlock) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DeletePublicAccessBlock::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DeletePublicAccessBlock::set_account_id): <p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want to remove.</p>
    /// - On success, responds with [`DeletePublicAccessBlockOutput`](crate::output::DeletePublicAccessBlockOutput)

    /// - On failure, responds with [`SdkError<DeletePublicAccessBlockError>`](crate::error::DeletePublicAccessBlockError)
    pub fn delete_public_access_block(&self) -> fluent_builders::DeletePublicAccessBlock {
        fluent_builders::DeletePublicAccessBlock::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteStorageLensConfiguration`](crate::client::fluent_builders::DeleteStorageLensConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`config_id(impl Into<String>)`](crate::client::fluent_builders::DeleteStorageLensConfiguration::config_id) / [`set_config_id(Option<String>)`](crate::client::fluent_builders::DeleteStorageLensConfiguration::set_config_id): <p>The ID of the S3 Storage Lens configuration.</p>
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteStorageLensConfiguration::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DeleteStorageLensConfiguration::set_account_id): <p>The account ID of the requester.</p>
    /// - On success, responds with [`DeleteStorageLensConfigurationOutput`](crate::output::DeleteStorageLensConfigurationOutput)

    /// - On failure, responds with [`SdkError<DeleteStorageLensConfigurationError>`](crate::error::DeleteStorageLensConfigurationError)
    pub fn delete_storage_lens_configuration(
        &self,
    ) -> fluent_builders::DeleteStorageLensConfiguration {
        fluent_builders::DeleteStorageLensConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteStorageLensConfigurationTagging`](crate::client::fluent_builders::DeleteStorageLensConfigurationTagging) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`config_id(impl Into<String>)`](crate::client::fluent_builders::DeleteStorageLensConfigurationTagging::config_id) / [`set_config_id(Option<String>)`](crate::client::fluent_builders::DeleteStorageLensConfigurationTagging::set_config_id): <p>The ID of the S3 Storage Lens configuration.</p>
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteStorageLensConfigurationTagging::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DeleteStorageLensConfigurationTagging::set_account_id): <p>The account ID of the requester.</p>
    /// - On success, responds with [`DeleteStorageLensConfigurationTaggingOutput`](crate::output::DeleteStorageLensConfigurationTaggingOutput)

    /// - On failure, responds with [`SdkError<DeleteStorageLensConfigurationTaggingError>`](crate::error::DeleteStorageLensConfigurationTaggingError)
    pub fn delete_storage_lens_configuration_tagging(
        &self,
    ) -> fluent_builders::DeleteStorageLensConfigurationTagging {
        fluent_builders::DeleteStorageLensConfigurationTagging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeJob`](crate::client::fluent_builders::DescribeJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeJob::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DescribeJob::set_account_id): <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DescribeJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DescribeJob::set_job_id): <p>The ID for the job whose information you want to retrieve.</p>
    /// - On success, responds with [`DescribeJobOutput`](crate::output::DescribeJobOutput) with field(s):
    ///   - [`job(Option<JobDescriptor>)`](crate::output::DescribeJobOutput::job): <p>Contains the configuration parameters and status for the job specified in the <code>Describe Job</code> request.</p>
    /// - On failure, responds with [`SdkError<DescribeJobError>`](crate::error::DescribeJobError)
    pub fn describe_job(&self) -> fluent_builders::DescribeJob {
        fluent_builders::DescribeJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeMultiRegionAccessPointOperation`](crate::client::fluent_builders::DescribeMultiRegionAccessPointOperation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DescribeMultiRegionAccessPointOperation::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DescribeMultiRegionAccessPointOperation::set_account_id): <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
    ///   - [`request_token_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeMultiRegionAccessPointOperation::request_token_arn) / [`set_request_token_arn(Option<String>)`](crate::client::fluent_builders::DescribeMultiRegionAccessPointOperation::set_request_token_arn): <p>The request token associated with the request you want to know about. This request token is returned as part of the response when you make an asynchronous request. You provide this token to query about the status of the asynchronous action.</p>
    /// - On success, responds with [`DescribeMultiRegionAccessPointOperationOutput`](crate::output::DescribeMultiRegionAccessPointOperationOutput) with field(s):
    ///   - [`async_operation(Option<AsyncOperation>)`](crate::output::DescribeMultiRegionAccessPointOperationOutput::async_operation): <p>A container element containing the details of the asynchronous operation.</p>
    /// - On failure, responds with [`SdkError<DescribeMultiRegionAccessPointOperationError>`](crate::error::DescribeMultiRegionAccessPointOperationError)
    pub fn describe_multi_region_access_point_operation(
        &self,
    ) -> fluent_builders::DescribeMultiRegionAccessPointOperation {
        fluent_builders::DescribeMultiRegionAccessPointOperation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAccessPoint`](crate::client::fluent_builders::GetAccessPoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetAccessPoint::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetAccessPoint::set_account_id): <p>The account ID for the account that owns the specified access point.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetAccessPoint::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetAccessPoint::set_name): <p>The name of the access point whose configuration information you want to retrieve.</p>  <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>  <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:   <region>    :    <account-id>     :outpost/     <outpost-id>      /accesspoint/      <my-accesspoint-name></my-accesspoint-name>     </outpost-id>    </account-id>   </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
    /// - On success, responds with [`GetAccessPointOutput`](crate::output::GetAccessPointOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::GetAccessPointOutput::name): <p>The name of the specified access point.</p>
    ///   - [`bucket(Option<String>)`](crate::output::GetAccessPointOutput::bucket): <p>The name of the bucket associated with the specified access point.</p>
    ///   - [`network_origin(Option<NetworkOrigin>)`](crate::output::GetAccessPointOutput::network_origin): <p>Indicates whether this access point allows access from the public internet. If <code>VpcConfiguration</code> is specified for this access point, then <code>NetworkOrigin</code> is <code>VPC</code>, and the access point doesn't allow access from the public internet. Otherwise, <code>NetworkOrigin</code> is <code>Internet</code>, and the access point allows access from the public internet, subject to the access point and bucket access policies.</p>  <p>This will always be true for an Amazon S3 on Outposts access point</p>
    ///   - [`vpc_configuration(Option<VpcConfiguration>)`](crate::output::GetAccessPointOutput::vpc_configuration): <p>Contains the virtual private cloud (VPC) configuration for the specified access point.</p> <note>   <p>This element is empty if this access point is an Amazon S3 on Outposts access point that is used by other Amazon Web Services.</p>  </note>
    ///   - [`public_access_block_configuration(Option<PublicAccessBlockConfiguration>)`](crate::output::GetAccessPointOutput::public_access_block_configuration): <p>The <code>PublicAccessBlock</code> configuration that you want to apply to this Amazon S3 account. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <i>Amazon S3 User Guide</i>.</p>  <p>This is not supported for Amazon S3 on Outposts.</p>
    ///   - [`creation_date(Option<DateTime>)`](crate::output::GetAccessPointOutput::creation_date): <p>The date and time when the specified access point was created.</p>
    ///   - [`alias(Option<String>)`](crate::output::GetAccessPointOutput::alias): <p>The name or alias of the access point.</p>
    ///   - [`access_point_arn(Option<String>)`](crate::output::GetAccessPointOutput::access_point_arn): <p>The ARN of the access point.</p>
    ///   - [`endpoints(Option<HashMap<String, String>>)`](crate::output::GetAccessPointOutput::endpoints): <p>The VPC endpoint for the access point.</p>
    /// - On failure, responds with [`SdkError<GetAccessPointError>`](crate::error::GetAccessPointError)
    pub fn get_access_point(&self) -> fluent_builders::GetAccessPoint {
        fluent_builders::GetAccessPoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAccessPointConfigurationForObjectLambda`](crate::client::fluent_builders::GetAccessPointConfigurationForObjectLambda) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetAccessPointConfigurationForObjectLambda::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetAccessPointConfigurationForObjectLambda::set_account_id): <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetAccessPointConfigurationForObjectLambda::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetAccessPointConfigurationForObjectLambda::set_name): <p>The name of the Object Lambda Access Point you want to return the configuration for.</p>
    /// - On success, responds with [`GetAccessPointConfigurationForObjectLambdaOutput`](crate::output::GetAccessPointConfigurationForObjectLambdaOutput) with field(s):
    ///   - [`configuration(Option<ObjectLambdaConfiguration>)`](crate::output::GetAccessPointConfigurationForObjectLambdaOutput::configuration): <p>Object Lambda Access Point configuration document.</p>
    /// - On failure, responds with [`SdkError<GetAccessPointConfigurationForObjectLambdaError>`](crate::error::GetAccessPointConfigurationForObjectLambdaError)
    pub fn get_access_point_configuration_for_object_lambda(
        &self,
    ) -> fluent_builders::GetAccessPointConfigurationForObjectLambda {
        fluent_builders::GetAccessPointConfigurationForObjectLambda::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAccessPointForObjectLambda`](crate::client::fluent_builders::GetAccessPointForObjectLambda) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetAccessPointForObjectLambda::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetAccessPointForObjectLambda::set_account_id): <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetAccessPointForObjectLambda::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetAccessPointForObjectLambda::set_name): <p>The name of the Object Lambda Access Point.</p>
    /// - On success, responds with [`GetAccessPointForObjectLambdaOutput`](crate::output::GetAccessPointForObjectLambdaOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::GetAccessPointForObjectLambdaOutput::name): <p>The name of the Object Lambda Access Point.</p>
    ///   - [`public_access_block_configuration(Option<PublicAccessBlockConfiguration>)`](crate::output::GetAccessPointForObjectLambdaOutput::public_access_block_configuration): <p>Configuration to block all public access. This setting is turned on and can not be edited. </p>
    ///   - [`creation_date(Option<DateTime>)`](crate::output::GetAccessPointForObjectLambdaOutput::creation_date): <p>The date and time when the specified Object Lambda Access Point was created.</p>
    /// - On failure, responds with [`SdkError<GetAccessPointForObjectLambdaError>`](crate::error::GetAccessPointForObjectLambdaError)
    pub fn get_access_point_for_object_lambda(
        &self,
    ) -> fluent_builders::GetAccessPointForObjectLambda {
        fluent_builders::GetAccessPointForObjectLambda::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAccessPointPolicy`](crate::client::fluent_builders::GetAccessPointPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetAccessPointPolicy::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetAccessPointPolicy::set_account_id): <p>The account ID for the account that owns the specified access point.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetAccessPointPolicy::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetAccessPointPolicy::set_name): <p>The name of the access point whose policy you want to retrieve.</p>  <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>  <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:   <region>    :    <account-id>     :outpost/     <outpost-id>      /accesspoint/      <my-accesspoint-name></my-accesspoint-name>     </outpost-id>    </account-id>   </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
    /// - On success, responds with [`GetAccessPointPolicyOutput`](crate::output::GetAccessPointPolicyOutput) with field(s):
    ///   - [`policy(Option<String>)`](crate::output::GetAccessPointPolicyOutput::policy): <p>The access point policy associated with the specified access point.</p>
    /// - On failure, responds with [`SdkError<GetAccessPointPolicyError>`](crate::error::GetAccessPointPolicyError)
    pub fn get_access_point_policy(&self) -> fluent_builders::GetAccessPointPolicy {
        fluent_builders::GetAccessPointPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAccessPointPolicyForObjectLambda`](crate::client::fluent_builders::GetAccessPointPolicyForObjectLambda) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetAccessPointPolicyForObjectLambda::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetAccessPointPolicyForObjectLambda::set_account_id): <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetAccessPointPolicyForObjectLambda::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetAccessPointPolicyForObjectLambda::set_name): <p>The name of the Object Lambda Access Point.</p>
    /// - On success, responds with [`GetAccessPointPolicyForObjectLambdaOutput`](crate::output::GetAccessPointPolicyForObjectLambdaOutput) with field(s):
    ///   - [`policy(Option<String>)`](crate::output::GetAccessPointPolicyForObjectLambdaOutput::policy): <p>Object Lambda Access Point resource policy document.</p>
    /// - On failure, responds with [`SdkError<GetAccessPointPolicyForObjectLambdaError>`](crate::error::GetAccessPointPolicyForObjectLambdaError)
    pub fn get_access_point_policy_for_object_lambda(
        &self,
    ) -> fluent_builders::GetAccessPointPolicyForObjectLambda {
        fluent_builders::GetAccessPointPolicyForObjectLambda::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAccessPointPolicyStatus`](crate::client::fluent_builders::GetAccessPointPolicyStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetAccessPointPolicyStatus::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetAccessPointPolicyStatus::set_account_id): <p>The account ID for the account that owns the specified access point.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetAccessPointPolicyStatus::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetAccessPointPolicyStatus::set_name): <p>The name of the access point whose policy status you want to retrieve.</p>
    /// - On success, responds with [`GetAccessPointPolicyStatusOutput`](crate::output::GetAccessPointPolicyStatusOutput) with field(s):
    ///   - [`policy_status(Option<PolicyStatus>)`](crate::output::GetAccessPointPolicyStatusOutput::policy_status): <p>Indicates the current policy status of the specified access point.</p>
    /// - On failure, responds with [`SdkError<GetAccessPointPolicyStatusError>`](crate::error::GetAccessPointPolicyStatusError)
    pub fn get_access_point_policy_status(&self) -> fluent_builders::GetAccessPointPolicyStatus {
        fluent_builders::GetAccessPointPolicyStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAccessPointPolicyStatusForObjectLambda`](crate::client::fluent_builders::GetAccessPointPolicyStatusForObjectLambda) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetAccessPointPolicyStatusForObjectLambda::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetAccessPointPolicyStatusForObjectLambda::set_account_id): <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetAccessPointPolicyStatusForObjectLambda::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetAccessPointPolicyStatusForObjectLambda::set_name): <p>The name of the Object Lambda Access Point.</p>
    /// - On success, responds with [`GetAccessPointPolicyStatusForObjectLambdaOutput`](crate::output::GetAccessPointPolicyStatusForObjectLambdaOutput) with field(s):
    ///   - [`policy_status(Option<PolicyStatus>)`](crate::output::GetAccessPointPolicyStatusForObjectLambdaOutput::policy_status): <p>Indicates whether this access point policy is public. For more information about how Amazon S3 evaluates policies to determine whether they are public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <i>Amazon S3 User Guide</i>. </p>
    /// - On failure, responds with [`SdkError<GetAccessPointPolicyStatusForObjectLambdaError>`](crate::error::GetAccessPointPolicyStatusForObjectLambdaError)
    pub fn get_access_point_policy_status_for_object_lambda(
        &self,
    ) -> fluent_builders::GetAccessPointPolicyStatusForObjectLambda {
        fluent_builders::GetAccessPointPolicyStatusForObjectLambda::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBucket`](crate::client::fluent_builders::GetBucket) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetBucket::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetBucket::set_account_id): <p>The Amazon Web Services account ID of the Outposts bucket.</p>
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetBucket::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetBucket::set_bucket): <p>Specifies the bucket.</p>  <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>  <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:   <region>    :    <account-id>     :outpost/     <outpost-id>      /bucket/      <my-bucket-name></my-bucket-name>     </outpost-id>    </account-id>   </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    /// - On success, responds with [`GetBucketOutput`](crate::output::GetBucketOutput) with field(s):
    ///   - [`bucket(Option<String>)`](crate::output::GetBucketOutput::bucket): <p>The Outposts bucket requested.</p>
    ///   - [`public_access_block_enabled(bool)`](crate::output::GetBucketOutput::public_access_block_enabled): <p></p>
    ///   - [`creation_date(Option<DateTime>)`](crate::output::GetBucketOutput::creation_date): <p>The creation date of the Outposts bucket.</p>
    /// - On failure, responds with [`SdkError<GetBucketError>`](crate::error::GetBucketError)
    pub fn get_bucket(&self) -> fluent_builders::GetBucket {
        fluent_builders::GetBucket::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBucketLifecycleConfiguration`](crate::client::fluent_builders::GetBucketLifecycleConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetBucketLifecycleConfiguration::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetBucketLifecycleConfiguration::set_account_id): <p>The Amazon Web Services account ID of the Outposts bucket.</p>
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetBucketLifecycleConfiguration::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetBucketLifecycleConfiguration::set_bucket): <p>The Amazon Resource Name (ARN) of the bucket.</p>  <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>  <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:   <region>    :    <account-id>     :outpost/     <outpost-id>      /bucket/      <my-bucket-name></my-bucket-name>     </outpost-id>    </account-id>   </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    /// - On success, responds with [`GetBucketLifecycleConfigurationOutput`](crate::output::GetBucketLifecycleConfigurationOutput) with field(s):
    ///   - [`rules(Option<Vec<LifecycleRule>>)`](crate::output::GetBucketLifecycleConfigurationOutput::rules): <p>Container for the lifecycle rule of the Outposts bucket.</p>
    /// - On failure, responds with [`SdkError<GetBucketLifecycleConfigurationError>`](crate::error::GetBucketLifecycleConfigurationError)
    pub fn get_bucket_lifecycle_configuration(
        &self,
    ) -> fluent_builders::GetBucketLifecycleConfiguration {
        fluent_builders::GetBucketLifecycleConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBucketPolicy`](crate::client::fluent_builders::GetBucketPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetBucketPolicy::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetBucketPolicy::set_account_id): <p>The Amazon Web Services account ID of the Outposts bucket.</p>
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetBucketPolicy::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetBucketPolicy::set_bucket): <p>Specifies the bucket.</p>  <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>  <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:   <region>    :    <account-id>     :outpost/     <outpost-id>      /bucket/      <my-bucket-name></my-bucket-name>     </outpost-id>    </account-id>   </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    /// - On success, responds with [`GetBucketPolicyOutput`](crate::output::GetBucketPolicyOutput) with field(s):
    ///   - [`policy(Option<String>)`](crate::output::GetBucketPolicyOutput::policy): <p>The policy of the Outposts bucket.</p>
    /// - On failure, responds with [`SdkError<GetBucketPolicyError>`](crate::error::GetBucketPolicyError)
    pub fn get_bucket_policy(&self) -> fluent_builders::GetBucketPolicy {
        fluent_builders::GetBucketPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBucketTagging`](crate::client::fluent_builders::GetBucketTagging) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetBucketTagging::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetBucketTagging::set_account_id): <p>The Amazon Web Services account ID of the Outposts bucket.</p>
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetBucketTagging::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetBucketTagging::set_bucket): <p>Specifies the bucket.</p>  <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>  <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:   <region>    :    <account-id>     :outpost/     <outpost-id>      /bucket/      <my-bucket-name></my-bucket-name>     </outpost-id>    </account-id>   </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    /// - On success, responds with [`GetBucketTaggingOutput`](crate::output::GetBucketTaggingOutput) with field(s):
    ///   - [`tag_set(Option<Vec<S3Tag>>)`](crate::output::GetBucketTaggingOutput::tag_set): <p>The tags set of the Outposts bucket.</p>
    /// - On failure, responds with [`SdkError<GetBucketTaggingError>`](crate::error::GetBucketTaggingError)
    pub fn get_bucket_tagging(&self) -> fluent_builders::GetBucketTagging {
        fluent_builders::GetBucketTagging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetJobTagging`](crate::client::fluent_builders::GetJobTagging) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetJobTagging::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetJobTagging::set_account_id): <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::GetJobTagging::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::GetJobTagging::set_job_id): <p>The ID for the S3 Batch Operations job whose tags you want to retrieve.</p>
    /// - On success, responds with [`GetJobTaggingOutput`](crate::output::GetJobTaggingOutput) with field(s):
    ///   - [`tags(Option<Vec<S3Tag>>)`](crate::output::GetJobTaggingOutput::tags): <p>The set of tags associated with the S3 Batch Operations job.</p>
    /// - On failure, responds with [`SdkError<GetJobTaggingError>`](crate::error::GetJobTaggingError)
    pub fn get_job_tagging(&self) -> fluent_builders::GetJobTagging {
        fluent_builders::GetJobTagging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMultiRegionAccessPoint`](crate::client::fluent_builders::GetMultiRegionAccessPoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetMultiRegionAccessPoint::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetMultiRegionAccessPoint::set_account_id): <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetMultiRegionAccessPoint::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetMultiRegionAccessPoint::set_name): <p>The name of the Multi-Region Access Point whose configuration information you want to receive. The name of the Multi-Region Access Point is different from the alias. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// - On success, responds with [`GetMultiRegionAccessPointOutput`](crate::output::GetMultiRegionAccessPointOutput) with field(s):
    ///   - [`access_point(Option<MultiRegionAccessPointReport>)`](crate::output::GetMultiRegionAccessPointOutput::access_point): <p>A container element containing the details of the requested Multi-Region Access Point.</p>
    /// - On failure, responds with [`SdkError<GetMultiRegionAccessPointError>`](crate::error::GetMultiRegionAccessPointError)
    pub fn get_multi_region_access_point(&self) -> fluent_builders::GetMultiRegionAccessPoint {
        fluent_builders::GetMultiRegionAccessPoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMultiRegionAccessPointPolicy`](crate::client::fluent_builders::GetMultiRegionAccessPointPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetMultiRegionAccessPointPolicy::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetMultiRegionAccessPointPolicy::set_account_id): <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetMultiRegionAccessPointPolicy::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetMultiRegionAccessPointPolicy::set_name): <p>Specifies the Multi-Region Access Point. The name of the Multi-Region Access Point is different from the alias. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// - On success, responds with [`GetMultiRegionAccessPointPolicyOutput`](crate::output::GetMultiRegionAccessPointPolicyOutput) with field(s):
    ///   - [`policy(Option<MultiRegionAccessPointPolicyDocument>)`](crate::output::GetMultiRegionAccessPointPolicyOutput::policy): <p>The policy associated with the specified Multi-Region Access Point.</p>
    /// - On failure, responds with [`SdkError<GetMultiRegionAccessPointPolicyError>`](crate::error::GetMultiRegionAccessPointPolicyError)
    pub fn get_multi_region_access_point_policy(
        &self,
    ) -> fluent_builders::GetMultiRegionAccessPointPolicy {
        fluent_builders::GetMultiRegionAccessPointPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMultiRegionAccessPointPolicyStatus`](crate::client::fluent_builders::GetMultiRegionAccessPointPolicyStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetMultiRegionAccessPointPolicyStatus::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetMultiRegionAccessPointPolicyStatus::set_account_id): <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetMultiRegionAccessPointPolicyStatus::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetMultiRegionAccessPointPolicyStatus::set_name): <p>Specifies the Multi-Region Access Point. The name of the Multi-Region Access Point is different from the alias. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// - On success, responds with [`GetMultiRegionAccessPointPolicyStatusOutput`](crate::output::GetMultiRegionAccessPointPolicyStatusOutput) with field(s):
    ///   - [`established(Option<PolicyStatus>)`](crate::output::GetMultiRegionAccessPointPolicyStatusOutput::established): <p>Indicates whether this access point policy is public. For more information about how Amazon S3 evaluates policies to determine whether they are public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <i>Amazon S3 User Guide</i>. </p>
    /// - On failure, responds with [`SdkError<GetMultiRegionAccessPointPolicyStatusError>`](crate::error::GetMultiRegionAccessPointPolicyStatusError)
    pub fn get_multi_region_access_point_policy_status(
        &self,
    ) -> fluent_builders::GetMultiRegionAccessPointPolicyStatus {
        fluent_builders::GetMultiRegionAccessPointPolicyStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPublicAccessBlock`](crate::client::fluent_builders::GetPublicAccessBlock) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetPublicAccessBlock::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetPublicAccessBlock::set_account_id): <p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want to retrieve.</p>
    /// - On success, responds with [`GetPublicAccessBlockOutput`](crate::output::GetPublicAccessBlockOutput) with field(s):
    ///   - [`public_access_block_configuration(Option<PublicAccessBlockConfiguration>)`](crate::output::GetPublicAccessBlockOutput::public_access_block_configuration): <p>The <code>PublicAccessBlock</code> configuration currently in effect for this Amazon Web Services account.</p>
    /// - On failure, responds with [`SdkError<GetPublicAccessBlockError>`](crate::error::GetPublicAccessBlockError)
    pub fn get_public_access_block(&self) -> fluent_builders::GetPublicAccessBlock {
        fluent_builders::GetPublicAccessBlock::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetStorageLensConfiguration`](crate::client::fluent_builders::GetStorageLensConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`config_id(impl Into<String>)`](crate::client::fluent_builders::GetStorageLensConfiguration::config_id) / [`set_config_id(Option<String>)`](crate::client::fluent_builders::GetStorageLensConfiguration::set_config_id): <p>The ID of the Amazon S3 Storage Lens configuration.</p>
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetStorageLensConfiguration::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetStorageLensConfiguration::set_account_id): <p>The account ID of the requester.</p>
    /// - On success, responds with [`GetStorageLensConfigurationOutput`](crate::output::GetStorageLensConfigurationOutput) with field(s):
    ///   - [`storage_lens_configuration(Option<StorageLensConfiguration>)`](crate::output::GetStorageLensConfigurationOutput::storage_lens_configuration): <p>The S3 Storage Lens configuration requested.</p>
    /// - On failure, responds with [`SdkError<GetStorageLensConfigurationError>`](crate::error::GetStorageLensConfigurationError)
    pub fn get_storage_lens_configuration(&self) -> fluent_builders::GetStorageLensConfiguration {
        fluent_builders::GetStorageLensConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetStorageLensConfigurationTagging`](crate::client::fluent_builders::GetStorageLensConfigurationTagging) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`config_id(impl Into<String>)`](crate::client::fluent_builders::GetStorageLensConfigurationTagging::config_id) / [`set_config_id(Option<String>)`](crate::client::fluent_builders::GetStorageLensConfigurationTagging::set_config_id): <p>The ID of the Amazon S3 Storage Lens configuration.</p>
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetStorageLensConfigurationTagging::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetStorageLensConfigurationTagging::set_account_id): <p>The account ID of the requester.</p>
    /// - On success, responds with [`GetStorageLensConfigurationTaggingOutput`](crate::output::GetStorageLensConfigurationTaggingOutput) with field(s):
    ///   - [`tags(Option<Vec<StorageLensTag>>)`](crate::output::GetStorageLensConfigurationTaggingOutput::tags): <p>The tags of S3 Storage Lens configuration requested.</p>
    /// - On failure, responds with [`SdkError<GetStorageLensConfigurationTaggingError>`](crate::error::GetStorageLensConfigurationTaggingError)
    pub fn get_storage_lens_configuration_tagging(
        &self,
    ) -> fluent_builders::GetStorageLensConfigurationTagging {
        fluent_builders::GetStorageLensConfigurationTagging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAccessPoints`](crate::client::fluent_builders::ListAccessPoints) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAccessPoints::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::ListAccessPoints::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::ListAccessPoints::set_account_id): <p>The Amazon Web Services account ID for owner of the bucket whose access points you want to list.</p>
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::ListAccessPoints::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::ListAccessPoints::set_bucket): <p>The name of the bucket whose associated access points you want to list.</p>  <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>  <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:   <region>    :    <account-id>     :outpost/     <outpost-id>      /bucket/      <my-bucket-name></my-bucket-name>     </outpost-id>    </account-id>   </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAccessPoints::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAccessPoints::set_next_token): <p>A continuation token. If a previous call to <code>ListAccessPoints</code> returned a continuation token in the <code>NextToken</code> field, then providing that value here causes Amazon S3 to retrieve the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAccessPoints::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListAccessPoints::set_max_results): <p>The maximum number of access points that you want to include in the list. If the specified bucket has more than this number of access points, then the response will include a continuation token in the <code>NextToken</code> field that you can use to retrieve the next page of access points.</p>
    /// - On success, responds with [`ListAccessPointsOutput`](crate::output::ListAccessPointsOutput) with field(s):
    ///   - [`access_point_list(Option<Vec<AccessPoint>>)`](crate::output::ListAccessPointsOutput::access_point_list): <p>Contains identification and configuration information for one or more access points associated with the specified bucket.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAccessPointsOutput::next_token): <p>If the specified bucket has more access points than can be returned in one call to this API, this field contains a continuation token that you can provide in subsequent calls to this API to retrieve additional access points.</p>
    /// - On failure, responds with [`SdkError<ListAccessPointsError>`](crate::error::ListAccessPointsError)
    pub fn list_access_points(&self) -> fluent_builders::ListAccessPoints {
        fluent_builders::ListAccessPoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAccessPointsForObjectLambda`](crate::client::fluent_builders::ListAccessPointsForObjectLambda) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAccessPointsForObjectLambda::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::ListAccessPointsForObjectLambda::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::ListAccessPointsForObjectLambda::set_account_id): <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAccessPointsForObjectLambda::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAccessPointsForObjectLambda::set_next_token): <p>If the list has more access points than can be returned in one call to this API, this field contains a continuation token that you can provide in subsequent calls to this API to retrieve additional access points.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAccessPointsForObjectLambda::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListAccessPointsForObjectLambda::set_max_results): <p>The maximum number of access points that you want to include in the list. The response may contain fewer access points but will never contain more. If there are more than this number of access points, then the response will include a continuation token in the <code>NextToken</code> field that you can use to retrieve the next page of access points.</p>
    /// - On success, responds with [`ListAccessPointsForObjectLambdaOutput`](crate::output::ListAccessPointsForObjectLambdaOutput) with field(s):
    ///   - [`object_lambda_access_point_list(Option<Vec<ObjectLambdaAccessPoint>>)`](crate::output::ListAccessPointsForObjectLambdaOutput::object_lambda_access_point_list): <p>Returns list of Object Lambda Access Points.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAccessPointsForObjectLambdaOutput::next_token): <p>If the list has more access points than can be returned in one call to this API, this field contains a continuation token that you can provide in subsequent calls to this API to retrieve additional access points.</p>
    /// - On failure, responds with [`SdkError<ListAccessPointsForObjectLambdaError>`](crate::error::ListAccessPointsForObjectLambdaError)
    pub fn list_access_points_for_object_lambda(
        &self,
    ) -> fluent_builders::ListAccessPointsForObjectLambda {
        fluent_builders::ListAccessPointsForObjectLambda::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListJobs`](crate::client::fluent_builders::ListJobs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListJobs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::ListJobs::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::ListJobs::set_account_id): <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
    ///   - [`job_statuses(Vec<JobStatus>)`](crate::client::fluent_builders::ListJobs::job_statuses) / [`set_job_statuses(Option<Vec<JobStatus>>)`](crate::client::fluent_builders::ListJobs::set_job_statuses): <p>The <code>List Jobs</code> request returns jobs that match the statuses listed in this element.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListJobs::set_next_token): <p>A pagination token to request the next page of results. Use the token that Amazon S3 returned in the <code>NextToken</code> element of the <code>ListJobsResult</code> from the previous <code>List Jobs</code> request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListJobs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListJobs::set_max_results): <p>The maximum number of jobs that Amazon S3 will include in the <code>List Jobs</code> response. If there are more jobs than this number, the response will include a pagination token in the <code>NextToken</code> field to enable you to retrieve the next page of results.</p>
    /// - On success, responds with [`ListJobsOutput`](crate::output::ListJobsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListJobsOutput::next_token): <p>If the <code>List Jobs</code> request produced more than the maximum number of results, you can pass this value into a subsequent <code>List Jobs</code> request in order to retrieve the next page of results.</p>
    ///   - [`jobs(Option<Vec<JobListDescriptor>>)`](crate::output::ListJobsOutput::jobs): <p>The list of current jobs and jobs that have ended within the last 30 days.</p>
    /// - On failure, responds with [`SdkError<ListJobsError>`](crate::error::ListJobsError)
    pub fn list_jobs(&self) -> fluent_builders::ListJobs {
        fluent_builders::ListJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListMultiRegionAccessPoints`](crate::client::fluent_builders::ListMultiRegionAccessPoints) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListMultiRegionAccessPoints::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::ListMultiRegionAccessPoints::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::ListMultiRegionAccessPoints::set_account_id): <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListMultiRegionAccessPoints::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListMultiRegionAccessPoints::set_next_token): <p>Not currently used. Do not use this parameter.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListMultiRegionAccessPoints::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListMultiRegionAccessPoints::set_max_results): <p>Not currently used. Do not use this parameter.</p>
    /// - On success, responds with [`ListMultiRegionAccessPointsOutput`](crate::output::ListMultiRegionAccessPointsOutput) with field(s):
    ///   - [`access_points(Option<Vec<MultiRegionAccessPointReport>>)`](crate::output::ListMultiRegionAccessPointsOutput::access_points): <p>The list of Multi-Region Access Points associated with the user.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListMultiRegionAccessPointsOutput::next_token): <p>If the specified bucket has more Multi-Region Access Points than can be returned in one call to this action, this field contains a continuation token. You can use this token tin subsequent calls to this action to retrieve additional Multi-Region Access Points.</p>
    /// - On failure, responds with [`SdkError<ListMultiRegionAccessPointsError>`](crate::error::ListMultiRegionAccessPointsError)
    pub fn list_multi_region_access_points(&self) -> fluent_builders::ListMultiRegionAccessPoints {
        fluent_builders::ListMultiRegionAccessPoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRegionalBuckets`](crate::client::fluent_builders::ListRegionalBuckets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRegionalBuckets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::ListRegionalBuckets::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::ListRegionalBuckets::set_account_id): <p>The Amazon Web Services account ID of the Outposts bucket.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRegionalBuckets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRegionalBuckets::set_next_token): <p></p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListRegionalBuckets::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListRegionalBuckets::set_max_results): <p></p>
    ///   - [`outpost_id(impl Into<String>)`](crate::client::fluent_builders::ListRegionalBuckets::outpost_id) / [`set_outpost_id(Option<String>)`](crate::client::fluent_builders::ListRegionalBuckets::set_outpost_id): <p>The ID of the Outposts.</p> <note>   <p>This is required by Amazon S3 on Outposts buckets.</p>  </note>
    /// - On success, responds with [`ListRegionalBucketsOutput`](crate::output::ListRegionalBucketsOutput) with field(s):
    ///   - [`regional_bucket_list(Option<Vec<RegionalBucket>>)`](crate::output::ListRegionalBucketsOutput::regional_bucket_list): <p></p>
    ///   - [`next_token(Option<String>)`](crate::output::ListRegionalBucketsOutput::next_token): <p> <code>NextToken</code> is sent when <code>isTruncated</code> is true, which means there are more buckets that can be listed. The next list requests to Amazon S3 can be continued with this <code>NextToken</code>. <code>NextToken</code> is obfuscated and is not a real key.</p>
    /// - On failure, responds with [`SdkError<ListRegionalBucketsError>`](crate::error::ListRegionalBucketsError)
    pub fn list_regional_buckets(&self) -> fluent_builders::ListRegionalBuckets {
        fluent_builders::ListRegionalBuckets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListStorageLensConfigurations`](crate::client::fluent_builders::ListStorageLensConfigurations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListStorageLensConfigurations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::ListStorageLensConfigurations::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::ListStorageLensConfigurations::set_account_id): <p>The account ID of the requester.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListStorageLensConfigurations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListStorageLensConfigurations::set_next_token): <p>A pagination token to request the next page of results.</p>
    /// - On success, responds with [`ListStorageLensConfigurationsOutput`](crate::output::ListStorageLensConfigurationsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListStorageLensConfigurationsOutput::next_token): <p>If the request produced more than the maximum number of S3 Storage Lens configuration results, you can pass this value into a subsequent request to retrieve the next page of results.</p>
    ///   - [`storage_lens_configuration_list(Option<Vec<ListStorageLensConfigurationEntry>>)`](crate::output::ListStorageLensConfigurationsOutput::storage_lens_configuration_list): <p>A list of S3 Storage Lens configurations.</p>
    /// - On failure, responds with [`SdkError<ListStorageLensConfigurationsError>`](crate::error::ListStorageLensConfigurationsError)
    pub fn list_storage_lens_configurations(
        &self,
    ) -> fluent_builders::ListStorageLensConfigurations {
        fluent_builders::ListStorageLensConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutAccessPointConfigurationForObjectLambda`](crate::client::fluent_builders::PutAccessPointConfigurationForObjectLambda) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::PutAccessPointConfigurationForObjectLambda::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::PutAccessPointConfigurationForObjectLambda::set_account_id): <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::PutAccessPointConfigurationForObjectLambda::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::PutAccessPointConfigurationForObjectLambda::set_name): <p>The name of the Object Lambda Access Point.</p>
    ///   - [`configuration(ObjectLambdaConfiguration)`](crate::client::fluent_builders::PutAccessPointConfigurationForObjectLambda::configuration) / [`set_configuration(Option<ObjectLambdaConfiguration>)`](crate::client::fluent_builders::PutAccessPointConfigurationForObjectLambda::set_configuration): <p>Object Lambda Access Point configuration document.</p>
    /// - On success, responds with [`PutAccessPointConfigurationForObjectLambdaOutput`](crate::output::PutAccessPointConfigurationForObjectLambdaOutput)

    /// - On failure, responds with [`SdkError<PutAccessPointConfigurationForObjectLambdaError>`](crate::error::PutAccessPointConfigurationForObjectLambdaError)
    pub fn put_access_point_configuration_for_object_lambda(
        &self,
    ) -> fluent_builders::PutAccessPointConfigurationForObjectLambda {
        fluent_builders::PutAccessPointConfigurationForObjectLambda::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutAccessPointPolicy`](crate::client::fluent_builders::PutAccessPointPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::PutAccessPointPolicy::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::PutAccessPointPolicy::set_account_id): <p>The Amazon Web Services account ID for owner of the bucket associated with the specified access point.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::PutAccessPointPolicy::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::PutAccessPointPolicy::set_name): <p>The name of the access point that you want to associate with the specified policy.</p>  <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>  <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:   <region>    :    <account-id>     :outpost/     <outpost-id>      /accesspoint/      <my-accesspoint-name></my-accesspoint-name>     </outpost-id>    </account-id>   </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::PutAccessPointPolicy::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::PutAccessPointPolicy::set_policy): <p>The policy that you want to apply to the specified access point. For more information about access point policies, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">Managing data access with Amazon S3 access points</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// - On success, responds with [`PutAccessPointPolicyOutput`](crate::output::PutAccessPointPolicyOutput)

    /// - On failure, responds with [`SdkError<PutAccessPointPolicyError>`](crate::error::PutAccessPointPolicyError)
    pub fn put_access_point_policy(&self) -> fluent_builders::PutAccessPointPolicy {
        fluent_builders::PutAccessPointPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutAccessPointPolicyForObjectLambda`](crate::client::fluent_builders::PutAccessPointPolicyForObjectLambda) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::PutAccessPointPolicyForObjectLambda::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::PutAccessPointPolicyForObjectLambda::set_account_id): <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::PutAccessPointPolicyForObjectLambda::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::PutAccessPointPolicyForObjectLambda::set_name): <p>The name of the Object Lambda Access Point.</p>
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::PutAccessPointPolicyForObjectLambda::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::PutAccessPointPolicyForObjectLambda::set_policy): <p>Object Lambda Access Point resource policy document.</p>
    /// - On success, responds with [`PutAccessPointPolicyForObjectLambdaOutput`](crate::output::PutAccessPointPolicyForObjectLambdaOutput)

    /// - On failure, responds with [`SdkError<PutAccessPointPolicyForObjectLambdaError>`](crate::error::PutAccessPointPolicyForObjectLambdaError)
    pub fn put_access_point_policy_for_object_lambda(
        &self,
    ) -> fluent_builders::PutAccessPointPolicyForObjectLambda {
        fluent_builders::PutAccessPointPolicyForObjectLambda::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutBucketLifecycleConfiguration`](crate::client::fluent_builders::PutBucketLifecycleConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::PutBucketLifecycleConfiguration::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::PutBucketLifecycleConfiguration::set_account_id): <p>The Amazon Web Services account ID of the Outposts bucket.</p>
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::PutBucketLifecycleConfiguration::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::PutBucketLifecycleConfiguration::set_bucket): <p>The name of the bucket for which to set the configuration.</p>
    ///   - [`lifecycle_configuration(LifecycleConfiguration)`](crate::client::fluent_builders::PutBucketLifecycleConfiguration::lifecycle_configuration) / [`set_lifecycle_configuration(Option<LifecycleConfiguration>)`](crate::client::fluent_builders::PutBucketLifecycleConfiguration::set_lifecycle_configuration): <p>Container for lifecycle rules. You can add as many as 1,000 rules.</p>
    /// - On success, responds with [`PutBucketLifecycleConfigurationOutput`](crate::output::PutBucketLifecycleConfigurationOutput)

    /// - On failure, responds with [`SdkError<PutBucketLifecycleConfigurationError>`](crate::error::PutBucketLifecycleConfigurationError)
    pub fn put_bucket_lifecycle_configuration(
        &self,
    ) -> fluent_builders::PutBucketLifecycleConfiguration {
        fluent_builders::PutBucketLifecycleConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutBucketPolicy`](crate::client::fluent_builders::PutBucketPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::PutBucketPolicy::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::PutBucketPolicy::set_account_id): <p>The Amazon Web Services account ID of the Outposts bucket.</p>
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::PutBucketPolicy::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::PutBucketPolicy::set_bucket): <p>Specifies the bucket.</p>  <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>  <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:   <region>    :    <account-id>     :outpost/     <outpost-id>      /bucket/      <my-bucket-name></my-bucket-name>     </outpost-id>    </account-id>   </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    ///   - [`confirm_remove_self_bucket_access(bool)`](crate::client::fluent_builders::PutBucketPolicy::confirm_remove_self_bucket_access) / [`set_confirm_remove_self_bucket_access(bool)`](crate::client::fluent_builders::PutBucketPolicy::set_confirm_remove_self_bucket_access): <p>Set this parameter to true to confirm that you want to remove your permissions to change this bucket policy in the future.</p> <note>   <p>This is not supported by Amazon S3 on Outposts buckets.</p>  </note>
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::PutBucketPolicy::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::PutBucketPolicy::set_policy): <p>The bucket policy as a JSON document.</p>
    /// - On success, responds with [`PutBucketPolicyOutput`](crate::output::PutBucketPolicyOutput)

    /// - On failure, responds with [`SdkError<PutBucketPolicyError>`](crate::error::PutBucketPolicyError)
    pub fn put_bucket_policy(&self) -> fluent_builders::PutBucketPolicy {
        fluent_builders::PutBucketPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutBucketTagging`](crate::client::fluent_builders::PutBucketTagging) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::PutBucketTagging::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::PutBucketTagging::set_account_id): <p>The Amazon Web Services account ID of the Outposts bucket.</p>
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::PutBucketTagging::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::PutBucketTagging::set_bucket): <p>The Amazon Resource Name (ARN) of the bucket.</p>  <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>  <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:   <region>    :    <account-id>     :outpost/     <outpost-id>      /bucket/      <my-bucket-name></my-bucket-name>     </outpost-id>    </account-id>   </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    ///   - [`tagging(Tagging)`](crate::client::fluent_builders::PutBucketTagging::tagging) / [`set_tagging(Option<Tagging>)`](crate::client::fluent_builders::PutBucketTagging::set_tagging): <p></p>
    /// - On success, responds with [`PutBucketTaggingOutput`](crate::output::PutBucketTaggingOutput)

    /// - On failure, responds with [`SdkError<PutBucketTaggingError>`](crate::error::PutBucketTaggingError)
    pub fn put_bucket_tagging(&self) -> fluent_builders::PutBucketTagging {
        fluent_builders::PutBucketTagging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutJobTagging`](crate::client::fluent_builders::PutJobTagging) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::PutJobTagging::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::PutJobTagging::set_account_id): <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::PutJobTagging::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::PutJobTagging::set_job_id): <p>The ID for the S3 Batch Operations job whose tags you want to replace.</p>
    ///   - [`tags(Vec<S3Tag>)`](crate::client::fluent_builders::PutJobTagging::tags) / [`set_tags(Option<Vec<S3Tag>>)`](crate::client::fluent_builders::PutJobTagging::set_tags): <p>The set of tags to associate with the S3 Batch Operations job.</p>
    /// - On success, responds with [`PutJobTaggingOutput`](crate::output::PutJobTaggingOutput)

    /// - On failure, responds with [`SdkError<PutJobTaggingError>`](crate::error::PutJobTaggingError)
    pub fn put_job_tagging(&self) -> fluent_builders::PutJobTagging {
        fluent_builders::PutJobTagging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutMultiRegionAccessPointPolicy`](crate::client::fluent_builders::PutMultiRegionAccessPointPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::PutMultiRegionAccessPointPolicy::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::PutMultiRegionAccessPointPolicy::set_account_id): <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::PutMultiRegionAccessPointPolicy::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::PutMultiRegionAccessPointPolicy::set_client_token): <p>An idempotency token used to identify the request and guarantee that requests are unique.</p>
    ///   - [`details(PutMultiRegionAccessPointPolicyInput)`](crate::client::fluent_builders::PutMultiRegionAccessPointPolicy::details) / [`set_details(Option<PutMultiRegionAccessPointPolicyInput>)`](crate::client::fluent_builders::PutMultiRegionAccessPointPolicy::set_details): <p>A container element containing the details of the policy for the Multi-Region Access Point.</p>
    /// - On success, responds with [`PutMultiRegionAccessPointPolicyOutput`](crate::output::PutMultiRegionAccessPointPolicyOutput) with field(s):
    ///   - [`request_token_arn(Option<String>)`](crate::output::PutMultiRegionAccessPointPolicyOutput::request_token_arn): <p>The request token associated with the request. You can use this token with <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> to determine the status of asynchronous requests.</p>
    /// - On failure, responds with [`SdkError<PutMultiRegionAccessPointPolicyError>`](crate::error::PutMultiRegionAccessPointPolicyError)
    pub fn put_multi_region_access_point_policy(
        &self,
    ) -> fluent_builders::PutMultiRegionAccessPointPolicy {
        fluent_builders::PutMultiRegionAccessPointPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutPublicAccessBlock`](crate::client::fluent_builders::PutPublicAccessBlock) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`public_access_block_configuration(PublicAccessBlockConfiguration)`](crate::client::fluent_builders::PutPublicAccessBlock::public_access_block_configuration) / [`set_public_access_block_configuration(Option<PublicAccessBlockConfiguration>)`](crate::client::fluent_builders::PutPublicAccessBlock::set_public_access_block_configuration): <p>The <code>PublicAccessBlock</code> configuration that you want to apply to the specified Amazon Web Services account.</p>
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::PutPublicAccessBlock::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::PutPublicAccessBlock::set_account_id): <p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want to set.</p>
    /// - On success, responds with [`PutPublicAccessBlockOutput`](crate::output::PutPublicAccessBlockOutput)

    /// - On failure, responds with [`SdkError<PutPublicAccessBlockError>`](crate::error::PutPublicAccessBlockError)
    pub fn put_public_access_block(&self) -> fluent_builders::PutPublicAccessBlock {
        fluent_builders::PutPublicAccessBlock::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutStorageLensConfiguration`](crate::client::fluent_builders::PutStorageLensConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`config_id(impl Into<String>)`](crate::client::fluent_builders::PutStorageLensConfiguration::config_id) / [`set_config_id(Option<String>)`](crate::client::fluent_builders::PutStorageLensConfiguration::set_config_id): <p>The ID of the S3 Storage Lens configuration.</p>
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::PutStorageLensConfiguration::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::PutStorageLensConfiguration::set_account_id): <p>The account ID of the requester.</p>
    ///   - [`storage_lens_configuration(StorageLensConfiguration)`](crate::client::fluent_builders::PutStorageLensConfiguration::storage_lens_configuration) / [`set_storage_lens_configuration(Option<StorageLensConfiguration>)`](crate::client::fluent_builders::PutStorageLensConfiguration::set_storage_lens_configuration): <p>The S3 Storage Lens configuration.</p>
    ///   - [`tags(Vec<StorageLensTag>)`](crate::client::fluent_builders::PutStorageLensConfiguration::tags) / [`set_tags(Option<Vec<StorageLensTag>>)`](crate::client::fluent_builders::PutStorageLensConfiguration::set_tags): <p>The tag set of the S3 Storage Lens configuration.</p> <note>   <p>You can set up to a maximum of 50 tags.</p>  </note>
    /// - On success, responds with [`PutStorageLensConfigurationOutput`](crate::output::PutStorageLensConfigurationOutput)

    /// - On failure, responds with [`SdkError<PutStorageLensConfigurationError>`](crate::error::PutStorageLensConfigurationError)
    pub fn put_storage_lens_configuration(&self) -> fluent_builders::PutStorageLensConfiguration {
        fluent_builders::PutStorageLensConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutStorageLensConfigurationTagging`](crate::client::fluent_builders::PutStorageLensConfigurationTagging) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`config_id(impl Into<String>)`](crate::client::fluent_builders::PutStorageLensConfigurationTagging::config_id) / [`set_config_id(Option<String>)`](crate::client::fluent_builders::PutStorageLensConfigurationTagging::set_config_id): <p>The ID of the S3 Storage Lens configuration.</p>
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::PutStorageLensConfigurationTagging::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::PutStorageLensConfigurationTagging::set_account_id): <p>The account ID of the requester.</p>
    ///   - [`tags(Vec<StorageLensTag>)`](crate::client::fluent_builders::PutStorageLensConfigurationTagging::tags) / [`set_tags(Option<Vec<StorageLensTag>>)`](crate::client::fluent_builders::PutStorageLensConfigurationTagging::set_tags): <p>The tag set of the S3 Storage Lens configuration.</p> <note>   <p>You can set up to a maximum of 50 tags.</p>  </note>
    /// - On success, responds with [`PutStorageLensConfigurationTaggingOutput`](crate::output::PutStorageLensConfigurationTaggingOutput)

    /// - On failure, responds with [`SdkError<PutStorageLensConfigurationTaggingError>`](crate::error::PutStorageLensConfigurationTaggingError)
    pub fn put_storage_lens_configuration_tagging(
        &self,
    ) -> fluent_builders::PutStorageLensConfigurationTagging {
        fluent_builders::PutStorageLensConfigurationTagging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateJobPriority`](crate::client::fluent_builders::UpdateJobPriority) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateJobPriority::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::UpdateJobPriority::set_account_id): <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::UpdateJobPriority::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::UpdateJobPriority::set_job_id): <p>The ID for the job whose priority you want to update.</p>
    ///   - [`priority(i32)`](crate::client::fluent_builders::UpdateJobPriority::priority) / [`set_priority(i32)`](crate::client::fluent_builders::UpdateJobPriority::set_priority): <p>The priority you want to assign to this job.</p>
    /// - On success, responds with [`UpdateJobPriorityOutput`](crate::output::UpdateJobPriorityOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::UpdateJobPriorityOutput::job_id): <p>The ID for the job whose priority Amazon S3 updated.</p>
    ///   - [`priority(i32)`](crate::output::UpdateJobPriorityOutput::priority): <p>The new priority assigned to the specified job.</p>
    /// - On failure, responds with [`SdkError<UpdateJobPriorityError>`](crate::error::UpdateJobPriorityError)
    pub fn update_job_priority(&self) -> fluent_builders::UpdateJobPriority {
        fluent_builders::UpdateJobPriority::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateJobStatus`](crate::client::fluent_builders::UpdateJobStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateJobStatus::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::UpdateJobStatus::set_account_id): <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::UpdateJobStatus::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::UpdateJobStatus::set_job_id): <p>The ID of the job whose status you want to update.</p>
    ///   - [`requested_job_status(RequestedJobStatus)`](crate::client::fluent_builders::UpdateJobStatus::requested_job_status) / [`set_requested_job_status(Option<RequestedJobStatus>)`](crate::client::fluent_builders::UpdateJobStatus::set_requested_job_status): <p>The status that you want to move the specified job to.</p>
    ///   - [`status_update_reason(impl Into<String>)`](crate::client::fluent_builders::UpdateJobStatus::status_update_reason) / [`set_status_update_reason(Option<String>)`](crate::client::fluent_builders::UpdateJobStatus::set_status_update_reason): <p>A description of the reason why you want to change the specified job's status. This field can be any string up to the maximum length.</p>
    /// - On success, responds with [`UpdateJobStatusOutput`](crate::output::UpdateJobStatusOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::UpdateJobStatusOutput::job_id): <p>The ID for the job whose status was updated.</p>
    ///   - [`status(Option<JobStatus>)`](crate::output::UpdateJobStatusOutput::status): <p>The current status for the specified job.</p>
    ///   - [`status_update_reason(Option<String>)`](crate::output::UpdateJobStatusOutput::status_update_reason): <p>The reason that the specified job's status was updated.</p>
    /// - On failure, responds with [`SdkError<UpdateJobStatusError>`](crate::error::UpdateJobStatusError)
    pub fn update_job_status(&self) -> fluent_builders::UpdateJobStatus {
        fluent_builders::UpdateJobStatus::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateAccessPoint`.
    ///
    /// <p>Creates an access point and associates it with the specified bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">Managing Data Access with Amazon S3 Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p></p> <note>
    /// <p>S3 on Outposts only supports VPC-style access points. </p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html"> Accessing Amazon S3 on Outposts using virtual private cloud (VPC) only access points</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// </note>
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html#API_control_CreateAccessPoint_Examples">Examples</a> section.</p>
    /// <p></p>
    /// <p>The following actions are related to <code>CreateAccessPoint</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html">GetAccessPoint</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html">DeleteAccessPoint</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html">ListAccessPoints</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAccessPoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_access_point_input::Builder,
    }
    impl CreateAccessPoint {
        /// Creates a new `CreateAccessPoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAccessPointOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAccessPointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID for the owner of the bucket for which you want to create an access point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the owner of the bucket for which you want to create an access point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name you want to assign to this access point.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name you want to assign to this access point.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name of the bucket that you want to associate this access point with.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket that you want to associate this access point with.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>If you include this field, Amazon S3 restricts access to this access point to requests from the specified virtual private cloud (VPC).</p> <note>
        /// <p>This is required for creating an access point for Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn vpc_configuration(mut self, input: crate::model::VpcConfiguration) -> Self {
            self.inner = self.inner.vpc_configuration(input);
            self
        }
        /// <p>If you include this field, Amazon S3 restricts access to this access point to requests from the specified virtual private cloud (VPC).</p> <note>
        /// <p>This is required for creating an access point for Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_vpc_configuration(
            mut self,
            input: std::option::Option<crate::model::VpcConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_vpc_configuration(input);
            self
        }
        /// <p> The <code>PublicAccessBlock</code> configuration that you want to apply to the access point. </p>
        pub fn public_access_block_configuration(
            mut self,
            input: crate::model::PublicAccessBlockConfiguration,
        ) -> Self {
            self.inner = self.inner.public_access_block_configuration(input);
            self
        }
        /// <p> The <code>PublicAccessBlock</code> configuration that you want to apply to the access point. </p>
        pub fn set_public_access_block_configuration(
            mut self,
            input: std::option::Option<crate::model::PublicAccessBlockConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_public_access_block_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAccessPointForObjectLambda`.
    ///
    /// <p>Creates an Object Lambda Access Point. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/transforming-objects.html">Transforming objects with Object Lambda Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>The following actions are related to <code>CreateAccessPointForObjectLambda</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointForObjectLambda.html">DeleteAccessPointForObjectLambda</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointForObjectLambda.html">GetAccessPointForObjectLambda</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPointsForObjectLambda.html">ListAccessPointsForObjectLambda</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAccessPointForObjectLambda {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_access_point_for_object_lambda_input::Builder,
    }
    impl CreateAccessPointForObjectLambda {
        /// Creates a new `CreateAccessPointForObjectLambda`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAccessPointForObjectLambdaOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAccessPointForObjectLambdaError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID for owner of the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for owner of the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name you want to assign to this Object Lambda Access Point.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name you want to assign to this Object Lambda Access Point.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Object Lambda Access Point configuration as a JSON document.</p>
        pub fn configuration(mut self, input: crate::model::ObjectLambdaConfiguration) -> Self {
            self.inner = self.inner.configuration(input);
            self
        }
        /// <p>Object Lambda Access Point configuration as a JSON document.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ObjectLambdaConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBucket`.
    ///
    /// <note>
    /// <p>This action creates an Amazon S3 on Outposts bucket. To create an S3 bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">Create Bucket</a> in the <i>Amazon S3 API Reference</i>. </p>
    /// </note>
    /// <p>Creates a new Outposts bucket. By creating the bucket, you become the bucket owner. To create an Outposts bucket, you must have S3 on Outposts. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in <i>Amazon S3 User Guide</i>.</p>
    /// <p>Not every string is an acceptable bucket name. For information on bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/BucketRestrictions.html#bucketnamingrules">Working with Amazon S3 Buckets</a>.</p>
    /// <p>S3 on Outposts buckets support:</p>
    /// <ul>
    /// <li> <p>Tags</p> </li>
    /// <li> <p>LifecycleConfigurations for deleting expired objects</p> </li>
    /// </ul>
    /// <p>For a complete list of restrictions and Amazon S3 feature limitations on S3 on Outposts, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OnOutpostsRestrictionsLimitations.html"> Amazon S3 on Outposts Restrictions and Limitations</a>.</p>
    /// <p>For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and <code>x-amz-outpost-id</code> in your API request, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html#API_control_CreateBucket_Examples">Examples</a> section.</p>
    /// <p>The following actions are related to <code>CreateBucket</code> for Amazon S3 on Outposts:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucket.html">GetBucket</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html">DeleteBucket</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html">CreateAccessPoint</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html">PutAccessPointPolicy</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBucket {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_bucket_input::Builder,
    }
    impl CreateBucket {
        /// Creates a new `CreateBucket`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBucketOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBucketError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The canned ACL to apply to the bucket.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn acl(mut self, input: crate::model::BucketCannedAcl) -> Self {
            self.inner = self.inner.acl(input);
            self
        }
        /// <p>The canned ACL to apply to the bucket.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_acl(
            mut self,
            input: std::option::Option<crate::model::BucketCannedAcl>,
        ) -> Self {
            self.inner = self.inner.set_acl(input);
            self
        }
        /// <p>The name of the bucket.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The configuration information for the bucket.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn create_bucket_configuration(
            mut self,
            input: crate::model::CreateBucketConfiguration,
        ) -> Self {
            self.inner = self.inner.create_bucket_configuration(input);
            self
        }
        /// <p>The configuration information for the bucket.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_create_bucket_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateBucketConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_create_bucket_configuration(input);
            self
        }
        /// <p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn grant_full_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_full_control(input.into());
            self
        }
        /// <p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_grant_full_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_grant_full_control(input);
            self
        }
        /// <p>Allows grantee to list the objects in the bucket.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn grant_read(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_read(input.into());
            self
        }
        /// <p>Allows grantee to list the objects in the bucket.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_grant_read(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grant_read(input);
            self
        }
        /// <p>Allows grantee to read the bucket ACL.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn grant_read_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_read_acp(input.into());
            self
        }
        /// <p>Allows grantee to read the bucket ACL.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_grant_read_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_grant_read_acp(input);
            self
        }
        /// <p>Allows grantee to create, overwrite, and delete any object in the bucket.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn grant_write(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_write(input.into());
            self
        }
        /// <p>Allows grantee to create, overwrite, and delete any object in the bucket.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_grant_write(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grant_write(input);
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable bucket.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn grant_write_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_write_acp(input.into());
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable bucket.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_grant_write_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_grant_write_acp(input);
            self
        }
        /// <p>Specifies whether you want S3 Object Lock to be enabled for the new bucket.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn object_lock_enabled_for_bucket(mut self, input: bool) -> Self {
            self.inner = self.inner.object_lock_enabled_for_bucket(input);
            self
        }
        /// <p>Specifies whether you want S3 Object Lock to be enabled for the new bucket.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_object_lock_enabled_for_bucket(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_object_lock_enabled_for_bucket(input);
            self
        }
        /// <p>The ID of the Outposts where the bucket is being created.</p> <note>
        /// <p>This is required by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn outpost_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.outpost_id(input.into());
            self
        }
        /// <p>The ID of the Outposts where the bucket is being created.</p> <note>
        /// <p>This is required by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_outpost_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_outpost_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateJob`.
    ///
    /// <p>You can use S3 Batch Operations to perform large-scale batch actions on Amazon S3 objects. Batch Operations can run a single action on lists of Amazon S3 objects that you specify. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html">S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>This action creates a S3 Batch Operations job.</p>
    /// <p></p>
    /// <p>Related actions include:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html">DescribeJob</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html">ListJobs</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobPriority.html">UpdateJobPriority</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html">UpdateJobStatus</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_JobOperation.html">JobOperation</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_job_input::Builder,
    }
    impl CreateJob {
        /// Creates a new `CreateJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID that creates the job.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID that creates the job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>Indicates whether confirmation is required before Amazon S3 runs the job. Confirmation is only required for jobs created through the Amazon S3 console.</p>
        pub fn confirmation_required(mut self, input: bool) -> Self {
            self.inner = self.inner.confirmation_required(input);
            self
        }
        /// <p>Indicates whether confirmation is required before Amazon S3 runs the job. Confirmation is only required for jobs created through the Amazon S3 console.</p>
        pub fn set_confirmation_required(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_confirmation_required(input);
            self
        }
        /// <p>The action that you want this job to perform on every object listed in the manifest. For more information about the available actions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-actions.html">Operations</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn operation(mut self, input: crate::model::JobOperation) -> Self {
            self.inner = self.inner.operation(input);
            self
        }
        /// <p>The action that you want this job to perform on every object listed in the manifest. For more information about the available actions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-actions.html">Operations</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_operation(
            mut self,
            input: std::option::Option<crate::model::JobOperation>,
        ) -> Self {
            self.inner = self.inner.set_operation(input);
            self
        }
        /// <p>Configuration parameters for the optional job-completion report.</p>
        pub fn report(mut self, input: crate::model::JobReport) -> Self {
            self.inner = self.inner.report(input);
            self
        }
        /// <p>Configuration parameters for the optional job-completion report.</p>
        pub fn set_report(mut self, input: std::option::Option<crate::model::JobReport>) -> Self {
            self.inner = self.inner.set_report(input);
            self
        }
        /// <p>An idempotency token to ensure that you don't accidentally submit the same request twice. You can use any string up to the maximum length.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>An idempotency token to ensure that you don't accidentally submit the same request twice. You can use any string up to the maximum length.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>Configuration parameters for the manifest.</p>
        pub fn manifest(mut self, input: crate::model::JobManifest) -> Self {
            self.inner = self.inner.manifest(input);
            self
        }
        /// <p>Configuration parameters for the manifest.</p>
        pub fn set_manifest(
            mut self,
            input: std::option::Option<crate::model::JobManifest>,
        ) -> Self {
            self.inner = self.inner.set_manifest(input);
            self
        }
        /// <p>A description for this job. You can use any string within the permitted length. Descriptions don't need to be unique and can be used for multiple jobs.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for this job. You can use any string within the permitted length. Descriptions don't need to be unique and can be used for multiple jobs.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The numerical priority for this job. Higher numbers indicate higher priority.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.inner = self.inner.priority(input);
            self
        }
        /// <p>The numerical priority for this job. Higher numbers indicate higher priority.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_priority(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Identity and Access Management (IAM) role that Batch Operations will use to run this job's action on every object in the manifest.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Identity and Access Management (IAM) role that Batch Operations will use to run this job's action on every object in the manifest.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A set of tags to associate with the S3 Batch Operations job. This is an optional parameter. </p>
        pub fn tags(mut self, input: crate::model::S3Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A set of tags to associate with the S3 Batch Operations job. This is an optional parameter. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The attribute container for the ManifestGenerator details. Jobs must be created with either a manifest file or a ManifestGenerator, but not both.</p>
        pub fn manifest_generator(mut self, input: crate::model::JobManifestGenerator) -> Self {
            self.inner = self.inner.manifest_generator(input);
            self
        }
        /// <p>The attribute container for the ManifestGenerator details. Jobs must be created with either a manifest file or a ManifestGenerator, but not both.</p>
        pub fn set_manifest_generator(
            mut self,
            input: std::option::Option<crate::model::JobManifestGenerator>,
        ) -> Self {
            self.inner = self.inner.set_manifest_generator(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMultiRegionAccessPoint`.
    ///
    /// <p>Creates a Multi-Region Access Point and associates it with the specified buckets. For more information about creating Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html">Creating Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around managing Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>This request is asynchronous, meaning that you might receive a response before the command has completed. When this request provides a response, it provides a token that you can use to monitor the status of the request with <code>DescribeMultiRegionAccessPointOperation</code>.</p>
    /// <p>The following actions are related to <code>CreateMultiRegionAccessPoint</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html">DeleteMultiRegionAccessPoint</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html">GetMultiRegionAccessPoint</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html">ListMultiRegionAccessPoints</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateMultiRegionAccessPoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_multi_region_access_point_input::Builder,
    }
    impl CreateMultiRegionAccessPoint {
        /// Creates a new `CreateMultiRegionAccessPoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMultiRegionAccessPointOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMultiRegionAccessPointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point. The owner of the Multi-Region Access Point also must own the underlying buckets.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point. The owner of the Multi-Region Access Point also must own the underlying buckets.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>An idempotency token used to identify the request and guarantee that requests are unique.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>An idempotency token used to identify the request and guarantee that requests are unique.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>A container element containing details about the Multi-Region Access Point.</p>
        pub fn details(mut self, input: crate::model::CreateMultiRegionAccessPointInput) -> Self {
            self.inner = self.inner.details(input);
            self
        }
        /// <p>A container element containing details about the Multi-Region Access Point.</p>
        pub fn set_details(
            mut self,
            input: std::option::Option<crate::model::CreateMultiRegionAccessPointInput>,
        ) -> Self {
            self.inner = self.inner.set_details(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccessPoint`.
    ///
    /// <p>Deletes the specified access point.</p>
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html#API_control_DeleteAccessPoint_Examples">Examples</a> section.</p>
    /// <p>The following actions are related to <code>DeleteAccessPoint</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html">CreateAccessPoint</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html">GetAccessPoint</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html">ListAccessPoints</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAccessPoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_access_point_input::Builder,
    }
    impl DeleteAccessPoint {
        /// Creates a new `DeleteAccessPoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAccessPointOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAccessPointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the access point you want to delete.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /accesspoint/
        /// <my-accesspoint-name></my-accesspoint-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the access point you want to delete.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /accesspoint/
        /// <my-accesspoint-name></my-accesspoint-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccessPointForObjectLambda`.
    ///
    /// <p>Deletes the specified Object Lambda Access Point.</p>
    /// <p>The following actions are related to <code>DeleteAccessPointForObjectLambda</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPointForObjectLambda.html">CreateAccessPointForObjectLambda</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointForObjectLambda.html">GetAccessPointForObjectLambda</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPointsForObjectLambda.html">ListAccessPointsForObjectLambda</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAccessPointForObjectLambda {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_access_point_for_object_lambda_input::Builder,
    }
    impl DeleteAccessPointForObjectLambda {
        /// Creates a new `DeleteAccessPointForObjectLambda`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAccessPointForObjectLambdaOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAccessPointForObjectLambdaError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the access point you want to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the access point you want to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccessPointPolicy`.
    ///
    /// <p>Deletes the access point policy for the specified access point.</p>
    /// <p></p>
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html#API_control_DeleteAccessPointPolicy_Examples">Examples</a> section.</p>
    /// <p>The following actions are related to <code>DeleteAccessPointPolicy</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html">PutAccessPointPolicy</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicy.html">GetAccessPointPolicy</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAccessPointPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_access_point_policy_input::Builder,
    }
    impl DeleteAccessPointPolicy {
        /// Creates a new `DeleteAccessPointPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAccessPointPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAccessPointPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the access point whose policy you want to delete.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /accesspoint/
        /// <my-accesspoint-name></my-accesspoint-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the access point whose policy you want to delete.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /accesspoint/
        /// <my-accesspoint-name></my-accesspoint-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccessPointPolicyForObjectLambda`.
    ///
    /// <p>Removes the resource policy for an Object Lambda Access Point.</p>
    /// <p>The following actions are related to <code>DeleteAccessPointPolicyForObjectLambda</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicyForObjectLambda.html">GetAccessPointPolicyForObjectLambda</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicyForObjectLambda.html">PutAccessPointPolicyForObjectLambda</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAccessPointPolicyForObjectLambda {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_access_point_policy_for_object_lambda_input::Builder,
    }
    impl DeleteAccessPointPolicyForObjectLambda {
        /// Creates a new `DeleteAccessPointPolicyForObjectLambda`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAccessPointPolicyForObjectLambdaOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteAccessPointPolicyForObjectLambdaError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the Object Lambda Access Point you want to delete the policy for.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the Object Lambda Access Point you want to delete the policy for.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBucket`.
    ///
    /// <note>
    /// <p>This action deletes an Amazon S3 on Outposts bucket. To delete an S3 bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html">DeleteBucket</a> in the <i>Amazon S3 API Reference</i>. </p>
    /// </note>
    /// <p>Deletes the Amazon S3 on Outposts bucket. All objects (including all object versions and delete markers) in the bucket must be deleted before the bucket itself can be deleted. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in <i>Amazon S3 User Guide</i>.</p>
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html#API_control_DeleteBucket_Examples">Examples</a> section.</p>
    /// <p class="title"> <b>Related Resources</b> </p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html">CreateBucket</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucket.html">GetBucket</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html">DeleteObject</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBucket {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_bucket_input::Builder,
    }
    impl DeleteBucket {
        /// Creates a new `DeleteBucket`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBucketOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBucketError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID that owns the Outposts bucket.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID that owns the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>Specifies the bucket being deleted.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>Specifies the bucket being deleted.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBucketLifecycleConfiguration`.
    ///
    /// <note>
    /// <p>This action deletes an Amazon S3 on Outposts bucket's lifecycle configuration. To delete an S3 bucket's lifecycle configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketLifecycle.html">DeleteBucketLifecycle</a> in the <i>Amazon S3 API Reference</i>. </p>
    /// </note>
    /// <p>Deletes the lifecycle configuration from the specified Outposts bucket. Amazon S3 on Outposts removes all the lifecycle configuration rules in the lifecycle subresource associated with the bucket. Your objects never expire, and Amazon S3 on Outposts no longer automatically deletes any objects on the basis of rules contained in the deleted lifecycle configuration. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in <i>Amazon S3 User Guide</i>.</p>
    /// <p>To use this action, you must have permission to perform the <code>s3-outposts:DeleteLifecycleConfiguration</code> action. By default, the bucket owner has this permission and the Outposts bucket owner can grant this permission to others.</p>
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketLifecycleConfiguration.html#API_control_DeleteBucketLifecycleConfiguration_Examples">Examples</a> section.</p>
    /// <p>For more information about object expiration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#intro-lifecycle-rules-actions">Elements to Describe Lifecycle Actions</a>.</p>
    /// <p>Related actions include:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html">PutBucketLifecycleConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html">GetBucketLifecycleConfiguration</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBucketLifecycleConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_bucket_lifecycle_configuration_input::Builder,
    }
    impl DeleteBucketLifecycleConfiguration {
        /// Creates a new `DeleteBucketLifecycleConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBucketLifecycleConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteBucketLifecycleConfigurationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID of the lifecycle configuration to delete.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID of the lifecycle configuration to delete.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBucketPolicy`.
    ///
    /// <note>
    /// <p>This action deletes an Amazon S3 on Outposts bucket policy. To delete an S3 bucket policy, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketPolicy.html">DeleteBucketPolicy</a> in the <i>Amazon S3 API Reference</i>. </p>
    /// </note>
    /// <p>This implementation of the DELETE action uses the policy subresource to delete the policy of a specified Amazon S3 on Outposts bucket. If you are using an identity other than the root user of the Amazon Web Services account that owns the bucket, the calling identity must have the <code>s3-outposts:DeleteBucketPolicy</code> permissions on the specified Outposts bucket and belong to the bucket owner's account to use this action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in <i>Amazon S3 User Guide</i>.</p>
    /// <p>If you don't have <code>DeleteBucketPolicy</code> permissions, Amazon S3 returns a <code>403 Access Denied</code> error. If you have the correct permissions, but you're not using an identity that belongs to the bucket owner's account, Amazon S3 returns a <code>405 Method Not Allowed</code> error. </p> <important>
    /// <p>As a security precaution, the root user of the Amazon Web Services account that owns a bucket can always use this action, even if the policy explicitly denies the root user the ability to perform this action.</p>
    /// </important>
    /// <p>For more information about bucket policies, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies and User Policies</a>. </p>
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketPolicy.html#API_control_DeleteBucketPolicy_Examples">Examples</a> section.</p>
    /// <p>The following actions are related to <code>DeleteBucketPolicy</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketPolicy.html">GetBucketPolicy</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketPolicy.html">PutBucketPolicy</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBucketPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_bucket_policy_input::Builder,
    }
    impl DeleteBucketPolicy {
        /// Creates a new `DeleteBucketPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBucketPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBucketPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID of the Outposts bucket.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID of the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBucketTagging`.
    ///
    /// <note>
    /// <p>This action deletes an Amazon S3 on Outposts bucket's tags. To delete an S3 bucket tags, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketTagging.html">DeleteBucketTagging</a> in the <i>Amazon S3 API Reference</i>. </p>
    /// </note>
    /// <p>Deletes the tags from the Outposts bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in <i>Amazon S3 User Guide</i>.</p>
    /// <p>To use this action, you must have permission to perform the <code>PutBucketTagging</code> action. By default, the bucket owner has this permission and can grant this permission to others. </p>
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketTagging.html#API_control_DeleteBucketTagging_Examples">Examples</a> section.</p>
    /// <p>The following actions are related to <code>DeleteBucketTagging</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketTagging.html">GetBucketTagging</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html">PutBucketTagging</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBucketTagging {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_bucket_tagging_input::Builder,
    }
    impl DeleteBucketTagging {
        /// Creates a new `DeleteBucketTagging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBucketTaggingOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBucketTaggingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket tag set to be removed.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket tag set to be removed.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The bucket ARN that has the tag set to be removed.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The bucket ARN that has the tag set to be removed.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteJobTagging`.
    ///
    /// <p>Removes the entire tag set from the specified S3 Batch Operations job. To use this operation, you must have permission to perform the <code>s3:DeleteJobTagging</code> action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags">Controlling access and labeling jobs using tags</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p></p>
    /// <p>Related actions include:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetJobTagging.html">GetJobTagging</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutJobTagging.html">PutJobTagging</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteJobTagging {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_job_tagging_input::Builder,
    }
    impl DeleteJobTagging {
        /// Creates a new `DeleteJobTagging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteJobTaggingOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteJobTaggingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The ID for the S3 Batch Operations job whose tags you want to delete.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID for the S3 Batch Operations job whose tags you want to delete.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMultiRegionAccessPoint`.
    ///
    /// <p>Deletes a Multi-Region Access Point. This action does not delete the buckets associated with the Multi-Region Access Point, only the Multi-Region Access Point itself.</p>
    /// <p>This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around managing Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>This request is asynchronous, meaning that you might receive a response before the command has completed. When this request provides a response, it provides a token that you can use to monitor the status of the request with <code>DescribeMultiRegionAccessPointOperation</code>.</p>
    /// <p>The following actions are related to <code>DeleteMultiRegionAccessPoint</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html">CreateMultiRegionAccessPoint</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html">GetMultiRegionAccessPoint</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html">ListMultiRegionAccessPoints</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteMultiRegionAccessPoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_multi_region_access_point_input::Builder,
    }
    impl DeleteMultiRegionAccessPoint {
        /// Creates a new `DeleteMultiRegionAccessPoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMultiRegionAccessPointOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMultiRegionAccessPointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>An idempotency token used to identify the request and guarantee that requests are unique.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>An idempotency token used to identify the request and guarantee that requests are unique.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>A container element containing details about the Multi-Region Access Point.</p>
        pub fn details(mut self, input: crate::model::DeleteMultiRegionAccessPointInput) -> Self {
            self.inner = self.inner.details(input);
            self
        }
        /// <p>A container element containing details about the Multi-Region Access Point.</p>
        pub fn set_details(
            mut self,
            input: std::option::Option<crate::model::DeleteMultiRegionAccessPointInput>,
        ) -> Self {
            self.inner = self.inner.set_details(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePublicAccessBlock`.
    ///
    /// <p>Removes the <code>PublicAccessBlock</code> configuration for an Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html"> Using Amazon S3 block public access</a>.</p>
    /// <p>Related actions include:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetPublicAccessBlock.html">GetPublicAccessBlock</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutPublicAccessBlock.html">PutPublicAccessBlock</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePublicAccessBlock {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_public_access_block_input::Builder,
    }
    impl DeletePublicAccessBlock {
        /// Creates a new `DeletePublicAccessBlock`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePublicAccessBlockOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePublicAccessBlockError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want to remove.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want to remove.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStorageLensConfiguration`.
    ///
    /// <p>Deletes the Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage activity and usage with Amazon S3 Storage Lens </a> in the <i>Amazon S3 User Guide</i>.</p> <note>
    /// <p>To use this action, you must have permission to perform the <code>s3:DeleteStorageLensConfiguration</code> action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to use Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteStorageLensConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_storage_lens_configuration_input::Builder,
    }
    impl DeleteStorageLensConfiguration {
        /// Creates a new `DeleteStorageLensConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStorageLensConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStorageLensConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the S3 Storage Lens configuration.</p>
        pub fn config_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_id(input.into());
            self
        }
        /// <p>The ID of the S3 Storage Lens configuration.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_config_id(input);
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStorageLensConfigurationTagging`.
    ///
    /// <p>Deletes the Amazon S3 Storage Lens configuration tags. For more information about S3 Storage Lens, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage activity and usage with Amazon S3 Storage Lens </a> in the <i>Amazon S3 User Guide</i>.</p> <note>
    /// <p>To use this action, you must have permission to perform the <code>s3:DeleteStorageLensConfigurationTagging</code> action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to use Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteStorageLensConfigurationTagging {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_storage_lens_configuration_tagging_input::Builder,
    }
    impl DeleteStorageLensConfigurationTagging {
        /// Creates a new `DeleteStorageLensConfigurationTagging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStorageLensConfigurationTaggingOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteStorageLensConfigurationTaggingError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the S3 Storage Lens configuration.</p>
        pub fn config_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_id(input.into());
            self
        }
        /// <p>The ID of the S3 Storage Lens configuration.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_config_id(input);
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeJob`.
    ///
    /// <p>Retrieves the configuration parameters and status for a Batch Operations job. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html">S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p></p>
    /// <p>Related actions include:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html">ListJobs</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobPriority.html">UpdateJobPriority</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html">UpdateJobStatus</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_job_input::Builder,
    }
    impl DescribeJob {
        /// Creates a new `DescribeJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The ID for the job whose information you want to retrieve.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID for the job whose information you want to retrieve.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMultiRegionAccessPointOperation`.
    ///
    /// <p>Retrieves the status of an asynchronous request to manage a Multi-Region Access Point. For more information about managing Multi-Region Access Points and how asynchronous requests work, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>The following actions are related to <code>GetMultiRegionAccessPoint</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html">CreateMultiRegionAccessPoint</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html">DeleteMultiRegionAccessPoint</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html">GetMultiRegionAccessPoint</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html">ListMultiRegionAccessPoints</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeMultiRegionAccessPointOperation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_multi_region_access_point_operation_input::Builder,
    }
    impl DescribeMultiRegionAccessPointOperation {
        /// Creates a new `DescribeMultiRegionAccessPointOperation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMultiRegionAccessPointOperationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeMultiRegionAccessPointOperationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The request token associated with the request you want to know about. This request token is returned as part of the response when you make an asynchronous request. You provide this token to query about the status of the asynchronous action.</p>
        pub fn request_token_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_token_arn(input.into());
            self
        }
        /// <p>The request token associated with the request you want to know about. This request token is returned as part of the response when you make an asynchronous request. You provide this token to query about the status of the asynchronous action.</p>
        pub fn set_request_token_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_request_token_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccessPoint`.
    ///
    /// <p>Returns configuration information about the specified access point.</p>
    /// <p></p>
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html#API_control_GetAccessPoint_Examples">Examples</a> section.</p>
    /// <p>The following actions are related to <code>GetAccessPoint</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html">CreateAccessPoint</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html">DeleteAccessPoint</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html">ListAccessPoints</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAccessPoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_access_point_input::Builder,
    }
    impl GetAccessPoint {
        /// Creates a new `GetAccessPoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccessPointOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccessPointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the access point whose configuration information you want to retrieve.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /accesspoint/
        /// <my-accesspoint-name></my-accesspoint-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the access point whose configuration information you want to retrieve.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /accesspoint/
        /// <my-accesspoint-name></my-accesspoint-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccessPointConfigurationForObjectLambda`.
    ///
    /// <p>Returns configuration for an Object Lambda Access Point.</p>
    /// <p>The following actions are related to <code>GetAccessPointConfigurationForObjectLambda</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointConfigurationForObjectLambda.html">PutAccessPointConfigurationForObjectLambda</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAccessPointConfigurationForObjectLambda {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_access_point_configuration_for_object_lambda_input::Builder,
    }
    impl GetAccessPointConfigurationForObjectLambda {
        /// Creates a new `GetAccessPointConfigurationForObjectLambda`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccessPointConfigurationForObjectLambdaOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetAccessPointConfigurationForObjectLambdaError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the Object Lambda Access Point you want to return the configuration for.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the Object Lambda Access Point you want to return the configuration for.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccessPointForObjectLambda`.
    ///
    /// <p>Returns configuration information about the specified Object Lambda Access Point</p>
    /// <p>The following actions are related to <code>GetAccessPointForObjectLambda</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPointForObjectLambda.html">CreateAccessPointForObjectLambda</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointForObjectLambda.html">DeleteAccessPointForObjectLambda</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPointsForObjectLambda.html">ListAccessPointsForObjectLambda</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAccessPointForObjectLambda {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_access_point_for_object_lambda_input::Builder,
    }
    impl GetAccessPointForObjectLambda {
        /// Creates a new `GetAccessPointForObjectLambda`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccessPointForObjectLambdaOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccessPointForObjectLambdaError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccessPointPolicy`.
    ///
    /// <p>Returns the access point policy associated with the specified access point.</p>
    /// <p>The following actions are related to <code>GetAccessPointPolicy</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html">PutAccessPointPolicy</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html">DeleteAccessPointPolicy</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAccessPointPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_access_point_policy_input::Builder,
    }
    impl GetAccessPointPolicy {
        /// Creates a new `GetAccessPointPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccessPointPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccessPointPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the access point whose policy you want to retrieve.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /accesspoint/
        /// <my-accesspoint-name></my-accesspoint-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the access point whose policy you want to retrieve.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /accesspoint/
        /// <my-accesspoint-name></my-accesspoint-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccessPointPolicyForObjectLambda`.
    ///
    /// <p>Returns the resource policy for an Object Lambda Access Point.</p>
    /// <p>The following actions are related to <code>GetAccessPointPolicyForObjectLambda</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicyForObjectLambda.html">DeleteAccessPointPolicyForObjectLambda</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicyForObjectLambda.html">PutAccessPointPolicyForObjectLambda</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAccessPointPolicyForObjectLambda {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_access_point_policy_for_object_lambda_input::Builder,
    }
    impl GetAccessPointPolicyForObjectLambda {
        /// Creates a new `GetAccessPointPolicyForObjectLambda`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccessPointPolicyForObjectLambdaOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetAccessPointPolicyForObjectLambdaError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccessPointPolicyStatus`.
    ///
    /// <p>Indicates whether the specified access point currently has a policy that allows public access. For more information about public access through access points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">Managing Data Access with Amazon S3 access points</a> in the <i>Amazon S3 User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAccessPointPolicyStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_access_point_policy_status_input::Builder,
    }
    impl GetAccessPointPolicyStatus {
        /// Creates a new `GetAccessPointPolicyStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccessPointPolicyStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccessPointPolicyStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the access point whose policy status you want to retrieve.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the access point whose policy status you want to retrieve.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccessPointPolicyStatusForObjectLambda`.
    ///
    /// <p>Returns the status of the resource policy associated with an Object Lambda Access Point.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAccessPointPolicyStatusForObjectLambda {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_access_point_policy_status_for_object_lambda_input::Builder,
    }
    impl GetAccessPointPolicyStatusForObjectLambda {
        /// Creates a new `GetAccessPointPolicyStatusForObjectLambda`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccessPointPolicyStatusForObjectLambdaOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetAccessPointPolicyStatusForObjectLambdaError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucket`.
    ///
    /// <p>Gets an Amazon S3 on Outposts bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html"> Using Amazon S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>If you are using an identity other than the root user of the Amazon Web Services account that owns the Outposts bucket, the calling identity must have the <code>s3-outposts:GetBucket</code> permissions on the specified Outposts bucket and belong to the Outposts bucket owner's account in order to use this action. Only users from Outposts bucket owner account with the right permissions can perform actions on an Outposts bucket. </p>
    /// <p> If you don't have <code>s3-outposts:GetBucket</code> permissions or you're not using an identity that belongs to the bucket owner's account, Amazon S3 returns a <code>403 Access Denied</code> error.</p>
    /// <p>The following actions are related to <code>GetBucket</code> for Amazon S3 on Outposts:</p>
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucket.html#API_control_GetBucket_Examples">Examples</a> section.</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html">CreateBucket</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html">DeleteBucket</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBucket {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_bucket_input::Builder,
    }
    impl GetBucket {
        /// Creates a new `GetBucket`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketLifecycleConfiguration`.
    ///
    /// <note>
    /// <p>This action gets an Amazon S3 on Outposts bucket's lifecycle configuration. To get an S3 bucket's lifecycle configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html">GetBucketLifecycleConfiguration</a> in the <i>Amazon S3 API Reference</i>. </p>
    /// </note>
    /// <p>Returns the lifecycle configuration information set on the Outposts bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> and for information about lifecycle configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html"> Object Lifecycle Management</a> in <i>Amazon S3 User Guide</i>.</p>
    /// <p>To use this action, you must have permission to perform the <code>s3-outposts:GetLifecycleConfiguration</code> action. The Outposts bucket owner has this permission, by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p>
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html#API_control_GetBucketLifecycleConfiguration_Examples">Examples</a> section.</p>
    /// <p> <code>GetBucketLifecycleConfiguration</code> has the following special error:</p>
    /// <ul>
    /// <li> <p>Error code: <code>NoSuchLifecycleConfiguration</code> </p>
    /// <ul>
    /// <li> <p>Description: The lifecycle configuration does not exist.</p> </li>
    /// <li> <p>HTTP Status Code: 404 Not Found</p> </li>
    /// <li> <p>SOAP Fault Code Prefix: Client</p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p>The following actions are related to <code>GetBucketLifecycleConfiguration</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html">PutBucketLifecycleConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketLifecycleConfiguration.html">DeleteBucketLifecycleConfiguration</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBucketLifecycleConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_bucket_lifecycle_configuration_input::Builder,
    }
    impl GetBucketLifecycleConfiguration {
        /// Creates a new `GetBucketLifecycleConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketLifecycleConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketLifecycleConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketPolicy`.
    ///
    /// <note>
    /// <p>This action gets a bucket policy for an Amazon S3 on Outposts bucket. To get a policy for an S3 bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketPolicy.html">GetBucketPolicy</a> in the <i>Amazon S3 API Reference</i>. </p>
    /// </note>
    /// <p>Returns the policy of a specified Outposts bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>If you are using an identity other than the root user of the Amazon Web Services account that owns the bucket, the calling identity must have the <code>GetBucketPolicy</code> permissions on the specified bucket and belong to the bucket owner's account in order to use this action.</p>
    /// <p>Only users from Outposts bucket owner account with the right permissions can perform actions on an Outposts bucket. If you don't have <code>s3-outposts:GetBucketPolicy</code> permissions or you're not using an identity that belongs to the bucket owner's account, Amazon S3 returns a <code>403 Access Denied</code> error.</p> <important>
    /// <p>As a security precaution, the root user of the Amazon Web Services account that owns a bucket can always use this action, even if the policy explicitly denies the root user the ability to perform this action.</p>
    /// </important>
    /// <p>For more information about bucket policies, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies and User Policies</a>.</p>
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketPolicy.html#API_control_GetBucketPolicy_Examples">Examples</a> section.</p>
    /// <p>The following actions are related to <code>GetBucketPolicy</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketPolicy.html">PutBucketPolicy</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketPolicy.html">DeleteBucketPolicy</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBucketPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_bucket_policy_input::Builder,
    }
    impl GetBucketPolicy {
        /// Creates a new `GetBucketPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketTagging`.
    ///
    /// <note>
    /// <p>This action gets an Amazon S3 on Outposts bucket's tags. To get an S3 bucket tags, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketTagging.html">GetBucketTagging</a> in the <i>Amazon S3 API Reference</i>. </p>
    /// </note>
    /// <p>Returns the tag set associated with the Outposts bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>To use this action, you must have permission to perform the <code>GetBucketTagging</code> action. By default, the bucket owner has this permission and can grant this permission to others.</p>
    /// <p> <code>GetBucketTagging</code> has the following special error:</p>
    /// <ul>
    /// <li> <p>Error code: <code>NoSuchTagSetError</code> </p>
    /// <ul>
    /// <li> <p>Description: There is no tag set associated with the bucket.</p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketTagging.html#API_control_GetBucketTagging_Examples">Examples</a> section.</p>
    /// <p>The following actions are related to <code>GetBucketTagging</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html">PutBucketTagging</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketTagging.html">DeleteBucketTagging</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBucketTagging {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_bucket_tagging_input::Builder,
    }
    impl GetBucketTagging {
        /// Creates a new `GetBucketTagging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketTaggingOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketTaggingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetJobTagging`.
    ///
    /// <p>Returns the tags on an S3 Batch Operations job. To use this operation, you must have permission to perform the <code>s3:GetJobTagging</code> action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags">Controlling access and labeling jobs using tags</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p></p>
    /// <p>Related actions include:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutJobTagging.html">PutJobTagging</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteJobTagging.html">DeleteJobTagging</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetJobTagging {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_job_tagging_input::Builder,
    }
    impl GetJobTagging {
        /// Creates a new `GetJobTagging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetJobTaggingOutput,
            aws_smithy_http::result::SdkError<crate::error::GetJobTaggingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The ID for the S3 Batch Operations job whose tags you want to retrieve.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID for the S3 Batch Operations job whose tags you want to retrieve.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMultiRegionAccessPoint`.
    ///
    /// <p>Returns configuration information about the specified Multi-Region Access Point.</p>
    /// <p>This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around managing Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>The following actions are related to <code>GetMultiRegionAccessPoint</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html">CreateMultiRegionAccessPoint</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html">DeleteMultiRegionAccessPoint</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html">ListMultiRegionAccessPoints</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMultiRegionAccessPoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_multi_region_access_point_input::Builder,
    }
    impl GetMultiRegionAccessPoint {
        /// Creates a new `GetMultiRegionAccessPoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMultiRegionAccessPointOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMultiRegionAccessPointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the Multi-Region Access Point whose configuration information you want to receive. The name of the Multi-Region Access Point is different from the alias. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the Multi-Region Access Point whose configuration information you want to receive. The name of the Multi-Region Access Point is different from the alias. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMultiRegionAccessPointPolicy`.
    ///
    /// <p>Returns the access control policy of the specified Multi-Region Access Point.</p>
    /// <p>This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around managing Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>The following actions are related to <code>GetMultiRegionAccessPointPolicy</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicyStatus.html">GetMultiRegionAccessPointPolicyStatus</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPointPolicy.html">PutMultiRegionAccessPointPolicy</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMultiRegionAccessPointPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_multi_region_access_point_policy_input::Builder,
    }
    impl GetMultiRegionAccessPointPolicy {
        /// Creates a new `GetMultiRegionAccessPointPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMultiRegionAccessPointPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMultiRegionAccessPointPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>Specifies the Multi-Region Access Point. The name of the Multi-Region Access Point is different from the alias. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>Specifies the Multi-Region Access Point. The name of the Multi-Region Access Point is different from the alias. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMultiRegionAccessPointPolicyStatus`.
    ///
    /// <p>Indicates whether the specified Multi-Region Access Point has an access control policy that allows public access.</p>
    /// <p>This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around managing Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>The following actions are related to <code>GetMultiRegionAccessPointPolicyStatus</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicy.html">GetMultiRegionAccessPointPolicy</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPointPolicy.html">PutMultiRegionAccessPointPolicy</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMultiRegionAccessPointPolicyStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_multi_region_access_point_policy_status_input::Builder,
    }
    impl GetMultiRegionAccessPointPolicyStatus {
        /// Creates a new `GetMultiRegionAccessPointPolicyStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMultiRegionAccessPointPolicyStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetMultiRegionAccessPointPolicyStatusError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>Specifies the Multi-Region Access Point. The name of the Multi-Region Access Point is different from the alias. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>Specifies the Multi-Region Access Point. The name of the Multi-Region Access Point is different from the alias. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPublicAccessBlock`.
    ///
    /// <p>Retrieves the <code>PublicAccessBlock</code> configuration for an Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html"> Using Amazon S3 block public access</a>.</p>
    /// <p>Related actions include:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeletePublicAccessBlock.html">DeletePublicAccessBlock</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutPublicAccessBlock.html">PutPublicAccessBlock</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPublicAccessBlock {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_public_access_block_input::Builder,
    }
    impl GetPublicAccessBlock {
        /// Creates a new `GetPublicAccessBlock`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPublicAccessBlockOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPublicAccessBlockError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want to retrieve.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want to retrieve.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStorageLensConfiguration`.
    ///
    /// <p>Gets the Amazon S3 Storage Lens configuration. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage activity and usage with Amazon S3 Storage Lens </a> in the <i>Amazon S3 User Guide</i>.</p> <note>
    /// <p>To use this action, you must have permission to perform the <code>s3:GetStorageLensConfiguration</code> action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to use Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetStorageLensConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_storage_lens_configuration_input::Builder,
    }
    impl GetStorageLensConfiguration {
        /// Creates a new `GetStorageLensConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStorageLensConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStorageLensConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon S3 Storage Lens configuration.</p>
        pub fn config_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_id(input.into());
            self
        }
        /// <p>The ID of the Amazon S3 Storage Lens configuration.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_config_id(input);
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStorageLensConfigurationTagging`.
    ///
    /// <p>Gets the tags of Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage activity and usage with Amazon S3 Storage Lens </a> in the <i>Amazon S3 User Guide</i>.</p> <note>
    /// <p>To use this action, you must have permission to perform the <code>s3:GetStorageLensConfigurationTagging</code> action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to use Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetStorageLensConfigurationTagging {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_storage_lens_configuration_tagging_input::Builder,
    }
    impl GetStorageLensConfigurationTagging {
        /// Creates a new `GetStorageLensConfigurationTagging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStorageLensConfigurationTaggingOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetStorageLensConfigurationTaggingError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon S3 Storage Lens configuration.</p>
        pub fn config_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_id(input.into());
            self
        }
        /// <p>The ID of the Amazon S3 Storage Lens configuration.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_config_id(input);
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccessPoints`.
    ///
    /// <p>Returns a list of the access points currently associated with the specified bucket. You can retrieve up to 1000 access points per call. If the specified bucket has more than 1,000 access points (or the number specified in <code>maxResults</code>, whichever is less), the response will include a continuation token that you can use to list the additional access points.</p>
    /// <p></p>
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html#API_control_GetAccessPoint_Examples">Examples</a> section.</p>
    /// <p>The following actions are related to <code>ListAccessPoints</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html">CreateAccessPoint</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html">DeleteAccessPoint</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html">GetAccessPoint</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAccessPoints {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_access_points_input::Builder,
    }
    impl ListAccessPoints {
        /// Creates a new `ListAccessPoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccessPointsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAccessPointsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAccessPointsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAccessPointsPaginator {
            crate::paginator::ListAccessPointsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Web Services account ID for owner of the bucket whose access points you want to list.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for owner of the bucket whose access points you want to list.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the bucket whose associated access points you want to list.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket whose associated access points you want to list.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>A continuation token. If a previous call to <code>ListAccessPoints</code> returned a continuation token in the <code>NextToken</code> field, then providing that value here causes Amazon S3 to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A continuation token. If a previous call to <code>ListAccessPoints</code> returned a continuation token in the <code>NextToken</code> field, then providing that value here causes Amazon S3 to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of access points that you want to include in the list. If the specified bucket has more than this number of access points, then the response will include a continuation token in the <code>NextToken</code> field that you can use to retrieve the next page of access points.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of access points that you want to include in the list. If the specified bucket has more than this number of access points, then the response will include a continuation token in the <code>NextToken</code> field that you can use to retrieve the next page of access points.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccessPointsForObjectLambda`.
    ///
    /// <p>Returns some or all (up to 1,000) access points associated with the Object Lambda Access Point per call. If there are more access points than what can be returned in one call, the response will include a continuation token that you can use to list the additional access points.</p>
    /// <p>The following actions are related to <code>ListAccessPointsForObjectLambda</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPointForObjectLambda.html">CreateAccessPointForObjectLambda</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointForObjectLambda.html">DeleteAccessPointForObjectLambda</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointForObjectLambda.html">GetAccessPointForObjectLambda</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAccessPointsForObjectLambda {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_access_points_for_object_lambda_input::Builder,
    }
    impl ListAccessPointsForObjectLambda {
        /// Creates a new `ListAccessPointsForObjectLambda`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccessPointsForObjectLambdaOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAccessPointsForObjectLambdaError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAccessPointsForObjectLambdaPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAccessPointsForObjectLambdaPaginator {
            crate::paginator::ListAccessPointsForObjectLambdaPaginator::new(self.handle, self.inner)
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>If the list has more access points than can be returned in one call to this API, this field contains a continuation token that you can provide in subsequent calls to this API to retrieve additional access points.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the list has more access points than can be returned in one call to this API, this field contains a continuation token that you can provide in subsequent calls to this API to retrieve additional access points.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of access points that you want to include in the list. The response may contain fewer access points but will never contain more. If there are more than this number of access points, then the response will include a continuation token in the <code>NextToken</code> field that you can use to retrieve the next page of access points.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of access points that you want to include in the list. The response may contain fewer access points but will never contain more. If there are more than this number of access points, then the response will include a continuation token in the <code>NextToken</code> field that you can use to retrieve the next page of access points.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJobs`.
    ///
    /// <p>Lists current S3 Batch Operations jobs and jobs that have ended within the last 30 days for the Amazon Web Services account making the request. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html">S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Related actions include:</p>
    /// <p></p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html">DescribeJob</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobPriority.html">UpdateJobPriority</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html">UpdateJobStatus</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListJobs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_jobs_input::Builder,
    }
    impl ListJobs {
        /// Creates a new `ListJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListJobsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListJobsPaginator {
            crate::paginator::ListJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// Appends an item to `JobStatuses`.
        ///
        /// To override the contents of this collection use [`set_job_statuses`](Self::set_job_statuses).
        ///
        /// <p>The <code>List Jobs</code> request returns jobs that match the statuses listed in this element.</p>
        pub fn job_statuses(mut self, input: crate::model::JobStatus) -> Self {
            self.inner = self.inner.job_statuses(input);
            self
        }
        /// <p>The <code>List Jobs</code> request returns jobs that match the statuses listed in this element.</p>
        pub fn set_job_statuses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobStatus>>,
        ) -> Self {
            self.inner = self.inner.set_job_statuses(input);
            self
        }
        /// <p>A pagination token to request the next page of results. Use the token that Amazon S3 returned in the <code>NextToken</code> element of the <code>ListJobsResult</code> from the previous <code>List Jobs</code> request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token to request the next page of results. Use the token that Amazon S3 returned in the <code>NextToken</code> element of the <code>ListJobsResult</code> from the previous <code>List Jobs</code> request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of jobs that Amazon S3 will include in the <code>List Jobs</code> response. If there are more jobs than this number, the response will include a pagination token in the <code>NextToken</code> field to enable you to retrieve the next page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of jobs that Amazon S3 will include in the <code>List Jobs</code> response. If there are more jobs than this number, the response will include a pagination token in the <code>NextToken</code> field to enable you to retrieve the next page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMultiRegionAccessPoints`.
    ///
    /// <p>Returns a list of the Multi-Region Access Points currently associated with the specified Amazon Web Services account. Each call can return up to 100 Multi-Region Access Points, the maximum number of Multi-Region Access Points that can be associated with a single account.</p>
    /// <p>This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around managing Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>The following actions are related to <code>ListMultiRegionAccessPoint</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html">CreateMultiRegionAccessPoint</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html">DeleteMultiRegionAccessPoint</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html">GetMultiRegionAccessPoint</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListMultiRegionAccessPoints {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_multi_region_access_points_input::Builder,
    }
    impl ListMultiRegionAccessPoints {
        /// Creates a new `ListMultiRegionAccessPoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMultiRegionAccessPointsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMultiRegionAccessPointsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListMultiRegionAccessPointsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListMultiRegionAccessPointsPaginator {
            crate::paginator::ListMultiRegionAccessPointsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>Not currently used. Do not use this parameter.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Not currently used. Do not use this parameter.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Not currently used. Do not use this parameter.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Not currently used. Do not use this parameter.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRegionalBuckets`.
    ///
    /// <p>Returns a list of all Outposts buckets in an Outpost that are owned by the authenticated sender of the request. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and <code>x-amz-outpost-id</code> in your request, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListRegionalBuckets.html#API_control_ListRegionalBuckets_Examples">Examples</a> section.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRegionalBuckets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_regional_buckets_input::Builder,
    }
    impl ListRegionalBuckets {
        /// Creates a new `ListRegionalBuckets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRegionalBucketsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRegionalBucketsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRegionalBucketsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListRegionalBucketsPaginator {
            crate::paginator::ListRegionalBucketsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p></p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p></p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p></p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p></p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The ID of the Outposts.</p> <note>
        /// <p>This is required by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn outpost_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.outpost_id(input.into());
            self
        }
        /// <p>The ID of the Outposts.</p> <note>
        /// <p>This is required by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_outpost_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_outpost_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStorageLensConfigurations`.
    ///
    /// <p>Gets a list of Amazon S3 Storage Lens configurations. For more information about S3 Storage Lens, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage activity and usage with Amazon S3 Storage Lens </a> in the <i>Amazon S3 User Guide</i>.</p> <note>
    /// <p>To use this action, you must have permission to perform the <code>s3:ListStorageLensConfigurations</code> action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to use Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListStorageLensConfigurations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_storage_lens_configurations_input::Builder,
    }
    impl ListStorageLensConfigurations {
        /// Creates a new `ListStorageLensConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStorageLensConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStorageLensConfigurationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListStorageLensConfigurationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListStorageLensConfigurationsPaginator {
            crate::paginator::ListStorageLensConfigurationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The account ID of the requester.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>A pagination token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAccessPointConfigurationForObjectLambda`.
    ///
    /// <p>Replaces configuration for an Object Lambda Access Point.</p>
    /// <p>The following actions are related to <code>PutAccessPointConfigurationForObjectLambda</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointConfigurationForObjectLambda.html">GetAccessPointConfigurationForObjectLambda</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutAccessPointConfigurationForObjectLambda {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_access_point_configuration_for_object_lambda_input::Builder,
    }
    impl PutAccessPointConfigurationForObjectLambda {
        /// Creates a new `PutAccessPointConfigurationForObjectLambda`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAccessPointConfigurationForObjectLambdaOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutAccessPointConfigurationForObjectLambdaError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Object Lambda Access Point configuration document.</p>
        pub fn configuration(mut self, input: crate::model::ObjectLambdaConfiguration) -> Self {
            self.inner = self.inner.configuration(input);
            self
        }
        /// <p>Object Lambda Access Point configuration document.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ObjectLambdaConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAccessPointPolicy`.
    ///
    /// <p>Associates an access policy with the specified access point. Each access point can have only one policy, so a request made to this API replaces any existing policy associated with the specified access point.</p>
    /// <p></p>
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html#API_control_PutAccessPointPolicy_Examples">Examples</a> section.</p>
    /// <p>The following actions are related to <code>PutAccessPointPolicy</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicy.html">GetAccessPointPolicy</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html">DeleteAccessPointPolicy</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutAccessPointPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_access_point_policy_input::Builder,
    }
    impl PutAccessPointPolicy {
        /// Creates a new `PutAccessPointPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAccessPointPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAccessPointPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID for owner of the bucket associated with the specified access point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for owner of the bucket associated with the specified access point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the access point that you want to associate with the specified policy.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /accesspoint/
        /// <my-accesspoint-name></my-accesspoint-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the access point that you want to associate with the specified policy.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /accesspoint/
        /// <my-accesspoint-name></my-accesspoint-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The policy that you want to apply to the specified access point. For more information about access point policies, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">Managing data access with Amazon S3 access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>The policy that you want to apply to the specified access point. For more information about access point policies, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">Managing data access with Amazon S3 access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAccessPointPolicyForObjectLambda`.
    ///
    /// <p>Creates or replaces resource policy for an Object Lambda Access Point. For an example policy, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/olap-create.html#olap-create-cli">Creating Object Lambda Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>The following actions are related to <code>PutAccessPointPolicyForObjectLambda</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicyForObjectLambda.html">DeleteAccessPointPolicyForObjectLambda</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicyForObjectLambda.html">GetAccessPointPolicyForObjectLambda</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutAccessPointPolicyForObjectLambda {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_access_point_policy_for_object_lambda_input::Builder,
    }
    impl PutAccessPointPolicyForObjectLambda {
        /// Creates a new `PutAccessPointPolicyForObjectLambda`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAccessPointPolicyForObjectLambdaOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutAccessPointPolicyForObjectLambdaError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Object Lambda Access Point resource policy document.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>Object Lambda Access Point resource policy document.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBucketLifecycleConfiguration`.
    ///
    /// <note>
    /// <p>This action puts a lifecycle configuration to an Amazon S3 on Outposts bucket. To put a lifecycle configuration to an S3 bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html">PutBucketLifecycleConfiguration</a> in the <i>Amazon S3 API Reference</i>. </p>
    /// </note>
    /// <p>Creates a new lifecycle configuration for the S3 on Outposts bucket or replaces an existing lifecycle configuration. Outposts buckets only support lifecycle configurations that delete/expire objects after a certain period of time and abort incomplete multipart uploads.</p>
    /// <p></p>
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html#API_control_PutBucketLifecycleConfiguration_Examples">Examples</a> section.</p>
    /// <p>The following actions are related to <code>PutBucketLifecycleConfiguration</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html">GetBucketLifecycleConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketLifecycleConfiguration.html">DeleteBucketLifecycleConfiguration</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutBucketLifecycleConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_bucket_lifecycle_configuration_input::Builder,
    }
    impl PutBucketLifecycleConfiguration {
        /// Creates a new `PutBucketLifecycleConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBucketLifecycleConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBucketLifecycleConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the bucket for which to set the configuration.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket for which to set the configuration.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>Container for lifecycle rules. You can add as many as 1,000 rules.</p>
        pub fn lifecycle_configuration(
            mut self,
            input: crate::model::LifecycleConfiguration,
        ) -> Self {
            self.inner = self.inner.lifecycle_configuration(input);
            self
        }
        /// <p>Container for lifecycle rules. You can add as many as 1,000 rules.</p>
        pub fn set_lifecycle_configuration(
            mut self,
            input: std::option::Option<crate::model::LifecycleConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_lifecycle_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBucketPolicy`.
    ///
    /// <note>
    /// <p>This action puts a bucket policy to an Amazon S3 on Outposts bucket. To put a policy on an S3 bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketPolicy.html">PutBucketPolicy</a> in the <i>Amazon S3 API Reference</i>. </p>
    /// </note>
    /// <p>Applies an Amazon S3 bucket policy to an Outposts bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>If you are using an identity other than the root user of the Amazon Web Services account that owns the Outposts bucket, the calling identity must have the <code>PutBucketPolicy</code> permissions on the specified Outposts bucket and belong to the bucket owner's account in order to use this action.</p>
    /// <p>If you don't have <code>PutBucketPolicy</code> permissions, Amazon S3 returns a <code>403 Access Denied</code> error. If you have the correct permissions, but you're not using an identity that belongs to the bucket owner's account, Amazon S3 returns a <code>405 Method Not Allowed</code> error.</p> <important>
    /// <p> As a security precaution, the root user of the Amazon Web Services account that owns a bucket can always use this action, even if the policy explicitly denies the root user the ability to perform this action. </p>
    /// </important>
    /// <p>For more information about bucket policies, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies and User Policies</a>.</p>
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketPolicy.html#API_control_PutBucketPolicy_Examples">Examples</a> section.</p>
    /// <p>The following actions are related to <code>PutBucketPolicy</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketPolicy.html">GetBucketPolicy</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketPolicy.html">DeleteBucketPolicy</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutBucketPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_bucket_policy_input::Builder,
    }
    impl PutBucketPolicy {
        /// Creates a new `PutBucketPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBucketPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBucketPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>Set this parameter to true to confirm that you want to remove your permissions to change this bucket policy in the future.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn confirm_remove_self_bucket_access(mut self, input: bool) -> Self {
            self.inner = self.inner.confirm_remove_self_bucket_access(input);
            self
        }
        /// <p>Set this parameter to true to confirm that you want to remove your permissions to change this bucket policy in the future.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_confirm_remove_self_bucket_access(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_confirm_remove_self_bucket_access(input);
            self
        }
        /// <p>The bucket policy as a JSON document.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>The bucket policy as a JSON document.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBucketTagging`.
    ///
    /// <note>
    /// <p>This action puts tags on an Amazon S3 on Outposts bucket. To put tags on an S3 bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketTagging.html">PutBucketTagging</a> in the <i>Amazon S3 API Reference</i>. </p>
    /// </note>
    /// <p>Sets the tags for an S3 on Outposts bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Use tags to organize your Amazon Web Services bill to reflect your own cost structure. To do this, sign up to get your Amazon Web Services account bill with tag key values included. Then, to see the cost of combined resources, organize your billing information according to resources with the same tag key values. For example, you can tag several resources with a specific application name, and then organize your billing information to see the total cost of that application across several services. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Cost allocation and tagging</a>.</p> <note>
    /// <p>Within a bucket, if you add a tag that has the same key as an existing tag, the new value overwrites the old value. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CostAllocTagging.html"> Using cost allocation in Amazon S3 bucket tags</a>.</p>
    /// </note>
    /// <p>To use this action, you must have permissions to perform the <code>s3-outposts:PutBucketTagging</code> action. The Outposts bucket owner has this permission by default and can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"> Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing access permissions to your Amazon S3 resources</a>.</p>
    /// <p> <code>PutBucketTagging</code> has the following special errors:</p>
    /// <ul>
    /// <li> <p>Error code: <code>InvalidTagError</code> </p>
    /// <ul>
    /// <li> <p>Description: The tag provided was not a valid tag. This error can occur if the tag did not pass input validation. For information about tag restrictions, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html"> User-Defined Tag Restrictions</a> and <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/aws-tag-restrictions.html"> Amazon Web Services-Generated Cost Allocation Tag Restrictions</a>.</p> </li>
    /// </ul> </li>
    /// <li> <p>Error code: <code>MalformedXMLError</code> </p>
    /// <ul>
    /// <li> <p>Description: The XML provided does not match the schema.</p> </li>
    /// </ul> </li>
    /// <li> <p>Error code: <code>OperationAbortedError </code> </p>
    /// <ul>
    /// <li> <p>Description: A conflicting conditional action is currently in progress against this resource. Try again.</p> </li>
    /// </ul> </li>
    /// <li> <p>Error code: <code>InternalError</code> </p>
    /// <ul>
    /// <li> <p>Description: The service was unable to apply the provided tag to the bucket.</p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html#API_control_PutBucketTagging_Examples">Examples</a> section.</p>
    /// <p>The following actions are related to <code>PutBucketTagging</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketTagging.html">GetBucketTagging</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketTagging.html">DeleteBucketTagging</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutBucketTagging {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_bucket_tagging_input::Builder,
    }
    impl PutBucketTagging {
        /// Creates a new `PutBucketTagging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBucketTaggingOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBucketTaggingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p></p>
        pub fn tagging(mut self, input: crate::model::Tagging) -> Self {
            self.inner = self.inner.tagging(input);
            self
        }
        /// <p></p>
        pub fn set_tagging(mut self, input: std::option::Option<crate::model::Tagging>) -> Self {
            self.inner = self.inner.set_tagging(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutJobTagging`.
    ///
    /// <p>Sets the supplied tag-set on an S3 Batch Operations job.</p>
    /// <p>A tag is a key-value pair. You can associate S3 Batch Operations tags with any job by sending a PUT request against the tagging subresource that is associated with the job. To modify the existing tag set, you can either replace the existing tag set entirely, or make changes within the existing tag set by retrieving the existing tag set using <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetJobTagging.html">GetJobTagging</a>, modify that tag set, and use this action to replace the tag set with the one you modified. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags">Controlling access and labeling jobs using tags</a> in the <i>Amazon S3 User Guide</i>. </p>
    /// <p></p> <note>
    /// <ul>
    /// <li> <p>If you send this request with an empty tag set, Amazon S3 deletes the existing tag set on the Batch Operations job. If you use this method, you are charged for a Tier 1 Request (PUT). For more information, see <a href="http://aws.amazon.com/s3/pricing/">Amazon S3 pricing</a>.</p> </li>
    /// <li> <p>For deleting existing tags for your Batch Operations job, a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteJobTagging.html">DeleteJobTagging</a> request is preferred because it achieves the same result without incurring charges.</p> </li>
    /// <li> <p>A few things to consider about using tags:</p>
    /// <ul>
    /// <li> <p>Amazon S3 limits the maximum number of tags to 50 tags per job.</p> </li>
    /// <li> <p>You can associate up to 50 tags with a job as long as they have unique tag keys.</p> </li>
    /// <li> <p>A tag key can be up to 128 Unicode characters in length, and tag values can be up to 256 Unicode characters in length.</p> </li>
    /// <li> <p>The key and values are case sensitive.</p> </li>
    /// <li> <p>For tagging-related restrictions related to characters and encodings, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html">User-Defined Tag Restrictions</a> in the <i>Billing and Cost Management User Guide</i>.</p> </li>
    /// </ul> </li>
    /// </ul>
    /// </note>
    /// <p></p>
    /// <p>To use this action, you must have permission to perform the <code>s3:PutJobTagging</code> action.</p>
    /// <p>Related actions include:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreatJob</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetJobTagging.html">GetJobTagging</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteJobTagging.html">DeleteJobTagging</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutJobTagging {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_job_tagging_input::Builder,
    }
    impl PutJobTagging {
        /// Creates a new `PutJobTagging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutJobTaggingOutput,
            aws_smithy_http::result::SdkError<crate::error::PutJobTaggingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The ID for the S3 Batch Operations job whose tags you want to replace.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID for the S3 Batch Operations job whose tags you want to replace.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The set of tags to associate with the S3 Batch Operations job.</p>
        pub fn tags(mut self, input: crate::model::S3Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The set of tags to associate with the S3 Batch Operations job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutMultiRegionAccessPointPolicy`.
    ///
    /// <p>Associates an access control policy with the specified Multi-Region Access Point. Each Multi-Region Access Point can have only one policy, so a request made to this action replaces any existing policy that is associated with the specified Multi-Region Access Point.</p>
    /// <p>This action will always be routed to the US West (Oregon) Region. For more information about the restrictions around managing Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>The following actions are related to <code>PutMultiRegionAccessPointPolicy</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicy.html">GetMultiRegionAccessPointPolicy</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicyStatus.html">GetMultiRegionAccessPointPolicyStatus</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutMultiRegionAccessPointPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_multi_region_access_point_policy_input::Builder,
    }
    impl PutMultiRegionAccessPointPolicy {
        /// Creates a new `PutMultiRegionAccessPointPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutMultiRegionAccessPointPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutMultiRegionAccessPointPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>An idempotency token used to identify the request and guarantee that requests are unique.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>An idempotency token used to identify the request and guarantee that requests are unique.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>A container element containing the details of the policy for the Multi-Region Access Point.</p>
        pub fn details(
            mut self,
            input: crate::model::PutMultiRegionAccessPointPolicyInput,
        ) -> Self {
            self.inner = self.inner.details(input);
            self
        }
        /// <p>A container element containing the details of the policy for the Multi-Region Access Point.</p>
        pub fn set_details(
            mut self,
            input: std::option::Option<crate::model::PutMultiRegionAccessPointPolicyInput>,
        ) -> Self {
            self.inner = self.inner.set_details(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutPublicAccessBlock`.
    ///
    /// <p>Creates or modifies the <code>PublicAccessBlock</code> configuration for an Amazon Web Services account. For this operation, users must have the <code>s3:PutBucketPublicAccessBlock</code> permission. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html"> Using Amazon S3 block public access</a>.</p>
    /// <p>Related actions include:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetPublicAccessBlock.html">GetPublicAccessBlock</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeletePublicAccessBlock.html">DeletePublicAccessBlock</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutPublicAccessBlock {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_public_access_block_input::Builder,
    }
    impl PutPublicAccessBlock {
        /// Creates a new `PutPublicAccessBlock`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutPublicAccessBlockOutput,
            aws_smithy_http::result::SdkError<crate::error::PutPublicAccessBlockError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>PublicAccessBlock</code> configuration that you want to apply to the specified Amazon Web Services account.</p>
        pub fn public_access_block_configuration(
            mut self,
            input: crate::model::PublicAccessBlockConfiguration,
        ) -> Self {
            self.inner = self.inner.public_access_block_configuration(input);
            self
        }
        /// <p>The <code>PublicAccessBlock</code> configuration that you want to apply to the specified Amazon Web Services account.</p>
        pub fn set_public_access_block_configuration(
            mut self,
            input: std::option::Option<crate::model::PublicAccessBlockConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_public_access_block_configuration(input);
            self
        }
        /// <p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want to set.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want to set.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutStorageLensConfiguration`.
    ///
    /// <p>Puts an Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Working with Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.</p> <note>
    /// <p>To use this action, you must have permission to perform the <code>s3:PutStorageLensConfiguration</code> action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to use Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutStorageLensConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_storage_lens_configuration_input::Builder,
    }
    impl PutStorageLensConfiguration {
        /// Creates a new `PutStorageLensConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutStorageLensConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutStorageLensConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the S3 Storage Lens configuration.</p>
        pub fn config_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_id(input.into());
            self
        }
        /// <p>The ID of the S3 Storage Lens configuration.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_config_id(input);
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The S3 Storage Lens configuration.</p>
        pub fn storage_lens_configuration(
            mut self,
            input: crate::model::StorageLensConfiguration,
        ) -> Self {
            self.inner = self.inner.storage_lens_configuration(input);
            self
        }
        /// <p>The S3 Storage Lens configuration.</p>
        pub fn set_storage_lens_configuration(
            mut self,
            input: std::option::Option<crate::model::StorageLensConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_storage_lens_configuration(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag set of the S3 Storage Lens configuration.</p> <note>
        /// <p>You can set up to a maximum of 50 tags.</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::StorageLensTag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tag set of the S3 Storage Lens configuration.</p> <note>
        /// <p>You can set up to a maximum of 50 tags.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StorageLensTag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutStorageLensConfigurationTagging`.
    ///
    /// <p>Put or replace tags on an existing Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage activity and usage with Amazon S3 Storage Lens </a> in the <i>Amazon S3 User Guide</i>.</p> <note>
    /// <p>To use this action, you must have permission to perform the <code>s3:PutStorageLensConfigurationTagging</code> action. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to use Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutStorageLensConfigurationTagging {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_storage_lens_configuration_tagging_input::Builder,
    }
    impl PutStorageLensConfigurationTagging {
        /// Creates a new `PutStorageLensConfigurationTagging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutStorageLensConfigurationTaggingOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutStorageLensConfigurationTaggingError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the S3 Storage Lens configuration.</p>
        pub fn config_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_id(input.into());
            self
        }
        /// <p>The ID of the S3 Storage Lens configuration.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_config_id(input);
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag set of the S3 Storage Lens configuration.</p> <note>
        /// <p>You can set up to a maximum of 50 tags.</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::StorageLensTag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tag set of the S3 Storage Lens configuration.</p> <note>
        /// <p>You can set up to a maximum of 50 tags.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StorageLensTag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateJobPriority`.
    ///
    /// <p>Updates an existing S3 Batch Operations job's priority. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html">S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p></p>
    /// <p>Related actions include:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html">ListJobs</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html">DescribeJob</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html">UpdateJobStatus</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateJobPriority {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_job_priority_input::Builder,
    }
    impl UpdateJobPriority {
        /// Creates a new `UpdateJobPriority`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateJobPriorityOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateJobPriorityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The ID for the job whose priority you want to update.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID for the job whose priority you want to update.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The priority you want to assign to this job.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.inner = self.inner.priority(input);
            self
        }
        /// <p>The priority you want to assign to this job.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_priority(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateJobStatus`.
    ///
    /// <p>Updates the status for the specified job. Use this action to confirm that you want to run a job or to cancel an existing job. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html">S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p></p>
    /// <p>Related actions include:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html">ListJobs</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html">DescribeJob</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html">UpdateJobStatus</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateJobStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_job_status_input::Builder,
    }
    impl UpdateJobStatus {
        /// Creates a new `UpdateJobStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateJobStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateJobStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The ID of the job whose status you want to update.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The ID of the job whose status you want to update.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The status that you want to move the specified job to.</p>
        pub fn requested_job_status(mut self, input: crate::model::RequestedJobStatus) -> Self {
            self.inner = self.inner.requested_job_status(input);
            self
        }
        /// <p>The status that you want to move the specified job to.</p>
        pub fn set_requested_job_status(
            mut self,
            input: std::option::Option<crate::model::RequestedJobStatus>,
        ) -> Self {
            self.inner = self.inner.set_requested_job_status(input);
            self
        }
        /// <p>A description of the reason why you want to change the specified job's status. This field can be any string up to the maximum length.</p>
        pub fn status_update_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status_update_reason(input.into());
            self
        }
        /// <p>A description of the reason why you want to change the specified job's status. This field can be any string up to the maximum length.</p>
        pub fn set_status_update_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_status_update_reason(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
