// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateAccessPointInput`](crate::input::CreateAccessPointInput)
pub mod create_access_point_input {
    /// A builder for [`CreateAccessPointInput`](crate::input::CreateAccessPointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) vpc_configuration: std::option::Option<crate::model::VpcConfiguration>,
        pub(crate) public_access_block_configuration:
            std::option::Option<crate::model::PublicAccessBlockConfiguration>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID for the owner of the bucket for which you want to create an access point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the owner of the bucket for which you want to create an access point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name you want to assign to this access point.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name you want to assign to this access point.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the bucket that you want to associate this access point with.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket that you want to associate this access point with.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>If you include this field, Amazon S3 restricts access to this access point to requests from the specified virtual private cloud (VPC).</p> <note>
        /// <p>This is required for creating an access point for Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn vpc_configuration(mut self, input: crate::model::VpcConfiguration) -> Self {
            self.vpc_configuration = Some(input);
            self
        }
        /// <p>If you include this field, Amazon S3 restricts access to this access point to requests from the specified virtual private cloud (VPC).</p> <note>
        /// <p>This is required for creating an access point for Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_vpc_configuration(
            mut self,
            input: std::option::Option<crate::model::VpcConfiguration>,
        ) -> Self {
            self.vpc_configuration = input;
            self
        }
        /// <p> The <code>PublicAccessBlock</code> configuration that you want to apply to the access point. </p>
        pub fn public_access_block_configuration(
            mut self,
            input: crate::model::PublicAccessBlockConfiguration,
        ) -> Self {
            self.public_access_block_configuration = Some(input);
            self
        }
        /// <p> The <code>PublicAccessBlock</code> configuration that you want to apply to the access point. </p>
        pub fn set_public_access_block_configuration(
            mut self,
            input: std::option::Option<crate::model::PublicAccessBlockConfiguration>,
        ) -> Self {
            self.public_access_block_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAccessPointInput`](crate::input::CreateAccessPointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAccessPointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAccessPointInput {
                account_id: self.account_id,
                name: self.name,
                bucket: self.bucket,
                vpc_configuration: self.vpc_configuration,
                public_access_block_configuration: self.public_access_block_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAccessPointInputOperationOutputAlias = crate::operation::CreateAccessPoint;
#[doc(hidden)]
pub type CreateAccessPointInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAccessPointInput {
    /// Consumes the builder and constructs an Operation<[`CreateAccessPoint`](crate::operation::CreateAccessPoint)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAccessPoint,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAccessPointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.name;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_1, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v20180820/accesspoint/{Name}", Name = name)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAccessPointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_create_access_point(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAccessPointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_access_point(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAccessPoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAccessPoint",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAccessPointInput`](crate::input::CreateAccessPointInput)
    pub fn builder() -> crate::input::create_access_point_input::Builder {
        crate::input::create_access_point_input::Builder::default()
    }
}

/// See [`CreateAccessPointForObjectLambdaInput`](crate::input::CreateAccessPointForObjectLambdaInput)
pub mod create_access_point_for_object_lambda_input {
    /// A builder for [`CreateAccessPointForObjectLambdaInput`](crate::input::CreateAccessPointForObjectLambdaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) configuration: std::option::Option<crate::model::ObjectLambdaConfiguration>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID for owner of the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for owner of the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name you want to assign to this Object Lambda Access Point.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name you want to assign to this Object Lambda Access Point.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Object Lambda Access Point configuration as a JSON document.</p>
        pub fn configuration(mut self, input: crate::model::ObjectLambdaConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>Object Lambda Access Point configuration as a JSON document.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ObjectLambdaConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAccessPointForObjectLambdaInput`](crate::input::CreateAccessPointForObjectLambdaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAccessPointForObjectLambdaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAccessPointForObjectLambdaInput {
                account_id: self.account_id,
                name: self.name,
                configuration: self.configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAccessPointForObjectLambdaInputOperationOutputAlias =
    crate::operation::CreateAccessPointForObjectLambda;
#[doc(hidden)]
pub type CreateAccessPointForObjectLambdaInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateAccessPointForObjectLambdaInput {
    /// Consumes the builder and constructs an Operation<[`CreateAccessPointForObjectLambda`](crate::operation::CreateAccessPointForObjectLambda)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAccessPointForObjectLambda,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAccessPointForObjectLambdaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.name;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_2, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v20180820/accesspointforobjectlambda/{Name}",
                Name = name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAccessPointForObjectLambdaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_create_access_point_for_object_lambda(
                input, builder,
            )?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAccessPointForObjectLambdaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_access_point_for_object_lambda(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAccessPointForObjectLambda::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAccessPointForObjectLambda",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAccessPointForObjectLambdaInput`](crate::input::CreateAccessPointForObjectLambdaInput)
    pub fn builder() -> crate::input::create_access_point_for_object_lambda_input::Builder {
        crate::input::create_access_point_for_object_lambda_input::Builder::default()
    }
}

/// See [`CreateBucketInput`](crate::input::CreateBucketInput)
pub mod create_bucket_input {
    /// A builder for [`CreateBucketInput`](crate::input::CreateBucketInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) acl: std::option::Option<crate::model::BucketCannedAcl>,
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) create_bucket_configuration:
            std::option::Option<crate::model::CreateBucketConfiguration>,
        pub(crate) grant_full_control: std::option::Option<std::string::String>,
        pub(crate) grant_read: std::option::Option<std::string::String>,
        pub(crate) grant_read_acp: std::option::Option<std::string::String>,
        pub(crate) grant_write: std::option::Option<std::string::String>,
        pub(crate) grant_write_acp: std::option::Option<std::string::String>,
        pub(crate) object_lock_enabled_for_bucket: std::option::Option<bool>,
        pub(crate) outpost_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The canned ACL to apply to the bucket.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn acl(mut self, input: crate::model::BucketCannedAcl) -> Self {
            self.acl = Some(input);
            self
        }
        /// <p>The canned ACL to apply to the bucket.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_acl(
            mut self,
            input: std::option::Option<crate::model::BucketCannedAcl>,
        ) -> Self {
            self.acl = input;
            self
        }
        /// <p>The name of the bucket.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The configuration information for the bucket.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn create_bucket_configuration(
            mut self,
            input: crate::model::CreateBucketConfiguration,
        ) -> Self {
            self.create_bucket_configuration = Some(input);
            self
        }
        /// <p>The configuration information for the bucket.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_create_bucket_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateBucketConfiguration>,
        ) -> Self {
            self.create_bucket_configuration = input;
            self
        }
        /// <p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn grant_full_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_full_control = Some(input.into());
            self
        }
        /// <p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_grant_full_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_full_control = input;
            self
        }
        /// <p>Allows grantee to list the objects in the bucket.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn grant_read(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_read = Some(input.into());
            self
        }
        /// <p>Allows grantee to list the objects in the bucket.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_grant_read(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grant_read = input;
            self
        }
        /// <p>Allows grantee to read the bucket ACL.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn grant_read_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_read_acp = Some(input.into());
            self
        }
        /// <p>Allows grantee to read the bucket ACL.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_grant_read_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_read_acp = input;
            self
        }
        /// <p>Allows grantee to create, overwrite, and delete any object in the bucket.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn grant_write(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_write = Some(input.into());
            self
        }
        /// <p>Allows grantee to create, overwrite, and delete any object in the bucket.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_grant_write(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grant_write = input;
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable bucket.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn grant_write_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_write_acp = Some(input.into());
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable bucket.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_grant_write_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_write_acp = input;
            self
        }
        /// <p>Specifies whether you want S3 Object Lock to be enabled for the new bucket.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn object_lock_enabled_for_bucket(mut self, input: bool) -> Self {
            self.object_lock_enabled_for_bucket = Some(input);
            self
        }
        /// <p>Specifies whether you want S3 Object Lock to be enabled for the new bucket.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_object_lock_enabled_for_bucket(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.object_lock_enabled_for_bucket = input;
            self
        }
        /// <p>The ID of the Outposts where the bucket is being created.</p> <note>
        /// <p>This is required by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn outpost_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_id = Some(input.into());
            self
        }
        /// <p>The ID of the Outposts where the bucket is being created.</p> <note>
        /// <p>This is required by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_outpost_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.outpost_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBucketInput`](crate::input::CreateBucketInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBucketInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBucketInput {
                acl: self.acl,
                bucket: self.bucket,
                create_bucket_configuration: self.create_bucket_configuration,
                grant_full_control: self.grant_full_control,
                grant_read: self.grant_read,
                grant_read_acp: self.grant_read_acp,
                grant_write: self.grant_write,
                grant_write_acp: self.grant_write_acp,
                object_lock_enabled_for_bucket: self
                    .object_lock_enabled_for_bucket
                    .unwrap_or_default(),
                outpost_id: self.outpost_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBucketInputOperationOutputAlias = crate::operation::CreateBucket;
#[doc(hidden)]
pub type CreateBucketInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateBucketInput {
    /// Consumes the builder and constructs an Operation<[`CreateBucket`](crate::operation::CreateBucket)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBucket,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateBucketInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.bucket;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_3, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v20180820/bucket/{Bucket}", Bucket = bucket)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateBucketInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_create_bucket(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateBucketInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_create_bucket_input(
                &self.create_bucket_configuration,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBucket::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBucket",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateBucketInput`](crate::input::CreateBucketInput)
    pub fn builder() -> crate::input::create_bucket_input::Builder {
        crate::input::create_bucket_input::Builder::default()
    }
}

/// See [`CreateJobInput`](crate::input::CreateJobInput)
pub mod create_job_input {
    /// A builder for [`CreateJobInput`](crate::input::CreateJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) confirmation_required: std::option::Option<bool>,
        pub(crate) operation: std::option::Option<crate::model::JobOperation>,
        pub(crate) report: std::option::Option<crate::model::JobReport>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) manifest: std::option::Option<crate::model::JobManifest>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
        pub(crate) manifest_generator: std::option::Option<crate::model::JobManifestGenerator>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID that creates the job.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID that creates the job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>Indicates whether confirmation is required before Amazon S3 runs the job. Confirmation is only required for jobs created through the Amazon S3 console.</p>
        pub fn confirmation_required(mut self, input: bool) -> Self {
            self.confirmation_required = Some(input);
            self
        }
        /// <p>Indicates whether confirmation is required before Amazon S3 runs the job. Confirmation is only required for jobs created through the Amazon S3 console.</p>
        pub fn set_confirmation_required(mut self, input: std::option::Option<bool>) -> Self {
            self.confirmation_required = input;
            self
        }
        /// <p>The action that you want this job to perform on every object listed in the manifest. For more information about the available actions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-actions.html">Operations</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn operation(mut self, input: crate::model::JobOperation) -> Self {
            self.operation = Some(input);
            self
        }
        /// <p>The action that you want this job to perform on every object listed in the manifest. For more information about the available actions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-actions.html">Operations</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_operation(
            mut self,
            input: std::option::Option<crate::model::JobOperation>,
        ) -> Self {
            self.operation = input;
            self
        }
        /// <p>Configuration parameters for the optional job-completion report.</p>
        pub fn report(mut self, input: crate::model::JobReport) -> Self {
            self.report = Some(input);
            self
        }
        /// <p>Configuration parameters for the optional job-completion report.</p>
        pub fn set_report(mut self, input: std::option::Option<crate::model::JobReport>) -> Self {
            self.report = input;
            self
        }
        /// <p>An idempotency token to ensure that you don't accidentally submit the same request twice. You can use any string up to the maximum length.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>An idempotency token to ensure that you don't accidentally submit the same request twice. You can use any string up to the maximum length.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>Configuration parameters for the manifest.</p>
        pub fn manifest(mut self, input: crate::model::JobManifest) -> Self {
            self.manifest = Some(input);
            self
        }
        /// <p>Configuration parameters for the manifest.</p>
        pub fn set_manifest(
            mut self,
            input: std::option::Option<crate::model::JobManifest>,
        ) -> Self {
            self.manifest = input;
            self
        }
        /// <p>A description for this job. You can use any string within the permitted length. Descriptions don't need to be unique and can be used for multiple jobs.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for this job. You can use any string within the permitted length. Descriptions don't need to be unique and can be used for multiple jobs.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The numerical priority for this job. Higher numbers indicate higher priority.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The numerical priority for this job. Higher numbers indicate higher priority.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Identity and Access Management (IAM) role that Batch Operations will use to run this job's action on every object in the manifest.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Identity and Access Management (IAM) role that Batch Operations will use to run this job's action on every object in the manifest.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A set of tags to associate with the S3 Batch Operations job. This is an optional parameter. </p>
        pub fn tags(mut self, input: crate::model::S3Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A set of tags to associate with the S3 Batch Operations job. This is an optional parameter. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The attribute container for the ManifestGenerator details. Jobs must be created with either a manifest file or a ManifestGenerator, but not both.</p>
        pub fn manifest_generator(mut self, input: crate::model::JobManifestGenerator) -> Self {
            self.manifest_generator = Some(input);
            self
        }
        /// <p>The attribute container for the ManifestGenerator details. Jobs must be created with either a manifest file or a ManifestGenerator, but not both.</p>
        pub fn set_manifest_generator(
            mut self,
            input: std::option::Option<crate::model::JobManifestGenerator>,
        ) -> Self {
            self.manifest_generator = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateJobInput`](crate::input::CreateJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::CreateJobInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::CreateJobInput {
                account_id: self.account_id,
                confirmation_required: self.confirmation_required,
                operation: self.operation,
                report: self.report,
                client_request_token: self.client_request_token,
                manifest: self.manifest,
                description: self.description,
                priority: self.priority,
                role_arn: self.role_arn,
                tags: self.tags,
                manifest_generator: self.manifest_generator,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateJobInputOperationOutputAlias = crate::operation::CreateJob;
#[doc(hidden)]
pub type CreateJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateJob`](crate::operation::CreateJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v20180820/jobs").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_create_job(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_job(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::CreateJob::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "CreateJob",
                    "s3control",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateJobInput`](crate::input::CreateJobInput)
    pub fn builder() -> crate::input::create_job_input::Builder {
        crate::input::create_job_input::Builder::default()
    }
}

/// See [`CreateMultiRegionAccessPointInput`](crate::input::CreateMultiRegionAccessPointInput)
pub mod create_multi_region_access_point_input {
    /// A builder for [`CreateMultiRegionAccessPointInput`](crate::input::CreateMultiRegionAccessPointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) details: std::option::Option<crate::model::CreateMultiRegionAccessPointInput>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point. The owner of the Multi-Region Access Point also must own the underlying buckets.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point. The owner of the Multi-Region Access Point also must own the underlying buckets.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>An idempotency token used to identify the request and guarantee that requests are unique.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>An idempotency token used to identify the request and guarantee that requests are unique.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>A container element containing details about the Multi-Region Access Point.</p>
        pub fn details(mut self, input: crate::model::CreateMultiRegionAccessPointInput) -> Self {
            self.details = Some(input);
            self
        }
        /// <p>A container element containing details about the Multi-Region Access Point.</p>
        pub fn set_details(
            mut self,
            input: std::option::Option<crate::model::CreateMultiRegionAccessPointInput>,
        ) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMultiRegionAccessPointInput`](crate::input::CreateMultiRegionAccessPointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMultiRegionAccessPointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMultiRegionAccessPointInput {
                account_id: self.account_id,
                client_token: self.client_token,
                details: self.details,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMultiRegionAccessPointInputOperationOutputAlias =
    crate::operation::CreateMultiRegionAccessPoint;
#[doc(hidden)]
pub type CreateMultiRegionAccessPointInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateMultiRegionAccessPointInput {
    /// Consumes the builder and constructs an Operation<[`CreateMultiRegionAccessPoint`](crate::operation::CreateMultiRegionAccessPoint)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMultiRegionAccessPoint,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateMultiRegionAccessPointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v20180820/async-requests/mrap/create")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateMultiRegionAccessPointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder =
                crate::http_serde::add_headers_create_multi_region_access_point(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateMultiRegionAccessPointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_multi_region_access_point(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMultiRegionAccessPoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMultiRegionAccessPoint",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateMultiRegionAccessPointInput`](crate::input::CreateMultiRegionAccessPointInput)
    pub fn builder() -> crate::input::create_multi_region_access_point_input::Builder {
        crate::input::create_multi_region_access_point_input::Builder::default()
    }
}

/// See [`DeleteAccessPointInput`](crate::input::DeleteAccessPointInput)
pub mod delete_access_point_input {
    /// A builder for [`DeleteAccessPointInput`](crate::input::DeleteAccessPointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the access point you want to delete.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /accesspoint/
        /// <my-accesspoint-name></my-accesspoint-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the access point you want to delete.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /accesspoint/
        /// <my-accesspoint-name></my-accesspoint-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAccessPointInput`](crate::input::DeleteAccessPointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAccessPointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAccessPointInput {
                account_id: self.account_id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAccessPointInputOperationOutputAlias = crate::operation::DeleteAccessPoint;
#[doc(hidden)]
pub type DeleteAccessPointInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAccessPointInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAccessPoint`](crate::operation::DeleteAccessPoint)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAccessPoint,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAccessPointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.name;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_4, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v20180820/accesspoint/{Name}", Name = name)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAccessPointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_delete_access_point(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAccessPointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAccessPoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAccessPoint",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAccessPointInput`](crate::input::DeleteAccessPointInput)
    pub fn builder() -> crate::input::delete_access_point_input::Builder {
        crate::input::delete_access_point_input::Builder::default()
    }
}

/// See [`DeleteAccessPointForObjectLambdaInput`](crate::input::DeleteAccessPointForObjectLambdaInput)
pub mod delete_access_point_for_object_lambda_input {
    /// A builder for [`DeleteAccessPointForObjectLambdaInput`](crate::input::DeleteAccessPointForObjectLambdaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the access point you want to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the access point you want to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAccessPointForObjectLambdaInput`](crate::input::DeleteAccessPointForObjectLambdaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAccessPointForObjectLambdaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAccessPointForObjectLambdaInput {
                account_id: self.account_id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAccessPointForObjectLambdaInputOperationOutputAlias =
    crate::operation::DeleteAccessPointForObjectLambda;
#[doc(hidden)]
pub type DeleteAccessPointForObjectLambdaInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAccessPointForObjectLambdaInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAccessPointForObjectLambda`](crate::operation::DeleteAccessPointForObjectLambda)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAccessPointForObjectLambda,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAccessPointForObjectLambdaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.name;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_5, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v20180820/accesspointforobjectlambda/{Name}",
                Name = name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAccessPointForObjectLambdaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_delete_access_point_for_object_lambda(
                input, builder,
            )?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAccessPointForObjectLambdaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAccessPointForObjectLambda::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAccessPointForObjectLambda",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAccessPointForObjectLambdaInput`](crate::input::DeleteAccessPointForObjectLambdaInput)
    pub fn builder() -> crate::input::delete_access_point_for_object_lambda_input::Builder {
        crate::input::delete_access_point_for_object_lambda_input::Builder::default()
    }
}

/// See [`DeleteAccessPointPolicyInput`](crate::input::DeleteAccessPointPolicyInput)
pub mod delete_access_point_policy_input {
    /// A builder for [`DeleteAccessPointPolicyInput`](crate::input::DeleteAccessPointPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the access point whose policy you want to delete.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /accesspoint/
        /// <my-accesspoint-name></my-accesspoint-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the access point whose policy you want to delete.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /accesspoint/
        /// <my-accesspoint-name></my-accesspoint-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAccessPointPolicyInput`](crate::input::DeleteAccessPointPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAccessPointPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAccessPointPolicyInput {
                account_id: self.account_id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAccessPointPolicyInputOperationOutputAlias =
    crate::operation::DeleteAccessPointPolicy;
#[doc(hidden)]
pub type DeleteAccessPointPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAccessPointPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAccessPointPolicy`](crate::operation::DeleteAccessPointPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAccessPointPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAccessPointPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.name;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_6, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v20180820/accesspoint/{Name}/policy", Name = name)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAccessPointPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder =
                crate::http_serde::add_headers_delete_access_point_policy(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAccessPointPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAccessPointPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAccessPointPolicy",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAccessPointPolicyInput`](crate::input::DeleteAccessPointPolicyInput)
    pub fn builder() -> crate::input::delete_access_point_policy_input::Builder {
        crate::input::delete_access_point_policy_input::Builder::default()
    }
}

/// See [`DeleteAccessPointPolicyForObjectLambdaInput`](crate::input::DeleteAccessPointPolicyForObjectLambdaInput)
pub mod delete_access_point_policy_for_object_lambda_input {
    /// A builder for [`DeleteAccessPointPolicyForObjectLambdaInput`](crate::input::DeleteAccessPointPolicyForObjectLambdaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the Object Lambda Access Point you want to delete the policy for.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Object Lambda Access Point you want to delete the policy for.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAccessPointPolicyForObjectLambdaInput`](crate::input::DeleteAccessPointPolicyForObjectLambdaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAccessPointPolicyForObjectLambdaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAccessPointPolicyForObjectLambdaInput {
                account_id: self.account_id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAccessPointPolicyForObjectLambdaInputOperationOutputAlias =
    crate::operation::DeleteAccessPointPolicyForObjectLambda;
#[doc(hidden)]
pub type DeleteAccessPointPolicyForObjectLambdaInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAccessPointPolicyForObjectLambdaInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAccessPointPolicyForObjectLambda`](crate::operation::DeleteAccessPointPolicyForObjectLambda)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAccessPointPolicyForObjectLambda,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAccessPointPolicyForObjectLambdaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.name;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_7, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v20180820/accesspointforobjectlambda/{Name}/policy",
                Name = name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAccessPointPolicyForObjectLambdaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder =
                crate::http_serde::add_headers_delete_access_point_policy_for_object_lambda(
                    input, builder,
                )?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAccessPointPolicyForObjectLambdaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAccessPointPolicyForObjectLambda::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAccessPointPolicyForObjectLambda",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAccessPointPolicyForObjectLambdaInput`](crate::input::DeleteAccessPointPolicyForObjectLambdaInput)
    pub fn builder() -> crate::input::delete_access_point_policy_for_object_lambda_input::Builder {
        crate::input::delete_access_point_policy_for_object_lambda_input::Builder::default()
    }
}

/// See [`DeleteBucketInput`](crate::input::DeleteBucketInput)
pub mod delete_bucket_input {
    /// A builder for [`DeleteBucketInput`](crate::input::DeleteBucketInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) bucket: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID that owns the Outposts bucket.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID that owns the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>Specifies the bucket being deleted.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>Specifies the bucket being deleted.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketInput`](crate::input::DeleteBucketInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketInput {
                account_id: self.account_id,
                bucket: self.bucket,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketInputOperationOutputAlias = crate::operation::DeleteBucket;
#[doc(hidden)]
pub type DeleteBucketInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucket`](crate::operation::DeleteBucket)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucket,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBucketInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.bucket;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_8, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v20180820/bucket/{Bucket}", Bucket = bucket)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBucketInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_delete_bucket(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBucketInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucket::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucket",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketInput`](crate::input::DeleteBucketInput)
    pub fn builder() -> crate::input::delete_bucket_input::Builder {
        crate::input::delete_bucket_input::Builder::default()
    }
}

/// See [`DeleteBucketLifecycleConfigurationInput`](crate::input::DeleteBucketLifecycleConfigurationInput)
pub mod delete_bucket_lifecycle_configuration_input {
    /// A builder for [`DeleteBucketLifecycleConfigurationInput`](crate::input::DeleteBucketLifecycleConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) bucket: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID of the lifecycle configuration to delete.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID of the lifecycle configuration to delete.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketLifecycleConfigurationInput`](crate::input::DeleteBucketLifecycleConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketLifecycleConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketLifecycleConfigurationInput {
                account_id: self.account_id,
                bucket: self.bucket,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketLifecycleConfigurationInputOperationOutputAlias =
    crate::operation::DeleteBucketLifecycleConfiguration;
#[doc(hidden)]
pub type DeleteBucketLifecycleConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketLifecycleConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucketLifecycleConfiguration`](crate::operation::DeleteBucketLifecycleConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucketLifecycleConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBucketLifecycleConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.bucket;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_9, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v20180820/bucket/{Bucket}/lifecycleconfiguration",
                Bucket = bucket
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBucketLifecycleConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_delete_bucket_lifecycle_configuration(
                input, builder,
            )?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBucketLifecycleConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucketLifecycleConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucketLifecycleConfiguration",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketLifecycleConfigurationInput`](crate::input::DeleteBucketLifecycleConfigurationInput)
    pub fn builder() -> crate::input::delete_bucket_lifecycle_configuration_input::Builder {
        crate::input::delete_bucket_lifecycle_configuration_input::Builder::default()
    }
}

/// See [`DeleteBucketPolicyInput`](crate::input::DeleteBucketPolicyInput)
pub mod delete_bucket_policy_input {
    /// A builder for [`DeleteBucketPolicyInput`](crate::input::DeleteBucketPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) bucket: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID of the Outposts bucket.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID of the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketPolicyInput`](crate::input::DeleteBucketPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketPolicyInput {
                account_id: self.account_id,
                bucket: self.bucket,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketPolicyInputOperationOutputAlias = crate::operation::DeleteBucketPolicy;
#[doc(hidden)]
pub type DeleteBucketPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucketPolicy`](crate::operation::DeleteBucketPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucketPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBucketPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.bucket;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_10, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v20180820/bucket/{Bucket}/policy", Bucket = bucket)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBucketPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_delete_bucket_policy(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBucketPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucketPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucketPolicy",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketPolicyInput`](crate::input::DeleteBucketPolicyInput)
    pub fn builder() -> crate::input::delete_bucket_policy_input::Builder {
        crate::input::delete_bucket_policy_input::Builder::default()
    }
}

/// See [`DeleteBucketTaggingInput`](crate::input::DeleteBucketTaggingInput)
pub mod delete_bucket_tagging_input {
    /// A builder for [`DeleteBucketTaggingInput`](crate::input::DeleteBucketTaggingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) bucket: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID of the Outposts bucket tag set to be removed.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket tag set to be removed.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The bucket ARN that has the tag set to be removed.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket ARN that has the tag set to be removed.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketTaggingInput`](crate::input::DeleteBucketTaggingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketTaggingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketTaggingInput {
                account_id: self.account_id,
                bucket: self.bucket,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketTaggingInputOperationOutputAlias = crate::operation::DeleteBucketTagging;
#[doc(hidden)]
pub type DeleteBucketTaggingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketTaggingInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucketTagging`](crate::operation::DeleteBucketTagging)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucketTagging,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBucketTaggingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_11 = &_input.bucket;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_11, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v20180820/bucket/{Bucket}/tagging",
                Bucket = bucket
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBucketTaggingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_delete_bucket_tagging(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBucketTaggingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucketTagging::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucketTagging",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketTaggingInput`](crate::input::DeleteBucketTaggingInput)
    pub fn builder() -> crate::input::delete_bucket_tagging_input::Builder {
        crate::input::delete_bucket_tagging_input::Builder::default()
    }
}

/// See [`DeleteJobTaggingInput`](crate::input::DeleteJobTaggingInput)
pub mod delete_job_tagging_input {
    /// A builder for [`DeleteJobTaggingInput`](crate::input::DeleteJobTaggingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The ID for the S3 Batch Operations job whose tags you want to delete.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for the S3 Batch Operations job whose tags you want to delete.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteJobTaggingInput`](crate::input::DeleteJobTaggingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteJobTaggingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteJobTaggingInput {
                account_id: self.account_id,
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteJobTaggingInputOperationOutputAlias = crate::operation::DeleteJobTagging;
#[doc(hidden)]
pub type DeleteJobTaggingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteJobTaggingInput {
    /// Consumes the builder and constructs an Operation<[`DeleteJobTagging`](crate::operation::DeleteJobTagging)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteJobTagging,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteJobTaggingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_12 = &_input.job_id;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    })?;
            let job_id = aws_smithy_http::label::fmt_string(input_12, false);
            if job_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "job_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v20180820/jobs/{JobId}/tagging", JobId = job_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteJobTaggingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_delete_job_tagging(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteJobTaggingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteJobTagging::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteJobTagging",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteJobTaggingInput`](crate::input::DeleteJobTaggingInput)
    pub fn builder() -> crate::input::delete_job_tagging_input::Builder {
        crate::input::delete_job_tagging_input::Builder::default()
    }
}

/// See [`DeleteMultiRegionAccessPointInput`](crate::input::DeleteMultiRegionAccessPointInput)
pub mod delete_multi_region_access_point_input {
    /// A builder for [`DeleteMultiRegionAccessPointInput`](crate::input::DeleteMultiRegionAccessPointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) details: std::option::Option<crate::model::DeleteMultiRegionAccessPointInput>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>An idempotency token used to identify the request and guarantee that requests are unique.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>An idempotency token used to identify the request and guarantee that requests are unique.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>A container element containing details about the Multi-Region Access Point.</p>
        pub fn details(mut self, input: crate::model::DeleteMultiRegionAccessPointInput) -> Self {
            self.details = Some(input);
            self
        }
        /// <p>A container element containing details about the Multi-Region Access Point.</p>
        pub fn set_details(
            mut self,
            input: std::option::Option<crate::model::DeleteMultiRegionAccessPointInput>,
        ) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMultiRegionAccessPointInput`](crate::input::DeleteMultiRegionAccessPointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteMultiRegionAccessPointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteMultiRegionAccessPointInput {
                account_id: self.account_id,
                client_token: self.client_token,
                details: self.details,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteMultiRegionAccessPointInputOperationOutputAlias =
    crate::operation::DeleteMultiRegionAccessPoint;
#[doc(hidden)]
pub type DeleteMultiRegionAccessPointInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteMultiRegionAccessPointInput {
    /// Consumes the builder and constructs an Operation<[`DeleteMultiRegionAccessPoint`](crate::operation::DeleteMultiRegionAccessPoint)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteMultiRegionAccessPoint,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteMultiRegionAccessPointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v20180820/async-requests/mrap/delete")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteMultiRegionAccessPointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder =
                crate::http_serde::add_headers_delete_multi_region_access_point(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteMultiRegionAccessPointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_multi_region_access_point(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteMultiRegionAccessPoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteMultiRegionAccessPoint",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteMultiRegionAccessPointInput`](crate::input::DeleteMultiRegionAccessPointInput)
    pub fn builder() -> crate::input::delete_multi_region_access_point_input::Builder {
        crate::input::delete_multi_region_access_point_input::Builder::default()
    }
}

/// See [`DeletePublicAccessBlockInput`](crate::input::DeletePublicAccessBlockInput)
pub mod delete_public_access_block_input {
    /// A builder for [`DeletePublicAccessBlockInput`](crate::input::DeletePublicAccessBlockInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want to remove.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want to remove.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePublicAccessBlockInput`](crate::input::DeletePublicAccessBlockInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePublicAccessBlockInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePublicAccessBlockInput {
                account_id: self.account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePublicAccessBlockInputOperationOutputAlias =
    crate::operation::DeletePublicAccessBlock;
#[doc(hidden)]
pub type DeletePublicAccessBlockInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeletePublicAccessBlockInput {
    /// Consumes the builder and constructs an Operation<[`DeletePublicAccessBlock`](crate::operation::DeletePublicAccessBlock)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePublicAccessBlock,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeletePublicAccessBlockInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v20180820/configuration/publicAccessBlock")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeletePublicAccessBlockInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder =
                crate::http_serde::add_headers_delete_public_access_block(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeletePublicAccessBlockInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePublicAccessBlock::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePublicAccessBlock",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeletePublicAccessBlockInput`](crate::input::DeletePublicAccessBlockInput)
    pub fn builder() -> crate::input::delete_public_access_block_input::Builder {
        crate::input::delete_public_access_block_input::Builder::default()
    }
}

/// See [`DeleteStorageLensConfigurationInput`](crate::input::DeleteStorageLensConfigurationInput)
pub mod delete_storage_lens_configuration_input {
    /// A builder for [`DeleteStorageLensConfigurationInput`](crate::input::DeleteStorageLensConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_id: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the S3 Storage Lens configuration.</p>
        pub fn config_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_id = Some(input.into());
            self
        }
        /// <p>The ID of the S3 Storage Lens configuration.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.config_id = input;
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteStorageLensConfigurationInput`](crate::input::DeleteStorageLensConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteStorageLensConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteStorageLensConfigurationInput {
                config_id: self.config_id,
                account_id: self.account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteStorageLensConfigurationInputOperationOutputAlias =
    crate::operation::DeleteStorageLensConfiguration;
#[doc(hidden)]
pub type DeleteStorageLensConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteStorageLensConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteStorageLensConfiguration`](crate::operation::DeleteStorageLensConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteStorageLensConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteStorageLensConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_13 = &_input.config_id;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "config_id",
                        details: "cannot be empty or unset",
                    })?;
            let config_id = aws_smithy_http::label::fmt_string(input_13, false);
            if config_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "config_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v20180820/storagelens/{ConfigId}",
                ConfigId = config_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteStorageLensConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder =
                crate::http_serde::add_headers_delete_storage_lens_configuration(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteStorageLensConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteStorageLensConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteStorageLensConfiguration",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteStorageLensConfigurationInput`](crate::input::DeleteStorageLensConfigurationInput)
    pub fn builder() -> crate::input::delete_storage_lens_configuration_input::Builder {
        crate::input::delete_storage_lens_configuration_input::Builder::default()
    }
}

/// See [`DeleteStorageLensConfigurationTaggingInput`](crate::input::DeleteStorageLensConfigurationTaggingInput)
pub mod delete_storage_lens_configuration_tagging_input {
    /// A builder for [`DeleteStorageLensConfigurationTaggingInput`](crate::input::DeleteStorageLensConfigurationTaggingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_id: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the S3 Storage Lens configuration.</p>
        pub fn config_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_id = Some(input.into());
            self
        }
        /// <p>The ID of the S3 Storage Lens configuration.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.config_id = input;
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteStorageLensConfigurationTaggingInput`](crate::input::DeleteStorageLensConfigurationTaggingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteStorageLensConfigurationTaggingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteStorageLensConfigurationTaggingInput {
                config_id: self.config_id,
                account_id: self.account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteStorageLensConfigurationTaggingInputOperationOutputAlias =
    crate::operation::DeleteStorageLensConfigurationTagging;
#[doc(hidden)]
pub type DeleteStorageLensConfigurationTaggingInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteStorageLensConfigurationTaggingInput {
    /// Consumes the builder and constructs an Operation<[`DeleteStorageLensConfigurationTagging`](crate::operation::DeleteStorageLensConfigurationTagging)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteStorageLensConfigurationTagging,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteStorageLensConfigurationTaggingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_14 = &_input.config_id;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "config_id",
                        details: "cannot be empty or unset",
                    })?;
            let config_id = aws_smithy_http::label::fmt_string(input_14, false);
            if config_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "config_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v20180820/storagelens/{ConfigId}/tagging",
                ConfigId = config_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteStorageLensConfigurationTaggingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_delete_storage_lens_configuration_tagging(
                input, builder,
            )?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteStorageLensConfigurationTaggingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteStorageLensConfigurationTagging::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteStorageLensConfigurationTagging",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteStorageLensConfigurationTaggingInput`](crate::input::DeleteStorageLensConfigurationTaggingInput)
    pub fn builder() -> crate::input::delete_storage_lens_configuration_tagging_input::Builder {
        crate::input::delete_storage_lens_configuration_tagging_input::Builder::default()
    }
}

/// See [`DescribeJobInput`](crate::input::DescribeJobInput)
pub mod describe_job_input {
    /// A builder for [`DescribeJobInput`](crate::input::DescribeJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The ID for the job whose information you want to retrieve.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for the job whose information you want to retrieve.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeJobInput`](crate::input::DescribeJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeJobInput {
                account_id: self.account_id,
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeJobInputOperationOutputAlias = crate::operation::DescribeJob;
#[doc(hidden)]
pub type DescribeJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeJob`](crate::operation::DescribeJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_15 = &_input.job_id;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    })?;
            let job_id = aws_smithy_http::label::fmt_string(input_15, false);
            if job_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "job_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v20180820/jobs/{JobId}", JobId = job_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_describe_job(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeJob",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeJobInput`](crate::input::DescribeJobInput)
    pub fn builder() -> crate::input::describe_job_input::Builder {
        crate::input::describe_job_input::Builder::default()
    }
}

/// See [`DescribeMultiRegionAccessPointOperationInput`](crate::input::DescribeMultiRegionAccessPointOperationInput)
pub mod describe_multi_region_access_point_operation_input {
    /// A builder for [`DescribeMultiRegionAccessPointOperationInput`](crate::input::DescribeMultiRegionAccessPointOperationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) request_token_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The request token associated with the request you want to know about. This request token is returned as part of the response when you make an asynchronous request. You provide this token to query about the status of the asynchronous action.</p>
        pub fn request_token_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_token_arn = Some(input.into());
            self
        }
        /// <p>The request token associated with the request you want to know about. This request token is returned as part of the response when you make an asynchronous request. You provide this token to query about the status of the asynchronous action.</p>
        pub fn set_request_token_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.request_token_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMultiRegionAccessPointOperationInput`](crate::input::DescribeMultiRegionAccessPointOperationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeMultiRegionAccessPointOperationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeMultiRegionAccessPointOperationInput {
                account_id: self.account_id,
                request_token_arn: self.request_token_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeMultiRegionAccessPointOperationInputOperationOutputAlias =
    crate::operation::DescribeMultiRegionAccessPointOperation;
#[doc(hidden)]
pub type DescribeMultiRegionAccessPointOperationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeMultiRegionAccessPointOperationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeMultiRegionAccessPointOperation`](crate::operation::DescribeMultiRegionAccessPointOperation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeMultiRegionAccessPointOperation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeMultiRegionAccessPointOperationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_16 = &_input.request_token_arn;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "request_token_arn",
                        details: "cannot be empty or unset",
                    })?;
            let request_token_arn = aws_smithy_http::label::fmt_string(input_16, true);
            if request_token_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "request_token_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v20180820/async-requests/mrap/{RequestTokenARN}",
                RequestTokenARN = request_token_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeMultiRegionAccessPointOperationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder =
                crate::http_serde::add_headers_describe_multi_region_access_point_operation(
                    input, builder,
                )?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeMultiRegionAccessPointOperationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeMultiRegionAccessPointOperation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeMultiRegionAccessPointOperation",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeMultiRegionAccessPointOperationInput`](crate::input::DescribeMultiRegionAccessPointOperationInput)
    pub fn builder() -> crate::input::describe_multi_region_access_point_operation_input::Builder {
        crate::input::describe_multi_region_access_point_operation_input::Builder::default()
    }
}

/// See [`GetAccessPointInput`](crate::input::GetAccessPointInput)
pub mod get_access_point_input {
    /// A builder for [`GetAccessPointInput`](crate::input::GetAccessPointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the access point whose configuration information you want to retrieve.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /accesspoint/
        /// <my-accesspoint-name></my-accesspoint-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the access point whose configuration information you want to retrieve.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /accesspoint/
        /// <my-accesspoint-name></my-accesspoint-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccessPointInput`](crate::input::GetAccessPointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAccessPointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAccessPointInput {
                account_id: self.account_id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAccessPointInputOperationOutputAlias = crate::operation::GetAccessPoint;
#[doc(hidden)]
pub type GetAccessPointInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAccessPointInput {
    /// Consumes the builder and constructs an Operation<[`GetAccessPoint`](crate::operation::GetAccessPoint)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAccessPoint,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAccessPointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_17 = &_input.name;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_17, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v20180820/accesspoint/{Name}", Name = name)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAccessPointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_get_access_point(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAccessPointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAccessPoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAccessPoint",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAccessPointInput`](crate::input::GetAccessPointInput)
    pub fn builder() -> crate::input::get_access_point_input::Builder {
        crate::input::get_access_point_input::Builder::default()
    }
}

/// See [`GetAccessPointConfigurationForObjectLambdaInput`](crate::input::GetAccessPointConfigurationForObjectLambdaInput)
pub mod get_access_point_configuration_for_object_lambda_input {
    /// A builder for [`GetAccessPointConfigurationForObjectLambdaInput`](crate::input::GetAccessPointConfigurationForObjectLambdaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the Object Lambda Access Point you want to return the configuration for.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Object Lambda Access Point you want to return the configuration for.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccessPointConfigurationForObjectLambdaInput`](crate::input::GetAccessPointConfigurationForObjectLambdaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAccessPointConfigurationForObjectLambdaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::GetAccessPointConfigurationForObjectLambdaInput {
                    account_id: self.account_id,
                    name: self.name,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type GetAccessPointConfigurationForObjectLambdaInputOperationOutputAlias =
    crate::operation::GetAccessPointConfigurationForObjectLambda;
#[doc(hidden)]
pub type GetAccessPointConfigurationForObjectLambdaInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetAccessPointConfigurationForObjectLambdaInput {
    /// Consumes the builder and constructs an Operation<[`GetAccessPointConfigurationForObjectLambda`](crate::operation::GetAccessPointConfigurationForObjectLambda)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAccessPointConfigurationForObjectLambda,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAccessPointConfigurationForObjectLambdaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_18 = &_input.name;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_18, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v20180820/accesspointforobjectlambda/{Name}/configuration",
                Name = name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAccessPointConfigurationForObjectLambdaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder =
                crate::http_serde::add_headers_get_access_point_configuration_for_object_lambda(
                    input, builder,
                )?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAccessPointConfigurationForObjectLambdaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAccessPointConfigurationForObjectLambda::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAccessPointConfigurationForObjectLambda",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAccessPointConfigurationForObjectLambdaInput`](crate::input::GetAccessPointConfigurationForObjectLambdaInput)
    pub fn builder() -> crate::input::get_access_point_configuration_for_object_lambda_input::Builder
    {
        crate::input::get_access_point_configuration_for_object_lambda_input::Builder::default()
    }
}

/// See [`GetAccessPointForObjectLambdaInput`](crate::input::GetAccessPointForObjectLambdaInput)
pub mod get_access_point_for_object_lambda_input {
    /// A builder for [`GetAccessPointForObjectLambdaInput`](crate::input::GetAccessPointForObjectLambdaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccessPointForObjectLambdaInput`](crate::input::GetAccessPointForObjectLambdaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAccessPointForObjectLambdaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAccessPointForObjectLambdaInput {
                account_id: self.account_id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAccessPointForObjectLambdaInputOperationOutputAlias =
    crate::operation::GetAccessPointForObjectLambda;
#[doc(hidden)]
pub type GetAccessPointForObjectLambdaInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetAccessPointForObjectLambdaInput {
    /// Consumes the builder and constructs an Operation<[`GetAccessPointForObjectLambda`](crate::operation::GetAccessPointForObjectLambda)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAccessPointForObjectLambda,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAccessPointForObjectLambdaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_19 = &_input.name;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_19, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v20180820/accesspointforobjectlambda/{Name}",
                Name = name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAccessPointForObjectLambdaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder =
                crate::http_serde::add_headers_get_access_point_for_object_lambda(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAccessPointForObjectLambdaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAccessPointForObjectLambda::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAccessPointForObjectLambda",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAccessPointForObjectLambdaInput`](crate::input::GetAccessPointForObjectLambdaInput)
    pub fn builder() -> crate::input::get_access_point_for_object_lambda_input::Builder {
        crate::input::get_access_point_for_object_lambda_input::Builder::default()
    }
}

/// See [`GetAccessPointPolicyInput`](crate::input::GetAccessPointPolicyInput)
pub mod get_access_point_policy_input {
    /// A builder for [`GetAccessPointPolicyInput`](crate::input::GetAccessPointPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the access point whose policy you want to retrieve.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /accesspoint/
        /// <my-accesspoint-name></my-accesspoint-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the access point whose policy you want to retrieve.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /accesspoint/
        /// <my-accesspoint-name></my-accesspoint-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccessPointPolicyInput`](crate::input::GetAccessPointPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAccessPointPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAccessPointPolicyInput {
                account_id: self.account_id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAccessPointPolicyInputOperationOutputAlias = crate::operation::GetAccessPointPolicy;
#[doc(hidden)]
pub type GetAccessPointPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAccessPointPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetAccessPointPolicy`](crate::operation::GetAccessPointPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAccessPointPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAccessPointPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_20 = &_input.name;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_20, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v20180820/accesspoint/{Name}/policy", Name = name)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAccessPointPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_get_access_point_policy(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAccessPointPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAccessPointPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAccessPointPolicy",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAccessPointPolicyInput`](crate::input::GetAccessPointPolicyInput)
    pub fn builder() -> crate::input::get_access_point_policy_input::Builder {
        crate::input::get_access_point_policy_input::Builder::default()
    }
}

/// See [`GetAccessPointPolicyForObjectLambdaInput`](crate::input::GetAccessPointPolicyForObjectLambdaInput)
pub mod get_access_point_policy_for_object_lambda_input {
    /// A builder for [`GetAccessPointPolicyForObjectLambdaInput`](crate::input::GetAccessPointPolicyForObjectLambdaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccessPointPolicyForObjectLambdaInput`](crate::input::GetAccessPointPolicyForObjectLambdaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAccessPointPolicyForObjectLambdaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAccessPointPolicyForObjectLambdaInput {
                account_id: self.account_id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAccessPointPolicyForObjectLambdaInputOperationOutputAlias =
    crate::operation::GetAccessPointPolicyForObjectLambda;
#[doc(hidden)]
pub type GetAccessPointPolicyForObjectLambdaInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetAccessPointPolicyForObjectLambdaInput {
    /// Consumes the builder and constructs an Operation<[`GetAccessPointPolicyForObjectLambda`](crate::operation::GetAccessPointPolicyForObjectLambda)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAccessPointPolicyForObjectLambda,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAccessPointPolicyForObjectLambdaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_21 = &_input.name;
            let input_21 =
                input_21
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_21, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v20180820/accesspointforobjectlambda/{Name}/policy",
                Name = name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAccessPointPolicyForObjectLambdaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_get_access_point_policy_for_object_lambda(
                input, builder,
            )?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAccessPointPolicyForObjectLambdaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAccessPointPolicyForObjectLambda::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAccessPointPolicyForObjectLambda",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAccessPointPolicyForObjectLambdaInput`](crate::input::GetAccessPointPolicyForObjectLambdaInput)
    pub fn builder() -> crate::input::get_access_point_policy_for_object_lambda_input::Builder {
        crate::input::get_access_point_policy_for_object_lambda_input::Builder::default()
    }
}

/// See [`GetAccessPointPolicyStatusInput`](crate::input::GetAccessPointPolicyStatusInput)
pub mod get_access_point_policy_status_input {
    /// A builder for [`GetAccessPointPolicyStatusInput`](crate::input::GetAccessPointPolicyStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the access point whose policy status you want to retrieve.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the access point whose policy status you want to retrieve.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccessPointPolicyStatusInput`](crate::input::GetAccessPointPolicyStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAccessPointPolicyStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAccessPointPolicyStatusInput {
                account_id: self.account_id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAccessPointPolicyStatusInputOperationOutputAlias =
    crate::operation::GetAccessPointPolicyStatus;
#[doc(hidden)]
pub type GetAccessPointPolicyStatusInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAccessPointPolicyStatusInput {
    /// Consumes the builder and constructs an Operation<[`GetAccessPointPolicyStatus`](crate::operation::GetAccessPointPolicyStatus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAccessPointPolicyStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAccessPointPolicyStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_22 = &_input.name;
            let input_22 =
                input_22
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_22, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v20180820/accesspoint/{Name}/policyStatus",
                Name = name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAccessPointPolicyStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder =
                crate::http_serde::add_headers_get_access_point_policy_status(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAccessPointPolicyStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAccessPointPolicyStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAccessPointPolicyStatus",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAccessPointPolicyStatusInput`](crate::input::GetAccessPointPolicyStatusInput)
    pub fn builder() -> crate::input::get_access_point_policy_status_input::Builder {
        crate::input::get_access_point_policy_status_input::Builder::default()
    }
}

/// See [`GetAccessPointPolicyStatusForObjectLambdaInput`](crate::input::GetAccessPointPolicyStatusForObjectLambdaInput)
pub mod get_access_point_policy_status_for_object_lambda_input {
    /// A builder for [`GetAccessPointPolicyStatusForObjectLambdaInput`](crate::input::GetAccessPointPolicyStatusForObjectLambdaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccessPointPolicyStatusForObjectLambdaInput`](crate::input::GetAccessPointPolicyStatusForObjectLambdaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAccessPointPolicyStatusForObjectLambdaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::GetAccessPointPolicyStatusForObjectLambdaInput {
                    account_id: self.account_id,
                    name: self.name,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type GetAccessPointPolicyStatusForObjectLambdaInputOperationOutputAlias =
    crate::operation::GetAccessPointPolicyStatusForObjectLambda;
#[doc(hidden)]
pub type GetAccessPointPolicyStatusForObjectLambdaInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetAccessPointPolicyStatusForObjectLambdaInput {
    /// Consumes the builder and constructs an Operation<[`GetAccessPointPolicyStatusForObjectLambda`](crate::operation::GetAccessPointPolicyStatusForObjectLambda)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAccessPointPolicyStatusForObjectLambda,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAccessPointPolicyStatusForObjectLambdaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_23 = &_input.name;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_23, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v20180820/accesspointforobjectlambda/{Name}/policyStatus",
                Name = name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAccessPointPolicyStatusForObjectLambdaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder =
                crate::http_serde::add_headers_get_access_point_policy_status_for_object_lambda(
                    input, builder,
                )?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAccessPointPolicyStatusForObjectLambdaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAccessPointPolicyStatusForObjectLambda::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAccessPointPolicyStatusForObjectLambda",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAccessPointPolicyStatusForObjectLambdaInput`](crate::input::GetAccessPointPolicyStatusForObjectLambdaInput)
    pub fn builder() -> crate::input::get_access_point_policy_status_for_object_lambda_input::Builder
    {
        crate::input::get_access_point_policy_status_for_object_lambda_input::Builder::default()
    }
}

/// See [`GetBucketInput`](crate::input::GetBucketInput)
pub mod get_bucket_input {
    /// A builder for [`GetBucketInput`](crate::input::GetBucketInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) bucket: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketInput`](crate::input::GetBucketInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetBucketInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetBucketInput {
                account_id: self.account_id,
                bucket: self.bucket,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketInputOperationOutputAlias = crate::operation::GetBucket;
#[doc(hidden)]
pub type GetBucketInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketInput {
    /// Consumes the builder and constructs an Operation<[`GetBucket`](crate::operation::GetBucket)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucket,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBucketInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_24 = &_input.bucket;
            let input_24 =
                input_24
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_24, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v20180820/bucket/{Bucket}", Bucket = bucket)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBucketInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_get_bucket(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBucketInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetBucket::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetBucket",
                    "s3control",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBucketInput`](crate::input::GetBucketInput)
    pub fn builder() -> crate::input::get_bucket_input::Builder {
        crate::input::get_bucket_input::Builder::default()
    }
}

/// See [`GetBucketLifecycleConfigurationInput`](crate::input::GetBucketLifecycleConfigurationInput)
pub mod get_bucket_lifecycle_configuration_input {
    /// A builder for [`GetBucketLifecycleConfigurationInput`](crate::input::GetBucketLifecycleConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) bucket: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketLifecycleConfigurationInput`](crate::input::GetBucketLifecycleConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketLifecycleConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketLifecycleConfigurationInput {
                account_id: self.account_id,
                bucket: self.bucket,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketLifecycleConfigurationInputOperationOutputAlias =
    crate::operation::GetBucketLifecycleConfiguration;
#[doc(hidden)]
pub type GetBucketLifecycleConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketLifecycleConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketLifecycleConfiguration`](crate::operation::GetBucketLifecycleConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketLifecycleConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBucketLifecycleConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_25 = &_input.bucket;
            let input_25 =
                input_25
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_25, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v20180820/bucket/{Bucket}/lifecycleconfiguration",
                Bucket = bucket
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBucketLifecycleConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder =
                crate::http_serde::add_headers_get_bucket_lifecycle_configuration(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBucketLifecycleConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketLifecycleConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketLifecycleConfiguration",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBucketLifecycleConfigurationInput`](crate::input::GetBucketLifecycleConfigurationInput)
    pub fn builder() -> crate::input::get_bucket_lifecycle_configuration_input::Builder {
        crate::input::get_bucket_lifecycle_configuration_input::Builder::default()
    }
}

/// See [`GetBucketPolicyInput`](crate::input::GetBucketPolicyInput)
pub mod get_bucket_policy_input {
    /// A builder for [`GetBucketPolicyInput`](crate::input::GetBucketPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) bucket: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketPolicyInput`](crate::input::GetBucketPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketPolicyInput {
                account_id: self.account_id,
                bucket: self.bucket,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketPolicyInputOperationOutputAlias = crate::operation::GetBucketPolicy;
#[doc(hidden)]
pub type GetBucketPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketPolicy`](crate::operation::GetBucketPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBucketPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_26 = &_input.bucket;
            let input_26 =
                input_26
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_26, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v20180820/bucket/{Bucket}/policy", Bucket = bucket)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBucketPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_get_bucket_policy(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBucketPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketPolicy",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBucketPolicyInput`](crate::input::GetBucketPolicyInput)
    pub fn builder() -> crate::input::get_bucket_policy_input::Builder {
        crate::input::get_bucket_policy_input::Builder::default()
    }
}

/// See [`GetBucketTaggingInput`](crate::input::GetBucketTaggingInput)
pub mod get_bucket_tagging_input {
    /// A builder for [`GetBucketTaggingInput`](crate::input::GetBucketTaggingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) bucket: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketTaggingInput`](crate::input::GetBucketTaggingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketTaggingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketTaggingInput {
                account_id: self.account_id,
                bucket: self.bucket,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketTaggingInputOperationOutputAlias = crate::operation::GetBucketTagging;
#[doc(hidden)]
pub type GetBucketTaggingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketTaggingInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketTagging`](crate::operation::GetBucketTagging)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketTagging,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBucketTaggingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_27 = &_input.bucket;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_27, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v20180820/bucket/{Bucket}/tagging",
                Bucket = bucket
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBucketTaggingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_get_bucket_tagging(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBucketTaggingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketTagging::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketTagging",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBucketTaggingInput`](crate::input::GetBucketTaggingInput)
    pub fn builder() -> crate::input::get_bucket_tagging_input::Builder {
        crate::input::get_bucket_tagging_input::Builder::default()
    }
}

/// See [`GetJobTaggingInput`](crate::input::GetJobTaggingInput)
pub mod get_job_tagging_input {
    /// A builder for [`GetJobTaggingInput`](crate::input::GetJobTaggingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The ID for the S3 Batch Operations job whose tags you want to retrieve.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for the S3 Batch Operations job whose tags you want to retrieve.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetJobTaggingInput`](crate::input::GetJobTaggingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetJobTaggingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetJobTaggingInput {
                account_id: self.account_id,
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetJobTaggingInputOperationOutputAlias = crate::operation::GetJobTagging;
#[doc(hidden)]
pub type GetJobTaggingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetJobTaggingInput {
    /// Consumes the builder and constructs an Operation<[`GetJobTagging`](crate::operation::GetJobTagging)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetJobTagging,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetJobTaggingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_28 = &_input.job_id;
            let input_28 =
                input_28
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    })?;
            let job_id = aws_smithy_http::label::fmt_string(input_28, false);
            if job_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "job_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v20180820/jobs/{JobId}/tagging", JobId = job_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetJobTaggingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_get_job_tagging(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetJobTaggingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetJobTagging::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetJobTagging",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetJobTaggingInput`](crate::input::GetJobTaggingInput)
    pub fn builder() -> crate::input::get_job_tagging_input::Builder {
        crate::input::get_job_tagging_input::Builder::default()
    }
}

/// See [`GetMultiRegionAccessPointInput`](crate::input::GetMultiRegionAccessPointInput)
pub mod get_multi_region_access_point_input {
    /// A builder for [`GetMultiRegionAccessPointInput`](crate::input::GetMultiRegionAccessPointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the Multi-Region Access Point whose configuration information you want to receive. The name of the Multi-Region Access Point is different from the alias. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Multi-Region Access Point whose configuration information you want to receive. The name of the Multi-Region Access Point is different from the alias. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMultiRegionAccessPointInput`](crate::input::GetMultiRegionAccessPointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMultiRegionAccessPointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMultiRegionAccessPointInput {
                account_id: self.account_id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMultiRegionAccessPointInputOperationOutputAlias =
    crate::operation::GetMultiRegionAccessPoint;
#[doc(hidden)]
pub type GetMultiRegionAccessPointInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetMultiRegionAccessPointInput {
    /// Consumes the builder and constructs an Operation<[`GetMultiRegionAccessPoint`](crate::operation::GetMultiRegionAccessPoint)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMultiRegionAccessPoint,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMultiRegionAccessPointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_29 = &_input.name;
            let input_29 =
                input_29
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_29, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v20180820/mrap/instances/{Name}", Name = name)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMultiRegionAccessPointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder =
                crate::http_serde::add_headers_get_multi_region_access_point(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMultiRegionAccessPointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMultiRegionAccessPoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMultiRegionAccessPoint",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMultiRegionAccessPointInput`](crate::input::GetMultiRegionAccessPointInput)
    pub fn builder() -> crate::input::get_multi_region_access_point_input::Builder {
        crate::input::get_multi_region_access_point_input::Builder::default()
    }
}

/// See [`GetMultiRegionAccessPointPolicyInput`](crate::input::GetMultiRegionAccessPointPolicyInput)
pub mod get_multi_region_access_point_policy_input {
    /// A builder for [`GetMultiRegionAccessPointPolicyInput`](crate::input::GetMultiRegionAccessPointPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>Specifies the Multi-Region Access Point. The name of the Multi-Region Access Point is different from the alias. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Specifies the Multi-Region Access Point. The name of the Multi-Region Access Point is different from the alias. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMultiRegionAccessPointPolicyInput`](crate::input::GetMultiRegionAccessPointPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMultiRegionAccessPointPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMultiRegionAccessPointPolicyInput {
                account_id: self.account_id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMultiRegionAccessPointPolicyInputOperationOutputAlias =
    crate::operation::GetMultiRegionAccessPointPolicy;
#[doc(hidden)]
pub type GetMultiRegionAccessPointPolicyInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetMultiRegionAccessPointPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetMultiRegionAccessPointPolicy`](crate::operation::GetMultiRegionAccessPointPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMultiRegionAccessPointPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMultiRegionAccessPointPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_30 = &_input.name;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_30, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v20180820/mrap/instances/{Name}/policy",
                Name = name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMultiRegionAccessPointPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_get_multi_region_access_point_policy(
                input, builder,
            )?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMultiRegionAccessPointPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMultiRegionAccessPointPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMultiRegionAccessPointPolicy",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMultiRegionAccessPointPolicyInput`](crate::input::GetMultiRegionAccessPointPolicyInput)
    pub fn builder() -> crate::input::get_multi_region_access_point_policy_input::Builder {
        crate::input::get_multi_region_access_point_policy_input::Builder::default()
    }
}

/// See [`GetMultiRegionAccessPointPolicyStatusInput`](crate::input::GetMultiRegionAccessPointPolicyStatusInput)
pub mod get_multi_region_access_point_policy_status_input {
    /// A builder for [`GetMultiRegionAccessPointPolicyStatusInput`](crate::input::GetMultiRegionAccessPointPolicyStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>Specifies the Multi-Region Access Point. The name of the Multi-Region Access Point is different from the alias. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Specifies the Multi-Region Access Point. The name of the Multi-Region Access Point is different from the alias. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMultiRegionAccessPointPolicyStatusInput`](crate::input::GetMultiRegionAccessPointPolicyStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMultiRegionAccessPointPolicyStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMultiRegionAccessPointPolicyStatusInput {
                account_id: self.account_id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMultiRegionAccessPointPolicyStatusInputOperationOutputAlias =
    crate::operation::GetMultiRegionAccessPointPolicyStatus;
#[doc(hidden)]
pub type GetMultiRegionAccessPointPolicyStatusInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetMultiRegionAccessPointPolicyStatusInput {
    /// Consumes the builder and constructs an Operation<[`GetMultiRegionAccessPointPolicyStatus`](crate::operation::GetMultiRegionAccessPointPolicyStatus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMultiRegionAccessPointPolicyStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMultiRegionAccessPointPolicyStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_31 = &_input.name;
            let input_31 =
                input_31
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_31, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v20180820/mrap/instances/{Name}/policystatus",
                Name = name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMultiRegionAccessPointPolicyStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder =
                crate::http_serde::add_headers_get_multi_region_access_point_policy_status(
                    input, builder,
                )?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMultiRegionAccessPointPolicyStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMultiRegionAccessPointPolicyStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMultiRegionAccessPointPolicyStatus",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMultiRegionAccessPointPolicyStatusInput`](crate::input::GetMultiRegionAccessPointPolicyStatusInput)
    pub fn builder() -> crate::input::get_multi_region_access_point_policy_status_input::Builder {
        crate::input::get_multi_region_access_point_policy_status_input::Builder::default()
    }
}

/// See [`GetPublicAccessBlockInput`](crate::input::GetPublicAccessBlockInput)
pub mod get_public_access_block_input {
    /// A builder for [`GetPublicAccessBlockInput`](crate::input::GetPublicAccessBlockInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want to retrieve.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want to retrieve.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPublicAccessBlockInput`](crate::input::GetPublicAccessBlockInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPublicAccessBlockInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPublicAccessBlockInput {
                account_id: self.account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPublicAccessBlockInputOperationOutputAlias = crate::operation::GetPublicAccessBlock;
#[doc(hidden)]
pub type GetPublicAccessBlockInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetPublicAccessBlockInput {
    /// Consumes the builder and constructs an Operation<[`GetPublicAccessBlock`](crate::operation::GetPublicAccessBlock)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPublicAccessBlock,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetPublicAccessBlockInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v20180820/configuration/publicAccessBlock")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetPublicAccessBlockInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_get_public_access_block(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetPublicAccessBlockInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPublicAccessBlock::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPublicAccessBlock",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetPublicAccessBlockInput`](crate::input::GetPublicAccessBlockInput)
    pub fn builder() -> crate::input::get_public_access_block_input::Builder {
        crate::input::get_public_access_block_input::Builder::default()
    }
}

/// See [`GetStorageLensConfigurationInput`](crate::input::GetStorageLensConfigurationInput)
pub mod get_storage_lens_configuration_input {
    /// A builder for [`GetStorageLensConfigurationInput`](crate::input::GetStorageLensConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_id: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon S3 Storage Lens configuration.</p>
        pub fn config_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon S3 Storage Lens configuration.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.config_id = input;
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStorageLensConfigurationInput`](crate::input::GetStorageLensConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetStorageLensConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetStorageLensConfigurationInput {
                config_id: self.config_id,
                account_id: self.account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetStorageLensConfigurationInputOperationOutputAlias =
    crate::operation::GetStorageLensConfiguration;
#[doc(hidden)]
pub type GetStorageLensConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetStorageLensConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetStorageLensConfiguration`](crate::operation::GetStorageLensConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetStorageLensConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetStorageLensConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_32 = &_input.config_id;
            let input_32 =
                input_32
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "config_id",
                        details: "cannot be empty or unset",
                    })?;
            let config_id = aws_smithy_http::label::fmt_string(input_32, false);
            if config_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "config_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v20180820/storagelens/{ConfigId}",
                ConfigId = config_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetStorageLensConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder =
                crate::http_serde::add_headers_get_storage_lens_configuration(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetStorageLensConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetStorageLensConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetStorageLensConfiguration",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetStorageLensConfigurationInput`](crate::input::GetStorageLensConfigurationInput)
    pub fn builder() -> crate::input::get_storage_lens_configuration_input::Builder {
        crate::input::get_storage_lens_configuration_input::Builder::default()
    }
}

/// See [`GetStorageLensConfigurationTaggingInput`](crate::input::GetStorageLensConfigurationTaggingInput)
pub mod get_storage_lens_configuration_tagging_input {
    /// A builder for [`GetStorageLensConfigurationTaggingInput`](crate::input::GetStorageLensConfigurationTaggingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_id: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the Amazon S3 Storage Lens configuration.</p>
        pub fn config_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon S3 Storage Lens configuration.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.config_id = input;
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStorageLensConfigurationTaggingInput`](crate::input::GetStorageLensConfigurationTaggingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetStorageLensConfigurationTaggingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetStorageLensConfigurationTaggingInput {
                config_id: self.config_id,
                account_id: self.account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetStorageLensConfigurationTaggingInputOperationOutputAlias =
    crate::operation::GetStorageLensConfigurationTagging;
#[doc(hidden)]
pub type GetStorageLensConfigurationTaggingInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetStorageLensConfigurationTaggingInput {
    /// Consumes the builder and constructs an Operation<[`GetStorageLensConfigurationTagging`](crate::operation::GetStorageLensConfigurationTagging)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetStorageLensConfigurationTagging,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetStorageLensConfigurationTaggingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_33 = &_input.config_id;
            let input_33 =
                input_33
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "config_id",
                        details: "cannot be empty or unset",
                    })?;
            let config_id = aws_smithy_http::label::fmt_string(input_33, false);
            if config_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "config_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v20180820/storagelens/{ConfigId}/tagging",
                ConfigId = config_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetStorageLensConfigurationTaggingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_get_storage_lens_configuration_tagging(
                input, builder,
            )?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetStorageLensConfigurationTaggingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetStorageLensConfigurationTagging::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetStorageLensConfigurationTagging",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetStorageLensConfigurationTaggingInput`](crate::input::GetStorageLensConfigurationTaggingInput)
    pub fn builder() -> crate::input::get_storage_lens_configuration_tagging_input::Builder {
        crate::input::get_storage_lens_configuration_tagging_input::Builder::default()
    }
}

/// See [`ListAccessPointsInput`](crate::input::ListAccessPointsInput)
pub mod list_access_points_input {
    /// A builder for [`ListAccessPointsInput`](crate::input::ListAccessPointsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID for owner of the bucket whose access points you want to list.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for owner of the bucket whose access points you want to list.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the bucket whose associated access points you want to list.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket whose associated access points you want to list.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>A continuation token. If a previous call to <code>ListAccessPoints</code> returned a continuation token in the <code>NextToken</code> field, then providing that value here causes Amazon S3 to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A continuation token. If a previous call to <code>ListAccessPoints</code> returned a continuation token in the <code>NextToken</code> field, then providing that value here causes Amazon S3 to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of access points that you want to include in the list. If the specified bucket has more than this number of access points, then the response will include a continuation token in the <code>NextToken</code> field that you can use to retrieve the next page of access points.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of access points that you want to include in the list. If the specified bucket has more than this number of access points, then the response will include a continuation token in the <code>NextToken</code> field that you can use to retrieve the next page of access points.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccessPointsInput`](crate::input::ListAccessPointsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAccessPointsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAccessPointsInput {
                account_id: self.account_id,
                bucket: self.bucket,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListAccessPointsInputOperationOutputAlias = crate::operation::ListAccessPoints;
#[doc(hidden)]
pub type ListAccessPointsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAccessPointsInput {
    /// Consumes the builder and constructs an Operation<[`ListAccessPoints`](crate::operation::ListAccessPoints)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAccessPoints,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAccessPointsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v20180820/accesspoint").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListAccessPointsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_34) = &_input.bucket {
                query.push_kv("bucket", &aws_smithy_http::query::fmt_string(&inner_34));
            }
            if let Some(inner_35) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_35));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAccessPointsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_list_access_points(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAccessPointsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAccessPoints::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAccessPoints",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAccessPointsInput`](crate::input::ListAccessPointsInput)
    pub fn builder() -> crate::input::list_access_points_input::Builder {
        crate::input::list_access_points_input::Builder::default()
    }
}

/// See [`ListAccessPointsForObjectLambdaInput`](crate::input::ListAccessPointsForObjectLambdaInput)
pub mod list_access_points_for_object_lambda_input {
    /// A builder for [`ListAccessPointsForObjectLambdaInput`](crate::input::ListAccessPointsForObjectLambdaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>If the list has more access points than can be returned in one call to this API, this field contains a continuation token that you can provide in subsequent calls to this API to retrieve additional access points.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the list has more access points than can be returned in one call to this API, this field contains a continuation token that you can provide in subsequent calls to this API to retrieve additional access points.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of access points that you want to include in the list. The response may contain fewer access points but will never contain more. If there are more than this number of access points, then the response will include a continuation token in the <code>NextToken</code> field that you can use to retrieve the next page of access points.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of access points that you want to include in the list. The response may contain fewer access points but will never contain more. If there are more than this number of access points, then the response will include a continuation token in the <code>NextToken</code> field that you can use to retrieve the next page of access points.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccessPointsForObjectLambdaInput`](crate::input::ListAccessPointsForObjectLambdaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAccessPointsForObjectLambdaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAccessPointsForObjectLambdaInput {
                account_id: self.account_id,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListAccessPointsForObjectLambdaInputOperationOutputAlias =
    crate::operation::ListAccessPointsForObjectLambda;
#[doc(hidden)]
pub type ListAccessPointsForObjectLambdaInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListAccessPointsForObjectLambdaInput {
    /// Consumes the builder and constructs an Operation<[`ListAccessPointsForObjectLambda`](crate::operation::ListAccessPointsForObjectLambda)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAccessPointsForObjectLambda,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAccessPointsForObjectLambdaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v20180820/accesspointforobjectlambda")
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListAccessPointsForObjectLambdaInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_36) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_36));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAccessPointsForObjectLambdaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_list_access_points_for_object_lambda(
                input, builder,
            )?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAccessPointsForObjectLambdaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAccessPointsForObjectLambda::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAccessPointsForObjectLambda",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAccessPointsForObjectLambdaInput`](crate::input::ListAccessPointsForObjectLambdaInput)
    pub fn builder() -> crate::input::list_access_points_for_object_lambda_input::Builder {
        crate::input::list_access_points_for_object_lambda_input::Builder::default()
    }
}

/// See [`ListJobsInput`](crate::input::ListJobsInput)
pub mod list_jobs_input {
    /// A builder for [`ListJobsInput`](crate::input::ListJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) job_statuses: std::option::Option<std::vec::Vec<crate::model::JobStatus>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Appends an item to `job_statuses`.
        ///
        /// To override the contents of this collection use [`set_job_statuses`](Self::set_job_statuses).
        ///
        /// <p>The <code>List Jobs</code> request returns jobs that match the statuses listed in this element.</p>
        pub fn job_statuses(mut self, input: crate::model::JobStatus) -> Self {
            let mut v = self.job_statuses.unwrap_or_default();
            v.push(input);
            self.job_statuses = Some(v);
            self
        }
        /// <p>The <code>List Jobs</code> request returns jobs that match the statuses listed in this element.</p>
        pub fn set_job_statuses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobStatus>>,
        ) -> Self {
            self.job_statuses = input;
            self
        }
        /// <p>A pagination token to request the next page of results. Use the token that Amazon S3 returned in the <code>NextToken</code> element of the <code>ListJobsResult</code> from the previous <code>List Jobs</code> request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token to request the next page of results. Use the token that Amazon S3 returned in the <code>NextToken</code> element of the <code>ListJobsResult</code> from the previous <code>List Jobs</code> request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of jobs that Amazon S3 will include in the <code>List Jobs</code> response. If there are more jobs than this number, the response will include a pagination token in the <code>NextToken</code> field to enable you to retrieve the next page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of jobs that Amazon S3 will include in the <code>List Jobs</code> response. If there are more jobs than this number, the response will include a pagination token in the <code>NextToken</code> field to enable you to retrieve the next page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJobsInput`](crate::input::ListJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListJobsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListJobsInput {
                account_id: self.account_id,
                job_statuses: self.job_statuses,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListJobsInputOperationOutputAlias = crate::operation::ListJobs;
#[doc(hidden)]
pub type ListJobsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListJobs`](crate::operation::ListJobs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListJobs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v20180820/jobs").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListJobsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_37) = &_input.job_statuses {
                for inner_38 in inner_37 {
                    query.push_kv(
                        "jobStatuses",
                        &aws_smithy_http::query::fmt_string(&inner_38),
                    );
                }
            }
            if let Some(inner_39) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_39));
            }
            if let Some(inner_40) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_40).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_list_jobs(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListJobs::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListJobs",
                    "s3control",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListJobsInput`](crate::input::ListJobsInput)
    pub fn builder() -> crate::input::list_jobs_input::Builder {
        crate::input::list_jobs_input::Builder::default()
    }
}

/// See [`ListMultiRegionAccessPointsInput`](crate::input::ListMultiRegionAccessPointsInput)
pub mod list_multi_region_access_points_input {
    /// A builder for [`ListMultiRegionAccessPointsInput`](crate::input::ListMultiRegionAccessPointsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>Not currently used. Do not use this parameter.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Not currently used. Do not use this parameter.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Not currently used. Do not use this parameter.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Not currently used. Do not use this parameter.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMultiRegionAccessPointsInput`](crate::input::ListMultiRegionAccessPointsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListMultiRegionAccessPointsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListMultiRegionAccessPointsInput {
                account_id: self.account_id,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListMultiRegionAccessPointsInputOperationOutputAlias =
    crate::operation::ListMultiRegionAccessPoints;
#[doc(hidden)]
pub type ListMultiRegionAccessPointsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListMultiRegionAccessPointsInput {
    /// Consumes the builder and constructs an Operation<[`ListMultiRegionAccessPoints`](crate::operation::ListMultiRegionAccessPoints)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListMultiRegionAccessPoints,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListMultiRegionAccessPointsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v20180820/mrap/instances").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListMultiRegionAccessPointsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_41) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_41));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListMultiRegionAccessPointsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder =
                crate::http_serde::add_headers_list_multi_region_access_points(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListMultiRegionAccessPointsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListMultiRegionAccessPoints::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListMultiRegionAccessPoints",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListMultiRegionAccessPointsInput`](crate::input::ListMultiRegionAccessPointsInput)
    pub fn builder() -> crate::input::list_multi_region_access_points_input::Builder {
        crate::input::list_multi_region_access_points_input::Builder::default()
    }
}

/// See [`ListRegionalBucketsInput`](crate::input::ListRegionalBucketsInput)
pub mod list_regional_buckets_input {
    /// A builder for [`ListRegionalBucketsInput`](crate::input::ListRegionalBucketsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) outpost_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p></p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p></p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p></p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The ID of the Outposts.</p> <note>
        /// <p>This is required by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn outpost_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_id = Some(input.into());
            self
        }
        /// <p>The ID of the Outposts.</p> <note>
        /// <p>This is required by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_outpost_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.outpost_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRegionalBucketsInput`](crate::input::ListRegionalBucketsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRegionalBucketsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRegionalBucketsInput {
                account_id: self.account_id,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
                outpost_id: self.outpost_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRegionalBucketsInputOperationOutputAlias = crate::operation::ListRegionalBuckets;
#[doc(hidden)]
pub type ListRegionalBucketsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListRegionalBucketsInput {
    /// Consumes the builder and constructs an Operation<[`ListRegionalBuckets`](crate::operation::ListRegionalBuckets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRegionalBuckets,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRegionalBucketsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v20180820/bucket").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListRegionalBucketsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_42) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_42));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRegionalBucketsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_list_regional_buckets(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRegionalBucketsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRegionalBuckets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRegionalBuckets",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRegionalBucketsInput`](crate::input::ListRegionalBucketsInput)
    pub fn builder() -> crate::input::list_regional_buckets_input::Builder {
        crate::input::list_regional_buckets_input::Builder::default()
    }
}

/// See [`ListStorageLensConfigurationsInput`](crate::input::ListStorageLensConfigurationsInput)
pub mod list_storage_lens_configurations_input {
    /// A builder for [`ListStorageLensConfigurationsInput`](crate::input::ListStorageLensConfigurationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID of the requester.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>A pagination token to request the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStorageLensConfigurationsInput`](crate::input::ListStorageLensConfigurationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListStorageLensConfigurationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListStorageLensConfigurationsInput {
                account_id: self.account_id,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListStorageLensConfigurationsInputOperationOutputAlias =
    crate::operation::ListStorageLensConfigurations;
#[doc(hidden)]
pub type ListStorageLensConfigurationsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListStorageLensConfigurationsInput {
    /// Consumes the builder and constructs an Operation<[`ListStorageLensConfigurations`](crate::operation::ListStorageLensConfigurations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListStorageLensConfigurations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListStorageLensConfigurationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v20180820/storagelens").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListStorageLensConfigurationsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_43) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_43));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListStorageLensConfigurationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder =
                crate::http_serde::add_headers_list_storage_lens_configurations(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListStorageLensConfigurationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListStorageLensConfigurations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListStorageLensConfigurations",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListStorageLensConfigurationsInput`](crate::input::ListStorageLensConfigurationsInput)
    pub fn builder() -> crate::input::list_storage_lens_configurations_input::Builder {
        crate::input::list_storage_lens_configurations_input::Builder::default()
    }
}

/// See [`PutAccessPointConfigurationForObjectLambdaInput`](crate::input::PutAccessPointConfigurationForObjectLambdaInput)
pub mod put_access_point_configuration_for_object_lambda_input {
    /// A builder for [`PutAccessPointConfigurationForObjectLambdaInput`](crate::input::PutAccessPointConfigurationForObjectLambdaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) configuration: std::option::Option<crate::model::ObjectLambdaConfiguration>,
    }
    impl Builder {
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Object Lambda Access Point configuration document.</p>
        pub fn configuration(mut self, input: crate::model::ObjectLambdaConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>Object Lambda Access Point configuration document.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ObjectLambdaConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`PutAccessPointConfigurationForObjectLambdaInput`](crate::input::PutAccessPointConfigurationForObjectLambdaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutAccessPointConfigurationForObjectLambdaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::PutAccessPointConfigurationForObjectLambdaInput {
                    account_id: self.account_id,
                    name: self.name,
                    configuration: self.configuration,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type PutAccessPointConfigurationForObjectLambdaInputOperationOutputAlias =
    crate::operation::PutAccessPointConfigurationForObjectLambda;
#[doc(hidden)]
pub type PutAccessPointConfigurationForObjectLambdaInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutAccessPointConfigurationForObjectLambdaInput {
    /// Consumes the builder and constructs an Operation<[`PutAccessPointConfigurationForObjectLambda`](crate::operation::PutAccessPointConfigurationForObjectLambda)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutAccessPointConfigurationForObjectLambda,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutAccessPointConfigurationForObjectLambdaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_44 = &_input.name;
            let input_44 =
                input_44
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_44, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v20180820/accesspointforobjectlambda/{Name}/configuration",
                Name = name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutAccessPointConfigurationForObjectLambdaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder =
                crate::http_serde::add_headers_put_access_point_configuration_for_object_lambda(
                    input, builder,
                )?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutAccessPointConfigurationForObjectLambdaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_access_point_configuration_for_object_lambda(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutAccessPointConfigurationForObjectLambda::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutAccessPointConfigurationForObjectLambda",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutAccessPointConfigurationForObjectLambdaInput`](crate::input::PutAccessPointConfigurationForObjectLambdaInput)
    pub fn builder() -> crate::input::put_access_point_configuration_for_object_lambda_input::Builder
    {
        crate::input::put_access_point_configuration_for_object_lambda_input::Builder::default()
    }
}

/// See [`PutAccessPointPolicyInput`](crate::input::PutAccessPointPolicyInput)
pub mod put_access_point_policy_input {
    /// A builder for [`PutAccessPointPolicyInput`](crate::input::PutAccessPointPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID for owner of the bucket associated with the specified access point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for owner of the bucket associated with the specified access point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the access point that you want to associate with the specified policy.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /accesspoint/
        /// <my-accesspoint-name></my-accesspoint-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the access point that you want to associate with the specified policy.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /accesspoint/
        /// <my-accesspoint-name></my-accesspoint-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The policy that you want to apply to the specified access point. For more information about access point policies, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">Managing data access with Amazon S3 access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The policy that you want to apply to the specified access point. For more information about access point policies, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">Managing data access with Amazon S3 access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutAccessPointPolicyInput`](crate::input::PutAccessPointPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutAccessPointPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutAccessPointPolicyInput {
                account_id: self.account_id,
                name: self.name,
                policy: self.policy,
            })
        }
    }
}
#[doc(hidden)]
pub type PutAccessPointPolicyInputOperationOutputAlias = crate::operation::PutAccessPointPolicy;
#[doc(hidden)]
pub type PutAccessPointPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutAccessPointPolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutAccessPointPolicy`](crate::operation::PutAccessPointPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutAccessPointPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutAccessPointPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_45 = &_input.name;
            let input_45 =
                input_45
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_45, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v20180820/accesspoint/{Name}/policy", Name = name)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutAccessPointPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_put_access_point_policy(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutAccessPointPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_access_point_policy(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutAccessPointPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutAccessPointPolicy",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutAccessPointPolicyInput`](crate::input::PutAccessPointPolicyInput)
    pub fn builder() -> crate::input::put_access_point_policy_input::Builder {
        crate::input::put_access_point_policy_input::Builder::default()
    }
}

/// See [`PutAccessPointPolicyForObjectLambdaInput`](crate::input::PutAccessPointPolicyForObjectLambdaInput)
pub mod put_access_point_policy_for_object_lambda_input {
    /// A builder for [`PutAccessPointPolicyForObjectLambdaInput`](crate::input::PutAccessPointPolicyForObjectLambdaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Object Lambda Access Point resource policy document.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>Object Lambda Access Point resource policy document.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutAccessPointPolicyForObjectLambdaInput`](crate::input::PutAccessPointPolicyForObjectLambdaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutAccessPointPolicyForObjectLambdaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutAccessPointPolicyForObjectLambdaInput {
                account_id: self.account_id,
                name: self.name,
                policy: self.policy,
            })
        }
    }
}
#[doc(hidden)]
pub type PutAccessPointPolicyForObjectLambdaInputOperationOutputAlias =
    crate::operation::PutAccessPointPolicyForObjectLambda;
#[doc(hidden)]
pub type PutAccessPointPolicyForObjectLambdaInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutAccessPointPolicyForObjectLambdaInput {
    /// Consumes the builder and constructs an Operation<[`PutAccessPointPolicyForObjectLambda`](crate::operation::PutAccessPointPolicyForObjectLambda)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutAccessPointPolicyForObjectLambda,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutAccessPointPolicyForObjectLambdaInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_46 = &_input.name;
            let input_46 =
                input_46
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_46, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v20180820/accesspointforobjectlambda/{Name}/policy",
                Name = name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutAccessPointPolicyForObjectLambdaInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_put_access_point_policy_for_object_lambda(
                input, builder,
            )?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutAccessPointPolicyForObjectLambdaInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_access_point_policy_for_object_lambda(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutAccessPointPolicyForObjectLambda::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutAccessPointPolicyForObjectLambda",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutAccessPointPolicyForObjectLambdaInput`](crate::input::PutAccessPointPolicyForObjectLambdaInput)
    pub fn builder() -> crate::input::put_access_point_policy_for_object_lambda_input::Builder {
        crate::input::put_access_point_policy_for_object_lambda_input::Builder::default()
    }
}

/// See [`PutBucketLifecycleConfigurationInput`](crate::input::PutBucketLifecycleConfigurationInput)
pub mod put_bucket_lifecycle_configuration_input {
    /// A builder for [`PutBucketLifecycleConfigurationInput`](crate::input::PutBucketLifecycleConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) lifecycle_configuration:
            std::option::Option<crate::model::LifecycleConfiguration>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the bucket for which to set the configuration.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket for which to set the configuration.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Container for lifecycle rules. You can add as many as 1,000 rules.</p>
        pub fn lifecycle_configuration(
            mut self,
            input: crate::model::LifecycleConfiguration,
        ) -> Self {
            self.lifecycle_configuration = Some(input);
            self
        }
        /// <p>Container for lifecycle rules. You can add as many as 1,000 rules.</p>
        pub fn set_lifecycle_configuration(
            mut self,
            input: std::option::Option<crate::model::LifecycleConfiguration>,
        ) -> Self {
            self.lifecycle_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketLifecycleConfigurationInput`](crate::input::PutBucketLifecycleConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketLifecycleConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBucketLifecycleConfigurationInput {
                account_id: self.account_id,
                bucket: self.bucket,
                lifecycle_configuration: self.lifecycle_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBucketLifecycleConfigurationInputOperationOutputAlias =
    crate::operation::PutBucketLifecycleConfiguration;
#[doc(hidden)]
pub type PutBucketLifecycleConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketLifecycleConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketLifecycleConfiguration`](crate::operation::PutBucketLifecycleConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketLifecycleConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutBucketLifecycleConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_47 = &_input.bucket;
            let input_47 =
                input_47
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_47, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v20180820/bucket/{Bucket}/lifecycleconfiguration",
                Bucket = bucket
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutBucketLifecycleConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder =
                crate::http_serde::add_headers_put_bucket_lifecycle_configuration(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutBucketLifecycleConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_put_bucket_lifecycle_configuration_input(
                &self.lifecycle_configuration,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketLifecycleConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketLifecycleConfiguration",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutBucketLifecycleConfigurationInput`](crate::input::PutBucketLifecycleConfigurationInput)
    pub fn builder() -> crate::input::put_bucket_lifecycle_configuration_input::Builder {
        crate::input::put_bucket_lifecycle_configuration_input::Builder::default()
    }
}

/// See [`PutBucketPolicyInput`](crate::input::PutBucketPolicyInput)
pub mod put_bucket_policy_input {
    /// A builder for [`PutBucketPolicyInput`](crate::input::PutBucketPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) confirm_remove_self_bucket_access: std::option::Option<bool>,
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Set this parameter to true to confirm that you want to remove your permissions to change this bucket policy in the future.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn confirm_remove_self_bucket_access(mut self, input: bool) -> Self {
            self.confirm_remove_self_bucket_access = Some(input);
            self
        }
        /// <p>Set this parameter to true to confirm that you want to remove your permissions to change this bucket policy in the future.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_confirm_remove_self_bucket_access(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.confirm_remove_self_bucket_access = input;
            self
        }
        /// <p>The bucket policy as a JSON document.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The bucket policy as a JSON document.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketPolicyInput`](crate::input::PutBucketPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBucketPolicyInput {
                account_id: self.account_id,
                bucket: self.bucket,
                confirm_remove_self_bucket_access: self
                    .confirm_remove_self_bucket_access
                    .unwrap_or_default(),
                policy: self.policy,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBucketPolicyInputOperationOutputAlias = crate::operation::PutBucketPolicy;
#[doc(hidden)]
pub type PutBucketPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketPolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketPolicy`](crate::operation::PutBucketPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutBucketPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_48 = &_input.bucket;
            let input_48 =
                input_48
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_48, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v20180820/bucket/{Bucket}/policy", Bucket = bucket)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutBucketPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_put_bucket_policy(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutBucketPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_bucket_policy(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketPolicy",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutBucketPolicyInput`](crate::input::PutBucketPolicyInput)
    pub fn builder() -> crate::input::put_bucket_policy_input::Builder {
        crate::input::put_bucket_policy_input::Builder::default()
    }
}

/// See [`PutBucketTaggingInput`](crate::input::PutBucketTaggingInput)
pub mod put_bucket_tagging_input {
    /// A builder for [`PutBucketTaggingInput`](crate::input::PutBucketTaggingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) tagging: std::option::Option<crate::model::Tagging>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /bucket/
        /// <my-bucket-name></my-bucket-name>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p></p>
        pub fn tagging(mut self, input: crate::model::Tagging) -> Self {
            self.tagging = Some(input);
            self
        }
        /// <p></p>
        pub fn set_tagging(mut self, input: std::option::Option<crate::model::Tagging>) -> Self {
            self.tagging = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketTaggingInput`](crate::input::PutBucketTaggingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketTaggingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBucketTaggingInput {
                account_id: self.account_id,
                bucket: self.bucket,
                tagging: self.tagging,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBucketTaggingInputOperationOutputAlias = crate::operation::PutBucketTagging;
#[doc(hidden)]
pub type PutBucketTaggingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketTaggingInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketTagging`](crate::operation::PutBucketTagging)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketTagging,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutBucketTaggingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_49 = &_input.bucket;
            let input_49 =
                input_49
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_49, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v20180820/bucket/{Bucket}/tagging",
                Bucket = bucket
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutBucketTaggingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_put_bucket_tagging(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutBucketTaggingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_put_bucket_tagging_input(&self.tagging)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketTagging::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketTagging",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutBucketTaggingInput`](crate::input::PutBucketTaggingInput)
    pub fn builder() -> crate::input::put_bucket_tagging_input::Builder {
        crate::input::put_bucket_tagging_input::Builder::default()
    }
}

/// See [`PutJobTaggingInput`](crate::input::PutJobTaggingInput)
pub mod put_job_tagging_input {
    /// A builder for [`PutJobTaggingInput`](crate::input::PutJobTaggingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The ID for the S3 Batch Operations job whose tags you want to replace.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for the S3 Batch Operations job whose tags you want to replace.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The set of tags to associate with the S3 Batch Operations job.</p>
        pub fn tags(mut self, input: crate::model::S3Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The set of tags to associate with the S3 Batch Operations job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PutJobTaggingInput`](crate::input::PutJobTaggingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutJobTaggingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutJobTaggingInput {
                account_id: self.account_id,
                job_id: self.job_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type PutJobTaggingInputOperationOutputAlias = crate::operation::PutJobTagging;
#[doc(hidden)]
pub type PutJobTaggingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutJobTaggingInput {
    /// Consumes the builder and constructs an Operation<[`PutJobTagging`](crate::operation::PutJobTagging)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutJobTagging,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutJobTaggingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_50 = &_input.job_id;
            let input_50 =
                input_50
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    })?;
            let job_id = aws_smithy_http::label::fmt_string(input_50, false);
            if job_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "job_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v20180820/jobs/{JobId}/tagging", JobId = job_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutJobTaggingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_put_job_tagging(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutJobTaggingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_job_tagging(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutJobTagging::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutJobTagging",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutJobTaggingInput`](crate::input::PutJobTaggingInput)
    pub fn builder() -> crate::input::put_job_tagging_input::Builder {
        crate::input::put_job_tagging_input::Builder::default()
    }
}

/// See [`PutMultiRegionAccessPointPolicyInput`](crate::input::PutMultiRegionAccessPointPolicyInput)
pub mod put_multi_region_access_point_policy_input {
    /// A builder for [`PutMultiRegionAccessPointPolicyInput`](crate::input::PutMultiRegionAccessPointPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) details: std::option::Option<crate::model::PutMultiRegionAccessPointPolicyInput>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>An idempotency token used to identify the request and guarantee that requests are unique.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>An idempotency token used to identify the request and guarantee that requests are unique.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>A container element containing the details of the policy for the Multi-Region Access Point.</p>
        pub fn details(
            mut self,
            input: crate::model::PutMultiRegionAccessPointPolicyInput,
        ) -> Self {
            self.details = Some(input);
            self
        }
        /// <p>A container element containing the details of the policy for the Multi-Region Access Point.</p>
        pub fn set_details(
            mut self,
            input: std::option::Option<crate::model::PutMultiRegionAccessPointPolicyInput>,
        ) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`PutMultiRegionAccessPointPolicyInput`](crate::input::PutMultiRegionAccessPointPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutMultiRegionAccessPointPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutMultiRegionAccessPointPolicyInput {
                account_id: self.account_id,
                client_token: self.client_token,
                details: self.details,
            })
        }
    }
}
#[doc(hidden)]
pub type PutMultiRegionAccessPointPolicyInputOperationOutputAlias =
    crate::operation::PutMultiRegionAccessPointPolicy;
#[doc(hidden)]
pub type PutMultiRegionAccessPointPolicyInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutMultiRegionAccessPointPolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutMultiRegionAccessPointPolicy`](crate::operation::PutMultiRegionAccessPointPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutMultiRegionAccessPointPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutMultiRegionAccessPointPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v20180820/async-requests/mrap/put-policy")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutMultiRegionAccessPointPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_put_multi_region_access_point_policy(
                input, builder,
            )?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutMultiRegionAccessPointPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_multi_region_access_point_policy(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutMultiRegionAccessPointPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutMultiRegionAccessPointPolicy",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutMultiRegionAccessPointPolicyInput`](crate::input::PutMultiRegionAccessPointPolicyInput)
    pub fn builder() -> crate::input::put_multi_region_access_point_policy_input::Builder {
        crate::input::put_multi_region_access_point_policy_input::Builder::default()
    }
}

/// See [`PutPublicAccessBlockInput`](crate::input::PutPublicAccessBlockInput)
pub mod put_public_access_block_input {
    /// A builder for [`PutPublicAccessBlockInput`](crate::input::PutPublicAccessBlockInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) public_access_block_configuration:
            std::option::Option<crate::model::PublicAccessBlockConfiguration>,
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>PublicAccessBlock</code> configuration that you want to apply to the specified Amazon Web Services account.</p>
        pub fn public_access_block_configuration(
            mut self,
            input: crate::model::PublicAccessBlockConfiguration,
        ) -> Self {
            self.public_access_block_configuration = Some(input);
            self
        }
        /// <p>The <code>PublicAccessBlock</code> configuration that you want to apply to the specified Amazon Web Services account.</p>
        pub fn set_public_access_block_configuration(
            mut self,
            input: std::option::Option<crate::model::PublicAccessBlockConfiguration>,
        ) -> Self {
            self.public_access_block_configuration = input;
            self
        }
        /// <p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want to set.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want to set.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PutPublicAccessBlockInput`](crate::input::PutPublicAccessBlockInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutPublicAccessBlockInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutPublicAccessBlockInput {
                public_access_block_configuration: self.public_access_block_configuration,
                account_id: self.account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type PutPublicAccessBlockInputOperationOutputAlias = crate::operation::PutPublicAccessBlock;
#[doc(hidden)]
pub type PutPublicAccessBlockInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutPublicAccessBlockInput {
    /// Consumes the builder and constructs an Operation<[`PutPublicAccessBlock`](crate::operation::PutPublicAccessBlock)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutPublicAccessBlock,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutPublicAccessBlockInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v20180820/configuration/publicAccessBlock")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutPublicAccessBlockInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_put_public_access_block(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutPublicAccessBlockInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_put_public_access_block_input(
                &self.public_access_block_configuration,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutPublicAccessBlock::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutPublicAccessBlock",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutPublicAccessBlockInput`](crate::input::PutPublicAccessBlockInput)
    pub fn builder() -> crate::input::put_public_access_block_input::Builder {
        crate::input::put_public_access_block_input::Builder::default()
    }
}

/// See [`PutStorageLensConfigurationInput`](crate::input::PutStorageLensConfigurationInput)
pub mod put_storage_lens_configuration_input {
    /// A builder for [`PutStorageLensConfigurationInput`](crate::input::PutStorageLensConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_id: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) storage_lens_configuration:
            std::option::Option<crate::model::StorageLensConfiguration>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::StorageLensTag>>,
    }
    impl Builder {
        /// <p>The ID of the S3 Storage Lens configuration.</p>
        pub fn config_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_id = Some(input.into());
            self
        }
        /// <p>The ID of the S3 Storage Lens configuration.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.config_id = input;
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The S3 Storage Lens configuration.</p>
        pub fn storage_lens_configuration(
            mut self,
            input: crate::model::StorageLensConfiguration,
        ) -> Self {
            self.storage_lens_configuration = Some(input);
            self
        }
        /// <p>The S3 Storage Lens configuration.</p>
        pub fn set_storage_lens_configuration(
            mut self,
            input: std::option::Option<crate::model::StorageLensConfiguration>,
        ) -> Self {
            self.storage_lens_configuration = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag set of the S3 Storage Lens configuration.</p> <note>
        /// <p>You can set up to a maximum of 50 tags.</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::StorageLensTag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag set of the S3 Storage Lens configuration.</p> <note>
        /// <p>You can set up to a maximum of 50 tags.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StorageLensTag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PutStorageLensConfigurationInput`](crate::input::PutStorageLensConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutStorageLensConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutStorageLensConfigurationInput {
                config_id: self.config_id,
                account_id: self.account_id,
                storage_lens_configuration: self.storage_lens_configuration,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type PutStorageLensConfigurationInputOperationOutputAlias =
    crate::operation::PutStorageLensConfiguration;
#[doc(hidden)]
pub type PutStorageLensConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutStorageLensConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutStorageLensConfiguration`](crate::operation::PutStorageLensConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutStorageLensConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutStorageLensConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_51 = &_input.config_id;
            let input_51 =
                input_51
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "config_id",
                        details: "cannot be empty or unset",
                    })?;
            let config_id = aws_smithy_http::label::fmt_string(input_51, false);
            if config_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "config_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v20180820/storagelens/{ConfigId}",
                ConfigId = config_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutStorageLensConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder =
                crate::http_serde::add_headers_put_storage_lens_configuration(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutStorageLensConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_storage_lens_configuration(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutStorageLensConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutStorageLensConfiguration",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutStorageLensConfigurationInput`](crate::input::PutStorageLensConfigurationInput)
    pub fn builder() -> crate::input::put_storage_lens_configuration_input::Builder {
        crate::input::put_storage_lens_configuration_input::Builder::default()
    }
}

/// See [`PutStorageLensConfigurationTaggingInput`](crate::input::PutStorageLensConfigurationTaggingInput)
pub mod put_storage_lens_configuration_tagging_input {
    /// A builder for [`PutStorageLensConfigurationTaggingInput`](crate::input::PutStorageLensConfigurationTaggingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) config_id: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::StorageLensTag>>,
    }
    impl Builder {
        /// <p>The ID of the S3 Storage Lens configuration.</p>
        pub fn config_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.config_id = Some(input.into());
            self
        }
        /// <p>The ID of the S3 Storage Lens configuration.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.config_id = input;
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag set of the S3 Storage Lens configuration.</p> <note>
        /// <p>You can set up to a maximum of 50 tags.</p>
        /// </note>
        pub fn tags(mut self, input: crate::model::StorageLensTag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag set of the S3 Storage Lens configuration.</p> <note>
        /// <p>You can set up to a maximum of 50 tags.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StorageLensTag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PutStorageLensConfigurationTaggingInput`](crate::input::PutStorageLensConfigurationTaggingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutStorageLensConfigurationTaggingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutStorageLensConfigurationTaggingInput {
                config_id: self.config_id,
                account_id: self.account_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type PutStorageLensConfigurationTaggingInputOperationOutputAlias =
    crate::operation::PutStorageLensConfigurationTagging;
#[doc(hidden)]
pub type PutStorageLensConfigurationTaggingInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutStorageLensConfigurationTaggingInput {
    /// Consumes the builder and constructs an Operation<[`PutStorageLensConfigurationTagging`](crate::operation::PutStorageLensConfigurationTagging)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutStorageLensConfigurationTagging,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutStorageLensConfigurationTaggingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_52 = &_input.config_id;
            let input_52 =
                input_52
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "config_id",
                        details: "cannot be empty or unset",
                    })?;
            let config_id = aws_smithy_http::label::fmt_string(input_52, false);
            if config_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "config_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v20180820/storagelens/{ConfigId}/tagging",
                ConfigId = config_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutStorageLensConfigurationTaggingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_put_storage_lens_configuration_tagging(
                input, builder,
            )?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutStorageLensConfigurationTaggingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_storage_lens_configuration_tagging(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutStorageLensConfigurationTagging::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutStorageLensConfigurationTagging",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutStorageLensConfigurationTaggingInput`](crate::input::PutStorageLensConfigurationTaggingInput)
    pub fn builder() -> crate::input::put_storage_lens_configuration_tagging_input::Builder {
        crate::input::put_storage_lens_configuration_tagging_input::Builder::default()
    }
}

/// See [`UpdateJobPriorityInput`](crate::input::UpdateJobPriorityInput)
pub mod update_job_priority_input {
    /// A builder for [`UpdateJobPriorityInput`](crate::input::UpdateJobPriorityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) priority: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The ID for the job whose priority you want to update.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for the job whose priority you want to update.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The priority you want to assign to this job.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The priority you want to assign to this job.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateJobPriorityInput`](crate::input::UpdateJobPriorityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateJobPriorityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateJobPriorityInput {
                account_id: self.account_id,
                job_id: self.job_id,
                priority: self.priority.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateJobPriorityInputOperationOutputAlias = crate::operation::UpdateJobPriority;
#[doc(hidden)]
pub type UpdateJobPriorityInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateJobPriorityInput {
    /// Consumes the builder and constructs an Operation<[`UpdateJobPriority`](crate::operation::UpdateJobPriority)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateJobPriority,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateJobPriorityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_53 = &_input.job_id;
            let input_53 =
                input_53
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    })?;
            let job_id = aws_smithy_http::label::fmt_string(input_53, false);
            if job_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "job_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v20180820/jobs/{JobId}/priority", JobId = job_id)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UpdateJobPriorityInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.priority != 0 {
                query.push_kv(
                    "priority",
                    aws_smithy_types::primitive::Encoder::from(_input.priority).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateJobPriorityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_update_job_priority(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateJobPriorityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateJobPriority::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateJobPriority",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateJobPriorityInput`](crate::input::UpdateJobPriorityInput)
    pub fn builder() -> crate::input::update_job_priority_input::Builder {
        crate::input::update_job_priority_input::Builder::default()
    }
}

/// See [`UpdateJobStatusInput`](crate::input::UpdateJobStatusInput)
pub mod update_job_status_input {
    /// A builder for [`UpdateJobStatusInput`](crate::input::UpdateJobStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) requested_job_status: std::option::Option<crate::model::RequestedJobStatus>,
        pub(crate) status_update_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The ID of the job whose status you want to update.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID of the job whose status you want to update.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The status that you want to move the specified job to.</p>
        pub fn requested_job_status(mut self, input: crate::model::RequestedJobStatus) -> Self {
            self.requested_job_status = Some(input);
            self
        }
        /// <p>The status that you want to move the specified job to.</p>
        pub fn set_requested_job_status(
            mut self,
            input: std::option::Option<crate::model::RequestedJobStatus>,
        ) -> Self {
            self.requested_job_status = input;
            self
        }
        /// <p>A description of the reason why you want to change the specified job's status. This field can be any string up to the maximum length.</p>
        pub fn status_update_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_update_reason = Some(input.into());
            self
        }
        /// <p>A description of the reason why you want to change the specified job's status. This field can be any string up to the maximum length.</p>
        pub fn set_status_update_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_update_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateJobStatusInput`](crate::input::UpdateJobStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateJobStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateJobStatusInput {
                account_id: self.account_id,
                job_id: self.job_id,
                requested_job_status: self.requested_job_status,
                status_update_reason: self.status_update_reason,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateJobStatusInputOperationOutputAlias = crate::operation::UpdateJobStatus;
#[doc(hidden)]
pub type UpdateJobStatusInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateJobStatusInput {
    /// Consumes the builder and constructs an Operation<[`UpdateJobStatus`](crate::operation::UpdateJobStatus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateJobStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateJobStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_54 = &_input.job_id;
            let input_54 =
                input_54
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    })?;
            let job_id = aws_smithy_http::label::fmt_string(input_54, false);
            if job_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "job_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v20180820/jobs/{JobId}/status", JobId = job_id)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UpdateJobStatusInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_55) = &_input.requested_job_status {
                query.push_kv(
                    "requestedJobStatus",
                    &aws_smithy_http::query::fmt_string(&inner_55),
                );
            }
            if let Some(inner_56) = &_input.status_update_reason {
                query.push_kv(
                    "statusUpdateReason",
                    &aws_smithy_http::query::fmt_string(&inner_56),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateJobStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = crate::http_serde::add_headers_update_job_status(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateJobStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = {
            let account_id = self.account_id.as_deref().unwrap_or_default();
            if account_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::InvalidField { field: "account_id", details: "account_id was unset or empty but must be set as part of the endpoint prefix".to_string() });
            }
            aws_smithy_http::endpoint::EndpointPrefix::new(format!(
                "{AccountId}.",
                AccountId = account_id
            ))
        }?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateJobStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateJobStatus",
            "s3control",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateJobStatusInput`](crate::input::UpdateJobStatusInput)
    pub fn builder() -> crate::input::update_job_status_input::Builder {
        crate::input::update_job_status_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateJobStatusInput {
    /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The ID of the job whose status you want to update.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The status that you want to move the specified job to.</p>
    pub requested_job_status: std::option::Option<crate::model::RequestedJobStatus>,
    /// <p>A description of the reason why you want to change the specified job's status. This field can be any string up to the maximum length.</p>
    pub status_update_reason: std::option::Option<std::string::String>,
}
impl UpdateJobStatusInput {
    /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The ID of the job whose status you want to update.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The status that you want to move the specified job to.</p>
    pub fn requested_job_status(&self) -> std::option::Option<&crate::model::RequestedJobStatus> {
        self.requested_job_status.as_ref()
    }
    /// <p>A description of the reason why you want to change the specified job's status. This field can be any string up to the maximum length.</p>
    pub fn status_update_reason(&self) -> std::option::Option<&str> {
        self.status_update_reason.as_deref()
    }
}
impl std::fmt::Debug for UpdateJobStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateJobStatusInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("job_id", &self.job_id);
        formatter.field("requested_job_status", &self.requested_job_status);
        formatter.field("status_update_reason", &self.status_update_reason);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateJobPriorityInput {
    /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The ID for the job whose priority you want to update.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The priority you want to assign to this job.</p>
    pub priority: i32,
}
impl UpdateJobPriorityInput {
    /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The ID for the job whose priority you want to update.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The priority you want to assign to this job.</p>
    pub fn priority(&self) -> i32 {
        self.priority
    }
}
impl std::fmt::Debug for UpdateJobPriorityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateJobPriorityInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("job_id", &self.job_id);
        formatter.field("priority", &self.priority);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutStorageLensConfigurationTaggingInput {
    /// <p>The ID of the S3 Storage Lens configuration.</p>
    pub config_id: std::option::Option<std::string::String>,
    /// <p>The account ID of the requester.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The tag set of the S3 Storage Lens configuration.</p> <note>
    /// <p>You can set up to a maximum of 50 tags.</p>
    /// </note>
    pub tags: std::option::Option<std::vec::Vec<crate::model::StorageLensTag>>,
}
impl PutStorageLensConfigurationTaggingInput {
    /// <p>The ID of the S3 Storage Lens configuration.</p>
    pub fn config_id(&self) -> std::option::Option<&str> {
        self.config_id.as_deref()
    }
    /// <p>The account ID of the requester.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The tag set of the S3 Storage Lens configuration.</p> <note>
    /// <p>You can set up to a maximum of 50 tags.</p>
    /// </note>
    pub fn tags(&self) -> std::option::Option<&[crate::model::StorageLensTag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for PutStorageLensConfigurationTaggingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutStorageLensConfigurationTaggingInput");
        formatter.field("config_id", &self.config_id);
        formatter.field("account_id", &self.account_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutStorageLensConfigurationInput {
    /// <p>The ID of the S3 Storage Lens configuration.</p>
    pub config_id: std::option::Option<std::string::String>,
    /// <p>The account ID of the requester.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The S3 Storage Lens configuration.</p>
    pub storage_lens_configuration: std::option::Option<crate::model::StorageLensConfiguration>,
    /// <p>The tag set of the S3 Storage Lens configuration.</p> <note>
    /// <p>You can set up to a maximum of 50 tags.</p>
    /// </note>
    pub tags: std::option::Option<std::vec::Vec<crate::model::StorageLensTag>>,
}
impl PutStorageLensConfigurationInput {
    /// <p>The ID of the S3 Storage Lens configuration.</p>
    pub fn config_id(&self) -> std::option::Option<&str> {
        self.config_id.as_deref()
    }
    /// <p>The account ID of the requester.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The S3 Storage Lens configuration.</p>
    pub fn storage_lens_configuration(
        &self,
    ) -> std::option::Option<&crate::model::StorageLensConfiguration> {
        self.storage_lens_configuration.as_ref()
    }
    /// <p>The tag set of the S3 Storage Lens configuration.</p> <note>
    /// <p>You can set up to a maximum of 50 tags.</p>
    /// </note>
    pub fn tags(&self) -> std::option::Option<&[crate::model::StorageLensTag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for PutStorageLensConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutStorageLensConfigurationInput");
        formatter.field("config_id", &self.config_id);
        formatter.field("account_id", &self.account_id);
        formatter.field(
            "storage_lens_configuration",
            &self.storage_lens_configuration,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutPublicAccessBlockInput {
    /// <p>The <code>PublicAccessBlock</code> configuration that you want to apply to the specified Amazon Web Services account.</p>
    pub public_access_block_configuration:
        std::option::Option<crate::model::PublicAccessBlockConfiguration>,
    /// <p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want to set.</p>
    pub account_id: std::option::Option<std::string::String>,
}
impl PutPublicAccessBlockInput {
    /// <p>The <code>PublicAccessBlock</code> configuration that you want to apply to the specified Amazon Web Services account.</p>
    pub fn public_access_block_configuration(
        &self,
    ) -> std::option::Option<&crate::model::PublicAccessBlockConfiguration> {
        self.public_access_block_configuration.as_ref()
    }
    /// <p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want to set.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for PutPublicAccessBlockInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutPublicAccessBlockInput");
        formatter.field(
            "public_access_block_configuration",
            &self.public_access_block_configuration,
        );
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutMultiRegionAccessPointPolicyInput {
    /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>An idempotency token used to identify the request and guarantee that requests are unique.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>A container element containing the details of the policy for the Multi-Region Access Point.</p>
    pub details: std::option::Option<crate::model::PutMultiRegionAccessPointPolicyInput>,
}
impl PutMultiRegionAccessPointPolicyInput {
    /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>An idempotency token used to identify the request and guarantee that requests are unique.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>A container element containing the details of the policy for the Multi-Region Access Point.</p>
    pub fn details(
        &self,
    ) -> std::option::Option<&crate::model::PutMultiRegionAccessPointPolicyInput> {
        self.details.as_ref()
    }
}
impl std::fmt::Debug for PutMultiRegionAccessPointPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutMultiRegionAccessPointPolicyInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("client_token", &self.client_token);
        formatter.field("details", &self.details);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutJobTaggingInput {
    /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The ID for the S3 Batch Operations job whose tags you want to replace.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The set of tags to associate with the S3 Batch Operations job.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
}
impl PutJobTaggingInput {
    /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The ID for the S3 Batch Operations job whose tags you want to replace.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The set of tags to associate with the S3 Batch Operations job.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::S3Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for PutJobTaggingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutJobTaggingInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("job_id", &self.job_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBucketTaggingInput {
    /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /bucket/
    /// <my-bucket-name></my-bucket-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p></p>
    pub tagging: std::option::Option<crate::model::Tagging>,
}
impl PutBucketTaggingInput {
    /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /bucket/
    /// <my-bucket-name></my-bucket-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p></p>
    pub fn tagging(&self) -> std::option::Option<&crate::model::Tagging> {
        self.tagging.as_ref()
    }
}
impl std::fmt::Debug for PutBucketTaggingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBucketTaggingInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("bucket", &self.bucket);
        formatter.field("tagging", &self.tagging);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBucketPolicyInput {
    /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>Specifies the bucket.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /bucket/
    /// <my-bucket-name></my-bucket-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>Set this parameter to true to confirm that you want to remove your permissions to change this bucket policy in the future.</p> <note>
    /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub confirm_remove_self_bucket_access: bool,
    /// <p>The bucket policy as a JSON document.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl PutBucketPolicyInput {
    /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>Specifies the bucket.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /bucket/
    /// <my-bucket-name></my-bucket-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>Set this parameter to true to confirm that you want to remove your permissions to change this bucket policy in the future.</p> <note>
    /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub fn confirm_remove_self_bucket_access(&self) -> bool {
        self.confirm_remove_self_bucket_access
    }
    /// <p>The bucket policy as a JSON document.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for PutBucketPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBucketPolicyInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("bucket", &self.bucket);
        formatter.field(
            "confirm_remove_self_bucket_access",
            &self.confirm_remove_self_bucket_access,
        );
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBucketLifecycleConfigurationInput {
    /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the bucket for which to set the configuration.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>Container for lifecycle rules. You can add as many as 1,000 rules.</p>
    pub lifecycle_configuration: std::option::Option<crate::model::LifecycleConfiguration>,
}
impl PutBucketLifecycleConfigurationInput {
    /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the bucket for which to set the configuration.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>Container for lifecycle rules. You can add as many as 1,000 rules.</p>
    pub fn lifecycle_configuration(
        &self,
    ) -> std::option::Option<&crate::model::LifecycleConfiguration> {
        self.lifecycle_configuration.as_ref()
    }
}
impl std::fmt::Debug for PutBucketLifecycleConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBucketLifecycleConfigurationInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("bucket", &self.bucket);
        formatter.field("lifecycle_configuration", &self.lifecycle_configuration);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAccessPointPolicyForObjectLambdaInput {
    /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the Object Lambda Access Point.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Object Lambda Access Point resource policy document.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl PutAccessPointPolicyForObjectLambdaInput {
    /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the Object Lambda Access Point.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Object Lambda Access Point resource policy document.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for PutAccessPointPolicyForObjectLambdaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAccessPointPolicyForObjectLambdaInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("name", &self.name);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAccessPointPolicyInput {
    /// <p>The Amazon Web Services account ID for owner of the bucket associated with the specified access point.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the access point that you want to associate with the specified policy.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /accesspoint/
    /// <my-accesspoint-name></my-accesspoint-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The policy that you want to apply to the specified access point. For more information about access point policies, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">Managing data access with Amazon S3 access points</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl PutAccessPointPolicyInput {
    /// <p>The Amazon Web Services account ID for owner of the bucket associated with the specified access point.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the access point that you want to associate with the specified policy.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /accesspoint/
    /// <my-accesspoint-name></my-accesspoint-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The policy that you want to apply to the specified access point. For more information about access point policies, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">Managing data access with Amazon S3 access points</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for PutAccessPointPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAccessPointPolicyInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("name", &self.name);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAccessPointConfigurationForObjectLambdaInput {
    /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the Object Lambda Access Point.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Object Lambda Access Point configuration document.</p>
    pub configuration: std::option::Option<crate::model::ObjectLambdaConfiguration>,
}
impl PutAccessPointConfigurationForObjectLambdaInput {
    /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the Object Lambda Access Point.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Object Lambda Access Point configuration document.</p>
    pub fn configuration(&self) -> std::option::Option<&crate::model::ObjectLambdaConfiguration> {
        self.configuration.as_ref()
    }
}
impl std::fmt::Debug for PutAccessPointConfigurationForObjectLambdaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAccessPointConfigurationForObjectLambdaInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("name", &self.name);
        formatter.field("configuration", &self.configuration);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStorageLensConfigurationsInput {
    /// <p>The account ID of the requester.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>A pagination token to request the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListStorageLensConfigurationsInput {
    /// <p>The account ID of the requester.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>A pagination token to request the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListStorageLensConfigurationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStorageLensConfigurationsInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRegionalBucketsInput {
    /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p></p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p></p>
    pub max_results: i32,
    /// <p>The ID of the Outposts.</p> <note>
    /// <p>This is required by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub outpost_id: std::option::Option<std::string::String>,
}
impl ListRegionalBucketsInput {
    /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p></p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p></p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The ID of the Outposts.</p> <note>
    /// <p>This is required by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub fn outpost_id(&self) -> std::option::Option<&str> {
        self.outpost_id.as_deref()
    }
}
impl std::fmt::Debug for ListRegionalBucketsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRegionalBucketsInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("outpost_id", &self.outpost_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMultiRegionAccessPointsInput {
    /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>Not currently used. Do not use this parameter.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Not currently used. Do not use this parameter.</p>
    pub max_results: i32,
}
impl ListMultiRegionAccessPointsInput {
    /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>Not currently used. Do not use this parameter.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Not currently used. Do not use this parameter.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListMultiRegionAccessPointsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMultiRegionAccessPointsInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJobsInput {
    /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The <code>List Jobs</code> request returns jobs that match the statuses listed in this element.</p>
    pub job_statuses: std::option::Option<std::vec::Vec<crate::model::JobStatus>>,
    /// <p>A pagination token to request the next page of results. Use the token that Amazon S3 returned in the <code>NextToken</code> element of the <code>ListJobsResult</code> from the previous <code>List Jobs</code> request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of jobs that Amazon S3 will include in the <code>List Jobs</code> response. If there are more jobs than this number, the response will include a pagination token in the <code>NextToken</code> field to enable you to retrieve the next page of results.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListJobsInput {
    /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The <code>List Jobs</code> request returns jobs that match the statuses listed in this element.</p>
    pub fn job_statuses(&self) -> std::option::Option<&[crate::model::JobStatus]> {
        self.job_statuses.as_deref()
    }
    /// <p>A pagination token to request the next page of results. Use the token that Amazon S3 returned in the <code>NextToken</code> element of the <code>ListJobsResult</code> from the previous <code>List Jobs</code> request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of jobs that Amazon S3 will include in the <code>List Jobs</code> response. If there are more jobs than this number, the response will include a pagination token in the <code>NextToken</code> field to enable you to retrieve the next page of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJobsInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("job_statuses", &self.job_statuses);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccessPointsForObjectLambdaInput {
    /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>If the list has more access points than can be returned in one call to this API, this field contains a continuation token that you can provide in subsequent calls to this API to retrieve additional access points.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of access points that you want to include in the list. The response may contain fewer access points but will never contain more. If there are more than this number of access points, then the response will include a continuation token in the <code>NextToken</code> field that you can use to retrieve the next page of access points.</p>
    pub max_results: i32,
}
impl ListAccessPointsForObjectLambdaInput {
    /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>If the list has more access points than can be returned in one call to this API, this field contains a continuation token that you can provide in subsequent calls to this API to retrieve additional access points.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of access points that you want to include in the list. The response may contain fewer access points but will never contain more. If there are more than this number of access points, then the response will include a continuation token in the <code>NextToken</code> field that you can use to retrieve the next page of access points.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListAccessPointsForObjectLambdaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccessPointsForObjectLambdaInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccessPointsInput {
    /// <p>The Amazon Web Services account ID for owner of the bucket whose access points you want to list.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the bucket whose associated access points you want to list.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /bucket/
    /// <my-bucket-name></my-bucket-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>A continuation token. If a previous call to <code>ListAccessPoints</code> returned a continuation token in the <code>NextToken</code> field, then providing that value here causes Amazon S3 to retrieve the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of access points that you want to include in the list. If the specified bucket has more than this number of access points, then the response will include a continuation token in the <code>NextToken</code> field that you can use to retrieve the next page of access points.</p>
    pub max_results: i32,
}
impl ListAccessPointsInput {
    /// <p>The Amazon Web Services account ID for owner of the bucket whose access points you want to list.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the bucket whose associated access points you want to list.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /bucket/
    /// <my-bucket-name></my-bucket-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>A continuation token. If a previous call to <code>ListAccessPoints</code> returned a continuation token in the <code>NextToken</code> field, then providing that value here causes Amazon S3 to retrieve the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of access points that you want to include in the list. If the specified bucket has more than this number of access points, then the response will include a continuation token in the <code>NextToken</code> field that you can use to retrieve the next page of access points.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListAccessPointsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccessPointsInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("bucket", &self.bucket);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStorageLensConfigurationTaggingInput {
    /// <p>The ID of the Amazon S3 Storage Lens configuration.</p>
    pub config_id: std::option::Option<std::string::String>,
    /// <p>The account ID of the requester.</p>
    pub account_id: std::option::Option<std::string::String>,
}
impl GetStorageLensConfigurationTaggingInput {
    /// <p>The ID of the Amazon S3 Storage Lens configuration.</p>
    pub fn config_id(&self) -> std::option::Option<&str> {
        self.config_id.as_deref()
    }
    /// <p>The account ID of the requester.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for GetStorageLensConfigurationTaggingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStorageLensConfigurationTaggingInput");
        formatter.field("config_id", &self.config_id);
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStorageLensConfigurationInput {
    /// <p>The ID of the Amazon S3 Storage Lens configuration.</p>
    pub config_id: std::option::Option<std::string::String>,
    /// <p>The account ID of the requester.</p>
    pub account_id: std::option::Option<std::string::String>,
}
impl GetStorageLensConfigurationInput {
    /// <p>The ID of the Amazon S3 Storage Lens configuration.</p>
    pub fn config_id(&self) -> std::option::Option<&str> {
        self.config_id.as_deref()
    }
    /// <p>The account ID of the requester.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for GetStorageLensConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStorageLensConfigurationInput");
        formatter.field("config_id", &self.config_id);
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPublicAccessBlockInput {
    /// <p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want to retrieve.</p>
    pub account_id: std::option::Option<std::string::String>,
}
impl GetPublicAccessBlockInput {
    /// <p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want to retrieve.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for GetPublicAccessBlockInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPublicAccessBlockInput");
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMultiRegionAccessPointPolicyStatusInput {
    /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>Specifies the Multi-Region Access Point. The name of the Multi-Region Access Point is different from the alias. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub name: std::option::Option<std::string::String>,
}
impl GetMultiRegionAccessPointPolicyStatusInput {
    /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>Specifies the Multi-Region Access Point. The name of the Multi-Region Access Point is different from the alias. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for GetMultiRegionAccessPointPolicyStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMultiRegionAccessPointPolicyStatusInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMultiRegionAccessPointPolicyInput {
    /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>Specifies the Multi-Region Access Point. The name of the Multi-Region Access Point is different from the alias. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub name: std::option::Option<std::string::String>,
}
impl GetMultiRegionAccessPointPolicyInput {
    /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>Specifies the Multi-Region Access Point. The name of the Multi-Region Access Point is different from the alias. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for GetMultiRegionAccessPointPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMultiRegionAccessPointPolicyInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMultiRegionAccessPointInput {
    /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the Multi-Region Access Point whose configuration information you want to receive. The name of the Multi-Region Access Point is different from the alias. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub name: std::option::Option<std::string::String>,
}
impl GetMultiRegionAccessPointInput {
    /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the Multi-Region Access Point whose configuration information you want to receive. The name of the Multi-Region Access Point is different from the alias. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for GetMultiRegionAccessPointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMultiRegionAccessPointInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetJobTaggingInput {
    /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The ID for the S3 Batch Operations job whose tags you want to retrieve.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl GetJobTaggingInput {
    /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The ID for the S3 Batch Operations job whose tags you want to retrieve.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for GetJobTaggingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetJobTaggingInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketTaggingInput {
    /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>Specifies the bucket.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /bucket/
    /// <my-bucket-name></my-bucket-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    pub bucket: std::option::Option<std::string::String>,
}
impl GetBucketTaggingInput {
    /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>Specifies the bucket.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /bucket/
    /// <my-bucket-name></my-bucket-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
}
impl std::fmt::Debug for GetBucketTaggingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketTaggingInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("bucket", &self.bucket);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketPolicyInput {
    /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>Specifies the bucket.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /bucket/
    /// <my-bucket-name></my-bucket-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    pub bucket: std::option::Option<std::string::String>,
}
impl GetBucketPolicyInput {
    /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>Specifies the bucket.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /bucket/
    /// <my-bucket-name></my-bucket-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
}
impl std::fmt::Debug for GetBucketPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketPolicyInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("bucket", &self.bucket);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketLifecycleConfigurationInput {
    /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /bucket/
    /// <my-bucket-name></my-bucket-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    pub bucket: std::option::Option<std::string::String>,
}
impl GetBucketLifecycleConfigurationInput {
    /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /bucket/
    /// <my-bucket-name></my-bucket-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
}
impl std::fmt::Debug for GetBucketLifecycleConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketLifecycleConfigurationInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("bucket", &self.bucket);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketInput {
    /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>Specifies the bucket.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /bucket/
    /// <my-bucket-name></my-bucket-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    pub bucket: std::option::Option<std::string::String>,
}
impl GetBucketInput {
    /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>Specifies the bucket.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /bucket/
    /// <my-bucket-name></my-bucket-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
}
impl std::fmt::Debug for GetBucketInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("bucket", &self.bucket);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccessPointPolicyStatusForObjectLambdaInput {
    /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the Object Lambda Access Point.</p>
    pub name: std::option::Option<std::string::String>,
}
impl GetAccessPointPolicyStatusForObjectLambdaInput {
    /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the Object Lambda Access Point.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for GetAccessPointPolicyStatusForObjectLambdaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccessPointPolicyStatusForObjectLambdaInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccessPointPolicyStatusInput {
    /// <p>The account ID for the account that owns the specified access point.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the access point whose policy status you want to retrieve.</p>
    pub name: std::option::Option<std::string::String>,
}
impl GetAccessPointPolicyStatusInput {
    /// <p>The account ID for the account that owns the specified access point.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the access point whose policy status you want to retrieve.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for GetAccessPointPolicyStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccessPointPolicyStatusInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccessPointPolicyForObjectLambdaInput {
    /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the Object Lambda Access Point.</p>
    pub name: std::option::Option<std::string::String>,
}
impl GetAccessPointPolicyForObjectLambdaInput {
    /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the Object Lambda Access Point.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for GetAccessPointPolicyForObjectLambdaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccessPointPolicyForObjectLambdaInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccessPointPolicyInput {
    /// <p>The account ID for the account that owns the specified access point.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the access point whose policy you want to retrieve.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /accesspoint/
    /// <my-accesspoint-name></my-accesspoint-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
    pub name: std::option::Option<std::string::String>,
}
impl GetAccessPointPolicyInput {
    /// <p>The account ID for the account that owns the specified access point.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the access point whose policy you want to retrieve.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /accesspoint/
    /// <my-accesspoint-name></my-accesspoint-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for GetAccessPointPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccessPointPolicyInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccessPointForObjectLambdaInput {
    /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the Object Lambda Access Point.</p>
    pub name: std::option::Option<std::string::String>,
}
impl GetAccessPointForObjectLambdaInput {
    /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the Object Lambda Access Point.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for GetAccessPointForObjectLambdaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccessPointForObjectLambdaInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccessPointConfigurationForObjectLambdaInput {
    /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the Object Lambda Access Point you want to return the configuration for.</p>
    pub name: std::option::Option<std::string::String>,
}
impl GetAccessPointConfigurationForObjectLambdaInput {
    /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the Object Lambda Access Point you want to return the configuration for.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for GetAccessPointConfigurationForObjectLambdaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccessPointConfigurationForObjectLambdaInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccessPointInput {
    /// <p>The account ID for the account that owns the specified access point.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the access point whose configuration information you want to retrieve.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /accesspoint/
    /// <my-accesspoint-name></my-accesspoint-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
    pub name: std::option::Option<std::string::String>,
}
impl GetAccessPointInput {
    /// <p>The account ID for the account that owns the specified access point.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the access point whose configuration information you want to retrieve.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /accesspoint/
    /// <my-accesspoint-name></my-accesspoint-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for GetAccessPointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccessPointInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMultiRegionAccessPointOperationInput {
    /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The request token associated with the request you want to know about. This request token is returned as part of the response when you make an asynchronous request. You provide this token to query about the status of the asynchronous action.</p>
    pub request_token_arn: std::option::Option<std::string::String>,
}
impl DescribeMultiRegionAccessPointOperationInput {
    /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The request token associated with the request you want to know about. This request token is returned as part of the response when you make an asynchronous request. You provide this token to query about the status of the asynchronous action.</p>
    pub fn request_token_arn(&self) -> std::option::Option<&str> {
        self.request_token_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeMultiRegionAccessPointOperationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMultiRegionAccessPointOperationInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("request_token_arn", &self.request_token_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeJobInput {
    /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The ID for the job whose information you want to retrieve.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl DescribeJobInput {
    /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The ID for the job whose information you want to retrieve.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeJobInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStorageLensConfigurationTaggingInput {
    /// <p>The ID of the S3 Storage Lens configuration.</p>
    pub config_id: std::option::Option<std::string::String>,
    /// <p>The account ID of the requester.</p>
    pub account_id: std::option::Option<std::string::String>,
}
impl DeleteStorageLensConfigurationTaggingInput {
    /// <p>The ID of the S3 Storage Lens configuration.</p>
    pub fn config_id(&self) -> std::option::Option<&str> {
        self.config_id.as_deref()
    }
    /// <p>The account ID of the requester.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteStorageLensConfigurationTaggingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStorageLensConfigurationTaggingInput");
        formatter.field("config_id", &self.config_id);
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStorageLensConfigurationInput {
    /// <p>The ID of the S3 Storage Lens configuration.</p>
    pub config_id: std::option::Option<std::string::String>,
    /// <p>The account ID of the requester.</p>
    pub account_id: std::option::Option<std::string::String>,
}
impl DeleteStorageLensConfigurationInput {
    /// <p>The ID of the S3 Storage Lens configuration.</p>
    pub fn config_id(&self) -> std::option::Option<&str> {
        self.config_id.as_deref()
    }
    /// <p>The account ID of the requester.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteStorageLensConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStorageLensConfigurationInput");
        formatter.field("config_id", &self.config_id);
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePublicAccessBlockInput {
    /// <p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want to remove.</p>
    pub account_id: std::option::Option<std::string::String>,
}
impl DeletePublicAccessBlockInput {
    /// <p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want to remove.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for DeletePublicAccessBlockInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePublicAccessBlockInput");
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMultiRegionAccessPointInput {
    /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>An idempotency token used to identify the request and guarantee that requests are unique.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>A container element containing details about the Multi-Region Access Point.</p>
    pub details: std::option::Option<crate::model::DeleteMultiRegionAccessPointInput>,
}
impl DeleteMultiRegionAccessPointInput {
    /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>An idempotency token used to identify the request and guarantee that requests are unique.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>A container element containing details about the Multi-Region Access Point.</p>
    pub fn details(&self) -> std::option::Option<&crate::model::DeleteMultiRegionAccessPointInput> {
        self.details.as_ref()
    }
}
impl std::fmt::Debug for DeleteMultiRegionAccessPointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMultiRegionAccessPointInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("client_token", &self.client_token);
        formatter.field("details", &self.details);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteJobTaggingInput {
    /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The ID for the S3 Batch Operations job whose tags you want to delete.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl DeleteJobTaggingInput {
    /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The ID for the S3 Batch Operations job whose tags you want to delete.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteJobTaggingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteJobTaggingInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBucketTaggingInput {
    /// <p>The Amazon Web Services account ID of the Outposts bucket tag set to be removed.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The bucket ARN that has the tag set to be removed.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /bucket/
    /// <my-bucket-name></my-bucket-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    pub bucket: std::option::Option<std::string::String>,
}
impl DeleteBucketTaggingInput {
    /// <p>The Amazon Web Services account ID of the Outposts bucket tag set to be removed.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The bucket ARN that has the tag set to be removed.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /bucket/
    /// <my-bucket-name></my-bucket-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
}
impl std::fmt::Debug for DeleteBucketTaggingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBucketTaggingInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("bucket", &self.bucket);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBucketPolicyInput {
    /// <p>The account ID of the Outposts bucket.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>Specifies the bucket.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /bucket/
    /// <my-bucket-name></my-bucket-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    pub bucket: std::option::Option<std::string::String>,
}
impl DeleteBucketPolicyInput {
    /// <p>The account ID of the Outposts bucket.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>Specifies the bucket.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /bucket/
    /// <my-bucket-name></my-bucket-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
}
impl std::fmt::Debug for DeleteBucketPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBucketPolicyInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("bucket", &self.bucket);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBucketLifecycleConfigurationInput {
    /// <p>The account ID of the lifecycle configuration to delete.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>Specifies the bucket.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /bucket/
    /// <my-bucket-name></my-bucket-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    pub bucket: std::option::Option<std::string::String>,
}
impl DeleteBucketLifecycleConfigurationInput {
    /// <p>The account ID of the lifecycle configuration to delete.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>Specifies the bucket.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /bucket/
    /// <my-bucket-name></my-bucket-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
}
impl std::fmt::Debug for DeleteBucketLifecycleConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBucketLifecycleConfigurationInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("bucket", &self.bucket);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBucketInput {
    /// <p>The account ID that owns the Outposts bucket.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>Specifies the bucket being deleted.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /bucket/
    /// <my-bucket-name></my-bucket-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    pub bucket: std::option::Option<std::string::String>,
}
impl DeleteBucketInput {
    /// <p>The account ID that owns the Outposts bucket.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>Specifies the bucket being deleted.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /bucket/
    /// <my-bucket-name></my-bucket-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
}
impl std::fmt::Debug for DeleteBucketInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBucketInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("bucket", &self.bucket);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAccessPointPolicyForObjectLambdaInput {
    /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the Object Lambda Access Point you want to delete the policy for.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteAccessPointPolicyForObjectLambdaInput {
    /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the Object Lambda Access Point you want to delete the policy for.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteAccessPointPolicyForObjectLambdaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAccessPointPolicyForObjectLambdaInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAccessPointPolicyInput {
    /// <p>The account ID for the account that owns the specified access point.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the access point whose policy you want to delete.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /accesspoint/
    /// <my-accesspoint-name></my-accesspoint-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteAccessPointPolicyInput {
    /// <p>The account ID for the account that owns the specified access point.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the access point whose policy you want to delete.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /accesspoint/
    /// <my-accesspoint-name></my-accesspoint-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteAccessPointPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAccessPointPolicyInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAccessPointForObjectLambdaInput {
    /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the access point you want to delete.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteAccessPointForObjectLambdaInput {
    /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the access point you want to delete.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteAccessPointForObjectLambdaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAccessPointForObjectLambdaInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAccessPointInput {
    /// <p>The account ID for the account that owns the specified access point.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the access point you want to delete.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /accesspoint/
    /// <my-accesspoint-name></my-accesspoint-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteAccessPointInput {
    /// <p>The account ID for the account that owns the specified access point.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the access point you want to delete.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /accesspoint/
    /// <my-accesspoint-name></my-accesspoint-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteAccessPointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAccessPointInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMultiRegionAccessPointInput {
    /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point. The owner of the Multi-Region Access Point also must own the underlying buckets.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>An idempotency token used to identify the request and guarantee that requests are unique.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>A container element containing details about the Multi-Region Access Point.</p>
    pub details: std::option::Option<crate::model::CreateMultiRegionAccessPointInput>,
}
impl CreateMultiRegionAccessPointInput {
    /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point. The owner of the Multi-Region Access Point also must own the underlying buckets.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>An idempotency token used to identify the request and guarantee that requests are unique.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>A container element containing details about the Multi-Region Access Point.</p>
    pub fn details(&self) -> std::option::Option<&crate::model::CreateMultiRegionAccessPointInput> {
        self.details.as_ref()
    }
}
impl std::fmt::Debug for CreateMultiRegionAccessPointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMultiRegionAccessPointInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("client_token", &self.client_token);
        formatter.field("details", &self.details);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateJobInput {
    /// <p>The Amazon Web Services account ID that creates the job.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether confirmation is required before Amazon S3 runs the job. Confirmation is only required for jobs created through the Amazon S3 console.</p>
    pub confirmation_required: std::option::Option<bool>,
    /// <p>The action that you want this job to perform on every object listed in the manifest. For more information about the available actions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-actions.html">Operations</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub operation: std::option::Option<crate::model::JobOperation>,
    /// <p>Configuration parameters for the optional job-completion report.</p>
    pub report: std::option::Option<crate::model::JobReport>,
    /// <p>An idempotency token to ensure that you don't accidentally submit the same request twice. You can use any string up to the maximum length.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>Configuration parameters for the manifest.</p>
    pub manifest: std::option::Option<crate::model::JobManifest>,
    /// <p>A description for this job. You can use any string within the permitted length. Descriptions don't need to be unique and can be used for multiple jobs.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The numerical priority for this job. Higher numbers indicate higher priority.</p>
    pub priority: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) for the Identity and Access Management (IAM) role that Batch Operations will use to run this job's action on every object in the manifest.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>A set of tags to associate with the S3 Batch Operations job. This is an optional parameter. </p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
    /// <p>The attribute container for the ManifestGenerator details. Jobs must be created with either a manifest file or a ManifestGenerator, but not both.</p>
    pub manifest_generator: std::option::Option<crate::model::JobManifestGenerator>,
}
impl CreateJobInput {
    /// <p>The Amazon Web Services account ID that creates the job.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>Indicates whether confirmation is required before Amazon S3 runs the job. Confirmation is only required for jobs created through the Amazon S3 console.</p>
    pub fn confirmation_required(&self) -> std::option::Option<bool> {
        self.confirmation_required
    }
    /// <p>The action that you want this job to perform on every object listed in the manifest. For more information about the available actions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-actions.html">Operations</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn operation(&self) -> std::option::Option<&crate::model::JobOperation> {
        self.operation.as_ref()
    }
    /// <p>Configuration parameters for the optional job-completion report.</p>
    pub fn report(&self) -> std::option::Option<&crate::model::JobReport> {
        self.report.as_ref()
    }
    /// <p>An idempotency token to ensure that you don't accidentally submit the same request twice. You can use any string up to the maximum length.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>Configuration parameters for the manifest.</p>
    pub fn manifest(&self) -> std::option::Option<&crate::model::JobManifest> {
        self.manifest.as_ref()
    }
    /// <p>A description for this job. You can use any string within the permitted length. Descriptions don't need to be unique and can be used for multiple jobs.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The numerical priority for this job. Higher numbers indicate higher priority.</p>
    pub fn priority(&self) -> std::option::Option<i32> {
        self.priority
    }
    /// <p>The Amazon Resource Name (ARN) for the Identity and Access Management (IAM) role that Batch Operations will use to run this job's action on every object in the manifest.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>A set of tags to associate with the S3 Batch Operations job. This is an optional parameter. </p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::S3Tag]> {
        self.tags.as_deref()
    }
    /// <p>The attribute container for the ManifestGenerator details. Jobs must be created with either a manifest file or a ManifestGenerator, but not both.</p>
    pub fn manifest_generator(&self) -> std::option::Option<&crate::model::JobManifestGenerator> {
        self.manifest_generator.as_ref()
    }
}
impl std::fmt::Debug for CreateJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateJobInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("confirmation_required", &self.confirmation_required);
        formatter.field("operation", &self.operation);
        formatter.field("report", &self.report);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("manifest", &self.manifest);
        formatter.field("description", &self.description);
        formatter.field("priority", &self.priority);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("tags", &self.tags);
        formatter.field("manifest_generator", &self.manifest_generator);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBucketInput {
    /// <p>The canned ACL to apply to the bucket.</p> <note>
    /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub acl: std::option::Option<crate::model::BucketCannedAcl>,
    /// <p>The name of the bucket.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The configuration information for the bucket.</p> <note>
    /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub create_bucket_configuration: std::option::Option<crate::model::CreateBucketConfiguration>,
    /// <p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p> <note>
    /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub grant_full_control: std::option::Option<std::string::String>,
    /// <p>Allows grantee to list the objects in the bucket.</p> <note>
    /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub grant_read: std::option::Option<std::string::String>,
    /// <p>Allows grantee to read the bucket ACL.</p> <note>
    /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub grant_read_acp: std::option::Option<std::string::String>,
    /// <p>Allows grantee to create, overwrite, and delete any object in the bucket.</p> <note>
    /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub grant_write: std::option::Option<std::string::String>,
    /// <p>Allows grantee to write the ACL for the applicable bucket.</p> <note>
    /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub grant_write_acp: std::option::Option<std::string::String>,
    /// <p>Specifies whether you want S3 Object Lock to be enabled for the new bucket.</p> <note>
    /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub object_lock_enabled_for_bucket: bool,
    /// <p>The ID of the Outposts where the bucket is being created.</p> <note>
    /// <p>This is required by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub outpost_id: std::option::Option<std::string::String>,
}
impl CreateBucketInput {
    /// <p>The canned ACL to apply to the bucket.</p> <note>
    /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub fn acl(&self) -> std::option::Option<&crate::model::BucketCannedAcl> {
        self.acl.as_ref()
    }
    /// <p>The name of the bucket.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The configuration information for the bucket.</p> <note>
    /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub fn create_bucket_configuration(
        &self,
    ) -> std::option::Option<&crate::model::CreateBucketConfiguration> {
        self.create_bucket_configuration.as_ref()
    }
    /// <p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p> <note>
    /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub fn grant_full_control(&self) -> std::option::Option<&str> {
        self.grant_full_control.as_deref()
    }
    /// <p>Allows grantee to list the objects in the bucket.</p> <note>
    /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub fn grant_read(&self) -> std::option::Option<&str> {
        self.grant_read.as_deref()
    }
    /// <p>Allows grantee to read the bucket ACL.</p> <note>
    /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub fn grant_read_acp(&self) -> std::option::Option<&str> {
        self.grant_read_acp.as_deref()
    }
    /// <p>Allows grantee to create, overwrite, and delete any object in the bucket.</p> <note>
    /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub fn grant_write(&self) -> std::option::Option<&str> {
        self.grant_write.as_deref()
    }
    /// <p>Allows grantee to write the ACL for the applicable bucket.</p> <note>
    /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub fn grant_write_acp(&self) -> std::option::Option<&str> {
        self.grant_write_acp.as_deref()
    }
    /// <p>Specifies whether you want S3 Object Lock to be enabled for the new bucket.</p> <note>
    /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub fn object_lock_enabled_for_bucket(&self) -> bool {
        self.object_lock_enabled_for_bucket
    }
    /// <p>The ID of the Outposts where the bucket is being created.</p> <note>
    /// <p>This is required by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub fn outpost_id(&self) -> std::option::Option<&str> {
        self.outpost_id.as_deref()
    }
}
impl std::fmt::Debug for CreateBucketInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBucketInput");
        formatter.field("acl", &self.acl);
        formatter.field("bucket", &self.bucket);
        formatter.field(
            "create_bucket_configuration",
            &self.create_bucket_configuration,
        );
        formatter.field("grant_full_control", &self.grant_full_control);
        formatter.field("grant_read", &self.grant_read);
        formatter.field("grant_read_acp", &self.grant_read_acp);
        formatter.field("grant_write", &self.grant_write);
        formatter.field("grant_write_acp", &self.grant_write_acp);
        formatter.field(
            "object_lock_enabled_for_bucket",
            &self.object_lock_enabled_for_bucket,
        );
        formatter.field("outpost_id", &self.outpost_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAccessPointForObjectLambdaInput {
    /// <p>The Amazon Web Services account ID for owner of the specified Object Lambda Access Point.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name you want to assign to this Object Lambda Access Point.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Object Lambda Access Point configuration as a JSON document.</p>
    pub configuration: std::option::Option<crate::model::ObjectLambdaConfiguration>,
}
impl CreateAccessPointForObjectLambdaInput {
    /// <p>The Amazon Web Services account ID for owner of the specified Object Lambda Access Point.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name you want to assign to this Object Lambda Access Point.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Object Lambda Access Point configuration as a JSON document.</p>
    pub fn configuration(&self) -> std::option::Option<&crate::model::ObjectLambdaConfiguration> {
        self.configuration.as_ref()
    }
}
impl std::fmt::Debug for CreateAccessPointForObjectLambdaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAccessPointForObjectLambdaInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("name", &self.name);
        formatter.field("configuration", &self.configuration);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAccessPointInput {
    /// <p>The Amazon Web Services account ID for the owner of the bucket for which you want to create an access point.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name you want to assign to this access point.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the bucket that you want to associate this access point with.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /bucket/
    /// <my-bucket-name></my-bucket-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>If you include this field, Amazon S3 restricts access to this access point to requests from the specified virtual private cloud (VPC).</p> <note>
    /// <p>This is required for creating an access point for Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub vpc_configuration: std::option::Option<crate::model::VpcConfiguration>,
    /// <p> The <code>PublicAccessBlock</code> configuration that you want to apply to the access point. </p>
    pub public_access_block_configuration:
        std::option::Option<crate::model::PublicAccessBlockConfiguration>,
}
impl CreateAccessPointInput {
    /// <p>The Amazon Web Services account ID for the owner of the bucket for which you want to create an access point.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name you want to assign to this access point.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name of the bucket that you want to associate this access point with.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:
    /// <region>
    /// :
    /// <account-id>
    /// :outpost/
    /// <outpost-id>
    /// /bucket/
    /// <my-bucket-name></my-bucket-name>
    /// </outpost-id>
    /// </account-id>
    /// </region></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded. </p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>If you include this field, Amazon S3 restricts access to this access point to requests from the specified virtual private cloud (VPC).</p> <note>
    /// <p>This is required for creating an access point for Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub fn vpc_configuration(&self) -> std::option::Option<&crate::model::VpcConfiguration> {
        self.vpc_configuration.as_ref()
    }
    /// <p> The <code>PublicAccessBlock</code> configuration that you want to apply to the access point. </p>
    pub fn public_access_block_configuration(
        &self,
    ) -> std::option::Option<&crate::model::PublicAccessBlockConfiguration> {
        self.public_access_block_configuration.as_ref()
    }
}
impl std::fmt::Debug for CreateAccessPointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAccessPointInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("name", &self.name);
        formatter.field("bucket", &self.bucket);
        formatter.field("vpc_configuration", &self.vpc_configuration);
        formatter.field(
            "public_access_block_configuration",
            &self.public_access_block_configuration,
        );
        formatter.finish()
    }
}
