// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Cancelling,
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    Completing,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Failing,
    #[allow(missing_docs)] // documentation missing in model
    New,
    #[allow(missing_docs)] // documentation missing in model
    Paused,
    #[allow(missing_docs)] // documentation missing in model
    Pausing,
    #[allow(missing_docs)] // documentation missing in model
    Preparing,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    #[allow(missing_docs)] // documentation missing in model
    Suspended,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobStatus {
    fn from(s: &str) -> Self {
        match s {
            "Active" => JobStatus::Active,
            "Cancelled" => JobStatus::Cancelled,
            "Cancelling" => JobStatus::Cancelling,
            "Complete" => JobStatus::Complete,
            "Completing" => JobStatus::Completing,
            "Failed" => JobStatus::Failed,
            "Failing" => JobStatus::Failing,
            "New" => JobStatus::New,
            "Paused" => JobStatus::Paused,
            "Pausing" => JobStatus::Pausing,
            "Preparing" => JobStatus::Preparing,
            "Ready" => JobStatus::Ready,
            "Suspended" => JobStatus::Suspended,
            other => JobStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobStatus::from(s))
    }
}
impl JobStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobStatus::Active => "Active",
            JobStatus::Cancelled => "Cancelled",
            JobStatus::Cancelling => "Cancelling",
            JobStatus::Complete => "Complete",
            JobStatus::Completing => "Completing",
            JobStatus::Failed => "Failed",
            JobStatus::Failing => "Failing",
            JobStatus::New => "New",
            JobStatus::Paused => "Paused",
            JobStatus::Pausing => "Pausing",
            JobStatus::Preparing => "Preparing",
            JobStatus::Ready => "Ready",
            JobStatus::Suspended => "Suspended",
            JobStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Active",
            "Cancelled",
            "Cancelling",
            "Complete",
            "Completing",
            "Failed",
            "Failing",
            "New",
            "Paused",
            "Pausing",
            "Preparing",
            "Ready",
            "Suspended",
        ]
    }
}
impl AsRef<str> for JobStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RequestedJobStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RequestedJobStatus {
    fn from(s: &str) -> Self {
        match s {
            "Cancelled" => RequestedJobStatus::Cancelled,
            "Ready" => RequestedJobStatus::Ready,
            other => RequestedJobStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RequestedJobStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RequestedJobStatus::from(s))
    }
}
impl RequestedJobStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RequestedJobStatus::Cancelled => "Cancelled",
            RequestedJobStatus::Ready => "Ready",
            RequestedJobStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Cancelled", "Ready"]
    }
}
impl AsRef<str> for RequestedJobStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StorageLensTag {
    /// <p></p>
    pub key: std::option::Option<std::string::String>,
    /// <p></p>
    pub value: std::option::Option<std::string::String>,
}
impl StorageLensTag {
    /// <p></p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p></p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for StorageLensTag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StorageLensTag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`StorageLensTag`](crate::model::StorageLensTag)
pub mod storage_lens_tag {
    /// A builder for [`StorageLensTag`](crate::model::StorageLensTag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p></p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`StorageLensTag`](crate::model::StorageLensTag)
        pub fn build(self) -> crate::model::StorageLensTag {
            crate::model::StorageLensTag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl StorageLensTag {
    /// Creates a new builder-style object to manufacture [`StorageLensTag`](crate::model::StorageLensTag)
    pub fn builder() -> crate::model::storage_lens_tag::Builder {
        crate::model::storage_lens_tag::Builder::default()
    }
}

/// <p>A container for the Amazon S3 Storage Lens configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StorageLensConfiguration {
    /// <p>A container for the Amazon S3 Storage Lens configuration ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>A container for all the account-level configurations of your S3 Storage Lens configuration.</p>
    pub account_level: std::option::Option<crate::model::AccountLevel>,
    /// <p>A container for what is included in this configuration. This container can only be valid if there is no <code>Exclude</code> container submitted, and it's not empty. </p>
    pub include: std::option::Option<crate::model::Include>,
    /// <p>A container for what is excluded in this configuration. This container can only be valid if there is no <code>Include</code> container submitted, and it's not empty. </p>
    pub exclude: std::option::Option<crate::model::Exclude>,
    /// <p>A container to specify the properties of your S3 Storage Lens metrics export including, the destination, schema and format.</p>
    pub data_export: std::option::Option<crate::model::StorageLensDataExport>,
    /// <p>A container for whether the S3 Storage Lens configuration is enabled.</p>
    pub is_enabled: bool,
    /// <p>A container for the Amazon Web Services organization for this S3 Storage Lens configuration.</p>
    pub aws_org: std::option::Option<crate::model::StorageLensAwsOrg>,
    /// <p>The Amazon Resource Name (ARN) of the S3 Storage Lens configuration. This property is read-only and follows the following format: <code> arn:aws:s3:<i>us-east-1</i>:<i>example-account-id</i>:storage-lens/<i>your-dashboard-name</i> </code> </p>
    pub storage_lens_arn: std::option::Option<std::string::String>,
}
impl StorageLensConfiguration {
    /// <p>A container for the Amazon S3 Storage Lens configuration ID.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>A container for all the account-level configurations of your S3 Storage Lens configuration.</p>
    pub fn account_level(&self) -> std::option::Option<&crate::model::AccountLevel> {
        self.account_level.as_ref()
    }
    /// <p>A container for what is included in this configuration. This container can only be valid if there is no <code>Exclude</code> container submitted, and it's not empty. </p>
    pub fn include(&self) -> std::option::Option<&crate::model::Include> {
        self.include.as_ref()
    }
    /// <p>A container for what is excluded in this configuration. This container can only be valid if there is no <code>Include</code> container submitted, and it's not empty. </p>
    pub fn exclude(&self) -> std::option::Option<&crate::model::Exclude> {
        self.exclude.as_ref()
    }
    /// <p>A container to specify the properties of your S3 Storage Lens metrics export including, the destination, schema and format.</p>
    pub fn data_export(&self) -> std::option::Option<&crate::model::StorageLensDataExport> {
        self.data_export.as_ref()
    }
    /// <p>A container for whether the S3 Storage Lens configuration is enabled.</p>
    pub fn is_enabled(&self) -> bool {
        self.is_enabled
    }
    /// <p>A container for the Amazon Web Services organization for this S3 Storage Lens configuration.</p>
    pub fn aws_org(&self) -> std::option::Option<&crate::model::StorageLensAwsOrg> {
        self.aws_org.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the S3 Storage Lens configuration. This property is read-only and follows the following format: <code> arn:aws:s3:<i>us-east-1</i>:<i>example-account-id</i>:storage-lens/<i>your-dashboard-name</i> </code> </p>
    pub fn storage_lens_arn(&self) -> std::option::Option<&str> {
        self.storage_lens_arn.as_deref()
    }
}
impl std::fmt::Debug for StorageLensConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StorageLensConfiguration");
        formatter.field("id", &self.id);
        formatter.field("account_level", &self.account_level);
        formatter.field("include", &self.include);
        formatter.field("exclude", &self.exclude);
        formatter.field("data_export", &self.data_export);
        formatter.field("is_enabled", &self.is_enabled);
        formatter.field("aws_org", &self.aws_org);
        formatter.field("storage_lens_arn", &self.storage_lens_arn);
        formatter.finish()
    }
}
/// See [`StorageLensConfiguration`](crate::model::StorageLensConfiguration)
pub mod storage_lens_configuration {
    /// A builder for [`StorageLensConfiguration`](crate::model::StorageLensConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) account_level: std::option::Option<crate::model::AccountLevel>,
        pub(crate) include: std::option::Option<crate::model::Include>,
        pub(crate) exclude: std::option::Option<crate::model::Exclude>,
        pub(crate) data_export: std::option::Option<crate::model::StorageLensDataExport>,
        pub(crate) is_enabled: std::option::Option<bool>,
        pub(crate) aws_org: std::option::Option<crate::model::StorageLensAwsOrg>,
        pub(crate) storage_lens_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A container for the Amazon S3 Storage Lens configuration ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>A container for the Amazon S3 Storage Lens configuration ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>A container for all the account-level configurations of your S3 Storage Lens configuration.</p>
        pub fn account_level(mut self, input: crate::model::AccountLevel) -> Self {
            self.account_level = Some(input);
            self
        }
        /// <p>A container for all the account-level configurations of your S3 Storage Lens configuration.</p>
        pub fn set_account_level(
            mut self,
            input: std::option::Option<crate::model::AccountLevel>,
        ) -> Self {
            self.account_level = input;
            self
        }
        /// <p>A container for what is included in this configuration. This container can only be valid if there is no <code>Exclude</code> container submitted, and it's not empty. </p>
        pub fn include(mut self, input: crate::model::Include) -> Self {
            self.include = Some(input);
            self
        }
        /// <p>A container for what is included in this configuration. This container can only be valid if there is no <code>Exclude</code> container submitted, and it's not empty. </p>
        pub fn set_include(mut self, input: std::option::Option<crate::model::Include>) -> Self {
            self.include = input;
            self
        }
        /// <p>A container for what is excluded in this configuration. This container can only be valid if there is no <code>Include</code> container submitted, and it's not empty. </p>
        pub fn exclude(mut self, input: crate::model::Exclude) -> Self {
            self.exclude = Some(input);
            self
        }
        /// <p>A container for what is excluded in this configuration. This container can only be valid if there is no <code>Include</code> container submitted, and it's not empty. </p>
        pub fn set_exclude(mut self, input: std::option::Option<crate::model::Exclude>) -> Self {
            self.exclude = input;
            self
        }
        /// <p>A container to specify the properties of your S3 Storage Lens metrics export including, the destination, schema and format.</p>
        pub fn data_export(mut self, input: crate::model::StorageLensDataExport) -> Self {
            self.data_export = Some(input);
            self
        }
        /// <p>A container to specify the properties of your S3 Storage Lens metrics export including, the destination, schema and format.</p>
        pub fn set_data_export(
            mut self,
            input: std::option::Option<crate::model::StorageLensDataExport>,
        ) -> Self {
            self.data_export = input;
            self
        }
        /// <p>A container for whether the S3 Storage Lens configuration is enabled.</p>
        pub fn is_enabled(mut self, input: bool) -> Self {
            self.is_enabled = Some(input);
            self
        }
        /// <p>A container for whether the S3 Storage Lens configuration is enabled.</p>
        pub fn set_is_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.is_enabled = input;
            self
        }
        /// <p>A container for the Amazon Web Services organization for this S3 Storage Lens configuration.</p>
        pub fn aws_org(mut self, input: crate::model::StorageLensAwsOrg) -> Self {
            self.aws_org = Some(input);
            self
        }
        /// <p>A container for the Amazon Web Services organization for this S3 Storage Lens configuration.</p>
        pub fn set_aws_org(
            mut self,
            input: std::option::Option<crate::model::StorageLensAwsOrg>,
        ) -> Self {
            self.aws_org = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the S3 Storage Lens configuration. This property is read-only and follows the following format: <code> arn:aws:s3:<i>us-east-1</i>:<i>example-account-id</i>:storage-lens/<i>your-dashboard-name</i> </code> </p>
        pub fn storage_lens_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_lens_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the S3 Storage Lens configuration. This property is read-only and follows the following format: <code> arn:aws:s3:<i>us-east-1</i>:<i>example-account-id</i>:storage-lens/<i>your-dashboard-name</i> </code> </p>
        pub fn set_storage_lens_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.storage_lens_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StorageLensConfiguration`](crate::model::StorageLensConfiguration)
        pub fn build(self) -> crate::model::StorageLensConfiguration {
            crate::model::StorageLensConfiguration {
                id: self.id,
                account_level: self.account_level,
                include: self.include,
                exclude: self.exclude,
                data_export: self.data_export,
                is_enabled: self.is_enabled.unwrap_or_default(),
                aws_org: self.aws_org,
                storage_lens_arn: self.storage_lens_arn,
            }
        }
    }
}
impl StorageLensConfiguration {
    /// Creates a new builder-style object to manufacture [`StorageLensConfiguration`](crate::model::StorageLensConfiguration)
    pub fn builder() -> crate::model::storage_lens_configuration::Builder {
        crate::model::storage_lens_configuration::Builder::default()
    }
}

/// <p>The Amazon Web Services organization for your S3 Storage Lens.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StorageLensAwsOrg {
    /// <p>A container for the Amazon Resource Name (ARN) of the Amazon Web Services organization. This property is read-only and follows the following format: <code> arn:aws:organizations:<i>us-east-1</i>:<i>example-account-id</i>:organization/<i>o-ex2l495dck</i> </code> </p>
    pub arn: std::option::Option<std::string::String>,
}
impl StorageLensAwsOrg {
    /// <p>A container for the Amazon Resource Name (ARN) of the Amazon Web Services organization. This property is read-only and follows the following format: <code> arn:aws:organizations:<i>us-east-1</i>:<i>example-account-id</i>:organization/<i>o-ex2l495dck</i> </code> </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for StorageLensAwsOrg {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StorageLensAwsOrg");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`StorageLensAwsOrg`](crate::model::StorageLensAwsOrg)
pub mod storage_lens_aws_org {
    /// A builder for [`StorageLensAwsOrg`](crate::model::StorageLensAwsOrg)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A container for the Amazon Resource Name (ARN) of the Amazon Web Services organization. This property is read-only and follows the following format: <code> arn:aws:organizations:<i>us-east-1</i>:<i>example-account-id</i>:organization/<i>o-ex2l495dck</i> </code> </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>A container for the Amazon Resource Name (ARN) of the Amazon Web Services organization. This property is read-only and follows the following format: <code> arn:aws:organizations:<i>us-east-1</i>:<i>example-account-id</i>:organization/<i>o-ex2l495dck</i> </code> </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StorageLensAwsOrg`](crate::model::StorageLensAwsOrg)
        pub fn build(self) -> crate::model::StorageLensAwsOrg {
            crate::model::StorageLensAwsOrg { arn: self.arn }
        }
    }
}
impl StorageLensAwsOrg {
    /// Creates a new builder-style object to manufacture [`StorageLensAwsOrg`](crate::model::StorageLensAwsOrg)
    pub fn builder() -> crate::model::storage_lens_aws_org::Builder {
        crate::model::storage_lens_aws_org::Builder::default()
    }
}

/// <p>A container to specify the properties of your S3 Storage Lens metrics export, including the destination, schema, and format.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StorageLensDataExport {
    /// <p>A container for the bucket where the S3 Storage Lens metrics export will be located.</p> <note>
    /// <p>This bucket must be located in the same Region as the storage lens configuration. </p>
    /// </note>
    pub s3_bucket_destination: std::option::Option<crate::model::S3BucketDestination>,
    /// <p>A container for enabling Amazon CloudWatch publishing for S3 Storage Lens metrics.</p>
    pub cloud_watch_metrics: std::option::Option<crate::model::CloudWatchMetrics>,
}
impl StorageLensDataExport {
    /// <p>A container for the bucket where the S3 Storage Lens metrics export will be located.</p> <note>
    /// <p>This bucket must be located in the same Region as the storage lens configuration. </p>
    /// </note>
    pub fn s3_bucket_destination(&self) -> std::option::Option<&crate::model::S3BucketDestination> {
        self.s3_bucket_destination.as_ref()
    }
    /// <p>A container for enabling Amazon CloudWatch publishing for S3 Storage Lens metrics.</p>
    pub fn cloud_watch_metrics(&self) -> std::option::Option<&crate::model::CloudWatchMetrics> {
        self.cloud_watch_metrics.as_ref()
    }
}
impl std::fmt::Debug for StorageLensDataExport {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StorageLensDataExport");
        formatter.field("s3_bucket_destination", &self.s3_bucket_destination);
        formatter.field("cloud_watch_metrics", &self.cloud_watch_metrics);
        formatter.finish()
    }
}
/// See [`StorageLensDataExport`](crate::model::StorageLensDataExport)
pub mod storage_lens_data_export {
    /// A builder for [`StorageLensDataExport`](crate::model::StorageLensDataExport)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_bucket_destination: std::option::Option<crate::model::S3BucketDestination>,
        pub(crate) cloud_watch_metrics: std::option::Option<crate::model::CloudWatchMetrics>,
    }
    impl Builder {
        /// <p>A container for the bucket where the S3 Storage Lens metrics export will be located.</p> <note>
        /// <p>This bucket must be located in the same Region as the storage lens configuration. </p>
        /// </note>
        pub fn s3_bucket_destination(mut self, input: crate::model::S3BucketDestination) -> Self {
            self.s3_bucket_destination = Some(input);
            self
        }
        /// <p>A container for the bucket where the S3 Storage Lens metrics export will be located.</p> <note>
        /// <p>This bucket must be located in the same Region as the storage lens configuration. </p>
        /// </note>
        pub fn set_s3_bucket_destination(
            mut self,
            input: std::option::Option<crate::model::S3BucketDestination>,
        ) -> Self {
            self.s3_bucket_destination = input;
            self
        }
        /// <p>A container for enabling Amazon CloudWatch publishing for S3 Storage Lens metrics.</p>
        pub fn cloud_watch_metrics(mut self, input: crate::model::CloudWatchMetrics) -> Self {
            self.cloud_watch_metrics = Some(input);
            self
        }
        /// <p>A container for enabling Amazon CloudWatch publishing for S3 Storage Lens metrics.</p>
        pub fn set_cloud_watch_metrics(
            mut self,
            input: std::option::Option<crate::model::CloudWatchMetrics>,
        ) -> Self {
            self.cloud_watch_metrics = input;
            self
        }
        /// Consumes the builder and constructs a [`StorageLensDataExport`](crate::model::StorageLensDataExport)
        pub fn build(self) -> crate::model::StorageLensDataExport {
            crate::model::StorageLensDataExport {
                s3_bucket_destination: self.s3_bucket_destination,
                cloud_watch_metrics: self.cloud_watch_metrics,
            }
        }
    }
}
impl StorageLensDataExport {
    /// Creates a new builder-style object to manufacture [`StorageLensDataExport`](crate::model::StorageLensDataExport)
    pub fn builder() -> crate::model::storage_lens_data_export::Builder {
        crate::model::storage_lens_data_export::Builder::default()
    }
}

/// <p>A container for enabling Amazon CloudWatch publishing for S3 Storage Lens metrics.</p>
/// <p>For more information about publishing S3 Storage Lens metrics to CloudWatch, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_view_metrics_cloudwatch.html">Monitor S3 Storage Lens metrics in CloudWatch</a> in the <i>Amazon S3 User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchMetrics {
    /// <p>A container that indicates whether CloudWatch publishing for S3 Storage Lens metrics is enabled. A value of <code>true</code> indicates that CloudWatch publishing for S3 Storage Lens metrics is enabled.</p>
    pub is_enabled: bool,
}
impl CloudWatchMetrics {
    /// <p>A container that indicates whether CloudWatch publishing for S3 Storage Lens metrics is enabled. A value of <code>true</code> indicates that CloudWatch publishing for S3 Storage Lens metrics is enabled.</p>
    pub fn is_enabled(&self) -> bool {
        self.is_enabled
    }
}
impl std::fmt::Debug for CloudWatchMetrics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchMetrics");
        formatter.field("is_enabled", &self.is_enabled);
        formatter.finish()
    }
}
/// See [`CloudWatchMetrics`](crate::model::CloudWatchMetrics)
pub mod cloud_watch_metrics {
    /// A builder for [`CloudWatchMetrics`](crate::model::CloudWatchMetrics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) is_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A container that indicates whether CloudWatch publishing for S3 Storage Lens metrics is enabled. A value of <code>true</code> indicates that CloudWatch publishing for S3 Storage Lens metrics is enabled.</p>
        pub fn is_enabled(mut self, input: bool) -> Self {
            self.is_enabled = Some(input);
            self
        }
        /// <p>A container that indicates whether CloudWatch publishing for S3 Storage Lens metrics is enabled. A value of <code>true</code> indicates that CloudWatch publishing for S3 Storage Lens metrics is enabled.</p>
        pub fn set_is_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.is_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchMetrics`](crate::model::CloudWatchMetrics)
        pub fn build(self) -> crate::model::CloudWatchMetrics {
            crate::model::CloudWatchMetrics {
                is_enabled: self.is_enabled.unwrap_or_default(),
            }
        }
    }
}
impl CloudWatchMetrics {
    /// Creates a new builder-style object to manufacture [`CloudWatchMetrics`](crate::model::CloudWatchMetrics)
    pub fn builder() -> crate::model::cloud_watch_metrics::Builder {
        crate::model::cloud_watch_metrics::Builder::default()
    }
}

/// <p>A container for the bucket where the Amazon S3 Storage Lens metrics export files are located.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3BucketDestination {
    /// <p></p>
    pub format: std::option::Option<crate::model::Format>,
    /// <p>The schema version of the export file.</p>
    pub output_schema_version: std::option::Option<crate::model::OutputSchemaVersion>,
    /// <p>The account ID of the owner of the S3 Storage Lens metrics export bucket.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the bucket. This property is read-only and follows the following format: <code> arn:aws:s3:<i>us-east-1</i>:<i>example-account-id</i>:bucket/<i>your-destination-bucket-name</i> </code> </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The prefix of the destination bucket where the metrics export will be delivered.</p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>The container for the type encryption of the metrics exports in this bucket.</p>
    pub encryption: std::option::Option<crate::model::StorageLensDataExportEncryption>,
}
impl S3BucketDestination {
    /// <p></p>
    pub fn format(&self) -> std::option::Option<&crate::model::Format> {
        self.format.as_ref()
    }
    /// <p>The schema version of the export file.</p>
    pub fn output_schema_version(&self) -> std::option::Option<&crate::model::OutputSchemaVersion> {
        self.output_schema_version.as_ref()
    }
    /// <p>The account ID of the owner of the S3 Storage Lens metrics export bucket.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the bucket. This property is read-only and follows the following format: <code> arn:aws:s3:<i>us-east-1</i>:<i>example-account-id</i>:bucket/<i>your-destination-bucket-name</i> </code> </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The prefix of the destination bucket where the metrics export will be delivered.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>The container for the type encryption of the metrics exports in this bucket.</p>
    pub fn encryption(
        &self,
    ) -> std::option::Option<&crate::model::StorageLensDataExportEncryption> {
        self.encryption.as_ref()
    }
}
impl std::fmt::Debug for S3BucketDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3BucketDestination");
        formatter.field("format", &self.format);
        formatter.field("output_schema_version", &self.output_schema_version);
        formatter.field("account_id", &self.account_id);
        formatter.field("arn", &self.arn);
        formatter.field("prefix", &self.prefix);
        formatter.field("encryption", &self.encryption);
        formatter.finish()
    }
}
/// See [`S3BucketDestination`](crate::model::S3BucketDestination)
pub mod s3_bucket_destination {
    /// A builder for [`S3BucketDestination`](crate::model::S3BucketDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) format: std::option::Option<crate::model::Format>,
        pub(crate) output_schema_version: std::option::Option<crate::model::OutputSchemaVersion>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) encryption: std::option::Option<crate::model::StorageLensDataExportEncryption>,
    }
    impl Builder {
        /// <p></p>
        pub fn format(mut self, input: crate::model::Format) -> Self {
            self.format = Some(input);
            self
        }
        /// <p></p>
        pub fn set_format(mut self, input: std::option::Option<crate::model::Format>) -> Self {
            self.format = input;
            self
        }
        /// <p>The schema version of the export file.</p>
        pub fn output_schema_version(mut self, input: crate::model::OutputSchemaVersion) -> Self {
            self.output_schema_version = Some(input);
            self
        }
        /// <p>The schema version of the export file.</p>
        pub fn set_output_schema_version(
            mut self,
            input: std::option::Option<crate::model::OutputSchemaVersion>,
        ) -> Self {
            self.output_schema_version = input;
            self
        }
        /// <p>The account ID of the owner of the S3 Storage Lens metrics export bucket.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID of the owner of the S3 Storage Lens metrics export bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bucket. This property is read-only and follows the following format: <code> arn:aws:s3:<i>us-east-1</i>:<i>example-account-id</i>:bucket/<i>your-destination-bucket-name</i> </code> </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bucket. This property is read-only and follows the following format: <code> arn:aws:s3:<i>us-east-1</i>:<i>example-account-id</i>:bucket/<i>your-destination-bucket-name</i> </code> </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The prefix of the destination bucket where the metrics export will be delivered.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>The prefix of the destination bucket where the metrics export will be delivered.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>The container for the type encryption of the metrics exports in this bucket.</p>
        pub fn encryption(mut self, input: crate::model::StorageLensDataExportEncryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// <p>The container for the type encryption of the metrics exports in this bucket.</p>
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::StorageLensDataExportEncryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// Consumes the builder and constructs a [`S3BucketDestination`](crate::model::S3BucketDestination)
        pub fn build(self) -> crate::model::S3BucketDestination {
            crate::model::S3BucketDestination {
                format: self.format,
                output_schema_version: self.output_schema_version,
                account_id: self.account_id,
                arn: self.arn,
                prefix: self.prefix,
                encryption: self.encryption,
            }
        }
    }
}
impl S3BucketDestination {
    /// Creates a new builder-style object to manufacture [`S3BucketDestination`](crate::model::S3BucketDestination)
    pub fn builder() -> crate::model::s3_bucket_destination::Builder {
        crate::model::s3_bucket_destination::Builder::default()
    }
}

/// <p>A container for the encryption of the S3 Storage Lens metrics exports.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StorageLensDataExportEncryption {
    /// <p></p>
    pub sses3: std::option::Option<crate::model::Sses3>,
    /// <p></p>
    pub ssekms: std::option::Option<crate::model::Ssekms>,
}
impl StorageLensDataExportEncryption {
    /// <p></p>
    pub fn sses3(&self) -> std::option::Option<&crate::model::Sses3> {
        self.sses3.as_ref()
    }
    /// <p></p>
    pub fn ssekms(&self) -> std::option::Option<&crate::model::Ssekms> {
        self.ssekms.as_ref()
    }
}
impl std::fmt::Debug for StorageLensDataExportEncryption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StorageLensDataExportEncryption");
        formatter.field("sses3", &self.sses3);
        formatter.field("ssekms", &self.ssekms);
        formatter.finish()
    }
}
/// See [`StorageLensDataExportEncryption`](crate::model::StorageLensDataExportEncryption)
pub mod storage_lens_data_export_encryption {
    /// A builder for [`StorageLensDataExportEncryption`](crate::model::StorageLensDataExportEncryption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sses3: std::option::Option<crate::model::Sses3>,
        pub(crate) ssekms: std::option::Option<crate::model::Ssekms>,
    }
    impl Builder {
        /// <p></p>
        pub fn sses3(mut self, input: crate::model::Sses3) -> Self {
            self.sses3 = Some(input);
            self
        }
        /// <p></p>
        pub fn set_sses3(mut self, input: std::option::Option<crate::model::Sses3>) -> Self {
            self.sses3 = input;
            self
        }
        /// <p></p>
        pub fn ssekms(mut self, input: crate::model::Ssekms) -> Self {
            self.ssekms = Some(input);
            self
        }
        /// <p></p>
        pub fn set_ssekms(mut self, input: std::option::Option<crate::model::Ssekms>) -> Self {
            self.ssekms = input;
            self
        }
        /// Consumes the builder and constructs a [`StorageLensDataExportEncryption`](crate::model::StorageLensDataExportEncryption)
        pub fn build(self) -> crate::model::StorageLensDataExportEncryption {
            crate::model::StorageLensDataExportEncryption {
                sses3: self.sses3,
                ssekms: self.ssekms,
            }
        }
    }
}
impl StorageLensDataExportEncryption {
    /// Creates a new builder-style object to manufacture [`StorageLensDataExportEncryption`](crate::model::StorageLensDataExportEncryption)
    pub fn builder() -> crate::model::storage_lens_data_export_encryption::Builder {
        crate::model::storage_lens_data_export_encryption::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ssekms {
    /// <p>A container for the ARN of the SSE-KMS encryption. This property is read-only and follows the following format: <code> arn:aws:kms:<i>us-east-1</i>:<i>example-account-id</i>:key/<i>example-9a73-4afc-8d29-8f5900cef44e</i> </code> </p>
    pub key_id: std::option::Option<std::string::String>,
}
impl Ssekms {
    /// <p>A container for the ARN of the SSE-KMS encryption. This property is read-only and follows the following format: <code> arn:aws:kms:<i>us-east-1</i>:<i>example-account-id</i>:key/<i>example-9a73-4afc-8d29-8f5900cef44e</i> </code> </p>
    pub fn key_id(&self) -> std::option::Option<&str> {
        self.key_id.as_deref()
    }
}
impl std::fmt::Debug for Ssekms {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ssekms");
        formatter.field("key_id", &self.key_id);
        formatter.finish()
    }
}
/// See [`Ssekms`](crate::model::Ssekms)
pub mod ssekms {
    /// A builder for [`Ssekms`](crate::model::Ssekms)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A container for the ARN of the SSE-KMS encryption. This property is read-only and follows the following format: <code> arn:aws:kms:<i>us-east-1</i>:<i>example-account-id</i>:key/<i>example-9a73-4afc-8d29-8f5900cef44e</i> </code> </p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>A container for the ARN of the SSE-KMS encryption. This property is read-only and follows the following format: <code> arn:aws:kms:<i>us-east-1</i>:<i>example-account-id</i>:key/<i>example-9a73-4afc-8d29-8f5900cef44e</i> </code> </p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Ssekms`](crate::model::Ssekms)
        pub fn build(self) -> crate::model::Ssekms {
            crate::model::Ssekms {
                key_id: self.key_id,
            }
        }
    }
}
impl Ssekms {
    /// Creates a new builder-style object to manufacture [`Ssekms`](crate::model::Ssekms)
    pub fn builder() -> crate::model::ssekms::Builder {
        crate::model::ssekms::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Sses3 {}
impl std::fmt::Debug for Sses3 {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Sses3");
        formatter.finish()
    }
}
/// See [`Sses3`](crate::model::Sses3)
pub mod sses3 {
    /// A builder for [`Sses3`](crate::model::Sses3)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`Sses3`](crate::model::Sses3)
        pub fn build(self) -> crate::model::Sses3 {
            crate::model::Sses3 {}
        }
    }
}
impl Sses3 {
    /// Creates a new builder-style object to manufacture [`Sses3`](crate::model::Sses3)
    pub fn builder() -> crate::model::sses3::Builder {
        crate::model::sses3::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OutputSchemaVersion {
    #[allow(missing_docs)] // documentation missing in model
    V1,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OutputSchemaVersion {
    fn from(s: &str) -> Self {
        match s {
            "V_1" => OutputSchemaVersion::V1,
            other => OutputSchemaVersion::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OutputSchemaVersion {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OutputSchemaVersion::from(s))
    }
}
impl OutputSchemaVersion {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OutputSchemaVersion::V1 => "V_1",
            OutputSchemaVersion::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["V_1"]
    }
}
impl AsRef<str> for OutputSchemaVersion {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Format {
    #[allow(missing_docs)] // documentation missing in model
    Csv,
    #[allow(missing_docs)] // documentation missing in model
    Parquet,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Format {
    fn from(s: &str) -> Self {
        match s {
            "CSV" => Format::Csv,
            "Parquet" => Format::Parquet,
            other => Format::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Format {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Format::from(s))
    }
}
impl Format {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Format::Csv => "CSV",
            Format::Parquet => "Parquet",
            Format::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CSV", "Parquet"]
    }
}
impl AsRef<str> for Format {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A container for what Amazon S3 Storage Lens will exclude.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Exclude {
    /// <p>A container for the S3 Storage Lens bucket excludes.</p>
    pub buckets: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A container for the S3 Storage Lens Region excludes.</p>
    pub regions: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Exclude {
    /// <p>A container for the S3 Storage Lens bucket excludes.</p>
    pub fn buckets(&self) -> std::option::Option<&[std::string::String]> {
        self.buckets.as_deref()
    }
    /// <p>A container for the S3 Storage Lens Region excludes.</p>
    pub fn regions(&self) -> std::option::Option<&[std::string::String]> {
        self.regions.as_deref()
    }
}
impl std::fmt::Debug for Exclude {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Exclude");
        formatter.field("buckets", &self.buckets);
        formatter.field("regions", &self.regions);
        formatter.finish()
    }
}
/// See [`Exclude`](crate::model::Exclude)
pub mod exclude {
    /// A builder for [`Exclude`](crate::model::Exclude)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) buckets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) regions: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `buckets`.
        ///
        /// To override the contents of this collection use [`set_buckets`](Self::set_buckets).
        ///
        /// <p>A container for the S3 Storage Lens bucket excludes.</p>
        pub fn buckets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.buckets.unwrap_or_default();
            v.push(input.into());
            self.buckets = Some(v);
            self
        }
        /// <p>A container for the S3 Storage Lens bucket excludes.</p>
        pub fn set_buckets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.buckets = input;
            self
        }
        /// Appends an item to `regions`.
        ///
        /// To override the contents of this collection use [`set_regions`](Self::set_regions).
        ///
        /// <p>A container for the S3 Storage Lens Region excludes.</p>
        pub fn regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.regions.unwrap_or_default();
            v.push(input.into());
            self.regions = Some(v);
            self
        }
        /// <p>A container for the S3 Storage Lens Region excludes.</p>
        pub fn set_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.regions = input;
            self
        }
        /// Consumes the builder and constructs a [`Exclude`](crate::model::Exclude)
        pub fn build(self) -> crate::model::Exclude {
            crate::model::Exclude {
                buckets: self.buckets,
                regions: self.regions,
            }
        }
    }
}
impl Exclude {
    /// Creates a new builder-style object to manufacture [`Exclude`](crate::model::Exclude)
    pub fn builder() -> crate::model::exclude::Builder {
        crate::model::exclude::Builder::default()
    }
}

/// <p>A container for what Amazon S3 Storage Lens configuration includes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Include {
    /// <p>A container for the S3 Storage Lens bucket includes.</p>
    pub buckets: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A container for the S3 Storage Lens Region includes.</p>
    pub regions: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Include {
    /// <p>A container for the S3 Storage Lens bucket includes.</p>
    pub fn buckets(&self) -> std::option::Option<&[std::string::String]> {
        self.buckets.as_deref()
    }
    /// <p>A container for the S3 Storage Lens Region includes.</p>
    pub fn regions(&self) -> std::option::Option<&[std::string::String]> {
        self.regions.as_deref()
    }
}
impl std::fmt::Debug for Include {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Include");
        formatter.field("buckets", &self.buckets);
        formatter.field("regions", &self.regions);
        formatter.finish()
    }
}
/// See [`Include`](crate::model::Include)
pub mod include {
    /// A builder for [`Include`](crate::model::Include)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) buckets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) regions: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `buckets`.
        ///
        /// To override the contents of this collection use [`set_buckets`](Self::set_buckets).
        ///
        /// <p>A container for the S3 Storage Lens bucket includes.</p>
        pub fn buckets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.buckets.unwrap_or_default();
            v.push(input.into());
            self.buckets = Some(v);
            self
        }
        /// <p>A container for the S3 Storage Lens bucket includes.</p>
        pub fn set_buckets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.buckets = input;
            self
        }
        /// Appends an item to `regions`.
        ///
        /// To override the contents of this collection use [`set_regions`](Self::set_regions).
        ///
        /// <p>A container for the S3 Storage Lens Region includes.</p>
        pub fn regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.regions.unwrap_or_default();
            v.push(input.into());
            self.regions = Some(v);
            self
        }
        /// <p>A container for the S3 Storage Lens Region includes.</p>
        pub fn set_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.regions = input;
            self
        }
        /// Consumes the builder and constructs a [`Include`](crate::model::Include)
        pub fn build(self) -> crate::model::Include {
            crate::model::Include {
                buckets: self.buckets,
                regions: self.regions,
            }
        }
    }
}
impl Include {
    /// Creates a new builder-style object to manufacture [`Include`](crate::model::Include)
    pub fn builder() -> crate::model::include::Builder {
        crate::model::include::Builder::default()
    }
}

/// <p>A container for the account level Amazon S3 Storage Lens configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountLevel {
    /// <p>A container for the S3 Storage Lens activity metrics.</p>
    pub activity_metrics: std::option::Option<crate::model::ActivityMetrics>,
    /// <p>A container for the S3 Storage Lens bucket-level configuration.</p>
    pub bucket_level: std::option::Option<crate::model::BucketLevel>,
}
impl AccountLevel {
    /// <p>A container for the S3 Storage Lens activity metrics.</p>
    pub fn activity_metrics(&self) -> std::option::Option<&crate::model::ActivityMetrics> {
        self.activity_metrics.as_ref()
    }
    /// <p>A container for the S3 Storage Lens bucket-level configuration.</p>
    pub fn bucket_level(&self) -> std::option::Option<&crate::model::BucketLevel> {
        self.bucket_level.as_ref()
    }
}
impl std::fmt::Debug for AccountLevel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountLevel");
        formatter.field("activity_metrics", &self.activity_metrics);
        formatter.field("bucket_level", &self.bucket_level);
        formatter.finish()
    }
}
/// See [`AccountLevel`](crate::model::AccountLevel)
pub mod account_level {
    /// A builder for [`AccountLevel`](crate::model::AccountLevel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) activity_metrics: std::option::Option<crate::model::ActivityMetrics>,
        pub(crate) bucket_level: std::option::Option<crate::model::BucketLevel>,
    }
    impl Builder {
        /// <p>A container for the S3 Storage Lens activity metrics.</p>
        pub fn activity_metrics(mut self, input: crate::model::ActivityMetrics) -> Self {
            self.activity_metrics = Some(input);
            self
        }
        /// <p>A container for the S3 Storage Lens activity metrics.</p>
        pub fn set_activity_metrics(
            mut self,
            input: std::option::Option<crate::model::ActivityMetrics>,
        ) -> Self {
            self.activity_metrics = input;
            self
        }
        /// <p>A container for the S3 Storage Lens bucket-level configuration.</p>
        pub fn bucket_level(mut self, input: crate::model::BucketLevel) -> Self {
            self.bucket_level = Some(input);
            self
        }
        /// <p>A container for the S3 Storage Lens bucket-level configuration.</p>
        pub fn set_bucket_level(
            mut self,
            input: std::option::Option<crate::model::BucketLevel>,
        ) -> Self {
            self.bucket_level = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountLevel`](crate::model::AccountLevel)
        pub fn build(self) -> crate::model::AccountLevel {
            crate::model::AccountLevel {
                activity_metrics: self.activity_metrics,
                bucket_level: self.bucket_level,
            }
        }
    }
}
impl AccountLevel {
    /// Creates a new builder-style object to manufacture [`AccountLevel`](crate::model::AccountLevel)
    pub fn builder() -> crate::model::account_level::Builder {
        crate::model::account_level::Builder::default()
    }
}

/// <p>A container for the bucket-level configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BucketLevel {
    /// <p>A container for the bucket-level activity metrics for Amazon S3 Storage Lens</p>
    pub activity_metrics: std::option::Option<crate::model::ActivityMetrics>,
    /// <p>A container for the bucket-level prefix-level metrics for S3 Storage Lens</p>
    pub prefix_level: std::option::Option<crate::model::PrefixLevel>,
}
impl BucketLevel {
    /// <p>A container for the bucket-level activity metrics for Amazon S3 Storage Lens</p>
    pub fn activity_metrics(&self) -> std::option::Option<&crate::model::ActivityMetrics> {
        self.activity_metrics.as_ref()
    }
    /// <p>A container for the bucket-level prefix-level metrics for S3 Storage Lens</p>
    pub fn prefix_level(&self) -> std::option::Option<&crate::model::PrefixLevel> {
        self.prefix_level.as_ref()
    }
}
impl std::fmt::Debug for BucketLevel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BucketLevel");
        formatter.field("activity_metrics", &self.activity_metrics);
        formatter.field("prefix_level", &self.prefix_level);
        formatter.finish()
    }
}
/// See [`BucketLevel`](crate::model::BucketLevel)
pub mod bucket_level {
    /// A builder for [`BucketLevel`](crate::model::BucketLevel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) activity_metrics: std::option::Option<crate::model::ActivityMetrics>,
        pub(crate) prefix_level: std::option::Option<crate::model::PrefixLevel>,
    }
    impl Builder {
        /// <p>A container for the bucket-level activity metrics for Amazon S3 Storage Lens</p>
        pub fn activity_metrics(mut self, input: crate::model::ActivityMetrics) -> Self {
            self.activity_metrics = Some(input);
            self
        }
        /// <p>A container for the bucket-level activity metrics for Amazon S3 Storage Lens</p>
        pub fn set_activity_metrics(
            mut self,
            input: std::option::Option<crate::model::ActivityMetrics>,
        ) -> Self {
            self.activity_metrics = input;
            self
        }
        /// <p>A container for the bucket-level prefix-level metrics for S3 Storage Lens</p>
        pub fn prefix_level(mut self, input: crate::model::PrefixLevel) -> Self {
            self.prefix_level = Some(input);
            self
        }
        /// <p>A container for the bucket-level prefix-level metrics for S3 Storage Lens</p>
        pub fn set_prefix_level(
            mut self,
            input: std::option::Option<crate::model::PrefixLevel>,
        ) -> Self {
            self.prefix_level = input;
            self
        }
        /// Consumes the builder and constructs a [`BucketLevel`](crate::model::BucketLevel)
        pub fn build(self) -> crate::model::BucketLevel {
            crate::model::BucketLevel {
                activity_metrics: self.activity_metrics,
                prefix_level: self.prefix_level,
            }
        }
    }
}
impl BucketLevel {
    /// Creates a new builder-style object to manufacture [`BucketLevel`](crate::model::BucketLevel)
    pub fn builder() -> crate::model::bucket_level::Builder {
        crate::model::bucket_level::Builder::default()
    }
}

/// <p>A container for the prefix-level configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PrefixLevel {
    /// <p>A container for the prefix-level storage metrics for S3 Storage Lens.</p>
    pub storage_metrics: std::option::Option<crate::model::PrefixLevelStorageMetrics>,
}
impl PrefixLevel {
    /// <p>A container for the prefix-level storage metrics for S3 Storage Lens.</p>
    pub fn storage_metrics(&self) -> std::option::Option<&crate::model::PrefixLevelStorageMetrics> {
        self.storage_metrics.as_ref()
    }
}
impl std::fmt::Debug for PrefixLevel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PrefixLevel");
        formatter.field("storage_metrics", &self.storage_metrics);
        formatter.finish()
    }
}
/// See [`PrefixLevel`](crate::model::PrefixLevel)
pub mod prefix_level {
    /// A builder for [`PrefixLevel`](crate::model::PrefixLevel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) storage_metrics: std::option::Option<crate::model::PrefixLevelStorageMetrics>,
    }
    impl Builder {
        /// <p>A container for the prefix-level storage metrics for S3 Storage Lens.</p>
        pub fn storage_metrics(mut self, input: crate::model::PrefixLevelStorageMetrics) -> Self {
            self.storage_metrics = Some(input);
            self
        }
        /// <p>A container for the prefix-level storage metrics for S3 Storage Lens.</p>
        pub fn set_storage_metrics(
            mut self,
            input: std::option::Option<crate::model::PrefixLevelStorageMetrics>,
        ) -> Self {
            self.storage_metrics = input;
            self
        }
        /// Consumes the builder and constructs a [`PrefixLevel`](crate::model::PrefixLevel)
        pub fn build(self) -> crate::model::PrefixLevel {
            crate::model::PrefixLevel {
                storage_metrics: self.storage_metrics,
            }
        }
    }
}
impl PrefixLevel {
    /// Creates a new builder-style object to manufacture [`PrefixLevel`](crate::model::PrefixLevel)
    pub fn builder() -> crate::model::prefix_level::Builder {
        crate::model::prefix_level::Builder::default()
    }
}

/// <p>A container for the prefix-level storage metrics for S3 Storage Lens.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PrefixLevelStorageMetrics {
    /// <p>A container for whether prefix-level storage metrics are enabled.</p>
    pub is_enabled: bool,
    /// <p></p>
    pub selection_criteria: std::option::Option<crate::model::SelectionCriteria>,
}
impl PrefixLevelStorageMetrics {
    /// <p>A container for whether prefix-level storage metrics are enabled.</p>
    pub fn is_enabled(&self) -> bool {
        self.is_enabled
    }
    /// <p></p>
    pub fn selection_criteria(&self) -> std::option::Option<&crate::model::SelectionCriteria> {
        self.selection_criteria.as_ref()
    }
}
impl std::fmt::Debug for PrefixLevelStorageMetrics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PrefixLevelStorageMetrics");
        formatter.field("is_enabled", &self.is_enabled);
        formatter.field("selection_criteria", &self.selection_criteria);
        formatter.finish()
    }
}
/// See [`PrefixLevelStorageMetrics`](crate::model::PrefixLevelStorageMetrics)
pub mod prefix_level_storage_metrics {
    /// A builder for [`PrefixLevelStorageMetrics`](crate::model::PrefixLevelStorageMetrics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) is_enabled: std::option::Option<bool>,
        pub(crate) selection_criteria: std::option::Option<crate::model::SelectionCriteria>,
    }
    impl Builder {
        /// <p>A container for whether prefix-level storage metrics are enabled.</p>
        pub fn is_enabled(mut self, input: bool) -> Self {
            self.is_enabled = Some(input);
            self
        }
        /// <p>A container for whether prefix-level storage metrics are enabled.</p>
        pub fn set_is_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.is_enabled = input;
            self
        }
        /// <p></p>
        pub fn selection_criteria(mut self, input: crate::model::SelectionCriteria) -> Self {
            self.selection_criteria = Some(input);
            self
        }
        /// <p></p>
        pub fn set_selection_criteria(
            mut self,
            input: std::option::Option<crate::model::SelectionCriteria>,
        ) -> Self {
            self.selection_criteria = input;
            self
        }
        /// Consumes the builder and constructs a [`PrefixLevelStorageMetrics`](crate::model::PrefixLevelStorageMetrics)
        pub fn build(self) -> crate::model::PrefixLevelStorageMetrics {
            crate::model::PrefixLevelStorageMetrics {
                is_enabled: self.is_enabled.unwrap_or_default(),
                selection_criteria: self.selection_criteria,
            }
        }
    }
}
impl PrefixLevelStorageMetrics {
    /// Creates a new builder-style object to manufacture [`PrefixLevelStorageMetrics`](crate::model::PrefixLevelStorageMetrics)
    pub fn builder() -> crate::model::prefix_level_storage_metrics::Builder {
        crate::model::prefix_level_storage_metrics::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SelectionCriteria {
    /// <p>A container for the delimiter of the selection criteria being used.</p>
    pub delimiter: std::option::Option<std::string::String>,
    /// <p>The max depth of the selection criteria</p>
    pub max_depth: i32,
    /// <p>The minimum number of storage bytes percentage whose metrics will be selected.</p> <note>
    /// <p>You must choose a value greater than or equal to <code>1.0</code>.</p>
    /// </note>
    pub min_storage_bytes_percentage: f64,
}
impl SelectionCriteria {
    /// <p>A container for the delimiter of the selection criteria being used.</p>
    pub fn delimiter(&self) -> std::option::Option<&str> {
        self.delimiter.as_deref()
    }
    /// <p>The max depth of the selection criteria</p>
    pub fn max_depth(&self) -> i32 {
        self.max_depth
    }
    /// <p>The minimum number of storage bytes percentage whose metrics will be selected.</p> <note>
    /// <p>You must choose a value greater than or equal to <code>1.0</code>.</p>
    /// </note>
    pub fn min_storage_bytes_percentage(&self) -> f64 {
        self.min_storage_bytes_percentage
    }
}
impl std::fmt::Debug for SelectionCriteria {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SelectionCriteria");
        formatter.field("delimiter", &self.delimiter);
        formatter.field("max_depth", &self.max_depth);
        formatter.field(
            "min_storage_bytes_percentage",
            &self.min_storage_bytes_percentage,
        );
        formatter.finish()
    }
}
/// See [`SelectionCriteria`](crate::model::SelectionCriteria)
pub mod selection_criteria {
    /// A builder for [`SelectionCriteria`](crate::model::SelectionCriteria)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delimiter: std::option::Option<std::string::String>,
        pub(crate) max_depth: std::option::Option<i32>,
        pub(crate) min_storage_bytes_percentage: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>A container for the delimiter of the selection criteria being used.</p>
        pub fn delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.delimiter = Some(input.into());
            self
        }
        /// <p>A container for the delimiter of the selection criteria being used.</p>
        pub fn set_delimiter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.delimiter = input;
            self
        }
        /// <p>The max depth of the selection criteria</p>
        pub fn max_depth(mut self, input: i32) -> Self {
            self.max_depth = Some(input);
            self
        }
        /// <p>The max depth of the selection criteria</p>
        pub fn set_max_depth(mut self, input: std::option::Option<i32>) -> Self {
            self.max_depth = input;
            self
        }
        /// <p>The minimum number of storage bytes percentage whose metrics will be selected.</p> <note>
        /// <p>You must choose a value greater than or equal to <code>1.0</code>.</p>
        /// </note>
        pub fn min_storage_bytes_percentage(mut self, input: f64) -> Self {
            self.min_storage_bytes_percentage = Some(input);
            self
        }
        /// <p>The minimum number of storage bytes percentage whose metrics will be selected.</p> <note>
        /// <p>You must choose a value greater than or equal to <code>1.0</code>.</p>
        /// </note>
        pub fn set_min_storage_bytes_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.min_storage_bytes_percentage = input;
            self
        }
        /// Consumes the builder and constructs a [`SelectionCriteria`](crate::model::SelectionCriteria)
        pub fn build(self) -> crate::model::SelectionCriteria {
            crate::model::SelectionCriteria {
                delimiter: self.delimiter,
                max_depth: self.max_depth.unwrap_or_default(),
                min_storage_bytes_percentage: self.min_storage_bytes_percentage.unwrap_or_default(),
            }
        }
    }
}
impl SelectionCriteria {
    /// Creates a new builder-style object to manufacture [`SelectionCriteria`](crate::model::SelectionCriteria)
    pub fn builder() -> crate::model::selection_criteria::Builder {
        crate::model::selection_criteria::Builder::default()
    }
}

/// <p>A container for the activity metrics.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivityMetrics {
    /// <p>A container for whether the activity metrics are enabled.</p>
    pub is_enabled: bool,
}
impl ActivityMetrics {
    /// <p>A container for whether the activity metrics are enabled.</p>
    pub fn is_enabled(&self) -> bool {
        self.is_enabled
    }
}
impl std::fmt::Debug for ActivityMetrics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivityMetrics");
        formatter.field("is_enabled", &self.is_enabled);
        formatter.finish()
    }
}
/// See [`ActivityMetrics`](crate::model::ActivityMetrics)
pub mod activity_metrics {
    /// A builder for [`ActivityMetrics`](crate::model::ActivityMetrics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) is_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A container for whether the activity metrics are enabled.</p>
        pub fn is_enabled(mut self, input: bool) -> Self {
            self.is_enabled = Some(input);
            self
        }
        /// <p>A container for whether the activity metrics are enabled.</p>
        pub fn set_is_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.is_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivityMetrics`](crate::model::ActivityMetrics)
        pub fn build(self) -> crate::model::ActivityMetrics {
            crate::model::ActivityMetrics {
                is_enabled: self.is_enabled.unwrap_or_default(),
            }
        }
    }
}
impl ActivityMetrics {
    /// Creates a new builder-style object to manufacture [`ActivityMetrics`](crate::model::ActivityMetrics)
    pub fn builder() -> crate::model::activity_metrics::Builder {
        crate::model::activity_metrics::Builder::default()
    }
}

/// <p>The <code>PublicAccessBlock</code> configuration that you want to apply to this Amazon S3 account. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <i>Amazon S3 User Guide</i>.</p>
/// <p>This is not supported for Amazon S3 on Outposts.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublicAccessBlockConfiguration {
    /// <p>Specifies whether Amazon S3 should block public access control lists (ACLs) for buckets in this account. Setting this element to <code>TRUE</code> causes the following behavior:</p>
    /// <ul>
    /// <li> <p>PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.</p> </li>
    /// <li> <p>PUT Object calls fail if the request includes a public ACL.</p> </li>
    /// <li> <p>PUT Bucket calls fail if the request includes a public ACL.</p> </li>
    /// </ul>
    /// <p>Enabling this setting doesn't affect existing policies or ACLs.</p>
    /// <p>This is not supported for Amazon S3 on Outposts.</p>
    pub block_public_acls: bool,
    /// <p>Specifies whether Amazon S3 should ignore public ACLs for buckets in this account. Setting this element to <code>TRUE</code> causes Amazon S3 to ignore all public ACLs on buckets in this account and any objects that they contain. </p>
    /// <p>Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.</p>
    /// <p>This is not supported for Amazon S3 on Outposts.</p>
    pub ignore_public_acls: bool,
    /// <p>Specifies whether Amazon S3 should block public bucket policies for buckets in this account. Setting this element to <code>TRUE</code> causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access. </p>
    /// <p>Enabling this setting doesn't affect existing bucket policies.</p>
    /// <p>This is not supported for Amazon S3 on Outposts.</p>
    pub block_public_policy: bool,
    /// <p>Specifies whether Amazon S3 should restrict public bucket policies for buckets in this account. Setting this element to <code>TRUE</code> restricts access to buckets with public policies to only Amazon Web Service principals and authorized users within this account.</p>
    /// <p>Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.</p>
    /// <p>This is not supported for Amazon S3 on Outposts.</p>
    pub restrict_public_buckets: bool,
}
impl PublicAccessBlockConfiguration {
    /// <p>Specifies whether Amazon S3 should block public access control lists (ACLs) for buckets in this account. Setting this element to <code>TRUE</code> causes the following behavior:</p>
    /// <ul>
    /// <li> <p>PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.</p> </li>
    /// <li> <p>PUT Object calls fail if the request includes a public ACL.</p> </li>
    /// <li> <p>PUT Bucket calls fail if the request includes a public ACL.</p> </li>
    /// </ul>
    /// <p>Enabling this setting doesn't affect existing policies or ACLs.</p>
    /// <p>This is not supported for Amazon S3 on Outposts.</p>
    pub fn block_public_acls(&self) -> bool {
        self.block_public_acls
    }
    /// <p>Specifies whether Amazon S3 should ignore public ACLs for buckets in this account. Setting this element to <code>TRUE</code> causes Amazon S3 to ignore all public ACLs on buckets in this account and any objects that they contain. </p>
    /// <p>Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.</p>
    /// <p>This is not supported for Amazon S3 on Outposts.</p>
    pub fn ignore_public_acls(&self) -> bool {
        self.ignore_public_acls
    }
    /// <p>Specifies whether Amazon S3 should block public bucket policies for buckets in this account. Setting this element to <code>TRUE</code> causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access. </p>
    /// <p>Enabling this setting doesn't affect existing bucket policies.</p>
    /// <p>This is not supported for Amazon S3 on Outposts.</p>
    pub fn block_public_policy(&self) -> bool {
        self.block_public_policy
    }
    /// <p>Specifies whether Amazon S3 should restrict public bucket policies for buckets in this account. Setting this element to <code>TRUE</code> restricts access to buckets with public policies to only Amazon Web Service principals and authorized users within this account.</p>
    /// <p>Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.</p>
    /// <p>This is not supported for Amazon S3 on Outposts.</p>
    pub fn restrict_public_buckets(&self) -> bool {
        self.restrict_public_buckets
    }
}
impl std::fmt::Debug for PublicAccessBlockConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublicAccessBlockConfiguration");
        formatter.field("block_public_acls", &self.block_public_acls);
        formatter.field("ignore_public_acls", &self.ignore_public_acls);
        formatter.field("block_public_policy", &self.block_public_policy);
        formatter.field("restrict_public_buckets", &self.restrict_public_buckets);
        formatter.finish()
    }
}
/// See [`PublicAccessBlockConfiguration`](crate::model::PublicAccessBlockConfiguration)
pub mod public_access_block_configuration {
    /// A builder for [`PublicAccessBlockConfiguration`](crate::model::PublicAccessBlockConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) block_public_acls: std::option::Option<bool>,
        pub(crate) ignore_public_acls: std::option::Option<bool>,
        pub(crate) block_public_policy: std::option::Option<bool>,
        pub(crate) restrict_public_buckets: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies whether Amazon S3 should block public access control lists (ACLs) for buckets in this account. Setting this element to <code>TRUE</code> causes the following behavior:</p>
        /// <ul>
        /// <li> <p>PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.</p> </li>
        /// <li> <p>PUT Object calls fail if the request includes a public ACL.</p> </li>
        /// <li> <p>PUT Bucket calls fail if the request includes a public ACL.</p> </li>
        /// </ul>
        /// <p>Enabling this setting doesn't affect existing policies or ACLs.</p>
        /// <p>This is not supported for Amazon S3 on Outposts.</p>
        pub fn block_public_acls(mut self, input: bool) -> Self {
            self.block_public_acls = Some(input);
            self
        }
        /// <p>Specifies whether Amazon S3 should block public access control lists (ACLs) for buckets in this account. Setting this element to <code>TRUE</code> causes the following behavior:</p>
        /// <ul>
        /// <li> <p>PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.</p> </li>
        /// <li> <p>PUT Object calls fail if the request includes a public ACL.</p> </li>
        /// <li> <p>PUT Bucket calls fail if the request includes a public ACL.</p> </li>
        /// </ul>
        /// <p>Enabling this setting doesn't affect existing policies or ACLs.</p>
        /// <p>This is not supported for Amazon S3 on Outposts.</p>
        pub fn set_block_public_acls(mut self, input: std::option::Option<bool>) -> Self {
            self.block_public_acls = input;
            self
        }
        /// <p>Specifies whether Amazon S3 should ignore public ACLs for buckets in this account. Setting this element to <code>TRUE</code> causes Amazon S3 to ignore all public ACLs on buckets in this account and any objects that they contain. </p>
        /// <p>Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.</p>
        /// <p>This is not supported for Amazon S3 on Outposts.</p>
        pub fn ignore_public_acls(mut self, input: bool) -> Self {
            self.ignore_public_acls = Some(input);
            self
        }
        /// <p>Specifies whether Amazon S3 should ignore public ACLs for buckets in this account. Setting this element to <code>TRUE</code> causes Amazon S3 to ignore all public ACLs on buckets in this account and any objects that they contain. </p>
        /// <p>Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.</p>
        /// <p>This is not supported for Amazon S3 on Outposts.</p>
        pub fn set_ignore_public_acls(mut self, input: std::option::Option<bool>) -> Self {
            self.ignore_public_acls = input;
            self
        }
        /// <p>Specifies whether Amazon S3 should block public bucket policies for buckets in this account. Setting this element to <code>TRUE</code> causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access. </p>
        /// <p>Enabling this setting doesn't affect existing bucket policies.</p>
        /// <p>This is not supported for Amazon S3 on Outposts.</p>
        pub fn block_public_policy(mut self, input: bool) -> Self {
            self.block_public_policy = Some(input);
            self
        }
        /// <p>Specifies whether Amazon S3 should block public bucket policies for buckets in this account. Setting this element to <code>TRUE</code> causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access. </p>
        /// <p>Enabling this setting doesn't affect existing bucket policies.</p>
        /// <p>This is not supported for Amazon S3 on Outposts.</p>
        pub fn set_block_public_policy(mut self, input: std::option::Option<bool>) -> Self {
            self.block_public_policy = input;
            self
        }
        /// <p>Specifies whether Amazon S3 should restrict public bucket policies for buckets in this account. Setting this element to <code>TRUE</code> restricts access to buckets with public policies to only Amazon Web Service principals and authorized users within this account.</p>
        /// <p>Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.</p>
        /// <p>This is not supported for Amazon S3 on Outposts.</p>
        pub fn restrict_public_buckets(mut self, input: bool) -> Self {
            self.restrict_public_buckets = Some(input);
            self
        }
        /// <p>Specifies whether Amazon S3 should restrict public bucket policies for buckets in this account. Setting this element to <code>TRUE</code> restricts access to buckets with public policies to only Amazon Web Service principals and authorized users within this account.</p>
        /// <p>Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.</p>
        /// <p>This is not supported for Amazon S3 on Outposts.</p>
        pub fn set_restrict_public_buckets(mut self, input: std::option::Option<bool>) -> Self {
            self.restrict_public_buckets = input;
            self
        }
        /// Consumes the builder and constructs a [`PublicAccessBlockConfiguration`](crate::model::PublicAccessBlockConfiguration)
        pub fn build(self) -> crate::model::PublicAccessBlockConfiguration {
            crate::model::PublicAccessBlockConfiguration {
                block_public_acls: self.block_public_acls.unwrap_or_default(),
                ignore_public_acls: self.ignore_public_acls.unwrap_or_default(),
                block_public_policy: self.block_public_policy.unwrap_or_default(),
                restrict_public_buckets: self.restrict_public_buckets.unwrap_or_default(),
            }
        }
    }
}
impl PublicAccessBlockConfiguration {
    /// Creates a new builder-style object to manufacture [`PublicAccessBlockConfiguration`](crate::model::PublicAccessBlockConfiguration)
    pub fn builder() -> crate::model::public_access_block_configuration::Builder {
        crate::model::public_access_block_configuration::Builder::default()
    }
}

/// <p>A container for the information associated with a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPoint.html">PutMultiRegionAccessPoint</a> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutMultiRegionAccessPointPolicyInput {
    /// <p>The name of the Multi-Region Access Point associated with the request.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The policy details for the <code>PutMultiRegionAccessPoint</code> request.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl PutMultiRegionAccessPointPolicyInput {
    /// <p>The name of the Multi-Region Access Point associated with the request.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The policy details for the <code>PutMultiRegionAccessPoint</code> request.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for PutMultiRegionAccessPointPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutMultiRegionAccessPointPolicyInput");
        formatter.field("name", &self.name);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`PutMultiRegionAccessPointPolicyInput`](crate::model::PutMultiRegionAccessPointPolicyInput)
pub mod put_multi_region_access_point_policy_input {
    /// A builder for [`PutMultiRegionAccessPointPolicyInput`](crate::model::PutMultiRegionAccessPointPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Multi-Region Access Point associated with the request.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Multi-Region Access Point associated with the request.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The policy details for the <code>PutMultiRegionAccessPoint</code> request.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The policy details for the <code>PutMultiRegionAccessPoint</code> request.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutMultiRegionAccessPointPolicyInput`](crate::model::PutMultiRegionAccessPointPolicyInput)
        pub fn build(self) -> crate::model::PutMultiRegionAccessPointPolicyInput {
            crate::model::PutMultiRegionAccessPointPolicyInput {
                name: self.name,
                policy: self.policy,
            }
        }
    }
}
impl PutMultiRegionAccessPointPolicyInput {
    /// Creates a new builder-style object to manufacture [`PutMultiRegionAccessPointPolicyInput`](crate::model::PutMultiRegionAccessPointPolicyInput)
    pub fn builder() -> crate::model::put_multi_region_access_point_policy_input::Builder {
        crate::model::put_multi_region_access_point_policy_input::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Tag {
    /// <p></p>
    pub key: std::option::Option<std::string::String>,
    /// <p></p>
    pub value: std::option::Option<std::string::String>,
}
impl S3Tag {
    /// <p></p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p></p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for S3Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`S3Tag`](crate::model::S3Tag)
pub mod s3_tag {
    /// A builder for [`S3Tag`](crate::model::S3Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p></p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Tag`](crate::model::S3Tag)
        pub fn build(self) -> crate::model::S3Tag {
            crate::model::S3Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl S3Tag {
    /// Creates a new builder-style object to manufacture [`S3Tag`](crate::model::S3Tag)
    pub fn builder() -> crate::model::s3_tag::Builder {
        crate::model::s3_tag::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tagging {
    /// <p>A collection for a set of tags.</p>
    pub tag_set: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
}
impl Tagging {
    /// <p>A collection for a set of tags.</p>
    pub fn tag_set(&self) -> std::option::Option<&[crate::model::S3Tag]> {
        self.tag_set.as_deref()
    }
}
impl std::fmt::Debug for Tagging {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tagging");
        formatter.field("tag_set", &self.tag_set);
        formatter.finish()
    }
}
/// See [`Tagging`](crate::model::Tagging)
pub mod tagging {
    /// A builder for [`Tagging`](crate::model::Tagging)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_set: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
    }
    impl Builder {
        /// Appends an item to `tag_set`.
        ///
        /// To override the contents of this collection use [`set_tag_set`](Self::set_tag_set).
        ///
        /// <p>A collection for a set of tags.</p>
        pub fn tag_set(mut self, input: crate::model::S3Tag) -> Self {
            let mut v = self.tag_set.unwrap_or_default();
            v.push(input);
            self.tag_set = Some(v);
            self
        }
        /// <p>A collection for a set of tags.</p>
        pub fn set_tag_set(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
        ) -> Self {
            self.tag_set = input;
            self
        }
        /// Consumes the builder and constructs a [`Tagging`](crate::model::Tagging)
        pub fn build(self) -> crate::model::Tagging {
            crate::model::Tagging {
                tag_set: self.tag_set,
            }
        }
    }
}
impl Tagging {
    /// Creates a new builder-style object to manufacture [`Tagging`](crate::model::Tagging)
    pub fn builder() -> crate::model::tagging::Builder {
        crate::model::tagging::Builder::default()
    }
}

/// <p>The container for the Outposts bucket lifecycle configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifecycleConfiguration {
    /// <p>A lifecycle rule for individual objects in an Outposts bucket. </p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::LifecycleRule>>,
}
impl LifecycleConfiguration {
    /// <p>A lifecycle rule for individual objects in an Outposts bucket. </p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::LifecycleRule]> {
        self.rules.as_deref()
    }
}
impl std::fmt::Debug for LifecycleConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifecycleConfiguration");
        formatter.field("rules", &self.rules);
        formatter.finish()
    }
}
/// See [`LifecycleConfiguration`](crate::model::LifecycleConfiguration)
pub mod lifecycle_configuration {
    /// A builder for [`LifecycleConfiguration`](crate::model::LifecycleConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::LifecycleRule>>,
    }
    impl Builder {
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>A lifecycle rule for individual objects in an Outposts bucket. </p>
        pub fn rules(mut self, input: crate::model::LifecycleRule) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input);
            self.rules = Some(v);
            self
        }
        /// <p>A lifecycle rule for individual objects in an Outposts bucket. </p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LifecycleRule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// Consumes the builder and constructs a [`LifecycleConfiguration`](crate::model::LifecycleConfiguration)
        pub fn build(self) -> crate::model::LifecycleConfiguration {
            crate::model::LifecycleConfiguration { rules: self.rules }
        }
    }
}
impl LifecycleConfiguration {
    /// Creates a new builder-style object to manufacture [`LifecycleConfiguration`](crate::model::LifecycleConfiguration)
    pub fn builder() -> crate::model::lifecycle_configuration::Builder {
        crate::model::lifecycle_configuration::Builder::default()
    }
}

/// <p>The container for the Outposts bucket lifecycle rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifecycleRule {
    /// <p>Specifies the expiration for the lifecycle of the object in the form of date, days and, whether the object has a delete marker.</p>
    pub expiration: std::option::Option<crate::model::LifecycleExpiration>,
    /// <p>Unique identifier for the rule. The value cannot be longer than 255 characters.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The container for the filter of lifecycle rule.</p>
    pub filter: std::option::Option<crate::model::LifecycleRuleFilter>,
    /// <p>If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.</p>
    pub status: std::option::Option<crate::model::ExpirationStatus>,
    /// <p>Specifies when an Amazon S3 object transitions to a specified storage class.</p> <note>
    /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub transitions: std::option::Option<std::vec::Vec<crate::model::Transition>>,
    /// <p> Specifies the transition rule for the lifecycle rule that describes when noncurrent objects transition to a specific storage class. If your bucket is versioning-enabled (or versioning is suspended), you can set this action to request that Amazon S3 transition noncurrent object versions to a specific storage class at a set period in the object's lifetime. </p> <note>
    /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub noncurrent_version_transitions:
        std::option::Option<std::vec::Vec<crate::model::NoncurrentVersionTransition>>,
    /// <p>The noncurrent version expiration of the lifecycle rule.</p> <note>
    /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub noncurrent_version_expiration:
        std::option::Option<crate::model::NoncurrentVersionExpiration>,
    /// <p>Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 waits before permanently removing all parts of the upload. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config"> Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Policy</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub abort_incomplete_multipart_upload:
        std::option::Option<crate::model::AbortIncompleteMultipartUpload>,
}
impl LifecycleRule {
    /// <p>Specifies the expiration for the lifecycle of the object in the form of date, days and, whether the object has a delete marker.</p>
    pub fn expiration(&self) -> std::option::Option<&crate::model::LifecycleExpiration> {
        self.expiration.as_ref()
    }
    /// <p>Unique identifier for the rule. The value cannot be longer than 255 characters.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The container for the filter of lifecycle rule.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::LifecycleRuleFilter> {
        self.filter.as_ref()
    }
    /// <p>If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ExpirationStatus> {
        self.status.as_ref()
    }
    /// <p>Specifies when an Amazon S3 object transitions to a specified storage class.</p> <note>
    /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub fn transitions(&self) -> std::option::Option<&[crate::model::Transition]> {
        self.transitions.as_deref()
    }
    /// <p> Specifies the transition rule for the lifecycle rule that describes when noncurrent objects transition to a specific storage class. If your bucket is versioning-enabled (or versioning is suspended), you can set this action to request that Amazon S3 transition noncurrent object versions to a specific storage class at a set period in the object's lifetime. </p> <note>
    /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub fn noncurrent_version_transitions(
        &self,
    ) -> std::option::Option<&[crate::model::NoncurrentVersionTransition]> {
        self.noncurrent_version_transitions.as_deref()
    }
    /// <p>The noncurrent version expiration of the lifecycle rule.</p> <note>
    /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub fn noncurrent_version_expiration(
        &self,
    ) -> std::option::Option<&crate::model::NoncurrentVersionExpiration> {
        self.noncurrent_version_expiration.as_ref()
    }
    /// <p>Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 waits before permanently removing all parts of the upload. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config"> Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Policy</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn abort_incomplete_multipart_upload(
        &self,
    ) -> std::option::Option<&crate::model::AbortIncompleteMultipartUpload> {
        self.abort_incomplete_multipart_upload.as_ref()
    }
}
impl std::fmt::Debug for LifecycleRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifecycleRule");
        formatter.field("expiration", &self.expiration);
        formatter.field("id", &self.id);
        formatter.field("filter", &self.filter);
        formatter.field("status", &self.status);
        formatter.field("transitions", &self.transitions);
        formatter.field(
            "noncurrent_version_transitions",
            &self.noncurrent_version_transitions,
        );
        formatter.field(
            "noncurrent_version_expiration",
            &self.noncurrent_version_expiration,
        );
        formatter.field(
            "abort_incomplete_multipart_upload",
            &self.abort_incomplete_multipart_upload,
        );
        formatter.finish()
    }
}
/// See [`LifecycleRule`](crate::model::LifecycleRule)
pub mod lifecycle_rule {
    /// A builder for [`LifecycleRule`](crate::model::LifecycleRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) expiration: std::option::Option<crate::model::LifecycleExpiration>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) filter: std::option::Option<crate::model::LifecycleRuleFilter>,
        pub(crate) status: std::option::Option<crate::model::ExpirationStatus>,
        pub(crate) transitions: std::option::Option<std::vec::Vec<crate::model::Transition>>,
        pub(crate) noncurrent_version_transitions:
            std::option::Option<std::vec::Vec<crate::model::NoncurrentVersionTransition>>,
        pub(crate) noncurrent_version_expiration:
            std::option::Option<crate::model::NoncurrentVersionExpiration>,
        pub(crate) abort_incomplete_multipart_upload:
            std::option::Option<crate::model::AbortIncompleteMultipartUpload>,
    }
    impl Builder {
        /// <p>Specifies the expiration for the lifecycle of the object in the form of date, days and, whether the object has a delete marker.</p>
        pub fn expiration(mut self, input: crate::model::LifecycleExpiration) -> Self {
            self.expiration = Some(input);
            self
        }
        /// <p>Specifies the expiration for the lifecycle of the object in the form of date, days and, whether the object has a delete marker.</p>
        pub fn set_expiration(
            mut self,
            input: std::option::Option<crate::model::LifecycleExpiration>,
        ) -> Self {
            self.expiration = input;
            self
        }
        /// <p>Unique identifier for the rule. The value cannot be longer than 255 characters.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Unique identifier for the rule. The value cannot be longer than 255 characters.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The container for the filter of lifecycle rule.</p>
        pub fn filter(mut self, input: crate::model::LifecycleRuleFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>The container for the filter of lifecycle rule.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::LifecycleRuleFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.</p>
        pub fn status(mut self, input: crate::model::ExpirationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ExpirationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `transitions`.
        ///
        /// To override the contents of this collection use [`set_transitions`](Self::set_transitions).
        ///
        /// <p>Specifies when an Amazon S3 object transitions to a specified storage class.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn transitions(mut self, input: crate::model::Transition) -> Self {
            let mut v = self.transitions.unwrap_or_default();
            v.push(input);
            self.transitions = Some(v);
            self
        }
        /// <p>Specifies when an Amazon S3 object transitions to a specified storage class.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_transitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Transition>>,
        ) -> Self {
            self.transitions = input;
            self
        }
        /// Appends an item to `noncurrent_version_transitions`.
        ///
        /// To override the contents of this collection use [`set_noncurrent_version_transitions`](Self::set_noncurrent_version_transitions).
        ///
        /// <p> Specifies the transition rule for the lifecycle rule that describes when noncurrent objects transition to a specific storage class. If your bucket is versioning-enabled (or versioning is suspended), you can set this action to request that Amazon S3 transition noncurrent object versions to a specific storage class at a set period in the object's lifetime. </p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn noncurrent_version_transitions(
            mut self,
            input: crate::model::NoncurrentVersionTransition,
        ) -> Self {
            let mut v = self.noncurrent_version_transitions.unwrap_or_default();
            v.push(input);
            self.noncurrent_version_transitions = Some(v);
            self
        }
        /// <p> Specifies the transition rule for the lifecycle rule that describes when noncurrent objects transition to a specific storage class. If your bucket is versioning-enabled (or versioning is suspended), you can set this action to request that Amazon S3 transition noncurrent object versions to a specific storage class at a set period in the object's lifetime. </p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_noncurrent_version_transitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NoncurrentVersionTransition>>,
        ) -> Self {
            self.noncurrent_version_transitions = input;
            self
        }
        /// <p>The noncurrent version expiration of the lifecycle rule.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn noncurrent_version_expiration(
            mut self,
            input: crate::model::NoncurrentVersionExpiration,
        ) -> Self {
            self.noncurrent_version_expiration = Some(input);
            self
        }
        /// <p>The noncurrent version expiration of the lifecycle rule.</p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_noncurrent_version_expiration(
            mut self,
            input: std::option::Option<crate::model::NoncurrentVersionExpiration>,
        ) -> Self {
            self.noncurrent_version_expiration = input;
            self
        }
        /// <p>Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 waits before permanently removing all parts of the upload. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config"> Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Policy</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn abort_incomplete_multipart_upload(
            mut self,
            input: crate::model::AbortIncompleteMultipartUpload,
        ) -> Self {
            self.abort_incomplete_multipart_upload = Some(input);
            self
        }
        /// <p>Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 waits before permanently removing all parts of the upload. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config"> Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Policy</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_abort_incomplete_multipart_upload(
            mut self,
            input: std::option::Option<crate::model::AbortIncompleteMultipartUpload>,
        ) -> Self {
            self.abort_incomplete_multipart_upload = input;
            self
        }
        /// Consumes the builder and constructs a [`LifecycleRule`](crate::model::LifecycleRule)
        pub fn build(self) -> crate::model::LifecycleRule {
            crate::model::LifecycleRule {
                expiration: self.expiration,
                id: self.id,
                filter: self.filter,
                status: self.status,
                transitions: self.transitions,
                noncurrent_version_transitions: self.noncurrent_version_transitions,
                noncurrent_version_expiration: self.noncurrent_version_expiration,
                abort_incomplete_multipart_upload: self.abort_incomplete_multipart_upload,
            }
        }
    }
}
impl LifecycleRule {
    /// Creates a new builder-style object to manufacture [`LifecycleRule`](crate::model::LifecycleRule)
    pub fn builder() -> crate::model::lifecycle_rule::Builder {
        crate::model::lifecycle_rule::Builder::default()
    }
}

/// <p>The container for abort incomplete multipart upload</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AbortIncompleteMultipartUpload {
    /// <p>Specifies the number of days after which Amazon S3 aborts an incomplete multipart upload to the Outposts bucket.</p>
    pub days_after_initiation: i32,
}
impl AbortIncompleteMultipartUpload {
    /// <p>Specifies the number of days after which Amazon S3 aborts an incomplete multipart upload to the Outposts bucket.</p>
    pub fn days_after_initiation(&self) -> i32 {
        self.days_after_initiation
    }
}
impl std::fmt::Debug for AbortIncompleteMultipartUpload {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AbortIncompleteMultipartUpload");
        formatter.field("days_after_initiation", &self.days_after_initiation);
        formatter.finish()
    }
}
/// See [`AbortIncompleteMultipartUpload`](crate::model::AbortIncompleteMultipartUpload)
pub mod abort_incomplete_multipart_upload {
    /// A builder for [`AbortIncompleteMultipartUpload`](crate::model::AbortIncompleteMultipartUpload)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) days_after_initiation: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specifies the number of days after which Amazon S3 aborts an incomplete multipart upload to the Outposts bucket.</p>
        pub fn days_after_initiation(mut self, input: i32) -> Self {
            self.days_after_initiation = Some(input);
            self
        }
        /// <p>Specifies the number of days after which Amazon S3 aborts an incomplete multipart upload to the Outposts bucket.</p>
        pub fn set_days_after_initiation(mut self, input: std::option::Option<i32>) -> Self {
            self.days_after_initiation = input;
            self
        }
        /// Consumes the builder and constructs a [`AbortIncompleteMultipartUpload`](crate::model::AbortIncompleteMultipartUpload)
        pub fn build(self) -> crate::model::AbortIncompleteMultipartUpload {
            crate::model::AbortIncompleteMultipartUpload {
                days_after_initiation: self.days_after_initiation.unwrap_or_default(),
            }
        }
    }
}
impl AbortIncompleteMultipartUpload {
    /// Creates a new builder-style object to manufacture [`AbortIncompleteMultipartUpload`](crate::model::AbortIncompleteMultipartUpload)
    pub fn builder() -> crate::model::abort_incomplete_multipart_upload::Builder {
        crate::model::abort_incomplete_multipart_upload::Builder::default()
    }
}

/// <p>The container of the noncurrent version expiration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoncurrentVersionExpiration {
    /// <p>Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action. For information about the noncurrent days calculations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations">How Amazon S3 Calculates When an Object Became Noncurrent</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub noncurrent_days: i32,
}
impl NoncurrentVersionExpiration {
    /// <p>Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action. For information about the noncurrent days calculations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations">How Amazon S3 Calculates When an Object Became Noncurrent</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn noncurrent_days(&self) -> i32 {
        self.noncurrent_days
    }
}
impl std::fmt::Debug for NoncurrentVersionExpiration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoncurrentVersionExpiration");
        formatter.field("noncurrent_days", &self.noncurrent_days);
        formatter.finish()
    }
}
/// See [`NoncurrentVersionExpiration`](crate::model::NoncurrentVersionExpiration)
pub mod noncurrent_version_expiration {
    /// A builder for [`NoncurrentVersionExpiration`](crate::model::NoncurrentVersionExpiration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) noncurrent_days: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action. For information about the noncurrent days calculations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations">How Amazon S3 Calculates When an Object Became Noncurrent</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn noncurrent_days(mut self, input: i32) -> Self {
            self.noncurrent_days = Some(input);
            self
        }
        /// <p>Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action. For information about the noncurrent days calculations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations">How Amazon S3 Calculates When an Object Became Noncurrent</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_noncurrent_days(mut self, input: std::option::Option<i32>) -> Self {
            self.noncurrent_days = input;
            self
        }
        /// Consumes the builder and constructs a [`NoncurrentVersionExpiration`](crate::model::NoncurrentVersionExpiration)
        pub fn build(self) -> crate::model::NoncurrentVersionExpiration {
            crate::model::NoncurrentVersionExpiration {
                noncurrent_days: self.noncurrent_days.unwrap_or_default(),
            }
        }
    }
}
impl NoncurrentVersionExpiration {
    /// Creates a new builder-style object to manufacture [`NoncurrentVersionExpiration`](crate::model::NoncurrentVersionExpiration)
    pub fn builder() -> crate::model::noncurrent_version_expiration::Builder {
        crate::model::noncurrent_version_expiration::Builder::default()
    }
}

/// <p>The container for the noncurrent version transition.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoncurrentVersionTransition {
    /// <p>Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action. For information about the noncurrent days calculations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations"> How Amazon S3 Calculates How Long an Object Has Been Noncurrent</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub noncurrent_days: i32,
    /// <p>The class of storage used to store the object.</p>
    pub storage_class: std::option::Option<crate::model::TransitionStorageClass>,
}
impl NoncurrentVersionTransition {
    /// <p>Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action. For information about the noncurrent days calculations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations"> How Amazon S3 Calculates How Long an Object Has Been Noncurrent</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn noncurrent_days(&self) -> i32 {
        self.noncurrent_days
    }
    /// <p>The class of storage used to store the object.</p>
    pub fn storage_class(&self) -> std::option::Option<&crate::model::TransitionStorageClass> {
        self.storage_class.as_ref()
    }
}
impl std::fmt::Debug for NoncurrentVersionTransition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoncurrentVersionTransition");
        formatter.field("noncurrent_days", &self.noncurrent_days);
        formatter.field("storage_class", &self.storage_class);
        formatter.finish()
    }
}
/// See [`NoncurrentVersionTransition`](crate::model::NoncurrentVersionTransition)
pub mod noncurrent_version_transition {
    /// A builder for [`NoncurrentVersionTransition`](crate::model::NoncurrentVersionTransition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) noncurrent_days: std::option::Option<i32>,
        pub(crate) storage_class: std::option::Option<crate::model::TransitionStorageClass>,
    }
    impl Builder {
        /// <p>Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action. For information about the noncurrent days calculations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations"> How Amazon S3 Calculates How Long an Object Has Been Noncurrent</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn noncurrent_days(mut self, input: i32) -> Self {
            self.noncurrent_days = Some(input);
            self
        }
        /// <p>Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action. For information about the noncurrent days calculations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations"> How Amazon S3 Calculates How Long an Object Has Been Noncurrent</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_noncurrent_days(mut self, input: std::option::Option<i32>) -> Self {
            self.noncurrent_days = input;
            self
        }
        /// <p>The class of storage used to store the object.</p>
        pub fn storage_class(mut self, input: crate::model::TransitionStorageClass) -> Self {
            self.storage_class = Some(input);
            self
        }
        /// <p>The class of storage used to store the object.</p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<crate::model::TransitionStorageClass>,
        ) -> Self {
            self.storage_class = input;
            self
        }
        /// Consumes the builder and constructs a [`NoncurrentVersionTransition`](crate::model::NoncurrentVersionTransition)
        pub fn build(self) -> crate::model::NoncurrentVersionTransition {
            crate::model::NoncurrentVersionTransition {
                noncurrent_days: self.noncurrent_days.unwrap_or_default(),
                storage_class: self.storage_class,
            }
        }
    }
}
impl NoncurrentVersionTransition {
    /// Creates a new builder-style object to manufacture [`NoncurrentVersionTransition`](crate::model::NoncurrentVersionTransition)
    pub fn builder() -> crate::model::noncurrent_version_transition::Builder {
        crate::model::noncurrent_version_transition::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TransitionStorageClass {
    #[allow(missing_docs)] // documentation missing in model
    DeepArchive,
    #[allow(missing_docs)] // documentation missing in model
    Glacier,
    #[allow(missing_docs)] // documentation missing in model
    IntelligentTiering,
    #[allow(missing_docs)] // documentation missing in model
    OnezoneIa,
    #[allow(missing_docs)] // documentation missing in model
    StandardIa,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TransitionStorageClass {
    fn from(s: &str) -> Self {
        match s {
            "DEEP_ARCHIVE" => TransitionStorageClass::DeepArchive,
            "GLACIER" => TransitionStorageClass::Glacier,
            "INTELLIGENT_TIERING" => TransitionStorageClass::IntelligentTiering,
            "ONEZONE_IA" => TransitionStorageClass::OnezoneIa,
            "STANDARD_IA" => TransitionStorageClass::StandardIa,
            other => TransitionStorageClass::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TransitionStorageClass {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TransitionStorageClass::from(s))
    }
}
impl TransitionStorageClass {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TransitionStorageClass::DeepArchive => "DEEP_ARCHIVE",
            TransitionStorageClass::Glacier => "GLACIER",
            TransitionStorageClass::IntelligentTiering => "INTELLIGENT_TIERING",
            TransitionStorageClass::OnezoneIa => "ONEZONE_IA",
            TransitionStorageClass::StandardIa => "STANDARD_IA",
            TransitionStorageClass::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DEEP_ARCHIVE",
            "GLACIER",
            "INTELLIGENT_TIERING",
            "ONEZONE_IA",
            "STANDARD_IA",
        ]
    }
}
impl AsRef<str> for TransitionStorageClass {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies when an object transitions to a specified storage class. For more information about Amazon S3 Lifecycle configuration rules, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/lifecycle-transition-general-considerations.html"> Transitioning objects using Amazon S3 Lifecycle</a> in the <i>Amazon S3 User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Transition {
    /// <p>Indicates when objects are transitioned to the specified storage class. The date value must be in ISO 8601 format. The time is always midnight UTC.</p>
    pub date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Indicates the number of days after creation when objects are transitioned to the specified storage class. The value must be a positive integer.</p>
    pub days: i32,
    /// <p>The storage class to which you want the object to transition.</p>
    pub storage_class: std::option::Option<crate::model::TransitionStorageClass>,
}
impl Transition {
    /// <p>Indicates when objects are transitioned to the specified storage class. The date value must be in ISO 8601 format. The time is always midnight UTC.</p>
    pub fn date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.date.as_ref()
    }
    /// <p>Indicates the number of days after creation when objects are transitioned to the specified storage class. The value must be a positive integer.</p>
    pub fn days(&self) -> i32 {
        self.days
    }
    /// <p>The storage class to which you want the object to transition.</p>
    pub fn storage_class(&self) -> std::option::Option<&crate::model::TransitionStorageClass> {
        self.storage_class.as_ref()
    }
}
impl std::fmt::Debug for Transition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Transition");
        formatter.field("date", &self.date);
        formatter.field("days", &self.days);
        formatter.field("storage_class", &self.storage_class);
        formatter.finish()
    }
}
/// See [`Transition`](crate::model::Transition)
pub mod transition {
    /// A builder for [`Transition`](crate::model::Transition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) days: std::option::Option<i32>,
        pub(crate) storage_class: std::option::Option<crate::model::TransitionStorageClass>,
    }
    impl Builder {
        /// <p>Indicates when objects are transitioned to the specified storage class. The date value must be in ISO 8601 format. The time is always midnight UTC.</p>
        pub fn date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.date = Some(input);
            self
        }
        /// <p>Indicates when objects are transitioned to the specified storage class. The date value must be in ISO 8601 format. The time is always midnight UTC.</p>
        pub fn set_date(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.date = input;
            self
        }
        /// <p>Indicates the number of days after creation when objects are transitioned to the specified storage class. The value must be a positive integer.</p>
        pub fn days(mut self, input: i32) -> Self {
            self.days = Some(input);
            self
        }
        /// <p>Indicates the number of days after creation when objects are transitioned to the specified storage class. The value must be a positive integer.</p>
        pub fn set_days(mut self, input: std::option::Option<i32>) -> Self {
            self.days = input;
            self
        }
        /// <p>The storage class to which you want the object to transition.</p>
        pub fn storage_class(mut self, input: crate::model::TransitionStorageClass) -> Self {
            self.storage_class = Some(input);
            self
        }
        /// <p>The storage class to which you want the object to transition.</p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<crate::model::TransitionStorageClass>,
        ) -> Self {
            self.storage_class = input;
            self
        }
        /// Consumes the builder and constructs a [`Transition`](crate::model::Transition)
        pub fn build(self) -> crate::model::Transition {
            crate::model::Transition {
                date: self.date,
                days: self.days.unwrap_or_default(),
                storage_class: self.storage_class,
            }
        }
    }
}
impl Transition {
    /// Creates a new builder-style object to manufacture [`Transition`](crate::model::Transition)
    pub fn builder() -> crate::model::transition::Builder {
        crate::model::transition::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExpirationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExpirationStatus {
    fn from(s: &str) -> Self {
        match s {
            "Disabled" => ExpirationStatus::Disabled,
            "Enabled" => ExpirationStatus::Enabled,
            other => ExpirationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExpirationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExpirationStatus::from(s))
    }
}
impl ExpirationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExpirationStatus::Disabled => "Disabled",
            ExpirationStatus::Enabled => "Enabled",
            ExpirationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Disabled", "Enabled"]
    }
}
impl AsRef<str> for ExpirationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The container for the filter of the lifecycle rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifecycleRuleFilter {
    /// <p>Prefix identifying one or more objects to which the rule applies.</p> <important>
    /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
    /// </important>
    pub prefix: std::option::Option<std::string::String>,
    /// <p></p>
    pub tag: std::option::Option<crate::model::S3Tag>,
    /// <p>The container for the <code>AND</code> condition for the lifecycle rule.</p>
    pub and: std::option::Option<crate::model::LifecycleRuleAndOperator>,
}
impl LifecycleRuleFilter {
    /// <p>Prefix identifying one or more objects to which the rule applies.</p> <important>
    /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
    /// </important>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p></p>
    pub fn tag(&self) -> std::option::Option<&crate::model::S3Tag> {
        self.tag.as_ref()
    }
    /// <p>The container for the <code>AND</code> condition for the lifecycle rule.</p>
    pub fn and(&self) -> std::option::Option<&crate::model::LifecycleRuleAndOperator> {
        self.and.as_ref()
    }
}
impl std::fmt::Debug for LifecycleRuleFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifecycleRuleFilter");
        formatter.field("prefix", &self.prefix);
        formatter.field("tag", &self.tag);
        formatter.field("and", &self.and);
        formatter.finish()
    }
}
/// See [`LifecycleRuleFilter`](crate::model::LifecycleRuleFilter)
pub mod lifecycle_rule_filter {
    /// A builder for [`LifecycleRuleFilter`](crate::model::LifecycleRuleFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) tag: std::option::Option<crate::model::S3Tag>,
        pub(crate) and: std::option::Option<crate::model::LifecycleRuleAndOperator>,
    }
    impl Builder {
        /// <p>Prefix identifying one or more objects to which the rule applies.</p> <important>
        /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
        /// </important>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>Prefix identifying one or more objects to which the rule applies.</p> <important>
        /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
        /// </important>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p></p>
        pub fn tag(mut self, input: crate::model::S3Tag) -> Self {
            self.tag = Some(input);
            self
        }
        /// <p></p>
        pub fn set_tag(mut self, input: std::option::Option<crate::model::S3Tag>) -> Self {
            self.tag = input;
            self
        }
        /// <p>The container for the <code>AND</code> condition for the lifecycle rule.</p>
        pub fn and(mut self, input: crate::model::LifecycleRuleAndOperator) -> Self {
            self.and = Some(input);
            self
        }
        /// <p>The container for the <code>AND</code> condition for the lifecycle rule.</p>
        pub fn set_and(
            mut self,
            input: std::option::Option<crate::model::LifecycleRuleAndOperator>,
        ) -> Self {
            self.and = input;
            self
        }
        /// Consumes the builder and constructs a [`LifecycleRuleFilter`](crate::model::LifecycleRuleFilter)
        pub fn build(self) -> crate::model::LifecycleRuleFilter {
            crate::model::LifecycleRuleFilter {
                prefix: self.prefix,
                tag: self.tag,
                and: self.and,
            }
        }
    }
}
impl LifecycleRuleFilter {
    /// Creates a new builder-style object to manufacture [`LifecycleRuleFilter`](crate::model::LifecycleRuleFilter)
    pub fn builder() -> crate::model::lifecycle_rule_filter::Builder {
        crate::model::lifecycle_rule_filter::Builder::default()
    }
}

/// <p>The container for the Outposts bucket lifecycle rule and operator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifecycleRuleAndOperator {
    /// <p>Prefix identifying one or more objects to which the rule applies.</p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>All of these tags must exist in the object's tag set in order for the rule to apply.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
}
impl LifecycleRuleAndOperator {
    /// <p>Prefix identifying one or more objects to which the rule applies.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>All of these tags must exist in the object's tag set in order for the rule to apply.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::S3Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for LifecycleRuleAndOperator {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifecycleRuleAndOperator");
        formatter.field("prefix", &self.prefix);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`LifecycleRuleAndOperator`](crate::model::LifecycleRuleAndOperator)
pub mod lifecycle_rule_and_operator {
    /// A builder for [`LifecycleRuleAndOperator`](crate::model::LifecycleRuleAndOperator)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
    }
    impl Builder {
        /// <p>Prefix identifying one or more objects to which the rule applies.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>Prefix identifying one or more objects to which the rule applies.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>All of these tags must exist in the object's tag set in order for the rule to apply.</p>
        pub fn tags(mut self, input: crate::model::S3Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>All of these tags must exist in the object's tag set in order for the rule to apply.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`LifecycleRuleAndOperator`](crate::model::LifecycleRuleAndOperator)
        pub fn build(self) -> crate::model::LifecycleRuleAndOperator {
            crate::model::LifecycleRuleAndOperator {
                prefix: self.prefix,
                tags: self.tags,
            }
        }
    }
}
impl LifecycleRuleAndOperator {
    /// Creates a new builder-style object to manufacture [`LifecycleRuleAndOperator`](crate::model::LifecycleRuleAndOperator)
    pub fn builder() -> crate::model::lifecycle_rule_and_operator::Builder {
        crate::model::lifecycle_rule_and_operator::Builder::default()
    }
}

/// <p>The container of the Outposts bucket lifecycle expiration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifecycleExpiration {
    /// <p>Indicates at what date the object is to be deleted. Should be in GMT ISO 8601 format.</p>
    pub date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Indicates the lifetime, in days, of the objects that are subject to the rule. The value must be a non-zero positive integer.</p>
    pub days: i32,
    /// <p>Indicates whether Amazon S3 will remove a delete marker with no noncurrent versions. If set to true, the delete marker will be expired. If set to false, the policy takes no action. This cannot be specified with Days or Date in a Lifecycle Expiration Policy.</p>
    pub expired_object_delete_marker: bool,
}
impl LifecycleExpiration {
    /// <p>Indicates at what date the object is to be deleted. Should be in GMT ISO 8601 format.</p>
    pub fn date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.date.as_ref()
    }
    /// <p>Indicates the lifetime, in days, of the objects that are subject to the rule. The value must be a non-zero positive integer.</p>
    pub fn days(&self) -> i32 {
        self.days
    }
    /// <p>Indicates whether Amazon S3 will remove a delete marker with no noncurrent versions. If set to true, the delete marker will be expired. If set to false, the policy takes no action. This cannot be specified with Days or Date in a Lifecycle Expiration Policy.</p>
    pub fn expired_object_delete_marker(&self) -> bool {
        self.expired_object_delete_marker
    }
}
impl std::fmt::Debug for LifecycleExpiration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifecycleExpiration");
        formatter.field("date", &self.date);
        formatter.field("days", &self.days);
        formatter.field(
            "expired_object_delete_marker",
            &self.expired_object_delete_marker,
        );
        formatter.finish()
    }
}
/// See [`LifecycleExpiration`](crate::model::LifecycleExpiration)
pub mod lifecycle_expiration {
    /// A builder for [`LifecycleExpiration`](crate::model::LifecycleExpiration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) days: std::option::Option<i32>,
        pub(crate) expired_object_delete_marker: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Indicates at what date the object is to be deleted. Should be in GMT ISO 8601 format.</p>
        pub fn date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.date = Some(input);
            self
        }
        /// <p>Indicates at what date the object is to be deleted. Should be in GMT ISO 8601 format.</p>
        pub fn set_date(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.date = input;
            self
        }
        /// <p>Indicates the lifetime, in days, of the objects that are subject to the rule. The value must be a non-zero positive integer.</p>
        pub fn days(mut self, input: i32) -> Self {
            self.days = Some(input);
            self
        }
        /// <p>Indicates the lifetime, in days, of the objects that are subject to the rule. The value must be a non-zero positive integer.</p>
        pub fn set_days(mut self, input: std::option::Option<i32>) -> Self {
            self.days = input;
            self
        }
        /// <p>Indicates whether Amazon S3 will remove a delete marker with no noncurrent versions. If set to true, the delete marker will be expired. If set to false, the policy takes no action. This cannot be specified with Days or Date in a Lifecycle Expiration Policy.</p>
        pub fn expired_object_delete_marker(mut self, input: bool) -> Self {
            self.expired_object_delete_marker = Some(input);
            self
        }
        /// <p>Indicates whether Amazon S3 will remove a delete marker with no noncurrent versions. If set to true, the delete marker will be expired. If set to false, the policy takes no action. This cannot be specified with Days or Date in a Lifecycle Expiration Policy.</p>
        pub fn set_expired_object_delete_marker(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.expired_object_delete_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`LifecycleExpiration`](crate::model::LifecycleExpiration)
        pub fn build(self) -> crate::model::LifecycleExpiration {
            crate::model::LifecycleExpiration {
                date: self.date,
                days: self.days.unwrap_or_default(),
                expired_object_delete_marker: self.expired_object_delete_marker.unwrap_or_default(),
            }
        }
    }
}
impl LifecycleExpiration {
    /// Creates a new builder-style object to manufacture [`LifecycleExpiration`](crate::model::LifecycleExpiration)
    pub fn builder() -> crate::model::lifecycle_expiration::Builder {
        crate::model::lifecycle_expiration::Builder::default()
    }
}

/// <p>A configuration used when creating an Object Lambda Access Point.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ObjectLambdaConfiguration {
    /// <p>Standard access point associated with the Object Lambda Access Point.</p>
    pub supporting_access_point: std::option::Option<std::string::String>,
    /// <p>A container for whether the CloudWatch metrics configuration is enabled.</p>
    pub cloud_watch_metrics_enabled: bool,
    /// <p>A container for allowed features. Valid inputs are <code>GetObject-Range</code> and <code>GetObject-PartNumber</code>.</p>
    pub allowed_features:
        std::option::Option<std::vec::Vec<crate::model::ObjectLambdaAllowedFeature>>,
    /// <p>A container for transformation configurations for an Object Lambda Access Point.</p>
    pub transformation_configurations:
        std::option::Option<std::vec::Vec<crate::model::ObjectLambdaTransformationConfiguration>>,
}
impl ObjectLambdaConfiguration {
    /// <p>Standard access point associated with the Object Lambda Access Point.</p>
    pub fn supporting_access_point(&self) -> std::option::Option<&str> {
        self.supporting_access_point.as_deref()
    }
    /// <p>A container for whether the CloudWatch metrics configuration is enabled.</p>
    pub fn cloud_watch_metrics_enabled(&self) -> bool {
        self.cloud_watch_metrics_enabled
    }
    /// <p>A container for allowed features. Valid inputs are <code>GetObject-Range</code> and <code>GetObject-PartNumber</code>.</p>
    pub fn allowed_features(
        &self,
    ) -> std::option::Option<&[crate::model::ObjectLambdaAllowedFeature]> {
        self.allowed_features.as_deref()
    }
    /// <p>A container for transformation configurations for an Object Lambda Access Point.</p>
    pub fn transformation_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::ObjectLambdaTransformationConfiguration]> {
        self.transformation_configurations.as_deref()
    }
}
impl std::fmt::Debug for ObjectLambdaConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ObjectLambdaConfiguration");
        formatter.field("supporting_access_point", &self.supporting_access_point);
        formatter.field(
            "cloud_watch_metrics_enabled",
            &self.cloud_watch_metrics_enabled,
        );
        formatter.field("allowed_features", &self.allowed_features);
        formatter.field(
            "transformation_configurations",
            &self.transformation_configurations,
        );
        formatter.finish()
    }
}
/// See [`ObjectLambdaConfiguration`](crate::model::ObjectLambdaConfiguration)
pub mod object_lambda_configuration {
    /// A builder for [`ObjectLambdaConfiguration`](crate::model::ObjectLambdaConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) supporting_access_point: std::option::Option<std::string::String>,
        pub(crate) cloud_watch_metrics_enabled: std::option::Option<bool>,
        pub(crate) allowed_features:
            std::option::Option<std::vec::Vec<crate::model::ObjectLambdaAllowedFeature>>,
        pub(crate) transformation_configurations: std::option::Option<
            std::vec::Vec<crate::model::ObjectLambdaTransformationConfiguration>,
        >,
    }
    impl Builder {
        /// <p>Standard access point associated with the Object Lambda Access Point.</p>
        pub fn supporting_access_point(mut self, input: impl Into<std::string::String>) -> Self {
            self.supporting_access_point = Some(input.into());
            self
        }
        /// <p>Standard access point associated with the Object Lambda Access Point.</p>
        pub fn set_supporting_access_point(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.supporting_access_point = input;
            self
        }
        /// <p>A container for whether the CloudWatch metrics configuration is enabled.</p>
        pub fn cloud_watch_metrics_enabled(mut self, input: bool) -> Self {
            self.cloud_watch_metrics_enabled = Some(input);
            self
        }
        /// <p>A container for whether the CloudWatch metrics configuration is enabled.</p>
        pub fn set_cloud_watch_metrics_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.cloud_watch_metrics_enabled = input;
            self
        }
        /// Appends an item to `allowed_features`.
        ///
        /// To override the contents of this collection use [`set_allowed_features`](Self::set_allowed_features).
        ///
        /// <p>A container for allowed features. Valid inputs are <code>GetObject-Range</code> and <code>GetObject-PartNumber</code>.</p>
        pub fn allowed_features(mut self, input: crate::model::ObjectLambdaAllowedFeature) -> Self {
            let mut v = self.allowed_features.unwrap_or_default();
            v.push(input);
            self.allowed_features = Some(v);
            self
        }
        /// <p>A container for allowed features. Valid inputs are <code>GetObject-Range</code> and <code>GetObject-PartNumber</code>.</p>
        pub fn set_allowed_features(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ObjectLambdaAllowedFeature>>,
        ) -> Self {
            self.allowed_features = input;
            self
        }
        /// Appends an item to `transformation_configurations`.
        ///
        /// To override the contents of this collection use [`set_transformation_configurations`](Self::set_transformation_configurations).
        ///
        /// <p>A container for transformation configurations for an Object Lambda Access Point.</p>
        pub fn transformation_configurations(
            mut self,
            input: crate::model::ObjectLambdaTransformationConfiguration,
        ) -> Self {
            let mut v = self.transformation_configurations.unwrap_or_default();
            v.push(input);
            self.transformation_configurations = Some(v);
            self
        }
        /// <p>A container for transformation configurations for an Object Lambda Access Point.</p>
        pub fn set_transformation_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ObjectLambdaTransformationConfiguration>,
            >,
        ) -> Self {
            self.transformation_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`ObjectLambdaConfiguration`](crate::model::ObjectLambdaConfiguration)
        pub fn build(self) -> crate::model::ObjectLambdaConfiguration {
            crate::model::ObjectLambdaConfiguration {
                supporting_access_point: self.supporting_access_point,
                cloud_watch_metrics_enabled: self.cloud_watch_metrics_enabled.unwrap_or_default(),
                allowed_features: self.allowed_features,
                transformation_configurations: self.transformation_configurations,
            }
        }
    }
}
impl ObjectLambdaConfiguration {
    /// Creates a new builder-style object to manufacture [`ObjectLambdaConfiguration`](crate::model::ObjectLambdaConfiguration)
    pub fn builder() -> crate::model::object_lambda_configuration::Builder {
        crate::model::object_lambda_configuration::Builder::default()
    }
}

/// <p>A configuration used when creating an Object Lambda Access Point transformation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ObjectLambdaTransformationConfiguration {
    /// <p>A container for the action of an Object Lambda Access Point configuration. Valid input is <code>GetObject</code>.</p>
    pub actions: std::option::Option<
        std::vec::Vec<crate::model::ObjectLambdaTransformationConfigurationAction>,
    >,
    /// <p>A container for the content transformation of an Object Lambda Access Point configuration.</p>
    pub content_transformation:
        std::option::Option<crate::model::ObjectLambdaContentTransformation>,
}
impl ObjectLambdaTransformationConfiguration {
    /// <p>A container for the action of an Object Lambda Access Point configuration. Valid input is <code>GetObject</code>.</p>
    pub fn actions(
        &self,
    ) -> std::option::Option<&[crate::model::ObjectLambdaTransformationConfigurationAction]> {
        self.actions.as_deref()
    }
    /// <p>A container for the content transformation of an Object Lambda Access Point configuration.</p>
    pub fn content_transformation(
        &self,
    ) -> std::option::Option<&crate::model::ObjectLambdaContentTransformation> {
        self.content_transformation.as_ref()
    }
}
impl std::fmt::Debug for ObjectLambdaTransformationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ObjectLambdaTransformationConfiguration");
        formatter.field("actions", &self.actions);
        formatter.field("content_transformation", &self.content_transformation);
        formatter.finish()
    }
}
/// See [`ObjectLambdaTransformationConfiguration`](crate::model::ObjectLambdaTransformationConfiguration)
pub mod object_lambda_transformation_configuration {
    /// A builder for [`ObjectLambdaTransformationConfiguration`](crate::model::ObjectLambdaTransformationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) actions: std::option::Option<
            std::vec::Vec<crate::model::ObjectLambdaTransformationConfigurationAction>,
        >,
        pub(crate) content_transformation:
            std::option::Option<crate::model::ObjectLambdaContentTransformation>,
    }
    impl Builder {
        /// Appends an item to `actions`.
        ///
        /// To override the contents of this collection use [`set_actions`](Self::set_actions).
        ///
        /// <p>A container for the action of an Object Lambda Access Point configuration. Valid input is <code>GetObject</code>.</p>
        pub fn actions(
            mut self,
            input: crate::model::ObjectLambdaTransformationConfigurationAction,
        ) -> Self {
            let mut v = self.actions.unwrap_or_default();
            v.push(input);
            self.actions = Some(v);
            self
        }
        /// <p>A container for the action of an Object Lambda Access Point configuration. Valid input is <code>GetObject</code>.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ObjectLambdaTransformationConfigurationAction>,
            >,
        ) -> Self {
            self.actions = input;
            self
        }
        /// <p>A container for the content transformation of an Object Lambda Access Point configuration.</p>
        pub fn content_transformation(
            mut self,
            input: crate::model::ObjectLambdaContentTransformation,
        ) -> Self {
            self.content_transformation = Some(input);
            self
        }
        /// <p>A container for the content transformation of an Object Lambda Access Point configuration.</p>
        pub fn set_content_transformation(
            mut self,
            input: std::option::Option<crate::model::ObjectLambdaContentTransformation>,
        ) -> Self {
            self.content_transformation = input;
            self
        }
        /// Consumes the builder and constructs a [`ObjectLambdaTransformationConfiguration`](crate::model::ObjectLambdaTransformationConfiguration)
        pub fn build(self) -> crate::model::ObjectLambdaTransformationConfiguration {
            crate::model::ObjectLambdaTransformationConfiguration {
                actions: self.actions,
                content_transformation: self.content_transformation,
            }
        }
    }
}
impl ObjectLambdaTransformationConfiguration {
    /// Creates a new builder-style object to manufacture [`ObjectLambdaTransformationConfiguration`](crate::model::ObjectLambdaTransformationConfiguration)
    pub fn builder() -> crate::model::object_lambda_transformation_configuration::Builder {
        crate::model::object_lambda_transformation_configuration::Builder::default()
    }
}

/// <p>A container for AwsLambdaTransformation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum ObjectLambdaContentTransformation {
    /// <p>A container for an Lambda function.</p>
    AwsLambda(crate::model::AwsLambdaTransformation),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl ObjectLambdaContentTransformation {
    #[allow(irrefutable_let_patterns)]
    /// Tries to convert the enum instance into [`AwsLambda`](crate::model::ObjectLambdaContentTransformation::AwsLambda), extracting the inner [`AwsLambdaTransformation`](crate::model::AwsLambdaTransformation).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_aws_lambda(
        &self,
    ) -> std::result::Result<&crate::model::AwsLambdaTransformation, &Self> {
        if let ObjectLambdaContentTransformation::AwsLambda(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`AwsLambda`](crate::model::ObjectLambdaContentTransformation::AwsLambda).
    pub fn is_aws_lambda(&self) -> bool {
        self.as_aws_lambda().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>Lambda function used to transform objects through an Object Lambda Access Point.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsLambdaTransformation {
    /// <p>The Amazon Resource Name (ARN) of the Lambda function.</p>
    pub function_arn: std::option::Option<std::string::String>,
    /// <p>Additional JSON that provides supplemental data to the Lambda function used to transform objects.</p>
    pub function_payload: std::option::Option<std::string::String>,
}
impl AwsLambdaTransformation {
    /// <p>The Amazon Resource Name (ARN) of the Lambda function.</p>
    pub fn function_arn(&self) -> std::option::Option<&str> {
        self.function_arn.as_deref()
    }
    /// <p>Additional JSON that provides supplemental data to the Lambda function used to transform objects.</p>
    pub fn function_payload(&self) -> std::option::Option<&str> {
        self.function_payload.as_deref()
    }
}
impl std::fmt::Debug for AwsLambdaTransformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsLambdaTransformation");
        formatter.field("function_arn", &self.function_arn);
        formatter.field("function_payload", &self.function_payload);
        formatter.finish()
    }
}
/// See [`AwsLambdaTransformation`](crate::model::AwsLambdaTransformation)
pub mod aws_lambda_transformation {
    /// A builder for [`AwsLambdaTransformation`](crate::model::AwsLambdaTransformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_arn: std::option::Option<std::string::String>,
        pub(crate) function_payload: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Lambda function.</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Lambda function.</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_arn = input;
            self
        }
        /// <p>Additional JSON that provides supplemental data to the Lambda function used to transform objects.</p>
        pub fn function_payload(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_payload = Some(input.into());
            self
        }
        /// <p>Additional JSON that provides supplemental data to the Lambda function used to transform objects.</p>
        pub fn set_function_payload(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_payload = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsLambdaTransformation`](crate::model::AwsLambdaTransformation)
        pub fn build(self) -> crate::model::AwsLambdaTransformation {
            crate::model::AwsLambdaTransformation {
                function_arn: self.function_arn,
                function_payload: self.function_payload,
            }
        }
    }
}
impl AwsLambdaTransformation {
    /// Creates a new builder-style object to manufacture [`AwsLambdaTransformation`](crate::model::AwsLambdaTransformation)
    pub fn builder() -> crate::model::aws_lambda_transformation::Builder {
        crate::model::aws_lambda_transformation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ObjectLambdaTransformationConfigurationAction {
    #[allow(missing_docs)] // documentation missing in model
    GetObject,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ObjectLambdaTransformationConfigurationAction {
    fn from(s: &str) -> Self {
        match s {
            "GetObject" => ObjectLambdaTransformationConfigurationAction::GetObject,
            other => ObjectLambdaTransformationConfigurationAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ObjectLambdaTransformationConfigurationAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ObjectLambdaTransformationConfigurationAction::from(s))
    }
}
impl ObjectLambdaTransformationConfigurationAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ObjectLambdaTransformationConfigurationAction::GetObject => "GetObject",
            ObjectLambdaTransformationConfigurationAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GetObject"]
    }
}
impl AsRef<str> for ObjectLambdaTransformationConfigurationAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ObjectLambdaAllowedFeature {
    #[allow(missing_docs)] // documentation missing in model
    GetObjectPartNumber,
    #[allow(missing_docs)] // documentation missing in model
    GetObjectRange,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ObjectLambdaAllowedFeature {
    fn from(s: &str) -> Self {
        match s {
            "GetObject-PartNumber" => ObjectLambdaAllowedFeature::GetObjectPartNumber,
            "GetObject-Range" => ObjectLambdaAllowedFeature::GetObjectRange,
            other => ObjectLambdaAllowedFeature::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ObjectLambdaAllowedFeature {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ObjectLambdaAllowedFeature::from(s))
    }
}
impl ObjectLambdaAllowedFeature {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ObjectLambdaAllowedFeature::GetObjectPartNumber => "GetObject-PartNumber",
            ObjectLambdaAllowedFeature::GetObjectRange => "GetObject-Range",
            ObjectLambdaAllowedFeature::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GetObject-PartNumber", "GetObject-Range"]
    }
}
impl AsRef<str> for ObjectLambdaAllowedFeature {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Part of <code>ListStorageLensConfigurationResult</code>. Each entry includes the description of the S3 Storage Lens configuration, its home Region, whether it is enabled, its Amazon Resource Name (ARN), and config ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStorageLensConfigurationEntry {
    /// <p>A container for the S3 Storage Lens configuration ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ARN of the S3 Storage Lens configuration. This property is read-only.</p>
    pub storage_lens_arn: std::option::Option<std::string::String>,
    /// <p>A container for the S3 Storage Lens home Region. Your metrics data is stored and retained in your designated S3 Storage Lens home Region.</p>
    pub home_region: std::option::Option<std::string::String>,
    /// <p>A container for whether the S3 Storage Lens configuration is enabled. This property is required.</p>
    pub is_enabled: bool,
}
impl ListStorageLensConfigurationEntry {
    /// <p>A container for the S3 Storage Lens configuration ID.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ARN of the S3 Storage Lens configuration. This property is read-only.</p>
    pub fn storage_lens_arn(&self) -> std::option::Option<&str> {
        self.storage_lens_arn.as_deref()
    }
    /// <p>A container for the S3 Storage Lens home Region. Your metrics data is stored and retained in your designated S3 Storage Lens home Region.</p>
    pub fn home_region(&self) -> std::option::Option<&str> {
        self.home_region.as_deref()
    }
    /// <p>A container for whether the S3 Storage Lens configuration is enabled. This property is required.</p>
    pub fn is_enabled(&self) -> bool {
        self.is_enabled
    }
}
impl std::fmt::Debug for ListStorageLensConfigurationEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStorageLensConfigurationEntry");
        formatter.field("id", &self.id);
        formatter.field("storage_lens_arn", &self.storage_lens_arn);
        formatter.field("home_region", &self.home_region);
        formatter.field("is_enabled", &self.is_enabled);
        formatter.finish()
    }
}
/// See [`ListStorageLensConfigurationEntry`](crate::model::ListStorageLensConfigurationEntry)
pub mod list_storage_lens_configuration_entry {
    /// A builder for [`ListStorageLensConfigurationEntry`](crate::model::ListStorageLensConfigurationEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) storage_lens_arn: std::option::Option<std::string::String>,
        pub(crate) home_region: std::option::Option<std::string::String>,
        pub(crate) is_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A container for the S3 Storage Lens configuration ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>A container for the S3 Storage Lens configuration ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ARN of the S3 Storage Lens configuration. This property is read-only.</p>
        pub fn storage_lens_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_lens_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the S3 Storage Lens configuration. This property is read-only.</p>
        pub fn set_storage_lens_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.storage_lens_arn = input;
            self
        }
        /// <p>A container for the S3 Storage Lens home Region. Your metrics data is stored and retained in your designated S3 Storage Lens home Region.</p>
        pub fn home_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.home_region = Some(input.into());
            self
        }
        /// <p>A container for the S3 Storage Lens home Region. Your metrics data is stored and retained in your designated S3 Storage Lens home Region.</p>
        pub fn set_home_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.home_region = input;
            self
        }
        /// <p>A container for whether the S3 Storage Lens configuration is enabled. This property is required.</p>
        pub fn is_enabled(mut self, input: bool) -> Self {
            self.is_enabled = Some(input);
            self
        }
        /// <p>A container for whether the S3 Storage Lens configuration is enabled. This property is required.</p>
        pub fn set_is_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.is_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStorageLensConfigurationEntry`](crate::model::ListStorageLensConfigurationEntry)
        pub fn build(self) -> crate::model::ListStorageLensConfigurationEntry {
            crate::model::ListStorageLensConfigurationEntry {
                id: self.id,
                storage_lens_arn: self.storage_lens_arn,
                home_region: self.home_region,
                is_enabled: self.is_enabled.unwrap_or_default(),
            }
        }
    }
}
impl ListStorageLensConfigurationEntry {
    /// Creates a new builder-style object to manufacture [`ListStorageLensConfigurationEntry`](crate::model::ListStorageLensConfigurationEntry)
    pub fn builder() -> crate::model::list_storage_lens_configuration_entry::Builder {
        crate::model::list_storage_lens_configuration_entry::Builder::default()
    }
}

/// <p>The container for the regional bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegionalBucket {
    /// <p></p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the regional bucket.</p>
    pub bucket_arn: std::option::Option<std::string::String>,
    /// <p></p>
    pub public_access_block_enabled: bool,
    /// <p>The creation date of the regional bucket</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Outposts ID of the regional bucket.</p>
    pub outpost_id: std::option::Option<std::string::String>,
}
impl RegionalBucket {
    /// <p></p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the regional bucket.</p>
    pub fn bucket_arn(&self) -> std::option::Option<&str> {
        self.bucket_arn.as_deref()
    }
    /// <p></p>
    pub fn public_access_block_enabled(&self) -> bool {
        self.public_access_block_enabled
    }
    /// <p>The creation date of the regional bucket</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The Outposts ID of the regional bucket.</p>
    pub fn outpost_id(&self) -> std::option::Option<&str> {
        self.outpost_id.as_deref()
    }
}
impl std::fmt::Debug for RegionalBucket {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegionalBucket");
        formatter.field("bucket", &self.bucket);
        formatter.field("bucket_arn", &self.bucket_arn);
        formatter.field(
            "public_access_block_enabled",
            &self.public_access_block_enabled,
        );
        formatter.field("creation_date", &self.creation_date);
        formatter.field("outpost_id", &self.outpost_id);
        formatter.finish()
    }
}
/// See [`RegionalBucket`](crate::model::RegionalBucket)
pub mod regional_bucket {
    /// A builder for [`RegionalBucket`](crate::model::RegionalBucket)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) bucket_arn: std::option::Option<std::string::String>,
        pub(crate) public_access_block_enabled: std::option::Option<bool>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) outpost_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the regional bucket.</p>
        pub fn bucket_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the regional bucket.</p>
        pub fn set_bucket_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_arn = input;
            self
        }
        /// <p></p>
        pub fn public_access_block_enabled(mut self, input: bool) -> Self {
            self.public_access_block_enabled = Some(input);
            self
        }
        /// <p></p>
        pub fn set_public_access_block_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.public_access_block_enabled = input;
            self
        }
        /// <p>The creation date of the regional bucket</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The creation date of the regional bucket</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The Outposts ID of the regional bucket.</p>
        pub fn outpost_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.outpost_id = Some(input.into());
            self
        }
        /// <p>The Outposts ID of the regional bucket.</p>
        pub fn set_outpost_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.outpost_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RegionalBucket`](crate::model::RegionalBucket)
        pub fn build(self) -> crate::model::RegionalBucket {
            crate::model::RegionalBucket {
                bucket: self.bucket,
                bucket_arn: self.bucket_arn,
                public_access_block_enabled: self.public_access_block_enabled.unwrap_or_default(),
                creation_date: self.creation_date,
                outpost_id: self.outpost_id,
            }
        }
    }
}
impl RegionalBucket {
    /// Creates a new builder-style object to manufacture [`RegionalBucket`](crate::model::RegionalBucket)
    pub fn builder() -> crate::model::regional_bucket::Builder {
        crate::model::regional_bucket::Builder::default()
    }
}

/// <p>A collection of statuses for a Multi-Region Access Point in the various Regions it supports.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MultiRegionAccessPointReport {
    /// <p>The name of the Multi-Region Access Point.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The alias for the Multi-Region Access Point. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a>.</p>
    pub alias: std::option::Option<std::string::String>,
    /// <p>When the Multi-Region Access Point create request was received.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The <code>PublicAccessBlock</code> configuration that you want to apply to this Amazon S3 account. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>This is not supported for Amazon S3 on Outposts.</p>
    pub public_access_block: std::option::Option<crate::model::PublicAccessBlockConfiguration>,
    /// <p>The current status of the Multi-Region Access Point.</p>
    /// <p> <code>CREATING</code> and <code>DELETING</code> are temporary states that exist while the request is propogating and being completed. If a Multi-Region Access Point has a status of <code>PARTIALLY_CREATED</code>, you can retry creation or send a request to delete the Multi-Region Access Point. If a Multi-Region Access Point has a status of <code>PARTIALLY_DELETED</code>, you can retry a delete request to finish the deletion of the Multi-Region Access Point.</p>
    pub status: std::option::Option<crate::model::MultiRegionAccessPointStatus>,
    /// <p>A collection of the Regions and buckets associated with the Multi-Region Access Point.</p>
    pub regions: std::option::Option<std::vec::Vec<crate::model::RegionReport>>,
}
impl MultiRegionAccessPointReport {
    /// <p>The name of the Multi-Region Access Point.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The alias for the Multi-Region Access Point. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a>.</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
    /// <p>When the Multi-Region Access Point create request was received.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The <code>PublicAccessBlock</code> configuration that you want to apply to this Amazon S3 account. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>This is not supported for Amazon S3 on Outposts.</p>
    pub fn public_access_block(
        &self,
    ) -> std::option::Option<&crate::model::PublicAccessBlockConfiguration> {
        self.public_access_block.as_ref()
    }
    /// <p>The current status of the Multi-Region Access Point.</p>
    /// <p> <code>CREATING</code> and <code>DELETING</code> are temporary states that exist while the request is propogating and being completed. If a Multi-Region Access Point has a status of <code>PARTIALLY_CREATED</code>, you can retry creation or send a request to delete the Multi-Region Access Point. If a Multi-Region Access Point has a status of <code>PARTIALLY_DELETED</code>, you can retry a delete request to finish the deletion of the Multi-Region Access Point.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::MultiRegionAccessPointStatus> {
        self.status.as_ref()
    }
    /// <p>A collection of the Regions and buckets associated with the Multi-Region Access Point.</p>
    pub fn regions(&self) -> std::option::Option<&[crate::model::RegionReport]> {
        self.regions.as_deref()
    }
}
impl std::fmt::Debug for MultiRegionAccessPointReport {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MultiRegionAccessPointReport");
        formatter.field("name", &self.name);
        formatter.field("alias", &self.alias);
        formatter.field("created_at", &self.created_at);
        formatter.field("public_access_block", &self.public_access_block);
        formatter.field("status", &self.status);
        formatter.field("regions", &self.regions);
        formatter.finish()
    }
}
/// See [`MultiRegionAccessPointReport`](crate::model::MultiRegionAccessPointReport)
pub mod multi_region_access_point_report {
    /// A builder for [`MultiRegionAccessPointReport`](crate::model::MultiRegionAccessPointReport)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) alias: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) public_access_block:
            std::option::Option<crate::model::PublicAccessBlockConfiguration>,
        pub(crate) status: std::option::Option<crate::model::MultiRegionAccessPointStatus>,
        pub(crate) regions: std::option::Option<std::vec::Vec<crate::model::RegionReport>>,
    }
    impl Builder {
        /// <p>The name of the Multi-Region Access Point.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Multi-Region Access Point.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The alias for the Multi-Region Access Point. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a>.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The alias for the Multi-Region Access Point. For more information about the distinction between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a>.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// <p>When the Multi-Region Access Point create request was received.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>When the Multi-Region Access Point create request was received.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The <code>PublicAccessBlock</code> configuration that you want to apply to this Amazon S3 account. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>This is not supported for Amazon S3 on Outposts.</p>
        pub fn public_access_block(
            mut self,
            input: crate::model::PublicAccessBlockConfiguration,
        ) -> Self {
            self.public_access_block = Some(input);
            self
        }
        /// <p>The <code>PublicAccessBlock</code> configuration that you want to apply to this Amazon S3 account. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>This is not supported for Amazon S3 on Outposts.</p>
        pub fn set_public_access_block(
            mut self,
            input: std::option::Option<crate::model::PublicAccessBlockConfiguration>,
        ) -> Self {
            self.public_access_block = input;
            self
        }
        /// <p>The current status of the Multi-Region Access Point.</p>
        /// <p> <code>CREATING</code> and <code>DELETING</code> are temporary states that exist while the request is propogating and being completed. If a Multi-Region Access Point has a status of <code>PARTIALLY_CREATED</code>, you can retry creation or send a request to delete the Multi-Region Access Point. If a Multi-Region Access Point has a status of <code>PARTIALLY_DELETED</code>, you can retry a delete request to finish the deletion of the Multi-Region Access Point.</p>
        pub fn status(mut self, input: crate::model::MultiRegionAccessPointStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the Multi-Region Access Point.</p>
        /// <p> <code>CREATING</code> and <code>DELETING</code> are temporary states that exist while the request is propogating and being completed. If a Multi-Region Access Point has a status of <code>PARTIALLY_CREATED</code>, you can retry creation or send a request to delete the Multi-Region Access Point. If a Multi-Region Access Point has a status of <code>PARTIALLY_DELETED</code>, you can retry a delete request to finish the deletion of the Multi-Region Access Point.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::MultiRegionAccessPointStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `regions`.
        ///
        /// To override the contents of this collection use [`set_regions`](Self::set_regions).
        ///
        /// <p>A collection of the Regions and buckets associated with the Multi-Region Access Point.</p>
        pub fn regions(mut self, input: crate::model::RegionReport) -> Self {
            let mut v = self.regions.unwrap_or_default();
            v.push(input);
            self.regions = Some(v);
            self
        }
        /// <p>A collection of the Regions and buckets associated with the Multi-Region Access Point.</p>
        pub fn set_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RegionReport>>,
        ) -> Self {
            self.regions = input;
            self
        }
        /// Consumes the builder and constructs a [`MultiRegionAccessPointReport`](crate::model::MultiRegionAccessPointReport)
        pub fn build(self) -> crate::model::MultiRegionAccessPointReport {
            crate::model::MultiRegionAccessPointReport {
                name: self.name,
                alias: self.alias,
                created_at: self.created_at,
                public_access_block: self.public_access_block,
                status: self.status,
                regions: self.regions,
            }
        }
    }
}
impl MultiRegionAccessPointReport {
    /// Creates a new builder-style object to manufacture [`MultiRegionAccessPointReport`](crate::model::MultiRegionAccessPointReport)
    pub fn builder() -> crate::model::multi_region_access_point_report::Builder {
        crate::model::multi_region_access_point_report::Builder::default()
    }
}

/// <p>A combination of a bucket and Region that's part of a Multi-Region Access Point.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegionReport {
    /// <p>The name of the bucket.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The name of the Region.</p>
    pub region: std::option::Option<std::string::String>,
}
impl RegionReport {
    /// <p>The name of the bucket.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The name of the Region.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
}
impl std::fmt::Debug for RegionReport {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegionReport");
        formatter.field("bucket", &self.bucket);
        formatter.field("region", &self.region);
        formatter.finish()
    }
}
/// See [`RegionReport`](crate::model::RegionReport)
pub mod region_report {
    /// A builder for [`RegionReport`](crate::model::RegionReport)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The name of the Region.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The name of the Region.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// Consumes the builder and constructs a [`RegionReport`](crate::model::RegionReport)
        pub fn build(self) -> crate::model::RegionReport {
            crate::model::RegionReport {
                bucket: self.bucket,
                region: self.region,
            }
        }
    }
}
impl RegionReport {
    /// Creates a new builder-style object to manufacture [`RegionReport`](crate::model::RegionReport)
    pub fn builder() -> crate::model::region_report::Builder {
        crate::model::region_report::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MultiRegionAccessPointStatus {
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    InconsistentAcrossRegions,
    #[allow(missing_docs)] // documentation missing in model
    PartiallyCreated,
    #[allow(missing_docs)] // documentation missing in model
    PartiallyDeleted,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MultiRegionAccessPointStatus {
    fn from(s: &str) -> Self {
        match s {
            "CREATING" => MultiRegionAccessPointStatus::Creating,
            "DELETING" => MultiRegionAccessPointStatus::Deleting,
            "INCONSISTENT_ACROSS_REGIONS" => {
                MultiRegionAccessPointStatus::InconsistentAcrossRegions
            }
            "PARTIALLY_CREATED" => MultiRegionAccessPointStatus::PartiallyCreated,
            "PARTIALLY_DELETED" => MultiRegionAccessPointStatus::PartiallyDeleted,
            "READY" => MultiRegionAccessPointStatus::Ready,
            other => MultiRegionAccessPointStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MultiRegionAccessPointStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MultiRegionAccessPointStatus::from(s))
    }
}
impl MultiRegionAccessPointStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MultiRegionAccessPointStatus::Creating => "CREATING",
            MultiRegionAccessPointStatus::Deleting => "DELETING",
            MultiRegionAccessPointStatus::InconsistentAcrossRegions => {
                "INCONSISTENT_ACROSS_REGIONS"
            }
            MultiRegionAccessPointStatus::PartiallyCreated => "PARTIALLY_CREATED",
            MultiRegionAccessPointStatus::PartiallyDeleted => "PARTIALLY_DELETED",
            MultiRegionAccessPointStatus::Ready => "READY",
            MultiRegionAccessPointStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATING",
            "DELETING",
            "INCONSISTENT_ACROSS_REGIONS",
            "PARTIALLY_CREATED",
            "PARTIALLY_DELETED",
            "READY",
        ]
    }
}
impl AsRef<str> for MultiRegionAccessPointStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the configuration and status information for a single job retrieved as part of a job list.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobListDescriptor {
    /// <p>The ID for the specified job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The user-specified description that was included in the specified job's <code>Create Job</code> request.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The operation that the specified job is configured to run on every object listed in the manifest.</p>
    pub operation: std::option::Option<crate::model::OperationName>,
    /// <p>The current priority for the specified job.</p>
    pub priority: i32,
    /// <p>The specified job's current status.</p>
    pub status: std::option::Option<crate::model::JobStatus>,
    /// <p>A timestamp indicating when the specified job was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp indicating when the specified job terminated. A job's termination date is the date and time when it succeeded, failed, or was canceled.</p>
    pub termination_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Describes the total number of tasks that the specified job has run, the number of tasks that succeeded, and the number of tasks that failed.</p>
    pub progress_summary: std::option::Option<crate::model::JobProgressSummary>,
}
impl JobListDescriptor {
    /// <p>The ID for the specified job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The user-specified description that was included in the specified job's <code>Create Job</code> request.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The operation that the specified job is configured to run on every object listed in the manifest.</p>
    pub fn operation(&self) -> std::option::Option<&crate::model::OperationName> {
        self.operation.as_ref()
    }
    /// <p>The current priority for the specified job.</p>
    pub fn priority(&self) -> i32 {
        self.priority
    }
    /// <p>The specified job's current status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.status.as_ref()
    }
    /// <p>A timestamp indicating when the specified job was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>A timestamp indicating when the specified job terminated. A job's termination date is the date and time when it succeeded, failed, or was canceled.</p>
    pub fn termination_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.termination_date.as_ref()
    }
    /// <p>Describes the total number of tasks that the specified job has run, the number of tasks that succeeded, and the number of tasks that failed.</p>
    pub fn progress_summary(&self) -> std::option::Option<&crate::model::JobProgressSummary> {
        self.progress_summary.as_ref()
    }
}
impl std::fmt::Debug for JobListDescriptor {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobListDescriptor");
        formatter.field("job_id", &self.job_id);
        formatter.field("description", &self.description);
        formatter.field("operation", &self.operation);
        formatter.field("priority", &self.priority);
        formatter.field("status", &self.status);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("termination_date", &self.termination_date);
        formatter.field("progress_summary", &self.progress_summary);
        formatter.finish()
    }
}
/// See [`JobListDescriptor`](crate::model::JobListDescriptor)
pub mod job_list_descriptor {
    /// A builder for [`JobListDescriptor`](crate::model::JobListDescriptor)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) operation: std::option::Option<crate::model::OperationName>,
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) status: std::option::Option<crate::model::JobStatus>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) termination_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) progress_summary: std::option::Option<crate::model::JobProgressSummary>,
    }
    impl Builder {
        /// <p>The ID for the specified job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for the specified job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The user-specified description that was included in the specified job's <code>Create Job</code> request.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The user-specified description that was included in the specified job's <code>Create Job</code> request.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The operation that the specified job is configured to run on every object listed in the manifest.</p>
        pub fn operation(mut self, input: crate::model::OperationName) -> Self {
            self.operation = Some(input);
            self
        }
        /// <p>The operation that the specified job is configured to run on every object listed in the manifest.</p>
        pub fn set_operation(
            mut self,
            input: std::option::Option<crate::model::OperationName>,
        ) -> Self {
            self.operation = input;
            self
        }
        /// <p>The current priority for the specified job.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The current priority for the specified job.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// <p>The specified job's current status.</p>
        pub fn status(mut self, input: crate::model::JobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The specified job's current status.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::JobStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>A timestamp indicating when the specified job was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A timestamp indicating when the specified job was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>A timestamp indicating when the specified job terminated. A job's termination date is the date and time when it succeeded, failed, or was canceled.</p>
        pub fn termination_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.termination_date = Some(input);
            self
        }
        /// <p>A timestamp indicating when the specified job terminated. A job's termination date is the date and time when it succeeded, failed, or was canceled.</p>
        pub fn set_termination_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.termination_date = input;
            self
        }
        /// <p>Describes the total number of tasks that the specified job has run, the number of tasks that succeeded, and the number of tasks that failed.</p>
        pub fn progress_summary(mut self, input: crate::model::JobProgressSummary) -> Self {
            self.progress_summary = Some(input);
            self
        }
        /// <p>Describes the total number of tasks that the specified job has run, the number of tasks that succeeded, and the number of tasks that failed.</p>
        pub fn set_progress_summary(
            mut self,
            input: std::option::Option<crate::model::JobProgressSummary>,
        ) -> Self {
            self.progress_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`JobListDescriptor`](crate::model::JobListDescriptor)
        pub fn build(self) -> crate::model::JobListDescriptor {
            crate::model::JobListDescriptor {
                job_id: self.job_id,
                description: self.description,
                operation: self.operation,
                priority: self.priority.unwrap_or_default(),
                status: self.status,
                creation_time: self.creation_time,
                termination_date: self.termination_date,
                progress_summary: self.progress_summary,
            }
        }
    }
}
impl JobListDescriptor {
    /// Creates a new builder-style object to manufacture [`JobListDescriptor`](crate::model::JobListDescriptor)
    pub fn builder() -> crate::model::job_list_descriptor::Builder {
        crate::model::job_list_descriptor::Builder::default()
    }
}

/// <p>Describes the total number of tasks that the specified job has started, the number of tasks that succeeded, and the number of tasks that failed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobProgressSummary {
    /// <p></p>
    pub total_number_of_tasks: std::option::Option<i64>,
    /// <p></p>
    pub number_of_tasks_succeeded: std::option::Option<i64>,
    /// <p></p>
    pub number_of_tasks_failed: std::option::Option<i64>,
    /// <p>The JobTimers attribute of a job's progress summary.</p>
    pub timers: std::option::Option<crate::model::JobTimers>,
}
impl JobProgressSummary {
    /// <p></p>
    pub fn total_number_of_tasks(&self) -> std::option::Option<i64> {
        self.total_number_of_tasks
    }
    /// <p></p>
    pub fn number_of_tasks_succeeded(&self) -> std::option::Option<i64> {
        self.number_of_tasks_succeeded
    }
    /// <p></p>
    pub fn number_of_tasks_failed(&self) -> std::option::Option<i64> {
        self.number_of_tasks_failed
    }
    /// <p>The JobTimers attribute of a job's progress summary.</p>
    pub fn timers(&self) -> std::option::Option<&crate::model::JobTimers> {
        self.timers.as_ref()
    }
}
impl std::fmt::Debug for JobProgressSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobProgressSummary");
        formatter.field("total_number_of_tasks", &self.total_number_of_tasks);
        formatter.field("number_of_tasks_succeeded", &self.number_of_tasks_succeeded);
        formatter.field("number_of_tasks_failed", &self.number_of_tasks_failed);
        formatter.field("timers", &self.timers);
        formatter.finish()
    }
}
/// See [`JobProgressSummary`](crate::model::JobProgressSummary)
pub mod job_progress_summary {
    /// A builder for [`JobProgressSummary`](crate::model::JobProgressSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) total_number_of_tasks: std::option::Option<i64>,
        pub(crate) number_of_tasks_succeeded: std::option::Option<i64>,
        pub(crate) number_of_tasks_failed: std::option::Option<i64>,
        pub(crate) timers: std::option::Option<crate::model::JobTimers>,
    }
    impl Builder {
        /// <p></p>
        pub fn total_number_of_tasks(mut self, input: i64) -> Self {
            self.total_number_of_tasks = Some(input);
            self
        }
        /// <p></p>
        pub fn set_total_number_of_tasks(mut self, input: std::option::Option<i64>) -> Self {
            self.total_number_of_tasks = input;
            self
        }
        /// <p></p>
        pub fn number_of_tasks_succeeded(mut self, input: i64) -> Self {
            self.number_of_tasks_succeeded = Some(input);
            self
        }
        /// <p></p>
        pub fn set_number_of_tasks_succeeded(mut self, input: std::option::Option<i64>) -> Self {
            self.number_of_tasks_succeeded = input;
            self
        }
        /// <p></p>
        pub fn number_of_tasks_failed(mut self, input: i64) -> Self {
            self.number_of_tasks_failed = Some(input);
            self
        }
        /// <p></p>
        pub fn set_number_of_tasks_failed(mut self, input: std::option::Option<i64>) -> Self {
            self.number_of_tasks_failed = input;
            self
        }
        /// <p>The JobTimers attribute of a job's progress summary.</p>
        pub fn timers(mut self, input: crate::model::JobTimers) -> Self {
            self.timers = Some(input);
            self
        }
        /// <p>The JobTimers attribute of a job's progress summary.</p>
        pub fn set_timers(mut self, input: std::option::Option<crate::model::JobTimers>) -> Self {
            self.timers = input;
            self
        }
        /// Consumes the builder and constructs a [`JobProgressSummary`](crate::model::JobProgressSummary)
        pub fn build(self) -> crate::model::JobProgressSummary {
            crate::model::JobProgressSummary {
                total_number_of_tasks: self.total_number_of_tasks,
                number_of_tasks_succeeded: self.number_of_tasks_succeeded,
                number_of_tasks_failed: self.number_of_tasks_failed,
                timers: self.timers,
            }
        }
    }
}
impl JobProgressSummary {
    /// Creates a new builder-style object to manufacture [`JobProgressSummary`](crate::model::JobProgressSummary)
    pub fn builder() -> crate::model::job_progress_summary::Builder {
        crate::model::job_progress_summary::Builder::default()
    }
}

/// <p>Provides timing details for the job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobTimers {
    /// <p>Indicates the elapsed time in seconds the job has been in the Active job state.</p>
    pub elapsed_time_in_active_seconds: std::option::Option<i64>,
}
impl JobTimers {
    /// <p>Indicates the elapsed time in seconds the job has been in the Active job state.</p>
    pub fn elapsed_time_in_active_seconds(&self) -> std::option::Option<i64> {
        self.elapsed_time_in_active_seconds
    }
}
impl std::fmt::Debug for JobTimers {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobTimers");
        formatter.field(
            "elapsed_time_in_active_seconds",
            &self.elapsed_time_in_active_seconds,
        );
        formatter.finish()
    }
}
/// See [`JobTimers`](crate::model::JobTimers)
pub mod job_timers {
    /// A builder for [`JobTimers`](crate::model::JobTimers)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) elapsed_time_in_active_seconds: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Indicates the elapsed time in seconds the job has been in the Active job state.</p>
        pub fn elapsed_time_in_active_seconds(mut self, input: i64) -> Self {
            self.elapsed_time_in_active_seconds = Some(input);
            self
        }
        /// <p>Indicates the elapsed time in seconds the job has been in the Active job state.</p>
        pub fn set_elapsed_time_in_active_seconds(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.elapsed_time_in_active_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`JobTimers`](crate::model::JobTimers)
        pub fn build(self) -> crate::model::JobTimers {
            crate::model::JobTimers {
                elapsed_time_in_active_seconds: self.elapsed_time_in_active_seconds,
            }
        }
    }
}
impl JobTimers {
    /// Creates a new builder-style object to manufacture [`JobTimers`](crate::model::JobTimers)
    pub fn builder() -> crate::model::job_timers::Builder {
        crate::model::job_timers::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OperationName {
    #[allow(missing_docs)] // documentation missing in model
    LambdaInvoke,
    #[allow(missing_docs)] // documentation missing in model
    S3DeleteObjectTagging,
    #[allow(missing_docs)] // documentation missing in model
    S3InitiateRestoreObject,
    #[allow(missing_docs)] // documentation missing in model
    S3PutObjectAcl,
    #[allow(missing_docs)] // documentation missing in model
    S3PutObjectCopy,
    #[allow(missing_docs)] // documentation missing in model
    S3PutObjectLegalHold,
    #[allow(missing_docs)] // documentation missing in model
    S3PutObjectRetention,
    #[allow(missing_docs)] // documentation missing in model
    S3PutObjectTagging,
    #[allow(missing_docs)] // documentation missing in model
    S3ReplicateObject,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OperationName {
    fn from(s: &str) -> Self {
        match s {
            "LambdaInvoke" => OperationName::LambdaInvoke,
            "S3DeleteObjectTagging" => OperationName::S3DeleteObjectTagging,
            "S3InitiateRestoreObject" => OperationName::S3InitiateRestoreObject,
            "S3PutObjectAcl" => OperationName::S3PutObjectAcl,
            "S3PutObjectCopy" => OperationName::S3PutObjectCopy,
            "S3PutObjectLegalHold" => OperationName::S3PutObjectLegalHold,
            "S3PutObjectRetention" => OperationName::S3PutObjectRetention,
            "S3PutObjectTagging" => OperationName::S3PutObjectTagging,
            "S3ReplicateObject" => OperationName::S3ReplicateObject,
            other => OperationName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OperationName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OperationName::from(s))
    }
}
impl OperationName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OperationName::LambdaInvoke => "LambdaInvoke",
            OperationName::S3DeleteObjectTagging => "S3DeleteObjectTagging",
            OperationName::S3InitiateRestoreObject => "S3InitiateRestoreObject",
            OperationName::S3PutObjectAcl => "S3PutObjectAcl",
            OperationName::S3PutObjectCopy => "S3PutObjectCopy",
            OperationName::S3PutObjectLegalHold => "S3PutObjectLegalHold",
            OperationName::S3PutObjectRetention => "S3PutObjectRetention",
            OperationName::S3PutObjectTagging => "S3PutObjectTagging",
            OperationName::S3ReplicateObject => "S3ReplicateObject",
            OperationName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "LambdaInvoke",
            "S3DeleteObjectTagging",
            "S3InitiateRestoreObject",
            "S3PutObjectAcl",
            "S3PutObjectCopy",
            "S3PutObjectLegalHold",
            "S3PutObjectRetention",
            "S3PutObjectTagging",
            "S3ReplicateObject",
        ]
    }
}
impl AsRef<str> for OperationName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An access point with an attached Lambda function used to access transformed data from an Amazon S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ObjectLambdaAccessPoint {
    /// <p>The name of the Object Lambda Access Point.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specifies the ARN for the Object Lambda Access Point.</p>
    pub object_lambda_access_point_arn: std::option::Option<std::string::String>,
}
impl ObjectLambdaAccessPoint {
    /// <p>The name of the Object Lambda Access Point.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Specifies the ARN for the Object Lambda Access Point.</p>
    pub fn object_lambda_access_point_arn(&self) -> std::option::Option<&str> {
        self.object_lambda_access_point_arn.as_deref()
    }
}
impl std::fmt::Debug for ObjectLambdaAccessPoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ObjectLambdaAccessPoint");
        formatter.field("name", &self.name);
        formatter.field(
            "object_lambda_access_point_arn",
            &self.object_lambda_access_point_arn,
        );
        formatter.finish()
    }
}
/// See [`ObjectLambdaAccessPoint`](crate::model::ObjectLambdaAccessPoint)
pub mod object_lambda_access_point {
    /// A builder for [`ObjectLambdaAccessPoint`](crate::model::ObjectLambdaAccessPoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) object_lambda_access_point_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Specifies the ARN for the Object Lambda Access Point.</p>
        pub fn object_lambda_access_point_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.object_lambda_access_point_arn = Some(input.into());
            self
        }
        /// <p>Specifies the ARN for the Object Lambda Access Point.</p>
        pub fn set_object_lambda_access_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_lambda_access_point_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ObjectLambdaAccessPoint`](crate::model::ObjectLambdaAccessPoint)
        pub fn build(self) -> crate::model::ObjectLambdaAccessPoint {
            crate::model::ObjectLambdaAccessPoint {
                name: self.name,
                object_lambda_access_point_arn: self.object_lambda_access_point_arn,
            }
        }
    }
}
impl ObjectLambdaAccessPoint {
    /// Creates a new builder-style object to manufacture [`ObjectLambdaAccessPoint`](crate::model::ObjectLambdaAccessPoint)
    pub fn builder() -> crate::model::object_lambda_access_point::Builder {
        crate::model::object_lambda_access_point::Builder::default()
    }
}

/// <p>An access point used to access a bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessPoint {
    /// <p>The name of this access point.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Indicates whether this access point allows access from the public internet. If <code>VpcConfiguration</code> is specified for this access point, then <code>NetworkOrigin</code> is <code>VPC</code>, and the access point doesn't allow access from the public internet. Otherwise, <code>NetworkOrigin</code> is <code>Internet</code>, and the access point allows access from the public internet, subject to the access point and bucket access policies.</p>
    pub network_origin: std::option::Option<crate::model::NetworkOrigin>,
    /// <p>The virtual private cloud (VPC) configuration for this access point, if one exists.</p> <note>
    /// <p>This element is empty if this access point is an Amazon S3 on Outposts access point that is used by other Amazon Web Services.</p>
    /// </note>
    pub vpc_configuration: std::option::Option<crate::model::VpcConfiguration>,
    /// <p>The name of the bucket associated with this access point.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The ARN for the access point.</p>
    pub access_point_arn: std::option::Option<std::string::String>,
    /// <p>The name or alias of the access point.</p>
    pub alias: std::option::Option<std::string::String>,
}
impl AccessPoint {
    /// <p>The name of this access point.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Indicates whether this access point allows access from the public internet. If <code>VpcConfiguration</code> is specified for this access point, then <code>NetworkOrigin</code> is <code>VPC</code>, and the access point doesn't allow access from the public internet. Otherwise, <code>NetworkOrigin</code> is <code>Internet</code>, and the access point allows access from the public internet, subject to the access point and bucket access policies.</p>
    pub fn network_origin(&self) -> std::option::Option<&crate::model::NetworkOrigin> {
        self.network_origin.as_ref()
    }
    /// <p>The virtual private cloud (VPC) configuration for this access point, if one exists.</p> <note>
    /// <p>This element is empty if this access point is an Amazon S3 on Outposts access point that is used by other Amazon Web Services.</p>
    /// </note>
    pub fn vpc_configuration(&self) -> std::option::Option<&crate::model::VpcConfiguration> {
        self.vpc_configuration.as_ref()
    }
    /// <p>The name of the bucket associated with this access point.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The ARN for the access point.</p>
    pub fn access_point_arn(&self) -> std::option::Option<&str> {
        self.access_point_arn.as_deref()
    }
    /// <p>The name or alias of the access point.</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
}
impl std::fmt::Debug for AccessPoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessPoint");
        formatter.field("name", &self.name);
        formatter.field("network_origin", &self.network_origin);
        formatter.field("vpc_configuration", &self.vpc_configuration);
        formatter.field("bucket", &self.bucket);
        formatter.field("access_point_arn", &self.access_point_arn);
        formatter.field("alias", &self.alias);
        formatter.finish()
    }
}
/// See [`AccessPoint`](crate::model::AccessPoint)
pub mod access_point {
    /// A builder for [`AccessPoint`](crate::model::AccessPoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) network_origin: std::option::Option<crate::model::NetworkOrigin>,
        pub(crate) vpc_configuration: std::option::Option<crate::model::VpcConfiguration>,
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) access_point_arn: std::option::Option<std::string::String>,
        pub(crate) alias: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of this access point.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of this access point.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Indicates whether this access point allows access from the public internet. If <code>VpcConfiguration</code> is specified for this access point, then <code>NetworkOrigin</code> is <code>VPC</code>, and the access point doesn't allow access from the public internet. Otherwise, <code>NetworkOrigin</code> is <code>Internet</code>, and the access point allows access from the public internet, subject to the access point and bucket access policies.</p>
        pub fn network_origin(mut self, input: crate::model::NetworkOrigin) -> Self {
            self.network_origin = Some(input);
            self
        }
        /// <p>Indicates whether this access point allows access from the public internet. If <code>VpcConfiguration</code> is specified for this access point, then <code>NetworkOrigin</code> is <code>VPC</code>, and the access point doesn't allow access from the public internet. Otherwise, <code>NetworkOrigin</code> is <code>Internet</code>, and the access point allows access from the public internet, subject to the access point and bucket access policies.</p>
        pub fn set_network_origin(
            mut self,
            input: std::option::Option<crate::model::NetworkOrigin>,
        ) -> Self {
            self.network_origin = input;
            self
        }
        /// <p>The virtual private cloud (VPC) configuration for this access point, if one exists.</p> <note>
        /// <p>This element is empty if this access point is an Amazon S3 on Outposts access point that is used by other Amazon Web Services.</p>
        /// </note>
        pub fn vpc_configuration(mut self, input: crate::model::VpcConfiguration) -> Self {
            self.vpc_configuration = Some(input);
            self
        }
        /// <p>The virtual private cloud (VPC) configuration for this access point, if one exists.</p> <note>
        /// <p>This element is empty if this access point is an Amazon S3 on Outposts access point that is used by other Amazon Web Services.</p>
        /// </note>
        pub fn set_vpc_configuration(
            mut self,
            input: std::option::Option<crate::model::VpcConfiguration>,
        ) -> Self {
            self.vpc_configuration = input;
            self
        }
        /// <p>The name of the bucket associated with this access point.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket associated with this access point.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The ARN for the access point.</p>
        pub fn access_point_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_point_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the access point.</p>
        pub fn set_access_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_point_arn = input;
            self
        }
        /// <p>The name or alias of the access point.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The name or alias of the access point.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessPoint`](crate::model::AccessPoint)
        pub fn build(self) -> crate::model::AccessPoint {
            crate::model::AccessPoint {
                name: self.name,
                network_origin: self.network_origin,
                vpc_configuration: self.vpc_configuration,
                bucket: self.bucket,
                access_point_arn: self.access_point_arn,
                alias: self.alias,
            }
        }
    }
}
impl AccessPoint {
    /// Creates a new builder-style object to manufacture [`AccessPoint`](crate::model::AccessPoint)
    pub fn builder() -> crate::model::access_point::Builder {
        crate::model::access_point::Builder::default()
    }
}

/// <p>The virtual private cloud (VPC) configuration for an access point.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcConfiguration {
    /// <p>If this field is specified, this access point will only allow connections from the specified VPC ID.</p>
    pub vpc_id: std::option::Option<std::string::String>,
}
impl VpcConfiguration {
    /// <p>If this field is specified, this access point will only allow connections from the specified VPC ID.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
}
impl std::fmt::Debug for VpcConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcConfiguration");
        formatter.field("vpc_id", &self.vpc_id);
        formatter.finish()
    }
}
/// See [`VpcConfiguration`](crate::model::VpcConfiguration)
pub mod vpc_configuration {
    /// A builder for [`VpcConfiguration`](crate::model::VpcConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>If this field is specified, this access point will only allow connections from the specified VPC ID.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>If this field is specified, this access point will only allow connections from the specified VPC ID.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcConfiguration`](crate::model::VpcConfiguration)
        pub fn build(self) -> crate::model::VpcConfiguration {
            crate::model::VpcConfiguration {
                vpc_id: self.vpc_id,
            }
        }
    }
}
impl VpcConfiguration {
    /// Creates a new builder-style object to manufacture [`VpcConfiguration`](crate::model::VpcConfiguration)
    pub fn builder() -> crate::model::vpc_configuration::Builder {
        crate::model::vpc_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NetworkOrigin {
    #[allow(missing_docs)] // documentation missing in model
    Internet,
    #[allow(missing_docs)] // documentation missing in model
    Vpc,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NetworkOrigin {
    fn from(s: &str) -> Self {
        match s {
            "Internet" => NetworkOrigin::Internet,
            "VPC" => NetworkOrigin::Vpc,
            other => NetworkOrigin::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NetworkOrigin {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NetworkOrigin::from(s))
    }
}
impl NetworkOrigin {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NetworkOrigin::Internet => "Internet",
            NetworkOrigin::Vpc => "VPC",
            NetworkOrigin::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Internet", "VPC"]
    }
}
impl AsRef<str> for NetworkOrigin {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Indicates whether this access point policy is public. For more information about how Amazon S3 evaluates policies to determine whether they are public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <i>Amazon S3 User Guide</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyStatus {
    /// <p></p>
    pub is_public: bool,
}
impl PolicyStatus {
    /// <p></p>
    pub fn is_public(&self) -> bool {
        self.is_public
    }
}
impl std::fmt::Debug for PolicyStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyStatus");
        formatter.field("is_public", &self.is_public);
        formatter.finish()
    }
}
/// See [`PolicyStatus`](crate::model::PolicyStatus)
pub mod policy_status {
    /// A builder for [`PolicyStatus`](crate::model::PolicyStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) is_public: std::option::Option<bool>,
    }
    impl Builder {
        /// <p></p>
        pub fn is_public(mut self, input: bool) -> Self {
            self.is_public = Some(input);
            self
        }
        /// <p></p>
        pub fn set_is_public(mut self, input: std::option::Option<bool>) -> Self {
            self.is_public = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyStatus`](crate::model::PolicyStatus)
        pub fn build(self) -> crate::model::PolicyStatus {
            crate::model::PolicyStatus {
                is_public: self.is_public.unwrap_or_default(),
            }
        }
    }
}
impl PolicyStatus {
    /// Creates a new builder-style object to manufacture [`PolicyStatus`](crate::model::PolicyStatus)
    pub fn builder() -> crate::model::policy_status::Builder {
        crate::model::policy_status::Builder::default()
    }
}

/// <p>The Multi-Region Access Point access control policy.</p>
/// <p>When you update the policy, the update is first listed as the proposed policy. After the update is finished and all Regions have been updated, the proposed policy is listed as the established policy. If both policies have the same version number, the proposed policy is the established policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MultiRegionAccessPointPolicyDocument {
    /// <p>The last established policy for the Multi-Region Access Point.</p>
    pub established: std::option::Option<crate::model::EstablishedMultiRegionAccessPointPolicy>,
    /// <p>The proposed policy for the Multi-Region Access Point.</p>
    pub proposed: std::option::Option<crate::model::ProposedMultiRegionAccessPointPolicy>,
}
impl MultiRegionAccessPointPolicyDocument {
    /// <p>The last established policy for the Multi-Region Access Point.</p>
    pub fn established(
        &self,
    ) -> std::option::Option<&crate::model::EstablishedMultiRegionAccessPointPolicy> {
        self.established.as_ref()
    }
    /// <p>The proposed policy for the Multi-Region Access Point.</p>
    pub fn proposed(
        &self,
    ) -> std::option::Option<&crate::model::ProposedMultiRegionAccessPointPolicy> {
        self.proposed.as_ref()
    }
}
impl std::fmt::Debug for MultiRegionAccessPointPolicyDocument {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MultiRegionAccessPointPolicyDocument");
        formatter.field("established", &self.established);
        formatter.field("proposed", &self.proposed);
        formatter.finish()
    }
}
/// See [`MultiRegionAccessPointPolicyDocument`](crate::model::MultiRegionAccessPointPolicyDocument)
pub mod multi_region_access_point_policy_document {
    /// A builder for [`MultiRegionAccessPointPolicyDocument`](crate::model::MultiRegionAccessPointPolicyDocument)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) established:
            std::option::Option<crate::model::EstablishedMultiRegionAccessPointPolicy>,
        pub(crate) proposed:
            std::option::Option<crate::model::ProposedMultiRegionAccessPointPolicy>,
    }
    impl Builder {
        /// <p>The last established policy for the Multi-Region Access Point.</p>
        pub fn established(
            mut self,
            input: crate::model::EstablishedMultiRegionAccessPointPolicy,
        ) -> Self {
            self.established = Some(input);
            self
        }
        /// <p>The last established policy for the Multi-Region Access Point.</p>
        pub fn set_established(
            mut self,
            input: std::option::Option<crate::model::EstablishedMultiRegionAccessPointPolicy>,
        ) -> Self {
            self.established = input;
            self
        }
        /// <p>The proposed policy for the Multi-Region Access Point.</p>
        pub fn proposed(
            mut self,
            input: crate::model::ProposedMultiRegionAccessPointPolicy,
        ) -> Self {
            self.proposed = Some(input);
            self
        }
        /// <p>The proposed policy for the Multi-Region Access Point.</p>
        pub fn set_proposed(
            mut self,
            input: std::option::Option<crate::model::ProposedMultiRegionAccessPointPolicy>,
        ) -> Self {
            self.proposed = input;
            self
        }
        /// Consumes the builder and constructs a [`MultiRegionAccessPointPolicyDocument`](crate::model::MultiRegionAccessPointPolicyDocument)
        pub fn build(self) -> crate::model::MultiRegionAccessPointPolicyDocument {
            crate::model::MultiRegionAccessPointPolicyDocument {
                established: self.established,
                proposed: self.proposed,
            }
        }
    }
}
impl MultiRegionAccessPointPolicyDocument {
    /// Creates a new builder-style object to manufacture [`MultiRegionAccessPointPolicyDocument`](crate::model::MultiRegionAccessPointPolicyDocument)
    pub fn builder() -> crate::model::multi_region_access_point_policy_document::Builder {
        crate::model::multi_region_access_point_policy_document::Builder::default()
    }
}

/// <p>The proposed access control policy for the Multi-Region Access Point.</p>
/// <p>When you update the policy, the update is first listed as the proposed policy. After the update is finished and all Regions have been updated, the proposed policy is listed as the established policy. If both policies have the same version number, the proposed policy is the established policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProposedMultiRegionAccessPointPolicy {
    /// <p>The details of the proposed policy.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl ProposedMultiRegionAccessPointPolicy {
    /// <p>The details of the proposed policy.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for ProposedMultiRegionAccessPointPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProposedMultiRegionAccessPointPolicy");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`ProposedMultiRegionAccessPointPolicy`](crate::model::ProposedMultiRegionAccessPointPolicy)
pub mod proposed_multi_region_access_point_policy {
    /// A builder for [`ProposedMultiRegionAccessPointPolicy`](crate::model::ProposedMultiRegionAccessPointPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The details of the proposed policy.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The details of the proposed policy.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`ProposedMultiRegionAccessPointPolicy`](crate::model::ProposedMultiRegionAccessPointPolicy)
        pub fn build(self) -> crate::model::ProposedMultiRegionAccessPointPolicy {
            crate::model::ProposedMultiRegionAccessPointPolicy {
                policy: self.policy,
            }
        }
    }
}
impl ProposedMultiRegionAccessPointPolicy {
    /// Creates a new builder-style object to manufacture [`ProposedMultiRegionAccessPointPolicy`](crate::model::ProposedMultiRegionAccessPointPolicy)
    pub fn builder() -> crate::model::proposed_multi_region_access_point_policy::Builder {
        crate::model::proposed_multi_region_access_point_policy::Builder::default()
    }
}

/// <p>The last established access control policy for a Multi-Region Access Point.</p>
/// <p>When you update the policy, the update is first listed as the proposed policy. After the update is finished and all Regions have been updated, the proposed policy is listed as the established policy. If both policies have the same version number, the proposed policy is the established policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EstablishedMultiRegionAccessPointPolicy {
    /// <p>The details of the last established policy.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl EstablishedMultiRegionAccessPointPolicy {
    /// <p>The details of the last established policy.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for EstablishedMultiRegionAccessPointPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EstablishedMultiRegionAccessPointPolicy");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`EstablishedMultiRegionAccessPointPolicy`](crate::model::EstablishedMultiRegionAccessPointPolicy)
pub mod established_multi_region_access_point_policy {
    /// A builder for [`EstablishedMultiRegionAccessPointPolicy`](crate::model::EstablishedMultiRegionAccessPointPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The details of the last established policy.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The details of the last established policy.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`EstablishedMultiRegionAccessPointPolicy`](crate::model::EstablishedMultiRegionAccessPointPolicy)
        pub fn build(self) -> crate::model::EstablishedMultiRegionAccessPointPolicy {
            crate::model::EstablishedMultiRegionAccessPointPolicy {
                policy: self.policy,
            }
        }
    }
}
impl EstablishedMultiRegionAccessPointPolicy {
    /// Creates a new builder-style object to manufacture [`EstablishedMultiRegionAccessPointPolicy`](crate::model::EstablishedMultiRegionAccessPointPolicy)
    pub fn builder() -> crate::model::established_multi_region_access_point_policy::Builder {
        crate::model::established_multi_region_access_point_policy::Builder::default()
    }
}

/// <p>A container for the information about an asynchronous operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AsyncOperation {
    /// <p>The time that the request was sent to the service.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The specific operation for the asynchronous request.</p>
    pub operation: std::option::Option<crate::model::AsyncOperationName>,
    /// <p>The request token associated with the request.</p>
    pub request_token_arn: std::option::Option<std::string::String>,
    /// <p>The parameters associated with the request.</p>
    pub request_parameters: std::option::Option<crate::model::AsyncRequestParameters>,
    /// <p>The current status of the request.</p>
    pub request_status: std::option::Option<std::string::String>,
    /// <p>The details of the response.</p>
    pub response_details: std::option::Option<crate::model::AsyncResponseDetails>,
}
impl AsyncOperation {
    /// <p>The time that the request was sent to the service.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The specific operation for the asynchronous request.</p>
    pub fn operation(&self) -> std::option::Option<&crate::model::AsyncOperationName> {
        self.operation.as_ref()
    }
    /// <p>The request token associated with the request.</p>
    pub fn request_token_arn(&self) -> std::option::Option<&str> {
        self.request_token_arn.as_deref()
    }
    /// <p>The parameters associated with the request.</p>
    pub fn request_parameters(&self) -> std::option::Option<&crate::model::AsyncRequestParameters> {
        self.request_parameters.as_ref()
    }
    /// <p>The current status of the request.</p>
    pub fn request_status(&self) -> std::option::Option<&str> {
        self.request_status.as_deref()
    }
    /// <p>The details of the response.</p>
    pub fn response_details(&self) -> std::option::Option<&crate::model::AsyncResponseDetails> {
        self.response_details.as_ref()
    }
}
impl std::fmt::Debug for AsyncOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AsyncOperation");
        formatter.field("creation_time", &self.creation_time);
        formatter.field("operation", &self.operation);
        formatter.field("request_token_arn", &self.request_token_arn);
        formatter.field("request_parameters", &self.request_parameters);
        formatter.field("request_status", &self.request_status);
        formatter.field("response_details", &self.response_details);
        formatter.finish()
    }
}
/// See [`AsyncOperation`](crate::model::AsyncOperation)
pub mod async_operation {
    /// A builder for [`AsyncOperation`](crate::model::AsyncOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) operation: std::option::Option<crate::model::AsyncOperationName>,
        pub(crate) request_token_arn: std::option::Option<std::string::String>,
        pub(crate) request_parameters: std::option::Option<crate::model::AsyncRequestParameters>,
        pub(crate) request_status: std::option::Option<std::string::String>,
        pub(crate) response_details: std::option::Option<crate::model::AsyncResponseDetails>,
    }
    impl Builder {
        /// <p>The time that the request was sent to the service.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time that the request was sent to the service.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The specific operation for the asynchronous request.</p>
        pub fn operation(mut self, input: crate::model::AsyncOperationName) -> Self {
            self.operation = Some(input);
            self
        }
        /// <p>The specific operation for the asynchronous request.</p>
        pub fn set_operation(
            mut self,
            input: std::option::Option<crate::model::AsyncOperationName>,
        ) -> Self {
            self.operation = input;
            self
        }
        /// <p>The request token associated with the request.</p>
        pub fn request_token_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_token_arn = Some(input.into());
            self
        }
        /// <p>The request token associated with the request.</p>
        pub fn set_request_token_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.request_token_arn = input;
            self
        }
        /// <p>The parameters associated with the request.</p>
        pub fn request_parameters(mut self, input: crate::model::AsyncRequestParameters) -> Self {
            self.request_parameters = Some(input);
            self
        }
        /// <p>The parameters associated with the request.</p>
        pub fn set_request_parameters(
            mut self,
            input: std::option::Option<crate::model::AsyncRequestParameters>,
        ) -> Self {
            self.request_parameters = input;
            self
        }
        /// <p>The current status of the request.</p>
        pub fn request_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_status = Some(input.into());
            self
        }
        /// <p>The current status of the request.</p>
        pub fn set_request_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.request_status = input;
            self
        }
        /// <p>The details of the response.</p>
        pub fn response_details(mut self, input: crate::model::AsyncResponseDetails) -> Self {
            self.response_details = Some(input);
            self
        }
        /// <p>The details of the response.</p>
        pub fn set_response_details(
            mut self,
            input: std::option::Option<crate::model::AsyncResponseDetails>,
        ) -> Self {
            self.response_details = input;
            self
        }
        /// Consumes the builder and constructs a [`AsyncOperation`](crate::model::AsyncOperation)
        pub fn build(self) -> crate::model::AsyncOperation {
            crate::model::AsyncOperation {
                creation_time: self.creation_time,
                operation: self.operation,
                request_token_arn: self.request_token_arn,
                request_parameters: self.request_parameters,
                request_status: self.request_status,
                response_details: self.response_details,
            }
        }
    }
}
impl AsyncOperation {
    /// Creates a new builder-style object to manufacture [`AsyncOperation`](crate::model::AsyncOperation)
    pub fn builder() -> crate::model::async_operation::Builder {
        crate::model::async_operation::Builder::default()
    }
}

/// <p>A container for the response details that are returned when querying about an asynchronous request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AsyncResponseDetails {
    /// <p>The details for the Multi-Region Access Point.</p>
    pub multi_region_access_point_details:
        std::option::Option<crate::model::MultiRegionAccessPointsAsyncResponse>,
    /// <p>Error details for an asynchronous request.</p>
    pub error_details: std::option::Option<crate::model::AsyncErrorDetails>,
}
impl AsyncResponseDetails {
    /// <p>The details for the Multi-Region Access Point.</p>
    pub fn multi_region_access_point_details(
        &self,
    ) -> std::option::Option<&crate::model::MultiRegionAccessPointsAsyncResponse> {
        self.multi_region_access_point_details.as_ref()
    }
    /// <p>Error details for an asynchronous request.</p>
    pub fn error_details(&self) -> std::option::Option<&crate::model::AsyncErrorDetails> {
        self.error_details.as_ref()
    }
}
impl std::fmt::Debug for AsyncResponseDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AsyncResponseDetails");
        formatter.field(
            "multi_region_access_point_details",
            &self.multi_region_access_point_details,
        );
        formatter.field("error_details", &self.error_details);
        formatter.finish()
    }
}
/// See [`AsyncResponseDetails`](crate::model::AsyncResponseDetails)
pub mod async_response_details {
    /// A builder for [`AsyncResponseDetails`](crate::model::AsyncResponseDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) multi_region_access_point_details:
            std::option::Option<crate::model::MultiRegionAccessPointsAsyncResponse>,
        pub(crate) error_details: std::option::Option<crate::model::AsyncErrorDetails>,
    }
    impl Builder {
        /// <p>The details for the Multi-Region Access Point.</p>
        pub fn multi_region_access_point_details(
            mut self,
            input: crate::model::MultiRegionAccessPointsAsyncResponse,
        ) -> Self {
            self.multi_region_access_point_details = Some(input);
            self
        }
        /// <p>The details for the Multi-Region Access Point.</p>
        pub fn set_multi_region_access_point_details(
            mut self,
            input: std::option::Option<crate::model::MultiRegionAccessPointsAsyncResponse>,
        ) -> Self {
            self.multi_region_access_point_details = input;
            self
        }
        /// <p>Error details for an asynchronous request.</p>
        pub fn error_details(mut self, input: crate::model::AsyncErrorDetails) -> Self {
            self.error_details = Some(input);
            self
        }
        /// <p>Error details for an asynchronous request.</p>
        pub fn set_error_details(
            mut self,
            input: std::option::Option<crate::model::AsyncErrorDetails>,
        ) -> Self {
            self.error_details = input;
            self
        }
        /// Consumes the builder and constructs a [`AsyncResponseDetails`](crate::model::AsyncResponseDetails)
        pub fn build(self) -> crate::model::AsyncResponseDetails {
            crate::model::AsyncResponseDetails {
                multi_region_access_point_details: self.multi_region_access_point_details,
                error_details: self.error_details,
            }
        }
    }
}
impl AsyncResponseDetails {
    /// Creates a new builder-style object to manufacture [`AsyncResponseDetails`](crate::model::AsyncResponseDetails)
    pub fn builder() -> crate::model::async_response_details::Builder {
        crate::model::async_response_details::Builder::default()
    }
}

/// <p>Error details for the failed asynchronous operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AsyncErrorDetails {
    /// <p>A string that uniquely identifies the error condition.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>A generic descritpion of the error condition in English.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The identifier of the resource associated with the error.</p>
    pub resource: std::option::Option<std::string::String>,
    /// <p>The ID of the request associated with the error.</p>
    pub request_id: std::option::Option<std::string::String>,
}
impl AsyncErrorDetails {
    /// <p>A string that uniquely identifies the error condition.</p>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>A generic descritpion of the error condition in English.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The identifier of the resource associated with the error.</p>
    pub fn resource(&self) -> std::option::Option<&str> {
        self.resource.as_deref()
    }
    /// <p>The ID of the request associated with the error.</p>
    pub fn request_id(&self) -> std::option::Option<&str> {
        self.request_id.as_deref()
    }
}
impl std::fmt::Debug for AsyncErrorDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AsyncErrorDetails");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.field("resource", &self.resource);
        formatter.field("request_id", &self.request_id);
        formatter.finish()
    }
}
/// See [`AsyncErrorDetails`](crate::model::AsyncErrorDetails)
pub mod async_error_details {
    /// A builder for [`AsyncErrorDetails`](crate::model::AsyncErrorDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource: std::option::Option<std::string::String>,
        pub(crate) request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A string that uniquely identifies the error condition.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>A string that uniquely identifies the error condition.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>A generic descritpion of the error condition in English.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A generic descritpion of the error condition in English.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The identifier of the resource associated with the error.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource = Some(input.into());
            self
        }
        /// <p>The identifier of the resource associated with the error.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource = input;
            self
        }
        /// <p>The ID of the request associated with the error.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The ID of the request associated with the error.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AsyncErrorDetails`](crate::model::AsyncErrorDetails)
        pub fn build(self) -> crate::model::AsyncErrorDetails {
            crate::model::AsyncErrorDetails {
                code: self.code,
                message: self.message,
                resource: self.resource,
                request_id: self.request_id,
            }
        }
    }
}
impl AsyncErrorDetails {
    /// Creates a new builder-style object to manufacture [`AsyncErrorDetails`](crate::model::AsyncErrorDetails)
    pub fn builder() -> crate::model::async_error_details::Builder {
        crate::model::async_error_details::Builder::default()
    }
}

/// <p>The Multi-Region Access Point details that are returned when querying about an asynchronous request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MultiRegionAccessPointsAsyncResponse {
    /// <p>A collection of status information for the different Regions that a Multi-Region Access Point supports.</p>
    pub regions:
        std::option::Option<std::vec::Vec<crate::model::MultiRegionAccessPointRegionalResponse>>,
}
impl MultiRegionAccessPointsAsyncResponse {
    /// <p>A collection of status information for the different Regions that a Multi-Region Access Point supports.</p>
    pub fn regions(
        &self,
    ) -> std::option::Option<&[crate::model::MultiRegionAccessPointRegionalResponse]> {
        self.regions.as_deref()
    }
}
impl std::fmt::Debug for MultiRegionAccessPointsAsyncResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MultiRegionAccessPointsAsyncResponse");
        formatter.field("regions", &self.regions);
        formatter.finish()
    }
}
/// See [`MultiRegionAccessPointsAsyncResponse`](crate::model::MultiRegionAccessPointsAsyncResponse)
pub mod multi_region_access_points_async_response {
    /// A builder for [`MultiRegionAccessPointsAsyncResponse`](crate::model::MultiRegionAccessPointsAsyncResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) regions: std::option::Option<
            std::vec::Vec<crate::model::MultiRegionAccessPointRegionalResponse>,
        >,
    }
    impl Builder {
        /// Appends an item to `regions`.
        ///
        /// To override the contents of this collection use [`set_regions`](Self::set_regions).
        ///
        /// <p>A collection of status information for the different Regions that a Multi-Region Access Point supports.</p>
        pub fn regions(
            mut self,
            input: crate::model::MultiRegionAccessPointRegionalResponse,
        ) -> Self {
            let mut v = self.regions.unwrap_or_default();
            v.push(input);
            self.regions = Some(v);
            self
        }
        /// <p>A collection of status information for the different Regions that a Multi-Region Access Point supports.</p>
        pub fn set_regions(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::MultiRegionAccessPointRegionalResponse>,
            >,
        ) -> Self {
            self.regions = input;
            self
        }
        /// Consumes the builder and constructs a [`MultiRegionAccessPointsAsyncResponse`](crate::model::MultiRegionAccessPointsAsyncResponse)
        pub fn build(self) -> crate::model::MultiRegionAccessPointsAsyncResponse {
            crate::model::MultiRegionAccessPointsAsyncResponse {
                regions: self.regions,
            }
        }
    }
}
impl MultiRegionAccessPointsAsyncResponse {
    /// Creates a new builder-style object to manufacture [`MultiRegionAccessPointsAsyncResponse`](crate::model::MultiRegionAccessPointsAsyncResponse)
    pub fn builder() -> crate::model::multi_region_access_points_async_response::Builder {
        crate::model::multi_region_access_points_async_response::Builder::default()
    }
}

/// <p>Status information for a single Multi-Region Access Point Region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MultiRegionAccessPointRegionalResponse {
    /// <p>The name of the Region in the Multi-Region Access Point.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The current status of the Multi-Region Access Point in this Region.</p>
    pub request_status: std::option::Option<std::string::String>,
}
impl MultiRegionAccessPointRegionalResponse {
    /// <p>The name of the Region in the Multi-Region Access Point.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The current status of the Multi-Region Access Point in this Region.</p>
    pub fn request_status(&self) -> std::option::Option<&str> {
        self.request_status.as_deref()
    }
}
impl std::fmt::Debug for MultiRegionAccessPointRegionalResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MultiRegionAccessPointRegionalResponse");
        formatter.field("name", &self.name);
        formatter.field("request_status", &self.request_status);
        formatter.finish()
    }
}
/// See [`MultiRegionAccessPointRegionalResponse`](crate::model::MultiRegionAccessPointRegionalResponse)
pub mod multi_region_access_point_regional_response {
    /// A builder for [`MultiRegionAccessPointRegionalResponse`](crate::model::MultiRegionAccessPointRegionalResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) request_status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Region in the Multi-Region Access Point.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Region in the Multi-Region Access Point.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The current status of the Multi-Region Access Point in this Region.</p>
        pub fn request_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_status = Some(input.into());
            self
        }
        /// <p>The current status of the Multi-Region Access Point in this Region.</p>
        pub fn set_request_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.request_status = input;
            self
        }
        /// Consumes the builder and constructs a [`MultiRegionAccessPointRegionalResponse`](crate::model::MultiRegionAccessPointRegionalResponse)
        pub fn build(self) -> crate::model::MultiRegionAccessPointRegionalResponse {
            crate::model::MultiRegionAccessPointRegionalResponse {
                name: self.name,
                request_status: self.request_status,
            }
        }
    }
}
impl MultiRegionAccessPointRegionalResponse {
    /// Creates a new builder-style object to manufacture [`MultiRegionAccessPointRegionalResponse`](crate::model::MultiRegionAccessPointRegionalResponse)
    pub fn builder() -> crate::model::multi_region_access_point_regional_response::Builder {
        crate::model::multi_region_access_point_regional_response::Builder::default()
    }
}

/// <p>A container for the request parameters associated with an asynchronous request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AsyncRequestParameters {
    /// <p>A container of the parameters for a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html">CreateMultiRegionAccessPoint</a> request.</p>
    pub create_multi_region_access_point_request:
        std::option::Option<crate::model::CreateMultiRegionAccessPointInput>,
    /// <p>A container of the parameters for a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html">DeleteMultiRegionAccessPoint</a> request.</p>
    pub delete_multi_region_access_point_request:
        std::option::Option<crate::model::DeleteMultiRegionAccessPointInput>,
    /// <p>A container of the parameters for a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPoint.html">PutMultiRegionAccessPoint</a> request.</p>
    pub put_multi_region_access_point_policy_request:
        std::option::Option<crate::model::PutMultiRegionAccessPointPolicyInput>,
}
impl AsyncRequestParameters {
    /// <p>A container of the parameters for a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html">CreateMultiRegionAccessPoint</a> request.</p>
    pub fn create_multi_region_access_point_request(
        &self,
    ) -> std::option::Option<&crate::model::CreateMultiRegionAccessPointInput> {
        self.create_multi_region_access_point_request.as_ref()
    }
    /// <p>A container of the parameters for a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html">DeleteMultiRegionAccessPoint</a> request.</p>
    pub fn delete_multi_region_access_point_request(
        &self,
    ) -> std::option::Option<&crate::model::DeleteMultiRegionAccessPointInput> {
        self.delete_multi_region_access_point_request.as_ref()
    }
    /// <p>A container of the parameters for a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPoint.html">PutMultiRegionAccessPoint</a> request.</p>
    pub fn put_multi_region_access_point_policy_request(
        &self,
    ) -> std::option::Option<&crate::model::PutMultiRegionAccessPointPolicyInput> {
        self.put_multi_region_access_point_policy_request.as_ref()
    }
}
impl std::fmt::Debug for AsyncRequestParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AsyncRequestParameters");
        formatter.field(
            "create_multi_region_access_point_request",
            &self.create_multi_region_access_point_request,
        );
        formatter.field(
            "delete_multi_region_access_point_request",
            &self.delete_multi_region_access_point_request,
        );
        formatter.field(
            "put_multi_region_access_point_policy_request",
            &self.put_multi_region_access_point_policy_request,
        );
        formatter.finish()
    }
}
/// See [`AsyncRequestParameters`](crate::model::AsyncRequestParameters)
pub mod async_request_parameters {
    /// A builder for [`AsyncRequestParameters`](crate::model::AsyncRequestParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) create_multi_region_access_point_request:
            std::option::Option<crate::model::CreateMultiRegionAccessPointInput>,
        pub(crate) delete_multi_region_access_point_request:
            std::option::Option<crate::model::DeleteMultiRegionAccessPointInput>,
        pub(crate) put_multi_region_access_point_policy_request:
            std::option::Option<crate::model::PutMultiRegionAccessPointPolicyInput>,
    }
    impl Builder {
        /// <p>A container of the parameters for a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html">CreateMultiRegionAccessPoint</a> request.</p>
        pub fn create_multi_region_access_point_request(
            mut self,
            input: crate::model::CreateMultiRegionAccessPointInput,
        ) -> Self {
            self.create_multi_region_access_point_request = Some(input);
            self
        }
        /// <p>A container of the parameters for a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html">CreateMultiRegionAccessPoint</a> request.</p>
        pub fn set_create_multi_region_access_point_request(
            mut self,
            input: std::option::Option<crate::model::CreateMultiRegionAccessPointInput>,
        ) -> Self {
            self.create_multi_region_access_point_request = input;
            self
        }
        /// <p>A container of the parameters for a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html">DeleteMultiRegionAccessPoint</a> request.</p>
        pub fn delete_multi_region_access_point_request(
            mut self,
            input: crate::model::DeleteMultiRegionAccessPointInput,
        ) -> Self {
            self.delete_multi_region_access_point_request = Some(input);
            self
        }
        /// <p>A container of the parameters for a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html">DeleteMultiRegionAccessPoint</a> request.</p>
        pub fn set_delete_multi_region_access_point_request(
            mut self,
            input: std::option::Option<crate::model::DeleteMultiRegionAccessPointInput>,
        ) -> Self {
            self.delete_multi_region_access_point_request = input;
            self
        }
        /// <p>A container of the parameters for a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPoint.html">PutMultiRegionAccessPoint</a> request.</p>
        pub fn put_multi_region_access_point_policy_request(
            mut self,
            input: crate::model::PutMultiRegionAccessPointPolicyInput,
        ) -> Self {
            self.put_multi_region_access_point_policy_request = Some(input);
            self
        }
        /// <p>A container of the parameters for a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPoint.html">PutMultiRegionAccessPoint</a> request.</p>
        pub fn set_put_multi_region_access_point_policy_request(
            mut self,
            input: std::option::Option<crate::model::PutMultiRegionAccessPointPolicyInput>,
        ) -> Self {
            self.put_multi_region_access_point_policy_request = input;
            self
        }
        /// Consumes the builder and constructs a [`AsyncRequestParameters`](crate::model::AsyncRequestParameters)
        pub fn build(self) -> crate::model::AsyncRequestParameters {
            crate::model::AsyncRequestParameters {
                create_multi_region_access_point_request: self
                    .create_multi_region_access_point_request,
                delete_multi_region_access_point_request: self
                    .delete_multi_region_access_point_request,
                put_multi_region_access_point_policy_request: self
                    .put_multi_region_access_point_policy_request,
            }
        }
    }
}
impl AsyncRequestParameters {
    /// Creates a new builder-style object to manufacture [`AsyncRequestParameters`](crate::model::AsyncRequestParameters)
    pub fn builder() -> crate::model::async_request_parameters::Builder {
        crate::model::async_request_parameters::Builder::default()
    }
}

/// <p>A container for the information associated with a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html">DeleteMultiRegionAccessPoint</a> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMultiRegionAccessPointInput {
    /// <p>The name of the Multi-Region Access Point associated with this request.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteMultiRegionAccessPointInput {
    /// <p>The name of the Multi-Region Access Point associated with this request.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteMultiRegionAccessPointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMultiRegionAccessPointInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`DeleteMultiRegionAccessPointInput`](crate::model::DeleteMultiRegionAccessPointInput)
pub mod delete_multi_region_access_point_input {
    /// A builder for [`DeleteMultiRegionAccessPointInput`](crate::model::DeleteMultiRegionAccessPointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Multi-Region Access Point associated with this request.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Multi-Region Access Point associated with this request.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMultiRegionAccessPointInput`](crate::model::DeleteMultiRegionAccessPointInput)
        pub fn build(self) -> crate::model::DeleteMultiRegionAccessPointInput {
            crate::model::DeleteMultiRegionAccessPointInput { name: self.name }
        }
    }
}
impl DeleteMultiRegionAccessPointInput {
    /// Creates a new builder-style object to manufacture [`DeleteMultiRegionAccessPointInput`](crate::model::DeleteMultiRegionAccessPointInput)
    pub fn builder() -> crate::model::delete_multi_region_access_point_input::Builder {
        crate::model::delete_multi_region_access_point_input::Builder::default()
    }
}

/// <p>A container for the information associated with a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html">CreateMultiRegionAccessPoint</a> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMultiRegionAccessPointInput {
    /// <p>The name of the Multi-Region Access Point associated with this request.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The <code>PublicAccessBlock</code> configuration that you want to apply to this Amazon S3 account. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>This is not supported for Amazon S3 on Outposts.</p>
    pub public_access_block: std::option::Option<crate::model::PublicAccessBlockConfiguration>,
    /// <p>The buckets in different Regions that are associated with the Multi-Region Access Point.</p>
    pub regions: std::option::Option<std::vec::Vec<crate::model::Region>>,
}
impl CreateMultiRegionAccessPointInput {
    /// <p>The name of the Multi-Region Access Point associated with this request.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The <code>PublicAccessBlock</code> configuration that you want to apply to this Amazon S3 account. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>This is not supported for Amazon S3 on Outposts.</p>
    pub fn public_access_block(
        &self,
    ) -> std::option::Option<&crate::model::PublicAccessBlockConfiguration> {
        self.public_access_block.as_ref()
    }
    /// <p>The buckets in different Regions that are associated with the Multi-Region Access Point.</p>
    pub fn regions(&self) -> std::option::Option<&[crate::model::Region]> {
        self.regions.as_deref()
    }
}
impl std::fmt::Debug for CreateMultiRegionAccessPointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMultiRegionAccessPointInput");
        formatter.field("name", &self.name);
        formatter.field("public_access_block", &self.public_access_block);
        formatter.field("regions", &self.regions);
        formatter.finish()
    }
}
/// See [`CreateMultiRegionAccessPointInput`](crate::model::CreateMultiRegionAccessPointInput)
pub mod create_multi_region_access_point_input {
    /// A builder for [`CreateMultiRegionAccessPointInput`](crate::model::CreateMultiRegionAccessPointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) public_access_block:
            std::option::Option<crate::model::PublicAccessBlockConfiguration>,
        pub(crate) regions: std::option::Option<std::vec::Vec<crate::model::Region>>,
    }
    impl Builder {
        /// <p>The name of the Multi-Region Access Point associated with this request.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Multi-Region Access Point associated with this request.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The <code>PublicAccessBlock</code> configuration that you want to apply to this Amazon S3 account. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>This is not supported for Amazon S3 on Outposts.</p>
        pub fn public_access_block(
            mut self,
            input: crate::model::PublicAccessBlockConfiguration,
        ) -> Self {
            self.public_access_block = Some(input);
            self
        }
        /// <p>The <code>PublicAccessBlock</code> configuration that you want to apply to this Amazon S3 account. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>This is not supported for Amazon S3 on Outposts.</p>
        pub fn set_public_access_block(
            mut self,
            input: std::option::Option<crate::model::PublicAccessBlockConfiguration>,
        ) -> Self {
            self.public_access_block = input;
            self
        }
        /// Appends an item to `regions`.
        ///
        /// To override the contents of this collection use [`set_regions`](Self::set_regions).
        ///
        /// <p>The buckets in different Regions that are associated with the Multi-Region Access Point.</p>
        pub fn regions(mut self, input: crate::model::Region) -> Self {
            let mut v = self.regions.unwrap_or_default();
            v.push(input);
            self.regions = Some(v);
            self
        }
        /// <p>The buckets in different Regions that are associated with the Multi-Region Access Point.</p>
        pub fn set_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Region>>,
        ) -> Self {
            self.regions = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMultiRegionAccessPointInput`](crate::model::CreateMultiRegionAccessPointInput)
        pub fn build(self) -> crate::model::CreateMultiRegionAccessPointInput {
            crate::model::CreateMultiRegionAccessPointInput {
                name: self.name,
                public_access_block: self.public_access_block,
                regions: self.regions,
            }
        }
    }
}
impl CreateMultiRegionAccessPointInput {
    /// Creates a new builder-style object to manufacture [`CreateMultiRegionAccessPointInput`](crate::model::CreateMultiRegionAccessPointInput)
    pub fn builder() -> crate::model::create_multi_region_access_point_input::Builder {
        crate::model::create_multi_region_access_point_input::Builder::default()
    }
}

/// <p>A Region that supports a Multi-Region Access Point as well as the associated bucket for the Region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Region {
    /// <p>The name of the associated bucket for the Region.</p>
    pub bucket: std::option::Option<std::string::String>,
}
impl Region {
    /// <p>The name of the associated bucket for the Region.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
}
impl std::fmt::Debug for Region {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Region");
        formatter.field("bucket", &self.bucket);
        formatter.finish()
    }
}
/// See [`Region`](crate::model::Region)
pub mod region {
    /// A builder for [`Region`](crate::model::Region)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the associated bucket for the Region.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the associated bucket for the Region.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// Consumes the builder and constructs a [`Region`](crate::model::Region)
        pub fn build(self) -> crate::model::Region {
            crate::model::Region {
                bucket: self.bucket,
            }
        }
    }
}
impl Region {
    /// Creates a new builder-style object to manufacture [`Region`](crate::model::Region)
    pub fn builder() -> crate::model::region::Builder {
        crate::model::region::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AsyncOperationName {
    #[allow(missing_docs)] // documentation missing in model
    CreateMultiRegionAccessPoint,
    #[allow(missing_docs)] // documentation missing in model
    DeleteMultiRegionAccessPoint,
    #[allow(missing_docs)] // documentation missing in model
    PutMultiRegionAccessPointPolicy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AsyncOperationName {
    fn from(s: &str) -> Self {
        match s {
            "CreateMultiRegionAccessPoint" => AsyncOperationName::CreateMultiRegionAccessPoint,
            "DeleteMultiRegionAccessPoint" => AsyncOperationName::DeleteMultiRegionAccessPoint,
            "PutMultiRegionAccessPointPolicy" => {
                AsyncOperationName::PutMultiRegionAccessPointPolicy
            }
            other => AsyncOperationName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AsyncOperationName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AsyncOperationName::from(s))
    }
}
impl AsyncOperationName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AsyncOperationName::CreateMultiRegionAccessPoint => "CreateMultiRegionAccessPoint",
            AsyncOperationName::DeleteMultiRegionAccessPoint => "DeleteMultiRegionAccessPoint",
            AsyncOperationName::PutMultiRegionAccessPointPolicy => {
                "PutMultiRegionAccessPointPolicy"
            }
            AsyncOperationName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CreateMultiRegionAccessPoint",
            "DeleteMultiRegionAccessPoint",
            "PutMultiRegionAccessPointPolicy",
        ]
    }
}
impl AsRef<str> for AsyncOperationName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A container element for the job configuration and status information returned by a <code>Describe Job</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobDescriptor {
    /// <p>The ID for the specified job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether confirmation is required before Amazon S3 begins running the specified job. Confirmation is required only for jobs created through the Amazon S3 console.</p>
    pub confirmation_required: std::option::Option<bool>,
    /// <p>The description for this job, if one was provided in this job's <code>Create Job</code> request.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for this job.</p>
    pub job_arn: std::option::Option<std::string::String>,
    /// <p>The current status of the specified job.</p>
    pub status: std::option::Option<crate::model::JobStatus>,
    /// <p>The configuration information for the specified job's manifest object.</p>
    pub manifest: std::option::Option<crate::model::JobManifest>,
    /// <p>The operation that the specified job is configured to run on the objects listed in the manifest.</p>
    pub operation: std::option::Option<crate::model::JobOperation>,
    /// <p>The priority of the specified job.</p>
    pub priority: i32,
    /// <p>Describes the total number of tasks that the specified job has run, the number of tasks that succeeded, and the number of tasks that failed.</p>
    pub progress_summary: std::option::Option<crate::model::JobProgressSummary>,
    /// <p>The reason for updating the job.</p>
    pub status_update_reason: std::option::Option<std::string::String>,
    /// <p>If the specified job failed, this field contains information describing the failure.</p>
    pub failure_reasons: std::option::Option<std::vec::Vec<crate::model::JobFailure>>,
    /// <p>Contains the configuration information for the job-completion report if you requested one in the <code>Create Job</code> request.</p>
    pub report: std::option::Option<crate::model::JobReport>,
    /// <p>A timestamp indicating when this job was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp indicating when this job terminated. A job's termination date is the date and time when it succeeded, failed, or was canceled.</p>
    pub termination_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Amazon Resource Name (ARN) for the Identity and Access Management (IAM) role assigned to run the tasks for this job.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The timestamp when this job was suspended, if it has been suspended.</p>
    pub suspended_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The reason why the specified job was suspended. A job is only suspended if you create it through the Amazon S3 console. When you create the job, it enters the <code>Suspended</code> state to await confirmation before running. After you confirm the job, it automatically exits the <code>Suspended</code> state.</p>
    pub suspended_cause: std::option::Option<std::string::String>,
    /// <p>The manifest generator that was used to generate a job manifest for this job.</p>
    pub manifest_generator: std::option::Option<crate::model::JobManifestGenerator>,
    /// <p>The attribute of the JobDescriptor containing details about the job's generated manifest.</p>
    pub generated_manifest_descriptor:
        std::option::Option<crate::model::S3GeneratedManifestDescriptor>,
}
impl JobDescriptor {
    /// <p>The ID for the specified job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>Indicates whether confirmation is required before Amazon S3 begins running the specified job. Confirmation is required only for jobs created through the Amazon S3 console.</p>
    pub fn confirmation_required(&self) -> std::option::Option<bool> {
        self.confirmation_required
    }
    /// <p>The description for this job, if one was provided in this job's <code>Create Job</code> request.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for this job.</p>
    pub fn job_arn(&self) -> std::option::Option<&str> {
        self.job_arn.as_deref()
    }
    /// <p>The current status of the specified job.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.status.as_ref()
    }
    /// <p>The configuration information for the specified job's manifest object.</p>
    pub fn manifest(&self) -> std::option::Option<&crate::model::JobManifest> {
        self.manifest.as_ref()
    }
    /// <p>The operation that the specified job is configured to run on the objects listed in the manifest.</p>
    pub fn operation(&self) -> std::option::Option<&crate::model::JobOperation> {
        self.operation.as_ref()
    }
    /// <p>The priority of the specified job.</p>
    pub fn priority(&self) -> i32 {
        self.priority
    }
    /// <p>Describes the total number of tasks that the specified job has run, the number of tasks that succeeded, and the number of tasks that failed.</p>
    pub fn progress_summary(&self) -> std::option::Option<&crate::model::JobProgressSummary> {
        self.progress_summary.as_ref()
    }
    /// <p>The reason for updating the job.</p>
    pub fn status_update_reason(&self) -> std::option::Option<&str> {
        self.status_update_reason.as_deref()
    }
    /// <p>If the specified job failed, this field contains information describing the failure.</p>
    pub fn failure_reasons(&self) -> std::option::Option<&[crate::model::JobFailure]> {
        self.failure_reasons.as_deref()
    }
    /// <p>Contains the configuration information for the job-completion report if you requested one in the <code>Create Job</code> request.</p>
    pub fn report(&self) -> std::option::Option<&crate::model::JobReport> {
        self.report.as_ref()
    }
    /// <p>A timestamp indicating when this job was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>A timestamp indicating when this job terminated. A job's termination date is the date and time when it succeeded, failed, or was canceled.</p>
    pub fn termination_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.termination_date.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) for the Identity and Access Management (IAM) role assigned to run the tasks for this job.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The timestamp when this job was suspended, if it has been suspended.</p>
    pub fn suspended_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.suspended_date.as_ref()
    }
    /// <p>The reason why the specified job was suspended. A job is only suspended if you create it through the Amazon S3 console. When you create the job, it enters the <code>Suspended</code> state to await confirmation before running. After you confirm the job, it automatically exits the <code>Suspended</code> state.</p>
    pub fn suspended_cause(&self) -> std::option::Option<&str> {
        self.suspended_cause.as_deref()
    }
    /// <p>The manifest generator that was used to generate a job manifest for this job.</p>
    pub fn manifest_generator(&self) -> std::option::Option<&crate::model::JobManifestGenerator> {
        self.manifest_generator.as_ref()
    }
    /// <p>The attribute of the JobDescriptor containing details about the job's generated manifest.</p>
    pub fn generated_manifest_descriptor(
        &self,
    ) -> std::option::Option<&crate::model::S3GeneratedManifestDescriptor> {
        self.generated_manifest_descriptor.as_ref()
    }
}
impl std::fmt::Debug for JobDescriptor {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobDescriptor");
        formatter.field("job_id", &self.job_id);
        formatter.field("confirmation_required", &self.confirmation_required);
        formatter.field("description", &self.description);
        formatter.field("job_arn", &self.job_arn);
        formatter.field("status", &self.status);
        formatter.field("manifest", &self.manifest);
        formatter.field("operation", &self.operation);
        formatter.field("priority", &self.priority);
        formatter.field("progress_summary", &self.progress_summary);
        formatter.field("status_update_reason", &self.status_update_reason);
        formatter.field("failure_reasons", &self.failure_reasons);
        formatter.field("report", &self.report);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("termination_date", &self.termination_date);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("suspended_date", &self.suspended_date);
        formatter.field("suspended_cause", &self.suspended_cause);
        formatter.field("manifest_generator", &self.manifest_generator);
        formatter.field(
            "generated_manifest_descriptor",
            &self.generated_manifest_descriptor,
        );
        formatter.finish()
    }
}
/// See [`JobDescriptor`](crate::model::JobDescriptor)
pub mod job_descriptor {
    /// A builder for [`JobDescriptor`](crate::model::JobDescriptor)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) confirmation_required: std::option::Option<bool>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) job_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::JobStatus>,
        pub(crate) manifest: std::option::Option<crate::model::JobManifest>,
        pub(crate) operation: std::option::Option<crate::model::JobOperation>,
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) progress_summary: std::option::Option<crate::model::JobProgressSummary>,
        pub(crate) status_update_reason: std::option::Option<std::string::String>,
        pub(crate) failure_reasons: std::option::Option<std::vec::Vec<crate::model::JobFailure>>,
        pub(crate) report: std::option::Option<crate::model::JobReport>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) termination_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) suspended_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) suspended_cause: std::option::Option<std::string::String>,
        pub(crate) manifest_generator: std::option::Option<crate::model::JobManifestGenerator>,
        pub(crate) generated_manifest_descriptor:
            std::option::Option<crate::model::S3GeneratedManifestDescriptor>,
    }
    impl Builder {
        /// <p>The ID for the specified job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for the specified job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>Indicates whether confirmation is required before Amazon S3 begins running the specified job. Confirmation is required only for jobs created through the Amazon S3 console.</p>
        pub fn confirmation_required(mut self, input: bool) -> Self {
            self.confirmation_required = Some(input);
            self
        }
        /// <p>Indicates whether confirmation is required before Amazon S3 begins running the specified job. Confirmation is required only for jobs created through the Amazon S3 console.</p>
        pub fn set_confirmation_required(mut self, input: std::option::Option<bool>) -> Self {
            self.confirmation_required = input;
            self
        }
        /// <p>The description for this job, if one was provided in this job's <code>Create Job</code> request.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for this job, if one was provided in this job's <code>Create Job</code> request.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for this job.</p>
        pub fn job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for this job.</p>
        pub fn set_job_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_arn = input;
            self
        }
        /// <p>The current status of the specified job.</p>
        pub fn status(mut self, input: crate::model::JobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the specified job.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::JobStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>The configuration information for the specified job's manifest object.</p>
        pub fn manifest(mut self, input: crate::model::JobManifest) -> Self {
            self.manifest = Some(input);
            self
        }
        /// <p>The configuration information for the specified job's manifest object.</p>
        pub fn set_manifest(
            mut self,
            input: std::option::Option<crate::model::JobManifest>,
        ) -> Self {
            self.manifest = input;
            self
        }
        /// <p>The operation that the specified job is configured to run on the objects listed in the manifest.</p>
        pub fn operation(mut self, input: crate::model::JobOperation) -> Self {
            self.operation = Some(input);
            self
        }
        /// <p>The operation that the specified job is configured to run on the objects listed in the manifest.</p>
        pub fn set_operation(
            mut self,
            input: std::option::Option<crate::model::JobOperation>,
        ) -> Self {
            self.operation = input;
            self
        }
        /// <p>The priority of the specified job.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The priority of the specified job.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// <p>Describes the total number of tasks that the specified job has run, the number of tasks that succeeded, and the number of tasks that failed.</p>
        pub fn progress_summary(mut self, input: crate::model::JobProgressSummary) -> Self {
            self.progress_summary = Some(input);
            self
        }
        /// <p>Describes the total number of tasks that the specified job has run, the number of tasks that succeeded, and the number of tasks that failed.</p>
        pub fn set_progress_summary(
            mut self,
            input: std::option::Option<crate::model::JobProgressSummary>,
        ) -> Self {
            self.progress_summary = input;
            self
        }
        /// <p>The reason for updating the job.</p>
        pub fn status_update_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_update_reason = Some(input.into());
            self
        }
        /// <p>The reason for updating the job.</p>
        pub fn set_status_update_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_update_reason = input;
            self
        }
        /// Appends an item to `failure_reasons`.
        ///
        /// To override the contents of this collection use [`set_failure_reasons`](Self::set_failure_reasons).
        ///
        /// <p>If the specified job failed, this field contains information describing the failure.</p>
        pub fn failure_reasons(mut self, input: crate::model::JobFailure) -> Self {
            let mut v = self.failure_reasons.unwrap_or_default();
            v.push(input);
            self.failure_reasons = Some(v);
            self
        }
        /// <p>If the specified job failed, this field contains information describing the failure.</p>
        pub fn set_failure_reasons(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobFailure>>,
        ) -> Self {
            self.failure_reasons = input;
            self
        }
        /// <p>Contains the configuration information for the job-completion report if you requested one in the <code>Create Job</code> request.</p>
        pub fn report(mut self, input: crate::model::JobReport) -> Self {
            self.report = Some(input);
            self
        }
        /// <p>Contains the configuration information for the job-completion report if you requested one in the <code>Create Job</code> request.</p>
        pub fn set_report(mut self, input: std::option::Option<crate::model::JobReport>) -> Self {
            self.report = input;
            self
        }
        /// <p>A timestamp indicating when this job was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A timestamp indicating when this job was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>A timestamp indicating when this job terminated. A job's termination date is the date and time when it succeeded, failed, or was canceled.</p>
        pub fn termination_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.termination_date = Some(input);
            self
        }
        /// <p>A timestamp indicating when this job terminated. A job's termination date is the date and time when it succeeded, failed, or was canceled.</p>
        pub fn set_termination_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.termination_date = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Identity and Access Management (IAM) role assigned to run the tasks for this job.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Identity and Access Management (IAM) role assigned to run the tasks for this job.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The timestamp when this job was suspended, if it has been suspended.</p>
        pub fn suspended_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.suspended_date = Some(input);
            self
        }
        /// <p>The timestamp when this job was suspended, if it has been suspended.</p>
        pub fn set_suspended_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.suspended_date = input;
            self
        }
        /// <p>The reason why the specified job was suspended. A job is only suspended if you create it through the Amazon S3 console. When you create the job, it enters the <code>Suspended</code> state to await confirmation before running. After you confirm the job, it automatically exits the <code>Suspended</code> state.</p>
        pub fn suspended_cause(mut self, input: impl Into<std::string::String>) -> Self {
            self.suspended_cause = Some(input.into());
            self
        }
        /// <p>The reason why the specified job was suspended. A job is only suspended if you create it through the Amazon S3 console. When you create the job, it enters the <code>Suspended</code> state to await confirmation before running. After you confirm the job, it automatically exits the <code>Suspended</code> state.</p>
        pub fn set_suspended_cause(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suspended_cause = input;
            self
        }
        /// <p>The manifest generator that was used to generate a job manifest for this job.</p>
        pub fn manifest_generator(mut self, input: crate::model::JobManifestGenerator) -> Self {
            self.manifest_generator = Some(input);
            self
        }
        /// <p>The manifest generator that was used to generate a job manifest for this job.</p>
        pub fn set_manifest_generator(
            mut self,
            input: std::option::Option<crate::model::JobManifestGenerator>,
        ) -> Self {
            self.manifest_generator = input;
            self
        }
        /// <p>The attribute of the JobDescriptor containing details about the job's generated manifest.</p>
        pub fn generated_manifest_descriptor(
            mut self,
            input: crate::model::S3GeneratedManifestDescriptor,
        ) -> Self {
            self.generated_manifest_descriptor = Some(input);
            self
        }
        /// <p>The attribute of the JobDescriptor containing details about the job's generated manifest.</p>
        pub fn set_generated_manifest_descriptor(
            mut self,
            input: std::option::Option<crate::model::S3GeneratedManifestDescriptor>,
        ) -> Self {
            self.generated_manifest_descriptor = input;
            self
        }
        /// Consumes the builder and constructs a [`JobDescriptor`](crate::model::JobDescriptor)
        pub fn build(self) -> crate::model::JobDescriptor {
            crate::model::JobDescriptor {
                job_id: self.job_id,
                confirmation_required: self.confirmation_required,
                description: self.description,
                job_arn: self.job_arn,
                status: self.status,
                manifest: self.manifest,
                operation: self.operation,
                priority: self.priority.unwrap_or_default(),
                progress_summary: self.progress_summary,
                status_update_reason: self.status_update_reason,
                failure_reasons: self.failure_reasons,
                report: self.report,
                creation_time: self.creation_time,
                termination_date: self.termination_date,
                role_arn: self.role_arn,
                suspended_date: self.suspended_date,
                suspended_cause: self.suspended_cause,
                manifest_generator: self.manifest_generator,
                generated_manifest_descriptor: self.generated_manifest_descriptor,
            }
        }
    }
}
impl JobDescriptor {
    /// Creates a new builder-style object to manufacture [`JobDescriptor`](crate::model::JobDescriptor)
    pub fn builder() -> crate::model::job_descriptor::Builder {
        crate::model::job_descriptor::Builder::default()
    }
}

/// <p>Describes the specified job's generated manifest. Batch Operations jobs created with a ManifestGenerator populate details of this descriptor after execution of the ManifestGenerator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3GeneratedManifestDescriptor {
    /// <p>The format of the generated manifest.</p>
    pub format: std::option::Option<crate::model::GeneratedManifestFormat>,
    /// <p>Contains the information required to locate a manifest object.</p>
    pub location: std::option::Option<crate::model::JobManifestLocation>,
}
impl S3GeneratedManifestDescriptor {
    /// <p>The format of the generated manifest.</p>
    pub fn format(&self) -> std::option::Option<&crate::model::GeneratedManifestFormat> {
        self.format.as_ref()
    }
    /// <p>Contains the information required to locate a manifest object.</p>
    pub fn location(&self) -> std::option::Option<&crate::model::JobManifestLocation> {
        self.location.as_ref()
    }
}
impl std::fmt::Debug for S3GeneratedManifestDescriptor {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3GeneratedManifestDescriptor");
        formatter.field("format", &self.format);
        formatter.field("location", &self.location);
        formatter.finish()
    }
}
/// See [`S3GeneratedManifestDescriptor`](crate::model::S3GeneratedManifestDescriptor)
pub mod s3_generated_manifest_descriptor {
    /// A builder for [`S3GeneratedManifestDescriptor`](crate::model::S3GeneratedManifestDescriptor)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) format: std::option::Option<crate::model::GeneratedManifestFormat>,
        pub(crate) location: std::option::Option<crate::model::JobManifestLocation>,
    }
    impl Builder {
        /// <p>The format of the generated manifest.</p>
        pub fn format(mut self, input: crate::model::GeneratedManifestFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>The format of the generated manifest.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::GeneratedManifestFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>Contains the information required to locate a manifest object.</p>
        pub fn location(mut self, input: crate::model::JobManifestLocation) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>Contains the information required to locate a manifest object.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::JobManifestLocation>,
        ) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`S3GeneratedManifestDescriptor`](crate::model::S3GeneratedManifestDescriptor)
        pub fn build(self) -> crate::model::S3GeneratedManifestDescriptor {
            crate::model::S3GeneratedManifestDescriptor {
                format: self.format,
                location: self.location,
            }
        }
    }
}
impl S3GeneratedManifestDescriptor {
    /// Creates a new builder-style object to manufacture [`S3GeneratedManifestDescriptor`](crate::model::S3GeneratedManifestDescriptor)
    pub fn builder() -> crate::model::s3_generated_manifest_descriptor::Builder {
        crate::model::s3_generated_manifest_descriptor::Builder::default()
    }
}

/// <p>Contains the information required to locate a manifest object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobManifestLocation {
    /// <p>The Amazon Resource Name (ARN) for a manifest object.</p> <important>
    /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
    /// </important>
    pub object_arn: std::option::Option<std::string::String>,
    /// <p>The optional version ID to identify a specific version of the manifest object.</p>
    pub object_version_id: std::option::Option<std::string::String>,
    /// <p>The ETag for the specified manifest object.</p>
    pub e_tag: std::option::Option<std::string::String>,
}
impl JobManifestLocation {
    /// <p>The Amazon Resource Name (ARN) for a manifest object.</p> <important>
    /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
    /// </important>
    pub fn object_arn(&self) -> std::option::Option<&str> {
        self.object_arn.as_deref()
    }
    /// <p>The optional version ID to identify a specific version of the manifest object.</p>
    pub fn object_version_id(&self) -> std::option::Option<&str> {
        self.object_version_id.as_deref()
    }
    /// <p>The ETag for the specified manifest object.</p>
    pub fn e_tag(&self) -> std::option::Option<&str> {
        self.e_tag.as_deref()
    }
}
impl std::fmt::Debug for JobManifestLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobManifestLocation");
        formatter.field("object_arn", &self.object_arn);
        formatter.field("object_version_id", &self.object_version_id);
        formatter.field("e_tag", &self.e_tag);
        formatter.finish()
    }
}
/// See [`JobManifestLocation`](crate::model::JobManifestLocation)
pub mod job_manifest_location {
    /// A builder for [`JobManifestLocation`](crate::model::JobManifestLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_arn: std::option::Option<std::string::String>,
        pub(crate) object_version_id: std::option::Option<std::string::String>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for a manifest object.</p> <important>
        /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
        /// </important>
        pub fn object_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for a manifest object.</p> <important>
        /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
        /// </important>
        pub fn set_object_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object_arn = input;
            self
        }
        /// <p>The optional version ID to identify a specific version of the manifest object.</p>
        pub fn object_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_version_id = Some(input.into());
            self
        }
        /// <p>The optional version ID to identify a specific version of the manifest object.</p>
        pub fn set_object_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_version_id = input;
            self
        }
        /// <p>The ETag for the specified manifest object.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The ETag for the specified manifest object.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// Consumes the builder and constructs a [`JobManifestLocation`](crate::model::JobManifestLocation)
        pub fn build(self) -> crate::model::JobManifestLocation {
            crate::model::JobManifestLocation {
                object_arn: self.object_arn,
                object_version_id: self.object_version_id,
                e_tag: self.e_tag,
            }
        }
    }
}
impl JobManifestLocation {
    /// Creates a new builder-style object to manufacture [`JobManifestLocation`](crate::model::JobManifestLocation)
    pub fn builder() -> crate::model::job_manifest_location::Builder {
        crate::model::job_manifest_location::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GeneratedManifestFormat {
    #[allow(missing_docs)] // documentation missing in model
    S3InventoryReportCsv20211130,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GeneratedManifestFormat {
    fn from(s: &str) -> Self {
        match s {
            "S3InventoryReport_CSV_20211130" => {
                GeneratedManifestFormat::S3InventoryReportCsv20211130
            }
            other => GeneratedManifestFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GeneratedManifestFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GeneratedManifestFormat::from(s))
    }
}
impl GeneratedManifestFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GeneratedManifestFormat::S3InventoryReportCsv20211130 => {
                "S3InventoryReport_CSV_20211130"
            }
            GeneratedManifestFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["S3InventoryReport_CSV_20211130"]
    }
}
impl AsRef<str> for GeneratedManifestFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Configures the type of the job's ManifestGenerator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum JobManifestGenerator {
    /// <p>The S3 job ManifestGenerator's configuration details.</p>
    S3JobManifestGenerator(crate::model::S3JobManifestGenerator),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl JobManifestGenerator {
    #[allow(irrefutable_let_patterns)]
    /// Tries to convert the enum instance into [`S3JobManifestGenerator`](crate::model::JobManifestGenerator::S3JobManifestGenerator), extracting the inner [`S3JobManifestGenerator`](crate::model::S3JobManifestGenerator).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_s3_job_manifest_generator(
        &self,
    ) -> std::result::Result<&crate::model::S3JobManifestGenerator, &Self> {
        if let JobManifestGenerator::S3JobManifestGenerator(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`S3JobManifestGenerator`](crate::model::JobManifestGenerator::S3JobManifestGenerator).
    pub fn is_s3_job_manifest_generator(&self) -> bool {
        self.as_s3_job_manifest_generator().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>The container for the service that will create the S3 manifest.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3JobManifestGenerator {
    /// <p>The Amazon Web Services account ID that owns the bucket the generated manifest is written to. If provided the generated manifest bucket's owner Amazon Web Services account ID must match this value, else the job fails.</p>
    pub expected_bucket_owner: std::option::Option<std::string::String>,
    /// <p>The source bucket used by the ManifestGenerator.</p>
    pub source_bucket: std::option::Option<std::string::String>,
    /// <p>Specifies the location the generated manifest will be written to.</p>
    pub manifest_output_location: std::option::Option<crate::model::S3ManifestOutputLocation>,
    /// <p>Specifies rules the S3JobManifestGenerator should use to use to decide whether an object in the source bucket should or should not be included in the generated job manifest.</p>
    pub filter: std::option::Option<crate::model::JobManifestGeneratorFilter>,
    /// <p>Determines whether or not to write the job's generated manifest to a bucket.</p>
    pub enable_manifest_output: bool,
}
impl S3JobManifestGenerator {
    /// <p>The Amazon Web Services account ID that owns the bucket the generated manifest is written to. If provided the generated manifest bucket's owner Amazon Web Services account ID must match this value, else the job fails.</p>
    pub fn expected_bucket_owner(&self) -> std::option::Option<&str> {
        self.expected_bucket_owner.as_deref()
    }
    /// <p>The source bucket used by the ManifestGenerator.</p>
    pub fn source_bucket(&self) -> std::option::Option<&str> {
        self.source_bucket.as_deref()
    }
    /// <p>Specifies the location the generated manifest will be written to.</p>
    pub fn manifest_output_location(
        &self,
    ) -> std::option::Option<&crate::model::S3ManifestOutputLocation> {
        self.manifest_output_location.as_ref()
    }
    /// <p>Specifies rules the S3JobManifestGenerator should use to use to decide whether an object in the source bucket should or should not be included in the generated job manifest.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::JobManifestGeneratorFilter> {
        self.filter.as_ref()
    }
    /// <p>Determines whether or not to write the job's generated manifest to a bucket.</p>
    pub fn enable_manifest_output(&self) -> bool {
        self.enable_manifest_output
    }
}
impl std::fmt::Debug for S3JobManifestGenerator {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3JobManifestGenerator");
        formatter.field("expected_bucket_owner", &self.expected_bucket_owner);
        formatter.field("source_bucket", &self.source_bucket);
        formatter.field("manifest_output_location", &self.manifest_output_location);
        formatter.field("filter", &self.filter);
        formatter.field("enable_manifest_output", &self.enable_manifest_output);
        formatter.finish()
    }
}
/// See [`S3JobManifestGenerator`](crate::model::S3JobManifestGenerator)
pub mod s3_job_manifest_generator {
    /// A builder for [`S3JobManifestGenerator`](crate::model::S3JobManifestGenerator)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
        pub(crate) source_bucket: std::option::Option<std::string::String>,
        pub(crate) manifest_output_location:
            std::option::Option<crate::model::S3ManifestOutputLocation>,
        pub(crate) filter: std::option::Option<crate::model::JobManifestGeneratorFilter>,
        pub(crate) enable_manifest_output: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID that owns the bucket the generated manifest is written to. If provided the generated manifest bucket's owner Amazon Web Services account ID must match this value, else the job fails.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID that owns the bucket the generated manifest is written to. If provided the generated manifest bucket's owner Amazon Web Services account ID must match this value, else the job fails.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// <p>The source bucket used by the ManifestGenerator.</p>
        pub fn source_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_bucket = Some(input.into());
            self
        }
        /// <p>The source bucket used by the ManifestGenerator.</p>
        pub fn set_source_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_bucket = input;
            self
        }
        /// <p>Specifies the location the generated manifest will be written to.</p>
        pub fn manifest_output_location(
            mut self,
            input: crate::model::S3ManifestOutputLocation,
        ) -> Self {
            self.manifest_output_location = Some(input);
            self
        }
        /// <p>Specifies the location the generated manifest will be written to.</p>
        pub fn set_manifest_output_location(
            mut self,
            input: std::option::Option<crate::model::S3ManifestOutputLocation>,
        ) -> Self {
            self.manifest_output_location = input;
            self
        }
        /// <p>Specifies rules the S3JobManifestGenerator should use to use to decide whether an object in the source bucket should or should not be included in the generated job manifest.</p>
        pub fn filter(mut self, input: crate::model::JobManifestGeneratorFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Specifies rules the S3JobManifestGenerator should use to use to decide whether an object in the source bucket should or should not be included in the generated job manifest.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::JobManifestGeneratorFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>Determines whether or not to write the job's generated manifest to a bucket.</p>
        pub fn enable_manifest_output(mut self, input: bool) -> Self {
            self.enable_manifest_output = Some(input);
            self
        }
        /// <p>Determines whether or not to write the job's generated manifest to a bucket.</p>
        pub fn set_enable_manifest_output(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_manifest_output = input;
            self
        }
        /// Consumes the builder and constructs a [`S3JobManifestGenerator`](crate::model::S3JobManifestGenerator)
        pub fn build(self) -> crate::model::S3JobManifestGenerator {
            crate::model::S3JobManifestGenerator {
                expected_bucket_owner: self.expected_bucket_owner,
                source_bucket: self.source_bucket,
                manifest_output_location: self.manifest_output_location,
                filter: self.filter,
                enable_manifest_output: self.enable_manifest_output.unwrap_or_default(),
            }
        }
    }
}
impl S3JobManifestGenerator {
    /// Creates a new builder-style object to manufacture [`S3JobManifestGenerator`](crate::model::S3JobManifestGenerator)
    pub fn builder() -> crate::model::s3_job_manifest_generator::Builder {
        crate::model::s3_job_manifest_generator::Builder::default()
    }
}

/// <p>The filter used to describe a set of objects for the job's manifest.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobManifestGeneratorFilter {
    /// <p>Include objects in the generated manifest only if they are eligible for replication according to the Replication configuration on the source bucket.</p>
    pub eligible_for_replication: std::option::Option<bool>,
    /// <p>If provided, the generated manifest should include only source bucket objects that were created after this time.</p>
    pub created_after: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>If provided, the generated manifest should include only source bucket objects that were created before this time.</p>
    pub created_before: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>If provided, the generated manifest should include only source bucket objects that have one of the specified Replication statuses.</p>
    pub object_replication_statuses:
        std::option::Option<std::vec::Vec<crate::model::ReplicationStatus>>,
}
impl JobManifestGeneratorFilter {
    /// <p>Include objects in the generated manifest only if they are eligible for replication according to the Replication configuration on the source bucket.</p>
    pub fn eligible_for_replication(&self) -> std::option::Option<bool> {
        self.eligible_for_replication
    }
    /// <p>If provided, the generated manifest should include only source bucket objects that were created after this time.</p>
    pub fn created_after(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_after.as_ref()
    }
    /// <p>If provided, the generated manifest should include only source bucket objects that were created before this time.</p>
    pub fn created_before(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_before.as_ref()
    }
    /// <p>If provided, the generated manifest should include only source bucket objects that have one of the specified Replication statuses.</p>
    pub fn object_replication_statuses(
        &self,
    ) -> std::option::Option<&[crate::model::ReplicationStatus]> {
        self.object_replication_statuses.as_deref()
    }
}
impl std::fmt::Debug for JobManifestGeneratorFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobManifestGeneratorFilter");
        formatter.field("eligible_for_replication", &self.eligible_for_replication);
        formatter.field("created_after", &self.created_after);
        formatter.field("created_before", &self.created_before);
        formatter.field(
            "object_replication_statuses",
            &self.object_replication_statuses,
        );
        formatter.finish()
    }
}
/// See [`JobManifestGeneratorFilter`](crate::model::JobManifestGeneratorFilter)
pub mod job_manifest_generator_filter {
    /// A builder for [`JobManifestGeneratorFilter`](crate::model::JobManifestGeneratorFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) eligible_for_replication: std::option::Option<bool>,
        pub(crate) created_after: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_before: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) object_replication_statuses:
            std::option::Option<std::vec::Vec<crate::model::ReplicationStatus>>,
    }
    impl Builder {
        /// <p>Include objects in the generated manifest only if they are eligible for replication according to the Replication configuration on the source bucket.</p>
        pub fn eligible_for_replication(mut self, input: bool) -> Self {
            self.eligible_for_replication = Some(input);
            self
        }
        /// <p>Include objects in the generated manifest only if they are eligible for replication according to the Replication configuration on the source bucket.</p>
        pub fn set_eligible_for_replication(mut self, input: std::option::Option<bool>) -> Self {
            self.eligible_for_replication = input;
            self
        }
        /// <p>If provided, the generated manifest should include only source bucket objects that were created after this time.</p>
        pub fn created_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_after = Some(input);
            self
        }
        /// <p>If provided, the generated manifest should include only source bucket objects that were created after this time.</p>
        pub fn set_created_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_after = input;
            self
        }
        /// <p>If provided, the generated manifest should include only source bucket objects that were created before this time.</p>
        pub fn created_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_before = Some(input);
            self
        }
        /// <p>If provided, the generated manifest should include only source bucket objects that were created before this time.</p>
        pub fn set_created_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_before = input;
            self
        }
        /// Appends an item to `object_replication_statuses`.
        ///
        /// To override the contents of this collection use [`set_object_replication_statuses`](Self::set_object_replication_statuses).
        ///
        /// <p>If provided, the generated manifest should include only source bucket objects that have one of the specified Replication statuses.</p>
        pub fn object_replication_statuses(
            mut self,
            input: crate::model::ReplicationStatus,
        ) -> Self {
            let mut v = self.object_replication_statuses.unwrap_or_default();
            v.push(input);
            self.object_replication_statuses = Some(v);
            self
        }
        /// <p>If provided, the generated manifest should include only source bucket objects that have one of the specified Replication statuses.</p>
        pub fn set_object_replication_statuses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicationStatus>>,
        ) -> Self {
            self.object_replication_statuses = input;
            self
        }
        /// Consumes the builder and constructs a [`JobManifestGeneratorFilter`](crate::model::JobManifestGeneratorFilter)
        pub fn build(self) -> crate::model::JobManifestGeneratorFilter {
            crate::model::JobManifestGeneratorFilter {
                eligible_for_replication: self.eligible_for_replication,
                created_after: self.created_after,
                created_before: self.created_before,
                object_replication_statuses: self.object_replication_statuses,
            }
        }
    }
}
impl JobManifestGeneratorFilter {
    /// Creates a new builder-style object to manufacture [`JobManifestGeneratorFilter`](crate::model::JobManifestGeneratorFilter)
    pub fn builder() -> crate::model::job_manifest_generator_filter::Builder {
        crate::model::job_manifest_generator_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReplicationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Replica,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReplicationStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => ReplicationStatus::Completed,
            "FAILED" => ReplicationStatus::Failed,
            "NONE" => ReplicationStatus::None,
            "REPLICA" => ReplicationStatus::Replica,
            other => ReplicationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReplicationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReplicationStatus::from(s))
    }
}
impl ReplicationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReplicationStatus::Completed => "COMPLETED",
            ReplicationStatus::Failed => "FAILED",
            ReplicationStatus::None => "NONE",
            ReplicationStatus::Replica => "REPLICA",
            ReplicationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETED", "FAILED", "NONE", "REPLICA"]
    }
}
impl AsRef<str> for ReplicationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Location details for where the generated manifest should be written.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3ManifestOutputLocation {
    /// <p>The Account ID that owns the bucket the generated manifest is written to.</p>
    pub expected_manifest_bucket_owner: std::option::Option<std::string::String>,
    /// <p>The bucket ARN the generated manifest should be written to.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>Prefix identifying one or more objects to which the manifest applies.</p>
    pub manifest_prefix: std::option::Option<std::string::String>,
    /// <p>Specifies what encryption should be used when the generated manifest objects are written.</p>
    pub manifest_encryption: std::option::Option<crate::model::GeneratedManifestEncryption>,
    /// <p>The format of the generated manifest.</p>
    pub manifest_format: std::option::Option<crate::model::GeneratedManifestFormat>,
}
impl S3ManifestOutputLocation {
    /// <p>The Account ID that owns the bucket the generated manifest is written to.</p>
    pub fn expected_manifest_bucket_owner(&self) -> std::option::Option<&str> {
        self.expected_manifest_bucket_owner.as_deref()
    }
    /// <p>The bucket ARN the generated manifest should be written to.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>Prefix identifying one or more objects to which the manifest applies.</p>
    pub fn manifest_prefix(&self) -> std::option::Option<&str> {
        self.manifest_prefix.as_deref()
    }
    /// <p>Specifies what encryption should be used when the generated manifest objects are written.</p>
    pub fn manifest_encryption(
        &self,
    ) -> std::option::Option<&crate::model::GeneratedManifestEncryption> {
        self.manifest_encryption.as_ref()
    }
    /// <p>The format of the generated manifest.</p>
    pub fn manifest_format(&self) -> std::option::Option<&crate::model::GeneratedManifestFormat> {
        self.manifest_format.as_ref()
    }
}
impl std::fmt::Debug for S3ManifestOutputLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3ManifestOutputLocation");
        formatter.field(
            "expected_manifest_bucket_owner",
            &self.expected_manifest_bucket_owner,
        );
        formatter.field("bucket", &self.bucket);
        formatter.field("manifest_prefix", &self.manifest_prefix);
        formatter.field("manifest_encryption", &self.manifest_encryption);
        formatter.field("manifest_format", &self.manifest_format);
        formatter.finish()
    }
}
/// See [`S3ManifestOutputLocation`](crate::model::S3ManifestOutputLocation)
pub mod s3_manifest_output_location {
    /// A builder for [`S3ManifestOutputLocation`](crate::model::S3ManifestOutputLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) expected_manifest_bucket_owner: std::option::Option<std::string::String>,
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) manifest_prefix: std::option::Option<std::string::String>,
        pub(crate) manifest_encryption:
            std::option::Option<crate::model::GeneratedManifestEncryption>,
        pub(crate) manifest_format: std::option::Option<crate::model::GeneratedManifestFormat>,
    }
    impl Builder {
        /// <p>The Account ID that owns the bucket the generated manifest is written to.</p>
        pub fn expected_manifest_bucket_owner(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.expected_manifest_bucket_owner = Some(input.into());
            self
        }
        /// <p>The Account ID that owns the bucket the generated manifest is written to.</p>
        pub fn set_expected_manifest_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_manifest_bucket_owner = input;
            self
        }
        /// <p>The bucket ARN the generated manifest should be written to.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket ARN the generated manifest should be written to.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Prefix identifying one or more objects to which the manifest applies.</p>
        pub fn manifest_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.manifest_prefix = Some(input.into());
            self
        }
        /// <p>Prefix identifying one or more objects to which the manifest applies.</p>
        pub fn set_manifest_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.manifest_prefix = input;
            self
        }
        /// <p>Specifies what encryption should be used when the generated manifest objects are written.</p>
        pub fn manifest_encryption(
            mut self,
            input: crate::model::GeneratedManifestEncryption,
        ) -> Self {
            self.manifest_encryption = Some(input);
            self
        }
        /// <p>Specifies what encryption should be used when the generated manifest objects are written.</p>
        pub fn set_manifest_encryption(
            mut self,
            input: std::option::Option<crate::model::GeneratedManifestEncryption>,
        ) -> Self {
            self.manifest_encryption = input;
            self
        }
        /// <p>The format of the generated manifest.</p>
        pub fn manifest_format(mut self, input: crate::model::GeneratedManifestFormat) -> Self {
            self.manifest_format = Some(input);
            self
        }
        /// <p>The format of the generated manifest.</p>
        pub fn set_manifest_format(
            mut self,
            input: std::option::Option<crate::model::GeneratedManifestFormat>,
        ) -> Self {
            self.manifest_format = input;
            self
        }
        /// Consumes the builder and constructs a [`S3ManifestOutputLocation`](crate::model::S3ManifestOutputLocation)
        pub fn build(self) -> crate::model::S3ManifestOutputLocation {
            crate::model::S3ManifestOutputLocation {
                expected_manifest_bucket_owner: self.expected_manifest_bucket_owner,
                bucket: self.bucket,
                manifest_prefix: self.manifest_prefix,
                manifest_encryption: self.manifest_encryption,
                manifest_format: self.manifest_format,
            }
        }
    }
}
impl S3ManifestOutputLocation {
    /// Creates a new builder-style object to manufacture [`S3ManifestOutputLocation`](crate::model::S3ManifestOutputLocation)
    pub fn builder() -> crate::model::s3_manifest_output_location::Builder {
        crate::model::s3_manifest_output_location::Builder::default()
    }
}

/// <p>The encryption configuration to use when storing the generated manifest.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GeneratedManifestEncryption {
    /// <p>Specifies the use of SSE-S3 to encrypt generated manifest objects.</p>
    pub sses3: std::option::Option<crate::model::Sses3Encryption>,
    /// <p>Configuration details on how SSE-KMS is used to encrypt generated manifest objects.</p>
    pub ssekms: std::option::Option<crate::model::SsekmsEncryption>,
}
impl GeneratedManifestEncryption {
    /// <p>Specifies the use of SSE-S3 to encrypt generated manifest objects.</p>
    pub fn sses3(&self) -> std::option::Option<&crate::model::Sses3Encryption> {
        self.sses3.as_ref()
    }
    /// <p>Configuration details on how SSE-KMS is used to encrypt generated manifest objects.</p>
    pub fn ssekms(&self) -> std::option::Option<&crate::model::SsekmsEncryption> {
        self.ssekms.as_ref()
    }
}
impl std::fmt::Debug for GeneratedManifestEncryption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GeneratedManifestEncryption");
        formatter.field("sses3", &self.sses3);
        formatter.field("ssekms", &self.ssekms);
        formatter.finish()
    }
}
/// See [`GeneratedManifestEncryption`](crate::model::GeneratedManifestEncryption)
pub mod generated_manifest_encryption {
    /// A builder for [`GeneratedManifestEncryption`](crate::model::GeneratedManifestEncryption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sses3: std::option::Option<crate::model::Sses3Encryption>,
        pub(crate) ssekms: std::option::Option<crate::model::SsekmsEncryption>,
    }
    impl Builder {
        /// <p>Specifies the use of SSE-S3 to encrypt generated manifest objects.</p>
        pub fn sses3(mut self, input: crate::model::Sses3Encryption) -> Self {
            self.sses3 = Some(input);
            self
        }
        /// <p>Specifies the use of SSE-S3 to encrypt generated manifest objects.</p>
        pub fn set_sses3(
            mut self,
            input: std::option::Option<crate::model::Sses3Encryption>,
        ) -> Self {
            self.sses3 = input;
            self
        }
        /// <p>Configuration details on how SSE-KMS is used to encrypt generated manifest objects.</p>
        pub fn ssekms(mut self, input: crate::model::SsekmsEncryption) -> Self {
            self.ssekms = Some(input);
            self
        }
        /// <p>Configuration details on how SSE-KMS is used to encrypt generated manifest objects.</p>
        pub fn set_ssekms(
            mut self,
            input: std::option::Option<crate::model::SsekmsEncryption>,
        ) -> Self {
            self.ssekms = input;
            self
        }
        /// Consumes the builder and constructs a [`GeneratedManifestEncryption`](crate::model::GeneratedManifestEncryption)
        pub fn build(self) -> crate::model::GeneratedManifestEncryption {
            crate::model::GeneratedManifestEncryption {
                sses3: self.sses3,
                ssekms: self.ssekms,
            }
        }
    }
}
impl GeneratedManifestEncryption {
    /// Creates a new builder-style object to manufacture [`GeneratedManifestEncryption`](crate::model::GeneratedManifestEncryption)
    pub fn builder() -> crate::model::generated_manifest_encryption::Builder {
        crate::model::generated_manifest_encryption::Builder::default()
    }
}

/// <p>Configuration for the use of SSE-KMS to encrypt generated manifest objects.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SsekmsEncryption {
    /// <p>Specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric customer managed key to use for encrypting generated manifest objects.</p>
    pub key_id: std::option::Option<std::string::String>,
}
impl SsekmsEncryption {
    /// <p>Specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric customer managed key to use for encrypting generated manifest objects.</p>
    pub fn key_id(&self) -> std::option::Option<&str> {
        self.key_id.as_deref()
    }
}
impl std::fmt::Debug for SsekmsEncryption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SsekmsEncryption");
        formatter.field("key_id", &self.key_id);
        formatter.finish()
    }
}
/// See [`SsekmsEncryption`](crate::model::SsekmsEncryption)
pub mod ssekms_encryption {
    /// A builder for [`SsekmsEncryption`](crate::model::SsekmsEncryption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric customer managed key to use for encrypting generated manifest objects.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>Specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric customer managed key to use for encrypting generated manifest objects.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SsekmsEncryption`](crate::model::SsekmsEncryption)
        pub fn build(self) -> crate::model::SsekmsEncryption {
            crate::model::SsekmsEncryption {
                key_id: self.key_id,
            }
        }
    }
}
impl SsekmsEncryption {
    /// Creates a new builder-style object to manufacture [`SsekmsEncryption`](crate::model::SsekmsEncryption)
    pub fn builder() -> crate::model::ssekms_encryption::Builder {
        crate::model::ssekms_encryption::Builder::default()
    }
}

/// <p>Configuration for the use of SSE-S3 to encrypt generated manifest objects.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Sses3Encryption {}
impl std::fmt::Debug for Sses3Encryption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Sses3Encryption");
        formatter.finish()
    }
}
/// See [`Sses3Encryption`](crate::model::Sses3Encryption)
pub mod sses3_encryption {
    /// A builder for [`Sses3Encryption`](crate::model::Sses3Encryption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`Sses3Encryption`](crate::model::Sses3Encryption)
        pub fn build(self) -> crate::model::Sses3Encryption {
            crate::model::Sses3Encryption {}
        }
    }
}
impl Sses3Encryption {
    /// Creates a new builder-style object to manufacture [`Sses3Encryption`](crate::model::Sses3Encryption)
    pub fn builder() -> crate::model::sses3_encryption::Builder {
        crate::model::sses3_encryption::Builder::default()
    }
}

/// <p>Contains the configuration parameters for a job-completion report.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobReport {
    /// <p>The Amazon Resource Name (ARN) for the bucket where specified job-completion report will be stored.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The format of the specified job-completion report.</p>
    pub format: std::option::Option<crate::model::JobReportFormat>,
    /// <p>Indicates whether the specified job will generate a job-completion report.</p>
    pub enabled: bool,
    /// <p>An optional prefix to describe where in the specified bucket the job-completion report will be stored. Amazon S3 stores the job-completion report at <code>
    /// <prefix>
    /// /job-
    /// <job-id>
    /// /report.json
    /// </job-id>
    /// </prefix></code>.</p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>Indicates whether the job-completion report will include details of all tasks or only failed tasks.</p>
    pub report_scope: std::option::Option<crate::model::JobReportScope>,
}
impl JobReport {
    /// <p>The Amazon Resource Name (ARN) for the bucket where specified job-completion report will be stored.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The format of the specified job-completion report.</p>
    pub fn format(&self) -> std::option::Option<&crate::model::JobReportFormat> {
        self.format.as_ref()
    }
    /// <p>Indicates whether the specified job will generate a job-completion report.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>An optional prefix to describe where in the specified bucket the job-completion report will be stored. Amazon S3 stores the job-completion report at <code>
    /// <prefix>
    /// /job-
    /// <job-id>
    /// /report.json
    /// </job-id>
    /// </prefix></code>.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>Indicates whether the job-completion report will include details of all tasks or only failed tasks.</p>
    pub fn report_scope(&self) -> std::option::Option<&crate::model::JobReportScope> {
        self.report_scope.as_ref()
    }
}
impl std::fmt::Debug for JobReport {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobReport");
        formatter.field("bucket", &self.bucket);
        formatter.field("format", &self.format);
        formatter.field("enabled", &self.enabled);
        formatter.field("prefix", &self.prefix);
        formatter.field("report_scope", &self.report_scope);
        formatter.finish()
    }
}
/// See [`JobReport`](crate::model::JobReport)
pub mod job_report {
    /// A builder for [`JobReport`](crate::model::JobReport)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::JobReportFormat>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) report_scope: std::option::Option<crate::model::JobReportScope>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the bucket where specified job-completion report will be stored.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the bucket where specified job-completion report will be stored.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The format of the specified job-completion report.</p>
        pub fn format(mut self, input: crate::model::JobReportFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>The format of the specified job-completion report.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::JobReportFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>Indicates whether the specified job will generate a job-completion report.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Indicates whether the specified job will generate a job-completion report.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>An optional prefix to describe where in the specified bucket the job-completion report will be stored. Amazon S3 stores the job-completion report at <code>
        /// <prefix>
        /// /job-
        /// <job-id>
        /// /report.json
        /// </job-id>
        /// </prefix></code>.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>An optional prefix to describe where in the specified bucket the job-completion report will be stored. Amazon S3 stores the job-completion report at <code>
        /// <prefix>
        /// /job-
        /// <job-id>
        /// /report.json
        /// </job-id>
        /// </prefix></code>.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>Indicates whether the job-completion report will include details of all tasks or only failed tasks.</p>
        pub fn report_scope(mut self, input: crate::model::JobReportScope) -> Self {
            self.report_scope = Some(input);
            self
        }
        /// <p>Indicates whether the job-completion report will include details of all tasks or only failed tasks.</p>
        pub fn set_report_scope(
            mut self,
            input: std::option::Option<crate::model::JobReportScope>,
        ) -> Self {
            self.report_scope = input;
            self
        }
        /// Consumes the builder and constructs a [`JobReport`](crate::model::JobReport)
        pub fn build(self) -> crate::model::JobReport {
            crate::model::JobReport {
                bucket: self.bucket,
                format: self.format,
                enabled: self.enabled.unwrap_or_default(),
                prefix: self.prefix,
                report_scope: self.report_scope,
            }
        }
    }
}
impl JobReport {
    /// Creates a new builder-style object to manufacture [`JobReport`](crate::model::JobReport)
    pub fn builder() -> crate::model::job_report::Builder {
        crate::model::job_report::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobReportScope {
    #[allow(missing_docs)] // documentation missing in model
    AllTasks,
    #[allow(missing_docs)] // documentation missing in model
    FailedTasksOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobReportScope {
    fn from(s: &str) -> Self {
        match s {
            "AllTasks" => JobReportScope::AllTasks,
            "FailedTasksOnly" => JobReportScope::FailedTasksOnly,
            other => JobReportScope::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobReportScope {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobReportScope::from(s))
    }
}
impl JobReportScope {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobReportScope::AllTasks => "AllTasks",
            JobReportScope::FailedTasksOnly => "FailedTasksOnly",
            JobReportScope::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AllTasks", "FailedTasksOnly"]
    }
}
impl AsRef<str> for JobReportScope {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobReportFormat {
    #[allow(missing_docs)] // documentation missing in model
    ReportCsv20180820,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobReportFormat {
    fn from(s: &str) -> Self {
        match s {
            "Report_CSV_20180820" => JobReportFormat::ReportCsv20180820,
            other => JobReportFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobReportFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobReportFormat::from(s))
    }
}
impl JobReportFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobReportFormat::ReportCsv20180820 => "Report_CSV_20180820",
            JobReportFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Report_CSV_20180820"]
    }
}
impl AsRef<str> for JobReportFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>If this job failed, this element indicates why the job failed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobFailure {
    /// <p>The failure code, if any, for the specified job.</p>
    pub failure_code: std::option::Option<std::string::String>,
    /// <p>The failure reason, if any, for the specified job.</p>
    pub failure_reason: std::option::Option<std::string::String>,
}
impl JobFailure {
    /// <p>The failure code, if any, for the specified job.</p>
    pub fn failure_code(&self) -> std::option::Option<&str> {
        self.failure_code.as_deref()
    }
    /// <p>The failure reason, if any, for the specified job.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
}
impl std::fmt::Debug for JobFailure {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobFailure");
        formatter.field("failure_code", &self.failure_code);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.finish()
    }
}
/// See [`JobFailure`](crate::model::JobFailure)
pub mod job_failure {
    /// A builder for [`JobFailure`](crate::model::JobFailure)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) failure_code: std::option::Option<std::string::String>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The failure code, if any, for the specified job.</p>
        pub fn failure_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_code = Some(input.into());
            self
        }
        /// <p>The failure code, if any, for the specified job.</p>
        pub fn set_failure_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.failure_code = input;
            self
        }
        /// <p>The failure reason, if any, for the specified job.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>The failure reason, if any, for the specified job.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`JobFailure`](crate::model::JobFailure)
        pub fn build(self) -> crate::model::JobFailure {
            crate::model::JobFailure {
                failure_code: self.failure_code,
                failure_reason: self.failure_reason,
            }
        }
    }
}
impl JobFailure {
    /// Creates a new builder-style object to manufacture [`JobFailure`](crate::model::JobFailure)
    pub fn builder() -> crate::model::job_failure::Builder {
        crate::model::job_failure::Builder::default()
    }
}

/// <p>The operation that you want this job to perform on every object listed in the manifest. For more information about the available operations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-operations.html">Operations</a> in the <i>Amazon S3 User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobOperation {
    /// <p>Directs the specified job to invoke an Lambda function on every object in the manifest.</p>
    pub lambda_invoke: std::option::Option<crate::model::LambdaInvokeOperation>,
    /// <p>Directs the specified job to run a PUT Copy object call on every object in the manifest.</p>
    pub s3_put_object_copy: std::option::Option<crate::model::S3CopyObjectOperation>,
    /// <p>Directs the specified job to run a PUT Object acl call on every object in the manifest.</p>
    pub s3_put_object_acl: std::option::Option<crate::model::S3SetObjectAclOperation>,
    /// <p>Directs the specified job to run a PUT Object tagging call on every object in the manifest.</p>
    pub s3_put_object_tagging: std::option::Option<crate::model::S3SetObjectTaggingOperation>,
    /// <p>Directs the specified job to execute a DELETE Object tagging call on every object in the manifest.</p>
    pub s3_delete_object_tagging: std::option::Option<crate::model::S3DeleteObjectTaggingOperation>,
    /// <p>Directs the specified job to initiate restore requests for every archived object in the manifest.</p>
    pub s3_initiate_restore_object:
        std::option::Option<crate::model::S3InitiateRestoreObjectOperation>,
    /// <p>Contains the configuration for an S3 Object Lock legal hold operation that an S3 Batch Operations job passes every object to the underlying <code>PutObjectLegalHold</code> API. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-legal-hold.html">Using S3 Object Lock legal hold with S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub s3_put_object_legal_hold: std::option::Option<crate::model::S3SetObjectLegalHoldOperation>,
    /// <p>Contains the configuration parameters for the Object Lock retention action for an S3 Batch Operations job. Batch Operations passes every object to the underlying <code>PutObjectRetention</code> API. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html">Using S3 Object Lock retention with S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub s3_put_object_retention: std::option::Option<crate::model::S3SetObjectRetentionOperation>,
    /// <p>Directs the specified job to invoke <code>ReplicateObject</code> on every object in the job's manifest.</p>
    pub s3_replicate_object: std::option::Option<crate::model::S3ReplicateObjectOperation>,
}
impl JobOperation {
    /// <p>Directs the specified job to invoke an Lambda function on every object in the manifest.</p>
    pub fn lambda_invoke(&self) -> std::option::Option<&crate::model::LambdaInvokeOperation> {
        self.lambda_invoke.as_ref()
    }
    /// <p>Directs the specified job to run a PUT Copy object call on every object in the manifest.</p>
    pub fn s3_put_object_copy(&self) -> std::option::Option<&crate::model::S3CopyObjectOperation> {
        self.s3_put_object_copy.as_ref()
    }
    /// <p>Directs the specified job to run a PUT Object acl call on every object in the manifest.</p>
    pub fn s3_put_object_acl(&self) -> std::option::Option<&crate::model::S3SetObjectAclOperation> {
        self.s3_put_object_acl.as_ref()
    }
    /// <p>Directs the specified job to run a PUT Object tagging call on every object in the manifest.</p>
    pub fn s3_put_object_tagging(
        &self,
    ) -> std::option::Option<&crate::model::S3SetObjectTaggingOperation> {
        self.s3_put_object_tagging.as_ref()
    }
    /// <p>Directs the specified job to execute a DELETE Object tagging call on every object in the manifest.</p>
    pub fn s3_delete_object_tagging(
        &self,
    ) -> std::option::Option<&crate::model::S3DeleteObjectTaggingOperation> {
        self.s3_delete_object_tagging.as_ref()
    }
    /// <p>Directs the specified job to initiate restore requests for every archived object in the manifest.</p>
    pub fn s3_initiate_restore_object(
        &self,
    ) -> std::option::Option<&crate::model::S3InitiateRestoreObjectOperation> {
        self.s3_initiate_restore_object.as_ref()
    }
    /// <p>Contains the configuration for an S3 Object Lock legal hold operation that an S3 Batch Operations job passes every object to the underlying <code>PutObjectLegalHold</code> API. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-legal-hold.html">Using S3 Object Lock legal hold with S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn s3_put_object_legal_hold(
        &self,
    ) -> std::option::Option<&crate::model::S3SetObjectLegalHoldOperation> {
        self.s3_put_object_legal_hold.as_ref()
    }
    /// <p>Contains the configuration parameters for the Object Lock retention action for an S3 Batch Operations job. Batch Operations passes every object to the underlying <code>PutObjectRetention</code> API. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html">Using S3 Object Lock retention with S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn s3_put_object_retention(
        &self,
    ) -> std::option::Option<&crate::model::S3SetObjectRetentionOperation> {
        self.s3_put_object_retention.as_ref()
    }
    /// <p>Directs the specified job to invoke <code>ReplicateObject</code> on every object in the job's manifest.</p>
    pub fn s3_replicate_object(
        &self,
    ) -> std::option::Option<&crate::model::S3ReplicateObjectOperation> {
        self.s3_replicate_object.as_ref()
    }
}
impl std::fmt::Debug for JobOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobOperation");
        formatter.field("lambda_invoke", &self.lambda_invoke);
        formatter.field("s3_put_object_copy", &self.s3_put_object_copy);
        formatter.field("s3_put_object_acl", &self.s3_put_object_acl);
        formatter.field("s3_put_object_tagging", &self.s3_put_object_tagging);
        formatter.field("s3_delete_object_tagging", &self.s3_delete_object_tagging);
        formatter.field(
            "s3_initiate_restore_object",
            &self.s3_initiate_restore_object,
        );
        formatter.field("s3_put_object_legal_hold", &self.s3_put_object_legal_hold);
        formatter.field("s3_put_object_retention", &self.s3_put_object_retention);
        formatter.field("s3_replicate_object", &self.s3_replicate_object);
        formatter.finish()
    }
}
/// See [`JobOperation`](crate::model::JobOperation)
pub mod job_operation {
    /// A builder for [`JobOperation`](crate::model::JobOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lambda_invoke: std::option::Option<crate::model::LambdaInvokeOperation>,
        pub(crate) s3_put_object_copy: std::option::Option<crate::model::S3CopyObjectOperation>,
        pub(crate) s3_put_object_acl: std::option::Option<crate::model::S3SetObjectAclOperation>,
        pub(crate) s3_put_object_tagging:
            std::option::Option<crate::model::S3SetObjectTaggingOperation>,
        pub(crate) s3_delete_object_tagging:
            std::option::Option<crate::model::S3DeleteObjectTaggingOperation>,
        pub(crate) s3_initiate_restore_object:
            std::option::Option<crate::model::S3InitiateRestoreObjectOperation>,
        pub(crate) s3_put_object_legal_hold:
            std::option::Option<crate::model::S3SetObjectLegalHoldOperation>,
        pub(crate) s3_put_object_retention:
            std::option::Option<crate::model::S3SetObjectRetentionOperation>,
        pub(crate) s3_replicate_object:
            std::option::Option<crate::model::S3ReplicateObjectOperation>,
    }
    impl Builder {
        /// <p>Directs the specified job to invoke an Lambda function on every object in the manifest.</p>
        pub fn lambda_invoke(mut self, input: crate::model::LambdaInvokeOperation) -> Self {
            self.lambda_invoke = Some(input);
            self
        }
        /// <p>Directs the specified job to invoke an Lambda function on every object in the manifest.</p>
        pub fn set_lambda_invoke(
            mut self,
            input: std::option::Option<crate::model::LambdaInvokeOperation>,
        ) -> Self {
            self.lambda_invoke = input;
            self
        }
        /// <p>Directs the specified job to run a PUT Copy object call on every object in the manifest.</p>
        pub fn s3_put_object_copy(mut self, input: crate::model::S3CopyObjectOperation) -> Self {
            self.s3_put_object_copy = Some(input);
            self
        }
        /// <p>Directs the specified job to run a PUT Copy object call on every object in the manifest.</p>
        pub fn set_s3_put_object_copy(
            mut self,
            input: std::option::Option<crate::model::S3CopyObjectOperation>,
        ) -> Self {
            self.s3_put_object_copy = input;
            self
        }
        /// <p>Directs the specified job to run a PUT Object acl call on every object in the manifest.</p>
        pub fn s3_put_object_acl(mut self, input: crate::model::S3SetObjectAclOperation) -> Self {
            self.s3_put_object_acl = Some(input);
            self
        }
        /// <p>Directs the specified job to run a PUT Object acl call on every object in the manifest.</p>
        pub fn set_s3_put_object_acl(
            mut self,
            input: std::option::Option<crate::model::S3SetObjectAclOperation>,
        ) -> Self {
            self.s3_put_object_acl = input;
            self
        }
        /// <p>Directs the specified job to run a PUT Object tagging call on every object in the manifest.</p>
        pub fn s3_put_object_tagging(
            mut self,
            input: crate::model::S3SetObjectTaggingOperation,
        ) -> Self {
            self.s3_put_object_tagging = Some(input);
            self
        }
        /// <p>Directs the specified job to run a PUT Object tagging call on every object in the manifest.</p>
        pub fn set_s3_put_object_tagging(
            mut self,
            input: std::option::Option<crate::model::S3SetObjectTaggingOperation>,
        ) -> Self {
            self.s3_put_object_tagging = input;
            self
        }
        /// <p>Directs the specified job to execute a DELETE Object tagging call on every object in the manifest.</p>
        pub fn s3_delete_object_tagging(
            mut self,
            input: crate::model::S3DeleteObjectTaggingOperation,
        ) -> Self {
            self.s3_delete_object_tagging = Some(input);
            self
        }
        /// <p>Directs the specified job to execute a DELETE Object tagging call on every object in the manifest.</p>
        pub fn set_s3_delete_object_tagging(
            mut self,
            input: std::option::Option<crate::model::S3DeleteObjectTaggingOperation>,
        ) -> Self {
            self.s3_delete_object_tagging = input;
            self
        }
        /// <p>Directs the specified job to initiate restore requests for every archived object in the manifest.</p>
        pub fn s3_initiate_restore_object(
            mut self,
            input: crate::model::S3InitiateRestoreObjectOperation,
        ) -> Self {
            self.s3_initiate_restore_object = Some(input);
            self
        }
        /// <p>Directs the specified job to initiate restore requests for every archived object in the manifest.</p>
        pub fn set_s3_initiate_restore_object(
            mut self,
            input: std::option::Option<crate::model::S3InitiateRestoreObjectOperation>,
        ) -> Self {
            self.s3_initiate_restore_object = input;
            self
        }
        /// <p>Contains the configuration for an S3 Object Lock legal hold operation that an S3 Batch Operations job passes every object to the underlying <code>PutObjectLegalHold</code> API. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-legal-hold.html">Using S3 Object Lock legal hold with S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn s3_put_object_legal_hold(
            mut self,
            input: crate::model::S3SetObjectLegalHoldOperation,
        ) -> Self {
            self.s3_put_object_legal_hold = Some(input);
            self
        }
        /// <p>Contains the configuration for an S3 Object Lock legal hold operation that an S3 Batch Operations job passes every object to the underlying <code>PutObjectLegalHold</code> API. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-legal-hold.html">Using S3 Object Lock legal hold with S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_s3_put_object_legal_hold(
            mut self,
            input: std::option::Option<crate::model::S3SetObjectLegalHoldOperation>,
        ) -> Self {
            self.s3_put_object_legal_hold = input;
            self
        }
        /// <p>Contains the configuration parameters for the Object Lock retention action for an S3 Batch Operations job. Batch Operations passes every object to the underlying <code>PutObjectRetention</code> API. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html">Using S3 Object Lock retention with S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn s3_put_object_retention(
            mut self,
            input: crate::model::S3SetObjectRetentionOperation,
        ) -> Self {
            self.s3_put_object_retention = Some(input);
            self
        }
        /// <p>Contains the configuration parameters for the Object Lock retention action for an S3 Batch Operations job. Batch Operations passes every object to the underlying <code>PutObjectRetention</code> API. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html">Using S3 Object Lock retention with S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_s3_put_object_retention(
            mut self,
            input: std::option::Option<crate::model::S3SetObjectRetentionOperation>,
        ) -> Self {
            self.s3_put_object_retention = input;
            self
        }
        /// <p>Directs the specified job to invoke <code>ReplicateObject</code> on every object in the job's manifest.</p>
        pub fn s3_replicate_object(
            mut self,
            input: crate::model::S3ReplicateObjectOperation,
        ) -> Self {
            self.s3_replicate_object = Some(input);
            self
        }
        /// <p>Directs the specified job to invoke <code>ReplicateObject</code> on every object in the job's manifest.</p>
        pub fn set_s3_replicate_object(
            mut self,
            input: std::option::Option<crate::model::S3ReplicateObjectOperation>,
        ) -> Self {
            self.s3_replicate_object = input;
            self
        }
        /// Consumes the builder and constructs a [`JobOperation`](crate::model::JobOperation)
        pub fn build(self) -> crate::model::JobOperation {
            crate::model::JobOperation {
                lambda_invoke: self.lambda_invoke,
                s3_put_object_copy: self.s3_put_object_copy,
                s3_put_object_acl: self.s3_put_object_acl,
                s3_put_object_tagging: self.s3_put_object_tagging,
                s3_delete_object_tagging: self.s3_delete_object_tagging,
                s3_initiate_restore_object: self.s3_initiate_restore_object,
                s3_put_object_legal_hold: self.s3_put_object_legal_hold,
                s3_put_object_retention: self.s3_put_object_retention,
                s3_replicate_object: self.s3_replicate_object,
            }
        }
    }
}
impl JobOperation {
    /// Creates a new builder-style object to manufacture [`JobOperation`](crate::model::JobOperation)
    pub fn builder() -> crate::model::job_operation::Builder {
        crate::model::job_operation::Builder::default()
    }
}

/// <p>Directs the specified job to invoke <code>ReplicateObject</code> on every object in the job's manifest.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3ReplicateObjectOperation {}
impl std::fmt::Debug for S3ReplicateObjectOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3ReplicateObjectOperation");
        formatter.finish()
    }
}
/// See [`S3ReplicateObjectOperation`](crate::model::S3ReplicateObjectOperation)
pub mod s3_replicate_object_operation {
    /// A builder for [`S3ReplicateObjectOperation`](crate::model::S3ReplicateObjectOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`S3ReplicateObjectOperation`](crate::model::S3ReplicateObjectOperation)
        pub fn build(self) -> crate::model::S3ReplicateObjectOperation {
            crate::model::S3ReplicateObjectOperation {}
        }
    }
}
impl S3ReplicateObjectOperation {
    /// Creates a new builder-style object to manufacture [`S3ReplicateObjectOperation`](crate::model::S3ReplicateObjectOperation)
    pub fn builder() -> crate::model::s3_replicate_object_operation::Builder {
        crate::model::s3_replicate_object_operation::Builder::default()
    }
}

/// <p>Contains the configuration parameters for the Object Lock retention action for an S3 Batch Operations job. Batch Operations passes every object to the underlying <code>PutObjectRetention</code> API. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html">Using S3 Object Lock retention with S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3SetObjectRetentionOperation {
    /// <p>Indicates if the action should be applied to objects in the Batch Operations job even if they have Object Lock <code> GOVERNANCE</code> type in place.</p>
    pub bypass_governance_retention: std::option::Option<bool>,
    /// <p>Contains the Object Lock retention mode to be applied to all objects in the Batch Operations job. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html">Using S3 Object Lock retention with S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub retention: std::option::Option<crate::model::S3Retention>,
}
impl S3SetObjectRetentionOperation {
    /// <p>Indicates if the action should be applied to objects in the Batch Operations job even if they have Object Lock <code> GOVERNANCE</code> type in place.</p>
    pub fn bypass_governance_retention(&self) -> std::option::Option<bool> {
        self.bypass_governance_retention
    }
    /// <p>Contains the Object Lock retention mode to be applied to all objects in the Batch Operations job. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html">Using S3 Object Lock retention with S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn retention(&self) -> std::option::Option<&crate::model::S3Retention> {
        self.retention.as_ref()
    }
}
impl std::fmt::Debug for S3SetObjectRetentionOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3SetObjectRetentionOperation");
        formatter.field(
            "bypass_governance_retention",
            &self.bypass_governance_retention,
        );
        formatter.field("retention", &self.retention);
        formatter.finish()
    }
}
/// See [`S3SetObjectRetentionOperation`](crate::model::S3SetObjectRetentionOperation)
pub mod s3_set_object_retention_operation {
    /// A builder for [`S3SetObjectRetentionOperation`](crate::model::S3SetObjectRetentionOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bypass_governance_retention: std::option::Option<bool>,
        pub(crate) retention: std::option::Option<crate::model::S3Retention>,
    }
    impl Builder {
        /// <p>Indicates if the action should be applied to objects in the Batch Operations job even if they have Object Lock <code> GOVERNANCE</code> type in place.</p>
        pub fn bypass_governance_retention(mut self, input: bool) -> Self {
            self.bypass_governance_retention = Some(input);
            self
        }
        /// <p>Indicates if the action should be applied to objects in the Batch Operations job even if they have Object Lock <code> GOVERNANCE</code> type in place.</p>
        pub fn set_bypass_governance_retention(mut self, input: std::option::Option<bool>) -> Self {
            self.bypass_governance_retention = input;
            self
        }
        /// <p>Contains the Object Lock retention mode to be applied to all objects in the Batch Operations job. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html">Using S3 Object Lock retention with S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn retention(mut self, input: crate::model::S3Retention) -> Self {
            self.retention = Some(input);
            self
        }
        /// <p>Contains the Object Lock retention mode to be applied to all objects in the Batch Operations job. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html">Using S3 Object Lock retention with S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_retention(
            mut self,
            input: std::option::Option<crate::model::S3Retention>,
        ) -> Self {
            self.retention = input;
            self
        }
        /// Consumes the builder and constructs a [`S3SetObjectRetentionOperation`](crate::model::S3SetObjectRetentionOperation)
        pub fn build(self) -> crate::model::S3SetObjectRetentionOperation {
            crate::model::S3SetObjectRetentionOperation {
                bypass_governance_retention: self.bypass_governance_retention,
                retention: self.retention,
            }
        }
    }
}
impl S3SetObjectRetentionOperation {
    /// Creates a new builder-style object to manufacture [`S3SetObjectRetentionOperation`](crate::model::S3SetObjectRetentionOperation)
    pub fn builder() -> crate::model::s3_set_object_retention_operation::Builder {
        crate::model::s3_set_object_retention_operation::Builder::default()
    }
}

/// <p>Contains the S3 Object Lock retention mode to be applied to all objects in the S3 Batch Operations job. If you don't provide <code>Mode</code> and <code>RetainUntilDate</code> data types in your operation, you will remove the retention from your objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html">Using S3 Object Lock retention with S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Retention {
    /// <p>The date when the applied Object Lock retention will expire on all objects set by the Batch Operations job.</p>
    pub retain_until_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Object Lock retention mode to be applied to all objects in the Batch Operations job.</p>
    pub mode: std::option::Option<crate::model::S3ObjectLockRetentionMode>,
}
impl S3Retention {
    /// <p>The date when the applied Object Lock retention will expire on all objects set by the Batch Operations job.</p>
    pub fn retain_until_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.retain_until_date.as_ref()
    }
    /// <p>The Object Lock retention mode to be applied to all objects in the Batch Operations job.</p>
    pub fn mode(&self) -> std::option::Option<&crate::model::S3ObjectLockRetentionMode> {
        self.mode.as_ref()
    }
}
impl std::fmt::Debug for S3Retention {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Retention");
        formatter.field("retain_until_date", &self.retain_until_date);
        formatter.field("mode", &self.mode);
        formatter.finish()
    }
}
/// See [`S3Retention`](crate::model::S3Retention)
pub mod s3_retention {
    /// A builder for [`S3Retention`](crate::model::S3Retention)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) retain_until_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) mode: std::option::Option<crate::model::S3ObjectLockRetentionMode>,
    }
    impl Builder {
        /// <p>The date when the applied Object Lock retention will expire on all objects set by the Batch Operations job.</p>
        pub fn retain_until_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.retain_until_date = Some(input);
            self
        }
        /// <p>The date when the applied Object Lock retention will expire on all objects set by the Batch Operations job.</p>
        pub fn set_retain_until_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.retain_until_date = input;
            self
        }
        /// <p>The Object Lock retention mode to be applied to all objects in the Batch Operations job.</p>
        pub fn mode(mut self, input: crate::model::S3ObjectLockRetentionMode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>The Object Lock retention mode to be applied to all objects in the Batch Operations job.</p>
        pub fn set_mode(
            mut self,
            input: std::option::Option<crate::model::S3ObjectLockRetentionMode>,
        ) -> Self {
            self.mode = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Retention`](crate::model::S3Retention)
        pub fn build(self) -> crate::model::S3Retention {
            crate::model::S3Retention {
                retain_until_date: self.retain_until_date,
                mode: self.mode,
            }
        }
    }
}
impl S3Retention {
    /// Creates a new builder-style object to manufacture [`S3Retention`](crate::model::S3Retention)
    pub fn builder() -> crate::model::s3_retention::Builder {
        crate::model::s3_retention::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum S3ObjectLockRetentionMode {
    #[allow(missing_docs)] // documentation missing in model
    Compliance,
    #[allow(missing_docs)] // documentation missing in model
    Governance,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for S3ObjectLockRetentionMode {
    fn from(s: &str) -> Self {
        match s {
            "COMPLIANCE" => S3ObjectLockRetentionMode::Compliance,
            "GOVERNANCE" => S3ObjectLockRetentionMode::Governance,
            other => S3ObjectLockRetentionMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for S3ObjectLockRetentionMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(S3ObjectLockRetentionMode::from(s))
    }
}
impl S3ObjectLockRetentionMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            S3ObjectLockRetentionMode::Compliance => "COMPLIANCE",
            S3ObjectLockRetentionMode::Governance => "GOVERNANCE",
            S3ObjectLockRetentionMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLIANCE", "GOVERNANCE"]
    }
}
impl AsRef<str> for S3ObjectLockRetentionMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the configuration for an S3 Object Lock legal hold operation that an S3 Batch Operations job passes every object to the underlying <code>PutObjectLegalHold</code> API. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-legal-hold.html">Using S3 Object Lock legal hold with S3 Batch Operations</a> in the <i>Amazon S3 User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3SetObjectLegalHoldOperation {
    /// <p>Contains the Object Lock legal hold status to be applied to all objects in the Batch Operations job.</p>
    pub legal_hold: std::option::Option<crate::model::S3ObjectLockLegalHold>,
}
impl S3SetObjectLegalHoldOperation {
    /// <p>Contains the Object Lock legal hold status to be applied to all objects in the Batch Operations job.</p>
    pub fn legal_hold(&self) -> std::option::Option<&crate::model::S3ObjectLockLegalHold> {
        self.legal_hold.as_ref()
    }
}
impl std::fmt::Debug for S3SetObjectLegalHoldOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3SetObjectLegalHoldOperation");
        formatter.field("legal_hold", &self.legal_hold);
        formatter.finish()
    }
}
/// See [`S3SetObjectLegalHoldOperation`](crate::model::S3SetObjectLegalHoldOperation)
pub mod s3_set_object_legal_hold_operation {
    /// A builder for [`S3SetObjectLegalHoldOperation`](crate::model::S3SetObjectLegalHoldOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) legal_hold: std::option::Option<crate::model::S3ObjectLockLegalHold>,
    }
    impl Builder {
        /// <p>Contains the Object Lock legal hold status to be applied to all objects in the Batch Operations job.</p>
        pub fn legal_hold(mut self, input: crate::model::S3ObjectLockLegalHold) -> Self {
            self.legal_hold = Some(input);
            self
        }
        /// <p>Contains the Object Lock legal hold status to be applied to all objects in the Batch Operations job.</p>
        pub fn set_legal_hold(
            mut self,
            input: std::option::Option<crate::model::S3ObjectLockLegalHold>,
        ) -> Self {
            self.legal_hold = input;
            self
        }
        /// Consumes the builder and constructs a [`S3SetObjectLegalHoldOperation`](crate::model::S3SetObjectLegalHoldOperation)
        pub fn build(self) -> crate::model::S3SetObjectLegalHoldOperation {
            crate::model::S3SetObjectLegalHoldOperation {
                legal_hold: self.legal_hold,
            }
        }
    }
}
impl S3SetObjectLegalHoldOperation {
    /// Creates a new builder-style object to manufacture [`S3SetObjectLegalHoldOperation`](crate::model::S3SetObjectLegalHoldOperation)
    pub fn builder() -> crate::model::s3_set_object_legal_hold_operation::Builder {
        crate::model::s3_set_object_legal_hold_operation::Builder::default()
    }
}

/// <p>Whether S3 Object Lock legal hold will be applied to objects in an S3 Batch Operations job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3ObjectLockLegalHold {
    /// <p>The Object Lock legal hold status to be applied to all objects in the Batch Operations job.</p>
    pub status: std::option::Option<crate::model::S3ObjectLockLegalHoldStatus>,
}
impl S3ObjectLockLegalHold {
    /// <p>The Object Lock legal hold status to be applied to all objects in the Batch Operations job.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::S3ObjectLockLegalHoldStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for S3ObjectLockLegalHold {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3ObjectLockLegalHold");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`S3ObjectLockLegalHold`](crate::model::S3ObjectLockLegalHold)
pub mod s3_object_lock_legal_hold {
    /// A builder for [`S3ObjectLockLegalHold`](crate::model::S3ObjectLockLegalHold)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::S3ObjectLockLegalHoldStatus>,
    }
    impl Builder {
        /// <p>The Object Lock legal hold status to be applied to all objects in the Batch Operations job.</p>
        pub fn status(mut self, input: crate::model::S3ObjectLockLegalHoldStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The Object Lock legal hold status to be applied to all objects in the Batch Operations job.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::S3ObjectLockLegalHoldStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`S3ObjectLockLegalHold`](crate::model::S3ObjectLockLegalHold)
        pub fn build(self) -> crate::model::S3ObjectLockLegalHold {
            crate::model::S3ObjectLockLegalHold {
                status: self.status,
            }
        }
    }
}
impl S3ObjectLockLegalHold {
    /// Creates a new builder-style object to manufacture [`S3ObjectLockLegalHold`](crate::model::S3ObjectLockLegalHold)
    pub fn builder() -> crate::model::s3_object_lock_legal_hold::Builder {
        crate::model::s3_object_lock_legal_hold::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum S3ObjectLockLegalHoldStatus {
    #[allow(missing_docs)] // documentation missing in model
    Off,
    #[allow(missing_docs)] // documentation missing in model
    On,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for S3ObjectLockLegalHoldStatus {
    fn from(s: &str) -> Self {
        match s {
            "OFF" => S3ObjectLockLegalHoldStatus::Off,
            "ON" => S3ObjectLockLegalHoldStatus::On,
            other => S3ObjectLockLegalHoldStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for S3ObjectLockLegalHoldStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(S3ObjectLockLegalHoldStatus::from(s))
    }
}
impl S3ObjectLockLegalHoldStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            S3ObjectLockLegalHoldStatus::Off => "OFF",
            S3ObjectLockLegalHoldStatus::On => "ON",
            S3ObjectLockLegalHoldStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OFF", "ON"]
    }
}
impl AsRef<str> for S3ObjectLockLegalHoldStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the configuration parameters for an S3 Initiate Restore Object job. S3 Batch Operations passes every object to the underlying POST Object restore API. For more information about the parameters for this operation, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPOSTrestore.html#RESTObjectPOSTrestore-restore-request">RestoreObject</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3InitiateRestoreObjectOperation {
    /// <p>This argument specifies how long the S3 Glacier or S3 Glacier Deep Archive object remains available in Amazon S3. S3 Initiate Restore Object jobs that target S3 Glacier and S3 Glacier Deep Archive objects require <code>ExpirationInDays</code> set to 1 or greater.</p>
    /// <p>Conversely, do <i>not</i> set <code>ExpirationInDays</code> when creating S3 Initiate Restore Object jobs that target S3 Intelligent-Tiering Archive Access and Deep Archive Access tier objects. Objects in S3 Intelligent-Tiering archive access tiers are not subject to restore expiry, so specifying <code>ExpirationInDays</code> results in restore request failure.</p>
    /// <p>S3 Batch Operations jobs can operate either on S3 Glacier and S3 Glacier Deep Archive storage class objects or on S3 Intelligent-Tiering Archive Access and Deep Archive Access storage tier objects, but not both types in the same job. If you need to restore objects of both types you <i>must</i> create separate Batch Operations jobs. </p>
    pub expiration_in_days: std::option::Option<i32>,
    /// <p>S3 Batch Operations supports <code>STANDARD</code> and <code>BULK</code> retrieval tiers, but not the <code>EXPEDITED</code> retrieval tier.</p>
    pub glacier_job_tier: std::option::Option<crate::model::S3GlacierJobTier>,
}
impl S3InitiateRestoreObjectOperation {
    /// <p>This argument specifies how long the S3 Glacier or S3 Glacier Deep Archive object remains available in Amazon S3. S3 Initiate Restore Object jobs that target S3 Glacier and S3 Glacier Deep Archive objects require <code>ExpirationInDays</code> set to 1 or greater.</p>
    /// <p>Conversely, do <i>not</i> set <code>ExpirationInDays</code> when creating S3 Initiate Restore Object jobs that target S3 Intelligent-Tiering Archive Access and Deep Archive Access tier objects. Objects in S3 Intelligent-Tiering archive access tiers are not subject to restore expiry, so specifying <code>ExpirationInDays</code> results in restore request failure.</p>
    /// <p>S3 Batch Operations jobs can operate either on S3 Glacier and S3 Glacier Deep Archive storage class objects or on S3 Intelligent-Tiering Archive Access and Deep Archive Access storage tier objects, but not both types in the same job. If you need to restore objects of both types you <i>must</i> create separate Batch Operations jobs. </p>
    pub fn expiration_in_days(&self) -> std::option::Option<i32> {
        self.expiration_in_days
    }
    /// <p>S3 Batch Operations supports <code>STANDARD</code> and <code>BULK</code> retrieval tiers, but not the <code>EXPEDITED</code> retrieval tier.</p>
    pub fn glacier_job_tier(&self) -> std::option::Option<&crate::model::S3GlacierJobTier> {
        self.glacier_job_tier.as_ref()
    }
}
impl std::fmt::Debug for S3InitiateRestoreObjectOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3InitiateRestoreObjectOperation");
        formatter.field("expiration_in_days", &self.expiration_in_days);
        formatter.field("glacier_job_tier", &self.glacier_job_tier);
        formatter.finish()
    }
}
/// See [`S3InitiateRestoreObjectOperation`](crate::model::S3InitiateRestoreObjectOperation)
pub mod s3_initiate_restore_object_operation {
    /// A builder for [`S3InitiateRestoreObjectOperation`](crate::model::S3InitiateRestoreObjectOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) expiration_in_days: std::option::Option<i32>,
        pub(crate) glacier_job_tier: std::option::Option<crate::model::S3GlacierJobTier>,
    }
    impl Builder {
        /// <p>This argument specifies how long the S3 Glacier or S3 Glacier Deep Archive object remains available in Amazon S3. S3 Initiate Restore Object jobs that target S3 Glacier and S3 Glacier Deep Archive objects require <code>ExpirationInDays</code> set to 1 or greater.</p>
        /// <p>Conversely, do <i>not</i> set <code>ExpirationInDays</code> when creating S3 Initiate Restore Object jobs that target S3 Intelligent-Tiering Archive Access and Deep Archive Access tier objects. Objects in S3 Intelligent-Tiering archive access tiers are not subject to restore expiry, so specifying <code>ExpirationInDays</code> results in restore request failure.</p>
        /// <p>S3 Batch Operations jobs can operate either on S3 Glacier and S3 Glacier Deep Archive storage class objects or on S3 Intelligent-Tiering Archive Access and Deep Archive Access storage tier objects, but not both types in the same job. If you need to restore objects of both types you <i>must</i> create separate Batch Operations jobs. </p>
        pub fn expiration_in_days(mut self, input: i32) -> Self {
            self.expiration_in_days = Some(input);
            self
        }
        /// <p>This argument specifies how long the S3 Glacier or S3 Glacier Deep Archive object remains available in Amazon S3. S3 Initiate Restore Object jobs that target S3 Glacier and S3 Glacier Deep Archive objects require <code>ExpirationInDays</code> set to 1 or greater.</p>
        /// <p>Conversely, do <i>not</i> set <code>ExpirationInDays</code> when creating S3 Initiate Restore Object jobs that target S3 Intelligent-Tiering Archive Access and Deep Archive Access tier objects. Objects in S3 Intelligent-Tiering archive access tiers are not subject to restore expiry, so specifying <code>ExpirationInDays</code> results in restore request failure.</p>
        /// <p>S3 Batch Operations jobs can operate either on S3 Glacier and S3 Glacier Deep Archive storage class objects or on S3 Intelligent-Tiering Archive Access and Deep Archive Access storage tier objects, but not both types in the same job. If you need to restore objects of both types you <i>must</i> create separate Batch Operations jobs. </p>
        pub fn set_expiration_in_days(mut self, input: std::option::Option<i32>) -> Self {
            self.expiration_in_days = input;
            self
        }
        /// <p>S3 Batch Operations supports <code>STANDARD</code> and <code>BULK</code> retrieval tiers, but not the <code>EXPEDITED</code> retrieval tier.</p>
        pub fn glacier_job_tier(mut self, input: crate::model::S3GlacierJobTier) -> Self {
            self.glacier_job_tier = Some(input);
            self
        }
        /// <p>S3 Batch Operations supports <code>STANDARD</code> and <code>BULK</code> retrieval tiers, but not the <code>EXPEDITED</code> retrieval tier.</p>
        pub fn set_glacier_job_tier(
            mut self,
            input: std::option::Option<crate::model::S3GlacierJobTier>,
        ) -> Self {
            self.glacier_job_tier = input;
            self
        }
        /// Consumes the builder and constructs a [`S3InitiateRestoreObjectOperation`](crate::model::S3InitiateRestoreObjectOperation)
        pub fn build(self) -> crate::model::S3InitiateRestoreObjectOperation {
            crate::model::S3InitiateRestoreObjectOperation {
                expiration_in_days: self.expiration_in_days,
                glacier_job_tier: self.glacier_job_tier,
            }
        }
    }
}
impl S3InitiateRestoreObjectOperation {
    /// Creates a new builder-style object to manufacture [`S3InitiateRestoreObjectOperation`](crate::model::S3InitiateRestoreObjectOperation)
    pub fn builder() -> crate::model::s3_initiate_restore_object_operation::Builder {
        crate::model::s3_initiate_restore_object_operation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum S3GlacierJobTier {
    #[allow(missing_docs)] // documentation missing in model
    Bulk,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for S3GlacierJobTier {
    fn from(s: &str) -> Self {
        match s {
            "BULK" => S3GlacierJobTier::Bulk,
            "STANDARD" => S3GlacierJobTier::Standard,
            other => S3GlacierJobTier::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for S3GlacierJobTier {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(S3GlacierJobTier::from(s))
    }
}
impl S3GlacierJobTier {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            S3GlacierJobTier::Bulk => "BULK",
            S3GlacierJobTier::Standard => "STANDARD",
            S3GlacierJobTier::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BULK", "STANDARD"]
    }
}
impl AsRef<str> for S3GlacierJobTier {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains no configuration parameters because the DELETE Object tagging API only accepts the bucket name and key name as parameters, which are defined in the job's manifest.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3DeleteObjectTaggingOperation {}
impl std::fmt::Debug for S3DeleteObjectTaggingOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3DeleteObjectTaggingOperation");
        formatter.finish()
    }
}
/// See [`S3DeleteObjectTaggingOperation`](crate::model::S3DeleteObjectTaggingOperation)
pub mod s3_delete_object_tagging_operation {
    /// A builder for [`S3DeleteObjectTaggingOperation`](crate::model::S3DeleteObjectTaggingOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`S3DeleteObjectTaggingOperation`](crate::model::S3DeleteObjectTaggingOperation)
        pub fn build(self) -> crate::model::S3DeleteObjectTaggingOperation {
            crate::model::S3DeleteObjectTaggingOperation {}
        }
    }
}
impl S3DeleteObjectTaggingOperation {
    /// Creates a new builder-style object to manufacture [`S3DeleteObjectTaggingOperation`](crate::model::S3DeleteObjectTaggingOperation)
    pub fn builder() -> crate::model::s3_delete_object_tagging_operation::Builder {
        crate::model::s3_delete_object_tagging_operation::Builder::default()
    }
}

/// <p>Contains the configuration parameters for a Set Object Tagging operation. S3 Batch Operations passes every object to the underlying PUT Object tagging API. For more information about the parameters for this operation, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPUTtagging.html">PUT Object tagging</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3SetObjectTaggingOperation {
    /// <p></p>
    pub tag_set: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
}
impl S3SetObjectTaggingOperation {
    /// <p></p>
    pub fn tag_set(&self) -> std::option::Option<&[crate::model::S3Tag]> {
        self.tag_set.as_deref()
    }
}
impl std::fmt::Debug for S3SetObjectTaggingOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3SetObjectTaggingOperation");
        formatter.field("tag_set", &self.tag_set);
        formatter.finish()
    }
}
/// See [`S3SetObjectTaggingOperation`](crate::model::S3SetObjectTaggingOperation)
pub mod s3_set_object_tagging_operation {
    /// A builder for [`S3SetObjectTaggingOperation`](crate::model::S3SetObjectTaggingOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_set: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
    }
    impl Builder {
        /// Appends an item to `tag_set`.
        ///
        /// To override the contents of this collection use [`set_tag_set`](Self::set_tag_set).
        ///
        /// <p></p>
        pub fn tag_set(mut self, input: crate::model::S3Tag) -> Self {
            let mut v = self.tag_set.unwrap_or_default();
            v.push(input);
            self.tag_set = Some(v);
            self
        }
        /// <p></p>
        pub fn set_tag_set(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
        ) -> Self {
            self.tag_set = input;
            self
        }
        /// Consumes the builder and constructs a [`S3SetObjectTaggingOperation`](crate::model::S3SetObjectTaggingOperation)
        pub fn build(self) -> crate::model::S3SetObjectTaggingOperation {
            crate::model::S3SetObjectTaggingOperation {
                tag_set: self.tag_set,
            }
        }
    }
}
impl S3SetObjectTaggingOperation {
    /// Creates a new builder-style object to manufacture [`S3SetObjectTaggingOperation`](crate::model::S3SetObjectTaggingOperation)
    pub fn builder() -> crate::model::s3_set_object_tagging_operation::Builder {
        crate::model::s3_set_object_tagging_operation::Builder::default()
    }
}

/// <p>Contains the configuration parameters for a Set Object ACL operation. S3 Batch Operations passes every object to the underlying PUT Object acl API. For more information about the parameters for this operation, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPUTacl.html">PUT Object acl</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3SetObjectAclOperation {
    /// <p></p>
    pub access_control_policy: std::option::Option<crate::model::S3AccessControlPolicy>,
}
impl S3SetObjectAclOperation {
    /// <p></p>
    pub fn access_control_policy(
        &self,
    ) -> std::option::Option<&crate::model::S3AccessControlPolicy> {
        self.access_control_policy.as_ref()
    }
}
impl std::fmt::Debug for S3SetObjectAclOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3SetObjectAclOperation");
        formatter.field("access_control_policy", &self.access_control_policy);
        formatter.finish()
    }
}
/// See [`S3SetObjectAclOperation`](crate::model::S3SetObjectAclOperation)
pub mod s3_set_object_acl_operation {
    /// A builder for [`S3SetObjectAclOperation`](crate::model::S3SetObjectAclOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_control_policy: std::option::Option<crate::model::S3AccessControlPolicy>,
    }
    impl Builder {
        /// <p></p>
        pub fn access_control_policy(mut self, input: crate::model::S3AccessControlPolicy) -> Self {
            self.access_control_policy = Some(input);
            self
        }
        /// <p></p>
        pub fn set_access_control_policy(
            mut self,
            input: std::option::Option<crate::model::S3AccessControlPolicy>,
        ) -> Self {
            self.access_control_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`S3SetObjectAclOperation`](crate::model::S3SetObjectAclOperation)
        pub fn build(self) -> crate::model::S3SetObjectAclOperation {
            crate::model::S3SetObjectAclOperation {
                access_control_policy: self.access_control_policy,
            }
        }
    }
}
impl S3SetObjectAclOperation {
    /// Creates a new builder-style object to manufacture [`S3SetObjectAclOperation`](crate::model::S3SetObjectAclOperation)
    pub fn builder() -> crate::model::s3_set_object_acl_operation::Builder {
        crate::model::s3_set_object_acl_operation::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3AccessControlPolicy {
    /// <p></p>
    pub access_control_list: std::option::Option<crate::model::S3AccessControlList>,
    /// <p></p>
    pub canned_access_control_list: std::option::Option<crate::model::S3CannedAccessControlList>,
}
impl S3AccessControlPolicy {
    /// <p></p>
    pub fn access_control_list(&self) -> std::option::Option<&crate::model::S3AccessControlList> {
        self.access_control_list.as_ref()
    }
    /// <p></p>
    pub fn canned_access_control_list(
        &self,
    ) -> std::option::Option<&crate::model::S3CannedAccessControlList> {
        self.canned_access_control_list.as_ref()
    }
}
impl std::fmt::Debug for S3AccessControlPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3AccessControlPolicy");
        formatter.field("access_control_list", &self.access_control_list);
        formatter.field(
            "canned_access_control_list",
            &self.canned_access_control_list,
        );
        formatter.finish()
    }
}
/// See [`S3AccessControlPolicy`](crate::model::S3AccessControlPolicy)
pub mod s3_access_control_policy {
    /// A builder for [`S3AccessControlPolicy`](crate::model::S3AccessControlPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_control_list: std::option::Option<crate::model::S3AccessControlList>,
        pub(crate) canned_access_control_list:
            std::option::Option<crate::model::S3CannedAccessControlList>,
    }
    impl Builder {
        /// <p></p>
        pub fn access_control_list(mut self, input: crate::model::S3AccessControlList) -> Self {
            self.access_control_list = Some(input);
            self
        }
        /// <p></p>
        pub fn set_access_control_list(
            mut self,
            input: std::option::Option<crate::model::S3AccessControlList>,
        ) -> Self {
            self.access_control_list = input;
            self
        }
        /// <p></p>
        pub fn canned_access_control_list(
            mut self,
            input: crate::model::S3CannedAccessControlList,
        ) -> Self {
            self.canned_access_control_list = Some(input);
            self
        }
        /// <p></p>
        pub fn set_canned_access_control_list(
            mut self,
            input: std::option::Option<crate::model::S3CannedAccessControlList>,
        ) -> Self {
            self.canned_access_control_list = input;
            self
        }
        /// Consumes the builder and constructs a [`S3AccessControlPolicy`](crate::model::S3AccessControlPolicy)
        pub fn build(self) -> crate::model::S3AccessControlPolicy {
            crate::model::S3AccessControlPolicy {
                access_control_list: self.access_control_list,
                canned_access_control_list: self.canned_access_control_list,
            }
        }
    }
}
impl S3AccessControlPolicy {
    /// Creates a new builder-style object to manufacture [`S3AccessControlPolicy`](crate::model::S3AccessControlPolicy)
    pub fn builder() -> crate::model::s3_access_control_policy::Builder {
        crate::model::s3_access_control_policy::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum S3CannedAccessControlList {
    #[allow(missing_docs)] // documentation missing in model
    AuthenticatedRead,
    #[allow(missing_docs)] // documentation missing in model
    AwsExecRead,
    #[allow(missing_docs)] // documentation missing in model
    BucketOwnerFullControl,
    #[allow(missing_docs)] // documentation missing in model
    BucketOwnerRead,
    #[allow(missing_docs)] // documentation missing in model
    Private,
    #[allow(missing_docs)] // documentation missing in model
    PublicRead,
    #[allow(missing_docs)] // documentation missing in model
    PublicReadWrite,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for S3CannedAccessControlList {
    fn from(s: &str) -> Self {
        match s {
            "authenticated-read" => S3CannedAccessControlList::AuthenticatedRead,
            "aws-exec-read" => S3CannedAccessControlList::AwsExecRead,
            "bucket-owner-full-control" => S3CannedAccessControlList::BucketOwnerFullControl,
            "bucket-owner-read" => S3CannedAccessControlList::BucketOwnerRead,
            "private" => S3CannedAccessControlList::Private,
            "public-read" => S3CannedAccessControlList::PublicRead,
            "public-read-write" => S3CannedAccessControlList::PublicReadWrite,
            other => S3CannedAccessControlList::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for S3CannedAccessControlList {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(S3CannedAccessControlList::from(s))
    }
}
impl S3CannedAccessControlList {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            S3CannedAccessControlList::AuthenticatedRead => "authenticated-read",
            S3CannedAccessControlList::AwsExecRead => "aws-exec-read",
            S3CannedAccessControlList::BucketOwnerFullControl => "bucket-owner-full-control",
            S3CannedAccessControlList::BucketOwnerRead => "bucket-owner-read",
            S3CannedAccessControlList::Private => "private",
            S3CannedAccessControlList::PublicRead => "public-read",
            S3CannedAccessControlList::PublicReadWrite => "public-read-write",
            S3CannedAccessControlList::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "authenticated-read",
            "aws-exec-read",
            "bucket-owner-full-control",
            "bucket-owner-read",
            "private",
            "public-read",
            "public-read-write",
        ]
    }
}
impl AsRef<str> for S3CannedAccessControlList {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3AccessControlList {
    /// <p></p>
    pub owner: std::option::Option<crate::model::S3ObjectOwner>,
    /// <p></p>
    pub grants: std::option::Option<std::vec::Vec<crate::model::S3Grant>>,
}
impl S3AccessControlList {
    /// <p></p>
    pub fn owner(&self) -> std::option::Option<&crate::model::S3ObjectOwner> {
        self.owner.as_ref()
    }
    /// <p></p>
    pub fn grants(&self) -> std::option::Option<&[crate::model::S3Grant]> {
        self.grants.as_deref()
    }
}
impl std::fmt::Debug for S3AccessControlList {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3AccessControlList");
        formatter.field("owner", &self.owner);
        formatter.field("grants", &self.grants);
        formatter.finish()
    }
}
/// See [`S3AccessControlList`](crate::model::S3AccessControlList)
pub mod s3_access_control_list {
    /// A builder for [`S3AccessControlList`](crate::model::S3AccessControlList)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner: std::option::Option<crate::model::S3ObjectOwner>,
        pub(crate) grants: std::option::Option<std::vec::Vec<crate::model::S3Grant>>,
    }
    impl Builder {
        /// <p></p>
        pub fn owner(mut self, input: crate::model::S3ObjectOwner) -> Self {
            self.owner = Some(input);
            self
        }
        /// <p></p>
        pub fn set_owner(
            mut self,
            input: std::option::Option<crate::model::S3ObjectOwner>,
        ) -> Self {
            self.owner = input;
            self
        }
        /// Appends an item to `grants`.
        ///
        /// To override the contents of this collection use [`set_grants`](Self::set_grants).
        ///
        /// <p></p>
        pub fn grants(mut self, input: crate::model::S3Grant) -> Self {
            let mut v = self.grants.unwrap_or_default();
            v.push(input);
            self.grants = Some(v);
            self
        }
        /// <p></p>
        pub fn set_grants(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::S3Grant>>,
        ) -> Self {
            self.grants = input;
            self
        }
        /// Consumes the builder and constructs a [`S3AccessControlList`](crate::model::S3AccessControlList)
        pub fn build(self) -> crate::model::S3AccessControlList {
            crate::model::S3AccessControlList {
                owner: self.owner,
                grants: self.grants,
            }
        }
    }
}
impl S3AccessControlList {
    /// Creates a new builder-style object to manufacture [`S3AccessControlList`](crate::model::S3AccessControlList)
    pub fn builder() -> crate::model::s3_access_control_list::Builder {
        crate::model::s3_access_control_list::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Grant {
    /// <p></p>
    pub grantee: std::option::Option<crate::model::S3Grantee>,
    /// <p></p>
    pub permission: std::option::Option<crate::model::S3Permission>,
}
impl S3Grant {
    /// <p></p>
    pub fn grantee(&self) -> std::option::Option<&crate::model::S3Grantee> {
        self.grantee.as_ref()
    }
    /// <p></p>
    pub fn permission(&self) -> std::option::Option<&crate::model::S3Permission> {
        self.permission.as_ref()
    }
}
impl std::fmt::Debug for S3Grant {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Grant");
        formatter.field("grantee", &self.grantee);
        formatter.field("permission", &self.permission);
        formatter.finish()
    }
}
/// See [`S3Grant`](crate::model::S3Grant)
pub mod s3_grant {
    /// A builder for [`S3Grant`](crate::model::S3Grant)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) grantee: std::option::Option<crate::model::S3Grantee>,
        pub(crate) permission: std::option::Option<crate::model::S3Permission>,
    }
    impl Builder {
        /// <p></p>
        pub fn grantee(mut self, input: crate::model::S3Grantee) -> Self {
            self.grantee = Some(input);
            self
        }
        /// <p></p>
        pub fn set_grantee(mut self, input: std::option::Option<crate::model::S3Grantee>) -> Self {
            self.grantee = input;
            self
        }
        /// <p></p>
        pub fn permission(mut self, input: crate::model::S3Permission) -> Self {
            self.permission = Some(input);
            self
        }
        /// <p></p>
        pub fn set_permission(
            mut self,
            input: std::option::Option<crate::model::S3Permission>,
        ) -> Self {
            self.permission = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Grant`](crate::model::S3Grant)
        pub fn build(self) -> crate::model::S3Grant {
            crate::model::S3Grant {
                grantee: self.grantee,
                permission: self.permission,
            }
        }
    }
}
impl S3Grant {
    /// Creates a new builder-style object to manufacture [`S3Grant`](crate::model::S3Grant)
    pub fn builder() -> crate::model::s3_grant::Builder {
        crate::model::s3_grant::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum S3Permission {
    #[allow(missing_docs)] // documentation missing in model
    FullControl,
    #[allow(missing_docs)] // documentation missing in model
    Read,
    #[allow(missing_docs)] // documentation missing in model
    ReadAcp,
    #[allow(missing_docs)] // documentation missing in model
    Write,
    #[allow(missing_docs)] // documentation missing in model
    WriteAcp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for S3Permission {
    fn from(s: &str) -> Self {
        match s {
            "FULL_CONTROL" => S3Permission::FullControl,
            "READ" => S3Permission::Read,
            "READ_ACP" => S3Permission::ReadAcp,
            "WRITE" => S3Permission::Write,
            "WRITE_ACP" => S3Permission::WriteAcp,
            other => S3Permission::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for S3Permission {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(S3Permission::from(s))
    }
}
impl S3Permission {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            S3Permission::FullControl => "FULL_CONTROL",
            S3Permission::Read => "READ",
            S3Permission::ReadAcp => "READ_ACP",
            S3Permission::Write => "WRITE",
            S3Permission::WriteAcp => "WRITE_ACP",
            S3Permission::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FULL_CONTROL", "READ", "READ_ACP", "WRITE", "WRITE_ACP"]
    }
}
impl AsRef<str> for S3Permission {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Grantee {
    /// <p></p>
    pub type_identifier: std::option::Option<crate::model::S3GranteeTypeIdentifier>,
    /// <p></p>
    pub identifier: std::option::Option<std::string::String>,
    /// <p></p>
    pub display_name: std::option::Option<std::string::String>,
}
impl S3Grantee {
    /// <p></p>
    pub fn type_identifier(&self) -> std::option::Option<&crate::model::S3GranteeTypeIdentifier> {
        self.type_identifier.as_ref()
    }
    /// <p></p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
    /// <p></p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
}
impl std::fmt::Debug for S3Grantee {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Grantee");
        formatter.field("type_identifier", &self.type_identifier);
        formatter.field("identifier", &self.identifier);
        formatter.field("display_name", &self.display_name);
        formatter.finish()
    }
}
/// See [`S3Grantee`](crate::model::S3Grantee)
pub mod s3_grantee {
    /// A builder for [`S3Grantee`](crate::model::S3Grantee)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) type_identifier: std::option::Option<crate::model::S3GranteeTypeIdentifier>,
        pub(crate) identifier: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn type_identifier(mut self, input: crate::model::S3GranteeTypeIdentifier) -> Self {
            self.type_identifier = Some(input);
            self
        }
        /// <p></p>
        pub fn set_type_identifier(
            mut self,
            input: std::option::Option<crate::model::S3GranteeTypeIdentifier>,
        ) -> Self {
            self.type_identifier = input;
            self
        }
        /// <p></p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// <p></p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Grantee`](crate::model::S3Grantee)
        pub fn build(self) -> crate::model::S3Grantee {
            crate::model::S3Grantee {
                type_identifier: self.type_identifier,
                identifier: self.identifier,
                display_name: self.display_name,
            }
        }
    }
}
impl S3Grantee {
    /// Creates a new builder-style object to manufacture [`S3Grantee`](crate::model::S3Grantee)
    pub fn builder() -> crate::model::s3_grantee::Builder {
        crate::model::s3_grantee::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum S3GranteeTypeIdentifier {
    #[allow(missing_docs)] // documentation missing in model
    EmailAddress,
    #[allow(missing_docs)] // documentation missing in model
    Canonical,
    #[allow(missing_docs)] // documentation missing in model
    Group,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for S3GranteeTypeIdentifier {
    fn from(s: &str) -> Self {
        match s {
            "emailAddress" => S3GranteeTypeIdentifier::EmailAddress,
            "id" => S3GranteeTypeIdentifier::Canonical,
            "uri" => S3GranteeTypeIdentifier::Group,
            other => S3GranteeTypeIdentifier::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for S3GranteeTypeIdentifier {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(S3GranteeTypeIdentifier::from(s))
    }
}
impl S3GranteeTypeIdentifier {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            S3GranteeTypeIdentifier::EmailAddress => "emailAddress",
            S3GranteeTypeIdentifier::Canonical => "id",
            S3GranteeTypeIdentifier::Group => "uri",
            S3GranteeTypeIdentifier::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["emailAddress", "id", "uri"]
    }
}
impl AsRef<str> for S3GranteeTypeIdentifier {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3ObjectOwner {
    /// <p></p>
    pub id: std::option::Option<std::string::String>,
    /// <p></p>
    pub display_name: std::option::Option<std::string::String>,
}
impl S3ObjectOwner {
    /// <p></p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p></p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
}
impl std::fmt::Debug for S3ObjectOwner {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3ObjectOwner");
        formatter.field("id", &self.id);
        formatter.field("display_name", &self.display_name);
        formatter.finish()
    }
}
/// See [`S3ObjectOwner`](crate::model::S3ObjectOwner)
pub mod s3_object_owner {
    /// A builder for [`S3ObjectOwner`](crate::model::S3ObjectOwner)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p></p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// Consumes the builder and constructs a [`S3ObjectOwner`](crate::model::S3ObjectOwner)
        pub fn build(self) -> crate::model::S3ObjectOwner {
            crate::model::S3ObjectOwner {
                id: self.id,
                display_name: self.display_name,
            }
        }
    }
}
impl S3ObjectOwner {
    /// Creates a new builder-style object to manufacture [`S3ObjectOwner`](crate::model::S3ObjectOwner)
    pub fn builder() -> crate::model::s3_object_owner::Builder {
        crate::model::s3_object_owner::Builder::default()
    }
}

/// <p>Contains the configuration parameters for a PUT Copy object operation. S3 Batch Operations passes every object to the underlying PUT Copy object API. For more information about the parameters for this operation, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectCOPY.html">PUT Object - Copy</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3CopyObjectOperation {
    /// <p>Specifies the destination bucket ARN for the batch copy operation. For example, to copy objects to a bucket named "destinationBucket", set the TargetResource to "arn:aws:s3:::destinationBucket".</p>
    pub target_resource: std::option::Option<std::string::String>,
    /// <p></p>
    pub canned_access_control_list: std::option::Option<crate::model::S3CannedAccessControlList>,
    /// <p></p>
    pub access_control_grants: std::option::Option<std::vec::Vec<crate::model::S3Grant>>,
    /// <p></p>
    pub metadata_directive: std::option::Option<crate::model::S3MetadataDirective>,
    /// <p></p>
    pub modified_since_constraint: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>If you don't provide this parameter, Amazon S3 copies all the metadata from the original objects. If you specify an empty set, the new objects will have no tags. Otherwise, Amazon S3 assigns the supplied tags to the new objects.</p>
    pub new_object_metadata: std::option::Option<crate::model::S3ObjectMetadata>,
    /// <p></p>
    pub new_object_tagging: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
    /// <p>Specifies an optional metadata property for website redirects, <code>x-amz-website-redirect-location</code>. Allows webpage redirects if the object is accessed through a website endpoint.</p>
    pub redirect_location: std::option::Option<std::string::String>,
    /// <p></p>
    pub requester_pays: bool,
    /// <p></p>
    pub storage_class: std::option::Option<crate::model::S3StorageClass>,
    /// <p></p>
    pub un_modified_since_constraint: std::option::Option<aws_smithy_types::DateTime>,
    /// <p></p>
    pub sse_aws_kms_key_id: std::option::Option<std::string::String>,
    /// <p>Specifies the folder prefix into which you would like the objects to be copied. For example, to copy objects into a folder named <code>Folder1</code> in the destination bucket, set the TargetKeyPrefix to <code>Folder1</code>.</p>
    pub target_key_prefix: std::option::Option<std::string::String>,
    /// <p>The legal hold status to be applied to all objects in the Batch Operations job.</p>
    pub object_lock_legal_hold_status:
        std::option::Option<crate::model::S3ObjectLockLegalHoldStatus>,
    /// <p>The retention mode to be applied to all objects in the Batch Operations job.</p>
    pub object_lock_mode: std::option::Option<crate::model::S3ObjectLockMode>,
    /// <p>The date when the applied object retention configuration expires on all objects in the Batch Operations job.</p>
    pub object_lock_retain_until_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using Amazon Web Services KMS (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.</p>
    /// <p>Specifying this header with an <i>object</i> action doesn’t affect <i>bucket-level</i> settings for S3 Bucket Key.</p>
    pub bucket_key_enabled: bool,
    /// <p>Indicates the algorithm you want Amazon S3 to use to create the checksum. For more information see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CheckingObjectIntegrity.xml"> Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub checksum_algorithm: std::option::Option<crate::model::S3ChecksumAlgorithm>,
}
impl S3CopyObjectOperation {
    /// <p>Specifies the destination bucket ARN for the batch copy operation. For example, to copy objects to a bucket named "destinationBucket", set the TargetResource to "arn:aws:s3:::destinationBucket".</p>
    pub fn target_resource(&self) -> std::option::Option<&str> {
        self.target_resource.as_deref()
    }
    /// <p></p>
    pub fn canned_access_control_list(
        &self,
    ) -> std::option::Option<&crate::model::S3CannedAccessControlList> {
        self.canned_access_control_list.as_ref()
    }
    /// <p></p>
    pub fn access_control_grants(&self) -> std::option::Option<&[crate::model::S3Grant]> {
        self.access_control_grants.as_deref()
    }
    /// <p></p>
    pub fn metadata_directive(&self) -> std::option::Option<&crate::model::S3MetadataDirective> {
        self.metadata_directive.as_ref()
    }
    /// <p></p>
    pub fn modified_since_constraint(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.modified_since_constraint.as_ref()
    }
    /// <p>If you don't provide this parameter, Amazon S3 copies all the metadata from the original objects. If you specify an empty set, the new objects will have no tags. Otherwise, Amazon S3 assigns the supplied tags to the new objects.</p>
    pub fn new_object_metadata(&self) -> std::option::Option<&crate::model::S3ObjectMetadata> {
        self.new_object_metadata.as_ref()
    }
    /// <p></p>
    pub fn new_object_tagging(&self) -> std::option::Option<&[crate::model::S3Tag]> {
        self.new_object_tagging.as_deref()
    }
    /// <p>Specifies an optional metadata property for website redirects, <code>x-amz-website-redirect-location</code>. Allows webpage redirects if the object is accessed through a website endpoint.</p>
    pub fn redirect_location(&self) -> std::option::Option<&str> {
        self.redirect_location.as_deref()
    }
    /// <p></p>
    pub fn requester_pays(&self) -> bool {
        self.requester_pays
    }
    /// <p></p>
    pub fn storage_class(&self) -> std::option::Option<&crate::model::S3StorageClass> {
        self.storage_class.as_ref()
    }
    /// <p></p>
    pub fn un_modified_since_constraint(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.un_modified_since_constraint.as_ref()
    }
    /// <p></p>
    pub fn sse_aws_kms_key_id(&self) -> std::option::Option<&str> {
        self.sse_aws_kms_key_id.as_deref()
    }
    /// <p>Specifies the folder prefix into which you would like the objects to be copied. For example, to copy objects into a folder named <code>Folder1</code> in the destination bucket, set the TargetKeyPrefix to <code>Folder1</code>.</p>
    pub fn target_key_prefix(&self) -> std::option::Option<&str> {
        self.target_key_prefix.as_deref()
    }
    /// <p>The legal hold status to be applied to all objects in the Batch Operations job.</p>
    pub fn object_lock_legal_hold_status(
        &self,
    ) -> std::option::Option<&crate::model::S3ObjectLockLegalHoldStatus> {
        self.object_lock_legal_hold_status.as_ref()
    }
    /// <p>The retention mode to be applied to all objects in the Batch Operations job.</p>
    pub fn object_lock_mode(&self) -> std::option::Option<&crate::model::S3ObjectLockMode> {
        self.object_lock_mode.as_ref()
    }
    /// <p>The date when the applied object retention configuration expires on all objects in the Batch Operations job.</p>
    pub fn object_lock_retain_until_date(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.object_lock_retain_until_date.as_ref()
    }
    /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using Amazon Web Services KMS (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.</p>
    /// <p>Specifying this header with an <i>object</i> action doesn’t affect <i>bucket-level</i> settings for S3 Bucket Key.</p>
    pub fn bucket_key_enabled(&self) -> bool {
        self.bucket_key_enabled
    }
    /// <p>Indicates the algorithm you want Amazon S3 to use to create the checksum. For more information see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CheckingObjectIntegrity.xml"> Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn checksum_algorithm(&self) -> std::option::Option<&crate::model::S3ChecksumAlgorithm> {
        self.checksum_algorithm.as_ref()
    }
}
impl std::fmt::Debug for S3CopyObjectOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3CopyObjectOperation");
        formatter.field("target_resource", &self.target_resource);
        formatter.field(
            "canned_access_control_list",
            &self.canned_access_control_list,
        );
        formatter.field("access_control_grants", &self.access_control_grants);
        formatter.field("metadata_directive", &self.metadata_directive);
        formatter.field("modified_since_constraint", &self.modified_since_constraint);
        formatter.field("new_object_metadata", &self.new_object_metadata);
        formatter.field("new_object_tagging", &self.new_object_tagging);
        formatter.field("redirect_location", &self.redirect_location);
        formatter.field("requester_pays", &self.requester_pays);
        formatter.field("storage_class", &self.storage_class);
        formatter.field(
            "un_modified_since_constraint",
            &self.un_modified_since_constraint,
        );
        formatter.field("sse_aws_kms_key_id", &self.sse_aws_kms_key_id);
        formatter.field("target_key_prefix", &self.target_key_prefix);
        formatter.field(
            "object_lock_legal_hold_status",
            &self.object_lock_legal_hold_status,
        );
        formatter.field("object_lock_mode", &self.object_lock_mode);
        formatter.field(
            "object_lock_retain_until_date",
            &self.object_lock_retain_until_date,
        );
        formatter.field("bucket_key_enabled", &self.bucket_key_enabled);
        formatter.field("checksum_algorithm", &self.checksum_algorithm);
        formatter.finish()
    }
}
/// See [`S3CopyObjectOperation`](crate::model::S3CopyObjectOperation)
pub mod s3_copy_object_operation {
    /// A builder for [`S3CopyObjectOperation`](crate::model::S3CopyObjectOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_resource: std::option::Option<std::string::String>,
        pub(crate) canned_access_control_list:
            std::option::Option<crate::model::S3CannedAccessControlList>,
        pub(crate) access_control_grants: std::option::Option<std::vec::Vec<crate::model::S3Grant>>,
        pub(crate) metadata_directive: std::option::Option<crate::model::S3MetadataDirective>,
        pub(crate) modified_since_constraint: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) new_object_metadata: std::option::Option<crate::model::S3ObjectMetadata>,
        pub(crate) new_object_tagging: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
        pub(crate) redirect_location: std::option::Option<std::string::String>,
        pub(crate) requester_pays: std::option::Option<bool>,
        pub(crate) storage_class: std::option::Option<crate::model::S3StorageClass>,
        pub(crate) un_modified_since_constraint: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) sse_aws_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) target_key_prefix: std::option::Option<std::string::String>,
        pub(crate) object_lock_legal_hold_status:
            std::option::Option<crate::model::S3ObjectLockLegalHoldStatus>,
        pub(crate) object_lock_mode: std::option::Option<crate::model::S3ObjectLockMode>,
        pub(crate) object_lock_retain_until_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) bucket_key_enabled: std::option::Option<bool>,
        pub(crate) checksum_algorithm: std::option::Option<crate::model::S3ChecksumAlgorithm>,
    }
    impl Builder {
        /// <p>Specifies the destination bucket ARN for the batch copy operation. For example, to copy objects to a bucket named "destinationBucket", set the TargetResource to "arn:aws:s3:::destinationBucket".</p>
        pub fn target_resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_resource = Some(input.into());
            self
        }
        /// <p>Specifies the destination bucket ARN for the batch copy operation. For example, to copy objects to a bucket named "destinationBucket", set the TargetResource to "arn:aws:s3:::destinationBucket".</p>
        pub fn set_target_resource(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_resource = input;
            self
        }
        /// <p></p>
        pub fn canned_access_control_list(
            mut self,
            input: crate::model::S3CannedAccessControlList,
        ) -> Self {
            self.canned_access_control_list = Some(input);
            self
        }
        /// <p></p>
        pub fn set_canned_access_control_list(
            mut self,
            input: std::option::Option<crate::model::S3CannedAccessControlList>,
        ) -> Self {
            self.canned_access_control_list = input;
            self
        }
        /// Appends an item to `access_control_grants`.
        ///
        /// To override the contents of this collection use [`set_access_control_grants`](Self::set_access_control_grants).
        ///
        /// <p></p>
        pub fn access_control_grants(mut self, input: crate::model::S3Grant) -> Self {
            let mut v = self.access_control_grants.unwrap_or_default();
            v.push(input);
            self.access_control_grants = Some(v);
            self
        }
        /// <p></p>
        pub fn set_access_control_grants(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::S3Grant>>,
        ) -> Self {
            self.access_control_grants = input;
            self
        }
        /// <p></p>
        pub fn metadata_directive(mut self, input: crate::model::S3MetadataDirective) -> Self {
            self.metadata_directive = Some(input);
            self
        }
        /// <p></p>
        pub fn set_metadata_directive(
            mut self,
            input: std::option::Option<crate::model::S3MetadataDirective>,
        ) -> Self {
            self.metadata_directive = input;
            self
        }
        /// <p></p>
        pub fn modified_since_constraint(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.modified_since_constraint = Some(input);
            self
        }
        /// <p></p>
        pub fn set_modified_since_constraint(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.modified_since_constraint = input;
            self
        }
        /// <p>If you don't provide this parameter, Amazon S3 copies all the metadata from the original objects. If you specify an empty set, the new objects will have no tags. Otherwise, Amazon S3 assigns the supplied tags to the new objects.</p>
        pub fn new_object_metadata(mut self, input: crate::model::S3ObjectMetadata) -> Self {
            self.new_object_metadata = Some(input);
            self
        }
        /// <p>If you don't provide this parameter, Amazon S3 copies all the metadata from the original objects. If you specify an empty set, the new objects will have no tags. Otherwise, Amazon S3 assigns the supplied tags to the new objects.</p>
        pub fn set_new_object_metadata(
            mut self,
            input: std::option::Option<crate::model::S3ObjectMetadata>,
        ) -> Self {
            self.new_object_metadata = input;
            self
        }
        /// Appends an item to `new_object_tagging`.
        ///
        /// To override the contents of this collection use [`set_new_object_tagging`](Self::set_new_object_tagging).
        ///
        /// <p></p>
        pub fn new_object_tagging(mut self, input: crate::model::S3Tag) -> Self {
            let mut v = self.new_object_tagging.unwrap_or_default();
            v.push(input);
            self.new_object_tagging = Some(v);
            self
        }
        /// <p></p>
        pub fn set_new_object_tagging(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
        ) -> Self {
            self.new_object_tagging = input;
            self
        }
        /// <p>Specifies an optional metadata property for website redirects, <code>x-amz-website-redirect-location</code>. Allows webpage redirects if the object is accessed through a website endpoint.</p>
        pub fn redirect_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.redirect_location = Some(input.into());
            self
        }
        /// <p>Specifies an optional metadata property for website redirects, <code>x-amz-website-redirect-location</code>. Allows webpage redirects if the object is accessed through a website endpoint.</p>
        pub fn set_redirect_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.redirect_location = input;
            self
        }
        /// <p></p>
        pub fn requester_pays(mut self, input: bool) -> Self {
            self.requester_pays = Some(input);
            self
        }
        /// <p></p>
        pub fn set_requester_pays(mut self, input: std::option::Option<bool>) -> Self {
            self.requester_pays = input;
            self
        }
        /// <p></p>
        pub fn storage_class(mut self, input: crate::model::S3StorageClass) -> Self {
            self.storage_class = Some(input);
            self
        }
        /// <p></p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<crate::model::S3StorageClass>,
        ) -> Self {
            self.storage_class = input;
            self
        }
        /// <p></p>
        pub fn un_modified_since_constraint(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.un_modified_since_constraint = Some(input);
            self
        }
        /// <p></p>
        pub fn set_un_modified_since_constraint(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.un_modified_since_constraint = input;
            self
        }
        /// <p></p>
        pub fn sse_aws_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_aws_kms_key_id = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_sse_aws_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_aws_kms_key_id = input;
            self
        }
        /// <p>Specifies the folder prefix into which you would like the objects to be copied. For example, to copy objects into a folder named <code>Folder1</code> in the destination bucket, set the TargetKeyPrefix to <code>Folder1</code>.</p>
        pub fn target_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_key_prefix = Some(input.into());
            self
        }
        /// <p>Specifies the folder prefix into which you would like the objects to be copied. For example, to copy objects into a folder named <code>Folder1</code> in the destination bucket, set the TargetKeyPrefix to <code>Folder1</code>.</p>
        pub fn set_target_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_key_prefix = input;
            self
        }
        /// <p>The legal hold status to be applied to all objects in the Batch Operations job.</p>
        pub fn object_lock_legal_hold_status(
            mut self,
            input: crate::model::S3ObjectLockLegalHoldStatus,
        ) -> Self {
            self.object_lock_legal_hold_status = Some(input);
            self
        }
        /// <p>The legal hold status to be applied to all objects in the Batch Operations job.</p>
        pub fn set_object_lock_legal_hold_status(
            mut self,
            input: std::option::Option<crate::model::S3ObjectLockLegalHoldStatus>,
        ) -> Self {
            self.object_lock_legal_hold_status = input;
            self
        }
        /// <p>The retention mode to be applied to all objects in the Batch Operations job.</p>
        pub fn object_lock_mode(mut self, input: crate::model::S3ObjectLockMode) -> Self {
            self.object_lock_mode = Some(input);
            self
        }
        /// <p>The retention mode to be applied to all objects in the Batch Operations job.</p>
        pub fn set_object_lock_mode(
            mut self,
            input: std::option::Option<crate::model::S3ObjectLockMode>,
        ) -> Self {
            self.object_lock_mode = input;
            self
        }
        /// <p>The date when the applied object retention configuration expires on all objects in the Batch Operations job.</p>
        pub fn object_lock_retain_until_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.object_lock_retain_until_date = Some(input);
            self
        }
        /// <p>The date when the applied object retention configuration expires on all objects in the Batch Operations job.</p>
        pub fn set_object_lock_retain_until_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.object_lock_retain_until_date = input;
            self
        }
        /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using Amazon Web Services KMS (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.</p>
        /// <p>Specifying this header with an <i>object</i> action doesn’t affect <i>bucket-level</i> settings for S3 Bucket Key.</p>
        pub fn bucket_key_enabled(mut self, input: bool) -> Self {
            self.bucket_key_enabled = Some(input);
            self
        }
        /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using Amazon Web Services KMS (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.</p>
        /// <p>Specifying this header with an <i>object</i> action doesn’t affect <i>bucket-level</i> settings for S3 Bucket Key.</p>
        pub fn set_bucket_key_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.bucket_key_enabled = input;
            self
        }
        /// <p>Indicates the algorithm you want Amazon S3 to use to create the checksum. For more information see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CheckingObjectIntegrity.xml"> Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn checksum_algorithm(mut self, input: crate::model::S3ChecksumAlgorithm) -> Self {
            self.checksum_algorithm = Some(input);
            self
        }
        /// <p>Indicates the algorithm you want Amazon S3 to use to create the checksum. For more information see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CheckingObjectIntegrity.xml"> Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_checksum_algorithm(
            mut self,
            input: std::option::Option<crate::model::S3ChecksumAlgorithm>,
        ) -> Self {
            self.checksum_algorithm = input;
            self
        }
        /// Consumes the builder and constructs a [`S3CopyObjectOperation`](crate::model::S3CopyObjectOperation)
        pub fn build(self) -> crate::model::S3CopyObjectOperation {
            crate::model::S3CopyObjectOperation {
                target_resource: self.target_resource,
                canned_access_control_list: self.canned_access_control_list,
                access_control_grants: self.access_control_grants,
                metadata_directive: self.metadata_directive,
                modified_since_constraint: self.modified_since_constraint,
                new_object_metadata: self.new_object_metadata,
                new_object_tagging: self.new_object_tagging,
                redirect_location: self.redirect_location,
                requester_pays: self.requester_pays.unwrap_or_default(),
                storage_class: self.storage_class,
                un_modified_since_constraint: self.un_modified_since_constraint,
                sse_aws_kms_key_id: self.sse_aws_kms_key_id,
                target_key_prefix: self.target_key_prefix,
                object_lock_legal_hold_status: self.object_lock_legal_hold_status,
                object_lock_mode: self.object_lock_mode,
                object_lock_retain_until_date: self.object_lock_retain_until_date,
                bucket_key_enabled: self.bucket_key_enabled.unwrap_or_default(),
                checksum_algorithm: self.checksum_algorithm,
            }
        }
    }
}
impl S3CopyObjectOperation {
    /// Creates a new builder-style object to manufacture [`S3CopyObjectOperation`](crate::model::S3CopyObjectOperation)
    pub fn builder() -> crate::model::s3_copy_object_operation::Builder {
        crate::model::s3_copy_object_operation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum S3ChecksumAlgorithm {
    #[allow(missing_docs)] // documentation missing in model
    Crc32,
    #[allow(missing_docs)] // documentation missing in model
    Crc32C,
    #[allow(missing_docs)] // documentation missing in model
    Sha1,
    #[allow(missing_docs)] // documentation missing in model
    Sha256,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for S3ChecksumAlgorithm {
    fn from(s: &str) -> Self {
        match s {
            "CRC32" => S3ChecksumAlgorithm::Crc32,
            "CRC32C" => S3ChecksumAlgorithm::Crc32C,
            "SHA1" => S3ChecksumAlgorithm::Sha1,
            "SHA256" => S3ChecksumAlgorithm::Sha256,
            other => S3ChecksumAlgorithm::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for S3ChecksumAlgorithm {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(S3ChecksumAlgorithm::from(s))
    }
}
impl S3ChecksumAlgorithm {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            S3ChecksumAlgorithm::Crc32 => "CRC32",
            S3ChecksumAlgorithm::Crc32C => "CRC32C",
            S3ChecksumAlgorithm::Sha1 => "SHA1",
            S3ChecksumAlgorithm::Sha256 => "SHA256",
            S3ChecksumAlgorithm::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CRC32", "CRC32C", "SHA1", "SHA256"]
    }
}
impl AsRef<str> for S3ChecksumAlgorithm {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum S3ObjectLockMode {
    #[allow(missing_docs)] // documentation missing in model
    Compliance,
    #[allow(missing_docs)] // documentation missing in model
    Governance,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for S3ObjectLockMode {
    fn from(s: &str) -> Self {
        match s {
            "COMPLIANCE" => S3ObjectLockMode::Compliance,
            "GOVERNANCE" => S3ObjectLockMode::Governance,
            other => S3ObjectLockMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for S3ObjectLockMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(S3ObjectLockMode::from(s))
    }
}
impl S3ObjectLockMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            S3ObjectLockMode::Compliance => "COMPLIANCE",
            S3ObjectLockMode::Governance => "GOVERNANCE",
            S3ObjectLockMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLIANCE", "GOVERNANCE"]
    }
}
impl AsRef<str> for S3ObjectLockMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum S3StorageClass {
    #[allow(missing_docs)] // documentation missing in model
    DeepArchive,
    #[allow(missing_docs)] // documentation missing in model
    Glacier,
    #[allow(missing_docs)] // documentation missing in model
    GlacierIr,
    #[allow(missing_docs)] // documentation missing in model
    IntelligentTiering,
    #[allow(missing_docs)] // documentation missing in model
    OnezoneIa,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    #[allow(missing_docs)] // documentation missing in model
    StandardIa,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for S3StorageClass {
    fn from(s: &str) -> Self {
        match s {
            "DEEP_ARCHIVE" => S3StorageClass::DeepArchive,
            "GLACIER" => S3StorageClass::Glacier,
            "GLACIER_IR" => S3StorageClass::GlacierIr,
            "INTELLIGENT_TIERING" => S3StorageClass::IntelligentTiering,
            "ONEZONE_IA" => S3StorageClass::OnezoneIa,
            "STANDARD" => S3StorageClass::Standard,
            "STANDARD_IA" => S3StorageClass::StandardIa,
            other => S3StorageClass::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for S3StorageClass {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(S3StorageClass::from(s))
    }
}
impl S3StorageClass {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            S3StorageClass::DeepArchive => "DEEP_ARCHIVE",
            S3StorageClass::Glacier => "GLACIER",
            S3StorageClass::GlacierIr => "GLACIER_IR",
            S3StorageClass::IntelligentTiering => "INTELLIGENT_TIERING",
            S3StorageClass::OnezoneIa => "ONEZONE_IA",
            S3StorageClass::Standard => "STANDARD",
            S3StorageClass::StandardIa => "STANDARD_IA",
            S3StorageClass::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DEEP_ARCHIVE",
            "GLACIER",
            "GLACIER_IR",
            "INTELLIGENT_TIERING",
            "ONEZONE_IA",
            "STANDARD",
            "STANDARD_IA",
        ]
    }
}
impl AsRef<str> for S3StorageClass {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3ObjectMetadata {
    /// <p></p>
    pub cache_control: std::option::Option<std::string::String>,
    /// <p></p>
    pub content_disposition: std::option::Option<std::string::String>,
    /// <p></p>
    pub content_encoding: std::option::Option<std::string::String>,
    /// <p></p>
    pub content_language: std::option::Option<std::string::String>,
    /// <p></p>
    pub user_metadata:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p></p>
    pub content_length: std::option::Option<i64>,
    /// <p></p>
    pub content_md5: std::option::Option<std::string::String>,
    /// <p></p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p></p>
    pub http_expires_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p></p>
    pub requester_charged: bool,
    /// <p></p>
    pub sse_algorithm: std::option::Option<crate::model::S3SseAlgorithm>,
}
impl S3ObjectMetadata {
    /// <p></p>
    pub fn cache_control(&self) -> std::option::Option<&str> {
        self.cache_control.as_deref()
    }
    /// <p></p>
    pub fn content_disposition(&self) -> std::option::Option<&str> {
        self.content_disposition.as_deref()
    }
    /// <p></p>
    pub fn content_encoding(&self) -> std::option::Option<&str> {
        self.content_encoding.as_deref()
    }
    /// <p></p>
    pub fn content_language(&self) -> std::option::Option<&str> {
        self.content_language.as_deref()
    }
    /// <p></p>
    pub fn user_metadata(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.user_metadata.as_ref()
    }
    /// <p></p>
    pub fn content_length(&self) -> std::option::Option<i64> {
        self.content_length
    }
    /// <p></p>
    pub fn content_md5(&self) -> std::option::Option<&str> {
        self.content_md5.as_deref()
    }
    /// <p></p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p></p>
    pub fn http_expires_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.http_expires_date.as_ref()
    }
    /// <p></p>
    pub fn requester_charged(&self) -> bool {
        self.requester_charged
    }
    /// <p></p>
    pub fn sse_algorithm(&self) -> std::option::Option<&crate::model::S3SseAlgorithm> {
        self.sse_algorithm.as_ref()
    }
}
impl std::fmt::Debug for S3ObjectMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3ObjectMetadata");
        formatter.field("cache_control", &self.cache_control);
        formatter.field("content_disposition", &self.content_disposition);
        formatter.field("content_encoding", &self.content_encoding);
        formatter.field("content_language", &self.content_language);
        formatter.field("user_metadata", &self.user_metadata);
        formatter.field("content_length", &self.content_length);
        formatter.field("content_md5", &self.content_md5);
        formatter.field("content_type", &self.content_type);
        formatter.field("http_expires_date", &self.http_expires_date);
        formatter.field("requester_charged", &self.requester_charged);
        formatter.field("sse_algorithm", &self.sse_algorithm);
        formatter.finish()
    }
}
/// See [`S3ObjectMetadata`](crate::model::S3ObjectMetadata)
pub mod s3_object_metadata {
    /// A builder for [`S3ObjectMetadata`](crate::model::S3ObjectMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cache_control: std::option::Option<std::string::String>,
        pub(crate) content_disposition: std::option::Option<std::string::String>,
        pub(crate) content_encoding: std::option::Option<std::string::String>,
        pub(crate) content_language: std::option::Option<std::string::String>,
        pub(crate) user_metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) content_length: std::option::Option<i64>,
        pub(crate) content_md5: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) http_expires_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) requester_charged: std::option::Option<bool>,
        pub(crate) sse_algorithm: std::option::Option<crate::model::S3SseAlgorithm>,
    }
    impl Builder {
        /// <p></p>
        pub fn cache_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_control = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_cache_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_control = input;
            self
        }
        /// <p></p>
        pub fn content_disposition(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_disposition = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_content_disposition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_disposition = input;
            self
        }
        /// <p></p>
        pub fn content_encoding(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_encoding = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_content_encoding(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_encoding = input;
            self
        }
        /// <p></p>
        pub fn content_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_language = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_content_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_language = input;
            self
        }
        /// Adds a key-value pair to `user_metadata`.
        ///
        /// To override the contents of this collection use [`set_user_metadata`](Self::set_user_metadata).
        ///
        /// <p></p>
        pub fn user_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.user_metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.user_metadata = Some(hash_map);
            self
        }
        /// <p></p>
        pub fn set_user_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.user_metadata = input;
            self
        }
        /// <p></p>
        pub fn content_length(mut self, input: i64) -> Self {
            self.content_length = Some(input);
            self
        }
        /// <p></p>
        pub fn set_content_length(mut self, input: std::option::Option<i64>) -> Self {
            self.content_length = input;
            self
        }
        /// <p></p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_md5 = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_md5 = input;
            self
        }
        /// <p></p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p></p>
        pub fn http_expires_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.http_expires_date = Some(input);
            self
        }
        /// <p></p>
        pub fn set_http_expires_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.http_expires_date = input;
            self
        }
        /// <p></p>
        pub fn requester_charged(mut self, input: bool) -> Self {
            self.requester_charged = Some(input);
            self
        }
        /// <p></p>
        pub fn set_requester_charged(mut self, input: std::option::Option<bool>) -> Self {
            self.requester_charged = input;
            self
        }
        /// <p></p>
        pub fn sse_algorithm(mut self, input: crate::model::S3SseAlgorithm) -> Self {
            self.sse_algorithm = Some(input);
            self
        }
        /// <p></p>
        pub fn set_sse_algorithm(
            mut self,
            input: std::option::Option<crate::model::S3SseAlgorithm>,
        ) -> Self {
            self.sse_algorithm = input;
            self
        }
        /// Consumes the builder and constructs a [`S3ObjectMetadata`](crate::model::S3ObjectMetadata)
        pub fn build(self) -> crate::model::S3ObjectMetadata {
            crate::model::S3ObjectMetadata {
                cache_control: self.cache_control,
                content_disposition: self.content_disposition,
                content_encoding: self.content_encoding,
                content_language: self.content_language,
                user_metadata: self.user_metadata,
                content_length: self.content_length,
                content_md5: self.content_md5,
                content_type: self.content_type,
                http_expires_date: self.http_expires_date,
                requester_charged: self.requester_charged.unwrap_or_default(),
                sse_algorithm: self.sse_algorithm,
            }
        }
    }
}
impl S3ObjectMetadata {
    /// Creates a new builder-style object to manufacture [`S3ObjectMetadata`](crate::model::S3ObjectMetadata)
    pub fn builder() -> crate::model::s3_object_metadata::Builder {
        crate::model::s3_object_metadata::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum S3SseAlgorithm {
    #[allow(missing_docs)] // documentation missing in model
    Aes256,
    #[allow(missing_docs)] // documentation missing in model
    Kms,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for S3SseAlgorithm {
    fn from(s: &str) -> Self {
        match s {
            "AES256" => S3SseAlgorithm::Aes256,
            "KMS" => S3SseAlgorithm::Kms,
            other => S3SseAlgorithm::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for S3SseAlgorithm {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(S3SseAlgorithm::from(s))
    }
}
impl S3SseAlgorithm {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            S3SseAlgorithm::Aes256 => "AES256",
            S3SseAlgorithm::Kms => "KMS",
            S3SseAlgorithm::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AES256", "KMS"]
    }
}
impl AsRef<str> for S3SseAlgorithm {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum S3MetadataDirective {
    #[allow(missing_docs)] // documentation missing in model
    Copy,
    #[allow(missing_docs)] // documentation missing in model
    Replace,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for S3MetadataDirective {
    fn from(s: &str) -> Self {
        match s {
            "COPY" => S3MetadataDirective::Copy,
            "REPLACE" => S3MetadataDirective::Replace,
            other => S3MetadataDirective::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for S3MetadataDirective {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(S3MetadataDirective::from(s))
    }
}
impl S3MetadataDirective {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            S3MetadataDirective::Copy => "COPY",
            S3MetadataDirective::Replace => "REPLACE",
            S3MetadataDirective::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COPY", "REPLACE"]
    }
}
impl AsRef<str> for S3MetadataDirective {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the configuration parameters for a <code>Lambda Invoke</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaInvokeOperation {
    /// <p>The Amazon Resource Name (ARN) for the Lambda function that the specified job will invoke on every object in the manifest.</p>
    pub function_arn: std::option::Option<std::string::String>,
}
impl LambdaInvokeOperation {
    /// <p>The Amazon Resource Name (ARN) for the Lambda function that the specified job will invoke on every object in the manifest.</p>
    pub fn function_arn(&self) -> std::option::Option<&str> {
        self.function_arn.as_deref()
    }
}
impl std::fmt::Debug for LambdaInvokeOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaInvokeOperation");
        formatter.field("function_arn", &self.function_arn);
        formatter.finish()
    }
}
/// See [`LambdaInvokeOperation`](crate::model::LambdaInvokeOperation)
pub mod lambda_invoke_operation {
    /// A builder for [`LambdaInvokeOperation`](crate::model::LambdaInvokeOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the Lambda function that the specified job will invoke on every object in the manifest.</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Lambda function that the specified job will invoke on every object in the manifest.</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaInvokeOperation`](crate::model::LambdaInvokeOperation)
        pub fn build(self) -> crate::model::LambdaInvokeOperation {
            crate::model::LambdaInvokeOperation {
                function_arn: self.function_arn,
            }
        }
    }
}
impl LambdaInvokeOperation {
    /// Creates a new builder-style object to manufacture [`LambdaInvokeOperation`](crate::model::LambdaInvokeOperation)
    pub fn builder() -> crate::model::lambda_invoke_operation::Builder {
        crate::model::lambda_invoke_operation::Builder::default()
    }
}

/// <p>Contains the configuration information for a job's manifest.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobManifest {
    /// <p>Describes the format of the specified job's manifest. If the manifest is in CSV format, also describes the columns contained within the manifest.</p>
    pub spec: std::option::Option<crate::model::JobManifestSpec>,
    /// <p>Contains the information required to locate the specified job's manifest.</p>
    pub location: std::option::Option<crate::model::JobManifestLocation>,
}
impl JobManifest {
    /// <p>Describes the format of the specified job's manifest. If the manifest is in CSV format, also describes the columns contained within the manifest.</p>
    pub fn spec(&self) -> std::option::Option<&crate::model::JobManifestSpec> {
        self.spec.as_ref()
    }
    /// <p>Contains the information required to locate the specified job's manifest.</p>
    pub fn location(&self) -> std::option::Option<&crate::model::JobManifestLocation> {
        self.location.as_ref()
    }
}
impl std::fmt::Debug for JobManifest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobManifest");
        formatter.field("spec", &self.spec);
        formatter.field("location", &self.location);
        formatter.finish()
    }
}
/// See [`JobManifest`](crate::model::JobManifest)
pub mod job_manifest {
    /// A builder for [`JobManifest`](crate::model::JobManifest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) spec: std::option::Option<crate::model::JobManifestSpec>,
        pub(crate) location: std::option::Option<crate::model::JobManifestLocation>,
    }
    impl Builder {
        /// <p>Describes the format of the specified job's manifest. If the manifest is in CSV format, also describes the columns contained within the manifest.</p>
        pub fn spec(mut self, input: crate::model::JobManifestSpec) -> Self {
            self.spec = Some(input);
            self
        }
        /// <p>Describes the format of the specified job's manifest. If the manifest is in CSV format, also describes the columns contained within the manifest.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::JobManifestSpec>,
        ) -> Self {
            self.spec = input;
            self
        }
        /// <p>Contains the information required to locate the specified job's manifest.</p>
        pub fn location(mut self, input: crate::model::JobManifestLocation) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>Contains the information required to locate the specified job's manifest.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::JobManifestLocation>,
        ) -> Self {
            self.location = input;
            self
        }
        /// Consumes the builder and constructs a [`JobManifest`](crate::model::JobManifest)
        pub fn build(self) -> crate::model::JobManifest {
            crate::model::JobManifest {
                spec: self.spec,
                location: self.location,
            }
        }
    }
}
impl JobManifest {
    /// Creates a new builder-style object to manufacture [`JobManifest`](crate::model::JobManifest)
    pub fn builder() -> crate::model::job_manifest::Builder {
        crate::model::job_manifest::Builder::default()
    }
}

/// <p>Describes the format of a manifest. If the manifest is in CSV format, also describes the columns contained within the manifest.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobManifestSpec {
    /// <p>Indicates which of the available formats the specified manifest uses.</p>
    pub format: std::option::Option<crate::model::JobManifestFormat>,
    /// <p>If the specified manifest object is in the <code>S3BatchOperations_CSV_20180820</code> format, this element describes which columns contain the required data.</p>
    pub fields: std::option::Option<std::vec::Vec<crate::model::JobManifestFieldName>>,
}
impl JobManifestSpec {
    /// <p>Indicates which of the available formats the specified manifest uses.</p>
    pub fn format(&self) -> std::option::Option<&crate::model::JobManifestFormat> {
        self.format.as_ref()
    }
    /// <p>If the specified manifest object is in the <code>S3BatchOperations_CSV_20180820</code> format, this element describes which columns contain the required data.</p>
    pub fn fields(&self) -> std::option::Option<&[crate::model::JobManifestFieldName]> {
        self.fields.as_deref()
    }
}
impl std::fmt::Debug for JobManifestSpec {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobManifestSpec");
        formatter.field("format", &self.format);
        formatter.field("fields", &self.fields);
        formatter.finish()
    }
}
/// See [`JobManifestSpec`](crate::model::JobManifestSpec)
pub mod job_manifest_spec {
    /// A builder for [`JobManifestSpec`](crate::model::JobManifestSpec)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) format: std::option::Option<crate::model::JobManifestFormat>,
        pub(crate) fields: std::option::Option<std::vec::Vec<crate::model::JobManifestFieldName>>,
    }
    impl Builder {
        /// <p>Indicates which of the available formats the specified manifest uses.</p>
        pub fn format(mut self, input: crate::model::JobManifestFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>Indicates which of the available formats the specified manifest uses.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::JobManifestFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// Appends an item to `fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p>If the specified manifest object is in the <code>S3BatchOperations_CSV_20180820</code> format, this element describes which columns contain the required data.</p>
        pub fn fields(mut self, input: crate::model::JobManifestFieldName) -> Self {
            let mut v = self.fields.unwrap_or_default();
            v.push(input);
            self.fields = Some(v);
            self
        }
        /// <p>If the specified manifest object is in the <code>S3BatchOperations_CSV_20180820</code> format, this element describes which columns contain the required data.</p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobManifestFieldName>>,
        ) -> Self {
            self.fields = input;
            self
        }
        /// Consumes the builder and constructs a [`JobManifestSpec`](crate::model::JobManifestSpec)
        pub fn build(self) -> crate::model::JobManifestSpec {
            crate::model::JobManifestSpec {
                format: self.format,
                fields: self.fields,
            }
        }
    }
}
impl JobManifestSpec {
    /// Creates a new builder-style object to manufacture [`JobManifestSpec`](crate::model::JobManifestSpec)
    pub fn builder() -> crate::model::job_manifest_spec::Builder {
        crate::model::job_manifest_spec::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobManifestFieldName {
    #[allow(missing_docs)] // documentation missing in model
    Bucket,
    #[allow(missing_docs)] // documentation missing in model
    Ignore,
    #[allow(missing_docs)] // documentation missing in model
    Key,
    #[allow(missing_docs)] // documentation missing in model
    VersionId,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobManifestFieldName {
    fn from(s: &str) -> Self {
        match s {
            "Bucket" => JobManifestFieldName::Bucket,
            "Ignore" => JobManifestFieldName::Ignore,
            "Key" => JobManifestFieldName::Key,
            "VersionId" => JobManifestFieldName::VersionId,
            other => JobManifestFieldName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobManifestFieldName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobManifestFieldName::from(s))
    }
}
impl JobManifestFieldName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobManifestFieldName::Bucket => "Bucket",
            JobManifestFieldName::Ignore => "Ignore",
            JobManifestFieldName::Key => "Key",
            JobManifestFieldName::VersionId => "VersionId",
            JobManifestFieldName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Bucket", "Ignore", "Key", "VersionId"]
    }
}
impl AsRef<str> for JobManifestFieldName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobManifestFormat {
    #[allow(missing_docs)] // documentation missing in model
    S3BatchOperationsCsv20180820,
    #[allow(missing_docs)] // documentation missing in model
    S3InventoryReportCsv20161130,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobManifestFormat {
    fn from(s: &str) -> Self {
        match s {
            "S3BatchOperations_CSV_20180820" => JobManifestFormat::S3BatchOperationsCsv20180820,
            "S3InventoryReport_CSV_20161130" => JobManifestFormat::S3InventoryReportCsv20161130,
            other => JobManifestFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobManifestFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobManifestFormat::from(s))
    }
}
impl JobManifestFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobManifestFormat::S3BatchOperationsCsv20180820 => "S3BatchOperations_CSV_20180820",
            JobManifestFormat::S3InventoryReportCsv20161130 => "S3InventoryReport_CSV_20161130",
            JobManifestFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "S3BatchOperations_CSV_20180820",
            "S3InventoryReport_CSV_20161130",
        ]
    }
}
impl AsRef<str> for JobManifestFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The container for the bucket configuration.</p> <note>
/// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBucketConfiguration {
    /// <p>Specifies the Region where the bucket will be created. If you are creating a bucket on the US East (N. Virginia) Region (us-east-1), you do not need to specify the location. </p> <note>
    /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub location_constraint: std::option::Option<crate::model::BucketLocationConstraint>,
}
impl CreateBucketConfiguration {
    /// <p>Specifies the Region where the bucket will be created. If you are creating a bucket on the US East (N. Virginia) Region (us-east-1), you do not need to specify the location. </p> <note>
    /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
    /// </note>
    pub fn location_constraint(
        &self,
    ) -> std::option::Option<&crate::model::BucketLocationConstraint> {
        self.location_constraint.as_ref()
    }
}
impl std::fmt::Debug for CreateBucketConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBucketConfiguration");
        formatter.field("location_constraint", &self.location_constraint);
        formatter.finish()
    }
}
/// See [`CreateBucketConfiguration`](crate::model::CreateBucketConfiguration)
pub mod create_bucket_configuration {
    /// A builder for [`CreateBucketConfiguration`](crate::model::CreateBucketConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location_constraint: std::option::Option<crate::model::BucketLocationConstraint>,
    }
    impl Builder {
        /// <p>Specifies the Region where the bucket will be created. If you are creating a bucket on the US East (N. Virginia) Region (us-east-1), you do not need to specify the location. </p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn location_constraint(
            mut self,
            input: crate::model::BucketLocationConstraint,
        ) -> Self {
            self.location_constraint = Some(input);
            self
        }
        /// <p>Specifies the Region where the bucket will be created. If you are creating a bucket on the US East (N. Virginia) Region (us-east-1), you do not need to specify the location. </p> <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_location_constraint(
            mut self,
            input: std::option::Option<crate::model::BucketLocationConstraint>,
        ) -> Self {
            self.location_constraint = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBucketConfiguration`](crate::model::CreateBucketConfiguration)
        pub fn build(self) -> crate::model::CreateBucketConfiguration {
            crate::model::CreateBucketConfiguration {
                location_constraint: self.location_constraint,
            }
        }
    }
}
impl CreateBucketConfiguration {
    /// Creates a new builder-style object to manufacture [`CreateBucketConfiguration`](crate::model::CreateBucketConfiguration)
    pub fn builder() -> crate::model::create_bucket_configuration::Builder {
        crate::model::create_bucket_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BucketLocationConstraint {
    #[allow(missing_docs)] // documentation missing in model
    Eu,
    #[allow(missing_docs)] // documentation missing in model
    ApNortheast1,
    #[allow(missing_docs)] // documentation missing in model
    ApSouth1,
    #[allow(missing_docs)] // documentation missing in model
    ApSoutheast1,
    #[allow(missing_docs)] // documentation missing in model
    ApSoutheast2,
    #[allow(missing_docs)] // documentation missing in model
    CnNorth1,
    #[allow(missing_docs)] // documentation missing in model
    EuCentral1,
    #[allow(missing_docs)] // documentation missing in model
    EuWest1,
    #[allow(missing_docs)] // documentation missing in model
    SaEast1,
    #[allow(missing_docs)] // documentation missing in model
    UsWest1,
    #[allow(missing_docs)] // documentation missing in model
    UsWest2,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BucketLocationConstraint {
    fn from(s: &str) -> Self {
        match s {
            "EU" => BucketLocationConstraint::Eu,
            "ap-northeast-1" => BucketLocationConstraint::ApNortheast1,
            "ap-south-1" => BucketLocationConstraint::ApSouth1,
            "ap-southeast-1" => BucketLocationConstraint::ApSoutheast1,
            "ap-southeast-2" => BucketLocationConstraint::ApSoutheast2,
            "cn-north-1" => BucketLocationConstraint::CnNorth1,
            "eu-central-1" => BucketLocationConstraint::EuCentral1,
            "eu-west-1" => BucketLocationConstraint::EuWest1,
            "sa-east-1" => BucketLocationConstraint::SaEast1,
            "us-west-1" => BucketLocationConstraint::UsWest1,
            "us-west-2" => BucketLocationConstraint::UsWest2,
            other => BucketLocationConstraint::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BucketLocationConstraint {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BucketLocationConstraint::from(s))
    }
}
impl BucketLocationConstraint {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BucketLocationConstraint::Eu => "EU",
            BucketLocationConstraint::ApNortheast1 => "ap-northeast-1",
            BucketLocationConstraint::ApSouth1 => "ap-south-1",
            BucketLocationConstraint::ApSoutheast1 => "ap-southeast-1",
            BucketLocationConstraint::ApSoutheast2 => "ap-southeast-2",
            BucketLocationConstraint::CnNorth1 => "cn-north-1",
            BucketLocationConstraint::EuCentral1 => "eu-central-1",
            BucketLocationConstraint::EuWest1 => "eu-west-1",
            BucketLocationConstraint::SaEast1 => "sa-east-1",
            BucketLocationConstraint::UsWest1 => "us-west-1",
            BucketLocationConstraint::UsWest2 => "us-west-2",
            BucketLocationConstraint::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "EU",
            "ap-northeast-1",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "cn-north-1",
            "eu-central-1",
            "eu-west-1",
            "sa-east-1",
            "us-west-1",
            "us-west-2",
        ]
    }
}
impl AsRef<str> for BucketLocationConstraint {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BucketCannedAcl {
    #[allow(missing_docs)] // documentation missing in model
    AuthenticatedRead,
    #[allow(missing_docs)] // documentation missing in model
    Private,
    #[allow(missing_docs)] // documentation missing in model
    PublicRead,
    #[allow(missing_docs)] // documentation missing in model
    PublicReadWrite,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BucketCannedAcl {
    fn from(s: &str) -> Self {
        match s {
            "authenticated-read" => BucketCannedAcl::AuthenticatedRead,
            "private" => BucketCannedAcl::Private,
            "public-read" => BucketCannedAcl::PublicRead,
            "public-read-write" => BucketCannedAcl::PublicReadWrite,
            other => BucketCannedAcl::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BucketCannedAcl {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BucketCannedAcl::from(s))
    }
}
impl BucketCannedAcl {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BucketCannedAcl::AuthenticatedRead => "authenticated-read",
            BucketCannedAcl::Private => "private",
            BucketCannedAcl::PublicRead => "public-read",
            BucketCannedAcl::PublicReadWrite => "public-read-write",
            BucketCannedAcl::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "authenticated-read",
            "private",
            "public-read",
            "public-read-write",
        ]
    }
}
impl AsRef<str> for BucketCannedAcl {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
