// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateJobStatusOutput {
    /// <p>The ID for the job whose status was updated.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The current status for the specified job.</p>
    pub status: std::option::Option<crate::model::JobStatus>,
    /// <p>The reason that the specified job's status was updated.</p>
    pub status_update_reason: std::option::Option<std::string::String>,
}
impl UpdateJobStatusOutput {
    /// <p>The ID for the job whose status was updated.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The current status for the specified job.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.status.as_ref()
    }
    /// <p>The reason that the specified job's status was updated.</p>
    pub fn status_update_reason(&self) -> std::option::Option<&str> {
        self.status_update_reason.as_deref()
    }
}
impl std::fmt::Debug for UpdateJobStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateJobStatusOutput");
        formatter.field("job_id", &self.job_id);
        formatter.field("status", &self.status);
        formatter.field("status_update_reason", &self.status_update_reason);
        formatter.finish()
    }
}
/// See [`UpdateJobStatusOutput`](crate::output::UpdateJobStatusOutput)
pub mod update_job_status_output {
    /// A builder for [`UpdateJobStatusOutput`](crate::output::UpdateJobStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::JobStatus>,
        pub(crate) status_update_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for the job whose status was updated.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for the job whose status was updated.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The current status for the specified job.</p>
        pub fn status(mut self, input: crate::model::JobStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status for the specified job.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::JobStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>The reason that the specified job's status was updated.</p>
        pub fn status_update_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_update_reason = Some(input.into());
            self
        }
        /// <p>The reason that the specified job's status was updated.</p>
        pub fn set_status_update_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_update_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateJobStatusOutput`](crate::output::UpdateJobStatusOutput)
        pub fn build(self) -> crate::output::UpdateJobStatusOutput {
            crate::output::UpdateJobStatusOutput {
                job_id: self.job_id,
                status: self.status,
                status_update_reason: self.status_update_reason,
            }
        }
    }
}
impl UpdateJobStatusOutput {
    /// Creates a new builder-style object to manufacture [`UpdateJobStatusOutput`](crate::output::UpdateJobStatusOutput)
    pub fn builder() -> crate::output::update_job_status_output::Builder {
        crate::output::update_job_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateJobPriorityOutput {
    /// <p>The ID for the job whose priority Amazon S3 updated.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The new priority assigned to the specified job.</p>
    pub priority: i32,
}
impl UpdateJobPriorityOutput {
    /// <p>The ID for the job whose priority Amazon S3 updated.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The new priority assigned to the specified job.</p>
    pub fn priority(&self) -> i32 {
        self.priority
    }
}
impl std::fmt::Debug for UpdateJobPriorityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateJobPriorityOutput");
        formatter.field("job_id", &self.job_id);
        formatter.field("priority", &self.priority);
        formatter.finish()
    }
}
/// See [`UpdateJobPriorityOutput`](crate::output::UpdateJobPriorityOutput)
pub mod update_job_priority_output {
    /// A builder for [`UpdateJobPriorityOutput`](crate::output::UpdateJobPriorityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) priority: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID for the job whose priority Amazon S3 updated.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for the job whose priority Amazon S3 updated.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The new priority assigned to the specified job.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The new priority assigned to the specified job.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateJobPriorityOutput`](crate::output::UpdateJobPriorityOutput)
        pub fn build(self) -> crate::output::UpdateJobPriorityOutput {
            crate::output::UpdateJobPriorityOutput {
                job_id: self.job_id,
                priority: self.priority.unwrap_or_default(),
            }
        }
    }
}
impl UpdateJobPriorityOutput {
    /// Creates a new builder-style object to manufacture [`UpdateJobPriorityOutput`](crate::output::UpdateJobPriorityOutput)
    pub fn builder() -> crate::output::update_job_priority_output::Builder {
        crate::output::update_job_priority_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutStorageLensConfigurationTaggingOutput {}
impl std::fmt::Debug for PutStorageLensConfigurationTaggingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutStorageLensConfigurationTaggingOutput");
        formatter.finish()
    }
}
/// See [`PutStorageLensConfigurationTaggingOutput`](crate::output::PutStorageLensConfigurationTaggingOutput)
pub mod put_storage_lens_configuration_tagging_output {
    /// A builder for [`PutStorageLensConfigurationTaggingOutput`](crate::output::PutStorageLensConfigurationTaggingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutStorageLensConfigurationTaggingOutput`](crate::output::PutStorageLensConfigurationTaggingOutput)
        pub fn build(self) -> crate::output::PutStorageLensConfigurationTaggingOutput {
            crate::output::PutStorageLensConfigurationTaggingOutput {}
        }
    }
}
impl PutStorageLensConfigurationTaggingOutput {
    /// Creates a new builder-style object to manufacture [`PutStorageLensConfigurationTaggingOutput`](crate::output::PutStorageLensConfigurationTaggingOutput)
    pub fn builder() -> crate::output::put_storage_lens_configuration_tagging_output::Builder {
        crate::output::put_storage_lens_configuration_tagging_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutStorageLensConfigurationOutput {}
impl std::fmt::Debug for PutStorageLensConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutStorageLensConfigurationOutput");
        formatter.finish()
    }
}
/// See [`PutStorageLensConfigurationOutput`](crate::output::PutStorageLensConfigurationOutput)
pub mod put_storage_lens_configuration_output {
    /// A builder for [`PutStorageLensConfigurationOutput`](crate::output::PutStorageLensConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutStorageLensConfigurationOutput`](crate::output::PutStorageLensConfigurationOutput)
        pub fn build(self) -> crate::output::PutStorageLensConfigurationOutput {
            crate::output::PutStorageLensConfigurationOutput {}
        }
    }
}
impl PutStorageLensConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`PutStorageLensConfigurationOutput`](crate::output::PutStorageLensConfigurationOutput)
    pub fn builder() -> crate::output::put_storage_lens_configuration_output::Builder {
        crate::output::put_storage_lens_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutPublicAccessBlockOutput {}
impl std::fmt::Debug for PutPublicAccessBlockOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutPublicAccessBlockOutput");
        formatter.finish()
    }
}
/// See [`PutPublicAccessBlockOutput`](crate::output::PutPublicAccessBlockOutput)
pub mod put_public_access_block_output {
    /// A builder for [`PutPublicAccessBlockOutput`](crate::output::PutPublicAccessBlockOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutPublicAccessBlockOutput`](crate::output::PutPublicAccessBlockOutput)
        pub fn build(self) -> crate::output::PutPublicAccessBlockOutput {
            crate::output::PutPublicAccessBlockOutput {}
        }
    }
}
impl PutPublicAccessBlockOutput {
    /// Creates a new builder-style object to manufacture [`PutPublicAccessBlockOutput`](crate::output::PutPublicAccessBlockOutput)
    pub fn builder() -> crate::output::put_public_access_block_output::Builder {
        crate::output::put_public_access_block_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutMultiRegionAccessPointPolicyOutput {
    /// <p>The request token associated with the request. You can use this token with <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> to determine the status of
    /// asynchronous requests.</p>
    pub request_token_arn: std::option::Option<std::string::String>,
}
impl PutMultiRegionAccessPointPolicyOutput {
    /// <p>The request token associated with the request. You can use this token with <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> to determine the status of
    /// asynchronous requests.</p>
    pub fn request_token_arn(&self) -> std::option::Option<&str> {
        self.request_token_arn.as_deref()
    }
}
impl std::fmt::Debug for PutMultiRegionAccessPointPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutMultiRegionAccessPointPolicyOutput");
        formatter.field("request_token_arn", &self.request_token_arn);
        formatter.finish()
    }
}
/// See [`PutMultiRegionAccessPointPolicyOutput`](crate::output::PutMultiRegionAccessPointPolicyOutput)
pub mod put_multi_region_access_point_policy_output {
    /// A builder for [`PutMultiRegionAccessPointPolicyOutput`](crate::output::PutMultiRegionAccessPointPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_token_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request token associated with the request. You can use this token with <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> to determine the status of
        /// asynchronous requests.</p>
        pub fn request_token_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_token_arn = Some(input.into());
            self
        }
        /// <p>The request token associated with the request. You can use this token with <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> to determine the status of
        /// asynchronous requests.</p>
        pub fn set_request_token_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.request_token_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`PutMultiRegionAccessPointPolicyOutput`](crate::output::PutMultiRegionAccessPointPolicyOutput)
        pub fn build(self) -> crate::output::PutMultiRegionAccessPointPolicyOutput {
            crate::output::PutMultiRegionAccessPointPolicyOutput {
                request_token_arn: self.request_token_arn,
            }
        }
    }
}
impl PutMultiRegionAccessPointPolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutMultiRegionAccessPointPolicyOutput`](crate::output::PutMultiRegionAccessPointPolicyOutput)
    pub fn builder() -> crate::output::put_multi_region_access_point_policy_output::Builder {
        crate::output::put_multi_region_access_point_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutJobTaggingOutput {}
impl std::fmt::Debug for PutJobTaggingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutJobTaggingOutput");
        formatter.finish()
    }
}
/// See [`PutJobTaggingOutput`](crate::output::PutJobTaggingOutput)
pub mod put_job_tagging_output {
    /// A builder for [`PutJobTaggingOutput`](crate::output::PutJobTaggingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutJobTaggingOutput`](crate::output::PutJobTaggingOutput)
        pub fn build(self) -> crate::output::PutJobTaggingOutput {
            crate::output::PutJobTaggingOutput {}
        }
    }
}
impl PutJobTaggingOutput {
    /// Creates a new builder-style object to manufacture [`PutJobTaggingOutput`](crate::output::PutJobTaggingOutput)
    pub fn builder() -> crate::output::put_job_tagging_output::Builder {
        crate::output::put_job_tagging_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBucketTaggingOutput {}
impl std::fmt::Debug for PutBucketTaggingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBucketTaggingOutput");
        formatter.finish()
    }
}
/// See [`PutBucketTaggingOutput`](crate::output::PutBucketTaggingOutput)
pub mod put_bucket_tagging_output {
    /// A builder for [`PutBucketTaggingOutput`](crate::output::PutBucketTaggingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutBucketTaggingOutput`](crate::output::PutBucketTaggingOutput)
        pub fn build(self) -> crate::output::PutBucketTaggingOutput {
            crate::output::PutBucketTaggingOutput {}
        }
    }
}
impl PutBucketTaggingOutput {
    /// Creates a new builder-style object to manufacture [`PutBucketTaggingOutput`](crate::output::PutBucketTaggingOutput)
    pub fn builder() -> crate::output::put_bucket_tagging_output::Builder {
        crate::output::put_bucket_tagging_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBucketPolicyOutput {}
impl std::fmt::Debug for PutBucketPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBucketPolicyOutput");
        formatter.finish()
    }
}
/// See [`PutBucketPolicyOutput`](crate::output::PutBucketPolicyOutput)
pub mod put_bucket_policy_output {
    /// A builder for [`PutBucketPolicyOutput`](crate::output::PutBucketPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutBucketPolicyOutput`](crate::output::PutBucketPolicyOutput)
        pub fn build(self) -> crate::output::PutBucketPolicyOutput {
            crate::output::PutBucketPolicyOutput {}
        }
    }
}
impl PutBucketPolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutBucketPolicyOutput`](crate::output::PutBucketPolicyOutput)
    pub fn builder() -> crate::output::put_bucket_policy_output::Builder {
        crate::output::put_bucket_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBucketLifecycleConfigurationOutput {}
impl std::fmt::Debug for PutBucketLifecycleConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBucketLifecycleConfigurationOutput");
        formatter.finish()
    }
}
/// See [`PutBucketLifecycleConfigurationOutput`](crate::output::PutBucketLifecycleConfigurationOutput)
pub mod put_bucket_lifecycle_configuration_output {
    /// A builder for [`PutBucketLifecycleConfigurationOutput`](crate::output::PutBucketLifecycleConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutBucketLifecycleConfigurationOutput`](crate::output::PutBucketLifecycleConfigurationOutput)
        pub fn build(self) -> crate::output::PutBucketLifecycleConfigurationOutput {
            crate::output::PutBucketLifecycleConfigurationOutput {}
        }
    }
}
impl PutBucketLifecycleConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`PutBucketLifecycleConfigurationOutput`](crate::output::PutBucketLifecycleConfigurationOutput)
    pub fn builder() -> crate::output::put_bucket_lifecycle_configuration_output::Builder {
        crate::output::put_bucket_lifecycle_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAccessPointPolicyForObjectLambdaOutput {}
impl std::fmt::Debug for PutAccessPointPolicyForObjectLambdaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAccessPointPolicyForObjectLambdaOutput");
        formatter.finish()
    }
}
/// See [`PutAccessPointPolicyForObjectLambdaOutput`](crate::output::PutAccessPointPolicyForObjectLambdaOutput)
pub mod put_access_point_policy_for_object_lambda_output {
    /// A builder for [`PutAccessPointPolicyForObjectLambdaOutput`](crate::output::PutAccessPointPolicyForObjectLambdaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutAccessPointPolicyForObjectLambdaOutput`](crate::output::PutAccessPointPolicyForObjectLambdaOutput)
        pub fn build(self) -> crate::output::PutAccessPointPolicyForObjectLambdaOutput {
            crate::output::PutAccessPointPolicyForObjectLambdaOutput {}
        }
    }
}
impl PutAccessPointPolicyForObjectLambdaOutput {
    /// Creates a new builder-style object to manufacture [`PutAccessPointPolicyForObjectLambdaOutput`](crate::output::PutAccessPointPolicyForObjectLambdaOutput)
    pub fn builder() -> crate::output::put_access_point_policy_for_object_lambda_output::Builder {
        crate::output::put_access_point_policy_for_object_lambda_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAccessPointPolicyOutput {}
impl std::fmt::Debug for PutAccessPointPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAccessPointPolicyOutput");
        formatter.finish()
    }
}
/// See [`PutAccessPointPolicyOutput`](crate::output::PutAccessPointPolicyOutput)
pub mod put_access_point_policy_output {
    /// A builder for [`PutAccessPointPolicyOutput`](crate::output::PutAccessPointPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutAccessPointPolicyOutput`](crate::output::PutAccessPointPolicyOutput)
        pub fn build(self) -> crate::output::PutAccessPointPolicyOutput {
            crate::output::PutAccessPointPolicyOutput {}
        }
    }
}
impl PutAccessPointPolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutAccessPointPolicyOutput`](crate::output::PutAccessPointPolicyOutput)
    pub fn builder() -> crate::output::put_access_point_policy_output::Builder {
        crate::output::put_access_point_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutAccessPointConfigurationForObjectLambdaOutput {}
impl std::fmt::Debug for PutAccessPointConfigurationForObjectLambdaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutAccessPointConfigurationForObjectLambdaOutput");
        formatter.finish()
    }
}
/// See [`PutAccessPointConfigurationForObjectLambdaOutput`](crate::output::PutAccessPointConfigurationForObjectLambdaOutput)
pub mod put_access_point_configuration_for_object_lambda_output {
    /// A builder for [`PutAccessPointConfigurationForObjectLambdaOutput`](crate::output::PutAccessPointConfigurationForObjectLambdaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutAccessPointConfigurationForObjectLambdaOutput`](crate::output::PutAccessPointConfigurationForObjectLambdaOutput)
        pub fn build(self) -> crate::output::PutAccessPointConfigurationForObjectLambdaOutput {
            crate::output::PutAccessPointConfigurationForObjectLambdaOutput {}
        }
    }
}
impl PutAccessPointConfigurationForObjectLambdaOutput {
    /// Creates a new builder-style object to manufacture [`PutAccessPointConfigurationForObjectLambdaOutput`](crate::output::PutAccessPointConfigurationForObjectLambdaOutput)
    pub fn builder(
    ) -> crate::output::put_access_point_configuration_for_object_lambda_output::Builder {
        crate::output::put_access_point_configuration_for_object_lambda_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListStorageLensConfigurationsOutput {
    /// <p>If the request produced more than the maximum number of S3 Storage Lens configuration results,
    /// you can pass this value into a subsequent request to retrieve the next page of
    /// results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of S3 Storage Lens configurations.</p>
    pub storage_lens_configuration_list:
        std::option::Option<std::vec::Vec<crate::model::ListStorageLensConfigurationEntry>>,
}
impl ListStorageLensConfigurationsOutput {
    /// <p>If the request produced more than the maximum number of S3 Storage Lens configuration results,
    /// you can pass this value into a subsequent request to retrieve the next page of
    /// results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A list of S3 Storage Lens configurations.</p>
    pub fn storage_lens_configuration_list(
        &self,
    ) -> std::option::Option<&[crate::model::ListStorageLensConfigurationEntry]> {
        self.storage_lens_configuration_list.as_deref()
    }
}
impl std::fmt::Debug for ListStorageLensConfigurationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListStorageLensConfigurationsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field(
            "storage_lens_configuration_list",
            &self.storage_lens_configuration_list,
        );
        formatter.finish()
    }
}
/// See [`ListStorageLensConfigurationsOutput`](crate::output::ListStorageLensConfigurationsOutput)
pub mod list_storage_lens_configurations_output {
    /// A builder for [`ListStorageLensConfigurationsOutput`](crate::output::ListStorageLensConfigurationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) storage_lens_configuration_list:
            std::option::Option<std::vec::Vec<crate::model::ListStorageLensConfigurationEntry>>,
    }
    impl Builder {
        /// <p>If the request produced more than the maximum number of S3 Storage Lens configuration results,
        /// you can pass this value into a subsequent request to retrieve the next page of
        /// results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the request produced more than the maximum number of S3 Storage Lens configuration results,
        /// you can pass this value into a subsequent request to retrieve the next page of
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `storage_lens_configuration_list`.
        ///
        /// To override the contents of this collection use [`set_storage_lens_configuration_list`](Self::set_storage_lens_configuration_list).
        ///
        /// <p>A list of S3 Storage Lens configurations.</p>
        pub fn storage_lens_configuration_list(
            mut self,
            input: impl Into<crate::model::ListStorageLensConfigurationEntry>,
        ) -> Self {
            let mut v = self.storage_lens_configuration_list.unwrap_or_default();
            v.push(input.into());
            self.storage_lens_configuration_list = Some(v);
            self
        }
        /// <p>A list of S3 Storage Lens configurations.</p>
        pub fn set_storage_lens_configuration_list(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ListStorageLensConfigurationEntry>,
            >,
        ) -> Self {
            self.storage_lens_configuration_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListStorageLensConfigurationsOutput`](crate::output::ListStorageLensConfigurationsOutput)
        pub fn build(self) -> crate::output::ListStorageLensConfigurationsOutput {
            crate::output::ListStorageLensConfigurationsOutput {
                next_token: self.next_token,
                storage_lens_configuration_list: self.storage_lens_configuration_list,
            }
        }
    }
}
impl ListStorageLensConfigurationsOutput {
    /// Creates a new builder-style object to manufacture [`ListStorageLensConfigurationsOutput`](crate::output::ListStorageLensConfigurationsOutput)
    pub fn builder() -> crate::output::list_storage_lens_configurations_output::Builder {
        crate::output::list_storage_lens_configurations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRegionalBucketsOutput {
    /// <p></p>
    pub regional_bucket_list: std::option::Option<std::vec::Vec<crate::model::RegionalBucket>>,
    /// <p>
    /// <code>NextToken</code> is sent when <code>isTruncated</code> is true, which means
    /// there are more buckets that can be listed. The next list requests to Amazon S3
    /// can be continued with this <code>NextToken</code>.
    /// <code>NextToken</code> is obfuscated and is not a real key.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRegionalBucketsOutput {
    /// <p></p>
    pub fn regional_bucket_list(&self) -> std::option::Option<&[crate::model::RegionalBucket]> {
        self.regional_bucket_list.as_deref()
    }
    /// <p>
    /// <code>NextToken</code> is sent when <code>isTruncated</code> is true, which means
    /// there are more buckets that can be listed. The next list requests to Amazon S3
    /// can be continued with this <code>NextToken</code>.
    /// <code>NextToken</code> is obfuscated and is not a real key.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRegionalBucketsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRegionalBucketsOutput");
        formatter.field("regional_bucket_list", &self.regional_bucket_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListRegionalBucketsOutput`](crate::output::ListRegionalBucketsOutput)
pub mod list_regional_buckets_output {
    /// A builder for [`ListRegionalBucketsOutput`](crate::output::ListRegionalBucketsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) regional_bucket_list:
            std::option::Option<std::vec::Vec<crate::model::RegionalBucket>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `regional_bucket_list`.
        ///
        /// To override the contents of this collection use [`set_regional_bucket_list`](Self::set_regional_bucket_list).
        ///
        /// <p></p>
        pub fn regional_bucket_list(
            mut self,
            input: impl Into<crate::model::RegionalBucket>,
        ) -> Self {
            let mut v = self.regional_bucket_list.unwrap_or_default();
            v.push(input.into());
            self.regional_bucket_list = Some(v);
            self
        }
        /// <p></p>
        pub fn set_regional_bucket_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RegionalBucket>>,
        ) -> Self {
            self.regional_bucket_list = input;
            self
        }
        /// <p>
        /// <code>NextToken</code> is sent when <code>isTruncated</code> is true, which means
        /// there are more buckets that can be listed. The next list requests to Amazon S3
        /// can be continued with this <code>NextToken</code>.
        /// <code>NextToken</code> is obfuscated and is not a real key.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// <code>NextToken</code> is sent when <code>isTruncated</code> is true, which means
        /// there are more buckets that can be listed. The next list requests to Amazon S3
        /// can be continued with this <code>NextToken</code>.
        /// <code>NextToken</code> is obfuscated and is not a real key.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRegionalBucketsOutput`](crate::output::ListRegionalBucketsOutput)
        pub fn build(self) -> crate::output::ListRegionalBucketsOutput {
            crate::output::ListRegionalBucketsOutput {
                regional_bucket_list: self.regional_bucket_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListRegionalBucketsOutput {
    /// Creates a new builder-style object to manufacture [`ListRegionalBucketsOutput`](crate::output::ListRegionalBucketsOutput)
    pub fn builder() -> crate::output::list_regional_buckets_output::Builder {
        crate::output::list_regional_buckets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMultiRegionAccessPointsOutput {
    /// <p>The list of Multi-Region Access Points associated with the user.</p>
    pub access_points:
        std::option::Option<std::vec::Vec<crate::model::MultiRegionAccessPointReport>>,
    /// <p>If the specified bucket has more Multi-Region Access Points than can be returned in one call to this
    /// action, this field contains a continuation token. You can use this token tin subsequent
    /// calls to this action to retrieve additional Multi-Region Access Points.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListMultiRegionAccessPointsOutput {
    /// <p>The list of Multi-Region Access Points associated with the user.</p>
    pub fn access_points(
        &self,
    ) -> std::option::Option<&[crate::model::MultiRegionAccessPointReport]> {
        self.access_points.as_deref()
    }
    /// <p>If the specified bucket has more Multi-Region Access Points than can be returned in one call to this
    /// action, this field contains a continuation token. You can use this token tin subsequent
    /// calls to this action to retrieve additional Multi-Region Access Points.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListMultiRegionAccessPointsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMultiRegionAccessPointsOutput");
        formatter.field("access_points", &self.access_points);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListMultiRegionAccessPointsOutput`](crate::output::ListMultiRegionAccessPointsOutput)
pub mod list_multi_region_access_points_output {
    /// A builder for [`ListMultiRegionAccessPointsOutput`](crate::output::ListMultiRegionAccessPointsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_points:
            std::option::Option<std::vec::Vec<crate::model::MultiRegionAccessPointReport>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `access_points`.
        ///
        /// To override the contents of this collection use [`set_access_points`](Self::set_access_points).
        ///
        /// <p>The list of Multi-Region Access Points associated with the user.</p>
        pub fn access_points(
            mut self,
            input: impl Into<crate::model::MultiRegionAccessPointReport>,
        ) -> Self {
            let mut v = self.access_points.unwrap_or_default();
            v.push(input.into());
            self.access_points = Some(v);
            self
        }
        /// <p>The list of Multi-Region Access Points associated with the user.</p>
        pub fn set_access_points(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MultiRegionAccessPointReport>>,
        ) -> Self {
            self.access_points = input;
            self
        }
        /// <p>If the specified bucket has more Multi-Region Access Points than can be returned in one call to this
        /// action, this field contains a continuation token. You can use this token tin subsequent
        /// calls to this action to retrieve additional Multi-Region Access Points.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the specified bucket has more Multi-Region Access Points than can be returned in one call to this
        /// action, this field contains a continuation token. You can use this token tin subsequent
        /// calls to this action to retrieve additional Multi-Region Access Points.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMultiRegionAccessPointsOutput`](crate::output::ListMultiRegionAccessPointsOutput)
        pub fn build(self) -> crate::output::ListMultiRegionAccessPointsOutput {
            crate::output::ListMultiRegionAccessPointsOutput {
                access_points: self.access_points,
                next_token: self.next_token,
            }
        }
    }
}
impl ListMultiRegionAccessPointsOutput {
    /// Creates a new builder-style object to manufacture [`ListMultiRegionAccessPointsOutput`](crate::output::ListMultiRegionAccessPointsOutput)
    pub fn builder() -> crate::output::list_multi_region_access_points_output::Builder {
        crate::output::list_multi_region_access_points_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJobsOutput {
    /// <p>If the <code>List Jobs</code> request produced more than the maximum number of results, you can pass this value into a subsequent <code>List Jobs</code> request in order to retrieve
    /// the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The list of current jobs and jobs that have ended within the last 30 days.</p>
    pub jobs: std::option::Option<std::vec::Vec<crate::model::JobListDescriptor>>,
}
impl ListJobsOutput {
    /// <p>If the <code>List Jobs</code> request produced more than the maximum number of results, you can pass this value into a subsequent <code>List Jobs</code> request in order to retrieve
    /// the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The list of current jobs and jobs that have ended within the last 30 days.</p>
    pub fn jobs(&self) -> std::option::Option<&[crate::model::JobListDescriptor]> {
        self.jobs.as_deref()
    }
}
impl std::fmt::Debug for ListJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJobsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("jobs", &self.jobs);
        formatter.finish()
    }
}
/// See [`ListJobsOutput`](crate::output::ListJobsOutput)
pub mod list_jobs_output {
    /// A builder for [`ListJobsOutput`](crate::output::ListJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) jobs: std::option::Option<std::vec::Vec<crate::model::JobListDescriptor>>,
    }
    impl Builder {
        /// <p>If the <code>List Jobs</code> request produced more than the maximum number of results, you can pass this value into a subsequent <code>List Jobs</code> request in order to retrieve
        /// the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the <code>List Jobs</code> request produced more than the maximum number of results, you can pass this value into a subsequent <code>List Jobs</code> request in order to retrieve
        /// the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `jobs`.
        ///
        /// To override the contents of this collection use [`set_jobs`](Self::set_jobs).
        ///
        /// <p>The list of current jobs and jobs that have ended within the last 30 days.</p>
        pub fn jobs(mut self, input: impl Into<crate::model::JobListDescriptor>) -> Self {
            let mut v = self.jobs.unwrap_or_default();
            v.push(input.into());
            self.jobs = Some(v);
            self
        }
        /// <p>The list of current jobs and jobs that have ended within the last 30 days.</p>
        pub fn set_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobListDescriptor>>,
        ) -> Self {
            self.jobs = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJobsOutput`](crate::output::ListJobsOutput)
        pub fn build(self) -> crate::output::ListJobsOutput {
            crate::output::ListJobsOutput {
                next_token: self.next_token,
                jobs: self.jobs,
            }
        }
    }
}
impl ListJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListJobsOutput`](crate::output::ListJobsOutput)
    pub fn builder() -> crate::output::list_jobs_output::Builder {
        crate::output::list_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccessPointsForObjectLambdaOutput {
    /// <p>Returns list of Object Lambda Access Points.</p>
    pub object_lambda_access_point_list:
        std::option::Option<std::vec::Vec<crate::model::ObjectLambdaAccessPoint>>,
    /// <p>If the list has more access points than can be returned in one call to this
    /// API, this field contains a continuation token that you can provide in subsequent calls to
    /// this API to retrieve additional access points.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAccessPointsForObjectLambdaOutput {
    /// <p>Returns list of Object Lambda Access Points.</p>
    pub fn object_lambda_access_point_list(
        &self,
    ) -> std::option::Option<&[crate::model::ObjectLambdaAccessPoint]> {
        self.object_lambda_access_point_list.as_deref()
    }
    /// <p>If the list has more access points than can be returned in one call to this
    /// API, this field contains a continuation token that you can provide in subsequent calls to
    /// this API to retrieve additional access points.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAccessPointsForObjectLambdaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccessPointsForObjectLambdaOutput");
        formatter.field(
            "object_lambda_access_point_list",
            &self.object_lambda_access_point_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAccessPointsForObjectLambdaOutput`](crate::output::ListAccessPointsForObjectLambdaOutput)
pub mod list_access_points_for_object_lambda_output {
    /// A builder for [`ListAccessPointsForObjectLambdaOutput`](crate::output::ListAccessPointsForObjectLambdaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_lambda_access_point_list:
            std::option::Option<std::vec::Vec<crate::model::ObjectLambdaAccessPoint>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `object_lambda_access_point_list`.
        ///
        /// To override the contents of this collection use [`set_object_lambda_access_point_list`](Self::set_object_lambda_access_point_list).
        ///
        /// <p>Returns list of Object Lambda Access Points.</p>
        pub fn object_lambda_access_point_list(
            mut self,
            input: impl Into<crate::model::ObjectLambdaAccessPoint>,
        ) -> Self {
            let mut v = self.object_lambda_access_point_list.unwrap_or_default();
            v.push(input.into());
            self.object_lambda_access_point_list = Some(v);
            self
        }
        /// <p>Returns list of Object Lambda Access Points.</p>
        pub fn set_object_lambda_access_point_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ObjectLambdaAccessPoint>>,
        ) -> Self {
            self.object_lambda_access_point_list = input;
            self
        }
        /// <p>If the list has more access points than can be returned in one call to this
        /// API, this field contains a continuation token that you can provide in subsequent calls to
        /// this API to retrieve additional access points.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the list has more access points than can be returned in one call to this
        /// API, this field contains a continuation token that you can provide in subsequent calls to
        /// this API to retrieve additional access points.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccessPointsForObjectLambdaOutput`](crate::output::ListAccessPointsForObjectLambdaOutput)
        pub fn build(self) -> crate::output::ListAccessPointsForObjectLambdaOutput {
            crate::output::ListAccessPointsForObjectLambdaOutput {
                object_lambda_access_point_list: self.object_lambda_access_point_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAccessPointsForObjectLambdaOutput {
    /// Creates a new builder-style object to manufacture [`ListAccessPointsForObjectLambdaOutput`](crate::output::ListAccessPointsForObjectLambdaOutput)
    pub fn builder() -> crate::output::list_access_points_for_object_lambda_output::Builder {
        crate::output::list_access_points_for_object_lambda_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccessPointsOutput {
    /// <p>Contains identification and configuration information for one or more access points
    /// associated with the specified bucket.</p>
    pub access_point_list: std::option::Option<std::vec::Vec<crate::model::AccessPoint>>,
    /// <p>If the specified bucket has more access points than can be returned in one call to this
    /// API, this field contains a continuation token that you can provide in subsequent calls to
    /// this API to retrieve additional access points.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAccessPointsOutput {
    /// <p>Contains identification and configuration information for one or more access points
    /// associated with the specified bucket.</p>
    pub fn access_point_list(&self) -> std::option::Option<&[crate::model::AccessPoint]> {
        self.access_point_list.as_deref()
    }
    /// <p>If the specified bucket has more access points than can be returned in one call to this
    /// API, this field contains a continuation token that you can provide in subsequent calls to
    /// this API to retrieve additional access points.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAccessPointsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccessPointsOutput");
        formatter.field("access_point_list", &self.access_point_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAccessPointsOutput`](crate::output::ListAccessPointsOutput)
pub mod list_access_points_output {
    /// A builder for [`ListAccessPointsOutput`](crate::output::ListAccessPointsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_point_list: std::option::Option<std::vec::Vec<crate::model::AccessPoint>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `access_point_list`.
        ///
        /// To override the contents of this collection use [`set_access_point_list`](Self::set_access_point_list).
        ///
        /// <p>Contains identification and configuration information for one or more access points
        /// associated with the specified bucket.</p>
        pub fn access_point_list(mut self, input: impl Into<crate::model::AccessPoint>) -> Self {
            let mut v = self.access_point_list.unwrap_or_default();
            v.push(input.into());
            self.access_point_list = Some(v);
            self
        }
        /// <p>Contains identification and configuration information for one or more access points
        /// associated with the specified bucket.</p>
        pub fn set_access_point_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccessPoint>>,
        ) -> Self {
            self.access_point_list = input;
            self
        }
        /// <p>If the specified bucket has more access points than can be returned in one call to this
        /// API, this field contains a continuation token that you can provide in subsequent calls to
        /// this API to retrieve additional access points.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the specified bucket has more access points than can be returned in one call to this
        /// API, this field contains a continuation token that you can provide in subsequent calls to
        /// this API to retrieve additional access points.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccessPointsOutput`](crate::output::ListAccessPointsOutput)
        pub fn build(self) -> crate::output::ListAccessPointsOutput {
            crate::output::ListAccessPointsOutput {
                access_point_list: self.access_point_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAccessPointsOutput {
    /// Creates a new builder-style object to manufacture [`ListAccessPointsOutput`](crate::output::ListAccessPointsOutput)
    pub fn builder() -> crate::output::list_access_points_output::Builder {
        crate::output::list_access_points_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStorageLensConfigurationTaggingOutput {
    /// <p>The tags of S3 Storage Lens configuration requested.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::StorageLensTag>>,
}
impl GetStorageLensConfigurationTaggingOutput {
    /// <p>The tags of S3 Storage Lens configuration requested.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::StorageLensTag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for GetStorageLensConfigurationTaggingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStorageLensConfigurationTaggingOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetStorageLensConfigurationTaggingOutput`](crate::output::GetStorageLensConfigurationTaggingOutput)
pub mod get_storage_lens_configuration_tagging_output {
    /// A builder for [`GetStorageLensConfigurationTaggingOutput`](crate::output::GetStorageLensConfigurationTaggingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::StorageLensTag>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags of S3 Storage Lens configuration requested.</p>
        pub fn tags(mut self, input: impl Into<crate::model::StorageLensTag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags of S3 Storage Lens configuration requested.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StorageLensTag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStorageLensConfigurationTaggingOutput`](crate::output::GetStorageLensConfigurationTaggingOutput)
        pub fn build(self) -> crate::output::GetStorageLensConfigurationTaggingOutput {
            crate::output::GetStorageLensConfigurationTaggingOutput { tags: self.tags }
        }
    }
}
impl GetStorageLensConfigurationTaggingOutput {
    /// Creates a new builder-style object to manufacture [`GetStorageLensConfigurationTaggingOutput`](crate::output::GetStorageLensConfigurationTaggingOutput)
    pub fn builder() -> crate::output::get_storage_lens_configuration_tagging_output::Builder {
        crate::output::get_storage_lens_configuration_tagging_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetStorageLensConfigurationOutput {
    /// <p>The S3 Storage Lens configuration requested.</p>
    pub storage_lens_configuration: std::option::Option<crate::model::StorageLensConfiguration>,
}
impl GetStorageLensConfigurationOutput {
    /// <p>The S3 Storage Lens configuration requested.</p>
    pub fn storage_lens_configuration(
        &self,
    ) -> std::option::Option<&crate::model::StorageLensConfiguration> {
        self.storage_lens_configuration.as_ref()
    }
}
impl std::fmt::Debug for GetStorageLensConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetStorageLensConfigurationOutput");
        formatter.field(
            "storage_lens_configuration",
            &self.storage_lens_configuration,
        );
        formatter.finish()
    }
}
/// See [`GetStorageLensConfigurationOutput`](crate::output::GetStorageLensConfigurationOutput)
pub mod get_storage_lens_configuration_output {
    /// A builder for [`GetStorageLensConfigurationOutput`](crate::output::GetStorageLensConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) storage_lens_configuration:
            std::option::Option<crate::model::StorageLensConfiguration>,
    }
    impl Builder {
        /// <p>The S3 Storage Lens configuration requested.</p>
        pub fn storage_lens_configuration(
            mut self,
            input: crate::model::StorageLensConfiguration,
        ) -> Self {
            self.storage_lens_configuration = Some(input);
            self
        }
        /// <p>The S3 Storage Lens configuration requested.</p>
        pub fn set_storage_lens_configuration(
            mut self,
            input: std::option::Option<crate::model::StorageLensConfiguration>,
        ) -> Self {
            self.storage_lens_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GetStorageLensConfigurationOutput`](crate::output::GetStorageLensConfigurationOutput)
        pub fn build(self) -> crate::output::GetStorageLensConfigurationOutput {
            crate::output::GetStorageLensConfigurationOutput {
                storage_lens_configuration: self.storage_lens_configuration,
            }
        }
    }
}
impl GetStorageLensConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetStorageLensConfigurationOutput`](crate::output::GetStorageLensConfigurationOutput)
    pub fn builder() -> crate::output::get_storage_lens_configuration_output::Builder {
        crate::output::get_storage_lens_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPublicAccessBlockOutput {
    /// <p>The <code>PublicAccessBlock</code> configuration currently in effect for this Amazon Web Services account.</p>
    pub public_access_block_configuration:
        std::option::Option<crate::model::PublicAccessBlockConfiguration>,
}
impl GetPublicAccessBlockOutput {
    /// <p>The <code>PublicAccessBlock</code> configuration currently in effect for this Amazon Web Services account.</p>
    pub fn public_access_block_configuration(
        &self,
    ) -> std::option::Option<&crate::model::PublicAccessBlockConfiguration> {
        self.public_access_block_configuration.as_ref()
    }
}
impl std::fmt::Debug for GetPublicAccessBlockOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPublicAccessBlockOutput");
        formatter.field(
            "public_access_block_configuration",
            &self.public_access_block_configuration,
        );
        formatter.finish()
    }
}
/// See [`GetPublicAccessBlockOutput`](crate::output::GetPublicAccessBlockOutput)
pub mod get_public_access_block_output {
    /// A builder for [`GetPublicAccessBlockOutput`](crate::output::GetPublicAccessBlockOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) public_access_block_configuration:
            std::option::Option<crate::model::PublicAccessBlockConfiguration>,
    }
    impl Builder {
        /// <p>The <code>PublicAccessBlock</code> configuration currently in effect for this Amazon Web Services account.</p>
        pub fn public_access_block_configuration(
            mut self,
            input: crate::model::PublicAccessBlockConfiguration,
        ) -> Self {
            self.public_access_block_configuration = Some(input);
            self
        }
        /// <p>The <code>PublicAccessBlock</code> configuration currently in effect for this Amazon Web Services account.</p>
        pub fn set_public_access_block_configuration(
            mut self,
            input: std::option::Option<crate::model::PublicAccessBlockConfiguration>,
        ) -> Self {
            self.public_access_block_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPublicAccessBlockOutput`](crate::output::GetPublicAccessBlockOutput)
        pub fn build(self) -> crate::output::GetPublicAccessBlockOutput {
            crate::output::GetPublicAccessBlockOutput {
                public_access_block_configuration: self.public_access_block_configuration,
            }
        }
    }
}
impl GetPublicAccessBlockOutput {
    /// Creates a new builder-style object to manufacture [`GetPublicAccessBlockOutput`](crate::output::GetPublicAccessBlockOutput)
    pub fn builder() -> crate::output::get_public_access_block_output::Builder {
        crate::output::get_public_access_block_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMultiRegionAccessPointPolicyStatusOutput {
    /// <p>Indicates whether this access point policy is public. For more information about how Amazon S3 evaluates policies to determine whether they are public, see
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the
    /// <i>Amazon S3 User Guide</i>.
    /// </p>
    pub established: std::option::Option<crate::model::PolicyStatus>,
}
impl GetMultiRegionAccessPointPolicyStatusOutput {
    /// <p>Indicates whether this access point policy is public. For more information about how Amazon S3 evaluates policies to determine whether they are public, see
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the
    /// <i>Amazon S3 User Guide</i>.
    /// </p>
    pub fn established(&self) -> std::option::Option<&crate::model::PolicyStatus> {
        self.established.as_ref()
    }
}
impl std::fmt::Debug for GetMultiRegionAccessPointPolicyStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMultiRegionAccessPointPolicyStatusOutput");
        formatter.field("established", &self.established);
        formatter.finish()
    }
}
/// See [`GetMultiRegionAccessPointPolicyStatusOutput`](crate::output::GetMultiRegionAccessPointPolicyStatusOutput)
pub mod get_multi_region_access_point_policy_status_output {
    /// A builder for [`GetMultiRegionAccessPointPolicyStatusOutput`](crate::output::GetMultiRegionAccessPointPolicyStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) established: std::option::Option<crate::model::PolicyStatus>,
    }
    impl Builder {
        /// <p>Indicates whether this access point policy is public. For more information about how Amazon S3 evaluates policies to determine whether they are public, see
        /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the
        /// <i>Amazon S3 User Guide</i>.
        /// </p>
        pub fn established(mut self, input: crate::model::PolicyStatus) -> Self {
            self.established = Some(input);
            self
        }
        /// <p>Indicates whether this access point policy is public. For more information about how Amazon S3 evaluates policies to determine whether they are public, see
        /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the
        /// <i>Amazon S3 User Guide</i>.
        /// </p>
        pub fn set_established(
            mut self,
            input: std::option::Option<crate::model::PolicyStatus>,
        ) -> Self {
            self.established = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMultiRegionAccessPointPolicyStatusOutput`](crate::output::GetMultiRegionAccessPointPolicyStatusOutput)
        pub fn build(self) -> crate::output::GetMultiRegionAccessPointPolicyStatusOutput {
            crate::output::GetMultiRegionAccessPointPolicyStatusOutput {
                established: self.established,
            }
        }
    }
}
impl GetMultiRegionAccessPointPolicyStatusOutput {
    /// Creates a new builder-style object to manufacture [`GetMultiRegionAccessPointPolicyStatusOutput`](crate::output::GetMultiRegionAccessPointPolicyStatusOutput)
    pub fn builder() -> crate::output::get_multi_region_access_point_policy_status_output::Builder {
        crate::output::get_multi_region_access_point_policy_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMultiRegionAccessPointPolicyOutput {
    /// <p>The policy associated with the specified Multi-Region Access Point.</p>
    pub policy: std::option::Option<crate::model::MultiRegionAccessPointPolicyDocument>,
}
impl GetMultiRegionAccessPointPolicyOutput {
    /// <p>The policy associated with the specified Multi-Region Access Point.</p>
    pub fn policy(
        &self,
    ) -> std::option::Option<&crate::model::MultiRegionAccessPointPolicyDocument> {
        self.policy.as_ref()
    }
}
impl std::fmt::Debug for GetMultiRegionAccessPointPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMultiRegionAccessPointPolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`GetMultiRegionAccessPointPolicyOutput`](crate::output::GetMultiRegionAccessPointPolicyOutput)
pub mod get_multi_region_access_point_policy_output {
    /// A builder for [`GetMultiRegionAccessPointPolicyOutput`](crate::output::GetMultiRegionAccessPointPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<crate::model::MultiRegionAccessPointPolicyDocument>,
    }
    impl Builder {
        /// <p>The policy associated with the specified Multi-Region Access Point.</p>
        pub fn policy(mut self, input: crate::model::MultiRegionAccessPointPolicyDocument) -> Self {
            self.policy = Some(input);
            self
        }
        /// <p>The policy associated with the specified Multi-Region Access Point.</p>
        pub fn set_policy(
            mut self,
            input: std::option::Option<crate::model::MultiRegionAccessPointPolicyDocument>,
        ) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMultiRegionAccessPointPolicyOutput`](crate::output::GetMultiRegionAccessPointPolicyOutput)
        pub fn build(self) -> crate::output::GetMultiRegionAccessPointPolicyOutput {
            crate::output::GetMultiRegionAccessPointPolicyOutput {
                policy: self.policy,
            }
        }
    }
}
impl GetMultiRegionAccessPointPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetMultiRegionAccessPointPolicyOutput`](crate::output::GetMultiRegionAccessPointPolicyOutput)
    pub fn builder() -> crate::output::get_multi_region_access_point_policy_output::Builder {
        crate::output::get_multi_region_access_point_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMultiRegionAccessPointOutput {
    /// <p>A container element containing the details of the requested Multi-Region Access Point.</p>
    pub access_point: std::option::Option<crate::model::MultiRegionAccessPointReport>,
}
impl GetMultiRegionAccessPointOutput {
    /// <p>A container element containing the details of the requested Multi-Region Access Point.</p>
    pub fn access_point(&self) -> std::option::Option<&crate::model::MultiRegionAccessPointReport> {
        self.access_point.as_ref()
    }
}
impl std::fmt::Debug for GetMultiRegionAccessPointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMultiRegionAccessPointOutput");
        formatter.field("access_point", &self.access_point);
        formatter.finish()
    }
}
/// See [`GetMultiRegionAccessPointOutput`](crate::output::GetMultiRegionAccessPointOutput)
pub mod get_multi_region_access_point_output {
    /// A builder for [`GetMultiRegionAccessPointOutput`](crate::output::GetMultiRegionAccessPointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_point: std::option::Option<crate::model::MultiRegionAccessPointReport>,
    }
    impl Builder {
        /// <p>A container element containing the details of the requested Multi-Region Access Point.</p>
        pub fn access_point(mut self, input: crate::model::MultiRegionAccessPointReport) -> Self {
            self.access_point = Some(input);
            self
        }
        /// <p>A container element containing the details of the requested Multi-Region Access Point.</p>
        pub fn set_access_point(
            mut self,
            input: std::option::Option<crate::model::MultiRegionAccessPointReport>,
        ) -> Self {
            self.access_point = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMultiRegionAccessPointOutput`](crate::output::GetMultiRegionAccessPointOutput)
        pub fn build(self) -> crate::output::GetMultiRegionAccessPointOutput {
            crate::output::GetMultiRegionAccessPointOutput {
                access_point: self.access_point,
            }
        }
    }
}
impl GetMultiRegionAccessPointOutput {
    /// Creates a new builder-style object to manufacture [`GetMultiRegionAccessPointOutput`](crate::output::GetMultiRegionAccessPointOutput)
    pub fn builder() -> crate::output::get_multi_region_access_point_output::Builder {
        crate::output::get_multi_region_access_point_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetJobTaggingOutput {
    /// <p>The set of tags associated with the S3 Batch Operations job.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
}
impl GetJobTaggingOutput {
    /// <p>The set of tags associated with the S3 Batch Operations job.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::S3Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for GetJobTaggingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetJobTaggingOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetJobTaggingOutput`](crate::output::GetJobTaggingOutput)
pub mod get_job_tagging_output {
    /// A builder for [`GetJobTaggingOutput`](crate::output::GetJobTaggingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The set of tags associated with the S3 Batch Operations job.</p>
        pub fn tags(mut self, input: impl Into<crate::model::S3Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The set of tags associated with the S3 Batch Operations job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetJobTaggingOutput`](crate::output::GetJobTaggingOutput)
        pub fn build(self) -> crate::output::GetJobTaggingOutput {
            crate::output::GetJobTaggingOutput { tags: self.tags }
        }
    }
}
impl GetJobTaggingOutput {
    /// Creates a new builder-style object to manufacture [`GetJobTaggingOutput`](crate::output::GetJobTaggingOutput)
    pub fn builder() -> crate::output::get_job_tagging_output::Builder {
        crate::output::get_job_tagging_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketTaggingOutput {
    /// <p>The tags set of the Outposts bucket.</p>
    pub tag_set: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
}
impl GetBucketTaggingOutput {
    /// <p>The tags set of the Outposts bucket.</p>
    pub fn tag_set(&self) -> std::option::Option<&[crate::model::S3Tag]> {
        self.tag_set.as_deref()
    }
}
impl std::fmt::Debug for GetBucketTaggingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketTaggingOutput");
        formatter.field("tag_set", &self.tag_set);
        formatter.finish()
    }
}
/// See [`GetBucketTaggingOutput`](crate::output::GetBucketTaggingOutput)
pub mod get_bucket_tagging_output {
    /// A builder for [`GetBucketTaggingOutput`](crate::output::GetBucketTaggingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_set: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
    }
    impl Builder {
        /// Appends an item to `tag_set`.
        ///
        /// To override the contents of this collection use [`set_tag_set`](Self::set_tag_set).
        ///
        /// <p>The tags set of the Outposts bucket.</p>
        pub fn tag_set(mut self, input: impl Into<crate::model::S3Tag>) -> Self {
            let mut v = self.tag_set.unwrap_or_default();
            v.push(input.into());
            self.tag_set = Some(v);
            self
        }
        /// <p>The tags set of the Outposts bucket.</p>
        pub fn set_tag_set(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
        ) -> Self {
            self.tag_set = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketTaggingOutput`](crate::output::GetBucketTaggingOutput)
        pub fn build(self) -> crate::output::GetBucketTaggingOutput {
            crate::output::GetBucketTaggingOutput {
                tag_set: self.tag_set,
            }
        }
    }
}
impl GetBucketTaggingOutput {
    /// Creates a new builder-style object to manufacture [`GetBucketTaggingOutput`](crate::output::GetBucketTaggingOutput)
    pub fn builder() -> crate::output::get_bucket_tagging_output::Builder {
        crate::output::get_bucket_tagging_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketPolicyOutput {
    /// <p>The policy of the Outposts bucket.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl GetBucketPolicyOutput {
    /// <p>The policy of the Outposts bucket.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for GetBucketPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketPolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`GetBucketPolicyOutput`](crate::output::GetBucketPolicyOutput)
pub mod get_bucket_policy_output {
    /// A builder for [`GetBucketPolicyOutput`](crate::output::GetBucketPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The policy of the Outposts bucket.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The policy of the Outposts bucket.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketPolicyOutput`](crate::output::GetBucketPolicyOutput)
        pub fn build(self) -> crate::output::GetBucketPolicyOutput {
            crate::output::GetBucketPolicyOutput {
                policy: self.policy,
            }
        }
    }
}
impl GetBucketPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetBucketPolicyOutput`](crate::output::GetBucketPolicyOutput)
    pub fn builder() -> crate::output::get_bucket_policy_output::Builder {
        crate::output::get_bucket_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketLifecycleConfigurationOutput {
    /// <p>Container for the lifecycle rule of the Outposts bucket.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::LifecycleRule>>,
}
impl GetBucketLifecycleConfigurationOutput {
    /// <p>Container for the lifecycle rule of the Outposts bucket.</p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::LifecycleRule]> {
        self.rules.as_deref()
    }
}
impl std::fmt::Debug for GetBucketLifecycleConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketLifecycleConfigurationOutput");
        formatter.field("rules", &self.rules);
        formatter.finish()
    }
}
/// See [`GetBucketLifecycleConfigurationOutput`](crate::output::GetBucketLifecycleConfigurationOutput)
pub mod get_bucket_lifecycle_configuration_output {
    /// A builder for [`GetBucketLifecycleConfigurationOutput`](crate::output::GetBucketLifecycleConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::LifecycleRule>>,
    }
    impl Builder {
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>Container for the lifecycle rule of the Outposts bucket.</p>
        pub fn rules(mut self, input: impl Into<crate::model::LifecycleRule>) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input.into());
            self.rules = Some(v);
            self
        }
        /// <p>Container for the lifecycle rule of the Outposts bucket.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LifecycleRule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketLifecycleConfigurationOutput`](crate::output::GetBucketLifecycleConfigurationOutput)
        pub fn build(self) -> crate::output::GetBucketLifecycleConfigurationOutput {
            crate::output::GetBucketLifecycleConfigurationOutput { rules: self.rules }
        }
    }
}
impl GetBucketLifecycleConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetBucketLifecycleConfigurationOutput`](crate::output::GetBucketLifecycleConfigurationOutput)
    pub fn builder() -> crate::output::get_bucket_lifecycle_configuration_output::Builder {
        crate::output::get_bucket_lifecycle_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketOutput {
    /// <p>The Outposts bucket requested.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p></p>
    pub public_access_block_enabled: bool,
    /// <p>The creation date of the Outposts bucket.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl GetBucketOutput {
    /// <p>The Outposts bucket requested.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p></p>
    pub fn public_access_block_enabled(&self) -> bool {
        self.public_access_block_enabled
    }
    /// <p>The creation date of the Outposts bucket.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
}
impl std::fmt::Debug for GetBucketOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketOutput");
        formatter.field("bucket", &self.bucket);
        formatter.field(
            "public_access_block_enabled",
            &self.public_access_block_enabled,
        );
        formatter.field("creation_date", &self.creation_date);
        formatter.finish()
    }
}
/// See [`GetBucketOutput`](crate::output::GetBucketOutput)
pub mod get_bucket_output {
    /// A builder for [`GetBucketOutput`](crate::output::GetBucketOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) public_access_block_enabled: std::option::Option<bool>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Outposts bucket requested.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The Outposts bucket requested.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p></p>
        pub fn public_access_block_enabled(mut self, input: bool) -> Self {
            self.public_access_block_enabled = Some(input);
            self
        }
        /// <p></p>
        pub fn set_public_access_block_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.public_access_block_enabled = input;
            self
        }
        /// <p>The creation date of the Outposts bucket.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The creation date of the Outposts bucket.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketOutput`](crate::output::GetBucketOutput)
        pub fn build(self) -> crate::output::GetBucketOutput {
            crate::output::GetBucketOutput {
                bucket: self.bucket,
                public_access_block_enabled: self.public_access_block_enabled.unwrap_or_default(),
                creation_date: self.creation_date,
            }
        }
    }
}
impl GetBucketOutput {
    /// Creates a new builder-style object to manufacture [`GetBucketOutput`](crate::output::GetBucketOutput)
    pub fn builder() -> crate::output::get_bucket_output::Builder {
        crate::output::get_bucket_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccessPointPolicyStatusForObjectLambdaOutput {
    /// <p>Indicates whether this access point policy is public. For more information about how Amazon S3 evaluates policies to determine whether they are public, see
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the
    /// <i>Amazon S3 User Guide</i>.
    /// </p>
    pub policy_status: std::option::Option<crate::model::PolicyStatus>,
}
impl GetAccessPointPolicyStatusForObjectLambdaOutput {
    /// <p>Indicates whether this access point policy is public. For more information about how Amazon S3 evaluates policies to determine whether they are public, see
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the
    /// <i>Amazon S3 User Guide</i>.
    /// </p>
    pub fn policy_status(&self) -> std::option::Option<&crate::model::PolicyStatus> {
        self.policy_status.as_ref()
    }
}
impl std::fmt::Debug for GetAccessPointPolicyStatusForObjectLambdaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccessPointPolicyStatusForObjectLambdaOutput");
        formatter.field("policy_status", &self.policy_status);
        formatter.finish()
    }
}
/// See [`GetAccessPointPolicyStatusForObjectLambdaOutput`](crate::output::GetAccessPointPolicyStatusForObjectLambdaOutput)
pub mod get_access_point_policy_status_for_object_lambda_output {
    /// A builder for [`GetAccessPointPolicyStatusForObjectLambdaOutput`](crate::output::GetAccessPointPolicyStatusForObjectLambdaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_status: std::option::Option<crate::model::PolicyStatus>,
    }
    impl Builder {
        /// <p>Indicates whether this access point policy is public. For more information about how Amazon S3 evaluates policies to determine whether they are public, see
        /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the
        /// <i>Amazon S3 User Guide</i>.
        /// </p>
        pub fn policy_status(mut self, input: crate::model::PolicyStatus) -> Self {
            self.policy_status = Some(input);
            self
        }
        /// <p>Indicates whether this access point policy is public. For more information about how Amazon S3 evaluates policies to determine whether they are public, see
        /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the
        /// <i>Amazon S3 User Guide</i>.
        /// </p>
        pub fn set_policy_status(
            mut self,
            input: std::option::Option<crate::model::PolicyStatus>,
        ) -> Self {
            self.policy_status = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccessPointPolicyStatusForObjectLambdaOutput`](crate::output::GetAccessPointPolicyStatusForObjectLambdaOutput)
        pub fn build(self) -> crate::output::GetAccessPointPolicyStatusForObjectLambdaOutput {
            crate::output::GetAccessPointPolicyStatusForObjectLambdaOutput {
                policy_status: self.policy_status,
            }
        }
    }
}
impl GetAccessPointPolicyStatusForObjectLambdaOutput {
    /// Creates a new builder-style object to manufacture [`GetAccessPointPolicyStatusForObjectLambdaOutput`](crate::output::GetAccessPointPolicyStatusForObjectLambdaOutput)
    pub fn builder(
    ) -> crate::output::get_access_point_policy_status_for_object_lambda_output::Builder {
        crate::output::get_access_point_policy_status_for_object_lambda_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccessPointPolicyStatusOutput {
    /// <p>Indicates the current policy status of the specified access point.</p>
    pub policy_status: std::option::Option<crate::model::PolicyStatus>,
}
impl GetAccessPointPolicyStatusOutput {
    /// <p>Indicates the current policy status of the specified access point.</p>
    pub fn policy_status(&self) -> std::option::Option<&crate::model::PolicyStatus> {
        self.policy_status.as_ref()
    }
}
impl std::fmt::Debug for GetAccessPointPolicyStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccessPointPolicyStatusOutput");
        formatter.field("policy_status", &self.policy_status);
        formatter.finish()
    }
}
/// See [`GetAccessPointPolicyStatusOutput`](crate::output::GetAccessPointPolicyStatusOutput)
pub mod get_access_point_policy_status_output {
    /// A builder for [`GetAccessPointPolicyStatusOutput`](crate::output::GetAccessPointPolicyStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_status: std::option::Option<crate::model::PolicyStatus>,
    }
    impl Builder {
        /// <p>Indicates the current policy status of the specified access point.</p>
        pub fn policy_status(mut self, input: crate::model::PolicyStatus) -> Self {
            self.policy_status = Some(input);
            self
        }
        /// <p>Indicates the current policy status of the specified access point.</p>
        pub fn set_policy_status(
            mut self,
            input: std::option::Option<crate::model::PolicyStatus>,
        ) -> Self {
            self.policy_status = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccessPointPolicyStatusOutput`](crate::output::GetAccessPointPolicyStatusOutput)
        pub fn build(self) -> crate::output::GetAccessPointPolicyStatusOutput {
            crate::output::GetAccessPointPolicyStatusOutput {
                policy_status: self.policy_status,
            }
        }
    }
}
impl GetAccessPointPolicyStatusOutput {
    /// Creates a new builder-style object to manufacture [`GetAccessPointPolicyStatusOutput`](crate::output::GetAccessPointPolicyStatusOutput)
    pub fn builder() -> crate::output::get_access_point_policy_status_output::Builder {
        crate::output::get_access_point_policy_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccessPointPolicyForObjectLambdaOutput {
    /// <p>Object Lambda Access Point resource policy document.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl GetAccessPointPolicyForObjectLambdaOutput {
    /// <p>Object Lambda Access Point resource policy document.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for GetAccessPointPolicyForObjectLambdaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccessPointPolicyForObjectLambdaOutput");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`GetAccessPointPolicyForObjectLambdaOutput`](crate::output::GetAccessPointPolicyForObjectLambdaOutput)
pub mod get_access_point_policy_for_object_lambda_output {
    /// A builder for [`GetAccessPointPolicyForObjectLambdaOutput`](crate::output::GetAccessPointPolicyForObjectLambdaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Object Lambda Access Point resource policy document.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>Object Lambda Access Point resource policy document.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccessPointPolicyForObjectLambdaOutput`](crate::output::GetAccessPointPolicyForObjectLambdaOutput)
        pub fn build(self) -> crate::output::GetAccessPointPolicyForObjectLambdaOutput {
            crate::output::GetAccessPointPolicyForObjectLambdaOutput {
                policy: self.policy,
            }
        }
    }
}
impl GetAccessPointPolicyForObjectLambdaOutput {
    /// Creates a new builder-style object to manufacture [`GetAccessPointPolicyForObjectLambdaOutput`](crate::output::GetAccessPointPolicyForObjectLambdaOutput)
    pub fn builder() -> crate::output::get_access_point_policy_for_object_lambda_output::Builder {
        crate::output::get_access_point_policy_for_object_lambda_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccessPointPolicyOutput {
    /// <p>The access point policy associated with the specified access point.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl GetAccessPointPolicyOutput {
    /// <p>The access point policy associated with the specified access point.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for GetAccessPointPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccessPointPolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`GetAccessPointPolicyOutput`](crate::output::GetAccessPointPolicyOutput)
pub mod get_access_point_policy_output {
    /// A builder for [`GetAccessPointPolicyOutput`](crate::output::GetAccessPointPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The access point policy associated with the specified access point.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The access point policy associated with the specified access point.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccessPointPolicyOutput`](crate::output::GetAccessPointPolicyOutput)
        pub fn build(self) -> crate::output::GetAccessPointPolicyOutput {
            crate::output::GetAccessPointPolicyOutput {
                policy: self.policy,
            }
        }
    }
}
impl GetAccessPointPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetAccessPointPolicyOutput`](crate::output::GetAccessPointPolicyOutput)
    pub fn builder() -> crate::output::get_access_point_policy_output::Builder {
        crate::output::get_access_point_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccessPointForObjectLambdaOutput {
    /// <p>The name of the Object Lambda Access Point.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Configuration to block all public access. This setting is turned on and can not be edited. </p>
    pub public_access_block_configuration:
        std::option::Option<crate::model::PublicAccessBlockConfiguration>,
    /// <p>The date and time when the specified Object Lambda Access Point was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl GetAccessPointForObjectLambdaOutput {
    /// <p>The name of the Object Lambda Access Point.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Configuration to block all public access. This setting is turned on and can not be edited. </p>
    pub fn public_access_block_configuration(
        &self,
    ) -> std::option::Option<&crate::model::PublicAccessBlockConfiguration> {
        self.public_access_block_configuration.as_ref()
    }
    /// <p>The date and time when the specified Object Lambda Access Point was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
}
impl std::fmt::Debug for GetAccessPointForObjectLambdaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccessPointForObjectLambdaOutput");
        formatter.field("name", &self.name);
        formatter.field(
            "public_access_block_configuration",
            &self.public_access_block_configuration,
        );
        formatter.field("creation_date", &self.creation_date);
        formatter.finish()
    }
}
/// See [`GetAccessPointForObjectLambdaOutput`](crate::output::GetAccessPointForObjectLambdaOutput)
pub mod get_access_point_for_object_lambda_output {
    /// A builder for [`GetAccessPointForObjectLambdaOutput`](crate::output::GetAccessPointForObjectLambdaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) public_access_block_configuration:
            std::option::Option<crate::model::PublicAccessBlockConfiguration>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Configuration to block all public access. This setting is turned on and can not be edited. </p>
        pub fn public_access_block_configuration(
            mut self,
            input: crate::model::PublicAccessBlockConfiguration,
        ) -> Self {
            self.public_access_block_configuration = Some(input);
            self
        }
        /// <p>Configuration to block all public access. This setting is turned on and can not be edited. </p>
        pub fn set_public_access_block_configuration(
            mut self,
            input: std::option::Option<crate::model::PublicAccessBlockConfiguration>,
        ) -> Self {
            self.public_access_block_configuration = input;
            self
        }
        /// <p>The date and time when the specified Object Lambda Access Point was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time when the specified Object Lambda Access Point was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccessPointForObjectLambdaOutput`](crate::output::GetAccessPointForObjectLambdaOutput)
        pub fn build(self) -> crate::output::GetAccessPointForObjectLambdaOutput {
            crate::output::GetAccessPointForObjectLambdaOutput {
                name: self.name,
                public_access_block_configuration: self.public_access_block_configuration,
                creation_date: self.creation_date,
            }
        }
    }
}
impl GetAccessPointForObjectLambdaOutput {
    /// Creates a new builder-style object to manufacture [`GetAccessPointForObjectLambdaOutput`](crate::output::GetAccessPointForObjectLambdaOutput)
    pub fn builder() -> crate::output::get_access_point_for_object_lambda_output::Builder {
        crate::output::get_access_point_for_object_lambda_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccessPointConfigurationForObjectLambdaOutput {
    /// <p>Object Lambda Access Point configuration document.</p>
    pub configuration: std::option::Option<crate::model::ObjectLambdaConfiguration>,
}
impl GetAccessPointConfigurationForObjectLambdaOutput {
    /// <p>Object Lambda Access Point configuration document.</p>
    pub fn configuration(&self) -> std::option::Option<&crate::model::ObjectLambdaConfiguration> {
        self.configuration.as_ref()
    }
}
impl std::fmt::Debug for GetAccessPointConfigurationForObjectLambdaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccessPointConfigurationForObjectLambdaOutput");
        formatter.field("configuration", &self.configuration);
        formatter.finish()
    }
}
/// See [`GetAccessPointConfigurationForObjectLambdaOutput`](crate::output::GetAccessPointConfigurationForObjectLambdaOutput)
pub mod get_access_point_configuration_for_object_lambda_output {
    /// A builder for [`GetAccessPointConfigurationForObjectLambdaOutput`](crate::output::GetAccessPointConfigurationForObjectLambdaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration: std::option::Option<crate::model::ObjectLambdaConfiguration>,
    }
    impl Builder {
        /// <p>Object Lambda Access Point configuration document.</p>
        pub fn configuration(mut self, input: crate::model::ObjectLambdaConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>Object Lambda Access Point configuration document.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ObjectLambdaConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccessPointConfigurationForObjectLambdaOutput`](crate::output::GetAccessPointConfigurationForObjectLambdaOutput)
        pub fn build(self) -> crate::output::GetAccessPointConfigurationForObjectLambdaOutput {
            crate::output::GetAccessPointConfigurationForObjectLambdaOutput {
                configuration: self.configuration,
            }
        }
    }
}
impl GetAccessPointConfigurationForObjectLambdaOutput {
    /// Creates a new builder-style object to manufacture [`GetAccessPointConfigurationForObjectLambdaOutput`](crate::output::GetAccessPointConfigurationForObjectLambdaOutput)
    pub fn builder(
    ) -> crate::output::get_access_point_configuration_for_object_lambda_output::Builder {
        crate::output::get_access_point_configuration_for_object_lambda_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccessPointOutput {
    /// <p>The name of the specified access point.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the bucket associated with the specified access point.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>Indicates whether this access point allows access from the public internet. If
    /// <code>VpcConfiguration</code> is specified for this access point, then
    /// <code>NetworkOrigin</code> is <code>VPC</code>, and the access point doesn't allow access from
    /// the public internet. Otherwise, <code>NetworkOrigin</code> is <code>Internet</code>, and
    /// the access point allows access from the public internet, subject to the access point and bucket access
    /// policies.</p>
    /// <p>This will always be true for an Amazon S3 on Outposts access point</p>
    pub network_origin: std::option::Option<crate::model::NetworkOrigin>,
    /// <p>Contains the virtual private cloud (VPC) configuration for the specified access point.</p>
    /// <note>
    /// <p>This element is empty if this access point is an Amazon S3 on Outposts access point that is used by other Amazon Web Services.</p>
    /// </note>
    pub vpc_configuration: std::option::Option<crate::model::VpcConfiguration>,
    /// <p>The <code>PublicAccessBlock</code> configuration that you want to apply to this Amazon S3 account.
    /// You can enable the configuration options in any combination. For more information about
    /// when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>This is not supported for Amazon S3 on Outposts.</p>
    pub public_access_block_configuration:
        std::option::Option<crate::model::PublicAccessBlockConfiguration>,
    /// <p>The date and time when the specified access point was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The name or alias of the access point.</p>
    pub alias: std::option::Option<std::string::String>,
    /// <p>The ARN of the access point.</p>
    pub access_point_arn: std::option::Option<std::string::String>,
    /// <p>The VPC endpoint for the access point.</p>
    pub endpoints:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GetAccessPointOutput {
    /// <p>The name of the specified access point.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name of the bucket associated with the specified access point.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>Indicates whether this access point allows access from the public internet. If
    /// <code>VpcConfiguration</code> is specified for this access point, then
    /// <code>NetworkOrigin</code> is <code>VPC</code>, and the access point doesn't allow access from
    /// the public internet. Otherwise, <code>NetworkOrigin</code> is <code>Internet</code>, and
    /// the access point allows access from the public internet, subject to the access point and bucket access
    /// policies.</p>
    /// <p>This will always be true for an Amazon S3 on Outposts access point</p>
    pub fn network_origin(&self) -> std::option::Option<&crate::model::NetworkOrigin> {
        self.network_origin.as_ref()
    }
    /// <p>Contains the virtual private cloud (VPC) configuration for the specified access point.</p>
    /// <note>
    /// <p>This element is empty if this access point is an Amazon S3 on Outposts access point that is used by other Amazon Web Services.</p>
    /// </note>
    pub fn vpc_configuration(&self) -> std::option::Option<&crate::model::VpcConfiguration> {
        self.vpc_configuration.as_ref()
    }
    /// <p>The <code>PublicAccessBlock</code> configuration that you want to apply to this Amazon S3 account.
    /// You can enable the configuration options in any combination. For more information about
    /// when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>This is not supported for Amazon S3 on Outposts.</p>
    pub fn public_access_block_configuration(
        &self,
    ) -> std::option::Option<&crate::model::PublicAccessBlockConfiguration> {
        self.public_access_block_configuration.as_ref()
    }
    /// <p>The date and time when the specified access point was created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The name or alias of the access point.</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
    /// <p>The ARN of the access point.</p>
    pub fn access_point_arn(&self) -> std::option::Option<&str> {
        self.access_point_arn.as_deref()
    }
    /// <p>The VPC endpoint for the access point.</p>
    pub fn endpoints(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.endpoints.as_ref()
    }
}
impl std::fmt::Debug for GetAccessPointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccessPointOutput");
        formatter.field("name", &self.name);
        formatter.field("bucket", &self.bucket);
        formatter.field("network_origin", &self.network_origin);
        formatter.field("vpc_configuration", &self.vpc_configuration);
        formatter.field(
            "public_access_block_configuration",
            &self.public_access_block_configuration,
        );
        formatter.field("creation_date", &self.creation_date);
        formatter.field("alias", &self.alias);
        formatter.field("access_point_arn", &self.access_point_arn);
        formatter.field("endpoints", &self.endpoints);
        formatter.finish()
    }
}
/// See [`GetAccessPointOutput`](crate::output::GetAccessPointOutput)
pub mod get_access_point_output {
    /// A builder for [`GetAccessPointOutput`](crate::output::GetAccessPointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) network_origin: std::option::Option<crate::model::NetworkOrigin>,
        pub(crate) vpc_configuration: std::option::Option<crate::model::VpcConfiguration>,
        pub(crate) public_access_block_configuration:
            std::option::Option<crate::model::PublicAccessBlockConfiguration>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) alias: std::option::Option<std::string::String>,
        pub(crate) access_point_arn: std::option::Option<std::string::String>,
        pub(crate) endpoints: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the specified access point.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the specified access point.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the bucket associated with the specified access point.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket associated with the specified access point.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Indicates whether this access point allows access from the public internet. If
        /// <code>VpcConfiguration</code> is specified for this access point, then
        /// <code>NetworkOrigin</code> is <code>VPC</code>, and the access point doesn't allow access from
        /// the public internet. Otherwise, <code>NetworkOrigin</code> is <code>Internet</code>, and
        /// the access point allows access from the public internet, subject to the access point and bucket access
        /// policies.</p>
        /// <p>This will always be true for an Amazon S3 on Outposts access point</p>
        pub fn network_origin(mut self, input: crate::model::NetworkOrigin) -> Self {
            self.network_origin = Some(input);
            self
        }
        /// <p>Indicates whether this access point allows access from the public internet. If
        /// <code>VpcConfiguration</code> is specified for this access point, then
        /// <code>NetworkOrigin</code> is <code>VPC</code>, and the access point doesn't allow access from
        /// the public internet. Otherwise, <code>NetworkOrigin</code> is <code>Internet</code>, and
        /// the access point allows access from the public internet, subject to the access point and bucket access
        /// policies.</p>
        /// <p>This will always be true for an Amazon S3 on Outposts access point</p>
        pub fn set_network_origin(
            mut self,
            input: std::option::Option<crate::model::NetworkOrigin>,
        ) -> Self {
            self.network_origin = input;
            self
        }
        /// <p>Contains the virtual private cloud (VPC) configuration for the specified access point.</p>
        /// <note>
        /// <p>This element is empty if this access point is an Amazon S3 on Outposts access point that is used by other Amazon Web Services.</p>
        /// </note>
        pub fn vpc_configuration(mut self, input: crate::model::VpcConfiguration) -> Self {
            self.vpc_configuration = Some(input);
            self
        }
        /// <p>Contains the virtual private cloud (VPC) configuration for the specified access point.</p>
        /// <note>
        /// <p>This element is empty if this access point is an Amazon S3 on Outposts access point that is used by other Amazon Web Services.</p>
        /// </note>
        pub fn set_vpc_configuration(
            mut self,
            input: std::option::Option<crate::model::VpcConfiguration>,
        ) -> Self {
            self.vpc_configuration = input;
            self
        }
        /// <p>The <code>PublicAccessBlock</code> configuration that you want to apply to this Amazon S3 account.
        /// You can enable the configuration options in any combination. For more information about
        /// when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>This is not supported for Amazon S3 on Outposts.</p>
        pub fn public_access_block_configuration(
            mut self,
            input: crate::model::PublicAccessBlockConfiguration,
        ) -> Self {
            self.public_access_block_configuration = Some(input);
            self
        }
        /// <p>The <code>PublicAccessBlock</code> configuration that you want to apply to this Amazon S3 account.
        /// You can enable the configuration options in any combination. For more information about
        /// when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>This is not supported for Amazon S3 on Outposts.</p>
        pub fn set_public_access_block_configuration(
            mut self,
            input: std::option::Option<crate::model::PublicAccessBlockConfiguration>,
        ) -> Self {
            self.public_access_block_configuration = input;
            self
        }
        /// <p>The date and time when the specified access point was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time when the specified access point was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The name or alias of the access point.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The name or alias of the access point.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// <p>The ARN of the access point.</p>
        pub fn access_point_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_point_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the access point.</p>
        pub fn set_access_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_point_arn = input;
            self
        }
        /// Adds a key-value pair to `endpoints`.
        ///
        /// To override the contents of this collection use [`set_endpoints`](Self::set_endpoints).
        ///
        /// <p>The VPC endpoint for the access point.</p>
        pub fn endpoints(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.endpoints.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.endpoints = Some(hash_map);
            self
        }
        /// <p>The VPC endpoint for the access point.</p>
        pub fn set_endpoints(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.endpoints = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccessPointOutput`](crate::output::GetAccessPointOutput)
        pub fn build(self) -> crate::output::GetAccessPointOutput {
            crate::output::GetAccessPointOutput {
                name: self.name,
                bucket: self.bucket,
                network_origin: self.network_origin,
                vpc_configuration: self.vpc_configuration,
                public_access_block_configuration: self.public_access_block_configuration,
                creation_date: self.creation_date,
                alias: self.alias,
                access_point_arn: self.access_point_arn,
                endpoints: self.endpoints,
            }
        }
    }
}
impl GetAccessPointOutput {
    /// Creates a new builder-style object to manufacture [`GetAccessPointOutput`](crate::output::GetAccessPointOutput)
    pub fn builder() -> crate::output::get_access_point_output::Builder {
        crate::output::get_access_point_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMultiRegionAccessPointOperationOutput {
    /// <p>A container element containing the details of the asynchronous operation.</p>
    pub async_operation: std::option::Option<crate::model::AsyncOperation>,
}
impl DescribeMultiRegionAccessPointOperationOutput {
    /// <p>A container element containing the details of the asynchronous operation.</p>
    pub fn async_operation(&self) -> std::option::Option<&crate::model::AsyncOperation> {
        self.async_operation.as_ref()
    }
}
impl std::fmt::Debug for DescribeMultiRegionAccessPointOperationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMultiRegionAccessPointOperationOutput");
        formatter.field("async_operation", &self.async_operation);
        formatter.finish()
    }
}
/// See [`DescribeMultiRegionAccessPointOperationOutput`](crate::output::DescribeMultiRegionAccessPointOperationOutput)
pub mod describe_multi_region_access_point_operation_output {
    /// A builder for [`DescribeMultiRegionAccessPointOperationOutput`](crate::output::DescribeMultiRegionAccessPointOperationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) async_operation: std::option::Option<crate::model::AsyncOperation>,
    }
    impl Builder {
        /// <p>A container element containing the details of the asynchronous operation.</p>
        pub fn async_operation(mut self, input: crate::model::AsyncOperation) -> Self {
            self.async_operation = Some(input);
            self
        }
        /// <p>A container element containing the details of the asynchronous operation.</p>
        pub fn set_async_operation(
            mut self,
            input: std::option::Option<crate::model::AsyncOperation>,
        ) -> Self {
            self.async_operation = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMultiRegionAccessPointOperationOutput`](crate::output::DescribeMultiRegionAccessPointOperationOutput)
        pub fn build(self) -> crate::output::DescribeMultiRegionAccessPointOperationOutput {
            crate::output::DescribeMultiRegionAccessPointOperationOutput {
                async_operation: self.async_operation,
            }
        }
    }
}
impl DescribeMultiRegionAccessPointOperationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeMultiRegionAccessPointOperationOutput`](crate::output::DescribeMultiRegionAccessPointOperationOutput)
    pub fn builder() -> crate::output::describe_multi_region_access_point_operation_output::Builder
    {
        crate::output::describe_multi_region_access_point_operation_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeJobOutput {
    /// <p>Contains the configuration parameters and status for the job specified in the <code>Describe Job</code> request.</p>
    pub job: std::option::Option<crate::model::JobDescriptor>,
}
impl DescribeJobOutput {
    /// <p>Contains the configuration parameters and status for the job specified in the <code>Describe Job</code> request.</p>
    pub fn job(&self) -> std::option::Option<&crate::model::JobDescriptor> {
        self.job.as_ref()
    }
}
impl std::fmt::Debug for DescribeJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeJobOutput");
        formatter.field("job", &self.job);
        formatter.finish()
    }
}
/// See [`DescribeJobOutput`](crate::output::DescribeJobOutput)
pub mod describe_job_output {
    /// A builder for [`DescribeJobOutput`](crate::output::DescribeJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job: std::option::Option<crate::model::JobDescriptor>,
    }
    impl Builder {
        /// <p>Contains the configuration parameters and status for the job specified in the <code>Describe Job</code> request.</p>
        pub fn job(mut self, input: crate::model::JobDescriptor) -> Self {
            self.job = Some(input);
            self
        }
        /// <p>Contains the configuration parameters and status for the job specified in the <code>Describe Job</code> request.</p>
        pub fn set_job(mut self, input: std::option::Option<crate::model::JobDescriptor>) -> Self {
            self.job = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeJobOutput`](crate::output::DescribeJobOutput)
        pub fn build(self) -> crate::output::DescribeJobOutput {
            crate::output::DescribeJobOutput { job: self.job }
        }
    }
}
impl DescribeJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeJobOutput`](crate::output::DescribeJobOutput)
    pub fn builder() -> crate::output::describe_job_output::Builder {
        crate::output::describe_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStorageLensConfigurationTaggingOutput {}
impl std::fmt::Debug for DeleteStorageLensConfigurationTaggingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStorageLensConfigurationTaggingOutput");
        formatter.finish()
    }
}
/// See [`DeleteStorageLensConfigurationTaggingOutput`](crate::output::DeleteStorageLensConfigurationTaggingOutput)
pub mod delete_storage_lens_configuration_tagging_output {
    /// A builder for [`DeleteStorageLensConfigurationTaggingOutput`](crate::output::DeleteStorageLensConfigurationTaggingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteStorageLensConfigurationTaggingOutput`](crate::output::DeleteStorageLensConfigurationTaggingOutput)
        pub fn build(self) -> crate::output::DeleteStorageLensConfigurationTaggingOutput {
            crate::output::DeleteStorageLensConfigurationTaggingOutput {}
        }
    }
}
impl DeleteStorageLensConfigurationTaggingOutput {
    /// Creates a new builder-style object to manufacture [`DeleteStorageLensConfigurationTaggingOutput`](crate::output::DeleteStorageLensConfigurationTaggingOutput)
    pub fn builder() -> crate::output::delete_storage_lens_configuration_tagging_output::Builder {
        crate::output::delete_storage_lens_configuration_tagging_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStorageLensConfigurationOutput {}
impl std::fmt::Debug for DeleteStorageLensConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStorageLensConfigurationOutput");
        formatter.finish()
    }
}
/// See [`DeleteStorageLensConfigurationOutput`](crate::output::DeleteStorageLensConfigurationOutput)
pub mod delete_storage_lens_configuration_output {
    /// A builder for [`DeleteStorageLensConfigurationOutput`](crate::output::DeleteStorageLensConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteStorageLensConfigurationOutput`](crate::output::DeleteStorageLensConfigurationOutput)
        pub fn build(self) -> crate::output::DeleteStorageLensConfigurationOutput {
            crate::output::DeleteStorageLensConfigurationOutput {}
        }
    }
}
impl DeleteStorageLensConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteStorageLensConfigurationOutput`](crate::output::DeleteStorageLensConfigurationOutput)
    pub fn builder() -> crate::output::delete_storage_lens_configuration_output::Builder {
        crate::output::delete_storage_lens_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePublicAccessBlockOutput {}
impl std::fmt::Debug for DeletePublicAccessBlockOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePublicAccessBlockOutput");
        formatter.finish()
    }
}
/// See [`DeletePublicAccessBlockOutput`](crate::output::DeletePublicAccessBlockOutput)
pub mod delete_public_access_block_output {
    /// A builder for [`DeletePublicAccessBlockOutput`](crate::output::DeletePublicAccessBlockOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeletePublicAccessBlockOutput`](crate::output::DeletePublicAccessBlockOutput)
        pub fn build(self) -> crate::output::DeletePublicAccessBlockOutput {
            crate::output::DeletePublicAccessBlockOutput {}
        }
    }
}
impl DeletePublicAccessBlockOutput {
    /// Creates a new builder-style object to manufacture [`DeletePublicAccessBlockOutput`](crate::output::DeletePublicAccessBlockOutput)
    pub fn builder() -> crate::output::delete_public_access_block_output::Builder {
        crate::output::delete_public_access_block_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMultiRegionAccessPointOutput {
    /// <p>The request token associated with the request. You can use this token with <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> to determine the status of
    /// asynchronous requests.</p>
    pub request_token_arn: std::option::Option<std::string::String>,
}
impl DeleteMultiRegionAccessPointOutput {
    /// <p>The request token associated with the request. You can use this token with <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> to determine the status of
    /// asynchronous requests.</p>
    pub fn request_token_arn(&self) -> std::option::Option<&str> {
        self.request_token_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteMultiRegionAccessPointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMultiRegionAccessPointOutput");
        formatter.field("request_token_arn", &self.request_token_arn);
        formatter.finish()
    }
}
/// See [`DeleteMultiRegionAccessPointOutput`](crate::output::DeleteMultiRegionAccessPointOutput)
pub mod delete_multi_region_access_point_output {
    /// A builder for [`DeleteMultiRegionAccessPointOutput`](crate::output::DeleteMultiRegionAccessPointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_token_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request token associated with the request. You can use this token with <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> to determine the status of
        /// asynchronous requests.</p>
        pub fn request_token_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_token_arn = Some(input.into());
            self
        }
        /// <p>The request token associated with the request. You can use this token with <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> to determine the status of
        /// asynchronous requests.</p>
        pub fn set_request_token_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.request_token_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMultiRegionAccessPointOutput`](crate::output::DeleteMultiRegionAccessPointOutput)
        pub fn build(self) -> crate::output::DeleteMultiRegionAccessPointOutput {
            crate::output::DeleteMultiRegionAccessPointOutput {
                request_token_arn: self.request_token_arn,
            }
        }
    }
}
impl DeleteMultiRegionAccessPointOutput {
    /// Creates a new builder-style object to manufacture [`DeleteMultiRegionAccessPointOutput`](crate::output::DeleteMultiRegionAccessPointOutput)
    pub fn builder() -> crate::output::delete_multi_region_access_point_output::Builder {
        crate::output::delete_multi_region_access_point_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteJobTaggingOutput {}
impl std::fmt::Debug for DeleteJobTaggingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteJobTaggingOutput");
        formatter.finish()
    }
}
/// See [`DeleteJobTaggingOutput`](crate::output::DeleteJobTaggingOutput)
pub mod delete_job_tagging_output {
    /// A builder for [`DeleteJobTaggingOutput`](crate::output::DeleteJobTaggingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteJobTaggingOutput`](crate::output::DeleteJobTaggingOutput)
        pub fn build(self) -> crate::output::DeleteJobTaggingOutput {
            crate::output::DeleteJobTaggingOutput {}
        }
    }
}
impl DeleteJobTaggingOutput {
    /// Creates a new builder-style object to manufacture [`DeleteJobTaggingOutput`](crate::output::DeleteJobTaggingOutput)
    pub fn builder() -> crate::output::delete_job_tagging_output::Builder {
        crate::output::delete_job_tagging_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBucketTaggingOutput {}
impl std::fmt::Debug for DeleteBucketTaggingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBucketTaggingOutput");
        formatter.finish()
    }
}
/// See [`DeleteBucketTaggingOutput`](crate::output::DeleteBucketTaggingOutput)
pub mod delete_bucket_tagging_output {
    /// A builder for [`DeleteBucketTaggingOutput`](crate::output::DeleteBucketTaggingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBucketTaggingOutput`](crate::output::DeleteBucketTaggingOutput)
        pub fn build(self) -> crate::output::DeleteBucketTaggingOutput {
            crate::output::DeleteBucketTaggingOutput {}
        }
    }
}
impl DeleteBucketTaggingOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBucketTaggingOutput`](crate::output::DeleteBucketTaggingOutput)
    pub fn builder() -> crate::output::delete_bucket_tagging_output::Builder {
        crate::output::delete_bucket_tagging_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBucketPolicyOutput {}
impl std::fmt::Debug for DeleteBucketPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBucketPolicyOutput");
        formatter.finish()
    }
}
/// See [`DeleteBucketPolicyOutput`](crate::output::DeleteBucketPolicyOutput)
pub mod delete_bucket_policy_output {
    /// A builder for [`DeleteBucketPolicyOutput`](crate::output::DeleteBucketPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBucketPolicyOutput`](crate::output::DeleteBucketPolicyOutput)
        pub fn build(self) -> crate::output::DeleteBucketPolicyOutput {
            crate::output::DeleteBucketPolicyOutput {}
        }
    }
}
impl DeleteBucketPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBucketPolicyOutput`](crate::output::DeleteBucketPolicyOutput)
    pub fn builder() -> crate::output::delete_bucket_policy_output::Builder {
        crate::output::delete_bucket_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBucketLifecycleConfigurationOutput {}
impl std::fmt::Debug for DeleteBucketLifecycleConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBucketLifecycleConfigurationOutput");
        formatter.finish()
    }
}
/// See [`DeleteBucketLifecycleConfigurationOutput`](crate::output::DeleteBucketLifecycleConfigurationOutput)
pub mod delete_bucket_lifecycle_configuration_output {
    /// A builder for [`DeleteBucketLifecycleConfigurationOutput`](crate::output::DeleteBucketLifecycleConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBucketLifecycleConfigurationOutput`](crate::output::DeleteBucketLifecycleConfigurationOutput)
        pub fn build(self) -> crate::output::DeleteBucketLifecycleConfigurationOutput {
            crate::output::DeleteBucketLifecycleConfigurationOutput {}
        }
    }
}
impl DeleteBucketLifecycleConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBucketLifecycleConfigurationOutput`](crate::output::DeleteBucketLifecycleConfigurationOutput)
    pub fn builder() -> crate::output::delete_bucket_lifecycle_configuration_output::Builder {
        crate::output::delete_bucket_lifecycle_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBucketOutput {}
impl std::fmt::Debug for DeleteBucketOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBucketOutput");
        formatter.finish()
    }
}
/// See [`DeleteBucketOutput`](crate::output::DeleteBucketOutput)
pub mod delete_bucket_output {
    /// A builder for [`DeleteBucketOutput`](crate::output::DeleteBucketOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBucketOutput`](crate::output::DeleteBucketOutput)
        pub fn build(self) -> crate::output::DeleteBucketOutput {
            crate::output::DeleteBucketOutput {}
        }
    }
}
impl DeleteBucketOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBucketOutput`](crate::output::DeleteBucketOutput)
    pub fn builder() -> crate::output::delete_bucket_output::Builder {
        crate::output::delete_bucket_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAccessPointPolicyForObjectLambdaOutput {}
impl std::fmt::Debug for DeleteAccessPointPolicyForObjectLambdaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAccessPointPolicyForObjectLambdaOutput");
        formatter.finish()
    }
}
/// See [`DeleteAccessPointPolicyForObjectLambdaOutput`](crate::output::DeleteAccessPointPolicyForObjectLambdaOutput)
pub mod delete_access_point_policy_for_object_lambda_output {
    /// A builder for [`DeleteAccessPointPolicyForObjectLambdaOutput`](crate::output::DeleteAccessPointPolicyForObjectLambdaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAccessPointPolicyForObjectLambdaOutput`](crate::output::DeleteAccessPointPolicyForObjectLambdaOutput)
        pub fn build(self) -> crate::output::DeleteAccessPointPolicyForObjectLambdaOutput {
            crate::output::DeleteAccessPointPolicyForObjectLambdaOutput {}
        }
    }
}
impl DeleteAccessPointPolicyForObjectLambdaOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAccessPointPolicyForObjectLambdaOutput`](crate::output::DeleteAccessPointPolicyForObjectLambdaOutput)
    pub fn builder() -> crate::output::delete_access_point_policy_for_object_lambda_output::Builder
    {
        crate::output::delete_access_point_policy_for_object_lambda_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAccessPointPolicyOutput {}
impl std::fmt::Debug for DeleteAccessPointPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAccessPointPolicyOutput");
        formatter.finish()
    }
}
/// See [`DeleteAccessPointPolicyOutput`](crate::output::DeleteAccessPointPolicyOutput)
pub mod delete_access_point_policy_output {
    /// A builder for [`DeleteAccessPointPolicyOutput`](crate::output::DeleteAccessPointPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAccessPointPolicyOutput`](crate::output::DeleteAccessPointPolicyOutput)
        pub fn build(self) -> crate::output::DeleteAccessPointPolicyOutput {
            crate::output::DeleteAccessPointPolicyOutput {}
        }
    }
}
impl DeleteAccessPointPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAccessPointPolicyOutput`](crate::output::DeleteAccessPointPolicyOutput)
    pub fn builder() -> crate::output::delete_access_point_policy_output::Builder {
        crate::output::delete_access_point_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAccessPointForObjectLambdaOutput {}
impl std::fmt::Debug for DeleteAccessPointForObjectLambdaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAccessPointForObjectLambdaOutput");
        formatter.finish()
    }
}
/// See [`DeleteAccessPointForObjectLambdaOutput`](crate::output::DeleteAccessPointForObjectLambdaOutput)
pub mod delete_access_point_for_object_lambda_output {
    /// A builder for [`DeleteAccessPointForObjectLambdaOutput`](crate::output::DeleteAccessPointForObjectLambdaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAccessPointForObjectLambdaOutput`](crate::output::DeleteAccessPointForObjectLambdaOutput)
        pub fn build(self) -> crate::output::DeleteAccessPointForObjectLambdaOutput {
            crate::output::DeleteAccessPointForObjectLambdaOutput {}
        }
    }
}
impl DeleteAccessPointForObjectLambdaOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAccessPointForObjectLambdaOutput`](crate::output::DeleteAccessPointForObjectLambdaOutput)
    pub fn builder() -> crate::output::delete_access_point_for_object_lambda_output::Builder {
        crate::output::delete_access_point_for_object_lambda_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAccessPointOutput {}
impl std::fmt::Debug for DeleteAccessPointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAccessPointOutput");
        formatter.finish()
    }
}
/// See [`DeleteAccessPointOutput`](crate::output::DeleteAccessPointOutput)
pub mod delete_access_point_output {
    /// A builder for [`DeleteAccessPointOutput`](crate::output::DeleteAccessPointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAccessPointOutput`](crate::output::DeleteAccessPointOutput)
        pub fn build(self) -> crate::output::DeleteAccessPointOutput {
            crate::output::DeleteAccessPointOutput {}
        }
    }
}
impl DeleteAccessPointOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAccessPointOutput`](crate::output::DeleteAccessPointOutput)
    pub fn builder() -> crate::output::delete_access_point_output::Builder {
        crate::output::delete_access_point_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMultiRegionAccessPointOutput {
    /// <p>The request token associated with the request. You can use this token with <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> to determine the status of
    /// asynchronous requests.</p>
    pub request_token_arn: std::option::Option<std::string::String>,
}
impl CreateMultiRegionAccessPointOutput {
    /// <p>The request token associated with the request. You can use this token with <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> to determine the status of
    /// asynchronous requests.</p>
    pub fn request_token_arn(&self) -> std::option::Option<&str> {
        self.request_token_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateMultiRegionAccessPointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMultiRegionAccessPointOutput");
        formatter.field("request_token_arn", &self.request_token_arn);
        formatter.finish()
    }
}
/// See [`CreateMultiRegionAccessPointOutput`](crate::output::CreateMultiRegionAccessPointOutput)
pub mod create_multi_region_access_point_output {
    /// A builder for [`CreateMultiRegionAccessPointOutput`](crate::output::CreateMultiRegionAccessPointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_token_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request token associated with the request. You can use this token with <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> to determine the status of
        /// asynchronous requests.</p>
        pub fn request_token_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_token_arn = Some(input.into());
            self
        }
        /// <p>The request token associated with the request. You can use this token with <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a> to determine the status of
        /// asynchronous requests.</p>
        pub fn set_request_token_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.request_token_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMultiRegionAccessPointOutput`](crate::output::CreateMultiRegionAccessPointOutput)
        pub fn build(self) -> crate::output::CreateMultiRegionAccessPointOutput {
            crate::output::CreateMultiRegionAccessPointOutput {
                request_token_arn: self.request_token_arn,
            }
        }
    }
}
impl CreateMultiRegionAccessPointOutput {
    /// Creates a new builder-style object to manufacture [`CreateMultiRegionAccessPointOutput`](crate::output::CreateMultiRegionAccessPointOutput)
    pub fn builder() -> crate::output::create_multi_region_access_point_output::Builder {
        crate::output::create_multi_region_access_point_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateJobOutput {
    /// <p>The ID for this job. Amazon S3 generates this ID automatically and returns it after a
    /// successful <code>Create Job</code> request.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl CreateJobOutput {
    /// <p>The ID for this job. Amazon S3 generates this ID automatically and returns it after a
    /// successful <code>Create Job</code> request.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for CreateJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateJobOutput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}
/// See [`CreateJobOutput`](crate::output::CreateJobOutput)
pub mod create_job_output {
    /// A builder for [`CreateJobOutput`](crate::output::CreateJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for this job. Amazon S3 generates this ID automatically and returns it after a
        /// successful <code>Create Job</code> request.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID for this job. Amazon S3 generates this ID automatically and returns it after a
        /// successful <code>Create Job</code> request.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateJobOutput`](crate::output::CreateJobOutput)
        pub fn build(self) -> crate::output::CreateJobOutput {
            crate::output::CreateJobOutput {
                job_id: self.job_id,
            }
        }
    }
}
impl CreateJobOutput {
    /// Creates a new builder-style object to manufacture [`CreateJobOutput`](crate::output::CreateJobOutput)
    pub fn builder() -> crate::output::create_job_output::Builder {
        crate::output::create_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBucketOutput {
    /// <p>The location of the bucket.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded.  </p>
    pub bucket_arn: std::option::Option<std::string::String>,
}
impl CreateBucketOutput {
    /// <p>The location of the bucket.</p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
    /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
    /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded.  </p>
    pub fn bucket_arn(&self) -> std::option::Option<&str> {
        self.bucket_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateBucketOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBucketOutput");
        formatter.field("location", &self.location);
        formatter.field("bucket_arn", &self.bucket_arn);
        formatter.finish()
    }
}
/// See [`CreateBucketOutput`](crate::output::CreateBucketOutput)
pub mod create_bucket_output {
    /// A builder for [`CreateBucketOutput`](crate::output::CreateBucketOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) bucket_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The location of the bucket.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The location of the bucket.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded.  </p>
        pub fn bucket_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded.  </p>
        pub fn set_bucket_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBucketOutput`](crate::output::CreateBucketOutput)
        pub fn build(self) -> crate::output::CreateBucketOutput {
            crate::output::CreateBucketOutput {
                location: self.location,
                bucket_arn: self.bucket_arn,
            }
        }
    }
}
impl CreateBucketOutput {
    /// Creates a new builder-style object to manufacture [`CreateBucketOutput`](crate::output::CreateBucketOutput)
    pub fn builder() -> crate::output::create_bucket_output::Builder {
        crate::output::create_bucket_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAccessPointForObjectLambdaOutput {
    /// <p>Specifies the ARN for the Object Lambda Access Point.</p>
    pub object_lambda_access_point_arn: std::option::Option<std::string::String>,
}
impl CreateAccessPointForObjectLambdaOutput {
    /// <p>Specifies the ARN for the Object Lambda Access Point.</p>
    pub fn object_lambda_access_point_arn(&self) -> std::option::Option<&str> {
        self.object_lambda_access_point_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateAccessPointForObjectLambdaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAccessPointForObjectLambdaOutput");
        formatter.field(
            "object_lambda_access_point_arn",
            &self.object_lambda_access_point_arn,
        );
        formatter.finish()
    }
}
/// See [`CreateAccessPointForObjectLambdaOutput`](crate::output::CreateAccessPointForObjectLambdaOutput)
pub mod create_access_point_for_object_lambda_output {
    /// A builder for [`CreateAccessPointForObjectLambdaOutput`](crate::output::CreateAccessPointForObjectLambdaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_lambda_access_point_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the ARN for the Object Lambda Access Point.</p>
        pub fn object_lambda_access_point_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.object_lambda_access_point_arn = Some(input.into());
            self
        }
        /// <p>Specifies the ARN for the Object Lambda Access Point.</p>
        pub fn set_object_lambda_access_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_lambda_access_point_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAccessPointForObjectLambdaOutput`](crate::output::CreateAccessPointForObjectLambdaOutput)
        pub fn build(self) -> crate::output::CreateAccessPointForObjectLambdaOutput {
            crate::output::CreateAccessPointForObjectLambdaOutput {
                object_lambda_access_point_arn: self.object_lambda_access_point_arn,
            }
        }
    }
}
impl CreateAccessPointForObjectLambdaOutput {
    /// Creates a new builder-style object to manufacture [`CreateAccessPointForObjectLambdaOutput`](crate::output::CreateAccessPointForObjectLambdaOutput)
    pub fn builder() -> crate::output::create_access_point_for_object_lambda_output::Builder {
        crate::output::create_access_point_for_object_lambda_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAccessPointOutput {
    /// <p>The ARN of the access point.</p>
    /// <note>
    /// <p>This is only supported by Amazon S3 on Outposts.</p>
    /// </note>
    pub access_point_arn: std::option::Option<std::string::String>,
    /// <p>The name or alias of the access point.</p>
    pub alias: std::option::Option<std::string::String>,
}
impl CreateAccessPointOutput {
    /// <p>The ARN of the access point.</p>
    /// <note>
    /// <p>This is only supported by Amazon S3 on Outposts.</p>
    /// </note>
    pub fn access_point_arn(&self) -> std::option::Option<&str> {
        self.access_point_arn.as_deref()
    }
    /// <p>The name or alias of the access point.</p>
    pub fn alias(&self) -> std::option::Option<&str> {
        self.alias.as_deref()
    }
}
impl std::fmt::Debug for CreateAccessPointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAccessPointOutput");
        formatter.field("access_point_arn", &self.access_point_arn);
        formatter.field("alias", &self.alias);
        formatter.finish()
    }
}
/// See [`CreateAccessPointOutput`](crate::output::CreateAccessPointOutput)
pub mod create_access_point_output {
    /// A builder for [`CreateAccessPointOutput`](crate::output::CreateAccessPointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_point_arn: std::option::Option<std::string::String>,
        pub(crate) alias: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the access point.</p>
        /// <note>
        /// <p>This is only supported by Amazon S3 on Outposts.</p>
        /// </note>
        pub fn access_point_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_point_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the access point.</p>
        /// <note>
        /// <p>This is only supported by Amazon S3 on Outposts.</p>
        /// </note>
        pub fn set_access_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_point_arn = input;
            self
        }
        /// <p>The name or alias of the access point.</p>
        pub fn alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias = Some(input.into());
            self
        }
        /// <p>The name or alias of the access point.</p>
        pub fn set_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAccessPointOutput`](crate::output::CreateAccessPointOutput)
        pub fn build(self) -> crate::output::CreateAccessPointOutput {
            crate::output::CreateAccessPointOutput {
                access_point_arn: self.access_point_arn,
                alias: self.alias,
            }
        }
    }
}
impl CreateAccessPointOutput {
    /// Creates a new builder-style object to manufacture [`CreateAccessPointOutput`](crate::output::CreateAccessPointOutput)
    pub fn builder() -> crate::output::create_access_point_output::Builder {
        crate::output::create_access_point_output::Builder::default()
    }
}
