// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_access_point_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAccessPointOutput, crate::error::CreateAccessPointError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateAccessPointError::unhandled)?;
    Err(crate::error::CreateAccessPointError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_access_point_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAccessPointOutput, crate::error::CreateAccessPointError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_access_point_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_access_point(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateAccessPointError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_access_point_for_object_lambda_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateAccessPointForObjectLambdaOutput,
    crate::error::CreateAccessPointForObjectLambdaError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateAccessPointForObjectLambdaError::unhandled)?;
    Err(crate::error::CreateAccessPointForObjectLambdaError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_access_point_for_object_lambda_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateAccessPointForObjectLambdaOutput,
    crate::error::CreateAccessPointForObjectLambdaError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::create_access_point_for_object_lambda_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_access_point_for_object_lambda(response.body().as_ref(), output).map_err(crate::error::CreateAccessPointForObjectLambdaError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_bucket_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateBucketOutput, crate::error::CreateBucketError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateBucketError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateBucketError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BucketAlreadyExists" => crate::error::CreateBucketError {
            meta: generic,
            kind: crate::error::CreateBucketErrorKind::BucketAlreadyExists({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bucket_already_exists::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_bucket_already_exists_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateBucketError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BucketAlreadyOwnedByYou" => crate::error::CreateBucketError {
            meta: generic,
            kind: crate::error::CreateBucketErrorKind::BucketAlreadyOwnedByYou({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bucket_already_owned_by_you::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_bucket_already_owned_by_you_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateBucketError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateBucketError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_bucket_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateBucketOutput, crate::error::CreateBucketError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_bucket_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_bucket(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateBucketError::unhandled)?;
        output = output.set_location(
            crate::http_serde::deser_header_create_bucket_create_bucket_output_location(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::CreateBucketError::unhandled(
                    "Failed to parse Location from header `Location",
                )
            })?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateJobOutput, crate::error::CreateJobError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::CreateJobError {
            meta: generic,
            kind: crate::error::CreateJobErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_bad_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IdempotencyException" => crate::error::CreateJobError {
            meta: generic,
            kind: crate::error::CreateJobErrorKind::IdempotencyException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::idempotency_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_idempotency_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceException" => crate::error::CreateJobError {
            meta: generic,
            kind: crate::error::CreateJobErrorKind::InternalServiceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_service_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyRequestsException" => crate::error::CreateJobError {
            meta: generic,
            kind: crate::error::CreateJobErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_requests_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateJobOutput, crate::error::CreateJobError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_job_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_multi_region_access_point_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateMultiRegionAccessPointOutput,
    crate::error::CreateMultiRegionAccessPointError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateMultiRegionAccessPointError::unhandled)?;
    Err(crate::error::CreateMultiRegionAccessPointError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_multi_region_access_point_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateMultiRegionAccessPointOutput,
    crate::error::CreateMultiRegionAccessPointError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_multi_region_access_point_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_create_multi_region_access_point(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::CreateMultiRegionAccessPointError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_access_point_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAccessPointOutput, crate::error::DeleteAccessPointError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAccessPointError::unhandled)?;
    Err(crate::error::DeleteAccessPointError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_access_point_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAccessPointOutput, crate::error::DeleteAccessPointError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_access_point_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_access_point_for_object_lambda_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAccessPointForObjectLambdaOutput,
    crate::error::DeleteAccessPointForObjectLambdaError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAccessPointForObjectLambdaError::unhandled)?;
    Err(crate::error::DeleteAccessPointForObjectLambdaError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_access_point_for_object_lambda_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAccessPointForObjectLambdaOutput,
    crate::error::DeleteAccessPointForObjectLambdaError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_access_point_for_object_lambda_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_access_point_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAccessPointPolicyOutput,
    crate::error::DeleteAccessPointPolicyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAccessPointPolicyError::unhandled)?;
    Err(crate::error::DeleteAccessPointPolicyError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_access_point_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAccessPointPolicyOutput,
    crate::error::DeleteAccessPointPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_access_point_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_access_point_policy_for_object_lambda_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAccessPointPolicyForObjectLambdaOutput,
    crate::error::DeleteAccessPointPolicyForObjectLambdaError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAccessPointPolicyForObjectLambdaError::unhandled)?;
    Err(crate::error::DeleteAccessPointPolicyForObjectLambdaError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_access_point_policy_for_object_lambda_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAccessPointPolicyForObjectLambdaOutput,
    crate::error::DeleteAccessPointPolicyForObjectLambdaError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_access_point_policy_for_object_lambda_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteBucketOutput, crate::error::DeleteBucketError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteBucketError::unhandled)?;
    Err(crate::error::DeleteBucketError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteBucketOutput, crate::error::DeleteBucketError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_bucket_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_lifecycle_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketLifecycleConfigurationOutput,
    crate::error::DeleteBucketLifecycleConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteBucketLifecycleConfigurationError::unhandled)?;
    Err(crate::error::DeleteBucketLifecycleConfigurationError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_lifecycle_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketLifecycleConfigurationOutput,
    crate::error::DeleteBucketLifecycleConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_bucket_lifecycle_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketPolicyOutput,
    crate::error::DeleteBucketPolicyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteBucketPolicyError::unhandled)?;
    Err(crate::error::DeleteBucketPolicyError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketPolicyOutput,
    crate::error::DeleteBucketPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_bucket_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_tagging_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketTaggingOutput,
    crate::error::DeleteBucketTaggingError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteBucketTaggingError::unhandled)?;
    Err(crate::error::DeleteBucketTaggingError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_tagging_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketTaggingOutput,
    crate::error::DeleteBucketTaggingError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_bucket_tagging_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_job_tagging_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteJobTaggingOutput, crate::error::DeleteJobTaggingError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteJobTaggingError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteJobTaggingError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceException" => crate::error::DeleteJobTaggingError {
            meta: generic,
            kind: crate::error::DeleteJobTaggingErrorKind::InternalServiceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_service_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteJobTaggingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => {
            crate::error::DeleteJobTaggingError {
                meta: generic,
                kind: crate::error::DeleteJobTaggingErrorKind::NotFoundException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteJobTaggingError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::DeleteJobTaggingError {
            meta: generic,
            kind: crate::error::DeleteJobTaggingErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_requests_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteJobTaggingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteJobTaggingError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_job_tagging_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteJobTaggingOutput, crate::error::DeleteJobTaggingError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_job_tagging_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_multi_region_access_point_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteMultiRegionAccessPointOutput,
    crate::error::DeleteMultiRegionAccessPointError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteMultiRegionAccessPointError::unhandled)?;
    Err(crate::error::DeleteMultiRegionAccessPointError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_multi_region_access_point_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteMultiRegionAccessPointOutput,
    crate::error::DeleteMultiRegionAccessPointError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_multi_region_access_point_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_delete_multi_region_access_point(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DeleteMultiRegionAccessPointError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_public_access_block_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeletePublicAccessBlockOutput,
    crate::error::DeletePublicAccessBlockError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeletePublicAccessBlockError::unhandled)?;
    Err(crate::error::DeletePublicAccessBlockError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_public_access_block_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeletePublicAccessBlockOutput,
    crate::error::DeletePublicAccessBlockError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_public_access_block_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_storage_lens_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteStorageLensConfigurationOutput,
    crate::error::DeleteStorageLensConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteStorageLensConfigurationError::unhandled)?;
    Err(crate::error::DeleteStorageLensConfigurationError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_storage_lens_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteStorageLensConfigurationOutput,
    crate::error::DeleteStorageLensConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_storage_lens_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_storage_lens_configuration_tagging_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteStorageLensConfigurationTaggingOutput,
    crate::error::DeleteStorageLensConfigurationTaggingError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteStorageLensConfigurationTaggingError::unhandled)?;
    Err(crate::error::DeleteStorageLensConfigurationTaggingError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_storage_lens_configuration_tagging_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteStorageLensConfigurationTaggingOutput,
    crate::error::DeleteStorageLensConfigurationTaggingError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_storage_lens_configuration_tagging_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_job_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeJobOutput, crate::error::DescribeJobError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeJobError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeJobError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::DescribeJobError {
            meta: generic,
            kind: crate::error::DescribeJobErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_bad_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceException" => crate::error::DescribeJobError {
            meta: generic,
            kind: crate::error::DescribeJobErrorKind::InternalServiceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_service_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => {
            crate::error::DescribeJobError {
                meta: generic,
                kind: crate::error::DescribeJobErrorKind::NotFoundException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeJobError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::DescribeJobError {
            meta: generic,
            kind: crate::error::DescribeJobErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_requests_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeJobError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeJobError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_job_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeJobOutput, crate::error::DescribeJobError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_job_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_job(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeJobError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_multi_region_access_point_operation_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeMultiRegionAccessPointOperationOutput,
    crate::error::DescribeMultiRegionAccessPointOperationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeMultiRegionAccessPointOperationError::unhandled)?;
    Err(crate::error::DescribeMultiRegionAccessPointOperationError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_multi_region_access_point_operation_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeMultiRegionAccessPointOperationOutput,
    crate::error::DescribeMultiRegionAccessPointOperationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_multi_region_access_point_operation_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_multi_region_access_point_operation(response.body().as_ref(), output).map_err(crate::error::DescribeMultiRegionAccessPointOperationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_access_point_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetAccessPointOutput, crate::error::GetAccessPointError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAccessPointError::unhandled)?;
    Err(crate::error::GetAccessPointError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_access_point_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetAccessPointOutput, crate::error::GetAccessPointError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_access_point_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_access_point(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetAccessPointError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_access_point_configuration_for_object_lambda_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAccessPointConfigurationForObjectLambdaOutput,
    crate::error::GetAccessPointConfigurationForObjectLambdaError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAccessPointConfigurationForObjectLambdaError::unhandled)?;
    Err(crate::error::GetAccessPointConfigurationForObjectLambdaError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_access_point_configuration_for_object_lambda_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAccessPointConfigurationForObjectLambdaOutput,
    crate::error::GetAccessPointConfigurationForObjectLambdaError,
> {
    Ok({
        #[allow(unused_mut)]let mut output = crate::output::get_access_point_configuration_for_object_lambda_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_access_point_configuration_for_object_lambda(response.body().as_ref(), output).map_err(crate::error::GetAccessPointConfigurationForObjectLambdaError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_access_point_for_object_lambda_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAccessPointForObjectLambdaOutput,
    crate::error::GetAccessPointForObjectLambdaError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAccessPointForObjectLambdaError::unhandled)?;
    Err(crate::error::GetAccessPointForObjectLambdaError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_access_point_for_object_lambda_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAccessPointForObjectLambdaOutput,
    crate::error::GetAccessPointForObjectLambdaError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_access_point_for_object_lambda_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_get_access_point_for_object_lambda(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetAccessPointForObjectLambdaError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_access_point_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAccessPointPolicyOutput,
    crate::error::GetAccessPointPolicyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAccessPointPolicyError::unhandled)?;
    Err(crate::error::GetAccessPointPolicyError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_access_point_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAccessPointPolicyOutput,
    crate::error::GetAccessPointPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_access_point_policy_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_access_point_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetAccessPointPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_access_point_policy_for_object_lambda_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAccessPointPolicyForObjectLambdaOutput,
    crate::error::GetAccessPointPolicyForObjectLambdaError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAccessPointPolicyForObjectLambdaError::unhandled)?;
    Err(crate::error::GetAccessPointPolicyForObjectLambdaError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_access_point_policy_for_object_lambda_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAccessPointPolicyForObjectLambdaOutput,
    crate::error::GetAccessPointPolicyForObjectLambdaError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_access_point_policy_for_object_lambda_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_access_point_policy_for_object_lambda(response.body().as_ref(), output).map_err(crate::error::GetAccessPointPolicyForObjectLambdaError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_access_point_policy_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAccessPointPolicyStatusOutput,
    crate::error::GetAccessPointPolicyStatusError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAccessPointPolicyStatusError::unhandled)?;
    Err(crate::error::GetAccessPointPolicyStatusError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_access_point_policy_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAccessPointPolicyStatusOutput,
    crate::error::GetAccessPointPolicyStatusError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_access_point_policy_status_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_access_point_policy_status(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetAccessPointPolicyStatusError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_access_point_policy_status_for_object_lambda_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAccessPointPolicyStatusForObjectLambdaOutput,
    crate::error::GetAccessPointPolicyStatusForObjectLambdaError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAccessPointPolicyStatusForObjectLambdaError::unhandled)?;
    Err(crate::error::GetAccessPointPolicyStatusForObjectLambdaError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_access_point_policy_status_for_object_lambda_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAccessPointPolicyStatusForObjectLambdaOutput,
    crate::error::GetAccessPointPolicyStatusForObjectLambdaError,
> {
    Ok({
        #[allow(unused_mut)]let mut output = crate::output::get_access_point_policy_status_for_object_lambda_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_access_point_policy_status_for_object_lambda(response.body().as_ref(), output).map_err(crate::error::GetAccessPointPolicyStatusForObjectLambdaError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetBucketOutput, crate::error::GetBucketError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBucketError::unhandled)?;
    Err(crate::error::GetBucketError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetBucketOutput, crate::error::GetBucketError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_bucket_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_bucket(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetBucketError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_lifecycle_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketLifecycleConfigurationOutput,
    crate::error::GetBucketLifecycleConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBucketLifecycleConfigurationError::unhandled)?;
    Err(crate::error::GetBucketLifecycleConfigurationError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_lifecycle_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketLifecycleConfigurationOutput,
    crate::error::GetBucketLifecycleConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_bucket_lifecycle_configuration_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_get_bucket_lifecycle_configuration(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetBucketLifecycleConfigurationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetBucketPolicyOutput, crate::error::GetBucketPolicyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBucketPolicyError::unhandled)?;
    Err(crate::error::GetBucketPolicyError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetBucketPolicyOutput, crate::error::GetBucketPolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_bucket_policy_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_bucket_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetBucketPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_tagging_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetBucketTaggingOutput, crate::error::GetBucketTaggingError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBucketTaggingError::unhandled)?;
    Err(crate::error::GetBucketTaggingError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_tagging_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetBucketTaggingOutput, crate::error::GetBucketTaggingError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_bucket_tagging_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_bucket_tagging(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetBucketTaggingError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_job_tagging_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetJobTaggingOutput, crate::error::GetJobTaggingError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetJobTaggingError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetJobTaggingError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceException" => crate::error::GetJobTaggingError {
            meta: generic,
            kind: crate::error::GetJobTaggingErrorKind::InternalServiceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_service_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetJobTaggingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => {
            crate::error::GetJobTaggingError {
                meta: generic,
                kind: crate::error::GetJobTaggingErrorKind::NotFoundException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetJobTaggingError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::GetJobTaggingError {
            meta: generic,
            kind: crate::error::GetJobTaggingErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_requests_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetJobTaggingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetJobTaggingError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_job_tagging_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetJobTaggingOutput, crate::error::GetJobTaggingError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_job_tagging_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_job_tagging(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetJobTaggingError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_multi_region_access_point_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetMultiRegionAccessPointOutput,
    crate::error::GetMultiRegionAccessPointError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetMultiRegionAccessPointError::unhandled)?;
    Err(crate::error::GetMultiRegionAccessPointError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_multi_region_access_point_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetMultiRegionAccessPointOutput,
    crate::error::GetMultiRegionAccessPointError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_multi_region_access_point_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_multi_region_access_point(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetMultiRegionAccessPointError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_multi_region_access_point_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetMultiRegionAccessPointPolicyOutput,
    crate::error::GetMultiRegionAccessPointPolicyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetMultiRegionAccessPointPolicyError::unhandled)?;
    Err(crate::error::GetMultiRegionAccessPointPolicyError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_multi_region_access_point_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetMultiRegionAccessPointPolicyOutput,
    crate::error::GetMultiRegionAccessPointPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_multi_region_access_point_policy_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_get_multi_region_access_point_policy(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetMultiRegionAccessPointPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_multi_region_access_point_policy_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetMultiRegionAccessPointPolicyStatusOutput,
    crate::error::GetMultiRegionAccessPointPolicyStatusError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetMultiRegionAccessPointPolicyStatusError::unhandled)?;
    Err(crate::error::GetMultiRegionAccessPointPolicyStatusError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_multi_region_access_point_policy_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetMultiRegionAccessPointPolicyStatusOutput,
    crate::error::GetMultiRegionAccessPointPolicyStatusError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_multi_region_access_point_policy_status_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_multi_region_access_point_policy_status(response.body().as_ref(), output).map_err(crate::error::GetMultiRegionAccessPointPolicyStatusError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_public_access_block_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetPublicAccessBlockOutput,
    crate::error::GetPublicAccessBlockError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetPublicAccessBlockError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetPublicAccessBlockError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchPublicAccessBlockConfiguration" => crate::error::GetPublicAccessBlockError {
            meta: generic,
            kind: crate::error::GetPublicAccessBlockErrorKind::NoSuchPublicAccessBlockConfiguration(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::no_such_public_access_block_configuration::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_public_access_block_configuration_xml_err(response.body().as_ref(), output).map_err(crate::error::GetPublicAccessBlockError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::GetPublicAccessBlockError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_public_access_block_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetPublicAccessBlockOutput,
    crate::error::GetPublicAccessBlockError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_public_access_block_output::Builder::default();
        let _ = response;
        output = output.set_public_access_block_configuration(
            crate::http_serde::deser_payload_get_public_access_block_get_public_access_block_output_public_access_block_configuration(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_storage_lens_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetStorageLensConfigurationOutput,
    crate::error::GetStorageLensConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetStorageLensConfigurationError::unhandled)?;
    Err(crate::error::GetStorageLensConfigurationError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_storage_lens_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetStorageLensConfigurationOutput,
    crate::error::GetStorageLensConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_storage_lens_configuration_output::Builder::default();
        let _ = response;
        output = output.set_storage_lens_configuration(
            crate::http_serde::deser_payload_get_storage_lens_configuration_get_storage_lens_configuration_output_storage_lens_configuration(response.body().as_ref())?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_storage_lens_configuration_tagging_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetStorageLensConfigurationTaggingOutput,
    crate::error::GetStorageLensConfigurationTaggingError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetStorageLensConfigurationTaggingError::unhandled)?;
    Err(crate::error::GetStorageLensConfigurationTaggingError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_storage_lens_configuration_tagging_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetStorageLensConfigurationTaggingOutput,
    crate::error::GetStorageLensConfigurationTaggingError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_storage_lens_configuration_tagging_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_storage_lens_configuration_tagging(response.body().as_ref(), output).map_err(crate::error::GetStorageLensConfigurationTaggingError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_access_points_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListAccessPointsOutput, crate::error::ListAccessPointsError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAccessPointsError::unhandled)?;
    Err(crate::error::ListAccessPointsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_access_points_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListAccessPointsOutput, crate::error::ListAccessPointsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_access_points_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_access_points(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListAccessPointsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_access_points_for_object_lambda_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAccessPointsForObjectLambdaOutput,
    crate::error::ListAccessPointsForObjectLambdaError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAccessPointsForObjectLambdaError::unhandled)?;
    Err(crate::error::ListAccessPointsForObjectLambdaError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_access_points_for_object_lambda_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAccessPointsForObjectLambdaOutput,
    crate::error::ListAccessPointsForObjectLambdaError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_access_points_for_object_lambda_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_list_access_points_for_object_lambda(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListAccessPointsForObjectLambdaError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_jobs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListJobsOutput, crate::error::ListJobsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListJobsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListJobsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceException" => crate::error::ListJobsError {
            meta: generic,
            kind: crate::error::ListJobsErrorKind::InternalServiceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_service_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::ListJobsError {
            meta: generic,
            kind: crate::error::ListJobsErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_next_token_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestException" => crate::error::ListJobsError {
            meta: generic,
            kind: crate::error::ListJobsErrorKind::InvalidRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListJobsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListJobsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_jobs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListJobsOutput, crate::error::ListJobsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_jobs_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_jobs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListJobsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_multi_region_access_points_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListMultiRegionAccessPointsOutput,
    crate::error::ListMultiRegionAccessPointsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListMultiRegionAccessPointsError::unhandled)?;
    Err(crate::error::ListMultiRegionAccessPointsError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_multi_region_access_points_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListMultiRegionAccessPointsOutput,
    crate::error::ListMultiRegionAccessPointsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_multi_region_access_points_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_multi_region_access_points(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListMultiRegionAccessPointsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_regional_buckets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListRegionalBucketsOutput,
    crate::error::ListRegionalBucketsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListRegionalBucketsError::unhandled)?;
    Err(crate::error::ListRegionalBucketsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_regional_buckets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListRegionalBucketsOutput,
    crate::error::ListRegionalBucketsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_regional_buckets_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_regional_buckets(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListRegionalBucketsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_storage_lens_configurations_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListStorageLensConfigurationsOutput,
    crate::error::ListStorageLensConfigurationsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListStorageLensConfigurationsError::unhandled)?;
    Err(crate::error::ListStorageLensConfigurationsError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_storage_lens_configurations_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListStorageLensConfigurationsOutput,
    crate::error::ListStorageLensConfigurationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_storage_lens_configurations_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_list_storage_lens_configurations(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListStorageLensConfigurationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_access_point_configuration_for_object_lambda_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutAccessPointConfigurationForObjectLambdaOutput,
    crate::error::PutAccessPointConfigurationForObjectLambdaError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutAccessPointConfigurationForObjectLambdaError::unhandled)?;
    Err(crate::error::PutAccessPointConfigurationForObjectLambdaError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_access_point_configuration_for_object_lambda_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutAccessPointConfigurationForObjectLambdaOutput,
    crate::error::PutAccessPointConfigurationForObjectLambdaError,
> {
    Ok({
        #[allow(unused_mut)]let mut output = crate::output::put_access_point_configuration_for_object_lambda_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_access_point_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutAccessPointPolicyOutput,
    crate::error::PutAccessPointPolicyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutAccessPointPolicyError::unhandled)?;
    Err(crate::error::PutAccessPointPolicyError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_access_point_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutAccessPointPolicyOutput,
    crate::error::PutAccessPointPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_access_point_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_access_point_policy_for_object_lambda_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutAccessPointPolicyForObjectLambdaOutput,
    crate::error::PutAccessPointPolicyForObjectLambdaError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutAccessPointPolicyForObjectLambdaError::unhandled)?;
    Err(crate::error::PutAccessPointPolicyForObjectLambdaError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_access_point_policy_for_object_lambda_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutAccessPointPolicyForObjectLambdaOutput,
    crate::error::PutAccessPointPolicyForObjectLambdaError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::put_access_point_policy_for_object_lambda_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_lifecycle_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutBucketLifecycleConfigurationOutput,
    crate::error::PutBucketLifecycleConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutBucketLifecycleConfigurationError::unhandled)?;
    Err(crate::error::PutBucketLifecycleConfigurationError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_lifecycle_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutBucketLifecycleConfigurationOutput,
    crate::error::PutBucketLifecycleConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::put_bucket_lifecycle_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutBucketPolicyOutput, crate::error::PutBucketPolicyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutBucketPolicyError::unhandled)?;
    Err(crate::error::PutBucketPolicyError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutBucketPolicyOutput, crate::error::PutBucketPolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_bucket_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_tagging_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutBucketTaggingOutput, crate::error::PutBucketTaggingError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutBucketTaggingError::unhandled)?;
    Err(crate::error::PutBucketTaggingError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_bucket_tagging_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutBucketTaggingOutput, crate::error::PutBucketTaggingError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_bucket_tagging_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_job_tagging_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutJobTaggingOutput, crate::error::PutJobTaggingError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutJobTaggingError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutJobTaggingError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceException" => crate::error::PutJobTaggingError {
            meta: generic,
            kind: crate::error::PutJobTaggingErrorKind::InternalServiceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_service_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutJobTaggingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => {
            crate::error::PutJobTaggingError {
                meta: generic,
                kind: crate::error::PutJobTaggingErrorKind::NotFoundException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutJobTaggingError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::PutJobTaggingError {
            meta: generic,
            kind: crate::error::PutJobTaggingErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_requests_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutJobTaggingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTagsException" => crate::error::PutJobTaggingError {
            meta: generic,
            kind: crate::error::PutJobTaggingErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_tags_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutJobTaggingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutJobTaggingError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_job_tagging_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutJobTaggingOutput, crate::error::PutJobTaggingError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_job_tagging_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_multi_region_access_point_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutMultiRegionAccessPointPolicyOutput,
    crate::error::PutMultiRegionAccessPointPolicyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutMultiRegionAccessPointPolicyError::unhandled)?;
    Err(crate::error::PutMultiRegionAccessPointPolicyError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_multi_region_access_point_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutMultiRegionAccessPointPolicyOutput,
    crate::error::PutMultiRegionAccessPointPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::put_multi_region_access_point_policy_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_put_multi_region_access_point_policy(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::PutMultiRegionAccessPointPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_public_access_block_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutPublicAccessBlockOutput,
    crate::error::PutPublicAccessBlockError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutPublicAccessBlockError::unhandled)?;
    Err(crate::error::PutPublicAccessBlockError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_public_access_block_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutPublicAccessBlockOutput,
    crate::error::PutPublicAccessBlockError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_public_access_block_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_storage_lens_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutStorageLensConfigurationOutput,
    crate::error::PutStorageLensConfigurationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutStorageLensConfigurationError::unhandled)?;
    Err(crate::error::PutStorageLensConfigurationError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_storage_lens_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutStorageLensConfigurationOutput,
    crate::error::PutStorageLensConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_storage_lens_configuration_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_storage_lens_configuration_tagging_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutStorageLensConfigurationTaggingOutput,
    crate::error::PutStorageLensConfigurationTaggingError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutStorageLensConfigurationTaggingError::unhandled)?;
    Err(crate::error::PutStorageLensConfigurationTaggingError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_storage_lens_configuration_tagging_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutStorageLensConfigurationTaggingOutput,
    crate::error::PutStorageLensConfigurationTaggingError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::put_storage_lens_configuration_tagging_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_job_priority_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateJobPriorityOutput, crate::error::UpdateJobPriorityError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateJobPriorityError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateJobPriorityError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::UpdateJobPriorityError {
            meta: generic,
            kind: crate::error::UpdateJobPriorityErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_bad_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateJobPriorityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceException" => crate::error::UpdateJobPriorityError {
            meta: generic,
            kind: crate::error::UpdateJobPriorityErrorKind::InternalServiceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_service_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateJobPriorityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => {
            crate::error::UpdateJobPriorityError {
                meta: generic,
                kind: crate::error::UpdateJobPriorityErrorKind::NotFoundException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateJobPriorityError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::UpdateJobPriorityError {
            meta: generic,
            kind: crate::error::UpdateJobPriorityErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_requests_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateJobPriorityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateJobPriorityError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_job_priority_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateJobPriorityOutput, crate::error::UpdateJobPriorityError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_job_priority_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_update_job_priority(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateJobPriorityError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_job_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateJobStatusOutput, crate::error::UpdateJobStatusError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateJobStatusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateJobStatusError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::UpdateJobStatusError {
            meta: generic,
            kind: crate::error::UpdateJobStatusErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_bad_request_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateJobStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceException" => crate::error::UpdateJobStatusError {
            meta: generic,
            kind: crate::error::UpdateJobStatusErrorKind::InternalServiceException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_service_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateJobStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "JobStatusException" => {
            crate::error::UpdateJobStatusError {
                meta: generic,
                kind: crate::error::UpdateJobStatusErrorKind::JobStatusException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::job_status_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_job_status_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateJobStatusError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "NotFoundException" => {
            crate::error::UpdateJobStatusError {
                meta: generic,
                kind: crate::error::UpdateJobStatusErrorKind::NotFoundException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateJobStatusError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::UpdateJobStatusError {
            meta: generic,
            kind: crate::error::UpdateJobStatusErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_too_many_requests_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateJobStatusError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateJobStatusError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_job_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateJobStatusOutput, crate::error::UpdateJobStatusError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_job_status_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_update_job_status(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateJobStatusError::unhandled)?;
        output.build()
    })
}
