// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub fn parse_http_generic_error(
    response: &http::Response<bytes::Bytes>,
) -> Result<aws_smithy_types::Error, aws_smithy_xml::decode::XmlError> {
    crate::rest_xml_wrapped_errors::parse_generic_error(response.body().as_ref())
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_access_point(
    inp: &[u8],
    mut builder: crate::output::create_access_point_output::Builder,
) -> Result<crate::output::create_access_point_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateAccessPointResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateAccessPointResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("AccessPointArn") /* AccessPointArn com.amazonaws.s3control.synthetic#CreateAccessPointOutput$AccessPointArn */ =>  {
                let var_1 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_access_point_arn(var_1);
            }
            ,
            s if s.matches("Alias") /* Alias com.amazonaws.s3control.synthetic#CreateAccessPointOutput$Alias */ =>  {
                let var_2 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_alias(var_2);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_access_point_for_object_lambda(
    inp: &[u8],
    mut builder: crate::output::create_access_point_for_object_lambda_output::Builder,
) -> Result<
    crate::output::create_access_point_for_object_lambda_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateAccessPointForObjectLambdaResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateAccessPointForObjectLambdaResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ObjectLambdaAccessPointArn") /* ObjectLambdaAccessPointArn com.amazonaws.s3control.synthetic#CreateAccessPointForObjectLambdaOutput$ObjectLambdaAccessPointArn */ =>  {
                let var_3 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_object_lambda_access_point_arn(var_3);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_bucket_already_exists_xml_err(
    inp: &[u8],
    mut builder: crate::error::bucket_already_exists::Builder,
) -> Result<crate::error::bucket_already_exists::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.s3control#BucketAlreadyExists$message */ =>  {
                let var_4 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_4);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_bucket_already_owned_by_you_xml_err(
    inp: &[u8],
    mut builder: crate::error::bucket_already_owned_by_you::Builder,
) -> Result<crate::error::bucket_already_owned_by_you::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.s3control#BucketAlreadyOwnedByYou$message */ =>  {
                let var_5 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_5);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_bucket(
    inp: &[u8],
    mut builder: crate::output::create_bucket_output::Builder,
) -> Result<crate::output::create_bucket_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateBucketResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateBucketResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("BucketArn") /* BucketArn com.amazonaws.s3control.synthetic#CreateBucketOutput$BucketArn */ =>  {
                let var_6 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_bucket_arn(var_6);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_bad_request_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::bad_request_exception::Builder,
) -> Result<crate::error::bad_request_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Message") /* Message com.amazonaws.s3control#BadRequestException$Message */ =>  {
                let var_7 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_7);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_idempotency_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::idempotency_exception::Builder,
) -> Result<crate::error::idempotency_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Message") /* Message com.amazonaws.s3control#IdempotencyException$Message */ =>  {
                let var_8 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_8);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_internal_service_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::internal_service_exception::Builder,
) -> Result<crate::error::internal_service_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Message") /* Message com.amazonaws.s3control#InternalServiceException$Message */ =>  {
                let var_9 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_9);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_too_many_requests_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::too_many_requests_exception::Builder,
) -> Result<crate::error::too_many_requests_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Message") /* Message com.amazonaws.s3control#TooManyRequestsException$Message */ =>  {
                let var_10 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_10);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_job(
    inp: &[u8],
    mut builder: crate::output::create_job_output::Builder,
) -> Result<crate::output::create_job_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateJobResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateJobResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("JobId") /* JobId com.amazonaws.s3control.synthetic#CreateJobOutput$JobId */ =>  {
                let var_11 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_job_id(var_11);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_multi_region_access_point(
    inp: &[u8],
    mut builder: crate::output::create_multi_region_access_point_output::Builder,
) -> Result<
    crate::output::create_multi_region_access_point_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateMultiRegionAccessPointResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateMultiRegionAccessPointResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("RequestTokenARN") /* RequestTokenARN com.amazonaws.s3control.synthetic#CreateMultiRegionAccessPointOutput$RequestTokenARN */ =>  {
                let var_12 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_request_token_arn(var_12);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_not_found_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::not_found_exception::Builder,
) -> Result<crate::error::not_found_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Message") /* Message com.amazonaws.s3control#NotFoundException$Message */ =>  {
                let var_13 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_13);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_multi_region_access_point(
    inp: &[u8],
    mut builder: crate::output::delete_multi_region_access_point_output::Builder,
) -> Result<
    crate::output::delete_multi_region_access_point_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteMultiRegionAccessPointResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteMultiRegionAccessPointResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("RequestTokenARN") /* RequestTokenARN com.amazonaws.s3control.synthetic#DeleteMultiRegionAccessPointOutput$RequestTokenARN */ =>  {
                let var_14 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_request_token_arn(var_14);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_job(
    inp: &[u8],
    mut builder: crate::output::describe_job_output::Builder,
) -> Result<crate::output::describe_job_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeJobResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeJobResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Job") /* Job com.amazonaws.s3control.synthetic#DescribeJobOutput$Job */ =>  {
                let var_15 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_job_descriptor(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_job(var_15);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_multi_region_access_point_operation(
    inp: &[u8],
    mut builder: crate::output::describe_multi_region_access_point_operation_output::Builder,
) -> Result<
    crate::output::describe_multi_region_access_point_operation_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeMultiRegionAccessPointOperationResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeMultiRegionAccessPointOperationResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("AsyncOperation") /* AsyncOperation com.amazonaws.s3control.synthetic#DescribeMultiRegionAccessPointOperationOutput$AsyncOperation */ =>  {
                let var_16 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_async_operation(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_async_operation(var_16);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_access_point(
    inp: &[u8],
    mut builder: crate::output::get_access_point_output::Builder,
) -> Result<crate::output::get_access_point_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetAccessPointResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetAccessPointResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Endpoints") /* Endpoints com.amazonaws.s3control.synthetic#GetAccessPointOutput$Endpoints */ =>  {
                let var_17 =
                    Some(
                        crate::xml_deser::deser_map_com_amazonaws_s3control_endpoints(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_endpoints(var_17);
            }
            ,
            s if s.matches("PublicAccessBlockConfiguration") /* PublicAccessBlockConfiguration com.amazonaws.s3control.synthetic#GetAccessPointOutput$PublicAccessBlockConfiguration */ =>  {
                let var_18 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_public_access_block_configuration(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_public_access_block_configuration(var_18);
            }
            ,
            s if s.matches("CreationDate") /* CreationDate com.amazonaws.s3control.synthetic#GetAccessPointOutput$CreationDate */ =>  {
                let var_19 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.s3control#CreationDate`)"))
                        ?
                    )
                ;
                builder = builder.set_creation_date(var_19);
            }
            ,
            s if s.matches("Bucket") /* Bucket com.amazonaws.s3control.synthetic#GetAccessPointOutput$Bucket */ =>  {
                let var_20 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_bucket(var_20);
            }
            ,
            s if s.matches("Alias") /* Alias com.amazonaws.s3control.synthetic#GetAccessPointOutput$Alias */ =>  {
                let var_21 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_alias(var_21);
            }
            ,
            s if s.matches("AccessPointArn") /* AccessPointArn com.amazonaws.s3control.synthetic#GetAccessPointOutput$AccessPointArn */ =>  {
                let var_22 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_access_point_arn(var_22);
            }
            ,
            s if s.matches("VpcConfiguration") /* VpcConfiguration com.amazonaws.s3control.synthetic#GetAccessPointOutput$VpcConfiguration */ =>  {
                let var_23 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_vpc_configuration(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpc_configuration(var_23);
            }
            ,
            s if s.matches("NetworkOrigin") /* NetworkOrigin com.amazonaws.s3control.synthetic#GetAccessPointOutput$NetworkOrigin */ =>  {
                let var_24 =
                    Some(
                        Result::<crate::model::NetworkOrigin, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::NetworkOrigin::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_network_origin(var_24);
            }
            ,
            s if s.matches("Name") /* Name com.amazonaws.s3control.synthetic#GetAccessPointOutput$Name */ =>  {
                let var_25 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_25);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_access_point_configuration_for_object_lambda(
    inp: &[u8],
    mut builder: crate::output::get_access_point_configuration_for_object_lambda_output::Builder,
) -> Result<
    crate::output::get_access_point_configuration_for_object_lambda_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetAccessPointConfigurationForObjectLambdaResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetAccessPointConfigurationForObjectLambdaResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Configuration") /* Configuration com.amazonaws.s3control.synthetic#GetAccessPointConfigurationForObjectLambdaOutput$Configuration */ =>  {
                let var_26 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_object_lambda_configuration(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_configuration(var_26);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_access_point_for_object_lambda(
    inp: &[u8],
    mut builder: crate::output::get_access_point_for_object_lambda_output::Builder,
) -> Result<
    crate::output::get_access_point_for_object_lambda_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetAccessPointForObjectLambdaResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetAccessPointForObjectLambdaResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("PublicAccessBlockConfiguration") /* PublicAccessBlockConfiguration com.amazonaws.s3control.synthetic#GetAccessPointForObjectLambdaOutput$PublicAccessBlockConfiguration */ =>  {
                let var_27 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_public_access_block_configuration(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_public_access_block_configuration(var_27);
            }
            ,
            s if s.matches("CreationDate") /* CreationDate com.amazonaws.s3control.synthetic#GetAccessPointForObjectLambdaOutput$CreationDate */ =>  {
                let var_28 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.s3control#CreationDate`)"))
                        ?
                    )
                ;
                builder = builder.set_creation_date(var_28);
            }
            ,
            s if s.matches("Name") /* Name com.amazonaws.s3control.synthetic#GetAccessPointForObjectLambdaOutput$Name */ =>  {
                let var_29 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_29);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_access_point_policy(
    inp: &[u8],
    mut builder: crate::output::get_access_point_policy_output::Builder,
) -> Result<crate::output::get_access_point_policy_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetAccessPointPolicyResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetAccessPointPolicyResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Policy") /* Policy com.amazonaws.s3control.synthetic#GetAccessPointPolicyOutput$Policy */ =>  {
                let var_30 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_policy(var_30);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_access_point_policy_for_object_lambda(
    inp: &[u8],
    mut builder: crate::output::get_access_point_policy_for_object_lambda_output::Builder,
) -> Result<
    crate::output::get_access_point_policy_for_object_lambda_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetAccessPointPolicyForObjectLambdaResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetAccessPointPolicyForObjectLambdaResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Policy") /* Policy com.amazonaws.s3control.synthetic#GetAccessPointPolicyForObjectLambdaOutput$Policy */ =>  {
                let var_31 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_policy(var_31);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_access_point_policy_status(
    inp: &[u8],
    mut builder: crate::output::get_access_point_policy_status_output::Builder,
) -> Result<
    crate::output::get_access_point_policy_status_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetAccessPointPolicyStatusResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetAccessPointPolicyStatusResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("PolicyStatus") /* PolicyStatus com.amazonaws.s3control.synthetic#GetAccessPointPolicyStatusOutput$PolicyStatus */ =>  {
                let var_32 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_policy_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_policy_status(var_32);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_access_point_policy_status_for_object_lambda(
    inp: &[u8],
    mut builder: crate::output::get_access_point_policy_status_for_object_lambda_output::Builder,
) -> Result<
    crate::output::get_access_point_policy_status_for_object_lambda_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetAccessPointPolicyStatusForObjectLambdaResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetAccessPointPolicyStatusForObjectLambdaResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("PolicyStatus") /* PolicyStatus com.amazonaws.s3control.synthetic#GetAccessPointPolicyStatusForObjectLambdaOutput$PolicyStatus */ =>  {
                let var_33 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_policy_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_policy_status(var_33);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_bucket(
    inp: &[u8],
    mut builder: crate::output::get_bucket_output::Builder,
) -> Result<crate::output::get_bucket_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetBucketResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetBucketResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("CreationDate") /* CreationDate com.amazonaws.s3control.synthetic#GetBucketOutput$CreationDate */ =>  {
                let var_34 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.s3control#CreationDate`)"))
                        ?
                    )
                ;
                builder = builder.set_creation_date(var_34);
            }
            ,
            s if s.matches("Bucket") /* Bucket com.amazonaws.s3control.synthetic#GetBucketOutput$Bucket */ =>  {
                let var_35 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_bucket(var_35);
            }
            ,
            s if s.matches("PublicAccessBlockEnabled") /* PublicAccessBlockEnabled com.amazonaws.s3control.synthetic#GetBucketOutput$PublicAccessBlockEnabled */ =>  {
                let var_36 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3control#PublicAccessBlockEnabled`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_public_access_block_enabled(var_36);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_bucket_lifecycle_configuration(
    inp: &[u8],
    mut builder: crate::output::get_bucket_lifecycle_configuration_output::Builder,
) -> Result<
    crate::output::get_bucket_lifecycle_configuration_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetBucketLifecycleConfigurationResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetBucketLifecycleConfigurationResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Rules") /* Rules com.amazonaws.s3control.synthetic#GetBucketLifecycleConfigurationOutput$Rules */ =>  {
                let var_37 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3control_lifecycle_rules(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_rules(var_37);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_bucket_policy(
    inp: &[u8],
    mut builder: crate::output::get_bucket_policy_output::Builder,
) -> Result<crate::output::get_bucket_policy_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetBucketPolicyResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetBucketPolicyResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Policy") /* Policy com.amazonaws.s3control.synthetic#GetBucketPolicyOutput$Policy */ =>  {
                let var_38 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_policy(var_38);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_bucket_tagging(
    inp: &[u8],
    mut builder: crate::output::get_bucket_tagging_output::Builder,
) -> Result<crate::output::get_bucket_tagging_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetBucketTaggingResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetBucketTaggingResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("TagSet") /* TagSet com.amazonaws.s3control.synthetic#GetBucketTaggingOutput$TagSet */ =>  {
                let var_39 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3control_s3_tag_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tag_set(var_39);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_job_tagging(
    inp: &[u8],
    mut builder: crate::output::get_job_tagging_output::Builder,
) -> Result<crate::output::get_job_tagging_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetJobTaggingResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetJobTaggingResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Tags") /* Tags com.amazonaws.s3control.synthetic#GetJobTaggingOutput$Tags */ =>  {
                let var_40 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3control_s3_tag_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_40);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_multi_region_access_point(
    inp: &[u8],
    mut builder: crate::output::get_multi_region_access_point_output::Builder,
) -> Result<
    crate::output::get_multi_region_access_point_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetMultiRegionAccessPointResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetMultiRegionAccessPointResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("AccessPoint") /* AccessPoint com.amazonaws.s3control.synthetic#GetMultiRegionAccessPointOutput$AccessPoint */ =>  {
                let var_41 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_multi_region_access_point_report(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_access_point(var_41);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_multi_region_access_point_policy(
    inp: &[u8],
    mut builder: crate::output::get_multi_region_access_point_policy_output::Builder,
) -> Result<
    crate::output::get_multi_region_access_point_policy_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetMultiRegionAccessPointPolicyResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetMultiRegionAccessPointPolicyResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Policy") /* Policy com.amazonaws.s3control.synthetic#GetMultiRegionAccessPointPolicyOutput$Policy */ =>  {
                let var_42 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_multi_region_access_point_policy_document(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_policy(var_42);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_multi_region_access_point_policy_status(
    inp: &[u8],
    mut builder: crate::output::get_multi_region_access_point_policy_status_output::Builder,
) -> Result<
    crate::output::get_multi_region_access_point_policy_status_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetMultiRegionAccessPointPolicyStatusResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetMultiRegionAccessPointPolicyStatusResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Established") /* Established com.amazonaws.s3control.synthetic#GetMultiRegionAccessPointPolicyStatusOutput$Established */ =>  {
                let var_43 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_policy_status(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_established(var_43);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_no_such_public_access_block_configuration_xml_err(
    inp: &[u8],
    mut builder: crate::error::no_such_public_access_block_configuration::Builder,
) -> Result<
    crate::error::no_such_public_access_block_configuration::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Message") /* Message com.amazonaws.s3control#NoSuchPublicAccessBlockConfiguration$Message */ =>  {
                let var_44 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_44);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_storage_lens_configuration_tagging(
    inp: &[u8],
    mut builder: crate::output::get_storage_lens_configuration_tagging_output::Builder,
) -> Result<
    crate::output::get_storage_lens_configuration_tagging_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetStorageLensConfigurationTaggingResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetStorageLensConfigurationTaggingResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Tags") /* Tags com.amazonaws.s3control.synthetic#GetStorageLensConfigurationTaggingOutput$Tags */ =>  {
                let var_45 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3control_storage_lens_tags(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_45);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_access_points(
    inp: &[u8],
    mut builder: crate::output::list_access_points_output::Builder,
) -> Result<crate::output::list_access_points_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListAccessPointsResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListAccessPointsResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("NextToken") /* NextToken com.amazonaws.s3control.synthetic#ListAccessPointsOutput$NextToken */ =>  {
                let var_46 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_46);
            }
            ,
            s if s.matches("AccessPointList") /* AccessPointList com.amazonaws.s3control.synthetic#ListAccessPointsOutput$AccessPointList */ =>  {
                let var_47 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3control_access_point_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_access_point_list(var_47);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_access_points_for_object_lambda(
    inp: &[u8],
    mut builder: crate::output::list_access_points_for_object_lambda_output::Builder,
) -> Result<
    crate::output::list_access_points_for_object_lambda_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListAccessPointsForObjectLambdaResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListAccessPointsForObjectLambdaResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("NextToken") /* NextToken com.amazonaws.s3control.synthetic#ListAccessPointsForObjectLambdaOutput$NextToken */ =>  {
                let var_48 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_48);
            }
            ,
            s if s.matches("ObjectLambdaAccessPointList") /* ObjectLambdaAccessPointList com.amazonaws.s3control.synthetic#ListAccessPointsForObjectLambdaOutput$ObjectLambdaAccessPointList */ =>  {
                let var_49 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3control_object_lambda_access_point_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_object_lambda_access_point_list(var_49);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_next_token_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_next_token_exception::Builder,
) -> Result<crate::error::invalid_next_token_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Message") /* Message com.amazonaws.s3control#InvalidNextTokenException$Message */ =>  {
                let var_50 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_50);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_request_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_request_exception::Builder,
) -> Result<crate::error::invalid_request_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Message") /* Message com.amazonaws.s3control#InvalidRequestException$Message */ =>  {
                let var_51 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_51);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_jobs(
    inp: &[u8],
    mut builder: crate::output::list_jobs_output::Builder,
) -> Result<crate::output::list_jobs_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListJobsResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListJobsResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("NextToken") /* NextToken com.amazonaws.s3control.synthetic#ListJobsOutput$NextToken */ =>  {
                let var_52 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_52);
            }
            ,
            s if s.matches("Jobs") /* Jobs com.amazonaws.s3control.synthetic#ListJobsOutput$Jobs */ =>  {
                let var_53 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3control_job_list_descriptor_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_jobs(var_53);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_multi_region_access_points(
    inp: &[u8],
    mut builder: crate::output::list_multi_region_access_points_output::Builder,
) -> Result<
    crate::output::list_multi_region_access_points_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListMultiRegionAccessPointsResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListMultiRegionAccessPointsResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("AccessPoints") /* AccessPoints com.amazonaws.s3control.synthetic#ListMultiRegionAccessPointsOutput$AccessPoints */ =>  {
                let var_54 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3control_multi_region_access_point_report_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_access_points(var_54);
            }
            ,
            s if s.matches("NextToken") /* NextToken com.amazonaws.s3control.synthetic#ListMultiRegionAccessPointsOutput$NextToken */ =>  {
                let var_55 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_55);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_regional_buckets(
    inp: &[u8],
    mut builder: crate::output::list_regional_buckets_output::Builder,
) -> Result<crate::output::list_regional_buckets_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListRegionalBucketsResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListRegionalBucketsResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("RegionalBucketList") /* RegionalBucketList com.amazonaws.s3control.synthetic#ListRegionalBucketsOutput$RegionalBucketList */ =>  {
                let var_56 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3control_regional_bucket_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_regional_bucket_list(var_56);
            }
            ,
            s if s.matches("NextToken") /* NextToken com.amazonaws.s3control.synthetic#ListRegionalBucketsOutput$NextToken */ =>  {
                let var_57 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_57);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_storage_lens_configurations(
    inp: &[u8],
    mut builder: crate::output::list_storage_lens_configurations_output::Builder,
) -> Result<
    crate::output::list_storage_lens_configurations_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListStorageLensConfigurationsResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListStorageLensConfigurationsResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("StorageLensConfigurationList") /* StorageLensConfigurationList com.amazonaws.s3control.synthetic#ListStorageLensConfigurationsOutput$StorageLensConfigurationList */ =>  {
                let var_58 =
                    Some(
                        Result::<std::vec::Vec<crate::model::ListStorageLensConfigurationEntry>, aws_smithy_xml::decode::XmlError>::Ok({
                            let mut list_59 = builder.storage_lens_configuration_list.take().unwrap_or_default();
                            list_59.push(
                                crate::xml_deser::deser_structure_crate_model_list_storage_lens_configuration_entry(&mut tag)
                                ?
                            );
                            list_59
                        })
                        ?
                    )
                ;
                builder = builder.set_storage_lens_configuration_list(var_58);
            }
            ,
            s if s.matches("NextToken") /* NextToken com.amazonaws.s3control.synthetic#ListStorageLensConfigurationsOutput$NextToken */ =>  {
                let var_60 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_60);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_too_many_tags_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::too_many_tags_exception::Builder,
) -> Result<crate::error::too_many_tags_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Message") /* Message com.amazonaws.s3control#TooManyTagsException$Message */ =>  {
                let var_61 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_61);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_put_multi_region_access_point_policy(
    inp: &[u8],
    mut builder: crate::output::put_multi_region_access_point_policy_output::Builder,
) -> Result<
    crate::output::put_multi_region_access_point_policy_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("PutMultiRegionAccessPointPolicyResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected PutMultiRegionAccessPointPolicyResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("RequestTokenARN") /* RequestTokenARN com.amazonaws.s3control.synthetic#PutMultiRegionAccessPointPolicyOutput$RequestTokenARN */ =>  {
                let var_62 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_request_token_arn(var_62);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_update_job_priority(
    inp: &[u8],
    mut builder: crate::output::update_job_priority_output::Builder,
) -> Result<crate::output::update_job_priority_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("UpdateJobPriorityResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected UpdateJobPriorityResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Priority") /* Priority com.amazonaws.s3control.synthetic#UpdateJobPriorityOutput$Priority */ =>  {
                let var_63 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3control#JobPriority`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_priority(var_63);
            }
            ,
            s if s.matches("JobId") /* JobId com.amazonaws.s3control.synthetic#UpdateJobPriorityOutput$JobId */ =>  {
                let var_64 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_job_id(var_64);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_job_status_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::job_status_exception::Builder,
) -> Result<crate::error::job_status_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Message") /* Message com.amazonaws.s3control#JobStatusException$Message */ =>  {
                let var_65 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_65);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_update_job_status(
    inp: &[u8],
    mut builder: crate::output::update_job_status_output::Builder,
) -> Result<crate::output::update_job_status_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("UpdateJobStatusResult")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected UpdateJobStatusResult got {:?}",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Status") /* Status com.amazonaws.s3control.synthetic#UpdateJobStatusOutput$Status */ =>  {
                let var_66 =
                    Some(
                        Result::<crate::model::JobStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::JobStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_66);
            }
            ,
            s if s.matches("StatusUpdateReason") /* StatusUpdateReason com.amazonaws.s3control.synthetic#UpdateJobStatusOutput$StatusUpdateReason */ =>  {
                let var_67 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_status_update_reason(var_67);
            }
            ,
            s if s.matches("JobId") /* JobId com.amazonaws.s3control.synthetic#UpdateJobStatusOutput$JobId */ =>  {
                let var_68 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_job_id(var_68);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

pub fn deser_member_com_amazonaws_s3control_synthetic_get_public_access_block_output_public_access_block_configuration(
    inp: &[u8],
) -> Result<crate::model::PublicAccessBlockConfiguration, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("PublicAccessBlockConfiguration")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected PublicAccessBlockConfiguration got {:?}",
            start_el
        )));
    }
    crate::xml_deser::deser_structure_crate_model_public_access_block_configuration(&mut decoder)
}

pub fn deser_member_com_amazonaws_s3control_synthetic_get_storage_lens_configuration_output_storage_lens_configuration(
    inp: &[u8],
) -> Result<crate::model::StorageLensConfiguration, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("StorageLensConfiguration")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected StorageLensConfiguration got {:?}",
            start_el
        )));
    }
    crate::xml_deser::deser_structure_crate_model_storage_lens_configuration(&mut decoder)
}

pub fn deser_structure_crate_model_job_descriptor(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::JobDescriptor, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::JobDescriptor::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("JobId") /* JobId com.amazonaws.s3control#JobDescriptor$JobId */ =>  {
                let var_69 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_job_id(var_69);
            }
            ,
            s if s.matches("ConfirmationRequired") /* ConfirmationRequired com.amazonaws.s3control#JobDescriptor$ConfirmationRequired */ =>  {
                let var_70 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3control#ConfirmationRequired`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_confirmation_required(var_70);
            }
            ,
            s if s.matches("Description") /* Description com.amazonaws.s3control#JobDescriptor$Description */ =>  {
                let var_71 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_71);
            }
            ,
            s if s.matches("JobArn") /* JobArn com.amazonaws.s3control#JobDescriptor$JobArn */ =>  {
                let var_72 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_job_arn(var_72);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.s3control#JobDescriptor$Status */ =>  {
                let var_73 =
                    Some(
                        Result::<crate::model::JobStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::JobStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_73);
            }
            ,
            s if s.matches("Manifest") /* Manifest com.amazonaws.s3control#JobDescriptor$Manifest */ =>  {
                let var_74 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_job_manifest(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_manifest(var_74);
            }
            ,
            s if s.matches("Operation") /* Operation com.amazonaws.s3control#JobDescriptor$Operation */ =>  {
                let var_75 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_job_operation(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_operation(var_75);
            }
            ,
            s if s.matches("Priority") /* Priority com.amazonaws.s3control#JobDescriptor$Priority */ =>  {
                let var_76 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3control#JobPriority`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_priority(var_76);
            }
            ,
            s if s.matches("ProgressSummary") /* ProgressSummary com.amazonaws.s3control#JobDescriptor$ProgressSummary */ =>  {
                let var_77 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_job_progress_summary(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_progress_summary(var_77);
            }
            ,
            s if s.matches("StatusUpdateReason") /* StatusUpdateReason com.amazonaws.s3control#JobDescriptor$StatusUpdateReason */ =>  {
                let var_78 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_status_update_reason(var_78);
            }
            ,
            s if s.matches("FailureReasons") /* FailureReasons com.amazonaws.s3control#JobDescriptor$FailureReasons */ =>  {
                let var_79 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3control_job_failure_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_failure_reasons(var_79);
            }
            ,
            s if s.matches("Report") /* Report com.amazonaws.s3control#JobDescriptor$Report */ =>  {
                let var_80 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_job_report(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_report(var_80);
            }
            ,
            s if s.matches("CreationTime") /* CreationTime com.amazonaws.s3control#JobDescriptor$CreationTime */ =>  {
                let var_81 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.s3control#JobCreationTime`)"))
                        ?
                    )
                ;
                builder = builder.set_creation_time(var_81);
            }
            ,
            s if s.matches("TerminationDate") /* TerminationDate com.amazonaws.s3control#JobDescriptor$TerminationDate */ =>  {
                let var_82 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.s3control#JobTerminationDate`)"))
                        ?
                    )
                ;
                builder = builder.set_termination_date(var_82);
            }
            ,
            s if s.matches("RoleArn") /* RoleArn com.amazonaws.s3control#JobDescriptor$RoleArn */ =>  {
                let var_83 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_role_arn(var_83);
            }
            ,
            s if s.matches("SuspendedDate") /* SuspendedDate com.amazonaws.s3control#JobDescriptor$SuspendedDate */ =>  {
                let var_84 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.s3control#SuspendedDate`)"))
                        ?
                    )
                ;
                builder = builder.set_suspended_date(var_84);
            }
            ,
            s if s.matches("SuspendedCause") /* SuspendedCause com.amazonaws.s3control#JobDescriptor$SuspendedCause */ =>  {
                let var_85 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_suspended_cause(var_85);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_async_operation(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AsyncOperation, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AsyncOperation::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("CreationTime") /* CreationTime com.amazonaws.s3control#AsyncOperation$CreationTime */ =>  {
                let var_86 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.s3control#AsyncCreationTimestamp`)"))
                        ?
                    )
                ;
                builder = builder.set_creation_time(var_86);
            }
            ,
            s if s.matches("Operation") /* Operation com.amazonaws.s3control#AsyncOperation$Operation */ =>  {
                let var_87 =
                    Some(
                        Result::<crate::model::AsyncOperationName, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::AsyncOperationName::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_operation(var_87);
            }
            ,
            s if s.matches("RequestTokenARN") /* RequestTokenARN com.amazonaws.s3control#AsyncOperation$RequestTokenARN */ =>  {
                let var_88 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_request_token_arn(var_88);
            }
            ,
            s if s.matches("RequestParameters") /* RequestParameters com.amazonaws.s3control#AsyncOperation$RequestParameters */ =>  {
                let var_89 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_async_request_parameters(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_request_parameters(var_89);
            }
            ,
            s if s.matches("RequestStatus") /* RequestStatus com.amazonaws.s3control#AsyncOperation$RequestStatus */ =>  {
                let var_90 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_request_status(var_90);
            }
            ,
            s if s.matches("ResponseDetails") /* ResponseDetails com.amazonaws.s3control#AsyncOperation$ResponseDetails */ =>  {
                let var_91 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_async_response_details(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_response_details(var_91);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_map_com_amazonaws_s3control_endpoints(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::collections::HashMap<std::string::String, std::string::String>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::collections::HashMap::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("entry") => {
                crate::xml_deser::deser_map_com_amazonaws_s3control_endpoints_entry(
                    &mut tag, &mut out,
                )?;
            }
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_public_access_block_configuration(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::PublicAccessBlockConfiguration, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::PublicAccessBlockConfiguration::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("BlockPublicAcls") /* BlockPublicAcls com.amazonaws.s3control#PublicAccessBlockConfiguration$BlockPublicAcls */ =>  {
                let var_92 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3control#Setting`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_block_public_acls(var_92);
            }
            ,
            s if s.matches("IgnorePublicAcls") /* IgnorePublicAcls com.amazonaws.s3control#PublicAccessBlockConfiguration$IgnorePublicAcls */ =>  {
                let var_93 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3control#Setting`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_ignore_public_acls(var_93);
            }
            ,
            s if s.matches("BlockPublicPolicy") /* BlockPublicPolicy com.amazonaws.s3control#PublicAccessBlockConfiguration$BlockPublicPolicy */ =>  {
                let var_94 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3control#Setting`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_block_public_policy(var_94);
            }
            ,
            s if s.matches("RestrictPublicBuckets") /* RestrictPublicBuckets com.amazonaws.s3control#PublicAccessBlockConfiguration$RestrictPublicBuckets */ =>  {
                let var_95 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3control#Setting`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_restrict_public_buckets(var_95);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_vpc_configuration(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::VpcConfiguration, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::VpcConfiguration::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("VpcId") /* VpcId com.amazonaws.s3control#VpcConfiguration$VpcId */ =>  {
                let var_96 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_vpc_id(var_96);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_object_lambda_configuration(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ObjectLambdaConfiguration, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ObjectLambdaConfiguration::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("SupportingAccessPoint") /* SupportingAccessPoint com.amazonaws.s3control#ObjectLambdaConfiguration$SupportingAccessPoint */ =>  {
                let var_97 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_supporting_access_point(var_97);
            }
            ,
            s if s.matches("CloudWatchMetricsEnabled") /* CloudWatchMetricsEnabled com.amazonaws.s3control#ObjectLambdaConfiguration$CloudWatchMetricsEnabled */ =>  {
                let var_98 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3control#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_cloud_watch_metrics_enabled(var_98);
            }
            ,
            s if s.matches("AllowedFeatures") /* AllowedFeatures com.amazonaws.s3control#ObjectLambdaConfiguration$AllowedFeatures */ =>  {
                let var_99 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3control_object_lambda_allowed_features_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_allowed_features(var_99);
            }
            ,
            s if s.matches("TransformationConfigurations") /* TransformationConfigurations com.amazonaws.s3control#ObjectLambdaConfiguration$TransformationConfigurations */ =>  {
                let var_100 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3control_object_lambda_transformation_configurations_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transformation_configurations(var_100);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_policy_status(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::PolicyStatus, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::PolicyStatus::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("IsPublic") /* IsPublic com.amazonaws.s3control#PolicyStatus$IsPublic */ =>  {
                let var_101 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3control#IsPublic`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_public(var_101);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_s3control_lifecycle_rules(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::LifecycleRule>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Rule") /* member com.amazonaws.s3control#LifecycleRules$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_lifecycle_rule(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_s3control_s3_tag_set(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::S3Tag>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.s3control#S3TagSet$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_s3_tag(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_multi_region_access_point_report(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::MultiRegionAccessPointReport, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::MultiRegionAccessPointReport::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* Name com.amazonaws.s3control#MultiRegionAccessPointReport$Name */ =>  {
                let var_102 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_102);
            }
            ,
            s if s.matches("Alias") /* Alias com.amazonaws.s3control#MultiRegionAccessPointReport$Alias */ =>  {
                let var_103 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_alias(var_103);
            }
            ,
            s if s.matches("CreatedAt") /* CreatedAt com.amazonaws.s3control#MultiRegionAccessPointReport$CreatedAt */ =>  {
                let var_104 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.s3control#CreationTimestamp`)"))
                        ?
                    )
                ;
                builder = builder.set_created_at(var_104);
            }
            ,
            s if s.matches("PublicAccessBlock") /* PublicAccessBlock com.amazonaws.s3control#MultiRegionAccessPointReport$PublicAccessBlock */ =>  {
                let var_105 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_public_access_block_configuration(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_public_access_block(var_105);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.s3control#MultiRegionAccessPointReport$Status */ =>  {
                let var_106 =
                    Some(
                        Result::<crate::model::MultiRegionAccessPointStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::MultiRegionAccessPointStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_106);
            }
            ,
            s if s.matches("Regions") /* Regions com.amazonaws.s3control#MultiRegionAccessPointReport$Regions */ =>  {
                let var_107 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3control_region_report_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_regions(var_107);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_multi_region_access_point_policy_document(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::MultiRegionAccessPointPolicyDocument, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::MultiRegionAccessPointPolicyDocument::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Established") /* Established com.amazonaws.s3control#MultiRegionAccessPointPolicyDocument$Established */ =>  {
                let var_108 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_established_multi_region_access_point_policy(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_established(var_108);
            }
            ,
            s if s.matches("Proposed") /* Proposed com.amazonaws.s3control#MultiRegionAccessPointPolicyDocument$Proposed */ =>  {
                let var_109 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_proposed_multi_region_access_point_policy(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_proposed(var_109);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_s3control_storage_lens_tags(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::StorageLensTag>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Tag") /* member com.amazonaws.s3control#StorageLensTags$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_storage_lens_tag(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_s3control_access_point_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::AccessPoint>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("AccessPoint") /* member com.amazonaws.s3control#AccessPointList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_access_point(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_s3control_object_lambda_access_point_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::ObjectLambdaAccessPoint>, aws_smithy_xml::decode::XmlError>
{
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ObjectLambdaAccessPoint") /* member com.amazonaws.s3control#ObjectLambdaAccessPointList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_object_lambda_access_point(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_s3control_job_list_descriptor_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::JobListDescriptor>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.s3control#JobListDescriptorList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_job_list_descriptor(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_s3control_multi_region_access_point_report_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::vec::Vec<crate::model::MultiRegionAccessPointReport>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("AccessPoint") /* member com.amazonaws.s3control#MultiRegionAccessPointReportList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_multi_region_access_point_report(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_s3control_regional_bucket_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::RegionalBucket>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("RegionalBucket") /* member com.amazonaws.s3control#RegionalBucketList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_regional_bucket(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_list_storage_lens_configuration_entry(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ListStorageLensConfigurationEntry, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ListStorageLensConfigurationEntry::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Id") /* Id com.amazonaws.s3control#ListStorageLensConfigurationEntry$Id */ =>  {
                let var_110 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_id(var_110);
            }
            ,
            s if s.matches("StorageLensArn") /* StorageLensArn com.amazonaws.s3control#ListStorageLensConfigurationEntry$StorageLensArn */ =>  {
                let var_111 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_storage_lens_arn(var_111);
            }
            ,
            s if s.matches("HomeRegion") /* HomeRegion com.amazonaws.s3control#ListStorageLensConfigurationEntry$HomeRegion */ =>  {
                let var_112 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_home_region(var_112);
            }
            ,
            s if s.matches("IsEnabled") /* IsEnabled com.amazonaws.s3control#ListStorageLensConfigurationEntry$IsEnabled */ =>  {
                let var_113 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3control#IsEnabled`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_enabled(var_113);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_storage_lens_configuration(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::StorageLensConfiguration, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::StorageLensConfiguration::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Id") /* Id com.amazonaws.s3control#StorageLensConfiguration$Id */ =>  {
                let var_114 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_id(var_114);
            }
            ,
            s if s.matches("AccountLevel") /* AccountLevel com.amazonaws.s3control#StorageLensConfiguration$AccountLevel */ =>  {
                let var_115 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_account_level(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_account_level(var_115);
            }
            ,
            s if s.matches("Include") /* Include com.amazonaws.s3control#StorageLensConfiguration$Include */ =>  {
                let var_116 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_include(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_include(var_116);
            }
            ,
            s if s.matches("Exclude") /* Exclude com.amazonaws.s3control#StorageLensConfiguration$Exclude */ =>  {
                let var_117 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_exclude(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_exclude(var_117);
            }
            ,
            s if s.matches("DataExport") /* DataExport com.amazonaws.s3control#StorageLensConfiguration$DataExport */ =>  {
                let var_118 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_storage_lens_data_export(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_data_export(var_118);
            }
            ,
            s if s.matches("IsEnabled") /* IsEnabled com.amazonaws.s3control#StorageLensConfiguration$IsEnabled */ =>  {
                let var_119 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3control#IsEnabled`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_enabled(var_119);
            }
            ,
            s if s.matches("AwsOrg") /* AwsOrg com.amazonaws.s3control#StorageLensConfiguration$AwsOrg */ =>  {
                let var_120 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_storage_lens_aws_org(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_aws_org(var_120);
            }
            ,
            s if s.matches("StorageLensArn") /* StorageLensArn com.amazonaws.s3control#StorageLensConfiguration$StorageLensArn */ =>  {
                let var_121 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_storage_lens_arn(var_121);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_job_manifest(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::JobManifest, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::JobManifest::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Spec") /* Spec com.amazonaws.s3control#JobManifest$Spec */ =>  {
                let var_122 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_job_manifest_spec(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_spec(var_122);
            }
            ,
            s if s.matches("Location") /* Location com.amazonaws.s3control#JobManifest$Location */ =>  {
                let var_123 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_job_manifest_location(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_location(var_123);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_job_operation(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::JobOperation, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::JobOperation::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("LambdaInvoke") /* LambdaInvoke com.amazonaws.s3control#JobOperation$LambdaInvoke */ =>  {
                let var_124 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_lambda_invoke_operation(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_lambda_invoke(var_124);
            }
            ,
            s if s.matches("S3PutObjectCopy") /* S3PutObjectCopy com.amazonaws.s3control#JobOperation$S3PutObjectCopy */ =>  {
                let var_125 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_s3_copy_object_operation(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_s3_put_object_copy(var_125);
            }
            ,
            s if s.matches("S3PutObjectAcl") /* S3PutObjectAcl com.amazonaws.s3control#JobOperation$S3PutObjectAcl */ =>  {
                let var_126 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_s3_set_object_acl_operation(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_s3_put_object_acl(var_126);
            }
            ,
            s if s.matches("S3PutObjectTagging") /* S3PutObjectTagging com.amazonaws.s3control#JobOperation$S3PutObjectTagging */ =>  {
                let var_127 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_s3_set_object_tagging_operation(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_s3_put_object_tagging(var_127);
            }
            ,
            s if s.matches("S3DeleteObjectTagging") /* S3DeleteObjectTagging com.amazonaws.s3control#JobOperation$S3DeleteObjectTagging */ =>  {
                let var_128 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_s3_delete_object_tagging_operation(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_s3_delete_object_tagging(var_128);
            }
            ,
            s if s.matches("S3InitiateRestoreObject") /* S3InitiateRestoreObject com.amazonaws.s3control#JobOperation$S3InitiateRestoreObject */ =>  {
                let var_129 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_s3_initiate_restore_object_operation(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_s3_initiate_restore_object(var_129);
            }
            ,
            s if s.matches("S3PutObjectLegalHold") /* S3PutObjectLegalHold com.amazonaws.s3control#JobOperation$S3PutObjectLegalHold */ =>  {
                let var_130 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_s3_set_object_legal_hold_operation(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_s3_put_object_legal_hold(var_130);
            }
            ,
            s if s.matches("S3PutObjectRetention") /* S3PutObjectRetention com.amazonaws.s3control#JobOperation$S3PutObjectRetention */ =>  {
                let var_131 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_s3_set_object_retention_operation(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_s3_put_object_retention(var_131);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_job_progress_summary(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::JobProgressSummary, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::JobProgressSummary::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("TotalNumberOfTasks") /* TotalNumberOfTasks com.amazonaws.s3control#JobProgressSummary$TotalNumberOfTasks */ =>  {
                let var_132 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.s3control#JobTotalNumberOfTasks`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_total_number_of_tasks(var_132);
            }
            ,
            s if s.matches("NumberOfTasksSucceeded") /* NumberOfTasksSucceeded com.amazonaws.s3control#JobProgressSummary$NumberOfTasksSucceeded */ =>  {
                let var_133 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.s3control#JobNumberOfTasksSucceeded`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_number_of_tasks_succeeded(var_133);
            }
            ,
            s if s.matches("NumberOfTasksFailed") /* NumberOfTasksFailed com.amazonaws.s3control#JobProgressSummary$NumberOfTasksFailed */ =>  {
                let var_134 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.s3control#JobNumberOfTasksFailed`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_number_of_tasks_failed(var_134);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_s3control_job_failure_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::JobFailure>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.s3control#JobFailureList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_job_failure(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_job_report(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::JobReport, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::JobReport::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Bucket") /* Bucket com.amazonaws.s3control#JobReport$Bucket */ =>  {
                let var_135 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_bucket(var_135);
            }
            ,
            s if s.matches("Format") /* Format com.amazonaws.s3control#JobReport$Format */ =>  {
                let var_136 =
                    Some(
                        Result::<crate::model::JobReportFormat, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::JobReportFormat::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_format(var_136);
            }
            ,
            s if s.matches("Enabled") /* Enabled com.amazonaws.s3control#JobReport$Enabled */ =>  {
                let var_137 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3control#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_enabled(var_137);
            }
            ,
            s if s.matches("Prefix") /* Prefix com.amazonaws.s3control#JobReport$Prefix */ =>  {
                let var_138 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_prefix(var_138);
            }
            ,
            s if s.matches("ReportScope") /* ReportScope com.amazonaws.s3control#JobReport$ReportScope */ =>  {
                let var_139 =
                    Some(
                        Result::<crate::model::JobReportScope, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::JobReportScope::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_report_scope(var_139);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_async_request_parameters(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AsyncRequestParameters, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AsyncRequestParameters::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("CreateMultiRegionAccessPointRequest") /* CreateMultiRegionAccessPointRequest com.amazonaws.s3control#AsyncRequestParameters$CreateMultiRegionAccessPointRequest */ =>  {
                let var_140 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_create_multi_region_access_point_input(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_create_multi_region_access_point_request(var_140);
            }
            ,
            s if s.matches("DeleteMultiRegionAccessPointRequest") /* DeleteMultiRegionAccessPointRequest com.amazonaws.s3control#AsyncRequestParameters$DeleteMultiRegionAccessPointRequest */ =>  {
                let var_141 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_delete_multi_region_access_point_input(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_delete_multi_region_access_point_request(var_141);
            }
            ,
            s if s.matches("PutMultiRegionAccessPointPolicyRequest") /* PutMultiRegionAccessPointPolicyRequest com.amazonaws.s3control#AsyncRequestParameters$PutMultiRegionAccessPointPolicyRequest */ =>  {
                let var_142 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_put_multi_region_access_point_policy_input(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_put_multi_region_access_point_policy_request(var_142);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_async_response_details(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AsyncResponseDetails, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AsyncResponseDetails::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("MultiRegionAccessPointDetails") /* MultiRegionAccessPointDetails com.amazonaws.s3control#AsyncResponseDetails$MultiRegionAccessPointDetails */ =>  {
                let var_143 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_multi_region_access_points_async_response(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_multi_region_access_point_details(var_143);
            }
            ,
            s if s.matches("ErrorDetails") /* ErrorDetails com.amazonaws.s3control#AsyncResponseDetails$ErrorDetails */ =>  {
                let var_144 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_async_error_details(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_error_details(var_144);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_map_com_amazonaws_s3control_endpoints_entry(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
    out: &mut std::collections::HashMap<std::string::String, std::string::String>,
) -> Result<(), aws_smithy_xml::decode::XmlError> {
    let mut k: Option<std::string::String> = None;
    let mut v: Option<std::string::String> = None;
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("key") /* key com.amazonaws.s3control#Endpoints$key */ =>  {
                k = Some(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                )
            }
            ,
            s if s.matches("value") /* value com.amazonaws.s3control#Endpoints$value */ =>  {
                v = Some(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                )
            }
            ,
            _ => {}
        }
    }
    let k = k.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing key map entry"))?;
    let v = v.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing value map entry"))?;
    out.insert(k, v);
    Ok(())
}

pub fn deser_list_com_amazonaws_s3control_object_lambda_allowed_features_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::ObjectLambdaAllowedFeature>, aws_smithy_xml::decode::XmlError>
{
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("AllowedFeature") /* member com.amazonaws.s3control#ObjectLambdaAllowedFeaturesList$member */ =>  {
                out.push(
                    Result::<crate::model::ObjectLambdaAllowedFeature, aws_smithy_xml::decode::XmlError>::Ok(
                        crate::model::ObjectLambdaAllowedFeature::from(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        )
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_s3control_object_lambda_transformation_configurations_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::vec::Vec<crate::model::ObjectLambdaTransformationConfiguration>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("TransformationConfiguration") /* member com.amazonaws.s3control#ObjectLambdaTransformationConfigurationsList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_object_lambda_transformation_configuration(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_lifecycle_rule(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::LifecycleRule, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::LifecycleRule::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Expiration") /* Expiration com.amazonaws.s3control#LifecycleRule$Expiration */ =>  {
                let var_145 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_lifecycle_expiration(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_expiration(var_145);
            }
            ,
            s if s.matches("ID") /* ID com.amazonaws.s3control#LifecycleRule$ID */ =>  {
                let var_146 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_id(var_146);
            }
            ,
            s if s.matches("Filter") /* Filter com.amazonaws.s3control#LifecycleRule$Filter */ =>  {
                let var_147 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_lifecycle_rule_filter(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_filter(var_147);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.s3control#LifecycleRule$Status */ =>  {
                let var_148 =
                    Some(
                        Result::<crate::model::ExpirationStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ExpirationStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_148);
            }
            ,
            s if s.matches("Transitions") /* Transitions com.amazonaws.s3control#LifecycleRule$Transitions */ =>  {
                let var_149 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3control_transition_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_transitions(var_149);
            }
            ,
            s if s.matches("NoncurrentVersionTransitions") /* NoncurrentVersionTransitions com.amazonaws.s3control#LifecycleRule$NoncurrentVersionTransitions */ =>  {
                let var_150 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3control_noncurrent_version_transition_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_noncurrent_version_transitions(var_150);
            }
            ,
            s if s.matches("NoncurrentVersionExpiration") /* NoncurrentVersionExpiration com.amazonaws.s3control#LifecycleRule$NoncurrentVersionExpiration */ =>  {
                let var_151 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_noncurrent_version_expiration(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_noncurrent_version_expiration(var_151);
            }
            ,
            s if s.matches("AbortIncompleteMultipartUpload") /* AbortIncompleteMultipartUpload com.amazonaws.s3control#LifecycleRule$AbortIncompleteMultipartUpload */ =>  {
                let var_152 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_abort_incomplete_multipart_upload(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_abort_incomplete_multipart_upload(var_152);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_s3_tag(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::S3Tag, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::S3Tag::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Key") /* Key com.amazonaws.s3control#S3Tag$Key */ =>  {
                let var_153 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key(var_153);
            }
            ,
            s if s.matches("Value") /* Value com.amazonaws.s3control#S3Tag$Value */ =>  {
                let var_154 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_value(var_154);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_s3control_region_report_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::RegionReport>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Region") /* member com.amazonaws.s3control#RegionReportList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_region_report(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_established_multi_region_access_point_policy(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::EstablishedMultiRegionAccessPointPolicy, aws_smithy_xml::decode::XmlError>
{
    #[allow(unused_mut)]
    let mut builder = crate::model::EstablishedMultiRegionAccessPointPolicy::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Policy") /* Policy com.amazonaws.s3control#EstablishedMultiRegionAccessPointPolicy$Policy */ =>  {
                let var_155 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_policy(var_155);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_proposed_multi_region_access_point_policy(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ProposedMultiRegionAccessPointPolicy, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ProposedMultiRegionAccessPointPolicy::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Policy") /* Policy com.amazonaws.s3control#ProposedMultiRegionAccessPointPolicy$Policy */ =>  {
                let var_156 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_policy(var_156);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_storage_lens_tag(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::StorageLensTag, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::StorageLensTag::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Key") /* Key com.amazonaws.s3control#StorageLensTag$Key */ =>  {
                let var_157 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key(var_157);
            }
            ,
            s if s.matches("Value") /* Value com.amazonaws.s3control#StorageLensTag$Value */ =>  {
                let var_158 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_value(var_158);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_access_point(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AccessPoint, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AccessPoint::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* Name com.amazonaws.s3control#AccessPoint$Name */ =>  {
                let var_159 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_159);
            }
            ,
            s if s.matches("NetworkOrigin") /* NetworkOrigin com.amazonaws.s3control#AccessPoint$NetworkOrigin */ =>  {
                let var_160 =
                    Some(
                        Result::<crate::model::NetworkOrigin, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::NetworkOrigin::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_network_origin(var_160);
            }
            ,
            s if s.matches("VpcConfiguration") /* VpcConfiguration com.amazonaws.s3control#AccessPoint$VpcConfiguration */ =>  {
                let var_161 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_vpc_configuration(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_vpc_configuration(var_161);
            }
            ,
            s if s.matches("Bucket") /* Bucket com.amazonaws.s3control#AccessPoint$Bucket */ =>  {
                let var_162 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_bucket(var_162);
            }
            ,
            s if s.matches("AccessPointArn") /* AccessPointArn com.amazonaws.s3control#AccessPoint$AccessPointArn */ =>  {
                let var_163 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_access_point_arn(var_163);
            }
            ,
            s if s.matches("Alias") /* Alias com.amazonaws.s3control#AccessPoint$Alias */ =>  {
                let var_164 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_alias(var_164);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_object_lambda_access_point(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ObjectLambdaAccessPoint, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ObjectLambdaAccessPoint::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* Name com.amazonaws.s3control#ObjectLambdaAccessPoint$Name */ =>  {
                let var_165 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_165);
            }
            ,
            s if s.matches("ObjectLambdaAccessPointArn") /* ObjectLambdaAccessPointArn com.amazonaws.s3control#ObjectLambdaAccessPoint$ObjectLambdaAccessPointArn */ =>  {
                let var_166 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_object_lambda_access_point_arn(var_166);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_job_list_descriptor(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::JobListDescriptor, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::JobListDescriptor::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("JobId") /* JobId com.amazonaws.s3control#JobListDescriptor$JobId */ =>  {
                let var_167 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_job_id(var_167);
            }
            ,
            s if s.matches("Description") /* Description com.amazonaws.s3control#JobListDescriptor$Description */ =>  {
                let var_168 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_168);
            }
            ,
            s if s.matches("Operation") /* Operation com.amazonaws.s3control#JobListDescriptor$Operation */ =>  {
                let var_169 =
                    Some(
                        Result::<crate::model::OperationName, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::OperationName::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_operation(var_169);
            }
            ,
            s if s.matches("Priority") /* Priority com.amazonaws.s3control#JobListDescriptor$Priority */ =>  {
                let var_170 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3control#JobPriority`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_priority(var_170);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.s3control#JobListDescriptor$Status */ =>  {
                let var_171 =
                    Some(
                        Result::<crate::model::JobStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::JobStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_171);
            }
            ,
            s if s.matches("CreationTime") /* CreationTime com.amazonaws.s3control#JobListDescriptor$CreationTime */ =>  {
                let var_172 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.s3control#JobCreationTime`)"))
                        ?
                    )
                ;
                builder = builder.set_creation_time(var_172);
            }
            ,
            s if s.matches("TerminationDate") /* TerminationDate com.amazonaws.s3control#JobListDescriptor$TerminationDate */ =>  {
                let var_173 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.s3control#JobTerminationDate`)"))
                        ?
                    )
                ;
                builder = builder.set_termination_date(var_173);
            }
            ,
            s if s.matches("ProgressSummary") /* ProgressSummary com.amazonaws.s3control#JobListDescriptor$ProgressSummary */ =>  {
                let var_174 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_job_progress_summary(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_progress_summary(var_174);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_regional_bucket(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::RegionalBucket, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::RegionalBucket::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Bucket") /* Bucket com.amazonaws.s3control#RegionalBucket$Bucket */ =>  {
                let var_175 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_bucket(var_175);
            }
            ,
            s if s.matches("BucketArn") /* BucketArn com.amazonaws.s3control#RegionalBucket$BucketArn */ =>  {
                let var_176 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_bucket_arn(var_176);
            }
            ,
            s if s.matches("PublicAccessBlockEnabled") /* PublicAccessBlockEnabled com.amazonaws.s3control#RegionalBucket$PublicAccessBlockEnabled */ =>  {
                let var_177 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3control#PublicAccessBlockEnabled`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_public_access_block_enabled(var_177);
            }
            ,
            s if s.matches("CreationDate") /* CreationDate com.amazonaws.s3control#RegionalBucket$CreationDate */ =>  {
                let var_178 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.s3control#CreationDate`)"))
                        ?
                    )
                ;
                builder = builder.set_creation_date(var_178);
            }
            ,
            s if s.matches("OutpostId") /* OutpostId com.amazonaws.s3control#RegionalBucket$OutpostId */ =>  {
                let var_179 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_outpost_id(var_179);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_account_level(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AccountLevel, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AccountLevel::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ActivityMetrics") /* ActivityMetrics com.amazonaws.s3control#AccountLevel$ActivityMetrics */ =>  {
                let var_180 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_activity_metrics(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_activity_metrics(var_180);
            }
            ,
            s if s.matches("BucketLevel") /* BucketLevel com.amazonaws.s3control#AccountLevel$BucketLevel */ =>  {
                let var_181 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_bucket_level(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_bucket_level(var_181);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_include(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Include, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Include::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Buckets") /* Buckets com.amazonaws.s3control#Include$Buckets */ =>  {
                let var_182 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3control_buckets(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_buckets(var_182);
            }
            ,
            s if s.matches("Regions") /* Regions com.amazonaws.s3control#Include$Regions */ =>  {
                let var_183 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3control_regions(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_regions(var_183);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_exclude(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Exclude, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Exclude::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Buckets") /* Buckets com.amazonaws.s3control#Exclude$Buckets */ =>  {
                let var_184 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3control_buckets(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_buckets(var_184);
            }
            ,
            s if s.matches("Regions") /* Regions com.amazonaws.s3control#Exclude$Regions */ =>  {
                let var_185 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3control_regions(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_regions(var_185);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_storage_lens_data_export(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::StorageLensDataExport, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::StorageLensDataExport::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("S3BucketDestination") /* S3BucketDestination com.amazonaws.s3control#StorageLensDataExport$S3BucketDestination */ =>  {
                let var_186 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_s3_bucket_destination(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_s3_bucket_destination(var_186);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_storage_lens_aws_org(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::StorageLensAwsOrg, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::StorageLensAwsOrg::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Arn") /* Arn com.amazonaws.s3control#StorageLensAwsOrg$Arn */ =>  {
                let var_187 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_arn(var_187);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_job_manifest_spec(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::JobManifestSpec, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::JobManifestSpec::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Format") /* Format com.amazonaws.s3control#JobManifestSpec$Format */ =>  {
                let var_188 =
                    Some(
                        Result::<crate::model::JobManifestFormat, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::JobManifestFormat::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_format(var_188);
            }
            ,
            s if s.matches("Fields") /* Fields com.amazonaws.s3control#JobManifestSpec$Fields */ =>  {
                let var_189 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3control_job_manifest_field_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_fields(var_189);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_job_manifest_location(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::JobManifestLocation, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::JobManifestLocation::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ObjectArn") /* ObjectArn com.amazonaws.s3control#JobManifestLocation$ObjectArn */ =>  {
                let var_190 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_object_arn(var_190);
            }
            ,
            s if s.matches("ObjectVersionId") /* ObjectVersionId com.amazonaws.s3control#JobManifestLocation$ObjectVersionId */ =>  {
                let var_191 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_object_version_id(var_191);
            }
            ,
            s if s.matches("ETag") /* ETag com.amazonaws.s3control#JobManifestLocation$ETag */ =>  {
                let var_192 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_e_tag(var_192);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_lambda_invoke_operation(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::LambdaInvokeOperation, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::LambdaInvokeOperation::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("FunctionArn") /* FunctionArn com.amazonaws.s3control#LambdaInvokeOperation$FunctionArn */ =>  {
                let var_193 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_function_arn(var_193);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_s3_copy_object_operation(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::S3CopyObjectOperation, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::S3CopyObjectOperation::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("TargetResource") /* TargetResource com.amazonaws.s3control#S3CopyObjectOperation$TargetResource */ =>  {
                let var_194 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_target_resource(var_194);
            }
            ,
            s if s.matches("CannedAccessControlList") /* CannedAccessControlList com.amazonaws.s3control#S3CopyObjectOperation$CannedAccessControlList */ =>  {
                let var_195 =
                    Some(
                        Result::<crate::model::S3CannedAccessControlList, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::S3CannedAccessControlList::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_canned_access_control_list(var_195);
            }
            ,
            s if s.matches("AccessControlGrants") /* AccessControlGrants com.amazonaws.s3control#S3CopyObjectOperation$AccessControlGrants */ =>  {
                let var_196 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3control_s3_grant_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_access_control_grants(var_196);
            }
            ,
            s if s.matches("MetadataDirective") /* MetadataDirective com.amazonaws.s3control#S3CopyObjectOperation$MetadataDirective */ =>  {
                let var_197 =
                    Some(
                        Result::<crate::model::S3MetadataDirective, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::S3MetadataDirective::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_metadata_directive(var_197);
            }
            ,
            s if s.matches("ModifiedSinceConstraint") /* ModifiedSinceConstraint com.amazonaws.s3control#S3CopyObjectOperation$ModifiedSinceConstraint */ =>  {
                let var_198 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.s3control#TimeStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_modified_since_constraint(var_198);
            }
            ,
            s if s.matches("NewObjectMetadata") /* NewObjectMetadata com.amazonaws.s3control#S3CopyObjectOperation$NewObjectMetadata */ =>  {
                let var_199 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_s3_object_metadata(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_new_object_metadata(var_199);
            }
            ,
            s if s.matches("NewObjectTagging") /* NewObjectTagging com.amazonaws.s3control#S3CopyObjectOperation$NewObjectTagging */ =>  {
                let var_200 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3control_s3_tag_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_new_object_tagging(var_200);
            }
            ,
            s if s.matches("RedirectLocation") /* RedirectLocation com.amazonaws.s3control#S3CopyObjectOperation$RedirectLocation */ =>  {
                let var_201 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_redirect_location(var_201);
            }
            ,
            s if s.matches("RequesterPays") /* RequesterPays com.amazonaws.s3control#S3CopyObjectOperation$RequesterPays */ =>  {
                let var_202 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3control#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_requester_pays(var_202);
            }
            ,
            s if s.matches("StorageClass") /* StorageClass com.amazonaws.s3control#S3CopyObjectOperation$StorageClass */ =>  {
                let var_203 =
                    Some(
                        Result::<crate::model::S3StorageClass, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::S3StorageClass::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_storage_class(var_203);
            }
            ,
            s if s.matches("UnModifiedSinceConstraint") /* UnModifiedSinceConstraint com.amazonaws.s3control#S3CopyObjectOperation$UnModifiedSinceConstraint */ =>  {
                let var_204 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.s3control#TimeStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_un_modified_since_constraint(var_204);
            }
            ,
            s if s.matches("SSEAwsKmsKeyId") /* SSEAwsKmsKeyId com.amazonaws.s3control#S3CopyObjectOperation$SSEAwsKmsKeyId */ =>  {
                let var_205 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_sse_aws_kms_key_id(var_205);
            }
            ,
            s if s.matches("TargetKeyPrefix") /* TargetKeyPrefix com.amazonaws.s3control#S3CopyObjectOperation$TargetKeyPrefix */ =>  {
                let var_206 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_target_key_prefix(var_206);
            }
            ,
            s if s.matches("ObjectLockLegalHoldStatus") /* ObjectLockLegalHoldStatus com.amazonaws.s3control#S3CopyObjectOperation$ObjectLockLegalHoldStatus */ =>  {
                let var_207 =
                    Some(
                        Result::<crate::model::S3ObjectLockLegalHoldStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::S3ObjectLockLegalHoldStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_object_lock_legal_hold_status(var_207);
            }
            ,
            s if s.matches("ObjectLockMode") /* ObjectLockMode com.amazonaws.s3control#S3CopyObjectOperation$ObjectLockMode */ =>  {
                let var_208 =
                    Some(
                        Result::<crate::model::S3ObjectLockMode, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::S3ObjectLockMode::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_object_lock_mode(var_208);
            }
            ,
            s if s.matches("ObjectLockRetainUntilDate") /* ObjectLockRetainUntilDate com.amazonaws.s3control#S3CopyObjectOperation$ObjectLockRetainUntilDate */ =>  {
                let var_209 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.s3control#TimeStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_object_lock_retain_until_date(var_209);
            }
            ,
            s if s.matches("BucketKeyEnabled") /* BucketKeyEnabled com.amazonaws.s3control#S3CopyObjectOperation$BucketKeyEnabled */ =>  {
                let var_210 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3control#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_bucket_key_enabled(var_210);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_s3_set_object_acl_operation(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::S3SetObjectAclOperation, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::S3SetObjectAclOperation::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("AccessControlPolicy") /* AccessControlPolicy com.amazonaws.s3control#S3SetObjectAclOperation$AccessControlPolicy */ =>  {
                let var_211 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_s3_access_control_policy(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_access_control_policy(var_211);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_s3_set_object_tagging_operation(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::S3SetObjectTaggingOperation, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::S3SetObjectTaggingOperation::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("TagSet") /* TagSet com.amazonaws.s3control#S3SetObjectTaggingOperation$TagSet */ =>  {
                let var_212 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3control_s3_tag_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tag_set(var_212);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_s3_delete_object_tagging_operation(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::S3DeleteObjectTaggingOperation, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::S3DeleteObjectTaggingOperation::builder();
    let _ = decoder;
    Ok(builder.build())
}

pub fn deser_structure_crate_model_s3_initiate_restore_object_operation(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::S3InitiateRestoreObjectOperation, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::S3InitiateRestoreObjectOperation::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ExpirationInDays") /* ExpirationInDays com.amazonaws.s3control#S3InitiateRestoreObjectOperation$ExpirationInDays */ =>  {
                let var_213 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3control#S3ExpirationInDays`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_expiration_in_days(var_213);
            }
            ,
            s if s.matches("GlacierJobTier") /* GlacierJobTier com.amazonaws.s3control#S3InitiateRestoreObjectOperation$GlacierJobTier */ =>  {
                let var_214 =
                    Some(
                        Result::<crate::model::S3GlacierJobTier, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::S3GlacierJobTier::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_glacier_job_tier(var_214);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_s3_set_object_legal_hold_operation(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::S3SetObjectLegalHoldOperation, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::S3SetObjectLegalHoldOperation::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("LegalHold") /* LegalHold com.amazonaws.s3control#S3SetObjectLegalHoldOperation$LegalHold */ =>  {
                let var_215 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_s3_object_lock_legal_hold(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_legal_hold(var_215);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_s3_set_object_retention_operation(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::S3SetObjectRetentionOperation, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::S3SetObjectRetentionOperation::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("BypassGovernanceRetention") /* BypassGovernanceRetention com.amazonaws.s3control#S3SetObjectRetentionOperation$BypassGovernanceRetention */ =>  {
                let var_216 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3control#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_bypass_governance_retention(var_216);
            }
            ,
            s if s.matches("Retention") /* Retention com.amazonaws.s3control#S3SetObjectRetentionOperation$Retention */ =>  {
                let var_217 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_s3_retention(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_retention(var_217);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_job_failure(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::JobFailure, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::JobFailure::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("FailureCode") /* FailureCode com.amazonaws.s3control#JobFailure$FailureCode */ =>  {
                let var_218 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_failure_code(var_218);
            }
            ,
            s if s.matches("FailureReason") /* FailureReason com.amazonaws.s3control#JobFailure$FailureReason */ =>  {
                let var_219 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_failure_reason(var_219);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_create_multi_region_access_point_input(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::CreateMultiRegionAccessPointInput, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::CreateMultiRegionAccessPointInput::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* Name com.amazonaws.s3control#CreateMultiRegionAccessPointInput$Name */ =>  {
                let var_220 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_220);
            }
            ,
            s if s.matches("PublicAccessBlock") /* PublicAccessBlock com.amazonaws.s3control#CreateMultiRegionAccessPointInput$PublicAccessBlock */ =>  {
                let var_221 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_public_access_block_configuration(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_public_access_block(var_221);
            }
            ,
            s if s.matches("Regions") /* Regions com.amazonaws.s3control#CreateMultiRegionAccessPointInput$Regions */ =>  {
                let var_222 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3control_region_creation_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_regions(var_222);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_delete_multi_region_access_point_input(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::DeleteMultiRegionAccessPointInput, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::DeleteMultiRegionAccessPointInput::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* Name com.amazonaws.s3control#DeleteMultiRegionAccessPointInput$Name */ =>  {
                let var_223 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_223);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_put_multi_region_access_point_policy_input(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::PutMultiRegionAccessPointPolicyInput, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::PutMultiRegionAccessPointPolicyInput::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* Name com.amazonaws.s3control#PutMultiRegionAccessPointPolicyInput$Name */ =>  {
                let var_224 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_224);
            }
            ,
            s if s.matches("Policy") /* Policy com.amazonaws.s3control#PutMultiRegionAccessPointPolicyInput$Policy */ =>  {
                let var_225 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_policy(var_225);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_multi_region_access_points_async_response(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::MultiRegionAccessPointsAsyncResponse, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::MultiRegionAccessPointsAsyncResponse::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Regions") /* Regions com.amazonaws.s3control#MultiRegionAccessPointsAsyncResponse$Regions */ =>  {
                let var_226 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3control_multi_region_access_point_regional_response_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_regions(var_226);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_async_error_details(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AsyncErrorDetails, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AsyncErrorDetails::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Code") /* Code com.amazonaws.s3control#AsyncErrorDetails$Code */ =>  {
                let var_227 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_code(var_227);
            }
            ,
            s if s.matches("Message") /* Message com.amazonaws.s3control#AsyncErrorDetails$Message */ =>  {
                let var_228 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_228);
            }
            ,
            s if s.matches("Resource") /* Resource com.amazonaws.s3control#AsyncErrorDetails$Resource */ =>  {
                let var_229 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_resource(var_229);
            }
            ,
            s if s.matches("RequestId") /* RequestId com.amazonaws.s3control#AsyncErrorDetails$RequestId */ =>  {
                let var_230 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_request_id(var_230);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_object_lambda_transformation_configuration(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ObjectLambdaTransformationConfiguration, aws_smithy_xml::decode::XmlError>
{
    #[allow(unused_mut)]
    let mut builder = crate::model::ObjectLambdaTransformationConfiguration::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Actions") /* Actions com.amazonaws.s3control#ObjectLambdaTransformationConfiguration$Actions */ =>  {
                let var_231 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3control_object_lambda_transformation_configuration_actions_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_actions(var_231);
            }
            ,
            s if s.matches("ContentTransformation") /* ContentTransformation com.amazonaws.s3control#ObjectLambdaTransformationConfiguration$ContentTransformation */ =>  {
                let var_232 =
                    Some(
                        crate::xml_deser::deser_union_crate_model_object_lambda_content_transformation(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_content_transformation(var_232);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_lifecycle_expiration(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::LifecycleExpiration, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::LifecycleExpiration::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Date") /* Date com.amazonaws.s3control#LifecycleExpiration$Date */ =>  {
                let var_233 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.s3control#Date`)"))
                        ?
                    )
                ;
                builder = builder.set_date(var_233);
            }
            ,
            s if s.matches("Days") /* Days com.amazonaws.s3control#LifecycleExpiration$Days */ =>  {
                let var_234 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3control#Days`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_days(var_234);
            }
            ,
            s if s.matches("ExpiredObjectDeleteMarker") /* ExpiredObjectDeleteMarker com.amazonaws.s3control#LifecycleExpiration$ExpiredObjectDeleteMarker */ =>  {
                let var_235 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3control#ExpiredObjectDeleteMarker`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_expired_object_delete_marker(var_235);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_lifecycle_rule_filter(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::LifecycleRuleFilter, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::LifecycleRuleFilter::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Prefix") /* Prefix com.amazonaws.s3control#LifecycleRuleFilter$Prefix */ =>  {
                let var_236 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_prefix(var_236);
            }
            ,
            s if s.matches("Tag") /* Tag com.amazonaws.s3control#LifecycleRuleFilter$Tag */ =>  {
                let var_237 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_s3_tag(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tag(var_237);
            }
            ,
            s if s.matches("And") /* And com.amazonaws.s3control#LifecycleRuleFilter$And */ =>  {
                let var_238 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_lifecycle_rule_and_operator(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_and(var_238);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_s3control_transition_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::Transition>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Transition") /* member com.amazonaws.s3control#TransitionList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_transition(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_s3control_noncurrent_version_transition_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::vec::Vec<crate::model::NoncurrentVersionTransition>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("NoncurrentVersionTransition") /* member com.amazonaws.s3control#NoncurrentVersionTransitionList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_noncurrent_version_transition(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_noncurrent_version_expiration(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::NoncurrentVersionExpiration, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::NoncurrentVersionExpiration::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("NoncurrentDays") /* NoncurrentDays com.amazonaws.s3control#NoncurrentVersionExpiration$NoncurrentDays */ =>  {
                let var_239 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3control#Days`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_noncurrent_days(var_239);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_abort_incomplete_multipart_upload(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AbortIncompleteMultipartUpload, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AbortIncompleteMultipartUpload::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DaysAfterInitiation") /* DaysAfterInitiation com.amazonaws.s3control#AbortIncompleteMultipartUpload$DaysAfterInitiation */ =>  {
                let var_240 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3control#DaysAfterInitiation`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_days_after_initiation(var_240);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_region_report(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::RegionReport, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::RegionReport::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Bucket") /* Bucket com.amazonaws.s3control#RegionReport$Bucket */ =>  {
                let var_241 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_bucket(var_241);
            }
            ,
            s if s.matches("Region") /* Region com.amazonaws.s3control#RegionReport$Region */ =>  {
                let var_242 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_region(var_242);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_activity_metrics(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ActivityMetrics, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ActivityMetrics::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("IsEnabled") /* IsEnabled com.amazonaws.s3control#ActivityMetrics$IsEnabled */ =>  {
                let var_243 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3control#IsEnabled`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_enabled(var_243);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_bucket_level(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::BucketLevel, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::BucketLevel::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ActivityMetrics") /* ActivityMetrics com.amazonaws.s3control#BucketLevel$ActivityMetrics */ =>  {
                let var_244 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_activity_metrics(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_activity_metrics(var_244);
            }
            ,
            s if s.matches("PrefixLevel") /* PrefixLevel com.amazonaws.s3control#BucketLevel$PrefixLevel */ =>  {
                let var_245 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_prefix_level(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_prefix_level(var_245);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_s3control_buckets(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Arn") /* member com.amazonaws.s3control#Buckets$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_s3control_regions(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Region") /* member com.amazonaws.s3control#Regions$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_s3_bucket_destination(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::S3BucketDestination, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::S3BucketDestination::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Format") /* Format com.amazonaws.s3control#S3BucketDestination$Format */ =>  {
                let var_246 =
                    Some(
                        Result::<crate::model::Format, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::Format::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_format(var_246);
            }
            ,
            s if s.matches("OutputSchemaVersion") /* OutputSchemaVersion com.amazonaws.s3control#S3BucketDestination$OutputSchemaVersion */ =>  {
                let var_247 =
                    Some(
                        Result::<crate::model::OutputSchemaVersion, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::OutputSchemaVersion::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_output_schema_version(var_247);
            }
            ,
            s if s.matches("AccountId") /* AccountId com.amazonaws.s3control#S3BucketDestination$AccountId */ =>  {
                let var_248 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_account_id(var_248);
            }
            ,
            s if s.matches("Arn") /* Arn com.amazonaws.s3control#S3BucketDestination$Arn */ =>  {
                let var_249 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_arn(var_249);
            }
            ,
            s if s.matches("Prefix") /* Prefix com.amazonaws.s3control#S3BucketDestination$Prefix */ =>  {
                let var_250 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_prefix(var_250);
            }
            ,
            s if s.matches("Encryption") /* Encryption com.amazonaws.s3control#S3BucketDestination$Encryption */ =>  {
                let var_251 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_storage_lens_data_export_encryption(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_encryption(var_251);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_s3control_job_manifest_field_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::JobManifestFieldName>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.s3control#JobManifestFieldList$member */ =>  {
                out.push(
                    Result::<crate::model::JobManifestFieldName, aws_smithy_xml::decode::XmlError>::Ok(
                        crate::model::JobManifestFieldName::from(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        )
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_s3control_s3_grant_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::S3Grant>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.s3control#S3GrantList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_s3_grant(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_s3_object_metadata(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::S3ObjectMetadata, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::S3ObjectMetadata::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("CacheControl") /* CacheControl com.amazonaws.s3control#S3ObjectMetadata$CacheControl */ =>  {
                let var_252 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_cache_control(var_252);
            }
            ,
            s if s.matches("ContentDisposition") /* ContentDisposition com.amazonaws.s3control#S3ObjectMetadata$ContentDisposition */ =>  {
                let var_253 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_content_disposition(var_253);
            }
            ,
            s if s.matches("ContentEncoding") /* ContentEncoding com.amazonaws.s3control#S3ObjectMetadata$ContentEncoding */ =>  {
                let var_254 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_content_encoding(var_254);
            }
            ,
            s if s.matches("ContentLanguage") /* ContentLanguage com.amazonaws.s3control#S3ObjectMetadata$ContentLanguage */ =>  {
                let var_255 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_content_language(var_255);
            }
            ,
            s if s.matches("UserMetadata") /* UserMetadata com.amazonaws.s3control#S3ObjectMetadata$UserMetadata */ =>  {
                let var_256 =
                    Some(
                        crate::xml_deser::deser_map_com_amazonaws_s3control_s3_user_metadata(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_user_metadata(var_256);
            }
            ,
            s if s.matches("ContentLength") /* ContentLength com.amazonaws.s3control#S3ObjectMetadata$ContentLength */ =>  {
                let var_257 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.s3control#S3ContentLength`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_content_length(var_257);
            }
            ,
            s if s.matches("ContentMD5") /* ContentMD5 com.amazonaws.s3control#S3ObjectMetadata$ContentMD5 */ =>  {
                let var_258 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_content_md5(var_258);
            }
            ,
            s if s.matches("ContentType") /* ContentType com.amazonaws.s3control#S3ObjectMetadata$ContentType */ =>  {
                let var_259 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_content_type(var_259);
            }
            ,
            s if s.matches("HttpExpiresDate") /* HttpExpiresDate com.amazonaws.s3control#S3ObjectMetadata$HttpExpiresDate */ =>  {
                let var_260 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.s3control#TimeStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_http_expires_date(var_260);
            }
            ,
            s if s.matches("RequesterCharged") /* RequesterCharged com.amazonaws.s3control#S3ObjectMetadata$RequesterCharged */ =>  {
                let var_261 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3control#Boolean`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_requester_charged(var_261);
            }
            ,
            s if s.matches("SSEAlgorithm") /* SSEAlgorithm com.amazonaws.s3control#S3ObjectMetadata$SSEAlgorithm */ =>  {
                let var_262 =
                    Some(
                        Result::<crate::model::S3SseAlgorithm, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::S3SseAlgorithm::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_sse_algorithm(var_262);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_s3_access_control_policy(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::S3AccessControlPolicy, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::S3AccessControlPolicy::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("AccessControlList") /* AccessControlList com.amazonaws.s3control#S3AccessControlPolicy$AccessControlList */ =>  {
                let var_263 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_s3_access_control_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_access_control_list(var_263);
            }
            ,
            s if s.matches("CannedAccessControlList") /* CannedAccessControlList com.amazonaws.s3control#S3AccessControlPolicy$CannedAccessControlList */ =>  {
                let var_264 =
                    Some(
                        Result::<crate::model::S3CannedAccessControlList, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::S3CannedAccessControlList::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_canned_access_control_list(var_264);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_s3_object_lock_legal_hold(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::S3ObjectLockLegalHold, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::S3ObjectLockLegalHold::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Status") /* Status com.amazonaws.s3control#S3ObjectLockLegalHold$Status */ =>  {
                let var_265 =
                    Some(
                        Result::<crate::model::S3ObjectLockLegalHoldStatus, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::S3ObjectLockLegalHoldStatus::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_265);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_s3_retention(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::S3Retention, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::S3Retention::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("RetainUntilDate") /* RetainUntilDate com.amazonaws.s3control#S3Retention$RetainUntilDate */ =>  {
                let var_266 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.s3control#TimeStamp`)"))
                        ?
                    )
                ;
                builder = builder.set_retain_until_date(var_266);
            }
            ,
            s if s.matches("Mode") /* Mode com.amazonaws.s3control#S3Retention$Mode */ =>  {
                let var_267 =
                    Some(
                        Result::<crate::model::S3ObjectLockRetentionMode, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::S3ObjectLockRetentionMode::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_mode(var_267);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_s3control_region_creation_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::Region>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Region") /* member com.amazonaws.s3control#RegionCreationList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_region(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_s3control_multi_region_access_point_regional_response_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::vec::Vec<crate::model::MultiRegionAccessPointRegionalResponse>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Region") /* member com.amazonaws.s3control#MultiRegionAccessPointRegionalResponseList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_multi_region_access_point_regional_response(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_s3control_object_lambda_transformation_configuration_actions_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::vec::Vec<crate::model::ObjectLambdaTransformationConfigurationAction>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Action") /* member com.amazonaws.s3control#ObjectLambdaTransformationConfigurationActionsList$member */ =>  {
                out.push(
                    Result::<crate::model::ObjectLambdaTransformationConfigurationAction, aws_smithy_xml::decode::XmlError>::Ok(
                        crate::model::ObjectLambdaTransformationConfigurationAction::from(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        )
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_union_crate_model_object_lambda_content_transformation(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ObjectLambdaContentTransformation, aws_smithy_xml::decode::XmlError> {
    let mut base: Option<crate::model::ObjectLambdaContentTransformation> = None;
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("AwsLambda") /* AwsLambda com.amazonaws.s3control#ObjectLambdaContentTransformation$AwsLambda */ =>  {
                let tmp =
                    crate::xml_deser::deser_structure_crate_model_aws_lambda_transformation(&mut tag)
                    ?
                ;
                base = Some(crate::model::ObjectLambdaContentTransformation::AwsLambda(tmp));
            }
            ,
            _ => {}
        }
    }
    base.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("expected union, got nothing"))
}

pub fn deser_structure_crate_model_lifecycle_rule_and_operator(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::LifecycleRuleAndOperator, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::LifecycleRuleAndOperator::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Prefix") /* Prefix com.amazonaws.s3control#LifecycleRuleAndOperator$Prefix */ =>  {
                let var_268 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_prefix(var_268);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.s3control#LifecycleRuleAndOperator$Tags */ =>  {
                let var_269 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3control_s3_tag_set(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_269);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_transition(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Transition, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Transition::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Date") /* Date com.amazonaws.s3control#Transition$Date */ =>  {
                let var_270 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.s3control#Date`)"))
                        ?
                    )
                ;
                builder = builder.set_date(var_270);
            }
            ,
            s if s.matches("Days") /* Days com.amazonaws.s3control#Transition$Days */ =>  {
                let var_271 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3control#Days`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_days(var_271);
            }
            ,
            s if s.matches("StorageClass") /* StorageClass com.amazonaws.s3control#Transition$StorageClass */ =>  {
                let var_272 =
                    Some(
                        Result::<crate::model::TransitionStorageClass, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::TransitionStorageClass::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_storage_class(var_272);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_noncurrent_version_transition(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::NoncurrentVersionTransition, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::NoncurrentVersionTransition::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("NoncurrentDays") /* NoncurrentDays com.amazonaws.s3control#NoncurrentVersionTransition$NoncurrentDays */ =>  {
                let var_273 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3control#Days`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_noncurrent_days(var_273);
            }
            ,
            s if s.matches("StorageClass") /* StorageClass com.amazonaws.s3control#NoncurrentVersionTransition$StorageClass */ =>  {
                let var_274 =
                    Some(
                        Result::<crate::model::TransitionStorageClass, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::TransitionStorageClass::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_storage_class(var_274);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_prefix_level(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::PrefixLevel, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::PrefixLevel::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("StorageMetrics") /* StorageMetrics com.amazonaws.s3control#PrefixLevel$StorageMetrics */ =>  {
                let var_275 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_prefix_level_storage_metrics(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_storage_metrics(var_275);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_storage_lens_data_export_encryption(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::StorageLensDataExportEncryption, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::StorageLensDataExportEncryption::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("SSE-S3") /* SSES3 com.amazonaws.s3control#StorageLensDataExportEncryption$SSES3 */ =>  {
                let var_276 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_sses3(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_sses3(var_276);
            }
            ,
            s if s.matches("SSE-KMS") /* SSEKMS com.amazonaws.s3control#StorageLensDataExportEncryption$SSEKMS */ =>  {
                let var_277 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_ssekms(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ssekms(var_277);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_s3_grant(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::S3Grant, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::S3Grant::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Grantee") /* Grantee com.amazonaws.s3control#S3Grant$Grantee */ =>  {
                let var_278 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_s3_grantee(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_grantee(var_278);
            }
            ,
            s if s.matches("Permission") /* Permission com.amazonaws.s3control#S3Grant$Permission */ =>  {
                let var_279 =
                    Some(
                        Result::<crate::model::S3Permission, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::S3Permission::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_permission(var_279);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_map_com_amazonaws_s3control_s3_user_metadata(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::collections::HashMap<std::string::String, std::string::String>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::collections::HashMap::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("entry") => {
                crate::xml_deser::deser_map_com_amazonaws_s3control_s3_user_metadata_entry(
                    &mut tag, &mut out,
                )?;
            }
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_s3_access_control_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::S3AccessControlList, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::S3AccessControlList::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Owner") /* Owner com.amazonaws.s3control#S3AccessControlList$Owner */ =>  {
                let var_280 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_s3_object_owner(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_owner(var_280);
            }
            ,
            s if s.matches("Grants") /* Grants com.amazonaws.s3control#S3AccessControlList$Grants */ =>  {
                let var_281 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_s3control_s3_grant_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_grants(var_281);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_region(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Region, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Region::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Bucket") /* Bucket com.amazonaws.s3control#Region$Bucket */ =>  {
                let var_282 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_bucket(var_282);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_multi_region_access_point_regional_response(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::MultiRegionAccessPointRegionalResponse, aws_smithy_xml::decode::XmlError>
{
    #[allow(unused_mut)]
    let mut builder = crate::model::MultiRegionAccessPointRegionalResponse::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* Name com.amazonaws.s3control#MultiRegionAccessPointRegionalResponse$Name */ =>  {
                let var_283 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_283);
            }
            ,
            s if s.matches("RequestStatus") /* RequestStatus com.amazonaws.s3control#MultiRegionAccessPointRegionalResponse$RequestStatus */ =>  {
                let var_284 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_request_status(var_284);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_aws_lambda_transformation(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AwsLambdaTransformation, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AwsLambdaTransformation::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("FunctionArn") /* FunctionArn com.amazonaws.s3control#AwsLambdaTransformation$FunctionArn */ =>  {
                let var_285 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_function_arn(var_285);
            }
            ,
            s if s.matches("FunctionPayload") /* FunctionPayload com.amazonaws.s3control#AwsLambdaTransformation$FunctionPayload */ =>  {
                let var_286 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_function_payload(var_286);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_prefix_level_storage_metrics(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::PrefixLevelStorageMetrics, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::PrefixLevelStorageMetrics::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("IsEnabled") /* IsEnabled com.amazonaws.s3control#PrefixLevelStorageMetrics$IsEnabled */ =>  {
                let var_287 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.s3control#IsEnabled`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_enabled(var_287);
            }
            ,
            s if s.matches("SelectionCriteria") /* SelectionCriteria com.amazonaws.s3control#PrefixLevelStorageMetrics$SelectionCriteria */ =>  {
                let var_288 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_selection_criteria(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_selection_criteria(var_288);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_sses3(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Sses3, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Sses3::builder();
    let _ = decoder;
    Ok(builder.build())
}

pub fn deser_structure_crate_model_ssekms(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Ssekms, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Ssekms::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("KeyId") /* KeyId com.amazonaws.s3control#SSEKMS$KeyId */ =>  {
                let var_289 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key_id(var_289);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_s3_grantee(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::S3Grantee, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::S3Grantee::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("TypeIdentifier") /* TypeIdentifier com.amazonaws.s3control#S3Grantee$TypeIdentifier */ =>  {
                let var_290 =
                    Some(
                        Result::<crate::model::S3GranteeTypeIdentifier, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::S3GranteeTypeIdentifier::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_type_identifier(var_290);
            }
            ,
            s if s.matches("Identifier") /* Identifier com.amazonaws.s3control#S3Grantee$Identifier */ =>  {
                let var_291 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_identifier(var_291);
            }
            ,
            s if s.matches("DisplayName") /* DisplayName com.amazonaws.s3control#S3Grantee$DisplayName */ =>  {
                let var_292 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_display_name(var_292);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_map_com_amazonaws_s3control_s3_user_metadata_entry(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
    out: &mut std::collections::HashMap<std::string::String, std::string::String>,
) -> Result<(), aws_smithy_xml::decode::XmlError> {
    let mut k: Option<std::string::String> = None;
    let mut v: Option<std::string::String> = None;
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("key") /* key com.amazonaws.s3control#S3UserMetadata$key */ =>  {
                k = Some(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                )
            }
            ,
            s if s.matches("value") /* value com.amazonaws.s3control#S3UserMetadata$value */ =>  {
                v = Some(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                )
            }
            ,
            _ => {}
        }
    }
    let k = k.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing key map entry"))?;
    let v = v.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing value map entry"))?;
    out.insert(k, v);
    Ok(())
}

pub fn deser_structure_crate_model_s3_object_owner(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::S3ObjectOwner, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::S3ObjectOwner::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ID") /* ID com.amazonaws.s3control#S3ObjectOwner$ID */ =>  {
                let var_293 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_id(var_293);
            }
            ,
            s if s.matches("DisplayName") /* DisplayName com.amazonaws.s3control#S3ObjectOwner$DisplayName */ =>  {
                let var_294 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_display_name(var_294);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_selection_criteria(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::SelectionCriteria, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::SelectionCriteria::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Delimiter") /* Delimiter com.amazonaws.s3control#SelectionCriteria$Delimiter */ =>  {
                let var_295 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_delimiter(var_295);
            }
            ,
            s if s.matches("MaxDepth") /* MaxDepth com.amazonaws.s3control#SelectionCriteria$MaxDepth */ =>  {
                let var_296 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.s3control#StorageLensPrefixLevelMaxDepth`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_max_depth(var_296);
            }
            ,
            s if s.matches("MinStorageBytesPercentage") /* MinStorageBytesPercentage com.amazonaws.s3control#SelectionCriteria$MinStorageBytesPercentage */ =>  {
                let var_297 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.s3control#MinStorageBytesPercentage`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_min_storage_bytes_percentage(var_297);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}
