// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AWSS3ControlServiceV20180820`.
///
/// This client allows ergonomic access to a `AWSS3ControlServiceV20180820`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateAccessPoint` operation.
    ///
    /// See [`CreateAccessPoint`](crate::client::fluent_builders::CreateAccessPoint) for more information about the
    /// operation and its arguments.
    pub fn create_access_point(&self) -> fluent_builders::CreateAccessPoint<C, M, R> {
        fluent_builders::CreateAccessPoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAccessPointForObjectLambda` operation.
    ///
    /// See [`CreateAccessPointForObjectLambda`](crate::client::fluent_builders::CreateAccessPointForObjectLambda) for more information about the
    /// operation and its arguments.
    pub fn create_access_point_for_object_lambda(
        &self,
    ) -> fluent_builders::CreateAccessPointForObjectLambda<C, M, R> {
        fluent_builders::CreateAccessPointForObjectLambda::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBucket` operation.
    ///
    /// See [`CreateBucket`](crate::client::fluent_builders::CreateBucket) for more information about the
    /// operation and its arguments.
    pub fn create_bucket(&self) -> fluent_builders::CreateBucket<C, M, R> {
        fluent_builders::CreateBucket::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateJob` operation.
    ///
    /// See [`CreateJob`](crate::client::fluent_builders::CreateJob) for more information about the
    /// operation and its arguments.
    pub fn create_job(&self) -> fluent_builders::CreateJob<C, M, R> {
        fluent_builders::CreateJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateMultiRegionAccessPoint` operation.
    ///
    /// See [`CreateMultiRegionAccessPoint`](crate::client::fluent_builders::CreateMultiRegionAccessPoint) for more information about the
    /// operation and its arguments.
    pub fn create_multi_region_access_point(
        &self,
    ) -> fluent_builders::CreateMultiRegionAccessPoint<C, M, R> {
        fluent_builders::CreateMultiRegionAccessPoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAccessPoint` operation.
    ///
    /// See [`DeleteAccessPoint`](crate::client::fluent_builders::DeleteAccessPoint) for more information about the
    /// operation and its arguments.
    pub fn delete_access_point(&self) -> fluent_builders::DeleteAccessPoint<C, M, R> {
        fluent_builders::DeleteAccessPoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAccessPointForObjectLambda` operation.
    ///
    /// See [`DeleteAccessPointForObjectLambda`](crate::client::fluent_builders::DeleteAccessPointForObjectLambda) for more information about the
    /// operation and its arguments.
    pub fn delete_access_point_for_object_lambda(
        &self,
    ) -> fluent_builders::DeleteAccessPointForObjectLambda<C, M, R> {
        fluent_builders::DeleteAccessPointForObjectLambda::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAccessPointPolicy` operation.
    ///
    /// See [`DeleteAccessPointPolicy`](crate::client::fluent_builders::DeleteAccessPointPolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_access_point_policy(&self) -> fluent_builders::DeleteAccessPointPolicy<C, M, R> {
        fluent_builders::DeleteAccessPointPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAccessPointPolicyForObjectLambda` operation.
    ///
    /// See [`DeleteAccessPointPolicyForObjectLambda`](crate::client::fluent_builders::DeleteAccessPointPolicyForObjectLambda) for more information about the
    /// operation and its arguments.
    pub fn delete_access_point_policy_for_object_lambda(
        &self,
    ) -> fluent_builders::DeleteAccessPointPolicyForObjectLambda<C, M, R> {
        fluent_builders::DeleteAccessPointPolicyForObjectLambda::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBucket` operation.
    ///
    /// See [`DeleteBucket`](crate::client::fluent_builders::DeleteBucket) for more information about the
    /// operation and its arguments.
    pub fn delete_bucket(&self) -> fluent_builders::DeleteBucket<C, M, R> {
        fluent_builders::DeleteBucket::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBucketLifecycleConfiguration` operation.
    ///
    /// See [`DeleteBucketLifecycleConfiguration`](crate::client::fluent_builders::DeleteBucketLifecycleConfiguration) for more information about the
    /// operation and its arguments.
    pub fn delete_bucket_lifecycle_configuration(
        &self,
    ) -> fluent_builders::DeleteBucketLifecycleConfiguration<C, M, R> {
        fluent_builders::DeleteBucketLifecycleConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBucketPolicy` operation.
    ///
    /// See [`DeleteBucketPolicy`](crate::client::fluent_builders::DeleteBucketPolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_bucket_policy(&self) -> fluent_builders::DeleteBucketPolicy<C, M, R> {
        fluent_builders::DeleteBucketPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBucketTagging` operation.
    ///
    /// See [`DeleteBucketTagging`](crate::client::fluent_builders::DeleteBucketTagging) for more information about the
    /// operation and its arguments.
    pub fn delete_bucket_tagging(&self) -> fluent_builders::DeleteBucketTagging<C, M, R> {
        fluent_builders::DeleteBucketTagging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteJobTagging` operation.
    ///
    /// See [`DeleteJobTagging`](crate::client::fluent_builders::DeleteJobTagging) for more information about the
    /// operation and its arguments.
    pub fn delete_job_tagging(&self) -> fluent_builders::DeleteJobTagging<C, M, R> {
        fluent_builders::DeleteJobTagging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteMultiRegionAccessPoint` operation.
    ///
    /// See [`DeleteMultiRegionAccessPoint`](crate::client::fluent_builders::DeleteMultiRegionAccessPoint) for more information about the
    /// operation and its arguments.
    pub fn delete_multi_region_access_point(
        &self,
    ) -> fluent_builders::DeleteMultiRegionAccessPoint<C, M, R> {
        fluent_builders::DeleteMultiRegionAccessPoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePublicAccessBlock` operation.
    ///
    /// See [`DeletePublicAccessBlock`](crate::client::fluent_builders::DeletePublicAccessBlock) for more information about the
    /// operation and its arguments.
    pub fn delete_public_access_block(&self) -> fluent_builders::DeletePublicAccessBlock<C, M, R> {
        fluent_builders::DeletePublicAccessBlock::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteStorageLensConfiguration` operation.
    ///
    /// See [`DeleteStorageLensConfiguration`](crate::client::fluent_builders::DeleteStorageLensConfiguration) for more information about the
    /// operation and its arguments.
    pub fn delete_storage_lens_configuration(
        &self,
    ) -> fluent_builders::DeleteStorageLensConfiguration<C, M, R> {
        fluent_builders::DeleteStorageLensConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteStorageLensConfigurationTagging` operation.
    ///
    /// See [`DeleteStorageLensConfigurationTagging`](crate::client::fluent_builders::DeleteStorageLensConfigurationTagging) for more information about the
    /// operation and its arguments.
    pub fn delete_storage_lens_configuration_tagging(
        &self,
    ) -> fluent_builders::DeleteStorageLensConfigurationTagging<C, M, R> {
        fluent_builders::DeleteStorageLensConfigurationTagging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeJob` operation.
    ///
    /// See [`DescribeJob`](crate::client::fluent_builders::DescribeJob) for more information about the
    /// operation and its arguments.
    pub fn describe_job(&self) -> fluent_builders::DescribeJob<C, M, R> {
        fluent_builders::DescribeJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeMultiRegionAccessPointOperation` operation.
    ///
    /// See [`DescribeMultiRegionAccessPointOperation`](crate::client::fluent_builders::DescribeMultiRegionAccessPointOperation) for more information about the
    /// operation and its arguments.
    pub fn describe_multi_region_access_point_operation(
        &self,
    ) -> fluent_builders::DescribeMultiRegionAccessPointOperation<C, M, R> {
        fluent_builders::DescribeMultiRegionAccessPointOperation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAccessPoint` operation.
    ///
    /// See [`GetAccessPoint`](crate::client::fluent_builders::GetAccessPoint) for more information about the
    /// operation and its arguments.
    pub fn get_access_point(&self) -> fluent_builders::GetAccessPoint<C, M, R> {
        fluent_builders::GetAccessPoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAccessPointConfigurationForObjectLambda` operation.
    ///
    /// See [`GetAccessPointConfigurationForObjectLambda`](crate::client::fluent_builders::GetAccessPointConfigurationForObjectLambda) for more information about the
    /// operation and its arguments.
    pub fn get_access_point_configuration_for_object_lambda(
        &self,
    ) -> fluent_builders::GetAccessPointConfigurationForObjectLambda<C, M, R> {
        fluent_builders::GetAccessPointConfigurationForObjectLambda::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAccessPointForObjectLambda` operation.
    ///
    /// See [`GetAccessPointForObjectLambda`](crate::client::fluent_builders::GetAccessPointForObjectLambda) for more information about the
    /// operation and its arguments.
    pub fn get_access_point_for_object_lambda(
        &self,
    ) -> fluent_builders::GetAccessPointForObjectLambda<C, M, R> {
        fluent_builders::GetAccessPointForObjectLambda::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAccessPointPolicy` operation.
    ///
    /// See [`GetAccessPointPolicy`](crate::client::fluent_builders::GetAccessPointPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_access_point_policy(&self) -> fluent_builders::GetAccessPointPolicy<C, M, R> {
        fluent_builders::GetAccessPointPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAccessPointPolicyForObjectLambda` operation.
    ///
    /// See [`GetAccessPointPolicyForObjectLambda`](crate::client::fluent_builders::GetAccessPointPolicyForObjectLambda) for more information about the
    /// operation and its arguments.
    pub fn get_access_point_policy_for_object_lambda(
        &self,
    ) -> fluent_builders::GetAccessPointPolicyForObjectLambda<C, M, R> {
        fluent_builders::GetAccessPointPolicyForObjectLambda::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAccessPointPolicyStatus` operation.
    ///
    /// See [`GetAccessPointPolicyStatus`](crate::client::fluent_builders::GetAccessPointPolicyStatus) for more information about the
    /// operation and its arguments.
    pub fn get_access_point_policy_status(
        &self,
    ) -> fluent_builders::GetAccessPointPolicyStatus<C, M, R> {
        fluent_builders::GetAccessPointPolicyStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAccessPointPolicyStatusForObjectLambda` operation.
    ///
    /// See [`GetAccessPointPolicyStatusForObjectLambda`](crate::client::fluent_builders::GetAccessPointPolicyStatusForObjectLambda) for more information about the
    /// operation and its arguments.
    pub fn get_access_point_policy_status_for_object_lambda(
        &self,
    ) -> fluent_builders::GetAccessPointPolicyStatusForObjectLambda<C, M, R> {
        fluent_builders::GetAccessPointPolicyStatusForObjectLambda::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBucket` operation.
    ///
    /// See [`GetBucket`](crate::client::fluent_builders::GetBucket) for more information about the
    /// operation and its arguments.
    pub fn get_bucket(&self) -> fluent_builders::GetBucket<C, M, R> {
        fluent_builders::GetBucket::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBucketLifecycleConfiguration` operation.
    ///
    /// See [`GetBucketLifecycleConfiguration`](crate::client::fluent_builders::GetBucketLifecycleConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_bucket_lifecycle_configuration(
        &self,
    ) -> fluent_builders::GetBucketLifecycleConfiguration<C, M, R> {
        fluent_builders::GetBucketLifecycleConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBucketPolicy` operation.
    ///
    /// See [`GetBucketPolicy`](crate::client::fluent_builders::GetBucketPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_bucket_policy(&self) -> fluent_builders::GetBucketPolicy<C, M, R> {
        fluent_builders::GetBucketPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBucketTagging` operation.
    ///
    /// See [`GetBucketTagging`](crate::client::fluent_builders::GetBucketTagging) for more information about the
    /// operation and its arguments.
    pub fn get_bucket_tagging(&self) -> fluent_builders::GetBucketTagging<C, M, R> {
        fluent_builders::GetBucketTagging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetJobTagging` operation.
    ///
    /// See [`GetJobTagging`](crate::client::fluent_builders::GetJobTagging) for more information about the
    /// operation and its arguments.
    pub fn get_job_tagging(&self) -> fluent_builders::GetJobTagging<C, M, R> {
        fluent_builders::GetJobTagging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMultiRegionAccessPoint` operation.
    ///
    /// See [`GetMultiRegionAccessPoint`](crate::client::fluent_builders::GetMultiRegionAccessPoint) for more information about the
    /// operation and its arguments.
    pub fn get_multi_region_access_point(
        &self,
    ) -> fluent_builders::GetMultiRegionAccessPoint<C, M, R> {
        fluent_builders::GetMultiRegionAccessPoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMultiRegionAccessPointPolicy` operation.
    ///
    /// See [`GetMultiRegionAccessPointPolicy`](crate::client::fluent_builders::GetMultiRegionAccessPointPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_multi_region_access_point_policy(
        &self,
    ) -> fluent_builders::GetMultiRegionAccessPointPolicy<C, M, R> {
        fluent_builders::GetMultiRegionAccessPointPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMultiRegionAccessPointPolicyStatus` operation.
    ///
    /// See [`GetMultiRegionAccessPointPolicyStatus`](crate::client::fluent_builders::GetMultiRegionAccessPointPolicyStatus) for more information about the
    /// operation and its arguments.
    pub fn get_multi_region_access_point_policy_status(
        &self,
    ) -> fluent_builders::GetMultiRegionAccessPointPolicyStatus<C, M, R> {
        fluent_builders::GetMultiRegionAccessPointPolicyStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPublicAccessBlock` operation.
    ///
    /// See [`GetPublicAccessBlock`](crate::client::fluent_builders::GetPublicAccessBlock) for more information about the
    /// operation and its arguments.
    pub fn get_public_access_block(&self) -> fluent_builders::GetPublicAccessBlock<C, M, R> {
        fluent_builders::GetPublicAccessBlock::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetStorageLensConfiguration` operation.
    ///
    /// See [`GetStorageLensConfiguration`](crate::client::fluent_builders::GetStorageLensConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_storage_lens_configuration(
        &self,
    ) -> fluent_builders::GetStorageLensConfiguration<C, M, R> {
        fluent_builders::GetStorageLensConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetStorageLensConfigurationTagging` operation.
    ///
    /// See [`GetStorageLensConfigurationTagging`](crate::client::fluent_builders::GetStorageLensConfigurationTagging) for more information about the
    /// operation and its arguments.
    pub fn get_storage_lens_configuration_tagging(
        &self,
    ) -> fluent_builders::GetStorageLensConfigurationTagging<C, M, R> {
        fluent_builders::GetStorageLensConfigurationTagging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAccessPoints` operation.
    ///
    /// See [`ListAccessPoints`](crate::client::fluent_builders::ListAccessPoints) for more information about the
    /// operation and its arguments.
    pub fn list_access_points(&self) -> fluent_builders::ListAccessPoints<C, M, R> {
        fluent_builders::ListAccessPoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAccessPointsForObjectLambda` operation.
    ///
    /// See [`ListAccessPointsForObjectLambda`](crate::client::fluent_builders::ListAccessPointsForObjectLambda) for more information about the
    /// operation and its arguments.
    pub fn list_access_points_for_object_lambda(
        &self,
    ) -> fluent_builders::ListAccessPointsForObjectLambda<C, M, R> {
        fluent_builders::ListAccessPointsForObjectLambda::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListJobs` operation.
    ///
    /// See [`ListJobs`](crate::client::fluent_builders::ListJobs) for more information about the
    /// operation and its arguments.
    pub fn list_jobs(&self) -> fluent_builders::ListJobs<C, M, R> {
        fluent_builders::ListJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListMultiRegionAccessPoints` operation.
    ///
    /// See [`ListMultiRegionAccessPoints`](crate::client::fluent_builders::ListMultiRegionAccessPoints) for more information about the
    /// operation and its arguments.
    pub fn list_multi_region_access_points(
        &self,
    ) -> fluent_builders::ListMultiRegionAccessPoints<C, M, R> {
        fluent_builders::ListMultiRegionAccessPoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRegionalBuckets` operation.
    ///
    /// See [`ListRegionalBuckets`](crate::client::fluent_builders::ListRegionalBuckets) for more information about the
    /// operation and its arguments.
    pub fn list_regional_buckets(&self) -> fluent_builders::ListRegionalBuckets<C, M, R> {
        fluent_builders::ListRegionalBuckets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListStorageLensConfigurations` operation.
    ///
    /// See [`ListStorageLensConfigurations`](crate::client::fluent_builders::ListStorageLensConfigurations) for more information about the
    /// operation and its arguments.
    pub fn list_storage_lens_configurations(
        &self,
    ) -> fluent_builders::ListStorageLensConfigurations<C, M, R> {
        fluent_builders::ListStorageLensConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutAccessPointConfigurationForObjectLambda` operation.
    ///
    /// See [`PutAccessPointConfigurationForObjectLambda`](crate::client::fluent_builders::PutAccessPointConfigurationForObjectLambda) for more information about the
    /// operation and its arguments.
    pub fn put_access_point_configuration_for_object_lambda(
        &self,
    ) -> fluent_builders::PutAccessPointConfigurationForObjectLambda<C, M, R> {
        fluent_builders::PutAccessPointConfigurationForObjectLambda::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutAccessPointPolicy` operation.
    ///
    /// See [`PutAccessPointPolicy`](crate::client::fluent_builders::PutAccessPointPolicy) for more information about the
    /// operation and its arguments.
    pub fn put_access_point_policy(&self) -> fluent_builders::PutAccessPointPolicy<C, M, R> {
        fluent_builders::PutAccessPointPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutAccessPointPolicyForObjectLambda` operation.
    ///
    /// See [`PutAccessPointPolicyForObjectLambda`](crate::client::fluent_builders::PutAccessPointPolicyForObjectLambda) for more information about the
    /// operation and its arguments.
    pub fn put_access_point_policy_for_object_lambda(
        &self,
    ) -> fluent_builders::PutAccessPointPolicyForObjectLambda<C, M, R> {
        fluent_builders::PutAccessPointPolicyForObjectLambda::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutBucketLifecycleConfiguration` operation.
    ///
    /// See [`PutBucketLifecycleConfiguration`](crate::client::fluent_builders::PutBucketLifecycleConfiguration) for more information about the
    /// operation and its arguments.
    pub fn put_bucket_lifecycle_configuration(
        &self,
    ) -> fluent_builders::PutBucketLifecycleConfiguration<C, M, R> {
        fluent_builders::PutBucketLifecycleConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutBucketPolicy` operation.
    ///
    /// See [`PutBucketPolicy`](crate::client::fluent_builders::PutBucketPolicy) for more information about the
    /// operation and its arguments.
    pub fn put_bucket_policy(&self) -> fluent_builders::PutBucketPolicy<C, M, R> {
        fluent_builders::PutBucketPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutBucketTagging` operation.
    ///
    /// See [`PutBucketTagging`](crate::client::fluent_builders::PutBucketTagging) for more information about the
    /// operation and its arguments.
    pub fn put_bucket_tagging(&self) -> fluent_builders::PutBucketTagging<C, M, R> {
        fluent_builders::PutBucketTagging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutJobTagging` operation.
    ///
    /// See [`PutJobTagging`](crate::client::fluent_builders::PutJobTagging) for more information about the
    /// operation and its arguments.
    pub fn put_job_tagging(&self) -> fluent_builders::PutJobTagging<C, M, R> {
        fluent_builders::PutJobTagging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutMultiRegionAccessPointPolicy` operation.
    ///
    /// See [`PutMultiRegionAccessPointPolicy`](crate::client::fluent_builders::PutMultiRegionAccessPointPolicy) for more information about the
    /// operation and its arguments.
    pub fn put_multi_region_access_point_policy(
        &self,
    ) -> fluent_builders::PutMultiRegionAccessPointPolicy<C, M, R> {
        fluent_builders::PutMultiRegionAccessPointPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutPublicAccessBlock` operation.
    ///
    /// See [`PutPublicAccessBlock`](crate::client::fluent_builders::PutPublicAccessBlock) for more information about the
    /// operation and its arguments.
    pub fn put_public_access_block(&self) -> fluent_builders::PutPublicAccessBlock<C, M, R> {
        fluent_builders::PutPublicAccessBlock::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutStorageLensConfiguration` operation.
    ///
    /// See [`PutStorageLensConfiguration`](crate::client::fluent_builders::PutStorageLensConfiguration) for more information about the
    /// operation and its arguments.
    pub fn put_storage_lens_configuration(
        &self,
    ) -> fluent_builders::PutStorageLensConfiguration<C, M, R> {
        fluent_builders::PutStorageLensConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutStorageLensConfigurationTagging` operation.
    ///
    /// See [`PutStorageLensConfigurationTagging`](crate::client::fluent_builders::PutStorageLensConfigurationTagging) for more information about the
    /// operation and its arguments.
    pub fn put_storage_lens_configuration_tagging(
        &self,
    ) -> fluent_builders::PutStorageLensConfigurationTagging<C, M, R> {
        fluent_builders::PutStorageLensConfigurationTagging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateJobPriority` operation.
    ///
    /// See [`UpdateJobPriority`](crate::client::fluent_builders::UpdateJobPriority) for more information about the
    /// operation and its arguments.
    pub fn update_job_priority(&self) -> fluent_builders::UpdateJobPriority<C, M, R> {
        fluent_builders::UpdateJobPriority::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateJobStatus` operation.
    ///
    /// See [`UpdateJobStatus`](crate::client::fluent_builders::UpdateJobStatus) for more information about the
    /// operation and its arguments.
    pub fn update_job_status(&self) -> fluent_builders::UpdateJobStatus<C, M, R> {
        fluent_builders::UpdateJobStatus::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateAccessPoint`.
    ///
    /// <p>Creates an access point and associates it with the specified bucket. For more information, see
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">Managing Data Access with Amazon S3 Access
    /// Points</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p></p>
    /// <note>
    /// <p>S3 on Outposts only supports VPC-style access points.
    /// </p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">
    /// Accessing Amazon S3 on Outposts using virtual private cloud (VPC) only access points</a> in
    /// the <i>Amazon S3 User Guide</i>.</p>
    /// </note>
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html#API_control_CreateAccessPoint_Examples">Examples</a> section.</p>
    /// <p></p>
    /// <p>The following actions are related to <code>CreateAccessPoint</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html">GetAccessPoint</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html">DeleteAccessPoint</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html">ListAccessPoints</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct CreateAccessPoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_access_point_input::Builder,
    }
    impl<C, M, R> CreateAccessPoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAccessPoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAccessPointOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAccessPointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAccessPointInputOperationOutputAlias,
                crate::output::CreateAccessPointOutput,
                crate::error::CreateAccessPointError,
                crate::input::CreateAccessPointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID for the owner of the bucket for which you want to create an access point.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID for the owner of the bucket for which you want to create an access point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name you want to assign to this access point.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name you want to assign to this access point.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name of the bucket that you want to associate this access point with.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded.  </p>
        pub fn bucket(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(inp);
            self
        }
        /// <p>The name of the bucket that you want to associate this access point with.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded.  </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>If you include this field, Amazon S3 restricts access to this access point to requests from the
        /// specified virtual private cloud (VPC).</p>
        /// <note>
        /// <p>This is required for creating an access point for Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn vpc_configuration(mut self, inp: crate::model::VpcConfiguration) -> Self {
            self.inner = self.inner.vpc_configuration(inp);
            self
        }
        /// <p>If you include this field, Amazon S3 restricts access to this access point to requests from the
        /// specified virtual private cloud (VPC).</p>
        /// <note>
        /// <p>This is required for creating an access point for Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_vpc_configuration(
            mut self,
            input: std::option::Option<crate::model::VpcConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_vpc_configuration(input);
            self
        }
        /// <p>
        /// The <code>PublicAccessBlock</code> configuration that you want to apply to the access point.
        /// </p>
        pub fn public_access_block_configuration(
            mut self,
            inp: crate::model::PublicAccessBlockConfiguration,
        ) -> Self {
            self.inner = self.inner.public_access_block_configuration(inp);
            self
        }
        /// <p>
        /// The <code>PublicAccessBlock</code> configuration that you want to apply to the access point.
        /// </p>
        pub fn set_public_access_block_configuration(
            mut self,
            input: std::option::Option<crate::model::PublicAccessBlockConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_public_access_block_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAccessPointForObjectLambda`.
    ///
    /// <p>Creates an Object Lambda Access Point. For more information, see
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/transforming-objects.html">Transforming objects with Object Lambda Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>The following actions are related to <code>CreateAccessPointForObjectLambda</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointForObjectLambda.html">DeleteAccessPointForObjectLambda</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointForObjectLambda.html">GetAccessPointForObjectLambda</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPointsForObjectLambda.html">ListAccessPointsForObjectLambda</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct CreateAccessPointForObjectLambda<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_access_point_for_object_lambda_input::Builder,
    }
    impl<C, M, R> CreateAccessPointForObjectLambda<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAccessPointForObjectLambda`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAccessPointForObjectLambdaOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAccessPointForObjectLambdaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAccessPointForObjectLambdaInputOperationOutputAlias,
                crate::output::CreateAccessPointForObjectLambdaOutput,
                crate::error::CreateAccessPointForObjectLambdaError,
                crate::input::CreateAccessPointForObjectLambdaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID for owner of the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID for owner of the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name you want to assign to this Object Lambda Access Point.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name you want to assign to this Object Lambda Access Point.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Object Lambda Access Point configuration as a JSON document.</p>
        pub fn configuration(mut self, inp: crate::model::ObjectLambdaConfiguration) -> Self {
            self.inner = self.inner.configuration(inp);
            self
        }
        /// <p>Object Lambda Access Point configuration as a JSON document.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ObjectLambdaConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBucket`.
    ///
    /// <note>
    /// <p>This action creates an Amazon S3 on Outposts bucket. To create an S3 bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">Create Bucket</a> in the <i>Amazon S3 API Reference</i>.
    /// </p>
    /// </note>
    /// <p>Creates a new Outposts bucket. By creating the bucket, you become the bucket owner. To create an Outposts bucket, you must have S3 on Outposts.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in <i>Amazon S3 User Guide</i>.</p>
    /// <p>Not every string is an acceptable bucket name. For information on bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/BucketRestrictions.html#bucketnamingrules">Working with Amazon S3 Buckets</a>.</p>
    /// <p>S3 on Outposts buckets support:</p>
    /// <ul>
    /// <li>
    /// <p>Tags</p>
    /// </li>
    /// <li>
    /// <p>LifecycleConfigurations for deleting expired objects</p>
    /// </li>
    /// </ul>
    /// <p>For a complete list of restrictions and Amazon S3 feature limitations on S3 on Outposts,  
    /// see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3OnOutpostsRestrictionsLimitations.html">
    /// Amazon S3 on Outposts Restrictions and Limitations</a>.</p>
    /// <p>For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts
    /// endpoint hostname prefix and <code>x-amz-outpost-id</code> in your API request, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html#API_control_CreateBucket_Examples">Examples</a> section.</p>
    ///
    /// <p>The following actions are related to <code>CreateBucket</code> for Amazon S3 on Outposts:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucket.html">GetBucket</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html">DeleteBucket</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html">CreateAccessPoint</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html">PutAccessPointPolicy</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct CreateBucket<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_bucket_input::Builder,
    }
    impl<C, M, R> CreateBucket<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBucket`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBucketOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBucketError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBucketInputOperationOutputAlias,
                crate::output::CreateBucketOutput,
                crate::error::CreateBucketError,
                crate::input::CreateBucketInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The canned ACL to apply to the bucket.</p>
        /// <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn acl(mut self, inp: crate::model::BucketCannedAcl) -> Self {
            self.inner = self.inner.acl(inp);
            self
        }
        /// <p>The canned ACL to apply to the bucket.</p>
        /// <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_acl(
            mut self,
            input: std::option::Option<crate::model::BucketCannedAcl>,
        ) -> Self {
            self.inner = self.inner.set_acl(input);
            self
        }
        /// <p>The name of the bucket.</p>
        pub fn bucket(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(inp);
            self
        }
        /// <p>The name of the bucket.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p>
        /// <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn grant_full_control(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_full_control(inp);
            self
        }
        /// <p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p>
        /// <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_grant_full_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_grant_full_control(input);
            self
        }
        /// <p>Allows grantee to list the objects in the bucket.</p>
        /// <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn grant_read(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_read(inp);
            self
        }
        /// <p>Allows grantee to list the objects in the bucket.</p>
        /// <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_grant_read(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grant_read(input);
            self
        }
        /// <p>Allows grantee to read the bucket ACL.</p>
        /// <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn grant_read_acp(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_read_acp(inp);
            self
        }
        /// <p>Allows grantee to read the bucket ACL.</p>
        /// <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_grant_read_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_grant_read_acp(input);
            self
        }
        /// <p>Allows grantee to create, overwrite, and delete any object in the bucket.</p>
        /// <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn grant_write(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_write(inp);
            self
        }
        /// <p>Allows grantee to create, overwrite, and delete any object in the bucket.</p>
        /// <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_grant_write(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grant_write(input);
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable bucket.</p>
        /// <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn grant_write_acp(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_write_acp(inp);
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable bucket.</p>
        /// <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_grant_write_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_grant_write_acp(input);
            self
        }
        /// <p>Specifies whether you want S3 Object Lock to be enabled for the new bucket.</p>
        /// <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn object_lock_enabled_for_bucket(mut self, inp: bool) -> Self {
            self.inner = self.inner.object_lock_enabled_for_bucket(inp);
            self
        }
        /// <p>Specifies whether you want S3 Object Lock to be enabled for the new bucket.</p>
        /// <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_object_lock_enabled_for_bucket(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_object_lock_enabled_for_bucket(input);
            self
        }
        /// <p>The ID of the Outposts where the bucket is being created.</p>
        /// <note>
        /// <p>This is required by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn outpost_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.outpost_id(inp);
            self
        }
        /// <p>The ID of the Outposts where the bucket is being created.</p>
        /// <note>
        /// <p>This is required by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_outpost_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_outpost_id(input);
            self
        }
        /// <p>The configuration information for the bucket.</p>
        /// <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn create_bucket_configuration(
            mut self,
            inp: crate::model::CreateBucketConfiguration,
        ) -> Self {
            self.inner = self.inner.create_bucket_configuration(inp);
            self
        }
        /// <p>The configuration information for the bucket.</p>
        /// <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_create_bucket_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateBucketConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_create_bucket_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateJob`.
    ///
    /// <p>You can use S3 Batch Operations to perform large-scale batch actions on Amazon S3 objects. Batch Operations can run a
    /// single action on lists of Amazon S3 objects that you specify. For more information,
    /// see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-basics.html">S3 Batch Operations</a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// <p>This action creates a S3 Batch Operations job.</p>
    /// <p></p>
    /// <p>Related actions include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html">DescribeJob</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html">ListJobs</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobPriority.html">UpdateJobPriority</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html">UpdateJobStatus</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_JobOperation.html">JobOperation</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct CreateJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_job_input::Builder,
    }
    impl<C, M, R> CreateJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateJobInputOperationOutputAlias,
                crate::output::CreateJobOutput,
                crate::error::CreateJobError,
                crate::input::CreateJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID that creates the job.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID that creates the job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>Indicates whether confirmation is required before Amazon S3 runs the job. Confirmation is only required for jobs created through the Amazon S3 console.</p>
        pub fn confirmation_required(mut self, inp: bool) -> Self {
            self.inner = self.inner.confirmation_required(inp);
            self
        }
        /// <p>Indicates whether confirmation is required before Amazon S3 runs the job. Confirmation is only required for jobs created through the Amazon S3 console.</p>
        pub fn set_confirmation_required(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_confirmation_required(input);
            self
        }
        /// <p>The action that you want this job to perform on every object listed in the manifest.
        /// For more information about the available actions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-actions.html">Operations</a> in the
        /// <i>Amazon S3 User Guide</i>.</p>
        pub fn operation(mut self, inp: crate::model::JobOperation) -> Self {
            self.inner = self.inner.operation(inp);
            self
        }
        /// <p>The action that you want this job to perform on every object listed in the manifest.
        /// For more information about the available actions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-actions.html">Operations</a> in the
        /// <i>Amazon S3 User Guide</i>.</p>
        pub fn set_operation(
            mut self,
            input: std::option::Option<crate::model::JobOperation>,
        ) -> Self {
            self.inner = self.inner.set_operation(input);
            self
        }
        /// <p>Configuration parameters for the optional job-completion report.</p>
        pub fn report(mut self, inp: crate::model::JobReport) -> Self {
            self.inner = self.inner.report(inp);
            self
        }
        /// <p>Configuration parameters for the optional job-completion report.</p>
        pub fn set_report(mut self, input: std::option::Option<crate::model::JobReport>) -> Self {
            self.inner = self.inner.set_report(input);
            self
        }
        /// <p>An idempotency token to ensure that you don't accidentally submit the same request twice. You can use any string up to the maximum length.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>An idempotency token to ensure that you don't accidentally submit the same request twice. You can use any string up to the maximum length.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>Configuration parameters for the manifest.</p>
        pub fn manifest(mut self, inp: crate::model::JobManifest) -> Self {
            self.inner = self.inner.manifest(inp);
            self
        }
        /// <p>Configuration parameters for the manifest.</p>
        pub fn set_manifest(
            mut self,
            input: std::option::Option<crate::model::JobManifest>,
        ) -> Self {
            self.inner = self.inner.set_manifest(input);
            self
        }
        /// <p>A description for this job. You can use any string within the permitted length. Descriptions don't need to be unique and can be used for multiple jobs.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description for this job. You can use any string within the permitted length. Descriptions don't need to be unique and can be used for multiple jobs.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The numerical priority for this job. Higher numbers indicate higher priority.</p>
        pub fn priority(mut self, inp: i32) -> Self {
            self.inner = self.inner.priority(inp);
            self
        }
        /// <p>The numerical priority for this job. Higher numbers indicate higher priority.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_priority(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Identity and Access Management (IAM) role
        /// that Batch Operations will use to run this job's action on every object in the
        /// manifest.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Identity and Access Management (IAM) role
        /// that Batch Operations will use to run this job's action on every object in the
        /// manifest.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A set of tags to associate with the S3 Batch Operations job. This is an optional parameter. </p>
        pub fn tags(mut self, inp: impl Into<crate::model::S3Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A set of tags to associate with the S3 Batch Operations job. This is an optional parameter. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMultiRegionAccessPoint`.
    ///
    /// <p>Creates a Multi-Region Access Point and associates it with the specified buckets. For more information about creating Multi-Region Access Points, see
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html">Creating
    /// Multi-Region Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>This action will always be routed to the US West (Oregon) Region. For more
    /// information about the restrictions around managing Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html">Managing
    /// Multi-Region Access Points</a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// <p>This request is asynchronous, meaning that you might receive a response before the
    /// command has completed. When this request provides a response, it provides a token that
    /// you can use to monitor the status of the request with
    /// <code>DescribeMultiRegionAccessPointOperation</code>.</p>
    /// <p>The following actions are related to <code>CreateMultiRegionAccessPoint</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html">DeleteMultiRegionAccessPoint</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html">GetMultiRegionAccessPoint</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html">ListMultiRegionAccessPoints</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct CreateMultiRegionAccessPoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_multi_region_access_point_input::Builder,
    }
    impl<C, M, R> CreateMultiRegionAccessPoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMultiRegionAccessPoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMultiRegionAccessPointOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMultiRegionAccessPointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMultiRegionAccessPointInputOperationOutputAlias,
                crate::output::CreateMultiRegionAccessPointOutput,
                crate::error::CreateMultiRegionAccessPointError,
                crate::input::CreateMultiRegionAccessPointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point. The owner of the Multi-Region Access Point also must own
        /// the underlying buckets.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point. The owner of the Multi-Region Access Point also must own
        /// the underlying buckets.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>An idempotency token used to identify the request and guarantee that requests are
        /// unique.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>An idempotency token used to identify the request and guarantee that requests are
        /// unique.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>A container element containing details about the Multi-Region Access Point.</p>
        pub fn details(mut self, inp: crate::model::CreateMultiRegionAccessPointInput) -> Self {
            self.inner = self.inner.details(inp);
            self
        }
        /// <p>A container element containing details about the Multi-Region Access Point.</p>
        pub fn set_details(
            mut self,
            input: std::option::Option<crate::model::CreateMultiRegionAccessPointInput>,
        ) -> Self {
            self.inner = self.inner.set_details(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccessPoint`.
    ///
    /// <p>Deletes the specified access point.</p>
    ///
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html#API_control_DeleteAccessPoint_Examples">Examples</a> section.</p>
    /// <p>The following actions are related to <code>DeleteAccessPoint</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html">CreateAccessPoint</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html">GetAccessPoint</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html">ListAccessPoints</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAccessPoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_access_point_input::Builder,
    }
    impl<C, M, R> DeleteAccessPoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAccessPoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAccessPointOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAccessPointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAccessPointInputOperationOutputAlias,
                crate::output::DeleteAccessPointOutput,
                crate::error::DeleteAccessPointError,
                crate::input::DeleteAccessPointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the access point you want to delete.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the access point you want to delete.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccessPointForObjectLambda`.
    ///
    /// <p>Deletes the specified Object Lambda Access Point.</p>
    /// <p>The following actions are related to <code>DeleteAccessPointForObjectLambda</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPointForObjectLambda.html">CreateAccessPointForObjectLambda</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointForObjectLambda.html">GetAccessPointForObjectLambda</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPointsForObjectLambda.html">ListAccessPointsForObjectLambda</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAccessPointForObjectLambda<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_access_point_for_object_lambda_input::Builder,
    }
    impl<C, M, R> DeleteAccessPointForObjectLambda<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAccessPointForObjectLambda`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAccessPointForObjectLambdaOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAccessPointForObjectLambdaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAccessPointForObjectLambdaInputOperationOutputAlias,
                crate::output::DeleteAccessPointForObjectLambdaOutput,
                crate::error::DeleteAccessPointForObjectLambdaError,
                crate::input::DeleteAccessPointForObjectLambdaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the access point you want to delete.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the access point you want to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccessPointPolicy`.
    ///
    /// <p>Deletes the access point policy for the specified access point.</p>
    /// <p></p>
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html#API_control_DeleteAccessPointPolicy_Examples">Examples</a> section.</p>
    /// <p>The following actions are related to <code>DeleteAccessPointPolicy</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html">PutAccessPointPolicy</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicy.html">GetAccessPointPolicy</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAccessPointPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_access_point_policy_input::Builder,
    }
    impl<C, M, R> DeleteAccessPointPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAccessPointPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAccessPointPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAccessPointPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAccessPointPolicyInputOperationOutputAlias,
                crate::output::DeleteAccessPointPolicyOutput,
                crate::error::DeleteAccessPointPolicyError,
                crate::input::DeleteAccessPointPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the access point whose policy you want to delete.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the access point whose policy you want to delete.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccessPointPolicyForObjectLambda`.
    ///
    /// <p>Removes the resource policy for an Object Lambda Access Point.</p>
    /// <p>The following actions are related to <code>DeleteAccessPointPolicyForObjectLambda</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicyForObjectLambda.html">GetAccessPointPolicyForObjectLambda</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicyForObjectLambda.html">PutAccessPointPolicyForObjectLambda</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAccessPointPolicyForObjectLambda<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_access_point_policy_for_object_lambda_input::Builder,
    }
    impl<C, M, R> DeleteAccessPointPolicyForObjectLambda<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAccessPointPolicyForObjectLambda`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAccessPointPolicyForObjectLambdaOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteAccessPointPolicyForObjectLambdaError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAccessPointPolicyForObjectLambdaInputOperationOutputAlias,
                crate::output::DeleteAccessPointPolicyForObjectLambdaOutput,
                crate::error::DeleteAccessPointPolicyForObjectLambdaError,
                crate::input::DeleteAccessPointPolicyForObjectLambdaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the Object Lambda Access Point you want to delete the policy for.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the Object Lambda Access Point you want to delete the policy for.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBucket`.
    ///
    /// <note>
    /// <p>This action deletes an Amazon S3 on Outposts bucket. To delete an S3 bucket,
    /// see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html">DeleteBucket</a> in the <i>Amazon S3 API Reference</i>.
    /// </p>
    /// </note>
    /// <p>Deletes the Amazon S3 on Outposts bucket. All objects (including all object versions and delete markers) in the
    /// bucket must be deleted before the bucket itself can be deleted.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in <i>Amazon S3 User Guide</i>.</p>
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html#API_control_DeleteBucket_Examples">Examples</a> section.</p>
    /// <p class="title">
    /// <b>Related Resources</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html">CreateBucket</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucket.html">GetBucket</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html">DeleteObject</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBucket<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_bucket_input::Builder,
    }
    impl<C, M, R> DeleteBucket<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBucket`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBucketOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBucketError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBucketInputOperationOutputAlias,
                crate::output::DeleteBucketOutput,
                crate::error::DeleteBucketError,
                crate::input::DeleteBucketInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID that owns the Outposts bucket.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID that owns the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>Specifies the bucket being deleted.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded.  </p>
        pub fn bucket(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(inp);
            self
        }
        /// <p>Specifies the bucket being deleted.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded.  </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBucketLifecycleConfiguration`.
    ///
    /// <note>
    /// <p>This action deletes an Amazon S3 on Outposts bucket's lifecycle configuration. To delete an
    /// S3 bucket's lifecycle configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketLifecycle.html">DeleteBucketLifecycle</a> in the <i>Amazon S3 API Reference</i>.
    /// </p>
    /// </note>
    /// <p>Deletes the lifecycle configuration from the specified Outposts bucket. Amazon S3 on Outposts removes all the lifecycle configuration
    /// rules in the lifecycle subresource associated with the bucket. Your objects never expire, and Amazon S3 on Outposts no longer automatically
    /// deletes any objects on the basis of rules contained in the deleted lifecycle configuration.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in <i>Amazon S3 User Guide</i>.</p>
    /// <p>To use this action, you must have permission to perform the
    /// <code>s3-outposts:DeleteLifecycleConfiguration</code> action. By default, the bucket
    /// owner has this permission and the Outposts bucket owner can grant this permission to
    /// others.</p>
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketLifecycleConfiguration.html#API_control_DeleteBucketLifecycleConfiguration_Examples">Examples</a> section.</p>
    ///
    /// <p>For more information about object expiration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#intro-lifecycle-rules-actions">Elements to Describe Lifecycle Actions</a>.</p>
    /// <p>Related actions include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html">PutBucketLifecycleConfiguration</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html">GetBucketLifecycleConfiguration</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBucketLifecycleConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_bucket_lifecycle_configuration_input::Builder,
    }
    impl<C, M, R> DeleteBucketLifecycleConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBucketLifecycleConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBucketLifecycleConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteBucketLifecycleConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBucketLifecycleConfigurationInputOperationOutputAlias,
                crate::output::DeleteBucketLifecycleConfigurationOutput,
                crate::error::DeleteBucketLifecycleConfigurationError,
                crate::input::DeleteBucketLifecycleConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID of the lifecycle configuration to delete.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID of the lifecycle configuration to delete.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded.  </p>
        pub fn bucket(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(inp);
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded.  </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBucketPolicy`.
    ///
    /// <note>
    /// <p>This action deletes an Amazon S3 on Outposts bucket policy. To delete an
    /// S3 bucket policy, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketPolicy.html">DeleteBucketPolicy</a> in the <i>Amazon S3 API Reference</i>.
    /// </p>
    /// </note>
    /// <p>This implementation of the DELETE action uses the policy subresource to delete the
    /// policy of a specified Amazon S3 on Outposts bucket. If you are using an identity other than the
    /// root user of the Amazon Web Services account that owns the bucket, the calling identity must have the
    /// <code>s3-outposts:DeleteBucketPolicy</code> permissions on the specified Outposts bucket
    /// and belong to the bucket owner's account to use this action. For more information, see
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in
    /// <i>Amazon S3 User Guide</i>.</p>
    ///
    /// <p>If you don't have <code>DeleteBucketPolicy</code> permissions, Amazon S3 returns a
    /// <code>403 Access Denied</code> error. If you have the correct permissions, but you're
    /// not using an identity that belongs to the bucket owner's account, Amazon S3 returns a
    /// <code>405 Method Not Allowed</code> error. </p>
    ///
    ///
    /// <important>
    /// <p>As a security precaution, the root user of the Amazon Web Services account that owns a bucket can always use this action,
    /// even if the policy explicitly denies the root user the ability to perform this action.</p>
    /// </important>      
    ///
    /// <p>For more information about bucket policies, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies and User Policies</a>. </p>
    ///
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketPolicy.html#API_control_DeleteBucketPolicy_Examples">Examples</a> section.</p>
    ///
    /// <p>The following actions are related to <code>DeleteBucketPolicy</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketPolicy.html">GetBucketPolicy</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketPolicy.html">PutBucketPolicy</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBucketPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_bucket_policy_input::Builder,
    }
    impl<C, M, R> DeleteBucketPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBucketPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBucketPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBucketPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBucketPolicyInputOperationOutputAlias,
                crate::output::DeleteBucketPolicyOutput,
                crate::error::DeleteBucketPolicyError,
                crate::input::DeleteBucketPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID of the Outposts bucket.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID of the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded.  </p>
        pub fn bucket(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(inp);
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded.  </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBucketTagging`.
    ///
    /// <note>
    /// <p>This action deletes an Amazon S3 on Outposts bucket's tags. To delete an
    /// S3 bucket tags, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketTagging.html">DeleteBucketTagging</a> in the <i>Amazon S3 API Reference</i>.
    /// </p>
    /// </note>
    /// <p>Deletes the tags from the Outposts bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in
    /// <i>Amazon S3 User Guide</i>.</p>
    ///
    /// <p>To use this action, you must have permission to perform the <code>PutBucketTagging</code> action.
    /// By default, the bucket owner has this permission and can grant this permission to others.
    /// </p>
    ///
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketTagging.html#API_control_DeleteBucketTagging_Examples">Examples</a> section.</p>
    ///
    /// <p>The following actions are related to <code>DeleteBucketTagging</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketTagging.html">GetBucketTagging</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html">PutBucketTagging</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBucketTagging<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_bucket_tagging_input::Builder,
    }
    impl<C, M, R> DeleteBucketTagging<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBucketTagging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBucketTaggingOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBucketTaggingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBucketTaggingInputOperationOutputAlias,
                crate::output::DeleteBucketTaggingOutput,
                crate::error::DeleteBucketTaggingError,
                crate::input::DeleteBucketTaggingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket tag set to be removed.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket tag set to be removed.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The bucket ARN that has the tag set to be removed.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded.  </p>
        pub fn bucket(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(inp);
            self
        }
        /// <p>The bucket ARN that has the tag set to be removed.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded.  </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteJobTagging`.
    ///
    /// <p>Removes the entire tag set from the specified S3 Batch Operations job. To use this operation,
    /// you must have permission to perform the <code>s3:DeleteJobTagging</code> action. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags">Controlling access and labeling jobs using tags</a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// <p></p>
    /// <p>Related actions include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetJobTagging.html">GetJobTagging</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutJobTagging.html">PutJobTagging</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DeleteJobTagging<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_job_tagging_input::Builder,
    }
    impl<C, M, R> DeleteJobTagging<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteJobTagging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteJobTaggingOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteJobTaggingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteJobTaggingInputOperationOutputAlias,
                crate::output::DeleteJobTaggingOutput,
                crate::error::DeleteJobTaggingError,
                crate::input::DeleteJobTaggingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The ID for the S3 Batch Operations job whose tags you want to delete.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The ID for the S3 Batch Operations job whose tags you want to delete.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMultiRegionAccessPoint`.
    ///
    /// <p>Deletes a Multi-Region Access Point. This action does not delete the buckets associated with the Multi-Region Access Point,
    /// only the Multi-Region Access Point itself.</p>
    /// <p>This action will always be routed to the US West (Oregon) Region. For more
    /// information about the restrictions around managing Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html">Managing
    /// Multi-Region Access Points</a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// <p>This request is asynchronous, meaning that you might receive a response before the
    /// command has completed. When this request provides a response, it provides a token that
    /// you can use to monitor the status of the request with
    /// <code>DescribeMultiRegionAccessPointOperation</code>.</p>
    /// <p>The following actions are related to <code>DeleteMultiRegionAccessPoint</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html">CreateMultiRegionAccessPoint</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html">GetMultiRegionAccessPoint</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html">ListMultiRegionAccessPoints</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DeleteMultiRegionAccessPoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_multi_region_access_point_input::Builder,
    }
    impl<C, M, R> DeleteMultiRegionAccessPoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMultiRegionAccessPoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMultiRegionAccessPointOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMultiRegionAccessPointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMultiRegionAccessPointInputOperationOutputAlias,
                crate::output::DeleteMultiRegionAccessPointOutput,
                crate::error::DeleteMultiRegionAccessPointError,
                crate::input::DeleteMultiRegionAccessPointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>An idempotency token used to identify the request and guarantee that requests are
        /// unique.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>An idempotency token used to identify the request and guarantee that requests are
        /// unique.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>A container element containing details about the Multi-Region Access Point.</p>
        pub fn details(mut self, inp: crate::model::DeleteMultiRegionAccessPointInput) -> Self {
            self.inner = self.inner.details(inp);
            self
        }
        /// <p>A container element containing details about the Multi-Region Access Point.</p>
        pub fn set_details(
            mut self,
            input: std::option::Option<crate::model::DeleteMultiRegionAccessPointInput>,
        ) -> Self {
            self.inner = self.inner.set_details(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePublicAccessBlock`.
    ///
    /// <p>Removes the <code>PublicAccessBlock</code> configuration for an Amazon Web Services account. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html"> Using Amazon S3 block
    /// public access</a>.</p>
    /// <p>Related actions include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetPublicAccessBlock.html">GetPublicAccessBlock</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutPublicAccessBlock.html">PutPublicAccessBlock</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DeletePublicAccessBlock<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_public_access_block_input::Builder,
    }
    impl<C, M, R> DeletePublicAccessBlock<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePublicAccessBlock`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePublicAccessBlockOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePublicAccessBlockError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePublicAccessBlockInputOperationOutputAlias,
                crate::output::DeletePublicAccessBlockOutput,
                crate::error::DeletePublicAccessBlockError,
                crate::input::DeletePublicAccessBlockInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want
        /// to remove.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want
        /// to remove.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStorageLensConfiguration`.
    ///
    /// <p>Deletes the Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage
    /// activity and usage with Amazon S3 Storage Lens </a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// <note>
    /// <p>To use this action,
    /// you must have permission to perform the <code>s3:DeleteStorageLensConfiguration</code> action. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to use Amazon S3 Storage Lens</a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteStorageLensConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_storage_lens_configuration_input::Builder,
    }
    impl<C, M, R> DeleteStorageLensConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteStorageLensConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStorageLensConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStorageLensConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteStorageLensConfigurationInputOperationOutputAlias,
                crate::output::DeleteStorageLensConfigurationOutput,
                crate::error::DeleteStorageLensConfigurationError,
                crate::input::DeleteStorageLensConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the S3 Storage Lens configuration.</p>
        pub fn config_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_id(inp);
            self
        }
        /// <p>The ID of the S3 Storage Lens configuration.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_config_id(input);
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStorageLensConfigurationTagging`.
    ///
    /// <p>Deletes the Amazon S3 Storage Lens configuration tags. For more information about S3 Storage Lens, see
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage
    /// activity and usage with Amazon S3 Storage Lens </a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// <note>
    /// <p>To use this action,
    /// you must have permission to perform the <code>s3:DeleteStorageLensConfigurationTagging</code> action. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to use Amazon S3 Storage Lens</a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteStorageLensConfigurationTagging<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_storage_lens_configuration_tagging_input::Builder,
    }
    impl<C, M, R> DeleteStorageLensConfigurationTagging<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteStorageLensConfigurationTagging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStorageLensConfigurationTaggingOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteStorageLensConfigurationTaggingError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteStorageLensConfigurationTaggingInputOperationOutputAlias,
                crate::output::DeleteStorageLensConfigurationTaggingOutput,
                crate::error::DeleteStorageLensConfigurationTaggingError,
                crate::input::DeleteStorageLensConfigurationTaggingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the S3 Storage Lens configuration.</p>
        pub fn config_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_id(inp);
            self
        }
        /// <p>The ID of the S3 Storage Lens configuration.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_config_id(input);
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeJob`.
    ///
    /// <p>Retrieves the configuration parameters and status for a Batch Operations job. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-basics.html">S3 Batch Operations</a> in
    /// the <i>Amazon S3 User Guide</i>.</p>
    /// <p></p>
    /// <p>Related actions include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html">ListJobs</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobPriority.html">UpdateJobPriority</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html">UpdateJobStatus</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DescribeJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_job_input::Builder,
    }
    impl<C, M, R> DescribeJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeJobInputOperationOutputAlias,
                crate::output::DescribeJobOutput,
                crate::error::DescribeJobError,
                crate::input::DescribeJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The ID for the job whose information you want to retrieve.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The ID for the job whose information you want to retrieve.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMultiRegionAccessPointOperation`.
    ///
    /// <p>Retrieves the status of an asynchronous request to manage a Multi-Region Access Point. For more information
    /// about managing Multi-Region Access Points and how asynchronous requests work, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html">Managing
    /// Multi-Region Access Points</a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// <p>The following actions are related to <code>GetMultiRegionAccessPoint</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html">CreateMultiRegionAccessPoint</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html">DeleteMultiRegionAccessPoint</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html">GetMultiRegionAccessPoint</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html">ListMultiRegionAccessPoints</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DescribeMultiRegionAccessPointOperation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_multi_region_access_point_operation_input::Builder,
    }
    impl<C, M, R> DescribeMultiRegionAccessPointOperation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeMultiRegionAccessPointOperation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMultiRegionAccessPointOperationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeMultiRegionAccessPointOperationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeMultiRegionAccessPointOperationInputOperationOutputAlias,
                crate::output::DescribeMultiRegionAccessPointOperationOutput,
                crate::error::DescribeMultiRegionAccessPointOperationError,
                crate::input::DescribeMultiRegionAccessPointOperationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The request token associated with the request you want to know about. This request token
        /// is returned as part of the response when you make an asynchronous request. You provide
        /// this token to query about the status of the asynchronous action.</p>
        pub fn request_token_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_token_arn(inp);
            self
        }
        /// <p>The request token associated with the request you want to know about. This request token
        /// is returned as part of the response when you make an asynchronous request. You provide
        /// this token to query about the status of the asynchronous action.</p>
        pub fn set_request_token_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_request_token_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccessPoint`.
    ///
    /// <p>Returns configuration information about the specified access point.</p>
    /// <p></p>
    ///
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html#API_control_GetAccessPoint_Examples">Examples</a> section.</p>
    /// <p>The following actions are related to <code>GetAccessPoint</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html">CreateAccessPoint</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html">DeleteAccessPoint</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html">ListAccessPoints</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct GetAccessPoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_access_point_input::Builder,
    }
    impl<C, M, R> GetAccessPoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccessPoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccessPointOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccessPointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccessPointInputOperationOutputAlias,
                crate::output::GetAccessPointOutput,
                crate::error::GetAccessPointError,
                crate::input::GetAccessPointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the access point whose configuration information you want to retrieve.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the access point whose configuration information you want to retrieve.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccessPointConfigurationForObjectLambda`.
    ///
    /// <p>Returns configuration for an Object Lambda Access Point.</p>
    /// <p>The following actions are related to <code>GetAccessPointConfigurationForObjectLambda</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointConfigurationForObjectLambda.html">PutAccessPointConfigurationForObjectLambda</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct GetAccessPointConfigurationForObjectLambda<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_access_point_configuration_for_object_lambda_input::Builder,
    }
    impl<C, M, R> GetAccessPointConfigurationForObjectLambda<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccessPointConfigurationForObjectLambda`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccessPointConfigurationForObjectLambdaOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetAccessPointConfigurationForObjectLambdaError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccessPointConfigurationForObjectLambdaInputOperationOutputAlias,
                crate::output::GetAccessPointConfigurationForObjectLambdaOutput,
                crate::error::GetAccessPointConfigurationForObjectLambdaError,
                crate::input::GetAccessPointConfigurationForObjectLambdaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the Object Lambda Access Point you want to return the configuration for.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the Object Lambda Access Point you want to return the configuration for.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccessPointForObjectLambda`.
    ///
    /// <p>Returns configuration information about the specified Object Lambda Access Point</p>
    /// <p>The following actions are related to <code>GetAccessPointForObjectLambda</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPointForObjectLambda.html">CreateAccessPointForObjectLambda</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointForObjectLambda.html">DeleteAccessPointForObjectLambda</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPointsForObjectLambda.html">ListAccessPointsForObjectLambda</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct GetAccessPointForObjectLambda<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_access_point_for_object_lambda_input::Builder,
    }
    impl<C, M, R> GetAccessPointForObjectLambda<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccessPointForObjectLambda`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccessPointForObjectLambdaOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccessPointForObjectLambdaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccessPointForObjectLambdaInputOperationOutputAlias,
                crate::output::GetAccessPointForObjectLambdaOutput,
                crate::error::GetAccessPointForObjectLambdaError,
                crate::input::GetAccessPointForObjectLambdaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccessPointPolicy`.
    ///
    /// <p>Returns the access point policy associated with the specified access point.</p>
    /// <p>The following actions are related to <code>GetAccessPointPolicy</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html">PutAccessPointPolicy</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html">DeleteAccessPointPolicy</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct GetAccessPointPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_access_point_policy_input::Builder,
    }
    impl<C, M, R> GetAccessPointPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccessPointPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccessPointPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccessPointPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccessPointPolicyInputOperationOutputAlias,
                crate::output::GetAccessPointPolicyOutput,
                crate::error::GetAccessPointPolicyError,
                crate::input::GetAccessPointPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the access point whose policy you want to retrieve.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the access point whose policy you want to retrieve.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccessPointPolicyForObjectLambda`.
    ///
    /// <p>Returns the resource policy for an Object Lambda Access Point.</p>
    /// <p>The following actions are related to <code>GetAccessPointPolicyForObjectLambda</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicyForObjectLambda.html">DeleteAccessPointPolicyForObjectLambda</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicyForObjectLambda.html">PutAccessPointPolicyForObjectLambda</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct GetAccessPointPolicyForObjectLambda<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_access_point_policy_for_object_lambda_input::Builder,
    }
    impl<C, M, R> GetAccessPointPolicyForObjectLambda<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccessPointPolicyForObjectLambda`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccessPointPolicyForObjectLambdaOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetAccessPointPolicyForObjectLambdaError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccessPointPolicyForObjectLambdaInputOperationOutputAlias,
                crate::output::GetAccessPointPolicyForObjectLambdaOutput,
                crate::error::GetAccessPointPolicyForObjectLambdaError,
                crate::input::GetAccessPointPolicyForObjectLambdaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccessPointPolicyStatus`.
    ///
    /// <p>Indicates whether the specified access point currently has a policy that allows public access. For more information about public access through access points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">Managing Data Access with Amazon S3 access points</a> in the <i>Amazon S3 User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAccessPointPolicyStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_access_point_policy_status_input::Builder,
    }
    impl<C, M, R> GetAccessPointPolicyStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccessPointPolicyStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccessPointPolicyStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccessPointPolicyStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccessPointPolicyStatusInputOperationOutputAlias,
                crate::output::GetAccessPointPolicyStatusOutput,
                crate::error::GetAccessPointPolicyStatusError,
                crate::input::GetAccessPointPolicyStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID for the account that owns the specified access point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the access point whose policy status you want to retrieve.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the access point whose policy status you want to retrieve.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccessPointPolicyStatusForObjectLambda`.
    ///
    /// <p>Returns the status of the resource policy associated with an Object Lambda Access Point.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAccessPointPolicyStatusForObjectLambda<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_access_point_policy_status_for_object_lambda_input::Builder,
    }
    impl<C, M, R> GetAccessPointPolicyStatusForObjectLambda<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccessPointPolicyStatusForObjectLambda`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccessPointPolicyStatusForObjectLambdaOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetAccessPointPolicyStatusForObjectLambdaError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccessPointPolicyStatusForObjectLambdaInputOperationOutputAlias,
                crate::output::GetAccessPointPolicyStatusForObjectLambdaOutput,
                crate::error::GetAccessPointPolicyStatusForObjectLambdaError,
                crate::input::GetAccessPointPolicyStatusForObjectLambdaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucket`.
    ///
    /// <p>Gets an Amazon S3 on Outposts bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">
    /// Using Amazon S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>If you are using an identity other than the root user of the Amazon Web Services account
    /// that owns the Outposts bucket, the calling identity must have the
    /// <code>s3-outposts:GetBucket</code> permissions on the specified Outposts bucket and
    /// belong to the Outposts bucket owner's account in order to use this action. Only
    /// users from Outposts bucket owner account with the right permissions can perform
    /// actions on an Outposts bucket.
    /// </p>
    /// <p>
    /// If you don't have <code>s3-outposts:GetBucket</code> permissions or you're not using an identity that belongs to the bucket owner's
    /// account, Amazon S3 returns a <code>403 Access Denied</code> error.</p>
    /// <p>The following actions are related to <code>GetBucket</code> for Amazon S3 on Outposts:</p>
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucket.html#API_control_GetBucket_Examples">Examples</a> section.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html">CreateBucket</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html">DeleteBucket</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct GetBucket<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_bucket_input::Builder,
    }
    impl<C, M, R> GetBucket<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBucket`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBucketInputOperationOutputAlias,
                crate::output::GetBucketOutput,
                crate::error::GetBucketError,
                crate::input::GetBucketInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded.  </p>
        pub fn bucket(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(inp);
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded.  </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketLifecycleConfiguration`.
    ///
    /// <note>
    /// <p>This action gets an Amazon S3 on Outposts bucket's lifecycle configuration. To get an
    /// S3 bucket's lifecycle configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html">GetBucketLifecycleConfiguration</a> in the <i>Amazon S3 API Reference</i>.
    /// </p>
    /// </note>
    /// <p>Returns the lifecycle configuration information set on the Outposts bucket. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> and for
    /// information about lifecycle configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html"> Object Lifecycle Management</a> in
    /// <i>Amazon S3 User Guide</i>.</p>
    ///
    /// <p>To use this action, you must have permission to perform the <code>s3-outposts:GetLifecycleConfiguration</code> action.
    /// The Outposts bucket owner has this permission, by default. The bucket owner can grant this permission to others. For more
    /// information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions
    /// Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p>
    ///
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html#API_control_GetBucketLifecycleConfiguration_Examples">Examples</a> section.</p>
    ///
    /// <p>
    /// <code>GetBucketLifecycleConfiguration</code> has the following special error:</p>
    /// <ul>
    /// <li>
    /// <p>Error code: <code>NoSuchLifecycleConfiguration</code>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>Description: The lifecycle configuration does not exist.</p>
    /// </li>
    /// <li>
    /// <p>HTTP Status Code: 404 Not Found</p>
    /// </li>
    /// <li>
    /// <p>SOAP Fault Code Prefix: Client</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// <p>The following actions are related to <code>GetBucketLifecycleConfiguration</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html">PutBucketLifecycleConfiguration</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketLifecycleConfiguration.html">DeleteBucketLifecycleConfiguration</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct GetBucketLifecycleConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_bucket_lifecycle_configuration_input::Builder,
    }
    impl<C, M, R> GetBucketLifecycleConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBucketLifecycleConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketLifecycleConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketLifecycleConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBucketLifecycleConfigurationInputOperationOutputAlias,
                crate::output::GetBucketLifecycleConfigurationOutput,
                crate::error::GetBucketLifecycleConfigurationError,
                crate::input::GetBucketLifecycleConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded.  </p>
        pub fn bucket(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded.  </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketPolicy`.
    ///
    /// <note>
    /// <p>This action gets a bucket policy for an Amazon S3 on Outposts bucket. To get a policy for an S3
    /// bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketPolicy.html">GetBucketPolicy</a> in the
    /// <i>Amazon S3 API Reference</i>. </p>
    /// </note>
    /// <p>Returns the policy of a specified Outposts bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// <p>If you are using an identity other than the root user of the Amazon Web Services account that owns the bucket, the calling identity
    /// must have the <code>GetBucketPolicy</code> permissions on the specified bucket and belong to the bucket owner's account in order to use this action.</p>
    ///
    /// <p>Only users from Outposts bucket owner account with the right permissions can perform actions on an Outposts bucket.
    /// If you don't have <code>s3-outposts:GetBucketPolicy</code> permissions or you're not using an identity that belongs to the bucket owner's
    /// account, Amazon S3 returns a <code>403 Access Denied</code> error.</p>
    ///
    /// <important>
    /// <p>As a security precaution, the root user of the Amazon Web Services account that owns a bucket can always use this action, even if the policy
    /// explicitly denies the root user the ability to perform this action.</p>
    /// </important>
    ///
    /// <p>For more information about bucket policies, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies and User Policies</a>.</p>
    ///
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketPolicy.html#API_control_GetBucketPolicy_Examples">Examples</a> section.</p>
    ///
    /// <p>The following actions are related to <code>GetBucketPolicy</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketPolicy.html">PutBucketPolicy</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketPolicy.html">DeleteBucketPolicy</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct GetBucketPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_bucket_policy_input::Builder,
    }
    impl<C, M, R> GetBucketPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBucketPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBucketPolicyInputOperationOutputAlias,
                crate::output::GetBucketPolicyOutput,
                crate::error::GetBucketPolicyError,
                crate::input::GetBucketPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded.  </p>
        pub fn bucket(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(inp);
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded.  </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketTagging`.
    ///
    /// <note>
    /// <p>This action gets an Amazon S3 on Outposts bucket's tags. To get an
    /// S3 bucket tags, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketTagging.html">GetBucketTagging</a> in the <i>Amazon S3 API Reference</i>.
    /// </p>
    /// </note>
    /// <p>Returns the tag set associated with the Outposts bucket. For more information, see
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// <p>To use this action, you must have permission to perform the <code>GetBucketTagging</code> action.
    /// By default, the bucket owner has this permission and can grant this permission to others.</p>
    ///
    /// <p>
    /// <code>GetBucketTagging</code> has the following special error:</p>
    /// <ul>
    /// <li>
    /// <p>Error code: <code>NoSuchTagSetError</code>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>Description: There is no tag set associated with the bucket.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketTagging.html#API_control_GetBucketTagging_Examples">Examples</a> section.</p>
    ///
    /// <p>The following actions are related to <code>GetBucketTagging</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html">PutBucketTagging</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketTagging.html">DeleteBucketTagging</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct GetBucketTagging<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_bucket_tagging_input::Builder,
    }
    impl<C, M, R> GetBucketTagging<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBucketTagging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketTaggingOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketTaggingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBucketTaggingInputOperationOutputAlias,
                crate::output::GetBucketTaggingOutput,
                crate::error::GetBucketTaggingError,
                crate::input::GetBucketTaggingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded.  </p>
        pub fn bucket(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(inp);
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded.  </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetJobTagging`.
    ///
    /// <p>Returns the tags on an S3 Batch Operations job. To use this operation, you must have
    /// permission to perform the <code>s3:GetJobTagging</code> action. For more information, see
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags">Controlling
    /// access and labeling jobs using tags</a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// <p></p>
    /// <p>Related actions include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutJobTagging.html">PutJobTagging</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteJobTagging.html">DeleteJobTagging</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct GetJobTagging<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_job_tagging_input::Builder,
    }
    impl<C, M, R> GetJobTagging<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetJobTagging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetJobTaggingOutput,
            aws_smithy_http::result::SdkError<crate::error::GetJobTaggingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetJobTaggingInputOperationOutputAlias,
                crate::output::GetJobTaggingOutput,
                crate::error::GetJobTaggingError,
                crate::input::GetJobTaggingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The ID for the S3 Batch Operations job whose tags you want to retrieve.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The ID for the S3 Batch Operations job whose tags you want to retrieve.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMultiRegionAccessPoint`.
    ///
    /// <p>Returns configuration information about the specified Multi-Region Access Point.</p>
    /// <p>This action will always be routed to the US West (Oregon) Region. For more
    /// information about the restrictions around managing Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html">Managing
    /// Multi-Region Access Points</a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// <p>The following actions are related to <code>GetMultiRegionAccessPoint</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html">CreateMultiRegionAccessPoint</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html">DeleteMultiRegionAccessPoint</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListMultiRegionAccessPoints.html">ListMultiRegionAccessPoints</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct GetMultiRegionAccessPoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_multi_region_access_point_input::Builder,
    }
    impl<C, M, R> GetMultiRegionAccessPoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMultiRegionAccessPoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMultiRegionAccessPointOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMultiRegionAccessPointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMultiRegionAccessPointInputOperationOutputAlias,
                crate::output::GetMultiRegionAccessPointOutput,
                crate::error::GetMultiRegionAccessPointError,
                crate::input::GetMultiRegionAccessPointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the Multi-Region Access Point whose configuration information you want to receive. The name of
        /// the Multi-Region Access Point is different from the alias. For more information about the distinction
        /// between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the
        /// <i>Amazon S3 User Guide</i>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the Multi-Region Access Point whose configuration information you want to receive. The name of
        /// the Multi-Region Access Point is different from the alias. For more information about the distinction
        /// between the name and the alias of an Multi-Region Access Point, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the
        /// <i>Amazon S3 User Guide</i>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMultiRegionAccessPointPolicy`.
    ///
    /// <p>Returns the access control policy of the specified Multi-Region Access Point.</p>
    /// <p>This action will always be routed to the US West (Oregon) Region. For more
    /// information about the restrictions around managing Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html">Managing
    /// Multi-Region Access Points</a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// <p>The following actions are related to <code>GetMultiRegionAccessPointPolicy</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicyStatus.html">GetMultiRegionAccessPointPolicyStatus</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPointPolicy.html">PutMultiRegionAccessPointPolicy</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct GetMultiRegionAccessPointPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_multi_region_access_point_policy_input::Builder,
    }
    impl<C, M, R> GetMultiRegionAccessPointPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMultiRegionAccessPointPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMultiRegionAccessPointPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMultiRegionAccessPointPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMultiRegionAccessPointPolicyInputOperationOutputAlias,
                crate::output::GetMultiRegionAccessPointPolicyOutput,
                crate::error::GetMultiRegionAccessPointPolicyError,
                crate::input::GetMultiRegionAccessPointPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>Specifies the Multi-Region Access Point. The name of the Multi-Region Access Point is different from the alias. For more
        /// information about the distinction between the name and the alias of an Multi-Region Access Point, see
        /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the
        /// <i>Amazon S3 User Guide</i>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Specifies the Multi-Region Access Point. The name of the Multi-Region Access Point is different from the alias. For more
        /// information about the distinction between the name and the alias of an Multi-Region Access Point, see
        /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the
        /// <i>Amazon S3 User Guide</i>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMultiRegionAccessPointPolicyStatus`.
    ///
    /// <p>Indicates whether the specified Multi-Region Access Point has an access control policy that allows public
    /// access.</p>
    /// <p>This action will always be routed to the US West (Oregon) Region. For more
    /// information about the restrictions around managing Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html">Managing
    /// Multi-Region Access Points</a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// <p>The following actions are related to <code>GetMultiRegionAccessPointPolicyStatus</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicy.html">GetMultiRegionAccessPointPolicy</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPointPolicy.html">PutMultiRegionAccessPointPolicy</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct GetMultiRegionAccessPointPolicyStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_multi_region_access_point_policy_status_input::Builder,
    }
    impl<C, M, R> GetMultiRegionAccessPointPolicyStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMultiRegionAccessPointPolicyStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMultiRegionAccessPointPolicyStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetMultiRegionAccessPointPolicyStatusError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMultiRegionAccessPointPolicyStatusInputOperationOutputAlias,
                crate::output::GetMultiRegionAccessPointPolicyStatusOutput,
                crate::error::GetMultiRegionAccessPointPolicyStatusError,
                crate::input::GetMultiRegionAccessPointPolicyStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>Specifies the Multi-Region Access Point. The name of the Multi-Region Access Point is different from the alias. For more
        /// information about the distinction between the name and the alias of an Multi-Region Access Point, see
        /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the
        /// <i>Amazon S3 User Guide</i>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Specifies the Multi-Region Access Point. The name of the Multi-Region Access Point is different from the alias. For more
        /// information about the distinction between the name and the alias of an Multi-Region Access Point, see
        /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming">Managing Multi-Region Access Points</a> in the
        /// <i>Amazon S3 User Guide</i>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPublicAccessBlock`.
    ///
    /// <p>Retrieves the <code>PublicAccessBlock</code> configuration for an Amazon Web Services account. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html"> Using Amazon S3 block
    /// public access</a>.</p>
    /// <p>Related actions include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeletePublicAccessBlock.html">DeletePublicAccessBlock</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutPublicAccessBlock.html">PutPublicAccessBlock</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct GetPublicAccessBlock<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_public_access_block_input::Builder,
    }
    impl<C, M, R> GetPublicAccessBlock<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPublicAccessBlock`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPublicAccessBlockOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPublicAccessBlockError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPublicAccessBlockInputOperationOutputAlias,
                crate::output::GetPublicAccessBlockOutput,
                crate::error::GetPublicAccessBlockError,
                crate::input::GetPublicAccessBlockInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want
        /// to retrieve.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want
        /// to retrieve.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStorageLensConfiguration`.
    ///
    /// <p>Gets the Amazon S3 Storage Lens configuration. For more information, see
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage
    /// activity and usage with Amazon S3 Storage Lens </a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// <note>
    /// <p>To use this action,
    /// you must have permission to perform the <code>s3:GetStorageLensConfiguration</code> action. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to use Amazon S3 Storage Lens</a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetStorageLensConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_storage_lens_configuration_input::Builder,
    }
    impl<C, M, R> GetStorageLensConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetStorageLensConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStorageLensConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStorageLensConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetStorageLensConfigurationInputOperationOutputAlias,
                crate::output::GetStorageLensConfigurationOutput,
                crate::error::GetStorageLensConfigurationError,
                crate::input::GetStorageLensConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon S3 Storage Lens configuration.</p>
        pub fn config_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_id(inp);
            self
        }
        /// <p>The ID of the Amazon S3 Storage Lens configuration.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_config_id(input);
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStorageLensConfigurationTagging`.
    ///
    /// <p>Gets the tags of Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage
    /// activity and usage with Amazon S3 Storage Lens </a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <note>
    /// <p>To use this action,
    /// you must have permission to perform the <code>s3:GetStorageLensConfigurationTagging</code> action. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to use Amazon S3 Storage Lens</a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetStorageLensConfigurationTagging<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_storage_lens_configuration_tagging_input::Builder,
    }
    impl<C, M, R> GetStorageLensConfigurationTagging<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetStorageLensConfigurationTagging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStorageLensConfigurationTaggingOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetStorageLensConfigurationTaggingError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetStorageLensConfigurationTaggingInputOperationOutputAlias,
                crate::output::GetStorageLensConfigurationTaggingOutput,
                crate::error::GetStorageLensConfigurationTaggingError,
                crate::input::GetStorageLensConfigurationTaggingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon S3 Storage Lens configuration.</p>
        pub fn config_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_id(inp);
            self
        }
        /// <p>The ID of the Amazon S3 Storage Lens configuration.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_config_id(input);
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccessPoints`.
    ///
    /// <p>Returns a list of the access points currently associated with the specified bucket. You
    /// can retrieve up to 1000 access points per call. If the specified bucket has more than 1,000
    /// access points (or the number specified in <code>maxResults</code>, whichever is less), the
    /// response will include a continuation token that you can use to list the additional access points.</p>
    /// <p></p>
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html#API_control_GetAccessPoint_Examples">Examples</a> section.</p>
    /// <p>The following actions are related to <code>ListAccessPoints</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html">CreateAccessPoint</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html">DeleteAccessPoint</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html">GetAccessPoint</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct ListAccessPoints<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_access_points_input::Builder,
    }
    impl<C, M, R> ListAccessPoints<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAccessPoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccessPointsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAccessPointsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAccessPointsInputOperationOutputAlias,
                crate::output::ListAccessPointsOutput,
                crate::error::ListAccessPointsError,
                crate::input::ListAccessPointsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID for owner of the bucket whose access points you want to list.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID for owner of the bucket whose access points you want to list.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the bucket whose associated access points you want to list.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded.  </p>
        pub fn bucket(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(inp);
            self
        }
        /// <p>The name of the bucket whose associated access points you want to list.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded.  </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>A continuation token. If a previous call to <code>ListAccessPoints</code> returned a continuation token in the <code>NextToken</code> field, then providing that value here causes Amazon S3 to retrieve the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A continuation token. If a previous call to <code>ListAccessPoints</code> returned a continuation token in the <code>NextToken</code> field, then providing that value here causes Amazon S3 to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of access points that you want to include in the list. If the specified
        /// bucket has more than this number of access points, then the response will include a
        /// continuation token in the <code>NextToken</code> field that you can use to retrieve the
        /// next page of access points.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of access points that you want to include in the list. If the specified
        /// bucket has more than this number of access points, then the response will include a
        /// continuation token in the <code>NextToken</code> field that you can use to retrieve the
        /// next page of access points.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccessPointsForObjectLambda`.
    ///
    /// <p>Returns a list of the access points associated with the Object Lambda Access Point. You
    /// can retrieve up to 1000 access points per call. If there are more than 1,000
    /// access points (or the number specified in <code>maxResults</code>, whichever is less), the
    /// response will include a continuation token that you can use to list the additional access points.</p>
    /// <p>The following actions are related to <code>ListAccessPointsForObjectLambda</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPointForObjectLambda.html">CreateAccessPointForObjectLambda</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointForObjectLambda.html">DeleteAccessPointForObjectLambda</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointForObjectLambda.html">GetAccessPointForObjectLambda</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct ListAccessPointsForObjectLambda<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_access_points_for_object_lambda_input::Builder,
    }
    impl<C, M, R> ListAccessPointsForObjectLambda<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAccessPointsForObjectLambda`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccessPointsForObjectLambdaOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAccessPointsForObjectLambdaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAccessPointsForObjectLambdaInputOperationOutputAlias,
                crate::output::ListAccessPointsForObjectLambdaOutput,
                crate::error::ListAccessPointsForObjectLambdaError,
                crate::input::ListAccessPointsForObjectLambdaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>If the list has more access points than can be returned in one call to this
        /// API, this field contains a continuation token that you can provide in subsequent calls to
        /// this API to retrieve additional access points.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the list has more access points than can be returned in one call to this
        /// API, this field contains a continuation token that you can provide in subsequent calls to
        /// this API to retrieve additional access points.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of access points that you want to include in the list. If there are more than this number of access points, then the response will include a continuation token in the <code>NextToken</code> field that you can use to retrieve the next page of access points.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of access points that you want to include in the list. If there are more than this number of access points, then the response will include a continuation token in the <code>NextToken</code> field that you can use to retrieve the next page of access points.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJobs`.
    ///
    /// <p>Lists current S3 Batch Operations jobs and jobs that have ended within the last 30 days for
    /// the Amazon Web Services account making the request. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-basics.html">S3 Batch Operations</a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// <p>Related actions include:</p>
    /// <p></p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html">DescribeJob</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobPriority.html">UpdateJobPriority</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html">UpdateJobStatus</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct ListJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_jobs_input::Builder,
    }
    impl<C, M, R> ListJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListJobsInputOperationOutputAlias,
                crate::output::ListJobsOutput,
                crate::error::ListJobsError,
                crate::input::ListJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// Appends an item to `JobStatuses`.
        ///
        /// To override the contents of this collection use [`set_job_statuses`](Self::set_job_statuses).
        ///
        /// <p>The <code>List Jobs</code> request returns jobs that match the statuses listed in this element.</p>
        pub fn job_statuses(mut self, inp: impl Into<crate::model::JobStatus>) -> Self {
            self.inner = self.inner.job_statuses(inp);
            self
        }
        /// <p>The <code>List Jobs</code> request returns jobs that match the statuses listed in this element.</p>
        pub fn set_job_statuses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobStatus>>,
        ) -> Self {
            self.inner = self.inner.set_job_statuses(input);
            self
        }
        /// <p>A pagination token to request the next page of results. Use the token that Amazon S3 returned in the <code>NextToken</code> element of the <code>ListJobsResult</code> from the previous <code>List Jobs</code> request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A pagination token to request the next page of results. Use the token that Amazon S3 returned in the <code>NextToken</code> element of the <code>ListJobsResult</code> from the previous <code>List Jobs</code> request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of jobs that Amazon S3 will include in the <code>List Jobs</code> response. If there are more jobs than this number, the response will include a pagination token in the <code>NextToken</code> field to enable you to retrieve the next page of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of jobs that Amazon S3 will include in the <code>List Jobs</code> response. If there are more jobs than this number, the response will include a pagination token in the <code>NextToken</code> field to enable you to retrieve the next page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMultiRegionAccessPoints`.
    ///
    /// <p>Returns a list of the Multi-Region Access Points currently associated with the specified Amazon Web Services account. Each
    /// call can return up to 100 Multi-Region Access Points, the maximum number of Multi-Region Access Points that can be associated with
    /// a single account.</p>
    /// <p>This action will always be routed to the US West (Oregon) Region. For more
    /// information about the restrictions around managing Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html">Managing
    /// Multi-Region Access Points</a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// <p>The following actions are related to <code>ListMultiRegionAccessPoint</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html">CreateMultiRegionAccessPoint</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html">DeleteMultiRegionAccessPoint</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeMultiRegionAccessPointOperation.html">DescribeMultiRegionAccessPointOperation</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPoint.html">GetMultiRegionAccessPoint</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct ListMultiRegionAccessPoints<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_multi_region_access_points_input::Builder,
    }
    impl<C, M, R> ListMultiRegionAccessPoints<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMultiRegionAccessPoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMultiRegionAccessPointsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMultiRegionAccessPointsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMultiRegionAccessPointsInputOperationOutputAlias,
                crate::output::ListMultiRegionAccessPointsOutput,
                crate::error::ListMultiRegionAccessPointsError,
                crate::input::ListMultiRegionAccessPointsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>Not currently used. Do not use this parameter.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Not currently used. Do not use this parameter.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Not currently used. Do not use this parameter.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Not currently used. Do not use this parameter.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRegionalBuckets`.
    ///
    /// <p>Returns a list of all Outposts buckets in an Outpost that are owned by the authenticated
    /// sender of the request. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// <p>For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts
    /// endpoint hostname prefix and <code>x-amz-outpost-id</code> in your request, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListRegionalBuckets.html#API_control_ListRegionalBuckets_Examples">Examples</a> section.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRegionalBuckets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_regional_buckets_input::Builder,
    }
    impl<C, M, R> ListRegionalBuckets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRegionalBuckets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRegionalBucketsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRegionalBucketsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRegionalBucketsInputOperationOutputAlias,
                crate::output::ListRegionalBucketsOutput,
                crate::error::ListRegionalBucketsError,
                crate::input::ListRegionalBucketsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p></p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p></p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p></p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p></p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The ID of the Outposts.</p>
        /// <note>
        /// <p>This is required by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn outpost_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.outpost_id(inp);
            self
        }
        /// <p>The ID of the Outposts.</p>
        /// <note>
        /// <p>This is required by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_outpost_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_outpost_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListStorageLensConfigurations`.
    ///
    /// <p>Gets a list of Amazon S3 Storage Lens configurations. For more information about S3 Storage Lens, see
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage
    /// activity and usage with Amazon S3 Storage Lens </a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// <note>
    /// <p>To use this action,
    /// you must have permission to perform the <code>s3:ListStorageLensConfigurations</code> action. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to use Amazon S3 Storage Lens</a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListStorageLensConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_storage_lens_configurations_input::Builder,
    }
    impl<C, M, R> ListStorageLensConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListStorageLensConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListStorageLensConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListStorageLensConfigurationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListStorageLensConfigurationsInputOperationOutputAlias,
                crate::output::ListStorageLensConfigurationsOutput,
                crate::error::ListStorageLensConfigurationsError,
                crate::input::ListStorageLensConfigurationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID of the requester.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>A pagination token to request the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A pagination token to request the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAccessPointConfigurationForObjectLambda`.
    ///
    /// <p>Replaces configuration for an Object Lambda Access Point.</p>
    /// <p>The following actions are related to <code>PutAccessPointConfigurationForObjectLambda</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointConfigurationForObjectLambda.html">GetAccessPointConfigurationForObjectLambda</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct PutAccessPointConfigurationForObjectLambda<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_access_point_configuration_for_object_lambda_input::Builder,
    }
    impl<C, M, R> PutAccessPointConfigurationForObjectLambda<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutAccessPointConfigurationForObjectLambda`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAccessPointConfigurationForObjectLambdaOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutAccessPointConfigurationForObjectLambdaError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutAccessPointConfigurationForObjectLambdaInputOperationOutputAlias,
                crate::output::PutAccessPointConfigurationForObjectLambdaOutput,
                crate::error::PutAccessPointConfigurationForObjectLambdaError,
                crate::input::PutAccessPointConfigurationForObjectLambdaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Object Lambda Access Point configuration document.</p>
        pub fn configuration(mut self, inp: crate::model::ObjectLambdaConfiguration) -> Self {
            self.inner = self.inner.configuration(inp);
            self
        }
        /// <p>Object Lambda Access Point configuration document.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ObjectLambdaConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAccessPointPolicy`.
    ///
    /// <p>Associates an access policy with the specified access point. Each access point can have only one policy, so a request made to this API
    /// replaces any existing policy associated with the specified access point.</p>
    /// <p></p>
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html#API_control_PutAccessPointPolicy_Examples">Examples</a> section.</p>
    /// <p>The following actions are related to <code>PutAccessPointPolicy</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicy.html">GetAccessPointPolicy</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicy.html">DeleteAccessPointPolicy</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct PutAccessPointPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_access_point_policy_input::Builder,
    }
    impl<C, M, R> PutAccessPointPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutAccessPointPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAccessPointPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAccessPointPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutAccessPointPolicyInputOperationOutputAlias,
                crate::output::PutAccessPointPolicyOutput,
                crate::error::PutAccessPointPolicyError,
                crate::input::PutAccessPointPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID for owner of the bucket associated with the specified access point.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID for owner of the bucket associated with the specified access point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the access point that you want to associate with the specified policy.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the access point that you want to associate with the specified policy.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the access point accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name></code>. For example, to access the access point <code>reports-ap</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap</code>. The value must be URL encoded. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The policy that you want to apply to the specified access point. For more information about access point policies, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">Managing data access with Amazon S3 access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(inp);
            self
        }
        /// <p>The policy that you want to apply to the specified access point. For more information about access point policies, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">Managing data access with Amazon S3 access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutAccessPointPolicyForObjectLambda`.
    ///
    /// <p>Creates or replaces resource policy for an Object Lambda Access Point. For an example policy, see
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/olap-create.html#olap-create-cli">Creating Object Lambda Access Points</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>The following actions are related to <code>PutAccessPointPolicyForObjectLambda</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPointPolicyForObjectLambda.html">DeleteAccessPointPolicyForObjectLambda</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPointPolicyForObjectLambda.html">GetAccessPointPolicyForObjectLambda</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct PutAccessPointPolicyForObjectLambda<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_access_point_policy_for_object_lambda_input::Builder,
    }
    impl<C, M, R> PutAccessPointPolicyForObjectLambda<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutAccessPointPolicyForObjectLambda`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAccessPointPolicyForObjectLambdaOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutAccessPointPolicyForObjectLambdaError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutAccessPointPolicyForObjectLambdaInputOperationOutputAlias,
                crate::output::PutAccessPointPolicyForObjectLambdaOutput,
                crate::error::PutAccessPointPolicyForObjectLambdaError,
                crate::input::PutAccessPointPolicyForObjectLambdaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID for the account that owns the specified Object Lambda Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the Object Lambda Access Point.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Object Lambda Access Point resource policy document.</p>
        pub fn policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(inp);
            self
        }
        /// <p>Object Lambda Access Point resource policy document.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBucketLifecycleConfiguration`.
    ///
    /// <note>
    /// <p>This action puts a lifecycle configuration to an Amazon S3 on Outposts bucket. To put a lifecycle configuration to an S3 bucket,
    /// see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html">PutBucketLifecycleConfiguration</a> in the <i>Amazon S3 API Reference</i>.
    /// </p>
    /// </note>
    /// <p>Creates a new lifecycle configuration for the S3 on Outposts bucket or replaces an existing
    /// lifecycle configuration. Outposts buckets only support lifecycle configurations that delete/expire objects
    /// after a certain period of time and abort incomplete multipart uploads.</p>
    /// <p></p>
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketLifecycleConfiguration.html#API_control_PutBucketLifecycleConfiguration_Examples">Examples</a> section.</p>
    /// <p>The following actions are related to <code>PutBucketLifecycleConfiguration</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketLifecycleConfiguration.html">GetBucketLifecycleConfiguration</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketLifecycleConfiguration.html">DeleteBucketLifecycleConfiguration</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct PutBucketLifecycleConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_bucket_lifecycle_configuration_input::Builder,
    }
    impl<C, M, R> PutBucketLifecycleConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutBucketLifecycleConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBucketLifecycleConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBucketLifecycleConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutBucketLifecycleConfigurationInputOperationOutputAlias,
                crate::output::PutBucketLifecycleConfigurationOutput,
                crate::error::PutBucketLifecycleConfigurationError,
                crate::input::PutBucketLifecycleConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The name of the bucket for which to set the configuration.</p>
        pub fn bucket(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(inp);
            self
        }
        /// <p>The name of the bucket for which to set the configuration.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>Container for lifecycle rules. You can add as many as 1,000 rules.</p>
        pub fn lifecycle_configuration(
            mut self,
            inp: crate::model::LifecycleConfiguration,
        ) -> Self {
            self.inner = self.inner.lifecycle_configuration(inp);
            self
        }
        /// <p>Container for lifecycle rules. You can add as many as 1,000 rules.</p>
        pub fn set_lifecycle_configuration(
            mut self,
            input: std::option::Option<crate::model::LifecycleConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_lifecycle_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBucketPolicy`.
    ///
    /// <note>
    /// <p>This action puts a bucket policy to an Amazon S3 on Outposts bucket. To put a policy on an S3 bucket,
    /// see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketPolicy.html">PutBucketPolicy</a> in the <i>Amazon S3 API Reference</i>.
    /// </p>
    /// </note>
    /// <p>Applies an Amazon S3 bucket policy to an Outposts bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// <p>If you are using an identity other than the root user of the Amazon Web Services account that owns the
    /// Outposts bucket, the calling identity must have the <code>PutBucketPolicy</code>
    /// permissions on the specified Outposts bucket and belong to the bucket owner's account in
    /// order to use this action.</p>
    ///
    /// <p>If you don't have <code>PutBucketPolicy</code> permissions, Amazon S3 returns a <code>403 Access Denied</code> error. If you have the correct permissions,
    /// but you're not using an identity that belongs to the bucket owner's account, Amazon S3 returns a <code>405 Method Not Allowed</code> error.</p>
    ///
    /// <important>
    /// <p> As a security precaution, the root user of the Amazon Web Services account that owns a bucket can always use this action, even if the policy
    /// explicitly denies the root user the ability to perform this action.
    /// </p>
    /// </important>
    ///
    ///
    /// <p>For more information about bucket policies, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies and User Policies</a>.</p>
    ///
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketPolicy.html#API_control_PutBucketPolicy_Examples">Examples</a> section.</p>
    ///
    /// <p>The following actions are related to <code>PutBucketPolicy</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketPolicy.html">GetBucketPolicy</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketPolicy.html">DeleteBucketPolicy</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct PutBucketPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_bucket_policy_input::Builder,
    }
    impl<C, M, R> PutBucketPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutBucketPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBucketPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBucketPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutBucketPolicyInputOperationOutputAlias,
                crate::output::PutBucketPolicyOutput,
                crate::error::PutBucketPolicyError,
                crate::input::PutBucketPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded.  </p>
        pub fn bucket(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(inp);
            self
        }
        /// <p>Specifies the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded.  </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>Set this parameter to true to confirm that you want to remove your permissions to change this bucket policy in the future.</p>
        /// <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn confirm_remove_self_bucket_access(mut self, inp: bool) -> Self {
            self.inner = self.inner.confirm_remove_self_bucket_access(inp);
            self
        }
        /// <p>Set this parameter to true to confirm that you want to remove your permissions to change this bucket policy in the future.</p>
        /// <note>
        /// <p>This is not supported by Amazon S3 on Outposts buckets.</p>
        /// </note>
        pub fn set_confirm_remove_self_bucket_access(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_confirm_remove_self_bucket_access(input);
            self
        }
        /// <p>The bucket policy as a JSON document.</p>
        pub fn policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(inp);
            self
        }
        /// <p>The bucket policy as a JSON document.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBucketTagging`.
    ///
    /// <note>
    /// <p>This action puts tags on an Amazon S3 on Outposts bucket. To put tags on an S3 bucket, see
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketTagging.html">PutBucketTagging</a> in the <i>Amazon S3 API Reference</i>. </p>
    /// </note>
    /// <p>Sets the tags for an S3 on Outposts bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using Amazon S3 on Outposts</a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// <p>Use tags to organize your Amazon Web Services bill to reflect your own cost structure. To do this, sign up to get your
    /// Amazon Web Services account bill with tag key values included. Then, to see the cost of combined resources, organize your
    /// billing information according to resources with the same tag key values. For example, you can tag several
    /// resources with a specific application name, and then organize your billing information to see the total cost
    /// of that application across several services. For more information, see
    /// <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Cost
    /// allocation and tagging</a>.</p>
    ///
    /// <note>
    /// <p>Within a bucket, if you add a tag that has the same key as an existing tag, the new value overwrites
    /// the old value. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/CostAllocTagging.html">
    /// Using cost allocation in Amazon S3 bucket tags</a>.</p>
    /// </note>
    /// <p>To use this action, you must have permissions to perform the
    /// <code>s3-outposts:PutBucketTagging</code> action. The Outposts bucket owner has this
    /// permission by default and can grant this permission to others. For more information about
    /// permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"> Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing access permissions to your Amazon S3
    /// resources</a>.</p>
    ///
    /// <p>
    /// <code>PutBucketTagging</code> has the following special errors:</p>
    /// <ul>
    /// <li>
    /// <p>Error code: <code>InvalidTagError</code>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>Description: The tag provided was not a valid tag. This error can occur if the tag did not pass input validation.
    /// For information about tag restrictions, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html">
    /// User-Defined Tag Restrictions</a>  and <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/aws-tag-restrictions.html">
    /// Amazon Web Services-Generated Cost Allocation Tag Restrictions</a>.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Error code: <code>MalformedXMLError</code>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>Description: The XML provided does not match the schema.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Error code: <code>OperationAbortedError </code>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>Description: A conflicting conditional action is currently in progress against this
    /// resource. Try again.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Error code: <code>InternalError</code>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>Description: The service was unable to apply the provided tag to the bucket.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// <p>All Amazon S3 on Outposts REST API requests for this action require an additional parameter of <code>x-amz-outpost-id</code> to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of <code>s3-control</code>. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the <code>x-amz-outpost-id</code> derived using the access point ARN, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html#API_control_PutBucketTagging_Examples">Examples</a> section.</p>
    ///
    /// <p>The following actions are related to <code>PutBucketTagging</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketTagging.html">GetBucketTagging</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketTagging.html">DeleteBucketTagging</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct PutBucketTagging<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_bucket_tagging_input::Builder,
    }
    impl<C, M, R> PutBucketTagging<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutBucketTagging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBucketTaggingOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBucketTaggingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutBucketTaggingInputOperationOutputAlias,
                crate::output::PutBucketTaggingOutput,
                crate::error::PutBucketTaggingError,
                crate::input::PutBucketTaggingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID of the Outposts bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded.  </p>
        pub fn bucket(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
        /// <p>For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well.</p>
        /// <p>For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must  specify the ARN of the bucket accessed in the format <code>arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name></code>. For example, to access the bucket <code>reports</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports</code>. The value must be URL encoded.  </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p></p>
        pub fn tagging(mut self, inp: crate::model::Tagging) -> Self {
            self.inner = self.inner.tagging(inp);
            self
        }
        /// <p></p>
        pub fn set_tagging(mut self, input: std::option::Option<crate::model::Tagging>) -> Self {
            self.inner = self.inner.set_tagging(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutJobTagging`.
    ///
    /// <p>Sets the supplied tag-set on an S3 Batch Operations job.</p>
    /// <p>A tag is a key-value pair. You can associate S3 Batch Operations tags with any job by sending
    /// a PUT request against the tagging subresource that is associated with the job. To modify
    /// the existing tag set, you can either replace the existing tag set entirely, or make changes
    /// within the existing tag set by retrieving the existing tag set using <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetJobTagging.html">GetJobTagging</a>, modify that tag set, and use this action to replace the
    /// tag set with the one you modified. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags">Controlling access and
    /// labeling jobs using tags</a> in the <i>Amazon S3 User Guide</i>. </p>
    /// <p></p>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>If you send this request with an empty tag set, Amazon S3 deletes the existing tag set on the
    /// Batch Operations job. If you use this method, you are charged for a Tier 1 Request
    /// (PUT). For more information, see <a href="http://aws.amazon.com/s3/pricing/">Amazon S3
    /// pricing</a>.</p>
    /// </li>
    /// <li>
    /// <p>For deleting existing tags for your Batch Operations job, a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteJobTagging.html">DeleteJobTagging</a>
    /// request is preferred because it achieves the same result without incurring
    /// charges.</p>
    /// </li>
    /// <li>
    /// <p>A few things to consider about using tags:</p>
    /// <ul>
    /// <li>
    /// <p>Amazon S3 limits the maximum number of tags to 50 tags per job.</p>
    /// </li>
    /// <li>
    /// <p>You can associate up to 50 tags with a job as long as they have unique tag keys.</p>
    /// </li>
    /// <li>
    /// <p>A tag key can be up to 128 Unicode characters in length, and tag values can be up to 256 Unicode characters in length.</p>
    /// </li>
    /// <li>
    /// <p>The key and values are case sensitive.</p>
    /// </li>
    /// <li>
    /// <p>For tagging-related restrictions related to characters and encodings, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html">User-Defined Tag Restrictions</a> in the <i>Billing and Cost Management User Guide</i>.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// </note>
    /// <p></p>
    /// <p>To use this action, you must have permission to perform the <code>s3:PutJobTagging</code> action.</p>
    /// <p>Related actions include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreatJob</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetJobTagging.html">GetJobTagging</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteJobTagging.html">DeleteJobTagging</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct PutJobTagging<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_job_tagging_input::Builder,
    }
    impl<C, M, R> PutJobTagging<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutJobTagging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutJobTaggingOutput,
            aws_smithy_http::result::SdkError<crate::error::PutJobTaggingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutJobTaggingInputOperationOutputAlias,
                crate::output::PutJobTaggingOutput,
                crate::error::PutJobTaggingError,
                crate::input::PutJobTaggingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The ID for the S3 Batch Operations job whose tags you want to replace.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The ID for the S3 Batch Operations job whose tags you want to replace.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The set of tags to associate with the S3 Batch Operations job.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::S3Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The set of tags to associate with the S3 Batch Operations job.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::S3Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutMultiRegionAccessPointPolicy`.
    ///
    /// <p>Associates an access control policy with the specified Multi-Region Access Point. Each Multi-Region Access Point can have only
    /// one policy, so a request made to this action replaces any existing policy that is
    /// associated with the specified Multi-Region Access Point.</p>
    /// <p>This action will always be routed to the US West (Oregon) Region. For more
    /// information about the restrictions around managing Multi-Region Access Points, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html">Managing
    /// Multi-Region Access Points</a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// <p>The following actions are related to <code>PutMultiRegionAccessPointPolicy</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicy.html">GetMultiRegionAccessPointPolicy</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetMultiRegionAccessPointPolicyStatus.html">GetMultiRegionAccessPointPolicyStatus</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct PutMultiRegionAccessPointPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_multi_region_access_point_policy_input::Builder,
    }
    impl<C, M, R> PutMultiRegionAccessPointPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutMultiRegionAccessPointPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutMultiRegionAccessPointPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutMultiRegionAccessPointPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutMultiRegionAccessPointPolicyInputOperationOutputAlias,
                crate::output::PutMultiRegionAccessPointPolicyOutput,
                crate::error::PutMultiRegionAccessPointPolicyError,
                crate::input::PutMultiRegionAccessPointPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID for the owner of the Multi-Region Access Point.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>An idempotency token used to identify the request and guarantee that requests are
        /// unique.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>An idempotency token used to identify the request and guarantee that requests are
        /// unique.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>A container element containing the details of the policy for the Multi-Region Access Point.</p>
        pub fn details(mut self, inp: crate::model::PutMultiRegionAccessPointPolicyInput) -> Self {
            self.inner = self.inner.details(inp);
            self
        }
        /// <p>A container element containing the details of the policy for the Multi-Region Access Point.</p>
        pub fn set_details(
            mut self,
            input: std::option::Option<crate::model::PutMultiRegionAccessPointPolicyInput>,
        ) -> Self {
            self.inner = self.inner.set_details(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutPublicAccessBlock`.
    ///
    /// <p>Creates or modifies the <code>PublicAccessBlock</code> configuration for an Amazon Web Services account. For
    /// more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html"> Using Amazon S3 block
    /// public access</a>.</p>
    /// <p>Related actions include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetPublicAccessBlock.html">GetPublicAccessBlock</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeletePublicAccessBlock.html">DeletePublicAccessBlock</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct PutPublicAccessBlock<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_public_access_block_input::Builder,
    }
    impl<C, M, R> PutPublicAccessBlock<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutPublicAccessBlock`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutPublicAccessBlockOutput,
            aws_smithy_http::result::SdkError<crate::error::PutPublicAccessBlockError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutPublicAccessBlockInputOperationOutputAlias,
                crate::output::PutPublicAccessBlockOutput,
                crate::error::PutPublicAccessBlockError,
                crate::input::PutPublicAccessBlockInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want
        /// to set.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID for the Amazon Web Services account whose <code>PublicAccessBlock</code> configuration you want
        /// to set.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The <code>PublicAccessBlock</code> configuration that you want to apply to the specified Amazon Web Services account.</p>
        pub fn public_access_block_configuration(
            mut self,
            inp: crate::model::PublicAccessBlockConfiguration,
        ) -> Self {
            self.inner = self.inner.public_access_block_configuration(inp);
            self
        }
        /// <p>The <code>PublicAccessBlock</code> configuration that you want to apply to the specified Amazon Web Services account.</p>
        pub fn set_public_access_block_configuration(
            mut self,
            input: std::option::Option<crate::model::PublicAccessBlockConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_public_access_block_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutStorageLensConfiguration`.
    ///
    /// <p>Puts an Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Working with
    /// Amazon S3 Storage Lens</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <note>
    /// <p>To use this action,
    /// you must have permission to perform the <code>s3:PutStorageLensConfiguration</code> action. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to use Amazon S3 Storage Lens</a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct PutStorageLensConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_storage_lens_configuration_input::Builder,
    }
    impl<C, M, R> PutStorageLensConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutStorageLensConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutStorageLensConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutStorageLensConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutStorageLensConfigurationInputOperationOutputAlias,
                crate::output::PutStorageLensConfigurationOutput,
                crate::error::PutStorageLensConfigurationError,
                crate::input::PutStorageLensConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the S3 Storage Lens configuration.</p>
        pub fn config_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_id(inp);
            self
        }
        /// <p>The ID of the S3 Storage Lens configuration.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_config_id(input);
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The S3 Storage Lens configuration.</p>
        pub fn storage_lens_configuration(
            mut self,
            inp: crate::model::StorageLensConfiguration,
        ) -> Self {
            self.inner = self.inner.storage_lens_configuration(inp);
            self
        }
        /// <p>The S3 Storage Lens configuration.</p>
        pub fn set_storage_lens_configuration(
            mut self,
            input: std::option::Option<crate::model::StorageLensConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_storage_lens_configuration(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag set of the S3 Storage Lens configuration.</p>
        /// <note>
        /// <p>You can set up to a maximum of 50 tags.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::StorageLensTag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag set of the S3 Storage Lens configuration.</p>
        /// <note>
        /// <p>You can set up to a maximum of 50 tags.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StorageLensTag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutStorageLensConfigurationTagging`.
    ///
    /// <p>Put or replace tags on an existing Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens.html">Assessing your storage
    /// activity and usage with Amazon S3 Storage Lens </a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// <note>
    /// <p>To use this action,
    /// you must have permission to perform the <code>s3:PutStorageLensConfigurationTagging</code> action. For more
    /// information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage_lens_iam_permissions.html">Setting permissions to use Amazon S3 Storage Lens</a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct PutStorageLensConfigurationTagging<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_storage_lens_configuration_tagging_input::Builder,
    }
    impl<C, M, R> PutStorageLensConfigurationTagging<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutStorageLensConfigurationTagging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutStorageLensConfigurationTaggingOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutStorageLensConfigurationTaggingError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutStorageLensConfigurationTaggingInputOperationOutputAlias,
                crate::output::PutStorageLensConfigurationTaggingOutput,
                crate::error::PutStorageLensConfigurationTaggingError,
                crate::input::PutStorageLensConfigurationTaggingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the S3 Storage Lens configuration.</p>
        pub fn config_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.config_id(inp);
            self
        }
        /// <p>The ID of the S3 Storage Lens configuration.</p>
        pub fn set_config_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_config_id(input);
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The account ID of the requester.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag set of the S3 Storage Lens configuration.</p>
        /// <note>
        /// <p>You can set up to a maximum of 50 tags.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::StorageLensTag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag set of the S3 Storage Lens configuration.</p>
        /// <note>
        /// <p>You can set up to a maximum of 50 tags.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StorageLensTag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateJobPriority`.
    ///
    /// <p>Updates an existing S3 Batch Operations job's priority. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-basics.html">S3 Batch Operations</a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// <p></p>
    /// <p>Related actions include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html">ListJobs</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html">DescribeJob</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html">UpdateJobStatus</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct UpdateJobPriority<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_job_priority_input::Builder,
    }
    impl<C, M, R> UpdateJobPriority<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateJobPriority`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateJobPriorityOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateJobPriorityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateJobPriorityInputOperationOutputAlias,
                crate::output::UpdateJobPriorityOutput,
                crate::error::UpdateJobPriorityError,
                crate::input::UpdateJobPriorityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The ID for the job whose priority you want to update.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The ID for the job whose priority you want to update.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The priority you want to assign to this job.</p>
        pub fn priority(mut self, inp: i32) -> Self {
            self.inner = self.inner.priority(inp);
            self
        }
        /// <p>The priority you want to assign to this job.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_priority(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateJobStatus`.
    ///
    /// <p>Updates the status for the specified job. Use this action to confirm that you want to
    /// run a job or to cancel an existing job. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-basics.html">S3 Batch Operations</a> in the
    /// <i>Amazon S3 User Guide</i>.</p>
    /// <p></p>
    /// <p>Related actions include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateJob.html">CreateJob</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListJobs.html">ListJobs</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DescribeJob.html">DescribeJob</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_UpdateJobStatus.html">UpdateJobStatus</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct UpdateJobStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_job_status_input::Builder,
    }
    impl<C, M, R> UpdateJobStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateJobStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateJobStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateJobStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateJobStatusInputOperationOutputAlias,
                crate::output::UpdateJobStatusOutput,
                crate::error::UpdateJobStatusError,
                crate::input::UpdateJobStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID associated with the S3 Batch Operations job.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The ID of the job whose status you want to update.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The ID of the job whose status you want to update.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The status that you want to move the specified job to.</p>
        pub fn requested_job_status(mut self, inp: crate::model::RequestedJobStatus) -> Self {
            self.inner = self.inner.requested_job_status(inp);
            self
        }
        /// <p>The status that you want to move the specified job to.</p>
        pub fn set_requested_job_status(
            mut self,
            input: std::option::Option<crate::model::RequestedJobStatus>,
        ) -> Self {
            self.inner = self.inner.set_requested_job_status(input);
            self
        }
        /// <p>A description of the reason why you want to change the specified job's status. This field can be any string up to the maximum length.</p>
        pub fn status_update_reason(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status_update_reason(inp);
            self
        }
        /// <p>A description of the reason why you want to change the specified job's status. This field can be any string up to the maximum length.</p>
        pub fn set_status_update_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_status_update_reason(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
