// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Simple Storage Service
///
/// Client for invoking operations on Amazon Simple Storage Service. Each operation on Amazon Simple Storage Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_s3::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_s3::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_s3::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AbortMultipartUpload`](crate::client::fluent_builders::AbortMultipartUpload) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::AbortMultipartUpload::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::AbortMultipartUpload::set_bucket): <p>The bucket name to which the upload was taking place. </p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>  <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`key(impl Into<String>)`](crate::client::fluent_builders::AbortMultipartUpload::key) / [`set_key(Option<String>)`](crate::client::fluent_builders::AbortMultipartUpload::set_key): <p>Key of the object for which the multipart upload was initiated.</p>
    ///   - [`upload_id(impl Into<String>)`](crate::client::fluent_builders::AbortMultipartUpload::upload_id) / [`set_upload_id(Option<String>)`](crate::client::fluent_builders::AbortMultipartUpload::set_upload_id): <p>Upload ID that identifies the multipart upload.</p>
    ///   - [`request_payer(RequestPayer)`](crate::client::fluent_builders::AbortMultipartUpload::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::client::fluent_builders::AbortMultipartUpload::set_request_payer): <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::AbortMultipartUpload::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::AbortMultipartUpload::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`AbortMultipartUploadOutput`](crate::output::AbortMultipartUploadOutput) with field(s):
    ///   - [`request_charged(Option<RequestCharged>)`](crate::output::AbortMultipartUploadOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p>
    /// - On failure, responds with [`SdkError<AbortMultipartUploadError>`](crate::error::AbortMultipartUploadError)
    pub fn abort_multipart_upload(&self) -> fluent_builders::AbortMultipartUpload {
        fluent_builders::AbortMultipartUpload::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CompleteMultipartUpload`](crate::client::fluent_builders::CompleteMultipartUpload) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::CompleteMultipartUpload::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::CompleteMultipartUpload::set_bucket): <p>Name of the bucket to which the multipart upload was initiated.</p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>  <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`key(impl Into<String>)`](crate::client::fluent_builders::CompleteMultipartUpload::key) / [`set_key(Option<String>)`](crate::client::fluent_builders::CompleteMultipartUpload::set_key): <p>Object key for which the multipart upload was initiated.</p>
    ///   - [`multipart_upload(CompletedMultipartUpload)`](crate::client::fluent_builders::CompleteMultipartUpload::multipart_upload) / [`set_multipart_upload(Option<CompletedMultipartUpload>)`](crate::client::fluent_builders::CompleteMultipartUpload::set_multipart_upload): <p>The container for the multipart upload request information.</p>
    ///   - [`upload_id(impl Into<String>)`](crate::client::fluent_builders::CompleteMultipartUpload::upload_id) / [`set_upload_id(Option<String>)`](crate::client::fluent_builders::CompleteMultipartUpload::set_upload_id): <p>ID for the initiated multipart upload.</p>
    ///   - [`request_payer(RequestPayer)`](crate::client::fluent_builders::CompleteMultipartUpload::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::client::fluent_builders::CompleteMultipartUpload::set_request_payer): <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::CompleteMultipartUpload::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::CompleteMultipartUpload::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`CompleteMultipartUploadOutput`](crate::output::CompleteMultipartUploadOutput) with field(s):
    ///   - [`location(Option<String>)`](crate::output::CompleteMultipartUploadOutput::location): <p>The URI that identifies the newly created object.</p>
    ///   - [`bucket(Option<String>)`](crate::output::CompleteMultipartUploadOutput::bucket): <p>The name of the bucket that contains the newly created object. Does not return the access point ARN or access point alias if used.</p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>  <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`key(Option<String>)`](crate::output::CompleteMultipartUploadOutput::key): <p>The object key of the newly created object.</p>
    ///   - [`expiration(Option<String>)`](crate::output::CompleteMultipartUploadOutput::expiration): <p>If the object expiration is configured, this will contain the expiration date (expiry-date) and rule ID (rule-id). The value of rule-id is URL encoded.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::CompleteMultipartUploadOutput::e_tag): <p>Entity tag that identifies the newly created object's data. Objects with different object data will have different entity tags. The entity tag is an opaque string. The entity tag may or may not be an MD5 digest of the object data. If the entity tag is not an MD5 digest of the object data, it will contain one or more nonhexadecimal characters and/or will consist of less than 32 or more than 32 hexadecimal digits.</p>
    ///   - [`server_side_encryption(Option<ServerSideEncryption>)`](crate::output::CompleteMultipartUploadOutput::server_side_encryption): <p>If you specified server-side encryption either with an Amazon S3-managed encryption key or an Amazon Web Services KMS key in your initiate multipart upload request, the response includes this header. It confirms the encryption algorithm that Amazon S3 used to encrypt the object.</p>
    ///   - [`version_id(Option<String>)`](crate::output::CompleteMultipartUploadOutput::version_id): <p>Version ID of the newly created object, in case the bucket has versioning turned on.</p>
    ///   - [`ssekms_key_id(Option<String>)`](crate::output::CompleteMultipartUploadOutput::ssekms_key_id): <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric customer managed key that was used for the object.</p>
    ///   - [`bucket_key_enabled(bool)`](crate::output::CompleteMultipartUploadOutput::bucket_key_enabled): <p>Indicates whether the multipart upload uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    ///   - [`request_charged(Option<RequestCharged>)`](crate::output::CompleteMultipartUploadOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p>
    /// - On failure, responds with [`SdkError<CompleteMultipartUploadError>`](crate::error::CompleteMultipartUploadError)
    pub fn complete_multipart_upload(&self) -> fluent_builders::CompleteMultipartUpload {
        fluent_builders::CompleteMultipartUpload::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CopyObject`](crate::client::fluent_builders::CopyObject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`acl(ObjectCannedAcl)`](crate::client::fluent_builders::CopyObject::acl) / [`set_acl(Option<ObjectCannedAcl>)`](crate::client::fluent_builders::CopyObject::set_acl): <p>The canned ACL to apply to the object.</p>  <p>This action is not supported by Amazon S3 on Outposts.</p>
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::CopyObject::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::CopyObject::set_bucket): <p>The name of the destination bucket.</p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>  <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`cache_control(impl Into<String>)`](crate::client::fluent_builders::CopyObject::cache_control) / [`set_cache_control(Option<String>)`](crate::client::fluent_builders::CopyObject::set_cache_control): <p>Specifies caching behavior along the request/reply chain.</p>
    ///   - [`content_disposition(impl Into<String>)`](crate::client::fluent_builders::CopyObject::content_disposition) / [`set_content_disposition(Option<String>)`](crate::client::fluent_builders::CopyObject::set_content_disposition): <p>Specifies presentational information for the object.</p>
    ///   - [`content_encoding(impl Into<String>)`](crate::client::fluent_builders::CopyObject::content_encoding) / [`set_content_encoding(Option<String>)`](crate::client::fluent_builders::CopyObject::set_content_encoding): <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>
    ///   - [`content_language(impl Into<String>)`](crate::client::fluent_builders::CopyObject::content_language) / [`set_content_language(Option<String>)`](crate::client::fluent_builders::CopyObject::set_content_language): <p>The language the content is in.</p>
    ///   - [`content_type(impl Into<String>)`](crate::client::fluent_builders::CopyObject::content_type) / [`set_content_type(Option<String>)`](crate::client::fluent_builders::CopyObject::set_content_type): <p>A standard MIME type describing the format of the object data.</p>
    ///   - [`copy_source(impl Into<String>)`](crate::client::fluent_builders::CopyObject::copy_source) / [`set_copy_source(Option<String>)`](crate::client::fluent_builders::CopyObject::set_copy_source): <p>Specifies the source object for the copy operation. You specify the value in one of two formats, depending on whether you want to access the source object through an <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">access point</a>:</p>  <ul>   <li> <p>For objects not accessed through an access point, specify the name of the source bucket and the key of the source object, separated by a slash (/). For example, to copy the object <code>reports/january.pdf</code> from the bucket <code>awsexamplebucket</code>, use <code>awsexamplebucket/reports/january.pdf</code>. The value must be URL encoded.</p> </li>   <li> <p>For objects accessed through access points, specify the Amazon Resource Name (ARN) of the object as accessed through the access point, in the format <code>arn:aws:s3:     <region>      :      <account-id>       :accesspoint/       <access-point-name>        /object/        <key></key>       </access-point-name>      </account-id>     </region></code>. For example, to copy the object <code>reports/january.pdf</code> through access point <code>my-access-point</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3:us-west-2:123456789012:accesspoint/my-access-point/object/reports/january.pdf</code>. The value must be URL encoded.</p> <note>     <p>Amazon S3 supports copy operations using access points only when the source and destination buckets are in the same Amazon Web Services Region.</p>    </note> <p>Alternatively, for objects accessed through Amazon S3 on Outposts, specify the ARN of the object as accessed in the format <code>arn:aws:s3-outposts:     <region>      :      <account-id>       :outpost/       <outpost-id>        /object/        <key></key>       </outpost-id>      </account-id>     </region></code>. For example, to copy the object <code>reports/january.pdf</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/object/reports/january.pdf</code>. The value must be URL encoded. </p> </li>  </ul>  <p>To copy a specific version of an object, append <code>?versionId=   <version-id></version-id></code> to the value (for example, <code>awsexamplebucket/reports/january.pdf?versionId=QUpfdndhfd8438MNFDN93jdnJFkdmqnh893</code>). If you don't specify a version ID, Amazon S3 copies the latest version of the source object.</p>
    ///   - [`copy_source_if_match(impl Into<String>)`](crate::client::fluent_builders::CopyObject::copy_source_if_match) / [`set_copy_source_if_match(Option<String>)`](crate::client::fluent_builders::CopyObject::set_copy_source_if_match): <p>Copies the object if its entity tag (ETag) matches the specified tag.</p>
    ///   - [`copy_source_if_modified_since(DateTime)`](crate::client::fluent_builders::CopyObject::copy_source_if_modified_since) / [`set_copy_source_if_modified_since(Option<DateTime>)`](crate::client::fluent_builders::CopyObject::set_copy_source_if_modified_since): <p>Copies the object if it has been modified since the specified time.</p>
    ///   - [`copy_source_if_none_match(impl Into<String>)`](crate::client::fluent_builders::CopyObject::copy_source_if_none_match) / [`set_copy_source_if_none_match(Option<String>)`](crate::client::fluent_builders::CopyObject::set_copy_source_if_none_match): <p>Copies the object if its entity tag (ETag) is different than the specified ETag.</p>
    ///   - [`copy_source_if_unmodified_since(DateTime)`](crate::client::fluent_builders::CopyObject::copy_source_if_unmodified_since) / [`set_copy_source_if_unmodified_since(Option<DateTime>)`](crate::client::fluent_builders::CopyObject::set_copy_source_if_unmodified_since): <p>Copies the object if it hasn't been modified since the specified time.</p>
    ///   - [`expires(DateTime)`](crate::client::fluent_builders::CopyObject::expires) / [`set_expires(Option<DateTime>)`](crate::client::fluent_builders::CopyObject::set_expires): <p>The date and time at which the object is no longer cacheable.</p>
    ///   - [`grant_full_control(impl Into<String>)`](crate::client::fluent_builders::CopyObject::grant_full_control) / [`set_grant_full_control(Option<String>)`](crate::client::fluent_builders::CopyObject::set_grant_full_control): <p>Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p>  <p>This action is not supported by Amazon S3 on Outposts.</p>
    ///   - [`grant_read(impl Into<String>)`](crate::client::fluent_builders::CopyObject::grant_read) / [`set_grant_read(Option<String>)`](crate::client::fluent_builders::CopyObject::set_grant_read): <p>Allows grantee to read the object data and its metadata.</p>  <p>This action is not supported by Amazon S3 on Outposts.</p>
    ///   - [`grant_read_acp(impl Into<String>)`](crate::client::fluent_builders::CopyObject::grant_read_acp) / [`set_grant_read_acp(Option<String>)`](crate::client::fluent_builders::CopyObject::set_grant_read_acp): <p>Allows grantee to read the object ACL.</p>  <p>This action is not supported by Amazon S3 on Outposts.</p>
    ///   - [`grant_write_acp(impl Into<String>)`](crate::client::fluent_builders::CopyObject::grant_write_acp) / [`set_grant_write_acp(Option<String>)`](crate::client::fluent_builders::CopyObject::set_grant_write_acp): <p>Allows grantee to write the ACL for the applicable object.</p>  <p>This action is not supported by Amazon S3 on Outposts.</p>
    ///   - [`key(impl Into<String>)`](crate::client::fluent_builders::CopyObject::key) / [`set_key(Option<String>)`](crate::client::fluent_builders::CopyObject::set_key): <p>The key of the destination object.</p>
    ///   - [`metadata(HashMap<String, String>)`](crate::client::fluent_builders::CopyObject::metadata) / [`set_metadata(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CopyObject::set_metadata): <p>A map of metadata to store with the object in S3.</p>
    ///   - [`metadata_directive(MetadataDirective)`](crate::client::fluent_builders::CopyObject::metadata_directive) / [`set_metadata_directive(Option<MetadataDirective>)`](crate::client::fluent_builders::CopyObject::set_metadata_directive): <p>Specifies whether the metadata is copied from the source object or replaced with metadata provided in the request.</p>
    ///   - [`tagging_directive(TaggingDirective)`](crate::client::fluent_builders::CopyObject::tagging_directive) / [`set_tagging_directive(Option<TaggingDirective>)`](crate::client::fluent_builders::CopyObject::set_tagging_directive): <p>Specifies whether the object tag-set are copied from the source object or replaced with tag-set provided in the request.</p>
    ///   - [`server_side_encryption(ServerSideEncryption)`](crate::client::fluent_builders::CopyObject::server_side_encryption) / [`set_server_side_encryption(Option<ServerSideEncryption>)`](crate::client::fluent_builders::CopyObject::set_server_side_encryption): <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>
    ///   - [`storage_class(StorageClass)`](crate::client::fluent_builders::CopyObject::storage_class) / [`set_storage_class(Option<StorageClass>)`](crate::client::fluent_builders::CopyObject::set_storage_class): <p>By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. Amazon S3 on Outposts only uses the OUTPOSTS Storage Class. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`website_redirect_location(impl Into<String>)`](crate::client::fluent_builders::CopyObject::website_redirect_location) / [`set_website_redirect_location(Option<String>)`](crate::client::fluent_builders::CopyObject::set_website_redirect_location): <p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p>
    ///   - [`sse_customer_algorithm(impl Into<String>)`](crate::client::fluent_builders::CopyObject::sse_customer_algorithm) / [`set_sse_customer_algorithm(Option<String>)`](crate::client::fluent_builders::CopyObject::set_sse_customer_algorithm): <p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>
    ///   - [`sse_customer_key(impl Into<String>)`](crate::client::fluent_builders::CopyObject::sse_customer_key) / [`set_sse_customer_key(Option<String>)`](crate::client::fluent_builders::CopyObject::set_sse_customer_key): <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
    ///   - [`sse_customer_key_md5(impl Into<String>)`](crate::client::fluent_builders::CopyObject::sse_customer_key_md5) / [`set_sse_customer_key_md5(Option<String>)`](crate::client::fluent_builders::CopyObject::set_sse_customer_key_md5): <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
    ///   - [`ssekms_key_id(impl Into<String>)`](crate::client::fluent_builders::CopyObject::ssekms_key_id) / [`set_ssekms_key_id(Option<String>)`](crate::client::fluent_builders::CopyObject::set_ssekms_key_id): <p>Specifies the Amazon Web Services KMS key ID to use for object encryption. All GET and PUT requests for an object protected by Amazon Web Services KMS will fail if not made via SSL or using SigV4. For information about configuring using any of the officially supported Amazon Web Services SDKs and Amazon Web Services CLI, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version">Specifying the Signature Version in Request Authentication</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`ssekms_encryption_context(impl Into<String>)`](crate::client::fluent_builders::CopyObject::ssekms_encryption_context) / [`set_ssekms_encryption_context(Option<String>)`](crate::client::fluent_builders::CopyObject::set_ssekms_encryption_context): <p>Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p>
    ///   - [`bucket_key_enabled(bool)`](crate::client::fluent_builders::CopyObject::bucket_key_enabled) / [`set_bucket_key_enabled(bool)`](crate::client::fluent_builders::CopyObject::set_bucket_key_enabled): <p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using AWS KMS (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS. </p>  <p>Specifying this header with a COPY action doesn’t affect bucket-level settings for S3 Bucket Key.</p>
    ///   - [`copy_source_sse_customer_algorithm(impl Into<String>)`](crate::client::fluent_builders::CopyObject::copy_source_sse_customer_algorithm) / [`set_copy_source_sse_customer_algorithm(Option<String>)`](crate::client::fluent_builders::CopyObject::set_copy_source_sse_customer_algorithm): <p>Specifies the algorithm to use when decrypting the source object (for example, AES256).</p>
    ///   - [`copy_source_sse_customer_key(impl Into<String>)`](crate::client::fluent_builders::CopyObject::copy_source_sse_customer_key) / [`set_copy_source_sse_customer_key(Option<String>)`](crate::client::fluent_builders::CopyObject::set_copy_source_sse_customer_key): <p>Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The encryption key provided in this header must be one that was used when the source object was created.</p>
    ///   - [`copy_source_sse_customer_key_md5(impl Into<String>)`](crate::client::fluent_builders::CopyObject::copy_source_sse_customer_key_md5) / [`set_copy_source_sse_customer_key_md5(Option<String>)`](crate::client::fluent_builders::CopyObject::set_copy_source_sse_customer_key_md5): <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
    ///   - [`request_payer(RequestPayer)`](crate::client::fluent_builders::CopyObject::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::client::fluent_builders::CopyObject::set_request_payer): <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`tagging(impl Into<String>)`](crate::client::fluent_builders::CopyObject::tagging) / [`set_tagging(Option<String>)`](crate::client::fluent_builders::CopyObject::set_tagging): <p>The tag-set for the object destination object this value must be used in conjunction with the <code>TaggingDirective</code>. The tag-set must be encoded as URL Query parameters.</p>
    ///   - [`object_lock_mode(ObjectLockMode)`](crate::client::fluent_builders::CopyObject::object_lock_mode) / [`set_object_lock_mode(Option<ObjectLockMode>)`](crate::client::fluent_builders::CopyObject::set_object_lock_mode): <p>The Object Lock mode that you want to apply to the copied object.</p>
    ///   - [`object_lock_retain_until_date(DateTime)`](crate::client::fluent_builders::CopyObject::object_lock_retain_until_date) / [`set_object_lock_retain_until_date(Option<DateTime>)`](crate::client::fluent_builders::CopyObject::set_object_lock_retain_until_date): <p>The date and time when you want the copied object's Object Lock to expire.</p>
    ///   - [`object_lock_legal_hold_status(ObjectLockLegalHoldStatus)`](crate::client::fluent_builders::CopyObject::object_lock_legal_hold_status) / [`set_object_lock_legal_hold_status(Option<ObjectLockLegalHoldStatus>)`](crate::client::fluent_builders::CopyObject::set_object_lock_legal_hold_status): <p>Specifies whether you want to apply a Legal Hold to the copied object.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::CopyObject::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::CopyObject::set_expected_bucket_owner): <p>The account ID of the expected destination bucket owner. If the destination bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    ///   - [`expected_source_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::CopyObject::expected_source_bucket_owner) / [`set_expected_source_bucket_owner(Option<String>)`](crate::client::fluent_builders::CopyObject::set_expected_source_bucket_owner): <p>The account ID of the expected source bucket owner. If the source bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`CopyObjectOutput`](crate::output::CopyObjectOutput) with field(s):
    ///   - [`copy_object_result(Option<CopyObjectResult>)`](crate::output::CopyObjectOutput::copy_object_result): <p>Container for all response elements.</p>
    ///   - [`expiration(Option<String>)`](crate::output::CopyObjectOutput::expiration): <p>If the object expiration is configured, the response includes this header.</p>
    ///   - [`copy_source_version_id(Option<String>)`](crate::output::CopyObjectOutput::copy_source_version_id): <p>Version of the copied object in the destination bucket.</p>
    ///   - [`version_id(Option<String>)`](crate::output::CopyObjectOutput::version_id): <p>Version ID of the newly created copy.</p>
    ///   - [`server_side_encryption(Option<ServerSideEncryption>)`](crate::output::CopyObjectOutput::server_side_encryption): <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>
    ///   - [`sse_customer_algorithm(Option<String>)`](crate::output::CopyObjectOutput::sse_customer_algorithm): <p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header confirming the encryption algorithm used.</p>
    ///   - [`sse_customer_key_md5(Option<String>)`](crate::output::CopyObjectOutput::sse_customer_key_md5): <p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header to provide round-trip message integrity verification of the customer-provided encryption key.</p>
    ///   - [`ssekms_key_id(Option<String>)`](crate::output::CopyObjectOutput::ssekms_key_id): <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric customer managed key that was used for the object.</p>
    ///   - [`ssekms_encryption_context(Option<String>)`](crate::output::CopyObjectOutput::ssekms_encryption_context): <p>If present, specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p>
    ///   - [`bucket_key_enabled(bool)`](crate::output::CopyObjectOutput::bucket_key_enabled): <p>Indicates whether the copied object uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    ///   - [`request_charged(Option<RequestCharged>)`](crate::output::CopyObjectOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p>
    /// - On failure, responds with [`SdkError<CopyObjectError>`](crate::error::CopyObjectError)
    pub fn copy_object(&self) -> fluent_builders::CopyObject {
        fluent_builders::CopyObject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateBucket`](crate::client::fluent_builders::CreateBucket) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`acl(BucketCannedAcl)`](crate::client::fluent_builders::CreateBucket::acl) / [`set_acl(Option<BucketCannedAcl>)`](crate::client::fluent_builders::CreateBucket::set_acl): <p>The canned ACL to apply to the bucket.</p>
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::CreateBucket::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::CreateBucket::set_bucket): <p>The name of the bucket to create.</p>
    ///   - [`create_bucket_configuration(CreateBucketConfiguration)`](crate::client::fluent_builders::CreateBucket::create_bucket_configuration) / [`set_create_bucket_configuration(Option<CreateBucketConfiguration>)`](crate::client::fluent_builders::CreateBucket::set_create_bucket_configuration): <p>The configuration information for the bucket.</p>
    ///   - [`grant_full_control(impl Into<String>)`](crate::client::fluent_builders::CreateBucket::grant_full_control) / [`set_grant_full_control(Option<String>)`](crate::client::fluent_builders::CreateBucket::set_grant_full_control): <p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p>
    ///   - [`grant_read(impl Into<String>)`](crate::client::fluent_builders::CreateBucket::grant_read) / [`set_grant_read(Option<String>)`](crate::client::fluent_builders::CreateBucket::set_grant_read): <p>Allows grantee to list the objects in the bucket.</p>
    ///   - [`grant_read_acp(impl Into<String>)`](crate::client::fluent_builders::CreateBucket::grant_read_acp) / [`set_grant_read_acp(Option<String>)`](crate::client::fluent_builders::CreateBucket::set_grant_read_acp): <p>Allows grantee to read the bucket ACL.</p>
    ///   - [`grant_write(impl Into<String>)`](crate::client::fluent_builders::CreateBucket::grant_write) / [`set_grant_write(Option<String>)`](crate::client::fluent_builders::CreateBucket::set_grant_write): <p>Allows grantee to create new objects in the bucket.</p>  <p>For the bucket and object owners of existing objects, also allows deletions and overwrites of those objects.</p>
    ///   - [`grant_write_acp(impl Into<String>)`](crate::client::fluent_builders::CreateBucket::grant_write_acp) / [`set_grant_write_acp(Option<String>)`](crate::client::fluent_builders::CreateBucket::set_grant_write_acp): <p>Allows grantee to write the ACL for the applicable bucket.</p>
    ///   - [`object_lock_enabled_for_bucket(bool)`](crate::client::fluent_builders::CreateBucket::object_lock_enabled_for_bucket) / [`set_object_lock_enabled_for_bucket(bool)`](crate::client::fluent_builders::CreateBucket::set_object_lock_enabled_for_bucket): <p>Specifies whether you want S3 Object Lock to be enabled for the new bucket.</p>
    ///   - [`object_ownership(ObjectOwnership)`](crate::client::fluent_builders::CreateBucket::object_ownership) / [`set_object_ownership(Option<ObjectOwnership>)`](crate::client::fluent_builders::CreateBucket::set_object_ownership): <p>The container element for object ownership for a bucket's ownership controls.</p>  <p>BucketOwnerPreferred - Objects uploaded to the bucket change ownership to the bucket owner if the objects are uploaded with the <code>bucket-owner-full-control</code> canned ACL.</p>  <p>ObjectWriter - The uploading account will own the object if the object is uploaded with the <code>bucket-owner-full-control</code> canned ACL.</p>  <p>BucketOwnerEnforced - Access control lists (ACLs) are disabled and no longer affect permissions. The bucket owner automatically owns and has full control over every object in the bucket. The bucket only accepts PUT requests that don't specify an ACL or bucket owner full control ACLs, such as the <code>bucket-owner-full-control</code> canned ACL or an equivalent form of this ACL expressed in the XML format.</p>
    /// - On success, responds with [`CreateBucketOutput`](crate::output::CreateBucketOutput) with field(s):
    ///   - [`location(Option<String>)`](crate::output::CreateBucketOutput::location): <p>Specifies the Region where the bucket will be created. If you are creating a bucket on the US East (N. Virginia) Region (us-east-1), you do not need to specify the location.</p>
    /// - On failure, responds with [`SdkError<CreateBucketError>`](crate::error::CreateBucketError)
    pub fn create_bucket(&self) -> fluent_builders::CreateBucket {
        fluent_builders::CreateBucket::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateMultipartUpload`](crate::client::fluent_builders::CreateMultipartUpload) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`acl(ObjectCannedAcl)`](crate::client::fluent_builders::CreateMultipartUpload::acl) / [`set_acl(Option<ObjectCannedAcl>)`](crate::client::fluent_builders::CreateMultipartUpload::set_acl): <p>The canned ACL to apply to the object.</p>  <p>This action is not supported by Amazon S3 on Outposts.</p>
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::CreateMultipartUpload::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::CreateMultipartUpload::set_bucket): <p>The name of the bucket to which to initiate the upload</p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>  <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`cache_control(impl Into<String>)`](crate::client::fluent_builders::CreateMultipartUpload::cache_control) / [`set_cache_control(Option<String>)`](crate::client::fluent_builders::CreateMultipartUpload::set_cache_control): <p>Specifies caching behavior along the request/reply chain.</p>
    ///   - [`content_disposition(impl Into<String>)`](crate::client::fluent_builders::CreateMultipartUpload::content_disposition) / [`set_content_disposition(Option<String>)`](crate::client::fluent_builders::CreateMultipartUpload::set_content_disposition): <p>Specifies presentational information for the object.</p>
    ///   - [`content_encoding(impl Into<String>)`](crate::client::fluent_builders::CreateMultipartUpload::content_encoding) / [`set_content_encoding(Option<String>)`](crate::client::fluent_builders::CreateMultipartUpload::set_content_encoding): <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>
    ///   - [`content_language(impl Into<String>)`](crate::client::fluent_builders::CreateMultipartUpload::content_language) / [`set_content_language(Option<String>)`](crate::client::fluent_builders::CreateMultipartUpload::set_content_language): <p>The language the content is in.</p>
    ///   - [`content_type(impl Into<String>)`](crate::client::fluent_builders::CreateMultipartUpload::content_type) / [`set_content_type(Option<String>)`](crate::client::fluent_builders::CreateMultipartUpload::set_content_type): <p>A standard MIME type describing the format of the object data.</p>
    ///   - [`expires(DateTime)`](crate::client::fluent_builders::CreateMultipartUpload::expires) / [`set_expires(Option<DateTime>)`](crate::client::fluent_builders::CreateMultipartUpload::set_expires): <p>The date and time at which the object is no longer cacheable.</p>
    ///   - [`grant_full_control(impl Into<String>)`](crate::client::fluent_builders::CreateMultipartUpload::grant_full_control) / [`set_grant_full_control(Option<String>)`](crate::client::fluent_builders::CreateMultipartUpload::set_grant_full_control): <p>Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p>  <p>This action is not supported by Amazon S3 on Outposts.</p>
    ///   - [`grant_read(impl Into<String>)`](crate::client::fluent_builders::CreateMultipartUpload::grant_read) / [`set_grant_read(Option<String>)`](crate::client::fluent_builders::CreateMultipartUpload::set_grant_read): <p>Allows grantee to read the object data and its metadata.</p>  <p>This action is not supported by Amazon S3 on Outposts.</p>
    ///   - [`grant_read_acp(impl Into<String>)`](crate::client::fluent_builders::CreateMultipartUpload::grant_read_acp) / [`set_grant_read_acp(Option<String>)`](crate::client::fluent_builders::CreateMultipartUpload::set_grant_read_acp): <p>Allows grantee to read the object ACL.</p>  <p>This action is not supported by Amazon S3 on Outposts.</p>
    ///   - [`grant_write_acp(impl Into<String>)`](crate::client::fluent_builders::CreateMultipartUpload::grant_write_acp) / [`set_grant_write_acp(Option<String>)`](crate::client::fluent_builders::CreateMultipartUpload::set_grant_write_acp): <p>Allows grantee to write the ACL for the applicable object.</p>  <p>This action is not supported by Amazon S3 on Outposts.</p>
    ///   - [`key(impl Into<String>)`](crate::client::fluent_builders::CreateMultipartUpload::key) / [`set_key(Option<String>)`](crate::client::fluent_builders::CreateMultipartUpload::set_key): <p>Object key for which the multipart upload is to be initiated.</p>
    ///   - [`metadata(HashMap<String, String>)`](crate::client::fluent_builders::CreateMultipartUpload::metadata) / [`set_metadata(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateMultipartUpload::set_metadata): <p>A map of metadata to store with the object in S3.</p>
    ///   - [`server_side_encryption(ServerSideEncryption)`](crate::client::fluent_builders::CreateMultipartUpload::server_side_encryption) / [`set_server_side_encryption(Option<ServerSideEncryption>)`](crate::client::fluent_builders::CreateMultipartUpload::set_server_side_encryption): <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>
    ///   - [`storage_class(StorageClass)`](crate::client::fluent_builders::CreateMultipartUpload::storage_class) / [`set_storage_class(Option<StorageClass>)`](crate::client::fluent_builders::CreateMultipartUpload::set_storage_class): <p>By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. Amazon S3 on Outposts only uses the OUTPOSTS Storage Class. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`website_redirect_location(impl Into<String>)`](crate::client::fluent_builders::CreateMultipartUpload::website_redirect_location) / [`set_website_redirect_location(Option<String>)`](crate::client::fluent_builders::CreateMultipartUpload::set_website_redirect_location): <p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p>
    ///   - [`sse_customer_algorithm(impl Into<String>)`](crate::client::fluent_builders::CreateMultipartUpload::sse_customer_algorithm) / [`set_sse_customer_algorithm(Option<String>)`](crate::client::fluent_builders::CreateMultipartUpload::set_sse_customer_algorithm): <p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>
    ///   - [`sse_customer_key(impl Into<String>)`](crate::client::fluent_builders::CreateMultipartUpload::sse_customer_key) / [`set_sse_customer_key(Option<String>)`](crate::client::fluent_builders::CreateMultipartUpload::set_sse_customer_key): <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
    ///   - [`sse_customer_key_md5(impl Into<String>)`](crate::client::fluent_builders::CreateMultipartUpload::sse_customer_key_md5) / [`set_sse_customer_key_md5(Option<String>)`](crate::client::fluent_builders::CreateMultipartUpload::set_sse_customer_key_md5): <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
    ///   - [`ssekms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateMultipartUpload::ssekms_key_id) / [`set_ssekms_key_id(Option<String>)`](crate::client::fluent_builders::CreateMultipartUpload::set_ssekms_key_id): <p>Specifies the ID of the symmetric customer managed key to use for object encryption. All GET and PUT requests for an object protected by Amazon Web Services KMS will fail if not made via SSL or using SigV4. For information about configuring using any of the officially supported Amazon Web Services SDKs and Amazon Web Services CLI, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version">Specifying the Signature Version in Request Authentication</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`ssekms_encryption_context(impl Into<String>)`](crate::client::fluent_builders::CreateMultipartUpload::ssekms_encryption_context) / [`set_ssekms_encryption_context(Option<String>)`](crate::client::fluent_builders::CreateMultipartUpload::set_ssekms_encryption_context): <p>Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p>
    ///   - [`bucket_key_enabled(bool)`](crate::client::fluent_builders::CreateMultipartUpload::bucket_key_enabled) / [`set_bucket_key_enabled(bool)`](crate::client::fluent_builders::CreateMultipartUpload::set_bucket_key_enabled): <p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using AWS KMS (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.</p>  <p>Specifying this header with an object action doesn’t affect bucket-level settings for S3 Bucket Key.</p>
    ///   - [`request_payer(RequestPayer)`](crate::client::fluent_builders::CreateMultipartUpload::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::client::fluent_builders::CreateMultipartUpload::set_request_payer): <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`tagging(impl Into<String>)`](crate::client::fluent_builders::CreateMultipartUpload::tagging) / [`set_tagging(Option<String>)`](crate::client::fluent_builders::CreateMultipartUpload::set_tagging): <p>The tag-set for the object. The tag-set must be encoded as URL Query parameters.</p>
    ///   - [`object_lock_mode(ObjectLockMode)`](crate::client::fluent_builders::CreateMultipartUpload::object_lock_mode) / [`set_object_lock_mode(Option<ObjectLockMode>)`](crate::client::fluent_builders::CreateMultipartUpload::set_object_lock_mode): <p>Specifies the Object Lock mode that you want to apply to the uploaded object.</p>
    ///   - [`object_lock_retain_until_date(DateTime)`](crate::client::fluent_builders::CreateMultipartUpload::object_lock_retain_until_date) / [`set_object_lock_retain_until_date(Option<DateTime>)`](crate::client::fluent_builders::CreateMultipartUpload::set_object_lock_retain_until_date): <p>Specifies the date and time when you want the Object Lock to expire.</p>
    ///   - [`object_lock_legal_hold_status(ObjectLockLegalHoldStatus)`](crate::client::fluent_builders::CreateMultipartUpload::object_lock_legal_hold_status) / [`set_object_lock_legal_hold_status(Option<ObjectLockLegalHoldStatus>)`](crate::client::fluent_builders::CreateMultipartUpload::set_object_lock_legal_hold_status): <p>Specifies whether you want to apply a Legal Hold to the uploaded object.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::CreateMultipartUpload::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::CreateMultipartUpload::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`CreateMultipartUploadOutput`](crate::output::CreateMultipartUploadOutput) with field(s):
    ///   - [`abort_date(Option<DateTime>)`](crate::output::CreateMultipartUploadOutput::abort_date): <p>If the bucket has a lifecycle rule configured with an action to abort incomplete multipart uploads and the prefix in the lifecycle rule matches the object name in the request, the response includes this header. The header indicates when the initiated multipart upload becomes eligible for an abort operation. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config"> Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Policy</a>.</p>  <p>The response also includes the <code>x-amz-abort-rule-id</code> header that provides the ID of the lifecycle configuration rule that defines this action.</p>
    ///   - [`abort_rule_id(Option<String>)`](crate::output::CreateMultipartUploadOutput::abort_rule_id): <p>This header is returned along with the <code>x-amz-abort-date</code> header. It identifies the applicable lifecycle configuration rule that defines the action to abort incomplete multipart uploads.</p>
    ///   - [`bucket(Option<String>)`](crate::output::CreateMultipartUploadOutput::bucket): <p>The name of the bucket to which the multipart upload was initiated. Does not return the access point ARN or access point alias if used.</p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>  <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`key(Option<String>)`](crate::output::CreateMultipartUploadOutput::key): <p>Object key for which the multipart upload was initiated.</p>
    ///   - [`upload_id(Option<String>)`](crate::output::CreateMultipartUploadOutput::upload_id): <p>ID for the initiated multipart upload.</p>
    ///   - [`server_side_encryption(Option<ServerSideEncryption>)`](crate::output::CreateMultipartUploadOutput::server_side_encryption): <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>
    ///   - [`sse_customer_algorithm(Option<String>)`](crate::output::CreateMultipartUploadOutput::sse_customer_algorithm): <p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header confirming the encryption algorithm used.</p>
    ///   - [`sse_customer_key_md5(Option<String>)`](crate::output::CreateMultipartUploadOutput::sse_customer_key_md5): <p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header to provide round-trip message integrity verification of the customer-provided encryption key.</p>
    ///   - [`ssekms_key_id(Option<String>)`](crate::output::CreateMultipartUploadOutput::ssekms_key_id): <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric customer managed key that was used for the object.</p>
    ///   - [`ssekms_encryption_context(Option<String>)`](crate::output::CreateMultipartUploadOutput::ssekms_encryption_context): <p>If present, specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p>
    ///   - [`bucket_key_enabled(bool)`](crate::output::CreateMultipartUploadOutput::bucket_key_enabled): <p>Indicates whether the multipart upload uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    ///   - [`request_charged(Option<RequestCharged>)`](crate::output::CreateMultipartUploadOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p>
    /// - On failure, responds with [`SdkError<CreateMultipartUploadError>`](crate::error::CreateMultipartUploadError)
    pub fn create_multipart_upload(&self) -> fluent_builders::CreateMultipartUpload {
        fluent_builders::CreateMultipartUpload::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBucket`](crate::client::fluent_builders::DeleteBucket) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::DeleteBucket::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::DeleteBucket::set_bucket): <p>Specifies the bucket being deleted.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::DeleteBucket::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::DeleteBucket::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`DeleteBucketOutput`](crate::output::DeleteBucketOutput)

    /// - On failure, responds with [`SdkError<DeleteBucketError>`](crate::error::DeleteBucketError)
    pub fn delete_bucket(&self) -> fluent_builders::DeleteBucket {
        fluent_builders::DeleteBucket::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBucketAnalyticsConfiguration`](crate::client::fluent_builders::DeleteBucketAnalyticsConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketAnalyticsConfiguration::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::DeleteBucketAnalyticsConfiguration::set_bucket): <p>The name of the bucket from which an analytics configuration is deleted.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketAnalyticsConfiguration::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteBucketAnalyticsConfiguration::set_id): <p>The ID that identifies the analytics configuration.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketAnalyticsConfiguration::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::DeleteBucketAnalyticsConfiguration::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`DeleteBucketAnalyticsConfigurationOutput`](crate::output::DeleteBucketAnalyticsConfigurationOutput)

    /// - On failure, responds with [`SdkError<DeleteBucketAnalyticsConfigurationError>`](crate::error::DeleteBucketAnalyticsConfigurationError)
    pub fn delete_bucket_analytics_configuration(
        &self,
    ) -> fluent_builders::DeleteBucketAnalyticsConfiguration {
        fluent_builders::DeleteBucketAnalyticsConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBucketCors`](crate::client::fluent_builders::DeleteBucketCors) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketCors::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::DeleteBucketCors::set_bucket): <p>Specifies the bucket whose <code>cors</code> configuration is being deleted.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketCors::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::DeleteBucketCors::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`DeleteBucketCorsOutput`](crate::output::DeleteBucketCorsOutput)

    /// - On failure, responds with [`SdkError<DeleteBucketCorsError>`](crate::error::DeleteBucketCorsError)
    pub fn delete_bucket_cors(&self) -> fluent_builders::DeleteBucketCors {
        fluent_builders::DeleteBucketCors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBucketEncryption`](crate::client::fluent_builders::DeleteBucketEncryption) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketEncryption::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::DeleteBucketEncryption::set_bucket): <p>The name of the bucket containing the server-side encryption configuration to delete.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketEncryption::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::DeleteBucketEncryption::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`DeleteBucketEncryptionOutput`](crate::output::DeleteBucketEncryptionOutput)

    /// - On failure, responds with [`SdkError<DeleteBucketEncryptionError>`](crate::error::DeleteBucketEncryptionError)
    pub fn delete_bucket_encryption(&self) -> fluent_builders::DeleteBucketEncryption {
        fluent_builders::DeleteBucketEncryption::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBucketIntelligentTieringConfiguration`](crate::client::fluent_builders::DeleteBucketIntelligentTieringConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketIntelligentTieringConfiguration::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::DeleteBucketIntelligentTieringConfiguration::set_bucket): <p>The name of the Amazon S3 bucket whose configuration you want to modify or retrieve.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketIntelligentTieringConfiguration::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteBucketIntelligentTieringConfiguration::set_id): <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
    /// - On success, responds with [`DeleteBucketIntelligentTieringConfigurationOutput`](crate::output::DeleteBucketIntelligentTieringConfigurationOutput)

    /// - On failure, responds with [`SdkError<DeleteBucketIntelligentTieringConfigurationError>`](crate::error::DeleteBucketIntelligentTieringConfigurationError)
    pub fn delete_bucket_intelligent_tiering_configuration(
        &self,
    ) -> fluent_builders::DeleteBucketIntelligentTieringConfiguration {
        fluent_builders::DeleteBucketIntelligentTieringConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBucketInventoryConfiguration`](crate::client::fluent_builders::DeleteBucketInventoryConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketInventoryConfiguration::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::DeleteBucketInventoryConfiguration::set_bucket): <p>The name of the bucket containing the inventory configuration to delete.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketInventoryConfiguration::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteBucketInventoryConfiguration::set_id): <p>The ID used to identify the inventory configuration.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketInventoryConfiguration::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::DeleteBucketInventoryConfiguration::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`DeleteBucketInventoryConfigurationOutput`](crate::output::DeleteBucketInventoryConfigurationOutput)

    /// - On failure, responds with [`SdkError<DeleteBucketInventoryConfigurationError>`](crate::error::DeleteBucketInventoryConfigurationError)
    pub fn delete_bucket_inventory_configuration(
        &self,
    ) -> fluent_builders::DeleteBucketInventoryConfiguration {
        fluent_builders::DeleteBucketInventoryConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBucketLifecycle`](crate::client::fluent_builders::DeleteBucketLifecycle) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketLifecycle::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::DeleteBucketLifecycle::set_bucket): <p>The bucket name of the lifecycle to delete.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketLifecycle::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::DeleteBucketLifecycle::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`DeleteBucketLifecycleOutput`](crate::output::DeleteBucketLifecycleOutput)

    /// - On failure, responds with [`SdkError<DeleteBucketLifecycleError>`](crate::error::DeleteBucketLifecycleError)
    pub fn delete_bucket_lifecycle(&self) -> fluent_builders::DeleteBucketLifecycle {
        fluent_builders::DeleteBucketLifecycle::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBucketMetricsConfiguration`](crate::client::fluent_builders::DeleteBucketMetricsConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketMetricsConfiguration::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::DeleteBucketMetricsConfiguration::set_bucket): <p>The name of the bucket containing the metrics configuration to delete.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketMetricsConfiguration::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteBucketMetricsConfiguration::set_id): <p>The ID used to identify the metrics configuration.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketMetricsConfiguration::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::DeleteBucketMetricsConfiguration::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`DeleteBucketMetricsConfigurationOutput`](crate::output::DeleteBucketMetricsConfigurationOutput)

    /// - On failure, responds with [`SdkError<DeleteBucketMetricsConfigurationError>`](crate::error::DeleteBucketMetricsConfigurationError)
    pub fn delete_bucket_metrics_configuration(
        &self,
    ) -> fluent_builders::DeleteBucketMetricsConfiguration {
        fluent_builders::DeleteBucketMetricsConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBucketOwnershipControls`](crate::client::fluent_builders::DeleteBucketOwnershipControls) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketOwnershipControls::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::DeleteBucketOwnershipControls::set_bucket): <p>The Amazon S3 bucket whose <code>OwnershipControls</code> you want to delete. </p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketOwnershipControls::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::DeleteBucketOwnershipControls::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`DeleteBucketOwnershipControlsOutput`](crate::output::DeleteBucketOwnershipControlsOutput)

    /// - On failure, responds with [`SdkError<DeleteBucketOwnershipControlsError>`](crate::error::DeleteBucketOwnershipControlsError)
    pub fn delete_bucket_ownership_controls(
        &self,
    ) -> fluent_builders::DeleteBucketOwnershipControls {
        fluent_builders::DeleteBucketOwnershipControls::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBucketPolicy`](crate::client::fluent_builders::DeleteBucketPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketPolicy::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::DeleteBucketPolicy::set_bucket): <p>The bucket name.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketPolicy::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::DeleteBucketPolicy::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`DeleteBucketPolicyOutput`](crate::output::DeleteBucketPolicyOutput)

    /// - On failure, responds with [`SdkError<DeleteBucketPolicyError>`](crate::error::DeleteBucketPolicyError)
    pub fn delete_bucket_policy(&self) -> fluent_builders::DeleteBucketPolicy {
        fluent_builders::DeleteBucketPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBucketReplication`](crate::client::fluent_builders::DeleteBucketReplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketReplication::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::DeleteBucketReplication::set_bucket): <p> The bucket name. </p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketReplication::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::DeleteBucketReplication::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`DeleteBucketReplicationOutput`](crate::output::DeleteBucketReplicationOutput)

    /// - On failure, responds with [`SdkError<DeleteBucketReplicationError>`](crate::error::DeleteBucketReplicationError)
    pub fn delete_bucket_replication(&self) -> fluent_builders::DeleteBucketReplication {
        fluent_builders::DeleteBucketReplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBucketTagging`](crate::client::fluent_builders::DeleteBucketTagging) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketTagging::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::DeleteBucketTagging::set_bucket): <p>The bucket that has the tag set to be removed.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketTagging::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::DeleteBucketTagging::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`DeleteBucketTaggingOutput`](crate::output::DeleteBucketTaggingOutput)

    /// - On failure, responds with [`SdkError<DeleteBucketTaggingError>`](crate::error::DeleteBucketTaggingError)
    pub fn delete_bucket_tagging(&self) -> fluent_builders::DeleteBucketTagging {
        fluent_builders::DeleteBucketTagging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBucketWebsite`](crate::client::fluent_builders::DeleteBucketWebsite) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketWebsite::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::DeleteBucketWebsite::set_bucket): <p>The bucket name for which you want to remove the website configuration. </p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::DeleteBucketWebsite::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::DeleteBucketWebsite::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`DeleteBucketWebsiteOutput`](crate::output::DeleteBucketWebsiteOutput)

    /// - On failure, responds with [`SdkError<DeleteBucketWebsiteError>`](crate::error::DeleteBucketWebsiteError)
    pub fn delete_bucket_website(&self) -> fluent_builders::DeleteBucketWebsite {
        fluent_builders::DeleteBucketWebsite::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteObject`](crate::client::fluent_builders::DeleteObject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::DeleteObject::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::DeleteObject::set_bucket): <p>The bucket name of the bucket containing the object. </p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>  <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`key(impl Into<String>)`](crate::client::fluent_builders::DeleteObject::key) / [`set_key(Option<String>)`](crate::client::fluent_builders::DeleteObject::set_key): <p>Key name of the object to delete.</p>
    ///   - [`mfa(impl Into<String>)`](crate::client::fluent_builders::DeleteObject::mfa) / [`set_mfa(Option<String>)`](crate::client::fluent_builders::DeleteObject::set_mfa): <p>The concatenation of the authentication device's serial number, a space, and the value that is displayed on your authentication device. Required to permanently delete a versioned object if versioning is configured with MFA delete enabled.</p>
    ///   - [`version_id(impl Into<String>)`](crate::client::fluent_builders::DeleteObject::version_id) / [`set_version_id(Option<String>)`](crate::client::fluent_builders::DeleteObject::set_version_id): <p>VersionId used to reference a specific version of the object.</p>
    ///   - [`request_payer(RequestPayer)`](crate::client::fluent_builders::DeleteObject::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::client::fluent_builders::DeleteObject::set_request_payer): <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`bypass_governance_retention(bool)`](crate::client::fluent_builders::DeleteObject::bypass_governance_retention) / [`set_bypass_governance_retention(bool)`](crate::client::fluent_builders::DeleteObject::set_bypass_governance_retention): <p>Indicates whether S3 Object Lock should bypass Governance-mode restrictions to process this operation. To use this header, you must have the <code>s3:PutBucketPublicAccessBlock</code> permission.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::DeleteObject::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::DeleteObject::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`DeleteObjectOutput`](crate::output::DeleteObjectOutput) with field(s):
    ///   - [`delete_marker(bool)`](crate::output::DeleteObjectOutput::delete_marker): <p>Specifies whether the versioned object that was permanently deleted was (true) or was not (false) a delete marker.</p>
    ///   - [`version_id(Option<String>)`](crate::output::DeleteObjectOutput::version_id): <p>Returns the version ID of the delete marker created as a result of the DELETE operation.</p>
    ///   - [`request_charged(Option<RequestCharged>)`](crate::output::DeleteObjectOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p>
    /// - On failure, responds with [`SdkError<DeleteObjectError>`](crate::error::DeleteObjectError)
    pub fn delete_object(&self) -> fluent_builders::DeleteObject {
        fluent_builders::DeleteObject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteObjects`](crate::client::fluent_builders::DeleteObjects) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::DeleteObjects::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::DeleteObjects::set_bucket): <p>The bucket name containing the objects to delete. </p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>  <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`delete(Delete)`](crate::client::fluent_builders::DeleteObjects::delete) / [`set_delete(Option<Delete>)`](crate::client::fluent_builders::DeleteObjects::set_delete): <p>Container for the request.</p>
    ///   - [`mfa(impl Into<String>)`](crate::client::fluent_builders::DeleteObjects::mfa) / [`set_mfa(Option<String>)`](crate::client::fluent_builders::DeleteObjects::set_mfa): <p>The concatenation of the authentication device's serial number, a space, and the value that is displayed on your authentication device. Required to permanently delete a versioned object if versioning is configured with MFA delete enabled.</p>
    ///   - [`request_payer(RequestPayer)`](crate::client::fluent_builders::DeleteObjects::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::client::fluent_builders::DeleteObjects::set_request_payer): <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`bypass_governance_retention(bool)`](crate::client::fluent_builders::DeleteObjects::bypass_governance_retention) / [`set_bypass_governance_retention(bool)`](crate::client::fluent_builders::DeleteObjects::set_bypass_governance_retention): <p>Specifies whether you want to delete this object even if it has a Governance-type Object Lock in place. To use this header, you must have the <code>s3:PutBucketPublicAccessBlock</code> permission.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::DeleteObjects::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::DeleteObjects::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`DeleteObjectsOutput`](crate::output::DeleteObjectsOutput) with field(s):
    ///   - [`deleted(Option<Vec<DeletedObject>>)`](crate::output::DeleteObjectsOutput::deleted): <p>Container element for a successful delete. It identifies the object that was successfully deleted.</p>
    ///   - [`request_charged(Option<RequestCharged>)`](crate::output::DeleteObjectsOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p>
    ///   - [`errors(Option<Vec<Error>>)`](crate::output::DeleteObjectsOutput::errors): <p>Container for a failed delete action that describes the object that Amazon S3 attempted to delete and the error it encountered.</p>
    /// - On failure, responds with [`SdkError<DeleteObjectsError>`](crate::error::DeleteObjectsError)
    pub fn delete_objects(&self) -> fluent_builders::DeleteObjects {
        fluent_builders::DeleteObjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteObjectTagging`](crate::client::fluent_builders::DeleteObjectTagging) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::DeleteObjectTagging::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::DeleteObjectTagging::set_bucket): <p>The bucket name containing the objects from which to remove the tags. </p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>  <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`key(impl Into<String>)`](crate::client::fluent_builders::DeleteObjectTagging::key) / [`set_key(Option<String>)`](crate::client::fluent_builders::DeleteObjectTagging::set_key): <p>The key that identifies the object in the bucket from which to remove all tags.</p>
    ///   - [`version_id(impl Into<String>)`](crate::client::fluent_builders::DeleteObjectTagging::version_id) / [`set_version_id(Option<String>)`](crate::client::fluent_builders::DeleteObjectTagging::set_version_id): <p>The versionId of the object that the tag-set will be removed from.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::DeleteObjectTagging::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::DeleteObjectTagging::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`DeleteObjectTaggingOutput`](crate::output::DeleteObjectTaggingOutput) with field(s):
    ///   - [`version_id(Option<String>)`](crate::output::DeleteObjectTaggingOutput::version_id): <p>The versionId of the object the tag-set was removed from.</p>
    /// - On failure, responds with [`SdkError<DeleteObjectTaggingError>`](crate::error::DeleteObjectTaggingError)
    pub fn delete_object_tagging(&self) -> fluent_builders::DeleteObjectTagging {
        fluent_builders::DeleteObjectTagging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePublicAccessBlock`](crate::client::fluent_builders::DeletePublicAccessBlock) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::DeletePublicAccessBlock::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::DeletePublicAccessBlock::set_bucket): <p>The Amazon S3 bucket whose <code>PublicAccessBlock</code> configuration you want to delete. </p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::DeletePublicAccessBlock::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::DeletePublicAccessBlock::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`DeletePublicAccessBlockOutput`](crate::output::DeletePublicAccessBlockOutput)

    /// - On failure, responds with [`SdkError<DeletePublicAccessBlockError>`](crate::error::DeletePublicAccessBlockError)
    pub fn delete_public_access_block(&self) -> fluent_builders::DeletePublicAccessBlock {
        fluent_builders::DeletePublicAccessBlock::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBucketAccelerateConfiguration`](crate::client::fluent_builders::GetBucketAccelerateConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetBucketAccelerateConfiguration::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetBucketAccelerateConfiguration::set_bucket): <p>The name of the bucket for which the accelerate configuration is retrieved.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::GetBucketAccelerateConfiguration::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::GetBucketAccelerateConfiguration::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`GetBucketAccelerateConfigurationOutput`](crate::output::GetBucketAccelerateConfigurationOutput) with field(s):
    ///   - [`status(Option<BucketAccelerateStatus>)`](crate::output::GetBucketAccelerateConfigurationOutput::status): <p>The accelerate configuration of the bucket.</p>
    /// - On failure, responds with [`SdkError<GetBucketAccelerateConfigurationError>`](crate::error::GetBucketAccelerateConfigurationError)
    pub fn get_bucket_accelerate_configuration(
        &self,
    ) -> fluent_builders::GetBucketAccelerateConfiguration {
        fluent_builders::GetBucketAccelerateConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBucketAcl`](crate::client::fluent_builders::GetBucketAcl) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetBucketAcl::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetBucketAcl::set_bucket): <p>Specifies the S3 bucket whose ACL is being requested.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::GetBucketAcl::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::GetBucketAcl::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`GetBucketAclOutput`](crate::output::GetBucketAclOutput) with field(s):
    ///   - [`owner(Option<Owner>)`](crate::output::GetBucketAclOutput::owner): <p>Container for the bucket owner's display name and ID.</p>
    ///   - [`grants(Option<Vec<Grant>>)`](crate::output::GetBucketAclOutput::grants): <p>A list of grants.</p>
    /// - On failure, responds with [`SdkError<GetBucketAclError>`](crate::error::GetBucketAclError)
    pub fn get_bucket_acl(&self) -> fluent_builders::GetBucketAcl {
        fluent_builders::GetBucketAcl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBucketAnalyticsConfiguration`](crate::client::fluent_builders::GetBucketAnalyticsConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetBucketAnalyticsConfiguration::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetBucketAnalyticsConfiguration::set_bucket): <p>The name of the bucket from which an analytics configuration is retrieved.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetBucketAnalyticsConfiguration::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetBucketAnalyticsConfiguration::set_id): <p>The ID that identifies the analytics configuration.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::GetBucketAnalyticsConfiguration::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::GetBucketAnalyticsConfiguration::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`GetBucketAnalyticsConfigurationOutput`](crate::output::GetBucketAnalyticsConfigurationOutput) with field(s):
    ///   - [`analytics_configuration(Option<AnalyticsConfiguration>)`](crate::output::GetBucketAnalyticsConfigurationOutput::analytics_configuration): <p>The configuration and any analyses for the analytics filter.</p>
    /// - On failure, responds with [`SdkError<GetBucketAnalyticsConfigurationError>`](crate::error::GetBucketAnalyticsConfigurationError)
    pub fn get_bucket_analytics_configuration(
        &self,
    ) -> fluent_builders::GetBucketAnalyticsConfiguration {
        fluent_builders::GetBucketAnalyticsConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBucketCors`](crate::client::fluent_builders::GetBucketCors) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetBucketCors::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetBucketCors::set_bucket): <p>The bucket name for which to get the cors configuration.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::GetBucketCors::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::GetBucketCors::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`GetBucketCorsOutput`](crate::output::GetBucketCorsOutput) with field(s):
    ///   - [`cors_rules(Option<Vec<CorsRule>>)`](crate::output::GetBucketCorsOutput::cors_rules): <p>A set of origins and methods (cross-origin access that you want to allow). You can add up to 100 rules to the configuration.</p>
    /// - On failure, responds with [`SdkError<GetBucketCorsError>`](crate::error::GetBucketCorsError)
    pub fn get_bucket_cors(&self) -> fluent_builders::GetBucketCors {
        fluent_builders::GetBucketCors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBucketEncryption`](crate::client::fluent_builders::GetBucketEncryption) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetBucketEncryption::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetBucketEncryption::set_bucket): <p>The name of the bucket from which the server-side encryption configuration is retrieved.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::GetBucketEncryption::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::GetBucketEncryption::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`GetBucketEncryptionOutput`](crate::output::GetBucketEncryptionOutput) with field(s):
    ///   - [`server_side_encryption_configuration(Option<ServerSideEncryptionConfiguration>)`](crate::output::GetBucketEncryptionOutput::server_side_encryption_configuration): <p>Specifies the default server-side-encryption configuration.</p>
    /// - On failure, responds with [`SdkError<GetBucketEncryptionError>`](crate::error::GetBucketEncryptionError)
    pub fn get_bucket_encryption(&self) -> fluent_builders::GetBucketEncryption {
        fluent_builders::GetBucketEncryption::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBucketIntelligentTieringConfiguration`](crate::client::fluent_builders::GetBucketIntelligentTieringConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetBucketIntelligentTieringConfiguration::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetBucketIntelligentTieringConfiguration::set_bucket): <p>The name of the Amazon S3 bucket whose configuration you want to modify or retrieve.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetBucketIntelligentTieringConfiguration::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetBucketIntelligentTieringConfiguration::set_id): <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
    /// - On success, responds with [`GetBucketIntelligentTieringConfigurationOutput`](crate::output::GetBucketIntelligentTieringConfigurationOutput) with field(s):
    ///   - [`intelligent_tiering_configuration(Option<IntelligentTieringConfiguration>)`](crate::output::GetBucketIntelligentTieringConfigurationOutput::intelligent_tiering_configuration): <p>Container for S3 Intelligent-Tiering configuration.</p>
    /// - On failure, responds with [`SdkError<GetBucketIntelligentTieringConfigurationError>`](crate::error::GetBucketIntelligentTieringConfigurationError)
    pub fn get_bucket_intelligent_tiering_configuration(
        &self,
    ) -> fluent_builders::GetBucketIntelligentTieringConfiguration {
        fluent_builders::GetBucketIntelligentTieringConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBucketInventoryConfiguration`](crate::client::fluent_builders::GetBucketInventoryConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetBucketInventoryConfiguration::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetBucketInventoryConfiguration::set_bucket): <p>The name of the bucket containing the inventory configuration to retrieve.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetBucketInventoryConfiguration::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetBucketInventoryConfiguration::set_id): <p>The ID used to identify the inventory configuration.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::GetBucketInventoryConfiguration::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::GetBucketInventoryConfiguration::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`GetBucketInventoryConfigurationOutput`](crate::output::GetBucketInventoryConfigurationOutput) with field(s):
    ///   - [`inventory_configuration(Option<InventoryConfiguration>)`](crate::output::GetBucketInventoryConfigurationOutput::inventory_configuration): <p>Specifies the inventory configuration.</p>
    /// - On failure, responds with [`SdkError<GetBucketInventoryConfigurationError>`](crate::error::GetBucketInventoryConfigurationError)
    pub fn get_bucket_inventory_configuration(
        &self,
    ) -> fluent_builders::GetBucketInventoryConfiguration {
        fluent_builders::GetBucketInventoryConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBucketLifecycleConfiguration`](crate::client::fluent_builders::GetBucketLifecycleConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetBucketLifecycleConfiguration::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetBucketLifecycleConfiguration::set_bucket): <p>The name of the bucket for which to get the lifecycle information.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::GetBucketLifecycleConfiguration::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::GetBucketLifecycleConfiguration::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`GetBucketLifecycleConfigurationOutput`](crate::output::GetBucketLifecycleConfigurationOutput) with field(s):
    ///   - [`rules(Option<Vec<LifecycleRule>>)`](crate::output::GetBucketLifecycleConfigurationOutput::rules): <p>Container for a lifecycle rule.</p>
    /// - On failure, responds with [`SdkError<GetBucketLifecycleConfigurationError>`](crate::error::GetBucketLifecycleConfigurationError)
    pub fn get_bucket_lifecycle_configuration(
        &self,
    ) -> fluent_builders::GetBucketLifecycleConfiguration {
        fluent_builders::GetBucketLifecycleConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBucketLocation`](crate::client::fluent_builders::GetBucketLocation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetBucketLocation::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetBucketLocation::set_bucket): <p>The name of the bucket for which to get the location.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::GetBucketLocation::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::GetBucketLocation::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`GetBucketLocationOutput`](crate::output::GetBucketLocationOutput) with field(s):
    ///   - [`location_constraint(Option<BucketLocationConstraint>)`](crate::output::GetBucketLocationOutput::location_constraint): <p>Specifies the Region where the bucket resides. For a list of all the Amazon S3 supported location constraints by Region, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a>. Buckets in Region <code>us-east-1</code> have a LocationConstraint of <code>null</code>.</p>
    /// - On failure, responds with [`SdkError<GetBucketLocationError>`](crate::error::GetBucketLocationError)
    pub fn get_bucket_location(&self) -> fluent_builders::GetBucketLocation {
        fluent_builders::GetBucketLocation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBucketLogging`](crate::client::fluent_builders::GetBucketLogging) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetBucketLogging::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetBucketLogging::set_bucket): <p>The bucket name for which to get the logging information.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::GetBucketLogging::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::GetBucketLogging::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`GetBucketLoggingOutput`](crate::output::GetBucketLoggingOutput) with field(s):
    ///   - [`logging_enabled(Option<LoggingEnabled>)`](crate::output::GetBucketLoggingOutput::logging_enabled): <p>Describes where logs are stored and the prefix that Amazon S3 assigns to all log object keys for a bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlogging.html">PUT Bucket logging</a> in the <i>Amazon S3 API Reference</i>.</p>
    /// - On failure, responds with [`SdkError<GetBucketLoggingError>`](crate::error::GetBucketLoggingError)
    pub fn get_bucket_logging(&self) -> fluent_builders::GetBucketLogging {
        fluent_builders::GetBucketLogging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBucketMetricsConfiguration`](crate::client::fluent_builders::GetBucketMetricsConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetBucketMetricsConfiguration::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetBucketMetricsConfiguration::set_bucket): <p>The name of the bucket containing the metrics configuration to retrieve.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetBucketMetricsConfiguration::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetBucketMetricsConfiguration::set_id): <p>The ID used to identify the metrics configuration.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::GetBucketMetricsConfiguration::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::GetBucketMetricsConfiguration::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`GetBucketMetricsConfigurationOutput`](crate::output::GetBucketMetricsConfigurationOutput) with field(s):
    ///   - [`metrics_configuration(Option<MetricsConfiguration>)`](crate::output::GetBucketMetricsConfigurationOutput::metrics_configuration): <p>Specifies the metrics configuration.</p>
    /// - On failure, responds with [`SdkError<GetBucketMetricsConfigurationError>`](crate::error::GetBucketMetricsConfigurationError)
    pub fn get_bucket_metrics_configuration(
        &self,
    ) -> fluent_builders::GetBucketMetricsConfiguration {
        fluent_builders::GetBucketMetricsConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBucketNotificationConfiguration`](crate::client::fluent_builders::GetBucketNotificationConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetBucketNotificationConfiguration::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetBucketNotificationConfiguration::set_bucket): <p>The name of the bucket for which to get the notification configuration.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::GetBucketNotificationConfiguration::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::GetBucketNotificationConfiguration::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`GetBucketNotificationConfigurationOutput`](crate::output::GetBucketNotificationConfigurationOutput) with field(s):
    ///   - [`topic_configurations(Option<Vec<TopicConfiguration>>)`](crate::output::GetBucketNotificationConfigurationOutput::topic_configurations): <p>The topic to which notifications are sent and the events for which notifications are generated.</p>
    ///   - [`queue_configurations(Option<Vec<QueueConfiguration>>)`](crate::output::GetBucketNotificationConfigurationOutput::queue_configurations): <p>The Amazon Simple Queue Service queues to publish messages to and the events for which to publish messages.</p>
    ///   - [`lambda_function_configurations(Option<Vec<LambdaFunctionConfiguration>>)`](crate::output::GetBucketNotificationConfigurationOutput::lambda_function_configurations): <p>Describes the Lambda functions to invoke and the events for which to invoke them.</p>
    ///   - [`event_bridge_configuration(Option<EventBridgeConfiguration>)`](crate::output::GetBucketNotificationConfigurationOutput::event_bridge_configuration): <p>Enables delivery of events to Amazon EventBridge.</p>
    /// - On failure, responds with [`SdkError<GetBucketNotificationConfigurationError>`](crate::error::GetBucketNotificationConfigurationError)
    pub fn get_bucket_notification_configuration(
        &self,
    ) -> fluent_builders::GetBucketNotificationConfiguration {
        fluent_builders::GetBucketNotificationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBucketOwnershipControls`](crate::client::fluent_builders::GetBucketOwnershipControls) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetBucketOwnershipControls::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetBucketOwnershipControls::set_bucket): <p>The name of the Amazon S3 bucket whose <code>OwnershipControls</code> you want to retrieve. </p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::GetBucketOwnershipControls::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::GetBucketOwnershipControls::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`GetBucketOwnershipControlsOutput`](crate::output::GetBucketOwnershipControlsOutput) with field(s):
    ///   - [`ownership_controls(Option<OwnershipControls>)`](crate::output::GetBucketOwnershipControlsOutput::ownership_controls): <p>The <code>OwnershipControls</code> (BucketOwnerEnforced, BucketOwnerPreferred, or ObjectWriter) currently in effect for this Amazon S3 bucket.</p>
    /// - On failure, responds with [`SdkError<GetBucketOwnershipControlsError>`](crate::error::GetBucketOwnershipControlsError)
    pub fn get_bucket_ownership_controls(&self) -> fluent_builders::GetBucketOwnershipControls {
        fluent_builders::GetBucketOwnershipControls::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBucketPolicy`](crate::client::fluent_builders::GetBucketPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetBucketPolicy::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetBucketPolicy::set_bucket): <p>The bucket name for which to get the bucket policy.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::GetBucketPolicy::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::GetBucketPolicy::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`GetBucketPolicyOutput`](crate::output::GetBucketPolicyOutput) with field(s):
    ///   - [`policy(Option<String>)`](crate::output::GetBucketPolicyOutput::policy): <p>The bucket policy as a JSON document.</p>
    /// - On failure, responds with [`SdkError<GetBucketPolicyError>`](crate::error::GetBucketPolicyError)
    pub fn get_bucket_policy(&self) -> fluent_builders::GetBucketPolicy {
        fluent_builders::GetBucketPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBucketPolicyStatus`](crate::client::fluent_builders::GetBucketPolicyStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetBucketPolicyStatus::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetBucketPolicyStatus::set_bucket): <p>The name of the Amazon S3 bucket whose policy status you want to retrieve.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::GetBucketPolicyStatus::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::GetBucketPolicyStatus::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`GetBucketPolicyStatusOutput`](crate::output::GetBucketPolicyStatusOutput) with field(s):
    ///   - [`policy_status(Option<PolicyStatus>)`](crate::output::GetBucketPolicyStatusOutput::policy_status): <p>The policy status for the specified bucket.</p>
    /// - On failure, responds with [`SdkError<GetBucketPolicyStatusError>`](crate::error::GetBucketPolicyStatusError)
    pub fn get_bucket_policy_status(&self) -> fluent_builders::GetBucketPolicyStatus {
        fluent_builders::GetBucketPolicyStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBucketReplication`](crate::client::fluent_builders::GetBucketReplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetBucketReplication::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetBucketReplication::set_bucket): <p>The bucket name for which to get the replication information.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::GetBucketReplication::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::GetBucketReplication::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`GetBucketReplicationOutput`](crate::output::GetBucketReplicationOutput) with field(s):
    ///   - [`replication_configuration(Option<ReplicationConfiguration>)`](crate::output::GetBucketReplicationOutput::replication_configuration): <p>A container for replication rules. You can add up to 1,000 rules. The maximum size of a replication configuration is 2 MB.</p>
    /// - On failure, responds with [`SdkError<GetBucketReplicationError>`](crate::error::GetBucketReplicationError)
    pub fn get_bucket_replication(&self) -> fluent_builders::GetBucketReplication {
        fluent_builders::GetBucketReplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBucketRequestPayment`](crate::client::fluent_builders::GetBucketRequestPayment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetBucketRequestPayment::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetBucketRequestPayment::set_bucket): <p>The name of the bucket for which to get the payment request configuration</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::GetBucketRequestPayment::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::GetBucketRequestPayment::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`GetBucketRequestPaymentOutput`](crate::output::GetBucketRequestPaymentOutput) with field(s):
    ///   - [`payer(Option<Payer>)`](crate::output::GetBucketRequestPaymentOutput::payer): <p>Specifies who pays for the download and request fees.</p>
    /// - On failure, responds with [`SdkError<GetBucketRequestPaymentError>`](crate::error::GetBucketRequestPaymentError)
    pub fn get_bucket_request_payment(&self) -> fluent_builders::GetBucketRequestPayment {
        fluent_builders::GetBucketRequestPayment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBucketTagging`](crate::client::fluent_builders::GetBucketTagging) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetBucketTagging::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetBucketTagging::set_bucket): <p>The name of the bucket for which to get the tagging information.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::GetBucketTagging::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::GetBucketTagging::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`GetBucketTaggingOutput`](crate::output::GetBucketTaggingOutput) with field(s):
    ///   - [`tag_set(Option<Vec<Tag>>)`](crate::output::GetBucketTaggingOutput::tag_set): <p>Contains the tag set.</p>
    /// - On failure, responds with [`SdkError<GetBucketTaggingError>`](crate::error::GetBucketTaggingError)
    pub fn get_bucket_tagging(&self) -> fluent_builders::GetBucketTagging {
        fluent_builders::GetBucketTagging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBucketVersioning`](crate::client::fluent_builders::GetBucketVersioning) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetBucketVersioning::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetBucketVersioning::set_bucket): <p>The name of the bucket for which to get the versioning information.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::GetBucketVersioning::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::GetBucketVersioning::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`GetBucketVersioningOutput`](crate::output::GetBucketVersioningOutput) with field(s):
    ///   - [`status(Option<BucketVersioningStatus>)`](crate::output::GetBucketVersioningOutput::status): <p>The versioning state of the bucket.</p>
    ///   - [`mfa_delete(Option<MfaDeleteStatus>)`](crate::output::GetBucketVersioningOutput::mfa_delete): <p>Specifies whether MFA delete is enabled in the bucket versioning configuration. This element is only returned if the bucket has been configured with MFA delete. If the bucket has never been so configured, this element is not returned.</p>
    /// - On failure, responds with [`SdkError<GetBucketVersioningError>`](crate::error::GetBucketVersioningError)
    pub fn get_bucket_versioning(&self) -> fluent_builders::GetBucketVersioning {
        fluent_builders::GetBucketVersioning::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBucketWebsite`](crate::client::fluent_builders::GetBucketWebsite) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetBucketWebsite::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetBucketWebsite::set_bucket): <p>The bucket name for which to get the website configuration.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::GetBucketWebsite::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::GetBucketWebsite::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`GetBucketWebsiteOutput`](crate::output::GetBucketWebsiteOutput) with field(s):
    ///   - [`redirect_all_requests_to(Option<RedirectAllRequestsTo>)`](crate::output::GetBucketWebsiteOutput::redirect_all_requests_to): <p>Specifies the redirect behavior of all requests to a website endpoint of an Amazon S3 bucket.</p>
    ///   - [`index_document(Option<IndexDocument>)`](crate::output::GetBucketWebsiteOutput::index_document): <p>The name of the index document for the website (for example <code>index.html</code>).</p>
    ///   - [`error_document(Option<ErrorDocument>)`](crate::output::GetBucketWebsiteOutput::error_document): <p>The object key name of the website error document to use for 4XX class errors.</p>
    ///   - [`routing_rules(Option<Vec<RoutingRule>>)`](crate::output::GetBucketWebsiteOutput::routing_rules): <p>Rules that define when a redirect is applied and the redirect behavior.</p>
    /// - On failure, responds with [`SdkError<GetBucketWebsiteError>`](crate::error::GetBucketWebsiteError)
    pub fn get_bucket_website(&self) -> fluent_builders::GetBucketWebsite {
        fluent_builders::GetBucketWebsite::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetObject`](crate::client::fluent_builders::GetObject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetObject::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetObject::set_bucket): <p>The bucket name containing the object. </p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>  <p>When using an Object Lambda access point the hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-object-lambda.<i>Region</i>.amazonaws.com.</p>  <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`if_match(impl Into<String>)`](crate::client::fluent_builders::GetObject::if_match) / [`set_if_match(Option<String>)`](crate::client::fluent_builders::GetObject::set_if_match): <p>Return the object only if its entity tag (ETag) is the same as the one specified, otherwise return a 412 (precondition failed).</p>
    ///   - [`if_modified_since(DateTime)`](crate::client::fluent_builders::GetObject::if_modified_since) / [`set_if_modified_since(Option<DateTime>)`](crate::client::fluent_builders::GetObject::set_if_modified_since): <p>Return the object only if it has been modified since the specified time, otherwise return a 304 (not modified).</p>
    ///   - [`if_none_match(impl Into<String>)`](crate::client::fluent_builders::GetObject::if_none_match) / [`set_if_none_match(Option<String>)`](crate::client::fluent_builders::GetObject::set_if_none_match): <p>Return the object only if its entity tag (ETag) is different from the one specified, otherwise return a 304 (not modified).</p>
    ///   - [`if_unmodified_since(DateTime)`](crate::client::fluent_builders::GetObject::if_unmodified_since) / [`set_if_unmodified_since(Option<DateTime>)`](crate::client::fluent_builders::GetObject::set_if_unmodified_since): <p>Return the object only if it has not been modified since the specified time, otherwise return a 412 (precondition failed).</p>
    ///   - [`key(impl Into<String>)`](crate::client::fluent_builders::GetObject::key) / [`set_key(Option<String>)`](crate::client::fluent_builders::GetObject::set_key): <p>Key of the object to get.</p>
    ///   - [`range(impl Into<String>)`](crate::client::fluent_builders::GetObject::range) / [`set_range(Option<String>)`](crate::client::fluent_builders::GetObject::set_range): <p>Downloads the specified range bytes of an object. For more information about the HTTP Range header, see <a href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35">https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35</a>.</p> <note>   <p>Amazon S3 doesn't support retrieving multiple ranges of data per <code>GET</code> request.</p>  </note>
    ///   - [`response_cache_control(impl Into<String>)`](crate::client::fluent_builders::GetObject::response_cache_control) / [`set_response_cache_control(Option<String>)`](crate::client::fluent_builders::GetObject::set_response_cache_control): <p>Sets the <code>Cache-Control</code> header of the response.</p>
    ///   - [`response_content_disposition(impl Into<String>)`](crate::client::fluent_builders::GetObject::response_content_disposition) / [`set_response_content_disposition(Option<String>)`](crate::client::fluent_builders::GetObject::set_response_content_disposition): <p>Sets the <code>Content-Disposition</code> header of the response</p>
    ///   - [`response_content_encoding(impl Into<String>)`](crate::client::fluent_builders::GetObject::response_content_encoding) / [`set_response_content_encoding(Option<String>)`](crate::client::fluent_builders::GetObject::set_response_content_encoding): <p>Sets the <code>Content-Encoding</code> header of the response.</p>
    ///   - [`response_content_language(impl Into<String>)`](crate::client::fluent_builders::GetObject::response_content_language) / [`set_response_content_language(Option<String>)`](crate::client::fluent_builders::GetObject::set_response_content_language): <p>Sets the <code>Content-Language</code> header of the response.</p>
    ///   - [`response_content_type(impl Into<String>)`](crate::client::fluent_builders::GetObject::response_content_type) / [`set_response_content_type(Option<String>)`](crate::client::fluent_builders::GetObject::set_response_content_type): <p>Sets the <code>Content-Type</code> header of the response.</p>
    ///   - [`response_expires(DateTime)`](crate::client::fluent_builders::GetObject::response_expires) / [`set_response_expires(Option<DateTime>)`](crate::client::fluent_builders::GetObject::set_response_expires): <p>Sets the <code>Expires</code> header of the response.</p>
    ///   - [`version_id(impl Into<String>)`](crate::client::fluent_builders::GetObject::version_id) / [`set_version_id(Option<String>)`](crate::client::fluent_builders::GetObject::set_version_id): <p>VersionId used to reference a specific version of the object.</p>
    ///   - [`sse_customer_algorithm(impl Into<String>)`](crate::client::fluent_builders::GetObject::sse_customer_algorithm) / [`set_sse_customer_algorithm(Option<String>)`](crate::client::fluent_builders::GetObject::set_sse_customer_algorithm): <p>Specifies the algorithm to use to when decrypting the object (for example, AES256).</p>
    ///   - [`sse_customer_key(impl Into<String>)`](crate::client::fluent_builders::GetObject::sse_customer_key) / [`set_sse_customer_key(Option<String>)`](crate::client::fluent_builders::GetObject::set_sse_customer_key): <p>Specifies the customer-provided encryption key for Amazon S3 used to encrypt the data. This value is used to decrypt the object when recovering it and must match the one used when storing the data. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
    ///   - [`sse_customer_key_md5(impl Into<String>)`](crate::client::fluent_builders::GetObject::sse_customer_key_md5) / [`set_sse_customer_key_md5(Option<String>)`](crate::client::fluent_builders::GetObject::set_sse_customer_key_md5): <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
    ///   - [`request_payer(RequestPayer)`](crate::client::fluent_builders::GetObject::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::client::fluent_builders::GetObject::set_request_payer): <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`part_number(i32)`](crate::client::fluent_builders::GetObject::part_number) / [`set_part_number(i32)`](crate::client::fluent_builders::GetObject::set_part_number): <p>Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a 'ranged' GET request for the part specified. Useful for downloading just a part of an object.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::GetObject::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::GetObject::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`GetObjectOutput`](crate::output::GetObjectOutput) with field(s):
    ///   - [`body(byte_stream::ByteStream)`](crate::output::GetObjectOutput::body): <p>Object data.</p>
    ///   - [`delete_marker(bool)`](crate::output::GetObjectOutput::delete_marker): <p>Specifies whether the object retrieved was (true) or was not (false) a Delete Marker. If false, this response header does not appear in the response.</p>
    ///   - [`accept_ranges(Option<String>)`](crate::output::GetObjectOutput::accept_ranges): <p>Indicates that a range of bytes was specified.</p>
    ///   - [`expiration(Option<String>)`](crate::output::GetObjectOutput::expiration): <p>If the object expiration is configured (see PUT Bucket lifecycle), the response includes this header. It includes the expiry-date and rule-id key-value pairs providing object expiration information. The value of the rule-id is URL encoded.</p>
    ///   - [`restore(Option<String>)`](crate::output::GetObjectOutput::restore): <p>Provides information about object restoration action and expiration time of the restored object copy.</p>
    ///   - [`last_modified(Option<DateTime>)`](crate::output::GetObjectOutput::last_modified): <p>Creation date of the object.</p>
    ///   - [`content_length(i64)`](crate::output::GetObjectOutput::content_length): <p>Size of the body in bytes.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::GetObjectOutput::e_tag): <p>An ETag is an opaque identifier assigned by a web server to a specific version of a resource found at a URL.</p>
    ///   - [`missing_meta(i32)`](crate::output::GetObjectOutput::missing_meta): <p>This is set to the number of metadata entries not returned in <code>x-amz-meta</code> headers. This can happen if you create metadata using an API like SOAP that supports more flexible metadata than the REST API. For example, using SOAP, you can create metadata whose values are not legal HTTP headers.</p>
    ///   - [`version_id(Option<String>)`](crate::output::GetObjectOutput::version_id): <p>Version of the object.</p>
    ///   - [`cache_control(Option<String>)`](crate::output::GetObjectOutput::cache_control): <p>Specifies caching behavior along the request/reply chain.</p>
    ///   - [`content_disposition(Option<String>)`](crate::output::GetObjectOutput::content_disposition): <p>Specifies presentational information for the object.</p>
    ///   - [`content_encoding(Option<String>)`](crate::output::GetObjectOutput::content_encoding): <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>
    ///   - [`content_language(Option<String>)`](crate::output::GetObjectOutput::content_language): <p>The language the content is in.</p>
    ///   - [`content_range(Option<String>)`](crate::output::GetObjectOutput::content_range): <p>The portion of the object returned in the response.</p>
    ///   - [`content_type(Option<String>)`](crate::output::GetObjectOutput::content_type): <p>A standard MIME type describing the format of the object data.</p>
    ///   - [`expires(Option<DateTime>)`](crate::output::GetObjectOutput::expires): <p>The date and time at which the object is no longer cacheable.</p>
    ///   - [`website_redirect_location(Option<String>)`](crate::output::GetObjectOutput::website_redirect_location): <p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p>
    ///   - [`server_side_encryption(Option<ServerSideEncryption>)`](crate::output::GetObjectOutput::server_side_encryption): <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>
    ///   - [`metadata(Option<HashMap<String, String>>)`](crate::output::GetObjectOutput::metadata): <p>A map of metadata to store with the object in S3.</p>
    ///   - [`sse_customer_algorithm(Option<String>)`](crate::output::GetObjectOutput::sse_customer_algorithm): <p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header confirming the encryption algorithm used.</p>
    ///   - [`sse_customer_key_md5(Option<String>)`](crate::output::GetObjectOutput::sse_customer_key_md5): <p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header to provide round-trip message integrity verification of the customer-provided encryption key.</p>
    ///   - [`ssekms_key_id(Option<String>)`](crate::output::GetObjectOutput::ssekms_key_id): <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric customer managed key that was used for the object.</p>
    ///   - [`bucket_key_enabled(bool)`](crate::output::GetObjectOutput::bucket_key_enabled): <p>Indicates whether the object uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    ///   - [`storage_class(Option<StorageClass>)`](crate::output::GetObjectOutput::storage_class): <p>Provides storage class information of the object. Amazon S3 returns this header for all objects except for S3 Standard storage class objects.</p>
    ///   - [`request_charged(Option<RequestCharged>)`](crate::output::GetObjectOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p>
    ///   - [`replication_status(Option<ReplicationStatus>)`](crate::output::GetObjectOutput::replication_status): <p>Amazon S3 can return this if your request involves a bucket that is either a source or destination in a replication rule.</p>
    ///   - [`parts_count(i32)`](crate::output::GetObjectOutput::parts_count): <p>The count of parts this object has.</p>
    ///   - [`tag_count(i32)`](crate::output::GetObjectOutput::tag_count): <p>The number of tags, if any, on the object.</p>
    ///   - [`object_lock_mode(Option<ObjectLockMode>)`](crate::output::GetObjectOutput::object_lock_mode): <p>The Object Lock mode currently in place for this object.</p>
    ///   - [`object_lock_retain_until_date(Option<DateTime>)`](crate::output::GetObjectOutput::object_lock_retain_until_date): <p>The date and time when this object's Object Lock will expire.</p>
    ///   - [`object_lock_legal_hold_status(Option<ObjectLockLegalHoldStatus>)`](crate::output::GetObjectOutput::object_lock_legal_hold_status): <p>Indicates whether this object has an active legal hold. This field is only returned if you have permission to view an object's legal hold status. </p>
    /// - On failure, responds with [`SdkError<GetObjectError>`](crate::error::GetObjectError)
    pub fn get_object(&self) -> fluent_builders::GetObject {
        fluent_builders::GetObject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetObjectAcl`](crate::client::fluent_builders::GetObjectAcl) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetObjectAcl::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetObjectAcl::set_bucket): <p>The bucket name that contains the object for which to get the ACL information. </p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`key(impl Into<String>)`](crate::client::fluent_builders::GetObjectAcl::key) / [`set_key(Option<String>)`](crate::client::fluent_builders::GetObjectAcl::set_key): <p>The key of the object for which to get the ACL information.</p>
    ///   - [`version_id(impl Into<String>)`](crate::client::fluent_builders::GetObjectAcl::version_id) / [`set_version_id(Option<String>)`](crate::client::fluent_builders::GetObjectAcl::set_version_id): <p>VersionId used to reference a specific version of the object.</p>
    ///   - [`request_payer(RequestPayer)`](crate::client::fluent_builders::GetObjectAcl::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::client::fluent_builders::GetObjectAcl::set_request_payer): <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::GetObjectAcl::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::GetObjectAcl::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`GetObjectAclOutput`](crate::output::GetObjectAclOutput) with field(s):
    ///   - [`owner(Option<Owner>)`](crate::output::GetObjectAclOutput::owner): <p> Container for the bucket owner's display name and ID.</p>
    ///   - [`grants(Option<Vec<Grant>>)`](crate::output::GetObjectAclOutput::grants): <p>A list of grants.</p>
    ///   - [`request_charged(Option<RequestCharged>)`](crate::output::GetObjectAclOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p>
    /// - On failure, responds with [`SdkError<GetObjectAclError>`](crate::error::GetObjectAclError)
    pub fn get_object_acl(&self) -> fluent_builders::GetObjectAcl {
        fluent_builders::GetObjectAcl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetObjectLegalHold`](crate::client::fluent_builders::GetObjectLegalHold) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetObjectLegalHold::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetObjectLegalHold::set_bucket): <p>The bucket name containing the object whose Legal Hold status you want to retrieve. </p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`key(impl Into<String>)`](crate::client::fluent_builders::GetObjectLegalHold::key) / [`set_key(Option<String>)`](crate::client::fluent_builders::GetObjectLegalHold::set_key): <p>The key name for the object whose Legal Hold status you want to retrieve.</p>
    ///   - [`version_id(impl Into<String>)`](crate::client::fluent_builders::GetObjectLegalHold::version_id) / [`set_version_id(Option<String>)`](crate::client::fluent_builders::GetObjectLegalHold::set_version_id): <p>The version ID of the object whose Legal Hold status you want to retrieve.</p>
    ///   - [`request_payer(RequestPayer)`](crate::client::fluent_builders::GetObjectLegalHold::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::client::fluent_builders::GetObjectLegalHold::set_request_payer): <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::GetObjectLegalHold::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::GetObjectLegalHold::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`GetObjectLegalHoldOutput`](crate::output::GetObjectLegalHoldOutput) with field(s):
    ///   - [`legal_hold(Option<ObjectLockLegalHold>)`](crate::output::GetObjectLegalHoldOutput::legal_hold): <p>The current Legal Hold status for the specified object.</p>
    /// - On failure, responds with [`SdkError<GetObjectLegalHoldError>`](crate::error::GetObjectLegalHoldError)
    pub fn get_object_legal_hold(&self) -> fluent_builders::GetObjectLegalHold {
        fluent_builders::GetObjectLegalHold::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetObjectLockConfiguration`](crate::client::fluent_builders::GetObjectLockConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetObjectLockConfiguration::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetObjectLockConfiguration::set_bucket): <p>The bucket whose Object Lock configuration you want to retrieve.</p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::GetObjectLockConfiguration::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::GetObjectLockConfiguration::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`GetObjectLockConfigurationOutput`](crate::output::GetObjectLockConfigurationOutput) with field(s):
    ///   - [`object_lock_configuration(Option<ObjectLockConfiguration>)`](crate::output::GetObjectLockConfigurationOutput::object_lock_configuration): <p>The specified bucket's Object Lock configuration.</p>
    /// - On failure, responds with [`SdkError<GetObjectLockConfigurationError>`](crate::error::GetObjectLockConfigurationError)
    pub fn get_object_lock_configuration(&self) -> fluent_builders::GetObjectLockConfiguration {
        fluent_builders::GetObjectLockConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetObjectRetention`](crate::client::fluent_builders::GetObjectRetention) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetObjectRetention::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetObjectRetention::set_bucket): <p>The bucket name containing the object whose retention settings you want to retrieve. </p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`key(impl Into<String>)`](crate::client::fluent_builders::GetObjectRetention::key) / [`set_key(Option<String>)`](crate::client::fluent_builders::GetObjectRetention::set_key): <p>The key name for the object whose retention settings you want to retrieve.</p>
    ///   - [`version_id(impl Into<String>)`](crate::client::fluent_builders::GetObjectRetention::version_id) / [`set_version_id(Option<String>)`](crate::client::fluent_builders::GetObjectRetention::set_version_id): <p>The version ID for the object whose retention settings you want to retrieve.</p>
    ///   - [`request_payer(RequestPayer)`](crate::client::fluent_builders::GetObjectRetention::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::client::fluent_builders::GetObjectRetention::set_request_payer): <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::GetObjectRetention::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::GetObjectRetention::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`GetObjectRetentionOutput`](crate::output::GetObjectRetentionOutput) with field(s):
    ///   - [`retention(Option<ObjectLockRetention>)`](crate::output::GetObjectRetentionOutput::retention): <p>The container element for an object's retention settings.</p>
    /// - On failure, responds with [`SdkError<GetObjectRetentionError>`](crate::error::GetObjectRetentionError)
    pub fn get_object_retention(&self) -> fluent_builders::GetObjectRetention {
        fluent_builders::GetObjectRetention::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetObjectTagging`](crate::client::fluent_builders::GetObjectTagging) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetObjectTagging::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetObjectTagging::set_bucket): <p>The bucket name containing the object for which to get the tagging information. </p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>  <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`key(impl Into<String>)`](crate::client::fluent_builders::GetObjectTagging::key) / [`set_key(Option<String>)`](crate::client::fluent_builders::GetObjectTagging::set_key): <p>Object key for which to get the tagging information.</p>
    ///   - [`version_id(impl Into<String>)`](crate::client::fluent_builders::GetObjectTagging::version_id) / [`set_version_id(Option<String>)`](crate::client::fluent_builders::GetObjectTagging::set_version_id): <p>The versionId of the object for which to get the tagging information.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::GetObjectTagging::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::GetObjectTagging::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    ///   - [`request_payer(RequestPayer)`](crate::client::fluent_builders::GetObjectTagging::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::client::fluent_builders::GetObjectTagging::set_request_payer): <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// - On success, responds with [`GetObjectTaggingOutput`](crate::output::GetObjectTaggingOutput) with field(s):
    ///   - [`version_id(Option<String>)`](crate::output::GetObjectTaggingOutput::version_id): <p>The versionId of the object for which you got the tagging information.</p>
    ///   - [`tag_set(Option<Vec<Tag>>)`](crate::output::GetObjectTaggingOutput::tag_set): <p>Contains the tag set.</p>
    /// - On failure, responds with [`SdkError<GetObjectTaggingError>`](crate::error::GetObjectTaggingError)
    pub fn get_object_tagging(&self) -> fluent_builders::GetObjectTagging {
        fluent_builders::GetObjectTagging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetObjectTorrent`](crate::client::fluent_builders::GetObjectTorrent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetObjectTorrent::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetObjectTorrent::set_bucket): <p>The name of the bucket containing the object for which to get the torrent files.</p>
    ///   - [`key(impl Into<String>)`](crate::client::fluent_builders::GetObjectTorrent::key) / [`set_key(Option<String>)`](crate::client::fluent_builders::GetObjectTorrent::set_key): <p>The object key for which to get the information.</p>
    ///   - [`request_payer(RequestPayer)`](crate::client::fluent_builders::GetObjectTorrent::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::client::fluent_builders::GetObjectTorrent::set_request_payer): <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::GetObjectTorrent::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::GetObjectTorrent::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`GetObjectTorrentOutput`](crate::output::GetObjectTorrentOutput) with field(s):
    ///   - [`body(byte_stream::ByteStream)`](crate::output::GetObjectTorrentOutput::body): <p>A Bencoded dictionary as defined by the BitTorrent specification</p>
    ///   - [`request_charged(Option<RequestCharged>)`](crate::output::GetObjectTorrentOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p>
    /// - On failure, responds with [`SdkError<GetObjectTorrentError>`](crate::error::GetObjectTorrentError)
    pub fn get_object_torrent(&self) -> fluent_builders::GetObjectTorrent {
        fluent_builders::GetObjectTorrent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPublicAccessBlock`](crate::client::fluent_builders::GetPublicAccessBlock) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::GetPublicAccessBlock::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::GetPublicAccessBlock::set_bucket): <p>The name of the Amazon S3 bucket whose <code>PublicAccessBlock</code> configuration you want to retrieve. </p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::GetPublicAccessBlock::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::GetPublicAccessBlock::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`GetPublicAccessBlockOutput`](crate::output::GetPublicAccessBlockOutput) with field(s):
    ///   - [`public_access_block_configuration(Option<PublicAccessBlockConfiguration>)`](crate::output::GetPublicAccessBlockOutput::public_access_block_configuration): <p>The <code>PublicAccessBlock</code> configuration currently in effect for this Amazon S3 bucket.</p>
    /// - On failure, responds with [`SdkError<GetPublicAccessBlockError>`](crate::error::GetPublicAccessBlockError)
    pub fn get_public_access_block(&self) -> fluent_builders::GetPublicAccessBlock {
        fluent_builders::GetPublicAccessBlock::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`HeadBucket`](crate::client::fluent_builders::HeadBucket) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::HeadBucket::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::HeadBucket::set_bucket): <p>The bucket name.</p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>  <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::HeadBucket::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::HeadBucket::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`HeadBucketOutput`](crate::output::HeadBucketOutput)

    /// - On failure, responds with [`SdkError<HeadBucketError>`](crate::error::HeadBucketError)
    pub fn head_bucket(&self) -> fluent_builders::HeadBucket {
        fluent_builders::HeadBucket::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`HeadObject`](crate::client::fluent_builders::HeadObject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::HeadObject::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::HeadObject::set_bucket): <p>The name of the bucket containing the object.</p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>  <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`if_match(impl Into<String>)`](crate::client::fluent_builders::HeadObject::if_match) / [`set_if_match(Option<String>)`](crate::client::fluent_builders::HeadObject::set_if_match): <p>Return the object only if its entity tag (ETag) is the same as the one specified, otherwise return a 412 (precondition failed).</p>
    ///   - [`if_modified_since(DateTime)`](crate::client::fluent_builders::HeadObject::if_modified_since) / [`set_if_modified_since(Option<DateTime>)`](crate::client::fluent_builders::HeadObject::set_if_modified_since): <p>Return the object only if it has been modified since the specified time, otherwise return a 304 (not modified).</p>
    ///   - [`if_none_match(impl Into<String>)`](crate::client::fluent_builders::HeadObject::if_none_match) / [`set_if_none_match(Option<String>)`](crate::client::fluent_builders::HeadObject::set_if_none_match): <p>Return the object only if its entity tag (ETag) is different from the one specified, otherwise return a 304 (not modified).</p>
    ///   - [`if_unmodified_since(DateTime)`](crate::client::fluent_builders::HeadObject::if_unmodified_since) / [`set_if_unmodified_since(Option<DateTime>)`](crate::client::fluent_builders::HeadObject::set_if_unmodified_since): <p>Return the object only if it has not been modified since the specified time, otherwise return a 412 (precondition failed).</p>
    ///   - [`key(impl Into<String>)`](crate::client::fluent_builders::HeadObject::key) / [`set_key(Option<String>)`](crate::client::fluent_builders::HeadObject::set_key): <p>The object key.</p>
    ///   - [`range(impl Into<String>)`](crate::client::fluent_builders::HeadObject::range) / [`set_range(Option<String>)`](crate::client::fluent_builders::HeadObject::set_range): <p>Because <code>HeadObject</code> returns only the metadata for an object, this parameter has no effect.</p>
    ///   - [`version_id(impl Into<String>)`](crate::client::fluent_builders::HeadObject::version_id) / [`set_version_id(Option<String>)`](crate::client::fluent_builders::HeadObject::set_version_id): <p>VersionId used to reference a specific version of the object.</p>
    ///   - [`sse_customer_algorithm(impl Into<String>)`](crate::client::fluent_builders::HeadObject::sse_customer_algorithm) / [`set_sse_customer_algorithm(Option<String>)`](crate::client::fluent_builders::HeadObject::set_sse_customer_algorithm): <p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>
    ///   - [`sse_customer_key(impl Into<String>)`](crate::client::fluent_builders::HeadObject::sse_customer_key) / [`set_sse_customer_key(Option<String>)`](crate::client::fluent_builders::HeadObject::set_sse_customer_key): <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
    ///   - [`sse_customer_key_md5(impl Into<String>)`](crate::client::fluent_builders::HeadObject::sse_customer_key_md5) / [`set_sse_customer_key_md5(Option<String>)`](crate::client::fluent_builders::HeadObject::set_sse_customer_key_md5): <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
    ///   - [`request_payer(RequestPayer)`](crate::client::fluent_builders::HeadObject::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::client::fluent_builders::HeadObject::set_request_payer): <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`part_number(i32)`](crate::client::fluent_builders::HeadObject::part_number) / [`set_part_number(i32)`](crate::client::fluent_builders::HeadObject::set_part_number): <p>Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a 'ranged' HEAD request for the part specified. Useful querying about the size of the part and the number of parts in this object.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::HeadObject::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::HeadObject::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`HeadObjectOutput`](crate::output::HeadObjectOutput) with field(s):
    ///   - [`delete_marker(bool)`](crate::output::HeadObjectOutput::delete_marker): <p>Specifies whether the object retrieved was (true) or was not (false) a Delete Marker. If false, this response header does not appear in the response.</p>
    ///   - [`accept_ranges(Option<String>)`](crate::output::HeadObjectOutput::accept_ranges): <p>Indicates that a range of bytes was specified.</p>
    ///   - [`expiration(Option<String>)`](crate::output::HeadObjectOutput::expiration): <p>If the object expiration is configured (see PUT Bucket lifecycle), the response includes this header. It includes the expiry-date and rule-id key-value pairs providing object expiration information. The value of the rule-id is URL encoded.</p>
    ///   - [`restore(Option<String>)`](crate::output::HeadObjectOutput::restore): <p>If the object is an archived object (an object whose storage class is GLACIER), the response includes this header if either the archive restoration is in progress (see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html">RestoreObject</a> or an archive copy is already restored.</p>  <p> If an archive copy is already restored, the header value indicates when Amazon S3 is scheduled to delete the object copy. For example:</p>  <p> <code>x-amz-restore: ongoing-request="false", expiry-date="Fri, 21 Dec 2012 00:00:00 GMT"</code> </p>  <p>If the object restoration is in progress, the header returns the value <code>ongoing-request="true"</code>.</p>  <p>For more information about archiving objects, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html#lifecycle-transition-general-considerations">Transitioning Objects: General Considerations</a>.</p>
    ///   - [`archive_status(Option<ArchiveStatus>)`](crate::output::HeadObjectOutput::archive_status): <p>The archive state of the head object.</p>
    ///   - [`last_modified(Option<DateTime>)`](crate::output::HeadObjectOutput::last_modified): <p>Creation date of the object.</p>
    ///   - [`content_length(i64)`](crate::output::HeadObjectOutput::content_length): <p>Size of the body in bytes.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::HeadObjectOutput::e_tag): <p>An ETag is an opaque identifier assigned by a web server to a specific version of a resource found at a URL.</p>
    ///   - [`missing_meta(i32)`](crate::output::HeadObjectOutput::missing_meta): <p>This is set to the number of metadata entries not returned in <code>x-amz-meta</code> headers. This can happen if you create metadata using an API like SOAP that supports more flexible metadata than the REST API. For example, using SOAP, you can create metadata whose values are not legal HTTP headers.</p>
    ///   - [`version_id(Option<String>)`](crate::output::HeadObjectOutput::version_id): <p>Version of the object.</p>
    ///   - [`cache_control(Option<String>)`](crate::output::HeadObjectOutput::cache_control): <p>Specifies caching behavior along the request/reply chain.</p>
    ///   - [`content_disposition(Option<String>)`](crate::output::HeadObjectOutput::content_disposition): <p>Specifies presentational information for the object.</p>
    ///   - [`content_encoding(Option<String>)`](crate::output::HeadObjectOutput::content_encoding): <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>
    ///   - [`content_language(Option<String>)`](crate::output::HeadObjectOutput::content_language): <p>The language the content is in.</p>
    ///   - [`content_type(Option<String>)`](crate::output::HeadObjectOutput::content_type): <p>A standard MIME type describing the format of the object data.</p>
    ///   - [`expires(Option<DateTime>)`](crate::output::HeadObjectOutput::expires): <p>The date and time at which the object is no longer cacheable.</p>
    ///   - [`website_redirect_location(Option<String>)`](crate::output::HeadObjectOutput::website_redirect_location): <p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p>
    ///   - [`server_side_encryption(Option<ServerSideEncryption>)`](crate::output::HeadObjectOutput::server_side_encryption): <p>If the object is stored using server-side encryption either with an Amazon Web Services KMS key or an Amazon S3-managed encryption key, the response includes this header with the value of the server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>
    ///   - [`metadata(Option<HashMap<String, String>>)`](crate::output::HeadObjectOutput::metadata): <p>A map of metadata to store with the object in S3.</p>
    ///   - [`sse_customer_algorithm(Option<String>)`](crate::output::HeadObjectOutput::sse_customer_algorithm): <p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header confirming the encryption algorithm used.</p>
    ///   - [`sse_customer_key_md5(Option<String>)`](crate::output::HeadObjectOutput::sse_customer_key_md5): <p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header to provide round-trip message integrity verification of the customer-provided encryption key.</p>
    ///   - [`ssekms_key_id(Option<String>)`](crate::output::HeadObjectOutput::ssekms_key_id): <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric customer managed key that was used for the object.</p>
    ///   - [`bucket_key_enabled(bool)`](crate::output::HeadObjectOutput::bucket_key_enabled): <p>Indicates whether the object uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    ///   - [`storage_class(Option<StorageClass>)`](crate::output::HeadObjectOutput::storage_class): <p>Provides storage class information of the object. Amazon S3 returns this header for all objects except for S3 Standard storage class objects.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a>.</p>
    ///   - [`request_charged(Option<RequestCharged>)`](crate::output::HeadObjectOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p>
    ///   - [`replication_status(Option<ReplicationStatus>)`](crate::output::HeadObjectOutput::replication_status): <p>Amazon S3 can return this header if your request involves a bucket that is either a source or a destination in a replication rule.</p>  <p>In replication, you have a source bucket on which you configure replication and destination bucket or buckets where Amazon S3 stores object replicas. When you request an object (<code>GetObject</code>) or object metadata (<code>HeadObject</code>) from these buckets, Amazon S3 will return the <code>x-amz-replication-status</code> header in the response as follows:</p>  <ul>   <li> <p>If requesting an object from the source bucket — Amazon S3 will return the <code>x-amz-replication-status</code> header if the object in your request is eligible for replication.</p> <p> For example, suppose that in your replication configuration, you specify object prefix <code>TaxDocs</code> requesting Amazon S3 to replicate objects with key prefix <code>TaxDocs</code>. Any objects you upload with this key name prefix, for example <code>TaxDocs/document1.pdf</code>, are eligible for replication. For any object request with this key name prefix, Amazon S3 will return the <code>x-amz-replication-status</code> header with value PENDING, COMPLETED or FAILED indicating object replication status.</p> </li>   <li> <p>If requesting an object from a destination bucket — Amazon S3 will return the <code>x-amz-replication-status</code> header with value REPLICA if the object in your request is a replica that Amazon S3 created and there is no replica modification replication in progress.</p> </li>   <li> <p>When replicating objects to multiple destination buckets the <code>x-amz-replication-status</code> header acts differently. The header of the source object will only return a value of COMPLETED when replication is successful to all destinations. The header will remain at value PENDING until replication has completed for all destinations. If one or more destinations fails replication the header will return FAILED. </p> </li>  </ul>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Replication</a>.</p>
    ///   - [`parts_count(i32)`](crate::output::HeadObjectOutput::parts_count): <p>The count of parts this object has.</p>
    ///   - [`object_lock_mode(Option<ObjectLockMode>)`](crate::output::HeadObjectOutput::object_lock_mode): <p>The Object Lock mode, if any, that's in effect for this object. This header is only returned if the requester has the <code>s3:GetObjectRetention</code> permission. For more information about S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Object Lock</a>. </p>
    ///   - [`object_lock_retain_until_date(Option<DateTime>)`](crate::output::HeadObjectOutput::object_lock_retain_until_date): <p>The date and time when the Object Lock retention period expires. This header is only returned if the requester has the <code>s3:GetObjectRetention</code> permission.</p>
    ///   - [`object_lock_legal_hold_status(Option<ObjectLockLegalHoldStatus>)`](crate::output::HeadObjectOutput::object_lock_legal_hold_status): <p>Specifies whether a legal hold is in effect for this object. This header is only returned if the requester has the <code>s3:GetObjectLegalHold</code> permission. This header is not returned if the specified version of this object has never had a legal hold applied. For more information about S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Object Lock</a>.</p>
    /// - On failure, responds with [`SdkError<HeadObjectError>`](crate::error::HeadObjectError)
    pub fn head_object(&self) -> fluent_builders::HeadObject {
        fluent_builders::HeadObject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBucketAnalyticsConfigurations`](crate::client::fluent_builders::ListBucketAnalyticsConfigurations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::ListBucketAnalyticsConfigurations::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::ListBucketAnalyticsConfigurations::set_bucket): <p>The name of the bucket from which analytics configurations are retrieved.</p>
    ///   - [`continuation_token(impl Into<String>)`](crate::client::fluent_builders::ListBucketAnalyticsConfigurations::continuation_token) / [`set_continuation_token(Option<String>)`](crate::client::fluent_builders::ListBucketAnalyticsConfigurations::set_continuation_token): <p>The ContinuationToken that represents a placeholder from where this request should begin.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::ListBucketAnalyticsConfigurations::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::ListBucketAnalyticsConfigurations::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`ListBucketAnalyticsConfigurationsOutput`](crate::output::ListBucketAnalyticsConfigurationsOutput) with field(s):
    ///   - [`is_truncated(bool)`](crate::output::ListBucketAnalyticsConfigurationsOutput::is_truncated): <p>Indicates whether the returned list of analytics configurations is complete. A value of true indicates that the list is not complete and the NextContinuationToken will be provided for a subsequent request.</p>
    ///   - [`continuation_token(Option<String>)`](crate::output::ListBucketAnalyticsConfigurationsOutput::continuation_token): <p>The marker that is used as a starting point for this analytics configuration list response. This value is present if it was sent in the request.</p>
    ///   - [`next_continuation_token(Option<String>)`](crate::output::ListBucketAnalyticsConfigurationsOutput::next_continuation_token): <p> <code>NextContinuationToken</code> is sent when <code>isTruncated</code> is true, which indicates that there are more analytics configurations to list. The next request must include this <code>NextContinuationToken</code>. The token is obfuscated and is not a usable value.</p>
    ///   - [`analytics_configuration_list(Option<Vec<AnalyticsConfiguration>>)`](crate::output::ListBucketAnalyticsConfigurationsOutput::analytics_configuration_list): <p>The list of analytics configurations for a bucket.</p>
    /// - On failure, responds with [`SdkError<ListBucketAnalyticsConfigurationsError>`](crate::error::ListBucketAnalyticsConfigurationsError)
    pub fn list_bucket_analytics_configurations(
        &self,
    ) -> fluent_builders::ListBucketAnalyticsConfigurations {
        fluent_builders::ListBucketAnalyticsConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBucketIntelligentTieringConfigurations`](crate::client::fluent_builders::ListBucketIntelligentTieringConfigurations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::ListBucketIntelligentTieringConfigurations::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::ListBucketIntelligentTieringConfigurations::set_bucket): <p>The name of the Amazon S3 bucket whose configuration you want to modify or retrieve.</p>
    ///   - [`continuation_token(impl Into<String>)`](crate::client::fluent_builders::ListBucketIntelligentTieringConfigurations::continuation_token) / [`set_continuation_token(Option<String>)`](crate::client::fluent_builders::ListBucketIntelligentTieringConfigurations::set_continuation_token): <p>The ContinuationToken that represents a placeholder from where this request should begin.</p>
    /// - On success, responds with [`ListBucketIntelligentTieringConfigurationsOutput`](crate::output::ListBucketIntelligentTieringConfigurationsOutput) with field(s):
    ///   - [`is_truncated(bool)`](crate::output::ListBucketIntelligentTieringConfigurationsOutput::is_truncated): <p>Indicates whether the returned list of analytics configurations is complete. A value of true indicates that the list is not complete and the NextContinuationToken will be provided for a subsequent request.</p>
    ///   - [`continuation_token(Option<String>)`](crate::output::ListBucketIntelligentTieringConfigurationsOutput::continuation_token): <p>The ContinuationToken that represents a placeholder from where this request should begin.</p>
    ///   - [`next_continuation_token(Option<String>)`](crate::output::ListBucketIntelligentTieringConfigurationsOutput::next_continuation_token): <p>The marker used to continue this inventory configuration listing. Use the <code>NextContinuationToken</code> from this response to continue the listing in a subsequent request. The continuation token is an opaque value that Amazon S3 understands.</p>
    ///   - [`intelligent_tiering_configuration_list(Option<Vec<IntelligentTieringConfiguration>>)`](crate::output::ListBucketIntelligentTieringConfigurationsOutput::intelligent_tiering_configuration_list): <p>The list of S3 Intelligent-Tiering configurations for a bucket.</p>
    /// - On failure, responds with [`SdkError<ListBucketIntelligentTieringConfigurationsError>`](crate::error::ListBucketIntelligentTieringConfigurationsError)
    pub fn list_bucket_intelligent_tiering_configurations(
        &self,
    ) -> fluent_builders::ListBucketIntelligentTieringConfigurations {
        fluent_builders::ListBucketIntelligentTieringConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBucketInventoryConfigurations`](crate::client::fluent_builders::ListBucketInventoryConfigurations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::ListBucketInventoryConfigurations::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::ListBucketInventoryConfigurations::set_bucket): <p>The name of the bucket containing the inventory configurations to retrieve.</p>
    ///   - [`continuation_token(impl Into<String>)`](crate::client::fluent_builders::ListBucketInventoryConfigurations::continuation_token) / [`set_continuation_token(Option<String>)`](crate::client::fluent_builders::ListBucketInventoryConfigurations::set_continuation_token): <p>The marker used to continue an inventory configuration listing that has been truncated. Use the NextContinuationToken from a previously truncated list response to continue the listing. The continuation token is an opaque value that Amazon S3 understands.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::ListBucketInventoryConfigurations::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::ListBucketInventoryConfigurations::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`ListBucketInventoryConfigurationsOutput`](crate::output::ListBucketInventoryConfigurationsOutput) with field(s):
    ///   - [`continuation_token(Option<String>)`](crate::output::ListBucketInventoryConfigurationsOutput::continuation_token): <p>If sent in the request, the marker that is used as a starting point for this inventory configuration list response.</p>
    ///   - [`inventory_configuration_list(Option<Vec<InventoryConfiguration>>)`](crate::output::ListBucketInventoryConfigurationsOutput::inventory_configuration_list): <p>The list of inventory configurations for a bucket.</p>
    ///   - [`is_truncated(bool)`](crate::output::ListBucketInventoryConfigurationsOutput::is_truncated): <p>Tells whether the returned list of inventory configurations is complete. A value of true indicates that the list is not complete and the NextContinuationToken is provided for a subsequent request.</p>
    ///   - [`next_continuation_token(Option<String>)`](crate::output::ListBucketInventoryConfigurationsOutput::next_continuation_token): <p>The marker used to continue this inventory configuration listing. Use the <code>NextContinuationToken</code> from this response to continue the listing in a subsequent request. The continuation token is an opaque value that Amazon S3 understands.</p>
    /// - On failure, responds with [`SdkError<ListBucketInventoryConfigurationsError>`](crate::error::ListBucketInventoryConfigurationsError)
    pub fn list_bucket_inventory_configurations(
        &self,
    ) -> fluent_builders::ListBucketInventoryConfigurations {
        fluent_builders::ListBucketInventoryConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBucketMetricsConfigurations`](crate::client::fluent_builders::ListBucketMetricsConfigurations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::ListBucketMetricsConfigurations::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::ListBucketMetricsConfigurations::set_bucket): <p>The name of the bucket containing the metrics configurations to retrieve.</p>
    ///   - [`continuation_token(impl Into<String>)`](crate::client::fluent_builders::ListBucketMetricsConfigurations::continuation_token) / [`set_continuation_token(Option<String>)`](crate::client::fluent_builders::ListBucketMetricsConfigurations::set_continuation_token): <p>The marker that is used to continue a metrics configuration listing that has been truncated. Use the NextContinuationToken from a previously truncated list response to continue the listing. The continuation token is an opaque value that Amazon S3 understands.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::ListBucketMetricsConfigurations::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::ListBucketMetricsConfigurations::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`ListBucketMetricsConfigurationsOutput`](crate::output::ListBucketMetricsConfigurationsOutput) with field(s):
    ///   - [`is_truncated(bool)`](crate::output::ListBucketMetricsConfigurationsOutput::is_truncated): <p>Indicates whether the returned list of metrics configurations is complete. A value of true indicates that the list is not complete and the NextContinuationToken will be provided for a subsequent request.</p>
    ///   - [`continuation_token(Option<String>)`](crate::output::ListBucketMetricsConfigurationsOutput::continuation_token): <p>The marker that is used as a starting point for this metrics configuration list response. This value is present if it was sent in the request.</p>
    ///   - [`next_continuation_token(Option<String>)`](crate::output::ListBucketMetricsConfigurationsOutput::next_continuation_token): <p>The marker used to continue a metrics configuration listing that has been truncated. Use the <code>NextContinuationToken</code> from a previously truncated list response to continue the listing. The continuation token is an opaque value that Amazon S3 understands.</p>
    ///   - [`metrics_configuration_list(Option<Vec<MetricsConfiguration>>)`](crate::output::ListBucketMetricsConfigurationsOutput::metrics_configuration_list): <p>The list of metrics configurations for a bucket.</p>
    /// - On failure, responds with [`SdkError<ListBucketMetricsConfigurationsError>`](crate::error::ListBucketMetricsConfigurationsError)
    pub fn list_bucket_metrics_configurations(
        &self,
    ) -> fluent_builders::ListBucketMetricsConfigurations {
        fluent_builders::ListBucketMetricsConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBuckets`](crate::client::fluent_builders::ListBuckets) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::ListBuckets::send) it.

    /// - On success, responds with [`ListBucketsOutput`](crate::output::ListBucketsOutput) with field(s):
    ///   - [`buckets(Option<Vec<Bucket>>)`](crate::output::ListBucketsOutput::buckets): <p>The list of buckets owned by the requestor.</p>
    ///   - [`owner(Option<Owner>)`](crate::output::ListBucketsOutput::owner): <p>The owner of the buckets listed.</p>
    /// - On failure, responds with [`SdkError<ListBucketsError>`](crate::error::ListBucketsError)
    pub fn list_buckets(&self) -> fluent_builders::ListBuckets {
        fluent_builders::ListBuckets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListMultipartUploads`](crate::client::fluent_builders::ListMultipartUploads) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::ListMultipartUploads::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::ListMultipartUploads::set_bucket): <p>The name of the bucket to which the multipart upload was initiated. </p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>  <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`delimiter(impl Into<String>)`](crate::client::fluent_builders::ListMultipartUploads::delimiter) / [`set_delimiter(Option<String>)`](crate::client::fluent_builders::ListMultipartUploads::set_delimiter): <p>Character you use to group keys.</p>  <p>All keys that contain the same string between the prefix, if specified, and the first occurrence of the delimiter after the prefix are grouped under a single result element, <code>CommonPrefixes</code>. If you don't specify the prefix parameter, then the substring starts at the beginning of the key. The keys that are grouped under <code>CommonPrefixes</code> result element are not returned elsewhere in the response.</p>
    ///   - [`encoding_type(EncodingType)`](crate::client::fluent_builders::ListMultipartUploads::encoding_type) / [`set_encoding_type(Option<EncodingType>)`](crate::client::fluent_builders::ListMultipartUploads::set_encoding_type): <p>Requests Amazon S3 to encode the object keys in the response and specifies the encoding method to use. An object key may contain any Unicode character; however, XML 1.0 parser cannot parse some characters, such as characters with an ASCII value from 0 to 10. For characters that are not supported in XML 1.0, you can add this parameter to request that Amazon S3 encode the keys in the response.</p>
    ///   - [`key_marker(impl Into<String>)`](crate::client::fluent_builders::ListMultipartUploads::key_marker) / [`set_key_marker(Option<String>)`](crate::client::fluent_builders::ListMultipartUploads::set_key_marker): <p>Together with upload-id-marker, this parameter specifies the multipart upload after which listing should begin.</p>  <p>If <code>upload-id-marker</code> is not specified, only the keys lexicographically greater than the specified <code>key-marker</code> will be included in the list.</p>  <p>If <code>upload-id-marker</code> is specified, any multipart uploads for a key equal to the <code>key-marker</code> might also be included, provided those multipart uploads have upload IDs lexicographically greater than the specified <code>upload-id-marker</code>.</p>
    ///   - [`max_uploads(i32)`](crate::client::fluent_builders::ListMultipartUploads::max_uploads) / [`set_max_uploads(i32)`](crate::client::fluent_builders::ListMultipartUploads::set_max_uploads): <p>Sets the maximum number of multipart uploads, from 1 to 1,000, to return in the response body. 1,000 is the maximum number of uploads that can be returned in a response.</p>
    ///   - [`prefix(impl Into<String>)`](crate::client::fluent_builders::ListMultipartUploads::prefix) / [`set_prefix(Option<String>)`](crate::client::fluent_builders::ListMultipartUploads::set_prefix): <p>Lists in-progress uploads only for those keys that begin with the specified prefix. You can use prefixes to separate a bucket into different grouping of keys. (You can think of using prefix to make groups in the same way you'd use a folder in a file system.)</p>
    ///   - [`upload_id_marker(impl Into<String>)`](crate::client::fluent_builders::ListMultipartUploads::upload_id_marker) / [`set_upload_id_marker(Option<String>)`](crate::client::fluent_builders::ListMultipartUploads::set_upload_id_marker): <p>Together with key-marker, specifies the multipart upload after which listing should begin. If key-marker is not specified, the upload-id-marker parameter is ignored. Otherwise, any multipart uploads for a key equal to the key-marker might be included in the list only if they have an upload ID lexicographically greater than the specified <code>upload-id-marker</code>.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::ListMultipartUploads::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::ListMultipartUploads::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`ListMultipartUploadsOutput`](crate::output::ListMultipartUploadsOutput) with field(s):
    ///   - [`bucket(Option<String>)`](crate::output::ListMultipartUploadsOutput::bucket): <p>The name of the bucket to which the multipart upload was initiated. Does not return the access point ARN or access point alias if used.</p>
    ///   - [`key_marker(Option<String>)`](crate::output::ListMultipartUploadsOutput::key_marker): <p>The key at or after which the listing began.</p>
    ///   - [`upload_id_marker(Option<String>)`](crate::output::ListMultipartUploadsOutput::upload_id_marker): <p>Upload ID after which listing began.</p>
    ///   - [`next_key_marker(Option<String>)`](crate::output::ListMultipartUploadsOutput::next_key_marker): <p>When a list is truncated, this element specifies the value that should be used for the key-marker request parameter in a subsequent request.</p>
    ///   - [`prefix(Option<String>)`](crate::output::ListMultipartUploadsOutput::prefix): <p>When a prefix is provided in the request, this field contains the specified prefix. The result contains only keys starting with the specified prefix.</p>
    ///   - [`delimiter(Option<String>)`](crate::output::ListMultipartUploadsOutput::delimiter): <p>Contains the delimiter you specified in the request. If you don't specify a delimiter in your request, this element is absent from the response.</p>
    ///   - [`next_upload_id_marker(Option<String>)`](crate::output::ListMultipartUploadsOutput::next_upload_id_marker): <p>When a list is truncated, this element specifies the value that should be used for the <code>upload-id-marker</code> request parameter in a subsequent request.</p>
    ///   - [`max_uploads(i32)`](crate::output::ListMultipartUploadsOutput::max_uploads): <p>Maximum number of multipart uploads that could have been included in the response.</p>
    ///   - [`is_truncated(bool)`](crate::output::ListMultipartUploadsOutput::is_truncated): <p>Indicates whether the returned list of multipart uploads is truncated. A value of true indicates that the list was truncated. The list can be truncated if the number of multipart uploads exceeds the limit allowed or specified by max uploads.</p>
    ///   - [`uploads(Option<Vec<MultipartUpload>>)`](crate::output::ListMultipartUploadsOutput::uploads): <p>Container for elements related to a particular multipart upload. A response can contain zero or more <code>Upload</code> elements.</p>
    ///   - [`common_prefixes(Option<Vec<CommonPrefix>>)`](crate::output::ListMultipartUploadsOutput::common_prefixes): <p>If you specify a delimiter in the request, then the result returns each distinct key prefix containing the delimiter in a <code>CommonPrefixes</code> element. The distinct key prefixes are returned in the <code>Prefix</code> child element.</p>
    ///   - [`encoding_type(Option<EncodingType>)`](crate::output::ListMultipartUploadsOutput::encoding_type): <p>Encoding type used by Amazon S3 to encode object keys in the response.</p>  <p>If you specify <code>encoding-type</code> request parameter, Amazon S3 includes this element in the response, and returns encoded key name values in the following response elements:</p>  <p> <code>Delimiter</code>, <code>KeyMarker</code>, <code>Prefix</code>, <code>NextKeyMarker</code>, <code>Key</code>.</p>
    /// - On failure, responds with [`SdkError<ListMultipartUploadsError>`](crate::error::ListMultipartUploadsError)
    pub fn list_multipart_uploads(&self) -> fluent_builders::ListMultipartUploads {
        fluent_builders::ListMultipartUploads::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListObjects`](crate::client::fluent_builders::ListObjects) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::ListObjects::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::ListObjects::set_bucket): <p>The name of the bucket containing the objects.</p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>  <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`delimiter(impl Into<String>)`](crate::client::fluent_builders::ListObjects::delimiter) / [`set_delimiter(Option<String>)`](crate::client::fluent_builders::ListObjects::set_delimiter): <p>A delimiter is a character you use to group keys.</p>
    ///   - [`encoding_type(EncodingType)`](crate::client::fluent_builders::ListObjects::encoding_type) / [`set_encoding_type(Option<EncodingType>)`](crate::client::fluent_builders::ListObjects::set_encoding_type): <p>Requests Amazon S3 to encode the object keys in the response and specifies the encoding method to use. An object key may contain any Unicode character; however, XML 1.0 parser cannot parse some characters, such as characters with an ASCII value from 0 to 10. For characters that are not supported in XML 1.0, you can add this parameter to request that Amazon S3 encode the keys in the response.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListObjects::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListObjects::set_marker): <p>Marker is where you want Amazon S3 to start listing from. Amazon S3 starts listing after this specified key. Marker can be any key in the bucket.</p>
    ///   - [`max_keys(i32)`](crate::client::fluent_builders::ListObjects::max_keys) / [`set_max_keys(i32)`](crate::client::fluent_builders::ListObjects::set_max_keys): <p>Sets the maximum number of keys returned in the response. By default the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more. </p>
    ///   - [`prefix(impl Into<String>)`](crate::client::fluent_builders::ListObjects::prefix) / [`set_prefix(Option<String>)`](crate::client::fluent_builders::ListObjects::set_prefix): <p>Limits the response to keys that begin with the specified prefix.</p>
    ///   - [`request_payer(RequestPayer)`](crate::client::fluent_builders::ListObjects::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::client::fluent_builders::ListObjects::set_request_payer): <p>Confirms that the requester knows that she or he will be charged for the list objects request. Bucket owners need not specify this parameter in their requests.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::ListObjects::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::ListObjects::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`ListObjectsOutput`](crate::output::ListObjectsOutput) with field(s):
    ///   - [`is_truncated(bool)`](crate::output::ListObjectsOutput::is_truncated): <p>A flag that indicates whether Amazon S3 returned all of the results that satisfied the search criteria.</p>
    ///   - [`marker(Option<String>)`](crate::output::ListObjectsOutput::marker): <p>Indicates where in the bucket listing begins. Marker is included in the response if it was sent with the request.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::ListObjectsOutput::next_marker): <p>When response is truncated (the IsTruncated element value in the response is true), you can use the key name in this field as marker in the subsequent request to get next set of objects. Amazon S3 lists objects in alphabetical order Note: This element is returned only if you have delimiter request parameter specified. If response does not include the NextMarker and it is truncated, you can use the value of the last Key in the response as the marker in the subsequent request to get the next set of object keys.</p>
    ///   - [`contents(Option<Vec<Object>>)`](crate::output::ListObjectsOutput::contents): <p>Metadata about each object returned.</p>
    ///   - [`name(Option<String>)`](crate::output::ListObjectsOutput::name): <p>The bucket name.</p>
    ///   - [`prefix(Option<String>)`](crate::output::ListObjectsOutput::prefix): <p>Keys that begin with the indicated prefix.</p>
    ///   - [`delimiter(Option<String>)`](crate::output::ListObjectsOutput::delimiter): <p>Causes keys that contain the same string between the prefix and the first occurrence of the delimiter to be rolled up into a single result element in the <code>CommonPrefixes</code> collection. These rolled-up keys are not returned elsewhere in the response. Each rolled-up result counts as only one return against the <code>MaxKeys</code> value.</p>
    ///   - [`max_keys(i32)`](crate::output::ListObjectsOutput::max_keys): <p>The maximum number of keys returned in the response body.</p>
    ///   - [`common_prefixes(Option<Vec<CommonPrefix>>)`](crate::output::ListObjectsOutput::common_prefixes): <p>All of the keys (up to 1,000) rolled up in a common prefix count as a single return when calculating the number of returns. </p>  <p>A response can contain CommonPrefixes only if you specify a delimiter.</p>  <p>CommonPrefixes contains all (if there are any) keys between Prefix and the next occurrence of the string specified by the delimiter.</p>  <p> CommonPrefixes lists keys that act like subdirectories in the directory specified by Prefix.</p>  <p>For example, if the prefix is notes/ and the delimiter is a slash (/) as in notes/summer/july, the common prefix is notes/summer/. All of the keys that roll up into a common prefix count as a single return when calculating the number of returns.</p>
    ///   - [`encoding_type(Option<EncodingType>)`](crate::output::ListObjectsOutput::encoding_type): <p>Encoding type used by Amazon S3 to encode object keys in the response.</p>
    /// - On failure, responds with [`SdkError<ListObjectsError>`](crate::error::ListObjectsError)
    pub fn list_objects(&self) -> fluent_builders::ListObjects {
        fluent_builders::ListObjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListObjectsV2`](crate::client::fluent_builders::ListObjectsV2) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListObjectsV2::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::ListObjectsV2::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::ListObjectsV2::set_bucket): <p>Bucket name to list. </p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>  <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`delimiter(impl Into<String>)`](crate::client::fluent_builders::ListObjectsV2::delimiter) / [`set_delimiter(Option<String>)`](crate::client::fluent_builders::ListObjectsV2::set_delimiter): <p>A delimiter is a character you use to group keys.</p>
    ///   - [`encoding_type(EncodingType)`](crate::client::fluent_builders::ListObjectsV2::encoding_type) / [`set_encoding_type(Option<EncodingType>)`](crate::client::fluent_builders::ListObjectsV2::set_encoding_type): <p>Encoding type used by Amazon S3 to encode object keys in the response.</p>
    ///   - [`max_keys(i32)`](crate::client::fluent_builders::ListObjectsV2::max_keys) / [`set_max_keys(i32)`](crate::client::fluent_builders::ListObjectsV2::set_max_keys): <p>Sets the maximum number of keys returned in the response. By default the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more.</p>
    ///   - [`prefix(impl Into<String>)`](crate::client::fluent_builders::ListObjectsV2::prefix) / [`set_prefix(Option<String>)`](crate::client::fluent_builders::ListObjectsV2::set_prefix): <p>Limits the response to keys that begin with the specified prefix.</p>
    ///   - [`continuation_token(impl Into<String>)`](crate::client::fluent_builders::ListObjectsV2::continuation_token) / [`set_continuation_token(Option<String>)`](crate::client::fluent_builders::ListObjectsV2::set_continuation_token): <p>ContinuationToken indicates Amazon S3 that the list is being continued on this bucket with a token. ContinuationToken is obfuscated and is not a real key.</p>
    ///   - [`fetch_owner(bool)`](crate::client::fluent_builders::ListObjectsV2::fetch_owner) / [`set_fetch_owner(bool)`](crate::client::fluent_builders::ListObjectsV2::set_fetch_owner): <p>The owner field is not present in listV2 by default, if you want to return owner field with each key in the result then set the fetch owner field to true.</p>
    ///   - [`start_after(impl Into<String>)`](crate::client::fluent_builders::ListObjectsV2::start_after) / [`set_start_after(Option<String>)`](crate::client::fluent_builders::ListObjectsV2::set_start_after): <p>StartAfter is where you want Amazon S3 to start listing from. Amazon S3 starts listing after this specified key. StartAfter can be any key in the bucket.</p>
    ///   - [`request_payer(RequestPayer)`](crate::client::fluent_builders::ListObjectsV2::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::client::fluent_builders::ListObjectsV2::set_request_payer): <p>Confirms that the requester knows that she or he will be charged for the list objects request in V2 style. Bucket owners need not specify this parameter in their requests.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::ListObjectsV2::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::ListObjectsV2::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`ListObjectsV2Output`](crate::output::ListObjectsV2Output) with field(s):
    ///   - [`is_truncated(bool)`](crate::output::ListObjectsV2Output::is_truncated): <p>Set to false if all of the results were returned. Set to true if more keys are available to return. If the number of results exceeds that specified by MaxKeys, all of the results might not be returned.</p>
    ///   - [`contents(Option<Vec<Object>>)`](crate::output::ListObjectsV2Output::contents): <p>Metadata about each object returned.</p>
    ///   - [`name(Option<String>)`](crate::output::ListObjectsV2Output::name): <p>The bucket name.</p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>  <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`prefix(Option<String>)`](crate::output::ListObjectsV2Output::prefix): <p> Keys that begin with the indicated prefix.</p>
    ///   - [`delimiter(Option<String>)`](crate::output::ListObjectsV2Output::delimiter): <p>Causes keys that contain the same string between the prefix and the first occurrence of the delimiter to be rolled up into a single result element in the CommonPrefixes collection. These rolled-up keys are not returned elsewhere in the response. Each rolled-up result counts as only one return against the <code>MaxKeys</code> value.</p>
    ///   - [`max_keys(i32)`](crate::output::ListObjectsV2Output::max_keys): <p>Sets the maximum number of keys returned in the response. By default the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more.</p>
    ///   - [`common_prefixes(Option<Vec<CommonPrefix>>)`](crate::output::ListObjectsV2Output::common_prefixes): <p>All of the keys (up to 1,000) rolled up into a common prefix count as a single return when calculating the number of returns.</p>  <p>A response can contain <code>CommonPrefixes</code> only if you specify a delimiter.</p>  <p> <code>CommonPrefixes</code> contains all (if there are any) keys between <code>Prefix</code> and the next occurrence of the string specified by a delimiter.</p>  <p> <code>CommonPrefixes</code> lists keys that act like subdirectories in the directory specified by <code>Prefix</code>.</p>  <p>For example, if the prefix is <code>notes/</code> and the delimiter is a slash (<code>/</code>) as in <code>notes/summer/july</code>, the common prefix is <code>notes/summer/</code>. All of the keys that roll up into a common prefix count as a single return when calculating the number of returns. </p>
    ///   - [`encoding_type(Option<EncodingType>)`](crate::output::ListObjectsV2Output::encoding_type): <p>Encoding type used by Amazon S3 to encode object key names in the XML response.</p>  <p>If you specify the encoding-type request parameter, Amazon S3 includes this element in the response, and returns encoded key name values in the following response elements:</p>  <p> <code>Delimiter, Prefix, Key,</code> and <code>StartAfter</code>.</p>
    ///   - [`key_count(i32)`](crate::output::ListObjectsV2Output::key_count): <p>KeyCount is the number of keys returned with this request. KeyCount will always be less than or equals to MaxKeys field. Say you ask for 50 keys, your result will include less than equals 50 keys </p>
    ///   - [`continuation_token(Option<String>)`](crate::output::ListObjectsV2Output::continuation_token): <p> If ContinuationToken was sent with the request, it is included in the response.</p>
    ///   - [`next_continuation_token(Option<String>)`](crate::output::ListObjectsV2Output::next_continuation_token): <p> <code>NextContinuationToken</code> is sent when <code>isTruncated</code> is true, which means there are more keys in the bucket that can be listed. The next list requests to Amazon S3 can be continued with this <code>NextContinuationToken</code>. <code>NextContinuationToken</code> is obfuscated and is not a real key</p>
    ///   - [`start_after(Option<String>)`](crate::output::ListObjectsV2Output::start_after): <p>If StartAfter was sent with the request, it is included in the response.</p>
    /// - On failure, responds with [`SdkError<ListObjectsV2Error>`](crate::error::ListObjectsV2Error)
    pub fn list_objects_v2(&self) -> fluent_builders::ListObjectsV2 {
        fluent_builders::ListObjectsV2::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListObjectVersions`](crate::client::fluent_builders::ListObjectVersions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::ListObjectVersions::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::ListObjectVersions::set_bucket): <p>The bucket name that contains the objects. </p>
    ///   - [`delimiter(impl Into<String>)`](crate::client::fluent_builders::ListObjectVersions::delimiter) / [`set_delimiter(Option<String>)`](crate::client::fluent_builders::ListObjectVersions::set_delimiter): <p>A delimiter is a character that you specify to group keys. All keys that contain the same string between the <code>prefix</code> and the first occurrence of the delimiter are grouped under a single result element in CommonPrefixes. These groups are counted as one result against the max-keys limitation. These keys are not returned elsewhere in the response.</p>
    ///   - [`encoding_type(EncodingType)`](crate::client::fluent_builders::ListObjectVersions::encoding_type) / [`set_encoding_type(Option<EncodingType>)`](crate::client::fluent_builders::ListObjectVersions::set_encoding_type): <p>Requests Amazon S3 to encode the object keys in the response and specifies the encoding method to use. An object key may contain any Unicode character; however, XML 1.0 parser cannot parse some characters, such as characters with an ASCII value from 0 to 10. For characters that are not supported in XML 1.0, you can add this parameter to request that Amazon S3 encode the keys in the response.</p>
    ///   - [`key_marker(impl Into<String>)`](crate::client::fluent_builders::ListObjectVersions::key_marker) / [`set_key_marker(Option<String>)`](crate::client::fluent_builders::ListObjectVersions::set_key_marker): <p>Specifies the key to start with when listing objects in a bucket.</p>
    ///   - [`max_keys(i32)`](crate::client::fluent_builders::ListObjectVersions::max_keys) / [`set_max_keys(i32)`](crate::client::fluent_builders::ListObjectVersions::set_max_keys): <p>Sets the maximum number of keys returned in the response. By default the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more. If additional keys satisfy the search criteria, but were not returned because max-keys was exceeded, the response contains <istruncated>   true  </istruncated>. To return the additional keys, see key-marker and version-id-marker.</p>
    ///   - [`prefix(impl Into<String>)`](crate::client::fluent_builders::ListObjectVersions::prefix) / [`set_prefix(Option<String>)`](crate::client::fluent_builders::ListObjectVersions::set_prefix): <p>Use this parameter to select only those keys that begin with the specified prefix. You can use prefixes to separate a bucket into different groupings of keys. (You can think of using prefix to make groups in the same way you'd use a folder in a file system.) You can use prefix with delimiter to roll up numerous objects into a single result under CommonPrefixes. </p>
    ///   - [`version_id_marker(impl Into<String>)`](crate::client::fluent_builders::ListObjectVersions::version_id_marker) / [`set_version_id_marker(Option<String>)`](crate::client::fluent_builders::ListObjectVersions::set_version_id_marker): <p>Specifies the object version you want to start listing from.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::ListObjectVersions::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::ListObjectVersions::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`ListObjectVersionsOutput`](crate::output::ListObjectVersionsOutput) with field(s):
    ///   - [`is_truncated(bool)`](crate::output::ListObjectVersionsOutput::is_truncated): <p>A flag that indicates whether Amazon S3 returned all of the results that satisfied the search criteria. If your results were truncated, you can make a follow-up paginated request using the NextKeyMarker and NextVersionIdMarker response parameters as a starting place in another request to return the rest of the results.</p>
    ///   - [`key_marker(Option<String>)`](crate::output::ListObjectVersionsOutput::key_marker): <p>Marks the last key returned in a truncated response.</p>
    ///   - [`version_id_marker(Option<String>)`](crate::output::ListObjectVersionsOutput::version_id_marker): <p>Marks the last version of the key returned in a truncated response.</p>
    ///   - [`next_key_marker(Option<String>)`](crate::output::ListObjectVersionsOutput::next_key_marker): <p>When the number of responses exceeds the value of <code>MaxKeys</code>, <code>NextKeyMarker</code> specifies the first key not returned that satisfies the search criteria. Use this value for the key-marker request parameter in a subsequent request.</p>
    ///   - [`next_version_id_marker(Option<String>)`](crate::output::ListObjectVersionsOutput::next_version_id_marker): <p>When the number of responses exceeds the value of <code>MaxKeys</code>, <code>NextVersionIdMarker</code> specifies the first object version not returned that satisfies the search criteria. Use this value for the version-id-marker request parameter in a subsequent request.</p>
    ///   - [`versions(Option<Vec<ObjectVersion>>)`](crate::output::ListObjectVersionsOutput::versions): <p>Container for version information.</p>
    ///   - [`delete_markers(Option<Vec<DeleteMarkerEntry>>)`](crate::output::ListObjectVersionsOutput::delete_markers): <p>Container for an object that is a delete marker.</p>
    ///   - [`name(Option<String>)`](crate::output::ListObjectVersionsOutput::name): <p>The bucket name.</p>
    ///   - [`prefix(Option<String>)`](crate::output::ListObjectVersionsOutput::prefix): <p>Selects objects that start with the value supplied by this parameter.</p>
    ///   - [`delimiter(Option<String>)`](crate::output::ListObjectVersionsOutput::delimiter): <p>The delimiter grouping the included keys. A delimiter is a character that you specify to group keys. All keys that contain the same string between the prefix and the first occurrence of the delimiter are grouped under a single result element in <code>CommonPrefixes</code>. These groups are counted as one result against the max-keys limitation. These keys are not returned elsewhere in the response.</p>
    ///   - [`max_keys(i32)`](crate::output::ListObjectVersionsOutput::max_keys): <p>Specifies the maximum number of objects to return.</p>
    ///   - [`common_prefixes(Option<Vec<CommonPrefix>>)`](crate::output::ListObjectVersionsOutput::common_prefixes): <p>All of the keys rolled up into a common prefix count as a single return when calculating the number of returns.</p>
    ///   - [`encoding_type(Option<EncodingType>)`](crate::output::ListObjectVersionsOutput::encoding_type): <p> Encoding type used by Amazon S3 to encode object key names in the XML response.</p>  <p>If you specify encoding-type request parameter, Amazon S3 includes this element in the response, and returns encoded key name values in the following response elements:</p>  <p> <code>KeyMarker, NextKeyMarker, Prefix, Key</code>, and <code>Delimiter</code>.</p>
    /// - On failure, responds with [`SdkError<ListObjectVersionsError>`](crate::error::ListObjectVersionsError)
    pub fn list_object_versions(&self) -> fluent_builders::ListObjectVersions {
        fluent_builders::ListObjectVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListParts`](crate::client::fluent_builders::ListParts) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListParts::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::ListParts::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::ListParts::set_bucket): <p>The name of the bucket to which the parts are being uploaded. </p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>  <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`key(impl Into<String>)`](crate::client::fluent_builders::ListParts::key) / [`set_key(Option<String>)`](crate::client::fluent_builders::ListParts::set_key): <p>Object key for which the multipart upload was initiated.</p>
    ///   - [`max_parts(i32)`](crate::client::fluent_builders::ListParts::max_parts) / [`set_max_parts(i32)`](crate::client::fluent_builders::ListParts::set_max_parts): <p>Sets the maximum number of parts to return.</p>
    ///   - [`part_number_marker(impl Into<String>)`](crate::client::fluent_builders::ListParts::part_number_marker) / [`set_part_number_marker(Option<String>)`](crate::client::fluent_builders::ListParts::set_part_number_marker): <p>Specifies the part after which listing should begin. Only parts with higher part numbers will be listed.</p>
    ///   - [`upload_id(impl Into<String>)`](crate::client::fluent_builders::ListParts::upload_id) / [`set_upload_id(Option<String>)`](crate::client::fluent_builders::ListParts::set_upload_id): <p>Upload ID identifying the multipart upload whose parts are being listed.</p>
    ///   - [`request_payer(RequestPayer)`](crate::client::fluent_builders::ListParts::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::client::fluent_builders::ListParts::set_request_payer): <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::ListParts::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::ListParts::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`ListPartsOutput`](crate::output::ListPartsOutput) with field(s):
    ///   - [`abort_date(Option<DateTime>)`](crate::output::ListPartsOutput::abort_date): <p>If the bucket has a lifecycle rule configured with an action to abort incomplete multipart uploads and the prefix in the lifecycle rule matches the object name in the request, then the response includes this header indicating when the initiated multipart upload will become eligible for abort operation. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config">Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Policy</a>.</p>  <p>The response will also include the <code>x-amz-abort-rule-id</code> header that will provide the ID of the lifecycle configuration rule that defines this action.</p>
    ///   - [`abort_rule_id(Option<String>)`](crate::output::ListPartsOutput::abort_rule_id): <p>This header is returned along with the <code>x-amz-abort-date</code> header. It identifies applicable lifecycle configuration rule that defines the action to abort incomplete multipart uploads.</p>
    ///   - [`bucket(Option<String>)`](crate::output::ListPartsOutput::bucket): <p>The name of the bucket to which the multipart upload was initiated. Does not return the access point ARN or access point alias if used.</p>
    ///   - [`key(Option<String>)`](crate::output::ListPartsOutput::key): <p>Object key for which the multipart upload was initiated.</p>
    ///   - [`upload_id(Option<String>)`](crate::output::ListPartsOutput::upload_id): <p>Upload ID identifying the multipart upload whose parts are being listed.</p>
    ///   - [`part_number_marker(Option<String>)`](crate::output::ListPartsOutput::part_number_marker): <p>When a list is truncated, this element specifies the last part in the list, as well as the value to use for the part-number-marker request parameter in a subsequent request.</p>
    ///   - [`next_part_number_marker(Option<String>)`](crate::output::ListPartsOutput::next_part_number_marker): <p>When a list is truncated, this element specifies the last part in the list, as well as the value to use for the part-number-marker request parameter in a subsequent request.</p>
    ///   - [`max_parts(i32)`](crate::output::ListPartsOutput::max_parts): <p>Maximum number of parts that were allowed in the response.</p>
    ///   - [`is_truncated(bool)`](crate::output::ListPartsOutput::is_truncated): <p> Indicates whether the returned list of parts is truncated. A true value indicates that the list was truncated. A list can be truncated if the number of parts exceeds the limit returned in the MaxParts element.</p>
    ///   - [`parts(Option<Vec<Part>>)`](crate::output::ListPartsOutput::parts): <p> Container for elements related to a particular part. A response can contain zero or more <code>Part</code> elements.</p>
    ///   - [`initiator(Option<Initiator>)`](crate::output::ListPartsOutput::initiator): <p>Container element that identifies who initiated the multipart upload. If the initiator is an Amazon Web Services account, this element provides the same information as the <code>Owner</code> element. If the initiator is an IAM User, this element provides the user ARN and display name.</p>
    ///   - [`owner(Option<Owner>)`](crate::output::ListPartsOutput::owner): <p> Container element that identifies the object owner, after the object is created. If multipart upload is initiated by an IAM user, this element provides the parent account ID and display name.</p>
    ///   - [`storage_class(Option<StorageClass>)`](crate::output::ListPartsOutput::storage_class): <p>Class of storage (STANDARD or REDUCED_REDUNDANCY) used to store the uploaded object.</p>
    ///   - [`request_charged(Option<RequestCharged>)`](crate::output::ListPartsOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p>
    /// - On failure, responds with [`SdkError<ListPartsError>`](crate::error::ListPartsError)
    pub fn list_parts(&self) -> fluent_builders::ListParts {
        fluent_builders::ListParts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutBucketAccelerateConfiguration`](crate::client::fluent_builders::PutBucketAccelerateConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::PutBucketAccelerateConfiguration::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::PutBucketAccelerateConfiguration::set_bucket): <p>The name of the bucket for which the accelerate configuration is set.</p>
    ///   - [`accelerate_configuration(AccelerateConfiguration)`](crate::client::fluent_builders::PutBucketAccelerateConfiguration::accelerate_configuration) / [`set_accelerate_configuration(Option<AccelerateConfiguration>)`](crate::client::fluent_builders::PutBucketAccelerateConfiguration::set_accelerate_configuration): <p>Container for setting the transfer acceleration state.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::PutBucketAccelerateConfiguration::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::PutBucketAccelerateConfiguration::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`PutBucketAccelerateConfigurationOutput`](crate::output::PutBucketAccelerateConfigurationOutput)

    /// - On failure, responds with [`SdkError<PutBucketAccelerateConfigurationError>`](crate::error::PutBucketAccelerateConfigurationError)
    pub fn put_bucket_accelerate_configuration(
        &self,
    ) -> fluent_builders::PutBucketAccelerateConfiguration {
        fluent_builders::PutBucketAccelerateConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutBucketAcl`](crate::client::fluent_builders::PutBucketAcl) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`acl(BucketCannedAcl)`](crate::client::fluent_builders::PutBucketAcl::acl) / [`set_acl(Option<BucketCannedAcl>)`](crate::client::fluent_builders::PutBucketAcl::set_acl): <p>The canned ACL to apply to the bucket.</p>
    ///   - [`access_control_policy(AccessControlPolicy)`](crate::client::fluent_builders::PutBucketAcl::access_control_policy) / [`set_access_control_policy(Option<AccessControlPolicy>)`](crate::client::fluent_builders::PutBucketAcl::set_access_control_policy): <p>Contains the elements that set the ACL permissions for an object per grantee.</p>
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::PutBucketAcl::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::PutBucketAcl::set_bucket): <p>The bucket to which to apply the ACL.</p>
    ///   - [`content_md5(impl Into<String>)`](crate::client::fluent_builders::PutBucketAcl::content_md5) / [`set_content_md5(Option<String>)`](crate::client::fluent_builders::PutBucketAcl::set_content_md5): <p>The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity check to verify that the request body was not corrupted in transit. For more information, go to <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.</a> </p>  <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
    ///   - [`grant_full_control(impl Into<String>)`](crate::client::fluent_builders::PutBucketAcl::grant_full_control) / [`set_grant_full_control(Option<String>)`](crate::client::fluent_builders::PutBucketAcl::set_grant_full_control): <p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p>
    ///   - [`grant_read(impl Into<String>)`](crate::client::fluent_builders::PutBucketAcl::grant_read) / [`set_grant_read(Option<String>)`](crate::client::fluent_builders::PutBucketAcl::set_grant_read): <p>Allows grantee to list the objects in the bucket.</p>
    ///   - [`grant_read_acp(impl Into<String>)`](crate::client::fluent_builders::PutBucketAcl::grant_read_acp) / [`set_grant_read_acp(Option<String>)`](crate::client::fluent_builders::PutBucketAcl::set_grant_read_acp): <p>Allows grantee to read the bucket ACL.</p>
    ///   - [`grant_write(impl Into<String>)`](crate::client::fluent_builders::PutBucketAcl::grant_write) / [`set_grant_write(Option<String>)`](crate::client::fluent_builders::PutBucketAcl::set_grant_write): <p>Allows grantee to create new objects in the bucket.</p>  <p>For the bucket and object owners of existing objects, also allows deletions and overwrites of those objects.</p>
    ///   - [`grant_write_acp(impl Into<String>)`](crate::client::fluent_builders::PutBucketAcl::grant_write_acp) / [`set_grant_write_acp(Option<String>)`](crate::client::fluent_builders::PutBucketAcl::set_grant_write_acp): <p>Allows grantee to write the ACL for the applicable bucket.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::PutBucketAcl::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::PutBucketAcl::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`PutBucketAclOutput`](crate::output::PutBucketAclOutput)

    /// - On failure, responds with [`SdkError<PutBucketAclError>`](crate::error::PutBucketAclError)
    pub fn put_bucket_acl(&self) -> fluent_builders::PutBucketAcl {
        fluent_builders::PutBucketAcl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutBucketAnalyticsConfiguration`](crate::client::fluent_builders::PutBucketAnalyticsConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::PutBucketAnalyticsConfiguration::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::PutBucketAnalyticsConfiguration::set_bucket): <p>The name of the bucket to which an analytics configuration is stored.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::PutBucketAnalyticsConfiguration::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::PutBucketAnalyticsConfiguration::set_id): <p>The ID that identifies the analytics configuration.</p>
    ///   - [`analytics_configuration(AnalyticsConfiguration)`](crate::client::fluent_builders::PutBucketAnalyticsConfiguration::analytics_configuration) / [`set_analytics_configuration(Option<AnalyticsConfiguration>)`](crate::client::fluent_builders::PutBucketAnalyticsConfiguration::set_analytics_configuration): <p>The configuration and any analyses for the analytics filter.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::PutBucketAnalyticsConfiguration::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::PutBucketAnalyticsConfiguration::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`PutBucketAnalyticsConfigurationOutput`](crate::output::PutBucketAnalyticsConfigurationOutput)

    /// - On failure, responds with [`SdkError<PutBucketAnalyticsConfigurationError>`](crate::error::PutBucketAnalyticsConfigurationError)
    pub fn put_bucket_analytics_configuration(
        &self,
    ) -> fluent_builders::PutBucketAnalyticsConfiguration {
        fluent_builders::PutBucketAnalyticsConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutBucketCors`](crate::client::fluent_builders::PutBucketCors) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::PutBucketCors::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::PutBucketCors::set_bucket): <p>Specifies the bucket impacted by the <code>cors</code>configuration.</p>
    ///   - [`cors_configuration(CorsConfiguration)`](crate::client::fluent_builders::PutBucketCors::cors_configuration) / [`set_cors_configuration(Option<CorsConfiguration>)`](crate::client::fluent_builders::PutBucketCors::set_cors_configuration): <p>Describes the cross-origin access configuration for objects in an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">Enabling Cross-Origin Resource Sharing</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`content_md5(impl Into<String>)`](crate::client::fluent_builders::PutBucketCors::content_md5) / [`set_content_md5(Option<String>)`](crate::client::fluent_builders::PutBucketCors::set_content_md5): <p>The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity check to verify that the request body was not corrupted in transit. For more information, go to <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.</a> </p>  <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::PutBucketCors::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::PutBucketCors::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`PutBucketCorsOutput`](crate::output::PutBucketCorsOutput)

    /// - On failure, responds with [`SdkError<PutBucketCorsError>`](crate::error::PutBucketCorsError)
    pub fn put_bucket_cors(&self) -> fluent_builders::PutBucketCors {
        fluent_builders::PutBucketCors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutBucketEncryption`](crate::client::fluent_builders::PutBucketEncryption) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::PutBucketEncryption::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::PutBucketEncryption::set_bucket): <p>Specifies default encryption for a bucket using server-side encryption with Amazon S3-managed keys (SSE-S3) or customer managed keys (SSE-KMS). For information about the Amazon S3 default encryption feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">Amazon S3 Default Bucket Encryption</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`content_md5(impl Into<String>)`](crate::client::fluent_builders::PutBucketEncryption::content_md5) / [`set_content_md5(Option<String>)`](crate::client::fluent_builders::PutBucketEncryption::set_content_md5): <p>The base64-encoded 128-bit MD5 digest of the server-side encryption configuration.</p>  <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
    ///   - [`server_side_encryption_configuration(ServerSideEncryptionConfiguration)`](crate::client::fluent_builders::PutBucketEncryption::server_side_encryption_configuration) / [`set_server_side_encryption_configuration(Option<ServerSideEncryptionConfiguration>)`](crate::client::fluent_builders::PutBucketEncryption::set_server_side_encryption_configuration): <p>Specifies the default server-side-encryption configuration.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::PutBucketEncryption::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::PutBucketEncryption::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`PutBucketEncryptionOutput`](crate::output::PutBucketEncryptionOutput)

    /// - On failure, responds with [`SdkError<PutBucketEncryptionError>`](crate::error::PutBucketEncryptionError)
    pub fn put_bucket_encryption(&self) -> fluent_builders::PutBucketEncryption {
        fluent_builders::PutBucketEncryption::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutBucketIntelligentTieringConfiguration`](crate::client::fluent_builders::PutBucketIntelligentTieringConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::PutBucketIntelligentTieringConfiguration::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::PutBucketIntelligentTieringConfiguration::set_bucket): <p>The name of the Amazon S3 bucket whose configuration you want to modify or retrieve.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::PutBucketIntelligentTieringConfiguration::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::PutBucketIntelligentTieringConfiguration::set_id): <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
    ///   - [`intelligent_tiering_configuration(IntelligentTieringConfiguration)`](crate::client::fluent_builders::PutBucketIntelligentTieringConfiguration::intelligent_tiering_configuration) / [`set_intelligent_tiering_configuration(Option<IntelligentTieringConfiguration>)`](crate::client::fluent_builders::PutBucketIntelligentTieringConfiguration::set_intelligent_tiering_configuration): <p>Container for S3 Intelligent-Tiering configuration.</p>
    /// - On success, responds with [`PutBucketIntelligentTieringConfigurationOutput`](crate::output::PutBucketIntelligentTieringConfigurationOutput)

    /// - On failure, responds with [`SdkError<PutBucketIntelligentTieringConfigurationError>`](crate::error::PutBucketIntelligentTieringConfigurationError)
    pub fn put_bucket_intelligent_tiering_configuration(
        &self,
    ) -> fluent_builders::PutBucketIntelligentTieringConfiguration {
        fluent_builders::PutBucketIntelligentTieringConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutBucketInventoryConfiguration`](crate::client::fluent_builders::PutBucketInventoryConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::PutBucketInventoryConfiguration::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::PutBucketInventoryConfiguration::set_bucket): <p>The name of the bucket where the inventory configuration will be stored.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::PutBucketInventoryConfiguration::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::PutBucketInventoryConfiguration::set_id): <p>The ID used to identify the inventory configuration.</p>
    ///   - [`inventory_configuration(InventoryConfiguration)`](crate::client::fluent_builders::PutBucketInventoryConfiguration::inventory_configuration) / [`set_inventory_configuration(Option<InventoryConfiguration>)`](crate::client::fluent_builders::PutBucketInventoryConfiguration::set_inventory_configuration): <p>Specifies the inventory configuration.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::PutBucketInventoryConfiguration::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::PutBucketInventoryConfiguration::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`PutBucketInventoryConfigurationOutput`](crate::output::PutBucketInventoryConfigurationOutput)

    /// - On failure, responds with [`SdkError<PutBucketInventoryConfigurationError>`](crate::error::PutBucketInventoryConfigurationError)
    pub fn put_bucket_inventory_configuration(
        &self,
    ) -> fluent_builders::PutBucketInventoryConfiguration {
        fluent_builders::PutBucketInventoryConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutBucketLifecycleConfiguration`](crate::client::fluent_builders::PutBucketLifecycleConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::PutBucketLifecycleConfiguration::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::PutBucketLifecycleConfiguration::set_bucket): <p>The name of the bucket for which to set the configuration.</p>
    ///   - [`lifecycle_configuration(BucketLifecycleConfiguration)`](crate::client::fluent_builders::PutBucketLifecycleConfiguration::lifecycle_configuration) / [`set_lifecycle_configuration(Option<BucketLifecycleConfiguration>)`](crate::client::fluent_builders::PutBucketLifecycleConfiguration::set_lifecycle_configuration): <p>Container for lifecycle rules. You can add as many as 1,000 rules.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::PutBucketLifecycleConfiguration::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::PutBucketLifecycleConfiguration::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`PutBucketLifecycleConfigurationOutput`](crate::output::PutBucketLifecycleConfigurationOutput)

    /// - On failure, responds with [`SdkError<PutBucketLifecycleConfigurationError>`](crate::error::PutBucketLifecycleConfigurationError)
    pub fn put_bucket_lifecycle_configuration(
        &self,
    ) -> fluent_builders::PutBucketLifecycleConfiguration {
        fluent_builders::PutBucketLifecycleConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutBucketLogging`](crate::client::fluent_builders::PutBucketLogging) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::PutBucketLogging::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::PutBucketLogging::set_bucket): <p>The name of the bucket for which to set the logging parameters.</p>
    ///   - [`bucket_logging_status(BucketLoggingStatus)`](crate::client::fluent_builders::PutBucketLogging::bucket_logging_status) / [`set_bucket_logging_status(Option<BucketLoggingStatus>)`](crate::client::fluent_builders::PutBucketLogging::set_bucket_logging_status): <p>Container for logging status information.</p>
    ///   - [`content_md5(impl Into<String>)`](crate::client::fluent_builders::PutBucketLogging::content_md5) / [`set_content_md5(Option<String>)`](crate::client::fluent_builders::PutBucketLogging::set_content_md5): <p>The MD5 hash of the <code>PutBucketLogging</code> request body.</p>  <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::PutBucketLogging::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::PutBucketLogging::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`PutBucketLoggingOutput`](crate::output::PutBucketLoggingOutput)

    /// - On failure, responds with [`SdkError<PutBucketLoggingError>`](crate::error::PutBucketLoggingError)
    pub fn put_bucket_logging(&self) -> fluent_builders::PutBucketLogging {
        fluent_builders::PutBucketLogging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutBucketMetricsConfiguration`](crate::client::fluent_builders::PutBucketMetricsConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::PutBucketMetricsConfiguration::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::PutBucketMetricsConfiguration::set_bucket): <p>The name of the bucket for which the metrics configuration is set.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::PutBucketMetricsConfiguration::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::PutBucketMetricsConfiguration::set_id): <p>The ID used to identify the metrics configuration.</p>
    ///   - [`metrics_configuration(MetricsConfiguration)`](crate::client::fluent_builders::PutBucketMetricsConfiguration::metrics_configuration) / [`set_metrics_configuration(Option<MetricsConfiguration>)`](crate::client::fluent_builders::PutBucketMetricsConfiguration::set_metrics_configuration): <p>Specifies the metrics configuration.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::PutBucketMetricsConfiguration::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::PutBucketMetricsConfiguration::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`PutBucketMetricsConfigurationOutput`](crate::output::PutBucketMetricsConfigurationOutput)

    /// - On failure, responds with [`SdkError<PutBucketMetricsConfigurationError>`](crate::error::PutBucketMetricsConfigurationError)
    pub fn put_bucket_metrics_configuration(
        &self,
    ) -> fluent_builders::PutBucketMetricsConfiguration {
        fluent_builders::PutBucketMetricsConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutBucketNotificationConfiguration`](crate::client::fluent_builders::PutBucketNotificationConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::PutBucketNotificationConfiguration::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::PutBucketNotificationConfiguration::set_bucket): <p>The name of the bucket.</p>
    ///   - [`notification_configuration(NotificationConfiguration)`](crate::client::fluent_builders::PutBucketNotificationConfiguration::notification_configuration) / [`set_notification_configuration(Option<NotificationConfiguration>)`](crate::client::fluent_builders::PutBucketNotificationConfiguration::set_notification_configuration): <p>A container for specifying the notification configuration of the bucket. If this element is empty, notifications are turned off for the bucket.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::PutBucketNotificationConfiguration::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::PutBucketNotificationConfiguration::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    ///   - [`skip_destination_validation(bool)`](crate::client::fluent_builders::PutBucketNotificationConfiguration::skip_destination_validation) / [`set_skip_destination_validation(bool)`](crate::client::fluent_builders::PutBucketNotificationConfiguration::set_skip_destination_validation): <p>Skips validation of Amazon SQS, Amazon SNS, and Lambda destinations. True or false value.</p>
    /// - On success, responds with [`PutBucketNotificationConfigurationOutput`](crate::output::PutBucketNotificationConfigurationOutput)

    /// - On failure, responds with [`SdkError<PutBucketNotificationConfigurationError>`](crate::error::PutBucketNotificationConfigurationError)
    pub fn put_bucket_notification_configuration(
        &self,
    ) -> fluent_builders::PutBucketNotificationConfiguration {
        fluent_builders::PutBucketNotificationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutBucketOwnershipControls`](crate::client::fluent_builders::PutBucketOwnershipControls) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::PutBucketOwnershipControls::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::PutBucketOwnershipControls::set_bucket): <p>The name of the Amazon S3 bucket whose <code>OwnershipControls</code> you want to set.</p>
    ///   - [`content_md5(impl Into<String>)`](crate::client::fluent_builders::PutBucketOwnershipControls::content_md5) / [`set_content_md5(Option<String>)`](crate::client::fluent_builders::PutBucketOwnershipControls::set_content_md5): <p>The MD5 hash of the <code>OwnershipControls</code> request body. </p>  <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::PutBucketOwnershipControls::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::PutBucketOwnershipControls::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    ///   - [`ownership_controls(OwnershipControls)`](crate::client::fluent_builders::PutBucketOwnershipControls::ownership_controls) / [`set_ownership_controls(Option<OwnershipControls>)`](crate::client::fluent_builders::PutBucketOwnershipControls::set_ownership_controls): <p>The <code>OwnershipControls</code> (BucketOwnerEnforced, BucketOwnerPreferred, or ObjectWriter) that you want to apply to this Amazon S3 bucket.</p>
    /// - On success, responds with [`PutBucketOwnershipControlsOutput`](crate::output::PutBucketOwnershipControlsOutput)

    /// - On failure, responds with [`SdkError<PutBucketOwnershipControlsError>`](crate::error::PutBucketOwnershipControlsError)
    pub fn put_bucket_ownership_controls(&self) -> fluent_builders::PutBucketOwnershipControls {
        fluent_builders::PutBucketOwnershipControls::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutBucketPolicy`](crate::client::fluent_builders::PutBucketPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::PutBucketPolicy::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::PutBucketPolicy::set_bucket): <p>The name of the bucket.</p>
    ///   - [`content_md5(impl Into<String>)`](crate::client::fluent_builders::PutBucketPolicy::content_md5) / [`set_content_md5(Option<String>)`](crate::client::fluent_builders::PutBucketPolicy::set_content_md5): <p>The MD5 hash of the request body.</p>  <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
    ///   - [`confirm_remove_self_bucket_access(bool)`](crate::client::fluent_builders::PutBucketPolicy::confirm_remove_self_bucket_access) / [`set_confirm_remove_self_bucket_access(bool)`](crate::client::fluent_builders::PutBucketPolicy::set_confirm_remove_self_bucket_access): <p>Set this parameter to true to confirm that you want to remove your permissions to change this bucket policy in the future.</p>
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::PutBucketPolicy::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::PutBucketPolicy::set_policy): <p>The bucket policy as a JSON document.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::PutBucketPolicy::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::PutBucketPolicy::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`PutBucketPolicyOutput`](crate::output::PutBucketPolicyOutput)

    /// - On failure, responds with [`SdkError<PutBucketPolicyError>`](crate::error::PutBucketPolicyError)
    pub fn put_bucket_policy(&self) -> fluent_builders::PutBucketPolicy {
        fluent_builders::PutBucketPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutBucketReplication`](crate::client::fluent_builders::PutBucketReplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::PutBucketReplication::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::PutBucketReplication::set_bucket): <p>The name of the bucket</p>
    ///   - [`content_md5(impl Into<String>)`](crate::client::fluent_builders::PutBucketReplication::content_md5) / [`set_content_md5(Option<String>)`](crate::client::fluent_builders::PutBucketReplication::set_content_md5): <p>The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>  <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
    ///   - [`replication_configuration(ReplicationConfiguration)`](crate::client::fluent_builders::PutBucketReplication::replication_configuration) / [`set_replication_configuration(Option<ReplicationConfiguration>)`](crate::client::fluent_builders::PutBucketReplication::set_replication_configuration): <p>A container for replication rules. You can add up to 1,000 rules. The maximum size of a replication configuration is 2 MB.</p>
    ///   - [`token(impl Into<String>)`](crate::client::fluent_builders::PutBucketReplication::token) / [`set_token(Option<String>)`](crate::client::fluent_builders::PutBucketReplication::set_token): <p>A token to allow Object Lock to be enabled for an existing bucket.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::PutBucketReplication::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::PutBucketReplication::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`PutBucketReplicationOutput`](crate::output::PutBucketReplicationOutput)

    /// - On failure, responds with [`SdkError<PutBucketReplicationError>`](crate::error::PutBucketReplicationError)
    pub fn put_bucket_replication(&self) -> fluent_builders::PutBucketReplication {
        fluent_builders::PutBucketReplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutBucketRequestPayment`](crate::client::fluent_builders::PutBucketRequestPayment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::PutBucketRequestPayment::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::PutBucketRequestPayment::set_bucket): <p>The bucket name.</p>
    ///   - [`content_md5(impl Into<String>)`](crate::client::fluent_builders::PutBucketRequestPayment::content_md5) / [`set_content_md5(Option<String>)`](crate::client::fluent_builders::PutBucketRequestPayment::set_content_md5): <p>The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>  <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
    ///   - [`request_payment_configuration(RequestPaymentConfiguration)`](crate::client::fluent_builders::PutBucketRequestPayment::request_payment_configuration) / [`set_request_payment_configuration(Option<RequestPaymentConfiguration>)`](crate::client::fluent_builders::PutBucketRequestPayment::set_request_payment_configuration): <p>Container for Payer.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::PutBucketRequestPayment::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::PutBucketRequestPayment::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`PutBucketRequestPaymentOutput`](crate::output::PutBucketRequestPaymentOutput)

    /// - On failure, responds with [`SdkError<PutBucketRequestPaymentError>`](crate::error::PutBucketRequestPaymentError)
    pub fn put_bucket_request_payment(&self) -> fluent_builders::PutBucketRequestPayment {
        fluent_builders::PutBucketRequestPayment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutBucketTagging`](crate::client::fluent_builders::PutBucketTagging) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::PutBucketTagging::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::PutBucketTagging::set_bucket): <p>The bucket name.</p>
    ///   - [`content_md5(impl Into<String>)`](crate::client::fluent_builders::PutBucketTagging::content_md5) / [`set_content_md5(Option<String>)`](crate::client::fluent_builders::PutBucketTagging::set_content_md5): <p>The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>  <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
    ///   - [`tagging(Tagging)`](crate::client::fluent_builders::PutBucketTagging::tagging) / [`set_tagging(Option<Tagging>)`](crate::client::fluent_builders::PutBucketTagging::set_tagging): <p>Container for the <code>TagSet</code> and <code>Tag</code> elements.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::PutBucketTagging::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::PutBucketTagging::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`PutBucketTaggingOutput`](crate::output::PutBucketTaggingOutput)

    /// - On failure, responds with [`SdkError<PutBucketTaggingError>`](crate::error::PutBucketTaggingError)
    pub fn put_bucket_tagging(&self) -> fluent_builders::PutBucketTagging {
        fluent_builders::PutBucketTagging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutBucketVersioning`](crate::client::fluent_builders::PutBucketVersioning) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::PutBucketVersioning::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::PutBucketVersioning::set_bucket): <p>The bucket name.</p>
    ///   - [`content_md5(impl Into<String>)`](crate::client::fluent_builders::PutBucketVersioning::content_md5) / [`set_content_md5(Option<String>)`](crate::client::fluent_builders::PutBucketVersioning::set_content_md5): <p>&gt;The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>  <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
    ///   - [`mfa(impl Into<String>)`](crate::client::fluent_builders::PutBucketVersioning::mfa) / [`set_mfa(Option<String>)`](crate::client::fluent_builders::PutBucketVersioning::set_mfa): <p>The concatenation of the authentication device's serial number, a space, and the value that is displayed on your authentication device.</p>
    ///   - [`versioning_configuration(VersioningConfiguration)`](crate::client::fluent_builders::PutBucketVersioning::versioning_configuration) / [`set_versioning_configuration(Option<VersioningConfiguration>)`](crate::client::fluent_builders::PutBucketVersioning::set_versioning_configuration): <p>Container for setting the versioning state.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::PutBucketVersioning::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::PutBucketVersioning::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`PutBucketVersioningOutput`](crate::output::PutBucketVersioningOutput)

    /// - On failure, responds with [`SdkError<PutBucketVersioningError>`](crate::error::PutBucketVersioningError)
    pub fn put_bucket_versioning(&self) -> fluent_builders::PutBucketVersioning {
        fluent_builders::PutBucketVersioning::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutBucketWebsite`](crate::client::fluent_builders::PutBucketWebsite) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::PutBucketWebsite::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::PutBucketWebsite::set_bucket): <p>The bucket name.</p>
    ///   - [`content_md5(impl Into<String>)`](crate::client::fluent_builders::PutBucketWebsite::content_md5) / [`set_content_md5(Option<String>)`](crate::client::fluent_builders::PutBucketWebsite::set_content_md5): <p>The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>  <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
    ///   - [`website_configuration(WebsiteConfiguration)`](crate::client::fluent_builders::PutBucketWebsite::website_configuration) / [`set_website_configuration(Option<WebsiteConfiguration>)`](crate::client::fluent_builders::PutBucketWebsite::set_website_configuration): <p>Container for the request.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::PutBucketWebsite::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::PutBucketWebsite::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`PutBucketWebsiteOutput`](crate::output::PutBucketWebsiteOutput)

    /// - On failure, responds with [`SdkError<PutBucketWebsiteError>`](crate::error::PutBucketWebsiteError)
    pub fn put_bucket_website(&self) -> fluent_builders::PutBucketWebsite {
        fluent_builders::PutBucketWebsite::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutObject`](crate::client::fluent_builders::PutObject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`acl(ObjectCannedAcl)`](crate::client::fluent_builders::PutObject::acl) / [`set_acl(Option<ObjectCannedAcl>)`](crate::client::fluent_builders::PutObject::set_acl): <p>The canned ACL to apply to the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a>.</p>  <p>This action is not supported by Amazon S3 on Outposts.</p>
    ///   - [`body(byte_stream::ByteStream)`](crate::client::fluent_builders::PutObject::body) / [`set_body(byte_stream::ByteStream)`](crate::client::fluent_builders::PutObject::set_body): <p>Object data.</p>
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::PutObject::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::PutObject::set_bucket): <p>The bucket name to which the PUT action was initiated. </p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>  <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`cache_control(impl Into<String>)`](crate::client::fluent_builders::PutObject::cache_control) / [`set_cache_control(Option<String>)`](crate::client::fluent_builders::PutObject::set_cache_control): <p> Can be used to specify caching behavior along the request/reply chain. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9">http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9</a>.</p>
    ///   - [`content_disposition(impl Into<String>)`](crate::client::fluent_builders::PutObject::content_disposition) / [`set_content_disposition(Option<String>)`](crate::client::fluent_builders::PutObject::set_content_disposition): <p>Specifies presentational information for the object. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1">http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1</a>.</p>
    ///   - [`content_encoding(impl Into<String>)`](crate::client::fluent_builders::PutObject::content_encoding) / [`set_content_encoding(Option<String>)`](crate::client::fluent_builders::PutObject::set_content_encoding): <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11">http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11</a>.</p>
    ///   - [`content_language(impl Into<String>)`](crate::client::fluent_builders::PutObject::content_language) / [`set_content_language(Option<String>)`](crate::client::fluent_builders::PutObject::set_content_language): <p>The language the content is in.</p>
    ///   - [`content_length(i64)`](crate::client::fluent_builders::PutObject::content_length) / [`set_content_length(i64)`](crate::client::fluent_builders::PutObject::set_content_length): <p>Size of the body in bytes. This parameter is useful when the size of the body cannot be determined automatically. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.13">http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.13</a>.</p>
    ///   - [`content_md5(impl Into<String>)`](crate::client::fluent_builders::PutObject::content_md5) / [`set_content_md5(Option<String>)`](crate::client::fluent_builders::PutObject::set_content_md5): <p>The base64-encoded 128-bit MD5 digest of the message (without the headers) according to RFC 1864. This header can be used as a message integrity check to verify that the data is the same data that was originally sent. Although it is optional, we recommend using the Content-MD5 mechanism as an end-to-end integrity check. For more information about REST request authentication, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">REST Authentication</a>.</p>
    ///   - [`content_type(impl Into<String>)`](crate::client::fluent_builders::PutObject::content_type) / [`set_content_type(Option<String>)`](crate::client::fluent_builders::PutObject::set_content_type): <p>A standard MIME type describing the format of the contents. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17">http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17</a>.</p>
    ///   - [`expires(DateTime)`](crate::client::fluent_builders::PutObject::expires) / [`set_expires(Option<DateTime>)`](crate::client::fluent_builders::PutObject::set_expires): <p>The date and time at which the object is no longer cacheable. For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.21">http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.21</a>.</p>
    ///   - [`grant_full_control(impl Into<String>)`](crate::client::fluent_builders::PutObject::grant_full_control) / [`set_grant_full_control(Option<String>)`](crate::client::fluent_builders::PutObject::set_grant_full_control): <p>Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p>  <p>This action is not supported by Amazon S3 on Outposts.</p>
    ///   - [`grant_read(impl Into<String>)`](crate::client::fluent_builders::PutObject::grant_read) / [`set_grant_read(Option<String>)`](crate::client::fluent_builders::PutObject::set_grant_read): <p>Allows grantee to read the object data and its metadata.</p>  <p>This action is not supported by Amazon S3 on Outposts.</p>
    ///   - [`grant_read_acp(impl Into<String>)`](crate::client::fluent_builders::PutObject::grant_read_acp) / [`set_grant_read_acp(Option<String>)`](crate::client::fluent_builders::PutObject::set_grant_read_acp): <p>Allows grantee to read the object ACL.</p>  <p>This action is not supported by Amazon S3 on Outposts.</p>
    ///   - [`grant_write_acp(impl Into<String>)`](crate::client::fluent_builders::PutObject::grant_write_acp) / [`set_grant_write_acp(Option<String>)`](crate::client::fluent_builders::PutObject::set_grant_write_acp): <p>Allows grantee to write the ACL for the applicable object.</p>  <p>This action is not supported by Amazon S3 on Outposts.</p>
    ///   - [`key(impl Into<String>)`](crate::client::fluent_builders::PutObject::key) / [`set_key(Option<String>)`](crate::client::fluent_builders::PutObject::set_key): <p>Object key for which the PUT action was initiated.</p>
    ///   - [`metadata(HashMap<String, String>)`](crate::client::fluent_builders::PutObject::metadata) / [`set_metadata(Option<HashMap<String, String>>)`](crate::client::fluent_builders::PutObject::set_metadata): <p>A map of metadata to store with the object in S3.</p>
    ///   - [`server_side_encryption(ServerSideEncryption)`](crate::client::fluent_builders::PutObject::server_side_encryption) / [`set_server_side_encryption(Option<ServerSideEncryption>)`](crate::client::fluent_builders::PutObject::set_server_side_encryption): <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>
    ///   - [`storage_class(StorageClass)`](crate::client::fluent_builders::PutObject::storage_class) / [`set_storage_class(Option<StorageClass>)`](crate::client::fluent_builders::PutObject::set_storage_class): <p>By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. Amazon S3 on Outposts only uses the OUTPOSTS Storage Class. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`website_redirect_location(impl Into<String>)`](crate::client::fluent_builders::PutObject::website_redirect_location) / [`set_website_redirect_location(Option<String>)`](crate::client::fluent_builders::PutObject::set_website_redirect_location): <p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata. For information about object metadata, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html">Object Key and Metadata</a>.</p>  <p>In the following example, the request header sets the redirect to an object (anotherPage.html) in the same bucket:</p>  <p> <code>x-amz-website-redirect-location: /anotherPage.html</code> </p>  <p>In the following example, the request header sets the object redirect to another website:</p>  <p> <code>x-amz-website-redirect-location: http://www.example.com/</code> </p>  <p>For more information about website hosting in Amazon S3, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">Hosting Websites on Amazon S3</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html">How to Configure Website Page Redirects</a>. </p>
    ///   - [`sse_customer_algorithm(impl Into<String>)`](crate::client::fluent_builders::PutObject::sse_customer_algorithm) / [`set_sse_customer_algorithm(Option<String>)`](crate::client::fluent_builders::PutObject::set_sse_customer_algorithm): <p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>
    ///   - [`sse_customer_key(impl Into<String>)`](crate::client::fluent_builders::PutObject::sse_customer_key) / [`set_sse_customer_key(Option<String>)`](crate::client::fluent_builders::PutObject::set_sse_customer_key): <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
    ///   - [`sse_customer_key_md5(impl Into<String>)`](crate::client::fluent_builders::PutObject::sse_customer_key_md5) / [`set_sse_customer_key_md5(Option<String>)`](crate::client::fluent_builders::PutObject::set_sse_customer_key_md5): <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
    ///   - [`ssekms_key_id(impl Into<String>)`](crate::client::fluent_builders::PutObject::ssekms_key_id) / [`set_ssekms_key_id(Option<String>)`](crate::client::fluent_builders::PutObject::set_ssekms_key_id): <p>If <code>x-amz-server-side-encryption</code> is present and has the value of <code>aws:kms</code>, this header specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetrical customer managed key that was used for the object. If you specify <code>x-amz-server-side-encryption:aws:kms</code>, but do not provide<code> x-amz-server-side-encryption-aws-kms-key-id</code>, Amazon S3 uses the Amazon Web Services managed key to protect the data. If the KMS key does not exist in the same account issuing the command, you must use the full ARN and not just the ID. </p>
    ///   - [`ssekms_encryption_context(impl Into<String>)`](crate::client::fluent_builders::PutObject::ssekms_encryption_context) / [`set_ssekms_encryption_context(Option<String>)`](crate::client::fluent_builders::PutObject::set_ssekms_encryption_context): <p>Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p>
    ///   - [`bucket_key_enabled(bool)`](crate::client::fluent_builders::PutObject::bucket_key_enabled) / [`set_bucket_key_enabled(bool)`](crate::client::fluent_builders::PutObject::set_bucket_key_enabled): <p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using AWS KMS (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.</p>  <p>Specifying this header with a PUT action doesn’t affect bucket-level settings for S3 Bucket Key.</p>
    ///   - [`request_payer(RequestPayer)`](crate::client::fluent_builders::PutObject::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::client::fluent_builders::PutObject::set_request_payer): <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`tagging(impl Into<String>)`](crate::client::fluent_builders::PutObject::tagging) / [`set_tagging(Option<String>)`](crate::client::fluent_builders::PutObject::set_tagging): <p>The tag-set for the object. The tag-set must be encoded as URL Query parameters. (For example, "Key1=Value1")</p>
    ///   - [`object_lock_mode(ObjectLockMode)`](crate::client::fluent_builders::PutObject::object_lock_mode) / [`set_object_lock_mode(Option<ObjectLockMode>)`](crate::client::fluent_builders::PutObject::set_object_lock_mode): <p>The Object Lock mode that you want to apply to this object.</p>
    ///   - [`object_lock_retain_until_date(DateTime)`](crate::client::fluent_builders::PutObject::object_lock_retain_until_date) / [`set_object_lock_retain_until_date(Option<DateTime>)`](crate::client::fluent_builders::PutObject::set_object_lock_retain_until_date): <p>The date and time when you want this object's Object Lock to expire. Must be formatted as a timestamp parameter.</p>
    ///   - [`object_lock_legal_hold_status(ObjectLockLegalHoldStatus)`](crate::client::fluent_builders::PutObject::object_lock_legal_hold_status) / [`set_object_lock_legal_hold_status(Option<ObjectLockLegalHoldStatus>)`](crate::client::fluent_builders::PutObject::set_object_lock_legal_hold_status): <p>Specifies whether a legal hold will be applied to this object. For more information about S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Object Lock</a>.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::PutObject::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::PutObject::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`PutObjectOutput`](crate::output::PutObjectOutput) with field(s):
    ///   - [`expiration(Option<String>)`](crate::output::PutObjectOutput::expiration): <p> If the expiration is configured for the object (see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html">PutBucketLifecycleConfiguration</a>), the response includes this header. It includes the expiry-date and rule-id key-value pairs that provide information about object expiration. The value of the rule-id is URL encoded.</p>
    ///   - [`e_tag(Option<String>)`](crate::output::PutObjectOutput::e_tag): <p>Entity tag for the uploaded object.</p>
    ///   - [`server_side_encryption(Option<ServerSideEncryption>)`](crate::output::PutObjectOutput::server_side_encryption): <p>If you specified server-side encryption either with an Amazon Web Services KMS key or Amazon S3-managed encryption key in your PUT request, the response includes this header. It confirms the encryption algorithm that Amazon S3 used to encrypt the object.</p>
    ///   - [`version_id(Option<String>)`](crate::output::PutObjectOutput::version_id): <p>Version of the object.</p>
    ///   - [`sse_customer_algorithm(Option<String>)`](crate::output::PutObjectOutput::sse_customer_algorithm): <p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header confirming the encryption algorithm used.</p>
    ///   - [`sse_customer_key_md5(Option<String>)`](crate::output::PutObjectOutput::sse_customer_key_md5): <p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header to provide round-trip message integrity verification of the customer-provided encryption key.</p>
    ///   - [`ssekms_key_id(Option<String>)`](crate::output::PutObjectOutput::ssekms_key_id): <p>If <code>x-amz-server-side-encryption</code> is present and has the value of <code>aws:kms</code>, this header specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric customer managed key that was used for the object. </p>
    ///   - [`ssekms_encryption_context(Option<String>)`](crate::output::PutObjectOutput::ssekms_encryption_context): <p>If present, specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p>
    ///   - [`bucket_key_enabled(bool)`](crate::output::PutObjectOutput::bucket_key_enabled): <p>Indicates whether the uploaded object uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    ///   - [`request_charged(Option<RequestCharged>)`](crate::output::PutObjectOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p>
    /// - On failure, responds with [`SdkError<PutObjectError>`](crate::error::PutObjectError)
    pub fn put_object(&self) -> fluent_builders::PutObject {
        fluent_builders::PutObject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutObjectAcl`](crate::client::fluent_builders::PutObjectAcl) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`acl(ObjectCannedAcl)`](crate::client::fluent_builders::PutObjectAcl::acl) / [`set_acl(Option<ObjectCannedAcl>)`](crate::client::fluent_builders::PutObjectAcl::set_acl): <p>The canned ACL to apply to the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a>.</p>
    ///   - [`access_control_policy(AccessControlPolicy)`](crate::client::fluent_builders::PutObjectAcl::access_control_policy) / [`set_access_control_policy(Option<AccessControlPolicy>)`](crate::client::fluent_builders::PutObjectAcl::set_access_control_policy): <p>Contains the elements that set the ACL permissions for an object per grantee.</p>
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::PutObjectAcl::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::PutObjectAcl::set_bucket): <p>The bucket name that contains the object to which you want to attach the ACL. </p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`content_md5(impl Into<String>)`](crate::client::fluent_builders::PutObjectAcl::content_md5) / [`set_content_md5(Option<String>)`](crate::client::fluent_builders::PutObjectAcl::set_content_md5): <p>The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity check to verify that the request body was not corrupted in transit. For more information, go to <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.&gt;</a> </p>  <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
    ///   - [`grant_full_control(impl Into<String>)`](crate::client::fluent_builders::PutObjectAcl::grant_full_control) / [`set_grant_full_control(Option<String>)`](crate::client::fluent_builders::PutObjectAcl::set_grant_full_control): <p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p>  <p>This action is not supported by Amazon S3 on Outposts.</p>
    ///   - [`grant_read(impl Into<String>)`](crate::client::fluent_builders::PutObjectAcl::grant_read) / [`set_grant_read(Option<String>)`](crate::client::fluent_builders::PutObjectAcl::set_grant_read): <p>Allows grantee to list the objects in the bucket.</p>  <p>This action is not supported by Amazon S3 on Outposts.</p>
    ///   - [`grant_read_acp(impl Into<String>)`](crate::client::fluent_builders::PutObjectAcl::grant_read_acp) / [`set_grant_read_acp(Option<String>)`](crate::client::fluent_builders::PutObjectAcl::set_grant_read_acp): <p>Allows grantee to read the bucket ACL.</p>  <p>This action is not supported by Amazon S3 on Outposts.</p>
    ///   - [`grant_write(impl Into<String>)`](crate::client::fluent_builders::PutObjectAcl::grant_write) / [`set_grant_write(Option<String>)`](crate::client::fluent_builders::PutObjectAcl::set_grant_write): <p>Allows grantee to create new objects in the bucket.</p>  <p>For the bucket and object owners of existing objects, also allows deletions and overwrites of those objects.</p>
    ///   - [`grant_write_acp(impl Into<String>)`](crate::client::fluent_builders::PutObjectAcl::grant_write_acp) / [`set_grant_write_acp(Option<String>)`](crate::client::fluent_builders::PutObjectAcl::set_grant_write_acp): <p>Allows grantee to write the ACL for the applicable bucket.</p>  <p>This action is not supported by Amazon S3 on Outposts.</p>
    ///   - [`key(impl Into<String>)`](crate::client::fluent_builders::PutObjectAcl::key) / [`set_key(Option<String>)`](crate::client::fluent_builders::PutObjectAcl::set_key): <p>Key for which the PUT action was initiated.</p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>  <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`request_payer(RequestPayer)`](crate::client::fluent_builders::PutObjectAcl::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::client::fluent_builders::PutObjectAcl::set_request_payer): <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`version_id(impl Into<String>)`](crate::client::fluent_builders::PutObjectAcl::version_id) / [`set_version_id(Option<String>)`](crate::client::fluent_builders::PutObjectAcl::set_version_id): <p>VersionId used to reference a specific version of the object.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::PutObjectAcl::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::PutObjectAcl::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`PutObjectAclOutput`](crate::output::PutObjectAclOutput) with field(s):
    ///   - [`request_charged(Option<RequestCharged>)`](crate::output::PutObjectAclOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p>
    /// - On failure, responds with [`SdkError<PutObjectAclError>`](crate::error::PutObjectAclError)
    pub fn put_object_acl(&self) -> fluent_builders::PutObjectAcl {
        fluent_builders::PutObjectAcl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutObjectLegalHold`](crate::client::fluent_builders::PutObjectLegalHold) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::PutObjectLegalHold::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::PutObjectLegalHold::set_bucket): <p>The bucket name containing the object that you want to place a Legal Hold on. </p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`key(impl Into<String>)`](crate::client::fluent_builders::PutObjectLegalHold::key) / [`set_key(Option<String>)`](crate::client::fluent_builders::PutObjectLegalHold::set_key): <p>The key name for the object that you want to place a Legal Hold on.</p>
    ///   - [`legal_hold(ObjectLockLegalHold)`](crate::client::fluent_builders::PutObjectLegalHold::legal_hold) / [`set_legal_hold(Option<ObjectLockLegalHold>)`](crate::client::fluent_builders::PutObjectLegalHold::set_legal_hold): <p>Container element for the Legal Hold configuration you want to apply to the specified object.</p>
    ///   - [`request_payer(RequestPayer)`](crate::client::fluent_builders::PutObjectLegalHold::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::client::fluent_builders::PutObjectLegalHold::set_request_payer): <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`version_id(impl Into<String>)`](crate::client::fluent_builders::PutObjectLegalHold::version_id) / [`set_version_id(Option<String>)`](crate::client::fluent_builders::PutObjectLegalHold::set_version_id): <p>The version ID of the object that you want to place a Legal Hold on.</p>
    ///   - [`content_md5(impl Into<String>)`](crate::client::fluent_builders::PutObjectLegalHold::content_md5) / [`set_content_md5(Option<String>)`](crate::client::fluent_builders::PutObjectLegalHold::set_content_md5): <p>The MD5 hash for the request body.</p>  <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::PutObjectLegalHold::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::PutObjectLegalHold::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`PutObjectLegalHoldOutput`](crate::output::PutObjectLegalHoldOutput) with field(s):
    ///   - [`request_charged(Option<RequestCharged>)`](crate::output::PutObjectLegalHoldOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p>
    /// - On failure, responds with [`SdkError<PutObjectLegalHoldError>`](crate::error::PutObjectLegalHoldError)
    pub fn put_object_legal_hold(&self) -> fluent_builders::PutObjectLegalHold {
        fluent_builders::PutObjectLegalHold::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutObjectLockConfiguration`](crate::client::fluent_builders::PutObjectLockConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::PutObjectLockConfiguration::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::PutObjectLockConfiguration::set_bucket): <p>The bucket whose Object Lock configuration you want to create or replace.</p>
    ///   - [`object_lock_configuration(ObjectLockConfiguration)`](crate::client::fluent_builders::PutObjectLockConfiguration::object_lock_configuration) / [`set_object_lock_configuration(Option<ObjectLockConfiguration>)`](crate::client::fluent_builders::PutObjectLockConfiguration::set_object_lock_configuration): <p>The Object Lock configuration that you want to apply to the specified bucket.</p>
    ///   - [`request_payer(RequestPayer)`](crate::client::fluent_builders::PutObjectLockConfiguration::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::client::fluent_builders::PutObjectLockConfiguration::set_request_payer): <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`token(impl Into<String>)`](crate::client::fluent_builders::PutObjectLockConfiguration::token) / [`set_token(Option<String>)`](crate::client::fluent_builders::PutObjectLockConfiguration::set_token): <p>A token to allow Object Lock to be enabled for an existing bucket.</p>
    ///   - [`content_md5(impl Into<String>)`](crate::client::fluent_builders::PutObjectLockConfiguration::content_md5) / [`set_content_md5(Option<String>)`](crate::client::fluent_builders::PutObjectLockConfiguration::set_content_md5): <p>The MD5 hash for the request body.</p>  <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::PutObjectLockConfiguration::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::PutObjectLockConfiguration::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`PutObjectLockConfigurationOutput`](crate::output::PutObjectLockConfigurationOutput) with field(s):
    ///   - [`request_charged(Option<RequestCharged>)`](crate::output::PutObjectLockConfigurationOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p>
    /// - On failure, responds with [`SdkError<PutObjectLockConfigurationError>`](crate::error::PutObjectLockConfigurationError)
    pub fn put_object_lock_configuration(&self) -> fluent_builders::PutObjectLockConfiguration {
        fluent_builders::PutObjectLockConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutObjectRetention`](crate::client::fluent_builders::PutObjectRetention) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::PutObjectRetention::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::PutObjectRetention::set_bucket): <p>The bucket name that contains the object you want to apply this Object Retention configuration to. </p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`key(impl Into<String>)`](crate::client::fluent_builders::PutObjectRetention::key) / [`set_key(Option<String>)`](crate::client::fluent_builders::PutObjectRetention::set_key): <p>The key name for the object that you want to apply this Object Retention configuration to.</p>
    ///   - [`retention(ObjectLockRetention)`](crate::client::fluent_builders::PutObjectRetention::retention) / [`set_retention(Option<ObjectLockRetention>)`](crate::client::fluent_builders::PutObjectRetention::set_retention): <p>The container element for the Object Retention configuration.</p>
    ///   - [`request_payer(RequestPayer)`](crate::client::fluent_builders::PutObjectRetention::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::client::fluent_builders::PutObjectRetention::set_request_payer): <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`version_id(impl Into<String>)`](crate::client::fluent_builders::PutObjectRetention::version_id) / [`set_version_id(Option<String>)`](crate::client::fluent_builders::PutObjectRetention::set_version_id): <p>The version ID for the object that you want to apply this Object Retention configuration to.</p>
    ///   - [`bypass_governance_retention(bool)`](crate::client::fluent_builders::PutObjectRetention::bypass_governance_retention) / [`set_bypass_governance_retention(bool)`](crate::client::fluent_builders::PutObjectRetention::set_bypass_governance_retention): <p>Indicates whether this action should bypass Governance-mode restrictions.</p>
    ///   - [`content_md5(impl Into<String>)`](crate::client::fluent_builders::PutObjectRetention::content_md5) / [`set_content_md5(Option<String>)`](crate::client::fluent_builders::PutObjectRetention::set_content_md5): <p>The MD5 hash for the request body.</p>  <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::PutObjectRetention::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::PutObjectRetention::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`PutObjectRetentionOutput`](crate::output::PutObjectRetentionOutput) with field(s):
    ///   - [`request_charged(Option<RequestCharged>)`](crate::output::PutObjectRetentionOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p>
    /// - On failure, responds with [`SdkError<PutObjectRetentionError>`](crate::error::PutObjectRetentionError)
    pub fn put_object_retention(&self) -> fluent_builders::PutObjectRetention {
        fluent_builders::PutObjectRetention::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutObjectTagging`](crate::client::fluent_builders::PutObjectTagging) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::PutObjectTagging::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::PutObjectTagging::set_bucket): <p>The bucket name containing the object. </p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>  <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`key(impl Into<String>)`](crate::client::fluent_builders::PutObjectTagging::key) / [`set_key(Option<String>)`](crate::client::fluent_builders::PutObjectTagging::set_key): <p>Name of the object key.</p>
    ///   - [`version_id(impl Into<String>)`](crate::client::fluent_builders::PutObjectTagging::version_id) / [`set_version_id(Option<String>)`](crate::client::fluent_builders::PutObjectTagging::set_version_id): <p>The versionId of the object that the tag-set will be added to.</p>
    ///   - [`content_md5(impl Into<String>)`](crate::client::fluent_builders::PutObjectTagging::content_md5) / [`set_content_md5(Option<String>)`](crate::client::fluent_builders::PutObjectTagging::set_content_md5): <p>The MD5 hash for the request body.</p>  <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
    ///   - [`tagging(Tagging)`](crate::client::fluent_builders::PutObjectTagging::tagging) / [`set_tagging(Option<Tagging>)`](crate::client::fluent_builders::PutObjectTagging::set_tagging): <p>Container for the <code>TagSet</code> and <code>Tag</code> elements</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::PutObjectTagging::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::PutObjectTagging::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    ///   - [`request_payer(RequestPayer)`](crate::client::fluent_builders::PutObjectTagging::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::client::fluent_builders::PutObjectTagging::set_request_payer): <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// - On success, responds with [`PutObjectTaggingOutput`](crate::output::PutObjectTaggingOutput) with field(s):
    ///   - [`version_id(Option<String>)`](crate::output::PutObjectTaggingOutput::version_id): <p>The versionId of the object the tag-set was added to.</p>
    /// - On failure, responds with [`SdkError<PutObjectTaggingError>`](crate::error::PutObjectTaggingError)
    pub fn put_object_tagging(&self) -> fluent_builders::PutObjectTagging {
        fluent_builders::PutObjectTagging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutPublicAccessBlock`](crate::client::fluent_builders::PutPublicAccessBlock) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::PutPublicAccessBlock::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::PutPublicAccessBlock::set_bucket): <p>The name of the Amazon S3 bucket whose <code>PublicAccessBlock</code> configuration you want to set.</p>
    ///   - [`content_md5(impl Into<String>)`](crate::client::fluent_builders::PutPublicAccessBlock::content_md5) / [`set_content_md5(Option<String>)`](crate::client::fluent_builders::PutPublicAccessBlock::set_content_md5): <p>The MD5 hash of the <code>PutPublicAccessBlock</code> request body. </p>  <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
    ///   - [`public_access_block_configuration(PublicAccessBlockConfiguration)`](crate::client::fluent_builders::PutPublicAccessBlock::public_access_block_configuration) / [`set_public_access_block_configuration(Option<PublicAccessBlockConfiguration>)`](crate::client::fluent_builders::PutPublicAccessBlock::set_public_access_block_configuration): <p>The <code>PublicAccessBlock</code> configuration that you want to apply to this Amazon S3 bucket. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::PutPublicAccessBlock::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::PutPublicAccessBlock::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`PutPublicAccessBlockOutput`](crate::output::PutPublicAccessBlockOutput)

    /// - On failure, responds with [`SdkError<PutPublicAccessBlockError>`](crate::error::PutPublicAccessBlockError)
    pub fn put_public_access_block(&self) -> fluent_builders::PutPublicAccessBlock {
        fluent_builders::PutPublicAccessBlock::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RestoreObject`](crate::client::fluent_builders::RestoreObject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::RestoreObject::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::RestoreObject::set_bucket): <p>The bucket name containing the object to restore. </p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>  <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`key(impl Into<String>)`](crate::client::fluent_builders::RestoreObject::key) / [`set_key(Option<String>)`](crate::client::fluent_builders::RestoreObject::set_key): <p>Object key for which the action was initiated.</p>
    ///   - [`version_id(impl Into<String>)`](crate::client::fluent_builders::RestoreObject::version_id) / [`set_version_id(Option<String>)`](crate::client::fluent_builders::RestoreObject::set_version_id): <p>VersionId used to reference a specific version of the object.</p>
    ///   - [`restore_request(RestoreRequest)`](crate::client::fluent_builders::RestoreObject::restore_request) / [`set_restore_request(Option<RestoreRequest>)`](crate::client::fluent_builders::RestoreObject::set_restore_request): <p>Container for restore job parameters.</p>
    ///   - [`request_payer(RequestPayer)`](crate::client::fluent_builders::RestoreObject::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::client::fluent_builders::RestoreObject::set_request_payer): <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::RestoreObject::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::RestoreObject::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`RestoreObjectOutput`](crate::output::RestoreObjectOutput) with field(s):
    ///   - [`request_charged(Option<RequestCharged>)`](crate::output::RestoreObjectOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p>
    ///   - [`restore_output_path(Option<String>)`](crate::output::RestoreObjectOutput::restore_output_path): <p>Indicates the path in the provided S3 output location where Select results will be restored to.</p>
    /// - On failure, responds with [`SdkError<RestoreObjectError>`](crate::error::RestoreObjectError)
    pub fn restore_object(&self) -> fluent_builders::RestoreObject {
        fluent_builders::RestoreObject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SelectObjectContent`](crate::client::fluent_builders::SelectObjectContent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::SelectObjectContent::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::SelectObjectContent::set_bucket): <p>The S3 bucket.</p>
    ///   - [`key(impl Into<String>)`](crate::client::fluent_builders::SelectObjectContent::key) / [`set_key(Option<String>)`](crate::client::fluent_builders::SelectObjectContent::set_key): <p>The object key.</p>
    ///   - [`sse_customer_algorithm(impl Into<String>)`](crate::client::fluent_builders::SelectObjectContent::sse_customer_algorithm) / [`set_sse_customer_algorithm(Option<String>)`](crate::client::fluent_builders::SelectObjectContent::set_sse_customer_algorithm): <p>The SSE Algorithm used to encrypt the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html">Server-Side Encryption (Using Customer-Provided Encryption Keys</a>. </p>
    ///   - [`sse_customer_key(impl Into<String>)`](crate::client::fluent_builders::SelectObjectContent::sse_customer_key) / [`set_sse_customer_key(Option<String>)`](crate::client::fluent_builders::SelectObjectContent::set_sse_customer_key): <p>The SSE Customer Key. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html">Server-Side Encryption (Using Customer-Provided Encryption Keys</a>. </p>
    ///   - [`sse_customer_key_md5(impl Into<String>)`](crate::client::fluent_builders::SelectObjectContent::sse_customer_key_md5) / [`set_sse_customer_key_md5(Option<String>)`](crate::client::fluent_builders::SelectObjectContent::set_sse_customer_key_md5): <p>The SSE Customer Key MD5. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html">Server-Side Encryption (Using Customer-Provided Encryption Keys</a>. </p>
    ///   - [`expression(impl Into<String>)`](crate::client::fluent_builders::SelectObjectContent::expression) / [`set_expression(Option<String>)`](crate::client::fluent_builders::SelectObjectContent::set_expression): <p>The expression that is used to query the object.</p>
    ///   - [`expression_type(ExpressionType)`](crate::client::fluent_builders::SelectObjectContent::expression_type) / [`set_expression_type(Option<ExpressionType>)`](crate::client::fluent_builders::SelectObjectContent::set_expression_type): <p>The type of the provided expression (for example, SQL).</p>
    ///   - [`request_progress(RequestProgress)`](crate::client::fluent_builders::SelectObjectContent::request_progress) / [`set_request_progress(Option<RequestProgress>)`](crate::client::fluent_builders::SelectObjectContent::set_request_progress): <p>Specifies if periodic request progress information should be enabled.</p>
    ///   - [`input_serialization(InputSerialization)`](crate::client::fluent_builders::SelectObjectContent::input_serialization) / [`set_input_serialization(Option<InputSerialization>)`](crate::client::fluent_builders::SelectObjectContent::set_input_serialization): <p>Describes the format of the data in the object that is being queried.</p>
    ///   - [`output_serialization(OutputSerialization)`](crate::client::fluent_builders::SelectObjectContent::output_serialization) / [`set_output_serialization(Option<OutputSerialization>)`](crate::client::fluent_builders::SelectObjectContent::set_output_serialization): <p>Describes the format of the data that you want Amazon S3 to return in response.</p>
    ///   - [`scan_range(ScanRange)`](crate::client::fluent_builders::SelectObjectContent::scan_range) / [`set_scan_range(Option<ScanRange>)`](crate::client::fluent_builders::SelectObjectContent::set_scan_range): <p>Specifies the byte range of the object to get the records from. A record is processed when its first byte is contained by the range. This parameter is optional, but when specified, it must not be empty. See RFC 2616, Section 14.35.1 about how to specify the start and end of the range.</p>  <p> <code>ScanRange</code>may be used in the following ways:</p>  <ul>   <li> <p> <code>     <scanrange>      <start>       50      </start>      <end>       100      </end>     </scanrange></code> - process only the records starting between the bytes 50 and 100 (inclusive, counting from zero)</p> </li>   <li> <p> <code>     <scanrange>      <start>       50      </start>     </scanrange></code> - process only the records starting after the byte 50</p> </li>   <li> <p> <code>     <scanrange>      <end>       50      </end>     </scanrange></code> - process only the records within the last 50 bytes of the file.</p> </li>  </ul>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::SelectObjectContent::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::SelectObjectContent::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`SelectObjectContentOutput`](crate::output::SelectObjectContentOutput) with field(s):
    ///   - [`payload(Receiver<crate::model::SelectObjectContentEventStream, crate::error::SelectObjectContentError>)`](crate::output::SelectObjectContentOutput::payload): <p>The array of results.</p>
    /// - On failure, responds with [`SdkError<SelectObjectContentError>`](crate::error::SelectObjectContentError)
    pub fn select_object_content(&self) -> fluent_builders::SelectObjectContent {
        fluent_builders::SelectObjectContent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UploadPart`](crate::client::fluent_builders::UploadPart) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`body(byte_stream::ByteStream)`](crate::client::fluent_builders::UploadPart::body) / [`set_body(byte_stream::ByteStream)`](crate::client::fluent_builders::UploadPart::set_body): <p>Object data.</p>
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::UploadPart::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::UploadPart::set_bucket): <p>The name of the bucket to which the multipart upload was initiated.</p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>  <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`content_length(i64)`](crate::client::fluent_builders::UploadPart::content_length) / [`set_content_length(i64)`](crate::client::fluent_builders::UploadPart::set_content_length): <p>Size of the body in bytes. This parameter is useful when the size of the body cannot be determined automatically.</p>
    ///   - [`content_md5(impl Into<String>)`](crate::client::fluent_builders::UploadPart::content_md5) / [`set_content_md5(Option<String>)`](crate::client::fluent_builders::UploadPart::set_content_md5): <p>The base64-encoded 128-bit MD5 digest of the part data. This parameter is auto-populated when using the command from the CLI. This parameter is required if object lock parameters are specified.</p>
    ///   - [`key(impl Into<String>)`](crate::client::fluent_builders::UploadPart::key) / [`set_key(Option<String>)`](crate::client::fluent_builders::UploadPart::set_key): <p>Object key for which the multipart upload was initiated.</p>
    ///   - [`part_number(i32)`](crate::client::fluent_builders::UploadPart::part_number) / [`set_part_number(i32)`](crate::client::fluent_builders::UploadPart::set_part_number): <p>Part number of part being uploaded. This is a positive integer between 1 and 10,000.</p>
    ///   - [`upload_id(impl Into<String>)`](crate::client::fluent_builders::UploadPart::upload_id) / [`set_upload_id(Option<String>)`](crate::client::fluent_builders::UploadPart::set_upload_id): <p>Upload ID identifying the multipart upload whose part is being uploaded.</p>
    ///   - [`sse_customer_algorithm(impl Into<String>)`](crate::client::fluent_builders::UploadPart::sse_customer_algorithm) / [`set_sse_customer_algorithm(Option<String>)`](crate::client::fluent_builders::UploadPart::set_sse_customer_algorithm): <p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>
    ///   - [`sse_customer_key(impl Into<String>)`](crate::client::fluent_builders::UploadPart::sse_customer_key) / [`set_sse_customer_key(Option<String>)`](crate::client::fluent_builders::UploadPart::set_sse_customer_key): <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm header</code>. This must be the same encryption key specified in the initiate multipart upload request.</p>
    ///   - [`sse_customer_key_md5(impl Into<String>)`](crate::client::fluent_builders::UploadPart::sse_customer_key_md5) / [`set_sse_customer_key_md5(Option<String>)`](crate::client::fluent_builders::UploadPart::set_sse_customer_key_md5): <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
    ///   - [`request_payer(RequestPayer)`](crate::client::fluent_builders::UploadPart::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::client::fluent_builders::UploadPart::set_request_payer): <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::UploadPart::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::UploadPart::set_expected_bucket_owner): <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`UploadPartOutput`](crate::output::UploadPartOutput) with field(s):
    ///   - [`server_side_encryption(Option<ServerSideEncryption>)`](crate::output::UploadPartOutput::server_side_encryption): <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>
    ///   - [`e_tag(Option<String>)`](crate::output::UploadPartOutput::e_tag): <p>Entity tag for the uploaded object.</p>
    ///   - [`sse_customer_algorithm(Option<String>)`](crate::output::UploadPartOutput::sse_customer_algorithm): <p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header confirming the encryption algorithm used.</p>
    ///   - [`sse_customer_key_md5(Option<String>)`](crate::output::UploadPartOutput::sse_customer_key_md5): <p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header to provide round-trip message integrity verification of the customer-provided encryption key.</p>
    ///   - [`ssekms_key_id(Option<String>)`](crate::output::UploadPartOutput::ssekms_key_id): <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric customer managed key was used for the object.</p>
    ///   - [`bucket_key_enabled(bool)`](crate::output::UploadPartOutput::bucket_key_enabled): <p>Indicates whether the multipart upload uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    ///   - [`request_charged(Option<RequestCharged>)`](crate::output::UploadPartOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p>
    /// - On failure, responds with [`SdkError<UploadPartError>`](crate::error::UploadPartError)
    pub fn upload_part(&self) -> fluent_builders::UploadPart {
        fluent_builders::UploadPart::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UploadPartCopy`](crate::client::fluent_builders::UploadPartCopy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::client::fluent_builders::UploadPartCopy::bucket) / [`set_bucket(Option<String>)`](crate::client::fluent_builders::UploadPartCopy::set_bucket): <p>The bucket name.</p>  <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>  <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`copy_source(impl Into<String>)`](crate::client::fluent_builders::UploadPartCopy::copy_source) / [`set_copy_source(Option<String>)`](crate::client::fluent_builders::UploadPartCopy::set_copy_source): <p>Specifies the source object for the copy operation. You specify the value in one of two formats, depending on whether you want to access the source object through an <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">access point</a>:</p>  <ul>   <li> <p>For objects not accessed through an access point, specify the name of the source bucket and key of the source object, separated by a slash (/). For example, to copy the object <code>reports/january.pdf</code> from the bucket <code>awsexamplebucket</code>, use <code>awsexamplebucket/reports/january.pdf</code>. The value must be URL encoded.</p> </li>   <li> <p>For objects accessed through access points, specify the Amazon Resource Name (ARN) of the object as accessed through the access point, in the format <code>arn:aws:s3:     <region>      :      <account-id>       :accesspoint/       <access-point-name>        /object/        <key></key>       </access-point-name>      </account-id>     </region></code>. For example, to copy the object <code>reports/january.pdf</code> through access point <code>my-access-point</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3:us-west-2:123456789012:accesspoint/my-access-point/object/reports/january.pdf</code>. The value must be URL encoded.</p> <note>     <p>Amazon S3 supports copy operations using access points only when the source and destination buckets are in the same Amazon Web Services Region.</p>    </note> <p>Alternatively, for objects accessed through Amazon S3 on Outposts, specify the ARN of the object as accessed in the format <code>arn:aws:s3-outposts:     <region>      :      <account-id>       :outpost/       <outpost-id>        /object/        <key></key>       </outpost-id>      </account-id>     </region></code>. For example, to copy the object <code>reports/january.pdf</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/object/reports/january.pdf</code>. The value must be URL encoded. </p> </li>  </ul>  <p>To copy a specific version of an object, append <code>?versionId=   <version-id></version-id></code> to the value (for example, <code>awsexamplebucket/reports/january.pdf?versionId=QUpfdndhfd8438MNFDN93jdnJFkdmqnh893</code>). If you don't specify a version ID, Amazon S3 copies the latest version of the source object.</p>
    ///   - [`copy_source_if_match(impl Into<String>)`](crate::client::fluent_builders::UploadPartCopy::copy_source_if_match) / [`set_copy_source_if_match(Option<String>)`](crate::client::fluent_builders::UploadPartCopy::set_copy_source_if_match): <p>Copies the object if its entity tag (ETag) matches the specified tag.</p>
    ///   - [`copy_source_if_modified_since(DateTime)`](crate::client::fluent_builders::UploadPartCopy::copy_source_if_modified_since) / [`set_copy_source_if_modified_since(Option<DateTime>)`](crate::client::fluent_builders::UploadPartCopy::set_copy_source_if_modified_since): <p>Copies the object if it has been modified since the specified time.</p>
    ///   - [`copy_source_if_none_match(impl Into<String>)`](crate::client::fluent_builders::UploadPartCopy::copy_source_if_none_match) / [`set_copy_source_if_none_match(Option<String>)`](crate::client::fluent_builders::UploadPartCopy::set_copy_source_if_none_match): <p>Copies the object if its entity tag (ETag) is different than the specified ETag.</p>
    ///   - [`copy_source_if_unmodified_since(DateTime)`](crate::client::fluent_builders::UploadPartCopy::copy_source_if_unmodified_since) / [`set_copy_source_if_unmodified_since(Option<DateTime>)`](crate::client::fluent_builders::UploadPartCopy::set_copy_source_if_unmodified_since): <p>Copies the object if it hasn't been modified since the specified time.</p>
    ///   - [`copy_source_range(impl Into<String>)`](crate::client::fluent_builders::UploadPartCopy::copy_source_range) / [`set_copy_source_range(Option<String>)`](crate::client::fluent_builders::UploadPartCopy::set_copy_source_range): <p>The range of bytes to copy from the source object. The range value must use the form bytes=first-last, where the first and last are the zero-based byte offsets to copy. For example, bytes=0-9 indicates that you want to copy the first 10 bytes of the source. You can copy a range only if the source object is greater than 5 MB.</p>
    ///   - [`key(impl Into<String>)`](crate::client::fluent_builders::UploadPartCopy::key) / [`set_key(Option<String>)`](crate::client::fluent_builders::UploadPartCopy::set_key): <p>Object key for which the multipart upload was initiated.</p>
    ///   - [`part_number(i32)`](crate::client::fluent_builders::UploadPartCopy::part_number) / [`set_part_number(i32)`](crate::client::fluent_builders::UploadPartCopy::set_part_number): <p>Part number of part being copied. This is a positive integer between 1 and 10,000.</p>
    ///   - [`upload_id(impl Into<String>)`](crate::client::fluent_builders::UploadPartCopy::upload_id) / [`set_upload_id(Option<String>)`](crate::client::fluent_builders::UploadPartCopy::set_upload_id): <p>Upload ID identifying the multipart upload whose part is being copied.</p>
    ///   - [`sse_customer_algorithm(impl Into<String>)`](crate::client::fluent_builders::UploadPartCopy::sse_customer_algorithm) / [`set_sse_customer_algorithm(Option<String>)`](crate::client::fluent_builders::UploadPartCopy::set_sse_customer_algorithm): <p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>
    ///   - [`sse_customer_key(impl Into<String>)`](crate::client::fluent_builders::UploadPartCopy::sse_customer_key) / [`set_sse_customer_key(Option<String>)`](crate::client::fluent_builders::UploadPartCopy::set_sse_customer_key): <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header. This must be the same encryption key specified in the initiate multipart upload request.</p>
    ///   - [`sse_customer_key_md5(impl Into<String>)`](crate::client::fluent_builders::UploadPartCopy::sse_customer_key_md5) / [`set_sse_customer_key_md5(Option<String>)`](crate::client::fluent_builders::UploadPartCopy::set_sse_customer_key_md5): <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
    ///   - [`copy_source_sse_customer_algorithm(impl Into<String>)`](crate::client::fluent_builders::UploadPartCopy::copy_source_sse_customer_algorithm) / [`set_copy_source_sse_customer_algorithm(Option<String>)`](crate::client::fluent_builders::UploadPartCopy::set_copy_source_sse_customer_algorithm): <p>Specifies the algorithm to use when decrypting the source object (for example, AES256).</p>
    ///   - [`copy_source_sse_customer_key(impl Into<String>)`](crate::client::fluent_builders::UploadPartCopy::copy_source_sse_customer_key) / [`set_copy_source_sse_customer_key(Option<String>)`](crate::client::fluent_builders::UploadPartCopy::set_copy_source_sse_customer_key): <p>Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The encryption key provided in this header must be one that was used when the source object was created.</p>
    ///   - [`copy_source_sse_customer_key_md5(impl Into<String>)`](crate::client::fluent_builders::UploadPartCopy::copy_source_sse_customer_key_md5) / [`set_copy_source_sse_customer_key_md5(Option<String>)`](crate::client::fluent_builders::UploadPartCopy::set_copy_source_sse_customer_key_md5): <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
    ///   - [`request_payer(RequestPayer)`](crate::client::fluent_builders::UploadPartCopy::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::client::fluent_builders::UploadPartCopy::set_request_payer): <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::UploadPartCopy::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::client::fluent_builders::UploadPartCopy::set_expected_bucket_owner): <p>The account ID of the expected destination bucket owner. If the destination bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    ///   - [`expected_source_bucket_owner(impl Into<String>)`](crate::client::fluent_builders::UploadPartCopy::expected_source_bucket_owner) / [`set_expected_source_bucket_owner(Option<String>)`](crate::client::fluent_builders::UploadPartCopy::set_expected_source_bucket_owner): <p>The account ID of the expected source bucket owner. If the source bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
    /// - On success, responds with [`UploadPartCopyOutput`](crate::output::UploadPartCopyOutput) with field(s):
    ///   - [`copy_source_version_id(Option<String>)`](crate::output::UploadPartCopyOutput::copy_source_version_id): <p>The version of the source object that was copied, if you have enabled versioning on the source bucket.</p>
    ///   - [`copy_part_result(Option<CopyPartResult>)`](crate::output::UploadPartCopyOutput::copy_part_result): <p>Container for all response elements.</p>
    ///   - [`server_side_encryption(Option<ServerSideEncryption>)`](crate::output::UploadPartCopyOutput::server_side_encryption): <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>
    ///   - [`sse_customer_algorithm(Option<String>)`](crate::output::UploadPartCopyOutput::sse_customer_algorithm): <p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header confirming the encryption algorithm used.</p>
    ///   - [`sse_customer_key_md5(Option<String>)`](crate::output::UploadPartCopyOutput::sse_customer_key_md5): <p>If server-side encryption with a customer-provided encryption key was requested, the response will include this header to provide round-trip message integrity verification of the customer-provided encryption key.</p>
    ///   - [`ssekms_key_id(Option<String>)`](crate::output::UploadPartCopyOutput::ssekms_key_id): <p>If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric customer managed key that was used for the object.</p>
    ///   - [`bucket_key_enabled(bool)`](crate::output::UploadPartCopyOutput::bucket_key_enabled): <p>Indicates whether the multipart upload uses an S3 Bucket Key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    ///   - [`request_charged(Option<RequestCharged>)`](crate::output::UploadPartCopyOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p>
    /// - On failure, responds with [`SdkError<UploadPartCopyError>`](crate::error::UploadPartCopyError)
    pub fn upload_part_copy(&self) -> fluent_builders::UploadPartCopy {
        fluent_builders::UploadPartCopy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`WriteGetObjectResponse`](crate::client::fluent_builders::WriteGetObjectResponse) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`request_route(impl Into<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::request_route) / [`set_request_route(Option<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::set_request_route): <p>Route prefix to the HTTP URL generated.</p>
    ///   - [`request_token(impl Into<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::request_token) / [`set_request_token(Option<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::set_request_token): <p>A single use encrypted token that maps <code>WriteGetObjectResponse</code> to the end user <code>GetObject</code> request.</p>
    ///   - [`body(byte_stream::ByteStream)`](crate::client::fluent_builders::WriteGetObjectResponse::body) / [`set_body(byte_stream::ByteStream)`](crate::client::fluent_builders::WriteGetObjectResponse::set_body): <p>The object data.</p>
    ///   - [`status_code(i32)`](crate::client::fluent_builders::WriteGetObjectResponse::status_code) / [`set_status_code(i32)`](crate::client::fluent_builders::WriteGetObjectResponse::set_status_code): <p>The integer status code for an HTTP response of a corresponding <code>GetObject</code> request.</p>  <p class="title"> <b>Status Codes</b> </p>  <ul>   <li> <p> <i>200 - OK</i> </p> </li>   <li> <p> <i>206 - Partial Content</i> </p> </li>   <li> <p> <i>304 - Not Modified</i> </p> </li>   <li> <p> <i>400 - Bad Request</i> </p> </li>   <li> <p> <i>401 - Unauthorized</i> </p> </li>   <li> <p> <i>403 - Forbidden</i> </p> </li>   <li> <p> <i>404 - Not Found</i> </p> </li>   <li> <p> <i>405 - Method Not Allowed</i> </p> </li>   <li> <p> <i>409 - Conflict</i> </p> </li>   <li> <p> <i>411 - Length Required</i> </p> </li>   <li> <p> <i>412 - Precondition Failed</i> </p> </li>   <li> <p> <i>416 - Range Not Satisfiable</i> </p> </li>   <li> <p> <i>500 - Internal Server Error</i> </p> </li>   <li> <p> <i>503 - Service Unavailable</i> </p> </li>  </ul>
    ///   - [`error_code(impl Into<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::error_code) / [`set_error_code(Option<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::set_error_code): <p>A string that uniquely identifies an error condition. Returned in the <code> tag of the error XML response for a corresponding <code>GetObject</code> call. Cannot be used with a successful <code>StatusCode</code> header or when the transformed object is provided in the body. All error codes from S3 are sentence-cased. Regex value is "^[A-Z][a-zA-Z]+$".</code></p>
    ///   - [`error_message(impl Into<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::error_message) / [`set_error_message(Option<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::set_error_message): <p>Contains a generic description of the error condition. Returned in the <message>    tag of the error XML response for a corresponding    <code>GetObject</code> call. Cannot be used with a successful    <code>StatusCode</code> header or when the transformed object is provided in body.  </message></p>
    ///   - [`accept_ranges(impl Into<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::accept_ranges) / [`set_accept_ranges(Option<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::set_accept_ranges): <p>Indicates that a range of bytes was specified.</p>
    ///   - [`cache_control(impl Into<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::cache_control) / [`set_cache_control(Option<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::set_cache_control): <p>Specifies caching behavior along the request/reply chain.</p>
    ///   - [`content_disposition(impl Into<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::content_disposition) / [`set_content_disposition(Option<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::set_content_disposition): <p>Specifies presentational information for the object.</p>
    ///   - [`content_encoding(impl Into<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::content_encoding) / [`set_content_encoding(Option<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::set_content_encoding): <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>
    ///   - [`content_language(impl Into<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::content_language) / [`set_content_language(Option<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::set_content_language): <p>The language the content is in.</p>
    ///   - [`content_length(i64)`](crate::client::fluent_builders::WriteGetObjectResponse::content_length) / [`set_content_length(i64)`](crate::client::fluent_builders::WriteGetObjectResponse::set_content_length): <p>The size of the content body in bytes.</p>
    ///   - [`content_range(impl Into<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::content_range) / [`set_content_range(Option<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::set_content_range): <p>The portion of the object returned in the response.</p>
    ///   - [`content_type(impl Into<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::content_type) / [`set_content_type(Option<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::set_content_type): <p>A standard MIME type describing the format of the object data.</p>
    ///   - [`delete_marker(bool)`](crate::client::fluent_builders::WriteGetObjectResponse::delete_marker) / [`set_delete_marker(bool)`](crate::client::fluent_builders::WriteGetObjectResponse::set_delete_marker): <p>Specifies whether an object stored in Amazon S3 is (<code>true</code>) or is not (<code>false</code>) a delete marker. </p>
    ///   - [`e_tag(impl Into<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::e_tag) / [`set_e_tag(Option<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::set_e_tag): <p>An opaque identifier assigned by a web server to a specific version of a resource found at a URL. </p>
    ///   - [`expires(DateTime)`](crate::client::fluent_builders::WriteGetObjectResponse::expires) / [`set_expires(Option<DateTime>)`](crate::client::fluent_builders::WriteGetObjectResponse::set_expires): <p>The date and time at which the object is no longer cacheable.</p>
    ///   - [`expiration(impl Into<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::expiration) / [`set_expiration(Option<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::set_expiration): <p>If object stored in Amazon S3 expiration is configured (see PUT Bucket lifecycle) it includes expiry-date and rule-id key-value pairs providing object expiration information. The value of the rule-id is URL encoded. </p>
    ///   - [`last_modified(DateTime)`](crate::client::fluent_builders::WriteGetObjectResponse::last_modified) / [`set_last_modified(Option<DateTime>)`](crate::client::fluent_builders::WriteGetObjectResponse::set_last_modified): <p>The date and time that the object was last modified.</p>
    ///   - [`missing_meta(i32)`](crate::client::fluent_builders::WriteGetObjectResponse::missing_meta) / [`set_missing_meta(i32)`](crate::client::fluent_builders::WriteGetObjectResponse::set_missing_meta): <p>Set to the number of metadata entries not returned in <code>x-amz-meta</code> headers. This can happen if you create metadata using an API like SOAP that supports more flexible metadata than the REST API. For example, using SOAP, you can create metadata whose values are not legal HTTP headers.</p>
    ///   - [`metadata(HashMap<String, String>)`](crate::client::fluent_builders::WriteGetObjectResponse::metadata) / [`set_metadata(Option<HashMap<String, String>>)`](crate::client::fluent_builders::WriteGetObjectResponse::set_metadata): <p>A map of metadata to store with the object in S3.</p>
    ///   - [`object_lock_mode(ObjectLockMode)`](crate::client::fluent_builders::WriteGetObjectResponse::object_lock_mode) / [`set_object_lock_mode(Option<ObjectLockMode>)`](crate::client::fluent_builders::WriteGetObjectResponse::set_object_lock_mode): <p>Indicates whether an object stored in Amazon S3 has Object Lock enabled. For more information about S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock.html">Object Lock</a>.</p>
    ///   - [`object_lock_legal_hold_status(ObjectLockLegalHoldStatus)`](crate::client::fluent_builders::WriteGetObjectResponse::object_lock_legal_hold_status) / [`set_object_lock_legal_hold_status(Option<ObjectLockLegalHoldStatus>)`](crate::client::fluent_builders::WriteGetObjectResponse::set_object_lock_legal_hold_status): <p>Indicates whether an object stored in Amazon S3 has an active legal hold.</p>
    ///   - [`object_lock_retain_until_date(DateTime)`](crate::client::fluent_builders::WriteGetObjectResponse::object_lock_retain_until_date) / [`set_object_lock_retain_until_date(Option<DateTime>)`](crate::client::fluent_builders::WriteGetObjectResponse::set_object_lock_retain_until_date): <p>The date and time when Object Lock is configured to expire.</p>
    ///   - [`parts_count(i32)`](crate::client::fluent_builders::WriteGetObjectResponse::parts_count) / [`set_parts_count(i32)`](crate::client::fluent_builders::WriteGetObjectResponse::set_parts_count): <p>The count of parts this object has.</p>
    ///   - [`replication_status(ReplicationStatus)`](crate::client::fluent_builders::WriteGetObjectResponse::replication_status) / [`set_replication_status(Option<ReplicationStatus>)`](crate::client::fluent_builders::WriteGetObjectResponse::set_replication_status): <p>Indicates if request involves bucket that is either a source or destination in a Replication rule. For more information about S3 Replication, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/replication.html">Replication</a>.</p>
    ///   - [`request_charged(RequestCharged)`](crate::client::fluent_builders::WriteGetObjectResponse::request_charged) / [`set_request_charged(Option<RequestCharged>)`](crate::client::fluent_builders::WriteGetObjectResponse::set_request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p>
    ///   - [`restore(impl Into<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::restore) / [`set_restore(Option<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::set_restore): <p>Provides information about object restoration operation and expiration time of the restored object copy.</p>
    ///   - [`server_side_encryption(ServerSideEncryption)`](crate::client::fluent_builders::WriteGetObjectResponse::server_side_encryption) / [`set_server_side_encryption(Option<ServerSideEncryption>)`](crate::client::fluent_builders::WriteGetObjectResponse::set_server_side_encryption): <p> The server-side encryption algorithm used when storing requested object in Amazon S3 (for example, AES256, aws:kms).</p>
    ///   - [`sse_customer_algorithm(impl Into<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::sse_customer_algorithm) / [`set_sse_customer_algorithm(Option<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::set_sse_customer_algorithm): <p>Encryption algorithm used if server-side encryption with a customer-provided encryption key was specified for object stored in Amazon S3.</p>
    ///   - [`ssekms_key_id(impl Into<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::ssekms_key_id) / [`set_ssekms_key_id(Option<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::set_ssekms_key_id): <p> If present, specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric customer managed key that was used for stored in Amazon S3 object. </p>
    ///   - [`sse_customer_key_md5(impl Into<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::sse_customer_key_md5) / [`set_sse_customer_key_md5(Option<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::set_sse_customer_key_md5): <p> 128-bit MD5 digest of customer-provided encryption key used in Amazon S3 to encrypt data stored in S3. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html">Protecting data using server-side encryption with customer-provided encryption keys (SSE-C)</a>.</p>
    ///   - [`storage_class(StorageClass)`](crate::client::fluent_builders::WriteGetObjectResponse::storage_class) / [`set_storage_class(Option<StorageClass>)`](crate::client::fluent_builders::WriteGetObjectResponse::set_storage_class): <p> The class of storage used to store object in Amazon S3.</p>
    ///   - [`tag_count(i32)`](crate::client::fluent_builders::WriteGetObjectResponse::tag_count) / [`set_tag_count(i32)`](crate::client::fluent_builders::WriteGetObjectResponse::set_tag_count): <p>The number of tags, if any, on the object.</p>
    ///   - [`version_id(impl Into<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::version_id) / [`set_version_id(Option<String>)`](crate::client::fluent_builders::WriteGetObjectResponse::set_version_id): <p>An ID used to reference a specific version of the object.</p>
    ///   - [`bucket_key_enabled(bool)`](crate::client::fluent_builders::WriteGetObjectResponse::bucket_key_enabled) / [`set_bucket_key_enabled(bool)`](crate::client::fluent_builders::WriteGetObjectResponse::set_bucket_key_enabled): <p> Indicates whether the object stored in Amazon S3 uses an S3 bucket key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    /// - On success, responds with [`WriteGetObjectResponseOutput`](crate::output::WriteGetObjectResponseOutput)

    /// - On failure, responds with [`SdkError<WriteGetObjectResponseError>`](crate::error::WriteGetObjectResponseError)
    pub fn write_get_object_response(&self) -> fluent_builders::WriteGetObjectResponse {
        fluent_builders::WriteGetObjectResponse::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AbortMultipartUpload`.
    ///
    /// <p>This action aborts a multipart upload. After a multipart upload is aborted, no additional parts can be uploaded using that upload ID. The storage consumed by any previously uploaded parts will be freed. However, if any part uploads are currently in progress, those part uploads might or might not succeed. As a result, it might be necessary to abort a given multipart upload multiple times in order to completely free all storage consumed by all parts. </p>
    /// <p>To verify that all parts have been removed, so you don't get charged for the part storage, you should call the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html">ListParts</a> action and ensure that the parts list is empty.</p>
    /// <p>For information about permissions required to use the multipart upload, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html">Multipart Upload and Permissions</a>.</p>
    /// <p>The following operations are related to <code>AbortMultipartUpload</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html">CreateMultipartUpload</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html">CompleteMultipartUpload</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html">ListParts</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html">ListMultipartUploads</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AbortMultipartUpload {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::abort_multipart_upload_input::Builder,
    }
    impl AbortMultipartUpload {
        /// Creates a new `AbortMultipartUpload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AbortMultipartUploadOutput,
            aws_smithy_http::result::SdkError<crate::error::AbortMultipartUploadError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The bucket name to which the upload was taking place. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The bucket name to which the upload was taking place. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>Key of the object for which the multipart upload was initiated.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key(input.into());
            self
        }
        /// <p>Key of the object for which the multipart upload was initiated.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key(input);
            self
        }
        /// <p>Upload ID that identifies the multipart upload.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.upload_id(input.into());
            self
        }
        /// <p>Upload ID that identifies the multipart upload.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_upload_id(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.inner = self.inner.request_payer(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.inner = self.inner.set_request_payer(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CompleteMultipartUpload`.
    ///
    /// <p>Completes a multipart upload by assembling previously uploaded parts.</p>
    /// <p>You first initiate the multipart upload and then upload all parts using the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a> operation. After successfully uploading all relevant parts of an upload, you call this action to complete the upload. Upon receiving this request, Amazon S3 concatenates all the parts in ascending order by part number to create a new object. In the Complete Multipart Upload request, you must provide the parts list. You must ensure that the parts list is complete. This action concatenates the parts that you provide in the list. For each part in the list, you must provide the part number and the <code>ETag</code> value, returned after that part was uploaded.</p>
    /// <p>Processing of a Complete Multipart Upload request could take several minutes to complete. After Amazon S3 begins processing the request, it sends an HTTP response header that specifies a 200 OK response. While processing is in progress, Amazon S3 periodically sends white space characters to keep the connection from timing out. Because a request could fail after the initial 200 OK response has been sent, it is important that you check the response body to determine whether the request succeeded.</p>
    /// <p>Note that if <code>CompleteMultipartUpload</code> fails, applications should be prepared to retry the failed requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ErrorBestPractices.html">Amazon S3 Error Best Practices</a>.</p> <important>
    /// <p>You cannot use <code>Content-Type: application/x-www-form-urlencoded</code> with Complete Multipart Upload requests. Also, if you do not provide a <code>Content-Type</code> header, <code>CompleteMultipartUpload</code> returns a 200 OK response.</p>
    /// </important>
    /// <p>For more information about multipart uploads, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/uploadobjusingmpu.html">Uploading Objects Using Multipart Upload</a>.</p>
    /// <p>For information about permissions required to use the multipart upload API, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html">Multipart Upload and Permissions</a>.</p>
    /// <p> <code>CompleteMultipartUpload</code> has the following special errors:</p>
    /// <ul>
    /// <li> <p>Error code: <code>EntityTooSmall</code> </p>
    /// <ul>
    /// <li> <p>Description: Your proposed upload is smaller than the minimum allowed object size. Each part must be at least 5 MB in size, except the last part.</p> </li>
    /// <li> <p>400 Bad Request</p> </li>
    /// </ul> </li>
    /// <li> <p>Error code: <code>InvalidPart</code> </p>
    /// <ul>
    /// <li> <p>Description: One or more of the specified parts could not be found. The part might not have been uploaded, or the specified entity tag might not have matched the part's entity tag.</p> </li>
    /// <li> <p>400 Bad Request</p> </li>
    /// </ul> </li>
    /// <li> <p>Error code: <code>InvalidPartOrder</code> </p>
    /// <ul>
    /// <li> <p>Description: The list of parts was not in ascending order. The parts list must be specified in order by part number.</p> </li>
    /// <li> <p>400 Bad Request</p> </li>
    /// </ul> </li>
    /// <li> <p>Error code: <code>NoSuchUpload</code> </p>
    /// <ul>
    /// <li> <p>Description: The specified multipart upload does not exist. The upload ID might be invalid, or the multipart upload might have been aborted or completed.</p> </li>
    /// <li> <p>404 Not Found</p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p>The following operations are related to <code>CompleteMultipartUpload</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html">CreateMultipartUpload</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html">AbortMultipartUpload</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html">ListParts</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html">ListMultipartUploads</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CompleteMultipartUpload {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::complete_multipart_upload_input::Builder,
    }
    impl CompleteMultipartUpload {
        /// Creates a new `CompleteMultipartUpload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CompleteMultipartUploadOutput,
            aws_smithy_http::result::SdkError<crate::error::CompleteMultipartUploadError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the bucket to which the multipart upload was initiated.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>Name of the bucket to which the multipart upload was initiated.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>Object key for which the multipart upload was initiated.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key(input.into());
            self
        }
        /// <p>Object key for which the multipart upload was initiated.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key(input);
            self
        }
        /// <p>The container for the multipart upload request information.</p>
        pub fn multipart_upload(mut self, input: crate::model::CompletedMultipartUpload) -> Self {
            self.inner = self.inner.multipart_upload(input);
            self
        }
        /// <p>The container for the multipart upload request information.</p>
        pub fn set_multipart_upload(
            mut self,
            input: std::option::Option<crate::model::CompletedMultipartUpload>,
        ) -> Self {
            self.inner = self.inner.set_multipart_upload(input);
            self
        }
        /// <p>ID for the initiated multipart upload.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.upload_id(input.into());
            self
        }
        /// <p>ID for the initiated multipart upload.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_upload_id(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.inner = self.inner.request_payer(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.inner = self.inner.set_request_payer(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyObject`.
    ///
    /// <p>Creates a copy of an object that is already stored in Amazon S3.</p> <note>
    /// <p>You can store individual objects of up to 5 TB in Amazon S3. You create a copy of your object up to 5 GB in size in a single atomic action using this API. However, to copy an object greater than 5 GB, you must use the multipart upload Upload Part - Copy API. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/CopyingObjctsUsingRESTMPUapi.html">Copy Object Using the REST Multipart Upload API</a>.</p>
    /// </note>
    /// <p>All copy requests must be authenticated. Additionally, you must have <i>read</i> access to the source object and <i>write</i> access to the destination bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">REST Authentication</a>. Both the Region that you want to copy the object from and the Region that you want to copy the object to must be enabled for your account.</p>
    /// <p>A copy request might return an error when Amazon S3 receives the copy request or while Amazon S3 is copying the files. If the error occurs before the copy action starts, you receive a standard Amazon S3 error. If the error occurs during the copy operation, the error response is embedded in the <code>200 OK</code> response. This means that a <code>200 OK</code> response can contain either a success or an error. Design your application to parse the contents of the response and handle it appropriately.</p>
    /// <p>If the copy is successful, you receive a response with information about the copied object.</p> <note>
    /// <p>If the request is an HTTP 1.1 request, the response is chunk encoded. If it were not, it would not contain the content-length, and you would need to read the entire body.</p>
    /// </note>
    /// <p>The copy request charge is based on the storage class and Region that you specify for the destination object. For pricing information, see <a href="http://aws.amazon.com/s3/pricing/">Amazon S3 pricing</a>.</p> <important>
    /// <p>Amazon S3 transfer acceleration does not support cross-Region copies. If you request a cross-Region copy using a transfer acceleration endpoint, you get a 400 <code>Bad Request</code> error. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html">Transfer Acceleration</a>.</p>
    /// </important>
    /// <p> <b>Metadata</b> </p>
    /// <p>When copying an object, you can preserve all metadata (default) or specify new metadata. However, the ACL is not preserved and is set to private for the user making the request. To override the default ACL setting, specify a new ACL when generating a copy request. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html">Using ACLs</a>. </p>
    /// <p>To specify whether you want the object metadata copied from the source object or replaced with metadata provided in the request, you can optionally add the <code>x-amz-metadata-directive</code> header. When you grant permissions, you can use the <code>s3:x-amz-metadata-directive</code> condition key to enforce certain metadata behavior when objects are uploaded. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/amazon-s3-policy-keys.html">Specifying Conditions in a Policy</a> in the <i>Amazon S3 User Guide</i>. For a complete list of Amazon S3-specific condition keys, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/list_amazons3.html">Actions, Resources, and Condition Keys for Amazon S3</a>.</p>
    /// <p> <b> <code>x-amz-copy-source-if</code> Headers</b> </p>
    /// <p>To only copy an object under certain conditions, such as whether the <code>Etag</code> matches or whether the object was modified before or after a specified date, use the following request parameters:</p>
    /// <ul>
    /// <li> <p> <code>x-amz-copy-source-if-match</code> </p> </li>
    /// <li> <p> <code>x-amz-copy-source-if-none-match</code> </p> </li>
    /// <li> <p> <code>x-amz-copy-source-if-unmodified-since</code> </p> </li>
    /// <li> <p> <code>x-amz-copy-source-if-modified-since</code> </p> </li>
    /// </ul>
    /// <p> If both the <code>x-amz-copy-source-if-match</code> and <code>x-amz-copy-source-if-unmodified-since</code> headers are present in the request and evaluate as follows, Amazon S3 returns <code>200 OK</code> and copies the data:</p>
    /// <ul>
    /// <li> <p> <code>x-amz-copy-source-if-match</code> condition evaluates to true</p> </li>
    /// <li> <p> <code>x-amz-copy-source-if-unmodified-since</code> condition evaluates to false</p> </li>
    /// </ul>
    /// <p>If both the <code>x-amz-copy-source-if-none-match</code> and <code>x-amz-copy-source-if-modified-since</code> headers are present in the request and evaluate as follows, Amazon S3 returns the <code>412 Precondition Failed</code> response code:</p>
    /// <ul>
    /// <li> <p> <code>x-amz-copy-source-if-none-match</code> condition evaluates to false</p> </li>
    /// <li> <p> <code>x-amz-copy-source-if-modified-since</code> condition evaluates to true</p> </li>
    /// </ul> <note>
    /// <p>All headers with the <code>x-amz-</code> prefix, including <code>x-amz-copy-source</code>, must be signed.</p>
    /// </note>
    /// <p> <b>Server-side encryption</b> </p>
    /// <p>When you perform a CopyObject operation, you can optionally use the appropriate encryption-related headers to encrypt the object using server-side encryption with Amazon Web Services managed encryption keys (SSE-S3 or SSE-KMS) or a customer-provided encryption key. With server-side encryption, Amazon S3 encrypts your data as it writes it to disks in its data centers and decrypts the data when you access it. For more information about server-side encryption, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html">Using Server-Side Encryption</a>.</p>
    /// <p>If a target object uses SSE-KMS, you can enable an S3 Bucket Key for the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html">Amazon S3 Bucket Keys</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p> <b>Access Control List (ACL)-Specific Request Headers</b> </p>
    /// <p>When copying an object, you can optionally use headers to grant ACL-based permissions. By default, all objects are private. Only the owner has full access control. When adding a new object, you can grant permissions to individual Amazon Web Services accounts or to predefined groups defined by Amazon S3. These permissions are then added to the ACL on the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-using-rest-api.html">Managing ACLs Using the REST API</a>. </p>
    /// <p>If the bucket that you're copying objects to uses the bucket owner enforced setting for S3 Object Ownership, ACLs are disabled and no longer affect permissions. Buckets that use this setting only accept PUT requests that don't specify an ACL or PUT requests that specify bucket owner full control ACLs, such as the <code>bucket-owner-full-control</code> canned ACL or an equivalent form of this ACL expressed in the XML format.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html"> Controlling ownership of objects and disabling ACLs</a> in the <i>Amazon S3 User Guide</i>.</p> <note>
    /// <p>If your bucket uses the bucket owner enforced setting for Object Ownership, all objects written to the bucket by any account will be owned by the bucket owner.</p>
    /// </note>
    /// <p> <b>Storage Class Options</b> </p>
    /// <p>You can use the <code>CopyObject</code> action to change the storage class of an object that is already stored in Amazon S3 using the <code>StorageClass</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p> <b>Versioning</b> </p>
    /// <p>By default, <code>x-amz-copy-source</code> identifies the current version of an object to copy. If the current version is a delete marker, Amazon S3 behaves as if the object was deleted. To copy a different version, use the <code>versionId</code> subresource.</p>
    /// <p>If you enable versioning on the target bucket, Amazon S3 generates a unique version ID for the object being copied. This version ID is different from the version ID of the source object. Amazon S3 returns the version ID of the copied object in the <code>x-amz-version-id</code> response header in the response.</p>
    /// <p>If you do not enable versioning or suspend it on the target bucket, the version ID that Amazon S3 generates is always null.</p>
    /// <p>If the source object's storage class is GLACIER, you must restore a copy of this object before you can use it as a source object for the copy operation. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html">RestoreObject</a>.</p>
    /// <p>The following operations are related to <code>CopyObject</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a> </p> </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/CopyingObjectsExamples.html">Copying Objects</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CopyObject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::copy_object_input::Builder,
    }
    impl CopyObject {
        /// Creates a new `CopyObject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyObjectOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyObjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The canned ACL to apply to the object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn acl(mut self, input: crate::model::ObjectCannedAcl) -> Self {
            self.inner = self.inner.acl(input);
            self
        }
        /// <p>The canned ACL to apply to the object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_acl(
            mut self,
            input: std::option::Option<crate::model::ObjectCannedAcl>,
        ) -> Self {
            self.inner = self.inner.set_acl(input);
            self
        }
        /// <p>The name of the destination bucket.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the destination bucket.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>Specifies caching behavior along the request/reply chain.</p>
        pub fn cache_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_control(input.into());
            self
        }
        /// <p>Specifies caching behavior along the request/reply chain.</p>
        pub fn set_cache_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_control(input);
            self
        }
        /// <p>Specifies presentational information for the object.</p>
        pub fn content_disposition(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_disposition(input.into());
            self
        }
        /// <p>Specifies presentational information for the object.</p>
        pub fn set_content_disposition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_content_disposition(input);
            self
        }
        /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>
        pub fn content_encoding(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_encoding(input.into());
            self
        }
        /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>
        pub fn set_content_encoding(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_content_encoding(input);
            self
        }
        /// <p>The language the content is in.</p>
        pub fn content_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_language(input.into());
            self
        }
        /// <p>The language the content is in.</p>
        pub fn set_content_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_content_language(input);
            self
        }
        /// <p>A standard MIME type describing the format of the object data.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_type(input.into());
            self
        }
        /// <p>A standard MIME type describing the format of the object data.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_type(input);
            self
        }
        /// <p>Specifies the source object for the copy operation. You specify the value in one of two formats, depending on whether you want to access the source object through an <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">access point</a>:</p>
        /// <ul>
        /// <li> <p>For objects not accessed through an access point, specify the name of the source bucket and the key of the source object, separated by a slash (/). For example, to copy the object <code>reports/january.pdf</code> from the bucket <code>awsexamplebucket</code>, use <code>awsexamplebucket/reports/january.pdf</code>. The value must be URL encoded.</p> </li>
        /// <li> <p>For objects accessed through access points, specify the Amazon Resource Name (ARN) of the object as accessed through the access point, in the format <code>arn:aws:s3:
        /// <region>
        /// :
        /// <account-id>
        /// :accesspoint/
        /// <access-point-name>
        /// /object/
        /// <key></key>
        /// </access-point-name>
        /// </account-id>
        /// </region></code>. For example, to copy the object <code>reports/january.pdf</code> through access point <code>my-access-point</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3:us-west-2:123456789012:accesspoint/my-access-point/object/reports/january.pdf</code>. The value must be URL encoded.</p> <note>
        /// <p>Amazon S3 supports copy operations using access points only when the source and destination buckets are in the same Amazon Web Services Region.</p>
        /// </note> <p>Alternatively, for objects accessed through Amazon S3 on Outposts, specify the ARN of the object as accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /object/
        /// <key></key>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to copy the object <code>reports/january.pdf</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/object/reports/january.pdf</code>. The value must be URL encoded. </p> </li>
        /// </ul>
        /// <p>To copy a specific version of an object, append <code>?versionId=
        /// <version-id></version-id></code> to the value (for example, <code>awsexamplebucket/reports/january.pdf?versionId=QUpfdndhfd8438MNFDN93jdnJFkdmqnh893</code>). If you don't specify a version ID, Amazon S3 copies the latest version of the source object.</p>
        pub fn copy_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.copy_source(input.into());
            self
        }
        /// <p>Specifies the source object for the copy operation. You specify the value in one of two formats, depending on whether you want to access the source object through an <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">access point</a>:</p>
        /// <ul>
        /// <li> <p>For objects not accessed through an access point, specify the name of the source bucket and the key of the source object, separated by a slash (/). For example, to copy the object <code>reports/january.pdf</code> from the bucket <code>awsexamplebucket</code>, use <code>awsexamplebucket/reports/january.pdf</code>. The value must be URL encoded.</p> </li>
        /// <li> <p>For objects accessed through access points, specify the Amazon Resource Name (ARN) of the object as accessed through the access point, in the format <code>arn:aws:s3:
        /// <region>
        /// :
        /// <account-id>
        /// :accesspoint/
        /// <access-point-name>
        /// /object/
        /// <key></key>
        /// </access-point-name>
        /// </account-id>
        /// </region></code>. For example, to copy the object <code>reports/january.pdf</code> through access point <code>my-access-point</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3:us-west-2:123456789012:accesspoint/my-access-point/object/reports/january.pdf</code>. The value must be URL encoded.</p> <note>
        /// <p>Amazon S3 supports copy operations using access points only when the source and destination buckets are in the same Amazon Web Services Region.</p>
        /// </note> <p>Alternatively, for objects accessed through Amazon S3 on Outposts, specify the ARN of the object as accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /object/
        /// <key></key>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to copy the object <code>reports/january.pdf</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/object/reports/january.pdf</code>. The value must be URL encoded. </p> </li>
        /// </ul>
        /// <p>To copy a specific version of an object, append <code>?versionId=
        /// <version-id></version-id></code> to the value (for example, <code>awsexamplebucket/reports/january.pdf?versionId=QUpfdndhfd8438MNFDN93jdnJFkdmqnh893</code>). If you don't specify a version ID, Amazon S3 copies the latest version of the source object.</p>
        pub fn set_copy_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_copy_source(input);
            self
        }
        /// <p>Copies the object if its entity tag (ETag) matches the specified tag.</p>
        pub fn copy_source_if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.copy_source_if_match(input.into());
            self
        }
        /// <p>Copies the object if its entity tag (ETag) matches the specified tag.</p>
        pub fn set_copy_source_if_match(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_copy_source_if_match(input);
            self
        }
        /// <p>Copies the object if it has been modified since the specified time.</p>
        pub fn copy_source_if_modified_since(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.copy_source_if_modified_since(input);
            self
        }
        /// <p>Copies the object if it has been modified since the specified time.</p>
        pub fn set_copy_source_if_modified_since(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_copy_source_if_modified_since(input);
            self
        }
        /// <p>Copies the object if its entity tag (ETag) is different than the specified ETag.</p>
        pub fn copy_source_if_none_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.copy_source_if_none_match(input.into());
            self
        }
        /// <p>Copies the object if its entity tag (ETag) is different than the specified ETag.</p>
        pub fn set_copy_source_if_none_match(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_copy_source_if_none_match(input);
            self
        }
        /// <p>Copies the object if it hasn't been modified since the specified time.</p>
        pub fn copy_source_if_unmodified_since(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.inner = self.inner.copy_source_if_unmodified_since(input);
            self
        }
        /// <p>Copies the object if it hasn't been modified since the specified time.</p>
        pub fn set_copy_source_if_unmodified_since(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_copy_source_if_unmodified_since(input);
            self
        }
        /// <p>The date and time at which the object is no longer cacheable.</p>
        pub fn expires(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.expires(input);
            self
        }
        /// <p>The date and time at which the object is no longer cacheable.</p>
        pub fn set_expires(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_expires(input);
            self
        }
        /// <p>Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_full_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_full_control(input.into());
            self
        }
        /// <p>Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_full_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_grant_full_control(input);
            self
        }
        /// <p>Allows grantee to read the object data and its metadata.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_read(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_read(input.into());
            self
        }
        /// <p>Allows grantee to read the object data and its metadata.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_read(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grant_read(input);
            self
        }
        /// <p>Allows grantee to read the object ACL.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_read_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_read_acp(input.into());
            self
        }
        /// <p>Allows grantee to read the object ACL.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_read_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_grant_read_acp(input);
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_write_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_write_acp(input.into());
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_write_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_grant_write_acp(input);
            self
        }
        /// <p>The key of the destination object.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key(input.into());
            self
        }
        /// <p>The key of the destination object.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key(input);
            self
        }
        /// Adds a key-value pair to `Metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>A map of metadata to store with the object in S3.</p>
        pub fn metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.metadata(k.into(), v.into());
            self
        }
        /// <p>A map of metadata to store with the object in S3.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// <p>Specifies whether the metadata is copied from the source object or replaced with metadata provided in the request.</p>
        pub fn metadata_directive(mut self, input: crate::model::MetadataDirective) -> Self {
            self.inner = self.inner.metadata_directive(input);
            self
        }
        /// <p>Specifies whether the metadata is copied from the source object or replaced with metadata provided in the request.</p>
        pub fn set_metadata_directive(
            mut self,
            input: std::option::Option<crate::model::MetadataDirective>,
        ) -> Self {
            self.inner = self.inner.set_metadata_directive(input);
            self
        }
        /// <p>Specifies whether the object tag-set are copied from the source object or replaced with tag-set provided in the request.</p>
        pub fn tagging_directive(mut self, input: crate::model::TaggingDirective) -> Self {
            self.inner = self.inner.tagging_directive(input);
            self
        }
        /// <p>Specifies whether the object tag-set are copied from the source object or replaced with tag-set provided in the request.</p>
        pub fn set_tagging_directive(
            mut self,
            input: std::option::Option<crate::model::TaggingDirective>,
        ) -> Self {
            self.inner = self.inner.set_tagging_directive(input);
            self
        }
        /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>
        pub fn server_side_encryption(mut self, input: crate::model::ServerSideEncryption) -> Self {
            self.inner = self.inner.server_side_encryption(input);
            self
        }
        /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>
        pub fn set_server_side_encryption(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryption>,
        ) -> Self {
            self.inner = self.inner.set_server_side_encryption(input);
            self
        }
        /// <p>By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. Amazon S3 on Outposts only uses the OUTPOSTS Storage Class. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn storage_class(mut self, input: crate::model::StorageClass) -> Self {
            self.inner = self.inner.storage_class(input);
            self
        }
        /// <p>By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. Amazon S3 on Outposts only uses the OUTPOSTS Storage Class. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<crate::model::StorageClass>,
        ) -> Self {
            self.inner = self.inner.set_storage_class(input);
            self
        }
        /// <p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p>
        pub fn website_redirect_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.website_redirect_location(input.into());
            self
        }
        /// <p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p>
        pub fn set_website_redirect_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_website_redirect_location(input);
            self
        }
        /// <p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>
        pub fn sse_customer_algorithm(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sse_customer_algorithm(input.into());
            self
        }
        /// <p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>
        pub fn set_sse_customer_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sse_customer_algorithm(input);
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
        pub fn sse_customer_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sse_customer_key(input.into());
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
        pub fn set_sse_customer_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sse_customer_key(input);
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn sse_customer_key_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sse_customer_key_md5(input.into());
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn set_sse_customer_key_md5(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sse_customer_key_md5(input);
            self
        }
        /// <p>Specifies the Amazon Web Services KMS key ID to use for object encryption. All GET and PUT requests for an object protected by Amazon Web Services KMS will fail if not made via SSL or using SigV4. For information about configuring using any of the officially supported Amazon Web Services SDKs and Amazon Web Services CLI, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version">Specifying the Signature Version in Request Authentication</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn ssekms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ssekms_key_id(input.into());
            self
        }
        /// <p>Specifies the Amazon Web Services KMS key ID to use for object encryption. All GET and PUT requests for an object protected by Amazon Web Services KMS will fail if not made via SSL or using SigV4. For information about configuring using any of the officially supported Amazon Web Services SDKs and Amazon Web Services CLI, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version">Specifying the Signature Version in Request Authentication</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_ssekms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ssekms_key_id(input);
            self
        }
        /// <p>Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p>
        pub fn ssekms_encryption_context(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ssekms_encryption_context(input.into());
            self
        }
        /// <p>Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p>
        pub fn set_ssekms_encryption_context(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ssekms_encryption_context(input);
            self
        }
        /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using AWS KMS (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS. </p>
        /// <p>Specifying this header with a COPY action doesn’t affect bucket-level settings for S3 Bucket Key.</p>
        pub fn bucket_key_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.bucket_key_enabled(input);
            self
        }
        /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using AWS KMS (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS. </p>
        /// <p>Specifying this header with a COPY action doesn’t affect bucket-level settings for S3 Bucket Key.</p>
        pub fn set_bucket_key_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_bucket_key_enabled(input);
            self
        }
        /// <p>Specifies the algorithm to use when decrypting the source object (for example, AES256).</p>
        pub fn copy_source_sse_customer_algorithm(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.copy_source_sse_customer_algorithm(input.into());
            self
        }
        /// <p>Specifies the algorithm to use when decrypting the source object (for example, AES256).</p>
        pub fn set_copy_source_sse_customer_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_copy_source_sse_customer_algorithm(input);
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The encryption key provided in this header must be one that was used when the source object was created.</p>
        pub fn copy_source_sse_customer_key(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.copy_source_sse_customer_key(input.into());
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The encryption key provided in this header must be one that was used when the source object was created.</p>
        pub fn set_copy_source_sse_customer_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_copy_source_sse_customer_key(input);
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn copy_source_sse_customer_key_md5(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.copy_source_sse_customer_key_md5(input.into());
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn set_copy_source_sse_customer_key_md5(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_copy_source_sse_customer_key_md5(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.inner = self.inner.request_payer(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.inner = self.inner.set_request_payer(input);
            self
        }
        /// <p>The tag-set for the object destination object this value must be used in conjunction with the <code>TaggingDirective</code>. The tag-set must be encoded as URL Query parameters.</p>
        pub fn tagging(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tagging(input.into());
            self
        }
        /// <p>The tag-set for the object destination object this value must be used in conjunction with the <code>TaggingDirective</code>. The tag-set must be encoded as URL Query parameters.</p>
        pub fn set_tagging(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tagging(input);
            self
        }
        /// <p>The Object Lock mode that you want to apply to the copied object.</p>
        pub fn object_lock_mode(mut self, input: crate::model::ObjectLockMode) -> Self {
            self.inner = self.inner.object_lock_mode(input);
            self
        }
        /// <p>The Object Lock mode that you want to apply to the copied object.</p>
        pub fn set_object_lock_mode(
            mut self,
            input: std::option::Option<crate::model::ObjectLockMode>,
        ) -> Self {
            self.inner = self.inner.set_object_lock_mode(input);
            self
        }
        /// <p>The date and time when you want the copied object's Object Lock to expire.</p>
        pub fn object_lock_retain_until_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.object_lock_retain_until_date(input);
            self
        }
        /// <p>The date and time when you want the copied object's Object Lock to expire.</p>
        pub fn set_object_lock_retain_until_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_object_lock_retain_until_date(input);
            self
        }
        /// <p>Specifies whether you want to apply a Legal Hold to the copied object.</p>
        pub fn object_lock_legal_hold_status(
            mut self,
            input: crate::model::ObjectLockLegalHoldStatus,
        ) -> Self {
            self.inner = self.inner.object_lock_legal_hold_status(input);
            self
        }
        /// <p>Specifies whether you want to apply a Legal Hold to the copied object.</p>
        pub fn set_object_lock_legal_hold_status(
            mut self,
            input: std::option::Option<crate::model::ObjectLockLegalHoldStatus>,
        ) -> Self {
            self.inner = self.inner.set_object_lock_legal_hold_status(input);
            self
        }
        /// <p>The account ID of the expected destination bucket owner. If the destination bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected destination bucket owner. If the destination bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
        /// <p>The account ID of the expected source bucket owner. If the source bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_source_bucket_owner(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.expected_source_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected source bucket owner. If the source bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_source_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_source_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBucket`.
    ///
    /// <p>Creates a new S3 bucket. To create a bucket, you must register with Amazon S3 and have a valid Amazon Web Services Access Key ID to authenticate requests. Anonymous requests are never allowed to create buckets. By creating the bucket, you become the bucket owner.</p>
    /// <p>Not every string is an acceptable bucket name. For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html">Bucket naming rules</a>.</p>
    /// <p>If you want to create an Amazon S3 on Outposts bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html">Create Bucket</a>. </p>
    /// <p>By default, the bucket is created in the US East (N. Virginia) Region. You can optionally specify a Region in the request body. You might choose a Region to optimize latency, minimize costs, or address regulatory requirements. For example, if you reside in Europe, you will probably find it advantageous to create buckets in the Europe (Ireland) Region. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingBucket.html#access-bucket-intro">Accessing a bucket</a>.</p> <note>
    /// <p>If you send your create bucket request to the <code>s3.amazonaws.com</code> endpoint, the request goes to the us-east-1 Region. Accordingly, the signature calculations in Signature Version 4 must use us-east-1 as the Region, even if the location constraint in the request specifies another Region where the bucket is to be created. If you create a bucket in a Region other than US East (N. Virginia), your application must be able to handle 307 redirect. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/VirtualHosting.html">Virtual hosting of buckets</a>.</p>
    /// </note>
    /// <p> <b>Access control lists (ACLs)</b> </p>
    /// <p>When creating a bucket using this operation, you can optionally configure the bucket ACL to specify the accounts or groups that should be granted specific permissions on the bucket.</p> <important>
    /// <p>If your CreateBucket request sets bucket owner enforced for S3 Object Ownership and specifies a bucket ACL that provides access to an external Amazon Web Services account, your request fails with a <code>400</code> error and returns the <code>InvalidBucketAclWithObjectOwnership</code> error code. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling object ownership</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// </important>
    /// <p>There are two ways to grant the appropriate permissions using the request headers.</p>
    /// <ul>
    /// <li> <p>Specify a canned ACL using the <code>x-amz-acl</code> request header. Amazon S3 supports a set of predefined ACLs, known as <i>canned ACLs</i>. Each canned ACL has a predefined set of grantees and permissions. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a>.</p> </li>
    /// <li> <p>Specify access permissions explicitly using the <code>x-amz-grant-read</code>, <code>x-amz-grant-write</code>, <code>x-amz-grant-read-acp</code>, <code>x-amz-grant-write-acp</code>, and <code>x-amz-grant-full-control</code> headers. These headers map to the set of permissions Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html">Access control list (ACL) overview</a>.</p> <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li> <p> <code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p> </li>
    /// <li> <p> <code>uri</code> – if you are granting permissions to a predefined group</p> </li>
    /// <li> <p> <code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p> <note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions: </p>
    /// <ul>
    /// <li> <p>US East (N. Virginia)</p> </li>
    /// <li> <p>US West (N. California)</p> </li>
    /// <li> <p> US West (Oregon)</p> </li>
    /// <li> <p> Asia Pacific (Singapore)</p> </li>
    /// <li> <p>Asia Pacific (Sydney)</p> </li>
    /// <li> <p>Asia Pacific (Tokyo)</p> </li>
    /// <li> <p>Europe (Ireland)</p> </li>
    /// <li> <p>South America (São Paulo)</p> </li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note> </li>
    /// </ul> <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p> <p> <code>x-amz-grant-read: id="11112222333", id="444455556666" </code> </p> </li>
    /// </ul> <note>
    /// <p>You can use either a canned ACL or specify access permissions explicitly. You cannot do both.</p>
    /// </note>
    /// <p> <b>Permissions</b> </p>
    /// <p>In addition to <code>s3:CreateBucket</code>, the following permissions are required when your CreateBucket includes specific headers:</p>
    /// <ul>
    /// <li> <p> <b>ACLs</b> - If your <code>CreateBucket</code> request specifies ACL permissions and the ACL is public-read, public-read-write, authenticated-read, or if you specify access permissions explicitly through any other ACL, both <code>s3:CreateBucket</code> and <code>s3:PutBucketAcl</code> permissions are needed. If the ACL the <code>CreateBucket</code> request is private or doesn't specify any ACLs, only <code>s3:CreateBucket</code> permission is needed. </p> </li>
    /// <li> <p> <b>Object Lock</b> - If <code>ObjectLockEnabledForBucket</code> is set to true in your <code>CreateBucket</code> request, <code>s3:PutBucketObjectLockConfiguration</code> and <code>s3:PutBucketVersioning</code> permissions are required.</p> </li>
    /// <li> <p> <b>S3 Object Ownership</b> - If your CreateBucket request includes the the <code>x-amz-object-ownership</code> header, <code>s3:PutBucketOwnershipControls</code> permission is required.</p> </li>
    /// </ul>
    /// <p>The following operations are related to <code>CreateBucket</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html">DeleteBucket</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBucket {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_bucket_input::Builder,
    }
    impl CreateBucket {
        /// Creates a new `CreateBucket`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBucketOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBucketError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The canned ACL to apply to the bucket.</p>
        pub fn acl(mut self, input: crate::model::BucketCannedAcl) -> Self {
            self.inner = self.inner.acl(input);
            self
        }
        /// <p>The canned ACL to apply to the bucket.</p>
        pub fn set_acl(
            mut self,
            input: std::option::Option<crate::model::BucketCannedAcl>,
        ) -> Self {
            self.inner = self.inner.set_acl(input);
            self
        }
        /// <p>The name of the bucket to create.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket to create.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The configuration information for the bucket.</p>
        pub fn create_bucket_configuration(
            mut self,
            input: crate::model::CreateBucketConfiguration,
        ) -> Self {
            self.inner = self.inner.create_bucket_configuration(input);
            self
        }
        /// <p>The configuration information for the bucket.</p>
        pub fn set_create_bucket_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateBucketConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_create_bucket_configuration(input);
            self
        }
        /// <p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p>
        pub fn grant_full_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_full_control(input.into());
            self
        }
        /// <p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p>
        pub fn set_grant_full_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_grant_full_control(input);
            self
        }
        /// <p>Allows grantee to list the objects in the bucket.</p>
        pub fn grant_read(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_read(input.into());
            self
        }
        /// <p>Allows grantee to list the objects in the bucket.</p>
        pub fn set_grant_read(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grant_read(input);
            self
        }
        /// <p>Allows grantee to read the bucket ACL.</p>
        pub fn grant_read_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_read_acp(input.into());
            self
        }
        /// <p>Allows grantee to read the bucket ACL.</p>
        pub fn set_grant_read_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_grant_read_acp(input);
            self
        }
        /// <p>Allows grantee to create new objects in the bucket.</p>
        /// <p>For the bucket and object owners of existing objects, also allows deletions and overwrites of those objects.</p>
        pub fn grant_write(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_write(input.into());
            self
        }
        /// <p>Allows grantee to create new objects in the bucket.</p>
        /// <p>For the bucket and object owners of existing objects, also allows deletions and overwrites of those objects.</p>
        pub fn set_grant_write(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grant_write(input);
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable bucket.</p>
        pub fn grant_write_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_write_acp(input.into());
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable bucket.</p>
        pub fn set_grant_write_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_grant_write_acp(input);
            self
        }
        /// <p>Specifies whether you want S3 Object Lock to be enabled for the new bucket.</p>
        pub fn object_lock_enabled_for_bucket(mut self, input: bool) -> Self {
            self.inner = self.inner.object_lock_enabled_for_bucket(input);
            self
        }
        /// <p>Specifies whether you want S3 Object Lock to be enabled for the new bucket.</p>
        pub fn set_object_lock_enabled_for_bucket(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_object_lock_enabled_for_bucket(input);
            self
        }
        /// <p>The container element for object ownership for a bucket's ownership controls.</p>
        /// <p>BucketOwnerPreferred - Objects uploaded to the bucket change ownership to the bucket owner if the objects are uploaded with the <code>bucket-owner-full-control</code> canned ACL.</p>
        /// <p>ObjectWriter - The uploading account will own the object if the object is uploaded with the <code>bucket-owner-full-control</code> canned ACL.</p>
        /// <p>BucketOwnerEnforced - Access control lists (ACLs) are disabled and no longer affect permissions. The bucket owner automatically owns and has full control over every object in the bucket. The bucket only accepts PUT requests that don't specify an ACL or bucket owner full control ACLs, such as the <code>bucket-owner-full-control</code> canned ACL or an equivalent form of this ACL expressed in the XML format.</p>
        pub fn object_ownership(mut self, input: crate::model::ObjectOwnership) -> Self {
            self.inner = self.inner.object_ownership(input);
            self
        }
        /// <p>The container element for object ownership for a bucket's ownership controls.</p>
        /// <p>BucketOwnerPreferred - Objects uploaded to the bucket change ownership to the bucket owner if the objects are uploaded with the <code>bucket-owner-full-control</code> canned ACL.</p>
        /// <p>ObjectWriter - The uploading account will own the object if the object is uploaded with the <code>bucket-owner-full-control</code> canned ACL.</p>
        /// <p>BucketOwnerEnforced - Access control lists (ACLs) are disabled and no longer affect permissions. The bucket owner automatically owns and has full control over every object in the bucket. The bucket only accepts PUT requests that don't specify an ACL or bucket owner full control ACLs, such as the <code>bucket-owner-full-control</code> canned ACL or an equivalent form of this ACL expressed in the XML format.</p>
        pub fn set_object_ownership(
            mut self,
            input: std::option::Option<crate::model::ObjectOwnership>,
        ) -> Self {
            self.inner = self.inner.set_object_ownership(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMultipartUpload`.
    ///
    /// <p>This action initiates a multipart upload and returns an upload ID. This upload ID is used to associate all of the parts in the specific multipart upload. You specify this upload ID in each of your subsequent upload part requests (see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a>). You also include this upload ID in the final request to either complete or abort the multipart upload request.</p>
    /// <p>For more information about multipart uploads, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html">Multipart Upload Overview</a>.</p>
    /// <p>If you have configured a lifecycle rule to abort incomplete multipart uploads, the upload must complete within the number of days specified in the bucket lifecycle configuration. Otherwise, the incomplete multipart upload becomes eligible for an abort action and Amazon S3 aborts the multipart upload. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config">Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Policy</a>.</p>
    /// <p>For information about the permissions required to use the multipart upload API, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html">Multipart Upload and Permissions</a>.</p>
    /// <p>For request signing, multipart upload is just a series of regular requests. You initiate a multipart upload, send one or more requests to upload parts, and then complete the multipart upload process. You sign each request individually. There is nothing special about signing multipart upload requests. For more information about signing, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html">Authenticating Requests (Amazon Web Services Signature Version 4)</a>.</p> <note>
    /// <p> After you initiate a multipart upload and upload one or more parts, to stop being charged for storing the uploaded parts, you must either complete or abort the multipart upload. Amazon S3 frees up the space used to store the parts and stop charging you for storing them only after you either complete or abort a multipart upload. </p>
    /// </note>
    /// <p>You can optionally request server-side encryption. For server-side encryption, Amazon S3 encrypts your data as it writes it to disks in its data centers and decrypts it when you access it. You can provide your own encryption key, or use Amazon Web Services KMS keys or Amazon S3-managed encryption keys. If you choose to provide your own encryption key, the request headers you provide in <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPartCopy.html">UploadPartCopy</a> requests must match the headers you used in the request to initiate the upload by using <code>CreateMultipartUpload</code>. </p>
    /// <p>To perform a multipart upload with encryption using an Amazon Web Services KMS key, the requester must have permission to the <code>kms:Decrypt</code> and <code>kms:GenerateDataKey*</code> actions on the key. These permissions are required because Amazon S3 must decrypt and read data from the encrypted file parts before it completes the multipart upload. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/mpuoverview.html#mpuAndPermissions">Multipart upload API and permissions</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>If your Identity and Access Management (IAM) user or role is in the same Amazon Web Services account as the KMS key, then you must have these permissions on the key policy. If your IAM user or role belongs to a different account than the key, then you must have the permissions on both the key policy and your IAM user or role.</p>
    /// <p> For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html">Protecting Data Using Server-Side Encryption</a>.</p>
    /// <dl>
    /// <dt>
    /// Access Permissions
    /// </dt>
    /// <dd>
    /// <p>When copying an object, you can optionally specify the accounts or groups that should be granted specific permissions on the new object. There are two ways to grant the permissions using the request headers:</p>
    /// <ul>
    /// <li> <p>Specify a canned ACL with the <code>x-amz-acl</code> request header. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a>.</p> </li>
    /// <li> <p>Specify access permissions explicitly with the <code>x-amz-grant-read</code>, <code>x-amz-grant-read-acp</code>, <code>x-amz-grant-write-acp</code>, and <code>x-amz-grant-full-control</code> headers. These parameters map to the set of permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a>.</p> </li>
    /// </ul>
    /// <p>You can use either a canned ACL or specify access permissions explicitly. You cannot do both.</p>
    /// </dd>
    /// <dt>
    /// Server-Side- Encryption-Specific Request Headers
    /// </dt>
    /// <dd>
    /// <p>You can optionally tell Amazon S3 to encrypt data at rest using server-side encryption. Server-side encryption is for data encryption at rest. Amazon S3 encrypts your data as it writes it to disks in its data centers and decrypts it when you access it. The option you use depends on whether you want to use Amazon Web Services managed encryption keys or provide your own encryption key. </p>
    /// <ul>
    /// <li> <p>Use encryption keys managed by Amazon S3 or customer managed key stored in Amazon Web Services Key Management Service (Amazon Web Services KMS) – If you want Amazon Web Services to manage the keys used to encrypt data, specify the following headers in the request.</p>
    /// <ul>
    /// <li> <p>x-amz-server-side-encryption</p> </li>
    /// <li> <p>x-amz-server-side-encryption-aws-kms-key-id</p> </li>
    /// <li> <p>x-amz-server-side-encryption-context</p> </li>
    /// </ul> <note>
    /// <p>If you specify <code>x-amz-server-side-encryption:aws:kms</code>, but don't provide <code>x-amz-server-side-encryption-aws-kms-key-id</code>, Amazon S3 uses the Amazon Web Services managed key in Amazon Web Services KMS to protect the data.</p>
    /// </note> <important>
    /// <p>All GET and PUT requests for an object protected by Amazon Web Services KMS fail if you don't make them with SSL or by using SigV4.</p>
    /// </important> <p>For more information about server-side encryption with KMS key (SSE-KMS), see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">Protecting Data Using Server-Side Encryption with KMS keys</a>.</p> </li>
    /// <li> <p>Use customer-provided encryption keys – If you want to manage your own encryption keys, provide all the following headers in the request.</p>
    /// <ul>
    /// <li> <p>x-amz-server-side-encryption-customer-algorithm</p> </li>
    /// <li> <p>x-amz-server-side-encryption-customer-key</p> </li>
    /// <li> <p>x-amz-server-side-encryption-customer-key-MD5</p> </li>
    /// </ul> <p>For more information about server-side encryption with KMS keys (SSE-KMS), see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">Protecting Data Using Server-Side Encryption with KMS keys</a>.</p> </li>
    /// </ul>
    /// </dd>
    /// <dt>
    /// Access-Control-List (ACL)-Specific Request Headers
    /// </dt>
    /// <dd>
    /// <p>You also can use the following access control–related headers with this operation. By default, all objects are private. Only the owner has full access control. When adding a new object, you can grant permissions to individual Amazon Web Services accounts or to predefined groups defined by Amazon S3. These permissions are then added to the access control list (ACL) on the object. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html">Using ACLs</a>. With this operation, you can grant access permissions using one of the following two methods:</p>
    /// <ul>
    /// <li> <p>Specify a canned ACL (<code>x-amz-acl</code>) — Amazon S3 supports a set of predefined ACLs, known as <i>canned ACLs</i>. Each canned ACL has a predefined set of grantees and permissions. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a>.</p> </li>
    /// <li> <p>Specify access permissions explicitly — To explicitly grant access permissions to specific Amazon Web Services accounts or groups, use the following headers. Each header maps to specific permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a>. In the header, you specify a list of grantees who get the specific permission. To grant permissions explicitly, use:</p>
    /// <ul>
    /// <li> <p>x-amz-grant-read</p> </li>
    /// <li> <p>x-amz-grant-write</p> </li>
    /// <li> <p>x-amz-grant-read-acp</p> </li>
    /// <li> <p>x-amz-grant-write-acp</p> </li>
    /// <li> <p>x-amz-grant-full-control</p> </li>
    /// </ul> <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li> <p> <code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p> </li>
    /// <li> <p> <code>uri</code> – if you are granting permissions to a predefined group</p> </li>
    /// <li> <p> <code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p> <note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions: </p>
    /// <ul>
    /// <li> <p>US East (N. Virginia)</p> </li>
    /// <li> <p>US West (N. California)</p> </li>
    /// <li> <p> US West (Oregon)</p> </li>
    /// <li> <p> Asia Pacific (Singapore)</p> </li>
    /// <li> <p>Asia Pacific (Sydney)</p> </li>
    /// <li> <p>Asia Pacific (Tokyo)</p> </li>
    /// <li> <p>Europe (Ireland)</p> </li>
    /// <li> <p>South America (São Paulo)</p> </li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note> </li>
    /// </ul> <p>For example, the following <code>x-amz-grant-read</code> header grants the Amazon Web Services accounts identified by account IDs permissions to read object data and its metadata:</p> <p> <code>x-amz-grant-read: id="11112222333", id="444455556666" </code> </p> </li>
    /// </ul>
    /// </dd>
    /// </dl>
    /// <p>The following operations are related to <code>CreateMultipartUpload</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html">CompleteMultipartUpload</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html">AbortMultipartUpload</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html">ListParts</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html">ListMultipartUploads</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateMultipartUpload {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_multipart_upload_input::Builder,
    }
    impl CreateMultipartUpload {
        /// Creates a new `CreateMultipartUpload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMultipartUploadOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMultipartUploadError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The canned ACL to apply to the object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn acl(mut self, input: crate::model::ObjectCannedAcl) -> Self {
            self.inner = self.inner.acl(input);
            self
        }
        /// <p>The canned ACL to apply to the object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_acl(
            mut self,
            input: std::option::Option<crate::model::ObjectCannedAcl>,
        ) -> Self {
            self.inner = self.inner.set_acl(input);
            self
        }
        /// <p>The name of the bucket to which to initiate the upload</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket to which to initiate the upload</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>Specifies caching behavior along the request/reply chain.</p>
        pub fn cache_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cache_control(input.into());
            self
        }
        /// <p>Specifies caching behavior along the request/reply chain.</p>
        pub fn set_cache_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cache_control(input);
            self
        }
        /// <p>Specifies presentational information for the object.</p>
        pub fn content_disposition(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_disposition(input.into());
            self
        }
        /// <p>Specifies presentational information for the object.</p>
        pub fn set_content_disposition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_content_disposition(input);
            self
        }
        /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>
        pub fn content_encoding(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_encoding(input.into());
            self
        }
        /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>
        pub fn set_content_encoding(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_content_encoding(input);
            self
        }
        /// <p>The language the content is in.</p>
        pub fn content_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_language(input.into());
            self
        }
        /// <p>The language the content is in.</p>
        pub fn set_content_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_content_language(input);
            self
        }
        /// <p>A standard MIME type describing the format of the object data.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_type(input.into());
            self
        }
        /// <p>A standard MIME type describing the format of the object data.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_type(input);
            self
        }
        /// <p>The date and time at which the object is no longer cacheable.</p>
        pub fn expires(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.expires(input);
            self
        }
        /// <p>The date and time at which the object is no longer cacheable.</p>
        pub fn set_expires(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_expires(input);
            self
        }
        /// <p>Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_full_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_full_control(input.into());
            self
        }
        /// <p>Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_full_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_grant_full_control(input);
            self
        }
        /// <p>Allows grantee to read the object data and its metadata.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_read(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_read(input.into());
            self
        }
        /// <p>Allows grantee to read the object data and its metadata.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_read(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grant_read(input);
            self
        }
        /// <p>Allows grantee to read the object ACL.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_read_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_read_acp(input.into());
            self
        }
        /// <p>Allows grantee to read the object ACL.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_read_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_grant_read_acp(input);
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_write_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_write_acp(input.into());
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_write_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_grant_write_acp(input);
            self
        }
        /// <p>Object key for which the multipart upload is to be initiated.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key(input.into());
            self
        }
        /// <p>Object key for which the multipart upload is to be initiated.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key(input);
            self
        }
        /// Adds a key-value pair to `Metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>A map of metadata to store with the object in S3.</p>
        pub fn metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.metadata(k.into(), v.into());
            self
        }
        /// <p>A map of metadata to store with the object in S3.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_metadata(input);
            self
        }
        /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>
        pub fn server_side_encryption(mut self, input: crate::model::ServerSideEncryption) -> Self {
            self.inner = self.inner.server_side_encryption(input);
            self
        }
        /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>
        pub fn set_server_side_encryption(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryption>,
        ) -> Self {
            self.inner = self.inner.set_server_side_encryption(input);
            self
        }
        /// <p>By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. Amazon S3 on Outposts only uses the OUTPOSTS Storage Class. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn storage_class(mut self, input: crate::model::StorageClass) -> Self {
            self.inner = self.inner.storage_class(input);
            self
        }
        /// <p>By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. Amazon S3 on Outposts only uses the OUTPOSTS Storage Class. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<crate::model::StorageClass>,
        ) -> Self {
            self.inner = self.inner.set_storage_class(input);
            self
        }
        /// <p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p>
        pub fn website_redirect_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.website_redirect_location(input.into());
            self
        }
        /// <p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p>
        pub fn set_website_redirect_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_website_redirect_location(input);
            self
        }
        /// <p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>
        pub fn sse_customer_algorithm(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sse_customer_algorithm(input.into());
            self
        }
        /// <p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>
        pub fn set_sse_customer_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sse_customer_algorithm(input);
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
        pub fn sse_customer_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sse_customer_key(input.into());
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
        pub fn set_sse_customer_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sse_customer_key(input);
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn sse_customer_key_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sse_customer_key_md5(input.into());
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn set_sse_customer_key_md5(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sse_customer_key_md5(input);
            self
        }
        /// <p>Specifies the ID of the symmetric customer managed key to use for object encryption. All GET and PUT requests for an object protected by Amazon Web Services KMS will fail if not made via SSL or using SigV4. For information about configuring using any of the officially supported Amazon Web Services SDKs and Amazon Web Services CLI, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version">Specifying the Signature Version in Request Authentication</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn ssekms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ssekms_key_id(input.into());
            self
        }
        /// <p>Specifies the ID of the symmetric customer managed key to use for object encryption. All GET and PUT requests for an object protected by Amazon Web Services KMS will fail if not made via SSL or using SigV4. For information about configuring using any of the officially supported Amazon Web Services SDKs and Amazon Web Services CLI, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version">Specifying the Signature Version in Request Authentication</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_ssekms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ssekms_key_id(input);
            self
        }
        /// <p>Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p>
        pub fn ssekms_encryption_context(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ssekms_encryption_context(input.into());
            self
        }
        /// <p>Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p>
        pub fn set_ssekms_encryption_context(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ssekms_encryption_context(input);
            self
        }
        /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using AWS KMS (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.</p>
        /// <p>Specifying this header with an object action doesn’t affect bucket-level settings for S3 Bucket Key.</p>
        pub fn bucket_key_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.bucket_key_enabled(input);
            self
        }
        /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using AWS KMS (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.</p>
        /// <p>Specifying this header with an object action doesn’t affect bucket-level settings for S3 Bucket Key.</p>
        pub fn set_bucket_key_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_bucket_key_enabled(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.inner = self.inner.request_payer(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.inner = self.inner.set_request_payer(input);
            self
        }
        /// <p>The tag-set for the object. The tag-set must be encoded as URL Query parameters.</p>
        pub fn tagging(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tagging(input.into());
            self
        }
        /// <p>The tag-set for the object. The tag-set must be encoded as URL Query parameters.</p>
        pub fn set_tagging(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tagging(input);
            self
        }
        /// <p>Specifies the Object Lock mode that you want to apply to the uploaded object.</p>
        pub fn object_lock_mode(mut self, input: crate::model::ObjectLockMode) -> Self {
            self.inner = self.inner.object_lock_mode(input);
            self
        }
        /// <p>Specifies the Object Lock mode that you want to apply to the uploaded object.</p>
        pub fn set_object_lock_mode(
            mut self,
            input: std::option::Option<crate::model::ObjectLockMode>,
        ) -> Self {
            self.inner = self.inner.set_object_lock_mode(input);
            self
        }
        /// <p>Specifies the date and time when you want the Object Lock to expire.</p>
        pub fn object_lock_retain_until_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.object_lock_retain_until_date(input);
            self
        }
        /// <p>Specifies the date and time when you want the Object Lock to expire.</p>
        pub fn set_object_lock_retain_until_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_object_lock_retain_until_date(input);
            self
        }
        /// <p>Specifies whether you want to apply a Legal Hold to the uploaded object.</p>
        pub fn object_lock_legal_hold_status(
            mut self,
            input: crate::model::ObjectLockLegalHoldStatus,
        ) -> Self {
            self.inner = self.inner.object_lock_legal_hold_status(input);
            self
        }
        /// <p>Specifies whether you want to apply a Legal Hold to the uploaded object.</p>
        pub fn set_object_lock_legal_hold_status(
            mut self,
            input: std::option::Option<crate::model::ObjectLockLegalHoldStatus>,
        ) -> Self {
            self.inner = self.inner.set_object_lock_legal_hold_status(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBucket`.
    ///
    /// <p>Deletes the S3 bucket. All objects (including all object versions and delete markers) in the bucket must be deleted before the bucket itself can be deleted.</p>
    /// <p class="title"> <b>Related Resources</b> </p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html">DeleteObject</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBucket {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_bucket_input::Builder,
    }
    impl DeleteBucket {
        /// Creates a new `DeleteBucket`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBucketOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBucketError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the bucket being deleted.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>Specifies the bucket being deleted.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBucketAnalyticsConfiguration`.
    ///
    /// <p>Deletes an analytics configuration for the bucket (specified by the analytics configuration ID).</p>
    /// <p>To use this operation, you must have permissions to perform the <code>s3:PutAnalyticsConfiguration</code> action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p>
    /// <p>For information about the Amazon S3 analytics feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/analytics-storage-class.html">Amazon S3 Analytics – Storage Class Analysis</a>. </p>
    /// <p>The following operations are related to <code>DeleteBucketAnalyticsConfiguration</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketAnalyticsConfiguration.html">GetBucketAnalyticsConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketAnalyticsConfigurations.html">ListBucketAnalyticsConfigurations</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAnalyticsConfiguration.html">PutBucketAnalyticsConfiguration</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBucketAnalyticsConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_bucket_analytics_configuration_input::Builder,
    }
    impl DeleteBucketAnalyticsConfiguration {
        /// Creates a new `DeleteBucketAnalyticsConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBucketAnalyticsConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteBucketAnalyticsConfigurationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket from which an analytics configuration is deleted.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket from which an analytics configuration is deleted.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The ID that identifies the analytics configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID that identifies the analytics configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBucketCors`.
    ///
    /// <p>Deletes the <code>cors</code> configuration information set for the bucket.</p>
    /// <p>To use this operation, you must have permission to perform the <code>s3:PutBucketCORS</code> action. The bucket owner has this permission by default and can grant this permission to others. </p>
    /// <p>For information about <code>cors</code>, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">Enabling Cross-Origin Resource Sharing</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p class="title"> <b>Related Resources:</b> </p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketCors.html">PutBucketCors</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTOPTIONSobject.html">RESTOPTIONSobject</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBucketCors {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_bucket_cors_input::Builder,
    }
    impl DeleteBucketCors {
        /// Creates a new `DeleteBucketCors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBucketCorsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBucketCorsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the bucket whose <code>cors</code> configuration is being deleted.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>Specifies the bucket whose <code>cors</code> configuration is being deleted.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBucketEncryption`.
    ///
    /// <p>This implementation of the DELETE action removes default encryption from the bucket. For information about the Amazon S3 default encryption feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">Amazon S3 Default Bucket Encryption</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>To use this operation, you must have permissions to perform the <code>s3:PutEncryptionConfiguration</code> action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions to your Amazon S3 Resources</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p class="title"> <b>Related Resources</b> </p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketEncryption.html">PutBucketEncryption</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketEncryption.html">GetBucketEncryption</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBucketEncryption {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_bucket_encryption_input::Builder,
    }
    impl DeleteBucketEncryption {
        /// Creates a new `DeleteBucketEncryption`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBucketEncryptionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBucketEncryptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket containing the server-side encryption configuration to delete.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket containing the server-side encryption configuration to delete.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBucketIntelligentTieringConfiguration`.
    ///
    /// <p>Deletes the S3 Intelligent-Tiering configuration from the specified bucket.</p>
    /// <p>The S3 Intelligent-Tiering storage class is designed to optimize storage costs by automatically moving data to the most cost-effective storage access tier, without performance impact or operational overhead. S3 Intelligent-Tiering delivers automatic cost savings in three low latency and high throughput access tiers. To get the lowest storage cost on data that can be accessed in minutes to hours, you can choose to activate additional archiving capabilities.</p>
    /// <p>The S3 Intelligent-Tiering storage class is the ideal storage class for data with unknown, changing, or unpredictable access patterns, independent of object size or retention period. If the size of an object is less than 128 KB, it is not monitored and not eligible for auto-tiering. Smaller objects can be stored, but they are always charged at the Frequent Access tier rates in the S3 Intelligent-Tiering storage class.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access">Storage class for automatically optimizing frequently and infrequently accessed objects</a>.</p>
    /// <p>Operations related to <code>DeleteBucketIntelligentTieringConfiguration</code> include: </p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketIntelligentTieringConfiguration.html">GetBucketIntelligentTieringConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketIntelligentTieringConfiguration.html">PutBucketIntelligentTieringConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketIntelligentTieringConfigurations.html">ListBucketIntelligentTieringConfigurations</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBucketIntelligentTieringConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_bucket_intelligent_tiering_configuration_input::Builder,
    }
    impl DeleteBucketIntelligentTieringConfiguration {
        /// Creates a new `DeleteBucketIntelligentTieringConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBucketIntelligentTieringConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteBucketIntelligentTieringConfigurationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon S3 bucket whose configuration you want to modify or retrieve.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket whose configuration you want to modify or retrieve.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBucketInventoryConfiguration`.
    ///
    /// <p>Deletes an inventory configuration (identified by the inventory ID) from the bucket.</p>
    /// <p>To use this operation, you must have permissions to perform the <code>s3:PutInventoryConfiguration</code> action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p>
    /// <p>For information about the Amazon S3 inventory feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html">Amazon S3 Inventory</a>.</p>
    /// <p>Operations related to <code>DeleteBucketInventoryConfiguration</code> include: </p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketInventoryConfiguration.html">GetBucketInventoryConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketInventoryConfiguration.html">PutBucketInventoryConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketInventoryConfigurations.html">ListBucketInventoryConfigurations</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBucketInventoryConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_bucket_inventory_configuration_input::Builder,
    }
    impl DeleteBucketInventoryConfiguration {
        /// Creates a new `DeleteBucketInventoryConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBucketInventoryConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteBucketInventoryConfigurationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket containing the inventory configuration to delete.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket containing the inventory configuration to delete.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The ID used to identify the inventory configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID used to identify the inventory configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBucketLifecycle`.
    ///
    /// <p>Deletes the lifecycle configuration from the specified bucket. Amazon S3 removes all the lifecycle configuration rules in the lifecycle subresource associated with the bucket. Your objects never expire, and Amazon S3 no longer automatically deletes any objects on the basis of rules contained in the deleted lifecycle configuration.</p>
    /// <p>To use this operation, you must have permission to perform the <code>s3:PutLifecycleConfiguration</code> action. By default, the bucket owner has this permission and the bucket owner can grant this permission to others.</p>
    /// <p>There is usually some time lag before lifecycle configuration deletion is fully propagated to all the Amazon S3 systems.</p>
    /// <p>For more information about the object expiration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#intro-lifecycle-rules-actions">Elements to Describe Lifecycle Actions</a>.</p>
    /// <p>Related actions include:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html">PutBucketLifecycleConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html">GetBucketLifecycleConfiguration</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBucketLifecycle {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_bucket_lifecycle_input::Builder,
    }
    impl DeleteBucketLifecycle {
        /// Creates a new `DeleteBucketLifecycle`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBucketLifecycleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBucketLifecycleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The bucket name of the lifecycle to delete.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The bucket name of the lifecycle to delete.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBucketMetricsConfiguration`.
    ///
    /// <p>Deletes a metrics configuration for the Amazon CloudWatch request metrics (specified by the metrics configuration ID) from the bucket. Note that this doesn't include the daily storage metrics.</p>
    /// <p> To use this operation, you must have permissions to perform the <code>s3:PutMetricsConfiguration</code> action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p>
    /// <p>For information about CloudWatch request metrics for Amazon S3, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html">Monitoring Metrics with Amazon CloudWatch</a>. </p>
    /// <p>The following operations are related to <code>DeleteBucketMetricsConfiguration</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketMetricsConfiguration.html">GetBucketMetricsConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketMetricsConfiguration.html">PutBucketMetricsConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketMetricsConfigurations.html">ListBucketMetricsConfigurations</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html">Monitoring Metrics with Amazon CloudWatch</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBucketMetricsConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_bucket_metrics_configuration_input::Builder,
    }
    impl DeleteBucketMetricsConfiguration {
        /// Creates a new `DeleteBucketMetricsConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBucketMetricsConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBucketMetricsConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket containing the metrics configuration to delete.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket containing the metrics configuration to delete.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The ID used to identify the metrics configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID used to identify the metrics configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBucketOwnershipControls`.
    ///
    /// <p>Removes <code>OwnershipControls</code> for an Amazon S3 bucket. To use this operation, you must have the <code>s3:PutBucketOwnershipControls</code> permission. For more information about Amazon S3 permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying Permissions in a Policy</a>.</p>
    /// <p>For information about Amazon S3 Object Ownership, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/about-object-ownership.html">Using Object Ownership</a>. </p>
    /// <p>The following operations are related to <code>DeleteBucketOwnershipControls</code>:</p>
    /// <ul>
    /// <li> <p> <code>GetBucketOwnershipControls</code> </p> </li>
    /// <li> <p> <code>PutBucketOwnershipControls</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBucketOwnershipControls {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_bucket_ownership_controls_input::Builder,
    }
    impl DeleteBucketOwnershipControls {
        /// Creates a new `DeleteBucketOwnershipControls`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBucketOwnershipControlsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBucketOwnershipControlsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon S3 bucket whose <code>OwnershipControls</code> you want to delete. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The Amazon S3 bucket whose <code>OwnershipControls</code> you want to delete. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBucketPolicy`.
    ///
    /// <p>This implementation of the DELETE action uses the policy subresource to delete the policy of a specified bucket. If you are using an identity other than the root user of the Amazon Web Services account that owns the bucket, the calling identity must have the <code>DeleteBucketPolicy</code> permissions on the specified bucket and belong to the bucket owner's account to use this operation. </p>
    /// <p>If you don't have <code>DeleteBucketPolicy</code> permissions, Amazon S3 returns a <code>403 Access Denied</code> error. If you have the correct permissions, but you're not using an identity that belongs to the bucket owner's account, Amazon S3 returns a <code>405 Method Not Allowed</code> error. </p> <important>
    /// <p>As a security precaution, the root user of the Amazon Web Services account that owns a bucket can always use this operation, even if the policy explicitly denies the root user the ability to perform this action.</p>
    /// </important>
    /// <p>For more information about bucket policies, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies and UserPolicies</a>. </p>
    /// <p>The following operations are related to <code>DeleteBucketPolicy</code> </p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html">DeleteObject</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBucketPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_bucket_policy_input::Builder,
    }
    impl DeleteBucketPolicy {
        /// Creates a new `DeleteBucketPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBucketPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBucketPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The bucket name.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The bucket name.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBucketReplication`.
    ///
    /// <p> Deletes the replication configuration from the bucket.</p>
    /// <p>To use this operation, you must have permissions to perform the <code>s3:PutReplicationConfiguration</code> action. The bucket owner has these permissions by default and can grant it to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>. </p> <note>
    /// <p>It can take a while for the deletion of a replication configuration to fully propagate.</p>
    /// </note>
    /// <p> For information about replication configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html">Replication</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>The following operations are related to <code>DeleteBucketReplication</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketReplication.html">PutBucketReplication</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketReplication.html">GetBucketReplication</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBucketReplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_bucket_replication_input::Builder,
    }
    impl DeleteBucketReplication {
        /// Creates a new `DeleteBucketReplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBucketReplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBucketReplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The bucket name. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p> The bucket name. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBucketTagging`.
    ///
    /// <p>Deletes the tags from the bucket.</p>
    /// <p>To use this operation, you must have permission to perform the <code>s3:PutBucketTagging</code> action. By default, the bucket owner has this permission and can grant this permission to others. </p>
    /// <p>The following operations are related to <code>DeleteBucketTagging</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketTagging.html">GetBucketTagging</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketTagging.html">PutBucketTagging</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBucketTagging {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_bucket_tagging_input::Builder,
    }
    impl DeleteBucketTagging {
        /// Creates a new `DeleteBucketTagging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBucketTaggingOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBucketTaggingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The bucket that has the tag set to be removed.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The bucket that has the tag set to be removed.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBucketWebsite`.
    ///
    /// <p>This action removes the website configuration for a bucket. Amazon S3 returns a <code>200 OK</code> response upon successfully deleting a website configuration on the specified bucket. You will get a <code>200 OK</code> response if the website configuration you are trying to delete does not exist on the bucket. Amazon S3 returns a <code>404</code> response if the bucket specified in the request does not exist.</p>
    /// <p>This DELETE action requires the <code>S3:DeleteBucketWebsite</code> permission. By default, only the bucket owner can delete the website configuration attached to a bucket. However, bucket owners can grant other users permission to delete the website configuration by writing a bucket policy granting them the <code>S3:DeleteBucketWebsite</code> permission. </p>
    /// <p>For more information about hosting websites, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">Hosting Websites on Amazon S3</a>. </p>
    /// <p>The following operations are related to <code>DeleteBucketWebsite</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketWebsite.html">GetBucketWebsite</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketWebsite.html">PutBucketWebsite</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBucketWebsite {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_bucket_website_input::Builder,
    }
    impl DeleteBucketWebsite {
        /// Creates a new `DeleteBucketWebsite`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBucketWebsiteOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBucketWebsiteError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The bucket name for which you want to remove the website configuration. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The bucket name for which you want to remove the website configuration. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteObject`.
    ///
    /// <p>Removes the null version (if there is one) of an object and inserts a delete marker, which becomes the latest version of the object. If there isn't a null version, Amazon S3 does not remove any objects but will still respond that the command was successful.</p>
    /// <p>To remove a specific version, you must be the bucket owner and you must use the version Id subresource. Using this subresource permanently deletes the version. If the object deleted is a delete marker, Amazon S3 sets the response header, <code>x-amz-delete-marker</code>, to true. </p>
    /// <p>If the object you want to delete is in a bucket where the bucket versioning configuration is MFA Delete enabled, you must include the <code>x-amz-mfa</code> request header in the DELETE <code>versionId</code> request. Requests that include <code>x-amz-mfa</code> must use HTTPS. </p>
    /// <p> For more information about MFA Delete, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMFADelete.html">Using MFA Delete</a>. To see sample requests that use versioning, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectDELETE.html#ExampleVersionObjectDelete">Sample Request</a>. </p>
    /// <p>You can delete objects by explicitly calling DELETE Object or configure its lifecycle (<a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycle.html">PutBucketLifecycle</a>) to enable Amazon S3 to remove them for you. If you want to block users or accounts from removing or deleting objects from your bucket, you must deny them the <code>s3:DeleteObject</code>, <code>s3:DeleteObjectVersion</code>, and <code>s3:PutLifeCycleConfiguration</code> actions. </p>
    /// <p>The following action is related to <code>DeleteObject</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteObject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_object_input::Builder,
    }
    impl DeleteObject {
        /// Creates a new `DeleteObject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteObjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteObjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The bucket name of the bucket containing the object. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The bucket name of the bucket containing the object. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>Key name of the object to delete.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key(input.into());
            self
        }
        /// <p>Key name of the object to delete.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key(input);
            self
        }
        /// <p>The concatenation of the authentication device's serial number, a space, and the value that is displayed on your authentication device. Required to permanently delete a versioned object if versioning is configured with MFA delete enabled.</p>
        pub fn mfa(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mfa(input.into());
            self
        }
        /// <p>The concatenation of the authentication device's serial number, a space, and the value that is displayed on your authentication device. Required to permanently delete a versioned object if versioning is configured with MFA delete enabled.</p>
        pub fn set_mfa(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mfa(input);
            self
        }
        /// <p>VersionId used to reference a specific version of the object.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(input.into());
            self
        }
        /// <p>VersionId used to reference a specific version of the object.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.inner = self.inner.request_payer(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.inner = self.inner.set_request_payer(input);
            self
        }
        /// <p>Indicates whether S3 Object Lock should bypass Governance-mode restrictions to process this operation. To use this header, you must have the <code>s3:PutBucketPublicAccessBlock</code> permission.</p>
        pub fn bypass_governance_retention(mut self, input: bool) -> Self {
            self.inner = self.inner.bypass_governance_retention(input);
            self
        }
        /// <p>Indicates whether S3 Object Lock should bypass Governance-mode restrictions to process this operation. To use this header, you must have the <code>s3:PutBucketPublicAccessBlock</code> permission.</p>
        pub fn set_bypass_governance_retention(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_bypass_governance_retention(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteObjects`.
    ///
    /// <p>This action enables you to delete multiple objects from a bucket using a single HTTP request. If you know the object keys that you want to delete, then this action provides a suitable alternative to sending individual delete requests, reducing per-request overhead.</p>
    /// <p>The request contains a list of up to 1000 keys that you want to delete. In the XML, you provide the object key names, and optionally, version IDs if you want to delete a specific version of the object from a versioning-enabled bucket. For each key, Amazon S3 performs a delete action and returns the result of that delete, success, or failure, in the response. Note that if the object specified in the request is not found, Amazon S3 returns the result as deleted.</p>
    /// <p> The action supports two modes for the response: verbose and quiet. By default, the action uses verbose mode in which the response includes the result of deletion of each key in your request. In quiet mode the response includes only keys where the delete action encountered an error. For a successful deletion, the action does not return any information about the delete in the response body.</p>
    /// <p>When performing this action on an MFA Delete enabled bucket, that attempts to delete any versioned objects, you must include an MFA token. If you do not provide one, the entire request will fail, even if there are non-versioned objects you are trying to delete. If you provide an invalid token, whether there are versioned keys in the request or not, the entire Multi-Object Delete request will fail. For information about MFA Delete, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html#MultiFactorAuthenticationDelete"> MFA Delete</a>.</p>
    /// <p>Finally, the Content-MD5 header is required for all Multi-Object Delete requests. Amazon S3 uses the header value to ensure that your request body has not been altered in transit.</p>
    /// <p>The following operations are related to <code>DeleteObjects</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html">CreateMultipartUpload</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html">CompleteMultipartUpload</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html">ListParts</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html">AbortMultipartUpload</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteObjects {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_objects_input::Builder,
    }
    impl DeleteObjects {
        /// Creates a new `DeleteObjects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteObjectsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteObjectsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The bucket name containing the objects to delete. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The bucket name containing the objects to delete. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>Container for the request.</p>
        pub fn delete(mut self, input: crate::model::Delete) -> Self {
            self.inner = self.inner.delete(input);
            self
        }
        /// <p>Container for the request.</p>
        pub fn set_delete(mut self, input: std::option::Option<crate::model::Delete>) -> Self {
            self.inner = self.inner.set_delete(input);
            self
        }
        /// <p>The concatenation of the authentication device's serial number, a space, and the value that is displayed on your authentication device. Required to permanently delete a versioned object if versioning is configured with MFA delete enabled.</p>
        pub fn mfa(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mfa(input.into());
            self
        }
        /// <p>The concatenation of the authentication device's serial number, a space, and the value that is displayed on your authentication device. Required to permanently delete a versioned object if versioning is configured with MFA delete enabled.</p>
        pub fn set_mfa(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mfa(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.inner = self.inner.request_payer(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.inner = self.inner.set_request_payer(input);
            self
        }
        /// <p>Specifies whether you want to delete this object even if it has a Governance-type Object Lock in place. To use this header, you must have the <code>s3:PutBucketPublicAccessBlock</code> permission.</p>
        pub fn bypass_governance_retention(mut self, input: bool) -> Self {
            self.inner = self.inner.bypass_governance_retention(input);
            self
        }
        /// <p>Specifies whether you want to delete this object even if it has a Governance-type Object Lock in place. To use this header, you must have the <code>s3:PutBucketPublicAccessBlock</code> permission.</p>
        pub fn set_bypass_governance_retention(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_bypass_governance_retention(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteObjectTagging`.
    ///
    /// <p>Removes the entire tag set from the specified object. For more information about managing object tags, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-tagging.html"> Object Tagging</a>.</p>
    /// <p>To use this operation, you must have permission to perform the <code>s3:DeleteObjectTagging</code> action.</p>
    /// <p>To delete tags of a specific object version, add the <code>versionId</code> query parameter in the request. You will need permission for the <code>s3:DeleteObjectVersionTagging</code> action.</p>
    /// <p>The following operations are related to <code>DeleteBucketMetricsConfiguration</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectTagging.html">PutObjectTagging</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectTagging.html">GetObjectTagging</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteObjectTagging {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_object_tagging_input::Builder,
    }
    impl DeleteObjectTagging {
        /// Creates a new `DeleteObjectTagging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteObjectTaggingOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteObjectTaggingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The bucket name containing the objects from which to remove the tags. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The bucket name containing the objects from which to remove the tags. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The key that identifies the object in the bucket from which to remove all tags.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key(input.into());
            self
        }
        /// <p>The key that identifies the object in the bucket from which to remove all tags.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key(input);
            self
        }
        /// <p>The versionId of the object that the tag-set will be removed from.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(input.into());
            self
        }
        /// <p>The versionId of the object that the tag-set will be removed from.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePublicAccessBlock`.
    ///
    /// <p>Removes the <code>PublicAccessBlock</code> configuration for an Amazon S3 bucket. To use this operation, you must have the <code>s3:PutBucketPublicAccessBlock</code> permission. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p>
    /// <p>The following operations are related to <code>DeletePublicAccessBlock</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html">Using Amazon S3 Block Public Access</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetPublicAccessBlock.html">GetPublicAccessBlock</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutPublicAccessBlock.html">PutPublicAccessBlock</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketPolicyStatus.html">GetBucketPolicyStatus</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePublicAccessBlock {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_public_access_block_input::Builder,
    }
    impl DeletePublicAccessBlock {
        /// Creates a new `DeletePublicAccessBlock`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePublicAccessBlockOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePublicAccessBlockError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon S3 bucket whose <code>PublicAccessBlock</code> configuration you want to delete. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The Amazon S3 bucket whose <code>PublicAccessBlock</code> configuration you want to delete. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketAccelerateConfiguration`.
    ///
    /// <p>This implementation of the GET action uses the <code>accelerate</code> subresource to return the Transfer Acceleration state of a bucket, which is either <code>Enabled</code> or <code>Suspended</code>. Amazon S3 Transfer Acceleration is a bucket-level feature that enables you to perform faster data transfers to and from Amazon S3.</p>
    /// <p>To use this operation, you must have permission to perform the <code>s3:GetAccelerateConfiguration</code> action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions to your Amazon S3 Resources</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>You set the Transfer Acceleration state of an existing bucket to <code>Enabled</code> or <code>Suspended</code> by using the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAccelerateConfiguration.html">PutBucketAccelerateConfiguration</a> operation. </p>
    /// <p>A GET <code>accelerate</code> request does not return a state value for a bucket that has no transfer acceleration state. A bucket has no Transfer Acceleration state if a state has never been set on the bucket. </p>
    /// <p>For more information about transfer acceleration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html">Transfer Acceleration</a> in the Amazon S3 User Guide.</p>
    /// <p class="title"> <b>Related Resources</b> </p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAccelerateConfiguration.html">PutBucketAccelerateConfiguration</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBucketAccelerateConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_bucket_accelerate_configuration_input::Builder,
    }
    impl GetBucketAccelerateConfiguration {
        /// Creates a new `GetBucketAccelerateConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketAccelerateConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketAccelerateConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket for which the accelerate configuration is retrieved.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket for which the accelerate configuration is retrieved.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketAcl`.
    ///
    /// <p>This implementation of the <code>GET</code> action uses the <code>acl</code> subresource to return the access control list (ACL) of a bucket. To use <code>GET</code> to return the ACL of the bucket, you must have <code>READ_ACP</code> access to the bucket. If <code>READ_ACP</code> permission is granted to the anonymous user, you can return the ACL of the bucket without using an authorization header.</p> <note>
    /// <p>If your bucket uses the bucket owner enforced setting for S3 Object Ownership, requests to read ACLs are still supported and return the <code>bucket-owner-full-control</code> ACL with the owner being the account that created the bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html"> Controlling object ownership and disabling ACLs</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// </note>
    /// <p class="title"> <b>Related Resources</b> </p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html">ListObjects</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBucketAcl {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_bucket_acl_input::Builder,
    }
    impl GetBucketAcl {
        /// Creates a new `GetBucketAcl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketAclOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketAclError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the S3 bucket whose ACL is being requested.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>Specifies the S3 bucket whose ACL is being requested.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketAnalyticsConfiguration`.
    ///
    /// <p>This implementation of the GET action returns an analytics configuration (identified by the analytics configuration ID) from the bucket.</p>
    /// <p>To use this operation, you must have permissions to perform the <code>s3:GetAnalyticsConfiguration</code> action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources"> Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a> in the <i>Amazon S3 User Guide</i>. </p>
    /// <p>For information about Amazon S3 analytics feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/analytics-storage-class.html">Amazon S3 Analytics – Storage Class Analysis</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p class="title"> <b>Related Resources</b> </p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketAnalyticsConfiguration.html">DeleteBucketAnalyticsConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketAnalyticsConfigurations.html">ListBucketAnalyticsConfigurations</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAnalyticsConfiguration.html">PutBucketAnalyticsConfiguration</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBucketAnalyticsConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_bucket_analytics_configuration_input::Builder,
    }
    impl GetBucketAnalyticsConfiguration {
        /// Creates a new `GetBucketAnalyticsConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketAnalyticsConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketAnalyticsConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket from which an analytics configuration is retrieved.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket from which an analytics configuration is retrieved.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The ID that identifies the analytics configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID that identifies the analytics configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketCors`.
    ///
    /// <p>Returns the cors configuration information set for the bucket.</p>
    /// <p> To use this operation, you must have permission to perform the s3:GetBucketCORS action. By default, the bucket owner has this permission and can grant it to others.</p>
    /// <p> For more information about cors, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html"> Enabling Cross-Origin Resource Sharing</a>.</p>
    /// <p>The following operations are related to <code>GetBucketCors</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketCors.html">PutBucketCors</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketCors.html">DeleteBucketCors</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBucketCors {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_bucket_cors_input::Builder,
    }
    impl GetBucketCors {
        /// Creates a new `GetBucketCors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketCorsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketCorsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The bucket name for which to get the cors configuration.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The bucket name for which to get the cors configuration.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketEncryption`.
    ///
    /// <p>Returns the default encryption configuration for an Amazon S3 bucket. If the bucket does not have a default encryption configuration, GetBucketEncryption returns <code>ServerSideEncryptionConfigurationNotFoundError</code>. </p>
    /// <p>For information about the Amazon S3 default encryption feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">Amazon S3 Default Bucket Encryption</a>.</p>
    /// <p> To use this operation, you must have permission to perform the <code>s3:GetEncryptionConfiguration</code> action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p>
    /// <p>The following operations are related to <code>GetBucketEncryption</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketEncryption.html">PutBucketEncryption</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketEncryption.html">DeleteBucketEncryption</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBucketEncryption {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_bucket_encryption_input::Builder,
    }
    impl GetBucketEncryption {
        /// Creates a new `GetBucketEncryption`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketEncryptionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketEncryptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket from which the server-side encryption configuration is retrieved.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket from which the server-side encryption configuration is retrieved.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketIntelligentTieringConfiguration`.
    ///
    /// <p>Gets the S3 Intelligent-Tiering configuration from the specified bucket.</p>
    /// <p>The S3 Intelligent-Tiering storage class is designed to optimize storage costs by automatically moving data to the most cost-effective storage access tier, without performance impact or operational overhead. S3 Intelligent-Tiering delivers automatic cost savings in three low latency and high throughput access tiers. To get the lowest storage cost on data that can be accessed in minutes to hours, you can choose to activate additional archiving capabilities.</p>
    /// <p>The S3 Intelligent-Tiering storage class is the ideal storage class for data with unknown, changing, or unpredictable access patterns, independent of object size or retention period. If the size of an object is less than 128 KB, it is not monitored and not eligible for auto-tiering. Smaller objects can be stored, but they are always charged at the Frequent Access tier rates in the S3 Intelligent-Tiering storage class.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access">Storage class for automatically optimizing frequently and infrequently accessed objects</a>.</p>
    /// <p>Operations related to <code>GetBucketIntelligentTieringConfiguration</code> include: </p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketIntelligentTieringConfiguration.html">DeleteBucketIntelligentTieringConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketIntelligentTieringConfiguration.html">PutBucketIntelligentTieringConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketIntelligentTieringConfigurations.html">ListBucketIntelligentTieringConfigurations</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBucketIntelligentTieringConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_bucket_intelligent_tiering_configuration_input::Builder,
    }
    impl GetBucketIntelligentTieringConfiguration {
        /// Creates a new `GetBucketIntelligentTieringConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketIntelligentTieringConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetBucketIntelligentTieringConfigurationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon S3 bucket whose configuration you want to modify or retrieve.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket whose configuration you want to modify or retrieve.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketInventoryConfiguration`.
    ///
    /// <p>Returns an inventory configuration (identified by the inventory configuration ID) from the bucket.</p>
    /// <p>To use this operation, you must have permissions to perform the <code>s3:GetInventoryConfiguration</code> action. The bucket owner has this permission by default and can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p>
    /// <p>For information about the Amazon S3 inventory feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html">Amazon S3 Inventory</a>.</p>
    /// <p>The following operations are related to <code>GetBucketInventoryConfiguration</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketInventoryConfiguration.html">DeleteBucketInventoryConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketInventoryConfigurations.html">ListBucketInventoryConfigurations</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketInventoryConfiguration.html">PutBucketInventoryConfiguration</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBucketInventoryConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_bucket_inventory_configuration_input::Builder,
    }
    impl GetBucketInventoryConfiguration {
        /// Creates a new `GetBucketInventoryConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketInventoryConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketInventoryConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket containing the inventory configuration to retrieve.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket containing the inventory configuration to retrieve.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The ID used to identify the inventory configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID used to identify the inventory configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketLifecycleConfiguration`.
    ///
    /// <note>
    /// <p>Bucket lifecycle configuration now supports specifying a lifecycle rule using an object key name prefix, one or more object tags, or a combination of both. Accordingly, this section describes the latest API. The response describes the new filter element that you can use to specify a filter to select a subset of objects to which the rule applies. If you are using a previous version of the lifecycle configuration, it still works. For the earlier action, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycle.html">GetBucketLifecycle</a>.</p>
    /// </note>
    /// <p>Returns the lifecycle configuration information set on the bucket. For information about lifecycle configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html">Object Lifecycle Management</a>.</p>
    /// <p>To use this operation, you must have permission to perform the <code>s3:GetLifecycleConfiguration</code> action. The bucket owner has this permission, by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p>
    /// <p> <code>GetBucketLifecycleConfiguration</code> has the following special error:</p>
    /// <ul>
    /// <li> <p>Error code: <code>NoSuchLifecycleConfiguration</code> </p>
    /// <ul>
    /// <li> <p>Description: The lifecycle configuration does not exist.</p> </li>
    /// <li> <p>HTTP Status Code: 404 Not Found</p> </li>
    /// <li> <p>SOAP Fault Code Prefix: Client</p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p>The following operations are related to <code>GetBucketLifecycleConfiguration</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycle.html">GetBucketLifecycle</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycle.html">PutBucketLifecycle</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketLifecycle.html">DeleteBucketLifecycle</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBucketLifecycleConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_bucket_lifecycle_configuration_input::Builder,
    }
    impl GetBucketLifecycleConfiguration {
        /// Creates a new `GetBucketLifecycleConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketLifecycleConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketLifecycleConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket for which to get the lifecycle information.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket for which to get the lifecycle information.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketLocation`.
    ///
    /// <p>Returns the Region the bucket resides in. You set the bucket's Region using the <code>LocationConstraint</code> request parameter in a <code>CreateBucket</code> request. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>.</p>
    /// <p>To use this implementation of the operation, you must be the bucket owner.</p>
    /// <p>To use this API against an access point, provide the alias of the access point in place of the bucket name.</p>
    /// <p>The following operations are related to <code>GetBucketLocation</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBucketLocation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_bucket_location_input::Builder,
    }
    impl GetBucketLocation {
        /// Creates a new `GetBucketLocation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketLocationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketLocationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket for which to get the location.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket for which to get the location.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketLogging`.
    ///
    /// <p>Returns the logging status of a bucket and the permissions users have to view and modify that status. To use GET, you must be the bucket owner.</p>
    /// <p>The following operations are related to <code>GetBucketLogging</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLogging.html">PutBucketLogging</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBucketLogging {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_bucket_logging_input::Builder,
    }
    impl GetBucketLogging {
        /// Creates a new `GetBucketLogging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketLoggingOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketLoggingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The bucket name for which to get the logging information.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The bucket name for which to get the logging information.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketMetricsConfiguration`.
    ///
    /// <p>Gets a metrics configuration (specified by the metrics configuration ID) from the bucket. Note that this doesn't include the daily storage metrics.</p>
    /// <p> To use this operation, you must have permissions to perform the <code>s3:GetMetricsConfiguration</code> action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p>
    /// <p> For information about CloudWatch request metrics for Amazon S3, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html">Monitoring Metrics with Amazon CloudWatch</a>.</p>
    /// <p>The following operations are related to <code>GetBucketMetricsConfiguration</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketMetricsConfiguration.html">PutBucketMetricsConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketMetricsConfiguration.html">DeleteBucketMetricsConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketMetricsConfigurations.html">ListBucketMetricsConfigurations</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html">Monitoring Metrics with Amazon CloudWatch</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBucketMetricsConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_bucket_metrics_configuration_input::Builder,
    }
    impl GetBucketMetricsConfiguration {
        /// Creates a new `GetBucketMetricsConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketMetricsConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketMetricsConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket containing the metrics configuration to retrieve.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket containing the metrics configuration to retrieve.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The ID used to identify the metrics configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID used to identify the metrics configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketNotificationConfiguration`.
    ///
    /// <p>Returns the notification configuration of a bucket.</p>
    /// <p>If notifications are not enabled on the bucket, the action returns an empty <code>NotificationConfiguration</code> element.</p>
    /// <p>By default, you must be the bucket owner to read the notification configuration of a bucket. However, the bucket owner can use a bucket policy to grant permission to other users to read this configuration with the <code>s3:GetBucketNotification</code> permission.</p>
    /// <p>For more information about setting and reading the notification configuration on a bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Setting Up Notification of Bucket Events</a>. For more information about bucket policies, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies</a>.</p>
    /// <p>The following action is related to <code>GetBucketNotification</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketNotification.html">PutBucketNotification</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBucketNotificationConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_bucket_notification_configuration_input::Builder,
    }
    impl GetBucketNotificationConfiguration {
        /// Creates a new `GetBucketNotificationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketNotificationConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetBucketNotificationConfigurationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket for which to get the notification configuration.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket for which to get the notification configuration.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketOwnershipControls`.
    ///
    /// <p>Retrieves <code>OwnershipControls</code> for an Amazon S3 bucket. To use this operation, you must have the <code>s3:GetBucketOwnershipControls</code> permission. For more information about Amazon S3 permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html">Specifying permissions in a policy</a>. </p>
    /// <p>For information about Amazon S3 Object Ownership, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Using Object Ownership</a>. </p>
    /// <p>The following operations are related to <code>GetBucketOwnershipControls</code>:</p>
    /// <ul>
    /// <li> <p> <code>PutBucketOwnershipControls</code> </p> </li>
    /// <li> <p> <code>DeleteBucketOwnershipControls</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBucketOwnershipControls {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_bucket_ownership_controls_input::Builder,
    }
    impl GetBucketOwnershipControls {
        /// Creates a new `GetBucketOwnershipControls`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketOwnershipControlsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketOwnershipControlsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon S3 bucket whose <code>OwnershipControls</code> you want to retrieve. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket whose <code>OwnershipControls</code> you want to retrieve. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketPolicy`.
    ///
    /// <p>Returns the policy of a specified bucket. If you are using an identity other than the root user of the Amazon Web Services account that owns the bucket, the calling identity must have the <code>GetBucketPolicy</code> permissions on the specified bucket and belong to the bucket owner's account in order to use this operation.</p>
    /// <p>If you don't have <code>GetBucketPolicy</code> permissions, Amazon S3 returns a <code>403 Access Denied</code> error. If you have the correct permissions, but you're not using an identity that belongs to the bucket owner's account, Amazon S3 returns a <code>405 Method Not Allowed</code> error.</p> <important>
    /// <p>As a security precaution, the root user of the Amazon Web Services account that owns a bucket can always use this operation, even if the policy explicitly denies the root user the ability to perform this action.</p>
    /// </important>
    /// <p>For more information about bucket policies, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies and User Policies</a>.</p>
    /// <p>The following action is related to <code>GetBucketPolicy</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBucketPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_bucket_policy_input::Builder,
    }
    impl GetBucketPolicy {
        /// Creates a new `GetBucketPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The bucket name for which to get the bucket policy.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The bucket name for which to get the bucket policy.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketPolicyStatus`.
    ///
    /// <p>Retrieves the policy status for an Amazon S3 bucket, indicating whether the bucket is public. In order to use this operation, you must have the <code>s3:GetBucketPolicyStatus</code> permission. For more information about Amazon S3 permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying Permissions in a Policy</a>.</p>
    /// <p> For more information about when Amazon S3 considers a bucket public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a>. </p>
    /// <p>The following operations are related to <code>GetBucketPolicyStatus</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html">Using Amazon S3 Block Public Access</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetPublicAccessBlock.html">GetPublicAccessBlock</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutPublicAccessBlock.html">PutPublicAccessBlock</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeletePublicAccessBlock.html">DeletePublicAccessBlock</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBucketPolicyStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_bucket_policy_status_input::Builder,
    }
    impl GetBucketPolicyStatus {
        /// Creates a new `GetBucketPolicyStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketPolicyStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketPolicyStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon S3 bucket whose policy status you want to retrieve.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket whose policy status you want to retrieve.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketReplication`.
    ///
    /// <p>Returns the replication configuration of a bucket.</p> <note>
    /// <p> It can take a while to propagate the put or delete a replication configuration to all Amazon S3 systems. Therefore, a get request soon after put or delete can return a wrong result. </p>
    /// </note>
    /// <p> For information about replication configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html">Replication</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>This action requires permissions for the <code>s3:GetReplicationConfiguration</code> action. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html">Using Bucket Policies and User Policies</a>.</p>
    /// <p>If you include the <code>Filter</code> element in a replication configuration, you must also include the <code>DeleteMarkerReplication</code> and <code>Priority</code> elements. The response also returns those elements.</p>
    /// <p>For information about <code>GetBucketReplication</code> errors, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ReplicationErrorCodeList">List of replication-related error codes</a> </p>
    /// <p>The following operations are related to <code>GetBucketReplication</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketReplication.html">PutBucketReplication</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketReplication.html">DeleteBucketReplication</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBucketReplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_bucket_replication_input::Builder,
    }
    impl GetBucketReplication {
        /// Creates a new `GetBucketReplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketReplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketReplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The bucket name for which to get the replication information.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The bucket name for which to get the replication information.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketRequestPayment`.
    ///
    /// <p>Returns the request payment configuration of a bucket. To use this version of the operation, you must be the bucket owner. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a>.</p>
    /// <p>The following operations are related to <code>GetBucketRequestPayment</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html">ListObjects</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBucketRequestPayment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_bucket_request_payment_input::Builder,
    }
    impl GetBucketRequestPayment {
        /// Creates a new `GetBucketRequestPayment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketRequestPaymentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketRequestPaymentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket for which to get the payment request configuration</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket for which to get the payment request configuration</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketTagging`.
    ///
    /// <p>Returns the tag set associated with the bucket.</p>
    /// <p>To use this operation, you must have permission to perform the <code>s3:GetBucketTagging</code> action. By default, the bucket owner has this permission and can grant this permission to others.</p>
    /// <p> <code>GetBucketTagging</code> has the following special error:</p>
    /// <ul>
    /// <li> <p>Error code: <code>NoSuchTagSetError</code> </p>
    /// <ul>
    /// <li> <p>Description: There is no tag set associated with the bucket.</p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p>The following operations are related to <code>GetBucketTagging</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketTagging.html">PutBucketTagging</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketTagging.html">DeleteBucketTagging</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBucketTagging {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_bucket_tagging_input::Builder,
    }
    impl GetBucketTagging {
        /// Creates a new `GetBucketTagging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketTaggingOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketTaggingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket for which to get the tagging information.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket for which to get the tagging information.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketVersioning`.
    ///
    /// <p>Returns the versioning state of a bucket.</p>
    /// <p>To retrieve the versioning state of a bucket, you must be the bucket owner.</p>
    /// <p>This implementation also returns the MFA Delete status of the versioning state. If the MFA Delete status is <code>enabled</code>, the bucket owner must use an authentication device to change the versioning state of the bucket.</p>
    /// <p>The following operations are related to <code>GetBucketVersioning</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html">DeleteObject</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBucketVersioning {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_bucket_versioning_input::Builder,
    }
    impl GetBucketVersioning {
        /// Creates a new `GetBucketVersioning`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketVersioningOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketVersioningError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket for which to get the versioning information.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket for which to get the versioning information.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketWebsite`.
    ///
    /// <p>Returns the website configuration for a bucket. To host website on Amazon S3, you can configure a bucket as website by adding a website configuration. For more information about hosting websites, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">Hosting Websites on Amazon S3</a>. </p>
    /// <p>This GET action requires the <code>S3:GetBucketWebsite</code> permission. By default, only the bucket owner can read the bucket website configuration. However, bucket owners can allow other users to read the website configuration by writing a bucket policy granting them the <code>S3:GetBucketWebsite</code> permission.</p>
    /// <p>The following operations are related to <code>DeleteBucketWebsite</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketWebsite.html">DeleteBucketWebsite</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketWebsite.html">PutBucketWebsite</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBucketWebsite {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_bucket_website_input::Builder,
    }
    impl GetBucketWebsite {
        /// Creates a new `GetBucketWebsite`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketWebsiteOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketWebsiteError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The bucket name for which to get the website configuration.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The bucket name for which to get the website configuration.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetObject`.
    ///
    /// <p>Retrieves objects from Amazon S3. To use <code>GET</code>, you must have <code>READ</code> access to the object. If you grant <code>READ</code> access to the anonymous user, you can return the object without using an authorization header.</p>
    /// <p>An Amazon S3 bucket has no directory hierarchy such as you would find in a typical computer file system. You can, however, create a logical hierarchy by using object key names that imply a folder structure. For example, instead of naming an object <code>sample.jpg</code>, you can name it <code>photos/2006/February/sample.jpg</code>.</p>
    /// <p>To get an object from such a logical hierarchy, specify the full key name for the object in the <code>GET</code> operation. For a virtual hosted-style request example, if you have the object <code>photos/2006/February/sample.jpg</code>, specify the resource as <code>/photos/2006/February/sample.jpg</code>. For a path-style request example, if you have the object <code>photos/2006/February/sample.jpg</code> in the bucket named <code>examplebucket</code>, specify the resource as <code>/examplebucket/photos/2006/February/sample.jpg</code>. For more information about request types, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/VirtualHosting.html#VirtualHostingSpecifyBucket">HTTP Host Header Bucket Specification</a>.</p>
    /// <p>To distribute large files to many people, you can save bandwidth costs by using BitTorrent. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/S3Torrent.html">Amazon S3 Torrent</a>. For more information about returning the ACL of an object, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html">GetObjectAcl</a>.</p>
    /// <p>If the object you are retrieving is stored in the S3 Glacier or S3 Glacier Deep Archive storage class, or S3 Intelligent-Tiering Archive or S3 Intelligent-Tiering Deep Archive tiers, before you can retrieve the object you must first restore a copy using <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html">RestoreObject</a>. Otherwise, this action returns an <code>InvalidObjectStateError</code> error. For information about restoring archived objects, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html">Restoring Archived Objects</a>.</p>
    /// <p>Encryption request headers, like <code>x-amz-server-side-encryption</code>, should not be sent for GET requests if your object uses server-side encryption with KMS keys (SSE-KMS) or server-side encryption with Amazon S3–managed encryption keys (SSE-S3). If your object does use these types of keys, you’ll get an HTTP 400 BadRequest error.</p>
    /// <p>If you encrypt an object by using server-side encryption with customer-provided encryption keys (SSE-C) when you store the object in Amazon S3, then when you GET the object, you must use the following headers:</p>
    /// <ul>
    /// <li> <p>x-amz-server-side-encryption-customer-algorithm</p> </li>
    /// <li> <p>x-amz-server-side-encryption-customer-key</p> </li>
    /// <li> <p>x-amz-server-side-encryption-customer-key-MD5</p> </li>
    /// </ul>
    /// <p>For more information about SSE-C, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html">Server-Side Encryption (Using Customer-Provided Encryption Keys)</a>.</p>
    /// <p>Assuming you have the relevant permission to read object tags, the response also returns the <code>x-amz-tagging-count</code> header that provides the count of number of tags associated with the object. You can use <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectTagging.html">GetObjectTagging</a> to retrieve the tag set associated with an object.</p>
    /// <p> <b>Permissions</b> </p>
    /// <p>You need the relevant read object (or version) permission for this operation. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying Permissions in a Policy</a>. If the object you request does not exist, the error Amazon S3 returns depends on whether you also have the <code>s3:ListBucket</code> permission.</p>
    /// <ul>
    /// <li> <p>If you have the <code>s3:ListBucket</code> permission on the bucket, Amazon S3 will return an HTTP status code 404 ("no such key") error.</p> </li>
    /// <li> <p>If you don’t have the <code>s3:ListBucket</code> permission, Amazon S3 will return an HTTP status code 403 ("access denied") error.</p> </li>
    /// </ul>
    /// <p> <b>Versioning</b> </p>
    /// <p>By default, the GET action returns the current version of an object. To return a different version, use the <code>versionId</code> subresource.</p> <note>
    /// <ul>
    /// <li> <p> If you supply a <code>versionId</code>, you need the <code>s3:GetObjectVersion</code> permission to access a specific version of an object. If you request a specific version, you do not need to have the <code>s3:GetObject</code> permission. </p> </li>
    /// <li> <p>If the current version of the object is a delete marker, Amazon S3 behaves as if the object was deleted and includes <code>x-amz-delete-marker: true</code> in the response.</p> </li>
    /// </ul>
    /// </note>
    /// <p>For more information about versioning, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketVersioning.html">PutBucketVersioning</a>. </p>
    /// <p> <b>Overriding Response Header Values</b> </p>
    /// <p>There are times when you want to override certain response header values in a GET response. For example, you might override the Content-Disposition response header value in your GET request.</p>
    /// <p>You can override values for a set of response headers using the following query parameters. These response header values are sent only on a successful request, that is, when status code 200 OK is returned. The set of headers you can override using these parameters is a subset of the headers that Amazon S3 accepts when you create an object. The response headers that you can override for the GET response are <code>Content-Type</code>, <code>Content-Language</code>, <code>Expires</code>, <code>Cache-Control</code>, <code>Content-Disposition</code>, and <code>Content-Encoding</code>. To override these header values in the GET response, you use the following request parameters.</p> <note>
    /// <p>You must sign the request, either using an Authorization header or a presigned URL, when using these parameters. They cannot be used with an unsigned (anonymous) request.</p>
    /// </note>
    /// <ul>
    /// <li> <p> <code>response-content-type</code> </p> </li>
    /// <li> <p> <code>response-content-language</code> </p> </li>
    /// <li> <p> <code>response-expires</code> </p> </li>
    /// <li> <p> <code>response-cache-control</code> </p> </li>
    /// <li> <p> <code>response-content-disposition</code> </p> </li>
    /// <li> <p> <code>response-content-encoding</code> </p> </li>
    /// </ul>
    /// <p> <b>Additional Considerations about Request Headers</b> </p>
    /// <p>If both of the <code>If-Match</code> and <code>If-Unmodified-Since</code> headers are present in the request as follows: <code>If-Match</code> condition evaluates to <code>true</code>, and; <code>If-Unmodified-Since</code> condition evaluates to <code>false</code>; then, S3 returns 200 OK and the data requested. </p>
    /// <p>If both of the <code>If-None-Match</code> and <code>If-Modified-Since</code> headers are present in the request as follows:<code> If-None-Match</code> condition evaluates to <code>false</code>, and; <code>If-Modified-Since</code> condition evaluates to <code>true</code>; then, S3 returns 304 Not Modified response code.</p>
    /// <p>For more information about conditional requests, see <a href="https://tools.ietf.org/html/rfc7232">RFC 7232</a>.</p>
    /// <p>The following operations are related to <code>GetObject</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBuckets.html">ListBuckets</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html">GetObjectAcl</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetObject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_object_input::Builder,
    }
    impl GetObject {
        /// Creates a new `GetObject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetObjectOutput,
            aws_smithy_http::result::SdkError<crate::error::GetObjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        ///
        /// Creates a presigned request for this operation.
        ///
        /// The `presigning_config` provides additional presigning-specific config values, such as the
        /// amount of time the request should be valid for after creation.
        ///
        /// Presigned requests can be given to other users or applications to access a resource or perform
        /// an operation without having access to the AWS security credentials.
        ///
        pub async fn presigned(
            self,
            presigning_config: crate::presigning::config::PresigningConfig,
        ) -> Result<
            crate::presigning::request::PresignedRequest,
            aws_smithy_http::result::SdkError<crate::error::GetObjectError>,
        > {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            input.presigned(&self.handle.conf, presigning_config).await
        }
        /// <p>The bucket name containing the object. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using an Object Lambda access point the hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-object-lambda.<i>Region</i>.amazonaws.com.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The bucket name containing the object. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using an Object Lambda access point the hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-object-lambda.<i>Region</i>.amazonaws.com.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>Return the object only if its entity tag (ETag) is the same as the one specified, otherwise return a 412 (precondition failed).</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(input.into());
            self
        }
        /// <p>Return the object only if its entity tag (ETag) is the same as the one specified, otherwise return a 412 (precondition failed).</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
        /// <p>Return the object only if it has been modified since the specified time, otherwise return a 304 (not modified).</p>
        pub fn if_modified_since(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.if_modified_since(input);
            self
        }
        /// <p>Return the object only if it has been modified since the specified time, otherwise return a 304 (not modified).</p>
        pub fn set_if_modified_since(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_if_modified_since(input);
            self
        }
        /// <p>Return the object only if its entity tag (ETag) is different from the one specified, otherwise return a 304 (not modified).</p>
        pub fn if_none_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_none_match(input.into());
            self
        }
        /// <p>Return the object only if its entity tag (ETag) is different from the one specified, otherwise return a 304 (not modified).</p>
        pub fn set_if_none_match(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_if_none_match(input);
            self
        }
        /// <p>Return the object only if it has not been modified since the specified time, otherwise return a 412 (precondition failed).</p>
        pub fn if_unmodified_since(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.if_unmodified_since(input);
            self
        }
        /// <p>Return the object only if it has not been modified since the specified time, otherwise return a 412 (precondition failed).</p>
        pub fn set_if_unmodified_since(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_if_unmodified_since(input);
            self
        }
        /// <p>Key of the object to get.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key(input.into());
            self
        }
        /// <p>Key of the object to get.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key(input);
            self
        }
        /// <p>Downloads the specified range bytes of an object. For more information about the HTTP Range header, see <a href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35">https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35</a>.</p> <note>
        /// <p>Amazon S3 doesn't support retrieving multiple ranges of data per <code>GET</code> request.</p>
        /// </note>
        pub fn range(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.range(input.into());
            self
        }
        /// <p>Downloads the specified range bytes of an object. For more information about the HTTP Range header, see <a href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35">https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35</a>.</p> <note>
        /// <p>Amazon S3 doesn't support retrieving multiple ranges of data per <code>GET</code> request.</p>
        /// </note>
        pub fn set_range(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_range(input);
            self
        }
        /// <p>Sets the <code>Cache-Control</code> header of the response.</p>
        pub fn response_cache_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.response_cache_control(input.into());
            self
        }
        /// <p>Sets the <code>Cache-Control</code> header of the response.</p>
        pub fn set_response_cache_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_response_cache_control(input);
            self
        }
        /// <p>Sets the <code>Content-Disposition</code> header of the response</p>
        pub fn response_content_disposition(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.response_content_disposition(input.into());
            self
        }
        /// <p>Sets the <code>Content-Disposition</code> header of the response</p>
        pub fn set_response_content_disposition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_response_content_disposition(input);
            self
        }
        /// <p>Sets the <code>Content-Encoding</code> header of the response.</p>
        pub fn response_content_encoding(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.response_content_encoding(input.into());
            self
        }
        /// <p>Sets the <code>Content-Encoding</code> header of the response.</p>
        pub fn set_response_content_encoding(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_response_content_encoding(input);
            self
        }
        /// <p>Sets the <code>Content-Language</code> header of the response.</p>
        pub fn response_content_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.response_content_language(input.into());
            self
        }
        /// <p>Sets the <code>Content-Language</code> header of the response.</p>
        pub fn set_response_content_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_response_content_language(input);
            self
        }
        /// <p>Sets the <code>Content-Type</code> header of the response.</p>
        pub fn response_content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.response_content_type(input.into());
            self
        }
        /// <p>Sets the <code>Content-Type</code> header of the response.</p>
        pub fn set_response_content_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_response_content_type(input);
            self
        }
        /// <p>Sets the <code>Expires</code> header of the response.</p>
        pub fn response_expires(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.response_expires(input);
            self
        }
        /// <p>Sets the <code>Expires</code> header of the response.</p>
        pub fn set_response_expires(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_response_expires(input);
            self
        }
        /// <p>VersionId used to reference a specific version of the object.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(input.into());
            self
        }
        /// <p>VersionId used to reference a specific version of the object.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
        /// <p>Specifies the algorithm to use to when decrypting the object (for example, AES256).</p>
        pub fn sse_customer_algorithm(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sse_customer_algorithm(input.into());
            self
        }
        /// <p>Specifies the algorithm to use to when decrypting the object (for example, AES256).</p>
        pub fn set_sse_customer_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sse_customer_algorithm(input);
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 used to encrypt the data. This value is used to decrypt the object when recovering it and must match the one used when storing the data. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
        pub fn sse_customer_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sse_customer_key(input.into());
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 used to encrypt the data. This value is used to decrypt the object when recovering it and must match the one used when storing the data. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
        pub fn set_sse_customer_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sse_customer_key(input);
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn sse_customer_key_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sse_customer_key_md5(input.into());
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn set_sse_customer_key_md5(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sse_customer_key_md5(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.inner = self.inner.request_payer(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.inner = self.inner.set_request_payer(input);
            self
        }
        /// <p>Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a 'ranged' GET request for the part specified. Useful for downloading just a part of an object.</p>
        pub fn part_number(mut self, input: i32) -> Self {
            self.inner = self.inner.part_number(input);
            self
        }
        /// <p>Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a 'ranged' GET request for the part specified. Useful for downloading just a part of an object.</p>
        pub fn set_part_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_part_number(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetObjectAcl`.
    ///
    /// <p>Returns the access control list (ACL) of an object. To use this operation, you must have <code>READ_ACP</code> access to the object.</p>
    /// <p>This action is not supported by Amazon S3 on Outposts.</p>
    /// <p> <b>Versioning</b> </p>
    /// <p>By default, GET returns ACL information about the current version of an object. To return ACL information about a different version, use the versionId subresource.</p> <note>
    /// <p>If your bucket uses the bucket owner enforced setting for S3 Object Ownership, requests to read ACLs are still supported and return the <code>bucket-owner-full-control</code> ACL with the owner being the account that created the bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html"> Controlling object ownership and disabling ACLs</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// </note>
    /// <p>The following operations are related to <code>GetObjectAcl</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html">DeleteObject</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetObjectAcl {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_object_acl_input::Builder,
    }
    impl GetObjectAcl {
        /// Creates a new `GetObjectAcl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetObjectAclOutput,
            aws_smithy_http::result::SdkError<crate::error::GetObjectAclError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The bucket name that contains the object for which to get the ACL information. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The bucket name that contains the object for which to get the ACL information. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The key of the object for which to get the ACL information.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key(input.into());
            self
        }
        /// <p>The key of the object for which to get the ACL information.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key(input);
            self
        }
        /// <p>VersionId used to reference a specific version of the object.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(input.into());
            self
        }
        /// <p>VersionId used to reference a specific version of the object.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.inner = self.inner.request_payer(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.inner = self.inner.set_request_payer(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetObjectLegalHold`.
    ///
    /// <p>Gets an object's current Legal Hold status. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Locking Objects</a>.</p>
    /// <p>This action is not supported by Amazon S3 on Outposts.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetObjectLegalHold {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_object_legal_hold_input::Builder,
    }
    impl GetObjectLegalHold {
        /// Creates a new `GetObjectLegalHold`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetObjectLegalHoldOutput,
            aws_smithy_http::result::SdkError<crate::error::GetObjectLegalHoldError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The bucket name containing the object whose Legal Hold status you want to retrieve. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The bucket name containing the object whose Legal Hold status you want to retrieve. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The key name for the object whose Legal Hold status you want to retrieve.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key(input.into());
            self
        }
        /// <p>The key name for the object whose Legal Hold status you want to retrieve.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key(input);
            self
        }
        /// <p>The version ID of the object whose Legal Hold status you want to retrieve.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(input.into());
            self
        }
        /// <p>The version ID of the object whose Legal Hold status you want to retrieve.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.inner = self.inner.request_payer(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.inner = self.inner.set_request_payer(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetObjectLockConfiguration`.
    ///
    /// <p>Gets the Object Lock configuration for a bucket. The rule specified in the Object Lock configuration will be applied by default to every new object placed in the specified bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Locking Objects</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetObjectLockConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_object_lock_configuration_input::Builder,
    }
    impl GetObjectLockConfiguration {
        /// Creates a new `GetObjectLockConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetObjectLockConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetObjectLockConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The bucket whose Object Lock configuration you want to retrieve.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The bucket whose Object Lock configuration you want to retrieve.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetObjectRetention`.
    ///
    /// <p>Retrieves an object's retention settings. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html">Locking Objects</a>.</p>
    /// <p>This action is not supported by Amazon S3 on Outposts.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetObjectRetention {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_object_retention_input::Builder,
    }
    impl GetObjectRetention {
        /// Creates a new `GetObjectRetention`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetObjectRetentionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetObjectRetentionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The bucket name containing the object whose retention settings you want to retrieve. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The bucket name containing the object whose retention settings you want to retrieve. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The key name for the object whose retention settings you want to retrieve.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key(input.into());
            self
        }
        /// <p>The key name for the object whose retention settings you want to retrieve.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key(input);
            self
        }
        /// <p>The version ID for the object whose retention settings you want to retrieve.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(input.into());
            self
        }
        /// <p>The version ID for the object whose retention settings you want to retrieve.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.inner = self.inner.request_payer(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.inner = self.inner.set_request_payer(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetObjectTagging`.
    ///
    /// <p>Returns the tag-set of an object. You send the GET request against the tagging subresource associated with the object.</p>
    /// <p>To use this operation, you must have permission to perform the <code>s3:GetObjectTagging</code> action. By default, the GET action returns information about current version of an object. For a versioned bucket, you can have multiple versions of an object in your bucket. To retrieve tags of any other version, use the versionId query parameter. You also need permission for the <code>s3:GetObjectVersionTagging</code> action.</p>
    /// <p> By default, the bucket owner has this permission and can grant this permission to others.</p>
    /// <p> For information about the Amazon S3 object tagging feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-tagging.html">Object Tagging</a>.</p>
    /// <p>The following action is related to <code>GetObjectTagging</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectTagging.html">PutObjectTagging</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObjectTagging.html">DeleteObjectTagging</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetObjectTagging {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_object_tagging_input::Builder,
    }
    impl GetObjectTagging {
        /// Creates a new `GetObjectTagging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetObjectTaggingOutput,
            aws_smithy_http::result::SdkError<crate::error::GetObjectTaggingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The bucket name containing the object for which to get the tagging information. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The bucket name containing the object for which to get the tagging information. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>Object key for which to get the tagging information.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key(input.into());
            self
        }
        /// <p>Object key for which to get the tagging information.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key(input);
            self
        }
        /// <p>The versionId of the object for which to get the tagging information.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(input.into());
            self
        }
        /// <p>The versionId of the object for which to get the tagging information.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.inner = self.inner.request_payer(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.inner = self.inner.set_request_payer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetObjectTorrent`.
    ///
    /// <p>Returns torrent files from a bucket. BitTorrent can save you bandwidth when you're distributing large files. For more information about BitTorrent, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/S3Torrent.html">Using BitTorrent with Amazon S3</a>.</p> <note>
    /// <p>You can get torrent only for objects that are less than 5 GB in size, and that are not encrypted using server-side encryption with a customer-provided encryption key.</p>
    /// </note>
    /// <p>To use GET, you must have READ access to the object.</p>
    /// <p>This action is not supported by Amazon S3 on Outposts.</p>
    /// <p>The following action is related to <code>GetObjectTorrent</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetObjectTorrent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_object_torrent_input::Builder,
    }
    impl GetObjectTorrent {
        /// Creates a new `GetObjectTorrent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetObjectTorrentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetObjectTorrentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket containing the object for which to get the torrent files.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket containing the object for which to get the torrent files.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The object key for which to get the information.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key(input.into());
            self
        }
        /// <p>The object key for which to get the information.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.inner = self.inner.request_payer(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.inner = self.inner.set_request_payer(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPublicAccessBlock`.
    ///
    /// <p>Retrieves the <code>PublicAccessBlock</code> configuration for an Amazon S3 bucket. To use this operation, you must have the <code>s3:GetBucketPublicAccessBlock</code> permission. For more information about Amazon S3 permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying Permissions in a Policy</a>.</p> <important>
    /// <p>When Amazon S3 evaluates the <code>PublicAccessBlock</code> configuration for a bucket or an object, it checks the <code>PublicAccessBlock</code> configuration for both the bucket (or the bucket that contains the object) and the bucket owner's account. If the <code>PublicAccessBlock</code> settings are different between the bucket and the account, Amazon S3 uses the most restrictive combination of the bucket-level and account-level settings.</p>
    /// </important>
    /// <p>For more information about when Amazon S3 considers a bucket or an object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a>.</p>
    /// <p>The following operations are related to <code>GetPublicAccessBlock</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html">Using Amazon S3 Block Public Access</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutPublicAccessBlock.html">PutPublicAccessBlock</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetPublicAccessBlock.html">GetPublicAccessBlock</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeletePublicAccessBlock.html">DeletePublicAccessBlock</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPublicAccessBlock {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_public_access_block_input::Builder,
    }
    impl GetPublicAccessBlock {
        /// Creates a new `GetPublicAccessBlock`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPublicAccessBlockOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPublicAccessBlockError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon S3 bucket whose <code>PublicAccessBlock</code> configuration you want to retrieve. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket whose <code>PublicAccessBlock</code> configuration you want to retrieve. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `HeadBucket`.
    ///
    /// <p>This action is useful to determine if a bucket exists and you have permission to access it. The action returns a <code>200 OK</code> if the bucket exists and you have permission to access it.</p>
    /// <p>If the bucket does not exist or you do not have permission to access it, the <code>HEAD</code> request returns a generic <code>404 Not Found</code> or <code>403 Forbidden</code> code. A message body is not included, so you cannot determine the exception beyond these error codes.</p>
    /// <p>To use this operation, you must have permissions to perform the <code>s3:ListBucket</code> action. The bucket owner has this permission by default and can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p>
    /// <p>To use this API against an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com. When using the Amazon Web Services SDKs, you provide the ARN in place of the bucket name. For more information see, <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct HeadBucket {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::head_bucket_input::Builder,
    }
    impl HeadBucket {
        /// Creates a new `HeadBucket`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::HeadBucketOutput,
            aws_smithy_http::result::SdkError<crate::error::HeadBucketError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The bucket name.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The bucket name.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `HeadObject`.
    ///
    /// <p>The HEAD action retrieves metadata from an object without returning the object itself. This action is useful if you're only interested in an object's metadata. To use HEAD, you must have READ access to the object.</p>
    /// <p>A <code>HEAD</code> request has the same options as a <code>GET</code> action on an object. The response is identical to the <code>GET</code> response except that there is no response body. Because of this, if the <code>HEAD</code> request generates an error, it returns a generic <code>404 Not Found</code> or <code>403 Forbidden</code> code. It is not possible to retrieve the exact exception beyond these error codes.</p>
    /// <p>If you encrypt an object by using server-side encryption with customer-provided encryption keys (SSE-C) when you store the object in Amazon S3, then when you retrieve the metadata from the object, you must use the following headers:</p>
    /// <ul>
    /// <li> <p>x-amz-server-side-encryption-customer-algorithm</p> </li>
    /// <li> <p>x-amz-server-side-encryption-customer-key</p> </li>
    /// <li> <p>x-amz-server-side-encryption-customer-key-MD5</p> </li>
    /// </ul>
    /// <p>For more information about SSE-C, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html">Server-Side Encryption (Using Customer-Provided Encryption Keys)</a>.</p> <note>
    /// <ul>
    /// <li> <p>Encryption request headers, like <code>x-amz-server-side-encryption</code>, should not be sent for GET requests if your object uses server-side encryption with KMS keys (SSE-KMS) or server-side encryption with Amazon S3–managed encryption keys (SSE-S3). If your object does use these types of keys, you’ll get an HTTP 400 BadRequest error.</p> </li>
    /// <li> <p> The last modified property in this case is the creation date of the object.</p> </li>
    /// </ul>
    /// </note>
    /// <p>Request headers are limited to 8 KB in size. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTCommonRequestHeaders.html">Common Request Headers</a>.</p>
    /// <p>Consider the following when using request headers:</p>
    /// <ul>
    /// <li> <p> Consideration 1 – If both of the <code>If-Match</code> and <code>If-Unmodified-Since</code> headers are present in the request as follows:</p>
    /// <ul>
    /// <li> <p> <code>If-Match</code> condition evaluates to <code>true</code>, and;</p> </li>
    /// <li> <p> <code>If-Unmodified-Since</code> condition evaluates to <code>false</code>;</p> </li>
    /// </ul> <p>Then Amazon S3 returns <code>200 OK</code> and the data requested.</p> </li>
    /// <li> <p> Consideration 2 – If both of the <code>If-None-Match</code> and <code>If-Modified-Since</code> headers are present in the request as follows:</p>
    /// <ul>
    /// <li> <p> <code>If-None-Match</code> condition evaluates to <code>false</code>, and;</p> </li>
    /// <li> <p> <code>If-Modified-Since</code> condition evaluates to <code>true</code>;</p> </li>
    /// </ul> <p>Then Amazon S3 returns the <code>304 Not Modified</code> response code.</p> </li>
    /// </ul>
    /// <p>For more information about conditional requests, see <a href="https://tools.ietf.org/html/rfc7232">RFC 7232</a>.</p>
    /// <p> <b>Permissions</b> </p>
    /// <p>You need the relevant read object (or version) permission for this operation. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying Permissions in a Policy</a>. If the object you request does not exist, the error Amazon S3 returns depends on whether you also have the s3:ListBucket permission.</p>
    /// <ul>
    /// <li> <p>If you have the <code>s3:ListBucket</code> permission on the bucket, Amazon S3 returns an HTTP status code 404 ("no such key") error.</p> </li>
    /// <li> <p>If you don’t have the <code>s3:ListBucket</code> permission, Amazon S3 returns an HTTP status code 403 ("access denied") error.</p> </li>
    /// </ul>
    /// <p>The following action is related to <code>HeadObject</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct HeadObject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::head_object_input::Builder,
    }
    impl HeadObject {
        /// Creates a new `HeadObject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::HeadObjectOutput,
            aws_smithy_http::result::SdkError<crate::error::HeadObjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket containing the object.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket containing the object.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>Return the object only if its entity tag (ETag) is the same as the one specified, otherwise return a 412 (precondition failed).</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_match(input.into());
            self
        }
        /// <p>Return the object only if its entity tag (ETag) is the same as the one specified, otherwise return a 412 (precondition failed).</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_if_match(input);
            self
        }
        /// <p>Return the object only if it has been modified since the specified time, otherwise return a 304 (not modified).</p>
        pub fn if_modified_since(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.if_modified_since(input);
            self
        }
        /// <p>Return the object only if it has been modified since the specified time, otherwise return a 304 (not modified).</p>
        pub fn set_if_modified_since(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_if_modified_since(input);
            self
        }
        /// <p>Return the object only if its entity tag (ETag) is different from the one specified, otherwise return a 304 (not modified).</p>
        pub fn if_none_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.if_none_match(input.into());
            self
        }
        /// <p>Return the object only if its entity tag (ETag) is different from the one specified, otherwise return a 304 (not modified).</p>
        pub fn set_if_none_match(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_if_none_match(input);
            self
        }
        /// <p>Return the object only if it has not been modified since the specified time, otherwise return a 412 (precondition failed).</p>
        pub fn if_unmodified_since(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.if_unmodified_since(input);
            self
        }
        /// <p>Return the object only if it has not been modified since the specified time, otherwise return a 412 (precondition failed).</p>
        pub fn set_if_unmodified_since(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_if_unmodified_since(input);
            self
        }
        /// <p>The object key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key(input.into());
            self
        }
        /// <p>The object key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key(input);
            self
        }
        /// <p>Because <code>HeadObject</code> returns only the metadata for an object, this parameter has no effect.</p>
        pub fn range(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.range(input.into());
            self
        }
        /// <p>Because <code>HeadObject</code> returns only the metadata for an object, this parameter has no effect.</p>
        pub fn set_range(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_range(input);
            self
        }
        /// <p>VersionId used to reference a specific version of the object.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(input.into());
            self
        }
        /// <p>VersionId used to reference a specific version of the object.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
        /// <p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>
        pub fn sse_customer_algorithm(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sse_customer_algorithm(input.into());
            self
        }
        /// <p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>
        pub fn set_sse_customer_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sse_customer_algorithm(input);
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
        pub fn sse_customer_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sse_customer_key(input.into());
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
        pub fn set_sse_customer_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sse_customer_key(input);
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn sse_customer_key_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sse_customer_key_md5(input.into());
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn set_sse_customer_key_md5(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sse_customer_key_md5(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.inner = self.inner.request_payer(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.inner = self.inner.set_request_payer(input);
            self
        }
        /// <p>Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a 'ranged' HEAD request for the part specified. Useful querying about the size of the part and the number of parts in this object.</p>
        pub fn part_number(mut self, input: i32) -> Self {
            self.inner = self.inner.part_number(input);
            self
        }
        /// <p>Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a 'ranged' HEAD request for the part specified. Useful querying about the size of the part and the number of parts in this object.</p>
        pub fn set_part_number(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_part_number(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBucketAnalyticsConfigurations`.
    ///
    /// <p>Lists the analytics configurations for the bucket. You can have up to 1,000 analytics configurations per bucket.</p>
    /// <p>This action supports list pagination and does not return more than 100 configurations at a time. You should always check the <code>IsTruncated</code> element in the response. If there are no more configurations to list, <code>IsTruncated</code> is set to false. If there are more configurations to list, <code>IsTruncated</code> is set to true, and there will be a value in <code>NextContinuationToken</code>. You use the <code>NextContinuationToken</code> value to continue the pagination of the list by passing the value in continuation-token in the request to <code>GET</code> the next page.</p>
    /// <p>To use this operation, you must have permissions to perform the <code>s3:GetAnalyticsConfiguration</code> action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p>
    /// <p>For information about Amazon S3 analytics feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/analytics-storage-class.html">Amazon S3 Analytics – Storage Class Analysis</a>. </p>
    /// <p>The following operations are related to <code>ListBucketAnalyticsConfigurations</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketAnalyticsConfiguration.html">GetBucketAnalyticsConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketAnalyticsConfiguration.html">DeleteBucketAnalyticsConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAnalyticsConfiguration.html">PutBucketAnalyticsConfiguration</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBucketAnalyticsConfigurations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_bucket_analytics_configurations_input::Builder,
    }
    impl ListBucketAnalyticsConfigurations {
        /// Creates a new `ListBucketAnalyticsConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBucketAnalyticsConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBucketAnalyticsConfigurationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket from which analytics configurations are retrieved.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket from which analytics configurations are retrieved.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The ContinuationToken that represents a placeholder from where this request should begin.</p>
        pub fn continuation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.continuation_token(input.into());
            self
        }
        /// <p>The ContinuationToken that represents a placeholder from where this request should begin.</p>
        pub fn set_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_continuation_token(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBucketIntelligentTieringConfigurations`.
    ///
    /// <p>Lists the S3 Intelligent-Tiering configuration from the specified bucket.</p>
    /// <p>The S3 Intelligent-Tiering storage class is designed to optimize storage costs by automatically moving data to the most cost-effective storage access tier, without performance impact or operational overhead. S3 Intelligent-Tiering delivers automatic cost savings in three low latency and high throughput access tiers. To get the lowest storage cost on data that can be accessed in minutes to hours, you can choose to activate additional archiving capabilities.</p>
    /// <p>The S3 Intelligent-Tiering storage class is the ideal storage class for data with unknown, changing, or unpredictable access patterns, independent of object size or retention period. If the size of an object is less than 128 KB, it is not monitored and not eligible for auto-tiering. Smaller objects can be stored, but they are always charged at the Frequent Access tier rates in the S3 Intelligent-Tiering storage class.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access">Storage class for automatically optimizing frequently and infrequently accessed objects</a>.</p>
    /// <p>Operations related to <code>ListBucketIntelligentTieringConfigurations</code> include: </p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketIntelligentTieringConfiguration.html">DeleteBucketIntelligentTieringConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketIntelligentTieringConfiguration.html">PutBucketIntelligentTieringConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketIntelligentTieringConfiguration.html">GetBucketIntelligentTieringConfiguration</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBucketIntelligentTieringConfigurations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_bucket_intelligent_tiering_configurations_input::Builder,
    }
    impl ListBucketIntelligentTieringConfigurations {
        /// Creates a new `ListBucketIntelligentTieringConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBucketIntelligentTieringConfigurationsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListBucketIntelligentTieringConfigurationsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon S3 bucket whose configuration you want to modify or retrieve.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket whose configuration you want to modify or retrieve.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The ContinuationToken that represents a placeholder from where this request should begin.</p>
        pub fn continuation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.continuation_token(input.into());
            self
        }
        /// <p>The ContinuationToken that represents a placeholder from where this request should begin.</p>
        pub fn set_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_continuation_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBucketInventoryConfigurations`.
    ///
    /// <p>Returns a list of inventory configurations for the bucket. You can have up to 1,000 analytics configurations per bucket.</p>
    /// <p>This action supports list pagination and does not return more than 100 configurations at a time. Always check the <code>IsTruncated</code> element in the response. If there are no more configurations to list, <code>IsTruncated</code> is set to false. If there are more configurations to list, <code>IsTruncated</code> is set to true, and there is a value in <code>NextContinuationToken</code>. You use the <code>NextContinuationToken</code> value to continue the pagination of the list by passing the value in continuation-token in the request to <code>GET</code> the next page.</p>
    /// <p> To use this operation, you must have permissions to perform the <code>s3:GetInventoryConfiguration</code> action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p>
    /// <p>For information about the Amazon S3 inventory feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html">Amazon S3 Inventory</a> </p>
    /// <p>The following operations are related to <code>ListBucketInventoryConfigurations</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketInventoryConfiguration.html">GetBucketInventoryConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketInventoryConfiguration.html">DeleteBucketInventoryConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketInventoryConfiguration.html">PutBucketInventoryConfiguration</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBucketInventoryConfigurations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_bucket_inventory_configurations_input::Builder,
    }
    impl ListBucketInventoryConfigurations {
        /// Creates a new `ListBucketInventoryConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBucketInventoryConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBucketInventoryConfigurationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket containing the inventory configurations to retrieve.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket containing the inventory configurations to retrieve.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The marker used to continue an inventory configuration listing that has been truncated. Use the NextContinuationToken from a previously truncated list response to continue the listing. The continuation token is an opaque value that Amazon S3 understands.</p>
        pub fn continuation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.continuation_token(input.into());
            self
        }
        /// <p>The marker used to continue an inventory configuration listing that has been truncated. Use the NextContinuationToken from a previously truncated list response to continue the listing. The continuation token is an opaque value that Amazon S3 understands.</p>
        pub fn set_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_continuation_token(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBucketMetricsConfigurations`.
    ///
    /// <p>Lists the metrics configurations for the bucket. The metrics configurations are only for the request metrics of the bucket and do not provide information on daily storage metrics. You can have up to 1,000 configurations per bucket.</p>
    /// <p>This action supports list pagination and does not return more than 100 configurations at a time. Always check the <code>IsTruncated</code> element in the response. If there are no more configurations to list, <code>IsTruncated</code> is set to false. If there are more configurations to list, <code>IsTruncated</code> is set to true, and there is a value in <code>NextContinuationToken</code>. You use the <code>NextContinuationToken</code> value to continue the pagination of the list by passing the value in <code>continuation-token</code> in the request to <code>GET</code> the next page.</p>
    /// <p>To use this operation, you must have permissions to perform the <code>s3:GetMetricsConfiguration</code> action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p>
    /// <p>For more information about metrics configurations and CloudWatch request metrics, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html">Monitoring Metrics with Amazon CloudWatch</a>.</p>
    /// <p>The following operations are related to <code>ListBucketMetricsConfigurations</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketMetricsConfiguration.html">PutBucketMetricsConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketMetricsConfiguration.html">GetBucketMetricsConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketMetricsConfiguration.html">DeleteBucketMetricsConfiguration</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBucketMetricsConfigurations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_bucket_metrics_configurations_input::Builder,
    }
    impl ListBucketMetricsConfigurations {
        /// Creates a new `ListBucketMetricsConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBucketMetricsConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBucketMetricsConfigurationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket containing the metrics configurations to retrieve.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket containing the metrics configurations to retrieve.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The marker that is used to continue a metrics configuration listing that has been truncated. Use the NextContinuationToken from a previously truncated list response to continue the listing. The continuation token is an opaque value that Amazon S3 understands.</p>
        pub fn continuation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.continuation_token(input.into());
            self
        }
        /// <p>The marker that is used to continue a metrics configuration listing that has been truncated. Use the NextContinuationToken from a previously truncated list response to continue the listing. The continuation token is an opaque value that Amazon S3 understands.</p>
        pub fn set_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_continuation_token(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBuckets`.
    ///
    /// <p>Returns a list of all buckets owned by the authenticated sender of the request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBuckets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_buckets_input::Builder,
    }
    impl ListBuckets {
        /// Creates a new `ListBuckets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBucketsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBucketsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListMultipartUploads`.
    ///
    /// <p>This action lists in-progress multipart uploads. An in-progress multipart upload is a multipart upload that has been initiated using the Initiate Multipart Upload request, but has not yet been completed or aborted.</p>
    /// <p>This action returns at most 1,000 multipart uploads in the response. 1,000 multipart uploads is the maximum number of uploads a response can include, which is also the default value. You can further limit the number of uploads in a response by specifying the <code>max-uploads</code> parameter in the response. If additional multipart uploads satisfy the list criteria, the response will contain an <code>IsTruncated</code> element with the value true. To list the additional multipart uploads, use the <code>key-marker</code> and <code>upload-id-marker</code> request parameters.</p>
    /// <p>In the response, the uploads are sorted by key. If your application has initiated more than one multipart upload using the same object key, then uploads in the response are first sorted by key. Additionally, uploads are sorted in ascending order within each key by the upload initiation time.</p>
    /// <p>For more information on multipart uploads, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/uploadobjusingmpu.html">Uploading Objects Using Multipart Upload</a>.</p>
    /// <p>For information on permissions required to use the multipart upload API, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html">Multipart Upload and Permissions</a>.</p>
    /// <p>The following operations are related to <code>ListMultipartUploads</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html">CreateMultipartUpload</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html">CompleteMultipartUpload</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html">ListParts</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html">AbortMultipartUpload</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListMultipartUploads {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_multipart_uploads_input::Builder,
    }
    impl ListMultipartUploads {
        /// Creates a new `ListMultipartUploads`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMultipartUploadsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMultipartUploadsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket to which the multipart upload was initiated. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket to which the multipart upload was initiated. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>Character you use to group keys.</p>
        /// <p>All keys that contain the same string between the prefix, if specified, and the first occurrence of the delimiter after the prefix are grouped under a single result element, <code>CommonPrefixes</code>. If you don't specify the prefix parameter, then the substring starts at the beginning of the key. The keys that are grouped under <code>CommonPrefixes</code> result element are not returned elsewhere in the response.</p>
        pub fn delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delimiter(input.into());
            self
        }
        /// <p>Character you use to group keys.</p>
        /// <p>All keys that contain the same string between the prefix, if specified, and the first occurrence of the delimiter after the prefix are grouped under a single result element, <code>CommonPrefixes</code>. If you don't specify the prefix parameter, then the substring starts at the beginning of the key. The keys that are grouped under <code>CommonPrefixes</code> result element are not returned elsewhere in the response.</p>
        pub fn set_delimiter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_delimiter(input);
            self
        }
        /// <p>Requests Amazon S3 to encode the object keys in the response and specifies the encoding method to use. An object key may contain any Unicode character; however, XML 1.0 parser cannot parse some characters, such as characters with an ASCII value from 0 to 10. For characters that are not supported in XML 1.0, you can add this parameter to request that Amazon S3 encode the keys in the response.</p>
        pub fn encoding_type(mut self, input: crate::model::EncodingType) -> Self {
            self.inner = self.inner.encoding_type(input);
            self
        }
        /// <p>Requests Amazon S3 to encode the object keys in the response and specifies the encoding method to use. An object key may contain any Unicode character; however, XML 1.0 parser cannot parse some characters, such as characters with an ASCII value from 0 to 10. For characters that are not supported in XML 1.0, you can add this parameter to request that Amazon S3 encode the keys in the response.</p>
        pub fn set_encoding_type(
            mut self,
            input: std::option::Option<crate::model::EncodingType>,
        ) -> Self {
            self.inner = self.inner.set_encoding_type(input);
            self
        }
        /// <p>Together with upload-id-marker, this parameter specifies the multipart upload after which listing should begin.</p>
        /// <p>If <code>upload-id-marker</code> is not specified, only the keys lexicographically greater than the specified <code>key-marker</code> will be included in the list.</p>
        /// <p>If <code>upload-id-marker</code> is specified, any multipart uploads for a key equal to the <code>key-marker</code> might also be included, provided those multipart uploads have upload IDs lexicographically greater than the specified <code>upload-id-marker</code>.</p>
        pub fn key_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_marker(input.into());
            self
        }
        /// <p>Together with upload-id-marker, this parameter specifies the multipart upload after which listing should begin.</p>
        /// <p>If <code>upload-id-marker</code> is not specified, only the keys lexicographically greater than the specified <code>key-marker</code> will be included in the list.</p>
        /// <p>If <code>upload-id-marker</code> is specified, any multipart uploads for a key equal to the <code>key-marker</code> might also be included, provided those multipart uploads have upload IDs lexicographically greater than the specified <code>upload-id-marker</code>.</p>
        pub fn set_key_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_marker(input);
            self
        }
        /// <p>Sets the maximum number of multipart uploads, from 1 to 1,000, to return in the response body. 1,000 is the maximum number of uploads that can be returned in a response.</p>
        pub fn max_uploads(mut self, input: i32) -> Self {
            self.inner = self.inner.max_uploads(input);
            self
        }
        /// <p>Sets the maximum number of multipart uploads, from 1 to 1,000, to return in the response body. 1,000 is the maximum number of uploads that can be returned in a response.</p>
        pub fn set_max_uploads(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_uploads(input);
            self
        }
        /// <p>Lists in-progress uploads only for those keys that begin with the specified prefix. You can use prefixes to separate a bucket into different grouping of keys. (You can think of using prefix to make groups in the same way you'd use a folder in a file system.)</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.prefix(input.into());
            self
        }
        /// <p>Lists in-progress uploads only for those keys that begin with the specified prefix. You can use prefixes to separate a bucket into different grouping of keys. (You can think of using prefix to make groups in the same way you'd use a folder in a file system.)</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_prefix(input);
            self
        }
        /// <p>Together with key-marker, specifies the multipart upload after which listing should begin. If key-marker is not specified, the upload-id-marker parameter is ignored. Otherwise, any multipart uploads for a key equal to the key-marker might be included in the list only if they have an upload ID lexicographically greater than the specified <code>upload-id-marker</code>.</p>
        pub fn upload_id_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.upload_id_marker(input.into());
            self
        }
        /// <p>Together with key-marker, specifies the multipart upload after which listing should begin. If key-marker is not specified, the upload-id-marker parameter is ignored. Otherwise, any multipart uploads for a key equal to the key-marker might be included in the list only if they have an upload ID lexicographically greater than the specified <code>upload-id-marker</code>.</p>
        pub fn set_upload_id_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_upload_id_marker(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListObjects`.
    ///
    /// <p>Returns some or all (up to 1,000) of the objects in a bucket. You can use the request parameters as selection criteria to return a subset of the objects in a bucket. A 200 OK response can contain valid or invalid XML. Be sure to design your application to parse the contents of the response and handle it appropriately.</p> <important>
    /// <p>This action has been revised. We recommend that you use the newer version, <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjectsV2.html">ListObjectsV2</a>, when developing applications. For backward compatibility, Amazon S3 continues to support <code>ListObjects</code>.</p>
    /// </important>
    /// <p>The following operations are related to <code>ListObjects</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjectsV2.html">ListObjectsV2</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBuckets.html">ListBuckets</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListObjects {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_objects_input::Builder,
    }
    impl ListObjects {
        /// Creates a new `ListObjects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListObjectsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListObjectsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket containing the objects.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket containing the objects.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>A delimiter is a character you use to group keys.</p>
        pub fn delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delimiter(input.into());
            self
        }
        /// <p>A delimiter is a character you use to group keys.</p>
        pub fn set_delimiter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_delimiter(input);
            self
        }
        /// <p>Requests Amazon S3 to encode the object keys in the response and specifies the encoding method to use. An object key may contain any Unicode character; however, XML 1.0 parser cannot parse some characters, such as characters with an ASCII value from 0 to 10. For characters that are not supported in XML 1.0, you can add this parameter to request that Amazon S3 encode the keys in the response.</p>
        pub fn encoding_type(mut self, input: crate::model::EncodingType) -> Self {
            self.inner = self.inner.encoding_type(input);
            self
        }
        /// <p>Requests Amazon S3 to encode the object keys in the response and specifies the encoding method to use. An object key may contain any Unicode character; however, XML 1.0 parser cannot parse some characters, such as characters with an ASCII value from 0 to 10. For characters that are not supported in XML 1.0, you can add this parameter to request that Amazon S3 encode the keys in the response.</p>
        pub fn set_encoding_type(
            mut self,
            input: std::option::Option<crate::model::EncodingType>,
        ) -> Self {
            self.inner = self.inner.set_encoding_type(input);
            self
        }
        /// <p>Marker is where you want Amazon S3 to start listing from. Amazon S3 starts listing after this specified key. Marker can be any key in the bucket.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Marker is where you want Amazon S3 to start listing from. Amazon S3 starts listing after this specified key. Marker can be any key in the bucket.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Sets the maximum number of keys returned in the response. By default the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more. </p>
        pub fn max_keys(mut self, input: i32) -> Self {
            self.inner = self.inner.max_keys(input);
            self
        }
        /// <p>Sets the maximum number of keys returned in the response. By default the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more. </p>
        pub fn set_max_keys(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_keys(input);
            self
        }
        /// <p>Limits the response to keys that begin with the specified prefix.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.prefix(input.into());
            self
        }
        /// <p>Limits the response to keys that begin with the specified prefix.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_prefix(input);
            self
        }
        /// <p>Confirms that the requester knows that she or he will be charged for the list objects request. Bucket owners need not specify this parameter in their requests.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.inner = self.inner.request_payer(input);
            self
        }
        /// <p>Confirms that the requester knows that she or he will be charged for the list objects request. Bucket owners need not specify this parameter in their requests.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.inner = self.inner.set_request_payer(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListObjectsV2`.
    ///
    /// <p>Returns some or all (up to 1,000) of the objects in a bucket with each request. You can use the request parameters as selection criteria to return a subset of the objects in a bucket. A <code>200 OK</code> response can contain valid or invalid XML. Make sure to design your application to parse the contents of the response and handle it appropriately. Objects are returned sorted in an ascending order of the respective key names in the list. For more information about listing objects, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ListingKeysUsingAPIs.html">Listing object keys programmatically</a> </p>
    /// <p>To use this operation, you must have READ access to the bucket.</p>
    /// <p>To use this action in an Identity and Access Management (IAM) policy, you must have permissions to perform the <code>s3:ListBucket</code> action. The bucket owner has this permission by default and can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p> <important>
    /// <p>This section describes the latest revision of this action. We recommend that you use this revised API for application development. For backward compatibility, Amazon S3 continues to support the prior version of this API, <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html">ListObjects</a>.</p>
    /// </important>
    /// <p>To get a list of your buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBuckets.html">ListBuckets</a>.</p>
    /// <p>The following operations are related to <code>ListObjectsV2</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListObjectsV2 {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_objects_v2_input::Builder,
    }
    impl ListObjectsV2 {
        /// Creates a new `ListObjectsV2`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListObjectsV2Output,
            aws_smithy_http::result::SdkError<crate::error::ListObjectsV2Error>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListObjectsV2Paginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListObjectsV2Paginator {
            crate::paginator::ListObjectsV2Paginator::new(self.handle, self.inner)
        }
        /// <p>Bucket name to list. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>Bucket name to list. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>A delimiter is a character you use to group keys.</p>
        pub fn delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delimiter(input.into());
            self
        }
        /// <p>A delimiter is a character you use to group keys.</p>
        pub fn set_delimiter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_delimiter(input);
            self
        }
        /// <p>Encoding type used by Amazon S3 to encode object keys in the response.</p>
        pub fn encoding_type(mut self, input: crate::model::EncodingType) -> Self {
            self.inner = self.inner.encoding_type(input);
            self
        }
        /// <p>Encoding type used by Amazon S3 to encode object keys in the response.</p>
        pub fn set_encoding_type(
            mut self,
            input: std::option::Option<crate::model::EncodingType>,
        ) -> Self {
            self.inner = self.inner.set_encoding_type(input);
            self
        }
        /// <p>Sets the maximum number of keys returned in the response. By default the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more.</p>
        pub fn max_keys(mut self, input: i32) -> Self {
            self.inner = self.inner.max_keys(input);
            self
        }
        /// <p>Sets the maximum number of keys returned in the response. By default the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more.</p>
        pub fn set_max_keys(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_keys(input);
            self
        }
        /// <p>Limits the response to keys that begin with the specified prefix.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.prefix(input.into());
            self
        }
        /// <p>Limits the response to keys that begin with the specified prefix.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_prefix(input);
            self
        }
        /// <p>ContinuationToken indicates Amazon S3 that the list is being continued on this bucket with a token. ContinuationToken is obfuscated and is not a real key.</p>
        pub fn continuation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.continuation_token(input.into());
            self
        }
        /// <p>ContinuationToken indicates Amazon S3 that the list is being continued on this bucket with a token. ContinuationToken is obfuscated and is not a real key.</p>
        pub fn set_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_continuation_token(input);
            self
        }
        /// <p>The owner field is not present in listV2 by default, if you want to return owner field with each key in the result then set the fetch owner field to true.</p>
        pub fn fetch_owner(mut self, input: bool) -> Self {
            self.inner = self.inner.fetch_owner(input);
            self
        }
        /// <p>The owner field is not present in listV2 by default, if you want to return owner field with each key in the result then set the fetch owner field to true.</p>
        pub fn set_fetch_owner(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_fetch_owner(input);
            self
        }
        /// <p>StartAfter is where you want Amazon S3 to start listing from. Amazon S3 starts listing after this specified key. StartAfter can be any key in the bucket.</p>
        pub fn start_after(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.start_after(input.into());
            self
        }
        /// <p>StartAfter is where you want Amazon S3 to start listing from. Amazon S3 starts listing after this specified key. StartAfter can be any key in the bucket.</p>
        pub fn set_start_after(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_start_after(input);
            self
        }
        /// <p>Confirms that the requester knows that she or he will be charged for the list objects request in V2 style. Bucket owners need not specify this parameter in their requests.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.inner = self.inner.request_payer(input);
            self
        }
        /// <p>Confirms that the requester knows that she or he will be charged for the list objects request in V2 style. Bucket owners need not specify this parameter in their requests.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.inner = self.inner.set_request_payer(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListObjectVersions`.
    ///
    /// <p>Returns metadata about all versions of the objects in a bucket. You can also use request parameters as selection criteria to return metadata about a subset of all the object versions.</p> <important>
    /// <p> To use this operation, you must have permissions to perform the <code>s3:ListBucketVersions</code> action. Be aware of the name difference. </p>
    /// </important> <note>
    /// <p> A 200 OK response can contain valid or invalid XML. Make sure to design your application to parse the contents of the response and handle it appropriately.</p>
    /// </note>
    /// <p>To use this operation, you must have READ access to the bucket.</p>
    /// <p>This action is not supported by Amazon S3 on Outposts.</p>
    /// <p>The following operations are related to <code>ListObjectVersions</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjectsV2.html">ListObjectsV2</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html">DeleteObject</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListObjectVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_object_versions_input::Builder,
    }
    impl ListObjectVersions {
        /// Creates a new `ListObjectVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListObjectVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListObjectVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The bucket name that contains the objects. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The bucket name that contains the objects. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>A delimiter is a character that you specify to group keys. All keys that contain the same string between the <code>prefix</code> and the first occurrence of the delimiter are grouped under a single result element in CommonPrefixes. These groups are counted as one result against the max-keys limitation. These keys are not returned elsewhere in the response.</p>
        pub fn delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delimiter(input.into());
            self
        }
        /// <p>A delimiter is a character that you specify to group keys. All keys that contain the same string between the <code>prefix</code> and the first occurrence of the delimiter are grouped under a single result element in CommonPrefixes. These groups are counted as one result against the max-keys limitation. These keys are not returned elsewhere in the response.</p>
        pub fn set_delimiter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_delimiter(input);
            self
        }
        /// <p>Requests Amazon S3 to encode the object keys in the response and specifies the encoding method to use. An object key may contain any Unicode character; however, XML 1.0 parser cannot parse some characters, such as characters with an ASCII value from 0 to 10. For characters that are not supported in XML 1.0, you can add this parameter to request that Amazon S3 encode the keys in the response.</p>
        pub fn encoding_type(mut self, input: crate::model::EncodingType) -> Self {
            self.inner = self.inner.encoding_type(input);
            self
        }
        /// <p>Requests Amazon S3 to encode the object keys in the response and specifies the encoding method to use. An object key may contain any Unicode character; however, XML 1.0 parser cannot parse some characters, such as characters with an ASCII value from 0 to 10. For characters that are not supported in XML 1.0, you can add this parameter to request that Amazon S3 encode the keys in the response.</p>
        pub fn set_encoding_type(
            mut self,
            input: std::option::Option<crate::model::EncodingType>,
        ) -> Self {
            self.inner = self.inner.set_encoding_type(input);
            self
        }
        /// <p>Specifies the key to start with when listing objects in a bucket.</p>
        pub fn key_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_marker(input.into());
            self
        }
        /// <p>Specifies the key to start with when listing objects in a bucket.</p>
        pub fn set_key_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_marker(input);
            self
        }
        /// <p>Sets the maximum number of keys returned in the response. By default the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more. If additional keys satisfy the search criteria, but were not returned because max-keys was exceeded, the response contains <istruncated>
        /// true
        /// </istruncated>. To return the additional keys, see key-marker and version-id-marker.</p>
        pub fn max_keys(mut self, input: i32) -> Self {
            self.inner = self.inner.max_keys(input);
            self
        }
        /// <p>Sets the maximum number of keys returned in the response. By default the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more. If additional keys satisfy the search criteria, but were not returned because max-keys was exceeded, the response contains <istruncated>
        /// true
        /// </istruncated>. To return the additional keys, see key-marker and version-id-marker.</p>
        pub fn set_max_keys(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_keys(input);
            self
        }
        /// <p>Use this parameter to select only those keys that begin with the specified prefix. You can use prefixes to separate a bucket into different groupings of keys. (You can think of using prefix to make groups in the same way you'd use a folder in a file system.) You can use prefix with delimiter to roll up numerous objects into a single result under CommonPrefixes. </p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.prefix(input.into());
            self
        }
        /// <p>Use this parameter to select only those keys that begin with the specified prefix. You can use prefixes to separate a bucket into different groupings of keys. (You can think of using prefix to make groups in the same way you'd use a folder in a file system.) You can use prefix with delimiter to roll up numerous objects into a single result under CommonPrefixes. </p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_prefix(input);
            self
        }
        /// <p>Specifies the object version you want to start listing from.</p>
        pub fn version_id_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id_marker(input.into());
            self
        }
        /// <p>Specifies the object version you want to start listing from.</p>
        pub fn set_version_id_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_id_marker(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListParts`.
    ///
    /// <p>Lists the parts that have been uploaded for a specific multipart upload. This operation must include the upload ID, which you obtain by sending the initiate multipart upload request (see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html">CreateMultipartUpload</a>). This request returns a maximum of 1,000 uploaded parts. The default number of parts returned is 1,000 parts. You can restrict the number of parts returned by specifying the <code>max-parts</code> request parameter. If your multipart upload consists of more than 1,000 parts, the response returns an <code>IsTruncated</code> field with the value of true, and a <code>NextPartNumberMarker</code> element. In subsequent <code>ListParts</code> requests you can include the part-number-marker query string parameter and set its value to the <code>NextPartNumberMarker</code> field value from the previous response.</p>
    /// <p>For more information on multipart uploads, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/uploadobjusingmpu.html">Uploading Objects Using Multipart Upload</a>.</p>
    /// <p>For information on permissions required to use the multipart upload API, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html">Multipart Upload and Permissions</a>.</p>
    /// <p>The following operations are related to <code>ListParts</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html">CreateMultipartUpload</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html">UploadPart</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html">CompleteMultipartUpload</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html">AbortMultipartUpload</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html">ListMultipartUploads</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListParts {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_parts_input::Builder,
    }
    impl ListParts {
        /// Creates a new `ListParts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPartsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPartsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPartsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPartsPaginator {
            crate::paginator::ListPartsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the bucket to which the parts are being uploaded. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket to which the parts are being uploaded. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>Object key for which the multipart upload was initiated.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key(input.into());
            self
        }
        /// <p>Object key for which the multipart upload was initiated.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key(input);
            self
        }
        /// <p>Sets the maximum number of parts to return.</p>
        pub fn max_parts(mut self, input: i32) -> Self {
            self.inner = self.inner.max_parts(input);
            self
        }
        /// <p>Sets the maximum number of parts to return.</p>
        pub fn set_max_parts(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_parts(input);
            self
        }
        /// <p>Specifies the part after which listing should begin. Only parts with higher part numbers will be listed.</p>
        pub fn part_number_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.part_number_marker(input.into());
            self
        }
        /// <p>Specifies the part after which listing should begin. Only parts with higher part numbers will be listed.</p>
        pub fn set_part_number_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_part_number_marker(input);
            self
        }
        /// <p>Upload ID identifying the multipart upload whose parts are being listed.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.upload_id(input.into());
            self
        }
        /// <p>Upload ID identifying the multipart upload whose parts are being listed.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_upload_id(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.inner = self.inner.request_payer(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.inner = self.inner.set_request_payer(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBucketAccelerateConfiguration`.
    ///
    /// <p>Sets the accelerate configuration of an existing bucket. Amazon S3 Transfer Acceleration is a bucket-level feature that enables you to perform faster data transfers to Amazon S3.</p>
    /// <p> To use this operation, you must have permission to perform the s3:PutAccelerateConfiguration action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p>
    /// <p> The Transfer Acceleration state of a bucket can be set to one of the following two values:</p>
    /// <ul>
    /// <li> <p> Enabled – Enables accelerated data transfers to the bucket.</p> </li>
    /// <li> <p> Suspended – Disables accelerated data transfers to the bucket.</p> </li>
    /// </ul>
    /// <p>The <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketAccelerateConfiguration.html">GetBucketAccelerateConfiguration</a> action returns the transfer acceleration state of a bucket.</p>
    /// <p>After setting the Transfer Acceleration state of a bucket to Enabled, it might take up to thirty minutes before the data transfer rates to the bucket increase.</p>
    /// <p> The name of the bucket used for Transfer Acceleration must be DNS-compliant and must not contain periods (".").</p>
    /// <p> For more information about transfer acceleration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html">Transfer Acceleration</a>.</p>
    /// <p>The following operations are related to <code>PutBucketAccelerateConfiguration</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketAccelerateConfiguration.html">GetBucketAccelerateConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutBucketAccelerateConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_bucket_accelerate_configuration_input::Builder,
    }
    impl PutBucketAccelerateConfiguration {
        /// Creates a new `PutBucketAccelerateConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBucketAccelerateConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBucketAccelerateConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket for which the accelerate configuration is set.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket for which the accelerate configuration is set.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>Container for setting the transfer acceleration state.</p>
        pub fn accelerate_configuration(
            mut self,
            input: crate::model::AccelerateConfiguration,
        ) -> Self {
            self.inner = self.inner.accelerate_configuration(input);
            self
        }
        /// <p>Container for setting the transfer acceleration state.</p>
        pub fn set_accelerate_configuration(
            mut self,
            input: std::option::Option<crate::model::AccelerateConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_accelerate_configuration(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBucketAcl`.
    ///
    /// <p>Sets the permissions on an existing bucket using access control lists (ACL). For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html">Using ACLs</a>. To set the ACL of a bucket, you must have <code>WRITE_ACP</code> permission.</p>
    /// <p>You can use one of the following two ways to set a bucket's permissions:</p>
    /// <ul>
    /// <li> <p>Specify the ACL in the request body</p> </li>
    /// <li> <p>Specify permissions using request headers</p> </li>
    /// </ul> <note>
    /// <p>You cannot specify access permission using both the body and the request headers.</p>
    /// </note>
    /// <p>Depending on your application needs, you may choose to set the ACL on a bucket using either the request body or the headers. For example, if you have an existing application that updates a bucket ACL using the request body, then you can continue to use that approach.</p> <important>
    /// <p>If your bucket uses the bucket owner enforced setting for S3 Object Ownership, ACLs are disabled and no longer affect permissions. You must use policies to grant access to your bucket and the objects in it. Requests to set ACLs or update ACLs fail and return the <code>AccessControlListNotSupported</code> error code. Requests to read ACLs are still supported. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling object ownership</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// </important>
    /// <p> <b>Access Permissions</b> </p>
    /// <p>You can set access permissions using one of the following methods:</p>
    /// <ul>
    /// <li> <p>Specify a canned ACL with the <code>x-amz-acl</code> request header. Amazon S3 supports a set of predefined ACLs, known as <i>canned ACLs</i>. Each canned ACL has a predefined set of grantees and permissions. Specify the canned ACL name as the value of <code>x-amz-acl</code>. If you use this header, you cannot use other access control-specific headers in your request. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL">Canned ACL</a>.</p> </li>
    /// <li> <p>Specify access permissions explicitly with the <code>x-amz-grant-read</code>, <code>x-amz-grant-read-acp</code>, <code>x-amz-grant-write-acp</code>, and <code>x-amz-grant-full-control</code> headers. When using these headers, you specify explicit access permissions and grantees (Amazon Web Services accounts or Amazon S3 groups) who will receive the permission. If you use these ACL-specific headers, you cannot use the <code>x-amz-acl</code> header to set a canned ACL. These parameters map to the set of permissions that Amazon S3 supports in an ACL. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html">Access Control List (ACL) Overview</a>.</p> <p>You specify each grantee as a type=value pair, where the type is one of the following:</p>
    /// <ul>
    /// <li> <p> <code>id</code> – if the value specified is the canonical user ID of an Amazon Web Services account</p> </li>
    /// <li> <p> <code>uri</code> – if you are granting permissions to a predefined group</p> </li>
    /// <li> <p> <code>emailAddress</code> – if the value specified is the email address of an Amazon Web Services account</p> <note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions: </p>
    /// <ul>
    /// <li> <p>US East (N. Virginia)</p> </li>
    /// <li> <p>US West (N. California)</p> </li>
    /// <li> <p> US West (Oregon)</p> </li>
    /// <li> <p> Asia Pacific (Singapore)</p> </li>
    /// <li> <p>Asia Pacific (Sydney)</p> </li>
    /// <li> <p>Asia Pacific (Tokyo)</p> </li>
    /// <li> <p>Europe (Ireland)</p> </li>
    /// <li> <p>South America (São Paulo)</p> </li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note> </li>
    /// </ul> <p>For example, the following <code>x-amz-grant-write</code> header grants create, overwrite, and delete objects permission to LogDelivery group predefined by Amazon S3 and two Amazon Web Services accounts identified by their email addresses.</p> <p> <code>x-amz-grant-write: uri="http://acs.amazonaws.com/groups/s3/LogDelivery", id="111122223333", id="555566667777" </code> </p> </li>
    /// </ul>
    /// <p>You can use either a canned ACL or specify access permissions explicitly. You cannot do both.</p>
    /// <p> <b>Grantee Values</b> </p>
    /// <p>You can specify the person (grantee) to whom you're assigning access rights (using request elements) in the following ways:</p>
    /// <ul>
    /// <li> <p>By the person's ID:</p> <p> <code>
    /// <grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="CanonicalUser">
    /// <id>
    /// &lt;&gt;ID&lt;&gt;
    /// </id>
    /// <displayname>
    /// &lt;&gt;GranteesEmail&lt;&gt;
    /// </displayname>
    /// </grantee></code> </p> <p>DisplayName is optional and ignored in the request</p> </li>
    /// <li> <p>By URI:</p> <p> <code>
    /// <grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="Group">
    /// <uri>
    /// &lt;&gt;http://acs.amazonaws.com/groups/global/AuthenticatedUsers&lt;&gt;
    /// </uri>
    /// </grantee></code> </p> </li>
    /// <li> <p>By Email address:</p> <p> <code>
    /// <grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="AmazonCustomerByEmail">
    /// <emailaddress>
    /// &lt;&gt;Grantees@email.com&lt;&gt;
    /// </emailaddress>lt;/Grantee&gt;
    /// </grantee></code> </p> <p>The grantee is resolved to the CanonicalUser and, in a response to a GET Object acl request, appears as the CanonicalUser. </p> <note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions: </p>
    /// <ul>
    /// <li> <p>US East (N. Virginia)</p> </li>
    /// <li> <p>US West (N. California)</p> </li>
    /// <li> <p> US West (Oregon)</p> </li>
    /// <li> <p> Asia Pacific (Singapore)</p> </li>
    /// <li> <p>Asia Pacific (Sydney)</p> </li>
    /// <li> <p>Asia Pacific (Tokyo)</p> </li>
    /// <li> <p>Europe (Ireland)</p> </li>
    /// <li> <p>South America (São Paulo)</p> </li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note> </li>
    /// </ul>
    /// <p class="title"> <b>Related Resources</b> </p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html">DeleteBucket</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html">GetObjectAcl</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutBucketAcl {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_bucket_acl_input::Builder,
    }
    impl PutBucketAcl {
        /// Creates a new `PutBucketAcl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBucketAclOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBucketAclError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The canned ACL to apply to the bucket.</p>
        pub fn acl(mut self, input: crate::model::BucketCannedAcl) -> Self {
            self.inner = self.inner.acl(input);
            self
        }
        /// <p>The canned ACL to apply to the bucket.</p>
        pub fn set_acl(
            mut self,
            input: std::option::Option<crate::model::BucketCannedAcl>,
        ) -> Self {
            self.inner = self.inner.set_acl(input);
            self
        }
        /// <p>Contains the elements that set the ACL permissions for an object per grantee.</p>
        pub fn access_control_policy(mut self, input: crate::model::AccessControlPolicy) -> Self {
            self.inner = self.inner.access_control_policy(input);
            self
        }
        /// <p>Contains the elements that set the ACL permissions for an object per grantee.</p>
        pub fn set_access_control_policy(
            mut self,
            input: std::option::Option<crate::model::AccessControlPolicy>,
        ) -> Self {
            self.inner = self.inner.set_access_control_policy(input);
            self
        }
        /// <p>The bucket to which to apply the ACL.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The bucket to which to apply the ACL.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity check to verify that the request body was not corrupted in transit. For more information, go to <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.</a> </p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_md5(input.into());
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity check to verify that the request body was not corrupted in transit. For more information, go to <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.</a> </p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_md5(input);
            self
        }
        /// <p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p>
        pub fn grant_full_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_full_control(input.into());
            self
        }
        /// <p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p>
        pub fn set_grant_full_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_grant_full_control(input);
            self
        }
        /// <p>Allows grantee to list the objects in the bucket.</p>
        pub fn grant_read(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_read(input.into());
            self
        }
        /// <p>Allows grantee to list the objects in the bucket.</p>
        pub fn set_grant_read(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grant_read(input);
            self
        }
        /// <p>Allows grantee to read the bucket ACL.</p>
        pub fn grant_read_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_read_acp(input.into());
            self
        }
        /// <p>Allows grantee to read the bucket ACL.</p>
        pub fn set_grant_read_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_grant_read_acp(input);
            self
        }
        /// <p>Allows grantee to create new objects in the bucket.</p>
        /// <p>For the bucket and object owners of existing objects, also allows deletions and overwrites of those objects.</p>
        pub fn grant_write(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_write(input.into());
            self
        }
        /// <p>Allows grantee to create new objects in the bucket.</p>
        /// <p>For the bucket and object owners of existing objects, also allows deletions and overwrites of those objects.</p>
        pub fn set_grant_write(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grant_write(input);
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable bucket.</p>
        pub fn grant_write_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_write_acp(input.into());
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable bucket.</p>
        pub fn set_grant_write_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_grant_write_acp(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBucketAnalyticsConfiguration`.
    ///
    /// <p>Sets an analytics configuration for the bucket (specified by the analytics configuration ID). You can have up to 1,000 analytics configurations per bucket.</p>
    /// <p>You can choose to have storage class analysis export analysis reports sent to a comma-separated values (CSV) flat file. See the <code>DataExport</code> request element. Reports are updated daily and are based on the object filters that you configure. When selecting data export, you specify a destination bucket and an optional destination prefix where the file is written. You can export the data to a destination bucket in a different account. However, the destination bucket must be in the same Region as the bucket that you are making the PUT analytics configuration to. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/analytics-storage-class.html">Amazon S3 Analytics – Storage Class Analysis</a>. </p> <important>
    /// <p>You must create a bucket policy on the destination bucket where the exported file is written to grant permissions to Amazon S3 to write objects to the bucket. For an example policy, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html#example-bucket-policies-use-case-9">Granting Permissions for Amazon S3 Inventory and Storage Class Analysis</a>.</p>
    /// </important>
    /// <p>To use this operation, you must have permissions to perform the <code>s3:PutAnalyticsConfiguration</code> action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p>
    /// <p class="title"> <b>Special Errors</b> </p>
    /// <ul>
    /// <li>
    /// <ul>
    /// <li> <p> <i>HTTP Error: HTTP 400 Bad Request</i> </p> </li>
    /// <li> <p> <i>Code: InvalidArgument</i> </p> </li>
    /// <li> <p> <i>Cause: Invalid argument.</i> </p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>HTTP Error: HTTP 400 Bad Request</i> </p> </li>
    /// <li> <p> <i>Code: TooManyConfigurations</i> </p> </li>
    /// <li> <p> <i>Cause: You are attempting to create a new configuration but have already reached the 1,000-configuration limit.</i> </p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>HTTP Error: HTTP 403 Forbidden</i> </p> </li>
    /// <li> <p> <i>Code: AccessDenied</i> </p> </li>
    /// <li> <p> <i>Cause: You are not the owner of the specified bucket, or you do not have the s3:PutAnalyticsConfiguration bucket permission to set the configuration on the bucket.</i> </p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p class="title"> <b>Related Resources</b> </p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketAnalyticsConfiguration.html">GetBucketAnalyticsConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketAnalyticsConfiguration.html">DeleteBucketAnalyticsConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketAnalyticsConfigurations.html">ListBucketAnalyticsConfigurations</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutBucketAnalyticsConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_bucket_analytics_configuration_input::Builder,
    }
    impl PutBucketAnalyticsConfiguration {
        /// Creates a new `PutBucketAnalyticsConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBucketAnalyticsConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBucketAnalyticsConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket to which an analytics configuration is stored.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket to which an analytics configuration is stored.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The ID that identifies the analytics configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID that identifies the analytics configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>The configuration and any analyses for the analytics filter.</p>
        pub fn analytics_configuration(
            mut self,
            input: crate::model::AnalyticsConfiguration,
        ) -> Self {
            self.inner = self.inner.analytics_configuration(input);
            self
        }
        /// <p>The configuration and any analyses for the analytics filter.</p>
        pub fn set_analytics_configuration(
            mut self,
            input: std::option::Option<crate::model::AnalyticsConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_analytics_configuration(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBucketCors`.
    ///
    /// <p>Sets the <code>cors</code> configuration for your bucket. If the configuration exists, Amazon S3 replaces it.</p>
    /// <p>To use this operation, you must be allowed to perform the <code>s3:PutBucketCORS</code> action. By default, the bucket owner has this permission and can grant it to others.</p>
    /// <p>You set this configuration on a bucket so that the bucket can service cross-origin requests. For example, you might want to enable a request whose origin is <code>http://www.example.com</code> to access your Amazon S3 bucket at <code>my.example.bucket.com</code> by using the browser's <code>XMLHttpRequest</code> capability.</p>
    /// <p>To enable cross-origin resource sharing (CORS) on a bucket, you add the <code>cors</code> subresource to the bucket. The <code>cors</code> subresource is an XML document in which you configure rules that identify origins and the HTTP methods that can be executed on your bucket. The document is limited to 64 KB in size. </p>
    /// <p>When Amazon S3 receives a cross-origin request (or a pre-flight OPTIONS request) against a bucket, it evaluates the <code>cors</code> configuration on the bucket and uses the first <code>CORSRule</code> rule that matches the incoming browser request to enable a cross-origin request. For a rule to match, the following conditions must be met:</p>
    /// <ul>
    /// <li> <p>The request's <code>Origin</code> header must match <code>AllowedOrigin</code> elements.</p> </li>
    /// <li> <p>The request method (for example, GET, PUT, HEAD, and so on) or the <code>Access-Control-Request-Method</code> header in case of a pre-flight <code>OPTIONS</code> request must be one of the <code>AllowedMethod</code> elements. </p> </li>
    /// <li> <p>Every header specified in the <code>Access-Control-Request-Headers</code> request header of a pre-flight request must match an <code>AllowedHeader</code> element. </p> </li>
    /// </ul>
    /// <p> For more information about CORS, go to <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">Enabling Cross-Origin Resource Sharing</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p class="title"> <b>Related Resources</b> </p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketCors.html">GetBucketCors</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketCors.html">DeleteBucketCors</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTOPTIONSobject.html">RESTOPTIONSobject</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutBucketCors {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_bucket_cors_input::Builder,
    }
    impl PutBucketCors {
        /// Creates a new `PutBucketCors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBucketCorsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBucketCorsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the bucket impacted by the <code>cors</code>configuration.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>Specifies the bucket impacted by the <code>cors</code>configuration.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>Describes the cross-origin access configuration for objects in an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">Enabling Cross-Origin Resource Sharing</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn cors_configuration(mut self, input: crate::model::CorsConfiguration) -> Self {
            self.inner = self.inner.cors_configuration(input);
            self
        }
        /// <p>Describes the cross-origin access configuration for objects in an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">Enabling Cross-Origin Resource Sharing</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_cors_configuration(
            mut self,
            input: std::option::Option<crate::model::CorsConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_cors_configuration(input);
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity check to verify that the request body was not corrupted in transit. For more information, go to <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.</a> </p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_md5(input.into());
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity check to verify that the request body was not corrupted in transit. For more information, go to <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.</a> </p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_md5(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBucketEncryption`.
    ///
    /// <p>This action uses the <code>encryption</code> subresource to configure default encryption and Amazon S3 Bucket Key for an existing bucket.</p>
    /// <p>Default encryption for a bucket can use server-side encryption with Amazon S3-managed keys (SSE-S3) or customer managed keys (SSE-KMS). If you specify default encryption using SSE-KMS, you can also configure Amazon S3 Bucket Key. For information about default encryption, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">Amazon S3 default bucket encryption</a> in the <i>Amazon S3 User Guide</i>. For more information about S3 Bucket Keys, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html">Amazon S3 Bucket Keys</a> in the <i>Amazon S3 User Guide</i>.</p> <important>
    /// <p>This action requires Amazon Web Services Signature Version 4. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html"> Authenticating Requests (Amazon Web Services Signature Version 4)</a>. </p>
    /// </important>
    /// <p>To use this operation, you must have permissions to perform the <code>s3:PutEncryptionConfiguration</code> action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a> in the Amazon S3 User Guide. </p>
    /// <p class="title"> <b>Related Resources</b> </p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketEncryption.html">GetBucketEncryption</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketEncryption.html">DeleteBucketEncryption</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutBucketEncryption {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_bucket_encryption_input::Builder,
    }
    impl PutBucketEncryption {
        /// Creates a new `PutBucketEncryption`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBucketEncryptionOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBucketEncryptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies default encryption for a bucket using server-side encryption with Amazon S3-managed keys (SSE-S3) or customer managed keys (SSE-KMS). For information about the Amazon S3 default encryption feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">Amazon S3 Default Bucket Encryption</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>Specifies default encryption for a bucket using server-side encryption with Amazon S3-managed keys (SSE-S3) or customer managed keys (SSE-KMS). For information about the Amazon S3 default encryption feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">Amazon S3 Default Bucket Encryption</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the server-side encryption configuration.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_md5(input.into());
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the server-side encryption configuration.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_md5(input);
            self
        }
        /// <p>Specifies the default server-side-encryption configuration.</p>
        pub fn server_side_encryption_configuration(
            mut self,
            input: crate::model::ServerSideEncryptionConfiguration,
        ) -> Self {
            self.inner = self.inner.server_side_encryption_configuration(input);
            self
        }
        /// <p>Specifies the default server-side-encryption configuration.</p>
        pub fn set_server_side_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_server_side_encryption_configuration(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBucketIntelligentTieringConfiguration`.
    ///
    /// <p>Puts a S3 Intelligent-Tiering configuration to the specified bucket. You can have up to 1,000 S3 Intelligent-Tiering configurations per bucket.</p>
    /// <p>The S3 Intelligent-Tiering storage class is designed to optimize storage costs by automatically moving data to the most cost-effective storage access tier, without performance impact or operational overhead. S3 Intelligent-Tiering delivers automatic cost savings in three low latency and high throughput access tiers. To get the lowest storage cost on data that can be accessed in minutes to hours, you can choose to activate additional archiving capabilities.</p>
    /// <p>The S3 Intelligent-Tiering storage class is the ideal storage class for data with unknown, changing, or unpredictable access patterns, independent of object size or retention period. If the size of an object is less than 128 KB, it is not monitored and not eligible for auto-tiering. Smaller objects can be stored, but they are always charged at the Frequent Access tier rates in the S3 Intelligent-Tiering storage class.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access">Storage class for automatically optimizing frequently and infrequently accessed objects</a>.</p>
    /// <p>Operations related to <code>PutBucketIntelligentTieringConfiguration</code> include: </p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketIntelligentTieringConfiguration.html">DeleteBucketIntelligentTieringConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketIntelligentTieringConfiguration.html">GetBucketIntelligentTieringConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketIntelligentTieringConfigurations.html">ListBucketIntelligentTieringConfigurations</a> </p> </li>
    /// </ul> <note>
    /// <p>You only need S3 Intelligent-Tiering enabled on a bucket if you want to automatically move objects stored in the S3 Intelligent-Tiering storage class to the Archive Access or Deep Archive Access tier.</p>
    /// </note>
    /// <p class="title"> <b>Special Errors</b> </p>
    /// <ul>
    /// <li> <p class="title"> <b>HTTP 400 Bad Request Error</b> </p>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidArgument</p> </li>
    /// <li> <p> <i>Cause:</i> Invalid Argument</p> </li>
    /// </ul> </li>
    /// <li> <p class="title"> <b>HTTP 400 Bad Request Error</b> </p>
    /// <ul>
    /// <li> <p> <i>Code:</i> TooManyConfigurations</p> </li>
    /// <li> <p> <i>Cause:</i> You are attempting to create a new configuration but have already reached the 1,000-configuration limit. </p> </li>
    /// </ul> </li>
    /// <li> <p class="title"> <b>HTTP 403 Forbidden Error</b> </p>
    /// <ul>
    /// <li> <p> <i>Code:</i> AccessDenied</p> </li>
    /// <li> <p> <i>Cause:</i> You are not the owner of the specified bucket, or you do not have the <code>s3:PutIntelligentTieringConfiguration</code> bucket permission to set the configuration on the bucket. </p> </li>
    /// </ul> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutBucketIntelligentTieringConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_bucket_intelligent_tiering_configuration_input::Builder,
    }
    impl PutBucketIntelligentTieringConfiguration {
        /// Creates a new `PutBucketIntelligentTieringConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBucketIntelligentTieringConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutBucketIntelligentTieringConfigurationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon S3 bucket whose configuration you want to modify or retrieve.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket whose configuration you want to modify or retrieve.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>Container for S3 Intelligent-Tiering configuration.</p>
        pub fn intelligent_tiering_configuration(
            mut self,
            input: crate::model::IntelligentTieringConfiguration,
        ) -> Self {
            self.inner = self.inner.intelligent_tiering_configuration(input);
            self
        }
        /// <p>Container for S3 Intelligent-Tiering configuration.</p>
        pub fn set_intelligent_tiering_configuration(
            mut self,
            input: std::option::Option<crate::model::IntelligentTieringConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_intelligent_tiering_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBucketInventoryConfiguration`.
    ///
    /// <p>This implementation of the <code>PUT</code> action adds an inventory configuration (identified by the inventory ID) to the bucket. You can have up to 1,000 inventory configurations per bucket. </p>
    /// <p>Amazon S3 inventory generates inventories of the objects in the bucket on a daily or weekly basis, and the results are published to a flat file. The bucket that is inventoried is called the <i>source</i> bucket, and the bucket where the inventory flat file is stored is called the <i>destination</i> bucket. The <i>destination</i> bucket must be in the same Amazon Web Services Region as the <i>source</i> bucket. </p>
    /// <p>When you configure an inventory for a <i>source</i> bucket, you specify the <i>destination</i> bucket where you want the inventory to be stored, and whether to generate the inventory daily or weekly. You can also configure what object metadata to include and whether to inventory all object versions or only current versions. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html">Amazon S3 Inventory</a> in the Amazon S3 User Guide.</p> <important>
    /// <p>You must create a bucket policy on the <i>destination</i> bucket to grant permissions to Amazon S3 to write objects to the bucket in the defined location. For an example policy, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html#example-bucket-policies-use-case-9"> Granting Permissions for Amazon S3 Inventory and Storage Class Analysis</a>.</p>
    /// </important>
    /// <p>To use this operation, you must have permissions to perform the <code>s3:PutInventoryConfiguration</code> action. The bucket owner has this permission by default and can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a> in the Amazon S3 User Guide.</p>
    /// <p class="title"> <b>Special Errors</b> </p>
    /// <ul>
    /// <li> <p class="title"> <b>HTTP 400 Bad Request Error</b> </p>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidArgument</p> </li>
    /// <li> <p> <i>Cause:</i> Invalid Argument</p> </li>
    /// </ul> </li>
    /// <li> <p class="title"> <b>HTTP 400 Bad Request Error</b> </p>
    /// <ul>
    /// <li> <p> <i>Code:</i> TooManyConfigurations</p> </li>
    /// <li> <p> <i>Cause:</i> You are attempting to create a new configuration but have already reached the 1,000-configuration limit. </p> </li>
    /// </ul> </li>
    /// <li> <p class="title"> <b>HTTP 403 Forbidden Error</b> </p>
    /// <ul>
    /// <li> <p> <i>Code:</i> AccessDenied</p> </li>
    /// <li> <p> <i>Cause:</i> You are not the owner of the specified bucket, or you do not have the <code>s3:PutInventoryConfiguration</code> bucket permission to set the configuration on the bucket. </p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p class="title"> <b>Related Resources</b> </p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketInventoryConfiguration.html">GetBucketInventoryConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketInventoryConfiguration.html">DeleteBucketInventoryConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketInventoryConfigurations.html">ListBucketInventoryConfigurations</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutBucketInventoryConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_bucket_inventory_configuration_input::Builder,
    }
    impl PutBucketInventoryConfiguration {
        /// Creates a new `PutBucketInventoryConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBucketInventoryConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBucketInventoryConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket where the inventory configuration will be stored.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket where the inventory configuration will be stored.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The ID used to identify the inventory configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID used to identify the inventory configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>Specifies the inventory configuration.</p>
        pub fn inventory_configuration(
            mut self,
            input: crate::model::InventoryConfiguration,
        ) -> Self {
            self.inner = self.inner.inventory_configuration(input);
            self
        }
        /// <p>Specifies the inventory configuration.</p>
        pub fn set_inventory_configuration(
            mut self,
            input: std::option::Option<crate::model::InventoryConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_inventory_configuration(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBucketLifecycleConfiguration`.
    ///
    /// <p>Creates a new lifecycle configuration for the bucket or replaces an existing lifecycle configuration. For information about lifecycle configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lifecycle-mgmt.html">Managing your storage lifecycle</a>.</p> <note>
    /// <p>Bucket lifecycle configuration now supports specifying a lifecycle rule using an object key name prefix, one or more object tags, or a combination of both. Accordingly, this section describes the latest API. The previous version of the API supported filtering based only on an object key name prefix, which is supported for backward compatibility. For the related API description, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycle.html">PutBucketLifecycle</a>.</p>
    /// </note>
    /// <p> <b>Rules</b> </p>
    /// <p>You specify the lifecycle configuration in your request body. The lifecycle configuration is specified as XML consisting of one or more rules. Each rule consists of the following:</p>
    /// <ul>
    /// <li> <p>Filter identifying a subset of objects to which the rule applies. The filter can be based on a key name prefix, object tags, or a combination of both.</p> </li>
    /// <li> <p>Status whether the rule is in effect.</p> </li>
    /// <li> <p>One or more lifecycle transition and expiration actions that you want Amazon S3 to perform on the objects identified by the filter. If the state of your bucket is versioning-enabled or versioning-suspended, you can have many versions of the same object (one current version and zero or more noncurrent versions). Amazon S3 provides predefined actions that you can specify for current and noncurrent object versions.</p> </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html">Object Lifecycle Management</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html">Lifecycle Configuration Elements</a>.</p>
    /// <p> <b>Permissions</b> </p>
    /// <p>By default, all Amazon S3 resources are private, including buckets, objects, and related subresources (for example, lifecycle configuration and website configuration). Only the resource owner (that is, the Amazon Web Services account that created it) can access the resource. The resource owner can optionally grant access permissions to others by writing an access policy. For this operation, a user must get the s3:PutLifecycleConfiguration permission.</p>
    /// <p>You can also explicitly deny permissions. Explicit deny also supersedes any other permissions. If you want to block users or accounts from removing or deleting objects from your bucket, you must deny them permissions for the following actions:</p>
    /// <ul>
    /// <li> <p>s3:DeleteObject</p> </li>
    /// <li> <p>s3:DeleteObjectVersion</p> </li>
    /// <li> <p>s3:PutLifecycleConfiguration</p> </li>
    /// </ul>
    /// <p>For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p>
    /// <p>The following are related to <code>PutBucketLifecycleConfiguration</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/lifecycle-configuration-examples.html">Examples of Lifecycle Configuration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html">GetBucketLifecycleConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketLifecycle.html">DeleteBucketLifecycle</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutBucketLifecycleConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_bucket_lifecycle_configuration_input::Builder,
    }
    impl PutBucketLifecycleConfiguration {
        /// Creates a new `PutBucketLifecycleConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBucketLifecycleConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBucketLifecycleConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket for which to set the configuration.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket for which to set the configuration.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>Container for lifecycle rules. You can add as many as 1,000 rules.</p>
        pub fn lifecycle_configuration(
            mut self,
            input: crate::model::BucketLifecycleConfiguration,
        ) -> Self {
            self.inner = self.inner.lifecycle_configuration(input);
            self
        }
        /// <p>Container for lifecycle rules. You can add as many as 1,000 rules.</p>
        pub fn set_lifecycle_configuration(
            mut self,
            input: std::option::Option<crate::model::BucketLifecycleConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_lifecycle_configuration(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBucketLogging`.
    ///
    /// <p>Set the logging parameters for a bucket and to specify permissions for who can view and modify the logging parameters. All logs are saved to buckets in the same Amazon Web Services Region as the source bucket. To set the logging status of a bucket, you must be the bucket owner.</p>
    /// <p>The bucket owner is automatically granted FULL_CONTROL to all logs. You use the <code>Grantee</code> request element to grant access to other people. The <code>Permissions</code> request element specifies the kind of access the grantee has to the logs.</p> <important>
    /// <p>If the target bucket for log delivery uses the bucket owner enforced setting for S3 Object Ownership, you can't use the <code>Grantee</code> request element to grant access to others. Permissions can only be granted using policies. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/enable-server-access-logging.html#grant-log-delivery-permissions-general">Permissions for server access log delivery</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// </important>
    /// <p> <b>Grantee Values</b> </p>
    /// <p>You can specify the person (grantee) to whom you're assigning access rights (using request elements) in the following ways:</p>
    /// <ul>
    /// <li> <p>By the person's ID:</p> <p> <code>
    /// <grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="CanonicalUser">
    /// <id>
    /// &lt;&gt;ID&lt;&gt;
    /// </id>
    /// <displayname>
    /// &lt;&gt;GranteesEmail&lt;&gt;
    /// </displayname>
    /// </grantee></code> </p> <p>DisplayName is optional and ignored in the request.</p> </li>
    /// <li> <p>By Email address:</p> <p> <code>
    /// <grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="AmazonCustomerByEmail">
    /// <emailaddress>
    /// &lt;&gt;Grantees@email.com&lt;&gt;
    /// </emailaddress>
    /// </grantee></code> </p> <p>The grantee is resolved to the CanonicalUser and, in a response to a GET Object acl request, appears as the CanonicalUser.</p> </li>
    /// <li> <p>By URI:</p> <p> <code>
    /// <grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="Group">
    /// <uri>
    /// &lt;&gt;http://acs.amazonaws.com/groups/global/AuthenticatedUsers&lt;&gt;
    /// </uri>
    /// </grantee></code> </p> </li>
    /// </ul>
    /// <p>To enable logging, you use LoggingEnabled and its children request elements. To disable logging, you use an empty BucketLoggingStatus request element:</p>
    /// <p> <code>
    /// <bucketloggingstatus xmlns="http://doc.s3.amazonaws.com/2006-03-01" /></code> </p>
    /// <p>For more information about server access logging, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerLogs.html">Server Access Logging</a> in the <i>Amazon S3 User Guide</i>. </p>
    /// <p>For more information about creating a bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a>. For more information about returning the logging status of a bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLogging.html">GetBucketLogging</a>.</p>
    /// <p>The following operations are related to <code>PutBucketLogging</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html">PutObject</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html">DeleteBucket</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLogging.html">GetBucketLogging</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutBucketLogging {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_bucket_logging_input::Builder,
    }
    impl PutBucketLogging {
        /// Creates a new `PutBucketLogging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBucketLoggingOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBucketLoggingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket for which to set the logging parameters.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket for which to set the logging parameters.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>Container for logging status information.</p>
        pub fn bucket_logging_status(mut self, input: crate::model::BucketLoggingStatus) -> Self {
            self.inner = self.inner.bucket_logging_status(input);
            self
        }
        /// <p>Container for logging status information.</p>
        pub fn set_bucket_logging_status(
            mut self,
            input: std::option::Option<crate::model::BucketLoggingStatus>,
        ) -> Self {
            self.inner = self.inner.set_bucket_logging_status(input);
            self
        }
        /// <p>The MD5 hash of the <code>PutBucketLogging</code> request body.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_md5(input.into());
            self
        }
        /// <p>The MD5 hash of the <code>PutBucketLogging</code> request body.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_md5(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBucketMetricsConfiguration`.
    ///
    /// <p>Sets a metrics configuration (specified by the metrics configuration ID) for the bucket. You can have up to 1,000 metrics configurations per bucket. If you're updating an existing metrics configuration, note that this is a full replacement of the existing metrics configuration. If you don't include the elements you want to keep, they are erased.</p>
    /// <p>To use this operation, you must have permissions to perform the <code>s3:PutMetricsConfiguration</code> action. The bucket owner has this permission by default. The bucket owner can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p>
    /// <p>For information about CloudWatch request metrics for Amazon S3, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cloudwatch-monitoring.html">Monitoring Metrics with Amazon CloudWatch</a>.</p>
    /// <p>The following operations are related to <code>PutBucketMetricsConfiguration</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketMetricsConfiguration.html">DeleteBucketMetricsConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketMetricsConfiguration.html">GetBucketMetricsConfiguration</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBucketMetricsConfigurations.html">ListBucketMetricsConfigurations</a> </p> </li>
    /// </ul>
    /// <p> <code>GetBucketLifecycle</code> has the following special error:</p>
    /// <ul>
    /// <li> <p>Error code: <code>TooManyConfigurations</code> </p>
    /// <ul>
    /// <li> <p>Description: You are attempting to create a new configuration but have already reached the 1,000-configuration limit.</p> </li>
    /// <li> <p>HTTP Status Code: HTTP 400 Bad Request</p> </li>
    /// </ul> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutBucketMetricsConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_bucket_metrics_configuration_input::Builder,
    }
    impl PutBucketMetricsConfiguration {
        /// Creates a new `PutBucketMetricsConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBucketMetricsConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBucketMetricsConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket for which the metrics configuration is set.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket for which the metrics configuration is set.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The ID used to identify the metrics configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID used to identify the metrics configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>Specifies the metrics configuration.</p>
        pub fn metrics_configuration(mut self, input: crate::model::MetricsConfiguration) -> Self {
            self.inner = self.inner.metrics_configuration(input);
            self
        }
        /// <p>Specifies the metrics configuration.</p>
        pub fn set_metrics_configuration(
            mut self,
            input: std::option::Option<crate::model::MetricsConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_metrics_configuration(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBucketNotificationConfiguration`.
    ///
    /// <p>Enables notifications of specified events for a bucket. For more information about event notifications, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a>.</p>
    /// <p>Using this API, you can replace an existing notification configuration. The configuration is an XML file that defines the event types that you want Amazon S3 to publish and the destination where you want Amazon S3 to publish an event notification when it detects an event of the specified type.</p>
    /// <p>By default, your bucket has no event notifications configured. That is, the notification configuration will be an empty <code>NotificationConfiguration</code>.</p>
    /// <p> <code>
    /// <notificationconfiguration></notificationconfiguration></code> </p>
    /// <p> <code></code> </p>
    /// <p>This action replaces the existing notification configuration with the configuration you include in the request body.</p>
    /// <p>After Amazon S3 receives this request, it first verifies that any Amazon Simple Notification Service (Amazon SNS) or Amazon Simple Queue Service (Amazon SQS) destination exists, and that the bucket owner has permission to publish to it by sending a test notification. In the case of Lambda destinations, Amazon S3 verifies that the Lambda function permissions grant Amazon S3 permission to invoke the function from the Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Notifications for Amazon S3 Events</a>.</p>
    /// <p>You can disable notifications by adding the empty NotificationConfiguration element.</p>
    /// <p>By default, only the bucket owner can configure notifications on a bucket. However, bucket owners can use a bucket policy to grant permission to other users to set this configuration with <code>s3:PutBucketNotification</code> permission.</p> <note>
    /// <p>The PUT notification is an atomic operation. For example, suppose your notification configuration includes SNS topic, SQS queue, and Lambda function configurations. When you send a PUT request with this configuration, Amazon S3 sends test messages to your SNS topic. If the message fails, the entire PUT action will fail, and Amazon S3 will not add the configuration to your bucket.</p>
    /// </note>
    /// <p> <b>Responses</b> </p>
    /// <p>If the configuration in the request body includes only one <code>TopicConfiguration</code> specifying only the <code>s3:ReducedRedundancyLostObject</code> event type, the response will also include the <code>x-amz-sns-test-message-id</code> header containing the message ID of the test notification sent to the topic.</p>
    /// <p>The following action is related to <code>PutBucketNotificationConfiguration</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketNotificationConfiguration.html">GetBucketNotificationConfiguration</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutBucketNotificationConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_bucket_notification_configuration_input::Builder,
    }
    impl PutBucketNotificationConfiguration {
        /// Creates a new `PutBucketNotificationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBucketNotificationConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutBucketNotificationConfigurationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>A container for specifying the notification configuration of the bucket. If this element is empty, notifications are turned off for the bucket.</p>
        pub fn notification_configuration(
            mut self,
            input: crate::model::NotificationConfiguration,
        ) -> Self {
            self.inner = self.inner.notification_configuration(input);
            self
        }
        /// <p>A container for specifying the notification configuration of the bucket. If this element is empty, notifications are turned off for the bucket.</p>
        pub fn set_notification_configuration(
            mut self,
            input: std::option::Option<crate::model::NotificationConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_notification_configuration(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
        /// <p>Skips validation of Amazon SQS, Amazon SNS, and Lambda destinations. True or false value.</p>
        pub fn skip_destination_validation(mut self, input: bool) -> Self {
            self.inner = self.inner.skip_destination_validation(input);
            self
        }
        /// <p>Skips validation of Amazon SQS, Amazon SNS, and Lambda destinations. True or false value.</p>
        pub fn set_skip_destination_validation(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_skip_destination_validation(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBucketOwnershipControls`.
    ///
    /// <p>Creates or modifies <code>OwnershipControls</code> for an Amazon S3 bucket. To use this operation, you must have the <code>s3:PutBucketOwnershipControls</code> permission. For more information about Amazon S3 permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/user-guide/using-with-s3-actions.html">Specifying permissions in a policy</a>. </p>
    /// <p>For information about Amazon S3 Object Ownership, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/user-guide/about-object-ownership.html">Using object ownership</a>. </p>
    /// <p>The following operations are related to <code>PutBucketOwnershipControls</code>:</p>
    /// <ul>
    /// <li> <p> <code>GetBucketOwnershipControls</code> </p> </li>
    /// <li> <p> <code>DeleteBucketOwnershipControls</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutBucketOwnershipControls {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_bucket_ownership_controls_input::Builder,
    }
    impl PutBucketOwnershipControls {
        /// Creates a new `PutBucketOwnershipControls`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBucketOwnershipControlsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBucketOwnershipControlsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon S3 bucket whose <code>OwnershipControls</code> you want to set.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket whose <code>OwnershipControls</code> you want to set.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The MD5 hash of the <code>OwnershipControls</code> request body. </p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_md5(input.into());
            self
        }
        /// <p>The MD5 hash of the <code>OwnershipControls</code> request body. </p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_md5(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
        /// <p>The <code>OwnershipControls</code> (BucketOwnerEnforced, BucketOwnerPreferred, or ObjectWriter) that you want to apply to this Amazon S3 bucket.</p>
        pub fn ownership_controls(mut self, input: crate::model::OwnershipControls) -> Self {
            self.inner = self.inner.ownership_controls(input);
            self
        }
        /// <p>The <code>OwnershipControls</code> (BucketOwnerEnforced, BucketOwnerPreferred, or ObjectWriter) that you want to apply to this Amazon S3 bucket.</p>
        pub fn set_ownership_controls(
            mut self,
            input: std::option::Option<crate::model::OwnershipControls>,
        ) -> Self {
            self.inner = self.inner.set_ownership_controls(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBucketPolicy`.
    ///
    /// <p>Applies an Amazon S3 bucket policy to an Amazon S3 bucket. If you are using an identity other than the root user of the Amazon Web Services account that owns the bucket, the calling identity must have the <code>PutBucketPolicy</code> permissions on the specified bucket and belong to the bucket owner's account in order to use this operation.</p>
    /// <p>If you don't have <code>PutBucketPolicy</code> permissions, Amazon S3 returns a <code>403 Access Denied</code> error. If you have the correct permissions, but you're not using an identity that belongs to the bucket owner's account, Amazon S3 returns a <code>405 Method Not Allowed</code> error.</p> <important>
    /// <p> As a security precaution, the root user of the Amazon Web Services account that owns a bucket can always use this operation, even if the policy explicitly denies the root user the ability to perform this action. </p>
    /// </important>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/example-bucket-policies.html">Bucket policy examples</a>.</p>
    /// <p>The following operations are related to <code>PutBucketPolicy</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html">DeleteBucket</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutBucketPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_bucket_policy_input::Builder,
    }
    impl PutBucketPolicy {
        /// Creates a new `PutBucketPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBucketPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBucketPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The MD5 hash of the request body.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_md5(input.into());
            self
        }
        /// <p>The MD5 hash of the request body.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_md5(input);
            self
        }
        /// <p>Set this parameter to true to confirm that you want to remove your permissions to change this bucket policy in the future.</p>
        pub fn confirm_remove_self_bucket_access(mut self, input: bool) -> Self {
            self.inner = self.inner.confirm_remove_self_bucket_access(input);
            self
        }
        /// <p>Set this parameter to true to confirm that you want to remove your permissions to change this bucket policy in the future.</p>
        pub fn set_confirm_remove_self_bucket_access(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_confirm_remove_self_bucket_access(input);
            self
        }
        /// <p>The bucket policy as a JSON document.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>The bucket policy as a JSON document.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBucketReplication`.
    ///
    /// <p> Creates a replication configuration or replaces an existing one. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html">Replication</a> in the <i>Amazon S3 User Guide</i>. </p>
    /// <p>Specify the replication configuration in the request body. In the replication configuration, you provide the name of the destination bucket or buckets where you want Amazon S3 to replicate objects, the IAM role that Amazon S3 can assume to replicate objects on your behalf, and other relevant information.</p>
    /// <p>A replication configuration must include at least one rule, and can contain a maximum of 1,000. Each rule identifies a subset of objects to replicate by filtering the objects in the source bucket. To choose additional subsets of objects to replicate, add a rule for each subset.</p>
    /// <p>To specify a subset of the objects in the source bucket to apply a replication rule to, add the Filter element as a child of the Rule element. You can filter objects based on an object key prefix, one or more object tags, or both. When you add the Filter element in the configuration, you must also add the following elements: <code>DeleteMarkerReplication</code>, <code>Status</code>, and <code>Priority</code>.</p> <note>
    /// <p>If you are using an earlier version of the replication configuration, Amazon S3 handles replication of delete markers differently. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-backward-compat-considerations">Backward Compatibility</a>.</p>
    /// </note>
    /// <p>For information about enabling versioning on a bucket, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html">Using Versioning</a>.</p>
    /// <p> <b>Handling Replication of Encrypted Objects</b> </p>
    /// <p>By default, Amazon S3 doesn't replicate objects that are stored at rest using server-side encryption with KMS keys. To replicate Amazon Web Services KMS-encrypted objects, add the following: <code>SourceSelectionCriteria</code>, <code>SseKmsEncryptedObjects</code>, <code>Status</code>, <code>EncryptionConfiguration</code>, and <code>ReplicaKmsKeyID</code>. For information about replication configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-config-for-kms-objects.html">Replicating Objects Created with SSE Using KMS keys</a>.</p>
    /// <p>For information on <code>PutBucketReplication</code> errors, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ReplicationErrorCodeList">List of replication-related error codes</a> </p>
    /// <p> <b>Permissions</b> </p>
    /// <p>To create a <code>PutBucketReplication</code> request, you must have <code>s3:PutReplicationConfiguration</code> permissions for the bucket. </p>
    /// <p>By default, a resource owner, in this case the Amazon Web Services account that created the bucket, can perform this operation. The resource owner can also grant others permissions to perform the operation. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html">Specifying Permissions in a Policy</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p> <note>
    /// <p>To perform this operation, the user or role performing the action must have the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">iam:PassRole</a> permission.</p>
    /// </note>
    /// <p>The following operations are related to <code>PutBucketReplication</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketReplication.html">GetBucketReplication</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketReplication.html">DeleteBucketReplication</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutBucketReplication {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_bucket_replication_input::Builder,
    }
    impl PutBucketReplication {
        /// Creates a new `PutBucketReplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBucketReplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBucketReplicationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The name of the bucket</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_md5(input.into());
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_md5(input);
            self
        }
        /// <p>A container for replication rules. You can add up to 1,000 rules. The maximum size of a replication configuration is 2 MB.</p>
        pub fn replication_configuration(
            mut self,
            input: crate::model::ReplicationConfiguration,
        ) -> Self {
            self.inner = self.inner.replication_configuration(input);
            self
        }
        /// <p>A container for replication rules. You can add up to 1,000 rules. The maximum size of a replication configuration is 2 MB.</p>
        pub fn set_replication_configuration(
            mut self,
            input: std::option::Option<crate::model::ReplicationConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_replication_configuration(input);
            self
        }
        /// <p>A token to allow Object Lock to be enabled for an existing bucket.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(input.into());
            self
        }
        /// <p>A token to allow Object Lock to be enabled for an existing bucket.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBucketRequestPayment`.
    ///
    /// <p>Sets the request payment configuration for a bucket. By default, the bucket owner pays for downloads from the bucket. This configuration parameter enables the bucket owner (only) to specify that the person requesting the download will be charged for the download. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a>.</p>
    /// <p>The following operations are related to <code>PutBucketRequestPayment</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketRequestPayment.html">GetBucketRequestPayment</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutBucketRequestPayment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_bucket_request_payment_input::Builder,
    }
    impl PutBucketRequestPayment {
        /// Creates a new `PutBucketRequestPayment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBucketRequestPaymentOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBucketRequestPaymentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The bucket name.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The bucket name.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_md5(input.into());
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_md5(input);
            self
        }
        /// <p>Container for Payer.</p>
        pub fn request_payment_configuration(
            mut self,
            input: crate::model::RequestPaymentConfiguration,
        ) -> Self {
            self.inner = self.inner.request_payment_configuration(input);
            self
        }
        /// <p>Container for Payer.</p>
        pub fn set_request_payment_configuration(
            mut self,
            input: std::option::Option<crate::model::RequestPaymentConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_request_payment_configuration(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBucketTagging`.
    ///
    /// <p>Sets the tags for a bucket.</p>
    /// <p>Use tags to organize your Amazon Web Services bill to reflect your own cost structure. To do this, sign up to get your Amazon Web Services account bill with tag key values included. Then, to see the cost of combined resources, organize your billing information according to resources with the same tag key values. For example, you can tag several resources with a specific application name, and then organize your billing information to see the total cost of that application across several services. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Cost Allocation and Tagging</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/CostAllocTagging.html">Using Cost Allocation in Amazon S3 Bucket Tags</a>.</p> <note>
    /// <p> When this operation sets the tags for a bucket, it will overwrite any current tags the bucket already has. You cannot use this operation to add tags to an existing list of tags.</p>
    /// </note>
    /// <p>To use this operation, you must have permissions to perform the <code>s3:PutBucketTagging</code> action. The bucket owner has this permission by default and can grant this permission to others. For more information about permissions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources">Permissions Related to Bucket Subresource Operations</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html">Managing Access Permissions to Your Amazon S3 Resources</a>.</p>
    /// <p> <code>PutBucketTagging</code> has the following special errors:</p>
    /// <ul>
    /// <li> <p>Error code: <code>InvalidTagError</code> </p>
    /// <ul>
    /// <li> <p>Description: The tag provided was not a valid tag. This error can occur if the tag did not pass input validation. For information about tag restrictions, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html">User-Defined Tag Restrictions</a> and <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/aws-tag-restrictions.html">Amazon Web Services-Generated Cost Allocation Tag Restrictions</a>.</p> </li>
    /// </ul> </li>
    /// <li> <p>Error code: <code>MalformedXMLError</code> </p>
    /// <ul>
    /// <li> <p>Description: The XML provided does not match the schema.</p> </li>
    /// </ul> </li>
    /// <li> <p>Error code: <code>OperationAbortedError </code> </p>
    /// <ul>
    /// <li> <p>Description: A conflicting conditional action is currently in progress against this resource. Please try again.</p> </li>
    /// </ul> </li>
    /// <li> <p>Error code: <code>InternalError</code> </p>
    /// <ul>
    /// <li> <p>Description: The service was unable to apply the provided tag to the bucket.</p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p>The following operations are related to <code>PutBucketTagging</code>:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketTagging.html">GetBucketTagging</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketTagging.html">DeleteBucketTagging</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutBucketTagging {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_bucket_tagging_input::Builder,
    }
    impl PutBucketTagging {
        /// Creates a new `PutBucketTagging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBucketTaggingOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBucketTaggingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The bucket name.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The bucket name.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_md5(input.into());
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_md5(input);
            self
        }
        /// <p>Container for the <code>TagSet</code> and <code>Tag</code> elements.</p>
        pub fn tagging(mut self, input: crate::model::Tagging) -> Self {
            self.inner = self.inner.tagging(input);
            self
        }
        /// <p>Container for the <code>TagSet</code> and <code>Tag</code> elements.</p>
        pub fn set_tagging(mut self, input: std::option::Option<crate::model::Tagging>) -> Self {
            self.inner = self.inner.set_tagging(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBucketVersioning`.
    ///
    /// <p>Sets the versioning state of an existing bucket. To set the versioning state, you must be the bucket owner.</p>
    /// <p>You can set the versioning state with one of the following values:</p>
    /// <p> <b>Enabled</b>—Enables versioning for the objects in the bucket. All objects added to the bucket receive a unique version ID.</p>
    /// <p> <b>Suspended</b>—Disables versioning for the objects in the bucket. All objects added to the bucket receive the version ID null.</p>
    /// <p>If the versioning state has never been set on a bucket, it has no versioning state; a <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketVersioning.html">GetBucketVersioning</a> request does not return a versioning state value.</p>
    /// <p>If the bucket owner enables MFA Delete in the bucket versioning configuration, the bucket owner must include the <code>x-amz-mfa request</code> header and the <code>Status</code> and the <code>MfaDelete</code> request elements in a request to set the versioning state of the bucket.</p> <important>
    /// <p>If you have an object expiration lifecycle policy in your non-versioned bucket and you want to maintain the same permanent delete behavior when you enable versioning, you must add a noncurrent expiration policy. The noncurrent expiration lifecycle policy will manage the deletes of the noncurrent object versions in the version-enabled bucket. (A version-enabled bucket maintains one current and zero or more noncurrent object versions.) For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html#lifecycle-and-other-bucket-config">Lifecycle and Versioning</a>.</p>
    /// </important>
    /// <p class="title"> <b>Related Resources</b> </p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html">DeleteBucket</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketVersioning.html">GetBucketVersioning</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutBucketVersioning {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_bucket_versioning_input::Builder,
    }
    impl PutBucketVersioning {
        /// Creates a new `PutBucketVersioning`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBucketVersioningOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBucketVersioningError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The bucket name.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The bucket name.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>&gt;The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_md5(input.into());
            self
        }
        /// <p>&gt;The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_md5(input);
            self
        }
        /// <p>The concatenation of the authentication device's serial number, a space, and the value that is displayed on your authentication device.</p>
        pub fn mfa(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mfa(input.into());
            self
        }
        /// <p>The concatenation of the authentication device's serial number, a space, and the value that is displayed on your authentication device.</p>
        pub fn set_mfa(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mfa(input);
            self
        }
        /// <p>Container for setting the versioning state.</p>
        pub fn versioning_configuration(
            mut self,
            input: crate::model::VersioningConfiguration,
        ) -> Self {
            self.inner = self.inner.versioning_configuration(input);
            self
        }
        /// <p>Container for setting the versioning state.</p>
        pub fn set_versioning_configuration(
            mut self,
            input: std::option::Option<crate::model::VersioningConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_versioning_configuration(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBucketWebsite`.
    ///
    /// <p>Sets the configuration of the website that is specified in the <code>website</code> subresource. To configure a bucket as a website, you can add this subresource on the bucket with website configuration information such as the file name of the index document and any redirect rules. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">Hosting Websites on Amazon S3</a>.</p>
    /// <p>This PUT action requires the <code>S3:PutBucketWebsite</code> permission. By default, only the bucket owner can configure the website attached to a bucket; however, bucket owners can allow other users to set the website configuration by writing a bucket policy that grants them the <code>S3:PutBucketWebsite</code> permission.</p>
    /// <p>To redirect all website requests sent to the bucket's website endpoint, you add a website configuration with the following elements. Because all requests are sent to another website, you don't need to provide index document name for the bucket.</p>
    /// <ul>
    /// <li> <p> <code>WebsiteConfiguration</code> </p> </li>
    /// <li> <p> <code>RedirectAllRequestsTo</code> </p> </li>
    /// <li> <p> <code>HostName</code> </p> </li>
    /// <li> <p> <code>Protocol</code> </p> </li>
    /// </ul>
    /// <p>If you want granular control over redirects, you can use the following elements to add routing rules that describe conditions for redirecting requests and information about the redirect destination. In this case, the website configuration must provide an index document for the bucket, because some requests might not be redirected. </p>
    /// <ul>
    /// <li> <p> <code>WebsiteConfiguration</code> </p> </li>
    /// <li> <p> <code>IndexDocument</code> </p> </li>
    /// <li> <p> <code>Suffix</code> </p> </li>
    /// <li> <p> <code>ErrorDocument</code> </p> </li>
    /// <li> <p> <code>Key</code> </p> </li>
    /// <li> <p> <code>RoutingRules</code> </p> </li>
    /// <li> <p> <code>RoutingRule</code> </p> </li>
    /// <li> <p> <code>Condition</code> </p> </li>
    /// <li> <p> <code>HttpErrorCodeReturnedEquals</code> </p> </li>
    /// <li> <p> <code>KeyPrefixEquals</code> </p> </li>
    /// <li> <p> <code>Redirect</code> </p> </li>
    /// <li> <p> <code>Protocol</code> </p> </li>
    /// <li> <p> <code>HostName</code> </p> </li>
    /// <li> <p> <code>ReplaceKeyPrefixWith</code> </p> </li>
    /// <li> <p> <code>ReplaceKeyWith</code> </p> </li>
    /// <li> <p> <code>HttpRedirectCode</code> </p> </li>
    /// </ul>
    /// <p>Amazon S3 has a limitation of 50 routing rules per website configuration. If you require more than 50 routing rules, you can use object redirect. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html">Configuring an Object Redirect</a> in the <i>Amazon S3 User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutBucketWebsite {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_bucket_website_input::Builder,
    }
    impl PutBucketWebsite {
        /// Creates a new `PutBucketWebsite`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBucketWebsiteOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBucketWebsiteError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The bucket name.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket(input.into());
            self
        }
        /// <p>The bucket name.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket(input);
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_md5(input.into());
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to verify that the request body was not corrupted in transit. For more information, see <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_md5(input);
            self
        }
        /// <p>Container for the request.</p>
        pub fn website_configuration(mut self, input: crate::model::WebsiteConfiguration) -> Self {
            self.inner = self.inner.website_configuration(input);
            self
        }
        /// <p>Container for the request.</p>
        pub fn set_website_configuration(
            mut self,
            input: std::option::Option<crate::model::WebsiteConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_website_configuration(input);
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_bucket_owner(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_bucket_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutObject`.
    ///
    /// <p>Adds an object to a bucket. You must have WRITE permissions on a bucket to add an object to it.</p>
    /// <p>Amazon S3 never adds partial objects; if you receive a success response, Amazon S3 added the entire object to the bucket.</p>
    /// <p>Amazon S3 is a distributed system. If it receives multiple write requests for the same object simultaneously, it overwrites all but the last object written. Amazon S3 does not provide object locking; if you need this, make sure to build it into your application layer or use versioning instead.</p>
    /// <p>To ensure that data is not corrupted traversing the network, use the <code>Content-MD5</code> header. When you use this header, Amazon S3 checks the object against the provided MD5 value and, if they do not match, returns an error. Additionally, you can calculate the MD5 while putting an object to Amazon S3 and compare the returned ETag to the calculated MD5 value.</p> <note>
    /// <ul>
    /// <li> <p>To successfully complete the <code>PutObject</code> request, you must have the <code>s3:PutObject</code> in your IAM permissions.</p> </li>
    /// <li> <p>To successfully change the objects acl of your <code>PutObject</code> request, you must have the <code>s3:PutObjectAcl</code> in your IAM permissions.</p> </li>
    /// <li> <p> The <code>Content-MD5</code> header is required for any request to upload an object with a retention period configured using Amazon S3 Object Lock. For more information about Amazon S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html">Amazon S3 Object Lock Overview</a> in the <i>Amazon S3 User Guide</i>. </p> </li>
    /// </ul>
    /// </note>
    /// <p> <b>Server-side Encryption</b> </p>
    /// <p>You can optionally request se