// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StorageClass {
    #[allow(missing_docs)] // documentation missing in model
    DeepArchive,
    #[allow(missing_docs)] // documentation missing in model
    Glacier,
    #[allow(missing_docs)] // documentation missing in model
    GlacierIr,
    #[allow(missing_docs)] // documentation missing in model
    IntelligentTiering,
    #[allow(missing_docs)] // documentation missing in model
    OnezoneIa,
    #[allow(missing_docs)] // documentation missing in model
    Outposts,
    #[allow(missing_docs)] // documentation missing in model
    ReducedRedundancy,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    #[allow(missing_docs)] // documentation missing in model
    StandardIa,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StorageClass {
    fn from(s: &str) -> Self {
        match s {
            "DEEP_ARCHIVE" => StorageClass::DeepArchive,
            "GLACIER" => StorageClass::Glacier,
            "GLACIER_IR" => StorageClass::GlacierIr,
            "INTELLIGENT_TIERING" => StorageClass::IntelligentTiering,
            "ONEZONE_IA" => StorageClass::OnezoneIa,
            "OUTPOSTS" => StorageClass::Outposts,
            "REDUCED_REDUNDANCY" => StorageClass::ReducedRedundancy,
            "STANDARD" => StorageClass::Standard,
            "STANDARD_IA" => StorageClass::StandardIa,
            other => StorageClass::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StorageClass {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StorageClass::from(s))
    }
}
impl StorageClass {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StorageClass::DeepArchive => "DEEP_ARCHIVE",
            StorageClass::Glacier => "GLACIER",
            StorageClass::GlacierIr => "GLACIER_IR",
            StorageClass::IntelligentTiering => "INTELLIGENT_TIERING",
            StorageClass::OnezoneIa => "ONEZONE_IA",
            StorageClass::Outposts => "OUTPOSTS",
            StorageClass::ReducedRedundancy => "REDUCED_REDUNDANCY",
            StorageClass::Standard => "STANDARD",
            StorageClass::StandardIa => "STANDARD_IA",
            StorageClass::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DEEP_ARCHIVE",
            "GLACIER",
            "GLACIER_IR",
            "INTELLIGENT_TIERING",
            "ONEZONE_IA",
            "OUTPOSTS",
            "REDUCED_REDUNDANCY",
            "STANDARD",
            "STANDARD_IA",
        ]
    }
}
impl AsRef<str> for StorageClass {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServerSideEncryption {
    #[allow(missing_docs)] // documentation missing in model
    Aes256,
    #[allow(missing_docs)] // documentation missing in model
    AwsKms,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServerSideEncryption {
    fn from(s: &str) -> Self {
        match s {
            "AES256" => ServerSideEncryption::Aes256,
            "aws:kms" => ServerSideEncryption::AwsKms,
            other => ServerSideEncryption::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServerSideEncryption {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServerSideEncryption::from(s))
    }
}
impl ServerSideEncryption {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServerSideEncryption::Aes256 => "AES256",
            ServerSideEncryption::AwsKms => "aws:kms",
            ServerSideEncryption::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AES256", "aws:kms"]
    }
}
impl AsRef<str> for ServerSideEncryption {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>If present, indicates that the requester was successfully charged for the
/// request.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RequestCharged {
    #[allow(missing_docs)] // documentation missing in model
    Requester,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RequestCharged {
    fn from(s: &str) -> Self {
        match s {
            "requester" => RequestCharged::Requester,
            other => RequestCharged::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RequestCharged {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RequestCharged::from(s))
    }
}
impl RequestCharged {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RequestCharged::Requester => "requester",
            RequestCharged::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["requester"]
    }
}
impl AsRef<str> for RequestCharged {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReplicationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Replica,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReplicationStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETE" => ReplicationStatus::Complete,
            "FAILED" => ReplicationStatus::Failed,
            "PENDING" => ReplicationStatus::Pending,
            "REPLICA" => ReplicationStatus::Replica,
            other => ReplicationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReplicationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReplicationStatus::from(s))
    }
}
impl ReplicationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReplicationStatus::Complete => "COMPLETE",
            ReplicationStatus::Failed => "FAILED",
            ReplicationStatus::Pending => "PENDING",
            ReplicationStatus::Replica => "REPLICA",
            ReplicationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETE", "FAILED", "PENDING", "REPLICA"]
    }
}
impl AsRef<str> for ReplicationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ObjectLockLegalHoldStatus {
    #[allow(missing_docs)] // documentation missing in model
    Off,
    #[allow(missing_docs)] // documentation missing in model
    On,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ObjectLockLegalHoldStatus {
    fn from(s: &str) -> Self {
        match s {
            "OFF" => ObjectLockLegalHoldStatus::Off,
            "ON" => ObjectLockLegalHoldStatus::On,
            other => ObjectLockLegalHoldStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ObjectLockLegalHoldStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ObjectLockLegalHoldStatus::from(s))
    }
}
impl ObjectLockLegalHoldStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ObjectLockLegalHoldStatus::Off => "OFF",
            ObjectLockLegalHoldStatus::On => "ON",
            ObjectLockLegalHoldStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OFF", "ON"]
    }
}
impl AsRef<str> for ObjectLockLegalHoldStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ObjectLockMode {
    #[allow(missing_docs)] // documentation missing in model
    Compliance,
    #[allow(missing_docs)] // documentation missing in model
    Governance,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ObjectLockMode {
    fn from(s: &str) -> Self {
        match s {
            "COMPLIANCE" => ObjectLockMode::Compliance,
            "GOVERNANCE" => ObjectLockMode::Governance,
            other => ObjectLockMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ObjectLockMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ObjectLockMode::from(s))
    }
}
impl ObjectLockMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ObjectLockMode::Compliance => "COMPLIANCE",
            ObjectLockMode::Governance => "GOVERNANCE",
            ObjectLockMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLIANCE", "GOVERNANCE"]
    }
}
impl AsRef<str> for ObjectLockMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Container for all response elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyPartResult {
    /// <p>Entity tag of the object.</p>
    pub e_tag: std::option::Option<std::string::String>,
    /// <p>Date and time at which the object was uploaded.</p>
    pub last_modified: std::option::Option<aws_smithy_types::DateTime>,
}
impl CopyPartResult {
    /// <p>Entity tag of the object.</p>
    pub fn e_tag(&self) -> std::option::Option<&str> {
        self.e_tag.as_deref()
    }
    /// <p>Date and time at which the object was uploaded.</p>
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified.as_ref()
    }
}
impl std::fmt::Debug for CopyPartResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyPartResult");
        formatter.field("e_tag", &self.e_tag);
        formatter.field("last_modified", &self.last_modified);
        formatter.finish()
    }
}
/// See [`CopyPartResult`](crate::model::CopyPartResult)
pub mod copy_part_result {
    /// A builder for [`CopyPartResult`](crate::model::CopyPartResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) e_tag: std::option::Option<std::string::String>,
        pub(crate) last_modified: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Entity tag of the object.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>Entity tag of the object.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// <p>Date and time at which the object was uploaded.</p>
        pub fn last_modified(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>Date and time at which the object was uploaded.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyPartResult`](crate::model::CopyPartResult)
        pub fn build(self) -> crate::model::CopyPartResult {
            crate::model::CopyPartResult {
                e_tag: self.e_tag,
                last_modified: self.last_modified,
            }
        }
    }
}
impl CopyPartResult {
    /// Creates a new builder-style object to manufacture [`CopyPartResult`](crate::model::CopyPartResult)
    pub fn builder() -> crate::model::copy_part_result::Builder {
        crate::model::copy_part_result::Builder::default()
    }
}

/// <p>Confirms that the requester knows that they will be charged for the request. Bucket
/// owners need not specify this parameter in their requests. For information about downloading
/// objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in
/// Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RequestPayer {
    #[allow(missing_docs)] // documentation missing in model
    Requester,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RequestPayer {
    fn from(s: &str) -> Self {
        match s {
            "requester" => RequestPayer::Requester,
            other => RequestPayer::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RequestPayer {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RequestPayer::from(s))
    }
}
impl RequestPayer {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RequestPayer::Requester => "requester",
            RequestPayer::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["requester"]
    }
}
impl AsRef<str> for RequestPayer {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The container for selecting objects from a content event stream.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum SelectObjectContentEventStream {
    /// <p>The Continuation Event.</p>
    Cont(crate::model::ContinuationEvent),
    /// <p>The End Event.</p>
    End(crate::model::EndEvent),
    /// <p>The Progress Event.</p>
    Progress(crate::model::ProgressEvent),
    /// <p>The Records Event.</p>
    Records(crate::model::RecordsEvent),
    /// <p>The Stats Event.</p>
    Stats(crate::model::StatsEvent),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl SelectObjectContentEventStream {
    /// Tries to convert the enum instance into [`Cont`](crate::model::SelectObjectContentEventStream::Cont), extracting the inner [`ContinuationEvent`](crate::model::ContinuationEvent).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_cont(&self) -> std::result::Result<&crate::model::ContinuationEvent, &Self> {
        if let SelectObjectContentEventStream::Cont(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Cont`](crate::model::SelectObjectContentEventStream::Cont).
    pub fn is_cont(&self) -> bool {
        self.as_cont().is_ok()
    }
    /// Tries to convert the enum instance into [`End`](crate::model::SelectObjectContentEventStream::End), extracting the inner [`EndEvent`](crate::model::EndEvent).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_end(&self) -> std::result::Result<&crate::model::EndEvent, &Self> {
        if let SelectObjectContentEventStream::End(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`End`](crate::model::SelectObjectContentEventStream::End).
    pub fn is_end(&self) -> bool {
        self.as_end().is_ok()
    }
    /// Tries to convert the enum instance into [`Progress`](crate::model::SelectObjectContentEventStream::Progress), extracting the inner [`ProgressEvent`](crate::model::ProgressEvent).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_progress(&self) -> std::result::Result<&crate::model::ProgressEvent, &Self> {
        if let SelectObjectContentEventStream::Progress(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Progress`](crate::model::SelectObjectContentEventStream::Progress).
    pub fn is_progress(&self) -> bool {
        self.as_progress().is_ok()
    }
    /// Tries to convert the enum instance into [`Records`](crate::model::SelectObjectContentEventStream::Records), extracting the inner [`RecordsEvent`](crate::model::RecordsEvent).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_records(&self) -> std::result::Result<&crate::model::RecordsEvent, &Self> {
        if let SelectObjectContentEventStream::Records(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Records`](crate::model::SelectObjectContentEventStream::Records).
    pub fn is_records(&self) -> bool {
        self.as_records().is_ok()
    }
    /// Tries to convert the enum instance into [`Stats`](crate::model::SelectObjectContentEventStream::Stats), extracting the inner [`StatsEvent`](crate::model::StatsEvent).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_stats(&self) -> std::result::Result<&crate::model::StatsEvent, &Self> {
        if let SelectObjectContentEventStream::Stats(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Stats`](crate::model::SelectObjectContentEventStream::Stats).
    pub fn is_stats(&self) -> bool {
        self.as_stats().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>A message that indicates the request is complete and no more messages will be sent. You should not assume that the request is complete until the client receives an <code>EndEvent</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndEvent {}
impl std::fmt::Debug for EndEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndEvent");
        formatter.finish()
    }
}
/// See [`EndEvent`](crate::model::EndEvent)
pub mod end_event {
    /// A builder for [`EndEvent`](crate::model::EndEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`EndEvent`](crate::model::EndEvent)
        pub fn build(self) -> crate::model::EndEvent {
            crate::model::EndEvent {}
        }
    }
}
impl EndEvent {
    /// Creates a new builder-style object to manufacture [`EndEvent`](crate::model::EndEvent)
    pub fn builder() -> crate::model::end_event::Builder {
        crate::model::end_event::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContinuationEvent {}
impl std::fmt::Debug for ContinuationEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContinuationEvent");
        formatter.finish()
    }
}
/// See [`ContinuationEvent`](crate::model::ContinuationEvent)
pub mod continuation_event {
    /// A builder for [`ContinuationEvent`](crate::model::ContinuationEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ContinuationEvent`](crate::model::ContinuationEvent)
        pub fn build(self) -> crate::model::ContinuationEvent {
            crate::model::ContinuationEvent {}
        }
    }
}
impl ContinuationEvent {
    /// Creates a new builder-style object to manufacture [`ContinuationEvent`](crate::model::ContinuationEvent)
    pub fn builder() -> crate::model::continuation_event::Builder {
        crate::model::continuation_event::Builder::default()
    }
}

/// <p>This data type contains information about the progress event of an operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProgressEvent {
    /// <p>The Progress event details.</p>
    pub details: std::option::Option<crate::model::Progress>,
}
impl ProgressEvent {
    /// <p>The Progress event details.</p>
    pub fn details(&self) -> std::option::Option<&crate::model::Progress> {
        self.details.as_ref()
    }
}
impl std::fmt::Debug for ProgressEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProgressEvent");
        formatter.field("details", &self.details);
        formatter.finish()
    }
}
/// See [`ProgressEvent`](crate::model::ProgressEvent)
pub mod progress_event {
    /// A builder for [`ProgressEvent`](crate::model::ProgressEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) details: std::option::Option<crate::model::Progress>,
    }
    impl Builder {
        /// <p>The Progress event details.</p>
        pub fn details(mut self, input: crate::model::Progress) -> Self {
            self.details = Some(input);
            self
        }
        /// <p>The Progress event details.</p>
        pub fn set_details(mut self, input: std::option::Option<crate::model::Progress>) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`ProgressEvent`](crate::model::ProgressEvent)
        pub fn build(self) -> crate::model::ProgressEvent {
            crate::model::ProgressEvent {
                details: self.details,
            }
        }
    }
}
impl ProgressEvent {
    /// Creates a new builder-style object to manufacture [`ProgressEvent`](crate::model::ProgressEvent)
    pub fn builder() -> crate::model::progress_event::Builder {
        crate::model::progress_event::Builder::default()
    }
}

/// <p>This data type contains information about progress of an operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Progress {
    /// <p>The current number of object bytes scanned.</p>
    pub bytes_scanned: i64,
    /// <p>The current number of uncompressed object bytes processed.</p>
    pub bytes_processed: i64,
    /// <p>The current number of bytes of records payload data returned.</p>
    pub bytes_returned: i64,
}
impl Progress {
    /// <p>The current number of object bytes scanned.</p>
    pub fn bytes_scanned(&self) -> i64 {
        self.bytes_scanned
    }
    /// <p>The current number of uncompressed object bytes processed.</p>
    pub fn bytes_processed(&self) -> i64 {
        self.bytes_processed
    }
    /// <p>The current number of bytes of records payload data returned.</p>
    pub fn bytes_returned(&self) -> i64 {
        self.bytes_returned
    }
}
impl std::fmt::Debug for Progress {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Progress");
        formatter.field("bytes_scanned", &self.bytes_scanned);
        formatter.field("bytes_processed", &self.bytes_processed);
        formatter.field("bytes_returned", &self.bytes_returned);
        formatter.finish()
    }
}
/// See [`Progress`](crate::model::Progress)
pub mod progress {
    /// A builder for [`Progress`](crate::model::Progress)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bytes_scanned: std::option::Option<i64>,
        pub(crate) bytes_processed: std::option::Option<i64>,
        pub(crate) bytes_returned: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The current number of object bytes scanned.</p>
        pub fn bytes_scanned(mut self, input: i64) -> Self {
            self.bytes_scanned = Some(input);
            self
        }
        /// <p>The current number of object bytes scanned.</p>
        pub fn set_bytes_scanned(mut self, input: std::option::Option<i64>) -> Self {
            self.bytes_scanned = input;
            self
        }
        /// <p>The current number of uncompressed object bytes processed.</p>
        pub fn bytes_processed(mut self, input: i64) -> Self {
            self.bytes_processed = Some(input);
            self
        }
        /// <p>The current number of uncompressed object bytes processed.</p>
        pub fn set_bytes_processed(mut self, input: std::option::Option<i64>) -> Self {
            self.bytes_processed = input;
            self
        }
        /// <p>The current number of bytes of records payload data returned.</p>
        pub fn bytes_returned(mut self, input: i64) -> Self {
            self.bytes_returned = Some(input);
            self
        }
        /// <p>The current number of bytes of records payload data returned.</p>
        pub fn set_bytes_returned(mut self, input: std::option::Option<i64>) -> Self {
            self.bytes_returned = input;
            self
        }
        /// Consumes the builder and constructs a [`Progress`](crate::model::Progress)
        pub fn build(self) -> crate::model::Progress {
            crate::model::Progress {
                bytes_scanned: self.bytes_scanned.unwrap_or_default(),
                bytes_processed: self.bytes_processed.unwrap_or_default(),
                bytes_returned: self.bytes_returned.unwrap_or_default(),
            }
        }
    }
}
impl Progress {
    /// Creates a new builder-style object to manufacture [`Progress`](crate::model::Progress)
    pub fn builder() -> crate::model::progress::Builder {
        crate::model::progress::Builder::default()
    }
}

/// <p>Container for the Stats Event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StatsEvent {
    /// <p>The Stats event details.</p>
    pub details: std::option::Option<crate::model::Stats>,
}
impl StatsEvent {
    /// <p>The Stats event details.</p>
    pub fn details(&self) -> std::option::Option<&crate::model::Stats> {
        self.details.as_ref()
    }
}
impl std::fmt::Debug for StatsEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StatsEvent");
        formatter.field("details", &self.details);
        formatter.finish()
    }
}
/// See [`StatsEvent`](crate::model::StatsEvent)
pub mod stats_event {
    /// A builder for [`StatsEvent`](crate::model::StatsEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) details: std::option::Option<crate::model::Stats>,
    }
    impl Builder {
        /// <p>The Stats event details.</p>
        pub fn details(mut self, input: crate::model::Stats) -> Self {
            self.details = Some(input);
            self
        }
        /// <p>The Stats event details.</p>
        pub fn set_details(mut self, input: std::option::Option<crate::model::Stats>) -> Self {
            self.details = input;
            self
        }
        /// Consumes the builder and constructs a [`StatsEvent`](crate::model::StatsEvent)
        pub fn build(self) -> crate::model::StatsEvent {
            crate::model::StatsEvent {
                details: self.details,
            }
        }
    }
}
impl StatsEvent {
    /// Creates a new builder-style object to manufacture [`StatsEvent`](crate::model::StatsEvent)
    pub fn builder() -> crate::model::stats_event::Builder {
        crate::model::stats_event::Builder::default()
    }
}

/// <p>Container for the stats details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Stats {
    /// <p>The total number of object bytes scanned.</p>
    pub bytes_scanned: i64,
    /// <p>The total number of uncompressed object bytes processed.</p>
    pub bytes_processed: i64,
    /// <p>The total number of bytes of records payload data returned.</p>
    pub bytes_returned: i64,
}
impl Stats {
    /// <p>The total number of object bytes scanned.</p>
    pub fn bytes_scanned(&self) -> i64 {
        self.bytes_scanned
    }
    /// <p>The total number of uncompressed object bytes processed.</p>
    pub fn bytes_processed(&self) -> i64 {
        self.bytes_processed
    }
    /// <p>The total number of bytes of records payload data returned.</p>
    pub fn bytes_returned(&self) -> i64 {
        self.bytes_returned
    }
}
impl std::fmt::Debug for Stats {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Stats");
        formatter.field("bytes_scanned", &self.bytes_scanned);
        formatter.field("bytes_processed", &self.bytes_processed);
        formatter.field("bytes_returned", &self.bytes_returned);
        formatter.finish()
    }
}
/// See [`Stats`](crate::model::Stats)
pub mod stats {
    /// A builder for [`Stats`](crate::model::Stats)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bytes_scanned: std::option::Option<i64>,
        pub(crate) bytes_processed: std::option::Option<i64>,
        pub(crate) bytes_returned: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The total number of object bytes scanned.</p>
        pub fn bytes_scanned(mut self, input: i64) -> Self {
            self.bytes_scanned = Some(input);
            self
        }
        /// <p>The total number of object bytes scanned.</p>
        pub fn set_bytes_scanned(mut self, input: std::option::Option<i64>) -> Self {
            self.bytes_scanned = input;
            self
        }
        /// <p>The total number of uncompressed object bytes processed.</p>
        pub fn bytes_processed(mut self, input: i64) -> Self {
            self.bytes_processed = Some(input);
            self
        }
        /// <p>The total number of uncompressed object bytes processed.</p>
        pub fn set_bytes_processed(mut self, input: std::option::Option<i64>) -> Self {
            self.bytes_processed = input;
            self
        }
        /// <p>The total number of bytes of records payload data returned.</p>
        pub fn bytes_returned(mut self, input: i64) -> Self {
            self.bytes_returned = Some(input);
            self
        }
        /// <p>The total number of bytes of records payload data returned.</p>
        pub fn set_bytes_returned(mut self, input: std::option::Option<i64>) -> Self {
            self.bytes_returned = input;
            self
        }
        /// Consumes the builder and constructs a [`Stats`](crate::model::Stats)
        pub fn build(self) -> crate::model::Stats {
            crate::model::Stats {
                bytes_scanned: self.bytes_scanned.unwrap_or_default(),
                bytes_processed: self.bytes_processed.unwrap_or_default(),
                bytes_returned: self.bytes_returned.unwrap_or_default(),
            }
        }
    }
}
impl Stats {
    /// Creates a new builder-style object to manufacture [`Stats`](crate::model::Stats)
    pub fn builder() -> crate::model::stats::Builder {
        crate::model::stats::Builder::default()
    }
}

/// <p>The container for the records event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecordsEvent {
    /// <p>The byte array of partial, one or more result records.</p>
    pub payload: std::option::Option<aws_smithy_types::Blob>,
}
impl RecordsEvent {
    /// <p>The byte array of partial, one or more result records.</p>
    pub fn payload(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.payload.as_ref()
    }
}
impl std::fmt::Debug for RecordsEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecordsEvent");
        formatter.field("payload", &self.payload);
        formatter.finish()
    }
}
/// See [`RecordsEvent`](crate::model::RecordsEvent)
pub mod records_event {
    /// A builder for [`RecordsEvent`](crate::model::RecordsEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) payload: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>The byte array of partial, one or more result records.</p>
        pub fn payload(mut self, input: aws_smithy_types::Blob) -> Self {
            self.payload = Some(input);
            self
        }
        /// <p>The byte array of partial, one or more result records.</p>
        pub fn set_payload(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.payload = input;
            self
        }
        /// Consumes the builder and constructs a [`RecordsEvent`](crate::model::RecordsEvent)
        pub fn build(self) -> crate::model::RecordsEvent {
            crate::model::RecordsEvent {
                payload: self.payload,
            }
        }
    }
}
impl RecordsEvent {
    /// Creates a new builder-style object to manufacture [`RecordsEvent`](crate::model::RecordsEvent)
    pub fn builder() -> crate::model::records_event::Builder {
        crate::model::records_event::Builder::default()
    }
}

/// <p>Specifies the byte range of the object to get the records from. A record is processed when its first byte is contained by the range. This parameter is optional, but when specified, it must not be empty. See RFC 2616, Section 14.35.1 about how to specify the start and end of the range.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScanRange {
    /// <p>Specifies the start of the byte range. This parameter is optional. Valid values: non-negative integers. The default value is 0. If only start is supplied, it means scan from that point to the end of the file.For example; <code>
    /// <scanrange>
    /// <start>
    /// 50
    /// </start>
    /// </scanrange></code> means scan from byte 50 until the end of the file.</p>
    pub start: i64,
    /// <p>Specifies the end of the byte range. This parameter is optional. Valid values: non-negative integers. The default value is one less than the size of the object being queried. If only the End parameter is supplied, it is interpreted to mean scan the last N bytes of the file. For example, <code>
    /// <scanrange>
    /// <end>
    /// 50
    /// </end>
    /// </scanrange></code> means scan the last 50 bytes.</p>
    pub end: i64,
}
impl ScanRange {
    /// <p>Specifies the start of the byte range. This parameter is optional. Valid values: non-negative integers. The default value is 0. If only start is supplied, it means scan from that point to the end of the file.For example; <code>
    /// <scanrange>
    /// <start>
    /// 50
    /// </start>
    /// </scanrange></code> means scan from byte 50 until the end of the file.</p>
    pub fn start(&self) -> i64 {
        self.start
    }
    /// <p>Specifies the end of the byte range. This parameter is optional. Valid values: non-negative integers. The default value is one less than the size of the object being queried. If only the End parameter is supplied, it is interpreted to mean scan the last N bytes of the file. For example, <code>
    /// <scanrange>
    /// <end>
    /// 50
    /// </end>
    /// </scanrange></code> means scan the last 50 bytes.</p>
    pub fn end(&self) -> i64 {
        self.end
    }
}
impl std::fmt::Debug for ScanRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScanRange");
        formatter.field("start", &self.start);
        formatter.field("end", &self.end);
        formatter.finish()
    }
}
/// See [`ScanRange`](crate::model::ScanRange)
pub mod scan_range {
    /// A builder for [`ScanRange`](crate::model::ScanRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start: std::option::Option<i64>,
        pub(crate) end: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Specifies the start of the byte range. This parameter is optional. Valid values: non-negative integers. The default value is 0. If only start is supplied, it means scan from that point to the end of the file.For example; <code>
        /// <scanrange>
        /// <start>
        /// 50
        /// </start>
        /// </scanrange></code> means scan from byte 50 until the end of the file.</p>
        pub fn start(mut self, input: i64) -> Self {
            self.start = Some(input);
            self
        }
        /// <p>Specifies the start of the byte range. This parameter is optional. Valid values: non-negative integers. The default value is 0. If only start is supplied, it means scan from that point to the end of the file.For example; <code>
        /// <scanrange>
        /// <start>
        /// 50
        /// </start>
        /// </scanrange></code> means scan from byte 50 until the end of the file.</p>
        pub fn set_start(mut self, input: std::option::Option<i64>) -> Self {
            self.start = input;
            self
        }
        /// <p>Specifies the end of the byte range. This parameter is optional. Valid values: non-negative integers. The default value is one less than the size of the object being queried. If only the End parameter is supplied, it is interpreted to mean scan the last N bytes of the file. For example, <code>
        /// <scanrange>
        /// <end>
        /// 50
        /// </end>
        /// </scanrange></code> means scan the last 50 bytes.</p>
        pub fn end(mut self, input: i64) -> Self {
            self.end = Some(input);
            self
        }
        /// <p>Specifies the end of the byte range. This parameter is optional. Valid values: non-negative integers. The default value is one less than the size of the object being queried. If only the End parameter is supplied, it is interpreted to mean scan the last N bytes of the file. For example, <code>
        /// <scanrange>
        /// <end>
        /// 50
        /// </end>
        /// </scanrange></code> means scan the last 50 bytes.</p>
        pub fn set_end(mut self, input: std::option::Option<i64>) -> Self {
            self.end = input;
            self
        }
        /// Consumes the builder and constructs a [`ScanRange`](crate::model::ScanRange)
        pub fn build(self) -> crate::model::ScanRange {
            crate::model::ScanRange {
                start: self.start.unwrap_or_default(),
                end: self.end.unwrap_or_default(),
            }
        }
    }
}
impl ScanRange {
    /// Creates a new builder-style object to manufacture [`ScanRange`](crate::model::ScanRange)
    pub fn builder() -> crate::model::scan_range::Builder {
        crate::model::scan_range::Builder::default()
    }
}

/// <p>Describes how results of the Select job are serialized.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutputSerialization {
    /// <p>Describes the serialization of CSV-encoded Select results.</p>
    pub csv: std::option::Option<crate::model::CsvOutput>,
    /// <p>Specifies JSON as request's output serialization format.</p>
    pub json: std::option::Option<crate::model::JsonOutput>,
}
impl OutputSerialization {
    /// <p>Describes the serialization of CSV-encoded Select results.</p>
    pub fn csv(&self) -> std::option::Option<&crate::model::CsvOutput> {
        self.csv.as_ref()
    }
    /// <p>Specifies JSON as request's output serialization format.</p>
    pub fn json(&self) -> std::option::Option<&crate::model::JsonOutput> {
        self.json.as_ref()
    }
}
impl std::fmt::Debug for OutputSerialization {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutputSerialization");
        formatter.field("csv", &self.csv);
        formatter.field("json", &self.json);
        formatter.finish()
    }
}
/// See [`OutputSerialization`](crate::model::OutputSerialization)
pub mod output_serialization {
    /// A builder for [`OutputSerialization`](crate::model::OutputSerialization)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) csv: std::option::Option<crate::model::CsvOutput>,
        pub(crate) json: std::option::Option<crate::model::JsonOutput>,
    }
    impl Builder {
        /// <p>Describes the serialization of CSV-encoded Select results.</p>
        pub fn csv(mut self, input: crate::model::CsvOutput) -> Self {
            self.csv = Some(input);
            self
        }
        /// <p>Describes the serialization of CSV-encoded Select results.</p>
        pub fn set_csv(mut self, input: std::option::Option<crate::model::CsvOutput>) -> Self {
            self.csv = input;
            self
        }
        /// <p>Specifies JSON as request's output serialization format.</p>
        pub fn json(mut self, input: crate::model::JsonOutput) -> Self {
            self.json = Some(input);
            self
        }
        /// <p>Specifies JSON as request's output serialization format.</p>
        pub fn set_json(mut self, input: std::option::Option<crate::model::JsonOutput>) -> Self {
            self.json = input;
            self
        }
        /// Consumes the builder and constructs a [`OutputSerialization`](crate::model::OutputSerialization)
        pub fn build(self) -> crate::model::OutputSerialization {
            crate::model::OutputSerialization {
                csv: self.csv,
                json: self.json,
            }
        }
    }
}
impl OutputSerialization {
    /// Creates a new builder-style object to manufacture [`OutputSerialization`](crate::model::OutputSerialization)
    pub fn builder() -> crate::model::output_serialization::Builder {
        crate::model::output_serialization::Builder::default()
    }
}

/// <p>Specifies JSON as request's output serialization format.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JsonOutput {
    /// <p>The value used to separate individual records in the output. If no value is specified, Amazon S3 uses a newline character ('\n').</p>
    pub record_delimiter: std::option::Option<std::string::String>,
}
impl JsonOutput {
    /// <p>The value used to separate individual records in the output. If no value is specified, Amazon S3 uses a newline character ('\n').</p>
    pub fn record_delimiter(&self) -> std::option::Option<&str> {
        self.record_delimiter.as_deref()
    }
}
impl std::fmt::Debug for JsonOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JsonOutput");
        formatter.field("record_delimiter", &self.record_delimiter);
        formatter.finish()
    }
}
/// See [`JsonOutput`](crate::model::JsonOutput)
pub mod json_output {
    /// A builder for [`JsonOutput`](crate::model::JsonOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) record_delimiter: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The value used to separate individual records in the output. If no value is specified, Amazon S3 uses a newline character ('\n').</p>
        pub fn record_delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.record_delimiter = Some(input.into());
            self
        }
        /// <p>The value used to separate individual records in the output. If no value is specified, Amazon S3 uses a newline character ('\n').</p>
        pub fn set_record_delimiter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.record_delimiter = input;
            self
        }
        /// Consumes the builder and constructs a [`JsonOutput`](crate::model::JsonOutput)
        pub fn build(self) -> crate::model::JsonOutput {
            crate::model::JsonOutput {
                record_delimiter: self.record_delimiter,
            }
        }
    }
}
impl JsonOutput {
    /// Creates a new builder-style object to manufacture [`JsonOutput`](crate::model::JsonOutput)
    pub fn builder() -> crate::model::json_output::Builder {
        crate::model::json_output::Builder::default()
    }
}

/// <p>Describes how uncompressed comma-separated values (CSV)-formatted results are formatted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CsvOutput {
    /// <p>Indicates whether to use quotation marks around output fields. </p>
    /// <ul>
    /// <li> <p> <code>ALWAYS</code>: Always use quotation marks for output fields.</p> </li>
    /// <li> <p> <code>ASNEEDED</code>: Use quotation marks for output fields when needed.</p> </li>
    /// </ul>
    pub quote_fields: std::option::Option<crate::model::QuoteFields>,
    /// <p>The single character used for escaping the quote character inside an already escaped value.</p>
    pub quote_escape_character: std::option::Option<std::string::String>,
    /// <p>A single character used to separate individual records in the output. Instead of the default value, you can specify an arbitrary delimiter.</p>
    pub record_delimiter: std::option::Option<std::string::String>,
    /// <p>The value used to separate individual fields in a record. You can specify an arbitrary delimiter.</p>
    pub field_delimiter: std::option::Option<std::string::String>,
    /// <p>A single character used for escaping when the field delimiter is part of the value. For example, if the value is <code>a, b</code>, Amazon S3 wraps this field value in quotation marks, as follows: <code>" a , b "</code>.</p>
    pub quote_character: std::option::Option<std::string::String>,
}
impl CsvOutput {
    /// <p>Indicates whether to use quotation marks around output fields. </p>
    /// <ul>
    /// <li> <p> <code>ALWAYS</code>: Always use quotation marks for output fields.</p> </li>
    /// <li> <p> <code>ASNEEDED</code>: Use quotation marks for output fields when needed.</p> </li>
    /// </ul>
    pub fn quote_fields(&self) -> std::option::Option<&crate::model::QuoteFields> {
        self.quote_fields.as_ref()
    }
    /// <p>The single character used for escaping the quote character inside an already escaped value.</p>
    pub fn quote_escape_character(&self) -> std::option::Option<&str> {
        self.quote_escape_character.as_deref()
    }
    /// <p>A single character used to separate individual records in the output. Instead of the default value, you can specify an arbitrary delimiter.</p>
    pub fn record_delimiter(&self) -> std::option::Option<&str> {
        self.record_delimiter.as_deref()
    }
    /// <p>The value used to separate individual fields in a record. You can specify an arbitrary delimiter.</p>
    pub fn field_delimiter(&self) -> std::option::Option<&str> {
        self.field_delimiter.as_deref()
    }
    /// <p>A single character used for escaping when the field delimiter is part of the value. For example, if the value is <code>a, b</code>, Amazon S3 wraps this field value in quotation marks, as follows: <code>" a , b "</code>.</p>
    pub fn quote_character(&self) -> std::option::Option<&str> {
        self.quote_character.as_deref()
    }
}
impl std::fmt::Debug for CsvOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CsvOutput");
        formatter.field("quote_fields", &self.quote_fields);
        formatter.field("quote_escape_character", &self.quote_escape_character);
        formatter.field("record_delimiter", &self.record_delimiter);
        formatter.field("field_delimiter", &self.field_delimiter);
        formatter.field("quote_character", &self.quote_character);
        formatter.finish()
    }
}
/// See [`CsvOutput`](crate::model::CsvOutput)
pub mod csv_output {
    /// A builder for [`CsvOutput`](crate::model::CsvOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) quote_fields: std::option::Option<crate::model::QuoteFields>,
        pub(crate) quote_escape_character: std::option::Option<std::string::String>,
        pub(crate) record_delimiter: std::option::Option<std::string::String>,
        pub(crate) field_delimiter: std::option::Option<std::string::String>,
        pub(crate) quote_character: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates whether to use quotation marks around output fields. </p>
        /// <ul>
        /// <li> <p> <code>ALWAYS</code>: Always use quotation marks for output fields.</p> </li>
        /// <li> <p> <code>ASNEEDED</code>: Use quotation marks for output fields when needed.</p> </li>
        /// </ul>
        pub fn quote_fields(mut self, input: crate::model::QuoteFields) -> Self {
            self.quote_fields = Some(input);
            self
        }
        /// <p>Indicates whether to use quotation marks around output fields. </p>
        /// <ul>
        /// <li> <p> <code>ALWAYS</code>: Always use quotation marks for output fields.</p> </li>
        /// <li> <p> <code>ASNEEDED</code>: Use quotation marks for output fields when needed.</p> </li>
        /// </ul>
        pub fn set_quote_fields(
            mut self,
            input: std::option::Option<crate::model::QuoteFields>,
        ) -> Self {
            self.quote_fields = input;
            self
        }
        /// <p>The single character used for escaping the quote character inside an already escaped value.</p>
        pub fn quote_escape_character(mut self, input: impl Into<std::string::String>) -> Self {
            self.quote_escape_character = Some(input.into());
            self
        }
        /// <p>The single character used for escaping the quote character inside an already escaped value.</p>
        pub fn set_quote_escape_character(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.quote_escape_character = input;
            self
        }
        /// <p>A single character used to separate individual records in the output. Instead of the default value, you can specify an arbitrary delimiter.</p>
        pub fn record_delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.record_delimiter = Some(input.into());
            self
        }
        /// <p>A single character used to separate individual records in the output. Instead of the default value, you can specify an arbitrary delimiter.</p>
        pub fn set_record_delimiter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.record_delimiter = input;
            self
        }
        /// <p>The value used to separate individual fields in a record. You can specify an arbitrary delimiter.</p>
        pub fn field_delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.field_delimiter = Some(input.into());
            self
        }
        /// <p>The value used to separate individual fields in a record. You can specify an arbitrary delimiter.</p>
        pub fn set_field_delimiter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.field_delimiter = input;
            self
        }
        /// <p>A single character used for escaping when the field delimiter is part of the value. For example, if the value is <code>a, b</code>, Amazon S3 wraps this field value in quotation marks, as follows: <code>" a , b "</code>.</p>
        pub fn quote_character(mut self, input: impl Into<std::string::String>) -> Self {
            self.quote_character = Some(input.into());
            self
        }
        /// <p>A single character used for escaping when the field delimiter is part of the value. For example, if the value is <code>a, b</code>, Amazon S3 wraps this field value in quotation marks, as follows: <code>" a , b "</code>.</p>
        pub fn set_quote_character(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.quote_character = input;
            self
        }
        /// Consumes the builder and constructs a [`CsvOutput`](crate::model::CsvOutput)
        pub fn build(self) -> crate::model::CsvOutput {
            crate::model::CsvOutput {
                quote_fields: self.quote_fields,
                quote_escape_character: self.quote_escape_character,
                record_delimiter: self.record_delimiter,
                field_delimiter: self.field_delimiter,
                quote_character: self.quote_character,
            }
        }
    }
}
impl CsvOutput {
    /// Creates a new builder-style object to manufacture [`CsvOutput`](crate::model::CsvOutput)
    pub fn builder() -> crate::model::csv_output::Builder {
        crate::model::csv_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum QuoteFields {
    #[allow(missing_docs)] // documentation missing in model
    Always,
    #[allow(missing_docs)] // documentation missing in model
    Asneeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for QuoteFields {
    fn from(s: &str) -> Self {
        match s {
            "ALWAYS" => QuoteFields::Always,
            "ASNEEDED" => QuoteFields::Asneeded,
            other => QuoteFields::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for QuoteFields {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(QuoteFields::from(s))
    }
}
impl QuoteFields {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            QuoteFields::Always => "ALWAYS",
            QuoteFields::Asneeded => "ASNEEDED",
            QuoteFields::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALWAYS", "ASNEEDED"]
    }
}
impl AsRef<str> for QuoteFields {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the serialization format of the object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputSerialization {
    /// <p>Describes the serialization of a CSV-encoded object.</p>
    pub csv: std::option::Option<crate::model::CsvInput>,
    /// <p>Specifies object's compression format. Valid values: NONE, GZIP, BZIP2. Default Value: NONE.</p>
    pub compression_type: std::option::Option<crate::model::CompressionType>,
    /// <p>Specifies JSON as object's input serialization format.</p>
    pub json: std::option::Option<crate::model::JsonInput>,
    /// <p>Specifies Parquet as object's input serialization format.</p>
    pub parquet: std::option::Option<crate::model::ParquetInput>,
}
impl InputSerialization {
    /// <p>Describes the serialization of a CSV-encoded object.</p>
    pub fn csv(&self) -> std::option::Option<&crate::model::CsvInput> {
        self.csv.as_ref()
    }
    /// <p>Specifies object's compression format. Valid values: NONE, GZIP, BZIP2. Default Value: NONE.</p>
    pub fn compression_type(&self) -> std::option::Option<&crate::model::CompressionType> {
        self.compression_type.as_ref()
    }
    /// <p>Specifies JSON as object's input serialization format.</p>
    pub fn json(&self) -> std::option::Option<&crate::model::JsonInput> {
        self.json.as_ref()
    }
    /// <p>Specifies Parquet as object's input serialization format.</p>
    pub fn parquet(&self) -> std::option::Option<&crate::model::ParquetInput> {
        self.parquet.as_ref()
    }
}
impl std::fmt::Debug for InputSerialization {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputSerialization");
        formatter.field("csv", &self.csv);
        formatter.field("compression_type", &self.compression_type);
        formatter.field("json", &self.json);
        formatter.field("parquet", &self.parquet);
        formatter.finish()
    }
}
/// See [`InputSerialization`](crate::model::InputSerialization)
pub mod input_serialization {
    /// A builder for [`InputSerialization`](crate::model::InputSerialization)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) csv: std::option::Option<crate::model::CsvInput>,
        pub(crate) compression_type: std::option::Option<crate::model::CompressionType>,
        pub(crate) json: std::option::Option<crate::model::JsonInput>,
        pub(crate) parquet: std::option::Option<crate::model::ParquetInput>,
    }
    impl Builder {
        /// <p>Describes the serialization of a CSV-encoded object.</p>
        pub fn csv(mut self, input: crate::model::CsvInput) -> Self {
            self.csv = Some(input);
            self
        }
        /// <p>Describes the serialization of a CSV-encoded object.</p>
        pub fn set_csv(mut self, input: std::option::Option<crate::model::CsvInput>) -> Self {
            self.csv = input;
            self
        }
        /// <p>Specifies object's compression format. Valid values: NONE, GZIP, BZIP2. Default Value: NONE.</p>
        pub fn compression_type(mut self, input: crate::model::CompressionType) -> Self {
            self.compression_type = Some(input);
            self
        }
        /// <p>Specifies object's compression format. Valid values: NONE, GZIP, BZIP2. Default Value: NONE.</p>
        pub fn set_compression_type(
            mut self,
            input: std::option::Option<crate::model::CompressionType>,
        ) -> Self {
            self.compression_type = input;
            self
        }
        /// <p>Specifies JSON as object's input serialization format.</p>
        pub fn json(mut self, input: crate::model::JsonInput) -> Self {
            self.json = Some(input);
            self
        }
        /// <p>Specifies JSON as object's input serialization format.</p>
        pub fn set_json(mut self, input: std::option::Option<crate::model::JsonInput>) -> Self {
            self.json = input;
            self
        }
        /// <p>Specifies Parquet as object's input serialization format.</p>
        pub fn parquet(mut self, input: crate::model::ParquetInput) -> Self {
            self.parquet = Some(input);
            self
        }
        /// <p>Specifies Parquet as object's input serialization format.</p>
        pub fn set_parquet(
            mut self,
            input: std::option::Option<crate::model::ParquetInput>,
        ) -> Self {
            self.parquet = input;
            self
        }
        /// Consumes the builder and constructs a [`InputSerialization`](crate::model::InputSerialization)
        pub fn build(self) -> crate::model::InputSerialization {
            crate::model::InputSerialization {
                csv: self.csv,
                compression_type: self.compression_type,
                json: self.json,
                parquet: self.parquet,
            }
        }
    }
}
impl InputSerialization {
    /// Creates a new builder-style object to manufacture [`InputSerialization`](crate::model::InputSerialization)
    pub fn builder() -> crate::model::input_serialization::Builder {
        crate::model::input_serialization::Builder::default()
    }
}

/// <p>Container for Parquet.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ParquetInput {}
impl std::fmt::Debug for ParquetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ParquetInput");
        formatter.finish()
    }
}
/// See [`ParquetInput`](crate::model::ParquetInput)
pub mod parquet_input {
    /// A builder for [`ParquetInput`](crate::model::ParquetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ParquetInput`](crate::model::ParquetInput)
        pub fn build(self) -> crate::model::ParquetInput {
            crate::model::ParquetInput {}
        }
    }
}
impl ParquetInput {
    /// Creates a new builder-style object to manufacture [`ParquetInput`](crate::model::ParquetInput)
    pub fn builder() -> crate::model::parquet_input::Builder {
        crate::model::parquet_input::Builder::default()
    }
}

/// <p>Specifies JSON as object's input serialization format.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JsonInput {
    /// <p>The type of JSON. Valid values: Document, Lines.</p>
    pub r#type: std::option::Option<crate::model::JsonType>,
}
impl JsonInput {
    /// <p>The type of JSON. Valid values: Document, Lines.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::JsonType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for JsonInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JsonInput");
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`JsonInput`](crate::model::JsonInput)
pub mod json_input {
    /// A builder for [`JsonInput`](crate::model::JsonInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::JsonType>,
    }
    impl Builder {
        /// <p>The type of JSON. Valid values: Document, Lines.</p>
        pub fn r#type(mut self, input: crate::model::JsonType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of JSON. Valid values: Document, Lines.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::JsonType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`JsonInput`](crate::model::JsonInput)
        pub fn build(self) -> crate::model::JsonInput {
            crate::model::JsonInput {
                r#type: self.r#type,
            }
        }
    }
}
impl JsonInput {
    /// Creates a new builder-style object to manufacture [`JsonInput`](crate::model::JsonInput)
    pub fn builder() -> crate::model::json_input::Builder {
        crate::model::json_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JsonType {
    #[allow(missing_docs)] // documentation missing in model
    Document,
    #[allow(missing_docs)] // documentation missing in model
    Lines,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JsonType {
    fn from(s: &str) -> Self {
        match s {
            "DOCUMENT" => JsonType::Document,
            "LINES" => JsonType::Lines,
            other => JsonType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JsonType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JsonType::from(s))
    }
}
impl JsonType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JsonType::Document => "DOCUMENT",
            JsonType::Lines => "LINES",
            JsonType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DOCUMENT", "LINES"]
    }
}
impl AsRef<str> for JsonType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CompressionType {
    #[allow(missing_docs)] // documentation missing in model
    Bzip2,
    #[allow(missing_docs)] // documentation missing in model
    Gzip,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CompressionType {
    fn from(s: &str) -> Self {
        match s {
            "BZIP2" => CompressionType::Bzip2,
            "GZIP" => CompressionType::Gzip,
            "NONE" => CompressionType::None,
            other => CompressionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CompressionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CompressionType::from(s))
    }
}
impl CompressionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CompressionType::Bzip2 => "BZIP2",
            CompressionType::Gzip => "GZIP",
            CompressionType::None => "NONE",
            CompressionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BZIP2", "GZIP", "NONE"]
    }
}
impl AsRef<str> for CompressionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes how an uncompressed comma-separated values (CSV)-formatted input object is formatted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CsvInput {
    /// <p>Describes the first line of input. Valid values are:</p>
    /// <ul>
    /// <li> <p> <code>NONE</code>: First line is not a header.</p> </li>
    /// <li> <p> <code>IGNORE</code>: First line is a header, but you can't use the header values to indicate the column in an expression. You can use column position (such as _1, _2, …) to indicate the column (<code>SELECT s._1 FROM OBJECT s</code>).</p> </li>
    /// <li> <p> <code>Use</code>: First line is a header, and you can use the header value to identify a column in an expression (<code>SELECT "name" FROM OBJECT</code>). </p> </li>
    /// </ul>
    pub file_header_info: std::option::Option<crate::model::FileHeaderInfo>,
    /// <p>A single character used to indicate that a row should be ignored when the character is present at the start of that row. You can specify any character to indicate a comment line.</p>
    pub comments: std::option::Option<std::string::String>,
    /// <p>A single character used for escaping the quotation mark character inside an already escaped value. For example, the value """ a , b """ is parsed as " a , b ".</p>
    pub quote_escape_character: std::option::Option<std::string::String>,
    /// <p>A single character used to separate individual records in the input. Instead of the default value, you can specify an arbitrary delimiter.</p>
    pub record_delimiter: std::option::Option<std::string::String>,
    /// <p>A single character used to separate individual fields in a record. You can specify an arbitrary delimiter.</p>
    pub field_delimiter: std::option::Option<std::string::String>,
    /// <p>A single character used for escaping when the field delimiter is part of the value. For example, if the value is <code>a, b</code>, Amazon S3 wraps this field value in quotation marks, as follows: <code>" a , b "</code>.</p>
    /// <p>Type: String</p>
    /// <p>Default: <code>"</code> </p>
    /// <p>Ancestors: <code>CSV</code> </p>
    pub quote_character: std::option::Option<std::string::String>,
    /// <p>Specifies that CSV field values may contain quoted record delimiters and such records should be allowed. Default value is FALSE. Setting this value to TRUE may lower performance.</p>
    pub allow_quoted_record_delimiter: bool,
}
impl CsvInput {
    /// <p>Describes the first line of input. Valid values are:</p>
    /// <ul>
    /// <li> <p> <code>NONE</code>: First line is not a header.</p> </li>
    /// <li> <p> <code>IGNORE</code>: First line is a header, but you can't use the header values to indicate the column in an expression. You can use column position (such as _1, _2, …) to indicate the column (<code>SELECT s._1 FROM OBJECT s</code>).</p> </li>
    /// <li> <p> <code>Use</code>: First line is a header, and you can use the header value to identify a column in an expression (<code>SELECT "name" FROM OBJECT</code>). </p> </li>
    /// </ul>
    pub fn file_header_info(&self) -> std::option::Option<&crate::model::FileHeaderInfo> {
        self.file_header_info.as_ref()
    }
    /// <p>A single character used to indicate that a row should be ignored when the character is present at the start of that row. You can specify any character to indicate a comment line.</p>
    pub fn comments(&self) -> std::option::Option<&str> {
        self.comments.as_deref()
    }
    /// <p>A single character used for escaping the quotation mark character inside an already escaped value. For example, the value """ a , b """ is parsed as " a , b ".</p>
    pub fn quote_escape_character(&self) -> std::option::Option<&str> {
        self.quote_escape_character.as_deref()
    }
    /// <p>A single character used to separate individual records in the input. Instead of the default value, you can specify an arbitrary delimiter.</p>
    pub fn record_delimiter(&self) -> std::option::Option<&str> {
        self.record_delimiter.as_deref()
    }
    /// <p>A single character used to separate individual fields in a record. You can specify an arbitrary delimiter.</p>
    pub fn field_delimiter(&self) -> std::option::Option<&str> {
        self.field_delimiter.as_deref()
    }
    /// <p>A single character used for escaping when the field delimiter is part of the value. For example, if the value is <code>a, b</code>, Amazon S3 wraps this field value in quotation marks, as follows: <code>" a , b "</code>.</p>
    /// <p>Type: String</p>
    /// <p>Default: <code>"</code> </p>
    /// <p>Ancestors: <code>CSV</code> </p>
    pub fn quote_character(&self) -> std::option::Option<&str> {
        self.quote_character.as_deref()
    }
    /// <p>Specifies that CSV field values may contain quoted record delimiters and such records should be allowed. Default value is FALSE. Setting this value to TRUE may lower performance.</p>
    pub fn allow_quoted_record_delimiter(&self) -> bool {
        self.allow_quoted_record_delimiter
    }
}
impl std::fmt::Debug for CsvInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CsvInput");
        formatter.field("file_header_info", &self.file_header_info);
        formatter.field("comments", &self.comments);
        formatter.field("quote_escape_character", &self.quote_escape_character);
        formatter.field("record_delimiter", &self.record_delimiter);
        formatter.field("field_delimiter", &self.field_delimiter);
        formatter.field("quote_character", &self.quote_character);
        formatter.field(
            "allow_quoted_record_delimiter",
            &self.allow_quoted_record_delimiter,
        );
        formatter.finish()
    }
}
/// See [`CsvInput`](crate::model::CsvInput)
pub mod csv_input {
    /// A builder for [`CsvInput`](crate::model::CsvInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_header_info: std::option::Option<crate::model::FileHeaderInfo>,
        pub(crate) comments: std::option::Option<std::string::String>,
        pub(crate) quote_escape_character: std::option::Option<std::string::String>,
        pub(crate) record_delimiter: std::option::Option<std::string::String>,
        pub(crate) field_delimiter: std::option::Option<std::string::String>,
        pub(crate) quote_character: std::option::Option<std::string::String>,
        pub(crate) allow_quoted_record_delimiter: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Describes the first line of input. Valid values are:</p>
        /// <ul>
        /// <li> <p> <code>NONE</code>: First line is not a header.</p> </li>
        /// <li> <p> <code>IGNORE</code>: First line is a header, but you can't use the header values to indicate the column in an expression. You can use column position (such as _1, _2, …) to indicate the column (<code>SELECT s._1 FROM OBJECT s</code>).</p> </li>
        /// <li> <p> <code>Use</code>: First line is a header, and you can use the header value to identify a column in an expression (<code>SELECT "name" FROM OBJECT</code>). </p> </li>
        /// </ul>
        pub fn file_header_info(mut self, input: crate::model::FileHeaderInfo) -> Self {
            self.file_header_info = Some(input);
            self
        }
        /// <p>Describes the first line of input. Valid values are:</p>
        /// <ul>
        /// <li> <p> <code>NONE</code>: First line is not a header.</p> </li>
        /// <li> <p> <code>IGNORE</code>: First line is a header, but you can't use the header values to indicate the column in an expression. You can use column position (such as _1, _2, …) to indicate the column (<code>SELECT s._1 FROM OBJECT s</code>).</p> </li>
        /// <li> <p> <code>Use</code>: First line is a header, and you can use the header value to identify a column in an expression (<code>SELECT "name" FROM OBJECT</code>). </p> </li>
        /// </ul>
        pub fn set_file_header_info(
            mut self,
            input: std::option::Option<crate::model::FileHeaderInfo>,
        ) -> Self {
            self.file_header_info = input;
            self
        }
        /// <p>A single character used to indicate that a row should be ignored when the character is present at the start of that row. You can specify any character to indicate a comment line.</p>
        pub fn comments(mut self, input: impl Into<std::string::String>) -> Self {
            self.comments = Some(input.into());
            self
        }
        /// <p>A single character used to indicate that a row should be ignored when the character is present at the start of that row. You can specify any character to indicate a comment line.</p>
        pub fn set_comments(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comments = input;
            self
        }
        /// <p>A single character used for escaping the quotation mark character inside an already escaped value. For example, the value """ a , b """ is parsed as " a , b ".</p>
        pub fn quote_escape_character(mut self, input: impl Into<std::string::String>) -> Self {
            self.quote_escape_character = Some(input.into());
            self
        }
        /// <p>A single character used for escaping the quotation mark character inside an already escaped value. For example, the value """ a , b """ is parsed as " a , b ".</p>
        pub fn set_quote_escape_character(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.quote_escape_character = input;
            self
        }
        /// <p>A single character used to separate individual records in the input. Instead of the default value, you can specify an arbitrary delimiter.</p>
        pub fn record_delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.record_delimiter = Some(input.into());
            self
        }
        /// <p>A single character used to separate individual records in the input. Instead of the default value, you can specify an arbitrary delimiter.</p>
        pub fn set_record_delimiter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.record_delimiter = input;
            self
        }
        /// <p>A single character used to separate individual fields in a record. You can specify an arbitrary delimiter.</p>
        pub fn field_delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.field_delimiter = Some(input.into());
            self
        }
        /// <p>A single character used to separate individual fields in a record. You can specify an arbitrary delimiter.</p>
        pub fn set_field_delimiter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.field_delimiter = input;
            self
        }
        /// <p>A single character used for escaping when the field delimiter is part of the value. For example, if the value is <code>a, b</code>, Amazon S3 wraps this field value in quotation marks, as follows: <code>" a , b "</code>.</p>
        /// <p>Type: String</p>
        /// <p>Default: <code>"</code> </p>
        /// <p>Ancestors: <code>CSV</code> </p>
        pub fn quote_character(mut self, input: impl Into<std::string::String>) -> Self {
            self.quote_character = Some(input.into());
            self
        }
        /// <p>A single character used for escaping when the field delimiter is part of the value. For example, if the value is <code>a, b</code>, Amazon S3 wraps this field value in quotation marks, as follows: <code>" a , b "</code>.</p>
        /// <p>Type: String</p>
        /// <p>Default: <code>"</code> </p>
        /// <p>Ancestors: <code>CSV</code> </p>
        pub fn set_quote_character(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.quote_character = input;
            self
        }
        /// <p>Specifies that CSV field values may contain quoted record delimiters and such records should be allowed. Default value is FALSE. Setting this value to TRUE may lower performance.</p>
        pub fn allow_quoted_record_delimiter(mut self, input: bool) -> Self {
            self.allow_quoted_record_delimiter = Some(input);
            self
        }
        /// <p>Specifies that CSV field values may contain quoted record delimiters and such records should be allowed. Default value is FALSE. Setting this value to TRUE may lower performance.</p>
        pub fn set_allow_quoted_record_delimiter(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.allow_quoted_record_delimiter = input;
            self
        }
        /// Consumes the builder and constructs a [`CsvInput`](crate::model::CsvInput)
        pub fn build(self) -> crate::model::CsvInput {
            crate::model::CsvInput {
                file_header_info: self.file_header_info,
                comments: self.comments,
                quote_escape_character: self.quote_escape_character,
                record_delimiter: self.record_delimiter,
                field_delimiter: self.field_delimiter,
                quote_character: self.quote_character,
                allow_quoted_record_delimiter: self
                    .allow_quoted_record_delimiter
                    .unwrap_or_default(),
            }
        }
    }
}
impl CsvInput {
    /// Creates a new builder-style object to manufacture [`CsvInput`](crate::model::CsvInput)
    pub fn builder() -> crate::model::csv_input::Builder {
        crate::model::csv_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FileHeaderInfo {
    #[allow(missing_docs)] // documentation missing in model
    Ignore,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Use,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FileHeaderInfo {
    fn from(s: &str) -> Self {
        match s {
            "IGNORE" => FileHeaderInfo::Ignore,
            "NONE" => FileHeaderInfo::None,
            "USE" => FileHeaderInfo::Use,
            other => FileHeaderInfo::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FileHeaderInfo {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FileHeaderInfo::from(s))
    }
}
impl FileHeaderInfo {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FileHeaderInfo::Ignore => "IGNORE",
            FileHeaderInfo::None => "NONE",
            FileHeaderInfo::Use => "USE",
            FileHeaderInfo::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IGNORE", "NONE", "USE"]
    }
}
impl AsRef<str> for FileHeaderInfo {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Container for specifying if periodic <code>QueryProgress</code> messages should be sent.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestProgress {
    /// <p>Specifies whether periodic QueryProgress frames should be sent. Valid values: TRUE, FALSE. Default value: FALSE.</p>
    pub enabled: bool,
}
impl RequestProgress {
    /// <p>Specifies whether periodic QueryProgress frames should be sent. Valid values: TRUE, FALSE. Default value: FALSE.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
}
impl std::fmt::Debug for RequestProgress {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestProgress");
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`RequestProgress`](crate::model::RequestProgress)
pub mod request_progress {
    /// A builder for [`RequestProgress`](crate::model::RequestProgress)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies whether periodic QueryProgress frames should be sent. Valid values: TRUE, FALSE. Default value: FALSE.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether periodic QueryProgress frames should be sent. Valid values: TRUE, FALSE. Default value: FALSE.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestProgress`](crate::model::RequestProgress)
        pub fn build(self) -> crate::model::RequestProgress {
            crate::model::RequestProgress {
                enabled: self.enabled.unwrap_or_default(),
            }
        }
    }
}
impl RequestProgress {
    /// Creates a new builder-style object to manufacture [`RequestProgress`](crate::model::RequestProgress)
    pub fn builder() -> crate::model::request_progress::Builder {
        crate::model::request_progress::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExpressionType {
    #[allow(missing_docs)] // documentation missing in model
    Sql,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExpressionType {
    fn from(s: &str) -> Self {
        match s {
            "SQL" => ExpressionType::Sql,
            other => ExpressionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExpressionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExpressionType::from(s))
    }
}
impl ExpressionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExpressionType::Sql => "SQL",
            ExpressionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SQL"]
    }
}
impl AsRef<str> for ExpressionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Container for restore job parameters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreRequest {
    /// <p>Lifetime of the active copy in days. Do not use with restores that specify <code>OutputLocation</code>.</p>
    /// <p>The Days element is required for regular restores, and must not be provided for select requests.</p>
    pub days: i32,
    /// <p>S3 Glacier related parameters pertaining to this job. Do not use with restores that specify <code>OutputLocation</code>.</p>
    pub glacier_job_parameters: std::option::Option<crate::model::GlacierJobParameters>,
    /// <p>Type of restore request.</p>
    pub r#type: std::option::Option<crate::model::RestoreRequestType>,
    /// <p>Retrieval tier at which the restore will be processed.</p>
    pub tier: std::option::Option<crate::model::Tier>,
    /// <p>The optional description for the job.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Describes the parameters for Select job types.</p>
    pub select_parameters: std::option::Option<crate::model::SelectParameters>,
    /// <p>Describes the location where the restore job's output is stored.</p>
    pub output_location: std::option::Option<crate::model::OutputLocation>,
}
impl RestoreRequest {
    /// <p>Lifetime of the active copy in days. Do not use with restores that specify <code>OutputLocation</code>.</p>
    /// <p>The Days element is required for regular restores, and must not be provided for select requests.</p>
    pub fn days(&self) -> i32 {
        self.days
    }
    /// <p>S3 Glacier related parameters pertaining to this job. Do not use with restores that specify <code>OutputLocation</code>.</p>
    pub fn glacier_job_parameters(
        &self,
    ) -> std::option::Option<&crate::model::GlacierJobParameters> {
        self.glacier_job_parameters.as_ref()
    }
    /// <p>Type of restore request.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::RestoreRequestType> {
        self.r#type.as_ref()
    }
    /// <p>Retrieval tier at which the restore will be processed.</p>
    pub fn tier(&self) -> std::option::Option<&crate::model::Tier> {
        self.tier.as_ref()
    }
    /// <p>The optional description for the job.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Describes the parameters for Select job types.</p>
    pub fn select_parameters(&self) -> std::option::Option<&crate::model::SelectParameters> {
        self.select_parameters.as_ref()
    }
    /// <p>Describes the location where the restore job's output is stored.</p>
    pub fn output_location(&self) -> std::option::Option<&crate::model::OutputLocation> {
        self.output_location.as_ref()
    }
}
impl std::fmt::Debug for RestoreRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreRequest");
        formatter.field("days", &self.days);
        formatter.field("glacier_job_parameters", &self.glacier_job_parameters);
        formatter.field("r#type", &self.r#type);
        formatter.field("tier", &self.tier);
        formatter.field("description", &self.description);
        formatter.field("select_parameters", &self.select_parameters);
        formatter.field("output_location", &self.output_location);
        formatter.finish()
    }
}
/// See [`RestoreRequest`](crate::model::RestoreRequest)
pub mod restore_request {
    /// A builder for [`RestoreRequest`](crate::model::RestoreRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) days: std::option::Option<i32>,
        pub(crate) glacier_job_parameters: std::option::Option<crate::model::GlacierJobParameters>,
        pub(crate) r#type: std::option::Option<crate::model::RestoreRequestType>,
        pub(crate) tier: std::option::Option<crate::model::Tier>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) select_parameters: std::option::Option<crate::model::SelectParameters>,
        pub(crate) output_location: std::option::Option<crate::model::OutputLocation>,
    }
    impl Builder {
        /// <p>Lifetime of the active copy in days. Do not use with restores that specify <code>OutputLocation</code>.</p>
        /// <p>The Days element is required for regular restores, and must not be provided for select requests.</p>
        pub fn days(mut self, input: i32) -> Self {
            self.days = Some(input);
            self
        }
        /// <p>Lifetime of the active copy in days. Do not use with restores that specify <code>OutputLocation</code>.</p>
        /// <p>The Days element is required for regular restores, and must not be provided for select requests.</p>
        pub fn set_days(mut self, input: std::option::Option<i32>) -> Self {
            self.days = input;
            self
        }
        /// <p>S3 Glacier related parameters pertaining to this job. Do not use with restores that specify <code>OutputLocation</code>.</p>
        pub fn glacier_job_parameters(mut self, input: crate::model::GlacierJobParameters) -> Self {
            self.glacier_job_parameters = Some(input);
            self
        }
        /// <p>S3 Glacier related parameters pertaining to this job. Do not use with restores that specify <code>OutputLocation</code>.</p>
        pub fn set_glacier_job_parameters(
            mut self,
            input: std::option::Option<crate::model::GlacierJobParameters>,
        ) -> Self {
            self.glacier_job_parameters = input;
            self
        }
        /// <p>Type of restore request.</p>
        pub fn r#type(mut self, input: crate::model::RestoreRequestType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Type of restore request.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::RestoreRequestType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Retrieval tier at which the restore will be processed.</p>
        pub fn tier(mut self, input: crate::model::Tier) -> Self {
            self.tier = Some(input);
            self
        }
        /// <p>Retrieval tier at which the restore will be processed.</p>
        pub fn set_tier(mut self, input: std::option::Option<crate::model::Tier>) -> Self {
            self.tier = input;
            self
        }
        /// <p>The optional description for the job.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The optional description for the job.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Describes the parameters for Select job types.</p>
        pub fn select_parameters(mut self, input: crate::model::SelectParameters) -> Self {
            self.select_parameters = Some(input);
            self
        }
        /// <p>Describes the parameters for Select job types.</p>
        pub fn set_select_parameters(
            mut self,
            input: std::option::Option<crate::model::SelectParameters>,
        ) -> Self {
            self.select_parameters = input;
            self
        }
        /// <p>Describes the location where the restore job's output is stored.</p>
        pub fn output_location(mut self, input: crate::model::OutputLocation) -> Self {
            self.output_location = Some(input);
            self
        }
        /// <p>Describes the location where the restore job's output is stored.</p>
        pub fn set_output_location(
            mut self,
            input: std::option::Option<crate::model::OutputLocation>,
        ) -> Self {
            self.output_location = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreRequest`](crate::model::RestoreRequest)
        pub fn build(self) -> crate::model::RestoreRequest {
            crate::model::RestoreRequest {
                days: self.days.unwrap_or_default(),
                glacier_job_parameters: self.glacier_job_parameters,
                r#type: self.r#type,
                tier: self.tier,
                description: self.description,
                select_parameters: self.select_parameters,
                output_location: self.output_location,
            }
        }
    }
}
impl RestoreRequest {
    /// Creates a new builder-style object to manufacture [`RestoreRequest`](crate::model::RestoreRequest)
    pub fn builder() -> crate::model::restore_request::Builder {
        crate::model::restore_request::Builder::default()
    }
}

/// <p>Describes the location where the restore job's output is stored.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutputLocation {
    /// <p>Describes an S3 location that will receive the results of the restore request.</p>
    pub s3: std::option::Option<crate::model::S3Location>,
}
impl OutputLocation {
    /// <p>Describes an S3 location that will receive the results of the restore request.</p>
    pub fn s3(&self) -> std::option::Option<&crate::model::S3Location> {
        self.s3.as_ref()
    }
}
impl std::fmt::Debug for OutputLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutputLocation");
        formatter.field("s3", &self.s3);
        formatter.finish()
    }
}
/// See [`OutputLocation`](crate::model::OutputLocation)
pub mod output_location {
    /// A builder for [`OutputLocation`](crate::model::OutputLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3: std::option::Option<crate::model::S3Location>,
    }
    impl Builder {
        /// <p>Describes an S3 location that will receive the results of the restore request.</p>
        pub fn s3(mut self, input: crate::model::S3Location) -> Self {
            self.s3 = Some(input);
            self
        }
        /// <p>Describes an S3 location that will receive the results of the restore request.</p>
        pub fn set_s3(mut self, input: std::option::Option<crate::model::S3Location>) -> Self {
            self.s3 = input;
            self
        }
        /// Consumes the builder and constructs a [`OutputLocation`](crate::model::OutputLocation)
        pub fn build(self) -> crate::model::OutputLocation {
            crate::model::OutputLocation { s3: self.s3 }
        }
    }
}
impl OutputLocation {
    /// Creates a new builder-style object to manufacture [`OutputLocation`](crate::model::OutputLocation)
    pub fn builder() -> crate::model::output_location::Builder {
        crate::model::output_location::Builder::default()
    }
}

/// <p>Describes an Amazon S3 location that will receive the results of the restore request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Location {
    /// <p>The name of the bucket where the restore results will be placed.</p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p>The prefix that is prepended to the restore results for this request.</p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>Contains the type of server-side encryption used.</p>
    pub encryption: std::option::Option<crate::model::Encryption>,
    /// <p>The canned ACL to apply to the restore results.</p>
    pub canned_acl: std::option::Option<crate::model::ObjectCannedAcl>,
    /// <p>A list of grants that control access to the staged results.</p>
    pub access_control_list: std::option::Option<std::vec::Vec<crate::model::Grant>>,
    /// <p>The tag-set that is applied to the restore results.</p>
    pub tagging: std::option::Option<crate::model::Tagging>,
    /// <p>A list of metadata to store with the restore results in S3.</p>
    pub user_metadata: std::option::Option<std::vec::Vec<crate::model::MetadataEntry>>,
    /// <p>The class of storage used to store the restore results.</p>
    pub storage_class: std::option::Option<crate::model::StorageClass>,
}
impl S3Location {
    /// <p>The name of the bucket where the restore results will be placed.</p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p>The prefix that is prepended to the restore results for this request.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>Contains the type of server-side encryption used.</p>
    pub fn encryption(&self) -> std::option::Option<&crate::model::Encryption> {
        self.encryption.as_ref()
    }
    /// <p>The canned ACL to apply to the restore results.</p>
    pub fn canned_acl(&self) -> std::option::Option<&crate::model::ObjectCannedAcl> {
        self.canned_acl.as_ref()
    }
    /// <p>A list of grants that control access to the staged results.</p>
    pub fn access_control_list(&self) -> std::option::Option<&[crate::model::Grant]> {
        self.access_control_list.as_deref()
    }
    /// <p>The tag-set that is applied to the restore results.</p>
    pub fn tagging(&self) -> std::option::Option<&crate::model::Tagging> {
        self.tagging.as_ref()
    }
    /// <p>A list of metadata to store with the restore results in S3.</p>
    pub fn user_metadata(&self) -> std::option::Option<&[crate::model::MetadataEntry]> {
        self.user_metadata.as_deref()
    }
    /// <p>The class of storage used to store the restore results.</p>
    pub fn storage_class(&self) -> std::option::Option<&crate::model::StorageClass> {
        self.storage_class.as_ref()
    }
}
impl std::fmt::Debug for S3Location {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Location");
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("prefix", &self.prefix);
        formatter.field("encryption", &self.encryption);
        formatter.field("canned_acl", &self.canned_acl);
        formatter.field("access_control_list", &self.access_control_list);
        formatter.field("tagging", &self.tagging);
        formatter.field("user_metadata", &self.user_metadata);
        formatter.field("storage_class", &self.storage_class);
        formatter.finish()
    }
}
/// See [`S3Location`](crate::model::S3Location)
pub mod s3_location {
    /// A builder for [`S3Location`](crate::model::S3Location)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) encryption: std::option::Option<crate::model::Encryption>,
        pub(crate) canned_acl: std::option::Option<crate::model::ObjectCannedAcl>,
        pub(crate) access_control_list: std::option::Option<std::vec::Vec<crate::model::Grant>>,
        pub(crate) tagging: std::option::Option<crate::model::Tagging>,
        pub(crate) user_metadata: std::option::Option<std::vec::Vec<crate::model::MetadataEntry>>,
        pub(crate) storage_class: std::option::Option<crate::model::StorageClass>,
    }
    impl Builder {
        /// <p>The name of the bucket where the restore results will be placed.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the bucket where the restore results will be placed.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>The prefix that is prepended to the restore results for this request.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>The prefix that is prepended to the restore results for this request.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>Contains the type of server-side encryption used.</p>
        pub fn encryption(mut self, input: crate::model::Encryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// <p>Contains the type of server-side encryption used.</p>
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::Encryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// <p>The canned ACL to apply to the restore results.</p>
        pub fn canned_acl(mut self, input: crate::model::ObjectCannedAcl) -> Self {
            self.canned_acl = Some(input);
            self
        }
        /// <p>The canned ACL to apply to the restore results.</p>
        pub fn set_canned_acl(
            mut self,
            input: std::option::Option<crate::model::ObjectCannedAcl>,
        ) -> Self {
            self.canned_acl = input;
            self
        }
        /// Appends an item to `access_control_list`.
        ///
        /// To override the contents of this collection use [`set_access_control_list`](Self::set_access_control_list).
        ///
        /// <p>A list of grants that control access to the staged results.</p>
        pub fn access_control_list(mut self, input: crate::model::Grant) -> Self {
            let mut v = self.access_control_list.unwrap_or_default();
            v.push(input);
            self.access_control_list = Some(v);
            self
        }
        /// <p>A list of grants that control access to the staged results.</p>
        pub fn set_access_control_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Grant>>,
        ) -> Self {
            self.access_control_list = input;
            self
        }
        /// <p>The tag-set that is applied to the restore results.</p>
        pub fn tagging(mut self, input: crate::model::Tagging) -> Self {
            self.tagging = Some(input);
            self
        }
        /// <p>The tag-set that is applied to the restore results.</p>
        pub fn set_tagging(mut self, input: std::option::Option<crate::model::Tagging>) -> Self {
            self.tagging = input;
            self
        }
        /// Appends an item to `user_metadata`.
        ///
        /// To override the contents of this collection use [`set_user_metadata`](Self::set_user_metadata).
        ///
        /// <p>A list of metadata to store with the restore results in S3.</p>
        pub fn user_metadata(mut self, input: crate::model::MetadataEntry) -> Self {
            let mut v = self.user_metadata.unwrap_or_default();
            v.push(input);
            self.user_metadata = Some(v);
            self
        }
        /// <p>A list of metadata to store with the restore results in S3.</p>
        pub fn set_user_metadata(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetadataEntry>>,
        ) -> Self {
            self.user_metadata = input;
            self
        }
        /// <p>The class of storage used to store the restore results.</p>
        pub fn storage_class(mut self, input: crate::model::StorageClass) -> Self {
            self.storage_class = Some(input);
            self
        }
        /// <p>The class of storage used to store the restore results.</p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<crate::model::StorageClass>,
        ) -> Self {
            self.storage_class = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Location`](crate::model::S3Location)
        pub fn build(self) -> crate::model::S3Location {
            crate::model::S3Location {
                bucket_name: self.bucket_name,
                prefix: self.prefix,
                encryption: self.encryption,
                canned_acl: self.canned_acl,
                access_control_list: self.access_control_list,
                tagging: self.tagging,
                user_metadata: self.user_metadata,
                storage_class: self.storage_class,
            }
        }
    }
}
impl S3Location {
    /// Creates a new builder-style object to manufacture [`S3Location`](crate::model::S3Location)
    pub fn builder() -> crate::model::s3_location::Builder {
        crate::model::s3_location::Builder::default()
    }
}

/// <p>A metadata key-value pair to store with an object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetadataEntry {
    /// <p>Name of the Object.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Value of the Object.</p>
    pub value: std::option::Option<std::string::String>,
}
impl MetadataEntry {
    /// <p>Name of the Object.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Value of the Object.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for MetadataEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetadataEntry");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`MetadataEntry`](crate::model::MetadataEntry)
pub mod metadata_entry {
    /// A builder for [`MetadataEntry`](crate::model::MetadataEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the Object.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of the Object.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Value of the Object.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>Value of the Object.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`MetadataEntry`](crate::model::MetadataEntry)
        pub fn build(self) -> crate::model::MetadataEntry {
            crate::model::MetadataEntry {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl MetadataEntry {
    /// Creates a new builder-style object to manufacture [`MetadataEntry`](crate::model::MetadataEntry)
    pub fn builder() -> crate::model::metadata_entry::Builder {
        crate::model::metadata_entry::Builder::default()
    }
}

/// <p>Container for <code>TagSet</code> elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tagging {
    /// <p>A collection for a set of tags</p>
    pub tag_set: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl Tagging {
    /// <p>A collection for a set of tags</p>
    pub fn tag_set(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tag_set.as_deref()
    }
}
impl std::fmt::Debug for Tagging {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tagging");
        formatter.field("tag_set", &self.tag_set);
        formatter.finish()
    }
}
/// See [`Tagging`](crate::model::Tagging)
pub mod tagging {
    /// A builder for [`Tagging`](crate::model::Tagging)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_set: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tag_set`.
        ///
        /// To override the contents of this collection use [`set_tag_set`](Self::set_tag_set).
        ///
        /// <p>A collection for a set of tags</p>
        pub fn tag_set(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tag_set.unwrap_or_default();
            v.push(input);
            self.tag_set = Some(v);
            self
        }
        /// <p>A collection for a set of tags</p>
        pub fn set_tag_set(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tag_set = input;
            self
        }
        /// Consumes the builder and constructs a [`Tagging`](crate::model::Tagging)
        pub fn build(self) -> crate::model::Tagging {
            crate::model::Tagging {
                tag_set: self.tag_set,
            }
        }
    }
}
impl Tagging {
    /// Creates a new builder-style object to manufacture [`Tagging`](crate::model::Tagging)
    pub fn builder() -> crate::model::tagging::Builder {
        crate::model::tagging::Builder::default()
    }
}

/// <p>A container of a key value name pair.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>Name of the object key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>Value of the tag.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>Name of the object key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>Value of the tag.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the object key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Name of the object key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Value of the tag.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>Value of the tag.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Container for grant information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Grant {
    /// <p>The person being granted permissions.</p>
    pub grantee: std::option::Option<crate::model::Grantee>,
    /// <p>Specifies the permission given to the grantee.</p>
    pub permission: std::option::Option<crate::model::Permission>,
}
impl Grant {
    /// <p>The person being granted permissions.</p>
    pub fn grantee(&self) -> std::option::Option<&crate::model::Grantee> {
        self.grantee.as_ref()
    }
    /// <p>Specifies the permission given to the grantee.</p>
    pub fn permission(&self) -> std::option::Option<&crate::model::Permission> {
        self.permission.as_ref()
    }
}
impl std::fmt::Debug for Grant {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Grant");
        formatter.field("grantee", &self.grantee);
        formatter.field("permission", &self.permission);
        formatter.finish()
    }
}
/// See [`Grant`](crate::model::Grant)
pub mod grant {
    /// A builder for [`Grant`](crate::model::Grant)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) grantee: std::option::Option<crate::model::Grantee>,
        pub(crate) permission: std::option::Option<crate::model::Permission>,
    }
    impl Builder {
        /// <p>The person being granted permissions.</p>
        pub fn grantee(mut self, input: crate::model::Grantee) -> Self {
            self.grantee = Some(input);
            self
        }
        /// <p>The person being granted permissions.</p>
        pub fn set_grantee(mut self, input: std::option::Option<crate::model::Grantee>) -> Self {
            self.grantee = input;
            self
        }
        /// <p>Specifies the permission given to the grantee.</p>
        pub fn permission(mut self, input: crate::model::Permission) -> Self {
            self.permission = Some(input);
            self
        }
        /// <p>Specifies the permission given to the grantee.</p>
        pub fn set_permission(
            mut self,
            input: std::option::Option<crate::model::Permission>,
        ) -> Self {
            self.permission = input;
            self
        }
        /// Consumes the builder and constructs a [`Grant`](crate::model::Grant)
        pub fn build(self) -> crate::model::Grant {
            crate::model::Grant {
                grantee: self.grantee,
                permission: self.permission,
            }
        }
    }
}
impl Grant {
    /// Creates a new builder-style object to manufacture [`Grant`](crate::model::Grant)
    pub fn builder() -> crate::model::grant::Builder {
        crate::model::grant::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Permission {
    #[allow(missing_docs)] // documentation missing in model
    FullControl,
    #[allow(missing_docs)] // documentation missing in model
    Read,
    #[allow(missing_docs)] // documentation missing in model
    ReadAcp,
    #[allow(missing_docs)] // documentation missing in model
    Write,
    #[allow(missing_docs)] // documentation missing in model
    WriteAcp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Permission {
    fn from(s: &str) -> Self {
        match s {
            "FULL_CONTROL" => Permission::FullControl,
            "READ" => Permission::Read,
            "READ_ACP" => Permission::ReadAcp,
            "WRITE" => Permission::Write,
            "WRITE_ACP" => Permission::WriteAcp,
            other => Permission::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Permission {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Permission::from(s))
    }
}
impl Permission {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Permission::FullControl => "FULL_CONTROL",
            Permission::Read => "READ",
            Permission::ReadAcp => "READ_ACP",
            Permission::Write => "WRITE",
            Permission::WriteAcp => "WRITE_ACP",
            Permission::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FULL_CONTROL", "READ", "READ_ACP", "WRITE", "WRITE_ACP"]
    }
}
impl AsRef<str> for Permission {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Container for the person being granted permissions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Grantee {
    /// <p>Screen name of the grantee.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>Email address of the grantee.</p> <note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions: </p>
    /// <ul>
    /// <li> <p>US East (N. Virginia)</p> </li>
    /// <li> <p>US West (N. California)</p> </li>
    /// <li> <p> US West (Oregon)</p> </li>
    /// <li> <p> Asia Pacific (Singapore)</p> </li>
    /// <li> <p>Asia Pacific (Sydney)</p> </li>
    /// <li> <p>Asia Pacific (Tokyo)</p> </li>
    /// <li> <p>Europe (Ireland)</p> </li>
    /// <li> <p>South America (São Paulo)</p> </li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note>
    pub email_address: std::option::Option<std::string::String>,
    /// <p>The canonical user ID of the grantee.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>URI of the grantee group.</p>
    pub uri: std::option::Option<std::string::String>,
    /// <p>Type of grantee</p>
    pub r#type: std::option::Option<crate::model::Type>,
}
impl Grantee {
    /// <p>Screen name of the grantee.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>Email address of the grantee.</p> <note>
    /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions: </p>
    /// <ul>
    /// <li> <p>US East (N. Virginia)</p> </li>
    /// <li> <p>US West (N. California)</p> </li>
    /// <li> <p> US West (Oregon)</p> </li>
    /// <li> <p> Asia Pacific (Singapore)</p> </li>
    /// <li> <p>Asia Pacific (Sydney)</p> </li>
    /// <li> <p>Asia Pacific (Tokyo)</p> </li>
    /// <li> <p>Europe (Ireland)</p> </li>
    /// <li> <p>South America (São Paulo)</p> </li>
    /// </ul>
    /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
    /// </note>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
    /// <p>The canonical user ID of the grantee.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>URI of the grantee group.</p>
    pub fn uri(&self) -> std::option::Option<&str> {
        self.uri.as_deref()
    }
    /// <p>Type of grantee</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::Type> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for Grantee {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Grantee");
        formatter.field("display_name", &self.display_name);
        formatter.field("email_address", &self.email_address);
        formatter.field("id", &self.id);
        formatter.field("uri", &self.uri);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`Grantee`](crate::model::Grantee)
pub mod grantee {
    /// A builder for [`Grantee`](crate::model::Grantee)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) email_address: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) uri: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::Type>,
    }
    impl Builder {
        /// <p>Screen name of the grantee.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>Screen name of the grantee.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>Email address of the grantee.</p> <note>
        /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions: </p>
        /// <ul>
        /// <li> <p>US East (N. Virginia)</p> </li>
        /// <li> <p>US West (N. California)</p> </li>
        /// <li> <p> US West (Oregon)</p> </li>
        /// <li> <p> Asia Pacific (Singapore)</p> </li>
        /// <li> <p>Asia Pacific (Sydney)</p> </li>
        /// <li> <p>Asia Pacific (Tokyo)</p> </li>
        /// <li> <p>Europe (Ireland)</p> </li>
        /// <li> <p>South America (São Paulo)</p> </li>
        /// </ul>
        /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
        /// </note>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>Email address of the grantee.</p> <note>
        /// <p>Using email addresses to specify a grantee is only supported in the following Amazon Web Services Regions: </p>
        /// <ul>
        /// <li> <p>US East (N. Virginia)</p> </li>
        /// <li> <p>US West (N. California)</p> </li>
        /// <li> <p> US West (Oregon)</p> </li>
        /// <li> <p> Asia Pacific (Singapore)</p> </li>
        /// <li> <p>Asia Pacific (Sydney)</p> </li>
        /// <li> <p>Asia Pacific (Tokyo)</p> </li>
        /// <li> <p>Europe (Ireland)</p> </li>
        /// <li> <p>South America (São Paulo)</p> </li>
        /// </ul>
        /// <p>For a list of all the Amazon S3 supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.</p>
        /// </note>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// <p>The canonical user ID of the grantee.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The canonical user ID of the grantee.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>URI of the grantee group.</p>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.uri = Some(input.into());
            self
        }
        /// <p>URI of the grantee group.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uri = input;
            self
        }
        /// <p>Type of grantee</p>
        pub fn r#type(mut self, input: crate::model::Type) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Type of grantee</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`Grantee`](crate::model::Grantee)
        pub fn build(self) -> crate::model::Grantee {
            crate::model::Grantee {
                display_name: self.display_name,
                email_address: self.email_address,
                id: self.id,
                uri: self.uri,
                r#type: self.r#type,
            }
        }
    }
}
impl Grantee {
    /// Creates a new builder-style object to manufacture [`Grantee`](crate::model::Grantee)
    pub fn builder() -> crate::model::grantee::Builder {
        crate::model::grantee::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Type {
    #[allow(missing_docs)] // documentation missing in model
    AmazonCustomerByEmail,
    #[allow(missing_docs)] // documentation missing in model
    CanonicalUser,
    #[allow(missing_docs)] // documentation missing in model
    Group,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Type {
    fn from(s: &str) -> Self {
        match s {
            "AmazonCustomerByEmail" => Type::AmazonCustomerByEmail,
            "CanonicalUser" => Type::CanonicalUser,
            "Group" => Type::Group,
            other => Type::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Type {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Type::from(s))
    }
}
impl Type {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Type::AmazonCustomerByEmail => "AmazonCustomerByEmail",
            Type::CanonicalUser => "CanonicalUser",
            Type::Group => "Group",
            Type::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AmazonCustomerByEmail", "CanonicalUser", "Group"]
    }
}
impl AsRef<str> for Type {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ObjectCannedAcl {
    #[allow(missing_docs)] // documentation missing in model
    AuthenticatedRead,
    #[allow(missing_docs)] // documentation missing in model
    AwsExecRead,
    #[allow(missing_docs)] // documentation missing in model
    BucketOwnerFullControl,
    #[allow(missing_docs)] // documentation missing in model
    BucketOwnerRead,
    #[allow(missing_docs)] // documentation missing in model
    Private,
    #[allow(missing_docs)] // documentation missing in model
    PublicRead,
    #[allow(missing_docs)] // documentation missing in model
    PublicReadWrite,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ObjectCannedAcl {
    fn from(s: &str) -> Self {
        match s {
            "authenticated-read" => ObjectCannedAcl::AuthenticatedRead,
            "aws-exec-read" => ObjectCannedAcl::AwsExecRead,
            "bucket-owner-full-control" => ObjectCannedAcl::BucketOwnerFullControl,
            "bucket-owner-read" => ObjectCannedAcl::BucketOwnerRead,
            "private" => ObjectCannedAcl::Private,
            "public-read" => ObjectCannedAcl::PublicRead,
            "public-read-write" => ObjectCannedAcl::PublicReadWrite,
            other => ObjectCannedAcl::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ObjectCannedAcl {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ObjectCannedAcl::from(s))
    }
}
impl ObjectCannedAcl {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ObjectCannedAcl::AuthenticatedRead => "authenticated-read",
            ObjectCannedAcl::AwsExecRead => "aws-exec-read",
            ObjectCannedAcl::BucketOwnerFullControl => "bucket-owner-full-control",
            ObjectCannedAcl::BucketOwnerRead => "bucket-owner-read",
            ObjectCannedAcl::Private => "private",
            ObjectCannedAcl::PublicRead => "public-read",
            ObjectCannedAcl::PublicReadWrite => "public-read-write",
            ObjectCannedAcl::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "authenticated-read",
            "aws-exec-read",
            "bucket-owner-full-control",
            "bucket-owner-read",
            "private",
            "public-read",
            "public-read-write",
        ]
    }
}
impl AsRef<str> for ObjectCannedAcl {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the type of server-side encryption used.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Encryption {
    /// <p>The server-side encryption algorithm used when storing job results in Amazon S3 (for example, AES256, aws:kms).</p>
    pub encryption_type: std::option::Option<crate::model::ServerSideEncryption>,
    /// <p>If the encryption type is <code>aws:kms</code>, this optional value specifies the ID of the symmetric customer managed key to use for encryption of job results. Amazon S3 only supports symmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>If the encryption type is <code>aws:kms</code>, this optional value can be used to specify the encryption context for the restore results.</p>
    pub kms_context: std::option::Option<std::string::String>,
}
impl Encryption {
    /// <p>The server-side encryption algorithm used when storing job results in Amazon S3 (for example, AES256, aws:kms).</p>
    pub fn encryption_type(&self) -> std::option::Option<&crate::model::ServerSideEncryption> {
        self.encryption_type.as_ref()
    }
    /// <p>If the encryption type is <code>aws:kms</code>, this optional value specifies the ID of the symmetric customer managed key to use for encryption of job results. Amazon S3 only supports symmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>If the encryption type is <code>aws:kms</code>, this optional value can be used to specify the encryption context for the restore results.</p>
    pub fn kms_context(&self) -> std::option::Option<&str> {
        self.kms_context.as_deref()
    }
}
impl std::fmt::Debug for Encryption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Encryption");
        formatter.field("encryption_type", &self.encryption_type);
        formatter.field("kms_key_id", &"*** Sensitive Data Redacted ***");
        formatter.field("kms_context", &self.kms_context);
        formatter.finish()
    }
}
/// See [`Encryption`](crate::model::Encryption)
pub mod encryption {
    /// A builder for [`Encryption`](crate::model::Encryption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encryption_type: std::option::Option<crate::model::ServerSideEncryption>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) kms_context: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The server-side encryption algorithm used when storing job results in Amazon S3 (for example, AES256, aws:kms).</p>
        pub fn encryption_type(mut self, input: crate::model::ServerSideEncryption) -> Self {
            self.encryption_type = Some(input);
            self
        }
        /// <p>The server-side encryption algorithm used when storing job results in Amazon S3 (for example, AES256, aws:kms).</p>
        pub fn set_encryption_type(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryption>,
        ) -> Self {
            self.encryption_type = input;
            self
        }
        /// <p>If the encryption type is <code>aws:kms</code>, this optional value specifies the ID of the symmetric customer managed key to use for encryption of job results. Amazon S3 only supports symmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>If the encryption type is <code>aws:kms</code>, this optional value specifies the ID of the symmetric customer managed key to use for encryption of job results. Amazon S3 only supports symmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>If the encryption type is <code>aws:kms</code>, this optional value can be used to specify the encryption context for the restore results.</p>
        pub fn kms_context(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_context = Some(input.into());
            self
        }
        /// <p>If the encryption type is <code>aws:kms</code>, this optional value can be used to specify the encryption context for the restore results.</p>
        pub fn set_kms_context(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_context = input;
            self
        }
        /// Consumes the builder and constructs a [`Encryption`](crate::model::Encryption)
        pub fn build(self) -> crate::model::Encryption {
            crate::model::Encryption {
                encryption_type: self.encryption_type,
                kms_key_id: self.kms_key_id,
                kms_context: self.kms_context,
            }
        }
    }
}
impl Encryption {
    /// Creates a new builder-style object to manufacture [`Encryption`](crate::model::Encryption)
    pub fn builder() -> crate::model::encryption::Builder {
        crate::model::encryption::Builder::default()
    }
}

/// <p>Describes the parameters for Select job types.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SelectParameters {
    /// <p>Describes the serialization format of the object.</p>
    pub input_serialization: std::option::Option<crate::model::InputSerialization>,
    /// <p>The type of the provided expression (for example, SQL).</p>
    pub expression_type: std::option::Option<crate::model::ExpressionType>,
    /// <p>The expression that is used to query the object.</p>
    pub expression: std::option::Option<std::string::String>,
    /// <p>Describes how the results of the Select job are serialized.</p>
    pub output_serialization: std::option::Option<crate::model::OutputSerialization>,
}
impl SelectParameters {
    /// <p>Describes the serialization format of the object.</p>
    pub fn input_serialization(&self) -> std::option::Option<&crate::model::InputSerialization> {
        self.input_serialization.as_ref()
    }
    /// <p>The type of the provided expression (for example, SQL).</p>
    pub fn expression_type(&self) -> std::option::Option<&crate::model::ExpressionType> {
        self.expression_type.as_ref()
    }
    /// <p>The expression that is used to query the object.</p>
    pub fn expression(&self) -> std::option::Option<&str> {
        self.expression.as_deref()
    }
    /// <p>Describes how the results of the Select job are serialized.</p>
    pub fn output_serialization(&self) -> std::option::Option<&crate::model::OutputSerialization> {
        self.output_serialization.as_ref()
    }
}
impl std::fmt::Debug for SelectParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SelectParameters");
        formatter.field("input_serialization", &self.input_serialization);
        formatter.field("expression_type", &self.expression_type);
        formatter.field("expression", &self.expression);
        formatter.field("output_serialization", &self.output_serialization);
        formatter.finish()
    }
}
/// See [`SelectParameters`](crate::model::SelectParameters)
pub mod select_parameters {
    /// A builder for [`SelectParameters`](crate::model::SelectParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_serialization: std::option::Option<crate::model::InputSerialization>,
        pub(crate) expression_type: std::option::Option<crate::model::ExpressionType>,
        pub(crate) expression: std::option::Option<std::string::String>,
        pub(crate) output_serialization: std::option::Option<crate::model::OutputSerialization>,
    }
    impl Builder {
        /// <p>Describes the serialization format of the object.</p>
        pub fn input_serialization(mut self, input: crate::model::InputSerialization) -> Self {
            self.input_serialization = Some(input);
            self
        }
        /// <p>Describes the serialization format of the object.</p>
        pub fn set_input_serialization(
            mut self,
            input: std::option::Option<crate::model::InputSerialization>,
        ) -> Self {
            self.input_serialization = input;
            self
        }
        /// <p>The type of the provided expression (for example, SQL).</p>
        pub fn expression_type(mut self, input: crate::model::ExpressionType) -> Self {
            self.expression_type = Some(input);
            self
        }
        /// <p>The type of the provided expression (for example, SQL).</p>
        pub fn set_expression_type(
            mut self,
            input: std::option::Option<crate::model::ExpressionType>,
        ) -> Self {
            self.expression_type = input;
            self
        }
        /// <p>The expression that is used to query the object.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression = Some(input.into());
            self
        }
        /// <p>The expression that is used to query the object.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expression = input;
            self
        }
        /// <p>Describes how the results of the Select job are serialized.</p>
        pub fn output_serialization(mut self, input: crate::model::OutputSerialization) -> Self {
            self.output_serialization = Some(input);
            self
        }
        /// <p>Describes how the results of the Select job are serialized.</p>
        pub fn set_output_serialization(
            mut self,
            input: std::option::Option<crate::model::OutputSerialization>,
        ) -> Self {
            self.output_serialization = input;
            self
        }
        /// Consumes the builder and constructs a [`SelectParameters`](crate::model::SelectParameters)
        pub fn build(self) -> crate::model::SelectParameters {
            crate::model::SelectParameters {
                input_serialization: self.input_serialization,
                expression_type: self.expression_type,
                expression: self.expression,
                output_serialization: self.output_serialization,
            }
        }
    }
}
impl SelectParameters {
    /// Creates a new builder-style object to manufacture [`SelectParameters`](crate::model::SelectParameters)
    pub fn builder() -> crate::model::select_parameters::Builder {
        crate::model::select_parameters::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Tier {
    #[allow(missing_docs)] // documentation missing in model
    Bulk,
    #[allow(missing_docs)] // documentation missing in model
    Expedited,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Tier {
    fn from(s: &str) -> Self {
        match s {
            "Bulk" => Tier::Bulk,
            "Expedited" => Tier::Expedited,
            "Standard" => Tier::Standard,
            other => Tier::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Tier {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Tier::from(s))
    }
}
impl Tier {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Tier::Bulk => "Bulk",
            Tier::Expedited => "Expedited",
            Tier::Standard => "Standard",
            Tier::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Bulk", "Expedited", "Standard"]
    }
}
impl AsRef<str> for Tier {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RestoreRequestType {
    #[allow(missing_docs)] // documentation missing in model
    Select,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RestoreRequestType {
    fn from(s: &str) -> Self {
        match s {
            "SELECT" => RestoreRequestType::Select,
            other => RestoreRequestType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RestoreRequestType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RestoreRequestType::from(s))
    }
}
impl RestoreRequestType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RestoreRequestType::Select => "SELECT",
            RestoreRequestType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SELECT"]
    }
}
impl AsRef<str> for RestoreRequestType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Container for S3 Glacier job parameters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GlacierJobParameters {
    /// <p>Retrieval tier at which the restore will be processed.</p>
    pub tier: std::option::Option<crate::model::Tier>,
}
impl GlacierJobParameters {
    /// <p>Retrieval tier at which the restore will be processed.</p>
    pub fn tier(&self) -> std::option::Option<&crate::model::Tier> {
        self.tier.as_ref()
    }
}
impl std::fmt::Debug for GlacierJobParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GlacierJobParameters");
        formatter.field("tier", &self.tier);
        formatter.finish()
    }
}
/// See [`GlacierJobParameters`](crate::model::GlacierJobParameters)
pub mod glacier_job_parameters {
    /// A builder for [`GlacierJobParameters`](crate::model::GlacierJobParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tier: std::option::Option<crate::model::Tier>,
    }
    impl Builder {
        /// <p>Retrieval tier at which the restore will be processed.</p>
        pub fn tier(mut self, input: crate::model::Tier) -> Self {
            self.tier = Some(input);
            self
        }
        /// <p>Retrieval tier at which the restore will be processed.</p>
        pub fn set_tier(mut self, input: std::option::Option<crate::model::Tier>) -> Self {
            self.tier = input;
            self
        }
        /// Consumes the builder and constructs a [`GlacierJobParameters`](crate::model::GlacierJobParameters)
        pub fn build(self) -> crate::model::GlacierJobParameters {
            crate::model::GlacierJobParameters { tier: self.tier }
        }
    }
}
impl GlacierJobParameters {
    /// Creates a new builder-style object to manufacture [`GlacierJobParameters`](crate::model::GlacierJobParameters)
    pub fn builder() -> crate::model::glacier_job_parameters::Builder {
        crate::model::glacier_job_parameters::Builder::default()
    }
}

/// <p>The PublicAccessBlock configuration that you want to apply to this Amazon S3 bucket. You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <i>Amazon S3 User Guide</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublicAccessBlockConfiguration {
    /// <p>Specifies whether Amazon S3 should block public access control lists (ACLs) for this bucket and objects in this bucket. Setting this element to <code>TRUE</code> causes the following behavior:</p>
    /// <ul>
    /// <li> <p>PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.</p> </li>
    /// <li> <p>PUT Object calls fail if the request includes a public ACL.</p> </li>
    /// <li> <p>PUT Bucket calls fail if the request includes a public ACL.</p> </li>
    /// </ul>
    /// <p>Enabling this setting doesn't affect existing policies or ACLs.</p>
    pub block_public_acls: bool,
    /// <p>Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this bucket. Setting this element to <code>TRUE</code> causes Amazon S3 to ignore all public ACLs on this bucket and objects in this bucket.</p>
    /// <p>Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.</p>
    pub ignore_public_acls: bool,
    /// <p>Specifies whether Amazon S3 should block public bucket policies for this bucket. Setting this element to <code>TRUE</code> causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access. </p>
    /// <p>Enabling this setting doesn't affect existing bucket policies.</p>
    pub block_public_policy: bool,
    /// <p>Specifies whether Amazon S3 should restrict public bucket policies for this bucket. Setting this element to <code>TRUE</code> restricts access to this bucket to only Amazon Web Service principals and authorized users within this account if the bucket has a public policy.</p>
    /// <p>Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.</p>
    pub restrict_public_buckets: bool,
}
impl PublicAccessBlockConfiguration {
    /// <p>Specifies whether Amazon S3 should block public access control lists (ACLs) for this bucket and objects in this bucket. Setting this element to <code>TRUE</code> causes the following behavior:</p>
    /// <ul>
    /// <li> <p>PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.</p> </li>
    /// <li> <p>PUT Object calls fail if the request includes a public ACL.</p> </li>
    /// <li> <p>PUT Bucket calls fail if the request includes a public ACL.</p> </li>
    /// </ul>
    /// <p>Enabling this setting doesn't affect existing policies or ACLs.</p>
    pub fn block_public_acls(&self) -> bool {
        self.block_public_acls
    }
    /// <p>Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this bucket. Setting this element to <code>TRUE</code> causes Amazon S3 to ignore all public ACLs on this bucket and objects in this bucket.</p>
    /// <p>Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.</p>
    pub fn ignore_public_acls(&self) -> bool {
        self.ignore_public_acls
    }
    /// <p>Specifies whether Amazon S3 should block public bucket policies for this bucket. Setting this element to <code>TRUE</code> causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access. </p>
    /// <p>Enabling this setting doesn't affect existing bucket policies.</p>
    pub fn block_public_policy(&self) -> bool {
        self.block_public_policy
    }
    /// <p>Specifies whether Amazon S3 should restrict public bucket policies for this bucket. Setting this element to <code>TRUE</code> restricts access to this bucket to only Amazon Web Service principals and authorized users within this account if the bucket has a public policy.</p>
    /// <p>Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.</p>
    pub fn restrict_public_buckets(&self) -> bool {
        self.restrict_public_buckets
    }
}
impl std::fmt::Debug for PublicAccessBlockConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublicAccessBlockConfiguration");
        formatter.field("block_public_acls", &self.block_public_acls);
        formatter.field("ignore_public_acls", &self.ignore_public_acls);
        formatter.field("block_public_policy", &self.block_public_policy);
        formatter.field("restrict_public_buckets", &self.restrict_public_buckets);
        formatter.finish()
    }
}
/// See [`PublicAccessBlockConfiguration`](crate::model::PublicAccessBlockConfiguration)
pub mod public_access_block_configuration {
    /// A builder for [`PublicAccessBlockConfiguration`](crate::model::PublicAccessBlockConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) block_public_acls: std::option::Option<bool>,
        pub(crate) ignore_public_acls: std::option::Option<bool>,
        pub(crate) block_public_policy: std::option::Option<bool>,
        pub(crate) restrict_public_buckets: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies whether Amazon S3 should block public access control lists (ACLs) for this bucket and objects in this bucket. Setting this element to <code>TRUE</code> causes the following behavior:</p>
        /// <ul>
        /// <li> <p>PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.</p> </li>
        /// <li> <p>PUT Object calls fail if the request includes a public ACL.</p> </li>
        /// <li> <p>PUT Bucket calls fail if the request includes a public ACL.</p> </li>
        /// </ul>
        /// <p>Enabling this setting doesn't affect existing policies or ACLs.</p>
        pub fn block_public_acls(mut self, input: bool) -> Self {
            self.block_public_acls = Some(input);
            self
        }
        /// <p>Specifies whether Amazon S3 should block public access control lists (ACLs) for this bucket and objects in this bucket. Setting this element to <code>TRUE</code> causes the following behavior:</p>
        /// <ul>
        /// <li> <p>PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.</p> </li>
        /// <li> <p>PUT Object calls fail if the request includes a public ACL.</p> </li>
        /// <li> <p>PUT Bucket calls fail if the request includes a public ACL.</p> </li>
        /// </ul>
        /// <p>Enabling this setting doesn't affect existing policies or ACLs.</p>
        pub fn set_block_public_acls(mut self, input: std::option::Option<bool>) -> Self {
            self.block_public_acls = input;
            self
        }
        /// <p>Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this bucket. Setting this element to <code>TRUE</code> causes Amazon S3 to ignore all public ACLs on this bucket and objects in this bucket.</p>
        /// <p>Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.</p>
        pub fn ignore_public_acls(mut self, input: bool) -> Self {
            self.ignore_public_acls = Some(input);
            self
        }
        /// <p>Specifies whether Amazon S3 should ignore public ACLs for this bucket and objects in this bucket. Setting this element to <code>TRUE</code> causes Amazon S3 to ignore all public ACLs on this bucket and objects in this bucket.</p>
        /// <p>Enabling this setting doesn't affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set.</p>
        pub fn set_ignore_public_acls(mut self, input: std::option::Option<bool>) -> Self {
            self.ignore_public_acls = input;
            self
        }
        /// <p>Specifies whether Amazon S3 should block public bucket policies for this bucket. Setting this element to <code>TRUE</code> causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access. </p>
        /// <p>Enabling this setting doesn't affect existing bucket policies.</p>
        pub fn block_public_policy(mut self, input: bool) -> Self {
            self.block_public_policy = Some(input);
            self
        }
        /// <p>Specifies whether Amazon S3 should block public bucket policies for this bucket. Setting this element to <code>TRUE</code> causes Amazon S3 to reject calls to PUT Bucket policy if the specified bucket policy allows public access. </p>
        /// <p>Enabling this setting doesn't affect existing bucket policies.</p>
        pub fn set_block_public_policy(mut self, input: std::option::Option<bool>) -> Self {
            self.block_public_policy = input;
            self
        }
        /// <p>Specifies whether Amazon S3 should restrict public bucket policies for this bucket. Setting this element to <code>TRUE</code> restricts access to this bucket to only Amazon Web Service principals and authorized users within this account if the bucket has a public policy.</p>
        /// <p>Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.</p>
        pub fn restrict_public_buckets(mut self, input: bool) -> Self {
            self.restrict_public_buckets = Some(input);
            self
        }
        /// <p>Specifies whether Amazon S3 should restrict public bucket policies for this bucket. Setting this element to <code>TRUE</code> restricts access to this bucket to only Amazon Web Service principals and authorized users within this account if the bucket has a public policy.</p>
        /// <p>Enabling this setting doesn't affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.</p>
        pub fn set_restrict_public_buckets(mut self, input: std::option::Option<bool>) -> Self {
            self.restrict_public_buckets = input;
            self
        }
        /// Consumes the builder and constructs a [`PublicAccessBlockConfiguration`](crate::model::PublicAccessBlockConfiguration)
        pub fn build(self) -> crate::model::PublicAccessBlockConfiguration {
            crate::model::PublicAccessBlockConfiguration {
                block_public_acls: self.block_public_acls.unwrap_or_default(),
                ignore_public_acls: self.ignore_public_acls.unwrap_or_default(),
                block_public_policy: self.block_public_policy.unwrap_or_default(),
                restrict_public_buckets: self.restrict_public_buckets.unwrap_or_default(),
            }
        }
    }
}
impl PublicAccessBlockConfiguration {
    /// Creates a new builder-style object to manufacture [`PublicAccessBlockConfiguration`](crate::model::PublicAccessBlockConfiguration)
    pub fn builder() -> crate::model::public_access_block_configuration::Builder {
        crate::model::public_access_block_configuration::Builder::default()
    }
}

/// <p>A Retention configuration for an object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ObjectLockRetention {
    /// <p>Indicates the Retention mode for the specified object.</p>
    pub mode: std::option::Option<crate::model::ObjectLockRetentionMode>,
    /// <p>The date on which this Object Lock Retention will expire.</p>
    pub retain_until_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl ObjectLockRetention {
    /// <p>Indicates the Retention mode for the specified object.</p>
    pub fn mode(&self) -> std::option::Option<&crate::model::ObjectLockRetentionMode> {
        self.mode.as_ref()
    }
    /// <p>The date on which this Object Lock Retention will expire.</p>
    pub fn retain_until_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.retain_until_date.as_ref()
    }
}
impl std::fmt::Debug for ObjectLockRetention {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ObjectLockRetention");
        formatter.field("mode", &self.mode);
        formatter.field("retain_until_date", &self.retain_until_date);
        formatter.finish()
    }
}
/// See [`ObjectLockRetention`](crate::model::ObjectLockRetention)
pub mod object_lock_retention {
    /// A builder for [`ObjectLockRetention`](crate::model::ObjectLockRetention)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mode: std::option::Option<crate::model::ObjectLockRetentionMode>,
        pub(crate) retain_until_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Indicates the Retention mode for the specified object.</p>
        pub fn mode(mut self, input: crate::model::ObjectLockRetentionMode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>Indicates the Retention mode for the specified object.</p>
        pub fn set_mode(
            mut self,
            input: std::option::Option<crate::model::ObjectLockRetentionMode>,
        ) -> Self {
            self.mode = input;
            self
        }
        /// <p>The date on which this Object Lock Retention will expire.</p>
        pub fn retain_until_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.retain_until_date = Some(input);
            self
        }
        /// <p>The date on which this Object Lock Retention will expire.</p>
        pub fn set_retain_until_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.retain_until_date = input;
            self
        }
        /// Consumes the builder and constructs a [`ObjectLockRetention`](crate::model::ObjectLockRetention)
        pub fn build(self) -> crate::model::ObjectLockRetention {
            crate::model::ObjectLockRetention {
                mode: self.mode,
                retain_until_date: self.retain_until_date,
            }
        }
    }
}
impl ObjectLockRetention {
    /// Creates a new builder-style object to manufacture [`ObjectLockRetention`](crate::model::ObjectLockRetention)
    pub fn builder() -> crate::model::object_lock_retention::Builder {
        crate::model::object_lock_retention::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ObjectLockRetentionMode {
    #[allow(missing_docs)] // documentation missing in model
    Compliance,
    #[allow(missing_docs)] // documentation missing in model
    Governance,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ObjectLockRetentionMode {
    fn from(s: &str) -> Self {
        match s {
            "COMPLIANCE" => ObjectLockRetentionMode::Compliance,
            "GOVERNANCE" => ObjectLockRetentionMode::Governance,
            other => ObjectLockRetentionMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ObjectLockRetentionMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ObjectLockRetentionMode::from(s))
    }
}
impl ObjectLockRetentionMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ObjectLockRetentionMode::Compliance => "COMPLIANCE",
            ObjectLockRetentionMode::Governance => "GOVERNANCE",
            ObjectLockRetentionMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLIANCE", "GOVERNANCE"]
    }
}
impl AsRef<str> for ObjectLockRetentionMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The container element for Object Lock configuration parameters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ObjectLockConfiguration {
    /// <p>Indicates whether this bucket has an Object Lock configuration enabled. Enable <code>ObjectLockEnabled</code> when you apply <code>ObjectLockConfiguration</code> to a bucket. </p>
    pub object_lock_enabled: std::option::Option<crate::model::ObjectLockEnabled>,
    /// <p>Specifies the Object Lock rule for the specified object. Enable the this rule when you apply <code>ObjectLockConfiguration</code> to a bucket. Bucket settings require both a mode and a period. The period can be either <code>Days</code> or <code>Years</code> but you must select one. You cannot specify <code>Days</code> and <code>Years</code> at the same time.</p>
    pub rule: std::option::Option<crate::model::ObjectLockRule>,
}
impl ObjectLockConfiguration {
    /// <p>Indicates whether this bucket has an Object Lock configuration enabled. Enable <code>ObjectLockEnabled</code> when you apply <code>ObjectLockConfiguration</code> to a bucket. </p>
    pub fn object_lock_enabled(&self) -> std::option::Option<&crate::model::ObjectLockEnabled> {
        self.object_lock_enabled.as_ref()
    }
    /// <p>Specifies the Object Lock rule for the specified object. Enable the this rule when you apply <code>ObjectLockConfiguration</code> to a bucket. Bucket settings require both a mode and a period. The period can be either <code>Days</code> or <code>Years</code> but you must select one. You cannot specify <code>Days</code> and <code>Years</code> at the same time.</p>
    pub fn rule(&self) -> std::option::Option<&crate::model::ObjectLockRule> {
        self.rule.as_ref()
    }
}
impl std::fmt::Debug for ObjectLockConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ObjectLockConfiguration");
        formatter.field("object_lock_enabled", &self.object_lock_enabled);
        formatter.field("rule", &self.rule);
        formatter.finish()
    }
}
/// See [`ObjectLockConfiguration`](crate::model::ObjectLockConfiguration)
pub mod object_lock_configuration {
    /// A builder for [`ObjectLockConfiguration`](crate::model::ObjectLockConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_lock_enabled: std::option::Option<crate::model::ObjectLockEnabled>,
        pub(crate) rule: std::option::Option<crate::model::ObjectLockRule>,
    }
    impl Builder {
        /// <p>Indicates whether this bucket has an Object Lock configuration enabled. Enable <code>ObjectLockEnabled</code> when you apply <code>ObjectLockConfiguration</code> to a bucket. </p>
        pub fn object_lock_enabled(mut self, input: crate::model::ObjectLockEnabled) -> Self {
            self.object_lock_enabled = Some(input);
            self
        }
        /// <p>Indicates whether this bucket has an Object Lock configuration enabled. Enable <code>ObjectLockEnabled</code> when you apply <code>ObjectLockConfiguration</code> to a bucket. </p>
        pub fn set_object_lock_enabled(
            mut self,
            input: std::option::Option<crate::model::ObjectLockEnabled>,
        ) -> Self {
            self.object_lock_enabled = input;
            self
        }
        /// <p>Specifies the Object Lock rule for the specified object. Enable the this rule when you apply <code>ObjectLockConfiguration</code> to a bucket. Bucket settings require both a mode and a period. The period can be either <code>Days</code> or <code>Years</code> but you must select one. You cannot specify <code>Days</code> and <code>Years</code> at the same time.</p>
        pub fn rule(mut self, input: crate::model::ObjectLockRule) -> Self {
            self.rule = Some(input);
            self
        }
        /// <p>Specifies the Object Lock rule for the specified object. Enable the this rule when you apply <code>ObjectLockConfiguration</code> to a bucket. Bucket settings require both a mode and a period. The period can be either <code>Days</code> or <code>Years</code> but you must select one. You cannot specify <code>Days</code> and <code>Years</code> at the same time.</p>
        pub fn set_rule(
            mut self,
            input: std::option::Option<crate::model::ObjectLockRule>,
        ) -> Self {
            self.rule = input;
            self
        }
        /// Consumes the builder and constructs a [`ObjectLockConfiguration`](crate::model::ObjectLockConfiguration)
        pub fn build(self) -> crate::model::ObjectLockConfiguration {
            crate::model::ObjectLockConfiguration {
                object_lock_enabled: self.object_lock_enabled,
                rule: self.rule,
            }
        }
    }
}
impl ObjectLockConfiguration {
    /// Creates a new builder-style object to manufacture [`ObjectLockConfiguration`](crate::model::ObjectLockConfiguration)
    pub fn builder() -> crate::model::object_lock_configuration::Builder {
        crate::model::object_lock_configuration::Builder::default()
    }
}

/// <p>The container element for an Object Lock rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ObjectLockRule {
    /// <p>The default Object Lock retention mode and period that you want to apply to new objects placed in the specified bucket. Bucket settings require both a mode and a period. The period can be either <code>Days</code> or <code>Years</code> but you must select one. You cannot specify <code>Days</code> and <code>Years</code> at the same time.</p>
    pub default_retention: std::option::Option<crate::model::DefaultRetention>,
}
impl ObjectLockRule {
    /// <p>The default Object Lock retention mode and period that you want to apply to new objects placed in the specified bucket. Bucket settings require both a mode and a period. The period can be either <code>Days</code> or <code>Years</code> but you must select one. You cannot specify <code>Days</code> and <code>Years</code> at the same time.</p>
    pub fn default_retention(&self) -> std::option::Option<&crate::model::DefaultRetention> {
        self.default_retention.as_ref()
    }
}
impl std::fmt::Debug for ObjectLockRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ObjectLockRule");
        formatter.field("default_retention", &self.default_retention);
        formatter.finish()
    }
}
/// See [`ObjectLockRule`](crate::model::ObjectLockRule)
pub mod object_lock_rule {
    /// A builder for [`ObjectLockRule`](crate::model::ObjectLockRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_retention: std::option::Option<crate::model::DefaultRetention>,
    }
    impl Builder {
        /// <p>The default Object Lock retention mode and period that you want to apply to new objects placed in the specified bucket. Bucket settings require both a mode and a period. The period can be either <code>Days</code> or <code>Years</code> but you must select one. You cannot specify <code>Days</code> and <code>Years</code> at the same time.</p>
        pub fn default_retention(mut self, input: crate::model::DefaultRetention) -> Self {
            self.default_retention = Some(input);
            self
        }
        /// <p>The default Object Lock retention mode and period that you want to apply to new objects placed in the specified bucket. Bucket settings require both a mode and a period. The period can be either <code>Days</code> or <code>Years</code> but you must select one. You cannot specify <code>Days</code> and <code>Years</code> at the same time.</p>
        pub fn set_default_retention(
            mut self,
            input: std::option::Option<crate::model::DefaultRetention>,
        ) -> Self {
            self.default_retention = input;
            self
        }
        /// Consumes the builder and constructs a [`ObjectLockRule`](crate::model::ObjectLockRule)
        pub fn build(self) -> crate::model::ObjectLockRule {
            crate::model::ObjectLockRule {
                default_retention: self.default_retention,
            }
        }
    }
}
impl ObjectLockRule {
    /// Creates a new builder-style object to manufacture [`ObjectLockRule`](crate::model::ObjectLockRule)
    pub fn builder() -> crate::model::object_lock_rule::Builder {
        crate::model::object_lock_rule::Builder::default()
    }
}

/// <p>The container element for specifying the default Object Lock retention settings for new objects placed in the specified bucket.</p> <note>
/// <ul>
/// <li> <p>The <code>DefaultRetention</code> settings require both a mode and a period.</p> </li>
/// <li> <p>The <code>DefaultRetention</code> period can be either <code>Days</code> or <code>Years</code> but you must select one. You cannot specify <code>Days</code> and <code>Years</code> at the same time.</p> </li>
/// </ul>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DefaultRetention {
    /// <p>The default Object Lock retention mode you want to apply to new objects placed in the specified bucket. Must be used with either <code>Days</code> or <code>Years</code>.</p>
    pub mode: std::option::Option<crate::model::ObjectLockRetentionMode>,
    /// <p>The number of days that you want to specify for the default retention period. Must be used with <code>Mode</code>.</p>
    pub days: i32,
    /// <p>The number of years that you want to specify for the default retention period. Must be used with <code>Mode</code>.</p>
    pub years: i32,
}
impl DefaultRetention {
    /// <p>The default Object Lock retention mode you want to apply to new objects placed in the specified bucket. Must be used with either <code>Days</code> or <code>Years</code>.</p>
    pub fn mode(&self) -> std::option::Option<&crate::model::ObjectLockRetentionMode> {
        self.mode.as_ref()
    }
    /// <p>The number of days that you want to specify for the default retention period. Must be used with <code>Mode</code>.</p>
    pub fn days(&self) -> i32 {
        self.days
    }
    /// <p>The number of years that you want to specify for the default retention period. Must be used with <code>Mode</code>.</p>
    pub fn years(&self) -> i32 {
        self.years
    }
}
impl std::fmt::Debug for DefaultRetention {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DefaultRetention");
        formatter.field("mode", &self.mode);
        formatter.field("days", &self.days);
        formatter.field("years", &self.years);
        formatter.finish()
    }
}
/// See [`DefaultRetention`](crate::model::DefaultRetention)
pub mod default_retention {
    /// A builder for [`DefaultRetention`](crate::model::DefaultRetention)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mode: std::option::Option<crate::model::ObjectLockRetentionMode>,
        pub(crate) days: std::option::Option<i32>,
        pub(crate) years: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The default Object Lock retention mode you want to apply to new objects placed in the specified bucket. Must be used with either <code>Days</code> or <code>Years</code>.</p>
        pub fn mode(mut self, input: crate::model::ObjectLockRetentionMode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>The default Object Lock retention mode you want to apply to new objects placed in the specified bucket. Must be used with either <code>Days</code> or <code>Years</code>.</p>
        pub fn set_mode(
            mut self,
            input: std::option::Option<crate::model::ObjectLockRetentionMode>,
        ) -> Self {
            self.mode = input;
            self
        }
        /// <p>The number of days that you want to specify for the default retention period. Must be used with <code>Mode</code>.</p>
        pub fn days(mut self, input: i32) -> Self {
            self.days = Some(input);
            self
        }
        /// <p>The number of days that you want to specify for the default retention period. Must be used with <code>Mode</code>.</p>
        pub fn set_days(mut self, input: std::option::Option<i32>) -> Self {
            self.days = input;
            self
        }
        /// <p>The number of years that you want to specify for the default retention period. Must be used with <code>Mode</code>.</p>
        pub fn years(mut self, input: i32) -> Self {
            self.years = Some(input);
            self
        }
        /// <p>The number of years that you want to specify for the default retention period. Must be used with <code>Mode</code>.</p>
        pub fn set_years(mut self, input: std::option::Option<i32>) -> Self {
            self.years = input;
            self
        }
        /// Consumes the builder and constructs a [`DefaultRetention`](crate::model::DefaultRetention)
        pub fn build(self) -> crate::model::DefaultRetention {
            crate::model::DefaultRetention {
                mode: self.mode,
                days: self.days.unwrap_or_default(),
                years: self.years.unwrap_or_default(),
            }
        }
    }
}
impl DefaultRetention {
    /// Creates a new builder-style object to manufacture [`DefaultRetention`](crate::model::DefaultRetention)
    pub fn builder() -> crate::model::default_retention::Builder {
        crate::model::default_retention::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ObjectLockEnabled {
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ObjectLockEnabled {
    fn from(s: &str) -> Self {
        match s {
            "Enabled" => ObjectLockEnabled::Enabled,
            other => ObjectLockEnabled::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ObjectLockEnabled {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ObjectLockEnabled::from(s))
    }
}
impl ObjectLockEnabled {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ObjectLockEnabled::Enabled => "Enabled",
            ObjectLockEnabled::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Enabled"]
    }
}
impl AsRef<str> for ObjectLockEnabled {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A Legal Hold configuration for an object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ObjectLockLegalHold {
    /// <p>Indicates whether the specified object has a Legal Hold in place.</p>
    pub status: std::option::Option<crate::model::ObjectLockLegalHoldStatus>,
}
impl ObjectLockLegalHold {
    /// <p>Indicates whether the specified object has a Legal Hold in place.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ObjectLockLegalHoldStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for ObjectLockLegalHold {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ObjectLockLegalHold");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ObjectLockLegalHold`](crate::model::ObjectLockLegalHold)
pub mod object_lock_legal_hold {
    /// A builder for [`ObjectLockLegalHold`](crate::model::ObjectLockLegalHold)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::ObjectLockLegalHoldStatus>,
    }
    impl Builder {
        /// <p>Indicates whether the specified object has a Legal Hold in place.</p>
        pub fn status(mut self, input: crate::model::ObjectLockLegalHoldStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Indicates whether the specified object has a Legal Hold in place.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ObjectLockLegalHoldStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ObjectLockLegalHold`](crate::model::ObjectLockLegalHold)
        pub fn build(self) -> crate::model::ObjectLockLegalHold {
            crate::model::ObjectLockLegalHold {
                status: self.status,
            }
        }
    }
}
impl ObjectLockLegalHold {
    /// Creates a new builder-style object to manufacture [`ObjectLockLegalHold`](crate::model::ObjectLockLegalHold)
    pub fn builder() -> crate::model::object_lock_legal_hold::Builder {
        crate::model::object_lock_legal_hold::Builder::default()
    }
}

/// <p>Contains the elements that set the ACL permissions for an object per grantee.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessControlPolicy {
    /// <p>A list of grants.</p>
    pub grants: std::option::Option<std::vec::Vec<crate::model::Grant>>,
    /// <p>Container for the bucket owner's display name and ID.</p>
    pub owner: std::option::Option<crate::model::Owner>,
}
impl AccessControlPolicy {
    /// <p>A list of grants.</p>
    pub fn grants(&self) -> std::option::Option<&[crate::model::Grant]> {
        self.grants.as_deref()
    }
    /// <p>Container for the bucket owner's display name and ID.</p>
    pub fn owner(&self) -> std::option::Option<&crate::model::Owner> {
        self.owner.as_ref()
    }
}
impl std::fmt::Debug for AccessControlPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessControlPolicy");
        formatter.field("grants", &self.grants);
        formatter.field("owner", &self.owner);
        formatter.finish()
    }
}
/// See [`AccessControlPolicy`](crate::model::AccessControlPolicy)
pub mod access_control_policy {
    /// A builder for [`AccessControlPolicy`](crate::model::AccessControlPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) grants: std::option::Option<std::vec::Vec<crate::model::Grant>>,
        pub(crate) owner: std::option::Option<crate::model::Owner>,
    }
    impl Builder {
        /// Appends an item to `grants`.
        ///
        /// To override the contents of this collection use [`set_grants`](Self::set_grants).
        ///
        /// <p>A list of grants.</p>
        pub fn grants(mut self, input: crate::model::Grant) -> Self {
            let mut v = self.grants.unwrap_or_default();
            v.push(input);
            self.grants = Some(v);
            self
        }
        /// <p>A list of grants.</p>
        pub fn set_grants(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Grant>>,
        ) -> Self {
            self.grants = input;
            self
        }
        /// <p>Container for the bucket owner's display name and ID.</p>
        pub fn owner(mut self, input: crate::model::Owner) -> Self {
            self.owner = Some(input);
            self
        }
        /// <p>Container for the bucket owner's display name and ID.</p>
        pub fn set_owner(mut self, input: std::option::Option<crate::model::Owner>) -> Self {
            self.owner = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessControlPolicy`](crate::model::AccessControlPolicy)
        pub fn build(self) -> crate::model::AccessControlPolicy {
            crate::model::AccessControlPolicy {
                grants: self.grants,
                owner: self.owner,
            }
        }
    }
}
impl AccessControlPolicy {
    /// Creates a new builder-style object to manufacture [`AccessControlPolicy`](crate::model::AccessControlPolicy)
    pub fn builder() -> crate::model::access_control_policy::Builder {
        crate::model::access_control_policy::Builder::default()
    }
}

/// <p>Container for the owner's display name and ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Owner {
    /// <p>Container for the display name of the owner.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>Container for the ID of the owner.</p>
    pub id: std::option::Option<std::string::String>,
}
impl Owner {
    /// <p>Container for the display name of the owner.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>Container for the ID of the owner.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for Owner {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Owner");
        formatter.field("display_name", &self.display_name);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`Owner`](crate::model::Owner)
pub mod owner {
    /// A builder for [`Owner`](crate::model::Owner)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Container for the display name of the owner.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>Container for the display name of the owner.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>Container for the ID of the owner.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Container for the ID of the owner.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`Owner`](crate::model::Owner)
        pub fn build(self) -> crate::model::Owner {
            crate::model::Owner {
                display_name: self.display_name,
                id: self.id,
            }
        }
    }
}
impl Owner {
    /// Creates a new builder-style object to manufacture [`Owner`](crate::model::Owner)
    pub fn builder() -> crate::model::owner::Builder {
        crate::model::owner::Builder::default()
    }
}

/// <p>Specifies website configuration parameters for an Amazon S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WebsiteConfiguration {
    /// <p>The name of the error document for the website.</p>
    pub error_document: std::option::Option<crate::model::ErrorDocument>,
    /// <p>The name of the index document for the website.</p>
    pub index_document: std::option::Option<crate::model::IndexDocument>,
    /// <p>The redirect behavior for every request to this bucket's website endpoint.</p> <important>
    /// <p>If you specify this property, you can't specify any other property.</p>
    /// </important>
    pub redirect_all_requests_to: std::option::Option<crate::model::RedirectAllRequestsTo>,
    /// <p>Rules that define when a redirect is applied and the redirect behavior.</p>
    pub routing_rules: std::option::Option<std::vec::Vec<crate::model::RoutingRule>>,
}
impl WebsiteConfiguration {
    /// <p>The name of the error document for the website.</p>
    pub fn error_document(&self) -> std::option::Option<&crate::model::ErrorDocument> {
        self.error_document.as_ref()
    }
    /// <p>The name of the index document for the website.</p>
    pub fn index_document(&self) -> std::option::Option<&crate::model::IndexDocument> {
        self.index_document.as_ref()
    }
    /// <p>The redirect behavior for every request to this bucket's website endpoint.</p> <important>
    /// <p>If you specify this property, you can't specify any other property.</p>
    /// </important>
    pub fn redirect_all_requests_to(
        &self,
    ) -> std::option::Option<&crate::model::RedirectAllRequestsTo> {
        self.redirect_all_requests_to.as_ref()
    }
    /// <p>Rules that define when a redirect is applied and the redirect behavior.</p>
    pub fn routing_rules(&self) -> std::option::Option<&[crate::model::RoutingRule]> {
        self.routing_rules.as_deref()
    }
}
impl std::fmt::Debug for WebsiteConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WebsiteConfiguration");
        formatter.field("error_document", &self.error_document);
        formatter.field("index_document", &self.index_document);
        formatter.field("redirect_all_requests_to", &self.redirect_all_requests_to);
        formatter.field("routing_rules", &self.routing_rules);
        formatter.finish()
    }
}
/// See [`WebsiteConfiguration`](crate::model::WebsiteConfiguration)
pub mod website_configuration {
    /// A builder for [`WebsiteConfiguration`](crate::model::WebsiteConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_document: std::option::Option<crate::model::ErrorDocument>,
        pub(crate) index_document: std::option::Option<crate::model::IndexDocument>,
        pub(crate) redirect_all_requests_to:
            std::option::Option<crate::model::RedirectAllRequestsTo>,
        pub(crate) routing_rules: std::option::Option<std::vec::Vec<crate::model::RoutingRule>>,
    }
    impl Builder {
        /// <p>The name of the error document for the website.</p>
        pub fn error_document(mut self, input: crate::model::ErrorDocument) -> Self {
            self.error_document = Some(input);
            self
        }
        /// <p>The name of the error document for the website.</p>
        pub fn set_error_document(
            mut self,
            input: std::option::Option<crate::model::ErrorDocument>,
        ) -> Self {
            self.error_document = input;
            self
        }
        /// <p>The name of the index document for the website.</p>
        pub fn index_document(mut self, input: crate::model::IndexDocument) -> Self {
            self.index_document = Some(input);
            self
        }
        /// <p>The name of the index document for the website.</p>
        pub fn set_index_document(
            mut self,
            input: std::option::Option<crate::model::IndexDocument>,
        ) -> Self {
            self.index_document = input;
            self
        }
        /// <p>The redirect behavior for every request to this bucket's website endpoint.</p> <important>
        /// <p>If you specify this property, you can't specify any other property.</p>
        /// </important>
        pub fn redirect_all_requests_to(
            mut self,
            input: crate::model::RedirectAllRequestsTo,
        ) -> Self {
            self.redirect_all_requests_to = Some(input);
            self
        }
        /// <p>The redirect behavior for every request to this bucket's website endpoint.</p> <important>
        /// <p>If you specify this property, you can't specify any other property.</p>
        /// </important>
        pub fn set_redirect_all_requests_to(
            mut self,
            input: std::option::Option<crate::model::RedirectAllRequestsTo>,
        ) -> Self {
            self.redirect_all_requests_to = input;
            self
        }
        /// Appends an item to `routing_rules`.
        ///
        /// To override the contents of this collection use [`set_routing_rules`](Self::set_routing_rules).
        ///
        /// <p>Rules that define when a redirect is applied and the redirect behavior.</p>
        pub fn routing_rules(mut self, input: crate::model::RoutingRule) -> Self {
            let mut v = self.routing_rules.unwrap_or_default();
            v.push(input);
            self.routing_rules = Some(v);
            self
        }
        /// <p>Rules that define when a redirect is applied and the redirect behavior.</p>
        pub fn set_routing_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RoutingRule>>,
        ) -> Self {
            self.routing_rules = input;
            self
        }
        /// Consumes the builder and constructs a [`WebsiteConfiguration`](crate::model::WebsiteConfiguration)
        pub fn build(self) -> crate::model::WebsiteConfiguration {
            crate::model::WebsiteConfiguration {
                error_document: self.error_document,
                index_document: self.index_document,
                redirect_all_requests_to: self.redirect_all_requests_to,
                routing_rules: self.routing_rules,
            }
        }
    }
}
impl WebsiteConfiguration {
    /// Creates a new builder-style object to manufacture [`WebsiteConfiguration`](crate::model::WebsiteConfiguration)
    pub fn builder() -> crate::model::website_configuration::Builder {
        crate::model::website_configuration::Builder::default()
    }
}

/// <p>Specifies the redirect behavior and when a redirect is applied. For more information about routing rules, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html#advanced-conditional-redirects">Configuring advanced conditional redirects</a> in the <i>Amazon S3 User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RoutingRule {
    /// <p>A container for describing a condition that must be met for the specified redirect to apply. For example, 1. If request is for pages in the <code>/docs</code> folder, redirect to the <code>/documents</code> folder. 2. If request results in HTTP error 4xx, redirect request to another host where you might process the error.</p>
    pub condition: std::option::Option<crate::model::Condition>,
    /// <p>Container for redirect information. You can redirect requests to another host, to another page, or with another protocol. In the event of an error, you can specify a different error code to return.</p>
    pub redirect: std::option::Option<crate::model::Redirect>,
}
impl RoutingRule {
    /// <p>A container for describing a condition that must be met for the specified redirect to apply. For example, 1. If request is for pages in the <code>/docs</code> folder, redirect to the <code>/documents</code> folder. 2. If request results in HTTP error 4xx, redirect request to another host where you might process the error.</p>
    pub fn condition(&self) -> std::option::Option<&crate::model::Condition> {
        self.condition.as_ref()
    }
    /// <p>Container for redirect information. You can redirect requests to another host, to another page, or with another protocol. In the event of an error, you can specify a different error code to return.</p>
    pub fn redirect(&self) -> std::option::Option<&crate::model::Redirect> {
        self.redirect.as_ref()
    }
}
impl std::fmt::Debug for RoutingRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RoutingRule");
        formatter.field("condition", &self.condition);
        formatter.field("redirect", &self.redirect);
        formatter.finish()
    }
}
/// See [`RoutingRule`](crate::model::RoutingRule)
pub mod routing_rule {
    /// A builder for [`RoutingRule`](crate::model::RoutingRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) condition: std::option::Option<crate::model::Condition>,
        pub(crate) redirect: std::option::Option<crate::model::Redirect>,
    }
    impl Builder {
        /// <p>A container for describing a condition that must be met for the specified redirect to apply. For example, 1. If request is for pages in the <code>/docs</code> folder, redirect to the <code>/documents</code> folder. 2. If request results in HTTP error 4xx, redirect request to another host where you might process the error.</p>
        pub fn condition(mut self, input: crate::model::Condition) -> Self {
            self.condition = Some(input);
            self
        }
        /// <p>A container for describing a condition that must be met for the specified redirect to apply. For example, 1. If request is for pages in the <code>/docs</code> folder, redirect to the <code>/documents</code> folder. 2. If request results in HTTP error 4xx, redirect request to another host where you might process the error.</p>
        pub fn set_condition(
            mut self,
            input: std::option::Option<crate::model::Condition>,
        ) -> Self {
            self.condition = input;
            self
        }
        /// <p>Container for redirect information. You can redirect requests to another host, to another page, or with another protocol. In the event of an error, you can specify a different error code to return.</p>
        pub fn redirect(mut self, input: crate::model::Redirect) -> Self {
            self.redirect = Some(input);
            self
        }
        /// <p>Container for redirect information. You can redirect requests to another host, to another page, or with another protocol. In the event of an error, you can specify a different error code to return.</p>
        pub fn set_redirect(mut self, input: std::option::Option<crate::model::Redirect>) -> Self {
            self.redirect = input;
            self
        }
        /// Consumes the builder and constructs a [`RoutingRule`](crate::model::RoutingRule)
        pub fn build(self) -> crate::model::RoutingRule {
            crate::model::RoutingRule {
                condition: self.condition,
                redirect: self.redirect,
            }
        }
    }
}
impl RoutingRule {
    /// Creates a new builder-style object to manufacture [`RoutingRule`](crate::model::RoutingRule)
    pub fn builder() -> crate::model::routing_rule::Builder {
        crate::model::routing_rule::Builder::default()
    }
}

/// <p>Specifies how requests are redirected. In the event of an error, you can specify a different error code to return.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Redirect {
    /// <p>The host name to use in the redirect request.</p>
    pub host_name: std::option::Option<std::string::String>,
    /// <p>The HTTP redirect code to use on the response. Not required if one of the siblings is present.</p>
    pub http_redirect_code: std::option::Option<std::string::String>,
    /// <p>Protocol to use when redirecting requests. The default is the protocol that is used in the original request.</p>
    pub protocol: std::option::Option<crate::model::Protocol>,
    /// <p>The object key prefix to use in the redirect request. For example, to redirect requests for all pages with prefix <code>docs/</code> (objects in the <code>docs/</code> folder) to <code>documents/</code>, you can set a condition block with <code>KeyPrefixEquals</code> set to <code>docs/</code> and in the Redirect set <code>ReplaceKeyPrefixWith</code> to <code>/documents</code>. Not required if one of the siblings is present. Can be present only if <code>ReplaceKeyWith</code> is not provided.</p> <important>
    /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
    /// </important>
    pub replace_key_prefix_with: std::option::Option<std::string::String>,
    /// <p>The specific object key to use in the redirect request. For example, redirect request to <code>error.html</code>. Not required if one of the siblings is present. Can be present only if <code>ReplaceKeyPrefixWith</code> is not provided.</p> <important>
    /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
    /// </important>
    pub replace_key_with: std::option::Option<std::string::String>,
}
impl Redirect {
    /// <p>The host name to use in the redirect request.</p>
    pub fn host_name(&self) -> std::option::Option<&str> {
        self.host_name.as_deref()
    }
    /// <p>The HTTP redirect code to use on the response. Not required if one of the siblings is present.</p>
    pub fn http_redirect_code(&self) -> std::option::Option<&str> {
        self.http_redirect_code.as_deref()
    }
    /// <p>Protocol to use when redirecting requests. The default is the protocol that is used in the original request.</p>
    pub fn protocol(&self) -> std::option::Option<&crate::model::Protocol> {
        self.protocol.as_ref()
    }
    /// <p>The object key prefix to use in the redirect request. For example, to redirect requests for all pages with prefix <code>docs/</code> (objects in the <code>docs/</code> folder) to <code>documents/</code>, you can set a condition block with <code>KeyPrefixEquals</code> set to <code>docs/</code> and in the Redirect set <code>ReplaceKeyPrefixWith</code> to <code>/documents</code>. Not required if one of the siblings is present. Can be present only if <code>ReplaceKeyWith</code> is not provided.</p> <important>
    /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
    /// </important>
    pub fn replace_key_prefix_with(&self) -> std::option::Option<&str> {
        self.replace_key_prefix_with.as_deref()
    }
    /// <p>The specific object key to use in the redirect request. For example, redirect request to <code>error.html</code>. Not required if one of the siblings is present. Can be present only if <code>ReplaceKeyPrefixWith</code> is not provided.</p> <important>
    /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
    /// </important>
    pub fn replace_key_with(&self) -> std::option::Option<&str> {
        self.replace_key_with.as_deref()
    }
}
impl std::fmt::Debug for Redirect {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Redirect");
        formatter.field("host_name", &self.host_name);
        formatter.field("http_redirect_code", &self.http_redirect_code);
        formatter.field("protocol", &self.protocol);
        formatter.field("replace_key_prefix_with", &self.replace_key_prefix_with);
        formatter.field("replace_key_with", &self.replace_key_with);
        formatter.finish()
    }
}
/// See [`Redirect`](crate::model::Redirect)
pub mod redirect {
    /// A builder for [`Redirect`](crate::model::Redirect)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) host_name: std::option::Option<std::string::String>,
        pub(crate) http_redirect_code: std::option::Option<std::string::String>,
        pub(crate) protocol: std::option::Option<crate::model::Protocol>,
        pub(crate) replace_key_prefix_with: std::option::Option<std::string::String>,
        pub(crate) replace_key_with: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The host name to use in the redirect request.</p>
        pub fn host_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.host_name = Some(input.into());
            self
        }
        /// <p>The host name to use in the redirect request.</p>
        pub fn set_host_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host_name = input;
            self
        }
        /// <p>The HTTP redirect code to use on the response. Not required if one of the siblings is present.</p>
        pub fn http_redirect_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_redirect_code = Some(input.into());
            self
        }
        /// <p>The HTTP redirect code to use on the response. Not required if one of the siblings is present.</p>
        pub fn set_http_redirect_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.http_redirect_code = input;
            self
        }
        /// <p>Protocol to use when redirecting requests. The default is the protocol that is used in the original request.</p>
        pub fn protocol(mut self, input: crate::model::Protocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>Protocol to use when redirecting requests. The default is the protocol that is used in the original request.</p>
        pub fn set_protocol(mut self, input: std::option::Option<crate::model::Protocol>) -> Self {
            self.protocol = input;
            self
        }
        /// <p>The object key prefix to use in the redirect request. For example, to redirect requests for all pages with prefix <code>docs/</code> (objects in the <code>docs/</code> folder) to <code>documents/</code>, you can set a condition block with <code>KeyPrefixEquals</code> set to <code>docs/</code> and in the Redirect set <code>ReplaceKeyPrefixWith</code> to <code>/documents</code>. Not required if one of the siblings is present. Can be present only if <code>ReplaceKeyWith</code> is not provided.</p> <important>
        /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
        /// </important>
        pub fn replace_key_prefix_with(mut self, input: impl Into<std::string::String>) -> Self {
            self.replace_key_prefix_with = Some(input.into());
            self
        }
        /// <p>The object key prefix to use in the redirect request. For example, to redirect requests for all pages with prefix <code>docs/</code> (objects in the <code>docs/</code> folder) to <code>documents/</code>, you can set a condition block with <code>KeyPrefixEquals</code> set to <code>docs/</code> and in the Redirect set <code>ReplaceKeyPrefixWith</code> to <code>/documents</code>. Not required if one of the siblings is present. Can be present only if <code>ReplaceKeyWith</code> is not provided.</p> <important>
        /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
        /// </important>
        pub fn set_replace_key_prefix_with(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replace_key_prefix_with = input;
            self
        }
        /// <p>The specific object key to use in the redirect request. For example, redirect request to <code>error.html</code>. Not required if one of the siblings is present. Can be present only if <code>ReplaceKeyPrefixWith</code> is not provided.</p> <important>
        /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
        /// </important>
        pub fn replace_key_with(mut self, input: impl Into<std::string::String>) -> Self {
            self.replace_key_with = Some(input.into());
            self
        }
        /// <p>The specific object key to use in the redirect request. For example, redirect request to <code>error.html</code>. Not required if one of the siblings is present. Can be present only if <code>ReplaceKeyPrefixWith</code> is not provided.</p> <important>
        /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
        /// </important>
        pub fn set_replace_key_with(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replace_key_with = input;
            self
        }
        /// Consumes the builder and constructs a [`Redirect`](crate::model::Redirect)
        pub fn build(self) -> crate::model::Redirect {
            crate::model::Redirect {
                host_name: self.host_name,
                http_redirect_code: self.http_redirect_code,
                protocol: self.protocol,
                replace_key_prefix_with: self.replace_key_prefix_with,
                replace_key_with: self.replace_key_with,
            }
        }
    }
}
impl Redirect {
    /// Creates a new builder-style object to manufacture [`Redirect`](crate::model::Redirect)
    pub fn builder() -> crate::model::redirect::Builder {
        crate::model::redirect::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Protocol {
    #[allow(missing_docs)] // documentation missing in model
    Http,
    #[allow(missing_docs)] // documentation missing in model
    Https,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Protocol {
    fn from(s: &str) -> Self {
        match s {
            "http" => Protocol::Http,
            "https" => Protocol::Https,
            other => Protocol::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Protocol {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Protocol::from(s))
    }
}
impl Protocol {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Protocol::Http => "http",
            Protocol::Https => "https",
            Protocol::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["http", "https"]
    }
}
impl AsRef<str> for Protocol {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A container for describing a condition that must be met for the specified redirect to apply. For example, 1. If request is for pages in the <code>/docs</code> folder, redirect to the <code>/documents</code> folder. 2. If request results in HTTP error 4xx, redirect request to another host where you might process the error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Condition {
    /// <p>The HTTP error code when the redirect is applied. In the event of an error, if the error code equals this value, then the specified redirect is applied. Required when parent element <code>Condition</code> is specified and sibling <code>KeyPrefixEquals</code> is not specified. If both are specified, then both must be true for the redirect to be applied.</p>
    pub http_error_code_returned_equals: std::option::Option<std::string::String>,
    /// <p>The object key name prefix when the redirect is applied. For example, to redirect requests for <code>ExamplePage.html</code>, the key prefix will be <code>ExamplePage.html</code>. To redirect request for all pages with the prefix <code>docs/</code>, the key prefix will be <code>/docs</code>, which identifies all objects in the <code>docs/</code> folder. Required when the parent element <code>Condition</code> is specified and sibling <code>HttpErrorCodeReturnedEquals</code> is not specified. If both conditions are specified, both must be true for the redirect to be applied.</p> <important>
    /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
    /// </important>
    pub key_prefix_equals: std::option::Option<std::string::String>,
}
impl Condition {
    /// <p>The HTTP error code when the redirect is applied. In the event of an error, if the error code equals this value, then the specified redirect is applied. Required when parent element <code>Condition</code> is specified and sibling <code>KeyPrefixEquals</code> is not specified. If both are specified, then both must be true for the redirect to be applied.</p>
    pub fn http_error_code_returned_equals(&self) -> std::option::Option<&str> {
        self.http_error_code_returned_equals.as_deref()
    }
    /// <p>The object key name prefix when the redirect is applied. For example, to redirect requests for <code>ExamplePage.html</code>, the key prefix will be <code>ExamplePage.html</code>. To redirect request for all pages with the prefix <code>docs/</code>, the key prefix will be <code>/docs</code>, which identifies all objects in the <code>docs/</code> folder. Required when the parent element <code>Condition</code> is specified and sibling <code>HttpErrorCodeReturnedEquals</code> is not specified. If both conditions are specified, both must be true for the redirect to be applied.</p> <important>
    /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
    /// </important>
    pub fn key_prefix_equals(&self) -> std::option::Option<&str> {
        self.key_prefix_equals.as_deref()
    }
}
impl std::fmt::Debug for Condition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Condition");
        formatter.field(
            "http_error_code_returned_equals",
            &self.http_error_code_returned_equals,
        );
        formatter.field("key_prefix_equals", &self.key_prefix_equals);
        formatter.finish()
    }
}
/// See [`Condition`](crate::model::Condition)
pub mod condition {
    /// A builder for [`Condition`](crate::model::Condition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) http_error_code_returned_equals: std::option::Option<std::string::String>,
        pub(crate) key_prefix_equals: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The HTTP error code when the redirect is applied. In the event of an error, if the error code equals this value, then the specified redirect is applied. Required when parent element <code>Condition</code> is specified and sibling <code>KeyPrefixEquals</code> is not specified. If both are specified, then both must be true for the redirect to be applied.</p>
        pub fn http_error_code_returned_equals(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.http_error_code_returned_equals = Some(input.into());
            self
        }
        /// <p>The HTTP error code when the redirect is applied. In the event of an error, if the error code equals this value, then the specified redirect is applied. Required when parent element <code>Condition</code> is specified and sibling <code>KeyPrefixEquals</code> is not specified. If both are specified, then both must be true for the redirect to be applied.</p>
        pub fn set_http_error_code_returned_equals(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.http_error_code_returned_equals = input;
            self
        }
        /// <p>The object key name prefix when the redirect is applied. For example, to redirect requests for <code>ExamplePage.html</code>, the key prefix will be <code>ExamplePage.html</code>. To redirect request for all pages with the prefix <code>docs/</code>, the key prefix will be <code>/docs</code>, which identifies all objects in the <code>docs/</code> folder. Required when the parent element <code>Condition</code> is specified and sibling <code>HttpErrorCodeReturnedEquals</code> is not specified. If both conditions are specified, both must be true for the redirect to be applied.</p> <important>
        /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
        /// </important>
        pub fn key_prefix_equals(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_prefix_equals = Some(input.into());
            self
        }
        /// <p>The object key name prefix when the redirect is applied. For example, to redirect requests for <code>ExamplePage.html</code>, the key prefix will be <code>ExamplePage.html</code>. To redirect request for all pages with the prefix <code>docs/</code>, the key prefix will be <code>/docs</code>, which identifies all objects in the <code>docs/</code> folder. Required when the parent element <code>Condition</code> is specified and sibling <code>HttpErrorCodeReturnedEquals</code> is not specified. If both conditions are specified, both must be true for the redirect to be applied.</p> <important>
        /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
        /// </important>
        pub fn set_key_prefix_equals(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.key_prefix_equals = input;
            self
        }
        /// Consumes the builder and constructs a [`Condition`](crate::model::Condition)
        pub fn build(self) -> crate::model::Condition {
            crate::model::Condition {
                http_error_code_returned_equals: self.http_error_code_returned_equals,
                key_prefix_equals: self.key_prefix_equals,
            }
        }
    }
}
impl Condition {
    /// Creates a new builder-style object to manufacture [`Condition`](crate::model::Condition)
    pub fn builder() -> crate::model::condition::Builder {
        crate::model::condition::Builder::default()
    }
}

/// <p>Specifies the redirect behavior of all requests to a website endpoint of an Amazon S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RedirectAllRequestsTo {
    /// <p>Name of the host where requests are redirected.</p>
    pub host_name: std::option::Option<std::string::String>,
    /// <p>Protocol to use when redirecting requests. The default is the protocol that is used in the original request.</p>
    pub protocol: std::option::Option<crate::model::Protocol>,
}
impl RedirectAllRequestsTo {
    /// <p>Name of the host where requests are redirected.</p>
    pub fn host_name(&self) -> std::option::Option<&str> {
        self.host_name.as_deref()
    }
    /// <p>Protocol to use when redirecting requests. The default is the protocol that is used in the original request.</p>
    pub fn protocol(&self) -> std::option::Option<&crate::model::Protocol> {
        self.protocol.as_ref()
    }
}
impl std::fmt::Debug for RedirectAllRequestsTo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RedirectAllRequestsTo");
        formatter.field("host_name", &self.host_name);
        formatter.field("protocol", &self.protocol);
        formatter.finish()
    }
}
/// See [`RedirectAllRequestsTo`](crate::model::RedirectAllRequestsTo)
pub mod redirect_all_requests_to {
    /// A builder for [`RedirectAllRequestsTo`](crate::model::RedirectAllRequestsTo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) host_name: std::option::Option<std::string::String>,
        pub(crate) protocol: std::option::Option<crate::model::Protocol>,
    }
    impl Builder {
        /// <p>Name of the host where requests are redirected.</p>
        pub fn host_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.host_name = Some(input.into());
            self
        }
        /// <p>Name of the host where requests are redirected.</p>
        pub fn set_host_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.host_name = input;
            self
        }
        /// <p>Protocol to use when redirecting requests. The default is the protocol that is used in the original request.</p>
        pub fn protocol(mut self, input: crate::model::Protocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>Protocol to use when redirecting requests. The default is the protocol that is used in the original request.</p>
        pub fn set_protocol(mut self, input: std::option::Option<crate::model::Protocol>) -> Self {
            self.protocol = input;
            self
        }
        /// Consumes the builder and constructs a [`RedirectAllRequestsTo`](crate::model::RedirectAllRequestsTo)
        pub fn build(self) -> crate::model::RedirectAllRequestsTo {
            crate::model::RedirectAllRequestsTo {
                host_name: self.host_name,
                protocol: self.protocol,
            }
        }
    }
}
impl RedirectAllRequestsTo {
    /// Creates a new builder-style object to manufacture [`RedirectAllRequestsTo`](crate::model::RedirectAllRequestsTo)
    pub fn builder() -> crate::model::redirect_all_requests_to::Builder {
        crate::model::redirect_all_requests_to::Builder::default()
    }
}

/// <p>Container for the <code>Suffix</code> element.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IndexDocument {
    /// <p>A suffix that is appended to a request that is for a directory on the website endpoint (for example,if the suffix is index.html and you make a request to samplebucket/images/ the data that is returned will be for the object with the key name images/index.html) The suffix must not be empty and must not include a slash character.</p> <important>
    /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
    /// </important>
    pub suffix: std::option::Option<std::string::String>,
}
impl IndexDocument {
    /// <p>A suffix that is appended to a request that is for a directory on the website endpoint (for example,if the suffix is index.html and you make a request to samplebucket/images/ the data that is returned will be for the object with the key name images/index.html) The suffix must not be empty and must not include a slash character.</p> <important>
    /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
    /// </important>
    pub fn suffix(&self) -> std::option::Option<&str> {
        self.suffix.as_deref()
    }
}
impl std::fmt::Debug for IndexDocument {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IndexDocument");
        formatter.field("suffix", &self.suffix);
        formatter.finish()
    }
}
/// See [`IndexDocument`](crate::model::IndexDocument)
pub mod index_document {
    /// A builder for [`IndexDocument`](crate::model::IndexDocument)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) suffix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A suffix that is appended to a request that is for a directory on the website endpoint (for example,if the suffix is index.html and you make a request to samplebucket/images/ the data that is returned will be for the object with the key name images/index.html) The suffix must not be empty and must not include a slash character.</p> <important>
        /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
        /// </important>
        pub fn suffix(mut self, input: impl Into<std::string::String>) -> Self {
            self.suffix = Some(input.into());
            self
        }
        /// <p>A suffix that is appended to a request that is for a directory on the website endpoint (for example,if the suffix is index.html and you make a request to samplebucket/images/ the data that is returned will be for the object with the key name images/index.html) The suffix must not be empty and must not include a slash character.</p> <important>
        /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
        /// </important>
        pub fn set_suffix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.suffix = input;
            self
        }
        /// Consumes the builder and constructs a [`IndexDocument`](crate::model::IndexDocument)
        pub fn build(self) -> crate::model::IndexDocument {
            crate::model::IndexDocument {
                suffix: self.suffix,
            }
        }
    }
}
impl IndexDocument {
    /// Creates a new builder-style object to manufacture [`IndexDocument`](crate::model::IndexDocument)
    pub fn builder() -> crate::model::index_document::Builder {
        crate::model::index_document::Builder::default()
    }
}

/// <p>The error information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ErrorDocument {
    /// <p>The object key name to use when a 4XX class error occurs.</p> <important>
    /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
    /// </important>
    pub key: std::option::Option<std::string::String>,
}
impl ErrorDocument {
    /// <p>The object key name to use when a 4XX class error occurs.</p> <important>
    /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
    /// </important>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
}
impl std::fmt::Debug for ErrorDocument {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ErrorDocument");
        formatter.field("key", &self.key);
        formatter.finish()
    }
}
/// See [`ErrorDocument`](crate::model::ErrorDocument)
pub mod error_document {
    /// A builder for [`ErrorDocument`](crate::model::ErrorDocument)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The object key name to use when a 4XX class error occurs.</p> <important>
        /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
        /// </important>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The object key name to use when a 4XX class error occurs.</p> <important>
        /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
        /// </important>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Consumes the builder and constructs a [`ErrorDocument`](crate::model::ErrorDocument)
        pub fn build(self) -> crate::model::ErrorDocument {
            crate::model::ErrorDocument { key: self.key }
        }
    }
}
impl ErrorDocument {
    /// Creates a new builder-style object to manufacture [`ErrorDocument`](crate::model::ErrorDocument)
    pub fn builder() -> crate::model::error_document::Builder {
        crate::model::error_document::Builder::default()
    }
}

/// <p>Describes the versioning state of an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTVersioningStatus.html">PUT Bucket versioning</a> in the <i>Amazon S3 API Reference</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VersioningConfiguration {
    /// <p>Specifies whether MFA delete is enabled in the bucket versioning configuration. This element is only returned if the bucket has been configured with MFA delete. If the bucket has never been so configured, this element is not returned.</p>
    pub mfa_delete: std::option::Option<crate::model::MfaDelete>,
    /// <p>The versioning state of the bucket.</p>
    pub status: std::option::Option<crate::model::BucketVersioningStatus>,
}
impl VersioningConfiguration {
    /// <p>Specifies whether MFA delete is enabled in the bucket versioning configuration. This element is only returned if the bucket has been configured with MFA delete. If the bucket has never been so configured, this element is not returned.</p>
    pub fn mfa_delete(&self) -> std::option::Option<&crate::model::MfaDelete> {
        self.mfa_delete.as_ref()
    }
    /// <p>The versioning state of the bucket.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::BucketVersioningStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for VersioningConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VersioningConfiguration");
        formatter.field("mfa_delete", &self.mfa_delete);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`VersioningConfiguration`](crate::model::VersioningConfiguration)
pub mod versioning_configuration {
    /// A builder for [`VersioningConfiguration`](crate::model::VersioningConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mfa_delete: std::option::Option<crate::model::MfaDelete>,
        pub(crate) status: std::option::Option<crate::model::BucketVersioningStatus>,
    }
    impl Builder {
        /// <p>Specifies whether MFA delete is enabled in the bucket versioning configuration. This element is only returned if the bucket has been configured with MFA delete. If the bucket has never been so configured, this element is not returned.</p>
        pub fn mfa_delete(mut self, input: crate::model::MfaDelete) -> Self {
            self.mfa_delete = Some(input);
            self
        }
        /// <p>Specifies whether MFA delete is enabled in the bucket versioning configuration. This element is only returned if the bucket has been configured with MFA delete. If the bucket has never been so configured, this element is not returned.</p>
        pub fn set_mfa_delete(
            mut self,
            input: std::option::Option<crate::model::MfaDelete>,
        ) -> Self {
            self.mfa_delete = input;
            self
        }
        /// <p>The versioning state of the bucket.</p>
        pub fn status(mut self, input: crate::model::BucketVersioningStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The versioning state of the bucket.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::BucketVersioningStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`VersioningConfiguration`](crate::model::VersioningConfiguration)
        pub fn build(self) -> crate::model::VersioningConfiguration {
            crate::model::VersioningConfiguration {
                mfa_delete: self.mfa_delete,
                status: self.status,
            }
        }
    }
}
impl VersioningConfiguration {
    /// Creates a new builder-style object to manufacture [`VersioningConfiguration`](crate::model::VersioningConfiguration)
    pub fn builder() -> crate::model::versioning_configuration::Builder {
        crate::model::versioning_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BucketVersioningStatus {
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    Suspended,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BucketVersioningStatus {
    fn from(s: &str) -> Self {
        match s {
            "Enabled" => BucketVersioningStatus::Enabled,
            "Suspended" => BucketVersioningStatus::Suspended,
            other => BucketVersioningStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BucketVersioningStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BucketVersioningStatus::from(s))
    }
}
impl BucketVersioningStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BucketVersioningStatus::Enabled => "Enabled",
            BucketVersioningStatus::Suspended => "Suspended",
            BucketVersioningStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Enabled", "Suspended"]
    }
}
impl AsRef<str> for BucketVersioningStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MfaDelete {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MfaDelete {
    fn from(s: &str) -> Self {
        match s {
            "Disabled" => MfaDelete::Disabled,
            "Enabled" => MfaDelete::Enabled,
            other => MfaDelete::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MfaDelete {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MfaDelete::from(s))
    }
}
impl MfaDelete {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MfaDelete::Disabled => "Disabled",
            MfaDelete::Enabled => "Enabled",
            MfaDelete::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Disabled", "Enabled"]
    }
}
impl AsRef<str> for MfaDelete {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Container for Payer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestPaymentConfiguration {
    /// <p>Specifies who pays for the download and request fees.</p>
    pub payer: std::option::Option<crate::model::Payer>,
}
impl RequestPaymentConfiguration {
    /// <p>Specifies who pays for the download and request fees.</p>
    pub fn payer(&self) -> std::option::Option<&crate::model::Payer> {
        self.payer.as_ref()
    }
}
impl std::fmt::Debug for RequestPaymentConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestPaymentConfiguration");
        formatter.field("payer", &self.payer);
        formatter.finish()
    }
}
/// See [`RequestPaymentConfiguration`](crate::model::RequestPaymentConfiguration)
pub mod request_payment_configuration {
    /// A builder for [`RequestPaymentConfiguration`](crate::model::RequestPaymentConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) payer: std::option::Option<crate::model::Payer>,
    }
    impl Builder {
        /// <p>Specifies who pays for the download and request fees.</p>
        pub fn payer(mut self, input: crate::model::Payer) -> Self {
            self.payer = Some(input);
            self
        }
        /// <p>Specifies who pays for the download and request fees.</p>
        pub fn set_payer(mut self, input: std::option::Option<crate::model::Payer>) -> Self {
            self.payer = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestPaymentConfiguration`](crate::model::RequestPaymentConfiguration)
        pub fn build(self) -> crate::model::RequestPaymentConfiguration {
            crate::model::RequestPaymentConfiguration { payer: self.payer }
        }
    }
}
impl RequestPaymentConfiguration {
    /// Creates a new builder-style object to manufacture [`RequestPaymentConfiguration`](crate::model::RequestPaymentConfiguration)
    pub fn builder() -> crate::model::request_payment_configuration::Builder {
        crate::model::request_payment_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Payer {
    #[allow(missing_docs)] // documentation missing in model
    BucketOwner,
    #[allow(missing_docs)] // documentation missing in model
    Requester,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Payer {
    fn from(s: &str) -> Self {
        match s {
            "BucketOwner" => Payer::BucketOwner,
            "Requester" => Payer::Requester,
            other => Payer::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Payer {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Payer::from(s))
    }
}
impl Payer {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Payer::BucketOwner => "BucketOwner",
            Payer::Requester => "Requester",
            Payer::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BucketOwner", "Requester"]
    }
}
impl AsRef<str> for Payer {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A container for replication rules. You can add up to 1,000 rules. The maximum size of a replication configuration is 2 MB.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that Amazon S3 assumes when replicating objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-how-setup.html">How to Set Up Replication</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>A container for one or more replication rules. A replication configuration must have at least one rule and can contain a maximum of 1,000 rules. </p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::ReplicationRule>>,
}
impl ReplicationConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that Amazon S3 assumes when replicating objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-how-setup.html">How to Set Up Replication</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn role(&self) -> std::option::Option<&str> {
        self.role.as_deref()
    }
    /// <p>A container for one or more replication rules. A replication configuration must have at least one rule and can contain a maximum of 1,000 rules. </p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::ReplicationRule]> {
        self.rules.as_deref()
    }
}
impl std::fmt::Debug for ReplicationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationConfiguration");
        formatter.field("role", &self.role);
        formatter.field("rules", &self.rules);
        formatter.finish()
    }
}
/// See [`ReplicationConfiguration`](crate::model::ReplicationConfiguration)
pub mod replication_configuration {
    /// A builder for [`ReplicationConfiguration`](crate::model::ReplicationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::ReplicationRule>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that Amazon S3 assumes when replicating objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-how-setup.html">How to Set Up Replication</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that Amazon S3 assumes when replicating objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-how-setup.html">How to Set Up Replication</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>A container for one or more replication rules. A replication configuration must have at least one rule and can contain a maximum of 1,000 rules. </p>
        pub fn rules(mut self, input: crate::model::ReplicationRule) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input);
            self.rules = Some(v);
            self
        }
        /// <p>A container for one or more replication rules. A replication configuration must have at least one rule and can contain a maximum of 1,000 rules. </p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplicationRule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationConfiguration`](crate::model::ReplicationConfiguration)
        pub fn build(self) -> crate::model::ReplicationConfiguration {
            crate::model::ReplicationConfiguration {
                role: self.role,
                rules: self.rules,
            }
        }
    }
}
impl ReplicationConfiguration {
    /// Creates a new builder-style object to manufacture [`ReplicationConfiguration`](crate::model::ReplicationConfiguration)
    pub fn builder() -> crate::model::replication_configuration::Builder {
        crate::model::replication_configuration::Builder::default()
    }
}

/// <p>Specifies which Amazon S3 objects to replicate and where to store the replicas.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationRule {
    /// <p>A unique identifier for the rule. The maximum value is 255 characters.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The priority indicates which rule has precedence whenever two or more replication rules conflict. Amazon S3 will attempt to replicate objects according to all replication rules. However, if there are two or more rules with the same destination bucket, then objects will be replicated according to the rule with the highest priority. The higher the number, the higher the priority. </p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html">Replication</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub priority: i32,
    /// <p>An object key name prefix that identifies the object or objects to which the rule applies. The maximum prefix length is 1,024 characters. To include all objects in a bucket, specify an empty string. </p> <important>
    /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
    /// </important>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>A filter that identifies the subset of objects to which the replication rule applies. A <code>Filter</code> must specify exactly one <code>Prefix</code>, <code>Tag</code>, or an <code>And</code> child element.</p>
    pub filter: std::option::Option<crate::model::ReplicationRuleFilter>,
    /// <p>Specifies whether the rule is enabled.</p>
    pub status: std::option::Option<crate::model::ReplicationRuleStatus>,
    /// <p>A container that describes additional filters for identifying the source objects that you want to replicate. You can choose to enable or disable the replication of these objects. Currently, Amazon S3 supports only the filter that you can specify for objects created with server-side encryption using a customer managed key stored in Amazon Web Services Key Management Service (SSE-KMS).</p>
    pub source_selection_criteria: std::option::Option<crate::model::SourceSelectionCriteria>,
    /// <p></p>
    pub existing_object_replication: std::option::Option<crate::model::ExistingObjectReplication>,
    /// <p>A container for information about the replication destination and its configurations including enabling the S3 Replication Time Control (S3 RTC).</p>
    pub destination: std::option::Option<crate::model::Destination>,
    /// <p>Specifies whether Amazon S3 replicates delete markers. If you specify a <code>Filter</code> in your replication configuration, you must also include a <code>DeleteMarkerReplication</code> element. If your <code>Filter</code> includes a <code>Tag</code> element, the <code>DeleteMarkerReplication</code> <code>Status</code> must be set to Disabled, because Amazon S3 does not support replicating delete markers for tag-based rules. For an example configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-config-min-rule-config">Basic Rule Configuration</a>. </p>
    /// <p>For more information about delete marker replication, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/delete-marker-replication.html">Basic Rule Configuration</a>. </p> <note>
    /// <p>If you are using an earlier version of the replication configuration, Amazon S3 handles replication of delete markers differently. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-backward-compat-considerations">Backward Compatibility</a>.</p>
    /// </note>
    pub delete_marker_replication: std::option::Option<crate::model::DeleteMarkerReplication>,
}
impl ReplicationRule {
    /// <p>A unique identifier for the rule. The maximum value is 255 characters.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The priority indicates which rule has precedence whenever two or more replication rules conflict. Amazon S3 will attempt to replicate objects according to all replication rules. However, if there are two or more rules with the same destination bucket, then objects will be replicated according to the rule with the highest priority. The higher the number, the higher the priority. </p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html">Replication</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn priority(&self) -> i32 {
        self.priority
    }
    /// <p>An object key name prefix that identifies the object or objects to which the rule applies. The maximum prefix length is 1,024 characters. To include all objects in a bucket, specify an empty string. </p> <important>
    /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
    /// </important>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>A filter that identifies the subset of objects to which the replication rule applies. A <code>Filter</code> must specify exactly one <code>Prefix</code>, <code>Tag</code>, or an <code>And</code> child element.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::ReplicationRuleFilter> {
        self.filter.as_ref()
    }
    /// <p>Specifies whether the rule is enabled.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ReplicationRuleStatus> {
        self.status.as_ref()
    }
    /// <p>A container that describes additional filters for identifying the source objects that you want to replicate. You can choose to enable or disable the replication of these objects. Currently, Amazon S3 supports only the filter that you can specify for objects created with server-side encryption using a customer managed key stored in Amazon Web Services Key Management Service (SSE-KMS).</p>
    pub fn source_selection_criteria(
        &self,
    ) -> std::option::Option<&crate::model::SourceSelectionCriteria> {
        self.source_selection_criteria.as_ref()
    }
    /// <p></p>
    pub fn existing_object_replication(
        &self,
    ) -> std::option::Option<&crate::model::ExistingObjectReplication> {
        self.existing_object_replication.as_ref()
    }
    /// <p>A container for information about the replication destination and its configurations including enabling the S3 Replication Time Control (S3 RTC).</p>
    pub fn destination(&self) -> std::option::Option<&crate::model::Destination> {
        self.destination.as_ref()
    }
    /// <p>Specifies whether Amazon S3 replicates delete markers. If you specify a <code>Filter</code> in your replication configuration, you must also include a <code>DeleteMarkerReplication</code> element. If your <code>Filter</code> includes a <code>Tag</code> element, the <code>DeleteMarkerReplication</code> <code>Status</code> must be set to Disabled, because Amazon S3 does not support replicating delete markers for tag-based rules. For an example configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-config-min-rule-config">Basic Rule Configuration</a>. </p>
    /// <p>For more information about delete marker replication, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/delete-marker-replication.html">Basic Rule Configuration</a>. </p> <note>
    /// <p>If you are using an earlier version of the replication configuration, Amazon S3 handles replication of delete markers differently. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-backward-compat-considerations">Backward Compatibility</a>.</p>
    /// </note>
    pub fn delete_marker_replication(
        &self,
    ) -> std::option::Option<&crate::model::DeleteMarkerReplication> {
        self.delete_marker_replication.as_ref()
    }
}
impl std::fmt::Debug for ReplicationRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationRule");
        formatter.field("id", &self.id);
        formatter.field("priority", &self.priority);
        formatter.field("prefix", &self.prefix);
        formatter.field("filter", &self.filter);
        formatter.field("status", &self.status);
        formatter.field("source_selection_criteria", &self.source_selection_criteria);
        formatter.field(
            "existing_object_replication",
            &self.existing_object_replication,
        );
        formatter.field("destination", &self.destination);
        formatter.field("delete_marker_replication", &self.delete_marker_replication);
        formatter.finish()
    }
}
/// See [`ReplicationRule`](crate::model::ReplicationRule)
pub mod replication_rule {
    /// A builder for [`ReplicationRule`](crate::model::ReplicationRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) filter: std::option::Option<crate::model::ReplicationRuleFilter>,
        pub(crate) status: std::option::Option<crate::model::ReplicationRuleStatus>,
        pub(crate) source_selection_criteria:
            std::option::Option<crate::model::SourceSelectionCriteria>,
        pub(crate) existing_object_replication:
            std::option::Option<crate::model::ExistingObjectReplication>,
        pub(crate) destination: std::option::Option<crate::model::Destination>,
        pub(crate) delete_marker_replication:
            std::option::Option<crate::model::DeleteMarkerReplication>,
    }
    impl Builder {
        /// <p>A unique identifier for the rule. The maximum value is 255 characters.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the rule. The maximum value is 255 characters.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The priority indicates which rule has precedence whenever two or more replication rules conflict. Amazon S3 will attempt to replicate objects according to all replication rules. However, if there are two or more rules with the same destination bucket, then objects will be replicated according to the rule with the highest priority. The higher the number, the higher the priority. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html">Replication</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The priority indicates which rule has precedence whenever two or more replication rules conflict. Amazon S3 will attempt to replicate objects according to all replication rules. However, if there are two or more rules with the same destination bucket, then objects will be replicated according to the rule with the highest priority. The higher the number, the higher the priority. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html">Replication</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// <p>An object key name prefix that identifies the object or objects to which the rule applies. The maximum prefix length is 1,024 characters. To include all objects in a bucket, specify an empty string. </p> <important>
        /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
        /// </important>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>An object key name prefix that identifies the object or objects to which the rule applies. The maximum prefix length is 1,024 characters. To include all objects in a bucket, specify an empty string. </p> <important>
        /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
        /// </important>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>A filter that identifies the subset of objects to which the replication rule applies. A <code>Filter</code> must specify exactly one <code>Prefix</code>, <code>Tag</code>, or an <code>And</code> child element.</p>
        pub fn filter(mut self, input: crate::model::ReplicationRuleFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>A filter that identifies the subset of objects to which the replication rule applies. A <code>Filter</code> must specify exactly one <code>Prefix</code>, <code>Tag</code>, or an <code>And</code> child element.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::ReplicationRuleFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>Specifies whether the rule is enabled.</p>
        pub fn status(mut self, input: crate::model::ReplicationRuleStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Specifies whether the rule is enabled.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ReplicationRuleStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A container that describes additional filters for identifying the source objects that you want to replicate. You can choose to enable or disable the replication of these objects. Currently, Amazon S3 supports only the filter that you can specify for objects created with server-side encryption using a customer managed key stored in Amazon Web Services Key Management Service (SSE-KMS).</p>
        pub fn source_selection_criteria(
            mut self,
            input: crate::model::SourceSelectionCriteria,
        ) -> Self {
            self.source_selection_criteria = Some(input);
            self
        }
        /// <p>A container that describes additional filters for identifying the source objects that you want to replicate. You can choose to enable or disable the replication of these objects. Currently, Amazon S3 supports only the filter that you can specify for objects created with server-side encryption using a customer managed key stored in Amazon Web Services Key Management Service (SSE-KMS).</p>
        pub fn set_source_selection_criteria(
            mut self,
            input: std::option::Option<crate::model::SourceSelectionCriteria>,
        ) -> Self {
            self.source_selection_criteria = input;
            self
        }
        /// <p></p>
        pub fn existing_object_replication(
            mut self,
            input: crate::model::ExistingObjectReplication,
        ) -> Self {
            self.existing_object_replication = Some(input);
            self
        }
        /// <p></p>
        pub fn set_existing_object_replication(
            mut self,
            input: std::option::Option<crate::model::ExistingObjectReplication>,
        ) -> Self {
            self.existing_object_replication = input;
            self
        }
        /// <p>A container for information about the replication destination and its configurations including enabling the S3 Replication Time Control (S3 RTC).</p>
        pub fn destination(mut self, input: crate::model::Destination) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>A container for information about the replication destination and its configurations including enabling the S3 Replication Time Control (S3 RTC).</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::Destination>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// <p>Specifies whether Amazon S3 replicates delete markers. If you specify a <code>Filter</code> in your replication configuration, you must also include a <code>DeleteMarkerReplication</code> element. If your <code>Filter</code> includes a <code>Tag</code> element, the <code>DeleteMarkerReplication</code> <code>Status</code> must be set to Disabled, because Amazon S3 does not support replicating delete markers for tag-based rules. For an example configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-config-min-rule-config">Basic Rule Configuration</a>. </p>
        /// <p>For more information about delete marker replication, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/delete-marker-replication.html">Basic Rule Configuration</a>. </p> <note>
        /// <p>If you are using an earlier version of the replication configuration, Amazon S3 handles replication of delete markers differently. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-backward-compat-considerations">Backward Compatibility</a>.</p>
        /// </note>
        pub fn delete_marker_replication(
            mut self,
            input: crate::model::DeleteMarkerReplication,
        ) -> Self {
            self.delete_marker_replication = Some(input);
            self
        }
        /// <p>Specifies whether Amazon S3 replicates delete markers. If you specify a <code>Filter</code> in your replication configuration, you must also include a <code>DeleteMarkerReplication</code> element. If your <code>Filter</code> includes a <code>Tag</code> element, the <code>DeleteMarkerReplication</code> <code>Status</code> must be set to Disabled, because Amazon S3 does not support replicating delete markers for tag-based rules. For an example configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-config-min-rule-config">Basic Rule Configuration</a>. </p>
        /// <p>For more information about delete marker replication, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/delete-marker-replication.html">Basic Rule Configuration</a>. </p> <note>
        /// <p>If you are using an earlier version of the replication configuration, Amazon S3 handles replication of delete markers differently. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-backward-compat-considerations">Backward Compatibility</a>.</p>
        /// </note>
        pub fn set_delete_marker_replication(
            mut self,
            input: std::option::Option<crate::model::DeleteMarkerReplication>,
        ) -> Self {
            self.delete_marker_replication = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationRule`](crate::model::ReplicationRule)
        pub fn build(self) -> crate::model::ReplicationRule {
            crate::model::ReplicationRule {
                id: self.id,
                priority: self.priority.unwrap_or_default(),
                prefix: self.prefix,
                filter: self.filter,
                status: self.status,
                source_selection_criteria: self.source_selection_criteria,
                existing_object_replication: self.existing_object_replication,
                destination: self.destination,
                delete_marker_replication: self.delete_marker_replication,
            }
        }
    }
}
impl ReplicationRule {
    /// Creates a new builder-style object to manufacture [`ReplicationRule`](crate::model::ReplicationRule)
    pub fn builder() -> crate::model::replication_rule::Builder {
        crate::model::replication_rule::Builder::default()
    }
}

/// <p>Specifies whether Amazon S3 replicates delete markers. If you specify a <code>Filter</code> in your replication configuration, you must also include a <code>DeleteMarkerReplication</code> element. If your <code>Filter</code> includes a <code>Tag</code> element, the <code>DeleteMarkerReplication</code> <code>Status</code> must be set to Disabled, because Amazon S3 does not support replicating delete markers for tag-based rules. For an example configuration, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-config-min-rule-config">Basic Rule Configuration</a>. </p>
/// <p>For more information about delete marker replication, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/delete-marker-replication.html">Basic Rule Configuration</a>. </p> <note>
/// <p>If you are using an earlier version of the replication configuration, Amazon S3 handles replication of delete markers differently. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-backward-compat-considerations">Backward Compatibility</a>.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMarkerReplication {
    /// <p>Indicates whether to replicate delete markers.</p> <note>
    /// <p>Indicates whether to replicate delete markers.</p>
    /// </note>
    pub status: std::option::Option<crate::model::DeleteMarkerReplicationStatus>,
}
impl DeleteMarkerReplication {
    /// <p>Indicates whether to replicate delete markers.</p> <note>
    /// <p>Indicates whether to replicate delete markers.</p>
    /// </note>
    pub fn status(&self) -> std::option::Option<&crate::model::DeleteMarkerReplicationStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for DeleteMarkerReplication {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMarkerReplication");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DeleteMarkerReplication`](crate::model::DeleteMarkerReplication)
pub mod delete_marker_replication {
    /// A builder for [`DeleteMarkerReplication`](crate::model::DeleteMarkerReplication)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::DeleteMarkerReplicationStatus>,
    }
    impl Builder {
        /// <p>Indicates whether to replicate delete markers.</p> <note>
        /// <p>Indicates whether to replicate delete markers.</p>
        /// </note>
        pub fn status(mut self, input: crate::model::DeleteMarkerReplicationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Indicates whether to replicate delete markers.</p> <note>
        /// <p>Indicates whether to replicate delete markers.</p>
        /// </note>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DeleteMarkerReplicationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMarkerReplication`](crate::model::DeleteMarkerReplication)
        pub fn build(self) -> crate::model::DeleteMarkerReplication {
            crate::model::DeleteMarkerReplication {
                status: self.status,
            }
        }
    }
}
impl DeleteMarkerReplication {
    /// Creates a new builder-style object to manufacture [`DeleteMarkerReplication`](crate::model::DeleteMarkerReplication)
    pub fn builder() -> crate::model::delete_marker_replication::Builder {
        crate::model::delete_marker_replication::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeleteMarkerReplicationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeleteMarkerReplicationStatus {
    fn from(s: &str) -> Self {
        match s {
            "Disabled" => DeleteMarkerReplicationStatus::Disabled,
            "Enabled" => DeleteMarkerReplicationStatus::Enabled,
            other => DeleteMarkerReplicationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeleteMarkerReplicationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeleteMarkerReplicationStatus::from(s))
    }
}
impl DeleteMarkerReplicationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeleteMarkerReplicationStatus::Disabled => "Disabled",
            DeleteMarkerReplicationStatus::Enabled => "Enabled",
            DeleteMarkerReplicationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Disabled", "Enabled"]
    }
}
impl AsRef<str> for DeleteMarkerReplicationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies information about where to publish analysis or configuration results for an Amazon S3 bucket and S3 Replication Time Control (S3 RTC).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Destination {
    /// <p> The Amazon Resource Name (ARN) of the bucket where you want Amazon S3 to store the results.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>Destination bucket owner account ID. In a cross-account scenario, if you direct Amazon S3 to change replica ownership to the Amazon Web Services account that owns the destination bucket by specifying the <code>AccessControlTranslation</code> property, this is the account ID of the destination bucket owner. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-change-owner.html">Replication Additional Configuration: Changing the Replica Owner</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub account: std::option::Option<std::string::String>,
    /// <p> The storage class to use when replicating objects, such as S3 Standard or reduced redundancy. By default, Amazon S3 uses the storage class of the source object to create the object replica. </p>
    /// <p>For valid values, see the <code>StorageClass</code> element of the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTreplication.html">PUT Bucket replication</a> action in the <i>Amazon S3 API Reference</i>.</p>
    pub storage_class: std::option::Option<crate::model::StorageClass>,
    /// <p>Specify this only in a cross-account scenario (where source and destination bucket owners are not the same), and you want to change replica ownership to the Amazon Web Services account that owns the destination bucket. If this is not specified in the replication configuration, the replicas are owned by same Amazon Web Services account that owns the source object.</p>
    pub access_control_translation: std::option::Option<crate::model::AccessControlTranslation>,
    /// <p>A container that provides information about encryption. If <code>SourceSelectionCriteria</code> is specified, you must specify this element.</p>
    pub encryption_configuration: std::option::Option<crate::model::EncryptionConfiguration>,
    /// <p> A container specifying S3 Replication Time Control (S3 RTC), including whether S3 RTC is enabled and the time when all objects and operations on objects must be replicated. Must be specified together with a <code>Metrics</code> block. </p>
    pub replication_time: std::option::Option<crate::model::ReplicationTime>,
    /// <p> A container specifying replication metrics-related settings enabling replication metrics and events. </p>
    pub metrics: std::option::Option<crate::model::Metrics>,
}
impl Destination {
    /// <p> The Amazon Resource Name (ARN) of the bucket where you want Amazon S3 to store the results.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>Destination bucket owner account ID. In a cross-account scenario, if you direct Amazon S3 to change replica ownership to the Amazon Web Services account that owns the destination bucket by specifying the <code>AccessControlTranslation</code> property, this is the account ID of the destination bucket owner. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-change-owner.html">Replication Additional Configuration: Changing the Replica Owner</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn account(&self) -> std::option::Option<&str> {
        self.account.as_deref()
    }
    /// <p> The storage class to use when replicating objects, such as S3 Standard or reduced redundancy. By default, Amazon S3 uses the storage class of the source object to create the object replica. </p>
    /// <p>For valid values, see the <code>StorageClass</code> element of the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTreplication.html">PUT Bucket replication</a> action in the <i>Amazon S3 API Reference</i>.</p>
    pub fn storage_class(&self) -> std::option::Option<&crate::model::StorageClass> {
        self.storage_class.as_ref()
    }
    /// <p>Specify this only in a cross-account scenario (where source and destination bucket owners are not the same), and you want to change replica ownership to the Amazon Web Services account that owns the destination bucket. If this is not specified in the replication configuration, the replicas are owned by same Amazon Web Services account that owns the source object.</p>
    pub fn access_control_translation(
        &self,
    ) -> std::option::Option<&crate::model::AccessControlTranslation> {
        self.access_control_translation.as_ref()
    }
    /// <p>A container that provides information about encryption. If <code>SourceSelectionCriteria</code> is specified, you must specify this element.</p>
    pub fn encryption_configuration(
        &self,
    ) -> std::option::Option<&crate::model::EncryptionConfiguration> {
        self.encryption_configuration.as_ref()
    }
    /// <p> A container specifying S3 Replication Time Control (S3 RTC), including whether S3 RTC is enabled and the time when all objects and operations on objects must be replicated. Must be specified together with a <code>Metrics</code> block. </p>
    pub fn replication_time(&self) -> std::option::Option<&crate::model::ReplicationTime> {
        self.replication_time.as_ref()
    }
    /// <p> A container specifying replication metrics-related settings enabling replication metrics and events. </p>
    pub fn metrics(&self) -> std::option::Option<&crate::model::Metrics> {
        self.metrics.as_ref()
    }
}
impl std::fmt::Debug for Destination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Destination");
        formatter.field("bucket", &self.bucket);
        formatter.field("account", &self.account);
        formatter.field("storage_class", &self.storage_class);
        formatter.field(
            "access_control_translation",
            &self.access_control_translation,
        );
        formatter.field("encryption_configuration", &self.encryption_configuration);
        formatter.field("replication_time", &self.replication_time);
        formatter.field("metrics", &self.metrics);
        formatter.finish()
    }
}
/// See [`Destination`](crate::model::Destination)
pub mod destination {
    /// A builder for [`Destination`](crate::model::Destination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) account: std::option::Option<std::string::String>,
        pub(crate) storage_class: std::option::Option<crate::model::StorageClass>,
        pub(crate) access_control_translation:
            std::option::Option<crate::model::AccessControlTranslation>,
        pub(crate) encryption_configuration:
            std::option::Option<crate::model::EncryptionConfiguration>,
        pub(crate) replication_time: std::option::Option<crate::model::ReplicationTime>,
        pub(crate) metrics: std::option::Option<crate::model::Metrics>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the bucket where you want Amazon S3 to store the results.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the bucket where you want Amazon S3 to store the results.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Destination bucket owner account ID. In a cross-account scenario, if you direct Amazon S3 to change replica ownership to the Amazon Web Services account that owns the destination bucket by specifying the <code>AccessControlTranslation</code> property, this is the account ID of the destination bucket owner. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-change-owner.html">Replication Additional Configuration: Changing the Replica Owner</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn account(mut self, input: impl Into<std::string::String>) -> Self {
            self.account = Some(input.into());
            self
        }
        /// <p>Destination bucket owner account ID. In a cross-account scenario, if you direct Amazon S3 to change replica ownership to the Amazon Web Services account that owns the destination bucket by specifying the <code>AccessControlTranslation</code> property, this is the account ID of the destination bucket owner. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-change-owner.html">Replication Additional Configuration: Changing the Replica Owner</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_account(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account = input;
            self
        }
        /// <p> The storage class to use when replicating objects, such as S3 Standard or reduced redundancy. By default, Amazon S3 uses the storage class of the source object to create the object replica. </p>
        /// <p>For valid values, see the <code>StorageClass</code> element of the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTreplication.html">PUT Bucket replication</a> action in the <i>Amazon S3 API Reference</i>.</p>
        pub fn storage_class(mut self, input: crate::model::StorageClass) -> Self {
            self.storage_class = Some(input);
            self
        }
        /// <p> The storage class to use when replicating objects, such as S3 Standard or reduced redundancy. By default, Amazon S3 uses the storage class of the source object to create the object replica. </p>
        /// <p>For valid values, see the <code>StorageClass</code> element of the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTreplication.html">PUT Bucket replication</a> action in the <i>Amazon S3 API Reference</i>.</p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<crate::model::StorageClass>,
        ) -> Self {
            self.storage_class = input;
            self
        }
        /// <p>Specify this only in a cross-account scenario (where source and destination bucket owners are not the same), and you want to change replica ownership to the Amazon Web Services account that owns the destination bucket. If this is not specified in the replication configuration, the replicas are owned by same Amazon Web Services account that owns the source object.</p>
        pub fn access_control_translation(
            mut self,
            input: crate::model::AccessControlTranslation,
        ) -> Self {
            self.access_control_translation = Some(input);
            self
        }
        /// <p>Specify this only in a cross-account scenario (where source and destination bucket owners are not the same), and you want to change replica ownership to the Amazon Web Services account that owns the destination bucket. If this is not specified in the replication configuration, the replicas are owned by same Amazon Web Services account that owns the source object.</p>
        pub fn set_access_control_translation(
            mut self,
            input: std::option::Option<crate::model::AccessControlTranslation>,
        ) -> Self {
            self.access_control_translation = input;
            self
        }
        /// <p>A container that provides information about encryption. If <code>SourceSelectionCriteria</code> is specified, you must specify this element.</p>
        pub fn encryption_configuration(
            mut self,
            input: crate::model::EncryptionConfiguration,
        ) -> Self {
            self.encryption_configuration = Some(input);
            self
        }
        /// <p>A container that provides information about encryption. If <code>SourceSelectionCriteria</code> is specified, you must specify this element.</p>
        pub fn set_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::EncryptionConfiguration>,
        ) -> Self {
            self.encryption_configuration = input;
            self
        }
        /// <p> A container specifying S3 Replication Time Control (S3 RTC), including whether S3 RTC is enabled and the time when all objects and operations on objects must be replicated. Must be specified together with a <code>Metrics</code> block. </p>
        pub fn replication_time(mut self, input: crate::model::ReplicationTime) -> Self {
            self.replication_time = Some(input);
            self
        }
        /// <p> A container specifying S3 Replication Time Control (S3 RTC), including whether S3 RTC is enabled and the time when all objects and operations on objects must be replicated. Must be specified together with a <code>Metrics</code> block. </p>
        pub fn set_replication_time(
            mut self,
            input: std::option::Option<crate::model::ReplicationTime>,
        ) -> Self {
            self.replication_time = input;
            self
        }
        /// <p> A container specifying replication metrics-related settings enabling replication metrics and events. </p>
        pub fn metrics(mut self, input: crate::model::Metrics) -> Self {
            self.metrics = Some(input);
            self
        }
        /// <p> A container specifying replication metrics-related settings enabling replication metrics and events. </p>
        pub fn set_metrics(mut self, input: std::option::Option<crate::model::Metrics>) -> Self {
            self.metrics = input;
            self
        }
        /// Consumes the builder and constructs a [`Destination`](crate::model::Destination)
        pub fn build(self) -> crate::model::Destination {
            crate::model::Destination {
                bucket: self.bucket,
                account: self.account,
                storage_class: self.storage_class,
                access_control_translation: self.access_control_translation,
                encryption_configuration: self.encryption_configuration,
                replication_time: self.replication_time,
                metrics: self.metrics,
            }
        }
    }
}
impl Destination {
    /// Creates a new builder-style object to manufacture [`Destination`](crate::model::Destination)
    pub fn builder() -> crate::model::destination::Builder {
        crate::model::destination::Builder::default()
    }
}

/// <p> A container specifying replication metrics-related settings enabling replication metrics and events.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Metrics {
    /// <p> Specifies whether the replication metrics are enabled. </p>
    pub status: std::option::Option<crate::model::MetricsStatus>,
    /// <p> A container specifying the time threshold for emitting the <code>s3:Replication:OperationMissedThreshold</code> event. </p>
    pub event_threshold: std::option::Option<crate::model::ReplicationTimeValue>,
}
impl Metrics {
    /// <p> Specifies whether the replication metrics are enabled. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::MetricsStatus> {
        self.status.as_ref()
    }
    /// <p> A container specifying the time threshold for emitting the <code>s3:Replication:OperationMissedThreshold</code> event. </p>
    pub fn event_threshold(&self) -> std::option::Option<&crate::model::ReplicationTimeValue> {
        self.event_threshold.as_ref()
    }
}
impl std::fmt::Debug for Metrics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Metrics");
        formatter.field("status", &self.status);
        formatter.field("event_threshold", &self.event_threshold);
        formatter.finish()
    }
}
/// See [`Metrics`](crate::model::Metrics)
pub mod metrics {
    /// A builder for [`Metrics`](crate::model::Metrics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::MetricsStatus>,
        pub(crate) event_threshold: std::option::Option<crate::model::ReplicationTimeValue>,
    }
    impl Builder {
        /// <p> Specifies whether the replication metrics are enabled. </p>
        pub fn status(mut self, input: crate::model::MetricsStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> Specifies whether the replication metrics are enabled. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::MetricsStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> A container specifying the time threshold for emitting the <code>s3:Replication:OperationMissedThreshold</code> event. </p>
        pub fn event_threshold(mut self, input: crate::model::ReplicationTimeValue) -> Self {
            self.event_threshold = Some(input);
            self
        }
        /// <p> A container specifying the time threshold for emitting the <code>s3:Replication:OperationMissedThreshold</code> event. </p>
        pub fn set_event_threshold(
            mut self,
            input: std::option::Option<crate::model::ReplicationTimeValue>,
        ) -> Self {
            self.event_threshold = input;
            self
        }
        /// Consumes the builder and constructs a [`Metrics`](crate::model::Metrics)
        pub fn build(self) -> crate::model::Metrics {
            crate::model::Metrics {
                status: self.status,
                event_threshold: self.event_threshold,
            }
        }
    }
}
impl Metrics {
    /// Creates a new builder-style object to manufacture [`Metrics`](crate::model::Metrics)
    pub fn builder() -> crate::model::metrics::Builder {
        crate::model::metrics::Builder::default()
    }
}

/// <p> A container specifying the time value for S3 Replication Time Control (S3 RTC) and replication metrics <code>EventThreshold</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationTimeValue {
    /// <p> Contains an integer specifying time in minutes. </p>
    /// <p> Valid value: 15</p>
    pub minutes: i32,
}
impl ReplicationTimeValue {
    /// <p> Contains an integer specifying time in minutes. </p>
    /// <p> Valid value: 15</p>
    pub fn minutes(&self) -> i32 {
        self.minutes
    }
}
impl std::fmt::Debug for ReplicationTimeValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationTimeValue");
        formatter.field("minutes", &self.minutes);
        formatter.finish()
    }
}
/// See [`ReplicationTimeValue`](crate::model::ReplicationTimeValue)
pub mod replication_time_value {
    /// A builder for [`ReplicationTimeValue`](crate::model::ReplicationTimeValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) minutes: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> Contains an integer specifying time in minutes. </p>
        /// <p> Valid value: 15</p>
        pub fn minutes(mut self, input: i32) -> Self {
            self.minutes = Some(input);
            self
        }
        /// <p> Contains an integer specifying time in minutes. </p>
        /// <p> Valid value: 15</p>
        pub fn set_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.minutes = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationTimeValue`](crate::model::ReplicationTimeValue)
        pub fn build(self) -> crate::model::ReplicationTimeValue {
            crate::model::ReplicationTimeValue {
                minutes: self.minutes.unwrap_or_default(),
            }
        }
    }
}
impl ReplicationTimeValue {
    /// Creates a new builder-style object to manufacture [`ReplicationTimeValue`](crate::model::ReplicationTimeValue)
    pub fn builder() -> crate::model::replication_time_value::Builder {
        crate::model::replication_time_value::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MetricsStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MetricsStatus {
    fn from(s: &str) -> Self {
        match s {
            "Disabled" => MetricsStatus::Disabled,
            "Enabled" => MetricsStatus::Enabled,
            other => MetricsStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MetricsStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MetricsStatus::from(s))
    }
}
impl MetricsStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MetricsStatus::Disabled => "Disabled",
            MetricsStatus::Enabled => "Enabled",
            MetricsStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Disabled", "Enabled"]
    }
}
impl AsRef<str> for MetricsStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> A container specifying S3 Replication Time Control (S3 RTC) related information, including whether S3 RTC is enabled and the time when all objects and operations on objects must be replicated. Must be specified together with a <code>Metrics</code> block. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationTime {
    /// <p> Specifies whether the replication time is enabled. </p>
    pub status: std::option::Option<crate::model::ReplicationTimeStatus>,
    /// <p> A container specifying the time by which replication should be complete for all objects and operations on objects. </p>
    pub time: std::option::Option<crate::model::ReplicationTimeValue>,
}
impl ReplicationTime {
    /// <p> Specifies whether the replication time is enabled. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::ReplicationTimeStatus> {
        self.status.as_ref()
    }
    /// <p> A container specifying the time by which replication should be complete for all objects and operations on objects. </p>
    pub fn time(&self) -> std::option::Option<&crate::model::ReplicationTimeValue> {
        self.time.as_ref()
    }
}
impl std::fmt::Debug for ReplicationTime {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationTime");
        formatter.field("status", &self.status);
        formatter.field("time", &self.time);
        formatter.finish()
    }
}
/// See [`ReplicationTime`](crate::model::ReplicationTime)
pub mod replication_time {
    /// A builder for [`ReplicationTime`](crate::model::ReplicationTime)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::ReplicationTimeStatus>,
        pub(crate) time: std::option::Option<crate::model::ReplicationTimeValue>,
    }
    impl Builder {
        /// <p> Specifies whether the replication time is enabled. </p>
        pub fn status(mut self, input: crate::model::ReplicationTimeStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> Specifies whether the replication time is enabled. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ReplicationTimeStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> A container specifying the time by which replication should be complete for all objects and operations on objects. </p>
        pub fn time(mut self, input: crate::model::ReplicationTimeValue) -> Self {
            self.time = Some(input);
            self
        }
        /// <p> A container specifying the time by which replication should be complete for all objects and operations on objects. </p>
        pub fn set_time(
            mut self,
            input: std::option::Option<crate::model::ReplicationTimeValue>,
        ) -> Self {
            self.time = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationTime`](crate::model::ReplicationTime)
        pub fn build(self) -> crate::model::ReplicationTime {
            crate::model::ReplicationTime {
                status: self.status,
                time: self.time,
            }
        }
    }
}
impl ReplicationTime {
    /// Creates a new builder-style object to manufacture [`ReplicationTime`](crate::model::ReplicationTime)
    pub fn builder() -> crate::model::replication_time::Builder {
        crate::model::replication_time::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReplicationTimeStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReplicationTimeStatus {
    fn from(s: &str) -> Self {
        match s {
            "Disabled" => ReplicationTimeStatus::Disabled,
            "Enabled" => ReplicationTimeStatus::Enabled,
            other => ReplicationTimeStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReplicationTimeStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReplicationTimeStatus::from(s))
    }
}
impl ReplicationTimeStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReplicationTimeStatus::Disabled => "Disabled",
            ReplicationTimeStatus::Enabled => "Enabled",
            ReplicationTimeStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Disabled", "Enabled"]
    }
}
impl AsRef<str> for ReplicationTimeStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies encryption-related information for an Amazon S3 bucket that is a destination for replicated objects.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EncryptionConfiguration {
    /// <p>Specifies the ID (Key ARN or Alias ARN) of the customer managed Amazon Web Services KMS key stored in Amazon Web Services Key Management Service (KMS) for the destination bucket. Amazon S3 uses this key to encrypt replica objects. Amazon S3 only supports symmetric, customer managed KMS keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>
    pub replica_kms_key_id: std::option::Option<std::string::String>,
}
impl EncryptionConfiguration {
    /// <p>Specifies the ID (Key ARN or Alias ARN) of the customer managed Amazon Web Services KMS key stored in Amazon Web Services Key Management Service (KMS) for the destination bucket. Amazon S3 uses this key to encrypt replica objects. Amazon S3 only supports symmetric, customer managed KMS keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>
    pub fn replica_kms_key_id(&self) -> std::option::Option<&str> {
        self.replica_kms_key_id.as_deref()
    }
}
impl std::fmt::Debug for EncryptionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EncryptionConfiguration");
        formatter.field("replica_kms_key_id", &self.replica_kms_key_id);
        formatter.finish()
    }
}
/// See [`EncryptionConfiguration`](crate::model::EncryptionConfiguration)
pub mod encryption_configuration {
    /// A builder for [`EncryptionConfiguration`](crate::model::EncryptionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replica_kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the ID (Key ARN or Alias ARN) of the customer managed Amazon Web Services KMS key stored in Amazon Web Services Key Management Service (KMS) for the destination bucket. Amazon S3 uses this key to encrypt replica objects. Amazon S3 only supports symmetric, customer managed KMS keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>
        pub fn replica_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.replica_kms_key_id = Some(input.into());
            self
        }
        /// <p>Specifies the ID (Key ARN or Alias ARN) of the customer managed Amazon Web Services KMS key stored in Amazon Web Services Key Management Service (KMS) for the destination bucket. Amazon S3 uses this key to encrypt replica objects. Amazon S3 only supports symmetric, customer managed KMS keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>
        pub fn set_replica_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replica_kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`EncryptionConfiguration`](crate::model::EncryptionConfiguration)
        pub fn build(self) -> crate::model::EncryptionConfiguration {
            crate::model::EncryptionConfiguration {
                replica_kms_key_id: self.replica_kms_key_id,
            }
        }
    }
}
impl EncryptionConfiguration {
    /// Creates a new builder-style object to manufacture [`EncryptionConfiguration`](crate::model::EncryptionConfiguration)
    pub fn builder() -> crate::model::encryption_configuration::Builder {
        crate::model::encryption_configuration::Builder::default()
    }
}

/// <p>A container for information about access control for replicas.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessControlTranslation {
    /// <p>Specifies the replica ownership. For default and valid values, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTreplication.html">PUT bucket replication</a> in the <i>Amazon S3 API Reference</i>.</p>
    pub owner: std::option::Option<crate::model::OwnerOverride>,
}
impl AccessControlTranslation {
    /// <p>Specifies the replica ownership. For default and valid values, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTreplication.html">PUT bucket replication</a> in the <i>Amazon S3 API Reference</i>.</p>
    pub fn owner(&self) -> std::option::Option<&crate::model::OwnerOverride> {
        self.owner.as_ref()
    }
}
impl std::fmt::Debug for AccessControlTranslation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessControlTranslation");
        formatter.field("owner", &self.owner);
        formatter.finish()
    }
}
/// See [`AccessControlTranslation`](crate::model::AccessControlTranslation)
pub mod access_control_translation {
    /// A builder for [`AccessControlTranslation`](crate::model::AccessControlTranslation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner: std::option::Option<crate::model::OwnerOverride>,
    }
    impl Builder {
        /// <p>Specifies the replica ownership. For default and valid values, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTreplication.html">PUT bucket replication</a> in the <i>Amazon S3 API Reference</i>.</p>
        pub fn owner(mut self, input: crate::model::OwnerOverride) -> Self {
            self.owner = Some(input);
            self
        }
        /// <p>Specifies the replica ownership. For default and valid values, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTreplication.html">PUT bucket replication</a> in the <i>Amazon S3 API Reference</i>.</p>
        pub fn set_owner(
            mut self,
            input: std::option::Option<crate::model::OwnerOverride>,
        ) -> Self {
            self.owner = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessControlTranslation`](crate::model::AccessControlTranslation)
        pub fn build(self) -> crate::model::AccessControlTranslation {
            crate::model::AccessControlTranslation { owner: self.owner }
        }
    }
}
impl AccessControlTranslation {
    /// Creates a new builder-style object to manufacture [`AccessControlTranslation`](crate::model::AccessControlTranslation)
    pub fn builder() -> crate::model::access_control_translation::Builder {
        crate::model::access_control_translation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OwnerOverride {
    #[allow(missing_docs)] // documentation missing in model
    Destination,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OwnerOverride {
    fn from(s: &str) -> Self {
        match s {
            "Destination" => OwnerOverride::Destination,
            other => OwnerOverride::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OwnerOverride {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OwnerOverride::from(s))
    }
}
impl OwnerOverride {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OwnerOverride::Destination => "Destination",
            OwnerOverride::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Destination"]
    }
}
impl AsRef<str> for OwnerOverride {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Optional configuration to replicate existing source bucket objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-what-is-isnot-replicated.html#existing-object-replication">Replicating Existing Objects</a> in the <i>Amazon S3 User Guide</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExistingObjectReplication {
    /// <p></p>
    pub status: std::option::Option<crate::model::ExistingObjectReplicationStatus>,
}
impl ExistingObjectReplication {
    /// <p></p>
    pub fn status(&self) -> std::option::Option<&crate::model::ExistingObjectReplicationStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for ExistingObjectReplication {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExistingObjectReplication");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ExistingObjectReplication`](crate::model::ExistingObjectReplication)
pub mod existing_object_replication {
    /// A builder for [`ExistingObjectReplication`](crate::model::ExistingObjectReplication)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::ExistingObjectReplicationStatus>,
    }
    impl Builder {
        /// <p></p>
        pub fn status(mut self, input: crate::model::ExistingObjectReplicationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p></p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ExistingObjectReplicationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ExistingObjectReplication`](crate::model::ExistingObjectReplication)
        pub fn build(self) -> crate::model::ExistingObjectReplication {
            crate::model::ExistingObjectReplication {
                status: self.status,
            }
        }
    }
}
impl ExistingObjectReplication {
    /// Creates a new builder-style object to manufacture [`ExistingObjectReplication`](crate::model::ExistingObjectReplication)
    pub fn builder() -> crate::model::existing_object_replication::Builder {
        crate::model::existing_object_replication::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExistingObjectReplicationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExistingObjectReplicationStatus {
    fn from(s: &str) -> Self {
        match s {
            "Disabled" => ExistingObjectReplicationStatus::Disabled,
            "Enabled" => ExistingObjectReplicationStatus::Enabled,
            other => ExistingObjectReplicationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExistingObjectReplicationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExistingObjectReplicationStatus::from(s))
    }
}
impl ExistingObjectReplicationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExistingObjectReplicationStatus::Disabled => "Disabled",
            ExistingObjectReplicationStatus::Enabled => "Enabled",
            ExistingObjectReplicationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Disabled", "Enabled"]
    }
}
impl AsRef<str> for ExistingObjectReplicationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A container that describes additional filters for identifying the source objects that you want to replicate. You can choose to enable or disable the replication of these objects. Currently, Amazon S3 supports only the filter that you can specify for objects created with server-side encryption using a customer managed key stored in Amazon Web Services Key Management Service (SSE-KMS).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceSelectionCriteria {
    /// <p> A container for filter information for the selection of Amazon S3 objects encrypted with Amazon Web Services KMS. If you include <code>SourceSelectionCriteria</code> in the replication configuration, this element is required. </p>
    pub sse_kms_encrypted_objects: std::option::Option<crate::model::SseKmsEncryptedObjects>,
    /// <p>A filter that you can specify for selections for modifications on replicas. Amazon S3 doesn't replicate replica modifications by default. In the latest version of replication configuration (when <code>Filter</code> is specified), you can specify this element and set the status to <code>Enabled</code> to replicate modifications on replicas. </p> <note>
    /// <p> If you don't specify the <code>Filter</code> element, Amazon S3 assumes that the replication configuration is the earlier version, V1. In the earlier version, this element is not allowed</p>
    /// </note>
    pub replica_modifications: std::option::Option<crate::model::ReplicaModifications>,
}
impl SourceSelectionCriteria {
    /// <p> A container for filter information for the selection of Amazon S3 objects encrypted with Amazon Web Services KMS. If you include <code>SourceSelectionCriteria</code> in the replication configuration, this element is required. </p>
    pub fn sse_kms_encrypted_objects(
        &self,
    ) -> std::option::Option<&crate::model::SseKmsEncryptedObjects> {
        self.sse_kms_encrypted_objects.as_ref()
    }
    /// <p>A filter that you can specify for selections for modifications on replicas. Amazon S3 doesn't replicate replica modifications by default. In the latest version of replication configuration (when <code>Filter</code> is specified), you can specify this element and set the status to <code>Enabled</code> to replicate modifications on replicas. </p> <note>
    /// <p> If you don't specify the <code>Filter</code> element, Amazon S3 assumes that the replication configuration is the earlier version, V1. In the earlier version, this element is not allowed</p>
    /// </note>
    pub fn replica_modifications(
        &self,
    ) -> std::option::Option<&crate::model::ReplicaModifications> {
        self.replica_modifications.as_ref()
    }
}
impl std::fmt::Debug for SourceSelectionCriteria {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceSelectionCriteria");
        formatter.field("sse_kms_encrypted_objects", &self.sse_kms_encrypted_objects);
        formatter.field("replica_modifications", &self.replica_modifications);
        formatter.finish()
    }
}
/// See [`SourceSelectionCriteria`](crate::model::SourceSelectionCriteria)
pub mod source_selection_criteria {
    /// A builder for [`SourceSelectionCriteria`](crate::model::SourceSelectionCriteria)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sse_kms_encrypted_objects:
            std::option::Option<crate::model::SseKmsEncryptedObjects>,
        pub(crate) replica_modifications: std::option::Option<crate::model::ReplicaModifications>,
    }
    impl Builder {
        /// <p> A container for filter information for the selection of Amazon S3 objects encrypted with Amazon Web Services KMS. If you include <code>SourceSelectionCriteria</code> in the replication configuration, this element is required. </p>
        pub fn sse_kms_encrypted_objects(
            mut self,
            input: crate::model::SseKmsEncryptedObjects,
        ) -> Self {
            self.sse_kms_encrypted_objects = Some(input);
            self
        }
        /// <p> A container for filter information for the selection of Amazon S3 objects encrypted with Amazon Web Services KMS. If you include <code>SourceSelectionCriteria</code> in the replication configuration, this element is required. </p>
        pub fn set_sse_kms_encrypted_objects(
            mut self,
            input: std::option::Option<crate::model::SseKmsEncryptedObjects>,
        ) -> Self {
            self.sse_kms_encrypted_objects = input;
            self
        }
        /// <p>A filter that you can specify for selections for modifications on replicas. Amazon S3 doesn't replicate replica modifications by default. In the latest version of replication configuration (when <code>Filter</code> is specified), you can specify this element and set the status to <code>Enabled</code> to replicate modifications on replicas. </p> <note>
        /// <p> If you don't specify the <code>Filter</code> element, Amazon S3 assumes that the replication configuration is the earlier version, V1. In the earlier version, this element is not allowed</p>
        /// </note>
        pub fn replica_modifications(mut self, input: crate::model::ReplicaModifications) -> Self {
            self.replica_modifications = Some(input);
            self
        }
        /// <p>A filter that you can specify for selections for modifications on replicas. Amazon S3 doesn't replicate replica modifications by default. In the latest version of replication configuration (when <code>Filter</code> is specified), you can specify this element and set the status to <code>Enabled</code> to replicate modifications on replicas. </p> <note>
        /// <p> If you don't specify the <code>Filter</code> element, Amazon S3 assumes that the replication configuration is the earlier version, V1. In the earlier version, this element is not allowed</p>
        /// </note>
        pub fn set_replica_modifications(
            mut self,
            input: std::option::Option<crate::model::ReplicaModifications>,
        ) -> Self {
            self.replica_modifications = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceSelectionCriteria`](crate::model::SourceSelectionCriteria)
        pub fn build(self) -> crate::model::SourceSelectionCriteria {
            crate::model::SourceSelectionCriteria {
                sse_kms_encrypted_objects: self.sse_kms_encrypted_objects,
                replica_modifications: self.replica_modifications,
            }
        }
    }
}
impl SourceSelectionCriteria {
    /// Creates a new builder-style object to manufacture [`SourceSelectionCriteria`](crate::model::SourceSelectionCriteria)
    pub fn builder() -> crate::model::source_selection_criteria::Builder {
        crate::model::source_selection_criteria::Builder::default()
    }
}

/// <p>A filter that you can specify for selection for modifications on replicas. Amazon S3 doesn't replicate replica modifications by default. In the latest version of replication configuration (when <code>Filter</code> is specified), you can specify this element and set the status to <code>Enabled</code> to replicate modifications on replicas. </p> <note>
/// <p> If you don't specify the <code>Filter</code> element, Amazon S3 assumes that the replication configuration is the earlier version, V1. In the earlier version, this element is not allowed.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicaModifications {
    /// <p>Specifies whether Amazon S3 replicates modifications on replicas.</p>
    pub status: std::option::Option<crate::model::ReplicaModificationsStatus>,
}
impl ReplicaModifications {
    /// <p>Specifies whether Amazon S3 replicates modifications on replicas.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ReplicaModificationsStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for ReplicaModifications {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicaModifications");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ReplicaModifications`](crate::model::ReplicaModifications)
pub mod replica_modifications {
    /// A builder for [`ReplicaModifications`](crate::model::ReplicaModifications)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::ReplicaModificationsStatus>,
    }
    impl Builder {
        /// <p>Specifies whether Amazon S3 replicates modifications on replicas.</p>
        pub fn status(mut self, input: crate::model::ReplicaModificationsStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Specifies whether Amazon S3 replicates modifications on replicas.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ReplicaModificationsStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicaModifications`](crate::model::ReplicaModifications)
        pub fn build(self) -> crate::model::ReplicaModifications {
            crate::model::ReplicaModifications {
                status: self.status,
            }
        }
    }
}
impl ReplicaModifications {
    /// Creates a new builder-style object to manufacture [`ReplicaModifications`](crate::model::ReplicaModifications)
    pub fn builder() -> crate::model::replica_modifications::Builder {
        crate::model::replica_modifications::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReplicaModificationsStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReplicaModificationsStatus {
    fn from(s: &str) -> Self {
        match s {
            "Disabled" => ReplicaModificationsStatus::Disabled,
            "Enabled" => ReplicaModificationsStatus::Enabled,
            other => ReplicaModificationsStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReplicaModificationsStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReplicaModificationsStatus::from(s))
    }
}
impl ReplicaModificationsStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReplicaModificationsStatus::Disabled => "Disabled",
            ReplicaModificationsStatus::Enabled => "Enabled",
            ReplicaModificationsStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Disabled", "Enabled"]
    }
}
impl AsRef<str> for ReplicaModificationsStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A container for filter information for the selection of S3 objects encrypted with Amazon Web Services KMS.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SseKmsEncryptedObjects {
    /// <p>Specifies whether Amazon S3 replicates objects created with server-side encryption using an Amazon Web Services KMS key stored in Amazon Web Services Key Management Service.</p>
    pub status: std::option::Option<crate::model::SseKmsEncryptedObjectsStatus>,
}
impl SseKmsEncryptedObjects {
    /// <p>Specifies whether Amazon S3 replicates objects created with server-side encryption using an Amazon Web Services KMS key stored in Amazon Web Services Key Management Service.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::SseKmsEncryptedObjectsStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for SseKmsEncryptedObjects {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SseKmsEncryptedObjects");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`SseKmsEncryptedObjects`](crate::model::SseKmsEncryptedObjects)
pub mod sse_kms_encrypted_objects {
    /// A builder for [`SseKmsEncryptedObjects`](crate::model::SseKmsEncryptedObjects)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::SseKmsEncryptedObjectsStatus>,
    }
    impl Builder {
        /// <p>Specifies whether Amazon S3 replicates objects created with server-side encryption using an Amazon Web Services KMS key stored in Amazon Web Services Key Management Service.</p>
        pub fn status(mut self, input: crate::model::SseKmsEncryptedObjectsStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Specifies whether Amazon S3 replicates objects created with server-side encryption using an Amazon Web Services KMS key stored in Amazon Web Services Key Management Service.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SseKmsEncryptedObjectsStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`SseKmsEncryptedObjects`](crate::model::SseKmsEncryptedObjects)
        pub fn build(self) -> crate::model::SseKmsEncryptedObjects {
            crate::model::SseKmsEncryptedObjects {
                status: self.status,
            }
        }
    }
}
impl SseKmsEncryptedObjects {
    /// Creates a new builder-style object to manufacture [`SseKmsEncryptedObjects`](crate::model::SseKmsEncryptedObjects)
    pub fn builder() -> crate::model::sse_kms_encrypted_objects::Builder {
        crate::model::sse_kms_encrypted_objects::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SseKmsEncryptedObjectsStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SseKmsEncryptedObjectsStatus {
    fn from(s: &str) -> Self {
        match s {
            "Disabled" => SseKmsEncryptedObjectsStatus::Disabled,
            "Enabled" => SseKmsEncryptedObjectsStatus::Enabled,
            other => SseKmsEncryptedObjectsStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SseKmsEncryptedObjectsStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SseKmsEncryptedObjectsStatus::from(s))
    }
}
impl SseKmsEncryptedObjectsStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SseKmsEncryptedObjectsStatus::Disabled => "Disabled",
            SseKmsEncryptedObjectsStatus::Enabled => "Enabled",
            SseKmsEncryptedObjectsStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Disabled", "Enabled"]
    }
}
impl AsRef<str> for SseKmsEncryptedObjectsStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReplicationRuleStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReplicationRuleStatus {
    fn from(s: &str) -> Self {
        match s {
            "Disabled" => ReplicationRuleStatus::Disabled,
            "Enabled" => ReplicationRuleStatus::Enabled,
            other => ReplicationRuleStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReplicationRuleStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReplicationRuleStatus::from(s))
    }
}
impl ReplicationRuleStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReplicationRuleStatus::Disabled => "Disabled",
            ReplicationRuleStatus::Enabled => "Enabled",
            ReplicationRuleStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Disabled", "Enabled"]
    }
}
impl AsRef<str> for ReplicationRuleStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A filter that identifies the subset of objects to which the replication rule applies. A <code>Filter</code> must specify exactly one <code>Prefix</code>, <code>Tag</code>, or an <code>And</code> child element.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum ReplicationRuleFilter {
    /// <p>A container for specifying rule filters. The filters determine the subset of objects to which the rule applies. This element is required only if you specify more than one filter. For example: </p>
    /// <ul>
    /// <li> <p>If you specify both a <code>Prefix</code> and a <code>Tag</code> filter, wrap these filters in an <code>And</code> tag.</p> </li>
    /// <li> <p>If you specify a filter based on multiple tags, wrap the <code>Tag</code> elements in an <code>And</code> tag.</p> </li>
    /// </ul>
    And(crate::model::ReplicationRuleAndOperator),
    /// <p>An object key name prefix that identifies the subset of objects to which the rule applies.</p> <important>
    /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
    /// </important>
    Prefix(std::string::String),
    /// <p>A container for specifying a tag key and value. </p>
    /// <p>The rule applies only to objects that have the tag in their tag set.</p>
    Tag(crate::model::Tag),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl ReplicationRuleFilter {
    /// Tries to convert the enum instance into [`And`](crate::model::ReplicationRuleFilter::And), extracting the inner [`ReplicationRuleAndOperator`](crate::model::ReplicationRuleAndOperator).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_and(&self) -> std::result::Result<&crate::model::ReplicationRuleAndOperator, &Self> {
        if let ReplicationRuleFilter::And(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`And`](crate::model::ReplicationRuleFilter::And).
    pub fn is_and(&self) -> bool {
        self.as_and().is_ok()
    }
    /// Tries to convert the enum instance into [`Prefix`](crate::model::ReplicationRuleFilter::Prefix), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_prefix(&self) -> std::result::Result<&std::string::String, &Self> {
        if let ReplicationRuleFilter::Prefix(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Prefix`](crate::model::ReplicationRuleFilter::Prefix).
    pub fn is_prefix(&self) -> bool {
        self.as_prefix().is_ok()
    }
    /// Tries to convert the enum instance into [`Tag`](crate::model::ReplicationRuleFilter::Tag), extracting the inner [`Tag`](crate::model::Tag).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_tag(&self) -> std::result::Result<&crate::model::Tag, &Self> {
        if let ReplicationRuleFilter::Tag(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Tag`](crate::model::ReplicationRuleFilter::Tag).
    pub fn is_tag(&self) -> bool {
        self.as_tag().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>A container for specifying rule filters. The filters determine the subset of objects to which the rule applies. This element is required only if you specify more than one filter. </p>
/// <p>For example:</p>
/// <ul>
/// <li> <p>If you specify both a <code>Prefix</code> and a <code>Tag</code> filter, wrap these filters in an <code>And</code> tag. </p> </li>
/// <li> <p>If you specify a filter based on multiple tags, wrap the <code>Tag</code> elements in an <code>And</code> tag.</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationRuleAndOperator {
    /// <p>An object key name prefix that identifies the subset of objects to which the rule applies.</p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>An array of tags containing key and value pairs.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ReplicationRuleAndOperator {
    /// <p>An object key name prefix that identifies the subset of objects to which the rule applies.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>An array of tags containing key and value pairs.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ReplicationRuleAndOperator {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationRuleAndOperator");
        formatter.field("prefix", &self.prefix);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ReplicationRuleAndOperator`](crate::model::ReplicationRuleAndOperator)
pub mod replication_rule_and_operator {
    /// A builder for [`ReplicationRuleAndOperator`](crate::model::ReplicationRuleAndOperator)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>An object key name prefix that identifies the subset of objects to which the rule applies.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>An object key name prefix that identifies the subset of objects to which the rule applies.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array of tags containing key and value pairs.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>An array of tags containing key and value pairs.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationRuleAndOperator`](crate::model::ReplicationRuleAndOperator)
        pub fn build(self) -> crate::model::ReplicationRuleAndOperator {
            crate::model::ReplicationRuleAndOperator {
                prefix: self.prefix,
                tags: self.tags,
            }
        }
    }
}
impl ReplicationRuleAndOperator {
    /// Creates a new builder-style object to manufacture [`ReplicationRuleAndOperator`](crate::model::ReplicationRuleAndOperator)
    pub fn builder() -> crate::model::replication_rule_and_operator::Builder {
        crate::model::replication_rule_and_operator::Builder::default()
    }
}

/// <p>The container element for a bucket's ownership controls.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OwnershipControls {
    /// <p>The container element for an ownership control rule.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::OwnershipControlsRule>>,
}
impl OwnershipControls {
    /// <p>The container element for an ownership control rule.</p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::OwnershipControlsRule]> {
        self.rules.as_deref()
    }
}
impl std::fmt::Debug for OwnershipControls {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OwnershipControls");
        formatter.field("rules", &self.rules);
        formatter.finish()
    }
}
/// See [`OwnershipControls`](crate::model::OwnershipControls)
pub mod ownership_controls {
    /// A builder for [`OwnershipControls`](crate::model::OwnershipControls)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::OwnershipControlsRule>>,
    }
    impl Builder {
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The container element for an ownership control rule.</p>
        pub fn rules(mut self, input: crate::model::OwnershipControlsRule) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input);
            self.rules = Some(v);
            self
        }
        /// <p>The container element for an ownership control rule.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OwnershipControlsRule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// Consumes the builder and constructs a [`OwnershipControls`](crate::model::OwnershipControls)
        pub fn build(self) -> crate::model::OwnershipControls {
            crate::model::OwnershipControls { rules: self.rules }
        }
    }
}
impl OwnershipControls {
    /// Creates a new builder-style object to manufacture [`OwnershipControls`](crate::model::OwnershipControls)
    pub fn builder() -> crate::model::ownership_controls::Builder {
        crate::model::ownership_controls::Builder::default()
    }
}

/// <p>The container element for an ownership control rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OwnershipControlsRule {
    /// <p>The container element for object ownership for a bucket's ownership controls.</p>
    /// <p>BucketOwnerPreferred - Objects uploaded to the bucket change ownership to the bucket owner if the objects are uploaded with the <code>bucket-owner-full-control</code> canned ACL.</p>
    /// <p>ObjectWriter - The uploading account will own the object if the object is uploaded with the <code>bucket-owner-full-control</code> canned ACL.</p>
    /// <p>BucketOwnerEnforced - Access control lists (ACLs) are disabled and no longer affect permissions. The bucket owner automatically owns and has full control over every object in the bucket. The bucket only accepts PUT requests that don't specify an ACL or bucket owner full control ACLs, such as the <code>bucket-owner-full-control</code> canned ACL or an equivalent form of this ACL expressed in the XML format.</p>
    pub object_ownership: std::option::Option<crate::model::ObjectOwnership>,
}
impl OwnershipControlsRule {
    /// <p>The container element for object ownership for a bucket's ownership controls.</p>
    /// <p>BucketOwnerPreferred - Objects uploaded to the bucket change ownership to the bucket owner if the objects are uploaded with the <code>bucket-owner-full-control</code> canned ACL.</p>
    /// <p>ObjectWriter - The uploading account will own the object if the object is uploaded with the <code>bucket-owner-full-control</code> canned ACL.</p>
    /// <p>BucketOwnerEnforced - Access control lists (ACLs) are disabled and no longer affect permissions. The bucket owner automatically owns and has full control over every object in the bucket. The bucket only accepts PUT requests that don't specify an ACL or bucket owner full control ACLs, such as the <code>bucket-owner-full-control</code> canned ACL or an equivalent form of this ACL expressed in the XML format.</p>
    pub fn object_ownership(&self) -> std::option::Option<&crate::model::ObjectOwnership> {
        self.object_ownership.as_ref()
    }
}
impl std::fmt::Debug for OwnershipControlsRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OwnershipControlsRule");
        formatter.field("object_ownership", &self.object_ownership);
        formatter.finish()
    }
}
/// See [`OwnershipControlsRule`](crate::model::OwnershipControlsRule)
pub mod ownership_controls_rule {
    /// A builder for [`OwnershipControlsRule`](crate::model::OwnershipControlsRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_ownership: std::option::Option<crate::model::ObjectOwnership>,
    }
    impl Builder {
        /// <p>The container element for object ownership for a bucket's ownership controls.</p>
        /// <p>BucketOwnerPreferred - Objects uploaded to the bucket change ownership to the bucket owner if the objects are uploaded with the <code>bucket-owner-full-control</code> canned ACL.</p>
        /// <p>ObjectWriter - The uploading account will own the object if the object is uploaded with the <code>bucket-owner-full-control</code> canned ACL.</p>
        /// <p>BucketOwnerEnforced - Access control lists (ACLs) are disabled and no longer affect permissions. The bucket owner automatically owns and has full control over every object in the bucket. The bucket only accepts PUT requests that don't specify an ACL or bucket owner full control ACLs, such as the <code>bucket-owner-full-control</code> canned ACL or an equivalent form of this ACL expressed in the XML format.</p>
        pub fn object_ownership(mut self, input: crate::model::ObjectOwnership) -> Self {
            self.object_ownership = Some(input);
            self
        }
        /// <p>The container element for object ownership for a bucket's ownership controls.</p>
        /// <p>BucketOwnerPreferred - Objects uploaded to the bucket change ownership to the bucket owner if the objects are uploaded with the <code>bucket-owner-full-control</code> canned ACL.</p>
        /// <p>ObjectWriter - The uploading account will own the object if the object is uploaded with the <code>bucket-owner-full-control</code> canned ACL.</p>
        /// <p>BucketOwnerEnforced - Access control lists (ACLs) are disabled and no longer affect permissions. The bucket owner automatically owns and has full control over every object in the bucket. The bucket only accepts PUT requests that don't specify an ACL or bucket owner full control ACLs, such as the <code>bucket-owner-full-control</code> canned ACL or an equivalent form of this ACL expressed in the XML format.</p>
        pub fn set_object_ownership(
            mut self,
            input: std::option::Option<crate::model::ObjectOwnership>,
        ) -> Self {
            self.object_ownership = input;
            self
        }
        /// Consumes the builder and constructs a [`OwnershipControlsRule`](crate::model::OwnershipControlsRule)
        pub fn build(self) -> crate::model::OwnershipControlsRule {
            crate::model::OwnershipControlsRule {
                object_ownership: self.object_ownership,
            }
        }
    }
}
impl OwnershipControlsRule {
    /// Creates a new builder-style object to manufacture [`OwnershipControlsRule`](crate::model::OwnershipControlsRule)
    pub fn builder() -> crate::model::ownership_controls_rule::Builder {
        crate::model::ownership_controls_rule::Builder::default()
    }
}

/// <p>The container element for object ownership for a bucket's ownership controls.</p>
/// <p>BucketOwnerPreferred - Objects uploaded to the bucket change ownership to the bucket
/// owner if the objects are uploaded with the <code>bucket-owner-full-control</code> canned
/// ACL.</p>
/// <p>ObjectWriter - The uploading account will own the object if the object is uploaded with
/// the <code>bucket-owner-full-control</code> canned ACL.</p>
/// <p>BucketOwnerEnforced - Access control lists (ACLs) are disabled and no longer affect permissions.
/// The bucket owner automatically owns and has full control over every object in the bucket. The bucket only
/// accepts PUT requests that don't specify an ACL or bucket owner full control
/// ACLs, such as the <code>bucket-owner-full-control</code> canned
/// ACL or an equivalent form of this ACL expressed in the XML format.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ObjectOwnership {
    #[allow(missing_docs)] // documentation missing in model
    BucketOwnerEnforced,
    #[allow(missing_docs)] // documentation missing in model
    BucketOwnerPreferred,
    #[allow(missing_docs)] // documentation missing in model
    ObjectWriter,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ObjectOwnership {
    fn from(s: &str) -> Self {
        match s {
            "BucketOwnerEnforced" => ObjectOwnership::BucketOwnerEnforced,
            "BucketOwnerPreferred" => ObjectOwnership::BucketOwnerPreferred,
            "ObjectWriter" => ObjectOwnership::ObjectWriter,
            other => ObjectOwnership::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ObjectOwnership {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ObjectOwnership::from(s))
    }
}
impl ObjectOwnership {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ObjectOwnership::BucketOwnerEnforced => "BucketOwnerEnforced",
            ObjectOwnership::BucketOwnerPreferred => "BucketOwnerPreferred",
            ObjectOwnership::ObjectWriter => "ObjectWriter",
            ObjectOwnership::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BucketOwnerEnforced",
            "BucketOwnerPreferred",
            "ObjectWriter",
        ]
    }
}
impl AsRef<str> for ObjectOwnership {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A container for specifying the notification configuration of the bucket. If this element is empty, notifications are turned off for the bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotificationConfiguration {
    /// <p>The topic to which notifications are sent and the events for which notifications are generated.</p>
    pub topic_configurations: std::option::Option<std::vec::Vec<crate::model::TopicConfiguration>>,
    /// <p>The Amazon Simple Queue Service queues to publish messages to and the events for which to publish messages.</p>
    pub queue_configurations: std::option::Option<std::vec::Vec<crate::model::QueueConfiguration>>,
    /// <p>Describes the Lambda functions to invoke and the events for which to invoke them.</p>
    pub lambda_function_configurations:
        std::option::Option<std::vec::Vec<crate::model::LambdaFunctionConfiguration>>,
    /// <p>Enables delivery of events to Amazon EventBridge.</p>
    pub event_bridge_configuration: std::option::Option<crate::model::EventBridgeConfiguration>,
}
impl NotificationConfiguration {
    /// <p>The topic to which notifications are sent and the events for which notifications are generated.</p>
    pub fn topic_configurations(&self) -> std::option::Option<&[crate::model::TopicConfiguration]> {
        self.topic_configurations.as_deref()
    }
    /// <p>The Amazon Simple Queue Service queues to publish messages to and the events for which to publish messages.</p>
    pub fn queue_configurations(&self) -> std::option::Option<&[crate::model::QueueConfiguration]> {
        self.queue_configurations.as_deref()
    }
    /// <p>Describes the Lambda functions to invoke and the events for which to invoke them.</p>
    pub fn lambda_function_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::LambdaFunctionConfiguration]> {
        self.lambda_function_configurations.as_deref()
    }
    /// <p>Enables delivery of events to Amazon EventBridge.</p>
    pub fn event_bridge_configuration(
        &self,
    ) -> std::option::Option<&crate::model::EventBridgeConfiguration> {
        self.event_bridge_configuration.as_ref()
    }
}
impl std::fmt::Debug for NotificationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotificationConfiguration");
        formatter.field("topic_configurations", &self.topic_configurations);
        formatter.field("queue_configurations", &self.queue_configurations);
        formatter.field(
            "lambda_function_configurations",
            &self.lambda_function_configurations,
        );
        formatter.field(
            "event_bridge_configuration",
            &self.event_bridge_configuration,
        );
        formatter.finish()
    }
}
/// See [`NotificationConfiguration`](crate::model::NotificationConfiguration)
pub mod notification_configuration {
    /// A builder for [`NotificationConfiguration`](crate::model::NotificationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) topic_configurations:
            std::option::Option<std::vec::Vec<crate::model::TopicConfiguration>>,
        pub(crate) queue_configurations:
            std::option::Option<std::vec::Vec<crate::model::QueueConfiguration>>,
        pub(crate) lambda_function_configurations:
            std::option::Option<std::vec::Vec<crate::model::LambdaFunctionConfiguration>>,
        pub(crate) event_bridge_configuration:
            std::option::Option<crate::model::EventBridgeConfiguration>,
    }
    impl Builder {
        /// Appends an item to `topic_configurations`.
        ///
        /// To override the contents of this collection use [`set_topic_configurations`](Self::set_topic_configurations).
        ///
        /// <p>The topic to which notifications are sent and the events for which notifications are generated.</p>
        pub fn topic_configurations(mut self, input: crate::model::TopicConfiguration) -> Self {
            let mut v = self.topic_configurations.unwrap_or_default();
            v.push(input);
            self.topic_configurations = Some(v);
            self
        }
        /// <p>The topic to which notifications are sent and the events for which notifications are generated.</p>
        pub fn set_topic_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TopicConfiguration>>,
        ) -> Self {
            self.topic_configurations = input;
            self
        }
        /// Appends an item to `queue_configurations`.
        ///
        /// To override the contents of this collection use [`set_queue_configurations`](Self::set_queue_configurations).
        ///
        /// <p>The Amazon Simple Queue Service queues to publish messages to and the events for which to publish messages.</p>
        pub fn queue_configurations(mut self, input: crate::model::QueueConfiguration) -> Self {
            let mut v = self.queue_configurations.unwrap_or_default();
            v.push(input);
            self.queue_configurations = Some(v);
            self
        }
        /// <p>The Amazon Simple Queue Service queues to publish messages to and the events for which to publish messages.</p>
        pub fn set_queue_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::QueueConfiguration>>,
        ) -> Self {
            self.queue_configurations = input;
            self
        }
        /// Appends an item to `lambda_function_configurations`.
        ///
        /// To override the contents of this collection use [`set_lambda_function_configurations`](Self::set_lambda_function_configurations).
        ///
        /// <p>Describes the Lambda functions to invoke and the events for which to invoke them.</p>
        pub fn lambda_function_configurations(
            mut self,
            input: crate::model::LambdaFunctionConfiguration,
        ) -> Self {
            let mut v = self.lambda_function_configurations.unwrap_or_default();
            v.push(input);
            self.lambda_function_configurations = Some(v);
            self
        }
        /// <p>Describes the Lambda functions to invoke and the events for which to invoke them.</p>
        pub fn set_lambda_function_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LambdaFunctionConfiguration>>,
        ) -> Self {
            self.lambda_function_configurations = input;
            self
        }
        /// <p>Enables delivery of events to Amazon EventBridge.</p>
        pub fn event_bridge_configuration(
            mut self,
            input: crate::model::EventBridgeConfiguration,
        ) -> Self {
            self.event_bridge_configuration = Some(input);
            self
        }
        /// <p>Enables delivery of events to Amazon EventBridge.</p>
        pub fn set_event_bridge_configuration(
            mut self,
            input: std::option::Option<crate::model::EventBridgeConfiguration>,
        ) -> Self {
            self.event_bridge_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`NotificationConfiguration`](crate::model::NotificationConfiguration)
        pub fn build(self) -> crate::model::NotificationConfiguration {
            crate::model::NotificationConfiguration {
                topic_configurations: self.topic_configurations,
                queue_configurations: self.queue_configurations,
                lambda_function_configurations: self.lambda_function_configurations,
                event_bridge_configuration: self.event_bridge_configuration,
            }
        }
    }
}
impl NotificationConfiguration {
    /// Creates a new builder-style object to manufacture [`NotificationConfiguration`](crate::model::NotificationConfiguration)
    pub fn builder() -> crate::model::notification_configuration::Builder {
        crate::model::notification_configuration::Builder::default()
    }
}

/// <p>A container for specifying the configuration for Amazon EventBridge.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventBridgeConfiguration {}
impl std::fmt::Debug for EventBridgeConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventBridgeConfiguration");
        formatter.finish()
    }
}
/// See [`EventBridgeConfiguration`](crate::model::EventBridgeConfiguration)
pub mod event_bridge_configuration {
    /// A builder for [`EventBridgeConfiguration`](crate::model::EventBridgeConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`EventBridgeConfiguration`](crate::model::EventBridgeConfiguration)
        pub fn build(self) -> crate::model::EventBridgeConfiguration {
            crate::model::EventBridgeConfiguration {}
        }
    }
}
impl EventBridgeConfiguration {
    /// Creates a new builder-style object to manufacture [`EventBridgeConfiguration`](crate::model::EventBridgeConfiguration)
    pub fn builder() -> crate::model::event_bridge_configuration::Builder {
        crate::model::event_bridge_configuration::Builder::default()
    }
}

/// <p>A container for specifying the configuration for Lambda notifications.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaFunctionConfiguration {
    /// <p>An optional unique identifier for configurations in a notification configuration. If you don't provide one, Amazon S3 will assign an ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Lambda function that Amazon S3 invokes when the specified event type occurs.</p>
    pub lambda_function_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 bucket event for which to invoke the Lambda function. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Supported Event Types</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub events: std::option::Option<std::vec::Vec<crate::model::Event>>,
    /// <p>Specifies object key name filtering rules. For information about key name filtering, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub filter: std::option::Option<crate::model::NotificationConfigurationFilter>,
}
impl LambdaFunctionConfiguration {
    /// <p>An optional unique identifier for configurations in a notification configuration. If you don't provide one, Amazon S3 will assign an ID.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Lambda function that Amazon S3 invokes when the specified event type occurs.</p>
    pub fn lambda_function_arn(&self) -> std::option::Option<&str> {
        self.lambda_function_arn.as_deref()
    }
    /// <p>The Amazon S3 bucket event for which to invoke the Lambda function. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Supported Event Types</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn events(&self) -> std::option::Option<&[crate::model::Event]> {
        self.events.as_deref()
    }
    /// <p>Specifies object key name filtering rules. For information about key name filtering, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::NotificationConfigurationFilter> {
        self.filter.as_ref()
    }
}
impl std::fmt::Debug for LambdaFunctionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaFunctionConfiguration");
        formatter.field("id", &self.id);
        formatter.field("lambda_function_arn", &self.lambda_function_arn);
        formatter.field("events", &self.events);
        formatter.field("filter", &self.filter);
        formatter.finish()
    }
}
/// See [`LambdaFunctionConfiguration`](crate::model::LambdaFunctionConfiguration)
pub mod lambda_function_configuration {
    /// A builder for [`LambdaFunctionConfiguration`](crate::model::LambdaFunctionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) lambda_function_arn: std::option::Option<std::string::String>,
        pub(crate) events: std::option::Option<std::vec::Vec<crate::model::Event>>,
        pub(crate) filter: std::option::Option<crate::model::NotificationConfigurationFilter>,
    }
    impl Builder {
        /// <p>An optional unique identifier for configurations in a notification configuration. If you don't provide one, Amazon S3 will assign an ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>An optional unique identifier for configurations in a notification configuration. If you don't provide one, Amazon S3 will assign an ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Lambda function that Amazon S3 invokes when the specified event type occurs.</p>
        pub fn lambda_function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.lambda_function_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Lambda function that Amazon S3 invokes when the specified event type occurs.</p>
        pub fn set_lambda_function_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lambda_function_arn = input;
            self
        }
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>The Amazon S3 bucket event for which to invoke the Lambda function. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Supported Event Types</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn events(mut self, input: crate::model::Event) -> Self {
            let mut v = self.events.unwrap_or_default();
            v.push(input);
            self.events = Some(v);
            self
        }
        /// <p>The Amazon S3 bucket event for which to invoke the Lambda function. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Supported Event Types</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Event>>,
        ) -> Self {
            self.events = input;
            self
        }
        /// <p>Specifies object key name filtering rules. For information about key name filtering, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn filter(mut self, input: crate::model::NotificationConfigurationFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Specifies object key name filtering rules. For information about key name filtering, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::NotificationConfigurationFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaFunctionConfiguration`](crate::model::LambdaFunctionConfiguration)
        pub fn build(self) -> crate::model::LambdaFunctionConfiguration {
            crate::model::LambdaFunctionConfiguration {
                id: self.id,
                lambda_function_arn: self.lambda_function_arn,
                events: self.events,
                filter: self.filter,
            }
        }
    }
}
impl LambdaFunctionConfiguration {
    /// Creates a new builder-style object to manufacture [`LambdaFunctionConfiguration`](crate::model::LambdaFunctionConfiguration)
    pub fn builder() -> crate::model::lambda_function_configuration::Builder {
        crate::model::lambda_function_configuration::Builder::default()
    }
}

/// <p>Specifies object key name filtering rules. For information about key name filtering, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a> in the <i>Amazon S3 User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotificationConfigurationFilter {
    /// <p>A container for object key name prefix and suffix filtering rules.</p>
    pub key: std::option::Option<crate::model::S3KeyFilter>,
}
impl NotificationConfigurationFilter {
    /// <p>A container for object key name prefix and suffix filtering rules.</p>
    pub fn key(&self) -> std::option::Option<&crate::model::S3KeyFilter> {
        self.key.as_ref()
    }
}
impl std::fmt::Debug for NotificationConfigurationFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotificationConfigurationFilter");
        formatter.field("key", &self.key);
        formatter.finish()
    }
}
/// See [`NotificationConfigurationFilter`](crate::model::NotificationConfigurationFilter)
pub mod notification_configuration_filter {
    /// A builder for [`NotificationConfigurationFilter`](crate::model::NotificationConfigurationFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<crate::model::S3KeyFilter>,
    }
    impl Builder {
        /// <p>A container for object key name prefix and suffix filtering rules.</p>
        pub fn key(mut self, input: crate::model::S3KeyFilter) -> Self {
            self.key = Some(input);
            self
        }
        /// <p>A container for object key name prefix and suffix filtering rules.</p>
        pub fn set_key(mut self, input: std::option::Option<crate::model::S3KeyFilter>) -> Self {
            self.key = input;
            self
        }
        /// Consumes the builder and constructs a [`NotificationConfigurationFilter`](crate::model::NotificationConfigurationFilter)
        pub fn build(self) -> crate::model::NotificationConfigurationFilter {
            crate::model::NotificationConfigurationFilter { key: self.key }
        }
    }
}
impl NotificationConfigurationFilter {
    /// Creates a new builder-style object to manufacture [`NotificationConfigurationFilter`](crate::model::NotificationConfigurationFilter)
    pub fn builder() -> crate::model::notification_configuration_filter::Builder {
        crate::model::notification_configuration_filter::Builder::default()
    }
}

/// <p>A container for object key name prefix and suffix filtering rules.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3KeyFilter {
    /// <p>A list of containers for the key-value pair that defines the criteria for the filter rule.</p>
    pub filter_rules: std::option::Option<std::vec::Vec<crate::model::FilterRule>>,
}
impl S3KeyFilter {
    /// <p>A list of containers for the key-value pair that defines the criteria for the filter rule.</p>
    pub fn filter_rules(&self) -> std::option::Option<&[crate::model::FilterRule]> {
        self.filter_rules.as_deref()
    }
}
impl std::fmt::Debug for S3KeyFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3KeyFilter");
        formatter.field("filter_rules", &self.filter_rules);
        formatter.finish()
    }
}
/// See [`S3KeyFilter`](crate::model::S3KeyFilter)
pub mod s3_key_filter {
    /// A builder for [`S3KeyFilter`](crate::model::S3KeyFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter_rules: std::option::Option<std::vec::Vec<crate::model::FilterRule>>,
    }
    impl Builder {
        /// Appends an item to `filter_rules`.
        ///
        /// To override the contents of this collection use [`set_filter_rules`](Self::set_filter_rules).
        ///
        /// <p>A list of containers for the key-value pair that defines the criteria for the filter rule.</p>
        pub fn filter_rules(mut self, input: crate::model::FilterRule) -> Self {
            let mut v = self.filter_rules.unwrap_or_default();
            v.push(input);
            self.filter_rules = Some(v);
            self
        }
        /// <p>A list of containers for the key-value pair that defines the criteria for the filter rule.</p>
        pub fn set_filter_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FilterRule>>,
        ) -> Self {
            self.filter_rules = input;
            self
        }
        /// Consumes the builder and constructs a [`S3KeyFilter`](crate::model::S3KeyFilter)
        pub fn build(self) -> crate::model::S3KeyFilter {
            crate::model::S3KeyFilter {
                filter_rules: self.filter_rules,
            }
        }
    }
}
impl S3KeyFilter {
    /// Creates a new builder-style object to manufacture [`S3KeyFilter`](crate::model::S3KeyFilter)
    pub fn builder() -> crate::model::s3_key_filter::Builder {
        crate::model::s3_key_filter::Builder::default()
    }
}

/// <p>Specifies the Amazon S3 object key name to filter on and whether to filter on the suffix or prefix of the key name.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FilterRule {
    /// <p>The object key name prefix or suffix identifying one or more objects to which the filtering rule applies. The maximum length is 1,024 characters. Overlapping prefixes and suffixes are not supported. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub name: std::option::Option<crate::model::FilterRuleName>,
    /// <p>The value that the filter searches for in object key names.</p>
    pub value: std::option::Option<std::string::String>,
}
impl FilterRule {
    /// <p>The object key name prefix or suffix identifying one or more objects to which the filtering rule applies. The maximum length is 1,024 characters. Overlapping prefixes and suffixes are not supported. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::FilterRuleName> {
        self.name.as_ref()
    }
    /// <p>The value that the filter searches for in object key names.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for FilterRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FilterRule");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`FilterRule`](crate::model::FilterRule)
pub mod filter_rule {
    /// A builder for [`FilterRule`](crate::model::FilterRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::FilterRuleName>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The object key name prefix or suffix identifying one or more objects to which the filtering rule applies. The maximum length is 1,024 characters. Overlapping prefixes and suffixes are not supported. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn name(mut self, input: crate::model::FilterRuleName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The object key name prefix or suffix identifying one or more objects to which the filtering rule applies. The maximum length is 1,024 characters. Overlapping prefixes and suffixes are not supported. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::FilterRuleName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>The value that the filter searches for in object key names.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value that the filter searches for in object key names.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`FilterRule`](crate::model::FilterRule)
        pub fn build(self) -> crate::model::FilterRule {
            crate::model::FilterRule {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl FilterRule {
    /// Creates a new builder-style object to manufacture [`FilterRule`](crate::model::FilterRule)
    pub fn builder() -> crate::model::filter_rule::Builder {
        crate::model::filter_rule::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FilterRuleName {
    #[allow(missing_docs)] // documentation missing in model
    Prefix,
    #[allow(missing_docs)] // documentation missing in model
    Suffix,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FilterRuleName {
    fn from(s: &str) -> Self {
        match s {
            "prefix" => FilterRuleName::Prefix,
            "suffix" => FilterRuleName::Suffix,
            other => FilterRuleName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FilterRuleName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FilterRuleName::from(s))
    }
}
impl FilterRuleName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FilterRuleName::Prefix => "prefix",
            FilterRuleName::Suffix => "suffix",
            FilterRuleName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["prefix", "suffix"]
    }
}
impl AsRef<str> for FilterRuleName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The bucket event for which to send notifications.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub struct Event(String);
impl Event {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        &self.0
    }
    /// Returns all the `&str` representations of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "s3:IntelligentTiering",
            "s3:LifecycleExpiration:*",
            "s3:LifecycleExpiration:Delete",
            "s3:LifecycleExpiration:DeleteMarkerCreated",
            "s3:LifecycleTransition",
            "s3:ObjectAcl:Put",
            "s3:ObjectCreated:*",
            "s3:ObjectCreated:CompleteMultipartUpload",
            "s3:ObjectCreated:Copy",
            "s3:ObjectCreated:Post",
            "s3:ObjectCreated:Put",
            "s3:ObjectRemoved:*",
            "s3:ObjectRemoved:Delete",
            "s3:ObjectRemoved:DeleteMarkerCreated",
            "s3:ObjectRestore:*",
            "s3:ObjectRestore:Completed",
            "s3:ObjectRestore:Delete",
            "s3:ObjectRestore:Post",
            "s3:ObjectTagging:*",
            "s3:ObjectTagging:Delete",
            "s3:ObjectTagging:Put",
            "s3:ReducedRedundancyLostObject",
            "s3:Replication:*",
            "s3:Replication:OperationFailedReplication",
            "s3:Replication:OperationMissedThreshold",
            "s3:Replication:OperationNotTracked",
            "s3:Replication:OperationReplicatedAfterThreshold",
        ]
    }
}
impl<T> std::convert::From<T> for Event
where
    T: std::convert::AsRef<str>,
{
    fn from(s: T) -> Self {
        Event(s.as_ref().to_owned())
    }
}

/// <p>Specifies the configuration for publishing messages to an Amazon Simple Queue Service (Amazon SQS) queue when Amazon S3 detects specified events.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueueConfiguration {
    /// <p>An optional unique identifier for configurations in a notification configuration. If you don't provide one, Amazon S3 will assign an ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon SQS queue to which Amazon S3 publishes a message when it detects events of the specified type.</p>
    pub queue_arn: std::option::Option<std::string::String>,
    /// <p>A collection of bucket events for which to send notifications</p>
    pub events: std::option::Option<std::vec::Vec<crate::model::Event>>,
    /// <p>Specifies object key name filtering rules. For information about key name filtering, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub filter: std::option::Option<crate::model::NotificationConfigurationFilter>,
}
impl QueueConfiguration {
    /// <p>An optional unique identifier for configurations in a notification configuration. If you don't provide one, Amazon S3 will assign an ID.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon SQS queue to which Amazon S3 publishes a message when it detects events of the specified type.</p>
    pub fn queue_arn(&self) -> std::option::Option<&str> {
        self.queue_arn.as_deref()
    }
    /// <p>A collection of bucket events for which to send notifications</p>
    pub fn events(&self) -> std::option::Option<&[crate::model::Event]> {
        self.events.as_deref()
    }
    /// <p>Specifies object key name filtering rules. For information about key name filtering, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::NotificationConfigurationFilter> {
        self.filter.as_ref()
    }
}
impl std::fmt::Debug for QueueConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueueConfiguration");
        formatter.field("id", &self.id);
        formatter.field("queue_arn", &self.queue_arn);
        formatter.field("events", &self.events);
        formatter.field("filter", &self.filter);
        formatter.finish()
    }
}
/// See [`QueueConfiguration`](crate::model::QueueConfiguration)
pub mod queue_configuration {
    /// A builder for [`QueueConfiguration`](crate::model::QueueConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) queue_arn: std::option::Option<std::string::String>,
        pub(crate) events: std::option::Option<std::vec::Vec<crate::model::Event>>,
        pub(crate) filter: std::option::Option<crate::model::NotificationConfigurationFilter>,
    }
    impl Builder {
        /// <p>An optional unique identifier for configurations in a notification configuration. If you don't provide one, Amazon S3 will assign an ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>An optional unique identifier for configurations in a notification configuration. If you don't provide one, Amazon S3 will assign an ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SQS queue to which Amazon S3 publishes a message when it detects events of the specified type.</p>
        pub fn queue_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.queue_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SQS queue to which Amazon S3 publishes a message when it detects events of the specified type.</p>
        pub fn set_queue_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.queue_arn = input;
            self
        }
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>A collection of bucket events for which to send notifications</p>
        pub fn events(mut self, input: crate::model::Event) -> Self {
            let mut v = self.events.unwrap_or_default();
            v.push(input);
            self.events = Some(v);
            self
        }
        /// <p>A collection of bucket events for which to send notifications</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Event>>,
        ) -> Self {
            self.events = input;
            self
        }
        /// <p>Specifies object key name filtering rules. For information about key name filtering, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn filter(mut self, input: crate::model::NotificationConfigurationFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Specifies object key name filtering rules. For information about key name filtering, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::NotificationConfigurationFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// Consumes the builder and constructs a [`QueueConfiguration`](crate::model::QueueConfiguration)
        pub fn build(self) -> crate::model::QueueConfiguration {
            crate::model::QueueConfiguration {
                id: self.id,
                queue_arn: self.queue_arn,
                events: self.events,
                filter: self.filter,
            }
        }
    }
}
impl QueueConfiguration {
    /// Creates a new builder-style object to manufacture [`QueueConfiguration`](crate::model::QueueConfiguration)
    pub fn builder() -> crate::model::queue_configuration::Builder {
        crate::model::queue_configuration::Builder::default()
    }
}

/// <p>A container for specifying the configuration for publication of messages to an Amazon Simple Notification Service (Amazon SNS) topic when Amazon S3 detects specified events.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TopicConfiguration {
    /// <p>An optional unique identifier for configurations in a notification configuration. If you don't provide one, Amazon S3 will assign an ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which Amazon S3 publishes a message when it detects events of the specified type.</p>
    pub topic_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 bucket event about which to send notifications. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Supported Event Types</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub events: std::option::Option<std::vec::Vec<crate::model::Event>>,
    /// <p>Specifies object key name filtering rules. For information about key name filtering, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub filter: std::option::Option<crate::model::NotificationConfigurationFilter>,
}
impl TopicConfiguration {
    /// <p>An optional unique identifier for configurations in a notification configuration. If you don't provide one, Amazon S3 will assign an ID.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which Amazon S3 publishes a message when it detects events of the specified type.</p>
    pub fn topic_arn(&self) -> std::option::Option<&str> {
        self.topic_arn.as_deref()
    }
    /// <p>The Amazon S3 bucket event about which to send notifications. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Supported Event Types</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn events(&self) -> std::option::Option<&[crate::model::Event]> {
        self.events.as_deref()
    }
    /// <p>Specifies object key name filtering rules. For information about key name filtering, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::NotificationConfigurationFilter> {
        self.filter.as_ref()
    }
}
impl std::fmt::Debug for TopicConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TopicConfiguration");
        formatter.field("id", &self.id);
        formatter.field("topic_arn", &self.topic_arn);
        formatter.field("events", &self.events);
        formatter.field("filter", &self.filter);
        formatter.finish()
    }
}
/// See [`TopicConfiguration`](crate::model::TopicConfiguration)
pub mod topic_configuration {
    /// A builder for [`TopicConfiguration`](crate::model::TopicConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) topic_arn: std::option::Option<std::string::String>,
        pub(crate) events: std::option::Option<std::vec::Vec<crate::model::Event>>,
        pub(crate) filter: std::option::Option<crate::model::NotificationConfigurationFilter>,
    }
    impl Builder {
        /// <p>An optional unique identifier for configurations in a notification configuration. If you don't provide one, Amazon S3 will assign an ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>An optional unique identifier for configurations in a notification configuration. If you don't provide one, Amazon S3 will assign an ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which Amazon S3 publishes a message when it detects events of the specified type.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which Amazon S3 publishes a message when it detects events of the specified type.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>The Amazon S3 bucket event about which to send notifications. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Supported Event Types</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn events(mut self, input: crate::model::Event) -> Self {
            let mut v = self.events.unwrap_or_default();
            v.push(input);
            self.events = Some(v);
            self
        }
        /// <p>The Amazon S3 bucket event about which to send notifications. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Supported Event Types</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Event>>,
        ) -> Self {
            self.events = input;
            self
        }
        /// <p>Specifies object key name filtering rules. For information about key name filtering, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn filter(mut self, input: crate::model::NotificationConfigurationFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Specifies object key name filtering rules. For information about key name filtering, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html">Configuring Event Notifications</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::NotificationConfigurationFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// Consumes the builder and constructs a [`TopicConfiguration`](crate::model::TopicConfiguration)
        pub fn build(self) -> crate::model::TopicConfiguration {
            crate::model::TopicConfiguration {
                id: self.id,
                topic_arn: self.topic_arn,
                events: self.events,
                filter: self.filter,
            }
        }
    }
}
impl TopicConfiguration {
    /// Creates a new builder-style object to manufacture [`TopicConfiguration`](crate::model::TopicConfiguration)
    pub fn builder() -> crate::model::topic_configuration::Builder {
        crate::model::topic_configuration::Builder::default()
    }
}

/// <p>Specifies a metrics configuration for the CloudWatch request metrics (specified by the metrics configuration ID) from an Amazon S3 bucket. If you're updating an existing metrics configuration, note that this is a full replacement of the existing metrics configuration. If you don't include the elements you want to keep, they are erased. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTMetricConfiguration.html">PutBucketMetricsConfiguration</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricsConfiguration {
    /// <p>The ID used to identify the metrics configuration.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Specifies a metrics configuration filter. The metrics configuration will only include objects that meet the filter's criteria. A filter must be a prefix, an object tag, an access point ARN, or a conjunction (MetricsAndOperator).</p>
    pub filter: std::option::Option<crate::model::MetricsFilter>,
}
impl MetricsConfiguration {
    /// <p>The ID used to identify the metrics configuration.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Specifies a metrics configuration filter. The metrics configuration will only include objects that meet the filter's criteria. A filter must be a prefix, an object tag, an access point ARN, or a conjunction (MetricsAndOperator).</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::MetricsFilter> {
        self.filter.as_ref()
    }
}
impl std::fmt::Debug for MetricsConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricsConfiguration");
        formatter.field("id", &self.id);
        formatter.field("filter", &self.filter);
        formatter.finish()
    }
}
/// See [`MetricsConfiguration`](crate::model::MetricsConfiguration)
pub mod metrics_configuration {
    /// A builder for [`MetricsConfiguration`](crate::model::MetricsConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) filter: std::option::Option<crate::model::MetricsFilter>,
    }
    impl Builder {
        /// <p>The ID used to identify the metrics configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID used to identify the metrics configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Specifies a metrics configuration filter. The metrics configuration will only include objects that meet the filter's criteria. A filter must be a prefix, an object tag, an access point ARN, or a conjunction (MetricsAndOperator).</p>
        pub fn filter(mut self, input: crate::model::MetricsFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Specifies a metrics configuration filter. The metrics configuration will only include objects that meet the filter's criteria. A filter must be a prefix, an object tag, an access point ARN, or a conjunction (MetricsAndOperator).</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::MetricsFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricsConfiguration`](crate::model::MetricsConfiguration)
        pub fn build(self) -> crate::model::MetricsConfiguration {
            crate::model::MetricsConfiguration {
                id: self.id,
                filter: self.filter,
            }
        }
    }
}
impl MetricsConfiguration {
    /// Creates a new builder-style object to manufacture [`MetricsConfiguration`](crate::model::MetricsConfiguration)
    pub fn builder() -> crate::model::metrics_configuration::Builder {
        crate::model::metrics_configuration::Builder::default()
    }
}

/// <p>Specifies a metrics configuration filter. The metrics configuration only includes objects that meet the filter's criteria. A filter must be a prefix, an object tag, an access point ARN, or a conjunction (MetricsAndOperator). For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketMetricsConfiguration.html">PutBucketMetricsConfiguration</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum MetricsFilter {
    /// <p>The access point ARN used when evaluating a metrics filter.</p>
    AccessPointArn(std::string::String),
    /// <p>A conjunction (logical AND) of predicates, which is used in evaluating a metrics filter. The operator must have at least two predicates, and an object must match all of the predicates in order for the filter to apply.</p>
    And(crate::model::MetricsAndOperator),
    /// <p>The prefix used when evaluating a metrics filter.</p>
    Prefix(std::string::String),
    /// <p>The tag used when evaluating a metrics filter.</p>
    Tag(crate::model::Tag),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl MetricsFilter {
    /// Tries to convert the enum instance into [`AccessPointArn`](crate::model::MetricsFilter::AccessPointArn), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_access_point_arn(&self) -> std::result::Result<&std::string::String, &Self> {
        if let MetricsFilter::AccessPointArn(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`AccessPointArn`](crate::model::MetricsFilter::AccessPointArn).
    pub fn is_access_point_arn(&self) -> bool {
        self.as_access_point_arn().is_ok()
    }
    /// Tries to convert the enum instance into [`And`](crate::model::MetricsFilter::And), extracting the inner [`MetricsAndOperator`](crate::model::MetricsAndOperator).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_and(&self) -> std::result::Result<&crate::model::MetricsAndOperator, &Self> {
        if let MetricsFilter::And(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`And`](crate::model::MetricsFilter::And).
    pub fn is_and(&self) -> bool {
        self.as_and().is_ok()
    }
    /// Tries to convert the enum instance into [`Prefix`](crate::model::MetricsFilter::Prefix), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_prefix(&self) -> std::result::Result<&std::string::String, &Self> {
        if let MetricsFilter::Prefix(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Prefix`](crate::model::MetricsFilter::Prefix).
    pub fn is_prefix(&self) -> bool {
        self.as_prefix().is_ok()
    }
    /// Tries to convert the enum instance into [`Tag`](crate::model::MetricsFilter::Tag), extracting the inner [`Tag`](crate::model::Tag).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_tag(&self) -> std::result::Result<&crate::model::Tag, &Self> {
        if let MetricsFilter::Tag(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Tag`](crate::model::MetricsFilter::Tag).
    pub fn is_tag(&self) -> bool {
        self.as_tag().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>A conjunction (logical AND) of predicates, which is used in evaluating a metrics filter. The operator must have at least two predicates, and an object must match all of the predicates in order for the filter to apply.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricsAndOperator {
    /// <p>The prefix used when evaluating an AND predicate.</p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>The list of tags used when evaluating an AND predicate.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The access point ARN used when evaluating an AND predicate.</p>
    pub access_point_arn: std::option::Option<std::string::String>,
}
impl MetricsAndOperator {
    /// <p>The prefix used when evaluating an AND predicate.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>The list of tags used when evaluating an AND predicate.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The access point ARN used when evaluating an AND predicate.</p>
    pub fn access_point_arn(&self) -> std::option::Option<&str> {
        self.access_point_arn.as_deref()
    }
}
impl std::fmt::Debug for MetricsAndOperator {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricsAndOperator");
        formatter.field("prefix", &self.prefix);
        formatter.field("tags", &self.tags);
        formatter.field("access_point_arn", &self.access_point_arn);
        formatter.finish()
    }
}
/// See [`MetricsAndOperator`](crate::model::MetricsAndOperator)
pub mod metrics_and_operator {
    /// A builder for [`MetricsAndOperator`](crate::model::MetricsAndOperator)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) access_point_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The prefix used when evaluating an AND predicate.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>The prefix used when evaluating an AND predicate.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags used when evaluating an AND predicate.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags used when evaluating an AND predicate.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The access point ARN used when evaluating an AND predicate.</p>
        pub fn access_point_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_point_arn = Some(input.into());
            self
        }
        /// <p>The access point ARN used when evaluating an AND predicate.</p>
        pub fn set_access_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_point_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricsAndOperator`](crate::model::MetricsAndOperator)
        pub fn build(self) -> crate::model::MetricsAndOperator {
            crate::model::MetricsAndOperator {
                prefix: self.prefix,
                tags: self.tags,
                access_point_arn: self.access_point_arn,
            }
        }
    }
}
impl MetricsAndOperator {
    /// Creates a new builder-style object to manufacture [`MetricsAndOperator`](crate::model::MetricsAndOperator)
    pub fn builder() -> crate::model::metrics_and_operator::Builder {
        crate::model::metrics_and_operator::Builder::default()
    }
}

/// <p>Container for logging status information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BucketLoggingStatus {
    /// <p>Describes where logs are stored and the prefix that Amazon S3 assigns to all log object keys for a bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlogging.html">PUT Bucket logging</a> in the <i>Amazon S3 API Reference</i>.</p>
    pub logging_enabled: std::option::Option<crate::model::LoggingEnabled>,
}
impl BucketLoggingStatus {
    /// <p>Describes where logs are stored and the prefix that Amazon S3 assigns to all log object keys for a bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlogging.html">PUT Bucket logging</a> in the <i>Amazon S3 API Reference</i>.</p>
    pub fn logging_enabled(&self) -> std::option::Option<&crate::model::LoggingEnabled> {
        self.logging_enabled.as_ref()
    }
}
impl std::fmt::Debug for BucketLoggingStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BucketLoggingStatus");
        formatter.field("logging_enabled", &self.logging_enabled);
        formatter.finish()
    }
}
/// See [`BucketLoggingStatus`](crate::model::BucketLoggingStatus)
pub mod bucket_logging_status {
    /// A builder for [`BucketLoggingStatus`](crate::model::BucketLoggingStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) logging_enabled: std::option::Option<crate::model::LoggingEnabled>,
    }
    impl Builder {
        /// <p>Describes where logs are stored and the prefix that Amazon S3 assigns to all log object keys for a bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlogging.html">PUT Bucket logging</a> in the <i>Amazon S3 API Reference</i>.</p>
        pub fn logging_enabled(mut self, input: crate::model::LoggingEnabled) -> Self {
            self.logging_enabled = Some(input);
            self
        }
        /// <p>Describes where logs are stored and the prefix that Amazon S3 assigns to all log object keys for a bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlogging.html">PUT Bucket logging</a> in the <i>Amazon S3 API Reference</i>.</p>
        pub fn set_logging_enabled(
            mut self,
            input: std::option::Option<crate::model::LoggingEnabled>,
        ) -> Self {
            self.logging_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`BucketLoggingStatus`](crate::model::BucketLoggingStatus)
        pub fn build(self) -> crate::model::BucketLoggingStatus {
            crate::model::BucketLoggingStatus {
                logging_enabled: self.logging_enabled,
            }
        }
    }
}
impl BucketLoggingStatus {
    /// Creates a new builder-style object to manufacture [`BucketLoggingStatus`](crate::model::BucketLoggingStatus)
    pub fn builder() -> crate::model::bucket_logging_status::Builder {
        crate::model::bucket_logging_status::Builder::default()
    }
}

/// <p>Describes where logs are stored and the prefix that Amazon S3 assigns to all log object keys for a bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlogging.html">PUT Bucket logging</a> in the <i>Amazon S3 API Reference</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoggingEnabled {
    /// <p>Specifies the bucket where you want Amazon S3 to store server access logs. You can have your logs delivered to any bucket that you own, including the same bucket that is being logged. You can also configure multiple buckets to deliver their logs to the same target bucket. In this case, you should choose a different <code>TargetPrefix</code> for each source bucket so that the delivered log files can be distinguished by key.</p>
    pub target_bucket: std::option::Option<std::string::String>,
    /// <p>Container for granting information.</p>
    /// <p>Buckets that use the bucket owner enforced setting for Object Ownership don't support target grants. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/enable-server-access-logging.html#grant-log-delivery-permissions-general">Permissions for server access log delivery</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub target_grants: std::option::Option<std::vec::Vec<crate::model::TargetGrant>>,
    /// <p>A prefix for all log object keys. If you store log files from multiple Amazon S3 buckets in a single bucket, you can use a prefix to distinguish which log files came from which bucket.</p>
    pub target_prefix: std::option::Option<std::string::String>,
}
impl LoggingEnabled {
    /// <p>Specifies the bucket where you want Amazon S3 to store server access logs. You can have your logs delivered to any bucket that you own, including the same bucket that is being logged. You can also configure multiple buckets to deliver their logs to the same target bucket. In this case, you should choose a different <code>TargetPrefix</code> for each source bucket so that the delivered log files can be distinguished by key.</p>
    pub fn target_bucket(&self) -> std::option::Option<&str> {
        self.target_bucket.as_deref()
    }
    /// <p>Container for granting information.</p>
    /// <p>Buckets that use the bucket owner enforced setting for Object Ownership don't support target grants. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/enable-server-access-logging.html#grant-log-delivery-permissions-general">Permissions for server access log delivery</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn target_grants(&self) -> std::option::Option<&[crate::model::TargetGrant]> {
        self.target_grants.as_deref()
    }
    /// <p>A prefix for all log object keys. If you store log files from multiple Amazon S3 buckets in a single bucket, you can use a prefix to distinguish which log files came from which bucket.</p>
    pub fn target_prefix(&self) -> std::option::Option<&str> {
        self.target_prefix.as_deref()
    }
}
impl std::fmt::Debug for LoggingEnabled {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoggingEnabled");
        formatter.field("target_bucket", &self.target_bucket);
        formatter.field("target_grants", &self.target_grants);
        formatter.field("target_prefix", &self.target_prefix);
        formatter.finish()
    }
}
/// See [`LoggingEnabled`](crate::model::LoggingEnabled)
pub mod logging_enabled {
    /// A builder for [`LoggingEnabled`](crate::model::LoggingEnabled)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_bucket: std::option::Option<std::string::String>,
        pub(crate) target_grants: std::option::Option<std::vec::Vec<crate::model::TargetGrant>>,
        pub(crate) target_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the bucket where you want Amazon S3 to store server access logs. You can have your logs delivered to any bucket that you own, including the same bucket that is being logged. You can also configure multiple buckets to deliver their logs to the same target bucket. In this case, you should choose a different <code>TargetPrefix</code> for each source bucket so that the delivered log files can be distinguished by key.</p>
        pub fn target_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_bucket = Some(input.into());
            self
        }
        /// <p>Specifies the bucket where you want Amazon S3 to store server access logs. You can have your logs delivered to any bucket that you own, including the same bucket that is being logged. You can also configure multiple buckets to deliver their logs to the same target bucket. In this case, you should choose a different <code>TargetPrefix</code> for each source bucket so that the delivered log files can be distinguished by key.</p>
        pub fn set_target_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_bucket = input;
            self
        }
        /// Appends an item to `target_grants`.
        ///
        /// To override the contents of this collection use [`set_target_grants`](Self::set_target_grants).
        ///
        /// <p>Container for granting information.</p>
        /// <p>Buckets that use the bucket owner enforced setting for Object Ownership don't support target grants. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/enable-server-access-logging.html#grant-log-delivery-permissions-general">Permissions for server access log delivery</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn target_grants(mut self, input: crate::model::TargetGrant) -> Self {
            let mut v = self.target_grants.unwrap_or_default();
            v.push(input);
            self.target_grants = Some(v);
            self
        }
        /// <p>Container for granting information.</p>
        /// <p>Buckets that use the bucket owner enforced setting for Object Ownership don't support target grants. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/enable-server-access-logging.html#grant-log-delivery-permissions-general">Permissions for server access log delivery</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_target_grants(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetGrant>>,
        ) -> Self {
            self.target_grants = input;
            self
        }
        /// <p>A prefix for all log object keys. If you store log files from multiple Amazon S3 buckets in a single bucket, you can use a prefix to distinguish which log files came from which bucket.</p>
        pub fn target_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_prefix = Some(input.into());
            self
        }
        /// <p>A prefix for all log object keys. If you store log files from multiple Amazon S3 buckets in a single bucket, you can use a prefix to distinguish which log files came from which bucket.</p>
        pub fn set_target_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`LoggingEnabled`](crate::model::LoggingEnabled)
        pub fn build(self) -> crate::model::LoggingEnabled {
            crate::model::LoggingEnabled {
                target_bucket: self.target_bucket,
                target_grants: self.target_grants,
                target_prefix: self.target_prefix,
            }
        }
    }
}
impl LoggingEnabled {
    /// Creates a new builder-style object to manufacture [`LoggingEnabled`](crate::model::LoggingEnabled)
    pub fn builder() -> crate::model::logging_enabled::Builder {
        crate::model::logging_enabled::Builder::default()
    }
}

/// <p>Container for granting information.</p>
/// <p>Buckets that use the bucket owner enforced setting for Object Ownership don't support target grants. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/enable-server-access-logging.html#grant-log-delivery-permissions-general">Permissions server access log delivery</a> in the <i>Amazon S3 User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TargetGrant {
    /// <p>Container for the person being granted permissions.</p>
    pub grantee: std::option::Option<crate::model::Grantee>,
    /// <p>Logging permissions assigned to the grantee for the bucket.</p>
    pub permission: std::option::Option<crate::model::BucketLogsPermission>,
}
impl TargetGrant {
    /// <p>Container for the person being granted permissions.</p>
    pub fn grantee(&self) -> std::option::Option<&crate::model::Grantee> {
        self.grantee.as_ref()
    }
    /// <p>Logging permissions assigned to the grantee for the bucket.</p>
    pub fn permission(&self) -> std::option::Option<&crate::model::BucketLogsPermission> {
        self.permission.as_ref()
    }
}
impl std::fmt::Debug for TargetGrant {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TargetGrant");
        formatter.field("grantee", &self.grantee);
        formatter.field("permission", &self.permission);
        formatter.finish()
    }
}
/// See [`TargetGrant`](crate::model::TargetGrant)
pub mod target_grant {
    /// A builder for [`TargetGrant`](crate::model::TargetGrant)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) grantee: std::option::Option<crate::model::Grantee>,
        pub(crate) permission: std::option::Option<crate::model::BucketLogsPermission>,
    }
    impl Builder {
        /// <p>Container for the person being granted permissions.</p>
        pub fn grantee(mut self, input: crate::model::Grantee) -> Self {
            self.grantee = Some(input);
            self
        }
        /// <p>Container for the person being granted permissions.</p>
        pub fn set_grantee(mut self, input: std::option::Option<crate::model::Grantee>) -> Self {
            self.grantee = input;
            self
        }
        /// <p>Logging permissions assigned to the grantee for the bucket.</p>
        pub fn permission(mut self, input: crate::model::BucketLogsPermission) -> Self {
            self.permission = Some(input);
            self
        }
        /// <p>Logging permissions assigned to the grantee for the bucket.</p>
        pub fn set_permission(
            mut self,
            input: std::option::Option<crate::model::BucketLogsPermission>,
        ) -> Self {
            self.permission = input;
            self
        }
        /// Consumes the builder and constructs a [`TargetGrant`](crate::model::TargetGrant)
        pub fn build(self) -> crate::model::TargetGrant {
            crate::model::TargetGrant {
                grantee: self.grantee,
                permission: self.permission,
            }
        }
    }
}
impl TargetGrant {
    /// Creates a new builder-style object to manufacture [`TargetGrant`](crate::model::TargetGrant)
    pub fn builder() -> crate::model::target_grant::Builder {
        crate::model::target_grant::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BucketLogsPermission {
    #[allow(missing_docs)] // documentation missing in model
    FullControl,
    #[allow(missing_docs)] // documentation missing in model
    Read,
    #[allow(missing_docs)] // documentation missing in model
    Write,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BucketLogsPermission {
    fn from(s: &str) -> Self {
        match s {
            "FULL_CONTROL" => BucketLogsPermission::FullControl,
            "READ" => BucketLogsPermission::Read,
            "WRITE" => BucketLogsPermission::Write,
            other => BucketLogsPermission::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BucketLogsPermission {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BucketLogsPermission::from(s))
    }
}
impl BucketLogsPermission {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BucketLogsPermission::FullControl => "FULL_CONTROL",
            BucketLogsPermission::Read => "READ",
            BucketLogsPermission::Write => "WRITE",
            BucketLogsPermission::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FULL_CONTROL", "READ", "WRITE"]
    }
}
impl AsRef<str> for BucketLogsPermission {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the lifecycle configuration for objects in an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html">Object Lifecycle Management</a> in the <i>Amazon S3 User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BucketLifecycleConfiguration {
    /// <p>A lifecycle rule for individual objects in an Amazon S3 bucket.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::LifecycleRule>>,
}
impl BucketLifecycleConfiguration {
    /// <p>A lifecycle rule for individual objects in an Amazon S3 bucket.</p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::LifecycleRule]> {
        self.rules.as_deref()
    }
}
impl std::fmt::Debug for BucketLifecycleConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BucketLifecycleConfiguration");
        formatter.field("rules", &self.rules);
        formatter.finish()
    }
}
/// See [`BucketLifecycleConfiguration`](crate::model::BucketLifecycleConfiguration)
pub mod bucket_lifecycle_configuration {
    /// A builder for [`BucketLifecycleConfiguration`](crate::model::BucketLifecycleConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::LifecycleRule>>,
    }
    impl Builder {
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>A lifecycle rule for individual objects in an Amazon S3 bucket.</p>
        pub fn rules(mut self, input: crate::model::LifecycleRule) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input);
            self.rules = Some(v);
            self
        }
        /// <p>A lifecycle rule for individual objects in an Amazon S3 bucket.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LifecycleRule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// Consumes the builder and constructs a [`BucketLifecycleConfiguration`](crate::model::BucketLifecycleConfiguration)
        pub fn build(self) -> crate::model::BucketLifecycleConfiguration {
            crate::model::BucketLifecycleConfiguration { rules: self.rules }
        }
    }
}
impl BucketLifecycleConfiguration {
    /// Creates a new builder-style object to manufacture [`BucketLifecycleConfiguration`](crate::model::BucketLifecycleConfiguration)
    pub fn builder() -> crate::model::bucket_lifecycle_configuration::Builder {
        crate::model::bucket_lifecycle_configuration::Builder::default()
    }
}

/// <p>A lifecycle rule for individual objects in an Amazon S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifecycleRule {
    /// <p>Specifies the expiration for the lifecycle of the object in the form of date, days and, whether the object has a delete marker.</p>
    pub expiration: std::option::Option<crate::model::LifecycleExpiration>,
    /// <p>Unique identifier for the rule. The value cannot be longer than 255 characters.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Prefix identifying one or more objects to which the rule applies. This is no longer used; use <code>Filter</code> instead.</p> <important>
    /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
    /// </important>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>The <code>Filter</code> is used to identify objects that a Lifecycle Rule applies to. A <code>Filter</code> must have exactly one of <code>Prefix</code>, <code>Tag</code>, or <code>And</code> specified. <code>Filter</code> is required if the <code>LifecycleRule</code> does not containt a <code>Prefix</code> element.</p>
    pub filter: std::option::Option<crate::model::LifecycleRuleFilter>,
    /// <p>If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.</p>
    pub status: std::option::Option<crate::model::ExpirationStatus>,
    /// <p>Specifies when an Amazon S3 object transitions to a specified storage class.</p>
    pub transitions: std::option::Option<std::vec::Vec<crate::model::Transition>>,
    /// <p> Specifies the transition rule for the lifecycle rule that describes when noncurrent objects transition to a specific storage class. If your bucket is versioning-enabled (or versioning is suspended), you can set this action to request that Amazon S3 transition noncurrent object versions to a specific storage class at a set period in the object's lifetime. </p>
    pub noncurrent_version_transitions:
        std::option::Option<std::vec::Vec<crate::model::NoncurrentVersionTransition>>,
    /// <p>Specifies when noncurrent object versions expire. Upon expiration, Amazon S3 permanently deletes the noncurrent object versions. You set this lifecycle configuration action on a bucket that has versioning enabled (or suspended) to request that Amazon S3 delete noncurrent object versions at a specific period in the object's lifetime.</p>
    pub noncurrent_version_expiration:
        std::option::Option<crate::model::NoncurrentVersionExpiration>,
    /// <p>Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config"> Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Policy</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub abort_incomplete_multipart_upload:
        std::option::Option<crate::model::AbortIncompleteMultipartUpload>,
}
impl LifecycleRule {
    /// <p>Specifies the expiration for the lifecycle of the object in the form of date, days and, whether the object has a delete marker.</p>
    pub fn expiration(&self) -> std::option::Option<&crate::model::LifecycleExpiration> {
        self.expiration.as_ref()
    }
    /// <p>Unique identifier for the rule. The value cannot be longer than 255 characters.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Prefix identifying one or more objects to which the rule applies. This is no longer used; use <code>Filter</code> instead.</p> <important>
    /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
    /// </important>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>The <code>Filter</code> is used to identify objects that a Lifecycle Rule applies to. A <code>Filter</code> must have exactly one of <code>Prefix</code>, <code>Tag</code>, or <code>And</code> specified. <code>Filter</code> is required if the <code>LifecycleRule</code> does not containt a <code>Prefix</code> element.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::LifecycleRuleFilter> {
        self.filter.as_ref()
    }
    /// <p>If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ExpirationStatus> {
        self.status.as_ref()
    }
    /// <p>Specifies when an Amazon S3 object transitions to a specified storage class.</p>
    pub fn transitions(&self) -> std::option::Option<&[crate::model::Transition]> {
        self.transitions.as_deref()
    }
    /// <p> Specifies the transition rule for the lifecycle rule that describes when noncurrent objects transition to a specific storage class. If your bucket is versioning-enabled (or versioning is suspended), you can set this action to request that Amazon S3 transition noncurrent object versions to a specific storage class at a set period in the object's lifetime. </p>
    pub fn noncurrent_version_transitions(
        &self,
    ) -> std::option::Option<&[crate::model::NoncurrentVersionTransition]> {
        self.noncurrent_version_transitions.as_deref()
    }
    /// <p>Specifies when noncurrent object versions expire. Upon expiration, Amazon S3 permanently deletes the noncurrent object versions. You set this lifecycle configuration action on a bucket that has versioning enabled (or suspended) to request that Amazon S3 delete noncurrent object versions at a specific period in the object's lifetime.</p>
    pub fn noncurrent_version_expiration(
        &self,
    ) -> std::option::Option<&crate::model::NoncurrentVersionExpiration> {
        self.noncurrent_version_expiration.as_ref()
    }
    /// <p>Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config"> Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Policy</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn abort_incomplete_multipart_upload(
        &self,
    ) -> std::option::Option<&crate::model::AbortIncompleteMultipartUpload> {
        self.abort_incomplete_multipart_upload.as_ref()
    }
}
impl std::fmt::Debug for LifecycleRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifecycleRule");
        formatter.field("expiration", &self.expiration);
        formatter.field("id", &self.id);
        formatter.field("prefix", &self.prefix);
        formatter.field("filter", &self.filter);
        formatter.field("status", &self.status);
        formatter.field("transitions", &self.transitions);
        formatter.field(
            "noncurrent_version_transitions",
            &self.noncurrent_version_transitions,
        );
        formatter.field(
            "noncurrent_version_expiration",
            &self.noncurrent_version_expiration,
        );
        formatter.field(
            "abort_incomplete_multipart_upload",
            &self.abort_incomplete_multipart_upload,
        );
        formatter.finish()
    }
}
/// See [`LifecycleRule`](crate::model::LifecycleRule)
pub mod lifecycle_rule {
    /// A builder for [`LifecycleRule`](crate::model::LifecycleRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) expiration: std::option::Option<crate::model::LifecycleExpiration>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) filter: std::option::Option<crate::model::LifecycleRuleFilter>,
        pub(crate) status: std::option::Option<crate::model::ExpirationStatus>,
        pub(crate) transitions: std::option::Option<std::vec::Vec<crate::model::Transition>>,
        pub(crate) noncurrent_version_transitions:
            std::option::Option<std::vec::Vec<crate::model::NoncurrentVersionTransition>>,
        pub(crate) noncurrent_version_expiration:
            std::option::Option<crate::model::NoncurrentVersionExpiration>,
        pub(crate) abort_incomplete_multipart_upload:
            std::option::Option<crate::model::AbortIncompleteMultipartUpload>,
    }
    impl Builder {
        /// <p>Specifies the expiration for the lifecycle of the object in the form of date, days and, whether the object has a delete marker.</p>
        pub fn expiration(mut self, input: crate::model::LifecycleExpiration) -> Self {
            self.expiration = Some(input);
            self
        }
        /// <p>Specifies the expiration for the lifecycle of the object in the form of date, days and, whether the object has a delete marker.</p>
        pub fn set_expiration(
            mut self,
            input: std::option::Option<crate::model::LifecycleExpiration>,
        ) -> Self {
            self.expiration = input;
            self
        }
        /// <p>Unique identifier for the rule. The value cannot be longer than 255 characters.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Unique identifier for the rule. The value cannot be longer than 255 characters.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Prefix identifying one or more objects to which the rule applies. This is no longer used; use <code>Filter</code> instead.</p> <important>
        /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
        /// </important>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>Prefix identifying one or more objects to which the rule applies. This is no longer used; use <code>Filter</code> instead.</p> <important>
        /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
        /// </important>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>The <code>Filter</code> is used to identify objects that a Lifecycle Rule applies to. A <code>Filter</code> must have exactly one of <code>Prefix</code>, <code>Tag</code>, or <code>And</code> specified. <code>Filter</code> is required if the <code>LifecycleRule</code> does not containt a <code>Prefix</code> element.</p>
        pub fn filter(mut self, input: crate::model::LifecycleRuleFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>The <code>Filter</code> is used to identify objects that a Lifecycle Rule applies to. A <code>Filter</code> must have exactly one of <code>Prefix</code>, <code>Tag</code>, or <code>And</code> specified. <code>Filter</code> is required if the <code>LifecycleRule</code> does not containt a <code>Prefix</code> element.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::LifecycleRuleFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.</p>
        pub fn status(mut self, input: crate::model::ExpirationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ExpirationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `transitions`.
        ///
        /// To override the contents of this collection use [`set_transitions`](Self::set_transitions).
        ///
        /// <p>Specifies when an Amazon S3 object transitions to a specified storage class.</p>
        pub fn transitions(mut self, input: crate::model::Transition) -> Self {
            let mut v = self.transitions.unwrap_or_default();
            v.push(input);
            self.transitions = Some(v);
            self
        }
        /// <p>Specifies when an Amazon S3 object transitions to a specified storage class.</p>
        pub fn set_transitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Transition>>,
        ) -> Self {
            self.transitions = input;
            self
        }
        /// Appends an item to `noncurrent_version_transitions`.
        ///
        /// To override the contents of this collection use [`set_noncurrent_version_transitions`](Self::set_noncurrent_version_transitions).
        ///
        /// <p> Specifies the transition rule for the lifecycle rule that describes when noncurrent objects transition to a specific storage class. If your bucket is versioning-enabled (or versioning is suspended), you can set this action to request that Amazon S3 transition noncurrent object versions to a specific storage class at a set period in the object's lifetime. </p>
        pub fn noncurrent_version_transitions(
            mut self,
            input: crate::model::NoncurrentVersionTransition,
        ) -> Self {
            let mut v = self.noncurrent_version_transitions.unwrap_or_default();
            v.push(input);
            self.noncurrent_version_transitions = Some(v);
            self
        }
        /// <p> Specifies the transition rule for the lifecycle rule that describes when noncurrent objects transition to a specific storage class. If your bucket is versioning-enabled (or versioning is suspended), you can set this action to request that Amazon S3 transition noncurrent object versions to a specific storage class at a set period in the object's lifetime. </p>
        pub fn set_noncurrent_version_transitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NoncurrentVersionTransition>>,
        ) -> Self {
            self.noncurrent_version_transitions = input;
            self
        }
        /// <p>Specifies when noncurrent object versions expire. Upon expiration, Amazon S3 permanently deletes the noncurrent object versions. You set this lifecycle configuration action on a bucket that has versioning enabled (or suspended) to request that Amazon S3 delete noncurrent object versions at a specific period in the object's lifetime.</p>
        pub fn noncurrent_version_expiration(
            mut self,
            input: crate::model::NoncurrentVersionExpiration,
        ) -> Self {
            self.noncurrent_version_expiration = Some(input);
            self
        }
        /// <p>Specifies when noncurrent object versions expire. Upon expiration, Amazon S3 permanently deletes the noncurrent object versions. You set this lifecycle configuration action on a bucket that has versioning enabled (or suspended) to request that Amazon S3 delete noncurrent object versions at a specific period in the object's lifetime.</p>
        pub fn set_noncurrent_version_expiration(
            mut self,
            input: std::option::Option<crate::model::NoncurrentVersionExpiration>,
        ) -> Self {
            self.noncurrent_version_expiration = input;
            self
        }
        /// <p>Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config"> Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Policy</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn abort_incomplete_multipart_upload(
            mut self,
            input: crate::model::AbortIncompleteMultipartUpload,
        ) -> Self {
            self.abort_incomplete_multipart_upload = Some(input);
            self
        }
        /// <p>Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config"> Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Policy</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_abort_incomplete_multipart_upload(
            mut self,
            input: std::option::Option<crate::model::AbortIncompleteMultipartUpload>,
        ) -> Self {
            self.abort_incomplete_multipart_upload = input;
            self
        }
        /// Consumes the builder and constructs a [`LifecycleRule`](crate::model::LifecycleRule)
        pub fn build(self) -> crate::model::LifecycleRule {
            crate::model::LifecycleRule {
                expiration: self.expiration,
                id: self.id,
                prefix: self.prefix,
                filter: self.filter,
                status: self.status,
                transitions: self.transitions,
                noncurrent_version_transitions: self.noncurrent_version_transitions,
                noncurrent_version_expiration: self.noncurrent_version_expiration,
                abort_incomplete_multipart_upload: self.abort_incomplete_multipart_upload,
            }
        }
    }
}
impl LifecycleRule {
    /// Creates a new builder-style object to manufacture [`LifecycleRule`](crate::model::LifecycleRule)
    pub fn builder() -> crate::model::lifecycle_rule::Builder {
        crate::model::lifecycle_rule::Builder::default()
    }
}

/// <p>Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config"> Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Policy</a> in the <i>Amazon S3 User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AbortIncompleteMultipartUpload {
    /// <p>Specifies the number of days after which Amazon S3 aborts an incomplete multipart upload.</p>
    pub days_after_initiation: i32,
}
impl AbortIncompleteMultipartUpload {
    /// <p>Specifies the number of days after which Amazon S3 aborts an incomplete multipart upload.</p>
    pub fn days_after_initiation(&self) -> i32 {
        self.days_after_initiation
    }
}
impl std::fmt::Debug for AbortIncompleteMultipartUpload {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AbortIncompleteMultipartUpload");
        formatter.field("days_after_initiation", &self.days_after_initiation);
        formatter.finish()
    }
}
/// See [`AbortIncompleteMultipartUpload`](crate::model::AbortIncompleteMultipartUpload)
pub mod abort_incomplete_multipart_upload {
    /// A builder for [`AbortIncompleteMultipartUpload`](crate::model::AbortIncompleteMultipartUpload)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) days_after_initiation: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specifies the number of days after which Amazon S3 aborts an incomplete multipart upload.</p>
        pub fn days_after_initiation(mut self, input: i32) -> Self {
            self.days_after_initiation = Some(input);
            self
        }
        /// <p>Specifies the number of days after which Amazon S3 aborts an incomplete multipart upload.</p>
        pub fn set_days_after_initiation(mut self, input: std::option::Option<i32>) -> Self {
            self.days_after_initiation = input;
            self
        }
        /// Consumes the builder and constructs a [`AbortIncompleteMultipartUpload`](crate::model::AbortIncompleteMultipartUpload)
        pub fn build(self) -> crate::model::AbortIncompleteMultipartUpload {
            crate::model::AbortIncompleteMultipartUpload {
                days_after_initiation: self.days_after_initiation.unwrap_or_default(),
            }
        }
    }
}
impl AbortIncompleteMultipartUpload {
    /// Creates a new builder-style object to manufacture [`AbortIncompleteMultipartUpload`](crate::model::AbortIncompleteMultipartUpload)
    pub fn builder() -> crate::model::abort_incomplete_multipart_upload::Builder {
        crate::model::abort_incomplete_multipart_upload::Builder::default()
    }
}

/// <p>Specifies when noncurrent object versions expire. Upon expiration, Amazon S3 permanently deletes the noncurrent object versions. You set this lifecycle configuration action on a bucket that has versioning enabled (or suspended) to request that Amazon S3 delete noncurrent object versions at a specific period in the object's lifetime.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoncurrentVersionExpiration {
    /// <p>Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action. For information about the noncurrent days calculations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations">How Amazon S3 Calculates When an Object Became Noncurrent</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub noncurrent_days: i32,
    /// <p>Specifies how many noncurrent versions Amazon S3 will retain. If there are this many more recent noncurrent versions, Amazon S3 will take the associated action. For more information about noncurrent versions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/intro-lifecycle-rules.html">Lifecycle configuration elements</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub newer_noncurrent_versions: i32,
}
impl NoncurrentVersionExpiration {
    /// <p>Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action. For information about the noncurrent days calculations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations">How Amazon S3 Calculates When an Object Became Noncurrent</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn noncurrent_days(&self) -> i32 {
        self.noncurrent_days
    }
    /// <p>Specifies how many noncurrent versions Amazon S3 will retain. If there are this many more recent noncurrent versions, Amazon S3 will take the associated action. For more information about noncurrent versions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/intro-lifecycle-rules.html">Lifecycle configuration elements</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn newer_noncurrent_versions(&self) -> i32 {
        self.newer_noncurrent_versions
    }
}
impl std::fmt::Debug for NoncurrentVersionExpiration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoncurrentVersionExpiration");
        formatter.field("noncurrent_days", &self.noncurrent_days);
        formatter.field("newer_noncurrent_versions", &self.newer_noncurrent_versions);
        formatter.finish()
    }
}
/// See [`NoncurrentVersionExpiration`](crate::model::NoncurrentVersionExpiration)
pub mod noncurrent_version_expiration {
    /// A builder for [`NoncurrentVersionExpiration`](crate::model::NoncurrentVersionExpiration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) noncurrent_days: std::option::Option<i32>,
        pub(crate) newer_noncurrent_versions: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action. For information about the noncurrent days calculations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations">How Amazon S3 Calculates When an Object Became Noncurrent</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn noncurrent_days(mut self, input: i32) -> Self {
            self.noncurrent_days = Some(input);
            self
        }
        /// <p>Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action. For information about the noncurrent days calculations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations">How Amazon S3 Calculates When an Object Became Noncurrent</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_noncurrent_days(mut self, input: std::option::Option<i32>) -> Self {
            self.noncurrent_days = input;
            self
        }
        /// <p>Specifies how many noncurrent versions Amazon S3 will retain. If there are this many more recent noncurrent versions, Amazon S3 will take the associated action. For more information about noncurrent versions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/intro-lifecycle-rules.html">Lifecycle configuration elements</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn newer_noncurrent_versions(mut self, input: i32) -> Self {
            self.newer_noncurrent_versions = Some(input);
            self
        }
        /// <p>Specifies how many noncurrent versions Amazon S3 will retain. If there are this many more recent noncurrent versions, Amazon S3 will take the associated action. For more information about noncurrent versions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/intro-lifecycle-rules.html">Lifecycle configuration elements</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_newer_noncurrent_versions(mut self, input: std::option::Option<i32>) -> Self {
            self.newer_noncurrent_versions = input;
            self
        }
        /// Consumes the builder and constructs a [`NoncurrentVersionExpiration`](crate::model::NoncurrentVersionExpiration)
        pub fn build(self) -> crate::model::NoncurrentVersionExpiration {
            crate::model::NoncurrentVersionExpiration {
                noncurrent_days: self.noncurrent_days.unwrap_or_default(),
                newer_noncurrent_versions: self.newer_noncurrent_versions.unwrap_or_default(),
            }
        }
    }
}
impl NoncurrentVersionExpiration {
    /// Creates a new builder-style object to manufacture [`NoncurrentVersionExpiration`](crate::model::NoncurrentVersionExpiration)
    pub fn builder() -> crate::model::noncurrent_version_expiration::Builder {
        crate::model::noncurrent_version_expiration::Builder::default()
    }
}

/// <p>Container for the transition rule that describes when noncurrent objects transition to the <code>STANDARD_IA</code>, <code>ONEZONE_IA</code>, <code>INTELLIGENT_TIERING</code>, <code>GLACIER_IR</code>, <code>GLACIER</code>, or <code>DEEP_ARCHIVE</code> storage class. If your bucket is versioning-enabled (or versioning is suspended), you can set this action to request that Amazon S3 transition noncurrent object versions to the <code>STANDARD_IA</code>, <code>ONEZONE_IA</code>, <code>INTELLIGENT_TIERING</code>, <code>GLACIER_IR</code>, <code>GLACIER</code>, or <code>DEEP_ARCHIVE</code> storage class at a specific period in the object's lifetime.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoncurrentVersionTransition {
    /// <p>Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action. For information about the noncurrent days calculations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations">How Amazon S3 Calculates How Long an Object Has Been Noncurrent</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub noncurrent_days: i32,
    /// <p>The class of storage used to store the object.</p>
    pub storage_class: std::option::Option<crate::model::TransitionStorageClass>,
    /// <p>Specifies how many noncurrent versions Amazon S3 will retain. If there are this many more recent noncurrent versions, Amazon S3 will take the associated action. For more information about noncurrent versions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/intro-lifecycle-rules.html">Lifecycle configuration elements</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub newer_noncurrent_versions: i32,
}
impl NoncurrentVersionTransition {
    /// <p>Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action. For information about the noncurrent days calculations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations">How Amazon S3 Calculates How Long an Object Has Been Noncurrent</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn noncurrent_days(&self) -> i32 {
        self.noncurrent_days
    }
    /// <p>The class of storage used to store the object.</p>
    pub fn storage_class(&self) -> std::option::Option<&crate::model::TransitionStorageClass> {
        self.storage_class.as_ref()
    }
    /// <p>Specifies how many noncurrent versions Amazon S3 will retain. If there are this many more recent noncurrent versions, Amazon S3 will take the associated action. For more information about noncurrent versions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/intro-lifecycle-rules.html">Lifecycle configuration elements</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn newer_noncurrent_versions(&self) -> i32 {
        self.newer_noncurrent_versions
    }
}
impl std::fmt::Debug for NoncurrentVersionTransition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoncurrentVersionTransition");
        formatter.field("noncurrent_days", &self.noncurrent_days);
        formatter.field("storage_class", &self.storage_class);
        formatter.field("newer_noncurrent_versions", &self.newer_noncurrent_versions);
        formatter.finish()
    }
}
/// See [`NoncurrentVersionTransition`](crate::model::NoncurrentVersionTransition)
pub mod noncurrent_version_transition {
    /// A builder for [`NoncurrentVersionTransition`](crate::model::NoncurrentVersionTransition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) noncurrent_days: std::option::Option<i32>,
        pub(crate) storage_class: std::option::Option<crate::model::TransitionStorageClass>,
        pub(crate) newer_noncurrent_versions: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action. For information about the noncurrent days calculations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations">How Amazon S3 Calculates How Long an Object Has Been Noncurrent</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn noncurrent_days(mut self, input: i32) -> Self {
            self.noncurrent_days = Some(input);
            self
        }
        /// <p>Specifies the number of days an object is noncurrent before Amazon S3 can perform the associated action. For information about the noncurrent days calculations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations">How Amazon S3 Calculates How Long an Object Has Been Noncurrent</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_noncurrent_days(mut self, input: std::option::Option<i32>) -> Self {
            self.noncurrent_days = input;
            self
        }
        /// <p>The class of storage used to store the object.</p>
        pub fn storage_class(mut self, input: crate::model::TransitionStorageClass) -> Self {
            self.storage_class = Some(input);
            self
        }
        /// <p>The class of storage used to store the object.</p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<crate::model::TransitionStorageClass>,
        ) -> Self {
            self.storage_class = input;
            self
        }
        /// <p>Specifies how many noncurrent versions Amazon S3 will retain. If there are this many more recent noncurrent versions, Amazon S3 will take the associated action. For more information about noncurrent versions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/intro-lifecycle-rules.html">Lifecycle configuration elements</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn newer_noncurrent_versions(mut self, input: i32) -> Self {
            self.newer_noncurrent_versions = Some(input);
            self
        }
        /// <p>Specifies how many noncurrent versions Amazon S3 will retain. If there are this many more recent noncurrent versions, Amazon S3 will take the associated action. For more information about noncurrent versions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/intro-lifecycle-rules.html">Lifecycle configuration elements</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_newer_noncurrent_versions(mut self, input: std::option::Option<i32>) -> Self {
            self.newer_noncurrent_versions = input;
            self
        }
        /// Consumes the builder and constructs a [`NoncurrentVersionTransition`](crate::model::NoncurrentVersionTransition)
        pub fn build(self) -> crate::model::NoncurrentVersionTransition {
            crate::model::NoncurrentVersionTransition {
                noncurrent_days: self.noncurrent_days.unwrap_or_default(),
                storage_class: self.storage_class,
                newer_noncurrent_versions: self.newer_noncurrent_versions.unwrap_or_default(),
            }
        }
    }
}
impl NoncurrentVersionTransition {
    /// Creates a new builder-style object to manufacture [`NoncurrentVersionTransition`](crate::model::NoncurrentVersionTransition)
    pub fn builder() -> crate::model::noncurrent_version_transition::Builder {
        crate::model::noncurrent_version_transition::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TransitionStorageClass {
    #[allow(missing_docs)] // documentation missing in model
    DeepArchive,
    #[allow(missing_docs)] // documentation missing in model
    Glacier,
    #[allow(missing_docs)] // documentation missing in model
    GlacierIr,
    #[allow(missing_docs)] // documentation missing in model
    IntelligentTiering,
    #[allow(missing_docs)] // documentation missing in model
    OnezoneIa,
    #[allow(missing_docs)] // documentation missing in model
    StandardIa,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TransitionStorageClass {
    fn from(s: &str) -> Self {
        match s {
            "DEEP_ARCHIVE" => TransitionStorageClass::DeepArchive,
            "GLACIER" => TransitionStorageClass::Glacier,
            "GLACIER_IR" => TransitionStorageClass::GlacierIr,
            "INTELLIGENT_TIERING" => TransitionStorageClass::IntelligentTiering,
            "ONEZONE_IA" => TransitionStorageClass::OnezoneIa,
            "STANDARD_IA" => TransitionStorageClass::StandardIa,
            other => TransitionStorageClass::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TransitionStorageClass {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TransitionStorageClass::from(s))
    }
}
impl TransitionStorageClass {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TransitionStorageClass::DeepArchive => "DEEP_ARCHIVE",
            TransitionStorageClass::Glacier => "GLACIER",
            TransitionStorageClass::GlacierIr => "GLACIER_IR",
            TransitionStorageClass::IntelligentTiering => "INTELLIGENT_TIERING",
            TransitionStorageClass::OnezoneIa => "ONEZONE_IA",
            TransitionStorageClass::StandardIa => "STANDARD_IA",
            TransitionStorageClass::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DEEP_ARCHIVE",
            "GLACIER",
            "GLACIER_IR",
            "INTELLIGENT_TIERING",
            "ONEZONE_IA",
            "STANDARD_IA",
        ]
    }
}
impl AsRef<str> for TransitionStorageClass {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies when an object transitions to a specified storage class. For more information about Amazon S3 lifecycle configuration rules, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/lifecycle-transition-general-considerations.html">Transitioning Objects Using Amazon S3 Lifecycle</a> in the <i>Amazon S3 User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Transition {
    /// <p>Indicates when objects are transitioned to the specified storage class. The date value must be in ISO 8601 format. The time is always midnight UTC.</p>
    pub date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Indicates the number of days after creation when objects are transitioned to the specified storage class. The value must be a positive integer.</p>
    pub days: i32,
    /// <p>The storage class to which you want the object to transition.</p>
    pub storage_class: std::option::Option<crate::model::TransitionStorageClass>,
}
impl Transition {
    /// <p>Indicates when objects are transitioned to the specified storage class. The date value must be in ISO 8601 format. The time is always midnight UTC.</p>
    pub fn date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.date.as_ref()
    }
    /// <p>Indicates the number of days after creation when objects are transitioned to the specified storage class. The value must be a positive integer.</p>
    pub fn days(&self) -> i32 {
        self.days
    }
    /// <p>The storage class to which you want the object to transition.</p>
    pub fn storage_class(&self) -> std::option::Option<&crate::model::TransitionStorageClass> {
        self.storage_class.as_ref()
    }
}
impl std::fmt::Debug for Transition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Transition");
        formatter.field("date", &self.date);
        formatter.field("days", &self.days);
        formatter.field("storage_class", &self.storage_class);
        formatter.finish()
    }
}
/// See [`Transition`](crate::model::Transition)
pub mod transition {
    /// A builder for [`Transition`](crate::model::Transition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) days: std::option::Option<i32>,
        pub(crate) storage_class: std::option::Option<crate::model::TransitionStorageClass>,
    }
    impl Builder {
        /// <p>Indicates when objects are transitioned to the specified storage class. The date value must be in ISO 8601 format. The time is always midnight UTC.</p>
        pub fn date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.date = Some(input);
            self
        }
        /// <p>Indicates when objects are transitioned to the specified storage class. The date value must be in ISO 8601 format. The time is always midnight UTC.</p>
        pub fn set_date(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.date = input;
            self
        }
        /// <p>Indicates the number of days after creation when objects are transitioned to the specified storage class. The value must be a positive integer.</p>
        pub fn days(mut self, input: i32) -> Self {
            self.days = Some(input);
            self
        }
        /// <p>Indicates the number of days after creation when objects are transitioned to the specified storage class. The value must be a positive integer.</p>
        pub fn set_days(mut self, input: std::option::Option<i32>) -> Self {
            self.days = input;
            self
        }
        /// <p>The storage class to which you want the object to transition.</p>
        pub fn storage_class(mut self, input: crate::model::TransitionStorageClass) -> Self {
            self.storage_class = Some(input);
            self
        }
        /// <p>The storage class to which you want the object to transition.</p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<crate::model::TransitionStorageClass>,
        ) -> Self {
            self.storage_class = input;
            self
        }
        /// Consumes the builder and constructs a [`Transition`](crate::model::Transition)
        pub fn build(self) -> crate::model::Transition {
            crate::model::Transition {
                date: self.date,
                days: self.days.unwrap_or_default(),
                storage_class: self.storage_class,
            }
        }
    }
}
impl Transition {
    /// Creates a new builder-style object to manufacture [`Transition`](crate::model::Transition)
    pub fn builder() -> crate::model::transition::Builder {
        crate::model::transition::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExpirationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExpirationStatus {
    fn from(s: &str) -> Self {
        match s {
            "Disabled" => ExpirationStatus::Disabled,
            "Enabled" => ExpirationStatus::Enabled,
            other => ExpirationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExpirationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExpirationStatus::from(s))
    }
}
impl ExpirationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExpirationStatus::Disabled => "Disabled",
            ExpirationStatus::Enabled => "Enabled",
            ExpirationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Disabled", "Enabled"]
    }
}
impl AsRef<str> for ExpirationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The <code>Filter</code> is used to identify objects that a Lifecycle Rule applies to. A <code>Filter</code> must have exactly one of <code>Prefix</code>, <code>Tag</code>, or <code>And</code> specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum LifecycleRuleFilter {
    /// <p>This is used in a Lifecycle Rule Filter to apply a logical AND to two or more predicates. The Lifecycle Rule will apply to any object matching all of the predicates configured inside the And operator.</p>
    And(crate::model::LifecycleRuleAndOperator),
    /// <p>Minimum object size to which the rule applies.</p>
    ObjectSizeGreaterThan(i64),
    /// <p>Maximum object size to which the rule applies.</p>
    ObjectSizeLessThan(i64),
    /// <p>Prefix identifying one or more objects to which the rule applies.</p> <important>
    /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
    /// </important>
    Prefix(std::string::String),
    /// <p>This tag must exist in the object's tag set in order for the rule to apply.</p>
    Tag(crate::model::Tag),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl LifecycleRuleFilter {
    /// Tries to convert the enum instance into [`And`](crate::model::LifecycleRuleFilter::And), extracting the inner [`LifecycleRuleAndOperator`](crate::model::LifecycleRuleAndOperator).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_and(&self) -> std::result::Result<&crate::model::LifecycleRuleAndOperator, &Self> {
        if let LifecycleRuleFilter::And(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`And`](crate::model::LifecycleRuleFilter::And).
    pub fn is_and(&self) -> bool {
        self.as_and().is_ok()
    }
    /// Tries to convert the enum instance into [`ObjectSizeGreaterThan`](crate::model::LifecycleRuleFilter::ObjectSizeGreaterThan), extracting the inner [`i64`](i64).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_object_size_greater_than(&self) -> std::result::Result<&i64, &Self> {
        if let LifecycleRuleFilter::ObjectSizeGreaterThan(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`ObjectSizeGreaterThan`](crate::model::LifecycleRuleFilter::ObjectSizeGreaterThan).
    pub fn is_object_size_greater_than(&self) -> bool {
        self.as_object_size_greater_than().is_ok()
    }
    /// Tries to convert the enum instance into [`ObjectSizeLessThan`](crate::model::LifecycleRuleFilter::ObjectSizeLessThan), extracting the inner [`i64`](i64).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_object_size_less_than(&self) -> std::result::Result<&i64, &Self> {
        if let LifecycleRuleFilter::ObjectSizeLessThan(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`ObjectSizeLessThan`](crate::model::LifecycleRuleFilter::ObjectSizeLessThan).
    pub fn is_object_size_less_than(&self) -> bool {
        self.as_object_size_less_than().is_ok()
    }
    /// Tries to convert the enum instance into [`Prefix`](crate::model::LifecycleRuleFilter::Prefix), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_prefix(&self) -> std::result::Result<&std::string::String, &Self> {
        if let LifecycleRuleFilter::Prefix(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Prefix`](crate::model::LifecycleRuleFilter::Prefix).
    pub fn is_prefix(&self) -> bool {
        self.as_prefix().is_ok()
    }
    /// Tries to convert the enum instance into [`Tag`](crate::model::LifecycleRuleFilter::Tag), extracting the inner [`Tag`](crate::model::Tag).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_tag(&self) -> std::result::Result<&crate::model::Tag, &Self> {
        if let LifecycleRuleFilter::Tag(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Tag`](crate::model::LifecycleRuleFilter::Tag).
    pub fn is_tag(&self) -> bool {
        self.as_tag().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>This is used in a Lifecycle Rule Filter to apply a logical AND to two or more predicates. The Lifecycle Rule will apply to any object matching all of the predicates configured inside the And operator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifecycleRuleAndOperator {
    /// <p>Prefix identifying one or more objects to which the rule applies.</p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>All of these tags must exist in the object's tag set in order for the rule to apply.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Minimum object size to which the rule applies.</p>
    pub object_size_greater_than: i64,
    /// <p>Maximum object size to which the rule applies.</p>
    pub object_size_less_than: i64,
}
impl LifecycleRuleAndOperator {
    /// <p>Prefix identifying one or more objects to which the rule applies.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>All of these tags must exist in the object's tag set in order for the rule to apply.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>Minimum object size to which the rule applies.</p>
    pub fn object_size_greater_than(&self) -> i64 {
        self.object_size_greater_than
    }
    /// <p>Maximum object size to which the rule applies.</p>
    pub fn object_size_less_than(&self) -> i64 {
        self.object_size_less_than
    }
}
impl std::fmt::Debug for LifecycleRuleAndOperator {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifecycleRuleAndOperator");
        formatter.field("prefix", &self.prefix);
        formatter.field("tags", &self.tags);
        formatter.field("object_size_greater_than", &self.object_size_greater_than);
        formatter.field("object_size_less_than", &self.object_size_less_than);
        formatter.finish()
    }
}
/// See [`LifecycleRuleAndOperator`](crate::model::LifecycleRuleAndOperator)
pub mod lifecycle_rule_and_operator {
    /// A builder for [`LifecycleRuleAndOperator`](crate::model::LifecycleRuleAndOperator)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) object_size_greater_than: std::option::Option<i64>,
        pub(crate) object_size_less_than: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Prefix identifying one or more objects to which the rule applies.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>Prefix identifying one or more objects to which the rule applies.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>All of these tags must exist in the object's tag set in order for the rule to apply.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>All of these tags must exist in the object's tag set in order for the rule to apply.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Minimum object size to which the rule applies.</p>
        pub fn object_size_greater_than(mut self, input: i64) -> Self {
            self.object_size_greater_than = Some(input);
            self
        }
        /// <p>Minimum object size to which the rule applies.</p>
        pub fn set_object_size_greater_than(mut self, input: std::option::Option<i64>) -> Self {
            self.object_size_greater_than = input;
            self
        }
        /// <p>Maximum object size to which the rule applies.</p>
        pub fn object_size_less_than(mut self, input: i64) -> Self {
            self.object_size_less_than = Some(input);
            self
        }
        /// <p>Maximum object size to which the rule applies.</p>
        pub fn set_object_size_less_than(mut self, input: std::option::Option<i64>) -> Self {
            self.object_size_less_than = input;
            self
        }
        /// Consumes the builder and constructs a [`LifecycleRuleAndOperator`](crate::model::LifecycleRuleAndOperator)
        pub fn build(self) -> crate::model::LifecycleRuleAndOperator {
            crate::model::LifecycleRuleAndOperator {
                prefix: self.prefix,
                tags: self.tags,
                object_size_greater_than: self.object_size_greater_than.unwrap_or_default(),
                object_size_less_than: self.object_size_less_than.unwrap_or_default(),
            }
        }
    }
}
impl LifecycleRuleAndOperator {
    /// Creates a new builder-style object to manufacture [`LifecycleRuleAndOperator`](crate::model::LifecycleRuleAndOperator)
    pub fn builder() -> crate::model::lifecycle_rule_and_operator::Builder {
        crate::model::lifecycle_rule_and_operator::Builder::default()
    }
}

/// <p>Container for the expiration for the lifecycle of the object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifecycleExpiration {
    /// <p>Indicates at what date the object is to be moved or deleted. Should be in GMT ISO 8601 Format.</p>
    pub date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Indicates the lifetime, in days, of the objects that are subject to the rule. The value must be a non-zero positive integer.</p>
    pub days: i32,
    /// <p>Indicates whether Amazon S3 will remove a delete marker with no noncurrent versions. If set to true, the delete marker will be expired; if set to false the policy takes no action. This cannot be specified with Days or Date in a Lifecycle Expiration Policy.</p>
    pub expired_object_delete_marker: bool,
}
impl LifecycleExpiration {
    /// <p>Indicates at what date the object is to be moved or deleted. Should be in GMT ISO 8601 Format.</p>
    pub fn date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.date.as_ref()
    }
    /// <p>Indicates the lifetime, in days, of the objects that are subject to the rule. The value must be a non-zero positive integer.</p>
    pub fn days(&self) -> i32 {
        self.days
    }
    /// <p>Indicates whether Amazon S3 will remove a delete marker with no noncurrent versions. If set to true, the delete marker will be expired; if set to false the policy takes no action. This cannot be specified with Days or Date in a Lifecycle Expiration Policy.</p>
    pub fn expired_object_delete_marker(&self) -> bool {
        self.expired_object_delete_marker
    }
}
impl std::fmt::Debug for LifecycleExpiration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifecycleExpiration");
        formatter.field("date", &self.date);
        formatter.field("days", &self.days);
        formatter.field(
            "expired_object_delete_marker",
            &self.expired_object_delete_marker,
        );
        formatter.finish()
    }
}
/// See [`LifecycleExpiration`](crate::model::LifecycleExpiration)
pub mod lifecycle_expiration {
    /// A builder for [`LifecycleExpiration`](crate::model::LifecycleExpiration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) days: std::option::Option<i32>,
        pub(crate) expired_object_delete_marker: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Indicates at what date the object is to be moved or deleted. Should be in GMT ISO 8601 Format.</p>
        pub fn date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.date = Some(input);
            self
        }
        /// <p>Indicates at what date the object is to be moved or deleted. Should be in GMT ISO 8601 Format.</p>
        pub fn set_date(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.date = input;
            self
        }
        /// <p>Indicates the lifetime, in days, of the objects that are subject to the rule. The value must be a non-zero positive integer.</p>
        pub fn days(mut self, input: i32) -> Self {
            self.days = Some(input);
            self
        }
        /// <p>Indicates the lifetime, in days, of the objects that are subject to the rule. The value must be a non-zero positive integer.</p>
        pub fn set_days(mut self, input: std::option::Option<i32>) -> Self {
            self.days = input;
            self
        }
        /// <p>Indicates whether Amazon S3 will remove a delete marker with no noncurrent versions. If set to true, the delete marker will be expired; if set to false the policy takes no action. This cannot be specified with Days or Date in a Lifecycle Expiration Policy.</p>
        pub fn expired_object_delete_marker(mut self, input: bool) -> Self {
            self.expired_object_delete_marker = Some(input);
            self
        }
        /// <p>Indicates whether Amazon S3 will remove a delete marker with no noncurrent versions. If set to true, the delete marker will be expired; if set to false the policy takes no action. This cannot be specified with Days or Date in a Lifecycle Expiration Policy.</p>
        pub fn set_expired_object_delete_marker(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.expired_object_delete_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`LifecycleExpiration`](crate::model::LifecycleExpiration)
        pub fn build(self) -> crate::model::LifecycleExpiration {
            crate::model::LifecycleExpiration {
                date: self.date,
                days: self.days.unwrap_or_default(),
                expired_object_delete_marker: self.expired_object_delete_marker.unwrap_or_default(),
            }
        }
    }
}
impl LifecycleExpiration {
    /// Creates a new builder-style object to manufacture [`LifecycleExpiration`](crate::model::LifecycleExpiration)
    pub fn builder() -> crate::model::lifecycle_expiration::Builder {
        crate::model::lifecycle_expiration::Builder::default()
    }
}

/// <p>Specifies the inventory configuration for an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketGETInventoryConfig.html">GET Bucket inventory</a> in the <i>Amazon S3 API Reference</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InventoryConfiguration {
    /// <p>Contains information about where to publish the inventory results.</p>
    pub destination: std::option::Option<crate::model::InventoryDestination>,
    /// <p>Specifies whether the inventory is enabled or disabled. If set to <code>True</code>, an inventory list is generated. If set to <code>False</code>, no inventory list is generated.</p>
    pub is_enabled: bool,
    /// <p>Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria.</p>
    pub filter: std::option::Option<crate::model::InventoryFilter>,
    /// <p>The ID used to identify the inventory configuration.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Object versions to include in the inventory list. If set to <code>All</code>, the list includes all the object versions, which adds the version-related fields <code>VersionId</code>, <code>IsLatest</code>, and <code>DeleteMarker</code> to the list. If set to <code>Current</code>, the list does not contain these version-related fields.</p>
    pub included_object_versions:
        std::option::Option<crate::model::InventoryIncludedObjectVersions>,
    /// <p>Contains the optional fields that are included in the inventory results.</p>
    pub optional_fields: std::option::Option<std::vec::Vec<crate::model::InventoryOptionalField>>,
    /// <p>Specifies the schedule for generating inventory results.</p>
    pub schedule: std::option::Option<crate::model::InventorySchedule>,
}
impl InventoryConfiguration {
    /// <p>Contains information about where to publish the inventory results.</p>
    pub fn destination(&self) -> std::option::Option<&crate::model::InventoryDestination> {
        self.destination.as_ref()
    }
    /// <p>Specifies whether the inventory is enabled or disabled. If set to <code>True</code>, an inventory list is generated. If set to <code>False</code>, no inventory list is generated.</p>
    pub fn is_enabled(&self) -> bool {
        self.is_enabled
    }
    /// <p>Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::InventoryFilter> {
        self.filter.as_ref()
    }
    /// <p>The ID used to identify the inventory configuration.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Object versions to include in the inventory list. If set to <code>All</code>, the list includes all the object versions, which adds the version-related fields <code>VersionId</code>, <code>IsLatest</code>, and <code>DeleteMarker</code> to the list. If set to <code>Current</code>, the list does not contain these version-related fields.</p>
    pub fn included_object_versions(
        &self,
    ) -> std::option::Option<&crate::model::InventoryIncludedObjectVersions> {
        self.included_object_versions.as_ref()
    }
    /// <p>Contains the optional fields that are included in the inventory results.</p>
    pub fn optional_fields(&self) -> std::option::Option<&[crate::model::InventoryOptionalField]> {
        self.optional_fields.as_deref()
    }
    /// <p>Specifies the schedule for generating inventory results.</p>
    pub fn schedule(&self) -> std::option::Option<&crate::model::InventorySchedule> {
        self.schedule.as_ref()
    }
}
impl std::fmt::Debug for InventoryConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InventoryConfiguration");
        formatter.field("destination", &self.destination);
        formatter.field("is_enabled", &self.is_enabled);
        formatter.field("filter", &self.filter);
        formatter.field("id", &self.id);
        formatter.field("included_object_versions", &self.included_object_versions);
        formatter.field("optional_fields", &self.optional_fields);
        formatter.field("schedule", &self.schedule);
        formatter.finish()
    }
}
/// See [`InventoryConfiguration`](crate::model::InventoryConfiguration)
pub mod inventory_configuration {
    /// A builder for [`InventoryConfiguration`](crate::model::InventoryConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination: std::option::Option<crate::model::InventoryDestination>,
        pub(crate) is_enabled: std::option::Option<bool>,
        pub(crate) filter: std::option::Option<crate::model::InventoryFilter>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) included_object_versions:
            std::option::Option<crate::model::InventoryIncludedObjectVersions>,
        pub(crate) optional_fields:
            std::option::Option<std::vec::Vec<crate::model::InventoryOptionalField>>,
        pub(crate) schedule: std::option::Option<crate::model::InventorySchedule>,
    }
    impl Builder {
        /// <p>Contains information about where to publish the inventory results.</p>
        pub fn destination(mut self, input: crate::model::InventoryDestination) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>Contains information about where to publish the inventory results.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::InventoryDestination>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// <p>Specifies whether the inventory is enabled or disabled. If set to <code>True</code>, an inventory list is generated. If set to <code>False</code>, no inventory list is generated.</p>
        pub fn is_enabled(mut self, input: bool) -> Self {
            self.is_enabled = Some(input);
            self
        }
        /// <p>Specifies whether the inventory is enabled or disabled. If set to <code>True</code>, an inventory list is generated. If set to <code>False</code>, no inventory list is generated.</p>
        pub fn set_is_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.is_enabled = input;
            self
        }
        /// <p>Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria.</p>
        pub fn filter(mut self, input: crate::model::InventoryFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::InventoryFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>The ID used to identify the inventory configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID used to identify the inventory configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Object versions to include in the inventory list. If set to <code>All</code>, the list includes all the object versions, which adds the version-related fields <code>VersionId</code>, <code>IsLatest</code>, and <code>DeleteMarker</code> to the list. If set to <code>Current</code>, the list does not contain these version-related fields.</p>
        pub fn included_object_versions(
            mut self,
            input: crate::model::InventoryIncludedObjectVersions,
        ) -> Self {
            self.included_object_versions = Some(input);
            self
        }
        /// <p>Object versions to include in the inventory list. If set to <code>All</code>, the list includes all the object versions, which adds the version-related fields <code>VersionId</code>, <code>IsLatest</code>, and <code>DeleteMarker</code> to the list. If set to <code>Current</code>, the list does not contain these version-related fields.</p>
        pub fn set_included_object_versions(
            mut self,
            input: std::option::Option<crate::model::InventoryIncludedObjectVersions>,
        ) -> Self {
            self.included_object_versions = input;
            self
        }
        /// Appends an item to `optional_fields`.
        ///
        /// To override the contents of this collection use [`set_optional_fields`](Self::set_optional_fields).
        ///
        /// <p>Contains the optional fields that are included in the inventory results.</p>
        pub fn optional_fields(mut self, input: crate::model::InventoryOptionalField) -> Self {
            let mut v = self.optional_fields.unwrap_or_default();
            v.push(input);
            self.optional_fields = Some(v);
            self
        }
        /// <p>Contains the optional fields that are included in the inventory results.</p>
        pub fn set_optional_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InventoryOptionalField>>,
        ) -> Self {
            self.optional_fields = input;
            self
        }
        /// <p>Specifies the schedule for generating inventory results.</p>
        pub fn schedule(mut self, input: crate::model::InventorySchedule) -> Self {
            self.schedule = Some(input);
            self
        }
        /// <p>Specifies the schedule for generating inventory results.</p>
        pub fn set_schedule(
            mut self,
            input: std::option::Option<crate::model::InventorySchedule>,
        ) -> Self {
            self.schedule = input;
            self
        }
        /// Consumes the builder and constructs a [`InventoryConfiguration`](crate::model::InventoryConfiguration)
        pub fn build(self) -> crate::model::InventoryConfiguration {
            crate::model::InventoryConfiguration {
                destination: self.destination,
                is_enabled: self.is_enabled.unwrap_or_default(),
                filter: self.filter,
                id: self.id,
                included_object_versions: self.included_object_versions,
                optional_fields: self.optional_fields,
                schedule: self.schedule,
            }
        }
    }
}
impl InventoryConfiguration {
    /// Creates a new builder-style object to manufacture [`InventoryConfiguration`](crate::model::InventoryConfiguration)
    pub fn builder() -> crate::model::inventory_configuration::Builder {
        crate::model::inventory_configuration::Builder::default()
    }
}

/// <p>Specifies the schedule for generating inventory results.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InventorySchedule {
    /// <p>Specifies how frequently inventory results are produced.</p>
    pub frequency: std::option::Option<crate::model::InventoryFrequency>,
}
impl InventorySchedule {
    /// <p>Specifies how frequently inventory results are produced.</p>
    pub fn frequency(&self) -> std::option::Option<&crate::model::InventoryFrequency> {
        self.frequency.as_ref()
    }
}
impl std::fmt::Debug for InventorySchedule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InventorySchedule");
        formatter.field("frequency", &self.frequency);
        formatter.finish()
    }
}
/// See [`InventorySchedule`](crate::model::InventorySchedule)
pub mod inventory_schedule {
    /// A builder for [`InventorySchedule`](crate::model::InventorySchedule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) frequency: std::option::Option<crate::model::InventoryFrequency>,
    }
    impl Builder {
        /// <p>Specifies how frequently inventory results are produced.</p>
        pub fn frequency(mut self, input: crate::model::InventoryFrequency) -> Self {
            self.frequency = Some(input);
            self
        }
        /// <p>Specifies how frequently inventory results are produced.</p>
        pub fn set_frequency(
            mut self,
            input: std::option::Option<crate::model::InventoryFrequency>,
        ) -> Self {
            self.frequency = input;
            self
        }
        /// Consumes the builder and constructs a [`InventorySchedule`](crate::model::InventorySchedule)
        pub fn build(self) -> crate::model::InventorySchedule {
            crate::model::InventorySchedule {
                frequency: self.frequency,
            }
        }
    }
}
impl InventorySchedule {
    /// Creates a new builder-style object to manufacture [`InventorySchedule`](crate::model::InventorySchedule)
    pub fn builder() -> crate::model::inventory_schedule::Builder {
        crate::model::inventory_schedule::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InventoryFrequency {
    #[allow(missing_docs)] // documentation missing in model
    Daily,
    #[allow(missing_docs)] // documentation missing in model
    Weekly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InventoryFrequency {
    fn from(s: &str) -> Self {
        match s {
            "Daily" => InventoryFrequency::Daily,
            "Weekly" => InventoryFrequency::Weekly,
            other => InventoryFrequency::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InventoryFrequency {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InventoryFrequency::from(s))
    }
}
impl InventoryFrequency {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InventoryFrequency::Daily => "Daily",
            InventoryFrequency::Weekly => "Weekly",
            InventoryFrequency::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Daily", "Weekly"]
    }
}
impl AsRef<str> for InventoryFrequency {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InventoryOptionalField {
    #[allow(missing_docs)] // documentation missing in model
    BucketKeyStatus,
    #[allow(missing_docs)] // documentation missing in model
    ETag,
    #[allow(missing_docs)] // documentation missing in model
    EncryptionStatus,
    #[allow(missing_docs)] // documentation missing in model
    IntelligentTieringAccessTier,
    #[allow(missing_docs)] // documentation missing in model
    IsMultipartUploaded,
    #[allow(missing_docs)] // documentation missing in model
    LastModifiedDate,
    #[allow(missing_docs)] // documentation missing in model
    ObjectLockLegalHoldStatus,
    #[allow(missing_docs)] // documentation missing in model
    ObjectLockMode,
    #[allow(missing_docs)] // documentation missing in model
    ObjectLockRetainUntilDate,
    #[allow(missing_docs)] // documentation missing in model
    ReplicationStatus,
    #[allow(missing_docs)] // documentation missing in model
    Size,
    #[allow(missing_docs)] // documentation missing in model
    StorageClass,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InventoryOptionalField {
    fn from(s: &str) -> Self {
        match s {
            "BucketKeyStatus" => InventoryOptionalField::BucketKeyStatus,
            "ETag" => InventoryOptionalField::ETag,
            "EncryptionStatus" => InventoryOptionalField::EncryptionStatus,
            "IntelligentTieringAccessTier" => InventoryOptionalField::IntelligentTieringAccessTier,
            "IsMultipartUploaded" => InventoryOptionalField::IsMultipartUploaded,
            "LastModifiedDate" => InventoryOptionalField::LastModifiedDate,
            "ObjectLockLegalHoldStatus" => InventoryOptionalField::ObjectLockLegalHoldStatus,
            "ObjectLockMode" => InventoryOptionalField::ObjectLockMode,
            "ObjectLockRetainUntilDate" => InventoryOptionalField::ObjectLockRetainUntilDate,
            "ReplicationStatus" => InventoryOptionalField::ReplicationStatus,
            "Size" => InventoryOptionalField::Size,
            "StorageClass" => InventoryOptionalField::StorageClass,
            other => InventoryOptionalField::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InventoryOptionalField {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InventoryOptionalField::from(s))
    }
}
impl InventoryOptionalField {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InventoryOptionalField::BucketKeyStatus => "BucketKeyStatus",
            InventoryOptionalField::ETag => "ETag",
            InventoryOptionalField::EncryptionStatus => "EncryptionStatus",
            InventoryOptionalField::IntelligentTieringAccessTier => "IntelligentTieringAccessTier",
            InventoryOptionalField::IsMultipartUploaded => "IsMultipartUploaded",
            InventoryOptionalField::LastModifiedDate => "LastModifiedDate",
            InventoryOptionalField::ObjectLockLegalHoldStatus => "ObjectLockLegalHoldStatus",
            InventoryOptionalField::ObjectLockMode => "ObjectLockMode",
            InventoryOptionalField::ObjectLockRetainUntilDate => "ObjectLockRetainUntilDate",
            InventoryOptionalField::ReplicationStatus => "ReplicationStatus",
            InventoryOptionalField::Size => "Size",
            InventoryOptionalField::StorageClass => "StorageClass",
            InventoryOptionalField::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BucketKeyStatus",
            "ETag",
            "EncryptionStatus",
            "IntelligentTieringAccessTier",
            "IsMultipartUploaded",
            "LastModifiedDate",
            "ObjectLockLegalHoldStatus",
            "ObjectLockMode",
            "ObjectLockRetainUntilDate",
            "ReplicationStatus",
            "Size",
            "StorageClass",
        ]
    }
}
impl AsRef<str> for InventoryOptionalField {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InventoryIncludedObjectVersions {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Current,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InventoryIncludedObjectVersions {
    fn from(s: &str) -> Self {
        match s {
            "All" => InventoryIncludedObjectVersions::All,
            "Current" => InventoryIncludedObjectVersions::Current,
            other => InventoryIncludedObjectVersions::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InventoryIncludedObjectVersions {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InventoryIncludedObjectVersions::from(s))
    }
}
impl InventoryIncludedObjectVersions {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InventoryIncludedObjectVersions::All => "All",
            InventoryIncludedObjectVersions::Current => "Current",
            InventoryIncludedObjectVersions::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["All", "Current"]
    }
}
impl AsRef<str> for InventoryIncludedObjectVersions {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InventoryFilter {
    /// <p>The prefix that an object must have to be included in the inventory results.</p>
    pub prefix: std::option::Option<std::string::String>,
}
impl InventoryFilter {
    /// <p>The prefix that an object must have to be included in the inventory results.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
}
impl std::fmt::Debug for InventoryFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InventoryFilter");
        formatter.field("prefix", &self.prefix);
        formatter.finish()
    }
}
/// See [`InventoryFilter`](crate::model::InventoryFilter)
pub mod inventory_filter {
    /// A builder for [`InventoryFilter`](crate::model::InventoryFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The prefix that an object must have to be included in the inventory results.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>The prefix that an object must have to be included in the inventory results.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`InventoryFilter`](crate::model::InventoryFilter)
        pub fn build(self) -> crate::model::InventoryFilter {
            crate::model::InventoryFilter {
                prefix: self.prefix,
            }
        }
    }
}
impl InventoryFilter {
    /// Creates a new builder-style object to manufacture [`InventoryFilter`](crate::model::InventoryFilter)
    pub fn builder() -> crate::model::inventory_filter::Builder {
        crate::model::inventory_filter::Builder::default()
    }
}

/// <p>Specifies the inventory configuration for an Amazon S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InventoryDestination {
    /// <p>Contains the bucket name, file format, bucket owner (optional), and prefix (optional) where inventory results are published.</p>
    pub s3_bucket_destination: std::option::Option<crate::model::InventoryS3BucketDestination>,
}
impl InventoryDestination {
    /// <p>Contains the bucket name, file format, bucket owner (optional), and prefix (optional) where inventory results are published.</p>
    pub fn s3_bucket_destination(
        &self,
    ) -> std::option::Option<&crate::model::InventoryS3BucketDestination> {
        self.s3_bucket_destination.as_ref()
    }
}
impl std::fmt::Debug for InventoryDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InventoryDestination");
        formatter.field("s3_bucket_destination", &self.s3_bucket_destination);
        formatter.finish()
    }
}
/// See [`InventoryDestination`](crate::model::InventoryDestination)
pub mod inventory_destination {
    /// A builder for [`InventoryDestination`](crate::model::InventoryDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_bucket_destination:
            std::option::Option<crate::model::InventoryS3BucketDestination>,
    }
    impl Builder {
        /// <p>Contains the bucket name, file format, bucket owner (optional), and prefix (optional) where inventory results are published.</p>
        pub fn s3_bucket_destination(
            mut self,
            input: crate::model::InventoryS3BucketDestination,
        ) -> Self {
            self.s3_bucket_destination = Some(input);
            self
        }
        /// <p>Contains the bucket name, file format, bucket owner (optional), and prefix (optional) where inventory results are published.</p>
        pub fn set_s3_bucket_destination(
            mut self,
            input: std::option::Option<crate::model::InventoryS3BucketDestination>,
        ) -> Self {
            self.s3_bucket_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`InventoryDestination`](crate::model::InventoryDestination)
        pub fn build(self) -> crate::model::InventoryDestination {
            crate::model::InventoryDestination {
                s3_bucket_destination: self.s3_bucket_destination,
            }
        }
    }
}
impl InventoryDestination {
    /// Creates a new builder-style object to manufacture [`InventoryDestination`](crate::model::InventoryDestination)
    pub fn builder() -> crate::model::inventory_destination::Builder {
        crate::model::inventory_destination::Builder::default()
    }
}

/// <p>Contains the bucket name, file format, bucket owner (optional), and prefix (optional) where inventory results are published.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InventoryS3BucketDestination {
    /// <p>The account ID that owns the destination S3 bucket. If no account ID is provided, the owner is not validated before exporting data. </p> <note>
    /// <p> Although this value is optional, we strongly recommend that you set it to help prevent problems if the destination bucket ownership changes. </p>
    /// </note>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the bucket where inventory results will be published.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>Specifies the output format of the inventory results.</p>
    pub format: std::option::Option<crate::model::InventoryFormat>,
    /// <p>The prefix that is prepended to all inventory results.</p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>Contains the type of server-side encryption used to encrypt the inventory results.</p>
    pub encryption: std::option::Option<crate::model::InventoryEncryption>,
}
impl InventoryS3BucketDestination {
    /// <p>The account ID that owns the destination S3 bucket. If no account ID is provided, the owner is not validated before exporting data. </p> <note>
    /// <p> Although this value is optional, we strongly recommend that you set it to help prevent problems if the destination bucket ownership changes. </p>
    /// </note>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the bucket where inventory results will be published.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>Specifies the output format of the inventory results.</p>
    pub fn format(&self) -> std::option::Option<&crate::model::InventoryFormat> {
        self.format.as_ref()
    }
    /// <p>The prefix that is prepended to all inventory results.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>Contains the type of server-side encryption used to encrypt the inventory results.</p>
    pub fn encryption(&self) -> std::option::Option<&crate::model::InventoryEncryption> {
        self.encryption.as_ref()
    }
}
impl std::fmt::Debug for InventoryS3BucketDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InventoryS3BucketDestination");
        formatter.field("account_id", &self.account_id);
        formatter.field("bucket", &self.bucket);
        formatter.field("format", &self.format);
        formatter.field("prefix", &self.prefix);
        formatter.field("encryption", &self.encryption);
        formatter.finish()
    }
}
/// See [`InventoryS3BucketDestination`](crate::model::InventoryS3BucketDestination)
pub mod inventory_s3_bucket_destination {
    /// A builder for [`InventoryS3BucketDestination`](crate::model::InventoryS3BucketDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::InventoryFormat>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) encryption: std::option::Option<crate::model::InventoryEncryption>,
    }
    impl Builder {
        /// <p>The account ID that owns the destination S3 bucket. If no account ID is provided, the owner is not validated before exporting data. </p> <note>
        /// <p> Although this value is optional, we strongly recommend that you set it to help prevent problems if the destination bucket ownership changes. </p>
        /// </note>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID that owns the destination S3 bucket. If no account ID is provided, the owner is not validated before exporting data. </p> <note>
        /// <p> Although this value is optional, we strongly recommend that you set it to help prevent problems if the destination bucket ownership changes. </p>
        /// </note>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bucket where inventory results will be published.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bucket where inventory results will be published.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Specifies the output format of the inventory results.</p>
        pub fn format(mut self, input: crate::model::InventoryFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>Specifies the output format of the inventory results.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::InventoryFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>The prefix that is prepended to all inventory results.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>The prefix that is prepended to all inventory results.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>Contains the type of server-side encryption used to encrypt the inventory results.</p>
        pub fn encryption(mut self, input: crate::model::InventoryEncryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// <p>Contains the type of server-side encryption used to encrypt the inventory results.</p>
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::InventoryEncryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// Consumes the builder and constructs a [`InventoryS3BucketDestination`](crate::model::InventoryS3BucketDestination)
        pub fn build(self) -> crate::model::InventoryS3BucketDestination {
            crate::model::InventoryS3BucketDestination {
                account_id: self.account_id,
                bucket: self.bucket,
                format: self.format,
                prefix: self.prefix,
                encryption: self.encryption,
            }
        }
    }
}
impl InventoryS3BucketDestination {
    /// Creates a new builder-style object to manufacture [`InventoryS3BucketDestination`](crate::model::InventoryS3BucketDestination)
    pub fn builder() -> crate::model::inventory_s3_bucket_destination::Builder {
        crate::model::inventory_s3_bucket_destination::Builder::default()
    }
}

/// <p>Contains the type of server-side encryption used to encrypt the inventory results.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InventoryEncryption {
    /// <p>Specifies the use of SSE-S3 to encrypt delivered inventory reports.</p>
    pub sses3: std::option::Option<crate::model::Sses3>,
    /// <p>Specifies the use of SSE-KMS to encrypt delivered inventory reports.</p>
    pub ssekms: std::option::Option<crate::model::Ssekms>,
}
impl InventoryEncryption {
    /// <p>Specifies the use of SSE-S3 to encrypt delivered inventory reports.</p>
    pub fn sses3(&self) -> std::option::Option<&crate::model::Sses3> {
        self.sses3.as_ref()
    }
    /// <p>Specifies the use of SSE-KMS to encrypt delivered inventory reports.</p>
    pub fn ssekms(&self) -> std::option::Option<&crate::model::Ssekms> {
        self.ssekms.as_ref()
    }
}
impl std::fmt::Debug for InventoryEncryption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InventoryEncryption");
        formatter.field("sses3", &self.sses3);
        formatter.field("ssekms", &self.ssekms);
        formatter.finish()
    }
}
/// See [`InventoryEncryption`](crate::model::InventoryEncryption)
pub mod inventory_encryption {
    /// A builder for [`InventoryEncryption`](crate::model::InventoryEncryption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sses3: std::option::Option<crate::model::Sses3>,
        pub(crate) ssekms: std::option::Option<crate::model::Ssekms>,
    }
    impl Builder {
        /// <p>Specifies the use of SSE-S3 to encrypt delivered inventory reports.</p>
        pub fn sses3(mut self, input: crate::model::Sses3) -> Self {
            self.sses3 = Some(input);
            self
        }
        /// <p>Specifies the use of SSE-S3 to encrypt delivered inventory reports.</p>
        pub fn set_sses3(mut self, input: std::option::Option<crate::model::Sses3>) -> Self {
            self.sses3 = input;
            self
        }
        /// <p>Specifies the use of SSE-KMS to encrypt delivered inventory reports.</p>
        pub fn ssekms(mut self, input: crate::model::Ssekms) -> Self {
            self.ssekms = Some(input);
            self
        }
        /// <p>Specifies the use of SSE-KMS to encrypt delivered inventory reports.</p>
        pub fn set_ssekms(mut self, input: std::option::Option<crate::model::Ssekms>) -> Self {
            self.ssekms = input;
            self
        }
        /// Consumes the builder and constructs a [`InventoryEncryption`](crate::model::InventoryEncryption)
        pub fn build(self) -> crate::model::InventoryEncryption {
            crate::model::InventoryEncryption {
                sses3: self.sses3,
                ssekms: self.ssekms,
            }
        }
    }
}
impl InventoryEncryption {
    /// Creates a new builder-style object to manufacture [`InventoryEncryption`](crate::model::InventoryEncryption)
    pub fn builder() -> crate::model::inventory_encryption::Builder {
        crate::model::inventory_encryption::Builder::default()
    }
}

/// <p>Specifies the use of SSE-KMS to encrypt delivered inventory reports.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ssekms {
    /// <p>Specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric customer managed key to use for encrypting inventory reports.</p>
    pub key_id: std::option::Option<std::string::String>,
}
impl Ssekms {
    /// <p>Specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric customer managed key to use for encrypting inventory reports.</p>
    pub fn key_id(&self) -> std::option::Option<&str> {
        self.key_id.as_deref()
    }
}
impl std::fmt::Debug for Ssekms {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ssekms");
        formatter.field("key_id", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`Ssekms`](crate::model::Ssekms)
pub mod ssekms {
    /// A builder for [`Ssekms`](crate::model::Ssekms)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric customer managed key to use for encrypting inventory reports.</p>
        pub fn key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_id = Some(input.into());
            self
        }
        /// <p>Specifies the ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric customer managed key to use for encrypting inventory reports.</p>
        pub fn set_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Ssekms`](crate::model::Ssekms)
        pub fn build(self) -> crate::model::Ssekms {
            crate::model::Ssekms {
                key_id: self.key_id,
            }
        }
    }
}
impl Ssekms {
    /// Creates a new builder-style object to manufacture [`Ssekms`](crate::model::Ssekms)
    pub fn builder() -> crate::model::ssekms::Builder {
        crate::model::ssekms::Builder::default()
    }
}

/// <p>Specifies the use of SSE-S3 to encrypt delivered inventory reports.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Sses3 {}
impl std::fmt::Debug for Sses3 {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Sses3");
        formatter.finish()
    }
}
/// See [`Sses3`](crate::model::Sses3)
pub mod sses3 {
    /// A builder for [`Sses3`](crate::model::Sses3)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`Sses3`](crate::model::Sses3)
        pub fn build(self) -> crate::model::Sses3 {
            crate::model::Sses3 {}
        }
    }
}
impl Sses3 {
    /// Creates a new builder-style object to manufacture [`Sses3`](crate::model::Sses3)
    pub fn builder() -> crate::model::sses3::Builder {
        crate::model::sses3::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InventoryFormat {
    #[allow(missing_docs)] // documentation missing in model
    Csv,
    #[allow(missing_docs)] // documentation missing in model
    Orc,
    #[allow(missing_docs)] // documentation missing in model
    Parquet,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InventoryFormat {
    fn from(s: &str) -> Self {
        match s {
            "CSV" => InventoryFormat::Csv,
            "ORC" => InventoryFormat::Orc,
            "Parquet" => InventoryFormat::Parquet,
            other => InventoryFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InventoryFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InventoryFormat::from(s))
    }
}
impl InventoryFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InventoryFormat::Csv => "CSV",
            InventoryFormat::Orc => "ORC",
            InventoryFormat::Parquet => "Parquet",
            InventoryFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CSV", "ORC", "Parquet"]
    }
}
impl AsRef<str> for InventoryFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the S3 Intelligent-Tiering configuration for an Amazon S3 bucket.</p>
/// <p>For information about the S3 Intelligent-Tiering storage class, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access">Storage class for automatically optimizing frequently and infrequently accessed objects</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IntelligentTieringConfiguration {
    /// <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Specifies a bucket filter. The configuration only includes objects that meet the filter's criteria.</p>
    pub filter: std::option::Option<crate::model::IntelligentTieringFilter>,
    /// <p>Specifies the status of the configuration.</p>
    pub status: std::option::Option<crate::model::IntelligentTieringStatus>,
    /// <p>Specifies the S3 Intelligent-Tiering storage class tier of the configuration.</p>
    pub tierings: std::option::Option<std::vec::Vec<crate::model::Tiering>>,
}
impl IntelligentTieringConfiguration {
    /// <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Specifies a bucket filter. The configuration only includes objects that meet the filter's criteria.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::IntelligentTieringFilter> {
        self.filter.as_ref()
    }
    /// <p>Specifies the status of the configuration.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::IntelligentTieringStatus> {
        self.status.as_ref()
    }
    /// <p>Specifies the S3 Intelligent-Tiering storage class tier of the configuration.</p>
    pub fn tierings(&self) -> std::option::Option<&[crate::model::Tiering]> {
        self.tierings.as_deref()
    }
}
impl std::fmt::Debug for IntelligentTieringConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IntelligentTieringConfiguration");
        formatter.field("id", &self.id);
        formatter.field("filter", &self.filter);
        formatter.field("status", &self.status);
        formatter.field("tierings", &self.tierings);
        formatter.finish()
    }
}
/// See [`IntelligentTieringConfiguration`](crate::model::IntelligentTieringConfiguration)
pub mod intelligent_tiering_configuration {
    /// A builder for [`IntelligentTieringConfiguration`](crate::model::IntelligentTieringConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) filter: std::option::Option<crate::model::IntelligentTieringFilter>,
        pub(crate) status: std::option::Option<crate::model::IntelligentTieringStatus>,
        pub(crate) tierings: std::option::Option<std::vec::Vec<crate::model::Tiering>>,
    }
    impl Builder {
        /// <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Specifies a bucket filter. The configuration only includes objects that meet the filter's criteria.</p>
        pub fn filter(mut self, input: crate::model::IntelligentTieringFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Specifies a bucket filter. The configuration only includes objects that meet the filter's criteria.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::IntelligentTieringFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>Specifies the status of the configuration.</p>
        pub fn status(mut self, input: crate::model::IntelligentTieringStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Specifies the status of the configuration.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::IntelligentTieringStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `tierings`.
        ///
        /// To override the contents of this collection use [`set_tierings`](Self::set_tierings).
        ///
        /// <p>Specifies the S3 Intelligent-Tiering storage class tier of the configuration.</p>
        pub fn tierings(mut self, input: crate::model::Tiering) -> Self {
            let mut v = self.tierings.unwrap_or_default();
            v.push(input);
            self.tierings = Some(v);
            self
        }
        /// <p>Specifies the S3 Intelligent-Tiering storage class tier of the configuration.</p>
        pub fn set_tierings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tiering>>,
        ) -> Self {
            self.tierings = input;
            self
        }
        /// Consumes the builder and constructs a [`IntelligentTieringConfiguration`](crate::model::IntelligentTieringConfiguration)
        pub fn build(self) -> crate::model::IntelligentTieringConfiguration {
            crate::model::IntelligentTieringConfiguration {
                id: self.id,
                filter: self.filter,
                status: self.status,
                tierings: self.tierings,
            }
        }
    }
}
impl IntelligentTieringConfiguration {
    /// Creates a new builder-style object to manufacture [`IntelligentTieringConfiguration`](crate::model::IntelligentTieringConfiguration)
    pub fn builder() -> crate::model::intelligent_tiering_configuration::Builder {
        crate::model::intelligent_tiering_configuration::Builder::default()
    }
}

/// <p>The S3 Intelligent-Tiering storage class is designed to optimize storage costs by automatically moving data to the most cost-effective storage access tier, without additional operational overhead.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tiering {
    /// <p>The number of consecutive days of no access after which an object will be eligible to be transitioned to the corresponding tier. The minimum number of days specified for Archive Access tier must be at least 90 days and Deep Archive Access tier must be at least 180 days. The maximum can be up to 2 years (730 days).</p>
    pub days: i32,
    /// <p>S3 Intelligent-Tiering access tier. See <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access">Storage class for automatically optimizing frequently and infrequently accessed objects</a> for a list of access tiers in the S3 Intelligent-Tiering storage class.</p>
    pub access_tier: std::option::Option<crate::model::IntelligentTieringAccessTier>,
}
impl Tiering {
    /// <p>The number of consecutive days of no access after which an object will be eligible to be transitioned to the corresponding tier. The minimum number of days specified for Archive Access tier must be at least 90 days and Deep Archive Access tier must be at least 180 days. The maximum can be up to 2 years (730 days).</p>
    pub fn days(&self) -> i32 {
        self.days
    }
    /// <p>S3 Intelligent-Tiering access tier. See <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access">Storage class for automatically optimizing frequently and infrequently accessed objects</a> for a list of access tiers in the S3 Intelligent-Tiering storage class.</p>
    pub fn access_tier(&self) -> std::option::Option<&crate::model::IntelligentTieringAccessTier> {
        self.access_tier.as_ref()
    }
}
impl std::fmt::Debug for Tiering {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tiering");
        formatter.field("days", &self.days);
        formatter.field("access_tier", &self.access_tier);
        formatter.finish()
    }
}
/// See [`Tiering`](crate::model::Tiering)
pub mod tiering {
    /// A builder for [`Tiering`](crate::model::Tiering)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) days: std::option::Option<i32>,
        pub(crate) access_tier: std::option::Option<crate::model::IntelligentTieringAccessTier>,
    }
    impl Builder {
        /// <p>The number of consecutive days of no access after which an object will be eligible to be transitioned to the corresponding tier. The minimum number of days specified for Archive Access tier must be at least 90 days and Deep Archive Access tier must be at least 180 days. The maximum can be up to 2 years (730 days).</p>
        pub fn days(mut self, input: i32) -> Self {
            self.days = Some(input);
            self
        }
        /// <p>The number of consecutive days of no access after which an object will be eligible to be transitioned to the corresponding tier. The minimum number of days specified for Archive Access tier must be at least 90 days and Deep Archive Access tier must be at least 180 days. The maximum can be up to 2 years (730 days).</p>
        pub fn set_days(mut self, input: std::option::Option<i32>) -> Self {
            self.days = input;
            self
        }
        /// <p>S3 Intelligent-Tiering access tier. See <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access">Storage class for automatically optimizing frequently and infrequently accessed objects</a> for a list of access tiers in the S3 Intelligent-Tiering storage class.</p>
        pub fn access_tier(mut self, input: crate::model::IntelligentTieringAccessTier) -> Self {
            self.access_tier = Some(input);
            self
        }
        /// <p>S3 Intelligent-Tiering access tier. See <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access">Storage class for automatically optimizing frequently and infrequently accessed objects</a> for a list of access tiers in the S3 Intelligent-Tiering storage class.</p>
        pub fn set_access_tier(
            mut self,
            input: std::option::Option<crate::model::IntelligentTieringAccessTier>,
        ) -> Self {
            self.access_tier = input;
            self
        }
        /// Consumes the builder and constructs a [`Tiering`](crate::model::Tiering)
        pub fn build(self) -> crate::model::Tiering {
            crate::model::Tiering {
                days: self.days.unwrap_or_default(),
                access_tier: self.access_tier,
            }
        }
    }
}
impl Tiering {
    /// Creates a new builder-style object to manufacture [`Tiering`](crate::model::Tiering)
    pub fn builder() -> crate::model::tiering::Builder {
        crate::model::tiering::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IntelligentTieringAccessTier {
    #[allow(missing_docs)] // documentation missing in model
    ArchiveAccess,
    #[allow(missing_docs)] // documentation missing in model
    DeepArchiveAccess,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IntelligentTieringAccessTier {
    fn from(s: &str) -> Self {
        match s {
            "ARCHIVE_ACCESS" => IntelligentTieringAccessTier::ArchiveAccess,
            "DEEP_ARCHIVE_ACCESS" => IntelligentTieringAccessTier::DeepArchiveAccess,
            other => IntelligentTieringAccessTier::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IntelligentTieringAccessTier {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IntelligentTieringAccessTier::from(s))
    }
}
impl IntelligentTieringAccessTier {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IntelligentTieringAccessTier::ArchiveAccess => "ARCHIVE_ACCESS",
            IntelligentTieringAccessTier::DeepArchiveAccess => "DEEP_ARCHIVE_ACCESS",
            IntelligentTieringAccessTier::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ARCHIVE_ACCESS", "DEEP_ARCHIVE_ACCESS"]
    }
}
impl AsRef<str> for IntelligentTieringAccessTier {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IntelligentTieringStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IntelligentTieringStatus {
    fn from(s: &str) -> Self {
        match s {
            "Disabled" => IntelligentTieringStatus::Disabled,
            "Enabled" => IntelligentTieringStatus::Enabled,
            other => IntelligentTieringStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IntelligentTieringStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IntelligentTieringStatus::from(s))
    }
}
impl IntelligentTieringStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IntelligentTieringStatus::Disabled => "Disabled",
            IntelligentTieringStatus::Enabled => "Enabled",
            IntelligentTieringStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Disabled", "Enabled"]
    }
}
impl AsRef<str> for IntelligentTieringStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The <code>Filter</code> is used to identify objects that the S3 Intelligent-Tiering configuration applies to.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IntelligentTieringFilter {
    /// <p>An object key name prefix that identifies the subset of objects to which the rule applies.</p> <important>
    /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
    /// </important>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>A container of a key value name pair.</p>
    pub tag: std::option::Option<crate::model::Tag>,
    /// <p>A conjunction (logical AND) of predicates, which is used in evaluating a metrics filter. The operator must have at least two predicates, and an object must match all of the predicates in order for the filter to apply.</p>
    pub and: std::option::Option<crate::model::IntelligentTieringAndOperator>,
}
impl IntelligentTieringFilter {
    /// <p>An object key name prefix that identifies the subset of objects to which the rule applies.</p> <important>
    /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
    /// </important>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>A container of a key value name pair.</p>
    pub fn tag(&self) -> std::option::Option<&crate::model::Tag> {
        self.tag.as_ref()
    }
    /// <p>A conjunction (logical AND) of predicates, which is used in evaluating a metrics filter. The operator must have at least two predicates, and an object must match all of the predicates in order for the filter to apply.</p>
    pub fn and(&self) -> std::option::Option<&crate::model::IntelligentTieringAndOperator> {
        self.and.as_ref()
    }
}
impl std::fmt::Debug for IntelligentTieringFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IntelligentTieringFilter");
        formatter.field("prefix", &self.prefix);
        formatter.field("tag", &self.tag);
        formatter.field("and", &self.and);
        formatter.finish()
    }
}
/// See [`IntelligentTieringFilter`](crate::model::IntelligentTieringFilter)
pub mod intelligent_tiering_filter {
    /// A builder for [`IntelligentTieringFilter`](crate::model::IntelligentTieringFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) tag: std::option::Option<crate::model::Tag>,
        pub(crate) and: std::option::Option<crate::model::IntelligentTieringAndOperator>,
    }
    impl Builder {
        /// <p>An object key name prefix that identifies the subset of objects to which the rule applies.</p> <important>
        /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
        /// </important>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>An object key name prefix that identifies the subset of objects to which the rule applies.</p> <important>
        /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
        /// </important>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>A container of a key value name pair.</p>
        pub fn tag(mut self, input: crate::model::Tag) -> Self {
            self.tag = Some(input);
            self
        }
        /// <p>A container of a key value name pair.</p>
        pub fn set_tag(mut self, input: std::option::Option<crate::model::Tag>) -> Self {
            self.tag = input;
            self
        }
        /// <p>A conjunction (logical AND) of predicates, which is used in evaluating a metrics filter. The operator must have at least two predicates, and an object must match all of the predicates in order for the filter to apply.</p>
        pub fn and(mut self, input: crate::model::IntelligentTieringAndOperator) -> Self {
            self.and = Some(input);
            self
        }
        /// <p>A conjunction (logical AND) of predicates, which is used in evaluating a metrics filter. The operator must have at least two predicates, and an object must match all of the predicates in order for the filter to apply.</p>
        pub fn set_and(
            mut self,
            input: std::option::Option<crate::model::IntelligentTieringAndOperator>,
        ) -> Self {
            self.and = input;
            self
        }
        /// Consumes the builder and constructs a [`IntelligentTieringFilter`](crate::model::IntelligentTieringFilter)
        pub fn build(self) -> crate::model::IntelligentTieringFilter {
            crate::model::IntelligentTieringFilter {
                prefix: self.prefix,
                tag: self.tag,
                and: self.and,
            }
        }
    }
}
impl IntelligentTieringFilter {
    /// Creates a new builder-style object to manufacture [`IntelligentTieringFilter`](crate::model::IntelligentTieringFilter)
    pub fn builder() -> crate::model::intelligent_tiering_filter::Builder {
        crate::model::intelligent_tiering_filter::Builder::default()
    }
}

/// <p>A container for specifying S3 Intelligent-Tiering filters. The filters determine the subset of objects to which the rule applies.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IntelligentTieringAndOperator {
    /// <p>An object key name prefix that identifies the subset of objects to which the configuration applies.</p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>All of these tags must exist in the object's tag set in order for the configuration to apply.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl IntelligentTieringAndOperator {
    /// <p>An object key name prefix that identifies the subset of objects to which the configuration applies.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>All of these tags must exist in the object's tag set in order for the configuration to apply.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for IntelligentTieringAndOperator {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IntelligentTieringAndOperator");
        formatter.field("prefix", &self.prefix);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`IntelligentTieringAndOperator`](crate::model::IntelligentTieringAndOperator)
pub mod intelligent_tiering_and_operator {
    /// A builder for [`IntelligentTieringAndOperator`](crate::model::IntelligentTieringAndOperator)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>An object key name prefix that identifies the subset of objects to which the configuration applies.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>An object key name prefix that identifies the subset of objects to which the configuration applies.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>All of these tags must exist in the object's tag set in order for the configuration to apply.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>All of these tags must exist in the object's tag set in order for the configuration to apply.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`IntelligentTieringAndOperator`](crate::model::IntelligentTieringAndOperator)
        pub fn build(self) -> crate::model::IntelligentTieringAndOperator {
            crate::model::IntelligentTieringAndOperator {
                prefix: self.prefix,
                tags: self.tags,
            }
        }
    }
}
impl IntelligentTieringAndOperator {
    /// Creates a new builder-style object to manufacture [`IntelligentTieringAndOperator`](crate::model::IntelligentTieringAndOperator)
    pub fn builder() -> crate::model::intelligent_tiering_and_operator::Builder {
        crate::model::intelligent_tiering_and_operator::Builder::default()
    }
}

/// <p>Specifies the default server-side-encryption configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerSideEncryptionConfiguration {
    /// <p>Container for information about a particular server-side encryption configuration rule.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::ServerSideEncryptionRule>>,
}
impl ServerSideEncryptionConfiguration {
    /// <p>Container for information about a particular server-side encryption configuration rule.</p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::ServerSideEncryptionRule]> {
        self.rules.as_deref()
    }
}
impl std::fmt::Debug for ServerSideEncryptionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerSideEncryptionConfiguration");
        formatter.field("rules", &self.rules);
        formatter.finish()
    }
}
/// See [`ServerSideEncryptionConfiguration`](crate::model::ServerSideEncryptionConfiguration)
pub mod server_side_encryption_configuration {
    /// A builder for [`ServerSideEncryptionConfiguration`](crate::model::ServerSideEncryptionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rules:
            std::option::Option<std::vec::Vec<crate::model::ServerSideEncryptionRule>>,
    }
    impl Builder {
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>Container for information about a particular server-side encryption configuration rule.</p>
        pub fn rules(mut self, input: crate::model::ServerSideEncryptionRule) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input);
            self.rules = Some(v);
            self
        }
        /// <p>Container for information about a particular server-side encryption configuration rule.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServerSideEncryptionRule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerSideEncryptionConfiguration`](crate::model::ServerSideEncryptionConfiguration)
        pub fn build(self) -> crate::model::ServerSideEncryptionConfiguration {
            crate::model::ServerSideEncryptionConfiguration { rules: self.rules }
        }
    }
}
impl ServerSideEncryptionConfiguration {
    /// Creates a new builder-style object to manufacture [`ServerSideEncryptionConfiguration`](crate::model::ServerSideEncryptionConfiguration)
    pub fn builder() -> crate::model::server_side_encryption_configuration::Builder {
        crate::model::server_side_encryption_configuration::Builder::default()
    }
}

/// <p>Specifies the default server-side encryption configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerSideEncryptionRule {
    /// <p>Specifies the default server-side encryption to apply to new objects in the bucket. If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied.</p>
    pub apply_server_side_encryption_by_default:
        std::option::Option<crate::model::ServerSideEncryptionByDefault>,
    /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key with server-side encryption using KMS (SSE-KMS) for new objects in the bucket. Existing objects are not affected. Setting the <code>BucketKeyEnabled</code> element to <code>true</code> causes Amazon S3 to use an S3 Bucket Key. By default, S3 Bucket Key is not enabled.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html">Amazon S3 Bucket Keys</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub bucket_key_enabled: bool,
}
impl ServerSideEncryptionRule {
    /// <p>Specifies the default server-side encryption to apply to new objects in the bucket. If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied.</p>
    pub fn apply_server_side_encryption_by_default(
        &self,
    ) -> std::option::Option<&crate::model::ServerSideEncryptionByDefault> {
        self.apply_server_side_encryption_by_default.as_ref()
    }
    /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key with server-side encryption using KMS (SSE-KMS) for new objects in the bucket. Existing objects are not affected. Setting the <code>BucketKeyEnabled</code> element to <code>true</code> causes Amazon S3 to use an S3 Bucket Key. By default, S3 Bucket Key is not enabled.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html">Amazon S3 Bucket Keys</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn bucket_key_enabled(&self) -> bool {
        self.bucket_key_enabled
    }
}
impl std::fmt::Debug for ServerSideEncryptionRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerSideEncryptionRule");
        formatter.field(
            "apply_server_side_encryption_by_default",
            &self.apply_server_side_encryption_by_default,
        );
        formatter.field("bucket_key_enabled", &self.bucket_key_enabled);
        formatter.finish()
    }
}
/// See [`ServerSideEncryptionRule`](crate::model::ServerSideEncryptionRule)
pub mod server_side_encryption_rule {
    /// A builder for [`ServerSideEncryptionRule`](crate::model::ServerSideEncryptionRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) apply_server_side_encryption_by_default:
            std::option::Option<crate::model::ServerSideEncryptionByDefault>,
        pub(crate) bucket_key_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies the default server-side encryption to apply to new objects in the bucket. If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied.</p>
        pub fn apply_server_side_encryption_by_default(
            mut self,
            input: crate::model::ServerSideEncryptionByDefault,
        ) -> Self {
            self.apply_server_side_encryption_by_default = Some(input);
            self
        }
        /// <p>Specifies the default server-side encryption to apply to new objects in the bucket. If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied.</p>
        pub fn set_apply_server_side_encryption_by_default(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryptionByDefault>,
        ) -> Self {
            self.apply_server_side_encryption_by_default = input;
            self
        }
        /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key with server-side encryption using KMS (SSE-KMS) for new objects in the bucket. Existing objects are not affected. Setting the <code>BucketKeyEnabled</code> element to <code>true</code> causes Amazon S3 to use an S3 Bucket Key. By default, S3 Bucket Key is not enabled.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html">Amazon S3 Bucket Keys</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket_key_enabled(mut self, input: bool) -> Self {
            self.bucket_key_enabled = Some(input);
            self
        }
        /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key with server-side encryption using KMS (SSE-KMS) for new objects in the bucket. Existing objects are not affected. Setting the <code>BucketKeyEnabled</code> element to <code>true</code> causes Amazon S3 to use an S3 Bucket Key. By default, S3 Bucket Key is not enabled.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html">Amazon S3 Bucket Keys</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket_key_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.bucket_key_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerSideEncryptionRule`](crate::model::ServerSideEncryptionRule)
        pub fn build(self) -> crate::model::ServerSideEncryptionRule {
            crate::model::ServerSideEncryptionRule {
                apply_server_side_encryption_by_default: self
                    .apply_server_side_encryption_by_default,
                bucket_key_enabled: self.bucket_key_enabled.unwrap_or_default(),
            }
        }
    }
}
impl ServerSideEncryptionRule {
    /// Creates a new builder-style object to manufacture [`ServerSideEncryptionRule`](crate::model::ServerSideEncryptionRule)
    pub fn builder() -> crate::model::server_side_encryption_rule::Builder {
        crate::model::server_side_encryption_rule::Builder::default()
    }
}

/// <p>Describes the default server-side encryption to apply to new objects in the bucket. If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied. If you don't specify a customer managed key at configuration, Amazon S3 automatically creates an Amazon Web Services KMS key in your Amazon Web Services account the first time that you add an object encrypted with SSE-KMS to a bucket. By default, Amazon S3 uses this KMS key for SSE-KMS. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTencryption.html">PUT Bucket encryption</a> in the <i>Amazon S3 API Reference</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerSideEncryptionByDefault {
    /// <p>Server-side encryption algorithm to use for the default encryption.</p>
    pub sse_algorithm: std::option::Option<crate::model::ServerSideEncryption>,
    /// <p>Amazon Web Services Key Management Service (KMS) customer Amazon Web Services KMS key ID to use for the default encryption. This parameter is allowed if and only if <code>SSEAlgorithm</code> is set to <code>aws:kms</code>.</p>
    /// <p>You can specify the key ID or the Amazon Resource Name (ARN) of the KMS key. However, if you are using encryption with cross-account or Amazon Web Services service operations you must use a fully qualified KMS key ARN. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html#bucket-encryption-update-bucket-policy">Using encryption for cross-account operations</a>. </p>
    /// <p> <b>For example:</b> </p>
    /// <ul>
    /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
    /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
    /// </ul> <important>
    /// <p>Amazon S3 only supports symmetric KMS keys and not asymmetric KMS keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>
    /// </important>
    pub kms_master_key_id: std::option::Option<std::string::String>,
}
impl ServerSideEncryptionByDefault {
    /// <p>Server-side encryption algorithm to use for the default encryption.</p>
    pub fn sse_algorithm(&self) -> std::option::Option<&crate::model::ServerSideEncryption> {
        self.sse_algorithm.as_ref()
    }
    /// <p>Amazon Web Services Key Management Service (KMS) customer Amazon Web Services KMS key ID to use for the default encryption. This parameter is allowed if and only if <code>SSEAlgorithm</code> is set to <code>aws:kms</code>.</p>
    /// <p>You can specify the key ID or the Amazon Resource Name (ARN) of the KMS key. However, if you are using encryption with cross-account or Amazon Web Services service operations you must use a fully qualified KMS key ARN. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html#bucket-encryption-update-bucket-policy">Using encryption for cross-account operations</a>. </p>
    /// <p> <b>For example:</b> </p>
    /// <ul>
    /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
    /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
    /// </ul> <important>
    /// <p>Amazon S3 only supports symmetric KMS keys and not asymmetric KMS keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>
    /// </important>
    pub fn kms_master_key_id(&self) -> std::option::Option<&str> {
        self.kms_master_key_id.as_deref()
    }
}
impl std::fmt::Debug for ServerSideEncryptionByDefault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerSideEncryptionByDefault");
        formatter.field("sse_algorithm", &self.sse_algorithm);
        formatter.field("kms_master_key_id", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ServerSideEncryptionByDefault`](crate::model::ServerSideEncryptionByDefault)
pub mod server_side_encryption_by_default {
    /// A builder for [`ServerSideEncryptionByDefault`](crate::model::ServerSideEncryptionByDefault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sse_algorithm: std::option::Option<crate::model::ServerSideEncryption>,
        pub(crate) kms_master_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Server-side encryption algorithm to use for the default encryption.</p>
        pub fn sse_algorithm(mut self, input: crate::model::ServerSideEncryption) -> Self {
            self.sse_algorithm = Some(input);
            self
        }
        /// <p>Server-side encryption algorithm to use for the default encryption.</p>
        pub fn set_sse_algorithm(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryption>,
        ) -> Self {
            self.sse_algorithm = input;
            self
        }
        /// <p>Amazon Web Services Key Management Service (KMS) customer Amazon Web Services KMS key ID to use for the default encryption. This parameter is allowed if and only if <code>SSEAlgorithm</code> is set to <code>aws:kms</code>.</p>
        /// <p>You can specify the key ID or the Amazon Resource Name (ARN) of the KMS key. However, if you are using encryption with cross-account or Amazon Web Services service operations you must use a fully qualified KMS key ARN. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html#bucket-encryption-update-bucket-policy">Using encryption for cross-account operations</a>. </p>
        /// <p> <b>For example:</b> </p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul> <important>
        /// <p>Amazon S3 only supports symmetric KMS keys and not asymmetric KMS keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>
        /// </important>
        pub fn kms_master_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_master_key_id = Some(input.into());
            self
        }
        /// <p>Amazon Web Services Key Management Service (KMS) customer Amazon Web Services KMS key ID to use for the default encryption. This parameter is allowed if and only if <code>SSEAlgorithm</code> is set to <code>aws:kms</code>.</p>
        /// <p>You can specify the key ID or the Amazon Resource Name (ARN) of the KMS key. However, if you are using encryption with cross-account or Amazon Web Services service operations you must use a fully qualified KMS key ARN. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html#bucket-encryption-update-bucket-policy">Using encryption for cross-account operations</a>. </p>
        /// <p> <b>For example:</b> </p>
        /// <ul>
        /// <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// <li> <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li>
        /// </ul> <important>
        /// <p>Amazon S3 only supports symmetric KMS keys and not asymmetric KMS keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>
        /// </important>
        pub fn set_kms_master_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.kms_master_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerSideEncryptionByDefault`](crate::model::ServerSideEncryptionByDefault)
        pub fn build(self) -> crate::model::ServerSideEncryptionByDefault {
            crate::model::ServerSideEncryptionByDefault {
                sse_algorithm: self.sse_algorithm,
                kms_master_key_id: self.kms_master_key_id,
            }
        }
    }
}
impl ServerSideEncryptionByDefault {
    /// Creates a new builder-style object to manufacture [`ServerSideEncryptionByDefault`](crate::model::ServerSideEncryptionByDefault)
    pub fn builder() -> crate::model::server_side_encryption_by_default::Builder {
        crate::model::server_side_encryption_by_default::Builder::default()
    }
}

/// <p>Describes the cross-origin access configuration for objects in an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">Enabling Cross-Origin Resource Sharing</a> in the <i>Amazon S3 User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CorsConfiguration {
    /// <p>A set of origins and methods (cross-origin access that you want to allow). You can add up to 100 rules to the configuration.</p>
    pub cors_rules: std::option::Option<std::vec::Vec<crate::model::CorsRule>>,
}
impl CorsConfiguration {
    /// <p>A set of origins and methods (cross-origin access that you want to allow). You can add up to 100 rules to the configuration.</p>
    pub fn cors_rules(&self) -> std::option::Option<&[crate::model::CorsRule]> {
        self.cors_rules.as_deref()
    }
}
impl std::fmt::Debug for CorsConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CorsConfiguration");
        formatter.field("cors_rules", &self.cors_rules);
        formatter.finish()
    }
}
/// See [`CorsConfiguration`](crate::model::CorsConfiguration)
pub mod cors_configuration {
    /// A builder for [`CorsConfiguration`](crate::model::CorsConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cors_rules: std::option::Option<std::vec::Vec<crate::model::CorsRule>>,
    }
    impl Builder {
        /// Appends an item to `cors_rules`.
        ///
        /// To override the contents of this collection use [`set_cors_rules`](Self::set_cors_rules).
        ///
        /// <p>A set of origins and methods (cross-origin access that you want to allow). You can add up to 100 rules to the configuration.</p>
        pub fn cors_rules(mut self, input: crate::model::CorsRule) -> Self {
            let mut v = self.cors_rules.unwrap_or_default();
            v.push(input);
            self.cors_rules = Some(v);
            self
        }
        /// <p>A set of origins and methods (cross-origin access that you want to allow). You can add up to 100 rules to the configuration.</p>
        pub fn set_cors_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CorsRule>>,
        ) -> Self {
            self.cors_rules = input;
            self
        }
        /// Consumes the builder and constructs a [`CorsConfiguration`](crate::model::CorsConfiguration)
        pub fn build(self) -> crate::model::CorsConfiguration {
            crate::model::CorsConfiguration {
                cors_rules: self.cors_rules,
            }
        }
    }
}
impl CorsConfiguration {
    /// Creates a new builder-style object to manufacture [`CorsConfiguration`](crate::model::CorsConfiguration)
    pub fn builder() -> crate::model::cors_configuration::Builder {
        crate::model::cors_configuration::Builder::default()
    }
}

/// <p>Specifies a cross-origin access rule for an Amazon S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CorsRule {
    /// <p>Unique identifier for the rule. The value cannot be longer than 255 characters.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Headers that are specified in the <code>Access-Control-Request-Headers</code> header. These headers are allowed in a preflight OPTIONS request. In response to any preflight OPTIONS request, Amazon S3 returns any requested headers that are allowed.</p>
    pub allowed_headers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An HTTP method that you allow the origin to execute. Valid values are <code>GET</code>, <code>PUT</code>, <code>HEAD</code>, <code>POST</code>, and <code>DELETE</code>.</p>
    pub allowed_methods: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>One or more origins you want customers to be able to access the bucket from.</p>
    pub allowed_origins: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>One or more headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript <code>XMLHttpRequest</code> object).</p>
    pub expose_headers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The time in seconds that your browser is to cache the preflight response for the specified resource.</p>
    pub max_age_seconds: i32,
}
impl CorsRule {
    /// <p>Unique identifier for the rule. The value cannot be longer than 255 characters.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Headers that are specified in the <code>Access-Control-Request-Headers</code> header. These headers are allowed in a preflight OPTIONS request. In response to any preflight OPTIONS request, Amazon S3 returns any requested headers that are allowed.</p>
    pub fn allowed_headers(&self) -> std::option::Option<&[std::string::String]> {
        self.allowed_headers.as_deref()
    }
    /// <p>An HTTP method that you allow the origin to execute. Valid values are <code>GET</code>, <code>PUT</code>, <code>HEAD</code>, <code>POST</code>, and <code>DELETE</code>.</p>
    pub fn allowed_methods(&self) -> std::option::Option<&[std::string::String]> {
        self.allowed_methods.as_deref()
    }
    /// <p>One or more origins you want customers to be able to access the bucket from.</p>
    pub fn allowed_origins(&self) -> std::option::Option<&[std::string::String]> {
        self.allowed_origins.as_deref()
    }
    /// <p>One or more headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript <code>XMLHttpRequest</code> object).</p>
    pub fn expose_headers(&self) -> std::option::Option<&[std::string::String]> {
        self.expose_headers.as_deref()
    }
    /// <p>The time in seconds that your browser is to cache the preflight response for the specified resource.</p>
    pub fn max_age_seconds(&self) -> i32 {
        self.max_age_seconds
    }
}
impl std::fmt::Debug for CorsRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CorsRule");
        formatter.field("id", &self.id);
        formatter.field("allowed_headers", &self.allowed_headers);
        formatter.field("allowed_methods", &self.allowed_methods);
        formatter.field("allowed_origins", &self.allowed_origins);
        formatter.field("expose_headers", &self.expose_headers);
        formatter.field("max_age_seconds", &self.max_age_seconds);
        formatter.finish()
    }
}
/// See [`CorsRule`](crate::model::CorsRule)
pub mod cors_rule {
    /// A builder for [`CorsRule`](crate::model::CorsRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) allowed_headers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) allowed_methods: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) allowed_origins: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) expose_headers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) max_age_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Unique identifier for the rule. The value cannot be longer than 255 characters.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>Unique identifier for the rule. The value cannot be longer than 255 characters.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Appends an item to `allowed_headers`.
        ///
        /// To override the contents of this collection use [`set_allowed_headers`](Self::set_allowed_headers).
        ///
        /// <p>Headers that are specified in the <code>Access-Control-Request-Headers</code> header. These headers are allowed in a preflight OPTIONS request. In response to any preflight OPTIONS request, Amazon S3 returns any requested headers that are allowed.</p>
        pub fn allowed_headers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.allowed_headers.unwrap_or_default();
            v.push(input.into());
            self.allowed_headers = Some(v);
            self
        }
        /// <p>Headers that are specified in the <code>Access-Control-Request-Headers</code> header. These headers are allowed in a preflight OPTIONS request. In response to any preflight OPTIONS request, Amazon S3 returns any requested headers that are allowed.</p>
        pub fn set_allowed_headers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.allowed_headers = input;
            self
        }
        /// Appends an item to `allowed_methods`.
        ///
        /// To override the contents of this collection use [`set_allowed_methods`](Self::set_allowed_methods).
        ///
        /// <p>An HTTP method that you allow the origin to execute. Valid values are <code>GET</code>, <code>PUT</code>, <code>HEAD</code>, <code>POST</code>, and <code>DELETE</code>.</p>
        pub fn allowed_methods(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.allowed_methods.unwrap_or_default();
            v.push(input.into());
            self.allowed_methods = Some(v);
            self
        }
        /// <p>An HTTP method that you allow the origin to execute. Valid values are <code>GET</code>, <code>PUT</code>, <code>HEAD</code>, <code>POST</code>, and <code>DELETE</code>.</p>
        pub fn set_allowed_methods(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.allowed_methods = input;
            self
        }
        /// Appends an item to `allowed_origins`.
        ///
        /// To override the contents of this collection use [`set_allowed_origins`](Self::set_allowed_origins).
        ///
        /// <p>One or more origins you want customers to be able to access the bucket from.</p>
        pub fn allowed_origins(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.allowed_origins.unwrap_or_default();
            v.push(input.into());
            self.allowed_origins = Some(v);
            self
        }
        /// <p>One or more origins you want customers to be able to access the bucket from.</p>
        pub fn set_allowed_origins(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.allowed_origins = input;
            self
        }
        /// Appends an item to `expose_headers`.
        ///
        /// To override the contents of this collection use [`set_expose_headers`](Self::set_expose_headers).
        ///
        /// <p>One or more headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript <code>XMLHttpRequest</code> object).</p>
        pub fn expose_headers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.expose_headers.unwrap_or_default();
            v.push(input.into());
            self.expose_headers = Some(v);
            self
        }
        /// <p>One or more headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript <code>XMLHttpRequest</code> object).</p>
        pub fn set_expose_headers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.expose_headers = input;
            self
        }
        /// <p>The time in seconds that your browser is to cache the preflight response for the specified resource.</p>
        pub fn max_age_seconds(mut self, input: i32) -> Self {
            self.max_age_seconds = Some(input);
            self
        }
        /// <p>The time in seconds that your browser is to cache the preflight response for the specified resource.</p>
        pub fn set_max_age_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.max_age_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`CorsRule`](crate::model::CorsRule)
        pub fn build(self) -> crate::model::CorsRule {
            crate::model::CorsRule {
                id: self.id,
                allowed_headers: self.allowed_headers,
                allowed_methods: self.allowed_methods,
                allowed_origins: self.allowed_origins,
                expose_headers: self.expose_headers,
                max_age_seconds: self.max_age_seconds.unwrap_or_default(),
            }
        }
    }
}
impl CorsRule {
    /// Creates a new builder-style object to manufacture [`CorsRule`](crate::model::CorsRule)
    pub fn builder() -> crate::model::cors_rule::Builder {
        crate::model::cors_rule::Builder::default()
    }
}

/// <p>Specifies the configuration and any analyses for the analytics filter of an Amazon S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalyticsConfiguration {
    /// <p>The ID that identifies the analytics configuration.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The filter used to describe a set of objects for analyses. A filter must have exactly one prefix, one tag, or one conjunction (AnalyticsAndOperator). If no filter is provided, all objects will be considered in any analysis.</p>
    pub filter: std::option::Option<crate::model::AnalyticsFilter>,
    /// <p> Contains data related to access patterns to be collected and made available to analyze the tradeoffs between different storage classes. </p>
    pub storage_class_analysis: std::option::Option<crate::model::StorageClassAnalysis>,
}
impl AnalyticsConfiguration {
    /// <p>The ID that identifies the analytics configuration.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The filter used to describe a set of objects for analyses. A filter must have exactly one prefix, one tag, or one conjunction (AnalyticsAndOperator). If no filter is provided, all objects will be considered in any analysis.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::AnalyticsFilter> {
        self.filter.as_ref()
    }
    /// <p> Contains data related to access patterns to be collected and made available to analyze the tradeoffs between different storage classes. </p>
    pub fn storage_class_analysis(
        &self,
    ) -> std::option::Option<&crate::model::StorageClassAnalysis> {
        self.storage_class_analysis.as_ref()
    }
}
impl std::fmt::Debug for AnalyticsConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalyticsConfiguration");
        formatter.field("id", &self.id);
        formatter.field("filter", &self.filter);
        formatter.field("storage_class_analysis", &self.storage_class_analysis);
        formatter.finish()
    }
}
/// See [`AnalyticsConfiguration`](crate::model::AnalyticsConfiguration)
pub mod analytics_configuration {
    /// A builder for [`AnalyticsConfiguration`](crate::model::AnalyticsConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) filter: std::option::Option<crate::model::AnalyticsFilter>,
        pub(crate) storage_class_analysis: std::option::Option<crate::model::StorageClassAnalysis>,
    }
    impl Builder {
        /// <p>The ID that identifies the analytics configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID that identifies the analytics configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The filter used to describe a set of objects for analyses. A filter must have exactly one prefix, one tag, or one conjunction (AnalyticsAndOperator). If no filter is provided, all objects will be considered in any analysis.</p>
        pub fn filter(mut self, input: crate::model::AnalyticsFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>The filter used to describe a set of objects for analyses. A filter must have exactly one prefix, one tag, or one conjunction (AnalyticsAndOperator). If no filter is provided, all objects will be considered in any analysis.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::AnalyticsFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p> Contains data related to access patterns to be collected and made available to analyze the tradeoffs between different storage classes. </p>
        pub fn storage_class_analysis(mut self, input: crate::model::StorageClassAnalysis) -> Self {
            self.storage_class_analysis = Some(input);
            self
        }
        /// <p> Contains data related to access patterns to be collected and made available to analyze the tradeoffs between different storage classes. </p>
        pub fn set_storage_class_analysis(
            mut self,
            input: std::option::Option<crate::model::StorageClassAnalysis>,
        ) -> Self {
            self.storage_class_analysis = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalyticsConfiguration`](crate::model::AnalyticsConfiguration)
        pub fn build(self) -> crate::model::AnalyticsConfiguration {
            crate::model::AnalyticsConfiguration {
                id: self.id,
                filter: self.filter,
                storage_class_analysis: self.storage_class_analysis,
            }
        }
    }
}
impl AnalyticsConfiguration {
    /// Creates a new builder-style object to manufacture [`AnalyticsConfiguration`](crate::model::AnalyticsConfiguration)
    pub fn builder() -> crate::model::analytics_configuration::Builder {
        crate::model::analytics_configuration::Builder::default()
    }
}

/// <p>Specifies data related to access patterns to be collected and made available to analyze the tradeoffs between different storage classes for an Amazon S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StorageClassAnalysis {
    /// <p>Specifies how data related to the storage class analysis for an Amazon S3 bucket should be exported.</p>
    pub data_export: std::option::Option<crate::model::StorageClassAnalysisDataExport>,
}
impl StorageClassAnalysis {
    /// <p>Specifies how data related to the storage class analysis for an Amazon S3 bucket should be exported.</p>
    pub fn data_export(
        &self,
    ) -> std::option::Option<&crate::model::StorageClassAnalysisDataExport> {
        self.data_export.as_ref()
    }
}
impl std::fmt::Debug for StorageClassAnalysis {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StorageClassAnalysis");
        formatter.field("data_export", &self.data_export);
        formatter.finish()
    }
}
/// See [`StorageClassAnalysis`](crate::model::StorageClassAnalysis)
pub mod storage_class_analysis {
    /// A builder for [`StorageClassAnalysis`](crate::model::StorageClassAnalysis)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_export: std::option::Option<crate::model::StorageClassAnalysisDataExport>,
    }
    impl Builder {
        /// <p>Specifies how data related to the storage class analysis for an Amazon S3 bucket should be exported.</p>
        pub fn data_export(mut self, input: crate::model::StorageClassAnalysisDataExport) -> Self {
            self.data_export = Some(input);
            self
        }
        /// <p>Specifies how data related to the storage class analysis for an Amazon S3 bucket should be exported.</p>
        pub fn set_data_export(
            mut self,
            input: std::option::Option<crate::model::StorageClassAnalysisDataExport>,
        ) -> Self {
            self.data_export = input;
            self
        }
        /// Consumes the builder and constructs a [`StorageClassAnalysis`](crate::model::StorageClassAnalysis)
        pub fn build(self) -> crate::model::StorageClassAnalysis {
            crate::model::StorageClassAnalysis {
                data_export: self.data_export,
            }
        }
    }
}
impl StorageClassAnalysis {
    /// Creates a new builder-style object to manufacture [`StorageClassAnalysis`](crate::model::StorageClassAnalysis)
    pub fn builder() -> crate::model::storage_class_analysis::Builder {
        crate::model::storage_class_analysis::Builder::default()
    }
}

/// <p>Container for data related to the storage class analysis for an Amazon S3 bucket for export.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StorageClassAnalysisDataExport {
    /// <p>The version of the output schema to use when exporting data. Must be <code>V_1</code>.</p>
    pub output_schema_version: std::option::Option<crate::model::StorageClassAnalysisSchemaVersion>,
    /// <p>The place to store the data for an analysis.</p>
    pub destination: std::option::Option<crate::model::AnalyticsExportDestination>,
}
impl StorageClassAnalysisDataExport {
    /// <p>The version of the output schema to use when exporting data. Must be <code>V_1</code>.</p>
    pub fn output_schema_version(
        &self,
    ) -> std::option::Option<&crate::model::StorageClassAnalysisSchemaVersion> {
        self.output_schema_version.as_ref()
    }
    /// <p>The place to store the data for an analysis.</p>
    pub fn destination(&self) -> std::option::Option<&crate::model::AnalyticsExportDestination> {
        self.destination.as_ref()
    }
}
impl std::fmt::Debug for StorageClassAnalysisDataExport {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StorageClassAnalysisDataExport");
        formatter.field("output_schema_version", &self.output_schema_version);
        formatter.field("destination", &self.destination);
        formatter.finish()
    }
}
/// See [`StorageClassAnalysisDataExport`](crate::model::StorageClassAnalysisDataExport)
pub mod storage_class_analysis_data_export {
    /// A builder for [`StorageClassAnalysisDataExport`](crate::model::StorageClassAnalysisDataExport)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) output_schema_version:
            std::option::Option<crate::model::StorageClassAnalysisSchemaVersion>,
        pub(crate) destination: std::option::Option<crate::model::AnalyticsExportDestination>,
    }
    impl Builder {
        /// <p>The version of the output schema to use when exporting data. Must be <code>V_1</code>.</p>
        pub fn output_schema_version(
            mut self,
            input: crate::model::StorageClassAnalysisSchemaVersion,
        ) -> Self {
            self.output_schema_version = Some(input);
            self
        }
        /// <p>The version of the output schema to use when exporting data. Must be <code>V_1</code>.</p>
        pub fn set_output_schema_version(
            mut self,
            input: std::option::Option<crate::model::StorageClassAnalysisSchemaVersion>,
        ) -> Self {
            self.output_schema_version = input;
            self
        }
        /// <p>The place to store the data for an analysis.</p>
        pub fn destination(mut self, input: crate::model::AnalyticsExportDestination) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>The place to store the data for an analysis.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::AnalyticsExportDestination>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// Consumes the builder and constructs a [`StorageClassAnalysisDataExport`](crate::model::StorageClassAnalysisDataExport)
        pub fn build(self) -> crate::model::StorageClassAnalysisDataExport {
            crate::model::StorageClassAnalysisDataExport {
                output_schema_version: self.output_schema_version,
                destination: self.destination,
            }
        }
    }
}
impl StorageClassAnalysisDataExport {
    /// Creates a new builder-style object to manufacture [`StorageClassAnalysisDataExport`](crate::model::StorageClassAnalysisDataExport)
    pub fn builder() -> crate::model::storage_class_analysis_data_export::Builder {
        crate::model::storage_class_analysis_data_export::Builder::default()
    }
}

/// <p>Where to publish the analytics results.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalyticsExportDestination {
    /// <p>A destination signifying output to an S3 bucket.</p>
    pub s3_bucket_destination: std::option::Option<crate::model::AnalyticsS3BucketDestination>,
}
impl AnalyticsExportDestination {
    /// <p>A destination signifying output to an S3 bucket.</p>
    pub fn s3_bucket_destination(
        &self,
    ) -> std::option::Option<&crate::model::AnalyticsS3BucketDestination> {
        self.s3_bucket_destination.as_ref()
    }
}
impl std::fmt::Debug for AnalyticsExportDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalyticsExportDestination");
        formatter.field("s3_bucket_destination", &self.s3_bucket_destination);
        formatter.finish()
    }
}
/// See [`AnalyticsExportDestination`](crate::model::AnalyticsExportDestination)
pub mod analytics_export_destination {
    /// A builder for [`AnalyticsExportDestination`](crate::model::AnalyticsExportDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_bucket_destination:
            std::option::Option<crate::model::AnalyticsS3BucketDestination>,
    }
    impl Builder {
        /// <p>A destination signifying output to an S3 bucket.</p>
        pub fn s3_bucket_destination(
            mut self,
            input: crate::model::AnalyticsS3BucketDestination,
        ) -> Self {
            self.s3_bucket_destination = Some(input);
            self
        }
        /// <p>A destination signifying output to an S3 bucket.</p>
        pub fn set_s3_bucket_destination(
            mut self,
            input: std::option::Option<crate::model::AnalyticsS3BucketDestination>,
        ) -> Self {
            self.s3_bucket_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalyticsExportDestination`](crate::model::AnalyticsExportDestination)
        pub fn build(self) -> crate::model::AnalyticsExportDestination {
            crate::model::AnalyticsExportDestination {
                s3_bucket_destination: self.s3_bucket_destination,
            }
        }
    }
}
impl AnalyticsExportDestination {
    /// Creates a new builder-style object to manufacture [`AnalyticsExportDestination`](crate::model::AnalyticsExportDestination)
    pub fn builder() -> crate::model::analytics_export_destination::Builder {
        crate::model::analytics_export_destination::Builder::default()
    }
}

/// <p>Contains information about where to publish the analytics results.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalyticsS3BucketDestination {
    /// <p>Specifies the file format used when exporting data to Amazon S3.</p>
    pub format: std::option::Option<crate::model::AnalyticsS3ExportFileFormat>,
    /// <p>The account ID that owns the destination S3 bucket. If no account ID is provided, the owner is not validated before exporting data.</p> <note>
    /// <p> Although this value is optional, we strongly recommend that you set it to help prevent problems if the destination bucket ownership changes. </p>
    /// </note>
    pub bucket_account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the bucket to which data is exported.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The prefix to use when exporting data. The prefix is prepended to all results.</p>
    pub prefix: std::option::Option<std::string::String>,
}
impl AnalyticsS3BucketDestination {
    /// <p>Specifies the file format used when exporting data to Amazon S3.</p>
    pub fn format(&self) -> std::option::Option<&crate::model::AnalyticsS3ExportFileFormat> {
        self.format.as_ref()
    }
    /// <p>The account ID that owns the destination S3 bucket. If no account ID is provided, the owner is not validated before exporting data.</p> <note>
    /// <p> Although this value is optional, we strongly recommend that you set it to help prevent problems if the destination bucket ownership changes. </p>
    /// </note>
    pub fn bucket_account_id(&self) -> std::option::Option<&str> {
        self.bucket_account_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the bucket to which data is exported.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The prefix to use when exporting data. The prefix is prepended to all results.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
}
impl std::fmt::Debug for AnalyticsS3BucketDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalyticsS3BucketDestination");
        formatter.field("format", &self.format);
        formatter.field("bucket_account_id", &self.bucket_account_id);
        formatter.field("bucket", &self.bucket);
        formatter.field("prefix", &self.prefix);
        formatter.finish()
    }
}
/// See [`AnalyticsS3BucketDestination`](crate::model::AnalyticsS3BucketDestination)
pub mod analytics_s3_bucket_destination {
    /// A builder for [`AnalyticsS3BucketDestination`](crate::model::AnalyticsS3BucketDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) format: std::option::Option<crate::model::AnalyticsS3ExportFileFormat>,
        pub(crate) bucket_account_id: std::option::Option<std::string::String>,
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the file format used when exporting data to Amazon S3.</p>
        pub fn format(mut self, input: crate::model::AnalyticsS3ExportFileFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>Specifies the file format used when exporting data to Amazon S3.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::AnalyticsS3ExportFileFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>The account ID that owns the destination S3 bucket. If no account ID is provided, the owner is not validated before exporting data.</p> <note>
        /// <p> Although this value is optional, we strongly recommend that you set it to help prevent problems if the destination bucket ownership changes. </p>
        /// </note>
        pub fn bucket_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_account_id = Some(input.into());
            self
        }
        /// <p>The account ID that owns the destination S3 bucket. If no account ID is provided, the owner is not validated before exporting data.</p> <note>
        /// <p> Although this value is optional, we strongly recommend that you set it to help prevent problems if the destination bucket ownership changes. </p>
        /// </note>
        pub fn set_bucket_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bucket_account_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bucket to which data is exported.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bucket to which data is exported.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The prefix to use when exporting data. The prefix is prepended to all results.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>The prefix to use when exporting data. The prefix is prepended to all results.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalyticsS3BucketDestination`](crate::model::AnalyticsS3BucketDestination)
        pub fn build(self) -> crate::model::AnalyticsS3BucketDestination {
            crate::model::AnalyticsS3BucketDestination {
                format: self.format,
                bucket_account_id: self.bucket_account_id,
                bucket: self.bucket,
                prefix: self.prefix,
            }
        }
    }
}
impl AnalyticsS3BucketDestination {
    /// Creates a new builder-style object to manufacture [`AnalyticsS3BucketDestination`](crate::model::AnalyticsS3BucketDestination)
    pub fn builder() -> crate::model::analytics_s3_bucket_destination::Builder {
        crate::model::analytics_s3_bucket_destination::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AnalyticsS3ExportFileFormat {
    #[allow(missing_docs)] // documentation missing in model
    Csv,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AnalyticsS3ExportFileFormat {
    fn from(s: &str) -> Self {
        match s {
            "CSV" => AnalyticsS3ExportFileFormat::Csv,
            other => AnalyticsS3ExportFileFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AnalyticsS3ExportFileFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AnalyticsS3ExportFileFormat::from(s))
    }
}
impl AnalyticsS3ExportFileFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AnalyticsS3ExportFileFormat::Csv => "CSV",
            AnalyticsS3ExportFileFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CSV"]
    }
}
impl AsRef<str> for AnalyticsS3ExportFileFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StorageClassAnalysisSchemaVersion {
    #[allow(missing_docs)] // documentation missing in model
    V1,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StorageClassAnalysisSchemaVersion {
    fn from(s: &str) -> Self {
        match s {
            "V_1" => StorageClassAnalysisSchemaVersion::V1,
            other => StorageClassAnalysisSchemaVersion::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StorageClassAnalysisSchemaVersion {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StorageClassAnalysisSchemaVersion::from(s))
    }
}
impl StorageClassAnalysisSchemaVersion {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StorageClassAnalysisSchemaVersion::V1 => "V_1",
            StorageClassAnalysisSchemaVersion::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["V_1"]
    }
}
impl AsRef<str> for StorageClassAnalysisSchemaVersion {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The filter used to describe a set of objects for analyses. A filter must have exactly one prefix, one tag, or one conjunction (AnalyticsAndOperator). If no filter is provided, all objects will be considered in any analysis.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum AnalyticsFilter {
    /// <p>A conjunction (logical AND) of predicates, which is used in evaluating an analytics filter. The operator must have at least two predicates.</p>
    And(crate::model::AnalyticsAndOperator),
    /// <p>The prefix to use when evaluating an analytics filter.</p>
    Prefix(std::string::String),
    /// <p>The tag to use when evaluating an analytics filter.</p>
    Tag(crate::model::Tag),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl AnalyticsFilter {
    /// Tries to convert the enum instance into [`And`](crate::model::AnalyticsFilter::And), extracting the inner [`AnalyticsAndOperator`](crate::model::AnalyticsAndOperator).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_and(&self) -> std::result::Result<&crate::model::AnalyticsAndOperator, &Self> {
        if let AnalyticsFilter::And(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`And`](crate::model::AnalyticsFilter::And).
    pub fn is_and(&self) -> bool {
        self.as_and().is_ok()
    }
    /// Tries to convert the enum instance into [`Prefix`](crate::model::AnalyticsFilter::Prefix), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_prefix(&self) -> std::result::Result<&std::string::String, &Self> {
        if let AnalyticsFilter::Prefix(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Prefix`](crate::model::AnalyticsFilter::Prefix).
    pub fn is_prefix(&self) -> bool {
        self.as_prefix().is_ok()
    }
    /// Tries to convert the enum instance into [`Tag`](crate::model::AnalyticsFilter::Tag), extracting the inner [`Tag`](crate::model::Tag).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_tag(&self) -> std::result::Result<&crate::model::Tag, &Self> {
        if let AnalyticsFilter::Tag(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`Tag`](crate::model::AnalyticsFilter::Tag).
    pub fn is_tag(&self) -> bool {
        self.as_tag().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>A conjunction (logical AND) of predicates, which is used in evaluating a metrics filter. The operator must have at least two predicates in any combination, and an object must match all of the predicates for the filter to apply.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnalyticsAndOperator {
    /// <p>The prefix to use when evaluating an AND predicate: The prefix that an object must have to be included in the metrics results.</p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>The list of tags to use when evaluating an AND predicate.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl AnalyticsAndOperator {
    /// <p>The prefix to use when evaluating an AND predicate: The prefix that an object must have to be included in the metrics results.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>The list of tags to use when evaluating an AND predicate.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for AnalyticsAndOperator {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnalyticsAndOperator");
        formatter.field("prefix", &self.prefix);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`AnalyticsAndOperator`](crate::model::AnalyticsAndOperator)
pub mod analytics_and_operator {
    /// A builder for [`AnalyticsAndOperator`](crate::model::AnalyticsAndOperator)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The prefix to use when evaluating an AND predicate: The prefix that an object must have to be included in the metrics results.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>The prefix to use when evaluating an AND predicate: The prefix that an object must have to be included in the metrics results.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags to use when evaluating an AND predicate.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags to use when evaluating an AND predicate.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AnalyticsAndOperator`](crate::model::AnalyticsAndOperator)
        pub fn build(self) -> crate::model::AnalyticsAndOperator {
            crate::model::AnalyticsAndOperator {
                prefix: self.prefix,
                tags: self.tags,
            }
        }
    }
}
impl AnalyticsAndOperator {
    /// Creates a new builder-style object to manufacture [`AnalyticsAndOperator`](crate::model::AnalyticsAndOperator)
    pub fn builder() -> crate::model::analytics_and_operator::Builder {
        crate::model::analytics_and_operator::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BucketCannedAcl {
    #[allow(missing_docs)] // documentation missing in model
    AuthenticatedRead,
    #[allow(missing_docs)] // documentation missing in model
    Private,
    #[allow(missing_docs)] // documentation missing in model
    PublicRead,
    #[allow(missing_docs)] // documentation missing in model
    PublicReadWrite,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BucketCannedAcl {
    fn from(s: &str) -> Self {
        match s {
            "authenticated-read" => BucketCannedAcl::AuthenticatedRead,
            "private" => BucketCannedAcl::Private,
            "public-read" => BucketCannedAcl::PublicRead,
            "public-read-write" => BucketCannedAcl::PublicReadWrite,
            other => BucketCannedAcl::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BucketCannedAcl {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BucketCannedAcl::from(s))
    }
}
impl BucketCannedAcl {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BucketCannedAcl::AuthenticatedRead => "authenticated-read",
            BucketCannedAcl::Private => "private",
            BucketCannedAcl::PublicRead => "public-read",
            BucketCannedAcl::PublicReadWrite => "public-read-write",
            BucketCannedAcl::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "authenticated-read",
            "private",
            "public-read",
            "public-read-write",
        ]
    }
}
impl AsRef<str> for BucketCannedAcl {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Configures the transfer acceleration state for an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html">Amazon S3 Transfer Acceleration</a> in the <i>Amazon S3 User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccelerateConfiguration {
    /// <p>Specifies the transfer acceleration status of the bucket.</p>
    pub status: std::option::Option<crate::model::BucketAccelerateStatus>,
}
impl AccelerateConfiguration {
    /// <p>Specifies the transfer acceleration status of the bucket.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::BucketAccelerateStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for AccelerateConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccelerateConfiguration");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`AccelerateConfiguration`](crate::model::AccelerateConfiguration)
pub mod accelerate_configuration {
    /// A builder for [`AccelerateConfiguration`](crate::model::AccelerateConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::BucketAccelerateStatus>,
    }
    impl Builder {
        /// <p>Specifies the transfer acceleration status of the bucket.</p>
        pub fn status(mut self, input: crate::model::BucketAccelerateStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Specifies the transfer acceleration status of the bucket.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::BucketAccelerateStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`AccelerateConfiguration`](crate::model::AccelerateConfiguration)
        pub fn build(self) -> crate::model::AccelerateConfiguration {
            crate::model::AccelerateConfiguration {
                status: self.status,
            }
        }
    }
}
impl AccelerateConfiguration {
    /// Creates a new builder-style object to manufacture [`AccelerateConfiguration`](crate::model::AccelerateConfiguration)
    pub fn builder() -> crate::model::accelerate_configuration::Builder {
        crate::model::accelerate_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BucketAccelerateStatus {
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    Suspended,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BucketAccelerateStatus {
    fn from(s: &str) -> Self {
        match s {
            "Enabled" => BucketAccelerateStatus::Enabled,
            "Suspended" => BucketAccelerateStatus::Suspended,
            other => BucketAccelerateStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BucketAccelerateStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BucketAccelerateStatus::from(s))
    }
}
impl BucketAccelerateStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BucketAccelerateStatus::Enabled => "Enabled",
            BucketAccelerateStatus::Suspended => "Suspended",
            BucketAccelerateStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Enabled", "Suspended"]
    }
}
impl AsRef<str> for BucketAccelerateStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Container element that identifies who initiated the multipart upload. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Initiator {
    /// <p>If the principal is an Amazon Web Services account, it provides the Canonical User ID. If the principal is an IAM User, it provides a user ARN value.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Name of the Principal.</p>
    pub display_name: std::option::Option<std::string::String>,
}
impl Initiator {
    /// <p>If the principal is an Amazon Web Services account, it provides the Canonical User ID. If the principal is an IAM User, it provides a user ARN value.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Name of the Principal.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
}
impl std::fmt::Debug for Initiator {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Initiator");
        formatter.field("id", &self.id);
        formatter.field("display_name", &self.display_name);
        formatter.finish()
    }
}
/// See [`Initiator`](crate::model::Initiator)
pub mod initiator {
    /// A builder for [`Initiator`](crate::model::Initiator)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>If the principal is an Amazon Web Services account, it provides the Canonical User ID. If the principal is an IAM User, it provides a user ARN value.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>If the principal is an Amazon Web Services account, it provides the Canonical User ID. If the principal is an IAM User, it provides a user ARN value.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Name of the Principal.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>Name of the Principal.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// Consumes the builder and constructs a [`Initiator`](crate::model::Initiator)
        pub fn build(self) -> crate::model::Initiator {
            crate::model::Initiator {
                id: self.id,
                display_name: self.display_name,
            }
        }
    }
}
impl Initiator {
    /// Creates a new builder-style object to manufacture [`Initiator`](crate::model::Initiator)
    pub fn builder() -> crate::model::initiator::Builder {
        crate::model::initiator::Builder::default()
    }
}

/// <p>Container for elements related to a part.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Part {
    /// <p>Part number identifying the part. This is a positive integer between 1 and 10,000.</p>
    pub part_number: i32,
    /// <p>Date and time at which the part was uploaded.</p>
    pub last_modified: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Entity tag returned when the part was uploaded.</p>
    pub e_tag: std::option::Option<std::string::String>,
    /// <p>Size in bytes of the uploaded part data.</p>
    pub size: i64,
}
impl Part {
    /// <p>Part number identifying the part. This is a positive integer between 1 and 10,000.</p>
    pub fn part_number(&self) -> i32 {
        self.part_number
    }
    /// <p>Date and time at which the part was uploaded.</p>
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified.as_ref()
    }
    /// <p>Entity tag returned when the part was uploaded.</p>
    pub fn e_tag(&self) -> std::option::Option<&str> {
        self.e_tag.as_deref()
    }
    /// <p>Size in bytes of the uploaded part data.</p>
    pub fn size(&self) -> i64 {
        self.size
    }
}
impl std::fmt::Debug for Part {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Part");
        formatter.field("part_number", &self.part_number);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("e_tag", &self.e_tag);
        formatter.field("size", &self.size);
        formatter.finish()
    }
}
/// See [`Part`](crate::model::Part)
pub mod part {
    /// A builder for [`Part`](crate::model::Part)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) part_number: std::option::Option<i32>,
        pub(crate) last_modified: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
        pub(crate) size: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Part number identifying the part. This is a positive integer between 1 and 10,000.</p>
        pub fn part_number(mut self, input: i32) -> Self {
            self.part_number = Some(input);
            self
        }
        /// <p>Part number identifying the part. This is a positive integer between 1 and 10,000.</p>
        pub fn set_part_number(mut self, input: std::option::Option<i32>) -> Self {
            self.part_number = input;
            self
        }
        /// <p>Date and time at which the part was uploaded.</p>
        pub fn last_modified(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>Date and time at which the part was uploaded.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>Entity tag returned when the part was uploaded.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>Entity tag returned when the part was uploaded.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// <p>Size in bytes of the uploaded part data.</p>
        pub fn size(mut self, input: i64) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>Size in bytes of the uploaded part data.</p>
        pub fn set_size(mut self, input: std::option::Option<i64>) -> Self {
            self.size = input;
            self
        }
        /// Consumes the builder and constructs a [`Part`](crate::model::Part)
        pub fn build(self) -> crate::model::Part {
            crate::model::Part {
                part_number: self.part_number.unwrap_or_default(),
                last_modified: self.last_modified,
                e_tag: self.e_tag,
                size: self.size.unwrap_or_default(),
            }
        }
    }
}
impl Part {
    /// Creates a new builder-style object to manufacture [`Part`](crate::model::Part)
    pub fn builder() -> crate::model::part::Builder {
        crate::model::part::Builder::default()
    }
}

/// <p>Requests Amazon S3 to encode the object keys in the response and specifies the encoding
/// method to use. An object key may contain any Unicode character; however, XML 1.0 parser
/// cannot parse some characters, such as characters with an ASCII value from 0 to 10. For
/// characters that are not supported in XML 1.0, you can add this parameter to request that
/// Amazon S3 encode the keys in the response.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EncodingType {
    #[allow(missing_docs)] // documentation missing in model
    Url,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EncodingType {
    fn from(s: &str) -> Self {
        match s {
            "url" => EncodingType::Url,
            other => EncodingType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EncodingType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EncodingType::from(s))
    }
}
impl EncodingType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EncodingType::Url => "url",
            EncodingType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["url"]
    }
}
impl AsRef<str> for EncodingType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Container for all (if there are any) keys between Prefix and the next occurrence of the string specified by a delimiter. CommonPrefixes lists keys that act like subdirectories in the directory specified by Prefix. For example, if the prefix is notes/ and the delimiter is a slash (/) as in notes/summer/july, the common prefix is notes/summer/. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CommonPrefix {
    /// <p>Container for the specified common prefix.</p>
    pub prefix: std::option::Option<std::string::String>,
}
impl CommonPrefix {
    /// <p>Container for the specified common prefix.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
}
impl std::fmt::Debug for CommonPrefix {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CommonPrefix");
        formatter.field("prefix", &self.prefix);
        formatter.finish()
    }
}
/// See [`CommonPrefix`](crate::model::CommonPrefix)
pub mod common_prefix {
    /// A builder for [`CommonPrefix`](crate::model::CommonPrefix)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Container for the specified common prefix.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>Container for the specified common prefix.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`CommonPrefix`](crate::model::CommonPrefix)
        pub fn build(self) -> crate::model::CommonPrefix {
            crate::model::CommonPrefix {
                prefix: self.prefix,
            }
        }
    }
}
impl CommonPrefix {
    /// Creates a new builder-style object to manufacture [`CommonPrefix`](crate::model::CommonPrefix)
    pub fn builder() -> crate::model::common_prefix::Builder {
        crate::model::common_prefix::Builder::default()
    }
}

/// <p>Information about the delete marker.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMarkerEntry {
    /// <p>The account that created the delete marker.&gt;</p>
    pub owner: std::option::Option<crate::model::Owner>,
    /// <p>The object key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>Version ID of an object.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the object is (true) or is not (false) the latest version of an object.</p>
    pub is_latest: bool,
    /// <p>Date and time the object was last modified.</p>
    pub last_modified: std::option::Option<aws_smithy_types::DateTime>,
}
impl DeleteMarkerEntry {
    /// <p>The account that created the delete marker.&gt;</p>
    pub fn owner(&self) -> std::option::Option<&crate::model::Owner> {
        self.owner.as_ref()
    }
    /// <p>The object key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>Version ID of an object.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>Specifies whether the object is (true) or is not (false) the latest version of an object.</p>
    pub fn is_latest(&self) -> bool {
        self.is_latest
    }
    /// <p>Date and time the object was last modified.</p>
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified.as_ref()
    }
}
impl std::fmt::Debug for DeleteMarkerEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMarkerEntry");
        formatter.field("owner", &self.owner);
        formatter.field("key", &self.key);
        formatter.field("version_id", &self.version_id);
        formatter.field("is_latest", &self.is_latest);
        formatter.field("last_modified", &self.last_modified);
        formatter.finish()
    }
}
/// See [`DeleteMarkerEntry`](crate::model::DeleteMarkerEntry)
pub mod delete_marker_entry {
    /// A builder for [`DeleteMarkerEntry`](crate::model::DeleteMarkerEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner: std::option::Option<crate::model::Owner>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) is_latest: std::option::Option<bool>,
        pub(crate) last_modified: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The account that created the delete marker.&gt;</p>
        pub fn owner(mut self, input: crate::model::Owner) -> Self {
            self.owner = Some(input);
            self
        }
        /// <p>The account that created the delete marker.&gt;</p>
        pub fn set_owner(mut self, input: std::option::Option<crate::model::Owner>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The object key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The object key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Version ID of an object.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>Version ID of an object.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>Specifies whether the object is (true) or is not (false) the latest version of an object.</p>
        pub fn is_latest(mut self, input: bool) -> Self {
            self.is_latest = Some(input);
            self
        }
        /// <p>Specifies whether the object is (true) or is not (false) the latest version of an object.</p>
        pub fn set_is_latest(mut self, input: std::option::Option<bool>) -> Self {
            self.is_latest = input;
            self
        }
        /// <p>Date and time the object was last modified.</p>
        pub fn last_modified(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>Date and time the object was last modified.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMarkerEntry`](crate::model::DeleteMarkerEntry)
        pub fn build(self) -> crate::model::DeleteMarkerEntry {
            crate::model::DeleteMarkerEntry {
                owner: self.owner,
                key: self.key,
                version_id: self.version_id,
                is_latest: self.is_latest.unwrap_or_default(),
                last_modified: self.last_modified,
            }
        }
    }
}
impl DeleteMarkerEntry {
    /// Creates a new builder-style object to manufacture [`DeleteMarkerEntry`](crate::model::DeleteMarkerEntry)
    pub fn builder() -> crate::model::delete_marker_entry::Builder {
        crate::model::delete_marker_entry::Builder::default()
    }
}

/// <p>The version of an object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ObjectVersion {
    /// <p>The entity tag is an MD5 hash of that version of the object.</p>
    pub e_tag: std::option::Option<std::string::String>,
    /// <p>Size in bytes of the object.</p>
    pub size: i64,
    /// <p>The class of storage used to store the object.</p>
    pub storage_class: std::option::Option<crate::model::ObjectVersionStorageClass>,
    /// <p>The object key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>Version ID of an object.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the object is (true) or is not (false) the latest version of an object.</p>
    pub is_latest: bool,
    /// <p>Date and time the object was last modified.</p>
    pub last_modified: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies the owner of the object.</p>
    pub owner: std::option::Option<crate::model::Owner>,
}
impl ObjectVersion {
    /// <p>The entity tag is an MD5 hash of that version of the object.</p>
    pub fn e_tag(&self) -> std::option::Option<&str> {
        self.e_tag.as_deref()
    }
    /// <p>Size in bytes of the object.</p>
    pub fn size(&self) -> i64 {
        self.size
    }
    /// <p>The class of storage used to store the object.</p>
    pub fn storage_class(&self) -> std::option::Option<&crate::model::ObjectVersionStorageClass> {
        self.storage_class.as_ref()
    }
    /// <p>The object key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>Version ID of an object.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>Specifies whether the object is (true) or is not (false) the latest version of an object.</p>
    pub fn is_latest(&self) -> bool {
        self.is_latest
    }
    /// <p>Date and time the object was last modified.</p>
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified.as_ref()
    }
    /// <p>Specifies the owner of the object.</p>
    pub fn owner(&self) -> std::option::Option<&crate::model::Owner> {
        self.owner.as_ref()
    }
}
impl std::fmt::Debug for ObjectVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ObjectVersion");
        formatter.field("e_tag", &self.e_tag);
        formatter.field("size", &self.size);
        formatter.field("storage_class", &self.storage_class);
        formatter.field("key", &self.key);
        formatter.field("version_id", &self.version_id);
        formatter.field("is_latest", &self.is_latest);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("owner", &self.owner);
        formatter.finish()
    }
}
/// See [`ObjectVersion`](crate::model::ObjectVersion)
pub mod object_version {
    /// A builder for [`ObjectVersion`](crate::model::ObjectVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) e_tag: std::option::Option<std::string::String>,
        pub(crate) size: std::option::Option<i64>,
        pub(crate) storage_class: std::option::Option<crate::model::ObjectVersionStorageClass>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) is_latest: std::option::Option<bool>,
        pub(crate) last_modified: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) owner: std::option::Option<crate::model::Owner>,
    }
    impl Builder {
        /// <p>The entity tag is an MD5 hash of that version of the object.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The entity tag is an MD5 hash of that version of the object.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// <p>Size in bytes of the object.</p>
        pub fn size(mut self, input: i64) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>Size in bytes of the object.</p>
        pub fn set_size(mut self, input: std::option::Option<i64>) -> Self {
            self.size = input;
            self
        }
        /// <p>The class of storage used to store the object.</p>
        pub fn storage_class(mut self, input: crate::model::ObjectVersionStorageClass) -> Self {
            self.storage_class = Some(input);
            self
        }
        /// <p>The class of storage used to store the object.</p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<crate::model::ObjectVersionStorageClass>,
        ) -> Self {
            self.storage_class = input;
            self
        }
        /// <p>The object key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The object key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Version ID of an object.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>Version ID of an object.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>Specifies whether the object is (true) or is not (false) the latest version of an object.</p>
        pub fn is_latest(mut self, input: bool) -> Self {
            self.is_latest = Some(input);
            self
        }
        /// <p>Specifies whether the object is (true) or is not (false) the latest version of an object.</p>
        pub fn set_is_latest(mut self, input: std::option::Option<bool>) -> Self {
            self.is_latest = input;
            self
        }
        /// <p>Date and time the object was last modified.</p>
        pub fn last_modified(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>Date and time the object was last modified.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>Specifies the owner of the object.</p>
        pub fn owner(mut self, input: crate::model::Owner) -> Self {
            self.owner = Some(input);
            self
        }
        /// <p>Specifies the owner of the object.</p>
        pub fn set_owner(mut self, input: std::option::Option<crate::model::Owner>) -> Self {
            self.owner = input;
            self
        }
        /// Consumes the builder and constructs a [`ObjectVersion`](crate::model::ObjectVersion)
        pub fn build(self) -> crate::model::ObjectVersion {
            crate::model::ObjectVersion {
                e_tag: self.e_tag,
                size: self.size.unwrap_or_default(),
                storage_class: self.storage_class,
                key: self.key,
                version_id: self.version_id,
                is_latest: self.is_latest.unwrap_or_default(),
                last_modified: self.last_modified,
                owner: self.owner,
            }
        }
    }
}
impl ObjectVersion {
    /// Creates a new builder-style object to manufacture [`ObjectVersion`](crate::model::ObjectVersion)
    pub fn builder() -> crate::model::object_version::Builder {
        crate::model::object_version::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ObjectVersionStorageClass {
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ObjectVersionStorageClass {
    fn from(s: &str) -> Self {
        match s {
            "STANDARD" => ObjectVersionStorageClass::Standard,
            other => ObjectVersionStorageClass::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ObjectVersionStorageClass {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ObjectVersionStorageClass::from(s))
    }
}
impl ObjectVersionStorageClass {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ObjectVersionStorageClass::Standard => "STANDARD",
            ObjectVersionStorageClass::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["STANDARD"]
    }
}
impl AsRef<str> for ObjectVersionStorageClass {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object consists of data and its descriptive metadata.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Object {
    /// <p>The name that you assign to an object. You use the object key to retrieve the object.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>Creation date of the object.</p>
    pub last_modified: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The entity tag is a hash of the object. The ETag reflects changes only to the contents of an object, not its metadata. The ETag may or may not be an MD5 digest of the object data. Whether or not it is depends on how the object was created and how it is encrypted as described below:</p>
    /// <ul>
    /// <li> <p>Objects created by the PUT Object, POST Object, or Copy operation, or through the Amazon Web Services Management Console, and are encrypted by SSE-S3 or plaintext, have ETags that are an MD5 digest of their object data.</p> </li>
    /// <li> <p>Objects created by the PUT Object, POST Object, or Copy operation, or through the Amazon Web Services Management Console, and are encrypted by SSE-C or SSE-KMS, have ETags that are not an MD5 digest of their object data.</p> </li>
    /// <li> <p>If an object is created by either the Multipart Upload or Part Copy operation, the ETag is not an MD5 digest, regardless of the method of encryption.</p> </li>
    /// </ul>
    pub e_tag: std::option::Option<std::string::String>,
    /// <p>Size in bytes of the object</p>
    pub size: i64,
    /// <p>The class of storage used to store the object.</p>
    pub storage_class: std::option::Option<crate::model::ObjectStorageClass>,
    /// <p>The owner of the object</p>
    pub owner: std::option::Option<crate::model::Owner>,
}
impl Object {
    /// <p>The name that you assign to an object. You use the object key to retrieve the object.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>Creation date of the object.</p>
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified.as_ref()
    }
    /// <p>The entity tag is a hash of the object. The ETag reflects changes only to the contents of an object, not its metadata. The ETag may or may not be an MD5 digest of the object data. Whether or not it is depends on how the object was created and how it is encrypted as described below:</p>
    /// <ul>
    /// <li> <p>Objects created by the PUT Object, POST Object, or Copy operation, or through the Amazon Web Services Management Console, and are encrypted by SSE-S3 or plaintext, have ETags that are an MD5 digest of their object data.</p> </li>
    /// <li> <p>Objects created by the PUT Object, POST Object, or Copy operation, or through the Amazon Web Services Management Console, and are encrypted by SSE-C or SSE-KMS, have ETags that are not an MD5 digest of their object data.</p> </li>
    /// <li> <p>If an object is created by either the Multipart Upload or Part Copy operation, the ETag is not an MD5 digest, regardless of the method of encryption.</p> </li>
    /// </ul>
    pub fn e_tag(&self) -> std::option::Option<&str> {
        self.e_tag.as_deref()
    }
    /// <p>Size in bytes of the object</p>
    pub fn size(&self) -> i64 {
        self.size
    }
    /// <p>The class of storage used to store the object.</p>
    pub fn storage_class(&self) -> std::option::Option<&crate::model::ObjectStorageClass> {
        self.storage_class.as_ref()
    }
    /// <p>The owner of the object</p>
    pub fn owner(&self) -> std::option::Option<&crate::model::Owner> {
        self.owner.as_ref()
    }
}
impl std::fmt::Debug for Object {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Object");
        formatter.field("key", &self.key);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("e_tag", &self.e_tag);
        formatter.field("size", &self.size);
        formatter.field("storage_class", &self.storage_class);
        formatter.field("owner", &self.owner);
        formatter.finish()
    }
}
/// See [`Object`](crate::model::Object)
pub mod object {
    /// A builder for [`Object`](crate::model::Object)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) last_modified: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
        pub(crate) size: std::option::Option<i64>,
        pub(crate) storage_class: std::option::Option<crate::model::ObjectStorageClass>,
        pub(crate) owner: std::option::Option<crate::model::Owner>,
    }
    impl Builder {
        /// <p>The name that you assign to an object. You use the object key to retrieve the object.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The name that you assign to an object. You use the object key to retrieve the object.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Creation date of the object.</p>
        pub fn last_modified(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>Creation date of the object.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>The entity tag is a hash of the object. The ETag reflects changes only to the contents of an object, not its metadata. The ETag may or may not be an MD5 digest of the object data. Whether or not it is depends on how the object was created and how it is encrypted as described below:</p>
        /// <ul>
        /// <li> <p>Objects created by the PUT Object, POST Object, or Copy operation, or through the Amazon Web Services Management Console, and are encrypted by SSE-S3 or plaintext, have ETags that are an MD5 digest of their object data.</p> </li>
        /// <li> <p>Objects created by the PUT Object, POST Object, or Copy operation, or through the Amazon Web Services Management Console, and are encrypted by SSE-C or SSE-KMS, have ETags that are not an MD5 digest of their object data.</p> </li>
        /// <li> <p>If an object is created by either the Multipart Upload or Part Copy operation, the ETag is not an MD5 digest, regardless of the method of encryption.</p> </li>
        /// </ul>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The entity tag is a hash of the object. The ETag reflects changes only to the contents of an object, not its metadata. The ETag may or may not be an MD5 digest of the object data. Whether or not it is depends on how the object was created and how it is encrypted as described below:</p>
        /// <ul>
        /// <li> <p>Objects created by the PUT Object, POST Object, or Copy operation, or through the Amazon Web Services Management Console, and are encrypted by SSE-S3 or plaintext, have ETags that are an MD5 digest of their object data.</p> </li>
        /// <li> <p>Objects created by the PUT Object, POST Object, or Copy operation, or through the Amazon Web Services Management Console, and are encrypted by SSE-C or SSE-KMS, have ETags that are not an MD5 digest of their object data.</p> </li>
        /// <li> <p>If an object is created by either the Multipart Upload or Part Copy operation, the ETag is not an MD5 digest, regardless of the method of encryption.</p> </li>
        /// </ul>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// <p>Size in bytes of the object</p>
        pub fn size(mut self, input: i64) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>Size in bytes of the object</p>
        pub fn set_size(mut self, input: std::option::Option<i64>) -> Self {
            self.size = input;
            self
        }
        /// <p>The class of storage used to store the object.</p>
        pub fn storage_class(mut self, input: crate::model::ObjectStorageClass) -> Self {
            self.storage_class = Some(input);
            self
        }
        /// <p>The class of storage used to store the object.</p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<crate::model::ObjectStorageClass>,
        ) -> Self {
            self.storage_class = input;
            self
        }
        /// <p>The owner of the object</p>
        pub fn owner(mut self, input: crate::model::Owner) -> Self {
            self.owner = Some(input);
            self
        }
        /// <p>The owner of the object</p>
        pub fn set_owner(mut self, input: std::option::Option<crate::model::Owner>) -> Self {
            self.owner = input;
            self
        }
        /// Consumes the builder and constructs a [`Object`](crate::model::Object)
        pub fn build(self) -> crate::model::Object {
            crate::model::Object {
                key: self.key,
                last_modified: self.last_modified,
                e_tag: self.e_tag,
                size: self.size.unwrap_or_default(),
                storage_class: self.storage_class,
                owner: self.owner,
            }
        }
    }
}
impl Object {
    /// Creates a new builder-style object to manufacture [`Object`](crate::model::Object)
    pub fn builder() -> crate::model::object::Builder {
        crate::model::object::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ObjectStorageClass {
    #[allow(missing_docs)] // documentation missing in model
    DeepArchive,
    #[allow(missing_docs)] // documentation missing in model
    Glacier,
    #[allow(missing_docs)] // documentation missing in model
    GlacierIr,
    #[allow(missing_docs)] // documentation missing in model
    IntelligentTiering,
    #[allow(missing_docs)] // documentation missing in model
    OnezoneIa,
    #[allow(missing_docs)] // documentation missing in model
    Outposts,
    #[allow(missing_docs)] // documentation missing in model
    ReducedRedundancy,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    #[allow(missing_docs)] // documentation missing in model
    StandardIa,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ObjectStorageClass {
    fn from(s: &str) -> Self {
        match s {
            "DEEP_ARCHIVE" => ObjectStorageClass::DeepArchive,
            "GLACIER" => ObjectStorageClass::Glacier,
            "GLACIER_IR" => ObjectStorageClass::GlacierIr,
            "INTELLIGENT_TIERING" => ObjectStorageClass::IntelligentTiering,
            "ONEZONE_IA" => ObjectStorageClass::OnezoneIa,
            "OUTPOSTS" => ObjectStorageClass::Outposts,
            "REDUCED_REDUNDANCY" => ObjectStorageClass::ReducedRedundancy,
            "STANDARD" => ObjectStorageClass::Standard,
            "STANDARD_IA" => ObjectStorageClass::StandardIa,
            other => ObjectStorageClass::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ObjectStorageClass {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ObjectStorageClass::from(s))
    }
}
impl ObjectStorageClass {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ObjectStorageClass::DeepArchive => "DEEP_ARCHIVE",
            ObjectStorageClass::Glacier => "GLACIER",
            ObjectStorageClass::GlacierIr => "GLACIER_IR",
            ObjectStorageClass::IntelligentTiering => "INTELLIGENT_TIERING",
            ObjectStorageClass::OnezoneIa => "ONEZONE_IA",
            ObjectStorageClass::Outposts => "OUTPOSTS",
            ObjectStorageClass::ReducedRedundancy => "REDUCED_REDUNDANCY",
            ObjectStorageClass::Standard => "STANDARD",
            ObjectStorageClass::StandardIa => "STANDARD_IA",
            ObjectStorageClass::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DEEP_ARCHIVE",
            "GLACIER",
            "GLACIER_IR",
            "INTELLIGENT_TIERING",
            "ONEZONE_IA",
            "OUTPOSTS",
            "REDUCED_REDUNDANCY",
            "STANDARD",
            "STANDARD_IA",
        ]
    }
}
impl AsRef<str> for ObjectStorageClass {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Container for the <code>MultipartUpload</code> for the Amazon S3 object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MultipartUpload {
    /// <p>Upload ID that identifies the multipart upload.</p>
    pub upload_id: std::option::Option<std::string::String>,
    /// <p>Key of the object for which the multipart upload was initiated.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>Date and time at which the multipart upload was initiated.</p>
    pub initiated: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The class of storage used to store the object.</p>
    pub storage_class: std::option::Option<crate::model::StorageClass>,
    /// <p>Specifies the owner of the object that is part of the multipart upload. </p>
    pub owner: std::option::Option<crate::model::Owner>,
    /// <p>Identifies who initiated the multipart upload.</p>
    pub initiator: std::option::Option<crate::model::Initiator>,
}
impl MultipartUpload {
    /// <p>Upload ID that identifies the multipart upload.</p>
    pub fn upload_id(&self) -> std::option::Option<&str> {
        self.upload_id.as_deref()
    }
    /// <p>Key of the object for which the multipart upload was initiated.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>Date and time at which the multipart upload was initiated.</p>
    pub fn initiated(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.initiated.as_ref()
    }
    /// <p>The class of storage used to store the object.</p>
    pub fn storage_class(&self) -> std::option::Option<&crate::model::StorageClass> {
        self.storage_class.as_ref()
    }
    /// <p>Specifies the owner of the object that is part of the multipart upload. </p>
    pub fn owner(&self) -> std::option::Option<&crate::model::Owner> {
        self.owner.as_ref()
    }
    /// <p>Identifies who initiated the multipart upload.</p>
    pub fn initiator(&self) -> std::option::Option<&crate::model::Initiator> {
        self.initiator.as_ref()
    }
}
impl std::fmt::Debug for MultipartUpload {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MultipartUpload");
        formatter.field("upload_id", &self.upload_id);
        formatter.field("key", &self.key);
        formatter.field("initiated", &self.initiated);
        formatter.field("storage_class", &self.storage_class);
        formatter.field("owner", &self.owner);
        formatter.field("initiator", &self.initiator);
        formatter.finish()
    }
}
/// See [`MultipartUpload`](crate::model::MultipartUpload)
pub mod multipart_upload {
    /// A builder for [`MultipartUpload`](crate::model::MultipartUpload)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) upload_id: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) initiated: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) storage_class: std::option::Option<crate::model::StorageClass>,
        pub(crate) owner: std::option::Option<crate::model::Owner>,
        pub(crate) initiator: std::option::Option<crate::model::Initiator>,
    }
    impl Builder {
        /// <p>Upload ID that identifies the multipart upload.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>Upload ID that identifies the multipart upload.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// <p>Key of the object for which the multipart upload was initiated.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Key of the object for which the multipart upload was initiated.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Date and time at which the multipart upload was initiated.</p>
        pub fn initiated(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.initiated = Some(input);
            self
        }
        /// <p>Date and time at which the multipart upload was initiated.</p>
        pub fn set_initiated(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.initiated = input;
            self
        }
        /// <p>The class of storage used to store the object.</p>
        pub fn storage_class(mut self, input: crate::model::StorageClass) -> Self {
            self.storage_class = Some(input);
            self
        }
        /// <p>The class of storage used to store the object.</p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<crate::model::StorageClass>,
        ) -> Self {
            self.storage_class = input;
            self
        }
        /// <p>Specifies the owner of the object that is part of the multipart upload. </p>
        pub fn owner(mut self, input: crate::model::Owner) -> Self {
            self.owner = Some(input);
            self
        }
        /// <p>Specifies the owner of the object that is part of the multipart upload. </p>
        pub fn set_owner(mut self, input: std::option::Option<crate::model::Owner>) -> Self {
            self.owner = input;
            self
        }
        /// <p>Identifies who initiated the multipart upload.</p>
        pub fn initiator(mut self, input: crate::model::Initiator) -> Self {
            self.initiator = Some(input);
            self
        }
        /// <p>Identifies who initiated the multipart upload.</p>
        pub fn set_initiator(
            mut self,
            input: std::option::Option<crate::model::Initiator>,
        ) -> Self {
            self.initiator = input;
            self
        }
        /// Consumes the builder and constructs a [`MultipartUpload`](crate::model::MultipartUpload)
        pub fn build(self) -> crate::model::MultipartUpload {
            crate::model::MultipartUpload {
                upload_id: self.upload_id,
                key: self.key,
                initiated: self.initiated,
                storage_class: self.storage_class,
                owner: self.owner,
                initiator: self.initiator,
            }
        }
    }
}
impl MultipartUpload {
    /// Creates a new builder-style object to manufacture [`MultipartUpload`](crate::model::MultipartUpload)
    pub fn builder() -> crate::model::multipart_upload::Builder {
        crate::model::multipart_upload::Builder::default()
    }
}

/// <p> In terms of implementation, a Bucket is a resource. An Amazon S3 bucket name is globally unique, and the namespace is shared by all Amazon Web Services accounts. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Bucket {
    /// <p>The name of the bucket.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Date the bucket was created. This date can change when making changes to your bucket, such as editing its bucket policy.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl Bucket {
    /// <p>The name of the bucket.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Date the bucket was created. This date can change when making changes to your bucket, such as editing its bucket policy.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
}
impl std::fmt::Debug for Bucket {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Bucket");
        formatter.field("name", &self.name);
        formatter.field("creation_date", &self.creation_date);
        formatter.finish()
    }
}
/// See [`Bucket`](crate::model::Bucket)
pub mod bucket {
    /// A builder for [`Bucket`](crate::model::Bucket)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the bucket.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the bucket.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Date the bucket was created. This date can change when making changes to your bucket, such as editing its bucket policy.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>Date the bucket was created. This date can change when making changes to your bucket, such as editing its bucket policy.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Consumes the builder and constructs a [`Bucket`](crate::model::Bucket)
        pub fn build(self) -> crate::model::Bucket {
            crate::model::Bucket {
                name: self.name,
                creation_date: self.creation_date,
            }
        }
    }
}
impl Bucket {
    /// Creates a new builder-style object to manufacture [`Bucket`](crate::model::Bucket)
    pub fn builder() -> crate::model::bucket::Builder {
        crate::model::bucket::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ArchiveStatus {
    #[allow(missing_docs)] // documentation missing in model
    ArchiveAccess,
    #[allow(missing_docs)] // documentation missing in model
    DeepArchiveAccess,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ArchiveStatus {
    fn from(s: &str) -> Self {
        match s {
            "ARCHIVE_ACCESS" => ArchiveStatus::ArchiveAccess,
            "DEEP_ARCHIVE_ACCESS" => ArchiveStatus::DeepArchiveAccess,
            other => ArchiveStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ArchiveStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ArchiveStatus::from(s))
    }
}
impl ArchiveStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ArchiveStatus::ArchiveAccess => "ARCHIVE_ACCESS",
            ArchiveStatus::DeepArchiveAccess => "DEEP_ARCHIVE_ACCESS",
            ArchiveStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ARCHIVE_ACCESS", "DEEP_ARCHIVE_ACCESS"]
    }
}
impl AsRef<str> for ArchiveStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MfaDeleteStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MfaDeleteStatus {
    fn from(s: &str) -> Self {
        match s {
            "Disabled" => MfaDeleteStatus::Disabled,
            "Enabled" => MfaDeleteStatus::Enabled,
            other => MfaDeleteStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MfaDeleteStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MfaDeleteStatus::from(s))
    }
}
impl MfaDeleteStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MfaDeleteStatus::Disabled => "Disabled",
            MfaDeleteStatus::Enabled => "Enabled",
            MfaDeleteStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Disabled", "Enabled"]
    }
}
impl AsRef<str> for MfaDeleteStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The container element for a bucket's policy status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyStatus {
    /// <p>The policy status for this bucket. <code>TRUE</code> indicates that this bucket is public. <code>FALSE</code> indicates that the bucket is not public.</p>
    pub is_public: bool,
}
impl PolicyStatus {
    /// <p>The policy status for this bucket. <code>TRUE</code> indicates that this bucket is public. <code>FALSE</code> indicates that the bucket is not public.</p>
    pub fn is_public(&self) -> bool {
        self.is_public
    }
}
impl std::fmt::Debug for PolicyStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyStatus");
        formatter.field("is_public", &self.is_public);
        formatter.finish()
    }
}
/// See [`PolicyStatus`](crate::model::PolicyStatus)
pub mod policy_status {
    /// A builder for [`PolicyStatus`](crate::model::PolicyStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) is_public: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The policy status for this bucket. <code>TRUE</code> indicates that this bucket is public. <code>FALSE</code> indicates that the bucket is not public.</p>
        pub fn is_public(mut self, input: bool) -> Self {
            self.is_public = Some(input);
            self
        }
        /// <p>The policy status for this bucket. <code>TRUE</code> indicates that this bucket is public. <code>FALSE</code> indicates that the bucket is not public.</p>
        pub fn set_is_public(mut self, input: std::option::Option<bool>) -> Self {
            self.is_public = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyStatus`](crate::model::PolicyStatus)
        pub fn build(self) -> crate::model::PolicyStatus {
            crate::model::PolicyStatus {
                is_public: self.is_public.unwrap_or_default(),
            }
        }
    }
}
impl PolicyStatus {
    /// Creates a new builder-style object to manufacture [`PolicyStatus`](crate::model::PolicyStatus)
    pub fn builder() -> crate::model::policy_status::Builder {
        crate::model::policy_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BucketLocationConstraint {
    #[allow(missing_docs)] // documentation missing in model
    Eu,
    #[allow(missing_docs)] // documentation missing in model
    AfSouth1,
    #[allow(missing_docs)] // documentation missing in model
    ApEast1,
    #[allow(missing_docs)] // documentation missing in model
    ApNortheast1,
    #[allow(missing_docs)] // documentation missing in model
    ApNortheast2,
    #[allow(missing_docs)] // documentation missing in model
    ApNortheast3,
    #[allow(missing_docs)] // documentation missing in model
    ApSouth1,
    #[allow(missing_docs)] // documentation missing in model
    ApSoutheast1,
    #[allow(missing_docs)] // documentation missing in model
    ApSoutheast2,
    #[allow(missing_docs)] // documentation missing in model
    CaCentral1,
    #[allow(missing_docs)] // documentation missing in model
    CnNorth1,
    #[allow(missing_docs)] // documentation missing in model
    CnNorthwest1,
    #[allow(missing_docs)] // documentation missing in model
    EuCentral1,
    #[allow(missing_docs)] // documentation missing in model
    EuNorth1,
    #[allow(missing_docs)] // documentation missing in model
    EuSouth1,
    #[allow(missing_docs)] // documentation missing in model
    EuWest1,
    #[allow(missing_docs)] // documentation missing in model
    EuWest2,
    #[allow(missing_docs)] // documentation missing in model
    EuWest3,
    #[allow(missing_docs)] // documentation missing in model
    MeSouth1,
    #[allow(missing_docs)] // documentation missing in model
    SaEast1,
    #[allow(missing_docs)] // documentation missing in model
    UsEast2,
    #[allow(missing_docs)] // documentation missing in model
    UsGovEast1,
    #[allow(missing_docs)] // documentation missing in model
    UsGovWest1,
    #[allow(missing_docs)] // documentation missing in model
    UsWest1,
    #[allow(missing_docs)] // documentation missing in model
    UsWest2,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BucketLocationConstraint {
    fn from(s: &str) -> Self {
        match s {
            "EU" => BucketLocationConstraint::Eu,
            "af-south-1" => BucketLocationConstraint::AfSouth1,
            "ap-east-1" => BucketLocationConstraint::ApEast1,
            "ap-northeast-1" => BucketLocationConstraint::ApNortheast1,
            "ap-northeast-2" => BucketLocationConstraint::ApNortheast2,
            "ap-northeast-3" => BucketLocationConstraint::ApNortheast3,
            "ap-south-1" => BucketLocationConstraint::ApSouth1,
            "ap-southeast-1" => BucketLocationConstraint::ApSoutheast1,
            "ap-southeast-2" => BucketLocationConstraint::ApSoutheast2,
            "ca-central-1" => BucketLocationConstraint::CaCentral1,
            "cn-north-1" => BucketLocationConstraint::CnNorth1,
            "cn-northwest-1" => BucketLocationConstraint::CnNorthwest1,
            "eu-central-1" => BucketLocationConstraint::EuCentral1,
            "eu-north-1" => BucketLocationConstraint::EuNorth1,
            "eu-south-1" => BucketLocationConstraint::EuSouth1,
            "eu-west-1" => BucketLocationConstraint::EuWest1,
            "eu-west-2" => BucketLocationConstraint::EuWest2,
            "eu-west-3" => BucketLocationConstraint::EuWest3,
            "me-south-1" => BucketLocationConstraint::MeSouth1,
            "sa-east-1" => BucketLocationConstraint::SaEast1,
            "us-east-2" => BucketLocationConstraint::UsEast2,
            "us-gov-east-1" => BucketLocationConstraint::UsGovEast1,
            "us-gov-west-1" => BucketLocationConstraint::UsGovWest1,
            "us-west-1" => BucketLocationConstraint::UsWest1,
            "us-west-2" => BucketLocationConstraint::UsWest2,
            other => BucketLocationConstraint::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BucketLocationConstraint {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BucketLocationConstraint::from(s))
    }
}
impl BucketLocationConstraint {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BucketLocationConstraint::Eu => "EU",
            BucketLocationConstraint::AfSouth1 => "af-south-1",
            BucketLocationConstraint::ApEast1 => "ap-east-1",
            BucketLocationConstraint::ApNortheast1 => "ap-northeast-1",
            BucketLocationConstraint::ApNortheast2 => "ap-northeast-2",
            BucketLocationConstraint::ApNortheast3 => "ap-northeast-3",
            BucketLocationConstraint::ApSouth1 => "ap-south-1",
            BucketLocationConstraint::ApSoutheast1 => "ap-southeast-1",
            BucketLocationConstraint::ApSoutheast2 => "ap-southeast-2",
            BucketLocationConstraint::CaCentral1 => "ca-central-1",
            BucketLocationConstraint::CnNorth1 => "cn-north-1",
            BucketLocationConstraint::CnNorthwest1 => "cn-northwest-1",
            BucketLocationConstraint::EuCentral1 => "eu-central-1",
            BucketLocationConstraint::EuNorth1 => "eu-north-1",
            BucketLocationConstraint::EuSouth1 => "eu-south-1",
            BucketLocationConstraint::EuWest1 => "eu-west-1",
            BucketLocationConstraint::EuWest2 => "eu-west-2",
            BucketLocationConstraint::EuWest3 => "eu-west-3",
            BucketLocationConstraint::MeSouth1 => "me-south-1",
            BucketLocationConstraint::SaEast1 => "sa-east-1",
            BucketLocationConstraint::UsEast2 => "us-east-2",
            BucketLocationConstraint::UsGovEast1 => "us-gov-east-1",
            BucketLocationConstraint::UsGovWest1 => "us-gov-west-1",
            BucketLocationConstraint::UsWest1 => "us-west-1",
            BucketLocationConstraint::UsWest2 => "us-west-2",
            BucketLocationConstraint::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "EU",
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "cn-north-1",
            "cn-northwest-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
        ]
    }
}
impl AsRef<str> for BucketLocationConstraint {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Container for all error elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Error {
    /// <p>The error key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The version ID of the error.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    /// <p class="title"> <b>Amazon S3 error codes</b> </p>
    /// <ul>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> AccessDenied </p> </li>
    /// <li> <p> <i>Description:</i> Access Denied</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> AccountProblem</p> </li>
    /// <li> <p> <i>Description:</i> There is a problem with your Amazon Web Services account that prevents the action from completing successfully. Contact Amazon Web Services Support for further assistance.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> AllAccessDisabled</p> </li>
    /// <li> <p> <i>Description:</i> All access to this Amazon S3 resource has been disabled. Contact Amazon Web Services Support for further assistance.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> AmbiguousGrantByEmailAddress</p> </li>
    /// <li> <p> <i>Description:</i> The email address you provided is associated with more than one account.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> AuthorizationHeaderMalformed</p> </li>
    /// <li> <p> <i>Description:</i> The authorization header you provided is invalid.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> N/A</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> BadDigest</p> </li>
    /// <li> <p> <i>Description:</i> The Content-MD5 you specified did not match what we received.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> BucketAlreadyExists</p> </li>
    /// <li> <p> <i>Description:</i> The requested bucket name is not available. The bucket namespace is shared by all users of the system. Please select a different name and try again.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 409 Conflict</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> BucketAlreadyOwnedByYou</p> </li>
    /// <li> <p> <i>Description:</i> The bucket you tried to create already exists, and you own it. Amazon S3 returns this error in all Amazon Web Services Regions except in the North Virginia Region. For legacy compatibility, if you re-create an existing bucket that you already own in the North Virginia Region, Amazon S3 returns 200 OK and resets the bucket access control lists (ACLs).</p> </li>
    /// <li> <p> <i>Code:</i> 409 Conflict (in all Regions except the North Virginia Region) </p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> BucketNotEmpty</p> </li>
    /// <li> <p> <i>Description:</i> The bucket you tried to delete is not empty.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 409 Conflict</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> CredentialsNotSupported</p> </li>
    /// <li> <p> <i>Description:</i> This request does not support credentials.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> CrossLocationLoggingProhibited</p> </li>
    /// <li> <p> <i>Description:</i> Cross-location logging not allowed. Buckets in one geographic location cannot log information to a bucket in another location.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> EntityTooSmall</p> </li>
    /// <li> <p> <i>Description:</i> Your proposed upload is smaller than the minimum allowed object size.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> EntityTooLarge</p> </li>
    /// <li> <p> <i>Description:</i> Your proposed upload exceeds the maximum allowed object size.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> ExpiredToken</p> </li>
    /// <li> <p> <i>Description:</i> The provided token has expired.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> IllegalVersioningConfigurationException </p> </li>
    /// <li> <p> <i>Description:</i> Indicates that the versioning configuration specified in the request is invalid.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> IncompleteBody</p> </li>
    /// <li> <p> <i>Description:</i> You did not provide the number of bytes specified by the Content-Length HTTP header</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> IncorrectNumberOfFilesInPostRequest</p> </li>
    /// <li> <p> <i>Description:</i> POST requires exactly one file upload per request.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InlineDataTooLarge</p> </li>
    /// <li> <p> <i>Description:</i> Inline data exceeds the maximum allowed size.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InternalError</p> </li>
    /// <li> <p> <i>Description:</i> We encountered an internal error. Please try again.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 500 Internal Server Error</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Server</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidAccessKeyId</p> </li>
    /// <li> <p> <i>Description:</i> The Amazon Web Services access key ID you provided does not exist in our records.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidAddressingHeader</p> </li>
    /// <li> <p> <i>Description:</i> You must specify the Anonymous role.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> N/A</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidArgument</p> </li>
    /// <li> <p> <i>Description:</i> Invalid Argument</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidBucketName</p> </li>
    /// <li> <p> <i>Description:</i> The specified bucket is not valid.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidBucketState</p> </li>
    /// <li> <p> <i>Description:</i> The request is not valid with the current state of the bucket.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 409 Conflict</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidDigest</p> </li>
    /// <li> <p> <i>Description:</i> The Content-MD5 you specified is not valid.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidEncryptionAlgorithmError</p> </li>
    /// <li> <p> <i>Description:</i> The encryption request you specified is not valid. The valid value is AES256.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidLocationConstraint</p> </li>
    /// <li> <p> <i>Description:</i> The specified location constraint is not valid. For more information about Regions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingBucket.html#access-bucket-intro">How to Select a Region for Your Buckets</a>. </p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidObjectState</p> </li>
    /// <li> <p> <i>Description:</i> The action is not valid for the current state of the object.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidPart</p> </li>
    /// <li> <p> <i>Description:</i> One or more of the specified parts could not be found. The part might not have been uploaded, or the specified entity tag might not have matched the part's entity tag.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidPartOrder</p> </li>
    /// <li> <p> <i>Description:</i> The list of parts was not in ascending order. Parts list must be specified in order by part number.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidPayer</p> </li>
    /// <li> <p> <i>Description:</i> All access to this object has been disabled. Please contact Amazon Web Services Support for further assistance.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidPolicyDocument</p> </li>
    /// <li> <p> <i>Description:</i> The content of the form does not meet the conditions specified in the policy document.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidRange</p> </li>
    /// <li> <p> <i>Description:</i> The requested range cannot be satisfied.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 416 Requested Range Not Satisfiable</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
    /// <li> <p> <i>Description:</i> Please use <code>AWS4-HMAC-SHA256</code>.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>Code:</i> N/A</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
    /// <li> <p> <i>Description:</i> SOAP requests must be made over an HTTPS connection.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
    /// <li> <p> <i>Description:</i> Amazon S3 Transfer Acceleration is not supported for buckets with non-DNS compliant names.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>Code:</i> N/A</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
    /// <li> <p> <i>Description:</i> Amazon S3 Transfer Acceleration is not supported for buckets with periods (.) in their names.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>Code:</i> N/A</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
    /// <li> <p> <i>Description:</i> Amazon S3 Transfer Accelerate endpoint only supports virtual style requests.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>Code:</i> N/A</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
    /// <li> <p> <i>Description:</i> Amazon S3 Transfer Accelerate is not configured on this bucket.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>Code:</i> N/A</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
    /// <li> <p> <i>Description:</i> Amazon S3 Transfer Accelerate is disabled on this bucket.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>Code:</i> N/A</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
    /// <li> <p> <i>Description:</i> Amazon S3 Transfer Acceleration is not supported on this bucket. Contact Amazon Web Services Support for more information.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>Code:</i> N/A</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
    /// <li> <p> <i>Description:</i> Amazon S3 Transfer Acceleration cannot be enabled on this bucket. Contact Amazon Web Services Support for more information.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>Code:</i> N/A</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidSecurity</p> </li>
    /// <li> <p> <i>Description:</i> The provided security credentials are not valid.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidSOAPRequest</p> </li>
    /// <li> <p> <i>Description:</i> The SOAP request body is invalid.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidStorageClass</p> </li>
    /// <li> <p> <i>Description:</i> The storage class you specified is not valid.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidTargetBucketForLogging</p> </li>
    /// <li> <p> <i>Description:</i> The target bucket for logging does not exist, is not owned by you, or does not have the appropriate grants for the log-delivery group. </p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidToken</p> </li>
    /// <li> <p> <i>Description:</i> The provided token is malformed or otherwise invalid.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidURI</p> </li>
    /// <li> <p> <i>Description:</i> Couldn't parse the specified URI.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> KeyTooLongError</p> </li>
    /// <li> <p> <i>Description:</i> Your key is too long.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> MalformedACLError</p> </li>
    /// <li> <p> <i>Description:</i> The XML you provided was not well-formed or did not validate against our published schema.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> MalformedPOSTRequest </p> </li>
    /// <li> <p> <i>Description:</i> The body of your POST request is not well-formed multipart/form-data.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> MalformedXML</p> </li>
    /// <li> <p> <i>Description:</i> This happens when the user sends malformed XML (XML that doesn't conform to the published XSD) for the configuration. The error message is, "The XML you provided was not well-formed or did not validate against our published schema." </p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> MaxMessageLengthExceeded</p> </li>
    /// <li> <p> <i>Description:</i> Your request was too big.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> MaxPostPreDataLengthExceededError</p> </li>
    /// <li> <p> <i>Description:</i> Your POST request fields preceding the upload file were too large.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> MetadataTooLarge</p> </li>
    /// <li> <p> <i>Description:</i> Your metadata headers exceed the maximum allowed metadata size.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> MethodNotAllowed</p> </li>
    /// <li> <p> <i>Description:</i> The specified method is not allowed against this resource.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 405 Method Not Allowed</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> MissingAttachment</p> </li>
    /// <li> <p> <i>Description:</i> A SOAP attachment was expected, but none were found.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> N/A</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> MissingContentLength</p> </li>
    /// <li> <p> <i>Description:</i> You must provide the Content-Length HTTP header.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 411 Length Required</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> MissingRequestBodyError</p> </li>
    /// <li> <p> <i>Description:</i> This happens when the user sends an empty XML document as a request. The error message is, "Request body is empty." </p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> MissingSecurityElement</p> </li>
    /// <li> <p> <i>Description:</i> The SOAP 1.1 request is missing a security element.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> MissingSecurityHeader</p> </li>
    /// <li> <p> <i>Description:</i> Your request is missing a required header.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> NoLoggingStatusForKey</p> </li>
    /// <li> <p> <i>Description:</i> There is no such thing as a logging status subresource for a key.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> NoSuchBucket</p> </li>
    /// <li> <p> <i>Description:</i> The specified bucket does not exist.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> NoSuchBucketPolicy</p> </li>
    /// <li> <p> <i>Description:</i> The specified bucket does not have a bucket policy.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> NoSuchKey</p> </li>
    /// <li> <p> <i>Description:</i> The specified key does not exist.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> NoSuchLifecycleConfiguration</p> </li>
    /// <li> <p> <i>Description:</i> The lifecycle configuration does not exist. </p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> NoSuchUpload</p> </li>
    /// <li> <p> <i>Description:</i> The specified multipart upload does not exist. The upload ID might be invalid, or the multipart upload might have been aborted or completed.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> NoSuchVersion </p> </li>
    /// <li> <p> <i>Description:</i> Indicates that the version ID specified in the request does not match an existing version.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> NotImplemented</p> </li>
    /// <li> <p> <i>Description:</i> A header you provided implies functionality that is not implemented.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 501 Not Implemented</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Server</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> NotSignedUp</p> </li>
    /// <li> <p> <i>Description:</i> Your account is not signed up for the Amazon S3 service. You must sign up before you can use Amazon S3. You can sign up at the following URL: <a href="http://aws.amazon.com/s3">Amazon S3</a> </p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> OperationAborted</p> </li>
    /// <li> <p> <i>Description:</i> A conflicting conditional action is currently in progress against this resource. Try again.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 409 Conflict</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> PermanentRedirect</p> </li>
    /// <li> <p> <i>Description:</i> The bucket you are attempting to access must be addressed using the specified endpoint. Send all future requests to this endpoint.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 301 Moved Permanently</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> PreconditionFailed</p> </li>
    /// <li> <p> <i>Description:</i> At least one of the preconditions you specified did not hold.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 412 Precondition Failed</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> Redirect</p> </li>
    /// <li> <p> <i>Description:</i> Temporary redirect.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 307 Moved Temporarily</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> RestoreAlreadyInProgress</p> </li>
    /// <li> <p> <i>Description:</i> Object restore is already in progress.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 409 Conflict</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> RequestIsNotMultiPartContent</p> </li>
    /// <li> <p> <i>Description:</i> Bucket POST must be of the enclosure-type multipart/form-data.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> RequestTimeout</p> </li>
    /// <li> <p> <i>Description:</i> Your socket connection to the server was not read from or written to within the timeout period.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> RequestTimeTooSkewed</p> </li>
    /// <li> <p> <i>Description:</i> The difference between the request time and the server's time is too large.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> RequestTorrentOfBucketError</p> </li>
    /// <li> <p> <i>Description:</i> Requesting the torrent file of a bucket is not permitted.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> SignatureDoesNotMatch</p> </li>
    /// <li> <p> <i>Description:</i> The request signature we calculated does not match the signature you provided. Check your Amazon Web Services secret access key and signing method. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">REST Authentication</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/SOAPAuthentication.html">SOAP Authentication</a> for details.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> ServiceUnavailable</p> </li>
    /// <li> <p> <i>Description:</i> Reduce your request rate.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 503 Service Unavailable</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Server</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> SlowDown</p> </li>
    /// <li> <p> <i>Description:</i> Reduce your request rate.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 503 Slow Down</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Server</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> TemporaryRedirect</p> </li>
    /// <li> <p> <i>Description:</i> You are being redirected to the bucket while DNS updates.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 307 Moved Temporarily</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> TokenRefreshRequired</p> </li>
    /// <li> <p> <i>Description:</i> The provided token must be refreshed.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> TooManyBuckets</p> </li>
    /// <li> <p> <i>Description:</i> You have attempted to create more buckets than allowed.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> UnexpectedContent</p> </li>
    /// <li> <p> <i>Description:</i> This request does not support content.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> UnresolvableGrantByEmailAddress</p> </li>
    /// <li> <p> <i>Description:</i> The email address you provided does not match any account on record.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> UserKeyMustBeSpecified</p> </li>
    /// <li> <p> <i>Description:</i> The bucket POST must contain the specified field name. If it is specified, check the order of the fields.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p></p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl Error {
    /// <p>The error key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The version ID of the error.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
    /// <p class="title"> <b>Amazon S3 error codes</b> </p>
    /// <ul>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> AccessDenied </p> </li>
    /// <li> <p> <i>Description:</i> Access Denied</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> AccountProblem</p> </li>
    /// <li> <p> <i>Description:</i> There is a problem with your Amazon Web Services account that prevents the action from completing successfully. Contact Amazon Web Services Support for further assistance.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> AllAccessDisabled</p> </li>
    /// <li> <p> <i>Description:</i> All access to this Amazon S3 resource has been disabled. Contact Amazon Web Services Support for further assistance.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> AmbiguousGrantByEmailAddress</p> </li>
    /// <li> <p> <i>Description:</i> The email address you provided is associated with more than one account.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> AuthorizationHeaderMalformed</p> </li>
    /// <li> <p> <i>Description:</i> The authorization header you provided is invalid.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> N/A</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> BadDigest</p> </li>
    /// <li> <p> <i>Description:</i> The Content-MD5 you specified did not match what we received.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> BucketAlreadyExists</p> </li>
    /// <li> <p> <i>Description:</i> The requested bucket name is not available. The bucket namespace is shared by all users of the system. Please select a different name and try again.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 409 Conflict</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> BucketAlreadyOwnedByYou</p> </li>
    /// <li> <p> <i>Description:</i> The bucket you tried to create already exists, and you own it. Amazon S3 returns this error in all Amazon Web Services Regions except in the North Virginia Region. For legacy compatibility, if you re-create an existing bucket that you already own in the North Virginia Region, Amazon S3 returns 200 OK and resets the bucket access control lists (ACLs).</p> </li>
    /// <li> <p> <i>Code:</i> 409 Conflict (in all Regions except the North Virginia Region) </p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> BucketNotEmpty</p> </li>
    /// <li> <p> <i>Description:</i> The bucket you tried to delete is not empty.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 409 Conflict</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> CredentialsNotSupported</p> </li>
    /// <li> <p> <i>Description:</i> This request does not support credentials.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> CrossLocationLoggingProhibited</p> </li>
    /// <li> <p> <i>Description:</i> Cross-location logging not allowed. Buckets in one geographic location cannot log information to a bucket in another location.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> EntityTooSmall</p> </li>
    /// <li> <p> <i>Description:</i> Your proposed upload is smaller than the minimum allowed object size.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> EntityTooLarge</p> </li>
    /// <li> <p> <i>Description:</i> Your proposed upload exceeds the maximum allowed object size.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> ExpiredToken</p> </li>
    /// <li> <p> <i>Description:</i> The provided token has expired.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> IllegalVersioningConfigurationException </p> </li>
    /// <li> <p> <i>Description:</i> Indicates that the versioning configuration specified in the request is invalid.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> IncompleteBody</p> </li>
    /// <li> <p> <i>Description:</i> You did not provide the number of bytes specified by the Content-Length HTTP header</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> IncorrectNumberOfFilesInPostRequest</p> </li>
    /// <li> <p> <i>Description:</i> POST requires exactly one file upload per request.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InlineDataTooLarge</p> </li>
    /// <li> <p> <i>Description:</i> Inline data exceeds the maximum allowed size.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InternalError</p> </li>
    /// <li> <p> <i>Description:</i> We encountered an internal error. Please try again.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 500 Internal Server Error</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Server</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidAccessKeyId</p> </li>
    /// <li> <p> <i>Description:</i> The Amazon Web Services access key ID you provided does not exist in our records.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidAddressingHeader</p> </li>
    /// <li> <p> <i>Description:</i> You must specify the Anonymous role.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> N/A</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidArgument</p> </li>
    /// <li> <p> <i>Description:</i> Invalid Argument</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidBucketName</p> </li>
    /// <li> <p> <i>Description:</i> The specified bucket is not valid.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidBucketState</p> </li>
    /// <li> <p> <i>Description:</i> The request is not valid with the current state of the bucket.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 409 Conflict</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidDigest</p> </li>
    /// <li> <p> <i>Description:</i> The Content-MD5 you specified is not valid.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidEncryptionAlgorithmError</p> </li>
    /// <li> <p> <i>Description:</i> The encryption request you specified is not valid. The valid value is AES256.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidLocationConstraint</p> </li>
    /// <li> <p> <i>Description:</i> The specified location constraint is not valid. For more information about Regions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingBucket.html#access-bucket-intro">How to Select a Region for Your Buckets</a>. </p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidObjectState</p> </li>
    /// <li> <p> <i>Description:</i> The action is not valid for the current state of the object.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidPart</p> </li>
    /// <li> <p> <i>Description:</i> One or more of the specified parts could not be found. The part might not have been uploaded, or the specified entity tag might not have matched the part's entity tag.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidPartOrder</p> </li>
    /// <li> <p> <i>Description:</i> The list of parts was not in ascending order. Parts list must be specified in order by part number.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidPayer</p> </li>
    /// <li> <p> <i>Description:</i> All access to this object has been disabled. Please contact Amazon Web Services Support for further assistance.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidPolicyDocument</p> </li>
    /// <li> <p> <i>Description:</i> The content of the form does not meet the conditions specified in the policy document.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidRange</p> </li>
    /// <li> <p> <i>Description:</i> The requested range cannot be satisfied.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 416 Requested Range Not Satisfiable</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
    /// <li> <p> <i>Description:</i> Please use <code>AWS4-HMAC-SHA256</code>.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>Code:</i> N/A</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
    /// <li> <p> <i>Description:</i> SOAP requests must be made over an HTTPS connection.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
    /// <li> <p> <i>Description:</i> Amazon S3 Transfer Acceleration is not supported for buckets with non-DNS compliant names.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>Code:</i> N/A</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
    /// <li> <p> <i>Description:</i> Amazon S3 Transfer Acceleration is not supported for buckets with periods (.) in their names.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>Code:</i> N/A</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
    /// <li> <p> <i>Description:</i> Amazon S3 Transfer Accelerate endpoint only supports virtual style requests.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>Code:</i> N/A</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
    /// <li> <p> <i>Description:</i> Amazon S3 Transfer Accelerate is not configured on this bucket.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>Code:</i> N/A</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
    /// <li> <p> <i>Description:</i> Amazon S3 Transfer Accelerate is disabled on this bucket.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>Code:</i> N/A</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
    /// <li> <p> <i>Description:</i> Amazon S3 Transfer Acceleration is not supported on this bucket. Contact Amazon Web Services Support for more information.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>Code:</i> N/A</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
    /// <li> <p> <i>Description:</i> Amazon S3 Transfer Acceleration cannot be enabled on this bucket. Contact Amazon Web Services Support for more information.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>Code:</i> N/A</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidSecurity</p> </li>
    /// <li> <p> <i>Description:</i> The provided security credentials are not valid.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidSOAPRequest</p> </li>
    /// <li> <p> <i>Description:</i> The SOAP request body is invalid.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidStorageClass</p> </li>
    /// <li> <p> <i>Description:</i> The storage class you specified is not valid.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidTargetBucketForLogging</p> </li>
    /// <li> <p> <i>Description:</i> The target bucket for logging does not exist, is not owned by you, or does not have the appropriate grants for the log-delivery group. </p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidToken</p> </li>
    /// <li> <p> <i>Description:</i> The provided token is malformed or otherwise invalid.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> InvalidURI</p> </li>
    /// <li> <p> <i>Description:</i> Couldn't parse the specified URI.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> KeyTooLongError</p> </li>
    /// <li> <p> <i>Description:</i> Your key is too long.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> MalformedACLError</p> </li>
    /// <li> <p> <i>Description:</i> The XML you provided was not well-formed or did not validate against our published schema.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> MalformedPOSTRequest </p> </li>
    /// <li> <p> <i>Description:</i> The body of your POST request is not well-formed multipart/form-data.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> MalformedXML</p> </li>
    /// <li> <p> <i>Description:</i> This happens when the user sends malformed XML (XML that doesn't conform to the published XSD) for the configuration. The error message is, "The XML you provided was not well-formed or did not validate against our published schema." </p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> MaxMessageLengthExceeded</p> </li>
    /// <li> <p> <i>Description:</i> Your request was too big.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> MaxPostPreDataLengthExceededError</p> </li>
    /// <li> <p> <i>Description:</i> Your POST request fields preceding the upload file were too large.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> MetadataTooLarge</p> </li>
    /// <li> <p> <i>Description:</i> Your metadata headers exceed the maximum allowed metadata size.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> MethodNotAllowed</p> </li>
    /// <li> <p> <i>Description:</i> The specified method is not allowed against this resource.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 405 Method Not Allowed</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> MissingAttachment</p> </li>
    /// <li> <p> <i>Description:</i> A SOAP attachment was expected, but none were found.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> N/A</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> MissingContentLength</p> </li>
    /// <li> <p> <i>Description:</i> You must provide the Content-Length HTTP header.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 411 Length Required</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> MissingRequestBodyError</p> </li>
    /// <li> <p> <i>Description:</i> This happens when the user sends an empty XML document as a request. The error message is, "Request body is empty." </p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> MissingSecurityElement</p> </li>
    /// <li> <p> <i>Description:</i> The SOAP 1.1 request is missing a security element.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> MissingSecurityHeader</p> </li>
    /// <li> <p> <i>Description:</i> Your request is missing a required header.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> NoLoggingStatusForKey</p> </li>
    /// <li> <p> <i>Description:</i> There is no such thing as a logging status subresource for a key.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> NoSuchBucket</p> </li>
    /// <li> <p> <i>Description:</i> The specified bucket does not exist.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> NoSuchBucketPolicy</p> </li>
    /// <li> <p> <i>Description:</i> The specified bucket does not have a bucket policy.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> NoSuchKey</p> </li>
    /// <li> <p> <i>Description:</i> The specified key does not exist.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> NoSuchLifecycleConfiguration</p> </li>
    /// <li> <p> <i>Description:</i> The lifecycle configuration does not exist. </p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> NoSuchUpload</p> </li>
    /// <li> <p> <i>Description:</i> The specified multipart upload does not exist. The upload ID might be invalid, or the multipart upload might have been aborted or completed.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> NoSuchVersion </p> </li>
    /// <li> <p> <i>Description:</i> Indicates that the version ID specified in the request does not match an existing version.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> NotImplemented</p> </li>
    /// <li> <p> <i>Description:</i> A header you provided implies functionality that is not implemented.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 501 Not Implemented</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Server</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> NotSignedUp</p> </li>
    /// <li> <p> <i>Description:</i> Your account is not signed up for the Amazon S3 service. You must sign up before you can use Amazon S3. You can sign up at the following URL: <a href="http://aws.amazon.com/s3">Amazon S3</a> </p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> OperationAborted</p> </li>
    /// <li> <p> <i>Description:</i> A conflicting conditional action is currently in progress against this resource. Try again.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 409 Conflict</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> PermanentRedirect</p> </li>
    /// <li> <p> <i>Description:</i> The bucket you are attempting to access must be addressed using the specified endpoint. Send all future requests to this endpoint.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 301 Moved Permanently</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> PreconditionFailed</p> </li>
    /// <li> <p> <i>Description:</i> At least one of the preconditions you specified did not hold.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 412 Precondition Failed</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> Redirect</p> </li>
    /// <li> <p> <i>Description:</i> Temporary redirect.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 307 Moved Temporarily</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> RestoreAlreadyInProgress</p> </li>
    /// <li> <p> <i>Description:</i> Object restore is already in progress.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 409 Conflict</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> RequestIsNotMultiPartContent</p> </li>
    /// <li> <p> <i>Description:</i> Bucket POST must be of the enclosure-type multipart/form-data.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> RequestTimeout</p> </li>
    /// <li> <p> <i>Description:</i> Your socket connection to the server was not read from or written to within the timeout period.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> RequestTimeTooSkewed</p> </li>
    /// <li> <p> <i>Description:</i> The difference between the request time and the server's time is too large.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> RequestTorrentOfBucketError</p> </li>
    /// <li> <p> <i>Description:</i> Requesting the torrent file of a bucket is not permitted.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> SignatureDoesNotMatch</p> </li>
    /// <li> <p> <i>Description:</i> The request signature we calculated does not match the signature you provided. Check your Amazon Web Services secret access key and signing method. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">REST Authentication</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/SOAPAuthentication.html">SOAP Authentication</a> for details.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> ServiceUnavailable</p> </li>
    /// <li> <p> <i>Description:</i> Reduce your request rate.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 503 Service Unavailable</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Server</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> SlowDown</p> </li>
    /// <li> <p> <i>Description:</i> Reduce your request rate.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 503 Slow Down</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Server</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> TemporaryRedirect</p> </li>
    /// <li> <p> <i>Description:</i> You are being redirected to the bucket while DNS updates.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 307 Moved Temporarily</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> TokenRefreshRequired</p> </li>
    /// <li> <p> <i>Description:</i> The provided token must be refreshed.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> TooManyBuckets</p> </li>
    /// <li> <p> <i>Description:</i> You have attempted to create more buckets than allowed.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> UnexpectedContent</p> </li>
    /// <li> <p> <i>Description:</i> This request does not support content.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> UnresolvableGrantByEmailAddress</p> </li>
    /// <li> <p> <i>Description:</i> The email address you provided does not match any account on record.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// <li>
    /// <ul>
    /// <li> <p> <i>Code:</i> UserKeyMustBeSpecified</p> </li>
    /// <li> <p> <i>Description:</i> The bucket POST must contain the specified field name. If it is specified, check the order of the fields.</p> </li>
    /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
    /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
    /// </ul> </li>
    /// </ul>
    /// <p></p>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Error");
        formatter.field("key", &self.key);
        formatter.field("version_id", &self.version_id);
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`Error`](crate::model::Error)
pub mod error {
    /// A builder for [`Error`](crate::model::Error)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The error key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The version ID of the error.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The version ID of the error.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        /// <p class="title"> <b>Amazon S3 error codes</b> </p>
        /// <ul>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> AccessDenied </p> </li>
        /// <li> <p> <i>Description:</i> Access Denied</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> AccountProblem</p> </li>
        /// <li> <p> <i>Description:</i> There is a problem with your Amazon Web Services account that prevents the action from completing successfully. Contact Amazon Web Services Support for further assistance.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> AllAccessDisabled</p> </li>
        /// <li> <p> <i>Description:</i> All access to this Amazon S3 resource has been disabled. Contact Amazon Web Services Support for further assistance.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> AmbiguousGrantByEmailAddress</p> </li>
        /// <li> <p> <i>Description:</i> The email address you provided is associated with more than one account.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> AuthorizationHeaderMalformed</p> </li>
        /// <li> <p> <i>Description:</i> The authorization header you provided is invalid.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> N/A</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> BadDigest</p> </li>
        /// <li> <p> <i>Description:</i> The Content-MD5 you specified did not match what we received.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> BucketAlreadyExists</p> </li>
        /// <li> <p> <i>Description:</i> The requested bucket name is not available. The bucket namespace is shared by all users of the system. Please select a different name and try again.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 409 Conflict</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> BucketAlreadyOwnedByYou</p> </li>
        /// <li> <p> <i>Description:</i> The bucket you tried to create already exists, and you own it. Amazon S3 returns this error in all Amazon Web Services Regions except in the North Virginia Region. For legacy compatibility, if you re-create an existing bucket that you already own in the North Virginia Region, Amazon S3 returns 200 OK and resets the bucket access control lists (ACLs).</p> </li>
        /// <li> <p> <i>Code:</i> 409 Conflict (in all Regions except the North Virginia Region) </p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> BucketNotEmpty</p> </li>
        /// <li> <p> <i>Description:</i> The bucket you tried to delete is not empty.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 409 Conflict</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> CredentialsNotSupported</p> </li>
        /// <li> <p> <i>Description:</i> This request does not support credentials.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> CrossLocationLoggingProhibited</p> </li>
        /// <li> <p> <i>Description:</i> Cross-location logging not allowed. Buckets in one geographic location cannot log information to a bucket in another location.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> EntityTooSmall</p> </li>
        /// <li> <p> <i>Description:</i> Your proposed upload is smaller than the minimum allowed object size.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> EntityTooLarge</p> </li>
        /// <li> <p> <i>Description:</i> Your proposed upload exceeds the maximum allowed object size.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> ExpiredToken</p> </li>
        /// <li> <p> <i>Description:</i> The provided token has expired.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> IllegalVersioningConfigurationException </p> </li>
        /// <li> <p> <i>Description:</i> Indicates that the versioning configuration specified in the request is invalid.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> IncompleteBody</p> </li>
        /// <li> <p> <i>Description:</i> You did not provide the number of bytes specified by the Content-Length HTTP header</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> IncorrectNumberOfFilesInPostRequest</p> </li>
        /// <li> <p> <i>Description:</i> POST requires exactly one file upload per request.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InlineDataTooLarge</p> </li>
        /// <li> <p> <i>Description:</i> Inline data exceeds the maximum allowed size.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InternalError</p> </li>
        /// <li> <p> <i>Description:</i> We encountered an internal error. Please try again.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 500 Internal Server Error</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Server</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidAccessKeyId</p> </li>
        /// <li> <p> <i>Description:</i> The Amazon Web Services access key ID you provided does not exist in our records.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidAddressingHeader</p> </li>
        /// <li> <p> <i>Description:</i> You must specify the Anonymous role.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> N/A</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidArgument</p> </li>
        /// <li> <p> <i>Description:</i> Invalid Argument</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidBucketName</p> </li>
        /// <li> <p> <i>Description:</i> The specified bucket is not valid.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidBucketState</p> </li>
        /// <li> <p> <i>Description:</i> The request is not valid with the current state of the bucket.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 409 Conflict</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidDigest</p> </li>
        /// <li> <p> <i>Description:</i> The Content-MD5 you specified is not valid.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidEncryptionAlgorithmError</p> </li>
        /// <li> <p> <i>Description:</i> The encryption request you specified is not valid. The valid value is AES256.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidLocationConstraint</p> </li>
        /// <li> <p> <i>Description:</i> The specified location constraint is not valid. For more information about Regions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingBucket.html#access-bucket-intro">How to Select a Region for Your Buckets</a>. </p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidObjectState</p> </li>
        /// <li> <p> <i>Description:</i> The action is not valid for the current state of the object.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidPart</p> </li>
        /// <li> <p> <i>Description:</i> One or more of the specified parts could not be found. The part might not have been uploaded, or the specified entity tag might not have matched the part's entity tag.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidPartOrder</p> </li>
        /// <li> <p> <i>Description:</i> The list of parts was not in ascending order. Parts list must be specified in order by part number.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidPayer</p> </li>
        /// <li> <p> <i>Description:</i> All access to this object has been disabled. Please contact Amazon Web Services Support for further assistance.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidPolicyDocument</p> </li>
        /// <li> <p> <i>Description:</i> The content of the form does not meet the conditions specified in the policy document.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidRange</p> </li>
        /// <li> <p> <i>Description:</i> The requested range cannot be satisfied.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 416 Requested Range Not Satisfiable</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
        /// <li> <p> <i>Description:</i> Please use <code>AWS4-HMAC-SHA256</code>.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>Code:</i> N/A</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
        /// <li> <p> <i>Description:</i> SOAP requests must be made over an HTTPS connection.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
        /// <li> <p> <i>Description:</i> Amazon S3 Transfer Acceleration is not supported for buckets with non-DNS compliant names.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>Code:</i> N/A</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
        /// <li> <p> <i>Description:</i> Amazon S3 Transfer Acceleration is not supported for buckets with periods (.) in their names.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>Code:</i> N/A</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
        /// <li> <p> <i>Description:</i> Amazon S3 Transfer Accelerate endpoint only supports virtual style requests.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>Code:</i> N/A</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
        /// <li> <p> <i>Description:</i> Amazon S3 Transfer Accelerate is not configured on this bucket.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>Code:</i> N/A</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
        /// <li> <p> <i>Description:</i> Amazon S3 Transfer Accelerate is disabled on this bucket.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>Code:</i> N/A</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
        /// <li> <p> <i>Description:</i> Amazon S3 Transfer Acceleration is not supported on this bucket. Contact Amazon Web Services Support for more information.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>Code:</i> N/A</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
        /// <li> <p> <i>Description:</i> Amazon S3 Transfer Acceleration cannot be enabled on this bucket. Contact Amazon Web Services Support for more information.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>Code:</i> N/A</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidSecurity</p> </li>
        /// <li> <p> <i>Description:</i> The provided security credentials are not valid.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidSOAPRequest</p> </li>
        /// <li> <p> <i>Description:</i> The SOAP request body is invalid.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidStorageClass</p> </li>
        /// <li> <p> <i>Description:</i> The storage class you specified is not valid.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidTargetBucketForLogging</p> </li>
        /// <li> <p> <i>Description:</i> The target bucket for logging does not exist, is not owned by you, or does not have the appropriate grants for the log-delivery group. </p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidToken</p> </li>
        /// <li> <p> <i>Description:</i> The provided token is malformed or otherwise invalid.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidURI</p> </li>
        /// <li> <p> <i>Description:</i> Couldn't parse the specified URI.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> KeyTooLongError</p> </li>
        /// <li> <p> <i>Description:</i> Your key is too long.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> MalformedACLError</p> </li>
        /// <li> <p> <i>Description:</i> The XML you provided was not well-formed or did not validate against our published schema.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> MalformedPOSTRequest </p> </li>
        /// <li> <p> <i>Description:</i> The body of your POST request is not well-formed multipart/form-data.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> MalformedXML</p> </li>
        /// <li> <p> <i>Description:</i> This happens when the user sends malformed XML (XML that doesn't conform to the published XSD) for the configuration. The error message is, "The XML you provided was not well-formed or did not validate against our published schema." </p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> MaxMessageLengthExceeded</p> </li>
        /// <li> <p> <i>Description:</i> Your request was too big.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> MaxPostPreDataLengthExceededError</p> </li>
        /// <li> <p> <i>Description:</i> Your POST request fields preceding the upload file were too large.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> MetadataTooLarge</p> </li>
        /// <li> <p> <i>Description:</i> Your metadata headers exceed the maximum allowed metadata size.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> MethodNotAllowed</p> </li>
        /// <li> <p> <i>Description:</i> The specified method is not allowed against this resource.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 405 Method Not Allowed</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> MissingAttachment</p> </li>
        /// <li> <p> <i>Description:</i> A SOAP attachment was expected, but none were found.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> N/A</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> MissingContentLength</p> </li>
        /// <li> <p> <i>Description:</i> You must provide the Content-Length HTTP header.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 411 Length Required</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> MissingRequestBodyError</p> </li>
        /// <li> <p> <i>Description:</i> This happens when the user sends an empty XML document as a request. The error message is, "Request body is empty." </p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> MissingSecurityElement</p> </li>
        /// <li> <p> <i>Description:</i> The SOAP 1.1 request is missing a security element.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> MissingSecurityHeader</p> </li>
        /// <li> <p> <i>Description:</i> Your request is missing a required header.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> NoLoggingStatusForKey</p> </li>
        /// <li> <p> <i>Description:</i> There is no such thing as a logging status subresource for a key.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> NoSuchBucket</p> </li>
        /// <li> <p> <i>Description:</i> The specified bucket does not exist.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> NoSuchBucketPolicy</p> </li>
        /// <li> <p> <i>Description:</i> The specified bucket does not have a bucket policy.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> NoSuchKey</p> </li>
        /// <li> <p> <i>Description:</i> The specified key does not exist.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> NoSuchLifecycleConfiguration</p> </li>
        /// <li> <p> <i>Description:</i> The lifecycle configuration does not exist. </p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> NoSuchUpload</p> </li>
        /// <li> <p> <i>Description:</i> The specified multipart upload does not exist. The upload ID might be invalid, or the multipart upload might have been aborted or completed.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> NoSuchVersion </p> </li>
        /// <li> <p> <i>Description:</i> Indicates that the version ID specified in the request does not match an existing version.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> NotImplemented</p> </li>
        /// <li> <p> <i>Description:</i> A header you provided implies functionality that is not implemented.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 501 Not Implemented</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Server</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> NotSignedUp</p> </li>
        /// <li> <p> <i>Description:</i> Your account is not signed up for the Amazon S3 service. You must sign up before you can use Amazon S3. You can sign up at the following URL: <a href="http://aws.amazon.com/s3">Amazon S3</a> </p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> OperationAborted</p> </li>
        /// <li> <p> <i>Description:</i> A conflicting conditional action is currently in progress against this resource. Try again.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 409 Conflict</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> PermanentRedirect</p> </li>
        /// <li> <p> <i>Description:</i> The bucket you are attempting to access must be addressed using the specified endpoint. Send all future requests to this endpoint.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 301 Moved Permanently</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> PreconditionFailed</p> </li>
        /// <li> <p> <i>Description:</i> At least one of the preconditions you specified did not hold.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 412 Precondition Failed</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> Redirect</p> </li>
        /// <li> <p> <i>Description:</i> Temporary redirect.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 307 Moved Temporarily</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> RestoreAlreadyInProgress</p> </li>
        /// <li> <p> <i>Description:</i> Object restore is already in progress.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 409 Conflict</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> RequestIsNotMultiPartContent</p> </li>
        /// <li> <p> <i>Description:</i> Bucket POST must be of the enclosure-type multipart/form-data.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> RequestTimeout</p> </li>
        /// <li> <p> <i>Description:</i> Your socket connection to the server was not read from or written to within the timeout period.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> RequestTimeTooSkewed</p> </li>
        /// <li> <p> <i>Description:</i> The difference between the request time and the server's time is too large.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> RequestTorrentOfBucketError</p> </li>
        /// <li> <p> <i>Description:</i> Requesting the torrent file of a bucket is not permitted.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> SignatureDoesNotMatch</p> </li>
        /// <li> <p> <i>Description:</i> The request signature we calculated does not match the signature you provided. Check your Amazon Web Services secret access key and signing method. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">REST Authentication</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/SOAPAuthentication.html">SOAP Authentication</a> for details.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> ServiceUnavailable</p> </li>
        /// <li> <p> <i>Description:</i> Reduce your request rate.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 503 Service Unavailable</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Server</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> SlowDown</p> </li>
        /// <li> <p> <i>Description:</i> Reduce your request rate.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 503 Slow Down</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Server</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> TemporaryRedirect</p> </li>
        /// <li> <p> <i>Description:</i> You are being redirected to the bucket while DNS updates.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 307 Moved Temporarily</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> TokenRefreshRequired</p> </li>
        /// <li> <p> <i>Description:</i> The provided token must be refreshed.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> TooManyBuckets</p> </li>
        /// <li> <p> <i>Description:</i> You have attempted to create more buckets than allowed.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> UnexpectedContent</p> </li>
        /// <li> <p> <i>Description:</i> This request does not support content.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> UnresolvableGrantByEmailAddress</p> </li>
        /// <li> <p> <i>Description:</i> The email address you provided does not match any account on record.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> UserKeyMustBeSpecified</p> </li>
        /// <li> <p> <i>Description:</i> The bucket POST must contain the specified field name. If it is specified, check the order of the fields.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// </ul>
        /// <p></p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type. </p>
        /// <p class="title"> <b>Amazon S3 error codes</b> </p>
        /// <ul>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> AccessDenied </p> </li>
        /// <li> <p> <i>Description:</i> Access Denied</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> AccountProblem</p> </li>
        /// <li> <p> <i>Description:</i> There is a problem with your Amazon Web Services account that prevents the action from completing successfully. Contact Amazon Web Services Support for further assistance.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> AllAccessDisabled</p> </li>
        /// <li> <p> <i>Description:</i> All access to this Amazon S3 resource has been disabled. Contact Amazon Web Services Support for further assistance.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> AmbiguousGrantByEmailAddress</p> </li>
        /// <li> <p> <i>Description:</i> The email address you provided is associated with more than one account.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> AuthorizationHeaderMalformed</p> </li>
        /// <li> <p> <i>Description:</i> The authorization header you provided is invalid.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> N/A</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> BadDigest</p> </li>
        /// <li> <p> <i>Description:</i> The Content-MD5 you specified did not match what we received.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> BucketAlreadyExists</p> </li>
        /// <li> <p> <i>Description:</i> The requested bucket name is not available. The bucket namespace is shared by all users of the system. Please select a different name and try again.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 409 Conflict</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> BucketAlreadyOwnedByYou</p> </li>
        /// <li> <p> <i>Description:</i> The bucket you tried to create already exists, and you own it. Amazon S3 returns this error in all Amazon Web Services Regions except in the North Virginia Region. For legacy compatibility, if you re-create an existing bucket that you already own in the North Virginia Region, Amazon S3 returns 200 OK and resets the bucket access control lists (ACLs).</p> </li>
        /// <li> <p> <i>Code:</i> 409 Conflict (in all Regions except the North Virginia Region) </p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> BucketNotEmpty</p> </li>
        /// <li> <p> <i>Description:</i> The bucket you tried to delete is not empty.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 409 Conflict</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> CredentialsNotSupported</p> </li>
        /// <li> <p> <i>Description:</i> This request does not support credentials.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> CrossLocationLoggingProhibited</p> </li>
        /// <li> <p> <i>Description:</i> Cross-location logging not allowed. Buckets in one geographic location cannot log information to a bucket in another location.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> EntityTooSmall</p> </li>
        /// <li> <p> <i>Description:</i> Your proposed upload is smaller than the minimum allowed object size.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> EntityTooLarge</p> </li>
        /// <li> <p> <i>Description:</i> Your proposed upload exceeds the maximum allowed object size.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> ExpiredToken</p> </li>
        /// <li> <p> <i>Description:</i> The provided token has expired.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> IllegalVersioningConfigurationException </p> </li>
        /// <li> <p> <i>Description:</i> Indicates that the versioning configuration specified in the request is invalid.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> IncompleteBody</p> </li>
        /// <li> <p> <i>Description:</i> You did not provide the number of bytes specified by the Content-Length HTTP header</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> IncorrectNumberOfFilesInPostRequest</p> </li>
        /// <li> <p> <i>Description:</i> POST requires exactly one file upload per request.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InlineDataTooLarge</p> </li>
        /// <li> <p> <i>Description:</i> Inline data exceeds the maximum allowed size.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InternalError</p> </li>
        /// <li> <p> <i>Description:</i> We encountered an internal error. Please try again.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 500 Internal Server Error</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Server</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidAccessKeyId</p> </li>
        /// <li> <p> <i>Description:</i> The Amazon Web Services access key ID you provided does not exist in our records.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidAddressingHeader</p> </li>
        /// <li> <p> <i>Description:</i> You must specify the Anonymous role.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> N/A</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidArgument</p> </li>
        /// <li> <p> <i>Description:</i> Invalid Argument</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidBucketName</p> </li>
        /// <li> <p> <i>Description:</i> The specified bucket is not valid.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidBucketState</p> </li>
        /// <li> <p> <i>Description:</i> The request is not valid with the current state of the bucket.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 409 Conflict</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidDigest</p> </li>
        /// <li> <p> <i>Description:</i> The Content-MD5 you specified is not valid.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidEncryptionAlgorithmError</p> </li>
        /// <li> <p> <i>Description:</i> The encryption request you specified is not valid. The valid value is AES256.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidLocationConstraint</p> </li>
        /// <li> <p> <i>Description:</i> The specified location constraint is not valid. For more information about Regions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingBucket.html#access-bucket-intro">How to Select a Region for Your Buckets</a>. </p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidObjectState</p> </li>
        /// <li> <p> <i>Description:</i> The action is not valid for the current state of the object.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidPart</p> </li>
        /// <li> <p> <i>Description:</i> One or more of the specified parts could not be found. The part might not have been uploaded, or the specified entity tag might not have matched the part's entity tag.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidPartOrder</p> </li>
        /// <li> <p> <i>Description:</i> The list of parts was not in ascending order. Parts list must be specified in order by part number.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidPayer</p> </li>
        /// <li> <p> <i>Description:</i> All access to this object has been disabled. Please contact Amazon Web Services Support for further assistance.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidPolicyDocument</p> </li>
        /// <li> <p> <i>Description:</i> The content of the form does not meet the conditions specified in the policy document.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidRange</p> </li>
        /// <li> <p> <i>Description:</i> The requested range cannot be satisfied.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 416 Requested Range Not Satisfiable</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
        /// <li> <p> <i>Description:</i> Please use <code>AWS4-HMAC-SHA256</code>.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>Code:</i> N/A</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
        /// <li> <p> <i>Description:</i> SOAP requests must be made over an HTTPS connection.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
        /// <li> <p> <i>Description:</i> Amazon S3 Transfer Acceleration is not supported for buckets with non-DNS compliant names.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>Code:</i> N/A</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
        /// <li> <p> <i>Description:</i> Amazon S3 Transfer Acceleration is not supported for buckets with periods (.) in their names.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>Code:</i> N/A</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
        /// <li> <p> <i>Description:</i> Amazon S3 Transfer Accelerate endpoint only supports virtual style requests.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>Code:</i> N/A</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
        /// <li> <p> <i>Description:</i> Amazon S3 Transfer Accelerate is not configured on this bucket.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>Code:</i> N/A</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
        /// <li> <p> <i>Description:</i> Amazon S3 Transfer Accelerate is disabled on this bucket.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>Code:</i> N/A</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
        /// <li> <p> <i>Description:</i> Amazon S3 Transfer Acceleration is not supported on this bucket. Contact Amazon Web Services Support for more information.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>Code:</i> N/A</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidRequest</p> </li>
        /// <li> <p> <i>Description:</i> Amazon S3 Transfer Acceleration cannot be enabled on this bucket. Contact Amazon Web Services Support for more information.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>Code:</i> N/A</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidSecurity</p> </li>
        /// <li> <p> <i>Description:</i> The provided security credentials are not valid.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidSOAPRequest</p> </li>
        /// <li> <p> <i>Description:</i> The SOAP request body is invalid.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidStorageClass</p> </li>
        /// <li> <p> <i>Description:</i> The storage class you specified is not valid.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidTargetBucketForLogging</p> </li>
        /// <li> <p> <i>Description:</i> The target bucket for logging does not exist, is not owned by you, or does not have the appropriate grants for the log-delivery group. </p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidToken</p> </li>
        /// <li> <p> <i>Description:</i> The provided token is malformed or otherwise invalid.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> InvalidURI</p> </li>
        /// <li> <p> <i>Description:</i> Couldn't parse the specified URI.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> KeyTooLongError</p> </li>
        /// <li> <p> <i>Description:</i> Your key is too long.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> MalformedACLError</p> </li>
        /// <li> <p> <i>Description:</i> The XML you provided was not well-formed or did not validate against our published schema.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> MalformedPOSTRequest </p> </li>
        /// <li> <p> <i>Description:</i> The body of your POST request is not well-formed multipart/form-data.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> MalformedXML</p> </li>
        /// <li> <p> <i>Description:</i> This happens when the user sends malformed XML (XML that doesn't conform to the published XSD) for the configuration. The error message is, "The XML you provided was not well-formed or did not validate against our published schema." </p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> MaxMessageLengthExceeded</p> </li>
        /// <li> <p> <i>Description:</i> Your request was too big.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> MaxPostPreDataLengthExceededError</p> </li>
        /// <li> <p> <i>Description:</i> Your POST request fields preceding the upload file were too large.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> MetadataTooLarge</p> </li>
        /// <li> <p> <i>Description:</i> Your metadata headers exceed the maximum allowed metadata size.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> MethodNotAllowed</p> </li>
        /// <li> <p> <i>Description:</i> The specified method is not allowed against this resource.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 405 Method Not Allowed</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> MissingAttachment</p> </li>
        /// <li> <p> <i>Description:</i> A SOAP attachment was expected, but none were found.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> N/A</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> MissingContentLength</p> </li>
        /// <li> <p> <i>Description:</i> You must provide the Content-Length HTTP header.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 411 Length Required</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> MissingRequestBodyError</p> </li>
        /// <li> <p> <i>Description:</i> This happens when the user sends an empty XML document as a request. The error message is, "Request body is empty." </p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> MissingSecurityElement</p> </li>
        /// <li> <p> <i>Description:</i> The SOAP 1.1 request is missing a security element.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> MissingSecurityHeader</p> </li>
        /// <li> <p> <i>Description:</i> Your request is missing a required header.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> NoLoggingStatusForKey</p> </li>
        /// <li> <p> <i>Description:</i> There is no such thing as a logging status subresource for a key.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> NoSuchBucket</p> </li>
        /// <li> <p> <i>Description:</i> The specified bucket does not exist.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> NoSuchBucketPolicy</p> </li>
        /// <li> <p> <i>Description:</i> The specified bucket does not have a bucket policy.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> NoSuchKey</p> </li>
        /// <li> <p> <i>Description:</i> The specified key does not exist.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> NoSuchLifecycleConfiguration</p> </li>
        /// <li> <p> <i>Description:</i> The lifecycle configuration does not exist. </p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> NoSuchUpload</p> </li>
        /// <li> <p> <i>Description:</i> The specified multipart upload does not exist. The upload ID might be invalid, or the multipart upload might have been aborted or completed.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> NoSuchVersion </p> </li>
        /// <li> <p> <i>Description:</i> Indicates that the version ID specified in the request does not match an existing version.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 404 Not Found</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> NotImplemented</p> </li>
        /// <li> <p> <i>Description:</i> A header you provided implies functionality that is not implemented.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 501 Not Implemented</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Server</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> NotSignedUp</p> </li>
        /// <li> <p> <i>Description:</i> Your account is not signed up for the Amazon S3 service. You must sign up before you can use Amazon S3. You can sign up at the following URL: <a href="http://aws.amazon.com/s3">Amazon S3</a> </p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> OperationAborted</p> </li>
        /// <li> <p> <i>Description:</i> A conflicting conditional action is currently in progress against this resource. Try again.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 409 Conflict</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> PermanentRedirect</p> </li>
        /// <li> <p> <i>Description:</i> The bucket you are attempting to access must be addressed using the specified endpoint. Send all future requests to this endpoint.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 301 Moved Permanently</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> PreconditionFailed</p> </li>
        /// <li> <p> <i>Description:</i> At least one of the preconditions you specified did not hold.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 412 Precondition Failed</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> Redirect</p> </li>
        /// <li> <p> <i>Description:</i> Temporary redirect.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 307 Moved Temporarily</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> RestoreAlreadyInProgress</p> </li>
        /// <li> <p> <i>Description:</i> Object restore is already in progress.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 409 Conflict</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> RequestIsNotMultiPartContent</p> </li>
        /// <li> <p> <i>Description:</i> Bucket POST must be of the enclosure-type multipart/form-data.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> RequestTimeout</p> </li>
        /// <li> <p> <i>Description:</i> Your socket connection to the server was not read from or written to within the timeout period.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> RequestTimeTooSkewed</p> </li>
        /// <li> <p> <i>Description:</i> The difference between the request time and the server's time is too large.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> RequestTorrentOfBucketError</p> </li>
        /// <li> <p> <i>Description:</i> Requesting the torrent file of a bucket is not permitted.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> SignatureDoesNotMatch</p> </li>
        /// <li> <p> <i>Description:</i> The request signature we calculated does not match the signature you provided. Check your Amazon Web Services secret access key and signing method. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">REST Authentication</a> and <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/SOAPAuthentication.html">SOAP Authentication</a> for details.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 403 Forbidden</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> ServiceUnavailable</p> </li>
        /// <li> <p> <i>Description:</i> Reduce your request rate.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 503 Service Unavailable</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Server</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> SlowDown</p> </li>
        /// <li> <p> <i>Description:</i> Reduce your request rate.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 503 Slow Down</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Server</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> TemporaryRedirect</p> </li>
        /// <li> <p> <i>Description:</i> You are being redirected to the bucket while DNS updates.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 307 Moved Temporarily</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> TokenRefreshRequired</p> </li>
        /// <li> <p> <i>Description:</i> The provided token must be refreshed.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> TooManyBuckets</p> </li>
        /// <li> <p> <i>Description:</i> You have attempted to create more buckets than allowed.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> UnexpectedContent</p> </li>
        /// <li> <p> <i>Description:</i> This request does not support content.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> UnresolvableGrantByEmailAddress</p> </li>
        /// <li> <p> <i>Description:</i> The email address you provided does not match any account on record.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// <li>
        /// <ul>
        /// <li> <p> <i>Code:</i> UserKeyMustBeSpecified</p> </li>
        /// <li> <p> <i>Description:</i> The bucket POST must contain the specified field name. If it is specified, check the order of the fields.</p> </li>
        /// <li> <p> <i>HTTP Status Code:</i> 400 Bad Request</p> </li>
        /// <li> <p> <i>SOAP Fault Code Prefix:</i> Client</p> </li>
        /// </ul> </li>
        /// </ul>
        /// <p></p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`Error`](crate::model::Error)
        pub fn build(self) -> crate::model::Error {
            crate::model::Error {
                key: self.key,
                version_id: self.version_id,
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl Error {
    /// Creates a new builder-style object to manufacture [`Error`](crate::model::Error)
    pub fn builder() -> crate::model::error::Builder {
        crate::model::error::Builder::default()
    }
}

/// <p>Information about the deleted object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletedObject {
    /// <p>The name of the deleted object.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The version ID of the deleted object.</p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the versioned object that was permanently deleted was (true) or was not (false) a delete marker. In a simple DELETE, this header indicates whether (true) or not (false) a delete marker was created.</p>
    pub delete_marker: bool,
    /// <p>The version ID of the delete marker created as a result of the DELETE operation. If you delete a specific object version, the value returned by this header is the version ID of the object version deleted.</p>
    pub delete_marker_version_id: std::option::Option<std::string::String>,
}
impl DeletedObject {
    /// <p>The name of the deleted object.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The version ID of the deleted object.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>Specifies whether the versioned object that was permanently deleted was (true) or was not (false) a delete marker. In a simple DELETE, this header indicates whether (true) or not (false) a delete marker was created.</p>
    pub fn delete_marker(&self) -> bool {
        self.delete_marker
    }
    /// <p>The version ID of the delete marker created as a result of the DELETE operation. If you delete a specific object version, the value returned by this header is the version ID of the object version deleted.</p>
    pub fn delete_marker_version_id(&self) -> std::option::Option<&str> {
        self.delete_marker_version_id.as_deref()
    }
}
impl std::fmt::Debug for DeletedObject {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletedObject");
        formatter.field("key", &self.key);
        formatter.field("version_id", &self.version_id);
        formatter.field("delete_marker", &self.delete_marker);
        formatter.field("delete_marker_version_id", &self.delete_marker_version_id);
        formatter.finish()
    }
}
/// See [`DeletedObject`](crate::model::DeletedObject)
pub mod deleted_object {
    /// A builder for [`DeletedObject`](crate::model::DeletedObject)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) delete_marker: std::option::Option<bool>,
        pub(crate) delete_marker_version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the deleted object.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The name of the deleted object.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The version ID of the deleted object.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The version ID of the deleted object.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>Specifies whether the versioned object that was permanently deleted was (true) or was not (false) a delete marker. In a simple DELETE, this header indicates whether (true) or not (false) a delete marker was created.</p>
        pub fn delete_marker(mut self, input: bool) -> Self {
            self.delete_marker = Some(input);
            self
        }
        /// <p>Specifies whether the versioned object that was permanently deleted was (true) or was not (false) a delete marker. In a simple DELETE, this header indicates whether (true) or not (false) a delete marker was created.</p>
        pub fn set_delete_marker(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_marker = input;
            self
        }
        /// <p>The version ID of the delete marker created as a result of the DELETE operation. If you delete a specific object version, the value returned by this header is the version ID of the object version deleted.</p>
        pub fn delete_marker_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.delete_marker_version_id = Some(input.into());
            self
        }
        /// <p>The version ID of the delete marker created as a result of the DELETE operation. If you delete a specific object version, the value returned by this header is the version ID of the object version deleted.</p>
        pub fn set_delete_marker_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delete_marker_version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletedObject`](crate::model::DeletedObject)
        pub fn build(self) -> crate::model::DeletedObject {
            crate::model::DeletedObject {
                key: self.key,
                version_id: self.version_id,
                delete_marker: self.delete_marker.unwrap_or_default(),
                delete_marker_version_id: self.delete_marker_version_id,
            }
        }
    }
}
impl DeletedObject {
    /// Creates a new builder-style object to manufacture [`DeletedObject`](crate::model::DeletedObject)
    pub fn builder() -> crate::model::deleted_object::Builder {
        crate::model::deleted_object::Builder::default()
    }
}

/// <p>Container for the objects to delete.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Delete {
    /// <p>The objects to delete.</p>
    pub objects: std::option::Option<std::vec::Vec<crate::model::ObjectIdentifier>>,
    /// <p>Element to enable quiet mode for the request. When you add this element, you must set its value to true.</p>
    pub quiet: bool,
}
impl Delete {
    /// <p>The objects to delete.</p>
    pub fn objects(&self) -> std::option::Option<&[crate::model::ObjectIdentifier]> {
        self.objects.as_deref()
    }
    /// <p>Element to enable quiet mode for the request. When you add this element, you must set its value to true.</p>
    pub fn quiet(&self) -> bool {
        self.quiet
    }
}
impl std::fmt::Debug for Delete {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Delete");
        formatter.field("objects", &self.objects);
        formatter.field("quiet", &self.quiet);
        formatter.finish()
    }
}
/// See [`Delete`](crate::model::Delete)
pub mod delete {
    /// A builder for [`Delete`](crate::model::Delete)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) objects: std::option::Option<std::vec::Vec<crate::model::ObjectIdentifier>>,
        pub(crate) quiet: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `objects`.
        ///
        /// To override the contents of this collection use [`set_objects`](Self::set_objects).
        ///
        /// <p>The objects to delete.</p>
        pub fn objects(mut self, input: crate::model::ObjectIdentifier) -> Self {
            let mut v = self.objects.unwrap_or_default();
            v.push(input);
            self.objects = Some(v);
            self
        }
        /// <p>The objects to delete.</p>
        pub fn set_objects(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ObjectIdentifier>>,
        ) -> Self {
            self.objects = input;
            self
        }
        /// <p>Element to enable quiet mode for the request. When you add this element, you must set its value to true.</p>
        pub fn quiet(mut self, input: bool) -> Self {
            self.quiet = Some(input);
            self
        }
        /// <p>Element to enable quiet mode for the request. When you add this element, you must set its value to true.</p>
        pub fn set_quiet(mut self, input: std::option::Option<bool>) -> Self {
            self.quiet = input;
            self
        }
        /// Consumes the builder and constructs a [`Delete`](crate::model::Delete)
        pub fn build(self) -> crate::model::Delete {
            crate::model::Delete {
                objects: self.objects,
                quiet: self.quiet.unwrap_or_default(),
            }
        }
    }
}
impl Delete {
    /// Creates a new builder-style object to manufacture [`Delete`](crate::model::Delete)
    pub fn builder() -> crate::model::delete::Builder {
        crate::model::delete::Builder::default()
    }
}

/// <p>Object Identifier is unique value to identify objects.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ObjectIdentifier {
    /// <p>Key name of the object.</p> <important>
    /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
    /// </important>
    pub key: std::option::Option<std::string::String>,
    /// <p>VersionId for the specific version of the object to delete.</p>
    pub version_id: std::option::Option<std::string::String>,
}
impl ObjectIdentifier {
    /// <p>Key name of the object.</p> <important>
    /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
    /// </important>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>VersionId for the specific version of the object to delete.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
}
impl std::fmt::Debug for ObjectIdentifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ObjectIdentifier");
        formatter.field("key", &self.key);
        formatter.field("version_id", &self.version_id);
        formatter.finish()
    }
}
/// See [`ObjectIdentifier`](crate::model::ObjectIdentifier)
pub mod object_identifier {
    /// A builder for [`ObjectIdentifier`](crate::model::ObjectIdentifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Key name of the object.</p> <important>
        /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
        /// </important>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Key name of the object.</p> <important>
        /// <p>Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints"> XML related object key constraints</a>.</p>
        /// </important>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>VersionId for the specific version of the object to delete.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>VersionId for the specific version of the object to delete.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ObjectIdentifier`](crate::model::ObjectIdentifier)
        pub fn build(self) -> crate::model::ObjectIdentifier {
            crate::model::ObjectIdentifier {
                key: self.key,
                version_id: self.version_id,
            }
        }
    }
}
impl ObjectIdentifier {
    /// Creates a new builder-style object to manufacture [`ObjectIdentifier`](crate::model::ObjectIdentifier)
    pub fn builder() -> crate::model::object_identifier::Builder {
        crate::model::object_identifier::Builder::default()
    }
}

/// <p>The configuration information for the bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBucketConfiguration {
    /// <p>Specifies the Region where the bucket will be created. If you don't specify a Region, the bucket is created in the US East (N. Virginia) Region (us-east-1).</p>
    pub location_constraint: std::option::Option<crate::model::BucketLocationConstraint>,
}
impl CreateBucketConfiguration {
    /// <p>Specifies the Region where the bucket will be created. If you don't specify a Region, the bucket is created in the US East (N. Virginia) Region (us-east-1).</p>
    pub fn location_constraint(
        &self,
    ) -> std::option::Option<&crate::model::BucketLocationConstraint> {
        self.location_constraint.as_ref()
    }
}
impl std::fmt::Debug for CreateBucketConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBucketConfiguration");
        formatter.field("location_constraint", &self.location_constraint);
        formatter.finish()
    }
}
/// See [`CreateBucketConfiguration`](crate::model::CreateBucketConfiguration)
pub mod create_bucket_configuration {
    /// A builder for [`CreateBucketConfiguration`](crate::model::CreateBucketConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location_constraint: std::option::Option<crate::model::BucketLocationConstraint>,
    }
    impl Builder {
        /// <p>Specifies the Region where the bucket will be created. If you don't specify a Region, the bucket is created in the US East (N. Virginia) Region (us-east-1).</p>
        pub fn location_constraint(
            mut self,
            input: crate::model::BucketLocationConstraint,
        ) -> Self {
            self.location_constraint = Some(input);
            self
        }
        /// <p>Specifies the Region where the bucket will be created. If you don't specify a Region, the bucket is created in the US East (N. Virginia) Region (us-east-1).</p>
        pub fn set_location_constraint(
            mut self,
            input: std::option::Option<crate::model::BucketLocationConstraint>,
        ) -> Self {
            self.location_constraint = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBucketConfiguration`](crate::model::CreateBucketConfiguration)
        pub fn build(self) -> crate::model::CreateBucketConfiguration {
            crate::model::CreateBucketConfiguration {
                location_constraint: self.location_constraint,
            }
        }
    }
}
impl CreateBucketConfiguration {
    /// Creates a new builder-style object to manufacture [`CreateBucketConfiguration`](crate::model::CreateBucketConfiguration)
    pub fn builder() -> crate::model::create_bucket_configuration::Builder {
        crate::model::create_bucket_configuration::Builder::default()
    }
}

/// <p>Container for all response elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyObjectResult {
    /// <p>Returns the ETag of the new object. The ETag reflects only changes to the contents of an object, not its metadata.</p>
    pub e_tag: std::option::Option<std::string::String>,
    /// <p>Creation date of the object.</p>
    pub last_modified: std::option::Option<aws_smithy_types::DateTime>,
}
impl CopyObjectResult {
    /// <p>Returns the ETag of the new object. The ETag reflects only changes to the contents of an object, not its metadata.</p>
    pub fn e_tag(&self) -> std::option::Option<&str> {
        self.e_tag.as_deref()
    }
    /// <p>Creation date of the object.</p>
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified.as_ref()
    }
}
impl std::fmt::Debug for CopyObjectResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyObjectResult");
        formatter.field("e_tag", &self.e_tag);
        formatter.field("last_modified", &self.last_modified);
        formatter.finish()
    }
}
/// See [`CopyObjectResult`](crate::model::CopyObjectResult)
pub mod copy_object_result {
    /// A builder for [`CopyObjectResult`](crate::model::CopyObjectResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) e_tag: std::option::Option<std::string::String>,
        pub(crate) last_modified: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Returns the ETag of the new object. The ETag reflects only changes to the contents of an object, not its metadata.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>Returns the ETag of the new object. The ETag reflects only changes to the contents of an object, not its metadata.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// <p>Creation date of the object.</p>
        pub fn last_modified(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>Creation date of the object.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyObjectResult`](crate::model::CopyObjectResult)
        pub fn build(self) -> crate::model::CopyObjectResult {
            crate::model::CopyObjectResult {
                e_tag: self.e_tag,
                last_modified: self.last_modified,
            }
        }
    }
}
impl CopyObjectResult {
    /// Creates a new builder-style object to manufacture [`CopyObjectResult`](crate::model::CopyObjectResult)
    pub fn builder() -> crate::model::copy_object_result::Builder {
        crate::model::copy_object_result::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TaggingDirective {
    #[allow(missing_docs)] // documentation missing in model
    Copy,
    #[allow(missing_docs)] // documentation missing in model
    Replace,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TaggingDirective {
    fn from(s: &str) -> Self {
        match s {
            "COPY" => TaggingDirective::Copy,
            "REPLACE" => TaggingDirective::Replace,
            other => TaggingDirective::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TaggingDirective {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TaggingDirective::from(s))
    }
}
impl TaggingDirective {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TaggingDirective::Copy => "COPY",
            TaggingDirective::Replace => "REPLACE",
            TaggingDirective::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COPY", "REPLACE"]
    }
}
impl AsRef<str> for TaggingDirective {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MetadataDirective {
    #[allow(missing_docs)] // documentation missing in model
    Copy,
    #[allow(missing_docs)] // documentation missing in model
    Replace,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MetadataDirective {
    fn from(s: &str) -> Self {
        match s {
            "COPY" => MetadataDirective::Copy,
            "REPLACE" => MetadataDirective::Replace,
            other => MetadataDirective::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MetadataDirective {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MetadataDirective::from(s))
    }
}
impl MetadataDirective {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MetadataDirective::Copy => "COPY",
            MetadataDirective::Replace => "REPLACE",
            MetadataDirective::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COPY", "REPLACE"]
    }
}
impl AsRef<str> for MetadataDirective {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The container for the completed multipart upload details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CompletedMultipartUpload {
    /// <p>Array of CompletedPart data types.</p>
    /// <p>If you do not supply a valid <code>Part</code> with your request, the service sends back an HTTP 400 response.</p>
    pub parts: std::option::Option<std::vec::Vec<crate::model::CompletedPart>>,
}
impl CompletedMultipartUpload {
    /// <p>Array of CompletedPart data types.</p>
    /// <p>If you do not supply a valid <code>Part</code> with your request, the service sends back an HTTP 400 response.</p>
    pub fn parts(&self) -> std::option::Option<&[crate::model::CompletedPart]> {
        self.parts.as_deref()
    }
}
impl std::fmt::Debug for CompletedMultipartUpload {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CompletedMultipartUpload");
        formatter.field("parts", &self.parts);
        formatter.finish()
    }
}
/// See [`CompletedMultipartUpload`](crate::model::CompletedMultipartUpload)
pub mod completed_multipart_upload {
    /// A builder for [`CompletedMultipartUpload`](crate::model::CompletedMultipartUpload)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parts: std::option::Option<std::vec::Vec<crate::model::CompletedPart>>,
    }
    impl Builder {
        /// Appends an item to `parts`.
        ///
        /// To override the contents of this collection use [`set_parts`](Self::set_parts).
        ///
        /// <p>Array of CompletedPart data types.</p>
        /// <p>If you do not supply a valid <code>Part</code> with your request, the service sends back an HTTP 400 response.</p>
        pub fn parts(mut self, input: crate::model::CompletedPart) -> Self {
            let mut v = self.parts.unwrap_or_default();
            v.push(input);
            self.parts = Some(v);
            self
        }
        /// <p>Array of CompletedPart data types.</p>
        /// <p>If you do not supply a valid <code>Part</code> with your request, the service sends back an HTTP 400 response.</p>
        pub fn set_parts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CompletedPart>>,
        ) -> Self {
            self.parts = input;
            self
        }
        /// Consumes the builder and constructs a [`CompletedMultipartUpload`](crate::model::CompletedMultipartUpload)
        pub fn build(self) -> crate::model::CompletedMultipartUpload {
            crate::model::CompletedMultipartUpload { parts: self.parts }
        }
    }
}
impl CompletedMultipartUpload {
    /// Creates a new builder-style object to manufacture [`CompletedMultipartUpload`](crate::model::CompletedMultipartUpload)
    pub fn builder() -> crate::model::completed_multipart_upload::Builder {
        crate::model::completed_multipart_upload::Builder::default()
    }
}

/// <p>Details of the parts that were uploaded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CompletedPart {
    /// <p>Entity tag returned when the part was uploaded.</p>
    pub e_tag: std::option::Option<std::string::String>,
    /// <p>Part number that identifies the part. This is a positive integer between 1 and 10,000.</p>
    pub part_number: i32,
}
impl CompletedPart {
    /// <p>Entity tag returned when the part was uploaded.</p>
    pub fn e_tag(&self) -> std::option::Option<&str> {
        self.e_tag.as_deref()
    }
    /// <p>Part number that identifies the part. This is a positive integer between 1 and 10,000.</p>
    pub fn part_number(&self) -> i32 {
        self.part_number
    }
}
impl std::fmt::Debug for CompletedPart {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CompletedPart");
        formatter.field("e_tag", &self.e_tag);
        formatter.field("part_number", &self.part_number);
        formatter.finish()
    }
}
/// See [`CompletedPart`](crate::model::CompletedPart)
pub mod completed_part {
    /// A builder for [`CompletedPart`](crate::model::CompletedPart)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) e_tag: std::option::Option<std::string::String>,
        pub(crate) part_number: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Entity tag returned when the part was uploaded.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>Entity tag returned when the part was uploaded.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// <p>Part number that identifies the part. This is a positive integer between 1 and 10,000.</p>
        pub fn part_number(mut self, input: i32) -> Self {
            self.part_number = Some(input);
            self
        }
        /// <p>Part number that identifies the part. This is a positive integer between 1 and 10,000.</p>
        pub fn set_part_number(mut self, input: std::option::Option<i32>) -> Self {
            self.part_number = input;
            self
        }
        /// Consumes the builder and constructs a [`CompletedPart`](crate::model::CompletedPart)
        pub fn build(self) -> crate::model::CompletedPart {
            crate::model::CompletedPart {
                e_tag: self.e_tag,
                part_number: self.part_number.unwrap_or_default(),
            }
        }
    }
}
impl CompletedPart {
    /// Creates a new builder-style object to manufacture [`CompletedPart`](crate::model::CompletedPart)
    pub fn builder() -> crate::model::completed_part::Builder {
        crate::model::completed_part::Builder::default()
    }
}
