// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AbortMultipartUploadInput`](crate::input::AbortMultipartUploadInput)
pub mod abort_multipart_upload_input {
    /// A builder for [`AbortMultipartUploadInput`](crate::input::AbortMultipartUploadInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) upload_id: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name to which the upload was taking place. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name to which the upload was taking place. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Key of the object for which the multipart upload was initiated.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Key of the object for which the multipart upload was initiated.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Upload ID that identifies the multipart upload.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>Upload ID that identifies the multipart upload.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`AbortMultipartUploadInput`](crate::input::AbortMultipartUploadInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AbortMultipartUploadInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AbortMultipartUploadInput {
                bucket: self.bucket,
                key: self.key,
                upload_id: self.upload_id,
                request_payer: self.request_payer,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type AbortMultipartUploadInputOperationOutputAlias = crate::operation::AbortMultipartUpload;
#[doc(hidden)]
pub type AbortMultipartUploadInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AbortMultipartUploadInput {
    /// Consumes the builder and constructs an Operation<[`AbortMultipartUpload`](crate::operation::AbortMultipartUpload)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AbortMultipartUpload,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AbortMultipartUploadInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.bucket;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_1, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            let input_2 = &_input.key;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    })?;
            let key = aws_smithy_http::label::fmt_string(input_2, true);
            if key.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "key",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::AbortMultipartUploadInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_3) = &_input.request_payer {
                let formatted_4 = AsRef::<str>::as_ref(inner_3);
                if !formatted_4.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_4;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "request_payer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-request-payer", header_value);
                }
            }
            if let Some(inner_5) = &_input.expected_bucket_owner {
                let formatted_6 = AsRef::<str>::as_ref(inner_5);
                if !formatted_6.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_6;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::AbortMultipartUploadInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("x-id", "AbortMultipartUpload");
            if let Some(inner_7) = &_input.upload_id {
                query.push_kv("uploadId", &aws_smithy_http::query::fmt_string(&inner_7));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AbortMultipartUploadInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AbortMultipartUploadInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AbortMultipartUpload::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AbortMultipartUpload",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AbortMultipartUploadInput`](crate::input::AbortMultipartUploadInput)
    pub fn builder() -> crate::input::abort_multipart_upload_input::Builder {
        crate::input::abort_multipart_upload_input::Builder::default()
    }
}

/// See [`CompleteMultipartUploadInput`](crate::input::CompleteMultipartUploadInput)
pub mod complete_multipart_upload_input {
    /// A builder for [`CompleteMultipartUploadInput`](crate::input::CompleteMultipartUploadInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) multipart_upload: std::option::Option<crate::model::CompletedMultipartUpload>,
        pub(crate) upload_id: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the bucket to which the multipart upload was initiated.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>Name of the bucket to which the multipart upload was initiated.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Object key for which the multipart upload was initiated.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Object key for which the multipart upload was initiated.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The container for the multipart upload request information.</p>
        pub fn multipart_upload(mut self, input: crate::model::CompletedMultipartUpload) -> Self {
            self.multipart_upload = Some(input);
            self
        }
        /// <p>The container for the multipart upload request information.</p>
        pub fn set_multipart_upload(
            mut self,
            input: std::option::Option<crate::model::CompletedMultipartUpload>,
        ) -> Self {
            self.multipart_upload = input;
            self
        }
        /// <p>ID for the initiated multipart upload.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>ID for the initiated multipart upload.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`CompleteMultipartUploadInput`](crate::input::CompleteMultipartUploadInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CompleteMultipartUploadInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CompleteMultipartUploadInput {
                bucket: self.bucket,
                key: self.key,
                multipart_upload: self.multipart_upload,
                upload_id: self.upload_id,
                request_payer: self.request_payer,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type CompleteMultipartUploadInputOperationOutputAlias =
    crate::operation::CompleteMultipartUpload;
#[doc(hidden)]
pub type CompleteMultipartUploadInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CompleteMultipartUploadInput {
    /// Consumes the builder and constructs an Operation<[`CompleteMultipartUpload`](crate::operation::CompleteMultipartUpload)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CompleteMultipartUpload,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CompleteMultipartUploadInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.bucket;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_8, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            let input_9 = &_input.key;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    })?;
            let key = aws_smithy_http::label::fmt_string(input_9, true);
            if key.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "key",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CompleteMultipartUploadInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_10) = &_input.request_payer {
                let formatted_11 = AsRef::<str>::as_ref(inner_10);
                if !formatted_11.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_11;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "request_payer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-request-payer", header_value);
                }
            }
            if let Some(inner_12) = &_input.expected_bucket_owner {
                let formatted_13 = AsRef::<str>::as_ref(inner_12);
                if !formatted_13.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_13;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::CompleteMultipartUploadInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("x-id", "CompleteMultipartUpload");
            if let Some(inner_14) = &_input.upload_id {
                query.push_kv("uploadId", &aws_smithy_http::query::fmt_string(&inner_14));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CompleteMultipartUploadInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CompleteMultipartUploadInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::ser_payload_complete_multipart_upload_input(
            &self.multipart_upload,
        )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CompleteMultipartUpload::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CompleteMultipartUpload",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CompleteMultipartUploadInput`](crate::input::CompleteMultipartUploadInput)
    pub fn builder() -> crate::input::complete_multipart_upload_input::Builder {
        crate::input::complete_multipart_upload_input::Builder::default()
    }
}

/// See [`CopyObjectInput`](crate::input::CopyObjectInput)
pub mod copy_object_input {
    /// A builder for [`CopyObjectInput`](crate::input::CopyObjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) acl: std::option::Option<crate::model::ObjectCannedAcl>,
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) cache_control: std::option::Option<std::string::String>,
        pub(crate) content_disposition: std::option::Option<std::string::String>,
        pub(crate) content_encoding: std::option::Option<std::string::String>,
        pub(crate) content_language: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) copy_source: std::option::Option<std::string::String>,
        pub(crate) copy_source_if_match: std::option::Option<std::string::String>,
        pub(crate) copy_source_if_modified_since: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) copy_source_if_none_match: std::option::Option<std::string::String>,
        pub(crate) copy_source_if_unmodified_since: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) expires: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) grant_full_control: std::option::Option<std::string::String>,
        pub(crate) grant_read: std::option::Option<std::string::String>,
        pub(crate) grant_read_acp: std::option::Option<std::string::String>,
        pub(crate) grant_write_acp: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) metadata_directive: std::option::Option<crate::model::MetadataDirective>,
        pub(crate) tagging_directive: std::option::Option<crate::model::TaggingDirective>,
        pub(crate) server_side_encryption: std::option::Option<crate::model::ServerSideEncryption>,
        pub(crate) storage_class: std::option::Option<crate::model::StorageClass>,
        pub(crate) website_redirect_location: std::option::Option<std::string::String>,
        pub(crate) sse_customer_algorithm: std::option::Option<std::string::String>,
        pub(crate) sse_customer_key: std::option::Option<std::string::String>,
        pub(crate) sse_customer_key_md5: std::option::Option<std::string::String>,
        pub(crate) ssekms_key_id: std::option::Option<std::string::String>,
        pub(crate) ssekms_encryption_context: std::option::Option<std::string::String>,
        pub(crate) bucket_key_enabled: std::option::Option<bool>,
        pub(crate) copy_source_sse_customer_algorithm: std::option::Option<std::string::String>,
        pub(crate) copy_source_sse_customer_key: std::option::Option<std::string::String>,
        pub(crate) copy_source_sse_customer_key_md5: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) tagging: std::option::Option<std::string::String>,
        pub(crate) object_lock_mode: std::option::Option<crate::model::ObjectLockMode>,
        pub(crate) object_lock_retain_until_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) object_lock_legal_hold_status:
            std::option::Option<crate::model::ObjectLockLegalHoldStatus>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
        pub(crate) expected_source_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The canned ACL to apply to the object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn acl(mut self, input: crate::model::ObjectCannedAcl) -> Self {
            self.acl = Some(input);
            self
        }
        /// <p>The canned ACL to apply to the object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_acl(
            mut self,
            input: std::option::Option<crate::model::ObjectCannedAcl>,
        ) -> Self {
            self.acl = input;
            self
        }
        /// <p>The name of the destination bucket.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the destination bucket.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Specifies caching behavior along the request/reply chain.</p>
        pub fn cache_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_control = Some(input.into());
            self
        }
        /// <p>Specifies caching behavior along the request/reply chain.</p>
        pub fn set_cache_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_control = input;
            self
        }
        /// <p>Specifies presentational information for the object.</p>
        pub fn content_disposition(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_disposition = Some(input.into());
            self
        }
        /// <p>Specifies presentational information for the object.</p>
        pub fn set_content_disposition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_disposition = input;
            self
        }
        /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>
        pub fn content_encoding(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_encoding = Some(input.into());
            self
        }
        /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>
        pub fn set_content_encoding(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_encoding = input;
            self
        }
        /// <p>The language the content is in.</p>
        pub fn content_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_language = Some(input.into());
            self
        }
        /// <p>The language the content is in.</p>
        pub fn set_content_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_language = input;
            self
        }
        /// <p>A standard MIME type describing the format of the object data.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>A standard MIME type describing the format of the object data.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>Specifies the source object for the copy operation. You specify the value in one of two formats, depending on whether you want to access the source object through an <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">access point</a>:</p>
        /// <ul>
        /// <li> <p>For objects not accessed through an access point, specify the name of the source bucket and the key of the source object, separated by a slash (/). For example, to copy the object <code>reports/january.pdf</code> from the bucket <code>awsexamplebucket</code>, use <code>awsexamplebucket/reports/january.pdf</code>. The value must be URL encoded.</p> </li>
        /// <li> <p>For objects accessed through access points, specify the Amazon Resource Name (ARN) of the object as accessed through the access point, in the format <code>arn:aws:s3:
        /// <region>
        /// :
        /// <account-id>
        /// :accesspoint/
        /// <access-point-name>
        /// /object/
        /// <key></key>
        /// </access-point-name>
        /// </account-id>
        /// </region></code>. For example, to copy the object <code>reports/january.pdf</code> through access point <code>my-access-point</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3:us-west-2:123456789012:accesspoint/my-access-point/object/reports/january.pdf</code>. The value must be URL encoded.</p> <note>
        /// <p>Amazon S3 supports copy operations using access points only when the source and destination buckets are in the same Amazon Web Services Region.</p>
        /// </note> <p>Alternatively, for objects accessed through Amazon S3 on Outposts, specify the ARN of the object as accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /object/
        /// <key></key>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to copy the object <code>reports/january.pdf</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/object/reports/january.pdf</code>. The value must be URL encoded. </p> </li>
        /// </ul>
        /// <p>To copy a specific version of an object, append <code>?versionId=
        /// <version-id></version-id></code> to the value (for example, <code>awsexamplebucket/reports/january.pdf?versionId=QUpfdndhfd8438MNFDN93jdnJFkdmqnh893</code>). If you don't specify a version ID, Amazon S3 copies the latest version of the source object.</p>
        pub fn copy_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.copy_source = Some(input.into());
            self
        }
        /// <p>Specifies the source object for the copy operation. You specify the value in one of two formats, depending on whether you want to access the source object through an <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html">access point</a>:</p>
        /// <ul>
        /// <li> <p>For objects not accessed through an access point, specify the name of the source bucket and the key of the source object, separated by a slash (/). For example, to copy the object <code>reports/january.pdf</code> from the bucket <code>awsexamplebucket</code>, use <code>awsexamplebucket/reports/january.pdf</code>. The value must be URL encoded.</p> </li>
        /// <li> <p>For objects accessed through access points, specify the Amazon Resource Name (ARN) of the object as accessed through the access point, in the format <code>arn:aws:s3:
        /// <region>
        /// :
        /// <account-id>
        /// :accesspoint/
        /// <access-point-name>
        /// /object/
        /// <key></key>
        /// </access-point-name>
        /// </account-id>
        /// </region></code>. For example, to copy the object <code>reports/january.pdf</code> through access point <code>my-access-point</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3:us-west-2:123456789012:accesspoint/my-access-point/object/reports/january.pdf</code>. The value must be URL encoded.</p> <note>
        /// <p>Amazon S3 supports copy operations using access points only when the source and destination buckets are in the same Amazon Web Services Region.</p>
        /// </note> <p>Alternatively, for objects accessed through Amazon S3 on Outposts, specify the ARN of the object as accessed in the format <code>arn:aws:s3-outposts:
        /// <region>
        /// :
        /// <account-id>
        /// :outpost/
        /// <outpost-id>
        /// /object/
        /// <key></key>
        /// </outpost-id>
        /// </account-id>
        /// </region></code>. For example, to copy the object <code>reports/january.pdf</code> through outpost <code>my-outpost</code> owned by account <code>123456789012</code> in Region <code>us-west-2</code>, use the URL encoding of <code>arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/object/reports/january.pdf</code>. The value must be URL encoded. </p> </li>
        /// </ul>
        /// <p>To copy a specific version of an object, append <code>?versionId=
        /// <version-id></version-id></code> to the value (for example, <code>awsexamplebucket/reports/january.pdf?versionId=QUpfdndhfd8438MNFDN93jdnJFkdmqnh893</code>). If you don't specify a version ID, Amazon S3 copies the latest version of the source object.</p>
        pub fn set_copy_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.copy_source = input;
            self
        }
        /// <p>Copies the object if its entity tag (ETag) matches the specified tag.</p>
        pub fn copy_source_if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.copy_source_if_match = Some(input.into());
            self
        }
        /// <p>Copies the object if its entity tag (ETag) matches the specified tag.</p>
        pub fn set_copy_source_if_match(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.copy_source_if_match = input;
            self
        }
        /// <p>Copies the object if it has been modified since the specified time.</p>
        pub fn copy_source_if_modified_since(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.copy_source_if_modified_since = Some(input);
            self
        }
        /// <p>Copies the object if it has been modified since the specified time.</p>
        pub fn set_copy_source_if_modified_since(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.copy_source_if_modified_since = input;
            self
        }
        /// <p>Copies the object if its entity tag (ETag) is different than the specified ETag.</p>
        pub fn copy_source_if_none_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.copy_source_if_none_match = Some(input.into());
            self
        }
        /// <p>Copies the object if its entity tag (ETag) is different than the specified ETag.</p>
        pub fn set_copy_source_if_none_match(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.copy_source_if_none_match = input;
            self
        }
        /// <p>Copies the object if it hasn't been modified since the specified time.</p>
        pub fn copy_source_if_unmodified_since(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.copy_source_if_unmodified_since = Some(input);
            self
        }
        /// <p>Copies the object if it hasn't been modified since the specified time.</p>
        pub fn set_copy_source_if_unmodified_since(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.copy_source_if_unmodified_since = input;
            self
        }
        /// <p>The date and time at which the object is no longer cacheable.</p>
        pub fn expires(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expires = Some(input);
            self
        }
        /// <p>The date and time at which the object is no longer cacheable.</p>
        pub fn set_expires(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expires = input;
            self
        }
        /// <p>Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_full_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_full_control = Some(input.into());
            self
        }
        /// <p>Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_full_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_full_control = input;
            self
        }
        /// <p>Allows grantee to read the object data and its metadata.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_read(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_read = Some(input.into());
            self
        }
        /// <p>Allows grantee to read the object data and its metadata.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_read(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grant_read = input;
            self
        }
        /// <p>Allows grantee to read the object ACL.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_read_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_read_acp = Some(input.into());
            self
        }
        /// <p>Allows grantee to read the object ACL.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_read_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_read_acp = input;
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_write_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_write_acp = Some(input.into());
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_write_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_write_acp = input;
            self
        }
        /// <p>The key of the destination object.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of the destination object.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Adds a key-value pair to `metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>A map of metadata to store with the object in S3.</p>
        pub fn metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.metadata = Some(hash_map);
            self
        }
        /// <p>A map of metadata to store with the object in S3.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// <p>Specifies whether the metadata is copied from the source object or replaced with metadata provided in the request.</p>
        pub fn metadata_directive(mut self, input: crate::model::MetadataDirective) -> Self {
            self.metadata_directive = Some(input);
            self
        }
        /// <p>Specifies whether the metadata is copied from the source object or replaced with metadata provided in the request.</p>
        pub fn set_metadata_directive(
            mut self,
            input: std::option::Option<crate::model::MetadataDirective>,
        ) -> Self {
            self.metadata_directive = input;
            self
        }
        /// <p>Specifies whether the object tag-set are copied from the source object or replaced with tag-set provided in the request.</p>
        pub fn tagging_directive(mut self, input: crate::model::TaggingDirective) -> Self {
            self.tagging_directive = Some(input);
            self
        }
        /// <p>Specifies whether the object tag-set are copied from the source object or replaced with tag-set provided in the request.</p>
        pub fn set_tagging_directive(
            mut self,
            input: std::option::Option<crate::model::TaggingDirective>,
        ) -> Self {
            self.tagging_directive = input;
            self
        }
        /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>
        pub fn server_side_encryption(mut self, input: crate::model::ServerSideEncryption) -> Self {
            self.server_side_encryption = Some(input);
            self
        }
        /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>
        pub fn set_server_side_encryption(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryption>,
        ) -> Self {
            self.server_side_encryption = input;
            self
        }
        /// <p>By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. Amazon S3 on Outposts only uses the OUTPOSTS Storage Class. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn storage_class(mut self, input: crate::model::StorageClass) -> Self {
            self.storage_class = Some(input);
            self
        }
        /// <p>By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. Amazon S3 on Outposts only uses the OUTPOSTS Storage Class. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<crate::model::StorageClass>,
        ) -> Self {
            self.storage_class = input;
            self
        }
        /// <p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p>
        pub fn website_redirect_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.website_redirect_location = Some(input.into());
            self
        }
        /// <p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p>
        pub fn set_website_redirect_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.website_redirect_location = input;
            self
        }
        /// <p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>
        pub fn sse_customer_algorithm(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_algorithm = Some(input.into());
            self
        }
        /// <p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>
        pub fn set_sse_customer_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_algorithm = input;
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
        pub fn sse_customer_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_key = Some(input.into());
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
        pub fn set_sse_customer_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_key = input;
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn sse_customer_key_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_key_md5 = Some(input.into());
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn set_sse_customer_key_md5(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_key_md5 = input;
            self
        }
        /// <p>Specifies the Amazon Web Services KMS key ID to use for object encryption. All GET and PUT requests for an object protected by Amazon Web Services KMS will fail if not made via SSL or using SigV4. For information about configuring using any of the officially supported Amazon Web Services SDKs and Amazon Web Services CLI, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version">Specifying the Signature Version in Request Authentication</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn ssekms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssekms_key_id = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon Web Services KMS key ID to use for object encryption. All GET and PUT requests for an object protected by Amazon Web Services KMS will fail if not made via SSL or using SigV4. For information about configuring using any of the officially supported Amazon Web Services SDKs and Amazon Web Services CLI, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version">Specifying the Signature Version in Request Authentication</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_ssekms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssekms_key_id = input;
            self
        }
        /// <p>Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p>
        pub fn ssekms_encryption_context(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssekms_encryption_context = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p>
        pub fn set_ssekms_encryption_context(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssekms_encryption_context = input;
            self
        }
        /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using AWS KMS (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS. </p>
        /// <p>Specifying this header with a COPY action doesn’t affect bucket-level settings for S3 Bucket Key.</p>
        pub fn bucket_key_enabled(mut self, input: bool) -> Self {
            self.bucket_key_enabled = Some(input);
            self
        }
        /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using AWS KMS (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS. </p>
        /// <p>Specifying this header with a COPY action doesn’t affect bucket-level settings for S3 Bucket Key.</p>
        pub fn set_bucket_key_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.bucket_key_enabled = input;
            self
        }
        /// <p>Specifies the algorithm to use when decrypting the source object (for example, AES256).</p>
        pub fn copy_source_sse_customer_algorithm(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.copy_source_sse_customer_algorithm = Some(input.into());
            self
        }
        /// <p>Specifies the algorithm to use when decrypting the source object (for example, AES256).</p>
        pub fn set_copy_source_sse_customer_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.copy_source_sse_customer_algorithm = input;
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The encryption key provided in this header must be one that was used when the source object was created.</p>
        pub fn copy_source_sse_customer_key(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.copy_source_sse_customer_key = Some(input.into());
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The encryption key provided in this header must be one that was used when the source object was created.</p>
        pub fn set_copy_source_sse_customer_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.copy_source_sse_customer_key = input;
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn copy_source_sse_customer_key_md5(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.copy_source_sse_customer_key_md5 = Some(input.into());
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn set_copy_source_sse_customer_key_md5(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.copy_source_sse_customer_key_md5 = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>The tag-set for the object destination object this value must be used in conjunction with the <code>TaggingDirective</code>. The tag-set must be encoded as URL Query parameters.</p>
        pub fn tagging(mut self, input: impl Into<std::string::String>) -> Self {
            self.tagging = Some(input.into());
            self
        }
        /// <p>The tag-set for the object destination object this value must be used in conjunction with the <code>TaggingDirective</code>. The tag-set must be encoded as URL Query parameters.</p>
        pub fn set_tagging(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tagging = input;
            self
        }
        /// <p>The Object Lock mode that you want to apply to the copied object.</p>
        pub fn object_lock_mode(mut self, input: crate::model::ObjectLockMode) -> Self {
            self.object_lock_mode = Some(input);
            self
        }
        /// <p>The Object Lock mode that you want to apply to the copied object.</p>
        pub fn set_object_lock_mode(
            mut self,
            input: std::option::Option<crate::model::ObjectLockMode>,
        ) -> Self {
            self.object_lock_mode = input;
            self
        }
        /// <p>The date and time when you want the copied object's Object Lock to expire.</p>
        pub fn object_lock_retain_until_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.object_lock_retain_until_date = Some(input);
            self
        }
        /// <p>The date and time when you want the copied object's Object Lock to expire.</p>
        pub fn set_object_lock_retain_until_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.object_lock_retain_until_date = input;
            self
        }
        /// <p>Specifies whether you want to apply a Legal Hold to the copied object.</p>
        pub fn object_lock_legal_hold_status(
            mut self,
            input: crate::model::ObjectLockLegalHoldStatus,
        ) -> Self {
            self.object_lock_legal_hold_status = Some(input);
            self
        }
        /// <p>Specifies whether you want to apply a Legal Hold to the copied object.</p>
        pub fn set_object_lock_legal_hold_status(
            mut self,
            input: std::option::Option<crate::model::ObjectLockLegalHoldStatus>,
        ) -> Self {
            self.object_lock_legal_hold_status = input;
            self
        }
        /// <p>The account ID of the expected destination bucket owner. If the destination bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected destination bucket owner. If the destination bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// <p>The account ID of the expected source bucket owner. If the source bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_source_bucket_owner(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.expected_source_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected source bucket owner. If the source bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_source_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_source_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyObjectInput`](crate::input::CopyObjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CopyObjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CopyObjectInput {
                acl: self.acl,
                bucket: self.bucket,
                cache_control: self.cache_control,
                content_disposition: self.content_disposition,
                content_encoding: self.content_encoding,
                content_language: self.content_language,
                content_type: self.content_type,
                copy_source: self.copy_source,
                copy_source_if_match: self.copy_source_if_match,
                copy_source_if_modified_since: self.copy_source_if_modified_since,
                copy_source_if_none_match: self.copy_source_if_none_match,
                copy_source_if_unmodified_since: self.copy_source_if_unmodified_since,
                expires: self.expires,
                grant_full_control: self.grant_full_control,
                grant_read: self.grant_read,
                grant_read_acp: self.grant_read_acp,
                grant_write_acp: self.grant_write_acp,
                key: self.key,
                metadata: self.metadata,
                metadata_directive: self.metadata_directive,
                tagging_directive: self.tagging_directive,
                server_side_encryption: self.server_side_encryption,
                storage_class: self.storage_class,
                website_redirect_location: self.website_redirect_location,
                sse_customer_algorithm: self.sse_customer_algorithm,
                sse_customer_key: self.sse_customer_key,
                sse_customer_key_md5: self.sse_customer_key_md5,
                ssekms_key_id: self.ssekms_key_id,
                ssekms_encryption_context: self.ssekms_encryption_context,
                bucket_key_enabled: self.bucket_key_enabled.unwrap_or_default(),
                copy_source_sse_customer_algorithm: self.copy_source_sse_customer_algorithm,
                copy_source_sse_customer_key: self.copy_source_sse_customer_key,
                copy_source_sse_customer_key_md5: self.copy_source_sse_customer_key_md5,
                request_payer: self.request_payer,
                tagging: self.tagging,
                object_lock_mode: self.object_lock_mode,
                object_lock_retain_until_date: self.object_lock_retain_until_date,
                object_lock_legal_hold_status: self.object_lock_legal_hold_status,
                expected_bucket_owner: self.expected_bucket_owner,
                expected_source_bucket_owner: self.expected_source_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type CopyObjectInputOperationOutputAlias = crate::operation::CopyObject;
#[doc(hidden)]
pub type CopyObjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CopyObjectInput {
    /// Consumes the builder and constructs an Operation<[`CopyObject`](crate::operation::CopyObject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CopyObject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CopyObjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_15 = &_input.bucket;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_15, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            let input_16 = &_input.key;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    })?;
            let key = aws_smithy_http::label::fmt_string(input_16, true);
            if key.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "key",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CopyObjectInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_17) = &_input.acl {
                let formatted_18 = AsRef::<str>::as_ref(inner_17);
                if !formatted_18.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_18;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "acl",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-acl", header_value);
                }
            }
            if let Some(inner_19) = &_input.cache_control {
                let formatted_20 = AsRef::<str>::as_ref(inner_19);
                if !formatted_20.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_20;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "cache_control",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Cache-Control", header_value);
                }
            }
            if let Some(inner_21) = &_input.content_disposition {
                let formatted_22 = AsRef::<str>::as_ref(inner_21);
                if !formatted_22.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_22;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "content_disposition",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Content-Disposition", header_value);
                }
            }
            if let Some(inner_23) = &_input.content_encoding {
                let formatted_24 = AsRef::<str>::as_ref(inner_23);
                if !formatted_24.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_24;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "content_encoding",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Content-Encoding", header_value);
                }
            }
            if let Some(inner_25) = &_input.content_language {
                let formatted_26 = AsRef::<str>::as_ref(inner_25);
                if !formatted_26.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_26;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "content_language",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Content-Language", header_value);
                }
            }
            if let Some(inner_27) = &_input.content_type {
                let formatted_28 = AsRef::<str>::as_ref(inner_27);
                if !formatted_28.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_28;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "content_type",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Content-Type", header_value);
                }
            }
            if let Some(inner_29) = &_input.copy_source {
                let formatted_30 = AsRef::<str>::as_ref(inner_29);
                if !formatted_30.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_30;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "copy_source",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-copy-source", header_value);
                }
            }
            if let Some(inner_31) = &_input.copy_source_if_match {
                let formatted_32 = AsRef::<str>::as_ref(inner_31);
                if !formatted_32.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_32;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "copy_source_if_match",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-copy-source-if-match", header_value);
                }
            }
            if let Some(inner_33) = &_input.copy_source_if_modified_since {
                let formatted_34 = inner_33.fmt(aws_smithy_types::date_time::Format::HttpDate)?;
                if !formatted_34.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_34;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "copy_source_if_modified_since",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-copy-source-if-modified-since", header_value);
                }
            }
            if let Some(inner_35) = &_input.copy_source_if_none_match {
                let formatted_36 = AsRef::<str>::as_ref(inner_35);
                if !formatted_36.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_36;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "copy_source_if_none_match",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-copy-source-if-none-match", header_value);
                }
            }
            if let Some(inner_37) = &_input.copy_source_if_unmodified_since {
                let formatted_38 = inner_37.fmt(aws_smithy_types::date_time::Format::HttpDate)?;
                if !formatted_38.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_38;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "copy_source_if_unmodified_since",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-copy-source-if-unmodified-since", header_value);
                }
            }
            if let Some(inner_39) = &_input.expires {
                let formatted_40 = inner_39.fmt(aws_smithy_types::date_time::Format::HttpDate)?;
                if !formatted_40.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_40;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expires",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Expires", header_value);
                }
            }
            if let Some(inner_41) = &_input.grant_full_control {
                let formatted_42 = AsRef::<str>::as_ref(inner_41);
                if !formatted_42.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_42;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "grant_full_control",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-grant-full-control", header_value);
                }
            }
            if let Some(inner_43) = &_input.grant_read {
                let formatted_44 = AsRef::<str>::as_ref(inner_43);
                if !formatted_44.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_44;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "grant_read",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-grant-read", header_value);
                }
            }
            if let Some(inner_45) = &_input.grant_read_acp {
                let formatted_46 = AsRef::<str>::as_ref(inner_45);
                if !formatted_46.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_46;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "grant_read_acp",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-grant-read-acp", header_value);
                }
            }
            if let Some(inner_47) = &_input.grant_write_acp {
                let formatted_48 = AsRef::<str>::as_ref(inner_47);
                if !formatted_48.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_48;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "grant_write_acp",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-grant-write-acp", header_value);
                }
            }
            if let Some(inner_49) = &_input.metadata_directive {
                let formatted_50 = AsRef::<str>::as_ref(inner_49);
                if !formatted_50.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_50;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "metadata_directive",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-metadata-directive", header_value);
                }
            }
            if let Some(inner_51) = &_input.tagging_directive {
                let formatted_52 = AsRef::<str>::as_ref(inner_51);
                if !formatted_52.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_52;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "tagging_directive",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-tagging-directive", header_value);
                }
            }
            if let Some(inner_53) = &_input.server_side_encryption {
                let formatted_54 = AsRef::<str>::as_ref(inner_53);
                if !formatted_54.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_54;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "server_side_encryption",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-server-side-encryption", header_value);
                }
            }
            if let Some(inner_55) = &_input.storage_class {
                let formatted_56 = AsRef::<str>::as_ref(inner_55);
                if !formatted_56.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_56;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "storage_class",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-storage-class", header_value);
                }
            }
            if let Some(inner_57) = &_input.website_redirect_location {
                let formatted_58 = AsRef::<str>::as_ref(inner_57);
                if !formatted_58.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_58;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "website_redirect_location",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-website-redirect-location", header_value);
                }
            }
            if let Some(inner_59) = &_input.sse_customer_algorithm {
                let formatted_60 = AsRef::<str>::as_ref(inner_59);
                if !formatted_60.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_60;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "sse_customer_algorithm",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header(
                        "x-amz-server-side-encryption-customer-algorithm",
                        header_value,
                    );
                }
            }
            if let Some(inner_61) = &_input.sse_customer_key {
                let formatted_62 = AsRef::<str>::as_ref(inner_61);
                if !formatted_62.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_62;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "sse_customer_key",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder =
                        builder.header("x-amz-server-side-encryption-customer-key", header_value);
                }
            }
            if let Some(inner_63) = &_input.sse_customer_key_md5 {
                let formatted_64 = AsRef::<str>::as_ref(inner_63);
                if !formatted_64.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_64;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "sse_customer_key_md5",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header(
                        "x-amz-server-side-encryption-customer-key-MD5",
                        header_value,
                    );
                }
            }
            if let Some(inner_65) = &_input.ssekms_key_id {
                let formatted_66 = AsRef::<str>::as_ref(inner_65);
                if !formatted_66.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_66;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "ssekms_key_id",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder =
                        builder.header("x-amz-server-side-encryption-aws-kms-key-id", header_value);
                }
            }
            if let Some(inner_67) = &_input.ssekms_encryption_context {
                let formatted_68 = AsRef::<str>::as_ref(inner_67);
                if !formatted_68.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_68;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "ssekms_encryption_context",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("x-amz-server-side-encryption-context", header_value);
                }
            }
            if _input.bucket_key_enabled {
                let mut encoder =
                    aws_smithy_types::primitive::Encoder::from(_input.bucket_key_enabled);
                let formatted_69 = encoder.encode();
                if !formatted_69.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_69;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "bucket_key_enabled",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header(
                        "x-amz-server-side-encryption-bucket-key-enabled",
                        header_value,
                    );
                }
            }
            if let Some(inner_70) = &_input.copy_source_sse_customer_algorithm {
                let formatted_71 = AsRef::<str>::as_ref(inner_70);
                if !formatted_71.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_71;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "copy_source_sse_customer_algorithm",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header(
                        "x-amz-copy-source-server-side-encryption-customer-algorithm",
                        header_value,
                    );
                }
            }
            if let Some(inner_72) = &_input.copy_source_sse_customer_key {
                let formatted_73 = AsRef::<str>::as_ref(inner_72);
                if !formatted_73.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_73;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "copy_source_sse_customer_key",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header(
                        "x-amz-copy-source-server-side-encryption-customer-key",
                        header_value,
                    );
                }
            }
            if let Some(inner_74) = &_input.copy_source_sse_customer_key_md5 {
                let formatted_75 = AsRef::<str>::as_ref(inner_74);
                if !formatted_75.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_75;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "copy_source_sse_customer_key_md5",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header(
                        "x-amz-copy-source-server-side-encryption-customer-key-MD5",
                        header_value,
                    );
                }
            }
            if let Some(inner_76) = &_input.request_payer {
                let formatted_77 = AsRef::<str>::as_ref(inner_76);
                if !formatted_77.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_77;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "request_payer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-request-payer", header_value);
                }
            }
            if let Some(inner_78) = &_input.tagging {
                let formatted_79 = AsRef::<str>::as_ref(inner_78);
                if !formatted_79.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_79;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "tagging",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-tagging", header_value);
                }
            }
            if let Some(inner_80) = &_input.object_lock_mode {
                let formatted_81 = AsRef::<str>::as_ref(inner_80);
                if !formatted_81.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_81;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "object_lock_mode",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-object-lock-mode", header_value);
                }
            }
            if let Some(inner_82) = &_input.object_lock_retain_until_date {
                let formatted_83 = inner_82.fmt(aws_smithy_types::date_time::Format::DateTime)?;
                if !formatted_83.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_83;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "object_lock_retain_until_date",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-object-lock-retain-until-date", header_value);
                }
            }
            if let Some(inner_84) = &_input.object_lock_legal_hold_status {
                let formatted_85 = AsRef::<str>::as_ref(inner_84);
                if !formatted_85.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_85;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "object_lock_legal_hold_status",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-object-lock-legal-hold", header_value);
                }
            }
            if let Some(inner_86) = &_input.expected_bucket_owner {
                let formatted_87 = AsRef::<str>::as_ref(inner_86);
                if !formatted_87.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_87;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            if let Some(inner_88) = &_input.expected_source_bucket_owner {
                let formatted_89 = AsRef::<str>::as_ref(inner_88);
                if !formatted_89.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_89;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_source_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-source-expected-bucket-owner", header_value);
                }
            }
            if let Some(inner_90) = &_input.metadata {
                for (k, v) in inner_90 {
                    use std::str::FromStr;
                    let header_name =
                        http::header::HeaderName::from_str(&format!("{}{}", "x-amz-meta-", &k))
                            .map_err(|err| {
                                aws_smithy_http::operation::BuildError::InvalidField {
                                    field: "metadata",
                                    details: format!(
                                        "`{}` cannot be used as a header name: {}",
                                        k, err
                                    ),
                                }
                            })?;
                    use std::convert::TryFrom;
                    let header_value = AsRef::<str>::as_ref(v);
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "metadata",
                            details: format!("`{}` cannot be used as a header value: {}", v, err),
                        })?;
                    builder = builder.header(header_name, header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::CopyObjectInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("x-id", "CopyObject");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CopyObjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CopyObjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CopyObject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CopyObject",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CopyObjectInput`](crate::input::CopyObjectInput)
    pub fn builder() -> crate::input::copy_object_input::Builder {
        crate::input::copy_object_input::Builder::default()
    }
}

/// See [`CreateBucketInput`](crate::input::CreateBucketInput)
pub mod create_bucket_input {
    /// A builder for [`CreateBucketInput`](crate::input::CreateBucketInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) acl: std::option::Option<crate::model::BucketCannedAcl>,
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) create_bucket_configuration:
            std::option::Option<crate::model::CreateBucketConfiguration>,
        pub(crate) grant_full_control: std::option::Option<std::string::String>,
        pub(crate) grant_read: std::option::Option<std::string::String>,
        pub(crate) grant_read_acp: std::option::Option<std::string::String>,
        pub(crate) grant_write: std::option::Option<std::string::String>,
        pub(crate) grant_write_acp: std::option::Option<std::string::String>,
        pub(crate) object_lock_enabled_for_bucket: std::option::Option<bool>,
        pub(crate) object_ownership: std::option::Option<crate::model::ObjectOwnership>,
    }
    impl Builder {
        /// <p>The canned ACL to apply to the bucket.</p>
        pub fn acl(mut self, input: crate::model::BucketCannedAcl) -> Self {
            self.acl = Some(input);
            self
        }
        /// <p>The canned ACL to apply to the bucket.</p>
        pub fn set_acl(
            mut self,
            input: std::option::Option<crate::model::BucketCannedAcl>,
        ) -> Self {
            self.acl = input;
            self
        }
        /// <p>The name of the bucket to create.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket to create.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The configuration information for the bucket.</p>
        pub fn create_bucket_configuration(
            mut self,
            input: crate::model::CreateBucketConfiguration,
        ) -> Self {
            self.create_bucket_configuration = Some(input);
            self
        }
        /// <p>The configuration information for the bucket.</p>
        pub fn set_create_bucket_configuration(
            mut self,
            input: std::option::Option<crate::model::CreateBucketConfiguration>,
        ) -> Self {
            self.create_bucket_configuration = input;
            self
        }
        /// <p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p>
        pub fn grant_full_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_full_control = Some(input.into());
            self
        }
        /// <p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p>
        pub fn set_grant_full_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_full_control = input;
            self
        }
        /// <p>Allows grantee to list the objects in the bucket.</p>
        pub fn grant_read(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_read = Some(input.into());
            self
        }
        /// <p>Allows grantee to list the objects in the bucket.</p>
        pub fn set_grant_read(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grant_read = input;
            self
        }
        /// <p>Allows grantee to read the bucket ACL.</p>
        pub fn grant_read_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_read_acp = Some(input.into());
            self
        }
        /// <p>Allows grantee to read the bucket ACL.</p>
        pub fn set_grant_read_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_read_acp = input;
            self
        }
        /// <p>Allows grantee to create new objects in the bucket.</p>
        /// <p>For the bucket and object owners of existing objects, also allows deletions and overwrites of those objects.</p>
        pub fn grant_write(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_write = Some(input.into());
            self
        }
        /// <p>Allows grantee to create new objects in the bucket.</p>
        /// <p>For the bucket and object owners of existing objects, also allows deletions and overwrites of those objects.</p>
        pub fn set_grant_write(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grant_write = input;
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable bucket.</p>
        pub fn grant_write_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_write_acp = Some(input.into());
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable bucket.</p>
        pub fn set_grant_write_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_write_acp = input;
            self
        }
        /// <p>Specifies whether you want S3 Object Lock to be enabled for the new bucket.</p>
        pub fn object_lock_enabled_for_bucket(mut self, input: bool) -> Self {
            self.object_lock_enabled_for_bucket = Some(input);
            self
        }
        /// <p>Specifies whether you want S3 Object Lock to be enabled for the new bucket.</p>
        pub fn set_object_lock_enabled_for_bucket(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.object_lock_enabled_for_bucket = input;
            self
        }
        /// <p>The container element for object ownership for a bucket's ownership controls.</p>
        /// <p>BucketOwnerPreferred - Objects uploaded to the bucket change ownership to the bucket owner if the objects are uploaded with the <code>bucket-owner-full-control</code> canned ACL.</p>
        /// <p>ObjectWriter - The uploading account will own the object if the object is uploaded with the <code>bucket-owner-full-control</code> canned ACL.</p>
        /// <p>BucketOwnerEnforced - Access control lists (ACLs) are disabled and no longer affect permissions. The bucket owner automatically owns and has full control over every object in the bucket. The bucket only accepts PUT requests that don't specify an ACL or bucket owner full control ACLs, such as the <code>bucket-owner-full-control</code> canned ACL or an equivalent form of this ACL expressed in the XML format.</p>
        pub fn object_ownership(mut self, input: crate::model::ObjectOwnership) -> Self {
            self.object_ownership = Some(input);
            self
        }
        /// <p>The container element for object ownership for a bucket's ownership controls.</p>
        /// <p>BucketOwnerPreferred - Objects uploaded to the bucket change ownership to the bucket owner if the objects are uploaded with the <code>bucket-owner-full-control</code> canned ACL.</p>
        /// <p>ObjectWriter - The uploading account will own the object if the object is uploaded with the <code>bucket-owner-full-control</code> canned ACL.</p>
        /// <p>BucketOwnerEnforced - Access control lists (ACLs) are disabled and no longer affect permissions. The bucket owner automatically owns and has full control over every object in the bucket. The bucket only accepts PUT requests that don't specify an ACL or bucket owner full control ACLs, such as the <code>bucket-owner-full-control</code> canned ACL or an equivalent form of this ACL expressed in the XML format.</p>
        pub fn set_object_ownership(
            mut self,
            input: std::option::Option<crate::model::ObjectOwnership>,
        ) -> Self {
            self.object_ownership = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBucketInput`](crate::input::CreateBucketInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBucketInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBucketInput {
                acl: self.acl,
                bucket: self.bucket,
                create_bucket_configuration: self.create_bucket_configuration,
                grant_full_control: self.grant_full_control,
                grant_read: self.grant_read,
                grant_read_acp: self.grant_read_acp,
                grant_write: self.grant_write,
                grant_write_acp: self.grant_write_acp,
                object_lock_enabled_for_bucket: self
                    .object_lock_enabled_for_bucket
                    .unwrap_or_default(),
                object_ownership: self.object_ownership,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBucketInputOperationOutputAlias = crate::operation::CreateBucket;
#[doc(hidden)]
pub type CreateBucketInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateBucketInput {
    /// Consumes the builder and constructs an Operation<[`CreateBucket`](crate::operation::CreateBucket)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBucket,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateBucketInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_91 = &_input.bucket;
            let input_91 =
                input_91
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_91, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateBucketInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_92) = &_input.acl {
                let formatted_93 = AsRef::<str>::as_ref(inner_92);
                if !formatted_93.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_93;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "acl",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-acl", header_value);
                }
            }
            if let Some(inner_94) = &_input.grant_full_control {
                let formatted_95 = AsRef::<str>::as_ref(inner_94);
                if !formatted_95.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_95;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "grant_full_control",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-grant-full-control", header_value);
                }
            }
            if let Some(inner_96) = &_input.grant_read {
                let formatted_97 = AsRef::<str>::as_ref(inner_96);
                if !formatted_97.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_97;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "grant_read",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-grant-read", header_value);
                }
            }
            if let Some(inner_98) = &_input.grant_read_acp {
                let formatted_99 = AsRef::<str>::as_ref(inner_98);
                if !formatted_99.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_99;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "grant_read_acp",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-grant-read-acp", header_value);
                }
            }
            if let Some(inner_100) = &_input.grant_write {
                let formatted_101 = AsRef::<str>::as_ref(inner_100);
                if !formatted_101.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_101;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "grant_write",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-grant-write", header_value);
                }
            }
            if let Some(inner_102) = &_input.grant_write_acp {
                let formatted_103 = AsRef::<str>::as_ref(inner_102);
                if !formatted_103.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_103;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "grant_write_acp",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-grant-write-acp", header_value);
                }
            }
            if _input.object_lock_enabled_for_bucket {
                let mut encoder = aws_smithy_types::primitive::Encoder::from(
                    _input.object_lock_enabled_for_bucket,
                );
                let formatted_104 = encoder.encode();
                if !formatted_104.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_104;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "object_lock_enabled_for_bucket",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-bucket-object-lock-enabled", header_value);
                }
            }
            if let Some(inner_105) = &_input.object_ownership {
                let formatted_106 = AsRef::<str>::as_ref(inner_105);
                if !formatted_106.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_106;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "object_ownership",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-object-ownership", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateBucketInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateBucketInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::ser_payload_create_bucket_input(
            &self.create_bucket_configuration,
        )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBucket::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBucket",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateBucketInput`](crate::input::CreateBucketInput)
    pub fn builder() -> crate::input::create_bucket_input::Builder {
        crate::input::create_bucket_input::Builder::default()
    }
}

/// See [`CreateMultipartUploadInput`](crate::input::CreateMultipartUploadInput)
pub mod create_multipart_upload_input {
    /// A builder for [`CreateMultipartUploadInput`](crate::input::CreateMultipartUploadInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) acl: std::option::Option<crate::model::ObjectCannedAcl>,
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) cache_control: std::option::Option<std::string::String>,
        pub(crate) content_disposition: std::option::Option<std::string::String>,
        pub(crate) content_encoding: std::option::Option<std::string::String>,
        pub(crate) content_language: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) expires: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) grant_full_control: std::option::Option<std::string::String>,
        pub(crate) grant_read: std::option::Option<std::string::String>,
        pub(crate) grant_read_acp: std::option::Option<std::string::String>,
        pub(crate) grant_write_acp: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) server_side_encryption: std::option::Option<crate::model::ServerSideEncryption>,
        pub(crate) storage_class: std::option::Option<crate::model::StorageClass>,
        pub(crate) website_redirect_location: std::option::Option<std::string::String>,
        pub(crate) sse_customer_algorithm: std::option::Option<std::string::String>,
        pub(crate) sse_customer_key: std::option::Option<std::string::String>,
        pub(crate) sse_customer_key_md5: std::option::Option<std::string::String>,
        pub(crate) ssekms_key_id: std::option::Option<std::string::String>,
        pub(crate) ssekms_encryption_context: std::option::Option<std::string::String>,
        pub(crate) bucket_key_enabled: std::option::Option<bool>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) tagging: std::option::Option<std::string::String>,
        pub(crate) object_lock_mode: std::option::Option<crate::model::ObjectLockMode>,
        pub(crate) object_lock_retain_until_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) object_lock_legal_hold_status:
            std::option::Option<crate::model::ObjectLockLegalHoldStatus>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The canned ACL to apply to the object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn acl(mut self, input: crate::model::ObjectCannedAcl) -> Self {
            self.acl = Some(input);
            self
        }
        /// <p>The canned ACL to apply to the object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_acl(
            mut self,
            input: std::option::Option<crate::model::ObjectCannedAcl>,
        ) -> Self {
            self.acl = input;
            self
        }
        /// <p>The name of the bucket to which to initiate the upload</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket to which to initiate the upload</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Specifies caching behavior along the request/reply chain.</p>
        pub fn cache_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.cache_control = Some(input.into());
            self
        }
        /// <p>Specifies caching behavior along the request/reply chain.</p>
        pub fn set_cache_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cache_control = input;
            self
        }
        /// <p>Specifies presentational information for the object.</p>
        pub fn content_disposition(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_disposition = Some(input.into());
            self
        }
        /// <p>Specifies presentational information for the object.</p>
        pub fn set_content_disposition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_disposition = input;
            self
        }
        /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>
        pub fn content_encoding(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_encoding = Some(input.into());
            self
        }
        /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>
        pub fn set_content_encoding(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_encoding = input;
            self
        }
        /// <p>The language the content is in.</p>
        pub fn content_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_language = Some(input.into());
            self
        }
        /// <p>The language the content is in.</p>
        pub fn set_content_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.content_language = input;
            self
        }
        /// <p>A standard MIME type describing the format of the object data.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>A standard MIME type describing the format of the object data.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>The date and time at which the object is no longer cacheable.</p>
        pub fn expires(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expires = Some(input);
            self
        }
        /// <p>The date and time at which the object is no longer cacheable.</p>
        pub fn set_expires(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expires = input;
            self
        }
        /// <p>Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_full_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_full_control = Some(input.into());
            self
        }
        /// <p>Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_full_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_full_control = input;
            self
        }
        /// <p>Allows grantee to read the object data and its metadata.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_read(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_read = Some(input.into());
            self
        }
        /// <p>Allows grantee to read the object data and its metadata.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_read(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grant_read = input;
            self
        }
        /// <p>Allows grantee to read the object ACL.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_read_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_read_acp = Some(input.into());
            self
        }
        /// <p>Allows grantee to read the object ACL.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_read_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_read_acp = input;
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn grant_write_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_write_acp = Some(input.into());
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable object.</p>
        /// <p>This action is not supported by Amazon S3 on Outposts.</p>
        pub fn set_grant_write_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_write_acp = input;
            self
        }
        /// <p>Object key for which the multipart upload is to be initiated.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Object key for which the multipart upload is to be initiated.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Adds a key-value pair to `metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>A map of metadata to store with the object in S3.</p>
        pub fn metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.metadata = Some(hash_map);
            self
        }
        /// <p>A map of metadata to store with the object in S3.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>
        pub fn server_side_encryption(mut self, input: crate::model::ServerSideEncryption) -> Self {
            self.server_side_encryption = Some(input);
            self
        }
        /// <p>The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms).</p>
        pub fn set_server_side_encryption(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryption>,
        ) -> Self {
            self.server_side_encryption = input;
            self
        }
        /// <p>By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. Amazon S3 on Outposts only uses the OUTPOSTS Storage Class. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn storage_class(mut self, input: crate::model::StorageClass) -> Self {
            self.storage_class = Some(input);
            self
        }
        /// <p>By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. Amazon S3 on Outposts only uses the OUTPOSTS Storage Class. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<crate::model::StorageClass>,
        ) -> Self {
            self.storage_class = input;
            self
        }
        /// <p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p>
        pub fn website_redirect_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.website_redirect_location = Some(input.into());
            self
        }
        /// <p>If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata.</p>
        pub fn set_website_redirect_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.website_redirect_location = input;
            self
        }
        /// <p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>
        pub fn sse_customer_algorithm(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_algorithm = Some(input.into());
            self
        }
        /// <p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>
        pub fn set_sse_customer_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_algorithm = input;
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
        pub fn sse_customer_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_key = Some(input.into());
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
        pub fn set_sse_customer_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_key = input;
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn sse_customer_key_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_key_md5 = Some(input.into());
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn set_sse_customer_key_md5(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_key_md5 = input;
            self
        }
        /// <p>Specifies the ID of the symmetric customer managed key to use for object encryption. All GET and PUT requests for an object protected by Amazon Web Services KMS will fail if not made via SSL or using SigV4. For information about configuring using any of the officially supported Amazon Web Services SDKs and Amazon Web Services CLI, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version">Specifying the Signature Version in Request Authentication</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn ssekms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssekms_key_id = Some(input.into());
            self
        }
        /// <p>Specifies the ID of the symmetric customer managed key to use for object encryption. All GET and PUT requests for an object protected by Amazon Web Services KMS will fail if not made via SSL or using SigV4. For information about configuring using any of the officially supported Amazon Web Services SDKs and Amazon Web Services CLI, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version">Specifying the Signature Version in Request Authentication</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_ssekms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssekms_key_id = input;
            self
        }
        /// <p>Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p>
        pub fn ssekms_encryption_context(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssekms_encryption_context = Some(input.into());
            self
        }
        /// <p>Specifies the Amazon Web Services KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs.</p>
        pub fn set_ssekms_encryption_context(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssekms_encryption_context = input;
            self
        }
        /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using AWS KMS (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.</p>
        /// <p>Specifying this header with an object action doesn’t affect bucket-level settings for S3 Bucket Key.</p>
        pub fn bucket_key_enabled(mut self, input: bool) -> Self {
            self.bucket_key_enabled = Some(input);
            self
        }
        /// <p>Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using AWS KMS (SSE-KMS). Setting this header to <code>true</code> causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.</p>
        /// <p>Specifying this header with an object action doesn’t affect bucket-level settings for S3 Bucket Key.</p>
        pub fn set_bucket_key_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.bucket_key_enabled = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>The tag-set for the object. The tag-set must be encoded as URL Query parameters.</p>
        pub fn tagging(mut self, input: impl Into<std::string::String>) -> Self {
            self.tagging = Some(input.into());
            self
        }
        /// <p>The tag-set for the object. The tag-set must be encoded as URL Query parameters.</p>
        pub fn set_tagging(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tagging = input;
            self
        }
        /// <p>Specifies the Object Lock mode that you want to apply to the uploaded object.</p>
        pub fn object_lock_mode(mut self, input: crate::model::ObjectLockMode) -> Self {
            self.object_lock_mode = Some(input);
            self
        }
        /// <p>Specifies the Object Lock mode that you want to apply to the uploaded object.</p>
        pub fn set_object_lock_mode(
            mut self,
            input: std::option::Option<crate::model::ObjectLockMode>,
        ) -> Self {
            self.object_lock_mode = input;
            self
        }
        /// <p>Specifies the date and time when you want the Object Lock to expire.</p>
        pub fn object_lock_retain_until_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.object_lock_retain_until_date = Some(input);
            self
        }
        /// <p>Specifies the date and time when you want the Object Lock to expire.</p>
        pub fn set_object_lock_retain_until_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.object_lock_retain_until_date = input;
            self
        }
        /// <p>Specifies whether you want to apply a Legal Hold to the uploaded object.</p>
        pub fn object_lock_legal_hold_status(
            mut self,
            input: crate::model::ObjectLockLegalHoldStatus,
        ) -> Self {
            self.object_lock_legal_hold_status = Some(input);
            self
        }
        /// <p>Specifies whether you want to apply a Legal Hold to the uploaded object.</p>
        pub fn set_object_lock_legal_hold_status(
            mut self,
            input: std::option::Option<crate::model::ObjectLockLegalHoldStatus>,
        ) -> Self {
            self.object_lock_legal_hold_status = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMultipartUploadInput`](crate::input::CreateMultipartUploadInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMultipartUploadInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMultipartUploadInput {
                acl: self.acl,
                bucket: self.bucket,
                cache_control: self.cache_control,
                content_disposition: self.content_disposition,
                content_encoding: self.content_encoding,
                content_language: self.content_language,
                content_type: self.content_type,
                expires: self.expires,
                grant_full_control: self.grant_full_control,
                grant_read: self.grant_read,
                grant_read_acp: self.grant_read_acp,
                grant_write_acp: self.grant_write_acp,
                key: self.key,
                metadata: self.metadata,
                server_side_encryption: self.server_side_encryption,
                storage_class: self.storage_class,
                website_redirect_location: self.website_redirect_location,
                sse_customer_algorithm: self.sse_customer_algorithm,
                sse_customer_key: self.sse_customer_key,
                sse_customer_key_md5: self.sse_customer_key_md5,
                ssekms_key_id: self.ssekms_key_id,
                ssekms_encryption_context: self.ssekms_encryption_context,
                bucket_key_enabled: self.bucket_key_enabled.unwrap_or_default(),
                request_payer: self.request_payer,
                tagging: self.tagging,
                object_lock_mode: self.object_lock_mode,
                object_lock_retain_until_date: self.object_lock_retain_until_date,
                object_lock_legal_hold_status: self.object_lock_legal_hold_status,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMultipartUploadInputOperationOutputAlias = crate::operation::CreateMultipartUpload;
#[doc(hidden)]
pub type CreateMultipartUploadInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateMultipartUploadInput {
    /// Consumes the builder and constructs an Operation<[`CreateMultipartUpload`](crate::operation::CreateMultipartUpload)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMultipartUpload,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateMultipartUploadInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_107 = &_input.bucket;
            let input_107 =
                input_107
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_107, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            let input_108 = &_input.key;
            let input_108 =
                input_108
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    })?;
            let key = aws_smithy_http::label::fmt_string(input_108, true);
            if key.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "key",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::CreateMultipartUploadInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_109) = &_input.acl {
                let formatted_110 = AsRef::<str>::as_ref(inner_109);
                if !formatted_110.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_110;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "acl",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-acl", header_value);
                }
            }
            if let Some(inner_111) = &_input.cache_control {
                let formatted_112 = AsRef::<str>::as_ref(inner_111);
                if !formatted_112.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_112;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "cache_control",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Cache-Control", header_value);
                }
            }
            if let Some(inner_113) = &_input.content_disposition {
                let formatted_114 = AsRef::<str>::as_ref(inner_113);
                if !formatted_114.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_114;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "content_disposition",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Content-Disposition", header_value);
                }
            }
            if let Some(inner_115) = &_input.content_encoding {
                let formatted_116 = AsRef::<str>::as_ref(inner_115);
                if !formatted_116.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_116;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "content_encoding",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Content-Encoding", header_value);
                }
            }
            if let Some(inner_117) = &_input.content_language {
                let formatted_118 = AsRef::<str>::as_ref(inner_117);
                if !formatted_118.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_118;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "content_language",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Content-Language", header_value);
                }
            }
            if let Some(inner_119) = &_input.content_type {
                let formatted_120 = AsRef::<str>::as_ref(inner_119);
                if !formatted_120.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_120;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "content_type",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Content-Type", header_value);
                }
            }
            if let Some(inner_121) = &_input.expires {
                let formatted_122 = inner_121.fmt(aws_smithy_types::date_time::Format::HttpDate)?;
                if !formatted_122.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_122;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expires",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Expires", header_value);
                }
            }
            if let Some(inner_123) = &_input.grant_full_control {
                let formatted_124 = AsRef::<str>::as_ref(inner_123);
                if !formatted_124.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_124;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "grant_full_control",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-grant-full-control", header_value);
                }
            }
            if let Some(inner_125) = &_input.grant_read {
                let formatted_126 = AsRef::<str>::as_ref(inner_125);
                if !formatted_126.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_126;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "grant_read",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-grant-read", header_value);
                }
            }
            if let Some(inner_127) = &_input.grant_read_acp {
                let formatted_128 = AsRef::<str>::as_ref(inner_127);
                if !formatted_128.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_128;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "grant_read_acp",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-grant-read-acp", header_value);
                }
            }
            if let Some(inner_129) = &_input.grant_write_acp {
                let formatted_130 = AsRef::<str>::as_ref(inner_129);
                if !formatted_130.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_130;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "grant_write_acp",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-grant-write-acp", header_value);
                }
            }
            if let Some(inner_131) = &_input.server_side_encryption {
                let formatted_132 = AsRef::<str>::as_ref(inner_131);
                if !formatted_132.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_132;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "server_side_encryption",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-server-side-encryption", header_value);
                }
            }
            if let Some(inner_133) = &_input.storage_class {
                let formatted_134 = AsRef::<str>::as_ref(inner_133);
                if !formatted_134.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_134;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "storage_class",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-storage-class", header_value);
                }
            }
            if let Some(inner_135) = &_input.website_redirect_location {
                let formatted_136 = AsRef::<str>::as_ref(inner_135);
                if !formatted_136.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_136;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "website_redirect_location",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-website-redirect-location", header_value);
                }
            }
            if let Some(inner_137) = &_input.sse_customer_algorithm {
                let formatted_138 = AsRef::<str>::as_ref(inner_137);
                if !formatted_138.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_138;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "sse_customer_algorithm",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header(
                        "x-amz-server-side-encryption-customer-algorithm",
                        header_value,
                    );
                }
            }
            if let Some(inner_139) = &_input.sse_customer_key {
                let formatted_140 = AsRef::<str>::as_ref(inner_139);
                if !formatted_140.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_140;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "sse_customer_key",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder =
                        builder.header("x-amz-server-side-encryption-customer-key", header_value);
                }
            }
            if let Some(inner_141) = &_input.sse_customer_key_md5 {
                let formatted_142 = AsRef::<str>::as_ref(inner_141);
                if !formatted_142.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_142;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "sse_customer_key_md5",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header(
                        "x-amz-server-side-encryption-customer-key-MD5",
                        header_value,
                    );
                }
            }
            if let Some(inner_143) = &_input.ssekms_key_id {
                let formatted_144 = AsRef::<str>::as_ref(inner_143);
                if !formatted_144.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_144;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "ssekms_key_id",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder =
                        builder.header("x-amz-server-side-encryption-aws-kms-key-id", header_value);
                }
            }
            if let Some(inner_145) = &_input.ssekms_encryption_context {
                let formatted_146 = AsRef::<str>::as_ref(inner_145);
                if !formatted_146.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_146;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "ssekms_encryption_context",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("x-amz-server-side-encryption-context", header_value);
                }
            }
            if _input.bucket_key_enabled {
                let mut encoder =
                    aws_smithy_types::primitive::Encoder::from(_input.bucket_key_enabled);
                let formatted_147 = encoder.encode();
                if !formatted_147.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_147;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "bucket_key_enabled",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header(
                        "x-amz-server-side-encryption-bucket-key-enabled",
                        header_value,
                    );
                }
            }
            if let Some(inner_148) = &_input.request_payer {
                let formatted_149 = AsRef::<str>::as_ref(inner_148);
                if !formatted_149.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_149;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "request_payer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-request-payer", header_value);
                }
            }
            if let Some(inner_150) = &_input.tagging {
                let formatted_151 = AsRef::<str>::as_ref(inner_150);
                if !formatted_151.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_151;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "tagging",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-tagging", header_value);
                }
            }
            if let Some(inner_152) = &_input.object_lock_mode {
                let formatted_153 = AsRef::<str>::as_ref(inner_152);
                if !formatted_153.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_153;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "object_lock_mode",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-object-lock-mode", header_value);
                }
            }
            if let Some(inner_154) = &_input.object_lock_retain_until_date {
                let formatted_155 = inner_154.fmt(aws_smithy_types::date_time::Format::DateTime)?;
                if !formatted_155.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_155;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "object_lock_retain_until_date",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-object-lock-retain-until-date", header_value);
                }
            }
            if let Some(inner_156) = &_input.object_lock_legal_hold_status {
                let formatted_157 = AsRef::<str>::as_ref(inner_156);
                if !formatted_157.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_157;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "object_lock_legal_hold_status",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-object-lock-legal-hold", header_value);
                }
            }
            if let Some(inner_158) = &_input.expected_bucket_owner {
                let formatted_159 = AsRef::<str>::as_ref(inner_158);
                if !formatted_159.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_159;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            if let Some(inner_160) = &_input.metadata {
                for (k, v) in inner_160 {
                    use std::str::FromStr;
                    let header_name =
                        http::header::HeaderName::from_str(&format!("{}{}", "x-amz-meta-", &k))
                            .map_err(|err| {
                                aws_smithy_http::operation::BuildError::InvalidField {
                                    field: "metadata",
                                    details: format!(
                                        "`{}` cannot be used as a header name: {}",
                                        k, err
                                    ),
                                }
                            })?;
                    use std::convert::TryFrom;
                    let header_value = AsRef::<str>::as_ref(v);
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "metadata",
                            details: format!("`{}` cannot be used as a header value: {}", v, err),
                        })?;
                    builder = builder.header(header_name, header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::CreateMultipartUploadInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("uploads");
            query.push_kv("x-id", "CreateMultipartUpload");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateMultipartUploadInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateMultipartUploadInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMultipartUpload::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMultipartUpload",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateMultipartUploadInput`](crate::input::CreateMultipartUploadInput)
    pub fn builder() -> crate::input::create_multipart_upload_input::Builder {
        crate::input::create_multipart_upload_input::Builder::default()
    }
}

/// See [`DeleteBucketInput`](crate::input::DeleteBucketInput)
pub mod delete_bucket_input {
    /// A builder for [`DeleteBucketInput`](crate::input::DeleteBucketInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the bucket being deleted.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>Specifies the bucket being deleted.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketInput`](crate::input::DeleteBucketInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketInputOperationOutputAlias = crate::operation::DeleteBucket;
#[doc(hidden)]
pub type DeleteBucketInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucket`](crate::operation::DeleteBucket)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucket,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBucketInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_161 = &_input.bucket;
            let input_161 =
                input_161
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_161, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteBucketInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_162) = &_input.expected_bucket_owner {
                let formatted_163 = AsRef::<str>::as_ref(inner_162);
                if !formatted_163.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_163;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBucketInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBucketInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucket::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucket",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketInput`](crate::input::DeleteBucketInput)
    pub fn builder() -> crate::input::delete_bucket_input::Builder {
        crate::input::delete_bucket_input::Builder::default()
    }
}

/// See [`DeleteBucketAnalyticsConfigurationInput`](crate::input::DeleteBucketAnalyticsConfigurationInput)
pub mod delete_bucket_analytics_configuration_input {
    /// A builder for [`DeleteBucketAnalyticsConfigurationInput`](crate::input::DeleteBucketAnalyticsConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket from which an analytics configuration is deleted.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket from which an analytics configuration is deleted.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The ID that identifies the analytics configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID that identifies the analytics configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketAnalyticsConfigurationInput`](crate::input::DeleteBucketAnalyticsConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketAnalyticsConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketAnalyticsConfigurationInput {
                bucket: self.bucket,
                id: self.id,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketAnalyticsConfigurationInputOperationOutputAlias =
    crate::operation::DeleteBucketAnalyticsConfiguration;
#[doc(hidden)]
pub type DeleteBucketAnalyticsConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketAnalyticsConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucketAnalyticsConfiguration`](crate::operation::DeleteBucketAnalyticsConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucketAnalyticsConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBucketAnalyticsConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_164 = &_input.bucket;
            let input_164 =
                input_164
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_164, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteBucketAnalyticsConfigurationInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_165) = &_input.expected_bucket_owner {
                let formatted_166 = AsRef::<str>::as_ref(inner_165);
                if !formatted_166.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_166;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::DeleteBucketAnalyticsConfigurationInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("analytics");
            if let Some(inner_167) = &_input.id {
                query.push_kv("id", &aws_smithy_http::query::fmt_string(&inner_167));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBucketAnalyticsConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBucketAnalyticsConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucketAnalyticsConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucketAnalyticsConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketAnalyticsConfigurationInput`](crate::input::DeleteBucketAnalyticsConfigurationInput)
    pub fn builder() -> crate::input::delete_bucket_analytics_configuration_input::Builder {
        crate::input::delete_bucket_analytics_configuration_input::Builder::default()
    }
}

/// See [`DeleteBucketCorsInput`](crate::input::DeleteBucketCorsInput)
pub mod delete_bucket_cors_input {
    /// A builder for [`DeleteBucketCorsInput`](crate::input::DeleteBucketCorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the bucket whose <code>cors</code> configuration is being deleted.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>Specifies the bucket whose <code>cors</code> configuration is being deleted.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketCorsInput`](crate::input::DeleteBucketCorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketCorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketCorsInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketCorsInputOperationOutputAlias = crate::operation::DeleteBucketCors;
#[doc(hidden)]
pub type DeleteBucketCorsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketCorsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucketCors`](crate::operation::DeleteBucketCors)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucketCors,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBucketCorsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_168 = &_input.bucket;
            let input_168 =
                input_168
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_168, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteBucketCorsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_169) = &_input.expected_bucket_owner {
                let formatted_170 = AsRef::<str>::as_ref(inner_169);
                if !formatted_170.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_170;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::DeleteBucketCorsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("cors");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBucketCorsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBucketCorsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucketCors::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucketCors",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketCorsInput`](crate::input::DeleteBucketCorsInput)
    pub fn builder() -> crate::input::delete_bucket_cors_input::Builder {
        crate::input::delete_bucket_cors_input::Builder::default()
    }
}

/// See [`DeleteBucketEncryptionInput`](crate::input::DeleteBucketEncryptionInput)
pub mod delete_bucket_encryption_input {
    /// A builder for [`DeleteBucketEncryptionInput`](crate::input::DeleteBucketEncryptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket containing the server-side encryption configuration to delete.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket containing the server-side encryption configuration to delete.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketEncryptionInput`](crate::input::DeleteBucketEncryptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketEncryptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketEncryptionInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketEncryptionInputOperationOutputAlias = crate::operation::DeleteBucketEncryption;
#[doc(hidden)]
pub type DeleteBucketEncryptionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketEncryptionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucketEncryption`](crate::operation::DeleteBucketEncryption)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucketEncryption,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBucketEncryptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_171 = &_input.bucket;
            let input_171 =
                input_171
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_171, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteBucketEncryptionInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_172) = &_input.expected_bucket_owner {
                let formatted_173 = AsRef::<str>::as_ref(inner_172);
                if !formatted_173.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_173;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::DeleteBucketEncryptionInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("encryption");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBucketEncryptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBucketEncryptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucketEncryption::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucketEncryption",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketEncryptionInput`](crate::input::DeleteBucketEncryptionInput)
    pub fn builder() -> crate::input::delete_bucket_encryption_input::Builder {
        crate::input::delete_bucket_encryption_input::Builder::default()
    }
}

/// See [`DeleteBucketIntelligentTieringConfigurationInput`](crate::input::DeleteBucketIntelligentTieringConfigurationInput)
pub mod delete_bucket_intelligent_tiering_configuration_input {
    /// A builder for [`DeleteBucketIntelligentTieringConfigurationInput`](crate::input::DeleteBucketIntelligentTieringConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon S3 bucket whose configuration you want to modify or retrieve.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket whose configuration you want to modify or retrieve.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketIntelligentTieringConfigurationInput`](crate::input::DeleteBucketIntelligentTieringConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketIntelligentTieringConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DeleteBucketIntelligentTieringConfigurationInput {
                    bucket: self.bucket,
                    id: self.id,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketIntelligentTieringConfigurationInputOperationOutputAlias =
    crate::operation::DeleteBucketIntelligentTieringConfiguration;
#[doc(hidden)]
pub type DeleteBucketIntelligentTieringConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketIntelligentTieringConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucketIntelligentTieringConfiguration`](crate::operation::DeleteBucketIntelligentTieringConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucketIntelligentTieringConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBucketIntelligentTieringConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_174 = &_input.bucket;
            let input_174 =
                input_174
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_174, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteBucketIntelligentTieringConfigurationInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("intelligent-tiering");
            if let Some(inner_175) = &_input.id {
                query.push_kv("id", &aws_smithy_http::query::fmt_string(&inner_175));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBucketIntelligentTieringConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBucketIntelligentTieringConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucketIntelligentTieringConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucketIntelligentTieringConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketIntelligentTieringConfigurationInput`](crate::input::DeleteBucketIntelligentTieringConfigurationInput)
    pub fn builder() -> crate::input::delete_bucket_intelligent_tiering_configuration_input::Builder
    {
        crate::input::delete_bucket_intelligent_tiering_configuration_input::Builder::default()
    }
}

/// See [`DeleteBucketInventoryConfigurationInput`](crate::input::DeleteBucketInventoryConfigurationInput)
pub mod delete_bucket_inventory_configuration_input {
    /// A builder for [`DeleteBucketInventoryConfigurationInput`](crate::input::DeleteBucketInventoryConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket containing the inventory configuration to delete.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket containing the inventory configuration to delete.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The ID used to identify the inventory configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID used to identify the inventory configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketInventoryConfigurationInput`](crate::input::DeleteBucketInventoryConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketInventoryConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketInventoryConfigurationInput {
                bucket: self.bucket,
                id: self.id,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketInventoryConfigurationInputOperationOutputAlias =
    crate::operation::DeleteBucketInventoryConfiguration;
#[doc(hidden)]
pub type DeleteBucketInventoryConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketInventoryConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucketInventoryConfiguration`](crate::operation::DeleteBucketInventoryConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucketInventoryConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBucketInventoryConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_176 = &_input.bucket;
            let input_176 =
                input_176
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_176, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteBucketInventoryConfigurationInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_177) = &_input.expected_bucket_owner {
                let formatted_178 = AsRef::<str>::as_ref(inner_177);
                if !formatted_178.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_178;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::DeleteBucketInventoryConfigurationInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("inventory");
            if let Some(inner_179) = &_input.id {
                query.push_kv("id", &aws_smithy_http::query::fmt_string(&inner_179));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBucketInventoryConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBucketInventoryConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucketInventoryConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucketInventoryConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketInventoryConfigurationInput`](crate::input::DeleteBucketInventoryConfigurationInput)
    pub fn builder() -> crate::input::delete_bucket_inventory_configuration_input::Builder {
        crate::input::delete_bucket_inventory_configuration_input::Builder::default()
    }
}

/// See [`DeleteBucketLifecycleInput`](crate::input::DeleteBucketLifecycleInput)
pub mod delete_bucket_lifecycle_input {
    /// A builder for [`DeleteBucketLifecycleInput`](crate::input::DeleteBucketLifecycleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name of the lifecycle to delete.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name of the lifecycle to delete.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketLifecycleInput`](crate::input::DeleteBucketLifecycleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketLifecycleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketLifecycleInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketLifecycleInputOperationOutputAlias = crate::operation::DeleteBucketLifecycle;
#[doc(hidden)]
pub type DeleteBucketLifecycleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketLifecycleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucketLifecycle`](crate::operation::DeleteBucketLifecycle)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucketLifecycle,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBucketLifecycleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_180 = &_input.bucket;
            let input_180 =
                input_180
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_180, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteBucketLifecycleInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_181) = &_input.expected_bucket_owner {
                let formatted_182 = AsRef::<str>::as_ref(inner_181);
                if !formatted_182.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_182;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::DeleteBucketLifecycleInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("lifecycle");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBucketLifecycleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBucketLifecycleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucketLifecycle::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucketLifecycle",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketLifecycleInput`](crate::input::DeleteBucketLifecycleInput)
    pub fn builder() -> crate::input::delete_bucket_lifecycle_input::Builder {
        crate::input::delete_bucket_lifecycle_input::Builder::default()
    }
}

/// See [`DeleteBucketMetricsConfigurationInput`](crate::input::DeleteBucketMetricsConfigurationInput)
pub mod delete_bucket_metrics_configuration_input {
    /// A builder for [`DeleteBucketMetricsConfigurationInput`](crate::input::DeleteBucketMetricsConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket containing the metrics configuration to delete.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket containing the metrics configuration to delete.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The ID used to identify the metrics configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID used to identify the metrics configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketMetricsConfigurationInput`](crate::input::DeleteBucketMetricsConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketMetricsConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketMetricsConfigurationInput {
                bucket: self.bucket,
                id: self.id,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketMetricsConfigurationInputOperationOutputAlias =
    crate::operation::DeleteBucketMetricsConfiguration;
#[doc(hidden)]
pub type DeleteBucketMetricsConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketMetricsConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucketMetricsConfiguration`](crate::operation::DeleteBucketMetricsConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucketMetricsConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBucketMetricsConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_183 = &_input.bucket;
            let input_183 =
                input_183
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_183, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteBucketMetricsConfigurationInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_184) = &_input.expected_bucket_owner {
                let formatted_185 = AsRef::<str>::as_ref(inner_184);
                if !formatted_185.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_185;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::DeleteBucketMetricsConfigurationInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("metrics");
            if let Some(inner_186) = &_input.id {
                query.push_kv("id", &aws_smithy_http::query::fmt_string(&inner_186));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBucketMetricsConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBucketMetricsConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucketMetricsConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucketMetricsConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketMetricsConfigurationInput`](crate::input::DeleteBucketMetricsConfigurationInput)
    pub fn builder() -> crate::input::delete_bucket_metrics_configuration_input::Builder {
        crate::input::delete_bucket_metrics_configuration_input::Builder::default()
    }
}

/// See [`DeleteBucketOwnershipControlsInput`](crate::input::DeleteBucketOwnershipControlsInput)
pub mod delete_bucket_ownership_controls_input {
    /// A builder for [`DeleteBucketOwnershipControlsInput`](crate::input::DeleteBucketOwnershipControlsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon S3 bucket whose <code>OwnershipControls</code> you want to delete. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket whose <code>OwnershipControls</code> you want to delete. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketOwnershipControlsInput`](crate::input::DeleteBucketOwnershipControlsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketOwnershipControlsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketOwnershipControlsInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketOwnershipControlsInputOperationOutputAlias =
    crate::operation::DeleteBucketOwnershipControls;
#[doc(hidden)]
pub type DeleteBucketOwnershipControlsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketOwnershipControlsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucketOwnershipControls`](crate::operation::DeleteBucketOwnershipControls)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucketOwnershipControls,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBucketOwnershipControlsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_187 = &_input.bucket;
            let input_187 =
                input_187
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_187, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteBucketOwnershipControlsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_188) = &_input.expected_bucket_owner {
                let formatted_189 = AsRef::<str>::as_ref(inner_188);
                if !formatted_189.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_189;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::DeleteBucketOwnershipControlsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("ownershipControls");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBucketOwnershipControlsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBucketOwnershipControlsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucketOwnershipControls::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucketOwnershipControls",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketOwnershipControlsInput`](crate::input::DeleteBucketOwnershipControlsInput)
    pub fn builder() -> crate::input::delete_bucket_ownership_controls_input::Builder {
        crate::input::delete_bucket_ownership_controls_input::Builder::default()
    }
}

/// See [`DeleteBucketPolicyInput`](crate::input::DeleteBucketPolicyInput)
pub mod delete_bucket_policy_input {
    /// A builder for [`DeleteBucketPolicyInput`](crate::input::DeleteBucketPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketPolicyInput`](crate::input::DeleteBucketPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketPolicyInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketPolicyInputOperationOutputAlias = crate::operation::DeleteBucketPolicy;
#[doc(hidden)]
pub type DeleteBucketPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucketPolicy`](crate::operation::DeleteBucketPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucketPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBucketPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_190 = &_input.bucket;
            let input_190 =
                input_190
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_190, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteBucketPolicyInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_191) = &_input.expected_bucket_owner {
                let formatted_192 = AsRef::<str>::as_ref(inner_191);
                if !formatted_192.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_192;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::DeleteBucketPolicyInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("policy");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBucketPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBucketPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucketPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucketPolicy",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketPolicyInput`](crate::input::DeleteBucketPolicyInput)
    pub fn builder() -> crate::input::delete_bucket_policy_input::Builder {
        crate::input::delete_bucket_policy_input::Builder::default()
    }
}

/// See [`DeleteBucketReplicationInput`](crate::input::DeleteBucketReplicationInput)
pub mod delete_bucket_replication_input {
    /// A builder for [`DeleteBucketReplicationInput`](crate::input::DeleteBucketReplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The bucket name. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p> The bucket name. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketReplicationInput`](crate::input::DeleteBucketReplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketReplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketReplicationInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketReplicationInputOperationOutputAlias =
    crate::operation::DeleteBucketReplication;
#[doc(hidden)]
pub type DeleteBucketReplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketReplicationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucketReplication`](crate::operation::DeleteBucketReplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucketReplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBucketReplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_193 = &_input.bucket;
            let input_193 =
                input_193
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_193, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteBucketReplicationInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_194) = &_input.expected_bucket_owner {
                let formatted_195 = AsRef::<str>::as_ref(inner_194);
                if !formatted_195.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_195;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::DeleteBucketReplicationInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("replication");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBucketReplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBucketReplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucketReplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucketReplication",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketReplicationInput`](crate::input::DeleteBucketReplicationInput)
    pub fn builder() -> crate::input::delete_bucket_replication_input::Builder {
        crate::input::delete_bucket_replication_input::Builder::default()
    }
}

/// See [`DeleteBucketTaggingInput`](crate::input::DeleteBucketTaggingInput)
pub mod delete_bucket_tagging_input {
    /// A builder for [`DeleteBucketTaggingInput`](crate::input::DeleteBucketTaggingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket that has the tag set to be removed.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket that has the tag set to be removed.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketTaggingInput`](crate::input::DeleteBucketTaggingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketTaggingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketTaggingInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketTaggingInputOperationOutputAlias = crate::operation::DeleteBucketTagging;
#[doc(hidden)]
pub type DeleteBucketTaggingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketTaggingInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucketTagging`](crate::operation::DeleteBucketTagging)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucketTagging,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBucketTaggingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_196 = &_input.bucket;
            let input_196 =
                input_196
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_196, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteBucketTaggingInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_197) = &_input.expected_bucket_owner {
                let formatted_198 = AsRef::<str>::as_ref(inner_197);
                if !formatted_198.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_198;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::DeleteBucketTaggingInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("tagging");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBucketTaggingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBucketTaggingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucketTagging::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucketTagging",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketTaggingInput`](crate::input::DeleteBucketTaggingInput)
    pub fn builder() -> crate::input::delete_bucket_tagging_input::Builder {
        crate::input::delete_bucket_tagging_input::Builder::default()
    }
}

/// See [`DeleteBucketWebsiteInput`](crate::input::DeleteBucketWebsiteInput)
pub mod delete_bucket_website_input {
    /// A builder for [`DeleteBucketWebsiteInput`](crate::input::DeleteBucketWebsiteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name for which you want to remove the website configuration. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name for which you want to remove the website configuration. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketWebsiteInput`](crate::input::DeleteBucketWebsiteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketWebsiteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketWebsiteInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketWebsiteInputOperationOutputAlias = crate::operation::DeleteBucketWebsite;
#[doc(hidden)]
pub type DeleteBucketWebsiteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketWebsiteInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucketWebsite`](crate::operation::DeleteBucketWebsite)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucketWebsite,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBucketWebsiteInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_199 = &_input.bucket;
            let input_199 =
                input_199
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_199, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteBucketWebsiteInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_200) = &_input.expected_bucket_owner {
                let formatted_201 = AsRef::<str>::as_ref(inner_200);
                if !formatted_201.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_201;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::DeleteBucketWebsiteInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("website");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBucketWebsiteInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBucketWebsiteInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucketWebsite::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucketWebsite",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketWebsiteInput`](crate::input::DeleteBucketWebsiteInput)
    pub fn builder() -> crate::input::delete_bucket_website_input::Builder {
        crate::input::delete_bucket_website_input::Builder::default()
    }
}

/// See [`DeleteObjectInput`](crate::input::DeleteObjectInput)
pub mod delete_object_input {
    /// A builder for [`DeleteObjectInput`](crate::input::DeleteObjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) mfa: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) bypass_governance_retention: std::option::Option<bool>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name of the bucket containing the object. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name of the bucket containing the object. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Key name of the object to delete.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Key name of the object to delete.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The concatenation of the authentication device's serial number, a space, and the value that is displayed on your authentication device. Required to permanently delete a versioned object if versioning is configured with MFA delete enabled.</p>
        pub fn mfa(mut self, input: impl Into<std::string::String>) -> Self {
            self.mfa = Some(input.into());
            self
        }
        /// <p>The concatenation of the authentication device's serial number, a space, and the value that is displayed on your authentication device. Required to permanently delete a versioned object if versioning is configured with MFA delete enabled.</p>
        pub fn set_mfa(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mfa = input;
            self
        }
        /// <p>VersionId used to reference a specific version of the object.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>VersionId used to reference a specific version of the object.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>Indicates whether S3 Object Lock should bypass Governance-mode restrictions to process this operation. To use this header, you must have the <code>s3:PutBucketPublicAccessBlock</code> permission.</p>
        pub fn bypass_governance_retention(mut self, input: bool) -> Self {
            self.bypass_governance_retention = Some(input);
            self
        }
        /// <p>Indicates whether S3 Object Lock should bypass Governance-mode restrictions to process this operation. To use this header, you must have the <code>s3:PutBucketPublicAccessBlock</code> permission.</p>
        pub fn set_bypass_governance_retention(mut self, input: std::option::Option<bool>) -> Self {
            self.bypass_governance_retention = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteObjectInput`](crate::input::DeleteObjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteObjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteObjectInput {
                bucket: self.bucket,
                key: self.key,
                mfa: self.mfa,
                version_id: self.version_id,
                request_payer: self.request_payer,
                bypass_governance_retention: self.bypass_governance_retention.unwrap_or_default(),
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteObjectInputOperationOutputAlias = crate::operation::DeleteObject;
#[doc(hidden)]
pub type DeleteObjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteObjectInput {
    /// Consumes the builder and constructs an Operation<[`DeleteObject`](crate::operation::DeleteObject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteObject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteObjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_202 = &_input.bucket;
            let input_202 =
                input_202
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_202, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            let input_203 = &_input.key;
            let input_203 =
                input_203
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    })?;
            let key = aws_smithy_http::label::fmt_string(input_203, true);
            if key.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "key",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteObjectInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_204) = &_input.mfa {
                let formatted_205 = AsRef::<str>::as_ref(inner_204);
                if !formatted_205.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_205;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "mfa",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-mfa", header_value);
                }
            }
            if let Some(inner_206) = &_input.request_payer {
                let formatted_207 = AsRef::<str>::as_ref(inner_206);
                if !formatted_207.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_207;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "request_payer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-request-payer", header_value);
                }
            }
            if _input.bypass_governance_retention {
                let mut encoder =
                    aws_smithy_types::primitive::Encoder::from(_input.bypass_governance_retention);
                let formatted_208 = encoder.encode();
                if !formatted_208.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_208;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "bypass_governance_retention",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-bypass-governance-retention", header_value);
                }
            }
            if let Some(inner_209) = &_input.expected_bucket_owner {
                let formatted_210 = AsRef::<str>::as_ref(inner_209);
                if !formatted_210.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_210;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::DeleteObjectInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("x-id", "DeleteObject");
            if let Some(inner_211) = &_input.version_id {
                query.push_kv("versionId", &aws_smithy_http::query::fmt_string(&inner_211));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteObjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteObjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteObject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteObject",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteObjectInput`](crate::input::DeleteObjectInput)
    pub fn builder() -> crate::input::delete_object_input::Builder {
        crate::input::delete_object_input::Builder::default()
    }
}

/// See [`DeleteObjectsInput`](crate::input::DeleteObjectsInput)
pub mod delete_objects_input {
    /// A builder for [`DeleteObjectsInput`](crate::input::DeleteObjectsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) delete: std::option::Option<crate::model::Delete>,
        pub(crate) mfa: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) bypass_governance_retention: std::option::Option<bool>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name containing the objects to delete. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name containing the objects to delete. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Container for the request.</p>
        pub fn delete(mut self, input: crate::model::Delete) -> Self {
            self.delete = Some(input);
            self
        }
        /// <p>Container for the request.</p>
        pub fn set_delete(mut self, input: std::option::Option<crate::model::Delete>) -> Self {
            self.delete = input;
            self
        }
        /// <p>The concatenation of the authentication device's serial number, a space, and the value that is displayed on your authentication device. Required to permanently delete a versioned object if versioning is configured with MFA delete enabled.</p>
        pub fn mfa(mut self, input: impl Into<std::string::String>) -> Self {
            self.mfa = Some(input.into());
            self
        }
        /// <p>The concatenation of the authentication device's serial number, a space, and the value that is displayed on your authentication device. Required to permanently delete a versioned object if versioning is configured with MFA delete enabled.</p>
        pub fn set_mfa(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mfa = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>Specifies whether you want to delete this object even if it has a Governance-type Object Lock in place. To use this header, you must have the <code>s3:PutBucketPublicAccessBlock</code> permission.</p>
        pub fn bypass_governance_retention(mut self, input: bool) -> Self {
            self.bypass_governance_retention = Some(input);
            self
        }
        /// <p>Specifies whether you want to delete this object even if it has a Governance-type Object Lock in place. To use this header, you must have the <code>s3:PutBucketPublicAccessBlock</code> permission.</p>
        pub fn set_bypass_governance_retention(mut self, input: std::option::Option<bool>) -> Self {
            self.bypass_governance_retention = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteObjectsInput`](crate::input::DeleteObjectsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteObjectsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteObjectsInput {
                bucket: self.bucket,
                delete: self.delete,
                mfa: self.mfa,
                request_payer: self.request_payer,
                bypass_governance_retention: self.bypass_governance_retention.unwrap_or_default(),
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteObjectsInputOperationOutputAlias = crate::operation::DeleteObjects;
#[doc(hidden)]
pub type DeleteObjectsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteObjectsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteObjects`](crate::operation::DeleteObjects)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteObjects,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteObjectsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_212 = &_input.bucket;
            let input_212 =
                input_212
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_212, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteObjectsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_213) = &_input.mfa {
                let formatted_214 = AsRef::<str>::as_ref(inner_213);
                if !formatted_214.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_214;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "mfa",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-mfa", header_value);
                }
            }
            if let Some(inner_215) = &_input.request_payer {
                let formatted_216 = AsRef::<str>::as_ref(inner_215);
                if !formatted_216.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_216;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "request_payer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-request-payer", header_value);
                }
            }
            if _input.bypass_governance_retention {
                let mut encoder =
                    aws_smithy_types::primitive::Encoder::from(_input.bypass_governance_retention);
                let formatted_217 = encoder.encode();
                if !formatted_217.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_217;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "bypass_governance_retention",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-bypass-governance-retention", header_value);
                }
            }
            if let Some(inner_218) = &_input.expected_bucket_owner {
                let formatted_219 = AsRef::<str>::as_ref(inner_218);
                if !formatted_219.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_219;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::DeleteObjectsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("delete");
            query.push_kv("x-id", "DeleteObjects");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteObjectsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteObjectsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::ser_payload_delete_objects_input(&self.delete)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteObjects::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteObjects",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteObjectsInput`](crate::input::DeleteObjectsInput)
    pub fn builder() -> crate::input::delete_objects_input::Builder {
        crate::input::delete_objects_input::Builder::default()
    }
}

/// See [`DeleteObjectTaggingInput`](crate::input::DeleteObjectTaggingInput)
pub mod delete_object_tagging_input {
    /// A builder for [`DeleteObjectTaggingInput`](crate::input::DeleteObjectTaggingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name containing the objects from which to remove the tags. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name containing the objects from which to remove the tags. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The key that identifies the object in the bucket from which to remove all tags.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key that identifies the object in the bucket from which to remove all tags.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The versionId of the object that the tag-set will be removed from.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The versionId of the object that the tag-set will be removed from.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteObjectTaggingInput`](crate::input::DeleteObjectTaggingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteObjectTaggingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteObjectTaggingInput {
                bucket: self.bucket,
                key: self.key,
                version_id: self.version_id,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteObjectTaggingInputOperationOutputAlias = crate::operation::DeleteObjectTagging;
#[doc(hidden)]
pub type DeleteObjectTaggingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteObjectTaggingInput {
    /// Consumes the builder and constructs an Operation<[`DeleteObjectTagging`](crate::operation::DeleteObjectTagging)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteObjectTagging,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteObjectTaggingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_220 = &_input.bucket;
            let input_220 =
                input_220
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_220, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            let input_221 = &_input.key;
            let input_221 =
                input_221
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    })?;
            let key = aws_smithy_http::label::fmt_string(input_221, true);
            if key.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "key",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeleteObjectTaggingInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_222) = &_input.expected_bucket_owner {
                let formatted_223 = AsRef::<str>::as_ref(inner_222);
                if !formatted_223.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_223;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::DeleteObjectTaggingInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("tagging");
            if let Some(inner_224) = &_input.version_id {
                query.push_kv("versionId", &aws_smithy_http::query::fmt_string(&inner_224));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteObjectTaggingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteObjectTaggingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteObjectTagging::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteObjectTagging",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteObjectTaggingInput`](crate::input::DeleteObjectTaggingInput)
    pub fn builder() -> crate::input::delete_object_tagging_input::Builder {
        crate::input::delete_object_tagging_input::Builder::default()
    }
}

/// See [`DeletePublicAccessBlockInput`](crate::input::DeletePublicAccessBlockInput)
pub mod delete_public_access_block_input {
    /// A builder for [`DeletePublicAccessBlockInput`](crate::input::DeletePublicAccessBlockInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon S3 bucket whose <code>PublicAccessBlock</code> configuration you want to delete. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket whose <code>PublicAccessBlock</code> configuration you want to delete. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePublicAccessBlockInput`](crate::input::DeletePublicAccessBlockInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePublicAccessBlockInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePublicAccessBlockInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePublicAccessBlockInputOperationOutputAlias =
    crate::operation::DeletePublicAccessBlock;
#[doc(hidden)]
pub type DeletePublicAccessBlockInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeletePublicAccessBlockInput {
    /// Consumes the builder and constructs an Operation<[`DeletePublicAccessBlock`](crate::operation::DeletePublicAccessBlock)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePublicAccessBlock,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeletePublicAccessBlockInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_225 = &_input.bucket;
            let input_225 =
                input_225
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_225, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::DeletePublicAccessBlockInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_226) = &_input.expected_bucket_owner {
                let formatted_227 = AsRef::<str>::as_ref(inner_226);
                if !formatted_227.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_227;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::DeletePublicAccessBlockInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("publicAccessBlock");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeletePublicAccessBlockInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeletePublicAccessBlockInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePublicAccessBlock::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePublicAccessBlock",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeletePublicAccessBlockInput`](crate::input::DeletePublicAccessBlockInput)
    pub fn builder() -> crate::input::delete_public_access_block_input::Builder {
        crate::input::delete_public_access_block_input::Builder::default()
    }
}

/// See [`GetBucketAccelerateConfigurationInput`](crate::input::GetBucketAccelerateConfigurationInput)
pub mod get_bucket_accelerate_configuration_input {
    /// A builder for [`GetBucketAccelerateConfigurationInput`](crate::input::GetBucketAccelerateConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket for which the accelerate configuration is retrieved.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket for which the accelerate configuration is retrieved.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketAccelerateConfigurationInput`](crate::input::GetBucketAccelerateConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketAccelerateConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketAccelerateConfigurationInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketAccelerateConfigurationInputOperationOutputAlias =
    crate::operation::GetBucketAccelerateConfiguration;
#[doc(hidden)]
pub type GetBucketAccelerateConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketAccelerateConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketAccelerateConfiguration`](crate::operation::GetBucketAccelerateConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketAccelerateConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBucketAccelerateConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_228 = &_input.bucket;
            let input_228 =
                input_228
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_228, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetBucketAccelerateConfigurationInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_229) = &_input.expected_bucket_owner {
                let formatted_230 = AsRef::<str>::as_ref(inner_229);
                if !formatted_230.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_230;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::GetBucketAccelerateConfigurationInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("accelerate");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBucketAccelerateConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBucketAccelerateConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketAccelerateConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketAccelerateConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBucketAccelerateConfigurationInput`](crate::input::GetBucketAccelerateConfigurationInput)
    pub fn builder() -> crate::input::get_bucket_accelerate_configuration_input::Builder {
        crate::input::get_bucket_accelerate_configuration_input::Builder::default()
    }
}

/// See [`GetBucketAclInput`](crate::input::GetBucketAclInput)
pub mod get_bucket_acl_input {
    /// A builder for [`GetBucketAclInput`](crate::input::GetBucketAclInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the S3 bucket whose ACL is being requested.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>Specifies the S3 bucket whose ACL is being requested.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketAclInput`](crate::input::GetBucketAclInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketAclInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketAclInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketAclInputOperationOutputAlias = crate::operation::GetBucketAcl;
#[doc(hidden)]
pub type GetBucketAclInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketAclInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketAcl`](crate::operation::GetBucketAcl)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketAcl,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBucketAclInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_231 = &_input.bucket;
            let input_231 =
                input_231
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_231, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetBucketAclInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_232) = &_input.expected_bucket_owner {
                let formatted_233 = AsRef::<str>::as_ref(inner_232);
                if !formatted_233.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_233;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::GetBucketAclInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("acl");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBucketAclInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBucketAclInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketAcl::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketAcl",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBucketAclInput`](crate::input::GetBucketAclInput)
    pub fn builder() -> crate::input::get_bucket_acl_input::Builder {
        crate::input::get_bucket_acl_input::Builder::default()
    }
}

/// See [`GetBucketAnalyticsConfigurationInput`](crate::input::GetBucketAnalyticsConfigurationInput)
pub mod get_bucket_analytics_configuration_input {
    /// A builder for [`GetBucketAnalyticsConfigurationInput`](crate::input::GetBucketAnalyticsConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket from which an analytics configuration is retrieved.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket from which an analytics configuration is retrieved.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The ID that identifies the analytics configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID that identifies the analytics configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketAnalyticsConfigurationInput`](crate::input::GetBucketAnalyticsConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketAnalyticsConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketAnalyticsConfigurationInput {
                bucket: self.bucket,
                id: self.id,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketAnalyticsConfigurationInputOperationOutputAlias =
    crate::operation::GetBucketAnalyticsConfiguration;
#[doc(hidden)]
pub type GetBucketAnalyticsConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketAnalyticsConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketAnalyticsConfiguration`](crate::operation::GetBucketAnalyticsConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketAnalyticsConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBucketAnalyticsConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_234 = &_input.bucket;
            let input_234 =
                input_234
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_234, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetBucketAnalyticsConfigurationInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_235) = &_input.expected_bucket_owner {
                let formatted_236 = AsRef::<str>::as_ref(inner_235);
                if !formatted_236.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_236;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::GetBucketAnalyticsConfigurationInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("analytics");
            query.push_kv("x-id", "GetBucketAnalyticsConfiguration");
            if let Some(inner_237) = &_input.id {
                query.push_kv("id", &aws_smithy_http::query::fmt_string(&inner_237));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBucketAnalyticsConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBucketAnalyticsConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketAnalyticsConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketAnalyticsConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBucketAnalyticsConfigurationInput`](crate::input::GetBucketAnalyticsConfigurationInput)
    pub fn builder() -> crate::input::get_bucket_analytics_configuration_input::Builder {
        crate::input::get_bucket_analytics_configuration_input::Builder::default()
    }
}

/// See [`GetBucketCorsInput`](crate::input::GetBucketCorsInput)
pub mod get_bucket_cors_input {
    /// A builder for [`GetBucketCorsInput`](crate::input::GetBucketCorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name for which to get the cors configuration.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name for which to get the cors configuration.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketCorsInput`](crate::input::GetBucketCorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketCorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketCorsInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketCorsInputOperationOutputAlias = crate::operation::GetBucketCors;
#[doc(hidden)]
pub type GetBucketCorsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketCorsInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketCors`](crate::operation::GetBucketCors)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketCors,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBucketCorsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_238 = &_input.bucket;
            let input_238 =
                input_238
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_238, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetBucketCorsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_239) = &_input.expected_bucket_owner {
                let formatted_240 = AsRef::<str>::as_ref(inner_239);
                if !formatted_240.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_240;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::GetBucketCorsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("cors");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBucketCorsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBucketCorsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketCors::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketCors",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBucketCorsInput`](crate::input::GetBucketCorsInput)
    pub fn builder() -> crate::input::get_bucket_cors_input::Builder {
        crate::input::get_bucket_cors_input::Builder::default()
    }
}

/// See [`GetBucketEncryptionInput`](crate::input::GetBucketEncryptionInput)
pub mod get_bucket_encryption_input {
    /// A builder for [`GetBucketEncryptionInput`](crate::input::GetBucketEncryptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket from which the server-side encryption configuration is retrieved.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket from which the server-side encryption configuration is retrieved.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketEncryptionInput`](crate::input::GetBucketEncryptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketEncryptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketEncryptionInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketEncryptionInputOperationOutputAlias = crate::operation::GetBucketEncryption;
#[doc(hidden)]
pub type GetBucketEncryptionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketEncryptionInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketEncryption`](crate::operation::GetBucketEncryption)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketEncryption,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBucketEncryptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_241 = &_input.bucket;
            let input_241 =
                input_241
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_241, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetBucketEncryptionInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_242) = &_input.expected_bucket_owner {
                let formatted_243 = AsRef::<str>::as_ref(inner_242);
                if !formatted_243.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_243;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::GetBucketEncryptionInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("encryption");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBucketEncryptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBucketEncryptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketEncryption::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketEncryption",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBucketEncryptionInput`](crate::input::GetBucketEncryptionInput)
    pub fn builder() -> crate::input::get_bucket_encryption_input::Builder {
        crate::input::get_bucket_encryption_input::Builder::default()
    }
}

/// See [`GetBucketIntelligentTieringConfigurationInput`](crate::input::GetBucketIntelligentTieringConfigurationInput)
pub mod get_bucket_intelligent_tiering_configuration_input {
    /// A builder for [`GetBucketIntelligentTieringConfigurationInput`](crate::input::GetBucketIntelligentTieringConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon S3 bucket whose configuration you want to modify or retrieve.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket whose configuration you want to modify or retrieve.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketIntelligentTieringConfigurationInput`](crate::input::GetBucketIntelligentTieringConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketIntelligentTieringConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::GetBucketIntelligentTieringConfigurationInput {
                    bucket: self.bucket,
                    id: self.id,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type GetBucketIntelligentTieringConfigurationInputOperationOutputAlias =
    crate::operation::GetBucketIntelligentTieringConfiguration;
#[doc(hidden)]
pub type GetBucketIntelligentTieringConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketIntelligentTieringConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketIntelligentTieringConfiguration`](crate::operation::GetBucketIntelligentTieringConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketIntelligentTieringConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBucketIntelligentTieringConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_244 = &_input.bucket;
            let input_244 =
                input_244
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_244, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetBucketIntelligentTieringConfigurationInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("intelligent-tiering");
            query.push_kv("x-id", "GetBucketIntelligentTieringConfiguration");
            if let Some(inner_245) = &_input.id {
                query.push_kv("id", &aws_smithy_http::query::fmt_string(&inner_245));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBucketIntelligentTieringConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBucketIntelligentTieringConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketIntelligentTieringConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketIntelligentTieringConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBucketIntelligentTieringConfigurationInput`](crate::input::GetBucketIntelligentTieringConfigurationInput)
    pub fn builder() -> crate::input::get_bucket_intelligent_tiering_configuration_input::Builder {
        crate::input::get_bucket_intelligent_tiering_configuration_input::Builder::default()
    }
}

/// See [`GetBucketInventoryConfigurationInput`](crate::input::GetBucketInventoryConfigurationInput)
pub mod get_bucket_inventory_configuration_input {
    /// A builder for [`GetBucketInventoryConfigurationInput`](crate::input::GetBucketInventoryConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket containing the inventory configuration to retrieve.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket containing the inventory configuration to retrieve.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The ID used to identify the inventory configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID used to identify the inventory configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketInventoryConfigurationInput`](crate::input::GetBucketInventoryConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketInventoryConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketInventoryConfigurationInput {
                bucket: self.bucket,
                id: self.id,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketInventoryConfigurationInputOperationOutputAlias =
    crate::operation::GetBucketInventoryConfiguration;
#[doc(hidden)]
pub type GetBucketInventoryConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketInventoryConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketInventoryConfiguration`](crate::operation::GetBucketInventoryConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketInventoryConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBucketInventoryConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_246 = &_input.bucket;
            let input_246 =
                input_246
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_246, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetBucketInventoryConfigurationInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_247) = &_input.expected_bucket_owner {
                let formatted_248 = AsRef::<str>::as_ref(inner_247);
                if !formatted_248.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_248;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::GetBucketInventoryConfigurationInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("inventory");
            query.push_kv("x-id", "GetBucketInventoryConfiguration");
            if let Some(inner_249) = &_input.id {
                query.push_kv("id", &aws_smithy_http::query::fmt_string(&inner_249));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBucketInventoryConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBucketInventoryConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketInventoryConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketInventoryConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBucketInventoryConfigurationInput`](crate::input::GetBucketInventoryConfigurationInput)
    pub fn builder() -> crate::input::get_bucket_inventory_configuration_input::Builder {
        crate::input::get_bucket_inventory_configuration_input::Builder::default()
    }
}

/// See [`GetBucketLifecycleConfigurationInput`](crate::input::GetBucketLifecycleConfigurationInput)
pub mod get_bucket_lifecycle_configuration_input {
    /// A builder for [`GetBucketLifecycleConfigurationInput`](crate::input::GetBucketLifecycleConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket for which to get the lifecycle information.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket for which to get the lifecycle information.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketLifecycleConfigurationInput`](crate::input::GetBucketLifecycleConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketLifecycleConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketLifecycleConfigurationInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketLifecycleConfigurationInputOperationOutputAlias =
    crate::operation::GetBucketLifecycleConfiguration;
#[doc(hidden)]
pub type GetBucketLifecycleConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketLifecycleConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketLifecycleConfiguration`](crate::operation::GetBucketLifecycleConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketLifecycleConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBucketLifecycleConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_250 = &_input.bucket;
            let input_250 =
                input_250
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_250, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetBucketLifecycleConfigurationInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_251) = &_input.expected_bucket_owner {
                let formatted_252 = AsRef::<str>::as_ref(inner_251);
                if !formatted_252.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_252;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::GetBucketLifecycleConfigurationInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("lifecycle");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBucketLifecycleConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBucketLifecycleConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketLifecycleConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketLifecycleConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBucketLifecycleConfigurationInput`](crate::input::GetBucketLifecycleConfigurationInput)
    pub fn builder() -> crate::input::get_bucket_lifecycle_configuration_input::Builder {
        crate::input::get_bucket_lifecycle_configuration_input::Builder::default()
    }
}

/// See [`GetBucketLocationInput`](crate::input::GetBucketLocationInput)
pub mod get_bucket_location_input {
    /// A builder for [`GetBucketLocationInput`](crate::input::GetBucketLocationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket for which to get the location.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket for which to get the location.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketLocationInput`](crate::input::GetBucketLocationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketLocationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketLocationInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketLocationInputOperationOutputAlias = crate::operation::GetBucketLocation;
#[doc(hidden)]
pub type GetBucketLocationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketLocationInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketLocation`](crate::operation::GetBucketLocation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketLocation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBucketLocationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_253 = &_input.bucket;
            let input_253 =
                input_253
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_253, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetBucketLocationInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_254) = &_input.expected_bucket_owner {
                let formatted_255 = AsRef::<str>::as_ref(inner_254);
                if !formatted_255.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_255;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::GetBucketLocationInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("location");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBucketLocationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBucketLocationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketLocation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketLocation",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBucketLocationInput`](crate::input::GetBucketLocationInput)
    pub fn builder() -> crate::input::get_bucket_location_input::Builder {
        crate::input::get_bucket_location_input::Builder::default()
    }
}

/// See [`GetBucketLoggingInput`](crate::input::GetBucketLoggingInput)
pub mod get_bucket_logging_input {
    /// A builder for [`GetBucketLoggingInput`](crate::input::GetBucketLoggingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name for which to get the logging information.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name for which to get the logging information.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketLoggingInput`](crate::input::GetBucketLoggingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketLoggingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketLoggingInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketLoggingInputOperationOutputAlias = crate::operation::GetBucketLogging;
#[doc(hidden)]
pub type GetBucketLoggingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketLoggingInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketLogging`](crate::operation::GetBucketLogging)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketLogging,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBucketLoggingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_256 = &_input.bucket;
            let input_256 =
                input_256
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_256, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetBucketLoggingInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_257) = &_input.expected_bucket_owner {
                let formatted_258 = AsRef::<str>::as_ref(inner_257);
                if !formatted_258.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_258;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::GetBucketLoggingInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("logging");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBucketLoggingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBucketLoggingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketLogging::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketLogging",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBucketLoggingInput`](crate::input::GetBucketLoggingInput)
    pub fn builder() -> crate::input::get_bucket_logging_input::Builder {
        crate::input::get_bucket_logging_input::Builder::default()
    }
}

/// See [`GetBucketMetricsConfigurationInput`](crate::input::GetBucketMetricsConfigurationInput)
pub mod get_bucket_metrics_configuration_input {
    /// A builder for [`GetBucketMetricsConfigurationInput`](crate::input::GetBucketMetricsConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket containing the metrics configuration to retrieve.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket containing the metrics configuration to retrieve.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The ID used to identify the metrics configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID used to identify the metrics configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketMetricsConfigurationInput`](crate::input::GetBucketMetricsConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketMetricsConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketMetricsConfigurationInput {
                bucket: self.bucket,
                id: self.id,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketMetricsConfigurationInputOperationOutputAlias =
    crate::operation::GetBucketMetricsConfiguration;
#[doc(hidden)]
pub type GetBucketMetricsConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketMetricsConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketMetricsConfiguration`](crate::operation::GetBucketMetricsConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketMetricsConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBucketMetricsConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_259 = &_input.bucket;
            let input_259 =
                input_259
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_259, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetBucketMetricsConfigurationInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_260) = &_input.expected_bucket_owner {
                let formatted_261 = AsRef::<str>::as_ref(inner_260);
                if !formatted_261.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_261;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::GetBucketMetricsConfigurationInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("metrics");
            query.push_kv("x-id", "GetBucketMetricsConfiguration");
            if let Some(inner_262) = &_input.id {
                query.push_kv("id", &aws_smithy_http::query::fmt_string(&inner_262));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBucketMetricsConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBucketMetricsConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketMetricsConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketMetricsConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBucketMetricsConfigurationInput`](crate::input::GetBucketMetricsConfigurationInput)
    pub fn builder() -> crate::input::get_bucket_metrics_configuration_input::Builder {
        crate::input::get_bucket_metrics_configuration_input::Builder::default()
    }
}

/// See [`GetBucketNotificationConfigurationInput`](crate::input::GetBucketNotificationConfigurationInput)
pub mod get_bucket_notification_configuration_input {
    /// A builder for [`GetBucketNotificationConfigurationInput`](crate::input::GetBucketNotificationConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket for which to get the notification configuration.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket for which to get the notification configuration.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketNotificationConfigurationInput`](crate::input::GetBucketNotificationConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketNotificationConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketNotificationConfigurationInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketNotificationConfigurationInputOperationOutputAlias =
    crate::operation::GetBucketNotificationConfiguration;
#[doc(hidden)]
pub type GetBucketNotificationConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketNotificationConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketNotificationConfiguration`](crate::operation::GetBucketNotificationConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketNotificationConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBucketNotificationConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_263 = &_input.bucket;
            let input_263 =
                input_263
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_263, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetBucketNotificationConfigurationInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_264) = &_input.expected_bucket_owner {
                let formatted_265 = AsRef::<str>::as_ref(inner_264);
                if !formatted_265.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_265;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::GetBucketNotificationConfigurationInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("notification");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBucketNotificationConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBucketNotificationConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketNotificationConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketNotificationConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBucketNotificationConfigurationInput`](crate::input::GetBucketNotificationConfigurationInput)
    pub fn builder() -> crate::input::get_bucket_notification_configuration_input::Builder {
        crate::input::get_bucket_notification_configuration_input::Builder::default()
    }
}

/// See [`GetBucketOwnershipControlsInput`](crate::input::GetBucketOwnershipControlsInput)
pub mod get_bucket_ownership_controls_input {
    /// A builder for [`GetBucketOwnershipControlsInput`](crate::input::GetBucketOwnershipControlsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon S3 bucket whose <code>OwnershipControls</code> you want to retrieve. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket whose <code>OwnershipControls</code> you want to retrieve. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketOwnershipControlsInput`](crate::input::GetBucketOwnershipControlsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketOwnershipControlsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketOwnershipControlsInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketOwnershipControlsInputOperationOutputAlias =
    crate::operation::GetBucketOwnershipControls;
#[doc(hidden)]
pub type GetBucketOwnershipControlsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketOwnershipControlsInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketOwnershipControls`](crate::operation::GetBucketOwnershipControls)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketOwnershipControls,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBucketOwnershipControlsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_266 = &_input.bucket;
            let input_266 =
                input_266
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_266, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetBucketOwnershipControlsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_267) = &_input.expected_bucket_owner {
                let formatted_268 = AsRef::<str>::as_ref(inner_267);
                if !formatted_268.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_268;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::GetBucketOwnershipControlsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("ownershipControls");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBucketOwnershipControlsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBucketOwnershipControlsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketOwnershipControls::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketOwnershipControls",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBucketOwnershipControlsInput`](crate::input::GetBucketOwnershipControlsInput)
    pub fn builder() -> crate::input::get_bucket_ownership_controls_input::Builder {
        crate::input::get_bucket_ownership_controls_input::Builder::default()
    }
}

/// See [`GetBucketPolicyInput`](crate::input::GetBucketPolicyInput)
pub mod get_bucket_policy_input {
    /// A builder for [`GetBucketPolicyInput`](crate::input::GetBucketPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name for which to get the bucket policy.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name for which to get the bucket policy.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketPolicyInput`](crate::input::GetBucketPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketPolicyInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketPolicyInputOperationOutputAlias = crate::operation::GetBucketPolicy;
#[doc(hidden)]
pub type GetBucketPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketPolicy`](crate::operation::GetBucketPolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBucketPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_269 = &_input.bucket;
            let input_269 =
                input_269
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_269, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetBucketPolicyInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_270) = &_input.expected_bucket_owner {
                let formatted_271 = AsRef::<str>::as_ref(inner_270);
                if !formatted_271.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_271;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::GetBucketPolicyInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("policy");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBucketPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBucketPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketPolicy",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBucketPolicyInput`](crate::input::GetBucketPolicyInput)
    pub fn builder() -> crate::input::get_bucket_policy_input::Builder {
        crate::input::get_bucket_policy_input::Builder::default()
    }
}

/// See [`GetBucketPolicyStatusInput`](crate::input::GetBucketPolicyStatusInput)
pub mod get_bucket_policy_status_input {
    /// A builder for [`GetBucketPolicyStatusInput`](crate::input::GetBucketPolicyStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon S3 bucket whose policy status you want to retrieve.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket whose policy status you want to retrieve.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketPolicyStatusInput`](crate::input::GetBucketPolicyStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketPolicyStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketPolicyStatusInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketPolicyStatusInputOperationOutputAlias = crate::operation::GetBucketPolicyStatus;
#[doc(hidden)]
pub type GetBucketPolicyStatusInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketPolicyStatusInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketPolicyStatus`](crate::operation::GetBucketPolicyStatus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketPolicyStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBucketPolicyStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_272 = &_input.bucket;
            let input_272 =
                input_272
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_272, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetBucketPolicyStatusInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_273) = &_input.expected_bucket_owner {
                let formatted_274 = AsRef::<str>::as_ref(inner_273);
                if !formatted_274.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_274;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::GetBucketPolicyStatusInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("policyStatus");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBucketPolicyStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBucketPolicyStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketPolicyStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketPolicyStatus",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBucketPolicyStatusInput`](crate::input::GetBucketPolicyStatusInput)
    pub fn builder() -> crate::input::get_bucket_policy_status_input::Builder {
        crate::input::get_bucket_policy_status_input::Builder::default()
    }
}

/// See [`GetBucketReplicationInput`](crate::input::GetBucketReplicationInput)
pub mod get_bucket_replication_input {
    /// A builder for [`GetBucketReplicationInput`](crate::input::GetBucketReplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name for which to get the replication information.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name for which to get the replication information.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketReplicationInput`](crate::input::GetBucketReplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketReplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketReplicationInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketReplicationInputOperationOutputAlias = crate::operation::GetBucketReplication;
#[doc(hidden)]
pub type GetBucketReplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketReplicationInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketReplication`](crate::operation::GetBucketReplication)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketReplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBucketReplicationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_275 = &_input.bucket;
            let input_275 =
                input_275
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_275, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetBucketReplicationInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_276) = &_input.expected_bucket_owner {
                let formatted_277 = AsRef::<str>::as_ref(inner_276);
                if !formatted_277.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_277;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::GetBucketReplicationInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("replication");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBucketReplicationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBucketReplicationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketReplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketReplication",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBucketReplicationInput`](crate::input::GetBucketReplicationInput)
    pub fn builder() -> crate::input::get_bucket_replication_input::Builder {
        crate::input::get_bucket_replication_input::Builder::default()
    }
}

/// See [`GetBucketRequestPaymentInput`](crate::input::GetBucketRequestPaymentInput)
pub mod get_bucket_request_payment_input {
    /// A builder for [`GetBucketRequestPaymentInput`](crate::input::GetBucketRequestPaymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket for which to get the payment request configuration</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket for which to get the payment request configuration</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketRequestPaymentInput`](crate::input::GetBucketRequestPaymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketRequestPaymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketRequestPaymentInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketRequestPaymentInputOperationOutputAlias =
    crate::operation::GetBucketRequestPayment;
#[doc(hidden)]
pub type GetBucketRequestPaymentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketRequestPaymentInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketRequestPayment`](crate::operation::GetBucketRequestPayment)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketRequestPayment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBucketRequestPaymentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_278 = &_input.bucket;
            let input_278 =
                input_278
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_278, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetBucketRequestPaymentInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_279) = &_input.expected_bucket_owner {
                let formatted_280 = AsRef::<str>::as_ref(inner_279);
                if !formatted_280.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_280;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::GetBucketRequestPaymentInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("requestPayment");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBucketRequestPaymentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBucketRequestPaymentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketRequestPayment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketRequestPayment",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBucketRequestPaymentInput`](crate::input::GetBucketRequestPaymentInput)
    pub fn builder() -> crate::input::get_bucket_request_payment_input::Builder {
        crate::input::get_bucket_request_payment_input::Builder::default()
    }
}

/// See [`GetBucketTaggingInput`](crate::input::GetBucketTaggingInput)
pub mod get_bucket_tagging_input {
    /// A builder for [`GetBucketTaggingInput`](crate::input::GetBucketTaggingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket for which to get the tagging information.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket for which to get the tagging information.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketTaggingInput`](crate::input::GetBucketTaggingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketTaggingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketTaggingInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketTaggingInputOperationOutputAlias = crate::operation::GetBucketTagging;
#[doc(hidden)]
pub type GetBucketTaggingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketTaggingInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketTagging`](crate::operation::GetBucketTagging)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketTagging,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBucketTaggingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_281 = &_input.bucket;
            let input_281 =
                input_281
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_281, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetBucketTaggingInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_282) = &_input.expected_bucket_owner {
                let formatted_283 = AsRef::<str>::as_ref(inner_282);
                if !formatted_283.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_283;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::GetBucketTaggingInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("tagging");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBucketTaggingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBucketTaggingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketTagging::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketTagging",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBucketTaggingInput`](crate::input::GetBucketTaggingInput)
    pub fn builder() -> crate::input::get_bucket_tagging_input::Builder {
        crate::input::get_bucket_tagging_input::Builder::default()
    }
}

/// See [`GetBucketVersioningInput`](crate::input::GetBucketVersioningInput)
pub mod get_bucket_versioning_input {
    /// A builder for [`GetBucketVersioningInput`](crate::input::GetBucketVersioningInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket for which to get the versioning information.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket for which to get the versioning information.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketVersioningInput`](crate::input::GetBucketVersioningInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketVersioningInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketVersioningInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketVersioningInputOperationOutputAlias = crate::operation::GetBucketVersioning;
#[doc(hidden)]
pub type GetBucketVersioningInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketVersioningInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketVersioning`](crate::operation::GetBucketVersioning)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketVersioning,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBucketVersioningInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_284 = &_input.bucket;
            let input_284 =
                input_284
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_284, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetBucketVersioningInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_285) = &_input.expected_bucket_owner {
                let formatted_286 = AsRef::<str>::as_ref(inner_285);
                if !formatted_286.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_286;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::GetBucketVersioningInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("versioning");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBucketVersioningInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBucketVersioningInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketVersioning::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketVersioning",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBucketVersioningInput`](crate::input::GetBucketVersioningInput)
    pub fn builder() -> crate::input::get_bucket_versioning_input::Builder {
        crate::input::get_bucket_versioning_input::Builder::default()
    }
}

/// See [`GetBucketWebsiteInput`](crate::input::GetBucketWebsiteInput)
pub mod get_bucket_website_input {
    /// A builder for [`GetBucketWebsiteInput`](crate::input::GetBucketWebsiteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name for which to get the website configuration.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name for which to get the website configuration.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketWebsiteInput`](crate::input::GetBucketWebsiteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketWebsiteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketWebsiteInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketWebsiteInputOperationOutputAlias = crate::operation::GetBucketWebsite;
#[doc(hidden)]
pub type GetBucketWebsiteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketWebsiteInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketWebsite`](crate::operation::GetBucketWebsite)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketWebsite,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBucketWebsiteInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_287 = &_input.bucket;
            let input_287 =
                input_287
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_287, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetBucketWebsiteInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_288) = &_input.expected_bucket_owner {
                let formatted_289 = AsRef::<str>::as_ref(inner_288);
                if !formatted_289.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_289;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::GetBucketWebsiteInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("website");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBucketWebsiteInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBucketWebsiteInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketWebsite::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketWebsite",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBucketWebsiteInput`](crate::input::GetBucketWebsiteInput)
    pub fn builder() -> crate::input::get_bucket_website_input::Builder {
        crate::input::get_bucket_website_input::Builder::default()
    }
}

/// See [`GetObjectInput`](crate::input::GetObjectInput)
pub mod get_object_input {
    /// A builder for [`GetObjectInput`](crate::input::GetObjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) if_match: std::option::Option<std::string::String>,
        pub(crate) if_modified_since: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) if_none_match: std::option::Option<std::string::String>,
        pub(crate) if_unmodified_since: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) range: std::option::Option<std::string::String>,
        pub(crate) response_cache_control: std::option::Option<std::string::String>,
        pub(crate) response_content_disposition: std::option::Option<std::string::String>,
        pub(crate) response_content_encoding: std::option::Option<std::string::String>,
        pub(crate) response_content_language: std::option::Option<std::string::String>,
        pub(crate) response_content_type: std::option::Option<std::string::String>,
        pub(crate) response_expires: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) sse_customer_algorithm: std::option::Option<std::string::String>,
        pub(crate) sse_customer_key: std::option::Option<std::string::String>,
        pub(crate) sse_customer_key_md5: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) part_number: std::option::Option<i32>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name containing the object. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using an Object Lambda access point the hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-object-lambda.<i>Region</i>.amazonaws.com.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name containing the object. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using an Object Lambda access point the hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-object-lambda.<i>Region</i>.amazonaws.com.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Return the object only if its entity tag (ETag) is the same as the one specified, otherwise return a 412 (precondition failed).</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_match = Some(input.into());
            self
        }
        /// <p>Return the object only if its entity tag (ETag) is the same as the one specified, otherwise return a 412 (precondition failed).</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.if_match = input;
            self
        }
        /// <p>Return the object only if it has been modified since the specified time, otherwise return a 304 (not modified).</p>
        pub fn if_modified_since(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.if_modified_since = Some(input);
            self
        }
        /// <p>Return the object only if it has been modified since the specified time, otherwise return a 304 (not modified).</p>
        pub fn set_if_modified_since(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.if_modified_since = input;
            self
        }
        /// <p>Return the object only if its entity tag (ETag) is different from the one specified, otherwise return a 304 (not modified).</p>
        pub fn if_none_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_none_match = Some(input.into());
            self
        }
        /// <p>Return the object only if its entity tag (ETag) is different from the one specified, otherwise return a 304 (not modified).</p>
        pub fn set_if_none_match(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.if_none_match = input;
            self
        }
        /// <p>Return the object only if it has not been modified since the specified time, otherwise return a 412 (precondition failed).</p>
        pub fn if_unmodified_since(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.if_unmodified_since = Some(input);
            self
        }
        /// <p>Return the object only if it has not been modified since the specified time, otherwise return a 412 (precondition failed).</p>
        pub fn set_if_unmodified_since(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.if_unmodified_since = input;
            self
        }
        /// <p>Key of the object to get.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Key of the object to get.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Downloads the specified range bytes of an object. For more information about the HTTP Range header, see <a href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35">https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35</a>.</p> <note>
        /// <p>Amazon S3 doesn't support retrieving multiple ranges of data per <code>GET</code> request.</p>
        /// </note>
        pub fn range(mut self, input: impl Into<std::string::String>) -> Self {
            self.range = Some(input.into());
            self
        }
        /// <p>Downloads the specified range bytes of an object. For more information about the HTTP Range header, see <a href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35">https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35</a>.</p> <note>
        /// <p>Amazon S3 doesn't support retrieving multiple ranges of data per <code>GET</code> request.</p>
        /// </note>
        pub fn set_range(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.range = input;
            self
        }
        /// <p>Sets the <code>Cache-Control</code> header of the response.</p>
        pub fn response_cache_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.response_cache_control = Some(input.into());
            self
        }
        /// <p>Sets the <code>Cache-Control</code> header of the response.</p>
        pub fn set_response_cache_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.response_cache_control = input;
            self
        }
        /// <p>Sets the <code>Content-Disposition</code> header of the response</p>
        pub fn response_content_disposition(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.response_content_disposition = Some(input.into());
            self
        }
        /// <p>Sets the <code>Content-Disposition</code> header of the response</p>
        pub fn set_response_content_disposition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.response_content_disposition = input;
            self
        }
        /// <p>Sets the <code>Content-Encoding</code> header of the response.</p>
        pub fn response_content_encoding(mut self, input: impl Into<std::string::String>) -> Self {
            self.response_content_encoding = Some(input.into());
            self
        }
        /// <p>Sets the <code>Content-Encoding</code> header of the response.</p>
        pub fn set_response_content_encoding(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.response_content_encoding = input;
            self
        }
        /// <p>Sets the <code>Content-Language</code> header of the response.</p>
        pub fn response_content_language(mut self, input: impl Into<std::string::String>) -> Self {
            self.response_content_language = Some(input.into());
            self
        }
        /// <p>Sets the <code>Content-Language</code> header of the response.</p>
        pub fn set_response_content_language(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.response_content_language = input;
            self
        }
        /// <p>Sets the <code>Content-Type</code> header of the response.</p>
        pub fn response_content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.response_content_type = Some(input.into());
            self
        }
        /// <p>Sets the <code>Content-Type</code> header of the response.</p>
        pub fn set_response_content_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.response_content_type = input;
            self
        }
        /// <p>Sets the <code>Expires</code> header of the response.</p>
        pub fn response_expires(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.response_expires = Some(input);
            self
        }
        /// <p>Sets the <code>Expires</code> header of the response.</p>
        pub fn set_response_expires(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.response_expires = input;
            self
        }
        /// <p>VersionId used to reference a specific version of the object.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>VersionId used to reference a specific version of the object.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>Specifies the algorithm to use to when decrypting the object (for example, AES256).</p>
        pub fn sse_customer_algorithm(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_algorithm = Some(input.into());
            self
        }
        /// <p>Specifies the algorithm to use to when decrypting the object (for example, AES256).</p>
        pub fn set_sse_customer_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_algorithm = input;
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 used to encrypt the data. This value is used to decrypt the object when recovering it and must match the one used when storing the data. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
        pub fn sse_customer_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_key = Some(input.into());
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 used to encrypt the data. This value is used to decrypt the object when recovering it and must match the one used when storing the data. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
        pub fn set_sse_customer_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_key = input;
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn sse_customer_key_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_key_md5 = Some(input.into());
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn set_sse_customer_key_md5(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_key_md5 = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a 'ranged' GET request for the part specified. Useful for downloading just a part of an object.</p>
        pub fn part_number(mut self, input: i32) -> Self {
            self.part_number = Some(input);
            self
        }
        /// <p>Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a 'ranged' GET request for the part specified. Useful for downloading just a part of an object.</p>
        pub fn set_part_number(mut self, input: std::option::Option<i32>) -> Self {
            self.part_number = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetObjectInput`](crate::input::GetObjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetObjectInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetObjectInput {
                bucket: self.bucket,
                if_match: self.if_match,
                if_modified_since: self.if_modified_since,
                if_none_match: self.if_none_match,
                if_unmodified_since: self.if_unmodified_since,
                key: self.key,
                range: self.range,
                response_cache_control: self.response_cache_control,
                response_content_disposition: self.response_content_disposition,
                response_content_encoding: self.response_content_encoding,
                response_content_language: self.response_content_language,
                response_content_type: self.response_content_type,
                response_expires: self.response_expires,
                version_id: self.version_id,
                sse_customer_algorithm: self.sse_customer_algorithm,
                sse_customer_key: self.sse_customer_key,
                sse_customer_key_md5: self.sse_customer_key_md5,
                request_payer: self.request_payer,
                part_number: self.part_number.unwrap_or_default(),
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetObjectInputOperationOutputAlias = crate::operation::GetObject;
#[doc(hidden)]
pub type GetObjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetObjectInput {
    ///
    /// Creates a presigned request for this operation.
    ///
    /// The credentials provider from the `config` will be used to generate the request's signature.
    /// The `presigning_config` provides additional presigning-specific config values, such as the
    /// amount of time the request should be valid for after creation.
    ///
    /// Presigned requests can be given to other users or applications to access a resource or perform
    /// an operation without having access to the AWS security credentials.
    ///
    pub async fn presigned(
        self,
        config: &crate::config::Config,
        presigning_config: crate::presigning::config::PresigningConfig,
    ) -> Result<
        crate::presigning::request::PresignedRequest,
        aws_smithy_http::result::SdkError<crate::error::GetObjectError>,
    > {
        let (mut request, _) = self
            .make_operation(config)
            .await
            .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
            .into_request_response();
        {
            // Change signature type to query params and wire up presigning config
            let mut props = request.properties_mut();
            props.insert(presigning_config.start_time());
            props.insert(aws_sigv4::http_request::SignableBody::UnsignedPayload);
            let mut config = props
                .get_mut::<aws_sig_auth::signer::OperationSigningConfig>()
                .expect("signing config added by make_operation()");
            config.signature_type = aws_sig_auth::signer::HttpSignatureType::HttpRequestQueryParams;
            config.expires_in = Some(presigning_config.expires());
        }
        let middleware = crate::middleware::DefaultMiddleware::default();
        let mut svc = tower::builder::ServiceBuilder::new()
            .layer(&middleware)
            .service(crate::presigning::service::PresignedRequestService::new());

        use tower::{Service, ServiceExt};
        Ok(svc.ready().await?.call(request).await?)
    }
    /// Consumes the builder and constructs an Operation<[`GetObject`](crate::operation::GetObject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetObject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetObjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_290 = &_input.bucket;
            let input_290 =
                input_290
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_290, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            let input_291 = &_input.key;
            let input_291 =
                input_291
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    })?;
            let key = aws_smithy_http::label::fmt_string(input_291, true);
            if key.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "key",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetObjectInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_292) = &_input.if_match {
                let formatted_293 = AsRef::<str>::as_ref(inner_292);
                if !formatted_293.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_293;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "if_match",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("If-Match", header_value);
                }
            }
            if let Some(inner_294) = &_input.if_modified_since {
                let formatted_295 = inner_294.fmt(aws_smithy_types::date_time::Format::HttpDate)?;
                if !formatted_295.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_295;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "if_modified_since",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("If-Modified-Since", header_value);
                }
            }
            if let Some(inner_296) = &_input.if_none_match {
                let formatted_297 = AsRef::<str>::as_ref(inner_296);
                if !formatted_297.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_297;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "if_none_match",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("If-None-Match", header_value);
                }
            }
            if let Some(inner_298) = &_input.if_unmodified_since {
                let formatted_299 = inner_298.fmt(aws_smithy_types::date_time::Format::HttpDate)?;
                if !formatted_299.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_299;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "if_unmodified_since",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("If-Unmodified-Since", header_value);
                }
            }
            if let Some(inner_300) = &_input.range {
                let formatted_301 = AsRef::<str>::as_ref(inner_300);
                if !formatted_301.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_301;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "range",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Range", header_value);
                }
            }
            if let Some(inner_302) = &_input.sse_customer_algorithm {
                let formatted_303 = AsRef::<str>::as_ref(inner_302);
                if !formatted_303.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_303;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "sse_customer_algorithm",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header(
                        "x-amz-server-side-encryption-customer-algorithm",
                        header_value,
                    );
                }
            }
            if let Some(inner_304) = &_input.sse_customer_key {
                let formatted_305 = AsRef::<str>::as_ref(inner_304);
                if !formatted_305.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_305;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "sse_customer_key",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder =
                        builder.header("x-amz-server-side-encryption-customer-key", header_value);
                }
            }
            if let Some(inner_306) = &_input.sse_customer_key_md5 {
                let formatted_307 = AsRef::<str>::as_ref(inner_306);
                if !formatted_307.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_307;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "sse_customer_key_md5",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header(
                        "x-amz-server-side-encryption-customer-key-MD5",
                        header_value,
                    );
                }
            }
            if let Some(inner_308) = &_input.request_payer {
                let formatted_309 = AsRef::<str>::as_ref(inner_308);
                if !formatted_309.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_309;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "request_payer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-request-payer", header_value);
                }
            }
            if let Some(inner_310) = &_input.expected_bucket_owner {
                let formatted_311 = AsRef::<str>::as_ref(inner_310);
                if !formatted_311.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_311;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::GetObjectInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("x-id", "GetObject");
            if let Some(inner_312) = &_input.response_cache_control {
                query.push_kv(
                    "response-cache-control",
                    &aws_smithy_http::query::fmt_string(&inner_312),
                );
            }
            if let Some(inner_313) = &_input.response_content_disposition {
                query.push_kv(
                    "response-content-disposition",
                    &aws_smithy_http::query::fmt_string(&inner_313),
                );
            }
            if let Some(inner_314) = &_input.response_content_encoding {
                query.push_kv(
                    "response-content-encoding",
                    &aws_smithy_http::query::fmt_string(&inner_314),
                );
            }
            if let Some(inner_315) = &_input.response_content_language {
                query.push_kv(
                    "response-content-language",
                    &aws_smithy_http::query::fmt_string(&inner_315),
                );
            }
            if let Some(inner_316) = &_input.response_content_type {
                query.push_kv(
                    "response-content-type",
                    &aws_smithy_http::query::fmt_string(&inner_316),
                );
            }
            if let Some(inner_317) = &_input.response_expires {
                query.push_kv(
                    "response-expires",
                    &aws_smithy_http::query::fmt_timestamp(
                        inner_317,
                        aws_smithy_types::date_time::Format::HttpDate,
                    )?,
                );
            }
            if let Some(inner_318) = &_input.version_id {
                query.push_kv("versionId", &aws_smithy_http::query::fmt_string(&inner_318));
            }
            if _input.part_number != 0 {
                query.push_kv(
                    "partNumber",
                    aws_smithy_types::primitive::Encoder::from(_input.part_number).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetObjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetObjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetObject::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new("GetObject", "s3"));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetObjectInput`](crate::input::GetObjectInput)
    pub fn builder() -> crate::input::get_object_input::Builder {
        crate::input::get_object_input::Builder::default()
    }
}

/// See [`GetObjectAclInput`](crate::input::GetObjectAclInput)
pub mod get_object_acl_input {
    /// A builder for [`GetObjectAclInput`](crate::input::GetObjectAclInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name that contains the object for which to get the ACL information. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name that contains the object for which to get the ACL information. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The key of the object for which to get the ACL information.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of the object for which to get the ACL information.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>VersionId used to reference a specific version of the object.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>VersionId used to reference a specific version of the object.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetObjectAclInput`](crate::input::GetObjectAclInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetObjectAclInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetObjectAclInput {
                bucket: self.bucket,
                key: self.key,
                version_id: self.version_id,
                request_payer: self.request_payer,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetObjectAclInputOperationOutputAlias = crate::operation::GetObjectAcl;
#[doc(hidden)]
pub type GetObjectAclInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetObjectAclInput {
    /// Consumes the builder and constructs an Operation<[`GetObjectAcl`](crate::operation::GetObjectAcl)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetObjectAcl,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetObjectAclInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_319 = &_input.bucket;
            let input_319 =
                input_319
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_319, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            let input_320 = &_input.key;
            let input_320 =
                input_320
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    })?;
            let key = aws_smithy_http::label::fmt_string(input_320, true);
            if key.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "key",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetObjectAclInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_321) = &_input.request_payer {
                let formatted_322 = AsRef::<str>::as_ref(inner_321);
                if !formatted_322.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_322;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "request_payer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-request-payer", header_value);
                }
            }
            if let Some(inner_323) = &_input.expected_bucket_owner {
                let formatted_324 = AsRef::<str>::as_ref(inner_323);
                if !formatted_324.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_324;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::GetObjectAclInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("acl");
            if let Some(inner_325) = &_input.version_id {
                query.push_kv("versionId", &aws_smithy_http::query::fmt_string(&inner_325));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetObjectAclInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetObjectAclInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetObjectAcl::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetObjectAcl",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetObjectAclInput`](crate::input::GetObjectAclInput)
    pub fn builder() -> crate::input::get_object_acl_input::Builder {
        crate::input::get_object_acl_input::Builder::default()
    }
}

/// See [`GetObjectLegalHoldInput`](crate::input::GetObjectLegalHoldInput)
pub mod get_object_legal_hold_input {
    /// A builder for [`GetObjectLegalHoldInput`](crate::input::GetObjectLegalHoldInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name containing the object whose Legal Hold status you want to retrieve. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name containing the object whose Legal Hold status you want to retrieve. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The key name for the object whose Legal Hold status you want to retrieve.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key name for the object whose Legal Hold status you want to retrieve.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The version ID of the object whose Legal Hold status you want to retrieve.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The version ID of the object whose Legal Hold status you want to retrieve.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetObjectLegalHoldInput`](crate::input::GetObjectLegalHoldInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetObjectLegalHoldInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetObjectLegalHoldInput {
                bucket: self.bucket,
                key: self.key,
                version_id: self.version_id,
                request_payer: self.request_payer,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetObjectLegalHoldInputOperationOutputAlias = crate::operation::GetObjectLegalHold;
#[doc(hidden)]
pub type GetObjectLegalHoldInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetObjectLegalHoldInput {
    /// Consumes the builder and constructs an Operation<[`GetObjectLegalHold`](crate::operation::GetObjectLegalHold)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetObjectLegalHold,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetObjectLegalHoldInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_326 = &_input.bucket;
            let input_326 =
                input_326
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_326, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            let input_327 = &_input.key;
            let input_327 =
                input_327
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    })?;
            let key = aws_smithy_http::label::fmt_string(input_327, true);
            if key.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "key",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetObjectLegalHoldInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_328) = &_input.request_payer {
                let formatted_329 = AsRef::<str>::as_ref(inner_328);
                if !formatted_329.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_329;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "request_payer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-request-payer", header_value);
                }
            }
            if let Some(inner_330) = &_input.expected_bucket_owner {
                let formatted_331 = AsRef::<str>::as_ref(inner_330);
                if !formatted_331.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_331;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::GetObjectLegalHoldInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("legal-hold");
            if let Some(inner_332) = &_input.version_id {
                query.push_kv("versionId", &aws_smithy_http::query::fmt_string(&inner_332));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetObjectLegalHoldInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetObjectLegalHoldInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetObjectLegalHold::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetObjectLegalHold",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetObjectLegalHoldInput`](crate::input::GetObjectLegalHoldInput)
    pub fn builder() -> crate::input::get_object_legal_hold_input::Builder {
        crate::input::get_object_legal_hold_input::Builder::default()
    }
}

/// See [`GetObjectLockConfigurationInput`](crate::input::GetObjectLockConfigurationInput)
pub mod get_object_lock_configuration_input {
    /// A builder for [`GetObjectLockConfigurationInput`](crate::input::GetObjectLockConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket whose Object Lock configuration you want to retrieve.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket whose Object Lock configuration you want to retrieve.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetObjectLockConfigurationInput`](crate::input::GetObjectLockConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetObjectLockConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetObjectLockConfigurationInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetObjectLockConfigurationInputOperationOutputAlias =
    crate::operation::GetObjectLockConfiguration;
#[doc(hidden)]
pub type GetObjectLockConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetObjectLockConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetObjectLockConfiguration`](crate::operation::GetObjectLockConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetObjectLockConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetObjectLockConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_333 = &_input.bucket;
            let input_333 =
                input_333
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_333, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetObjectLockConfigurationInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_334) = &_input.expected_bucket_owner {
                let formatted_335 = AsRef::<str>::as_ref(inner_334);
                if !formatted_335.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_335;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::GetObjectLockConfigurationInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("object-lock");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetObjectLockConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetObjectLockConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetObjectLockConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetObjectLockConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetObjectLockConfigurationInput`](crate::input::GetObjectLockConfigurationInput)
    pub fn builder() -> crate::input::get_object_lock_configuration_input::Builder {
        crate::input::get_object_lock_configuration_input::Builder::default()
    }
}

/// See [`GetObjectRetentionInput`](crate::input::GetObjectRetentionInput)
pub mod get_object_retention_input {
    /// A builder for [`GetObjectRetentionInput`](crate::input::GetObjectRetentionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name containing the object whose retention settings you want to retrieve. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name containing the object whose retention settings you want to retrieve. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The key name for the object whose retention settings you want to retrieve.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key name for the object whose retention settings you want to retrieve.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The version ID for the object whose retention settings you want to retrieve.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The version ID for the object whose retention settings you want to retrieve.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetObjectRetentionInput`](crate::input::GetObjectRetentionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetObjectRetentionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetObjectRetentionInput {
                bucket: self.bucket,
                key: self.key,
                version_id: self.version_id,
                request_payer: self.request_payer,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetObjectRetentionInputOperationOutputAlias = crate::operation::GetObjectRetention;
#[doc(hidden)]
pub type GetObjectRetentionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetObjectRetentionInput {
    /// Consumes the builder and constructs an Operation<[`GetObjectRetention`](crate::operation::GetObjectRetention)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetObjectRetention,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetObjectRetentionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_336 = &_input.bucket;
            let input_336 =
                input_336
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_336, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            let input_337 = &_input.key;
            let input_337 =
                input_337
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    })?;
            let key = aws_smithy_http::label::fmt_string(input_337, true);
            if key.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "key",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetObjectRetentionInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_338) = &_input.request_payer {
                let formatted_339 = AsRef::<str>::as_ref(inner_338);
                if !formatted_339.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_339;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "request_payer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-request-payer", header_value);
                }
            }
            if let Some(inner_340) = &_input.expected_bucket_owner {
                let formatted_341 = AsRef::<str>::as_ref(inner_340);
                if !formatted_341.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_341;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::GetObjectRetentionInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("retention");
            if let Some(inner_342) = &_input.version_id {
                query.push_kv("versionId", &aws_smithy_http::query::fmt_string(&inner_342));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetObjectRetentionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetObjectRetentionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetObjectRetention::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetObjectRetention",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetObjectRetentionInput`](crate::input::GetObjectRetentionInput)
    pub fn builder() -> crate::input::get_object_retention_input::Builder {
        crate::input::get_object_retention_input::Builder::default()
    }
}

/// See [`GetObjectTaggingInput`](crate::input::GetObjectTaggingInput)
pub mod get_object_tagging_input {
    /// A builder for [`GetObjectTaggingInput`](crate::input::GetObjectTaggingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
    }
    impl Builder {
        /// <p>The bucket name containing the object for which to get the tagging information. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name containing the object for which to get the tagging information. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Object key for which to get the tagging information.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Object key for which to get the tagging information.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The versionId of the object for which to get the tagging information.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The versionId of the object for which to get the tagging information.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// Consumes the builder and constructs a [`GetObjectTaggingInput`](crate::input::GetObjectTaggingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetObjectTaggingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetObjectTaggingInput {
                bucket: self.bucket,
                key: self.key,
                version_id: self.version_id,
                expected_bucket_owner: self.expected_bucket_owner,
                request_payer: self.request_payer,
            })
        }
    }
}
#[doc(hidden)]
pub type GetObjectTaggingInputOperationOutputAlias = crate::operation::GetObjectTagging;
#[doc(hidden)]
pub type GetObjectTaggingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetObjectTaggingInput {
    /// Consumes the builder and constructs an Operation<[`GetObjectTagging`](crate::operation::GetObjectTagging)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetObjectTagging,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetObjectTaggingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_343 = &_input.bucket;
            let input_343 =
                input_343
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_343, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            let input_344 = &_input.key;
            let input_344 =
                input_344
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    })?;
            let key = aws_smithy_http::label::fmt_string(input_344, true);
            if key.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "key",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetObjectTaggingInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_345) = &_input.expected_bucket_owner {
                let formatted_346 = AsRef::<str>::as_ref(inner_345);
                if !formatted_346.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_346;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            if let Some(inner_347) = &_input.request_payer {
                let formatted_348 = AsRef::<str>::as_ref(inner_347);
                if !formatted_348.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_348;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "request_payer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-request-payer", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::GetObjectTaggingInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("tagging");
            if let Some(inner_349) = &_input.version_id {
                query.push_kv("versionId", &aws_smithy_http::query::fmt_string(&inner_349));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetObjectTaggingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetObjectTaggingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetObjectTagging::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetObjectTagging",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetObjectTaggingInput`](crate::input::GetObjectTaggingInput)
    pub fn builder() -> crate::input::get_object_tagging_input::Builder {
        crate::input::get_object_tagging_input::Builder::default()
    }
}

/// See [`GetObjectTorrentInput`](crate::input::GetObjectTorrentInput)
pub mod get_object_torrent_input {
    /// A builder for [`GetObjectTorrentInput`](crate::input::GetObjectTorrentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket containing the object for which to get the torrent files.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket containing the object for which to get the torrent files.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The object key for which to get the information.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The object key for which to get the information.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetObjectTorrentInput`](crate::input::GetObjectTorrentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetObjectTorrentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetObjectTorrentInput {
                bucket: self.bucket,
                key: self.key,
                request_payer: self.request_payer,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetObjectTorrentInputOperationOutputAlias = crate::operation::GetObjectTorrent;
#[doc(hidden)]
pub type GetObjectTorrentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetObjectTorrentInput {
    /// Consumes the builder and constructs an Operation<[`GetObjectTorrent`](crate::operation::GetObjectTorrent)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetObjectTorrent,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetObjectTorrentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_350 = &_input.bucket;
            let input_350 =
                input_350
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_350, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            let input_351 = &_input.key;
            let input_351 =
                input_351
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    })?;
            let key = aws_smithy_http::label::fmt_string(input_351, true);
            if key.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "key",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetObjectTorrentInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_352) = &_input.request_payer {
                let formatted_353 = AsRef::<str>::as_ref(inner_352);
                if !formatted_353.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_353;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "request_payer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-request-payer", header_value);
                }
            }
            if let Some(inner_354) = &_input.expected_bucket_owner {
                let formatted_355 = AsRef::<str>::as_ref(inner_354);
                if !formatted_355.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_355;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::GetObjectTorrentInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("torrent");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetObjectTorrentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetObjectTorrentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetObjectTorrent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetObjectTorrent",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetObjectTorrentInput`](crate::input::GetObjectTorrentInput)
    pub fn builder() -> crate::input::get_object_torrent_input::Builder {
        crate::input::get_object_torrent_input::Builder::default()
    }
}

/// See [`GetPublicAccessBlockInput`](crate::input::GetPublicAccessBlockInput)
pub mod get_public_access_block_input {
    /// A builder for [`GetPublicAccessBlockInput`](crate::input::GetPublicAccessBlockInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon S3 bucket whose <code>PublicAccessBlock</code> configuration you want to retrieve. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket whose <code>PublicAccessBlock</code> configuration you want to retrieve. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPublicAccessBlockInput`](crate::input::GetPublicAccessBlockInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPublicAccessBlockInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPublicAccessBlockInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPublicAccessBlockInputOperationOutputAlias = crate::operation::GetPublicAccessBlock;
#[doc(hidden)]
pub type GetPublicAccessBlockInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetPublicAccessBlockInput {
    /// Consumes the builder and constructs an Operation<[`GetPublicAccessBlock`](crate::operation::GetPublicAccessBlock)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPublicAccessBlock,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetPublicAccessBlockInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_356 = &_input.bucket;
            let input_356 =
                input_356
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_356, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::GetPublicAccessBlockInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_357) = &_input.expected_bucket_owner {
                let formatted_358 = AsRef::<str>::as_ref(inner_357);
                if !formatted_358.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_358;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::GetPublicAccessBlockInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("publicAccessBlock");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetPublicAccessBlockInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetPublicAccessBlockInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPublicAccessBlock::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPublicAccessBlock",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetPublicAccessBlockInput`](crate::input::GetPublicAccessBlockInput)
    pub fn builder() -> crate::input::get_public_access_block_input::Builder {
        crate::input::get_public_access_block_input::Builder::default()
    }
}

/// See [`HeadBucketInput`](crate::input::HeadBucketInput)
pub mod head_bucket_input {
    /// A builder for [`HeadBucketInput`](crate::input::HeadBucketInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`HeadBucketInput`](crate::input::HeadBucketInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::HeadBucketInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::HeadBucketInput {
                bucket: self.bucket,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type HeadBucketInputOperationOutputAlias = crate::operation::HeadBucket;
#[doc(hidden)]
pub type HeadBucketInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl HeadBucketInput {
    /// Consumes the builder and constructs an Operation<[`HeadBucket`](crate::operation::HeadBucket)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::HeadBucket,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::HeadBucketInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_359 = &_input.bucket;
            let input_359 =
                input_359
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_359, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::HeadBucketInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_360) = &_input.expected_bucket_owner {
                let formatted_361 = AsRef::<str>::as_ref(inner_360);
                if !formatted_361.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_361;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::HeadBucketInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("HEAD").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::HeadBucketInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::HeadBucket::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "HeadBucket",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`HeadBucketInput`](crate::input::HeadBucketInput)
    pub fn builder() -> crate::input::head_bucket_input::Builder {
        crate::input::head_bucket_input::Builder::default()
    }
}

/// See [`HeadObjectInput`](crate::input::HeadObjectInput)
pub mod head_object_input {
    /// A builder for [`HeadObjectInput`](crate::input::HeadObjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) if_match: std::option::Option<std::string::String>,
        pub(crate) if_modified_since: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) if_none_match: std::option::Option<std::string::String>,
        pub(crate) if_unmodified_since: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) range: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) sse_customer_algorithm: std::option::Option<std::string::String>,
        pub(crate) sse_customer_key: std::option::Option<std::string::String>,
        pub(crate) sse_customer_key_md5: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) part_number: std::option::Option<i32>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket containing the object.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket containing the object.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Return the object only if its entity tag (ETag) is the same as the one specified, otherwise return a 412 (precondition failed).</p>
        pub fn if_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_match = Some(input.into());
            self
        }
        /// <p>Return the object only if its entity tag (ETag) is the same as the one specified, otherwise return a 412 (precondition failed).</p>
        pub fn set_if_match(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.if_match = input;
            self
        }
        /// <p>Return the object only if it has been modified since the specified time, otherwise return a 304 (not modified).</p>
        pub fn if_modified_since(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.if_modified_since = Some(input);
            self
        }
        /// <p>Return the object only if it has been modified since the specified time, otherwise return a 304 (not modified).</p>
        pub fn set_if_modified_since(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.if_modified_since = input;
            self
        }
        /// <p>Return the object only if its entity tag (ETag) is different from the one specified, otherwise return a 304 (not modified).</p>
        pub fn if_none_match(mut self, input: impl Into<std::string::String>) -> Self {
            self.if_none_match = Some(input.into());
            self
        }
        /// <p>Return the object only if its entity tag (ETag) is different from the one specified, otherwise return a 304 (not modified).</p>
        pub fn set_if_none_match(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.if_none_match = input;
            self
        }
        /// <p>Return the object only if it has not been modified since the specified time, otherwise return a 412 (precondition failed).</p>
        pub fn if_unmodified_since(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.if_unmodified_since = Some(input);
            self
        }
        /// <p>Return the object only if it has not been modified since the specified time, otherwise return a 412 (precondition failed).</p>
        pub fn set_if_unmodified_since(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.if_unmodified_since = input;
            self
        }
        /// <p>The object key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The object key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Because <code>HeadObject</code> returns only the metadata for an object, this parameter has no effect.</p>
        pub fn range(mut self, input: impl Into<std::string::String>) -> Self {
            self.range = Some(input.into());
            self
        }
        /// <p>Because <code>HeadObject</code> returns only the metadata for an object, this parameter has no effect.</p>
        pub fn set_range(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.range = input;
            self
        }
        /// <p>VersionId used to reference a specific version of the object.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>VersionId used to reference a specific version of the object.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>
        pub fn sse_customer_algorithm(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_algorithm = Some(input.into());
            self
        }
        /// <p>Specifies the algorithm to use to when encrypting the object (for example, AES256).</p>
        pub fn set_sse_customer_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_algorithm = input;
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
        pub fn sse_customer_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_key = Some(input.into());
            self
        }
        /// <p>Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the <code>x-amz-server-side-encryption-customer-algorithm</code> header.</p>
        pub fn set_sse_customer_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_key = input;
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn sse_customer_key_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.sse_customer_key_md5 = Some(input.into());
            self
        }
        /// <p>Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error.</p>
        pub fn set_sse_customer_key_md5(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sse_customer_key_md5 = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a 'ranged' HEAD request for the part specified. Useful querying about the size of the part and the number of parts in this object.</p>
        pub fn part_number(mut self, input: i32) -> Self {
            self.part_number = Some(input);
            self
        }
        /// <p>Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a 'ranged' HEAD request for the part specified. Useful querying about the size of the part and the number of parts in this object.</p>
        pub fn set_part_number(mut self, input: std::option::Option<i32>) -> Self {
            self.part_number = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`HeadObjectInput`](crate::input::HeadObjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::HeadObjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::HeadObjectInput {
                bucket: self.bucket,
                if_match: self.if_match,
                if_modified_since: self.if_modified_since,
                if_none_match: self.if_none_match,
                if_unmodified_since: self.if_unmodified_since,
                key: self.key,
                range: self.range,
                version_id: self.version_id,
                sse_customer_algorithm: self.sse_customer_algorithm,
                sse_customer_key: self.sse_customer_key,
                sse_customer_key_md5: self.sse_customer_key_md5,
                request_payer: self.request_payer,
                part_number: self.part_number.unwrap_or_default(),
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type HeadObjectInputOperationOutputAlias = crate::operation::HeadObject;
#[doc(hidden)]
pub type HeadObjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl HeadObjectInput {
    /// Consumes the builder and constructs an Operation<[`HeadObject`](crate::operation::HeadObject)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::HeadObject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::HeadObjectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_362 = &_input.bucket;
            let input_362 =
                input_362
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_362, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            let input_363 = &_input.key;
            let input_363 =
                input_363
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    })?;
            let key = aws_smithy_http::label::fmt_string(input_363, true);
            if key.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "key",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::HeadObjectInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_364) = &_input.if_match {
                let formatted_365 = AsRef::<str>::as_ref(inner_364);
                if !formatted_365.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_365;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "if_match",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("If-Match", header_value);
                }
            }
            if let Some(inner_366) = &_input.if_modified_since {
                let formatted_367 = inner_366.fmt(aws_smithy_types::date_time::Format::HttpDate)?;
                if !formatted_367.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_367;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "if_modified_since",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("If-Modified-Since", header_value);
                }
            }
            if let Some(inner_368) = &_input.if_none_match {
                let formatted_369 = AsRef::<str>::as_ref(inner_368);
                if !formatted_369.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_369;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "if_none_match",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("If-None-Match", header_value);
                }
            }
            if let Some(inner_370) = &_input.if_unmodified_since {
                let formatted_371 = inner_370.fmt(aws_smithy_types::date_time::Format::HttpDate)?;
                if !formatted_371.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_371;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "if_unmodified_since",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("If-Unmodified-Since", header_value);
                }
            }
            if let Some(inner_372) = &_input.range {
                let formatted_373 = AsRef::<str>::as_ref(inner_372);
                if !formatted_373.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_373;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "range",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Range", header_value);
                }
            }
            if let Some(inner_374) = &_input.sse_customer_algorithm {
                let formatted_375 = AsRef::<str>::as_ref(inner_374);
                if !formatted_375.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_375;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "sse_customer_algorithm",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header(
                        "x-amz-server-side-encryption-customer-algorithm",
                        header_value,
                    );
                }
            }
            if let Some(inner_376) = &_input.sse_customer_key {
                let formatted_377 = AsRef::<str>::as_ref(inner_376);
                if !formatted_377.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_377;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "sse_customer_key",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder =
                        builder.header("x-amz-server-side-encryption-customer-key", header_value);
                }
            }
            if let Some(inner_378) = &_input.sse_customer_key_md5 {
                let formatted_379 = AsRef::<str>::as_ref(inner_378);
                if !formatted_379.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_379;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "sse_customer_key_md5",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header(
                        "x-amz-server-side-encryption-customer-key-MD5",
                        header_value,
                    );
                }
            }
            if let Some(inner_380) = &_input.request_payer {
                let formatted_381 = AsRef::<str>::as_ref(inner_380);
                if !formatted_381.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_381;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "request_payer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-request-payer", header_value);
                }
            }
            if let Some(inner_382) = &_input.expected_bucket_owner {
                let formatted_383 = AsRef::<str>::as_ref(inner_382);
                if !formatted_383.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_383;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::HeadObjectInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_384) = &_input.version_id {
                query.push_kv("versionId", &aws_smithy_http::query::fmt_string(&inner_384));
            }
            if _input.part_number != 0 {
                query.push_kv(
                    "partNumber",
                    aws_smithy_types::primitive::Encoder::from(_input.part_number).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::HeadObjectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("HEAD").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::HeadObjectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::HeadObject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "HeadObject",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`HeadObjectInput`](crate::input::HeadObjectInput)
    pub fn builder() -> crate::input::head_object_input::Builder {
        crate::input::head_object_input::Builder::default()
    }
}

/// See [`ListBucketAnalyticsConfigurationsInput`](crate::input::ListBucketAnalyticsConfigurationsInput)
pub mod list_bucket_analytics_configurations_input {
    /// A builder for [`ListBucketAnalyticsConfigurationsInput`](crate::input::ListBucketAnalyticsConfigurationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) continuation_token: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket from which analytics configurations are retrieved.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket from which analytics configurations are retrieved.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The ContinuationToken that represents a placeholder from where this request should begin.</p>
        pub fn continuation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.continuation_token = Some(input.into());
            self
        }
        /// <p>The ContinuationToken that represents a placeholder from where this request should begin.</p>
        pub fn set_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.continuation_token = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBucketAnalyticsConfigurationsInput`](crate::input::ListBucketAnalyticsConfigurationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBucketAnalyticsConfigurationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBucketAnalyticsConfigurationsInput {
                bucket: self.bucket,
                continuation_token: self.continuation_token,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBucketAnalyticsConfigurationsInputOperationOutputAlias =
    crate::operation::ListBucketAnalyticsConfigurations;
#[doc(hidden)]
pub type ListBucketAnalyticsConfigurationsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListBucketAnalyticsConfigurationsInput {
    /// Consumes the builder and constructs an Operation<[`ListBucketAnalyticsConfigurations`](crate::operation::ListBucketAnalyticsConfigurations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBucketAnalyticsConfigurations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBucketAnalyticsConfigurationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_385 = &_input.bucket;
            let input_385 =
                input_385
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_385, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListBucketAnalyticsConfigurationsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_386) = &_input.expected_bucket_owner {
                let formatted_387 = AsRef::<str>::as_ref(inner_386);
                if !formatted_387.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_387;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::ListBucketAnalyticsConfigurationsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("analytics");
            query.push_kv("x-id", "ListBucketAnalyticsConfigurations");
            if let Some(inner_388) = &_input.continuation_token {
                query.push_kv(
                    "continuation-token",
                    &aws_smithy_http::query::fmt_string(&inner_388),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBucketAnalyticsConfigurationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBucketAnalyticsConfigurationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBucketAnalyticsConfigurations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBucketAnalyticsConfigurations",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBucketAnalyticsConfigurationsInput`](crate::input::ListBucketAnalyticsConfigurationsInput)
    pub fn builder() -> crate::input::list_bucket_analytics_configurations_input::Builder {
        crate::input::list_bucket_analytics_configurations_input::Builder::default()
    }
}

/// See [`ListBucketIntelligentTieringConfigurationsInput`](crate::input::ListBucketIntelligentTieringConfigurationsInput)
pub mod list_bucket_intelligent_tiering_configurations_input {
    /// A builder for [`ListBucketIntelligentTieringConfigurationsInput`](crate::input::ListBucketIntelligentTieringConfigurationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) continuation_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon S3 bucket whose configuration you want to modify or retrieve.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket whose configuration you want to modify or retrieve.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The ContinuationToken that represents a placeholder from where this request should begin.</p>
        pub fn continuation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.continuation_token = Some(input.into());
            self
        }
        /// <p>The ContinuationToken that represents a placeholder from where this request should begin.</p>
        pub fn set_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.continuation_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBucketIntelligentTieringConfigurationsInput`](crate::input::ListBucketIntelligentTieringConfigurationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBucketIntelligentTieringConfigurationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::ListBucketIntelligentTieringConfigurationsInput {
                    bucket: self.bucket,
                    continuation_token: self.continuation_token,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type ListBucketIntelligentTieringConfigurationsInputOperationOutputAlias =
    crate::operation::ListBucketIntelligentTieringConfigurations;
#[doc(hidden)]
pub type ListBucketIntelligentTieringConfigurationsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListBucketIntelligentTieringConfigurationsInput {
    /// Consumes the builder and constructs an Operation<[`ListBucketIntelligentTieringConfigurations`](crate::operation::ListBucketIntelligentTieringConfigurations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBucketIntelligentTieringConfigurations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBucketIntelligentTieringConfigurationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_389 = &_input.bucket;
            let input_389 =
                input_389
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_389, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListBucketIntelligentTieringConfigurationsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("intelligent-tiering");
            query.push_kv("x-id", "ListBucketIntelligentTieringConfigurations");
            if let Some(inner_390) = &_input.continuation_token {
                query.push_kv(
                    "continuation-token",
                    &aws_smithy_http::query::fmt_string(&inner_390),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBucketIntelligentTieringConfigurationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBucketIntelligentTieringConfigurationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBucketIntelligentTieringConfigurations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBucketIntelligentTieringConfigurations",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBucketIntelligentTieringConfigurationsInput`](crate::input::ListBucketIntelligentTieringConfigurationsInput)
    pub fn builder() -> crate::input::list_bucket_intelligent_tiering_configurations_input::Builder
    {
        crate::input::list_bucket_intelligent_tiering_configurations_input::Builder::default()
    }
}

/// See [`ListBucketInventoryConfigurationsInput`](crate::input::ListBucketInventoryConfigurationsInput)
pub mod list_bucket_inventory_configurations_input {
    /// A builder for [`ListBucketInventoryConfigurationsInput`](crate::input::ListBucketInventoryConfigurationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) continuation_token: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket containing the inventory configurations to retrieve.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket containing the inventory configurations to retrieve.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The marker used to continue an inventory configuration listing that has been truncated. Use the NextContinuationToken from a previously truncated list response to continue the listing. The continuation token is an opaque value that Amazon S3 understands.</p>
        pub fn continuation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.continuation_token = Some(input.into());
            self
        }
        /// <p>The marker used to continue an inventory configuration listing that has been truncated. Use the NextContinuationToken from a previously truncated list response to continue the listing. The continuation token is an opaque value that Amazon S3 understands.</p>
        pub fn set_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.continuation_token = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBucketInventoryConfigurationsInput`](crate::input::ListBucketInventoryConfigurationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBucketInventoryConfigurationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBucketInventoryConfigurationsInput {
                bucket: self.bucket,
                continuation_token: self.continuation_token,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBucketInventoryConfigurationsInputOperationOutputAlias =
    crate::operation::ListBucketInventoryConfigurations;
#[doc(hidden)]
pub type ListBucketInventoryConfigurationsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListBucketInventoryConfigurationsInput {
    /// Consumes the builder and constructs an Operation<[`ListBucketInventoryConfigurations`](crate::operation::ListBucketInventoryConfigurations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBucketInventoryConfigurations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBucketInventoryConfigurationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_391 = &_input.bucket;
            let input_391 =
                input_391
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_391, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListBucketInventoryConfigurationsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_392) = &_input.expected_bucket_owner {
                let formatted_393 = AsRef::<str>::as_ref(inner_392);
                if !formatted_393.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_393;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::ListBucketInventoryConfigurationsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("inventory");
            query.push_kv("x-id", "ListBucketInventoryConfigurations");
            if let Some(inner_394) = &_input.continuation_token {
                query.push_kv(
                    "continuation-token",
                    &aws_smithy_http::query::fmt_string(&inner_394),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBucketInventoryConfigurationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBucketInventoryConfigurationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBucketInventoryConfigurations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBucketInventoryConfigurations",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBucketInventoryConfigurationsInput`](crate::input::ListBucketInventoryConfigurationsInput)
    pub fn builder() -> crate::input::list_bucket_inventory_configurations_input::Builder {
        crate::input::list_bucket_inventory_configurations_input::Builder::default()
    }
}

/// See [`ListBucketMetricsConfigurationsInput`](crate::input::ListBucketMetricsConfigurationsInput)
pub mod list_bucket_metrics_configurations_input {
    /// A builder for [`ListBucketMetricsConfigurationsInput`](crate::input::ListBucketMetricsConfigurationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) continuation_token: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket containing the metrics configurations to retrieve.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket containing the metrics configurations to retrieve.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The marker that is used to continue a metrics configuration listing that has been truncated. Use the NextContinuationToken from a previously truncated list response to continue the listing. The continuation token is an opaque value that Amazon S3 understands.</p>
        pub fn continuation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.continuation_token = Some(input.into());
            self
        }
        /// <p>The marker that is used to continue a metrics configuration listing that has been truncated. Use the NextContinuationToken from a previously truncated list response to continue the listing. The continuation token is an opaque value that Amazon S3 understands.</p>
        pub fn set_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.continuation_token = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBucketMetricsConfigurationsInput`](crate::input::ListBucketMetricsConfigurationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBucketMetricsConfigurationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBucketMetricsConfigurationsInput {
                bucket: self.bucket,
                continuation_token: self.continuation_token,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBucketMetricsConfigurationsInputOperationOutputAlias =
    crate::operation::ListBucketMetricsConfigurations;
#[doc(hidden)]
pub type ListBucketMetricsConfigurationsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListBucketMetricsConfigurationsInput {
    /// Consumes the builder and constructs an Operation<[`ListBucketMetricsConfigurations`](crate::operation::ListBucketMetricsConfigurations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBucketMetricsConfigurations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBucketMetricsConfigurationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_395 = &_input.bucket;
            let input_395 =
                input_395
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_395, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListBucketMetricsConfigurationsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_396) = &_input.expected_bucket_owner {
                let formatted_397 = AsRef::<str>::as_ref(inner_396);
                if !formatted_397.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_397;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::ListBucketMetricsConfigurationsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("metrics");
            query.push_kv("x-id", "ListBucketMetricsConfigurations");
            if let Some(inner_398) = &_input.continuation_token {
                query.push_kv(
                    "continuation-token",
                    &aws_smithy_http::query::fmt_string(&inner_398),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBucketMetricsConfigurationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBucketMetricsConfigurationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBucketMetricsConfigurations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBucketMetricsConfigurations",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBucketMetricsConfigurationsInput`](crate::input::ListBucketMetricsConfigurationsInput)
    pub fn builder() -> crate::input::list_bucket_metrics_configurations_input::Builder {
        crate::input::list_bucket_metrics_configurations_input::Builder::default()
    }
}

/// See [`ListBucketsInput`](crate::input::ListBucketsInput)
pub mod list_buckets_input {
    /// A builder for [`ListBucketsInput`](crate::input::ListBucketsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ListBucketsInput`](crate::input::ListBucketsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBucketsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBucketsInput {})
        }
    }
}
#[doc(hidden)]
pub type ListBucketsInputOperationOutputAlias = crate::operation::ListBuckets;
#[doc(hidden)]
pub type ListBucketsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListBucketsInput {
    /// Consumes the builder and constructs an Operation<[`ListBuckets`](crate::operation::ListBuckets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBuckets,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBucketsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBucketsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBucketsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBuckets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBuckets",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBucketsInput`](crate::input::ListBucketsInput)
    pub fn builder() -> crate::input::list_buckets_input::Builder {
        crate::input::list_buckets_input::Builder::default()
    }
}

/// See [`ListMultipartUploadsInput`](crate::input::ListMultipartUploadsInput)
pub mod list_multipart_uploads_input {
    /// A builder for [`ListMultipartUploadsInput`](crate::input::ListMultipartUploadsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) delimiter: std::option::Option<std::string::String>,
        pub(crate) encoding_type: std::option::Option<crate::model::EncodingType>,
        pub(crate) key_marker: std::option::Option<std::string::String>,
        pub(crate) max_uploads: std::option::Option<i32>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) upload_id_marker: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket to which the multipart upload was initiated. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket to which the multipart upload was initiated. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Character you use to group keys.</p>
        /// <p>All keys that contain the same string between the prefix, if specified, and the first occurrence of the delimiter after the prefix are grouped under a single result element, <code>CommonPrefixes</code>. If you don't specify the prefix parameter, then the substring starts at the beginning of the key. The keys that are grouped under <code>CommonPrefixes</code> result element are not returned elsewhere in the response.</p>
        pub fn delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.delimiter = Some(input.into());
            self
        }
        /// <p>Character you use to group keys.</p>
        /// <p>All keys that contain the same string between the prefix, if specified, and the first occurrence of the delimiter after the prefix are grouped under a single result element, <code>CommonPrefixes</code>. If you don't specify the prefix parameter, then the substring starts at the beginning of the key. The keys that are grouped under <code>CommonPrefixes</code> result element are not returned elsewhere in the response.</p>
        pub fn set_delimiter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.delimiter = input;
            self
        }
        /// <p>Requests Amazon S3 to encode the object keys in the response and specifies the encoding method to use. An object key may contain any Unicode character; however, XML 1.0 parser cannot parse some characters, such as characters with an ASCII value from 0 to 10. For characters that are not supported in XML 1.0, you can add this parameter to request that Amazon S3 encode the keys in the response.</p>
        pub fn encoding_type(mut self, input: crate::model::EncodingType) -> Self {
            self.encoding_type = Some(input);
            self
        }
        /// <p>Requests Amazon S3 to encode the object keys in the response and specifies the encoding method to use. An object key may contain any Unicode character; however, XML 1.0 parser cannot parse some characters, such as characters with an ASCII value from 0 to 10. For characters that are not supported in XML 1.0, you can add this parameter to request that Amazon S3 encode the keys in the response.</p>
        pub fn set_encoding_type(
            mut self,
            input: std::option::Option<crate::model::EncodingType>,
        ) -> Self {
            self.encoding_type = input;
            self
        }
        /// <p>Together with upload-id-marker, this parameter specifies the multipart upload after which listing should begin.</p>
        /// <p>If <code>upload-id-marker</code> is not specified, only the keys lexicographically greater than the specified <code>key-marker</code> will be included in the list.</p>
        /// <p>If <code>upload-id-marker</code> is specified, any multipart uploads for a key equal to the <code>key-marker</code> might also be included, provided those multipart uploads have upload IDs lexicographically greater than the specified <code>upload-id-marker</code>.</p>
        pub fn key_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_marker = Some(input.into());
            self
        }
        /// <p>Together with upload-id-marker, this parameter specifies the multipart upload after which listing should begin.</p>
        /// <p>If <code>upload-id-marker</code> is not specified, only the keys lexicographically greater than the specified <code>key-marker</code> will be included in the list.</p>
        /// <p>If <code>upload-id-marker</code> is specified, any multipart uploads for a key equal to the <code>key-marker</code> might also be included, provided those multipart uploads have upload IDs lexicographically greater than the specified <code>upload-id-marker</code>.</p>
        pub fn set_key_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_marker = input;
            self
        }
        /// <p>Sets the maximum number of multipart uploads, from 1 to 1,000, to return in the response body. 1,000 is the maximum number of uploads that can be returned in a response.</p>
        pub fn max_uploads(mut self, input: i32) -> Self {
            self.max_uploads = Some(input);
            self
        }
        /// <p>Sets the maximum number of multipart uploads, from 1 to 1,000, to return in the response body. 1,000 is the maximum number of uploads that can be returned in a response.</p>
        pub fn set_max_uploads(mut self, input: std::option::Option<i32>) -> Self {
            self.max_uploads = input;
            self
        }
        /// <p>Lists in-progress uploads only for those keys that begin with the specified prefix. You can use prefixes to separate a bucket into different grouping of keys. (You can think of using prefix to make groups in the same way you'd use a folder in a file system.)</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>Lists in-progress uploads only for those keys that begin with the specified prefix. You can use prefixes to separate a bucket into different grouping of keys. (You can think of using prefix to make groups in the same way you'd use a folder in a file system.)</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>Together with key-marker, specifies the multipart upload after which listing should begin. If key-marker is not specified, the upload-id-marker parameter is ignored. Otherwise, any multipart uploads for a key equal to the key-marker might be included in the list only if they have an upload ID lexicographically greater than the specified <code>upload-id-marker</code>.</p>
        pub fn upload_id_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id_marker = Some(input.into());
            self
        }
        /// <p>Together with key-marker, specifies the multipart upload after which listing should begin. If key-marker is not specified, the upload-id-marker parameter is ignored. Otherwise, any multipart uploads for a key equal to the key-marker might be included in the list only if they have an upload ID lexicographically greater than the specified <code>upload-id-marker</code>.</p>
        pub fn set_upload_id_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.upload_id_marker = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMultipartUploadsInput`](crate::input::ListMultipartUploadsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListMultipartUploadsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListMultipartUploadsInput {
                bucket: self.bucket,
                delimiter: self.delimiter,
                encoding_type: self.encoding_type,
                key_marker: self.key_marker,
                max_uploads: self.max_uploads.unwrap_or_default(),
                prefix: self.prefix,
                upload_id_marker: self.upload_id_marker,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type ListMultipartUploadsInputOperationOutputAlias = crate::operation::ListMultipartUploads;
#[doc(hidden)]
pub type ListMultipartUploadsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListMultipartUploadsInput {
    /// Consumes the builder and constructs an Operation<[`ListMultipartUploads`](crate::operation::ListMultipartUploads)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListMultipartUploads,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListMultipartUploadsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_399 = &_input.bucket;
            let input_399 =
                input_399
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_399, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListMultipartUploadsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_400) = &_input.expected_bucket_owner {
                let formatted_401 = AsRef::<str>::as_ref(inner_400);
                if !formatted_401.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_401;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::ListMultipartUploadsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("uploads");
            if let Some(inner_402) = &_input.delimiter {
                query.push_kv("delimiter", &aws_smithy_http::query::fmt_string(&inner_402));
            }
            if let Some(inner_403) = &_input.encoding_type {
                query.push_kv(
                    "encoding-type",
                    &aws_smithy_http::query::fmt_string(&inner_403),
                );
            }
            if let Some(inner_404) = &_input.key_marker {
                query.push_kv(
                    "key-marker",
                    &aws_smithy_http::query::fmt_string(&inner_404),
                );
            }
            if _input.max_uploads != 0 {
                query.push_kv(
                    "max-uploads",
                    aws_smithy_types::primitive::Encoder::from(_input.max_uploads).encode(),
                );
            }
            if let Some(inner_405) = &_input.prefix {
                query.push_kv("prefix", &aws_smithy_http::query::fmt_string(&inner_405));
            }
            if let Some(inner_406) = &_input.upload_id_marker {
                query.push_kv(
                    "upload-id-marker",
                    &aws_smithy_http::query::fmt_string(&inner_406),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListMultipartUploadsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListMultipartUploadsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListMultipartUploads::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListMultipartUploads",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListMultipartUploadsInput`](crate::input::ListMultipartUploadsInput)
    pub fn builder() -> crate::input::list_multipart_uploads_input::Builder {
        crate::input::list_multipart_uploads_input::Builder::default()
    }
}

/// See [`ListObjectsInput`](crate::input::ListObjectsInput)
pub mod list_objects_input {
    /// A builder for [`ListObjectsInput`](crate::input::ListObjectsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) delimiter: std::option::Option<std::string::String>,
        pub(crate) encoding_type: std::option::Option<crate::model::EncodingType>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_keys: std::option::Option<i32>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket containing the objects.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket containing the objects.</p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>A delimiter is a character you use to group keys.</p>
        pub fn delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.delimiter = Some(input.into());
            self
        }
        /// <p>A delimiter is a character you use to group keys.</p>
        pub fn set_delimiter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.delimiter = input;
            self
        }
        /// <p>Requests Amazon S3 to encode the object keys in the response and specifies the encoding method to use. An object key may contain any Unicode character; however, XML 1.0 parser cannot parse some characters, such as characters with an ASCII value from 0 to 10. For characters that are not supported in XML 1.0, you can add this parameter to request that Amazon S3 encode the keys in the response.</p>
        pub fn encoding_type(mut self, input: crate::model::EncodingType) -> Self {
            self.encoding_type = Some(input);
            self
        }
        /// <p>Requests Amazon S3 to encode the object keys in the response and specifies the encoding method to use. An object key may contain any Unicode character; however, XML 1.0 parser cannot parse some characters, such as characters with an ASCII value from 0 to 10. For characters that are not supported in XML 1.0, you can add this parameter to request that Amazon S3 encode the keys in the response.</p>
        pub fn set_encoding_type(
            mut self,
            input: std::option::Option<crate::model::EncodingType>,
        ) -> Self {
            self.encoding_type = input;
            self
        }
        /// <p>Marker is where you want Amazon S3 to start listing from. Amazon S3 starts listing after this specified key. Marker can be any key in the bucket.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Marker is where you want Amazon S3 to start listing from. Amazon S3 starts listing after this specified key. Marker can be any key in the bucket.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Sets the maximum number of keys returned in the response. By default the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more. </p>
        pub fn max_keys(mut self, input: i32) -> Self {
            self.max_keys = Some(input);
            self
        }
        /// <p>Sets the maximum number of keys returned in the response. By default the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more. </p>
        pub fn set_max_keys(mut self, input: std::option::Option<i32>) -> Self {
            self.max_keys = input;
            self
        }
        /// <p>Limits the response to keys that begin with the specified prefix.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>Limits the response to keys that begin with the specified prefix.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>Confirms that the requester knows that she or he will be charged for the list objects request. Bucket owners need not specify this parameter in their requests.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that she or he will be charged for the list objects request. Bucket owners need not specify this parameter in their requests.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`ListObjectsInput`](crate::input::ListObjectsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListObjectsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListObjectsInput {
                bucket: self.bucket,
                delimiter: self.delimiter,
                encoding_type: self.encoding_type,
                marker: self.marker,
                max_keys: self.max_keys.unwrap_or_default(),
                prefix: self.prefix,
                request_payer: self.request_payer,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type ListObjectsInputOperationOutputAlias = crate::operation::ListObjects;
#[doc(hidden)]
pub type ListObjectsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListObjectsInput {
    /// Consumes the builder and constructs an Operation<[`ListObjects`](crate::operation::ListObjects)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListObjects,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListObjectsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_407 = &_input.bucket;
            let input_407 =
                input_407
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_407, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListObjectsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_408) = &_input.request_payer {
                let formatted_409 = AsRef::<str>::as_ref(inner_408);
                if !formatted_409.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_409;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "request_payer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-request-payer", header_value);
                }
            }
            if let Some(inner_410) = &_input.expected_bucket_owner {
                let formatted_411 = AsRef::<str>::as_ref(inner_410);
                if !formatted_411.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_411;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::ListObjectsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_412) = &_input.delimiter {
                query.push_kv("delimiter", &aws_smithy_http::query::fmt_string(&inner_412));
            }
            if let Some(inner_413) = &_input.encoding_type {
                query.push_kv(
                    "encoding-type",
                    &aws_smithy_http::query::fmt_string(&inner_413),
                );
            }
            if let Some(inner_414) = &_input.marker {
                query.push_kv("marker", &aws_smithy_http::query::fmt_string(&inner_414));
            }
            if _input.max_keys != 0 {
                query.push_kv(
                    "max-keys",
                    aws_smithy_types::primitive::Encoder::from(_input.max_keys).encode(),
                );
            }
            if let Some(inner_415) = &_input.prefix {
                query.push_kv("prefix", &aws_smithy_http::query::fmt_string(&inner_415));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListObjectsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListObjectsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListObjects::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListObjects",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListObjectsInput`](crate::input::ListObjectsInput)
    pub fn builder() -> crate::input::list_objects_input::Builder {
        crate::input::list_objects_input::Builder::default()
    }
}

/// See [`ListObjectsV2Input`](crate::input::ListObjectsV2Input)
pub mod list_objects_v2_input {
    /// A builder for [`ListObjectsV2Input`](crate::input::ListObjectsV2Input)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) delimiter: std::option::Option<std::string::String>,
        pub(crate) encoding_type: std::option::Option<crate::model::EncodingType>,
        pub(crate) max_keys: std::option::Option<i32>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) continuation_token: std::option::Option<std::string::String>,
        pub(crate) fetch_owner: std::option::Option<bool>,
        pub(crate) start_after: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Bucket name to list. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>Bucket name to list. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>A delimiter is a character you use to group keys.</p>
        pub fn delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.delimiter = Some(input.into());
            self
        }
        /// <p>A delimiter is a character you use to group keys.</p>
        pub fn set_delimiter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.delimiter = input;
            self
        }
        /// <p>Encoding type used by Amazon S3 to encode object keys in the response.</p>
        pub fn encoding_type(mut self, input: crate::model::EncodingType) -> Self {
            self.encoding_type = Some(input);
            self
        }
        /// <p>Encoding type used by Amazon S3 to encode object keys in the response.</p>
        pub fn set_encoding_type(
            mut self,
            input: std::option::Option<crate::model::EncodingType>,
        ) -> Self {
            self.encoding_type = input;
            self
        }
        /// <p>Sets the maximum number of keys returned in the response. By default the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more.</p>
        pub fn max_keys(mut self, input: i32) -> Self {
            self.max_keys = Some(input);
            self
        }
        /// <p>Sets the maximum number of keys returned in the response. By default the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more.</p>
        pub fn set_max_keys(mut self, input: std::option::Option<i32>) -> Self {
            self.max_keys = input;
            self
        }
        /// <p>Limits the response to keys that begin with the specified prefix.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>Limits the response to keys that begin with the specified prefix.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>ContinuationToken indicates Amazon S3 that the list is being continued on this bucket with a token. ContinuationToken is obfuscated and is not a real key.</p>
        pub fn continuation_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.continuation_token = Some(input.into());
            self
        }
        /// <p>ContinuationToken indicates Amazon S3 that the list is being continued on this bucket with a token. ContinuationToken is obfuscated and is not a real key.</p>
        pub fn set_continuation_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.continuation_token = input;
            self
        }
        /// <p>The owner field is not present in listV2 by default, if you want to return owner field with each key in the result then set the fetch owner field to true.</p>
        pub fn fetch_owner(mut self, input: bool) -> Self {
            self.fetch_owner = Some(input);
            self
        }
        /// <p>The owner field is not present in listV2 by default, if you want to return owner field with each key in the result then set the fetch owner field to true.</p>
        pub fn set_fetch_owner(mut self, input: std::option::Option<bool>) -> Self {
            self.fetch_owner = input;
            self
        }
        /// <p>StartAfter is where you want Amazon S3 to start listing from. Amazon S3 starts listing after this specified key. StartAfter can be any key in the bucket.</p>
        pub fn start_after(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_after = Some(input.into());
            self
        }
        /// <p>StartAfter is where you want Amazon S3 to start listing from. Amazon S3 starts listing after this specified key. StartAfter can be any key in the bucket.</p>
        pub fn set_start_after(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start_after = input;
            self
        }
        /// <p>Confirms that the requester knows that she or he will be charged for the list objects request in V2 style. Bucket owners need not specify this parameter in their requests.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that she or he will be charged for the list objects request in V2 style. Bucket owners need not specify this parameter in their requests.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`ListObjectsV2Input`](crate::input::ListObjectsV2Input)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListObjectsV2Input,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListObjectsV2Input {
                bucket: self.bucket,
                delimiter: self.delimiter,
                encoding_type: self.encoding_type,
                max_keys: self.max_keys.unwrap_or_default(),
                prefix: self.prefix,
                continuation_token: self.continuation_token,
                fetch_owner: self.fetch_owner.unwrap_or_default(),
                start_after: self.start_after,
                request_payer: self.request_payer,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type ListObjectsV2InputOperationOutputAlias = crate::operation::ListObjectsV2;
#[doc(hidden)]
pub type ListObjectsV2InputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListObjectsV2Input {
    /// Consumes the builder and constructs an Operation<[`ListObjectsV2`](crate::operation::ListObjectsV2)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListObjectsV2,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListObjectsV2Input,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_416 = &_input.bucket;
            let input_416 =
                input_416
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_416, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListObjectsV2Input,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_417) = &_input.request_payer {
                let formatted_418 = AsRef::<str>::as_ref(inner_417);
                if !formatted_418.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_418;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "request_payer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-request-payer", header_value);
                }
            }
            if let Some(inner_419) = &_input.expected_bucket_owner {
                let formatted_420 = AsRef::<str>::as_ref(inner_419);
                if !formatted_420.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_420;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::ListObjectsV2Input,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("list-type", "2");
            if let Some(inner_421) = &_input.delimiter {
                query.push_kv("delimiter", &aws_smithy_http::query::fmt_string(&inner_421));
            }
            if let Some(inner_422) = &_input.encoding_type {
                query.push_kv(
                    "encoding-type",
                    &aws_smithy_http::query::fmt_string(&inner_422),
                );
            }
            if _input.max_keys != 0 {
                query.push_kv(
                    "max-keys",
                    aws_smithy_types::primitive::Encoder::from(_input.max_keys).encode(),
                );
            }
            if let Some(inner_423) = &_input.prefix {
                query.push_kv("prefix", &aws_smithy_http::query::fmt_string(&inner_423));
            }
            if let Some(inner_424) = &_input.continuation_token {
                query.push_kv(
                    "continuation-token",
                    &aws_smithy_http::query::fmt_string(&inner_424),
                );
            }
            if _input.fetch_owner {
                query.push_kv(
                    "fetch-owner",
                    aws_smithy_types::primitive::Encoder::from(_input.fetch_owner).encode(),
                );
            }
            if let Some(inner_425) = &_input.start_after {
                query.push_kv(
                    "start-after",
                    &aws_smithy_http::query::fmt_string(&inner_425),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListObjectsV2Input,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListObjectsV2Input,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListObjectsV2::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListObjectsV2",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListObjectsV2Input`](crate::input::ListObjectsV2Input)
    pub fn builder() -> crate::input::list_objects_v2_input::Builder {
        crate::input::list_objects_v2_input::Builder::default()
    }
}

/// See [`ListObjectVersionsInput`](crate::input::ListObjectVersionsInput)
pub mod list_object_versions_input {
    /// A builder for [`ListObjectVersionsInput`](crate::input::ListObjectVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) delimiter: std::option::Option<std::string::String>,
        pub(crate) encoding_type: std::option::Option<crate::model::EncodingType>,
        pub(crate) key_marker: std::option::Option<std::string::String>,
        pub(crate) max_keys: std::option::Option<i32>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) version_id_marker: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The bucket name that contains the objects. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket name that contains the objects. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>A delimiter is a character that you specify to group keys. All keys that contain the same string between the <code>prefix</code> and the first occurrence of the delimiter are grouped under a single result element in CommonPrefixes. These groups are counted as one result against the max-keys limitation. These keys are not returned elsewhere in the response.</p>
        pub fn delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.delimiter = Some(input.into());
            self
        }
        /// <p>A delimiter is a character that you specify to group keys. All keys that contain the same string between the <code>prefix</code> and the first occurrence of the delimiter are grouped under a single result element in CommonPrefixes. These groups are counted as one result against the max-keys limitation. These keys are not returned elsewhere in the response.</p>
        pub fn set_delimiter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.delimiter = input;
            self
        }
        /// <p>Requests Amazon S3 to encode the object keys in the response and specifies the encoding method to use. An object key may contain any Unicode character; however, XML 1.0 parser cannot parse some characters, such as characters with an ASCII value from 0 to 10. For characters that are not supported in XML 1.0, you can add this parameter to request that Amazon S3 encode the keys in the response.</p>
        pub fn encoding_type(mut self, input: crate::model::EncodingType) -> Self {
            self.encoding_type = Some(input);
            self
        }
        /// <p>Requests Amazon S3 to encode the object keys in the response and specifies the encoding method to use. An object key may contain any Unicode character; however, XML 1.0 parser cannot parse some characters, such as characters with an ASCII value from 0 to 10. For characters that are not supported in XML 1.0, you can add this parameter to request that Amazon S3 encode the keys in the response.</p>
        pub fn set_encoding_type(
            mut self,
            input: std::option::Option<crate::model::EncodingType>,
        ) -> Self {
            self.encoding_type = input;
            self
        }
        /// <p>Specifies the key to start with when listing objects in a bucket.</p>
        pub fn key_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_marker = Some(input.into());
            self
        }
        /// <p>Specifies the key to start with when listing objects in a bucket.</p>
        pub fn set_key_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_marker = input;
            self
        }
        /// <p>Sets the maximum number of keys returned in the response. By default the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more. If additional keys satisfy the search criteria, but were not returned because max-keys was exceeded, the response contains <istruncated>
        /// true
        /// </istruncated>. To return the additional keys, see key-marker and version-id-marker.</p>
        pub fn max_keys(mut self, input: i32) -> Self {
            self.max_keys = Some(input);
            self
        }
        /// <p>Sets the maximum number of keys returned in the response. By default the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more. If additional keys satisfy the search criteria, but were not returned because max-keys was exceeded, the response contains <istruncated>
        /// true
        /// </istruncated>. To return the additional keys, see key-marker and version-id-marker.</p>
        pub fn set_max_keys(mut self, input: std::option::Option<i32>) -> Self {
            self.max_keys = input;
            self
        }
        /// <p>Use this parameter to select only those keys that begin with the specified prefix. You can use prefixes to separate a bucket into different groupings of keys. (You can think of using prefix to make groups in the same way you'd use a folder in a file system.) You can use prefix with delimiter to roll up numerous objects into a single result under CommonPrefixes. </p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>Use this parameter to select only those keys that begin with the specified prefix. You can use prefixes to separate a bucket into different groupings of keys. (You can think of using prefix to make groups in the same way you'd use a folder in a file system.) You can use prefix with delimiter to roll up numerous objects into a single result under CommonPrefixes. </p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>Specifies the object version you want to start listing from.</p>
        pub fn version_id_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id_marker = Some(input.into());
            self
        }
        /// <p>Specifies the object version you want to start listing from.</p>
        pub fn set_version_id_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_id_marker = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`ListObjectVersionsInput`](crate::input::ListObjectVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListObjectVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListObjectVersionsInput {
                bucket: self.bucket,
                delimiter: self.delimiter,
                encoding_type: self.encoding_type,
                key_marker: self.key_marker,
                max_keys: self.max_keys.unwrap_or_default(),
                prefix: self.prefix,
                version_id_marker: self.version_id_marker,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type ListObjectVersionsInputOperationOutputAlias = crate::operation::ListObjectVersions;
#[doc(hidden)]
pub type ListObjectVersionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListObjectVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListObjectVersions`](crate::operation::ListObjectVersions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListObjectVersions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListObjectVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_426 = &_input.bucket;
            let input_426 =
                input_426
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_426, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListObjectVersionsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_427) = &_input.expected_bucket_owner {
                let formatted_428 = AsRef::<str>::as_ref(inner_427);
                if !formatted_428.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_428;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::ListObjectVersionsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("versions");
            if let Some(inner_429) = &_input.delimiter {
                query.push_kv("delimiter", &aws_smithy_http::query::fmt_string(&inner_429));
            }
            if let Some(inner_430) = &_input.encoding_type {
                query.push_kv(
                    "encoding-type",
                    &aws_smithy_http::query::fmt_string(&inner_430),
                );
            }
            if let Some(inner_431) = &_input.key_marker {
                query.push_kv(
                    "key-marker",
                    &aws_smithy_http::query::fmt_string(&inner_431),
                );
            }
            if _input.max_keys != 0 {
                query.push_kv(
                    "max-keys",
                    aws_smithy_types::primitive::Encoder::from(_input.max_keys).encode(),
                );
            }
            if let Some(inner_432) = &_input.prefix {
                query.push_kv("prefix", &aws_smithy_http::query::fmt_string(&inner_432));
            }
            if let Some(inner_433) = &_input.version_id_marker {
                query.push_kv(
                    "version-id-marker",
                    &aws_smithy_http::query::fmt_string(&inner_433),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListObjectVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListObjectVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListObjectVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListObjectVersions",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListObjectVersionsInput`](crate::input::ListObjectVersionsInput)
    pub fn builder() -> crate::input::list_object_versions_input::Builder {
        crate::input::list_object_versions_input::Builder::default()
    }
}

/// See [`ListPartsInput`](crate::input::ListPartsInput)
pub mod list_parts_input {
    /// A builder for [`ListPartsInput`](crate::input::ListPartsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) max_parts: std::option::Option<i32>,
        pub(crate) part_number_marker: std::option::Option<std::string::String>,
        pub(crate) upload_id: std::option::Option<std::string::String>,
        pub(crate) request_payer: std::option::Option<crate::model::RequestPayer>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket to which the parts are being uploaded. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket to which the parts are being uploaded. </p>
        /// <p>When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p>
        /// <p>When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com. When using this action using S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">Using S3 on Outposts</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Object key for which the multipart upload was initiated.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Object key for which the multipart upload was initiated.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Sets the maximum number of parts to return.</p>
        pub fn max_parts(mut self, input: i32) -> Self {
            self.max_parts = Some(input);
            self
        }
        /// <p>Sets the maximum number of parts to return.</p>
        pub fn set_max_parts(mut self, input: std::option::Option<i32>) -> Self {
            self.max_parts = input;
            self
        }
        /// <p>Specifies the part after which listing should begin. Only parts with higher part numbers will be listed.</p>
        pub fn part_number_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.part_number_marker = Some(input.into());
            self
        }
        /// <p>Specifies the part after which listing should begin. Only parts with higher part numbers will be listed.</p>
        pub fn set_part_number_marker(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.part_number_marker = input;
            self
        }
        /// <p>Upload ID identifying the multipart upload whose parts are being listed.</p>
        pub fn upload_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_id = Some(input.into());
            self
        }
        /// <p>Upload ID identifying the multipart upload whose parts are being listed.</p>
        pub fn set_upload_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_id = input;
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn request_payer(mut self, input: crate::model::RequestPayer) -> Self {
            self.request_payer = Some(input);
            self
        }
        /// <p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requestor Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_request_payer(
            mut self,
            input: std::option::Option<crate::model::RequestPayer>,
        ) -> Self {
            self.request_payer = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPartsInput`](crate::input::ListPartsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListPartsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListPartsInput {
                bucket: self.bucket,
                key: self.key,
                max_parts: self.max_parts.unwrap_or_default(),
                part_number_marker: self.part_number_marker,
                upload_id: self.upload_id,
                request_payer: self.request_payer,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPartsInputOperationOutputAlias = crate::operation::ListParts;
#[doc(hidden)]
pub type ListPartsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPartsInput {
    /// Consumes the builder and constructs an Operation<[`ListParts`](crate::operation::ListParts)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListParts,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPartsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_434 = &_input.bucket;
            let input_434 =
                input_434
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_434, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            let input_435 = &_input.key;
            let input_435 =
                input_435
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "key",
                        details: "cannot be empty or unset",
                    })?;
            let key = aws_smithy_http::label::fmt_string(input_435, true);
            if key.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "key",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}/{Key}", Bucket = bucket, Key = key)
                .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::ListPartsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_436) = &_input.request_payer {
                let formatted_437 = AsRef::<str>::as_ref(inner_436);
                if !formatted_437.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_437;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "request_payer",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-request-payer", header_value);
                }
            }
            if let Some(inner_438) = &_input.expected_bucket_owner {
                let formatted_439 = AsRef::<str>::as_ref(inner_438);
                if !formatted_439.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_439;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::ListPartsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("x-id", "ListParts");
            if _input.max_parts != 0 {
                query.push_kv(
                    "max-parts",
                    aws_smithy_types::primitive::Encoder::from(_input.max_parts).encode(),
                );
            }
            if let Some(inner_440) = &_input.part_number_marker {
                query.push_kv(
                    "part-number-marker",
                    &aws_smithy_http::query::fmt_string(&inner_440),
                );
            }
            if let Some(inner_441) = &_input.upload_id {
                query.push_kv("uploadId", &aws_smithy_http::query::fmt_string(&inner_441));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPartsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPartsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListParts::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new("ListParts", "s3"));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPartsInput`](crate::input::ListPartsInput)
    pub fn builder() -> crate::input::list_parts_input::Builder {
        crate::input::list_parts_input::Builder::default()
    }
}

/// See [`PutBucketAccelerateConfigurationInput`](crate::input::PutBucketAccelerateConfigurationInput)
pub mod put_bucket_accelerate_configuration_input {
    /// A builder for [`PutBucketAccelerateConfigurationInput`](crate::input::PutBucketAccelerateConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) accelerate_configuration:
            std::option::Option<crate::model::AccelerateConfiguration>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket for which the accelerate configuration is set.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket for which the accelerate configuration is set.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Container for setting the transfer acceleration state.</p>
        pub fn accelerate_configuration(
            mut self,
            input: crate::model::AccelerateConfiguration,
        ) -> Self {
            self.accelerate_configuration = Some(input);
            self
        }
        /// <p>Container for setting the transfer acceleration state.</p>
        pub fn set_accelerate_configuration(
            mut self,
            input: std::option::Option<crate::model::AccelerateConfiguration>,
        ) -> Self {
            self.accelerate_configuration = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketAccelerateConfigurationInput`](crate::input::PutBucketAccelerateConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketAccelerateConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBucketAccelerateConfigurationInput {
                bucket: self.bucket,
                accelerate_configuration: self.accelerate_configuration,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBucketAccelerateConfigurationInputOperationOutputAlias =
    crate::operation::PutBucketAccelerateConfiguration;
#[doc(hidden)]
pub type PutBucketAccelerateConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketAccelerateConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketAccelerateConfiguration`](crate::operation::PutBucketAccelerateConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketAccelerateConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutBucketAccelerateConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_442 = &_input.bucket;
            let input_442 =
                input_442
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_442, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::PutBucketAccelerateConfigurationInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_443) = &_input.expected_bucket_owner {
                let formatted_444 = AsRef::<str>::as_ref(inner_443);
                if !formatted_444.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_444;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::PutBucketAccelerateConfigurationInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("accelerate");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutBucketAccelerateConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutBucketAccelerateConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::ser_payload_put_bucket_accelerate_configuration_input(
            &self.accelerate_configuration,
        )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketAccelerateConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketAccelerateConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutBucketAccelerateConfigurationInput`](crate::input::PutBucketAccelerateConfigurationInput)
    pub fn builder() -> crate::input::put_bucket_accelerate_configuration_input::Builder {
        crate::input::put_bucket_accelerate_configuration_input::Builder::default()
    }
}

/// See [`PutBucketAclInput`](crate::input::PutBucketAclInput)
pub mod put_bucket_acl_input {
    /// A builder for [`PutBucketAclInput`](crate::input::PutBucketAclInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) acl: std::option::Option<crate::model::BucketCannedAcl>,
        pub(crate) access_control_policy: std::option::Option<crate::model::AccessControlPolicy>,
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) content_md5: std::option::Option<std::string::String>,
        pub(crate) grant_full_control: std::option::Option<std::string::String>,
        pub(crate) grant_read: std::option::Option<std::string::String>,
        pub(crate) grant_read_acp: std::option::Option<std::string::String>,
        pub(crate) grant_write: std::option::Option<std::string::String>,
        pub(crate) grant_write_acp: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The canned ACL to apply to the bucket.</p>
        pub fn acl(mut self, input: crate::model::BucketCannedAcl) -> Self {
            self.acl = Some(input);
            self
        }
        /// <p>The canned ACL to apply to the bucket.</p>
        pub fn set_acl(
            mut self,
            input: std::option::Option<crate::model::BucketCannedAcl>,
        ) -> Self {
            self.acl = input;
            self
        }
        /// <p>Contains the elements that set the ACL permissions for an object per grantee.</p>
        pub fn access_control_policy(mut self, input: crate::model::AccessControlPolicy) -> Self {
            self.access_control_policy = Some(input);
            self
        }
        /// <p>Contains the elements that set the ACL permissions for an object per grantee.</p>
        pub fn set_access_control_policy(
            mut self,
            input: std::option::Option<crate::model::AccessControlPolicy>,
        ) -> Self {
            self.access_control_policy = input;
            self
        }
        /// <p>The bucket to which to apply the ACL.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The bucket to which to apply the ACL.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity check to verify that the request body was not corrupted in transit. For more information, go to <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.</a> </p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_md5 = Some(input.into());
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity check to verify that the request body was not corrupted in transit. For more information, go to <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.</a> </p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_md5 = input;
            self
        }
        /// <p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p>
        pub fn grant_full_control(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_full_control = Some(input.into());
            self
        }
        /// <p>Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.</p>
        pub fn set_grant_full_control(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_full_control = input;
            self
        }
        /// <p>Allows grantee to list the objects in the bucket.</p>
        pub fn grant_read(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_read = Some(input.into());
            self
        }
        /// <p>Allows grantee to list the objects in the bucket.</p>
        pub fn set_grant_read(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grant_read = input;
            self
        }
        /// <p>Allows grantee to read the bucket ACL.</p>
        pub fn grant_read_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_read_acp = Some(input.into());
            self
        }
        /// <p>Allows grantee to read the bucket ACL.</p>
        pub fn set_grant_read_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_read_acp = input;
            self
        }
        /// <p>Allows grantee to create new objects in the bucket.</p>
        /// <p>For the bucket and object owners of existing objects, also allows deletions and overwrites of those objects.</p>
        pub fn grant_write(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_write = Some(input.into());
            self
        }
        /// <p>Allows grantee to create new objects in the bucket.</p>
        /// <p>For the bucket and object owners of existing objects, also allows deletions and overwrites of those objects.</p>
        pub fn set_grant_write(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grant_write = input;
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable bucket.</p>
        pub fn grant_write_acp(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_write_acp = Some(input.into());
            self
        }
        /// <p>Allows grantee to write the ACL for the applicable bucket.</p>
        pub fn set_grant_write_acp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grant_write_acp = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketAclInput`](crate::input::PutBucketAclInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketAclInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBucketAclInput {
                acl: self.acl,
                access_control_policy: self.access_control_policy,
                bucket: self.bucket,
                content_md5: self.content_md5,
                grant_full_control: self.grant_full_control,
                grant_read: self.grant_read,
                grant_read_acp: self.grant_read_acp,
                grant_write: self.grant_write,
                grant_write_acp: self.grant_write_acp,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBucketAclInputOperationOutputAlias = crate::operation::PutBucketAcl;
#[doc(hidden)]
pub type PutBucketAclInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketAclInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketAcl`](crate::operation::PutBucketAcl)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketAcl,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutBucketAclInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_445 = &_input.bucket;
            let input_445 =
                input_445
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_445, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::PutBucketAclInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_446) = &_input.acl {
                let formatted_447 = AsRef::<str>::as_ref(inner_446);
                if !formatted_447.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_447;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "acl",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-acl", header_value);
                }
            }
            if let Some(inner_448) = &_input.content_md5 {
                let formatted_449 = AsRef::<str>::as_ref(inner_448);
                if !formatted_449.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_449;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "content_md5",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Content-MD5", header_value);
                }
            }
            if let Some(inner_450) = &_input.grant_full_control {
                let formatted_451 = AsRef::<str>::as_ref(inner_450);
                if !formatted_451.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_451;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "grant_full_control",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-grant-full-control", header_value);
                }
            }
            if let Some(inner_452) = &_input.grant_read {
                let formatted_453 = AsRef::<str>::as_ref(inner_452);
                if !formatted_453.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_453;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "grant_read",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-grant-read", header_value);
                }
            }
            if let Some(inner_454) = &_input.grant_read_acp {
                let formatted_455 = AsRef::<str>::as_ref(inner_454);
                if !formatted_455.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_455;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "grant_read_acp",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-grant-read-acp", header_value);
                }
            }
            if let Some(inner_456) = &_input.grant_write {
                let formatted_457 = AsRef::<str>::as_ref(inner_456);
                if !formatted_457.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_457;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "grant_write",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-grant-write", header_value);
                }
            }
            if let Some(inner_458) = &_input.grant_write_acp {
                let formatted_459 = AsRef::<str>::as_ref(inner_458);
                if !formatted_459.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_459;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "grant_write_acp",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-grant-write-acp", header_value);
                }
            }
            if let Some(inner_460) = &_input.expected_bucket_owner {
                let formatted_461 = AsRef::<str>::as_ref(inner_460);
                if !formatted_461.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_461;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::PutBucketAclInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("acl");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutBucketAclInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutBucketAclInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::ser_payload_put_bucket_acl_input(&self.access_control_policy)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketAcl::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketAcl",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutBucketAclInput`](crate::input::PutBucketAclInput)
    pub fn builder() -> crate::input::put_bucket_acl_input::Builder {
        crate::input::put_bucket_acl_input::Builder::default()
    }
}

/// See [`PutBucketAnalyticsConfigurationInput`](crate::input::PutBucketAnalyticsConfigurationInput)
pub mod put_bucket_analytics_configuration_input {
    /// A builder for [`PutBucketAnalyticsConfigurationInput`](crate::input::PutBucketAnalyticsConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) analytics_configuration:
            std::option::Option<crate::model::AnalyticsConfiguration>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket to which an analytics configuration is stored.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket to which an analytics configuration is stored.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The ID that identifies the analytics configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID that identifies the analytics configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The configuration and any analyses for the analytics filter.</p>
        pub fn analytics_configuration(
            mut self,
            input: crate::model::AnalyticsConfiguration,
        ) -> Self {
            self.analytics_configuration = Some(input);
            self
        }
        /// <p>The configuration and any analyses for the analytics filter.</p>
        pub fn set_analytics_configuration(
            mut self,
            input: std::option::Option<crate::model::AnalyticsConfiguration>,
        ) -> Self {
            self.analytics_configuration = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketAnalyticsConfigurationInput`](crate::input::PutBucketAnalyticsConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketAnalyticsConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBucketAnalyticsConfigurationInput {
                bucket: self.bucket,
                id: self.id,
                analytics_configuration: self.analytics_configuration,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBucketAnalyticsConfigurationInputOperationOutputAlias =
    crate::operation::PutBucketAnalyticsConfiguration;
#[doc(hidden)]
pub type PutBucketAnalyticsConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketAnalyticsConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketAnalyticsConfiguration`](crate::operation::PutBucketAnalyticsConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketAnalyticsConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutBucketAnalyticsConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_462 = &_input.bucket;
            let input_462 =
                input_462
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_462, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::PutBucketAnalyticsConfigurationInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_463) = &_input.expected_bucket_owner {
                let formatted_464 = AsRef::<str>::as_ref(inner_463);
                if !formatted_464.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_464;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::PutBucketAnalyticsConfigurationInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("analytics");
            if let Some(inner_465) = &_input.id {
                query.push_kv("id", &aws_smithy_http::query::fmt_string(&inner_465));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutBucketAnalyticsConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutBucketAnalyticsConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::ser_payload_put_bucket_analytics_configuration_input(
            &self.analytics_configuration,
        )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketAnalyticsConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketAnalyticsConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutBucketAnalyticsConfigurationInput`](crate::input::PutBucketAnalyticsConfigurationInput)
    pub fn builder() -> crate::input::put_bucket_analytics_configuration_input::Builder {
        crate::input::put_bucket_analytics_configuration_input::Builder::default()
    }
}

/// See [`PutBucketCorsInput`](crate::input::PutBucketCorsInput)
pub mod put_bucket_cors_input {
    /// A builder for [`PutBucketCorsInput`](crate::input::PutBucketCorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) cors_configuration: std::option::Option<crate::model::CorsConfiguration>,
        pub(crate) content_md5: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the bucket impacted by the <code>cors</code>configuration.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>Specifies the bucket impacted by the <code>cors</code>configuration.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Describes the cross-origin access configuration for objects in an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">Enabling Cross-Origin Resource Sharing</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn cors_configuration(mut self, input: crate::model::CorsConfiguration) -> Self {
            self.cors_configuration = Some(input);
            self
        }
        /// <p>Describes the cross-origin access configuration for objects in an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">Enabling Cross-Origin Resource Sharing</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_cors_configuration(
            mut self,
            input: std::option::Option<crate::model::CorsConfiguration>,
        ) -> Self {
            self.cors_configuration = input;
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity check to verify that the request body was not corrupted in transit. For more information, go to <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.</a> </p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_md5 = Some(input.into());
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity check to verify that the request body was not corrupted in transit. For more information, go to <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.</a> </p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_md5 = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketCorsInput`](crate::input::PutBucketCorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketCorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBucketCorsInput {
                bucket: self.bucket,
                cors_configuration: self.cors_configuration,
                content_md5: self.content_md5,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBucketCorsInputOperationOutputAlias = crate::operation::PutBucketCors;
#[doc(hidden)]
pub type PutBucketCorsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketCorsInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketCors`](crate::operation::PutBucketCors)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketCors,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutBucketCorsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_466 = &_input.bucket;
            let input_466 =
                input_466
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_466, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::PutBucketCorsInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_467) = &_input.content_md5 {
                let formatted_468 = AsRef::<str>::as_ref(inner_467);
                if !formatted_468.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_468;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "content_md5",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Content-MD5", header_value);
                }
            }
            if let Some(inner_469) = &_input.expected_bucket_owner {
                let formatted_470 = AsRef::<str>::as_ref(inner_469);
                if !formatted_470.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_470;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::PutBucketCorsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("cors");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutBucketCorsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutBucketCorsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::ser_payload_put_bucket_cors_input(&self.cors_configuration)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketCors::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketCors",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutBucketCorsInput`](crate::input::PutBucketCorsInput)
    pub fn builder() -> crate::input::put_bucket_cors_input::Builder {
        crate::input::put_bucket_cors_input::Builder::default()
    }
}

/// See [`PutBucketEncryptionInput`](crate::input::PutBucketEncryptionInput)
pub mod put_bucket_encryption_input {
    /// A builder for [`PutBucketEncryptionInput`](crate::input::PutBucketEncryptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) content_md5: std::option::Option<std::string::String>,
        pub(crate) server_side_encryption_configuration:
            std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies default encryption for a bucket using server-side encryption with Amazon S3-managed keys (SSE-S3) or customer managed keys (SSE-KMS). For information about the Amazon S3 default encryption feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">Amazon S3 Default Bucket Encryption</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>Specifies default encryption for a bucket using server-side encryption with Amazon S3-managed keys (SSE-S3) or customer managed keys (SSE-KMS). For information about the Amazon S3 default encryption feature, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html">Amazon S3 Default Bucket Encryption</a> in the <i>Amazon S3 User Guide</i>.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the server-side encryption configuration.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_md5 = Some(input.into());
            self
        }
        /// <p>The base64-encoded 128-bit MD5 digest of the server-side encryption configuration.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_md5 = input;
            self
        }
        /// <p>Specifies the default server-side-encryption configuration.</p>
        pub fn server_side_encryption_configuration(
            mut self,
            input: crate::model::ServerSideEncryptionConfiguration,
        ) -> Self {
            self.server_side_encryption_configuration = Some(input);
            self
        }
        /// <p>Specifies the default server-side-encryption configuration.</p>
        pub fn set_server_side_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryptionConfiguration>,
        ) -> Self {
            self.server_side_encryption_configuration = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketEncryptionInput`](crate::input::PutBucketEncryptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketEncryptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBucketEncryptionInput {
                bucket: self.bucket,
                content_md5: self.content_md5,
                server_side_encryption_configuration: self.server_side_encryption_configuration,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBucketEncryptionInputOperationOutputAlias = crate::operation::PutBucketEncryption;
#[doc(hidden)]
pub type PutBucketEncryptionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketEncryptionInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketEncryption`](crate::operation::PutBucketEncryption)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketEncryption,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutBucketEncryptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_471 = &_input.bucket;
            let input_471 =
                input_471
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_471, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::PutBucketEncryptionInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_472) = &_input.content_md5 {
                let formatted_473 = AsRef::<str>::as_ref(inner_472);
                if !formatted_473.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_473;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "content_md5",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Content-MD5", header_value);
                }
            }
            if let Some(inner_474) = &_input.expected_bucket_owner {
                let formatted_475 = AsRef::<str>::as_ref(inner_474);
                if !formatted_475.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_475;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::PutBucketEncryptionInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("encryption");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutBucketEncryptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutBucketEncryptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::ser_payload_put_bucket_encryption_input(
            &self.server_side_encryption_configuration,
        )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketEncryption::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketEncryption",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutBucketEncryptionInput`](crate::input::PutBucketEncryptionInput)
    pub fn builder() -> crate::input::put_bucket_encryption_input::Builder {
        crate::input::put_bucket_encryption_input::Builder::default()
    }
}

/// See [`PutBucketIntelligentTieringConfigurationInput`](crate::input::PutBucketIntelligentTieringConfigurationInput)
pub mod put_bucket_intelligent_tiering_configuration_input {
    /// A builder for [`PutBucketIntelligentTieringConfigurationInput`](crate::input::PutBucketIntelligentTieringConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) intelligent_tiering_configuration:
            std::option::Option<crate::model::IntelligentTieringConfiguration>,
    }
    impl Builder {
        /// <p>The name of the Amazon S3 bucket whose configuration you want to modify or retrieve.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket whose configuration you want to modify or retrieve.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Container for S3 Intelligent-Tiering configuration.</p>
        pub fn intelligent_tiering_configuration(
            mut self,
            input: crate::model::IntelligentTieringConfiguration,
        ) -> Self {
            self.intelligent_tiering_configuration = Some(input);
            self
        }
        /// <p>Container for S3 Intelligent-Tiering configuration.</p>
        pub fn set_intelligent_tiering_configuration(
            mut self,
            input: std::option::Option<crate::model::IntelligentTieringConfiguration>,
        ) -> Self {
            self.intelligent_tiering_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketIntelligentTieringConfigurationInput`](crate::input::PutBucketIntelligentTieringConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketIntelligentTieringConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::PutBucketIntelligentTieringConfigurationInput {
                    bucket: self.bucket,
                    id: self.id,
                    intelligent_tiering_configuration: self.intelligent_tiering_configuration,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type PutBucketIntelligentTieringConfigurationInputOperationOutputAlias =
    crate::operation::PutBucketIntelligentTieringConfiguration;
#[doc(hidden)]
pub type PutBucketIntelligentTieringConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketIntelligentTieringConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketIntelligentTieringConfiguration`](crate::operation::PutBucketIntelligentTieringConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketIntelligentTieringConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutBucketIntelligentTieringConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_476 = &_input.bucket;
            let input_476 =
                input_476
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_476, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::PutBucketIntelligentTieringConfigurationInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("intelligent-tiering");
            if let Some(inner_477) = &_input.id {
                query.push_kv("id", &aws_smithy_http::query::fmt_string(&inner_477));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutBucketIntelligentTieringConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutBucketIntelligentTieringConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::ser_payload_put_bucket_intelligent_tiering_configuration_input(
                &self.intelligent_tiering_configuration,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketIntelligentTieringConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketIntelligentTieringConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutBucketIntelligentTieringConfigurationInput`](crate::input::PutBucketIntelligentTieringConfigurationInput)
    pub fn builder() -> crate::input::put_bucket_intelligent_tiering_configuration_input::Builder {
        crate::input::put_bucket_intelligent_tiering_configuration_input::Builder::default()
    }
}

/// See [`PutBucketInventoryConfigurationInput`](crate::input::PutBucketInventoryConfigurationInput)
pub mod put_bucket_inventory_configuration_input {
    /// A builder for [`PutBucketInventoryConfigurationInput`](crate::input::PutBucketInventoryConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) inventory_configuration:
            std::option::Option<crate::model::InventoryConfiguration>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket where the inventory configuration will be stored.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket where the inventory configuration will be stored.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The ID used to identify the inventory configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID used to identify the inventory configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Specifies the inventory configuration.</p>
        pub fn inventory_configuration(
            mut self,
            input: crate::model::InventoryConfiguration,
        ) -> Self {
            self.inventory_configuration = Some(input);
            self
        }
        /// <p>Specifies the inventory configuration.</p>
        pub fn set_inventory_configuration(
            mut self,
            input: std::option::Option<crate::model::InventoryConfiguration>,
        ) -> Self {
            self.inventory_configuration = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketInventoryConfigurationInput`](crate::input::PutBucketInventoryConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketInventoryConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBucketInventoryConfigurationInput {
                bucket: self.bucket,
                id: self.id,
                inventory_configuration: self.inventory_configuration,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBucketInventoryConfigurationInputOperationOutputAlias =
    crate::operation::PutBucketInventoryConfiguration;
#[doc(hidden)]
pub type PutBucketInventoryConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketInventoryConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketInventoryConfiguration`](crate::operation::PutBucketInventoryConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketInventoryConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutBucketInventoryConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_478 = &_input.bucket;
            let input_478 =
                input_478
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_478, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::PutBucketInventoryConfigurationInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_479) = &_input.expected_bucket_owner {
                let formatted_480 = AsRef::<str>::as_ref(inner_479);
                if !formatted_480.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_480;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::PutBucketInventoryConfigurationInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("inventory");
            if let Some(inner_481) = &_input.id {
                query.push_kv("id", &aws_smithy_http::query::fmt_string(&inner_481));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutBucketInventoryConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutBucketInventoryConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::ser_payload_put_bucket_inventory_configuration_input(
            &self.inventory_configuration,
        )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketInventoryConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketInventoryConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutBucketInventoryConfigurationInput`](crate::input::PutBucketInventoryConfigurationInput)
    pub fn builder() -> crate::input::put_bucket_inventory_configuration_input::Builder {
        crate::input::put_bucket_inventory_configuration_input::Builder::default()
    }
}

/// See [`PutBucketLifecycleConfigurationInput`](crate::input::PutBucketLifecycleConfigurationInput)
pub mod put_bucket_lifecycle_configuration_input {
    /// A builder for [`PutBucketLifecycleConfigurationInput`](crate::input::PutBucketLifecycleConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) lifecycle_configuration:
            std::option::Option<crate::model::BucketLifecycleConfiguration>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket for which to set the configuration.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket for which to set the configuration.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Container for lifecycle rules. You can add as many as 1,000 rules.</p>
        pub fn lifecycle_configuration(
            mut self,
            input: crate::model::BucketLifecycleConfiguration,
        ) -> Self {
            self.lifecycle_configuration = Some(input);
            self
        }
        /// <p>Container for lifecycle rules. You can add as many as 1,000 rules.</p>
        pub fn set_lifecycle_configuration(
            mut self,
            input: std::option::Option<crate::model::BucketLifecycleConfiguration>,
        ) -> Self {
            self.lifecycle_configuration = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketLifecycleConfigurationInput`](crate::input::PutBucketLifecycleConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketLifecycleConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBucketLifecycleConfigurationInput {
                bucket: self.bucket,
                lifecycle_configuration: self.lifecycle_configuration,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBucketLifecycleConfigurationInputOperationOutputAlias =
    crate::operation::PutBucketLifecycleConfiguration;
#[doc(hidden)]
pub type PutBucketLifecycleConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketLifecycleConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketLifecycleConfiguration`](crate::operation::PutBucketLifecycleConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketLifecycleConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutBucketLifecycleConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_482 = &_input.bucket;
            let input_482 =
                input_482
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_482, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::PutBucketLifecycleConfigurationInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_483) = &_input.expected_bucket_owner {
                let formatted_484 = AsRef::<str>::as_ref(inner_483);
                if !formatted_484.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_484;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::PutBucketLifecycleConfigurationInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("lifecycle");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutBucketLifecycleConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutBucketLifecycleConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::ser_payload_put_bucket_lifecycle_configuration_input(
            &self.lifecycle_configuration,
        )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketLifecycleConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketLifecycleConfiguration",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutBucketLifecycleConfigurationInput`](crate::input::PutBucketLifecycleConfigurationInput)
    pub fn builder() -> crate::input::put_bucket_lifecycle_configuration_input::Builder {
        crate::input::put_bucket_lifecycle_configuration_input::Builder::default()
    }
}

/// See [`PutBucketLoggingInput`](crate::input::PutBucketLoggingInput)
pub mod put_bucket_logging_input {
    /// A builder for [`PutBucketLoggingInput`](crate::input::PutBucketLoggingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) bucket_logging_status: std::option::Option<crate::model::BucketLoggingStatus>,
        pub(crate) content_md5: std::option::Option<std::string::String>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket for which to set the logging parameters.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket for which to set the logging parameters.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Container for logging status information.</p>
        pub fn bucket_logging_status(mut self, input: crate::model::BucketLoggingStatus) -> Self {
            self.bucket_logging_status = Some(input);
            self
        }
        /// <p>Container for logging status information.</p>
        pub fn set_bucket_logging_status(
            mut self,
            input: std::option::Option<crate::model::BucketLoggingStatus>,
        ) -> Self {
            self.bucket_logging_status = input;
            self
        }
        /// <p>The MD5 hash of the <code>PutBucketLogging</code> request body.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn content_md5(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_md5 = Some(input.into());
            self
        }
        /// <p>The MD5 hash of the <code>PutBucketLogging</code> request body.</p>
        /// <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p>
        pub fn set_content_md5(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_md5 = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketLoggingInput`](crate::input::PutBucketLoggingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketLoggingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBucketLoggingInput {
                bucket: self.bucket,
                bucket_logging_status: self.bucket_logging_status,
                content_md5: self.content_md5,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBucketLoggingInputOperationOutputAlias = crate::operation::PutBucketLogging;
#[doc(hidden)]
pub type PutBucketLoggingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketLoggingInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketLogging`](crate::operation::PutBucketLogging)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketLogging,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutBucketLoggingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_485 = &_input.bucket;
            let input_485 =
                input_485
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_485, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::PutBucketLoggingInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_486) = &_input.content_md5 {
                let formatted_487 = AsRef::<str>::as_ref(inner_486);
                if !formatted_487.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_487;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "content_md5",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Content-MD5", header_value);
                }
            }
            if let Some(inner_488) = &_input.expected_bucket_owner {
                let formatted_489 = AsRef::<str>::as_ref(inner_488);
                if !formatted_489.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_489;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::PutBucketLoggingInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("logging");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutBucketLoggingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutBucketLoggingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::ser_payload_put_bucket_logging_input(
            &self.bucket_logging_status,
        )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request = request.augment(|mut req, _| {
            let data = req
                .body()
                .bytes()
                .expect("checksum can only be computed for non-streaming operations");
            let checksum = md5::compute(data);
            req.headers_mut().insert(
                http::header::HeaderName::from_static("content-md5"),
                aws_smithy_types::base64::encode(&checksum[..])
                    .parse()
                    .expect("checksum is valid header value"),
            );
            Result::<_, aws_smithy_http::operation::BuildError>::Ok(req)
        })?;
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        signing_config.signing_options.double_uri_encode = false;
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBucketLogging::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBucketLogging",
            "s3",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutBucketLoggingInput`](crate::input::PutBucketLoggingInput)
    pub fn builder() -> crate::input::put_bucket_logging_input::Builder {
        crate::input::put_bucket_logging_input::Builder::default()
    }
}

/// See [`PutBucketMetricsConfigurationInput`](crate::input::PutBucketMetricsConfigurationInput)
pub mod put_bucket_metrics_configuration_input {
    /// A builder for [`PutBucketMetricsConfigurationInput`](crate::input::PutBucketMetricsConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) metrics_configuration: std::option::Option<crate::model::MetricsConfiguration>,
        pub(crate) expected_bucket_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket for which the metrics configuration is set.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>The name of the bucket for which the metrics configuration is set.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The ID used to identify the metrics configuration.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID used to identify the metrics configuration.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Specifies the metrics configuration.</p>
        pub fn metrics_configuration(mut self, input: crate::model::MetricsConfiguration) -> Self {
            self.metrics_configuration = Some(input);
            self
        }
        /// <p>Specifies the metrics configuration.</p>
        pub fn set_metrics_configuration(
            mut self,
            input: std::option::Option<crate::model::MetricsConfiguration>,
        ) -> Self {
            self.metrics_configuration = input;
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn expected_bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_bucket_owner = Some(input.into());
            self
        }
        /// <p>The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP <code>403 (Access Denied)</code> error.</p>
        pub fn set_expected_bucket_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_bucket_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBucketMetricsConfigurationInput`](crate::input::PutBucketMetricsConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBucketMetricsConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBucketMetricsConfigurationInput {
                bucket: self.bucket,
                id: self.id,
                metrics_configuration: self.metrics_configuration,
                expected_bucket_owner: self.expected_bucket_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBucketMetricsConfigurationInputOperationOutputAlias =
    crate::operation::PutBucketMetricsConfiguration;
#[doc(hidden)]
pub type PutBucketMetricsConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutBucketMetricsConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutBucketMetricsConfiguration`](crate::operation::PutBucketMetricsConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBucketMetricsConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutBucketMetricsConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_490 = &_input.bucket;
            let input_490 =
                input_490
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bucket",
                        details: "cannot be empty or unset",
                    })?;
            let bucket = aws_smithy_http::label::fmt_string(input_490, false);
            if bucket.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bucket",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/{Bucket}", Bucket = bucket).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::PutBucketMetricsConfigurationInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_491) = &_input.expected_bucket_owner {
                let formatted_492 = AsRef::<str>::as_ref(inner_491);
                if !formatted_492.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_492;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "expected_bucket_owner",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("x-amz-expected-bucket-owner", header_value);
                }
            }
            Ok(builder)
        }
        fn uri_query(
            _input: &crate::input::PutBucketMetricsConfigurationInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_v("metrics");
            if let Some(inner_493) = &_input.id {
                query.push_kv("id", &aws_smithy_http::query::fmt_string(&inner_493));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutBucketMetricsConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutBucketMetricsConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/xml",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::ser_payload_put_bucket_metrics_configuration_input(
            &self.metrics_configuration,
        )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_fr